#![allow(non_camel_case_types, non_upper_case_globals)]

use crate::co::{ACCESS_RIGHTS, SECTION, STANDARD_RIGHTS, WM};

const_ordinary! { EC: u16;
	/// [`em::GetImeStatus`](crate::msg::em::SetMargins) margins to set (`u16`).
	=>
	=>
	LEFTMARGIN 0x0001
	RIGHTMARGIN 0x0002
	USEFONTINFO 0xffff
}

const_ordinary! { EDS: u32;
	/// [`EnumDisplaySettingsEx`](crate::EnumDisplaySettingsEx) `flags` (`u32`).
	=>
	=>
	RAWMODE 0x0000_0002
	ROTATEDMODE 0x0000_0004
}

const_ordinary! { EIMES: u16;
	/// [`em::GetImeStatus`](crate::msg::em::GetImeStatus) and
	/// [`em::SetImeStatus`](crate::msg::em::SetImeStatus) status (`u16`).
	=>
	=>
	GETCOMPSTRATONCE 0x0001
	CANCELCOMPSTRINFOCUS 0x0002
	COMPLETECOMPSTRKILLFOCUS 0x0004
}

const_wm! { EM;
	/// Edit control
	/// [messages](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-edit-control-reference-messages)
	/// (`u32`).
	=>
	FIRST 0x1500
	=>
	SETCUEBANNER Self::FIRST.0 + 1
	GETCUEBANNER Self::FIRST.0 + 2
	SHOWBALLOONTIP Self::FIRST.0 + 3
	HIDEBALLOONTIP Self::FIRST.0 + 4
	SETHILITE Self::FIRST.0 + 5
	GETHILITE Self::FIRST.0 + 6
	NOSETFOCUS Self::FIRST.0 + 7
	TAKEFOCUS Self::FIRST.0 + 8
	SETEXTENDEDSTYLE Self::FIRST.0 + 10
	GETEXTENDEDSTYLE Self::FIRST.0 + 11
	SETENDOFLINE Self::FIRST.0 + 12
	GETENDOFLINE Self::FIRST.0 + 13
	ENABLESEARCHWEB Self::FIRST.0 + 14
	SEARCHWEB Self::FIRST.0 + 15
	SETCARETINDEX Self::FIRST.0 + 17
	GETCARETINDEX Self::FIRST.0 + 18
	GETZOOM WM::USER.0 + 224
	SETZOOM WM::USER.0 + 225
	FILELINEFROMCHAR Self::FIRST.0 + 19
	FILELINEINDEX Self::FIRST.0 + 20
	FILELINELENGTH Self::FIRST.0 + 21
	GETFILELINE Self::FIRST.0 + 22
	GETFILELINECOUNT Self::FIRST.0 + 23

	GETSEL 0x00b0
	SETSEL 0x00b1
	GETRECT 0x00b2
	SETRECT 0x00b3
	SETRECTNP 0x00b4
	SCROLL 0x00b5
	LINESCROLL 0x00b6
	SCROLLCARET 0x00b7
	GETMODIFY 0x00b8
	SETMODIFY 0x00b9
	GETLINECOUNT 0x00ba
	LINEINDEX 0x00bb
	SETHANDLE 0x00bc
	GETHANDLE 0x00bd
	GETTHUMB 0x00be
	LINELENGTH 0x00c1
	REPLACESEL 0x00c2
	GETLINE 0x00c4
	LIMITTEXT 0x00c5
	CANUNDO 0x00c6
	UNDO 0x00c7
	FMTLINES 0x00c8
	LINEFROMCHAR 0x00c9
	SETTABSTOPS 0x00cb
	SETPASSWORDCHAR 0x00cc
	EMPTYUNDOBUFFER 0x00cd
	GETFIRSTVISIBLELINE 0x00ce
	SETREADONLY 0x00cf
	SETWORDBREAKPROC 0x00d0
	GETWORDBREAKPROC 0x00d1
	GETPASSWORDCHAR 0x00d2
	SETMARGINS 0x00d3
	GETMARGINS 0x00d4
	SETLIMITTEXT Self::LIMITTEXT.0
	GETLIMITTEXT 0x00d5
	POSFROMCHAR 0x00d6
	CHARFROMPOS 0x00d7
	SETIMESTATUS 0x00d8
	GETIMESTATUS 0x00d9
	ENABLEFEATURE 0x00da
}

const_ordinary! { EMF: u32;
	/// [`NMLVEMPTYMARKUP`](crate::NMLVEMPTYMARKUP) `dwFlags` (`u32`).
	=>
	=>
	LEFT 0x0000_0000
	CENTERED 0x0000_0001
}

const_cmd! { EN;
	/// Edit control `WM_COMMAND`
	/// [notifications](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-edit-control-reference-notifications)
	/// (`u16`).
	=>
	=>
	SETFOCUS 0x0100
	KILLFOCUS 0x0200
	CHANGE 0x0300
	UPDATE 0x0400
	ERRSPACE 0x0500
	MAXTEXT 0x0501
	HSCROLL 0x0601
	VSCROLL 0x0602
	ALIGN_LTR_EC 0x0700
	ALIGN_RTL_EC 0x0701
	BEFORE_PASTE 0x0800
	AFTER_PASTE 0x0801
}

const_ordinary! { ENDSESSION: u32;
	/// [`wm::EndSession`](crate::msg::wm::EndSession) event (`u32`).
	=>
	=>
	RESTARTORSHUTDOWN 0
	CLOSEAPP 0x0000_0001
	CRITICAL 0x4000_0000
	LOGOFF 0x8000_0000
}

const_ordinary! { ENUM_SETTINGS: u32;
	/// [`EnumDisplaySettingsEx`](crate::EnumDisplaySettingsEx) `mode_num`
	/// (`u32`).
	///
	/// Originally with `ENUM` prefix and `SETTINGS` suffix.
	=>
	=>
	CURRENT (0 - 1) as u32
	REGISTRY (0 - 2) as u32
}

const_ws! { ES: u32;
	/// Edit control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/edit-control-styles)
	/// (`u32`).
	=>
	=>
	LEFT 0x0000
	CENTER 0x0001
	RIGHT 0x0002
	MULTILINE 0x0004
	UPPERCASE 0x0008
	LOWERCASE 0x0010
	PASSWORD 0x0020
	AUTOVSCROLL 0x0040
	AUTOHSCROLL 0x0080
	NOHIDESEL 0x0100
	OEMCONVERT 0x0400
	READONLY 0x0800
	WANTRETURN 0x1000
	NUMBER 0x2000
}

const_ordinary! { FACILITY: u32;
	/// [`HRESULT`](crate::co::HRESULT) facility (`u32`).
	=>
	=>
	NULL 0
	RPC 1
	DISPATCH 2
	STORAGE 3
	ITF 4
	WIN32 7
	WINDOWS 8
	SSPI 9
	SECURITY 9
	CONTROL 10
	CERT 11
	INTERNET 12
	MEDIASERVER 13
	MSMQ 14
	SETUPAPI 15
	SCARD 16
	COMPLUS 17
	AAF 18
	URT 19
	ACS 20
	DPLAY 21
	UMI 22
	SXS 23
	WINDOWS_CE 24
	HTTP 25
	USERMODE_COMMONLOG 26
	WER 27
	USERMODE_FILTER_MANAGER 31
	BACKGROUNDCOPY 32
	CONFIGURATION 33
	WIA 33
	STATE_MANAGEMENT 34
	METADIRECTORY 35
	WINDOWSUPDATE 36
	DIRECTORYSERVICE 37
	GRAPHICS 38
	SHELL 39
	NAP 39
	TPM_SERVICES 40
	TPM_SOFTWARE 41
	UI 42
	XAML 43
	ACTION_QUEUE 44
	PLA 48
	WINDOWS_SETUP 48
	FVE 49
	FWP 50
	WINRM 51
	NDIS 52
	USERMODE_HYPERVISOR 53
	CMI 54
	USERMODE_VIRTUALIZATION 55
	USERMODE_VOLMGR 56
	BCD 57
	USERMODE_VHD 58
	USERMODE_HNS 59
	SDIAG 60
	WEBSERVICES 61
	WINPE 61
	WPN 62
	WINDOWS_STORE 63
	INPUT 64
	EAP 66
	WINDOWS_DEFENDER 80
	OPC 81
	XPS 82
	MBN 84
	POWERSHELL 84
	RAS 83
	P2P_INT 98
	P2P 99
	DAF 100
	BLUETOOTH_ATT 101
	AUDIO 102
	STATEREPOSITORY 103
	VISUALCPP 109
	SCRIPT 112
	PARSE 113
	BLB 120
	BLB_CLI 121
	WSBAPP 122
	BLBUI 128
	USN 129
	USERMODE_VOLSNAP 130
	TIERING 131
	WSB_ONLINE 133
	ONLINE_ID 134
	DEVICE_UPDATE_AGENT 135
	DRVSERVICING 136
	DLS 153
	DELIVERY_OPTIMIZATION 208
	USERMODE_SPACES 231
	USER_MODE_SECURITY_CORE 232
	USERMODE_LICENSING 234
	SOS 160
	DEBUGGERS 176
	SPP 256
	RESTORE 256
	DMSERVER 256
	DEPLOYMENT_SERVICES_SERVER 257
	DEPLOYMENT_SERVICES_IMAGING 258
	DEPLOYMENT_SERVICES_MANAGEMENT 259
	DEPLOYMENT_SERVICES_UTIL 260
	DEPLOYMENT_SERVICES_BINLSVC 261
	DEPLOYMENT_SERVICES_PXE 263
	DEPLOYMENT_SERVICES_TFTP 264
	DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT 272
	DEPLOYMENT_SERVICES_DRIVER_PROVISIONING 278
	DEPLOYMENT_SERVICES_MULTICAST_SERVER 289
	DEPLOYMENT_SERVICES_MULTICAST_CLIENT 290
	DEPLOYMENT_SERVICES_CONTENT_PROVIDER 293
	LINGUISTIC_SERVICES 305
	AUDIOSTREAMING 1094
	ACCELERATOR 1536
	WMAAECMA 1996
	DIRECTMUSIC 2168
	DIRECT3D10 2169
	DXGI 2170
	DXGI_DDI 2171
	DIRECT3D11 2172
	DIRECT3D11_DEBUG 2173
	DIRECT3D12 2174
	DIRECT3D12_DEBUG 2175
	LEAP 2184
	AUDCLNT 2185
	WINCODEC_DWRITE_DWM 2200
	WINML 2192
	DIRECT2D 2201
	DEFRAG 2304
	USERMODE_SDBUS 2305
	JSCRIPT 2306
	PIDGENX 2561
	EAS 85
	WEB 885
	WEB_SOCKET 886
	MOBILE 1793
	SQLITE 1967
	UTC 1989
	WEP 2049
	SYNCENGINE 2050
	XBOX 2339
	GAME 2340
	PIX 2748
}

const_ordinary! { FAPPCOMMAND: u16;
	/// [`wm::AppCommand`](crate::msg::wm::AppCommand) input event (`u16`).
	=>
	=>
	MOUSE 0x8000
	KEY 0
	OEM 0x1000
}

const_ordinary! { FF: u8;
	/// [`LOGFONT`](crate::LOGFONT) `lfPitchAndFamily` (`u8`) used with
	/// [`PITCH`](crate::co::PITCH).
	=>
	=>
	DONTCARE 0 << 4
	ROMAN 1 << 4
	SWISS 2 << 4
	MODERN 3 << 4
	SCRIPT 4 << 4
	DECORATIVE 5 << 4
}

const_ordinary! { FILE_ATTRIBUTE: u32;
	/// File attribute
	/// [flags](https://docs.microsoft.com/en-us/windows/win32/fileio/file-attribute-constants),
	/// also other flags from [`HFILE::CreateFile`](crate::HFILE::CreateFile)
	/// `flags_and_attrs` (`u32`).
	=>
	=>
	READONLY 0x0000_0001
	HIDDEN 0x0000_0002
	SYSTEM 0x0000_0004
	DIRECTORY 0x0000_0010
	ARCHIVE 0x0000_0020
	DEVICE 0x0000_0040
	NORMAL 0x0000_0080
	TEMPORARY 0x0000_0100
	SPARSE_FILE 0x0000_0200
	REPARSE_POINT 0x0000_0400
	COMPRESSED 0x0000_0800
	OFFLINE 0x000_01000
	NOT_CONTENT_INDEXED 0x0000_2000
	ENCRYPTED 0x0000_4000
	INTEGRITY_STREAM 0x0000_8000
	VIRTUAL 0x0001_0000
	NO_SCRUB_DATA 0x0002_0000
	EA 0x0004_0000
	PINNED 0x0008_0000
	UNPINNED 0x0010_0000
	RECALL_ON_OPEN 0x0004_0000
	RECALL_ON_DATA_ACCESS 0x0040_0000

	FLAG_WRITE_THROUGH 0x8000_0000
	FLAG_OVERLAPPED 0x4000_0000
	FLAG_NO_BUFFERING 0x2000_0000
	FLAG_RANDOM_ACCESS 0x1000_0000
	FLAG_SEQUENTIAL_SCAN 0x0800_0000
	FLAG_DELETE_ON_CLOSE 0x0400_0000
	FLAG_BACKUP_SEMANTICS 0x0200_0000
	FLAG_POSIX_SEMANTICS 0x0100_0000
	FLAG_SESSION_AWARE 0x0080_0000
	FLAG_OPEN_REPARSE_POINT 0x0020_0000
	FLAG_OPEN_NO_RECALL 0x0010_0000
	FLAG_FIRST_PIPE_INSTANCE 0x0008_0000

	SECURITY_ANONYMOUS 0 << 16
	SECURITY_IDENTIFICATION 1 << 16
	SECURITY_IMPERSONATION 2 << 16
	SECURITY_DELEGATION 3 << 16
	SECURITY_CONTEXT_TRACKING 0x0004_0000
	SECURITY_EFFECTIVE_ONLY 0x0008_0000
}

const_ordinary! { FILE_MAP: u32;
	/// [`HFILEMAP::MapViewOfFile`](crate::HFILEMAP::MapViewOfFile)
	/// `desired_access` (`u32`).
	=>
	=>
	ALL_ACCESS SECTION::ALL_ACCESS.0
	READ SECTION::MAP_READ.0
	WRITE SECTION::MAP_WRITE.0

	COPY 0x0000_0001
	EXECUTE SECTION::MAP_EXECUTE_EXPLICIT.0
	LARGE_PAGES 0x2000_0000
	TARGETS_INVALID 0x4000_0000
}

const_ordinary! { FILE_RIGHT: u32;
	/// File access rights
	/// [flags](https://docs.microsoft.com/en-us/windows/win32/fileio/file-access-rights-constants)
	/// (`u32`). Originally has `FILE` prefix.
	=>
	=>
	ADD_FILE 0x0002
	ADD_SUBDIRECTORY 0x0004
	ALL_ACCESS STANDARD_RIGHTS::REQUIRED.0 | ACCESS_RIGHTS::SYNCHRONIZE.0 | 0x1ff
	APPEND_DATA 0x0004
	CREATE_PIPE_INSTANCE 0x0004
	DELETE_CHILD 0x0040
	EXECUTE 0x0020
	LIST_DIRECTORY 0x0001
	READ_ATTRIBUTES 0x0080
	READ_DATA 0x0001
	READ_EA 0x0008
	TRAVERSE 0x0020
	WRITE_ATTRIBUTES 0x0100
	WRITE_DATA 0x0002
}

const_ordinary! { FILE_SHARE: u32;
	/// [`HFILE::CreateFile`](crate::HFILE::CreateFile) `share_mode` (`u32`).
	=>
	=>
	/// None of the actual values (zero).
	NoValue 0
	READ 0x0000_0001
	WRITE 0x0000_0002
	DELETE 0x0000_0004
}

const_ordinary! { FILE_STARTING_POINT: u32;
	/// [`HFILE::SetFilePointerEx`](crate::HFILE::SetFilePointerEx)
	/// `move_method` (`u32`).
	///
	/// Originally has `FILE` prefix.
	=>
	=>
	/// The starting point is zero or the beginning of the file. If this flag is
	/// specified then the `liDistanceToMove` parameter is interpreted as an
	/// unsigned value.
	BEGIN 0
	/// The start point is the current value of the file pointer.
	CURRENT 1
	/// The starting point is the current end-of-file position.
	END 2
}

const_ordinary! { FILE_TYPE: u32;
	/// [`HFILE::GetFileType`](crate::HFILE::GetFileType) return value (`u32`).
	=>
	=>
	/// The specified file is a character file typically an LPT device or a
	/// console.
	CHAR 0x0002
	/// The specified file is a disk file.
	DISK 0x0001
	/// The specified file is a socket a named pipe or an anonymous pipe.
	PIPE 0x0003
	/// Unused.
	REMOTE 0x8000
	/// Either the type of the specified file is unknown or the function
	/// failed.
	UNKNOWN 0x0000
}

const_ordinary! { FIRMWARE_TYPE: u32;
	/// [`FIRMWARE_TYPE`](https://docs.microsoft.com/en-us/windows/win32/api/winnt/ne-winnt-firmware_type)
	/// enumeration (`u32`).
	=>
	=>
	Unknown 0
	Bios 1
	Uefi 2
}

const_ordinary! { FO: u32;
	/// [`SHFILEOPSTRUCT`](crate::SHFILEOPSTRUCT) `wFunc` (`u32`).
	=>
	=>
	MOVE 0x0001
	COPY 0x0002
	DELETE 0x0003
	RENAME 0x0004
}

const_ordinary! { FOF: u16;
	/// [`SHFILEOPSTRUCT`](crate::SHFILEOPSTRUCT) `fFlags` (`u16`).
	=>
	=>
	MULTIDESTFILES 0x0001
	CONFIRMMOUSE 0x0002
	SILENT 0x0004
	RENAMEONCOLLISION 0x0008
	NOCONFIRMATION 0x0010
	WANTMAPPINGHANDLE 0x0020
	ALLOWUNDO 0x0040
	FILESONLY 0x0080
	SIMPLEPROGRESS 0x0100
	NOCONFIRMMKDIR 0x0200
	NOERRORUI 0x0400
	NOCOPYSECURITYATTRIBS 0x0800
	NORECURSION 0x1000
	NO_CONNECTED_ELEMENTS 0x2000
	WANTNUKEWARNING 0x4000
	NORECURSEREPARSE 0x8000
	NO_UI Self::SILENT.0 | Self::NOCONFIRMATION.0 | Self::NOERRORUI.0 | Self::NOCONFIRMMKDIR.0
}

const_ordinary! { FORMAT_MESSAGE: u32;
	/// [`FormatMessage`](crate::prelude::FormattedError::FormatMessage)
	/// `dwFlags` (`u32`).
	=>
	=>
	ALLOCATE_BUFFER 0x0000_0100
	ARGUMENT_ARRAY 0x0000_2000
	FROM_HMODULE 0x0000_0800
	FROM_STRING 0x0000_0400
	FROM_SYSTEM 0x0000_1000
	IGNORE_INSERTS 0x0000_0200
	MAX_WIDTH_MASK 0x0000_00ff
}

const_ordinary! { FW: u32;
	/// [`HFONT::CreateFont`](crate::HFONT::CreateFont) `weight` and
	/// [`LOGFONT`](crate::LOGFONT) `lfWeight` (`u32`).
	=>
	=>
	DONTCARE 0
	THIN 100
	EXTRALIGHT 200
	ULTRALIGHT Self::EXTRALIGHT.0
	LIGHT 300
	NORMAL 400
	REGULAR 400
	MEDIUM 500
	SEMIBOLD 600
	DEMIBOLD Self::SEMIBOLD.0
	BOLD 700
	EXTRABOLD 800
	ULTRABOLD Self::EXTRABOLD.0
	HEAVY 900
	BLACK Self::HEAVY.0
}
