//! Native Win32 controls.

#[macro_use]
mod macros;

mod base_native_control;
mod button;
mod check_box;
mod combo_box_items;
mod combo_box;
mod date_time_picker;
mod edit;
mod label;
mod list_box_items;
mod list_box;
mod list_view_columns;
mod list_view_items;
mod list_view;
mod month_calendar;
mod progress_bar;
mod radio_button;
mod radio_group;
mod status_bar_parts;
mod status_bar;
mod trackbar;
mod tree_view_items;
mod tree_view;

pub use button::{Button, ButtonOpts};
pub use check_box::{CheckBox, CheckBoxOpts};
pub use combo_box::{ComboBox, ComboBoxOpts};
pub use date_time_picker::{DateTimePicker, DateTimePickerOpts};
pub use edit::{Edit, EditOpts};
pub use label::{Label, LabelOpts};
pub use list_box::{ListBox, ListBoxOpts};
pub use list_view::{ListView, ListViewOpts};
pub use month_calendar::{MonthCalendar, MonthCalendarOpts};
pub use progress_bar::{ProgressBar, ProgressBarOpts};
pub use radio_button::{RadioButton, RadioButtonOpts};
pub use radio_group::RadioGroup;
pub use status_bar::{StatusBar, StatusBarPart};
pub use trackbar::{Trackbar, TrackbarOpts};
pub use tree_view::{TreeView, TreeViewOpts};

/// Structs which expose specialized methods of controls.
pub mod spec {
	pub use super::combo_box_items::ComboBoxItems;
	pub use super::list_box_items::ListBoxItems;
	pub use super::list_view_columns::ListViewColumns;
	pub use super::list_view_items::ListViewItems;
	pub use super::status_bar_parts::StatusBarParts;
	pub use super::tree_view_items::TreeViewItems;
}
