//! [DirectShow](https://docs.microsoft.com/en-us/windows/win32/directshow/directshow)
//! COM assorted GUIDs.

#![allow(non_upper_case_globals)]

use crate::structs::GUID;

pub_const_guid! { GUID,
	FORMAT_DvInfo, 0x05589f84, 0xc356, 0x11ce, 0xbf01, 0x00aa0055595a,
	FORMAT_MPEG2Video, 0xe06d80e3, 0xdb46, 0x11cf, 0xb4d1, 0x00805f6cbbea,
	FORMAT_MPEGStreams, 0x05589f83, 0xc356, 0x11ce, 0xbf01, 0x00aa0055595a,
	FORMAT_MPEGVideo, 0x05589f82, 0xc356, 0x11ce, 0xbf01, 0x00aa0055595a,
	FORMAT_None, 0x0f6417d6, 0xc318, 0x11d0, 0xa43f, 0x00a0c9223196,
	FORMAT_VideoInfo, 0x05589f80, 0xc356, 0x11ce, 0xbf01, 0x00aa0055595a,
	FORMAT_VideoInfo2, 0xf72a76a0, 0xeb0a, 0x11d0, 0xace4, 0x0000c0cc16ba,
	FORMAT_WaveFormatEx, 0x05589f81, 0xc356, 0x11ce, 0xbf01, 0x00aa0055595a,

	MEDIATYPE_AnalogAudio, 0x0482dee1, 0x7817, 0x11cf, 0x8a03, 0x00aa006ecb65,
	MEDIATYPE_AnalogVideo, 0x0482dde1, 0x7817, 0x11cf, 0x8a03, 0x00aa006ecb65,
	MEDIATYPE_Audio, 0x73647561, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_AUXLine21Data, 0x670aea80, 0x3a82, 0x11d0, 0xb79b, 0x00aa003767a7,
	MEDIATYPE_File, 0x656c6966, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_Interleaved, 0x73766169, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_Midi, 0x7364696d, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_MPEG2_PES, 0xe06d8020, 0xdb46, 0x11cf, 0xb4d1, 0x00805f6cbbea,
	MEDIATYPE_MPEG2_SECTIONS, 0x455f176c, 0x4b06, 0x47ce, 0x9aef, 0x8caef73df7b5,
	MEDIATYPE_ScriptCommand, 0x73636d64, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_Stream, 0xe436eb83, 0x524f, 0x11ce, 0x9f53, 0x0020af0ba770,
	MEDIATYPE_Text, 0x73747874, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,
	MEDIATYPE_Timecode, 0x0482dee3, 0x7817, 0x11cf, 0x8a03, 0x00aa006ecb65,
	MEDIATYPE_VBI, 0xf72a76e1, 0xeb0a, 0x11d0, 0xace4, 0x0000c0cc16ba,
	MEDIATYPE_Video, 0x73646976, 0x0000, 0x0010, 0x8000, 0x00aa00389b71,

	MR_VIDEO_RENDER_SERVICE, 0x1092a86c, 0xab1a, 0x459a, 0xa336, 0x831fbc4d11ff,
	MR_VIDEO_MIXER_SERVICE, 0x073cd2fc, 0x6cf4, 0x40b7, 0x8859, 0xe89552c841f8,
	MR_VIDEO_ACCELERATION_SERVICE, 0xefef5175, 0x5c7d, 0x4ce2, 0xbbbd, 0x34ff8bca6554,
	MR_BUFFER_SERVICE, 0xa562248c, 0x9ac6, 0x4ffc, 0x9fba, 0x3af8f8ad1a4d,
	VIDEO_ZOOM_RECT, 0x7aaa1638, 0x1b7f, 0x4c93, 0xbd89, 0x5b9c9fb6fcf0,

	TIME_FORMAT_NONE, 0x00000000, 0x0000, 0x0000, 0x0000, 0x000000000000,
	TIME_FORMAT_FRAME, 0x7b785570, 0x8c82, 0x11cf, 0xbc0c, 0x00aa00ac74f6,
	TIME_FORMAT_BYTE, 0x7b785571, 0x8c82, 0x11cf, 0xbc0c, 0x00aa00ac74f6,
	TIME_FORMAT_SAMPLE, 0x7b785572, 0x8c82, 0x11cf, 0xbc0c, 0x00aa00ac74f6,
	TIME_FORMAT_FIELD, 0x7b785573, 0x8c82, 0x11cf, 0xbc0c, 0x00aa00ac74f6,
	TIME_FORMAT_MEDIA_TIME, 0x7b785574, 0x8c82, 0x11cf, 0xbc0c, 0x00aa00ac74f6,
}
