// WARNING: this file is auto-generated by xtask gen and may be overwritten

use super::*;


/// This drive is locked by BitLocker Drive Encryption. You must unlock this drive from Control Panel.
pub const E_LOCKED_VOLUME : HResultError = HResultError::from_constant(0x80310000); // FVE_E_LOCKED_VOLUME

/// This drive is not encrypted.
pub const E_NOT_ENCRYPTED : HResultError = HResultError::from_constant(0x80310001); // FVE_E_NOT_ENCRYPTED

/// The BIOS did not correctly communicate with the Trusted Platform Module (TPM). Contact the computer manufacturer for BIOS upgrade instructions.
pub const E_NO_TPM_BIOS : HResultError = HResultError::from_constant(0x80310002); // FVE_E_NO_TPM_BIOS

/// The BIOS did not correctly communicate with the master boot record (MBR). Contact the computer manufacturer for BIOS upgrade instructions.
pub const E_NO_MBR_METRIC : HResultError = HResultError::from_constant(0x80310003); // FVE_E_NO_MBR_METRIC

/// A required TPM measurement is missing. If there is a bootable CD or DVD in your computer, remove it, restart the computer, and turn on BitLocker again. If the problem persists, ensure the master boot record is up to date.
pub const E_NO_BOOTSECTOR_METRIC : HResultError = HResultError::from_constant(0x80310004); // FVE_E_NO_BOOTSECTOR_METRIC

/// The boot sector of this drive is not compatible with BitLocker Drive Encryption. Use the Bootrec.exe tool in the Windows Recovery Environment to update or repair the boot manager (BOOTMGR).
pub const E_NO_BOOTMGR_METRIC : HResultError = HResultError::from_constant(0x80310005); // FVE_E_NO_BOOTMGR_METRIC

/// The boot manager of this operating system is not compatible with BitLocker Drive Encryption. Use the Bootrec.exe tool in the Windows Recovery Environment to update or repair the boot manager (BOOTMGR).
pub const E_WRONG_BOOTMGR : HResultError = HResultError::from_constant(0x80310006); // FVE_E_WRONG_BOOTMGR

/// At least one secure key protector is required for this operation to be performed.
pub const E_SECURE_KEY_REQUIRED : HResultError = HResultError::from_constant(0x80310007); // FVE_E_SECURE_KEY_REQUIRED

/// BitLocker Drive Encryption is not enabled on this drive. Turn on BitLocker.
pub const E_NOT_ACTIVATED : HResultError = HResultError::from_constant(0x80310008); // FVE_E_NOT_ACTIVATED

/// BitLocker Drive Encryption cannot perform the requested action. This condition may occur when two requests are issued at the same time. Wait a few moments and then try the action again.
pub const E_ACTION_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310009); // FVE_E_ACTION_NOT_ALLOWED

/// The Active Directory Domain Services forest does not contain the required attributes and classes to host BitLocker Drive Encryption or Trusted Platform Module information. Contact your domain administrator to verify that any required BitLocker Active Directory schema extensions have been installed.
pub const E_AD_SCHEMA_NOT_INSTALLED : HResultError = HResultError::from_constant(0x8031000A); // FVE_E_AD_SCHEMA_NOT_INSTALLED

/// The type of the data obtained from Active Directory was not expected. The BitLocker recovery information may be missing or corrupted.
pub const E_AD_INVALID_DATATYPE : HResultError = HResultError::from_constant(0x8031000B); // FVE_E_AD_INVALID_DATATYPE

/// The size of the data obtained from Active Directory was not expected. The BitLocker recovery information may be missing or corrupted.
pub const E_AD_INVALID_DATASIZE : HResultError = HResultError::from_constant(0x8031000C); // FVE_E_AD_INVALID_DATASIZE

/// The attribute read from Active Directory does not contain any values. The BitLocker recovery information may be missing or corrupted.
pub const E_AD_NO_VALUES : HResultError = HResultError::from_constant(0x8031000D); // FVE_E_AD_NO_VALUES

/// The attribute was not set. Verify that you are logged on with a domain account that has the ability to write information to Active Directory objects.
pub const E_AD_ATTR_NOT_SET : HResultError = HResultError::from_constant(0x8031000E); // FVE_E_AD_ATTR_NOT_SET

/// The specified attribute cannot be found in Active Directory Domain Services. Contact your domain administrator to verify that any required BitLocker Active Directory schema extensions have been installed.
pub const E_AD_GUID_NOT_FOUND : HResultError = HResultError::from_constant(0x8031000F); // FVE_E_AD_GUID_NOT_FOUND

/// The BitLocker metadata for the encrypted drive is not valid. You can attempt to repair the drive to restore access.
pub const E_BAD_INFORMATION : HResultError = HResultError::from_constant(0x80310010); // FVE_E_BAD_INFORMATION

/// The drive cannot be encrypted because it does not have enough free space. Delete any unnecessary data on the drive to create additional free space and then try again.
pub const E_TOO_SMALL : HResultError = HResultError::from_constant(0x80310011); // FVE_E_TOO_SMALL

/// The drive cannot be encrypted because it contains system boot information. Create a separate partition for use as the system drive that contains the boot information and a second partition for use as the operating system drive and then encrypt the operating system drive.
pub const E_SYSTEM_VOLUME : HResultError = HResultError::from_constant(0x80310012); // FVE_E_SYSTEM_VOLUME

/// The drive cannot be encrypted because the file system is not supported.
pub const E_FAILED_WRONG_FS : HResultError = HResultError::from_constant(0x80310013); // FVE_E_FAILED_WRONG_FS

/// The file system size is larger than the partition size in the partition table. This drive may be corrupt or may have been tampered with. To use it with BitLocker, you must reformat the partition.
pub const E_BAD_PARTITION_SIZE : HResultError = HResultError::from_constant(0x80310014); // FVE_E_BAD_PARTITION_SIZE

/// This drive cannot be encrypted.
pub const E_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x80310015); // FVE_E_NOT_SUPPORTED

/// The data is not valid.
pub const E_BAD_DATA : HResultError = HResultError::from_constant(0x80310016); // FVE_E_BAD_DATA

/// The data drive specified is not set to automatically unlock on the current computer and cannot be unlocked automatically.
pub const E_VOLUME_NOT_BOUND : HResultError = HResultError::from_constant(0x80310017); // FVE_E_VOLUME_NOT_BOUND

/// You must initialize the Trusted Platform Module (TPM) before you can use BitLocker Drive Encryption.
pub const E_TPM_NOT_OWNED : HResultError = HResultError::from_constant(0x80310018); // FVE_E_TPM_NOT_OWNED

/// The operation attempted cannot be performed on an operating system drive.
pub const E_NOT_DATA_VOLUME : HResultError = HResultError::from_constant(0x80310019); // FVE_E_NOT_DATA_VOLUME

/// The buffer supplied to a function was insufficient to contain the returned data. Increase the buffer size before running the function again.
pub const E_AD_INSUFFICIENT_BUFFER : HResultError = HResultError::from_constant(0x8031001A); // FVE_E_AD_INSUFFICIENT_BUFFER

/// A read operation failed while converting the drive. The drive was not converted. Please re-enable BitLocker.
pub const E_CONV_READ : HResultError = HResultError::from_constant(0x8031001B); // FVE_E_CONV_READ

/// A write operation failed while converting the drive. The drive was not converted. Please re-enable BitLocker.
pub const E_CONV_WRITE : HResultError = HResultError::from_constant(0x8031001C); // FVE_E_CONV_WRITE

/// One or more BitLocker key protectors are required. You cannot delete the last key on this drive.
pub const E_KEY_REQUIRED : HResultError = HResultError::from_constant(0x8031001D); // FVE_E_KEY_REQUIRED

/// Cluster configurations are not supported by BitLocker Drive Encryption.
pub const E_CLUSTERING_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x8031001E); // FVE_E_CLUSTERING_NOT_SUPPORTED

/// The drive specified is already configured to be automatically unlocked on the current computer.
pub const E_VOLUME_BOUND_ALREADY : HResultError = HResultError::from_constant(0x8031001F); // FVE_E_VOLUME_BOUND_ALREADY

/// The operating system drive is not protected by BitLocker Drive Encryption.
pub const E_OS_NOT_PROTECTED : HResultError = HResultError::from_constant(0x80310020); // FVE_E_OS_NOT_PROTECTED

/// BitLocker Drive Encryption has been suspended on this drive. All BitLocker key protectors configured for this drive are effectively disabled, and the drive will be automatically unlocked using an unencrypted (clear) key.
pub const E_PROTECTION_DISABLED : HResultError = HResultError::from_constant(0x80310021); // FVE_E_PROTECTION_DISABLED

/// The drive you are attempting to lock does not have any key protectors available for encryption because BitLocker protection is currently suspended. Re-enable BitLocker to lock this drive.
pub const E_RECOVERY_KEY_REQUIRED : HResultError = HResultError::from_constant(0x80310022); // FVE_E_RECOVERY_KEY_REQUIRED

/// BitLocker cannot use the Trusted Platform Module (TPM) to protect a data drive. TPM protection can only be used with the operating system drive.
pub const E_FOREIGN_VOLUME : HResultError = HResultError::from_constant(0x80310023); // FVE_E_FOREIGN_VOLUME

/// The BitLocker metadata for the encrypted drive cannot be updated because it was locked for updating by another process. Please try this process again.
pub const E_OVERLAPPED_UPDATE : HResultError = HResultError::from_constant(0x80310024); // FVE_E_OVERLAPPED_UPDATE

/// The authorization data for the storage root key (SRK) of the Trusted Platform Module (TPM) is not zero and is therefore incompatible with BitLocker. Please initialize the TPM before attempting to use it with BitLocker.
pub const E_TPM_SRK_AUTH_NOT_ZERO : HResultError = HResultError::from_constant(0x80310025); // FVE_E_TPM_SRK_AUTH_NOT_ZERO

/// The drive encryption algorithm cannot be used on this sector size.
pub const E_FAILED_SECTOR_SIZE : HResultError = HResultError::from_constant(0x80310026); // FVE_E_FAILED_SECTOR_SIZE

/// The drive cannot be unlocked with the key provided. Confirm that you have provided the correct key and try again.
pub const E_FAILED_AUTHENTICATION : HResultError = HResultError::from_constant(0x80310027); // FVE_E_FAILED_AUTHENTICATION

/// The drive specified is not the operating system drive.
pub const E_NOT_OS_VOLUME : HResultError = HResultError::from_constant(0x80310028); // FVE_E_NOT_OS_VOLUME

/// BitLocker Drive Encryption cannot be turned off on the operating system drive until the auto unlock feature has been disabled for the fixed data drives and removable data drives associated with this computer.
pub const E_AUTOUNLOCK_ENABLED : HResultError = HResultError::from_constant(0x80310029); // FVE_E_AUTOUNLOCK_ENABLED

/// The system partition boot sector does not perform Trusted Platform Module (TPM) measurements. Use the Bootrec.exe tool in the Windows Recovery Environment to update or repair the boot sector.
pub const E_WRONG_BOOTSECTOR : HResultError = HResultError::from_constant(0x8031002A); // FVE_E_WRONG_BOOTSECTOR

/// BitLocker Drive Encryption operating system drives must be formatted with the NTFS file system in order to be encrypted. Convert the drive to NTFS, and then turn on BitLocker.
pub const E_WRONG_SYSTEM_FS : HResultError = HResultError::from_constant(0x8031002B); // FVE_E_WRONG_SYSTEM_FS

/// Group Policy settings require that a recovery password be specified before encrypting the drive.
pub const E_POLICY_PASSWORD_REQUIRED : HResultError = HResultError::from_constant(0x8031002C); // FVE_E_POLICY_PASSWORD_REQUIRED

/// The drive encryption algorithm and key cannot be set on a previously encrypted drive. To encrypt this drive with BitLocker Drive Encryption, remove the previous encryption and then turn on BitLocker.
pub const E_CANNOT_SET_FVEK_ENCRYPTED : HResultError = HResultError::from_constant(0x8031002D); // FVE_E_CANNOT_SET_FVEK_ENCRYPTED

/// BitLocker Drive Encryption cannot encrypt the specified drive because an encryption key is not available. Add a key protector to encrypt this drive.
pub const E_CANNOT_ENCRYPT_NO_KEY : HResultError = HResultError::from_constant(0x8031002E); // FVE_E_CANNOT_ENCRYPT_NO_KEY

/// BitLocker Drive Encryption detected bootable media (CD or DVD) in the computer. Remove the media and restart the computer before configuring BitLocker.
pub const E_BOOTABLE_CDDVD : HResultError = HResultError::from_constant(0x80310030); // FVE_E_BOOTABLE_CDDVD

/// This key protector cannot be added. Only one key protector of this type is allowed for this drive.
pub const E_PROTECTOR_EXISTS : HResultError = HResultError::from_constant(0x80310031); // FVE_E_PROTECTOR_EXISTS

/// The recovery password file was not found because a relative path was specified. Recovery passwords must be saved to a fully qualified path. Environment variables configured on the computer can be used in the path.
pub const E_RELATIVE_PATH : HResultError = HResultError::from_constant(0x80310032); // FVE_E_RELATIVE_PATH

/// The specified key protector was not found on the drive. Try another key protector.
pub const E_PROTECTOR_NOT_FOUND : HResultError = HResultError::from_constant(0x80310033); // FVE_E_PROTECTOR_NOT_FOUND

/// The recovery key provided is corrupt and cannot be used to access the drive. An alternative recovery method, such as recovery password, a data recovery agent, or a backup version of the recovery key must be used to recover access to the drive.
pub const E_INVALID_KEY_FORMAT : HResultError = HResultError::from_constant(0x80310034); // FVE_E_INVALID_KEY_FORMAT

/// The format of the recovery password provided is invalid. BitLocker recovery passwords are 48 digits. Verify that the recovery password is in the correct format and then try again.
pub const E_INVALID_PASSWORD_FORMAT : HResultError = HResultError::from_constant(0x80310035); // FVE_E_INVALID_PASSWORD_FORMAT

/// The random number generator check test failed.
pub const E_FIPS_RNG_CHECK_FAILED : HResultError = HResultError::from_constant(0x80310036); // FVE_E_FIPS_RNG_CHECK_FAILED

/// The Group Policy setting requiring FIPS compliance prevents a local recovery password from being generated or used by BitLocker Drive Encryption. When operating in FIPS-compliant mode, BitLocker recovery options can be either a recovery key stored on a USB drive or recovery through a data recovery agent.
pub const E_FIPS_PREVENTS_RECOVERY_PASSWORD : HResultError = HResultError::from_constant(0x80310037); // FVE_E_FIPS_PREVENTS_RECOVERY_PASSWORD

/// The Group Policy setting requiring FIPS compliance prevents the recovery password from being saved to Active Directory. When operating in FIPS-compliant mode, BitLocker recovery options can be either a recovery key stored on a USB drive or recovery through a data recovery agent. Check your Group Policy settings configuration.
pub const E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT : HResultError = HResultError::from_constant(0x80310038); // FVE_E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT

/// The drive must be fully decrypted to complete this operation.
pub const E_NOT_DECRYPTED : HResultError = HResultError::from_constant(0x80310039); // FVE_E_NOT_DECRYPTED

/// The key protector specified cannot be used for this operation.
pub const E_INVALID_PROTECTOR_TYPE : HResultError = HResultError::from_constant(0x8031003A); // FVE_E_INVALID_PROTECTOR_TYPE

/// No key protectors exist on the drive to perform the hardware test.
pub const E_NO_PROTECTORS_TO_TEST : HResultError = HResultError::from_constant(0x8031003B); // FVE_E_NO_PROTECTORS_TO_TEST

/// The BitLocker startup key or recovery password cannot be found on the USB device. Verify that you have the correct USB device, that the USB device is plugged into the computer on an active USB port, restart the computer, and then try again. If the problem persists, contact the computer manufacturer for BIOS upgrade instructions.
pub const E_KEYFILE_NOT_FOUND : HResultError = HResultError::from_constant(0x8031003C); // FVE_E_KEYFILE_NOT_FOUND

/// The BitLocker startup key or recovery password file provided is corrupt or invalid. Verify that you have the correct startup key or recovery password file and try again.
pub const E_KEYFILE_INVALID : HResultError = HResultError::from_constant(0x8031003D); // FVE_E_KEYFILE_INVALID

/// The BitLocker encryption key cannot be obtained from the startup key or recovery password. Verify that you have the correct startup key or recovery password and try again.
pub const E_KEYFILE_NO_VMK : HResultError = HResultError::from_constant(0x8031003E); // FVE_E_KEYFILE_NO_VMK

/// The Trusted Platform Module (TPM) is disabled. The TPM must be enabled, initialized, and have valid ownership before it can be used with BitLocker Drive Encryption.
pub const E_TPM_DISABLED : HResultError = HResultError::from_constant(0x8031003F); // FVE_E_TPM_DISABLED

/// The BitLocker configuration of the specified drive cannot be managed because this computer is currently operating in Safe Mode. While in Safe Mode, BitLocker Drive Encryption can only be used for recovery purposes.
pub const E_NOT_ALLOWED_IN_SAFE_MODE : HResultError = HResultError::from_constant(0x80310040); // FVE_E_NOT_ALLOWED_IN_SAFE_MODE

/// The Trusted Platform Module (TPM) was unable to unlock the drive. Either the system boot information changed after choosing BitLocker settings or the PIN did not match. If the problem persists after several tries, there may be a hardware or firmware problem.
pub const E_TPM_INVALID_PCR : HResultError = HResultError::from_constant(0x80310041); // FVE_E_TPM_INVALID_PCR

/// The BitLocker encryption key cannot be obtained from the Trusted Platform Module (TPM).
pub const E_TPM_NO_VMK : HResultError = HResultError::from_constant(0x80310042); // FVE_E_TPM_NO_VMK

/// The BitLocker encryption key cannot be obtained from the Trusted Platform Module (TPM) and PIN.
pub const E_PIN_INVALID : HResultError = HResultError::from_constant(0x80310043); // FVE_E_PIN_INVALID

/// A boot application has changed since BitLocker Drive Encryption was enabled.
pub const E_AUTH_INVALID_APPLICATION : HResultError = HResultError::from_constant(0x80310044); // FVE_E_AUTH_INVALID_APPLICATION

/// The Boot Configuration Data (BCD) settings have changed since BitLocker Drive Encryption was enabled.
pub const E_AUTH_INVALID_CONFIG : HResultError = HResultError::from_constant(0x80310045); // FVE_E_AUTH_INVALID_CONFIG

/// The Group Policy setting requiring FIPS compliance prohibits the use of unencrypted keys, which prevents BitLocker from being suspended on this drive. Please contact your domain administrator for more information.
pub const E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310046); // FVE_E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED

/// This drive cannot be encrypted by BitLocker Drive Encryption because the file system does not extend to the end of the drive. Repartition this drive and then try again.
pub const E_FS_NOT_EXTENDED : HResultError = HResultError::from_constant(0x80310047); // FVE_E_FS_NOT_EXTENDED

/// BitLocker Drive Encryption cannot be enabled on the operating system drive. Contact the computer manufacturer for BIOS upgrade instructions.
pub const E_FIRMWARE_TYPE_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x80310048); // FVE_E_FIRMWARE_TYPE_NOT_SUPPORTED

/// This version of Windows does not include BitLocker Drive Encryption. To use BitLocker Drive Encryption, please upgrade the operating system.
pub const E_NO_LICENSE : HResultError = HResultError::from_constant(0x80310049); // FVE_E_NO_LICENSE

/// BitLocker Drive Encryption cannot be used because critical BitLocker system files are missing or corrupted. Use Windows Startup Repair to restore these files to your computer.
pub const E_NOT_ON_STACK : HResultError = HResultError::from_constant(0x8031004A); // FVE_E_NOT_ON_STACK

/// The drive cannot be locked when the drive is in use.
pub const E_FS_MOUNTED : HResultError = HResultError::from_constant(0x8031004B); // FVE_E_FS_MOUNTED

/// The access token associated with the current thread is not an impersonated token.
pub const E_TOKEN_NOT_IMPERSONATED : HResultError = HResultError::from_constant(0x8031004C); // FVE_E_TOKEN_NOT_IMPERSONATED

/// The BitLocker encryption key cannot be obtained. Verify that the Trusted Platform Module (TPM) is enabled and ownership has been taken. If this computer does not have a TPM, verify that the USB drive is inserted and available.
pub const E_DRY_RUN_FAILED : HResultError = HResultError::from_constant(0x8031004D); // FVE_E_DRY_RUN_FAILED

/// You must restart your computer before continuing with BitLocker Drive Encryption.
pub const E_REBOOT_REQUIRED : HResultError = HResultError::from_constant(0x8031004E); // FVE_E_REBOOT_REQUIRED

/// Drive encryption cannot occur while boot debugging is enabled. Use the bcdedit command-line tool to turn off boot debugging.
pub const E_DEBUGGER_ENABLED : HResultError = HResultError::from_constant(0x8031004F); // FVE_E_DEBUGGER_ENABLED

/// No action was taken as BitLocker Drive Encryption is in raw access mode.
pub const E_RAW_ACCESS : HResultError = HResultError::from_constant(0x80310050); // FVE_E_RAW_ACCESS

/// BitLocker Drive Encryption cannot enter raw access mode for this drive because the drive is currently in use.
pub const E_RAW_BLOCKED : HResultError = HResultError::from_constant(0x80310051); // FVE_E_RAW_BLOCKED

/// The path specified in the Boot Configuration Data (BCD) for a BitLocker Drive Encryption integrity-protected application is incorrect. Please verify and correct your BCD settings and try again.
pub const E_BCD_APPLICATIONS_PATH_INCORRECT : HResultError = HResultError::from_constant(0x80310052); // FVE_E_BCD_APPLICATIONS_PATH_INCORRECT

/// BitLocker Drive Encryption can only be used for limited provisioning or recovery purposes when the computer is running in pre-installation or recovery environments.
pub const E_NOT_ALLOWED_IN_VERSION : HResultError = HResultError::from_constant(0x80310053); // FVE_E_NOT_ALLOWED_IN_VERSION

/// The auto-unlock master key was not available from the operating system drive.
pub const E_NO_AUTOUNLOCK_MASTER_KEY : HResultError = HResultError::from_constant(0x80310054); // FVE_E_NO_AUTOUNLOCK_MASTER_KEY

/// The system firmware failed to enable clearing of system memory when the computer was restarted.
pub const E_MOR_FAILED : HResultError = HResultError::from_constant(0x80310055); // FVE_E_MOR_FAILED

/// The hidden drive cannot be encrypted.
pub const E_HIDDEN_VOLUME : HResultError = HResultError::from_constant(0x80310056); // FVE_E_HIDDEN_VOLUME

/// BitLocker encryption keys were ignored because the drive was in a transient state.
pub const E_TRANSIENT_STATE : HResultError = HResultError::from_constant(0x80310057); // FVE_E_TRANSIENT_STATE

/// Public key based protectors are not allowed on this drive.
pub const E_PUBKEY_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310058); // FVE_E_PUBKEY_NOT_ALLOWED

/// BitLocker Drive Encryption is already performing an operation on this drive. Please complete all operations before continuing.
pub const E_VOLUME_HANDLE_OPEN : HResultError = HResultError::from_constant(0x80310059); // FVE_E_VOLUME_HANDLE_OPEN

/// This version of Windows does not support this feature of BitLocker Drive Encryption. To use this feature, upgrade the operating system.
pub const E_NO_FEATURE_LICENSE : HResultError = HResultError::from_constant(0x8031005A); // FVE_E_NO_FEATURE_LICENSE

/// The Group Policy settings for BitLocker startup options are in conflict and cannot be applied. Contact your system administrator for more information.
pub const E_INVALID_STARTUP_OPTIONS : HResultError = HResultError::from_constant(0x8031005B); // FVE_E_INVALID_STARTUP_OPTIONS

/// Group Policy settings do not permit the creation of a recovery password.
pub const E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED : HResultError = HResultError::from_constant(0x8031005C); // FVE_E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED

/// Group Policy settings require the creation of a recovery password.
pub const E_POLICY_RECOVERY_PASSWORD_REQUIRED : HResultError = HResultError::from_constant(0x8031005D); // FVE_E_POLICY_RECOVERY_PASSWORD_REQUIRED

/// Group Policy settings do not permit the creation of a recovery key.
pub const E_POLICY_RECOVERY_KEY_NOT_ALLOWED : HResultError = HResultError::from_constant(0x8031005E); // FVE_E_POLICY_RECOVERY_KEY_NOT_ALLOWED

/// Group Policy settings require the creation of a recovery key.
pub const E_POLICY_RECOVERY_KEY_REQUIRED : HResultError = HResultError::from_constant(0x8031005F); // FVE_E_POLICY_RECOVERY_KEY_REQUIRED

/// Group Policy settings do not permit the use of a PIN at startup. Please choose a different BitLocker startup option.
pub const E_POLICY_STARTUP_PIN_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310060); // FVE_E_POLICY_STARTUP_PIN_NOT_ALLOWED

/// Group Policy settings require the use of a PIN at startup. Please choose this BitLocker startup option.
pub const E_POLICY_STARTUP_PIN_REQUIRED : HResultError = HResultError::from_constant(0x80310061); // FVE_E_POLICY_STARTUP_PIN_REQUIRED

/// Group Policy settings do not permit the use of a startup key. Please choose a different BitLocker startup option.
pub const E_POLICY_STARTUP_KEY_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310062); // FVE_E_POLICY_STARTUP_KEY_NOT_ALLOWED

/// Group Policy settings require the use of a startup key. Please choose this BitLocker startup option.
pub const E_POLICY_STARTUP_KEY_REQUIRED : HResultError = HResultError::from_constant(0x80310063); // FVE_E_POLICY_STARTUP_KEY_REQUIRED

/// Group Policy settings do not permit the use of a startup key and PIN. Please choose a different BitLocker startup option.
pub const E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310064); // FVE_E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED

/// Group Policy settings require the use of a startup key and PIN. Please choose this BitLocker startup option.
pub const E_POLICY_STARTUP_PIN_KEY_REQUIRED : HResultError = HResultError::from_constant(0x80310065); // FVE_E_POLICY_STARTUP_PIN_KEY_REQUIRED

/// Group policy does not permit the use of TPM-only at startup. Please choose a different BitLocker startup option.
pub const E_POLICY_STARTUP_TPM_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310066); // FVE_E_POLICY_STARTUP_TPM_NOT_ALLOWED

/// Group Policy settings require the use of TPM-only at startup. Please choose this BitLocker startup option.
pub const E_POLICY_STARTUP_TPM_REQUIRED : HResultError = HResultError::from_constant(0x80310067); // FVE_E_POLICY_STARTUP_TPM_REQUIRED

/// The PIN provided does not meet minimum or maximum length requirements.
pub const E_POLICY_INVALID_PIN_LENGTH : HResultError = HResultError::from_constant(0x80310068); // FVE_E_POLICY_INVALID_PIN_LENGTH

/// The key protector is not supported by the version of BitLocker Drive Encryption currently on the drive. Upgrade the drive to add the key protector.
pub const E_KEY_PROTECTOR_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x80310069); // FVE_E_KEY_PROTECTOR_NOT_SUPPORTED

/// Group Policy settings do not permit the creation of a password.
pub const E_POLICY_PASSPHRASE_NOT_ALLOWED : HResultError = HResultError::from_constant(0x8031006A); // FVE_E_POLICY_PASSPHRASE_NOT_ALLOWED

/// Group Policy settings require the creation of a password.
pub const E_POLICY_PASSPHRASE_REQUIRED : HResultError = HResultError::from_constant(0x8031006B); // FVE_E_POLICY_PASSPHRASE_REQUIRED

/// The Group Policy setting requiring FIPS compliance prevents passwords from being generated or used. Please contact your system administrator for more information.
pub const E_FIPS_PREVENTS_PASSPHRASE : HResultError = HResultError::from_constant(0x8031006C); // FVE_E_FIPS_PREVENTS_PASSPHRASE

/// A password cannot be added to the operating system drive.
pub const E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED : HResultError = HResultError::from_constant(0x8031006D); // FVE_E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED

/// The BitLocker object identifier (OID) on the drive appears to be invalid or corrupt. Use manage-BDE to reset the OID on this drive.
pub const E_INVALID_BITLOCKER_OID : HResultError = HResultError::from_constant(0x8031006E); // FVE_E_INVALID_BITLOCKER_OID

/// The drive is too small to be protected using BitLocker Drive Encryption.
pub const E_VOLUME_TOO_SMALL : HResultError = HResultError::from_constant(0x8031006F); // FVE_E_VOLUME_TOO_SMALL

/// The selected discovery drive type is incompatible with the file system on the drive. BitLocker To Go discovery drives must be created on FAT formatted drives.
pub const E_DV_NOT_SUPPORTED_ON_FS : HResultError = HResultError::from_constant(0x80310070); // FVE_E_DV_NOT_SUPPORTED_ON_FS

/// The selected discovery drive type is not allowed by the computer's Group Policy settings. Verify that Group Policy settings allow the creation of discovery drives for use with BitLocker To Go.
pub const E_DV_NOT_ALLOWED_BY_GP : HResultError = HResultError::from_constant(0x80310071); // FVE_E_DV_NOT_ALLOWED_BY_GP

/// Group Policy settings do not permit user certificates such as smart cards to be used with BitLocker Drive Encryption.
pub const E_POLICY_USER_CERTIFICATE_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310072); // FVE_E_POLICY_USER_CERTIFICATE_NOT_ALLOWED

/// Group Policy settings require that you have a valid user certificate, such as a smart card, to be used with BitLocker Drive Encryption.
pub const E_POLICY_USER_CERTIFICATE_REQUIRED : HResultError = HResultError::from_constant(0x80310073); // FVE_E_POLICY_USER_CERTIFICATE_REQUIRED

/// Group Policy settings requires that you use a smart card-based key protector with BitLocker Drive Encryption.
pub const E_POLICY_USER_CERT_MUST_BE_HW : HResultError = HResultError::from_constant(0x80310074); // FVE_E_POLICY_USER_CERT_MUST_BE_HW

/// Group Policy settings do not permit BitLocker-protected fixed data drives to be automatically unlocked.
pub const E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310075); // FVE_E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED

/// Group Policy settings do not permit BitLocker-protected removable data drives to be automatically unlocked.
pub const E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310076); // FVE_E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED

/// Group Policy settings do not permit you to configure BitLocker Drive Encryption on removable data drives.
pub const E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310077); // FVE_E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED

/// Group Policy settings do not permit you to turn on BitLocker Drive Encryption on removable data drives. Please contact your system administrator if you need to turn on BitLocker.
pub const E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310078); // FVE_E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED

/// Group Policy settings do not permit turning off BitLocker Drive Encryption on removable data drives. Please contact your system administrator if you need to turn off BitLocker.
pub const E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310079); // FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED

/// Your password does not meet minimum password length requirements. By default, passwords must be at least 8 characters in length. Check with your system administrator for the password length requirement in your organization.
pub const E_POLICY_INVALID_PASSPHRASE_LENGTH : HResultError = HResultError::from_constant(0x80310080); // FVE_E_POLICY_INVALID_PASSPHRASE_LENGTH

/// Your password does not meet the complexity requirements set by your system administrator. Try adding upper and lowercase characters, numbers, and symbols.
pub const E_POLICY_PASSPHRASE_TOO_SIMPLE : HResultError = HResultError::from_constant(0x80310081); // FVE_E_POLICY_PASSPHRASE_TOO_SIMPLE

/// This drive cannot be encrypted because it is reserved for Windows System Recovery Options.
pub const E_RECOVERY_PARTITION : HResultError = HResultError::from_constant(0x80310082); // FVE_E_RECOVERY_PARTITION

/// BitLocker Drive Encryption cannot be applied to this drive because of conflicting Group Policy settings. BitLocker cannot be configured to automatically unlock fixed data drives when user recovery options are disabled. If you want BitLocker-protected fixed data drives to be automatically unlocked after key validation has occurred, please ask your system administrator to resolve the settings conflict before enabling BitLocker.
pub const E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON : HResultError = HResultError::from_constant(0x80310083); // FVE_E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON

/// BitLocker Drive Encryption cannot be applied to this drive because of conflicting Group Policy settings. BitLocker cannot be configured to automatically unlock removable data drives when user recovery option are disabled. If you want BitLocker-protected removable data drives to be automatically unlocked after key validation has occurred, please ask your system administrator to resolve the settings conflict before enabling BitLocker.
pub const E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON : HResultError = HResultError::from_constant(0x80310084); // FVE_E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON

/// The Enhanced Key Usage (EKU) attribute of the specified certificate does not permit it to be used for BitLocker Drive Encryption. BitLocker does not require that a certificate have an EKU attribute, but if one is configured it must be set to an object identifier (OID) that matches the OID configured for BitLocker.
pub const E_NON_BITLOCKER_OID : HResultError = HResultError::from_constant(0x80310085); // FVE_E_NON_BITLOCKER_OID

/// BitLocker Drive Encryption cannot be applied to this drive as currently configured because of Group Policy settings. The certificate you provided for drive encryption is self-signed. Current Group Policy settings do not permit the use of self-signed certificates. Obtain a new certificate from your certification authority before attempting to enable BitLocker.
pub const E_POLICY_PROHIBITS_SELFSIGNED : HResultError = HResultError::from_constant(0x80310086); // FVE_E_POLICY_PROHIBITS_SELFSIGNED

/// BitLocker Encryption cannot be applied to this drive because of conflicting Group Policy settings. When write access to drives not protected by BitLocker is denied, the use of a USB startup key cannot be required. Please have your system administrator resolve these policy conflicts before attempting to enable BitLocker.
pub const E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED : HResultError = HResultError::from_constant(0x80310087); // FVE_E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED

/// BitLocker Drive Encryption failed to recover from an abruptly terminated conversion. This could be due to either all conversion logs being corrupted or the media being write-protected.
pub const E_CONV_RECOVERY_FAILED : HResultError = HResultError::from_constant(0x80310088); // FVE_E_CONV_RECOVERY_FAILED

/// The requested virtualization size is too big.
pub const E_VIRTUALIZED_SPACE_TOO_BIG : HResultError = HResultError::from_constant(0x80310089); // FVE_E_VIRTUALIZED_SPACE_TOO_BIG

/// BitLocker Drive Encryption cannot be applied to this drive because there are conflicting Group Policy settings for recovery options on operating system drives. Storing recovery information to Active Directory Domain Services cannot be required when the generation of recovery passwords is not permitted. Please have your system administrator resolve these policy conflicts before attempting to enable BitLocker.
pub const E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON : HResultError = HResultError::from_constant(0x80310090); // FVE_E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON

/// BitLocker Drive Encryption cannot be applied to this drive because there are conflicting Group Policy settings for recovery options on fixed data drives. Storing recovery information to Active Directory Domain Services cannot be required when the generation of recovery passwords is not permitted. Please have your system administrator resolve these policy conflicts before attempting to enable BitLocker.
pub const E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON : HResultError = HResultError::from_constant(0x80310091); // FVE_E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON

/// BitLocker Drive Encryption cannot be applied to this drive because there are conflicting Group Policy settings for recovery options on removable data drives. Storing recovery information to Active Directory Domain Services cannot be required when the generation of recovery passwords is not permitted. Please have your system administrator resolve these policy conflicts before attempting to enable BitLocker.
pub const E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON : HResultError = HResultError::from_constant(0x80310092); // FVE_E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON

/// The Key Usage (KU) attribute of the specified certificate does not permit it to be used for BitLocker Drive Encryption. BitLocker does not require that a certificate have a KU attribute, but if one is configured it must be set to either Key Encipherment or Key Agreement.
pub const E_NON_BITLOCKER_KU : HResultError = HResultError::from_constant(0x80310093); // FVE_E_NON_BITLOCKER_KU

/// The private key associated with the specified certificate cannot be authorized. The private key authorization was either not provided or the provided authorization was invalid.
pub const E_PRIVATEKEY_AUTH_FAILED : HResultError = HResultError::from_constant(0x80310094); // FVE_E_PRIVATEKEY_AUTH_FAILED

/// Removal of the data recovery agent certificate must be done using the Certificates snap-in.
pub const E_REMOVAL_OF_DRA_FAILED : HResultError = HResultError::from_constant(0x80310095); // FVE_E_REMOVAL_OF_DRA_FAILED

/// This drive was encrypted using the version of BitLocker Drive Encryption included with Windows Vista and Windows Server 2008 which does not support organizational identifiers. To specify organizational identifiers for this drive upgrade the drive encryption to the latest version using the "manage-bde -upgrade" command.
pub const E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME : HResultError = HResultError::from_constant(0x80310096); // FVE_E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME

/// The drive cannot be locked because it is automatically unlocked on this computer.  Remove the automatic unlock protector to lock this drive.
pub const E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME : HResultError = HResultError::from_constant(0x80310097); // FVE_E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME

/// The default BitLocker Key Derivation Function SP800-56A for ECC smart cards is not supported by your smart card. The Group Policy setting requiring FIPS-compliance prevents BitLocker from using any other key derivation function for encryption. You have to use a FIPS compliant smart card in FIPS restricted environments.
pub const E_FIPS_HASH_KDF_NOT_ALLOWED : HResultError = HResultError::from_constant(0x80310098); // FVE_E_FIPS_HASH_KDF_NOT_ALLOWED

/// The BitLocker encryption key could not be obtained from the Trusted Platform Module (TPM) and enhanced PIN. Try using a PIN containing only numerals.
pub const E_ENH_PIN_INVALID : HResultError = HResultError::from_constant(0x80310099); // FVE_E_ENH_PIN_INVALID

/// The requested TPM PIN contains invalid characters.
pub const E_INVALID_PIN_CHARS : HResultError = HResultError::from_constant(0x8031009A); // FVE_E_INVALID_PIN_CHARS

/// The management information stored on the drive contained an unknown type. If you are using an old version of Windows, try accessing the drive from the latest version.
pub const E_INVALID_DATUM_TYPE : HResultError = HResultError::from_constant(0x8031009B); // FVE_E_INVALID_DATUM_TYPE

/// The feature is only supported on EFI systems.
pub const E_EFI_ONLY : HResultError = HResultError::from_constant(0x8031009C); // FVE_E_EFI_ONLY

/// More than one Network Key Protector certificate has been found on the system.
pub const E_MULTIPLE_NKP_CERTS : HResultError = HResultError::from_constant(0x8031009D); // FVE_E_MULTIPLE_NKP_CERTS

/// Removal of the Network Key Protector certificate must be done using the Certificates snap-in.
pub const E_REMOVAL_OF_NKP_FAILED : HResultError = HResultError::from_constant(0x8031009E); // FVE_E_REMOVAL_OF_NKP_FAILED

/// An invalid certificate has been found in the Network Key Protector certificate store.
pub const E_INVALID_NKP_CERT : HResultError = HResultError::from_constant(0x8031009F); // FVE_E_INVALID_NKP_CERT

/// This drive isn't protected with a PIN.
pub const E_NO_EXISTING_PIN : HResultError = HResultError::from_constant(0x803100A0); // FVE_E_NO_EXISTING_PIN

/// Please enter the correct current PIN.
pub const E_PROTECTOR_CHANGE_PIN_MISMATCH : HResultError = HResultError::from_constant(0x803100A1); // FVE_E_PROTECTOR_CHANGE_PIN_MISMATCH

/// You must be logged on with an administrator account to change the PIN. Click the link to reset the PIN as an administrator.
pub const E_PIN_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED : HResultError = HResultError::from_constant(0x803100A2); // FVE_E_PIN_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED

/// BitLocker has disabled PIN changes after too many failed requests. Click the link to reset the PIN as an administrator.
pub const E_PROTECTOR_CHANGE_MAX_PIN_CHANGE_ATTEMPTS_REACHED : HResultError = HResultError::from_constant(0x803100A3); // FVE_E_PROTECTOR_CHANGE_MAX_PIN_CHANGE_ATTEMPTS_REACHED

/// Your system administrator requires that passwords contain only printable ASCII characters. This includes unaccented letters (A-Z, a-z), numbers (0-9), space, arithmetic signs, common punctuation, separators, and the following symbols: # $ & @ ^ _ ~ .
pub const E_POLICY_PASSPHRASE_REQUIRES_ASCII : HResultError = HResultError::from_constant(0x803100A4); // FVE_E_POLICY_PASSPHRASE_REQUIRES_ASCII

/// BitLocker Drive Encryption only supports Used Space Only encryption on thin provisioned storage.
pub const E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE : HResultError = HResultError::from_constant(0x803100A5); // FVE_E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE

/// BitLocker Drive Encryption does not support wiping free space on thin provisioned storage.
pub const E_WIPE_NOT_ALLOWED_ON_TP_STORAGE : HResultError = HResultError::from_constant(0x803100A6); // FVE_E_WIPE_NOT_ALLOWED_ON_TP_STORAGE

/// The required authentication key length is not supported by the drive.
pub const E_KEY_LENGTH_NOT_SUPPORTED_BY_EDRIVE : HResultError = HResultError::from_constant(0x803100A7); // FVE_E_KEY_LENGTH_NOT_SUPPORTED_BY_EDRIVE

/// This drive isn't protected with a password.
pub const E_NO_EXISTING_PASSPHRASE : HResultError = HResultError::from_constant(0x803100A8); // FVE_E_NO_EXISTING_PASSPHRASE

/// Please enter the correct current password.
pub const E_PROTECTOR_CHANGE_PASSPHRASE_MISMATCH : HResultError = HResultError::from_constant(0x803100A9); // FVE_E_PROTECTOR_CHANGE_PASSPHRASE_MISMATCH

/// The password cannot exceed 256 characters.
pub const E_PASSPHRASE_TOO_LONG : HResultError = HResultError::from_constant(0x803100AA); // FVE_E_PASSPHRASE_TOO_LONG

/// A password key protector cannot be added because a TPM protector exists on the drive.
pub const E_NO_PASSPHRASE_WITH_TPM : HResultError = HResultError::from_constant(0x803100AB); // FVE_E_NO_PASSPHRASE_WITH_TPM

/// A TPM key protector cannot be added because a password protector exists on the drive.
pub const E_NO_TPM_WITH_PASSPHRASE : HResultError = HResultError::from_constant(0x803100AC); // FVE_E_NO_TPM_WITH_PASSPHRASE

/// This command can only be performed from the coordinator node for the specified CSV volume.
pub const E_NOT_ALLOWED_ON_CSV_STACK : HResultError = HResultError::from_constant(0x803100AD); // FVE_E_NOT_ALLOWED_ON_CSV_STACK

/// This command cannot be performed on a volume when it is part of a cluster.
pub const E_NOT_ALLOWED_ON_CLUSTER : HResultError = HResultError::from_constant(0x803100AE); // FVE_E_NOT_ALLOWED_ON_CLUSTER

/// BitLocker did not revert to using BitLocker software encryption due to group policy configuration.
pub const E_EDRIVE_NO_FAILOVER_TO_SW : HResultError = HResultError::from_constant(0x803100AF); // FVE_E_EDRIVE_NO_FAILOVER_TO_SW

/// The drive cannot be managed by BitLocker because the drive's hardware encryption feature is already in use.
pub const E_EDRIVE_BAND_IN_USE : HResultError = HResultError::from_constant(0x803100B0); // FVE_E_EDRIVE_BAND_IN_USE

/// Group Policy settings do not allow the use of hardware-based encryption.
pub const E_EDRIVE_DISALLOWED_BY_GP : HResultError = HResultError::from_constant(0x803100B1); // FVE_E_EDRIVE_DISALLOWED_BY_GP

/// The drive specified does not support hardware-based encryption.
pub const E_EDRIVE_INCOMPATIBLE_VOLUME : HResultError = HResultError::from_constant(0x803100B2); // FVE_E_EDRIVE_INCOMPATIBLE_VOLUME

/// BitLocker cannot be upgraded during disk encryption or decryption.
pub const E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING : HResultError = HResultError::from_constant(0x803100B3); // FVE_E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING

/// Discovery Volumes are not supported for volumes using hardware encryption.
pub const E_EDRIVE_DV_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x803100B4); // FVE_E_EDRIVE_DV_NOT_SUPPORTED

/// No pre-boot keyboard detected. The user may not be able to provide required input to unlock the volume.
pub const E_NO_PREBOOT_KEYBOARD_DETECTED : HResultError = HResultError::from_constant(0x803100B5); // FVE_E_NO_PREBOOT_KEYBOARD_DETECTED

/// No pre-boot keyboard or Windows Recovery Environment detected. The user may not be able to provide required input to unlock the volume.
pub const E_NO_PREBOOT_KEYBOARD_OR_WINRE_DETECTED : HResultError = HResultError::from_constant(0x803100B6); // FVE_E_NO_PREBOOT_KEYBOARD_OR_WINRE_DETECTED

/// Group Policy settings require the creation of a startup PIN, but a pre-boot keyboard is not available on this device. The user may not be able to provide required input to unlock the volume.
pub const E_POLICY_REQUIRES_STARTUP_PIN_ON_TOUCH_DEVICE : HResultError = HResultError::from_constant(0x803100B7); // FVE_E_POLICY_REQUIRES_STARTUP_PIN_ON_TOUCH_DEVICE

/// Group Policy settings require the creation of a recovery password, but neither a pre-boot keyboard nor Windows Recovery Environment is available on this device. The user may not be able to provide required input to unlock the volume.
pub const E_POLICY_REQUIRES_RECOVERY_PASSWORD_ON_TOUCH_DEVICE : HResultError = HResultError::from_constant(0x803100B8); // FVE_E_POLICY_REQUIRES_RECOVERY_PASSWORD_ON_TOUCH_DEVICE

/// Wipe of free space is not currently taking place.
pub const E_WIPE_CANCEL_NOT_APPLICABLE : HResultError = HResultError::from_constant(0x803100B9); // FVE_E_WIPE_CANCEL_NOT_APPLICABLE

/// BitLocker cannot use Secure Boot for platform integrity because Secure Boot has been disabled.
pub const E_SECUREBOOT_DISABLED : HResultError = HResultError::from_constant(0x803100BA); // FVE_E_SECUREBOOT_DISABLED

/// BitLocker cannot use Secure Boot for platform integrity because the Secure Boot configuration does not meet the requirements for BitLocker.
pub const E_SECUREBOOT_CONFIGURATION_INVALID : HResultError = HResultError::from_constant(0x803100BB); // FVE_E_SECUREBOOT_CONFIGURATION_INVALID

/// Your computer doesn't support BitLocker hardware-based encryption. Check with your computer manufacturer for firmware updates.
pub const E_EDRIVE_DRY_RUN_FAILED : HResultError = HResultError::from_constant(0x803100BC); // FVE_E_EDRIVE_DRY_RUN_FAILED

/// BitLocker cannot be enabled on the volume because it contains a Volume Shadow Copy. Remove all Volume Shadow Copies before encrypting the volume.
pub const E_SHADOW_COPY_PRESENT : HResultError = HResultError::from_constant(0x803100BD); // FVE_E_SHADOW_COPY_PRESENT

/// BitLocker Drive Encryption cannot be applied to this drive because the Group Policy setting for Enhanced Boot Configuration Data contains invalid data. Please have your system administrator resolve this invalid configuration before attempting to enable BitLocker.
pub const E_POLICY_INVALID_ENHANCED_BCD_SETTINGS : HResultError = HResultError::from_constant(0x803100BE); // FVE_E_POLICY_INVALID_ENHANCED_BCD_SETTINGS

/// This PC's firmware is not capable of supporting hardware encryption.
pub const E_EDRIVE_INCOMPATIBLE_FIRMWARE : HResultError = HResultError::from_constant(0x803100BF); // FVE_E_EDRIVE_INCOMPATIBLE_FIRMWARE

/// BitLocker has disabled password changes after too many failed requests. Click the link to reset the password as an administrator.
pub const E_PROTECTOR_CHANGE_MAX_PASSPHRASE_CHANGE_ATTEMPTS_REACHED : HResultError = HResultError::from_constant(0x803100C0); // FVE_E_PROTECTOR_CHANGE_MAX_PASSPHRASE_CHANGE_ATTEMPTS_REACHED

/// You must be logged on with an administrator account to change the password. Click the link to reset the password as an administrator.
pub const E_PASSPHRASE_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED : HResultError = HResultError::from_constant(0x803100C1); // FVE_E_PASSPHRASE_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED

/// BitLocker cannot save the recovery password because the specified Microsoft account is Suspended.
pub const E_LIVEID_ACCOUNT_SUSPENDED : HResultError = HResultError::from_constant(0x803100C2); // FVE_E_LIVEID_ACCOUNT_SUSPENDED

/// BitLocker cannot save the recovery password because the specified Microsoft account is Blocked.
pub const E_LIVEID_ACCOUNT_BLOCKED : HResultError = HResultError::from_constant(0x803100C3); // FVE_E_LIVEID_ACCOUNT_BLOCKED

/// This PC is not provisioned to support device encryption. Please enable BitLocker on all volumes to comply with device encryption policy.
pub const E_NOT_PROVISIONED_ON_ALL_VOLUMES : HResultError = HResultError::from_constant(0x803100C4); // FVE_E_NOT_PROVISIONED_ON_ALL_VOLUMES

/// This PC cannot support device encryption because unencrypted fixed data volumes are present.
pub const E_DE_FIXED_DATA_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x803100C5); // FVE_E_DE_FIXED_DATA_NOT_SUPPORTED

/// This PC does not meet the hardware requirements to support device encryption.
pub const E_DE_HARDWARE_NOT_COMPLIANT : HResultError = HResultError::from_constant(0x803100C6); // FVE_E_DE_HARDWARE_NOT_COMPLIANT

/// This PC cannot support device encryption because WinRE is not properly configured.
pub const E_DE_WINRE_NOT_CONFIGURED : HResultError = HResultError::from_constant(0x803100C7); // FVE_E_DE_WINRE_NOT_CONFIGURED

/// Protection is enabled on the volume but has been suspended. This is likely to have happened due to an update being applied to your system. Please try again after a reboot.
pub const E_DE_PROTECTION_SUSPENDED : HResultError = HResultError::from_constant(0x803100C8); // FVE_E_DE_PROTECTION_SUSPENDED

/// This PC is not provisioned to support device encryption.
pub const E_DE_OS_VOLUME_NOT_PROTECTED : HResultError = HResultError::from_constant(0x803100C9); // FVE_E_DE_OS_VOLUME_NOT_PROTECTED

/// Device Lock has been triggered due to too many incorrect password attempts.
pub const E_DE_DEVICE_LOCKEDOUT : HResultError = HResultError::from_constant(0x803100CA); // FVE_E_DE_DEVICE_LOCKEDOUT

/// Protection has not been enabled on the volume. Enabling protection requires a connected account. If you already have a connected account and are seeing this error, please refer to the event log for more information.
pub const E_DE_PROTECTION_NOT_YET_ENABLED : HResultError = HResultError::from_constant(0x803100CB); // FVE_E_DE_PROTECTION_NOT_YET_ENABLED

/// Your PIN can only contain numbers from 0 to 9.
pub const E_INVALID_PIN_CHARS_DETAILED : HResultError = HResultError::from_constant(0x803100CC); // FVE_E_INVALID_PIN_CHARS_DETAILED

/// BitLocker cannot use hardware replay protection because no counter is available on your PC.
pub const E_DEVICE_LOCKOUT_COUNTER_UNAVAILABLE : HResultError = HResultError::from_constant(0x803100CD); // FVE_E_DEVICE_LOCKOUT_COUNTER_UNAVAILABLE

/// Device Lockout state validation failed due to counter mismatch.
pub const E_DEVICELOCKOUT_COUNTER_MISMATCH : HResultError = HResultError::from_constant(0x803100CE); // FVE_E_DEVICELOCKOUT_COUNTER_MISMATCH

/// The input buffer is too large.
pub const E_BUFFER_TOO_LARGE : HResultError = HResultError::from_constant(0x803100CF); // FVE_E_BUFFER_TOO_LARGE

/// The target of an invocation does not support requested capability.
pub const E_NO_SUCH_CAPABILITY_ON_TARGET : HResultError = HResultError::from_constant(0x803100D0); // FVE_E_NO_SUCH_CAPABILITY_ON_TARGET

/// Device encryption is currently blocked by this PC's configuration.
pub const E_DE_PREVENTED_FOR_OS : HResultError = HResultError::from_constant(0x803100D1); // FVE_E_DE_PREVENTED_FOR_OS

/// This drive has been opted out of device encryption.
pub const E_DE_VOLUME_OPTED_OUT : HResultError = HResultError::from_constant(0x803100D2); // FVE_E_DE_VOLUME_OPTED_OUT

/// Device encryption isn't available for this drive.
pub const E_DE_VOLUME_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x803100D3); // FVE_E_DE_VOLUME_NOT_SUPPORTED

/// The encrypt on write mode for BitLocker is not supported in this version of Windows. You can turn on BitLocker without using the encrypt on write mode.
pub const E_EOW_NOT_SUPPORTED_IN_VERSION : HResultError = HResultError::from_constant(0x803100D4); // FVE_E_EOW_NOT_SUPPORTED_IN_VERSION

/// Group policy prevents you from backing up your recovery password to Active Directory for this drive type. For more info, contact your system administrator.
pub const E_ADBACKUP_NOT_ENABLED : HResultError = HResultError::from_constant(0x803100D5); // FVE_E_ADBACKUP_NOT_ENABLED

/// Device encryption can't be turned off while this drive is being encrypted. Please try again later.
pub const E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT : HResultError = HResultError::from_constant(0x803100D6); // FVE_E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT

/// This action isn't supported because this drive isn't automatically managed with device encryption.
pub const E_NOT_DE_VOLUME : HResultError = HResultError::from_constant(0x803100D7); // FVE_E_NOT_DE_VOLUME

/// BitLocker can't be suspended on this drive until the next restart.
pub const E_PROTECTION_CANNOT_BE_DISABLED : HResultError = HResultError::from_constant(0x803100D8); // FVE_E_PROTECTION_CANNOT_BE_DISABLED

/// BitLocker Drive Encryption policy does not allow KSR operation with protected OS volume.
pub const E_OSV_KSR_NOT_ALLOWED : HResultError = HResultError::from_constant(0x803100D9); // FVE_E_OSV_KSR_NOT_ALLOWED

/// BitLocker recovery password rotation cannot be performed because backup policy for BitLocker recovery information is not set to required for the OS drive.
pub const E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_OS_DRIVE : HResultError = HResultError::from_constant(0x803100DA); // FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_OS_DRIVE

/// BitLocker recovery password rotation cannot be performed because backup policy for BitLocker recovery information is not set to required for fixed data drives.
pub const E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_FIXED_DRIVE : HResultError = HResultError::from_constant(0x803100DB); // FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_FIXED_DRIVE

/// BitLocker recovery password rotation cannot be performed because backup policy for BitLocker recovery information is not set to required for removable data drives
pub const E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_REMOVABLE_DRIVE : HResultError = HResultError::from_constant(0x803100DC); // FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_REMOVABLE_DRIVE

/// BitLocker recovery password rotation not supported.
pub const E_KEY_ROTATION_NOT_SUPPORTED : HResultError = HResultError::from_constant(0x803100DD); // FVE_E_KEY_ROTATION_NOT_SUPPORTED

/// A server issued BitLocker recovery password rotation was denied because requests must be 15 minutes apart.
pub const E_EXECUTE_REQUEST_SENT_TOO_SOON : HResultError = HResultError::from_constant(0x803100DE); // FVE_E_EXECUTE_REQUEST_SENT_TOO_SOON

/// BitLocker recovery password key rotation policy is not enabled.
pub const E_KEY_ROTATION_NOT_ENABLED : HResultError = HResultError::from_constant(0x803100DF); // FVE_E_KEY_ROTATION_NOT_ENABLED

/// BitLocker recovery password key rotation could not be performed because the device is neither Azure AD joined nor Hybrid Azure AD joined.
pub const E_DEVICE_NOT_JOINED : HResultError = HResultError::from_constant(0x803100E0); // FVE_E_DEVICE_NOT_JOINED

/// BitLocker recovery key backup endpoint is busy and cannot perform requested operation. Please retry after sometime.
pub const E_AAD_ENDPOINT_BUSY : HResultError = HResultError::from_constant(0x803100E1); // FVE_E_AAD_ENDPOINT_BUSY
