use std::env;

use clap_generate::{
    generate_to,
    generators::{Bash, Elvish, Fish, PowerShell, Zsh},
};
include!("src/lib.rs");

fn generate_completions(
    mut app: App<'static>,
    bin_name: &str,
    outdir: &str,
) -> Result<(), std::io::Error> {
    generate_to::<Bash, _, _>(&mut app, bin_name, &outdir)?;
    generate_to::<Elvish, _, _>(&mut app, bin_name, &outdir)?;
    generate_to::<Fish, _, _>(&mut app, bin_name, &outdir)?;
    generate_to::<PowerShell, _, _>(&mut app, bin_name, &outdir)?;
    generate_to::<Zsh, _, _>(&mut app, bin_name, &outdir)?;

    Ok(())
}

fn main() -> Result<(), std::io::Error> {
    let out_dir = match env::var("OUT_DIR") {
        Err(_) => return Ok(()),
        Ok(s) => s,
    };

    for (app, name) in [
        (app_ln(), "ln"),
        (app_rmlink(), "rmlink"),
        (app_linfo(), "linfo"),
    ] {
        generate_completions(app, name, &out_dir)?;
    }

    Ok(())
}
