use super::ffi;
use crate::event::VirtualKeyCode;
use libc;

pub fn keysym_to_element(keysym: libc::c_uint) -> Option<VirtualKeyCode> {
    Some(match keysym {
        ffi::XK_BackSpace => VirtualKeyCode::Back,
        ffi::XK_Tab => VirtualKeyCode::Tab,
        //ffi::XK_Linefeed => VirtualKeyCode::Linefeed,
        //ffi::XK_Clear => VirtualKeyCode::Clear,
        ffi::XK_Return => VirtualKeyCode::Return,
        //ffi::XK_Pause => VirtualKeyCode::Pause,
        //ffi::XK_Scroll_Lock => VirtualKeyCode::Scroll_lock,
        //ffi::XK_Sys_Req => VirtualKeyCode::Sys_req,
        ffi::XK_Escape => VirtualKeyCode::Escape,
        ffi::XK_Delete => VirtualKeyCode::Delete,
        ffi::XK_Multi_key => VirtualKeyCode::Compose,
        //ffi::XK_Kanji => VirtualKeyCode::Kanji,
        //ffi::XK_Muhenkan => VirtualKeyCode::Muhenkan,
        //ffi::XK_Henkan_Mode => VirtualKeyCode::Henkan_mode,
        //ffi::XK_Henkan => VirtualKeyCode::Henkan,
        //ffi::XK_Romaji => VirtualKeyCode::Romaji,
        //ffi::XK_Hiragana => VirtualKeyCode::Hiragana,
        //ffi::XK_Katakana => VirtualKeyCode::Katakana,
        //ffi::XK_Hiragana_Katakana => VirtualKeyCode::Hiragana_katakana,
        //ffi::XK_Zenkaku => VirtualKeyCode::Zenkaku,
        //ffi::XK_Hankaku => VirtualKeyCode::Hankaku,
        //ffi::XK_Zenkaku_Hankaku => VirtualKeyCode::Zenkaku_hankaku,
        //ffi::XK_Touroku => VirtualKeyCode::Touroku,
        //ffi::XK_Massyo => VirtualKeyCode::Massyo,
        //ffi::XK_Kana_Lock => VirtualKeyCode::Kana_lock,
        //ffi::XK_Kana_Shift => VirtualKeyCode::Kana_shift,
        //ffi::XK_Eisu_Shift => VirtualKeyCode::Eisu_shift,
        //ffi::XK_Eisu_toggle => VirtualKeyCode::Eisu_toggle,
        ffi::XK_Home => VirtualKeyCode::Home,
        ffi::XK_Left => VirtualKeyCode::Left,
        ffi::XK_Up => VirtualKeyCode::Up,
        ffi::XK_Right => VirtualKeyCode::Right,
        ffi::XK_Down => VirtualKeyCode::Down,
        //ffi::XK_Prior => VirtualKeyCode::Prior,
        ffi::XK_Page_Up => VirtualKeyCode::PageUp,
        //ffi::XK_Next => VirtualKeyCode::Next,
        ffi::XK_Page_Down => VirtualKeyCode::PageDown,
        ffi::XK_End => VirtualKeyCode::End,
        //ffi::XK_Begin => VirtualKeyCode::Begin,
        //ffi::XK_Win_L => VirtualKeyCode::Win_l,
        //ffi::XK_Win_R => VirtualKeyCode::Win_r,
        //ffi::XK_App => VirtualKeyCode::App,
        //ffi::XK_Select => VirtualKeyCode::Select,
        //ffi::XK_Print => VirtualKeyCode::Print,
        //ffi::XK_Execute => VirtualKeyCode::Execute,
        ffi::XK_Insert => VirtualKeyCode::Insert,
        //ffi::XK_Undo => VirtualKeyCode::Undo,
        //ffi::XK_Redo => VirtualKeyCode::Redo,
        //ffi::XK_Menu => VirtualKeyCode::Menu,
        //ffi::XK_Find => VirtualKeyCode::Find,
        //ffi::XK_Cancel => VirtualKeyCode::Cancel,
        //ffi::XK_Help => VirtualKeyCode::Help,
        //ffi::XK_Break => VirtualKeyCode::Break,
        //ffi::XK_Mode_switch => VirtualKeyCode::Mode_switch,
        //ffi::XK_script_switch => VirtualKeyCode::Script_switch,
        //ffi::XK_Num_Lock => VirtualKeyCode::Num_lock,
        //ffi::XK_KP_Space => VirtualKeyCode::Kp_space,
        //ffi::XK_KP_Tab => VirtualKeyCode::Kp_tab,
        //ffi::XK_KP_Enter => VirtualKeyCode::Kp_enter,
        //ffi::XK_KP_F1 => VirtualKeyCode::Kp_f1,
        //ffi::XK_KP_F2 => VirtualKeyCode::Kp_f2,
        //ffi::XK_KP_F3 => VirtualKeyCode::Kp_f3,
        //ffi::XK_KP_F4 => VirtualKeyCode::Kp_f4,
        ffi::XK_KP_Home => VirtualKeyCode::Home,
        ffi::XK_KP_Left => VirtualKeyCode::Left,
        ffi::XK_KP_Up => VirtualKeyCode::Up,
        ffi::XK_KP_Right => VirtualKeyCode::Right,
        ffi::XK_KP_Down => VirtualKeyCode::Down,
        //ffi::XK_KP_Prior => VirtualKeyCode::Kp_prior,
        ffi::XK_KP_Page_Up => VirtualKeyCode::PageUp,
        //ffi::XK_KP_Next => VirtualKeyCode::Kp_next,
        ffi::XK_KP_Page_Down => VirtualKeyCode::PageDown,
        ffi::XK_KP_End => VirtualKeyCode::End,
        //ffi::XK_KP_Begin => VirtualKeyCode::Kp_begin,
        ffi::XK_KP_Insert => VirtualKeyCode::Insert,
        ffi::XK_KP_Delete => VirtualKeyCode::Delete,
        ffi::XK_KP_Equal => VirtualKeyCode::NumpadEquals,
        ffi::XK_KP_Multiply => VirtualKeyCode::NumpadMultiply,
        ffi::XK_KP_Add => VirtualKeyCode::NumpadAdd,
        //ffi::XK_KP_Separator => VirtualKeyCode::Kp_separator,
        ffi::XK_KP_Subtract => VirtualKeyCode::NumpadSubtract,
        ffi::XK_KP_Decimal => VirtualKeyCode::NumpadDecimal,
        ffi::XK_KP_Divide => VirtualKeyCode::NumpadDivide,
        ffi::XK_KP_0 => VirtualKeyCode::Numpad0,
        ffi::XK_KP_1 => VirtualKeyCode::Numpad1,
        ffi::XK_KP_2 => VirtualKeyCode::Numpad2,
        ffi::XK_KP_3 => VirtualKeyCode::Numpad3,
        ffi::XK_KP_4 => VirtualKeyCode::Numpad4,
        ffi::XK_KP_5 => VirtualKeyCode::Numpad5,
        ffi::XK_KP_6 => VirtualKeyCode::Numpad6,
        ffi::XK_KP_7 => VirtualKeyCode::Numpad7,
        ffi::XK_KP_8 => VirtualKeyCode::Numpad8,
        ffi::XK_KP_9 => VirtualKeyCode::Numpad9,
        ffi::XK_F1 => VirtualKeyCode::F1,
        ffi::XK_F2 => VirtualKeyCode::F2,
        ffi::XK_F3 => VirtualKeyCode::F3,
        ffi::XK_F4 => VirtualKeyCode::F4,
        ffi::XK_F5 => VirtualKeyCode::F5,
        ffi::XK_F6 => VirtualKeyCode::F6,
        ffi::XK_F7 => VirtualKeyCode::F7,
        ffi::XK_F8 => VirtualKeyCode::F8,
        ffi::XK_F9 => VirtualKeyCode::F9,
        ffi::XK_F10 => VirtualKeyCode::F10,
        ffi::XK_F11 => VirtualKeyCode::F11,
        //ffi::XK_L1 => VirtualKeyCode::L1,
        ffi::XK_F12 => VirtualKeyCode::F12,
        //ffi::XK_L2 => VirtualKeyCode::L2,
        ffi::XK_F13 => VirtualKeyCode::F13,
        //ffi::XK_L3 => VirtualKeyCode::L3,
        ffi::XK_F14 => VirtualKeyCode::F14,
        //ffi::XK_L4 => VirtualKeyCode::L4,
        ffi::XK_F15 => VirtualKeyCode::F15,
        //ffi::XK_L5 => VirtualKeyCode::L5,
        ffi::XK_F16 => VirtualKeyCode::F16,
        //ffi::XK_L6 => VirtualKeyCode::L6,
        ffi::XK_F17 => VirtualKeyCode::F17,
        //ffi::XK_L7 => VirtualKeyCode::L7,
        ffi::XK_F18 => VirtualKeyCode::F18,
        //ffi::XK_L8 => VirtualKeyCode::L8,
        ffi::XK_F19 => VirtualKeyCode::F19,
        //ffi::XK_L9 => VirtualKeyCode::L9,
        ffi::XK_F20 => VirtualKeyCode::F20,
        //ffi::XK_L10 => VirtualKeyCode::L10,
        ffi::XK_F21 => VirtualKeyCode::F21,
        //ffi::XK_R1 => VirtualKeyCode::R1,
        ffi::XK_F22 => VirtualKeyCode::F22,
        //ffi::XK_R2 => VirtualKeyCode::R2,
        ffi::XK_F23 => VirtualKeyCode::F23,
        //ffi::XK_R3 => VirtualKeyCode::R3,
        ffi::XK_F24 => VirtualKeyCode::F24,
        //ffi::XK_R4 => VirtualKeyCode::R4,
        //ffi::XK_F25 => VirtualKeyCode::F25,
        //ffi::XK_R5 => VirtualKeyCode::R5,
        //ffi::XK_F26 => VirtualKeyCode::F26,
        //ffi::XK_R6 => VirtualKeyCode::R6,
        //ffi::XK_F27 => VirtualKeyCode::F27,
        //ffi::XK_R7 => VirtualKeyCode::R7,
        //ffi::XK_F28 => VirtualKeyCode::F28,
        //ffi::XK_R8 => VirtualKeyCode::R8,
        //ffi::XK_F29 => VirtualKeyCode::F29,
        //ffi::XK_R9 => VirtualKeyCode::R9,
        //ffi::XK_F30 => VirtualKeyCode::F30,
        //ffi::XK_R10 => VirtualKeyCode::R10,
        //ffi::XK_F31 => VirtualKeyCode::F31,
        //ffi::XK_R11 => VirtualKeyCode::R11,
        //ffi::XK_F32 => VirtualKeyCode::F32,
        //ffi::XK_R12 => VirtualKeyCode::R12,
        //ffi::XK_F33 => VirtualKeyCode::F33,
        //ffi::XK_R13 => VirtualKeyCode::R13,
        //ffi::XK_F34 => VirtualKeyCode::F34,
        //ffi::XK_R14 => VirtualKeyCode::R14,
        //ffi::XK_F35 => VirtualKeyCode::F35,
        //ffi::XK_R15 => VirtualKeyCode::R15,
        ffi::XK_Shift_L => VirtualKeyCode::LShift,
        ffi::XK_Shift_R => VirtualKeyCode::RShift,
        ffi::XK_Control_L => VirtualKeyCode::LControl,
        ffi::XK_Control_R => VirtualKeyCode::RControl,
        //ffi::XK_Caps_Lock => VirtualKeyCode::Caps_lock,
        //ffi::XK_Shift_Lock => VirtualKeyCode::Shift_lock,
        //ffi::XK_Meta_L => VirtualKeyCode::Meta_l,
        //ffi::XK_Meta_R => VirtualKeyCode::Meta_r,
        ffi::XK_Alt_L => VirtualKeyCode::LAlt,
        ffi::XK_Alt_R => VirtualKeyCode::RAlt,
        //ffi::XK_Super_L => VirtualKeyCode::Super_l,
        //ffi::XK_Super_R => VirtualKeyCode::Super_r,
        //ffi::XK_Hyper_L => VirtualKeyCode::Hyper_l,
        //ffi::XK_Hyper_R => VirtualKeyCode::Hyper_r,
        ffi::XK_ISO_Left_Tab => VirtualKeyCode::Tab,
        ffi::XK_space => VirtualKeyCode::Space,
        //ffi::XK_exclam => VirtualKeyCode::Exclam,
        //ffi::XK_quotedbl => VirtualKeyCode::Quotedbl,
        //ffi::XK_numbersign => VirtualKeyCode::Numbersign,
        //ffi::XK_dollar => VirtualKeyCode::Dollar,
        //ffi::XK_percent => VirtualKeyCode::Percent,
        //ffi::XK_ampersand => VirtualKeyCode::Ampersand,
        ffi::XK_apostrophe => VirtualKeyCode::Apostrophe,
        //ffi::XK_quoteright => VirtualKeyCode::Quoteright,
        //ffi::XK_parenleft => VirtualKeyCode::Parenleft,
        //ffi::XK_parenright => VirtualKeyCode::Parenright,
        ffi::XK_asterisk => VirtualKeyCode::Asterisk,
        ffi::XK_plus => VirtualKeyCode::Plus,
        ffi::XK_comma => VirtualKeyCode::Comma,
        ffi::XK_minus => VirtualKeyCode::Minus,
        ffi::XK_period => VirtualKeyCode::Period,
        ffi::XK_slash => VirtualKeyCode::Slash,
        ffi::XK_0 => VirtualKeyCode::Key0,
        ffi::XK_1 => VirtualKeyCode::Key1,
        ffi::XK_2 => VirtualKeyCode::Key2,
        ffi::XK_3 => VirtualKeyCode::Key3,
        ffi::XK_4 => VirtualKeyCode::Key4,
        ffi::XK_5 => VirtualKeyCode::Key5,
        ffi::XK_6 => VirtualKeyCode::Key6,
        ffi::XK_7 => VirtualKeyCode::Key7,
        ffi::XK_8 => VirtualKeyCode::Key8,
        ffi::XK_9 => VirtualKeyCode::Key9,
        ffi::XK_colon => VirtualKeyCode::Colon,
        ffi::XK_semicolon => VirtualKeyCode::Semicolon,
        //ffi::XK_less => VirtualKeyCode::Less,
        ffi::XK_equal => VirtualKeyCode::Equals,
        //ffi::XK_greater => VirtualKeyCode::Greater,
        //ffi::XK_question => VirtualKeyCode::Question,
        ffi::XK_at => VirtualKeyCode::At,
        ffi::XK_A => VirtualKeyCode::A,
        ffi::XK_B => VirtualKeyCode::B,
        ffi::XK_C => VirtualKeyCode::C,
        ffi::XK_D => VirtualKeyCode::D,
        ffi::XK_E => VirtualKeyCode::E,
        ffi::XK_F => VirtualKeyCode::F,
        ffi::XK_G => VirtualKeyCode::G,
        ffi::XK_H => VirtualKeyCode::H,
        ffi::XK_I => VirtualKeyCode::I,
        ffi::XK_J => VirtualKeyCode::J,
        ffi::XK_K => VirtualKeyCode::K,
        ffi::XK_L => VirtualKeyCode::L,
        ffi::XK_M => VirtualKeyCode::M,
        ffi::XK_N => VirtualKeyCode::N,
        ffi::XK_O => VirtualKeyCode::O,
        ffi::XK_P => VirtualKeyCode::P,
        ffi::XK_Q => VirtualKeyCode::Q,
        ffi::XK_R => VirtualKeyCode::R,
        ffi::XK_S => VirtualKeyCode::S,
        ffi::XK_T => VirtualKeyCode::T,
        ffi::XK_U => VirtualKeyCode::U,
        ffi::XK_V => VirtualKeyCode::V,
        ffi::XK_W => VirtualKeyCode::W,
        ffi::XK_X => VirtualKeyCode::X,
        ffi::XK_Y => VirtualKeyCode::Y,
        ffi::XK_Z => VirtualKeyCode::Z,
        ffi::XK_bracketleft => VirtualKeyCode::LBracket,
        ffi::XK_backslash => VirtualKeyCode::Backslash,
        ffi::XK_bracketright => VirtualKeyCode::RBracket,
        //ffi::XK_asciicircum => VirtualKeyCode::Asciicircum,
        //ffi::XK_underscore => VirtualKeyCode::Underscore,
        ffi::XK_grave => VirtualKeyCode::Grave,
        //ffi::XK_quoteleft => VirtualKeyCode::Quoteleft,
        ffi::XK_a => VirtualKeyCode::A,
        ffi::XK_b => VirtualKeyCode::B,
        ffi::XK_c => VirtualKeyCode::C,
        ffi::XK_d => VirtualKeyCode::D,
        ffi::XK_e => VirtualKeyCode::E,
        ffi::XK_f => VirtualKeyCode::F,
        ffi::XK_g => VirtualKeyCode::G,
        ffi::XK_h => VirtualKeyCode::H,
        ffi::XK_i => VirtualKeyCode::I,
        ffi::XK_j => VirtualKeyCode::J,
        ffi::XK_k => VirtualKeyCode::K,
        ffi::XK_l => VirtualKeyCode::L,
        ffi::XK_m => VirtualKeyCode::M,
        ffi::XK_n => VirtualKeyCode::N,
        ffi::XK_o => VirtualKeyCode::O,
        ffi::XK_p => VirtualKeyCode::P,
        ffi::XK_q => VirtualKeyCode::Q,
        ffi::XK_r => VirtualKeyCode::R,
        ffi::XK_s => VirtualKeyCode::S,
        ffi::XK_t => VirtualKeyCode::T,
        ffi::XK_u => VirtualKeyCode::U,
        ffi::XK_v => VirtualKeyCode::V,
        ffi::XK_w => VirtualKeyCode::W,
        ffi::XK_x => VirtualKeyCode::X,
        ffi::XK_y => VirtualKeyCode::Y,
        ffi::XK_z => VirtualKeyCode::Z,
        //ffi::XK_braceleft => VirtualKeyCode::Braceleft,
        //ffi::XK_bar => VirtualKeyCode::Bar,
        //ffi::XK_braceright => VirtualKeyCode::Braceright,
        //ffi::XK_asciitilde => VirtualKeyCode::Asciitilde,
        //ffi::XK_nobreakspace => VirtualKeyCode::Nobreakspace,
        //ffi::XK_exclamdown => VirtualKeyCode::Exclamdown,
        //ffi::XK_cent => VirtualKeyCode::Cent,
        //ffi::XK_sterling => VirtualKeyCode::Sterling,
        //ffi::XK_currency => VirtualKeyCode::Currency,
        //ffi::XK_yen => VirtualKeyCode::Yen,
        //ffi::XK_brokenbar => VirtualKeyCode::Brokenbar,
        //ffi::XK_section => VirtualKeyCode::Section,
        //ffi::XK_diaeresis => VirtualKeyCode::Diaeresis,
        //ffi::XK_copyright => VirtualKeyCode::Copyright,
        //ffi::XK_ordfeminine => VirtualKeyCode::Ordfeminine,
        //ffi::XK_guillemotleft => VirtualKeyCode::Guillemotleft,
        //ffi::XK_notsign => VirtualKeyCode::Notsign,
        //ffi::XK_hyphen => VirtualKeyCode::Hyphen,
        //ffi::XK_registered => VirtualKeyCode::Registered,
        //ffi::XK_macron => VirtualKeyCode::Macron,
        //ffi::XK_degree => VirtualKeyCode::Degree,
        //ffi::XK_plusminus => VirtualKeyCode::Plusminus,
        //ffi::XK_twosuperior => VirtualKeyCode::Twosuperior,
        //ffi::XK_threesuperior => VirtualKeyCode::Threesuperior,
        //ffi::XK_acute => VirtualKeyCode::Acute,
        //ffi::XK_mu => VirtualKeyCode::Mu,
        //ffi::XK_paragraph => VirtualKeyCode::Paragraph,
        //ffi::XK_periodcentered => VirtualKeyCode::Periodcentered,
        //ffi::XK_cedilla => VirtualKeyCode::Cedilla,
        //ffi::XK_onesuperior => VirtualKeyCode::Onesuperior,
        //ffi::XK_masculine => VirtualKeyCode::Masculine,
        //ffi::XK_guillemotright => VirtualKeyCode::Guillemotright,
        //ffi::XK_onequarter => VirtualKeyCode::Onequarter,
        //ffi::XK_onehalf => VirtualKeyCode::Onehalf,
        //ffi::XK_threequarters => VirtualKeyCode::Threequarters,
        //ffi::XK_questiondown => VirtualKeyCode::Questiondown,
        //ffi::XK_Agrave => VirtualKeyCode::Agrave,
        //ffi::XK_Aacute => VirtualKeyCode::Aacute,
        //ffi::XK_Acircumflex => VirtualKeyCode::Acircumflex,
        //ffi::XK_Atilde => VirtualKeyCode::Atilde,
        //ffi::XK_Adiaeresis => VirtualKeyCode::Adiaeresis,
        //ffi::XK_Aring => VirtualKeyCode::Aring,
        //ffi::XK_AE => VirtualKeyCode::Ae,
        //ffi::XK_Ccedilla => VirtualKeyCode::Ccedilla,
        //ffi::XK_Egrave => VirtualKeyCode::Egrave,
        //ffi::XK_Eacute => VirtualKeyCode::Eacute,
        //ffi::XK_Ecircumflex => VirtualKeyCode::Ecircumflex,
        //ffi::XK_Ediaeresis => VirtualKeyCode::Ediaeresis,
        //ffi::XK_Igrave => VirtualKeyCode::Igrave,
        //ffi::XK_Iacute => VirtualKeyCode::Iacute,
        //ffi::XK_Icircumflex => VirtualKeyCode::Icircumflex,
        //ffi::XK_Idiaeresis => VirtualKeyCode::Idiaeresis,
        //ffi::XK_ETH => VirtualKeyCode::Eth,
        //ffi::XK_Eth => VirtualKeyCode::Eth,
        //ffi::XK_Ntilde => VirtualKeyCode::Ntilde,
        //ffi::XK_Ograve => VirtualKeyCode::Ograve,
        //ffi::XK_Oacute => VirtualKeyCode::Oacute,
        //ffi::XK_Ocircumflex => VirtualKeyCode::Ocircumflex,
        //ffi::XK_Otilde => VirtualKeyCode::Otilde,
        //ffi::XK_Odiaeresis => VirtualKeyCode::Odiaeresis,
        //ffi::XK_multiply => VirtualKeyCode::Multiply,
        //ffi::XK_Ooblique => VirtualKeyCode::Ooblique,
        //ffi::XK_Ugrave => VirtualKeyCode::Ugrave,
        //ffi::XK_Uacute => VirtualKeyCode::Uacute,
        //ffi::XK_Ucircumflex => VirtualKeyCode::Ucircumflex,
        //ffi::XK_Udiaeresis => VirtualKeyCode::Udiaeresis,
        //ffi::XK_Yacute => VirtualKeyCode::Yacute,
        //ffi::XK_THORN => VirtualKeyCode::Thorn,
        //ffi::XK_Thorn => VirtualKeyCode::Thorn,
        //ffi::XK_ssharp => VirtualKeyCode::Ssharp,
        //ffi::XK_agrave => VirtualKeyCode::Agrave,
        //ffi::XK_aacute => VirtualKeyCode::Aacute,
        //ffi::XK_acircumflex => VirtualKeyCode::Acircumflex,
        //ffi::XK_atilde => VirtualKeyCode::Atilde,
        //ffi::XK_adiaeresis => VirtualKeyCode::Adiaeresis,
        //ffi::XK_aring => VirtualKeyCode::Aring,
        //ffi::XK_ae => VirtualKeyCode::Ae,
        //ffi::XK_ccedilla => VirtualKeyCode::Ccedilla,
        //ffi::XK_egrave => VirtualKeyCode::Egrave,
        //ffi::XK_eacute => VirtualKeyCode::Eacute,
        //ffi::XK_ecircumflex => VirtualKeyCode::Ecircumflex,
        //ffi::XK_ediaeresis => VirtualKeyCode::Ediaeresis,
        //ffi::XK_igrave => VirtualKeyCode::Igrave,
        //ffi::XK_iacute => VirtualKeyCode::Iacute,
        //ffi::XK_icircumflex => VirtualKeyCode::Icircumflex,
        //ffi::XK_idiaeresis => VirtualKeyCode::Idiaeresis,
        //ffi::XK_eth => VirtualKeyCode::Eth,
        //ffi::XK_ntilde => VirtualKeyCode::Ntilde,
        //ffi::XK_ograve => VirtualKeyCode::Ograve,
        //ffi::XK_oacute => VirtualKeyCode::Oacute,
        //ffi::XK_ocircumflex => VirtualKeyCode::Ocircumflex,
        //ffi::XK_otilde => VirtualKeyCode::Otilde,
        //ffi::XK_odiaeresis => VirtualKeyCode::Odiaeresis,
        //ffi::XK_division => VirtualKeyCode::Division,
        //ffi::XK_oslash => VirtualKeyCode::Oslash,
        //ffi::XK_ugrave => VirtualKeyCode::Ugrave,
        //ffi::XK_uacute => VirtualKeyCode::Uacute,
        //ffi::XK_ucircumflex => VirtualKeyCode::Ucircumflex,
        //ffi::XK_udiaeresis => VirtualKeyCode::Udiaeresis,
        //ffi::XK_yacute => VirtualKeyCode::Yacute,
        //ffi::XK_thorn => VirtualKeyCode::Thorn,
        //ffi::XK_ydiaeresis => VirtualKeyCode::Ydiaeresis,
        //ffi::XK_Aogonek => VirtualKeyCode::Aogonek,
        //ffi::XK_breve => VirtualKeyCode::Breve,
        //ffi::XK_Lstroke => VirtualKeyCode::Lstroke,
        //ffi::XK_Lcaron => VirtualKeyCode::Lcaron,
        //ffi::XK_Sacute => VirtualKeyCode::Sacute,
        //ffi::XK_Scaron => VirtualKeyCode::Scaron,
        //ffi::XK_Scedilla => VirtualKeyCode::Scedilla,
        //ffi::XK_Tcaron => VirtualKeyCode::Tcaron,
        //ffi::XK_Zacute => VirtualKeyCode::Zacute,
        //ffi::XK_Zcaron => VirtualKeyCode::Zcaron,
        //ffi::XK_Zabovedot => VirtualKeyCode::Zabovedot,
        //ffi::XK_aogonek => VirtualKeyCode::Aogonek,
        //ffi::XK_ogonek => VirtualKeyCode::Ogonek,
        //ffi::XK_lstroke => VirtualKeyCode::Lstroke,
        //ffi::XK_lcaron => VirtualKeyCode::Lcaron,
        //ffi::XK_sacute => VirtualKeyCode::Sacute,
        //ffi::XK_caron => VirtualKeyCode::Caron,
        //ffi::XK_scaron => VirtualKeyCode::Scaron,
        //ffi::XK_scedilla => VirtualKeyCode::Scedilla,
        //ffi::XK_tcaron => VirtualKeyCode::Tcaron,
        //ffi::XK_zacute => VirtualKeyCode::Zacute,
        //ffi::XK_doubleacute => VirtualKeyCode::Doubleacute,
        //ffi::XK_zcaron => VirtualKeyCode::Zcaron,
        //ffi::XK_zabovedot => VirtualKeyCode::Zabovedot,
        //ffi::XK_Racute => VirtualKeyCode::Racute,
        //ffi::XK_Abreve => VirtualKeyCode::Abreve,
        //ffi::XK_Lacute => VirtualKeyCode::Lacute,
        //ffi::XK_Cacute => VirtualKeyCode::Cacute,
        //ffi::XK_Ccaron => VirtualKeyCode::Ccaron,
        //ffi::XK_Eogonek => VirtualKeyCode::Eogonek,
        //ffi::XK_Ecaron => VirtualKeyCode::Ecaron,
        //ffi::XK_Dcaron => VirtualKeyCode::Dcaron,
        //ffi::XK_Dstroke => VirtualKeyCode::Dstroke,
        //ffi::XK_Nacute => VirtualKeyCode::Nacute,
        //ffi::XK_Ncaron => VirtualKeyCode::Ncaron,
        //ffi::XK_Odoubleacute => VirtualKeyCode::Odoubleacute,
        //ffi::XK_Rcaron => VirtualKeyCode::Rcaron,
        //ffi::XK_Uring => VirtualKeyCode::Uring,
        //ffi::XK_Udoubleacute => VirtualKeyCode::Udoubleacute,
        //ffi::XK_Tcedilla => VirtualKeyCode::Tcedilla,
        //ffi::XK_racute => VirtualKeyCode::Racute,
        //ffi::XK_abreve => VirtualKeyCode::Abreve,
        //ffi::XK_lacute => VirtualKeyCode::Lacute,
        //ffi::XK_cacute => VirtualKeyCode::Cacute,
        //ffi::XK_ccaron => VirtualKeyCode::Ccaron,
        //ffi::XK_eogonek => VirtualKeyCode::Eogonek,
        //ffi::XK_ecaron => VirtualKeyCode::Ecaron,
        //ffi::XK_dcaron => VirtualKeyCode::Dcaron,
        //ffi::XK_dstroke => VirtualKeyCode::Dstroke,
        //ffi::XK_nacute => VirtualKeyCode::Nacute,
        //ffi::XK_ncaron => VirtualKeyCode::Ncaron,
        //ffi::XK_odoubleacute => VirtualKeyCode::Odoubleacute,
        //ffi::XK_udoubleacute => VirtualKeyCode::Udoubleacute,
        //ffi::XK_rcaron => VirtualKeyCode::Rcaron,
        //ffi::XK_uring => VirtualKeyCode::Uring,
        //ffi::XK_tcedilla => VirtualKeyCode::Tcedilla,
        //ffi::XK_abovedot => VirtualKeyCode::Abovedot,
        //ffi::XK_Hstroke => VirtualKeyCode::Hstroke,
        //ffi::XK_Hcircumflex => VirtualKeyCode::Hcircumflex,
        //ffi::XK_Iabovedot => VirtualKeyCode::Iabovedot,
        //ffi::XK_Gbreve => VirtualKeyCode::Gbreve,
        //ffi::XK_Jcircumflex => VirtualKeyCode::Jcircumflex,
        //ffi::XK_hstroke => VirtualKeyCode::Hstroke,
        //ffi::XK_hcircumflex => VirtualKeyCode::Hcircumflex,
        //ffi::XK_idotless => VirtualKeyCode::Idotless,
        //ffi::XK_gbreve => VirtualKeyCode::Gbreve,
        //ffi::XK_jcircumflex => VirtualKeyCode::Jcircumflex,
        //ffi::XK_Cabovedot => VirtualKeyCode::Cabovedot,
        //ffi::XK_Ccircumflex => VirtualKeyCode::Ccircumflex,
        //ffi::XK_Gabovedot => VirtualKeyCode::Gabovedot,
        //ffi::XK_Gcircumflex => VirtualKeyCode::Gcircumflex,
        //ffi::XK_Ubreve => VirtualKeyCode::Ubreve,
        //ffi::XK_Scircumflex => VirtualKeyCode::Scircumflex,
        //ffi::XK_cabovedot => VirtualKeyCode::Cabovedot,
        //ffi::XK_ccircumflex => VirtualKeyCode::Ccircumflex,
        //ffi::XK_gabovedot => VirtualKeyCode::Gabovedot,
        //ffi::XK_gcircumflex => VirtualKeyCode::Gcircumflex,
        //ffi::XK_ubreve => VirtualKeyCode::Ubreve,
        //ffi::XK_scircumflex => VirtualKeyCode::Scircumflex,
        //ffi::XK_kra => VirtualKeyCode::Kra,
        //ffi::XK_kappa => VirtualKeyCode::Kappa,
        //ffi::XK_Rcedilla => VirtualKeyCode::Rcedilla,
        //ffi::XK_Itilde => VirtualKeyCode::Itilde,
        //ffi::XK_Lcedilla => VirtualKeyCode::Lcedilla,
        //ffi::XK_Emacron => VirtualKeyCode::Emacron,
        //ffi::XK_Gcedilla => VirtualKeyCode::Gcedilla,
        //ffi::XK_Tslash => VirtualKeyCode::Tslash,
        //ffi::XK_rcedilla => VirtualKeyCode::Rcedilla,
        //ffi::XK_itilde => VirtualKeyCode::Itilde,
        //ffi::XK_lcedilla => VirtualKeyCode::Lcedilla,
        //ffi::XK_emacron => VirtualKeyCode::Emacron,
        //ffi::XK_gcedilla => VirtualKeyCode::Gcedilla,
        //ffi::XK_tslash => VirtualKeyCode::Tslash,
        //ffi::XK_ENG => VirtualKeyCode::Eng,
        //ffi::XK_eng => VirtualKeyCode::Eng,
        //ffi::XK_Amacron => VirtualKeyCode::Amacron,
        //ffi::XK_Iogonek => VirtualKeyCode::Iogonek,
        //ffi::XK_Eabovedot => VirtualKeyCode::Eabovedot,
        //ffi::XK_Imacron => VirtualKeyCode::Imacron,
        //ffi::XK_Ncedilla => VirtualKeyCode::Ncedilla,
        //ffi::XK_Omacron => VirtualKeyCode::Omacron,
        //ffi::XK_Kcedilla => VirtualKeyCode::Kcedilla,
        //ffi::XK_Uogonek => VirtualKeyCode::Uogonek,
        //ffi::XK_Utilde => VirtualKeyCode::Utilde,
        //ffi::XK_Umacron => VirtualKeyCode::Umacron,
        //ffi::XK_amacron => VirtualKeyCode::Amacron,
        //ffi::XK_iogonek => VirtualKeyCode::Iogonek,
        //ffi::XK_eabovedot => VirtualKeyCode::Eabovedot,
        //ffi::XK_imacron => VirtualKeyCode::Imacron,
        //ffi::XK_ncedilla => VirtualKeyCode::Ncedilla,
        //ffi::XK_omacron => VirtualKeyCode::Omacron,
        //ffi::XK_kcedilla => VirtualKeyCode::Kcedilla,
        //ffi::XK_uogonek => VirtualKeyCode::Uogonek,
        //ffi::XK_utilde => VirtualKeyCode::Utilde,
        //ffi::XK_umacron => VirtualKeyCode::Umacron,
        //ffi::XK_overline => VirtualKeyCode::Overline,
        //ffi::XK_kana_fullstop => VirtualKeyCode::Kana_fullstop,
        //ffi::XK_kana_openingbracket => VirtualKeyCode::Kana_openingbracket,
        //ffi::XK_kana_closingbracket => VirtualKeyCode::Kana_closingbracket,
        //ffi::XK_kana_comma => VirtualKeyCode::Kana_comma,
        //ffi::XK_kana_conjunctive => VirtualKeyCode::Kana_conjunctive,
        //ffi::XK_kana_middledot => VirtualKeyCode::Kana_middledot,
        //ffi::XK_kana_WO => VirtualKeyCode::Kana_wo,
        //ffi::XK_kana_a => VirtualKeyCode::Kana_a,
        //ffi::XK_kana_i => VirtualKeyCode::Kana_i,
        //ffi::XK_kana_u => VirtualKeyCode::Kana_u,
        //ffi::XK_kana_e => VirtualKeyCode::Kana_e,
        //ffi::XK_kana_o => VirtualKeyCode::Kana_o,
        //ffi::XK_kana_ya => VirtualKeyCode::Kana_ya,
        //ffi::XK_kana_yu => VirtualKeyCode::Kana_yu,
        //ffi::XK_kana_yo => VirtualKeyCode::Kana_yo,
        //ffi::XK_kana_tsu => VirtualKeyCode::Kana_tsu,
        //ffi::XK_kana_tu => VirtualKeyCode::Kana_tu,
        //ffi::XK_prolongedsound => VirtualKeyCode::Prolongedsound,
        //ffi::XK_kana_A => VirtualKeyCode::Kana_a,
        //ffi::XK_kana_I => VirtualKeyCode::Kana_i,
        //ffi::XK_kana_U => VirtualKeyCode::Kana_u,
        //ffi::XK_kana_E => VirtualKeyCode::Kana_e,
        //ffi::XK_kana_O => VirtualKeyCode::Kana_o,
        //ffi::XK_kana_KA => VirtualKeyCode::Kana_ka,
        //ffi::XK_kana_KI => VirtualKeyCode::Kana_ki,
        //ffi::XK_kana_KU => VirtualKeyCode::Kana_ku,
        //ffi::XK_kana_KE => VirtualKeyCode::Kana_ke,
        //ffi::XK_kana_KO => VirtualKeyCode::Kana_ko,
        //ffi::XK_kana_SA => VirtualKeyCode::Kana_sa,
        //ffi::XK_kana_SHI => VirtualKeyCode::Kana_shi,
        //ffi::XK_kana_SU => VirtualKeyCode::Kana_su,
        //ffi::XK_kana_SE => VirtualKeyCode::Kana_se,
        //ffi::XK_kana_SO => VirtualKeyCode::Kana_so,
        //ffi::XK_kana_TA => VirtualKeyCode::Kana_ta,
        //ffi::XK_kana_CHI => VirtualKeyCode::Kana_chi,
        //ffi::XK_kana_TI => VirtualKeyCode::Kana_ti,
        //ffi::XK_kana_TSU => VirtualKeyCode::Kana_tsu,
        //ffi::XK_kana_TU => VirtualKeyCode::Kana_tu,
        //ffi::XK_kana_TE => VirtualKeyCode::Kana_te,
        //ffi::XK_kana_TO => VirtualKeyCode::Kana_to,
        //ffi::XK_kana_NA => VirtualKeyCode::Kana_na,
        //ffi::XK_kana_NI => VirtualKeyCode::Kana_ni,
        //ffi::XK_kana_NU => VirtualKeyCode::Kana_nu,
        //ffi::XK_kana_NE => VirtualKeyCode::Kana_ne,
        //ffi::XK_kana_NO => VirtualKeyCode::Kana_no,
        //ffi::XK_kana_HA => VirtualKeyCode::Kana_ha,
        //ffi::XK_kana_HI => VirtualKeyCode::Kana_hi,
        //ffi::XK_kana_FU => VirtualKeyCode::Kana_fu,
        //ffi::XK_kana_HU => VirtualKeyCode::Kana_hu,
        //ffi::XK_kana_HE => VirtualKeyCode::Kana_he,
        //ffi::XK_kana_HO => VirtualKeyCode::Kana_ho,
        //ffi::XK_kana_MA => VirtualKeyCode::Kana_ma,
        //ffi::XK_kana_MI => VirtualKeyCode::Kana_mi,
        //ffi::XK_kana_MU => VirtualKeyCode::Kana_mu,
        //ffi::XK_kana_ME => VirtualKeyCode::Kana_me,
        //ffi::XK_kana_MO => VirtualKeyCode::Kana_mo,
        //ffi::XK_kana_YA => VirtualKeyCode::Kana_ya,
        //ffi::XK_kana_YU => VirtualKeyCode::Kana_yu,
        //ffi::XK_kana_YO => VirtualKeyCode::Kana_yo,
        //ffi::XK_kana_RA => VirtualKeyCode::Kana_ra,
        //ffi::XK_kana_RI => VirtualKeyCode::Kana_ri,
        //ffi::XK_kana_RU => VirtualKeyCode::Kana_ru,
        //ffi::XK_kana_RE => VirtualKeyCode::Kana_re,
        //ffi::XK_kana_RO => VirtualKeyCode::Kana_ro,
        //ffi::XK_kana_WA => VirtualKeyCode::Kana_wa,
        //ffi::XK_kana_N => VirtualKeyCode::Kana_n,
        //ffi::XK_voicedsound => VirtualKeyCode::Voicedsound,
        //ffi::XK_semivoicedsound => VirtualKeyCode::Semivoicedsound,
        //ffi::XK_kana_switch => VirtualKeyCode::Kana_switch,
        //ffi::XK_Arabic_comma => VirtualKeyCode::Arabic_comma,
        //ffi::XK_Arabic_semicolon => VirtualKeyCode::Arabic_semicolon,
        //ffi::XK_Arabic_question_mark => VirtualKeyCode::Arabic_question_mark,
        //ffi::XK_Arabic_hamza => VirtualKeyCode::Arabic_hamza,
        //ffi::XK_Arabic_maddaonalef => VirtualKeyCode::Arabic_maddaonalef,
        //ffi::XK_Arabic_hamzaonalef => VirtualKeyCode::Arabic_hamzaonalef,
        //ffi::XK_Arabic_hamzaonwaw => VirtualKeyCode::Arabic_hamzaonwaw,
        //ffi::XK_Arabic_hamzaunderalef => VirtualKeyCode::Arabic_hamzaunderalef,
        //ffi::XK_Arabic_hamzaonyeh => VirtualKeyCode::Arabic_hamzaonyeh,
        //ffi::XK_Arabic_alef => VirtualKeyCode::Arabic_alef,
        //ffi::XK_Arabic_beh => VirtualKeyCode::Arabic_beh,
        //ffi::XK_Arabic_tehmarbuta => VirtualKeyCode::Arabic_tehmarbuta,
        //ffi::XK_Arabic_teh => VirtualKeyCode::Arabic_teh,
        //ffi::XK_Arabic_theh => VirtualKeyCode::Arabic_theh,
        //ffi::XK_Arabic_jeem => VirtualKeyCode::Arabic_jeem,
        //ffi::XK_Arabic_hah => VirtualKeyCode::Arabic_hah,
        //ffi::XK_Arabic_khah => VirtualKeyCode::Arabic_khah,
        //ffi::XK_Arabic_dal => VirtualKeyCode::Arabic_dal,
        //ffi::XK_Arabic_thal => VirtualKeyCode::Arabic_thal,
        //ffi::XK_Arabic_ra => VirtualKeyCode::Arabic_ra,
        //ffi::XK_Arabic_zain => VirtualKeyCode::Arabic_zain,
        //ffi::XK_Arabic_seen => VirtualKeyCode::Arabic_seen,
        //ffi::XK_Arabic_sheen => VirtualKeyCode::Arabic_sheen,
        //ffi::XK_Arabic_sad => VirtualKeyCode::Arabic_sad,
        //ffi::XK_Arabic_dad => VirtualKeyCode::Arabic_dad,
        //ffi::XK_Arabic_tah => VirtualKeyCode::Arabic_tah,
        //ffi::XK_Arabic_zah => VirtualKeyCode::Arabic_zah,
        //ffi::XK_Arabic_ain => VirtualKeyCode::Arabic_ain,
        //ffi::XK_Arabic_ghain => VirtualKeyCode::Arabic_ghain,
        //ffi::XK_Arabic_tatweel => VirtualKeyCode::Arabic_tatweel,
        //ffi::XK_Arabic_feh => VirtualKeyCode::Arabic_feh,
        //ffi::XK_Arabic_qaf => VirtualKeyCode::Arabic_qaf,
        //ffi::XK_Arabic_kaf => VirtualKeyCode::Arabic_kaf,
        //ffi::XK_Arabic_lam => VirtualKeyCode::Arabic_lam,
        //ffi::XK_Arabic_meem => VirtualKeyCode::Arabic_meem,
        //ffi::XK_Arabic_noon => VirtualKeyCode::Arabic_noon,
        //ffi::XK_Arabic_ha => VirtualKeyCode::Arabic_ha,
        //ffi::XK_Arabic_heh => VirtualKeyCode::Arabic_heh,
        //ffi::XK_Arabic_waw => VirtualKeyCode::Arabic_waw,
        //ffi::XK_Arabic_alefmaksura => VirtualKeyCode::Arabic_alefmaksura,
        //ffi::XK_Arabic_yeh => VirtualKeyCode::Arabic_yeh,
        //ffi::XK_Arabic_fathatan => VirtualKeyCode::Arabic_fathatan,
        //ffi::XK_Arabic_dammatan => VirtualKeyCode::Arabic_dammatan,
        //ffi::XK_Arabic_kasratan => VirtualKeyCode::Arabic_kasratan,
        //ffi::XK_Arabic_fatha => VirtualKeyCode::Arabic_fatha,
        //ffi::XK_Arabic_damma => VirtualKeyCode::Arabic_damma,
        //ffi::XK_Arabic_kasra => VirtualKeyCode::Arabic_kasra,
        //ffi::XK_Arabic_shadda => VirtualKeyCode::Arabic_shadda,
        //ffi::XK_Arabic_sukun => VirtualKeyCode::Arabic_sukun,
        //ffi::XK_Arabic_switch => VirtualKeyCode::Arabic_switch,
        //ffi::XK_Serbian_dje => VirtualKeyCode::Serbian_dje,
        //ffi::XK_Macedonia_gje => VirtualKeyCode::Macedonia_gje,
        //ffi::XK_Cyrillic_io => VirtualKeyCode::Cyrillic_io,
        //ffi::XK_Ukrainian_ie => VirtualKeyCode::Ukrainian_ie,
        //ffi::XK_Ukranian_je => VirtualKeyCode::Ukranian_je,
        //ffi::XK_Macedonia_dse => VirtualKeyCode::Macedonia_dse,
        //ffi::XK_Ukrainian_i => VirtualKeyCode::Ukrainian_i,
        //ffi::XK_Ukranian_i => VirtualKeyCode::Ukranian_i,
        //ffi::XK_Ukrainian_yi => VirtualKeyCode::Ukrainian_yi,
        //ffi::XK_Ukranian_yi => VirtualKeyCode::Ukranian_yi,
        //ffi::XK_Cyrillic_je => VirtualKeyCode::Cyrillic_je,
        //ffi::XK_Serbian_je => VirtualKeyCode::Serbian_je,
        //ffi::XK_Cyrillic_lje => VirtualKeyCode::Cyrillic_lje,
        //ffi::XK_Serbian_lje => VirtualKeyCode::Serbian_lje,
        //ffi::XK_Cyrillic_nje => VirtualKeyCode::Cyrillic_nje,
        //ffi::XK_Serbian_nje => VirtualKeyCode::Serbian_nje,
        //ffi::XK_Serbian_tshe => VirtualKeyCode::Serbian_tshe,
        //ffi::XK_Macedonia_kje => VirtualKeyCode::Macedonia_kje,
        //ffi::XK_Byelorussian_shortu => VirtualKeyCode::Byelorussian_shortu,
        //ffi::XK_Cyrillic_dzhe => VirtualKeyCode::Cyrillic_dzhe,
        //ffi::XK_Serbian_dze => VirtualKeyCode::Serbian_dze,
        //ffi::XK_numerosign => VirtualKeyCode::Numerosign,
        //ffi::XK_Serbian_DJE => VirtualKeyCode::Serbian_dje,
        //ffi::XK_Macedonia_GJE => VirtualKeyCode::Macedonia_gje,
        //ffi::XK_Cyrillic_IO => VirtualKeyCode::Cyrillic_io,
        //ffi::XK_Ukrainian_IE => VirtualKeyCode::Ukrainian_ie,
        //ffi::XK_Ukranian_JE => VirtualKeyCode::Ukranian_je,
        //ffi::XK_Macedonia_DSE => VirtualKeyCode::Macedonia_dse,
        //ffi::XK_Ukrainian_I => VirtualKeyCode::Ukrainian_i,
        //ffi::XK_Ukranian_I => VirtualKeyCode::Ukranian_i,
        //ffi::XK_Ukrainian_YI => VirtualKeyCode::Ukrainian_yi,
        //ffi::XK_Ukranian_YI => VirtualKeyCode::Ukranian_yi,
        //ffi::XK_Cyrillic_JE => VirtualKeyCode::Cyrillic_je,
        //ffi::XK_Serbian_JE => VirtualKeyCode::Serbian_je,
        //ffi::XK_Cyrillic_LJE => VirtualKeyCode::Cyrillic_lje,
        //ffi::XK_Serbian_LJE => VirtualKeyCode::Serbian_lje,
        //ffi::XK_Cyrillic_NJE => VirtualKeyCode::Cyrillic_nje,
        //ffi::XK_Serbian_NJE => VirtualKeyCode::Serbian_nje,
        //ffi::XK_Serbian_TSHE => VirtualKeyCode::Serbian_tshe,
        //ffi::XK_Macedonia_KJE => VirtualKeyCode::Macedonia_kje,
        //ffi::XK_Byelorussian_SHORTU => VirtualKeyCode::Byelorussian_shortu,
        //ffi::XK_Cyrillic_DZHE => VirtualKeyCode::Cyrillic_dzhe,
        //ffi::XK_Serbian_DZE => VirtualKeyCode::Serbian_dze,
        //ffi::XK_Cyrillic_yu => VirtualKeyCode::Cyrillic_yu,
        //ffi::XK_Cyrillic_a => VirtualKeyCode::Cyrillic_a,
        //ffi::XK_Cyrillic_be => VirtualKeyCode::Cyrillic_be,
        //ffi::XK_Cyrillic_tse => VirtualKeyCode::Cyrillic_tse,
        //ffi::XK_Cyrillic_de => VirtualKeyCode::Cyrillic_de,
        //ffi::XK_Cyrillic_ie => VirtualKeyCode::Cyrillic_ie,
        //ffi::XK_Cyrillic_ef => VirtualKeyCode::Cyrillic_ef,
        //ffi::XK_Cyrillic_ghe => VirtualKeyCode::Cyrillic_ghe,
        //ffi::XK_Cyrillic_ha => VirtualKeyCode::Cyrillic_ha,
        //ffi::XK_Cyrillic_i => VirtualKeyCode::Cyrillic_i,
        //ffi::XK_Cyrillic_shorti => VirtualKeyCode::Cyrillic_shorti,
        //ffi::XK_Cyrillic_ka => VirtualKeyCode::Cyrillic_ka,
        //ffi::XK_Cyrillic_el => VirtualKeyCode::Cyrillic_el,
        //ffi::XK_Cyrillic_em => VirtualKeyCode::Cyrillic_em,
        //ffi::XK_Cyrillic_en => VirtualKeyCode::Cyrillic_en,
        //ffi::XK_Cyrillic_o => VirtualKeyCode::Cyrillic_o,
        //ffi::XK_Cyrillic_pe => VirtualKeyCode::Cyrillic_pe,
        //ffi::XK_Cyrillic_ya => VirtualKeyCode::Cyrillic_ya,
        //ffi::XK_Cyrillic_er => VirtualKeyCode::Cyrillic_er,
        //ffi::XK_Cyrillic_es => VirtualKeyCode::Cyrillic_es,
        //ffi::XK_Cyrillic_te => VirtualKeyCode::Cyrillic_te,
        //ffi::XK_Cyrillic_u => VirtualKeyCode::Cyrillic_u,
        //ffi::XK_Cyrillic_zhe => VirtualKeyCode::Cyrillic_zhe,
        //ffi::XK_Cyrillic_ve => VirtualKeyCode::Cyrillic_ve,
        //ffi::XK_Cyrillic_softsign => VirtualKeyCode::Cyrillic_softsign,
        //ffi::XK_Cyrillic_yeru => VirtualKeyCode::Cyrillic_yeru,
        //ffi::XK_Cyrillic_ze => VirtualKeyCode::Cyrillic_ze,
        //ffi::XK_Cyrillic_sha => VirtualKeyCode::Cyrillic_sha,
        //ffi::XK_Cyrillic_e => VirtualKeyCode::Cyrillic_e,
        //ffi::XK_Cyrillic_shcha => VirtualKeyCode::Cyrillic_shcha,
        //ffi::XK_Cyrillic_che => VirtualKeyCode::Cyrillic_che,
        //ffi::XK_Cyrillic_hardsign => VirtualKeyCode::Cyrillic_hardsign,
        //ffi::XK_Cyrillic_YU => VirtualKeyCode::Cyrillic_yu,
        //ffi::XK_Cyrillic_A => VirtualKeyCode::Cyrillic_a,
        //ffi::XK_Cyrillic_BE => VirtualKeyCode::Cyrillic_be,
        //ffi::XK_Cyrillic_TSE => VirtualKeyCode::Cyrillic_tse,
        //ffi::XK_Cyrillic_DE => VirtualKeyCode::Cyrillic_de,
        //ffi::XK_Cyrillic_IE => VirtualKeyCode::Cyrillic_ie,
        //ffi::XK_Cyrillic_EF => VirtualKeyCode::Cyrillic_ef,
        //ffi::XK_Cyrillic_GHE => VirtualKeyCode::Cyrillic_ghe,
        //ffi::XK_Cyrillic_HA => VirtualKeyCode::Cyrillic_ha,
        //ffi::XK_Cyrillic_I => VirtualKeyCode::Cyrillic_i,
        //ffi::XK_Cyrillic_SHORTI => VirtualKeyCode::Cyrillic_shorti,
        //ffi::XK_Cyrillic_KA => VirtualKeyCode::Cyrillic_ka,
        //ffi::XK_Cyrillic_EL => VirtualKeyCode::Cyrillic_el,
        //ffi::XK_Cyrillic_EM => VirtualKeyCode::Cyrillic_em,
        //ffi::XK_Cyrillic_EN => VirtualKeyCode::Cyrillic_en,
        //ffi::XK_Cyrillic_O => VirtualKeyCode::Cyrillic_o,
        //ffi::XK_Cyrillic_PE => VirtualKeyCode::Cyrillic_pe,
        //ffi::XK_Cyrillic_YA => VirtualKeyCode::Cyrillic_ya,
        //ffi::XK_Cyrillic_ER => VirtualKeyCode::Cyrillic_er,
        //ffi::XK_Cyrillic_ES => VirtualKeyCode::Cyrillic_es,
        //ffi::XK_Cyrillic_TE => VirtualKeyCode::Cyrillic_te,
        //ffi::XK_Cyrillic_U => VirtualKeyCode::Cyrillic_u,
        //ffi::XK_Cyrillic_ZHE => VirtualKeyCode::Cyrillic_zhe,
        //ffi::XK_Cyrillic_VE => VirtualKeyCode::Cyrillic_ve,
        //ffi::XK_Cyrillic_SOFTSIGN => VirtualKeyCode::Cyrillic_softsign,
        //ffi::XK_Cyrillic_YERU => VirtualKeyCode::Cyrillic_yeru,
        //ffi::XK_Cyrillic_ZE => VirtualKeyCode::Cyrillic_ze,
        //ffi::XK_Cyrillic_SHA => VirtualKeyCode::Cyrillic_sha,
        //ffi::XK_Cyrillic_E => VirtualKeyCode::Cyrillic_e,
        //ffi::XK_Cyrillic_SHCHA => VirtualKeyCode::Cyrillic_shcha,
        //ffi::XK_Cyrillic_CHE => VirtualKeyCode::Cyrillic_che,
        //ffi::XK_Cyrillic_HARDSIGN => VirtualKeyCode::Cyrillic_hardsign,
        //ffi::XK_Greek_ALPHAaccent => VirtualKeyCode::Greek_alphaaccent,
        //ffi::XK_Greek_EPSILONaccent => VirtualKeyCode::Greek_epsilonaccent,
        //ffi::XK_Greek_ETAaccent => VirtualKeyCode::Greek_etaaccent,
        //ffi::XK_Greek_IOTAaccent => VirtualKeyCode::Greek_iotaaccent,
        //ffi::XK_Greek_IOTAdiaeresis => VirtualKeyCode::Greek_iotadiaeresis,
        //ffi::XK_Greek_OMICRONaccent => VirtualKeyCode::Greek_omicronaccent,
        //ffi::XK_Greek_UPSILONaccent => VirtualKeyCode::Greek_upsilonaccent,
        //ffi::XK_Greek_UPSILONdieresis => VirtualKeyCode::Greek_upsilondieresis,
        //ffi::XK_Greek_OMEGAaccent => VirtualKeyCode::Greek_omegaaccent,
        //ffi::XK_Greek_accentdieresis => VirtualKeyCode::Greek_accentdieresis,
        //ffi::XK_Greek_horizbar => VirtualKeyCode::Greek_horizbar,
        //ffi::XK_Greek_alphaaccent => VirtualKeyCode::Greek_alphaaccent,
        //ffi::XK_Greek_epsilonaccent => VirtualKeyCode::Greek_epsilonaccent,
        //ffi::XK_Greek_etaaccent => VirtualKeyCode::Greek_etaaccent,
        //ffi::XK_Greek_iotaaccent => VirtualKeyCode::Greek_iotaaccent,
        //ffi::XK_Greek_iotadieresis => VirtualKeyCode::Greek_iotadieresis,
        //ffi::XK_Greek_iotaaccentdieresis => VirtualKeyCode::Greek_iotaaccentdieresis,
        //ffi::XK_Greek_omicronaccent => VirtualKeyCode::Greek_omicronaccent,
        //ffi::XK_Greek_upsilonaccent => VirtualKeyCode::Greek_upsilonaccent,
        //ffi::XK_Greek_upsilondieresis => VirtualKeyCode::Greek_upsilondieresis,
        //ffi::XK_Greek_upsilonaccentdieresis => VirtualKeyCode::Greek_upsilonaccentdieresis,
        //ffi::XK_Greek_omegaaccent => VirtualKeyCode::Greek_omegaaccent,
        //ffi::XK_Greek_ALPHA => VirtualKeyCode::Greek_alpha,
        //ffi::XK_Greek_BETA => VirtualKeyCode::Greek_beta,
        //ffi::XK_Greek_GAMMA => VirtualKeyCode::Greek_gamma,
        //ffi::XK_Greek_DELTA => VirtualKeyCode::Greek_delta,
        //ffi::XK_Greek_EPSILON => VirtualKeyCode::Greek_epsilon,
        //ffi::XK_Greek_ZETA => VirtualKeyCode::Greek_zeta,
        //ffi::XK_Greek_ETA => VirtualKeyCode::Greek_eta,
        //ffi::XK_Greek_THETA => VirtualKeyCode::Greek_theta,
        //ffi::XK_Greek_IOTA => VirtualKeyCode::Greek_iota,
        //ffi::XK_Greek_KAPPA => VirtualKeyCode::Greek_kappa,
        //ffi::XK_Greek_LAMDA => VirtualKeyCode::Greek_lamda,
        //ffi::XK_Greek_LAMBDA => VirtualKeyCode::Greek_lambda,
        //ffi::XK_Greek_MU => VirtualKeyCode::Greek_mu,
        //ffi::XK_Greek_NU => VirtualKeyCode::Greek_nu,
        //ffi::XK_Greek_XI => VirtualKeyCode::Greek_xi,
        //ffi::XK_Greek_OMICRON => VirtualKeyCode::Greek_omicron,
        //ffi::XK_Greek_PI => VirtualKeyCode::Greek_pi,
        //ffi::XK_Greek_RHO => VirtualKeyCode::Greek_rho,
        //ffi::XK_Greek_SIGMA => VirtualKeyCode::Greek_sigma,
        //ffi::XK_Greek_TAU => VirtualKeyCode::Greek_tau,
        //ffi::XK_Greek_UPSILON => VirtualKeyCode::Greek_upsilon,
        //ffi::XK_Greek_PHI => VirtualKeyCode::Greek_phi,
        //ffi::XK_Greek_CHI => VirtualKeyCode::Greek_chi,
        //ffi::XK_Greek_PSI => VirtualKeyCode::Greek_psi,
        //ffi::XK_Greek_OMEGA => VirtualKeyCode::Greek_omega,
        //ffi::XK_Greek_alpha => VirtualKeyCode::Greek_alpha,
        //ffi::XK_Greek_beta => VirtualKeyCode::Greek_beta,
        //ffi::XK_Greek_gamma => VirtualKeyCode::Greek_gamma,
        //ffi::XK_Greek_delta => VirtualKeyCode::Greek_delta,
        //ffi::XK_Greek_epsilon => VirtualKeyCode::Greek_epsilon,
        //ffi::XK_Greek_zeta => VirtualKeyCode::Greek_zeta,
        //ffi::XK_Greek_eta => VirtualKeyCode::Greek_eta,
        //ffi::XK_Greek_theta => VirtualKeyCode::Greek_theta,
        //ffi::XK_Greek_iota => VirtualKeyCode::Greek_iota,
        //ffi::XK_Greek_kappa => VirtualKeyCode::Greek_kappa,
        //ffi::XK_Greek_lamda => VirtualKeyCode::Greek_lamda,
        //ffi::XK_Greek_lambda => VirtualKeyCode::Greek_lambda,
        //ffi::XK_Greek_mu => VirtualKeyCode::Greek_mu,
        //ffi::XK_Greek_nu => VirtualKeyCode::Greek_nu,
        //ffi::XK_Greek_xi => VirtualKeyCode::Greek_xi,
        //ffi::XK_Greek_omicron => VirtualKeyCode::Greek_omicron,
        //ffi::XK_Greek_pi => VirtualKeyCode::Greek_pi,
        //ffi::XK_Greek_rho => VirtualKeyCode::Greek_rho,
        //ffi::XK_Greek_sigma => VirtualKeyCode::Greek_sigma,
        //ffi::XK_Greek_finalsmallsigma => VirtualKeyCode::Greek_finalsmallsigma,
        //ffi::XK_Greek_tau => VirtualKeyCode::Greek_tau,
        //ffi::XK_Greek_upsilon => VirtualKeyCode::Greek_upsilon,
        //ffi::XK_Greek_phi => VirtualKeyCode::Greek_phi,
        //ffi::XK_Greek_chi => VirtualKeyCode::Greek_chi,
        //ffi::XK_Greek_psi => VirtualKeyCode::Greek_psi,
        //ffi::XK_Greek_omega => VirtualKeyCode::Greek_omega,
        //ffi::XK_Greek_switch => VirtualKeyCode::Greek_switch,
        //ffi::XK_leftradical => VirtualKeyCode::Leftradical,
        //ffi::XK_topleftradical => VirtualKeyCode::Topleftradical,
        //ffi::XK_horizconnector => VirtualKeyCode::Horizconnector,
        //ffi::XK_topintegral => VirtualKeyCode::Topintegral,
        //ffi::XK_botintegral => VirtualKeyCode::Botintegral,
        //ffi::XK_vertconnector => VirtualKeyCode::Vertconnector,
        //ffi::XK_topleftsqbracket => VirtualKeyCode::Topleftsqbracket,
        //ffi::XK_botleftsqbracket => VirtualKeyCode::Botleftsqbracket,
        //ffi::XK_toprightsqbracket => VirtualKeyCode::Toprightsqbracket,
        //ffi::XK_botrightsqbracket => VirtualKeyCode::Botrightsqbracket,
        //ffi::XK_topleftparens => VirtualKeyCode::Topleftparens,
        //ffi::XK_botleftparens => VirtualKeyCode::Botleftparens,
        //ffi::XK_toprightparens => VirtualKeyCode::Toprightparens,
        //ffi::XK_botrightparens => VirtualKeyCode::Botrightparens,
        //ffi::XK_leftmiddlecurlybrace => VirtualKeyCode::Leftmiddlecurlybrace,
        //ffi::XK_rightmiddlecurlybrace => VirtualKeyCode::Rightmiddlecurlybrace,
        //ffi::XK_topleftsummation => VirtualKeyCode::Topleftsummation,
        //ffi::XK_botleftsummation => VirtualKeyCode::Botleftsummation,
        //ffi::XK_topvertsummationconnector => VirtualKeyCode::Topvertsummationconnector,
        //ffi::XK_botvertsummationconnector => VirtualKeyCode::Botvertsummationconnector,
        //ffi::XK_toprightsummation => VirtualKeyCode::Toprightsummation,
        //ffi::XK_botrightsummation => VirtualKeyCode::Botrightsummation,
        //ffi::XK_rightmiddlesummation => VirtualKeyCode::Rightmiddlesummation,
        //ffi::XK_lessthanequal => VirtualKeyCode::Lessthanequal,
        //ffi::XK_notequal => VirtualKeyCode::Notequal,
        //ffi::XK_greaterthanequal => VirtualKeyCode::Greaterthanequal,
        //ffi::XK_integral => VirtualKeyCode::Integral,
        //ffi::XK_therefore => VirtualKeyCode::Therefore,
        //ffi::XK_variation => VirtualKeyCode::Variation,
        //ffi::XK_infinity => VirtualKeyCode::Infinity,
        //ffi::XK_nabla => VirtualKeyCode::Nabla,
        //ffi::XK_approximate => VirtualKeyCode::Approximate,
        //ffi::XK_similarequal => VirtualKeyCode::Similarequal,
        //ffi::XK_ifonlyif => VirtualKeyCode::Ifonlyif,
        //ffi::XK_implies => VirtualKeyCode::Implies,
        //ffi::XK_identical => VirtualKeyCode::Identical,
        //ffi::XK_radical => VirtualKeyCode::Radical,
        //ffi::XK_includedin => VirtualKeyCode::Includedin,
        //ffi::XK_includes => VirtualKeyCode::Includes,
        //ffi::XK_intersection => VirtualKeyCode::Intersection,
        //ffi::XK_union => VirtualKeyCode::Union,
        //ffi::XK_logicaland => VirtualKeyCode::Logicaland,
        //ffi::XK_logicalor => VirtualKeyCode::Logicalor,
        //ffi::XK_partialderivative => VirtualKeyCode::Partialderivative,
        //ffi::XK_function => VirtualKeyCode::Function,
        //ffi::XK_leftarrow => VirtualKeyCode::Leftarrow,
        //ffi::XK_uparrow => VirtualKeyCode::Uparrow,
        //ffi::XK_rightarrow => VirtualKeyCode::Rightarrow,
        //ffi::XK_downarrow => VirtualKeyCode::Downarrow,
        //ffi::XK_blank => VirtualKeyCode::Blank,
        //ffi::XK_soliddiamond => VirtualKeyCode::Soliddiamond,
        //ffi::XK_checkerboard => VirtualKeyCode::Checkerboard,
        //ffi::XK_ht => VirtualKeyCode::Ht,
        //ffi::XK_ff => VirtualKeyCode::Ff,
        //ffi::XK_cr => VirtualKeyCode::Cr,
        //ffi::XK_lf => VirtualKeyCode::Lf,
        //ffi::XK_nl => VirtualKeyCode::Nl,
        //ffi::XK_vt => VirtualKeyCode::Vt,
        //ffi::XK_lowrightcorner => VirtualKeyCode::Lowrightcorner,
        //ffi::XK_uprightcorner => VirtualKeyCode::Uprightcorner,
        //ffi::XK_upleftcorner => VirtualKeyCode::Upleftcorner,
        //ffi::XK_lowleftcorner => VirtualKeyCode::Lowleftcorner,
        //ffi::XK_crossinglines => VirtualKeyCode::Crossinglines,
        //ffi::XK_horizlinescan1 => VirtualKeyCode::Horizlinescan1,
        //ffi::XK_horizlinescan3 => VirtualKeyCode::Horizlinescan3,
        //ffi::XK_horizlinescan5 => VirtualKeyCode::Horizlinescan5,
        //ffi::XK_horizlinescan7 => VirtualKeyCode::Horizlinescan7,
        //ffi::XK_horizlinescan9 => VirtualKeyCode::Horizlinescan9,
        //ffi::XK_leftt => VirtualKeyCode::Leftt,
        //ffi::XK_rightt => VirtualKeyCode::Rightt,
        //ffi::XK_bott => VirtualKeyCode::Bott,
        //ffi::XK_topt => VirtualKeyCode::Topt,
        //ffi::XK_vertbar => VirtualKeyCode::Vertbar,
        //ffi::XK_emspace => VirtualKeyCode::Emspace,
        //ffi::XK_enspace => VirtualKeyCode::Enspace,
        //ffi::XK_em3space => VirtualKeyCode::Em3space,
        //ffi::XK_em4space => VirtualKeyCode::Em4space,
        //ffi::XK_digitspace => VirtualKeyCode::Digitspace,
        //ffi::XK_punctspace => VirtualKeyCode::Punctspace,
        //ffi::XK_thinspace => VirtualKeyCode::Thinspace,
        //ffi::XK_hairspace => VirtualKeyCode::Hairspace,
        //ffi::XK_emdash => VirtualKeyCode::Emdash,
        //ffi::XK_endash => VirtualKeyCode::Endash,
        //ffi::XK_signifblank => VirtualKeyCode::Signifblank,
        //ffi::XK_ellipsis => VirtualKeyCode::Ellipsis,
        //ffi::XK_doubbaselinedot => VirtualKeyCode::Doubbaselinedot,
        //ffi::XK_onethird => VirtualKeyCode::Onethird,
        //ffi::XK_twothirds => VirtualKeyCode::Twothirds,
        //ffi::XK_onefifth => VirtualKeyCode::Onefifth,
        //ffi::XK_twofifths => VirtualKeyCode::Twofifths,
        //ffi::XK_threefifths => VirtualKeyCode::Threefifths,
        //ffi::XK_fourfifths => VirtualKeyCode::Fourfifths,
        //ffi::XK_onesixth => VirtualKeyCode::Onesixth,
        //ffi::XK_fivesixths => VirtualKeyCode::Fivesixths,
        //ffi::XK_careof => VirtualKeyCode::Careof,
        //ffi::XK_figdash => VirtualKeyCode::Figdash,
        //ffi::XK_leftanglebracket => VirtualKeyCode::Leftanglebracket,
        //ffi::XK_decimalpoint => VirtualKeyCode::Decimalpoint,
        //ffi::XK_rightanglebracket => VirtualKeyCode::Rightanglebracket,
        //ffi::XK_marker => VirtualKeyCode::Marker,
        //ffi::XK_oneeighth => VirtualKeyCode::Oneeighth,
        //ffi::XK_threeeighths => VirtualKeyCode::Threeeighths,
        //ffi::XK_fiveeighths => VirtualKeyCode::Fiveeighths,
        //ffi::XK_seveneighths => VirtualKeyCode::Seveneighths,
        //ffi::XK_trademark => VirtualKeyCode::Trademark,
        //ffi::XK_signaturemark => VirtualKeyCode::Signaturemark,
        //ffi::XK_trademarkincircle => VirtualKeyCode::Trademarkincircle,
        //ffi::XK_leftopentriangle => VirtualKeyCode::Leftopentriangle,
        //ffi::XK_rightopentriangle => VirtualKeyCode::Rightopentriangle,
        //ffi::XK_emopencircle => VirtualKeyCode::Emopencircle,
        //ffi::XK_emopenrectangle => VirtualKeyCode::Emopenrectangle,
        //ffi::XK_leftsinglequotemark => VirtualKeyCode::Leftsinglequotemark,
        //ffi::XK_rightsinglequotemark => VirtualKeyCode::Rightsinglequotemark,
        //ffi::XK_leftdoublequotemark => VirtualKeyCode::Leftdoublequotemark,
        //ffi::XK_rightdoublequotemark => VirtualKeyCode::Rightdoublequotemark,
        //ffi::XK_prescription => VirtualKeyCode::Prescription,
        //ffi::XK_minutes => VirtualKeyCode::Minutes,
        //ffi::XK_seconds => VirtualKeyCode::Seconds,
        //ffi::XK_latincross => VirtualKeyCode::Latincross,
        //ffi::XK_hexagram => VirtualKeyCode::Hexagram,
        //ffi::XK_filledrectbullet => VirtualKeyCode::Filledrectbullet,
        //ffi::XK_filledlefttribullet => VirtualKeyCode::Filledlefttribullet,
        //ffi::XK_filledrighttribullet => VirtualKeyCode::Filledrighttribullet,
        //ffi::XK_emfilledcircle => VirtualKeyCode::Emfilledcircle,
        //ffi::XK_emfilledrect => VirtualKeyCode::Emfilledrect,
        //ffi::XK_enopencircbullet => VirtualKeyCode::Enopencircbullet,
        //ffi::XK_enopensquarebullet => VirtualKeyCode::Enopensquarebullet,
        //ffi::XK_openrectbullet => VirtualKeyCode::Openrectbullet,
        //ffi::XK_opentribulletup => VirtualKeyCode::Opentribulletup,
        //ffi::XK_opentribulletdown => VirtualKeyCode::Opentribulletdown,
        //ffi::XK_openstar => VirtualKeyCode::Openstar,
        //ffi::XK_enfilledcircbullet => VirtualKeyCode::Enfilledcircbullet,
        //ffi::XK_enfilledsqbullet => VirtualKeyCode::Enfilledsqbullet,
        //ffi::XK_filledtribulletup => VirtualKeyCode::Filledtribulletup,
        //ffi::XK_filledtribulletdown => VirtualKeyCode::Filledtribulletdown,
        //ffi::XK_leftpointer => VirtualKeyCode::Leftpointer,
        //ffi::XK_rightpointer => VirtualKeyCode::Rightpointer,
        //ffi::XK_club => VirtualKeyCode::Club,
        //ffi::XK_diamond => VirtualKeyCode::Diamond,
        //ffi::XK_heart => VirtualKeyCode::Heart,
        //ffi::XK_maltesecross => VirtualKeyCode::Maltesecross,
        //ffi::XK_dagger => VirtualKeyCode::Dagger,
        //ffi::XK_doubledagger => VirtualKeyCode::Doubledagger,
        //ffi::XK_checkmark => VirtualKeyCode::Checkmark,
        //ffi::XK_ballotcross => VirtualKeyCode::Ballotcross,
        //ffi::XK_musicalsharp => VirtualKeyCode::Musicalsharp,
        //ffi::XK_musicalflat => VirtualKeyCode::Musicalflat,
        //ffi::XK_malesymbol => VirtualKeyCode::Malesymbol,
        //ffi::XK_femalesymbol => VirtualKeyCode::Femalesymbol,
        //ffi::XK_telephone => VirtualKeyCode::Telephone,
        //ffi::XK_telephonerecorder => VirtualKeyCode::Telephonerecorder,
        //ffi::XK_phonographcopyright => VirtualKeyCode::Phonographcopyright,
        //ffi::XK_caret => VirtualKeyCode::Caret,
        //ffi::XK_singlelowquotemark => VirtualKeyCode::Singlelowquotemark,
        //ffi::XK_doublelowquotemark => VirtualKeyCode::Doublelowquotemark,
        //ffi::XK_cursor => VirtualKeyCode::Cursor,
        //ffi::XK_leftcaret => VirtualKeyCode::Leftcaret,
        //ffi::XK_rightcaret => VirtualKeyCode::Rightcaret,
        //ffi::XK_downcaret => VirtualKeyCode::Downcaret,
        //ffi::XK_upcaret => VirtualKeyCode::Upcaret,
        //ffi::XK_overbar => VirtualKeyCode::Overbar,
        //ffi::XK_downtack => VirtualKeyCode::Downtack,
        //ffi::XK_upshoe => VirtualKeyCode::Upshoe,
        //ffi::XK_downstile => VirtualKeyCode::Downstile,
        //ffi::XK_underbar => VirtualKeyCode::Underbar,
        //ffi::XK_jot => VirtualKeyCode::Jot,
        //ffi::XK_quad => VirtualKeyCode::Quad,
        //ffi::XK_uptack => VirtualKeyCode::Uptack,
        //ffi::XK_circle => VirtualKeyCode::Circle,
        //ffi::XK_upstile => VirtualKeyCode::Upstile,
        //ffi::XK_downshoe => VirtualKeyCode::Downshoe,
        //ffi::XK_rightshoe => VirtualKeyCode::Rightshoe,
        //ffi::XK_leftshoe => VirtualKeyCode::Leftshoe,
        //ffi::XK_lefttack => VirtualKeyCode::Lefttack,
        //ffi::XK_righttack => VirtualKeyCode::Righttack,
        //ffi::XK_hebrew_doublelowline => VirtualKeyCode::Hebrew_doublelowline,
        //ffi::XK_hebrew_aleph => VirtualKeyCode::Hebrew_aleph,
        //ffi::XK_hebrew_bet => VirtualKeyCode::Hebrew_bet,
        //ffi::XK_hebrew_beth => VirtualKeyCode::Hebrew_beth,
        //ffi::XK_hebrew_gimel => VirtualKeyCode::Hebrew_gimel,
        //ffi::XK_hebrew_gimmel => VirtualKeyCode::Hebrew_gimmel,
        //ffi::XK_hebrew_dalet => VirtualKeyCode::Hebrew_dalet,
        //ffi::XK_hebrew_daleth => VirtualKeyCode::Hebrew_daleth,
        //ffi::XK_hebrew_he => VirtualKeyCode::Hebrew_he,
        //ffi::XK_hebrew_waw => VirtualKeyCode::Hebrew_waw,
        //ffi::XK_hebrew_zain => VirtualKeyCode::Hebrew_zain,
        //ffi::XK_hebrew_zayin => VirtualKeyCode::Hebrew_zayin,
        //ffi::XK_hebrew_chet => VirtualKeyCode::Hebrew_chet,
        //ffi::XK_hebrew_het => VirtualKeyCode::Hebrew_het,
        //ffi::XK_hebrew_tet => VirtualKeyCode::Hebrew_tet,
        //ffi::XK_hebrew_teth => VirtualKeyCode::Hebrew_teth,
        //ffi::XK_hebrew_yod => VirtualKeyCode::Hebrew_yod,
        //ffi::XK_hebrew_finalkaph => VirtualKeyCode::Hebrew_finalkaph,
        //ffi::XK_hebrew_kaph => VirtualKeyCode::Hebrew_kaph,
        //ffi::XK_hebrew_lamed => VirtualKeyCode::Hebrew_lamed,
        //ffi::XK_hebrew_finalmem => VirtualKeyCode::Hebrew_finalmem,
        //ffi::XK_hebrew_mem => VirtualKeyCode::Hebrew_mem,
        //ffi::XK_hebrew_finalnun => VirtualKeyCode::Hebrew_finalnun,
        //ffi::XK_hebrew_nun => VirtualKeyCode::Hebrew_nun,
        //ffi::XK_hebrew_samech => VirtualKeyCode::Hebrew_samech,
        //ffi::XK_hebrew_samekh => VirtualKeyCode::Hebrew_samekh,
        //ffi::XK_hebrew_ayin => VirtualKeyCode::Hebrew_ayin,
        //ffi::XK_hebrew_finalpe => VirtualKeyCode::Hebrew_finalpe,
        //ffi::XK_hebrew_pe => VirtualKeyCode::Hebrew_pe,
        //ffi::XK_hebrew_finalzade => VirtualKeyCode::Hebrew_finalzade,
        //ffi::XK_hebrew_finalzadi => VirtualKeyCode::Hebrew_finalzadi,
        //ffi::XK_hebrew_zade => VirtualKeyCode::Hebrew_zade,
        //ffi::XK_hebrew_zadi => VirtualKeyCode::Hebrew_zadi,
        //ffi::XK_hebrew_qoph => VirtualKeyCode::Hebrew_qoph,
        //ffi::XK_hebrew_kuf => VirtualKeyCode::Hebrew_kuf,
        //ffi::XK_hebrew_resh => VirtualKeyCode::Hebrew_resh,
        //ffi::XK_hebrew_shin => VirtualKeyCode::Hebrew_shin,
        //ffi::XK_hebrew_taw => VirtualKeyCode::Hebrew_taw,
        //ffi::XK_hebrew_taf => VirtualKeyCode::Hebrew_taf,
        //ffi::XK_Hebrew_switch => VirtualKeyCode::Hebrew_switch,
        ffi::XF86XK_Back => VirtualKeyCode::NavigateBackward,
        ffi::XF86XK_Forward => VirtualKeyCode::NavigateForward,
        ffi::XF86XK_Copy => VirtualKeyCode::Copy,
        ffi::XF86XK_Paste => VirtualKeyCode::Paste,
        ffi::XF86XK_Cut => VirtualKeyCode::Cut,
        _ => return None,
    })
}
