#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Win32_System_Search_Common")]
pub mod Common;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ACCESS_MASKENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_EXCLUSIVE: ACCESS_MASKENUM = ACCESS_MASKENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_READDESIGN: ACCESS_MASKENUM = ACCESS_MASKENUM(1024i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_WRITEDESIGN: ACCESS_MASKENUM = ACCESS_MASKENUM(2048i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_WITHGRANT: ACCESS_MASKENUM = ACCESS_MASKENUM(4096i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_REFERENCE: ACCESS_MASKENUM = ACCESS_MASKENUM(8192i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_CREATE: ACCESS_MASKENUM = ACCESS_MASKENUM(16384i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_INSERT: ACCESS_MASKENUM = ACCESS_MASKENUM(32768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_DELETE: ACCESS_MASKENUM = ACCESS_MASKENUM(65536i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_READCONTROL: ACCESS_MASKENUM = ACCESS_MASKENUM(131072i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_WRITEPERMISSIONS: ACCESS_MASKENUM = ACCESS_MASKENUM(262144i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_WRITEOWNER: ACCESS_MASKENUM = ACCESS_MASKENUM(524288i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_MAXIMUM_ALLOWED: ACCESS_MASKENUM = ACCESS_MASKENUM(33554432i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_ALL: ACCESS_MASKENUM = ACCESS_MASKENUM(268435456i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_EXECUTE: ACCESS_MASKENUM = ACCESS_MASKENUM(536870912i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_READ: ACCESS_MASKENUM = ACCESS_MASKENUM(-2147483648i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_UPDATE: ACCESS_MASKENUM = ACCESS_MASKENUM(1073741824i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const PERM_DROP: ACCESS_MASKENUM = ACCESS_MASKENUM(256i32);
impl ::core::marker::Copy for ACCESS_MASKENUM {}
impl ::core::clone::Clone for ACCESS_MASKENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ACCESS_MASKENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ACCESS_MASKENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for ACCESS_MASKENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ACCESS_MASKENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct AUTHENTICATION_INFO {
    pub dwSize: u32,
    pub atAuthenticationType: AUTH_TYPE,
    pub pcwszUser: ::windows::core::PCWSTR,
    pub pcwszPassword: ::windows::core::PCWSTR,
}
impl ::core::marker::Copy for AUTHENTICATION_INFO {}
impl ::core::clone::Clone for AUTHENTICATION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AUTHENTICATION_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUTHENTICATION_INFO").field("dwSize", &self.dwSize).field("atAuthenticationType", &self.atAuthenticationType).field("pcwszUser", &self.pcwszUser).field("pcwszPassword", &self.pcwszPassword).finish()
    }
}
unsafe impl ::windows::core::Abi for AUTHENTICATION_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AUTHENTICATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AUTHENTICATION_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for AUTHENTICATION_INFO {}
impl ::core::default::Default for AUTHENTICATION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct AUTH_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const eAUTH_TYPE_ANONYMOUS: AUTH_TYPE = AUTH_TYPE(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const eAUTH_TYPE_NTLM: AUTH_TYPE = AUTH_TYPE(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const eAUTH_TYPE_BASIC: AUTH_TYPE = AUTH_TYPE(2i32);
impl ::core::marker::Copy for AUTH_TYPE {}
impl ::core::clone::Clone for AUTH_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AUTH_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AUTH_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for AUTH_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AUTH_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP6xFILEFMT: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPABORT: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPBATCH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_ACP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_OEMCP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_RAW: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILEFMT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFIRST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTS: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTSA: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTSW: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPKEEPIDENTITY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPKEEPNULLS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPLAST: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPMAXERRS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPODBC: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPTEXTFILE: u32 = 14u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPUNICODEFILE: u32 = 13u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_COLLATION: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_COLLATION_ID: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_DATA_LEN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_INDICATOR_LEN: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_SERVER_COL: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_TERMINATOR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_ROWSET: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_XTRANSACTION: i32 = 2i32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct BUCKETCATEGORIZE {
    pub cBuckets: u32,
    pub Distribution: u32,
}
impl ::core::marker::Copy for BUCKETCATEGORIZE {}
impl ::core::clone::Clone for BUCKETCATEGORIZE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BUCKETCATEGORIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BUCKETCATEGORIZE").field("cBuckets", &self.cBuckets).field("Distribution", &self.Distribution).finish()
    }
}
unsafe impl ::windows::core::Abi for BUCKETCATEGORIZE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BUCKETCATEGORIZE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BUCKETCATEGORIZE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BUCKETCATEGORIZE {}
impl ::core::default::Default for BUCKETCATEGORIZE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BUCKET_EXPONENTIAL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BUCKET_LINEAR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CASE_REQUIREMENT(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CASE_REQUIREMENT_ANY: CASE_REQUIREMENT = CASE_REQUIREMENT(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CASE_REQUIREMENT_UPPER_IF_AQS: CASE_REQUIREMENT = CASE_REQUIREMENT(1i32);
impl ::core::marker::Copy for CASE_REQUIREMENT {}
impl ::core::clone::Clone for CASE_REQUIREMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CASE_REQUIREMENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CASE_REQUIREMENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for CASE_REQUIREMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CASE_REQUIREMENT").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CATEGORIZATION {
    pub ulCatType: u32,
    pub Anonymous: CATEGORIZATION_0,
    pub csColumns: COLUMNSET,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATION {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATION>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub union CATEGORIZATION_0 {
    pub cClusters: u32,
    pub bucket: BUCKETCATEGORIZE,
    pub range: RANGECATEGORIZE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATION_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATION_0 {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATION_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATION_0>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATION_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CATEGORIZATIONSET {
    pub cCat: u32,
    pub aCat: *mut CATEGORIZATION,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATIONSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATIONSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::fmt::Debug for CATEGORIZATIONSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CATEGORIZATIONSET").field("cCat", &self.cCat).field("aCat", &self.aCat).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATIONSET {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATIONSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATIONSET>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATIONSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATIONSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_BUCKETS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_CLUSTER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_RANGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_UNIQUE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_COLLATOR: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_GATHERER: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_INDEXER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_SEARCH: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBBMKDISPIDS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBCOLDISPIDS: u32 = 28u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBSELFDISPIDS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CERT_E_NOT_FOUND_OR_NO_PERMISSSION: i32 = -2147211263i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CHANNEL_AGENT_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CHANNEL_AGENT_DYNAMIC_SCHEDULE: CHANNEL_AGENT_FLAGS = CHANNEL_AGENT_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CHANNEL_AGENT_PRECACHE_SOME: CHANNEL_AGENT_FLAGS = CHANNEL_AGENT_FLAGS(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CHANNEL_AGENT_PRECACHE_ALL: CHANNEL_AGENT_FLAGS = CHANNEL_AGENT_FLAGS(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CHANNEL_AGENT_PRECACHE_SCRNSAVER: CHANNEL_AGENT_FLAGS = CHANNEL_AGENT_FLAGS(8i32);
impl ::core::marker::Copy for CHANNEL_AGENT_FLAGS {}
impl ::core::clone::Clone for CHANNEL_AGENT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CHANNEL_AGENT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CHANNEL_AGENT_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CHANNEL_AGENT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CHANNEL_AGENT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_CORRUPT_FWIDX: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473491i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_DIACRITIC_SETTINGS_DIFFER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473490i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_INCONSISTENT_TRANSACTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473486i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_INVALID_CATALOG_LIST_VERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215313i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_MULTIPLE_PROTECTED_USERS_UNSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473483i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215318i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_CATALOG_MANAGER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473487i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_PROTECTED_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473484i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_NON_INTERACTIVE_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473481i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_NOT_AVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473485i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_SID_MISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473482i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_CATALOG_RESET: ::windows::core::HRESULT = ::windows::core::HRESULT(268336i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_CLIENT_REQUESTED_ABORT: ::windows::core::HRESULT = ::windows::core::HRESULT(268331i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_NEW_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(268329i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_RETRY_DOCUMENT: ::windows::core::HRESULT = ::windows::core::HRESULT(268332i32);
pub const CLSID_DataShapeProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3449a1c8_c56c_11d0_ad72_00c04fc29863);
pub const CLSID_MSDASQL: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cb_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSDASQL_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cd_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSPersist: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c07e0d0_4418_11d2_9212_00c04fbbbfb3);
pub const CLSID_SQLOLEDB: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c7ff16c_38e3_11d0_97ab_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdfa22b8e_e68d_11d0_97e4_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ERROR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0932c62_38e5_11d0_97ab_00c04fc2ad98);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSION_REASON(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CLUSIONREASON_UNKNOWNSCOPE: CLUSION_REASON = CLUSION_REASON(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CLUSIONREASON_DEFAULT: CLUSION_REASON = CLUSION_REASON(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CLUSIONREASON_USER: CLUSION_REASON = CLUSION_REASON(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CLUSIONREASON_GROUPPOLICY: CLUSION_REASON = CLUSION_REASON(3i32);
impl ::core::marker::Copy for CLUSION_REASON {}
impl ::core::clone::Clone for CLUSION_REASON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSION_REASON {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSION_REASON {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSION_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSION_REASON").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_ALREADY_INIT: i32 = -2147216123i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_NOT_INIT: i32 = -2147216124i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_NUM_PARAMS: i32 = -2147216122i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_PARAM_SIZE: i32 = -2147216125i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_PAREN: i32 = -2147216126i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_UNEXPECTED: i32 = -2147216127i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_CONNECTIONTIMEOUT: i32 = -2147219963i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_DATASOURCENOTAVAILABLE: i32 = -2147219964i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_INSUFFICIENTBUFFER: i32 = -2147219957i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_INVALIDDATASOURCE: i32 = -2147219959i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_NOQUERYCONNECTIONS: i32 = -2147219965i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_REGISTRY: i32 = -2147219960i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_SERVERNOTFOUND: i32 = -2147219962i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TIMEOUT: i32 = -2147219958i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TOOMANYDATASERVERS: i32 = -2147219967i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TOOMANYDATASOURCES: i32 = -2147219966i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_S_NODATASERVERS: i32 = 263687i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BADRESULT: i32 = -2147220218i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BADSEQUENCE: i32 = -2147220223i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BUFFERTOOSMALL: i32 = -2147220220i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_DUPLICATEDBID: i32 = -2147220216i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_INCOMPATIBLECOLUMNS: i32 = -2147220221i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_MAXCONNEXCEEDED: i32 = -2147220213i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NODEFAULTCATALOG: i32 = -2147220214i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NOMOREDATA: i32 = -2147220222i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NOSORTCOLUMN: i32 = -2147220217i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_TOOMANYMERGECOLUMNS: i32 = -2147220215i32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct COLUMNSET {
    pub cCol: u32,
    pub aCol: *mut super::super::Storage::IndexServer::FULLPROPSPEC,
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for COLUMNSET {}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for COLUMNSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::fmt::Debug for COLUMNSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("COLUMNSET").field("cCol", &self.cCol).field("aCol", &self.aCol).finish()
    }
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for COLUMNSET {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for COLUMNSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<COLUMNSET>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for COLUMNSET {}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for COLUMNSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CONDITION_CREATION_OPTIONS(pub u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_DEFAULT: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(0u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_NONE: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(0u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_SIMPLIFY: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(1u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_VECTOR_AND: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(2u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_VECTOR_OR: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(4u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_VECTOR_LEAF: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(8u32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONDITION_CREATION_USE_CONTENT_LOCALE: CONDITION_CREATION_OPTIONS = CONDITION_CREATION_OPTIONS(16u32);
impl ::core::marker::Copy for CONDITION_CREATION_OPTIONS {}
impl ::core::clone::Clone for CONDITION_CREATION_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CONDITION_CREATION_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CONDITION_CREATION_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CONDITION_CREATION_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CONDITION_CREATION_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for CONDITION_CREATION_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CONDITION_CREATION_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CONDITION_CREATION_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CONDITION_CREATION_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CONDITION_CREATION_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CONTENTRESTRICTION {
    pub prop: super::super::Storage::IndexServer::FULLPROPSPEC,
    pub pwcsPhrase: ::windows::core::PWSTR,
    pub lcid: u32,
    pub ulGenerateMethod: u32,
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CONTENTRESTRICTION {}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CONTENTRESTRICTION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CONTENTRESTRICTION {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CONTENTRESTRICTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CONTENTRESTRICTION>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CONTENTRESTRICTION {}
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CONTENTRESTRICTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_CONTENT_CLASS_READ: i32 = -2147208188i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_CONTENT_SOURCE_COLUMN_TYPE: i32 = -2147208185i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_NULL_CONTENT_CLASS_BSTR: i32 = -2147208186i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_NULL_URI: i32 = -2147208183i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_OUT_OF_RANGE: i32 = -2147208184i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_BAD_VECTOR_SIZE: i32 = -2147208189i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_READ: i32 = -2147208191i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_EXCEPTION: i32 = -2147208187i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_NULL_POINTER: i32 = -2147208190i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYDISPIDS: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYMETADISPIDS: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYPROPERTY: u32 = 64u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREATESUBSCRIPTIONFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CREATESUBS_ADDTOFAVORITES: CREATESUBSCRIPTIONFLAGS = CREATESUBSCRIPTIONFLAGS(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CREATESUBS_FROMFAVORITES: CREATESUBSCRIPTIONFLAGS = CREATESUBSCRIPTIONFLAGS(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CREATESUBS_NOUI: CREATESUBSCRIPTIONFLAGS = CREATESUBSCRIPTIONFLAGS(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CREATESUBS_NOSAVE: CREATESUBSCRIPTIONFLAGS = CREATESUBSCRIPTIONFLAGS(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CREATESUBS_SOFTWAREUPDATE: CREATESUBSCRIPTIONFLAGS = CREATESUBSCRIPTIONFLAGS(16i32);
impl ::core::marker::Copy for CREATESUBSCRIPTIONFLAGS {}
impl ::core::clone::Clone for CREATESUBSCRIPTIONFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREATESUBSCRIPTIONFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREATESUBSCRIPTIONFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREATESUBSCRIPTIONFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREATESUBSCRIPTIONFLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_ASSERTIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CATALOGS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS_BY_TABLE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLLATIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMNS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_INDEXES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_LINKEDSERVERS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECTS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURES: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_SCHEMATA: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_STATISTICS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES_INFO: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_STATISTICS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TRANSLATIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TRUSTEE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEWS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_ACTIONS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_COMMANDS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_CUBES: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_DIMENSIONS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_FUNCTIONS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_HIERARCHIES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_LEVELS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_MEASURES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_MEMBERS: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_PROPERTIES: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_SETS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CSTORAGEPROPERTY: u32 = 23u32;
pub const CSearchLanguageSupport: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6a68cc80_4337_4dbc_bd27_fbfb1053820b);
pub const CSearchManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d096c5f_ac08_4f1f_beb7_5c22c517ce39);
pub const CSearchRoot: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x30766bd2_ea1c_4f28_bf27_0b44e2f68db7);
pub const CSearchScopeRule: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe63de750_3bd7_4be5_9c84_6b4281988c44);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CatalogPausedReason(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_NONE: CatalogPausedReason = CatalogPausedReason(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_HIGH_IO: CatalogPausedReason = CatalogPausedReason(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_HIGH_CPU: CatalogPausedReason = CatalogPausedReason(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_HIGH_NTF_RATE: CatalogPausedReason = CatalogPausedReason(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_LOW_BATTERY: CatalogPausedReason = CatalogPausedReason(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_LOW_MEMORY: CatalogPausedReason = CatalogPausedReason(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_LOW_DISK: CatalogPausedReason = CatalogPausedReason(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_DELAYED_RECOVERY: CatalogPausedReason = CatalogPausedReason(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_USER_ACTIVE: CatalogPausedReason = CatalogPausedReason(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_EXTERNAL: CatalogPausedReason = CatalogPausedReason(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_PAUSED_REASON_UPGRADING: CatalogPausedReason = CatalogPausedReason(10i32);
impl ::core::marker::Copy for CatalogPausedReason {}
impl ::core::clone::Clone for CatalogPausedReason {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CatalogPausedReason {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CatalogPausedReason {
    type Abi = Self;
}
impl ::core::fmt::Debug for CatalogPausedReason {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CatalogPausedReason").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CatalogStatus(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_IDLE: CatalogStatus = CatalogStatus(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_PAUSED: CatalogStatus = CatalogStatus(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_RECOVERING: CatalogStatus = CatalogStatus(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_FULL_CRAWL: CatalogStatus = CatalogStatus(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_INCREMENTAL_CRAWL: CatalogStatus = CatalogStatus(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_PROCESSING_NOTIFICATIONS: CatalogStatus = CatalogStatus(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATALOG_STATUS_SHUTTING_DOWN: CatalogStatus = CatalogStatus(6i32);
impl ::core::marker::Copy for CatalogStatus {}
impl ::core::clone::Clone for CatalogStatus {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CatalogStatus {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CatalogStatus {
    type Abi = Self;
}
impl ::core::fmt::Debug for CatalogStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CatalogStatus").field(&self.0).finish()
    }
}
pub const CompoundCondition: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x116f8d13_101e_4fa5_84d4_ff8279381935);
pub const ConditionFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe03e85b0_7be3_4000_ba98_6c13de9fa486);
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct DATE_STRUCT {
    pub year: i16,
    pub month: u16,
    pub day: u16,
}
impl ::core::marker::Copy for DATE_STRUCT {}
impl ::core::clone::Clone for DATE_STRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DATE_STRUCT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DATE_STRUCT").field("year", &self.year).field("month", &self.month).field("day", &self.day).finish()
    }
}
unsafe impl ::windows::core::Abi for DATE_STRUCT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DATE_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DATE_STRUCT>()) == 0 }
    }
}
impl ::core::cmp::Eq for DATE_STRUCT {}
impl ::core::default::Default for DATE_STRUCT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBACCESSORFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_INVALID: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_PASSBYREF: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_ROWDATA: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_PARAMETERDATA: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_OPTIMIZED: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBACCESSOR_INHERITED: DBACCESSORFLAGSENUM = DBACCESSORFLAGSENUM(16i32);
impl ::core::marker::Copy for DBACCESSORFLAGSENUM {}
impl ::core::clone::Clone for DBACCESSORFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBACCESSORFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBACCESSORFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBACCESSORFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBACCESSORFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBASYNCHOPENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBASYNCHOP_OPEN: DBASYNCHOPENUM = DBASYNCHOPENUM(0i32);
impl ::core::marker::Copy for DBASYNCHOPENUM {}
impl ::core::clone::Clone for DBASYNCHOPENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBASYNCHOPENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBASYNCHOPENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBASYNCHOPENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBASYNCHOPENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBASYNCHPHASEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBASYNCHPHASE_INITIALIZATION: DBASYNCHPHASEENUM = DBASYNCHPHASEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBASYNCHPHASE_POPULATION: DBASYNCHPHASEENUM = DBASYNCHPHASEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBASYNCHPHASE_COMPLETE: DBASYNCHPHASEENUM = DBASYNCHPHASEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBASYNCHPHASE_CANCELED: DBASYNCHPHASEENUM = DBASYNCHPHASEENUM(3i32);
impl ::core::marker::Copy for DBASYNCHPHASEENUM {}
impl ::core::clone::Clone for DBASYNCHPHASEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBASYNCHPHASEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBASYNCHPHASEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBASYNCHPHASEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBASYNCHPHASEENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBBINDEXT {
    pub pExtension: *mut u8,
    pub ulExtension: usize,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBBINDEXT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBBINDEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBBINDEXT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBBINDEXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDEXT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBBINDEXT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBBINDEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBBINDEXT {
    pub pExtension: *mut u8,
    pub ulExtension: usize,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBBINDEXT {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBBINDEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBBINDEXT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBBINDEXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDEXT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBBINDEXT {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBBINDEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBBINDFLAGENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDFLAG_HTML: DBBINDFLAGENUM = DBBINDFLAGENUM(1i32);
impl ::core::marker::Copy for DBBINDFLAGENUM {}
impl ::core::clone::Clone for DBBINDFLAGENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBBINDFLAGENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBBINDFLAGENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBBINDFLAGENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBBINDFLAGENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
pub struct DBBINDING {
    pub iOrdinal: usize,
    pub obValue: usize,
    pub obLength: usize,
    pub obStatus: usize,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub pObject: *mut DBOBJECT,
    pub pBindExt: *mut DBBINDEXT,
    pub dwPart: u32,
    pub dwMemOwner: u32,
    pub eParamIO: u32,
    pub cbMaxLen: usize,
    pub dwFlags: u32,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DBBINDING {
    fn clone(&self) -> Self {
        Self {
            iOrdinal: self.iOrdinal,
            obValue: self.obValue,
            obLength: self.obLength,
            obStatus: self.obStatus,
            pTypeInfo: self.pTypeInfo.clone(),
            pObject: self.pObject,
            pBindExt: self.pBindExt,
            dwPart: self.dwPart,
            dwMemOwner: self.dwMemOwner,
            eParamIO: self.eParamIO,
            cbMaxLen: self.cbMaxLen,
            dwFlags: self.dwFlags,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBBINDING {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBBINDING {
    fn eq(&self, other: &Self) -> bool {
        self.iOrdinal == other.iOrdinal && self.obValue == other.obValue && self.obLength == other.obLength && self.obStatus == other.obStatus && self.pTypeInfo == other.pTypeInfo && self.pObject == other.pObject && self.pBindExt == other.pBindExt && self.dwPart == other.dwPart && self.dwMemOwner == other.dwMemOwner && self.eParamIO == other.eParamIO && self.cbMaxLen == other.cbMaxLen && self.dwFlags == other.dwFlags && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBBINDING {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBBINDING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
pub struct DBBINDING {
    pub iOrdinal: usize,
    pub obValue: usize,
    pub obLength: usize,
    pub obStatus: usize,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub pObject: *mut DBOBJECT,
    pub pBindExt: *mut DBBINDEXT,
    pub dwPart: u32,
    pub dwMemOwner: u32,
    pub eParamIO: u32,
    pub cbMaxLen: usize,
    pub dwFlags: u32,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBBINDING {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBBINDING {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDING>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBBINDING {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBBINDING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBBINDSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_OK: DBBINDSTATUSENUM = DBBINDSTATUSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_BADORDINAL: DBBINDSTATUSENUM = DBBINDSTATUSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_UNSUPPORTEDCONVERSION: DBBINDSTATUSENUM = DBBINDSTATUSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_BADBINDINFO: DBBINDSTATUSENUM = DBBINDSTATUSENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_BADSTORAGEFLAGS: DBBINDSTATUSENUM = DBBINDSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_NOINTERFACE: DBBINDSTATUSENUM = DBBINDSTATUSENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDSTATUS_MULTIPLESTORAGE: DBBINDSTATUSENUM = DBBINDSTATUSENUM(6i32);
impl ::core::marker::Copy for DBBINDSTATUSENUM {}
impl ::core::clone::Clone for DBBINDSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBBINDSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBBINDSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBBINDSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBBINDSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBBINDURLFLAGENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_READ: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_WRITE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_READWRITE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_SHARE_DENY_READ: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_SHARE_DENY_WRITE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_SHARE_EXCLUSIVE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_SHARE_DENY_NONE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_ASYNCHRONOUS: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(4096i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_COLLECTION: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(8192i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_DELAYFETCHSTREAM: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(16384i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_DELAYFETCHCOLUMNS: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(32768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_RECURSIVE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(4194304i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_OUTPUT: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(8388608i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_WAITFORINIT: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(16777216i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_OPENIFEXISTS: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(33554432i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_OVERWRITE: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(67108864i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLFLAG_ISSTRUCTUREDDOCUMENT: DBBINDURLFLAGENUM = DBBINDURLFLAGENUM(134217728i32);
impl ::core::marker::Copy for DBBINDURLFLAGENUM {}
impl ::core::clone::Clone for DBBINDURLFLAGENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBBINDURLFLAGENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBBINDURLFLAGENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBBINDURLFLAGENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBBINDURLFLAGENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBBINDURLSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLSTATUS_S_OK: DBBINDURLSTATUSENUM = DBBINDURLSTATUSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLSTATUS_S_DENYNOTSUPPORTED: DBBINDURLSTATUSENUM = DBBINDURLSTATUSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLSTATUS_S_DENYTYPENOTSUPPORTED: DBBINDURLSTATUSENUM = DBBINDURLSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBINDURLSTATUS_S_REDIRECTED: DBBINDURLSTATUSENUM = DBBINDURLSTATUSENUM(8i32);
impl ::core::marker::Copy for DBBINDURLSTATUSENUM {}
impl ::core::clone::Clone for DBBINDURLSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBBINDURLSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBBINDURLSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBBINDURLSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBBINDURLSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBBOOKMARK(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBMK_INVALID: DBBOOKMARK = DBBOOKMARK(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBMK_FIRST: DBBOOKMARK = DBBOOKMARK(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBBMK_LAST: DBBOOKMARK = DBBOOKMARK(2i32);
impl ::core::marker::Copy for DBBOOKMARK {}
impl ::core::clone::Clone for DBBOOKMARK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBBOOKMARK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBBOOKMARK {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBBOOKMARK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBBOOKMARK").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
pub struct DBCOLUMNACCESS {
    pub pData: *mut ::core::ffi::c_void,
    pub columnid: super::super::Storage::IndexServer::DBID,
    pub cbDataLen: usize,
    pub dwStatus: u32,
    pub cbMaxLen: usize,
    pub dwReserved: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::marker::Copy for DBCOLUMNACCESS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::clone::Clone for DBCOLUMNACCESS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
unsafe impl ::windows::core::Abi for DBCOLUMNACCESS {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::PartialEq for DBCOLUMNACCESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNACCESS>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::Eq for DBCOLUMNACCESS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::default::Default for DBCOLUMNACCESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
pub struct DBCOLUMNACCESS {
    pub pData: *mut ::core::ffi::c_void,
    pub columnid: super::super::Storage::IndexServer::DBID,
    pub cbDataLen: usize,
    pub dwStatus: u32,
    pub cbMaxLen: usize,
    pub dwReserved: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::marker::Copy for DBCOLUMNACCESS {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::clone::Clone for DBCOLUMNACCESS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
unsafe impl ::windows::core::Abi for DBCOLUMNACCESS {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::PartialEq for DBCOLUMNACCESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNACCESS>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::Eq for DBCOLUMNACCESS {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::default::Default for DBCOLUMNACCESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCOLUMNDESC {
    pub pwszTypeName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub rgPropertySets: *mut DBPROPSET,
    pub pclsid: *mut ::windows::core::GUID,
    pub cPropertySets: u32,
    pub ulColumnSize: usize,
    pub dbcid: super::super::Storage::IndexServer::DBID,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCOLUMNDESC {
    fn clone(&self) -> Self {
        Self {
            pwszTypeName: self.pwszTypeName,
            pTypeInfo: self.pTypeInfo.clone(),
            rgPropertySets: self.rgPropertySets,
            pclsid: self.pclsid,
            cPropertySets: self.cPropertySets,
            ulColumnSize: self.ulColumnSize,
            dbcid: self.dbcid,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCOLUMNDESC {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        self.pwszTypeName == other.pwszTypeName && self.pTypeInfo == other.pTypeInfo && self.rgPropertySets == other.rgPropertySets && self.pclsid == other.pclsid && self.cPropertySets == other.cPropertySets && self.ulColumnSize == other.ulColumnSize && self.dbcid == other.dbcid && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCOLUMNDESC {
    pub pwszTypeName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub rgPropertySets: *mut DBPROPSET,
    pub pclsid: *mut ::windows::core::GUID,
    pub cPropertySets: u32,
    pub ulColumnSize: usize,
    pub dbcid: super::super::Storage::IndexServer::DBID,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCOLUMNDESC {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNDESCFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_TYPENAME: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_ITYPEINFO: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_PROPERTIES: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_CLSID: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_COLSIZE: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_DBCID: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(32i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_WTYPE: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_PRECISION: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNDESCFLAGS_SCALE: DBCOLUMNDESCFLAGSENUM = DBCOLUMNDESCFLAGSENUM(256i32);
impl ::core::marker::Copy for DBCOLUMNDESCFLAGSENUM {}
impl ::core::clone::Clone for DBCOLUMNDESCFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNDESCFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNDESCFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNDESCFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNDESCFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNFLAGS15ENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISCHAPTER: DBCOLUMNFLAGS15ENUM = DBCOLUMNFLAGS15ENUM(8192i32);
impl ::core::marker::Copy for DBCOLUMNFLAGS15ENUM {}
impl ::core::clone::Clone for DBCOLUMNFLAGS15ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNFLAGS15ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNFLAGS15ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNFLAGS15ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNFLAGS15ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISBOOKMARK: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_MAYDEFER: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_WRITE: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_WRITEUNKNOWN: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISFIXEDLENGTH: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISNULLABLE: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(32i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_MAYBENULL: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISLONG: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISROWID: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISROWVER: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_CACHEDEFERRED: DBCOLUMNFLAGSENUM = DBCOLUMNFLAGSENUM(4096i32);
impl ::core::marker::Copy for DBCOLUMNFLAGSENUM {}
impl ::core::clone::Clone for DBCOLUMNFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNFLAGSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_SCALEISNEGATIVE: DBCOLUMNFLAGSENUM20 = DBCOLUMNFLAGSENUM20(16384i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_RESERVED: DBCOLUMNFLAGSENUM20 = DBCOLUMNFLAGSENUM20(32768i32);
impl ::core::marker::Copy for DBCOLUMNFLAGSENUM20 {}
impl ::core::clone::Clone for DBCOLUMNFLAGSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNFLAGSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNFLAGSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNFLAGSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNFLAGSENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNFLAGSENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISROWURL: DBCOLUMNFLAGSENUM21 = DBCOLUMNFLAGSENUM21(65536i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISDEFAULTSTREAM: DBCOLUMNFLAGSENUM21 = DBCOLUMNFLAGSENUM21(131072i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISCOLLECTION: DBCOLUMNFLAGSENUM21 = DBCOLUMNFLAGSENUM21(262144i32);
impl ::core::marker::Copy for DBCOLUMNFLAGSENUM21 {}
impl ::core::clone::Clone for DBCOLUMNFLAGSENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNFLAGSENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNFLAGSENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNFLAGSENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNFLAGSENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOLUMNFLAGSENUM26(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISSTREAM: DBCOLUMNFLAGSENUM26 = DBCOLUMNFLAGSENUM26(524288i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISROWSET: DBCOLUMNFLAGSENUM26 = DBCOLUMNFLAGSENUM26(1048576i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ISROW: DBCOLUMNFLAGSENUM26 = DBCOLUMNFLAGSENUM26(2097152i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOLUMNFLAGS_ROWSPECIFICCOLUMN: DBCOLUMNFLAGSENUM26 = DBCOLUMNFLAGSENUM26(4194304i32);
impl ::core::marker::Copy for DBCOLUMNFLAGSENUM26 {}
impl ::core::clone::Clone for DBCOLUMNFLAGSENUM26 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOLUMNFLAGSENUM26 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOLUMNFLAGSENUM26 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOLUMNFLAGSENUM26 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOLUMNFLAGSENUM26").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
pub struct DBCOLUMNINFO {
    pub pwszName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub iOrdinal: usize,
    pub dwFlags: u32,
    pub ulColumnSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
    pub columnid: super::super::Storage::IndexServer::DBID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::clone::Clone for DBCOLUMNINFO {
    fn clone(&self) -> Self {
        Self {
            pwszName: self.pwszName,
            pTypeInfo: self.pTypeInfo.clone(),
            iOrdinal: self.iOrdinal,
            dwFlags: self.dwFlags,
            ulColumnSize: self.ulColumnSize,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
            columnid: self.columnid,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBCOLUMNINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBCOLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszName == other.pwszName && self.pTypeInfo == other.pTypeInfo && self.iOrdinal == other.iOrdinal && self.dwFlags == other.dwFlags && self.ulColumnSize == other.ulColumnSize && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale && self.columnid == other.columnid
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBCOLUMNINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBCOLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
pub struct DBCOLUMNINFO {
    pub pwszName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub iOrdinal: usize,
    pub dwFlags: u32,
    pub ulColumnSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
    pub columnid: super::super::Storage::IndexServer::DBID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBCOLUMNINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBCOLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBCOLUMNINFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBCOLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOMMANDPERSISTFLAGENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMMANDPERSISTFLAG_NOSAVE: DBCOMMANDPERSISTFLAGENUM = DBCOMMANDPERSISTFLAGENUM(1i32);
impl ::core::marker::Copy for DBCOMMANDPERSISTFLAGENUM {}
impl ::core::clone::Clone for DBCOMMANDPERSISTFLAGENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOMMANDPERSISTFLAGENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOMMANDPERSISTFLAGENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOMMANDPERSISTFLAGENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOMMANDPERSISTFLAGENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOMMANDPERSISTFLAGENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMMANDPERSISTFLAG_DEFAULT: DBCOMMANDPERSISTFLAGENUM21 = DBCOMMANDPERSISTFLAGENUM21(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMMANDPERSISTFLAG_PERSISTVIEW: DBCOMMANDPERSISTFLAGENUM21 = DBCOMMANDPERSISTFLAGENUM21(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMMANDPERSISTFLAG_PERSISTPROCEDURE: DBCOMMANDPERSISTFLAGENUM21 = DBCOMMANDPERSISTFLAGENUM21(4i32);
impl ::core::marker::Copy for DBCOMMANDPERSISTFLAGENUM21 {}
impl ::core::clone::Clone for DBCOMMANDPERSISTFLAGENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOMMANDPERSISTFLAGENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOMMANDPERSISTFLAGENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOMMANDPERSISTFLAGENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOMMANDPERSISTFLAGENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOMPAREENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPARE_LT: DBCOMPAREENUM = DBCOMPAREENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPARE_EQ: DBCOMPAREENUM = DBCOMPAREENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPARE_GT: DBCOMPAREENUM = DBCOMPAREENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPARE_NE: DBCOMPAREENUM = DBCOMPAREENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPARE_NOTCOMPARABLE: DBCOMPAREENUM = DBCOMPAREENUM(4i32);
impl ::core::marker::Copy for DBCOMPAREENUM {}
impl ::core::clone::Clone for DBCOMPAREENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOMPAREENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOMPAREENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOMPAREENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOMPAREENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOMPAREOPSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_LT: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_LE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_EQ: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_GE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_GT: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_BEGINSWITH: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_CONTAINS: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_NE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_IGNORE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_CASESENSITIVE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(4096i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_CASEINSENSITIVE: DBCOMPAREOPSENUM = DBCOMPAREOPSENUM(8192i32);
impl ::core::marker::Copy for DBCOMPAREOPSENUM {}
impl ::core::clone::Clone for DBCOMPAREOPSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOMPAREOPSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOMPAREOPSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOMPAREOPSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOMPAREOPSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOMPAREOPSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_NOTBEGINSWITH: DBCOMPAREOPSENUM20 = DBCOMPAREOPSENUM20(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPAREOPS_NOTCONTAINS: DBCOMPAREOPSENUM20 = DBCOMPAREOPSENUM20(10i32);
impl ::core::marker::Copy for DBCOMPAREOPSENUM20 {}
impl ::core::clone::Clone for DBCOMPAREOPSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOMPAREOPSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOMPAREOPSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOMPAREOPSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOMPAREOPSENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_COMPUTED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_DYNAMIC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_NOTCOMPUTED: u32 = 3u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCONSTRAINTDESC {
    pub pConstraintID: *mut super::super::Storage::IndexServer::DBID,
    pub ConstraintType: u32,
    pub cColumns: usize,
    pub rgColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pReferencedTableID: *mut super::super::Storage::IndexServer::DBID,
    pub cForeignKeyColumns: usize,
    pub rgForeignKeyColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pwszConstraintText: ::windows::core::PWSTR,
    pub UpdateRule: u32,
    pub DeleteRule: u32,
    pub MatchType: u32,
    pub Deferrability: u32,
    pub cReserved: usize,
    pub rgReserved: *mut DBPROPSET,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBCONSTRAINTDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCONSTRAINTDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCONSTRAINTDESC {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCONSTRAINTDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCONSTRAINTDESC>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCONSTRAINTDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCONSTRAINTDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCONSTRAINTDESC {
    pub pConstraintID: *mut super::super::Storage::IndexServer::DBID,
    pub ConstraintType: u32,
    pub cColumns: usize,
    pub rgColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pReferencedTableID: *mut super::super::Storage::IndexServer::DBID,
    pub cForeignKeyColumns: usize,
    pub rgForeignKeyColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pwszConstraintText: ::windows::core::PWSTR,
    pub UpdateRule: u32,
    pub DeleteRule: u32,
    pub MatchType: u32,
    pub Deferrability: u32,
    pub cReserved: usize,
    pub rgReserved: *mut DBPROPSET,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBCONSTRAINTDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCONSTRAINTDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCONSTRAINTDESC {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCONSTRAINTDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCONSTRAINTDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCONSTRAINTDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCONSTRAINTDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCONSTRAINTTYPEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONSTRAINTTYPE_UNIQUE: DBCONSTRAINTTYPEENUM = DBCONSTRAINTTYPEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONSTRAINTTYPE_FOREIGNKEY: DBCONSTRAINTTYPEENUM = DBCONSTRAINTTYPEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONSTRAINTTYPE_PRIMARYKEY: DBCONSTRAINTTYPEENUM = DBCONSTRAINTTYPEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONSTRAINTTYPE_CHECK: DBCONSTRAINTTYPEENUM = DBCONSTRAINTTYPEENUM(3i32);
impl ::core::marker::Copy for DBCONSTRAINTTYPEENUM {}
impl ::core::clone::Clone for DBCONSTRAINTTYPEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCONSTRAINTTYPEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCONSTRAINTTYPEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCONSTRAINTTYPEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCONSTRAINTTYPEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCONVERTFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONVERTFLAGS_COLUMN: DBCONVERTFLAGSENUM = DBCONVERTFLAGSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONVERTFLAGS_PARAMETER: DBCONVERTFLAGSENUM = DBCONVERTFLAGSENUM(1i32);
impl ::core::marker::Copy for DBCONVERTFLAGSENUM {}
impl ::core::clone::Clone for DBCONVERTFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCONVERTFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCONVERTFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCONVERTFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCONVERTFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCONVERTFLAGSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONVERTFLAGS_ISLONG: DBCONVERTFLAGSENUM20 = DBCONVERTFLAGSENUM20(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONVERTFLAGS_ISFIXEDLENGTH: DBCONVERTFLAGSENUM20 = DBCONVERTFLAGSENUM20(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCONVERTFLAGS_FROMVARIANT: DBCONVERTFLAGSENUM20 = DBCONVERTFLAGSENUM20(8i32);
impl ::core::marker::Copy for DBCONVERTFLAGSENUM20 {}
impl ::core::clone::Clone for DBCONVERTFLAGSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCONVERTFLAGSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCONVERTFLAGSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCONVERTFLAGSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCONVERTFLAGSENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOPYFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOPY_ASYNC: DBCOPYFLAGSENUM = DBCOPYFLAGSENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOPY_REPLACE_EXISTING: DBCOPYFLAGSENUM = DBCOPYFLAGSENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOPY_ALLOW_EMULATION: DBCOPYFLAGSENUM = DBCOPYFLAGSENUM(1024i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOPY_NON_RECURSIVE: DBCOPYFLAGSENUM = DBCOPYFLAGSENUM(2048i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOPY_ATOMIC: DBCOPYFLAGSENUM = DBCOPYFLAGSENUM(4096i32);
impl ::core::marker::Copy for DBCOPYFLAGSENUM {}
impl ::core::clone::Clone for DBCOPYFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOPYFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOPYFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOPYFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOPYFLAGSENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBCOST {
    pub eKind: u32,
    pub dwUnits: u32,
    pub lValue: i32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBCOST {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBCOST {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBCOST {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBCOST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOST>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBCOST {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBCOST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBCOST {
    pub eKind: u32,
    pub dwUnits: u32,
    pub lValue: i32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBCOST {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBCOST {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBCOST {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBCOST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOST>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBCOST {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBCOST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBCOSTUNITENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_INVALID: DBCOSTUNITENUM = DBCOSTUNITENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_WEIGHT: DBCOSTUNITENUM = DBCOSTUNITENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_PERCENT: DBCOSTUNITENUM = DBCOSTUNITENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MAXIMUM: DBCOSTUNITENUM = DBCOSTUNITENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MINIMUM: DBCOSTUNITENUM = DBCOSTUNITENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MICRO_SECOND: DBCOSTUNITENUM = DBCOSTUNITENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MILLI_SECOND: DBCOSTUNITENUM = DBCOSTUNITENUM(32i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_SECOND: DBCOSTUNITENUM = DBCOSTUNITENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MINUTE: DBCOSTUNITENUM = DBCOSTUNITENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_HOUR: DBCOSTUNITENUM = DBCOSTUNITENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_BYTE: DBCOSTUNITENUM = DBCOSTUNITENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_KILO_BYTE: DBCOSTUNITENUM = DBCOSTUNITENUM(1024i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_MEGA_BYTE: DBCOSTUNITENUM = DBCOSTUNITENUM(2048i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_GIGA_BYTE: DBCOSTUNITENUM = DBCOSTUNITENUM(4096i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_NUM_MSGS: DBCOSTUNITENUM = DBCOSTUNITENUM(8192i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_NUM_LOCKS: DBCOSTUNITENUM = DBCOSTUNITENUM(16384i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_NUM_ROWS: DBCOSTUNITENUM = DBCOSTUNITENUM(32768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUNIT_OTHER: DBCOSTUNITENUM = DBCOSTUNITENUM(65536i32);
impl ::core::marker::Copy for DBCOSTUNITENUM {}
impl ::core::clone::Clone for DBCOSTUNITENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBCOSTUNITENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBCOSTUNITENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBCOSTUNITENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBCOSTUNITENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBDATACONVERTENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDATACONVERT_DEFAULT: DBDATACONVERTENUM = DBDATACONVERTENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDATACONVERT_SETDATABEHAVIOR: DBDATACONVERTENUM = DBDATACONVERTENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDATACONVERT_LENGTHFROMNTS: DBDATACONVERTENUM = DBDATACONVERTENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDATACONVERT_DSTISFIXEDLENGTH: DBDATACONVERTENUM = DBDATACONVERTENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDATACONVERT_DECIMALSCALE: DBDATACONVERTENUM = DBDATACONVERTENUM(8i32);
impl ::core::marker::Copy for DBDATACONVERTENUM {}
impl ::core::clone::Clone for DBDATACONVERTENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBDATACONVERTENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBDATACONVERTENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBDATACONVERTENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBDATACONVERTENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct DBDATE {
    pub year: i16,
    pub month: u16,
    pub day: u16,
}
impl ::core::marker::Copy for DBDATE {}
impl ::core::clone::Clone for DBDATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DBDATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBDATE").field("year", &self.year).field("month", &self.month).field("day", &self.day).finish()
    }
}
unsafe impl ::windows::core::Abi for DBDATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DBDATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBDATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for DBDATE {}
impl ::core::default::Default for DBDATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBDEFERRABILITYENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDEFERRABILITY_DEFERRED: DBDEFERRABILITYENUM = DBDEFERRABILITYENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDEFERRABILITY_DEFERRABLE: DBDEFERRABILITYENUM = DBDEFERRABILITYENUM(2i32);
impl ::core::marker::Copy for DBDEFERRABILITYENUM {}
impl ::core::clone::Clone for DBDEFERRABILITYENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBDEFERRABILITYENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBDEFERRABILITYENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBDEFERRABILITYENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBDEFERRABILITYENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBDELETEFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDELETE_ASYNC: DBDELETEFLAGSENUM = DBDELETEFLAGSENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBDELETE_ATOMIC: DBDELETEFLAGSENUM = DBDELETEFLAGSENUM(4096i32);
impl ::core::marker::Copy for DBDELETEFLAGSENUM {}
impl ::core::clone::Clone for DBDELETEFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBDELETEFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBDELETEFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBDELETEFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBDELETEFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBEVENTPHASEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEVENTPHASE_OKTODO: DBEVENTPHASEENUM = DBEVENTPHASEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEVENTPHASE_ABOUTTODO: DBEVENTPHASEENUM = DBEVENTPHASEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEVENTPHASE_SYNCHAFTER: DBEVENTPHASEENUM = DBEVENTPHASEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEVENTPHASE_FAILEDTODO: DBEVENTPHASEENUM = DBEVENTPHASEENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEVENTPHASE_DIDEVENT: DBEVENTPHASEENUM = DBEVENTPHASEENUM(4i32);
impl ::core::marker::Copy for DBEVENTPHASEENUM {}
impl ::core::clone::Clone for DBEVENTPHASEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBEVENTPHASEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBEVENTPHASEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBEVENTPHASEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBEVENTPHASEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBEXECLIMITSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEXECLIMITS_ABORT: DBEXECLIMITSENUM = DBEXECLIMITSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEXECLIMITS_STOP: DBEXECLIMITSENUM = DBEXECLIMITSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBEXECLIMITS_SUSPEND: DBEXECLIMITSENUM = DBEXECLIMITSENUM(3i32);
impl ::core::marker::Copy for DBEXECLIMITSENUM {}
impl ::core::clone::Clone for DBEXECLIMITSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBEXECLIMITSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBEXECLIMITSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBEXECLIMITSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBEXECLIMITSENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBFAILUREINFO {
    pub hRow: usize,
    pub iColumn: usize,
    pub failure: ::windows::core::HRESULT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBFAILUREINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBFAILUREINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBFAILUREINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBFAILUREINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBFAILUREINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBFAILUREINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBFAILUREINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBFAILUREINFO {
    pub hRow: usize,
    pub iColumn: usize,
    pub failure: ::windows::core::HRESULT,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBFAILUREINFO {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBFAILUREINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBFAILUREINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBFAILUREINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBFAILUREINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBFAILUREINFO {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBFAILUREINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DBGUID_MSSQLXML: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d531cb2_e6ed_11d2_b252_00c04f681b71);
pub const DBGUID_XPATH: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xec2a4293_e898_11d2_b1b7_00c04f680c56);
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBIMPLICITSESSION {
    pub pUnkOuter: ::core::option::Option<::windows::core::IUnknown>,
    pub piid: *mut ::windows::core::GUID,
    pub pSession: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBIMPLICITSESSION {
    fn clone(&self) -> Self {
        Self { pUnkOuter: self.pUnkOuter.clone(), piid: self.piid, pSession: self.pSession.clone() }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBIMPLICITSESSION {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBIMPLICITSESSION {
    fn eq(&self, other: &Self) -> bool {
        self.pUnkOuter == other.pUnkOuter && self.piid == other.piid && self.pSession == other.pSession
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBIMPLICITSESSION {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBIMPLICITSESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBIMPLICITSESSION {
    pub pUnkOuter: ::core::option::Option<::windows::core::IUnknown>,
    pub piid: *mut ::windows::core::GUID,
    pub pSession: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBIMPLICITSESSION {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBIMPLICITSESSION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBIMPLICITSESSION>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBIMPLICITSESSION {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBIMPLICITSESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
pub struct DBINDEXCOLUMNDESC {
    pub pColumnID: *mut super::super::Storage::IndexServer::DBID,
    pub eIndexColOrder: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::marker::Copy for DBINDEXCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::clone::Clone for DBINDEXCOLUMNDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
unsafe impl ::windows::core::Abi for DBINDEXCOLUMNDESC {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::PartialEq for DBINDEXCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBINDEXCOLUMNDESC>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::Eq for DBINDEXCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::default::Default for DBINDEXCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
pub struct DBINDEXCOLUMNDESC {
    pub pColumnID: *mut super::super::Storage::IndexServer::DBID,
    pub eIndexColOrder: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::marker::Copy for DBINDEXCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::clone::Clone for DBINDEXCOLUMNDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
unsafe impl ::windows::core::Abi for DBINDEXCOLUMNDESC {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::PartialEq for DBINDEXCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBINDEXCOLUMNDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::cmp::Eq for DBINDEXCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Storage_IndexServer")]
impl ::core::default::Default for DBINDEXCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBINDEX_COL_ORDERENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBINDEX_COL_ORDER_ASC: DBINDEX_COL_ORDERENUM = DBINDEX_COL_ORDERENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBINDEX_COL_ORDER_DESC: DBINDEX_COL_ORDERENUM = DBINDEX_COL_ORDERENUM(1i32);
impl ::core::marker::Copy for DBINDEX_COL_ORDERENUM {}
impl ::core::clone::Clone for DBINDEX_COL_ORDERENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBINDEX_COL_ORDERENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBINDEX_COL_ORDERENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBINDEX_COL_ORDERENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBINDEX_COL_ORDERENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBLITERALENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_INVALID: DBLITERALENUM = DBLITERALENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_BINARY_LITERAL: DBLITERALENUM = DBLITERALENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CATALOG_NAME: DBLITERALENUM = DBLITERALENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CATALOG_SEPARATOR: DBLITERALENUM = DBLITERALENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CHAR_LITERAL: DBLITERALENUM = DBLITERALENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_COLUMN_ALIAS: DBLITERALENUM = DBLITERALENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_COLUMN_NAME: DBLITERALENUM = DBLITERALENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CORRELATION_NAME: DBLITERALENUM = DBLITERALENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CURSOR_NAME: DBLITERALENUM = DBLITERALENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_ESCAPE_PERCENT: DBLITERALENUM = DBLITERALENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_ESCAPE_UNDERSCORE: DBLITERALENUM = DBLITERALENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_INDEX_NAME: DBLITERALENUM = DBLITERALENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_LIKE_PERCENT: DBLITERALENUM = DBLITERALENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_LIKE_UNDERSCORE: DBLITERALENUM = DBLITERALENUM(13i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_PROCEDURE_NAME: DBLITERALENUM = DBLITERALENUM(14i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_QUOTE: DBLITERALENUM = DBLITERALENUM(15i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_SCHEMA_NAME: DBLITERALENUM = DBLITERALENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_TABLE_NAME: DBLITERALENUM = DBLITERALENUM(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_TEXT_COMMAND: DBLITERALENUM = DBLITERALENUM(18i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_USER_NAME: DBLITERALENUM = DBLITERALENUM(19i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_VIEW_NAME: DBLITERALENUM = DBLITERALENUM(20i32);
impl ::core::marker::Copy for DBLITERALENUM {}
impl ::core::clone::Clone for DBLITERALENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBLITERALENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBLITERALENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBLITERALENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBLITERALENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBLITERALENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_CUBE_NAME: DBLITERALENUM20 = DBLITERALENUM20(21i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_DIMENSION_NAME: DBLITERALENUM20 = DBLITERALENUM20(22i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_HIERARCHY_NAME: DBLITERALENUM20 = DBLITERALENUM20(23i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_LEVEL_NAME: DBLITERALENUM20 = DBLITERALENUM20(24i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_MEMBER_NAME: DBLITERALENUM20 = DBLITERALENUM20(25i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_PROPERTY_NAME: DBLITERALENUM20 = DBLITERALENUM20(26i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_SCHEMA_SEPARATOR: DBLITERALENUM20 = DBLITERALENUM20(27i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_QUOTE_SUFFIX: DBLITERALENUM20 = DBLITERALENUM20(28i32);
impl ::core::marker::Copy for DBLITERALENUM20 {}
impl ::core::clone::Clone for DBLITERALENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBLITERALENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBLITERALENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBLITERALENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBLITERALENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBLITERALENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_ESCAPE_PERCENT_SUFFIX: DBLITERALENUM21 = DBLITERALENUM21(29i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBLITERAL_ESCAPE_UNDERSCORE_SUFFIX: DBLITERALENUM21 = DBLITERALENUM21(30i32);
impl ::core::marker::Copy for DBLITERALENUM21 {}
impl ::core::clone::Clone for DBLITERALENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBLITERALENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBLITERALENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBLITERALENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBLITERALENUM21").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DBLITERALINFO {
    pub pwszLiteralValue: ::windows::core::PWSTR,
    pub pwszInvalidChars: ::windows::core::PWSTR,
    pub pwszInvalidStartingChars: ::windows::core::PWSTR,
    pub lt: u32,
    pub fSupported: super::super::Foundation::BOOL,
    pub cchMaxLen: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBLITERALINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBLITERALINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBLITERALINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBLITERALINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBLITERALINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBLITERALINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBLITERALINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DBLITERALINFO {
    pub pwszLiteralValue: ::windows::core::PWSTR,
    pub pwszInvalidChars: ::windows::core::PWSTR,
    pub pwszInvalidStartingChars: ::windows::core::PWSTR,
    pub lt: u32,
    pub fSupported: super::super::Foundation::BOOL,
    pub cchMaxLen: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBLITERALINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBLITERALINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBLITERALINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBLITERALINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBLITERALINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBLITERALINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBLITERALINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBMATCHTYPEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMATCHTYPE_FULL: DBMATCHTYPEENUM = DBMATCHTYPEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMATCHTYPE_NONE: DBMATCHTYPEENUM = DBMATCHTYPEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMATCHTYPE_PARTIAL: DBMATCHTYPEENUM = DBMATCHTYPEENUM(2i32);
impl ::core::marker::Copy for DBMATCHTYPEENUM {}
impl ::core::clone::Clone for DBMATCHTYPEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBMATCHTYPEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBMATCHTYPEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBMATCHTYPEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBMATCHTYPEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMAXCHAR: u32 = 8001u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBMEMOWNERENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMEMOWNER_CLIENTOWNED: DBMEMOWNERENUM = DBMEMOWNERENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMEMOWNER_PROVIDEROWNED: DBMEMOWNERENUM = DBMEMOWNERENUM(1i32);
impl ::core::marker::Copy for DBMEMOWNERENUM {}
impl ::core::clone::Clone for DBMEMOWNERENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBMEMOWNERENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBMEMOWNERENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBMEMOWNERENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBMEMOWNERENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBMOVEFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMOVE_REPLACE_EXISTING: DBMOVEFLAGSENUM = DBMOVEFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMOVE_ASYNC: DBMOVEFLAGSENUM = DBMOVEFLAGSENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMOVE_DONT_UPDATE_LINKS: DBMOVEFLAGSENUM = DBMOVEFLAGSENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMOVE_ALLOW_EMULATION: DBMOVEFLAGSENUM = DBMOVEFLAGSENUM(1024i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMOVE_ATOMIC: DBMOVEFLAGSENUM = DBMOVEFLAGSENUM(4096i32);
impl ::core::marker::Copy for DBMOVEFLAGSENUM {}
impl ::core::clone::Clone for DBMOVEFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBMOVEFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBMOVEFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBMOVEFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBMOVEFLAGSENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBOBJECT {
    pub dwFlags: u32,
    pub iid: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBOBJECT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBOBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBOBJECT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBOBJECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBOBJECT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBOBJECT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBOBJECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBOBJECT {
    pub dwFlags: u32,
    pub iid: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBOBJECT {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBOBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBOBJECT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBOBJECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBOBJECT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBOBJECT {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBOBJECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBPARAMBINDINFO {
    pub pwszDataSourceType: ::windows::core::PWSTR,
    pub pwszName: ::windows::core::PWSTR,
    pub ulParamSize: usize,
    pub dwFlags: u32,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBPARAMBINDINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBPARAMBINDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBPARAMBINDINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBPARAMBINDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMBINDINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBPARAMBINDINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBPARAMBINDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBPARAMBINDINFO {
    pub pwszDataSourceType: ::windows::core::PWSTR,
    pub pwszName: ::windows::core::PWSTR,
    pub ulParamSize: usize,
    pub dwFlags: u32,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBPARAMBINDINFO {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBPARAMBINDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBPARAMBINDINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBPARAMBINDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMBINDINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBPARAMBINDINFO {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBPARAMBINDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPARAMFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_ISINPUT: DBPARAMFLAGSENUM = DBPARAMFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_ISOUTPUT: DBPARAMFLAGSENUM = DBPARAMFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_ISSIGNED: DBPARAMFLAGSENUM = DBPARAMFLAGSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_ISNULLABLE: DBPARAMFLAGSENUM = DBPARAMFLAGSENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_ISLONG: DBPARAMFLAGSENUM = DBPARAMFLAGSENUM(128i32);
impl ::core::marker::Copy for DBPARAMFLAGSENUM {}
impl ::core::clone::Clone for DBPARAMFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPARAMFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPARAMFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPARAMFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPARAMFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPARAMFLAGSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMFLAGS_SCALEISNEGATIVE: DBPARAMFLAGSENUM20 = DBPARAMFLAGSENUM20(256i32);
impl ::core::marker::Copy for DBPARAMFLAGSENUM20 {}
impl ::core::clone::Clone for DBPARAMFLAGSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPARAMFLAGSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPARAMFLAGSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPARAMFLAGSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPARAMFLAGSENUM20").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
pub struct DBPARAMINFO {
    pub dwFlags: u32,
    pub iOrdinal: usize,
    pub pwszName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub ulParamSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DBPARAMINFO {
    fn clone(&self) -> Self {
        Self {
            dwFlags: self.dwFlags,
            iOrdinal: self.iOrdinal,
            pwszName: self.pwszName,
            pTypeInfo: self.pTypeInfo.clone(),
            ulParamSize: self.ulParamSize,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBPARAMINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBPARAMINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.iOrdinal == other.iOrdinal && self.pwszName == other.pwszName && self.pTypeInfo == other.pTypeInfo && self.ulParamSize == other.ulParamSize && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBPARAMINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBPARAMINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
pub struct DBPARAMINFO {
    pub dwFlags: u32,
    pub iOrdinal: usize,
    pub pwszName: ::windows::core::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub ulParamSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBPARAMINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBPARAMINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBPARAMINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBPARAMINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPARAMIOENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMIO_NOTPARAM: DBPARAMIOENUM = DBPARAMIOENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMIO_INPUT: DBPARAMIOENUM = DBPARAMIOENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMIO_OUTPUT: DBPARAMIOENUM = DBPARAMIOENUM(2i32);
impl ::core::marker::Copy for DBPARAMIOENUM {}
impl ::core::clone::Clone for DBPARAMIOENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPARAMIOENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPARAMIOENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPARAMIOENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPARAMIOENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBPARAMS {
    pub pData: *mut ::core::ffi::c_void,
    pub cParamSets: usize,
    pub hAccessor: usize,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBPARAMS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBPARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBPARAMS {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBPARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMS>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBPARAMS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBPARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBPARAMS {
    pub pData: *mut ::core::ffi::c_void,
    pub cParamSets: usize,
    pub hAccessor: usize,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBPARAMS {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBPARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBPARAMS {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBPARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMS>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBPARAMS {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBPARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_INPUT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_INPUTOUTPUT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_OUTPUT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_RETURNVALUE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPARTENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPART_INVALID: DBPARTENUM = DBPARTENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPART_VALUE: DBPARTENUM = DBPARTENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPART_LENGTH: DBPARTENUM = DBPARTENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPART_STATUS: DBPARTENUM = DBPARTENUM(4i32);
impl ::core::marker::Copy for DBPARTENUM {}
impl ::core::clone::Clone for DBPARTENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPARTENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPARTENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPARTENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPARTENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPENDINGSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPENDINGSTATUS_NEW: DBPENDINGSTATUSENUM = DBPENDINGSTATUSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPENDINGSTATUS_CHANGED: DBPENDINGSTATUSENUM = DBPENDINGSTATUSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPENDINGSTATUS_DELETED: DBPENDINGSTATUSENUM = DBPENDINGSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPENDINGSTATUS_UNCHANGED: DBPENDINGSTATUSENUM = DBPENDINGSTATUSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPENDINGSTATUS_INVALIDROW: DBPENDINGSTATUSENUM = DBPENDINGSTATUSENUM(16i32);
impl ::core::marker::Copy for DBPENDINGSTATUSENUM {}
impl ::core::clone::Clone for DBPENDINGSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPENDINGSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPENDINGSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPENDINGSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPENDINGSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPOSITIONFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPOSITION_OK: DBPOSITIONFLAGSENUM = DBPOSITIONFLAGSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPOSITION_NOROW: DBPOSITIONFLAGSENUM = DBPOSITIONFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPOSITION_BOF: DBPOSITIONFLAGSENUM = DBPOSITIONFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPOSITION_EOF: DBPOSITIONFLAGSENUM = DBPOSITIONFLAGSENUM(3i32);
impl ::core::marker::Copy for DBPOSITIONFLAGSENUM {}
impl ::core::clone::Clone for DBPOSITIONFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPOSITIONFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPOSITIONFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPOSITIONFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPOSITIONFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROMPTOPTIONSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_NONE: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_WIZARDSHEET: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_PROPERTYSHEET: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_BROWSEONLY: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_DISABLE_PROVIDER_SELECTION: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPTOPTIONS_DISABLESAVEPASSWORD: DBPROMPTOPTIONSENUM = DBPROMPTOPTIONSENUM(32i32);
impl ::core::marker::Copy for DBPROMPTOPTIONSENUM {}
impl ::core::clone::Clone for DBPROMPTOPTIONSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROMPTOPTIONSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROMPTOPTIONSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROMPTOPTIONSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROMPTOPTIONSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_COMPLETE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_COMPLETEREQUIRED: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_NOPROMPT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_PROMPT: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROP {
    pub dwPropertyID: u32,
    pub dwOptions: u32,
    pub dwStatus: u32,
    pub colid: super::super::Storage::IndexServer::DBID,
    pub vValue: super::Com::VARIANT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROP {
    fn clone(&self) -> Self {
        Self { dwPropertyID: self.dwPropertyID, dwOptions: self.dwOptions, dwStatus: self.dwStatus, colid: self.colid, vValue: self.vValue.clone() }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROP {
    fn eq(&self, other: &Self) -> bool {
        self.dwPropertyID == other.dwPropertyID && self.dwOptions == other.dwOptions && self.dwStatus == other.dwStatus && self.colid == other.colid && self.vValue == other.vValue
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROP {
    pub dwPropertyID: u32,
    pub dwOptions: u32,
    pub dwStatus: u32,
    pub colid: super::super::Storage::IndexServer::DBID,
    pub vValue: super::Com::VARIANT,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROP>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROP {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ABORTPRESERVE: DBPROPENUM = DBPROPENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ACTIVESESSIONS: DBPROPENUM = DBPROPENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_APPENDONLY: DBPROPENUM = DBPROPENUM(187i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ASYNCTXNABORT: DBPROPENUM = DBPROPENUM(168i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ASYNCTXNCOMMIT: DBPROPENUM = DBPROPENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_CACHE_AUTHINFO: DBPROPENUM = DBPROPENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_ENCRYPT_PASSWORD: DBPROPENUM = DBPROPENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_INTEGRATED: DBPROPENUM = DBPROPENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_MASK_PASSWORD: DBPROPENUM = DBPROPENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_PASSWORD: DBPROPENUM = DBPROPENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_PERSIST_ENCRYPTED: DBPROPENUM = DBPROPENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO: DBPROPENUM = DBPROPENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_AUTH_USERID: DBPROPENUM = DBPROPENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BLOCKINGSTORAGEOBJECTS: DBPROPENUM = DBPROPENUM(13i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BOOKMARKS: DBPROPENUM = DBPROPENUM(14i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BOOKMARKSKIPPED: DBPROPENUM = DBPROPENUM(15i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BOOKMARKTYPE: DBPROPENUM = DBPROPENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BYREFACCESSORS: DBPROPENUM = DBPROPENUM(120i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CACHEDEFERRED: DBPROPENUM = DBPROPENUM(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CANFETCHBACKWARDS: DBPROPENUM = DBPROPENUM(18i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CANHOLDROWS: DBPROPENUM = DBPROPENUM(19i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CANSCROLLBACKWARDS: DBPROPENUM = DBPROPENUM(21i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CATALOGLOCATION: DBPROPENUM = DBPROPENUM(22i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CATALOGTERM: DBPROPENUM = DBPROPENUM(23i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CATALOGUSAGE: DBPROPENUM = DBPROPENUM(24i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CHANGEINSERTEDROWS: DBPROPENUM = DBPROPENUM(188i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_AUTOINCREMENT: DBPROPENUM = DBPROPENUM(26i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_DEFAULT: DBPROPENUM = DBPROPENUM(27i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_DESCRIPTION: DBPROPENUM = DBPROPENUM(28i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_FIXEDLENGTH: DBPROPENUM = DBPROPENUM(167i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_NULLABLE: DBPROPENUM = DBPROPENUM(29i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_PRIMARYKEY: DBPROPENUM = DBPROPENUM(30i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_UNIQUE: DBPROPENUM = DBPROPENUM(31i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COLUMNDEFINITION: DBPROPENUM = DBPROPENUM(32i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COLUMNRESTRICT: DBPROPENUM = DBPROPENUM(33i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COMMANDTIMEOUT: DBPROPENUM = DBPROPENUM(34i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COMMITPRESERVE: DBPROPENUM = DBPROPENUM(35i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CONCATNULLBEHAVIOR: DBPROPENUM = DBPROPENUM(36i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CURRENTCATALOG: DBPROPENUM = DBPROPENUM(37i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DATASOURCENAME: DBPROPENUM = DBPROPENUM(38i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DATASOURCEREADONLY: DBPROPENUM = DBPROPENUM(39i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DBMSNAME: DBPROPENUM = DBPROPENUM(40i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DBMSVER: DBPROPENUM = DBPROPENUM(41i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DEFERRED: DBPROPENUM = DBPROPENUM(42i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DELAYSTORAGEOBJECTS: DBPROPENUM = DBPROPENUM(43i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DSOTHREADMODEL: DBPROPENUM = DBPROPENUM(169i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_GROUPBY: DBPROPENUM = DBPROPENUM(44i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_HETEROGENEOUSTABLES: DBPROPENUM = DBPROPENUM(45i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IAccessor: DBPROPENUM = DBPROPENUM(121i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IColumnsInfo: DBPROPENUM = DBPROPENUM(122i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IColumnsRowset: DBPROPENUM = DBPROPENUM(123i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IConnectionPointContainer: DBPROPENUM = DBPROPENUM(124i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IConvertType: DBPROPENUM = DBPROPENUM(194i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowset: DBPROPENUM = DBPROPENUM(126i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetChange: DBPROPENUM = DBPROPENUM(127i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetIdentity: DBPROPENUM = DBPROPENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetIndex: DBPROPENUM = DBPROPENUM(159i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetInfo: DBPROPENUM = DBPROPENUM(129i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetLocate: DBPROPENUM = DBPROPENUM(130i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetResynch: DBPROPENUM = DBPROPENUM(132i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetScroll: DBPROPENUM = DBPROPENUM(133i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetUpdate: DBPROPENUM = DBPROPENUM(134i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ISupportErrorInfo: DBPROPENUM = DBPROPENUM(135i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ILockBytes: DBPROPENUM = DBPROPENUM(136i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ISequentialStream: DBPROPENUM = DBPROPENUM(137i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IStorage: DBPROPENUM = DBPROPENUM(138i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IStream: DBPROPENUM = DBPROPENUM(139i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IDENTIFIERCASE: DBPROPENUM = DBPROPENUM(46i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IMMOBILEROWS: DBPROPENUM = DBPROPENUM(47i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_AUTOUPDATE: DBPROPENUM = DBPROPENUM(48i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_CLUSTERED: DBPROPENUM = DBPROPENUM(49i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_FILLFACTOR: DBPROPENUM = DBPROPENUM(50i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_INITIALSIZE: DBPROPENUM = DBPROPENUM(51i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_NULLCOLLATION: DBPROPENUM = DBPROPENUM(52i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_NULLS: DBPROPENUM = DBPROPENUM(53i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_PRIMARYKEY: DBPROPENUM = DBPROPENUM(54i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_SORTBOOKMARKS: DBPROPENUM = DBPROPENUM(55i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_TEMPINDEX: DBPROPENUM = DBPROPENUM(163i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_TYPE: DBPROPENUM = DBPROPENUM(56i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INDEX_UNIQUE: DBPROPENUM = DBPROPENUM(57i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_DATASOURCE: DBPROPENUM = DBPROPENUM(59i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_HWND: DBPROPENUM = DBPROPENUM(60i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_IMPERSONATION_LEVEL: DBPROPENUM = DBPROPENUM(61i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_LCID: DBPROPENUM = DBPROPENUM(186i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_LOCATION: DBPROPENUM = DBPROPENUM(62i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_MODE: DBPROPENUM = DBPROPENUM(63i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_PROMPT: DBPROPENUM = DBPROPENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_PROTECTION_LEVEL: DBPROPENUM = DBPROPENUM(65i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_PROVIDERSTRING: DBPROPENUM = DBPROPENUM(160i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_TIMEOUT: DBPROPENUM = DBPROPENUM(66i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_LITERALBOOKMARKS: DBPROPENUM = DBPROPENUM(67i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_LITERALIDENTITY: DBPROPENUM = DBPROPENUM(68i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXINDEXSIZE: DBPROPENUM = DBPROPENUM(70i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXOPENROWS: DBPROPENUM = DBPROPENUM(71i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXPENDINGROWS: DBPROPENUM = DBPROPENUM(72i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXROWS: DBPROPENUM = DBPROPENUM(73i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXROWSIZE: DBPROPENUM = DBPROPENUM(74i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXROWSIZEINCLUDESBLOB: DBPROPENUM = DBPROPENUM(75i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXTABLESINSELECT: DBPROPENUM = DBPROPENUM(76i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAYWRITECOLUMN: DBPROPENUM = DBPROPENUM(77i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MEMORYUSAGE: DBPROPENUM = DBPROPENUM(78i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MULTIPLEPARAMSETS: DBPROPENUM = DBPROPENUM(191i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MULTIPLERESULTS: DBPROPENUM = DBPROPENUM(196i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MULTIPLESTORAGEOBJECTS: DBPROPENUM = DBPROPENUM(80i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MULTITABLEUPDATE: DBPROPENUM = DBPROPENUM(81i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFICATIONGRANULARITY: DBPROPENUM = DBPROPENUM(198i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFICATIONPHASES: DBPROPENUM = DBPROPENUM(82i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYCOLUMNSET: DBPROPENUM = DBPROPENUM(171i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWDELETE: DBPROPENUM = DBPROPENUM(173i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWFIRSTCHANGE: DBPROPENUM = DBPROPENUM(174i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWINSERT: DBPROPENUM = DBPROPENUM(175i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWRESYNCH: DBPROPENUM = DBPROPENUM(177i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWSETCHANGED: DBPROPENUM = DBPROPENUM(211i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWSETRELEASE: DBPROPENUM = DBPROPENUM(178i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE: DBPROPENUM = DBPROPENUM(179i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWUNDOCHANGE: DBPROPENUM = DBPROPENUM(180i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWUNDODELETE: DBPROPENUM = DBPROPENUM(181i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWUNDOINSERT: DBPROPENUM = DBPROPENUM(182i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NOTIFYROWUPDATE: DBPROPENUM = DBPROPENUM(183i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_NULLCOLLATION: DBPROPENUM = DBPROPENUM(83i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OLEOBJECTS: DBPROPENUM = DBPROPENUM(84i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ORDERBYCOLUMNSINSELECT: DBPROPENUM = DBPROPENUM(85i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ORDEREDBOOKMARKS: DBPROPENUM = DBPROPENUM(86i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OTHERINSERT: DBPROPENUM = DBPROPENUM(87i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OTHERUPDATEDELETE: DBPROPENUM = DBPROPENUM(88i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OUTPUTPARAMETERAVAILABILITY: DBPROPENUM = DBPROPENUM(184i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OWNINSERT: DBPROPENUM = DBPROPENUM(89i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OWNUPDATEDELETE: DBPROPENUM = DBPROPENUM(90i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PERSISTENTIDTYPE: DBPROPENUM = DBPROPENUM(185i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PREPAREABORTBEHAVIOR: DBPROPENUM = DBPROPENUM(91i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PREPARECOMMITBEHAVIOR: DBPROPENUM = DBPROPENUM(92i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROCEDURETERM: DBPROPENUM = DBPROPENUM(93i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROVIDERNAME: DBPROPENUM = DBPROPENUM(96i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROVIDEROLEDBVER: DBPROPENUM = DBPROPENUM(97i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROVIDERVER: DBPROPENUM = DBPROPENUM(98i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_QUICKRESTART: DBPROPENUM = DBPROPENUM(99i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_QUOTEDIDENTIFIERCASE: DBPROPENUM = DBPROPENUM(100i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_REENTRANTEVENTS: DBPROPENUM = DBPROPENUM(101i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_REMOVEDELETED: DBPROPENUM = DBPROPENUM(102i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_REPORTMULTIPLECHANGES: DBPROPENUM = DBPROPENUM(103i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_RETURNPENDINGINSERTS: DBPROPENUM = DBPROPENUM(189i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ROWRESTRICT: DBPROPENUM = DBPROPENUM(104i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ROWSETCONVERSIONSONCOMMAND: DBPROPENUM = DBPROPENUM(192i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ROWTHREADMODEL: DBPROPENUM = DBPROPENUM(105i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SCHEMATERM: DBPROPENUM = DBPROPENUM(106i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SCHEMAUSAGE: DBPROPENUM = DBPROPENUM(107i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SERVERCURSOR: DBPROPENUM = DBPROPENUM(108i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SESS_AUTOCOMMITISOLEVELS: DBPROPENUM = DBPROPENUM(190i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SQLSUPPORT: DBPROPENUM = DBPROPENUM(109i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_STRONGIDENTITY: DBPROPENUM = DBPROPENUM(119i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_STRUCTUREDSTORAGE: DBPROPENUM = DBPROPENUM(111i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SUBQUERIES: DBPROPENUM = DBPROPENUM(112i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SUPPORTEDTXNDDL: DBPROPENUM = DBPROPENUM(161i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SUPPORTEDTXNISOLEVELS: DBPROPENUM = DBPROPENUM(113i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SUPPORTEDTXNISORETAIN: DBPROPENUM = DBPROPENUM(114i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TABLETERM: DBPROPENUM = DBPROPENUM(115i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TBL_TEMPTABLE: DBPROPENUM = DBPROPENUM(140i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TRANSACTEDOBJECT: DBPROPENUM = DBPROPENUM(116i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_UPDATABILITY: DBPROPENUM = DBPROPENUM(117i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_USERNAME: DBPROPENUM = DBPROPENUM(118i32);
impl ::core::marker::Copy for DBPROPENUM {}
impl ::core::clone::Clone for DBPROPENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM15(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_FILTERCOMPAREOPS: DBPROPENUM15 = DBPROPENUM15(209i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_FINDCOMPAREOPS: DBPROPENUM15 = DBPROPENUM15(210i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IChapteredRowset: DBPROPENUM15 = DBPROPENUM15(202i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IDBAsynchStatus: DBPROPENUM15 = DBPROPENUM15(203i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetFind: DBPROPENUM15 = DBPROPENUM15(204i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetView: DBPROPENUM15 = DBPROPENUM15(212i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IViewChapter: DBPROPENUM15 = DBPROPENUM15(213i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IViewFilter: DBPROPENUM15 = DBPROPENUM15(214i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IViewRowset: DBPROPENUM15 = DBPROPENUM15(215i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IViewSort: DBPROPENUM15 = DBPROPENUM15(216i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_ASYNCH: DBPROPENUM15 = DBPROPENUM15(200i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXOPENCHAPTERS: DBPROPENUM15 = DBPROPENUM15(199i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXORSINFILTER: DBPROPENUM15 = DBPROPENUM15(205i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAXSORTCOLUMNS: DBPROPENUM15 = DBPROPENUM15(206i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ROWSET_ASYNCH: DBPROPENUM15 = DBPROPENUM15(201i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SORTONINDEX: DBPROPENUM15 = DBPROPENUM15(207i32);
impl ::core::marker::Copy for DBPROPENUM15 {}
impl ::core::clone::Clone for DBPROPENUM15 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM15 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM15 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM15 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM15").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IMultipleResults: DBPROPENUM20 = DBPROPENUM20(217i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_DATASOURCE_TYPE: DBPROPENUM20 = DBPROPENUM20(251i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_AXES: DBPROPENUM20 = DBPROPENUM20(252i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_FLATTENING_SUPPORT: DBPROPENUM20 = DBPROPENUM20(253i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_JOINCUBES: DBPROPENUM20 = DBPROPENUM20(254i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_NAMED_LEVELS: DBPROPENUM20 = DBPROPENUM20(255i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_RANGEROWSET: DBPROPENUM20 = DBPROPENUM20(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_SLICER: DBPROPENUM20 = DBPROPENUM20(218i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_CUBEQUALIFICATION: DBPROPENUM20 = DBPROPENUM20(219i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_OUTERREFERENCE: DBPROPENUM20 = DBPROPENUM20(220i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_QUERYBYPROPERTY: DBPROPENUM20 = DBPROPENUM20(221i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_CASESUPPORT: DBPROPENUM20 = DBPROPENUM20(222i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_STRING_COMPOP: DBPROPENUM20 = DBPROPENUM20(224i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_DESCFLAGS: DBPROPENUM20 = DBPROPENUM20(225i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_SET_FUNCTIONS: DBPROPENUM20 = DBPROPENUM20(226i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_MEMBER_FUNCTIONS: DBPROPENUM20 = DBPROPENUM20(227i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_NUMERIC_FUNCTIONS: DBPROPENUM20 = DBPROPENUM20(228i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_FORMULAS: DBPROPENUM20 = DBPROPENUM20(229i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_AGGREGATECELL_UPDATE: DBPROPENUM20 = DBPROPENUM20(230i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_AGGREGATECELL_UPDATE: DBPROPENUM20 = DBPROPENUM20(230i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_OBJQUALIFICATION: DBPROPENUM20 = DBPROPENUM20(261i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_MDX_NONMEASURE_EXPRESSIONS: DBPROPENUM20 = DBPROPENUM20(262i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ACCESSORDER: DBPROPENUM20 = DBPROPENUM20(231i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_BOOKMARKINFO: DBPROPENUM20 = DBPROPENUM20(232i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_CATALOG: DBPROPENUM20 = DBPROPENUM20(233i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ROW_BULKOPS: DBPROPENUM20 = DBPROPENUM20(234i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROVIDERFRIENDLYNAME: DBPROPENUM20 = DBPROPENUM20(235i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_LOCKMODE: DBPROPENUM20 = DBPROPENUM20(236i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MULTIPLECONNECTIONS: DBPROPENUM20 = DBPROPENUM20(237i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_UNIQUEROWS: DBPROPENUM20 = DBPROPENUM20(238i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SERVERDATAONINSERT: DBPROPENUM20 = DBPROPENUM20(239i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_STORAGEFLAGS: DBPROPENUM20 = DBPROPENUM20(240i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CONNECTIONSTATUS: DBPROPENUM20 = DBPROPENUM20(244i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ALTERCOLUMN: DBPROPENUM20 = DBPROPENUM20(245i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COLUMNLCID: DBPROPENUM20 = DBPROPENUM20(246i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_RESETDATASOURCE: DBPROPENUM20 = DBPROPENUM20(247i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_OLEDBSERVICES: DBPROPENUM20 = DBPROPENUM20(248i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetRefresh: DBPROPENUM20 = DBPROPENUM20(249i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SERVERNAME: DBPROPENUM20 = DBPROPENUM20(250i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IParentRowset: DBPROPENUM20 = DBPROPENUM20(257i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_HIDDENCOLUMNS: DBPROPENUM20 = DBPROPENUM20(258i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PROVIDERMEMORY: DBPROPENUM20 = DBPROPENUM20(259i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_CLIENTCURSOR: DBPROPENUM20 = DBPROPENUM20(260i32);
impl ::core::marker::Copy for DBPROPENUM20 {}
impl ::core::clone::Clone for DBPROPENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TRUSTEE_USERNAME: DBPROPENUM21 = DBPROPENUM21(241i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TRUSTEE_AUTHENTICATION: DBPROPENUM21 = DBPROPENUM21(242i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TRUSTEE_NEWAUTHENTICATION: DBPROPENUM21 = DBPROPENUM21(243i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRow: DBPROPENUM21 = DBPROPENUM21(263i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowChange: DBPROPENUM21 = DBPROPENUM21(264i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowSchemaChange: DBPROPENUM21 = DBPROPENUM21(265i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IGetRow: DBPROPENUM21 = DBPROPENUM21(266i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IScopedOperations: DBPROPENUM21 = DBPROPENUM21(267i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IBindResource: DBPROPENUM21 = DBPROPENUM21(268i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ICreateRow: DBPROPENUM21 = DBPROPENUM21(269i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_BINDFLAGS: DBPROPENUM21 = DBPROPENUM21(270i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_LOCKOWNER: DBPROPENUM21 = DBPROPENUM21(271i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_GENERATEURL: DBPROPENUM21 = DBPROPENUM21(273i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IDBBinderProperties: DBPROPENUM21 = DBPROPENUM21(274i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IColumnsInfo2: DBPROPENUM21 = DBPROPENUM21(275i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRegisterProvider: DBPROPENUM21 = DBPROPENUM21(276i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IGetSession: DBPROPENUM21 = DBPROPENUM21(277i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IGetSourceRow: DBPROPENUM21 = DBPROPENUM21(278i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetCurrentIndex: DBPROPENUM21 = DBPROPENUM21(279i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OPENROWSETSUPPORT: DBPROPENUM21 = DBPROPENUM21(280i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_ISLONG: DBPROPENUM21 = DBPROPENUM21(281i32);
impl ::core::marker::Copy for DBPROPENUM21 {}
impl ::core::clone::Clone for DBPROPENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM25(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_SEED: DBPROPENUM25 = DBPROPENUM25(282i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COL_INCREMENT: DBPROPENUM25 = DBPROPENUM25(283i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INIT_GENERALTIMEOUT: DBPROPENUM25 = DBPROPENUM25(284i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_COMSERVICES: DBPROPENUM25 = DBPROPENUM25(285i32);
impl ::core::marker::Copy for DBPROPENUM25 {}
impl ::core::clone::Clone for DBPROPENUM25 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM25 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM25 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM25 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM25").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM25_DEPRECATED(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ICommandCost: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(141i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ICommandTree: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(142i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_ICommandValidate: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(143i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IDBSchemaCommand: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(144i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IProvideMoniker: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(125i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IQuery: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(146i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IReadData: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(147i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetAsynch: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(148i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetCopyRows: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(149i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetKeys: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(151i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetNewRowAfter: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(152i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetNextRowset: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(153i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetWatchAll: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(155i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetWatchNotify: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(156i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetWatchRegion: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(157i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetWithParameters: DBPROPENUM25_DEPRECATED = DBPROPENUM25_DEPRECATED(158i32);
impl ::core::marker::Copy for DBPROPENUM25_DEPRECATED {}
impl ::core::clone::Clone for DBPROPENUM25_DEPRECATED {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM25_DEPRECATED {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM25_DEPRECATED {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM25_DEPRECATED {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM25_DEPRECATED").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPENUM26(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OUTPUTSTREAM: DBPROPENUM26 = DBPROPENUM26(286i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_OUTPUTENCODING: DBPROPENUM26 = DBPROPENUM26(287i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_TABLESTATISTICS: DBPROPENUM26 = DBPROPENUM26(288i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_SKIPROWCOUNTRESULTS: DBPROPENUM26 = DBPROPENUM26(291i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_IRowsetBookmark: DBPROPENUM26 = DBPROPENUM26(292i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDPROP_VISUALMODE: DBPROPENUM26 = DBPROPENUM26(293i32);
impl ::core::marker::Copy for DBPROPENUM26 {}
impl ::core::clone::Clone for DBPROPENUM26 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPENUM26 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPENUM26 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPENUM26 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPENUM26").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPFLAGSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_NOTSUPPORTED: DBPROPFLAGSENUM = DBPROPFLAGSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_COLUMN: DBPROPFLAGSENUM = DBPROPFLAGSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_DATASOURCE: DBPROPFLAGSENUM = DBPROPFLAGSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_DATASOURCECREATE: DBPROPFLAGSENUM = DBPROPFLAGSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_DATASOURCEINFO: DBPROPFLAGSENUM = DBPROPFLAGSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_DBINIT: DBPROPFLAGSENUM = DBPROPFLAGSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_INDEX: DBPROPFLAGSENUM = DBPROPFLAGSENUM(32i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_ROWSET: DBPROPFLAGSENUM = DBPROPFLAGSENUM(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_TABLE: DBPROPFLAGSENUM = DBPROPFLAGSENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_COLUMNOK: DBPROPFLAGSENUM = DBPROPFLAGSENUM(256i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_READ: DBPROPFLAGSENUM = DBPROPFLAGSENUM(512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_WRITE: DBPROPFLAGSENUM = DBPROPFLAGSENUM(1024i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_REQUIRED: DBPROPFLAGSENUM = DBPROPFLAGSENUM(2048i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_SESSION: DBPROPFLAGSENUM = DBPROPFLAGSENUM(4096i32);
impl ::core::marker::Copy for DBPROPFLAGSENUM {}
impl ::core::clone::Clone for DBPROPFLAGSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPFLAGSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPFLAGSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPFLAGSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPFLAGSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPFLAGSENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_TRUSTEE: DBPROPFLAGSENUM21 = DBPROPFLAGSENUM21(8192i32);
impl ::core::marker::Copy for DBPROPFLAGSENUM21 {}
impl ::core::clone::Clone for DBPROPFLAGSENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPFLAGSENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPFLAGSENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPFLAGSENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPFLAGSENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPFLAGSENUM25(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_VIEW: DBPROPFLAGSENUM25 = DBPROPFLAGSENUM25(16384i32);
impl ::core::marker::Copy for DBPROPFLAGSENUM25 {}
impl ::core::clone::Clone for DBPROPFLAGSENUM25 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPFLAGSENUM25 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPFLAGSENUM25 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPFLAGSENUM25 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPFLAGSENUM25").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPFLAGSENUM26(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_STREAM: DBPROPFLAGSENUM26 = DBPROPFLAGSENUM26(32768i32);
impl ::core::marker::Copy for DBPROPFLAGSENUM26 {}
impl ::core::clone::Clone for DBPROPFLAGSENUM26 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPFLAGSENUM26 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPFLAGSENUM26 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPFLAGSENUM26 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPFLAGSENUM26").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_PERSIST: u32 = 8192u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBPROPIDSET {
    pub rgPropertyIDs: *mut u32,
    pub cPropertyIDs: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBPROPIDSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBPROPIDSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBPROPIDSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBPROPIDSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPIDSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBPROPIDSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBPROPIDSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBPROPIDSET {
    pub rgPropertyIDs: *mut u32,
    pub cPropertyIDs: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBPROPIDSET {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBPROPIDSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBPROPIDSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBPROPIDSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPIDSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBPROPIDSET {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBPROPIDSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFO {
    pub pwszDescription: ::windows::core::PWSTR,
    pub dwPropertyID: u32,
    pub dwFlags: u32,
    pub vtType: u16,
    pub vValues: super::Com::VARIANT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFO {
    fn clone(&self) -> Self {
        Self {
            pwszDescription: self.pwszDescription,
            dwPropertyID: self.dwPropertyID,
            dwFlags: self.dwFlags,
            vtType: self.vtType,
            vValues: self.vValues.clone(),
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszDescription == other.pwszDescription && self.dwPropertyID == other.dwPropertyID && self.dwFlags == other.dwFlags && self.vtType == other.vtType && self.vValues == other.vValues
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFO {
    pub pwszDescription: ::windows::core::PWSTR,
    pub dwPropertyID: u32,
    pub dwFlags: u32,
    pub vtType: u16,
    pub vValues: super::Com::VARIANT,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFOSET {
    pub rgPropertyInfos: *mut DBPROPINFO,
    pub cPropertyInfos: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPINFOSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFOSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFOSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFOSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFOSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFOSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFOSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFOSET {
    pub rgPropertyInfos: *mut DBPROPINFO,
    pub cPropertyInfos: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPINFOSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFOSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFOSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFOSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFOSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFOSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFOSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPOPTIONSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPOPTIONS_REQUIRED: DBPROPOPTIONSENUM = DBPROPOPTIONSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPOPTIONS_SETIFCHEAP: DBPROPOPTIONSENUM = DBPROPOPTIONSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPOPTIONS_OPTIONAL: DBPROPOPTIONSENUM = DBPROPOPTIONSENUM(1i32);
impl ::core::marker::Copy for DBPROPOPTIONSENUM {}
impl ::core::clone::Clone for DBPROPOPTIONSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPOPTIONSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPOPTIONSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPOPTIONSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPOPTIONSENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPSET {
    pub rgProperties: *mut DBPROP,
    pub cProperties: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPSET {
    pub rgProperties: *mut DBPROP,
    pub cProperties: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DBPROPSET_MSDAORA8_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7f06a375_dd6a_43db_b4e0_1fc121e5e62b);
pub const DBPROPSET_MSDAORA_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8cc4cbd_fdff_11d0_b865_00a0c9081c1d);
pub const DBPROPSET_MSDSDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55cb91a8_5c7a_11d1_adad_00c04fc29863);
pub const DBPROPSET_MSDSSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedf17536_afbf_11d1_8847_0000f879f98c);
pub const DBPROPSET_PERSIST: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d7839a0_5b8e_11d1_a6b3_00a0c9138c66);
pub const DBPROPSET_PROVIDERCONNATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e4_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e0_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e2_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e1_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERSTMTATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e3_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_SQLSERVERCOLUMN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b63fb5e_3fbb_11d3_9f29_00c04f8ee9dc);
pub const DBPROPSET_SQLSERVERDATASOURCE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee4_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdf10cb94_35f6_11d2_9c54_00c04f7971d3);
pub const DBPROPSET_SQLSERVERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca10_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca11_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee5_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSTREAM: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f79c073_8a6d_4bca_a8a8_c9b79a9b962d);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_OK: DBPROPSTATUSENUM = DBPROPSTATUSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_NOTSUPPORTED: DBPROPSTATUSENUM = DBPROPSTATUSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_BADVALUE: DBPROPSTATUSENUM = DBPROPSTATUSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_BADOPTION: DBPROPSTATUSENUM = DBPROPSTATUSENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_BADCOLUMN: DBPROPSTATUSENUM = DBPROPSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_NOTALLSETTABLE: DBPROPSTATUSENUM = DBPROPSTATUSENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_NOTSETTABLE: DBPROPSTATUSENUM = DBPROPSTATUSENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_NOTSET: DBPROPSTATUSENUM = DBPROPSTATUSENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_CONFLICTING: DBPROPSTATUSENUM = DBPROPSTATUSENUM(8i32);
impl ::core::marker::Copy for DBPROPSTATUSENUM {}
impl ::core::clone::Clone for DBPROPSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBPROPSTATUSENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPSTATUS_NOTAVAILABLE: DBPROPSTATUSENUM21 = DBPROPSTATUSENUM21(9i32);
impl ::core::marker::Copy for DBPROPSTATUSENUM21 {}
impl ::core::clone::Clone for DBPROPSTATUSENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBPROPSTATUSENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBPROPSTATUSENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBPROPSTATUSENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBPROPSTATUSENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_RANDOM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_SEQUENTIAL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_INITIALIZE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_POPULATEONDEMAND: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_PREPOPULATE: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_RANDOMPOPULATION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_ROWSET: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_XTRANSACTION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BI_CROSSROWSET: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BMK_KEY: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BMK_NUMERIC: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_NOINDEXUPDATE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_NOLOG: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_REFINTEGRITY: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_DELETE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_NON_NULL: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_NULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_PRESERVE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CD_NOTNULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CL_END: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CL_START: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CM_TRANSACTIONS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_BEGINSWITH: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CASEINSENSITIVE: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CASESENSITIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CONTAINS: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_EQUALITY: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_STRING: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_COMMUNICATIONFAILURE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_INITIALIZED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_UNINITIALIZED: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_INITIALLY_DEFERRED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_INITIALLY_IMMEDIATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_NOT_DEFERRABLE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_DOCSOURCE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_MDP: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_TDP: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_TDPANDMDP: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_CATALOG: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_COLUMN: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_TABLE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_COLLATE: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_CONTAINS_SELECT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_EQUALS_SELECT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_NO_RELATION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GU_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GU_SUFFIX: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_HT_DIFFERENT_CATALOGS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_HT_DIFFERENT_PROVIDERS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_LOWER: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_MIXED: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_SENSITIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_UPPER: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_ALLOWNULL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_DISALLOWNULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_IGNOREANYNULL: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_IGNORENULL: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_BTREE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_CONTENT: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_HASH: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_OTHER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_INTENT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_NONE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_READ: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_RITE: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_SINGLEROW: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_CONCURRENT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_NOTSUPPORTED: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_END: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_HIGH: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_LOW: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_START: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_ABOUTTODO: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_DIDEVENT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_FAILEDTODO: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_OKTODO: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_SYNCHAFTER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NT_MULTIPLEROWS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NT_SINGLEROW: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_ATEXECUTE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_ATROWRELEASE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_BLOB: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_DIRECTBIND: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_IPERSIST: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_ROWOBJECT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_SCOPED: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_SINGLETON: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_EQUAL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_RELATIVE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_STRING: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_HISTOGRAM: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_INDEX: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_INTEGRATEDINDEX: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_STOREDPROC: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_TABLE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_AGR_AFTERSESSION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_CLIENTCURSOR: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_DISABLEALL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_ENABLEALL: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_RESOURCEPOOLING: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_TXNENLISTMENT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PERSIST_ADTG: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PERSIST_XML: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID_NAME: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID_PROPID: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_NAME: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PGUID_NAME: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PGUID_PROPID: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PROPID: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RD_RESETALL: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_APTMTTHREAD: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_FREETHREAD: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_SINGLETHREAD: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI89_IEF: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_ENTRY: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_FULL: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_INTERMEDIATE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ESCAPECLAUSES: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_FIPS_TRANSITIONAL: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_NONE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_CORE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_EXTENDED: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_MINIMUM: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_SUBMINIMUM: i32 = 512i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_COMPARISON: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_CORRELATEDSUBQUERIES: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_EXISTS: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_IN: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_QUANTIFIED: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_TABLE: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ILOCKBYTES: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISEQUENTIALSTREAM: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISTORAGE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISTREAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_CONVERT: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_DELETEONRELEASE: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_DIRECT: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_FAILIFTHERE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_PRIORITY: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_TRANSACTED: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_ALL: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_COMMIT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_IGNORE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_LOCK: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DML: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_NONE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_BROWSE: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_CHAOS: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_CURSORSTABILITY: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_ISOLATED: i32 = 1048576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_READCOMMITTED: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_READUNCOMMITTED: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_REPEATABLEREAD: i32 = 65536i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_SERIALIZABLE: i32 = 1048576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT_DC: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT_NO: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_BOTH: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT_DC: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT_NO: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_DONTCARE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_NONE: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_OPTIMISTIC: i32 = 512i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TS_CARDINALITY: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TS_HISTOGRAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_CHANGE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_DELETE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_INSERT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_HCHAPTER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INTERLEAVEDROWS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAINTAINPROPS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MSDAORA8_DETERMINEKEYCOLUMNS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MSDAORA_DETERMINEKEYCOLUMNS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PersistFormat: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PersistSchema: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_Unicode: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBRANGEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_INCLUSIVESTART: DBRANGEENUM = DBRANGEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_INCLUSIVEEND: DBRANGEENUM = DBRANGEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_EXCLUSIVESTART: DBRANGEENUM = DBRANGEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_EXCLUSIVEEND: DBRANGEENUM = DBRANGEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_EXCLUDENULLS: DBRANGEENUM = DBRANGEENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_PREFIX: DBRANGEENUM = DBRANGEENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_MATCH: DBRANGEENUM = DBRANGEENUM(16i32);
impl ::core::marker::Copy for DBRANGEENUM {}
impl ::core::clone::Clone for DBRANGEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBRANGEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBRANGEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBRANGEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBRANGEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBRANGEENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_MATCH_N_SHIFT: DBRANGEENUM20 = DBRANGEENUM20(24i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRANGE_MATCH_N_MASK: DBRANGEENUM20 = DBRANGEENUM20(255i32);
impl ::core::marker::Copy for DBRANGEENUM20 {}
impl ::core::clone::Clone for DBRANGEENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBRANGEENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBRANGEENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBRANGEENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBRANGEENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBREASONENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_FETCHPOSITIONCHANGE: DBREASONENUM = DBREASONENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_RELEASE: DBREASONENUM = DBREASONENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_COLUMN_SET: DBREASONENUM = DBREASONENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_COLUMN_RECALCULATED: DBREASONENUM = DBREASONENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_ACTIVATE: DBREASONENUM = DBREASONENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_RELEASE: DBREASONENUM = DBREASONENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_DELETE: DBREASONENUM = DBREASONENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_FIRSTCHANGE: DBREASONENUM = DBREASONENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_INSERT: DBREASONENUM = DBREASONENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_RESYNCH: DBREASONENUM = DBREASONENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_UNDOCHANGE: DBREASONENUM = DBREASONENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_UNDOINSERT: DBREASONENUM = DBREASONENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_UNDODELETE: DBREASONENUM = DBREASONENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_UPDATE: DBREASONENUM = DBREASONENUM(13i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_CHANGED: DBREASONENUM = DBREASONENUM(14i32);
impl ::core::marker::Copy for DBREASONENUM {}
impl ::core::clone::Clone for DBREASONENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBREASONENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBREASONENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBREASONENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBREASONENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBREASONENUM15(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWPOSITION_CHANGED: DBREASONENUM15 = DBREASONENUM15(15i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWPOSITION_CHAPTERCHANGED: DBREASONENUM15 = DBREASONENUM15(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWPOSITION_CLEARED: DBREASONENUM15 = DBREASONENUM15(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROW_ASYNCHINSERT: DBREASONENUM15 = DBREASONENUM15(18i32);
impl ::core::marker::Copy for DBREASONENUM15 {}
impl ::core::clone::Clone for DBREASONENUM15 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBREASONENUM15 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBREASONENUM15 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBREASONENUM15 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBREASONENUM15").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBREASONENUM25(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_ROWSADDED: DBREASONENUM25 = DBREASONENUM25(19i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_POPULATIONCOMPLETE: DBREASONENUM25 = DBREASONENUM25(20i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBREASON_ROWSET_POPULATIONSTOPPED: DBREASONENUM25 = DBREASONENUM25(21i32);
impl ::core::marker::Copy for DBREASONENUM25 {}
impl ::core::clone::Clone for DBREASONENUM25 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBREASONENUM25 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBREASONENUM25 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBREASONENUM25 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBREASONENUM25").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBRESOURCEKINDENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_INVALID: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_TOTAL: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_CPU: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_MEMORY: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_DISK: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_NETWORK: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_RESPONSE: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_ROWS: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESOURCE_OTHER: DBRESOURCEKINDENUM = DBRESOURCEKINDENUM(8i32);
impl ::core::marker::Copy for DBRESOURCEKINDENUM {}
impl ::core::clone::Clone for DBRESOURCEKINDENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBRESOURCEKINDENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBRESOURCEKINDENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBRESOURCEKINDENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBRESOURCEKINDENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBRESULTFLAGENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESULTFLAG_DEFAULT: DBRESULTFLAGENUM = DBRESULTFLAGENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESULTFLAG_ROWSET: DBRESULTFLAGENUM = DBRESULTFLAGENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBRESULTFLAG_ROW: DBRESULTFLAGENUM = DBRESULTFLAGENUM(2i32);
impl ::core::marker::Copy for DBRESULTFLAGENUM {}
impl ::core::clone::Clone for DBRESULTFLAGENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBRESULTFLAGENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBRESULTFLAGENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBRESULTFLAGENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBRESULTFLAGENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBROWCHANGEKINDENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWCHANGEKIND_INSERT: DBROWCHANGEKINDENUM = DBROWCHANGEKINDENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWCHANGEKIND_DELETE: DBROWCHANGEKINDENUM = DBROWCHANGEKINDENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWCHANGEKIND_UPDATE: DBROWCHANGEKINDENUM = DBROWCHANGEKINDENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWCHANGEKIND_COUNT: DBROWCHANGEKINDENUM = DBROWCHANGEKINDENUM(3i32);
impl ::core::marker::Copy for DBROWCHANGEKINDENUM {}
impl ::core::clone::Clone for DBROWCHANGEKINDENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBROWCHANGEKINDENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBROWCHANGEKINDENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBROWCHANGEKINDENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBROWCHANGEKINDENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBROWSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_S_OK: DBROWSTATUSENUM = DBROWSTATUSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_S_MULTIPLECHANGES: DBROWSTATUSENUM = DBROWSTATUSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_S_PENDINGCHANGES: DBROWSTATUSENUM = DBROWSTATUSENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_CANCELED: DBROWSTATUSENUM = DBROWSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_CANTRELEASE: DBROWSTATUSENUM = DBROWSTATUSENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_CONCURRENCYVIOLATION: DBROWSTATUSENUM = DBROWSTATUSENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_DELETED: DBROWSTATUSENUM = DBROWSTATUSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_PENDINGINSERT: DBROWSTATUSENUM = DBROWSTATUSENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_NEWLYINSERTED: DBROWSTATUSENUM = DBROWSTATUSENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_INTEGRITYVIOLATION: DBROWSTATUSENUM = DBROWSTATUSENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_INVALID: DBROWSTATUSENUM = DBROWSTATUSENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED: DBROWSTATUSENUM = DBROWSTATUSENUM(13i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_OBJECTOPEN: DBROWSTATUSENUM = DBROWSTATUSENUM(14i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_OUTOFMEMORY: DBROWSTATUSENUM = DBROWSTATUSENUM(15i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_PERMISSIONDENIED: DBROWSTATUSENUM = DBROWSTATUSENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_LIMITREACHED: DBROWSTATUSENUM = DBROWSTATUSENUM(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_SCHEMAVIOLATION: DBROWSTATUSENUM = DBROWSTATUSENUM(18i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_E_FAIL: DBROWSTATUSENUM = DBROWSTATUSENUM(19i32);
impl ::core::marker::Copy for DBROWSTATUSENUM {}
impl ::core::clone::Clone for DBROWSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBROWSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBROWSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBROWSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBROWSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBROWSTATUSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBROWSTATUS_S_NOCHANGE: DBROWSTATUSENUM20 = DBROWSTATUSENUM20(20i32);
impl ::core::marker::Copy for DBROWSTATUSENUM20 {}
impl ::core::clone::Clone for DBROWSTATUSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBROWSTATUSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBROWSTATUSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBROWSTATUSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBROWSTATUSENUM20").field(&self.0).finish()
    }
}
pub const DBSCHEMA_LINKEDSERVERS: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9093caf4_2eac_11d1_9809_00c04fc2ad98);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSEEKENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_INVALID: DBSEEKENUM = DBSEEKENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_FIRSTEQ: DBSEEKENUM = DBSEEKENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_LASTEQ: DBSEEKENUM = DBSEEKENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_AFTEREQ: DBSEEKENUM = DBSEEKENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_AFTER: DBSEEKENUM = DBSEEKENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_BEFOREEQ: DBSEEKENUM = DBSEEKENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSEEK_BEFORE: DBSEEKENUM = DBSEEKENUM(32i32);
impl ::core::marker::Copy for DBSEEKENUM {}
impl ::core::clone::Clone for DBSEEKENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSEEKENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSEEKENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSEEKENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSEEKENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSORTENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSORT_ASCENDING: DBSORTENUM = DBSORTENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSORT_DESCENDING: DBSORTENUM = DBSORTENUM(1i32);
impl ::core::marker::Copy for DBSORTENUM {}
impl ::core::clone::Clone for DBSORTENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSORTENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSORTENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSORTENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSORTENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSOURCETYPEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSOURCETYPE_DATASOURCE: DBSOURCETYPEENUM = DBSOURCETYPEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSOURCETYPE_ENUMERATOR: DBSOURCETYPEENUM = DBSOURCETYPEENUM(2i32);
impl ::core::marker::Copy for DBSOURCETYPEENUM {}
impl ::core::clone::Clone for DBSOURCETYPEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSOURCETYPEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSOURCETYPEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSOURCETYPEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSOURCETYPEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSOURCETYPEENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSOURCETYPE_DATASOURCE_TDP: DBSOURCETYPEENUM20 = DBSOURCETYPEENUM20(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSOURCETYPE_DATASOURCE_MDP: DBSOURCETYPEENUM20 = DBSOURCETYPEENUM20(3i32);
impl ::core::marker::Copy for DBSOURCETYPEENUM20 {}
impl ::core::clone::Clone for DBSOURCETYPEENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSOURCETYPEENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSOURCETYPEENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSOURCETYPEENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSOURCETYPEENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSOURCETYPEENUM25(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSOURCETYPE_BINDER: DBSOURCETYPEENUM25 = DBSOURCETYPEENUM25(4i32);
impl ::core::marker::Copy for DBSOURCETYPEENUM25 {}
impl ::core::clone::Clone for DBSOURCETYPEENUM25 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSOURCETYPEENUM25 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSOURCETYPEENUM25 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSOURCETYPEENUM25 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSOURCETYPEENUM25").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSTATUSENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_OK: DBSTATUSENUM = DBSTATUSENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_BADACCESSOR: DBSTATUSENUM = DBSTATUSENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_CANTCONVERTVALUE: DBSTATUSENUM = DBSTATUSENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_ISNULL: DBSTATUSENUM = DBSTATUSENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_TRUNCATED: DBSTATUSENUM = DBSTATUSENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_SIGNMISMATCH: DBSTATUSENUM = DBSTATUSENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_DATAOVERFLOW: DBSTATUSENUM = DBSTATUSENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_CANTCREATE: DBSTATUSENUM = DBSTATUSENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_UNAVAILABLE: DBSTATUSENUM = DBSTATUSENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_PERMISSIONDENIED: DBSTATUSENUM = DBSTATUSENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_INTEGRITYVIOLATION: DBSTATUSENUM = DBSTATUSENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_SCHEMAVIOLATION: DBSTATUSENUM = DBSTATUSENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_BADSTATUS: DBSTATUSENUM = DBSTATUSENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_DEFAULT: DBSTATUSENUM = DBSTATUSENUM(13i32);
impl ::core::marker::Copy for DBSTATUSENUM {}
impl ::core::clone::Clone for DBSTATUSENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSTATUSENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSTATUSENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSTATUSENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSTATUSENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSTATUSENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const MDSTATUS_S_CELLEMPTY: DBSTATUSENUM20 = DBSTATUSENUM20(14i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_IGNORE: DBSTATUSENUM20 = DBSTATUSENUM20(15i32);
impl ::core::marker::Copy for DBSTATUSENUM20 {}
impl ::core::clone::Clone for DBSTATUSENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSTATUSENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSTATUSENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSTATUSENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSTATUSENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSTATUSENUM21(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_DOESNOTEXIST: DBSTATUSENUM21 = DBSTATUSENUM21(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_INVALIDURL: DBSTATUSENUM21 = DBSTATUSENUM21(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_RESOURCELOCKED: DBSTATUSENUM21 = DBSTATUSENUM21(18i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_RESOURCEEXISTS: DBSTATUSENUM21 = DBSTATUSENUM21(19i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_CANNOTCOMPLETE: DBSTATUSENUM21 = DBSTATUSENUM21(20i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_VOLUMENOTFOUND: DBSTATUSENUM21 = DBSTATUSENUM21(21i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_OUTOFSPACE: DBSTATUSENUM21 = DBSTATUSENUM21(22i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_CANNOTDELETESOURCE: DBSTATUSENUM21 = DBSTATUSENUM21(23i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_READONLY: DBSTATUSENUM21 = DBSTATUSENUM21(24i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_RESOURCEOUTOFSCOPE: DBSTATUSENUM21 = DBSTATUSENUM21(25i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_ALREADYEXISTS: DBSTATUSENUM21 = DBSTATUSENUM21(26i32);
impl ::core::marker::Copy for DBSTATUSENUM21 {}
impl ::core::clone::Clone for DBSTATUSENUM21 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSTATUSENUM21 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSTATUSENUM21 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSTATUSENUM21 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSTATUSENUM21").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSTATUSENUM25(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_CANCELED: DBSTATUSENUM25 = DBSTATUSENUM25(27i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_E_NOTCOLLECTION: DBSTATUSENUM25 = DBSTATUSENUM25(28i32);
impl ::core::marker::Copy for DBSTATUSENUM25 {}
impl ::core::clone::Clone for DBSTATUSENUM25 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSTATUSENUM25 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSTATUSENUM25 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSTATUSENUM25 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSTATUSENUM25").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBSTATUSENUM26(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTATUS_S_ROWSETCOLUMN: DBSTATUSENUM26 = DBSTATUSENUM26(29i32);
impl ::core::marker::Copy for DBSTATUSENUM26 {}
impl ::core::clone::Clone for DBSTATUSENUM26 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBSTATUSENUM26 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBSTATUSENUM26 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBSTATUSENUM26 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBSTATUSENUM26").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBTABLESTATISTICSTYPE26(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTAT_HISTOGRAM: DBTABLESTATISTICSTYPE26 = DBTABLESTATISTICSTYPE26(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTAT_COLUMN_CARDINALITY: DBTABLESTATISTICSTYPE26 = DBTABLESTATISTICSTYPE26(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBSTAT_TUPLE_CARDINALITY: DBTABLESTATISTICSTYPE26 = DBTABLESTATISTICSTYPE26(4i32);
impl ::core::marker::Copy for DBTABLESTATISTICSTYPE26 {}
impl ::core::clone::Clone for DBTABLESTATISTICSTYPE26 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBTABLESTATISTICSTYPE26 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBTABLESTATISTICSTYPE26 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBTABLESTATISTICSTYPE26 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBTABLESTATISTICSTYPE26").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct DBTIME {
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
}
impl ::core::marker::Copy for DBTIME {}
impl ::core::clone::Clone for DBTIME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DBTIME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBTIME").field("hour", &self.hour).field("minute", &self.minute).field("second", &self.second).finish()
    }
}
unsafe impl ::windows::core::Abi for DBTIME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DBTIME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIME>()) == 0 }
    }
}
impl ::core::cmp::Eq for DBTIME {}
impl ::core::default::Default for DBTIME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBTIMESTAMP {
    pub year: i16,
    pub month: u16,
    pub day: u16,
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
    pub fraction: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBTIMESTAMP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBTIMESTAMP {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBTIMESTAMP {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBTIMESTAMP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIMESTAMP>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBTIMESTAMP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBTIMESTAMP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBTIMESTAMP {
    pub year: i16,
    pub month: u16,
    pub day: u16,
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
    pub fraction: u32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBTIMESTAMP {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBTIMESTAMP {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBTIMESTAMP {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBTIMESTAMP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIMESTAMP>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBTIMESTAMP {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBTIMESTAMP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBTYPEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_EMPTY: DBTYPEENUM = DBTYPEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_NULL: DBTYPEENUM = DBTYPEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_I2: DBTYPEENUM = DBTYPEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_I4: DBTYPEENUM = DBTYPEENUM(3i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_R4: DBTYPEENUM = DBTYPEENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_R8: DBTYPEENUM = DBTYPEENUM(5i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_CY: DBTYPEENUM = DBTYPEENUM(6i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_DATE: DBTYPEENUM = DBTYPEENUM(7i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_BSTR: DBTYPEENUM = DBTYPEENUM(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_IDISPATCH: DBTYPEENUM = DBTYPEENUM(9i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_ERROR: DBTYPEENUM = DBTYPEENUM(10i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_BOOL: DBTYPEENUM = DBTYPEENUM(11i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_VARIANT: DBTYPEENUM = DBTYPEENUM(12i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_IUNKNOWN: DBTYPEENUM = DBTYPEENUM(13i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_DECIMAL: DBTYPEENUM = DBTYPEENUM(14i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_UI1: DBTYPEENUM = DBTYPEENUM(17i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_ARRAY: DBTYPEENUM = DBTYPEENUM(8192i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_BYREF: DBTYPEENUM = DBTYPEENUM(16384i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_I1: DBTYPEENUM = DBTYPEENUM(16i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_UI2: DBTYPEENUM = DBTYPEENUM(18i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_UI4: DBTYPEENUM = DBTYPEENUM(19i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_I8: DBTYPEENUM = DBTYPEENUM(20i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_UI8: DBTYPEENUM = DBTYPEENUM(21i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_GUID: DBTYPEENUM = DBTYPEENUM(72i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_VECTOR: DBTYPEENUM = DBTYPEENUM(4096i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_RESERVED: DBTYPEENUM = DBTYPEENUM(32768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_BYTES: DBTYPEENUM = DBTYPEENUM(128i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_STR: DBTYPEENUM = DBTYPEENUM(129i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_WSTR: DBTYPEENUM = DBTYPEENUM(130i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_NUMERIC: DBTYPEENUM = DBTYPEENUM(131i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_UDT: DBTYPEENUM = DBTYPEENUM(132i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_DBDATE: DBTYPEENUM = DBTYPEENUM(133i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_DBTIME: DBTYPEENUM = DBTYPEENUM(134i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_DBTIMESTAMP: DBTYPEENUM = DBTYPEENUM(135i32);
impl ::core::marker::Copy for DBTYPEENUM {}
impl ::core::clone::Clone for DBTYPEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBTYPEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBTYPEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBTYPEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBTYPEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBTYPEENUM15(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_HCHAPTER: DBTYPEENUM15 = DBTYPEENUM15(136i32);
impl ::core::marker::Copy for DBTYPEENUM15 {}
impl ::core::clone::Clone for DBTYPEENUM15 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBTYPEENUM15 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBTYPEENUM15 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBTYPEENUM15 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBTYPEENUM15").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBTYPEENUM20(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_FILETIME: DBTYPEENUM20 = DBTYPEENUM20(64i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_PROPVARIANT: DBTYPEENUM20 = DBTYPEENUM20(138i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_VARNUMERIC: DBTYPEENUM20 = DBTYPEENUM20(139i32);
impl ::core::marker::Copy for DBTYPEENUM20 {}
impl ::core::clone::Clone for DBTYPEENUM20 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBTYPEENUM20 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBTYPEENUM20 {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBTYPEENUM20 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBTYPEENUM20").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_SQLVARIANT: u32 = 144u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBUPDELRULEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUPDELRULE_NOACTION: DBUPDELRULEENUM = DBUPDELRULEENUM(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUPDELRULE_CASCADE: DBUPDELRULEENUM = DBUPDELRULEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUPDELRULE_SETNULL: DBUPDELRULEENUM = DBUPDELRULEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBUPDELRULE_SETDEFAULT: DBUPDELRULEENUM = DBUPDELRULEENUM(3i32);
impl ::core::marker::Copy for DBUPDELRULEENUM {}
impl ::core::clone::Clone for DBUPDELRULEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBUPDELRULEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBUPDELRULEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBUPDELRULEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBUPDELRULEENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBVECTOR {
    pub size: usize,
    pub ptr: *mut ::core::ffi::c_void,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBVECTOR {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBVECTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBVECTOR {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBVECTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBVECTOR>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBVECTOR {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBVECTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct DBVECTOR {
    pub size: usize,
    pub ptr: *mut ::core::ffi::c_void,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBVECTOR {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBVECTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBVECTOR {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBVECTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBVECTOR>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBVECTOR {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBVECTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBWATCHMODEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHMODE_ALL: DBWATCHMODEENUM = DBWATCHMODEENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHMODE_EXTEND: DBWATCHMODEENUM = DBWATCHMODEENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHMODE_MOVE: DBWATCHMODEENUM = DBWATCHMODEENUM(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHMODE_COUNT: DBWATCHMODEENUM = DBWATCHMODEENUM(8i32);
impl ::core::marker::Copy for DBWATCHMODEENUM {}
impl ::core::clone::Clone for DBWATCHMODEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBWATCHMODEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBWATCHMODEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBWATCHMODEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBWATCHMODEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DBWATCHNOTIFYENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHNOTIFY_ROWSCHANGED: DBWATCHNOTIFYENUM = DBWATCHNOTIFYENUM(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHNOTIFY_QUERYDONE: DBWATCHNOTIFYENUM = DBWATCHNOTIFYENUM(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBWATCHNOTIFY_QUERYREEXECUTED: DBWATCHNOTIFYENUM = DBWATCHNOTIFYENUM(3i32);
impl ::core::marker::Copy for DBWATCHNOTIFYENUM {}
impl ::core::clone::Clone for DBWATCHNOTIFYENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DBWATCHNOTIFYENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DBWATCHNOTIFYENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DBWATCHNOTIFYENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DBWATCHNOTIFYENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_ALL_EXCEPT_LIKE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_COLLECTION: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_DELAYFETCHCOLUMNS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_DELAYFETCHSTREAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_ISSTRUCTUREDDOCUMENT: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OPENIFEXISTS: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OUTPUT: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OVERWRITE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_RECURSIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COLLATION_ASC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COLLATION_DESC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COUNTUNAVAILABLE: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ABORTLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217871i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ALREADYINITIALIZED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217838i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ALTERRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217763i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ASYNCNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217771i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217850i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217920i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217845i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADBINDINFO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217912i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADBOOKMARK: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217906i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCHAPTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217914i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217903i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMMANDFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217780i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMMANDID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217802i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMPAREOP: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217881i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTFORM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217800i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217781i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217801i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONVERTFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217828i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOPY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217863i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADDEFERRABILITY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217799i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADDYNAMICERRORID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217830i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADHRESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217832i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADID: i32 = -2147217860i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217806i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADINITSTRING: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217805i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADLOCKMODE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217905i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADLOOKUPID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217831i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADMATCHTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217792i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADORDINAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217835i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPARAMETERNAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217827i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPRECISION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217862i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPROPERTYVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217852i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADRATIO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217902i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADRECORDNUM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217854i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADREGIONHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217878i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217916i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217861i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSOURCEHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217840i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTARTPOSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217890i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTATUSVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217880i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTORAGEFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217882i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTORAGEFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217849i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217860i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217859i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTYPENAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217872i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADUPDATEDELETERULE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217782i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADVALUES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217901i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BOGUS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217665i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217853i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BYREFACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217848i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANCELED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217842i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTCONNECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217770i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTFREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217894i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTRESTART: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217896i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTCANCEL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217899i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTCONVERTVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217913i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTFETCHBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217884i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTFILTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217825i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTORDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217824i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTSCROLLBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217879i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTTRANSLATE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217869i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CHAPTERNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217841i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COLUMNUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217760i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COMMANDNOTPERSISTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217817i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CONCURRENCYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217864i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COSTLIMIT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217907i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DATAOVERFLOW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217833i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217885i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DIALECTNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217898i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DROPRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217776i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATECOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217858i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATECONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217767i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEDATASOURCE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217897i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217816i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217868i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATETABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217857i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ERRORSINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217900i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217887i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_GOALREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217892i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INDEXINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217866i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INTEGRITYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217873i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INVALID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217851i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INVALIDTRANSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217876i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_LIMITREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217909i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MAXPENDCHANGESEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217836i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MISMATCHEDPROVIDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217803i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MULTIPLESTATEMENTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217874i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MULTIPLESTORAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217826i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NEWLYINSERTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217893i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOAGGREGATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217886i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217819i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217908i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCONSTRAINT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217761i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOINDEX: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217867i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOLOCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217855i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NONCONTIGUOUSRANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217877i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOPROVIDERSREGISTERED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217804i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOQUERY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217889i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOSOURCEOBJECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217775i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOSTATISTIC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217764i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217865i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTAREFERENCECOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217910i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTASUBREGION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217875i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTCOLLECTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217773i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTFOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217895i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTPREPARED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217846i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTREENTRANT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217888i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217837i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NULLACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217847i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTCREATIONLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217815i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217779i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTOPEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217915i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OUTOFSPACE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217766i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PARAMNOTOPTIONAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217904i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217839i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PENDINGCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217834i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PENDINGINSERT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217829i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217772i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_READONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217918i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCEEXISTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCELOCKED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217774i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCENOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217762i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCEOUTOFSCOPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217778i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217919i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWSETINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217870i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWSNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217883i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_SCHEMAVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217917i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_TABLEINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217856i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_TIMEOUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217769i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_UNSUPPORTEDCONVERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217891i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_WRITEONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217844i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_ANONYMOUS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_DELEGATE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_IDENTIFY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_IMPERSONATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_INVALID_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_INVALID_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LIKE_ONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LOCAL_EXCLUSIVE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LOCAL_SHARED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_READ: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_READWRITE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_NONE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_READ: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_WRITE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_EXCLUSIVE: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_WRITE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HROW: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct DB_NUMERIC {
    pub precision: u8,
    pub scale: u8,
    pub sign: u8,
    pub val: [u8; 16],
}
impl ::core::marker::Copy for DB_NUMERIC {}
impl ::core::clone::Clone for DB_NUMERIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DB_NUMERIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DB_NUMERIC").field("precision", &self.precision).field("scale", &self.scale).field("sign", &self.sign).field("val", &self.val).finish()
    }
}
unsafe impl ::windows::core::Abi for DB_NUMERIC {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DB_NUMERIC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DB_NUMERIC>()) == 0 }
    }
}
impl ::core::cmp::Eq for DB_NUMERIC {}
impl ::core::default::Default for DB_NUMERIC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_OUT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_CALL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_CONNECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT_INTEGRITY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT_PRIVACY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_FUNCTION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_PROCEDURE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_UNKNOWN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_REMOTE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEARCHABLE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_AUTH_FAILED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217843i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_PERMISSIONDENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217911i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_SAFEMODE_DENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217765i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ASYNCHRONOUS: ::windows::core::HRESULT = ::windows::core::HRESULT(265936i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265939i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(265923i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BUFFERFULL: ::windows::core::HRESULT = ::windows::core::HRESULT(265928i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_CANTRELEASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265930i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COLUMNSCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265937i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COLUMNTYPEMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(265921i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COMMANDREEXECUTED: ::windows::core::HRESULT = ::windows::core::HRESULT(265927i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(265940i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_DIALECTIGNORED: ::windows::core::HRESULT = ::windows::core::HRESULT(265933i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ENDOFROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265926i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(265946i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ERRORSRETURNED: ::windows::core::HRESULT = ::windows::core::HRESULT(265938i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_GOALCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265931i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_LOCKUPGRADED: ::windows::core::HRESULT = ::windows::core::HRESULT(265944i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_MULTIPLECHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265948i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NONEXTROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265925i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NORESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(265929i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NOROWSPECIFICCOLUMNS: ::windows::core::HRESULT = ::windows::core::HRESULT(265949i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NOTSINGLETON: ::windows::core::HRESULT = ::windows::core::HRESULT(265943i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265947i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_PROPERTIESCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265945i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(265920i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_STOPLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(265942i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_TOOMANYCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265941i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_TYPEINFOOVERRIDDEN: ::windows::core::HRESULT = ::windows::core::HRESULT(265922i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDOPERATION: ::windows::core::HRESULT = ::windows::core::HRESULT(265932i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDPHASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265934i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDREASON: ::windows::core::HRESULT = ::windows::core::HRESULT(265935i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_UNSEARCHABLE: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct DB_VARNUMERIC {
    pub precision: u8,
    pub scale: i8,
    pub sign: u8,
    pub val: [u8; 1],
}
impl ::core::marker::Copy for DB_VARNUMERIC {}
impl ::core::clone::Clone for DB_VARNUMERIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DB_VARNUMERIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DB_VARNUMERIC").field("precision", &self.precision).field("scale", &self.scale).field("sign", &self.sign).field("val", &self.val).finish()
    }
}
unsafe impl ::windows::core::Abi for DB_VARNUMERIC {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DB_VARNUMERIC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DB_VARNUMERIC>()) == 0 }
    }
}
impl ::core::cmp::Eq for DB_VARNUMERIC {}
impl ::core::default::Default for DB_VARNUMERIC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DCINFO {
    pub eInfoType: u32,
    pub vData: super::Com::VARIANT,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DCINFO {
    fn clone(&self) -> Self {
        Self { eInfoType: self.eInfoType, vData: self.vData.clone() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DCINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DCINFO {
    fn eq(&self, other: &Self) -> bool {
        self.eInfoType == other.eInfoType && self.vData == other.vData
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DCINFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DCINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DCINFOTYPEENUM(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DCINFOTYPE_VERSION: DCINFOTYPEENUM = DCINFOTYPEENUM(1i32);
impl ::core::marker::Copy for DCINFOTYPEENUM {}
impl ::core::clone::Clone for DCINFOTYPEENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DCINFOTYPEENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DCINFOTYPEENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for DCINFOTYPEENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DCINFOTYPEENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DELIVERY_AGENT_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DELIVERY_AGENT_FLAG_NO_BROADCAST: DELIVERY_AGENT_FLAGS = DELIVERY_AGENT_FLAGS(4i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DELIVERY_AGENT_FLAG_NO_RESTRICTIONS: DELIVERY_AGENT_FLAGS = DELIVERY_AGENT_FLAGS(8i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DELIVERY_AGENT_FLAG_SILENT_DIAL: DELIVERY_AGENT_FLAGS = DELIVERY_AGENT_FLAGS(16i32);
impl ::core::marker::Copy for DELIVERY_AGENT_FLAGS {}
impl ::core::clone::Clone for DELIVERY_AGENT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DELIVERY_AGENT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DELIVERY_AGENT_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DELIVERY_AGENT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DELIVERY_AGENT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_ALL: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_HITCOUNT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_LASTSEENTIME: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPDISPID: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPGUID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPMODIFIABLE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPNAME: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_STORELEVEL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTAUTOMATIC: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTMANUAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTUSED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_RANK: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_RANKVECTOR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_REVNAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_UNFILTERED: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_VIRTUALPATH: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_WORKID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_ALREADYDISABLED: i32 = -2147220447i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_ALREADYENABLED: i32 = -2147220454i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADREQUEST: i32 = -2147220475i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADRESULT: i32 = -2147220445i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADSEQUENCE: i32 = -2147220473i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BUFFERTOOSMALL: i32 = -2147220449i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CANNOTREMOVECONCURRENT: i32 = -2147220443i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CANNOTWRITEREGISTRY: i32 = -2147220444i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CONFIGBAD: i32 = -2147220470i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CONFIGNOTRIGHTTYPE: i32 = -2147220456i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATANOTPRESENT: i32 = -2147220464i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATASOURCENOTAVAILABLE: i32 = -2147220478i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATASOURCENOTDISABLED: i32 = -2147220459i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DUPLICATEID: i32 = -2147220462i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INDEXDIRECTORY: i32 = -2147220452i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDCATALOGNAME: i32 = -2147220457i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDDATASOURCE: i32 = -2147220479i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDTAGDB: i32 = -2147220458i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_MESSAGETOOLONG: i32 = -2147220472i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_MISSINGCATALOG: i32 = -2147220440i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_NOMOREDATA: i32 = -2147220480i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PARAMOUTOFRANGE: i32 = -2147220448i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PROPVERSIONMISMATCH: i32 = -2147220441i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PROTOCOLVERSION: i32 = -2147220455i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_QUERYCANCELED: i32 = -2147220477i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_QUERYHUNG: i32 = -2147220446i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_REGISTRY: i32 = -2147220460i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SEARCHCATNAMECOLLISION: i32 = -2147220442i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SERVERCAPACITY: i32 = -2147220474i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SERVERERROR: i32 = -2147220471i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SETSTATUSINPROGRESS: i32 = -2147220463i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_TOOMANYDATASOURCES: i32 = -2147220461i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_UNKNOWNPARAM: i32 = -2147220450i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_UNKNOWNREQUEST: i32 = -2147220476i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_VALUETOOLARGE: i32 = -2147220451i32;
pub const DataLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206cdb2_19c1_11d1_89e0_00c04fd7a829);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct DataSource(::windows::core::IUnknown);
impl DataSource {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn getDataMember(&self, bstrdm: *const u16, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).getDataMember)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn getDataMemberName(&self, lindex: i32) -> ::windows::core::Result<*mut u16> {
        let mut result__: *mut u16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).getDataMemberName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(&mut result__)).from_abi::<*mut u16>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn getDataMemberCount(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).getDataMemberCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn addDataSourceListener<'a, Param0: ::windows::core::IntoParam<'a, DataSourceListener>>(&self, pdsl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).addDataSourceListener)(::core::mem::transmute_copy(self), pdsl.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn removeDataSourceListener<'a, Param0: ::windows::core::IntoParam<'a, DataSourceListener>>(&self, pdsl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).removeDataSourceListener)(::core::mem::transmute_copy(self), pdsl.into_param().abi()).ok()
    }
}
impl ::core::convert::From<DataSource> for ::windows::core::IUnknown {
    fn from(value: DataSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DataSource> for ::windows::core::IUnknown {
    fn from(value: &DataSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a DataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for DataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSource {}
impl ::core::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DataSource {
    type Vtable = DataSource_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab3_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSource_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub getDataMember: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub getDataMemberName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, pbstrdm: *mut *mut u16) -> ::windows::core::HRESULT,
    pub getDataMemberCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub addDataSourceListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub removeDataSourceListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct DataSourceListener(::windows::core::IUnknown);
impl DataSourceListener {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn dataMemberChanged(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).dataMemberChanged)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn dataMemberAdded(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).dataMemberAdded)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn dataMemberRemoved(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).dataMemberRemoved)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
}
impl ::core::convert::From<DataSourceListener> for ::windows::core::IUnknown {
    fn from(value: DataSourceListener) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DataSourceListener> for ::windows::core::IUnknown {
    fn from(value: &DataSourceListener) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSourceListener {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a DataSourceListener {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for DataSourceListener {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSourceListener {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSourceListener {}
impl ::core::fmt::Debug for DataSourceListener {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceListener").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DataSourceListener {
    type Vtable = DataSourceListener_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab2_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceListener_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub dataMemberChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub dataMemberAdded: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub dataMemberRemoved: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DataSourceObject(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DataSourceObject {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DataSourceObject> for ::windows::core::IUnknown {
    fn from(value: DataSourceObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DataSourceObject> for ::windows::core::IUnknown {
    fn from(value: &DataSourceObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DataSourceObject> for super::Com::IDispatch {
    fn from(value: DataSourceObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DataSourceObject> for super::Com::IDispatch {
    fn from(value: &DataSourceObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for &'a DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DataSourceObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DataSourceObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DataSourceObject {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DataSourceObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceObject").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DataSourceObject {
    type Vtable = DataSourceObject_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ae9a4e4_18d4_11d1_b3b3_00aa00c1a924);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceObject_Vtbl {
    pub base__: super::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct EBindInfoOptions(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BIO_BINDER: EBindInfoOptions = EBindInfoOptions(1i32);
impl ::core::marker::Copy for EBindInfoOptions {}
impl ::core::clone::Clone for EBindInfoOptions {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EBindInfoOptions {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EBindInfoOptions {
    type Abi = Self;
}
impl ::core::fmt::Debug for EBindInfoOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EBindInfoOptions").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct ERRORINFO {
    pub hrError: ::windows::core::HRESULT,
    pub dwMinor: u32,
    pub clsid: ::windows::core::GUID,
    pub iid: ::windows::core::GUID,
    pub dispid: i32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for ERRORINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for ERRORINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for ERRORINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for ERRORINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ERRORINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for ERRORINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for ERRORINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
pub struct ERRORINFO {
    pub hrError: ::windows::core::HRESULT,
    pub dwMinor: u32,
    pub clsid: ::windows::core::GUID,
    pub iid: ::windows::core::GUID,
    pub dispid: i32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for ERRORINFO {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for ERRORINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for ERRORINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for ERRORINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ERRORINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for ERRORINFO {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for ERRORINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE: u32 = 13824u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE_CB: u32 = 51968u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE_FD: u32 = 64768u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CMDLINE: u32 = 5376u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_COLLATOR: u32 = 1280u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CONNMGR: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CONTENT_SOURCE: u32 = 13312u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_DATASOURCE: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_DAV: u32 = 8960u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_EXSTOREPH: u32 = 9984u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_FLTRDMN: u32 = 9216u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_GATHERER: u32 = 3328u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_INDEXER: u32 = 4352u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_MSS: u32 = 8448u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NETWORKING: u32 = 768u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NLADMIN: u32 = 6400u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NOTESPH: u32 = 9728u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_OLEDB_BINDER: u32 = 9472u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_PEOPLE_IMPORT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_PROTHNDLR: u32 = 4608u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_QUERY: u32 = 1792u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_REMOTE_EXSTOREPH: u32 = 13568u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SCHEMA: u32 = 3072u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SCRIPTPI: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SECURITY: u32 = 5120u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SETUP: u32 = 4864u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SRCH_SCHEMA_CACHE: u32 = 13056u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_XML: u32 = 8704u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUDIENCECOMPUTATION_CANNOTSTART: i32 = -1073738223i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUTOCAT_CANT_CREATE_FILE_SHARE: i32 = -1073738726i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUTOCAT_PERFMON: i32 = -1073738753i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CONFIG_ERROR: i32 = -1073738821i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CONFIG_SYNTAX: i32 = -2147482604i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CRAWL_SCHEDULED: i32 = 1073744884i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_DETAILED_FILTERPOOL_ADD_FAILED: i32 = -1073738719i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_DSS_NOT_ENABLED: i32 = -2147476572i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_ENUMERATE_SESSIONS_FAILED: i32 = -1073738720i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_EXCEPTION: i32 = -1073740815i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FAILED_CREATE_GATHERER_LOG: i32 = -2147480587i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FAILED_INITIALIZE_CRAWL: i32 = -1073738765i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTERPOOL_ADD_FAILED: i32 = -1073738722i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTERPOOL_DELETE_FAILED: i32 = -1073738721i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_FORCE_TERMINATE: i32 = -2147473624i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_NOT_INITIALIZED: i32 = -1073738724i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_NOT_TERMINATED: i32 = -1073738723i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERER_DATASOURCE: i32 = -1073738727i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERER_PERFMON: i32 = -1073738817i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERSVC_PERFMON: i32 = -1073738818i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_ADVISE_FAILED: i32 = -1073738798i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_APP_INIT_FAILED: i32 = -1073738766i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_AUTODESCENCODE_INVALID: i32 = -2147480592i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_AUTODESCLEN_ADJUSTED: i32 = -2147480603i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_BACKUPAPP_COMPLETE: i32 = 3077i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_BACKUPAPP_ERROR: i32 = -1073738748i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CANT_CREATE_DOCID: i32 = -1073738793i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CANT_DELETE_DOCID: i32 = -1073738792i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_CORRUPT: i32 = -1073738732i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_FAILED: i32 = -1073738736i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_FILE_MISSING: i32 = -1073738731i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_IN_PROGRESS: i32 = -2147480609i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_NOT_STARTED: i32 = -2147480625i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_ERROR: i32 = -2147480624i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED: i32 = -2147480612i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED_INIT: i32 = -2147480611i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRITICAL_ERROR: i32 = -1073738799i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DAEMON_TERMINATED: i32 = -2147480570i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DELETING_HISTORY_ITEMS: i32 = -1073738774i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DIRTY_STARTUP: i32 = -2147480576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DISK_FULL: i32 = -2147480594i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_ADAPTIVE: i32 = 1073744891i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_CRAWL: i32 = 1073744842i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_INCREMENTAL: i32 = 1073744871i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_EXCEPTION: i32 = -1073738810i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_FLUSH_FAILED: i32 = -1073738737i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_FROM_NOT_SET: i32 = -1073738776i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_HISTORY_CORRUPTION_DETECTED: i32 = -2147480575i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_INTERNAL: i32 = -1073738804i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_INVALID_NETWORK_ACCESS_ACCOUNT: i32 = -1073738739i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_LOCK_FAILED: i32 = -1073738784i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_NO_CRAWL_SEEDS: i32 = -2147480602i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_NO_SCHEMA: i32 = -2147480593i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_OBJ_INIT_FAILED: i32 = -1073738796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PLUGINMGR_INIT_FAILED: i32 = -1073738767i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PLUGIN_INIT_FAILED: i32 = -1073738795i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_INIT_FAILED: i32 = -1073738740i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_LOAD_FAILED: i32 = -1073738741i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_READ_CHECKPOINT_FAILED: i32 = -1073738733i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RECOVERY_FAILURE: i32 = -1073738222i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_REG_MISSING: i32 = -2147480610i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESET_START: i32 = 1073744865i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTOREAPP_COMPLETE: i32 = 3075i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTOREAPP_ERROR: i32 = -1073738750i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_CHECKPOINT_FAILED: i32 = -1073738734i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_COMPLETE: i32 = 3069i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_ERROR: i32 = -1073738754i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESUME: i32 = 1073744868i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SAVE_FAILED: i32 = -1073738735i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SERVICE_INIT: i32 = -1073738794i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_CRAWL: i32 = 1073744843i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_CRAWL_IF_RESET: i32 = -2147480595i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_PAUSE: i32 = -2147480606i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_STOP_START: i32 = 1073744876i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SYSTEM_LCID_CHANGED: i32 = -2147480562i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_THROTTLE: i32 = 1073744867i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_TRANSACTION_FAIL: i32 = -1073738797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_HASHMAP_INSERT: i32 = -1073738816i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_HASHMAP_UPDATE: i32 = -1073738811i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_DISCONNECT: i32 = -2147476585i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_FAILED: i32 = -2147476627i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_SUCCEEDED: i32 = 7019i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_ENDED: i32 = 1073748873i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_FAILED: i32 = -1073734797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_START: i32 = 1073748872i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_CI_LOAD_ERROR: i32 = -1073734785i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_ALREADY_ADDED: i32 = 1073748870i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_CONTACT_FAILED: i32 = -1073734800i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_UNABLE_TO_REMOVE: i32 = -1073734755i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_CREATE_PER_USER_CATALOG: i32 = -1073731797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_SET_MAX_JETINSTANCE: i32 = -1073731798i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_UNLOAD_PER_USER_CATALOG: i32 = -1073731796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_INIT_ERROR: i32 = -1073734814i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_INVALID_DIRECTORY: i32 = -1073734813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_LOAD_FAIL: i32 = -1073734781i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_MISSING_APP_DIRECTORY: i32 = -1073734758i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_NEW_PROJECT: i32 = -1073734754i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_NO_SEARCH_SERVERS: i32 = -2147476630i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_OUT_OF_DATABASE_INSTANCE: i32 = -1073731799i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PAUSED_FOR_DISKFULL: i32 = -1073734811i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PERFMON: i32 = -1073734760i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROPSTORE_INIT_FAILED: i32 = -1073734787i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_ABORTED: i32 = 1073748899i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_COMMITTED: i32 = 1073748898i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_COMMIT_FAILED: i32 = -1073734747i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_ERROR: i32 = -1073734812i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STARTED: i32 = 1073748841i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STATE_CORRUPT: i32 = -1073734780i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STOPPED: i32 = -2147476633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_SUCCEEDED: i32 = 7016i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REG_ERROR: i32 = -1073734756i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REG_MISSING: i32 = -1073734796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVED_PROJECT: i32 = -1073734753i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVE_DSS_FAILED: i32 = -1073734801i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVE_DSS_SUCCEEDED: i32 = 7020i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_RESET_FOR_CORRUPTION: i32 = -1073734784i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_SCHEMA_COPY_ERROR: i32 = -1073734823i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_SHUTDOWN: i32 = 1073748866i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_STARTED: i32 = 1073748824i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_VERIFY_PROP_ACCOUNT: i32 = -1073734768i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_COMPILE_FAILED: i32 = -2147480583i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_CREATE_DB_FAILED: i32 = -2147480584i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_PROPAGATION_COPY_FAILED: i32 = -2147480585i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_PROPAGATION_FAILED: i32 = -2147480582i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LOCAL_GROUPS_CACHE_FLUSHED: i32 = 1073744920i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LOCAL_GROUP_NOT_EXPANDED: i32 = 1073744919i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_FAILURE: i32 = -1073738745i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_FAILURE_SCOPE_EXCEEDED_LOGGING: i32 = -2147480568i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_RESTORED: i32 = 1073744905i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_RESTORED_SCOPE_EXCEEDED_LOGGING: i32 = -2147480566i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_THREAD_EXIT_FAILED: i32 = -1073738725i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_OUTOFMEMORY: i32 = -1073740817i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_ALREADY_EXISTS: i32 = -2147473626i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_NOT_LOADED: i32 = -2147473628i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_REGISTRY_TROUBLE: i32 = -2147473627i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PROTOCOL_HOST_FORCE_TERMINATE: i32 = -2147473625i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_REG_VERSION: i32 = -1073738790i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_CREATE_PATH_RULES_FAILED: i32 = -2147482634i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_CSM_SAVE_FAILED: i32 = -1073740805i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_FAILED: i32 = -1073740808i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_ROLLBACK_ERRORS: i32 = -2147482630i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_SUCCEEDED: i32 = 1073742841i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DROPPED_EVENTS: i32 = -2147482633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_FAILED: i32 = -1073740813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_STARTED: i32 = -2147482640i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_SUCCEEDED: i32 = 1073742834i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_FAILED: i32 = -1073740818i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_SUCCEEDED: i32 = 1073742829i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STARTED: i32 = 1073742827i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STARTING_SETUP: i32 = 1073742828i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STOPPED: i32 = 1073742837i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_STS_INIT_SECURITY_FAILED: i32 = -2147480554i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SYSTEM_EXCEPTION: i32 = -2147482595i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSACTION_READ: i32 = -1073738809i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_APPEND: i32 = -1073738814i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_CREATE: i32 = -1073738791i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_CREATE_TRX: i32 = -1073738815i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_UPDATE: i32 = -1073738813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_UNPRIVILEGED_SERVICE_ACCOUNT: i32 = -2147482596i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_USING_DIFFERENT_WORD_BREAKER: i32 = -2147480580i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILE: i32 = -2147473634i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILES: i32 = -2147473635i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WBREAKER_NOT_LOADED: i32 = -2147480586i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WIN32_ERROR: i32 = -2147473633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_ACCESS_DENIED: i32 = -2147216990i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_BADCONFIG_OR_ACCESSDENIED: i32 = -2147216988i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_ACCOUNT_INFO: i32 = -2147216984i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_EXCHANGE_SERVER: i32 = -2147216989i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_SERVER_CONFIG: i32 = -2147216991i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NOT_ADMIN_OR_WRONG_SITE: i32 = -2147216986i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NO_CONFIG: i32 = -2147216992i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NO_MAPI: i32 = -2147216985i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_WRONG_SERVER_OR_ACCT: i32 = -2147216987i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXSTOREPH_E_UNEXPECTED: i32 = -2147211519i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_CMDFATAL: u32 = 20u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_CONTROL: u32 = 25u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DBCORRUPT: u32 = 23u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DBFATAL: u32 = 21u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DEADLOCK: u32 = 13u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_HARDWARE: u32 = 24u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_INFO: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_INTOK: u32 = 18u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_LIMIT: u32 = 19u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_MAXISEVERITY: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_MISSING: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_PERMIT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_RESOURCE: u32 = 17u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_SYNTAX: u32 = 15u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_TABCORRUPT: u32 = 22u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_TYPE: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_USER: u32 = 16u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FAIL: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct FILTERED_DATA_SOURCES {
    pub pwcsExtension: ::windows::core::PCWSTR,
    pub pwcsMime: ::windows::core::PCWSTR,
    pub pClsid: *const ::windows::core::GUID,
    pub pwcsOverride: ::windows::core::PCWSTR,
}
impl ::core::marker::Copy for FILTERED_DATA_SOURCES {}
impl ::core::clone::Clone for FILTERED_DATA_SOURCES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FILTERED_DATA_SOURCES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FILTERED_DATA_SOURCES").field("pwcsExtension", &self.pwcsExtension).field("pwcsMime", &self.pwcsMime).field("pClsid", &self.pClsid).field("pwcsOverride", &self.pwcsOverride).finish()
    }
}
unsafe impl ::windows::core::Abi for FILTERED_DATA_SOURCES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FILTERED_DATA_SOURCES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILTERED_DATA_SOURCES>()) == 0 }
    }
}
impl ::core::cmp::Eq for FILTERED_DATA_SOURCES {}
impl ::core::default::Default for FILTERED_DATA_SOURCES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_CANNOT_DECRYPT_PASSWORD: i32 = -2147212282i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_ENCRYPTED_DOCUMENT: i32 = -2147212283i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_FILTER_INIT_FAILED: i32 = -2147212284i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_QI_FILTER_FAILED: i32 = -2147212286i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_UNEXPECTED: i32 = -2147212287i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLLOW_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FF_INDEXCOMPLEXURLS: FOLLOW_FLAGS = FOLLOW_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FF_SUPPRESSINDEXING: FOLLOW_FLAGS = FOLLOW_FLAGS(2i32);
impl ::core::marker::Copy for FOLLOW_FLAGS {}
impl ::core::clone::Clone for FOLLOW_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLLOW_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLLOW_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLLOW_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLLOW_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ADMIN_BLOB_CORRUPT: i32 = -2147207676i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_AFFINITY_MASK: i32 = -2147207651i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ALREADY_INITIALIZED: i32 = -2147207604i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ANOTHER_STATUS_CHANGE_IS_ALREADY_ACTIVE: i32 = -2147207635i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_BATCH_ABORTED: i32 = -2147207636i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CATALOG_ALREADY_EXISTS: i32 = -2147207656i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CATALOG_DOES_NOT_EXIST: i32 = -2147207639i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_CBID_OUT_OF_BOUND: i32 = -2147169535i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_NOT_ENOUGH_AVAIL_PHY_MEM: i32 = -2147169534i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_NOT_ENOUGH_OCC_BUFFER: i32 = -2147169533i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_OUT_OF_MEMORY: i32 = -2147169536i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_COM_SIGNATURE_VALIDATION: i32 = -2147207652i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CORRUPT_GATHERER_HASH_MAP: i32 = -2147207619i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CORRUPT_PROPERTY_STORE: i32 = -2147207622i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CORRUPT_WORDLIST: i32 = -2147169532i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_DATATYPE_MISALIGNMENT: i32 = -2147207605i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_DEPENDENT_TRAN_FAILED_TO_PERSIST: i32 = -2147207641i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_DOC_TOO_HUGE: i32 = -2147207606i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_DUPLICATE_OBJECT: i32 = -2147207644i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ERROR_WRITING_REGISTRY: i32 = -2147207674i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_EXCEEDED_MAX_PLUGINS: i32 = -2147207647i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FAILED_TO_CREATE_ACCESSOR: i32 = -2147207625i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FAILURE_TO_POST_SETCOMPLETION_STATUS: i32 = -2147207597i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_DID_NOT_CONNECT: i32 = -2147207660i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_DOC_TIMEOUT: i32 = -2147156733i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_DOC_UNEXPECTED_EXIT: i32 = -2147156731i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_FAILED_TO_LOAD_IFILTER: i32 = -2147156734i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_FILTER_CAUSED_SHARING_VIOLATION: i32 = -2147156725i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_IDLE: i32 = -2147207595i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_IFILTER_INIT_FAILED: i32 = -2147156735i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_NOISE_NO_IPERSISTSTREAM_ON_TEXT_FILTER: i32 = -2147156729i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_NOISE_NO_TEXT_FILTER: i32 = -2147156730i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_NOISE_TEXT_FILTER_INIT_FAILED: i32 = -2147156727i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_NOISE_TEXT_FILTER_LOAD_FAILED: i32 = -2147156728i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_NO_IPERSIST_INTERFACE: i32 = -2147156736i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_OCCURRENCE_OVERFLOW: i32 = -2147156726i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_OWNERSHIP_OBSOLETE: i32 = -2147207650i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_SHUTDOWN: i32 = -2147207640i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_TIMEOUT: i32 = -2147207632i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_UNEXPECTED_EXIT: i32 = -2147156732i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_UNRESPONSIVE: i32 = -2147207594i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FD_USED_TOO_MUCH_MEMORY: i32 = -2147207603i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_FILTER_SINGLE_THREADED: i32 = -2147207675i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_HIGH_MEMORY_PRESSURE: i32 = -2147207601i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_CODEPAGE: i32 = -2147207596i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_DOCID: i32 = -2147207663i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_ISOLATE_ERROR_BATCH: i32 = -2147207600i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_PROG_ID: i32 = -2147207614i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_PROJECT_ID: i32 = -2147207598i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_PROPERTY: i32 = -2147207630i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_INVALID_TYPE: i32 = -2147207624i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_KEY_NOT_CACHED: i32 = -2147207618i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_LIBRARY_NOT_LOADED: i32 = -2147207627i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_NOT_PROCESSED_DUE_TO_PREVIOUS_ERRORS: i32 = -2147207633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_NO_MORE_PROPERTIES: i32 = -2147207629i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_NO_PLUGINS: i32 = -2147207638i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_NO_PROPERTY_STORE: i32 = -1073465766i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_OUT_OF_RANGE: i32 = -2147207623i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PATH_TOO_LONG: i32 = -2147207654i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PAUSE_EXTERNAL: i32 = -2147207662i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PERFMON_FULL: i32 = -2147207626i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PERF_NOT_LOADED: i32 = -2147207611i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PIPE_DATA_CORRUPTED: i32 = -2147207671i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PIPE_NOT_CONNECTED: i32 = -2147207677i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PROGID_REQUIRED: i32 = -2147207658i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PROJECT_NOT_INITALIZED: i32 = -2147207672i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PROJECT_SHUTDOWN: i32 = -2147207673i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_PROPERTY_STORE_WORKID_NOTVALID: i32 = -2147207621i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_READONLY_CATALOG: i32 = -2147207612i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_REDUNDANT_TRAN_FAILURE: i32 = -2147207642i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_REJECTED_DUE_TO_PROJECT_STATUS: i32 = -2147207661i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_RESOURCE_SHUTDOWN: i32 = -2147207631i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_RETRY_HUGE_DOC: i32 = -2147207608i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_RETRY_SINGLE_DOC_PER_BATCH: i32 = -2147207599i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_SECRET_NOT_FOUND: i32 = -2147207678i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_SERIAL_STREAM_CORRUPT: i32 = -2147207613i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_STACK_CORRUPTED: i32 = -2147207615i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_STATIC_THREAD_INVALID_ARGUMENTS: i32 = -2147207657i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_UNEXPECTED_EXIT: i32 = -2147207602i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_UNKNOWN_FD_TYPE: i32 = -2147207607i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_UNKNOWN_PLUGIN: i32 = -2147207628i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_UPGRADE_INTERFACE_ALREADY_INSTANTIATED: i32 = -2147207616i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_UPGRADE_INTERFACE_ALREADY_SHUTDOWN: i32 = -2147207617i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_URB_TOO_BIG: i32 = -2147207664i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_INVALID_ADMIN_CLIENT: i32 = -2147207653i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_BEYOND_QUOTA: i32 = 276002i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_CATALOG_BLOB_MISMATCHED: i32 = 276056i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_PROPERTY_RESET: i32 = 276057i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_PROPERTY_STORE_END_OF_ENUMERATION: i32 = 276028i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_READONLY_CATALOG: i32 = 276038i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_REDUNDANT: i32 = 276005i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_RESOURCES_STARTING_TO_GET_LOW: i32 = 275993i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_RESUME: i32 = 276014i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_STATUS_CHANGE_REQUEST: i32 = 276011i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_S_TRY_TO_FLUSH: i32 = 276055i32;
pub const FilterRegistration: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e175b8d_f52a_11d8_b9a5_505054503030);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GENERATE_METHOD_PREFIXMATCH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GENERATE_METHOD_STEMMED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GHTR_E_INSUFFICIENT_DISK_SPACE: i32 = -2147218037i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GHTR_E_LOCAL_SERVER_UNAVAILABLE: i32 = -2147218055i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_ADDLINKS_FAILED_WILL_RETRY_PARENT: i32 = -2147217989i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_APPLICATION_NOT_FOUND: i32 = -2147218079i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_AUTOCAT_UNEXPECTED: i32 = -2147218012i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_BACKUP_VALIDATION_FAIL: i32 = -2147217994i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_BAD_FILTER_DAEMON: i32 = -2147218119i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_BAD_FILTER_HOST: i32 = -2147217993i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_CANNOT_ENABLE_CHECKPOINT: i32 = -2147218002i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_CANNOT_REMOVE_PLUGINMGR: i32 = -2147218078i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_CONFIG_DUP_EXTENSION: i32 = -2147218165i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_CONFIG_DUP_PROJECT: i32 = -2147218166i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_CONTENT_ID_CONFLICT: i32 = -2147218062i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_DIRMON_NOT_INITIALZED: i32 = -2147218019i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_DUPLICATE_OBJECT: i32 = -2147218174i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_DUPLICATE_PROJECT: i32 = -2147218094i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_DUPLICATE_URL: i32 = -2147218163i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_DUP_PROPERTY_MAPPING: i32 = -2147218134i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_EMPTY_DACL: i32 = -2147218006i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_ERROR_INITIALIZING_PERFMON: i32 = -2147218171i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_ERROR_OBJECT_NOT_FOUND: i32 = -2147218170i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_ERROR_WRITING_REGISTRY: i32 = -2147218172i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTERPOOL_NOTFOUND: i32 = -2147217990i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_FAULT: i32 = -2147218075i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_INIT: i32 = -2147218130i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_INTERRUPTED: i32 = -2147218092i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_INVALID_MESSAGE: i32 = -2147218158i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_NOT_FOUND: i32 = -2147218154i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_NO_CODEPAGE: i32 = -2147218123i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_NO_MORE_THREADS: i32 = -2147218153i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_PROCESS_TERMINATED: i32 = -2147218159i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_PROCESS_TERMINATED_QUOTA: i32 = -2147218151i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FILTER_SINGLE_THREADED: i32 = -2147218069i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FOLDER_CRAWLED_BY_ANOTHER_WORKSPACE: i32 = -2147218007i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FORCE_NOTIFICATION_RESET: i32 = -2147218065i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_FROM_NOT_SPECIFIED: i32 = -2147218109i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_IE_OFFLINE: i32 = -2147218120i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INSUFFICIENT_EXAMPLE_CATEGORIES: i32 = -2147218014i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INSUFFICIENT_EXAMPLE_DOCUMENTS: i32 = -2147218013i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INSUFFICIENT_FEATURE_TERMS: i32 = -2147218015i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALIDFUNCTION: i32 = -2147218161i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_ACCOUNT: i32 = -2147218132i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_ACCOUNT_SYNTAX: i32 = -2147218129i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_APPLICATION_NAME: i32 = -2147218077i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_CALL_FROM_WBREAKER: i32 = -2147218058i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_DIRECTORY: i32 = -2147218093i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_EXTENSION: i32 = -2147218107i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_GROW_FACTOR: i32 = -2147218106i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_HOST_NAME: i32 = -2147218096i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_LOG_FILE_NAME: i32 = -2147218103i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_MAPPING: i32 = -2147218112i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_PATH: i32 = -2147218124i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_PATH_EXPRESSION: i32 = -2147218088i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_PATH_SPEC: i32 = -2147218016i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_PROJECT_NAME: i32 = -2147218142i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_PROXY_PORT: i32 = -2147218091i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_RESOURCE_ID: i32 = -2147218035i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_RETRIES: i32 = -2147218104i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_START_ADDRESS: i32 = -2147217998i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_START_PAGE: i32 = -2147218095i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_START_PAGE_HOST: i32 = -2147218087i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_START_PAGE_PATH: i32 = -2147218080i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_STREAM_LOGS_COUNT: i32 = -2147218108i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_INVALID_TIME_OUT: i32 = -2147218105i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_JET_BACKUP_ERROR: i32 = -2147218026i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_JET_RESTORE_ERROR: i32 = -2147218025i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_LOCAL_GROUPS_EXPANSION_INTERNAL_ERROR: i32 = -2147216867i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NAME_TOO_LONG: i32 = -2147218156i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NESTED_HIERARCHICAL_START_ADDRESSES: i32 = -2147218034i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOFILTERSINK: i32 = -2147218160i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NON_FIXED_DRIVE: i32 = -2147218074i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIFICATION_FILE_SHARE_INFO_NOT_AVAILABLE: i32 = -2147218040i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIFICATION_LOCAL_PATH_MUST_USE_FIXED_DRIVE: i32 = -2147218039i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIFICATION_START_ADDRESS_INVALID: i32 = -2147218042i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIFICATION_START_PAGE: i32 = -2147218137i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIFICATION_TYPE_NOT_SUPPORTED: i32 = -2147218041i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIF_ACCESS_TOKEN_UPDATED: i32 = -2147218020i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIF_BEING_REMOVED: i32 = -2147218018i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NOTIF_EXCESSIVE_THROUGHPUT: i32 = -2147218017i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NO_IDENTITY: i32 = -2147218155i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NO_PRTCLHNLR: i32 = -2147218121i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_NTF_CLIENT_NOT_SUBSCRIBED: i32 = -1073476167i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_OBJECT_NOT_VALID: i32 = -2147218005i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_OUT_OF_DOC_ID: i32 = -2147218138i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PIPE_NOT_CONNECTTED: i32 = -2147217996i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PLUGIN_NOT_REGISTERED: i32 = -2147218021i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PROJECT_NOT_INITIALIZED: i32 = -2147218149i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PROPERTIES_EXCEEDED: i32 = -2147218000i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PROPERTY_LIST_NOT_INITIALIZED: i32 = -2147218057i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PROXY_NAME: i32 = -2147218127i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_PRT_HNDLR_PROGID_MISSING: i32 = -2147218152i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_RECOVERABLE_EXOLEDB_ERROR: i32 = -2147218060i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_RETRY: i32 = -2147218027i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SCHEMA_ERRORS_OCCURRED: i32 = -2147218054i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SCOPES_EXCEEDED: i32 = -2147218001i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SECRET_NOT_FOUND: i32 = -2147218089i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SERVER_UNAVAILABLE: i32 = -2147218126i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SHUTTING_DOWN: i32 = -2147218141i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_SINGLE_THREADED_EMBEDDING: i32 = -2147218011i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_TIMEOUT: i32 = -2147218053i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_TOO_MANY_PLUGINS: i32 = -2147218162i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_UNABLE_TO_READ_EXCHANGE_STORE: i32 = -2147218061i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_UNABLE_TO_READ_REGISTRY: i32 = -2147218173i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_UNKNOWN_PROTOCOL: i32 = -2147218150i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_UNSUPPORTED_PROPERTY_TYPE: i32 = -2147218157i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_URL_EXCLUDED: i32 = -2147218169i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_URL_UNIDENTIFIED: i32 = -2147218067i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_USER_AGENT_NOT_SPECIFIED: i32 = -2147218111i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_E_VALUE_NOT_AVAILABLE: i32 = -2147218139i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_BAD_FILE_LINK: i32 = 265580i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CANNOT_FILTER: i32 = 265520i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CANNOT_WORDBREAK: i32 = 265638i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CONFIG_HAS_ACCOUNTS: i32 = 265558i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CRAWL_ADAPTIVE: i32 = 265605i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CRAWL_FULL: i32 = 265603i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CRAWL_INCREMENTAL: i32 = 265604i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_CRAWL_SCHEDULED: i32 = 265576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_END_PROCESS_LOOP_NOTIFY_QUEUE: i32 = 265584i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_END_STD_CHUNKS: i32 = 265508i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_MODIFIED_PARTS: i32 = 265592i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_NOT_ALL_PARTS: i32 = 265582i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_NO_CRAWL_SEEDS: i32 = 265515i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_NO_INDEX: i32 = 265616i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_OFFICE_CHILD: i32 = 265626i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_PAUSE_REASON_BACKOFF: i32 = 265620i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_PAUSE_REASON_EXTERNAL: i32 = 265618i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_PAUSE_REASON_PROFILE_IMPORT: i32 = 265651i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_PAUSE_REASON_UPGRADING: i32 = 265619i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_PROB_NOT_MODIFIED: i32 = 265575i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_START_FILTER_FROM_BODY: i32 = 265585i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_START_FILTER_FROM_PROTOCOL: i32 = 265578i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_CHANGE_IGNORED: i32 = 265500i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_END_CRAWL: i32 = 265501i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_PAUSE: i32 = 265505i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_RESET: i32 = 265502i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_RESUME: i32 = 265504i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_START: i32 = 265526i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_STOP: i32 = 265523i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_STATUS_THROTTLE: i32 = 265503i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_TRANSACTION_IGNORED: i32 = 265577i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const GTHR_S_USE_MIME_FILTER: i32 = 265639i32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub struct HITRANGE {
    pub iPosition: u32,
    pub cLength: u32,
}
impl ::core::marker::Copy for HITRANGE {}
impl ::core::clone::Clone for HITRANGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HITRANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HITRANGE").field("iPosition", &self.iPosition).field("cLength", &self.cLength).finish()
    }
}
unsafe impl ::windows::core::Abi for HITRANGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HITRANGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HITRANGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for HITRANGE {}
impl ::core::default::Default for HITRANGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAccessor(::windows::core::IUnknown);
impl IAccessor {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRefAccessor(&self, haccessor: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).AddRefAccessor)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateAccessor(&self, dwaccessorflags: u32, cbindings: usize, rgbindings: *const DBBINDING, cbrowsize: usize, phaccessor: *mut usize, rgstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateAccessor)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwaccessorflags), ::core::mem::transmute(cbindings), ::core::mem::transmute(rgbindings), ::core::mem::transmute(cbrowsize), ::core::mem::transmute(phaccessor), ::core::mem::transmute(rgstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetBindings(&self, haccessor: usize, pdwaccessorflags: *mut u32, pcbindings: *mut usize, prgbindings: *mut *mut DBBINDING) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetBindings)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdwaccessorflags), ::core::mem::transmute(pcbindings), ::core::mem::transmute(prgbindings)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseAccessor(&self, haccessor: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ReleaseAccessor)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAccessor> for ::windows::core::IUnknown {
    fn from(value: IAccessor) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessor> for ::windows::core::IUnknown {
    fn from(value: &IAccessor) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAccessor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAccessor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAccessor {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessor {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessor {}
impl ::core::fmt::Debug for IAccessor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessor").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessor {
    type Vtable = IAccessor_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessor_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub AddRefAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwaccessorflags: u32, cbindings: usize, rgbindings: *const DBBINDING, cbrowsize: usize, phaccessor: *mut usize, rgstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateAccessor: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetBindings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pdwaccessorflags: *mut u32, pcbindings: *mut usize, prgbindings: *mut *mut DBBINDING) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetBindings: usize,
    pub ReleaseAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAlterIndex(::windows::core::IUnknown);
impl IAlterIndex {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterIndex(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AlterIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(pnewindexid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IAlterIndex> for ::windows::core::IUnknown {
    fn from(value: IAlterIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAlterIndex> for ::windows::core::IUnknown {
    fn from(value: &IAlterIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAlterIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAlterIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAlterIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterIndex {}
impl ::core::fmt::Debug for IAlterIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAlterIndex {
    type Vtable = IAlterIndex_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa6_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterIndex_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAlterTable(::windows::core::IUnknown);
impl IAlterTable {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterColumn(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut DBCOLUMNDESC) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AlterColumn)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid), ::core::mem::transmute(dwcolumndescflags), ::core::mem::transmute(pcolumndesc)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterTable(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AlterTable)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pnewtableid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IAlterTable> for ::windows::core::IUnknown {
    fn from(value: IAlterTable) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAlterTable> for ::windows::core::IUnknown {
    fn from(value: &IAlterTable) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAlterTable {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAlterTable {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAlterTable {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterTable {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterTable {}
impl ::core::fmt::Debug for IAlterTable {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterTable").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAlterTable {
    type Vtable = IAlterTable_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterTable_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut DBCOLUMNDESC) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterColumn: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterTable: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IBindResource(::windows::core::IUnknown);
impl IBindResource {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Bind<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Bind)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppunk)).ok()
    }
}
impl ::core::convert::From<IBindResource> for ::windows::core::IUnknown {
    fn from(value: IBindResource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBindResource> for ::windows::core::IUnknown {
    fn from(value: &IBindResource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBindResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IBindResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBindResource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBindResource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBindResource {}
impl ::core::fmt::Debug for IBindResource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBindResource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBindResource {
    type Vtable = IBindResource_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab1_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBindResource_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Bind: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: ::windows::core::RawPtr, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Bind: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IChapteredRowset(::windows::core::IUnknown);
impl IChapteredRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRefChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).AddRefChapter)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ReleaseChapter)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IChapteredRowset> for ::windows::core::IUnknown {
    fn from(value: IChapteredRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IChapteredRowset> for ::windows::core::IUnknown {
    fn from(value: &IChapteredRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IChapteredRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IChapteredRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IChapteredRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IChapteredRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IChapteredRowset {}
impl ::core::fmt::Debug for IChapteredRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IChapteredRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IChapteredRowset {
    type Vtable = IChapteredRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a93_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IChapteredRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub AddRefChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    pub ReleaseChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnMapper(::windows::core::IUnknown);
impl IColumnMapper {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetPropInfoFromName<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, wcspropname: Param0, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPropInfoFromName)(::core::mem::transmute_copy(self), wcspropname.into_param().abi(), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetPropInfoFromId(&self, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPropInfoFromId)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppropid), ::core::mem::transmute(pwcsname), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn EnumPropInfo(&self, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumPropInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ientry), ::core::mem::transmute(pwcsname), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn IsMapUpToDate(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsMapUpToDate)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IColumnMapper> for ::windows::core::IUnknown {
    fn from(value: IColumnMapper) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnMapper> for ::windows::core::IUnknown {
    fn from(value: &IColumnMapper) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnMapper {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IColumnMapper {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnMapper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapper {}
impl ::core::fmt::Debug for IColumnMapper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapper").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnMapper {
    type Vtable = IColumnMapper_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37a_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapper_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetPropInfoFromName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcspropname: ::windows::core::PCWSTR, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetPropInfoFromName: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetPropInfoFromId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetPropInfoFromId: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub EnumPropInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    EnumPropInfo: usize,
    pub IsMapUpToDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnMapperCreator(::windows::core::IUnknown);
impl IColumnMapperCreator {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetColumnMapper<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, wcsmachinename: Param0, wcscatalogname: Param1) -> ::windows::core::Result<IColumnMapper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetColumnMapper)(::core::mem::transmute_copy(self), wcsmachinename.into_param().abi(), wcscatalogname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IColumnMapper>(result__)
    }
}
impl ::core::convert::From<IColumnMapperCreator> for ::windows::core::IUnknown {
    fn from(value: IColumnMapperCreator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnMapperCreator> for ::windows::core::IUnknown {
    fn from(value: &IColumnMapperCreator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnMapperCreator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IColumnMapperCreator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnMapperCreator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapperCreator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapperCreator {}
impl ::core::fmt::Debug for IColumnMapperCreator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapperCreator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnMapperCreator {
    type Vtable = IColumnMapperCreator_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37b_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapperCreator_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetColumnMapper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcsmachinename: ::windows::core::PCWSTR, wcscatalogname: ::windows::core::PCWSTR, ppcolumnmapper: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsInfo(::windows::core::IUnknown);
impl IColumnsInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumnInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MapColumnIDs)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumnids), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgcolumns)).ok()
    }
}
impl ::core::convert::From<IColumnsInfo> for ::windows::core::IUnknown {
    fn from(value: IColumnsInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo> for ::windows::core::IUnknown {
    fn from(value: &IColumnsInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IColumnsInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo {}
impl ::core::fmt::Debug for IColumnsInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsInfo {
    type Vtable = IColumnsInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a11_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    GetColumnInfo: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub MapColumnIDs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    MapColumnIDs: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsInfo2(::windows::core::IUnknown);
impl IColumnsInfo2 {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetColumnInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.MapColumnIDs)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumnids), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgcolumns)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetRestrictedColumnInfo(&self, rgcolumnidmasks: &[super::super::Storage::IndexServer::DBID], dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRestrictedColumnInfo)(::core::mem::transmute_copy(self), rgcolumnidmasks.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgcolumnidmasks)), ::core::mem::transmute(dwflags), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumnids), ::core::mem::transmute(prgcolumninfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
}
impl ::core::convert::From<IColumnsInfo2> for ::windows::core::IUnknown {
    fn from(value: IColumnsInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo2> for ::windows::core::IUnknown {
    fn from(value: &IColumnsInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IColumnsInfo2> for IColumnsInfo {
    fn from(value: IColumnsInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo2> for IColumnsInfo {
    fn from(value: &IColumnsInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IColumnsInfo> for IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, IColumnsInfo> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IColumnsInfo> for &'a IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, IColumnsInfo> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsInfo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo2 {}
impl ::core::fmt::Debug for IColumnsInfo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsInfo2 {
    type Vtable = IColumnsInfo2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfo2_Vtbl {
    pub base__: IColumnsInfo_Vtbl,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub GetRestrictedColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnidmasks: usize, rgcolumnidmasks: *const super::super::Storage::IndexServer::DBID, dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    GetRestrictedColumnInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsRowset(::windows::core::IUnknown);
impl IColumnsRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetAvailableColumns(&self, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAvailableColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcoptcolumns), ::core::mem::transmute(prgoptcolumns)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetColumnsRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, rgoptcolumns: &[super::super::Storage::IndexServer::DBID], riid: *const ::windows::core::GUID, rgpropertysets: &mut [DBPROPSET], ppcolrowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumnsRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), rgoptcolumns.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgoptcolumns)), ::core::mem::transmute(riid), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), ::core::mem::transmute(ppcolrowset)).ok()
    }
}
impl ::core::convert::From<IColumnsRowset> for ::windows::core::IUnknown {
    fn from(value: IColumnsRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsRowset> for ::windows::core::IUnknown {
    fn from(value: &IColumnsRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IColumnsRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsRowset {}
impl ::core::fmt::Debug for IColumnsRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsRowset {
    type Vtable = IColumnsRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a10_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetAvailableColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetAvailableColumns: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetColumnsRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, coptcolumns: usize, rgoptcolumns: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppcolrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetColumnsRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommand(::windows::core::IUnknown);
impl ICommand {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Cancel)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Execute)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetDBSession)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<ICommand> for ::windows::core::IUnknown {
    fn from(value: ICommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommand> for ::windows::core::IUnknown {
    fn from(value: &ICommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommand {}
impl ::core::fmt::Debug for ICommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommand {
    type Vtable = ICommand_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a63_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommand_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Cancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetDBSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandCost(::windows::core::IUnknown);
impl ICommandCost {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetAccumulatedCost<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAccumulatedCost)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCostEstimate<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCostEstimate)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostestimates), ::core::mem::transmute(prgcostestimates)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCostGoals<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCostGoals)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostgoals), ::core::mem::transmute(prgcostgoals)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCostLimits<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCostLimits)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetCostGoals<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCostGoals)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(ccostgoals), ::core::mem::transmute(rgcostgoals)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetCostLimits<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszrowsetname: Param0, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCostLimits)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(ccostlimits), ::core::mem::transmute(prgcostlimits), ::core::mem::transmute(dwexecutionflags)).ok()
    }
}
impl ::core::convert::From<ICommandCost> for ::windows::core::IUnknown {
    fn from(value: ICommandCost) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandCost> for ::windows::core::IUnknown {
    fn from(value: &ICommandCost) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandCost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandCost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandCost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandCost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandCost {}
impl ::core::fmt::Debug for ICommandCost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandCost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandCost {
    type Vtable = ICommandCost_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandCost_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetAccumulatedCost: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostEstimate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostGoals: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::HRESULT,
    pub SetCostGoals: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::HRESULT,
    pub SetCostLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandPersist(::windows::core::IUnknown);
impl ICommandPersist {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DeleteCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteCommand)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetCurrentCommand(&self, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCurrentCommand)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppcommandid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn LoadCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LoadCommand)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SaveCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveCommand)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid), ::core::mem::transmute(dwflags)).ok()
    }
}
impl ::core::convert::From<ICommandPersist> for ::windows::core::IUnknown {
    fn from(value: ICommandPersist) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandPersist> for ::windows::core::IUnknown {
    fn from(value: &ICommandPersist) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandPersist {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandPersist {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandPersist {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPersist {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPersist {}
impl ::core::fmt::Debug for ICommandPersist {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPersist").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandPersist {
    type Vtable = ICommandPersist_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa7_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPersist_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DeleteCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DeleteCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetCurrentCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetCurrentCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub LoadCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    LoadCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SaveCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SaveCommand: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandPrepare(::windows::core::IUnknown);
impl ICommandPrepare {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Prepare(&self, cexpectedruns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Prepare)(::core::mem::transmute_copy(self), ::core::mem::transmute(cexpectedruns)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Unprepare(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Unprepare)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICommandPrepare> for ::windows::core::IUnknown {
    fn from(value: ICommandPrepare) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandPrepare> for ::windows::core::IUnknown {
    fn from(value: &ICommandPrepare) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandPrepare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandPrepare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandPrepare {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPrepare {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPrepare {}
impl ::core::fmt::Debug for ICommandPrepare {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPrepare").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandPrepare {
    type Vtable = ICommandPrepare_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a26_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPrepare_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Prepare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cexpectedruns: u32) -> ::windows::core::HRESULT,
    pub Unprepare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandProperties(::windows::core::IUnknown);
impl ICommandProperties {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetProperties)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: &[DBPROPSET]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProperties)(::core::mem::transmute_copy(self), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertysets))).ok()
    }
}
impl ::core::convert::From<ICommandProperties> for ::windows::core::IUnknown {
    fn from(value: ICommandProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandProperties> for ::windows::core::IUnknown {
    fn from(value: &ICommandProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandProperties {}
impl ::core::fmt::Debug for ICommandProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandProperties {
    type Vtable = ICommandProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a79_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandProperties_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *const DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandStream(::windows::core::IUnknown);
impl ICommandStream {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCommandStream(&self, piid: *mut ::windows::core::GUID, pguiddialect: *mut ::windows::core::GUID, ppcommandstream: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommandStream)(::core::mem::transmute_copy(self), ::core::mem::transmute(piid), ::core::mem::transmute(pguiddialect), ::core::mem::transmute(ppcommandstream)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetCommandStream<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCommandStream)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rguiddialect), pcommandstream.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ICommandStream> for ::windows::core::IUnknown {
    fn from(value: ICommandStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandStream> for ::windows::core::IUnknown {
    fn from(value: &ICommandStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandStream {}
impl ::core::fmt::Debug for ICommandStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandStream {
    type Vtable = ICommandStream_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandStream_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetCommandStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piid: *mut ::windows::core::GUID, pguiddialect: *mut ::windows::core::GUID, ppcommandstream: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetCommandStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandText(::windows::core::IUnknown);
impl ICommandText {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Cancel)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Execute)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDBSession)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCommandText(&self, pguiddialect: *mut ::windows::core::GUID, ppwszcommand: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommandText)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguiddialect), ::core::mem::transmute(ppwszcommand)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetCommandText<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, rguiddialect: *const ::windows::core::GUID, pwszcommand: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCommandText)(::core::mem::transmute_copy(self), ::core::mem::transmute(rguiddialect), pwszcommand.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ICommandText> for ::windows::core::IUnknown {
    fn from(value: ICommandText) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandText> for ::windows::core::IUnknown {
    fn from(value: &ICommandText) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICommandText> for ICommand {
    fn from(value: ICommandText) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandText> for ICommand {
    fn from(value: &ICommandText) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommand> for ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ICommand> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommand> for &'a ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ICommand> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandText {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandText {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandText {}
impl ::core::fmt::Debug for ICommandText {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandText").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandText {
    type Vtable = ICommandText_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a27_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandText_Vtbl {
    pub base__: ICommand_Vtbl,
    pub GetCommandText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguiddialect: *mut ::windows::core::GUID, ppwszcommand: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetCommandText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguiddialect: *const ::windows::core::GUID, pwszcommand: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandValidate(::windows::core::IUnknown);
impl ICommandValidate {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ValidateCompletely(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ValidateCompletely)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ValidateSyntax(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ValidateSyntax)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICommandValidate> for ::windows::core::IUnknown {
    fn from(value: ICommandValidate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandValidate> for ::windows::core::IUnknown {
    fn from(value: &ICommandValidate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandValidate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandValidate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandValidate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandValidate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandValidate {}
impl ::core::fmt::Debug for ICommandValidate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandValidate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandValidate {
    type Vtable = ICommandValidate_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a18_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandValidate_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ValidateCompletely: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ValidateSyntax: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandWithParameters(::windows::core::IUnknown);
impl ICommandWithParameters {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetParameterInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo), ::core::mem::transmute(ppnamesbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn MapParameterNames(&self, cparamnames: usize, rgparamnames: *const ::windows::core::PWSTR, rgparamordinals: *mut isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MapParameterNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(cparamnames), ::core::mem::transmute(rgparamnames), ::core::mem::transmute(rgparamordinals)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetParameterInfo(&self, cparams: usize, rgparamordinals: *const usize, rgparambindinfo: *const DBPARAMBINDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetParameterInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(cparams), ::core::mem::transmute(rgparamordinals), ::core::mem::transmute(rgparambindinfo)).ok()
    }
}
impl ::core::convert::From<ICommandWithParameters> for ::windows::core::IUnknown {
    fn from(value: ICommandWithParameters) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandWithParameters> for ::windows::core::IUnknown {
    fn from(value: &ICommandWithParameters) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICommandWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandWithParameters {}
impl ::core::fmt::Debug for ICommandWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandWithParameters {
    type Vtable = ICommandWithParameters_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a64_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandWithParameters_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetParameterInfo: usize,
    pub MapParameterNames: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparamnames: usize, rgparamnames: *const ::windows::core::PWSTR, rgparamordinals: *mut isize) -> ::windows::core::HRESULT,
    pub SetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparams: usize, rgparamordinals: *const usize, rgparambindinfo: *const DBPARAMBINDINFO) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICondition(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICondition {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetClassID)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::HRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base__.IsDirty)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Load)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, fcleardirty: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Save)(::core::mem::transmute_copy(self), pstm.into_param().abi(), fcleardirty.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__: u64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetSizeMax)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__: Common::CONDITION_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetConditionType)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSubConditions<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetSubConditions)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: *mut ::windows::core::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetComparisonInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetValueType)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetValueNormalization)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetInputTerms(&self, pppropertyterm: *mut ::core::option::Option<IRichChunk>, ppoperationterm: *mut ::core::option::Option<IRichChunk>, ppvalueterm: *mut ::core::option::Option<IRichChunk>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetInputTerms)(::core::mem::transmute_copy(self), ::core::mem::transmute(pppropertyterm), ::core::mem::transmute(ppoperationterm), ::core::mem::transmute(ppvalueterm)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition> for ::windows::core::IUnknown {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition> for ::windows::core::IUnknown {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition> for super::Com::IPersist {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition> for super::Com::IPersist {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for &'a ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition> for super::Com::IPersistStream {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition> for super::Com::IPersistStream {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for &'a ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICondition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICondition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICondition {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICondition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICondition {
    type Vtable = ICondition_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0fc988d4_c935_4b97_a973_46282ea175c8);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICondition_Vtbl {
    pub base__: super::Com::IPersistStream_Vtbl,
    #[cfg(feature = "Win32_System_Search_Common")]
    pub GetConditionType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnodetype: *mut Common::CONDITION_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Search_Common"))]
    GetConditionType: usize,
    pub GetSubConditions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub GetComparisonInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpropertyname: *mut ::windows::core::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))]
    GetComparisonInfo: usize,
    pub GetValueType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvaluetypename: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetValueNormalization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsznormalization: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetInputTerms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppropertyterm: *mut ::windows::core::RawPtr, ppoperationterm: *mut ::windows::core::RawPtr, ppvalueterm: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Clone: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICondition2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICondition2 {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetClassID)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::HRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base__.base__.IsDirty)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.Load)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, fcleardirty: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.Save)(::core::mem::transmute_copy(self), pstm.into_param().abi(), fcleardirty.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__: u64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetSizeMax)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__: Common::CONDITION_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetConditionType)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSubConditions<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).base__.GetSubConditions)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: *mut ::windows::core::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetComparisonInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetValueType)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetValueNormalization)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetInputTerms(&self, pppropertyterm: *mut ::core::option::Option<IRichChunk>, ppoperationterm: *mut ::core::option::Option<IRichChunk>, ppvalueterm: *mut ::core::option::Option<IRichChunk>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetInputTerms)(::core::mem::transmute_copy(self), ::core::mem::transmute(pppropertyterm), ::core::mem::transmute(ppoperationterm), ::core::mem::transmute(ppvalueterm)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetLocale(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetLocale)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetLeafConditionInfo(&self, ppropkey: *mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLeafConditionInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppropkey), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for ::windows::core::IUnknown {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for ::windows::core::IUnknown {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for super::Com::IPersist {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for super::Com::IPersist {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for &'a ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for super::Com::IPersistStream {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for super::Com::IPersistStream {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for &'a ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for ICondition {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for ICondition {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ICondition> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICondition> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ICondition> for &'a ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICondition> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICondition2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICondition2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICondition2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICondition2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICondition2 {
    type Vtable = ICondition2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0db8851d_2e5b_47eb_9208_d28c325a01d7);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICondition2_Vtbl {
    pub base__: ICondition_Vtbl,
    pub GetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszlocalename: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetLeafConditionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropkey: *mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetLeafConditionInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionFactory(::windows::core::IUnknown);
impl IConditionFactory {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MakeNot)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MakeAndOr)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MakeLeaf)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Resolve)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
}
impl ::core::convert::From<IConditionFactory> for ::windows::core::IUnknown {
    fn from(value: IConditionFactory) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory> for ::windows::core::IUnknown {
    fn from(value: &IConditionFactory) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionFactory {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IConditionFactory {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory {}
impl ::core::fmt::Debug for IConditionFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionFactory {
    type Vtable = IConditionFactory_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa5efe073_b16f_474f_9f3e_9f8b497a3e08);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactory_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub MakeNot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    MakeNot: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub MakeAndOr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, peusubs: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    MakeAndOr: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub MakeLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: ::windows::core::PCWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: ::windows::core::PCWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, fexpand: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))]
    MakeLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub Resolve: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, ppcresolved: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    Resolve: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionFactory2(::windows::core::IUnknown);
impl IConditionFactory2 {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeNot)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeAndOr)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeLeaf)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.Resolve)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateTrueFalse<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, T: ::windows::core::Interface>(&self, fval: Param0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateTrueFalse)(::core::mem::transmute_copy(self), fval.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateNegation<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, T: ::windows::core::Interface>(&self, pcsub: Param0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateNegation)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn CreateCompoundFromObjectArray<'a, Param1: ::windows::core::IntoParam<'a, super::super::UI::Shell::Common::IObjectArray>, T: ::windows::core::Interface>(&self, ct: Common::CONDITION_TYPE, poasubs: Param1, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateCompoundFromObjectArray)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), poasubs.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn CreateCompoundFromArray<T: ::windows::core::Interface>(&self, ct: Common::CONDITION_TYPE, ppcondsubs: &[::core::option::Option<ICondition>], cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateCompoundFromArray)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), ::core::mem::transmute(::windows::core::as_ptr_or_null(ppcondsubs)), ppcondsubs.len() as _, ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateStringLeaf<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: Param2, pszlocalename: Param3, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateStringLeaf)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), pszvalue.into_param().abi(), pszlocalename.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateIntegerLeaf<T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateIntegerLeaf)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), ::core::mem::transmute(lvalue), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateBooleanLeaf<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: Param2, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateBooleanLeaf)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), fvalue.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateLeaf<'a, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, IRichChunk>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const super::Com::StructuredStorage::PROPVARIANT, pszsemantictype: Param3, pszlocalename: Param4, ppropertynameterm: Param5, poperationterm: Param6, pvalueterm: Param7, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateLeaf)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), ::core::mem::transmute(propvar), pszsemantictype.into_param().abi(), pszlocalename.into_param().abi(), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ResolveCondition<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, T: ::windows::core::Interface>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).ResolveCondition)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<IConditionFactory2> for ::windows::core::IUnknown {
    fn from(value: IConditionFactory2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory2> for ::windows::core::IUnknown {
    fn from(value: &IConditionFactory2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IConditionFactory2> for IConditionFactory {
    fn from(value: IConditionFactory2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory2> for IConditionFactory {
    fn from(value: &IConditionFactory2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for &'a IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionFactory2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory2 {}
impl ::core::fmt::Debug for IConditionFactory2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionFactory2 {
    type Vtable = IConditionFactory2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71d222e1_432f_429e_8c13_b6dafde5077a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactory2_Vtbl {
    pub base__: IConditionFactory_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateTrueFalse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fval: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateTrueFalse: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateNegation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateNegation: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))]
    pub CreateCompoundFromObjectArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, poasubs: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common")))]
    CreateCompoundFromObjectArray: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub CreateCompoundFromArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, ppcondsubs: *const ::windows::core::RawPtr, csubs: u32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    CreateCompoundFromArray: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateStringLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: ::windows::core::PCWSTR, pszlocalename: ::windows::core::PCWSTR, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateStringLeaf: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateIntegerLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateIntegerLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateBooleanLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateBooleanLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const super::Com::StructuredStorage::PROPVARIANT, pszsemantictype: ::windows::core::PCWSTR, pszlocalename: ::windows::core::PCWSTR, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub ResolveCondition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    ResolveCondition: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionGenerator(::windows::core::IUnknown);
impl IConditionGenerator {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::core::IntoParam<'a, ISchemaProvider>>(&self, pschemaprovider: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::core::mem::transmute_copy(self), pschemaprovider.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RecognizeNamedEntities<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ITokenCollection>, Param3: ::windows::core::IntoParam<'a, INamedEntityCollector>>(&self, pszinputstring: Param0, lciduserlocale: u32, ptokencollection: Param2, pnamedentities: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RecognizeNamedEntities)(::core::mem::transmute_copy(self), pszinputstring.into_param().abi(), ::core::mem::transmute(lciduserlocale), ptokencollection.into_param().abi(), pnamedentities.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GenerateForLeaf<'a, Param0: ::windows::core::IntoParam<'a, IConditionFactory>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, IRichChunk>, Param8: ::windows::core::IntoParam<'a, IRichChunk>, Param9: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(
        &self,
        pconditionfactory: Param0,
        pszpropertyname: Param1,
        cop: Common::CONDITION_OPERATION,
        pszvaluetype: Param3,
        pszvalue: Param4,
        pszvalue2: Param5,
        ppropertynameterm: Param6,
        poperationterm: Param7,
        pvalueterm: Param8,
        automaticwildcard: Param9,
        pnostringquery: *mut super::super::Foundation::BOOL,
        ppqueryexpression: *mut ::core::option::Option<ICondition>,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GenerateForLeaf)(::core::mem::transmute_copy(self), pconditionfactory.into_param().abi(), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), pszvalue.into_param().abi(), pszvalue2.into_param().abi(), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), automaticwildcard.into_param().abi(), ::core::mem::transmute(pnostringquery), ::core::mem::transmute(ppqueryexpression)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn DefaultPhrase<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszvaluetype: Param0, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, fuseenglish: Param2) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DefaultPhrase)(::core::mem::transmute_copy(self), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), fuseenglish.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<IConditionGenerator> for ::windows::core::IUnknown {
    fn from(value: IConditionGenerator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionGenerator> for ::windows::core::IUnknown {
    fn from(value: &IConditionGenerator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IConditionGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionGenerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionGenerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionGenerator {}
impl ::core::fmt::Debug for IConditionGenerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionGenerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionGenerator {
    type Vtable = IConditionGenerator_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92d2cc58_4386_45a3_b98c_7e0ce64a4117);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionGenerator_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pschemaprovider: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub RecognizeNamedEntities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: ::windows::core::PCWSTR, lciduserlocale: u32, ptokencollection: ::windows::core::RawPtr, pnamedentities: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub GenerateForLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pconditionfactory: ::windows::core::RawPtr, pszpropertyname: ::windows::core::PCWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, pszvalue2: ::windows::core::PCWSTR, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, automaticwildcard: super::super::Foundation::BOOL, pnostringquery: *mut super::super::Foundation::BOOL, ppqueryexpression: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    GenerateForLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvaluetype: ::windows::core::PCWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, fuseenglish: super::super::Foundation::BOOL, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    DefaultPhrase: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConvertType(::windows::core::IUnknown);
impl IConvertType {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CanConvert(&self, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanConvert)(::core::mem::transmute_copy(self), ::core::mem::transmute(wfromtype), ::core::mem::transmute(wtotype), ::core::mem::transmute(dwconvertflags)).ok()
    }
}
impl ::core::convert::From<IConvertType> for ::windows::core::IUnknown {
    fn from(value: IConvertType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConvertType> for ::windows::core::IUnknown {
    fn from(value: &IConvertType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConvertType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IConvertType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConvertType {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConvertType {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConvertType {}
impl ::core::fmt::Debug for IConvertType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConvertType").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConvertType {
    type Vtable = IConvertType_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a88_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConvertType_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CanConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICreateRow(::windows::core::IUnknown);
impl ICreateRow {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateRow<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppwsznewurl: *mut ::windows::core::PWSTR, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateRow)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppwsznewurl), ::core::mem::transmute(ppunk)).ok()
    }
}
impl ::core::convert::From<ICreateRow> for ::windows::core::IUnknown {
    fn from(value: ICreateRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICreateRow> for ::windows::core::IUnknown {
    fn from(value: &ICreateRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICreateRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICreateRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICreateRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreateRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateRow {}
impl ::core::fmt::Debug for ICreateRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICreateRow {
    type Vtable = ICreateRow_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateRow_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: ::windows::core::RawPtr, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppwsznewurl: *mut ::windows::core::PWSTR, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateRow: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBAsynchNotify(::windows::core::IUnknown);
impl IDBAsynchNotify {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn OnLowResource(&self, dwreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnLowResource)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwreserved)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn OnProgress<'a, Param5: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: Param5) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnProgress)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(ulprogress), ::core::mem::transmute(ulprogressmax), ::core::mem::transmute(easynchphase), pwszstatustext.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn OnStop<'a, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnStop)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(hrstatus), pwszstatustext.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IDBAsynchNotify> for ::windows::core::IUnknown {
    fn from(value: IDBAsynchNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBAsynchNotify> for ::windows::core::IUnknown {
    fn from(value: &IDBAsynchNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBAsynchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBAsynchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBAsynchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchNotify {}
impl ::core::fmt::Debug for IDBAsynchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBAsynchNotify {
    type Vtable = IDBAsynchNotify_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a96_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchNotify_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub OnLowResource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwreserved: usize) -> ::windows::core::HRESULT,
    pub OnProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OnStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBAsynchStatus(::windows::core::IUnknown);
impl IDBAsynchStatus {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Abort(&self, hchapter: usize, eoperation: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Abort)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetStatus(&self, hchapter: usize, eoperation: u32, pulprogress: *mut usize, pulprogressmax: *mut usize, peasynchphase: *mut u32, ppwszstatustext: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(pulprogress), ::core::mem::transmute(pulprogressmax), ::core::mem::transmute(peasynchphase), ::core::mem::transmute(ppwszstatustext)).ok()
    }
}
impl ::core::convert::From<IDBAsynchStatus> for ::windows::core::IUnknown {
    fn from(value: IDBAsynchStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBAsynchStatus> for ::windows::core::IUnknown {
    fn from(value: &IDBAsynchStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBAsynchStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBAsynchStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBAsynchStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchStatus {}
impl ::core::fmt::Debug for IDBAsynchStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBAsynchStatus {
    type Vtable = IDBAsynchStatus_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a95_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchStatus_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Abort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32) -> ::windows::core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, pulprogress: *mut usize, pulprogressmax: *mut usize, peasynchphase: *mut u32, ppwszstatustext: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBBinderProperties(::windows::core::IUnknown);
impl IDBBinderProperties {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetProperties)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetPropertyInfo)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: &mut [DBPROPSET]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProperties)(::core::mem::transmute_copy(self), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IDBBinderProperties> for ::windows::core::IUnknown {
    fn from(value: IDBBinderProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBBinderProperties> for ::windows::core::IUnknown {
    fn from(value: &IDBBinderProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IDBBinderProperties> for IDBProperties {
    fn from(value: IDBBinderProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBBinderProperties> for IDBProperties {
    fn from(value: &IDBBinderProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDBProperties> for IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, IDBProperties> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDBProperties> for &'a IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, IDBProperties> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBBinderProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBBinderProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBBinderProperties {}
impl ::core::fmt::Debug for IDBBinderProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBBinderProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBBinderProperties {
    type Vtable = IDBBinderProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBBinderProperties_Vtbl {
    pub base__: IDBProperties_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBCreateCommand(::windows::core::IUnknown);
impl IDBCreateCommand {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateCommand<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateCommand)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IDBCreateCommand> for ::windows::core::IUnknown {
    fn from(value: IDBCreateCommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBCreateCommand> for ::windows::core::IUnknown {
    fn from(value: &IDBCreateCommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBCreateCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBCreateCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBCreateCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateCommand {}
impl ::core::fmt::Debug for IDBCreateCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBCreateCommand {
    type Vtable = IDBCreateCommand_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a1d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateCommand_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CreateCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppcommand: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBCreateSession(::windows::core::IUnknown);
impl IDBCreateSession {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateSession<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateSession)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IDBCreateSession> for ::windows::core::IUnknown {
    fn from(value: IDBCreateSession) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBCreateSession> for ::windows::core::IUnknown {
    fn from(value: &IDBCreateSession) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBCreateSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBCreateSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBCreateSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateSession {}
impl ::core::fmt::Debug for IDBCreateSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBCreateSession {
    type Vtable = IDBCreateSession_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a5d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateSession_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CreateSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBDataSourceAdmin(::windows::core::IUnknown);
impl IDBDataSourceAdmin {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateDataSource<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, rgpropertysets: &mut [DBPROPSET], punkouter: Param2, riid: *const ::windows::core::GUID, ppdbsession: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateDataSource)(::core::mem::transmute_copy(self), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdbsession)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DestroyDataSource(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DestroyDataSource)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCreationProperties(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCreationProperties)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ModifyDataSource(&self, rgpropertysets: &mut [DBPROPSET]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ModifyDataSource)(::core::mem::transmute_copy(self), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets))).ok()
    }
}
impl ::core::convert::From<IDBDataSourceAdmin> for ::windows::core::IUnknown {
    fn from(value: IDBDataSourceAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBDataSourceAdmin> for ::windows::core::IUnknown {
    fn from(value: &IDBDataSourceAdmin) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBDataSourceAdmin {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBDataSourceAdmin {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBDataSourceAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBDataSourceAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBDataSourceAdmin {}
impl ::core::fmt::Debug for IDBDataSourceAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBDataSourceAdmin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBDataSourceAdmin {
    type Vtable = IDBDataSourceAdmin_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBDataSourceAdmin_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateDataSource: usize,
    pub DestroyDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCreationProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCreationProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ModifyDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ModifyDataSource: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBInfo(::windows::core::IUnknown);
impl IDBInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetKeywords(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetKeywords)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLiteralInfo(&self, rgliterals: &[u32], pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLiteralInfo)(::core::mem::transmute_copy(self), rgliterals.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgliterals)), ::core::mem::transmute(pcliteralinfo), ::core::mem::transmute(prgliteralinfo), ::core::mem::transmute(ppcharbuffer)).ok()
    }
}
impl ::core::convert::From<IDBInfo> for ::windows::core::IUnknown {
    fn from(value: IDBInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBInfo> for ::windows::core::IUnknown {
    fn from(value: &IDBInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInfo {}
impl ::core::fmt::Debug for IDBInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBInfo {
    type Vtable = IDBInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a89_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetKeywords: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppwszkeywords: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetLiteralInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cliterals: u32, rgliterals: *const u32, pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetLiteralInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBInitialize(::windows::core::IUnknown);
impl IDBInitialize {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Initialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Uninitialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Uninitialize)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IDBInitialize> for ::windows::core::IUnknown {
    fn from(value: IDBInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDBInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInitialize {}
impl ::core::fmt::Debug for IDBInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBInitialize {
    type Vtable = IDBInitialize_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInitialize_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Uninitialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBPromptInitialize(::windows::core::IUnknown);
impl IDBPromptInitialize {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptDataSource<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param5: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, punkouter: Param0, hwndparent: Param1, dwpromptoptions: u32, rgsourcetypefilter: &[u32], pwszszzproviderfilter: Param5, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PromptDataSource)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), hwndparent.into_param().abi(), ::core::mem::transmute(dwpromptoptions), rgsourcetypefilter.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgsourcetypefilter)), pwszszzproviderfilter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptFileName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, hwndparent: Param0, dwpromptoptions: u32, pwszinitialdirectory: Param2, pwszinitialfile: Param3) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PromptFileName)(::core::mem::transmute_copy(self), hwndparent.into_param().abi(), ::core::mem::transmute(dwpromptoptions), pwszinitialdirectory.into_param().abi(), pwszinitialfile.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<IDBPromptInitialize> for ::windows::core::IUnknown {
    fn from(value: IDBPromptInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBPromptInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDBPromptInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBPromptInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBPromptInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBPromptInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBPromptInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBPromptInitialize {}
impl ::core::fmt::Debug for IDBPromptInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBPromptInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBPromptInitialize {
    type Vtable = IDBPromptInitialize_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb0_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBPromptInitialize_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub PromptDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, csourcetypefilter: u32, rgsourcetypefilter: *const u32, pwszszzproviderfilter: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PromptDataSource: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub PromptFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, pwszinitialdirectory: ::windows::core::PCWSTR, pwszinitialfile: ::windows::core::PCWSTR, ppwszselectedfile: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PromptFileName: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBProperties(::windows::core::IUnknown);
impl IDBProperties {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetProperties)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPropertyInfo)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: &mut [DBPROPSET]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProperties)(::core::mem::transmute_copy(self), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets))).ok()
    }
}
impl ::core::convert::From<IDBProperties> for ::windows::core::IUnknown {
    fn from(value: IDBProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBProperties> for ::windows::core::IUnknown {
    fn from(value: &IDBProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBProperties {}
impl ::core::fmt::Debug for IDBProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBProperties {
    type Vtable = IDBProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBProperties_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetPropertyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetPropertyInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBSchemaCommand(::windows::core::IUnknown);
impl IDBSchemaCommand {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCommand<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, rguidschema: *const ::windows::core::GUID) -> ::windows::core::Result<ICommand> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCommand)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(rguidschema), ::core::mem::transmute(&mut result__)).from_abi::<ICommand>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSchemas)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas)).ok()
    }
}
impl ::core::convert::From<IDBSchemaCommand> for ::windows::core::IUnknown {
    fn from(value: IDBSchemaCommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBSchemaCommand> for ::windows::core::IUnknown {
    fn from(value: &IDBSchemaCommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBSchemaCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBSchemaCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBSchemaCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaCommand {}
impl ::core::fmt::Debug for IDBSchemaCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBSchemaCommand {
    type Vtable = IDBSchemaCommand_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a50_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaCommand_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, ppcommand: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub GetSchemas: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBSchemaRowset(::windows::core::IUnknown);
impl IDBSchemaRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, rguidschema: *const ::windows::core::GUID, rgrestrictions: &[super::Com::VARIANT], riid: *const ::windows::core::GUID, rgpropertysets: &mut [DBPROPSET], pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(rguidschema), rgrestrictions.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgrestrictions)), ::core::mem::transmute(riid), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID, prgrestrictionsupport: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSchemas)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas), ::core::mem::transmute(prgrestrictionsupport)).ok()
    }
}
impl ::core::convert::From<IDBSchemaRowset> for ::windows::core::IUnknown {
    fn from(value: IDBSchemaRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBSchemaRowset> for ::windows::core::IUnknown {
    fn from(value: &IDBSchemaRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBSchemaRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDBSchemaRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBSchemaRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaRowset {}
impl ::core::fmt::Debug for IDBSchemaRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBSchemaRowset {
    type Vtable = IDBSchemaRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, crestrictions: u32, rgrestrictions: *const super::Com::VARIANT, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRowset: usize,
    pub GetSchemas: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID, prgrestrictionsupport: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDCInfo(::windows::core::IUnknown);
impl IDCInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetInfo(&self, cinfo: u32, rgeinfotype: *const u32, prginfo: *mut *mut DCINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(cinfo), ::core::mem::transmute(rgeinfotype), ::core::mem::transmute(prginfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetInfo(&self, rginfo: &[DCINFO]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetInfo)(::core::mem::transmute_copy(self), rginfo.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rginfo))).ok()
    }
}
impl ::core::convert::From<IDCInfo> for ::windows::core::IUnknown {
    fn from(value: IDCInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDCInfo> for ::windows::core::IUnknown {
    fn from(value: &IDCInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDCInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDCInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDCInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDCInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDCInfo {}
impl ::core::fmt::Debug for IDCInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDCInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDCInfo {
    type Vtable = IDCInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDCInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rgeinfotype: *const u32, prginfo: *mut *mut DCINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rginfo: *const DCINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDENTIFIER_SDK_ERROR: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDENTIFIER_SDK_MASK: u32 = 4026531840u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_BUILTIN_PROPERTY: ::windows::core::HRESULT = ::windows::core::HRESULT(264511i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_BUILTIN_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264503i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_CANNOT_CAST: ::windows::core::HRESULT = ::windows::core::HRESULT(264518i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_CANNOT_CONVERT: ::windows::core::HRESULT = ::windows::core::HRESULT(264507i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_COLUMN_NOT_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264502i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_DATE_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264519i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_DEFAULT_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(264495i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_ILLEGAL_PASSTHROUGH: ::windows::core::HRESULT = ::windows::core::HRESULT(264496i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_INVALIDSELECT_COALESCE: ::windows::core::HRESULT = ::windows::core::HRESULT(264517i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_INVALID_CATALOG: ::windows::core::HRESULT = ::windows::core::HRESULT(264516i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_INVALID_IN_GROUP_CLAUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(264520i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_MATCH_STRING: ::windows::core::HRESULT = ::windows::core::HRESULT(264513i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_NOT_COLUMN_OF_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264510i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_ORDINAL_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264500i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_OR_NOT: ::windows::core::HRESULT = ::windows::core::HRESULT(264506i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_OUT_OF_MEMORY: ::windows::core::HRESULT = ::windows::core::HRESULT(264504i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264508i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_PARSE_ERR_1_PARAM: ::windows::core::HRESULT = ::windows::core::HRESULT(264497i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_PARSE_ERR_2_PARAM: ::windows::core::HRESULT = ::windows::core::HRESULT(264498i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_PROPERTY_NAME_IN_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264514i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_RELATIVE_INTERVAL: ::windows::core::HRESULT = ::windows::core::HRESULT(264509i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_SELECT_STAR: ::windows::core::HRESULT = ::windows::core::HRESULT(264505i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_SEMI_COLON: ::windows::core::HRESULT = ::windows::core::HRESULT(264499i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_VIEW_ALREADY_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264515i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_VIEW_NOT_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264501i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDS_MON_WEIGHT_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264512i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_BUILD_IN_PROGRESS: i32 = -2147217147i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_CATALOG_DISMOUNTED: i32 = -2147217124i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_CORRUPT_INDEX: i32 = -2147217136i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_DISKFULL: i32 = -2147217138i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_DOCUMENT_ABORTED: i32 = -2147217125i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_DSS_NOT_CONNECTED: i32 = -2147217126i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_IDXLSTFILE_CORRUPT: i32 = -2147217146i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_INVALIDTAG: i32 = -2147217151i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_INVALID_INDEX: i32 = -2147217137i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_METAFILE_CORRUPT: i32 = -2147217150i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_NOISELIST_NOTFOUND: i32 = -2147217141i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_NOT_LOADED: i32 = -2147217129i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_OBJECT_NOT_FOUND: i32 = -2147217144i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_PROPSTORE_INIT_FAILED: i32 = -2147217134i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_PROP_MAJOR_VERSION_MISMATCH: i32 = -2147217128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_PROP_MINOR_VERSION_MISMATCH: i32 = -2147217127i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_PROP_STATE_CORRUPT: i32 = -2147217133i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_PROP_STOPPED: i32 = -2147217139i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_REGISTRY_ENTRY: i32 = -2147217145i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_SEARCH_SERVER_ALREADY_EXISTS: i32 = -2147217148i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_SEARCH_SERVER_NOT_FOUND: i32 = -2147217143i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_STEMMER_NOTFOUND: i32 = -2147217140i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_TOO_MANY_SEARCH_SERVERS: i32 = -2147217149i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_USE_APPGLOBAL_PROPTABLE: i32 = -2147217120i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_USE_DEFAULT_CONTENTCLASS: i32 = -2147217121i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_E_WB_NOTFOUND: i32 = -2147217142i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_S_DSS_NOT_AVAILABLE: i32 = 266525i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_S_NO_BUILD_IN_PROGRESS: i32 = 266516i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_S_SEARCH_SERVER_ALREADY_EXISTS: i32 = 266517i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const IDX_S_SEARCH_SERVER_DOES_NOT_EXIST: i32 = 266518i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDataConvert(::windows::core::IUnknown);
impl IDataConvert {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DataConvert(&self, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: *mut u32, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DataConvert)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype), ::core::mem::transmute(cbsrclength), ::core::mem::transmute(pcbdstlength), ::core::mem::transmute(psrc), ::core::mem::transmute(pdst), ::core::mem::transmute(cbdstmaxlength), ::core::mem::transmute(dbssrcstatus), ::core::mem::transmute(pdbsstatus), ::core::mem::transmute(bprecision), ::core::mem::transmute(bscale), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CanConvert(&self, wsrctype: u16, wdsttype: u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanConvert)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetConversionSize(&self, wsrctype: u16, wdsttype: u16, pcbsrclength: *const usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetConversionSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype), ::core::mem::transmute(pcbsrclength), ::core::mem::transmute(pcbdstlength), ::core::mem::transmute(psrc)).ok()
    }
}
impl ::core::convert::From<IDataConvert> for ::windows::core::IUnknown {
    fn from(value: IDataConvert) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataConvert> for ::windows::core::IUnknown {
    fn from(value: &IDataConvert) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataConvert {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataConvert {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDataConvert {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataConvert {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataConvert {}
impl ::core::fmt::Debug for IDataConvert {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataConvert").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataConvert {
    type Vtable = IDataConvert_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataConvert_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub DataConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: *mut u32, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::HRESULT,
    pub CanConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16) -> ::windows::core::HRESULT,
    pub GetConversionSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, pcbsrclength: *const usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDataInitialize(::windows::core::IUnknown);
impl IDataInitialize {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetDataSource<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, punkouter: Param0, dwclsctx: u32, pwszinitializationstring: Param2, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDataSource)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszinitializationstring.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetInitializationString<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, pdatasource: Param0, fincludepassword: u8) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetInitializationString)(::core::mem::transmute_copy(self), pdatasource.into_param().abi(), ::core::mem::transmute(fincludepassword), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateDBInstance<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: Param1, dwclsctx: u32, pwszreserved: Param3, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDBInstance)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprovider), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszreserved.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateDBInstanceEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: Param1, dwclsctx: u32, pwszreserved: Param3, pserverinfo: *const super::Com::COSERVERINFO, rgmqresults: &mut [super::Com::MULTI_QI]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateDBInstanceEx)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprovider), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszreserved.into_param().abi(), ::core::mem::transmute(pserverinfo), rgmqresults.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgmqresults))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn LoadStringFromStorage<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszfilename: Param0) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).LoadStringFromStorage)(::core::mem::transmute_copy(self), pwszfilename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn WriteStringToStorage<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszfilename: Param0, pwszinitializationstring: Param1, dwcreationdisposition: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WriteStringToStorage)(::core::mem::transmute_copy(self), pwszfilename.into_param().abi(), pwszinitializationstring.into_param().abi(), ::core::mem::transmute(dwcreationdisposition)).ok()
    }
}
impl ::core::convert::From<IDataInitialize> for ::windows::core::IUnknown {
    fn from(value: IDataInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDataInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDataInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataInitialize {}
impl ::core::fmt::Debug for IDataInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataInitialize {
    type Vtable = IDataInitialize_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb1_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataInitialize_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszinitializationstring: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInitializationString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdatasource: *mut ::core::ffi::c_void, fincludepassword: u8, ppwszinitstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub CreateDBInstance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateDBInstanceEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: ::windows::core::PCWSTR, pserverinfo: *const super::Com::COSERVERINFO, cmq: u32, rgmqresults: *mut super::Com::MULTI_QI) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateDBInstanceEx: usize,
    pub LoadStringFromStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: ::windows::core::PCWSTR, ppwszinitializationstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub WriteStringToStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: ::windows::core::PCWSTR, pwszinitializationstring: ::windows::core::PCWSTR, dwcreationdisposition: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IDataSourceLocator(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IDataSourceLocator {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn hWnd(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).hWnd)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SethWnd(&self, hwndparent: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SethWnd)(::core::mem::transmute_copy(self), ::core::mem::transmute(hwndparent)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptNew(&self) -> ::windows::core::Result<super::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PromptNew)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptEdit(&self, ppadoconnection: *mut ::core::option::Option<super::Com::IDispatch>, pbsuccess: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PromptEdit)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppadoconnection), ::core::mem::transmute(pbsuccess)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IDataSourceLocator> for ::windows::core::IUnknown {
    fn from(value: IDataSourceLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IDataSourceLocator> for ::windows::core::IUnknown {
    fn from(value: &IDataSourceLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IDataSourceLocator> for super::Com::IDispatch {
    fn from(value: IDataSourceLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IDataSourceLocator> for super::Com::IDispatch {
    fn from(value: &IDataSourceLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for &'a IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IDataSourceLocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IDataSourceLocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IDataSourceLocator {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IDataSourceLocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataSourceLocator").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IDataSourceLocator {
    type Vtable = IDataSourceLocator_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb2_19c1_11d1_89e0_00c04fd7a829);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDataSourceLocator_Vtbl {
    pub base__: super::Com::IDispatch_Vtbl,
    pub hWnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndparent: *mut i64) -> ::windows::core::HRESULT,
    pub SethWnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: i64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub PromptNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PromptNew: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PromptEdit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut ::windows::core::RawPtr, pbsuccess: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PromptEdit: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEntity(::windows::core::IUnknown);
impl IEntity {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Base(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Base)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Relationships<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).Relationships)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRelationship<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszrelationname: Param0) -> ::windows::core::Result<IRelationship> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetRelationship)(::core::mem::transmute_copy(self), pszrelationname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IRelationship>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).MetaData)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn NamedEntities<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).NamedEntities)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetNamedEntity<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszvalue: Param0) -> ::windows::core::Result<INamedEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetNamedEntity)(::core::mem::transmute_copy(self), pszvalue.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<INamedEntity>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DefaultPhrase)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<IEntity> for ::windows::core::IUnknown {
    fn from(value: IEntity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEntity> for ::windows::core::IUnknown {
    fn from(value: &IEntity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEntity {}
impl ::core::fmt::Debug for IEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEntity {
    type Vtable = IEntity_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24264891_e80b_4fd3_b7ce_4ff2fae8931f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEntity_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Base: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbaseentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub Relationships: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, prelationships: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRelationship: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrelationname: ::windows::core::PCWSTR, prelationship: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub NamedEntities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pnamedentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNamedEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvalue: ::windows::core::PCWSTR, ppnamedentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumItemProperties(::windows::core::IUnknown);
impl IEnumItemProperties {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Next(&self, rgelt: &mut [ITEMPROP], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::core::mem::transmute_copy(self), rgelt.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgelt)), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumItemProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumItemProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IEnumItemProperties> for ::windows::core::IUnknown {
    fn from(value: IEnumItemProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumItemProperties> for ::windows::core::IUnknown {
    fn from(value: &IEnumItemProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumItemProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IEnumItemProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumItemProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumItemProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumItemProperties {}
impl ::core::fmt::Debug for IEnumItemProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumItemProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumItemProperties {
    type Vtable = IEnumItemProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d96_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumItemProperties_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ITEMPROP, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSearchRoots(::windows::core::IUnknown);
impl IEnumSearchRoots {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Next(&self, rgelt: &mut [::core::option::Option<ISearchRoot>], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::core::mem::transmute_copy(self), rgelt.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgelt)), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchRoots>(result__)
    }
}
impl ::core::convert::From<IEnumSearchRoots> for ::windows::core::IUnknown {
    fn from(value: IEnumSearchRoots) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSearchRoots> for ::windows::core::IUnknown {
    fn from(value: &IEnumSearchRoots) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSearchRoots {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IEnumSearchRoots {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSearchRoots {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchRoots {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchRoots {}
impl ::core::fmt::Debug for IEnumSearchRoots {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchRoots").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSearchRoots {
    type Vtable = IEnumSearchRoots_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef52);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchRoots_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::windows::core::RawPtr, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSearchScopeRules(::windows::core::IUnknown);
impl IEnumSearchScopeRules {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Next(&self, pprgelt: &mut [::core::option::Option<ISearchScopeRule>], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::core::mem::transmute_copy(self), pprgelt.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pprgelt)), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchScopeRules>(result__)
    }
}
impl ::core::convert::From<IEnumSearchScopeRules> for ::windows::core::IUnknown {
    fn from(value: IEnumSearchScopeRules) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSearchScopeRules> for ::windows::core::IUnknown {
    fn from(value: &IEnumSearchScopeRules) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSearchScopeRules {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IEnumSearchScopeRules {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSearchScopeRules {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchScopeRules {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchScopeRules {}
impl ::core::fmt::Debug for IEnumSearchScopeRules {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchScopeRules").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSearchScopeRules {
    type Vtable = IEnumSearchScopeRules_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef54);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchScopeRules_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, pprgelt: *mut ::windows::core::RawPtr, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSubscription(::windows::core::IUnknown);
impl IEnumSubscription {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Next(&self, rgelt: &mut [::windows::core::GUID], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::core::mem::transmute_copy(self), rgelt.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgelt)), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSubscription> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Clone)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSubscription>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IEnumSubscription> for ::windows::core::IUnknown {
    fn from(value: IEnumSubscription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSubscription> for ::windows::core::IUnknown {
    fn from(value: &IEnumSubscription) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSubscription {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IEnumSubscription {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSubscription {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSubscription {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSubscription {}
impl ::core::fmt::Debug for IEnumSubscription {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSubscription").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSubscription {
    type Vtable = IEnumSubscription_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d97_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSubscription_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::windows::core::GUID, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IErrorLookup(::windows::core::IUnknown);
impl IErrorLookup {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorDescription(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: *mut super::super::Foundation::BSTR, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetErrorDescription)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(pdispparams), ::core::mem::transmute(lcid), ::core::mem::transmute(pbstrsource), ::core::mem::transmute(pbstrdescription)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetHelpInfo(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: *mut super::super::Foundation::BSTR, pdwhelpcontext: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetHelpInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(lcid), ::core::mem::transmute(pbstrhelpfile), ::core::mem::transmute(pdwhelpcontext)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseErrors(&self, dwdynamicerrorid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseErrors)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdynamicerrorid)).ok()
    }
}
impl ::core::convert::From<IErrorLookup> for ::windows::core::IUnknown {
    fn from(value: IErrorLookup) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IErrorLookup> for ::windows::core::IUnknown {
    fn from(value: &IErrorLookup) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IErrorLookup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IErrorLookup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IErrorLookup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorLookup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorLookup {}
impl ::core::fmt::Debug for IErrorLookup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorLookup").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IErrorLookup {
    type Vtable = IErrorLookup_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a66_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorLookup_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetErrorDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: *mut super::super::Foundation::BSTR, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetErrorDescription: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetHelpInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: *mut super::super::Foundation::BSTR, pdwhelpcontext: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetHelpInfo: usize,
    pub ReleaseErrors: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IErrorRecords(::windows::core::IUnknown);
impl IErrorRecords {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddErrorRecord<'a, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, punkcustomerror: Param3, dwdynamicerrorid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddErrorRecord)(::core::mem::transmute_copy(self), ::core::mem::transmute(perrorinfo), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(pdispparams), punkcustomerror.into_param().abi(), ::core::mem::transmute(dwdynamicerrorid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetBasicErrorInfo(&self, ulrecordnum: u32) -> ::windows::core::Result<ERRORINFO> {
        let mut result__: ERRORINFO = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetBasicErrorInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(&mut result__)).from_abi::<ERRORINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCustomErrorObject(&self, ulrecordnum: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCustomErrorObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetErrorInfo(&self, ulrecordnum: u32, lcid: u32) -> ::windows::core::Result<super::Com::IErrorInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetErrorInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IErrorInfo>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorParameters(&self, ulrecordnum: u32) -> ::windows::core::Result<super::Com::DISPPARAMS> {
        let mut result__: super::Com::DISPPARAMS = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetErrorParameters)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::DISPPARAMS>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRecordCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetRecordCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IErrorRecords> for ::windows::core::IUnknown {
    fn from(value: IErrorRecords) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IErrorRecords> for ::windows::core::IUnknown {
    fn from(value: &IErrorRecords) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IErrorRecords {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IErrorRecords {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IErrorRecords {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorRecords {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorRecords {}
impl ::core::fmt::Debug for IErrorRecords {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorRecords").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IErrorRecords {
    type Vtable = IErrorRecords_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a67_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorRecords_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AddErrorRecord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, punkcustomerror: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AddErrorRecord: usize,
    pub GetBasicErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, perrorinfo: *mut ERRORINFO) -> ::windows::core::HRESULT,
    pub GetCustomErrorObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, riid: *const ::windows::core::GUID, ppobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, lcid: u32, pperrorinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetErrorInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetErrorParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, pdispparams: *mut super::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetErrorParameters: usize,
    pub GetRecordCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcrecords: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetDataSource(::windows::core::IUnknown);
impl IGetDataSource {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetDataSource(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetDataSource)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetDataSource> for ::windows::core::IUnknown {
    fn from(value: IGetDataSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetDataSource> for ::windows::core::IUnknown {
    fn from(value: &IGetDataSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetDataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetDataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetDataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetDataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetDataSource {}
impl ::core::fmt::Debug for IGetDataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetDataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetDataSource {
    type Vtable = IGetDataSource_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a75_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetDataSource_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetRow(::windows::core::IUnknown);
impl IGetRow {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowFromHROW<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, hrow: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetRowFromHROW)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(hrow), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetURLFromHROW(&self, hrow: usize) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetURLFromHROW)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<IGetRow> for ::windows::core::IUnknown {
    fn from(value: IGetRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetRow> for ::windows::core::IUnknown {
    fn from(value: &IGetRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetRow {}
impl ::core::fmt::Debug for IGetRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetRow {
    type Vtable = IGetRow_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetRow_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetRowFromHROW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hrow: usize, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetURLFromHROW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, ppwszurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetSession(::windows::core::IUnknown);
impl IGetSession {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSession)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetSession> for ::windows::core::IUnknown {
    fn from(value: IGetSession) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetSession> for ::windows::core::IUnknown {
    fn from(value: &IGetSession) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSession {}
impl ::core::fmt::Debug for IGetSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetSession {
    type Vtable = IGetSession_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aba_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSession_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetSourceRow(::windows::core::IUnknown);
impl IGetSourceRow {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSourceRow(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSourceRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetSourceRow> for ::windows::core::IUnknown {
    fn from(value: IGetSourceRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetSourceRow> for ::windows::core::IUnknown {
    fn from(value: &IGetSourceRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetSourceRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetSourceRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetSourceRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSourceRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSourceRow {}
impl ::core::fmt::Debug for IGetSourceRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSourceRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetSourceRow {
    type Vtable = IGetSourceRow_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abb_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSourceRow_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetSourceRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprow: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IIndexDefinition(::windows::core::IUnknown);
impl IIndexDefinition {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, rgindexcolumndescs: &[DBINDEXCOLUMNDESC], rgpropertysets: &mut [DBPROPSET], ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), rgindexcolumndescs.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgindexcolumndescs)), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), ::core::mem::transmute(ppindexid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DropIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid)).ok()
    }
}
impl ::core::convert::From<IIndexDefinition> for ::windows::core::IUnknown {
    fn from(value: IIndexDefinition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IIndexDefinition> for ::windows::core::IUnknown {
    fn from(value: &IIndexDefinition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IIndexDefinition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IIndexDefinition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IIndexDefinition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IIndexDefinition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IIndexDefinition {}
impl ::core::fmt::Debug for IIndexDefinition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IIndexDefinition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IIndexDefinition {
    type Vtable = IIndexDefinition_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a68_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IIndexDefinition_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, cindexcolumndescs: usize, rgindexcolumndescs: *const DBINDEXCOLUMNDESC, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateIndex: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DropIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DropIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IInterval(::windows::core::IUnknown);
impl IInterval {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetLimits(&self, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut super::Com::StructuredStorage::PROPVARIANT, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLimits)(::core::mem::transmute_copy(self), ::core::mem::transmute(pilklower), ::core::mem::transmute(ppropvarlower), ::core::mem::transmute(pilkupper), ::core::mem::transmute(ppropvarupper)).ok()
    }
}
impl ::core::convert::From<IInterval> for ::windows::core::IUnknown {
    fn from(value: IInterval) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IInterval> for ::windows::core::IUnknown {
    fn from(value: &IInterval) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IInterval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IInterval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IInterval {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IInterval {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IInterval {}
impl ::core::fmt::Debug for IInterval {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IInterval").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IInterval {
    type Vtable = IInterval_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bf0a714_3c18_430b_8b5d_83b1c234d3db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IInterval_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut super::Com::StructuredStorage::PROPVARIANT, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetLimits: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ILoadFilter(::windows::core::IUnknown);
impl ILoadFilter {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pwcspath: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LoadIFilter)(::core::mem::transmute_copy(self), pwcspath.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, Param0: ::windows::core::IntoParam<'a, super::Com::StructuredStorage::IStorage>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstg: Param0, punkouter: Param1, pwcsoverride: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LoadIFilterFromStorage)(::core::mem::transmute_copy(self), pstg.into_param().abi(), punkouter.into_param().abi(), pwcsoverride.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LoadIFilterFromStream)(::core::mem::transmute_copy(self), pstm.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
}
impl ::core::convert::From<ILoadFilter> for ::windows::core::IUnknown {
    fn from(value: ILoadFilter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilter> for ::windows::core::IUnknown {
    fn from(value: &ILoadFilter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ILoadFilter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ILoadFilter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ILoadFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilter {}
impl ::core::fmt::Debug for ILoadFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ILoadFilter {
    type Vtable = ILoadFilter_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7310722_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilter_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub LoadIFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcspath: ::windows::core::PCWSTR, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    LoadIFilter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub LoadIFilterFromStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstg: ::windows::core::RawPtr, punkouter: *mut ::core::ffi::c_void, pwcsoverride: ::windows::core::PCWSTR, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage")))]
    LoadIFilterFromStorage: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub LoadIFilterFromStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    LoadIFilterFromStream: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ILoadFilterWithPrivateComActivation(::windows::core::IUnknown);
impl ILoadFilterWithPrivateComActivation {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pwcspath: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.LoadIFilter)(::core::mem::transmute_copy(self), pwcspath.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, Param0: ::windows::core::IntoParam<'a, super::Com::StructuredStorage::IStorage>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstg: Param0, punkouter: Param1, pwcsoverride: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.LoadIFilterFromStorage)(::core::mem::transmute_copy(self), pstg.into_param().abi(), punkouter.into_param().abi(), pwcsoverride.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.LoadIFilterFromStream)(::core::mem::transmute_copy(self), pstm.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilterWithPrivateComActivation<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: Param1, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LoadIFilterWithPrivateComActivation)(::core::mem::transmute_copy(self), ::core::mem::transmute(filteredsources), usedefault.into_param().abi(), ::core::mem::transmute(filterclsid), ::core::mem::transmute(isfilterprivatecomactivated), ::core::mem::transmute(filterobj)).ok()
    }
}
impl ::core::convert::From<ILoadFilterWithPrivateComActivation> for ::windows::core::IUnknown {
    fn from(value: ILoadFilterWithPrivateComActivation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilterWithPrivateComActivation> for ::windows::core::IUnknown {
    fn from(value: &ILoadFilterWithPrivateComActivation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ILoadFilterWithPrivateComActivation> for ILoadFilter {
    fn from(value: ILoadFilterWithPrivateComActivation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilterWithPrivateComActivation> for ILoadFilter {
    fn from(value: &ILoadFilterWithPrivateComActivation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILoadFilter> for ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ILoadFilter> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILoadFilter> for &'a ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ILoadFilter> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ILoadFilterWithPrivateComActivation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilterWithPrivateComActivation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilterWithPrivateComActivation {}
impl ::core::fmt::Debug for ILoadFilterWithPrivateComActivation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilterWithPrivateComActivation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ILoadFilterWithPrivateComActivation {
    type Vtable = ILoadFilterWithPrivateComActivation_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40bdbd34_780b_48d3_9bb6_12ebd4ad2e75);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilterWithPrivateComActivation_Vtbl {
    pub base__: ILoadFilter_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub LoadIFilterWithPrivateComActivation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: super::super::Foundation::BOOL, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    LoadIFilterWithPrivateComActivation: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDDataset(::windows::core::IUnknown);
impl IMDDataset {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn FreeAxisInfo(&self, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FreeAxisInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(caxes), ::core::mem::transmute(rgaxisinfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetAxisInfo(&self, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAxisInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcaxes), ::core::mem::transmute(prgaxisinfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetAxisRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAxisRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(iaxis), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCellData(&self, haccessor: usize, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCellData)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ulstartcell), ::core::mem::transmute(ulendcell), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSpecification)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IMDDataset> for ::windows::core::IUnknown {
    fn from(value: IMDDataset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDDataset> for ::windows::core::IUnknown {
    fn from(value: &IMDDataset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDDataset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IMDDataset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDDataset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDDataset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDDataset {}
impl ::core::fmt::Debug for IMDDataset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDDataset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDDataset {
    type Vtable = IMDDataset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd1_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDDataset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub FreeAxisInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::HRESULT,
    pub GetAxisInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetAxisRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetAxisRowset: usize,
    pub GetCellData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDFind(::windows::core::IUnknown);
impl IMDFind {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn FindCell(&self, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FindCell)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulstartingordinal), ::core::mem::transmute(cmembers), ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pulcellordinal)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn FindTuple(&self, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FindTuple)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulaxisidentifier), ::core::mem::transmute(ulstartingordinal), ::core::mem::transmute(cmembers), ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pultupleordinal)).ok()
    }
}
impl ::core::convert::From<IMDFind> for ::windows::core::IUnknown {
    fn from(value: IMDFind) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDFind> for ::windows::core::IUnknown {
    fn from(value: &IMDFind) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IMDFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDFind {}
impl ::core::fmt::Debug for IMDFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDFind {
    type Vtable = IMDFind_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd2_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDFind_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub FindCell: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::HRESULT,
    pub FindTuple: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDRangeRowset(::windows::core::IUnknown);
impl IMDRangeRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRangeRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRangeRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ulstartcell), ::core::mem::transmute(ulendcell), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IMDRangeRowset> for ::windows::core::IUnknown {
    fn from(value: IMDRangeRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDRangeRowset> for ::windows::core::IUnknown {
    fn from(value: &IMDRangeRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDRangeRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IMDRangeRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDRangeRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDRangeRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDRangeRowset {}
impl ::core::fmt::Debug for IMDRangeRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDRangeRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDRangeRowset {
    type Vtable = IMDRangeRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDRangeRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRangeRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRangeRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMetaData(::windows::core::IUnknown);
impl IMetaData {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetData(&self, ppszkey: *mut ::windows::core::PWSTR, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszkey), ::core::mem::transmute(ppszvalue)).ok()
    }
}
impl ::core::convert::From<IMetaData> for ::windows::core::IUnknown {
    fn from(value: IMetaData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMetaData> for ::windows::core::IUnknown {
    fn from(value: &IMetaData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMetaData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IMetaData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMetaData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMetaData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMetaData {}
impl ::core::fmt::Debug for IMetaData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMetaData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMetaData {
    type Vtable = IMetaData_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x780102b0_c43b_4876_bc7b_5e9ba5c88794);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMetaData_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszkey: *mut ::windows::core::PWSTR, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMultipleResults(::windows::core::IUnknown);
impl IMultipleResults {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetResult<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetResult)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(lresultflag), ::core::mem::transmute(riid), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IMultipleResults> for ::windows::core::IUnknown {
    fn from(value: IMultipleResults) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMultipleResults> for ::windows::core::IUnknown {
    fn from(value: &IMultipleResults) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMultipleResults {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IMultipleResults {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMultipleResults {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMultipleResults {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultipleResults {}
impl ::core::fmt::Debug for IMultipleResults {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultipleResults").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMultipleResults {
    type Vtable = IMultipleResults_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a90_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultipleResults_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct INCREMENTAL_ACCESS_INFO {
    pub dwSize: u32,
    pub ftLastModifiedTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for INCREMENTAL_ACCESS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for INCREMENTAL_ACCESS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for INCREMENTAL_ACCESS_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("INCREMENTAL_ACCESS_INFO").field("dwSize", &self.dwSize).field("ftLastModifiedTime", &self.ftLastModifiedTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for INCREMENTAL_ACCESS_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for INCREMENTAL_ACCESS_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<INCREMENTAL_ACCESS_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for INCREMENTAL_ACCESS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for INCREMENTAL_ACCESS_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_AGENT_CACHE_SIZE_EXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693246i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_AGENT_CONNECTION_FAILED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693245i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_AGENT_EXCEEDING_CACHE_SIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693232i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_AGENT_MAX_SIZE_EXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693248i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_SCHEDULED_EXCLUDE_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693241i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_SCHEDULED_UPDATES_DISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693244i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_SCHEDULED_UPDATES_RESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693243i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_E_SCHEDULED_UPDATE_INTERVAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693242i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_S_AGENT_INCREASED_CACHE_SIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(790416i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const INET_S_AGENT_PART_FAIL: ::windows::core::HRESULT = ::windows::core::HRESULT(790401i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct INTERVAL_LIMIT_KIND(pub i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ILK_EXPLICIT_INCLUDED: INTERVAL_LIMIT_KIND = INTERVAL_LIMIT_KIND(0i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ILK_EXPLICIT_EXCLUDED: INTERVAL_LIMIT_KIND = INTERVAL_LIMIT_KIND(1i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ILK_NEGATIVE_INFINITY: INTERVAL_LIMIT_KIND = INTERVAL_LIMIT_KIND(2i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ILK_POSITIVE_INFINITY: INTERVAL_LIMIT_KIND = INTERVAL_LIMIT_KIND(3i32);
impl ::core::marker::Copy for INTERVAL_LIMIT_KIND {}
impl ::core::clone::Clone for INTERVAL_LIMIT_KIND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for INTERVAL_LIMIT_KIND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for INTERVAL_LIMIT_KIND {
    type Abi = Self;
}
impl ::core::fmt::Debug for INTERVAL_LIMIT_KIND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INTERVAL_LIMIT_KIND").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct INamedEntity(::windows::core::IUnknown);
impl INamedEntity {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetValue(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DefaultPhrase)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<INamedEntity> for ::windows::core::IUnknown {
    fn from(value: INamedEntity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&INamedEntity> for ::windows::core::IUnknown {
    fn from(value: &INamedEntity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for INamedEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a INamedEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for INamedEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntity {}
impl ::core::fmt::Debug for INamedEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for INamedEntity {
    type Vtable = INamedEntity_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabdbd0b1_7d54_49fb_ab5c_bff4130004cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntity_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct INamedEntityCollector(::windows::core::IUnknown);
impl INamedEntityCollector {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Add<'a, Param4: ::windows::core::IntoParam<'a, IEntity>, Param5: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: Param4, pszvalue: Param5, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Add)(::core::mem::transmute_copy(self), ::core::mem::transmute(beginspan), ::core::mem::transmute(endspan), ::core::mem::transmute(beginactual), ::core::mem::transmute(endactual), ptype.into_param().abi(), pszvalue.into_param().abi(), ::core::mem::transmute(certainty)).ok()
    }
}
impl ::core::convert::From<INamedEntityCollector> for ::windows::core::IUnknown {
    fn from(value: INamedEntityCollector) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&INamedEntityCollector> for ::windows::core::IUnknown {
    fn from(value: &INamedEntityCollector) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for INamedEntityCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a INamedEntityCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for INamedEntityCollector {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntityCollector {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntityCollector {}
impl ::core::fmt::Debug for INamedEntityCollector {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntityCollector").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for INamedEntityCollector {
    type Vtable = INamedEntityCollector_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaf2440f6_8afc_47d0_9a7f_396a0acfb43d);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntityCollector_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: ::windows::core::RawPtr, pszvalue: ::windows::core::PCWSTR, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IObjectAccessControl(::windows::core::IUnknown);
impl IObjectAccessControl {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetObjectAccessRights)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(pcaccessentries), ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectOwner(&self, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetObjectOwner)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(ppowner)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn IsObjectAccessAllowed(&self, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsObjectAccessAllowed)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(paccessentry), ::core::mem::transmute(pfresult)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetObjectAccessRights)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(caccessentries), ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectOwner(&self, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetObjectOwner)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(powner)).ok()
    }
}
impl ::core::convert::From<IObjectAccessControl> for ::windows::core::IUnknown {
    fn from(value: IObjectAccessControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IObjectAccessControl> for ::windows::core::IUnknown {
    fn from(value: &IObjectAccessControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IObjectAccessControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IObjectAccessControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IObjectAccessControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IObjectAccessControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IObjectAccessControl {}
impl ::core::fmt::Debug for IObjectAccessControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IObjectAccessControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IObjectAccessControl {
    type Vtable = IObjectAccessControl_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IObjectAccessControl_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub GetObjectAccessRights: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    GetObjectAccessRights: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub GetObjectOwner: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    GetObjectOwner: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub IsObjectAccessAllowed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    IsObjectAccessAllowed: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub SetObjectAccessRights: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    SetObjectAccessRights: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub SetObjectOwner: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    SetObjectOwner: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IOpLockStatus(::windows::core::IUnknown);
impl IOpLockStatus {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockValid(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsOplockValid)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockBroken(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsOplockBroken)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOplockEventHandle(&self) -> ::windows::core::Result<super::super::Foundation::HANDLE> {
        let mut result__: super::super::Foundation::HANDLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetOplockEventHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
}
impl ::core::convert::From<IOpLockStatus> for ::windows::core::IUnknown {
    fn from(value: IOpLockStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IOpLockStatus> for ::windows::core::IUnknown {
    fn from(value: &IOpLockStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IOpLockStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IOpLockStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IOpLockStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpLockStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpLockStatus {}
impl ::core::fmt::Debug for IOpLockStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpLockStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IOpLockStatus {
    type Vtable = IOpLockStatus_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc731065d_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpLockStatus_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub IsOplockValid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockvalid: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsOplockValid: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsOplockBroken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockbroken: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsOplockBroken: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetOplockEventHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phoplockev: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetOplockEventHandle: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IOpenRowset(::windows::core::IUnknown);
impl IOpenRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, rgpropertysets: &mut [DBPROPSET], pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OpenRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(riid), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IOpenRowset> for ::windows::core::IUnknown {
    fn from(value: IOpenRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IOpenRowset> for ::windows::core::IUnknown {
    fn from(value: &IOpenRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IOpenRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IOpenRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IOpenRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpenRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpenRowset {}
impl ::core::fmt::Debug for IOpenRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpenRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IOpenRowset {
    type Vtable = IOpenRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a69_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpenRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OpenRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OpenRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IParentRowset(::windows::core::IUnknown);
impl IParentRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetChildRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetChildRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(iordinal), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IParentRowset> for ::windows::core::IUnknown {
    fn from(value: IParentRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IParentRowset> for ::windows::core::IUnknown {
    fn from(value: &IParentRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IParentRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IParentRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IParentRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IParentRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IParentRowset {}
impl ::core::fmt::Debug for IParentRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IParentRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IParentRowset {
    type Vtable = IParentRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaa_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IParentRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetChildRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IProtocolHandlerSite(::windows::core::IUnknown);
impl IProtocolHandlerSite {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetFilter<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: Param1, pcwszextension: Param2, ppfilter: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetFilter)(::core::mem::transmute_copy(self), ::core::mem::transmute(pclsidobj), pcwszcontenttype.into_param().abi(), pcwszextension.into_param().abi(), ::core::mem::transmute(ppfilter)).ok()
    }
}
impl ::core::convert::From<IProtocolHandlerSite> for ::windows::core::IUnknown {
    fn from(value: IProtocolHandlerSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IProtocolHandlerSite> for ::windows::core::IUnknown {
    fn from(value: &IProtocolHandlerSite) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IProtocolHandlerSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IProtocolHandlerSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IProtocolHandlerSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProtocolHandlerSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProtocolHandlerSite {}
impl ::core::fmt::Debug for IProtocolHandlerSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProtocolHandlerSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IProtocolHandlerSite {
    type Vtable = IProtocolHandlerSite_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e385_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProtocolHandlerSite_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: ::windows::core::PCWSTR, pcwszextension: ::windows::core::PCWSTR, ppfilter: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetFilter: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IProvideMoniker(::windows::core::IUnknown);
impl IProvideMoniker {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMoniker(&self) -> ::windows::core::Result<super::Com::IMoniker> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetMoniker)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IMoniker>(result__)
    }
}
impl ::core::convert::From<IProvideMoniker> for ::windows::core::IUnknown {
    fn from(value: IProvideMoniker) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IProvideMoniker> for ::windows::core::IUnknown {
    fn from(value: &IProvideMoniker) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IProvideMoniker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IProvideMoniker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IProvideMoniker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProvideMoniker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProvideMoniker {}
impl ::core::fmt::Debug for IProvideMoniker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProvideMoniker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IProvideMoniker {
    type Vtable = IProvideMoniker_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProvideMoniker_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetMoniker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppimoniker: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetMoniker: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQueryParser(::windows::core::IUnknown);
impl IQueryParser {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parse<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>>(&self, pszinputstring: Param0, pcustomproperties: Param1) -> ::windows::core::Result<IQuerySolution> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parse)(::core::mem::transmute_copy(self), pszinputstring.into_param().abi(), pcustomproperties.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOption)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(poptionvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION) -> ::windows::core::Result<super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetOption)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetMultiOption<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: Param1, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMultiOption)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), pszoptionkey.into_param().abi(), ::core::mem::transmute(poptionvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSchemaProvider(&self) -> ::windows::core::Result<ISchemaProvider> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSchemaProvider)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISchemaProvider>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RestateToString<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcondition: Param0, fuseenglish: Param1) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).RestateToString)(::core::mem::transmute_copy(self), pcondition.into_param().abi(), fuseenglish.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ParsePropertyValue<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszpropertyname: Param0, pszinputstring: Param1) -> ::windows::core::Result<IQuerySolution> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ParsePropertyValue)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), pszinputstring.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RestatePropertyValueToString<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcondition: Param0, fuseenglish: Param1, ppszpropertyname: *mut ::windows::core::PWSTR, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RestatePropertyValueToString)(::core::mem::transmute_copy(self), pcondition.into_param().abi(), fuseenglish.into_param().abi(), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(ppszquerystring)).ok()
    }
}
impl ::core::convert::From<IQueryParser> for ::windows::core::IUnknown {
    fn from(value: IQueryParser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQueryParser> for ::windows::core::IUnknown {
    fn from(value: &IQueryParser) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQueryParser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IQueryParser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQueryParser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParser {}
impl ::core::fmt::Debug for IQueryParser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQueryParser {
    type Vtable = IQueryParser_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2ebdee67_3505_43f8_9946_ea44abc8e5b0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParser_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Parse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: ::windows::core::PCWSTR, pcustomproperties: ::windows::core::RawPtr, ppsolution: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parse: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetOption: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetOption: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetMultiOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: ::windows::core::PCWSTR, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetMultiOption: usize,
    pub GetSchemaProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppschemaprovider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub RestateToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: ::windows::core::RawPtr, fuseenglish: super::super::Foundation::BOOL, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    RestateToString: usize,
    pub ParsePropertyValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: ::windows::core::PCWSTR, pszinputstring: ::windows::core::PCWSTR, ppsolution: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub RestatePropertyValueToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: ::windows::core::RawPtr, fuseenglish: super::super::Foundation::BOOL, ppszpropertyname: *mut ::windows::core::PWSTR, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    RestatePropertyValueToString: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQueryParserManager(::windows::core::IUnknown);
impl IQueryParserManager {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateLoadedParser<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, T: ::windows::core::Interface>(&self, pszcatalog: Param0, langidforkeywords: u16) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateLoadedParser)(::core::mem::transmute_copy(self), pszcatalog.into_param().abi(), ::core::mem::transmute(langidforkeywords), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param2: ::windows::core::IntoParam<'a, IQueryParser>>(&self, funderstandnqs: Param0, fautowildcard: Param1, pqueryparser: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeOptions)(::core::mem::transmute_copy(self), funderstandnqs.into_param().abi(), fautowildcard.into_param().abi(), pqueryparser.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOption)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(poptionvalue)).ok()
    }
}
impl ::core::convert::From<IQueryParserManager> for ::windows::core::IUnknown {
    fn from(value: IQueryParserManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQueryParserManager> for ::windows::core::IUnknown {
    fn from(value: &IQueryParserManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQueryParserManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IQueryParserManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQueryParserManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParserManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParserManager {}
impl ::core::fmt::Debug for IQueryParserManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParserManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQueryParserManager {
    type Vtable = IQueryParserManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa879e3c4_af77_44fb_8f37_ebd1487cf920);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParserManager_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CreateLoadedParser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: ::windows::core::PCWSTR, langidforkeywords: u16, riid: *const ::windows::core::GUID, ppqueryparser: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, funderstandnqs: super::super::Foundation::BOOL, fautowildcard: super::super::Foundation::BOOL, pqueryparser: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeOptions: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetOption: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQuerySolution(::windows::core::IUnknown);
impl IQuerySolution {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeNot)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeAndOr)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.MakeLeaf)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.Resolve)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetQuery(&self, ppquerynode: *mut ::core::option::Option<ICondition>, ppmaintype: *mut ::core::option::Option<IEntity>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuery)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppquerynode), ::core::mem::transmute(ppmaintype)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetErrors<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetErrors)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetLexicalData(&self, ppszinputstring: *mut ::windows::core::PWSTR, pptokens: *mut ::core::option::Option<ITokenCollection>, plcid: *mut u32, ppwordbreaker: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLexicalData)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszinputstring), ::core::mem::transmute(pptokens), ::core::mem::transmute(plcid), ::core::mem::transmute(ppwordbreaker)).ok()
    }
}
impl ::core::convert::From<IQuerySolution> for ::windows::core::IUnknown {
    fn from(value: IQuerySolution) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQuerySolution> for ::windows::core::IUnknown {
    fn from(value: &IQuerySolution) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IQuerySolution> for IConditionFactory {
    fn from(value: IQuerySolution) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQuerySolution> for IConditionFactory {
    fn from(value: &IQuerySolution) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for &'a IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQuerySolution {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQuerySolution {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQuerySolution {}
impl ::core::fmt::Debug for IQuerySolution {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQuerySolution").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQuerySolution {
    type Vtable = IQuerySolution_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6ebc66b_8921_4193_afdd_a1789fb7ff57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQuerySolution_Vtbl {
    pub base__: IConditionFactory_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetQuery: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppquerynode: *mut ::windows::core::RawPtr, ppmaintype: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetQuery: usize,
    pub GetErrors: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppparseerrors: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetLexicalData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszinputstring: *mut ::windows::core::PWSTR, pptokens: *mut ::windows::core::RawPtr, plcid: *mut u32, ppwordbreaker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IReadData(::windows::core::IUnknown);
impl IReadData {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReadData(&self, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: usize, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReadData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(haccessor), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(ppfixeddata), ::core::mem::transmute(pcbvariabletotal), ::core::mem::transmute(ppvariabledata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseChapter)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter)).ok()
    }
}
impl ::core::convert::From<IReadData> for ::windows::core::IUnknown {
    fn from(value: IReadData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IReadData> for ::windows::core::IUnknown {
    fn from(value: &IReadData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IReadData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IReadData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IReadData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IReadData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IReadData {}
impl ::core::fmt::Debug for IReadData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IReadData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IReadData {
    type Vtable = IReadData_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IReadData_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ReadData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: usize, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::HRESULT,
    pub ReleaseChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRegisterProvider(::windows::core::IUnknown);
impl IRegisterProvider {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetURLMapping<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszurl: Param0, dwreserved: usize) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetURLMapping)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetURLMapping<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszurl: Param0, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetURLMapping)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(rclsidprovider)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn UnregisterProvider<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pwszurl: Param0, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnregisterProvider)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(rclsidprovider)).ok()
    }
}
impl ::core::convert::From<IRegisterProvider> for ::windows::core::IUnknown {
    fn from(value: IRegisterProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRegisterProvider> for ::windows::core::IUnknown {
    fn from(value: &IRegisterProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRegisterProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRegisterProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRegisterProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRegisterProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRegisterProvider {}
impl ::core::fmt::Debug for IRegisterProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRegisterProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRegisterProvider {
    type Vtable = IRegisterProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRegisterProvider_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetURLMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, pclsidprovider: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub SetURLMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub UnregisterProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRelationship(::windows::core::IUnknown);
impl IRelationship {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsReal(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsReal)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Destination(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Destination)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).MetaData)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DefaultPhrase)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<IRelationship> for ::windows::core::IUnknown {
    fn from(value: IRelationship) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRelationship> for ::windows::core::IUnknown {
    fn from(value: &IRelationship) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRelationship {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRelationship {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRelationship {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRelationship {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRelationship {}
impl ::core::fmt::Debug for IRelationship {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRelationship").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRelationship {
    type Vtable = IRelationship_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2769280b_5108_498c_9c7f_a51239b63147);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRelationship_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsReal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisreal: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsReal: usize,
    pub Destination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRichChunk(::windows::core::IUnknown);
impl IRichChunk {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetData(&self, pfirstpos: *mut u32, plength: *mut u32, ppsz: *mut ::windows::core::PWSTR, pvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfirstpos), ::core::mem::transmute(plength), ::core::mem::transmute(ppsz), ::core::mem::transmute(pvalue)).ok()
    }
}
impl ::core::convert::From<IRichChunk> for ::windows::core::IUnknown {
    fn from(value: IRichChunk) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRichChunk> for ::windows::core::IUnknown {
    fn from(value: &IRichChunk) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRichChunk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRichChunk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRichChunk {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRichChunk {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRichChunk {}
impl ::core::fmt::Debug for IRichChunk {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRichChunk").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRichChunk {
    type Vtable = IRichChunk_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4fdef69c_dbc9_454e_9910_b34f3c64b510);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRichChunk_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfirstpos: *mut u32, plength: *mut u32, ppsz: *mut ::windows::core::PWSTR, pvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetData: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRow(::windows::core::IUnknown);
impl IRow {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetColumns(&self, rgcolumns: &mut [DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumns)(::core::mem::transmute_copy(self), rgcolumns.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgcolumns))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSourceRowset(&self, riid: *const ::windows::core::GUID, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSourceRowset)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(pprowset), ::core::mem::transmute(phrow)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn Open<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Open)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(pcolumnid), ::core::mem::transmute(rguidcolumntype), ::core::mem::transmute(dwbindflags), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRow> for ::windows::core::IUnknown {
    fn from(value: IRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRow> for ::windows::core::IUnknown {
    fn from(value: &IRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRow {}
impl ::core::fmt::Debug for IRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRow {
    type Vtable = IRow_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab4_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRow_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetColumns: usize,
    pub GetSourceRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub Open: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    Open: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowChange(::windows::core::IUnknown);
impl IRowChange {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetColumns(&self, rgcolumns: &[DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetColumns)(::core::mem::transmute_copy(self), rgcolumns.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgcolumns))).ok()
    }
}
impl ::core::convert::From<IRowChange> for ::windows::core::IUnknown {
    fn from(value: IRowChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowChange> for ::windows::core::IUnknown {
    fn from(value: &IRowChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowChange {}
impl ::core::fmt::Debug for IRowChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowChange {
    type Vtable = IRowChange_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowChange_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SetColumns: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowPosition(::windows::core::IUnknown);
impl IRowPosition {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ClearRowPosition(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ClearRowPosition)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowPosition(&self, phchapter: *mut usize, phrow: *mut usize, pdwpositionflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowPosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(phchapter), ::core::mem::transmute(phrow), ::core::mem::transmute(pdwpositionflags)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowset(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetRowset)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, prowset: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::core::mem::transmute_copy(self), prowset.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetRowPosition(&self, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRowPosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(hrow), ::core::mem::transmute(dwpositionflags)).ok()
    }
}
impl ::core::convert::From<IRowPosition> for ::windows::core::IUnknown {
    fn from(value: IRowPosition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowPosition> for ::windows::core::IUnknown {
    fn from(value: &IRowPosition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowPosition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowPosition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowPosition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPosition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPosition {}
impl ::core::fmt::Debug for IRowPosition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPosition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowPosition {
    type Vtable = IRowPosition_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a94_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPosition_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ClearRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phchapter: *mut usize, phrow: *mut usize, pdwpositionflags: *mut u32) -> ::windows::core::HRESULT,
    pub GetRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowPositionChange(::windows::core::IUnknown);
impl IRowPositionChange {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowPositionChange<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ereason: u32, ephase: u32, fcantdeny: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnRowPositionChange)(::core::mem::transmute_copy(self), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowPositionChange> for ::windows::core::IUnknown {
    fn from(value: IRowPositionChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowPositionChange> for ::windows::core::IUnknown {
    fn from(value: &IRowPositionChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowPositionChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowPositionChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowPositionChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPositionChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPositionChange {}
impl ::core::fmt::Debug for IRowPositionChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPositionChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowPositionChange {
    type Vtable = IRowPositionChange_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0997a571_126e_11d0_9f8a_00a0c9a0631e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPositionChange_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowPositionChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowPositionChange: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowSchemaChange(::windows::core::IUnknown);
impl IRowSchemaChange {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetColumns(&self, rgcolumns: &[DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetColumns)(::core::mem::transmute_copy(self), rgcolumns.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgcolumns))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DeleteColumns(&self, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgdwstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn AddColumns(&self, ccolumns: usize, rgnewcolumninfo: *const DBCOLUMNINFO, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgnewcolumninfo), ::core::mem::transmute(rgcolumns)).ok()
    }
}
impl ::core::convert::From<IRowSchemaChange> for ::windows::core::IUnknown {
    fn from(value: IRowSchemaChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowSchemaChange> for ::windows::core::IUnknown {
    fn from(value: &IRowSchemaChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowSchemaChange> for IRowChange {
    fn from(value: IRowSchemaChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowSchemaChange> for IRowChange {
    fn from(value: &IRowSchemaChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowChange> for IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, IRowChange> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowChange> for &'a IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, IRowChange> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowSchemaChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowSchemaChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowSchemaChange {}
impl ::core::fmt::Debug for IRowSchemaChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowSchemaChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowSchemaChange {
    type Vtable = IRowSchemaChange_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aae_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowSchemaChange_Vtbl {
    pub base__: IRowChange_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DeleteColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DeleteColumns: usize,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub AddColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgnewcolumninfo: *const DBCOLUMNINFO, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    AddColumns: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowset(::windows::core::IUnknown);
impl IRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddRefRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetNextRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RestartPosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
}
impl ::core::convert::From<IRowset> for ::windows::core::IUnknown {
    fn from(value: IRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowset> for ::windows::core::IUnknown {
    fn from(value: &IRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowset {}
impl ::core::fmt::Debug for IRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowset {
    type Vtable = IRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub AddRefRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNextRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub ReleaseRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub RestartPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetAsynch(::windows::core::IUnknown);
impl IRowsetAsynch {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RatioFinished(&self, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RatioFinished)(::core::mem::transmute_copy(self), ::core::mem::transmute(puldenominator), ::core::mem::transmute(pulnumerator), ::core::mem::transmute(pcrows), ::core::mem::transmute(pfnewrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Stop)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IRowsetAsynch> for ::windows::core::IUnknown {
    fn from(value: IRowsetAsynch) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetAsynch> for ::windows::core::IUnknown {
    fn from(value: &IRowsetAsynch) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetAsynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetAsynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetAsynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetAsynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetAsynch {}
impl ::core::fmt::Debug for IRowsetAsynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetAsynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetAsynch {
    type Vtable = IRowsetAsynch_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a0f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetAsynch_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub RatioFinished: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RatioFinished: usize,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetBookmark(::windows::core::IUnknown);
impl IRowsetBookmark {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn PositionOnBookmark(&self, hchapter: usize, cbbookmark: usize, pbookmark: *const u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PositionOnBookmark)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark)).ok()
    }
}
impl ::core::convert::From<IRowsetBookmark> for ::windows::core::IUnknown {
    fn from(value: IRowsetBookmark) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetBookmark> for ::windows::core::IUnknown {
    fn from(value: &IRowsetBookmark) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetBookmark {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetBookmark {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetBookmark {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetBookmark {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetBookmark {}
impl ::core::fmt::Debug for IRowsetBookmark {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetBookmark").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetBookmark {
    type Vtable = IRowsetBookmark_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ac2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetBookmark_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub PositionOnBookmark: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChange(::windows::core::IUnknown);
impl IRowsetChange {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn InsertRow(&self, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InsertRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
impl ::core::convert::From<IRowsetChange> for ::windows::core::IUnknown {
    fn from(value: IRowsetChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChange> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChange {}
impl ::core::fmt::Debug for IRowsetChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChange {
    type Vtable = IRowsetChange_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a05_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChange_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub DeleteRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub SetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub InsertRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChangeExtInfo(::windows::core::IUnknown);
impl IRowsetChangeExtInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetOriginalRow(&self, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOriginalRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(hrow), ::core::mem::transmute(phroworiginal)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetPendingColumns(&self, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPendingColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(hrow), ::core::mem::transmute(ccolumnordinals), ::core::mem::transmute(rgiordinals), ::core::mem::transmute(rgcolumnstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetChangeExtInfo> for ::windows::core::IUnknown {
    fn from(value: IRowsetChangeExtInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChangeExtInfo> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChangeExtInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChangeExtInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetChangeExtInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChangeExtInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChangeExtInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChangeExtInfo {}
impl ::core::fmt::Debug for IRowsetChangeExtInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChangeExtInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChangeExtInfo {
    type Vtable = IRowsetChangeExtInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChangeExtInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetOriginalRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::HRESULT,
    pub GetPendingColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChapterMember(::windows::core::IUnknown);
impl IRowsetChapterMember {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn IsRowInChapter(&self, hchapter: usize, hrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsRowInChapter)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(hrow)).ok()
    }
}
impl ::core::convert::From<IRowsetChapterMember> for ::windows::core::IUnknown {
    fn from(value: IRowsetChapterMember) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChapterMember> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChapterMember) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChapterMember {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetChapterMember {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChapterMember {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChapterMember {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChapterMember {}
impl ::core::fmt::Debug for IRowsetChapterMember {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChapterMember").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChapterMember {
    type Vtable = IRowsetChapterMember_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChapterMember_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub IsRowInChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetCopyRows(::windows::core::IUnknown);
impl IRowsetCopyRows {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CloseSource(&self, hsourceid: u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CloseSource)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CopyByHROWS(&self, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyByHROWS)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(bflags)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CopyRows(&self, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(bflags), ::core::mem::transmute(pcrowscopied)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DefineSource<'a, Param0: ::windows::core::IntoParam<'a, IRowset>>(&self, prowsetsource: Param0, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DefineSource)(::core::mem::transmute_copy(self), prowsetsource.into_param().abi(), ::core::mem::transmute(ccolids), ::core::mem::transmute(rgsourcecolumns), ::core::mem::transmute(rgtargetcolumns), ::core::mem::transmute(phsourceid)).ok()
    }
}
impl ::core::convert::From<IRowsetCopyRows> for ::windows::core::IUnknown {
    fn from(value: IRowsetCopyRows) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCopyRows> for ::windows::core::IUnknown {
    fn from(value: &IRowsetCopyRows) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetCopyRows {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetCopyRows {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetCopyRows {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCopyRows {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCopyRows {}
impl ::core::fmt::Debug for IRowsetCopyRows {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCopyRows").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetCopyRows {
    type Vtable = IRowsetCopyRows_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCopyRows_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CloseSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16) -> ::windows::core::HRESULT,
    pub CopyByHROWS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::HRESULT,
    pub CopyRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::HRESULT,
    pub DefineSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowsetsource: ::windows::core::RawPtr, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetCurrentIndex(::windows::core::IUnknown);
impl IRowsetCurrentIndex {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetIndexInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Seek(&self, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Seek)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ckeyvalues), ::core::mem::transmute(pdata), ::core::mem::transmute(dwseekoptions)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetRange(&self, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRange)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(cstartkeycolumns), ::core::mem::transmute(pstartdata), ::core::mem::transmute(cendkeycolumns), ::core::mem::transmute(penddata), ::core::mem::transmute(dwrangeoptions)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetIndex(&self, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppindexid)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetIndex(&self, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(pindexid)).ok()
    }
}
impl ::core::convert::From<IRowsetCurrentIndex> for ::windows::core::IUnknown {
    fn from(value: IRowsetCurrentIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCurrentIndex> for ::windows::core::IUnknown {
    fn from(value: &IRowsetCurrentIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetCurrentIndex> for IRowsetIndex {
    fn from(value: IRowsetCurrentIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCurrentIndex> for IRowsetIndex {
    fn from(value: &IRowsetCurrentIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetIndex> for IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetIndex> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetIndex> for &'a IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetIndex> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetCurrentIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCurrentIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCurrentIndex {}
impl ::core::fmt::Debug for IRowsetCurrentIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCurrentIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetCurrentIndex {
    type Vtable = IRowsetCurrentIndex_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abd_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCurrentIndex_Vtbl {
    pub base__: IRowsetIndex_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetIndex: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SetIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SetIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetEvents(::windows::core::IUnknown);
impl IRowsetEvents {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnNewItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnNewItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(newitemstate)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnChangedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnChangedItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(rowsetitemstate), ::core::mem::transmute(changeditemstate)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnDeletedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnDeletedItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(deleteditemstate)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnRowsetEvent(&self, eventtype: ROWSETEVENT_TYPE, eventdata: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnRowsetEvent)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventtype), ::core::mem::transmute(eventdata)).ok()
    }
}
impl ::core::convert::From<IRowsetEvents> for ::windows::core::IUnknown {
    fn from(value: IRowsetEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetEvents> for ::windows::core::IUnknown {
    fn from(value: &IRowsetEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetEvents {}
impl ::core::fmt::Debug for IRowsetEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetEvents {
    type Vtable = IRowsetEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1551aea5_5d66_4b11_86f5_d5634cb211b9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetEvents_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnNewItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnNewItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnChangedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnChangedItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnDeletedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnDeletedItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnRowsetEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventtype: ROWSETEVENT_TYPE, eventdata: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnRowsetEvent: usize,
}
#[repr(C)]
pub struct IRowsetExactScroll(pub u8);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetFastLoad(::windows::core::IUnknown);
impl IRowsetFastLoad {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn InsertRow(&self, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InsertRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Commit<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdone: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Commit)(::core::mem::transmute_copy(self), fdone.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowsetFastLoad> for ::windows::core::IUnknown {
    fn from(value: IRowsetFastLoad) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetFastLoad> for ::windows::core::IUnknown {
    fn from(value: &IRowsetFastLoad) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetFastLoad {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetFastLoad {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetFastLoad {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFastLoad {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFastLoad {}
impl ::core::fmt::Debug for IRowsetFastLoad {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFastLoad").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetFastLoad {
    type Vtable = IRowsetFastLoad_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca13_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFastLoad_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub InsertRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Commit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdone: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Commit: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetFind(::windows::core::IUnknown);
impl IRowsetFind {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn FindNextRow(&self, hchapter: usize, haccessor: usize, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FindNextRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(haccessor), ::core::mem::transmute(pfindvalue), ::core::mem::transmute(compareop), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
impl ::core::convert::From<IRowsetFind> for ::windows::core::IUnknown {
    fn from(value: IRowsetFind) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetFind> for ::windows::core::IUnknown {
    fn from(value: &IRowsetFind) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFind {}
impl ::core::fmt::Debug for IRowsetFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetFind {
    type Vtable = IRowsetFind_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFind_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub FindNextRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, haccessor: usize, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetIdentity(::windows::core::IUnknown);
impl IRowsetIdentity {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn IsSameRow(&self, hthisrow: usize, hthatrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsSameRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(hthisrow), ::core::mem::transmute(hthatrow)).ok()
    }
}
impl ::core::convert::From<IRowsetIdentity> for ::windows::core::IUnknown {
    fn from(value: IRowsetIdentity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetIdentity> for ::windows::core::IUnknown {
    fn from(value: &IRowsetIdentity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetIdentity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetIdentity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetIdentity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIdentity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIdentity {}
impl ::core::fmt::Debug for IRowsetIdentity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIdentity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetIdentity {
    type Vtable = IRowsetIdentity_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a09_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIdentity_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub IsSameRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hthisrow: usize, hthatrow: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetIndex(::windows::core::IUnknown);
impl IRowsetIndex {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIndexInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Seek(&self, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Seek)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ckeyvalues), ::core::mem::transmute(pdata), ::core::mem::transmute(dwseekoptions)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetRange(&self, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRange)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(cstartkeycolumns), ::core::mem::transmute(pstartdata), ::core::mem::transmute(cendkeycolumns), ::core::mem::transmute(penddata), ::core::mem::transmute(dwrangeoptions)).ok()
    }
}
impl ::core::convert::From<IRowsetIndex> for ::windows::core::IUnknown {
    fn from(value: IRowsetIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetIndex> for ::windows::core::IUnknown {
    fn from(value: &IRowsetIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIndex {}
impl ::core::fmt::Debug for IRowsetIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetIndex {
    type Vtable = IRowsetIndex_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a82_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIndex_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetIndexInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetIndexInfo: usize,
    pub Seek: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::HRESULT,
    pub SetRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetInfo(::windows::core::IUnknown);
impl IRowsetInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: &[DBPROPIDSET], pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetProperties)(::core::mem::transmute_copy(self), rgpropertyidsets.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgpropertyidsets)), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetReferencedRowset(&self, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetReferencedRowset)(::core::mem::transmute_copy(self), ::core::mem::transmute(iordinal), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSpecification)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRowsetInfo> for ::windows::core::IUnknown {
    fn from(value: IRowsetInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetInfo> for ::windows::core::IUnknown {
    fn from(value: &IRowsetInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetInfo {}
impl ::core::fmt::Debug for IRowsetInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetInfo {
    type Vtable = IRowsetInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a55_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    pub GetReferencedRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, ppreferencedrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetKeys(::windows::core::IUnknown);
impl IRowsetKeys {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ListKeys(&self, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ListKeys)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumns)).ok()
    }
}
impl ::core::convert::From<IRowsetKeys> for ::windows::core::IUnknown {
    fn from(value: IRowsetKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetKeys> for ::windows::core::IUnknown {
    fn from(value: &IRowsetKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetKeys {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetKeys {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetKeys {}
impl ::core::fmt::Debug for IRowsetKeys {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetKeys").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetKeys {
    type Vtable = IRowsetKeys_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a12_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetKeys_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ListKeys: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetLocate(::windows::core::IUnknown);
impl IRowsetLocate {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.AddRefRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetNextRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ReleaseRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RestartPosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Compare)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark1), ::core::mem::transmute(pbookmark1), ::core::mem::transmute(cbbookmark2), ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowsAt)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowsByBookmark)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Hash)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbookmarks), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetLocate> for ::windows::core::IUnknown {
    fn from(value: IRowsetLocate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetLocate> for ::windows::core::IUnknown {
    fn from(value: &IRowsetLocate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetLocate> for IRowset {
    fn from(value: IRowsetLocate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetLocate> for IRowset {
    fn from(value: &IRowsetLocate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for &'a IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetLocate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetLocate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetLocate {}
impl ::core::fmt::Debug for IRowsetLocate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetLocate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetLocate {
    type Vtable = IRowsetLocate_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetLocate_Vtbl {
    pub base__: IRowset_Vtbl,
    pub Compare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::HRESULT,
    pub GetRowsAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub GetRowsByBookmark: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub Hash: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNewRowAfter(::windows::core::IUnknown);
impl IRowsetNewRowAfter {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetNewDataAfter(&self, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: usize, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNewDataAfter)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbmprevious), ::core::mem::transmute(pbmprevious), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
impl ::core::convert::From<IRowsetNewRowAfter> for ::windows::core::IUnknown {
    fn from(value: IRowsetNewRowAfter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNewRowAfter> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNewRowAfter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNewRowAfter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetNewRowAfter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNewRowAfter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNewRowAfter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNewRowAfter {}
impl ::core::fmt::Debug for IRowsetNewRowAfter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNewRowAfter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNewRowAfter {
    type Vtable = IRowsetNewRowAfter_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a71_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNewRowAfter_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetNewDataAfter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: usize, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNextRowset(::windows::core::IUnknown);
impl IRowsetNextRowset {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetNextRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetNextRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRowsetNextRowset> for ::windows::core::IUnknown {
    fn from(value: IRowsetNextRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNextRowset> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNextRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNextRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetNextRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNextRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNextRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNextRowset {}
impl ::core::fmt::Debug for IRowsetNextRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNextRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNextRowset {
    type Vtable = IRowsetNextRowset_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a72_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNextRowset_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetNextRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppnextrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNotify(::windows::core::IUnknown);
impl IRowsetNotify {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFieldChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param6: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, hrow: usize, rgcolumns: &[usize], ereason: u32, ephase: u32, fcantdeny: Param6) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnFieldChange)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(hrow), rgcolumns.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgcolumns)), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, rghrows: &[usize], ereason: u32, ephase: u32, fcantdeny: Param5) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnRowChange)(::core::mem::transmute_copy(self), prowset.into_param().abi(), rghrows.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rghrows)), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowsetChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, ereason: u32, ephase: u32, fcantdeny: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnRowsetChange)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowsetNotify> for ::windows::core::IUnknown {
    fn from(value: IRowsetNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNotify> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNotify {}
impl ::core::fmt::Debug for IRowsetNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNotify {
    type Vtable = IRowsetNotify_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a83_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNotify_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnFieldChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, hrow: usize, ccolumns: usize, rgcolumns: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnFieldChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, crows: usize, rghrows: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowsetChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowsetChange: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetPrioritization(::windows::core::IUnknown);
impl IRowsetPrioritization {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetScopePriority(&self, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetScopePriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(priority), ::core::mem::transmute(scopestatisticseventfrequency)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetScopePriority(&self, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetScopePriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(priority), ::core::mem::transmute(scopestatisticseventfrequency)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetScopeStatistics(&self, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetScopeStatistics)(::core::mem::transmute_copy(self), ::core::mem::transmute(indexeddocumentcount), ::core::mem::transmute(oustandingaddcount), ::core::mem::transmute(oustandingmodifycount)).ok()
    }
}
impl ::core::convert::From<IRowsetPrioritization> for ::windows::core::IUnknown {
    fn from(value: IRowsetPrioritization) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetPrioritization> for ::windows::core::IUnknown {
    fn from(value: &IRowsetPrioritization) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetPrioritization {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetPrioritization {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetPrioritization {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetPrioritization {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetPrioritization {}
impl ::core::fmt::Debug for IRowsetPrioritization {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetPrioritization").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetPrioritization {
    type Vtable = IRowsetPrioritization_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x42811652_079d_481b_87a2_09a69ecc5f44);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetPrioritization_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetScopePriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::HRESULT,
    pub GetScopePriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::HRESULT,
    pub GetScopeStatistics: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetQueryStatus(::windows::core::IUnknown);
impl IRowsetQueryStatus {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetStatus(&self, pdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetStatusEx(&self, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatusEx)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwstatus), ::core::mem::transmute(pcfiltereddocuments), ::core::mem::transmute(pcdocumentstofilter), ::core::mem::transmute(pdwratiofinisheddenominator), ::core::mem::transmute(pdwratiofinishednumerator), ::core::mem::transmute(cbbmk), ::core::mem::transmute(pbmk), ::core::mem::transmute(pirowbmk), ::core::mem::transmute(pcrowstotal)).ok()
    }
}
impl ::core::convert::From<IRowsetQueryStatus> for ::windows::core::IUnknown {
    fn from(value: IRowsetQueryStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetQueryStatus> for ::windows::core::IUnknown {
    fn from(value: &IRowsetQueryStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetQueryStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetQueryStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetQueryStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetQueryStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetQueryStatus {}
impl ::core::fmt::Debug for IRowsetQueryStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetQueryStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetQueryStatus {
    type Vtable = IRowsetQueryStatus_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ac77ed_f8d7_11ce_a798_0020f8008024);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetQueryStatus_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32) -> ::windows::core::HRESULT,
    pub GetStatusEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetRefresh(::windows::core::IUnknown);
impl IRowsetRefresh {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RefreshVisibleData<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: Param3, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RefreshVisibleData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), foverwrite.into_param().abi(), ::core::mem::transmute(pcrowsrefreshed), ::core::mem::transmute(prghrowsrefreshed), ::core::mem::transmute(prgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetLastVisibleData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLastVisibleData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
}
impl ::core::convert::From<IRowsetRefresh> for ::windows::core::IUnknown {
    fn from(value: IRowsetRefresh) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetRefresh> for ::windows::core::IUnknown {
    fn from(value: &IRowsetRefresh) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetRefresh {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetRefresh {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetRefresh {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetRefresh {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetRefresh {}
impl ::core::fmt::Debug for IRowsetRefresh {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetRefresh").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetRefresh {
    type Vtable = IRowsetRefresh_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetRefresh_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub RefreshVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: super::super::Foundation::BOOL, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RefreshVisibleData: usize,
    pub GetLastVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetResynch(::windows::core::IUnknown);
impl IRowsetResynch {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetVisibleData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetVisibleData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ResynchRows(&self, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResynchRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsresynched), ::core::mem::transmute(prghrowsresynched), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetResynch> for ::windows::core::IUnknown {
    fn from(value: IRowsetResynch) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetResynch> for ::windows::core::IUnknown {
    fn from(value: &IRowsetResynch) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetResynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetResynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetResynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetResynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetResynch {}
impl ::core::fmt::Debug for IRowsetResynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetResynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetResynch {
    type Vtable = IRowsetResynch_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a84_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetResynch_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ResynchRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetScroll(::windows::core::IUnknown);
impl IRowsetScroll {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.AddRefRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetNextRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.ReleaseRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.RestartPosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Compare)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark1), ::core::mem::transmute(pbookmark1), ::core::mem::transmute(cbbookmark2), ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetRowsAt)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetRowsByBookmark)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Hash)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbookmarks), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetApproximatePosition(&self, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetApproximatePosition)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(pulposition), ::core::mem::transmute(pcrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowsAtRatio(&self, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowsAtRatio)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(ulnumerator), ::core::mem::transmute(uldenominator), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
impl ::core::convert::From<IRowsetScroll> for ::windows::core::IUnknown {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for ::windows::core::IUnknown {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetScroll> for IRowset {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for IRowset {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for &'a IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetScroll> for IRowsetLocate {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for IRowsetLocate {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetLocate> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetLocate> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetLocate> for &'a IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetLocate> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetScroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetScroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetScroll {}
impl ::core::fmt::Debug for IRowsetScroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetScroll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetScroll {
    type Vtable = IRowsetScroll_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetScroll_Vtbl {
    pub base__: IRowsetLocate_Vtbl,
    pub GetApproximatePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::HRESULT,
    pub GetRowsAtRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetUpdate(::windows::core::IUnknown);
impl IRowsetUpdate {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.DeleteRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn InsertRow(&self, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.InsertRow)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetOriginalData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOriginalData)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetPendingRows(&self, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPendingRows)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(dwrowstatus), ::core::mem::transmute(pcpendingrows), ::core::mem::transmute(prgpendingrows), ::core::mem::transmute(prgpendingstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetRowStatus(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRowStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgpendingstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Undo(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Undo)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsundone), ::core::mem::transmute(prgrowsundone), ::core::mem::transmute(prgrowstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Update(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Update)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrows), ::core::mem::transmute(prgrows), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetUpdate> for ::windows::core::IUnknown {
    fn from(value: IRowsetUpdate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetUpdate> for ::windows::core::IUnknown {
    fn from(value: &IRowsetUpdate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetUpdate> for IRowsetChange {
    fn from(value: IRowsetUpdate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetUpdate> for IRowsetChange {
    fn from(value: &IRowsetUpdate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetChange> for IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetChange> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetChange> for &'a IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetChange> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetUpdate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetUpdate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetUpdate {}
impl ::core::fmt::Debug for IRowsetUpdate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetUpdate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetUpdate {
    type Vtable = IRowsetUpdate_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetUpdate_Vtbl {
    pub base__: IRowsetChange_Vtbl,
    pub GetOriginalData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetPendingRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub GetRowStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::HRESULT,
    pub Undo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub Update: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetView(::windows::core::IUnknown);
impl IRowsetView {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateView<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateView)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetView(&self, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetView)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(riid), ::core::mem::transmute(phchaptersource), ::core::mem::transmute(ppview)).ok()
    }
}
impl ::core::convert::From<IRowsetView> for ::windows::core::IUnknown {
    fn from(value: IRowsetView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetView> for ::windows::core::IUnknown {
    fn from(value: &IRowsetView) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetView {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetView {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetView {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetView {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetView {}
impl ::core::fmt::Debug for IRowsetView {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetView").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetView {
    type Vtable = IRowsetView_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a99_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetView_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CreateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchAll(::windows::core::IUnknown);
impl IRowsetWatchAll {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Acknowledge)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Start)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StopWatching)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchAll> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchAll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchAll> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchAll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchAll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetWatchAll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchAll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchAll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchAll {}
impl ::core::fmt::Debug for IRowsetWatchAll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchAll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchAll {
    type Vtable = IRowsetWatchAll_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a73_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchAll_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Acknowledge: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub StopWatching: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchNotify(::windows::core::IUnknown);
impl IRowsetWatchNotify {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn OnChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>>(&self, prowset: Param0, echangereason: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnChange)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(echangereason)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchNotify> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchNotify> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetWatchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchNotify {}
impl ::core::fmt::Debug for IRowsetWatchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchNotify {
    type Vtable = IRowsetWatchNotify_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a44_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchNotify_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub OnChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, echangereason: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchRegion(::windows::core::IUnknown);
impl IRowsetWatchRegion {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Acknowledge)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Start)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.StopWatching)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn CreateWatchRegion(&self, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateWatchRegion)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwwatchmode), ::core::mem::transmute(phregion)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ChangeWatchMode(&self, hregion: usize, dwwatchmode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ChangeWatchMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(dwwatchmode)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DeleteWatchRegion(&self, hregion: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteWatchRegion)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetWatchRegionInfo(&self, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetWatchRegionInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(pdwwatchmode), ::core::mem::transmute(phchapter), ::core::mem::transmute(pcbbookmark), ::core::mem::transmute(ppbookmark), ::core::mem::transmute(pcrows)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Refresh(&self, pcchangesobtained: *mut usize, prgchanges: *mut *mut tagDBROWWATCHRANGE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcchangesobtained), ::core::mem::transmute(prgchanges)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ShrinkWatchRegion(&self, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ShrinkWatchRegion)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(crows)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchRegion> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchRegion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchRegion> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchRegion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetWatchRegion> for IRowsetWatchAll {
    fn from(value: IRowsetWatchRegion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchRegion> for IRowsetWatchAll {
    fn from(value: &IRowsetWatchRegion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetWatchAll> for IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetWatchAll> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetWatchAll> for &'a IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetWatchAll> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchRegion {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchRegion {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchRegion {}
impl ::core::fmt::Debug for IRowsetWatchRegion {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchRegion").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchRegion {
    type Vtable = IRowsetWatchRegion_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a45_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchRegion_Vtbl {
    pub base__: IRowsetWatchAll_Vtbl,
    pub CreateWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::HRESULT,
    pub ChangeWatchMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, dwwatchmode: u32) -> ::windows::core::HRESULT,
    pub DeleteWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize) -> ::windows::core::HRESULT,
    pub GetWatchRegionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcchangesobtained: *mut usize, prgchanges: *mut *mut tagDBROWWATCHRANGE) -> ::windows::core::HRESULT,
    pub ShrinkWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWithParameters(::windows::core::IUnknown);
impl IRowsetWithParameters {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetParameterInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo), ::core::mem::transmute(ppnamesbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Requery(&self, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Requery)(::core::mem::transmute_copy(self), ::core::mem::transmute(pparams), ::core::mem::transmute(pulerrorparam), ::core::mem::transmute(phreserved)).ok()
    }
}
impl ::core::convert::From<IRowsetWithParameters> for ::windows::core::IUnknown {
    fn from(value: IRowsetWithParameters) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWithParameters> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWithParameters) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IRowsetWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWithParameters {}
impl ::core::fmt::Debug for IRowsetWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWithParameters {
    type Vtable = IRowsetWithParameters_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWithParameters_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetParameterInfo: usize,
    pub Requery: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLErrorInfo(::windows::core::IUnknown);
impl ISQLErrorInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSQLInfo(&self, pbstrsqlstate: *mut super::super::Foundation::BSTR, plnativeerror: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSQLInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrsqlstate), ::core::mem::transmute(plnativeerror)).ok()
    }
}
impl ::core::convert::From<ISQLErrorInfo> for ::windows::core::IUnknown {
    fn from(value: ISQLErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLErrorInfo> for ::windows::core::IUnknown {
    fn from(value: &ISQLErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISQLErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLErrorInfo {}
impl ::core::fmt::Debug for ISQLErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLErrorInfo {
    type Vtable = ISQLErrorInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a74_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLErrorInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetSQLInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsqlstate: *mut super::super::Foundation::BSTR, plnativeerror: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetSQLInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLGetDiagField(::windows::core::IUnknown);
impl ISQLGetDiagField {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDiagField(&self, pdiaginfo: *mut KAGGETDIAG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDiagField)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdiaginfo)).ok()
    }
}
impl ::core::convert::From<ISQLGetDiagField> for ::windows::core::IUnknown {
    fn from(value: ISQLGetDiagField) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLGetDiagField> for ::windows::core::IUnknown {
    fn from(value: &ISQLGetDiagField) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLGetDiagField {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISQLGetDiagField {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLGetDiagField {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLGetDiagField {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLGetDiagField {}
impl ::core::fmt::Debug for ISQLGetDiagField {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLGetDiagField").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLGetDiagField {
    type Vtable = ISQLGetDiagField_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f1_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLGetDiagField_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetDiagField: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdiaginfo: *mut KAGGETDIAG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetDiagField: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLRequestDiagFields(::windows::core::IUnknown);
impl ISQLRequestDiagFields {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RequestDiagFields(&self, rgdiagfields: &[KAGREQDIAG]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RequestDiagFields)(::core::mem::transmute_copy(self), rgdiagfields.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(rgdiagfields))).ok()
    }
}
impl ::core::convert::From<ISQLRequestDiagFields> for ::windows::core::IUnknown {
    fn from(value: ISQLRequestDiagFields) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLRequestDiagFields> for ::windows::core::IUnknown {
    fn from(value: &ISQLRequestDiagFields) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLRequestDiagFields {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISQLRequestDiagFields {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLRequestDiagFields {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLRequestDiagFields {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLRequestDiagFields {}
impl ::core::fmt::Debug for ISQLRequestDiagFields {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLRequestDiagFields").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLRequestDiagFields {
    type Vtable = ISQLRequestDiagFields_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f0_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLRequestDiagFields_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub RequestDiagFields: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cdiagfields: u32, rgdiagfields: *const KAGREQDIAG) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLServerErrorInfo(::windows::core::IUnknown);
impl ISQLServerErrorInfo {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetErrorInfo(&self, pperrorinfo: *mut *mut tagSSErrorInfo, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetErrorInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pperrorinfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
}
impl ::core::convert::From<ISQLServerErrorInfo> for ::windows::core::IUnknown {
    fn from(value: ISQLServerErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLServerErrorInfo> for ::windows::core::IUnknown {
    fn from(value: &ISQLServerErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLServerErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISQLServerErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLServerErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLServerErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLServerErrorInfo {}
impl ::core::fmt::Debug for ISQLServerErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLServerErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLServerErrorInfo {
    type Vtable = ISQLServerErrorInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca12_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLServerErrorInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pperrorinfo: *mut *mut tagSSErrorInfo, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaLocalizerSupport(::windows::core::IUnknown);
impl ISchemaLocalizerSupport {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Localize<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszglobalstring: Param0) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Localize)(::core::mem::transmute_copy(self), pszglobalstring.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<ISchemaLocalizerSupport> for ::windows::core::IUnknown {
    fn from(value: ISchemaLocalizerSupport) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaLocalizerSupport> for ::windows::core::IUnknown {
    fn from(value: &ISchemaLocalizerSupport) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaLocalizerSupport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISchemaLocalizerSupport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaLocalizerSupport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLocalizerSupport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLocalizerSupport {}
impl ::core::fmt::Debug for ISchemaLocalizerSupport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLocalizerSupport").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaLocalizerSupport {
    type Vtable = ISchemaLocalizerSupport_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xca3fdca2_bfbe_4eed_90d7_0caef0a1bda1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLocalizerSupport_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Localize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszglobalstring: ::windows::core::PCWSTR, ppszlocalstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaLock(::windows::core::IUnknown);
impl ISchemaLock {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetSchemaLock(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSchemaLock)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(lmmode), ::core::mem::transmute(phlockhandle), ::core::mem::transmute(ptableversion)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReleaseSchemaLock<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hlockhandle: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseSchemaLock)(::core::mem::transmute_copy(self), hlockhandle.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ISchemaLock> for ::windows::core::IUnknown {
    fn from(value: ISchemaLock) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaLock> for ::windows::core::IUnknown {
    fn from(value: &ISchemaLock) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaLock {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISchemaLock {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaLock {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLock {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLock {}
impl ::core::fmt::Debug for ISchemaLock {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLock").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaLock {
    type Vtable = ISchemaLock_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c2389fb_2511_11d4_b258_00c04f7971ce);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLock_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub GetSchemaLock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    GetSchemaLock: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ReleaseSchemaLock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hlockhandle: super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReleaseSchemaLock: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaProvider(::windows::core::IUnknown);
impl ISchemaProvider {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Entities<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).Entities)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RootEntity(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).RootEntity)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetEntity<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszentityname: Param0) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetEntity)(::core::mem::transmute_copy(self), pszentityname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).MetaData)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Localize<'a, Param1: ::windows::core::IntoParam<'a, ISchemaLocalizerSupport>>(&self, lcid: u32, pschemalocalizersupport: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Localize)(::core::mem::transmute_copy(self), ::core::mem::transmute(lcid), pschemalocalizersupport.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SaveBinary<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszschemabinarypath: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveBinary)(::core::mem::transmute_copy(self), pszschemabinarypath.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn LookupAuthoredNamedEntity<'a, Param0: ::windows::core::IntoParam<'a, IEntity>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ITokenCollection>>(&self, pentity: Param0, pszinputstring: Param1, ptokencollection: Param2, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LookupAuthoredNamedEntity)(::core::mem::transmute_copy(self), pentity.into_param().abi(), pszinputstring.into_param().abi(), ptokencollection.into_param().abi(), ::core::mem::transmute(ctokensbegin), ::core::mem::transmute(pctokenslength), ::core::mem::transmute(ppszvalue)).ok()
    }
}
impl ::core::convert::From<ISchemaProvider> for ::windows::core::IUnknown {
    fn from(value: ISchemaProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaProvider> for ::windows::core::IUnknown {
    fn from(value: &ISchemaProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISchemaProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaProvider {}
impl ::core::fmt::Debug for ISchemaProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaProvider {
    type Vtable = ISchemaProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8cf89bcb_394c_49b2_ae28_a59dd4ed7f68);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaProvider_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Entities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RootEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prootentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub GetEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszentityname: ::windows::core::PCWSTR, pentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Localize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32, pschemalocalizersupport: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub SaveBinary: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszschemabinarypath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub LookupAuthoredNamedEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pentity: ::windows::core::RawPtr, pszinputstring: ::windows::core::PCWSTR, ptokencollection: ::windows::core::RawPtr, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IScopedOperations(::windows::core::IUnknown);
impl IScopedOperations {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Bind<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Bind)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Copy<'a, Param4: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwcopyflags: u32, pauthenticate: Param4, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Copy)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszsourceurls), ::core::mem::transmute(rgpwszdesturls), ::core::mem::transmute(dwcopyflags), pauthenticate.into_param().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Move<'a, Param4: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwmoveflags: u32, pauthenticate: Param4, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Move)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszsourceurls), ::core::mem::transmute(rgpwszdesturls), ::core::mem::transmute(dwmoveflags), pauthenticate.into_param().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Delete(&self, crows: usize, rgpwszurls: *const ::windows::core::PWSTR, dwdeleteflags: u32, rgdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszurls), ::core::mem::transmute(dwdeleteflags), ::core::mem::transmute(rgdwstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, rgpropertysets: &mut [DBPROPSET], pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OpenRowset)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(riid), rgpropertysets.len() as _, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgpropertysets)), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IScopedOperations> for ::windows::core::IUnknown {
    fn from(value: IScopedOperations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IScopedOperations> for ::windows::core::IUnknown {
    fn from(value: &IScopedOperations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IScopedOperations> for IBindResource {
    fn from(value: IScopedOperations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IScopedOperations> for IBindResource {
    fn from(value: &IScopedOperations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBindResource> for IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, IBindResource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBindResource> for &'a IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, IBindResource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IScopedOperations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IScopedOperations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IScopedOperations {}
impl ::core::fmt::Debug for IScopedOperations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IScopedOperations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IScopedOperations {
    type Vtable = IScopedOperations_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScopedOperations_Vtbl {
    pub base__: IBindResource_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Copy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwcopyflags: u32, pauthenticate: ::windows::core::RawPtr, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Copy: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Move: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwmoveflags: u32, pauthenticate: ::windows::core::RawPtr, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Move: usize,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszurls: *const ::windows::core::PWSTR, dwdeleteflags: u32, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OpenRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OpenRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCatalogManager(::windows::core::IUnknown);
impl ISearchCatalogManager {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: *mut super::Com::StructuredStorage::PROPVARIANT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetParameter)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszname: Param0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetParameter)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(pvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCatalogStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reindex)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReindexMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszpattern: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReindexMatchingURLs)(::core::mem::transmute_copy(self), pszpattern.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReindexSearchRoot<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszrooturl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReindexSearchRoot)(::core::mem::transmute_copy(self), pszrooturl.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetConnectTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwconnecttimeout)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ConnectTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDataTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdatatimeout)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DataTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NumberOfItems)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).NumberOfItemsToIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).URLBeingIndexed)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetURLIndexingState<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetURLIndexingState)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetPersistentItemsChangedSink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RegisterViewForNotification<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, ISearchViewChangedSink>>(&self, pszview: Param0, pviewchangedsink: Param1) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).RegisterViewForNotification)(::core::mem::transmute_copy(self), pszview.into_param().abi(), pviewchangedsink.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetItemsChangedSink<'a, Param0: ::windows::core::IntoParam<'a, ISearchNotifyInlineSite>>(&self, pisearchnotifyinlinesite: Param0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetItemsChangedSink)(::core::mem::transmute_copy(self), pisearchnotifyinlinesite.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnregisterViewForNotification)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszextension: Param0, fexclude: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetExtensionClusion)(::core::mem::transmute_copy(self), pszextension.into_param().abi(), fexclude.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).EnumerateExcludedExtensions)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IEnumString>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetQueryHelper)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdiacriticsensitive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDiacriticSensitivity)(::core::mem::transmute_copy(self), fdiacriticsensitive.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DiacriticSensitivity)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCrawlScopeManager)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchCrawlScopeManager>(result__)
    }
}
impl ::core::convert::From<ISearchCatalogManager> for ::windows::core::IUnknown {
    fn from(value: ISearchCatalogManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager> for ::windows::core::IUnknown {
    fn from(value: &ISearchCatalogManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISearchCatalogManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISearchCatalogManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISearchCatalogManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager {}
impl ::core::fmt::Debug for ISearchCatalogManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager {
    type Vtable = ISearchCatalogManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef50);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManager_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, ppvalue: *mut *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetParameter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetParameter: usize,
    pub GetCatalogStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Reindex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ReindexMatchingURLs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ReindexSearchRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrooturl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetConnectTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwconnecttimeout: u32) -> ::windows::core::HRESULT,
    pub ConnectTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwconnecttimeout: *mut u32) -> ::windows::core::HRESULT,
    pub SetDataTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdatatimeout: u32) -> ::windows::core::HRESULT,
    pub DataTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdatatimeout: *mut u32) -> ::windows::core::HRESULT,
    pub NumberOfItems: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub NumberOfItemsToIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::HRESULT,
    pub URLBeingIndexed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetURLIndexingState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pdwstate: *mut u32) -> ::windows::core::HRESULT,
    pub GetPersistentItemsChangedSink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppisearchpersistentitemschangedsink: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub RegisterViewForNotification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszview: ::windows::core::PCWSTR, pviewchangedsink: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub GetItemsChangedSink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisearchnotifyinlinesite: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::HRESULT,
    pub UnregisterViewForNotification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetExtensionClusion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszextension: ::windows::core::PCWSTR, fexclude: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetExtensionClusion: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumerateExcludedExtensions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppextensions: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumerateExcludedExtensions: usize,
    pub GetQueryHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchqueryhelper: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdiacriticsensitive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiacriticSensitivity: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfdiacriticsensitive: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DiacriticSensitivity: usize,
    pub GetCrawlScopeManager: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcrawlscopemanager: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCatalogManager2(::windows::core::IUnknown);
impl ISearchCatalogManager2 {
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: *mut super::Com::StructuredStorage::PROPVARIANT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetParameter)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszname: Param0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetParameter)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(pvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCatalogStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reindex)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReindexMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszpattern: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ReindexMatchingURLs)(::core::mem::transmute_copy(self), pszpattern.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ReindexSearchRoot<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszrooturl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ReindexSearchRoot)(::core::mem::transmute_copy(self), pszrooturl.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetConnectTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwconnecttimeout)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.ConnectTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDataTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdatatimeout)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.DataTimeout)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.NumberOfItems)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.NumberOfItemsToIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__: ::windows::core::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.URLBeingIndexed)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetURLIndexingState<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetURLIndexingState)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetPersistentItemsChangedSink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn RegisterViewForNotification<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, ISearchViewChangedSink>>(&self, pszview: Param0, pviewchangedsink: Param1) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.RegisterViewForNotification)(::core::mem::transmute_copy(self), pszview.into_param().abi(), pviewchangedsink.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetItemsChangedSink<'a, Param0: ::windows::core::IntoParam<'a, ISearchNotifyInlineSite>>(&self, pisearchnotifyinlinesite: Param0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetItemsChangedSink)(::core::mem::transmute_copy(self), pisearchnotifyinlinesite.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UnregisterViewForNotification)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszextension: Param0, fexclude: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetExtensionClusion)(::core::mem::transmute_copy(self), pszextension.into_param().abi(), fexclude.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnumerateExcludedExtensions)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IEnumString>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetQueryHelper)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdiacriticsensitive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDiacriticSensitivity)(::core::mem::transmute_copy(self), fdiacriticsensitive.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.DiacriticSensitivity)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCrawlScopeManager)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchCrawlScopeManager>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn PrioritizeMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(&self, pszpattern: Param0, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PrioritizeMatchingURLs)(::core::mem::transmute_copy(self), pszpattern.into_param().abi(), ::core::mem::transmute(dwprioritizeflags)).ok()
    }
}
impl ::core::convert::From<ISearchCatalogManager2> for ::windows::core::IUnknown {
    fn from(value: ISearchCatalogManager2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager2> for ::windows::core::IUnknown {
    fn from(value: &ISearchCatalogManager2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ISearchCatalogManager2> for ISearchCatalogManager {
    fn from(value: ISearchCatalogManager2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager2> for ISearchCatalogManager {
    fn from(value: &ISearchCatalogManager2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ISearchCatalogManager> for ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ISearchCatalogManager> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ISearchCatalogManager> for &'a ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ISearchCatalogManager> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISearchCatalogManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager2 {}
impl ::core::fmt::Debug for ISearchCatalogManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager2 {
    type Vtable = ISearchCatalogManager2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ac3286d_4d1d_4817_84fc_c1c85e3af0d9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManager2_Vtbl {
    pub base__: ISearchCatalogManager_Vtbl,
    pub PrioritizeMatchingURLs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: ::windows::core::PCWSTR, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCrawlScopeManager(::windows::core::IUnknown);
impl ISearchCrawlScopeManager {
    #[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDefaultScopeRule<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszurl: Param0, finclude: Param1, ffollowflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddDefaultScopeRule)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), finclude.into_param().abi(), ::core::mem::transmute(ffollowflags)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Search\"`*"]
    pub unsafe fn AddRoot<'a, Param0: ::windows::core::IntoPa