#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Win32_System_Search_Common")]
pub mod Common;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type ACCESS_MASKENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_EXCLUSIVE: ACCESS_MASKENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_READDESIGN: ACCESS_MASKENUM = 1024i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_WRITEDESIGN: ACCESS_MASKENUM = 2048i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_WITHGRANT: ACCESS_MASKENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_REFERENCE: ACCESS_MASKENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_CREATE: ACCESS_MASKENUM = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_INSERT: ACCESS_MASKENUM = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_DELETE: ACCESS_MASKENUM = 65536i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_READCONTROL: ACCESS_MASKENUM = 131072i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_WRITEPERMISSIONS: ACCESS_MASKENUM = 262144i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_WRITEOWNER: ACCESS_MASKENUM = 524288i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_MAXIMUM_ALLOWED: ACCESS_MASKENUM = 33554432i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_ALL: ACCESS_MASKENUM = 268435456i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_EXECUTE: ACCESS_MASKENUM = 536870912i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_READ: ACCESS_MASKENUM = -2147483648i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_UPDATE: ACCESS_MASKENUM = 1073741824i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const PERM_DROP: ACCESS_MASKENUM = 256i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTHENTICATION_INFO {
    pub dwSize: u32,
    pub atAuthenticationType: AUTH_TYPE,
    pub pcwszUser: super::super::Foundation::PWSTR,
    pub pcwszPassword: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AUTHENTICATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AUTHENTICATION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AUTHENTICATION_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUTHENTICATION_INFO").field("dwSize", &self.dwSize).field("atAuthenticationType", &self.atAuthenticationType).field("pcwszUser", &self.pcwszUser).field("pcwszPassword", &self.pcwszPassword).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AUTHENTICATION_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AUTHENTICATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AUTHENTICATION_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AUTHENTICATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AUTHENTICATION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type AUTH_TYPE = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const eAUTH_TYPE_ANONYMOUS: AUTH_TYPE = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const eAUTH_TYPE_NTLM: AUTH_TYPE = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const eAUTH_TYPE_BASIC: AUTH_TYPE = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP6xFILEFMT: u32 = 9u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPABORT: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPBATCH: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFILECP: u32 = 12u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFILECP_ACP: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFILECP_OEMCP: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFILECP_RAW: i32 = -1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFILEFMT: u32 = 15u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPFIRST: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPHINTS: u32 = 11u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPHINTSA: u32 = 10u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPHINTSW: u32 = 11u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPKEEPIDENTITY: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPKEEPNULLS: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPLAST: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPMAXERRS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPODBC: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPTEXTFILE: u32 = 14u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCPUNICODEFILE: u32 = 13u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_COLLATION: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_COLLATION_ID: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_DATA_LEN: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_INDICATOR_LEN: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_SERVER_COL: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_TERMINATOR: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BCP_FMT_TYPE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BMK_DURABILITY_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BMK_DURABILITY_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BMK_DURABILITY_ROWSET: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BMK_DURABILITY_XTRANSACTION: i32 = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct BUCKETCATEGORIZE {
    pub cBuckets: u32,
    pub Distribution: u32,
}
impl ::core::marker::Copy for BUCKETCATEGORIZE {}
impl ::core::clone::Clone for BUCKETCATEGORIZE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BUCKETCATEGORIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BUCKETCATEGORIZE").field("cBuckets", &self.cBuckets).field("Distribution", &self.Distribution).finish()
    }
}
unsafe impl ::windows::core::Abi for BUCKETCATEGORIZE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BUCKETCATEGORIZE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BUCKETCATEGORIZE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BUCKETCATEGORIZE {}
impl ::core::default::Default for BUCKETCATEGORIZE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BUCKET_EXPONENTIAL: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BUCKET_LINEAR: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CASE_REQUIREMENT = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CASE_REQUIREMENT_ANY: CASE_REQUIREMENT = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CASE_REQUIREMENT_UPPER_IF_AQS: CASE_REQUIREMENT = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CATEGORIZATION {
    pub ulCatType: u32,
    pub Anonymous: CATEGORIZATION_0,
    pub csColumns: COLUMNSET,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATION {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATION>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
pub union CATEGORIZATION_0 {
    pub cClusters: u32,
    pub bucket: BUCKETCATEGORIZE,
    pub range: RANGECATEGORIZE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATION_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATION_0 {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATION_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATION_0>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATION_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CATEGORIZATIONSET {
    pub cCat: u32,
    pub aCat: *mut CATEGORIZATION,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CATEGORIZATIONSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CATEGORIZATIONSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::fmt::Debug for CATEGORIZATIONSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CATEGORIZATIONSET").field("cCat", &self.cCat).field("aCat", &self.aCat).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CATEGORIZATIONSET {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CATEGORIZATIONSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORIZATIONSET>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CATEGORIZATIONSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CATEGORIZATIONSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORIZE_BUCKETS: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORIZE_CLUSTER: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORIZE_RANGE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORIZE_UNIQUE: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORY_COLLATOR: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORY_GATHERER: i32 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORY_INDEXER: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATEGORY_SEARCH: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CDBBMKDISPIDS: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CDBCOLDISPIDS: u32 = 28u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CDBSELFDISPIDS: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CERT_E_NOT_FOUND_OR_NO_PERMISSSION: i32 = -2147211263i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CHANNEL_AGENT_FLAGS = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CHANNEL_AGENT_DYNAMIC_SCHEDULE: CHANNEL_AGENT_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CHANNEL_AGENT_PRECACHE_SOME: CHANNEL_AGENT_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CHANNEL_AGENT_PRECACHE_ALL: CHANNEL_AGENT_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CHANNEL_AGENT_PRECACHE_SCRNSAVER: CHANNEL_AGENT_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_CORRUPT_FWIDX: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473491i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_DIACRITIC_SETTINGS_DIFFER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473490i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_INCONSISTENT_TRANSACTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473486i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_INVALID_CATALOG_LIST_VERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215313i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_MULTIPLE_PROTECTED_USERS_UNSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473483i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_NO_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215318i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_NO_CATALOG_MANAGER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473487i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_NO_PROTECTED_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473484i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_PROTECTED_CATALOG_NON_INTERACTIVE_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473481i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_PROTECTED_CATALOG_NOT_AVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473485i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_E_PROTECTED_CATALOG_SID_MISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473482i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_S_CATALOG_RESET: ::windows::core::HRESULT = ::windows::core::HRESULT(268336i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_S_CLIENT_REQUESTED_ABORT: ::windows::core::HRESULT = ::windows::core::HRESULT(268331i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_S_NEW_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(268329i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CI_S_RETRY_DOCUMENT: ::windows::core::HRESULT = ::windows::core::HRESULT(268332i32);
pub const CLSID_DataShapeProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3449a1c8_c56c_11d0_ad72_00c04fc29863);
pub const CLSID_MSDASQL: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cb_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSDASQL_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cd_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSPersist: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c07e0d0_4418_11d2_9212_00c04fbbbfb3);
pub const CLSID_SQLOLEDB: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c7ff16c_38e3_11d0_97ab_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdfa22b8e_e68d_11d0_97e4_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ERROR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0932c62_38e5_11d0_97ab_00c04fc2ad98);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CLUSION_REASON = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CLUSIONREASON_UNKNOWNSCOPE: CLUSION_REASON = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CLUSIONREASON_DEFAULT: CLUSION_REASON = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CLUSIONREASON_USER: CLUSION_REASON = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CLUSIONREASON_GROUPPOLICY: CLUSION_REASON = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_ALREADY_INIT: i32 = -2147216123i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_NOT_INIT: i32 = -2147216124i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_NUM_PARAMS: i32 = -2147216122i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_PARAM_SIZE: i32 = -2147216125i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_PAREN: i32 = -2147216126i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CMDLINE_E_UNEXPECTED: i32 = -2147216127i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_CONNECTIONTIMEOUT: i32 = -2147219963i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_DATASOURCENOTAVAILABLE: i32 = -2147219964i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_INSUFFICIENTBUFFER: i32 = -2147219957i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_INVALIDDATASOURCE: i32 = -2147219959i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_NOQUERYCONNECTIONS: i32 = -2147219965i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_REGISTRY: i32 = -2147219960i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_SERVERNOTFOUND: i32 = -2147219962i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_TIMEOUT: i32 = -2147219958i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_TOOMANYDATASERVERS: i32 = -2147219967i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_E_TOOMANYDATASOURCES: i32 = -2147219966i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CM_S_NODATASERVERS: i32 = 263687i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_BADRESULT: i32 = -2147220218i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_BADSEQUENCE: i32 = -2147220223i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_BUFFERTOOSMALL: i32 = -2147220220i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_DUPLICATEDBID: i32 = -2147220216i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_INCOMPATIBLECOLUMNS: i32 = -2147220221i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_MAXCONNEXCEEDED: i32 = -2147220213i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_NODEFAULTCATALOG: i32 = -2147220214i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_NOMOREDATA: i32 = -2147220222i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_NOSORTCOLUMN: i32 = -2147220217i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const COLL_E_TOOMANYMERGECOLUMNS: i32 = -2147220215i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com_StructuredStorage'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct COLUMNSET {
    pub cCol: u32,
    pub aCol: *mut super::super::Storage::IndexServer::FULLPROPSPEC,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for COLUMNSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for COLUMNSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::fmt::Debug for COLUMNSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("COLUMNSET").field("cCol", &self.cCol).field("aCol", &self.aCol).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for COLUMNSET {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for COLUMNSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<COLUMNSET>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for COLUMNSET {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for COLUMNSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CONDITION_CREATION_OPTIONS = u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_DEFAULT: CONDITION_CREATION_OPTIONS = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_NONE: CONDITION_CREATION_OPTIONS = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_SIMPLIFY: CONDITION_CREATION_OPTIONS = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_VECTOR_AND: CONDITION_CREATION_OPTIONS = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_VECTOR_OR: CONDITION_CREATION_OPTIONS = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_VECTOR_LEAF: CONDITION_CREATION_OPTIONS = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONDITION_CREATION_USE_CONTENT_LOCALE: CONDITION_CREATION_OPTIONS = 16u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com_StructuredStorage'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
pub struct CONTENTRESTRICTION {
    pub prop: super::super::Storage::IndexServer::FULLPROPSPEC,
    pub pwcsPhrase: super::super::Foundation::PWSTR,
    pub lcid: u32,
    pub ulGenerateMethod: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::marker::Copy for CONTENTRESTRICTION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::clone::Clone for CONTENTRESTRICTION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
unsafe impl ::windows::core::Abi for CONTENTRESTRICTION {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::PartialEq for CONTENTRESTRICTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CONTENTRESTRICTION>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::cmp::Eq for CONTENTRESTRICTION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
impl ::core::default::Default for CONTENTRESTRICTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_CONTENT_CLASS_READ: i32 = -2147208188i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_CONTENT_SOURCE_COLUMN_TYPE: i32 = -2147208185i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_NULL_CONTENT_CLASS_BSTR: i32 = -2147208186i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_NULL_URI: i32 = -2147208183i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_OUT_OF_RANGE: i32 = -2147208184i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_BAD_VECTOR_SIZE: i32 = -2147208189i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_READ: i32 = -2147208191i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_EXCEPTION: i32 = -2147208187i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_NULL_POINTER: i32 = -2147208190i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CQUERYDISPIDS: u32 = 11u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CQUERYMETADISPIDS: u32 = 10u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CQUERYPROPERTY: u32 = 64u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CREATESUBSCRIPTIONFLAGS = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CREATESUBS_ADDTOFAVORITES: CREATESUBSCRIPTIONFLAGS = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CREATESUBS_FROMFAVORITES: CREATESUBSCRIPTIONFLAGS = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CREATESUBS_NOUI: CREATESUBSCRIPTIONFLAGS = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CREATESUBS_NOSAVE: CREATESUBSCRIPTIONFLAGS = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CREATESUBS_SOFTWAREUPDATE: CREATESUBSCRIPTIONFLAGS = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_ASSERTIONS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CATALOGS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS_BY_TABLE: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_COLLATIONS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMNS: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_INDEXES: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_LINKEDSERVERS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECTS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURES: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_SCHEMATA: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_STATISTICS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES_INFO: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_STATISTICS: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TRANSLATIONS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_TRUSTEE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEWS: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_ACTIONS: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_COMMANDS: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_CUBES: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_DIMENSIONS: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_FUNCTIONS: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_HIERARCHIES: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_LEVELS: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_MEASURES: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_MEMBERS: u32 = 12u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_PROPERTIES: u32 = 9u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CRESTRICTIONS_MDSCHEMA_SETS: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CSTORAGEPROPERTY: u32 = 23u32;
pub const CSearchLanguageSupport: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6a68cc80_4337_4dbc_bd27_fbfb1053820b);
pub const CSearchManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d096c5f_ac08_4f1f_beb7_5c22c517ce39);
pub const CSearchRoot: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x30766bd2_ea1c_4f28_bf27_0b44e2f68db7);
pub const CSearchScopeRule: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe63de750_3bd7_4be5_9c84_6b4281988c44);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CatalogPausedReason = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_NONE: CatalogPausedReason = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_HIGH_IO: CatalogPausedReason = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_HIGH_CPU: CatalogPausedReason = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_HIGH_NTF_RATE: CatalogPausedReason = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_LOW_BATTERY: CatalogPausedReason = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_LOW_MEMORY: CatalogPausedReason = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_LOW_DISK: CatalogPausedReason = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_DELAYED_RECOVERY: CatalogPausedReason = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_USER_ACTIVE: CatalogPausedReason = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_EXTERNAL: CatalogPausedReason = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_PAUSED_REASON_UPGRADING: CatalogPausedReason = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type CatalogStatus = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_IDLE: CatalogStatus = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_PAUSED: CatalogStatus = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_RECOVERING: CatalogStatus = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_FULL_CRAWL: CatalogStatus = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_INCREMENTAL_CRAWL: CatalogStatus = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_PROCESSING_NOTIFICATIONS: CatalogStatus = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const CATALOG_STATUS_SHUTTING_DOWN: CatalogStatus = 6i32;
pub const CompoundCondition: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x116f8d13_101e_4fa5_84d4_ff8279381935);
pub const ConditionFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe03e85b0_7be3_4000_ba98_6c13de9fa486);
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct DATE_STRUCT {
    pub year: i16,
    pub month: u16,
    pub day: u16,
}
impl ::core::marker::Copy for DATE_STRUCT {}
impl ::core::clone::Clone for DATE_STRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DATE_STRUCT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DATE_STRUCT").field("year", &self.year).field("month", &self.month).field("day", &self.day).finish()
    }
}
unsafe impl ::windows::core::Abi for DATE_STRUCT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DATE_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DATE_STRUCT>()) == 0 }
    }
}
impl ::core::cmp::Eq for DATE_STRUCT {}
impl ::core::default::Default for DATE_STRUCT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBACCESSORFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_INVALID: DBACCESSORFLAGSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_PASSBYREF: DBACCESSORFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_ROWDATA: DBACCESSORFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_PARAMETERDATA: DBACCESSORFLAGSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_OPTIMIZED: DBACCESSORFLAGSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBACCESSOR_INHERITED: DBACCESSORFLAGSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBASYNCHOPENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBASYNCHOP_OPEN: DBASYNCHOPENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBASYNCHPHASEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBASYNCHPHASE_INITIALIZATION: DBASYNCHPHASEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBASYNCHPHASE_POPULATION: DBASYNCHPHASEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBASYNCHPHASE_COMPLETE: DBASYNCHPHASEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBASYNCHPHASE_CANCELED: DBASYNCHPHASEENUM = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBBINDEXT {
    pub pExtension: *mut u8,
    pub ulExtension: usize,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBBINDEXT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBBINDEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBBINDEXT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBBINDEXT").field("pExtension", &self.pExtension).field("ulExtension", &self.ulExtension).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBBINDEXT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBBINDEXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDEXT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBBINDEXT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBBINDEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBBINDEXT {
    pub pExtension: *mut u8,
    pub ulExtension: usize,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBBINDEXT {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBBINDEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBBINDEXT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBBINDEXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDEXT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBBINDEXT {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBBINDEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBBINDFLAGENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDFLAG_HTML: DBBINDFLAGENUM = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
pub struct DBBINDING {
    pub iOrdinal: usize,
    pub obValue: usize,
    pub obLength: usize,
    pub obStatus: usize,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub pObject: *mut DBOBJECT,
    pub pBindExt: *mut DBBINDEXT,
    pub dwPart: u32,
    pub dwMemOwner: u32,
    pub eParamIO: u32,
    pub cbMaxLen: usize,
    pub dwFlags: u32,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DBBINDING {
    fn clone(&self) -> Self {
        Self {
            iOrdinal: self.iOrdinal,
            obValue: self.obValue,
            obLength: self.obLength,
            obStatus: self.obStatus,
            pTypeInfo: self.pTypeInfo.clone(),
            pObject: self.pObject,
            pBindExt: self.pBindExt,
            dwPart: self.dwPart,
            dwMemOwner: self.dwMemOwner,
            eParamIO: self.eParamIO,
            cbMaxLen: self.cbMaxLen,
            dwFlags: self.dwFlags,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DBBINDING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBBINDING")
            .field("iOrdinal", &self.iOrdinal)
            .field("obValue", &self.obValue)
            .field("obLength", &self.obLength)
            .field("obStatus", &self.obStatus)
            .field("pTypeInfo", &self.pTypeInfo)
            .field("pObject", &self.pObject)
            .field("pBindExt", &self.pBindExt)
            .field("dwPart", &self.dwPart)
            .field("dwMemOwner", &self.dwMemOwner)
            .field("eParamIO", &self.eParamIO)
            .field("cbMaxLen", &self.cbMaxLen)
            .field("dwFlags", &self.dwFlags)
            .field("wType", &self.wType)
            .field("bPrecision", &self.bPrecision)
            .field("bScale", &self.bScale)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBBINDING {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBBINDING {
    fn eq(&self, other: &Self) -> bool {
        self.iOrdinal == other.iOrdinal && self.obValue == other.obValue && self.obLength == other.obLength && self.obStatus == other.obStatus && self.pTypeInfo == other.pTypeInfo && self.pObject == other.pObject && self.pBindExt == other.pBindExt && self.dwPart == other.dwPart && self.dwMemOwner == other.dwMemOwner && self.eParamIO == other.eParamIO && self.cbMaxLen == other.cbMaxLen && self.dwFlags == other.dwFlags && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBBINDING {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBBINDING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
pub struct DBBINDING {
    pub iOrdinal: usize,
    pub obValue: usize,
    pub obLength: usize,
    pub obStatus: usize,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub pObject: *mut DBOBJECT,
    pub pBindExt: *mut DBBINDEXT,
    pub dwPart: u32,
    pub dwMemOwner: u32,
    pub eParamIO: u32,
    pub cbMaxLen: usize,
    pub dwFlags: u32,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Abi for DBBINDING {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DBBINDING {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBBINDING>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DBBINDING {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Com")]
impl ::core::default::Default for DBBINDING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBBINDSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_OK: DBBINDSTATUSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_BADORDINAL: DBBINDSTATUSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_UNSUPPORTEDCONVERSION: DBBINDSTATUSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_BADBINDINFO: DBBINDSTATUSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_BADSTORAGEFLAGS: DBBINDSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_NOINTERFACE: DBBINDSTATUSENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDSTATUS_MULTIPLESTORAGE: DBBINDSTATUSENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBBINDURLFLAGENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_READ: DBBINDURLFLAGENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_WRITE: DBBINDURLFLAGENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_READWRITE: DBBINDURLFLAGENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_SHARE_DENY_READ: DBBINDURLFLAGENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_SHARE_DENY_WRITE: DBBINDURLFLAGENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_SHARE_EXCLUSIVE: DBBINDURLFLAGENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_SHARE_DENY_NONE: DBBINDURLFLAGENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_ASYNCHRONOUS: DBBINDURLFLAGENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_COLLECTION: DBBINDURLFLAGENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_DELAYFETCHSTREAM: DBBINDURLFLAGENUM = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_DELAYFETCHCOLUMNS: DBBINDURLFLAGENUM = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_RECURSIVE: DBBINDURLFLAGENUM = 4194304i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_OUTPUT: DBBINDURLFLAGENUM = 8388608i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_WAITFORINIT: DBBINDURLFLAGENUM = 16777216i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_OPENIFEXISTS: DBBINDURLFLAGENUM = 33554432i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_OVERWRITE: DBBINDURLFLAGENUM = 67108864i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLFLAG_ISSTRUCTUREDDOCUMENT: DBBINDURLFLAGENUM = 134217728i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBBINDURLSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLSTATUS_S_OK: DBBINDURLSTATUSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLSTATUS_S_DENYNOTSUPPORTED: DBBINDURLSTATUSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLSTATUS_S_DENYTYPENOTSUPPORTED: DBBINDURLSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBINDURLSTATUS_S_REDIRECTED: DBBINDURLSTATUSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBBOOKMARK = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBMK_INVALID: DBBOOKMARK = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBMK_FIRST: DBBOOKMARK = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBBMK_LAST: DBBOOKMARK = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
pub struct DBCOLUMNACCESS {
    pub pData: *mut ::core::ffi::c_void,
    pub columnid: super::super::Storage::IndexServer::DBID,
    pub cbDataLen: usize,
    pub dwStatus: u32,
    pub cbMaxLen: usize,
    pub dwReserved: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::marker::Copy for DBCOLUMNACCESS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::clone::Clone for DBCOLUMNACCESS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
unsafe impl ::windows::core::Abi for DBCOLUMNACCESS {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::PartialEq for DBCOLUMNACCESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNACCESS>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::Eq for DBCOLUMNACCESS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::default::Default for DBCOLUMNACCESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
pub struct DBCOLUMNACCESS {
    pub pData: *mut ::core::ffi::c_void,
    pub columnid: super::super::Storage::IndexServer::DBID,
    pub cbDataLen: usize,
    pub dwStatus: u32,
    pub cbMaxLen: usize,
    pub dwReserved: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::marker::Copy for DBCOLUMNACCESS {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::clone::Clone for DBCOLUMNACCESS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
unsafe impl ::windows::core::Abi for DBCOLUMNACCESS {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::PartialEq for DBCOLUMNACCESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNACCESS>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::Eq for DBCOLUMNACCESS {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::default::Default for DBCOLUMNACCESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCOLUMNDESC {
    pub pwszTypeName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub rgPropertySets: *mut DBPROPSET,
    pub pclsid: *mut ::windows::core::GUID,
    pub cPropertySets: u32,
    pub ulColumnSize: usize,
    pub dbcid: super::super::Storage::IndexServer::DBID,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCOLUMNDESC {
    fn clone(&self) -> Self {
        Self {
            pwszTypeName: self.pwszTypeName,
            pTypeInfo: self.pTypeInfo.clone(),
            rgPropertySets: self.rgPropertySets,
            pclsid: self.pclsid,
            cPropertySets: self.cPropertySets,
            ulColumnSize: self.ulColumnSize,
            dbcid: self.dbcid,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCOLUMNDESC {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        self.pwszTypeName == other.pwszTypeName && self.pTypeInfo == other.pTypeInfo && self.rgPropertySets == other.rgPropertySets && self.pclsid == other.pclsid && self.cPropertySets == other.cPropertySets && self.ulColumnSize == other.ulColumnSize && self.dbcid == other.dbcid && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCOLUMNDESC {
    pub pwszTypeName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub rgPropertySets: *mut DBPROPSET,
    pub pclsid: *mut ::windows::core::GUID,
    pub cPropertySets: u32,
    pub ulColumnSize: usize,
    pub dbcid: super::super::Storage::IndexServer::DBID,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCOLUMNDESC {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNDESCFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_TYPENAME: DBCOLUMNDESCFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_ITYPEINFO: DBCOLUMNDESCFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_PROPERTIES: DBCOLUMNDESCFLAGSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_CLSID: DBCOLUMNDESCFLAGSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_COLSIZE: DBCOLUMNDESCFLAGSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_DBCID: DBCOLUMNDESCFLAGSENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_WTYPE: DBCOLUMNDESCFLAGSENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_PRECISION: DBCOLUMNDESCFLAGSENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNDESCFLAGS_SCALE: DBCOLUMNDESCFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNFLAGS15ENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISCHAPTER: DBCOLUMNFLAGS15ENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISBOOKMARK: DBCOLUMNFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_MAYDEFER: DBCOLUMNFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_WRITE: DBCOLUMNFLAGSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_WRITEUNKNOWN: DBCOLUMNFLAGSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISFIXEDLENGTH: DBCOLUMNFLAGSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISNULLABLE: DBCOLUMNFLAGSENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_MAYBENULL: DBCOLUMNFLAGSENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISLONG: DBCOLUMNFLAGSENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISROWID: DBCOLUMNFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISROWVER: DBCOLUMNFLAGSENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_CACHEDEFERRED: DBCOLUMNFLAGSENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNFLAGSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_SCALEISNEGATIVE: DBCOLUMNFLAGSENUM20 = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_RESERVED: DBCOLUMNFLAGSENUM20 = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNFLAGSENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISROWURL: DBCOLUMNFLAGSENUM21 = 65536i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISDEFAULTSTREAM: DBCOLUMNFLAGSENUM21 = 131072i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISCOLLECTION: DBCOLUMNFLAGSENUM21 = 262144i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOLUMNFLAGSENUM26 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISSTREAM: DBCOLUMNFLAGSENUM26 = 524288i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISROWSET: DBCOLUMNFLAGSENUM26 = 1048576i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ISROW: DBCOLUMNFLAGSENUM26 = 2097152i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOLUMNFLAGS_ROWSPECIFICCOLUMN: DBCOLUMNFLAGSENUM26 = 4194304i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
pub struct DBCOLUMNINFO {
    pub pwszName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub iOrdinal: usize,
    pub dwFlags: u32,
    pub ulColumnSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
    pub columnid: super::super::Storage::IndexServer::DBID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::clone::Clone for DBCOLUMNINFO {
    fn clone(&self) -> Self {
        Self {
            pwszName: self.pwszName,
            pTypeInfo: self.pTypeInfo.clone(),
            iOrdinal: self.iOrdinal,
            dwFlags: self.dwFlags,
            ulColumnSize: self.ulColumnSize,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
            columnid: self.columnid,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBCOLUMNINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBCOLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszName == other.pwszName && self.pTypeInfo == other.pTypeInfo && self.iOrdinal == other.iOrdinal && self.dwFlags == other.dwFlags && self.ulColumnSize == other.ulColumnSize && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale && self.columnid == other.columnid
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBCOLUMNINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBCOLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
pub struct DBCOLUMNINFO {
    pub pwszName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub iOrdinal: usize,
    pub dwFlags: u32,
    pub ulColumnSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
    pub columnid: super::super::Storage::IndexServer::DBID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBCOLUMNINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBCOLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOLUMNINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBCOLUMNINFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBCOLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOMMANDPERSISTFLAGENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMMANDPERSISTFLAG_NOSAVE: DBCOMMANDPERSISTFLAGENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOMMANDPERSISTFLAGENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMMANDPERSISTFLAG_DEFAULT: DBCOMMANDPERSISTFLAGENUM21 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMMANDPERSISTFLAG_PERSISTVIEW: DBCOMMANDPERSISTFLAGENUM21 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMMANDPERSISTFLAG_PERSISTPROCEDURE: DBCOMMANDPERSISTFLAGENUM21 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOMPAREENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPARE_LT: DBCOMPAREENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPARE_EQ: DBCOMPAREENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPARE_GT: DBCOMPAREENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPARE_NE: DBCOMPAREENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPARE_NOTCOMPARABLE: DBCOMPAREENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOMPAREOPSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_LT: DBCOMPAREOPSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_LE: DBCOMPAREOPSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_EQ: DBCOMPAREOPSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_GE: DBCOMPAREOPSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_GT: DBCOMPAREOPSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_BEGINSWITH: DBCOMPAREOPSENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_CONTAINS: DBCOMPAREOPSENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_NE: DBCOMPAREOPSENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_IGNORE: DBCOMPAREOPSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_CASESENSITIVE: DBCOMPAREOPSENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_CASEINSENSITIVE: DBCOMPAREOPSENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOMPAREOPSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_NOTBEGINSWITH: DBCOMPAREOPSENUM20 = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPAREOPS_NOTCONTAINS: DBCOMPAREOPSENUM20 = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPUTEMODE_COMPUTED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPUTEMODE_DYNAMIC: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOMPUTEMODE_NOTCOMPUTED: u32 = 3u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCONSTRAINTDESC {
    pub pConstraintID: *mut super::super::Storage::IndexServer::DBID,
    pub ConstraintType: u32,
    pub cColumns: usize,
    pub rgColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pReferencedTableID: *mut super::super::Storage::IndexServer::DBID,
    pub cForeignKeyColumns: usize,
    pub rgForeignKeyColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pwszConstraintText: super::super::Foundation::PWSTR,
    pub UpdateRule: u32,
    pub DeleteRule: u32,
    pub MatchType: u32,
    pub Deferrability: u32,
    pub cReserved: usize,
    pub rgReserved: *mut DBPROPSET,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBCONSTRAINTDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCONSTRAINTDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::fmt::Debug for DBCONSTRAINTDESC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBCONSTRAINTDESC")
            .field("pConstraintID", &self.pConstraintID)
            .field("ConstraintType", &self.ConstraintType)
            .field("cColumns", &self.cColumns)
            .field("rgColumnList", &self.rgColumnList)
            .field("pReferencedTableID", &self.pReferencedTableID)
            .field("cForeignKeyColumns", &self.cForeignKeyColumns)
            .field("rgForeignKeyColumnList", &self.rgForeignKeyColumnList)
            .field("pwszConstraintText", &self.pwszConstraintText)
            .field("UpdateRule", &self.UpdateRule)
            .field("DeleteRule", &self.DeleteRule)
            .field("MatchType", &self.MatchType)
            .field("Deferrability", &self.Deferrability)
            .field("cReserved", &self.cReserved)
            .field("rgReserved", &self.rgReserved)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCONSTRAINTDESC {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCONSTRAINTDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCONSTRAINTDESC>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCONSTRAINTDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCONSTRAINTDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBCONSTRAINTDESC {
    pub pConstraintID: *mut super::super::Storage::IndexServer::DBID,
    pub ConstraintType: u32,
    pub cColumns: usize,
    pub rgColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pReferencedTableID: *mut super::super::Storage::IndexServer::DBID,
    pub cForeignKeyColumns: usize,
    pub rgForeignKeyColumnList: *mut super::super::Storage::IndexServer::DBID,
    pub pwszConstraintText: super::super::Foundation::PWSTR,
    pub UpdateRule: u32,
    pub DeleteRule: u32,
    pub MatchType: u32,
    pub Deferrability: u32,
    pub cReserved: usize,
    pub rgReserved: *mut DBPROPSET,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBCONSTRAINTDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBCONSTRAINTDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBCONSTRAINTDESC {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBCONSTRAINTDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCONSTRAINTDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBCONSTRAINTDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBCONSTRAINTDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCONSTRAINTTYPEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONSTRAINTTYPE_UNIQUE: DBCONSTRAINTTYPEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONSTRAINTTYPE_FOREIGNKEY: DBCONSTRAINTTYPEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONSTRAINTTYPE_PRIMARYKEY: DBCONSTRAINTTYPEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONSTRAINTTYPE_CHECK: DBCONSTRAINTTYPEENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCONVERTFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONVERTFLAGS_COLUMN: DBCONVERTFLAGSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONVERTFLAGS_PARAMETER: DBCONVERTFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCONVERTFLAGSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONVERTFLAGS_ISLONG: DBCONVERTFLAGSENUM20 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONVERTFLAGS_ISFIXEDLENGTH: DBCONVERTFLAGSENUM20 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCONVERTFLAGS_FROMVARIANT: DBCONVERTFLAGSENUM20 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOPYFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOPY_ASYNC: DBCOPYFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOPY_REPLACE_EXISTING: DBCOPYFLAGSENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOPY_ALLOW_EMULATION: DBCOPYFLAGSENUM = 1024i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOPY_NON_RECURSIVE: DBCOPYFLAGSENUM = 2048i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBCOPY_ATOMIC: DBCOPYFLAGSENUM = 4096i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBCOST {
    pub eKind: u32,
    pub dwUnits: u32,
    pub lValue: i32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBCOST {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBCOST {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBCOST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBCOST").field("eKind", &self.eKind).field("dwUnits", &self.dwUnits).field("lValue", &self.lValue).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBCOST {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBCOST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOST>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBCOST {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBCOST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBCOST {
    pub eKind: u32,
    pub dwUnits: u32,
    pub lValue: i32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBCOST {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBCOST {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBCOST {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBCOST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBCOST>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBCOST {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBCOST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBCOSTUNITENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_INVALID: DBCOSTUNITENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_WEIGHT: DBCOSTUNITENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_PERCENT: DBCOSTUNITENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MAXIMUM: DBCOSTUNITENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MINIMUM: DBCOSTUNITENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MICRO_SECOND: DBCOSTUNITENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MILLI_SECOND: DBCOSTUNITENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_SECOND: DBCOSTUNITENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MINUTE: DBCOSTUNITENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_HOUR: DBCOSTUNITENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_BYTE: DBCOSTUNITENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_KILO_BYTE: DBCOSTUNITENUM = 1024i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_MEGA_BYTE: DBCOSTUNITENUM = 2048i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_GIGA_BYTE: DBCOSTUNITENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_NUM_MSGS: DBCOSTUNITENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_NUM_LOCKS: DBCOSTUNITENUM = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_NUM_ROWS: DBCOSTUNITENUM = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUNIT_OTHER: DBCOSTUNITENUM = 65536i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBDATACONVERTENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDATACONVERT_DEFAULT: DBDATACONVERTENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDATACONVERT_SETDATABEHAVIOR: DBDATACONVERTENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDATACONVERT_LENGTHFROMNTS: DBDATACONVERTENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDATACONVERT_DSTISFIXEDLENGTH: DBDATACONVERTENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDATACONVERT_DECIMALSCALE: DBDATACONVERTENUM = 8i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct DBDATE {
    pub year: i16,
    pub month: u16,
    pub day: u16,
}
impl ::core::marker::Copy for DBDATE {}
impl ::core::clone::Clone for DBDATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DBDATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBDATE").field("year", &self.year).field("month", &self.month).field("day", &self.day).finish()
    }
}
unsafe impl ::windows::core::Abi for DBDATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DBDATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBDATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for DBDATE {}
impl ::core::default::Default for DBDATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBDEFERRABILITYENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDEFERRABILITY_DEFERRED: DBDEFERRABILITYENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDEFERRABILITY_DEFERRABLE: DBDEFERRABILITYENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBDELETEFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDELETE_ASYNC: DBDELETEFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBDELETE_ATOMIC: DBDELETEFLAGSENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBEVENTPHASEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEVENTPHASE_OKTODO: DBEVENTPHASEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEVENTPHASE_ABOUTTODO: DBEVENTPHASEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEVENTPHASE_SYNCHAFTER: DBEVENTPHASEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEVENTPHASE_FAILEDTODO: DBEVENTPHASEENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEVENTPHASE_DIDEVENT: DBEVENTPHASEENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBEXECLIMITSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEXECLIMITS_ABORT: DBEXECLIMITSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEXECLIMITS_STOP: DBEXECLIMITSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBEXECLIMITS_SUSPEND: DBEXECLIMITSENUM = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBFAILUREINFO {
    pub hRow: usize,
    pub iColumn: usize,
    pub failure: ::windows::core::HRESULT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBFAILUREINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBFAILUREINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBFAILUREINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBFAILUREINFO").field("hRow", &self.hRow).field("iColumn", &self.iColumn).field("failure", &self.failure).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBFAILUREINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBFAILUREINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBFAILUREINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBFAILUREINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBFAILUREINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBFAILUREINFO {
    pub hRow: usize,
    pub iColumn: usize,
    pub failure: ::windows::core::HRESULT,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBFAILUREINFO {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBFAILUREINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBFAILUREINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBFAILUREINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBFAILUREINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBFAILUREINFO {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBFAILUREINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DBGUID_MSSQLXML: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d531cb2_e6ed_11d2_b252_00c04f681b71);
pub const DBGUID_XPATH: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xec2a4293_e898_11d2_b1b7_00c04f680c56);
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBIMPLICITSESSION {
    pub pUnkOuter: ::core::option::Option<::windows::core::IUnknown>,
    pub piid: *mut ::windows::core::GUID,
    pub pSession: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBIMPLICITSESSION {
    fn clone(&self) -> Self {
        Self { pUnkOuter: self.pUnkOuter.clone(), piid: self.piid, pSession: self.pSession.clone() }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBIMPLICITSESSION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBIMPLICITSESSION").field("pUnkOuter", &self.pUnkOuter).field("piid", &self.piid).field("pSession", &self.pSession).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBIMPLICITSESSION {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBIMPLICITSESSION {
    fn eq(&self, other: &Self) -> bool {
        self.pUnkOuter == other.pUnkOuter && self.piid == other.piid && self.pSession == other.pSession
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBIMPLICITSESSION {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBIMPLICITSESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBIMPLICITSESSION {
    pub pUnkOuter: ::core::option::Option<::windows::core::IUnknown>,
    pub piid: *mut ::windows::core::GUID,
    pub pSession: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBIMPLICITSESSION {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBIMPLICITSESSION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBIMPLICITSESSION>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBIMPLICITSESSION {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBIMPLICITSESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
pub struct DBINDEXCOLUMNDESC {
    pub pColumnID: *mut super::super::Storage::IndexServer::DBID,
    pub eIndexColOrder: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::marker::Copy for DBINDEXCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::clone::Clone for DBINDEXCOLUMNDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::fmt::Debug for DBINDEXCOLUMNDESC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBINDEXCOLUMNDESC").field("pColumnID", &self.pColumnID).field("eIndexColOrder", &self.eIndexColOrder).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
unsafe impl ::windows::core::Abi for DBINDEXCOLUMNDESC {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::PartialEq for DBINDEXCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBINDEXCOLUMNDESC>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::Eq for DBINDEXCOLUMNDESC {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::default::Default for DBINDEXCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
pub struct DBINDEXCOLUMNDESC {
    pub pColumnID: *mut super::super::Storage::IndexServer::DBID,
    pub eIndexColOrder: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::marker::Copy for DBINDEXCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::clone::Clone for DBINDEXCOLUMNDESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
unsafe impl ::windows::core::Abi for DBINDEXCOLUMNDESC {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::PartialEq for DBINDEXCOLUMNDESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBINDEXCOLUMNDESC>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::cmp::Eq for DBINDEXCOLUMNDESC {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
impl ::core::default::Default for DBINDEXCOLUMNDESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBINDEX_COL_ORDERENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBINDEX_COL_ORDER_ASC: DBINDEX_COL_ORDERENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBINDEX_COL_ORDER_DESC: DBINDEX_COL_ORDERENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBLITERALENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_INVALID: DBLITERALENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_BINARY_LITERAL: DBLITERALENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CATALOG_NAME: DBLITERALENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CATALOG_SEPARATOR: DBLITERALENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CHAR_LITERAL: DBLITERALENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_COLUMN_ALIAS: DBLITERALENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_COLUMN_NAME: DBLITERALENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CORRELATION_NAME: DBLITERALENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CURSOR_NAME: DBLITERALENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_ESCAPE_PERCENT: DBLITERALENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_ESCAPE_UNDERSCORE: DBLITERALENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_INDEX_NAME: DBLITERALENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_LIKE_PERCENT: DBLITERALENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_LIKE_UNDERSCORE: DBLITERALENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_PROCEDURE_NAME: DBLITERALENUM = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_QUOTE: DBLITERALENUM = 15i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_SCHEMA_NAME: DBLITERALENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_TABLE_NAME: DBLITERALENUM = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_TEXT_COMMAND: DBLITERALENUM = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_USER_NAME: DBLITERALENUM = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_VIEW_NAME: DBLITERALENUM = 20i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBLITERALENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_CUBE_NAME: DBLITERALENUM20 = 21i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_DIMENSION_NAME: DBLITERALENUM20 = 22i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_HIERARCHY_NAME: DBLITERALENUM20 = 23i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_LEVEL_NAME: DBLITERALENUM20 = 24i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_MEMBER_NAME: DBLITERALENUM20 = 25i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_PROPERTY_NAME: DBLITERALENUM20 = 26i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_SCHEMA_SEPARATOR: DBLITERALENUM20 = 27i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_QUOTE_SUFFIX: DBLITERALENUM20 = 28i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBLITERALENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_ESCAPE_PERCENT_SUFFIX: DBLITERALENUM21 = 29i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBLITERAL_ESCAPE_UNDERSCORE_SUFFIX: DBLITERALENUM21 = 30i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DBLITERALINFO {
    pub pwszLiteralValue: super::super::Foundation::PWSTR,
    pub pwszInvalidChars: super::super::Foundation::PWSTR,
    pub pwszInvalidStartingChars: super::super::Foundation::PWSTR,
    pub lt: u32,
    pub fSupported: super::super::Foundation::BOOL,
    pub cchMaxLen: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBLITERALINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBLITERALINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DBLITERALINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBLITERALINFO").field("pwszLiteralValue", &self.pwszLiteralValue).field("pwszInvalidChars", &self.pwszInvalidChars).field("pwszInvalidStartingChars", &self.pwszInvalidStartingChars).field("lt", &self.lt).field("fSupported", &self.fSupported).field("cchMaxLen", &self.cchMaxLen).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBLITERALINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBLITERALINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBLITERALINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBLITERALINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBLITERALINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DBLITERALINFO {
    pub pwszLiteralValue: super::super::Foundation::PWSTR,
    pub pwszInvalidChars: super::super::Foundation::PWSTR,
    pub pwszInvalidStartingChars: super::super::Foundation::PWSTR,
    pub lt: u32,
    pub fSupported: super::super::Foundation::BOOL,
    pub cchMaxLen: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBLITERALINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBLITERALINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBLITERALINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBLITERALINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBLITERALINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBLITERALINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBLITERALINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBMATCHTYPEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMATCHTYPE_FULL: DBMATCHTYPEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMATCHTYPE_NONE: DBMATCHTYPEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMATCHTYPE_PARTIAL: DBMATCHTYPEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMAXCHAR: u32 = 8001u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBMEMOWNERENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMEMOWNER_CLIENTOWNED: DBMEMOWNERENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMEMOWNER_PROVIDEROWNED: DBMEMOWNERENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBMOVEFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMOVE_REPLACE_EXISTING: DBMOVEFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMOVE_ASYNC: DBMOVEFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMOVE_DONT_UPDATE_LINKS: DBMOVEFLAGSENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMOVE_ALLOW_EMULATION: DBMOVEFLAGSENUM = 1024i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBMOVE_ATOMIC: DBMOVEFLAGSENUM = 4096i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBOBJECT {
    pub dwFlags: u32,
    pub iid: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBOBJECT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBOBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBOBJECT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBOBJECT").field("dwFlags", &self.dwFlags).field("iid", &self.iid).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBOBJECT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBOBJECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBOBJECT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBOBJECT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBOBJECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBOBJECT {
    pub dwFlags: u32,
    pub iid: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBOBJECT {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBOBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBOBJECT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBOBJECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBOBJECT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBOBJECT {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBOBJECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DBPARAMBINDINFO {
    pub pwszDataSourceType: super::super::Foundation::PWSTR,
    pub pwszName: super::super::Foundation::PWSTR,
    pub ulParamSize: usize,
    pub dwFlags: u32,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBPARAMBINDINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBPARAMBINDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DBPARAMBINDINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPARAMBINDINFO").field("pwszDataSourceType", &self.pwszDataSourceType).field("pwszName", &self.pwszName).field("ulParamSize", &self.ulParamSize).field("dwFlags", &self.dwFlags).field("bPrecision", &self.bPrecision).field("bScale", &self.bScale).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBPARAMBINDINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBPARAMBINDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMBINDINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBPARAMBINDINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBPARAMBINDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DBPARAMBINDINFO {
    pub pwszDataSourceType: super::super::Foundation::PWSTR,
    pub pwszName: super::super::Foundation::PWSTR,
    pub ulParamSize: usize,
    pub dwFlags: u32,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DBPARAMBINDINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DBPARAMBINDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBPARAMBINDINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBPARAMBINDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMBINDINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBPARAMBINDINFO {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBPARAMBINDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPARAMFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_ISINPUT: DBPARAMFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_ISOUTPUT: DBPARAMFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_ISSIGNED: DBPARAMFLAGSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_ISNULLABLE: DBPARAMFLAGSENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_ISLONG: DBPARAMFLAGSENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPARAMFLAGSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMFLAGS_SCALEISNEGATIVE: DBPARAMFLAGSENUM20 = 256i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub struct DBPARAMINFO {
    pub dwFlags: u32,
    pub iOrdinal: usize,
    pub pwszName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub ulParamSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::clone::Clone for DBPARAMINFO {
    fn clone(&self) -> Self {
        Self {
            dwFlags: self.dwFlags,
            iOrdinal: self.iOrdinal,
            pwszName: self.pwszName,
            pTypeInfo: self.pTypeInfo.clone(),
            ulParamSize: self.ulParamSize,
            wType: self.wType,
            bPrecision: self.bPrecision,
            bScale: self.bScale,
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::fmt::Debug for DBPARAMINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPARAMINFO").field("dwFlags", &self.dwFlags).field("iOrdinal", &self.iOrdinal).field("pwszName", &self.pwszName).field("pTypeInfo", &self.pTypeInfo).field("ulParamSize", &self.ulParamSize).field("wType", &self.wType).field("bPrecision", &self.bPrecision).field("bScale", &self.bScale).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBPARAMINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBPARAMINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.iOrdinal == other.iOrdinal && self.pwszName == other.pwszName && self.pTypeInfo == other.pTypeInfo && self.ulParamSize == other.ulParamSize && self.wType == other.wType && self.bPrecision == other.bPrecision && self.bScale == other.bScale
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBPARAMINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBPARAMINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub struct DBPARAMINFO {
    pub dwFlags: u32,
    pub iOrdinal: usize,
    pub pwszName: super::super::Foundation::PWSTR,
    pub pTypeInfo: ::core::option::Option<super::Com::ITypeInfo>,
    pub ulParamSize: usize,
    pub wType: u16,
    pub bPrecision: u8,
    pub bScale: u8,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
unsafe impl ::windows::core::Abi for DBPARAMINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::cmp::PartialEq for DBPARAMINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::cmp::Eq for DBPARAMINFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
impl ::core::default::Default for DBPARAMINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPARAMIOENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMIO_NOTPARAM: DBPARAMIOENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMIO_INPUT: DBPARAMIOENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMIO_OUTPUT: DBPARAMIOENUM = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBPARAMS {
    pub pData: *mut ::core::ffi::c_void,
    pub cParamSets: usize,
    pub hAccessor: usize,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBPARAMS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBPARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBPARAMS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPARAMS").field("pData", &self.pData).field("cParamSets", &self.cParamSets).field("hAccessor", &self.hAccessor).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBPARAMS {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBPARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMS>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBPARAMS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBPARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBPARAMS {
    pub pData: *mut ::core::ffi::c_void,
    pub cParamSets: usize,
    pub hAccessor: usize,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBPARAMS {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBPARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBPARAMS {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBPARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPARAMS>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBPARAMS {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBPARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMTYPE_INPUT: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMTYPE_INPUTOUTPUT: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMTYPE_OUTPUT: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPARAMTYPE_RETURNVALUE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPARTENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPART_INVALID: DBPARTENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPART_VALUE: DBPARTENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPART_LENGTH: DBPARTENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPART_STATUS: DBPARTENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPENDINGSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPENDINGSTATUS_NEW: DBPENDINGSTATUSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPENDINGSTATUS_CHANGED: DBPENDINGSTATUSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPENDINGSTATUS_DELETED: DBPENDINGSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPENDINGSTATUS_UNCHANGED: DBPENDINGSTATUSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPENDINGSTATUS_INVALIDROW: DBPENDINGSTATUSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPOSITIONFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPOSITION_OK: DBPOSITIONFLAGSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPOSITION_NOROW: DBPOSITIONFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPOSITION_BOF: DBPOSITIONFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPOSITION_EOF: DBPOSITIONFLAGSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROMPTOPTIONSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_NONE: DBPROMPTOPTIONSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_WIZARDSHEET: DBPROMPTOPTIONSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_PROPERTYSHEET: DBPROMPTOPTIONSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_BROWSEONLY: DBPROMPTOPTIONSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_DISABLE_PROVIDER_SELECTION: DBPROMPTOPTIONSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPTOPTIONS_DISABLESAVEPASSWORD: DBPROMPTOPTIONSENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPT_COMPLETE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPT_COMPLETEREQUIRED: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPT_NOPROMPT: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROMPT_PROMPT: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROP {
    pub dwPropertyID: u32,
    pub dwOptions: u32,
    pub dwStatus: u32,
    pub colid: super::super::Storage::IndexServer::DBID,
    pub vValue: super::Com::VARIANT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROP {
    fn clone(&self) -> Self {
        Self { dwPropertyID: self.dwPropertyID, dwOptions: self.dwOptions, dwStatus: self.dwStatus, colid: self.colid, vValue: self.vValue.clone() }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROP {
    fn eq(&self, other: &Self) -> bool {
        self.dwPropertyID == other.dwPropertyID && self.dwOptions == other.dwOptions && self.dwStatus == other.dwStatus && self.colid == other.colid && self.vValue == other.vValue
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROP {
    pub dwPropertyID: u32,
    pub dwOptions: u32,
    pub dwStatus: u32,
    pub colid: super::super::Storage::IndexServer::DBID,
    pub vValue: super::Com::VARIANT,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROP>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROP {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ABORTPRESERVE: DBPROPENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ACTIVESESSIONS: DBPROPENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_APPENDONLY: DBPROPENUM = 187i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ASYNCTXNABORT: DBPROPENUM = 168i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ASYNCTXNCOMMIT: DBPROPENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_CACHE_AUTHINFO: DBPROPENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_ENCRYPT_PASSWORD: DBPROPENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_INTEGRATED: DBPROPENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_MASK_PASSWORD: DBPROPENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_PASSWORD: DBPROPENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_PERSIST_ENCRYPTED: DBPROPENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO: DBPROPENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_AUTH_USERID: DBPROPENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BLOCKINGSTORAGEOBJECTS: DBPROPENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BOOKMARKS: DBPROPENUM = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BOOKMARKSKIPPED: DBPROPENUM = 15i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BOOKMARKTYPE: DBPROPENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BYREFACCESSORS: DBPROPENUM = 120i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CACHEDEFERRED: DBPROPENUM = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CANFETCHBACKWARDS: DBPROPENUM = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CANHOLDROWS: DBPROPENUM = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CANSCROLLBACKWARDS: DBPROPENUM = 21i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CATALOGLOCATION: DBPROPENUM = 22i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CATALOGTERM: DBPROPENUM = 23i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CATALOGUSAGE: DBPROPENUM = 24i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CHANGEINSERTEDROWS: DBPROPENUM = 188i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_AUTOINCREMENT: DBPROPENUM = 26i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_DEFAULT: DBPROPENUM = 27i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_DESCRIPTION: DBPROPENUM = 28i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_FIXEDLENGTH: DBPROPENUM = 167i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_NULLABLE: DBPROPENUM = 29i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_PRIMARYKEY: DBPROPENUM = 30i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_UNIQUE: DBPROPENUM = 31i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COLUMNDEFINITION: DBPROPENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COLUMNRESTRICT: DBPROPENUM = 33i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COMMANDTIMEOUT: DBPROPENUM = 34i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COMMITPRESERVE: DBPROPENUM = 35i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CONCATNULLBEHAVIOR: DBPROPENUM = 36i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CURRENTCATALOG: DBPROPENUM = 37i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DATASOURCENAME: DBPROPENUM = 38i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DATASOURCEREADONLY: DBPROPENUM = 39i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DBMSNAME: DBPROPENUM = 40i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DBMSVER: DBPROPENUM = 41i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DEFERRED: DBPROPENUM = 42i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DELAYSTORAGEOBJECTS: DBPROPENUM = 43i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DSOTHREADMODEL: DBPROPENUM = 169i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_GROUPBY: DBPROPENUM = 44i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_HETEROGENEOUSTABLES: DBPROPENUM = 45i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IAccessor: DBPROPENUM = 121i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IColumnsInfo: DBPROPENUM = 122i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IColumnsRowset: DBPROPENUM = 123i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IConnectionPointContainer: DBPROPENUM = 124i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IConvertType: DBPROPENUM = 194i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowset: DBPROPENUM = 126i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetChange: DBPROPENUM = 127i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetIdentity: DBPROPENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetIndex: DBPROPENUM = 159i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetInfo: DBPROPENUM = 129i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetLocate: DBPROPENUM = 130i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetResynch: DBPROPENUM = 132i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetScroll: DBPROPENUM = 133i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetUpdate: DBPROPENUM = 134i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ISupportErrorInfo: DBPROPENUM = 135i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ILockBytes: DBPROPENUM = 136i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ISequentialStream: DBPROPENUM = 137i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IStorage: DBPROPENUM = 138i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IStream: DBPROPENUM = 139i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IDENTIFIERCASE: DBPROPENUM = 46i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IMMOBILEROWS: DBPROPENUM = 47i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_AUTOUPDATE: DBPROPENUM = 48i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_CLUSTERED: DBPROPENUM = 49i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_FILLFACTOR: DBPROPENUM = 50i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_INITIALSIZE: DBPROPENUM = 51i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_NULLCOLLATION: DBPROPENUM = 52i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_NULLS: DBPROPENUM = 53i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_PRIMARYKEY: DBPROPENUM = 54i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_SORTBOOKMARKS: DBPROPENUM = 55i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_TEMPINDEX: DBPROPENUM = 163i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_TYPE: DBPROPENUM = 56i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INDEX_UNIQUE: DBPROPENUM = 57i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_DATASOURCE: DBPROPENUM = 59i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_HWND: DBPROPENUM = 60i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_IMPERSONATION_LEVEL: DBPROPENUM = 61i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_LCID: DBPROPENUM = 186i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_LOCATION: DBPROPENUM = 62i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_MODE: DBPROPENUM = 63i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_PROMPT: DBPROPENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_PROTECTION_LEVEL: DBPROPENUM = 65i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_PROVIDERSTRING: DBPROPENUM = 160i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_TIMEOUT: DBPROPENUM = 66i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_LITERALBOOKMARKS: DBPROPENUM = 67i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_LITERALIDENTITY: DBPROPENUM = 68i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXINDEXSIZE: DBPROPENUM = 70i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXOPENROWS: DBPROPENUM = 71i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXPENDINGROWS: DBPROPENUM = 72i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXROWS: DBPROPENUM = 73i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXROWSIZE: DBPROPENUM = 74i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXROWSIZEINCLUDESBLOB: DBPROPENUM = 75i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXTABLESINSELECT: DBPROPENUM = 76i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAYWRITECOLUMN: DBPROPENUM = 77i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MEMORYUSAGE: DBPROPENUM = 78i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MULTIPLEPARAMSETS: DBPROPENUM = 191i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MULTIPLERESULTS: DBPROPENUM = 196i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MULTIPLESTORAGEOBJECTS: DBPROPENUM = 80i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MULTITABLEUPDATE: DBPROPENUM = 81i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFICATIONGRANULARITY: DBPROPENUM = 198i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFICATIONPHASES: DBPROPENUM = 82i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYCOLUMNSET: DBPROPENUM = 171i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWDELETE: DBPROPENUM = 173i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWFIRSTCHANGE: DBPROPENUM = 174i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWINSERT: DBPROPENUM = 175i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWRESYNCH: DBPROPENUM = 177i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWSETCHANGED: DBPROPENUM = 211i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWSETRELEASE: DBPROPENUM = 178i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE: DBPROPENUM = 179i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWUNDOCHANGE: DBPROPENUM = 180i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWUNDODELETE: DBPROPENUM = 181i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWUNDOINSERT: DBPROPENUM = 182i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NOTIFYROWUPDATE: DBPROPENUM = 183i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_NULLCOLLATION: DBPROPENUM = 83i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OLEOBJECTS: DBPROPENUM = 84i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ORDERBYCOLUMNSINSELECT: DBPROPENUM = 85i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ORDEREDBOOKMARKS: DBPROPENUM = 86i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OTHERINSERT: DBPROPENUM = 87i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OTHERUPDATEDELETE: DBPROPENUM = 88i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OUTPUTPARAMETERAVAILABILITY: DBPROPENUM = 184i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OWNINSERT: DBPROPENUM = 89i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OWNUPDATEDELETE: DBPROPENUM = 90i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PERSISTENTIDTYPE: DBPROPENUM = 185i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PREPAREABORTBEHAVIOR: DBPROPENUM = 91i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PREPARECOMMITBEHAVIOR: DBPROPENUM = 92i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROCEDURETERM: DBPROPENUM = 93i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROVIDERNAME: DBPROPENUM = 96i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROVIDEROLEDBVER: DBPROPENUM = 97i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROVIDERVER: DBPROPENUM = 98i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_QUICKRESTART: DBPROPENUM = 99i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_QUOTEDIDENTIFIERCASE: DBPROPENUM = 100i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_REENTRANTEVENTS: DBPROPENUM = 101i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_REMOVEDELETED: DBPROPENUM = 102i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_REPORTMULTIPLECHANGES: DBPROPENUM = 103i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_RETURNPENDINGINSERTS: DBPROPENUM = 189i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ROWRESTRICT: DBPROPENUM = 104i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ROWSETCONVERSIONSONCOMMAND: DBPROPENUM = 192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ROWTHREADMODEL: DBPROPENUM = 105i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SCHEMATERM: DBPROPENUM = 106i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SCHEMAUSAGE: DBPROPENUM = 107i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SERVERCURSOR: DBPROPENUM = 108i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SESS_AUTOCOMMITISOLEVELS: DBPROPENUM = 190i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SQLSUPPORT: DBPROPENUM = 109i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_STRONGIDENTITY: DBPROPENUM = 119i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_STRUCTUREDSTORAGE: DBPROPENUM = 111i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SUBQUERIES: DBPROPENUM = 112i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SUPPORTEDTXNDDL: DBPROPENUM = 161i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SUPPORTEDTXNISOLEVELS: DBPROPENUM = 113i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SUPPORTEDTXNISORETAIN: DBPROPENUM = 114i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TABLETERM: DBPROPENUM = 115i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TBL_TEMPTABLE: DBPROPENUM = 140i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TRANSACTEDOBJECT: DBPROPENUM = 116i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_UPDATABILITY: DBPROPENUM = 117i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_USERNAME: DBPROPENUM = 118i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM15 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_FILTERCOMPAREOPS: DBPROPENUM15 = 209i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_FINDCOMPAREOPS: DBPROPENUM15 = 210i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IChapteredRowset: DBPROPENUM15 = 202i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IDBAsynchStatus: DBPROPENUM15 = 203i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetFind: DBPROPENUM15 = 204i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetView: DBPROPENUM15 = 212i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IViewChapter: DBPROPENUM15 = 213i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IViewFilter: DBPROPENUM15 = 214i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IViewRowset: DBPROPENUM15 = 215i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IViewSort: DBPROPENUM15 = 216i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_ASYNCH: DBPROPENUM15 = 200i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXOPENCHAPTERS: DBPROPENUM15 = 199i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXORSINFILTER: DBPROPENUM15 = 205i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAXSORTCOLUMNS: DBPROPENUM15 = 206i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ROWSET_ASYNCH: DBPROPENUM15 = 201i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SORTONINDEX: DBPROPENUM15 = 207i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IMultipleResults: DBPROPENUM20 = 217i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_DATASOURCE_TYPE: DBPROPENUM20 = 251i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_AXES: DBPROPENUM20 = 252i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_FLATTENING_SUPPORT: DBPROPENUM20 = 253i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_JOINCUBES: DBPROPENUM20 = 254i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_NAMED_LEVELS: DBPROPENUM20 = 255i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_RANGEROWSET: DBPROPENUM20 = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_SLICER: DBPROPENUM20 = 218i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_CUBEQUALIFICATION: DBPROPENUM20 = 219i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_OUTERREFERENCE: DBPROPENUM20 = 220i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_QUERYBYPROPERTY: DBPROPENUM20 = 221i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_CASESUPPORT: DBPROPENUM20 = 222i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_STRING_COMPOP: DBPROPENUM20 = 224i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_DESCFLAGS: DBPROPENUM20 = 225i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_SET_FUNCTIONS: DBPROPENUM20 = 226i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_MEMBER_FUNCTIONS: DBPROPENUM20 = 227i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_NUMERIC_FUNCTIONS: DBPROPENUM20 = 228i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_FORMULAS: DBPROPENUM20 = 229i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_AGGREGATECELL_UPDATE: DBPROPENUM20 = 230i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_AGGREGATECELL_UPDATE: DBPROPENUM20 = 230i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_OBJQUALIFICATION: DBPROPENUM20 = 261i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_MDX_NONMEASURE_EXPRESSIONS: DBPROPENUM20 = 262i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ACCESSORDER: DBPROPENUM20 = 231i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_BOOKMARKINFO: DBPROPENUM20 = 232i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_CATALOG: DBPROPENUM20 = 233i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ROW_BULKOPS: DBPROPENUM20 = 234i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROVIDERFRIENDLYNAME: DBPROPENUM20 = 235i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_LOCKMODE: DBPROPENUM20 = 236i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MULTIPLECONNECTIONS: DBPROPENUM20 = 237i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_UNIQUEROWS: DBPROPENUM20 = 238i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SERVERDATAONINSERT: DBPROPENUM20 = 239i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_STORAGEFLAGS: DBPROPENUM20 = 240i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CONNECTIONSTATUS: DBPROPENUM20 = 244i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ALTERCOLUMN: DBPROPENUM20 = 245i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COLUMNLCID: DBPROPENUM20 = 246i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_RESETDATASOURCE: DBPROPENUM20 = 247i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_OLEDBSERVICES: DBPROPENUM20 = 248i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetRefresh: DBPROPENUM20 = 249i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SERVERNAME: DBPROPENUM20 = 250i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IParentRowset: DBPROPENUM20 = 257i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_HIDDENCOLUMNS: DBPROPENUM20 = 258i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PROVIDERMEMORY: DBPROPENUM20 = 259i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_CLIENTCURSOR: DBPROPENUM20 = 260i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TRUSTEE_USERNAME: DBPROPENUM21 = 241i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TRUSTEE_AUTHENTICATION: DBPROPENUM21 = 242i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TRUSTEE_NEWAUTHENTICATION: DBPROPENUM21 = 243i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRow: DBPROPENUM21 = 263i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowChange: DBPROPENUM21 = 264i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowSchemaChange: DBPROPENUM21 = 265i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IGetRow: DBPROPENUM21 = 266i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IScopedOperations: DBPROPENUM21 = 267i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IBindResource: DBPROPENUM21 = 268i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ICreateRow: DBPROPENUM21 = 269i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_BINDFLAGS: DBPROPENUM21 = 270i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_LOCKOWNER: DBPROPENUM21 = 271i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_GENERATEURL: DBPROPENUM21 = 273i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IDBBinderProperties: DBPROPENUM21 = 274i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IColumnsInfo2: DBPROPENUM21 = 275i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRegisterProvider: DBPROPENUM21 = 276i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IGetSession: DBPROPENUM21 = 277i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IGetSourceRow: DBPROPENUM21 = 278i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetCurrentIndex: DBPROPENUM21 = 279i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OPENROWSETSUPPORT: DBPROPENUM21 = 280i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_ISLONG: DBPROPENUM21 = 281i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM25 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_SEED: DBPROPENUM25 = 282i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COL_INCREMENT: DBPROPENUM25 = 283i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INIT_GENERALTIMEOUT: DBPROPENUM25 = 284i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_COMSERVICES: DBPROPENUM25 = 285i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM25_DEPRECATED = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ICommandCost: DBPROPENUM25_DEPRECATED = 141i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ICommandTree: DBPROPENUM25_DEPRECATED = 142i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_ICommandValidate: DBPROPENUM25_DEPRECATED = 143i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IDBSchemaCommand: DBPROPENUM25_DEPRECATED = 144i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IProvideMoniker: DBPROPENUM25_DEPRECATED = 125i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IQuery: DBPROPENUM25_DEPRECATED = 146i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IReadData: DBPROPENUM25_DEPRECATED = 147i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetAsynch: DBPROPENUM25_DEPRECATED = 148i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetCopyRows: DBPROPENUM25_DEPRECATED = 149i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetKeys: DBPROPENUM25_DEPRECATED = 151i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetNewRowAfter: DBPROPENUM25_DEPRECATED = 152i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetNextRowset: DBPROPENUM25_DEPRECATED = 153i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetWatchAll: DBPROPENUM25_DEPRECATED = 155i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetWatchNotify: DBPROPENUM25_DEPRECATED = 156i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetWatchRegion: DBPROPENUM25_DEPRECATED = 157i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetWithParameters: DBPROPENUM25_DEPRECATED = 158i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPENUM26 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OUTPUTSTREAM: DBPROPENUM26 = 286i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_OUTPUTENCODING: DBPROPENUM26 = 287i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_TABLESTATISTICS: DBPROPENUM26 = 288i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_SKIPROWCOUNTRESULTS: DBPROPENUM26 = 291i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_IRowsetBookmark: DBPROPENUM26 = 292i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDPROP_VISUALMODE: DBPROPENUM26 = 293i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPFLAGSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_NOTSUPPORTED: DBPROPFLAGSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_COLUMN: DBPROPFLAGSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_DATASOURCE: DBPROPFLAGSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_DATASOURCECREATE: DBPROPFLAGSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_DATASOURCEINFO: DBPROPFLAGSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_DBINIT: DBPROPFLAGSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_INDEX: DBPROPFLAGSENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_ROWSET: DBPROPFLAGSENUM = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_TABLE: DBPROPFLAGSENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_COLUMNOK: DBPROPFLAGSENUM = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_READ: DBPROPFLAGSENUM = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_WRITE: DBPROPFLAGSENUM = 1024i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_REQUIRED: DBPROPFLAGSENUM = 2048i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_SESSION: DBPROPFLAGSENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPFLAGSENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_TRUSTEE: DBPROPFLAGSENUM21 = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPFLAGSENUM25 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_VIEW: DBPROPFLAGSENUM25 = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPFLAGSENUM26 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_STREAM: DBPROPFLAGSENUM26 = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPFLAGS_PERSIST: u32 = 8192u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBPROPIDSET {
    pub rgPropertyIDs: *mut u32,
    pub cPropertyIDs: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBPROPIDSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBPROPIDSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBPROPIDSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPROPIDSET").field("rgPropertyIDs", &self.rgPropertyIDs).field("cPropertyIDs", &self.cPropertyIDs).field("guidPropertySet", &self.guidPropertySet).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBPROPIDSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBPROPIDSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPIDSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBPROPIDSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBPROPIDSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBPROPIDSET {
    pub rgPropertyIDs: *mut u32,
    pub cPropertyIDs: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBPROPIDSET {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBPROPIDSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBPROPIDSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBPROPIDSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPIDSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBPROPIDSET {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBPROPIDSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFO {
    pub pwszDescription: super::super::Foundation::PWSTR,
    pub dwPropertyID: u32,
    pub dwFlags: u32,
    pub vtType: u16,
    pub vValues: super::Com::VARIANT,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFO {
    fn clone(&self) -> Self {
        Self {
            pwszDescription: self.pwszDescription,
            dwPropertyID: self.dwPropertyID,
            dwFlags: self.dwFlags,
            vtType: self.vtType,
            vValues: self.vValues.clone(),
        }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszDescription == other.pwszDescription && self.dwPropertyID == other.dwPropertyID && self.dwFlags == other.dwFlags && self.vtType == other.vtType && self.vValues == other.vValues
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFO {
    pub pwszDescription: super::super::Foundation::PWSTR,
    pub dwPropertyID: u32,
    pub dwFlags: u32,
    pub vtType: u16,
    pub vValues: super::Com::VARIANT,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFOSET {
    pub rgPropertyInfos: *mut DBPROPINFO,
    pub cPropertyInfos: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPINFOSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFOSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::fmt::Debug for DBPROPINFOSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPROPINFOSET").field("rgPropertyInfos", &self.rgPropertyInfos).field("cPropertyInfos", &self.cPropertyInfos).field("guidPropertySet", &self.guidPropertySet).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFOSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFOSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFOSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFOSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFOSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPINFOSET {
    pub rgPropertyInfos: *mut DBPROPINFO,
    pub cPropertyInfos: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPINFOSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPINFOSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPINFOSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPINFOSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPINFOSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPINFOSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPINFOSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPOPTIONSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPOPTIONS_REQUIRED: DBPROPOPTIONSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPOPTIONS_SETIFCHEAP: DBPROPOPTIONSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPOPTIONS_OPTIONAL: DBPROPOPTIONSENUM = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPSET {
    pub rgProperties: *mut DBPROP,
    pub cProperties: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::fmt::Debug for DBPROPSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBPROPSET").field("rgProperties", &self.rgProperties).field("cProperties", &self.cProperties).field("guidPropertySet", &self.guidPropertySet).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPSET {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPSET>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPSET {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DBPROPSET {
    pub rgProperties: *mut DBPROP,
    pub cProperties: u32,
    pub guidPropertySet: ::windows::core::GUID,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::marker::Copy for DBPROPSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DBPROPSET {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DBPROPSET {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DBPROPSET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBPROPSET>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DBPROPSET {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DBPROPSET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DBPROPSET_MSDAORA8_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7f06a375_dd6a_43db_b4e0_1fc121e5e62b);
pub const DBPROPSET_MSDAORA_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8cc4cbd_fdff_11d0_b865_00a0c9081c1d);
pub const DBPROPSET_MSDSDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55cb91a8_5c7a_11d1_adad_00c04fc29863);
pub const DBPROPSET_MSDSSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedf17536_afbf_11d1_8847_0000f879f98c);
pub const DBPROPSET_PERSIST: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d7839a0_5b8e_11d1_a6b3_00a0c9138c66);
pub const DBPROPSET_PROVIDERCONNATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e4_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e0_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e2_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e1_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERSTMTATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e3_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_SQLSERVERCOLUMN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b63fb5e_3fbb_11d3_9f29_00c04f8ee9dc);
pub const DBPROPSET_SQLSERVERDATASOURCE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee4_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdf10cb94_35f6_11d2_9c54_00c04f7971d3);
pub const DBPROPSET_SQLSERVERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca10_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca11_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee5_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSTREAM: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f79c073_8a6d_4bca_a8a8_c9b79a9b962d);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_OK: DBPROPSTATUSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_NOTSUPPORTED: DBPROPSTATUSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_BADVALUE: DBPROPSTATUSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_BADOPTION: DBPROPSTATUSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_BADCOLUMN: DBPROPSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_NOTALLSETTABLE: DBPROPSTATUSENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_NOTSETTABLE: DBPROPSTATUSENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_NOTSET: DBPROPSTATUSENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_CONFLICTING: DBPROPSTATUSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBPROPSTATUSENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPSTATUS_NOTAVAILABLE: DBPROPSTATUSENUM21 = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_AO_RANDOM: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_AO_SEQUENTIAL: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_INITIALIZE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_POPULATEONDEMAND: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_PREPOPULATE: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_RANDOMPOPULATION: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BD_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BD_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BD_ROWSET: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BD_XTRANSACTION: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BI_CROSSROWSET: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BMK_KEY: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BMK_NUMERIC: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BO_NOINDEXUPDATE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BO_NOLOG: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_BO_REFINTEGRITY: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CB_DELETE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CB_NON_NULL: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CB_NULL: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CB_PRESERVE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CD_NOTNULL: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CL_END: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CL_START: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CM_TRANSACTIONS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_BEGINSWITH: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_CASEINSENSITIVE: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_CASESENSITIVE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_CONTAINS: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_EQUALITY: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CO_STRING: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CS_COMMUNICATIONFAILURE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CS_INITIALIZED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CS_UNINITIALIZED: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_CU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DF_INITIALLY_DEFERRED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DF_INITIALLY_IMMEDIATE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DF_NOT_DEFERRABLE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DST_DOCSOURCE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DST_MDP: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DST_TDP: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_DST_TDPANDMDP: i32 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_FU_CATALOG: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_FU_COLUMN: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_FU_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_FU_TABLE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GB_COLLATE: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GB_CONTAINS_SELECT: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GB_EQUALS_SELECT: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GB_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GB_NO_RELATION: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GU_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_GU_SUFFIX: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_HT_DIFFERENT_CATALOGS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_HT_DIFFERENT_PROVIDERS: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IC_LOWER: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IC_MIXED: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IC_SENSITIVE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IC_UPPER: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IN_ALLOWNULL: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IN_DISALLOWNULL: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IN_IGNOREANYNULL: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IN_IGNORENULL: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IT_BTREE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IT_CONTENT: i32 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IT_HASH: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_IT_OTHER: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_LM_INTENT: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_LM_NONE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_LM_READ: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_LM_RITE: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_LM_SINGLEROW: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_MR_CONCURRENT: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_MR_NOTSUPPORTED: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_MR_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NC_END: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NC_HIGH: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NC_LOW: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NC_START: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NP_ABOUTTODO: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NP_DIDEVENT: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NP_FAILEDTODO: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NP_OKTODO: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NP_SYNCHAFTER: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NT_MULTIPLEROWS: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_NT_SINGLEROW: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OA_ATEXECUTE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OA_ATROWRELEASE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OA_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_BLOB: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_DIRECTBIND: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_IPERSIST: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_ROWOBJECT: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_SCOPED: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OO_SINGLETON: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OP_EQUAL: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OP_RELATIVE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OP_STRING: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ORS_HISTOGRAM: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ORS_INDEX: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ORS_INTEGRATEDINDEX: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ORS_STOREDPROC: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_ORS_TABLE: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_AGR_AFTERSESSION: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_CLIENTCURSOR: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_DISABLEALL: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_ENABLEALL: i32 = -1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_RESOURCEPOOLING: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_OS_TXNENLISTMENT: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PERSIST_ADTG: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PERSIST_XML: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_GUID: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_GUID_NAME: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_GUID_PROPID: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_NAME: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_PGUID_NAME: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_PGUID_PROPID: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_PT_PROPID: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_RD_RESETALL: i32 = -1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_RT_APTMTTHREAD: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_RT_FREETHREAD: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_RT_SINGLETHREAD: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ANSI89_IEF: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ANSI92_ENTRY: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ANSI92_FULL: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ANSI92_INTERMEDIATE: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ESCAPECLAUSES: i32 = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_FIPS_TRANSITIONAL: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_NONE: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ODBC_CORE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ODBC_EXTENDED: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_ODBC_MINIMUM: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQL_SUBMINIMUM: i32 = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_COMPARISON: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_CORRELATEDSUBQUERIES: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_EXISTS: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_IN: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_QUANTIFIED: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SQ_TABLE: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SS_ILOCKBYTES: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SS_ISEQUENTIALSTREAM: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SS_ISTORAGE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SS_ISTREAM: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_CONVERT: u32 = 262144u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_DELETEONRELEASE: u32 = 2097152u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_DIRECT: u32 = 65536u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_FAILIFTHERE: u32 = 524288u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_PRIORITY: u32 = 1048576u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_STGM_TRANSACTED: u32 = 131072u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_SU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_ALL: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_DDL_COMMIT: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_DDL_IGNORE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_DDL_LOCK: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_DML: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TC_NONE: i32 = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_BROWSE: i32 = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_CHAOS: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_CURSORSTABILITY: i32 = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_ISOLATED: i32 = 1048576i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_READCOMMITTED: i32 = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_READUNCOMMITTED: i32 = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_REPEATABLEREAD: i32 = 65536i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TI_SERIALIZABLE: i32 = 1048576i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_ABORT: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_ABORT_DC: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_ABORT_NO: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_BOTH: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_COMMIT: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_COMMIT_DC: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_COMMIT_NO: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_DONTCARE: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_NONE: i32 = 256i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TR_OPTIMISTIC: i32 = 512i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TS_CARDINALITY: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_TS_HISTOGRAM: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_UP_CHANGE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_UP_DELETE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROPVAL_UP_INSERT: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_HCHAPTER: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_INTERLEAVEDROWS: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MAINTAINPROPS: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MSDAORA8_DETERMINEKEYCOLUMNS: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_MSDAORA_DETERMINEKEYCOLUMNS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PersistFormat: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_PersistSchema: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBPROP_Unicode: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBRANGEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_INCLUSIVESTART: DBRANGEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_INCLUSIVEEND: DBRANGEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_EXCLUSIVESTART: DBRANGEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_EXCLUSIVEEND: DBRANGEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_EXCLUDENULLS: DBRANGEENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_PREFIX: DBRANGEENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_MATCH: DBRANGEENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBRANGEENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_MATCH_N_SHIFT: DBRANGEENUM20 = 24i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRANGE_MATCH_N_MASK: DBRANGEENUM20 = 255i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBREASONENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_FETCHPOSITIONCHANGE: DBREASONENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_RELEASE: DBREASONENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_COLUMN_SET: DBREASONENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_COLUMN_RECALCULATED: DBREASONENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_ACTIVATE: DBREASONENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_RELEASE: DBREASONENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_DELETE: DBREASONENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_FIRSTCHANGE: DBREASONENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_INSERT: DBREASONENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_RESYNCH: DBREASONENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_UNDOCHANGE: DBREASONENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_UNDOINSERT: DBREASONENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_UNDODELETE: DBREASONENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_UPDATE: DBREASONENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_CHANGED: DBREASONENUM = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBREASONENUM15 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWPOSITION_CHANGED: DBREASONENUM15 = 15i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWPOSITION_CHAPTERCHANGED: DBREASONENUM15 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWPOSITION_CLEARED: DBREASONENUM15 = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROW_ASYNCHINSERT: DBREASONENUM15 = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBREASONENUM25 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_ROWSADDED: DBREASONENUM25 = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_POPULATIONCOMPLETE: DBREASONENUM25 = 20i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBREASON_ROWSET_POPULATIONSTOPPED: DBREASONENUM25 = 21i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBRESOURCEKINDENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_INVALID: DBRESOURCEKINDENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_TOTAL: DBRESOURCEKINDENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_CPU: DBRESOURCEKINDENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_MEMORY: DBRESOURCEKINDENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_DISK: DBRESOURCEKINDENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_NETWORK: DBRESOURCEKINDENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_RESPONSE: DBRESOURCEKINDENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_ROWS: DBRESOURCEKINDENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESOURCE_OTHER: DBRESOURCEKINDENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBRESULTFLAGENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESULTFLAG_DEFAULT: DBRESULTFLAGENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESULTFLAG_ROWSET: DBRESULTFLAGENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBRESULTFLAG_ROW: DBRESULTFLAGENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBROWCHANGEKINDENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWCHANGEKIND_INSERT: DBROWCHANGEKINDENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWCHANGEKIND_DELETE: DBROWCHANGEKINDENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWCHANGEKIND_UPDATE: DBROWCHANGEKINDENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWCHANGEKIND_COUNT: DBROWCHANGEKINDENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBROWSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_S_OK: DBROWSTATUSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_S_MULTIPLECHANGES: DBROWSTATUSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_S_PENDINGCHANGES: DBROWSTATUSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_CANCELED: DBROWSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_CANTRELEASE: DBROWSTATUSENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_CONCURRENCYVIOLATION: DBROWSTATUSENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_DELETED: DBROWSTATUSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_PENDINGINSERT: DBROWSTATUSENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_NEWLYINSERTED: DBROWSTATUSENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_INTEGRITYVIOLATION: DBROWSTATUSENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_INVALID: DBROWSTATUSENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED: DBROWSTATUSENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_OBJECTOPEN: DBROWSTATUSENUM = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_OUTOFMEMORY: DBROWSTATUSENUM = 15i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_PERMISSIONDENIED: DBROWSTATUSENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_LIMITREACHED: DBROWSTATUSENUM = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_SCHEMAVIOLATION: DBROWSTATUSENUM = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_E_FAIL: DBROWSTATUSENUM = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBROWSTATUSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBROWSTATUS_S_NOCHANGE: DBROWSTATUSENUM20 = 20i32;
pub const DBSCHEMA_LINKEDSERVERS: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9093caf4_2eac_11d1_9809_00c04fc2ad98);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSEEKENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_INVALID: DBSEEKENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_FIRSTEQ: DBSEEKENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_LASTEQ: DBSEEKENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_AFTEREQ: DBSEEKENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_AFTER: DBSEEKENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_BEFOREEQ: DBSEEKENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSEEK_BEFORE: DBSEEKENUM = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSORTENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSORT_ASCENDING: DBSORTENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSORT_DESCENDING: DBSORTENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSOURCETYPEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSOURCETYPE_DATASOURCE: DBSOURCETYPEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSOURCETYPE_ENUMERATOR: DBSOURCETYPEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSOURCETYPEENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSOURCETYPE_DATASOURCE_TDP: DBSOURCETYPEENUM20 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSOURCETYPE_DATASOURCE_MDP: DBSOURCETYPEENUM20 = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSOURCETYPEENUM25 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSOURCETYPE_BINDER: DBSOURCETYPEENUM25 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSTATUSENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_OK: DBSTATUSENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_BADACCESSOR: DBSTATUSENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_CANTCONVERTVALUE: DBSTATUSENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_ISNULL: DBSTATUSENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_TRUNCATED: DBSTATUSENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_SIGNMISMATCH: DBSTATUSENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_DATAOVERFLOW: DBSTATUSENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_CANTCREATE: DBSTATUSENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_UNAVAILABLE: DBSTATUSENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_PERMISSIONDENIED: DBSTATUSENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_INTEGRITYVIOLATION: DBSTATUSENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_SCHEMAVIOLATION: DBSTATUSENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_BADSTATUS: DBSTATUSENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_DEFAULT: DBSTATUSENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSTATUSENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const MDSTATUS_S_CELLEMPTY: DBSTATUSENUM20 = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_IGNORE: DBSTATUSENUM20 = 15i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSTATUSENUM21 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_DOESNOTEXIST: DBSTATUSENUM21 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_INVALIDURL: DBSTATUSENUM21 = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_RESOURCELOCKED: DBSTATUSENUM21 = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_RESOURCEEXISTS: DBSTATUSENUM21 = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_CANNOTCOMPLETE: DBSTATUSENUM21 = 20i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_VOLUMENOTFOUND: DBSTATUSENUM21 = 21i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_OUTOFSPACE: DBSTATUSENUM21 = 22i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_CANNOTDELETESOURCE: DBSTATUSENUM21 = 23i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_READONLY: DBSTATUSENUM21 = 24i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_RESOURCEOUTOFSCOPE: DBSTATUSENUM21 = 25i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_ALREADYEXISTS: DBSTATUSENUM21 = 26i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSTATUSENUM25 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_CANCELED: DBSTATUSENUM25 = 27i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_E_NOTCOLLECTION: DBSTATUSENUM25 = 28i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBSTATUSENUM26 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTATUS_S_ROWSETCOLUMN: DBSTATUSENUM26 = 29i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBTABLESTATISTICSTYPE26 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTAT_HISTOGRAM: DBTABLESTATISTICSTYPE26 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTAT_COLUMN_CARDINALITY: DBTABLESTATISTICSTYPE26 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBSTAT_TUPLE_CARDINALITY: DBTABLESTATISTICSTYPE26 = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct DBTIME {
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
}
impl ::core::marker::Copy for DBTIME {}
impl ::core::clone::Clone for DBTIME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DBTIME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBTIME").field("hour", &self.hour).field("minute", &self.minute).field("second", &self.second).finish()
    }
}
unsafe impl ::windows::core::Abi for DBTIME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DBTIME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIME>()) == 0 }
    }
}
impl ::core::cmp::Eq for DBTIME {}
impl ::core::default::Default for DBTIME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBTIMESTAMP {
    pub year: i16,
    pub month: u16,
    pub day: u16,
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
    pub fraction: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBTIMESTAMP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBTIMESTAMP {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBTIMESTAMP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBTIMESTAMP").field("year", &self.year).field("month", &self.month).field("day", &self.day).field("hour", &self.hour).field("minute", &self.minute).field("second", &self.second).field("fraction", &self.fraction).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBTIMESTAMP {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBTIMESTAMP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIMESTAMP>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBTIMESTAMP {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBTIMESTAMP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBTIMESTAMP {
    pub year: i16,
    pub month: u16,
    pub day: u16,
    pub hour: u16,
    pub minute: u16,
    pub second: u16,
    pub fraction: u32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBTIMESTAMP {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBTIMESTAMP {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBTIMESTAMP {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBTIMESTAMP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBTIMESTAMP>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBTIMESTAMP {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBTIMESTAMP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBTYPEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_EMPTY: DBTYPEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_NULL: DBTYPEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_I2: DBTYPEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_I4: DBTYPEENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_R4: DBTYPEENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_R8: DBTYPEENUM = 5i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_CY: DBTYPEENUM = 6i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_DATE: DBTYPEENUM = 7i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_BSTR: DBTYPEENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_IDISPATCH: DBTYPEENUM = 9i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_ERROR: DBTYPEENUM = 10i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_BOOL: DBTYPEENUM = 11i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_VARIANT: DBTYPEENUM = 12i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_IUNKNOWN: DBTYPEENUM = 13i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_DECIMAL: DBTYPEENUM = 14i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_UI1: DBTYPEENUM = 17i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_ARRAY: DBTYPEENUM = 8192i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_BYREF: DBTYPEENUM = 16384i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_I1: DBTYPEENUM = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_UI2: DBTYPEENUM = 18i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_UI4: DBTYPEENUM = 19i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_I8: DBTYPEENUM = 20i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_UI8: DBTYPEENUM = 21i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_GUID: DBTYPEENUM = 72i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_VECTOR: DBTYPEENUM = 4096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_RESERVED: DBTYPEENUM = 32768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_BYTES: DBTYPEENUM = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_STR: DBTYPEENUM = 129i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_WSTR: DBTYPEENUM = 130i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_NUMERIC: DBTYPEENUM = 131i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_UDT: DBTYPEENUM = 132i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_DBDATE: DBTYPEENUM = 133i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_DBTIME: DBTYPEENUM = 134i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_DBTIMESTAMP: DBTYPEENUM = 135i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBTYPEENUM15 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_HCHAPTER: DBTYPEENUM15 = 136i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBTYPEENUM20 = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_FILETIME: DBTYPEENUM20 = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_PROPVARIANT: DBTYPEENUM20 = 138i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_VARNUMERIC: DBTYPEENUM20 = 139i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBTYPE_SQLVARIANT: u32 = 144u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBUPDELRULEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUPDELRULE_NOACTION: DBUPDELRULEENUM = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUPDELRULE_CASCADE: DBUPDELRULEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUPDELRULE_SETNULL: DBUPDELRULEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBUPDELRULE_SETDEFAULT: DBUPDELRULEENUM = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct DBVECTOR {
    pub size: usize,
    pub ptr: *mut ::core::ffi::c_void,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for DBVECTOR {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for DBVECTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for DBVECTOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DBVECTOR").field("size", &self.size).field("ptr", &self.ptr).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for DBVECTOR {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for DBVECTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBVECTOR>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for DBVECTOR {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for DBVECTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct DBVECTOR {
    pub size: usize,
    pub ptr: *mut ::core::ffi::c_void,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for DBVECTOR {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for DBVECTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for DBVECTOR {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for DBVECTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DBVECTOR>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for DBVECTOR {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for DBVECTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBWATCHMODEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHMODE_ALL: DBWATCHMODEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHMODE_EXTEND: DBWATCHMODEENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHMODE_MOVE: DBWATCHMODEENUM = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHMODE_COUNT: DBWATCHMODEENUM = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DBWATCHNOTIFYENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHNOTIFY_ROWSCHANGED: DBWATCHNOTIFYENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHNOTIFY_QUERYDONE: DBWATCHNOTIFYENUM = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DBWATCHNOTIFY_QUERYREEXECUTED: DBWATCHNOTIFYENUM = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_ALL_EXCEPT_LIKE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_COLLECTION: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_DELAYFETCHCOLUMNS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_DELAYFETCHSTREAM: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_ISSTRUCTUREDDOCUMENT: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_OPENIFEXISTS: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_OUTPUT: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_OVERWRITE: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_BINDFLAGS_RECURSIVE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_COLLATION_ASC: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_COLLATION_DESC: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_COUNTUNAVAILABLE: i32 = -1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ABORTLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217871i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ALREADYINITIALIZED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217838i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ALTERRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217763i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ASYNCNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217771i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADACCESSORFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217850i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADACCESSORHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217920i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADACCESSORTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217845i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADBINDINFO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217912i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADBOOKMARK: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217906i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCHAPTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217914i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217903i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCOMMANDFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217780i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCOMMANDID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217802i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCOMPAREOP: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217881i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCONSTRAINTFORM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217800i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217781i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCONSTRAINTTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217801i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCONVERTFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217828i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADCOPY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217863i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADDEFERRABILITY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217799i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADDYNAMICERRORID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217830i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADHRESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217832i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADID: i32 = -2147217860i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217806i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADINITSTRING: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217805i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADLOCKMODE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217905i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADLOOKUPID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217831i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADMATCHTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217792i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADORDINAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217835i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADPARAMETERNAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217827i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADPRECISION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217862i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADPROPERTYVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217852i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADRATIO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217902i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADRECORDNUM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217854i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADREGIONHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217878i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217916i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217861i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSOURCEHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217840i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSTARTPOSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217890i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSTATUSVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217880i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSTORAGEFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217882i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADSTORAGEFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217849i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADTABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217860i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217859i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADTYPENAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217872i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADUPDATEDELETERULE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217782i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BADVALUES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217901i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BOGUS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217665i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217853i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_BYREFACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217848i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANCELED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217842i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANNOTCONNECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217770i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANNOTFREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217894i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANNOTRESTART: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217896i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTCANCEL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217899i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTCONVERTVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217913i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTFETCHBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217884i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTFILTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217825i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTORDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217824i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTSCROLLBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217879i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CANTTRANSLATE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217869i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CHAPTERNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217841i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_COLUMNUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217760i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_COMMANDNOTPERSISTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217817i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_CONCURRENCYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217864i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_COSTLIMIT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217907i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DATAOVERFLOW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217833i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217885i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DIALECTNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217898i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DROPRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217776i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATECOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217858i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATECONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217767i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATEDATASOURCE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217897i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217816i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATEINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217868i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_DUPLICATETABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217857i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ERRORSINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217900i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217887i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_GOALREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217892i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_INDEXINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217866i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_INTEGRITYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217873i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_INVALID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217851i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_INVALIDTRANSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217876i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_LIMITREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217909i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_MAXPENDCHANGESEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217836i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_MISMATCHEDPROVIDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217803i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_MULTIPLESTATEMENTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217874i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_MULTIPLESTORAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217826i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NEWLYINSERTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217893i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOAGGREGATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217886i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOCOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217819i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217908i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOCONSTRAINT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217761i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOINDEX: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217867i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOLOCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217855i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NONCONTIGUOUSRANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217877i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOPROVIDERSREGISTERED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217804i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOQUERY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217889i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOSOURCEOBJECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217775i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOSTATISTIC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217764i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217865i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTAREFERENCECOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217910i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTASUBREGION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217875i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTCOLLECTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217773i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTFOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217895i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTPREPARED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217846i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTREENTRANT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217888i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217837i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_NULLACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217847i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_OBJECTCREATIONLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217815i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_OBJECTMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217779i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_OBJECTOPEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217915i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_OUTOFSPACE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217766i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_PARAMNOTOPTIONAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217904i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217839i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_PENDINGCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217834i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_PENDINGINSERT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217829i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217772i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_READONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217918i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_RESOURCEEXISTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217768i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_RESOURCELOCKED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217774i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_RESOURCENOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217762i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_RESOURCEOUTOFSCOPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217778i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217919i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ROWSETINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217870i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_ROWSNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217883i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_SCHEMAVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217917i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_TABLEINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217856i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_TIMEOUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217769i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_UNSUPPORTEDCONVERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217891i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_E_WRITEONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217844i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_IMP_LEVEL_ANONYMOUS: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_IMP_LEVEL_DELEGATE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_IMP_LEVEL_IDENTIFY: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_IMP_LEVEL_IMPERSONATE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_IN: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_INVALID_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_INVALID_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_LIKE_ONLY: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_LOCAL_EXCLUSIVE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_LOCAL_SHARED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_READ: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_READWRITE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_SHARE_DENY_NONE: u32 = 16u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_SHARE_DENY_READ: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_SHARE_DENY_WRITE: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_SHARE_EXCLUSIVE: u32 = 12u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_MODE_WRITE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_NULL_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_NULL_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_NULL_HROW: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct DB_NUMERIC {
    pub precision: u8,
    pub scale: u8,
    pub sign: u8,
    pub val: [u8; 16],
}
impl ::core::marker::Copy for DB_NUMERIC {}
impl ::core::clone::Clone for DB_NUMERIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DB_NUMERIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DB_NUMERIC").field("precision", &self.precision).field("scale", &self.scale).field("sign", &self.sign).field("val", &self.val).finish()
    }
}
unsafe impl ::windows::core::Abi for DB_NUMERIC {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DB_NUMERIC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DB_NUMERIC>()) == 0 }
    }
}
impl ::core::cmp::Eq for DB_NUMERIC {}
impl ::core::default::Default for DB_NUMERIC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_OUT: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_CALL: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_CONNECT: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_NONE: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_PKT: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_PKT_INTEGRITY: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PROT_LEVEL_PKT_PRIVACY: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PT_FUNCTION: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PT_PROCEDURE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_PT_UNKNOWN: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_REMOTE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_SEARCHABLE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_SEC_E_AUTH_FAILED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217843i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_SEC_E_PERMISSIONDENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217911i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_SEC_E_SAFEMODE_DENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217765i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_ASYNCHRONOUS: ::windows::core::HRESULT = ::windows::core::HRESULT(265936i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265939i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(265923i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_BUFFERFULL: ::windows::core::HRESULT = ::windows::core::HRESULT(265928i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_CANTRELEASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265930i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_COLUMNSCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265937i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_COLUMNTYPEMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(265921i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_COMMANDREEXECUTED: ::windows::core::HRESULT = ::windows::core::HRESULT(265927i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(265940i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_DIALECTIGNORED: ::windows::core::HRESULT = ::windows::core::HRESULT(265933i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_ENDOFROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265926i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(265946i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_ERRORSRETURNED: ::windows::core::HRESULT = ::windows::core::HRESULT(265938i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_GOALCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265931i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_LOCKUPGRADED: ::windows::core::HRESULT = ::windows::core::HRESULT(265944i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_MULTIPLECHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265948i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_NONEXTROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265925i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_NORESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(265929i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_NOROWSPECIFICCOLUMNS: ::windows::core::HRESULT = ::windows::core::HRESULT(265949i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_NOTSINGLETON: ::windows::core::HRESULT = ::windows::core::HRESULT(265943i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265947i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_PROPERTIESCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265945i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(265920i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_STOPLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(265942i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_TOOMANYCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265941i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_TYPEINFOOVERRIDDEN: ::windows::core::HRESULT = ::windows::core::HRESULT(265922i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_UNWANTEDOPERATION: ::windows::core::HRESULT = ::windows::core::HRESULT(265932i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_UNWANTEDPHASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265934i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_S_UNWANTEDREASON: ::windows::core::HRESULT = ::windows::core::HRESULT(265935i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DB_UNSEARCHABLE: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct DB_VARNUMERIC {
    pub precision: u8,
    pub scale: i8,
    pub sign: u8,
    pub val: [u8; 1],
}
impl ::core::marker::Copy for DB_VARNUMERIC {}
impl ::core::clone::Clone for DB_VARNUMERIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DB_VARNUMERIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DB_VARNUMERIC").field("precision", &self.precision).field("scale", &self.scale).field("sign", &self.sign).field("val", &self.val).finish()
    }
}
unsafe impl ::windows::core::Abi for DB_VARNUMERIC {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DB_VARNUMERIC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DB_VARNUMERIC>()) == 0 }
    }
}
impl ::core::cmp::Eq for DB_VARNUMERIC {}
impl ::core::default::Default for DB_VARNUMERIC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
pub struct DCINFO {
    pub eInfoType: u32,
    pub vData: super::Com::VARIANT,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for DCINFO {
    fn clone(&self) -> Self {
        Self { eInfoType: self.eInfoType, vData: self.vData.clone() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for DCINFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for DCINFO {
    fn eq(&self, other: &Self) -> bool {
        self.eInfoType == other.eInfoType && self.vData == other.vData
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for DCINFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
impl ::core::default::Default for DCINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DCINFOTYPEENUM = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DCINFOTYPE_VERSION: DCINFOTYPEENUM = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type DELIVERY_AGENT_FLAGS = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DELIVERY_AGENT_FLAG_NO_BROADCAST: DELIVERY_AGENT_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DELIVERY_AGENT_FLAG_NO_RESTRICTIONS: DELIVERY_AGENT_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DELIVERY_AGENT_FLAG_SILENT_DIAL: DELIVERY_AGENT_FLAGS = 16i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_ALL: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_HITCOUNT: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_LASTSEENTIME: u32 = 10u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_PROPDISPID: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_PROPGUID: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_PROPMODIFIABLE: u32 = 9u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_PROPNAME: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_STORELEVEL: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_VROOTAUTOMATIC: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_VROOTMANUAL: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_METADATA_VROOTUSED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_RANK: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_RANKVECTOR: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_REVNAME: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_UNFILTERED: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_VIRTUALPATH: u32 = 9u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DISPID_QUERY_WORKID: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_ALREADYDISABLED: i32 = -2147220447i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_ALREADYENABLED: i32 = -2147220454i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_BADREQUEST: i32 = -2147220475i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_BADRESULT: i32 = -2147220445i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_BADSEQUENCE: i32 = -2147220473i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_BUFFERTOOSMALL: i32 = -2147220449i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_CANNOTREMOVECONCURRENT: i32 = -2147220443i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_CANNOTWRITEREGISTRY: i32 = -2147220444i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_CONFIGBAD: i32 = -2147220470i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_CONFIGNOTRIGHTTYPE: i32 = -2147220456i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_DATANOTPRESENT: i32 = -2147220464i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_DATASOURCENOTAVAILABLE: i32 = -2147220478i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_DATASOURCENOTDISABLED: i32 = -2147220459i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_DUPLICATEID: i32 = -2147220462i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_INDEXDIRECTORY: i32 = -2147220452i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_INVALIDCATALOGNAME: i32 = -2147220457i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_INVALIDDATASOURCE: i32 = -2147220479i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_INVALIDTAGDB: i32 = -2147220458i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_MESSAGETOOLONG: i32 = -2147220472i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_MISSINGCATALOG: i32 = -2147220440i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_NOMOREDATA: i32 = -2147220480i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_PARAMOUTOFRANGE: i32 = -2147220448i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_PROPVERSIONMISMATCH: i32 = -2147220441i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_PROTOCOLVERSION: i32 = -2147220455i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_QUERYCANCELED: i32 = -2147220477i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_QUERYHUNG: i32 = -2147220446i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_REGISTRY: i32 = -2147220460i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_SEARCHCATNAMECOLLISION: i32 = -2147220442i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_SERVERCAPACITY: i32 = -2147220474i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_SERVERERROR: i32 = -2147220471i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_SETSTATUSINPROGRESS: i32 = -2147220463i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_TOOMANYDATASOURCES: i32 = -2147220461i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_UNKNOWNPARAM: i32 = -2147220450i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_UNKNOWNREQUEST: i32 = -2147220476i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const DS_E_VALUETOOLARGE: i32 = -2147220451i32;
pub const DataLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206cdb2_19c1_11d1_89e0_00c04fd7a829);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct DataSource(::windows::core::IUnknown);
impl DataSource {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn getDataMember(&self, bstrdm: *const u16, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn getDataMemberName(&self, lindex: i32) -> ::windows::core::Result<*mut u16> {
        let mut result__: *mut u16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(&mut result__)).from_abi::<*mut u16>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn getDataMemberCount(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn addDataSourceListener<'a, Param0: ::windows::core::IntoParam<'a, DataSourceListener>>(&self, pdsl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pdsl.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn removeDataSourceListener<'a, Param0: ::windows::core::IntoParam<'a, DataSourceListener>>(&self, pdsl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pdsl.into_param().abi()).ok()
    }
}
impl ::core::convert::From<DataSource> for ::windows::core::IUnknown {
    fn from(value: DataSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DataSource> for ::windows::core::IUnknown {
    fn from(value: &DataSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for DataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSource {}
impl ::core::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DataSource {
    type Vtable = DataSourceVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab3_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, pbstrdm: *mut *mut u16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct DataSourceListener(::windows::core::IUnknown);
impl DataSourceListener {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn dataMemberChanged(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn dataMemberAdded(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn dataMemberRemoved(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(bstrdm)).ok()
    }
}
impl ::core::convert::From<DataSourceListener> for ::windows::core::IUnknown {
    fn from(value: DataSourceListener) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DataSourceListener> for ::windows::core::IUnknown {
    fn from(value: &DataSourceListener) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSourceListener {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DataSourceListener {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for DataSourceListener {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSourceListener {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSourceListener {}
impl ::core::fmt::Debug for DataSourceListener {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceListener").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DataSourceListener {
    type Vtable = DataSourceListenerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab2_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceListenerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct DataSourceObject(::windows::core::IUnknown);
impl DataSourceObject {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::Com::DISPPARAMS, pvarresult: *mut super::Com::VARIANT, pexcepinfo: *mut super::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DataSourceObject> for super::Com::IDispatch {
    fn from(value: DataSourceObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DataSourceObject> for super::Com::IDispatch {
    fn from(value: &DataSourceObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for &DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<DataSourceObject> for ::windows::core::IUnknown {
    fn from(value: DataSourceObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DataSourceObject> for ::windows::core::IUnknown {
    fn from(value: &DataSourceObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DataSourceObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for DataSourceObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSourceObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSourceObject {}
impl ::core::fmt::Debug for DataSourceObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceObject").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DataSourceObject {
    type Vtable = DataSourceObjectVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ae9a4e4_18d4_11d1_b3b3_00aa00c1a924);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceObjectVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::Com::DISPPARAMS, pvarresult: *mut super::Com::VARIANT, pexcepinfo: *mut super::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type EBindInfoOptions = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const BIO_BINDER: EBindInfoOptions = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct ERRORINFO {
    pub hrError: ::windows::core::HRESULT,
    pub dwMinor: u32,
    pub clsid: ::windows::core::GUID,
    pub iid: ::windows::core::GUID,
    pub dispid: i32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for ERRORINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for ERRORINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::fmt::Debug for ERRORINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ERRORINFO").field("hrError", &self.hrError).field("dwMinor", &self.dwMinor).field("clsid", &self.clsid).field("iid", &self.iid).field("dispid", &self.dispid).finish()
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for ERRORINFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for ERRORINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ERRORINFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for ERRORINFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for ERRORINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_System_Search'*"]
#[cfg(target_arch = "x86")]
pub struct ERRORINFO {
    pub hrError: ::windows::core::HRESULT,
    pub dwMinor: u32,
    pub clsid: ::windows::core::GUID,
    pub iid: ::windows::core::GUID,
    pub dispid: i32,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for ERRORINFO {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for ERRORINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for ERRORINFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for ERRORINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ERRORINFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for ERRORINFO {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for ERRORINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_FTE: u32 = 13824u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_FTE_CB: u32 = 51968u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_FTE_FD: u32 = 64768u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_CMDLINE: u32 = 5376u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_COLLATOR: u32 = 1280u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_CONNMGR: u32 = 1536u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_CONTENT_SOURCE: u32 = 13312u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_DATASOURCE: u32 = 1024u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_DAV: u32 = 8960u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_EXSTOREPH: u32 = 9984u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_FLTRDMN: u32 = 9216u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_GATHERER: u32 = 3328u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_INDEXER: u32 = 4352u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_MSS: u32 = 8448u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_NETWORKING: u32 = 768u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_NLADMIN: u32 = 6400u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_NOTESPH: u32 = 9728u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_OLEDB_BINDER: u32 = 9472u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_PEOPLE_IMPORT: u32 = 16384u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_PROTHNDLR: u32 = 4608u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_QUERY: u32 = 1792u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_REMOTE_EXSTOREPH: u32 = 13568u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_SCHEMA: u32 = 3072u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_SCRIPTPI: u32 = 8192u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_SECURITY: u32 = 5120u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_SETUP: u32 = 4864u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_SRCH_SCHEMA_CACHE: u32 = 13056u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ERROR_SOURCE_XML: u32 = 8704u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_AUDIENCECOMPUTATION_CANNOTSTART: i32 = -1073738223i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_AUTOCAT_CANT_CREATE_FILE_SHARE: i32 = -1073738726i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_AUTOCAT_PERFMON: i32 = -1073738753i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_CONFIG_ERROR: i32 = -1073738821i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_CONFIG_SYNTAX: i32 = -2147482604i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_CRAWL_SCHEDULED: i32 = 1073744884i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_DETAILED_FILTERPOOL_ADD_FAILED: i32 = -1073738719i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_DSS_NOT_ENABLED: i32 = -2147476572i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_ENUMERATE_SESSIONS_FAILED: i32 = -1073738720i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_EXCEPTION: i32 = -1073740815i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FAILED_CREATE_GATHERER_LOG: i32 = -2147480587i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FAILED_INITIALIZE_CRAWL: i32 = -1073738765i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FILTERPOOL_ADD_FAILED: i32 = -1073738722i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FILTERPOOL_DELETE_FAILED: i32 = -1073738721i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FILTER_HOST_FORCE_TERMINATE: i32 = -2147473624i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FILTER_HOST_NOT_INITIALIZED: i32 = -1073738724i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_FILTER_HOST_NOT_TERMINATED: i32 = -1073738723i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHERER_DATASOURCE: i32 = -1073738727i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHERER_PERFMON: i32 = -1073738817i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHERSVC_PERFMON: i32 = -1073738818i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_ADVISE_FAILED: i32 = -1073738798i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_APP_INIT_FAILED: i32 = -1073738766i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_AUTODESCENCODE_INVALID: i32 = -2147480592i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_AUTODESCLEN_ADJUSTED: i32 = -2147480603i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_BACKUPAPP_COMPLETE: i32 = 3077i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_BACKUPAPP_ERROR: i32 = -1073738748i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CANT_CREATE_DOCID: i32 = -1073738793i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CANT_DELETE_DOCID: i32 = -1073738792i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CHECKPOINT_CORRUPT: i32 = -1073738732i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CHECKPOINT_FAILED: i32 = -1073738736i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CHECKPOINT_FILE_MISSING: i32 = -1073738731i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRAWL_IN_PROGRESS: i32 = -2147480609i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRAWL_NOT_STARTED: i32 = -2147480625i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRAWL_SEED_ERROR: i32 = -2147480624i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED: i32 = -2147480612i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED_INIT: i32 = -2147480611i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_CRITICAL_ERROR: i32 = -1073738799i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_DAEMON_TERMINATED: i32 = -2147480570i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_DELETING_HISTORY_ITEMS: i32 = -1073738774i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_DIRTY_STARTUP: i32 = -2147480576i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_DISK_FULL: i32 = -2147480594i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_END_ADAPTIVE: i32 = 1073744891i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_END_CRAWL: i32 = 1073744842i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_END_INCREMENTAL: i32 = 1073744871i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_EXCEPTION: i32 = -1073738810i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_FLUSH_FAILED: i32 = -1073738737i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_FROM_NOT_SET: i32 = -1073738776i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_HISTORY_CORRUPTION_DETECTED: i32 = -2147480575i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_INTERNAL: i32 = -1073738804i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_INVALID_NETWORK_ACCESS_ACCOUNT: i32 = -1073738739i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_LOCK_FAILED: i32 = -1073738784i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_NO_CRAWL_SEEDS: i32 = -2147480602i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_NO_SCHEMA: i32 = -2147480593i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_OBJ_INIT_FAILED: i32 = -1073738796i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_PLUGINMGR_INIT_FAILED: i32 = -1073738767i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_PLUGIN_INIT_FAILED: i32 = -1073738795i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_INIT_FAILED: i32 = -1073738740i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_LOAD_FAILED: i32 = -1073738741i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_READ_CHECKPOINT_FAILED: i32 = -1073738733i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RECOVERY_FAILURE: i32 = -1073738222i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_REG_MISSING: i32 = -2147480610i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESET_START: i32 = 1073744865i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESTOREAPP_COMPLETE: i32 = 3075i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESTOREAPP_ERROR: i32 = -1073738750i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESTORE_CHECKPOINT_FAILED: i32 = -1073738734i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESTORE_COMPLETE: i32 = 3069i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESTORE_ERROR: i32 = -1073738754i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_RESUME: i32 = 1073744868i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_SAVE_FAILED: i32 = -1073738735i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_SERVICE_INIT: i32 = -1073738794i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_START_CRAWL: i32 = 1073744843i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_START_CRAWL_IF_RESET: i32 = -2147480595i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_START_PAUSE: i32 = -2147480606i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_STOP_START: i32 = 1073744876i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_SYSTEM_LCID_CHANGED: i32 = -2147480562i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_THROTTLE: i32 = 1073744867i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_GATHER_TRANSACTION_FAIL: i32 = -1073738797i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_HASHMAP_INSERT: i32 = -1073738816i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_HASHMAP_UPDATE: i32 = -1073738811i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_ADD_DSS_DISCONNECT: i32 = -2147476585i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_ADD_DSS_FAILED: i32 = -2147476627i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_ADD_DSS_SUCCEEDED: i32 = 7019i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_BUILD_ENDED: i32 = 1073748873i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_BUILD_FAILED: i32 = -1073734797i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_BUILD_START: i32 = 1073748872i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_CI_LOAD_ERROR: i32 = -1073734785i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_DSS_ALREADY_ADDED: i32 = 1073748870i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_DSS_CONTACT_FAILED: i32 = -1073734800i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_DSS_UNABLE_TO_REMOVE: i32 = -1073734755i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_FAIL_TO_CREATE_PER_USER_CATALOG: i32 = -1073731797i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_FAIL_TO_SET_MAX_JETINSTANCE: i32 = -1073731798i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_FAIL_TO_UNLOAD_PER_USER_CATALOG: i32 = -1073731796i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_INIT_ERROR: i32 = -1073734814i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_INVALID_DIRECTORY: i32 = -1073734813i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_LOAD_FAIL: i32 = -1073734781i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_MISSING_APP_DIRECTORY: i32 = -1073734758i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_NEW_PROJECT: i32 = -1073734754i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_NO_SEARCH_SERVERS: i32 = -2147476630i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_OUT_OF_DATABASE_INSTANCE: i32 = -1073731799i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PAUSED_FOR_DISKFULL: i32 = -1073734811i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PERFMON: i32 = -1073734760i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROPSTORE_INIT_FAILED: i32 = -1073734787i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_ABORTED: i32 = 1073748899i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_COMMITTED: i32 = 1073748898i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_COMMIT_FAILED: i32 = -1073734747i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_ERROR: i32 = -1073734812i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_STARTED: i32 = 1073748841i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_STATE_CORRUPT: i32 = -1073734780i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_STOPPED: i32 = -2147476633i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_PROP_SUCCEEDED: i32 = 7016i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_REG_ERROR: i32 = -1073734756i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_REG_MISSING: i32 = -1073734796i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_REMOVED_PROJECT: i32 = -1073734753i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_REMOVE_DSS_FAILED: i32 = -1073734801i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_REMOVE_DSS_SUCCEEDED: i32 = 7020i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_RESET_FOR_CORRUPTION: i32 = -1073734784i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_SCHEMA_COPY_ERROR: i32 = -1073734823i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_SHUTDOWN: i32 = 1073748866i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_STARTED: i32 = 1073748824i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_INDEXER_VERIFY_PROP_ACCOUNT: i32 = -1073734768i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LEARN_COMPILE_FAILED: i32 = -2147480583i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LEARN_CREATE_DB_FAILED: i32 = -2147480584i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LEARN_PROPAGATION_COPY_FAILED: i32 = -2147480585i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LEARN_PROPAGATION_FAILED: i32 = -2147480582i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LOCAL_GROUPS_CACHE_FLUSHED: i32 = 1073744920i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_LOCAL_GROUP_NOT_EXPANDED: i32 = 1073744919i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_NOTIFICATION_FAILURE: i32 = -1073738745i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_NOTIFICATION_FAILURE_SCOPE_EXCEEDED_LOGGING: i32 = -2147480568i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_NOTIFICATION_RESTORED: i32 = 1073744905i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_NOTIFICATION_RESTORED_SCOPE_EXCEEDED_LOGGING: i32 = -2147480566i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_NOTIFICATION_THREAD_EXIT_FAILED: i32 = -1073738725i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_OUTOFMEMORY: i32 = -1073740817i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_PERF_COUNTERS_ALREADY_EXISTS: i32 = -2147473626i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_PERF_COUNTERS_NOT_LOADED: i32 = -2147473628i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_PERF_COUNTERS_REGISTRY_TROUBLE: i32 = -2147473627i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_PROTOCOL_HOST_FORCE_TERMINATE: i32 = -2147473625i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_REG_VERSION: i32 = -1073738790i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_CREATE_PATH_RULES_FAILED: i32 = -2147482634i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_CSM_SAVE_FAILED: i32 = -1073740805i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_FAILED: i32 = -1073740808i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_ROLLBACK_ERRORS: i32 = -2147482630i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_SUCCEEDED: i32 = 1073742841i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_DROPPED_EVENTS: i32 = -2147482633i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_FAILED: i32 = -1073740813i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_STARTED: i32 = -2147482640i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_SUCCEEDED: i32 = 1073742834i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_SETUP_FAILED: i32 = -1073740818i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_SETUP_SUCCEEDED: i32 = 1073742829i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_STARTED: i32 = 1073742827i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_STARTING_SETUP: i32 = 1073742828i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SSSEARCH_STOPPED: i32 = 1073742837i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_STS_INIT_SECURITY_FAILED: i32 = -2147480554i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_SYSTEM_EXCEPTION: i32 = -2147482595i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_TRANSACTION_READ: i32 = -1073738809i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_TRANSLOG_APPEND: i32 = -1073738814i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_TRANSLOG_CREATE: i32 = -1073738791i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_TRANSLOG_CREATE_TRX: i32 = -1073738815i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_TRANSLOG_UPDATE: i32 = -1073738813i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_UNPRIVILEGED_SERVICE_ACCOUNT: i32 = -2147482596i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_USING_DIFFERENT_WORD_BREAKER: i32 = -2147480580i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILE: i32 = -2147473634i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILES: i32 = -2147473635i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_WBREAKER_NOT_LOADED: i32 = -2147480586i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EVENT_WIN32_ERROR: i32 = -2147473633i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_ACCESS_DENIED: i32 = -2147216990i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_BADCONFIG_OR_ACCESSDENIED: i32 = -2147216988i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_INVALID_ACCOUNT_INFO: i32 = -2147216984i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_INVALID_EXCHANGE_SERVER: i32 = -2147216989i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_INVALID_SERVER_CONFIG: i32 = -2147216991i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_NOT_ADMIN_OR_WRONG_SITE: i32 = -2147216986i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_NO_CONFIG: i32 = -2147216992i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_NO_MAPI: i32 = -2147216985i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXCI_E_WRONG_SERVER_OR_ACCT: i32 = -2147216987i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EXSTOREPH_E_UNEXPECTED: i32 = -2147211519i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_ANY: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_CMDFATAL: u32 = 20u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_CONTROL: u32 = 25u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_DBCORRUPT: u32 = 23u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_DBFATAL: u32 = 21u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_DEADLOCK: u32 = 13u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_HARDWARE: u32 = 24u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_INFO: u32 = 10u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_INTOK: u32 = 18u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_LIMIT: u32 = 19u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_MAXISEVERITY: u32 = 10u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_MISSING: u32 = 11u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_PERMIT: u32 = 14u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_RESOURCE: u32 = 17u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_SYNTAX: u32 = 15u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_TABCORRUPT: u32 = 22u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_TYPE: u32 = 12u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const EX_USER: u32 = 16u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FAIL: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILTERED_DATA_SOURCES {
    pub pwcsExtension: super::super::Foundation::PWSTR,
    pub pwcsMime: super::super::Foundation::PWSTR,
    pub pClsid: *mut ::windows::core::GUID,
    pub pwcsOverride: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILTERED_DATA_SOURCES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILTERED_DATA_SOURCES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for FILTERED_DATA_SOURCES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FILTERED_DATA_SOURCES").field("pwcsExtension", &self.pwcsExtension).field("pwcsMime", &self.pwcsMime).field("pClsid", &self.pClsid).field("pwcsOverride", &self.pwcsOverride).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILTERED_DATA_SOURCES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILTERED_DATA_SOURCES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILTERED_DATA_SOURCES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILTERED_DATA_SOURCES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILTERED_DATA_SOURCES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FLTRDMN_E_CANNOT_DECRYPT_PASSWORD: i32 = -2147212282i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FLTRDMN_E_ENCRYPTED_DOCUMENT: i32 = -2147212283i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FLTRDMN_E_FILTER_INIT_FAILED: i32 = -2147212284i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FLTRDMN_E_QI_FILTER_FAILED: i32 = -2147212286i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FLTRDMN_E_UNEXPECTED: i32 = -2147212287i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type FOLLOW_FLAGS = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FF_INDEXCOMPLEXURLS: FOLLOW_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FF_SUPPRESSINDEXING: FOLLOW_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_ADMIN_BLOB_CORRUPT: i32 = -2147207676i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_AFFINITY_MASK: i32 = -2147207651i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_ALREADY_INITIALIZED: i32 = -2147207604i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_ANOTHER_STATUS_CHANGE_IS_ALREADY_ACTIVE: i32 = -2147207635i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_BATCH_ABORTED: i32 = -2147207636i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CATALOG_ALREADY_EXISTS: i32 = -2147207656i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CATALOG_DOES_NOT_EXIST: i32 = -2147207639i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CB_CBID_OUT_OF_BOUND: i32 = -2147169535i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CB_NOT_ENOUGH_AVAIL_PHY_MEM: i32 = -2147169534i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CB_NOT_ENOUGH_OCC_BUFFER: i32 = -2147169533i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CB_OUT_OF_MEMORY: i32 = -2147169536i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_COM_SIGNATURE_VALIDATION: i32 = -2147207652i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CORRUPT_GATHERER_HASH_MAP: i32 = -2147207619i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CORRUPT_PROPERTY_STORE: i32 = -2147207622i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_CORRUPT_WORDLIST: i32 = -2147169532i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_DATATYPE_MISALIGNMENT: i32 = -2147207605i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_DEPENDENT_TRAN_FAILED_TO_PERSIST: i32 = -2147207641i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_DOC_TOO_HUGE: i32 = -2147207606i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_DUPLICATE_OBJECT: i32 = -2147207644i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_ERROR_WRITING_REGISTRY: i32 = -2147207674i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_EXCEEDED_MAX_PLUGINS: i32 = -2147207647i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FAILED_TO_CREATE_ACCESSOR: i32 = -2147207625i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FAILURE_TO_POST_SETCOMPLETION_STATUS: i32 = -2147207597i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_DID_NOT_CONNECT: i32 = -2147207660i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_DOC_TIMEOUT: i32 = -2147156733i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_DOC_UNEXPECTED_EXIT: i32 = -2147156731i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_FAILED_TO_LOAD_IFILTER: i32 = -2147156734i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_FILTER_CAUSED_SHARING_VIOLATION: i32 = -2147156725i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_IDLE: i32 = -2147207595i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_IFILTER_INIT_FAILED: i32 = -2147156735i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_NOISE_NO_IPERSISTSTREAM_ON_TEXT_FILTER: i32 = -2147156729i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_NOISE_NO_TEXT_FILTER: i32 = -2147156730i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_NOISE_TEXT_FILTER_INIT_FAILED: i32 = -2147156727i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_NOISE_TEXT_FILTER_LOAD_FAILED: i32 = -2147156728i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_NO_IPERSIST_INTERFACE: i32 = -2147156736i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_OCCURRENCE_OVERFLOW: i32 = -2147156726i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_OWNERSHIP_OBSOLETE: i32 = -2147207650i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_SHUTDOWN: i32 = -2147207640i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_TIMEOUT: i32 = -2147207632i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_UNEXPECTED_EXIT: i32 = -2147156732i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_UNRESPONSIVE: i32 = -2147207594i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FD_USED_TOO_MUCH_MEMORY: i32 = -2147207603i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_FILTER_SINGLE_THREADED: i32 = -2147207675i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_HIGH_MEMORY_PRESSURE: i32 = -2147207601i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_CODEPAGE: i32 = -2147207596i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_DOCID: i32 = -2147207663i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_ISOLATE_ERROR_BATCH: i32 = -2147207600i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_PROG_ID: i32 = -2147207614i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_PROJECT_ID: i32 = -2147207598i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_PROPERTY: i32 = -2147207630i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_INVALID_TYPE: i32 = -2147207624i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_KEY_NOT_CACHED: i32 = -2147207618i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_LIBRARY_NOT_LOADED: i32 = -2147207627i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_NOT_PROCESSED_DUE_TO_PREVIOUS_ERRORS: i32 = -2147207633i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_NO_MORE_PROPERTIES: i32 = -2147207629i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_NO_PLUGINS: i32 = -2147207638i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_NO_PROPERTY_STORE: i32 = -1073465766i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_OUT_OF_RANGE: i32 = -2147207623i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PATH_TOO_LONG: i32 = -2147207654i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PAUSE_EXTERNAL: i32 = -2147207662i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PERFMON_FULL: i32 = -2147207626i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PERF_NOT_LOADED: i32 = -2147207611i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PIPE_DATA_CORRUPTED: i32 = -2147207671i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PIPE_NOT_CONNECTED: i32 = -2147207677i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PROGID_REQUIRED: i32 = -2147207658i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PROJECT_NOT_INITALIZED: i32 = -2147207672i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PROJECT_SHUTDOWN: i32 = -2147207673i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_PROPERTY_STORE_WORKID_NOTVALID: i32 = -2147207621i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_READONLY_CATALOG: i32 = -2147207612i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_REDUNDANT_TRAN_FAILURE: i32 = -2147207642i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_REJECTED_DUE_TO_PROJECT_STATUS: i32 = -2147207661i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_RESOURCE_SHUTDOWN: i32 = -2147207631i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_RETRY_HUGE_DOC: i32 = -2147207608i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_RETRY_SINGLE_DOC_PER_BATCH: i32 = -2147207599i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_SECRET_NOT_FOUND: i32 = -2147207678i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_SERIAL_STREAM_CORRUPT: i32 = -2147207613i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_STACK_CORRUPTED: i32 = -2147207615i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_STATIC_THREAD_INVALID_ARGUMENTS: i32 = -2147207657i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_UNEXPECTED_EXIT: i32 = -2147207602i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_UNKNOWN_FD_TYPE: i32 = -2147207607i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_UNKNOWN_PLUGIN: i32 = -2147207628i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_UPGRADE_INTERFACE_ALREADY_INSTANTIATED: i32 = -2147207616i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_UPGRADE_INTERFACE_ALREADY_SHUTDOWN: i32 = -2147207617i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_E_URB_TOO_BIG: i32 = -2147207664i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_INVALID_ADMIN_CLIENT: i32 = -2147207653i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_BEYOND_QUOTA: i32 = 276002i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_CATALOG_BLOB_MISMATCHED: i32 = 276056i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_PROPERTY_RESET: i32 = 276057i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_PROPERTY_STORE_END_OF_ENUMERATION: i32 = 276028i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_READONLY_CATALOG: i32 = 276038i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_REDUNDANT: i32 = 276005i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_RESOURCES_STARTING_TO_GET_LOW: i32 = 275993i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_RESUME: i32 = 276014i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_STATUS_CHANGE_REQUEST: i32 = 276011i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const FTE_S_TRY_TO_FLUSH: i32 = 276055i32;
pub const FilterRegistration: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e175b8d_f52a_11d8_b9a5_505054503030);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GENERATE_METHOD_PREFIXMATCH: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GENERATE_METHOD_STEMMED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GHTR_E_INSUFFICIENT_DISK_SPACE: i32 = -2147218037i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GHTR_E_LOCAL_SERVER_UNAVAILABLE: i32 = -2147218055i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_ADDLINKS_FAILED_WILL_RETRY_PARENT: i32 = -2147217989i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_APPLICATION_NOT_FOUND: i32 = -2147218079i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_AUTOCAT_UNEXPECTED: i32 = -2147218012i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_BACKUP_VALIDATION_FAIL: i32 = -2147217994i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_BAD_FILTER_DAEMON: i32 = -2147218119i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_BAD_FILTER_HOST: i32 = -2147217993i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_CANNOT_ENABLE_CHECKPOINT: i32 = -2147218002i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_CANNOT_REMOVE_PLUGINMGR: i32 = -2147218078i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_CONFIG_DUP_EXTENSION: i32 = -2147218165i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_CONFIG_DUP_PROJECT: i32 = -2147218166i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_CONTENT_ID_CONFLICT: i32 = -2147218062i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_DIRMON_NOT_INITIALZED: i32 = -2147218019i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_DUPLICATE_OBJECT: i32 = -2147218174i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_DUPLICATE_PROJECT: i32 = -2147218094i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_DUPLICATE_URL: i32 = -2147218163i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_DUP_PROPERTY_MAPPING: i32 = -2147218134i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_EMPTY_DACL: i32 = -2147218006i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_ERROR_INITIALIZING_PERFMON: i32 = -2147218171i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_ERROR_OBJECT_NOT_FOUND: i32 = -2147218170i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_ERROR_WRITING_REGISTRY: i32 = -2147218172i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTERPOOL_NOTFOUND: i32 = -2147217990i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_FAULT: i32 = -2147218075i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_INIT: i32 = -2147218130i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_INTERRUPTED: i32 = -2147218092i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_INVALID_MESSAGE: i32 = -2147218158i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_NOT_FOUND: i32 = -2147218154i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_NO_CODEPAGE: i32 = -2147218123i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_NO_MORE_THREADS: i32 = -2147218153i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_PROCESS_TERMINATED: i32 = -2147218159i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_PROCESS_TERMINATED_QUOTA: i32 = -2147218151i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FILTER_SINGLE_THREADED: i32 = -2147218069i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FOLDER_CRAWLED_BY_ANOTHER_WORKSPACE: i32 = -2147218007i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FORCE_NOTIFICATION_RESET: i32 = -2147218065i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_FROM_NOT_SPECIFIED: i32 = -2147218109i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_IE_OFFLINE: i32 = -2147218120i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INSUFFICIENT_EXAMPLE_CATEGORIES: i32 = -2147218014i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INSUFFICIENT_EXAMPLE_DOCUMENTS: i32 = -2147218013i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INSUFFICIENT_FEATURE_TERMS: i32 = -2147218015i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALIDFUNCTION: i32 = -2147218161i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_ACCOUNT: i32 = -2147218132i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_ACCOUNT_SYNTAX: i32 = -2147218129i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_APPLICATION_NAME: i32 = -2147218077i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_CALL_FROM_WBREAKER: i32 = -2147218058i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_DIRECTORY: i32 = -2147218093i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_EXTENSION: i32 = -2147218107i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_GROW_FACTOR: i32 = -2147218106i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_HOST_NAME: i32 = -2147218096i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_LOG_FILE_NAME: i32 = -2147218103i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_MAPPING: i32 = -2147218112i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_PATH: i32 = -2147218124i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_PATH_EXPRESSION: i32 = -2147218088i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_PATH_SPEC: i32 = -2147218016i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_PROJECT_NAME: i32 = -2147218142i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_PROXY_PORT: i32 = -2147218091i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_RESOURCE_ID: i32 = -2147218035i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_RETRIES: i32 = -2147218104i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_START_ADDRESS: i32 = -2147217998i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_START_PAGE: i32 = -2147218095i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_START_PAGE_HOST: i32 = -2147218087i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_START_PAGE_PATH: i32 = -2147218080i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_STREAM_LOGS_COUNT: i32 = -2147218108i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_INVALID_TIME_OUT: i32 = -2147218105i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_JET_BACKUP_ERROR: i32 = -2147218026i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_JET_RESTORE_ERROR: i32 = -2147218025i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_LOCAL_GROUPS_EXPANSION_INTERNAL_ERROR: i32 = -2147216867i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NAME_TOO_LONG: i32 = -2147218156i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NESTED_HIERARCHICAL_START_ADDRESSES: i32 = -2147218034i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOFILTERSINK: i32 = -2147218160i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NON_FIXED_DRIVE: i32 = -2147218074i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIFICATION_FILE_SHARE_INFO_NOT_AVAILABLE: i32 = -2147218040i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIFICATION_LOCAL_PATH_MUST_USE_FIXED_DRIVE: i32 = -2147218039i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIFICATION_START_ADDRESS_INVALID: i32 = -2147218042i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIFICATION_START_PAGE: i32 = -2147218137i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIFICATION_TYPE_NOT_SUPPORTED: i32 = -2147218041i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIF_ACCESS_TOKEN_UPDATED: i32 = -2147218020i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIF_BEING_REMOVED: i32 = -2147218018i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NOTIF_EXCESSIVE_THROUGHPUT: i32 = -2147218017i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NO_IDENTITY: i32 = -2147218155i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NO_PRTCLHNLR: i32 = -2147218121i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_NTF_CLIENT_NOT_SUBSCRIBED: i32 = -1073476167i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_OBJECT_NOT_VALID: i32 = -2147218005i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_OUT_OF_DOC_ID: i32 = -2147218138i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PIPE_NOT_CONNECTTED: i32 = -2147217996i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PLUGIN_NOT_REGISTERED: i32 = -2147218021i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PROJECT_NOT_INITIALIZED: i32 = -2147218149i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PROPERTIES_EXCEEDED: i32 = -2147218000i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PROPERTY_LIST_NOT_INITIALIZED: i32 = -2147218057i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PROXY_NAME: i32 = -2147218127i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_PRT_HNDLR_PROGID_MISSING: i32 = -2147218152i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_RECOVERABLE_EXOLEDB_ERROR: i32 = -2147218060i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_RETRY: i32 = -2147218027i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SCHEMA_ERRORS_OCCURRED: i32 = -2147218054i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SCOPES_EXCEEDED: i32 = -2147218001i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SECRET_NOT_FOUND: i32 = -2147218089i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SERVER_UNAVAILABLE: i32 = -2147218126i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SHUTTING_DOWN: i32 = -2147218141i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_SINGLE_THREADED_EMBEDDING: i32 = -2147218011i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_TIMEOUT: i32 = -2147218053i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_TOO_MANY_PLUGINS: i32 = -2147218162i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_UNABLE_TO_READ_EXCHANGE_STORE: i32 = -2147218061i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_UNABLE_TO_READ_REGISTRY: i32 = -2147218173i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_UNKNOWN_PROTOCOL: i32 = -2147218150i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_UNSUPPORTED_PROPERTY_TYPE: i32 = -2147218157i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_URL_EXCLUDED: i32 = -2147218169i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_URL_UNIDENTIFIED: i32 = -2147218067i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_USER_AGENT_NOT_SPECIFIED: i32 = -2147218111i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_E_VALUE_NOT_AVAILABLE: i32 = -2147218139i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_BAD_FILE_LINK: i32 = 265580i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CANNOT_FILTER: i32 = 265520i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CANNOT_WORDBREAK: i32 = 265638i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CONFIG_HAS_ACCOUNTS: i32 = 265558i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CRAWL_ADAPTIVE: i32 = 265605i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CRAWL_FULL: i32 = 265603i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CRAWL_INCREMENTAL: i32 = 265604i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_CRAWL_SCHEDULED: i32 = 265576i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_END_PROCESS_LOOP_NOTIFY_QUEUE: i32 = 265584i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_END_STD_CHUNKS: i32 = 265508i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_MODIFIED_PARTS: i32 = 265592i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_NOT_ALL_PARTS: i32 = 265582i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_NO_CRAWL_SEEDS: i32 = 265515i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_NO_INDEX: i32 = 265616i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_OFFICE_CHILD: i32 = 265626i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_PAUSE_REASON_BACKOFF: i32 = 265620i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_PAUSE_REASON_EXTERNAL: i32 = 265618i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_PAUSE_REASON_PROFILE_IMPORT: i32 = 265651i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_PAUSE_REASON_UPGRADING: i32 = 265619i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_PROB_NOT_MODIFIED: i32 = 265575i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_START_FILTER_FROM_BODY: i32 = 265585i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_START_FILTER_FROM_PROTOCOL: i32 = 265578i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_CHANGE_IGNORED: i32 = 265500i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_END_CRAWL: i32 = 265501i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_PAUSE: i32 = 265505i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_RESET: i32 = 265502i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_RESUME: i32 = 265504i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_START: i32 = 265526i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_STOP: i32 = 265523i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_STATUS_THROTTLE: i32 = 265503i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_TRANSACTION_IGNORED: i32 = 265577i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const GTHR_S_USE_MIME_FILTER: i32 = 265639i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search'*"]
pub struct HITRANGE {
    pub iPosition: u32,
    pub cLength: u32,
}
impl ::core::marker::Copy for HITRANGE {}
impl ::core::clone::Clone for HITRANGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HITRANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HITRANGE").field("iPosition", &self.iPosition).field("cLength", &self.cLength).finish()
    }
}
unsafe impl ::windows::core::Abi for HITRANGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HITRANGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HITRANGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for HITRANGE {}
impl ::core::default::Default for HITRANGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IAccessor(::windows::core::IUnknown);
impl IAccessor {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRefAccessor(&self, haccessor: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateAccessor(&self, dwaccessorflags: u32, cbindings: usize, rgbindings: *const DBBINDING, cbrowsize: usize, phaccessor: *mut usize, rgstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwaccessorflags), ::core::mem::transmute(cbindings), ::core::mem::transmute(rgbindings), ::core::mem::transmute(cbrowsize), ::core::mem::transmute(phaccessor), ::core::mem::transmute(rgstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetBindings(&self, haccessor: usize, pdwaccessorflags: *mut u32, pcbindings: *mut usize, prgbindings: *mut *mut DBBINDING) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdwaccessorflags), ::core::mem::transmute(pcbindings), ::core::mem::transmute(prgbindings)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseAccessor(&self, haccessor: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAccessor> for ::windows::core::IUnknown {
    fn from(value: IAccessor) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessor> for ::windows::core::IUnknown {
    fn from(value: &IAccessor) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAccessor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAccessor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAccessor {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessor {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessor {}
impl ::core::fmt::Debug for IAccessor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessor").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessor {
    type Vtable = IAccessorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwaccessorflags: u32, cbindings: usize, rgbindings: *const DBBINDING, cbrowsize: usize, phaccessor: *mut usize, rgstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pdwaccessorflags: *mut u32, pcbindings: *mut usize, prgbindings: *mut *mut DBBINDING) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IAlterIndex(::windows::core::IUnknown);
impl IAlterIndex {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterIndex(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(pnewindexid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IAlterIndex> for ::windows::core::IUnknown {
    fn from(value: IAlterIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAlterIndex> for ::windows::core::IUnknown {
    fn from(value: &IAlterIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAlterIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAlterIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAlterIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterIndex {}
impl ::core::fmt::Debug for IAlterIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAlterIndex {
    type Vtable = IAlterIndexVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa6_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterIndexVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IAlterTable(::windows::core::IUnknown);
impl IAlterTable {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterColumn(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut DBCOLUMNDESC) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid), ::core::mem::transmute(dwcolumndescflags), ::core::mem::transmute(pcolumndesc)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterTable(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pnewtableid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IAlterTable> for ::windows::core::IUnknown {
    fn from(value: IAlterTable) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAlterTable> for ::windows::core::IUnknown {
    fn from(value: &IAlterTable) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAlterTable {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAlterTable {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAlterTable {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterTable {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterTable {}
impl ::core::fmt::Debug for IAlterTable {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterTable").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAlterTable {
    type Vtable = IAlterTableVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterTableVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut DBCOLUMNDESC) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IBindResource(::windows::core::IUnknown);
impl IBindResource {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Bind<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppunk)).ok()
    }
}
impl ::core::convert::From<IBindResource> for ::windows::core::IUnknown {
    fn from(value: IBindResource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBindResource> for ::windows::core::IUnknown {
    fn from(value: &IBindResource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBindResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBindResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBindResource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBindResource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBindResource {}
impl ::core::fmt::Debug for IBindResource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBindResource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBindResource {
    type Vtable = IBindResourceVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab1_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBindResourceVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: ::windows::core::RawPtr, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IChapteredRowset(::windows::core::IUnknown);
impl IChapteredRowset {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRefChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IChapteredRowset> for ::windows::core::IUnknown {
    fn from(value: IChapteredRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IChapteredRowset> for ::windows::core::IUnknown {
    fn from(value: &IChapteredRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IChapteredRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IChapteredRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IChapteredRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IChapteredRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IChapteredRowset {}
impl ::core::fmt::Debug for IChapteredRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IChapteredRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IChapteredRowset {
    type Vtable = IChapteredRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a93_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IChapteredRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IColumnMapper(::windows::core::IUnknown);
impl IColumnMapper {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetPropInfoFromName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, wcspropname: Param0, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), wcspropname.into_param().abi(), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetPropInfoFromId(&self, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppropid), ::core::mem::transmute(pwcsname), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn EnumPropInfo(&self, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ientry), ::core::mem::transmute(pwcsname), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn IsMapUpToDate(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IColumnMapper> for ::windows::core::IUnknown {
    fn from(value: IColumnMapper) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnMapper> for ::windows::core::IUnknown {
    fn from(value: &IColumnMapper) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnMapper {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnMapper {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnMapper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapper {}
impl ::core::fmt::Debug for IColumnMapper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapper").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnMapper {
    type Vtable = IColumnMapperVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37a_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapperVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcspropname: super::super::Foundation::PWSTR, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IColumnMapperCreator(::windows::core::IUnknown);
impl IColumnMapperCreator {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColumnMapper<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, wcsmachinename: Param0, wcscatalogname: Param1) -> ::windows::core::Result<IColumnMapper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), wcsmachinename.into_param().abi(), wcscatalogname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IColumnMapper>(result__)
    }
}
impl ::core::convert::From<IColumnMapperCreator> for ::windows::core::IUnknown {
    fn from(value: IColumnMapperCreator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnMapperCreator> for ::windows::core::IUnknown {
    fn from(value: &IColumnMapperCreator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnMapperCreator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnMapperCreator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnMapperCreator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapperCreator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapperCreator {}
impl ::core::fmt::Debug for IColumnMapperCreator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapperCreator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnMapperCreator {
    type Vtable = IColumnMapperCreatorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37b_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapperCreatorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcsmachinename: super::super::Foundation::PWSTR, wcscatalogname: super::super::Foundation::PWSTR, ppcolumnmapper: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IColumnsInfo(::windows::core::IUnknown);
impl IColumnsInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumnids), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgcolumns)).ok()
    }
}
impl ::core::convert::From<IColumnsInfo> for ::windows::core::IUnknown {
    fn from(value: IColumnsInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo> for ::windows::core::IUnknown {
    fn from(value: &IColumnsInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnsInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo {}
impl ::core::fmt::Debug for IColumnsInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsInfo {
    type Vtable = IColumnsInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a11_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IColumnsInfo2(::windows::core::IUnknown);
impl IColumnsInfo2 {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumnids), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgcolumns)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetRestrictedColumnInfo(&self, ccolumnidmasks: usize, rgcolumnidmasks: *const super::super::Storage::IndexServer::DBID, dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumnidmasks), ::core::mem::transmute(rgcolumnidmasks), ::core::mem::transmute(dwflags), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumnids), ::core::mem::transmute(prgcolumninfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
}
impl ::core::convert::From<IColumnsInfo2> for IColumnsInfo {
    fn from(value: IColumnsInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo2> for IColumnsInfo {
    fn from(value: &IColumnsInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IColumnsInfo> for IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, IColumnsInfo> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IColumnsInfo> for &IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, IColumnsInfo> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IColumnsInfo2> for ::windows::core::IUnknown {
    fn from(value: IColumnsInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsInfo2> for ::windows::core::IUnknown {
    fn from(value: &IColumnsInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnsInfo2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsInfo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo2 {}
impl ::core::fmt::Debug for IColumnsInfo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsInfo2 {
    type Vtable = IColumnsInfo2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfo2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prginfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnidmasks: usize, rgcolumnidmasks: *const super::super::Storage::IndexServer::DBID, dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IColumnsRowset(::windows::core::IUnknown);
impl IColumnsRowset {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetAvailableColumns(&self, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcoptcolumns), ::core::mem::transmute(prgoptcolumns)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetColumnsRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, coptcolumns: usize, rgoptcolumns: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppcolrowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(coptcolumns), ::core::mem::transmute(rgoptcolumns), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(ppcolrowset)).ok()
    }
}
impl ::core::convert::From<IColumnsRowset> for ::windows::core::IUnknown {
    fn from(value: IColumnsRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnsRowset> for ::windows::core::IUnknown {
    fn from(value: &IColumnsRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnsRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnsRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnsRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsRowset {}
impl ::core::fmt::Debug for IColumnsRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnsRowset {
    type Vtable = IColumnsRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a10_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, coptcolumns: usize, rgoptcolumns: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppcolrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommand(::windows::core::IUnknown);
impl ICommand {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<ICommand> for ::windows::core::IUnknown {
    fn from(value: ICommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommand> for ::windows::core::IUnknown {
    fn from(value: &ICommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommand {}
impl ::core::fmt::Debug for ICommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommand {
    type Vtable = ICommandVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a63_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandCost(::windows::core::IUnknown);
impl ICommandCost {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAccumulatedCost<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCostEstimate<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostestimates), ::core::mem::transmute(prgcostestimates)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCostGoals<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostgoals), ::core::mem::transmute(prgcostgoals)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCostLimits<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCostGoals<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(ccostgoals), ::core::mem::transmute(rgcostgoals)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCostLimits<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszrowsetname: Param0, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pwszrowsetname.into_param().abi(), ::core::mem::transmute(ccostlimits), ::core::mem::transmute(prgcostlimits), ::core::mem::transmute(dwexecutionflags)).ok()
    }
}
impl ::core::convert::From<ICommandCost> for ::windows::core::IUnknown {
    fn from(value: ICommandCost) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandCost> for ::windows::core::IUnknown {
    fn from(value: &ICommandCost) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandCost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandCost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandCost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandCost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandCost {}
impl ::core::fmt::Debug for ICommandCost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandCost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandCost {
    type Vtable = ICommandCostVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandCostVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: super::super::Foundation::PWSTR, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandPersist(::windows::core::IUnknown);
impl ICommandPersist {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn DeleteCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetCurrentCommand(&self, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppcommandid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SaveCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcommandid), ::core::mem::transmute(dwflags)).ok()
    }
}
impl ::core::convert::From<ICommandPersist> for ::windows::core::IUnknown {
    fn from(value: ICommandPersist) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandPersist> for ::windows::core::IUnknown {
    fn from(value: &ICommandPersist) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandPersist {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandPersist {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandPersist {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPersist {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPersist {}
impl ::core::fmt::Debug for ICommandPersist {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPersist").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandPersist {
    type Vtable = ICommandPersistVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa7_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPersistVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandPrepare(::windows::core::IUnknown);
impl ICommandPrepare {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Prepare(&self, cexpectedruns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cexpectedruns)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Unprepare(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICommandPrepare> for ::windows::core::IUnknown {
    fn from(value: ICommandPrepare) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandPrepare> for ::windows::core::IUnknown {
    fn from(value: &ICommandPrepare) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandPrepare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandPrepare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandPrepare {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPrepare {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPrepare {}
impl ::core::fmt::Debug for ICommandPrepare {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPrepare").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandPrepare {
    type Vtable = ICommandPrepareVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a26_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPrepareVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cexpectedruns: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandProperties(::windows::core::IUnknown);
impl ICommandProperties {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, cpropertysets: u32, rgpropertysets: *const DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<ICommandProperties> for ::windows::core::IUnknown {
    fn from(value: ICommandProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandProperties> for ::windows::core::IUnknown {
    fn from(value: &ICommandProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandProperties {}
impl ::core::fmt::Debug for ICommandProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandProperties {
    type Vtable = ICommandPropertiesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a79_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPropertiesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *const DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandStream(::windows::core::IUnknown);
impl ICommandStream {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCommandStream(&self, piid: *mut ::windows::core::GUID, pguiddialect: *mut ::windows::core::GUID, ppcommandstream: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(piid), ::core::mem::transmute(pguiddialect), ::core::mem::transmute(ppcommandstream)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetCommandStream<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rguiddialect), pcommandstream.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ICommandStream> for ::windows::core::IUnknown {
    fn from(value: ICommandStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandStream> for ::windows::core::IUnknown {
    fn from(value: &ICommandStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandStream {}
impl ::core::fmt::Debug for ICommandStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandStream {
    type Vtable = ICommandStreamVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandStreamVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piid: *mut ::windows::core::GUID, pguiddialect: *mut ::windows::core::GUID, ppcommandstream: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandText(::windows::core::IUnknown);
impl ICommandText {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommandText(&self, pguiddialect: *mut ::windows::core::GUID, ppwszcommand: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguiddialect), ::core::mem::transmute(ppwszcommand)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommandText<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, rguiddialect: *const ::windows::core::GUID, pwszcommand: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(rguiddialect), pwszcommand.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ICommandText> for ICommand {
    fn from(value: ICommandText) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandText> for ICommand {
    fn from(value: &ICommandText) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommand> for ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ICommand> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommand> for &ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ICommand> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICommandText> for ::windows::core::IUnknown {
    fn from(value: ICommandText) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandText> for ::windows::core::IUnknown {
    fn from(value: &ICommandText) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandText {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandText {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandText {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandText {}
impl ::core::fmt::Debug for ICommandText {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandText").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandText {
    type Vtable = ICommandTextVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a27_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandTextVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguiddialect: *mut ::windows::core::GUID, ppwszcommand: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguiddialect: *const ::windows::core::GUID, pwszcommand: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandValidate(::windows::core::IUnknown);
impl ICommandValidate {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ValidateCompletely(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ValidateSyntax(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICommandValidate> for ::windows::core::IUnknown {
    fn from(value: ICommandValidate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandValidate> for ::windows::core::IUnknown {
    fn from(value: &ICommandValidate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandValidate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandValidate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandValidate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandValidate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandValidate {}
impl ::core::fmt::Debug for ICommandValidate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandValidate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandValidate {
    type Vtable = ICommandValidateVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a18_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandValidateVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICommandWithParameters(::windows::core::IUnknown);
impl ICommandWithParameters {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo), ::core::mem::transmute(ppnamesbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapParameterNames(&self, cparamnames: usize, rgparamnames: *const super::super::Foundation::PWSTR, rgparamordinals: *mut isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cparamnames), ::core::mem::transmute(rgparamnames), ::core::mem::transmute(rgparamordinals)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetParameterInfo(&self, cparams: usize, rgparamordinals: *const usize, rgparambindinfo: *const DBPARAMBINDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(cparams), ::core::mem::transmute(rgparamordinals), ::core::mem::transmute(rgparambindinfo)).ok()
    }
}
impl ::core::convert::From<ICommandWithParameters> for ::windows::core::IUnknown {
    fn from(value: ICommandWithParameters) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommandWithParameters> for ::windows::core::IUnknown {
    fn from(value: &ICommandWithParameters) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommandWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommandWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommandWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandWithParameters {}
impl ::core::fmt::Debug for ICommandWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommandWithParameters {
    type Vtable = ICommandWithParametersVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a64_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandWithParametersVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparamnames: usize, rgparamnames: *const super::super::Foundation::PWSTR, rgparamordinals: *mut isize) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparams: usize, rgparamordinals: *const usize, rgparambindinfo: *const DBPARAMBINDINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICondition(::windows::core::IUnknown);
impl ICondition {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, fcleardirty: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pstm.into_param().abi(), fcleardirty.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__: u64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Search_Common'*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__: Common::CONDITION_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSubConditions<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: *mut super::super::Foundation::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetInputTerms(&self, pppropertyterm: *mut ::core::option::Option<IRichChunk>, ppoperationterm: *mut ::core::option::Option<IRichChunk>, ppvalueterm: *mut ::core::option::Option<IRichChunk>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pppropertyterm), ::core::mem::transmute(ppoperationterm), ::core::mem::transmute(ppvalueterm)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition> for super::Com::IPersistStream {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition> for super::Com::IPersistStream {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for &ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition> for super::Com::IPersist {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition> for super::Com::IPersist {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for &ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICondition> for ::windows::core::IUnknown {
    fn from(value: ICondition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICondition> for ::windows::core::IUnknown {
    fn from(value: &ICondition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICondition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICondition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICondition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICondition {}
impl ::core::fmt::Debug for ICondition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICondition {
    type Vtable = IConditionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0fc988d4_c935_4b97_a973_46282ea175c8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclassid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr, fcleardirty: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcbsize: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Search_Common")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnodetype: *mut Common::CONDITION_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Search_Common"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpropertyname: *mut super::super::Foundation::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvaluetypename: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsznormalization: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppropertyterm: *mut ::windows::core::RawPtr, ppoperationterm: *mut ::windows::core::RawPtr, ppvalueterm: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICondition2(::windows::core::IUnknown);
impl ICondition2 {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, fcleardirty: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pstm.into_param().abi(), fcleardirty.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__: u64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Search_Common'*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__: Common::CONDITION_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSubConditions<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: *mut super::super::Foundation::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetInputTerms(&self, pppropertyterm: *mut ::core::option::Option<IRichChunk>, ppoperationterm: *mut ::core::option::Option<IRichChunk>, ppvalueterm: *mut ::core::option::Option<IRichChunk>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pppropertyterm), ::core::mem::transmute(ppoperationterm), ::core::mem::transmute(ppvalueterm)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLocale(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetLeafConditionInfo(&self, ppropkey: *mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppropkey), ::core::mem::transmute(pcop), ::core::mem::transmute(ppropvar)).ok()
    }
}
impl ::core::convert::From<ICondition2> for ICondition {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICondition2> for ICondition {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICondition> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICondition> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICondition> for &ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICondition> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for super::Com::IPersistStream {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for super::Com::IPersistStream {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersistStream> for &ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersistStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICondition2> for super::Com::IPersist {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICondition2> for super::Com::IPersist {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IPersist> for &ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IPersist> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICondition2> for ::windows::core::IUnknown {
    fn from(value: ICondition2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICondition2> for ::windows::core::IUnknown {
    fn from(value: &ICondition2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICondition2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICondition2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICondition2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICondition2 {}
impl ::core::fmt::Debug for ICondition2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICondition2 {
    type Vtable = ICondition2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0db8851d_2e5b_47eb_9208_d28c325a01d7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICondition2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclassid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr, fcleardirty: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcbsize: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Search_Common")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnodetype: *mut Common::CONDITION_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Search_Common"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpropertyname: *mut super::super::Foundation::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvaluetypename: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsznormalization: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppropertyterm: *mut ::windows::core::RawPtr, ppoperationterm: *mut ::windows::core::RawPtr, ppvalueterm: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszlocalename: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropkey: *mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IConditionFactory(::windows::core::IUnknown);
impl IConditionFactory {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
}
impl ::core::convert::From<IConditionFactory> for ::windows::core::IUnknown {
    fn from(value: IConditionFactory) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory> for ::windows::core::IUnknown {
    fn from(value: &IConditionFactory) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionFactory {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IConditionFactory {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory {}
impl ::core::fmt::Debug for IConditionFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionFactory {
    type Vtable = IConditionFactoryVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa5efe073_b16f_474f_9f3e_9f8b497a3e08);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactoryVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, peusubs: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: super::super::Foundation::PWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: super::super::Foundation::PWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, fexpand: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, ppcresolved: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IConditionFactory2(::windows::core::IUnknown);
impl IConditionFactory2 {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateTrueFalse<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, T: ::windows::core::Interface>(&self, fval: Param0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), fval.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CreateNegation<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, T: ::windows::core::Interface>(&self, pcsub: Param0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Search_Common', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn CreateCompoundFromObjectArray<'a, Param1: ::windows::core::IntoParam<'a, super::super::UI::Shell::Common::IObjectArray>, T: ::windows::core::Interface>(&self, ct: Common::CONDITION_TYPE, poasubs: Param1, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), poasubs.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Search_Common'*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn CreateCompoundFromArray<T: ::windows::core::Interface>(&self, ct: Common::CONDITION_TYPE, ppcondsubs: *const ::core::option::Option<ICondition>, csubs: u32, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), ::core::mem::transmute(ppcondsubs), ::core::mem::transmute(csubs), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Search_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateStringLeaf<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: Param2, pszlocalename: Param3, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), pszvalue.into_param().abi(), pszlocalename.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Search_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateIntegerLeaf<T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), ::core::mem::transmute(lvalue), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Search_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateBooleanLeaf<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: Param2, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), fvalue.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateLeaf<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, IRichChunk>, T: ::windows::core::Interface>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const super::Com::StructuredStorage::PROPVARIANT, pszsemantictype: Param3, pszlocalename: Param4, ppropertynameterm: Param5, poperationterm: Param6, pvalueterm: Param7, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(cop), ::core::mem::transmute(propvar), pszsemantictype.into_param().abi(), pszlocalename.into_param().abi(), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), ::core::mem::transmute(cco), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResolveCondition<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, T: ::windows::core::Interface>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<IConditionFactory2> for IConditionFactory {
    fn from(value: IConditionFactory2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory2> for IConditionFactory {
    fn from(value: &IConditionFactory2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for &IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IConditionFactory2> for ::windows::core::IUnknown {
    fn from(value: IConditionFactory2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionFactory2> for ::windows::core::IUnknown {
    fn from(value: &IConditionFactory2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IConditionFactory2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionFactory2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory2 {}
impl ::core::fmt::Debug for IConditionFactory2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionFactory2 {
    type Vtable = IConditionFactory2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71d222e1_432f_429e_8c13_b6dafde5077a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactory2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, peusubs: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: super::super::Foundation::PWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: super::super::Foundation::PWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, fexpand: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, ppcresolved: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fval: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, poasubs: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common")))] usize,
    #[cfg(feature = "Win32_System_Search_Common")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, ppcondsubs: *const ::windows::core::RawPtr, csubs: u32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Search_Common"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: super::super::Foundation::PWSTR, pszlocalename: super::super::Foundation::PWSTR, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))] usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const super::Com::StructuredStorage::PROPVARIANT, pszsemantictype: super::super::Foundation::PWSTR, pszlocalename: super::super::Foundation::PWSTR, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IConditionGenerator(::windows::core::IUnknown);
impl IConditionGenerator {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::core::IntoParam<'a, ISchemaProvider>>(&self, pschemaprovider: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pschemaprovider.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RecognizeNamedEntities<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ITokenCollection>, Param3: ::windows::core::IntoParam<'a, INamedEntityCollector>>(&self, pszinputstring: Param0, lciduserlocale: u32, ptokencollection: Param2, pnamedentities: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pszinputstring.into_param().abi(), ::core::mem::transmute(lciduserlocale), ptokencollection.into_param().abi(), pnamedentities.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GenerateForLeaf<'a, Param0: ::windows::core::IntoParam<'a, IConditionFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, IRichChunk>, Param8: ::windows::core::IntoParam<'a, IRichChunk>, Param9: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(
        &self,
        pconditionfactory: Param0,
        pszpropertyname: Param1,
        cop: Common::CONDITION_OPERATION,
        pszvaluetype: Param3,
        pszvalue: Param4,
        pszvalue2: Param5,
        ppropertynameterm: Param6,
        poperationterm: Param7,
        pvalueterm: Param8,
        automaticwildcard: Param9,
        pnostringquery: *mut super::super::Foundation::BOOL,
        ppqueryexpression: *mut ::core::option::Option<ICondition>,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pconditionfactory.into_param().abi(), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), pszvalue.into_param().abi(), pszvalue2.into_param().abi(), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), automaticwildcard.into_param().abi(), ::core::mem::transmute(pnostringquery), ::core::mem::transmute(ppqueryexpression)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn DefaultPhrase<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszvaluetype: Param0, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, fuseenglish: Param2) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), fuseenglish.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IConditionGenerator> for ::windows::core::IUnknown {
    fn from(value: IConditionGenerator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConditionGenerator> for ::windows::core::IUnknown {
    fn from(value: &IConditionGenerator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConditionGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IConditionGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConditionGenerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionGenerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionGenerator {}
impl ::core::fmt::Debug for IConditionGenerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionGenerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConditionGenerator {
    type Vtable = IConditionGeneratorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92d2cc58_4386_45a3_b98c_7e0ce64a4117);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionGeneratorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pschemaprovider: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: super::super::Foundation::PWSTR, lciduserlocale: u32, ptokencollection: ::windows::core::RawPtr, pnamedentities: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pconditionfactory: ::windows::core::RawPtr, pszpropertyname: super::super::Foundation::PWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: super::super::Foundation::PWSTR, pszvalue: super::super::Foundation::PWSTR, pszvalue2: super::super::Foundation::PWSTR, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, automaticwildcard: super::super::Foundation::BOOL, pnostringquery: *mut super::super::Foundation::BOOL, ppqueryexpression: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvaluetype: super::super::Foundation::PWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, fuseenglish: super::super::Foundation::BOOL, ppszphrase: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IConvertType(::windows::core::IUnknown);
impl IConvertType {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CanConvert(&self, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(wfromtype), ::core::mem::transmute(wtotype), ::core::mem::transmute(dwconvertflags)).ok()
    }
}
impl ::core::convert::From<IConvertType> for ::windows::core::IUnknown {
    fn from(value: IConvertType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConvertType> for ::windows::core::IUnknown {
    fn from(value: &IConvertType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConvertType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IConvertType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IConvertType {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConvertType {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConvertType {}
impl ::core::fmt::Debug for IConvertType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConvertType").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConvertType {
    type Vtable = IConvertTypeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a88_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConvertTypeVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ICreateRow(::windows::core::IUnknown);
impl ICreateRow {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateRow<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppwsznewurl: *mut super::super::Foundation::PWSTR, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppwsznewurl), ::core::mem::transmute(ppunk)).ok()
    }
}
impl ::core::convert::From<ICreateRow> for ::windows::core::IUnknown {
    fn from(value: ICreateRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICreateRow> for ::windows::core::IUnknown {
    fn from(value: &ICreateRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICreateRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICreateRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICreateRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreateRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateRow {}
impl ::core::fmt::Debug for ICreateRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICreateRow {
    type Vtable = ICreateRowVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateRowVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: ::windows::core::RawPtr, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppwsznewurl: *mut super::super::Foundation::PWSTR, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBAsynchNotify(::windows::core::IUnknown);
impl IDBAsynchNotify {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn OnLowResource(&self, dwreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwreserved)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnProgress<'a, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: Param5) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(ulprogress), ::core::mem::transmute(ulprogressmax), ::core::mem::transmute(easynchphase), pwszstatustext.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnStop<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(hrstatus), pwszstatustext.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IDBAsynchNotify> for ::windows::core::IUnknown {
    fn from(value: IDBAsynchNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBAsynchNotify> for ::windows::core::IUnknown {
    fn from(value: &IDBAsynchNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBAsynchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBAsynchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBAsynchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchNotify {}
impl ::core::fmt::Debug for IDBAsynchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBAsynchNotify {
    type Vtable = IDBAsynchNotifyVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a96_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchNotifyVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwreserved: usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBAsynchStatus(::windows::core::IUnknown);
impl IDBAsynchStatus {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Abort(&self, hchapter: usize, eoperation: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStatus(&self, hchapter: usize, eoperation: u32, pulprogress: *mut usize, pulprogressmax: *mut usize, peasynchphase: *mut u32, ppwszstatustext: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(eoperation), ::core::mem::transmute(pulprogress), ::core::mem::transmute(pulprogressmax), ::core::mem::transmute(peasynchphase), ::core::mem::transmute(ppwszstatustext)).ok()
    }
}
impl ::core::convert::From<IDBAsynchStatus> for ::windows::core::IUnknown {
    fn from(value: IDBAsynchStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBAsynchStatus> for ::windows::core::IUnknown {
    fn from(value: &IDBAsynchStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBAsynchStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBAsynchStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBAsynchStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchStatus {}
impl ::core::fmt::Debug for IDBAsynchStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBAsynchStatus {
    type Vtable = IDBAsynchStatusVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a95_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchStatusVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, pulprogress: *mut usize, pulprogressmax: *mut usize, peasynchphase: *mut u32, ppwszstatustext: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBBinderProperties(::windows::core::IUnknown);
impl IDBBinderProperties {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IDBBinderProperties> for IDBProperties {
    fn from(value: IDBBinderProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBBinderProperties> for IDBProperties {
    fn from(value: &IDBBinderProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDBProperties> for IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, IDBProperties> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDBProperties> for &IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, IDBProperties> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IDBBinderProperties> for ::windows::core::IUnknown {
    fn from(value: IDBBinderProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBBinderProperties> for ::windows::core::IUnknown {
    fn from(value: &IDBBinderProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBBinderProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBBinderProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBBinderProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBBinderProperties {}
impl ::core::fmt::Debug for IDBBinderProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBBinderProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBBinderProperties {
    type Vtable = IDBBinderPropertiesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBBinderPropertiesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBCreateCommand(::windows::core::IUnknown);
impl IDBCreateCommand {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CreateCommand<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IDBCreateCommand> for ::windows::core::IUnknown {
    fn from(value: IDBCreateCommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBCreateCommand> for ::windows::core::IUnknown {
    fn from(value: &IDBCreateCommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBCreateCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBCreateCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBCreateCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateCommand {}
impl ::core::fmt::Debug for IDBCreateCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBCreateCommand {
    type Vtable = IDBCreateCommandVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a1d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateCommandVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppcommand: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBCreateSession(::windows::core::IUnknown);
impl IDBCreateSession {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CreateSession<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IDBCreateSession> for ::windows::core::IUnknown {
    fn from(value: IDBCreateSession) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBCreateSession> for ::windows::core::IUnknown {
    fn from(value: &IDBCreateSession) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBCreateSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBCreateSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBCreateSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateSession {}
impl ::core::fmt::Debug for IDBCreateSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBCreateSession {
    type Vtable = IDBCreateSessionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a5d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateSessionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBDataSourceAdmin(::windows::core::IUnknown);
impl IDBDataSourceAdmin {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateDataSource<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, punkouter: Param2, riid: *const ::windows::core::GUID, ppdbsession: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdbsession)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DestroyDataSource(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCreationProperties(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ModifyDataSource(&self, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IDBDataSourceAdmin> for ::windows::core::IUnknown {
    fn from(value: IDBDataSourceAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBDataSourceAdmin> for ::windows::core::IUnknown {
    fn from(value: &IDBDataSourceAdmin) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBDataSourceAdmin {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBDataSourceAdmin {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBDataSourceAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBDataSourceAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBDataSourceAdmin {}
impl ::core::fmt::Debug for IDBDataSourceAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBDataSourceAdmin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBDataSourceAdmin {
    type Vtable = IDBDataSourceAdminVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBDataSourceAdminVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBInfo(::windows::core::IUnknown);
impl IDBInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKeywords(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLiteralInfo(&self, cliterals: u32, rgliterals: *const u32, pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliterals), ::core::mem::transmute(rgliterals), ::core::mem::transmute(pcliteralinfo), ::core::mem::transmute(prgliteralinfo), ::core::mem::transmute(ppcharbuffer)).ok()
    }
}
impl ::core::convert::From<IDBInfo> for ::windows::core::IUnknown {
    fn from(value: IDBInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBInfo> for ::windows::core::IUnknown {
    fn from(value: &IDBInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInfo {}
impl ::core::fmt::Debug for IDBInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBInfo {
    type Vtable = IDBInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a89_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppwszkeywords: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cliterals: u32, rgliterals: *const u32, pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBInitialize(::windows::core::IUnknown);
impl IDBInitialize {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Initialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Uninitialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IDBInitialize> for ::windows::core::IUnknown {
    fn from(value: IDBInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDBInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInitialize {}
impl ::core::fmt::Debug for IDBInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBInitialize {
    type Vtable = IDBInitializeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInitializeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBPromptInitialize(::windows::core::IUnknown);
impl IDBPromptInitialize {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptDataSource<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, punkouter: Param0, hwndparent: Param1, dwpromptoptions: u32, csourcetypefilter: u32, rgsourcetypefilter: *const u32, pwszszzproviderfilter: Param5, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), hwndparent.into_param().abi(), ::core::mem::transmute(dwpromptoptions), ::core::mem::transmute(csourcetypefilter), ::core::mem::transmute(rgsourcetypefilter), pwszszzproviderfilter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptFileName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hwndparent: Param0, dwpromptoptions: u32, pwszinitialdirectory: Param2, pwszinitialfile: Param3) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), hwndparent.into_param().abi(), ::core::mem::transmute(dwpromptoptions), pwszinitialdirectory.into_param().abi(), pwszinitialfile.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IDBPromptInitialize> for ::windows::core::IUnknown {
    fn from(value: IDBPromptInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBPromptInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDBPromptInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBPromptInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBPromptInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBPromptInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBPromptInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBPromptInitialize {}
impl ::core::fmt::Debug for IDBPromptInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBPromptInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBPromptInitialize {
    type Vtable = IDBPromptInitializeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb0_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBPromptInitializeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, csourcetypefilter: u32, rgsourcetypefilter: *const u32, pwszszzproviderfilter: super::super::Foundation::PWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, pwszinitialdirectory: super::super::Foundation::PWSTR, pwszinitialfile: super::super::Foundation::PWSTR, ppwszselectedfile: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBProperties(::windows::core::IUnknown);
impl IDBProperties {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets), ::core::mem::transmute(ppdescbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets)).ok()
    }
}
impl ::core::convert::From<IDBProperties> for ::windows::core::IUnknown {
    fn from(value: IDBProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBProperties> for ::windows::core::IUnknown {
    fn from(value: &IDBProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBProperties {}
impl ::core::fmt::Debug for IDBProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBProperties {
    type Vtable = IDBPropertiesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBPropertiesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBSchemaCommand(::windows::core::IUnknown);
impl IDBSchemaCommand {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCommand<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, rguidschema: *const ::windows::core::GUID) -> ::windows::core::Result<ICommand> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(rguidschema), ::core::mem::transmute(&mut result__)).from_abi::<ICommand>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas)).ok()
    }
}
impl ::core::convert::From<IDBSchemaCommand> for ::windows::core::IUnknown {
    fn from(value: IDBSchemaCommand) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBSchemaCommand> for ::windows::core::IUnknown {
    fn from(value: &IDBSchemaCommand) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBSchemaCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBSchemaCommand {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBSchemaCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaCommand {}
impl ::core::fmt::Debug for IDBSchemaCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBSchemaCommand {
    type Vtable = IDBSchemaCommandVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a50_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaCommandVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, ppcommand: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDBSchemaRowset(::windows::core::IUnknown);
impl IDBSchemaRowset {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, rguidschema: *const ::windows::core::GUID, crestrictions: u32, rgrestrictions: *const super::Com::VARIANT, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(rguidschema), ::core::mem::transmute(crestrictions), ::core::mem::transmute(rgrestrictions), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID, prgrestrictionsupport: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas), ::core::mem::transmute(prgrestrictionsupport)).ok()
    }
}
impl ::core::convert::From<IDBSchemaRowset> for ::windows::core::IUnknown {
    fn from(value: IDBSchemaRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDBSchemaRowset> for ::windows::core::IUnknown {
    fn from(value: &IDBSchemaRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDBSchemaRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDBSchemaRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDBSchemaRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaRowset {}
impl ::core::fmt::Debug for IDBSchemaRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDBSchemaRowset {
    type Vtable = IDBSchemaRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, crestrictions: u32, rgrestrictions: *const super::Com::VARIANT, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID, prgrestrictionsupport: *mut *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDCInfo(::windows::core::IUnknown);
impl IDCInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetInfo(&self, cinfo: u32, rgeinfotype: *const u32, prginfo: *mut *mut DCINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cinfo), ::core::mem::transmute(rgeinfotype), ::core::mem::transmute(prginfo)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetInfo(&self, cinfo: u32, rginfo: *const DCINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(cinfo), ::core::mem::transmute(rginfo)).ok()
    }
}
impl ::core::convert::From<IDCInfo> for ::windows::core::IUnknown {
    fn from(value: IDCInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDCInfo> for ::windows::core::IUnknown {
    fn from(value: &IDCInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDCInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDCInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDCInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDCInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDCInfo {}
impl ::core::fmt::Debug for IDCInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDCInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDCInfo {
    type Vtable = IDCInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDCInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rgeinfotype: *const u32, prginfo: *mut *mut DCINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rginfo: *const DCINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDENTIFIER_SDK_ERROR: u32 = 268435456u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDENTIFIER_SDK_MASK: u32 = 4026531840u32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_BUILTIN_PROPERTY: ::windows::core::HRESULT = ::windows::core::HRESULT(264511i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_BUILTIN_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264503i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_CANNOT_CAST: ::windows::core::HRESULT = ::windows::core::HRESULT(264518i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_CANNOT_CONVERT: ::windows::core::HRESULT = ::windows::core::HRESULT(264507i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_COLUMN_NOT_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264502i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_DATE_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264519i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_DEFAULT_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(264495i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_ILLEGAL_PASSTHROUGH: ::windows::core::HRESULT = ::windows::core::HRESULT(264496i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_INVALIDSELECT_COALESCE: ::windows::core::HRESULT = ::windows::core::HRESULT(264517i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_INVALID_CATALOG: ::windows::core::HRESULT = ::windows::core::HRESULT(264516i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_INVALID_IN_GROUP_CLAUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(264520i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_MATCH_STRING: ::windows::core::HRESULT = ::windows::core::HRESULT(264513i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_NOT_COLUMN_OF_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264510i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_ORDINAL_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264500i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_OR_NOT: ::windows::core::HRESULT = ::windows::core::HRESULT(264506i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_OUT_OF_MEMORY: ::windows::core::HRESULT = ::windows::core::HRESULT(264504i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264508i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_PARSE_ERR_1_PARAM: ::windows::core::HRESULT = ::windows::core::HRESULT(264497i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_PARSE_ERR_2_PARAM: ::windows::core::HRESULT = ::windows::core::HRESULT(264498i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_PROPERTY_NAME_IN_VIEW: ::windows::core::HRESULT = ::windows::core::HRESULT(264514i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_RELATIVE_INTERVAL: ::windows::core::HRESULT = ::windows::core::HRESULT(264509i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_SELECT_STAR: ::windows::core::HRESULT = ::windows::core::HRESULT(264505i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_SEMI_COLON: ::windows::core::HRESULT = ::windows::core::HRESULT(264499i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_VIEW_ALREADY_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264515i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_VIEW_NOT_DEFINED: ::windows::core::HRESULT = ::windows::core::HRESULT(264501i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDS_MON_WEIGHT_OUT_OF_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(264512i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_BUILD_IN_PROGRESS: i32 = -2147217147i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_CATALOG_DISMOUNTED: i32 = -2147217124i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_CORRUPT_INDEX: i32 = -2147217136i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_DISKFULL: i32 = -2147217138i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_DOCUMENT_ABORTED: i32 = -2147217125i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_DSS_NOT_CONNECTED: i32 = -2147217126i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_IDXLSTFILE_CORRUPT: i32 = -2147217146i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_INVALIDTAG: i32 = -2147217151i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_INVALID_INDEX: i32 = -2147217137i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_METAFILE_CORRUPT: i32 = -2147217150i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_NOISELIST_NOTFOUND: i32 = -2147217141i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_NOT_LOADED: i32 = -2147217129i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_OBJECT_NOT_FOUND: i32 = -2147217144i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_PROPSTORE_INIT_FAILED: i32 = -2147217134i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_PROP_MAJOR_VERSION_MISMATCH: i32 = -2147217128i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_PROP_MINOR_VERSION_MISMATCH: i32 = -2147217127i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_PROP_STATE_CORRUPT: i32 = -2147217133i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_PROP_STOPPED: i32 = -2147217139i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_REGISTRY_ENTRY: i32 = -2147217145i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_SEARCH_SERVER_ALREADY_EXISTS: i32 = -2147217148i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_SEARCH_SERVER_NOT_FOUND: i32 = -2147217143i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_STEMMER_NOTFOUND: i32 = -2147217140i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_TOO_MANY_SEARCH_SERVERS: i32 = -2147217149i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_USE_APPGLOBAL_PROPTABLE: i32 = -2147217120i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_USE_DEFAULT_CONTENTCLASS: i32 = -2147217121i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_E_WB_NOTFOUND: i32 = -2147217142i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_S_DSS_NOT_AVAILABLE: i32 = 266525i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_S_NO_BUILD_IN_PROGRESS: i32 = 266516i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_S_SEARCH_SERVER_ALREADY_EXISTS: i32 = 266517i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const IDX_S_SEARCH_SERVER_DOES_NOT_EXIST: i32 = 266518i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDataConvert(::windows::core::IUnknown);
impl IDataConvert {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DataConvert(&self, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: *mut u32, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype), ::core::mem::transmute(cbsrclength), ::core::mem::transmute(pcbdstlength), ::core::mem::transmute(psrc), ::core::mem::transmute(pdst), ::core::mem::transmute(cbdstmaxlength), ::core::mem::transmute(dbssrcstatus), ::core::mem::transmute(pdbsstatus), ::core::mem::transmute(bprecision), ::core::mem::transmute(bscale), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CanConvert(&self, wsrctype: u16, wdsttype: u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetConversionSize(&self, wsrctype: u16, wdsttype: u16, pcbsrclength: *const usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(wsrctype), ::core::mem::transmute(wdsttype), ::core::mem::transmute(pcbsrclength), ::core::mem::transmute(pcbdstlength), ::core::mem::transmute(psrc)).ok()
    }
}
impl ::core::convert::From<IDataConvert> for ::windows::core::IUnknown {
    fn from(value: IDataConvert) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataConvert> for ::windows::core::IUnknown {
    fn from(value: &IDataConvert) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataConvert {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDataConvert {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDataConvert {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataConvert {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataConvert {}
impl ::core::fmt::Debug for IDataConvert {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataConvert").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataConvert {
    type Vtable = IDataConvertVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataConvertVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: *mut u32, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, pcbsrclength: *const usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDataInitialize(::windows::core::IUnknown);
impl IDataInitialize {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDataSource<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, punkouter: Param0, dwclsctx: u32, pwszinitializationstring: Param2, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszinitializationstring.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInitializationString<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, pdatasource: Param0, fincludepassword: u8) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pdatasource.into_param().abi(), ::core::mem::transmute(fincludepassword), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateDBInstance<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: Param1, dwclsctx: u32, pwszreserved: Param3, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprovider), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszreserved.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateDBInstanceEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: Param1, dwclsctx: u32, pwszreserved: Param3, pserverinfo: *const super::Com::COSERVERINFO, cmq: u32, rgmqresults: *mut super::Com::MULTI_QI) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprovider), punkouter.into_param().abi(), ::core::mem::transmute(dwclsctx), pwszreserved.into_param().abi(), ::core::mem::transmute(pserverinfo), ::core::mem::transmute(cmq), ::core::mem::transmute(rgmqresults)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LoadStringFromStorage<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszfilename: Param0) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pwszfilename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteStringToStorage<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszfilename: Param0, pwszinitializationstring: Param1, dwcreationdisposition: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pwszfilename.into_param().abi(), pwszinitializationstring.into_param().abi(), ::core::mem::transmute(dwcreationdisposition)).ok()
    }
}
impl ::core::convert::From<IDataInitialize> for ::windows::core::IUnknown {
    fn from(value: IDataInitialize) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataInitialize> for ::windows::core::IUnknown {
    fn from(value: &IDataInitialize) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDataInitialize {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDataInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataInitialize {}
impl ::core::fmt::Debug for IDataInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataInitialize {
    type Vtable = IDataInitializeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb1_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataInitializeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszinitializationstring: super::super::Foundation::PWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdatasource: *mut ::core::ffi::c_void, fincludepassword: u8, ppwszinitstring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: super::super::Foundation::PWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: super::super::Foundation::PWSTR, pserverinfo: *const super::Com::COSERVERINFO, cmq: u32, rgmqresults: *mut super::Com::MULTI_QI) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: super::super::Foundation::PWSTR, ppwszinitializationstring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: super::super::Foundation::PWSTR, pwszinitializationstring: super::super::Foundation::PWSTR, dwcreationdisposition: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IDataSourceLocator(::windows::core::IUnknown);
impl IDataSourceLocator {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::Com::DISPPARAMS, pvarresult: *mut super::Com::VARIANT, pexcepinfo: *mut super::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn hWnd(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SethWnd(&self, hwndparent: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hwndparent)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptNew(&self) -> ::windows::core::Result<super::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptEdit(&self, ppadoconnection: *mut ::core::option::Option<super::Com::IDispatch>, pbsuccess: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppadoconnection), ::core::mem::transmute(pbsuccess)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IDataSourceLocator> for super::Com::IDispatch {
    fn from(value: IDataSourceLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IDataSourceLocator> for super::Com::IDispatch {
    fn from(value: &IDataSourceLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::Com::IDispatch> for &IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IDataSourceLocator> for ::windows::core::IUnknown {
    fn from(value: IDataSourceLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataSourceLocator> for ::windows::core::IUnknown {
    fn from(value: &IDataSourceLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IDataSourceLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IDataSourceLocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataSourceLocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataSourceLocator {}
impl ::core::fmt::Debug for IDataSourceLocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataSourceLocator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataSourceLocator {
    type Vtable = IDataSourceLocatorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb2_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataSourceLocatorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::Com::DISPPARAMS, pvarresult: *mut super::Com::VARIANT, pexcepinfo: *mut super::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndparent: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: i64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut ::windows::core::RawPtr, pbsuccess: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IEntity(::windows::core::IUnknown);
impl IEntity {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Base(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Relationships<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRelationship<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszrelationname: Param0) -> ::windows::core::Result<IRelationship> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pszrelationname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IRelationship>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn NamedEntities<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetNamedEntity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszvalue: Param0) -> ::windows::core::Result<INamedEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pszvalue.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<INamedEntity>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IEntity> for ::windows::core::IUnknown {
    fn from(value: IEntity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEntity> for ::windows::core::IUnknown {
    fn from(value: &IEntity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEntity {}
impl ::core::fmt::Debug for IEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEntity {
    type Vtable = IEntityVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24264891_e80b_4fd3_b7ce_4ff2fae8931f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEntityVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbaseentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, prelationships: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrelationname: super::super::Foundation::PWSTR, prelationship: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pnamedentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvalue: super::super::Foundation::PWSTR, ppnamedentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IEnumItemProperties(::windows::core::IUnknown);
impl IEnumItemProperties {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut ITEMPROP, pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(rgelt), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumItemProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumItemProperties>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IEnumItemProperties> for ::windows::core::IUnknown {
    fn from(value: IEnumItemProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumItemProperties> for ::windows::core::IUnknown {
    fn from(value: &IEnumItemProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumItemProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IEnumItemProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumItemProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumItemProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumItemProperties {}
impl ::core::fmt::Debug for IEnumItemProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumItemProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumItemProperties {
    type Vtable = IEnumItemPropertiesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d96_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumItemPropertiesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ITEMPROP, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IEnumSearchRoots(::windows::core::IUnknown);
impl IEnumSearchRoots {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut ::core::option::Option<ISearchRoot>, pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(rgelt), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchRoots>(result__)
    }
}
impl ::core::convert::From<IEnumSearchRoots> for ::windows::core::IUnknown {
    fn from(value: IEnumSearchRoots) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSearchRoots> for ::windows::core::IUnknown {
    fn from(value: &IEnumSearchRoots) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSearchRoots {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IEnumSearchRoots {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSearchRoots {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchRoots {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchRoots {}
impl ::core::fmt::Debug for IEnumSearchRoots {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchRoots").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSearchRoots {
    type Vtable = IEnumSearchRootsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef52);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchRootsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::windows::core::RawPtr, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IEnumSearchScopeRules(::windows::core::IUnknown);
impl IEnumSearchScopeRules {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Next(&self, celt: u32, pprgelt: *mut ::core::option::Option<ISearchScopeRule>, pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(pprgelt), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchScopeRules>(result__)
    }
}
impl ::core::convert::From<IEnumSearchScopeRules> for ::windows::core::IUnknown {
    fn from(value: IEnumSearchScopeRules) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSearchScopeRules> for ::windows::core::IUnknown {
    fn from(value: &IEnumSearchScopeRules) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSearchScopeRules {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IEnumSearchScopeRules {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSearchScopeRules {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchScopeRules {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchScopeRules {}
impl ::core::fmt::Debug for IEnumSearchScopeRules {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchScopeRules").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSearchScopeRules {
    type Vtable = IEnumSearchScopeRulesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef54);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchScopeRulesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, pprgelt: *mut ::windows::core::RawPtr, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IEnumSubscription(::windows::core::IUnknown);
impl IEnumSubscription {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut ::windows::core::GUID, pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(rgelt), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSubscription> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSubscription>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IEnumSubscription> for ::windows::core::IUnknown {
    fn from(value: IEnumSubscription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnumSubscription> for ::windows::core::IUnknown {
    fn from(value: &IEnumSubscription) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IEnumSubscription {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IEnumSubscription {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IEnumSubscription {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSubscription {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSubscription {}
impl ::core::fmt::Debug for IEnumSubscription {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSubscription").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSubscription {
    type Vtable = IEnumSubscriptionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d97_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSubscriptionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::windows::core::GUID, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IErrorLookup(::windows::core::IUnknown);
impl IErrorLookup {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorDescription(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: *mut super::super::Foundation::BSTR, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(pdispparams), ::core::mem::transmute(lcid), ::core::mem::transmute(pbstrsource), ::core::mem::transmute(pbstrdescription)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetHelpInfo(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: *mut super::super::Foundation::BSTR, pdwhelpcontext: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(lcid), ::core::mem::transmute(pbstrhelpfile), ::core::mem::transmute(pdwhelpcontext)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseErrors(&self, dwdynamicerrorid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdynamicerrorid)).ok()
    }
}
impl ::core::convert::From<IErrorLookup> for ::windows::core::IUnknown {
    fn from(value: IErrorLookup) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IErrorLookup> for ::windows::core::IUnknown {
    fn from(value: &IErrorLookup) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IErrorLookup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IErrorLookup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IErrorLookup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorLookup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorLookup {}
impl ::core::fmt::Debug for IErrorLookup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorLookup").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IErrorLookup {
    type Vtable = IErrorLookupVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a66_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorLookupVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: *mut super::super::Foundation::BSTR, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: *mut super::super::Foundation::BSTR, pdwhelpcontext: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IErrorRecords(::windows::core::IUnknown);
impl IErrorRecords {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddErrorRecord<'a, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, punkcustomerror: Param3, dwdynamicerrorid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(perrorinfo), ::core::mem::transmute(dwlookupid), ::core::mem::transmute(pdispparams), punkcustomerror.into_param().abi(), ::core::mem::transmute(dwdynamicerrorid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetBasicErrorInfo(&self, ulrecordnum: u32) -> ::windows::core::Result<ERRORINFO> {
        let mut result__: ERRORINFO = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(&mut result__)).from_abi::<ERRORINFO>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCustomErrorObject(&self, ulrecordnum: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetErrorInfo(&self, ulrecordnum: u32, lcid: u32) -> ::windows::core::Result<super::Com::IErrorInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IErrorInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorParameters(&self, ulrecordnum: u32) -> ::windows::core::Result<super::Com::DISPPARAMS> {
        let mut result__: super::Com::DISPPARAMS = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulrecordnum), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::DISPPARAMS>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRecordCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IErrorRecords> for ::windows::core::IUnknown {
    fn from(value: IErrorRecords) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IErrorRecords> for ::windows::core::IUnknown {
    fn from(value: &IErrorRecords) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IErrorRecords {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IErrorRecords {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IErrorRecords {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorRecords {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorRecords {}
impl ::core::fmt::Debug for IErrorRecords {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorRecords").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IErrorRecords {
    type Vtable = IErrorRecordsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a67_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorRecordsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, punkcustomerror: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, perrorinfo: *mut ERRORINFO) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, riid: *const ::windows::core::GUID, ppobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, lcid: u32, pperrorinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, pdispparams: *mut super::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcrecords: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IGetDataSource(::windows::core::IUnknown);
impl IGetDataSource {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetDataSource(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetDataSource> for ::windows::core::IUnknown {
    fn from(value: IGetDataSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetDataSource> for ::windows::core::IUnknown {
    fn from(value: &IGetDataSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetDataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IGetDataSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetDataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetDataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetDataSource {}
impl ::core::fmt::Debug for IGetDataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetDataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetDataSource {
    type Vtable = IGetDataSourceVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a75_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetDataSourceVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IGetRow(::windows::core::IUnknown);
impl IGetRow {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowFromHROW<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, hrow: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(hrow), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetURLFromHROW(&self, hrow: usize) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IGetRow> for ::windows::core::IUnknown {
    fn from(value: IGetRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetRow> for ::windows::core::IUnknown {
    fn from(value: &IGetRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IGetRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetRow {}
impl ::core::fmt::Debug for IGetRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetRow {
    type Vtable = IGetRowVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetRowVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hrow: usize, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, ppwszurl: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IGetSession(::windows::core::IUnknown);
impl IGetSession {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetSession> for ::windows::core::IUnknown {
    fn from(value: IGetSession) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetSession> for ::windows::core::IUnknown {
    fn from(value: &IGetSession) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IGetSession {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSession {}
impl ::core::fmt::Debug for IGetSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetSession {
    type Vtable = IGetSessionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aba_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSessionVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IGetSourceRow(::windows::core::IUnknown);
impl IGetSourceRow {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSourceRow(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IGetSourceRow> for ::windows::core::IUnknown {
    fn from(value: IGetSourceRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetSourceRow> for ::windows::core::IUnknown {
    fn from(value: &IGetSourceRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetSourceRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IGetSourceRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetSourceRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSourceRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSourceRow {}
impl ::core::fmt::Debug for IGetSourceRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSourceRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetSourceRow {
    type Vtable = IGetSourceRowVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abb_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSourceRowVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprow: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IIndexDefinition(::windows::core::IUnknown);
impl IIndexDefinition {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, cindexcolumndescs: usize, rgindexcolumndescs: *const DBINDEXCOLUMNDESC, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(cindexcolumndescs), ::core::mem::transmute(rgindexcolumndescs), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(ppindexid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn DropIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid)).ok()
    }
}
impl ::core::convert::From<IIndexDefinition> for ::windows::core::IUnknown {
    fn from(value: IIndexDefinition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IIndexDefinition> for ::windows::core::IUnknown {
    fn from(value: &IIndexDefinition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IIndexDefinition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IIndexDefinition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IIndexDefinition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IIndexDefinition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IIndexDefinition {}
impl ::core::fmt::Debug for IIndexDefinition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IIndexDefinition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IIndexDefinition {
    type Vtable = IIndexDefinitionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a68_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IIndexDefinitionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, cindexcolumndescs: usize, rgindexcolumndescs: *const DBINDEXCOLUMNDESC, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IInterval(::windows::core::IUnknown);
impl IInterval {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetLimits(&self, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut super::Com::StructuredStorage::PROPVARIANT, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pilklower), ::core::mem::transmute(ppropvarlower), ::core::mem::transmute(pilkupper), ::core::mem::transmute(ppropvarupper)).ok()
    }
}
impl ::core::convert::From<IInterval> for ::windows::core::IUnknown {
    fn from(value: IInterval) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IInterval> for ::windows::core::IUnknown {
    fn from(value: &IInterval) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IInterval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IInterval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IInterval {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IInterval {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IInterval {}
impl ::core::fmt::Debug for IInterval {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IInterval").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IInterval {
    type Vtable = IIntervalVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bf0a714_3c18_430b_8b5d_83b1c234d3db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IIntervalVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut super::Com::StructuredStorage::PROPVARIANT, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ILoadFilter(::windows::core::IUnknown);
impl ILoadFilter {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pwcspath: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pwcspath.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, Param0: ::windows::core::IntoParam<'a, super::Com::StructuredStorage::IStorage>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstg: Param0, punkouter: Param1, pwcsoverride: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pstg.into_param().abi(), punkouter.into_param().abi(), pwcsoverride.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstm.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
}
impl ::core::convert::From<ILoadFilter> for ::windows::core::IUnknown {
    fn from(value: ILoadFilter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilter> for ::windows::core::IUnknown {
    fn from(value: &ILoadFilter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ILoadFilter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ILoadFilter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ILoadFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilter {}
impl ::core::fmt::Debug for ILoadFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ILoadFilter {
    type Vtable = ILoadFilterVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7310722_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilterVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcspath: super::super::Foundation::PWSTR, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstg: ::windows::core::RawPtr, punkouter: *mut ::core::ffi::c_void, pwcsoverride: super::super::Foundation::PWSTR, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ILoadFilterWithPrivateComActivation(::windows::core::IUnknown);
impl ILoadFilterWithPrivateComActivation {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pwcspath: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pwcspath.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, Param0: ::windows::core::IntoParam<'a, super::Com::StructuredStorage::IStorage>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstg: Param0, punkouter: Param1, pwcsoverride: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pstg.into_param().abi(), punkouter.into_param().abi(), pwcsoverride.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, Param0: ::windows::core::IntoParam<'a, super::Com::IStream>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pstm: Param0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: Param2, fusedefault: Param3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstm.into_param().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into_param().abi(), fusedefault.into_param().abi(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilterWithPrivateComActivation<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: Param1, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(filteredsources), usedefault.into_param().abi(), ::core::mem::transmute(filterclsid), ::core::mem::transmute(isfilterprivatecomactivated), ::core::mem::transmute(filterobj)).ok()
    }
}
impl ::core::convert::From<ILoadFilterWithPrivateComActivation> for ILoadFilter {
    fn from(value: ILoadFilterWithPrivateComActivation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilterWithPrivateComActivation> for ILoadFilter {
    fn from(value: &ILoadFilterWithPrivateComActivation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILoadFilter> for ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ILoadFilter> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILoadFilter> for &ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ILoadFilter> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ILoadFilterWithPrivateComActivation> for ::windows::core::IUnknown {
    fn from(value: ILoadFilterWithPrivateComActivation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ILoadFilterWithPrivateComActivation> for ::windows::core::IUnknown {
    fn from(value: &ILoadFilterWithPrivateComActivation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ILoadFilterWithPrivateComActivation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ILoadFilterWithPrivateComActivation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilterWithPrivateComActivation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilterWithPrivateComActivation {}
impl ::core::fmt::Debug for ILoadFilterWithPrivateComActivation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilterWithPrivateComActivation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ILoadFilterWithPrivateComActivation {
    type Vtable = ILoadFilterWithPrivateComActivationVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40bdbd34_780b_48d3_9bb6_12ebd4ad2e75);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilterWithPrivateComActivationVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcspath: super::super::Foundation::PWSTR, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstg: ::windows::core::RawPtr, punkouter: *mut ::core::ffi::c_void, pwcsoverride: super::super::Foundation::PWSTR, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: super::super::Foundation::BOOL, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IMDDataset(::windows::core::IUnknown);
impl IMDDataset {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FreeAxisInfo(&self, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(caxes), ::core::mem::transmute(rgaxisinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAxisInfo(&self, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcaxes), ::core::mem::transmute(prgaxisinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetAxisRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(iaxis), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCellData(&self, haccessor: usize, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ulstartcell), ::core::mem::transmute(ulendcell), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IMDDataset> for ::windows::core::IUnknown {
    fn from(value: IMDDataset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDDataset> for ::windows::core::IUnknown {
    fn from(value: &IMDDataset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDDataset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IMDDataset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDDataset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDDataset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDDataset {}
impl ::core::fmt::Debug for IMDDataset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDDataset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDDataset {
    type Vtable = IMDDatasetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd1_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDDatasetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IMDFind(::windows::core::IUnknown);
impl IMDFind {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindCell(&self, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut super::super::Foundation::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulstartingordinal), ::core::mem::transmute(cmembers), ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pulcellordinal)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindTuple(&self, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut super::super::Foundation::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulaxisidentifier), ::core::mem::transmute(ulstartingordinal), ::core::mem::transmute(cmembers), ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pultupleordinal)).ok()
    }
}
impl ::core::convert::From<IMDFind> for ::windows::core::IUnknown {
    fn from(value: IMDFind) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDFind> for ::windows::core::IUnknown {
    fn from(value: &IMDFind) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IMDFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDFind {}
impl ::core::fmt::Debug for IMDFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDFind {
    type Vtable = IMDFindVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd2_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDFindVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut super::super::Foundation::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut super::super::Foundation::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IMDRangeRowset(::windows::core::IUnknown);
impl IMDRangeRowset {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRangeRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ulstartcell), ::core::mem::transmute(ulendcell), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IMDRangeRowset> for ::windows::core::IUnknown {
    fn from(value: IMDRangeRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMDRangeRowset> for ::windows::core::IUnknown {
    fn from(value: &IMDRangeRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMDRangeRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IMDRangeRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMDRangeRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDRangeRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDRangeRowset {}
impl ::core::fmt::Debug for IMDRangeRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDRangeRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMDRangeRowset {
    type Vtable = IMDRangeRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDRangeRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IMetaData(::windows::core::IUnknown);
impl IMetaData {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetData(&self, ppszkey: *mut super::super::Foundation::PWSTR, ppszvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszkey), ::core::mem::transmute(ppszvalue)).ok()
    }
}
impl ::core::convert::From<IMetaData> for ::windows::core::IUnknown {
    fn from(value: IMetaData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMetaData> for ::windows::core::IUnknown {
    fn from(value: &IMetaData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMetaData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IMetaData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMetaData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMetaData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMetaData {}
impl ::core::fmt::Debug for IMetaData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMetaData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMetaData {
    type Vtable = IMetaDataVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x780102b0_c43b_4876_bc7b_5e9ba5c88794);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMetaDataVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszkey: *mut super::super::Foundation::PWSTR, ppszvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IMultipleResults(::windows::core::IUnknown);
impl IMultipleResults {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetResult<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: *mut isize, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(lresultflag), ::core::mem::transmute(riid), ::core::mem::transmute(pcrowsaffected), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IMultipleResults> for ::windows::core::IUnknown {
    fn from(value: IMultipleResults) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IMultipleResults> for ::windows::core::IUnknown {
    fn from(value: &IMultipleResults) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IMultipleResults {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IMultipleResults {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IMultipleResults {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMultipleResults {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultipleResults {}
impl ::core::fmt::Debug for IMultipleResults {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultipleResults").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMultipleResults {
    type Vtable = IMultipleResultsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a90_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultipleResultsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct INCREMENTAL_ACCESS_INFO {
    pub dwSize: u32,
    pub ftLastModifiedTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for INCREMENTAL_ACCESS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for INCREMENTAL_ACCESS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for INCREMENTAL_ACCESS_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("INCREMENTAL_ACCESS_INFO").field("dwSize", &self.dwSize).field("ftLastModifiedTime", &self.ftLastModifiedTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for INCREMENTAL_ACCESS_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for INCREMENTAL_ACCESS_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<INCREMENTAL_ACCESS_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for INCREMENTAL_ACCESS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for INCREMENTAL_ACCESS_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_AGENT_CACHE_SIZE_EXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693246i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_AGENT_CONNECTION_FAILED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693245i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_AGENT_EXCEEDING_CACHE_SIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693232i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_AGENT_MAX_SIZE_EXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693248i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_SCHEDULED_EXCLUDE_RANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693241i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_SCHEDULED_UPDATES_DISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693244i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_SCHEDULED_UPDATES_RESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693243i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_E_SCHEDULED_UPDATE_INTERVAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2146693242i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_S_AGENT_INCREASED_CACHE_SIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(790416i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const INET_S_AGENT_PART_FAIL: ::windows::core::HRESULT = ::windows::core::HRESULT(790401i32);
#[doc = "*Required features: 'Win32_System_Search'*"]
pub type INTERVAL_LIMIT_KIND = i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ILK_EXPLICIT_INCLUDED: INTERVAL_LIMIT_KIND = 0i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ILK_EXPLICIT_EXCLUDED: INTERVAL_LIMIT_KIND = 1i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ILK_NEGATIVE_INFINITY: INTERVAL_LIMIT_KIND = 2i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
pub const ILK_POSITIVE_INFINITY: INTERVAL_LIMIT_KIND = 3i32;
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct INamedEntity(::windows::core::IUnknown);
impl INamedEntity {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValue(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<INamedEntity> for ::windows::core::IUnknown {
    fn from(value: INamedEntity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&INamedEntity> for ::windows::core::IUnknown {
    fn from(value: &INamedEntity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for INamedEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &INamedEntity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for INamedEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntity {}
impl ::core::fmt::Debug for INamedEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for INamedEntity {
    type Vtable = INamedEntityVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabdbd0b1_7d54_49fb_ab5c_bff4130004cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntityVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct INamedEntityCollector(::windows::core::IUnknown);
impl INamedEntityCollector {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Add<'a, Param4: ::windows::core::IntoParam<'a, IEntity>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: Param4, pszvalue: Param5, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(beginspan), ::core::mem::transmute(endspan), ::core::mem::transmute(beginactual), ::core::mem::transmute(endactual), ptype.into_param().abi(), pszvalue.into_param().abi(), ::core::mem::transmute(certainty)).ok()
    }
}
impl ::core::convert::From<INamedEntityCollector> for ::windows::core::IUnknown {
    fn from(value: INamedEntityCollector) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&INamedEntityCollector> for ::windows::core::IUnknown {
    fn from(value: &INamedEntityCollector) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for INamedEntityCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &INamedEntityCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for INamedEntityCollector {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntityCollector {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntityCollector {}
impl ::core::fmt::Debug for INamedEntityCollector {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntityCollector").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for INamedEntityCollector {
    type Vtable = INamedEntityCollectorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaf2440f6_8afc_47d0_9a7f_396a0acfb43d);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntityCollectorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: ::windows::core::RawPtr, pszvalue: super::super::Foundation::PWSTR, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IObjectAccessControl(::windows::core::IUnknown);
impl IObjectAccessControl {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Security', 'Win32_Security_Authorization', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(pcaccessentries), ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Security_Authorization', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectOwner(&self, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(ppowner)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Security', 'Win32_Security_Authorization', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn IsObjectAccessAllowed(&self, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(paccessentry), ::core::mem::transmute(pfresult)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Security', 'Win32_Security_Authorization', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(caccessentries), ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Security_Authorization', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectOwner(&self, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pobject), ::core::mem::transmute(powner)).ok()
    }
}
impl ::core::convert::From<IObjectAccessControl> for ::windows::core::IUnknown {
    fn from(value: IObjectAccessControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IObjectAccessControl> for ::windows::core::IUnknown {
    fn from(value: &IObjectAccessControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IObjectAccessControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IObjectAccessControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IObjectAccessControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IObjectAccessControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IObjectAccessControl {}
impl ::core::fmt::Debug for IObjectAccessControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IObjectAccessControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IObjectAccessControl {
    type Vtable = IObjectAccessControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IObjectAccessControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IOpLockStatus(::windows::core::IUnknown);
impl IOpLockStatus {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockValid(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockBroken(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOplockEventHandle(&self) -> ::windows::core::Result<super::super::Foundation::HANDLE> {
        let mut result__: super::super::Foundation::HANDLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
}
impl ::core::convert::From<IOpLockStatus> for ::windows::core::IUnknown {
    fn from(value: IOpLockStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IOpLockStatus> for ::windows::core::IUnknown {
    fn from(value: &IOpLockStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IOpLockStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IOpLockStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IOpLockStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpLockStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpLockStatus {}
impl ::core::fmt::Debug for IOpLockStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpLockStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IOpLockStatus {
    type Vtable = IOpLockStatusVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc731065d_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpLockStatusVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockvalid: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockbroken: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phoplockev: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IOpenRowset(::windows::core::IUnknown);
impl IOpenRowset {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IOpenRowset> for ::windows::core::IUnknown {
    fn from(value: IOpenRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IOpenRowset> for ::windows::core::IUnknown {
    fn from(value: &IOpenRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IOpenRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IOpenRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IOpenRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpenRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpenRowset {}
impl ::core::fmt::Debug for IOpenRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpenRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IOpenRowset {
    type Vtable = IOpenRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a69_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpenRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IParentRowset(::windows::core::IUnknown);
impl IParentRowset {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetChildRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(iordinal), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IParentRowset> for ::windows::core::IUnknown {
    fn from(value: IParentRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IParentRowset> for ::windows::core::IUnknown {
    fn from(value: &IParentRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IParentRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IParentRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IParentRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IParentRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IParentRowset {}
impl ::core::fmt::Debug for IParentRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IParentRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IParentRowset {
    type Vtable = IParentRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaa_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IParentRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IProtocolHandlerSite(::windows::core::IUnknown);
impl IProtocolHandlerSite {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetFilter<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: Param1, pcwszextension: Param2, ppfilter: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pclsidobj), pcwszcontenttype.into_param().abi(), pcwszextension.into_param().abi(), ::core::mem::transmute(ppfilter)).ok()
    }
}
impl ::core::convert::From<IProtocolHandlerSite> for ::windows::core::IUnknown {
    fn from(value: IProtocolHandlerSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IProtocolHandlerSite> for ::windows::core::IUnknown {
    fn from(value: &IProtocolHandlerSite) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IProtocolHandlerSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IProtocolHandlerSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IProtocolHandlerSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProtocolHandlerSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProtocolHandlerSite {}
impl ::core::fmt::Debug for IProtocolHandlerSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProtocolHandlerSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IProtocolHandlerSite {
    type Vtable = IProtocolHandlerSiteVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e385_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProtocolHandlerSiteVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: super::super::Foundation::PWSTR, pcwszextension: super::super::Foundation::PWSTR, ppfilter: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IProvideMoniker(::windows::core::IUnknown);
impl IProvideMoniker {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMoniker(&self) -> ::windows::core::Result<super::Com::IMoniker> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IMoniker>(result__)
    }
}
impl ::core::convert::From<IProvideMoniker> for ::windows::core::IUnknown {
    fn from(value: IProvideMoniker) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IProvideMoniker> for ::windows::core::IUnknown {
    fn from(value: &IProvideMoniker) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IProvideMoniker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IProvideMoniker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IProvideMoniker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProvideMoniker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProvideMoniker {}
impl ::core::fmt::Debug for IProvideMoniker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProvideMoniker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IProvideMoniker {
    type Vtable = IProvideMonikerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProvideMonikerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppimoniker: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IQueryParser(::windows::core::IUnknown);
impl IQueryParser {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Parse<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>>(&self, pszinputstring: Param0, pcustomproperties: Param1) -> ::windows::core::Result<IQuerySolution> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszinputstring.into_param().abi(), pcustomproperties.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(poptionvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION) -> ::windows::core::Result<super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetMultiOption<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: Param1, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), pszoptionkey.into_param().abi(), ::core::mem::transmute(poptionvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSchemaProvider(&self) -> ::windows::core::Result<ISchemaProvider> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISchemaProvider>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RestateToString<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcondition: Param0, fuseenglish: Param1) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pcondition.into_param().abi(), fuseenglish.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ParsePropertyValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszpropertyname: Param0, pszinputstring: Param1) -> ::windows::core::Result<IQuerySolution> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), pszinputstring.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RestatePropertyValueToString<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcondition: Param0, fuseenglish: Param1, ppszpropertyname: *mut super::super::Foundation::PWSTR, ppszquerystring: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pcondition.into_param().abi(), fuseenglish.into_param().abi(), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(ppszquerystring)).ok()
    }
}
impl ::core::convert::From<IQueryParser> for ::windows::core::IUnknown {
    fn from(value: IQueryParser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQueryParser> for ::windows::core::IUnknown {
    fn from(value: &IQueryParser) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQueryParser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IQueryParser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQueryParser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParser {}
impl ::core::fmt::Debug for IQueryParser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQueryParser {
    type Vtable = IQueryParserVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2ebdee67_3505_43f8_9946_ea44abc8e5b0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParserVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: super::super::Foundation::PWSTR, pcustomproperties: ::windows::core::RawPtr, ppsolution: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: super::super::Foundation::PWSTR, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppschemaprovider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: ::windows::core::RawPtr, fuseenglish: super::super::Foundation::BOOL, ppszquerystring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: super::super::Foundation::PWSTR, pszinputstring: super::super::Foundation::PWSTR, ppsolution: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: ::windows::core::RawPtr, fuseenglish: super::super::Foundation::BOOL, ppszpropertyname: *mut super::super::Foundation::PWSTR, ppszquerystring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IQueryParserManager(::windows::core::IUnknown);
impl IQueryParserManager {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateLoadedParser<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, T: ::windows::core::Interface>(&self, pszcatalog: Param0, langidforkeywords: u16) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszcatalog.into_param().abi(), ::core::mem::transmute(langidforkeywords), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param2: ::windows::core::IntoParam<'a, IQueryParser>>(&self, funderstandnqs: Param0, fautowildcard: Param1, pqueryparser: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), funderstandnqs.into_param().abi(), fautowildcard.into_param().abi(), pqueryparser.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(option), ::core::mem::transmute(poptionvalue)).ok()
    }
}
impl ::core::convert::From<IQueryParserManager> for ::windows::core::IUnknown {
    fn from(value: IQueryParserManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQueryParserManager> for ::windows::core::IUnknown {
    fn from(value: &IQueryParserManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQueryParserManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IQueryParserManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQueryParserManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParserManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParserManager {}
impl ::core::fmt::Debug for IQueryParserManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParserManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQueryParserManager {
    type Vtable = IQueryParserManagerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa879e3c4_af77_44fb_8f37_ebd1487cf920);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParserManagerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: super::super::Foundation::PWSTR, langidforkeywords: u16, riid: *const ::windows::core::GUID, ppqueryparser: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, funderstandnqs: super::super::Foundation::BOOL, fautowildcard: super::super::Foundation::BOOL, pqueryparser: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IQuerySolution(::windows::core::IUnknown);
impl IQuerySolution {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MakeNot<'a, Param0: ::windows::core::IntoParam<'a, ICondition>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pcsub: Param0, fsimplify: Param1) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pcsub.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, Param1: ::windows::core::IntoParam<'a, super::Com::IEnumUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ct: Common::CONDITION_TYPE, peusubs: Param1, fsimplify: Param2) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ct), peusubs.into_param().abi(), fsimplify.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage', 'Win32_System_Search_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, IRichChunk>, Param5: ::windows::core::IntoParam<'a, IRichChunk>, Param6: ::windows::core::IntoParam<'a, IRichChunk>, Param7: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszpropertyname: Param0, cop: Common::CONDITION_OPERATION, pszvaluetype: Param2, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: Param4, poperationterm: Param5, pvalueterm: Param6, fexpand: Param7) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszpropertyname.into_param().abi(), ::core::mem::transmute(cop), pszvaluetype.into_param().abi(), ::core::mem::transmute(ppropvar), ppropertynameterm.into_param().abi(), poperationterm.into_param().abi(), pvalueterm.into_param().abi(), fexpand.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Resolve<'a, Param0: ::windows::core::IntoParam<'a, ICondition>>(&self, pc: Param0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME) -> ::windows::core::Result<ICondition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pc.into_param().abi(), ::core::mem::transmute(sqro), ::core::mem::transmute(pstreferencetime), ::core::mem::transmute(&mut result__)).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetQuery(&self, ppquerynode: *mut ::core::option::Option<ICondition>, ppmaintype: *mut ::core::option::Option<IEntity>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppquerynode), ::core::mem::transmute(ppmaintype)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetErrors<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLexicalData(&self, ppszinputstring: *mut super::super::Foundation::PWSTR, pptokens: *mut ::core::option::Option<ITokenCollection>, plcid: *mut u32, ppwordbreaker: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszinputstring), ::core::mem::transmute(pptokens), ::core::mem::transmute(plcid), ::core::mem::transmute(ppwordbreaker)).ok()
    }
}
impl ::core::convert::From<IQuerySolution> for IConditionFactory {
    fn from(value: IQuerySolution) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQuerySolution> for IConditionFactory {
    fn from(value: &IQuerySolution) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IConditionFactory> for &IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, IConditionFactory> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IQuerySolution> for ::windows::core::IUnknown {
    fn from(value: IQuerySolution) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IQuerySolution> for ::windows::core::IUnknown {
    fn from(value: &IQuerySolution) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IQuerySolution {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IQuerySolution {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQuerySolution {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQuerySolution {}
impl ::core::fmt::Debug for IQuerySolution {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQuerySolution").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IQuerySolution {
    type Vtable = IQuerySolutionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6ebc66b_8921_4193_afdd_a1789fb7ff57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQuerySolutionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, peusubs: ::windows::core::RawPtr, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: super::super::Foundation::PWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: super::super::Foundation::PWSTR, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: ::windows::core::RawPtr, poperationterm: ::windows::core::RawPtr, pvalueterm: ::windows::core::RawPtr, fexpand: super::super::Foundation::BOOL, ppcresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: ::windows::core::RawPtr, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, ppcresolved: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppquerynode: *mut ::windows::core::RawPtr, ppmaintype: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppparseerrors: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszinputstring: *mut super::super::Foundation::PWSTR, pptokens: *mut ::windows::core::RawPtr, plcid: *mut u32, ppwordbreaker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IReadData(::windows::core::IUnknown);
impl IReadData {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReadData(&self, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: usize, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(haccessor), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(ppfixeddata), ::core::mem::transmute(pcbvariabletotal), ::core::mem::transmute(ppvariabledata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter)).ok()
    }
}
impl ::core::convert::From<IReadData> for ::windows::core::IUnknown {
    fn from(value: IReadData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IReadData> for ::windows::core::IUnknown {
    fn from(value: &IReadData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IReadData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IReadData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IReadData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IReadData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IReadData {}
impl ::core::fmt::Debug for IReadData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IReadData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IReadData {
    type Vtable = IReadDataVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IReadDataVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: usize, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRegisterProvider(::windows::core::IUnknown);
impl IRegisterProvider {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetURLMapping<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszurl: Param0, dwreserved: usize) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetURLMapping<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszurl: Param0, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(rclsidprovider)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterProvider<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszurl: Param0, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pwszurl.into_param().abi(), ::core::mem::transmute(dwreserved), ::core::mem::transmute(rclsidprovider)).ok()
    }
}
impl ::core::convert::From<IRegisterProvider> for ::windows::core::IUnknown {
    fn from(value: IRegisterProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRegisterProvider> for ::windows::core::IUnknown {
    fn from(value: &IRegisterProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRegisterProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRegisterProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRegisterProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRegisterProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRegisterProvider {}
impl ::core::fmt::Debug for IRegisterProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRegisterProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRegisterProvider {
    type Vtable = IRegisterProviderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRegisterProviderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwreserved: usize, pclsidprovider: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRelationship(::windows::core::IUnknown);
impl IRelationship {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsReal(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Destination(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IRelationship> for ::windows::core::IUnknown {
    fn from(value: IRelationship) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRelationship> for ::windows::core::IUnknown {
    fn from(value: &IRelationship) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRelationship {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRelationship {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRelationship {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRelationship {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRelationship {}
impl ::core::fmt::Debug for IRelationship {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRelationship").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRelationship {
    type Vtable = IRelationshipVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2769280b_5108_498c_9c7f_a51239b63147);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRelationshipVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisreal: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRichChunk(::windows::core::IUnknown);
impl IRichChunk {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetData(&self, pfirstpos: *mut u32, plength: *mut u32, ppsz: *mut super::super::Foundation::PWSTR, pvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfirstpos), ::core::mem::transmute(plength), ::core::mem::transmute(ppsz), ::core::mem::transmute(pvalue)).ok()
    }
}
impl ::core::convert::From<IRichChunk> for ::windows::core::IUnknown {
    fn from(value: IRichChunk) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRichChunk> for ::windows::core::IUnknown {
    fn from(value: &IRichChunk) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRichChunk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRichChunk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRichChunk {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRichChunk {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRichChunk {}
impl ::core::fmt::Debug for IRichChunk {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRichChunk").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRichChunk {
    type Vtable = IRichChunkVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4fdef69c_dbc9_454e_9910_b34f3c64b510);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRichChunkVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfirstpos: *mut u32, plength: *mut u32, ppsz: *mut super::super::Foundation::PWSTR, pvalue: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRow(::windows::core::IUnknown);
impl IRow {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetColumns(&self, ccolumns: usize, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumns)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSourceRowset(&self, riid: *const ::windows::core::GUID, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(pprowset), ::core::mem::transmute(phrow)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn Open<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(pcolumnid), ::core::mem::transmute(rguidcolumntype), ::core::mem::transmute(dwbindflags), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRow> for ::windows::core::IUnknown {
    fn from(value: IRow) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRow> for ::windows::core::IUnknown {
    fn from(value: &IRow) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRow {}
impl ::core::fmt::Debug for IRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRow {
    type Vtable = IRowVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab4_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowChange(::windows::core::IUnknown);
impl IRowChange {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetColumns(&self, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumns)).ok()
    }
}
impl ::core::convert::From<IRowChange> for ::windows::core::IUnknown {
    fn from(value: IRowChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowChange> for ::windows::core::IUnknown {
    fn from(value: &IRowChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowChange {}
impl ::core::fmt::Debug for IRowChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowChange {
    type Vtable = IRowChangeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowChangeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowPosition(::windows::core::IUnknown);
impl IRowPosition {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ClearRowPosition(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowPosition(&self, phchapter: *mut usize, phrow: *mut usize, pdwpositionflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(phchapter), ::core::mem::transmute(phrow), ::core::mem::transmute(pdwpositionflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowset(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, prowset: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), prowset.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetRowPosition(&self, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(hrow), ::core::mem::transmute(dwpositionflags)).ok()
    }
}
impl ::core::convert::From<IRowPosition> for ::windows::core::IUnknown {
    fn from(value: IRowPosition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowPosition> for ::windows::core::IUnknown {
    fn from(value: &IRowPosition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowPosition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowPosition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowPosition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPosition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPosition {}
impl ::core::fmt::Debug for IRowPosition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPosition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowPosition {
    type Vtable = IRowPositionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a94_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPositionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phchapter: *mut usize, phrow: *mut usize, pdwpositionflags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowPositionChange(::windows::core::IUnknown);
impl IRowPositionChange {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowPositionChange<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ereason: u32, ephase: u32, fcantdeny: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowPositionChange> for ::windows::core::IUnknown {
    fn from(value: IRowPositionChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowPositionChange> for ::windows::core::IUnknown {
    fn from(value: &IRowPositionChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowPositionChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowPositionChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowPositionChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPositionChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPositionChange {}
impl ::core::fmt::Debug for IRowPositionChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPositionChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowPositionChange {
    type Vtable = IRowPositionChangeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0997a571_126e_11d0_9f8a_00a0c9a0631e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPositionChangeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowSchemaChange(::windows::core::IUnknown);
impl IRowSchemaChange {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetColumns(&self, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumns)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn DeleteColumns(&self, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgdwstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn AddColumns(&self, ccolumns: usize, rgnewcolumninfo: *const DBCOLUMNINFO, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgnewcolumninfo), ::core::mem::transmute(rgcolumns)).ok()
    }
}
impl ::core::convert::From<IRowSchemaChange> for IRowChange {
    fn from(value: IRowSchemaChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowSchemaChange> for IRowChange {
    fn from(value: &IRowSchemaChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowChange> for IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, IRowChange> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowChange> for &IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, IRowChange> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowSchemaChange> for ::windows::core::IUnknown {
    fn from(value: IRowSchemaChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowSchemaChange> for ::windows::core::IUnknown {
    fn from(value: &IRowSchemaChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowSchemaChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowSchemaChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowSchemaChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowSchemaChange {}
impl ::core::fmt::Debug for IRowSchemaChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowSchemaChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowSchemaChange {
    type Vtable = IRowSchemaChangeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aae_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowSchemaChangeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgnewcolumninfo: *const DBCOLUMNINFO, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowset(::windows::core::IUnknown);
impl IRowset {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
}
impl ::core::convert::From<IRowset> for ::windows::core::IUnknown {
    fn from(value: IRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowset> for ::windows::core::IUnknown {
    fn from(value: &IRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowset {}
impl ::core::fmt::Debug for IRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowset {
    type Vtable = IRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetAsynch(::windows::core::IUnknown);
impl IRowsetAsynch {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RatioFinished(&self, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(puldenominator), ::core::mem::transmute(pulnumerator), ::core::mem::transmute(pcrows), ::core::mem::transmute(pfnewrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IRowsetAsynch> for ::windows::core::IUnknown {
    fn from(value: IRowsetAsynch) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetAsynch> for ::windows::core::IUnknown {
    fn from(value: &IRowsetAsynch) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetAsynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetAsynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetAsynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetAsynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetAsynch {}
impl ::core::fmt::Debug for IRowsetAsynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetAsynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetAsynch {
    type Vtable = IRowsetAsynchVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a0f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetAsynchVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetBookmark(::windows::core::IUnknown);
impl IRowsetBookmark {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn PositionOnBookmark(&self, hchapter: usize, cbbookmark: usize, pbookmark: *const u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark)).ok()
    }
}
impl ::core::convert::From<IRowsetBookmark> for ::windows::core::IUnknown {
    fn from(value: IRowsetBookmark) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetBookmark> for ::windows::core::IUnknown {
    fn from(value: &IRowsetBookmark) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetBookmark {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetBookmark {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetBookmark {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetBookmark {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetBookmark {}
impl ::core::fmt::Debug for IRowsetBookmark {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetBookmark").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetBookmark {
    type Vtable = IRowsetBookmarkVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ac2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetBookmarkVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetChange(::windows::core::IUnknown);
impl IRowsetChange {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn InsertRow(&self, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
impl ::core::convert::From<IRowsetChange> for ::windows::core::IUnknown {
    fn from(value: IRowsetChange) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChange> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChange) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetChange {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChange {}
impl ::core::fmt::Debug for IRowsetChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChange {
    type Vtable = IRowsetChangeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a05_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChangeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetChangeExtInfo(::windows::core::IUnknown);
impl IRowsetChangeExtInfo {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetOriginalRow(&self, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(hrow), ::core::mem::transmute(phroworiginal)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetPendingColumns(&self, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(hrow), ::core::mem::transmute(ccolumnordinals), ::core::mem::transmute(rgiordinals), ::core::mem::transmute(rgcolumnstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetChangeExtInfo> for ::windows::core::IUnknown {
    fn from(value: IRowsetChangeExtInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChangeExtInfo> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChangeExtInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChangeExtInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetChangeExtInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChangeExtInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChangeExtInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChangeExtInfo {}
impl ::core::fmt::Debug for IRowsetChangeExtInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChangeExtInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChangeExtInfo {
    type Vtable = IRowsetChangeExtInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChangeExtInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetChapterMember(::windows::core::IUnknown);
impl IRowsetChapterMember {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn IsRowInChapter(&self, hchapter: usize, hrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(hrow)).ok()
    }
}
impl ::core::convert::From<IRowsetChapterMember> for ::windows::core::IUnknown {
    fn from(value: IRowsetChapterMember) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetChapterMember> for ::windows::core::IUnknown {
    fn from(value: &IRowsetChapterMember) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetChapterMember {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetChapterMember {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetChapterMember {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChapterMember {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChapterMember {}
impl ::core::fmt::Debug for IRowsetChapterMember {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChapterMember").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetChapterMember {
    type Vtable = IRowsetChapterMemberVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChapterMemberVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetCopyRows(::windows::core::IUnknown);
impl IRowsetCopyRows {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CloseSource(&self, hsourceid: u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CopyByHROWS(&self, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(bflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CopyRows(&self, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hsourceid), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(bflags), ::core::mem::transmute(pcrowscopied)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DefineSource<'a, Param0: ::windows::core::IntoParam<'a, IRowset>>(&self, prowsetsource: Param0, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), prowsetsource.into_param().abi(), ::core::mem::transmute(ccolids), ::core::mem::transmute(rgsourcecolumns), ::core::mem::transmute(rgtargetcolumns), ::core::mem::transmute(phsourceid)).ok()
    }
}
impl ::core::convert::From<IRowsetCopyRows> for ::windows::core::IUnknown {
    fn from(value: IRowsetCopyRows) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCopyRows> for ::windows::core::IUnknown {
    fn from(value: &IRowsetCopyRows) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetCopyRows {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetCopyRows {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetCopyRows {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCopyRows {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCopyRows {}
impl ::core::fmt::Debug for IRowsetCopyRows {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCopyRows").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetCopyRows {
    type Vtable = IRowsetCopyRowsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCopyRowsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowsetsource: ::windows::core::RawPtr, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetCurrentIndex(::windows::core::IUnknown);
impl IRowsetCurrentIndex {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Seek(&self, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ckeyvalues), ::core::mem::transmute(pdata), ::core::mem::transmute(dwseekoptions)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetRange(&self, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(cstartkeycolumns), ::core::mem::transmute(pstartdata), ::core::mem::transmute(cendkeycolumns), ::core::mem::transmute(penddata), ::core::mem::transmute(dwrangeoptions)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetIndex(&self, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppindexid)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetIndex(&self, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pindexid)).ok()
    }
}
impl ::core::convert::From<IRowsetCurrentIndex> for IRowsetIndex {
    fn from(value: IRowsetCurrentIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCurrentIndex> for IRowsetIndex {
    fn from(value: &IRowsetCurrentIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetIndex> for IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetIndex> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetIndex> for &IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetIndex> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetCurrentIndex> for ::windows::core::IUnknown {
    fn from(value: IRowsetCurrentIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetCurrentIndex> for ::windows::core::IUnknown {
    fn from(value: &IRowsetCurrentIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetCurrentIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetCurrentIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCurrentIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCurrentIndex {}
impl ::core::fmt::Debug for IRowsetCurrentIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCurrentIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetCurrentIndex {
    type Vtable = IRowsetCurrentIndexVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abd_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCurrentIndexVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetEvents(::windows::core::IUnknown);
impl IRowsetEvents {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnNewItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(newitemstate)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnChangedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(rowsetitemstate), ::core::mem::transmute(changeditemstate)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnDeletedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(itemid), ::core::mem::transmute(deleteditemstate)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnRowsetEvent(&self, eventtype: ROWSETEVENT_TYPE, eventdata: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventtype), ::core::mem::transmute(eventdata)).ok()
    }
}
impl ::core::convert::From<IRowsetEvents> for ::windows::core::IUnknown {
    fn from(value: IRowsetEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetEvents> for ::windows::core::IUnknown {
    fn from(value: &IRowsetEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetEvents {}
impl ::core::fmt::Debug for IRowsetEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetEvents {
    type Vtable = IRowsetEventsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1551aea5_5d66_4b11_86f5_d5634cb211b9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetEventsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const super::Com::StructuredStorage::PROPVARIANT, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventtype: ROWSETEVENT_TYPE, eventdata: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
);
#[repr(C)]
pub struct IRowsetExactScroll(pub u8);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetFastLoad(::windows::core::IUnknown);
impl IRowsetFastLoad {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn InsertRow(&self, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Commit<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdone: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), fdone.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowsetFastLoad> for ::windows::core::IUnknown {
    fn from(value: IRowsetFastLoad) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetFastLoad> for ::windows::core::IUnknown {
    fn from(value: &IRowsetFastLoad) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetFastLoad {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetFastLoad {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetFastLoad {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFastLoad {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFastLoad {}
impl ::core::fmt::Debug for IRowsetFastLoad {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFastLoad").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetFastLoad {
    type Vtable = IRowsetFastLoadVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca13_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFastLoadVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdone: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetFind(::windows::core::IUnknown);
impl IRowsetFind {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn FindNextRow(&self, hchapter: usize, haccessor: usize, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(haccessor), ::core::mem::transmute(pfindvalue), ::core::mem::transmute(compareop), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
impl ::core::convert::From<IRowsetFind> for ::windows::core::IUnknown {
    fn from(value: IRowsetFind) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetFind> for ::windows::core::IUnknown {
    fn from(value: &IRowsetFind) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetFind {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFind {}
impl ::core::fmt::Debug for IRowsetFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetFind {
    type Vtable = IRowsetFindVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFindVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, haccessor: usize, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetIdentity(::windows::core::IUnknown);
impl IRowsetIdentity {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn IsSameRow(&self, hthisrow: usize, hthatrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hthisrow), ::core::mem::transmute(hthatrow)).ok()
    }
}
impl ::core::convert::From<IRowsetIdentity> for ::windows::core::IUnknown {
    fn from(value: IRowsetIdentity) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetIdentity> for ::windows::core::IUnknown {
    fn from(value: &IRowsetIdentity) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetIdentity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetIdentity {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetIdentity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIdentity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIdentity {}
impl ::core::fmt::Debug for IRowsetIdentity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIdentity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetIdentity {
    type Vtable = IRowsetIdentityVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a09_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIdentityVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hthisrow: usize, hthatrow: usize) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetIndex(::windows::core::IUnknown);
impl IRowsetIndex {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Seek(&self, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(ckeyvalues), ::core::mem::transmute(pdata), ::core::mem::transmute(dwseekoptions)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetRange(&self, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(haccessor), ::core::mem::transmute(cstartkeycolumns), ::core::mem::transmute(pstartdata), ::core::mem::transmute(cendkeycolumns), ::core::mem::transmute(penddata), ::core::mem::transmute(dwrangeoptions)).ok()
    }
}
impl ::core::convert::From<IRowsetIndex> for ::windows::core::IUnknown {
    fn from(value: IRowsetIndex) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetIndex> for ::windows::core::IUnknown {
    fn from(value: &IRowsetIndex) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetIndex {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIndex {}
impl ::core::fmt::Debug for IRowsetIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetIndex {
    type Vtable = IRowsetIndexVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a82_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIndexVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: usize, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetInfo(::windows::core::IUnknown);
impl IRowsetInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cpropertyidsets), ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetReferencedRowset(&self, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(iordinal), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRowsetInfo> for ::windows::core::IUnknown {
    fn from(value: IRowsetInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetInfo> for ::windows::core::IUnknown {
    fn from(value: &IRowsetInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetInfo {}
impl ::core::fmt::Debug for IRowsetInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetInfo {
    type Vtable = IRowsetInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a55_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, ppreferencedrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetKeys(::windows::core::IUnknown);
impl IRowsetKeys {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ListKeys(&self, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumns)).ok()
    }
}
impl ::core::convert::From<IRowsetKeys> for ::windows::core::IUnknown {
    fn from(value: IRowsetKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetKeys> for ::windows::core::IUnknown {
    fn from(value: &IRowsetKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetKeys {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetKeys {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetKeys {}
impl ::core::fmt::Debug for IRowsetKeys {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetKeys").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetKeys {
    type Vtable = IRowsetKeysVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a12_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetKeysVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetLocate(::windows::core::IUnknown);
impl IRowsetLocate {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark1), ::core::mem::transmute(pbookmark1), ::core::mem::transmute(cbbookmark2), ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbookmarks), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetLocate> for IRowset {
    fn from(value: IRowsetLocate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetLocate> for IRowset {
    fn from(value: &IRowsetLocate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for &IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetLocate> for ::windows::core::IUnknown {
    fn from(value: IRowsetLocate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetLocate> for ::windows::core::IUnknown {
    fn from(value: &IRowsetLocate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetLocate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetLocate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetLocate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetLocate {}
impl ::core::fmt::Debug for IRowsetLocate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetLocate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetLocate {
    type Vtable = IRowsetLocateVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetLocateVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetNewRowAfter(::windows::core::IUnknown);
impl IRowsetNewRowAfter {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetNewDataAfter(&self, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: usize, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbmprevious), ::core::mem::transmute(pbmprevious), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
impl ::core::convert::From<IRowsetNewRowAfter> for ::windows::core::IUnknown {
    fn from(value: IRowsetNewRowAfter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNewRowAfter> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNewRowAfter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNewRowAfter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetNewRowAfter {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNewRowAfter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNewRowAfter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNewRowAfter {}
impl ::core::fmt::Debug for IRowsetNewRowAfter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNewRowAfter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNewRowAfter {
    type Vtable = IRowsetNewRowAfterVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a71_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNewRowAfterVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: usize, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetNextRowset(::windows::core::IUnknown);
impl IRowsetNextRowset {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetNextRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<IRowsetNextRowset> for ::windows::core::IUnknown {
    fn from(value: IRowsetNextRowset) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNextRowset> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNextRowset) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNextRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetNextRowset {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNextRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNextRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNextRowset {}
impl ::core::fmt::Debug for IRowsetNextRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNextRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNextRowset {
    type Vtable = IRowsetNextRowsetVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a72_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNextRowsetVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppnextrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetNotify(::windows::core::IUnknown);
impl IRowsetNotify {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFieldChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param6: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, hrow: usize, ccolumns: usize, rgcolumns: *const usize, ereason: u32, ephase: u32, fcantdeny: Param6) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(hrow), ::core::mem::transmute(ccolumns), ::core::mem::transmute(rgcolumns), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, crows: usize, rghrows: *const usize, ereason: u32, ephase: u32, fcantdeny: Param5) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowsetChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, prowset: Param0, ereason: u32, ephase: u32, fcantdeny: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(ereason), ::core::mem::transmute(ephase), fcantdeny.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IRowsetNotify> for ::windows::core::IUnknown {
    fn from(value: IRowsetNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetNotify> for ::windows::core::IUnknown {
    fn from(value: &IRowsetNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNotify {}
impl ::core::fmt::Debug for IRowsetNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetNotify {
    type Vtable = IRowsetNotifyVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a83_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNotifyVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, hrow: usize, ccolumns: usize, rgcolumns: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, crows: usize, rghrows: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetPrioritization(::windows::core::IUnknown);
impl IRowsetPrioritization {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetScopePriority(&self, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(priority), ::core::mem::transmute(scopestatisticseventfrequency)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetScopePriority(&self, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(priority), ::core::mem::transmute(scopestatisticseventfrequency)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetScopeStatistics(&self, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(indexeddocumentcount), ::core::mem::transmute(oustandingaddcount), ::core::mem::transmute(oustandingmodifycount)).ok()
    }
}
impl ::core::convert::From<IRowsetPrioritization> for ::windows::core::IUnknown {
    fn from(value: IRowsetPrioritization) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetPrioritization> for ::windows::core::IUnknown {
    fn from(value: &IRowsetPrioritization) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetPrioritization {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetPrioritization {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetPrioritization {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetPrioritization {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetPrioritization {}
impl ::core::fmt::Debug for IRowsetPrioritization {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetPrioritization").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetPrioritization {
    type Vtable = IRowsetPrioritizationVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x42811652_079d_481b_87a2_09a69ecc5f44);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetPrioritizationVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetQueryStatus(::windows::core::IUnknown);
impl IRowsetQueryStatus {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetStatus(&self, pdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetStatusEx(&self, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwstatus), ::core::mem::transmute(pcfiltereddocuments), ::core::mem::transmute(pcdocumentstofilter), ::core::mem::transmute(pdwratiofinisheddenominator), ::core::mem::transmute(pdwratiofinishednumerator), ::core::mem::transmute(cbbmk), ::core::mem::transmute(pbmk), ::core::mem::transmute(pirowbmk), ::core::mem::transmute(pcrowstotal)).ok()
    }
}
impl ::core::convert::From<IRowsetQueryStatus> for ::windows::core::IUnknown {
    fn from(value: IRowsetQueryStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetQueryStatus> for ::windows::core::IUnknown {
    fn from(value: &IRowsetQueryStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetQueryStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetQueryStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetQueryStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetQueryStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetQueryStatus {}
impl ::core::fmt::Debug for IRowsetQueryStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetQueryStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetQueryStatus {
    type Vtable = IRowsetQueryStatusVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ac77ed_f8d7_11ce_a798_0020f8008024);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetQueryStatusVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetRefresh(::windows::core::IUnknown);
impl IRowsetRefresh {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RefreshVisibleData<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: Param3, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), foverwrite.into_param().abi(), ::core::mem::transmute(pcrowsrefreshed), ::core::mem::transmute(prghrowsrefreshed), ::core::mem::transmute(prgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetLastVisibleData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
}
impl ::core::convert::From<IRowsetRefresh> for ::windows::core::IUnknown {
    fn from(value: IRowsetRefresh) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetRefresh> for ::windows::core::IUnknown {
    fn from(value: &IRowsetRefresh) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetRefresh {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetRefresh {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetRefresh {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetRefresh {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetRefresh {}
impl ::core::fmt::Debug for IRowsetRefresh {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetRefresh").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetRefresh {
    type Vtable = IRowsetRefreshVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetRefreshVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: super::super::Foundation::BOOL, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetResynch(::windows::core::IUnknown);
impl IRowsetResynch {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetVisibleData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ResynchRows(&self, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsresynched), ::core::mem::transmute(prghrowsresynched), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetResynch> for ::windows::core::IUnknown {
    fn from(value: IRowsetResynch) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetResynch> for ::windows::core::IUnknown {
    fn from(value: &IRowsetResynch) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetResynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetResynch {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetResynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetResynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetResynch {}
impl ::core::fmt::Debug for IRowsetResynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetResynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetResynch {
    type Vtable = IRowsetResynchVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a84_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetResynchVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetScroll(::windows::core::IUnknown);
impl IRowsetScroll {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark1), ::core::mem::transmute(pbookmark1), ::core::mem::transmute(cbbookmark2), ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(lrowsoffset), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbookmarks), ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetApproximatePosition(&self, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(pulposition), ::core::mem::transmute(pcrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowsAtRatio(&self, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved1), ::core::mem::transmute(hreserved2), ::core::mem::transmute(ulnumerator), ::core::mem::transmute(uldenominator), ::core::mem::transmute(crows), ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
impl ::core::convert::From<IRowsetScroll> for IRowsetLocate {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for IRowsetLocate {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetLocate> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetLocate> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetLocate> for &IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetLocate> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetScroll> for IRowset {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for IRowset {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowset> for &IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, IRowset> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetScroll> for ::windows::core::IUnknown {
    fn from(value: IRowsetScroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetScroll> for ::windows::core::IUnknown {
    fn from(value: &IRowsetScroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetScroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetScroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetScroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetScroll {}
impl ::core::fmt::Debug for IRowsetScroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetScroll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetScroll {
    type Vtable = IRowsetScrollVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetScrollVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetUpdate(::windows::core::IUnknown);
impl IRowsetUpdate {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn InsertRow(&self, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetOriginalData(&self, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrow), ::core::mem::transmute(haccessor), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetPendingRows(&self, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(dwrowstatus), ::core::mem::transmute(pcpendingrows), ::core::mem::transmute(prgpendingrows), ::core::mem::transmute(prgpendingstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetRowStatus(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgpendingstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Undo(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsundone), ::core::mem::transmute(prgrowsundone), ::core::mem::transmute(prgrowstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Update(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(hreserved), ::core::mem::transmute(crows), ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrows), ::core::mem::transmute(prgrows), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
impl ::core::convert::From<IRowsetUpdate> for IRowsetChange {
    fn from(value: IRowsetUpdate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetUpdate> for IRowsetChange {
    fn from(value: &IRowsetUpdate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetChange> for IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetChange> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetChange> for &IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetChange> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetUpdate> for ::windows::core::IUnknown {
    fn from(value: IRowsetUpdate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetUpdate> for ::windows::core::IUnknown {
    fn from(value: &IRowsetUpdate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetUpdate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetUpdate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetUpdate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetUpdate {}
impl ::core::fmt::Debug for IRowsetUpdate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetUpdate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetUpdate {
    type Vtable = IRowsetUpdateVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetUpdateVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetView(::windows::core::IUnknown);
impl IRowsetView {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CreateView<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetView(&self, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hchapter), ::core::mem::transmute(riid), ::core::mem::transmute(phchaptersource), ::core::mem::transmute(ppview)).ok()
    }
}
impl ::core::convert::From<IRowsetView> for ::windows::core::IUnknown {
    fn from(value: IRowsetView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetView> for ::windows::core::IUnknown {
    fn from(value: &IRowsetView) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetView {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetView {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetView {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetView {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetView {}
impl ::core::fmt::Debug for IRowsetView {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetView").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetView {
    type Vtable = IRowsetViewVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a99_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetViewVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetWatchAll(::windows::core::IUnknown);
impl IRowsetWatchAll {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchAll> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchAll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchAll> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchAll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchAll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetWatchAll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchAll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchAll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchAll {}
impl ::core::fmt::Debug for IRowsetWatchAll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchAll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchAll {
    type Vtable = IRowsetWatchAllVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a73_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchAllVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetWatchNotify(::windows::core::IUnknown);
impl IRowsetWatchNotify {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn OnChange<'a, Param0: ::windows::core::IntoParam<'a, IRowset>>(&self, prowset: Param0, echangereason: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prowset.into_param().abi(), ::core::mem::transmute(echangereason)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchNotify> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchNotify> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetWatchNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchNotify {}
impl ::core::fmt::Debug for IRowsetWatchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchNotify {
    type Vtable = IRowsetWatchNotifyVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a44_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchNotifyVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: ::windows::core::RawPtr, echangereason: u32) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetWatchRegion(::windows::core::IUnknown);
impl IRowsetWatchRegion {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn CreateWatchRegion(&self, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwwatchmode), ::core::mem::transmute(phregion)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ChangeWatchMode(&self, hregion: usize, dwwatchmode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(dwwatchmode)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DeleteWatchRegion(&self, hregion: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetWatchRegionInfo(&self, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(pdwwatchmode), ::core::mem::transmute(phchapter), ::core::mem::transmute(pcbbookmark), ::core::mem::transmute(ppbookmark), ::core::mem::transmute(pcrows)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Refresh(&self, pcchangesobtained: *mut usize, prgchanges: *mut *mut tagDBROWWATCHRANGE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcchangesobtained), ::core::mem::transmute(prgchanges)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ShrinkWatchRegion(&self, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(hregion), ::core::mem::transmute(hchapter), ::core::mem::transmute(cbbookmark), ::core::mem::transmute(pbookmark), ::core::mem::transmute(crows)).ok()
    }
}
impl ::core::convert::From<IRowsetWatchRegion> for IRowsetWatchAll {
    fn from(value: IRowsetWatchRegion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchRegion> for IRowsetWatchAll {
    fn from(value: &IRowsetWatchRegion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetWatchAll> for IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetWatchAll> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRowsetWatchAll> for &IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, IRowsetWatchAll> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IRowsetWatchRegion> for ::windows::core::IUnknown {
    fn from(value: IRowsetWatchRegion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWatchRegion> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWatchRegion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetWatchRegion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWatchRegion {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchRegion {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchRegion {}
impl ::core::fmt::Debug for IRowsetWatchRegion {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchRegion").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWatchRegion {
    type Vtable = IRowsetWatchRegionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a45_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchRegionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, dwwatchmode: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcchangesobtained: *mut usize, prgchanges: *mut *mut tagDBROWWATCHRANGE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IRowsetWithParameters(::windows::core::IUnknown);
impl IRowsetWithParameters {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo), ::core::mem::transmute(ppnamesbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Requery(&self, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pparams), ::core::mem::transmute(pulerrorparam), ::core::mem::transmute(phreserved)).ok()
    }
}
impl ::core::convert::From<IRowsetWithParameters> for ::windows::core::IUnknown {
    fn from(value: IRowsetWithParameters) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IRowsetWithParameters> for ::windows::core::IUnknown {
    fn from(value: &IRowsetWithParameters) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IRowsetWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IRowsetWithParameters {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IRowsetWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWithParameters {}
impl ::core::fmt::Debug for IRowsetWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IRowsetWithParameters {
    type Vtable = IRowsetWithParametersVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWithParametersVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISQLErrorInfo(::windows::core::IUnknown);
impl ISQLErrorInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSQLInfo(&self, pbstrsqlstate: *mut super::super::Foundation::BSTR, plnativeerror: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrsqlstate), ::core::mem::transmute(plnativeerror)).ok()
    }
}
impl ::core::convert::From<ISQLErrorInfo> for ::windows::core::IUnknown {
    fn from(value: ISQLErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLErrorInfo> for ::windows::core::IUnknown {
    fn from(value: &ISQLErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISQLErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLErrorInfo {}
impl ::core::fmt::Debug for ISQLErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLErrorInfo {
    type Vtable = ISQLErrorInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a74_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLErrorInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsqlstate: *mut super::super::Foundation::BSTR, plnativeerror: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISQLGetDiagField(::windows::core::IUnknown);
impl ISQLGetDiagField {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDiagField(&self, pdiaginfo: *mut KAGGETDIAG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdiaginfo)).ok()
    }
}
impl ::core::convert::From<ISQLGetDiagField> for ::windows::core::IUnknown {
    fn from(value: ISQLGetDiagField) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLGetDiagField> for ::windows::core::IUnknown {
    fn from(value: &ISQLGetDiagField) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLGetDiagField {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISQLGetDiagField {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLGetDiagField {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLGetDiagField {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLGetDiagField {}
impl ::core::fmt::Debug for ISQLGetDiagField {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLGetDiagField").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLGetDiagField {
    type Vtable = ISQLGetDiagFieldVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f1_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLGetDiagFieldVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdiaginfo: *mut KAGGETDIAG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISQLRequestDiagFields(::windows::core::IUnknown);
impl ISQLRequestDiagFields {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RequestDiagFields(&self, cdiagfields: u32, rgdiagfields: *const KAGREQDIAG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(cdiagfields), ::core::mem::transmute(rgdiagfields)).ok()
    }
}
impl ::core::convert::From<ISQLRequestDiagFields> for ::windows::core::IUnknown {
    fn from(value: ISQLRequestDiagFields) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLRequestDiagFields> for ::windows::core::IUnknown {
    fn from(value: &ISQLRequestDiagFields) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLRequestDiagFields {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISQLRequestDiagFields {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLRequestDiagFields {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLRequestDiagFields {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLRequestDiagFields {}
impl ::core::fmt::Debug for ISQLRequestDiagFields {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLRequestDiagFields").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLRequestDiagFields {
    type Vtable = ISQLRequestDiagFieldsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f0_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLRequestDiagFieldsVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cdiagfields: u32, rgdiagfields: *const KAGREQDIAG) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISQLServerErrorInfo(::windows::core::IUnknown);
impl ISQLServerErrorInfo {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetErrorInfo(&self, pperrorinfo: *mut *mut tagSSErrorInfo, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pperrorinfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
}
impl ::core::convert::From<ISQLServerErrorInfo> for ::windows::core::IUnknown {
    fn from(value: ISQLServerErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISQLServerErrorInfo> for ::windows::core::IUnknown {
    fn from(value: &ISQLServerErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISQLServerErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISQLServerErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISQLServerErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLServerErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLServerErrorInfo {}
impl ::core::fmt::Debug for ISQLServerErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLServerErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISQLServerErrorInfo {
    type Vtable = ISQLServerErrorInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca12_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLServerErrorInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pperrorinfo: *mut *mut tagSSErrorInfo, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISchemaLocalizerSupport(::windows::core::IUnknown);
impl ISchemaLocalizerSupport {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Localize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszglobalstring: Param0) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszglobalstring.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<ISchemaLocalizerSupport> for ::windows::core::IUnknown {
    fn from(value: ISchemaLocalizerSupport) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaLocalizerSupport> for ::windows::core::IUnknown {
    fn from(value: &ISchemaLocalizerSupport) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaLocalizerSupport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISchemaLocalizerSupport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaLocalizerSupport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLocalizerSupport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLocalizerSupport {}
impl ::core::fmt::Debug for ISchemaLocalizerSupport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLocalizerSupport").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaLocalizerSupport {
    type Vtable = ISchemaLocalizerSupportVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xca3fdca2_bfbe_4eed_90d7_0caef0a1bda1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLocalizerSupportVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszglobalstring: super::super::Foundation::PWSTR, ppszlocalstring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISchemaLock(::windows::core::IUnknown);
impl ISchemaLock {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetSchemaLock(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(lmmode), ::core::mem::transmute(phlockhandle), ::core::mem::transmute(ptableversion)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReleaseSchemaLock<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hlockhandle: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), hlockhandle.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ISchemaLock> for ::windows::core::IUnknown {
    fn from(value: ISchemaLock) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaLock> for ::windows::core::IUnknown {
    fn from(value: &ISchemaLock) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaLock {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISchemaLock {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaLock {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLock {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLock {}
impl ::core::fmt::Debug for ISchemaLock {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLock").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaLock {
    type Vtable = ISchemaLockVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c2389fb_2511_11d4_b258_00c04f7971ce);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLockVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hlockhandle: super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISchemaProvider(::windows::core::IUnknown);
impl ISchemaProvider {
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Entities<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RootEntity(&self) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEntity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszentityname: Param0) -> ::windows::core::Result<IEntity> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszentityname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IEntity>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn MetaData<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Localize<'a, Param1: ::windows::core::IntoParam<'a, ISchemaLocalizerSupport>>(&self, lcid: u32, pschemalocalizersupport: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(lcid), pschemalocalizersupport.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SaveBinary<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszschemabinarypath: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pszschemabinarypath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LookupAuthoredNamedEntity<'a, Param0: ::windows::core::IntoParam<'a, IEntity>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ITokenCollection>>(&self, pentity: Param0, pszinputstring: Param1, ptokencollection: Param2, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pentity.into_param().abi(), pszinputstring.into_param().abi(), ptokencollection.into_param().abi(), ::core::mem::transmute(ctokensbegin), ::core::mem::transmute(pctokenslength), ::core::mem::transmute(ppszvalue)).ok()
    }
}
impl ::core::convert::From<ISchemaProvider> for ::windows::core::IUnknown {
    fn from(value: ISchemaProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISchemaProvider> for ::windows::core::IUnknown {
    fn from(value: &ISchemaProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISchemaProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISchemaProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISchemaProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaProvider {}
impl ::core::fmt::Debug for ISchemaProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISchemaProvider {
    type Vtable = ISchemaProviderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8cf89bcb_394c_49b2_ae28_a59dd4ed7f68);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaProviderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prootentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszentityname: super::super::Foundation::PWSTR, pentity: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32, pschemalocalizersupport: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszschemabinarypath: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pentity: ::windows::core::RawPtr, pszinputstring: super::super::Foundation::PWSTR, ptokencollection: ::windows::core::RawPtr, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct IScopedOperations(::windows::core::IUnknown);
impl IScopedOperations {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Bind<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, punkouter: Param0, pwszurl: Param1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: Param5, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), pwszurl.into_param().abi(), ::core::mem::transmute(dwbindurlflags), ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into_param().abi(), ::core::mem::transmute(pimplsession), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Copy<'a, Param4: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, crows: usize, rgpwszsourceurls: *const super::super::Foundation::PWSTR, rgpwszdesturls: *const super::super::Foundation::PWSTR, dwcopyflags: u32, pauthenticate: Param4, rgdwstatus: *mut u32, rgpwsznewurls: *mut super::super::Foundation::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszsourceurls), ::core::mem::transmute(rgpwszdesturls), ::core::mem::transmute(dwcopyflags), pauthenticate.into_param().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Move<'a, Param4: ::windows::core::IntoParam<'a, super::Com::IAuthenticate>>(&self, crows: usize, rgpwszsourceurls: *const super::super::Foundation::PWSTR, rgpwszdesturls: *const super::super::Foundation::PWSTR, dwmoveflags: u32, pauthenticate: Param4, rgdwstatus: *mut u32, rgpwsznewurls: *mut super::super::Foundation::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszsourceurls), ::core::mem::transmute(rgpwszdesturls), ::core::mem::transmute(dwmoveflags), pauthenticate.into_param().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Delete(&self, crows: usize, rgpwszurls: *const super::super::Foundation::PWSTR, dwdeleteflags: u32, rgdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(crows), ::core::mem::transmute(rgpwszurls), ::core::mem::transmute(dwdeleteflags), ::core::mem::transmute(rgdwstatus)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_Storage_IndexServer', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punkouter: Param0, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), punkouter.into_param().abi(), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(riid), ::core::mem::transmute(cpropertysets), ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
}
impl ::core::convert::From<IScopedOperations> for IBindResource {
    fn from(value: IScopedOperations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IScopedOperations> for IBindResource {
    fn from(value: &IScopedOperations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBindResource> for IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, IBindResource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBindResource> for &IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, IBindResource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IScopedOperations> for ::windows::core::IUnknown {
    fn from(value: IScopedOperations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IScopedOperations> for ::windows::core::IUnknown {
    fn from(value: &IScopedOperations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IScopedOperations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IScopedOperations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IScopedOperations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IScopedOperations {}
impl ::core::fmt::Debug for IScopedOperations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IScopedOperations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IScopedOperations {
    type Vtable = IScopedOperationsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScopedOperationsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: super::super::Foundation::PWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: ::windows::core::RawPtr, pimplsession: *mut DBIMPLICITSESSION, pdwbindstatus: *mut u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const super::super::Foundation::PWSTR, rgpwszdesturls: *const super::super::Foundation::PWSTR, dwcopyflags: u32, pauthenticate: ::windows::core::RawPtr, rgdwstatus: *mut u32, rgpwsznewurls: *mut super::super::Foundation::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const super::super::Foundation::PWSTR, rgpwszdesturls: *const super::super::Foundation::PWSTR, dwmoveflags: u32, pauthenticate: ::windows::core::RawPtr, rgdwstatus: *mut u32, rgpwsznewurls: *mut super::super::Foundation::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszurls: *const super::super::Foundation::PWSTR, dwdeleteflags: u32, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISearchCatalogManager(::windows::core::IUnknown);
impl ISearchCatalogManager {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: *mut super::Com::StructuredStorage::PROPVARIANT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszname: Param0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(pvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReindexMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszpattern: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pszpattern.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReindexSearchRoot<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszrooturl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pszrooturl.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwconnecttimeout)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdatatimeout)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetURLIndexingState<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterViewForNotification<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, ISearchViewChangedSink>>(&self, pszview: Param0, pviewchangedsink: Param1) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), pszview.into_param().abi(), pviewchangedsink.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetItemsChangedSink<'a, Param0: ::windows::core::IntoParam<'a, ISearchNotifyInlineSite>>(&self, pisearchnotifyinlinesite: Param0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), pisearchnotifyinlinesite.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszextension: Param0, fexclude: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), pszextension.into_param().abi(), fexclude.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IEnumString>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdiacriticsensitive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), fdiacriticsensitive.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchCrawlScopeManager>(result__)
    }
}
impl ::core::convert::From<ISearchCatalogManager> for ::windows::core::IUnknown {
    fn from(value: ISearchCatalogManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager> for ::windows::core::IUnknown {
    fn from(value: &ISearchCatalogManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISearchCatalogManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISearchCatalogManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISearchCatalogManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager {}
impl ::core::fmt::Debug for ISearchCatalogManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager {
    type Vtable = ISearchCatalogManagerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef50);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManagerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: super::super::Foundation::PWSTR, ppvalue: *mut *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: super::super::Foundation::PWSTR, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrooturl: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwconnecttimeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwconnecttimeout: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdatatimeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdatatimeout: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: super::super::Foundation::PWSTR, pdwstate: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppisearchpersistentitemschangedsink: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszview: super::super::Foundation::PWSTR, pviewchangedsink: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisearchnotifyinlinesite: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszextension: super::super::Foundation::PWSTR, fexclude: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppextensions: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchqueryhelper: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdiacriticsensitive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfdiacriticsensitive: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcrawlscopemanager: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISearchCatalogManager2(::windows::core::IUnknown);
impl ISearchCatalogManager2 {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__: *mut super::Com::StructuredStorage::PROPVARIANT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Com_StructuredStorage'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszname: Param0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(pvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReindexMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszpattern: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pszpattern.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReindexSearchRoot<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszrooturl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pszrooturl.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwconnecttimeout)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwdatatimeout)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetURLIndexingState<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterViewForNotification<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, ISearchViewChangedSink>>(&self, pszview: Param0, pviewchangedsink: Param1) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), pszview.into_param().abi(), pviewchangedsink.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetItemsChangedSink<'a, Param0: ::windows::core::IntoParam<'a, ISearchNotifyInlineSite>>(&self, pisearchnotifyinlinesite: Param0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), pisearchnotifyinlinesite.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszextension: Param0, fexclude: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), pszextension.into_param().abi(), fexclude.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Com::IEnumString>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fdiacriticsensitive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), fdiacriticsensitive.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISearchCrawlScopeManager>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PrioritizeMatchingURLs<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszpattern: Param0, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), pszpattern.into_param().abi(), ::core::mem::transmute(dwprioritizeflags)).ok()
    }
}
impl ::core::convert::From<ISearchCatalogManager2> for ISearchCatalogManager {
    fn from(value: ISearchCatalogManager2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager2> for ISearchCatalogManager {
    fn from(value: &ISearchCatalogManager2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ISearchCatalogManager> for ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ISearchCatalogManager> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ISearchCatalogManager> for &ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ISearchCatalogManager> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ISearchCatalogManager2> for ::windows::core::IUnknown {
    fn from(value: ISearchCatalogManager2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCatalogManager2> for ::windows::core::IUnknown {
    fn from(value: &ISearchCatalogManager2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISearchCatalogManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ISearchCatalogManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager2 {}
impl ::core::fmt::Debug for ISearchCatalogManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager2 {
    type Vtable = ISearchCatalogManager2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ac3286d_4d1d_4817_84fc_c1c85e3af0d9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManager2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: super::super::Foundation::PWSTR, ppvalue: *mut *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: super::super::Foundation::PWSTR, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrooturl: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwconnecttimeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwconnecttimeout: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdatatimeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdatatimeout: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: super::super::Foundation::PWSTR, pdwstate: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppisearchpersistentitemschangedsink: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszview: super::super::Foundation::PWSTR, pviewchangedsink: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisearchnotifyinlinesite: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszextension: super::super::Foundation::PWSTR, fexclude: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppextensions: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchqueryhelper: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdiacriticsensitive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfdiacriticsensitive: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcrawlscopemanager: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: super::super::Foundation::PWSTR, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Search'*"]
#[repr(transparent)]
pub struct ISearchCrawlScopeManager(::windows::core::IUnknown);
impl ISearchCrawlScopeManager {
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDefaultScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszurl: Param0, finclude: Param1, ffollowflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), finclude.into_param().abi(), ::core::mem::transmute(ffollowflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn AddRoot<'a, Param0: ::windows::core::IntoParam<'a, ISearchRoot>>(&self, psearchroot: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), psearchroot.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveRoot<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszurl.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn EnumerateRoots(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchRoots>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddHierarchicalScope<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszurl: Param0, finclude: Param1, fdefault: Param2, foverridechildren: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), finclude.into_param().abi(), fdefault.into_param().abi(), foverridechildren.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddUserScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pszurl: Param0, finclude: Param1, foverridechildren: Param2, ffollowflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), finclude.into_param().abi(), foverridechildren.into_param().abi(), ::core::mem::transmute(ffollowflags)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszrule: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pszrule.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn EnumerateScopeRules(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IEnumSearchScopeRules>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasParentScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasChildScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScope<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScopeEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0, pfisincluded: *mut super::super::Foundation::BOOL, preason: *mut CLUSION_REASON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(pfisincluded), ::core::mem::transmute(preason)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn RevertToDefaultScopes(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search'*"]
    pub unsafe fn SaveAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetParentScopeVersionId<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), pszurl.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Search', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveDefaultScopeRule<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszurl: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), pszurl.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ISearchCrawlScopeManager> for ::windows::core::IUnknown {
    fn from(value: ISearchCrawlScopeManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ISearchCrawlScopeManager> for ::windows::core::IUnknown {
    fn from(value: &ISearchCrawlScopeManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISearchCrawlScopeManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ISearchCrawlScopeManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
  