#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub type AMSI_ATTRIBUTE = i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = 0i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = 1i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = 2i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = 3i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = 4i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = 5i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = 6i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = 7i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = 8i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = 9i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub type AMSI_RESULT = i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = 0i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = 1i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = 16384i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = 20479i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = 32768i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub type AMSI_UAC_MSI_ACTION = i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = 0i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = 1i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = 2i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = 3i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: super::super::Foundation::PWSTR,
    pub lpwszSourceURL: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_AX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_AX_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_AX_INFO").field("ulLength", &self.ulLength).field("lpwszLocalInstallPath", &self.lpwszLocalInstallPath).field("lpwszSourceURL", &self.lpwszSourceURL).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_AX_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_AX_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_AX_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_AX_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: super::super::Foundation::PWSTR,
    pub lpwszRequestor: super::super::Foundation::PWSTR,
    pub Clsid: ::windows::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_COM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_COM_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_COM_INFO").field("ulLength", &self.ulLength).field("lpwszServerBinary", &self.lpwszServerBinary).field("lpwszRequestor", &self.lpwszRequestor).field("Clsid", &self.Clsid).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_COM_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_COM_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_COM_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_COM_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_CONTEXT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_CONTEXT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_CONTEXT_0 {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_CONTEXT_0>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpwszDLLParameter: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_EXE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_EXE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_EXE_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpwszDLLParameter", &self.lpwszDLLParameter).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_EXE_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_EXE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_EXE_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_EXE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: super::super::Foundation::PWSTR,
    pub lpwszVersion: super::super::Foundation::PWSTR,
    pub lpwszLanguage: super::super::Foundation::PWSTR,
    pub lpwszManufacturer: super::super::Foundation::PWSTR,
    pub lpwszPackagePath: super::super::Foundation::PWSTR,
    pub lpwszPackageSource: super::super::Foundation::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut super::super::Foundation::PWSTR,
    pub ppwszUpdateSources: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_MSI_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_MSI_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_MSI_INFO")
            .field("ulLength", &self.ulLength)
            .field("MsiAction", &self.MsiAction)
            .field("lpwszProductName", &self.lpwszProductName)
            .field("lpwszVersion", &self.lpwszVersion)
            .field("lpwszLanguage", &self.lpwszLanguage)
            .field("lpwszManufacturer", &self.lpwszManufacturer)
            .field("lpwszPackagePath", &self.lpwszPackagePath)
            .field("lpwszPackageSource", &self.lpwszPackageSource)
            .field("ulUpdates", &self.ulUpdates)
            .field("ppwszUpdates", &self.ppwszUpdates)
            .field("ppwszUpdateSources", &self.ppwszUpdateSources)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_MSI_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_MSI_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_MSI_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_MSI_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpPackageFamilyName: super::super::Foundation::PWSTR,
    pub lpApplicationId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_PACKAGED_APP_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpPackageFamilyName", &self.lpPackageFamilyName).field("lpApplicationId", &self.lpApplicationId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMSI_UAC_REQUEST_PACKAGED_APP_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub type AMSI_UAC_REQUEST_TYPE = i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = 0i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = 1i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = 2i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = 3i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = 4i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = 5i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub type AMSI_UAC_TRUST_STATE = i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = 0i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = 1i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = 2i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = 3i32;
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[inline]
pub unsafe fn AmsiCloseSession<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, amsisession: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiCloseSession(amsicontext: HAMSICONTEXT, amsisession: HAMSISESSION);
        }
        AmsiCloseSession(amsicontext.into_param().abi(), amsisession.into_param().abi())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiInitialize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(appname: Param0) -> ::windows::core::Result<HAMSICONTEXT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiInitialize(appname: super::super::Foundation::PWSTR, amsicontext: *mut HAMSICONTEXT) -> ::windows::core::HRESULT;
        }
        let mut result__: HAMSICONTEXT = ::core::mem::zeroed();
        AmsiInitialize(appname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<HAMSICONTEXT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiNotifyOperation<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(amsicontext: Param0, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiNotifyOperation(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        AmsiNotifyOperation(amsicontext.into_param().abi(), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[inline]
pub unsafe fn AmsiOpenSession<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) -> ::windows::core::Result<HAMSISESSION> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiOpenSession(amsicontext: HAMSICONTEXT, amsisession: *mut HAMSISESSION) -> ::windows::core::HRESULT;
        }
        let mut result__: HAMSISESSION = ::core::mem::zeroed();
        AmsiOpenSession(amsicontext.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<HAMSISESSION>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanBuffer<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param3, amsisession: Param4) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanBuffer(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        AmsiScanBuffer(amsicontext.into_param().abi(), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), amsisession.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanString<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, string: Param1, contentname: Param2, amsisession: Param3) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanString(amsicontext: HAMSICONTEXT, string: super::super::Foundation::PWSTR, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        AmsiScanString(amsicontext.into_param().abi(), string.into_param().abi(), contentname.into_param().abi(), amsisession.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[inline]
pub unsafe fn AmsiUninitialize<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiUninitialize(amsicontext: HAMSICONTEXT);
        }
        AmsiUninitialize(amsicontext.into_param().abi())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const CAntimalware: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfdb00e52_a214_4aa1_8fba_4357bb0072ec);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HAMSICONTEXT(pub isize);
impl HAMSICONTEXT {
    pub fn is_invalid(&self) -> bool {
        *self == unsafe { ::core::mem::zeroed() }
    }
    pub fn ok(self) -> ::windows::core::Result<Self> {
        if !self.is_invalid() {
            Ok(self)
        } else {
            Err(::windows::core::Error::from_win32())
        }
    }
}
impl ::core::default::Default for HAMSICONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HAMSICONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HAMSICONTEXT {}
impl ::core::fmt::Debug for HAMSICONTEXT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAMSICONTEXT").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Abi for HAMSICONTEXT {
    type Abi = Self;
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HAMSISESSION(pub isize);
impl HAMSISESSION {
    pub fn is_invalid(&self) -> bool {
        *self == unsafe { ::core::mem::zeroed() }
    }
    pub fn ok(self) -> ::windows::core::Result<Self> {
        if !self.is_invalid() {
            Ok(self)
        } else {
            Err(::windows::core::Error::from_win32())
        }
    }
}
impl ::core::default::Default for HAMSISESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HAMSISESSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HAMSISESSION {}
impl ::core::fmt::Debug for HAMSISESSION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAMSISESSION").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Abi for HAMSISESSION {
    type Abi = Self;
}
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAmsiStream(::windows::core::IUnknown);
impl IAmsiStream {
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(attribute), ::core::mem::transmute(datasize), ::core::mem::transmute(data), ::core::mem::transmute(retdata)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn Read(&self, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(position), ::core::mem::transmute(size), ::core::mem::transmute(buffer), ::core::mem::transmute(readsize)).ok()
    }
}
impl ::core::convert::From<IAmsiStream> for ::windows::core::IUnknown {
    fn from(value: IAmsiStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAmsiStream> for ::windows::core::IUnknown {
    fn from(value: &IAmsiStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAmsiStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAmsiStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAmsiStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAmsiStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAmsiStream {}
impl ::core::fmt::Debug for IAmsiStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAmsiStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAmsiStream {
    type Vtable = IAmsiStreamVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e47f2e5_81d4_4d3b_897f_545096770373);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmsiStreamVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAntimalware(::windows::core::IUnknown);
impl IAntimalware {
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(result), ::core::mem::transmute(provider)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session))
    }
}
impl ::core::convert::From<IAntimalware> for ::windows::core::IUnknown {
    fn from(value: IAntimalware) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalware> for ::windows::core::IUnknown {
    fn from(value: &IAntimalware) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalware {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAntimalware {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAntimalware {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAntimalware {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalware {}
impl ::core::fmt::Debug for IAntimalware {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalware").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalware {
    type Vtable = IAntimalwareVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82d29c2e_f062_44e6_b5c9_3d9a2f24a2df);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
);
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAntimalware2(::windows::core::IUnknown);
impl IAntimalware2 {
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(result), ::core::mem::transmute(provider)).ok()
    }
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session))
    }
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Notify<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
}
impl ::core::convert::From<IAntimalware2> for IAntimalware {
    fn from(value: IAntimalware2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalware2> for IAntimalware {
    fn from(value: &IAntimalware2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalware> for IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalware> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalware> for &IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalware> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAntimalware2> for ::windows::core::IUnknown {
    fn from(value: IAntimalware2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalware2> for ::windows::core::IUnknown {
    fn from(value: &IAntimalware2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAntimalware2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAntimalware2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalware2 {}
impl ::core::fmt::Debug for IAntimalware2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalware2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalware2 {
    type Vtable = IAntimalware2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x301035b5_2d42_4f56_8c65_2dcaa7fb3cdc);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAntimalwareProvider(::windows::core::IUnknown);
impl IAntimalwareProvider {
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session))
    }
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IAntimalwareProvider> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalwareProvider> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAntimalwareProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAntimalwareProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAntimalwareProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareProvider {}
impl ::core::fmt::Debug for IAntimalwareProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider {
    type Vtable = IAntimalwareProviderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe3_fe04_42b1_a5df_08d483d4d125);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProviderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAntimalwareProvider2(::windows::core::IUnknown);
impl IAntimalwareProvider2 {
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Antimalware'*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session))
    }
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Notify<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
}
impl ::core::convert::From<IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: IAntimalwareProvider2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: &IAntimalwareProvider2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalwareProvider> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalwareProvider> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalwareProvider> for &IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalwareProvider> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAntimalwareProvider2> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareProvider2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalwareProvider2> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareProvider2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAntimalwareProvider2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAntimalwareProvider2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareProvider2 {}
impl ::core::fmt::Debug for IAntimalwareProvider2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareProvider2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider2 {
    type Vtable = IAntimalwareProvider2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c1e6570_3f73_4e0f_8ad4_98b94cd3290f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Antimalware'*"]
#[repr(transparent)]
pub struct IAntimalwareUacProvider(::windows::core::IUnknown);
impl IAntimalwareUacProvider {
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: AMSI_RESULT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(&mut result__)).from_abi::<AMSI_RESULT>(result__)
    }
    #[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
impl ::core::convert::From<IAntimalwareUacProvider> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareUacProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalwareUacProvider> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareUacProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAntimalwareUacProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAntimalwareUacProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareUacProvider {}
impl ::core::fmt::Debug for IAntimalwareUacProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareUacProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareUacProvider {
    type Vtable = IAntimalwareUacProviderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe4_fe04_42b1_a5df_08d483d4d125);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareUacProviderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const AMSI_UAC_REQUEST_CONTEXT, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_System_Antimalware', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn InstallELAMCertificateInfo<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(elamfile: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn InstallELAMCertificateInfo(elamfile: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(InstallELAMCertificateInfo(elamfile.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
