#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Win32_Media_DirectShow_Xml")]
pub mod Xml;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ADVISE_TYPE = u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_NONE: ADVISE_TYPE = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_CLIPPING: ADVISE_TYPE = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_PALETTE: ADVISE_TYPE = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_COLORKEY: ADVISE_TYPE = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_POSITION: ADVISE_TYPE = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ADVISE_DISPLAY_CHANGE: ADVISE_TYPE = 16u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ALLOCATOR_PROPERTIES {
    pub cBuffers: i32,
    pub cbBuffer: i32,
    pub cbAlign: i32,
    pub cbPrefix: i32,
}
impl ::core::marker::Copy for ALLOCATOR_PROPERTIES {}
impl ::core::clone::Clone for ALLOCATOR_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ALLOCATOR_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ALLOCATOR_PROPERTIES").field("cBuffers", &self.cBuffers).field("cbBuffer", &self.cbBuffer).field("cbAlign", &self.cbAlign).field("cbPrefix", &self.cbPrefix).finish()
    }
}
unsafe impl ::windows::core::Abi for ALLOCATOR_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ALLOCATOR_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ALLOCATOR_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for ALLOCATOR_PROPERTIES {}
impl ::core::default::Default for ALLOCATOR_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMCONTROL_COLORINFO_PRESENT: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMCONTROL_PAD_TO_16x9: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMCONTROL_PAD_TO_4x3: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMCONTROL_USED: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMCOPPCommand {
    pub macKDI: ::windows::core::GUID,
    pub guidCommandID: ::windows::core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub CommandData: [u8; 4056],
}
impl ::core::marker::Copy for AMCOPPCommand {}
impl ::core::clone::Clone for AMCOPPCommand {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMCOPPCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMCOPPCommand").field("macKDI", &self.macKDI).field("guidCommandID", &self.guidCommandID).field("dwSequence", &self.dwSequence).field("cbSizeData", &self.cbSizeData).field("CommandData", &self.CommandData).finish()
    }
}
unsafe impl ::windows::core::Abi for AMCOPPCommand {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMCOPPCommand {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMCOPPCommand>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMCOPPCommand {}
impl ::core::default::Default for AMCOPPCommand {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMCOPPSignature {
    pub Signature: [u8; 256],
}
impl ::core::marker::Copy for AMCOPPSignature {}
impl ::core::clone::Clone for AMCOPPSignature {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMCOPPSignature {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMCOPPSignature").field("Signature", &self.Signature).finish()
    }
}
unsafe impl ::windows::core::Abi for AMCOPPSignature {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMCOPPSignature {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMCOPPSignature>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMCOPPSignature {}
impl ::core::default::Default for AMCOPPSignature {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMCOPPStatusInput {
    pub rApp: ::windows::core::GUID,
    pub guidStatusRequestID: ::windows::core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub StatusData: [u8; 4056],
}
impl ::core::marker::Copy for AMCOPPStatusInput {}
impl ::core::clone::Clone for AMCOPPStatusInput {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMCOPPStatusInput {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMCOPPStatusInput").field("rApp", &self.rApp).field("guidStatusRequestID", &self.guidStatusRequestID).field("dwSequence", &self.dwSequence).field("cbSizeData", &self.cbSizeData).field("StatusData", &self.StatusData).finish()
    }
}
unsafe impl ::windows::core::Abi for AMCOPPStatusInput {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMCOPPStatusInput {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMCOPPStatusInput>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMCOPPStatusInput {}
impl ::core::default::Default for AMCOPPStatusInput {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMCOPPStatusOutput {
    pub macKDI: ::windows::core::GUID,
    pub cbSizeData: u32,
    pub COPPStatus: [u8; 4076],
}
impl ::core::marker::Copy for AMCOPPStatusOutput {}
impl ::core::clone::Clone for AMCOPPStatusOutput {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMCOPPStatusOutput {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMCOPPStatusOutput").field("macKDI", &self.macKDI).field("cbSizeData", &self.cbSizeData).field("COPPStatus", &self.COPPStatus).finish()
    }
}
unsafe impl ::windows::core::Abi for AMCOPPStatusOutput {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMCOPPStatusOutput {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMCOPPStatusOutput>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMCOPPStatusOutput {}
impl ::core::default::Default for AMCOPPStatusOutput {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMCOPYPROTECT_RestrictDuplication: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_ALL: u32 = 255u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_DCIPS: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_DEFAULT: u32 = 255u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_NONE: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_PS: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_RGBFLP: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_RGBOFF: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_RGBOVR: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_YUVFLP: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_YUVOFF: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMDDS_YUVOVR: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMExtendedSeekingCapabilities = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_CANSEEK: AMExtendedSeekingCapabilities = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_CANSCAN: AMExtendedSeekingCapabilities = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_MARKERSEEK: AMExtendedSeekingCapabilities = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_SCANWITHOUTCLOCK: AMExtendedSeekingCapabilities = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_NOSTANDARDREPAINT: AMExtendedSeekingCapabilities = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_BUFFERING: AMExtendedSeekingCapabilities = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_EXSEEK_SENDS_VIDEOFRAMEREADY: AMExtendedSeekingCapabilities = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMF_AUTOMATICGAIN: f64 = -1f64;
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub type AMGETERRORTEXTPROCA = ::core::option::Option<unsafe extern "system" fn(param0: ::windows::core::HRESULT, param1: super::super::Foundation::PSTR, param2: u32) -> super::super::Foundation::BOOL>;
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub type AMGETERRORTEXTPROCW = ::core::option::Option<unsafe extern "system" fn(param0: ::windows::core::HRESULT, param1: super::super::Foundation::PWSTR, param2: u32) -> super::super::Foundation::BOOL>;
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AMGetErrorTextA(hr: ::windows::core::HRESULT, pbuffer: super::super::Foundation::PSTR, maxlen: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AMGetErrorTextA(hr: ::windows::core::HRESULT, pbuffer: super::super::Foundation::PSTR, maxlen: u32) -> u32;
        }
        ::core::mem::transmute(AMGetErrorTextA(::core::mem::transmute(hr), ::core::mem::transmute(pbuffer), ::core::mem::transmute(maxlen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AMGetErrorTextW(hr: ::windows::core::HRESULT, pbuffer: super::super::Foundation::PWSTR, maxlen: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AMGetErrorTextW(hr: ::windows::core::HRESULT, pbuffer: super::super::Foundation::PWSTR, maxlen: u32) -> u32;
        }
        ::core::mem::transmute(AMGetErrorTextW(::core::mem::transmute(hr), ::core::mem::transmute(pbuffer), ::core::mem::transmute(maxlen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_1FieldPerSample: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_DisplayModeBobOnly: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_DisplayModeBobOrWeave: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_DisplayModeMask: u32 = 192u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_DisplayModeWeaveOnly: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_Field1First: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_FieldPatBothIrregular: u32 = 48u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_FieldPatBothRegular: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_FieldPatField1Only: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_FieldPatField2Only: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_FieldPatternMask: u32 = 48u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_IsInterlaced: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMINTERLACE_UNUSED: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMMSF_MMS_INIT_FLAGS = u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_NOGRAPHTHREAD: AMMSF_MMS_INIT_FLAGS = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMMSF_MS_FLAGS = u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_ADDDEFAULTRENDERER: AMMSF_MS_FLAGS = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_CREATEPEER: AMMSF_MS_FLAGS = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_STOPIFNOSAMPLES: AMMSF_MS_FLAGS = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_NOSTALL: AMMSF_MS_FLAGS = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMMSF_RENDER_FLAGS = u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_RENDERTYPEMASK: AMMSF_RENDER_FLAGS = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_RENDERTOEXISTING: AMMSF_RENDER_FLAGS = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_RENDERALLSTREAMS: AMMSF_RENDER_FLAGS = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_NORENDER: AMMSF_RENDER_FLAGS = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_NOCLOCK: AMMSF_RENDER_FLAGS = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMMSF_RUN: AMMSF_RENDER_FLAGS = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMOVERLAYFX = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMOVERFX_NOFX: AMOVERLAYFX = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMOVERFX_MIRRORLEFTRIGHT: AMOVERLAYFX = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMOVERFX_MIRRORUPDOWN: AMOVERLAYFX = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMOVERFX_DEINTERLACE: AMOVERLAYFX = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMPROPERTY_PIN = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPROPERTY_PIN_CATEGORY: AMPROPERTY_PIN = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPROPERTY_PIN_MEDIUM: AMPROPERTY_PIN = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMPlayListEventFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTEVENT_RESUME: AMPlayListEventFlags = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTEVENT_BREAK: AMPlayListEventFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTEVENT_NEXT: AMPlayListEventFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTEVENT_MASK: AMPlayListEventFlags = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTEVENT_REFRESH: AMPlayListEventFlags = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMPlayListFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLIST_STARTINSCANMODE: AMPlayListFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLIST_FORCEBANNER: AMPlayListFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMPlayListItemFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTITEM_CANSKIP: AMPlayListItemFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMPLAYLISTITEM_CANBIND: AMPlayListItemFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMTVAudioEventType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTVAUDIO_EVENT_CHANGED: AMTVAudioEventType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMTunerEventType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_EVENT_CHANGED: AMTunerEventType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMTunerModeType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_MODE_DEFAULT: AMTunerModeType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_MODE_TV: AMTunerModeType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_MODE_FM_RADIO: AMTunerModeType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_MODE_AM_RADIO: AMTunerModeType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_MODE_DSS: AMTunerModeType = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMTunerSignalStrength = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_HASNOSIGNALSTRENGTH: AMTunerSignalStrength = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_NOSIGNAL: AMTunerSignalStrength = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_SIGNALPRESENT: AMTunerSignalStrength = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMTunerSubChannel = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_SUBCHAN_NO_TUNE: AMTunerSubChannel = -2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMTUNER_SUBCHAN_DEFAULT: AMTunerSubChannel = -1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMVABUFFERINFO {
    pub dwTypeIndex: u32,
    pub dwBufferIndex: u32,
    pub dwDataOffset: u32,
    pub dwDataSize: u32,
}
impl ::core::marker::Copy for AMVABUFFERINFO {}
impl ::core::clone::Clone for AMVABUFFERINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMVABUFFERINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVABUFFERINFO").field("dwTypeIndex", &self.dwTypeIndex).field("dwBufferIndex", &self.dwBufferIndex).field("dwDataOffset", &self.dwDataOffset).field("dwDataSize", &self.dwDataSize).finish()
    }
}
unsafe impl ::windows::core::Abi for AMVABUFFERINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMVABUFFERINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVABUFFERINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMVABUFFERINFO {}
impl ::core::default::Default for AMVABUFFERINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMVABeginFrameInfo {
    pub dwDestSurfaceIndex: u32,
    pub pInputData: *mut ::core::ffi::c_void,
    pub dwSizeInputData: u32,
    pub pOutputData: *mut ::core::ffi::c_void,
    pub dwSizeOutputData: u32,
}
impl ::core::marker::Copy for AMVABeginFrameInfo {}
impl ::core::clone::Clone for AMVABeginFrameInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMVABeginFrameInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVABeginFrameInfo").field("dwDestSurfaceIndex", &self.dwDestSurfaceIndex).field("pInputData", &self.pInputData).field("dwSizeInputData", &self.dwSizeInputData).field("pOutputData", &self.pOutputData).field("dwSizeOutputData", &self.dwSizeOutputData).finish()
    }
}
unsafe impl ::windows::core::Abi for AMVABeginFrameInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMVABeginFrameInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVABeginFrameInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMVABeginFrameInfo {}
impl ::core::default::Default for AMVABeginFrameInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub struct AMVACompBufferInfo {
    pub dwNumCompBuffers: u32,
    pub dwWidthToCreate: u32,
    pub dwHeightToCreate: u32,
    pub dwBytesToAllocate: u32,
    pub ddCompCaps: super::super::Graphics::DirectDraw::DDSCAPS2,
    pub ddPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::marker::Copy for AMVACompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::clone::Clone for AMVACompBufferInfo {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::core::Abi for AMVACompBufferInfo {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::PartialEq for AMVACompBufferInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVACompBufferInfo>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::Eq for AMVACompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::default::Default for AMVACompBufferInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMVAEndFrameInfo {
    pub dwSizeMiscData: u32,
    pub pMiscData: *mut ::core::ffi::c_void,
}
impl ::core::marker::Copy for AMVAEndFrameInfo {}
impl ::core::clone::Clone for AMVAEndFrameInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMVAEndFrameInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVAEndFrameInfo").field("dwSizeMiscData", &self.dwSizeMiscData).field("pMiscData", &self.pMiscData).finish()
    }
}
unsafe impl ::windows::core::Abi for AMVAEndFrameInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMVAEndFrameInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVAEndFrameInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMVAEndFrameInfo {}
impl ::core::default::Default for AMVAEndFrameInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMVAInternalMemInfo {
    pub dwScratchMemAlloc: u32,
}
impl ::core::marker::Copy for AMVAInternalMemInfo {}
impl ::core::clone::Clone for AMVAInternalMemInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMVAInternalMemInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVAInternalMemInfo").field("dwScratchMemAlloc", &self.dwScratchMemAlloc).finish()
    }
}
unsafe impl ::windows::core::Abi for AMVAInternalMemInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMVAInternalMemInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVAInternalMemInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMVAInternalMemInfo {}
impl ::core::default::Default for AMVAInternalMemInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub struct AMVAUncompBufferInfo {
    pub dwMinNumSurfaces: u32,
    pub dwMaxNumSurfaces: u32,
    pub ddUncompPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::marker::Copy for AMVAUncompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::clone::Clone for AMVAUncompBufferInfo {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::core::Abi for AMVAUncompBufferInfo {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::PartialEq for AMVAUncompBufferInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVAUncompBufferInfo>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::Eq for AMVAUncompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::default::Default for AMVAUncompBufferInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub struct AMVAUncompDataInfo {
    pub dwUncompWidth: u32,
    pub dwUncompHeight: u32,
    pub ddUncompPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::marker::Copy for AMVAUncompDataInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::clone::Clone for AMVAUncompDataInfo {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::core::Abi for AMVAUncompDataInfo {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::PartialEq for AMVAUncompDataInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVAUncompDataInfo>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::cmp::Eq for AMVAUncompDataInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::core::default::Default for AMVAUncompDataInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVA_QUERYRENDERSTATUSF_READ: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVA_TYPEINDEX_OUTPUTFRAME: u32 = 4294967295u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMVPDATAINFO {
    pub dwSize: u32,
    pub dwMicrosecondsPerField: u32,
    pub amvpDimInfo: AMVPDIMINFO,
    pub dwPictAspectRatioX: u32,
    pub dwPictAspectRatioY: u32,
    pub bEnableDoubleClock: super::super::Foundation::BOOL,
    pub bEnableVACT: super::super::Foundation::BOOL,
    pub bDataIsInterlaced: super::super::Foundation::BOOL,
    pub lHalfLinesOdd: i32,
    pub bFieldPolarityInverted: super::super::Foundation::BOOL,
    pub dwNumLinesInVREF: u32,
    pub lHalfLinesEven: i32,
    pub dwReserved1: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMVPDATAINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMVPDATAINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMVPDATAINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVPDATAINFO")
            .field("dwSize", &self.dwSize)
            .field("dwMicrosecondsPerField", &self.dwMicrosecondsPerField)
            .field("amvpDimInfo", &self.amvpDimInfo)
            .field("dwPictAspectRatioX", &self.dwPictAspectRatioX)
            .field("dwPictAspectRatioY", &self.dwPictAspectRatioY)
            .field("bEnableDoubleClock", &self.bEnableDoubleClock)
            .field("bEnableVACT", &self.bEnableVACT)
            .field("bDataIsInterlaced", &self.bDataIsInterlaced)
            .field("lHalfLinesOdd", &self.lHalfLinesOdd)
            .field("bFieldPolarityInverted", &self.bFieldPolarityInverted)
            .field("dwNumLinesInVREF", &self.dwNumLinesInVREF)
            .field("lHalfLinesEven", &self.lHalfLinesEven)
            .field("dwReserved1", &self.dwReserved1)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMVPDATAINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMVPDATAINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVPDATAINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMVPDATAINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMVPDATAINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMVPDIMINFO {
    pub dwFieldWidth: u32,
    pub dwFieldHeight: u32,
    pub dwVBIWidth: u32,
    pub dwVBIHeight: u32,
    pub rcValidRegion: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMVPDIMINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMVPDIMINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMVPDIMINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVPDIMINFO").field("dwFieldWidth", &self.dwFieldWidth).field("dwFieldHeight", &self.dwFieldHeight).field("dwVBIWidth", &self.dwVBIWidth).field("dwVBIHeight", &self.dwVBIHeight).field("rcValidRegion", &self.rcValidRegion).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMVPDIMINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMVPDIMINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVPDIMINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMVPDIMINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMVPDIMINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AMVPSIZE {
    pub dwWidth: u32,
    pub dwHeight: u32,
}
impl ::core::marker::Copy for AMVPSIZE {}
impl ::core::clone::Clone for AMVPSIZE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMVPSIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMVPSIZE").field("dwWidth", &self.dwWidth).field("dwHeight", &self.dwHeight).finish()
    }
}
unsafe impl ::windows::core::Abi for AMVPSIZE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AMVPSIZE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AMVPSIZE>()) == 0 }
    }
}
impl ::core::cmp::Eq for AMVPSIZE {}
impl ::core::default::Default for AMVPSIZE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMVP_MODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_MODE_WEAVE: AMVP_MODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_MODE_BOBINTERLEAVED: AMVP_MODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_MODE_BOBNONINTERLEAVED: AMVP_MODE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_MODE_SKIPEVEN: AMVP_MODE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_MODE_SKIPODD: AMVP_MODE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AMVP_SELECT_FORMAT_BY = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_DO_NOT_CARE: AMVP_SELECT_FORMAT_BY = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_BEST_BANDWIDTH: AMVP_SELECT_FORMAT_BY = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AMVP_INPUT_SAME_AS_OUTPUT: AMVP_SELECT_FORMAT_BY = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_AC3_ALTERNATE_AUDIO {
    pub fStereo: super::super::Foundation::BOOL,
    pub DualMode: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_AC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_AC3_ALTERNATE_AUDIO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_AC3_ALTERNATE_AUDIO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_ALTERNATE_AUDIO").field("fStereo", &self.fStereo).field("DualMode", &self.DualMode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_AC3_ALTERNATE_AUDIO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_AC3_ALTERNATE_AUDIO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_ALTERNATE_AUDIO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_AC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_AC3_ALTERNATE_AUDIO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_ALTERNATE_AUDIO_1: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_ALTERNATE_AUDIO_2: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_ALTERNATE_AUDIO_BOTH: u32 = 3u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_AC3_BIT_STREAM_MODE {
    pub BitStreamMode: i32,
}
impl ::core::marker::Copy for AM_AC3_BIT_STREAM_MODE {}
impl ::core::clone::Clone for AM_AC3_BIT_STREAM_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_AC3_BIT_STREAM_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_BIT_STREAM_MODE").field("BitStreamMode", &self.BitStreamMode).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_AC3_BIT_STREAM_MODE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_AC3_BIT_STREAM_MODE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_BIT_STREAM_MODE>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_AC3_BIT_STREAM_MODE {}
impl ::core::default::Default for AM_AC3_BIT_STREAM_MODE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_AC3_DIALOGUE_LEVEL {
    pub DialogueLevel: u32,
}
impl ::core::marker::Copy for AM_AC3_DIALOGUE_LEVEL {}
impl ::core::clone::Clone for AM_AC3_DIALOGUE_LEVEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_AC3_DIALOGUE_LEVEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_DIALOGUE_LEVEL").field("DialogueLevel", &self.DialogueLevel).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_AC3_DIALOGUE_LEVEL {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_AC3_DIALOGUE_LEVEL {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_DIALOGUE_LEVEL>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_AC3_DIALOGUE_LEVEL {}
impl ::core::default::Default for AM_AC3_DIALOGUE_LEVEL {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_AC3_DOWNMIX {
    pub fDownMix: super::super::Foundation::BOOL,
    pub fDolbySurround: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_AC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_AC3_DOWNMIX {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_AC3_DOWNMIX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_DOWNMIX").field("fDownMix", &self.fDownMix).field("fDolbySurround", &self.fDolbySurround).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_AC3_DOWNMIX {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_AC3_DOWNMIX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_DOWNMIX>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_AC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_AC3_DOWNMIX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_AC3_ERROR_CONCEALMENT {
    pub fRepeatPreviousBlock: super::super::Foundation::BOOL,
    pub fErrorInCurrentBlock: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_AC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_AC3_ERROR_CONCEALMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_AC3_ERROR_CONCEALMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_ERROR_CONCEALMENT").field("fRepeatPreviousBlock", &self.fRepeatPreviousBlock).field("fErrorInCurrentBlock", &self.fErrorInCurrentBlock).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_AC3_ERROR_CONCEALMENT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_AC3_ERROR_CONCEALMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_ERROR_CONCEALMENT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_AC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_AC3_ERROR_CONCEALMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_AC3_ROOM_TYPE {
    pub fLargeRoom: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_AC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_AC3_ROOM_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_AC3_ROOM_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_AC3_ROOM_TYPE").field("fLargeRoom", &self.fLargeRoom).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_AC3_ROOM_TYPE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_AC3_ROOM_TYPE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_AC3_ROOM_TYPE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_AC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_AC3_ROOM_TYPE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_COMMENTARY: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_DIALOG_ONLY: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_EMERGENCY_FLASH: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_HEARING_IMPAIRED: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_MAIN_AUDIO: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_NO_DIALOG: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_VISUALLY_IMPAIRED: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_AC3_SERVICE_VOICE_OVER: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_ASPECT_RATIO_MODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ARMODE_STRETCHED: AM_ASPECT_RATIO_MODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ARMODE_LETTER_BOX: AM_ASPECT_RATIO_MODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ARMODE_CROP: AM_ASPECT_RATIO_MODE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ARMODE_STRETCHED_AS_PRIMARY: AM_ASPECT_RATIO_MODE = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_COLCON {
    pub _bitfield1: u8,
    pub _bitfield2: u8,
    pub _bitfield3: u8,
    pub _bitfield4: u8,
}
impl ::core::marker::Copy for AM_COLCON {}
impl ::core::clone::Clone for AM_COLCON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_COLCON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_COLCON").field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).field("_bitfield3", &self._bitfield3).field("_bitfield4", &self._bitfield4).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_COLCON {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_COLCON {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_COLCON>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_COLCON {}
impl ::core::default::Default for AM_COLCON {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_CONTENTPROPERTY_AUTHOR: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_CONTENTPROPERTY_COPYRIGHT: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_CONTENTPROPERTY_DESCRIPTION: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_CONTENTPROPERTY_TITLE: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_COPY_MACROVISION {
    pub MACROVISIONLevel: u32,
}
impl ::core::marker::Copy for AM_COPY_MACROVISION {}
impl ::core::clone::Clone for AM_COPY_MACROVISION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_COPY_MACROVISION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_COPY_MACROVISION").field("MACROVISIONLevel", &self.MACROVISIONLevel).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_COPY_MACROVISION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_COPY_MACROVISION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_COPY_MACROVISION>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_COPY_MACROVISION {}
impl ::core::default::Default for AM_COPY_MACROVISION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_COPY_MACROVISION_LEVEL = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MACROVISION_DISABLED: AM_COPY_MACROVISION_LEVEL = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MACROVISION_LEVEL1: AM_COPY_MACROVISION_LEVEL = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MACROVISION_LEVEL2: AM_COPY_MACROVISION_LEVEL = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MACROVISION_LEVEL3: AM_COPY_MACROVISION_LEVEL = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_DIGITAL_CP = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DIGITAL_CP_OFF: AM_DIGITAL_CP = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DIGITAL_CP_ON: AM_DIGITAL_CP = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DIGITAL_CP_DVD_COMPLIANT: AM_DIGITAL_CP = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_DVDCOPYSTATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVDCOPYSTATE_INITIALIZE: AM_DVDCOPYSTATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVDCOPYSTATE_INITIALIZE_TITLE: AM_DVDCOPYSTATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED: AM_DVDCOPYSTATE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVDCOPYSTATE_AUTHENTICATION_REQUIRED: AM_DVDCOPYSTATE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVDCOPYSTATE_DONE: AM_DVDCOPYSTATE = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVDCOPY_BUSKEY {
    pub BusKey: [u8; 5],
    pub Reserved: [u8; 1],
}
impl ::core::marker::Copy for AM_DVDCOPY_BUSKEY {}
impl ::core::clone::Clone for AM_DVDCOPY_BUSKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVDCOPY_BUSKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVDCOPY_BUSKEY").field("BusKey", &self.BusKey).field("Reserved", &self.Reserved).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVDCOPY_BUSKEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVDCOPY_BUSKEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVDCOPY_BUSKEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVDCOPY_BUSKEY {}
impl ::core::default::Default for AM_DVDCOPY_BUSKEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVDCOPY_CHLGKEY {
    pub ChlgKey: [u8; 10],
    pub Reserved: [u8; 2],
}
impl ::core::marker::Copy for AM_DVDCOPY_CHLGKEY {}
impl ::core::clone::Clone for AM_DVDCOPY_CHLGKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVDCOPY_CHLGKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVDCOPY_CHLGKEY").field("ChlgKey", &self.ChlgKey).field("Reserved", &self.Reserved).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVDCOPY_CHLGKEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVDCOPY_CHLGKEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVDCOPY_CHLGKEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVDCOPY_CHLGKEY {}
impl ::core::default::Default for AM_DVDCOPY_CHLGKEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVDCOPY_DISCKEY {
    pub DiscKey: [u8; 2048],
}
impl ::core::marker::Copy for AM_DVDCOPY_DISCKEY {}
impl ::core::clone::Clone for AM_DVDCOPY_DISCKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVDCOPY_DISCKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVDCOPY_DISCKEY").field("DiscKey", &self.DiscKey).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVDCOPY_DISCKEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVDCOPY_DISCKEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVDCOPY_DISCKEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVDCOPY_DISCKEY {}
impl ::core::default::Default for AM_DVDCOPY_DISCKEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVDCOPY_SET_COPY_STATE {
    pub DVDCopyState: u32,
}
impl ::core::marker::Copy for AM_DVDCOPY_SET_COPY_STATE {}
impl ::core::clone::Clone for AM_DVDCOPY_SET_COPY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVDCOPY_SET_COPY_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVDCOPY_SET_COPY_STATE").field("DVDCopyState", &self.DVDCopyState).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVDCOPY_SET_COPY_STATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVDCOPY_SET_COPY_STATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVDCOPY_SET_COPY_STATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVDCOPY_SET_COPY_STATE {}
impl ::core::default::Default for AM_DVDCOPY_SET_COPY_STATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVDCOPY_TITLEKEY {
    pub KeyFlags: u32,
    pub Reserved1: [u32; 2],
    pub TitleKey: [u8; 6],
    pub Reserved2: [u8; 2],
}
impl ::core::marker::Copy for AM_DVDCOPY_TITLEKEY {}
impl ::core::clone::Clone for AM_DVDCOPY_TITLEKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVDCOPY_TITLEKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVDCOPY_TITLEKEY").field("KeyFlags", &self.KeyFlags).field("Reserved1", &self.Reserved1).field("TitleKey", &self.TitleKey).field("Reserved2", &self.Reserved2).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVDCOPY_TITLEKEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVDCOPY_TITLEKEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVDCOPY_TITLEKEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVDCOPY_TITLEKEY {}
impl ::core::default::Default for AM_DVDCOPY_TITLEKEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_CGMS_COPY_ONCE: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_CGMS_COPY_PERMITTED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_CGMS_COPY_PROTECT_MASK: u32 = 24u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_CGMS_NO_COPY: u32 = 24u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_CGMS_RESERVED_MASK: u32 = 120u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_COPYRIGHTED: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_COPYRIGHT_MASK: u32 = 64u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVD_ChangeRate {
    pub StartInTime: i64,
    pub StartOutTime: i64,
    pub Rate: i32,
}
impl ::core::marker::Copy for AM_DVD_ChangeRate {}
impl ::core::clone::Clone for AM_DVD_ChangeRate {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVD_ChangeRate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVD_ChangeRate").field("StartInTime", &self.StartInTime).field("StartOutTime", &self.StartOutTime).field("Rate", &self.Rate).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVD_ChangeRate {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVD_ChangeRate {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVD_ChangeRate>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVD_ChangeRate {}
impl ::core::default::Default for AM_DVD_ChangeRate {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_DVD_GRAPH_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_HWDEC_PREFER: AM_DVD_GRAPH_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_HWDEC_ONLY: AM_DVD_GRAPH_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_SWDEC_PREFER: AM_DVD_GRAPH_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_SWDEC_ONLY: AM_DVD_GRAPH_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_NOVPE: AM_DVD_GRAPH_FLAGS = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_DO_NOT_CLEAR: AM_DVD_GRAPH_FLAGS = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_VMR9_ONLY: AM_DVD_GRAPH_FLAGS = 2048i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_EVR_ONLY: AM_DVD_GRAPH_FLAGS = 4096i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_EVR_QOS: AM_DVD_GRAPH_FLAGS = 8192i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_ADAPT_GRAPH: AM_DVD_GRAPH_FLAGS = 16384i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_MASK: AM_DVD_GRAPH_FLAGS = 65535i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_NOT_COPYRIGHTED: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_DVD_RENDERSTATUS {
    pub hrVPEStatus: ::windows::core::HRESULT,
    pub bDvdVolInvalid: super::super::Foundation::BOOL,
    pub bDvdVolUnknown: super::super::Foundation::BOOL,
    pub bNoLine21In: super::super::Foundation::BOOL,
    pub bNoLine21Out: super::super::Foundation::BOOL,
    pub iNumStreams: i32,
    pub iNumStreamsFailed: i32,
    pub dwFailedStreamsFlag: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_DVD_RENDERSTATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_DVD_RENDERSTATUS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_DVD_RENDERSTATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVD_RENDERSTATUS").field("hrVPEStatus", &self.hrVPEStatus).field("bDvdVolInvalid", &self.bDvdVolInvalid).field("bDvdVolUnknown", &self.bDvdVolUnknown).field("bNoLine21In", &self.bNoLine21In).field("bNoLine21Out", &self.bNoLine21Out).field("iNumStreams", &self.iNumStreams).field("iNumStreamsFailed", &self.iNumStreamsFailed).field("dwFailedStreamsFlag", &self.dwFailedStreamsFlag).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_DVD_RENDERSTATUS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_DVD_RENDERSTATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVD_RENDERSTATUS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_DVD_RENDERSTATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_DVD_RENDERSTATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_SECTOR_NOT_PROTECTED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_SECTOR_PROTECTED: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_SECTOR_PROTECT_MASK: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_DVD_STREAM_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_STREAM_VIDEO: AM_DVD_STREAM_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_STREAM_AUDIO: AM_DVD_STREAM_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_DVD_STREAM_SUBPIC: AM_DVD_STREAM_FLAGS = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DVD_YUV {
    pub Reserved: u8,
    pub Y: u8,
    pub U: u8,
    pub V: u8,
}
impl ::core::marker::Copy for AM_DVD_YUV {}
impl ::core::clone::Clone for AM_DVD_YUV {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DVD_YUV {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DVD_YUV").field("Reserved", &self.Reserved).field("Y", &self.Y).field("U", &self.U).field("V", &self.V).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DVD_YUV {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DVD_YUV {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DVD_YUV>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DVD_YUV {}
impl ::core::default::Default for AM_DVD_YUV {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_DvdKaraokeData {
    pub dwDownmix: u32,
    pub dwSpeakerAssignment: u32,
}
impl ::core::marker::Copy for AM_DvdKaraokeData {}
impl ::core::clone::Clone for AM_DvdKaraokeData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_DvdKaraokeData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_DvdKaraokeData").field("dwDownmix", &self.dwDownmix).field("dwSpeakerAssignment", &self.dwSpeakerAssignment).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_DvdKaraokeData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_DvdKaraokeData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_DvdKaraokeData>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_DvdKaraokeData {}
impl ::core::default::Default for AM_DvdKaraokeData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_ExactRateChange {
    pub OutputZeroTime: i64,
    pub Rate: i32,
}
impl ::core::marker::Copy for AM_ExactRateChange {}
impl ::core::clone::Clone for AM_ExactRateChange {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_ExactRateChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_ExactRateChange").field("OutputZeroTime", &self.OutputZeroTime).field("Rate", &self.Rate).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_ExactRateChange {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_ExactRateChange {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_ExactRateChange>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_ExactRateChange {}
impl ::core::default::Default for AM_ExactRateChange {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_FILESINK_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_FILE_OVERWRITE: AM_FILESINK_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_FILTER_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_FILTER_FLAGS_REMOVABLE: AM_FILTER_FLAGS = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_FRAMESTEP_STEP {
    pub dwFramesToStep: u32,
}
impl ::core::marker::Copy for AM_FRAMESTEP_STEP {}
impl ::core::clone::Clone for AM_FRAMESTEP_STEP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_FRAMESTEP_STEP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_FRAMESTEP_STEP").field("dwFramesToStep", &self.dwFramesToStep).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_FRAMESTEP_STEP {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_FRAMESTEP_STEP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_FRAMESTEP_STEP>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_FRAMESTEP_STEP {}
impl ::core::default::Default for AM_FRAMESTEP_STEP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GBF_NODDSURFACELOCK: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GBF_NOTASYNCPOINT: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GBF_NOWAIT: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GBF_PREVFRAMESKIPPED: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GETDECODERCAP_QUERY_EVR_SUPPORT: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GETDECODERCAP_QUERY_VMR9_SUPPORT: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GETDECODERCAP_QUERY_VMR_SUPPORT: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_GRAPH_CONFIG_RECONNECT_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT: AM_GRAPH_CONFIG_RECONNECT_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_LINE21_CCLEVEL = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCLEVEL_TC2: AM_LINE21_CCLEVEL = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_LINE21_CCSERVICE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_None: AM_LINE21_CCSERVICE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_Caption1: AM_LINE21_CCSERVICE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_Caption2: AM_LINE21_CCSERVICE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_Text1: AM_LINE21_CCSERVICE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_Text2: AM_LINE21_CCSERVICE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_XDS: AM_LINE21_CCSERVICE = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_DefChannel: AM_LINE21_CCSERVICE = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSERVICE_Invalid: AM_LINE21_CCSERVICE = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_LINE21_CCSTATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTATE_Off: AM_LINE21_CCSTATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTATE_On: AM_LINE21_CCSTATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_LINE21_CCSTYLE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTYLE_None: AM_LINE21_CCSTYLE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTYLE_PopOn: AM_LINE21_CCSTYLE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTYLE_PaintOn: AM_LINE21_CCSTYLE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_CCSTYLE_RollUp: AM_LINE21_CCSTYLE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_LINE21_DRAWBGMODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_DRAWBGMODE_Opaque: AM_LINE21_DRAWBGMODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_L21_DRAWBGMODE_Transparent: AM_LINE21_DRAWBGMODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_CLOSED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_CONNECTING: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_LOADINGDESCR: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_LOADINGMCAST: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_LOCATING: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_OPEN: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_LOADSTATUS_OPENING: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_MEDIAEVENT_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MEDIAEVENT_NONOTIFY: AM_MEDIAEVENT_FLAGS = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_MEDIA_TYPE {
    pub majortype: ::windows::core::GUID,
    pub subtype: ::windows::core::GUID,
    pub bFixedSizeSamples: super::super::Foundation::BOOL,
    pub bTemporalCompression: super::super::Foundation::BOOL,
    pub lSampleSize: u32,
    pub formattype: ::windows::core::GUID,
    pub pUnk: ::core::option::Option<::windows::core::IUnknown>,
    pub cbFormat: u32,
    pub pbFormat: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_MEDIA_TYPE {
    fn clone(&self) -> Self {
        Self {
            majortype: self.majortype,
            subtype: self.subtype,
            bFixedSizeSamples: self.bFixedSizeSamples,
            bTemporalCompression: self.bTemporalCompression,
            lSampleSize: self.lSampleSize,
            formattype: self.formattype,
            pUnk: self.pUnk.clone(),
            cbFormat: self.cbFormat,
            pbFormat: self.pbFormat,
        }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_MEDIA_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_MEDIA_TYPE").field("majortype", &self.majortype).field("subtype", &self.subtype).field("bFixedSizeSamples", &self.bFixedSizeSamples).field("bTemporalCompression", &self.bTemporalCompression).field("lSampleSize", &self.lSampleSize).field("formattype", &self.formattype).field("pUnk", &self.pUnk).field("cbFormat", &self.cbFormat).field("pbFormat", &self.pbFormat).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_MEDIA_TYPE {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_MEDIA_TYPE {
    fn eq(&self, other: &Self) -> bool {
        self.majortype == other.majortype && self.subtype == other.subtype && self.bFixedSizeSamples == other.bFixedSizeSamples && self.bTemporalCompression == other.bTemporalCompression && self.lSampleSize == other.lSampleSize && self.formattype == other.formattype && self.pUnk == other.pUnk && self.cbFormat == other.cbFormat && self.pbFormat == other.pbFormat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_MEDIA_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_MEDIA_TYPE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_MPEG2Level = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Level_Low: AM_MPEG2Level = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Level_Main: AM_MPEG2Level = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Level_High1440: AM_MPEG2Level = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Level_High: AM_MPEG2Level = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_MPEG2Profile = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Profile_Simple: AM_MPEG2Profile = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Profile_Main: AM_MPEG2Profile = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Profile_SNRScalable: AM_MPEG2Profile = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Profile_SpatiallyScalable: AM_MPEG2Profile = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG2Profile_High: AM_MPEG2Profile = 5i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_MPEGSTREAMTYPE {
    pub dwStreamId: u32,
    pub dwReserved: u32,
    pub mt: AM_MEDIA_TYPE,
    pub bFormat: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_MPEGSTREAMTYPE {
    fn clone(&self) -> Self {
        Self { dwStreamId: self.dwStreamId, dwReserved: self.dwReserved, mt: self.mt.clone(), bFormat: self.bFormat }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_MPEGSTREAMTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_MPEGSTREAMTYPE").field("dwStreamId", &self.dwStreamId).field("dwReserved", &self.dwReserved).field("mt", &self.mt).field("bFormat", &self.bFormat).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_MPEGSTREAMTYPE {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_MPEGSTREAMTYPE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStreamId == other.dwStreamId && self.dwReserved == other.dwReserved && self.mt == other.mt && self.bFormat == other.bFormat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_MPEGSTREAMTYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_MPEGSTREAMTYPE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_MPEGSYSTEMTYPE {
    pub dwBitRate: u32,
    pub cStreams: u32,
    pub Streams: [AM_MPEGSTREAMTYPE; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_MPEGSYSTEMTYPE {
    fn clone(&self) -> Self {
        Self { dwBitRate: self.dwBitRate, cStreams: self.cStreams, Streams: self.Streams.clone() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_MPEGSYSTEMTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_MPEGSYSTEMTYPE").field("dwBitRate", &self.dwBitRate).field("cStreams", &self.cStreams).field("Streams", &self.Streams).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_MPEGSYSTEMTYPE {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_MPEGSYSTEMTYPE {
    fn eq(&self, other: &Self) -> bool {
        self.dwBitRate == other.dwBitRate && self.cStreams == other.cStreams && self.Streams == other.Streams
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_MPEGSYSTEMTYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_MPEGSYSTEMTYPE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG_AUDIO_DUAL_LEFT: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG_AUDIO_DUAL_MERGE: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_MPEG_AUDIO_DUAL_RIGHT: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_AC3 = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_ERROR_CONCEALMENT: AM_PROPERTY_AC3 = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_ALTERNATE_AUDIO: AM_PROPERTY_AC3 = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_DOWNMIX: AM_PROPERTY_AC3 = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_BIT_STREAM_MODE: AM_PROPERTY_AC3 = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_DIALOGUE_LEVEL: AM_PROPERTY_AC3 = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_LANGUAGE_CODE: AM_PROPERTY_AC3 = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_AC3_ROOM_TYPE: AM_PROPERTY_AC3 = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_DVDCOPYPROT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_CHLG_KEY: AM_PROPERTY_DVDCOPYPROT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_DVD_KEY1: AM_PROPERTY_DVDCOPYPROT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_DEC_KEY2: AM_PROPERTY_DVDCOPYPROT = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_TITLE_KEY: AM_PROPERTY_DVDCOPYPROT = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_COPY_MACROVISION: AM_PROPERTY_DVDCOPYPROT = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_REGION: AM_PROPERTY_DVDCOPYPROT = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_SET_COPY_STATE: AM_PROPERTY_DVDCOPYPROT = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_COPY_ANALOG_COMPONENT: AM_PROPERTY_DVDCOPYPROT = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_COPY_DIGITAL_CP: AM_PROPERTY_DVDCOPYPROT = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_COPY_DVD_SRM: AM_PROPERTY_DVDCOPYPROT = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_SUPPORTS_NEW_KEYCOUNT: AM_PROPERTY_DVDCOPYPROT = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDCOPY_DISC_KEY: AM_PROPERTY_DVDCOPYPROT = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_DVDKARAOKE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDKARAOKE_ENABLE: AM_PROPERTY_DVDKARAOKE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDKARAOKE_DATA: AM_PROPERTY_DVDKARAOKE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_DVDSUBPIC = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDSUBPIC_PALETTE: AM_PROPERTY_DVDSUBPIC = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDSUBPIC_HLI: AM_PROPERTY_DVDSUBPIC = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_DVDSUBPIC_COMPOSIT_ON: AM_PROPERTY_DVDSUBPIC = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_DVD_RATE_CHANGE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_ChangeRate: AM_PROPERTY_DVD_RATE_CHANGE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_FullDataRateMax: AM_PROPERTY_DVD_RATE_CHANGE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_ReverseDecode: AM_PROPERTY_DVD_RATE_CHANGE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_DecoderPosition: AM_PROPERTY_DVD_RATE_CHANGE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_DecoderVersion: AM_PROPERTY_DVD_RATE_CHANGE = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_FRAMESTEP = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_FRAMESTEP_STEP: AM_PROPERTY_FRAMESTEP = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_FRAMESTEP_CANCEL: AM_PROPERTY_FRAMESTEP = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_FRAMESTEP_CANSTEP: AM_PROPERTY_FRAMESTEP = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE: AM_PROPERTY_FRAMESTEP = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_PROPERTY_SPHLI {
    pub HLISS: u16,
    pub Reserved: u16,
    pub StartPTM: u32,
    pub EndPTM: u32,
    pub StartX: u16,
    pub StartY: u16,
    pub StopX: u16,
    pub StopY: u16,
    pub ColCon: AM_COLCON,
}
impl ::core::marker::Copy for AM_PROPERTY_SPHLI {}
impl ::core::clone::Clone for AM_PROPERTY_SPHLI {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_PROPERTY_SPHLI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_PROPERTY_SPHLI").field("HLISS", &self.HLISS).field("Reserved", &self.Reserved).field("StartPTM", &self.StartPTM).field("EndPTM", &self.EndPTM).field("StartX", &self.StartX).field("StartY", &self.StartY).field("StopX", &self.StopX).field("StopY", &self.StopY).field("ColCon", &self.ColCon).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_PROPERTY_SPHLI {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_PROPERTY_SPHLI {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_PROPERTY_SPHLI>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_PROPERTY_SPHLI {}
impl ::core::default::Default for AM_PROPERTY_SPHLI {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_PROPERTY_SPPAL {
    pub sppal: [AM_DVD_YUV; 16],
}
impl ::core::marker::Copy for AM_PROPERTY_SPPAL {}
impl ::core::clone::Clone for AM_PROPERTY_SPPAL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_PROPERTY_SPPAL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_PROPERTY_SPPAL").field("sppal", &self.sppal).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_PROPERTY_SPPAL {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_PROPERTY_SPPAL {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_PROPERTY_SPPAL>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_PROPERTY_SPPAL {}
impl ::core::default::Default for AM_PROPERTY_SPPAL {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_PROPERTY_TS_RATE_CHANGE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_SimpleRateChange: AM_PROPERTY_TS_RATE_CHANGE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_ExactRateChange: AM_PROPERTY_TS_RATE_CHANGE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_MaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_Step: AM_PROPERTY_TS_RATE_CHANGE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_UseRateVersion: AM_PROPERTY_TS_RATE_CHANGE = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_QueryFullFrameRate: AM_PROPERTY_TS_RATE_CHANGE = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_QueryLastRateSegPTS: AM_PROPERTY_TS_RATE_CHANGE = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_CorrectTS: AM_PROPERTY_TS_RATE_CHANGE = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_ReverseMaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_ResetOnTimeDisc: AM_PROPERTY_TS_RATE_CHANGE = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_RATE_QueryMapping: AM_PROPERTY_TS_RATE_CHANGE = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_QUERY_DECODER_ATSC_HD_SUPPORT: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_QUERY_DECODER_ATSC_SD_SUPPORT: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_QUERY_DECODER_DVD_SUPPORT: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_QUERY_DECODER_DXVA_1_SUPPORT: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_QUERY_DECODER_VMR_SUPPORT: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_QueryRate {
    pub lMaxForwardFullFrame: i32,
    pub lMaxReverseFullFrame: i32,
}
impl ::core::marker::Copy for AM_QueryRate {}
impl ::core::clone::Clone for AM_QueryRate {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_QueryRate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_QueryRate").field("lMaxForwardFullFrame", &self.lMaxForwardFullFrame).field("lMaxReverseFullFrame", &self.lMaxReverseFullFrame).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_QueryRate {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_QueryRate {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_QueryRate>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_QueryRate {}
impl ::core::default::Default for AM_QueryRate {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ReverseBlockEnd: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_ReverseBlockStart: u32 = 2u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AM_SAMPLE2_PROPERTIES {
    pub cbData: u32,
    pub dwTypeSpecificFlags: u32,
    pub dwSampleFlags: u32,
    pub lActual: i32,
    pub tStart: i64,
    pub tStop: i64,
    pub dwStreamId: u32,
    pub pMediaType: *mut AM_MEDIA_TYPE,
    pub pbBuffer: *mut u8,
    pub cbBuffer: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AM_SAMPLE2_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AM_SAMPLE2_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AM_SAMPLE2_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_SAMPLE2_PROPERTIES").field("cbData", &self.cbData).field("dwTypeSpecificFlags", &self.dwTypeSpecificFlags).field("dwSampleFlags", &self.dwSampleFlags).field("lActual", &self.lActual).field("tStart", &self.tStart).field("tStop", &self.tStop).field("dwStreamId", &self.dwStreamId).field("pMediaType", &self.pMediaType).field("pbBuffer", &self.pbBuffer).field("cbBuffer", &self.cbBuffer).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AM_SAMPLE2_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AM_SAMPLE2_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_SAMPLE2_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AM_SAMPLE2_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AM_SAMPLE2_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_SAMPLE_PROPERTY_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_SPLICEPOINT: AM_SAMPLE_PROPERTY_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_PREROLL: AM_SAMPLE_PROPERTY_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_DATADISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_TYPECHANGED: AM_SAMPLE_PROPERTY_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_TIMEVALID: AM_SAMPLE_PROPERTY_FLAGS = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_TIMEDISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_FLUSH_ON_PAUSE: AM_SAMPLE_PROPERTY_FLAGS = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_STOPVALID: AM_SAMPLE_PROPERTY_FLAGS = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SAMPLE_ENDOFSTREAM: AM_SAMPLE_PROPERTY_FLAGS = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_MEDIA: AM_SAMPLE_PROPERTY_FLAGS = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_CONTROL: AM_SAMPLE_PROPERTY_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_SEEKING_SEEKING_CAPABILITIES = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanSeekAbsolute: AM_SEEKING_SEEKING_CAPABILITIES = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanSeekForwards: AM_SEEKING_SEEKING_CAPABILITIES = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanSeekBackwards: AM_SEEKING_SEEKING_CAPABILITIES = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanGetCurrentPos: AM_SEEKING_SEEKING_CAPABILITIES = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanGetStopPos: AM_SEEKING_SEEKING_CAPABILITIES = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanGetDuration: AM_SEEKING_SEEKING_CAPABILITIES = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanPlayBackwards: AM_SEEKING_SEEKING_CAPABILITIES = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_CanDoSegments: AM_SEEKING_SEEKING_CAPABILITIES = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_Source: AM_SEEKING_SEEKING_CAPABILITIES = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_SEEKING_SeekingFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_NoPositioning: AM_SEEKING_SeekingFlags = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_AbsolutePositioning: AM_SEEKING_SeekingFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_RelativePositioning: AM_SEEKING_SeekingFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_IncrementalPositioning: AM_SEEKING_SeekingFlags = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_PositioningBitsMask: AM_SEEKING_SeekingFlags = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_SeekToKeyFrame: AM_SEEKING_SeekingFlags = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_ReturnTime: AM_SEEKING_SeekingFlags = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_Segment: AM_SEEKING_SeekingFlags = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_SEEKING_NoFlush: AM_SEEKING_SeekingFlags = 32i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_STREAM_INFO {
    pub tStart: i64,
    pub tStop: i64,
    pub dwStartCookie: u32,
    pub dwStopCookie: u32,
    pub dwFlags: u32,
}
impl ::core::marker::Copy for AM_STREAM_INFO {}
impl ::core::clone::Clone for AM_STREAM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_STREAM_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_STREAM_INFO").field("tStart", &self.tStart).field("tStop", &self.tStop).field("dwStartCookie", &self.dwStartCookie).field("dwStopCookie", &self.dwStopCookie).field("dwFlags", &self.dwFlags).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_STREAM_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_STREAM_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_STREAM_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_STREAM_INFO {}
impl ::core::default::Default for AM_STREAM_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_STREAM_INFO_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_INFO_START_DEFINED: AM_STREAM_INFO_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_INFO_STOP_DEFINED: AM_STREAM_INFO_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_INFO_DISCARDING: AM_STREAM_INFO_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_STREAM_INFO_STOP_SEND_EXTRA: AM_STREAM_INFO_FLAGS = 16i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_SimpleRateChange {
    pub StartTime: i64,
    pub Rate: i32,
}
impl ::core::marker::Copy for AM_SimpleRateChange {}
impl ::core::clone::Clone for AM_SimpleRateChange {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_SimpleRateChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_SimpleRateChange").field("StartTime", &self.StartTime).field("Rate", &self.Rate).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_SimpleRateChange {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_SimpleRateChange {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_SimpleRateChange>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_SimpleRateChange {}
impl ::core::default::Default for AM_SimpleRateChange {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_UseNewCSSKey: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_B_SAMPLE: i32 = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_FIELD1: i32 = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_FIELD1FIRST: i32 = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_FIELD2: i32 = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_FIELD_MASK: i32 = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_INTERLEAVED_FRAME: i32 = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_IPB_MASK: i32 = 48i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_I_SAMPLE: i32 = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_P_SAMPLE: i32 = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_REPEAT_FIELD: i32 = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_VIDEO_FLAG_WEAVE: i32 = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_WST_DRAWBGMODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_DRAWBGMODE_Opaque: AM_WST_DRAWBGMODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_DRAWBGMODE_Transparent: AM_WST_DRAWBGMODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_WST_LEVEL = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_LEVEL_1_5: AM_WST_LEVEL = 0i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AM_WST_PAGE {
    pub dwPageNr: u32,
    pub dwSubPageNr: u32,
    pub pucPageData: *mut u8,
}
impl ::core::marker::Copy for AM_WST_PAGE {}
impl ::core::clone::Clone for AM_WST_PAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AM_WST_PAGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AM_WST_PAGE").field("dwPageNr", &self.dwPageNr).field("dwSubPageNr", &self.dwSubPageNr).field("pucPageData", &self.pucPageData).finish()
    }
}
unsafe impl ::windows::core::Abi for AM_WST_PAGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AM_WST_PAGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AM_WST_PAGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for AM_WST_PAGE {}
impl ::core::default::Default for AM_WST_PAGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_WST_SERVICE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_SERVICE_None: AM_WST_SERVICE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_SERVICE_Text: AM_WST_SERVICE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_SERVICE_IDS: AM_WST_SERVICE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_SERVICE_Invalid: AM_WST_SERVICE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_WST_STATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_STATE_Off: AM_WST_STATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_STATE_On: AM_WST_STATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AM_WST_STYLE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_STYLE_None: AM_WST_STYLE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AM_WST_STYLE_Invers: AM_WST_STYLE = 1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct ANALOGVIDEOINFO {
    pub rcSource: super::super::Foundation::RECT,
    pub rcTarget: super::super::Foundation::RECT,
    pub dwActiveWidth: u32,
    pub dwActiveHeight: u32,
    pub AvgTimePerFrame: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for ANALOGVIDEOINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for ANALOGVIDEOINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for ANALOGVIDEOINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ANALOGVIDEOINFO").field("rcSource", &self.rcSource).field("rcTarget", &self.rcTarget).field("dwActiveWidth", &self.dwActiveWidth).field("dwActiveHeight", &self.dwActiveHeight).field("AvgTimePerFrame", &self.AvgTimePerFrame).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for ANALOGVIDEOINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for ANALOGVIDEOINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ANALOGVIDEOINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for ANALOGVIDEOINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for ANALOGVIDEOINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const ANALOG_AUXIN_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x742ef867_09e1_40a3_82d3_9669ba35325f);
pub const ANALOG_FM_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7728087b_2bb9_4e30_8078_449476e59dbb);
pub const ANALOG_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb820d87e_e0e3_478f_8a38_4e13f7b3df42);
pub const ATSCChannelTuneRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0369b4e6_45b6_11d3_b650_00c04f79498e);
pub const ATSCComponentType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa8dcf3d5_0780_4ef4_8a83_2cffaacb8ace);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ATSCComponentTypeFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSCCT_AC3: ATSCComponentTypeFlags = 1i32;
pub const ATSCLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8872ff1b_98fa_4d7a_8d93_c9f1055f85bb);
pub const ATSCTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa2e30750_6c3d_11d3_b653_00c04f79498e);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_EIT_TID: u32 = 203u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_EVENT: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_PSIP: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_ETM_LOCATION_NOT_PRESENT: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_ETM_LOCATION_RESERVED: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_ETT_TID: u32 = 204u32;
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct ATSC_FILTER_OPTIONS {
    pub fSpecifyEtmId: super::super::Foundation::BOOL,
    pub EtmId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for ATSC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for ATSC_FILTER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for ATSC_FILTER_OPTIONS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for ATSC_FILTER_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ATSC_FILTER_OPTIONS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for ATSC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for ATSC_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_MGT_PID: u32 = 8187u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_MGT_TID: u32 = 199u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_PIT_TID: u32 = 208u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_RRT_PID: u32 = 8187u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_RRT_TID: u32 = 202u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_STT_PID: u32 = 8187u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_STT_TID: u32 = 205u32;
pub const ATSC_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0dad2fdd_5fd7_11d3_8f50_00c04f7971e2);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_VCT_CABL_TID: u32 = 201u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_VCT_PID: u32 = 8187u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ATSC_VCT_TERR_TID: u32 = 200u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AUDIO_STREAM_CONFIG_CAPS {
    pub guid: ::windows::core::GUID,
    pub MinimumChannels: u32,
    pub MaximumChannels: u32,
    pub ChannelsGranularity: u32,
    pub MinimumBitsPerSample: u32,
    pub MaximumBitsPerSample: u32,
    pub BitsPerSampleGranularity: u32,
    pub MinimumSampleFrequency: u32,
    pub MaximumSampleFrequency: u32,
    pub SampleFrequencyGranularity: u32,
}
impl ::core::marker::Copy for AUDIO_STREAM_CONFIG_CAPS {}
impl ::core::clone::Clone for AUDIO_STREAM_CONFIG_CAPS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AUDIO_STREAM_CONFIG_CAPS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUDIO_STREAM_CONFIG_CAPS")
            .field("guid", &self.guid)
            .field("MinimumChannels", &self.MinimumChannels)
            .field("MaximumChannels", &self.MaximumChannels)
            .field("ChannelsGranularity", &self.ChannelsGranularity)
            .field("MinimumBitsPerSample", &self.MinimumBitsPerSample)
            .field("MaximumBitsPerSample", &self.MaximumBitsPerSample)
            .field("BitsPerSampleGranularity", &self.BitsPerSampleGranularity)
            .field("MinimumSampleFrequency", &self.MinimumSampleFrequency)
            .field("MaximumSampleFrequency", &self.MaximumSampleFrequency)
            .field("SampleFrequencyGranularity", &self.SampleFrequencyGranularity)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for AUDIO_STREAM_CONFIG_CAPS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AUDIO_STREAM_CONFIG_CAPS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AUDIO_STREAM_CONFIG_CAPS>()) == 0 }
    }
}
impl ::core::cmp::Eq for AUDIO_STREAM_CONFIG_CAPS {}
impl ::core::default::Default for AUDIO_STREAM_CONFIG_CAPS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIEXTHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwGrandFrames: u32,
    pub dwFuture: [u32; 61],
}
impl ::core::marker::Copy for AVIEXTHEADER {}
impl ::core::clone::Clone for AVIEXTHEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIEXTHEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIEXTHEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIEXTHEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIEXTHEADER {}
impl ::core::default::Default for AVIEXTHEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIFIELDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved3: u32,
    pub aIndex: [AVIFIELDINDEX_0; 1],
}
impl ::core::marker::Copy for AVIFIELDINDEX {}
impl ::core::clone::Clone for AVIFIELDINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIFIELDINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIFIELDINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIFIELDINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIFIELDINDEX {}
impl ::core::default::Default for AVIFIELDINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIFIELDINDEX_0 {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwOffsetField2: u32,
}
impl ::core::marker::Copy for AVIFIELDINDEX_0 {}
impl ::core::clone::Clone for AVIFIELDINDEX_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIFIELDINDEX_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIFIELDINDEX_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIFIELDINDEX_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIFIELDINDEX_0 {}
impl ::core::default::Default for AVIFIELDINDEX_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_COPYRIGHTED: u32 = 131072u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_HASINDEX: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_ISINTERLEAVED: u32 = 256u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_MUSTUSEINDEX: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_TRUSTCKTYPE: u32 = 2048u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIF_WASCAPTUREFILE: u32 = 65536u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_COMPRESSOR: u32 = 268369920u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_COMPUSE: i32 = 268369920i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_FIRSTPART: i32 = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_KEYFRAME: i32 = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_LASTPART: i32 = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_LIST: i32 = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_NOTIME: i32 = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVIIF_NO_TIME: u32 = 256u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIINDEXENTRY {
    pub ckid: u32,
    pub dwFlags: u32,
    pub dwChunkOffset: u32,
    pub dwChunkLength: u32,
}
impl ::core::marker::Copy for AVIINDEXENTRY {}
impl ::core::clone::Clone for AVIINDEXENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AVIINDEXENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AVIINDEXENTRY").field("ckid", &self.ckid).field("dwFlags", &self.dwFlags).field("dwChunkOffset", &self.dwChunkOffset).field("dwChunkLength", &self.dwChunkLength).finish()
    }
}
unsafe impl ::windows::core::Abi for AVIINDEXENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIINDEXENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIINDEXENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIINDEXENTRY {}
impl ::core::default::Default for AVIINDEXENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIMAINHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwMicroSecPerFrame: u32,
    pub dwMaxBytesPerSec: u32,
    pub dwPaddingGranularity: u32,
    pub dwFlags: u32,
    pub dwTotalFrames: u32,
    pub dwInitialFrames: u32,
    pub dwStreams: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dwReserved: [u32; 4],
}
impl ::core::marker::Copy for AVIMAINHEADER {}
impl ::core::clone::Clone for AVIMAINHEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIMAINHEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIMAINHEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIMAINHEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIMAINHEADER {}
impl ::core::default::Default for AVIMAINHEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIMETAINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub adwIndex: [u32; 1],
}
impl ::core::marker::Copy for AVIMETAINDEX {}
impl ::core::clone::Clone for AVIMETAINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIMETAINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIMETAINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIMETAINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIMETAINDEX {}
impl ::core::default::Default for AVIMETAINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIOLDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub aIndex: [AVIOLDINDEX_0; 1],
}
impl ::core::marker::Copy for AVIOLDINDEX {}
impl ::core::clone::Clone for AVIOLDINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIOLDINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIOLDINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIOLDINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIOLDINDEX {}
impl ::core::default::Default for AVIOLDINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVIOLDINDEX_0 {
    pub dwChunkId: u32,
    pub dwFlags: u32,
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl ::core::marker::Copy for AVIOLDINDEX_0 {}
impl ::core::clone::Clone for AVIOLDINDEX_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVIOLDINDEX_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVIOLDINDEX_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIOLDINDEX_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVIOLDINDEX_0 {}
impl ::core::default::Default for AVIOLDINDEX_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
pub struct AVIPALCHANGE {
    pub bFirstEntry: u8,
    pub bNumEntries: u8,
    pub wFlags: u16,
    pub peNew: [super::super::Graphics::Gdi::PALETTEENTRY; 1],
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::marker::Copy for AVIPALCHANGE {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::clone::Clone for AVIPALCHANGE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::fmt::Debug for AVIPALCHANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AVIPALCHANGE").field("bFirstEntry", &self.bFirstEntry).field("bNumEntries", &self.bNumEntries).field("wFlags", &self.wFlags).field("peNew", &self.peNew).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::core::Abi for AVIPALCHANGE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::cmp::PartialEq for AVIPALCHANGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIPALCHANGE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::cmp::Eq for AVIPALCHANGE {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::core::default::Default for AVIPALCHANGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVISF_DISABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVISF_VIDEO_PALCHANGES: u32 = 65536u32;
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISTDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved_3: u32,
    pub aIndex: [AVISTDINDEX_ENTRY; 2044],
}
impl ::core::marker::Copy for AVISTDINDEX {}
impl ::core::clone::Clone for AVISTDINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVISTDINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISTDINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISTDINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISTDINDEX {}
impl ::core::default::Default for AVISTDINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVISTDINDEX_DELTAFRAME: u32 = 2147483648u32;
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISTDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl ::core::marker::Copy for AVISTDINDEX_ENTRY {}
impl ::core::clone::Clone for AVISTDINDEX_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVISTDINDEX_ENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISTDINDEX_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISTDINDEX_ENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISTDINDEX_ENTRY {}
impl ::core::default::Default for AVISTDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISTREAMHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: AVISTREAMHEADER_0,
}
impl ::core::marker::Copy for AVISTREAMHEADER {}
impl ::core::clone::Clone for AVISTREAMHEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVISTREAMHEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISTREAMHEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISTREAMHEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISTREAMHEADER {}
impl ::core::default::Default for AVISTREAMHEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISTREAMHEADER_0 {
    pub left: i16,
    pub top: i16,
    pub right: i16,
    pub bottom: i16,
}
impl ::core::marker::Copy for AVISTREAMHEADER_0 {}
impl ::core::clone::Clone for AVISTREAMHEADER_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AVISTREAMHEADER_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AVISTREAMHEADER_0").field("left", &self.left).field("top", &self.top).field("right", &self.right).field("bottom", &self.bottom).finish()
    }
}
unsafe impl ::windows::core::Abi for AVISTREAMHEADER_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISTREAMHEADER_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISTREAMHEADER_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISTREAMHEADER_0 {}
impl ::core::default::Default for AVISTREAMHEADER_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISUPERINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [AVISUPERINDEX_0; 1022],
}
impl ::core::marker::Copy for AVISUPERINDEX {}
impl ::core::clone::Clone for AVISUPERINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVISUPERINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISUPERINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISUPERINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISUPERINDEX {}
impl ::core::default::Default for AVISUPERINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVISUPERINDEX_0 {
    pub qwOffset: u64,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl ::core::marker::Copy for AVISUPERINDEX_0 {}
impl ::core::clone::Clone for AVISUPERINDEX_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVISUPERINDEX_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVISUPERINDEX_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVISUPERINDEX_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVISUPERINDEX_0 {}
impl ::core::default::Default for AVISUPERINDEX_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AVIStreamHeader {
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AVIStreamHeader {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AVIStreamHeader {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AVIStreamHeader {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AVIStreamHeader")
            .field("fccType", &self.fccType)
            .field("fccHandler", &self.fccHandler)
            .field("dwFlags", &self.dwFlags)
            .field("wPriority", &self.wPriority)
            .field("wLanguage", &self.wLanguage)
            .field("dwInitialFrames", &self.dwInitialFrames)
            .field("dwScale", &self.dwScale)
            .field("dwRate", &self.dwRate)
            .field("dwStart", &self.dwStart)
            .field("dwLength", &self.dwLength)
            .field("dwSuggestedBufferSize", &self.dwSuggestedBufferSize)
            .field("dwQuality", &self.dwQuality)
            .field("dwSampleSize", &self.dwSampleSize)
            .field("rcFrame", &self.rcFrame)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AVIStreamHeader {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AVIStreamHeader {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVIStreamHeader>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AVIStreamHeader {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AVIStreamHeader {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVITCDLINDEX_ENTRY {
    pub dwTick: u32,
    pub time: super::TIMECODE,
    pub dwSMPTEflags: u32,
    pub dwUser: u32,
    pub szReelId: [i8; 12],
}
impl ::core::marker::Copy for AVITCDLINDEX_ENTRY {}
impl ::core::clone::Clone for AVITCDLINDEX_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVITCDLINDEX_ENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVITCDLINDEX_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVITCDLINDEX_ENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVITCDLINDEX_ENTRY {}
impl ::core::default::Default for AVITCDLINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVITIMECODEINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [TIMECODEDATA; 1022],
}
impl ::core::marker::Copy for AVITIMECODEINDEX {}
impl ::core::clone::Clone for AVITIMECODEINDEX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVITIMECODEINDEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVITIMECODEINDEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVITIMECODEINDEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVITIMECODEINDEX {}
impl ::core::default::Default for AVITIMECODEINDEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct AVITIMEDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl ::core::marker::Copy for AVITIMEDINDEX_ENTRY {}
impl ::core::clone::Clone for AVITIMEDINDEX_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for AVITIMEDINDEX_ENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AVITIMEDINDEX_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AVITIMEDINDEX_ENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for AVITIMEDINDEX_ENTRY {}
impl ::core::default::Default for AVITIMEDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_HEADERSIZE: u32 = 2048u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_IS_DATA: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_OF_CHUNKS: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_OF_INDEXES: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_OF_SUB_2FIELD: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_OF_TIMED_CHUNKS: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_SUB_2FIELD: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AVI_INDEX_SUB_DEFAULT: u32 = 0u32;
pub const AnalogAudioComponentType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28ab0005_e845_4ffa_aa9b_f4665236141c);
pub const AnalogLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49638b91_48ab_48b7_a47a_7d0e75a08ede);
pub const AnalogRadioTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8a674b4c_1f63_11d3_b64c_00c04f79498e);
pub const AnalogTVTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8a674b4d_1f63_11d3_b64c_00c04f79498e);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type AnalogVideoStandard = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_None: AnalogVideoStandard = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_NTSC_M: AnalogVideoStandard = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_NTSC_M_J: AnalogVideoStandard = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_NTSC_433: AnalogVideoStandard = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_B: AnalogVideoStandard = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_D: AnalogVideoStandard = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_G: AnalogVideoStandard = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_H: AnalogVideoStandard = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_I: AnalogVideoStandard = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_M: AnalogVideoStandard = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_N: AnalogVideoStandard = 1024i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_60: AnalogVideoStandard = 2048i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_B: AnalogVideoStandard = 4096i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_D: AnalogVideoStandard = 8192i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_G: AnalogVideoStandard = 16384i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_H: AnalogVideoStandard = 32768i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_K: AnalogVideoStandard = 65536i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_K1: AnalogVideoStandard = 131072i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_L: AnalogVideoStandard = 262144i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_L1: AnalogVideoStandard = 524288i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_N_COMBO: AnalogVideoStandard = 1048576i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideoMask_MCE_NTSC: AnalogVideoStandard = 1052167i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideoMask_MCE_PAL: AnalogVideoStandard = 496i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideoMask_MCE_SECAM: AnalogVideoStandard = 1044480i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_NTSC_Mask: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_PAL_Mask: u32 = 1052656u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AnalogVideo_SECAM_Mask: u32 = 1044480u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ApplicationTypeType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_ConditionalAccess: ApplicationTypeType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_POD_Host_Binding_Information: ApplicationTypeType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_IPService: ApplicationTypeType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_NetworkInterface_SCTE55_2: ApplicationTypeType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_NetworkInterface_SCTE55_1: ApplicationTypeType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_CopyProtection: ApplicationTypeType = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_Diagnostic: ApplicationTypeType = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_Undesignated: ApplicationTypeType = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const SCTE28_Reserved: ApplicationTypeType = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Commentary: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Dialogue: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Emergency: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Hearing_Impaired: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Music_And_Effects: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Reserved: i32 = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Standard: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Visually_Impaired: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AudioType_Voiceover: u32 = 7u32;
pub const AuxInTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf9769a06_7aca_4e39_9cfb_97bb35f0e77e);
pub const BDANETWORKTYPE_ATSC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71985f51_1ca1_11d3_9cc8_00c04f7971e0);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDANODE_DESCRIPTOR {
    pub ulBdaNodeType: u32,
    pub guidFunction: ::windows::core::GUID,
    pub guidName: ::windows::core::GUID,
}
impl ::core::marker::Copy for BDANODE_DESCRIPTOR {}
impl ::core::clone::Clone for BDANODE_DESCRIPTOR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDANODE_DESCRIPTOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDANODE_DESCRIPTOR").field("ulBdaNodeType", &self.ulBdaNodeType).field("guidFunction", &self.guidFunction).field("guidName", &self.guidName).finish()
    }
}
unsafe impl ::windows::core::Abi for BDANODE_DESCRIPTOR {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDANODE_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDANODE_DESCRIPTOR>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDANODE_DESCRIPTOR {}
impl ::core::default::Default for BDANODE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_BUFFER {
    pub lResult: i32,
    pub ulBufferSize: u32,
    pub argbBuffer: [u8; 1],
}
impl ::core::marker::Copy for BDA_BUFFER {}
impl ::core::clone::Clone for BDA_BUFFER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_BUFFER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_BUFFER").field("lResult", &self.lResult).field("ulBufferSize", &self.ulBufferSize).field("argbBuffer", &self.argbBuffer).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_BUFFER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_BUFFER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_BUFFER>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_BUFFER {}
impl ::core::default::Default for BDA_BUFFER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
}
impl ::core::marker::Copy for BDA_CAS_CHECK_ENTITLEMENTTOKEN {}
impl ::core::clone::Clone for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CAS_CHECK_ENTITLEMENTTOKEN").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CAS_CHECK_ENTITLEMENTTOKEN>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CAS_CHECK_ENTITLEMENTTOKEN {}
impl ::core::default::Default for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CAS_CLOSEMMIDATA {
    pub ulDialogNumber: u32,
}
impl ::core::marker::Copy for BDA_CAS_CLOSEMMIDATA {}
impl ::core::clone::Clone for BDA_CAS_CLOSEMMIDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CAS_CLOSEMMIDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CAS_CLOSEMMIDATA").field("ulDialogNumber", &self.ulDialogNumber).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CAS_CLOSEMMIDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CAS_CLOSEMMIDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CAS_CLOSEMMIDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CAS_CLOSEMMIDATA {}
impl ::core::default::Default for BDA_CAS_CLOSEMMIDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CAS_CLOSE_MMIDIALOG {
    pub lResult: i32,
    pub SessionResult: u32,
}
impl ::core::marker::Copy for BDA_CAS_CLOSE_MMIDIALOG {}
impl ::core::clone::Clone for BDA_CAS_CLOSE_MMIDIALOG {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CAS_CLOSE_MMIDIALOG {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CAS_CLOSE_MMIDIALOG").field("lResult", &self.lResult).field("SessionResult", &self.SessionResult).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CAS_CLOSE_MMIDIALOG {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CAS_CLOSE_MMIDIALOG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CAS_CLOSE_MMIDIALOG>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CAS_CLOSE_MMIDIALOG {}
impl ::core::default::Default for BDA_CAS_CLOSE_MMIDIALOG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CAS_OPENMMIDATA {
    pub ulDialogNumber: u32,
    pub ulDialogRequest: u32,
    pub uuidDialogType: ::windows::core::GUID,
    pub usDialogDataLength: u16,
    pub argbDialogData: [u8; 1],
}
impl ::core::marker::Copy for BDA_CAS_OPENMMIDATA {}
impl ::core::clone::Clone for BDA_CAS_OPENMMIDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CAS_OPENMMIDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CAS_OPENMMIDATA").field("ulDialogNumber", &self.ulDialogNumber).field("ulDialogRequest", &self.ulDialogRequest).field("uuidDialogType", &self.uuidDialogType).field("usDialogDataLength", &self.usDialogDataLength).field("argbDialogData", &self.argbDialogData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CAS_OPENMMIDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CAS_OPENMMIDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CAS_OPENMMIDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CAS_OPENMMIDATA {}
impl ::core::default::Default for BDA_CAS_OPENMMIDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CAS_REQUESTTUNERDATA {
    pub ucRequestPriority: u8,
    pub ucRequestReason: u8,
    pub ucRequestConsequences: u8,
    pub ulEstimatedTime: u32,
}
impl ::core::marker::Copy for BDA_CAS_REQUESTTUNERDATA {}
impl ::core::clone::Clone for BDA_CAS_REQUESTTUNERDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CAS_REQUESTTUNERDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CAS_REQUESTTUNERDATA").field("ucRequestPriority", &self.ucRequestPriority).field("ucRequestReason", &self.ucRequestReason).field("ucRequestConsequences", &self.ucRequestConsequences).field("ulEstimatedTime", &self.ulEstimatedTime).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CAS_REQUESTTUNERDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CAS_REQUESTTUNERDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CAS_REQUESTTUNERDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CAS_REQUESTTUNERDATA {}
impl ::core::default::Default for BDA_CAS_REQUESTTUNERDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_CA_MODULE_UI {
    pub ulFormat: u32,
    pub ulbcDesc: u32,
    pub ulDesc: [u32; 1],
}
impl ::core::marker::Copy for BDA_CA_MODULE_UI {}
impl ::core::clone::Clone for BDA_CA_MODULE_UI {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_CA_MODULE_UI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_CA_MODULE_UI").field("ulFormat", &self.ulFormat).field("ulbcDesc", &self.ulbcDesc).field("ulDesc", &self.ulDesc).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_CA_MODULE_UI {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_CA_MODULE_UI {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_CA_MODULE_UI>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_CA_MODULE_UI {}
impl ::core::default::Default for BDA_CA_MODULE_UI {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_CHANGE_STATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_CHANGES_COMPLETE: BDA_CHANGE_STATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_CHANGES_PENDING: BDA_CHANGE_STATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_CONDITIONALACCESS_MMICLOSEREASON = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_MMICLOSEREASON = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_CLOSED_ITSELF: BDA_CONDITIONALACCESS_MMICLOSEREASON = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_TUNER_REQUESTED_CLOSE: BDA_CONDITIONALACCESS_MMICLOSEREASON = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_DIALOG_TIMEOUT: BDA_CONDITIONALACCESS_MMICLOSEREASON = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_DIALOG_FOCUS_CHANGE: BDA_CONDITIONALACCESS_MMICLOSEREASON = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_DIALOG_USER_DISMISSED: BDA_CONDITIONALACCESS_MMICLOSEREASON = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_DIALOG_USER_NOT_AVAILABLE: BDA_CONDITIONALACCESS_MMICLOSEREASON = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_CONDITIONALACCESS_REQUESTTYPE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_REQUESTTYPE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ACCESS_NOT_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ACCESS_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ACCESS_POSSIBLE_NO_STREAMING_DISRUPTION: BDA_CONDITIONALACCESS_REQUESTTYPE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_CONDITIONALACCESS_SESSION_RESULT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_SUCCESSFULL: BDA_CONDITIONALACCESS_SESSION_RESULT = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ENDED_NOCHANGE: BDA_CONDITIONALACCESS_SESSION_RESULT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CONDITIONALACCESS_ABORTED: BDA_CONDITIONALACCESS_SESSION_RESULT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Channel = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_UNDEFINED_CHANNEL: BDA_Channel = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Channel_Bandwidth = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_CHAN_BANDWITH_NOT_SET: BDA_Channel_Bandwidth = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_CHAN_BANDWITH_NOT_DEFINED: BDA_Channel_Bandwidth = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Comp_Flags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDACOMP_NOT_DEFINED: BDA_Comp_Flags = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDACOMP_EXCLUDE_TS_FROM_TR: BDA_Comp_Flags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDACOMP_INCLUDE_LOCATOR_IN_TR: BDA_Comp_Flags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDACOMP_INCLUDE_COMPONENTS_IN_TR: BDA_Comp_Flags = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_DEBUG_DATA {
    pub lResult: i32,
    pub uuidDebugDataType: ::windows::core::GUID,
    pub ulDataSize: u32,
    pub argbDebugData: [u8; 1],
}
impl ::core::marker::Copy for BDA_DEBUG_DATA {}
impl ::core::clone::Clone for BDA_DEBUG_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_DEBUG_DATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_DEBUG_DATA").field("lResult", &self.lResult).field("uuidDebugDataType", &self.uuidDebugDataType).field("ulDataSize", &self.ulDataSize).field("argbDebugData", &self.argbDebugData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_DEBUG_DATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_DEBUG_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_DEBUG_DATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_DEBUG_DATA {}
impl ::core::default::Default for BDA_DEBUG_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const BDA_DEBUG_DATA_AVAILABLE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69c24f54_9983_497e_b415_282be4c555fb);
pub const BDA_DEBUG_DATA_TYPE_STRING: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa806e767_de5c_430c_80bf_a21ebe06c748);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_DISCOVERY_STATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DISCOVERY_UNSPECIFIED: BDA_DISCOVERY_STATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DISCOVERY_REQUIRED: BDA_DISCOVERY_STATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DISCOVERY_COMPLETE: BDA_DISCOVERY_STATE = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_DISEQC_RESPONSE {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl ::core::marker::Copy for BDA_DISEQC_RESPONSE {}
impl ::core::clone::Clone for BDA_DISEQC_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_DISEQC_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_DISEQC_RESPONSE").field("ulRequestId", &self.ulRequestId).field("ulPacketLength", &self.ulPacketLength).field("argbPacketData", &self.argbPacketData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_DISEQC_RESPONSE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_DISEQC_RESPONSE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_DISEQC_RESPONSE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_DISEQC_RESPONSE {}
impl ::core::default::Default for BDA_DISEQC_RESPONSE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_DISEQC_SEND {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl ::core::marker::Copy for BDA_DISEQC_SEND {}
impl ::core::clone::Clone for BDA_DISEQC_SEND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_DISEQC_SEND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_DISEQC_SEND").field("ulRequestId", &self.ulRequestId).field("ulPacketLength", &self.ulPacketLength).field("argbPacketData", &self.argbPacketData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_DISEQC_SEND {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_DISEQC_SEND {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_DISEQC_SEND>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_DISEQC_SEND {}
impl ::core::default::Default for BDA_DISEQC_SEND {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_DRM_DRMSTATUS {
    pub lResult: i32,
    pub DRMuuid: ::windows::core::GUID,
    pub ulDrmUuidListStringSize: u32,
    pub argbDrmUuidListString: [::windows::core::GUID; 1],
}
impl ::core::marker::Copy for BDA_DRM_DRMSTATUS {}
impl ::core::clone::Clone for BDA_DRM_DRMSTATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_DRM_DRMSTATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_DRM_DRMSTATUS").field("lResult", &self.lResult).field("DRMuuid", &self.DRMuuid).field("ulDrmUuidListStringSize", &self.ulDrmUuidListStringSize).field("argbDrmUuidListString", &self.argbDrmUuidListString).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_DRM_DRMSTATUS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_DRM_DRMSTATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_DRM_DRMSTATUS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_DRM_DRMSTATUS {}
impl ::core::default::Default for BDA_DRM_DRMSTATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_DVBT2_L1_SIGNALLING_DATA {
    pub L1Pre_TYPE: u8,
    pub L1Pre_BWT_S1_S2: u8,
    pub L1Pre_REPETITION_GUARD_PAPR: u8,
    pub L1Pre_MOD_COD_FEC: u8,
    pub L1Pre_POSTSIZE_INFO_PILOT: [u8; 5],
    pub L1Pre_TX_ID_AVAIL: u8,
    pub L1Pre_CELL_ID: [u8; 2],
    pub L1Pre_NETWORK_ID: [u8; 2],
    pub L1Pre_T2SYSTEM_ID: [u8; 2],
    pub L1Pre_NUM_T2_FRAMES: u8,
    pub L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT: [u8; 2],
    pub L1Pre_NUMRF_CURRENTRF_RESERVED: [u8; 2],
    pub L1Pre_CRC32: [u8; 4],
    pub L1PostData: [u8; 1],
}
impl ::core::marker::Copy for BDA_DVBT2_L1_SIGNALLING_DATA {}
impl ::core::clone::Clone for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_DVBT2_L1_SIGNALLING_DATA")
            .field("L1Pre_TYPE", &self.L1Pre_TYPE)
            .field("L1Pre_BWT_S1_S2", &self.L1Pre_BWT_S1_S2)
            .field("L1Pre_REPETITION_GUARD_PAPR", &self.L1Pre_REPETITION_GUARD_PAPR)
            .field("L1Pre_MOD_COD_FEC", &self.L1Pre_MOD_COD_FEC)
            .field("L1Pre_POSTSIZE_INFO_PILOT", &self.L1Pre_POSTSIZE_INFO_PILOT)
            .field("L1Pre_TX_ID_AVAIL", &self.L1Pre_TX_ID_AVAIL)
            .field("L1Pre_CELL_ID", &self.L1Pre_CELL_ID)
            .field("L1Pre_NETWORK_ID", &self.L1Pre_NETWORK_ID)
            .field("L1Pre_T2SYSTEM_ID", &self.L1Pre_T2SYSTEM_ID)
            .field("L1Pre_NUM_T2_FRAMES", &self.L1Pre_NUM_T2_FRAMES)
            .field("L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT", &self.L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT)
            .field("L1Pre_NUMRF_CURRENTRF_RESERVED", &self.L1Pre_NUMRF_CURRENTRF_RESERVED)
            .field("L1Pre_CRC32", &self.L1Pre_CRC32)
            .field("L1PostData", &self.L1PostData)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_DVBT2_L1_SIGNALLING_DATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_DVBT2_L1_SIGNALLING_DATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_DVBT2_L1_SIGNALLING_DATA {}
impl ::core::default::Default for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_DigitalSignalStandard = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_None: BDA_DigitalSignalStandard = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_DVB_T: BDA_DigitalSignalStandard = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_DVB_S: BDA_DigitalSignalStandard = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_DVB_C: BDA_DigitalSignalStandard = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_ATSC: BDA_DigitalSignalStandard = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_ISDB_T: BDA_DigitalSignalStandard = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_ISDB_S: BDA_DigitalSignalStandard = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_DigitalStandard_ISDB_C: BDA_DigitalSignalStandard = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_DrmPairingError = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_Succeeded: BDA_DrmPairingError = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_HardwareFailure: BDA_DrmPairingError = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_NeedRevocationData: BDA_DrmPairingError = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_NeedIndiv: BDA_DrmPairingError = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_Other: BDA_DrmPairingError = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_DrmInitFailed: BDA_DrmPairingError = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_DrmNotPaired: BDA_DrmPairingError = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_DrmRePairSoon: BDA_DrmPairingError = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_Aborted: BDA_DrmPairingError = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_DrmPairing_NeedSDKUpdate: BDA_DrmPairingError = 9i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_ETHERNET_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl ::core::marker::Copy for BDA_ETHERNET_ADDRESS {}
impl ::core::clone::Clone for BDA_ETHERNET_ADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_ETHERNET_ADDRESS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_ETHERNET_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_ETHERNET_ADDRESS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_ETHERNET_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_ETHERNET_ADDRESS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_ETHERNET_ADDRESS {}
impl ::core::default::Default for BDA_ETHERNET_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_ETHERNET_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_ETHERNET_ADDRESS; 1],
}
impl ::core::marker::Copy for BDA_ETHERNET_ADDRESS_LIST {}
impl ::core::clone::Clone for BDA_ETHERNET_ADDRESS_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_ETHERNET_ADDRESS_LIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_ETHERNET_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_ETHERNET_ADDRESS_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_ETHERNET_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_ETHERNET_ADDRESS_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_ETHERNET_ADDRESS_LIST {}
impl ::core::default::Default for BDA_ETHERNET_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_EVENT_DATA {
    pub lResult: i32,
    pub ulEventID: u32,
    pub uuidEventType: ::windows::core::GUID,
    pub ulEventDataLength: u32,
    pub argbEventData: [u8; 1],
}
impl ::core::marker::Copy for BDA_EVENT_DATA {}
impl ::core::clone::Clone for BDA_EVENT_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_EVENT_DATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_EVENT_DATA").field("lResult", &self.lResult).field("ulEventID", &self.ulEventID).field("uuidEventType", &self.uuidEventType).field("ulEventDataLength", &self.ulEventDataLength).field("argbEventData", &self.argbEventData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_EVENT_DATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_EVENT_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_EVENT_DATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_EVENT_DATA {}
impl ::core::default::Default for BDA_EVENT_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_EVENT_ID = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SIGNAL_LOSS: BDA_EVENT_ID = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SIGNAL_LOCK: BDA_EVENT_ID = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_DATA_START: BDA_EVENT_ID = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_DATA_STOP: BDA_EVENT_ID = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_CHANNEL_ACQUIRED: BDA_EVENT_ID = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_CHANNEL_LOST: BDA_EVENT_ID = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_CHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_CHANNEL_ACTIVATED: BDA_EVENT_ID = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_CHANNEL_DEACTIVATED: BDA_EVENT_ID = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SUBCHANNEL_ACQUIRED: BDA_EVENT_ID = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SUBCHANNEL_LOST: BDA_EVENT_ID = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SUBCHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SUBCHANNEL_ACTIVATED: BDA_EVENT_ID = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SUBCHANNEL_DEACTIVATED: BDA_EVENT_ID = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_ACCESS_GRANTED: BDA_EVENT_ID = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_ACCESS_DENIED: BDA_EVENT_ID = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_OFFER_EXTENDED: BDA_EVENT_ID = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_PURCHASE_COMPLETED: BDA_EVENT_ID = 17i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SMART_CARD_INSERTED: BDA_EVENT_ID = 18i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_EVENT_SMART_CARD_REMOVED: BDA_EVENT_ID = 19i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_ACCESS_DENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479671i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_BUFFER_TOO_SMALL: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479669i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_DISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479666i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_FAILURE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479679i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_CAPTURE_TOKEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073463294i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_ENTITLEMENT_TOKEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073463295i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_HANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479674i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_LANGUAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479664i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_PURCHASE_TOKEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073463292i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_SCHEMA: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479675i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_TUNE_REQUEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073467388i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_INVALID_TYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479673i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_IPNETWORK_ADDRESS_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073459198i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_IPNETWORK_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073459199i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_IPNETWORK_TIMEOUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073459197i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_IPNETWORK_UNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073459196i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479670i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NOT_IMPLEMENTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479678i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NO_HANDLER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479665i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NO_MORE_DATA: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073475582i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NO_MORE_EVENTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073475583i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_NO_SUCH_COMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479677i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_OUT_OF_BOUNDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479676i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_OUT_OF_MEMORY: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479667i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_OUT_OF_RESOURCES: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479668i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_READ_ONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479672i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TIMEOUT_ELAPSED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073479663i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNER_CONFLICT: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073467389i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNER_INITIALIZING: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073467391i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNER_REQUIRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073467390i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV01: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455103i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV02: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455102i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV03: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455101i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV04: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455100i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV05: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455099i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV06: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455098i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV07: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455097i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDV08: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073455096i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_TUNE_FAILED_SDVFF: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073454849i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_INVALID_CERTIFICATE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418238i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_INVALID_DATE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418235i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_INVALID_PROXIMITY: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418234i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_INVALID_SIGNATURE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418239i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_INVALID_VERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418236i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WMDRM_KEY_ID_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073418232i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_E_WOULD_DISRUPT_STREAMING: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073463293i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Frequency = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FREQUENCY_NOT_SET: BDA_Frequency = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FREQUENCY_NOT_DEFINED: BDA_Frequency = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Frequency_Multiplier = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FREQUENCY_MULTIPLIER_NOT_SET: BDA_Frequency_Multiplier = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED: BDA_Frequency_Multiplier = 0i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_GDDS_DATA {
    pub lResult: i32,
    pub ulDataLength: u32,
    pub ulPercentageProgress: u32,
    pub argbData: [u8; 1],
}
impl ::core::marker::Copy for BDA_GDDS_DATA {}
impl ::core::clone::Clone for BDA_GDDS_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_GDDS_DATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_GDDS_DATA").field("lResult", &self.lResult).field("ulDataLength", &self.ulDataLength).field("ulPercentageProgress", &self.ulPercentageProgress).field("argbData", &self.argbData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_GDDS_DATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_GDDS_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_GDDS_DATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_GDDS_DATA {}
impl ::core::default::Default for BDA_GDDS_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_GDDS_DATATYPE {
    pub lResult: i32,
    pub uuidDataType: ::windows::core::GUID,
}
impl ::core::marker::Copy for BDA_GDDS_DATATYPE {}
impl ::core::clone::Clone for BDA_GDDS_DATATYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_GDDS_DATATYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_GDDS_DATATYPE").field("lResult", &self.lResult).field("uuidDataType", &self.uuidDataType).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_GDDS_DATATYPE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_GDDS_DATATYPE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_GDDS_DATATYPE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_GDDS_DATATYPE {}
impl ::core::default::Default for BDA_GDDS_DATATYPE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_IPv4_ADDRESS {
    pub rgbAddress: [u8; 4],
}
impl ::core::marker::Copy for BDA_IPv4_ADDRESS {}
impl ::core::clone::Clone for BDA_IPv4_ADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_IPv4_ADDRESS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_IPv4_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_IPv4_ADDRESS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_IPv4_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_IPv4_ADDRESS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_IPv4_ADDRESS {}
impl ::core::default::Default for BDA_IPv4_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_IPv4_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv4_ADDRESS; 1],
}
impl ::core::marker::Copy for BDA_IPv4_ADDRESS_LIST {}
impl ::core::clone::Clone for BDA_IPv4_ADDRESS_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_IPv4_ADDRESS_LIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_IPv4_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_IPv4_ADDRESS_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_IPv4_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_IPv4_ADDRESS_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_IPv4_ADDRESS_LIST {}
impl ::core::default::Default for BDA_IPv4_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_IPv6_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl ::core::marker::Copy for BDA_IPv6_ADDRESS {}
impl ::core::clone::Clone for BDA_IPv6_ADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_IPv6_ADDRESS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_IPv6_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_IPv6_ADDRESS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_IPv6_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_IPv6_ADDRESS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_IPv6_ADDRESS {}
impl ::core::default::Default for BDA_IPv6_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_IPv6_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv6_ADDRESS; 1],
}
impl ::core::marker::Copy for BDA_IPv6_ADDRESS_LIST {}
impl ::core::clone::Clone for BDA_IPv6_ADDRESS_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_IPv6_ADDRESS_LIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_IPv6_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_IPv6_ADDRESS_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_IPv6_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_IPv6_ADDRESS_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_IPv6_ADDRESS_LIST {}
impl ::core::default::Default for BDA_IPv6_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_ISDBCAS_EMG_REQ {
    pub bCLA: u8,
    pub bINS: u8,
    pub bP1: u8,
    pub bP2: u8,
    pub bLC: u8,
    pub bCardId: [u8; 6],
    pub bProtocol: u8,
    pub bCABroadcasterGroupId: u8,
    pub bMessageControl: u8,
    pub bMessageCode: [u8; 1],
}
impl ::core::marker::Copy for BDA_ISDBCAS_EMG_REQ {}
impl ::core::clone::Clone for BDA_ISDBCAS_EMG_REQ {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_ISDBCAS_EMG_REQ {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_ISDBCAS_EMG_REQ").field("bCLA", &self.bCLA).field("bINS", &self.bINS).field("bP1", &self.bP1).field("bP2", &self.bP2).field("bLC", &self.bLC).field("bCardId", &self.bCardId).field("bProtocol", &self.bProtocol).field("bCABroadcasterGroupId", &self.bCABroadcasterGroupId).field("bMessageControl", &self.bMessageControl).field("bMessageCode", &self.bMessageCode).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_ISDBCAS_EMG_REQ {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_ISDBCAS_EMG_REQ {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_ISDBCAS_EMG_REQ>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_ISDBCAS_EMG_REQ {}
impl ::core::default::Default for BDA_ISDBCAS_EMG_REQ {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_ISDBCAS_REQUESTHEADER {
    pub bInstruction: u8,
    pub bReserved: [u8; 3],
    pub ulDataLength: u32,
    pub argbIsdbCommand: [u8; 1],
}
impl ::core::marker::Copy for BDA_ISDBCAS_REQUESTHEADER {}
impl ::core::clone::Clone for BDA_ISDBCAS_REQUESTHEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for BDA_ISDBCAS_REQUESTHEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_ISDBCAS_REQUESTHEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_ISDBCAS_REQUESTHEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_ISDBCAS_REQUESTHEADER {}
impl ::core::default::Default for BDA_ISDBCAS_REQUESTHEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_ISDBCAS_RESPONSEDATA {
    pub lResult: i32,
    pub ulRequestID: u32,
    pub ulIsdbStatus: u32,
    pub ulIsdbDataSize: u32,
    pub argbIsdbCommandData: [u8; 1],
}
impl ::core::marker::Copy for BDA_ISDBCAS_RESPONSEDATA {}
impl ::core::clone::Clone for BDA_ISDBCAS_RESPONSEDATA {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for BDA_ISDBCAS_RESPONSEDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_ISDBCAS_RESPONSEDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_ISDBCAS_RESPONSEDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_ISDBCAS_RESPONSEDATA {}
impl ::core::default::Default for BDA_ISDBCAS_RESPONSEDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_LockType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_LockType_None: BDA_LockType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_LockType_PLL: BDA_LockType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_LockType_DecoderDemod: BDA_LockType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_LockType_Complete: BDA_LockType = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_MULTICAST_MODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_PROMISCUOUS_MULTICAST: BDA_MULTICAST_MODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FILTERED_MULTICAST: BDA_MULTICAST_MODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_NO_MULTICAST: BDA_MULTICAST_MODE = 2i32;
#[repr(C, packed(2))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_MUX_PIDLISTITEM {
    pub usPIDNumber: u16,
    pub usProgramNumber: u16,
    pub ePIDType: MUX_PID_TYPE,
}
impl ::core::marker::Copy for BDA_MUX_PIDLISTITEM {}
impl ::core::clone::Clone for BDA_MUX_PIDLISTITEM {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for BDA_MUX_PIDLISTITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_MUX_PIDLISTITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_MUX_PIDLISTITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_MUX_PIDLISTITEM {}
impl ::core::default::Default for BDA_MUX_PIDLISTITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_PID_MAP {
    pub MediaSampleContent: MEDIA_SAMPLE_CONTENT,
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl ::core::marker::Copy for BDA_PID_MAP {}
impl ::core::clone::Clone for BDA_PID_MAP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_PID_MAP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_PID_MAP").field("MediaSampleContent", &self.MediaSampleContent).field("ulcPIDs", &self.ulcPIDs).field("aulPIDs", &self.aulPIDs).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_PID_MAP {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_PID_MAP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_PID_MAP>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_PID_MAP {}
impl ::core::default::Default for BDA_PID_MAP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_PID_UNMAP {
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl ::core::marker::Copy for BDA_PID_UNMAP {}
impl ::core::clone::Clone for BDA_PID_UNMAP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_PID_UNMAP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_PID_UNMAP").field("ulcPIDs", &self.ulcPIDs).field("aulPIDs", &self.aulPIDs).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_PID_UNMAP {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_PID_UNMAP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_PID_UNMAP>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_PID_UNMAP {}
impl ::core::default::Default for BDA_PID_UNMAP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_PLP_ID_NOT_SET: i32 = -1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_PROGRAM_PID_LIST {
    pub ulProgramNumber: u32,
    pub ulcPIDs: u32,
    pub ulPID: [u32; 1],
}
impl ::core::marker::Copy for BDA_PROGRAM_PID_LIST {}
impl ::core::clone::Clone for BDA_PROGRAM_PID_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_PROGRAM_PID_LIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_PROGRAM_PID_LIST").field("ulProgramNumber", &self.ulProgramNumber).field("ulcPIDs", &self.ulcPIDs).field("ulPID", &self.ulPID).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_PROGRAM_PID_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_PROGRAM_PID_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_PROGRAM_PID_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_PROGRAM_PID_LIST {}
impl ::core::default::Default for BDA_PROGRAM_PID_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_RATING_PINRESET {
    pub bPinLength: u8,
    pub argbNewPin: [u8; 1],
}
impl ::core::marker::Copy for BDA_RATING_PINRESET {}
impl ::core::clone::Clone for BDA_RATING_PINRESET {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_RATING_PINRESET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_RATING_PINRESET").field("bPinLength", &self.bPinLength).field("argbNewPin", &self.argbNewPin).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_RATING_PINRESET {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_RATING_PINRESET {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_RATING_PINRESET>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_RATING_PINRESET {}
impl ::core::default::Default for BDA_RATING_PINRESET {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_Range = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_RANGE_NOT_SET: BDA_Range = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_RANGE_NOT_DEFINED: BDA_Range = 0i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_SCAN_CAPABILTIES {
    pub lResult: i32,
    pub ul64AnalogStandardsSupported: u64,
}
impl ::core::marker::Copy for BDA_SCAN_CAPABILTIES {}
impl ::core::clone::Clone for BDA_SCAN_CAPABILTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_SCAN_CAPABILTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_SCAN_CAPABILTIES").field("lResult", &self.lResult).field("ul64AnalogStandardsSupported", &self.ul64AnalogStandardsSupported).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_SCAN_CAPABILTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_SCAN_CAPABILTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_SCAN_CAPABILTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_SCAN_CAPABILTIES {}
impl ::core::default::Default for BDA_SCAN_CAPABILTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_SCAN_START {
    pub lResult: i32,
    pub LowerFrequency: u32,
    pub HigerFrequency: u32,
}
impl ::core::marker::Copy for BDA_SCAN_START {}
impl ::core::clone::Clone for BDA_SCAN_START {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_SCAN_START {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_SCAN_START").field("lResult", &self.lResult).field("LowerFrequency", &self.LowerFrequency).field("HigerFrequency", &self.HigerFrequency).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_SCAN_START {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_SCAN_START {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_SCAN_START>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_SCAN_START {}
impl ::core::default::Default for BDA_SCAN_START {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_SCAN_STATE {
    pub lResult: i32,
    pub ulSignalLock: u32,
    pub ulSecondsLeft: u32,
    pub ulCurrentFrequency: u32,
}
impl ::core::marker::Copy for BDA_SCAN_STATE {}
impl ::core::clone::Clone for BDA_SCAN_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_SCAN_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_SCAN_STATE").field("lResult", &self.lResult).field("ulSignalLock", &self.ulSignalLock).field("ulSecondsLeft", &self.ulSecondsLeft).field("ulCurrentFrequency", &self.ulCurrentFrequency).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_SCAN_STATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_SCAN_STATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_SCAN_STATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_SCAN_STATE {}
impl ::core::default::Default for BDA_SCAN_STATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_SIGNAL_STATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_SIGNAL_UNAVAILABLE: BDA_SIGNAL_STATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_SIGNAL_INACTIVE: BDA_SIGNAL_STATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_SIGNAL_ACTIVE: BDA_SIGNAL_STATE = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_SIGNAL_TIMEOUTS {
    pub ulCarrierTimeoutMs: u32,
    pub ulScanningTimeoutMs: u32,
    pub ulTuningTimeoutMs: u32,
}
impl ::core::marker::Copy for BDA_SIGNAL_TIMEOUTS {}
impl ::core::clone::Clone for BDA_SIGNAL_TIMEOUTS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_SIGNAL_TIMEOUTS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_SIGNAL_TIMEOUTS").field("ulCarrierTimeoutMs", &self.ulCarrierTimeoutMs).field("ulScanningTimeoutMs", &self.ulScanningTimeoutMs).field("ulTuningTimeoutMs", &self.ulTuningTimeoutMs).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_SIGNAL_TIMEOUTS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_SIGNAL_TIMEOUTS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_SIGNAL_TIMEOUTS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_SIGNAL_TIMEOUTS {}
impl ::core::default::Default for BDA_SIGNAL_TIMEOUTS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_STRING {
    pub lResult: i32,
    pub ulStringSize: u32,
    pub argbString: [u8; 1],
}
impl ::core::marker::Copy for BDA_STRING {}
impl ::core::clone::Clone for BDA_STRING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_STRING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_STRING").field("lResult", &self.lResult).field("ulStringSize", &self.ulStringSize).field("argbString", &self.argbString).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_STRING {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_STRING {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_STRING>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_STRING {}
impl ::core::default::Default for BDA_STRING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BDA_SignalType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_SignalType_Unknown: BDA_SignalType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_SignalType_Analog: BDA_SignalType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Bda_SignalType_Digital: BDA_SignalType = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TABLE_SECTION {
    pub ulPrimarySectionId: u32,
    pub ulSecondarySectionId: u32,
    pub ulcbSectionLength: u32,
    pub argbSectionData: [u32; 1],
}
impl ::core::marker::Copy for BDA_TABLE_SECTION {}
impl ::core::clone::Clone for BDA_TABLE_SECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TABLE_SECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TABLE_SECTION").field("ulPrimarySectionId", &self.ulPrimarySectionId).field("ulSecondarySectionId", &self.ulSecondarySectionId).field("ulcbSectionLength", &self.ulcbSectionLength).field("argbSectionData", &self.argbSectionData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TABLE_SECTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TABLE_SECTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TABLE_SECTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TABLE_SECTION {}
impl ::core::default::Default for BDA_TABLE_SECTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TEMPLATE_CONNECTION {
    pub FromNodeType: u32,
    pub FromNodePinType: u32,
    pub ToNodeType: u32,
    pub ToNodePinType: u32,
}
impl ::core::marker::Copy for BDA_TEMPLATE_CONNECTION {}
impl ::core::clone::Clone for BDA_TEMPLATE_CONNECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TEMPLATE_CONNECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TEMPLATE_CONNECTION").field("FromNodeType", &self.FromNodeType).field("FromNodePinType", &self.FromNodePinType).field("ToNodeType", &self.ToNodeType).field("ToNodePinType", &self.ToNodePinType).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TEMPLATE_CONNECTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TEMPLATE_CONNECTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TEMPLATE_CONNECTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TEMPLATE_CONNECTION {}
impl ::core::default::Default for BDA_TEMPLATE_CONNECTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TEMPLATE_PIN_JOINT {
    pub uliTemplateConnection: u32,
    pub ulcInstancesMax: u32,
}
impl ::core::marker::Copy for BDA_TEMPLATE_PIN_JOINT {}
impl ::core::clone::Clone for BDA_TEMPLATE_PIN_JOINT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TEMPLATE_PIN_JOINT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TEMPLATE_PIN_JOINT").field("uliTemplateConnection", &self.uliTemplateConnection).field("ulcInstancesMax", &self.ulcInstancesMax).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TEMPLATE_PIN_JOINT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TEMPLATE_PIN_JOINT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TEMPLATE_PIN_JOINT>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TEMPLATE_PIN_JOINT {}
impl ::core::default::Default for BDA_TEMPLATE_PIN_JOINT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TRANSPORT_INFO {
    pub ulcbPhyiscalPacket: u32,
    pub ulcbPhyiscalFrame: u32,
    pub ulcbPhyiscalFrameAlignment: u32,
    pub AvgTimePerFrame: i64,
}
impl ::core::marker::Copy for BDA_TRANSPORT_INFO {}
impl ::core::clone::Clone for BDA_TRANSPORT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TRANSPORT_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TRANSPORT_INFO").field("ulcbPhyiscalPacket", &self.ulcbPhyiscalPacket).field("ulcbPhyiscalFrame", &self.ulcbPhyiscalFrame).field("ulcbPhyiscalFrameAlignment", &self.ulcbPhyiscalFrameAlignment).field("AvgTimePerFrame", &self.AvgTimePerFrame).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TRANSPORT_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TRANSPORT_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TRANSPORT_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TRANSPORT_INFO {}
impl ::core::default::Default for BDA_TRANSPORT_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TS_SELECTORINFO {
    pub bTSInfolength: u8,
    pub bReserved: [u8; 2],
    pub guidNetworkType: ::windows::core::GUID,
    pub bTSIDCount: u8,
    pub usTSID: [u16; 1],
}
impl ::core::marker::Copy for BDA_TS_SELECTORINFO {}
impl ::core::clone::Clone for BDA_TS_SELECTORINFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for BDA_TS_SELECTORINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TS_SELECTORINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TS_SELECTORINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TS_SELECTORINFO {}
impl ::core::default::Default for BDA_TS_SELECTORINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TS_SELECTORINFO_ISDBS_EXT {
    pub bTMCC: [u8; 48],
}
impl ::core::marker::Copy for BDA_TS_SELECTORINFO_ISDBS_EXT {}
impl ::core::clone::Clone for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TS_SELECTORINFO_ISDBS_EXT").field("bTMCC", &self.bTMCC).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TS_SELECTORINFO_ISDBS_EXT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TS_SELECTORINFO_ISDBS_EXT>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TS_SELECTORINFO_ISDBS_EXT {}
impl ::core::default::Default for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TUNER_DIAGNOSTICS {
    pub lResult: i32,
    pub ulSignalLevel: u32,
    pub ulSignalLevelQuality: u32,
    pub ulSignalNoiseRatio: u32,
}
impl ::core::marker::Copy for BDA_TUNER_DIAGNOSTICS {}
impl ::core::clone::Clone for BDA_TUNER_DIAGNOSTICS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TUNER_DIAGNOSTICS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TUNER_DIAGNOSTICS").field("lResult", &self.lResult).field("ulSignalLevel", &self.ulSignalLevel).field("ulSignalLevelQuality", &self.ulSignalLevelQuality).field("ulSignalNoiseRatio", &self.ulSignalNoiseRatio).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TUNER_DIAGNOSTICS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TUNER_DIAGNOSTICS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TUNER_DIAGNOSTICS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TUNER_DIAGNOSTICS {}
impl ::core::default::Default for BDA_TUNER_DIAGNOSTICS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_TUNER_TUNERSTATE {
    pub lResult: i32,
    pub ulTuneLength: u32,
    pub argbTuneData: [u8; 1],
}
impl ::core::marker::Copy for BDA_TUNER_TUNERSTATE {}
impl ::core::clone::Clone for BDA_TUNER_TUNERSTATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_TUNER_TUNERSTATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_TUNER_TUNERSTATE").field("lResult", &self.lResult).field("ulTuneLength", &self.ulTuneLength).field("argbTuneData", &self.argbTuneData).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_TUNER_TUNERSTATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_TUNER_TUNERSTATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_TUNER_TUNERSTATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_TUNER_TUNERSTATE {}
impl ::core::default::Default for BDA_TUNER_TUNERSTATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_USERACTIVITY_INTERVAL {
    pub lResult: i32,
    pub ulActivityInterval: u32,
}
impl ::core::marker::Copy for BDA_USERACTIVITY_INTERVAL {}
impl ::core::clone::Clone for BDA_USERACTIVITY_INTERVAL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_USERACTIVITY_INTERVAL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_USERACTIVITY_INTERVAL").field("lResult", &self.lResult).field("ulActivityInterval", &self.ulActivityInterval).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_USERACTIVITY_INTERVAL {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_USERACTIVITY_INTERVAL {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_USERACTIVITY_INTERVAL>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_USERACTIVITY_INTERVAL {}
impl ::core::default::Default for BDA_USERACTIVITY_INTERVAL {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_WMDRMTUNER_PIDPROTECTION {
    pub lResult: i32,
    pub uuidKeyID: ::windows::core::GUID,
}
impl ::core::marker::Copy for BDA_WMDRMTUNER_PIDPROTECTION {}
impl ::core::clone::Clone for BDA_WMDRMTUNER_PIDPROTECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_WMDRMTUNER_PIDPROTECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_WMDRMTUNER_PIDPROTECTION").field("lResult", &self.lResult).field("uuidKeyID", &self.uuidKeyID).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_WMDRMTUNER_PIDPROTECTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_WMDRMTUNER_PIDPROTECTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_WMDRMTUNER_PIDPROTECTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_WMDRMTUNER_PIDPROTECTION {}
impl ::core::default::Default for BDA_WMDRMTUNER_PIDPROTECTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulCaptureTokenLength: u32,
    pub argbCaptureTokenBuffer: [u8; 1],
}
impl ::core::marker::Copy for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {}
impl ::core::clone::Clone for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_WMDRMTUNER_PURCHASEENTITLEMENT").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).field("ulCaptureTokenLength", &self.ulCaptureTokenLength).field("argbCaptureTokenBuffer", &self.argbCaptureTokenBuffer).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_WMDRMTUNER_PURCHASEENTITLEMENT>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {}
impl ::core::default::Default for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_WMDRM_KEYINFOLIST {
    pub lResult: i32,
    pub ulKeyuuidBufferLen: u32,
    pub argKeyuuidBuffer: [::windows::core::GUID; 1],
}
impl ::core::marker::Copy for BDA_WMDRM_KEYINFOLIST {}
impl ::core::clone::Clone for BDA_WMDRM_KEYINFOLIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_WMDRM_KEYINFOLIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_WMDRM_KEYINFOLIST").field("lResult", &self.lResult).field("ulKeyuuidBufferLen", &self.ulKeyuuidBufferLen).field("argKeyuuidBuffer", &self.argKeyuuidBuffer).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_WMDRM_KEYINFOLIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_WMDRM_KEYINFOLIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_WMDRM_KEYINFOLIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_WMDRM_KEYINFOLIST {}
impl ::core::default::Default for BDA_WMDRM_KEYINFOLIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_WMDRM_RENEWLICENSE {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulXmrLicenseOutputLength: u32,
    pub argbXmrLicenceOutputBuffer: [u8; 1],
}
impl ::core::marker::Copy for BDA_WMDRM_RENEWLICENSE {}
impl ::core::clone::Clone for BDA_WMDRM_RENEWLICENSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_WMDRM_RENEWLICENSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_WMDRM_RENEWLICENSE").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).field("ulXmrLicenseOutputLength", &self.ulXmrLicenseOutputLength).field("argbXmrLicenceOutputBuffer", &self.argbXmrLicenceOutputBuffer).finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_WMDRM_RENEWLICENSE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_WMDRM_RENEWLICENSE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_WMDRM_RENEWLICENSE>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_WMDRM_RENEWLICENSE {}
impl ::core::default::Default for BDA_WMDRM_RENEWLICENSE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BDA_WMDRM_STATUS {
    pub lResult: i32,
    pub ulMaxCaptureTokenSize: u32,
    pub uMaxStreamingPid: u32,
    pub ulMaxLicense: u32,
    pub ulMinSecurityLevel: u32,
    pub ulRevInfoSequenceNumber: u32,
    pub ulRevInfoIssuedTime: u64,
    pub ulRevListVersion: u32,
    pub ulRevInfoTTL: u32,
    pub ulState: u32,
}
impl ::core::marker::Copy for BDA_WMDRM_STATUS {}
impl ::core::clone::Clone for BDA_WMDRM_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BDA_WMDRM_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BDA_WMDRM_STATUS")
            .field("lResult", &self.lResult)
            .field("ulMaxCaptureTokenSize", &self.ulMaxCaptureTokenSize)
            .field("uMaxStreamingPid", &self.uMaxStreamingPid)
            .field("ulMaxLicense", &self.ulMaxLicense)
            .field("ulMinSecurityLevel", &self.ulMinSecurityLevel)
            .field("ulRevInfoSequenceNumber", &self.ulRevInfoSequenceNumber)
            .field("ulRevInfoIssuedTime", &self.ulRevInfoIssuedTime)
            .field("ulRevListVersion", &self.ulRevListVersion)
            .field("ulRevInfoTTL", &self.ulRevInfoTTL)
            .field("ulState", &self.ulState)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for BDA_WMDRM_STATUS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BDA_WMDRM_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BDA_WMDRM_STATUS>()) == 0 }
    }
}
impl ::core::cmp::Eq for BDA_WMDRM_STATUS {}
impl ::core::default::Default for BDA_WMDRM_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const BSKYB_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e9e46c6_3aba_4f08_ad0e_cc5ac8148c2b);
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct BadSampleInfo {
    pub hrReason: ::windows::core::HRESULT,
}
impl ::core::marker::Copy for BadSampleInfo {}
impl ::core::clone::Clone for BadSampleInfo {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for BadSampleInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BadSampleInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BadSampleInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for BadSampleInfo {}
impl ::core::default::Default for BadSampleInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BfEnTvRat_Attributes_CAE_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_IsBlocked: BfEnTvRat_Attributes_CAE_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_ValidAttrSubmask: BfEnTvRat_Attributes_CAE_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BfEnTvRat_Attributes_CAF_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_IsBlocked: BfEnTvRat_Attributes_CAF_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_ValidAttrSubmask: BfEnTvRat_Attributes_CAF_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BfEnTvRat_Attributes_MPAA = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_IsBlocked: BfEnTvRat_Attributes_MPAA = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_ValidAttrSubmask: BfEnTvRat_Attributes_MPAA = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BfEnTvRat_Attributes_US_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_IsBlocked: BfEnTvRat_Attributes_US_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_IsViolent: BfEnTvRat_Attributes_US_TV = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_IsSexualSituation: BfEnTvRat_Attributes_US_TV = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_IsAdultLanguage: BfEnTvRat_Attributes_US_TV = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_IsSexuallySuggestiveDialog: BfEnTvRat_Attributes_US_TV = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_ValidAttrSubmask: BfEnTvRat_Attributes_US_TV = 31i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BfEnTvRat_GenericAttributes = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfAttrNone: BfEnTvRat_GenericAttributes = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsBlocked: BfEnTvRat_GenericAttributes = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_1: BfEnTvRat_GenericAttributes = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_2: BfEnTvRat_GenericAttributes = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_3: BfEnTvRat_GenericAttributes = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_4: BfEnTvRat_GenericAttributes = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_5: BfEnTvRat_GenericAttributes = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_6: BfEnTvRat_GenericAttributes = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfIsAttr_7: BfEnTvRat_GenericAttributes = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BfValidAttrSubmask: BfEnTvRat_GenericAttributes = 255i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type BinaryConvolutionCodeRate = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_NOT_SET: BinaryConvolutionCodeRate = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_NOT_DEFINED: BinaryConvolutionCodeRate = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_1_2: BinaryConvolutionCodeRate = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_2_3: BinaryConvolutionCodeRate = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_3_4: BinaryConvolutionCodeRate = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_3_5: BinaryConvolutionCodeRate = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_4_5: BinaryConvolutionCodeRate = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_5_6: BinaryConvolutionCodeRate = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_5_11: BinaryConvolutionCodeRate = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_7_8: BinaryConvolutionCodeRate = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_1_4: BinaryConvolutionCodeRate = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_1_3: BinaryConvolutionCodeRate = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_2_5: BinaryConvolutionCodeRate = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_6_7: BinaryConvolutionCodeRate = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_8_9: BinaryConvolutionCodeRate = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_9_10: BinaryConvolutionCodeRate = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_BCC_RATE_MAX: BinaryConvolutionCodeRate = 15i32;
pub const BroadcastEventService: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b3ffb92_0919_4934_9d5b_619c719d0202);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct CAPTURE_STREAMTIME {
    pub StreamTime: i64,
}
impl ::core::marker::Copy for CAPTURE_STREAMTIME {}
impl ::core::clone::Clone for CAPTURE_STREAMTIME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CAPTURE_STREAMTIME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CAPTURE_STREAMTIME").field("StreamTime", &self.StreamTime).finish()
    }
}
unsafe impl ::windows::core::Abi for CAPTURE_STREAMTIME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CAPTURE_STREAMTIME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CAPTURE_STREAMTIME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CAPTURE_STREAMTIME {}
impl ::core::default::Default for CAPTURE_STREAMTIME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_BYPASS_CLASS_MANAGER: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_CLASS_DEFAULT: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_DEVMON_CMGR_DEVICE: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_DEVMON_DMO: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_DEVMON_FILTER: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_DEVMON_PNP_DEVICE: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_DEVMON_SELECTIVE_MASK: u32 = 240u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CDEF_MERIT_ABOVE_DO_NOT_USE: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CHARS_IN_GUID: u32 = 39u32;
pub const CLSID_AMAudioData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2468580_af8a_11d0_8212_00c04fc32c45);
pub const CLSID_AMAudioStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8496e040_af4c_11d0_8212_00c04fc32c45);
pub const CLSID_AMDirectDrawStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49c47ce4_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_AMMediaTypeStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcf0f2f7c_f7bf_11d0_900d_00c04fd9189d);
pub const CLSID_AMMultiMediaStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49c47ce5_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_CPCAFiltersCategory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4fc_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_DMOFilterCategory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcd5796c_bd52_4d30_ab76_70f975b89199);
pub const CLSID_DMOWrapperFilter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94297043_bd82_4dfd_b0de_8177739c6d20);
pub const CLSID_DTFilterEncProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c482_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_DTFilterTagProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c492_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_ETFilterEncProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c481_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_ETFilterTagProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c491_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_Mpeg2TableFilter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x752845f1_758f_4c83_a043_4270c593308e);
pub const CLSID_PBDA_AUX_DATA_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd456373_3323_4090_adca_8ed45f55cf10);
pub const CLSID_PBDA_Encoder_DATA_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728fd6bc_5546_4716_b103_f899f5a1fa68);
pub const CLSID_PBDA_FDC_DATA_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe7dbf9a0_22ab_4047_8e67_ef9ad504e729);
pub const CLSID_PBDA_GDDS_DATA_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc80c0df3_6052_4c16_9f56_c44c21f73c45);
pub const CLSID_PTFilter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9cd31617_b303_4f96_8330_2eb173ea4dc6);
pub const CLSID_XDSCodecProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c483_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_XDSCodecTagProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c493_0049_4e2b_98fb_9537f6ce516d);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct COLORKEY {
    pub KeyType: u32,
    pub PaletteIndex: u32,
    pub LowColorValue: u32,
    pub HighColorValue: u32,
}
impl ::core::marker::Copy for COLORKEY {}
impl ::core::clone::Clone for COLORKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for COLORKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("COLORKEY").field("KeyType", &self.KeyType).field("PaletteIndex", &self.PaletteIndex).field("LowColorValue", &self.LowColorValue).field("HighColorValue", &self.HighColorValue).finish()
    }
}
unsafe impl ::windows::core::Abi for COLORKEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for COLORKEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<COLORKEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for COLORKEY {}
impl ::core::default::Default for COLORKEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COLORKEY_TYPE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CK_NOCOLORKEY: COLORKEY_TYPE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CK_INDEX: COLORKEY_TYPE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CK_RGB: COLORKEY_TYPE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COMPLETION_STATUS_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPSTAT_NOUPDATEOK: COMPLETION_STATUS_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPSTAT_WAIT: COMPLETION_STATUS_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPSTAT_ABORT: COMPLETION_STATUS_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPONENT_TAG_CAPTION_MAX: u32 = 55u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPONENT_TAG_CAPTION_MIN: u32 = 48u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPONENT_TAG_SUPERIMPOSE_MAX: u32 = 63u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COMPONENT_TAG_SUPERIMPOSE_MIN: u32 = 56u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPPEventBlockReason = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_Unknown: COPPEventBlockReason = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BadDriver: COPPEventBlockReason = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_NoCardHDCPSupport: COPPEventBlockReason = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_NoMonitorHDCPSupport: COPPEventBlockReason = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BadCertificate: COPPEventBlockReason = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_InvalidBusProtection: COPPEventBlockReason = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AeroGlassOff: COPPEventBlockReason = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_RogueApp: COPPEventBlockReason = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ForbiddenVideo: COPPEventBlockReason = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_Activate: COPPEventBlockReason = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_DigitalAudioUnprotected: COPPEventBlockReason = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_ACP_Protection_Level = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_Level0: COPP_ACP_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_LevelMin: COPP_ACP_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_Level1: COPP_ACP_Protection_Level = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_Level2: COPP_ACP_Protection_Level = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_Level3: COPP_ACP_Protection_Level = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_LevelMax: COPP_ACP_Protection_Level = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ACP_ForceDWORD: COPP_ACP_Protection_Level = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_BusType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_Unknown: COPP_BusType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_PCI: COPP_BusType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_PCIX: COPP_BusType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_PCIExpress: COPP_BusType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_AGP: COPP_BusType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_Integrated: COPP_BusType = -2147483648i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_BusType_ForceDWORD: COPP_BusType = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_CGMSA_Protection_Level = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_Disabled: COPP_CGMSA_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_LevelMin: COPP_CGMSA_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_CopyFreely: COPP_CGMSA_Protection_Level = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_CopyNoMore: COPP_CGMSA_Protection_Level = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_CopyOneGeneration: COPP_CGMSA_Protection_Level = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_CopyNever: COPP_CGMSA_Protection_Level = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_RedistributionControlRequired: COPP_CGMSA_Protection_Level = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_LevelMax: COPP_CGMSA_Protection_Level = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_CGMSA_ForceDWORD: COPP_CGMSA_Protection_Level = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_ConnectorType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_Unknown: COPP_ConnectorType = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_VGA: COPP_ConnectorType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_SVideo: COPP_ConnectorType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_CompositeVideo: COPP_ConnectorType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_ComponentVideo: COPP_ConnectorType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_DVI: COPP_ConnectorType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_HDMI: COPP_ConnectorType = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_LVDS: COPP_ConnectorType = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_TMDS: COPP_ConnectorType = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_D_JPN: COPP_ConnectorType = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_Internal: COPP_ConnectorType = -2147483648i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ConnectorType_ForceDWORD: COPP_ConnectorType = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_DefaultProtectionLevel: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_HDCP_Protection_Level = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCP_Level0: COPP_HDCP_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCP_LevelMin: COPP_HDCP_Protection_Level = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCP_Level1: COPP_HDCP_Protection_Level = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCP_LevelMax: COPP_HDCP_Protection_Level = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCP_ForceDWORD: COPP_HDCP_Protection_Level = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_ImageAspectRatio_EN300294 = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_FullFormat4by3: COPP_ImageAspectRatio_EN300294 = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_Box14by9Center: COPP_ImageAspectRatio_EN300294 = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_Box14by9Top: COPP_ImageAspectRatio_EN300294 = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_Box16by9Center: COPP_ImageAspectRatio_EN300294 = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_Box16by9Top: COPP_ImageAspectRatio_EN300294 = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_BoxGT16by9Center: COPP_ImageAspectRatio_EN300294 = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter: COPP_ImageAspectRatio_EN300294 = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic: COPP_ImageAspectRatio_EN300294 = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_AspectRatio_ForceDWORD: COPP_ImageAspectRatio_EN300294 = 2147483647i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ImageAspectRatio_EN300294_Mask: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_NoProtectionLevelAvailable: i32 = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_StatusFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_StatusNormal: COPP_StatusFlags = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_LinkLost: COPP_StatusFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_RenegotiationRequired: COPP_StatusFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_StatusFlagsReserved: COPP_StatusFlags = -4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_StatusHDCPFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCPRepeater: COPP_StatusHDCPFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_HDCPFlagsReserved: COPP_StatusHDCPFlags = -2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type COPP_TVProtectionStandard = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_Unknown: COPP_TVProtectionStandard = -2147483648i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_None: COPP_TVProtectionStandard = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_IEC61880_525i: COPP_TVProtectionStandard = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_IEC61880_2_525i: COPP_TVProtectionStandard = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_IEC62375_625p: COPP_TVProtectionStandard = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_EIA608B_525: COPP_TVProtectionStandard = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_EN300294_625i: COPP_TVProtectionStandard = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeA_525p: COPP_TVProtectionStandard = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeA_750p: COPP_TVProtectionStandard = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeA_1125i: COPP_TVProtectionStandard = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeB_525p: COPP_TVProtectionStandard = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeB_750p: COPP_TVProtectionStandard = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_CEA805A_TypeB_1125i: COPP_TVProtectionStandard = 1024i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_ARIBTRB15_525i: COPP_TVProtectionStandard = 2048i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_ARIBTRB15_525p: COPP_TVProtectionStandard = 4096i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_ARIBTRB15_750p: COPP_TVProtectionStandard = 8192i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_ARIBTRB15_1125i: COPP_TVProtectionStandard = 16384i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_Mask: COPP_TVProtectionStandard = -2147450881i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const COPP_ProtectionStandard_Reserved: COPP_TVProtectionStandard = 2147450880i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CPEventBitShift = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_RATINGS: CPEventBitShift = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_COPP: CPEventBitShift = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_LICENSE: CPEventBitShift = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_ROLLBACK: CPEventBitShift = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_SAC: CPEventBitShift = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_DOWNRES: CPEventBitShift = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_STUBLIB: CPEventBitShift = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_UNTRUSTEDGRAPH: CPEventBitShift = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_PENDING_CERTIFICATE: CPEventBitShift = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_BITSHIFT_NO_PLAYREADY: CPEventBitShift = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CPEvents = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_NONE: CPEvents = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_RATINGS: CPEvents = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_COPP: CPEvents = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_LICENSE: CPEvents = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_ROLLBACK: CPEvents = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_SAC: CPEvents = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_DOWNRES: CPEvents = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_STUBLIB: CPEvents = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_UNTRUSTEDGRAPH: CPEvents = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CPEVENT_PROTECTWINDOWED: CPEvents = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CPRecordingStatus = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const RECORDING_STOPPED: CPRecordingStatus = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const RECORDING_STARTED: CPRecordingStatus = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CRID_LOCATION = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CRID_LOCATION_IN_DESCRIPTOR: CRID_LOCATION = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CRID_LOCATION_IN_CIT: CRID_LOCATION = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CRID_LOCATION_DVB_RESERVED1: CRID_LOCATION = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CRID_LOCATION_DVB_RESERVED2: CRID_LOCATION = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CROSSBAR_DEFAULT_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DEF_MODE_PROFILE: CROSSBAR_DEFAULT_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DEF_MODE_STREAMS: CROSSBAR_DEFAULT_FLAGS = 2i32;
pub const CXDSData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4f4_0049_4e2b_98fb_9537f6ce516d);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CameraControlFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Flags_Auto: CameraControlFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Flags_Manual: CameraControlFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CameraControlProperty = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Pan: CameraControlProperty = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Tilt: CameraControlProperty = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Roll: CameraControlProperty = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Zoom: CameraControlProperty = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Exposure: CameraControlProperty = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Iris: CameraControlProperty = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CameraControl_Focus: CameraControlProperty = 6i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelChangeInfo {
    pub state: ChannelChangeSpanningEvent_State,
    pub TimeStamp: u64,
}
impl ::core::marker::Copy for ChannelChangeInfo {}
impl ::core::clone::Clone for ChannelChangeInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ChannelChangeInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ChannelChangeInfo").field("state", &self.state).field("TimeStamp", &self.TimeStamp).finish()
    }
}
unsafe impl ::windows::core::Abi for ChannelChangeInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelChangeInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelChangeInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelChangeInfo {}
impl ::core::default::Default for ChannelChangeInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ChannelChangeSpanningEvent_State = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelChangeSpanningEvent_Start: ChannelChangeSpanningEvent_State = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelChangeSpanningEvent_End: ChannelChangeSpanningEvent_State = 2i32;
pub const ChannelIDTuneRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3a9428a7_31a4_45e9_9efb_e055bf7bb3db);
pub const ChannelIDTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcc829a2f_3365_463f_af13_81dbb6f3a555);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelInfo {
    pub lFrequency: i32,
    pub Anonymous: ChannelInfo_0,
}
impl ::core::marker::Copy for ChannelInfo {}
impl ::core::clone::Clone for ChannelInfo {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for ChannelInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelInfo {}
impl ::core::default::Default for ChannelInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub union ChannelInfo_0 {
    pub DVB: ChannelInfo_0_2,
    pub DC: ChannelInfo_0_1,
    pub ATSC: ChannelInfo_0_0,
}
impl ::core::marker::Copy for ChannelInfo_0 {}
impl ::core::clone::Clone for ChannelInfo_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for ChannelInfo_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelInfo_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelInfo_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelInfo_0 {}
impl ::core::default::Default for ChannelInfo_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelInfo_0_0 {
    pub lProgNumber: i32,
}
impl ::core::marker::Copy for ChannelInfo_0_0 {}
impl ::core::clone::Clone for ChannelInfo_0_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ChannelInfo_0_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ChannelInfo_0_0").field("lProgNumber", &self.lProgNumber).finish()
    }
}
unsafe impl ::windows::core::Abi for ChannelInfo_0_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelInfo_0_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelInfo_0_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelInfo_0_0 {}
impl ::core::default::Default for ChannelInfo_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelInfo_0_1 {
    pub lProgNumber: i32,
}
impl ::core::marker::Copy for ChannelInfo_0_1 {}
impl ::core::clone::Clone for ChannelInfo_0_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ChannelInfo_0_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ChannelInfo_0_1").field("lProgNumber", &self.lProgNumber).finish()
    }
}
unsafe impl ::windows::core::Abi for ChannelInfo_0_1 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelInfo_0_1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelInfo_0_1>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelInfo_0_1 {}
impl ::core::default::Default for ChannelInfo_0_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelInfo_0_2 {
    pub lONID: i32,
    pub lTSID: i32,
    pub lSID: i32,
}
impl ::core::marker::Copy for ChannelInfo_0_2 {}
impl ::core::clone::Clone for ChannelInfo_0_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ChannelInfo_0_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ChannelInfo_0_2").field("lONID", &self.lONID).field("lTSID", &self.lTSID).field("lSID", &self.lSID).finish()
    }
}
unsafe impl ::windows::core::Abi for ChannelInfo_0_2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelInfo_0_2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelInfo_0_2>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelInfo_0_2 {}
impl ::core::default::Default for ChannelInfo_0_2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const ChannelTuneRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0369b4e5_45b6_11d3_b650_00c04f79498e);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ChannelType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeNone: ChannelType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeOther: ChannelType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeVideo: ChannelType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeAudio: ChannelType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeText: ChannelType = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeSubtitles: ChannelType = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeCaptions: ChannelType = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeSuperimpose: ChannelType = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ChannelTypeData: ChannelType = 128i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct ChannelTypeInfo {
    pub channelType: ChannelType,
    pub timeStamp: u64,
}
impl ::core::marker::Copy for ChannelTypeInfo {}
impl ::core::clone::Clone for ChannelTypeInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ChannelTypeInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ChannelTypeInfo").field("channelType", &self.channelType).field("timeStamp", &self.timeStamp).finish()
    }
}
unsafe impl ::windows::core::Abi for ChannelTypeInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for ChannelTypeInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ChannelTypeInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for ChannelTypeInfo {}
impl ::core::default::Default for ChannelTypeInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const Component: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x59dc47a8_116c_11d3_9d8e_00c04f72d980);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ComponentCategory = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryNotSet: ComponentCategory = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryOther: ComponentCategory = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryVideo: ComponentCategory = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryAudio: ComponentCategory = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryText: ComponentCategory = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategorySubtitles: ComponentCategory = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryCaptions: ComponentCategory = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategorySuperimpose: ComponentCategory = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CategoryData: ComponentCategory = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CATEGORY_COUNT: ComponentCategory = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type ComponentStatus = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const StatusActive: ComponentStatus = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const StatusInactive: ComponentStatus = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const StatusUnavailable: ComponentStatus = 2i32;
pub const ComponentType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x823535a0_0318_11d3_9d8e_00c04f72d980);
pub const ComponentTypes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa1a2b1c4_0e3a_11d3_9d8e_00c04f72d980);
pub const Components: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x809b6661_94c4_49e6_b6ec_3f0f862215aa);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type CompressionCaps = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CompressionCaps_CanQuality: CompressionCaps = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CompressionCaps_CanCrunch: CompressionCaps = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CompressionCaps_CanKeyFrame: CompressionCaps = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CompressionCaps_CanBFrame: CompressionCaps = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CompressionCaps_CanWindow: CompressionCaps = 16i32;
pub const CreatePropBagOnRegKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8a674b49_1f63_11d3_b64c_00c04f79498e);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DDSFF_FLAGS = u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DDSFF_PROGRESSIVERENDER: DDSFF_FLAGS = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DECIMATION_USAGE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECIMATION_LEGACY: DECIMATION_USAGE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECIMATION_USE_DECODER_ONLY: DECIMATION_USAGE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECIMATION_USE_VIDEOPORT_ONLY: DECIMATION_USAGE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECIMATION_USE_OVERLAY_ONLY: DECIMATION_USAGE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECIMATION_DEFAULT: DECIMATION_USAGE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECODER_CAP_NOTSUPPORTED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DECODER_CAP_SUPPORTED: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DESC_LINKAGE_TYPE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_RESERVED0: DESC_LINKAGE_TYPE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_INFORMATION: DESC_LINKAGE_TYPE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_EPG: DESC_LINKAGE_TYPE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_CA_REPLACEMENT: DESC_LINKAGE_TYPE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_COMPLETE_NET_BOUQUET_SI: DESC_LINKAGE_TYPE = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_REPLACEMENT: DESC_LINKAGE_TYPE = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_DATA: DESC_LINKAGE_TYPE = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_RESERVED1: DESC_LINKAGE_TYPE = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_USER: DESC_LINKAGE_TYPE = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DESC_LINKAGE_RESERVED2: DESC_LINKAGE_TYPE = 255i32;
pub const DIGITAL_CABLE_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x143827ab_f77b_498d_81ca_5a007aec28bf);
pub const DIRECT_TV_SATELLITE_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x93b66fb5_93d4_4323_921c_c1f52df61d3f);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DISPID_TUNER = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_UNIQUENAME: DISPID_TUNER = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_FRIENDLYNAME: DISPID_TUNER = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_CLSID: DISPID_TUNER = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_NETWORKTYPE: DISPID_TUNER = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS__NETWORKTYPE: DISPID_TUNER = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_CREATETUNEREQUEST: DISPID_TUNER = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ENUMCATEGORYGUIDS: DISPID_TUNER = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ENUMDEVICEMONIKERS: DISPID_TUNER = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DEFAULTPREFERREDCOMPONENTTYPES: DISPID_TUNER = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_FREQMAP: DISPID_TUNER = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DEFLOCATOR: DISPID_TUNER = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_CLONE: DISPID_TUNER = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TR_TUNINGSPACE: DISPID_TUNER = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TR_COMPONENTS: DISPID_TUNER = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TR_CLONE: DISPID_TUNER = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TR_LOCATOR: DISPID_TUNER = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_CATEGORY: DISPID_TUNER = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_MEDIAMAJORTYPE: DISPID_TUNER = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT__MEDIAMAJORTYPE: DISPID_TUNER = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_MEDIASUBTYPE: DISPID_TUNER = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT__MEDIASUBTYPE: DISPID_TUNER = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_MEDIAFORMATTYPE: DISPID_TUNER = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT__MEDIAFORMATTYPE: DISPID_TUNER = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_MEDIATYPE: DISPID_TUNER = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_CT_CLONE: DISPID_TUNER = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_LCT_LANGID: DISPID_TUNER = 100i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_MP2CT_TYPE: DISPID_TUNER = 200i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_ATSCCT_FLAGS: DISPID_TUNER = 300i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_CARRFREQ: DISPID_TUNER = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_INNERFECMETHOD: DISPID_TUNER = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_INNERFECRATE: DISPID_TUNER = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_OUTERFECMETHOD: DISPID_TUNER = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_OUTERFECRATE: DISPID_TUNER = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_MOD: DISPID_TUNER = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_SYMRATE: DISPID_TUNER = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_CLONE: DISPID_TUNER = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_ATSC_PHYS_CHANNEL: DISPID_TUNER = 201i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_ATSC_TSID: DISPID_TUNER = 202i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_ATSC_MP2_PROGNO: DISPID_TUNER = 203i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_BANDWIDTH: DISPID_TUNER = 301i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_LPINNERFECMETHOD: DISPID_TUNER = 302i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_LPINNERFECRATE: DISPID_TUNER = 303i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_GUARDINTERVAL: DISPID_TUNER = 304i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_HALPHA: DISPID_TUNER = 305i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_TRANSMISSIONMODE: DISPID_TUNER = 306i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT_INUSE: DISPID_TUNER = 307i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBT2_PHYSICALLAYERPIPEID: DISPID_TUNER = 351i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS_POLARISATION: DISPID_TUNER = 401i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS_WEST: DISPID_TUNER = 402i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS_ORBITAL: DISPID_TUNER = 403i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS_AZIMUTH: DISPID_TUNER = 404i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS_ELEVATION: DISPID_TUNER = 405i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS2_DISEQ_LNB_SOURCE: DISPID_TUNER = 406i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS2_LOW_OSC_FREQ_OVERRIDE: DISPID_TUNER = 407i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS2_HI_OSC_FREQ_OVERRIDE: DISPID_TUNER = 408i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS2_LNB_SWITCH_FREQ_OVERRIDE: DISPID_TUNER = 409i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS2_SPECTRAL_INVERSION_OVERRIDE: DISPID_TUNER = 410i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS2_ROLLOFF: DISPID_TUNER = 411i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DVBS2_PILOT: DISPID_TUNER = 412i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_ANALOG_STANDARD: DISPID_TUNER = 601i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_L_DTV_O_MAJOR_CHANNEL: DISPID_TUNER = 701i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_TYPE: DISPID_TUNER = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_STATUS: DISPID_TUNER = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_LANGID: DISPID_TUNER = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_DESCRIPTION: DISPID_TUNER = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_CLONE: DISPID_TUNER = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_MP2_PID: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_MP2_PCRPID: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_MP2_PROGNO: DISPID_TUNER = 103i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_C_ANALOG_AUDIO: DISPID_TUNER = 201i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVB_SYSTEMTYPE: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVB2_NETWORK_ID: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS_LOW_OSC_FREQ: DISPID_TUNER = 1001i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS_HI_OSC_FREQ: DISPID_TUNER = 1002i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS_LNB_SWITCH_FREQ: DISPID_TUNER = 1003i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS_INPUT_RANGE: DISPID_TUNER = 1004i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DVBS_SPECTRAL_INVERSION: DISPID_TUNER = 1005i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_AR_MINFREQUENCY: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_AR_MAXFREQUENCY: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_AR_STEP: DISPID_TUNER = 103i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_AR_COUNTRYCODE: DISPID_TUNER = 104i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_AUX_COUNTRYCODE: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATV_MINCHANNEL: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATV_MAXCHANNEL: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATV_INPUTTYPE: DISPID_TUNER = 103i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATV_COUNTRYCODE: DISPID_TUNER = 104i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATSC_MINMINORCHANNEL: DISPID_TUNER = 201i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATSC_MAXMINORCHANNEL: DISPID_TUNER = 202i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATSC_MINPHYSCHANNEL: DISPID_TUNER = 203i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_ATSC_MAXPHYSCHANNEL: DISPID_TUNER = 204i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DC_MINMAJORCHANNEL: DISPID_TUNER = 301i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DC_MAXMAJORCHANNEL: DISPID_TUNER = 302i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DC_MINSOURCEID: DISPID_TUNER = 303i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_TUNER_TS_DC_MAXSOURCEID: DISPID_TUNER = 304i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_ATVAC_CHANNEL: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_ATVDC_SYSTEM: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_ATVDC_CONTENT: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_CIDTR_CHANNELID: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_CTR_CHANNEL: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_ACTR_MINOR_CHANNEL: DISPID_TUNER = 201i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_DCTR_MAJOR_CHANNEL: DISPID_TUNER = 301i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_CHTUNER_DCTR_SRCID: DISPID_TUNER = 302i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_DVBC_ATTRIBUTESVALID: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_DVBC_PID: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_DVBC_TAG: DISPID_TUNER = 103i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_DVBC_COMPONENTTYPE: DISPID_TUNER = 104i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_ONID: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_TSID: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_DVBTUNER_SID: DISPID_TUNER = 103i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_MP2TUNER_TSID: DISPID_TUNER = 101i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_MP2TUNER_PROGNO: DISPID_TUNER = 102i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPID_MP2TUNERFACTORY_CREATETUNEREQUEST: DISPID_TUNER = 1i32;
pub const DSATTRIB_BadSampleInfo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe4846dda_5838_42b4_b897_6f7e5faa2f2f);
pub const DSATTRIB_WMDRMProtectionInfo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40749583_6b9d_4eec_b43c_67a1801e1a9b);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DSHOW_STREAM_DESC {
    pub VersionNo: u32,
    pub StreamId: u32,
    pub Default: super::super::Foundation::BOOL,
    pub Creation: super::super::Foundation::BOOL,
    pub Reserved: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DSHOW_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DSHOW_STREAM_DESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DSHOW_STREAM_DESC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DSHOW_STREAM_DESC").field("VersionNo", &self.VersionNo).field("StreamId", &self.StreamId).field("Default", &self.Default).field("Creation", &self.Creation).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DSHOW_STREAM_DESC {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DSHOW_STREAM_DESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSHOW_STREAM_DESC>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DSHOW_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DSHOW_STREAM_DESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DSMCC_ELEMENT {
    pub pid: u16,
    pub bComponentTag: u8,
    pub dwCarouselId: u32,
    pub dwTransactionId: u32,
    pub pNext: *mut DSMCC_ELEMENT,
}
impl ::core::marker::Copy for DSMCC_ELEMENT {}
impl ::core::clone::Clone for DSMCC_ELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DSMCC_ELEMENT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DSMCC_ELEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSMCC_ELEMENT>()) == 0 }
    }
}
impl ::core::cmp::Eq for DSMCC_ELEMENT {}
impl ::core::default::Default for DSMCC_ELEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DSMCC_FILTER_OPTIONS {
    pub fSpecifyProtocol: super::super::Foundation::BOOL,
    pub Protocol: u8,
    pub fSpecifyType: super::super::Foundation::BOOL,
    pub Type: u8,
    pub fSpecifyMessageId: super::super::Foundation::BOOL,
    pub MessageId: u16,
    pub fSpecifyTransactionId: super::super::Foundation::BOOL,
    pub fUseTrxIdMessageIdMask: super::super::Foundation::BOOL,
    pub TransactionId: u32,
    pub fSpecifyModuleVersion: super::super::Foundation::BOOL,
    pub ModuleVersion: u8,
    pub fSpecifyBlockNumber: super::super::Foundation::BOOL,
    pub BlockNumber: u16,
    pub fGetModuleCall: super::super::Foundation::BOOL,
    pub NumberOfBlocksInModule: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DSMCC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DSMCC_FILTER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DSMCC_FILTER_OPTIONS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DSMCC_FILTER_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSMCC_FILTER_OPTIONS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DSMCC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DSMCC_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DSMCC_SECTION {
    pub TableId: u8,
    pub Header: DSMCC_SECTION_0,
    pub TableIdExtension: u16,
    pub Version: DSMCC_SECTION_1,
    pub SectionNumber: u8,
    pub LastSectionNumber: u8,
    pub ProtocolDiscriminator: u8,
    pub DsmccType: u8,
    pub MessageId: u16,
    pub TransactionId: u32,
    pub Reserved: u8,
    pub AdaptationLength: u8,
    pub MessageLength: u16,
    pub RemainingData: [u8; 1],
}
impl ::core::marker::Copy for DSMCC_SECTION {}
impl ::core::clone::Clone for DSMCC_SECTION {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DSMCC_SECTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DSMCC_SECTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSMCC_SECTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for DSMCC_SECTION {}
impl ::core::default::Default for DSMCC_SECTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub union DSMCC_SECTION_0 {
    pub S: MPEG_HEADER_BITS_MIDL,
    pub W: u16,
}
impl ::core::marker::Copy for DSMCC_SECTION_0 {}
impl ::core::clone::Clone for DSMCC_SECTION_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DSMCC_SECTION_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DSMCC_SECTION_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSMCC_SECTION_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for DSMCC_SECTION_0 {}
impl ::core::default::Default for DSMCC_SECTION_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub union DSMCC_SECTION_1 {
    pub S: MPEG_HEADER_VERSION_BITS_MIDL,
    pub B: u8,
}
impl ::core::marker::Copy for DSMCC_SECTION_1 {}
impl ::core::clone::Clone for DSMCC_SECTION_1 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DSMCC_SECTION_1 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DSMCC_SECTION_1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DSMCC_SECTION_1>()) == 0 }
    }
}
impl ::core::cmp::Eq for DSMCC_SECTION_1 {}
impl ::core::default::Default for DSMCC_SECTION_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DTFilter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4f2_0049_4e2b_98fb_9537f6ce516d);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_CardStatus_Error: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_CardStatus_FirmwareDownload: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_CardStatus_Inserted: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_CardStatus_Removed: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_Entitlement_CanDecrypt: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_Entitlement_NotEntitled: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_Entitlement_TechnicalFailure: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_MMIMessage_Close: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DTV_MMIMessage_Open: u32 = 0u32;
pub const DVBCLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc531d9fd_9685_4028_8b68_6e1232079f1e);
pub const DVBSLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1df7d126_4050_47f0_a7cf_4c4ca9241333);
pub const DVBSTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb64016f3_c9a2_4066_96f0_bd9563314726);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVBS_SCAN_TABLE_MAX_SIZE: u32 = 400u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVBScramblingControlSpanningEvent {
    pub ulPID: u32,
    pub fScrambled: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVBScramblingControlSpanningEvent {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVBScramblingControlSpanningEvent {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVBScramblingControlSpanningEvent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVBScramblingControlSpanningEvent").field("ulPID", &self.ulPID).field("fScrambled", &self.fScrambled).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVBScramblingControlSpanningEvent {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVBScramblingControlSpanningEvent {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVBScramblingControlSpanningEvent>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVBScramblingControlSpanningEvent {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVBScramblingControlSpanningEvent {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVBSystemType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_Cable: DVBSystemType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_Terrestrial: DVBSystemType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_Satellite: DVBSystemType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ISDB_Terrestrial: DVBSystemType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ISDB_Satellite: DVBSystemType = 4i32;
pub const DVBTLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9cd64701_bdf3_4d14_8e03_f12983d86664);
pub const DVBTLocator2: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefe3fa02_45d7_4920_be96_53fa7f35b0e6);
pub const DVBTuneRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x15d6504a_5494_499c_886c_973c9e53b9f1);
pub const DVBTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6b14b32_76aa_4a86_a7ac_5c79aaf58da7);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_BAT_PID: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_BAT_TID: u32 = 74u32;
pub const DVB_CABLE_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdc0c0fe7_0485_4266_b93f_68fbf80ed834);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_DIT_PID: u32 = 30u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_DIT_TID: u32 = 126u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_EIT_ACTUAL_TID: u32 = 78u32;
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVB_EIT_FILTER_OPTIONS {
    pub fSpecifySegment: super::super::Foundation::BOOL,
    pub bSegment: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVB_EIT_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVB_EIT_FILTER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVB_EIT_FILTER_OPTIONS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVB_EIT_FILTER_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVB_EIT_FILTER_OPTIONS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVB_EIT_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVB_EIT_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_EIT_OTHER_TID: u32 = 79u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_EIT_PID: u32 = 18u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_NIT_ACTUAL_TID: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_NIT_OTHER_TID: u32 = 65u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_NIT_PID: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_RST_PID: u32 = 19u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_RST_TID: u32 = 113u32;
pub const DVB_SATELLITE_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa4b375a_45b4_4d45_8440_263957b11623);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_SDT_ACTUAL_TID: u32 = 66u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_SDT_OTHER_TID: u32 = 70u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_SDT_PID: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_SIT_PID: u32 = 31u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_SIT_TID: u32 = 127u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVB_STRCONV_MODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const STRCONV_MODE_DVB: DVB_STRCONV_MODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const STRCONV_MODE_DVB_EMPHASIS: DVB_STRCONV_MODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const STRCONV_MODE_DVB_WITHOUT_EMPHASIS: DVB_STRCONV_MODE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const STRCONV_MODE_ISDB: DVB_STRCONV_MODE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_PID_16: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_PID_17: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_PID_18: u32 = 18u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_PID_19: u32 = 19u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_PID_20: u32 = 20u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_ST_TID: u32 = 114u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_TDT_PID: u32 = 20u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_TDT_TID: u32 = 112u32;
pub const DVB_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x216c62df_6d7f_4e9a_8571_05f14edb766a);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_TOT_PID: u32 = 20u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVB_TOT_TID: u32 = 115u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVDFilterState = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdState_Undefined: DVDFilterState = -2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdState_Unitialized: DVDFilterState = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdState_Stopped: DVDFilterState = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdState_Paused: DVDFilterState = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdState_Running: DVDFilterState = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVDMenuIDConstants = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Title: DVDMenuIDConstants = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Root: DVDMenuIDConstants = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Subpicture: DVDMenuIDConstants = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Audio: DVDMenuIDConstants = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Angle: DVDMenuIDConstants = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdMenu_Chapter: DVDMenuIDConstants = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVDSPExt = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_NotSpecified: DVDSPExt = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_Caption_Normal: DVDSPExt = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_Caption_Big: DVDSPExt = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_Caption_Children: DVDSPExt = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_CC_Normal: DVDSPExt = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_CC_Big: DVDSPExt = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_CC_Children: DVDSPExt = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_Forced: DVDSPExt = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_DirectorComments_Normal: DVDSPExt = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_DirectorComments_Big: DVDSPExt = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdSPExt_DirectorComments_Children: DVDSPExt = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVDTextStringType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStruct_Volume: DVDTextStringType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStruct_Title: DVDTextStringType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStruct_ParentalID: DVDTextStringType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStruct_PartOfTitle: DVDTextStringType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStruct_Cell: DVDTextStringType = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStream_Audio: DVDTextStringType = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStream_Subpicture: DVDTextStringType = 17i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdStream_Angle: DVDTextStringType = 18i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdChannel_Audio: DVDTextStringType = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdGeneral_Name: DVDTextStringType = 48i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdGeneral_Comments: DVDTextStringType = 49i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Series: DVDTextStringType = 56i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Movie: DVDTextStringType = 57i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Video: DVDTextStringType = 58i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Album: DVDTextStringType = 59i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Song: DVDTextStringType = 60i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Other: DVDTextStringType = 63i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Series: DVDTextStringType = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Movie: DVDTextStringType = 65i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Video: DVDTextStringType = 66i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Album: DVDTextStringType = 67i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Song: DVDTextStringType = 68i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Sub_Other: DVDTextStringType = 71i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Series: DVDTextStringType = 72i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Movie: DVDTextStringType = 73i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Video: DVDTextStringType = 74i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Album: DVDTextStringType = 75i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Song: DVDTextStringType = 76i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdTitle_Orig_Other: DVDTextStringType = 79i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdOther_Scene: DVDTextStringType = 80i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdOther_Cut: DVDTextStringType = 81i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dvdOther_Take: DVDTextStringType = 82i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_ATR {
    pub ulCAT: u32,
    pub pbATRI: [u8; 768],
}
impl ::core::marker::Copy for DVD_ATR {}
impl ::core::clone::Clone for DVD_ATR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_ATR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_ATR").field("ulCAT", &self.ulCAT).field("pbATRI", &self.pbATRI).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_ATR {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_ATR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_ATR>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_ATR {}
impl ::core::default::Default for DVD_ATR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_AUDIO_APPMODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioMode_None: DVD_AUDIO_APPMODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioMode_Karaoke: DVD_AUDIO_APPMODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioMode_Surround: DVD_AUDIO_APPMODE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioMode_Other: DVD_AUDIO_APPMODE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUDIO_CAPS_AC3: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUDIO_CAPS_DTS: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUDIO_CAPS_LPCM: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUDIO_CAPS_MPEG2: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUDIO_CAPS_SDDS: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_AUDIO_FORMAT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_AC3: DVD_AUDIO_FORMAT = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_MPEG1: DVD_AUDIO_FORMAT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_MPEG1_DRC: DVD_AUDIO_FORMAT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_MPEG2: DVD_AUDIO_FORMAT = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_MPEG2_DRC: DVD_AUDIO_FORMAT = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_LPCM: DVD_AUDIO_FORMAT = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_DTS: DVD_AUDIO_FORMAT = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_SDDS: DVD_AUDIO_FORMAT = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioFormat_Other: DVD_AUDIO_FORMAT = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_AUDIO_LANG_EXT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUD_EXT_NotSpecified: DVD_AUDIO_LANG_EXT = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUD_EXT_Captions: DVD_AUDIO_LANG_EXT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUD_EXT_VisuallyImpaired: DVD_AUDIO_LANG_EXT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUD_EXT_DirectorComments1: DVD_AUDIO_LANG_EXT = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AUD_EXT_DirectorComments2: DVD_AUDIO_LANG_EXT = 4i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_AudioAttributes {
    pub AppMode: DVD_AUDIO_APPMODE,
    pub AppModeData: u8,
    pub AudioFormat: DVD_AUDIO_FORMAT,
    pub Language: u32,
    pub LanguageExtension: DVD_AUDIO_LANG_EXT,
    pub fHasMultichannelInfo: super::super::Foundation::BOOL,
    pub dwFrequency: u32,
    pub bQuantization: u8,
    pub bNumberOfChannels: u8,
    pub dwReserved: [u32; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_AudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_AudioAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_AudioAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_AudioAttributes").field("AppMode", &self.AppMode).field("AppModeData", &self.AppModeData).field("AudioFormat", &self.AudioFormat).field("Language", &self.Language).field("LanguageExtension", &self.LanguageExtension).field("fHasMultichannelInfo", &self.fHasMultichannelInfo).field("dwFrequency", &self.dwFrequency).field("bQuantization", &self.bQuantization).field("bNumberOfChannels", &self.bNumberOfChannels).field("dwReserved", &self.dwReserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_AudioAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_AudioAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_AudioAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_AudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_AudioAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_CMD_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_None: DVD_CMD_FLAGS = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_Flush: DVD_CMD_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_SendEvents: DVD_CMD_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_Block: DVD_CMD_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_StartWhenRendered: DVD_CMD_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CMD_FLAG_EndAfterRendered: DVD_CMD_FLAGS = 16i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_DECODER_CAPS {
    pub dwSize: u32,
    pub dwAudioCaps: u32,
    pub dFwdMaxRateVideo: f64,
    pub dFwdMaxRateAudio: f64,
    pub dFwdMaxRateSP: f64,
    pub dBwdMaxRateVideo: f64,
    pub dBwdMaxRateAudio: f64,
    pub dBwdMaxRateSP: f64,
    pub dwRes1: u32,
    pub dwRes2: u32,
    pub dwRes3: u32,
    pub dwRes4: u32,
}
impl ::core::marker::Copy for DVD_DECODER_CAPS {}
impl ::core::clone::Clone for DVD_DECODER_CAPS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_DECODER_CAPS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_DECODER_CAPS")
            .field("dwSize", &self.dwSize)
            .field("dwAudioCaps", &self.dwAudioCaps)
            .field("dFwdMaxRateVideo", &self.dFwdMaxRateVideo)
            .field("dFwdMaxRateAudio", &self.dFwdMaxRateAudio)
            .field("dFwdMaxRateSP", &self.dFwdMaxRateSP)
            .field("dBwdMaxRateVideo", &self.dBwdMaxRateVideo)
            .field("dBwdMaxRateAudio", &self.dBwdMaxRateAudio)
            .field("dBwdMaxRateSP", &self.dBwdMaxRateSP)
            .field("dwRes1", &self.dwRes1)
            .field("dwRes2", &self.dwRes2)
            .field("dwRes3", &self.dwRes3)
            .field("dwRes4", &self.dwRes4)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_DECODER_CAPS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_DECODER_CAPS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_DECODER_CAPS>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_DECODER_CAPS {}
impl ::core::default::Default for DVD_DECODER_CAPS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DEFAULT_AUDIO_STREAM: u32 = 15u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_DISC_SIDE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SIDE_A: DVD_DISC_SIDE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SIDE_B: DVD_DISC_SIDE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_DOMAIN = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DOMAIN_FirstPlay: DVD_DOMAIN = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DOMAIN_VideoManagerMenu: DVD_DOMAIN = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DOMAIN_VideoTitleSetMenu: DVD_DOMAIN = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DOMAIN_Title: DVD_DOMAIN = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DOMAIN_Stop: DVD_DOMAIN = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_ERROR = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_Unexpected: DVD_ERROR = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_CopyProtectFail: DVD_ERROR = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_InvalidDVD1_0Disc: DVD_ERROR = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_InvalidDiscRegion: DVD_ERROR = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_LowParentalLevel: DVD_ERROR = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_MacrovisionFail: DVD_ERROR = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_IncompatibleSystemAndDecoderRegions: DVD_ERROR = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_IncompatibleDiscAndDecoderRegions: DVD_ERROR = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_CopyProtectOutputFail: DVD_ERROR = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ERROR_CopyProtectOutputNotSupported: DVD_ERROR = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_FRAMERATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_FPS_25: DVD_FRAMERATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_FPS_30NonDrop: DVD_FRAMERATE = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_HMSF_TIMECODE {
    pub bHours: u8,
    pub bMinutes: u8,
    pub bSeconds: u8,
    pub bFrames: u8,
}
impl ::core::marker::Copy for DVD_HMSF_TIMECODE {}
impl ::core::clone::Clone for DVD_HMSF_TIMECODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_HMSF_TIMECODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_HMSF_TIMECODE").field("bHours", &self.bHours).field("bMinutes", &self.bMinutes).field("bSeconds", &self.bSeconds).field("bFrames", &self.bFrames).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_HMSF_TIMECODE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_HMSF_TIMECODE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_HMSF_TIMECODE>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_HMSF_TIMECODE {}
impl ::core::default::Default for DVD_HMSF_TIMECODE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_KARAOKE_ASSIGNMENT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_reserved0: DVD_KARAOKE_ASSIGNMENT = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_reserved1: DVD_KARAOKE_ASSIGNMENT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LR: DVD_KARAOKE_ASSIGNMENT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LRM: DVD_KARAOKE_ASSIGNMENT = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LR1: DVD_KARAOKE_ASSIGNMENT = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LRM1: DVD_KARAOKE_ASSIGNMENT = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LR12: DVD_KARAOKE_ASSIGNMENT = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Assignment_LRM12: DVD_KARAOKE_ASSIGNMENT = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_KARAOKE_CONTENTS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideVocal1: DVD_KARAOKE_CONTENTS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideVocal2: DVD_KARAOKE_CONTENTS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideMelody1: DVD_KARAOKE_CONTENTS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideMelody2: DVD_KARAOKE_CONTENTS = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideMelodyA: DVD_KARAOKE_CONTENTS = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_GuideMelodyB: DVD_KARAOKE_CONTENTS = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_SoundEffectA: DVD_KARAOKE_CONTENTS = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Karaoke_SoundEffectB: DVD_KARAOKE_CONTENTS = 128i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_KARAOKE_DOWNMIX = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_0to0: DVD_KARAOKE_DOWNMIX = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_1to0: DVD_KARAOKE_DOWNMIX = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_2to0: DVD_KARAOKE_DOWNMIX = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_3to0: DVD_KARAOKE_DOWNMIX = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_4to0: DVD_KARAOKE_DOWNMIX = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_Lto0: DVD_KARAOKE_DOWNMIX = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_Rto0: DVD_KARAOKE_DOWNMIX = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_0to1: DVD_KARAOKE_DOWNMIX = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_1to1: DVD_KARAOKE_DOWNMIX = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_2to1: DVD_KARAOKE_DOWNMIX = 1024i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_3to1: DVD_KARAOKE_DOWNMIX = 2048i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_4to1: DVD_KARAOKE_DOWNMIX = 4096i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_Lto1: DVD_KARAOKE_DOWNMIX = 8192i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Mix_Rto1: DVD_KARAOKE_DOWNMIX = 16384i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_KaraokeAttributes {
    pub bVersion: u8,
    pub fMasterOfCeremoniesInGuideVocal1: super::super::Foundation::BOOL,
    pub fDuet: super::super::Foundation::BOOL,
    pub ChannelAssignment: DVD_KARAOKE_ASSIGNMENT,
    pub wChannelContents: [u16; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_KaraokeAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_KaraokeAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_KaraokeAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_KaraokeAttributes").field("bVersion", &self.bVersion).field("fMasterOfCeremoniesInGuideVocal1", &self.fMasterOfCeremoniesInGuideVocal1).field("fDuet", &self.fDuet).field("ChannelAssignment", &self.ChannelAssignment).field("wChannelContents", &self.wChannelContents).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_KaraokeAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_KaraokeAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_KaraokeAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_KaraokeAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_KaraokeAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_MENU_ID = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Title: DVD_MENU_ID = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Root: DVD_MENU_ID = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Subpicture: DVD_MENU_ID = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Audio: DVD_MENU_ID = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Angle: DVD_MENU_ID = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MENU_Chapter: DVD_MENU_ID = 7i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_MUA_Coeff {
    pub log2_alpha: f64,
    pub log2_beta: f64,
}
impl ::core::marker::Copy for DVD_MUA_Coeff {}
impl ::core::clone::Clone for DVD_MUA_Coeff {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_MUA_Coeff {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_MUA_Coeff").field("log2_alpha", &self.log2_alpha).field("log2_beta", &self.log2_beta).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_MUA_Coeff {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_MUA_Coeff {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_MUA_Coeff>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_MUA_Coeff {}
impl ::core::default::Default for DVD_MUA_Coeff {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_MUA_MixingInfo {
    pub fMixTo0: super::super::Foundation::BOOL,
    pub fMixTo1: super::super::Foundation::BOOL,
    pub fMix0InPhase: super::super::Foundation::BOOL,
    pub fMix1InPhase: super::super::Foundation::BOOL,
    pub dwSpeakerPosition: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_MUA_MixingInfo {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_MUA_MixingInfo {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_MUA_MixingInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_MUA_MixingInfo").field("fMixTo0", &self.fMixTo0).field("fMixTo1", &self.fMixTo1).field("fMix0InPhase", &self.fMix0InPhase).field("fMix1InPhase", &self.fMix1InPhase).field("dwSpeakerPosition", &self.dwSpeakerPosition).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_MUA_MixingInfo {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_MUA_MixingInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_MUA_MixingInfo>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_MUA_MixingInfo {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_MUA_MixingInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_MenuAttributes {
    pub fCompatibleRegion: [super::super::Foundation::BOOL; 8],
    pub VideoAttributes: DVD_VideoAttributes,
    pub fAudioPresent: super::super::Foundation::BOOL,
    pub AudioAttributes: DVD_AudioAttributes,
    pub fSubpicturePresent: super::super::Foundation::BOOL,
    pub SubpictureAttributes: DVD_SubpictureAttributes,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_MenuAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_MenuAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_MenuAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_MenuAttributes").field("fCompatibleRegion", &self.fCompatibleRegion).field("VideoAttributes", &self.VideoAttributes).field("fAudioPresent", &self.fAudioPresent).field("AudioAttributes", &self.AudioAttributes).field("fSubpicturePresent", &self.fSubpicturePresent).field("SubpictureAttributes", &self.SubpictureAttributes).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_MenuAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_MenuAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_MenuAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_MenuAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_MenuAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_MultichannelAudioAttributes {
    pub Info: [DVD_MUA_MixingInfo; 8],
    pub Coeff: [DVD_MUA_Coeff; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_MultichannelAudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_MultichannelAudioAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_MultichannelAudioAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_MultichannelAudioAttributes").field("Info", &self.Info).field("Coeff", &self.Coeff).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_MultichannelAudioAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_MultichannelAudioAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_MultichannelAudioAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_MultichannelAudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_MultichannelAudioAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_NavCmdType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NavCmdType_Pre: DVD_NavCmdType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NavCmdType_Post: DVD_NavCmdType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NavCmdType_Cell: DVD_NavCmdType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NavCmdType_Button: DVD_NavCmdType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_OPTION_FLAG = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ResetOnStop: DVD_OPTION_FLAG = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NotifyParentalLevelChange: DVD_OPTION_FLAG = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_HMSF_TimeCodeEvents: DVD_OPTION_FLAG = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AudioDuringFFwdRew: DVD_OPTION_FLAG = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableNonblockingAPIs: DVD_OPTION_FLAG = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CacheSizeInMB: DVD_OPTION_FLAG = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnablePortableBookmarks: DVD_OPTION_FLAG = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableExtendedCopyProtectErrors: DVD_OPTION_FLAG = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_NotifyPositionChange: DVD_OPTION_FLAG = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_IncreaseOutputControl: DVD_OPTION_FLAG = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableStreaming: DVD_OPTION_FLAG = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableESOutput: DVD_OPTION_FLAG = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableTitleLength: DVD_OPTION_FLAG = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DisableStillThrottle: DVD_OPTION_FLAG = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableLoggingEvents: DVD_OPTION_FLAG = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_MaxReadBurstInKB: DVD_OPTION_FLAG = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_ReadBurstPeriodInMS: DVD_OPTION_FLAG = 17i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_RestartDisc: DVD_OPTION_FLAG = 18i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_EnableCC: DVD_OPTION_FLAG = 19i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_PARENTAL_LEVEL = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_8: DVD_PARENTAL_LEVEL = 32768i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_7: DVD_PARENTAL_LEVEL = 16384i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_6: DVD_PARENTAL_LEVEL = 8192i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_5: DVD_PARENTAL_LEVEL = 4096i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_4: DVD_PARENTAL_LEVEL = 2048i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_3: DVD_PARENTAL_LEVEL = 1024i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_2: DVD_PARENTAL_LEVEL = 512i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PARENTAL_LEVEL_1: DVD_PARENTAL_LEVEL = 256i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_PB_STOPPED = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_Other: DVD_PB_STOPPED = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_NoBranch: DVD_PB_STOPPED = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_NoFirstPlayDomain: DVD_PB_STOPPED = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_StopCommand: DVD_PB_STOPPED = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_Reset: DVD_PB_STOPPED = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_DiscEjected: DVD_PB_STOPPED = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_IllegalNavCommand: DVD_PB_STOPPED = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_PlayPeriodAutoStop: DVD_PB_STOPPED = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_PlayChapterAutoStop: DVD_PB_STOPPED = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_ParentalFailure: DVD_PB_STOPPED = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_RegionFailure: DVD_PB_STOPPED = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_MacrovisionFailure: DVD_PB_STOPPED = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_DiscReadError: DVD_PB_STOPPED = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_CopyProtectFailure: DVD_PB_STOPPED = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_CopyProtectOutputFailure: DVD_PB_STOPPED = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_PB_STOPPED_CopyProtectOutputNotSupported: DVD_PB_STOPPED = 15i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_PLAYBACK_LOCATION {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: u32,
}
impl ::core::marker::Copy for DVD_PLAYBACK_LOCATION {}
impl ::core::clone::Clone for DVD_PLAYBACK_LOCATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_PLAYBACK_LOCATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_PLAYBACK_LOCATION").field("TitleNum", &self.TitleNum).field("ChapterNum", &self.ChapterNum).field("TimeCode", &self.TimeCode).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_PLAYBACK_LOCATION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_PLAYBACK_LOCATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_PLAYBACK_LOCATION>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_PLAYBACK_LOCATION {}
impl ::core::default::Default for DVD_PLAYBACK_LOCATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_PLAYBACK_LOCATION2 {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: DVD_HMSF_TIMECODE,
    pub TimeCodeFlags: u32,
}
impl ::core::marker::Copy for DVD_PLAYBACK_LOCATION2 {}
impl ::core::clone::Clone for DVD_PLAYBACK_LOCATION2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_PLAYBACK_LOCATION2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_PLAYBACK_LOCATION2").field("TitleNum", &self.TitleNum).field("ChapterNum", &self.ChapterNum).field("TimeCode", &self.TimeCode).field("TimeCodeFlags", &self.TimeCodeFlags).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_PLAYBACK_LOCATION2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_PLAYBACK_LOCATION2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_PLAYBACK_LOCATION2>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_PLAYBACK_LOCATION2 {}
impl ::core::default::Default for DVD_PLAYBACK_LOCATION2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_PLAY_DIRECTION = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DIR_FORWARD: DVD_PLAY_DIRECTION = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_DIR_BACKWARD: DVD_PLAY_DIRECTION = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_PREFERRED_DISPLAY_MODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPLAY_CONTENT_DEFAULT: DVD_PREFERRED_DISPLAY_MODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPLAY_16x9: DVD_PREFERRED_DISPLAY_MODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPLAY_4x3_PANSCAN_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DISPLAY_4x3_LETTERBOX_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = 3i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_REGION {
    pub CopySystem: u8,
    pub RegionData: u8,
    pub SystemRegion: u8,
    pub ResetCount: u8,
}
impl ::core::marker::Copy for DVD_REGION {}
impl ::core::clone::Clone for DVD_REGION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_REGION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_REGION").field("CopySystem", &self.CopySystem).field("RegionData", &self.RegionData).field("SystemRegion", &self.SystemRegion).field("ResetCount", &self.ResetCount).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_REGION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_REGION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_REGION>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_REGION {}
impl ::core::default::Default for DVD_REGION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_RELATIVE_BUTTON = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Relative_Upper: DVD_RELATIVE_BUTTON = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Relative_Lower: DVD_RELATIVE_BUTTON = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Relative_Left: DVD_RELATIVE_BUTTON = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Relative_Right: DVD_RELATIVE_BUTTON = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_STREAM_DATA_CURRENT: u32 = 2048u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_STREAM_DATA_VMGM: u32 = 1024u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_STREAM_DATA_VTSM: u32 = 1025u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_SUBPICTURE_CODING = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPCoding_RunLength: DVD_SUBPICTURE_CODING = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPCoding_Extended: DVD_SUBPICTURE_CODING = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPCoding_Other: DVD_SUBPICTURE_CODING = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_SUBPICTURE_LANG_EXT = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_NotSpecified: DVD_SUBPICTURE_LANG_EXT = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_Caption_Normal: DVD_SUBPICTURE_LANG_EXT = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_Caption_Big: DVD_SUBPICTURE_LANG_EXT = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_Caption_Children: DVD_SUBPICTURE_LANG_EXT = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_CC_Normal: DVD_SUBPICTURE_LANG_EXT = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_CC_Big: DVD_SUBPICTURE_LANG_EXT = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_CC_Children: DVD_SUBPICTURE_LANG_EXT = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_Forced: DVD_SUBPICTURE_LANG_EXT = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_DirectorComments_Normal: DVD_SUBPICTURE_LANG_EXT = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_DirectorComments_Big: DVD_SUBPICTURE_LANG_EXT = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SP_EXT_DirectorComments_Children: DVD_SUBPICTURE_LANG_EXT = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_SUBPICTURE_TYPE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPType_NotSpecified: DVD_SUBPICTURE_TYPE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPType_Language: DVD_SUBPICTURE_TYPE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_SPType_Other: DVD_SUBPICTURE_TYPE = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_SubpictureAttributes {
    pub Type: DVD_SUBPICTURE_TYPE,
    pub CodingMode: DVD_SUBPICTURE_CODING,
    pub Language: u32,
    pub LanguageExtension: DVD_SUBPICTURE_LANG_EXT,
}
impl ::core::marker::Copy for DVD_SubpictureAttributes {}
impl ::core::clone::Clone for DVD_SubpictureAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_SubpictureAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_SubpictureAttributes").field("Type", &self.Type).field("CodingMode", &self.CodingMode).field("Language", &self.Language).field("LanguageExtension", &self.LanguageExtension).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_SubpictureAttributes {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_SubpictureAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_SubpictureAttributes>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_SubpictureAttributes {}
impl ::core::default::Default for DVD_SubpictureAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVD_TIMECODE {
    pub _bitfield: u32,
}
impl ::core::marker::Copy for DVD_TIMECODE {}
impl ::core::clone::Clone for DVD_TIMECODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVD_TIMECODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_TIMECODE").field("_bitfield", &self._bitfield).finish()
    }
}
unsafe impl ::windows::core::Abi for DVD_TIMECODE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVD_TIMECODE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_TIMECODE>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVD_TIMECODE {}
impl ::core::default::Default for DVD_TIMECODE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_TIMECODE_FLAGS = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_TC_FLAG_25fps: DVD_TIMECODE_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_TC_FLAG_30fps: DVD_TIMECODE_FLAGS = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_TC_FLAG_DropFrame: DVD_TIMECODE_FLAGS = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_TC_FLAG_Interpolated: DVD_TIMECODE_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_TITLE_APPMODE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AppMode_Not_Specified: DVD_TITLE_APPMODE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AppMode_Karaoke: DVD_TITLE_APPMODE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_AppMode_Other: DVD_TITLE_APPMODE = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_TITLE_MENU: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_TextCharSet = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CharSet_Unicode: DVD_TextCharSet = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CharSet_ISO646: DVD_TextCharSet = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CharSet_JIS_Roman_Kanji: DVD_TextCharSet = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CharSet_ISO8859_1: DVD_TextCharSet = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana: DVD_TextCharSet = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_TextStringType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Struct_Volume: DVD_TextStringType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Struct_Title: DVD_TextStringType = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Struct_ParentalID: DVD_TextStringType = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Struct_PartOfTitle: DVD_TextStringType = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Struct_Cell: DVD_TextStringType = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Stream_Audio: DVD_TextStringType = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Stream_Subpicture: DVD_TextStringType = 17i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Stream_Angle: DVD_TextStringType = 18i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Channel_Audio: DVD_TextStringType = 32i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_General_Name: DVD_TextStringType = 48i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_General_Comments: DVD_TextStringType = 49i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Series: DVD_TextStringType = 56i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Movie: DVD_TextStringType = 57i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Video: DVD_TextStringType = 58i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Album: DVD_TextStringType = 59i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Song: DVD_TextStringType = 60i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Other: DVD_TextStringType = 63i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Series: DVD_TextStringType = 64i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Movie: DVD_TextStringType = 65i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Video: DVD_TextStringType = 66i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Album: DVD_TextStringType = 67i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Song: DVD_TextStringType = 68i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Sub_Other: DVD_TextStringType = 71i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Series: DVD_TextStringType = 72i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Movie: DVD_TextStringType = 73i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Video: DVD_TextStringType = 74i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Album: DVD_TextStringType = 75i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Song: DVD_TextStringType = 76i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Title_Orig_Other: DVD_TextStringType = 79i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Other_Scene: DVD_TextStringType = 80i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Other_Cut: DVD_TextStringType = 81i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_Other_Take: DVD_TextStringType = 82i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_TitleAttributes {
    pub Anonymous: DVD_TitleAttributes_0,
    pub VideoAttributes: DVD_VideoAttributes,
    pub ulNumberOfAudioStreams: u32,
    pub AudioAttributes: [DVD_AudioAttributes; 8],
    pub MultichannelAudioAttributes: [DVD_MultichannelAudioAttributes; 8],
    pub ulNumberOfSubpictureStreams: u32,
    pub SubpictureAttributes: [DVD_SubpictureAttributes; 32],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_TitleAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_TitleAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_TitleAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_TitleAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_TitleAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_TitleAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_TitleAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub union DVD_TitleAttributes_0 {
    pub AppMode: DVD_TITLE_APPMODE,
    pub TitleLength: DVD_HMSF_TIMECODE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_TitleAttributes_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_TitleAttributes_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_TitleAttributes_0 {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_TitleAttributes_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_TitleAttributes_0>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_TitleAttributes_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_TitleAttributes_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_VIDEO_COMPRESSION = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_VideoCompression_Other: DVD_VIDEO_COMPRESSION = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_VideoCompression_MPEG1: DVD_VIDEO_COMPRESSION = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_VideoCompression_MPEG2: DVD_VIDEO_COMPRESSION = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVD_VideoAttributes {
    pub fPanscanPermitted: super::super::Foundation::BOOL,
    pub fLetterboxPermitted: super::super::Foundation::BOOL,
    pub ulAspectX: u32,
    pub ulAspectY: u32,
    pub ulFrameRate: u32,
    pub ulFrameHeight: u32,
    pub Compression: DVD_VIDEO_COMPRESSION,
    pub fLine21Field1InGOP: super::super::Foundation::BOOL,
    pub fLine21Field2InGOP: super::super::Foundation::BOOL,
    pub ulSourceResolutionX: u32,
    pub ulSourceResolutionY: u32,
    pub fIsSourceLetterboxed: super::super::Foundation::BOOL,
    pub fIsFilmMode: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DVD_VideoAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVD_VideoAttributes {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVD_VideoAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVD_VideoAttributes")
            .field("fPanscanPermitted", &self.fPanscanPermitted)
            .field("fLetterboxPermitted", &self.fLetterboxPermitted)
            .field("ulAspectX", &self.ulAspectX)
            .field("ulAspectY", &self.ulAspectY)
            .field("ulFrameRate", &self.ulFrameRate)
            .field("ulFrameHeight", &self.ulFrameHeight)
            .field("Compression", &self.Compression)
            .field("fLine21Field1InGOP", &self.fLine21Field1InGOP)
            .field("fLine21Field2InGOP", &self.fLine21Field2InGOP)
            .field("ulSourceResolutionX", &self.ulSourceResolutionX)
            .field("ulSourceResolutionY", &self.ulSourceResolutionY)
            .field("fIsSourceLetterboxed", &self.fIsSourceLetterboxed)
            .field("fIsFilmMode", &self.fIsFilmMode)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVD_VideoAttributes {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVD_VideoAttributes {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVD_VideoAttributes>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVD_VideoAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVD_VideoAttributes {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DVD_WARNING = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_InvalidDVD1_0Disc: DVD_WARNING = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_FormatNotSupported: DVD_WARNING = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_IllegalNavCommand: DVD_WARNING = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_Open: DVD_WARNING = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_Seek: DVD_WARNING = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DVD_WARNING_Read: DVD_WARNING = 6i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DVINFO {
    pub dwDVAAuxSrc: u32,
    pub dwDVAAuxCtl: u32,
    pub dwDVAAuxSrc1: u32,
    pub dwDVAAuxCtl1: u32,
    pub dwDVVAuxSrc: u32,
    pub dwDVVAuxCtl: u32,
    pub dwDVReserved: [u32; 2],
}
impl ::core::marker::Copy for DVINFO {}
impl ::core::clone::Clone for DVINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DVINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVINFO").field("dwDVAAuxSrc", &self.dwDVAAuxSrc).field("dwDVAAuxCtl", &self.dwDVAAuxCtl).field("dwDVAAuxSrc1", &self.dwDVAAuxSrc1).field("dwDVAAuxCtl1", &self.dwDVAAuxCtl1).field("dwDVVAuxSrc", &self.dwDVVAuxSrc).field("dwDVVAuxCtl", &self.dwDVVAuxCtl).field("dwDVReserved", &self.dwDVReserved).finish()
    }
}
unsafe impl ::windows::core::Abi for DVINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DVINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DVINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for DVINFO {}
impl ::core::default::Default for DVINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DVR_STREAM_DESC {
    pub Version: u32,
    pub StreamId: u32,
    pub Default: super::super::Foundation::BOOL,
    pub Creation: super::super::Foundation::BOOL,
    pub Reserved: u32,
    pub guidSubMediaType: ::windows::core::GUID,
    pub guidFormatType: ::windows::core::GUID,
    pub MediaType: AM_MEDIA_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DVR_STREAM_DESC {
    fn clone(&self) -> Self {
        Self {
            Version: self.Version,
            StreamId: self.StreamId,
            Default: self.Default,
            Creation: self.Creation,
            Reserved: self.Reserved,
            guidSubMediaType: self.guidSubMediaType,
            guidFormatType: self.guidFormatType,
            MediaType: self.MediaType.clone(),
        }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DVR_STREAM_DESC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DVR_STREAM_DESC").field("Version", &self.Version).field("StreamId", &self.StreamId).field("Default", &self.Default).field("Creation", &self.Creation).field("Reserved", &self.Reserved).field("guidSubMediaType", &self.guidSubMediaType).field("guidFormatType", &self.guidFormatType).field("MediaType", &self.MediaType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DVR_STREAM_DESC {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DVR_STREAM_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.StreamId == other.StreamId && self.Default == other.Default && self.Creation == other.Creation && self.Reserved == other.Reserved && self.guidSubMediaType == other.guidSubMediaType && self.guidFormatType == other.guidFormatType && self.MediaType == other.MediaType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DVR_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DVR_STREAM_DESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DWORD_ALLPARAMS: i32 = -1i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_Graphics_Direct3D9', 'Win32_Media_MediaFoundation'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
pub struct DXVA2SW_CALLBACKS {
    pub Size: u32,
    pub GetVideoProcessorRenderTargetCount: PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETCOUNT,
    pub GetVideoProcessorRenderTargets: PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETS,
    pub GetVideoProcessorCaps: PDXVA2SW_GETVIDEOPROCESSORCAPS,
    pub GetVideoProcessorSubStreamFormatCount: PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATCOUNT,
    pub GetVideoProcessorSubStreamFormats: PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATS,
    pub GetProcAmpRange: PDXVA2SW_GETPROCAMPRANGE,
    pub GetFilterPropertyRange: PDXVA2SW_GETFILTERPROPERTYRANGE,
    pub CreateVideoProcessDevice: PDXVA2SW_CREATEVIDEOPROCESSDEVICE,
    pub DestroyVideoProcessDevice: PDXVA2SW_DESTROYVIDEOPROCESSDEVICE,
    pub VideoProcessBeginFrame: PDXVA2SW_VIDEOPROCESSBEGINFRAME,
    pub VideoProcessEndFrame: PDXVA2SW_VIDEOPROCESSENDFRAME,
    pub VideoProcessSetRenderTarget: PDXVA2SW_VIDEOPROCESSSETRENDERTARGET,
    pub VideoProcessBlt: PDXVA2SW_VIDEOPROCESSBLT,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::marker::Copy for DXVA2SW_CALLBACKS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::clone::Clone for DXVA2SW_CALLBACKS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::fmt::Debug for DXVA2SW_CALLBACKS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA2SW_CALLBACKS")
            .field("Size", &self.Size)
            .field("GetVideoProcessorRenderTargetCount", &self.GetVideoProcessorRenderTargetCount.map(|f| f as usize))
            .field("GetVideoProcessorRenderTargets", &self.GetVideoProcessorRenderTargets.map(|f| f as usize))
            .field("GetVideoProcessorCaps", &self.GetVideoProcessorCaps.map(|f| f as usize))
            .field("GetVideoProcessorSubStreamFormatCount", &self.GetVideoProcessorSubStreamFormatCount.map(|f| f as usize))
            .field("GetVideoProcessorSubStreamFormats", &self.GetVideoProcessorSubStreamFormats.map(|f| f as usize))
            .field("GetProcAmpRange", &self.GetProcAmpRange.map(|f| f as usize))
            .field("GetFilterPropertyRange", &self.GetFilterPropertyRange.map(|f| f as usize))
            .field("CreateVideoProcessDevice", &self.CreateVideoProcessDevice.map(|f| f as usize))
            .field("DestroyVideoProcessDevice", &self.DestroyVideoProcessDevice.map(|f| f as usize))
            .field("VideoProcessBeginFrame", &self.VideoProcessBeginFrame.map(|f| f as usize))
            .field("VideoProcessEndFrame", &self.VideoProcessEndFrame.map(|f| f as usize))
            .field("VideoProcessSetRenderTarget", &self.VideoProcessSetRenderTarget.map(|f| f as usize))
            .field("VideoProcessBlt", &self.VideoProcessBlt.map(|f| f as usize))
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::core::Abi for DXVA2SW_CALLBACKS {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::PartialEq for DXVA2SW_CALLBACKS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2SW_CALLBACKS>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::Eq for DXVA2SW_CALLBACKS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::core::default::Default for DXVA2SW_CALLBACKS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2TraceVideoProcessBltData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub TargetFrameTime: u64,
    pub TargetRect: super::super::Foundation::RECT,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2TraceVideoProcessBltData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2TraceVideoProcessBltData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2TraceVideoProcessBltData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2TraceVideoProcessBltData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2TraceVideoProcessBltData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2TraceVideoProcessBltData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2TraceVideoProcessBltData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA2Trace_Control: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa0386e75_f70c_464c_a9ce_33c44e091623);
pub const DXVA2Trace_DecodeDevBeginFrame: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9fd1acf6_44cb_4637_bc62_2c11a9608f90);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_DecodeDevBeginFrameData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_DecodeDevBeginFrameData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_DecodeDevBeginFrameData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_DecodeDevBeginFrameData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_DecodeDevBeginFrameData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_DecodeDevBeginFrameData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_DecodeDevBeginFrameData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_DecodeDevBeginFrameData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA2Trace_DecodeDevCreated: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4de17a1_c5b2_44fe_86d5_d97a648114ff);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_DecodeDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: ::windows::core::GUID,
    pub Width: u32,
    pub Height: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_DecodeDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_DecodeDevCreatedData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_DecodeDevCreatedData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_DecodeDevCreatedData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_DecodeDevCreatedData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_DecodeDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_DecodeDevCreatedData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA2Trace_DecodeDevDestroyed: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x853ebdf2_4160_421d_8893_63dcea4f18bb);
pub const DXVA2Trace_DecodeDevEndFrame: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9fb3cb33_47dc_4899_98c8_c0c6cd7cd3cb);
pub const DXVA2Trace_DecodeDevExecute: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x850aeb4c_d19a_4609_b3b4_bcbf0e22121e);
pub const DXVA2Trace_DecodeDevGetBuffer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x57b128fb_72cb_4137_a575_d91fa3160897);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_DecodeDevGetBufferData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub BufferType: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_DecodeDevGetBufferData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_DecodeDevGetBufferData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_DecodeDevGetBufferData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_DecodeDevGetBufferData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_DecodeDevGetBufferData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_DecodeDevGetBufferData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_DecodeDevGetBufferData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_DecodeDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_DecodeDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_DecodeDeviceData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_DecodeDeviceData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_DecodeDeviceData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_DecodeDeviceData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_DecodeDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_DecodeDeviceData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA2Trace_VideoProcessBlt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69089cc0_71ab_42d0_953a_2887bf05a8af);
pub const DXVA2Trace_VideoProcessDevCreated: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x895508c6_540d_4c87_98f8_8dcbf2dabb2a);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_VideoProcessDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: ::windows::core::GUID,
    pub RTFourCC: u32,
    pub Width: u32,
    pub Height: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_VideoProcessDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_VideoProcessDevCreatedData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_VideoProcessDevCreatedData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_VideoProcessDevCreatedData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_VideoProcessDevCreatedData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_VideoProcessDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_VideoProcessDevCreatedData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA2Trace_VideoProcessDevDestroyed: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf97f30b1_fb49_42c7_8ee8_88bdfa92d4e2);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Diagnostics_Etw'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
pub struct DXVA2Trace_VideoProcessDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::marker::Copy for DXVA2Trace_VideoProcessDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::clone::Clone for DXVA2Trace_VideoProcessDeviceData {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::core::Abi for DXVA2Trace_VideoProcessDeviceData {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::PartialEq for DXVA2Trace_VideoProcessDeviceData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2Trace_VideoProcessDeviceData>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::cmp::Eq for DXVA2Trace_VideoProcessDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::core::default::Default for DXVA2Trace_VideoProcessDeviceData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DXVA2_DestinationFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_Background_Changed: DXVA2_DestinationFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_TargetRect_Changed: DXVA2_DestinationFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_ColorData_Changed: DXVA2_DestinationFlags = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_Alpha_Changed: DXVA2_DestinationFlags = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_RFF: DXVA2_DestinationFlags = 65536i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_TFF: DXVA2_DestinationFlags = 131072i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlag_RFF_TFF_Present: DXVA2_DestinationFlags = 262144i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_DestinationFlagMask: DXVA2_DestinationFlags = -65521i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DXVA2_SampleFlags = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_Palette_Changed: DXVA2_SampleFlags = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_SrcRect_Changed: DXVA2_SampleFlags = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_DstRect_Changed: DXVA2_SampleFlags = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_ColorData_Changed: DXVA2_SampleFlags = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_PlanarAlpha_Changed: DXVA2_SampleFlags = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_RFF: DXVA2_SampleFlags = 65536i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_TFF: DXVA2_SampleFlags = 131072i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlag_RFF_TFF_Present: DXVA2_SampleFlags = 262144i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA2_SampleFlagsMask: DXVA2_SampleFlags = -65505i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_Media_MediaFoundation'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
pub struct DXVA2_VIDEOPROCESSBLT {
    pub TargetFrame: i64,
    pub TargetRect: super::super::Foundation::RECT,
    pub ConstrictionSize: super::super::Foundation::SIZE,
    pub StreamingFlags: u32,
    pub BackgroundColor: super::MediaFoundation::DXVA2_AYUVSample16,
    pub DestFormat: super::MediaFoundation::DXVA2_ExtendedFormat,
    pub DestFlags: u32,
    pub ProcAmpValues: super::MediaFoundation::DXVA2_ProcAmpValues,
    pub Alpha: super::MediaFoundation::DXVA2_Fixed32,
    pub NoiseFilterLuma: super::MediaFoundation::DXVA2_FilterValues,
    pub NoiseFilterChroma: super::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterLuma: super::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterChroma: super::MediaFoundation::DXVA2_FilterValues,
    pub pSrcSurfaces: *mut DXVA2_VIDEOSAMPLE,
    pub NumSrcSurfaces: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::marker::Copy for DXVA2_VIDEOPROCESSBLT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::clone::Clone for DXVA2_VIDEOPROCESSBLT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::core::Abi for DXVA2_VIDEOPROCESSBLT {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::PartialEq for DXVA2_VIDEOPROCESSBLT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2_VIDEOPROCESSBLT>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::Eq for DXVA2_VIDEOPROCESSBLT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::default::Default for DXVA2_VIDEOPROCESSBLT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_Media_MediaFoundation'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
pub struct DXVA2_VIDEOSAMPLE {
    pub Start: i64,
    pub End: i64,
    pub SampleFormat: super::MediaFoundation::DXVA2_ExtendedFormat,
    pub SampleFlags: u32,
    pub SrcResource: *mut ::core::ffi::c_void,
    pub SrcRect: super::super::Foundation::RECT,
    pub DstRect: super::super::Foundation::RECT,
    pub Pal: [super::MediaFoundation::DXVA2_AYUVSample8; 16],
    pub PlanarAlpha: super::MediaFoundation::DXVA2_Fixed32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::marker::Copy for DXVA2_VIDEOSAMPLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::clone::Clone for DXVA2_VIDEOSAMPLE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::core::Abi for DXVA2_VIDEOSAMPLE {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::PartialEq for DXVA2_VIDEOSAMPLE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA2_VIDEOSAMPLE>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::cmp::Eq for DXVA2_VIDEOSAMPLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::core::default::Default for DXVA2_VIDEOSAMPLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ALPHA_BLEND_COMBINATION_BUFFER: u32 = 13u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ALPHA_BLEND_COMBINATION_FUNCTION: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ALPHA_BLEND_DATA_LOAD_FUNCTION: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_AYUV_BUFFER: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BIDIRECTIONAL_AVERAGING_H263_TRUNC: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_FORWARD: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_UNSPECIFIED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_MILD: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_SEVERE: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_UNLIKELY: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_BITSTREAM_DATA_BUFFER: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CHROMA_FORMAT_420: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CHROMA_FORMAT_422: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CHROMA_FORMAT_444: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COMPBUFFER_TYPE_THAT_IS_NOT_USED: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_BLEND_TYPE_BACK_HARDWARE: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_DATA_TYPE_AI44: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_DATA_TYPE_AYUV: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_DATA_TYPE_DPXD: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_CONFIG_DATA_TYPE_IA44: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COPPCommandFnCode: u32 = 4u32;
pub const DXVA_COPPDevice: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd2457add_8999_45ed_8a8a_d1aa047ba4d5);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COPPGetCertificateLengthFnCode: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COPPKeyExchangeFnCode: u32 = 2u32;
pub const DXVA_COPPQueryBusData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6f4d673_6174_4184_8e35_f6db5200bcba);
pub const DXVA_COPPQueryConnectorType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x81d0bfd5_6afe_48c2_99c0_95a08f97c5da);
pub const DXVA_COPPQueryDisplayData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd7bf1ba3_ad13_4f8e_af98_0dcb3ca204cc);
pub const DXVA_COPPQueryGlobalProtectionLevel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1957210a_7766_452a_b99a_d27aed54f03a);
pub const DXVA_COPPQueryHDCPKeyData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0db59d74_a992_492e_a0bd_c23fda564e00);
pub const DXVA_COPPQueryLocalProtectionLevel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2075857_3eda_4d5d_88db_748f8c1a0549);
pub const DXVA_COPPQueryProtectionType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38f2a801_9a6c_48bb_9107_b6696e6f1797);
pub const DXVA_COPPQuerySignaling: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6629a591_3b79_4cf3_924a_11e8e7811671);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COPPQueryStatusFnCode: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_COPPSequenceStartFnCode: u32 = 3u32;
pub const DXVA_COPPSetProtectionLevel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9bb9327c_4eb5_4727_9f00_b42b0919c0da);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPSetProtectionLevelCmdData {
    pub ProtType: u32,
    pub ProtLevel: u32,
    pub ExtendedInfoChangeMask: u32,
    pub ExtendedInfoData: u32,
}
impl ::core::marker::Copy for DXVA_COPPSetProtectionLevelCmdData {}
impl ::core::clone::Clone for DXVA_COPPSetProtectionLevelCmdData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPSetProtectionLevelCmdData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPSetProtectionLevelCmdData").field("ProtType", &self.ProtType).field("ProtLevel", &self.ProtLevel).field("ExtendedInfoChangeMask", &self.ExtendedInfoChangeMask).field("ExtendedInfoData", &self.ExtendedInfoData).finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPSetProtectionLevelCmdData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPSetProtectionLevelCmdData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPSetProtectionLevelCmdData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPSetProtectionLevelCmdData {}
impl ::core::default::Default for DXVA_COPPSetProtectionLevelCmdData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const DXVA_COPPSetSignaling: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x09a631a5_d684_4c60_8e4d_d3bb0f0be3ee);
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPSetSignalingCmdData {
    pub ActiveTVProtectionStandard: u32,
    pub AspectRatioChangeMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioChangeMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioChangeMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoChangeMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
    pub Reserved: u32,
}
impl ::core::marker::Copy for DXVA_COPPSetSignalingCmdData {}
impl ::core::clone::Clone for DXVA_COPPSetSignalingCmdData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPSetSignalingCmdData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPSetSignalingCmdData")
            .field("ActiveTVProtectionStandard", &self.ActiveTVProtectionStandard)
            .field("AspectRatioChangeMask1", &self.AspectRatioChangeMask1)
            .field("AspectRatioData1", &self.AspectRatioData1)
            .field("AspectRatioChangeMask2", &self.AspectRatioChangeMask2)
            .field("AspectRatioData2", &self.AspectRatioData2)
            .field("AspectRatioChangeMask3", &self.AspectRatioChangeMask3)
            .field("AspectRatioData3", &self.AspectRatioData3)
            .field("ExtendedInfoChangeMask", &self.ExtendedInfoChangeMask)
            .field("ExtendedInfoData", &self.ExtendedInfoData)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPSetSignalingCmdData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPSetSignalingCmdData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPSetSignalingCmdData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPSetSignalingCmdData {}
impl ::core::default::Default for DXVA_COPPSetSignalingCmdData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPStatusData {
    pub rApp: ::windows::core::GUID,
    pub dwFlags: u32,
    pub dwData: u32,
    pub ExtendedInfoValidMask: u32,
    pub ExtendedInfoData: u32,
}
impl ::core::marker::Copy for DXVA_COPPStatusData {}
impl ::core::clone::Clone for DXVA_COPPStatusData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPStatusData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPStatusData").field("rApp", &self.rApp).field("dwFlags", &self.dwFlags).field("dwData", &self.dwData).field("ExtendedInfoValidMask", &self.ExtendedInfoValidMask).field("ExtendedInfoData", &self.ExtendedInfoData).finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPStatusData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPStatusData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPStatusData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPStatusData {}
impl ::core::default::Default for DXVA_COPPStatusData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPStatusDisplayData {
    pub rApp: ::windows::core::GUID,
    pub dwFlags: u32,
    pub DisplayWidth: u32,
    pub DisplayHeight: u32,
    pub Format: u32,
    pub d3dFormat: u32,
    pub FreqNumerator: u32,
    pub FreqDenominator: u32,
}
impl ::core::marker::Copy for DXVA_COPPStatusDisplayData {}
impl ::core::clone::Clone for DXVA_COPPStatusDisplayData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPStatusDisplayData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPStatusDisplayData").field("rApp", &self.rApp).field("dwFlags", &self.dwFlags).field("DisplayWidth", &self.DisplayWidth).field("DisplayHeight", &self.DisplayHeight).field("Format", &self.Format).field("d3dFormat", &self.d3dFormat).field("FreqNumerator", &self.FreqNumerator).field("FreqDenominator", &self.FreqDenominator).finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPStatusDisplayData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPStatusDisplayData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPStatusDisplayData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPStatusDisplayData {}
impl ::core::default::Default for DXVA_COPPStatusDisplayData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPStatusHDCPKeyData {
    pub rApp: ::windows::core::GUID,
    pub dwFlags: u32,
    pub dwHDCPFlags: u32,
    pub BKey: ::windows::core::GUID,
    pub Reserved1: ::windows::core::GUID,
    pub Reserved2: ::windows::core::GUID,
}
impl ::core::marker::Copy for DXVA_COPPStatusHDCPKeyData {}
impl ::core::clone::Clone for DXVA_COPPStatusHDCPKeyData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPStatusHDCPKeyData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPStatusHDCPKeyData").field("rApp", &self.rApp).field("dwFlags", &self.dwFlags).field("dwHDCPFlags", &self.dwHDCPFlags).field("BKey", &self.BKey).field("Reserved1", &self.Reserved1).field("Reserved2", &self.Reserved2).finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPStatusHDCPKeyData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPStatusHDCPKeyData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPStatusHDCPKeyData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPStatusHDCPKeyData {}
impl ::core::default::Default for DXVA_COPPStatusHDCPKeyData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DXVA_COPPStatusSignalingCmdData {
    pub rApp: ::windows::core::GUID,
    pub dwFlags: u32,
    pub AvailableTVProtectionStandards: u32,
    pub ActiveTVProtectionStandard: u32,
    pub TVType: u32,
    pub AspectRatioValidMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioValidMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioValidMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoValidMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
}
impl ::core::marker::Copy for DXVA_COPPStatusSignalingCmdData {}
impl ::core::clone::Clone for DXVA_COPPStatusSignalingCmdData {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DXVA_COPPStatusSignalingCmdData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DXVA_COPPStatusSignalingCmdData")
            .field("rApp", &self.rApp)
            .field("dwFlags", &self.dwFlags)
            .field("AvailableTVProtectionStandards", &self.AvailableTVProtectionStandards)
            .field("ActiveTVProtectionStandard", &self.ActiveTVProtectionStandard)
            .field("TVType", &self.TVType)
            .field("AspectRatioValidMask1", &self.AspectRatioValidMask1)
            .field("AspectRatioData1", &self.AspectRatioData1)
            .field("AspectRatioValidMask2", &self.AspectRatioValidMask2)
            .field("AspectRatioData2", &self.AspectRatioData2)
            .field("AspectRatioValidMask3", &self.AspectRatioValidMask3)
            .field("AspectRatioData3", &self.AspectRatioData3)
            .field("ExtendedInfoValidMask", &self.ExtendedInfoValidMask)
            .field("ExtendedInfoData", &self.ExtendedInfoData)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for DXVA_COPPStatusSignalingCmdData {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DXVA_COPPStatusSignalingCmdData {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DXVA_COPPStatusSignalingCmdData>()) == 0 }
    }
}
impl ::core::cmp::Eq for DXVA_COPPStatusSignalingCmdData {}
impl ::core::default::Default for DXVA_COPPStatusSignalingCmdData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DCCMD_SURFACE_BUFFER: u32 = 12u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DEBLOCKING_CONTROL_BUFFER: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DEBLOCKING_FILTER_FUNCTION: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DPXD_SURFACE_BUFFER: u32 = 10u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DeinterlaceBltExFnCode: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DeinterlaceBltFnCode: u32 = 1u32;
pub const DXVA_DeinterlaceBobDevice: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x335aa36e_7884_43a4_9c91_7f87faf3e37e);
pub const DXVA_DeinterlaceContainerDevice: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0e85cb93_3046_4ff0_aecc_d58cb5f035fd);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DeinterlaceQueryAvailableModesFnCode: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_DeinterlaceQueryModeCapsFnCode: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL: u32 = 16776968u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_HOST: u32 = 16776960u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SIGNIF: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_EXECUTE_RETURN_OK: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ExtColorData_ShiftBase: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_FILM_GRAIN_BUFFER: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_FILM_GRAIN_SYNTHESIS_FUNCTION: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_HIGHLIGHT_BUFFER: u32 = 11u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_IA44_SURFACE_BUFFER: u32 = 9u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_MACROBLOCK_CONTROL_BUFFER: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_MOTION_VECTOR_BUFFER: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H261: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2: u32 = 0u32;
pub const DXVA_ModeAV1_VLD_12bit_Profile2: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x17127009_a00f_4ce1_994e_bf4081f6f3f0);
pub const DXVA_ModeAV1_VLD_12bit_Profile2_420: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d80bed6_9cac_4835_9e91_327bbc4f9ee8);
pub const DXVA_ModeAV1_VLD_Profile0: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8be4ccb_cf53_46ba_8d59_d6b8a6da5d2a);
pub const DXVA_ModeAV1_VLD_Profile1: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6936ff0f_45b1_4163_9cc1_646ef6946108);
pub const DXVA_ModeAV1_VLD_Profile2: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c5f2aa1_e541_4089_bb7b_98110a19d7c8);
pub const DXVA_ModeH261_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be01_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH261_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be02_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be03_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be04_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_C: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be05_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be06_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_E: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be07_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_F: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be08_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be64_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be65_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_C: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be66_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be67_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_E: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be68_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_F: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be69_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_VLD_Multiview_NoFGT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x705b9d82_76cf_49d6_b7e6_ac8872db013c);
pub const DXVA_ModeH264_VLD_Stereo_NoFGT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf9aaccbb_c2b6_4cfc_8779_5707b1760552);
pub const DXVA_ModeH264_VLD_Stereo_Progressive_NoFGT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd79be8da_0cf1_4c81_b82a_69a4e236f43d);
pub const DXVA_ModeH264_VLD_WithFMOASO_NoFGT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd5f04ff9_3418_45d8_9561_32a76aae2ddd);
pub const DXVA_ModeHEVC_VLD_Main: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5b11d51b_2f4c_4452_bcc3_09f2a1160cc0);
pub const DXVA_ModeHEVC_VLD_Main10: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x107af0e0_ef1a_4d19_aba8_67a163073d13);
pub const DXVA_ModeMPEG1_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be09_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG1_VLD: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6f3ec719_3735_42cc_8063_65cc3cb36616);
pub const DXVA_ModeMPEG2_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be0a_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be0b_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_C: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be0c_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be0d_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2and1_VLD: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x86695f12_340e_4f04_9fd3_9253dd327460);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_GMC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab998b5b_4258_44a9_9feb_94e597a6baae);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_NoGMC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xed418a9f_010d_4eda_9ae3_9a65358d8d2e);
pub const DXVA_ModeMPEG4pt2_VLD_Simple: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefd64d74_c9e8_41d7_a5e9_e9b0e39fa319);
pub const DXVA_ModeNone: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be00_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bea0_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bea1_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_C: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bea2_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bea3_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_D2010: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bea4_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVP8_VLD: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90b899ea_3a62_4705_88b3_8df04b2744e7);
pub const DXVA_ModeVP9_VLD_10bit_Profile2: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa4c749ef_6ecf_48aa_8448_50a7a1165ff7);
pub const DXVA_ModeVP9_VLD_Profile0: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x463707f8_a1d0_4585_876d_83aa6d60b89e);
pub const DXVA_ModeWMV8_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be80_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV8_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be81_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_A: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be90_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_B: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be91_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_C: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81be94_a0c7_11d3_b984_00c04f2e73c5);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_NUM_TYPES_COMP_BUFFERS: u32 = 18u32;
pub const DXVA_NoEncrypt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b81bed0_a0c7_11d3_b984_00c04f2e73c5);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_off: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_on: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_NumMV_OBMC_on__BinPB_off: u32 = 10u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_NumMV_OBMC_on__BinPB_on: u32 = 11u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_DECODE_BUFFER: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_DECODING_FUNCTION: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_RESAMPLE_BUFFER: u32 = 14u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_RESAMPLE_FUNCTION: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_STRUCTURE_BOTTOM_FIELD: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_STRUCTURE_FRAME: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_PICTURE_STRUCTURE_TOP_FIELD: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ProcAmpControlBltFnCode: u32 = 1u32;
pub const DXVA_ProcAmpControlDevice: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f200913_2ffd_4056_9f1e_e1b508f22dcf);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ProcAmpControlQueryCapsFnCode: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_ProcAmpControlQueryRangeFnCode: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_FALSE_PLUS: u32 = 16777215u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_OK_COPY: u32 = 16777212u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS: u32 = 16777211u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_COPY: u32 = 16777208u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_PLUS: u32 = 16777209u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY: u32 = 16777205u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_PROBE_QUERY: u32 = 16777201u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_READ_BACK_BUFFER: u32 = 15u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESIDUAL_DIFFERENCE_BUFFER: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H261_A: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H261_B: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_A: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_B: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_C: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_D: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_E: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H263_F: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_A: u32 = 100u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_B: u32 = 101u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_C: u32 = 102u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_D: u32 = 103u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_E: u32 = 104u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_F: u32 = 105u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_IDCT_FGT: u32 = 103u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_IDCT_NOFGT: u32 = 102u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_FGT: u32 = 101u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_NOFGT: u32 = 100u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_FGT: u32 = 105u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_MULTIVIEW_NOFGT: u32 = 115u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_NOFGT: u32 = 104u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_NOFGT: u32 = 114u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: u32 = 113u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_WITHFMOASO_NOFGT: u32 = 112u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG1_A: u32 = 9u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG1_VLD: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_A: u32 = 10u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_B: u32 = 11u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_C: u32 = 12u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_D: u32 = 13u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG2and1_VLD: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_GMC: u32 = 178u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_NOGMC: u32 = 177u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_SIMPLE: u32 = 176u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_UNRESTRICTED: u32 = 65535u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_A: u32 = 160u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_B: u32 = 161u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_C: u32 = 162u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_D: u32 = 163u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_D2010: u32 = 164u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_IDCT: u32 = 162u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_MOCOMP: u32 = 161u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_POSTPROC: u32 = 160u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_VC1_VLD: u32 = 163u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV8_A: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV8_B: u32 = 129u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV8_MOCOMP: u32 = 129u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV8_POSTPROC: u32 = 128u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_A: u32 = 144u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_B: u32 = 145u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_C: u32 = 148u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_IDCT: u32 = 148u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_MOCOMP: u32 = 145u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_RESTRICTED_MODE_WMV9_POSTPROC: u32 = 144u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_SCAN_METHOD_ALTERNATE_HORIZONTAL: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_SCAN_METHOD_ALTERNATE_VERTICAL: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_SCAN_METHOD_ARBITRARY: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_SCAN_METHOD_ZIG_ZAG: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_SLICE_CONTROL_BUFFER: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_STATUS_REPORTING_FUNCTION: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_USUAL_BLOCK_HEIGHT: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DXVA_USUAL_BLOCK_WIDTH: u32 = 8u32;
pub const DigitalCableLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x03c06416_d127_407a_ab4c_fdd279abbe5d);
pub const DigitalCableTuneRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x26ec0b63_aa90_458a_8df4_5659f2c8a18a);
pub const DigitalCableTuningSpace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd9bb4cee_b87a_47f1_ac92_b08d9c7813fc);
pub const DigitalLocator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6e50cc0d_c19b_4bf6_810b_5bd60761f5cc);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DisplaySizeList = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslDefaultSize: DisplaySizeList = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslSourceSize: DisplaySizeList = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslHalfSourceSize: DisplaySizeList = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslDoubleSourceSize: DisplaySizeList = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslFullScreen: DisplaySizeList = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslHalfScreen: DisplaySizeList = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslQuarterScreen: DisplaySizeList = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const dslSixteenthScreen: DisplaySizeList = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type DownResEventParam = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DOWNRES_Always: DownResEventParam = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DOWNRES_InWindowOnly: DownResEventParam = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const DOWNRES_Undefined: DownResEventParam = 2i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct DualMonoInfo {
    pub LangID1: u16,
    pub LangID2: u16,
    pub lISOLangCode1: i32,
    pub lISOLangCode2: i32,
}
impl ::core::marker::Copy for DualMonoInfo {}
impl ::core::clone::Clone for DualMonoInfo {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DualMonoInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DualMonoInfo").field("LangID1", &self.LangID1).field("LangID2", &self.LangID2).field("lISOLangCode1", &self.lISOLangCode1).field("lISOLangCode2", &self.lISOLangCode2).finish()
    }
}
unsafe impl ::windows::core::Abi for DualMonoInfo {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DualMonoInfo {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DualMonoInfo>()) == 0 }
    }
}
impl ::core::cmp::Eq for DualMonoInfo {}
impl ::core::default::Default for DualMonoInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DvbParentalRatingDescriptor {
    pub ulNumParams: u32,
    pub pParams: [DvbParentalRatingParam; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DvbParentalRatingDescriptor {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DvbParentalRatingDescriptor {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DvbParentalRatingDescriptor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DvbParentalRatingDescriptor").field("ulNumParams", &self.ulNumParams).field("pParams", &self.pParams).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DvbParentalRatingDescriptor {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DvbParentalRatingDescriptor {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DvbParentalRatingDescriptor>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DvbParentalRatingDescriptor {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DvbParentalRatingDescriptor {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DvbParentalRatingParam {
    pub szCountryCode: [super::super::Foundation::CHAR; 4],
    pub bRating: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DvbParentalRatingParam {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DvbParentalRatingParam {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DvbParentalRatingParam {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DvbParentalRatingParam").field("szCountryCode", &self.szCountryCode).field("bRating", &self.bRating).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DvbParentalRatingParam {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DvbParentalRatingParam {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DvbParentalRatingParam>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DvbParentalRatingParam {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DvbParentalRatingParam {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct EALocationCodeType {
    pub LocationCodeScheme: LocationCodeSchemeType,
    pub state_code: u8,
    pub county_subdivision: u8,
    pub county_code: u16,
}
impl ::core::marker::Copy for EALocationCodeType {}
impl ::core::clone::Clone for EALocationCodeType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for EALocationCodeType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("EALocationCodeType").field("LocationCodeScheme", &self.LocationCodeScheme).field("state_code", &self.state_code).field("county_subdivision", &self.county_subdivision).field("county_code", &self.county_code).finish()
    }
}
unsafe impl ::windows::core::Abi for EALocationCodeType {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EALocationCodeType {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EALocationCodeType>()) == 0 }
    }
}
impl ::core::cmp::Eq for EALocationCodeType {}
impl ::core::default::Default for EALocationCodeType {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const ECHOSTAR_SATELLITE_TV_NETWORK_TYPE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4f6b31b_c6bf_4759_886f_a7386dca27a0);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_ACTIVATE: u32 = 19u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_BANDWIDTHCHANGE: u32 = 72u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_BUFFERING_DATA: u32 = 17u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_BUILT: u32 = 768u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_CLOCK_CHANGED: u32 = 13u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_CLOCK_UNSET: u32 = 81u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_CODECAPI_EVENT: u32 = 87u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_COMPLETE: u32 = 1u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_CONTENTPROPERTY_CHANGED: u32 = 71u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DEVICE_LOST: u32 = 31u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DISPLAY_CHANGED: u32 = 22u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVDBASE: u32 = 256u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_ANGLES_AVAILABLE: u32 = 275u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_ANGLE_CHANGE: u32 = 262u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_AUDIO_STREAM_CHANGE: u32 = 260u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_BUTTON_AUTO_ACTIVATED: u32 = 277u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_BUTTON_CHANGE: u32 = 263u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_BeginNavigationCommands: u32 = 291u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CHAPTER_AUTOSTOP: u32 = 270u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CHAPTER_START: u32 = 259u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CMD_END: u32 = 279u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CMD_START: u32 = 278u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CURRENT_HMSF_TIME: u32 = 282u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_CURRENT_TIME: u32 = 267u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_DISC_EJECTED: u32 = 280u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_DISC_INSERTED: u32 = 281u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_DOMAIN_CHANGE: u32 = 257u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_ERROR: u32 = 268u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_GPRM_Change: u32 = 289u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_KARAOKE_MODE: u32 = 283u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_NO_FP_PGC: u32 = 271u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_NavigationCommand: u32 = 292u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PARENTAL_LEVEL_CHANGE: u32 = 273u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PLAYBACK_RATE_CHANGE: u32 = 272u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PLAYBACK_STOPPED: u32 = 274u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PLAYPERIOD_AUTOSTOP: u32 = 276u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PROGRAM_CELL_CHANGE: u32 = 284u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_PROGRAM_CHAIN_CHANGE: u32 = 286u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_SPRM_Change: u32 = 290u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_STILL_OFF: u32 = 266u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_STILL_ON: u32 = 265u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_SUBPICTURE_STREAM_CHANGE: u32 = 261u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_TITLE_CHANGE: u32 = 258u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_TITLE_SET_CHANGE: u32 = 285u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_VALID_UOPS_CHANGE: u32 = 264u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_VOBU_Offset: u32 = 287u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_VOBU_Timestamp: u32 = 288u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_DVD_WARNING: u32 = 269u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_END_OF_SEGMENT: u32 = 28u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_EOS_SOON: u32 = 70u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_ERRORABORT: u32 = 3u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_ERRORABORTEX: u32 = 69u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_ERROR_STILLPLAYING: u32 = 8u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_EXTDEVICE_MODE_CHANGE: u32 = 49u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_FILE_CLOSED: u32 = 68u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_FULLSCREEN_LOST: u32 = 18u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_GRAPH_CHANGED: u32 = 80u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_LENGTH_CHANGED: u32 = 30u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_LOADSTATUS: u32 = 67u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_MARKER_HIT: u32 = 66u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_NEED_RESTART: u32 = 20u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_NEW_PIN: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_NOTIFY_WINDOW: u32 = 25u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_OLE_EVENT: u32 = 24u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_OPENING_FILE: u32 = 16u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_PALETTE_CHANGED: u32 = 9u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_PAUSED: u32 = 14u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_PLEASE_REOPEN: u32 = 64u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_PREPROCESS_COMPLETE: u32 = 86u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_PROCESSING_LATENCY: u32 = 33u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_QUALITY_CHANGE: u32 = 11u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_RENDER_FINISHED: u32 = 33u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_REPAINT: u32 = 5u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SAMPLE_LATENCY: u32 = 34u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SAMPLE_NEEDED: u32 = 32u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SCRUB_TIME: u32 = 35u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SEGMENT_STARTED: u32 = 29u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SHUTTING_DOWN: u32 = 12u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SKIP_FRAMES: u32 = 37u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SNDDEV_IN_ERROR: u32 = 512u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SNDDEV_OUT_ERROR: u32 = 513u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SND_DEVICE_ERROR_BASE: u32 = 512u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STARVATION: u32 = 23u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STATE_CHANGE: u32 = 50u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STATUS: u32 = 65u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STEP_COMPLETE: u32 = 36u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STREAM_CONTROL_STARTED: u32 = 27u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STREAM_CONTROL_STOPPED: u32 = 26u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STREAM_ERROR_STILLPLAYING: u32 = 7u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_STREAM_ERROR_STOPPED: u32 = 6u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_SYSTEMBASE: u32 = 0u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_TIME: u32 = 4u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_TIMECODE_AVAILABLE: u32 = 48u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_UNBUILT: u32 = 769u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_USER: u32 = 32768u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_USERABORT: u32 = 2u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_VIDEOFRAMEREADY: u32 = 73u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_VIDEO_SIZE_CHANGED: u32 = 10u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_VMR_RECONNECTION_FAILED: u32 = 85u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_VMR_RENDERDEVICE_SET: u32 = 83u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_VMR_SURFACE_FLIPPED: u32 = 84u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_WINDOW_DESTROYED: u32 = 21u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_WMT_EVENT: u32 = 594u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_WMT_EVENT_BASE: u32 = 593u32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EC_WMT_INDEX_EVENT: u32 = 593u32;
pub const ESEventFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8e8a07da_71f8_40c1_a929_5e3a868ac2c6);
pub const ESEventService: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc20447fc_ec60_475e_813f_d2b0a6decefe);
pub const ETFilter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4f1_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ARIBcontentSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3a954083_93d0_463e_90b2_0742c496edf0);
pub const EVENTID_AudioDescriptorSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x107bd41c_a6da_4691_8369_11b2cdaa288e);
pub const EVENTID_AudioTypeSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x501cbfbe_b849_42ce_9be9_3db869fb82b3);
pub const EVENTID_BDAConditionalAccessTAG: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefc3a459_ae8b_4b4a_8fe9_79a0d097f3ea);
pub const EVENTID_BDAEventingServicePendingEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5ca51711_5ddc_41a6_9430_e41b8b3bbc5b);
pub const EVENTID_BDA_CASBroadcastMMI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x676876f0_1132_404c_a7ca_e72069a9d54f);
pub const EVENTID_BDA_CASCloseMMI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d0f550f_de2e_479d_8345_ec0e9557e8a2);
pub const EVENTID_BDA_CASOpenMMI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x85dac915_e593_410d_8471_d6812105f28e);
pub const EVENTID_BDA_CASReleaseTuner: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x20c1a16b_441f_49a5_bb5c_e9a04495c6c1);
pub const EVENTID_BDA_CASRequestTuner: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcf39a9d8_f5d3_4685_be57_ed81dba46b27);
pub const EVENTID_BDA_DiseqCResponseAvailable: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefa628f8_1f2c_4b67_9ea5_acf6fa9a1f36);
pub const EVENTID_BDA_EncoderSignalLock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5ec90eb9_39fa_4cfc_b93f_00bb11077f5e);
pub const EVENTID_BDA_FdcStatus: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x05f25366_d0eb_43d2_bc3c_682b863df142);
pub const EVENTID_BDA_FdcTableSection: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6a0cd757_4ce3_4e5b_9444_7187b87152c5);
pub const EVENTID_BDA_GPNVValueUpdate: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xff75c68c_f416_4e7e_bf17_6d55c5df1575);
pub const EVENTID_BDA_GuideDataAvailable: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x98db717a_478a_4cd4_92d0_95f66b89e5b1);
pub const EVENTID_BDA_GuideDataError: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xac33c448_6f73_4fd7_b341_594c360d8d74);
pub const EVENTID_BDA_GuideServiceInformationUpdated: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa1c3ea2b_175f_4458_b735_507d22db23a6);
pub const EVENTID_BDA_IsdbCASResponse: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd4cb1966_41bc_4ced_9a20_fdceac78f70d);
pub const EVENTID_BDA_LbigsCloseConnectionHandle: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2f08b99_65ef_4314_9671_e99d4cce0bae);
pub const EVENTID_BDA_LbigsOpenConnection: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x356207b2_6f31_4eb0_a271_b3fa6bb7680f);
pub const EVENTID_BDA_LbigsSendData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1123277b_f1c6_4154_8b0d_48e6157059aa);
pub const EVENTID_BDA_RatingPinReset: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e048c0_c574_4c26_bcda_2f4d35eb5e85);
pub const EVENTID_BDA_TransprtStreamSelectorInfo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc40f9f85_09d0_489c_9e9c_0abbb56951b0);
pub const EVENTID_BDA_TunerNoSignal: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe29b382b_1edd_4930_bc46_682fd72d2dfb);
pub const EVENTID_BDA_TunerSignalLock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1872e740_f573_429b_a00e_d9c1e408af09);
pub const EVENTID_BDA_UpdateDrmStatus: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x65a6f681_1462_473b_88ce_cb731427bdb5);
pub const EVENTID_BDA_UpdateScanState: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55702b50_7b49_42b8_a82f_4afb691b0628);
pub const EVENTID_CADenialCountChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a65c528_2249_4070_ac16_00390cdfb2dd);
pub const EVENTID_CASFailureSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xead831ae_5529_4d1f_afce_0d8cd1257d30);
pub const EVENTID_CSDescriptorSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefe779d9_97f0_4786_800d_95cf505ddc66);
pub const EVENTID_CandidatePostTuneData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f02d3d0_9f06_4369_9f1e_3ad6ca19807e);
pub const EVENTID_CardStatusChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa265faea_f874_4b38_9ff7_c53d02969996);
pub const EVENTID_ChannelChangeSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9067c5e5_4c5c_4205_86c8_7afe20fe1efa);
pub const EVENTID_ChannelInfoSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x41f36d80_4132_4cc2_b121_01a43219d81b);
pub const EVENTID_ChannelTypeSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x72ab1d51_87d2_489b_ba11_0e08dc210243);
pub const EVENTID_CtxADescriptorSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3ab4a2e6_4247_4b34_896c_30afa5d21c24);
pub const EVENTID_DFNWithNoActualAVData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf5689ffe_55f9_4bb3_96be_ae971c63bae0);
pub const EVENTID_DRMParingStatusChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000906f5_f0d1_41d6_a7df_4028697669f6);
pub const EVENTID_DRMParingStepComplete: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5b2ebf78_b752_4420_b41e_a472dc95828e);
pub const EVENTID_DTFilterCOPPBlock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4ea_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterCOPPUnblock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e8_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterDataFormatFailure: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4ed_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterDataFormatOK: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4ec_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingChange: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e2_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingsBlock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e3_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingsUnblock: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e4_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterXDSPacket: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e5_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DVBScramblingControlSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4bd4e1c4_90a1_4109_8236_27f00e7dcc5b);
pub const EVENTID_DemultiplexerFilterDiscontinuity: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x16155770_aed5_475c_bb98_95a33070df0c);
pub const EVENTID_DualMonoSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa9a29b56_a84b_488c_89d5_0d4e7657c8ce);
pub const EVENTID_DvbParentalRatingDescriptor: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a67a58d_eca5_4eac_abcb_e734d3776d0a);
pub const EVENTID_EASMessageReceived: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd10df9d5_c261_4b85_9e8a_517b3299cab2);
pub const EVENTID_ETDTFilterLicenseFailure: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4ef_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETDTFilterLicenseOK: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4ee_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterCopyNever: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4f0_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterCopyOnce: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4eb_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterEncryptionOff: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e7_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterEncryptionOn: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e6_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_EmmMessageSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bf00268_4f7e_4294_aa87_e9e953e43f14);
pub const EVENTID_EncDecFilterError: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e9_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_EncDecFilterEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4a1b465b_0fb9_4159_afbd_e33006a0f9f4);
pub const EVENTID_EntitlementChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9071ad5d_2359_4c95_8694_afa81d70bfd5);
pub const EVENTID_FormatNotSupportedEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24b2280a_b2aa_4777_bf65_63f35e7b024a);
pub const EVENTID_LanguageSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe292666d_9c02_448d_aa8d_781a93fdc395);
pub const EVENTID_MMIMessage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x052c29af_09a4_4b93_890f_bd6a348968a4);
pub const EVENTID_NewSignalAcquired: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc87ec52d_cd18_404a_a076_c02a273d3de7);
pub const EVENTID_PBDAParentalControlEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf947aa85_fb52_48e8_b9c5_e1e1f411a51a);
pub const EVENTID_PIDListSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x47fc8f65_e2bb_4634_9cef_fdbfe6261d5c);
pub const EVENTID_PSITable: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b9c3703_d447_4e16_97bb_01799fc031ed);
pub const EVENTID_RRTSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf6cfc8f4_da93_4f2f_bff8_ba1ee6fca3a2);
pub const EVENTID_SBE2RecControlStarted: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8966a89e_f83e_4c0e_bc3b_bfa7649e04cb);
pub const EVENTID_SBE2RecControlStopped: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x454b1ec8_0c9b_4caa_b1a1_1e7a2666f6c3);
pub const EVENTID_STBChannelNumber: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x17c4d730_d0f0_413a_8c99_500469de35ad);
pub const EVENTID_ServiceTerminated: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0a1d591c_e0d2_4f8e_8960_2335bef45ccb);
pub const EVENTID_SignalAndServiceStatusSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8068c5cb_3c04_492b_b47d_0308820dce51);
pub const EVENTID_SignalStatusChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d9cfaf2_702d_4b01_8dff_6892ad20d191);
pub const EVENTID_StreamIDSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcaf1ab68_e153_4d41_a6b3_a7c998db75ee);
pub const EVENTID_StreamTypeSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82af2ebc_30a6_4264_a80b_ad2e1372ac60);
pub const EVENTID_SubtitleSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5dcec048_d0b9_4163_872c_4f32223be88a);
pub const EVENTID_TeletextSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9599d950_5f33_4617_af7c_1e54b510daa3);
pub const EVENTID_TuneFailureEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd97287b2_2dfd_436a_9485_99d7d4ab5a69);
pub const EVENTID_TuneFailureSpanningEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6f8aa455_5ee1_48ab_a27c_4c8d70b9aeba);
pub const EVENTID_TuningChanged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9d7e6235_4b7d_425d_a6d1_d717c33b9c4c);
pub const EVENTID_TuningChanging: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x83183c03_c09e_45c4_a719_807a94952bf9);
pub const EVENTID_XDSCodecDuplicateXDSRating: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4df_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_XDSCodecNewXDSPacket: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e1_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_XDSCodecNewXDSRating: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4e0_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTTYPE_CASDescrambleFailureEvent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2127d42_7be5_4f4b_9130_6679899f4f4b);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const E_PROP_ID_UNSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147023728i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const E_PROP_SET_UNSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147023726i32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTag_Mode = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EnTag_Remove: EnTag_Mode = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EnTag_Once: EnTag_Mode = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const EnTag_Repeat: EnTag_Mode = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_CAE_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_Exempt: EnTvRat_CAE_TV = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_C: EnTvRat_CAE_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_C8: EnTvRat_CAE_TV = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_G: EnTvRat_CAE_TV = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_PG: EnTvRat_CAE_TV = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_14: EnTvRat_CAE_TV = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_18: EnTvRat_CAE_TV = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAE_TV_Reserved: EnTvRat_CAE_TV = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_CAF_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_Exempt: EnTvRat_CAF_TV = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_G: EnTvRat_CAF_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_8: EnTvRat_CAF_TV = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_13: EnTvRat_CAF_TV = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_16: EnTvRat_CAF_TV = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_18: EnTvRat_CAF_TV = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_Reserved6: EnTvRat_CAF_TV = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const CAF_TV_Reserved: EnTvRat_CAF_TV = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_GenericLevel = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_0: EnTvRat_GenericLevel = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_1: EnTvRat_GenericLevel = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_2: EnTvRat_GenericLevel = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_3: EnTvRat_GenericLevel = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_4: EnTvRat_GenericLevel = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_5: EnTvRat_GenericLevel = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_6: EnTvRat_GenericLevel = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_7: EnTvRat_GenericLevel = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_8: EnTvRat_GenericLevel = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_9: EnTvRat_GenericLevel = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_10: EnTvRat_GenericLevel = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_11: EnTvRat_GenericLevel = 11i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_12: EnTvRat_GenericLevel = 12i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_13: EnTvRat_GenericLevel = 13i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_14: EnTvRat_GenericLevel = 14i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_15: EnTvRat_GenericLevel = 15i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_16: EnTvRat_GenericLevel = 16i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_17: EnTvRat_GenericLevel = 17i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_18: EnTvRat_GenericLevel = 18i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_19: EnTvRat_GenericLevel = 19i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_20: EnTvRat_GenericLevel = 20i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_21: EnTvRat_GenericLevel = 21i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_kLevels: EnTvRat_GenericLevel = 22i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_Unblock: EnTvRat_GenericLevel = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_LevelDontKnow: EnTvRat_GenericLevel = 255i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_MPAA = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_NotApplicable: EnTvRat_MPAA = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_G: EnTvRat_MPAA = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_PG: EnTvRat_MPAA = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_PG13: EnTvRat_MPAA = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_R: EnTvRat_MPAA = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_NC17: EnTvRat_MPAA = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_X: EnTvRat_MPAA = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA_NotRated: EnTvRat_MPAA = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_System = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const MPAA: EnTvRat_System = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV: EnTvRat_System = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Canadian_English: EnTvRat_System = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Canadian_French: EnTvRat_System = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Reserved4: EnTvRat_System = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const System5: EnTvRat_System = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const System6: EnTvRat_System = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Reserved7: EnTvRat_System = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const PBDA: EnTvRat_System = 8i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const AgeBased: EnTvRat_System = 9i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_kSystems: EnTvRat_System = 10i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TvRat_SystemDontKnow: EnTvRat_System = 255i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EnTvRat_US_TV = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_None: EnTvRat_US_TV = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_Y: EnTvRat_US_TV = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_Y7: EnTvRat_US_TV = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_G: EnTvRat_US_TV = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_PG: EnTvRat_US_TV = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_14: EnTvRat_US_TV = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_MA: EnTvRat_US_TV = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const US_TV_None7: EnTvRat_US_TV = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EncDecEvents = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ENCDEC_CPEVENT: EncDecEvents = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const ENCDEC_RECORDING_STATUS: EncDecEvents = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type EntitlementType = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const Entitled: EntitlementType = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const NotEntitled: EntitlementType = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const TechnicalFailure: EntitlementType = 2i32;
pub const EvalRat: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc5c5c5f1_3abc_11d6_b25b_00c04fa0c026);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type FECMethod = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_METHOD_NOT_SET: FECMethod = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_METHOD_NOT_DEFINED: FECMethod = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_VITERBI: FECMethod = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_RS_204_188: FECMethod = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_LDPC: FECMethod = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_BCH: FECMethod = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_RS_147_130: FECMethod = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_FEC_MAX: FECMethod = 6i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub struct FILTER_INFO {
    pub achName: [u16; 128],
    pub pGraph: ::core::option::Option<IFilterGraph>,
}
impl ::core::clone::Clone for FILTER_INFO {
    fn clone(&self) -> Self {
        Self { achName: self.achName, pGraph: self.pGraph.clone() }
    }
}
impl ::core::fmt::Debug for FILTER_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FILTER_INFO").field("achName", &self.achName).field("pGraph", &self.pGraph).finish()
    }
}
unsafe impl ::windows::core::Abi for FILTER_INFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
impl ::core::cmp::PartialEq for FILTER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.achName == other.achName && self.pGraph == other.pGraph
    }
}
impl ::core::cmp::Eq for FILTER_INFO {}
impl ::core::default::Default for FILTER_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type FILTER_STATE = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const State_Stopped: FILTER_STATE = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const State_Paused: FILTER_STATE = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const State_Running: FILTER_STATE = 2i32;
pub const FORMATTYPE_CPFilters_Processed: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6739b36f_1d5f_4ac2_8192_28bb0e73d16a);
pub const FORMATTYPE_ETDTFilter_Tagged: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4c4c4d1_0049_4e2b_98fb_9537f6ce516d);
pub const FilgraphManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe436ebb3_524f_11ce_9f53_0020af0ba770);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type FormatNotSupportedEvents = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const FORMATNOTSUPPORTED_CLEAR: FormatNotSupportedEvents = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const FORMATNOTSUPPORTED_NOTSUPPORTED: FormatNotSupportedEvents = 1i32;
pub const GUID_TIME_MUSIC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0574c49d_5b04_4b15_a542_ae282030117b);
pub const GUID_TIME_REFERENCE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x93ad712b_daa0_4ffe_bc81_b0ce500fcdd9);
pub const GUID_TIME_SAMPLES: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa8593d05_0c43_4984_9a63_97af9e02c4c0);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type GuardInterval = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_NOT_SET: GuardInterval = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_NOT_DEFINED: GuardInterval = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_1_32: GuardInterval = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_1_16: GuardInterval = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_1_8: GuardInterval = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_1_4: GuardInterval = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_1_128: GuardInterval = 5i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_19_128: GuardInterval = 6i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_19_256: GuardInterval = 7i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_GUARD_MAX: GuardInterval = 8i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio'*"]
#[cfg(feature = "Win32_Media_Audio")]
pub struct HEAACWAVEFORMAT {
    pub wfInfo: HEAACWAVEINFO,
    pub pbAudioSpecificConfig: [u8; 1],
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::marker::Copy for HEAACWAVEFORMAT {}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::clone::Clone for HEAACWAVEFORMAT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Media_Audio")]
unsafe impl ::windows::core::Abi for HEAACWAVEFORMAT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::cmp::PartialEq for HEAACWAVEFORMAT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HEAACWAVEFORMAT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::cmp::Eq for HEAACWAVEFORMAT {}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::default::Default for HEAACWAVEFORMAT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio'*"]
#[cfg(feature = "Win32_Media_Audio")]
pub struct HEAACWAVEINFO {
    pub wfx: super::Audio::WAVEFORMATEX,
    pub wPayloadType: u16,
    pub wAudioProfileLevelIndication: u16,
    pub wStructType: u16,
    pub wReserved1: u16,
    pub dwReserved2: u32,
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::marker::Copy for HEAACWAVEINFO {}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::clone::Clone for HEAACWAVEINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Media_Audio")]
unsafe impl ::windows::core::Abi for HEAACWAVEINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::cmp::PartialEq for HEAACWAVEINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HEAACWAVEINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::cmp::Eq for HEAACWAVEINFO {}
#[cfg(feature = "Win32_Media_Audio")]
impl ::core::default::Default for HEAACWAVEINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub type HierarchyAlpha = i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_NOT_SET: HierarchyAlpha = -1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_NOT_DEFINED: HierarchyAlpha = 0i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_1: HierarchyAlpha = 1i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_2: HierarchyAlpha = 2i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_4: HierarchyAlpha = 3i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
pub const BDA_HALPHA_MAX: HierarchyAlpha = 4i32;
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMAnalogVideoDecoder(::windows::core::IUnknown);
impl IAMAnalogVideoDecoder {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lanalogvideostandard)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TVFormat(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn HorizontalLocked(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(lvcrhorizontallocking)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn VCRHorizontalLocking(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn NumberOfLines(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOutputEnable(&self, loutputenable: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(loutputenable)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OutputEnable(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
}
impl ::core::convert::From<IAMAnalogVideoDecoder> for ::windows::core::IUnknown {
    fn from(value: IAMAnalogVideoDecoder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMAnalogVideoDecoder> for ::windows::core::IUnknown {
    fn from(value: &IAMAnalogVideoDecoder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMAnalogVideoDecoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMAnalogVideoDecoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMAnalogVideoDecoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMAnalogVideoDecoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAnalogVideoDecoder {}
impl ::core::fmt::Debug for IAMAnalogVideoDecoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAnalogVideoDecoder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMAnalogVideoDecoder {
    type Vtable = IAMAnalogVideoDecoderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13350_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoDecoderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pllocked: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvcrhorizontallocking: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plvcrhorizontallocking: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnumberoflines: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, loutputenable: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ploutputenable: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMAnalogVideoEncoder(::windows::core::IUnknown);
impl IAMAnalogVideoEncoder {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lanalogvideostandard)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TVFormat(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCopyProtection(&self, lvideocopyprotection: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lvideocopyprotection)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CopyProtection(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCCEnable(&self, lccenable: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(lccenable)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CCEnable(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
}
impl ::core::convert::From<IAMAnalogVideoEncoder> for ::windows::core::IUnknown {
    fn from(value: IAMAnalogVideoEncoder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMAnalogVideoEncoder> for ::windows::core::IUnknown {
    fn from(value: &IAMAnalogVideoEncoder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMAnalogVideoEncoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMAnalogVideoEncoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMAnalogVideoEncoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMAnalogVideoEncoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAnalogVideoEncoder {}
impl ::core::fmt::Debug for IAMAnalogVideoEncoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAnalogVideoEncoder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMAnalogVideoEncoder {
    type Vtable = IAMAnalogVideoEncoderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e133b0_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoEncoderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvideocopyprotection: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvideocopyprotection: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lccenable: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lccenable: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMAsyncReaderTimestampScaling(::windows::core::IUnknown);
impl IAMAsyncReaderTimestampScaling {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTimestampMode(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTimestampMode<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fraw: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), fraw.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMAsyncReaderTimestampScaling> for ::windows::core::IUnknown {
    fn from(value: IAMAsyncReaderTimestampScaling) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMAsyncReaderTimestampScaling> for ::windows::core::IUnknown {
    fn from(value: &IAMAsyncReaderTimestampScaling) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMAsyncReaderTimestampScaling {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMAsyncReaderTimestampScaling {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMAsyncReaderTimestampScaling {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMAsyncReaderTimestampScaling {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAsyncReaderTimestampScaling {}
impl ::core::fmt::Debug for IAMAsyncReaderTimestampScaling {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAsyncReaderTimestampScaling").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMAsyncReaderTimestampScaling {
    type Vtable = IAMAsyncReaderTimestampScalingVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcf7b26fc_9a00_485b_8147_3e789d5e8f67);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAsyncReaderTimestampScalingVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfraw: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fraw: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMAudioInputMixer(::windows::core::IUnknown);
impl IAMAudioInputMixer {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnable<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fenable: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), fenable.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMono<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fmono: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), fmono.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Mono(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMixLevel(&self, level: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(level)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MixLevel(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPan(&self, pan: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pan)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Pan(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLoudness<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, floudness: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), floudness.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Loudness(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTreble(&self, treble: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(treble)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Treble(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TrebleRange(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetBass(&self, bass: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(bass)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Bass(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn BassRange(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
}
impl ::core::convert::From<IAMAudioInputMixer> for ::windows::core::IUnknown {
    fn from(value: IAMAudioInputMixer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMAudioInputMixer> for ::windows::core::IUnknown {
    fn from(value: &IAMAudioInputMixer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMAudioInputMixer {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMAudioInputMixer {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMAudioInputMixer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMAudioInputMixer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAudioInputMixer {}
impl ::core::fmt::Debug for IAMAudioInputMixer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAudioInputMixer").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMAudioInputMixer {
    type Vtable = IAMAudioInputMixerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x54c39221_8380_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioInputMixerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfenable: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmono: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfmono: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, level: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plevel: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pan: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppan: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, floudness: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfloudness: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, treble: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptreble: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prange: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bass: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbass: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prange: *mut f64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMAudioRendererStats(::windows::core::IUnknown);
impl IAMAudioRendererStats {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwparam), ::core::mem::transmute(pdwparam1), ::core::mem::transmute(pdwparam2)).ok()
    }
}
impl ::core::convert::From<IAMAudioRendererStats> for ::windows::core::IUnknown {
    fn from(value: IAMAudioRendererStats) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMAudioRendererStats> for ::windows::core::IUnknown {
    fn from(value: &IAMAudioRendererStats) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMAudioRendererStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMAudioRendererStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMAudioRendererStats {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMAudioRendererStats {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAudioRendererStats {}
impl ::core::fmt::Debug for IAMAudioRendererStats {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAudioRendererStats").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMAudioRendererStats {
    type Vtable = IAMAudioRendererStatsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x22320cb2_d41a_11d2_bf7c_d7cb9df0bf93);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioRendererStatsVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMBufferNegotiation(::windows::core::IUnknown);
impl IAMBufferNegotiation {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pprop)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetAllocatorProperties(&self) -> ::windows::core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__: ALLOCATOR_PROPERTIES = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ALLOCATOR_PROPERTIES>(result__)
    }
}
impl ::core::convert::From<IAMBufferNegotiation> for ::windows::core::IUnknown {
    fn from(value: IAMBufferNegotiation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMBufferNegotiation> for ::windows::core::IUnknown {
    fn from(value: &IAMBufferNegotiation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMBufferNegotiation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMBufferNegotiation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMBufferNegotiation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMBufferNegotiation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMBufferNegotiation {}
impl ::core::fmt::Debug for IAMBufferNegotiation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMBufferNegotiation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMBufferNegotiation {
    type Vtable = IAMBufferNegotiationVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56ed71a0_af5f_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMBufferNegotiationVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprop: *mut ALLOCATOR_PROPERTIES) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMCameraControl(::windows::core::IUnknown);
impl IAMCameraControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(pmin), ::core::mem::transmute(pmax), ::core::mem::transmute(psteppingdelta), ::core::mem::transmute(pdefault), ::core::mem::transmute(pcapsflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(lvalue), ::core::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(lvalue), ::core::mem::transmute(flags)).ok()
    }
}
impl ::core::convert::From<IAMCameraControl> for ::windows::core::IUnknown {
    fn from(value: IAMCameraControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMCameraControl> for ::windows::core::IUnknown {
    fn from(value: &IAMCameraControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMCameraControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMCameraControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMCameraControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMCameraControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCameraControl {}
impl ::core::fmt::Debug for IAMCameraControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCameraControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMCameraControl {
    type Vtable = IAMCameraControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13370_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCameraControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMCertifiedOutputProtection(::windows::core::IUnknown);
impl IAMCertifiedOutputProtection {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn KeyExchange(&self, prandom: *mut ::windows::core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(prandom), ::core::mem::transmute(varlencertgh), ::core::mem::transmute(pdwlengthcertgh)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SessionSequenceStart(&self, psig: *mut AMCOPPSignature) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(psig)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(cmd)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput) -> ::windows::core::Result<AMCOPPStatusOutput> {
        let mut result__: AMCOPPStatusOutput = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstatusinput), ::core::mem::transmute(&mut result__)).from_abi::<AMCOPPStatusOutput>(result__)
    }
}
impl ::core::convert::From<IAMCertifiedOutputProtection> for ::windows::core::IUnknown {
    fn from(value: IAMCertifiedOutputProtection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMCertifiedOutputProtection> for ::windows::core::IUnknown {
    fn from(value: &IAMCertifiedOutputProtection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMCertifiedOutputProtection {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMCertifiedOutputProtection {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMCertifiedOutputProtection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMCertifiedOutputProtection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCertifiedOutputProtection {}
impl ::core::fmt::Debug for IAMCertifiedOutputProtection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCertifiedOutputProtection").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMCertifiedOutputProtection {
    type Vtable = IAMCertifiedOutputProtectionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6feded3e_0ff1_4901_a2f1_43f7012c8515);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCertifiedOutputProtectionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prandom: *mut ::windows::core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psig: *mut AMCOPPSignature) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cmd: *const AMCOPPCommand) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMChannelInfo(::windows::core::IUnknown);
impl IAMChannelInfo {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ChannelName(&self, pbstrchannelname: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrchannelname)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ChannelDescription(&self, pbstrchanneldescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrchanneldescription)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ChannelURL(&self, pbstrchannelurl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrchannelurl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContactAddress(&self, pbstrcontactaddress: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrcontactaddress)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContactPhone(&self, pbstrcontactphone: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrcontactphone)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContactEmail(&self, pbstrcontactemail: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrcontactemail)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMChannelInfo> for super::super::System::Com::IDispatch {
    fn from(value: IAMChannelInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMChannelInfo> for super::super::System::Com::IDispatch {
    fn from(value: &IAMChannelInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMChannelInfo {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMChannelInfo {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMChannelInfo> for ::windows::core::IUnknown {
    fn from(value: IAMChannelInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMChannelInfo> for ::windows::core::IUnknown {
    fn from(value: &IAMChannelInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMChannelInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMChannelInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMChannelInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMChannelInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMChannelInfo {}
impl ::core::fmt::Debug for IAMChannelInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMChannelInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMChannelInfo {
    type Vtable = IAMChannelInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f2_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMChannelInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchannelname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchanneldescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchannelurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactaddress: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactphone: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactemail: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMClockAdjust(::windows::core::IUnknown);
impl IAMClockAdjust {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetClockDelta(&self, rtdelta: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(rtdelta)).ok()
    }
}
impl ::core::convert::From<IAMClockAdjust> for ::windows::core::IUnknown {
    fn from(value: IAMClockAdjust) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMClockAdjust> for ::windows::core::IUnknown {
    fn from(value: &IAMClockAdjust) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMClockAdjust {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMClockAdjust {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMClockAdjust {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMClockAdjust {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMClockAdjust {}
impl ::core::fmt::Debug for IAMClockAdjust {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMClockAdjust").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMClockAdjust {
    type Vtable = IAMClockAdjustVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d5466b0_a49c_11d1_abe8_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockAdjustVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtdelta: i64) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMClockSlave(::windows::core::IUnknown);
impl IAMClockSlave {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetErrorTolerance(&self, dwtolerance: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwtolerance)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetErrorTolerance(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAMClockSlave> for ::windows::core::IUnknown {
    fn from(value: IAMClockSlave) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMClockSlave> for ::windows::core::IUnknown {
    fn from(value: &IAMClockSlave) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMClockSlave {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMClockSlave {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMClockSlave {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMClockSlave {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMClockSlave {}
impl ::core::fmt::Debug for IAMClockSlave {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMClockSlave").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMClockSlave {
    type Vtable = IAMClockSlaveVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9fd52741_176d_4b36_8f51_ca8f933223be);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockSlaveVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtolerance: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwtolerance: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMCollection(::windows::core::IUnknown);
impl IAMCollection {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Item(&self, litem: i32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(litem), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMCollection> for super::super::System::Com::IDispatch {
    fn from(value: IAMCollection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMCollection> for super::super::System::Com::IDispatch {
    fn from(value: &IAMCollection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMCollection {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMCollection {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMCollection> for ::windows::core::IUnknown {
    fn from(value: IAMCollection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMCollection> for ::windows::core::IUnknown {
    fn from(value: &IAMCollection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMCollection {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMCollection {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCollection {}
impl ::core::fmt::Debug for IAMCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCollection").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMCollection {
    type Vtable = IAMCollectionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a868b9_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCollectionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, litem: i32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMCopyCaptureFileProgress(::windows::core::IUnknown);
impl IAMCopyCaptureFileProgress {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Progress(&self, iprogress: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(iprogress)).ok()
    }
}
impl ::core::convert::From<IAMCopyCaptureFileProgress> for ::windows::core::IUnknown {
    fn from(value: IAMCopyCaptureFileProgress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMCopyCaptureFileProgress> for ::windows::core::IUnknown {
    fn from(value: &IAMCopyCaptureFileProgress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMCopyCaptureFileProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMCopyCaptureFileProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMCopyCaptureFileProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMCopyCaptureFileProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCopyCaptureFileProgress {}
impl ::core::fmt::Debug for IAMCopyCaptureFileProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCopyCaptureFileProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMCopyCaptureFileProgress {
    type Vtable = IAMCopyCaptureFileProgressVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x670d1d20_a068_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCopyCaptureFileProgressVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iprogress: i32) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMCrossbar(::windows::core::IUnknown);
impl IAMCrossbar {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputpincount), ::core::mem::transmute(inputpincount)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputpinindex), ::core::mem::transmute(inputpinindex)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputpinindex), ::core::mem::transmute(inputpinindex)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsRoutedTo(&self, outputpinindex: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputpinindex), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CrossbarPinInfo<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, isinputpin: Param0, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), isinputpin.into_param().abi(), ::core::mem::transmute(pinindex), ::core::mem::transmute(pinindexrelated), ::core::mem::transmute(physicaltype)).ok()
    }
}
impl ::core::convert::From<IAMCrossbar> for ::windows::core::IUnknown {
    fn from(value: IAMCrossbar) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMCrossbar> for ::windows::core::IUnknown {
    fn from(value: &IAMCrossbar) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMCrossbar {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMCrossbar {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMCrossbar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMCrossbar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCrossbar {}
impl ::core::fmt::Debug for IAMCrossbar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCrossbar").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMCrossbar {
    type Vtable = IAMCrossbarVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13380_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCrossbarVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isinputpin: super::super::Foundation::BOOL, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDecoderCaps(::windows::core::IUnknown);
impl IAMDecoderCaps {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDecoderCaps(&self, dwcapindex: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcapindex), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAMDecoderCaps> for ::windows::core::IUnknown {
    fn from(value: IAMDecoderCaps) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDecoderCaps> for ::windows::core::IUnknown {
    fn from(value: &IAMDecoderCaps) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDecoderCaps {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDecoderCaps {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDecoderCaps {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDecoderCaps {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDecoderCaps {}
impl ::core::fmt::Debug for IAMDecoderCaps {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDecoderCaps").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDecoderCaps {
    type Vtable = IAMDecoderCapsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0dff467_d499_4986_972b_e1d9090fa941);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDecoderCapsVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcapindex: u32, lpdwcap: *mut u32) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDevMemoryAllocator(::windows::core::IUnknown);
impl IAMDevMemoryAllocator {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwcbtotalfree), ::core::mem::transmute(pdwcblargestfree), ::core::mem::transmute(pdwcbtotalmemory), ::core::mem::transmute(pdwcbminimumchunk)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CheckMemory(&self, pbuffer: *const u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(pdwcbbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Free(&self, pbuffer: *mut u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbuffer)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDevMemoryObject<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, ppunkinnner: *mut ::core::option::Option<::windows::core::IUnknown>, punkouter: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppunkinnner), punkouter.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMDevMemoryAllocator> for ::windows::core::IUnknown {
    fn from(value: IAMDevMemoryAllocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDevMemoryAllocator> for ::windows::core::IUnknown {
    fn from(value: &IAMDevMemoryAllocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDevMemoryAllocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDevMemoryAllocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDevMemoryAllocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDevMemoryAllocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDevMemoryAllocator {}
impl ::core::fmt::Debug for IAMDevMemoryAllocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDevMemoryAllocator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDevMemoryAllocator {
    type Vtable = IAMDevMemoryAllocatorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6545bf0_e76b_11d0_bd52_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryAllocatorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *const u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *mut u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunkinnner: *mut *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDevMemoryControl(::windows::core::IUnknown);
impl IAMDevMemoryControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn QueryWriteSync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn WriteSync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDevId(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAMDevMemoryControl> for ::windows::core::IUnknown {
    fn from(value: IAMDevMemoryControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDevMemoryControl> for ::windows::core::IUnknown {
    fn from(value: &IAMDevMemoryControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDevMemoryControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDevMemoryControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDevMemoryControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDevMemoryControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDevMemoryControl {}
impl ::core::fmt::Debug for IAMDevMemoryControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDevMemoryControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDevMemoryControl {
    type Vtable = IAMDevMemoryControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6545bf1_e76b_11d0_bd52_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdevid: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDeviceRemoval(::windows::core::IUnknown);
impl IAMDeviceRemoval {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeviceInfo(&self, pclsidinterfaceclass: *mut ::windows::core::GUID, pwszsymboliclink: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pclsidinterfaceclass), ::core::mem::transmute(pwszsymboliclink)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Reassociate(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Disassociate(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAMDeviceRemoval> for ::windows::core::IUnknown {
    fn from(value: IAMDeviceRemoval) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDeviceRemoval> for ::windows::core::IUnknown {
    fn from(value: &IAMDeviceRemoval) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDeviceRemoval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDeviceRemoval {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDeviceRemoval {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDeviceRemoval {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDeviceRemoval {}
impl ::core::fmt::Debug for IAMDeviceRemoval {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDeviceRemoval").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDeviceRemoval {
    type Vtable = IAMDeviceRemovalVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf90a6130_b658_11d2_ae49_0000f8754b99);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDeviceRemovalVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidinterfaceclass: *mut ::windows::core::GUID, pwszsymboliclink: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDirectSound(::windows::core::IUnknown);
impl IAMDirectSound {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetDirectSoundInterface(&self) -> ::windows::core::Result<super::Audio::DirectSound::IDirectSound> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Audio::DirectSound::IDirectSound>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetPrimaryBufferInterface(&self) -> ::windows::core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Audio::DirectSound::IDirectSoundBuffer>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetSecondaryBufferInterface(&self) -> ::windows::core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Audio::DirectSound::IDirectSoundBuffer>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseDirectSoundInterface<'a, Param0: ::windows::core::IntoParam<'a, super::Audio::DirectSound::IDirectSound>>(&self, lpds: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), lpds.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleasePrimaryBufferInterface<'a, Param0: ::windows::core::IntoParam<'a, super::Audio::DirectSound::IDirectSoundBuffer>>(&self, lpdsb: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), lpdsb.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Media_Audio_DirectSound'*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseSecondaryBufferInterface<'a, Param0: ::windows::core::IntoParam<'a, super::Audio::DirectSound::IDirectSoundBuffer>>(&self, lpdsb: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), lpdsb.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFocusWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, param0: Param0, param1: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), param0.into_param().abi(), param1.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(param0), ::core::mem::transmute(param1)).ok()
    }
}
impl ::core::convert::From<IAMDirectSound> for ::windows::core::IUnknown {
    fn from(value: IAMDirectSound) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDirectSound> for ::windows::core::IUnknown {
    fn from(value: &IAMDirectSound) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDirectSound {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDirectSound {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDirectSound {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDirectSound {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDirectSound {}
impl ::core::fmt::Debug for IAMDirectSound {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDirectSound").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDirectSound {
    type Vtable = IAMDirectSoundVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDirectSoundVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpds: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpdsb: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpdsb: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpds: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdsb: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdsb: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param0: super::super::Foundation::HWND, param1: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMDroppedFrames(::windows::core::IUnknown);
impl IAMDroppedFrames {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetNumDropped(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetNumNotDropped(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(lsize), ::core::mem::transmute(plarray), ::core::mem::transmute(plnumcopied)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetAverageFrameSize(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
}
impl ::core::convert::From<IAMDroppedFrames> for ::windows::core::IUnknown {
    fn from(value: IAMDroppedFrames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMDroppedFrames> for ::windows::core::IUnknown {
    fn from(value: &IAMDroppedFrames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMDroppedFrames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMDroppedFrames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMDroppedFrames {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMDroppedFrames {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDroppedFrames {}
impl ::core::fmt::Debug for IAMDroppedFrames {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDroppedFrames").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMDroppedFrames {
    type Vtable = IAMDroppedFramesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13344_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDroppedFramesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldropped: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnotdropped: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plaveragesize: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMExtDevice(::windows::core::IUnknown);
impl IAMExtDevice {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(capability), ::core::mem::transmute(pvalue), ::core::mem::transmute(pdblvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ExternalDeviceID(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ExternalDeviceVersion(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDevicePower(&self, powermode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(powermode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn DevicePower(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Calibrate(&self, hevent: usize, mode: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(hevent), ::core::mem::transmute(mode), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDevicePort(&self, deviceport: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(deviceport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn DevicePort(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
}
impl ::core::convert::From<IAMExtDevice> for ::windows::core::IUnknown {
    fn from(value: IAMExtDevice) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMExtDevice> for ::windows::core::IUnknown {
    fn from(value: &IAMExtDevice) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMExtDevice {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMExtDevice {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMExtDevice {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMExtDevice {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtDevice {}
impl ::core::fmt::Debug for IAMExtDevice {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtDevice").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMExtDevice {
    type Vtable = IAMExtDeviceVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb5730a90_1a2c_11cf_8c23_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtDeviceVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, powermode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppowermode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hevent: usize, mode: i32, pstatus: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, deviceport: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdeviceport: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMExtTransport(::windows::core::IUnknown);
impl IAMExtTransport {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(capability), ::core::mem::transmute(pvalue), ::core::mem::transmute(pdblvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMediaState(&self, state: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MediaState(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetLocalControl(&self, state: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn LocalControl(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetStatus(&self, statusitem: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(statusitem), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(pvalue), ::core::mem::transmute(ppszdata)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTransportBasicParameters<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, param: i32, value: i32, pszdata: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value), pszdata.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTransportVideoParameters(&self, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTransportVideoParameters(&self, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTransportAudioParameters(&self, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTransportAudioParameters(&self, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMode(&self, mode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(mode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Mode(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetRate(&self, dblrate: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(dblrate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Rate(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(penabled), ::core::mem::transmute(poffset), ::core::mem::transmute(phevent)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(enable), ::core::mem::transmute(offset), ::core::mem::transmute(hevent)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(pspeed), ::core::mem::transmute(pduration)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetBump(&self, speed: i32, duration: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(speed), ::core::mem::transmute(duration)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AntiClogControl(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetAntiClogControl(&self, enable: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(enable)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetEditPropertySet(&self, editid: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(editid), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(peditid), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetEditProperty(&self, editid: i32, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(editid), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(editid), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EditStart(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEditStart(&self, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), ::core::mem::transmute(value)).ok()
    }
}
impl ::core::convert::From<IAMExtTransport> for ::windows::core::IUnknown {
    fn from(value: IAMExtTransport) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMExtTransport> for ::windows::core::IUnknown {
    fn from(value: &IAMExtTransport) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMExtTransport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMExtTransport {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMExtTransport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMExtTransport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtTransport {}
impl ::core::fmt::Debug for IAMExtTransport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtTransport").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMExtTransport {
    type Vtable = IAMExtTransportVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa03cd5f0_3045_11cf_8c44_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtTransportVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, statusitem: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32, pszdata: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dblrate: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdblrate: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enable: i32, offset: i32, hevent: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspeed: *mut i32, pduration: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, speed: i32, duration: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabled: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enable: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, pstate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, peditid: *mut i32, state: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, param: i32, value: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMExtendedErrorInfo(::windows::core::IUnknown);
impl IAMExtendedErrorInfo {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn HasError(&self, phaserror: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(phaserror)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ErrorDescription(&self, pbstrerrordescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrerrordescription)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ErrorCode(&self, perrorcode: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(perrorcode)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMExtendedErrorInfo> for super::super::System::Com::IDispatch {
    fn from(value: IAMExtendedErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMExtendedErrorInfo> for super::super::System::Com::IDispatch {
    fn from(value: &IAMExtendedErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMExtendedErrorInfo> for ::windows::core::IUnknown {
    fn from(value: IAMExtendedErrorInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMExtendedErrorInfo> for ::windows::core::IUnknown {
    fn from(value: &IAMExtendedErrorInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMExtendedErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMExtendedErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtendedErrorInfo {}
impl ::core::fmt::Debug for IAMExtendedErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtendedErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMExtendedErrorInfo {
    type Vtable = IAMExtendedErrorInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f6_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedErrorInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phaserror: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrerrordescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrorcode: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMExtendedSeeking(::windows::core::IUnknown);
impl IAMExtendedSeeking {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pexcapabilities)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MarkerCount(&self, pmarkercount: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmarkercount)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcurrentmarker)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(markernum), ::core::mem::transmute(pmarkertime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(markernum), ::core::mem::transmute(pbstrmarkername)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPlaybackSpeed(&self, speed: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(speed)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PlaybackSpeed(&self, pspeed: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pspeed)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMExtendedSeeking> for super::super::System::Com::IDispatch {
    fn from(value: IAMExtendedSeeking) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMExtendedSeeking> for super::super::System::Com::IDispatch {
    fn from(value: &IAMExtendedSeeking) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMExtendedSeeking {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMExtendedSeeking {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMExtendedSeeking> for ::windows::core::IUnknown {
    fn from(value: IAMExtendedSeeking) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMExtendedSeeking> for ::windows::core::IUnknown {
    fn from(value: &IAMExtendedSeeking) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMExtendedSeeking {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMExtendedSeeking {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMExtendedSeeking {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMExtendedSeeking {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtendedSeeking {}
impl ::core::fmt::Debug for IAMExtendedSeeking {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtendedSeeking").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMExtendedSeeking {
    type Vtable = IAMExtendedSeekingVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f9_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedSeekingVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexcapabilities: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmarkercount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrentmarker: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, markernum: i32, pmarkertime: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, markernum: i32, pbstrmarkername: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, speed: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspeed: *mut f64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMFilterGraphCallback(::windows::core::IUnknown);
impl IAMFilterGraphCallback {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UnableToRender<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ppin.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMFilterGraphCallback> for ::windows::core::IUnknown {
    fn from(value: IAMFilterGraphCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMFilterGraphCallback> for ::windows::core::IUnknown {
    fn from(value: &IAMFilterGraphCallback) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMFilterGraphCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMFilterGraphCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMFilterGraphCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMFilterGraphCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMFilterGraphCallback {}
impl ::core::fmt::Debug for IAMFilterGraphCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMFilterGraphCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMFilterGraphCallback {
    type Vtable = IAMFilterGraphCallbackVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a868fd_0ad4_11ce_b0a3_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterGraphCallbackVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMFilterMiscFlags(::windows::core::IUnknown);
impl IAMFilterMiscFlags {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMiscFlags(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<IAMFilterMiscFlags> for ::windows::core::IUnknown {
    fn from(value: IAMFilterMiscFlags) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMFilterMiscFlags> for ::windows::core::IUnknown {
    fn from(value: &IAMFilterMiscFlags) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMFilterMiscFlags {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMFilterMiscFlags {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMFilterMiscFlags {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMFilterMiscFlags {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMFilterMiscFlags {}
impl ::core::fmt::Debug for IAMFilterMiscFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMFilterMiscFlags").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMFilterMiscFlags {
    type Vtable = IAMFilterMiscFlagsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2dd74950_a890_11d1_abe8_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterMiscFlagsVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMGraphBuilderCallback(::windows::core::IUnknown);
impl IAMGraphBuilderCallback {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SelectedFilter<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(&self, pmon: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreatedFilter<'a, Param0: ::windows::core::IntoParam<'a, IBaseFilter>>(&self, pfil: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pfil.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMGraphBuilderCallback> for ::windows::core::IUnknown {
    fn from(value: IAMGraphBuilderCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMGraphBuilderCallback> for ::windows::core::IUnknown {
    fn from(value: &IAMGraphBuilderCallback) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMGraphBuilderCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMGraphBuilderCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMGraphBuilderCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMGraphBuilderCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMGraphBuilderCallback {}
impl ::core::fmt::Debug for IAMGraphBuilderCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMGraphBuilderCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMGraphBuilderCallback {
    type Vtable = IAMGraphBuilderCallbackVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4995f511_9ddb_4f12_bd3b_f04611807b79);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphBuilderCallbackVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmon: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfil: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMGraphStreams(::windows::core::IUnknown);
impl IAMGraphStreams {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn FindUpstreamInterface<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0, riid: *const ::windows::core::GUID, ppvinterface: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvinterface), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SyncUsingStreamOffset<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, busestreamoffset: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), busestreamoffset.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(rtmaxgraphlatency)).ok()
    }
}
impl ::core::convert::From<IAMGraphStreams> for ::windows::core::IUnknown {
    fn from(value: IAMGraphStreams) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMGraphStreams> for ::windows::core::IUnknown {
    fn from(value: &IAMGraphStreams) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMGraphStreams {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMGraphStreams {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMGraphStreams {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMGraphStreams {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMGraphStreams {}
impl ::core::fmt::Debug for IAMGraphStreams {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMGraphStreams").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMGraphStreams {
    type Vtable = IAMGraphStreamsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x632105fa_072e_11d3_8af9_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphStreamsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, ppvinterface: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, busestreamoffset: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtmaxgraphlatency: i64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMLatency(::windows::core::IUnknown);
impl IAMLatency {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetLatency(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
}
impl ::core::convert::From<IAMLatency> for ::windows::core::IUnknown {
    fn from(value: IAMLatency) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMLatency> for ::windows::core::IUnknown {
    fn from(value: &IAMLatency) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMLatency {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMLatency {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMLatency {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMLatency {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMLatency {}
impl ::core::fmt::Debug for IAMLatency {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMLatency").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMLatency {
    type Vtable = IAMLatencyVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62ea93ba_ec62_11d2_b770_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLatencyVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtlatency: *mut i64) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMLine21Decoder(::windows::core::IUnknown);
impl IAMLine21Decoder {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(lplevel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpservice)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(service)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpstate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpbmih)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpbmi)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwphyscolor)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwphyscolor)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpboption)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRedrawAlways<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, boption: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), boption.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(mode)).ok()
    }
}
impl ::core::convert::From<IAMLine21Decoder> for ::windows::core::IUnknown {
    fn from(value: IAMLine21Decoder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMLine21Decoder> for ::windows::core::IUnknown {
    fn from(value: &IAMLine21Decoder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMLine21Decoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMLine21Decoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMLine21Decoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMLine21Decoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMLine21Decoder {}
impl ::core::fmt::Debug for IAMLine21Decoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMLine21Decoder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMLine21Decoder {
    type Vtable = IAMLine21DecoderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLine21DecoderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, service: AM_LINE21_CCSERVICE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: AM_LINE21_CCSTATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwphyscolor: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwphyscolor: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpboption: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, boption: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: AM_LINE21_DRAWBGMODE) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMediaContent(::windows::core::IUnknown);
impl IAMMediaContent {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AuthorName(&self, pbstrauthorname: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrauthorname)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self, pbstrtitle: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrtitle)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Rating(&self, pbstrrating: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrrating)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Description(&self, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrdescription)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Copyright(&self, pbstrcopyright: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrcopyright)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BaseURL(&self, pbstrbaseurl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrbaseurl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LogoURL(&self, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LogoIconURL(&self, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WatermarkURL(&self, pbstrwatermarkurl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrwatermarkurl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MoreInfoURL(&self, pbstrmoreinfourl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrmoreinfourl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrmoreinfobannerimage)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrmoreinfobannerurl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MoreInfoText(&self, pbstrmoreinfotext: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrmoreinfotext)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMMediaContent> for super::super::System::Com::IDispatch {
    fn from(value: IAMMediaContent) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMMediaContent> for super::super::System::Com::IDispatch {
    fn from(value: &IAMMediaContent) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMMediaContent {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMMediaContent {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMediaContent> for ::windows::core::IUnknown {
    fn from(value: IAMMediaContent) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaContent> for ::windows::core::IUnknown {
    fn from(value: &IAMMediaContent) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMediaContent {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMediaContent {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMediaContent {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMediaContent {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaContent {}
impl ::core::fmt::Debug for IAMMediaContent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaContent").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMediaContent {
    type Vtable = IAMMediaContentVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f4_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContentVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrauthorname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtitle: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrrating: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcopyright: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrbaseurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrwatermarkurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfourl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfobannerimage: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfobannerurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfotext: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMediaContent2(::windows::core::IUnknown);
impl IAMMediaContent2 {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaParameter<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, entrynum: i32, bstrname: Param1, pbstrvalue: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(entrynum), bstrname.into_param().abi(), ::core::mem::transmute(pbstrvalue)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(entrynum), ::core::mem::transmute(index), ::core::mem::transmute(pbstrname)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PlaylistCount(&self, pnumberentries: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pnumberentries)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMMediaContent2> for super::super::System::Com::IDispatch {
    fn from(value: IAMMediaContent2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMMediaContent2> for super::super::System::Com::IDispatch {
    fn from(value: &IAMMediaContent2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMMediaContent2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMMediaContent2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMediaContent2> for ::windows::core::IUnknown {
    fn from(value: IAMMediaContent2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaContent2> for ::windows::core::IUnknown {
    fn from(value: &IAMMediaContent2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMediaContent2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMediaContent2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMediaContent2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMediaContent2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaContent2 {}
impl ::core::fmt::Debug for IAMMediaContent2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaContent2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMediaContent2 {
    type Vtable = IAMMediaContent2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xce8f78c1_74d9_11d2_b09d_00a0c9a81117);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContent2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, entrynum: i32, bstrname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pbstrvalue: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, entrynum: i32, index: i32, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnumberentries: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMediaStream(::windows::core::IUnknown);
impl IAMMediaStream {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows::core::Result<IMultiMediaStream> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IMultiMediaStream>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows::core::GUID, ptype: *mut STREAM_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppurposeid), ::core::mem::transmute(ptype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetSameFormat<'a, Param0: ::windows::core::IntoParam<'a, IMediaStream>>(&self, pstreamthathasdesiredformat: Param0, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstreamthathasdesiredformat.into_param().abi(), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows::core::Result<IStreamSample> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreateSharedSample<'a, Param0: ::windows::core::IntoParam<'a, IStreamSample>>(&self, pexistingsample: Param0, dwflags: u32) -> ::windows::core::Result<IStreamSample> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pexistingsample.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, psourceobject: Param0, dwflags: u32, purposeid: *const ::windows::core::GUID, streamtype: STREAM_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), psourceobject.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(purposeid), ::core::mem::transmute(streamtype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetState(&self, state: FILTER_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn JoinAMMultiMediaStream<'a, Param0: ::windows::core::IntoParam<'a, IAMMultiMediaStream>>(&self, pammultimediastream: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), pammultimediastream.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn JoinFilter<'a, Param0: ::windows::core::IntoParam<'a, IMediaStreamFilter>>(&self, pmediastreamfilter: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), pmediastreamfilter.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn JoinFilterGraph<'a, Param0: ::windows::core::IntoParam<'a, IFilterGraph>>(&self, pfiltergraph: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), pfiltergraph.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMMediaStream> for IMediaStream {
    fn from(value: IAMMediaStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaStream> for IMediaStream {
    fn from(value: &IAMMediaStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMediaStream> for IAMMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMediaStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMediaStream> for &IAMMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMediaStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMediaStream> for ::windows::core::IUnknown {
    fn from(value: IAMMediaStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaStream> for ::windows::core::IUnknown {
    fn from(value: &IAMMediaStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaStream {}
impl ::core::fmt::Debug for IAMMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMediaStream {
    type Vtable = IAMMediaStreamVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbebe595d_9a6f_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaStreamVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmultimediastream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppurposeid: *mut ::windows::core::GUID, ptype: *mut STREAM_TYPE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstreamthathasdesiredformat: ::windows::core::RawPtr, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppsample: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexistingsample: ::windows::core::RawPtr, dwflags: u32, ppnewsample: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceobject: *mut ::core::ffi::c_void, dwflags: u32, purposeid: *const ::windows::core::GUID, streamtype: STREAM_TYPE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: FILTER_STATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pammultimediastream: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediastreamfilter: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfiltergraph: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMediaTypeSample(::windows::core::IUnknown);
impl IAMMediaTypeSample {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstarttime), ::core::mem::transmute(pendtime), ::core::mem::transmute(pcurrenttime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstarttime), ::core::mem::transmute(pendtime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Update<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, dwflags: u32, hevent: Param1, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), hevent.into_param().abi(), ::core::mem::transmute(pfnapc), ::core::mem::transmute(dwapcdata)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(dwmilliseconds)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPointer(&self, pbuffer: *const u8, lsize: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbuffer), ::core::mem::transmute(lsize)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetPointer(&self) -> ::windows::core::Result<*mut u8> {
        let mut result__: *mut u8 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut u8>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSize(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptimestart), ::core::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptimestart), ::core::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsSyncPoint(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSyncPoint<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bissyncpoint: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), bissyncpoint.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsPreroll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPreroll<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bispreroll: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), bispreroll.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(__midl__iammediatypesample0000)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMediaType(&self) -> ::windows::core::Result<*mut AM_MEDIA_TYPE> {
        let mut result__: *mut AM_MEDIA_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut AM_MEDIA_TYPE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMediaType(&self, pmediatype: *const AM_MEDIA_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmediatype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsDiscontinuity(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiscontinuity<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bdiscontinuity: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), bdiscontinuity.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptimestart), ::core::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptimestart), ::core::mem::transmute(ptimeend)).ok()
    }
}
impl ::core::convert::From<IAMMediaTypeSample> for IStreamSample {
    fn from(value: IAMMediaTypeSample) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaTypeSample> for IStreamSample {
    fn from(value: &IAMMediaTypeSample) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IStreamSample> for IAMMediaTypeSample {
    fn into_param(self) -> ::windows::core::Param<'a, IStreamSample> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IStreamSample> for &IAMMediaTypeSample {
    fn into_param(self) -> ::windows::core::Param<'a, IStreamSample> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMediaTypeSample> for ::windows::core::IUnknown {
    fn from(value: IAMMediaTypeSample) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaTypeSample> for ::windows::core::IUnknown {
    fn from(value: &IAMMediaTypeSample) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMediaTypeSample {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMediaTypeSample {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMediaTypeSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMediaTypeSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaTypeSample {}
impl ::core::fmt::Debug for IAMMediaTypeSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaTypeSample").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMediaTypeSample {
    type Vtable = IAMMediaTypeSampleVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab6b4afb_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeSampleVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmediastream: *const ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstarttime: *const i64, pendtime: *const i64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, hevent: super::super::Foundation::HANDLE, pfnapc: ::windows::core::RawPtr, dwapcdata: usize) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, dwmilliseconds: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *const u8, lsize: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bissyncpoint: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bispreroll: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, __midl__iammediatypesample0000: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmediatype: *mut *mut AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bdiscontinuity: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMediaTypeStream(::windows::core::IUnknown);
impl IAMMediaTypeStream {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows::core::Result<IMultiMediaStream> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IMultiMediaStream>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows::core::GUID, ptype: *mut STREAM_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppurposeid), ::core::mem::transmute(ptype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetSameFormat<'a, Param0: ::windows::core::IntoParam<'a, IMediaStream>>(&self, pstreamthathasdesiredformat: Param0, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstreamthathasdesiredformat.into_param().abi(), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows::core::Result<IStreamSample> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreateSharedSample<'a, Param0: ::windows::core::IntoParam<'a, IStreamSample>>(&self, pexistingsample: Param0, dwflags: u32) -> ::windows::core::Result<IStreamSample> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pexistingsample.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFormat(&self, pmediatype: *mut AM_MEDIA_TYPE, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmediatype), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFormat(&self, pmediatype: *const AM_MEDIA_TYPE, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmediatype), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreateSample<'a, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: Param3) -> ::windows::core::Result<IAMMediaTypeSample> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(lsamplesize), ::core::mem::transmute(pbbuffer), ::core::mem::transmute(dwflags), punkouter.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IAMMediaTypeSample>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetStreamAllocatorRequirements(&self) -> ::windows::core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__: ALLOCATOR_PROPERTIES = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ALLOCATOR_PROPERTIES>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pprops)).ok()
    }
}
impl ::core::convert::From<IAMMediaTypeStream> for IMediaStream {
    fn from(value: IAMMediaTypeStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaTypeStream> for IMediaStream {
    fn from(value: &IAMMediaTypeStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMediaStream> for IAMMediaTypeStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMediaStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMediaStream> for &IAMMediaTypeStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMediaStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMediaTypeStream> for ::windows::core::IUnknown {
    fn from(value: IAMMediaTypeStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMediaTypeStream> for ::windows::core::IUnknown {
    fn from(value: &IAMMediaTypeStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMediaTypeStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMediaTypeStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMediaTypeStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMediaTypeStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaTypeStream {}
impl ::core::fmt::Debug for IAMMediaTypeStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaTypeStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMediaTypeStream {
    type Vtable = IAMMediaTypeStreamVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab6b4afa_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeStreamVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmultimediastream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppurposeid: *mut ::windows::core::GUID, ptype: *mut STREAM_TYPE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstreamthathasdesiredformat: ::windows::core::RawPtr, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppsample: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexistingsample: ::windows::core::RawPtr, dwflags: u32, ppnewsample: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *mut AM_MEDIA_TYPE, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const AM_MEDIA_TYPE, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: *mut ::core::ffi::c_void, ppammediatypesample: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *mut ALLOCATOR_PROPERTIES) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMMultiMediaStream(::windows::core::IUnknown);
impl IAMMultiMediaStream {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwflags), ::core::mem::transmute(pstreamtype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows::core::GUID) -> ::windows::core::Result<IMediaStream> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(idpurpose), ::core::mem::transmute(&mut result__)).from_abi::<IMediaStream>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows::core::Result<IMediaStream> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(&mut result__)).from_abi::<IMediaStream>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetState(&self) -> ::windows::core::Result<STREAM_STATE> {
        let mut result__: STREAM_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<STREAM_STATE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(newstate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTime(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDuration(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(seektime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows::core::Result<super::super::Foundation::HANDLE> {
        let mut result__: super::super::Foundation::HANDLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Initialize<'a, Param2: ::windows::core::IntoParam<'a, IGraphBuilder>>(&self, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(streamtype), ::core::mem::transmute(dwflags), pfiltergraph.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetFilterGraph(&self) -> ::windows::core::Result<IGraphBuilder> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IGraphBuilder>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetFilter(&self) -> ::windows::core::Result<IMediaStreamFilter> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IMediaStreamFilter>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AddMediaStream<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, pstreamobject: Param0, purposeid: *const ::windows::core::GUID, dwflags: AMMSF_MS_FLAGS) -> ::windows::core::Result<IMediaStream> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), pstreamobject.into_param().abi(), ::core::mem::transmute(purposeid), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<IMediaStream>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszfilename: Param0, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pszfilename.into_param().abi(), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenMoniker<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(&self, pctx: Param0, pmoniker: Param1, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), pctx.into_param().abi(), pmoniker.into_param().abi(), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Render(&self, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags)).ok()
    }
}
impl ::core::convert::From<IAMMultiMediaStream> for IMultiMediaStream {
    fn from(value: IAMMultiMediaStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMultiMediaStream> for IMultiMediaStream {
    fn from(value: &IAMMultiMediaStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMultiMediaStream> for IAMMultiMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMultiMediaStream> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMultiMediaStream> for &IAMMultiMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, IMultiMediaStream> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMMultiMediaStream> for ::windows::core::IUnknown {
    fn from(value: IAMMultiMediaStream) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMMultiMediaStream> for ::windows::core::IUnknown {
    fn from(value: &IAMMultiMediaStream) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMMultiMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMMultiMediaStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMMultiMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMMultiMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMultiMediaStream {}
impl ::core::fmt::Debug for IAMMultiMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMultiMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMMultiMediaStream {
    type Vtable = IAMMultiMediaStreamVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbebe595c_9a6f_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMultiMediaStreamVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idpurpose: *const ::windows::core::GUID, ppmediastream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, ppmediastream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrentstate: *mut STREAM_STATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newstate: STREAM_STATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrenttime: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pduration: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, seektime: i64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pheos: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppgraphbuilder: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfilter: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstreamobject: *mut ::core::ffi::c_void, purposeid: *const ::windows::core::GUID, dwflags: AMMSF_MS_FLAGS, ppnewstream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: super::super::Foundation::PWSTR, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctx: ::windows::core::RawPtr, pmoniker: ::windows::core::RawPtr, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMNetShowConfig(::windows::core::IUnknown);
impl IAMNetShowConfig {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn BufferingTime(&self, pbufferingtime: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbufferingtime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetBufferingTime(&self, bufferingtime: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferingtime)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UseFixedUDPPort(&self, pusefixedudpport: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pusefixedudpport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetUseFixedUDPPort(&self, usefixedudpport: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(usefixedudpport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfixedudpport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetFixedUDPPort(&self, fixedudpport: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(fixedudpport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UseHTTPProxy(&self, pusehttpproxy: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pusehttpproxy)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetUseHTTPProxy(&self, usehttpproxy: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(usehttpproxy)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnableAutoProxy(&self, penableautoproxy: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(penableautoproxy)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEnableAutoProxy(&self, enableautoproxy: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(enableautoproxy)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrhttpproxyhost)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHTTPProxyHost<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrhttpproxyhost: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), bstrhttpproxyhost.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(phttpproxyport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetHTTPProxyPort(&self, httpproxyport: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(httpproxyport)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnableMulticast(&self, penablemulticast: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(penablemulticast)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEnableMulticast(&self, enablemulticast: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(enablemulticast)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnableUDP(&self, penableudp: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(penableudp)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEnableUDP(&self, enableudp: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(enableudp)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnableTCP(&self, penabletcp: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(penabletcp)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEnableTCP(&self, enabletcp: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(enabletcp)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EnableHTTP(&self, penablehttp: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(penablehttp)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetEnableHTTP(&self, enablehttp: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(enablehttp)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMNetShowConfig> for super::super::System::Com::IDispatch {
    fn from(value: IAMNetShowConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMNetShowConfig> for super::super::System::Com::IDispatch {
    fn from(value: &IAMNetShowConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMNetShowConfig {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMNetShowConfig {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMNetShowConfig> for ::windows::core::IUnknown {
    fn from(value: IAMNetShowConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMNetShowConfig> for ::windows::core::IUnknown {
    fn from(value: &IAMNetShowConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMNetShowConfig {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMNetShowConfig {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMNetShowConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMNetShowConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMNetShowConfig {}
impl ::core::fmt::Debug for IAMNetShowConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowConfig").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMNetShowConfig {
    type Vtable = IAMNetShowConfigVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f1_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowConfigVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingtime: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bufferingtime: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pusefixedudpport: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usefixedudpport: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfixedudpport: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fixedudpport: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pusehttpproxy: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usehttpproxy: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penableautoproxy: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enableautoproxy: i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrhttpproxyhost: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrhttpproxyhost: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phttpproxyport: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, httpproxyport: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penablemulticast: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enablemulticast: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penableudp: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enableudp: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabletcp: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enabletcp: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penablehttp: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enablehttp: i16) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMNetShowExProps(::windows::core::IUnknown);
impl IAMNetShowExProps {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SourceProtocol(&self, psourceprotocol: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(psourceprotocol)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Bandwidth(&self, pbandwidth: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbandwidth)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ErrorCorrection(&self, pbstrerrorcorrection: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrerrorcorrection)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CodecCount(&self, pcodeccount: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcodeccount)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(codecnum), ::core::mem::transmute(pcodecinstalled)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(codecnum), ::core::mem::transmute(pbstrcodecdescription)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(codecnum), ::core::mem::transmute(pbstrcodecurl)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreationDate(&self, pcreationdate: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcreationdate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SourceLink(&self, pbstrsourcelink: *mut super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrsourcelink)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMNetShowExProps> for super::super::System::Com::IDispatch {
    fn from(value: IAMNetShowExProps) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMNetShowExProps> for super::super::System::Com::IDispatch {
    fn from(value: &IAMNetShowExProps) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMNetShowExProps {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMNetShowExProps {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMNetShowExProps> for ::windows::core::IUnknown {
    fn from(value: IAMNetShowExProps) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMNetShowExProps> for ::windows::core::IUnknown {
    fn from(value: &IAMNetShowExProps) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMNetShowExProps {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMNetShowExProps {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMNetShowExProps {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMNetShowExProps {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMNetShowExProps {}
impl ::core::fmt::Debug for IAMNetShowExProps {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowExProps").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMNetShowExProps {
    type Vtable = IAMNetShowExPropsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f5_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowExPropsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceprotocol: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbandwidth: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrerrorcorrection: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcodeccount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pcodecinstalled: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pbstrcodecdescription: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pbstrcodecurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcreationdate: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsourcelink: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMNetShowPreroll(::windows::core::IUnknown);
impl IAMNetShowPreroll {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPreroll(&self, fpreroll: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(fpreroll)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Preroll(&self, pfpreroll: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfpreroll)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMNetShowPreroll> for super::super::System::Com::IDispatch {
    fn from(value: IAMNetShowPreroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMNetShowPreroll> for super::super::System::Com::IDispatch {
    fn from(value: &IAMNetShowPreroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMNetShowPreroll {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMNetShowPreroll {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMNetShowPreroll> for ::windows::core::IUnknown {
    fn from(value: IAMNetShowPreroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMNetShowPreroll> for ::windows::core::IUnknown {
    fn from(value: &IAMNetShowPreroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMNetShowPreroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMNetShowPreroll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMNetShowPreroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMNetShowPreroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMNetShowPreroll {}
impl ::core::fmt::Debug for IAMNetShowPreroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowPreroll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMNetShowPreroll {
    type Vtable = IAMNetShowPrerollVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaae7e4e2_6388_11d1_8d93_006097c9a2b2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowPrerollVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpreroll: i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfpreroll: *mut i16) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMNetworkStatus(::windows::core::IUnknown);
impl IAMNetworkStatus {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(preceivedpackets)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(precoveredpackets)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn LostPackets(&self, plostpackets: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(plostpackets)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ReceptionQuality(&self, preceptionquality: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(preceptionquality)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn BufferingCount(&self, pbufferingcount: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbufferingcount)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsBroadcast(&self, pisbroadcast: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(pisbroadcast)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbufferingprogress)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMNetworkStatus> for super::super::System::Com::IDispatch {
    fn from(value: IAMNetworkStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMNetworkStatus> for super::super::System::Com::IDispatch {
    fn from(value: &IAMNetworkStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMNetworkStatus {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMNetworkStatus {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMNetworkStatus> for ::windows::core::IUnknown {
    fn from(value: IAMNetworkStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMNetworkStatus> for ::windows::core::IUnknown {
    fn from(value: &IAMNetworkStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMNetworkStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMNetworkStatus {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMNetworkStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMNetworkStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMNetworkStatus {}
impl ::core::fmt::Debug for IAMNetworkStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetworkStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMNetworkStatus {
    type Vtable = IAMNetworkStatusVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa2aa8f3_8b62_11d0_a520_000000000000);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetworkStatusVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, preceivedpackets: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, precoveredpackets: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plostpackets: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, preceptionquality: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingcount: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisbroadcast: *mut i16) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingprogress: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMOpenProgress(::windows::core::IUnknown);
impl IAMOpenProgress {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(plltotal), ::core::mem::transmute(pllcurrent)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AbortOperation(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAMOpenProgress> for ::windows::core::IUnknown {
    fn from(value: IAMOpenProgress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMOpenProgress> for ::windows::core::IUnknown {
    fn from(value: &IAMOpenProgress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMOpenProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMOpenProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMOpenProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMOpenProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMOpenProgress {}
impl ::core::fmt::Debug for IAMOpenProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMOpenProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMOpenProgress {
    type Vtable = IAMOpenProgressVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8e1c39a1_de53_11cf_aa63_0080c744528d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOpenProgressVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMOverlayFX(::windows::core::IUnknown);
impl IAMOverlayFX {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn QueryOverlayFXCaps(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOverlayFX(&self, dwoverlayfx: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwoverlayfx)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetOverlayFX(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAMOverlayFX> for ::windows::core::IUnknown {
    fn from(value: IAMOverlayFX) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMOverlayFX> for ::windows::core::IUnknown {
    fn from(value: &IAMOverlayFX) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMOverlayFX {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMOverlayFX {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMOverlayFX {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMOverlayFX {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMOverlayFX {}
impl ::core::fmt::Debug for IAMOverlayFX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMOverlayFX").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMOverlayFX {
    type Vtable = IAMOverlayFXVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62fae250_7e65_4460_bfc9_6398b322073c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOverlayFXVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdwoverlayfxcaps: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwoverlayfx: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdwoverlayfx: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMParse(::windows::core::IUnknown);
impl IAMParse {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetParseTime(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetParseTime(&self, rtcurrent: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(rtcurrent)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Flush(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAMParse> for ::windows::core::IUnknown {
    fn from(value: IAMParse) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMParse> for ::windows::core::IUnknown {
    fn from(value: &IAMParse) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMParse {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMParse {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMParse {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMParse {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMParse {}
impl ::core::fmt::Debug for IAMParse {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMParse").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMParse {
    type Vtable = IAMParseVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc47a3420_005c_11d2_9038_00a0c9697298);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMParseVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtcurrent: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtcurrent: i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMPhysicalPinInfo(::windows::core::IUnknown);
impl IAMPhysicalPinInfo {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptype), ::core::mem::transmute(ppsztype)).ok()
    }
}
impl ::core::convert::From<IAMPhysicalPinInfo> for ::windows::core::IUnknown {
    fn from(value: IAMPhysicalPinInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPhysicalPinInfo> for ::windows::core::IUnknown {
    fn from(value: &IAMPhysicalPinInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMPhysicalPinInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMPhysicalPinInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMPhysicalPinInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMPhysicalPinInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPhysicalPinInfo {}
impl ::core::fmt::Debug for IAMPhysicalPinInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPhysicalPinInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMPhysicalPinInfo {
    type Vtable = IAMPhysicalPinInfoVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf938c991_3029_11cf_8c44_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPhysicalPinInfoVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *mut i32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMPlayList(::windows::core::IUnknown);
impl IAMPlayList {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetItemCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetItem(&self, dwitemindex: u32) -> ::windows::core::Result<IAMPlayListItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwitemindex), ::core::mem::transmute(&mut result__)).from_abi::<IAMPlayListItem>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetNamedEvent<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszeventname: Param0, dwitemindex: u32, ppitem: *mut ::core::option::Option<IAMPlayListItem>, pdwflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pwszeventname.into_param().abi(), ::core::mem::transmute(dwitemindex), ::core::mem::transmute(ppitem), ::core::mem::transmute(pdwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwrepeatcount), ::core::mem::transmute(pdwrepeatstart), ::core::mem::transmute(pdwrepeatend)).ok()
    }
}
impl ::core::convert::From<IAMPlayList> for ::windows::core::IUnknown {
    fn from(value: IAMPlayList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPlayList> for ::windows::core::IUnknown {
    fn from(value: &IAMPlayList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMPlayList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMPlayList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMPlayList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMPlayList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPlayList {}
impl ::core::fmt::Debug for IAMPlayList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPlayList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMPlayList {
    type Vtable = IAMPlayListVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a868fe_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayListVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwitems: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwitemindex: u32, ppitem: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszeventname: super::super::Foundation::PWSTR, dwitemindex: u32, ppitem: *mut ::windows::core::RawPtr, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMPlayListItem(::windows::core::IUnknown);
impl IAMPlayListItem {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSourceCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceURL(&self, dwsourceindex: u32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSourceStart(&self, dwsourceindex: u32) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSourceDuration(&self, dwsourceindex: u32) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSourceStartMarker(&self, dwsourceindex: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetSourceEndMarker(&self, dwsourceindex: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLinkURL(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetScanDuration(&self, dwsourceindex: u32) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourceindex), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
}
impl ::core::convert::From<IAMPlayListItem> for ::windows::core::IUnknown {
    fn from(value: IAMPlayListItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPlayListItem> for ::windows::core::IUnknown {
    fn from(value: &IAMPlayListItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMPlayListItem {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMPlayListItem {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMPlayListItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMPlayListItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPlayListItem {}
impl ::core::fmt::Debug for IAMPlayListItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPlayListItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMPlayListItem {
    type Vtable = IAMPlayListItemVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a868ff_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayListItemVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwsources: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtstart: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtduration: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrstartmarker: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrendmarker: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrurl: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtscanduration: *mut i64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMPluginControl(::windows::core::IUnknown);
impl IAMPluginControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetPreferredClsid(&self, subtype: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(subtype), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut ::windows::core::GUID, clsid: *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(subtype), ::core::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPreferredClsid(&self, subtype: *const ::windows::core::GUID, clsid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(subtype), ::core::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn IsDisabled(&self, clsid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDisabledByIndex(&self, index: u32) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDisabled<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, clsid: *const ::windows::core::GUID, disabled: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsid), disabled.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsLegacyDisabled<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, dllname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), dllname.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMPluginControl> for ::windows::core::IUnknown {
    fn from(value: IAMPluginControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPluginControl> for ::windows::core::IUnknown {
    fn from(value: &IAMPluginControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMPluginControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMPluginControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMPluginControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMPluginControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPluginControl {}
impl ::core::fmt::Debug for IAMPluginControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPluginControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMPluginControl {
    type Vtable = IAMPluginControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0e26a181_f40c_4635_8786_976284b52981);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPluginControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, subtype: *const ::windows::core::GUID, clsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, subtype: *mut ::windows::core::GUID, clsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, subtype: *const ::windows::core::GUID, clsid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, clsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: *const ::windows::core::GUID, disabled: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dllname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMPushSource(::windows::core::IUnknown);
impl IAMPushSource {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetLatency(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetPushSourceFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPushSourceFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetStreamOffset(&self, rtoffset: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(rtoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetStreamOffset(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMaxStreamOffset(&self) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(rtmaxoffset)).ok()
    }
}
impl ::core::convert::From<IAMPushSource> for IAMLatency {
    fn from(value: IAMPushSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPushSource> for IAMLatency {
    fn from(value: &IAMPushSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAMLatency> for IAMPushSource {
    fn into_param(self) -> ::windows::core::Param<'a, IAMLatency> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAMLatency> for &IAMPushSource {
    fn into_param(self) -> ::windows::core::Param<'a, IAMLatency> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMPushSource> for ::windows::core::IUnknown {
    fn from(value: IAMPushSource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMPushSource> for ::windows::core::IUnknown {
    fn from(value: &IAMPushSource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMPushSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMPushSource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMPushSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMPushSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPushSource {}
impl ::core::fmt::Debug for IAMPushSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPushSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMPushSource {
    type Vtable = IAMPushSourceVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf185fe76_e64e_11d2_b76e_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPushSourceVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtlatency: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pflags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtoffset: i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtoffset: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtmaxoffset: *mut i64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtmaxoffset: i64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMRebuild(::windows::core::IUnknown);
impl IAMRebuild {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn RebuildNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAMRebuild> for ::windows::core::IUnknown {
    fn from(value: IAMRebuild) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMRebuild> for ::windows::core::IUnknown {
    fn from(value: &IAMRebuild) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMRebuild {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMRebuild {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMRebuild {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMRebuild {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMRebuild {}
impl ::core::fmt::Debug for IAMRebuild {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMRebuild").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMRebuild {
    type Vtable = IAMRebuildVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x02ef04dd_7580_11d1_bece_00c04fb6e937);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMRebuildVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMResourceControl(::windows::core::IUnknown);
impl IAMResourceControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Reserve(&self, dwflags: u32, pvreserved: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(pvreserved)).ok()
    }
}
impl ::core::convert::From<IAMResourceControl> for ::windows::core::IUnknown {
    fn from(value: IAMResourceControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMResourceControl> for ::windows::core::IUnknown {
    fn from(value: &IAMResourceControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMResourceControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMResourceControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMResourceControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMResourceControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMResourceControl {}
impl ::core::fmt::Debug for IAMResourceControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMResourceControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMResourceControl {
    type Vtable = IAMResourceControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8389d2d0_77d7_11d1_abe6_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMResourceControlVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, pvreserved: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMStats(::windows::core::IUnknown);
impl IAMStats {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueByIndex(&self, lindex: i32, szname: *mut super::super::Foundation::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(szname), ::core::mem::transmute(lcount), ::core::mem::transmute(dlast), ::core::mem::transmute(daverage), ::core::mem::transmute(dstddev), ::core::mem::transmute(dmin), ::core::mem::transmute(dmax)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValueByName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, szname: Param0, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), szname.into_param().abi(), ::core::mem::transmute(lindex), ::core::mem::transmute(lcount), ::core::mem::transmute(dlast), ::core::mem::transmute(daverage), ::core::mem::transmute(dstddev), ::core::mem::transmute(dmin), ::core::mem::transmute(dmax)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIndex<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, szname: Param0, lcreate: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), szname.into_param().abi(), ::core::mem::transmute(lcreate), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AddValue(&self, lindex: i32, dvalue: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(dvalue)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAMStats> for super::super::System::Com::IDispatch {
    fn from(value: IAMStats) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAMStats> for super::super::System::Com::IDispatch {
    fn from(value: &IAMStats) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IAMStats {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IAMStats {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMStats> for ::windows::core::IUnknown {
    fn from(value: IAMStats) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMStats> for ::windows::core::IUnknown {
    fn from(value: &IAMStats) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMStats {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMStats {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStats {}
impl ::core::fmt::Debug for IAMStats {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStats").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMStats {
    type Vtable = IAMStatsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbc9bcf80_dcd2_11d2_abf6_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStatsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, szname: *mut super::super::Foundation::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, lcreate: i32, plindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, dvalue: f64) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMStreamConfig(::windows::core::IUnknown);
impl IAMStreamConfig {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFormat(&self, pmt: *mut AM_MEDIA_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmt)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFormat(&self) -> ::windows::core::Result<*mut AM_MEDIA_TYPE> {
        let mut result__: *mut AM_MEDIA_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut AM_MEDIA_TYPE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(picount), ::core::mem::transmute(pisize)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(iindex), ::core::mem::transmute(ppmt), ::core::mem::transmute(pscc)).ok()
    }
}
impl ::core::convert::From<IAMStreamConfig> for ::windows::core::IUnknown {
    fn from(value: IAMStreamConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMStreamConfig> for ::windows::core::IUnknown {
    fn from(value: &IAMStreamConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMStreamConfig {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMStreamConfig {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMStreamConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMStreamConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamConfig {}
impl ::core::fmt::Debug for IAMStreamConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamConfig").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMStreamConfig {
    type Vtable = IAMStreamConfigVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13340_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamConfigVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmt: *mut AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmt: *mut *mut AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, picount: *mut i32, pisize: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMStreamControl(::windows::core::IUnknown);
impl IAMStreamControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn StartAt(&self, ptstart: *const i64, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptstart), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StopAt<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ptstop: *const i64, bsendextra: Param1, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptstop), bsendextra.into_param().abi(), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetInfo(&self) -> ::windows::core::Result<AM_STREAM_INFO> {
        let mut result__: AM_STREAM_INFO = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<AM_STREAM_INFO>(result__)
    }
}
impl ::core::convert::From<IAMStreamControl> for ::windows::core::IUnknown {
    fn from(value: IAMStreamControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMStreamControl> for ::windows::core::IUnknown {
    fn from(value: &IAMStreamControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMStreamControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMStreamControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMStreamControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMStreamControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamControl {}
impl ::core::fmt::Debug for IAMStreamControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMStreamControl {
    type Vtable = IAMStreamControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x36b73881_c2c8_11cf_8b46_00805f6cef60);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptstart: *const i64, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptstop: *const i64, bsendextra: super::super::Foundation::BOOL, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pinfo: *mut AM_STREAM_INFO) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMStreamSelect(::windows::core::IUnknown);
impl IAMStreamSelect {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Info(&self, lindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut super::super::Foundation::PWSTR, ppobject: *mut ::core::option::Option<::windows::core::IUnknown>, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(ppmt), ::core::mem::transmute(pdwflags), ::core::mem::transmute(plcid), ::core::mem::transmute(pdwgroup), ::core::mem::transmute(ppszname), ::core::mem::transmute(ppobject), ::core::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Enable(&self, lindex: i32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(dwflags)).ok()
    }
}
impl ::core::convert::From<IAMStreamSelect> for ::windows::core::IUnknown {
    fn from(value: IAMStreamSelect) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMStreamSelect> for ::windows::core::IUnknown {
    fn from(value: &IAMStreamSelect) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMStreamSelect {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMStreamSelect {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMStreamSelect {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMStreamSelect {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamSelect {}
impl ::core::fmt::Debug for IAMStreamSelect {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamSelect").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMStreamSelect {
    type Vtable = IAMStreamSelectVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc1960960_17f5_11d1_abe1_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamSelectVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcstreams: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut super::super::Foundation::PWSTR, ppobject: *mut *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, dwflags: u32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTVAudio(::windows::core::IUnknown);
impl IAMTVAudio {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetHardwareSupportedTVAudioModes(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetAvailableTVAudioModes(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TVAudioMode(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTVAudioMode(&self, lmode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pnotify.into_param().abi(), ::core::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMTVAudio> for ::windows::core::IUnknown {
    fn from(value: IAMTVAudio) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTVAudio> for ::windows::core::IUnknown {
    fn from(value: &IAMTVAudio) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTVAudio {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTVAudio {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTVAudio {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTVAudio {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVAudio {}
impl ::core::fmt::Debug for IAMTVAudio {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVAudio").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTVAudio {
    type Vtable = IAMTVAudioVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x83ec1c30_23d1_11d1_99e6_00a0c9560266);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudioVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr, levents: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTVAudioNotification(::windows::core::IUnknown);
impl IAMTVAudioNotification {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OnEvent(&self, event: AMTVAudioEventType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(event)).ok()
    }
}
impl ::core::convert::From<IAMTVAudioNotification> for ::windows::core::IUnknown {
    fn from(value: IAMTVAudioNotification) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTVAudioNotification> for ::windows::core::IUnknown {
    fn from(value: &IAMTVAudioNotification) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTVAudioNotification {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTVAudioNotification {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTVAudioNotification {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTVAudioNotification {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVAudioNotification {}
impl ::core::fmt::Debug for IAMTVAudioNotification {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVAudioNotification").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTVAudioNotification {
    type Vtable = IAMTVAudioNotificationVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x83ec1c33_23d1_11d1_99e6_00a0c9560266);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudioNotificationVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, event: AMTVAudioEventType) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTVTuner(::windows::core::IUnknown);
impl IAMTVTuner {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetChannel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(lchannel), ::core::mem::transmute(lvideosubchannel), ::core::mem::transmute(laudiosubchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(plchannel), ::core::mem::transmute(plvideosubchannel), ::core::mem::transmute(plaudiosubchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(lchannelmin), ::core::mem::transmute(lchannelmax)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lcountrycode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CountryCode(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(ltuningspace)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Logon<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hcurrentuser: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), hcurrentuser.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Logout(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SignalPresent(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Mode(&self) -> ::windows::core::Result<AMTunerModeType> {
        let mut result__: AMTunerModeType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<AMTunerModeType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetAvailableModes(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pnotify.into_param().abi(), ::core::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TVFormat(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AutoTune(&self, lchannel: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(lchannel), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn StoreAutoTune(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn NumInputConnections(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInputType(&self, lindex: i32, inputtype: TunerInputType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(inputtype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InputType(&self, lindex: i32) -> ::windows::core::Result<TunerInputType> {
        let mut result__: TunerInputType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex), ::core::mem::transmute(&mut result__)).from_abi::<TunerInputType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetConnectInput(&self, lindex: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(lindex)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ConnectInput(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn VideoFrequency(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn AudioFrequency(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
}
impl ::core::convert::From<IAMTVTuner> for IAMTuner {
    fn from(value: IAMTVTuner) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTVTuner> for IAMTuner {
    fn from(value: &IAMTVTuner) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAMTuner> for IAMTVTuner {
    fn into_param(self) -> ::windows::core::Param<'a, IAMTuner> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAMTuner> for &IAMTVTuner {
    fn into_param(self) -> ::windows::core::Param<'a, IAMTuner> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAMTVTuner> for ::windows::core::IUnknown {
    fn from(value: IAMTVTuner) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTVTuner> for ::windows::core::IUnknown {
    fn from(value: &IAMTVTuner) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTVTuner {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTVTuner {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTVTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTVTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVTuner {}
impl ::core::fmt::Debug for IAMTVTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTVTuner {
    type Vtable = IAMTVTunerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x211a8766_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVTunerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcountrycode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcountrycode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ltuningspace: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pltuningspace: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hcurrentuser: super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plsignalstrength: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmode: AMTunerModeType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmode: *mut AMTunerModeType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr, levents: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannel: i32, plfoundsignal: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnuminputconnections: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, inputtype: TunerInputType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, pinputtype: *mut TunerInputType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plindex: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lfreq: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lfreq: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTimecodeDisplay(::windows::core::IUnknown);
impl IAMTimecodeDisplay {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTCDisplayEnable(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTCDisplayEnable(&self, state: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTCDisplay(&self, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTCDisplay(&self, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
}
impl ::core::convert::From<IAMTimecodeDisplay> for ::windows::core::IUnknown {
    fn from(value: IAMTimecodeDisplay) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTimecodeDisplay> for ::windows::core::IUnknown {
    fn from(value: &IAMTimecodeDisplay) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTimecodeDisplay {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTimecodeDisplay {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTimecodeDisplay {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTimecodeDisplay {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeDisplay {}
impl ::core::fmt::Debug for IAMTimecodeDisplay {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeDisplay").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTimecodeDisplay {
    type Vtable = IAMTimecodeDisplayVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b496ce2_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeDisplayVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTimecodeGenerator(::windows::core::IUnknown);
impl IAMTimecodeGenerator {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTCGMode(&self, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTCGMode(&self, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(line)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn VITCLine(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptimecodesample)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTimecode(&self) -> ::windows::core::Result<super::TIMECODE_SAMPLE> {
        let mut result__: super::TIMECODE_SAMPLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::TIMECODE_SAMPLE>(result__)
    }
}
impl ::core::convert::From<IAMTimecodeGenerator> for ::windows::core::IUnknown {
    fn from(value: IAMTimecodeGenerator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTimecodeGenerator> for ::windows::core::IUnknown {
    fn from(value: &IAMTimecodeGenerator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTimecodeGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTimecodeGenerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTimecodeGenerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTimecodeGenerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeGenerator {}
impl ::core::fmt::Debug for IAMTimecodeGenerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeGenerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTimecodeGenerator {
    type Vtable = IAMTimecodeGeneratorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b496ce0_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeGeneratorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, line: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pline: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTimecodeReader(::windows::core::IUnknown);
impl IAMTimecodeReader {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTCRMode(&self, param: i32) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTCRMode(&self, param: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(param), ::core::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(line)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn VITCLine(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetTimecode(&self) -> ::windows::core::Result<super::TIMECODE_SAMPLE> {
        let mut result__: super::TIMECODE_SAMPLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::TIMECODE_SAMPLE>(result__)
    }
}
impl ::core::convert::From<IAMTimecodeReader> for ::windows::core::IUnknown {
    fn from(value: IAMTimecodeReader) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTimecodeReader> for ::windows::core::IUnknown {
    fn from(value: &IAMTimecodeReader) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTimecodeReader {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTimecodeReader {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTimecodeReader {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTimecodeReader {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeReader {}
impl ::core::fmt::Debug for IAMTimecodeReader {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeReader").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTimecodeReader {
    type Vtable = IAMTimecodeReaderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b496ce1_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeReaderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, line: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pline: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTuner(::windows::core::IUnknown);
impl IAMTuner {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetChannel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(lchannel), ::core::mem::transmute(lvideosubchannel), ::core::mem::transmute(laudiosubchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(plchannel), ::core::mem::transmute(plvideosubchannel), ::core::mem::transmute(plaudiosubchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(lchannelmin), ::core::mem::transmute(lchannelmax)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lcountrycode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CountryCode(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(ltuningspace)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Logon<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hcurrentuser: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), hcurrentuser.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Logout(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SignalPresent(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Mode(&self) -> ::windows::core::Result<AMTunerModeType> {
        let mut result__: AMTunerModeType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<AMTunerModeType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetAvailableModes(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pnotify.into_param().abi(), ::core::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::core::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMTuner> for ::windows::core::IUnknown {
    fn from(value: IAMTuner) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTuner> for ::windows::core::IUnknown {
    fn from(value: &IAMTuner) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTuner {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTuner {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTuner {}
impl ::core::fmt::Debug for IAMTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTuner {
    type Vtable = IAMTunerVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x211a8761_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTunerVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcountrycode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcountrycode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ltuningspace: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pltuningspace: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hcurrentuser: super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plsignalstrength: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmode: AMTunerModeType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmode: *mut AMTunerModeType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr, levents: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMTunerNotification(::windows::core::IUnknown);
impl IAMTunerNotification {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OnEvent(&self, event: AMTunerEventType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(event)).ok()
    }
}
impl ::core::convert::From<IAMTunerNotification> for ::windows::core::IUnknown {
    fn from(value: IAMTunerNotification) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMTunerNotification> for ::windows::core::IUnknown {
    fn from(value: &IAMTunerNotification) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMTunerNotification {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMTunerNotification {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMTunerNotification {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMTunerNotification {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTunerNotification {}
impl ::core::fmt::Debug for IAMTunerNotification {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTunerNotification").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMTunerNotification {
    type Vtable = IAMTunerNotificationVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x211a8760_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTunerNotificationVtbl(pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32, pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, event: AMTunerEventType) -> ::windows::core::HRESULT);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVfwCaptureDialogs(::windows::core::IUnknown);
impl IAMVfwCaptureDialogs {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn HasDialog(&self, idialog: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(idialog)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDialog<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, idialog: i32, hwnd: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(idialog), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(idialog), ::core::mem::transmute(umsg), ::core::mem::transmute(dw1), ::core::mem::transmute(dw2)).ok()
    }
}
impl ::core::convert::From<IAMVfwCaptureDialogs> for ::windows::core::IUnknown {
    fn from(value: IAMVfwCaptureDialogs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVfwCaptureDialogs> for ::windows::core::IUnknown {
    fn from(value: &IAMVfwCaptureDialogs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVfwCaptureDialogs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVfwCaptureDialogs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVfwCaptureDialogs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVfwCaptureDialogs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVfwCaptureDialogs {}
impl ::core::fmt::Debug for IAMVfwCaptureDialogs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVfwCaptureDialogs").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVfwCaptureDialogs {
    type Vtable = IAMVfwCaptureDialogsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8d715a0_6e5e_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCaptureDialogsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVfwCompressDialogs(::windows::core::IUnknown);
impl IAMVfwCompressDialogs {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDialog<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, idialog: i32, hwnd: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(idialog), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetState(&self, pstate: *mut ::core::ffi::c_void, pcbstate: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstate), ::core::mem::transmute(pcbstate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetState(&self, pstate: *const ::core::ffi::c_void, cbstate: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pstate), ::core::mem::transmute(cbstate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(umsg), ::core::mem::transmute(dw1), ::core::mem::transmute(dw2)).ok()
    }
}
impl ::core::convert::From<IAMVfwCompressDialogs> for ::windows::core::IUnknown {
    fn from(value: IAMVfwCompressDialogs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVfwCompressDialogs> for ::windows::core::IUnknown {
    fn from(value: &IAMVfwCompressDialogs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVfwCompressDialogs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVfwCompressDialogs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVfwCompressDialogs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVfwCompressDialogs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVfwCompressDialogs {}
impl ::core::fmt::Debug for IAMVfwCompressDialogs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVfwCompressDialogs").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVfwCompressDialogs {
    type Vtable = IAMVfwCompressDialogsVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8d715a3_6e5e_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCompressDialogsVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut ::core::ffi::c_void, pcbstate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *const ::core::ffi::c_void, cbstate: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: i32, dw1: i32, dw2: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoAccelerator(::windows::core::IUnknown);
impl IAMVideoAccelerator {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwnumguidssupported), ::core::mem::transmute(pguidssupported)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompFormatsSupported(&self, pguid: *const ::windows::core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pdwnumformatssupported), ::core::mem::transmute(pformatssupported)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalMemInfo(&self, pguid: *const ::windows::core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pamvauncompdatainfo), ::core::mem::transmute(pamvainternalmeminfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCompBufferInfo(&self, pguid: *const ::windows::core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pamvauncompdatainfo), ::core::mem::transmute(pdwnumtypescompbuffers), ::core::mem::transmute(pamvacompbufferinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwnumtypescompbuffers), ::core::mem::transmute(pamvacompbufferinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(amvabeginframeinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pendframeinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBuffer<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: Param2, ppbuffer: *mut *mut ::core::ffi::c_void, lpstride: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwtypeindex), ::core::mem::transmute(dwbufferindex), breadonly.into_param().abi(), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(lpstride)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwtypeindex), ::core::mem::transmute(dwbufferindex)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const ::core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::core::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfunction), ::core::mem::transmute(lpprivateinputdata), ::core::mem::transmute(cbprivateinputdata), ::core::mem::transmute(lpprivateoutputdat), ::core::mem::transmute(cbprivateoutputdata), ::core::mem::transmute(dwnumbuffers), ::core::mem::transmute(pamvabufferinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwtypeindex), ::core::mem::transmute(dwbufferindex), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn DisplayFrame<'a, Param1: ::windows::core::IntoParam<'a, IMediaSample>>(&self, dwfliptoindex: u32, pmediasample: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfliptoindex), pmediasample.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMVideoAccelerator> for ::windows::core::IUnknown {
    fn from(value: IAMVideoAccelerator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoAccelerator> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoAccelerator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoAccelerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoAccelerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoAccelerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoAccelerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoAccelerator {}
impl ::core::fmt::Debug for IAMVideoAccelerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoAccelerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoAccelerator {
    type Vtable = IAMVideoAcceleratorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x256a6a22_fbad_11d1_82bf_00a0c9696c8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAcceleratorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumguidssupported: *mut u32, pguidssupported: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, breadonly: super::super::Foundation::BOOL, ppbuffer: *mut *mut ::core::ffi::c_void, lpstride: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfunction: u32, lpprivateinputdata: *const ::core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::core::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfliptoindex: u32, pmediasample: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoAcceleratorNotify(::windows::core::IUnknown);
impl IAMVideoAcceleratorNotify {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_DirectDraw'*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompSurfacesInfo(&self, pguid: *const ::windows::core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(puncompbufferinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwactualuncompsurfacesallocated)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCreateVideoAcceleratorData(&self, pguid: *const ::windows::core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pdwsizemiscdata), ::core::mem::transmute(ppmiscdata)).ok()
    }
}
impl ::core::convert::From<IAMVideoAcceleratorNotify> for ::windows::core::IUnknown {
    fn from(value: IAMVideoAcceleratorNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoAcceleratorNotify> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoAcceleratorNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoAcceleratorNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoAcceleratorNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoAcceleratorNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoAcceleratorNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoAcceleratorNotify {}
impl ::core::fmt::Debug for IAMVideoAcceleratorNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoAcceleratorNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoAcceleratorNotify {
    type Vtable = IAMVideoAcceleratorNotifyVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x256a6a21_fbad_11d1_82bf_00a0c9696c8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAcceleratorNotifyVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwactualuncompsurfacesallocated: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoCompression(::windows::core::IUnknown);
impl IAMVideoCompression {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetKeyFrameRate(&self, keyframerate: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(keyframerate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn KeyFrameRate(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pframesperkeyframe)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PFramesPerKeyFrame(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetQuality(&self, quality: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(quality)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Quality(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetWindowSize(&self, windowsize: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(windowsize)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn WindowSize(&self) -> ::windows::core::Result<u64> {
        let mut result__: u64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInfo(&self, pszversion: super::super::Foundation::PWSTR, pcbversion: *mut i32, pszdescription: super::super::Foundation::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(pszversion), ::core::mem::transmute(pcbversion), ::core::mem::transmute(pszdescription), ::core::mem::transmute(pcbdescription), ::core::mem::transmute(pdefaultkeyframerate), ::core::mem::transmute(pdefaultpframesperkey), ::core::mem::transmute(pdefaultquality), ::core::mem::transmute(pcapabilities)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OverrideKeyFrame(&self, framenumber: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(framenumber)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(framenumber), ::core::mem::transmute(size)).ok()
    }
}
impl ::core::convert::From<IAMVideoCompression> for ::windows::core::IUnknown {
    fn from(value: IAMVideoCompression) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoCompression> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoCompression) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoCompression {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoCompression {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoCompression {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoCompression {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoCompression {}
impl ::core::fmt::Debug for IAMVideoCompression {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoCompression").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoCompression {
    type Vtable = IAMVideoCompressionVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13343_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoCompressionVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, keyframerate: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkeyframerate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pframesperkeyframe: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppframesperkeyframe: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, quality: f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pquality: *mut f64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, windowsize: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwindowsize: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszversion: super::super::Foundation::PWSTR, pcbversion: *mut i32, pszdescription: super::super::Foundation::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, framenumber: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, framenumber: i32, size: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoControl(::windows::core::IUnknown);
impl IAMVideoControl {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCaps<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMode<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0, mode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(mode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetMode<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCurrentActualFrameRate<'a, Param0: ::windows::core::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMaxAvailableFrameRate<'a, Param0: ::windows::core::IntoParam<'a, IPin>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, ppin: Param0, iindex: i32, dimensions: Param2) -> ::windows::core::Result<i64> {
        let mut result__: i64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(iindex), dimensions.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFrameRateList<'a, Param0: ::windows::core::IntoParam<'a, IPin>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, ppin: Param0, iindex: i32, dimensions: Param2, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ppin.into_param().abi(), ::core::mem::transmute(iindex), dimensions.into_param().abi(), ::core::mem::transmute(listsize), ::core::mem::transmute(framerates)).ok()
    }
}
impl ::core::convert::From<IAMVideoControl> for ::windows::core::IUnknown {
    fn from(value: IAMVideoControl) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoControl> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoControl) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoControl {}
impl ::core::fmt::Debug for IAMVideoControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoControl {
    type Vtable = IAMVideoControlVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6a2e0670_28e4_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoControlVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, pcapsflags: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, mode: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, mode: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, actualframerate: *mut i64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, iindex: i32, dimensions: super::super::Foundation::SIZE, maxavailableframerate: *mut i64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: ::windows::core::RawPtr, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoDecimationProperties(::windows::core::IUnknown);
impl IAMVideoDecimationProperties {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn QueryDecimationUsage(&self) -> ::windows::core::Result<DECIMATION_USAGE> {
        let mut result__: DECIMATION_USAGE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<DECIMATION_USAGE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(usage)).ok()
    }
}
impl ::core::convert::From<IAMVideoDecimationProperties> for ::windows::core::IUnknown {
    fn from(value: IAMVideoDecimationProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoDecimationProperties> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoDecimationProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoDecimationProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoDecimationProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoDecimationProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoDecimationProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoDecimationProperties {}
impl ::core::fmt::Debug for IAMVideoDecimationProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoDecimationProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoDecimationProperties {
    type Vtable = IAMVideoDecimationPropertiesVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x60d32930_13da_11d3_9ec6_c4fcaef5c7be);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoDecimationPropertiesVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpusage: *mut DECIMATION_USAGE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usage: DECIMATION_USAGE) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMVideoProcAmp(::windows::core::IUnknown);
impl IAMVideoProcAmp {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(pmin), ::core::mem::transmute(pmax), ::core::mem::transmute(psteppingdelta), ::core::mem::transmute(pdefault), ::core::mem::transmute(pcapsflags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(lvalue), ::core::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(property), ::core::mem::transmute(lvalue), ::core::mem::transmute(flags)).ok()
    }
}
impl ::core::convert::From<IAMVideoProcAmp> for ::windows::core::IUnknown {
    fn from(value: IAMVideoProcAmp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMVideoProcAmp> for ::windows::core::IUnknown {
    fn from(value: &IAMVideoProcAmp) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMVideoProcAmp {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMVideoProcAmp {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMVideoProcAmp {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMVideoProcAmp {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoProcAmp {}
impl ::core::fmt::Debug for IAMVideoProcAmp {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoProcAmp").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMVideoProcAmp {
    type Vtable = IAMVideoProcAmpVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6e13360_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoProcAmpVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMWstDecoder(::windows::core::IUnknown);
impl IAMWstDecoder {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(lplevel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpservice)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpstate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetServiceState(&self, state: AM_WST_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpbmih)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpbmi)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwphyscolor)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwphyscolor)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpboption)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRedrawAlways<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, boption: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), boption.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(mode)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAnswerMode<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, banswer: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), banswer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAnswerMode(&self, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbanswer)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHoldPage<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bholdpage: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), bholdpage.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetHoldPage(&self, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbholdpage)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(pwstpage)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCurrentPage<'a, Param0: ::windows::core::IntoParam<'a, AM_WST_PAGE>>(&self, wstpage: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), wstpage.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAMWstDecoder> for ::windows::core::IUnknown {
    fn from(value: IAMWstDecoder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMWstDecoder> for ::windows::core::IUnknown {
    fn from(value: &IAMWstDecoder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMWstDecoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMWstDecoder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMWstDecoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMWstDecoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMWstDecoder {}
impl ::core::fmt::Debug for IAMWstDecoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMWstDecoder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMWstDecoder {
    type Vtable = IAMWstDecoderVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMWstDecoderVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplevel: *mut AM_WST_LEVEL) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpservice: *mut AM_WST_SERVICE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstate: *mut AM_WST_STATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: AM_WST_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwphyscolor: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwphyscolor: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpboption: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, boption: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: AM_WST_DRAWBGMODE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, banswer: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bholdpage: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwstpage: *mut AM_WST_PAGE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wstpage: AM_WST_PAGE) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IAMovieSetup(::windows::core::IUnknown);
impl IAMovieSetup {
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Register(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Unregister(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAMovieSetup> for ::windows::core::IUnknown {
    fn from(value: IAMovieSetup) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAMovieSetup> for ::windows::core::IUnknown {
    fn from(value: &IAMovieSetup) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAMovieSetup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAMovieSetup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAMovieSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAMovieSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMovieSetup {}
impl ::core::fmt::Debug for IAMovieSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMovieSetup").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAMovieSetup {
    type Vtable = IAMovieSetupVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3d8cec0_7e5a_11cf_bbc5_00805f6cef20);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMovieSetupVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IATSCChannelTuneRequest(::windows::core::IUnknown);
impl IATSCChannelTuneRequest {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::core::Result<ITuningSpace> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITuningSpace>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Components(&self) -> ::windows::core::Result<IComponents> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IComponents>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ITuneRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITuneRequest>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Locator(&self) -> ::windows::core::Result<ILocator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetLocator<'a, Param0: ::windows::core::IntoParam<'a, ILocator>>(&self, locator: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), locator.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Channel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetChannel(&self, channel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(channel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MinorChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMinorChannel(&self, minorchannel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(minorchannel)).ok()
    }
}
impl ::core::convert::From<IATSCChannelTuneRequest> for IChannelTuneRequest {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCChannelTuneRequest> for IChannelTuneRequest {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IChannelTuneRequest> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, IChannelTuneRequest> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IChannelTuneRequest> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, IChannelTuneRequest> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCChannelTuneRequest> for ITuneRequest {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCChannelTuneRequest> for ITuneRequest {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ITuneRequest> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, ITuneRequest> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ITuneRequest> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, ITuneRequest> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IATSCChannelTuneRequest> for super::super::System::Com::IDispatch {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IATSCChannelTuneRequest> for super::super::System::Com::IDispatch {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCChannelTuneRequest> for ::windows::core::IUnknown {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCChannelTuneRequest> for ::windows::core::IUnknown {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IATSCChannelTuneRequest {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IATSCChannelTuneRequest {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IATSCChannelTuneRequest {}
impl ::core::fmt::Debug for IATSCChannelTuneRequest {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IATSCChannelTuneRequest").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IATSCChannelTuneRequest {
    type Vtable = IATSCChannelTuneRequestVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0369b4e1_45b6_11d3_b650_00c04f79498e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCChannelTuneRequestVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tuningspace: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, components: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newtunerequest: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locator: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, channel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, channel: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, minorchannel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, minorchannel: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IATSCComponentType(::windows::core::IUnknown);
impl IATSCComponentType {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Category(&self) -> ::windows::core::Result<ComponentCategory> {
        let mut result__: ComponentCategory = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ComponentCategory>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCategory(&self, category: ComponentCategory) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(category)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaMajorType(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMediaMajorType<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediamajortype: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), mediamajortype.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn _MediaMajorType(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set_MediaMajorType(&self, mediamajortypeguid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(mediamajortypeguid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaSubType(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMediaSubType<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediasubtype: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), mediasubtype.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn _MediaSubType(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set_MediaSubType(&self, mediasubtypeguid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(mediasubtypeguid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaFormatType(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMediaFormatType<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediaformattype: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), mediaformattype.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn _MediaFormatType(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set_MediaFormatType(&self, mediaformattypeguid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(mediaformattypeguid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MediaType(&self) -> ::windows::core::Result<AM_MEDIA_TYPE> {
        let mut result__: ::core::mem::ManuallyDrop<AM_MEDIA_TYPE> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<AM_MEDIA_TYPE>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMediaType(&self, mediatype: *const AM_MEDIA_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(mediatype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IComponentType> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IComponentType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn LangID(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetLangID(&self, langid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(langid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn StreamType(&self) -> ::windows::core::Result<MPEG2StreamType> {
        let mut result__: MPEG2StreamType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<MPEG2StreamType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetStreamType(&self, mp2streamtype: MPEG2StreamType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(mp2streamtype)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Flags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetFlags(&self, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
}
impl ::core::convert::From<IATSCComponentType> for IMPEG2ComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCComponentType> for IMPEG2ComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMPEG2ComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, IMPEG2ComponentType> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IMPEG2ComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, IMPEG2ComponentType> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCComponentType> for ILanguageComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCComponentType> for ILanguageComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILanguageComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, ILanguageComponentType> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILanguageComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, ILanguageComponentType> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCComponentType> for IComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCComponentType> for IComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, IComponentType> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, IComponentType> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IATSCComponentType> for super::super::System::Com::IDispatch {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IATSCComponentType> for super::super::System::Com::IDispatch {
    fn from(value: &IATSCComponentType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCComponentType> for ::windows::core::IUnknown {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCComponentType> for ::windows::core::IUnknown {
    fn from(value: &IATSCComponentType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IATSCComponentType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IATSCComponentType {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IATSCComponentType {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IATSCComponentType {}
impl ::core::fmt::Debug for IATSCComponentType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IATSCComponentType").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IATSCComponentType {
    type Vtable = IATSCComponentTypeVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfc189e4d_7bd4_4125_b3b3_3a76a332cc96);
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCComponentTypeVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, category: *mut ComponentCategory) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, category: ComponentCategory) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediamajortype: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediamajortype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediamajortypeguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediamajortypeguid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediasubtype: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediasubtype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediasubtypeguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediasubtypeguid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediaformattype: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediaformattype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediaformattypeguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediaformattypeguid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediatype: *mut AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mediatype: *const AM_MEDIA_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newct: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, langid: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, langid: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mp2streamtype: *mut MPEG2StreamType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mp2streamtype: MPEG2StreamType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IATSCLocator(::windows::core::IUnknown);
impl IATSCLocator {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CarrierFrequency(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCarrierFrequency(&self, frequency: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(frequency)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InnerFEC(&self) -> ::windows::core::Result<FECMethod> {
        let mut result__: FECMethod = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInnerFEC(&self, fec: FECMethod) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InnerFECRate(&self) -> ::windows::core::Result<BinaryConvolutionCodeRate> {
        let mut result__: BinaryConvolutionCodeRate = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInnerFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OuterFEC(&self) -> ::windows::core::Result<FECMethod> {
        let mut result__: FECMethod = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOuterFEC(&self, fec: FECMethod) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OuterFECRate(&self) -> ::windows::core::Result<BinaryConvolutionCodeRate> {
        let mut result__: BinaryConvolutionCodeRate = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOuterFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Modulation(&self) -> ::windows::core::Result<ModulationType> {
        let mut result__: ModulationType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ModulationType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetModulation(&self, modulation: ModulationType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(modulation)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SymbolRate(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetSymbolRate(&self, rate: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(rate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ILocator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PhysicalChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPhysicalChannel(&self, physicalchannel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(physicalchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TSID(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTSID(&self, tsid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(tsid)).ok()
    }
}
impl ::core::convert::From<IATSCLocator> for IDigitalLocator {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator> for IDigitalLocator {
    fn from(value: &IATSCLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDigitalLocator> for IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, IDigitalLocator> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDigitalLocator> for &IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, IDigitalLocator> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCLocator> for ILocator {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator> for ILocator {
    fn from(value: &IATSCLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILocator> for IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ILocator> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILocator> for &IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ILocator> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IATSCLocator> for super::super::System::Com::IDispatch {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IATSCLocator> for super::super::System::Com::IDispatch {
    fn from(value: &IATSCLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCLocator> for ::windows::core::IUnknown {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator> for ::windows::core::IUnknown {
    fn from(value: &IATSCLocator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IATSCLocator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IATSCLocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IATSCLocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IATSCLocator {}
impl ::core::fmt::Debug for IATSCLocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IATSCLocator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IATSCLocator {
    type Vtable = IATSCLocatorVtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbf8d986f_8c2b_4131_94d7_4d3d9fcc21ef);
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocatorVtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, frequency: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, frequency: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modulation: *mut ModulationType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modulation: ModulationType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rate: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newlocator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, physicalchannel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, physicalchannel: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tsid: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tsid: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IATSCLocator2(::windows::core::IUnknown);
impl IATSCLocator2 {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CarrierFrequency(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCarrierFrequency(&self, frequency: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(frequency)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InnerFEC(&self) -> ::windows::core::Result<FECMethod> {
        let mut result__: FECMethod = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInnerFEC(&self, fec: FECMethod) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InnerFECRate(&self) -> ::windows::core::Result<BinaryConvolutionCodeRate> {
        let mut result__: BinaryConvolutionCodeRate = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInnerFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OuterFEC(&self) -> ::windows::core::Result<FECMethod> {
        let mut result__: FECMethod = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOuterFEC(&self, fec: FECMethod) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn OuterFECRate(&self) -> ::windows::core::Result<BinaryConvolutionCodeRate> {
        let mut result__: BinaryConvolutionCodeRate = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetOuterFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Modulation(&self) -> ::windows::core::Result<ModulationType> {
        let mut result__: ModulationType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ModulationType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetModulation(&self, modulation: ModulationType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(modulation)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SymbolRate(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetSymbolRate(&self, rate: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(rate)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ILocator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn PhysicalChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetPhysicalChannel(&self, physicalchannel: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(physicalchannel)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn TSID(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetTSID(&self, tsid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(tsid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn ProgramNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetProgramNumber(&self, programnumber: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(programnumber)).ok()
    }
}
impl ::core::convert::From<IATSCLocator2> for IATSCLocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator2> for IATSCLocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IATSCLocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, IATSCLocator> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IATSCLocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, IATSCLocator> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCLocator2> for IDigitalLocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator2> for IDigitalLocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDigitalLocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDigitalLocator> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDigitalLocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDigitalLocator> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCLocator2> for ILocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator2> for ILocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, ILocator> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ILocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, ILocator> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IATSCLocator2> for super::super::System::Com::IDispatch {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IATSCLocator2> for super::super::System::Com::IDispatch {
    fn from(value: &IATSCLocator2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IATSCLocator2> for ::windows::core::IUnknown {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IATSCLocator2> for ::windows::core::IUnknown {
    fn from(value: &IATSCLocator2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IATSCLocator2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IATSCLocator2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IATSCLocator2 {}
impl ::core::fmt::Debug for IATSCLocator2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IATSCLocator2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IATSCLocator2 {
    type Vtable = IATSCLocator2Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x612aa885_66cf_4090_ba0a_566f5312e4ca);
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocator2Vtbl(
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iid: &::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctinfo: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, frequency: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, frequency: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: FECMethod) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: *mut BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fec: BinaryConvolutionCodeRate) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modulation: *mut ModulationType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modulation: ModulationType) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rate: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rate: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newlocator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, physicalchannel: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, physicalchannel: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tsid: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tsid: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, programnumber: *mut i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void, programnumber: i32) -> ::windows::core::HRESULT,
);
#[doc = "*Required features: 'Win32_Media_DirectShow'*"]
#[repr(transparent)]
pub struct IATSCTuningSpace(::windows::core::IUnknown);
impl IATSCTuningSpace {
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UniqueName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUniqueName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, name: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FriendlyName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFriendlyName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, name: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CLSID(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NetworkType(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNetworkType<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, networktypeguid: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), networktypeguid.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn _NetworkType(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Set_NetworkType(&self, networktypeguid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(networktypeguid)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CreateTuneRequest(&self) -> ::windows::core::Result<ITuneRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITuneRequest>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategoryGUIDs(&self) -> ::windows::core::Result<super::super::System::Com::IEnumGUID> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumDeviceMonikers(&self) -> ::windows::core::Result<super::super::System::Com::IEnumMoniker> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IEnumMoniker>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn DefaultPreferredComponentTypes(&self) -> ::windows::core::Result<IComponentTypes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<IComponentTypes>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDefaultPreferredComponentTypes<'a, Param0: ::windows::core::IntoParam<'a, IComponentTypes>>(&self, newcomponenttypes: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), newcomponenttypes.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FrequencyMapping(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFrequencyMapping<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mapping: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), mapping.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn DefaultLocator(&self) -> ::windows::core::Result<ILocator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetDefaultLocator<'a, Param0: ::windows::core::IntoParam<'a, ILocator>>(&self, locatorval: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), locatorval.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ITuningSpace> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITuningSpace>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MinChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMinChannel(&self, newminchannelval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), ::core::mem::transmute(newminchannelval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MaxChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMaxChannel(&self, newmaxchannelval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), ::core::mem::transmute(newmaxchannelval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn InputType(&self) -> ::windows::core::Result<TunerInputType> {
        let mut result__: TunerInputType = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<TunerInputType>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetInputType(&self, newinputtypeval: TunerInputType) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), ::core::mem::transmute(newinputtypeval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn CountryCode(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetCountryCode(&self, newcountrycodeval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), ::core::mem::transmute(newcountrycodeval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MinMinorChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMinMinorChannel(&self, newminminorchannelval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), ::core::mem::transmute(newminminorchannelval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MaxMinorChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMaxMinorChannel(&self, newmaxminorchannelval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), ::core::mem::transmute(newmaxminorchannelval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MinPhysicalChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn SetMinPhysicalChannel(&self, newminphysicalchannelval: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), ::core::mem::transmute(newminphysicalchannelval)).ok()
    }
    #[doc = "*Required features: 'Win32_Media_DirectShow'*"]
    pub unsafe fn MaxPhysicalChannel(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[