#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[cfg(feature = "Win32_System_Diagnostics_Debug_WebApp")]
pub mod WebApp;
pub const ACTIVPROF_E_PROFILER_ABSENT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147220991i32 as _);
pub const ACTIVPROF_E_PROFILER_PRESENT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147220992i32 as _);
pub const ACTIVPROF_E_UNABLE_TO_APPLY_ACTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147220990i32 as _);
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86",))]
pub struct ADDRESS {
    pub Offset: u32,
    pub Segment: u16,
    pub Mode: ADDRESS_MODE,
}
#[cfg(any(target_arch = "x86",))]
impl ADDRESS {}
#[cfg(any(target_arch = "x86",))]
impl ::core::default::Default for ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::core::fmt::Debug for ADDRESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("ADDRESS").field("Offset", &self.Offset).field("Segment", &self.Segment).field("Mode", &self.Mode).finish()
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::core::cmp::PartialEq for ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Segment == other.Segment && self.Mode == other.Mode
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::core::cmp::Eq for ADDRESS {}
#[cfg(any(target_arch = "x86",))]
unsafe impl ::windows::core::Abi for ADDRESS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct ADDRESS64 {
    pub Offset: u64,
    pub Segment: u16,
    pub Mode: ADDRESS_MODE,
}
impl ADDRESS64 {}
impl ::core::default::Default for ADDRESS64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ADDRESS64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("ADDRESS64").field("Offset", &self.Offset).field("Segment", &self.Segment).field("Mode", &self.Mode).finish()
    }
}
impl ::core::cmp::PartialEq for ADDRESS64 {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Segment == other.Segment && self.Mode == other.Mode
    }
}
impl ::core::cmp::Eq for ADDRESS64 {}
unsafe impl ::windows::core::Abi for ADDRESS64 {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct ADDRESS_MODE(pub i32);
pub const AddrMode1616: ADDRESS_MODE = ADDRESS_MODE(0i32);
pub const AddrMode1632: ADDRESS_MODE = ADDRESS_MODE(1i32);
pub const AddrModeReal: ADDRESS_MODE = ADDRESS_MODE(2i32);
pub const AddrModeFlat: ADDRESS_MODE = ADDRESS_MODE(3i32);
impl ::core::convert::From<i32> for ADDRESS_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for ADDRESS_MODE {
    type Abi = Self;
}
pub const ADDRESS_TYPE_INDEX_NOT_FOUND: u32 = 11u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub union AER_BRIDGE_DESCRIPTOR_FLAGS {
    pub Anonymous: AER_BRIDGE_DESCRIPTOR_FLAGS_0,
    pub AsUSHORT: u16,
}
impl AER_BRIDGE_DESCRIPTOR_FLAGS {}
impl ::core::default::Default for AER_BRIDGE_DESCRIPTOR_FLAGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_BRIDGE_DESCRIPTOR_FLAGS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_BRIDGE_DESCRIPTOR_FLAGS {}
unsafe impl ::windows::core::Abi for AER_BRIDGE_DESCRIPTOR_FLAGS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct AER_BRIDGE_DESCRIPTOR_FLAGS_0 {
    pub _bitfield: u16,
}
impl AER_BRIDGE_DESCRIPTOR_FLAGS_0 {}
impl ::core::default::Default for AER_BRIDGE_DESCRIPTOR_FLAGS_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_BRIDGE_DESCRIPTOR_FLAGS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_BRIDGE_DESCRIPTOR_FLAGS_0 {}
unsafe impl ::windows::core::Abi for AER_BRIDGE_DESCRIPTOR_FLAGS_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub union AER_ENDPOINT_DESCRIPTOR_FLAGS {
    pub Anonymous: AER_ENDPOINT_DESCRIPTOR_FLAGS_0,
    pub AsUSHORT: u16,
}
impl AER_ENDPOINT_DESCRIPTOR_FLAGS {}
impl ::core::default::Default for AER_ENDPOINT_DESCRIPTOR_FLAGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_ENDPOINT_DESCRIPTOR_FLAGS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_ENDPOINT_DESCRIPTOR_FLAGS {}
unsafe impl ::windows::core::Abi for AER_ENDPOINT_DESCRIPTOR_FLAGS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {
    pub _bitfield: u16,
}
impl AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {}
impl ::core::default::Default for AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {}
unsafe impl ::windows::core::Abi for AER_ENDPOINT_DESCRIPTOR_FLAGS_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub union AER_ROOTPORT_DESCRIPTOR_FLAGS {
    pub Anonymous: AER_ROOTPORT_DESCRIPTOR_FLAGS_0,
    pub AsUSHORT: u16,
}
impl AER_ROOTPORT_DESCRIPTOR_FLAGS {}
impl ::core::default::Default for AER_ROOTPORT_DESCRIPTOR_FLAGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_ROOTPORT_DESCRIPTOR_FLAGS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_ROOTPORT_DESCRIPTOR_FLAGS {}
unsafe impl ::windows::core::Abi for AER_ROOTPORT_DESCRIPTOR_FLAGS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {
    pub _bitfield: u16,
}
impl AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {}
impl ::core::default::Default for AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {}
unsafe impl ::windows::core::Abi for AER_ROOTPORT_DESCRIPTOR_FLAGS_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct API_VERSION {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub Revision: u16,
    pub Reserved: u16,
}
impl API_VERSION {}
impl ::core::default::Default for API_VERSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for API_VERSION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("API_VERSION").field("MajorVersion", &self.MajorVersion).field("MinorVersion", &self.MinorVersion).field("Revision", &self.Revision).field("Reserved", &self.Reserved).finish()
    }
}
impl ::core::cmp::PartialEq for API_VERSION {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion && self.Revision == other.Revision && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for API_VERSION {}
unsafe impl ::windows::core::Abi for API_VERSION {
    type Abi = Self;
}
pub const API_VERSION_NUMBER: u32 = 12u32;
pub const APPBREAKFLAG_DEBUGGER_BLOCK: u32 = 1u32;
pub const APPBREAKFLAG_DEBUGGER_HALT: u32 = 2u32;
pub const APPBREAKFLAG_IN_BREAKPOINT: u32 = 2147483648u32;
pub const APPBREAKFLAG_NESTED: u32 = 131072u32;
pub const APPBREAKFLAG_STEP: u32 = 65536u32;
pub const APPBREAKFLAG_STEPTYPE_BYTECODE: u32 = 1048576u32;
pub const APPBREAKFLAG_STEPTYPE_MACHINE: u32 = 2097152u32;
pub const APPBREAKFLAG_STEPTYPE_MASK: u32 = 15728640u32;
pub const APPBREAKFLAG_STEPTYPE_SOURCE: u32 = 0u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct APPLICATION_NODE_EVENT_FILTER(pub i32);
pub const FILTER_EXCLUDE_NOTHING: APPLICATION_NODE_EVENT_FILTER = APPLICATION_NODE_EVENT_FILTER(0i32);
pub const FILTER_EXCLUDE_ANONYMOUS_CODE: APPLICATION_NODE_EVENT_FILTER = APPLICATION_NODE_EVENT_FILTER(1i32);
pub const FILTER_EXCLUDE_EVAL_CODE: APPLICATION_NODE_EVENT_FILTER = APPLICATION_NODE_EVENT_FILTER(2i32);
impl ::core::convert::From<i32> for APPLICATION_NODE_EVENT_FILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_NODE_EVENT_FILTER {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
pub struct ARM64_NT_CONTEXT {
    pub ContextFlags: u32,
    pub Cpsr: u32,
    pub Anonymous: ARM64_NT_CONTEXT_0,
    pub Sp: u64,
    pub Pc: u64,
    pub V: [ARM64_NT_NEON128; 32],
    pub Fpcr: u32,
    pub Fpsr: u32,
    pub Bcr: [u32; 8],
    pub Bvr: [u64; 8],
    pub Wcr: [u32; 2],
    pub Wvr: [u64; 2],
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::default::Default for ARM64_NT_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::PartialEq for ARM64_NT_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::Eq for ARM64_NT_CONTEXT {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::core::Abi for ARM64_NT_CONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
pub union ARM64_NT_CONTEXT_0 {
    pub Anonymous: ARM64_NT_CONTEXT_0_0,
    pub X: [u64; 31],
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::default::Default for ARM64_NT_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::PartialEq for ARM64_NT_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::Eq for ARM64_NT_CONTEXT_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::core::Abi for ARM64_NT_CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
pub struct ARM64_NT_CONTEXT_0_0 {
    pub X0: u64,
    pub X1: u64,
    pub X2: u64,
    pub X3: u64,
    pub X4: u64,
    pub X5: u64,
    pub X6: u64,
    pub X7: u64,
    pub X8: u64,
    pub X9: u64,
    pub X10: u64,
    pub X11: u64,
    pub X12: u64,
    pub X13: u64,
    pub X14: u64,
    pub X15: u64,
    pub X16: u64,
    pub X17: u64,
    pub X18: u64,
    pub X19: u64,
    pub X20: u64,
    pub X21: u64,
    pub X22: u64,
    pub X23: u64,
    pub X24: u64,
    pub X25: u64,
    pub X26: u64,
    pub X27: u64,
    pub X28: u64,
    pub Fp: u64,
    pub Lr: u64,
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::default::Default for ARM64_NT_CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::fmt::Debug for ARM64_NT_CONTEXT_0_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("X0", &self.X0)
            .field("X1", &self.X1)
            .field("X2", &self.X2)
            .field("X3", &self.X3)
            .field("X4", &self.X4)
            .field("X5", &self.X5)
            .field("X6", &self.X6)
            .field("X7", &self.X7)
            .field("X8", &self.X8)
            .field("X9", &self.X9)
            .field("X10", &self.X10)
            .field("X11", &self.X11)
            .field("X12", &self.X12)
            .field("X13", &self.X13)
            .field("X14", &self.X14)
            .field("X15", &self.X15)
            .field("X16", &self.X16)
            .field("X17", &self.X17)
            .field("X18", &self.X18)
            .field("X19", &self.X19)
            .field("X20", &self.X20)
            .field("X21", &self.X21)
            .field("X22", &self.X22)
            .field("X23", &self.X23)
            .field("X24", &self.X24)
            .field("X25", &self.X25)
            .field("X26", &self.X26)
            .field("X27", &self.X27)
            .field("X28", &self.X28)
            .field("Fp", &self.Fp)
            .field("Lr", &self.Lr)
            .finish()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::PartialEq for ARM64_NT_CONTEXT_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.X0 == other.X0
            && self.X1 == other.X1
            && self.X2 == other.X2
            && self.X3 == other.X3
            && self.X4 == other.X4
            && self.X5 == other.X5
            && self.X6 == other.X6
            && self.X7 == other.X7
            && self.X8 == other.X8
            && self.X9 == other.X9
            && self.X10 == other.X10
            && self.X11 == other.X11
            && self.X12 == other.X12
            && self.X13 == other.X13
            && self.X14 == other.X14
            && self.X15 == other.X15
            && self.X16 == other.X16
            && self.X17 == other.X17
            && self.X18 == other.X18
            && self.X19 == other.X19
            && self.X20 == other.X20
            && self.X21 == other.X21
            && self.X22 == other.X22
            && self.X23 == other.X23
            && self.X24 == other.X24
            && self.X25 == other.X25
            && self.X26 == other.X26
            && self.X27 == other.X27
            && self.X28 == other.X28
            && self.Fp == other.Fp
            && self.Lr == other.Lr
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::core::cmp::Eq for ARM64_NT_CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::core::Abi for ARM64_NT_CONTEXT_0_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub union ARM64_NT_NEON128 {
    pub Anonymous: ARM64_NT_NEON128_0,
    pub D: [f64; 2],
    pub S: [f32; 4],
    pub H: [u16; 8],
    pub B: [u8; 16],
}
impl ARM64_NT_NEON128 {}
impl ::core::default::Default for ARM64_NT_NEON128 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for ARM64_NT_NEON128 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for ARM64_NT_NEON128 {}
unsafe impl ::windows::core::Abi for ARM64_NT_NEON128 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct ARM64_NT_NEON128_0 {
    pub Low: u64,
    pub High: i64,
}
impl ARM64_NT_NEON128_0 {}
impl ::core::default::Default for ARM64_NT_NEON128_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ARM64_NT_NEON128_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("Low", &self.Low).field("High", &self.High).finish()
    }
}
impl ::core::cmp::PartialEq for ARM64_NT_NEON128_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Low == other.Low && self.High == other.High
    }
}
impl ::core::cmp::Eq for ARM64_NT_NEON128_0 {}
unsafe impl ::windows::core::Abi for ARM64_NT_NEON128_0 {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn AddVectoredContinueHandler(first: u32, handler: ::core::option::Option<PVECTORED_EXCEPTION_HANDLER>) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddVectoredContinueHandler(first: u32, handler: ::windows::core::RawPtr) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(AddVectoredContinueHandler(::core::mem::transmute(first), ::core::mem::transmute(handler)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn AddVectoredExceptionHandler(first: u32, handler: ::core::option::Option<PVECTORED_EXCEPTION_HANDLER>) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddVectoredExceptionHandler(first: u32, handler: ::windows::core::RawPtr) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(AddVectoredExceptionHandler(::core::mem::transmute(first), ::core::mem::transmute(handler)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct ArrayDimension {
    pub LowerBound: i64,
    pub Length: u64,
    pub Stride: u64,
}
impl ArrayDimension {}
impl ::core::default::Default for ArrayDimension {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ArrayDimension {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("ArrayDimension").field("LowerBound", &self.LowerBound).field("Length", &self.Length).field("Stride", &self.Stride).finish()
    }
}
impl ::core::cmp::PartialEq for ArrayDimension {
    fn eq(&self, other: &Self) -> bool {
        self.LowerBound == other.LowerBound && self.Length == other.Length && self.Stride == other.Stride
    }
}
impl ::core::cmp::Eq for ArrayDimension {}
unsafe impl ::windows::core::Abi for ArrayDimension {
    type Abi = Self;
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct AsyncIDebugApplicationNodeEvents(pub ::windows::core::IUnknown);
impl AsyncIDebugApplicationNodeEvents {
    pub unsafe fn Begin_onAddChild<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpchild: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onAddChild(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Begin_onRemoveChild<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpchild: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onRemoveChild(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Begin_onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Finish_onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Begin_onAttach<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpparent: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), prddpparent.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onAttach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for AsyncIDebugApplicationNodeEvents {
    type Vtable = AsyncIDebugApplicationNodeEvents_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa2e3aa3b_aa8d_4ebf_84cd_648b737b8c13);
}
impl ::core::convert::From<AsyncIDebugApplicationNodeEvents> for ::windows::core::IUnknown {
    fn from(value: AsyncIDebugApplicationNodeEvents) -> Self {
        value.0
    }
}
impl ::core::convert::From<&AsyncIDebugApplicationNodeEvents> for ::windows::core::IUnknown {
    fn from(value: &AsyncIDebugApplicationNodeEvents) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for AsyncIDebugApplicationNodeEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a AsyncIDebugApplicationNodeEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct AsyncIDebugApplicationNodeEvents_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpchild: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpchild: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpparent: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
pub const BIND_ALL_IMAGES: u32 = 4u32;
pub const BIND_CACHE_IMPORT_DLLS: u32 = 8u32;
pub const BIND_NO_BOUND_IMPORTS: u32 = 1u32;
pub const BIND_NO_UPDATE: u32 = 2u32;
pub const BIND_REPORT_64BIT_VA: u32 = 16u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct BREAKPOINT_STATE(pub i32);
pub const BREAKPOINT_DELETED: BREAKPOINT_STATE = BREAKPOINT_STATE(0i32);
pub const BREAKPOINT_DISABLED: BREAKPOINT_STATE = BREAKPOINT_STATE(1i32);
pub const BREAKPOINT_ENABLED: BREAKPOINT_STATE = BREAKPOINT_STATE(2i32);
impl ::core::convert::From<i32> for BREAKPOINT_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for BREAKPOINT_STATE {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct BREAKREASON(pub i32);
pub const BREAKREASON_STEP: BREAKREASON = BREAKREASON(0i32);
pub const BREAKREASON_BREAKPOINT: BREAKREASON = BREAKREASON(1i32);
pub const BREAKREASON_DEBUGGER_BLOCK: BREAKREASON = BREAKREASON(2i32);
pub const BREAKREASON_HOST_INITIATED: BREAKREASON = BREAKREASON(3i32);
pub const BREAKREASON_LANGUAGE_INITIATED: BREAKREASON = BREAKREASON(4i32);
pub const BREAKREASON_DEBUGGER_HALT: BREAKREASON = BREAKREASON(5i32);
pub const BREAKREASON_ERROR: BREAKREASON = BREAKREASON(6i32);
pub const BREAKREASON_JIT: BREAKREASON = BREAKREASON(7i32);
pub const BREAKREASON_MUTATION_BREAKPOINT: BREAKREASON = BREAKREASON(8i32);
impl ::core::convert::From<i32> for BREAKREASON {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for BREAKREASON {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct BREAKRESUME_ACTION(pub i32);
pub const BREAKRESUMEACTION_ABORT: BREAKRESUME_ACTION = BREAKRESUME_ACTION(0i32);
pub const BREAKRESUMEACTION_CONTINUE: BREAKRESUME_ACTION = BREAKRESUME_ACTION(1i32);
pub const BREAKRESUMEACTION_STEP_INTO: BREAKRESUME_ACTION = BREAKRESUME_ACTION(2i32);
pub const BREAKRESUMEACTION_STEP_OVER: BREAKRESUME_ACTION = BREAKRESUME_ACTION(3i32);
pub const BREAKRESUMEACTION_STEP_OUT: BREAKRESUME_ACTION = BREAKRESUME_ACTION(4i32);
pub const BREAKRESUMEACTION_IGNORE: BREAKRESUME_ACTION = BREAKRESUME_ACTION(5i32);
pub const BREAKRESUMEACTION_STEP_DOCUMENT: BREAKRESUME_ACTION = BREAKRESUME_ACTION(6i32);
impl ::core::convert::From<i32> for BREAKRESUME_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for BREAKRESUME_ACTION {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct BUGCHECK_ERROR(pub u32);
pub const HARDWARE_PROFILE_UNDOCKED_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073807361u32);
pub const HARDWARE_PROFILE_DOCKED_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073807362u32);
pub const HARDWARE_PROFILE_UNKNOWN_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073807363u32);
pub const WINDOWS_NT_BANNER: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741950u32);
pub const WINDOWS_NT_CSD_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741959u32);
pub const WINDOWS_NT_INFO_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741960u32);
pub const WINDOWS_NT_MP_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741961u32);
pub const THREAD_TERMINATE_HELD_MUTEX: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741962u32);
pub const WINDOWS_NT_INFO_STRING_PLURAL: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741981u32);
pub const WINDOWS_NT_RC_STRING: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741982u32);
pub const APC_INDEX_MISMATCH: BUGCHECK_ERROR = BUGCHECK_ERROR(1u32);
pub const DEVICE_QUEUE_NOT_BUSY: BUGCHECK_ERROR = BUGCHECK_ERROR(2u32);
pub const INVALID_AFFINITY_SET: BUGCHECK_ERROR = BUGCHECK_ERROR(3u32);
pub const INVALID_DATA_ACCESS_TRAP: BUGCHECK_ERROR = BUGCHECK_ERROR(4u32);
pub const INVALID_PROCESS_ATTACH_ATTEMPT: BUGCHECK_ERROR = BUGCHECK_ERROR(5u32);
pub const INVALID_PROCESS_DETACH_ATTEMPT: BUGCHECK_ERROR = BUGCHECK_ERROR(6u32);
pub const INVALID_SOFTWARE_INTERRUPT: BUGCHECK_ERROR = BUGCHECK_ERROR(7u32);
pub const IRQL_NOT_DISPATCH_LEVEL: BUGCHECK_ERROR = BUGCHECK_ERROR(8u32);
pub const IRQL_NOT_GREATER_OR_EQUAL: BUGCHECK_ERROR = BUGCHECK_ERROR(9u32);
pub const IRQL_NOT_LESS_OR_EQUAL: BUGCHECK_ERROR = BUGCHECK_ERROR(10u32);
pub const NO_EXCEPTION_HANDLING_SUPPORT: BUGCHECK_ERROR = BUGCHECK_ERROR(11u32);
pub const MAXIMUM_WAIT_OBJECTS_EXCEEDED: BUGCHECK_ERROR = BUGCHECK_ERROR(12u32);
pub const MUTEX_LEVEL_NUMBER_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(13u32);
pub const NO_USER_MODE_CONTEXT: BUGCHECK_ERROR = BUGCHECK_ERROR(14u32);
pub const SPIN_LOCK_ALREADY_OWNED: BUGCHECK_ERROR = BUGCHECK_ERROR(15u32);
pub const SPIN_LOCK_NOT_OWNED: BUGCHECK_ERROR = BUGCHECK_ERROR(16u32);
pub const THREAD_NOT_MUTEX_OWNER: BUGCHECK_ERROR = BUGCHECK_ERROR(17u32);
pub const TRAP_CAUSE_UNKNOWN: BUGCHECK_ERROR = BUGCHECK_ERROR(18u32);
pub const EMPTY_THREAD_REAPER_LIST: BUGCHECK_ERROR = BUGCHECK_ERROR(19u32);
pub const CREATE_DELETE_LOCK_NOT_LOCKED: BUGCHECK_ERROR = BUGCHECK_ERROR(20u32);
pub const LAST_CHANCE_CALLED_FROM_KMODE: BUGCHECK_ERROR = BUGCHECK_ERROR(21u32);
pub const CID_HANDLE_CREATION: BUGCHECK_ERROR = BUGCHECK_ERROR(22u32);
pub const CID_HANDLE_DELETION: BUGCHECK_ERROR = BUGCHECK_ERROR(23u32);
pub const REFERENCE_BY_POINTER: BUGCHECK_ERROR = BUGCHECK_ERROR(24u32);
pub const BAD_POOL_HEADER: BUGCHECK_ERROR = BUGCHECK_ERROR(25u32);
pub const MEMORY_MANAGEMENT: BUGCHECK_ERROR = BUGCHECK_ERROR(26u32);
pub const PFN_SHARE_COUNT: BUGCHECK_ERROR = BUGCHECK_ERROR(27u32);
pub const PFN_REFERENCE_COUNT: BUGCHECK_ERROR = BUGCHECK_ERROR(28u32);
pub const NO_SPIN_LOCK_AVAILABLE: BUGCHECK_ERROR = BUGCHECK_ERROR(29u32);
pub const KMODE_EXCEPTION_NOT_HANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(30u32);
pub const SHARED_RESOURCE_CONV_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(31u32);
pub const KERNEL_APC_PENDING_DURING_EXIT: BUGCHECK_ERROR = BUGCHECK_ERROR(32u32);
pub const QUOTA_UNDERFLOW: BUGCHECK_ERROR = BUGCHECK_ERROR(33u32);
pub const FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(34u32);
pub const FAT_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(35u32);
pub const NTFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(36u32);
pub const NPFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(37u32);
pub const CDFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(38u32);
pub const RDR_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(39u32);
pub const CORRUPT_ACCESS_TOKEN: BUGCHECK_ERROR = BUGCHECK_ERROR(40u32);
pub const SECURITY_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(41u32);
pub const INCONSISTENT_IRP: BUGCHECK_ERROR = BUGCHECK_ERROR(42u32);
pub const PANIC_STACK_SWITCH: BUGCHECK_ERROR = BUGCHECK_ERROR(43u32);
pub const PORT_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(44u32);
pub const SCSI_DISK_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(45u32);
pub const DATA_BUS_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(46u32);
pub const INSTRUCTION_BUS_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(47u32);
pub const SET_OF_INVALID_CONTEXT: BUGCHECK_ERROR = BUGCHECK_ERROR(48u32);
pub const PHASE0_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(49u32);
pub const PHASE1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(50u32);
pub const UNEXPECTED_INITIALIZATION_CALL: BUGCHECK_ERROR = BUGCHECK_ERROR(51u32);
pub const CACHE_MANAGER: BUGCHECK_ERROR = BUGCHECK_ERROR(52u32);
pub const NO_MORE_IRP_STACK_LOCATIONS: BUGCHECK_ERROR = BUGCHECK_ERROR(53u32);
pub const DEVICE_REFERENCE_COUNT_NOT_ZERO: BUGCHECK_ERROR = BUGCHECK_ERROR(54u32);
pub const FLOPPY_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(55u32);
pub const SERIAL_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(56u32);
pub const SYSTEM_EXIT_OWNED_MUTEX: BUGCHECK_ERROR = BUGCHECK_ERROR(57u32);
pub const SYSTEM_UNWIND_PREVIOUS_USER: BUGCHECK_ERROR = BUGCHECK_ERROR(58u32);
pub const SYSTEM_SERVICE_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(59u32);
pub const INTERRUPT_UNWIND_ATTEMPTED: BUGCHECK_ERROR = BUGCHECK_ERROR(60u32);
pub const INTERRUPT_EXCEPTION_NOT_HANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(61u32);
pub const MULTIPROCESSOR_CONFIGURATION_NOT_SUPPORTED: BUGCHECK_ERROR = BUGCHECK_ERROR(62u32);
pub const NO_MORE_SYSTEM_PTES: BUGCHECK_ERROR = BUGCHECK_ERROR(63u32);
pub const TARGET_MDL_TOO_SMALL: BUGCHECK_ERROR = BUGCHECK_ERROR(64u32);
pub const MUST_SUCCEED_POOL_EMPTY: BUGCHECK_ERROR = BUGCHECK_ERROR(65u32);
pub const ATDISK_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(66u32);
pub const NO_SUCH_PARTITION: BUGCHECK_ERROR = BUGCHECK_ERROR(67u32);
pub const MULTIPLE_IRP_COMPLETE_REQUESTS: BUGCHECK_ERROR = BUGCHECK_ERROR(68u32);
pub const INSUFFICIENT_SYSTEM_MAP_REGS: BUGCHECK_ERROR = BUGCHECK_ERROR(69u32);
pub const DEREF_UNKNOWN_LOGON_SESSION: BUGCHECK_ERROR = BUGCHECK_ERROR(70u32);
pub const REF_UNKNOWN_LOGON_SESSION: BUGCHECK_ERROR = BUGCHECK_ERROR(71u32);
pub const CANCEL_STATE_IN_COMPLETED_IRP: BUGCHECK_ERROR = BUGCHECK_ERROR(72u32);
pub const PAGE_FAULT_WITH_INTERRUPTS_OFF: BUGCHECK_ERROR = BUGCHECK_ERROR(73u32);
pub const IRQL_GT_ZERO_AT_SYSTEM_SERVICE: BUGCHECK_ERROR = BUGCHECK_ERROR(74u32);
pub const STREAMS_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(75u32);
pub const FATAL_UNHANDLED_HARD_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(76u32);
pub const NO_PAGES_AVAILABLE: BUGCHECK_ERROR = BUGCHECK_ERROR(77u32);
pub const PFN_LIST_CORRUPT: BUGCHECK_ERROR = BUGCHECK_ERROR(78u32);
pub const NDIS_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(79u32);
pub const PAGE_FAULT_IN_NONPAGED_AREA: BUGCHECK_ERROR = BUGCHECK_ERROR(80u32);
pub const PAGE_FAULT_IN_NONPAGED_AREA_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435536u32);
pub const REGISTRY_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(81u32);
pub const MAILSLOT_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(82u32);
pub const NO_BOOT_DEVICE: BUGCHECK_ERROR = BUGCHECK_ERROR(83u32);
pub const LM_SERVER_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(84u32);
pub const DATA_COHERENCY_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(85u32);
pub const INSTRUCTION_COHERENCY_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(86u32);
pub const XNS_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(87u32);
pub const VOLMGRX_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(88u32);
pub const PINBALL_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(89u32);
pub const CRITICAL_SERVICE_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(90u32);
pub const SET_ENV_VAR_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(91u32);
pub const HAL_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(92u32);
pub const UNSUPPORTED_PROCESSOR: BUGCHECK_ERROR = BUGCHECK_ERROR(93u32);
pub const OBJECT_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(94u32);
pub const SECURITY_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(95u32);
pub const PROCESS_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(96u32);
pub const HAL1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(97u32);
pub const OBJECT1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(98u32);
pub const SECURITY1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(99u32);
pub const SYMBOLIC_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(100u32);
pub const MEMORY1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(101u32);
pub const CACHE_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(102u32);
pub const CONFIG_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(103u32);
pub const FILE_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(104u32);
pub const IO1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(105u32);
pub const LPC_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(106u32);
pub const PROCESS1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(107u32);
pub const REFMON_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(108u32);
pub const SESSION1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(109u32);
pub const BOOTPROC_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(110u32);
pub const VSL_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(111u32);
pub const SOFT_RESTART_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(112u32);
pub const ASSIGN_DRIVE_LETTERS_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(114u32);
pub const CONFIG_LIST_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(115u32);
pub const BAD_SYSTEM_CONFIG_INFO: BUGCHECK_ERROR = BUGCHECK_ERROR(116u32);
pub const CANNOT_WRITE_CONFIGURATION: BUGCHECK_ERROR = BUGCHECK_ERROR(117u32);
pub const PROCESS_HAS_LOCKED_PAGES: BUGCHECK_ERROR = BUGCHECK_ERROR(118u32);
pub const KERNEL_STACK_INPAGE_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(119u32);
pub const PHASE0_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(120u32);
pub const MISMATCHED_HAL: BUGCHECK_ERROR = BUGCHECK_ERROR(121u32);
pub const KERNEL_DATA_INPAGE_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(122u32);
pub const INACCESSIBLE_BOOT_DEVICE: BUGCHECK_ERROR = BUGCHECK_ERROR(123u32);
pub const BUGCODE_NDIS_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(124u32);
pub const INSTALL_MORE_MEMORY: BUGCHECK_ERROR = BUGCHECK_ERROR(125u32);
pub const SYSTEM_THREAD_EXCEPTION_NOT_HANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(126u32);
pub const SYSTEM_THREAD_EXCEPTION_NOT_HANDLED_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435582u32);
pub const UNEXPECTED_KERNEL_MODE_TRAP: BUGCHECK_ERROR = BUGCHECK_ERROR(127u32);
pub const UNEXPECTED_KERNEL_MODE_TRAP_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435583u32);
pub const NMI_HARDWARE_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(128u32);
pub const SPIN_LOCK_INIT_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(129u32);
pub const DFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(130u32);
pub const OFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(131u32);
pub const RECOM_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(132u32);
pub const SETUP_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(133u32);
pub const AUDIT_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(134u32);
pub const MBR_CHECKSUM_MISMATCH: BUGCHECK_ERROR = BUGCHECK_ERROR(139u32);
pub const KERNEL_MODE_EXCEPTION_NOT_HANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(142u32);
pub const KERNEL_MODE_EXCEPTION_NOT_HANDLED_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435598u32);
pub const PP0_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(143u32);
pub const PP1_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(144u32);
pub const WIN32K_INIT_OR_RIT_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(145u32);
pub const UP_DRIVER_ON_MP_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(146u32);
pub const INVALID_KERNEL_HANDLE: BUGCHECK_ERROR = BUGCHECK_ERROR(147u32);
pub const KERNEL_STACK_LOCKED_AT_EXIT: BUGCHECK_ERROR = BUGCHECK_ERROR(148u32);
pub const PNP_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(149u32);
pub const INVALID_WORK_QUEUE_ITEM: BUGCHECK_ERROR = BUGCHECK_ERROR(150u32);
pub const BOUND_IMAGE_UNSUPPORTED: BUGCHECK_ERROR = BUGCHECK_ERROR(151u32);
pub const END_OF_NT_EVALUATION_PERIOD: BUGCHECK_ERROR = BUGCHECK_ERROR(152u32);
pub const INVALID_REGION_OR_SEGMENT: BUGCHECK_ERROR = BUGCHECK_ERROR(153u32);
pub const SYSTEM_LICENSE_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(154u32);
pub const UDFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(155u32);
pub const MACHINE_CHECK_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(156u32);
pub const USER_MODE_HEALTH_MONITOR: BUGCHECK_ERROR = BUGCHECK_ERROR(158u32);
pub const DRIVER_POWER_STATE_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(159u32);
pub const INTERNAL_POWER_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(160u32);
pub const PCI_BUS_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(161u32);
pub const MEMORY_IMAGE_CORRUPT: BUGCHECK_ERROR = BUGCHECK_ERROR(162u32);
pub const ACPI_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(163u32);
pub const CNSS_FILE_SYSTEM_FILTER: BUGCHECK_ERROR = BUGCHECK_ERROR(164u32);
pub const ACPI_BIOS_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(165u32);
pub const FP_EMULATION_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(166u32);
pub const BAD_EXHANDLE: BUGCHECK_ERROR = BUGCHECK_ERROR(167u32);
pub const BOOTING_IN_SAFEMODE_MINIMAL: BUGCHECK_ERROR = BUGCHECK_ERROR(168u32);
pub const BOOTING_IN_SAFEMODE_NETWORK: BUGCHECK_ERROR = BUGCHECK_ERROR(169u32);
pub const BOOTING_IN_SAFEMODE_DSREPAIR: BUGCHECK_ERROR = BUGCHECK_ERROR(170u32);
pub const SESSION_HAS_VALID_POOL_ON_EXIT: BUGCHECK_ERROR = BUGCHECK_ERROR(171u32);
pub const HAL_MEMORY_ALLOCATION: BUGCHECK_ERROR = BUGCHECK_ERROR(172u32);
pub const VIDEO_DRIVER_DEBUG_REPORT_REQUEST: BUGCHECK_ERROR = BUGCHECK_ERROR(1073741997u32);
pub const BGI_DETECTED_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(177u32);
pub const VIDEO_DRIVER_INIT_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(180u32);
pub const BOOTLOG_LOADED: BUGCHECK_ERROR = BUGCHECK_ERROR(181u32);
pub const BOOTLOG_NOT_LOADED: BUGCHECK_ERROR = BUGCHECK_ERROR(182u32);
pub const BOOTLOG_ENABLED: BUGCHECK_ERROR = BUGCHECK_ERROR(183u32);
pub const ATTEMPTED_SWITCH_FROM_DPC: BUGCHECK_ERROR = BUGCHECK_ERROR(184u32);
pub const CHIPSET_DETECTED_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(185u32);
pub const SESSION_HAS_VALID_VIEWS_ON_EXIT: BUGCHECK_ERROR = BUGCHECK_ERROR(186u32);
pub const NETWORK_BOOT_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(187u32);
pub const NETWORK_BOOT_DUPLICATE_ADDRESS: BUGCHECK_ERROR = BUGCHECK_ERROR(188u32);
pub const INVALID_HIBERNATED_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(189u32);
pub const ATTEMPTED_WRITE_TO_READONLY_MEMORY: BUGCHECK_ERROR = BUGCHECK_ERROR(190u32);
pub const MUTEX_ALREADY_OWNED: BUGCHECK_ERROR = BUGCHECK_ERROR(191u32);
pub const PCI_CONFIG_SPACE_ACCESS_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(192u32);
pub const SPECIAL_POOL_DETECTED_MEMORY_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(193u32);
pub const BAD_POOL_CALLER: BUGCHECK_ERROR = BUGCHECK_ERROR(194u32);
pub const SYSTEM_IMAGE_BAD_SIGNATURE: BUGCHECK_ERROR = BUGCHECK_ERROR(195u32);
pub const DRIVER_VERIFIER_DETECTED_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(196u32);
pub const DRIVER_CORRUPTED_EXPOOL: BUGCHECK_ERROR = BUGCHECK_ERROR(197u32);
pub const DRIVER_CAUGHT_MODIFYING_FREED_POOL: BUGCHECK_ERROR = BUGCHECK_ERROR(198u32);
pub const TIMER_OR_DPC_INVALID: BUGCHECK_ERROR = BUGCHECK_ERROR(199u32);
pub const IRQL_UNEXPECTED_VALUE: BUGCHECK_ERROR = BUGCHECK_ERROR(200u32);
pub const DRIVER_VERIFIER_IOMANAGER_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(201u32);
pub const PNP_DETECTED_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(202u32);
pub const DRIVER_LEFT_LOCKED_PAGES_IN_PROCESS: BUGCHECK_ERROR = BUGCHECK_ERROR(203u32);
pub const PAGE_FAULT_IN_FREED_SPECIAL_POOL: BUGCHECK_ERROR = BUGCHECK_ERROR(204u32);
pub const PAGE_FAULT_BEYOND_END_OF_ALLOCATION: BUGCHECK_ERROR = BUGCHECK_ERROR(205u32);
pub const DRIVER_UNLOADED_WITHOUT_CANCELLING_PENDING_OPERATIONS: BUGCHECK_ERROR = BUGCHECK_ERROR(206u32);
pub const TERMINAL_SERVER_DRIVER_MADE_INCORRECT_MEMORY_REFERENCE: BUGCHECK_ERROR = BUGCHECK_ERROR(207u32);
pub const DRIVER_CORRUPTED_MMPOOL: BUGCHECK_ERROR = BUGCHECK_ERROR(208u32);
pub const DRIVER_IRQL_NOT_LESS_OR_EQUAL: BUGCHECK_ERROR = BUGCHECK_ERROR(209u32);
pub const BUGCODE_ID_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(210u32);
pub const DRIVER_PORTION_MUST_BE_NONPAGED: BUGCHECK_ERROR = BUGCHECK_ERROR(211u32);
pub const SYSTEM_SCAN_AT_RAISED_IRQL_CAUGHT_IMPROPER_DRIVER_UNLOAD: BUGCHECK_ERROR = BUGCHECK_ERROR(212u32);
pub const DRIVER_PAGE_FAULT_IN_FREED_SPECIAL_POOL: BUGCHECK_ERROR = BUGCHECK_ERROR(213u32);
pub const DRIVER_PAGE_FAULT_BEYOND_END_OF_ALLOCATION: BUGCHECK_ERROR = BUGCHECK_ERROR(214u32);
pub const DRIVER_PAGE_FAULT_BEYOND_END_OF_ALLOCATION_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435670u32);
pub const DRIVER_UNMAPPING_INVALID_VIEW: BUGCHECK_ERROR = BUGCHECK_ERROR(215u32);
pub const DRIVER_USED_EXCESSIVE_PTES: BUGCHECK_ERROR = BUGCHECK_ERROR(216u32);
pub const LOCKED_PAGES_TRACKER_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(217u32);
pub const SYSTEM_PTE_MISUSE: BUGCHECK_ERROR = BUGCHECK_ERROR(218u32);
pub const DRIVER_CORRUPTED_SYSPTES: BUGCHECK_ERROR = BUGCHECK_ERROR(219u32);
pub const DRIVER_INVALID_STACK_ACCESS: BUGCHECK_ERROR = BUGCHECK_ERROR(220u32);
pub const POOL_CORRUPTION_IN_FILE_AREA: BUGCHECK_ERROR = BUGCHECK_ERROR(222u32);
pub const IMPERSONATING_WORKER_THREAD: BUGCHECK_ERROR = BUGCHECK_ERROR(223u32);
pub const ACPI_BIOS_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(224u32);
pub const WORKER_THREAD_RETURNED_AT_BAD_IRQL: BUGCHECK_ERROR = BUGCHECK_ERROR(225u32);
pub const MANUALLY_INITIATED_CRASH: BUGCHECK_ERROR = BUGCHECK_ERROR(226u32);
pub const RESOURCE_NOT_OWNED: BUGCHECK_ERROR = BUGCHECK_ERROR(227u32);
pub const WORKER_INVALID: BUGCHECK_ERROR = BUGCHECK_ERROR(228u32);
pub const POWER_FAILURE_SIMULATE: BUGCHECK_ERROR = BUGCHECK_ERROR(229u32);
pub const DRIVER_VERIFIER_DMA_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(230u32);
pub const INVALID_FLOATING_POINT_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(231u32);
pub const INVALID_CANCEL_OF_FILE_OPEN: BUGCHECK_ERROR = BUGCHECK_ERROR(232u32);
pub const ACTIVE_EX_WORKER_THREAD_TERMINATION: BUGCHECK_ERROR = BUGCHECK_ERROR(233u32);
pub const SAVER_UNSPECIFIED: BUGCHECK_ERROR = BUGCHECK_ERROR(61440u32);
pub const SAVER_BLANKSCREEN: BUGCHECK_ERROR = BUGCHECK_ERROR(61442u32);
pub const SAVER_INPUT: BUGCHECK_ERROR = BUGCHECK_ERROR(61443u32);
pub const SAVER_WATCHDOG: BUGCHECK_ERROR = BUGCHECK_ERROR(61444u32);
pub const SAVER_STARTNOTVISIBLE: BUGCHECK_ERROR = BUGCHECK_ERROR(61445u32);
pub const SAVER_NAVIGATIONMODEL: BUGCHECK_ERROR = BUGCHECK_ERROR(61446u32);
pub const SAVER_OUTOFMEMORY: BUGCHECK_ERROR = BUGCHECK_ERROR(61447u32);
pub const SAVER_GRAPHICS: BUGCHECK_ERROR = BUGCHECK_ERROR(61448u32);
pub const SAVER_NAVSERVERTIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(61449u32);
pub const SAVER_CHROMEPROCESSCRASH: BUGCHECK_ERROR = BUGCHECK_ERROR(61450u32);
pub const SAVER_NOTIFICATIONDISMISSAL: BUGCHECK_ERROR = BUGCHECK_ERROR(61451u32);
pub const SAVER_SPEECHDISMISSAL: BUGCHECK_ERROR = BUGCHECK_ERROR(61452u32);
pub const SAVER_CALLDISMISSAL: BUGCHECK_ERROR = BUGCHECK_ERROR(61453u32);
pub const SAVER_APPBARDISMISSAL: BUGCHECK_ERROR = BUGCHECK_ERROR(61454u32);
pub const SAVER_RILADAPTATIONCRASH: BUGCHECK_ERROR = BUGCHECK_ERROR(61455u32);
pub const SAVER_APPLISTUNREACHABLE: BUGCHECK_ERROR = BUGCHECK_ERROR(61456u32);
pub const SAVER_REPORTNOTIFICATIONFAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(61457u32);
pub const SAVER_UNEXPECTEDSHUTDOWN: BUGCHECK_ERROR = BUGCHECK_ERROR(61458u32);
pub const SAVER_RPCFAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(61459u32);
pub const SAVER_AUXILIARYFULLDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(61460u32);
pub const SAVER_ACCOUNTPROVSVCINITFAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(61461u32);
pub const SAVER_MTBFCOMMANDTIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(789u32);
pub const SAVER_MTBFCOMMANDHANG: BUGCHECK_ERROR = BUGCHECK_ERROR(61697u32);
pub const SAVER_MTBFPASSBUGCHECK: BUGCHECK_ERROR = BUGCHECK_ERROR(61698u32);
pub const SAVER_MTBFIOERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(61699u32);
pub const SAVER_RENDERTHREADHANG: BUGCHECK_ERROR = BUGCHECK_ERROR(61952u32);
pub const SAVER_RENDERMOBILEUIOOM: BUGCHECK_ERROR = BUGCHECK_ERROR(61953u32);
pub const SAVER_DEVICEUPDATEUNSPECIFIED: BUGCHECK_ERROR = BUGCHECK_ERROR(62208u32);
pub const SAVER_AUDIODRIVERHANG: BUGCHECK_ERROR = BUGCHECK_ERROR(62464u32);
pub const SAVER_BATTERYPULLOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(62720u32);
pub const SAVER_MEDIACORETESTHANG: BUGCHECK_ERROR = BUGCHECK_ERROR(62976u32);
pub const SAVER_RESOURCEMANAGEMENT: BUGCHECK_ERROR = BUGCHECK_ERROR(63232u32);
pub const SAVER_CAPTURESERVICE: BUGCHECK_ERROR = BUGCHECK_ERROR(63488u32);
pub const SAVER_WAITFORSHELLREADY: BUGCHECK_ERROR = BUGCHECK_ERROR(63744u32);
pub const SAVER_NONRESPONSIVEPROCESS: BUGCHECK_ERROR = BUGCHECK_ERROR(404u32);
pub const SAVER_SICKAPPLICATION: BUGCHECK_ERROR = BUGCHECK_ERROR(34918u32);
pub const THREAD_STUCK_IN_DEVICE_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(234u32);
pub const THREAD_STUCK_IN_DEVICE_DRIVER_M: BUGCHECK_ERROR = BUGCHECK_ERROR(268435690u32);
pub const DIRTY_MAPPED_PAGES_CONGESTION: BUGCHECK_ERROR = BUGCHECK_ERROR(235u32);
pub const SESSION_HAS_VALID_SPECIAL_POOL_ON_EXIT: BUGCHECK_ERROR = BUGCHECK_ERROR(236u32);
pub const UNMOUNTABLE_BOOT_VOLUME: BUGCHECK_ERROR = BUGCHECK_ERROR(237u32);
pub const CRITICAL_PROCESS_DIED: BUGCHECK_ERROR = BUGCHECK_ERROR(239u32);
pub const STORAGE_MINIPORT_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(240u32);
pub const SCSI_VERIFIER_DETECTED_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(241u32);
pub const HARDWARE_INTERRUPT_STORM: BUGCHECK_ERROR = BUGCHECK_ERROR(242u32);
pub const DISORDERLY_SHUTDOWN: BUGCHECK_ERROR = BUGCHECK_ERROR(243u32);
pub const CRITICAL_OBJECT_TERMINATION: BUGCHECK_ERROR = BUGCHECK_ERROR(244u32);
pub const FLTMGR_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(245u32);
pub const PCI_VERIFIER_DETECTED_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(246u32);
pub const DRIVER_OVERRAN_STACK_BUFFER: BUGCHECK_ERROR = BUGCHECK_ERROR(247u32);
pub const RAMDISK_BOOT_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(248u32);
pub const DRIVER_RETURNED_STATUS_REPARSE_FOR_VOLUME_OPEN: BUGCHECK_ERROR = BUGCHECK_ERROR(249u32);
pub const HTTP_DRIVER_CORRUPTED: BUGCHECK_ERROR = BUGCHECK_ERROR(250u32);
pub const RECURSIVE_MACHINE_CHECK: BUGCHECK_ERROR = BUGCHECK_ERROR(251u32);
pub const ATTEMPTED_EXECUTE_OF_NOEXECUTE_MEMORY: BUGCHECK_ERROR = BUGCHECK_ERROR(252u32);
pub const DIRTY_NOWRITE_PAGES_CONGESTION: BUGCHECK_ERROR = BUGCHECK_ERROR(253u32);
pub const BUGCODE_USB_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(254u32);
pub const BC_BLUETOOTH_VERIFIER_FAULT: BUGCHECK_ERROR = BUGCHECK_ERROR(3070u32);
pub const BC_BTHMINI_VERIFIER_FAULT: BUGCHECK_ERROR = BUGCHECK_ERROR(3071u32);
pub const RESERVE_QUEUE_OVERFLOW: BUGCHECK_ERROR = BUGCHECK_ERROR(255u32);
pub const LOADER_BLOCK_MISMATCH: BUGCHECK_ERROR = BUGCHECK_ERROR(256u32);
pub const CLOCK_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(257u32);
pub const DPC_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(258u32);
pub const MUP_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(259u32);
pub const AGP_INVALID_ACCESS: BUGCHECK_ERROR = BUGCHECK_ERROR(260u32);
pub const AGP_GART_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(261u32);
pub const AGP_ILLEGALLY_REPROGRAMMED: BUGCHECK_ERROR = BUGCHECK_ERROR(262u32);
pub const KERNEL_EXPAND_STACK_ACTIVE: BUGCHECK_ERROR = BUGCHECK_ERROR(263u32);
pub const THIRD_PARTY_FILE_SYSTEM_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(264u32);
pub const CRITICAL_STRUCTURE_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(265u32);
pub const APP_TAGGING_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(266u32);
pub const DFSC_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(267u32);
pub const FSRTL_EXTRA_CREATE_PARAMETER_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(268u32);
pub const WDF_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(269u32);
pub const VIDEO_MEMORY_MANAGEMENT_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(270u32);
pub const DRIVER_INVALID_CRUNTIME_PARAMETER: BUGCHECK_ERROR = BUGCHECK_ERROR(272u32);
pub const RECURSIVE_NMI: BUGCHECK_ERROR = BUGCHECK_ERROR(273u32);
pub const MSRPC_STATE_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(274u32);
pub const VIDEO_DXGKRNL_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(275u32);
pub const VIDEO_SHADOW_DRIVER_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(276u32);
pub const AGP_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(277u32);
pub const VIDEO_TDR_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(278u32);
pub const VIDEO_TDR_TIMEOUT_DETECTED: BUGCHECK_ERROR = BUGCHECK_ERROR(279u32);
pub const NTHV_GUEST_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(280u32);
pub const VIDEO_SCHEDULER_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(281u32);
pub const EM_INITIALIZATION_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(282u32);
pub const DRIVER_RETURNED_HOLDING_CANCEL_LOCK: BUGCHECK_ERROR = BUGCHECK_ERROR(283u32);
pub const ATTEMPTED_WRITE_TO_CM_PROTECTED_STORAGE: BUGCHECK_ERROR = BUGCHECK_ERROR(284u32);
pub const EVENT_TRACING_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(285u32);
pub const TOO_MANY_RECURSIVE_FAULTS: BUGCHECK_ERROR = BUGCHECK_ERROR(286u32);
pub const INVALID_DRIVER_HANDLE: BUGCHECK_ERROR = BUGCHECK_ERROR(287u32);
pub const BITLOCKER_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(288u32);
pub const DRIVER_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(289u32);
pub const WHEA_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(290u32);
pub const CRYPTO_SELF_TEST_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(291u32);
pub const WHEA_UNCORRECTABLE_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(292u32);
pub const NMR_INVALID_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(293u32);
pub const NETIO_INVALID_POOL_CALLER: BUGCHECK_ERROR = BUGCHECK_ERROR(294u32);
pub const PAGE_NOT_ZERO: BUGCHECK_ERROR = BUGCHECK_ERROR(295u32);
pub const WORKER_THREAD_RETURNED_WITH_BAD_IO_PRIORITY: BUGCHECK_ERROR = BUGCHECK_ERROR(296u32);
pub const WORKER_THREAD_RETURNED_WITH_BAD_PAGING_IO_PRIORITY: BUGCHECK_ERROR = BUGCHECK_ERROR(297u32);
pub const MUI_NO_VALID_SYSTEM_LANGUAGE: BUGCHECK_ERROR = BUGCHECK_ERROR(298u32);
pub const FAULTY_HARDWARE_CORRUPTED_PAGE: BUGCHECK_ERROR = BUGCHECK_ERROR(299u32);
pub const EXFAT_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(300u32);
pub const VOLSNAP_OVERLAPPED_TABLE_ACCESS: BUGCHECK_ERROR = BUGCHECK_ERROR(301u32);
pub const INVALID_MDL_RANGE: BUGCHECK_ERROR = BUGCHECK_ERROR(302u32);
pub const VHD_BOOT_INITIALIZATION_FAILED: BUGCHECK_ERROR = BUGCHECK_ERROR(303u32);
pub const DYNAMIC_ADD_PROCESSOR_MISMATCH: BUGCHECK_ERROR = BUGCHECK_ERROR(304u32);
pub const INVALID_EXTENDED_PROCESSOR_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(305u32);
pub const RESOURCE_OWNER_POINTER_INVALID: BUGCHECK_ERROR = BUGCHECK_ERROR(306u32);
pub const DPC_WATCHDOG_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(307u32);
pub const DRIVE_EXTENDER: BUGCHECK_ERROR = BUGCHECK_ERROR(308u32);
pub const REGISTRY_FILTER_DRIVER_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(309u32);
pub const VHD_BOOT_HOST_VOLUME_NOT_ENOUGH_SPACE: BUGCHECK_ERROR = BUGCHECK_ERROR(310u32);
pub const WIN32K_HANDLE_MANAGER: BUGCHECK_ERROR = BUGCHECK_ERROR(311u32);
pub const GPIO_CONTROLLER_DRIVER_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(312u32);
pub const KERNEL_SECURITY_CHECK_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(313u32);
pub const KERNEL_MODE_HEAP_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(314u32);
pub const PASSIVE_INTERRUPT_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(315u32);
pub const INVALID_IO_BOOST_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(316u32);
pub const CRITICAL_INITIALIZATION_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(317u32);
pub const ERRATA_WORKAROUND_UNSUCCESSFUL: BUGCHECK_ERROR = BUGCHECK_ERROR(318u32);
pub const REGISTRY_CALLBACK_DRIVER_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(319u32);
pub const STORAGE_DEVICE_ABNORMALITY_DETECTED: BUGCHECK_ERROR = BUGCHECK_ERROR(320u32);
pub const VIDEO_ENGINE_TIMEOUT_DETECTED: BUGCHECK_ERROR = BUGCHECK_ERROR(321u32);
pub const VIDEO_TDR_APPLICATION_BLOCKED: BUGCHECK_ERROR = BUGCHECK_ERROR(322u32);
pub const PROCESSOR_DRIVER_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(323u32);
pub const BUGCODE_USB3_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(324u32);
pub const SECURE_BOOT_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(325u32);
pub const NDIS_NET_BUFFER_LIST_INFO_ILLEGALLY_TRANSFERRED: BUGCHECK_ERROR = BUGCHECK_ERROR(326u32);
pub const ABNORMAL_RESET_DETECTED: BUGCHECK_ERROR = BUGCHECK_ERROR(327u32);
pub const IO_OBJECT_INVALID: BUGCHECK_ERROR = BUGCHECK_ERROR(328u32);
pub const REFS_FILE_SYSTEM: BUGCHECK_ERROR = BUGCHECK_ERROR(329u32);
pub const KERNEL_WMI_INTERNAL: BUGCHECK_ERROR = BUGCHECK_ERROR(330u32);
pub const SOC_SUBSYSTEM_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(331u32);
pub const FATAL_ABNORMAL_RESET_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(332u32);
pub const EXCEPTION_SCOPE_INVALID: BUGCHECK_ERROR = BUGCHECK_ERROR(333u32);
pub const SOC_CRITICAL_DEVICE_REMOVED: BUGCHECK_ERROR = BUGCHECK_ERROR(334u32);
pub const PDC_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(335u32);
pub const TCPIP_AOAC_NIC_ACTIVE_REFERENCE_LEAK: BUGCHECK_ERROR = BUGCHECK_ERROR(336u32);
pub const UNSUPPORTED_INSTRUCTION_MODE: BUGCHECK_ERROR = BUGCHECK_ERROR(337u32);
pub const INVALID_PUSH_LOCK_FLAGS: BUGCHECK_ERROR = BUGCHECK_ERROR(338u32);
pub const KERNEL_LOCK_ENTRY_LEAKED_ON_THREAD_TERMINATION: BUGCHECK_ERROR = BUGCHECK_ERROR(339u32);
pub const UNEXPECTED_STORE_EXCEPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(340u32);
pub const OS_DATA_TAMPERING: BUGCHECK_ERROR = BUGCHECK_ERROR(341u32);
pub const WINSOCK_DETECTED_HUNG_CLOSESOCKET_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(342u32);
pub const KERNEL_THREAD_PRIORITY_FLOOR_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(343u32);
pub const ILLEGAL_IOMMU_PAGE_FAULT: BUGCHECK_ERROR = BUGCHECK_ERROR(344u32);
pub const HAL_ILLEGAL_IOMMU_PAGE_FAULT: BUGCHECK_ERROR = BUGCHECK_ERROR(345u32);
pub const SDBUS_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(346u32);
pub const WORKER_THREAD_RETURNED_WITH_SYSTEM_PAGE_PRIORITY_ACTIVE: BUGCHECK_ERROR = BUGCHECK_ERROR(347u32);
pub const PDC_WATCHDOG_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(348u32);
pub const SOC_SUBSYSTEM_FAILURE_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(349u32);
pub const BUGCODE_NDIS_DRIVER_LIVE_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(350u32);
pub const CONNECTED_STANDBY_WATCHDOG_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(351u32);
pub const WIN32K_ATOMIC_CHECK_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(352u32);
pub const LIVE_SYSTEM_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(353u32);
pub const KERNEL_AUTO_BOOST_INVALID_LOCK_RELEASE: BUGCHECK_ERROR = BUGCHECK_ERROR(354u32);
pub const WORKER_THREAD_TEST_CONDITION: BUGCHECK_ERROR = BUGCHECK_ERROR(355u32);
pub const WIN32K_CRITICAL_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(356u32);
pub const CLUSTER_CSV_STATUS_IO_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(357u32);
pub const CLUSTER_RESOURCE_CALL_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(358u32);
pub const CLUSTER_CSV_SNAPSHOT_DEVICE_INFO_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(359u32);
pub const CLUSTER_CSV_STATE_TRANSITION_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(360u32);
pub const CLUSTER_CSV_VOLUME_ARRIVAL_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(361u32);
pub const CLUSTER_CSV_VOLUME_REMOVAL_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(362u32);
pub const CLUSTER_CSV_CLUSTER_WATCHDOG_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(363u32);
pub const INVALID_RUNDOWN_PROTECTION_FLAGS: BUGCHECK_ERROR = BUGCHECK_ERROR(364u32);
pub const INVALID_SLOT_ALLOCATOR_FLAGS: BUGCHECK_ERROR = BUGCHECK_ERROR(365u32);
pub const ERESOURCE_INVALID_RELEASE: BUGCHECK_ERROR = BUGCHECK_ERROR(366u32);
pub const CLUSTER_CSV_STATE_TRANSITION_INTERVAL_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(367u32);
pub const CLUSTER_CSV_CLUSSVC_DISCONNECT_WATCHDOG: BUGCHECK_ERROR = BUGCHECK_ERROR(368u32);
pub const CRYPTO_LIBRARY_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(369u32);
pub const COREMSGCALL_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(371u32);
pub const COREMSG_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(372u32);
pub const PREVIOUS_FATAL_ABNORMAL_RESET_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(373u32);
pub const ELAM_DRIVER_DETECTED_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(376u32);
pub const CLUSTER_CLUSPORT_STATUS_IO_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(377u32);
pub const PROFILER_CONFIGURATION_ILLEGAL: BUGCHECK_ERROR = BUGCHECK_ERROR(379u32);
pub const PDC_LOCK_WATCHDOG_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(380u32);
pub const PDC_UNEXPECTED_REVOCATION_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(381u32);
pub const MICROCODE_REVISION_MISMATCH: BUGCHECK_ERROR = BUGCHECK_ERROR(382u32);
pub const HYPERGUARD_INITIALIZATION_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(383u32);
pub const WVR_LIVEDUMP_REPLICATION_IOCONTEXT_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(384u32);
pub const WVR_LIVEDUMP_STATE_TRANSITION_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(385u32);
pub const WVR_LIVEDUMP_RECOVERY_IOCONTEXT_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(386u32);
pub const WVR_LIVEDUMP_APP_IO_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(387u32);
pub const WVR_LIVEDUMP_MANUALLY_INITIATED: BUGCHECK_ERROR = BUGCHECK_ERROR(388u32);
pub const WVR_LIVEDUMP_STATE_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(389u32);
pub const WVR_LIVEDUMP_CRITICAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(390u32);
pub const VIDEO_DWMINIT_TIMEOUT_FALLBACK_BDD: BUGCHECK_ERROR = BUGCHECK_ERROR(391u32);
pub const CLUSTER_CSVFS_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(392u32);
pub const BAD_OBJECT_HEADER: BUGCHECK_ERROR = BUGCHECK_ERROR(393u32);
pub const SILO_CORRUPT: BUGCHECK_ERROR = BUGCHECK_ERROR(394u32);
pub const SECURE_KERNEL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(395u32);
pub const HYPERGUARD_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(396u32);
pub const SECURE_FAULT_UNHANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(397u32);
pub const KERNEL_PARTITION_REFERENCE_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(398u32);
pub const SYNTHETIC_EXCEPTION_UNHANDLED: BUGCHECK_ERROR = BUGCHECK_ERROR(399u32);
pub const WIN32K_CRITICAL_FAILURE_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(400u32);
pub const PF_DETECTED_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(401u32);
pub const KERNEL_AUTO_BOOST_LOCK_ACQUISITION_WITH_RAISED_IRQL: BUGCHECK_ERROR = BUGCHECK_ERROR(402u32);
pub const VIDEO_DXGKRNL_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(403u32);
pub const KERNEL_STORAGE_SLOT_IN_USE: BUGCHECK_ERROR = BUGCHECK_ERROR(409u32);
pub const SMB_SERVER_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(405u32);
pub const LOADER_ROLLBACK_DETECTED: BUGCHECK_ERROR = BUGCHECK_ERROR(406u32);
pub const WIN32K_SECURITY_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(407u32);
pub const UFX_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(408u32);
pub const WORKER_THREAD_RETURNED_WHILE_ATTACHED_TO_SILO: BUGCHECK_ERROR = BUGCHECK_ERROR(410u32);
pub const TTM_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(411u32);
pub const WIN32K_POWER_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(412u32);
pub const CLUSTER_SVHDX_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(413u32);
pub const BUGCODE_NETADAPTER_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(414u32);
pub const PDC_PRIVILEGE_CHECK_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(415u32);
pub const TTM_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(416u32);
pub const WIN32K_CALLOUT_WATCHDOG_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(417u32);
pub const WIN32K_CALLOUT_WATCHDOG_BUGCHECK: BUGCHECK_ERROR = BUGCHECK_ERROR(418u32);
pub const CALL_HAS_NOT_RETURNED_WATCHDOG_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(419u32);
pub const DRIPS_SW_HW_DIVERGENCE_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(420u32);
pub const USB_DRIPS_BLOCKER_SURPRISE_REMOVAL_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(421u32);
pub const BLUETOOTH_ERROR_RECOVERY_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(422u32);
pub const SMB_REDIRECTOR_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(423u32);
pub const VIDEO_DXGKRNL_BLACK_SCREEN_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(424u32);
pub const DIRECTED_FX_TRANSITION_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(425u32);
pub const EXCEPTION_ON_INVALID_STACK: BUGCHECK_ERROR = BUGCHECK_ERROR(426u32);
pub const UNWIND_ON_INVALID_STACK: BUGCHECK_ERROR = BUGCHECK_ERROR(427u32);
pub const VIDEO_MINIPORT_FAILED_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(432u32);
pub const VIDEO_MINIPORT_BLACK_SCREEN_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(440u32);
pub const DRIVER_VERIFIER_DETECTED_VIOLATION_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(452u32);
pub const IO_THREADPOOL_DEADLOCK_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(453u32);
pub const FAST_ERESOURCE_PRECONDITION_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(454u32);
pub const STORE_DATA_STRUCTURE_CORRUPTION: BUGCHECK_ERROR = BUGCHECK_ERROR(455u32);
pub const MANUALLY_INITIATED_POWER_BUTTON_HOLD: BUGCHECK_ERROR = BUGCHECK_ERROR(456u32);
pub const USER_MODE_HEALTH_MONITOR_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(457u32);
pub const SYNTHETIC_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(458u32);
pub const INVALID_SILO_DETACH: BUGCHECK_ERROR = BUGCHECK_ERROR(459u32);
pub const EXRESOURCE_TIMEOUT_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(460u32);
pub const INVALID_CALLBACK_STACK_ADDRESS: BUGCHECK_ERROR = BUGCHECK_ERROR(461u32);
pub const INVALID_KERNEL_STACK_ADDRESS: BUGCHECK_ERROR = BUGCHECK_ERROR(462u32);
pub const HARDWARE_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(463u32);
pub const ACPI_FIRMWARE_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(464u32);
pub const TELEMETRY_ASSERTS_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(465u32);
pub const WORKER_THREAD_INVALID_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(466u32);
pub const WFP_INVALID_OPERATION: BUGCHECK_ERROR = BUGCHECK_ERROR(467u32);
pub const UCMUCSI_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(468u32);
pub const DRIVER_PNP_WATCHDOG: BUGCHECK_ERROR = BUGCHECK_ERROR(469u32);
pub const WORKER_THREAD_RETURNED_WITH_NON_DEFAULT_WORKLOAD_CLASS: BUGCHECK_ERROR = BUGCHECK_ERROR(470u32);
pub const EFS_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(471u32);
pub const UCMUCSI_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(472u32);
pub const HAL_IOMMU_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(473u32);
pub const HAL_BLOCKED_PROCESSOR_INTERNAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(474u32);
pub const IPI_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(475u32);
pub const DMA_COMMON_BUFFER_VECTOR_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(476u32);
pub const BUGCODE_MBBADAPTER_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(477u32);
pub const BUGCODE_WIFIADAPTER_DRIVER: BUGCHECK_ERROR = BUGCHECK_ERROR(478u32);
pub const PROCESSOR_START_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(479u32);
pub const INVALID_ALTERNATE_SYSTEM_CALL_HANDLER_REGISTRATION: BUGCHECK_ERROR = BUGCHECK_ERROR(480u32);
pub const DEVICE_DIAGNOSTIC_LOG_LIVEDUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(481u32);
pub const AZURE_DEVICE_FW_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(482u32);
pub const BREAKAWAY_CABLE_TRANSITION: BUGCHECK_ERROR = BUGCHECK_ERROR(483u32);
pub const VIDEO_DXGKRNL_SYSMM_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(484u32);
pub const DRIVER_VERIFIER_TRACKING_LIVE_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(485u32);
pub const CRASHDUMP_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(486u32);
pub const REGISTRY_LIVE_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(487u32);
pub const INVALID_THREAD_AFFINITY_STATE: BUGCHECK_ERROR = BUGCHECK_ERROR(488u32);
pub const ILLEGAL_ATS_INITIALIZATION: BUGCHECK_ERROR = BUGCHECK_ERROR(489u32);
pub const SECURE_PCI_CONFIG_SPACE_ACCESS_VIOLATION: BUGCHECK_ERROR = BUGCHECK_ERROR(490u32);
pub const DAM_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(491u32);
pub const XBOX_VMCTRL_CS_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(854u32);
pub const XBOX_CORRUPTED_IMAGE: BUGCHECK_ERROR = BUGCHECK_ERROR(855u32);
pub const XBOX_INVERTED_FUNCTION_TABLE_OVERFLOW: BUGCHECK_ERROR = BUGCHECK_ERROR(856u32);
pub const XBOX_CORRUPTED_IMAGE_BASE: BUGCHECK_ERROR = BUGCHECK_ERROR(857u32);
pub const XBOX_XDS_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(858u32);
pub const XBOX_SHUTDOWN_WATCHDOG_TIMEOUT: BUGCHECK_ERROR = BUGCHECK_ERROR(859u32);
pub const XBOX_360_SYSTEM_CRASH: BUGCHECK_ERROR = BUGCHECK_ERROR(864u32);
pub const XBOX_360_SYSTEM_CRASH_RESERVED: BUGCHECK_ERROR = BUGCHECK_ERROR(1056u32);
pub const XBOX_SECURITY_FAILUE: BUGCHECK_ERROR = BUGCHECK_ERROR(1057u32);
pub const KERNEL_CFG_INIT_FAILURE: BUGCHECK_ERROR = BUGCHECK_ERROR(1058u32);
pub const MANUALLY_INITIATED_POWER_BUTTON_HOLD_LIVE_DUMP: BUGCHECK_ERROR = BUGCHECK_ERROR(4552u32);
pub const HYPERVISOR_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(131073u32);
pub const WINLOGON_FATAL_ERROR: BUGCHECK_ERROR = BUGCHECK_ERROR(3221226010u32);
pub const MANUALLY_INITIATED_CRASH1: BUGCHECK_ERROR = BUGCHECK_ERROR(3735936685u32);
pub const BUGCHECK_CONTEXT_MODIFIER: BUGCHECK_ERROR = BUGCHECK_ERROR(2147483648u32);
impl ::core::convert::From<u32> for BUGCHECK_ERROR {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for BUGCHECK_ERROR {
    type Abi = Self;
}
impl ::core::ops::BitOr for BUGCHECK_ERROR {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for BUGCHECK_ERROR {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for BUGCHECK_ERROR {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for BUGCHECK_ERROR {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for BUGCHECK_ERROR {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Beep(dwfreq: u32, dwduration: u32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn Beep(dwfreq: u32, dwduration: u32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(Beep(::core::mem::transmute(dwfreq), ::core::mem::transmute(dwduration)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BindImage<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(imagename: Param0, dllpath: Param1, symbolpath: Param2) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BindImage(imagename: super::super::super::Foundation::PSTR, dllpath: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(BindImage(imagename.into_param().abi(), dllpath.into_param().abi(), symbolpath.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BindImageEx<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(flags: u32, imagename: Param1, dllpath: Param2, symbolpath: Param3, statusroutine: ::core::option::Option<PIMAGEHLP_STATUS_ROUTINE>) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BindImageEx(flags: u32, imagename: super::super::super::Foundation::PSTR, dllpath: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR, statusroutine: ::windows::core::RawPtr) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(BindImageEx(::core::mem::transmute(flags), imagename.into_param().abi(), dllpath.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(statusroutine)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const CANNOT_ALLOCATE_MEMORY: u32 = 9u32;
pub const CATID_ActiveScript: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0b7a1a1_9847_11cf_8f20_00805f2cd064);
pub const CATID_ActiveScriptAuthor: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0aee2a92_bcbb_11d0_8c72_00c04fc2b085);
pub const CATID_ActiveScriptEncode: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0b7a1a3_9847_11cf_8f20_00805f2cd064);
pub const CATID_ActiveScriptParse: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0b7a1a2_9847_11cf_8f20_00805f2cd064);
pub const CBA_CHECK_ARM_MACHINE_THUMB_TYPE_OVERRIDE: u32 = 2147483648u32;
pub const CBA_CHECK_ENGOPT_DISALLOW_NETWORK_PATHS: u32 = 1879048192u32;
pub const CBA_DEBUG_INFO: u32 = 268435456u32;
pub const CBA_DEFERRED_SYMBOL_LOAD_CANCEL: u32 = 7u32;
pub const CBA_DEFERRED_SYMBOL_LOAD_COMPLETE: u32 = 2u32;
pub const CBA_DEFERRED_SYMBOL_LOAD_FAILURE: u32 = 3u32;
pub const CBA_DEFERRED_SYMBOL_LOAD_PARTIAL: u32 = 32u32;
pub const CBA_DEFERRED_SYMBOL_LOAD_START: u32 = 1u32;
pub const CBA_DUPLICATE_SYMBOL: u32 = 5u32;
pub const CBA_ENGINE_PRESENT: u32 = 1610612736u32;
pub const CBA_EVENT: u32 = 16u32;
pub const CBA_MAP_JIT_SYMBOL: u32 = 2684354560u32;
pub const CBA_READ_MEMORY: u32 = 6u32;
pub const CBA_SET_OPTIONS: u32 = 8u32;
pub const CBA_SRCSRV_EVENT: u32 = 1073741824u32;
pub const CBA_SRCSRV_INFO: u32 = 536870912u32;
pub const CBA_SYMBOLS_UNLOADED: u32 = 4u32;
pub const CBA_UPDATE_STATUS_BAR: u32 = 1342177280u32;
pub const CBA_XML_LOG: u32 = 2415919104u32;
pub const CDebugDocumentHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x83b8bca6_687c_11d0_a405_00aa0060275c);
pub const CERT_PE_IMAGE_DIGEST_ALL_IMPORT_INFO: u32 = 4u32;
pub const CERT_PE_IMAGE_DIGEST_DEBUG_INFO: u32 = 1u32;
pub const CERT_PE_IMAGE_DIGEST_NON_PE_INFO: u32 = 8u32;
pub const CERT_PE_IMAGE_DIGEST_RESOURCES: u32 = 2u32;
pub const CERT_SECTION_TYPE_ANY: u32 = 255u32;
pub const CHECKSUM_MAPVIEW_FAILURE: u32 = 3u32;
pub const CHECKSUM_MAP_FAILURE: u32 = 2u32;
pub const CHECKSUM_OPEN_FAILURE: u32 = 1u32;
pub const CHECKSUM_SUCCESS: u32 = 0u32;
pub const CHECKSUM_UNICODE_FAILURE: u32 = 4u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub struct CONTEXT {
    pub ContextFlags: u32,
    pub Cpsr: u32,
    pub Anonymous: CONTEXT_0,
    pub Sp: u64,
    pub Pc: u64,
    pub V: [ARM64_NT_NEON128; 32],
    pub Fpcr: u32,
    pub Fpsr: u32,
    pub Bcr: [u32; 8],
    pub Bvr: [u64; 8],
    pub Wcr: [u32; 2],
    pub Wvr: [u64; 2],
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub union CONTEXT_0 {
    pub Anonymous: CONTEXT_0_0,
    pub X: [u64; 31],
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT_0 {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT_0 {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub struct CONTEXT_0_0 {
    pub X0: u64,
    pub X1: u64,
    pub X2: u64,
    pub X3: u64,
    pub X4: u64,
    pub X5: u64,
    pub X6: u64,
    pub X7: u64,
    pub X8: u64,
    pub X9: u64,
    pub X10: u64,
    pub X11: u64,
    pub X12: u64,
    pub X13: u64,
    pub X14: u64,
    pub X15: u64,
    pub X16: u64,
    pub X17: u64,
    pub X18: u64,
    pub X19: u64,
    pub X20: u64,
    pub X21: u64,
    pub X22: u64,
    pub X23: u64,
    pub X24: u64,
    pub X25: u64,
    pub X26: u64,
    pub X27: u64,
    pub X28: u64,
    pub Fp: u64,
    pub Lr: u64,
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT_0_0 {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for CONTEXT_0_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("X0", &self.X0)
            .field("X1", &self.X1)
            .field("X2", &self.X2)
            .field("X3", &self.X3)
            .field("X4", &self.X4)
            .field("X5", &self.X5)
            .field("X6", &self.X6)
            .field("X7", &self.X7)
            .field("X8", &self.X8)
            .field("X9", &self.X9)
            .field("X10", &self.X10)
            .field("X11", &self.X11)
            .field("X12", &self.X12)
            .field("X13", &self.X13)
            .field("X14", &self.X14)
            .field("X15", &self.X15)
            .field("X16", &self.X16)
            .field("X17", &self.X17)
            .field("X18", &self.X18)
            .field("X19", &self.X19)
            .field("X20", &self.X20)
            .field("X21", &self.X21)
            .field("X22", &self.X22)
            .field("X23", &self.X23)
            .field("X24", &self.X24)
            .field("X25", &self.X25)
            .field("X26", &self.X26)
            .field("X27", &self.X27)
            .field("X28", &self.X28)
            .field("Fp", &self.Fp)
            .field("Lr", &self.Lr)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.X0 == other.X0
            && self.X1 == other.X1
            && self.X2 == other.X2
            && self.X3 == other.X3
            && self.X4 == other.X4
            && self.X5 == other.X5
            && self.X6 == other.X6
            && self.X7 == other.X7
            && self.X8 == other.X8
            && self.X9 == other.X9
            && self.X10 == other.X10
            && self.X11 == other.X11
            && self.X12 == other.X12
            && self.X13 == other.X13
            && self.X14 == other.X14
            && self.X15 == other.X15
            && self.X16 == other.X16
            && self.X17 == other.X17
            && self.X18 == other.X18
            && self.X19 == other.X19
            && self.X20 == other.X20
            && self.X21 == other.X21
            && self.X22 == other.X22
            && self.X23 == other.X23
            && self.X24 == other.X24
            && self.X25 == other.X25
            && self.X26 == other.X26
            && self.X27 == other.X27
            && self.X28 == other.X28
            && self.Fp == other.Fp
            && self.Lr == other.Lr
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT_0_0 {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT_0_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub struct CONTEXT {
    pub P1Home: u64,
    pub P2Home: u64,
    pub P3Home: u64,
    pub P4Home: u64,
    pub P5Home: u64,
    pub P6Home: u64,
    pub ContextFlags: u32,
    pub MxCsr: u32,
    pub SegCs: u16,
    pub SegDs: u16,
    pub SegEs: u16,
    pub SegFs: u16,
    pub SegGs: u16,
    pub SegSs: u16,
    pub EFlags: u32,
    pub Dr0: u64,
    pub Dr1: u64,
    pub Dr2: u64,
    pub Dr3: u64,
    pub Dr6: u64,
    pub Dr7: u64,
    pub Rax: u64,
    pub Rcx: u64,
    pub Rdx: u64,
    pub Rbx: u64,
    pub Rsp: u64,
    pub Rbp: u64,
    pub Rsi: u64,
    pub Rdi: u64,
    pub R8: u64,
    pub R9: u64,
    pub R10: u64,
    pub R11: u64,
    pub R12: u64,
    pub R13: u64,
    pub R14: u64,
    pub R15: u64,
    pub Rip: u64,
    pub Anonymous: CONTEXT_0,
    pub VectorRegister: [M128A; 26],
    pub VectorControl: u64,
    pub DebugControl: u64,
    pub LastBranchToRip: u64,
    pub LastBranchFromRip: u64,
    pub LastExceptionToRip: u64,
    pub LastExceptionFromRip: u64,
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub union CONTEXT_0 {
    pub FltSave: XSAVE_FORMAT,
    pub Anonymous: CONTEXT_0_0,
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT_0 {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT_0 {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
pub struct CONTEXT_0_0 {
    pub Header: [M128A; 2],
    pub Legacy: [M128A; 8],
    pub Xmm0: M128A,
    pub Xmm1: M128A,
    pub Xmm2: M128A,
    pub Xmm3: M128A,
    pub Xmm4: M128A,
    pub Xmm5: M128A,
    pub Xmm6: M128A,
    pub Xmm7: M128A,
    pub Xmm8: M128A,
    pub Xmm9: M128A,
    pub Xmm10: M128A,
    pub Xmm11: M128A,
    pub Xmm12: M128A,
    pub Xmm13: M128A,
    pub Xmm14: M128A,
    pub Xmm15: M128A,
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for CONTEXT_0_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("Header", &self.Header)
            .field("Legacy", &self.Legacy)
            .field("Xmm0", &self.Xmm0)
            .field("Xmm1", &self.Xmm1)
            .field("Xmm2", &self.Xmm2)
            .field("Xmm3", &self.Xmm3)
            .field("Xmm4", &self.Xmm4)
            .field("Xmm5", &self.Xmm5)
            .field("Xmm6", &self.Xmm6)
            .field("Xmm7", &self.Xmm7)
            .field("Xmm8", &self.Xmm8)
            .field("Xmm9", &self.Xmm9)
            .field("Xmm10", &self.Xmm10)
            .field("Xmm11", &self.Xmm11)
            .field("Xmm12", &self.Xmm12)
            .field("Xmm13", &self.Xmm13)
            .field("Xmm14", &self.Xmm14)
            .field("Xmm15", &self.Xmm15)
            .finish()
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header
            && self.Legacy == other.Legacy
            && self.Xmm0 == other.Xmm0
            && self.Xmm1 == other.Xmm1
            && self.Xmm2 == other.Xmm2
            && self.Xmm3 == other.Xmm3
            && self.Xmm4 == other.Xmm4
            && self.Xmm5 == other.Xmm5
            && self.Xmm6 == other.Xmm6
            && self.Xmm7 == other.Xmm7
            && self.Xmm8 == other.Xmm8
            && self.Xmm9 == other.Xmm9
            && self.Xmm10 == other.Xmm10
            && self.Xmm11 == other.Xmm11
            && self.Xmm12 == other.Xmm12
            && self.Xmm13 == other.Xmm13
            && self.Xmm14 == other.Xmm14
            && self.Xmm15 == other.Xmm15
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT_0_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
pub struct CONTEXT {
    pub ContextFlags: u32,
    pub Dr0: u32,
    pub Dr1: u32,
    pub Dr2: u32,
    pub Dr3: u32,
    pub Dr6: u32,
    pub Dr7: u32,
    pub FloatSave: super::super::Kernel::FLOATING_SAVE_AREA,
    pub SegGs: u32,
    pub SegFs: u32,
    pub SegEs: u32,
    pub SegDs: u32,
    pub Edi: u32,
    pub Esi: u32,
    pub Ebx: u32,
    pub Edx: u32,
    pub Ecx: u32,
    pub Eax: u32,
    pub Ebp: u32,
    pub Eip: u32,
    pub SegCs: u32,
    pub EFlags: u32,
    pub Esp: u32,
    pub SegSs: u32,
    pub ExtendedRegisters: [u8; 512],
}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
impl CONTEXT {}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for CONTEXT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("CONTEXT")
            .field("ContextFlags", &self.ContextFlags)
            .field("Dr0", &self.Dr0)
            .field("Dr1", &self.Dr1)
            .field("Dr2", &self.Dr2)
            .field("Dr3", &self.Dr3)
            .field("Dr6", &self.Dr6)
            .field("Dr7", &self.Dr7)
            .field("FloatSave", &self.FloatSave)
            .field("SegGs", &self.SegGs)
            .field("SegFs", &self.SegFs)
            .field("SegEs", &self.SegEs)
            .field("SegDs", &self.SegDs)
            .field("Edi", &self.Edi)
            .field("Esi", &self.Esi)
            .field("Ebx", &self.Ebx)
            .field("Edx", &self.Edx)
            .field("Ecx", &self.Ecx)
            .field("Eax", &self.Eax)
            .field("Ebp", &self.Ebp)
            .field("Eip", &self.Eip)
            .field("SegCs", &self.SegCs)
            .field("EFlags", &self.EFlags)
            .field("Esp", &self.Esp)
            .field("SegSs", &self.SegSs)
            .field("ExtendedRegisters", &self.ExtendedRegisters)
            .finish()
    }
}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.ContextFlags == other.ContextFlags
            && self.Dr0 == other.Dr0
            && self.Dr1 == other.Dr1
            && self.Dr2 == other.Dr2
            && self.Dr3 == other.Dr3
            && self.Dr6 == other.Dr6
            && self.Dr7 == other.Dr7
            && self.FloatSave == other.FloatSave
            && self.SegGs == other.SegGs
            && self.SegFs == other.SegFs
            && self.SegEs == other.SegEs
            && self.SegDs == other.SegDs
            && self.Edi == other.Edi
            && self.Esi == other.Esi
            && self.Ebx == other.Ebx
            && self.Edx == other.Edx
            && self.Ecx == other.Ecx
            && self.Eax == other.Eax
            && self.Ebp == other.Ebp
            && self.Eip == other.Eip
            && self.SegCs == other.SegCs
            && self.EFlags == other.EFlags
            && self.Esp == other.Esp
            && self.SegSs == other.SegSs
            && self.ExtendedRegisters == other.ExtendedRegisters
    }
}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for CONTEXT {}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for CONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub union CPU_INFORMATION {
    pub X86CpuInfo: CPU_INFORMATION_1,
    pub OtherCpuInfo: CPU_INFORMATION_0,
}
impl CPU_INFORMATION {}
impl ::core::default::Default for CPU_INFORMATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for CPU_INFORMATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for CPU_INFORMATION {}
unsafe impl ::windows::core::Abi for CPU_INFORMATION {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C, packed(4))]
pub struct CPU_INFORMATION_0 {
    pub ProcessorFeatures: [u64; 2],
}
impl CPU_INFORMATION_0 {}
impl ::core::default::Default for CPU_INFORMATION_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for CPU_INFORMATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for CPU_INFORMATION_0 {}
unsafe impl ::windows::core::Abi for CPU_INFORMATION_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct CPU_INFORMATION_1 {
    pub VendorId: [u32; 3],
    pub VersionInformation: u32,
    pub FeatureInformation: u32,
    pub AMDExtendedCpuFeatures: u32,
}
impl CPU_INFORMATION_1 {}
impl ::core::default::Default for CPU_INFORMATION_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for CPU_INFORMATION_1 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_X86CpuInfo_e__Struct").field("VendorId", &self.VendorId).field("VersionInformation", &self.VersionInformation).field("FeatureInformation", &self.FeatureInformation).field("AMDExtendedCpuFeatures", &self.AMDExtendedCpuFeatures).finish()
    }
}
impl ::core::cmp::PartialEq for CPU_INFORMATION_1 {
    fn eq(&self, other: &Self) -> bool {
        self.VendorId == other.VendorId && self.VersionInformation == other.VersionInformation && self.FeatureInformation == other.FeatureInformation && self.AMDExtendedCpuFeatures == other.AMDExtendedCpuFeatures
    }
}
impl ::core::cmp::Eq for CPU_INFORMATION_1 {}
unsafe impl ::windows::core::Abi for CPU_INFORMATION_1 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
pub struct CREATE_PROCESS_DEBUG_INFO {
    pub hFile: super::super::super::Foundation::HANDLE,
    pub hProcess: super::super::super::Foundation::HANDLE,
    pub hThread: super::super::super::Foundation::HANDLE,
    pub lpBaseOfImage: *mut ::core::ffi::c_void,
    pub dwDebugInfoFileOffset: u32,
    pub nDebugInfoSize: u32,
    pub lpThreadLocalBase: *mut ::core::ffi::c_void,
    pub lpStartAddress: ::core::option::Option<super::super::Threading::LPTHREAD_START_ROUTINE>,
    pub lpImageName: *mut ::core::ffi::c_void,
    pub fUnicode: u16,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl CREATE_PROCESS_DEBUG_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::default::Default for CREATE_PROCESS_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::fmt::Debug for CREATE_PROCESS_DEBUG_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("CREATE_PROCESS_DEBUG_INFO")
            .field("hFile", &self.hFile)
            .field("hProcess", &self.hProcess)
            .field("hThread", &self.hThread)
            .field("lpBaseOfImage", &self.lpBaseOfImage)
            .field("dwDebugInfoFileOffset", &self.dwDebugInfoFileOffset)
            .field("nDebugInfoSize", &self.nDebugInfoSize)
            .field("lpThreadLocalBase", &self.lpThreadLocalBase)
            .field("lpImageName", &self.lpImageName)
            .field("fUnicode", &self.fUnicode)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::PartialEq for CREATE_PROCESS_DEBUG_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.hFile == other.hFile && self.hProcess == other.hProcess && self.hThread == other.hThread && self.lpBaseOfImage == other.lpBaseOfImage && self.dwDebugInfoFileOffset == other.dwDebugInfoFileOffset && self.nDebugInfoSize == other.nDebugInfoSize && self.lpThreadLocalBase == other.lpThreadLocalBase && self.lpStartAddress.map(|f| f as usize) == other.lpStartAddress.map(|f| f as usize) && self.lpImageName == other.lpImageName && self.fUnicode == other.fUnicode
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::Eq for CREATE_PROCESS_DEBUG_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
unsafe impl ::windows::core::Abi for CREATE_PROCESS_DEBUG_INFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
pub struct CREATE_THREAD_DEBUG_INFO {
    pub hThread: super::super::super::Foundation::HANDLE,
    pub lpThreadLocalBase: *mut ::core::ffi::c_void,
    pub lpStartAddress: ::core::option::Option<super::super::Threading::LPTHREAD_START_ROUTINE>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl CREATE_THREAD_DEBUG_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::default::Default for CREATE_THREAD_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::fmt::Debug for CREATE_THREAD_DEBUG_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("CREATE_THREAD_DEBUG_INFO").field("hThread", &self.hThread).field("lpThreadLocalBase", &self.lpThreadLocalBase).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::PartialEq for CREATE_THREAD_DEBUG_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.hThread == other.hThread && self.lpThreadLocalBase == other.lpThreadLocalBase && self.lpStartAddress.map(|f| f as usize) == other.lpStartAddress.map(|f| f as usize)
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::Eq for CREATE_THREAD_DEBUG_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
unsafe impl ::windows::core::Abi for CREATE_THREAD_DEBUG_INFO {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
pub const CROSS_PLATFORM_MAXIMUM_PROCESSORS: u32 = 2048u32;
pub const CURRENT_KD_SECONDARY_VERSION: u32 = 2u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct CallingConventionKind(pub i32);
pub const CallingConventionUnknown: CallingConventionKind = CallingConventionKind(0i32);
pub const CallingConventionCDecl: CallingConventionKind = CallingConventionKind(1i32);
pub const CallingConventionFastCall: CallingConventionKind = CallingConventionKind(2i32);
pub const CallingConventionStdCall: CallingConventionKind = CallingConventionKind(3i32);
pub const CallingConventionSysCall: CallingConventionKind = CallingConventionKind(4i32);
pub const CallingConventionThisCall: CallingConventionKind = CallingConventionKind(5i32);
impl ::core::convert::From<i32> for CallingConventionKind {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for CallingConventionKind {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CheckRemoteDebuggerPresent<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, pbdebuggerpresent: *mut super::super::super::Foundation::BOOL) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CheckRemoteDebuggerPresent(hprocess: super::super::super::Foundation::HANDLE, pbdebuggerpresent: *mut super::super::super::Foundation::BOOL) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CheckRemoteDebuggerPresent(hprocess.into_param().abi(), ::core::mem::transmute(pbdebuggerpresent)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
#[inline]
pub unsafe fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS64;
        }
        ::core::mem::transmute(CheckSumMappedFile(::core::mem::transmute(baseaddress), ::core::mem::transmute(filelength), ::core::mem::transmute(headersum), ::core::mem::transmute(checksum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86",))]
#[inline]
pub unsafe fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS32;
        }
        ::core::mem::transmute(CheckSumMappedFile(::core::mem::transmute(baseaddress), ::core::mem::transmute(filelength), ::core::mem::transmute(headersum), ::core::mem::transmute(checksum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn CloseThreadWaitChainSession(wcthandle: *const ::core::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseThreadWaitChainSession(wcthandle: *const ::core::ffi::c_void);
        }
        ::core::mem::transmute(CloseThreadWaitChainSession(::core::mem::transmute(wcthandle)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ContinueDebugEvent(dwprocessid: u32, dwthreadid: u32, dwcontinuestatus: u32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ContinueDebugEvent(dwprocessid: u32, dwthreadid: u32, dwcontinuestatus: u32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ContinueDebugEvent(::core::mem::transmute(dwprocessid), ::core::mem::transmute(dwthreadid), ::core::mem::transmute(dwcontinuestatus)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn CopyContext(destination: *mut CONTEXT, contextflags: u32, source: *const CONTEXT) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CopyContext(destination: *mut CONTEXT, contextflags: u32, source: *const CONTEXT) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CopyContext(::core::mem::transmute(destination), ::core::mem::transmute(contextflags), ::core::mem::transmute(source)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn CreateDataModelManager<'a, Param0: ::windows::core::IntoParam<'a, IDebugHost>>(debughost: Param0) -> ::windows::core::Result<IDataModelManager> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateDataModelManager(debughost: ::windows::core::RawPtr, manager: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: <IDataModelManager as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        CreateDataModelManager(debughost.into_param().abi(), &mut result__).from_abi::<IDataModelManager>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DBGHELP_DATA_REPORT_STRUCT {
    pub pBinPathNonExist: super::super::super::Foundation::PWSTR,
    pub pSymbolPathNonExist: super::super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DBGHELP_DATA_REPORT_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DBGHELP_DATA_REPORT_STRUCT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DBGHELP_DATA_REPORT_STRUCT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DBGHELP_DATA_REPORT_STRUCT").field("pBinPathNonExist", &self.pBinPathNonExist).field("pSymbolPathNonExist", &self.pSymbolPathNonExist).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DBGHELP_DATA_REPORT_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.pBinPathNonExist == other.pBinPathNonExist && self.pSymbolPathNonExist == other.pSymbolPathNonExist
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DBGHELP_DATA_REPORT_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DBGHELP_DATA_REPORT_STRUCT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct DBGKD_DEBUG_DATA_HEADER32 {
    pub List: super::super::Kernel::LIST_ENTRY32,
    pub OwnerTag: u32,
    pub Size: u32,
}
#[cfg(feature = "Win32_System_Kernel")]
impl DBGKD_DEBUG_DATA_HEADER32 {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for DBGKD_DEBUG_DATA_HEADER32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for DBGKD_DEBUG_DATA_HEADER32 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DBGKD_DEBUG_DATA_HEADER32").field("List", &self.List).field("OwnerTag", &self.OwnerTag).field("Size", &self.Size).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for DBGKD_DEBUG_DATA_HEADER32 {
    fn eq(&self, other: &Self) -> bool {
        self.List == other.List && self.OwnerTag == other.OwnerTag && self.Size == other.Size
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for DBGKD_DEBUG_DATA_HEADER32 {}
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for DBGKD_DEBUG_DATA_HEADER32 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct DBGKD_DEBUG_DATA_HEADER64 {
    pub List: super::super::Kernel::LIST_ENTRY64,
    pub OwnerTag: u32,
    pub Size: u32,
}
#[cfg(feature = "Win32_System_Kernel")]
impl DBGKD_DEBUG_DATA_HEADER64 {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for DBGKD_DEBUG_DATA_HEADER64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for DBGKD_DEBUG_DATA_HEADER64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DBGKD_DEBUG_DATA_HEADER64").field("List", &self.List).field("OwnerTag", &self.OwnerTag).field("Size", &self.Size).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for DBGKD_DEBUG_DATA_HEADER64 {
    fn eq(&self, other: &Self) -> bool {
        self.List == other.List && self.OwnerTag == other.OwnerTag && self.Size == other.Size
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for DBGKD_DEBUG_DATA_HEADER64 {}
#[cfg(feature = "Win32_System_Kernel")]
unsafe impl ::windows::core::Abi for DBGKD_DEBUG_DATA_HEADER64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DBGKD_GET_VERSION32 {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub ProtocolVersion: u16,
    pub Flags: u16,
    pub KernBase: u32,
    pub PsLoadedModuleList: u32,
    pub MachineType: u16,
    pub ThCallbackStack: u16,
    pub NextCallback: u16,
    pub FramePointer: u16,
    pub KiCallUserMode: u32,
    pub KeUserCallbackDispatcher: u32,
    pub BreakpointWithStatus: u32,
    pub DebuggerDataList: u32,
}
impl DBGKD_GET_VERSION32 {}
impl ::core::default::Default for DBGKD_GET_VERSION32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DBGKD_GET_VERSION32 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DBGKD_GET_VERSION32")
            .field("MajorVersion", &self.MajorVersion)
            .field("MinorVersion", &self.MinorVersion)
            .field("ProtocolVersion", &self.ProtocolVersion)
            .field("Flags", &self.Flags)
            .field("KernBase", &self.KernBase)
            .field("PsLoadedModuleList", &self.PsLoadedModuleList)
            .field("MachineType", &self.MachineType)
            .field("ThCallbackStack", &self.ThCallbackStack)
            .field("NextCallback", &self.NextCallback)
            .field("FramePointer", &self.FramePointer)
            .field("KiCallUserMode", &self.KiCallUserMode)
            .field("KeUserCallbackDispatcher", &self.KeUserCallbackDispatcher)
            .field("BreakpointWithStatus", &self.BreakpointWithStatus)
            .field("DebuggerDataList", &self.DebuggerDataList)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DBGKD_GET_VERSION32 {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion
            && self.MinorVersion == other.MinorVersion
            && self.ProtocolVersion == other.ProtocolVersion
            && self.Flags == other.Flags
            && self.KernBase == other.KernBase
            && self.PsLoadedModuleList == other.PsLoadedModuleList
            && self.MachineType == other.MachineType
            && self.ThCallbackStack == other.ThCallbackStack
            && self.NextCallback == other.NextCallback
            && self.FramePointer == other.FramePointer
            && self.KiCallUserMode == other.KiCallUserMode
            && self.KeUserCallbackDispatcher == other.KeUserCallbackDispatcher
            && self.BreakpointWithStatus == other.BreakpointWithStatus
            && self.DebuggerDataList == other.DebuggerDataList
    }
}
impl ::core::cmp::Eq for DBGKD_GET_VERSION32 {}
unsafe impl ::windows::core::Abi for DBGKD_GET_VERSION32 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DBGKD_GET_VERSION64 {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub ProtocolVersion: u8,
    pub KdSecondaryVersion: u8,
    pub Flags: u16,
    pub MachineType: u16,
    pub MaxPacketType: u8,
    pub MaxStateChange: u8,
    pub MaxManipulate: u8,
    pub Simulation: u8,
    pub Unused: [u16; 1],
    pub KernBase: u64,
    pub PsLoadedModuleList: u64,
    pub DebuggerDataList: u64,
}
impl DBGKD_GET_VERSION64 {}
impl ::core::default::Default for DBGKD_GET_VERSION64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DBGKD_GET_VERSION64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DBGKD_GET_VERSION64")
            .field("MajorVersion", &self.MajorVersion)
            .field("MinorVersion", &self.MinorVersion)
            .field("ProtocolVersion", &self.ProtocolVersion)
            .field("KdSecondaryVersion", &self.KdSecondaryVersion)
            .field("Flags", &self.Flags)
            .field("MachineType", &self.MachineType)
            .field("MaxPacketType", &self.MaxPacketType)
            .field("MaxStateChange", &self.MaxStateChange)
            .field("MaxManipulate", &self.MaxManipulate)
            .field("Simulation", &self.Simulation)
            .field("Unused", &self.Unused)
            .field("KernBase", &self.KernBase)
            .field("PsLoadedModuleList", &self.PsLoadedModuleList)
            .field("DebuggerDataList", &self.DebuggerDataList)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DBGKD_GET_VERSION64 {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion
            && self.MinorVersion == other.MinorVersion
            && self.ProtocolVersion == other.ProtocolVersion
            && self.KdSecondaryVersion == other.KdSecondaryVersion
            && self.Flags == other.Flags
            && self.MachineType == other.MachineType
            && self.MaxPacketType == other.MaxPacketType
            && self.MaxStateChange == other.MaxStateChange
            && self.MaxManipulate == other.MaxManipulate
            && self.Simulation == other.Simulation
            && self.Unused == other.Unused
            && self.KernBase == other.KernBase
            && self.PsLoadedModuleList == other.PsLoadedModuleList
            && self.DebuggerDataList == other.DebuggerDataList
    }
}
impl ::core::cmp::Eq for DBGKD_GET_VERSION64 {}
unsafe impl ::windows::core::Abi for DBGKD_GET_VERSION64 {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DBGKD_MAJOR_TYPES(pub i32);
pub const DBGKD_MAJOR_NT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(0i32);
pub const DBGKD_MAJOR_XBOX: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(1i32);
pub const DBGKD_MAJOR_BIG: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(2i32);
pub const DBGKD_MAJOR_EXDI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(3i32);
pub const DBGKD_MAJOR_NTBD: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(4i32);
pub const DBGKD_MAJOR_EFI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(5i32);
pub const DBGKD_MAJOR_TNT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(6i32);
pub const DBGKD_MAJOR_SINGULARITY: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(7i32);
pub const DBGKD_MAJOR_HYPERVISOR: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(8i32);
pub const DBGKD_MAJOR_MIDORI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(9i32);
pub const DBGKD_MAJOR_CE: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(10i32);
pub const DBGKD_MAJOR_COUNT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(11i32);
impl ::core::convert::From<i32> for DBGKD_MAJOR_TYPES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DBGKD_MAJOR_TYPES {
    type Abi = Self;
}
pub const DBGKD_SIMULATION_EXDI: i32 = 1i32;
pub const DBGKD_SIMULATION_NONE: i32 = 0i32;
pub const DBGKD_VERS_FLAG_DATA: u32 = 2u32;
pub const DBGKD_VERS_FLAG_HAL_IN_NTOS: u32 = 64u32;
pub const DBGKD_VERS_FLAG_HSS: u32 = 16u32;
pub const DBGKD_VERS_FLAG_MP: u32 = 1u32;
pub const DBGKD_VERS_FLAG_NOMM: u32 = 8u32;
pub const DBGKD_VERS_FLAG_PARTITIONS: u32 = 32u32;
pub const DBGKD_VERS_FLAG_PTR64: u32 = 4u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DBGPROP_ATTRIB_FLAGS(pub u32);
pub const DBGPROP_ATTRIB_NO_ATTRIB: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(0u32);
pub const DBGPROP_ATTRIB_VALUE_IS_INVALID: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(8u32);
pub const DBGPROP_ATTRIB_VALUE_IS_EXPANDABLE: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(16u32);
pub const DBGPROP_ATTRIB_VALUE_IS_FAKE: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(32u32);
pub const DBGPROP_ATTRIB_VALUE_IS_METHOD: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(256u32);
pub const DBGPROP_ATTRIB_VALUE_IS_EVENT: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(512u32);
pub const DBGPROP_ATTRIB_VALUE_IS_RAW_STRING: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(1024u32);
pub const DBGPROP_ATTRIB_VALUE_READONLY: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(2048u32);
pub const DBGPROP_ATTRIB_ACCESS_PUBLIC: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(4096u32);
pub const DBGPROP_ATTRIB_ACCESS_PRIVATE: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(8192u32);
pub const DBGPROP_ATTRIB_ACCESS_PROTECTED: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(16384u32);
pub const DBGPROP_ATTRIB_ACCESS_FINAL: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(32768u32);
pub const DBGPROP_ATTRIB_STORAGE_GLOBAL: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(65536u32);
pub const DBGPROP_ATTRIB_STORAGE_STATIC: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(131072u32);
pub const DBGPROP_ATTRIB_STORAGE_FIELD: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(262144u32);
pub const DBGPROP_ATTRIB_STORAGE_VIRTUAL: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(524288u32);
pub const DBGPROP_ATTRIB_TYPE_IS_CONSTANT: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(1048576u32);
pub const DBGPROP_ATTRIB_TYPE_IS_SYNCHRONIZED: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(2097152u32);
pub const DBGPROP_ATTRIB_TYPE_IS_VOLATILE: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(4194304u32);
pub const DBGPROP_ATTRIB_HAS_EXTENDED_ATTRIBS: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(8388608u32);
pub const DBGPROP_ATTRIB_FRAME_INTRYBLOCK: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(16777216u32);
pub const DBGPROP_ATTRIB_FRAME_INCATCHBLOCK: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(33554432u32);
pub const DBGPROP_ATTRIB_FRAME_INFINALLYBLOCK: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(67108864u32);
pub const DBGPROP_ATTRIB_VALUE_IS_RETURN_VALUE: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(134217728u32);
pub const DBGPROP_ATTRIB_VALUE_PENDING_MUTATION: DBGPROP_ATTRIB_FLAGS = DBGPROP_ATTRIB_FLAGS(268435456u32);
impl ::core::convert::From<u32> for DBGPROP_ATTRIB_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DBGPROP_ATTRIB_FLAGS {
    type Abi = Self;
}
impl ::core::ops::BitOr for DBGPROP_ATTRIB_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for DBGPROP_ATTRIB_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for DBGPROP_ATTRIB_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for DBGPROP_ATTRIB_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for DBGPROP_ATTRIB_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DBGPROP_INFO(pub u32);
pub const DBGPROP_INFO_NAME: DBGPROP_INFO = DBGPROP_INFO(1u32);
pub const DBGPROP_INFO_TYPE: DBGPROP_INFO = DBGPROP_INFO(2u32);
pub const DBGPROP_INFO_VALUE: DBGPROP_INFO = DBGPROP_INFO(4u32);
pub const DBGPROP_INFO_FULLNAME: DBGPROP_INFO = DBGPROP_INFO(32u32);
pub const DBGPROP_INFO_ATTRIBUTES: DBGPROP_INFO = DBGPROP_INFO(8u32);
pub const DBGPROP_INFO_DEBUGPROP: DBGPROP_INFO = DBGPROP_INFO(16u32);
pub const DBGPROP_INFO_BEAUTIFY: DBGPROP_INFO = DBGPROP_INFO(33554432u32);
pub const DBGPROP_INFO_CALLTOSTRING: DBGPROP_INFO = DBGPROP_INFO(67108864u32);
pub const DBGPROP_INFO_AUTOEXPAND: DBGPROP_INFO = DBGPROP_INFO(134217728u32);
impl ::core::convert::From<u32> for DBGPROP_INFO {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DBGPROP_INFO {
    type Abi = Self;
}
impl ::core::ops::BitOr for DBGPROP_INFO {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for DBGPROP_INFO {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for DBGPROP_INFO {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for DBGPROP_INFO {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for DBGPROP_INFO {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const DBG_DUMP_ADDRESS_AT_END: u32 = 131072u32;
pub const DBG_DUMP_ADDRESS_OF_FIELD: u32 = 65536u32;
pub const DBG_DUMP_ARRAY: u32 = 32768u32;
pub const DBG_DUMP_BLOCK_RECURSE: u32 = 2097152u32;
pub const DBG_DUMP_CALL_FOR_EACH: u32 = 8u32;
pub const DBG_DUMP_COMPACT_OUT: u32 = 8192u32;
pub const DBG_DUMP_COPY_TYPE_DATA: u32 = 262144u32;
pub const DBG_DUMP_FIELD_ARRAY: u32 = 16u32;
pub const DBG_DUMP_FIELD_CALL_BEFORE_PRINT: u32 = 1u32;
pub const DBG_DUMP_FIELD_COPY_FIELD_DATA: u32 = 32u32;
pub const DBG_DUMP_FIELD_DEFAULT_STRING: u32 = 65536u32;
pub const DBG_DUMP_FIELD_FULL_NAME: u32 = 8u32;
pub const DBG_DUMP_FIELD_GUID_STRING: u32 = 524288u32;
pub const DBG_DUMP_FIELD_MULTI_STRING: u32 = 262144u32;
pub const DBG_DUMP_FIELD_NO_CALLBACK_REQ: u32 = 2u32;
pub const DBG_DUMP_FIELD_NO_PRINT: u32 = 16384u32;
pub const DBG_DUMP_FIELD_RECUR_ON_THIS: u32 = 4u32;
pub const DBG_DUMP_FIELD_RETURN_ADDRESS: u32 = 4096u32;
pub const DBG_DUMP_FIELD_SIZE_IN_BITS: u32 = 8192u32;
pub const DBG_DUMP_FIELD_UTF32_STRING: u32 = 1048576u32;
pub const DBG_DUMP_FIELD_WCHAR_STRING: u32 = 131072u32;
pub const DBG_DUMP_FUNCTION_FORMAT: u32 = 1048576u32;
pub const DBG_DUMP_GET_SIZE_ONLY: u32 = 128u32;
pub const DBG_DUMP_LIST: u32 = 32u32;
pub const DBG_DUMP_MATCH_SIZE: u32 = 4194304u32;
pub const DBG_DUMP_NO_INDENT: u32 = 1u32;
pub const DBG_DUMP_NO_OFFSET: u32 = 2u32;
pub const DBG_DUMP_NO_PRINT: u32 = 64u32;
pub const DBG_DUMP_READ_PHYSICAL: u32 = 524288u32;
pub const DBG_DUMP_VERBOSE: u32 = 4u32;
pub const DBG_FRAME_DEFAULT: u32 = 0u32;
pub const DBG_FRAME_IGNORE_INLINE: u32 = 4294967295u32;
pub const DBG_RETURN_SUBTYPES: u32 = 0u32;
pub const DBG_RETURN_TYPE: u32 = 0u32;
pub const DBG_RETURN_TYPE_VALUES: u32 = 0u32;
pub const DBHHEADER_PDBGUID: u32 = 3u32;
pub const DEBUG_ADDSYNTHMOD_DEFAULT: u32 = 0u32;
pub const DEBUG_ADDSYNTHMOD_ZEROBASE: u32 = 1u32;
pub const DEBUG_ADDSYNTHSYM_DEFAULT: u32 = 0u32;
pub const DEBUG_ANY_ID: u32 = 4294967295u32;
pub const DEBUG_ASMOPT_DEFAULT: u32 = 0u32;
pub const DEBUG_ASMOPT_IGNORE_OUTPUT_WIDTH: u32 = 4u32;
pub const DEBUG_ASMOPT_NO_CODE_BYTES: u32 = 2u32;
pub const DEBUG_ASMOPT_SOURCE_LINE_NUMBER: u32 = 8u32;
pub const DEBUG_ASMOPT_VERBOSE: u32 = 1u32;
pub const DEBUG_ATTACH_DEFAULT: u32 = 0u32;
pub const DEBUG_ATTACH_EXDI_DRIVER: u32 = 2u32;
pub const DEBUG_ATTACH_EXISTING: u32 = 2u32;
pub const DEBUG_ATTACH_INSTALL_DRIVER: u32 = 4u32;
pub const DEBUG_ATTACH_INVASIVE_NO_INITIAL_BREAK: u32 = 8u32;
pub const DEBUG_ATTACH_INVASIVE_RESUME_PROCESS: u32 = 16u32;
pub const DEBUG_ATTACH_KERNEL_CONNECTION: u32 = 0u32;
pub const DEBUG_ATTACH_LOCAL_KERNEL: u32 = 1u32;
pub const DEBUG_ATTACH_NONINVASIVE: u32 = 1u32;
pub const DEBUG_ATTACH_NONINVASIVE_ALLOW_PARTIAL: u32 = 32u32;
pub const DEBUG_ATTACH_NONINVASIVE_NO_SUSPEND: u32 = 4u32;
pub const DEBUG_BREAKPOINT_ADDER_ONLY: u32 = 8u32;
pub const DEBUG_BREAKPOINT_CODE: u32 = 0u32;
pub const DEBUG_BREAKPOINT_DATA: u32 = 1u32;
pub const DEBUG_BREAKPOINT_DEFERRED: u32 = 2u32;
pub const DEBUG_BREAKPOINT_ENABLED: u32 = 4u32;
pub const DEBUG_BREAKPOINT_GO_ONLY: u32 = 1u32;
pub const DEBUG_BREAKPOINT_INLINE: u32 = 3u32;
pub const DEBUG_BREAKPOINT_ONE_SHOT: u32 = 16u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_BREAKPOINT_PARAMETERS {
    pub Offset: u64,
    pub Id: u32,
    pub BreakType: u32,
    pub ProcType: u32,
    pub Flags: u32,
    pub DataSize: u32,
    pub DataAccessType: u32,
    pub PassCount: u32,
    pub CurrentPassCount: u32,
    pub MatchThread: u32,
    pub CommandSize: u32,
    pub OffsetExpressionSize: u32,
}
impl DEBUG_BREAKPOINT_PARAMETERS {}
impl ::core::default::Default for DEBUG_BREAKPOINT_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_BREAKPOINT_PARAMETERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_BREAKPOINT_PARAMETERS")
            .field("Offset", &self.Offset)
            .field("Id", &self.Id)
            .field("BreakType", &self.BreakType)
            .field("ProcType", &self.ProcType)
            .field("Flags", &self.Flags)
            .field("DataSize", &self.DataSize)
            .field("DataAccessType", &self.DataAccessType)
            .field("PassCount", &self.PassCount)
            .field("CurrentPassCount", &self.CurrentPassCount)
            .field("MatchThread", &self.MatchThread)
            .field("CommandSize", &self.CommandSize)
            .field("OffsetExpressionSize", &self.OffsetExpressionSize)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_BREAKPOINT_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Id == other.Id && self.BreakType == other.BreakType && self.ProcType == other.ProcType && self.Flags == other.Flags && self.DataSize == other.DataSize && self.DataAccessType == other.DataAccessType && self.PassCount == other.PassCount && self.CurrentPassCount == other.CurrentPassCount && self.MatchThread == other.MatchThread && self.CommandSize == other.CommandSize && self.OffsetExpressionSize == other.OffsetExpressionSize
    }
}
impl ::core::cmp::Eq for DEBUG_BREAKPOINT_PARAMETERS {}
unsafe impl ::windows::core::Abi for DEBUG_BREAKPOINT_PARAMETERS {
    type Abi = Self;
}
pub const DEBUG_BREAKPOINT_TIME: u32 = 2u32;
pub const DEBUG_BREAK_EXECUTE: u32 = 4u32;
pub const DEBUG_BREAK_IO: u32 = 8u32;
pub const DEBUG_BREAK_READ: u32 = 1u32;
pub const DEBUG_BREAK_WRITE: u32 = 2u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_CACHED_SYMBOL_INFO {
    pub ModBase: u64,
    pub Arg1: u64,
    pub Arg2: u64,
    pub Id: u32,
    pub Arg3: u32,
}
impl DEBUG_CACHED_SYMBOL_INFO {}
impl ::core::default::Default for DEBUG_CACHED_SYMBOL_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_CACHED_SYMBOL_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_CACHED_SYMBOL_INFO").field("ModBase", &self.ModBase).field("Arg1", &self.Arg1).field("Arg2", &self.Arg2).field("Id", &self.Id).field("Arg3", &self.Arg3).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_CACHED_SYMBOL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ModBase == other.ModBase && self.Arg1 == other.Arg1 && self.Arg2 == other.Arg2 && self.Id == other.Id && self.Arg3 == other.Arg3
    }
}
impl ::core::cmp::Eq for DEBUG_CACHED_SYMBOL_INFO {}
unsafe impl ::windows::core::Abi for DEBUG_CACHED_SYMBOL_INFO {
    type Abi = Self;
}
pub const DEBUG_CDS_ALL: u32 = 4294967295u32;
pub const DEBUG_CDS_DATA: u32 = 2u32;
pub const DEBUG_CDS_REFRESH: u32 = 4u32;
pub const DEBUG_CDS_REFRESH_ADDBREAKPOINT: u32 = 4u32;
pub const DEBUG_CDS_REFRESH_EVALUATE: u32 = 1u32;
pub const DEBUG_CDS_REFRESH_EXECUTE: u32 = 2u32;
pub const DEBUG_CDS_REFRESH_EXECUTECOMMANDFILE: u32 = 3u32;
pub const DEBUG_CDS_REFRESH_INLINESTEP: u32 = 16u32;
pub const DEBUG_CDS_REFRESH_INLINESTEP_PSEUDO: u32 = 17u32;
pub const DEBUG_CDS_REFRESH_REMOVEBREAKPOINT: u32 = 5u32;
pub const DEBUG_CDS_REFRESH_SETSCOPE: u32 = 12u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFRAMEBYINDEX: u32 = 13u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFROMJITDEBUGINFO: u32 = 14u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFROMSTOREDEVENT: u32 = 15u32;
pub const DEBUG_CDS_REFRESH_SETVALUE: u32 = 10u32;
pub const DEBUG_CDS_REFRESH_SETVALUE2: u32 = 11u32;
pub const DEBUG_CDS_REFRESH_WRITEPHYSICAL: u32 = 8u32;
pub const DEBUG_CDS_REFRESH_WRITEPHYSICAL2: u32 = 9u32;
pub const DEBUG_CDS_REFRESH_WRITEVIRTUAL: u32 = 6u32;
pub const DEBUG_CDS_REFRESH_WRITEVIRTUALUNCACHED: u32 = 7u32;
pub const DEBUG_CDS_REGISTERS: u32 = 1u32;
pub const DEBUG_CES_ALL: u32 = 4294967295u32;
pub const DEBUG_CES_ASSEMBLY_OPTIONS: u32 = 4096u32;
pub const DEBUG_CES_BREAKPOINTS: u32 = 4u32;
pub const DEBUG_CES_CODE_LEVEL: u32 = 8u32;
pub const DEBUG_CES_CURRENT_THREAD: u32 = 1u32;
pub const DEBUG_CES_EFFECTIVE_PROCESSOR: u32 = 2u32;
pub const DEBUG_CES_ENGINE_OPTIONS: u32 = 32u32;
pub const DEBUG_CES_EVENT_FILTERS: u32 = 256u32;
pub const DEBUG_CES_EXECUTION_STATUS: u32 = 16u32;
pub const DEBUG_CES_EXPRESSION_SYNTAX: u32 = 8192u32;
pub const DEBUG_CES_EXTENSIONS: u32 = 1024u32;
pub const DEBUG_CES_LOG_FILE: u32 = 64u32;
pub const DEBUG_CES_PROCESS_OPTIONS: u32 = 512u32;
pub const DEBUG_CES_RADIX: u32 = 128u32;
pub const DEBUG_CES_SYSTEMS: u32 = 2048u32;
pub const DEBUG_CES_TEXT_REPLACEMENTS: u32 = 16384u32;
pub const DEBUG_CLASS_IMAGE_FILE: u32 = 3u32;
pub const DEBUG_CLASS_KERNEL: u32 = 1u32;
pub const DEBUG_CLASS_UNINITIALIZED: u32 = 0u32;
pub const DEBUG_CLASS_USER_WINDOWS: u32 = 2u32;
pub const DEBUG_CLIENT_CDB: u32 = 4u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_CLIENT_CONTEXT {
    pub cbSize: u32,
    pub eClient: u32,
}
impl DEBUG_CLIENT_CONTEXT {}
impl ::core::default::Default for DEBUG_CLIENT_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_CLIENT_CONTEXT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_CLIENT_CONTEXT").field("cbSize", &self.cbSize).field("eClient", &self.eClient).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_CLIENT_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.eClient == other.eClient
    }
}
impl ::core::cmp::Eq for DEBUG_CLIENT_CONTEXT {}
unsafe impl ::windows::core::Abi for DEBUG_CLIENT_CONTEXT {
    type Abi = Self;
}
pub const DEBUG_CLIENT_KD: u32 = 5u32;
pub const DEBUG_CLIENT_NTKD: u32 = 3u32;
pub const DEBUG_CLIENT_NTSD: u32 = 2u32;
pub const DEBUG_CLIENT_UNKNOWN: u32 = 0u32;
pub const DEBUG_CLIENT_VSINT: u32 = 1u32;
pub const DEBUG_CLIENT_WINDBG: u32 = 6u32;
pub const DEBUG_CLIENT_WINIDE: u32 = 7u32;
pub const DEBUG_CMDEX_ADD_EVENT_STRING: u32 = 1u32;
pub const DEBUG_CMDEX_INVALID: u32 = 0u32;
pub const DEBUG_CMDEX_RESET_EVENT_STRINGS: u32 = 2u32;
pub const DEBUG_COMMAND_EXCEPTION_ID: u32 = 3688893886u32;
pub const DEBUG_CONNECT_SESSION_DEFAULT: u32 = 0u32;
pub const DEBUG_CONNECT_SESSION_NO_ANNOUNCE: u32 = 2u32;
pub const DEBUG_CONNECT_SESSION_NO_VERSION: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_CREATE_PROCESS_OPTIONS {
    pub CreateFlags: u32,
    pub EngCreateFlags: u32,
    pub VerifierFlags: u32,
    pub Reserved: u32,
}
impl DEBUG_CREATE_PROCESS_OPTIONS {}
impl ::core::default::Default for DEBUG_CREATE_PROCESS_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_CREATE_PROCESS_OPTIONS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_CREATE_PROCESS_OPTIONS").field("CreateFlags", &self.CreateFlags).field("EngCreateFlags", &self.EngCreateFlags).field("VerifierFlags", &self.VerifierFlags).field("Reserved", &self.Reserved).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_CREATE_PROCESS_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.CreateFlags == other.CreateFlags && self.EngCreateFlags == other.EngCreateFlags && self.VerifierFlags == other.VerifierFlags && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_CREATE_PROCESS_OPTIONS {}
unsafe impl ::windows::core::Abi for DEBUG_CREATE_PROCESS_OPTIONS {
    type Abi = Self;
}
pub const DEBUG_CSS_ALL: u32 = 4294967295u32;
pub const DEBUG_CSS_COLLAPSE_CHILDREN: u32 = 64u32;
pub const DEBUG_CSS_LOADS: u32 = 1u32;
pub const DEBUG_CSS_PATHS: u32 = 8u32;
pub const DEBUG_CSS_SCOPE: u32 = 4u32;
pub const DEBUG_CSS_SYMBOL_OPTIONS: u32 = 16u32;
pub const DEBUG_CSS_TYPE_OPTIONS: u32 = 32u32;
pub const DEBUG_CSS_UNLOADS: u32 = 2u32;
pub const DEBUG_CURRENT_DEFAULT: u32 = 15u32;
pub const DEBUG_CURRENT_DISASM: u32 = 2u32;
pub const DEBUG_CURRENT_REGISTERS: u32 = 4u32;
pub const DEBUG_CURRENT_SOURCE_LINE: u32 = 8u32;
pub const DEBUG_CURRENT_SYMBOL: u32 = 1u32;
pub const DEBUG_DATA_BASE_TRANSLATION_VIRTUAL_OFFSET: u32 = 3u32;
pub const DEBUG_DATA_BreakpointWithStatusAddr: u32 = 32u32;
pub const DEBUG_DATA_CmNtCSDVersionAddr: u32 = 616u32;
pub const DEBUG_DATA_DumpAttributes: u32 = 100072u32;
pub const DEBUG_DATA_DumpFormatVersion: u32 = 100040u32;
pub const DEBUG_DATA_DumpMmStorage: u32 = 100064u32;
pub const DEBUG_DATA_DumpPowerState: u32 = 100056u32;
pub const DEBUG_DATA_DumpWriterStatus: u32 = 100032u32;
pub const DEBUG_DATA_DumpWriterVersion: u32 = 100048u32;
pub const DEBUG_DATA_EtwpDebuggerData: u32 = 816u32;
pub const DEBUG_DATA_ExpNumberOfPagedPoolsAddr: u32 = 112u32;
pub const DEBUG_DATA_ExpPagedPoolDescriptorAddr: u32 = 104u32;
pub const DEBUG_DATA_ExpSystemResourcesListAddr: u32 = 96u32;
pub const DEBUG_DATA_IopErrorLogListHeadAddr: u32 = 144u32;
pub const DEBUG_DATA_KPCR_OFFSET: u32 = 0u32;
pub const DEBUG_DATA_KPRCB_OFFSET: u32 = 1u32;
pub const DEBUG_DATA_KTHREAD_OFFSET: u32 = 2u32;
pub const DEBUG_DATA_KdPrintBufferSizeAddr: u32 = 720u32;
pub const DEBUG_DATA_KdPrintCircularBufferAddr: u32 = 480u32;
pub const DEBUG_DATA_KdPrintCircularBufferEndAddr: u32 = 488u32;
pub const DEBUG_DATA_KdPrintCircularBufferPtrAddr: u32 = 712u32;
pub const DEBUG_DATA_KdPrintRolloverCountAddr: u32 = 504u32;
pub const DEBUG_DATA_KdPrintWritePointerAddr: u32 = 496u32;
pub const DEBUG_DATA_KeBugCheckCallbackListHeadAddr: u32 = 128u32;
pub const DEBUG_DATA_KeTimeIncrementAddr: u32 = 120u32;
pub const DEBUG_DATA_KeUserCallbackDispatcherAddr: u32 = 64u32;
pub const DEBUG_DATA_KernBase: u32 = 24u32;
pub const DEBUG_DATA_KernelVerifierAddr: u32 = 576u32;
pub const DEBUG_DATA_KiBugcheckDataAddr: u32 = 136u32;
pub const DEBUG_DATA_KiCallUserModeAddr: u32 = 56u32;
pub const DEBUG_DATA_KiNormalSystemCall: u32 = 528u32;
pub const DEBUG_DATA_KiProcessorBlockAddr: u32 = 536u32;
pub const DEBUG_DATA_MmAllocatedNonPagedPoolAddr: u32 = 592u32;
pub const DEBUG_DATA_MmAvailablePagesAddr: u32 = 424u32;
pub const DEBUG_DATA_MmBadPagesDetected: u32 = 800u32;
pub const DEBUG_DATA_MmDriverCommitAddr: u32 = 352u32;
pub const DEBUG_DATA_MmExtendedCommitAddr: u32 = 376u32;
pub const DEBUG_DATA_MmFreePageListHeadAddr: u32 = 392u32;
pub const DEBUG_DATA_MmHighestPhysicalPageAddr: u32 = 240u32;
pub const DEBUG_DATA_MmHighestUserAddressAddr: u32 = 456u32;
pub const DEBUG_DATA_MmLastUnloadedDriverAddr: u32 = 552u32;
pub const DEBUG_DATA_MmLoadedUserImageListAddr: u32 = 512u32;
pub const DEBUG_DATA_MmLowestPhysicalPageAddr: u32 = 232u32;
pub const DEBUG_DATA_MmMaximumNonPagedPoolInBytesAddr: u32 = 256u32;
pub const DEBUG_DATA_MmModifiedNoWritePageListHeadAddr: u32 = 416u32;
pub const DEBUG_DATA_MmModifiedPageListHeadAddr: u32 = 408u32;
pub const DEBUG_DATA_MmNonPagedPoolEndAddr: u32 = 280u32;
pub const DEBUG_DATA_MmNonPagedPoolStartAddr: u32 = 272u32;
pub const DEBUG_DATA_MmNonPagedSystemStartAddr: u32 = 264u32;
pub const DEBUG_DATA_MmNumberOfPagingFilesAddr: u32 = 224u32;
pub const DEBUG_DATA_MmNumberOfPhysicalPagesAddr: u32 = 248u32;
pub const DEBUG_DATA_MmPageSize: u32 = 312u32;
pub const DEBUG_DATA_MmPagedPoolCommitAddr: u32 = 368u32;
pub const DEBUG_DATA_MmPagedPoolEndAddr: u32 = 296u32;
pub const DEBUG_DATA_MmPagedPoolInformationAddr: u32 = 304u32;
pub const DEBUG_DATA_MmPagedPoolStartAddr: u32 = 288u32;
pub const DEBUG_DATA_MmPeakCommitmentAddr: u32 = 600u32;
pub const DEBUG_DATA_MmPfnDatabaseAddr: u32 = 192u32;
pub const DEBUG_DATA_MmPhysicalMemoryBlockAddr: u32 = 624u32;
pub const DEBUG_DATA_MmProcessCommitAddr: u32 = 360u32;
pub const DEBUG_DATA_MmResidentAvailablePagesAddr: u32 = 432u32;
pub const DEBUG_DATA_MmSessionBase: u32 = 632u32;
pub const DEBUG_DATA_MmSessionSize: u32 = 640u32;
pub const DEBUG_DATA_MmSharedCommitAddr: u32 = 344u32;
pub const DEBUG_DATA_MmSizeOfPagedPoolInBytesAddr: u32 = 320u32;
pub const DEBUG_DATA_MmSpecialPoolTagAddr: u32 = 568u32;
pub const DEBUG_DATA_MmStandbyPageListHeadAddr: u32 = 400u32;
pub const DEBUG_DATA_MmSubsectionBaseAddr: u32 = 216u32;
pub const DEBUG_DATA_MmSystemCacheEndAddr: u32 = 176u32;
pub const DEBUG_DATA_MmSystemCacheStartAddr: u32 = 168u32;
pub const DEBUG_DATA_MmSystemCacheWsAddr: u32 = 184u32;
pub const DEBUG_DATA_MmSystemParentTablePage: u32 = 648u32;
pub const DEBUG_DATA_MmSystemPtesEndAddr: u32 = 208u32;
pub const DEBUG_DATA_MmSystemPtesStartAddr: u32 = 200u32;
pub const DEBUG_DATA_MmSystemRangeStartAddr: u32 = 464u32;
pub const DEBUG_DATA_MmTotalCommitLimitAddr: u32 = 328u32;
pub const DEBUG_DATA_MmTotalCommitLimitMaximumAddr: u32 = 608u32;
pub const DEBUG_DATA_MmTotalCommittedPagesAddr: u32 = 336u32;
pub const DEBUG_DATA_MmTriageActionTakenAddr: u32 = 560u32;
pub const DEBUG_DATA_MmUnloadedDriversAddr: u32 = 544u32;
pub const DEBUG_DATA_MmUserProbeAddressAddr: u32 = 472u32;
pub const DEBUG_DATA_MmVerifierDataAddr: u32 = 584u32;
pub const DEBUG_DATA_MmVirtualTranslationBase: u32 = 656u32;
pub const DEBUG_DATA_MmZeroedPageListHeadAddr: u32 = 384u32;
pub const DEBUG_DATA_NonPagedPoolDescriptorAddr: u32 = 448u32;
pub const DEBUG_DATA_NtBuildLabAddr: u32 = 520u32;
pub const DEBUG_DATA_ObpRootDirectoryObjectAddr: u32 = 152u32;
pub const DEBUG_DATA_ObpTypeObjectTypeAddr: u32 = 160u32;
pub const DEBUG_DATA_OffsetEprocessDirectoryTableBase: u32 = 686u32;
pub const DEBUG_DATA_OffsetEprocessParentCID: u32 = 684u32;
pub const DEBUG_DATA_OffsetEprocessPeb: u32 = 682u32;
pub const DEBUG_DATA_OffsetKThreadApcProcess: u32 = 672u32;
pub const DEBUG_DATA_OffsetKThreadBStore: u32 = 676u32;
pub const DEBUG_DATA_OffsetKThreadBStoreLimit: u32 = 678u32;
pub const DEBUG_DATA_OffsetKThreadInitialStack: u32 = 670u32;
pub const DEBUG_DATA_OffsetKThreadKernelStack: u32 = 668u32;
pub const DEBUG_DATA_OffsetKThreadNextProcessor: u32 = 664u32;
pub const DEBUG_DATA_OffsetKThreadState: u32 = 674u32;
pub const DEBUG_DATA_OffsetKThreadTeb: u32 = 666u32;
pub const DEBUG_DATA_OffsetPrcbCpuType: u32 = 696u32;
pub const DEBUG_DATA_OffsetPrcbCurrentThread: u32 = 692u32;
pub const DEBUG_DATA_OffsetPrcbDpcRoutine: u32 = 690u32;
pub const DEBUG_DATA_OffsetPrcbMhz: u32 = 694u32;
pub const DEBUG_DATA_OffsetPrcbNumber: u32 = 702u32;
pub const DEBUG_DATA_OffsetPrcbProcessorState: u32 = 700u32;
pub const DEBUG_DATA_OffsetPrcbVendorString: u32 = 698u32;
pub const DEBUG_DATA_PROCESSOR_IDENTIFICATION: u32 = 4u32;
pub const DEBUG_DATA_PROCESSOR_SPEED: u32 = 5u32;
pub const DEBUG_DATA_PaeEnabled: u32 = 100000u32;
pub const DEBUG_DATA_PoolTrackTableAddr: u32 = 440u32;
pub const DEBUG_DATA_ProductType: u32 = 100016u32;
pub const DEBUG_DATA_PsActiveProcessHeadAddr: u32 = 80u32;
pub const DEBUG_DATA_PsLoadedModuleListAddr: u32 = 72u32;
pub const DEBUG_DATA_PspCidTableAddr: u32 = 88u32;
pub const DEBUG_DATA_PteBase: u32 = 864u32;
pub const DEBUG_DATA_SPACE_BUS_DATA: u32 = 5u32;
pub const DEBUG_DATA_SPACE_CONTROL: u32 = 2u32;
pub const DEBUG_DATA_SPACE_COUNT: u32 = 7u32;
pub const DEBUG_DATA_SPACE_DEBUGGER_DATA: u32 = 6u32;
pub const DEBUG_DATA_SPACE_IO: u32 = 3u32;
pub const DEBUG_DATA_SPACE_MSR: u32 = 4u32;
pub const DEBUG_DATA_SPACE_PHYSICAL: u32 = 1u32;
pub const DEBUG_DATA_SPACE_VIRTUAL: u32 = 0u32;
pub const DEBUG_DATA_SavedContextAddr: u32 = 40u32;
pub const DEBUG_DATA_SharedUserData: u32 = 100008u32;
pub const DEBUG_DATA_SizeEProcess: u32 = 680u32;
pub const DEBUG_DATA_SizeEThread: u32 = 704u32;
pub const DEBUG_DATA_SizePrcb: u32 = 688u32;
pub const DEBUG_DATA_SuiteMask: u32 = 100024u32;
pub const DEBUG_DISASM_EFFECTIVE_ADDRESS: u32 = 1u32;
pub const DEBUG_DISASM_MATCHING_SYMBOLS: u32 = 2u32;
pub const DEBUG_DISASM_SOURCE_FILE_NAME: u32 = 8u32;
pub const DEBUG_DISASM_SOURCE_LINE_NUMBER: u32 = 4u32;
pub const DEBUG_DUMP_ACTIVE: u32 = 1030u32;
pub const DEBUG_DUMP_DEFAULT: u32 = 1025u32;
pub const DEBUG_DUMP_FILE_BASE: u32 = 4294967295u32;
pub const DEBUG_DUMP_FILE_LOAD_FAILED_INDEX: u32 = 4294967295u32;
pub const DEBUG_DUMP_FILE_ORIGINAL_CAB_INDEX: u32 = 4294967294u32;
pub const DEBUG_DUMP_FILE_PAGE_FILE_DUMP: u32 = 0u32;
pub const DEBUG_DUMP_FULL: u32 = 1026u32;
pub const DEBUG_DUMP_IMAGE_FILE: u32 = 1027u32;
pub const DEBUG_DUMP_SMALL: u32 = 1024u32;
pub const DEBUG_DUMP_TRACE_LOG: u32 = 1028u32;
pub const DEBUG_DUMP_WINDOWS_CE: u32 = 1029u32;
pub const DEBUG_ECREATE_PROCESS_DEFAULT: u32 = 0u32;
pub const DEBUG_ECREATE_PROCESS_INHERIT_HANDLES: u32 = 1u32;
pub const DEBUG_ECREATE_PROCESS_USE_IMPLICIT_COMMAND_LINE: u32 = 4u32;
pub const DEBUG_ECREATE_PROCESS_USE_VERIFIER_FLAGS: u32 = 2u32;
pub const DEBUG_EINDEX_FROM_CURRENT: u32 = 2u32;
pub const DEBUG_EINDEX_FROM_END: u32 = 1u32;
pub const DEBUG_EINDEX_FROM_START: u32 = 0u32;
pub const DEBUG_EINDEX_NAME: u32 = 0u32;
pub const DEBUG_END_ACTIVE_DETACH: u32 = 2u32;
pub const DEBUG_END_ACTIVE_TERMINATE: u32 = 1u32;
pub const DEBUG_END_DISCONNECT: u32 = 4u32;
pub const DEBUG_END_PASSIVE: u32 = 0u32;
pub const DEBUG_END_REENTRANT: u32 = 3u32;
pub const DEBUG_ENGOPT_ALL: u32 = 15728639u32;
pub const DEBUG_ENGOPT_ALLOW_NETWORK_PATHS: u32 = 4u32;
pub const DEBUG_ENGOPT_ALLOW_READ_ONLY_BREAKPOINTS: u32 = 1024u32;
pub const DEBUG_ENGOPT_DEBUGGING_SENSITIVE_DATA: u32 = 4194304u32;
pub const DEBUG_ENGOPT_DISABLESQM: u32 = 524288u32;
pub const DEBUG_ENGOPT_DISABLE_EXECUTION_COMMANDS: u32 = 65536u32;
pub const DEBUG_ENGOPT_DISABLE_MANAGED_SUPPORT: u32 = 16384u32;
pub const DEBUG_ENGOPT_DISABLE_MODULE_SYMBOL_LOAD: u32 = 32768u32;
pub const DEBUG_ENGOPT_DISABLE_STEPLINES_OPTIONS: u32 = 2097152u32;
pub const DEBUG_ENGOPT_DISALLOW_IMAGE_FILE_MAPPING: u32 = 131072u32;
pub const DEBUG_ENGOPT_DISALLOW_NETWORK_PATHS: u32 = 8u32;
pub const DEBUG_ENGOPT_DISALLOW_SHELL_COMMANDS: u32 = 4096u32;
pub const DEBUG_ENGOPT_FAIL_INCOMPLETE_INFORMATION: u32 = 512u32;
pub const DEBUG_ENGOPT_FINAL_BREAK: u32 = 128u32;
pub const DEBUG_ENGOPT_IGNORE_DBGHELP_VERSION: u32 = 1u32;
pub const DEBUG_ENGOPT_IGNORE_EXTENSION_VERSIONS: u32 = 2u32;
pub const DEBUG_ENGOPT_IGNORE_LOADER_EXCEPTIONS: u32 = 16u32;
pub const DEBUG_ENGOPT_INITIAL_BREAK: u32 = 32u32;
pub const DEBUG_ENGOPT_INITIAL_MODULE_BREAK: u32 = 64u32;
pub const DEBUG_ENGOPT_KD_QUIET_MODE: u32 = 8192u32;
pub const DEBUG_ENGOPT_NO_EXECUTE_REPEAT: u32 = 256u32;
pub const DEBUG_ENGOPT_PREFER_DML: u32 = 262144u32;
pub const DEBUG_ENGOPT_PREFER_TRACE_FILES: u32 = 8388608u32;
pub const DEBUG_ENGOPT_SYNCHRONIZE_BREAKPOINTS: u32 = 2048u32;
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::clone::Clone for DEBUG_EVENT {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
pub struct DEBUG_EVENT {
    pub dwDebugEventCode: DEBUG_EVENT_CODE,
    pub dwProcessId: u32,
    pub dwThreadId: u32,
    pub u: DEBUG_EVENT_0,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl DEBUG_EVENT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::default::Default for DEBUG_EVENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::PartialEq for DEBUG_EVENT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::Eq for DEBUG_EVENT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
unsafe impl ::windows::core::Abi for DEBUG_EVENT {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::clone::Clone for DEBUG_EVENT_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
pub union DEBUG_EVENT_0 {
    pub Exception: EXCEPTION_DEBUG_INFO,
    pub CreateThread: ::core::mem::ManuallyDrop<CREATE_THREAD_DEBUG_INFO>,
    pub CreateProcessInfo: ::core::mem::ManuallyDrop<CREATE_PROCESS_DEBUG_INFO>,
    pub ExitThread: EXIT_THREAD_DEBUG_INFO,
    pub ExitProcess: EXIT_PROCESS_DEBUG_INFO,
    pub LoadDll: LOAD_DLL_DEBUG_INFO,
    pub UnloadDll: UNLOAD_DLL_DEBUG_INFO,
    pub DebugString: OUTPUT_DEBUG_STRING_INFO,
    pub RipInfo: RIP_INFO,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl DEBUG_EVENT_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::default::Default for DEBUG_EVENT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::PartialEq for DEBUG_EVENT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
impl ::core::cmp::Eq for DEBUG_EVENT_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
unsafe impl ::windows::core::Abi for DEBUG_EVENT_0 {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
pub const DEBUG_EVENT_BREAKPOINT: u32 = 1u32;
pub const DEBUG_EVENT_CHANGE_DEBUGGEE_STATE: u32 = 1024u32;
pub const DEBUG_EVENT_CHANGE_ENGINE_STATE: u32 = 2048u32;
pub const DEBUG_EVENT_CHANGE_SYMBOL_STATE: u32 = 4096u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEBUG_EVENT_CODE(pub u32);
pub const CREATE_PROCESS_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(3u32);
pub const CREATE_THREAD_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(2u32);
pub const EXCEPTION_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(1u32);
pub const EXIT_PROCESS_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(5u32);
pub const EXIT_THREAD_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(4u32);
pub const LOAD_DLL_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(6u32);
pub const OUTPUT_DEBUG_STRING_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(8u32);
pub const RIP_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(9u32);
pub const UNLOAD_DLL_DEBUG_EVENT: DEBUG_EVENT_CODE = DEBUG_EVENT_CODE(7u32);
impl ::core::convert::From<u32> for DEBUG_EVENT_CODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DEBUG_EVENT_CODE {
    type Abi = Self;
}
impl ::core::ops::BitOr for DEBUG_EVENT_CODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for DEBUG_EVENT_CODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for DEBUG_EVENT_CODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for DEBUG_EVENT_CODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for DEBUG_EVENT_CODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_EVENT_CONTEXT {
    pub Size: u32,
    pub ProcessEngineId: u32,
    pub ThreadEngineId: u32,
    pub FrameEngineId: u32,
}
impl DEBUG_EVENT_CONTEXT {}
impl ::core::default::Default for DEBUG_EVENT_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_EVENT_CONTEXT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_EVENT_CONTEXT").field("Size", &self.Size).field("ProcessEngineId", &self.ProcessEngineId).field("ThreadEngineId", &self.ThreadEngineId).field("FrameEngineId", &self.FrameEngineId).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_EVENT_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.ProcessEngineId == other.ProcessEngineId && self.ThreadEngineId == other.ThreadEngineId && self.FrameEngineId == other.FrameEngineId
    }
}
impl ::core::cmp::Eq for DEBUG_EVENT_CONTEXT {}
unsafe impl ::windows::core::Abi for DEBUG_EVENT_CONTEXT {
    type Abi = Self;
}
pub const DEBUG_EVENT_CREATE_PROCESS: u32 = 16u32;
pub const DEBUG_EVENT_CREATE_THREAD: u32 = 4u32;
pub const DEBUG_EVENT_EXCEPTION: u32 = 2u32;
pub const DEBUG_EVENT_EXIT_PROCESS: u32 = 32u32;
pub const DEBUG_EVENT_EXIT_THREAD: u32 = 8u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEBUG_EVENT_INFO_TYPE(pub i32);
pub const DEIT_GENERAL: DEBUG_EVENT_INFO_TYPE = DEBUG_EVENT_INFO_TYPE(0i32);
pub const DEIT_ASMJS_IN_DEBUGGING: DEBUG_EVENT_INFO_TYPE = DEBUG_EVENT_INFO_TYPE(1i32);
pub const DEIT_ASMJS_SUCCEEDED: DEBUG_EVENT_INFO_TYPE = DEBUG_EVENT_INFO_TYPE(2i32);
pub const DEIT_ASMJS_FAILED: DEBUG_EVENT_INFO_TYPE = DEBUG_EVENT_INFO_TYPE(3i32);
impl ::core::convert::From<i32> for DEBUG_EVENT_INFO_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DEBUG_EVENT_INFO_TYPE {
    type Abi = Self;
}
pub const DEBUG_EVENT_LOAD_MODULE: u32 = 64u32;
pub const DEBUG_EVENT_SERVICE_EXCEPTION: u32 = 8192u32;
pub const DEBUG_EVENT_SESSION_STATUS: u32 = 512u32;
pub const DEBUG_EVENT_SYSTEM_ERROR: u32 = 256u32;
pub const DEBUG_EVENT_UNLOAD_MODULE: u32 = 128u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_EXCEPTION_FILTER_PARAMETERS {
    pub ExecutionOption: u32,
    pub ContinueOption: u32,
    pub TextSize: u32,
    pub CommandSize: u32,
    pub SecondCommandSize: u32,
    pub ExceptionCode: u32,
}
impl DEBUG_EXCEPTION_FILTER_PARAMETERS {}
impl ::core::default::Default for DEBUG_EXCEPTION_FILTER_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_EXCEPTION_FILTER_PARAMETERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_EXCEPTION_FILTER_PARAMETERS")
            .field("ExecutionOption", &self.ExecutionOption)
            .field("ContinueOption", &self.ContinueOption)
            .field("TextSize", &self.TextSize)
            .field("CommandSize", &self.CommandSize)
            .field("SecondCommandSize", &self.SecondCommandSize)
            .field("ExceptionCode", &self.ExceptionCode)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_EXCEPTION_FILTER_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ExecutionOption == other.ExecutionOption && self.ContinueOption == other.ContinueOption && self.TextSize == other.TextSize && self.CommandSize == other.CommandSize && self.SecondCommandSize == other.SecondCommandSize && self.ExceptionCode == other.ExceptionCode
    }
}
impl ::core::cmp::Eq for DEBUG_EXCEPTION_FILTER_PARAMETERS {}
unsafe impl ::windows::core::Abi for DEBUG_EXCEPTION_FILTER_PARAMETERS {
    type Abi = Self;
}
pub const DEBUG_EXECUTE_DEFAULT: u32 = 0u32;
pub const DEBUG_EXECUTE_ECHO: u32 = 1u32;
pub const DEBUG_EXECUTE_EVENT: u32 = 2048u32;
pub const DEBUG_EXECUTE_EXTENSION: u32 = 32u32;
pub const DEBUG_EXECUTE_HOTKEY: u32 = 1024u32;
pub const DEBUG_EXECUTE_INTERNAL: u32 = 64u32;
pub const DEBUG_EXECUTE_MENU: u32 = 512u32;
pub const DEBUG_EXECUTE_NOT_LOGGED: u32 = 2u32;
pub const DEBUG_EXECUTE_NO_REPEAT: u32 = 4u32;
pub const DEBUG_EXECUTE_SCRIPT: u32 = 128u32;
pub const DEBUG_EXECUTE_TOOLBAR: u32 = 256u32;
pub const DEBUG_EXECUTE_USER_CLICKED: u32 = 16u32;
pub const DEBUG_EXECUTE_USER_TYPED: u32 = 8u32;
pub const DEBUG_EXEC_FLAGS_NONBLOCK: u32 = 1u32;
pub const DEBUG_EXPR_CPLUSPLUS: u32 = 1u32;
pub const DEBUG_EXPR_MASM: u32 = 0u32;
pub const DEBUG_EXTENSION_AT_ENGINE: u32 = 0u32;
pub const DEBUG_EXTINIT_HAS_COMMAND_HELP: u32 = 1u32;
pub const DEBUG_EXT_PVALUE_DEFAULT: u32 = 0u32;
pub const DEBUG_EXT_PVTYPE_IS_POINTER: u32 = 1u32;
pub const DEBUG_EXT_PVTYPE_IS_VALUE: u32 = 0u32;
pub const DEBUG_EXT_QVALUE_DEFAULT: u32 = 0u32;
pub const DEBUG_FILTER_BREAK: u32 = 0u32;
pub const DEBUG_FILTER_CREATE_PROCESS: u32 = 2u32;
pub const DEBUG_FILTER_CREATE_THREAD: u32 = 0u32;
pub const DEBUG_FILTER_DEBUGGEE_OUTPUT: u32 = 9u32;
pub const DEBUG_FILTER_EXIT_PROCESS: u32 = 3u32;
pub const DEBUG_FILTER_EXIT_THREAD: u32 = 1u32;
pub const DEBUG_FILTER_GO_HANDLED: u32 = 0u32;
pub const DEBUG_FILTER_GO_NOT_HANDLED: u32 = 1u32;
pub const DEBUG_FILTER_IGNORE: u32 = 3u32;
pub const DEBUG_FILTER_INITIAL_BREAKPOINT: u32 = 7u32;
pub const DEBUG_FILTER_INITIAL_MODULE_LOAD: u32 = 8u32;
pub const DEBUG_FILTER_LOAD_MODULE: u32 = 4u32;
pub const DEBUG_FILTER_OUTPUT: u32 = 2u32;
pub const DEBUG_FILTER_REMOVE: u32 = 4u32;
pub const DEBUG_FILTER_SECOND_CHANCE_BREAK: u32 = 1u32;
pub const DEBUG_FILTER_SYSTEM_ERROR: u32 = 6u32;
pub const DEBUG_FILTER_UNLOAD_MODULE: u32 = 5u32;
pub const DEBUG_FIND_SOURCE_BEST_MATCH: u32 = 2u32;
pub const DEBUG_FIND_SOURCE_DEFAULT: u32 = 0u32;
pub const DEBUG_FIND_SOURCE_FULL_PATH: u32 = 1u32;
pub const DEBUG_FIND_SOURCE_NO_SRCSRV: u32 = 4u32;
pub const DEBUG_FIND_SOURCE_TOKEN_LOOKUP: u32 = 8u32;
pub const DEBUG_FIND_SOURCE_WITH_CHECKSUM: u32 = 16u32;
pub const DEBUG_FIND_SOURCE_WITH_CHECKSUM_STRICT: u32 = 32u32;
pub const DEBUG_FORMAT_CAB_SECONDARY_ALL_IMAGES: u32 = 268435456u32;
pub const DEBUG_FORMAT_CAB_SECONDARY_FILES: u32 = 1073741824u32;
pub const DEBUG_FORMAT_DEFAULT: u32 = 0u32;
pub const DEBUG_FORMAT_NO_OVERWRITE: u32 = 2147483648u32;
pub const DEBUG_FORMAT_USER_SMALL_ADD_AVX_XSTATE_CONTEXT: u32 = 131072u32;
pub const DEBUG_FORMAT_USER_SMALL_CODE_SEGMENTS: u32 = 4096u32;
pub const DEBUG_FORMAT_USER_SMALL_DATA_SEGMENTS: u32 = 16u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_MEMORY: u32 = 32u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_PATHS: u32 = 64u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_TRIAGE: u32 = 65536u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_AUXILIARY_STATE: u32 = 16384u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_MEMORY: u32 = 1u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_MEMORY_INFO: u32 = 1024u32;
pub const DEBUG_FORMAT_USER_SMALL_HANDLE_DATA: u32 = 2u32;
pub const DEBUG_FORMAT_USER_SMALL_IGNORE_INACCESSIBLE_MEM: u32 = 134217728u32;
pub const DEBUG_FORMAT_USER_SMALL_INDIRECT_MEMORY: u32 = 8u32;
pub const DEBUG_FORMAT_USER_SMALL_IPT_TRACE: u32 = 262144u32;
pub const DEBUG_FORMAT_USER_SMALL_MODULE_HEADERS: u32 = 32768u32;
pub const DEBUG_FORMAT_USER_SMALL_NO_AUXILIARY_STATE: u32 = 8192u32;
pub const DEBUG_FORMAT_USER_SMALL_NO_OPTIONAL_DATA: u32 = 512u32;
pub const DEBUG_FORMAT_USER_SMALL_PRIVATE_READ_WRITE_MEMORY: u32 = 256u32;
pub const DEBUG_FORMAT_USER_SMALL_PROCESS_THREAD_DATA: u32 = 128u32;
pub const DEBUG_FORMAT_USER_SMALL_SCAN_PARTIAL_PAGES: u32 = 268435456u32;
pub const DEBUG_FORMAT_USER_SMALL_THREAD_INFO: u32 = 2048u32;
pub const DEBUG_FORMAT_USER_SMALL_UNLOADED_MODULES: u32 = 4u32;
pub const DEBUG_FORMAT_WRITE_CAB: u32 = 536870912u32;
pub const DEBUG_FRAME_DEFAULT: u32 = 0u32;
pub const DEBUG_FRAME_IGNORE_INLINE: u32 = 1u32;
pub const DEBUG_GETFNENT_DEFAULT: u32 = 0u32;
pub const DEBUG_GETFNENT_RAW_ENTRY_ONLY: u32 = 1u32;
pub const DEBUG_GETMOD_DEFAULT: u32 = 0u32;
pub const DEBUG_GETMOD_NO_LOADED_MODULES: u32 = 1u32;
pub const DEBUG_GETMOD_NO_UNLOADED_MODULES: u32 = 2u32;
pub const DEBUG_GET_PROC_DEFAULT: u32 = 0u32;
pub const DEBUG_GET_PROC_FULL_MATCH: u32 = 1u32;
pub const DEBUG_GET_PROC_ONLY_MATCH: u32 = 2u32;
pub const DEBUG_GET_PROC_SERVICE_NAME: u32 = 4u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_GET_TEXT_COMPLETIONS_IN {
    pub Flags: u32,
    pub MatchCountLimit: u32,
    pub Reserved: [u64; 3],
}
impl DEBUG_GET_TEXT_COMPLETIONS_IN {}
impl ::core::default::Default for DEBUG_GET_TEXT_COMPLETIONS_IN {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_GET_TEXT_COMPLETIONS_IN {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_GET_TEXT_COMPLETIONS_IN").field("Flags", &self.Flags).field("MatchCountLimit", &self.MatchCountLimit).field("Reserved", &self.Reserved).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_GET_TEXT_COMPLETIONS_IN {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags && self.MatchCountLimit == other.MatchCountLimit && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_GET_TEXT_COMPLETIONS_IN {}
unsafe impl ::windows::core::Abi for DEBUG_GET_TEXT_COMPLETIONS_IN {
    type Abi = Self;
}
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_DOT_COMMAND: u32 = 1u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_EXTENSION_COMMAND: u32 = 2u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_SYMBOL: u32 = 4u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_DOT_COMMANDS: u32 = 1u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_EXTENSION_COMMANDS: u32 = 2u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_SYMBOLS: u32 = 4u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_GET_TEXT_COMPLETIONS_OUT {
    pub Flags: u32,
    pub ReplaceIndex: u32,
    pub MatchCount: u32,
    pub Reserved1: u32,
    pub Reserved2: [u64; 2],
}
impl DEBUG_GET_TEXT_COMPLETIONS_OUT {}
impl ::core::default::Default for DEBUG_GET_TEXT_COMPLETIONS_OUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_GET_TEXT_COMPLETIONS_OUT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_GET_TEXT_COMPLETIONS_OUT").field("Flags", &self.Flags).field("ReplaceIndex", &self.ReplaceIndex).field("MatchCount", &self.MatchCount).field("Reserved1", &self.Reserved1).field("Reserved2", &self.Reserved2).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_GET_TEXT_COMPLETIONS_OUT {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags && self.ReplaceIndex == other.ReplaceIndex && self.MatchCount == other.MatchCount && self.Reserved1 == other.Reserved1 && self.Reserved2 == other.Reserved2
    }
}
impl ::core::cmp::Eq for DEBUG_GET_TEXT_COMPLETIONS_OUT {}
unsafe impl ::windows::core::Abi for DEBUG_GET_TEXT_COMPLETIONS_OUT {
    type Abi = Self;
}
pub const DEBUG_GSEL_ALLOW_HIGHER: u32 = 4u32;
pub const DEBUG_GSEL_ALLOW_LOWER: u32 = 2u32;
pub const DEBUG_GSEL_DEFAULT: u32 = 0u32;
pub const DEBUG_GSEL_INLINE_CALLSITE: u32 = 16u32;
pub const DEBUG_GSEL_NEAREST_ONLY: u32 = 8u32;
pub const DEBUG_GSEL_NO_SYMBOL_LOADS: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_HANDLE_DATA_BASIC {
    pub TypeNameSize: u32,
    pub ObjectNameSize: u32,
    pub Attributes: u32,
    pub GrantedAccess: u32,
    pub HandleCount: u32,
    pub PointerCount: u32,
}
impl DEBUG_HANDLE_DATA_BASIC {}
impl ::core::default::Default for DEBUG_HANDLE_DATA_BASIC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_HANDLE_DATA_BASIC {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_HANDLE_DATA_BASIC")
            .field("TypeNameSize", &self.TypeNameSize)
            .field("ObjectNameSize", &self.ObjectNameSize)
            .field("Attributes", &self.Attributes)
            .field("GrantedAccess", &self.GrantedAccess)
            .field("HandleCount", &self.HandleCount)
            .field("PointerCount", &self.PointerCount)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_HANDLE_DATA_BASIC {
    fn eq(&self, other: &Self) -> bool {
        self.TypeNameSize == other.TypeNameSize && self.ObjectNameSize == other.ObjectNameSize && self.Attributes == other.Attributes && self.GrantedAccess == other.GrantedAccess && self.HandleCount == other.HandleCount && self.PointerCount == other.PointerCount
    }
}
impl ::core::cmp::Eq for DEBUG_HANDLE_DATA_BASIC {}
unsafe impl ::windows::core::Abi for DEBUG_HANDLE_DATA_BASIC {
    type Abi = Self;
}
pub const DEBUG_HANDLE_DATA_TYPE_ALL_HANDLE_OPERATIONS: u32 = 10u32;
pub const DEBUG_HANDLE_DATA_TYPE_BASIC: u32 = 0u32;
pub const DEBUG_HANDLE_DATA_TYPE_HANDLE_COUNT: u32 = 3u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_EVENT_1: u32 = 13u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_1: u32 = 7u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_2: u32 = 8u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_PROCESS_1: u32 = 11u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_PROCESS_2: u32 = 12u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_SECTION_1: u32 = 14u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_SEMAPHORE_1: u32 = 15u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_THREAD_1: u32 = 6u32;
pub const DEBUG_HANDLE_DATA_TYPE_OBJECT_NAME: u32 = 2u32;
pub const DEBUG_HANDLE_DATA_TYPE_OBJECT_NAME_WIDE: u32 = 5u32;
pub const DEBUG_HANDLE_DATA_TYPE_PER_HANDLE_OPERATIONS: u32 = 9u32;
pub const DEBUG_HANDLE_DATA_TYPE_TYPE_NAME: u32 = 1u32;
pub const DEBUG_HANDLE_DATA_TYPE_TYPE_NAME_WIDE: u32 = 4u32;
pub const DEBUG_INTERRUPT_ACTIVE: u32 = 0u32;
pub const DEBUG_INTERRUPT_EXIT: u32 = 2u32;
pub const DEBUG_INTERRUPT_PASSIVE: u32 = 1u32;
pub const DEBUG_IOUTPUT_ADDR_TRANSLATE: u32 = 134217728u32;
pub const DEBUG_IOUTPUT_BREAKPOINT: u32 = 536870912u32;
pub const DEBUG_IOUTPUT_EVENT: u32 = 268435456u32;
pub const DEBUG_IOUTPUT_KD_PROTOCOL: u32 = 2147483648u32;
pub const DEBUG_IOUTPUT_REMOTING: u32 = 1073741824u32;
pub const DEBUG_KERNEL_ACTIVE_DUMP: u32 = 1030u32;
pub const DEBUG_KERNEL_CONNECTION: u32 = 0u32;
pub const DEBUG_KERNEL_DUMP: u32 = 1025u32;
pub const DEBUG_KERNEL_EXDI_DRIVER: u32 = 2u32;
pub const DEBUG_KERNEL_FULL_DUMP: u32 = 1026u32;
pub const DEBUG_KERNEL_IDNA: u32 = 3u32;
pub const DEBUG_KERNEL_INSTALL_DRIVER: u32 = 4u32;
pub const DEBUG_KERNEL_LOCAL: u32 = 1u32;
pub const DEBUG_KERNEL_REPT: u32 = 5u32;
pub const DEBUG_KERNEL_SMALL_DUMP: u32 = 1024u32;
pub const DEBUG_KERNEL_TRACE_LOG: u32 = 1028u32;
pub const DEBUG_KNOWN_STRUCT_GET_NAMES: u32 = 1u32;
pub const DEBUG_KNOWN_STRUCT_GET_SINGLE_LINE_OUTPUT: u32 = 2u32;
pub const DEBUG_KNOWN_STRUCT_SUPPRESS_TYPE_NAME: u32 = 3u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    pub Id: u32,
}
impl DEBUG_LAST_EVENT_INFO_BREAKPOINT {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_BREAKPOINT").field("Id", &self.Id).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    fn eq(&self, other: &Self) -> bool {
        self.Id == other.Id
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_BREAKPOINT {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_LAST_EVENT_INFO_EXCEPTION {
    pub ExceptionRecord: EXCEPTION_RECORD64,
    pub FirstChance: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_LAST_EVENT_INFO_EXCEPTION {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_EXCEPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_EXCEPTION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_EXCEPTION").field("ExceptionRecord", &self.ExceptionRecord).field("FirstChance", &self.FirstChance).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_EXCEPTION {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionRecord == other.ExceptionRecord && self.FirstChance == other.FirstChance
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_EXCEPTION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_EXCEPTION {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    pub ExitCode: u32,
}
impl DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_EXIT_PROCESS").field("ExitCode", &self.ExitCode).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    fn eq(&self, other: &Self) -> bool {
        self.ExitCode == other.ExitCode
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    pub ExitCode: u32,
}
impl DEBUG_LAST_EVENT_INFO_EXIT_THREAD {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_EXIT_THREAD").field("ExitCode", &self.ExitCode).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    fn eq(&self, other: &Self) -> bool {
        self.ExitCode == other.ExitCode
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_EXIT_THREAD {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    pub Base: u64,
}
impl DEBUG_LAST_EVENT_INFO_LOAD_MODULE {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_LOAD_MODULE").field("Base", &self.Base).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    fn eq(&self, other: &Self) -> bool {
        self.Base == other.Base
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_LOAD_MODULE {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    pub Kind: u32,
    pub DataSize: u32,
    pub Address: u64,
}
impl DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION").field("Kind", &self.Kind).field("DataSize", &self.DataSize).field("Address", &self.Address).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    fn eq(&self, other: &Self) -> bool {
        self.Kind == other.Kind && self.DataSize == other.DataSize && self.Address == other.Address
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    pub Error: u32,
    pub Level: u32,
}
impl DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR").field("Error", &self.Error).field("Level", &self.Level).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    fn eq(&self, other: &Self) -> bool {
        self.Error == other.Error && self.Level == other.Level
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    pub Base: u64,
}
impl DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {}
impl ::core::default::Default for DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE").field("Base", &self.Base).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    fn eq(&self, other: &Self) -> bool {
        self.Base == other.Base
    }
}
impl ::core::cmp::Eq for DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {}
unsafe impl ::windows::core::Abi for DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    type Abi = Self;
}
pub const DEBUG_LEVEL_ASSEMBLY: u32 = 1u32;
pub const DEBUG_LEVEL_SOURCE: u32 = 0u32;
pub const DEBUG_LIVE_USER_NON_INVASIVE: u32 = 33u32;
pub const DEBUG_LOG_APPEND: u32 = 1u32;
pub const DEBUG_LOG_DEFAULT: u32 = 0u32;
pub const DEBUG_LOG_DML: u32 = 4u32;
pub const DEBUG_LOG_UNICODE: u32 = 2u32;
pub const DEBUG_MANAGED_ALLOWED: u32 = 1u32;
pub const DEBUG_MANAGED_DISABLED: u32 = 0u32;
pub const DEBUG_MANAGED_DLL_LOADED: u32 = 2u32;
pub const DEBUG_MANRESET_DEFAULT: u32 = 0u32;
pub const DEBUG_MANRESET_LOAD_DLL: u32 = 1u32;
pub const DEBUG_MANSTR_LOADED_SUPPORT_DLL: u32 = 1u32;
pub const DEBUG_MANSTR_LOAD_STATUS: u32 = 2u32;
pub const DEBUG_MANSTR_NONE: u32 = 0u32;
pub const DEBUG_MODNAME_IMAGE: u32 = 0u32;
pub const DEBUG_MODNAME_LOADED_IMAGE: u32 = 2u32;
pub const DEBUG_MODNAME_MAPPED_IMAGE: u32 = 4u32;
pub const DEBUG_MODNAME_MODULE: u32 = 1u32;
pub const DEBUG_MODNAME_SYMBOL_FILE: u32 = 3u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_MODULE_AND_ID {
    pub ModuleBase: u64,
    pub Id: u64,
}
impl DEBUG_MODULE_AND_ID {}
impl ::core::default::Default for DEBUG_MODULE_AND_ID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_MODULE_AND_ID {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_MODULE_AND_ID").field("ModuleBase", &self.ModuleBase).field("Id", &self.Id).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_MODULE_AND_ID {
    fn eq(&self, other: &Self) -> bool {
        self.ModuleBase == other.ModuleBase && self.Id == other.Id
    }
}
impl ::core::cmp::Eq for DEBUG_MODULE_AND_ID {}
unsafe impl ::windows::core::Abi for DEBUG_MODULE_AND_ID {
    type Abi = Self;
}
pub const DEBUG_MODULE_EXE_MODULE: u32 = 4u32;
pub const DEBUG_MODULE_EXPLICIT: u32 = 8u32;
pub const DEBUG_MODULE_LOADED: u32 = 0u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_MODULE_PARAMETERS {
    pub Base: u64,
    pub Size: u32,
    pub TimeDateStamp: u32,
    pub Checksum: u32,
    pub Flags: u32,
    pub SymbolType: u32,
    pub ImageNameSize: u32,
    pub ModuleNameSize: u32,
    pub LoadedImageNameSize: u32,
    pub SymbolFileNameSize: u32,
    pub MappedImageNameSize: u32,
    pub Reserved: [u64; 2],
}
impl DEBUG_MODULE_PARAMETERS {}
impl ::core::default::Default for DEBUG_MODULE_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_MODULE_PARAMETERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_MODULE_PARAMETERS")
            .field("Base", &self.Base)
            .field("Size", &self.Size)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("Checksum", &self.Checksum)
            .field("Flags", &self.Flags)
            .field("SymbolType", &self.SymbolType)
            .field("ImageNameSize", &self.ImageNameSize)
            .field("ModuleNameSize", &self.ModuleNameSize)
            .field("LoadedImageNameSize", &self.LoadedImageNameSize)
            .field("SymbolFileNameSize", &self.SymbolFileNameSize)
            .field("MappedImageNameSize", &self.MappedImageNameSize)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_MODULE_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.Base == other.Base
            && self.Size == other.Size
            && self.TimeDateStamp == other.TimeDateStamp
            && self.Checksum == other.Checksum
            && self.Flags == other.Flags
            && self.SymbolType == other.SymbolType
            && self.ImageNameSize == other.ImageNameSize
            && self.ModuleNameSize == other.ModuleNameSize
            && self.LoadedImageNameSize == other.LoadedImageNameSize
            && self.SymbolFileNameSize == other.SymbolFileNameSize
            && self.MappedImageNameSize == other.MappedImageNameSize
            && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_MODULE_PARAMETERS {}
unsafe impl ::windows::core::Abi for DEBUG_MODULE_PARAMETERS {
    type Abi = Self;
}
pub const DEBUG_MODULE_SECONDARY: u32 = 16u32;
pub const DEBUG_MODULE_SYM_BAD_CHECKSUM: u32 = 65536u32;
pub const DEBUG_MODULE_SYNTHETIC: u32 = 32u32;
pub const DEBUG_MODULE_UNLOADED: u32 = 1u32;
pub const DEBUG_MODULE_USER_MODE: u32 = 2u32;
pub const DEBUG_NOTIFY_SESSION_ACCESSIBLE: u32 = 2u32;
pub const DEBUG_NOTIFY_SESSION_ACTIVE: u32 = 0u32;
pub const DEBUG_NOTIFY_SESSION_INACCESSIBLE: u32 = 3u32;
pub const DEBUG_NOTIFY_SESSION_INACTIVE: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_OFFSET_REGION {
    pub Base: u64,
    pub Size: u64,
}
impl DEBUG_OFFSET_REGION {}
impl ::core::default::Default for DEBUG_OFFSET_REGION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_OFFSET_REGION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_OFFSET_REGION").field("Base", &self.Base).field("Size", &self.Size).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_OFFSET_REGION {
    fn eq(&self, other: &Self) -> bool {
        self.Base == other.Base && self.Size == other.Size
    }
}
impl ::core::cmp::Eq for DEBUG_OFFSET_REGION {}
unsafe impl ::windows::core::Abi for DEBUG_OFFSET_REGION {
    type Abi = Self;
}
pub const DEBUG_OFFSINFO_VIRTUAL_SOURCE: u32 = 1u32;
pub const DEBUG_OUTCBF_COMBINED_EXPLICIT_FLUSH: u32 = 1u32;
pub const DEBUG_OUTCBF_DML_HAS_SPECIAL_CHARACTERS: u32 = 4u32;
pub const DEBUG_OUTCBF_DML_HAS_TAGS: u32 = 2u32;
pub const DEBUG_OUTCBI_ANY_FORMAT: u32 = 6u32;
pub const DEBUG_OUTCBI_DML: u32 = 4u32;
pub const DEBUG_OUTCBI_EXPLICIT_FLUSH: u32 = 1u32;
pub const DEBUG_OUTCBI_TEXT: u32 = 2u32;
pub const DEBUG_OUTCB_DML: u32 = 1u32;
pub const DEBUG_OUTCB_EXPLICIT_FLUSH: u32 = 2u32;
pub const DEBUG_OUTCB_TEXT: u32 = 0u32;
pub const DEBUG_OUTCTL_ALL_CLIENTS: u32 = 1u32;
pub const DEBUG_OUTCTL_ALL_OTHER_CLIENTS: u32 = 2u32;
pub const DEBUG_OUTCTL_AMBIENT: u32 = 4294967295u32;
pub const DEBUG_OUTCTL_AMBIENT_DML: u32 = 4294967294u32;
pub const DEBUG_OUTCTL_AMBIENT_TEXT: u32 = 4294967295u32;
pub const DEBUG_OUTCTL_DML: u32 = 32u32;
pub const DEBUG_OUTCTL_IGNORE: u32 = 3u32;
pub const DEBUG_OUTCTL_LOG_ONLY: u32 = 4u32;
pub const DEBUG_OUTCTL_NOT_LOGGED: u32 = 8u32;
pub const DEBUG_OUTCTL_OVERRIDE_MASK: u32 = 16u32;
pub const DEBUG_OUTCTL_SEND_MASK: u32 = 7u32;
pub const DEBUG_OUTCTL_THIS_CLIENT: u32 = 0u32;
pub const DEBUG_OUTPUT_DEBUGGEE: u32 = 128u32;
pub const DEBUG_OUTPUT_DEBUGGEE_PROMPT: u32 = 256u32;
pub const DEBUG_OUTPUT_ERROR: u32 = 2u32;
pub const DEBUG_OUTPUT_EXTENSION_WARNING: u32 = 64u32;
pub const DEBUG_OUTPUT_IDENTITY_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTPUT_NORMAL: u32 = 1u32;
pub const DEBUG_OUTPUT_PROMPT: u32 = 16u32;
pub const DEBUG_OUTPUT_PROMPT_REGISTERS: u32 = 32u32;
pub const DEBUG_OUTPUT_STATUS: u32 = 1024u32;
pub const DEBUG_OUTPUT_SYMBOLS: u32 = 512u32;
pub const DEBUG_OUTPUT_SYMBOLS_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_NAMES: u32 = 1u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_OFFSETS: u32 = 2u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_TYPES: u32 = 16u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_VALUES: u32 = 4u32;
pub const DEBUG_OUTPUT_VERBOSE: u32 = 8u32;
pub const DEBUG_OUTPUT_WARNING: u32 = 4u32;
pub const DEBUG_OUTPUT_XML: u32 = 2048u32;
pub const DEBUG_OUTSYM_ALLOW_DISPLACEMENT: u32 = 4u32;
pub const DEBUG_OUTSYM_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTSYM_FORCE_OFFSET: u32 = 1u32;
pub const DEBUG_OUTSYM_SOURCE_LINE: u32 = 2u32;
pub const DEBUG_OUTTYPE_ADDRESS_AT_END: u32 = 131072u32;
pub const DEBUG_OUTTYPE_ADDRESS_OF_FIELD: u32 = 65536u32;
pub const DEBUG_OUTTYPE_BLOCK_RECURSE: u32 = 2097152u32;
pub const DEBUG_OUTTYPE_COMPACT_OUTPUT: u32 = 8u32;
pub const DEBUG_OUTTYPE_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTTYPE_NO_INDENT: u32 = 1u32;
pub const DEBUG_OUTTYPE_NO_OFFSET: u32 = 2u32;
pub const DEBUG_OUTTYPE_VERBOSE: u32 = 4u32;
pub const DEBUG_OUT_TEXT_REPL_DEFAULT: u32 = 0u32;
pub const DEBUG_PHYSICAL_CACHED: u32 = 1u32;
pub const DEBUG_PHYSICAL_DEFAULT: u32 = 0u32;
pub const DEBUG_PHYSICAL_UNCACHED: u32 = 2u32;
pub const DEBUG_PHYSICAL_WRITE_COMBINED: u32 = 3u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    pub Alpha: DEBUG_PROCESSOR_IDENTIFICATION_ALPHA,
    pub Amd64: DEBUG_PROCESSOR_IDENTIFICATION_AMD64,
    pub Ia64: DEBUG_PROCESSOR_IDENTIFICATION_IA64,
    pub X86: DEBUG_PROCESSOR_IDENTIFICATION_X86,
    pub Arm: DEBUG_PROCESSOR_IDENTIFICATION_ARM,
    pub Arm64: DEBUG_PROCESSOR_IDENTIFICATION_ARM64,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_ALL {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_ALL {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    pub Type: u32,
    pub Revision: u32,
}
impl DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {}
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_ALPHA").field("Type", &self.Type).field("Revision", &self.Revision).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.Revision == other.Revision
    }
}
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {}
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    pub Family: u32,
    pub Model: u32,
    pub Stepping: u32,
    pub VendorString: [super::super::super::Foundation::CHAR; 16],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_AMD64").field("Family", &self.Family).field("Model", &self.Model).field("Stepping", &self.Stepping).field("VendorString", &self.VendorString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    fn eq(&self, other: &Self) -> bool {
        self.Family == other.Family && self.Model == other.Model && self.Stepping == other.Stepping && self.VendorString == other.VendorString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    pub Model: u32,
    pub Revision: u32,
    pub VendorString: [super::super::super::Foundation::CHAR; 16],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_ARM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_ARM").field("Model", &self.Model).field("Revision", &self.Revision).field("VendorString", &self.VendorString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    fn eq(&self, other: &Self) -> bool {
        self.Model == other.Model && self.Revision == other.Revision && self.VendorString == other.VendorString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_ARM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    pub Model: u32,
    pub Revision: u32,
    pub VendorString: [super::super::super::Foundation::CHAR; 16],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_ARM64").field("Model", &self.Model).field("Revision", &self.Revision).field("VendorString", &self.VendorString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    fn eq(&self, other: &Self) -> bool {
        self.Model == other.Model && self.Revision == other.Revision && self.VendorString == other.VendorString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    pub Model: u32,
    pub Revision: u32,
    pub Family: u32,
    pub ArchRev: u32,
    pub VendorString: [super::super::super::Foundation::CHAR; 16],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_IA64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_IA64").field("Model", &self.Model).field("Revision", &self.Revision).field("Family", &self.Family).field("ArchRev", &self.ArchRev).field("VendorString", &self.VendorString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    fn eq(&self, other: &Self) -> bool {
        self.Model == other.Model && self.Revision == other.Revision && self.Family == other.Family && self.ArchRev == other.ArchRev && self.VendorString == other.VendorString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    pub Family: u32,
    pub Model: u32,
    pub Stepping: u32,
    pub VendorString: [super::super::super::Foundation::CHAR; 16],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_PROCESSOR_IDENTIFICATION_X86 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_PROCESSOR_IDENTIFICATION_X86").field("Family", &self.Family).field("Model", &self.Model).field("Stepping", &self.Stepping).field("VendorString", &self.VendorString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    fn eq(&self, other: &Self) -> bool {
        self.Family == other.Family && self.Model == other.Model && self.Stepping == other.Stepping && self.VendorString == other.VendorString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_PROCESSOR_IDENTIFICATION_X86 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    type Abi = Self;
}
pub const DEBUG_PROCESS_DETACH_ON_EXIT: u32 = 1u32;
pub const DEBUG_PROCESS_ONLY_THIS_PROCESS: u32 = 2u32;
pub const DEBUG_PROC_DESC_DEFAULT: u32 = 0u32;
pub const DEBUG_PROC_DESC_NO_COMMAND_LINE: u32 = 8u32;
pub const DEBUG_PROC_DESC_NO_MTS_PACKAGES: u32 = 4u32;
pub const DEBUG_PROC_DESC_NO_PATHS: u32 = 1u32;
pub const DEBUG_PROC_DESC_NO_SERVICES: u32 = 2u32;
pub const DEBUG_PROC_DESC_NO_SESSION_ID: u32 = 16u32;
pub const DEBUG_PROC_DESC_NO_USER_NAME: u32 = 32u32;
pub const DEBUG_PROC_DESC_WITH_PACKAGEFAMILY: u32 = 64u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_READ_USER_MINIDUMP_STREAM {
    pub StreamType: u32,
    pub Flags: u32,
    pub Offset: u64,
    pub Buffer: *mut ::core::ffi::c_void,
    pub BufferSize: u32,
    pub BufferUsed: u32,
}
impl DEBUG_READ_USER_MINIDUMP_STREAM {}
impl ::core::default::Default for DEBUG_READ_USER_MINIDUMP_STREAM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_READ_USER_MINIDUMP_STREAM {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_READ_USER_MINIDUMP_STREAM").field("StreamType", &self.StreamType).field("Flags", &self.Flags).field("Offset", &self.Offset).field("Buffer", &self.Buffer).field("BufferSize", &self.BufferSize).field("BufferUsed", &self.BufferUsed).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_READ_USER_MINIDUMP_STREAM {
    fn eq(&self, other: &Self) -> bool {
        self.StreamType == other.StreamType && self.Flags == other.Flags && self.Offset == other.Offset && self.Buffer == other.Buffer && self.BufferSize == other.BufferSize && self.BufferUsed == other.BufferUsed
    }
}
impl ::core::cmp::Eq for DEBUG_READ_USER_MINIDUMP_STREAM {}
unsafe impl ::windows::core::Abi for DEBUG_READ_USER_MINIDUMP_STREAM {
    type Abi = Self;
}
pub const DEBUG_REGISTERS_ALL: u32 = 7u32;
pub const DEBUG_REGISTERS_DEFAULT: u32 = 0u32;
pub const DEBUG_REGISTERS_FLOAT: u32 = 4u32;
pub const DEBUG_REGISTERS_INT32: u32 = 1u32;
pub const DEBUG_REGISTERS_INT64: u32 = 2u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_REGISTER_DESCRIPTION {
    pub Type: u32,
    pub Flags: u32,
    pub SubregMaster: u32,
    pub SubregLength: u32,
    pub SubregMask: u64,
    pub SubregShift: u32,
    pub Reserved0: u32,
}
impl DEBUG_REGISTER_DESCRIPTION {}
impl ::core::default::Default for DEBUG_REGISTER_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_REGISTER_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_REGISTER_DESCRIPTION")
            .field("Type", &self.Type)
            .field("Flags", &self.Flags)
            .field("SubregMaster", &self.SubregMaster)
            .field("SubregLength", &self.SubregLength)
            .field("SubregMask", &self.SubregMask)
            .field("SubregShift", &self.SubregShift)
            .field("Reserved0", &self.Reserved0)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_REGISTER_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.Flags == other.Flags && self.SubregMaster == other.SubregMaster && self.SubregLength == other.SubregLength && self.SubregMask == other.SubregMask && self.SubregShift == other.SubregShift && self.Reserved0 == other.Reserved0
    }
}
impl ::core::cmp::Eq for DEBUG_REGISTER_DESCRIPTION {}
unsafe impl ::windows::core::Abi for DEBUG_REGISTER_DESCRIPTION {
    type Abi = Self;
}
pub const DEBUG_REGISTER_SUB_REGISTER: u32 = 1u32;
pub const DEBUG_REGSRC_DEBUGGEE: u32 = 0u32;
pub const DEBUG_REGSRC_EXPLICIT: u32 = 1u32;
pub const DEBUG_REGSRC_FRAME: u32 = 2u32;
pub const DEBUG_REQUEST_ADD_CACHED_SYMBOL_INFO: u32 = 16u32;
pub const DEBUG_REQUEST_CLOSE_TOKEN: u32 = 30u32;
pub const DEBUG_REQUEST_CURRENT_OUTPUT_CALLBACKS_ARE_DML_AWARE: u32 = 19u32;
pub const DEBUG_REQUEST_DUPLICATE_TOKEN: u32 = 28u32;
pub const DEBUG_REQUEST_EXT_TYPED_DATA_ANSI: u32 = 12u32;
pub const DEBUG_REQUEST_GET_ADDITIONAL_CREATE_OPTIONS: u32 = 4u32;
pub const DEBUG_REQUEST_GET_CACHED_SYMBOL_INFO: u32 = 15u32;
pub const DEBUG_REQUEST_GET_CAPTURED_EVENT_CODE_OFFSET: u32 = 10u32;
pub const DEBUG_REQUEST_GET_DUMP_HEADER: u32 = 21u32;
pub const DEBUG_REQUEST_GET_EXTENSION_SEARCH_PATH_WIDE: u32 = 13u32;
pub const DEBUG_REQUEST_GET_INSTRUMENTATION_VERSION: u32 = 37u32;
pub const DEBUG_REQUEST_GET_MODULE_ARCHITECTURE: u32 = 38u32;
pub const DEBUG_REQUEST_GET_OFFSET_UNWIND_INFORMATION: u32 = 20u32;
pub const DEBUG_REQUEST_GET_TEXT_COMPLETIONS_ANSI: u32 = 18u32;
pub const DEBUG_REQUEST_GET_TEXT_COMPLETIONS_WIDE: u32 = 14u32;
pub const DEBUG_REQUEST_GET_WIN32_MAJOR_MINOR_VERSIONS: u32 = 6u32;
pub const DEBUG_REQUEST_INLINE_QUERY: u32 = 35u32;
pub const DEBUG_REQUEST_MIDORI: u32 = 23u32;
pub const DEBUG_REQUEST_MISC_INFORMATION: u32 = 25u32;
pub const DEBUG_REQUEST_OPEN_PROCESS_TOKEN: u32 = 26u32;
pub const DEBUG_REQUEST_OPEN_THREAD_TOKEN: u32 = 27u32;
pub const DEBUG_REQUEST_PROCESS_DESCRIPTORS: u32 = 24u32;
pub const DEBUG_REQUEST_QUERY_INFO_TOKEN: u32 = 29u32;
pub const DEBUG_REQUEST_READ_CAPTURED_EVENT_CODE_STREAM: u32 = 11u32;
pub const DEBUG_REQUEST_READ_USER_MINIDUMP_STREAM: u32 = 7u32;
pub const DEBUG_REQUEST_REMOVE_CACHED_SYMBOL_INFO: u32 = 17u32;
pub const DEBUG_REQUEST_RESUME_THREAD: u32 = 34u32;
pub const DEBUG_REQUEST_SET_ADDITIONAL_CREATE_OPTIONS: u32 = 5u32;
pub const DEBUG_REQUEST_SET_DUMP_HEADER: u32 = 22u32;
pub const DEBUG_REQUEST_SET_LOCAL_IMPLICIT_COMMAND_LINE: u32 = 9u32;
pub const DEBUG_REQUEST_SOURCE_PATH_HAS_SOURCE_SERVER: u32 = 0u32;
pub const DEBUG_REQUEST_TARGET_CAN_DETACH: u32 = 8u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_CONTEXT: u32 = 1u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_RECORD: u32 = 3u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_THREAD: u32 = 2u32;
pub const DEBUG_REQUEST_TL_INSTRUMENTATION_AWARE: u32 = 36u32;
pub const DEBUG_REQUEST_WOW_MODULE: u32 = 32u32;
pub const DEBUG_REQUEST_WOW_PROCESS: u32 = 31u32;
pub const DEBUG_SCOPE_GROUP_ALL: u32 = 3u32;
pub const DEBUG_SCOPE_GROUP_ARGUMENTS: u32 = 1u32;
pub const DEBUG_SCOPE_GROUP_BY_DATAMODEL: u32 = 4u32;
pub const DEBUG_SCOPE_GROUP_LOCALS: u32 = 2u32;
pub const DEBUG_SERVERS_ALL: u32 = 3u32;
pub const DEBUG_SERVERS_DEBUGGER: u32 = 1u32;
pub const DEBUG_SERVERS_PROCESS: u32 = 2u32;
pub const DEBUG_SESSION_ACTIVE: u32 = 0u32;
pub const DEBUG_SESSION_END: u32 = 4u32;
pub const DEBUG_SESSION_END_SESSION_ACTIVE_DETACH: u32 = 2u32;
pub const DEBUG_SESSION_END_SESSION_ACTIVE_TERMINATE: u32 = 1u32;
pub const DEBUG_SESSION_END_SESSION_PASSIVE: u32 = 3u32;
pub const DEBUG_SESSION_FAILURE: u32 = 7u32;
pub const DEBUG_SESSION_HIBERNATE: u32 = 6u32;
pub const DEBUG_SESSION_REBOOT: u32 = 5u32;
pub const DEBUG_SOURCE_IS_STATEMENT: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_SPECIFIC_FILTER_PARAMETERS {
    pub ExecutionOption: u32,
    pub ContinueOption: u32,
    pub TextSize: u32,
    pub CommandSize: u32,
    pub ArgumentSize: u32,
}
impl DEBUG_SPECIFIC_FILTER_PARAMETERS {}
impl ::core::default::Default for DEBUG_SPECIFIC_FILTER_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_SPECIFIC_FILTER_PARAMETERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_SPECIFIC_FILTER_PARAMETERS").field("ExecutionOption", &self.ExecutionOption).field("ContinueOption", &self.ContinueOption).field("TextSize", &self.TextSize).field("CommandSize", &self.CommandSize).field("ArgumentSize", &self.ArgumentSize).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_SPECIFIC_FILTER_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ExecutionOption == other.ExecutionOption && self.ContinueOption == other.ContinueOption && self.TextSize == other.TextSize && self.CommandSize == other.CommandSize && self.ArgumentSize == other.ArgumentSize
    }
}
impl ::core::cmp::Eq for DEBUG_SPECIFIC_FILTER_PARAMETERS {}
unsafe impl ::windows::core::Abi for DEBUG_SPECIFIC_FILTER_PARAMETERS {
    type Abi = Self;
}
pub const DEBUG_SRCFILE_SYMBOL_CHECKSUMINFO: u32 = 2u32;
pub const DEBUG_SRCFILE_SYMBOL_TOKEN: u32 = 0u32;
pub const DEBUG_SRCFILE_SYMBOL_TOKEN_SOURCE_COMMAND_WIDE: u32 = 1u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEBUG_STACKFRAME_TYPE(pub i32);
pub const DST_SCRIPT_FRAME: DEBUG_STACKFRAME_TYPE = DEBUG_STACKFRAME_TYPE(0i32);
pub const DST_INTERNAL_FRAME: DEBUG_STACKFRAME_TYPE = DEBUG_STACKFRAME_TYPE(1i32);
pub const DST_INVOCATION_FRAME: DEBUG_STACKFRAME_TYPE = DEBUG_STACKFRAME_TYPE(2i32);
impl ::core::convert::From<i32> for DEBUG_STACKFRAME_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DEBUG_STACKFRAME_TYPE {
    type Abi = Self;
}
pub const DEBUG_STACK_ARGUMENTS: u32 = 1u32;
pub const DEBUG_STACK_COLUMN_NAMES: u32 = 16u32;
pub const DEBUG_STACK_DML: u32 = 2048u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_STACK_FRAME {
    pub InstructionOffset: u64,
    pub ReturnOffset: u64,
    pub FrameOffset: u64,
    pub StackOffset: u64,
    pub FuncTableEntry: u64,
    pub Params: [u64; 4],
    pub Reserved: [u64; 6],
    pub Virtual: super::super::super::Foundation::BOOL,
    pub FrameNumber: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_STACK_FRAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_STACK_FRAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_STACK_FRAME {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_STACK_FRAME")
            .field("InstructionOffset", &self.InstructionOffset)
            .field("ReturnOffset", &self.ReturnOffset)
            .field("FrameOffset", &self.FrameOffset)
            .field("StackOffset", &self.StackOffset)
            .field("FuncTableEntry", &self.FuncTableEntry)
            .field("Params", &self.Params)
            .field("Reserved", &self.Reserved)
            .field("Virtual", &self.Virtual)
            .field("FrameNumber", &self.FrameNumber)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_STACK_FRAME {
    fn eq(&self, other: &Self) -> bool {
        self.InstructionOffset == other.InstructionOffset && self.ReturnOffset == other.ReturnOffset && self.FrameOffset == other.FrameOffset && self.StackOffset == other.StackOffset && self.FuncTableEntry == other.FuncTableEntry && self.Params == other.Params && self.Reserved == other.Reserved && self.Virtual == other.Virtual && self.FrameNumber == other.FrameNumber
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_STACK_FRAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_STACK_FRAME {
    type Abi = Self;
}
pub const DEBUG_STACK_FRAME_ADDRESSES: u32 = 8u32;
pub const DEBUG_STACK_FRAME_ADDRESSES_RA_ONLY: u32 = 256u32;
pub const DEBUG_STACK_FRAME_ARCH: u32 = 16384u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_STACK_FRAME_EX {
    pub InstructionOffset: u64,
    pub ReturnOffset: u64,
    pub FrameOffset: u64,
    pub StackOffset: u64,
    pub FuncTableEntry: u64,
    pub Params: [u64; 4],
    pub Reserved: [u64; 6],
    pub Virtual: super::super::super::Foundation::BOOL,
    pub FrameNumber: u32,
    pub InlineFrameContext: u32,
    pub Reserved1: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_STACK_FRAME_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_STACK_FRAME_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_STACK_FRAME_EX {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_STACK_FRAME_EX")
            .field("InstructionOffset", &self.InstructionOffset)
            .field("ReturnOffset", &self.ReturnOffset)
            .field("FrameOffset", &self.FrameOffset)
            .field("StackOffset", &self.StackOffset)
            .field("FuncTableEntry", &self.FuncTableEntry)
            .field("Params", &self.Params)
            .field("Reserved", &self.Reserved)
            .field("Virtual", &self.Virtual)
            .field("FrameNumber", &self.FrameNumber)
            .field("InlineFrameContext", &self.InlineFrameContext)
            .field("Reserved1", &self.Reserved1)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_STACK_FRAME_EX {
    fn eq(&self, other: &Self) -> bool {
        self.InstructionOffset == other.InstructionOffset && self.ReturnOffset == other.ReturnOffset && self.FrameOffset == other.FrameOffset && self.StackOffset == other.StackOffset && self.FuncTableEntry == other.FuncTableEntry && self.Params == other.Params && self.Reserved == other.Reserved && self.Virtual == other.Virtual && self.FrameNumber == other.FrameNumber && self.InlineFrameContext == other.InlineFrameContext && self.Reserved1 == other.Reserved1
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_STACK_FRAME_EX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_STACK_FRAME_EX {
    type Abi = Self;
}
pub const DEBUG_STACK_FRAME_MEMORY_USAGE: u32 = 512u32;
pub const DEBUG_STACK_FRAME_NUMBERS: u32 = 64u32;
pub const DEBUG_STACK_FRAME_OFFSETS: u32 = 4096u32;
pub const DEBUG_STACK_FUNCTION_INFO: u32 = 2u32;
pub const DEBUG_STACK_NONVOLATILE_REGISTERS: u32 = 32u32;
pub const DEBUG_STACK_PARAMETERS: u32 = 128u32;
pub const DEBUG_STACK_PARAMETERS_NEWLINE: u32 = 1024u32;
pub const DEBUG_STACK_PROVIDER: u32 = 8192u32;
pub const DEBUG_STACK_SOURCE_LINE: u32 = 4u32;
pub const DEBUG_STATUS_BREAK: u32 = 6u32;
pub const DEBUG_STATUS_GO: u32 = 1u32;
pub const DEBUG_STATUS_GO_HANDLED: u32 = 2u32;
pub const DEBUG_STATUS_GO_NOT_HANDLED: u32 = 3u32;
pub const DEBUG_STATUS_IGNORE_EVENT: u32 = 9u32;
pub const DEBUG_STATUS_INSIDE_WAIT: u64 = 4294967296u64;
pub const DEBUG_STATUS_MASK: u32 = 31u32;
pub const DEBUG_STATUS_NO_CHANGE: u32 = 0u32;
pub const DEBUG_STATUS_NO_DEBUGGEE: u32 = 7u32;
pub const DEBUG_STATUS_OUT_OF_SYNC: u32 = 15u32;
pub const DEBUG_STATUS_RESTART_REQUESTED: u32 = 10u32;
pub const DEBUG_STATUS_REVERSE_GO: u32 = 11u32;
pub const DEBUG_STATUS_REVERSE_STEP_BRANCH: u32 = 12u32;
pub const DEBUG_STATUS_REVERSE_STEP_INTO: u32 = 14u32;
pub const DEBUG_STATUS_REVERSE_STEP_OVER: u32 = 13u32;
pub const DEBUG_STATUS_STEP_BRANCH: u32 = 8u32;
pub const DEBUG_STATUS_STEP_INTO: u32 = 5u32;
pub const DEBUG_STATUS_STEP_OVER: u32 = 4u32;
pub const DEBUG_STATUS_TIMEOUT: u32 = 17u32;
pub const DEBUG_STATUS_WAIT_INPUT: u32 = 16u32;
pub const DEBUG_STATUS_WAIT_TIMEOUT: u64 = 8589934592u64;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_SYMBOL_ENTRY {
    pub ModuleBase: u64,
    pub Offset: u64,
    pub Id: u64,
    pub Arg64: u64,
    pub Size: u32,
    pub Flags: u32,
    pub TypeId: u32,
    pub NameSize: u32,
    pub Token: u32,
    pub Tag: u32,
    pub Arg32: u32,
    pub Reserved: u32,
}
impl DEBUG_SYMBOL_ENTRY {}
impl ::core::default::Default for DEBUG_SYMBOL_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_SYMBOL_ENTRY {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_SYMBOL_ENTRY")
            .field("ModuleBase", &self.ModuleBase)
            .field("Offset", &self.Offset)
            .field("Id", &self.Id)
            .field("Arg64", &self.Arg64)
            .field("Size", &self.Size)
            .field("Flags", &self.Flags)
            .field("TypeId", &self.TypeId)
            .field("NameSize", &self.NameSize)
            .field("Token", &self.Token)
            .field("Tag", &self.Tag)
            .field("Arg32", &self.Arg32)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_SYMBOL_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.ModuleBase == other.ModuleBase && self.Offset == other.Offset && self.Id == other.Id && self.Arg64 == other.Arg64 && self.Size == other.Size && self.Flags == other.Flags && self.TypeId == other.TypeId && self.NameSize == other.NameSize && self.Token == other.Token && self.Tag == other.Tag && self.Arg32 == other.Arg32 && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_SYMBOL_ENTRY {}
unsafe impl ::windows::core::Abi for DEBUG_SYMBOL_ENTRY {
    type Abi = Self;
}
pub const DEBUG_SYMBOL_EXPANDED: u32 = 16u32;
pub const DEBUG_SYMBOL_EXPANSION_LEVEL_MASK: u32 = 15u32;
pub const DEBUG_SYMBOL_IS_ARGUMENT: u32 = 256u32;
pub const DEBUG_SYMBOL_IS_ARRAY: u32 = 64u32;
pub const DEBUG_SYMBOL_IS_FLOAT: u32 = 128u32;
pub const DEBUG_SYMBOL_IS_LOCAL: u32 = 512u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_SYMBOL_PARAMETERS {
    pub Module: u64,
    pub TypeId: u32,
    pub ParentSymbol: u32,
    pub SubElements: u32,
    pub Flags: u32,
    pub Reserved: u64,
}
impl DEBUG_SYMBOL_PARAMETERS {}
impl ::core::default::Default for DEBUG_SYMBOL_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_SYMBOL_PARAMETERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_SYMBOL_PARAMETERS").field("Module", &self.Module).field("TypeId", &self.TypeId).field("ParentSymbol", &self.ParentSymbol).field("SubElements", &self.SubElements).field("Flags", &self.Flags).field("Reserved", &self.Reserved).finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_SYMBOL_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.Module == other.Module && self.TypeId == other.TypeId && self.ParentSymbol == other.ParentSymbol && self.SubElements == other.SubElements && self.Flags == other.Flags && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_SYMBOL_PARAMETERS {}
unsafe impl ::windows::core::Abi for DEBUG_SYMBOL_PARAMETERS {
    type Abi = Self;
}
pub const DEBUG_SYMBOL_READ_ONLY: u32 = 32u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_SYMBOL_SOURCE_ENTRY {
    pub ModuleBase: u64,
    pub Offset: u64,
    pub FileNameId: u64,
    pub EngineInternal: u64,
    pub Size: u32,
    pub Flags: u32,
    pub FileNameSize: u32,
    pub StartLine: u32,
    pub EndLine: u32,
    pub StartColumn: u32,
    pub EndColumn: u32,
    pub Reserved: u32,
}
impl DEBUG_SYMBOL_SOURCE_ENTRY {}
impl ::core::default::Default for DEBUG_SYMBOL_SOURCE_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_SYMBOL_SOURCE_ENTRY {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_SYMBOL_SOURCE_ENTRY")
            .field("ModuleBase", &self.ModuleBase)
            .field("Offset", &self.Offset)
            .field("FileNameId", &self.FileNameId)
            .field("EngineInternal", &self.EngineInternal)
            .field("Size", &self.Size)
            .field("Flags", &self.Flags)
            .field("FileNameSize", &self.FileNameSize)
            .field("StartLine", &self.StartLine)
            .field("EndLine", &self.EndLine)
            .field("StartColumn", &self.StartColumn)
            .field("EndColumn", &self.EndColumn)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_SYMBOL_SOURCE_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.ModuleBase == other.ModuleBase && self.Offset == other.Offset && self.FileNameId == other.FileNameId && self.EngineInternal == other.EngineInternal && self.Size == other.Size && self.Flags == other.Flags && self.FileNameSize == other.FileNameSize && self.StartLine == other.StartLine && self.EndLine == other.EndLine && self.StartColumn == other.StartColumn && self.EndColumn == other.EndColumn && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for DEBUG_SYMBOL_SOURCE_ENTRY {}
unsafe impl ::windows::core::Abi for DEBUG_SYMBOL_SOURCE_ENTRY {
    type Abi = Self;
}
pub const DEBUG_SYMENT_IS_CODE: u32 = 1u32;
pub const DEBUG_SYMENT_IS_DATA: u32 = 2u32;
pub const DEBUG_SYMENT_IS_LOCAL: u32 = 8u32;
pub const DEBUG_SYMENT_IS_MANAGED: u32 = 16u32;
pub const DEBUG_SYMENT_IS_PARAMETER: u32 = 4u32;
pub const DEBUG_SYMENT_IS_SYNTHETIC: u32 = 32u32;
pub const DEBUG_SYMINFO_BREAKPOINT_SOURCE_LINE: u32 = 0u32;
pub const DEBUG_SYMINFO_GET_MODULE_SYMBOL_NAMES_AND_OFFSETS: u32 = 3u32;
pub const DEBUG_SYMINFO_GET_SYMBOL_NAME_BY_OFFSET_AND_TAG_WIDE: u32 = 2u32;
pub const DEBUG_SYMINFO_IMAGEHLP_MODULEW64: u32 = 1u32;
pub const DEBUG_SYMTYPE_CODEVIEW: u32 = 2u32;
pub const DEBUG_SYMTYPE_COFF: u32 = 1u32;
pub const DEBUG_SYMTYPE_DEFERRED: u32 = 5u32;
pub const DEBUG_SYMTYPE_DIA: u32 = 7u32;
pub const DEBUG_SYMTYPE_EXPORT: u32 = 4u32;
pub const DEBUG_SYMTYPE_NONE: u32 = 0u32;
pub const DEBUG_SYMTYPE_PDB: u32 = 3u32;
pub const DEBUG_SYMTYPE_SYM: u32 = 6u32;
pub const DEBUG_SYSOBJINFO_CURRENT_PROCESS_COOKIE: u32 = 2u32;
pub const DEBUG_SYSOBJINFO_THREAD_BASIC_INFORMATION: u32 = 0u32;
pub const DEBUG_SYSOBJINFO_THREAD_NAME_WIDE: u32 = 1u32;
pub const DEBUG_SYSVERSTR_BUILD: u32 = 1u32;
pub const DEBUG_SYSVERSTR_SERVICE_PACK: u32 = 0u32;
pub const DEBUG_TBINFO_AFFINITY: u32 = 32u32;
pub const DEBUG_TBINFO_ALL: u32 = 63u32;
pub const DEBUG_TBINFO_EXIT_STATUS: u32 = 1u32;
pub const DEBUG_TBINFO_PRIORITY: u32 = 4u32;
pub const DEBUG_TBINFO_PRIORITY_CLASS: u32 = 2u32;
pub const DEBUG_TBINFO_START_OFFSET: u32 = 16u32;
pub const DEBUG_TBINFO_TIMES: u32 = 8u32;
pub const DEBUG_TEXT_ALLOWBREAKPOINTS: u32 = 8u32;
pub const DEBUG_TEXT_ALLOWERRORREPORT: u32 = 16u32;
pub const DEBUG_TEXT_EVALUATETOCODECONTEXT: u32 = 32u32;
pub const DEBUG_TEXT_ISEXPRESSION: u32 = 1u32;
pub const DEBUG_TEXT_ISNONUSERCODE: u32 = 64u32;
pub const DEBUG_TEXT_NOSIDEEFFECTS: u32 = 4u32;
pub const DEBUG_TEXT_RETURNVALUE: u32 = 2u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_THREAD_BASIC_INFORMATION {
    pub Valid: u32,
    pub ExitStatus: u32,
    pub PriorityClass: u32,
    pub Priority: u32,
    pub CreateTime: u64,
    pub ExitTime: u64,
    pub KernelTime: u64,
    pub UserTime: u64,
    pub StartOffset: u64,
    pub Affinity: u64,
}
impl DEBUG_THREAD_BASIC_INFORMATION {}
impl ::core::default::Default for DEBUG_THREAD_BASIC_INFORMATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_THREAD_BASIC_INFORMATION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_THREAD_BASIC_INFORMATION")
            .field("Valid", &self.Valid)
            .field("ExitStatus", &self.ExitStatus)
            .field("PriorityClass", &self.PriorityClass)
            .field("Priority", &self.Priority)
            .field("CreateTime", &self.CreateTime)
            .field("ExitTime", &self.ExitTime)
            .field("KernelTime", &self.KernelTime)
            .field("UserTime", &self.UserTime)
            .field("StartOffset", &self.StartOffset)
            .field("Affinity", &self.Affinity)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_THREAD_BASIC_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Valid == other.Valid && self.ExitStatus == other.ExitStatus && self.PriorityClass == other.PriorityClass && self.Priority == other.Priority && self.CreateTime == other.CreateTime && self.ExitTime == other.ExitTime && self.KernelTime == other.KernelTime && self.UserTime == other.UserTime && self.StartOffset == other.StartOffset && self.Affinity == other.Affinity
    }
}
impl ::core::cmp::Eq for DEBUG_THREAD_BASIC_INFORMATION {}
unsafe impl ::windows::core::Abi for DEBUG_THREAD_BASIC_INFORMATION {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DEBUG_TYPED_DATA {
    pub ModBase: u64,
    pub Offset: u64,
    pub EngineHandle: u64,
    pub Data: u64,
    pub Size: u32,
    pub Flags: u32,
    pub TypeId: u32,
    pub BaseTypeId: u32,
    pub Tag: u32,
    pub Register: u32,
    pub Internal: [u64; 9],
}
impl DEBUG_TYPED_DATA {}
impl ::core::default::Default for DEBUG_TYPED_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DEBUG_TYPED_DATA {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DEBUG_TYPED_DATA")
            .field("ModBase", &self.ModBase)
            .field("Offset", &self.Offset)
            .field("EngineHandle", &self.EngineHandle)
            .field("Data", &self.Data)
            .field("Size", &self.Size)
            .field("Flags", &self.Flags)
            .field("TypeId", &self.TypeId)
            .field("BaseTypeId", &self.BaseTypeId)
            .field("Tag", &self.Tag)
            .field("Register", &self.Register)
            .field("Internal", &self.Internal)
            .finish()
    }
}
impl ::core::cmp::PartialEq for DEBUG_TYPED_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.ModBase == other.ModBase && self.Offset == other.Offset && self.EngineHandle == other.EngineHandle && self.Data == other.Data && self.Size == other.Size && self.Flags == other.Flags && self.TypeId == other.TypeId && self.BaseTypeId == other.BaseTypeId && self.Tag == other.Tag && self.Register == other.Register && self.Internal == other.Internal
    }
}
impl ::core::cmp::Eq for DEBUG_TYPED_DATA {}
unsafe impl ::windows::core::Abi for DEBUG_TYPED_DATA {
    type Abi = Self;
}
pub const DEBUG_TYPED_DATA_IS_IN_MEMORY: u32 = 1u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_CACHED: u32 = 4u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_DEFAULT: u32 = 2u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_MEMORY: u32 = 14u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_UNCACHED: u32 = 6u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_WRITE_COMBINED: u32 = 8u32;
pub const DEBUG_TYPEOPTS_FORCERADIX_OUTPUT: u32 = 4u32;
pub const DEBUG_TYPEOPTS_LONGSTATUS_DISPLAY: u32 = 2u32;
pub const DEBUG_TYPEOPTS_MATCH_MAXSIZE: u32 = 8u32;
pub const DEBUG_TYPEOPTS_UNICODE_DISPLAY: u32 = 1u32;
pub const DEBUG_USER_WINDOWS_DUMP: u32 = 1025u32;
pub const DEBUG_USER_WINDOWS_DUMP_WINDOWS_CE: u32 = 1029u32;
pub const DEBUG_USER_WINDOWS_IDNA: u32 = 2u32;
pub const DEBUG_USER_WINDOWS_PROCESS: u32 = 0u32;
pub const DEBUG_USER_WINDOWS_PROCESS_SERVER: u32 = 1u32;
pub const DEBUG_USER_WINDOWS_REPT: u32 = 3u32;
pub const DEBUG_USER_WINDOWS_SMALL_DUMP: u32 = 1024u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_VALUE {
    pub Anonymous: DEBUG_VALUE_0,
    pub TailOfRawBytes: u32,
    pub Type: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_VALUE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_VALUE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_VALUE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_VALUE {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DEBUG_VALUE_0 {
    pub I8: u8,
    pub I16: u16,
    pub I32: u32,
    pub Anonymous: DEBUG_VALUE_0_0,
    pub F32: f32,
    pub F64: f64,
    pub F80Bytes: [u8; 10],
    pub F82Bytes: [u8; 11],
    pub F128Bytes: [u8; 16],
    pub VI8: [u8; 16],
    pub VI16: [u16; 8],
    pub VI32: [u32; 4],
    pub VI64: [u64; 2],
    pub VF32: [f32; 4],
    pub VF64: [f64; 2],
    pub I64Parts32: DEBUG_VALUE_0_2,
    pub F128Parts64: DEBUG_VALUE_0_1,
    pub RawBytes: [u8; 24],
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_VALUE_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_VALUE_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_VALUE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_VALUE_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_VALUE_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_VALUE_0_0 {
    pub I64: u64,
    pub Nat: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_VALUE_0_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_VALUE_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_VALUE_0_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("I64", &self.I64).field("Nat", &self.Nat).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_VALUE_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.I64 == other.I64 && self.Nat == other.Nat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_VALUE_0_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_VALUE_0_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_VALUE_0_1 {
    pub LowPart: u64,
    pub HighPart: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_VALUE_0_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_VALUE_0_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_VALUE_0_1 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_F128Parts64_e__Struct").field("LowPart", &self.LowPart).field("HighPart", &self.HighPart).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_VALUE_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.LowPart == other.LowPart && self.HighPart == other.HighPart
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_VALUE_0_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_VALUE_0_1 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEBUG_VALUE_0_2 {
    pub LowPart: u32,
    pub HighPart: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DEBUG_VALUE_0_2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DEBUG_VALUE_0_2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DEBUG_VALUE_0_2 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_I64Parts32_e__Struct").field("LowPart", &self.LowPart).field("HighPart", &self.HighPart).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DEBUG_VALUE_0_2 {
    fn eq(&self, other: &Self) -> bool {
        self.LowPart == other.LowPart && self.HighPart == other.HighPart
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DEBUG_VALUE_0_2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DEBUG_VALUE_0_2 {
    type Abi = Self;
}
pub const DEBUG_VALUE_FLOAT128: u32 = 9u32;
pub const DEBUG_VALUE_FLOAT32: u32 = 5u32;
pub const DEBUG_VALUE_FLOAT64: u32 = 6u32;
pub const DEBUG_VALUE_FLOAT80: u32 = 7u32;
pub const DEBUG_VALUE_FLOAT82: u32 = 8u32;
pub const DEBUG_VALUE_INT16: u32 = 2u32;
pub const DEBUG_VALUE_INT32: u32 = 3u32;
pub const DEBUG_VALUE_INT64: u32 = 4u32;
pub const DEBUG_VALUE_INT8: u32 = 1u32;
pub const DEBUG_VALUE_INVALID: u32 = 0u32;
pub const DEBUG_VALUE_TYPES: u32 = 12u32;
pub const DEBUG_VALUE_VECTOR128: u32 = 11u32;
pub const DEBUG_VALUE_VECTOR64: u32 = 10u32;
pub const DEBUG_VSEARCH_DEFAULT: u32 = 0u32;
pub const DEBUG_VSEARCH_WRITABLE_ONLY: u32 = 1u32;
pub const DEBUG_VSOURCE_DEBUGGEE: u32 = 1u32;
pub const DEBUG_VSOURCE_DUMP_WITHOUT_MEMINFO: u32 = 3u32;
pub const DEBUG_VSOURCE_INVALID: u32 = 0u32;
pub const DEBUG_VSOURCE_MAPPED_IMAGE: u32 = 2u32;
pub const DEBUG_WAIT_DEFAULT: u32 = 0u32;
#[cfg(feature = "Win32_Foundation")]
pub type DIGEST_FUNCTION = unsafe extern "system" fn(refdata: *mut ::core::ffi::c_void, pdata: *mut u8, dwlength: u32) -> super::super::super::Foundation::BOOL;
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
pub struct DISPATCHER_CONTEXT {
    pub ControlPc: usize,
    pub ImageBase: usize,
    pub FunctionEntry: *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY,
    pub EstablisherFrame: usize,
    pub TargetPc: usize,
    pub ContextRecord: *mut CONTEXT,
    pub LanguageHandler: ::core::option::Option<super::super::Kernel::EXCEPTION_ROUTINE>,
    pub HandlerData: *mut ::core::ffi::c_void,
    pub HistoryTable: *mut UNWIND_HISTORY_TABLE,
    pub ScopeIndex: u32,
    pub ControlPcIsUnwound: super::super::super::Foundation::BOOLEAN,
    pub NonVolatileRegisters: *mut u8,
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::default::Default for DISPATCHER_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::fmt::Debug for DISPATCHER_CONTEXT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DISPATCHER_CONTEXT")
            .field("ControlPc", &self.ControlPc)
            .field("ImageBase", &self.ImageBase)
            .field("FunctionEntry", &self.FunctionEntry)
            .field("EstablisherFrame", &self.EstablisherFrame)
            .field("TargetPc", &self.TargetPc)
            .field("ContextRecord", &self.ContextRecord)
            .field("HandlerData", &self.HandlerData)
            .field("HistoryTable", &self.HistoryTable)
            .field("ScopeIndex", &self.ScopeIndex)
            .field("ControlPcIsUnwound", &self.ControlPcIsUnwound)
            .field("NonVolatileRegisters", &self.NonVolatileRegisters)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::PartialEq for DISPATCHER_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.ControlPc == other.ControlPc
            && self.ImageBase == other.ImageBase
            && self.FunctionEntry == other.FunctionEntry
            && self.EstablisherFrame == other.EstablisherFrame
            && self.TargetPc == other.TargetPc
            && self.ContextRecord == other.ContextRecord
            && self.LanguageHandler.map(|f| f as usize) == other.LanguageHandler.map(|f| f as usize)
            && self.HandlerData == other.HandlerData
            && self.HistoryTable == other.HistoryTable
            && self.ScopeIndex == other.ScopeIndex
            && self.ControlPcIsUnwound == other.ControlPcIsUnwound
            && self.NonVolatileRegisters == other.NonVolatileRegisters
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::Eq for DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::core::Abi for DISPATCHER_CONTEXT {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
pub struct DISPATCHER_CONTEXT {
    pub ControlPc: u64,
    pub ImageBase: u64,
    pub FunctionEntry: *mut IMAGE_RUNTIME_FUNCTION_ENTRY,
    pub EstablisherFrame: u64,
    pub TargetIp: u64,
    pub ContextRecord: *mut CONTEXT,
    pub LanguageHandler: ::core::option::Option<super::super::Kernel::EXCEPTION_ROUTINE>,
    pub HandlerData: *mut ::core::ffi::c_void,
    pub HistoryTable: *mut UNWIND_HISTORY_TABLE,
    pub ScopeIndex: u32,
    pub Fill0: u32,
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::default::Default for DISPATCHER_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::fmt::Debug for DISPATCHER_CONTEXT {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DISPATCHER_CONTEXT")
            .field("ControlPc", &self.ControlPc)
            .field("ImageBase", &self.ImageBase)
            .field("FunctionEntry", &self.FunctionEntry)
            .field("EstablisherFrame", &self.EstablisherFrame)
            .field("TargetIp", &self.TargetIp)
            .field("ContextRecord", &self.ContextRecord)
            .field("HandlerData", &self.HandlerData)
            .field("HistoryTable", &self.HistoryTable)
            .field("ScopeIndex", &self.ScopeIndex)
            .field("Fill0", &self.Fill0)
            .finish()
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::PartialEq for DISPATCHER_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.ControlPc == other.ControlPc && self.ImageBase == other.ImageBase && self.FunctionEntry == other.FunctionEntry && self.EstablisherFrame == other.EstablisherFrame && self.TargetIp == other.TargetIp && self.ContextRecord == other.ContextRecord && self.LanguageHandler.map(|f| f as usize) == other.LanguageHandler.map(|f| f as usize) && self.HandlerData == other.HandlerData && self.HistoryTable == other.HistoryTable && self.ScopeIndex == other.ScopeIndex && self.Fill0 == other.Fill0
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::Eq for DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::core::Abi for DISPATCHER_CONTEXT {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
pub const DMP_CONTEXT_RECORD_SIZE_32: u32 = 1200u32;
pub const DMP_CONTEXT_RECORD_SIZE_64: u32 = 3000u32;
pub const DMP_HEADER_COMMENT_SIZE: u32 = 128u32;
pub const DMP_PHYSICAL_MEMORY_BLOCK_SIZE_32: u32 = 700u32;
pub const DMP_PHYSICAL_MEMORY_BLOCK_SIZE_64: u32 = 700u32;
pub const DMP_RESERVED_0_SIZE_32: u32 = 1760u32;
pub const DMP_RESERVED_0_SIZE_64: u32 = 4008u32;
pub const DMP_RESERVED_2_SIZE_32: u32 = 16u32;
pub const DMP_RESERVED_3_SIZE_32: u32 = 56u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct DOCUMENTNAMETYPE(pub i32);
pub const DOCUMENTNAMETYPE_APPNODE: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(0i32);
pub const DOCUMENTNAMETYPE_TITLE: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(1i32);
pub const DOCUMENTNAMETYPE_FILE_TAIL: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(2i32);
pub const DOCUMENTNAMETYPE_URL: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(3i32);
pub const DOCUMENTNAMETYPE_UNIQUE_TITLE: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(4i32);
pub const DOCUMENTNAMETYPE_SOURCE_MAP_URL: DOCUMENTNAMETYPE = DOCUMENTNAMETYPE(5i32);
impl ::core::convert::From<i32> for DOCUMENTNAMETYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for DOCUMENTNAMETYPE {
    type Abi = Self;
}
pub const DSLFLAG_MISMATCHED_DBG: u32 = 2u32;
pub const DSLFLAG_MISMATCHED_PDB: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub union DUMP_FILE_ATTRIBUTES {
    pub Anonymous: DUMP_FILE_ATTRIBUTES_0,
    pub Attributes: u32,
}
impl DUMP_FILE_ATTRIBUTES {}
impl ::core::default::Default for DUMP_FILE_ATTRIBUTES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for DUMP_FILE_ATTRIBUTES {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for DUMP_FILE_ATTRIBUTES {}
unsafe impl ::windows::core::Abi for DUMP_FILE_ATTRIBUTES {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct DUMP_FILE_ATTRIBUTES_0 {
    pub _bitfield: u32,
}
impl DUMP_FILE_ATTRIBUTES_0 {}
impl ::core::default::Default for DUMP_FILE_ATTRIBUTES_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for DUMP_FILE_ATTRIBUTES_0 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::core::cmp::PartialEq for DUMP_FILE_ATTRIBUTES_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::core::cmp::Eq for DUMP_FILE_ATTRIBUTES_0 {}
unsafe impl ::windows::core::Abi for DUMP_FILE_ATTRIBUTES_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DUMP_HEADER32 {
    pub Signature: u32,
    pub ValidDump: u32,
    pub MajorVersion: u32,
    pub MinorVersion: u32,
    pub DirectoryTableBase: u32,
    pub PfnDataBase: u32,
    pub PsLoadedModuleList: u32,
    pub PsActiveProcessHead: u32,
    pub MachineImageType: u32,
    pub NumberProcessors: u32,
    pub BugCheckCode: u32,
    pub BugCheckParameter1: u32,
    pub BugCheckParameter2: u32,
    pub BugCheckParameter3: u32,
    pub BugCheckParameter4: u32,
    pub VersionUser: [super::super::super::Foundation::CHAR; 32],
    pub PaeEnabled: u8,
    pub KdSecondaryVersion: u8,
    pub Spare3: [u8; 2],
    pub KdDebuggerDataBlock: u32,
    pub Anonymous: DUMP_HEADER32_0,
    pub ContextRecord: [u8; 1200],
    pub Exception: EXCEPTION_RECORD32,
    pub Comment: [super::super::super::Foundation::CHAR; 128],
    pub Attributes: DUMP_FILE_ATTRIBUTES,
    pub BootId: u32,
    pub _reserved0: [u8; 1760],
    pub DumpType: u32,
    pub MiniDumpFields: u32,
    pub SecondaryDataState: u32,
    pub ProductType: u32,
    pub SuiteMask: u32,
    pub WriterStatus: u32,
    pub RequiredDumpSpace: i64,
    pub _reserved2: [u8; 16],
    pub SystemUpTime: i64,
    pub SystemTime: i64,
    pub _reserved3: [u8; 56],
}
#[cfg(feature = "Win32_Foundation")]
impl DUMP_HEADER32 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DUMP_HEADER32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DUMP_HEADER32 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DUMP_HEADER32 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DUMP_HEADER32 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DUMP_HEADER32_0 {
    pub PhysicalMemoryBlock: PHYSICAL_MEMORY_DESCRIPTOR32,
    pub PhysicalMemoryBlockBuffer: [u8; 700],
}
#[cfg(feature = "Win32_Foundation")]
impl DUMP_HEADER32_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DUMP_HEADER32_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DUMP_HEADER32_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DUMP_HEADER32_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DUMP_HEADER32_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DUMP_HEADER64 {
    pub Signature: u32,
    pub ValidDump: u32,
    pub MajorVersion: u32,
    pub MinorVersion: u32,
    pub DirectoryTableBase: u64,
    pub PfnDataBase: u64,
    pub PsLoadedModuleList: u64,
    pub PsActiveProcessHead: u64,
    pub MachineImageType: u32,
    pub NumberProcessors: u32,
    pub BugCheckCode: u32,
    pub BugCheckParameter1: u64,
    pub BugCheckParameter2: u64,
    pub BugCheckParameter3: u64,
    pub BugCheckParameter4: u64,
    pub VersionUser: [super::super::super::Foundation::CHAR; 32],
    pub KdDebuggerDataBlock: u64,
    pub Anonymous: DUMP_HEADER64_0,
    pub ContextRecord: [u8; 3000],
    pub Exception: EXCEPTION_RECORD64,
    pub DumpType: u32,
    pub RequiredDumpSpace: i64,
    pub SystemTime: i64,
    pub Comment: [super::super::super::Foundation::CHAR; 128],
    pub SystemUpTime: i64,
    pub MiniDumpFields: u32,
    pub SecondaryDataState: u32,
    pub ProductType: u32,
    pub SuiteMask: u32,
    pub WriterStatus: u32,
    pub Unused1: u8,
    pub KdSecondaryVersion: u8,
    pub Unused: [u8; 2],
    pub Attributes: DUMP_FILE_ATTRIBUTES,
    pub BootId: u32,
    pub _reserved0: [u8; 4008],
}
#[cfg(feature = "Win32_Foundation")]
impl DUMP_HEADER64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DUMP_HEADER64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DUMP_HEADER64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DUMP_HEADER64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DUMP_HEADER64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DUMP_HEADER64_0 {
    pub PhysicalMemoryBlock: PHYSICAL_MEMORY_DESCRIPTOR64,
    pub PhysicalMemoryBlockBuffer: [u8; 700],
}
#[cfg(feature = "Win32_Foundation")]
impl DUMP_HEADER64_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DUMP_HEADER64_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DUMP_HEADER64_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DUMP_HEADER64_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DUMP_HEADER64_0 {
    type Abi = Self;
}
pub const DUMP_SUMMARY_VALID_CURRENT_USER_VA: u32 = 2u32;
pub const DUMP_SUMMARY_VALID_KERNEL_VA: u32 = 1u32;
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DbgHelpCreateUserDump<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(filename: Param0, callback: ::core::option::Option<PDBGHELP_CREATE_USER_DUMP_CALLBACK>, userdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DbgHelpCreateUserDump(filename: super::super::super::Foundation::PSTR, callback: ::windows::core::RawPtr, userdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DbgHelpCreateUserDump(filename.into_param().abi(), ::core::mem::transmute(callback), ::core::mem::transmute(userdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DbgHelpCreateUserDumpW<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(filename: Param0, callback: ::core::option::Option<PDBGHELP_CREATE_USER_DUMP_CALLBACK>, userdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DbgHelpCreateUserDumpW(filename: super::super::super::Foundation::PWSTR, callback: ::windows::core::RawPtr, userdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DbgHelpCreateUserDumpW(filename.into_param().abi(), ::core::mem::transmute(callback), ::core::mem::transmute(userdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugActiveProcess(dwprocessid: u32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugActiveProcess(dwprocessid: u32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DebugActiveProcess(::core::mem::transmute(dwprocessid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugActiveProcessStop(dwprocessid: u32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugActiveProcessStop(dwprocessid: u32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DebugActiveProcessStop(::core::mem::transmute(dwprocessid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct DebugBaseEventCallbacks(pub ::windows::core::IUnknown);
impl DebugBaseEventCallbacks {
    pub unsafe fn GetInterestMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Breakpoint<'a, Param0: ::windows::core::IntoParam<'a, IDebugBreakpoint>>(&self, bp: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), bp.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Exception(&self, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(exception), ::core::mem::transmute(firstchance)).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(handle), ::core::mem::transmute(dataoffset), ::core::mem::transmute(startoffset)).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(exitcode)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: Param4, imagename: Param5, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imagefilehandle),
            ::core::mem::transmute(handle),
            ::core::mem::transmute(baseoffset),
            ::core::mem::transmute(modulesize),
            modulename.into_param().abi(),
            imagename.into_param().abi(),
            ::core::mem::transmute(checksum),
            ::core::mem::transmute(timedatestamp),
            ::core::mem::transmute(initialthreadhandle),
            ::core::mem::transmute(threaddataoffset),
            ::core::mem::transmute(startoffset),
        )
        .ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(exitcode)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LoadModule<'a, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: Param3, imagename: Param4, checksum: u32, timedatestamp: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(imagefilehandle), ::core::mem::transmute(baseoffset), ::core::mem::transmute(modulesize), modulename.into_param().abi(), imagename.into_param().abi(), ::core::mem::transmute(checksum), ::core::mem::transmute(timedatestamp)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnloadModule<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, imagebasename: Param0, baseoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), imagebasename.into_param().abi(), ::core::mem::transmute(baseoffset)).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(error), ::core::mem::transmute(level)).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(status)).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
}
unsafe impl ::windows::core::Interface for DebugBaseEventCallbacks {
    type Vtable = DebugBaseEventCallbacks_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
impl ::core::convert::From<DebugBaseEventCallbacks> for ::windows::core::IUnknown {
    fn from(value: DebugBaseEventCallbacks) -> Self {
        value.0
    }
}
impl ::core::convert::From<&DebugBaseEventCallbacks> for ::windows::core::IUnknown {
    fn from(value: &DebugBaseEventCallbacks) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DebugBaseEventCallbacks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a DebugBaseEventCallbacks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<DebugBaseEventCallbacks> for IDebugEventCallbacks {
    fn from(value: DebugBaseEventCallbacks) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DebugBaseEventCallbacks> for IDebugEventCallbacks {
    fn from(value: &DebugBaseEventCallbacks) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugEventCallbacks> for DebugBaseEventCallbacks {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugEventCallbacks> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugEventCallbacks> for &DebugBaseEventCallbacks {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugEventCallbacks> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacks_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, bp: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exitcode: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: super::super::super::Foundation::PSTR, imagename: super::super::super::Foundation::PSTR, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exitcode: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: super::super::super::Foundation::PSTR, imagename: super::super::super::Foundation::PSTR, checksum: u32, timedatestamp: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagebasename: super::super::super::Foundation::PSTR, baseoffset: u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, error: u32, level: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, status: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct DebugBaseEventCallbacksWide(pub ::windows::core::IUnknown);
impl DebugBaseEventCallbacksWide {
    pub unsafe fn GetInterestMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Breakpoint<'a, Param0: ::windows::core::IntoParam<'a, IDebugBreakpoint2>>(&self, bp: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), bp.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Exception(&self, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(exception), ::core::mem::transmute(firstchance)).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(handle), ::core::mem::transmute(dataoffset), ::core::mem::transmute(startoffset)).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(exitcode)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: Param4, imagename: Param5, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imagefilehandle),
            ::core::mem::transmute(handle),
            ::core::mem::transmute(baseoffset),
            ::core::mem::transmute(modulesize),
            modulename.into_param().abi(),
            imagename.into_param().abi(),
            ::core::mem::transmute(checksum),
            ::core::mem::transmute(timedatestamp),
            ::core::mem::transmute(initialthreadhandle),
            ::core::mem::transmute(threaddataoffset),
            ::core::mem::transmute(startoffset),
        )
        .ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(exitcode)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LoadModule<'a, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: Param3, imagename: Param4, checksum: u32, timedatestamp: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(imagefilehandle), ::core::mem::transmute(baseoffset), ::core::mem::transmute(modulesize), modulename.into_param().abi(), imagename.into_param().abi(), ::core::mem::transmute(checksum), ::core::mem::transmute(timedatestamp)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnloadModule<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, imagebasename: Param0, baseoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), imagebasename.into_param().abi(), ::core::mem::transmute(baseoffset)).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(error), ::core::mem::transmute(level)).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(status)).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(argument)).ok()
    }
}
unsafe impl ::windows::core::Interface for DebugBaseEventCallbacksWide {
    type Vtable = DebugBaseEventCallbacksWide_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
impl ::core::convert::From<DebugBaseEventCallbacksWide> for ::windows::core::IUnknown {
    fn from(value: DebugBaseEventCallbacksWide) -> Self {
        value.0
    }
}
impl ::core::convert::From<&DebugBaseEventCallbacksWide> for ::windows::core::IUnknown {
    fn from(value: &DebugBaseEventCallbacksWide) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DebugBaseEventCallbacksWide {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a DebugBaseEventCallbacksWide {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<DebugBaseEventCallbacksWide> for IDebugEventCallbacksWide {
    fn from(value: DebugBaseEventCallbacksWide) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&DebugBaseEventCallbacksWide> for IDebugEventCallbacksWide {
    fn from(value: &DebugBaseEventCallbacksWide) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugEventCallbacksWide> for DebugBaseEventCallbacksWide {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugEventCallbacksWide> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugEventCallbacksWide> for &DebugBaseEventCallbacksWide {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugEventCallbacksWide> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacksWide_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, bp: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exitcode: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: super::super::super::Foundation::PWSTR, imagename: super::super::super::Foundation::PWSTR, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, exitcode: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: super::super::super::Foundation::PWSTR, imagename: super::super::super::Foundation::PWSTR, checksum: u32, timedatestamp: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, imagebasename: super::super::super::Foundation::PWSTR, baseoffset: u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, error: u32, level: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, status: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, argument: u64) -> ::windows::core::HRESULT,
);
#[inline]
pub unsafe fn DebugBreak() {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugBreak();
        }
        ::core::mem::transmute(DebugBreak())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugBreakProcess<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(process: Param0) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugBreakProcess(process: super::super::super::Foundation::HANDLE) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DebugBreakProcess(process.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugConnect<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(remoteoptions: Param0, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugConnect(remoteoptions: super::super::super::Foundation::PSTR, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        DebugConnect(remoteoptions.into_param().abi(), ::core::mem::transmute(interfaceid), ::core::mem::transmute(interface)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugConnectWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(remoteoptions: Param0, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugConnectWide(remoteoptions: super::super::super::Foundation::PWSTR, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        DebugConnectWide(remoteoptions.into_param().abi(), ::core::mem::transmute(interfaceid), ::core::mem::transmute(interface)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn DebugCreate(interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugCreate(interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        DebugCreate(::core::mem::transmute(interfaceid), ::core::mem::transmute(interface)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn DebugCreateEx(interfaceid: *const ::windows::core::GUID, dbgengoptions: u32, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugCreateEx(interfaceid: *const ::windows::core::GUID, dbgengoptions: u32, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        DebugCreateEx(::core::mem::transmute(interfaceid), ::core::mem::transmute(dbgengoptions), ::core::mem::transmute(interface)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DebugHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0bfcc060_8c1d_11d0_accd_00aa0060275c);
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DebugPropertyInfo {
    pub m_dwValidFields: u32,
    pub m_bstrName: super::super::super::Foundation::BSTR,
    pub m_bstrType: super::super::super::Foundation::BSTR,
    pub m_bstrValue: super::super::super::Foundation::BSTR,
    pub m_bstrFullName: super::super::super::Foundation::BSTR,
    pub m_dwAttrib: u32,
    pub m_pDebugProp: ::core::option::Option<IDebugProperty>,
}
#[cfg(feature = "Win32_Foundation")]
impl DebugPropertyInfo {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DebugPropertyInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DebugPropertyInfo {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DebugPropertyInfo")
            .field("m_dwValidFields", &self.m_dwValidFields)
            .field("m_bstrName", &self.m_bstrName)
            .field("m_bstrType", &self.m_bstrType)
            .field("m_bstrValue", &self.m_bstrValue)
            .field("m_bstrFullName", &self.m_bstrFullName)
            .field("m_dwAttrib", &self.m_dwAttrib)
            .field("m_pDebugProp", &self.m_pDebugProp)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DebugPropertyInfo {
    fn eq(&self, other: &Self) -> bool {
        self.m_dwValidFields == other.m_dwValidFields && self.m_bstrName == other.m_bstrName && self.m_bstrType == other.m_bstrType && self.m_bstrValue == other.m_bstrValue && self.m_bstrFullName == other.m_bstrFullName && self.m_dwAttrib == other.m_dwAttrib && self.m_pDebugProp == other.m_pDebugProp
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DebugPropertyInfo {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DebugPropertyInfo {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugSetProcessKillOnExit<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::BOOL>>(killonexit: Param0) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DebugSetProcessKillOnExit(killonexit: super::super::super::Foundation::BOOL) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DebugSetProcessKillOnExit(killonexit.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DebugStackFrameDescriptor {
    pub pdsf: ::core::option::Option<IDebugStackFrame>,
    pub dwMin: u32,
    pub dwLim: u32,
    pub fFinal: super::super::super::Foundation::BOOL,
    pub punkFinal: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl DebugStackFrameDescriptor {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DebugStackFrameDescriptor {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DebugStackFrameDescriptor {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DebugStackFrameDescriptor").field("pdsf", &self.pdsf).field("dwMin", &self.dwMin).field("dwLim", &self.dwLim).field("fFinal", &self.fFinal).field("punkFinal", &self.punkFinal).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DebugStackFrameDescriptor {
    fn eq(&self, other: &Self) -> bool {
        self.pdsf == other.pdsf && self.dwMin == other.dwMin && self.dwLim == other.dwLim && self.fFinal == other.fFinal && self.punkFinal == other.punkFinal
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DebugStackFrameDescriptor {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DebugStackFrameDescriptor {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[derive(:: core :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DebugStackFrameDescriptor64 {
    pub pdsf: ::core::option::Option<IDebugStackFrame>,
    pub dwMin: u64,
    pub dwLim: u64,
    pub fFinal: super::super::super::Foundation::BOOL,
    pub punkFinal: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl DebugStackFrameDescriptor64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DebugStackFrameDescriptor64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DebugStackFrameDescriptor64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("DebugStackFrameDescriptor64").field("pdsf", &self.pdsf).field("dwMin", &self.dwMin).field("dwLim", &self.dwLim).field("fFinal", &self.fFinal).field("punkFinal", &self.punkFinal).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DebugStackFrameDescriptor64 {
    fn eq(&self, other: &Self) -> bool {
        self.pdsf == other.pdsf && self.dwMin == other.dwMin && self.dwLim == other.dwLim && self.fFinal == other.fFinal && self.punkFinal == other.punkFinal
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DebugStackFrameDescriptor64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DebugStackFrameDescriptor64 {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[inline]
pub unsafe fn DecodePointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DecodePointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(DecodePointer(::core::mem::transmute(ptr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DecodeRemotePointer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(processhandle: Param0, ptr: *const ::core::ffi::c_void, decodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DecodeRemotePointer(processhandle: super::super::super::Foundation::HANDLE, ptr: *const ::core::ffi::c_void, decodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        DecodeRemotePointer(processhandle.into_param().abi(), ::core::mem::transmute(ptr), ::core::mem::transmute(decodedptr)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn DecodeSystemPointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DecodeSystemPointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(DecodeSystemPointer(::core::mem::transmute(ptr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DefaultDebugSessionProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x834128a2_51f4_11d0_8f20_00805f2cd064);
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct ERRORRESUMEACTION(pub i32);
pub const ERRORRESUMEACTION_ReexecuteErrorStatement: ERRORRESUMEACTION = ERRORRESUMEACTION(0i32);
pub const ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller: ERRORRESUMEACTION = ERRORRESUMEACTION(1i32);
pub const ERRORRESUMEACTION_SkipErrorStatement: ERRORRESUMEACTION = ERRORRESUMEACTION(2i32);
impl ::core::convert::From<i32> for ERRORRESUMEACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for ERRORRESUMEACTION {
    type Abi = Self;
}
pub const ERROR_DBG_CANCELLED: u32 = 3221226695u32;
pub const ERROR_DBG_TIMEOUT: u32 = 3221226932u32;
pub const ERROR_IMAGE_NOT_STRIPPED: u32 = 34816u32;
pub const ERROR_NO_DBG_POINTER: u32 = 34817u32;
pub const ERROR_NO_PDB_POINTER: u32 = 34818u32;
pub const ESLFLAG_FULLPATH: u32 = 1u32;
pub const ESLFLAG_INLINE_SITE: u32 = 16u32;
pub const ESLFLAG_NEAREST: u32 = 2u32;
pub const ESLFLAG_NEXT: u32 = 8u32;
pub const ESLFLAG_PREV: u32 = 4u32;
pub const EVENT_SRCSPEW: u32 = 100u32;
pub const EVENT_SRCSPEW_END: u32 = 199u32;
pub const EVENT_SRCSPEW_START: u32 = 100u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXCEPTION_DEBUG_INFO {
    pub ExceptionRecord: EXCEPTION_RECORD,
    pub dwFirstChance: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl EXCEPTION_DEBUG_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXCEPTION_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXCEPTION_DEBUG_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXCEPTION_DEBUG_INFO").field("ExceptionRecord", &self.ExceptionRecord).field("dwFirstChance", &self.dwFirstChance).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXCEPTION_DEBUG_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionRecord == other.ExceptionRecord && self.dwFirstChance == other.dwFirstChance
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXCEPTION_DEBUG_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXCEPTION_DEBUG_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
pub struct EXCEPTION_POINTERS {
    pub ExceptionRecord: *mut EXCEPTION_RECORD,
    pub ContextRecord: *mut CONTEXT,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl EXCEPTION_POINTERS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::default::Default for EXCEPTION_POINTERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::fmt::Debug for EXCEPTION_POINTERS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXCEPTION_POINTERS").field("ExceptionRecord", &self.ExceptionRecord).field("ContextRecord", &self.ContextRecord).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::PartialEq for EXCEPTION_POINTERS {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionRecord == other.ExceptionRecord && self.ContextRecord == other.ContextRecord
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
impl ::core::cmp::Eq for EXCEPTION_POINTERS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::core::Abi for EXCEPTION_POINTERS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXCEPTION_RECORD {
    pub ExceptionCode: super::super::super::Foundation::NTSTATUS,
    pub ExceptionFlags: u32,
    pub ExceptionRecord: *mut EXCEPTION_RECORD,
    pub ExceptionAddress: *mut ::core::ffi::c_void,
    pub NumberParameters: u32,
    pub ExceptionInformation: [usize; 15],
}
#[cfg(feature = "Win32_Foundation")]
impl EXCEPTION_RECORD {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXCEPTION_RECORD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXCEPTION_RECORD {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXCEPTION_RECORD")
            .field("ExceptionCode", &self.ExceptionCode)
            .field("ExceptionFlags", &self.ExceptionFlags)
            .field("ExceptionRecord", &self.ExceptionRecord)
            .field("ExceptionAddress", &self.ExceptionAddress)
            .field("NumberParameters", &self.NumberParameters)
            .field("ExceptionInformation", &self.ExceptionInformation)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXCEPTION_RECORD {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionCode == other.ExceptionCode && self.ExceptionFlags == other.ExceptionFlags && self.ExceptionRecord == other.ExceptionRecord && self.ExceptionAddress == other.ExceptionAddress && self.NumberParameters == other.NumberParameters && self.ExceptionInformation == other.ExceptionInformation
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXCEPTION_RECORD {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXCEPTION_RECORD {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXCEPTION_RECORD32 {
    pub ExceptionCode: super::super::super::Foundation::NTSTATUS,
    pub ExceptionFlags: u32,
    pub ExceptionRecord: u32,
    pub ExceptionAddress: u32,
    pub NumberParameters: u32,
    pub ExceptionInformation: [u32; 15],
}
#[cfg(feature = "Win32_Foundation")]
impl EXCEPTION_RECORD32 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXCEPTION_RECORD32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXCEPTION_RECORD32 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXCEPTION_RECORD32")
            .field("ExceptionCode", &self.ExceptionCode)
            .field("ExceptionFlags", &self.ExceptionFlags)
            .field("ExceptionRecord", &self.ExceptionRecord)
            .field("ExceptionAddress", &self.ExceptionAddress)
            .field("NumberParameters", &self.NumberParameters)
            .field("ExceptionInformation", &self.ExceptionInformation)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXCEPTION_RECORD32 {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionCode == other.ExceptionCode && self.ExceptionFlags == other.ExceptionFlags && self.ExceptionRecord == other.ExceptionRecord && self.ExceptionAddress == other.ExceptionAddress && self.NumberParameters == other.NumberParameters && self.ExceptionInformation == other.ExceptionInformation
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXCEPTION_RECORD32 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXCEPTION_RECORD32 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXCEPTION_RECORD64 {
    pub ExceptionCode: super::super::super::Foundation::NTSTATUS,
    pub ExceptionFlags: u32,
    pub ExceptionRecord: u64,
    pub ExceptionAddress: u64,
    pub NumberParameters: u32,
    pub __unusedAlignment: u32,
    pub ExceptionInformation: [u64; 15],
}
#[cfg(feature = "Win32_Foundation")]
impl EXCEPTION_RECORD64 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXCEPTION_RECORD64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXCEPTION_RECORD64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXCEPTION_RECORD64")
            .field("ExceptionCode", &self.ExceptionCode)
            .field("ExceptionFlags", &self.ExceptionFlags)
            .field("ExceptionRecord", &self.ExceptionRecord)
            .field("ExceptionAddress", &self.ExceptionAddress)
            .field("NumberParameters", &self.NumberParameters)
            .field("__unusedAlignment", &self.__unusedAlignment)
            .field("ExceptionInformation", &self.ExceptionInformation)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXCEPTION_RECORD64 {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionCode == other.ExceptionCode && self.ExceptionFlags == other.ExceptionFlags && self.ExceptionRecord == other.ExceptionRecord && self.ExceptionAddress == other.ExceptionAddress && self.NumberParameters == other.NumberParameters && self.__unusedAlignment == other.__unusedAlignment && self.ExceptionInformation == other.ExceptionInformation
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXCEPTION_RECORD64 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXCEPTION_RECORD64 {
    type Abi = Self;
}
pub const EXIT_ON_CONTROLC: u32 = 8u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXIT_PROCESS_DEBUG_INFO {
    pub dwExitCode: u32,
}
impl EXIT_PROCESS_DEBUG_INFO {}
impl ::core::default::Default for EXIT_PROCESS_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXIT_PROCESS_DEBUG_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXIT_PROCESS_DEBUG_INFO").field("dwExitCode", &self.dwExitCode).finish()
    }
}
impl ::core::cmp::PartialEq for EXIT_PROCESS_DEBUG_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwExitCode == other.dwExitCode
    }
}
impl ::core::cmp::Eq for EXIT_PROCESS_DEBUG_INFO {}
unsafe impl ::windows::core::Abi for EXIT_PROCESS_DEBUG_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXIT_THREAD_DEBUG_INFO {
    pub dwExitCode: u32,
}
impl EXIT_THREAD_DEBUG_INFO {}
impl ::core::default::Default for EXIT_THREAD_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXIT_THREAD_DEBUG_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXIT_THREAD_DEBUG_INFO").field("dwExitCode", &self.dwExitCode).finish()
    }
}
impl ::core::cmp::PartialEq for EXIT_THREAD_DEBUG_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwExitCode == other.dwExitCode
    }
}
impl ::core::cmp::Eq for EXIT_THREAD_DEBUG_INFO {}
unsafe impl ::windows::core::Abi for EXIT_THREAD_DEBUG_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXTSTACKTRACE {
    pub FramePointer: u32,
    pub ProgramCounter: u32,
    pub ReturnAddress: u32,
    pub Args: [u32; 4],
}
impl EXTSTACKTRACE {}
impl ::core::default::Default for EXTSTACKTRACE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXTSTACKTRACE {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXTSTACKTRACE").field("FramePointer", &self.FramePointer).field("ProgramCounter", &self.ProgramCounter).field("ReturnAddress", &self.ReturnAddress).field("Args", &self.Args).finish()
    }
}
impl ::core::cmp::PartialEq for EXTSTACKTRACE {
    fn eq(&self, other: &Self) -> bool {
        self.FramePointer == other.FramePointer && self.ProgramCounter == other.ProgramCounter && self.ReturnAddress == other.ReturnAddress && self.Args == other.Args
    }
}
impl ::core::cmp::Eq for EXTSTACKTRACE {}
unsafe impl ::windows::core::Abi for EXTSTACKTRACE {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXTSTACKTRACE32 {
    pub FramePointer: u32,
    pub ProgramCounter: u32,
    pub ReturnAddress: u32,
    pub Args: [u32; 4],
}
impl EXTSTACKTRACE32 {}
impl ::core::default::Default for EXTSTACKTRACE32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXTSTACKTRACE32 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXTSTACKTRACE32").field("FramePointer", &self.FramePointer).field("ProgramCounter", &self.ProgramCounter).field("ReturnAddress", &self.ReturnAddress).field("Args", &self.Args).finish()
    }
}
impl ::core::cmp::PartialEq for EXTSTACKTRACE32 {
    fn eq(&self, other: &Self) -> bool {
        self.FramePointer == other.FramePointer && self.ProgramCounter == other.ProgramCounter && self.ReturnAddress == other.ReturnAddress && self.Args == other.Args
    }
}
impl ::core::cmp::Eq for EXTSTACKTRACE32 {}
unsafe impl ::windows::core::Abi for EXTSTACKTRACE32 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXTSTACKTRACE64 {
    pub FramePointer: u64,
    pub ProgramCounter: u64,
    pub ReturnAddress: u64,
    pub Args: [u64; 4],
}
impl EXTSTACKTRACE64 {}
impl ::core::default::Default for EXTSTACKTRACE64 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXTSTACKTRACE64 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXTSTACKTRACE64").field("FramePointer", &self.FramePointer).field("ProgramCounter", &self.ProgramCounter).field("ReturnAddress", &self.ReturnAddress).field("Args", &self.Args).finish()
    }
}
impl ::core::cmp::PartialEq for EXTSTACKTRACE64 {
    fn eq(&self, other: &Self) -> bool {
        self.FramePointer == other.FramePointer && self.ProgramCounter == other.ProgramCounter && self.ReturnAddress == other.ReturnAddress && self.Args == other.Args
    }
}
impl ::core::cmp::Eq for EXTSTACKTRACE64 {}
unsafe impl ::windows::core::Abi for EXTSTACKTRACE64 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXT_API_VERSION {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub Revision: u16,
    pub Reserved: u16,
}
impl EXT_API_VERSION {}
impl ::core::default::Default for EXT_API_VERSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXT_API_VERSION {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXT_API_VERSION").field("MajorVersion", &self.MajorVersion).field("MinorVersion", &self.MinorVersion).field("Revision", &self.Revision).field("Reserved", &self.Reserved).finish()
    }
}
impl ::core::cmp::PartialEq for EXT_API_VERSION {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion && self.Revision == other.Revision && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for EXT_API_VERSION {}
unsafe impl ::windows::core::Abi for EXT_API_VERSION {
    type Abi = Self;
}
pub const EXT_API_VERSION_NUMBER: u32 = 5u32;
pub const EXT_API_VERSION_NUMBER32: u32 = 5u32;
pub const EXT_API_VERSION_NUMBER64: u32 = 6u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXT_FIND_FILE {
    pub FileName: super::super::super::Foundation::PWSTR,
    pub IndexedSize: u64,
    pub ImageTimeDateStamp: u32,
    pub ImageCheckSum: u32,
    pub ExtraInfo: *mut ::core::ffi::c_void,
    pub ExtraInfoSize: u32,
    pub Flags: u32,
    pub FileMapping: *mut ::core::ffi::c_void,
    pub FileMappingSize: u64,
    pub FileHandle: super::super::super::Foundation::HANDLE,
    pub FoundFileName: super::super::super::Foundation::PWSTR,
    pub FoundFileNameChars: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl EXT_FIND_FILE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXT_FIND_FILE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXT_FIND_FILE {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXT_FIND_FILE")
            .field("FileName", &self.FileName)
            .field("IndexedSize", &self.IndexedSize)
            .field("ImageTimeDateStamp", &self.ImageTimeDateStamp)
            .field("ImageCheckSum", &self.ImageCheckSum)
            .field("ExtraInfo", &self.ExtraInfo)
            .field("ExtraInfoSize", &self.ExtraInfoSize)
            .field("Flags", &self.Flags)
            .field("FileMapping", &self.FileMapping)
            .field("FileMappingSize", &self.FileMappingSize)
            .field("FileHandle", &self.FileHandle)
            .field("FoundFileName", &self.FoundFileName)
            .field("FoundFileNameChars", &self.FoundFileNameChars)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXT_FIND_FILE {
    fn eq(&self, other: &Self) -> bool {
        self.FileName == other.FileName
            && self.IndexedSize == other.IndexedSize
            && self.ImageTimeDateStamp == other.ImageTimeDateStamp
            && self.ImageCheckSum == other.ImageCheckSum
            && self.ExtraInfo == other.ExtraInfo
            && self.ExtraInfoSize == other.ExtraInfoSize
            && self.Flags == other.Flags
            && self.FileMapping == other.FileMapping
            && self.FileMappingSize == other.FileMappingSize
            && self.FileHandle == other.FileHandle
            && self.FoundFileName == other.FoundFileName
            && self.FoundFileNameChars == other.FoundFileNameChars
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXT_FIND_FILE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXT_FIND_FILE {
    type Abi = Self;
}
pub const EXT_FIND_FILE_ALLOW_GIVEN_PATH: u32 = 1u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct EXT_MATCH_PATTERN_A {
    pub Str: super::super::super::Foundation::PSTR,
    pub Pattern: super::super::super::Foundation::PSTR,
    pub CaseSensitive: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl EXT_MATCH_PATTERN_A {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXT_MATCH_PATTERN_A {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for EXT_MATCH_PATTERN_A {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXT_MATCH_PATTERN_A").field("Str", &self.Str).field("Pattern", &self.Pattern).field("CaseSensitive", &self.CaseSensitive).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXT_MATCH_PATTERN_A {
    fn eq(&self, other: &Self) -> bool {
        self.Str == other.Str && self.Pattern == other.Pattern && self.CaseSensitive == other.CaseSensitive
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXT_MATCH_PATTERN_A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXT_MATCH_PATTERN_A {
    type Abi = Self;
}
pub const EXT_OUTPUT_VER: u32 = 1u32;
pub const EXT_TDF_PHYSICAL_CACHED: u32 = 4u32;
pub const EXT_TDF_PHYSICAL_DEFAULT: u32 = 2u32;
pub const EXT_TDF_PHYSICAL_MEMORY: u32 = 14u32;
pub const EXT_TDF_PHYSICAL_UNCACHED: u32 = 6u32;
pub const EXT_TDF_PHYSICAL_WRITE_COMBINED: u32 = 8u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct EXT_TDOP(pub i32);
pub const EXT_TDOP_COPY: EXT_TDOP = EXT_TDOP(0i32);
pub const EXT_TDOP_RELEASE: EXT_TDOP = EXT_TDOP(1i32);
pub const EXT_TDOP_SET_FROM_EXPR: EXT_TDOP = EXT_TDOP(2i32);
pub const EXT_TDOP_SET_FROM_U64_EXPR: EXT_TDOP = EXT_TDOP(3i32);
pub const EXT_TDOP_GET_FIELD: EXT_TDOP = EXT_TDOP(4i32);
pub const EXT_TDOP_EVALUATE: EXT_TDOP = EXT_TDOP(5i32);
pub const EXT_TDOP_GET_TYPE_NAME: EXT_TDOP = EXT_TDOP(6i32);
pub const EXT_TDOP_OUTPUT_TYPE_NAME: EXT_TDOP = EXT_TDOP(7i32);
pub const EXT_TDOP_OUTPUT_SIMPLE_VALUE: EXT_TDOP = EXT_TDOP(8i32);
pub const EXT_TDOP_OUTPUT_FULL_VALUE: EXT_TDOP = EXT_TDOP(9i32);
pub const EXT_TDOP_HAS_FIELD: EXT_TDOP = EXT_TDOP(10i32);
pub const EXT_TDOP_GET_FIELD_OFFSET: EXT_TDOP = EXT_TDOP(11i32);
pub const EXT_TDOP_GET_ARRAY_ELEMENT: EXT_TDOP = EXT_TDOP(12i32);
pub const EXT_TDOP_GET_DEREFERENCE: EXT_TDOP = EXT_TDOP(13i32);
pub const EXT_TDOP_GET_TYPE_SIZE: EXT_TDOP = EXT_TDOP(14i32);
pub const EXT_TDOP_OUTPUT_TYPE_DEFINITION: EXT_TDOP = EXT_TDOP(15i32);
pub const EXT_TDOP_GET_POINTER_TO: EXT_TDOP = EXT_TDOP(16i32);
pub const EXT_TDOP_SET_FROM_TYPE_ID_AND_U64: EXT_TDOP = EXT_TDOP(17i32);
pub const EXT_TDOP_SET_PTR_FROM_TYPE_ID_AND_U64: EXT_TDOP = EXT_TDOP(18i32);
pub const EXT_TDOP_COUNT: EXT_TDOP = EXT_TDOP(19i32);
impl ::core::convert::From<i32> for EXT_TDOP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for EXT_TDOP {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct EXT_TYPED_DATA {
    pub Operation: EXT_TDOP,
    pub Flags: u32,
    pub InData: DEBUG_TYPED_DATA,
    pub OutData: DEBUG_TYPED_DATA,
    pub InStrIndex: u32,
    pub In32: u32,
    pub Out32: u32,
    pub In64: u64,
    pub Out64: u64,
    pub StrBufferIndex: u32,
    pub StrBufferChars: u32,
    pub StrCharsNeeded: u32,
    pub DataBufferIndex: u32,
    pub DataBufferBytes: u32,
    pub DataBytesNeeded: u32,
    pub Status: ::windows::core::HRESULT,
    pub Reserved: [u64; 8],
}
impl EXT_TYPED_DATA {}
impl ::core::default::Default for EXT_TYPED_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for EXT_TYPED_DATA {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("EXT_TYPED_DATA")
            .field("Operation", &self.Operation)
            .field("Flags", &self.Flags)
            .field("InData", &self.InData)
            .field("OutData", &self.OutData)
            .field("InStrIndex", &self.InStrIndex)
            .field("In32", &self.In32)
            .field("Out32", &self.Out32)
            .field("In64", &self.In64)
            .field("Out64", &self.Out64)
            .field("StrBufferIndex", &self.StrBufferIndex)
            .field("StrBufferChars", &self.StrBufferChars)
            .field("StrCharsNeeded", &self.StrCharsNeeded)
            .field("DataBufferIndex", &self.DataBufferIndex)
            .field("DataBufferBytes", &self.DataBufferBytes)
            .field("DataBytesNeeded", &self.DataBytesNeeded)
            .field("Status", &self.Status)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::core::cmp::PartialEq for EXT_TYPED_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.Operation == other.Operation
            && self.Flags == other.Flags
            && self.InData == other.InData
            && self.OutData == other.OutData
            && self.InStrIndex == other.InStrIndex
            && self.In32 == other.In32
            && self.Out32 == other.Out32
            && self.In64 == other.In64
            && self.Out64 == other.Out64
            && self.StrBufferIndex == other.StrBufferIndex
            && self.StrBufferChars == other.StrBufferChars
            && self.StrCharsNeeded == other.StrCharsNeeded
            && self.DataBufferIndex == other.DataBufferIndex
            && self.DataBufferBytes == other.DataBufferBytes
            && self.DataBytesNeeded == other.DataBytesNeeded
            && self.Status == other.Status
            && self.Reserved == other.Reserved
    }
}
impl ::core::cmp::Eq for EXT_TYPED_DATA {}
unsafe impl ::windows::core::Abi for EXT_TYPED_DATA {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct EX_PROP_INFO_FLAGS(pub i32);
pub const EX_PROP_INFO_ID: EX_PROP_INFO_FLAGS = EX_PROP_INFO_FLAGS(256i32);
pub const EX_PROP_INFO_NTYPE: EX_PROP_INFO_FLAGS = EX_PROP_INFO_FLAGS(512i32);
pub const EX_PROP_INFO_NVALUE: EX_PROP_INFO_FLAGS = EX_PROP_INFO_FLAGS(1024i32);
pub const EX_PROP_INFO_LOCKBYTES: EX_PROP_INFO_FLAGS = EX_PROP_INFO_FLAGS(2048i32);
pub const EX_PROP_INFO_DEBUGEXTPROP: EX_PROP_INFO_FLAGS = EX_PROP_INFO_FLAGS(4096i32);
impl ::core::convert::From<i32> for EX_PROP_INFO_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for EX_PROP_INFO_FLAGS {
    type Abi = Self;
}
pub const E_JsDEBUG_INVALID_MEMORY_ADDRESS: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338171i32 as _);
pub const E_JsDEBUG_MISMATCHED_RUNTIME: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338175i32 as _);
pub const E_JsDEBUG_OUTSIDE_OF_VM: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338172i32 as _);
pub const E_JsDEBUG_RUNTIME_NOT_IN_DEBUG_MODE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338169i32 as _);
pub const E_JsDEBUG_SOURCE_LOCATION_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338170i32 as _);
pub const E_JsDEBUG_UNKNOWN_THREAD: ::windows::core::HRESULT = ::windows::core::HRESULT(-1916338174i32 as _);
#[inline]
pub unsafe fn EncodePointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EncodePointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(EncodePointer(::core::mem::transmute(ptr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EncodeRemotePointer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(processhandle: Param0, ptr: *const ::core::ffi::c_void, encodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EncodeRemotePointer(processhandle: super::super::super::Foundation::HANDLE, ptr: *const ::core::ffi::c_void, encodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        EncodeRemotePointer(processhandle.into_param().abi(), ::core::mem::transmute(ptr), ::core::mem::transmute(encodedptr)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn EncodeSystemPointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EncodeSystemPointer(ptr: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void;
        }
        ::core::mem::transmute(EncodeSystemPointer(::core::mem::transmute(ptr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDirTree<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(
    hprocess: Param0,
    rootpath: Param1,
    inputpathname: Param2,
    outputpathbuffer: super::super::super::Foundation::PSTR,
    cb: ::core::option::Option<PENUMDIRTREE_CALLBACK>,
    data: *const ::core::ffi::c_void,
) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDirTree(hprocess: super::super::super::Foundation::HANDLE, rootpath: super::super::super::Foundation::PSTR, inputpathname: super::super::super::Foundation::PSTR, outputpathbuffer: super::super::super::Foundation::PSTR, cb: ::windows::core::RawPtr, data: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumDirTree(hprocess.into_param().abi(), rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer), ::core::mem::transmute(cb), ::core::mem::transmute(data)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDirTreeW<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(
    hprocess: Param0,
    rootpath: Param1,
    inputpathname: Param2,
    outputpathbuffer: super::super::super::Foundation::PWSTR,
    cb: ::core::option::Option<PENUMDIRTREE_CALLBACKW>,
    data: *const ::core::ffi::c_void,
) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDirTreeW(hprocess: super::super::super::Foundation::HANDLE, rootpath: super::super::super::Foundation::PWSTR, inputpathname: super::super::super::Foundation::PWSTR, outputpathbuffer: super::super::super::Foundation::PWSTR, cb: ::windows::core::RawPtr, data: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumDirTreeW(hprocess.into_param().abi(), rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer), ::core::mem::transmute(cb), ::core::mem::transmute(data)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86",))]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModules<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, enumloadedmodulescallback: ::core::option::Option<PENUMLOADED_MODULES_CALLBACK>, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumerateLoadedModules(hprocess: super::super::super::Foundation::HANDLE, enumloadedmodulescallback: ::windows::core::RawPtr, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumerateLoadedModules(hprocess.into_param().abi(), ::core::mem::transmute(enumloadedmodulescallback), ::core::mem::transmute(usercontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModules64<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, enumloadedmodulescallback: ::core::option::Option<PENUMLOADED_MODULES_CALLBACK64>, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumerateLoadedModules64(hprocess: super::super::super::Foundation::HANDLE, enumloadedmodulescallback: ::windows::core::RawPtr, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumerateLoadedModules64(hprocess.into_param().abi(), ::core::mem::transmute(enumloadedmodulescallback), ::core::mem::transmute(usercontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, enumloadedmodulescallback: ::core::option::Option<PENUMLOADED_MODULES_CALLBACK64>, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumerateLoadedModulesEx(hprocess: super::super::super::Foundation::HANDLE, enumloadedmodulescallback: ::windows::core::RawPtr, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumerateLoadedModulesEx(hprocess.into_param().abi(), ::core::mem::transmute(enumloadedmodulescallback), ::core::mem::transmute(usercontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesExW<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, enumloadedmodulescallback: ::core::option::Option<PENUMLOADED_MODULES_CALLBACKW64>, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumerateLoadedModulesExW(hprocess: super::super::super::Foundation::HANDLE, enumloadedmodulescallback: ::windows::core::RawPtr, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumerateLoadedModulesExW(hprocess.into_param().abi(), ::core::mem::transmute(enumloadedmodulescallback), ::core::mem::transmute(usercontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesW64<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, enumloadedmodulescallback: ::core::option::Option<PENUMLOADED_MODULES_CALLBACKW64>, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumerateLoadedModulesW64(hprocess: super::super::super::Foundation::HANDLE, enumloadedmodulescallback: ::windows::core::RawPtr, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(EnumerateLoadedModulesW64(hprocess.into_param().abi(), ::core::mem::transmute(enumloadedmodulescallback), ::core::mem::transmute(usercontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct ErrorClass(pub i32);
pub const ErrorClassWarning: ErrorClass = ErrorClass(0i32);
pub const ErrorClassError: ErrorClass = ErrorClass(1i32);
impl ::core::convert::From<i32> for ErrorClass {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for ErrorClass {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
impl ::core::clone::Clone for ExtendedDebugPropertyInfo {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
pub struct ExtendedDebugPropertyInfo {
    pub dwValidFields: u32,
    pub pszName: super::super::super::Foundation::PWSTR,
    pub pszType: super::super::super::Foundation::PWSTR,
    pub pszValue: super::super::super::Foundation::PWSTR,
    pub pszFullName: super::super::super::Foundation::PWSTR,
    pub dwAttrib: u32,
    pub pDebugProp: ::core::option::Option<IDebugProperty>,
    pub nDISPID: u32,
    pub nType: u32,
    pub varValue: super::super::Com::VARIANT,
    pub plbValue: ::core::option::Option<super::super::Com::StructuredStorage::ILockBytes>,
    pub pDebugExtProp: ::core::option::Option<IDebugExtendedProperty>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
impl ExtendedDebugPropertyInfo {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
impl ::core::default::Default for ExtendedDebugPropertyInfo {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
impl ::core::cmp::PartialEq for ExtendedDebugPropertyInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
impl ::core::cmp::Eq for ExtendedDebugPropertyInfo {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole"))]
unsafe impl ::windows::core::Abi for ExtendedDebugPropertyInfo {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct FACILITY_CODE(pub u32);
pub const FACILITY_NULL: FACILITY_CODE = FACILITY_CODE(0u32);
pub const FACILITY_RPC: FACILITY_CODE = FACILITY_CODE(1u32);
pub const FACILITY_DISPATCH: FACILITY_CODE = FACILITY_CODE(2u32);
pub const FACILITY_STORAGE: FACILITY_CODE = FACILITY_CODE(3u32);
pub const FACILITY_ITF: FACILITY_CODE = FACILITY_CODE(4u32);
pub const FACILITY_WIN32: FACILITY_CODE = FACILITY_CODE(7u32);
pub const FACILITY_WINDOWS: FACILITY_CODE = FACILITY_CODE(8u32);
pub const FACILITY_SSPI: FACILITY_CODE = FACILITY_CODE(9u32);
pub const FACILITY_SECURITY: FACILITY_CODE = FACILITY_CODE(9u32);
pub const FACILITY_CONTROL: FACILITY_CODE = FACILITY_CODE(10u32);
pub const FACILITY_CERT: FACILITY_CODE = FACILITY_CODE(11u32);
pub const FACILITY_INTERNET: FACILITY_CODE = FACILITY_CODE(12u32);
pub const FACILITY_MEDIASERVER: FACILITY_CODE = FACILITY_CODE(13u32);
pub const FACILITY_MSMQ: FACILITY_CODE = FACILITY_CODE(14u32);
pub const FACILITY_SETUPAPI: FACILITY_CODE = FACILITY_CODE(15u32);
pub const FACILITY_SCARD: FACILITY_CODE = FACILITY_CODE(16u32);
pub const FACILITY_COMPLUS: FACILITY_CODE = FACILITY_CODE(17u32);
pub const FACILITY_AAF: FACILITY_CODE = FACILITY_CODE(18u32);
pub const FACILITY_URT: FACILITY_CODE = FACILITY_CODE(19u32);
pub const FACILITY_ACS: FACILITY_CODE = FACILITY_CODE(20u32);
pub const FACILITY_DPLAY: FACILITY_CODE = FACILITY_CODE(21u32);
pub const FACILITY_UMI: FACILITY_CODE = FACILITY_CODE(22u32);
pub const FACILITY_SXS: FACILITY_CODE = FACILITY_CODE(23u32);
pub const FACILITY_WINDOWS_CE: FACILITY_CODE = FACILITY_CODE(24u32);
pub const FACILITY_HTTP: FACILITY_CODE = FACILITY_CODE(25u32);
pub const FACILITY_USERMODE_COMMONLOG: FACILITY_CODE = FACILITY_CODE(26u32);
pub const FACILITY_WER: FACILITY_CODE = FACILITY_CODE(27u32);
pub const FACILITY_USERMODE_FILTER_MANAGER: FACILITY_CODE = FACILITY_CODE(31u32);
pub const FACILITY_BACKGROUNDCOPY: FACILITY_CODE = FACILITY_CODE(32u32);
pub const FACILITY_CONFIGURATION: FACILITY_CODE = FACILITY_CODE(33u32);
pub const FACILITY_WIA: FACILITY_CODE = FACILITY_CODE(33u32);
pub const FACILITY_STATE_MANAGEMENT: FACILITY_CODE = FACILITY_CODE(34u32);
pub const FACILITY_METADIRECTORY: FACILITY_CODE = FACILITY_CODE(35u32);
pub const FACILITY_WINDOWSUPDATE: FACILITY_CODE = FACILITY_CODE(36u32);
pub const FACILITY_DIRECTORYSERVICE: FACILITY_CODE = FACILITY_CODE(37u32);
pub const FACILITY_GRAPHICS: FACILITY_CODE = FACILITY_CODE(38u32);
pub const FACILITY_SHELL: FACILITY_CODE = FACILITY_CODE(39u32);
pub const FACILITY_NAP: FACILITY_CODE = FACILITY_CODE(39u32);
pub const FACILITY_TPM_SERVICES: FACILITY_CODE = FACILITY_CODE(40u32);
pub const FACILITY_TPM_SOFTWARE: FACILITY_CODE = FACILITY_CODE(41u32);
pub const FACILITY_UI: FACILITY_CODE = FACILITY_CODE(42u32);
pub const FACILITY_XAML: FACILITY_CODE = FACILITY_CODE(43u32);
pub const FACILITY_ACTION_QUEUE: FACILITY_CODE = FACILITY_CODE(44u32);
pub const FACILITY_PLA: FACILITY_CODE = FACILITY_CODE(48u32);
pub const FACILITY_WINDOWS_SETUP: FACILITY_CODE = FACILITY_CODE(48u32);
pub const FACILITY_FVE: FACILITY_CODE = FACILITY_CODE(49u32);
pub const FACILITY_FWP: FACILITY_CODE = FACILITY_CODE(50u32);
pub const FACILITY_WINRM: FACILITY_CODE = FACILITY_CODE(51u32);
pub const FACILITY_NDIS: FACILITY_CODE = FACILITY_CODE(52u32);
pub const FACILITY_USERMODE_HYPERVISOR: FACILITY_CODE = FACILITY_CODE(53u32);
pub const FACILITY_CMI: FACILITY_CODE = FACILITY_CODE(54u32);
pub const FACILITY_USERMODE_VIRTUALIZATION: FACILITY_CODE = FACILITY_CODE(55u32);
pub const FACILITY_USERMODE_VOLMGR: FACILITY_CODE = FACILITY_CODE(56u32);
pub const FACILITY_BCD: FACILITY_CODE = FACILITY_CODE(57u32);
pub const FACILITY_USERMODE_VHD: FACILITY_CODE = FACILITY_CODE(58u32);
pub const FACILITY_USERMODE_HNS: FACILITY_CODE = FACILITY_CODE(59u32);
pub const FACILITY_SDIAG: FACILITY_CODE = FACILITY_CODE(60u32);
pub const FACILITY_WEBSERVICES: FACILITY_CODE = FACILITY_CODE(61u32);
pub const FACILITY_WINPE: FACILITY_CODE = FACILITY_CODE(61u32);
pub const FACILITY_WPN: FACILITY_CODE = FACILITY_CODE(62u32);
pub const FACILITY_WINDOWS_STORE: FACILITY_CODE = FACILITY_CODE(63u32);
pub const FACILITY_INPUT: FACILITY_CODE = FACILITY_CODE(64u32);
pub const FACILITY_QUIC: FACILITY_CODE = FACILITY_CODE(65u32);
pub const FACILITY_EAP: FACILITY_CODE = FACILITY_CODE(66u32);
pub const FACILITY_IORING: FACILITY_CODE = FACILITY_CODE(70u32);
pub const FACILITY_WINDOWS_DEFENDER: FACILITY_CODE = FACILITY_CODE(80u32);
pub const FACILITY_OPC: FACILITY_CODE = FACILITY_CODE(81u32);
pub const FACILITY_XPS: FACILITY_CODE = FACILITY_CODE(82u32);
pub const FACILITY_MBN: FACILITY_CODE = FACILITY_CODE(84u32);
pub const FACILITY_POWERSHELL: FACILITY_CODE = FACILITY_CODE(84u32);
pub const FACILITY_RAS: FACILITY_CODE = FACILITY_CODE(83u32);
pub const FACILITY_P2P_INT: FACILITY_CODE = FACILITY_CODE(98u32);
pub const FACILITY_P2P: FACILITY_CODE = FACILITY_CODE(99u32);
pub const FACILITY_DAF: FACILITY_CODE = FACILITY_CODE(100u32);
pub const FACILITY_BLUETOOTH_ATT: FACILITY_CODE = FACILITY_CODE(101u32);
pub const FACILITY_AUDIO: FACILITY_CODE = FACILITY_CODE(102u32);
pub const FACILITY_STATEREPOSITORY: FACILITY_CODE = FACILITY_CODE(103u32);
pub const FACILITY_VISUALCPP: FACILITY_CODE = FACILITY_CODE(109u32);
pub const FACILITY_SCRIPT: FACILITY_CODE = FACILITY_CODE(112u32);
pub const FACILITY_PARSE: FACILITY_CODE = FACILITY_CODE(113u32);
pub const FACILITY_BLB: FACILITY_CODE = FACILITY_CODE(120u32);
pub const FACILITY_BLB_CLI: FACILITY_CODE = FACILITY_CODE(121u32);
pub const FACILITY_WSBAPP: FACILITY_CODE = FACILITY_CODE(122u32);
pub const FACILITY_BLBUI: FACILITY_CODE = FACILITY_CODE(128u32);
pub const FACILITY_USN: FACILITY_CODE = FACILITY_CODE(129u32);
pub const FACILITY_USERMODE_VOLSNAP: FACILITY_CODE = FACILITY_CODE(130u32);
pub const FACILITY_TIERING: FACILITY_CODE = FACILITY_CODE(131u32);
pub const FACILITY_WSB_ONLINE: FACILITY_CODE = FACILITY_CODE(133u32);
pub const FACILITY_ONLINE_ID: FACILITY_CODE = FACILITY_CODE(134u32);
pub const FACILITY_DEVICE_UPDATE_AGENT: FACILITY_CODE = FACILITY_CODE(135u32);
pub const FACILITY_DRVSERVICING: FACILITY_CODE = FACILITY_CODE(136u32);
pub const FACILITY_DLS: FACILITY_CODE = FACILITY_CODE(153u32);
pub const FACILITY_DELIVERY_OPTIMIZATION: FACILITY_CODE = FACILITY_CODE(208u32);
pub const FACILITY_USERMODE_SPACES: FACILITY_CODE = FACILITY_CODE(231u32);
pub const FACILITY_USER_MODE_SECURITY_CORE: FACILITY_CODE = FACILITY_CODE(232u32);
pub const FACILITY_USERMODE_LICENSING: FACILITY_CODE = FACILITY_CODE(234u32);
pub const FACILITY_SOS: FACILITY_CODE = FACILITY_CODE(160u32);
pub const FACILITY_OCP_UPDATE_AGENT: FACILITY_CODE = FACILITY_CODE(173u32);
pub const FACILITY_DEBUGGERS: FACILITY_CODE = FACILITY_CODE(176u32);
pub const FACILITY_SPP: FACILITY_CODE = FACILITY_CODE(256u32);
pub const FACILITY_RESTORE: FACILITY_CODE = FACILITY_CODE(256u32);
pub const FACILITY_DMSERVER: FACILITY_CODE = FACILITY_CODE(256u32);
pub const FACILITY_DEPLOYMENT_SERVICES_SERVER: FACILITY_CODE = FACILITY_CODE(257u32);
pub const FACILITY_DEPLOYMENT_SERVICES_IMAGING: FACILITY_CODE = FACILITY_CODE(258u32);
pub const FACILITY_DEPLOYMENT_SERVICES_MANAGEMENT: FACILITY_CODE = FACILITY_CODE(259u32);
pub const FACILITY_DEPLOYMENT_SERVICES_UTIL: FACILITY_CODE = FACILITY_CODE(260u32);
pub const FACILITY_DEPLOYMENT_SERVICES_BINLSVC: FACILITY_CODE = FACILITY_CODE(261u32);
pub const FACILITY_DEPLOYMENT_SERVICES_PXE: FACILITY_CODE = FACILITY_CODE(263u32);
pub const FACILITY_DEPLOYMENT_SERVICES_TFTP: FACILITY_CODE = FACILITY_CODE(264u32);
pub const FACILITY_DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT: FACILITY_CODE = FACILITY_CODE(272u32);
pub const FACILITY_DEPLOYMENT_SERVICES_DRIVER_PROVISIONING: FACILITY_CODE = FACILITY_CODE(278u32);
pub const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_SERVER: FACILITY_CODE = FACILITY_CODE(289u32);
pub const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_CLIENT: FACILITY_CODE = FACILITY_CODE(290u32);
pub const FACILITY_DEPLOYMENT_SERVICES_CONTENT_PROVIDER: FACILITY_CODE = FACILITY_CODE(293u32);
pub const FACILITY_HSP_SERVICES: FACILITY_CODE = FACILITY_CODE(296u32);
pub const FACILITY_HSP_SOFTWARE: FACILITY_CODE = FACILITY_CODE(297u32);
pub const FACILITY_LINGUISTIC_SERVICES: FACILITY_CODE = FACILITY_CODE(305u32);
pub const FACILITY_AUDIOSTREAMING: FACILITY_CODE = FACILITY_CODE(1094u32);
pub const FACILITY_TTD: FACILITY_CODE = FACILITY_CODE(1490u32);
pub const FACILITY_ACCELERATOR: FACILITY_CODE = FACILITY_CODE(1536u32);
pub const FACILITY_WMAAECMA: FACILITY_CODE = FACILITY_CODE(1996u32);
pub const FACILITY_DIRECTMUSIC: FACILITY_CODE = FACILITY_CODE(2168u32);
pub const FACILITY_DIRECT3D10: FACILITY_CODE = FACILITY_CODE(2169u32);
pub const FACILITY_DXGI: FACILITY_CODE = FACILITY_CODE(2170u32);
pub const FACILITY_DXGI_DDI: FACILITY_CODE = FACILITY_CODE(2171u32);
pub const FACILITY_DIRECT3D11: FACILITY_CODE = FACILITY_CODE(2172u32);
pub const FACILITY_DIRECT3D11_DEBUG: FACILITY_CODE = FACILITY_CODE(2173u32);
pub const FACILITY_DIRECT3D12: FACILITY_CODE = FACILITY_CODE(2174u32);
pub const FACILITY_DIRECT3D12_DEBUG: FACILITY_CODE = FACILITY_CODE(2175u32);
pub const FACILITY_DXCORE: FACILITY_CODE = FACILITY_CODE(2176u32);
pub const FACILITY_PRESENTATION: FACILITY_CODE = FACILITY_CODE(2177u32);
pub const FACILITY_LEAP: FACILITY_CODE = FACILITY_CODE(2184u32);
pub const FACILITY_AUDCLNT: FACILITY_CODE = FACILITY_CODE(2185u32);
pub const FACILITY_WINCODEC_DWRITE_DWM: FACILITY_CODE = FACILITY_CODE(2200u32);
pub const FACILITY_WINML: FACILITY_CODE = FACILITY_CODE(2192u32);
pub const FACILITY_DIRECT2D: FACILITY_CODE = FACILITY_CODE(2201u32);
pub const FACILITY_DEFRAG: FACILITY_CODE = FACILITY_CODE(2304u32);
pub const FACILITY_USERMODE_SDBUS: FACILITY_CODE = FACILITY_CODE(2305u32);
pub const FACILITY_JSCRIPT: FACILITY_CODE = FACILITY_CODE(2306u32);
pub const FACILITY_PIDGENX: FACILITY_CODE = FACILITY_CODE(2561u32);
pub const FACILITY_EAS: FACILITY_CODE = FACILITY_CODE(85u32);
pub const FACILITY_WEB: FACILITY_CODE = FACILITY_CODE(885u32);
pub const FACILITY_WEB_SOCKET: FACILITY_CODE = FACILITY_CODE(886u32);
pub const FACILITY_MOBILE: FACILITY_CODE = FACILITY_CODE(1793u32);
pub const FACILITY_SQLITE: FACILITY_CODE = FACILITY_CODE(1967u32);
pub const FACILITY_SERVICE_FABRIC: FACILITY_CODE = FACILITY_CODE(1968u32);
pub const FACILITY_UTC: FACILITY_CODE = FACILITY_CODE(1989u32);
pub const FACILITY_WEP: FACILITY_CODE = FACILITY_CODE(2049u32);
pub const FACILITY_SYNCENGINE: FACILITY_CODE = FACILITY_CODE(2050u32);
pub const FACILITY_XBOX: FACILITY_CODE = FACILITY_CODE(2339u32);
pub const FACILITY_GAME: FACILITY_CODE = FACILITY_CODE(2340u32);
pub const FACILITY_PIX: FACILITY_CODE = FACILITY_CODE(2748u32);
pub const FACILITY_NT_BIT: FACILITY_CODE = FACILITY_CODE(268435456u32);
impl ::core::convert::From<u32> for FACILITY_CODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for FACILITY_CODE {
    type Abi = Self;
}
impl ::core::ops::BitOr for FACILITY_CODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for FACILITY_CODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for FACILITY_CODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for FACILITY_CODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for FACILITY_CODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const FACILITY_JsDEBUG: u32 = 3527u32;
pub const FIELDS_DID_NOT_MATCH: u32 = 4u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct FIELD_INFO {
    pub fName: *mut u8,
    pub printName: *mut u8,
    pub size: u32,
    pub fOptions: u32,
    pub address: u64,
    pub Anonymous: FIELD_INFO_0,
    pub TypeId: u32,
    pub FieldOffset: u32,
    pub BufferSize: u32,
    pub BitField: FIELD_INFO_1,
    pub _bitfield: u32,
}
impl FIELD_INFO {}
impl ::core::default::Default for FIELD_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for FIELD_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for FIELD_INFO {}
unsafe impl ::windows::core::Abi for FIELD_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub union FIELD_INFO_0 {
    pub fieldCallBack: *mut ::core::ffi::c_void,
    pub pBuffer: *mut ::core::ffi::c_void,
}
impl FIELD_INFO_0 {}
impl ::core::default::Default for FIELD_INFO_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::cmp::PartialEq for FIELD_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::core::cmp::Eq for FIELD_INFO_0 {}
unsafe impl ::windows::core::Abi for FIELD_INFO_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct FIELD_INFO_1 {
    pub Position: u16,
    pub Size: u16,
}
impl FIELD_INFO_1 {}
impl ::core::default::Default for FIELD_INFO_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for FIELD_INFO_1 {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("_BitField").field("Position", &self.Position).field("Size", &self.Size).finish()
    }
}
impl ::core::cmp::PartialEq for FIELD_INFO_1 {
    fn eq(&self, other: &Self) -> bool {
        self.Position == other.Position && self.Size == other.Size
    }
}
impl ::core::cmp::Eq for FIELD_INFO_1 {}
unsafe impl ::windows::core::Abi for FIELD_INFO_1 {
    type Abi = Self;
}
pub const FLAG_ENGINE_PRESENT: u32 = 4u32;
pub const FLAG_ENGOPT_DISALLOW_NETWORK_PATHS: u32 = 8u32;
pub const FLAG_OVERRIDE_ARM_MACHINE_TYPE: u32 = 16u32;
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct FORMAT_MESSAGE_OPTIONS(pub u32);
pub const FORMAT_MESSAGE_ALLOCATE_BUFFER: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(256u32);
pub const FORMAT_MESSAGE_ARGUMENT_ARRAY: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(8192u32);
pub const FORMAT_MESSAGE_FROM_HMODULE: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(2048u32);
pub const FORMAT_MESSAGE_FROM_STRING: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(1024u32);
pub const FORMAT_MESSAGE_FROM_SYSTEM: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(4096u32);
pub const FORMAT_MESSAGE_IGNORE_INSERTS: FORMAT_MESSAGE_OPTIONS = FORMAT_MESSAGE_OPTIONS(512u32);
impl ::core::convert::From<u32> for FORMAT_MESSAGE_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for FORMAT_MESSAGE_OPTIONS {
    type Abi = Self;
}
impl ::core::ops::BitOr for FORMAT_MESSAGE_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::core::ops::BitAnd for FORMAT_MESSAGE_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::core::ops::BitOrAssign for FORMAT_MESSAGE_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::core::ops::BitAndAssign for FORMAT_MESSAGE_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::core::ops::Not for FORMAT_MESSAGE_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct FPO_DATA {
    pub ulOffStart: u32,
    pub cbProcSize: u32,
    pub cdwLocals: u32,
    pub cdwParams: u16,
    pub _bitfield: u16,
}
impl FPO_DATA {}
impl ::core::default::Default for FPO_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for FPO_DATA {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("FPO_DATA").field("ulOffStart", &self.ulOffStart).field("cbProcSize", &self.cbProcSize).field("cdwLocals", &self.cdwLocals).field("cdwParams", &self.cdwParams).field("_bitfield", &self._bitfield).finish()
    }
}
impl ::core::cmp::PartialEq for FPO_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.ulOffStart == other.ulOffStart && self.cbProcSize == other.cbProcSize && self.cdwLocals == other.cdwLocals && self.cdwParams == other.cdwParams && self._bitfield == other._bitfield
    }
}
impl ::core::cmp::Eq for FPO_DATA {}
unsafe impl ::windows::core::Abi for FPO_DATA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FatalAppExitA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(uaction: u32, lpmessagetext: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FatalAppExitA(uaction: u32, lpmessagetext: super::super::super::Foundation::PSTR);
        }
        ::core::mem::transmute(FatalAppExitA(::core::mem::transmute(uaction), lpmessagetext.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FatalAppExitW<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(uaction: u32, lpmessagetext: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FatalAppExitW(uaction: u32, lpmessagetext: super::super::super::Foundation::PWSTR);
        }
        ::core::mem::transmute(FatalAppExitW(::core::mem::transmute(uaction), lpmessagetext.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn FatalExit(exitcode: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FatalExit(exitcode: i32);
        }
        ::core::mem::transmute(FatalExit(::core::mem::transmute(exitcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(filename: Param0, symbolpath: Param1, debugfilepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindDebugInfoFile(filename: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR, debugfilepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindDebugInfoFile(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFileEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(filename: Param0, symbolpath: Param1, debugfilepath: super::super::super::Foundation::PSTR, callback: ::core::option::Option<PFIND_DEBUG_FILE_CALLBACK>, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindDebugInfoFileEx(filename: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR, debugfilepath: super::super::super::Foundation::PSTR, callback: ::windows::core::RawPtr, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindDebugInfoFileEx(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), ::core::mem::transmute(callback), ::core::mem::transmute(callerdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFileExW<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(filename: Param0, symbolpath: Param1, debugfilepath: super::super::super::Foundation::PWSTR, callback: ::core::option::Option<PFIND_DEBUG_FILE_CALLBACKW>, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindDebugInfoFileExW(filename: super::super::super::Foundation::PWSTR, symbolpath: super::super::super::Foundation::PWSTR, debugfilepath: super::super::super::Foundation::PWSTR, callback: ::windows::core::RawPtr, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindDebugInfoFileExW(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), ::core::mem::transmute(callback), ::core::mem::transmute(callerdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImage<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(filename: Param0, symbolpath: Param1, imagefilepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindExecutableImage(filename: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR, imagefilepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindExecutableImage(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImageEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(filename: Param0, symbolpath: Param1, imagefilepath: super::super::super::Foundation::PSTR, callback: ::core::option::Option<PFIND_EXE_FILE_CALLBACK>, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindExecutableImageEx(filename: super::super::super::Foundation::PSTR, symbolpath: super::super::super::Foundation::PSTR, imagefilepath: super::super::super::Foundation::PSTR, callback: ::windows::core::RawPtr, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindExecutableImageEx(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath), ::core::mem::transmute(callback), ::core::mem::transmute(callerdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImageExW<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(filename: Param0, symbolpath: Param1, imagefilepath: super::super::super::Foundation::PWSTR, callback: ::core::option::Option<PFIND_EXE_FILE_CALLBACKW>, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindExecutableImageExW(filename: super::super::super::Foundation::PWSTR, symbolpath: super::super::super::Foundation::PWSTR, imagefilepath: super::super::super::Foundation::PWSTR, callback: ::windows::core::RawPtr, callerdata: *const ::core::ffi::c_void) -> super::super::super::Foundation::HANDLE;
        }
        ::core::mem::transmute(FindExecutableImageExW(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath), ::core::mem::transmute(callback), ::core::mem::transmute(callerdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindFileInPath<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(hprocess: Param0, searchpatha: Param1, filename: Param2, id: *const ::core::ffi::c_void, two: u32, three: u32, flags: u32, filepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindFileInPath(hprocess: super::super::super::Foundation::HANDLE, searchpatha: super::super::super::Foundation::PSTR, filename: super::super::super::Foundation::PSTR, id: *const ::core::ffi::c_void, two: u32, three: u32, flags: u32, filepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(FindFileInPath(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(id), ::core::mem::transmute(two), ::core::mem::transmute(three), ::core::mem::transmute(flags), ::core::mem::transmute(filepath)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindFileInSearchPath<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(hprocess: Param0, searchpatha: Param1, filename: Param2, one: u32, two: u32, three: u32, filepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindFileInSearchPath(hprocess: super::super::super::Foundation::HANDLE, searchpatha: super::super::super::Foundation::PSTR, filename: super::super::super::Foundation::PSTR, one: u32, two: u32, three: u32, filepath: super::super::super::Foundation::PSTR) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(FindFileInSearchPath(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(one), ::core::mem::transmute(two), ::core::mem::transmute(three), ::core::mem::transmute(filepath)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FlushInstructionCache<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hprocess: Param0, lpbaseaddress: *const ::core::ffi::c_void, dwsize: usize) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FlushInstructionCache(hprocess: super::super::super::Foundation::HANDLE, lpbaseaddress: *const ::core::ffi::c_void, dwsize: usize) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(FlushInstructionCache(hprocess.into_param().abi(), ::core::mem::transmute(lpbaseaddress), ::core::mem::transmute(dwsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FormatMessageA(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: *const ::core::ffi::c_void, dwmessageid: u32, dwlanguageid: u32, lpbuffer: super::super::super::Foundation::PSTR, nsize: u32, arguments: *const *const i8) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FormatMessageA(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: *const ::core::ffi::c_void, dwmessageid: u32, dwlanguageid: u32, lpbuffer: super::super::super::Foundation::PSTR, nsize: u32, arguments: *const *const i8) -> u32;
        }
        ::core::mem::transmute(FormatMessageA(::core::mem::transmute(dwflags), ::core::mem::transmute(lpsource), ::core::mem::transmute(dwmessageid), ::core::mem::transmute(dwlanguageid), ::core::mem::transmute(lpbuffer), ::core::mem::transmute(nsize), ::core::mem::transmute(arguments)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FormatMessageW(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: *const ::core::ffi::c_void, dwmessageid: u32, dwlanguageid: u32, lpbuffer: super::super::super::Foundation::PWSTR, nsize: u32, arguments: *const *const i8) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FormatMessageW(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: *const ::core::ffi::c_void, dwmessageid: u32, dwlanguageid: u32, lpbuffer: super::super::super::Foundation::PWSTR, nsize: u32, arguments: *const *const i8) -> u32;
        }
        ::core::mem::transmute(FormatMessageW(::core::mem::transmute(dwflags), ::core::mem::transmute(lpsource), ::core::mem::transmute(dwmessageid), ::core::mem::transmute(dwlanguageid), ::core::mem::transmute(lpbuffer), ::core::mem::transmute(nsize), ::core::mem::transmute(arguments)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const GETATTRFLAG_HUMANTEXT: u32 = 32768u32;
pub const GETATTRFLAG_THIS: u32 = 256u32;
pub const GETATTRTYPE_DEPSCAN: u32 = 1u32;
pub const GETATTRTYPE_NORMAL: u32 = 0u32;
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct GET_CONTEXT_EX {
    pub Status: u32,
    pub ContextSize: u32,
    pub pContext: *mut ::core::ffi::c_void,
}
impl GET_CONTEXT_EX {}
impl ::core::default::Default for GET_CONTEXT_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for GET_CONTEXT_EX {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_CONTEXT_EX").field("Status", &self.Status).field("ContextSize", &self.ContextSize).field("pContext", &self.pContext).finish()
    }
}
impl ::core::cmp::PartialEq for GET_CONTEXT_EX {
    fn eq(&self, other: &Self) -> bool {
        self.Status == other.Status && self.ContextSize == other.ContextSize && self.pContext == other.pContext
    }
}
impl ::core::cmp::Eq for GET_CONTEXT_EX {}
unsafe impl ::windows::core::Abi for GET_CONTEXT_EX {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct GET_CURRENT_PROCESS_ADDRESS {
    pub Processor: u32,
    pub CurrentThread: u64,
    pub Address: u64,
}
impl GET_CURRENT_PROCESS_ADDRESS {}
impl ::core::default::Default for GET_CURRENT_PROCESS_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for GET_CURRENT_PROCESS_ADDRESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_CURRENT_PROCESS_ADDRESS").field("Processor", &self.Processor).field("CurrentThread", &self.CurrentThread).field("Address", &self.Address).finish()
    }
}
impl ::core::cmp::PartialEq for GET_CURRENT_PROCESS_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.Processor == other.Processor && self.CurrentThread == other.CurrentThread && self.Address == other.Address
    }
}
impl ::core::cmp::Eq for GET_CURRENT_PROCESS_ADDRESS {}
unsafe impl ::windows::core::Abi for GET_CURRENT_PROCESS_ADDRESS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct GET_CURRENT_THREAD_ADDRESS {
    pub Processor: u32,
    pub Address: u64,
}
impl GET_CURRENT_THREAD_ADDRESS {}
impl ::core::default::Default for GET_CURRENT_THREAD_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for GET_CURRENT_THREAD_ADDRESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_CURRENT_THREAD_ADDRESS").field("Processor", &self.Processor).field("Address", &self.Address).finish()
    }
}
impl ::core::cmp::PartialEq for GET_CURRENT_THREAD_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.Processor == other.Processor && self.Address == other.Address
    }
}
impl ::core::cmp::Eq for GET_CURRENT_THREAD_ADDRESS {}
unsafe impl ::windows::core::Abi for GET_CURRENT_THREAD_ADDRESS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct GET_EXPRESSION_EX {
    pub Expression: super::super::super::Foundation::PSTR,
    pub Remainder: super::super::super::Foundation::PSTR,
    pub Value: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl GET_EXPRESSION_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for GET_EXPRESSION_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for GET_EXPRESSION_EX {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_EXPRESSION_EX").field("Expression", &self.Expression).field("Remainder", &self.Remainder).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for GET_EXPRESSION_EX {
    fn eq(&self, other: &Self) -> bool {
        self.Expression == other.Expression && self.Remainder == other.Remainder && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for GET_EXPRESSION_EX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for GET_EXPRESSION_EX {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct GET_INPUT_LINE {
    pub Prompt: super::super::super::Foundation::PSTR,
    pub Buffer: super::super::super::Foundation::PSTR,
    pub BufferSize: u32,
    pub InputSize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl GET_INPUT_LINE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for GET_INPUT_LINE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for GET_INPUT_LINE {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_INPUT_LINE").field("Prompt", &self.Prompt).field("Buffer", &self.Buffer).field("BufferSize", &self.BufferSize).field("InputSize", &self.InputSize).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for GET_INPUT_LINE {
    fn eq(&self, other: &Self) -> bool {
        self.Prompt == other.Prompt && self.Buffer == other.Buffer && self.BufferSize == other.BufferSize && self.InputSize == other.InputSize
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for GET_INPUT_LINE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for GET_INPUT_LINE {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct GET_PEB_ADDRESS {
    pub CurrentThread: u64,
    pub Address: u64,
}
impl GET_PEB_ADDRESS {}
impl ::core::default::Default for GET_PEB_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for GET_PEB_ADDRESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_PEB_ADDRESS").field("CurrentThread", &self.CurrentThread).field("Address", &self.Address).finish()
    }
}
impl ::core::cmp::PartialEq for GET_PEB_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.CurrentThread == other.CurrentThread && self.Address == other.Address
    }
}
impl ::core::cmp::Eq for GET_PEB_ADDRESS {}
unsafe impl ::windows::core::Abi for GET_PEB_ADDRESS {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct GET_SET_SYMPATH {
    pub Args: super::super::super::Foundation::PSTR,
    pub Result: super::super::super::Foundation::PSTR,
    pub Length: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl GET_SET_SYMPATH {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for GET_SET_SYMPATH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for GET_SET_SYMPATH {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_SET_SYMPATH").field("Args", &self.Args).field("Result", &self.Result).field("Length", &self.Length).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for GET_SET_SYMPATH {
    fn eq(&self, other: &Self) -> bool {
        self.Args == other.Args && self.Result == other.Result && self.Length == other.Length
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for GET_SET_SYMPATH {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for GET_SET_SYMPATH {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
pub struct GET_TEB_ADDRESS {
    pub Address: u64,
}
impl GET_TEB_ADDRESS {}
impl ::core::default::Default for GET_TEB_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for GET_TEB_ADDRESS {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("GET_TEB_ADDRESS").field("Address", &self.Address).finish()
    }
}
impl ::core::cmp::PartialEq for GET_TEB_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.Address == other.Address
    }
}
impl ::core::cmp::Eq for GET_TEB_ADDRESS {}
unsafe impl ::windows::core::Abi for GET_TEB_ADDRESS {
    type Abi = Self;
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
#[inline]
pub unsafe fn GetEnabledXStateFeatures() -> u64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetEnabledXStateFeatures() -> u64;
        }
        ::core::mem::transmute(GetEnabledXStateFeatures())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn GetErrorMode() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetErrorMode() -> u32;
        }
        ::core::mem::transmute(GetErrorMode())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY64) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY64) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetImageConfigInformation(::core::mem::transmute(loadedimage), ::core::mem::transmute(imageconfiginformation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetImageConfigInformation(::core::mem::transmute(loadedimage), ::core::mem::transmute(imageconfiginformation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetImageUnusedHeaderBytes(loadedimage: *const LOADED_IMAGE, sizeunusedheaderbytes: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetImageUnusedHeaderBytes(loadedimage: *const LOADED_IMAGE, sizeunusedheaderbytes: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetImageUnusedHeaderBytes(::core::mem::transmute(loadedimage), ::core::mem::transmute(sizeunusedheaderbytes)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn GetSymLoadError() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSymLoadError() -> u32;
        }
        ::core::mem::transmute(GetSymLoadError())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetThreadContext<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hthread: Param0, lpcontext: *mut CONTEXT) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadContext(hthread: super::super::super::Foundation::HANDLE, lpcontext: *mut CONTEXT) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetThreadContext(hthread.into_param().abi(), ::core::mem::transmute(lpcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn GetThreadErrorMode() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadErrorMode() -> u32;
        }
        ::core::mem::transmute(GetThreadErrorMode())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadSelectorEntry<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HANDLE>>(hthread: Param0, dwselector: u32, lpselectorentry: *mut LDT_ENTRY) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadSelectorEntry(hthread: super::super::super::Foundation::HANDLE, dwselector: u32, lpselectorentry: *mut LDT_ENTRY) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetThreadSelectorEntry(hthread.into_param().abi(), ::core::mem::transmute(dwselector), ::core::mem::transmute(lpselectorentry)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadWaitChain(wcthandle: *const ::core::ffi::c_void, context: usize, flags: WAIT_CHAIN_THREAD_OPTIONS, threadid: u32, nodecount: *mut u32, nodeinfoarray: *mut WAITCHAIN_NODE_INFO, iscycle: *mut i32) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadWaitChain(wcthandle: *const ::core::ffi::c_void, context: usize, flags: WAIT_CHAIN_THREAD_OPTIONS, threadid: u32, nodecount: *mut u32, nodeinfoarray: *mut WAITCHAIN_NODE_INFO, iscycle: *mut i32) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetThreadWaitChain(::core::mem::transmute(wcthandle), ::core::mem::transmute(context), ::core::mem::transmute(flags), ::core::mem::transmute(threadid), ::core::mem::transmute(nodecount), ::core::mem::transmute(nodeinfoarray), ::core::mem::transmute(iscycle)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimestampForLoadedLibrary<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::HINSTANCE>>(module: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimestampForLoadedLibrary(module: super::super::super::Foundation::HINSTANCE) -> u32;
        }
        ::core::mem::transmute(GetTimestampForLoadedLibrary(module.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetXStateFeaturesMask(context: *const CONTEXT, featuremask: *mut u64) -> super::super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetXStateFeaturesMask(context: *const CONTEXT, featuremask: *mut u64) -> super::super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetXStateFeaturesMask(::core::mem::transmute(context), ::core::mem::transmute(featuremask)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScript(pub ::windows::core::IUnknown);
impl IActiveScript {
    pub unsafe fn SetScriptSite<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptSite>>(&self, pass: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pass.into_param().abi()).ok()
    }
    pub unsafe fn GetScriptSite<T: ::windows::core::Interface>(&self) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn SetScriptState(&self, ss: SCRIPTSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(ss)).ok()
    }
    pub unsafe fn GetScriptState(&self) -> ::windows::core::Result<SCRIPTSTATE> {
        let mut result__: <SCRIPTSTATE as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<SCRIPTSTATE>(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddNamedItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrname: Param0, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pstrname.into_param().abi(), ::core::mem::transmute(dwflags)).ok()
    }
    pub unsafe fn AddTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(rguidtypelib), ::core::mem::transmute(dwmajor), ::core::mem::transmute(dwminor), ::core::mem::transmute(dwflags)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetScriptDispatch<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstritemname: Param0) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pstritemname.into_param().abi(), &mut result__).from_abi::<super::super::Com::IDispatch>(result__)
    }
    pub unsafe fn GetCurrentScriptThreadID(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetScriptThreadID(&self, dwwin32threadid: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwwin32threadid), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetScriptThreadState(&self, stidthread: u32) -> ::windows::core::Result<SCRIPTTHREADSTATE> {
        let mut result__: <SCRIPTTHREADSTATE as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(stidthread), &mut result__).from_abi::<SCRIPTTHREADSTATE>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn InterruptScriptThread(&self, stidthread: u32, pexcepinfo: *const super::super::Com::EXCEPINFO, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(stidthread), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(dwflags)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IActiveScript> {
        let mut result__: <IActiveScript as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IActiveScript>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScript {
    type Vtable = IActiveScript_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae1_a4f9_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScript> for ::windows::core::IUnknown {
    fn from(value: IActiveScript) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScript> for ::windows::core::IUnknown {
    fn from(value: &IActiveScript) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScript {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScript {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScript_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pass: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, ppvobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ss: SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pssstate: *mut SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrname: super::super::super::Foundation::PWSTR, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstritemname: super::super::super::Foundation::PWSTR, ppdisp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstidthread: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwwin32threadid: u32, pstidthread: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stidthread: u32, pstsstate: *mut SCRIPTTHREADSTATE) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stidthread: u32, pexcepinfo: *const ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppscript: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptAuthor(pub ::windows::core::IUnknown);
impl IActiveScriptAuthor {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn AddNamedItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Com::IDispatch>>(&self, pszname: Param0, dwflags: u32, pdisp: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszname.into_param().abi(), ::core::mem::transmute(dwflags), pdisp.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddScriptlet<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pszdefaultname: Param0,
        pszcode: Param1,
        pszitemname: Param2,
        pszsubitemname: Param3,
        pszeventname: Param4,
        pszdelimiter: Param5,
        dwcookie: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pszdefaultname.into_param().abi(), pszcode.into_param().abi(), pszitemname.into_param().abi(), pszsubitemname.into_param().abi(), pszeventname.into_param().abi(), pszdelimiter.into_param().abi(), ::core::mem::transmute(dwcookie), ::core::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ParseScriptText<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pszcode: Param0, pszitemname: Param1, pszdelimiter: Param2, dwcookie: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pszcode.into_param().abi(), pszitemname.into_param().abi(), pszdelimiter.into_param().abi(), ::core::mem::transmute(dwcookie), ::core::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pszcode: Param0, cch: u32, pszdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pszcode.into_param().abi(), ::core::mem::transmute(cch), pszdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptletTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pszcode: Param0, cch: u32, pszdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pszcode.into_param().abi(), ::core::mem::transmute(cch), pszdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    pub unsafe fn GetRoot(&self) -> ::windows::core::Result<IScriptNode> {
        let mut result__: <IScriptNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IScriptNode>(result__)
    }
    pub unsafe fn GetLanguageFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetEventHandler<'a, Param0: ::windows::core::IntoParam<'a, super::super::Com::IDispatch>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pdisp: Param0, pszitem: Param1, pszsubitem: Param2, pszevent: Param3) -> ::windows::core::Result<IScriptEntry> {
        let mut result__: <IScriptEntry as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pdisp.into_param().abi(), pszitem.into_param().abi(), pszsubitem.into_param().abi(), pszevent.into_param().abi(), &mut result__).from_abi::<IScriptEntry>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveNamedItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), pszname.into_param().abi()).ok()
    }
    pub unsafe fn AddTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(rguidtypelib), ::core::mem::transmute(dwmajor), ::core::mem::transmute(dwminor), ::core::mem::transmute(dwflags)).ok()
    }
    pub unsafe fn RemoveTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(rguidtypelib), ::core::mem::transmute(dwmajor), ::core::mem::transmute(dwminor)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetChars(&self, frequestedlist: u32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(frequestedlist), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInfoFromContext<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pszcode: Param0, cchcode: u32, ichcurrentposition: u32, dwlisttypesrequested: u32, pdwlisttypesprovided: *mut u32, pichlistanchorposition: *mut u32, pichfuncanchorposition: *mut u32, pmemid: *mut i32, picurrentparameter: *mut i32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            pszcode.into_param().abi(),
            ::core::mem::transmute(cchcode),
            ::core::mem::transmute(ichcurrentposition),
            ::core::mem::transmute(dwlisttypesrequested),
            ::core::mem::transmute(pdwlisttypesprovided),
            ::core::mem::transmute(pichlistanchorposition),
            ::core::mem::transmute(pichfuncanchorposition),
            ::core::mem::transmute(pmemid),
            ::core::mem::transmute(picurrentparameter),
            ::core::mem::transmute(ppunk),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsCommitChar(&self, ch: u16) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(ch), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptAuthor {
    type Vtable = IActiveScriptAuthor_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9c109da0_7006_11d1_b36c_00a0c911e8b2);
}
impl ::core::convert::From<IActiveScriptAuthor> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptAuthor) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptAuthor> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptAuthor) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptAuthor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptAuthor {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptAuthor_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszname: super::super::super::Foundation::PWSTR, dwflags: u32, pdisp: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszdefaultname: super::super::super::Foundation::PWSTR, pszcode: super::super::super::Foundation::PWSTR, pszitemname: super::super::super::Foundation::PWSTR, pszsubitemname: super::super::super::Foundation::PWSTR, pszeventname: super::super::super::Foundation::PWSTR, pszdelimiter: super::super::super::Foundation::PWSTR, dwcookie: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszcode: super::super::super::Foundation::PWSTR, pszitemname: super::super::super::Foundation::PWSTR, pszdelimiter: super::super::super::Foundation::PWSTR, dwcookie: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszcode: super::super::super::Foundation::PWSTR, cch: u32, pszdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszcode: super::super::super::Foundation::PWSTR, cch: u32, pszdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppsp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pgrfasa: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdisp: ::windows::core::RawPtr, pszitem: super::super::super::Foundation::PWSTR, pszsubitem: super::super::super::Foundation::PWSTR, pszevent: super::super::super::Foundation::PWSTR, ppse: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, frequestedlist: u32, pbstrchars: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszcode: super::super::super::Foundation::PWSTR, cchcode: u32, ichcurrentposition: u32, dwlisttypesrequested: u32, pdwlisttypesprovided: *mut u32, pichlistanchorposition: *mut u32, pichfuncanchorposition: *mut u32, pmemid: *mut i32, picurrentparameter: *mut i32, ppunk: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ch: u16, pfcommit: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptAuthorProcedure(pub ::windows::core::IUnknown);
impl IActiveScriptAuthorProcedure {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param7: ::windows::core::IntoParam<'a, super::super::Com::IDispatch>,
    >(
        &self,
        pszcode: Param0,
        pszformalparams: Param1,
        pszprocedurename: Param2,
        pszitemname: Param3,
        pszdelimiter: Param4,
        dwcookie: u32,
        dwflags: u32,
        pdispfor: Param7,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pszcode.into_param().abi(), pszformalparams.into_param().abi(), pszprocedurename.into_param().abi(), pszitemname.into_param().abi(), pszdelimiter.into_param().abi(), ::core::mem::transmute(dwcookie), ::core::mem::transmute(dwflags), pdispfor.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptAuthorProcedure {
    type Vtable = IActiveScriptAuthorProcedure_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e2d4b70_bd9a_11d0_9336_00a0c90dcaa9);
}
impl ::core::convert::From<IActiveScriptAuthorProcedure> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptAuthorProcedure) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptAuthorProcedure> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptAuthorProcedure) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptAuthorProcedure {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptAuthorProcedure {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptAuthorProcedure_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pszcode: super::super::super::Foundation::PWSTR, pszformalparams: super::super::super::Foundation::PWSTR, pszprocedurename: super::super::super::Foundation::PWSTR, pszitemname: super::super::super::Foundation::PWSTR, pszdelimiter: super::super::super::Foundation::PWSTR, dwcookie: u32, dwflags: u32, pdispfor: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptDebug32(pub ::windows::core::IUnknown);
impl IActiveScriptDebug32 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrcode: Param0, unumcodechars: u32, pstrdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pstrcode.into_param().abi(), ::core::mem::transmute(unumcodechars), pstrdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptletTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrcode: Param0, unumcodechars: u32, pstrdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pstrcode.into_param().abi(), ::core::mem::transmute(unumcodechars), pstrdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    pub unsafe fn EnumCodeContextsOfPosition(&self, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IEnumDebugCodeContexts> {
        let mut result__: <IEnumDebugCodeContexts as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourcecontext), ::core::mem::transmute(ucharacteroffset), ::core::mem::transmute(unumchars), &mut result__).from_abi::<IEnumDebugCodeContexts>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptDebug32 {
    type Vtable = IActiveScriptDebug32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c10_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IActiveScriptDebug32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptDebug32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptDebug32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptDebug32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptDebug32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptDebug32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptDebug32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, unumcodechars: u32, pstrdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, unumcodechars: u32, pstrdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32, ppescc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptDebug64(pub ::windows::core::IUnknown);
impl IActiveScriptDebug64 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrcode: Param0, unumcodechars: u32, pstrdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pstrcode.into_param().abi(), ::core::mem::transmute(unumcodechars), pstrdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetScriptletTextAttributes<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrcode: Param0, unumcodechars: u32, pstrdelimiter: Param2, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pstrcode.into_param().abi(), ::core::mem::transmute(unumcodechars), pstrdelimiter.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pattr)).ok()
    }
    pub unsafe fn EnumCodeContextsOfPosition(&self, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IEnumDebugCodeContexts> {
        let mut result__: <IEnumDebugCodeContexts as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourcecontext), ::core::mem::transmute(ucharacteroffset), ::core::mem::transmute(unumchars), &mut result__).from_abi::<IEnumDebugCodeContexts>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptDebug64 {
    type Vtable = IActiveScriptDebug64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbc437e23_f5b8_47f4_bb79_7d1ce5483b86);
}
impl ::core::convert::From<IActiveScriptDebug64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptDebug64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptDebug64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptDebug64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptDebug64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptDebug64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptDebug64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, unumcodechars: u32, pstrdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, unumcodechars: u32, pstrdelimiter: super::super::super::Foundation::PWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32, ppescc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptEncode(pub ::windows::core::IUnknown);
impl IActiveScriptEncode {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeSection<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pchin: Param0, cchin: u32, pchout: Param2, cchout: u32, pcchret: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pchin.into_param().abi(), ::core::mem::transmute(cchin), pchout.into_param().abi(), ::core::mem::transmute(cchout), ::core::mem::transmute(pcchret)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeScript<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pchin: Param0, cchin: u32, pchout: Param2, cchout: u32, pcchret: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pchin.into_param().abi(), ::core::mem::transmute(cchin), pchout.into_param().abi(), ::core::mem::transmute(cchout), ::core::mem::transmute(pcchret)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEncodeProgId(&self, pbstrout: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrout)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptEncode {
    type Vtable = IActiveScriptEncode_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae3_a4f9_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScriptEncode> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptEncode) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptEncode> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptEncode) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptEncode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptEncode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptEncode_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pchin: super::super::super::Foundation::PWSTR, cchin: u32, pchout: super::super::super::Foundation::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pchin: super::super::super::Foundation::PWSTR, cchin: u32, pchout: super::super::super::Foundation::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrout: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptError(pub ::windows::core::IUnknown);
impl IActiveScriptError {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetExceptionInfo(&self) -> ::windows::core::Result<super::super::Com::EXCEPINFO> {
        let mut result__: <super::super::Com::EXCEPINFO as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Com::EXCEPINFO>(result__)
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwsourcecontext), ::core::mem::transmute(pullinenumber), ::core::mem::transmute(plcharacterposition)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptError {
    type Vtable = IActiveScriptError_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeae1ba61_a4ed_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScriptError> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptError) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptError> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptError) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptError {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptError {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptError_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrsourceline: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptError64(pub ::windows::core::IUnknown);
impl IActiveScriptError64 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetExceptionInfo(&self) -> ::windows::core::Result<super::super::Com::EXCEPINFO> {
        let mut result__: <super::super::Com::EXCEPINFO as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Com::EXCEPINFO>(result__)
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwsourcecontext), ::core::mem::transmute(pullinenumber), ::core::mem::transmute(plcharacterposition)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetSourcePosition64(&self, pdwsourcecontext: *mut u64, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwsourcecontext), ::core::mem::transmute(pullinenumber), ::core::mem::transmute(plcharacterposition)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptError64 {
    type Vtable = IActiveScriptError64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb21fb2a1_5b8f_4963_8c21_21450f84ed7f);
}
impl ::core::convert::From<IActiveScriptError64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptError64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptError64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptError64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptError64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptError64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptError64> for IActiveScriptError {
    fn from(value: IActiveScriptError64) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptError64> for IActiveScriptError {
    fn from(value: &IActiveScriptError64) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for IActiveScriptError64 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for &IActiveScriptError64 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptError64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrsourceline: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwsourcecontext: *mut u64, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptErrorDebug(pub ::windows::core::IUnknown);
impl IActiveScriptErrorDebug {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetExceptionInfo(&self) -> ::windows::core::Result<super::super::Com::EXCEPINFO> {
        let mut result__: <super::super::Com::EXCEPINFO as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Com::EXCEPINFO>(result__)
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwsourcecontext), ::core::mem::transmute(pullinenumber), ::core::mem::transmute(plcharacterposition)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetDocumentContext(&self) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__: <IDebugDocumentContext as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugDocumentContext>(result__)
    }
    pub unsafe fn GetStackFrame(&self) -> ::windows::core::Result<IDebugStackFrame> {
        let mut result__: <IDebugStackFrame as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugStackFrame>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptErrorDebug {
    type Vtable = IActiveScriptErrorDebug_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c12_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IActiveScriptErrorDebug> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptErrorDebug) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptErrorDebug> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptErrorDebug) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptErrorDebug> for IActiveScriptError {
    fn from(value: IActiveScriptErrorDebug) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptErrorDebug> for IActiveScriptError {
    fn from(value: &IActiveScriptErrorDebug) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for IActiveScriptErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for &IActiveScriptErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptErrorDebug_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrsourceline: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppssc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdsf: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptErrorDebug110(pub ::windows::core::IUnknown);
impl IActiveScriptErrorDebug110 {
    pub unsafe fn GetExceptionThrownKind(&self) -> ::windows::core::Result<SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND> {
        let mut result__: <SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptErrorDebug110 {
    type Vtable = IActiveScriptErrorDebug110_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x516e42b6_89a8_4530_937b_5f0708431442);
}
impl ::core::convert::From<IActiveScriptErrorDebug110> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptErrorDebug110) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptErrorDebug110> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptErrorDebug110) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptErrorDebug110 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptErrorDebug110 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptErrorDebug110_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pexceptionkind: *mut SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptGarbageCollector(pub ::windows::core::IUnknown);
impl IActiveScriptGarbageCollector {
    pub unsafe fn CollectGarbage(&self, scriptgctype: SCRIPTGCTYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptgctype)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptGarbageCollector {
    type Vtable = IActiveScriptGarbageCollector_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6aa2c4a0_2b53_11d4_a2a0_00104bd35090);
}
impl ::core::convert::From<IActiveScriptGarbageCollector> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptGarbageCollector) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptGarbageCollector> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptGarbageCollector) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptGarbageCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptGarbageCollector {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptGarbageCollector_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptgctype: SCRIPTGCTYPE) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptHostEncode(pub ::windows::core::IUnknown);
impl IActiveScriptHostEncode {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeScriptHostFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::BSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::BSTR>>(&self, bstrinfile: Param0, pbstroutfile: *mut super::super::super::Foundation::BSTR, cflags: u32, bstrdefaultlang: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), bstrinfile.into_param().abi(), ::core::mem::transmute(pbstroutfile), ::core::mem::transmute(cflags), bstrdefaultlang.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptHostEncode {
    type Vtable = IActiveScriptHostEncode_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbee9b76e_cfe3_11d1_b747_00c04fc2b085);
}
impl ::core::convert::From<IActiveScriptHostEncode> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptHostEncode) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptHostEncode> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptHostEncode) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptHostEncode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptHostEncode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptHostEncode_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, bstrinfile: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pbstroutfile: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, cflags: u32, bstrdefaultlang: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParse32(pub ::windows::core::IUnknown);
impl IActiveScriptParse32 {
    pub unsafe fn InitNew(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn AddScriptlet<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrdefaultname: Param0,
        pstrcode: Param1,
        pstritemname: Param2,
        pstrsubitemname: Param3,
        pstreventname: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pbstrname: *mut super::super::super::Foundation::BSTR,
        pexcepinfo: *mut super::super::Com::EXCEPINFO,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            pstrdefaultname.into_param().abi(),
            pstrcode.into_param().abi(),
            pstritemname.into_param().abi(),
            pstrsubitemname.into_param().abi(),
            pstreventname.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            ::core::mem::transmute(pbstrname),
            ::core::mem::transmute(pexcepinfo),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ParseScriptText<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(
        &self,
        pstrcode: Param0,
        pstritemname: Param1,
        punkcontext: Param2,
        pstrdelimiter: Param3,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pvarresult: *mut super::super::Com::VARIANT,
        pexcepinfo: *mut super::super::Com::EXCEPINFO,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            ::core::mem::transmute(pvarresult),
            ::core::mem::transmute(pexcepinfo),
        )
        .ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParse32 {
    type Vtable = IActiveScriptParse32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae2_a4f9_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScriptParse32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParse32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParse32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParse32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParse32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParse32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParse32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrdefaultname: super::super::super::Foundation::PWSTR,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        pstrsubitemname: super::super::super::Foundation::PWSTR,
        pstreventname: super::super::super::Foundation::PWSTR,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pbstrname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>,
        pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pvarresult: *mut ::core::mem::ManuallyDrop<super::super::Com::VARIANT>,
        pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParse64(pub ::windows::core::IUnknown);
impl IActiveScriptParse64 {
    pub unsafe fn InitNew(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn AddScriptlet<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrdefaultname: Param0,
        pstrcode: Param1,
        pstritemname: Param2,
        pstrsubitemname: Param3,
        pstreventname: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pbstrname: *mut super::super::super::Foundation::BSTR,
        pexcepinfo: *mut super::super::Com::EXCEPINFO,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            pstrdefaultname.into_param().abi(),
            pstrcode.into_param().abi(),
            pstritemname.into_param().abi(),
            pstrsubitemname.into_param().abi(),
            pstreventname.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            ::core::mem::transmute(pbstrname),
            ::core::mem::transmute(pexcepinfo),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ParseScriptText<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(
        &self,
        pstrcode: Param0,
        pstritemname: Param1,
        punkcontext: Param2,
        pstrdelimiter: Param3,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pvarresult: *mut super::super::Com::VARIANT,
        pexcepinfo: *mut super::super::Com::EXCEPINFO,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            ::core::mem::transmute(pvarresult),
            ::core::mem::transmute(pexcepinfo),
        )
        .ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParse64 {
    type Vtable = IActiveScriptParse64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7ef7658_e1ee_480e_97ea_d52cb4d76d17);
}
impl ::core::convert::From<IActiveScriptParse64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParse64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParse64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParse64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParse64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParse64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParse64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrdefaultname: super::super::super::Foundation::PWSTR,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        pstrsubitemname: super::super::super::Foundation::PWSTR,
        pstreventname: super::super::super::Foundation::PWSTR,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pbstrname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>,
        pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        pvarresult: *mut ::core::mem::ManuallyDrop<super::super::Com::VARIANT>,
        pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedure2_32(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedure2_32 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstrprocedurename: Param2,
        pstritemname: Param3,
        punkcontext: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstrprocedurename.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure2_32 {
    type Vtable = IActiveScriptParseProcedure2_32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71ee5b20_fb04_11d1_b3a8_00a0c911e8b2);
}
impl ::core::convert::From<IActiveScriptParseProcedure2_32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedure2_32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure2_32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedure2_32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedure2_32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedure2_32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptParseProcedure2_32> for IActiveScriptParseProcedure32 {
    fn from(value: IActiveScriptParseProcedure2_32) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure2_32> for IActiveScriptParseProcedure32 {
    fn from(value: &IActiveScriptParseProcedure2_32) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptParseProcedure32> for IActiveScriptParseProcedure2_32 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptParseProcedure32> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptParseProcedure32> for &IActiveScriptParseProcedure2_32 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptParseProcedure32> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure2_32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstrformalparams: super::super::super::Foundation::PWSTR,
        pstrprocedurename: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        ppdisp: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedure2_64(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedure2_64 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstrprocedurename: Param2,
        pstritemname: Param3,
        punkcontext: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstrprocedurename.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure2_64 {
    type Vtable = IActiveScriptParseProcedure2_64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe7c4271_210c_448d_9f54_76dab7047b28);
}
impl ::core::convert::From<IActiveScriptParseProcedure2_64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedure2_64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure2_64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedure2_64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedure2_64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedure2_64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptParseProcedure2_64> for IActiveScriptParseProcedure64 {
    fn from(value: IActiveScriptParseProcedure2_64) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure2_64> for IActiveScriptParseProcedure64 {
    fn from(value: &IActiveScriptParseProcedure2_64) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptParseProcedure64> for IActiveScriptParseProcedure2_64 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptParseProcedure64> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptParseProcedure64> for &IActiveScriptParseProcedure2_64 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptParseProcedure64> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure2_64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstrformalparams: super::super::super::Foundation::PWSTR,
        pstrprocedurename: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        ppdisp: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedure32(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedure32 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstrprocedurename: Param2,
        pstritemname: Param3,
        punkcontext: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstrprocedurename.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure32 {
    type Vtable = IActiveScriptParseProcedure32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaa5b6a80_b834_11d0_932f_00a0c90dcaa9);
}
impl ::core::convert::From<IActiveScriptParseProcedure32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedure32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedure32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedure32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedure32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstrformalparams: super::super::super::Foundation::PWSTR,
        pstrprocedurename: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
        ppdisp: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedure64(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedure64 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<
        'a,
        Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
        Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
        Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>,
    >(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstrprocedurename: Param2,
        pstritemname: Param3,
        punkcontext: Param4,
        pstrdelimiter: Param5,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstrprocedurename.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure64 {
    type Vtable = IActiveScriptParseProcedure64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc64713b6_e029_4cc5_9200_438b72890b6a);
}
impl ::core::convert::From<IActiveScriptParseProcedure64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedure64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedure64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedure64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedure64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedure64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::core::RawPtr,
        pstrcode: super::super::super::Foundation::PWSTR,
        pstrformalparams: super::super::super::Foundation::PWSTR,
        pstrprocedurename: super::super::super::Foundation::PWSTR,
        pstritemname: super::super::super::Foundation::PWSTR,
        punkcontext: ::windows::core::RawPtr,
        pstrdelimiter: super::super::super::Foundation::PWSTR,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
        ppdisp: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedureOld32(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedureOld32 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstritemname: Param2,
        punkcontext: Param3,
        pstrdelimiter: Param4,
        dwsourcecontextcookie: u32,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedureOld32 {
    type Vtable = IActiveScriptParseProcedureOld32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1cff0050_6fdd_11d0_9328_00a0c90dcaa9);
}
impl ::core::convert::From<IActiveScriptParseProcedureOld32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedureOld32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedureOld32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedureOld32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedureOld32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedureOld32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedureOld32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, pstrformalparams: super::super::super::Foundation::PWSTR, pstritemname: super::super::super::Foundation::PWSTR, punkcontext: ::windows::core::RawPtr, pstrdelimiter: super::super::super::Foundation::PWSTR, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptParseProcedureOld64(pub ::windows::core::IUnknown);
impl IActiveScriptParseProcedureOld64 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseProcedureText<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(
        &self,
        pstrcode: Param0,
        pstrformalparams: Param1,
        pstritemname: Param2,
        punkcontext: Param3,
        pstrdelimiter: Param4,
        dwsourcecontextcookie: u64,
        ulstartinglinenumber: u32,
        dwflags: u32,
    ) -> ::windows::core::Result<super::super::Com::IDispatch> {
        let mut result__: <super::super::Com::IDispatch as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            pstrcode.into_param().abi(),
            pstrformalparams.into_param().abi(),
            pstritemname.into_param().abi(),
            punkcontext.into_param().abi(),
            pstrdelimiter.into_param().abi(),
            ::core::mem::transmute(dwsourcecontextcookie),
            ::core::mem::transmute(ulstartinglinenumber),
            ::core::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Com::IDispatch>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedureOld64 {
    type Vtable = IActiveScriptParseProcedureOld64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21f57128_08c9_4638_ba12_22d15d88dc5c);
}
impl ::core::convert::From<IActiveScriptParseProcedureOld64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptParseProcedureOld64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptParseProcedureOld64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptParseProcedureOld64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptParseProcedureOld64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptParseProcedureOld64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedureOld64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrcode: super::super::super::Foundation::PWSTR, pstrformalparams: super::super::super::Foundation::PWSTR, pstritemname: super::super::super::Foundation::PWSTR, punkcontext: ::windows::core::RawPtr, pstrdelimiter: super::super::super::Foundation::PWSTR, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerCallback(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerCallback {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrreason)).ok()
    }
    pub unsafe fn ScriptCompiled<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(r#type), pidebugdocumentcontext.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FunctionCompiled<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, functionid: i32, scriptid: i32, pwszfunctionname: Param2, pwszfunctionnamehint: Param3, pidebugdocumentcontext: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(functionid), ::core::mem::transmute(scriptid), pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback {
    type Vtable = IActiveScriptProfilerCallback_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x740eca23_7d9d_42e5_ba9d_f8b24b1c7a9b);
}
impl ::core::convert::From<IActiveScriptProfilerCallback> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerCallback) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerCallback) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, functionid: i32, scriptid: i32, pwszfunctionname: super::super::super::Foundation::PWSTR, pwszfunctionnamehint: super::super::super::Foundation::PWSTR, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerCallback2(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerCallback2 {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrreason)).ok()
    }
    pub unsafe fn ScriptCompiled<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(r#type), pidebugdocumentcontext.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FunctionCompiled<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, functionid: i32, scriptid: i32, pwszfunctionname: Param2, pwszfunctionnamehint: Param3, pidebugdocumentcontext: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(functionid), ::core::mem::transmute(scriptid), pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFunctionEnterByName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwszfunctionname: Param0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pwszfunctionname.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFunctionExitByName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwszfunctionname: Param0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pwszfunctionname.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback2 {
    type Vtable = IActiveScriptProfilerCallback2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x31b7f8ad_a637_409c_b22f_040995b6103d);
}
impl ::core::convert::From<IActiveScriptProfilerCallback2> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerCallback2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback2> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerCallback2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerCallback2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerCallback2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerCallback2> for IActiveScriptProfilerCallback {
    fn from(value: IActiveScriptProfilerCallback2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback2> for IActiveScriptProfilerCallback {
    fn from(value: &IActiveScriptProfilerCallback2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback> for IActiveScriptProfilerCallback2 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback> for &IActiveScriptProfilerCallback2 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, functionid: i32, scriptid: i32, pwszfunctionname: super::super::super::Foundation::PWSTR, pwszfunctionnamehint: super::super::super::Foundation::PWSTR, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pwszfunctionname: super::super::super::Foundation::PWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pwszfunctionname: super::super::super::Foundation::PWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerCallback3(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerCallback3 {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrreason)).ok()
    }
    pub unsafe fn ScriptCompiled<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(r#type), pidebugdocumentcontext.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FunctionCompiled<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, functionid: i32, scriptid: i32, pwszfunctionname: Param2, pwszfunctionnamehint: Param3, pidebugdocumentcontext: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(functionid), ::core::mem::transmute(scriptid), pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(scriptid), ::core::mem::transmute(functionid)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFunctionEnterByName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwszfunctionname: Param0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), pwszfunctionname.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFunctionExitByName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwszfunctionname: Param0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pwszfunctionname.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn SetWebWorkerId(&self, webworkerid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(webworkerid)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback3 {
    type Vtable = IActiveScriptProfilerCallback3_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6ac5ad25_2037_4687_91df_b59979d93d73);
}
impl ::core::convert::From<IActiveScriptProfilerCallback3> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerCallback3) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback3> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerCallback3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerCallback3> for IActiveScriptProfilerCallback2 {
    fn from(value: IActiveScriptProfilerCallback3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback3> for IActiveScriptProfilerCallback2 {
    fn from(value: &IActiveScriptProfilerCallback3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback2> for IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback2> for &IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerCallback3> for IActiveScriptProfilerCallback {
    fn from(value: IActiveScriptProfilerCallback3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerCallback3> for IActiveScriptProfilerCallback {
    fn from(value: &IActiveScriptProfilerCallback3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback> for IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerCallback> for &IActiveScriptProfilerCallback3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerCallback> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback3_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, functionid: i32, scriptid: i32, pwszfunctionname: super::super::super::Foundation::PWSTR, pwszfunctionnamehint: super::super::super::Foundation::PWSTR, pidebugdocumentcontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pwszfunctionname: super::super::super::Foundation::PWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pwszfunctionname: super::super::super::Foundation::PWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, webworkerid: u32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerControl(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerControl {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprofilerobject), ::core::mem::transmute(dweventmask), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dweventmask)).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrshutdownreason)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl {
    type Vtable = IActiveScriptProfilerControl_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x784b5ff0_69b0_47d1_a7dc_2518f4230e90);
}
impl ::core::convert::From<IActiveScriptProfilerControl> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerControl) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dweventmask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerControl2(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerControl2 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprofilerobject), ::core::mem::transmute(dweventmask), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dweventmask)).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrshutdownreason)).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl2 {
    type Vtable = IActiveScriptProfilerControl2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x47810165_498f_40be_94f1_653557e9e7da);
}
impl ::core::convert::From<IActiveScriptProfilerControl2> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerControl2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl2> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerControl2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerControl2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerControl2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl2> for IActiveScriptProfilerControl {
    fn from(value: IActiveScriptProfilerControl2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl2> for IActiveScriptProfilerControl {
    fn from(value: &IActiveScriptProfilerControl2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for IActiveScriptProfilerControl2 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for &IActiveScriptProfilerControl2 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dweventmask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerControl3(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerControl3 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprofilerobject), ::core::mem::transmute(dweventmask), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dweventmask)).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrshutdownreason)).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__: <IActiveScriptProfilerHeapEnum as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IActiveScriptProfilerHeapEnum>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl3 {
    type Vtable = IActiveScriptProfilerControl3_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b403015_f381_4023_a5d0_6fed076de716);
}
impl ::core::convert::From<IActiveScriptProfilerControl3> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerControl3) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl3> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerControl3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl3> for IActiveScriptProfilerControl2 {
    fn from(value: IActiveScriptProfilerControl3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl3> for IActiveScriptProfilerControl2 {
    fn from(value: &IActiveScriptProfilerControl3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for &IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl3> for IActiveScriptProfilerControl {
    fn from(value: IActiveScriptProfilerControl3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl3> for IActiveScriptProfilerControl {
    fn from(value: &IActiveScriptProfilerControl3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for &IActiveScriptProfilerControl3 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl3_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dweventmask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerControl4(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerControl4 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprofilerobject), ::core::mem::transmute(dweventmask), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dweventmask)).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrshutdownreason)).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__: <IActiveScriptProfilerHeapEnum as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IActiveScriptProfilerHeapEnum>(result__)
    }
    pub unsafe fn SummarizeHeap(&self, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(heapsummary)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl4 {
    type Vtable = IActiveScriptProfilerControl4_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x160f94fd_9dbc_40d4_9eac_2b71db3132f4);
}
impl ::core::convert::From<IActiveScriptProfilerControl4> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerControl4) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl4> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerControl4) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl4> for IActiveScriptProfilerControl3 {
    fn from(value: IActiveScriptProfilerControl4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl4> for IActiveScriptProfilerControl3 {
    fn from(value: &IActiveScriptProfilerControl4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl3> for IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl3> for &IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl4> for IActiveScriptProfilerControl2 {
    fn from(value: IActiveScriptProfilerControl4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl4> for IActiveScriptProfilerControl2 {
    fn from(value: &IActiveScriptProfilerControl4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for &IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl4> for IActiveScriptProfilerControl {
    fn from(value: IActiveScriptProfilerControl4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl4> for IActiveScriptProfilerControl {
    fn from(value: &IActiveScriptProfilerControl4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for &IActiveScriptProfilerControl4 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl4_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dweventmask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerControl5(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerControl5 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(clsidprofilerobject), ::core::mem::transmute(dweventmask), ::core::mem::transmute(dwcontext)).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dweventmask)).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrshutdownreason)).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__: <IActiveScriptProfilerHeapEnum as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IActiveScriptProfilerHeapEnum>(result__)
    }
    pub unsafe fn SummarizeHeap(&self, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(heapsummary)).ok()
    }
    pub unsafe fn EnumHeap2(&self, enumflags: PROFILER_HEAP_ENUM_FLAGS) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__: <IActiveScriptProfilerHeapEnum as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(enumflags), &mut result__).from_abi::<IActiveScriptProfilerHeapEnum>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl5 {
    type Vtable = IActiveScriptProfilerControl5_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c01a2d1_8f0f_46a5_9720_0d7ed2c62f0a);
}
impl ::core::convert::From<IActiveScriptProfilerControl5> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerControl5) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl5> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerControl5) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl5> for IActiveScriptProfilerControl4 {
    fn from(value: IActiveScriptProfilerControl5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl5> for IActiveScriptProfilerControl4 {
    fn from(value: &IActiveScriptProfilerControl5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl4> for IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl4> for &IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl5> for IActiveScriptProfilerControl3 {
    fn from(value: IActiveScriptProfilerControl5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl5> for IActiveScriptProfilerControl3 {
    fn from(value: &IActiveScriptProfilerControl5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl3> for IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl3> for &IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl5> for IActiveScriptProfilerControl2 {
    fn from(value: IActiveScriptProfilerControl5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl5> for IActiveScriptProfilerControl2 {
    fn from(value: &IActiveScriptProfilerControl5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl2> for &IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IActiveScriptProfilerControl5> for IActiveScriptProfilerControl {
    fn from(value: IActiveScriptProfilerControl5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptProfilerControl5> for IActiveScriptProfilerControl {
    fn from(value: &IActiveScriptProfilerControl5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptProfilerControl> for &IActiveScriptProfilerControl5 {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptProfilerControl> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl5_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dweventmask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, enumflags: PROFILER_HEAP_ENUM_FLAGS, ppenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProfilerHeapEnum(pub ::windows::core::IUnknown);
impl IActiveScriptProfilerHeapEnum {
    pub unsafe fn Next(&self, celt: u32, heapobjects: *mut *mut PROFILER_HEAP_OBJECT, pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(heapobjects), ::core::mem::transmute(pceltfetched)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionalInfo(&self, heapobject: *const PROFILER_HEAP_OBJECT, celt: u32, optionalinfo: *mut PROFILER_HEAP_OBJECT_OPTIONAL_INFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(heapobject), ::core::mem::transmute(celt), ::core::mem::transmute(optionalinfo)).ok()
    }
    pub unsafe fn FreeObjectAndOptionalInfo(&self, celt: u32, heapobjects: *const *const PROFILER_HEAP_OBJECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(celt), ::core::mem::transmute(heapobjects)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetNameIdMap(&self, pnamelist: *mut *mut *mut super::super::super::Foundation::PWSTR, pcelt: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pnamelist), ::core::mem::transmute(pcelt)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerHeapEnum {
    type Vtable = IActiveScriptProfilerHeapEnum_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x32e4694e_0d37_419b_b93d_fa20ded6e8ea);
}
impl ::core::convert::From<IActiveScriptProfilerHeapEnum> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProfilerHeapEnum) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProfilerHeapEnum> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProfilerHeapEnum) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProfilerHeapEnum {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProfilerHeapEnum {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerHeapEnum_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, celt: u32, heapobjects: *mut *mut PROFILER_HEAP_OBJECT, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, heapobject: *const PROFILER_HEAP_OBJECT, celt: u32, optionalinfo: *mut PROFILER_HEAP_OBJECT_OPTIONAL_INFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, celt: u32, heapobjects: *const *const PROFILER_HEAP_OBJECT) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pnamelist: *mut *mut *mut super::super::super::Foundation::PWSTR, pcelt: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptProperty(pub ::windows::core::IUnknown);
impl IActiveScriptProperty {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperty(&self, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT) -> ::windows::core::Result<super::super::Com::VARIANT> {
        let mut result__: <super::super::Com::VARIANT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwproperty), ::core::mem::transmute(pvarindex), &mut result__).from_abi::<super::super::Com::VARIANT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperty(&self, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT, pvarvalue: *const super::super::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwproperty), ::core::mem::transmute(pvarindex), ::core::mem::transmute(pvarvalue)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProperty {
    type Vtable = IActiveScriptProperty_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4954e0d0_fbc7_11d1_8410_006008c3fbfc);
}
impl ::core::convert::From<IActiveScriptProperty> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptProperty) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptProperty> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptProperty) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptProperty {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptProperty {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProperty_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwproperty: u32, pvarindex: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, pvarvalue: *mut ::core::mem::ManuallyDrop<super::super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwproperty: u32, pvarindex: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, pvarvalue: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSIPInfo(pub ::windows::core::IUnknown);
impl IActiveScriptSIPInfo {
    pub unsafe fn GetSIPOID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: <::windows::core::GUID as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<::windows::core::GUID>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSIPInfo {
    type Vtable = IActiveScriptSIPInfo_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x764651d0_38de_11d4_a2a3_00104bd35090);
}
impl ::core::convert::From<IActiveScriptSIPInfo> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSIPInfo) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSIPInfo> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSIPInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSIPInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSIPInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSIPInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, poid_sip: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSite(pub ::windows::core::IUnknown);
impl IActiveScriptSite {
    pub unsafe fn GetLCID(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetItemInfo<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrname: Param0, dwreturnmask: u32, ppiunkitem: *mut ::core::option::Option<::windows::core::IUnknown>, ppti: *mut ::core::option::Option<super::super::Com::ITypeInfo>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pstrname.into_param().abi(), ::core::mem::transmute(dwreturnmask), ::core::mem::transmute(ppiunkitem), ::core::mem::transmute(ppti)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDocVersionString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnScriptTerminate(&self, pvarresult: *const super::super::Com::VARIANT, pexcepinfo: *const super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo)).ok()
    }
    pub unsafe fn OnStateChange(&self, ssscriptstate: SCRIPTSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(ssscriptstate)).ok()
    }
    pub unsafe fn OnScriptError<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptError>>(&self, pscripterror: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pscripterror.into_param().abi()).ok()
    }
    pub unsafe fn OnEnterScript(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn OnLeaveScript(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSite {
    type Vtable = IActiveScriptSite_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdb01a1e3_a42b_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScriptSite> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSite) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSite> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSite) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSite_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, plcid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrname: super::super::super::Foundation::PWSTR, dwreturnmask: u32, ppiunkitem: *mut ::windows::core::RawPtr, ppti: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrversion: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pvarresult: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, pexcepinfo: *const ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ssscriptstate: SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pscripterror: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteDebug32(pub ::windows::core::IUnknown);
impl IActiveScriptSiteDebug32 {
    pub unsafe fn GetDocumentContextFromPosition(&self, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__: <IDebugDocumentContext as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourcecontext), ::core::mem::transmute(ucharacteroffset), ::core::mem::transmute(unumchars), &mut result__).from_abi::<IDebugDocumentContext>(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IDebugApplication32> {
        let mut result__: <IDebugApplication32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplication32>(result__)
    }
    pub unsafe fn GetRootApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnScriptErrorDebug<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>>(&self, perrordebug: Param0, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), perrordebug.into_param().abi(), ::core::mem::transmute(pfenterdebugger), ::core::mem::transmute(pfcallonscripterrorwhencontinuing)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebug32 {
    type Vtable = IActiveScriptSiteDebug32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c11_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IActiveScriptSiteDebug32> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteDebug32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteDebug32> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteDebug32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteDebug32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteDebug32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebug32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32, ppsc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppda: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdanroot: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, perrordebug: ::windows::core::RawPtr, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteDebug64(pub ::windows::core::IUnknown);
impl IActiveScriptSiteDebug64 {
    pub unsafe fn GetDocumentContextFromPosition(&self, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__: <IDebugDocumentContext as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwsourcecontext), ::core::mem::transmute(ucharacteroffset), ::core::mem::transmute(unumchars), &mut result__).from_abi::<IDebugDocumentContext>(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IDebugApplication64> {
        let mut result__: <IDebugApplication64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplication64>(result__)
    }
    pub unsafe fn GetRootApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnScriptErrorDebug<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>>(&self, perrordebug: Param0, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), perrordebug.into_param().abi(), ::core::mem::transmute(pfenterdebugger), ::core::mem::transmute(pfcallonscripterrorwhencontinuing)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebug64 {
    type Vtable = IActiveScriptSiteDebug64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6b96b0a_7463_402c_92ac_89984226942f);
}
impl ::core::convert::From<IActiveScriptSiteDebug64> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteDebug64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteDebug64> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteDebug64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteDebug64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteDebug64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebug64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32, ppsc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppda: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdanroot: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, perrordebug: ::windows::core::RawPtr, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteDebugEx(pub ::windows::core::IUnknown);
impl IActiveScriptSiteDebugEx {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCanNotJITScriptErrorDebug<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>>(&self, perrordebug: Param0) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), perrordebug.into_param().abi(), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebugEx {
    type Vtable = IActiveScriptSiteDebugEx_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb722ccb_6ad2_41c6_b780_af9c03ee69f5);
}
impl ::core::convert::From<IActiveScriptSiteDebugEx> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteDebugEx) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteDebugEx> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteDebugEx) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteDebugEx {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteDebugEx {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebugEx_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, perrordebug: ::windows::core::RawPtr, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteInterruptPoll(pub ::windows::core::IUnknown);
impl IActiveScriptSiteInterruptPoll {
    pub unsafe fn QueryContinue(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteInterruptPoll {
    type Vtable = IActiveScriptSiteInterruptPoll_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x539698a0_cdca_11cf_a5eb_00aa0047a063);
}
impl ::core::convert::From<IActiveScriptSiteInterruptPoll> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteInterruptPoll) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteInterruptPoll> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteInterruptPoll) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteInterruptPoll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteInterruptPoll {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteInterruptPoll_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteTraceInfo(pub ::windows::core::IUnknown);
impl IActiveScriptSiteTraceInfo {
    pub unsafe fn SendScriptTraceInfo<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::GUID>>(&self, stieventtype: SCRIPTTRACEINFO, guidcontextid: Param1, dwscriptcontextcookie: u32, lscriptstatementstart: i32, lscriptstatementend: i32, dwreserved: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(stieventtype), guidcontextid.into_param().abi(), ::core::mem::transmute(dwscriptcontextcookie), ::core::mem::transmute(lscriptstatementstart), ::core::mem::transmute(lscriptstatementend), ::core::mem::transmute(dwreserved)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteTraceInfo {
    type Vtable = IActiveScriptSiteTraceInfo_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4b7272ae_1955_4bfe_98b0_780621888569);
}
impl ::core::convert::From<IActiveScriptSiteTraceInfo> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteTraceInfo) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteTraceInfo> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteTraceInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteTraceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteTraceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteTraceInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stieventtype: SCRIPTTRACEINFO, guidcontextid: ::windows::core::GUID, dwscriptcontextcookie: u32, lscriptstatementstart: i32, lscriptstatementend: i32, dwreserved: u64) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteUIControl(pub ::windows::core::IUnknown);
impl IActiveScriptSiteUIControl {
    pub unsafe fn GetUIBehavior(&self, uicitem: SCRIPTUICITEM) -> ::windows::core::Result<SCRIPTUICHANDLING> {
        let mut result__: <SCRIPTUICHANDLING as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicitem), &mut result__).from_abi::<SCRIPTUICHANDLING>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteUIControl {
    type Vtable = IActiveScriptSiteUIControl_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaedae97e_d7ee_4796_b960_7f092ae844ab);
}
impl ::core::convert::From<IActiveScriptSiteUIControl> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteUIControl) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteUIControl> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteUIControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteUIControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteUIControl {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteUIControl_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, uicitem: SCRIPTUICITEM, puichandling: *mut SCRIPTUICHANDLING) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptSiteWindow(pub ::windows::core::IUnknown);
impl IActiveScriptSiteWindow {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::super::Foundation::HWND> {
        let mut result__: <super::super::super::Foundation::HWND as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::HWND>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableModeless<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, fenable: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), fenable.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteWindow {
    type Vtable = IActiveScriptSiteWindow_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd10f6761_83e9_11cf_8f20_00805f2cd064);
}
impl ::core::convert::From<IActiveScriptSiteWindow> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptSiteWindow) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptSiteWindow> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptSiteWindow) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptSiteWindow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptSiteWindow {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteWindow_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, phwnd: *mut super::super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, fenable: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptStats(pub ::windows::core::IUnknown);
impl IActiveScriptStats {
    pub unsafe fn GetStat(&self, stid: u32, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(stid), ::core::mem::transmute(pluhi), ::core::mem::transmute(plulo)).ok()
    }
    pub unsafe fn GetStatEx(&self, guid: *const ::windows::core::GUID, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(guid), ::core::mem::transmute(pluhi), ::core::mem::transmute(plulo)).ok()
    }
    pub unsafe fn ResetStats(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptStats {
    type Vtable = IActiveScriptStats_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8da6310_e19b_11d0_933c_00a0c90dcaa9);
}
impl ::core::convert::From<IActiveScriptStats> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptStats) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptStats> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptStats) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptStats {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptStats_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stid: u32, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, guid: *const ::windows::core::GUID, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptStringCompare(pub ::windows::core::IUnknown);
impl IActiveScriptStringCompare {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StrComp<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::BSTR>>(&self, bszstr1: Param0, bszstr2: Param1) -> ::windows::core::Result<i32> {
        let mut result__: <i32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), bszstr1.into_param().abi(), bszstr2.into_param().abi(), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptStringCompare {
    type Vtable = IActiveScriptStringCompare_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x58562769_ed52_42f7_8403_4963514e1f11);
}
impl ::core::convert::From<IActiveScriptStringCompare> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptStringCompare) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptStringCompare> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptStringCompare) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptStringCompare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptStringCompare {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptStringCompare_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, bszstr1: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, bszstr2: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, iret: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptTraceInfo(pub ::windows::core::IUnknown);
impl IActiveScriptTraceInfo {
    pub unsafe fn StartScriptTracing<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptSiteTraceInfo>, Param1: ::windows::core::IntoParam<'a, ::windows::core::GUID>>(&self, psitetraceinfo: Param0, guidcontextid: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), psitetraceinfo.into_param().abi(), guidcontextid.into_param().abi()).ok()
    }
    pub unsafe fn StopScriptTracing(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptTraceInfo {
    type Vtable = IActiveScriptTraceInfo_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc35456e7_bebf_4a1b_86a9_24d56be8b369);
}
impl ::core::convert::From<IActiveScriptTraceInfo> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptTraceInfo) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptTraceInfo> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptTraceInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptTraceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptTraceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptTraceInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, psitetraceinfo: ::windows::core::RawPtr, guidcontextid: ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IActiveScriptWinRTErrorDebug(pub ::windows::core::IUnknown);
impl IActiveScriptWinRTErrorDebug {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetExceptionInfo(&self) -> ::windows::core::Result<super::super::Com::EXCEPINFO> {
        let mut result__: <super::super::Com::EXCEPINFO as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Com::EXCEPINFO>(result__)
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwsourcecontext), ::core::mem::transmute(pullinenumber), ::core::mem::transmute(plcharacterposition)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRestrictedErrorString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRestrictedErrorReference(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCapabilitySid(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptWinRTErrorDebug {
    type Vtable = IActiveScriptWinRTErrorDebug_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73a3f82a_0fe9_4b33_ba3b_fe095f697e0a);
}
impl ::core::convert::From<IActiveScriptWinRTErrorDebug> for ::windows::core::IUnknown {
    fn from(value: IActiveScriptWinRTErrorDebug) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IActiveScriptWinRTErrorDebug> for ::windows::core::IUnknown {
    fn from(value: &IActiveScriptWinRTErrorDebug) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActiveScriptWinRTErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IActiveScriptWinRTErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IActiveScriptWinRTErrorDebug> for IActiveScriptError {
    fn from(value: IActiveScriptWinRTErrorDebug) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActiveScriptWinRTErrorDebug> for IActiveScriptError {
    fn from(value: &IActiveScriptWinRTErrorDebug) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for IActiveScriptWinRTErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IActiveScriptError> for &IActiveScriptWinRTErrorDebug {
    fn into_param(self) -> ::windows::core::Param<'a, IActiveScriptError> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptWinRTErrorDebug_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pexcepinfo: *mut ::core::mem::ManuallyDrop<super::super::Com::EXCEPINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrsourceline: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, errorstring: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, referencestring: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, capabilitysid: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IApplicationDebugger(pub ::windows::core::IUnknown);
impl IApplicationDebugger {
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CreateInstanceAtDebugger<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, rclsid: *const ::windows::core::GUID, punkouter: Param1, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: <::windows::core::IUnknown as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsid), punkouter.into_param().abi(), ::core::mem::transmute(dwclscontext), ::core::mem::transmute(riid), &mut result__).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn onDebugOutput<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstr: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn onHandleBreakPoint<'a, Param0: ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread>, Param2: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>>(&self, prpt: Param0, br: BREAKREASON, perror: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), prpt.into_param().abi(), ::core::mem::transmute(br), perror.into_param().abi()).ok()
    }
    pub unsafe fn onClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn onDebuggerEvent<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, riid: *const ::windows::core::GUID, punk: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), punk.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDebugger {
    type Vtable = IApplicationDebugger_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c2a_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IApplicationDebugger> for ::windows::core::IUnknown {
    fn from(value: IApplicationDebugger) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IApplicationDebugger> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDebugger) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDebugger {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IApplicationDebugger {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDebugger_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rclsid: *const ::windows::core::GUID, punkouter: ::windows::core::RawPtr, dwclscontext: u32, riid: *const ::windows::core::GUID, ppvobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstr: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prpt: ::windows::core::RawPtr, br: BREAKREASON, perror: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, punk: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IApplicationDebuggerUI(pub ::windows::core::IUnknown);
impl IApplicationDebuggerUI {
    pub unsafe fn BringDocumentToTop<'a, Param0: ::windows::core::IntoParam<'a, IDebugDocumentText>>(&self, pddt: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pddt.into_param().abi()).ok()
    }
    pub unsafe fn BringDocumentContextToTop<'a, Param0: ::windows::core::IntoParam<'a, IDebugDocumentContext>>(&self, pddc: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), pddc.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDebuggerUI {
    type Vtable = IApplicationDebuggerUI_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c2b_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IApplicationDebuggerUI> for ::windows::core::IUnknown {
    fn from(value: IApplicationDebuggerUI) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IApplicationDebuggerUI> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDebuggerUI) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDebuggerUI {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IApplicationDebuggerUI {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDebuggerUI_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pddt: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pddc: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IBindEventHandler(pub ::windows::core::IUnknown);
impl IBindEventHandler {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn BindHandler<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Com::IDispatch>>(&self, pstrevent: Param0, pdisp: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pstrevent.into_param().abi(), pdisp.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IBindEventHandler {
    type Vtable = IBindEventHandler_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63cdbcb0_c1b1_11d0_9336_00a0c90dcaa9);
}
impl ::core::convert::From<IBindEventHandler> for ::windows::core::IUnknown {
    fn from(value: IBindEventHandler) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IBindEventHandler> for ::windows::core::IUnknown {
    fn from(value: &IBindEventHandler) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBindEventHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IBindEventHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBindEventHandler_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrevent: super::super::super::Foundation::PWSTR, pdisp: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct ICodeAddressConcept(pub ::windows::core::IUnknown);
impl ICodeAddressConcept {
    pub unsafe fn GetContainingSymbol<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>>(&self, pcontextobject: Param0) -> ::windows::core::Result<IDebugHostSymbol> {
        let mut result__: <IDebugHostSymbol as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), pcontextobject.into_param().abi(), &mut result__).from_abi::<IDebugHostSymbol>(result__)
    }
}
unsafe impl ::windows::core::Interface for ICodeAddressConcept {
    type Vtable = ICodeAddressConcept_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7371568_5c78_4a00_a4ab_6ef8823184cb);
}
impl ::core::convert::From<ICodeAddressConcept> for ::windows::core::IUnknown {
    fn from(value: ICodeAddressConcept) -> Self {
        value.0
    }
}
impl ::core::convert::From<&ICodeAddressConcept> for ::windows::core::IUnknown {
    fn from(value: &ICodeAddressConcept) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICodeAddressConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ICodeAddressConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICodeAddressConcept_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pcontextobject: ::windows::core::RawPtr, ppsymbol: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IComparableConcept(pub ::windows::core::IUnknown);
impl IComparableConcept {
    pub unsafe fn CompareObjects<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, contextobject: Param0, otherobject: Param1) -> ::windows::core::Result<i32> {
        let mut result__: <i32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), contextobject.into_param().abi(), otherobject.into_param().abi(), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::core::Interface for IComparableConcept {
    type Vtable = IComparableConcept_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7830646_9f0c_4a31_ba19_503f33e6c8a3);
}
impl ::core::convert::From<IComparableConcept> for ::windows::core::IUnknown {
    fn from(value: IComparableConcept) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IComparableConcept> for ::windows::core::IUnknown {
    fn from(value: &IComparableConcept) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IComparableConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IComparableConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComparableConcept_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contextobject: ::windows::core::RawPtr, otherobject: ::windows::core::RawPtr, comparisonresult: *mut i32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelConcept(pub ::windows::core::IUnknown);
impl IDataModelConcept {
    pub unsafe fn InitializeObject<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>, Param2: ::windows::core::IntoParam<'a, IDebugHostSymbolEnumerator>>(&self, modelobject: Param0, matchingtypesignature: Param1, wildcardmatches: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), modelobject.into_param().abi(), matchingtypesignature.into_param().abi(), wildcardmatches.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelConcept {
    type Vtable = IDataModelConcept_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfcb98d1d_1114_4fbf_b24c_effcb5def0d3);
}
impl ::core::convert::From<IDataModelConcept> for ::windows::core::IUnknown {
    fn from(value: IDataModelConcept) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelConcept> for ::windows::core::IUnknown {
    fn from(value: &IDataModelConcept) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelConcept {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelConcept_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelobject: ::windows::core::RawPtr, matchingtypesignature: ::windows::core::RawPtr, wildcardmatches: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelManager(pub ::windows::core::IUnknown);
impl IDataModelManager {
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CreateNoValue(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateErrorObject<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, hrerror: ::windows::core::HRESULT, pwszmessage: Param1) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), pwszmessage.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateTypedObject<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>, Param1: ::windows::core::IntoParam<'a, Location>, Param2: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, context: Param0, objectlocation: Param1, objecttype: Param2) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), context.into_param().abi(), objectlocation.into_param().abi(), objecttype.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateTypedObjectReference<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>, Param1: ::windows::core::IntoParam<'a, Location>, Param2: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, context: Param0, objectlocation: Param1, objecttype: Param2) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), context.into_param().abi(), objectlocation.into_param().abi(), objecttype.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateSyntheticObject<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>>(&self, context: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), context.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateDataModelObject<'a, Param0: ::windows::core::IntoParam<'a, IDataModelConcept>>(&self, datamodel: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::Com::VARIANT) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(objectkind), ::core::mem::transmute(intrinsicdata), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObject<'a, Param1: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, intrinsicdata: *const super::super::Com::VARIANT, r#type: Param1) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(intrinsicdata), r#type.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn GetModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, typesignature: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn GetModelForType<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, r#type: Param0, datamodel: *mut ::core::option::Option<IModelObject>, typesignature: *mut ::core::option::Option<IDebugHostTypeSignature>, wildcardmatches: *mut ::core::option::Option<IDebugHostSymbolEnumerator>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), r#type.into_param().abi(), ::core::mem::transmute(datamodel), ::core::mem::transmute(typesignature), ::core::mem::transmute(wildcardmatches)).ok()
    }
    pub unsafe fn RegisterModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, typesignature: Param0, datamodel: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, datamodel: Param0, typesignature: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn RegisterExtensionForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, typesignature: Param0, datamodel: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, datamodel: Param0, typesignature: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn CreateMetadataStore<'a, Param0: ::windows::core::IntoParam<'a, IKeyStore>>(&self, parentstore: Param0) -> ::windows::core::Result<IKeyStore> {
        let mut result__: <IKeyStore as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), parentstore.into_param().abi(), &mut result__).from_abi::<IKeyStore>(result__)
    }
    pub unsafe fn GetRootNamespace(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, modelname: Param0, modeobject: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), modelname.into_param().abi(), modeobject.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, modelname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), modelname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AcquireNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, modelname: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), modelname.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelManager {
    type Vtable = IDataModelManager_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73fe19f4_a110_4500_8ed9_3c28896f508c);
}
impl ::core::convert::From<IDataModelManager> for ::windows::core::IUnknown {
    fn from(value: IDataModelManager) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelManager> for ::windows::core::IUnknown {
    fn from(value: &IDataModelManager) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrerror: ::windows::core::HRESULT, pwszmessage: super::super::super::Foundation::PWSTR, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, objectlocation: Location, objecttype: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, objectlocation: Location, objecttype: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, objectkind: ModelObjectKind, intrinsicdata: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, intrinsicdata: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, r#type: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, r#type: ::windows::core::RawPtr, datamodel: *mut ::windows::core::RawPtr, typesignature: *mut ::windows::core::RawPtr, wildcardmatches: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, parentstore: ::windows::core::RawPtr, metadatastore: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rootnamespace: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR, modeobject: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR, modelobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelManager2(pub ::windows::core::IUnknown);
impl IDataModelManager2 {
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CreateNoValue(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateErrorObject<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, hrerror: ::windows::core::HRESULT, pwszmessage: Param1) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(hrerror), pwszmessage.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateTypedObject<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>, Param1: ::windows::core::IntoParam<'a, Location>, Param2: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, context: Param0, objectlocation: Param1, objecttype: Param2) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), context.into_param().abi(), objectlocation.into_param().abi(), objecttype.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateTypedObjectReference<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>, Param1: ::windows::core::IntoParam<'a, Location>, Param2: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, context: Param0, objectlocation: Param1, objecttype: Param2) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), context.into_param().abi(), objectlocation.into_param().abi(), objecttype.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateSyntheticObject<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>>(&self, context: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), context.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn CreateDataModelObject<'a, Param0: ::windows::core::IntoParam<'a, IDataModelConcept>>(&self, datamodel: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::Com::VARIANT) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(objectkind), ::core::mem::transmute(intrinsicdata), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObject<'a, Param1: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, intrinsicdata: *const super::super::Com::VARIANT, r#type: Param1) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(intrinsicdata), r#type.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn GetModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, typesignature: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn GetModelForType<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, r#type: Param0, datamodel: *mut ::core::option::Option<IModelObject>, typesignature: *mut ::core::option::Option<IDebugHostTypeSignature>, wildcardmatches: *mut ::core::option::Option<IDebugHostSymbolEnumerator>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), r#type.into_param().abi(), ::core::mem::transmute(datamodel), ::core::mem::transmute(typesignature), ::core::mem::transmute(wildcardmatches)).ok()
    }
    pub unsafe fn RegisterModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, typesignature: Param0, datamodel: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterModelForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, datamodel: Param0, typesignature: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn RegisterExtensionForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, typesignature: Param0, datamodel: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, IDebugHostTypeSignature>>(&self, datamodel: Param0, typesignature: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn CreateMetadataStore<'a, Param0: ::windows::core::IntoParam<'a, IKeyStore>>(&self, parentstore: Param0) -> ::windows::core::Result<IKeyStore> {
        let mut result__: <IKeyStore as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), parentstore.into_param().abi(), &mut result__).from_abi::<IKeyStore>(result__)
    }
    pub unsafe fn GetRootNamespace(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, IModelObject>>(&self, modelname: Param0, modeobject: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), modelname.into_param().abi(), modeobject.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, modelname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), modelname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AcquireNamedModel<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, modelname: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), modelname.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AcquireSubNamespace<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, IKeyStore>>(&self, modelname: Param0, subnamespacemodelname: Param1, accessname: Param2, metadata: Param3) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), modelname.into_param().abi(), subnamespacemodelname.into_param().abi(), accessname.into_param().abi(), metadata.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObjectEx<'a, Param0: ::windows::core::IntoParam<'a, IDebugHostContext>, Param2: ::windows::core::IntoParam<'a, IDebugHostType>>(&self, context: Param0, intrinsicdata: *const super::super::Com::VARIANT, r#type: Param2) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), context.into_param().abi(), ::core::mem::transmute(intrinsicdata), r#type.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelManager2 {
    type Vtable = IDataModelManager2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf412c5ea_2284_4622_a660_a697160d3312);
}
impl ::core::convert::From<IDataModelManager2> for ::windows::core::IUnknown {
    fn from(value: IDataModelManager2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelManager2> for ::windows::core::IUnknown {
    fn from(value: &IDataModelManager2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDataModelManager2> for IDataModelManager {
    fn from(value: IDataModelManager2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataModelManager2> for IDataModelManager {
    fn from(value: &IDataModelManager2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDataModelManager> for IDataModelManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDataModelManager> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDataModelManager> for &IDataModelManager2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDataModelManager> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, hrerror: ::windows::core::HRESULT, pwszmessage: super::super::super::Foundation::PWSTR, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, objectlocation: Location, objecttype: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, objectlocation: Location, objecttype: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, objectkind: ModelObjectKind, intrinsicdata: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, intrinsicdata: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, r#type: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, r#type: ::windows::core::RawPtr, datamodel: *mut ::windows::core::RawPtr, typesignature: *mut ::windows::core::RawPtr, wildcardmatches: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, datamodel: ::windows::core::RawPtr, typesignature: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, parentstore: ::windows::core::RawPtr, metadatastore: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rootnamespace: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR, modeobject: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR, modelobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, modelname: super::super::super::Foundation::PWSTR, subnamespacemodelname: super::super::super::Foundation::PWSTR, accessname: super::super::super::Foundation::PWSTR, metadata: ::windows::core::RawPtr, namespacemodelobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: ::windows::core::RawPtr, intrinsicdata: *const ::core::mem::ManuallyDrop<super::super::Com::VARIANT>, r#type: ::windows::core::RawPtr, object: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelNameBinder(pub ::windows::core::IUnknown);
impl IDataModelNameBinder {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BindValue<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, contextobject: Param0, name: Param1, value: *mut ::core::option::Option<IModelObject>, metadata: *mut ::core::option::Option<IKeyStore>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), contextobject.into_param().abi(), name.into_param().abi(), ::core::mem::transmute(value), ::core::mem::transmute(metadata)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BindReference<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, contextobject: Param0, name: Param1, reference: *mut ::core::option::Option<IModelObject>, metadata: *mut ::core::option::Option<IKeyStore>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), contextobject.into_param().abi(), name.into_param().abi(), ::core::mem::transmute(reference), ::core::mem::transmute(metadata)).ok()
    }
    pub unsafe fn EnumerateValues<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>>(&self, contextobject: Param0) -> ::windows::core::Result<IKeyEnumerator> {
        let mut result__: <IKeyEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), contextobject.into_param().abi(), &mut result__).from_abi::<IKeyEnumerator>(result__)
    }
    pub unsafe fn EnumerateReferences<'a, Param0: ::windows::core::IntoParam<'a, IModelObject>>(&self, contextobject: Param0) -> ::windows::core::Result<IKeyEnumerator> {
        let mut result__: <IKeyEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), contextobject.into_param().abi(), &mut result__).from_abi::<IKeyEnumerator>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelNameBinder {
    type Vtable = IDataModelNameBinder_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaf352b7b_8292_4c01_b360_2dc3696c65e7);
}
impl ::core::convert::From<IDataModelNameBinder> for ::windows::core::IUnknown {
    fn from(value: IDataModelNameBinder) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelNameBinder> for ::windows::core::IUnknown {
    fn from(value: &IDataModelNameBinder) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelNameBinder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelNameBinder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelNameBinder_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contextobject: ::windows::core::RawPtr, name: super::super::super::Foundation::PWSTR, value: *mut ::windows::core::RawPtr, metadata: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contextobject: ::windows::core::RawPtr, name: super::super::super::Foundation::PWSTR, reference: *mut ::windows::core::RawPtr, metadata: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contextobject: ::windows::core::RawPtr, enumerator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contextobject: ::windows::core::RawPtr, enumerator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScript(pub ::windows::core::IUnknown);
impl IDataModelScript {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Rename<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, scriptname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), scriptname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Populate<'a, Param0: ::windows::core::IntoParam<'a, super::super::Com::IStream>>(&self, contentstream: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), contentstream.into_param().abi()).ok()
    }
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn Unlink(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn IsInvocable(&self) -> ::windows::core::Result<bool> {
        let mut result__: <bool as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<bool>(result__)
    }
    pub unsafe fn InvokeMain<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScript {
    type Vtable = IDataModelScript_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b4d30fc_b14a_49f8_8d87_d9a1480c97f7);
}
impl ::core::convert::From<IDataModelScript> for ::windows::core::IUnknown {
    fn from(value: IDataModelScript) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScript> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScript) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScript {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScript {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScript_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contentstream: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, isinvocable: *mut bool) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptClient(pub ::windows::core::IUnknown);
impl IDataModelScriptClient {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportError<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, errclass: ErrorClass, hrfail: ::windows::core::HRESULT, message: Param2, line: u32, position: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(errclass), ::core::mem::transmute(hrfail), message.into_param().abi(), ::core::mem::transmute(line), ::core::mem::transmute(position)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptClient {
    type Vtable = IDataModelScriptClient_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b362b0e_89f0_46c6_a663_dfdc95194aef);
}
impl ::core::convert::From<IDataModelScriptClient> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptClient) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptClient> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptClient_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, errclass: ErrorClass, hrfail: ::windows::core::HRESULT, message: super::super::super::Foundation::PWSTR, line: u32, position: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebug(pub ::windows::core::IUnknown);
impl IDataModelScriptDebug {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(currentposition), ::core::mem::transmute(positionspanend), ::core::mem::transmute(linetext)).ok()
    }
    pub unsafe fn GetStack(&self) -> ::windows::core::Result<IDataModelScriptDebugStack> {
        let mut result__: <IDataModelScriptDebugStack as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugStack>(result__)
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineposition), ::core::mem::transmute(columnposition), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(breakpointid), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        let mut result__: <IDataModelScriptDebugBreakpointEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugBreakpointEnumerator>(result__)
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> ::windows::core::Result<bool> {
        let mut result__: <bool as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventfilter), &mut result__).from_abi::<bool>(result__)
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventfilter), ::core::mem::transmute(isbreakenabled)).ok()
    }
    pub unsafe fn StartDebugging<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptDebugClient>>(&self, debugclient: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), debugclient.into_param().abi()).ok()
    }
    pub unsafe fn StopDebugging<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptDebugClient>>(&self, debugclient: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), debugclient.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebug {
    type Vtable = IDataModelScriptDebug_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde8e0945_9750_4471_ab76_a8f79d6ec350);
}
impl ::core::convert::From<IDataModelScriptDebug> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebug) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebug> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebug) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebug {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ScriptDebugState,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stack: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, lineposition: u32, columnposition: u32, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breakpointid: u64, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breakpointenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, eventfilter: ScriptDebugEventFilter, isbreakenabled: *mut bool) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, debugclient: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, debugclient: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebug2(pub ::windows::core::IUnknown);
impl IDataModelScriptDebug2 {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(currentposition), ::core::mem::transmute(positionspanend), ::core::mem::transmute(linetext)).ok()
    }
    pub unsafe fn GetStack(&self) -> ::windows::core::Result<IDataModelScriptDebugStack> {
        let mut result__: <IDataModelScriptDebugStack as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugStack>(result__)
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineposition), ::core::mem::transmute(columnposition), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(breakpointid), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        let mut result__: <IDataModelScriptDebugBreakpointEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugBreakpointEnumerator>(result__)
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> ::windows::core::Result<bool> {
        let mut result__: <bool as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventfilter), &mut result__).from_abi::<bool>(result__)
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(eventfilter), ::core::mem::transmute(isbreakenabled)).ok()
    }
    pub unsafe fn StartDebugging<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptDebugClient>>(&self, debugclient: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), debugclient.into_param().abi()).ok()
    }
    pub unsafe fn StopDebugging<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptDebugClient>>(&self, debugclient: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), debugclient.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBreakpointAtFunction<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, functionname: Param0) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), functionname.into_param().abi(), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebug2 {
    type Vtable = IDataModelScriptDebug2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcbb10ed3_839e_426c_9243_e23535c1ae1a);
}
impl ::core::convert::From<IDataModelScriptDebug2> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebug2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebug2> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebug2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebug2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebug2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDataModelScriptDebug2> for IDataModelScriptDebug {
    fn from(value: IDataModelScriptDebug2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataModelScriptDebug2> for IDataModelScriptDebug {
    fn from(value: &IDataModelScriptDebug2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDataModelScriptDebug> for IDataModelScriptDebug2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDataModelScriptDebug> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDataModelScriptDebug> for &IDataModelScriptDebug2 {
    fn into_param(self) -> ::windows::core::Param<'a, IDataModelScriptDebug> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ScriptDebugState,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stack: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, lineposition: u32, columnposition: u32, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breakpointid: u64, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breakpointenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, eventfilter: ScriptDebugEventFilter, isbreakenabled: *mut bool) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, debugclient: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, debugclient: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, functionname: super::super::super::Foundation::PWSTR, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugBreakpoint(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugBreakpoint {
    pub unsafe fn GetId(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn IsEnabled(&self) -> bool {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn Enable(&self) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn Disable(&self) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn Remove(&self) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(position), ::core::mem::transmute(positionspanend), ::core::mem::transmute(linetext)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugBreakpoint {
    type Vtable = IDataModelScriptDebugBreakpoint_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bb27b35_02e6_47cb_90a0_5371244032de);
}
impl ::core::convert::From<IDataModelScriptDebugBreakpoint> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugBreakpoint) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugBreakpoint> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugBreakpoint) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugBreakpoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugBreakpoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpoint_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> bool,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugBreakpointEnumerator(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugBreakpointEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__: <IDataModelScriptDebugBreakpoint as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugBreakpoint>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugBreakpointEnumerator {
    type Vtable = IDataModelScriptDebugBreakpointEnumerator_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x39484a75_b4f3_4799_86da_691afa57b299);
}
impl ::core::convert::From<IDataModelScriptDebugBreakpointEnumerator> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugBreakpointEnumerator) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugBreakpointEnumerator> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugBreakpointEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugBreakpointEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugBreakpointEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpointEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breakpoint: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugClient(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugClient {
    pub unsafe fn NotifyDebugEvent<'a, Param1: ::windows::core::IntoParam<'a, IDataModelScript>, Param2: ::windows::core::IntoParam<'a, IModelObject>>(&self, peventinfo: *const ScriptDebugEventInformation, pscript: Param1, peventdataobject: Param2, resumeeventkind: *mut ScriptExecutionKind) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(peventinfo), pscript.into_param().abi(), peventdataobject.into_param().abi(), ::core::mem::transmute(resumeeventkind)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugClient {
    type Vtable = IDataModelScriptDebugClient_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x53159b6d_d4c4_471b_a863_5b110ca800ca);
}
impl ::core::convert::From<IDataModelScriptDebugClient> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugClient) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugClient> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugClient_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, peventinfo: *const ScriptDebugEventInformation, pscript: ::windows::core::RawPtr, peventdataobject: ::windows::core::RawPtr, resumeeventkind: *mut ScriptExecutionKind) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugStack(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugStack {
    pub unsafe fn GetFrameCount(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn GetStackFrame(&self, framenumber: u64) -> ::windows::core::Result<IDataModelScriptDebugStackFrame> {
        let mut result__: <IDataModelScriptDebugStackFrame as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(framenumber), &mut result__).from_abi::<IDataModelScriptDebugStackFrame>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugStack {
    type Vtable = IDataModelScriptDebugStack_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x051364dd_e449_443e_9762_fe578f4a5473);
}
impl ::core::convert::From<IDataModelScriptDebugStack> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugStack) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugStack> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugStack) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugStack {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugStack {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStack_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, framenumber: u64, stackframe: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugStackFrame(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugStackFrame {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(position), ::core::mem::transmute(positionspanend), ::core::mem::transmute(linetext)).ok()
    }
    pub unsafe fn IsTransitionPoint(&self) -> ::windows::core::Result<bool> {
        let mut result__: <bool as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<bool>(result__)
    }
    pub unsafe fn GetTransition(&self, transitionscript: *mut ::core::option::Option<IDataModelScript>, istransitioncontiguous: *mut bool) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(transitionscript), ::core::mem::transmute(istransitioncontiguous)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Evaluate<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwszexpression: Param0) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pwszexpression.into_param().abi(), &mut result__).from_abi::<IModelObject>(result__)
    }
    pub unsafe fn EnumerateLocals(&self) -> ::windows::core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__: <IDataModelScriptDebugVariableSetEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugVariableSetEnumerator>(result__)
    }
    pub unsafe fn EnumerateArguments(&self) -> ::windows::core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__: <IDataModelScriptDebugVariableSetEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptDebugVariableSetEnumerator>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugStackFrame {
    type Vtable = IDataModelScriptDebugStackFrame_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdec6ed5e_6360_4941_ab4c_a26409de4f82);
}
impl ::core::convert::From<IDataModelScriptDebugStackFrame> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugStackFrame) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugStackFrame> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugStackFrame) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugStackFrame {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugStackFrame {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStackFrame_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, name: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, istransitionpoint: *mut bool) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, transitionscript: *mut ::windows::core::RawPtr, istransitioncontiguous: *mut bool) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pwszexpression: super::super::super::Foundation::PWSTR, ppresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, variablesenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, variablesenum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptDebugVariableSetEnumerator(pub ::windows::core::IUnknown);
impl IDataModelScriptDebugVariableSetEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetNext(&self, variablename: *mut super::super::super::Foundation::BSTR, variablevalue: *mut ::core::option::Option<IModelObject>, variablemetadata: *mut ::core::option::Option<IKeyStore>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(variablename), ::core::mem::transmute(variablevalue), ::core::mem::transmute(variablemetadata)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugVariableSetEnumerator {
    type Vtable = IDataModelScriptDebugVariableSetEnumerator_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0f9feed7_d045_4ac3_98a8_a98942cf6a35);
}
impl ::core::convert::From<IDataModelScriptDebugVariableSetEnumerator> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptDebugVariableSetEnumerator) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptDebugVariableSetEnumerator> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptDebugVariableSetEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptDebugVariableSetEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptDebugVariableSetEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugVariableSetEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, variablename: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, variablevalue: *mut ::windows::core::RawPtr, variablemetadata: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptHostContext(pub ::windows::core::IUnknown);
impl IDataModelScriptHostContext {
    pub unsafe fn NotifyScriptChange<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScript>>(&self, script: Param0, changekind: ScriptChangeKind) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), script.into_param().abi(), ::core::mem::transmute(changekind)).ok()
    }
    pub unsafe fn GetNamespaceObject(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__: <IModelObject as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IModelObject>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptHostContext {
    type Vtable = IDataModelScriptHostContext_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x014d366a_1f23_4981_9219_b2db8b402054);
}
impl ::core::convert::From<IDataModelScriptHostContext> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptHostContext) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptHostContext> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptHostContext) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptHostContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptHostContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptHostContext_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, script: ::windows::core::RawPtr, changekind: ScriptChangeKind) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, namespaceobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptManager(pub ::windows::core::IUnknown);
impl IDataModelScriptManager {
    pub unsafe fn GetDefaultNameBinder(&self) -> ::windows::core::Result<IDataModelNameBinder> {
        let mut result__: <IDataModelNameBinder as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelNameBinder>(result__)
    }
    pub unsafe fn RegisterScriptProvider<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptProvider>>(&self, provider: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), provider.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterScriptProvider<'a, Param0: ::windows::core::IntoParam<'a, IDataModelScriptProvider>>(&self, provider: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), provider.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindProviderForScriptType<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, scripttype: Param0) -> ::windows::core::Result<IDataModelScriptProvider> {
        let mut result__: <IDataModelScriptProvider as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), scripttype.into_param().abi(), &mut result__).from_abi::<IDataModelScriptProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindProviderForScriptExtension<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, scriptextension: Param0) -> ::windows::core::Result<IDataModelScriptProvider> {
        let mut result__: <IDataModelScriptProvider as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), scriptextension.into_param().abi(), &mut result__).from_abi::<IDataModelScriptProvider>(result__)
    }
    pub unsafe fn EnumerateScriptProviders(&self) -> ::windows::core::Result<IDataModelScriptProviderEnumerator> {
        let mut result__: <IDataModelScriptProviderEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptProviderEnumerator>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptManager {
    type Vtable = IDataModelScriptManager_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6fd11e33_e5ad_410b_8011_68c6bc4bf80d);
}
impl ::core::convert::From<IDataModelScriptManager> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptManager) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptManager> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptManager) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptManager_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppnamebinder: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, provider: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, provider: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scripttype: super::super::super::Foundation::PWSTR, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, scriptextension: super::super::super::Foundation::PWSTR, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, enumerator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptProvider(pub ::windows::core::IUnknown);
impl IDataModelScriptProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetExtension(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CreateScript(&self) -> ::windows::core::Result<IDataModelScript> {
        let mut result__: <IDataModelScript as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScript>(result__)
    }
    pub unsafe fn GetDefaultTemplateContent(&self) -> ::windows::core::Result<IDataModelScriptTemplate> {
        let mut result__: <IDataModelScriptTemplate as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptTemplate>(result__)
    }
    pub unsafe fn EnumerateTemplates(&self) -> ::windows::core::Result<IDataModelScriptTemplateEnumerator> {
        let mut result__: <IDataModelScriptTemplateEnumerator as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptTemplateEnumerator>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptProvider {
    type Vtable = IDataModelScriptProvider_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x513461e0_4fca_48ce_8658_32f3e2056f3b);
}
impl ::core::convert::From<IDataModelScriptProvider> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptProvider) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptProvider> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, name: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, extension: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, script: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, templatecontent: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, enumerator: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptProviderEnumerator(pub ::windows::core::IUnknown);
impl IDataModelScriptProviderEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptProvider> {
        let mut result__: <IDataModelScriptProvider as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptProvider>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptProviderEnumerator {
    type Vtable = IDataModelScriptProviderEnumerator_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x95ba00e2_704a_4fe2_a8f1_a7e7d8fb0941);
}
impl ::core::convert::From<IDataModelScriptProviderEnumerator> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptProviderEnumerator) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptProviderEnumerator> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptProviderEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptProviderEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptProviderEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProviderEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptTemplate(pub ::windows::core::IUnknown);
impl IDataModelScriptTemplate {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetContent(&self) -> ::windows::core::Result<super::super::Com::IStream> {
        let mut result__: <super::super::Com::IStream as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Com::IStream>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptTemplate {
    type Vtable = IDataModelScriptTemplate_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1303dec4_fa3b_4f1b_9224_b953d16babb5);
}
impl ::core::convert::From<IDataModelScriptTemplate> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptTemplate) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptTemplate> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptTemplate) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptTemplate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptTemplate {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplate_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, templatename: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, templatedescription: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, contentstream: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDataModelScriptTemplateEnumerator(pub ::windows::core::IUnknown);
impl IDataModelScriptTemplateEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptTemplate> {
        let mut result__: <IDataModelScriptTemplate as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDataModelScriptTemplate>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptTemplateEnumerator {
    type Vtable = IDataModelScriptTemplateEnumerator_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69ce6ae2_2268_4e6f_b062_20ce62bfe677);
}
impl ::core::convert::From<IDataModelScriptTemplateEnumerator> for ::windows::core::IUnknown {
    fn from(value: IDataModelScriptTemplateEnumerator) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDataModelScriptTemplateEnumerator> for ::windows::core::IUnknown {
    fn from(value: &IDataModelScriptTemplateEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDataModelScriptTemplateEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDataModelScriptTemplateEnumerator {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplateEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, templatecontent: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAdvanced(pub ::windows::core::IUnknown);
impl IDebugAdvanced {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced {
    type Vtable = IDebugAdvanced_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2df5f53_071f_47bd_9de6_5734c3fed689);
}
impl ::core::convert::From<IDebugAdvanced> for ::windows::core::IUnknown {
    fn from(value: IDebugAdvanced) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAdvanced> for ::windows::core::IUnknown {
    fn from(value: &IDebugAdvanced) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAdvanced {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAdvanced {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAdvanced2(pub ::windows::core::IUnknown);
impl IDebugAdvanced2 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(request), ::core::mem::transmute(inbuffer), ::core::mem::transmute(inbuffersize), ::core::mem::transmute(outbuffer), ::core::mem::transmute(outbuffersize), ::core::mem::transmute(outsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceFileInformation<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, which: u32, sourcefile: Param1, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), sourcefile.into_param().abi(), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindSourceFileAndToken<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, startelement: u32, modaddr: u64, file: Param2, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(startelement),
            ::core::mem::transmute(modaddr),
            file.into_param().abi(),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(filetoken),
            ::core::mem::transmute(filetokensize),
            ::core::mem::transmute(foundelement),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(foundsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
        )
        .ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced2 {
    type Vtable = IDebugAdvanced2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x716d14c9_119b_4ba5_af1f_0890e672416a);
}
impl ::core::convert::From<IDebugAdvanced2> for ::windows::core::IUnknown {
    fn from(value: IDebugAdvanced2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAdvanced2> for ::windows::core::IUnknown {
    fn from(value: &IDebugAdvanced2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAdvanced2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAdvanced2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, sourcefile: super::super::super::Foundation::PSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, startelement: u32, modaddr: u64, file: super::super::super::Foundation::PSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAdvanced3(pub ::windows::core::IUnknown);
impl IDebugAdvanced3 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(request), ::core::mem::transmute(inbuffer), ::core::mem::transmute(inbuffersize), ::core::mem::transmute(outbuffer), ::core::mem::transmute(outbuffersize), ::core::mem::transmute(outsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceFileInformation<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, which: u32, sourcefile: Param1, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), sourcefile.into_param().abi(), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindSourceFileAndToken<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, startelement: u32, modaddr: u64, file: Param2, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(startelement),
            ::core::mem::transmute(modaddr),
            file.into_param().abi(),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(filetoken),
            ::core::mem::transmute(filetokensize),
            ::core::mem::transmute(foundelement),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(foundsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
        )
        .ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceFileInformationWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, which: u32, sourcefile: Param1, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), sourcefile.into_param().abi(), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindSourceFileAndTokenWide<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, startelement: u32, modaddr: u64, file: Param2, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(startelement),
            ::core::mem::transmute(modaddr),
            file.into_param().abi(),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(filetoken),
            ::core::mem::transmute(filetokensize),
            ::core::mem::transmute(foundelement),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(foundsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
        )
        .ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced3 {
    type Vtable = IDebugAdvanced3_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcba4abb4_84c4_444d_87ca_a04e13286739);
}
impl ::core::convert::From<IDebugAdvanced3> for ::windows::core::IUnknown {
    fn from(value: IDebugAdvanced3) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAdvanced3> for ::windows::core::IUnknown {
    fn from(value: &IDebugAdvanced3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAdvanced3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAdvanced3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced3_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, sourcefile: super::super::super::Foundation::PSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, startelement: u32, modaddr: u64, file: super::super::super::Foundation::PSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, sourcefile: super::super::super::Foundation::PWSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, startelement: u32, modaddr: u64, file: super::super::super::Foundation::PWSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAdvanced4(pub ::windows::core::IUnknown);
impl IDebugAdvanced4 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), ::core::mem::transmute(contextsize)).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(request), ::core::mem::transmute(inbuffer), ::core::mem::transmute(inbuffersize), ::core::mem::transmute(outbuffer), ::core::mem::transmute(outbuffersize), ::core::mem::transmute(outsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceFileInformation<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, which: u32, sourcefile: Param1, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), sourcefile.into_param().abi(), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindSourceFileAndToken<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, startelement: u32, modaddr: u64, file: Param2, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(startelement),
            ::core::mem::transmute(modaddr),
            file.into_param().abi(),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(filetoken),
            ::core::mem::transmute(filetokensize),
            ::core::mem::transmute(foundelement),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(foundsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
        )
        .ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSourceFileInformationWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, which: u32, sourcefile: Param1, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(which), sourcefile.into_param().abi(), ::core::mem::transmute(arg64), ::core::mem::transmute(arg32), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(infosize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindSourceFileAndTokenWide<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, startelement: u32, modaddr: u64, file: Param2, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(startelement),
            ::core::mem::transmute(modaddr),
            file.into_param().abi(),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(filetoken),
            ::core::mem::transmute(filetokensize),
            ::core::mem::transmute(foundelement),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(foundsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSymbolInformationWideEx(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32, pinfoex: *mut SYMBOL_INFO_EX) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(which),
            ::core::mem::transmute(arg64),
            ::core::mem::transmute(arg32),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(buffersize),
            ::core::mem::transmute(infosize),
            ::core::mem::transmute(stringbuffer),
            ::core::mem::transmute(stringbuffersize),
            ::core::mem::transmute(stringsize),
            ::core::mem::transmute(pinfoex),
        )
        .ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced4 {
    type Vtable = IDebugAdvanced4_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd1069067_2a65_4bf0_ae97_76184b67856b);
}
impl ::core::convert::From<IDebugAdvanced4> for ::windows::core::IUnknown {
    fn from(value: IDebugAdvanced4) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAdvanced4> for ::windows::core::IUnknown {
    fn from(value: &IDebugAdvanced4) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAdvanced4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAdvanced4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced4_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, sourcefile: super::super::super::Foundation::PSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, startelement: u32, modaddr: u64, file: super::super::super::Foundation::PSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, sourcefile: super::super::super::Foundation::PWSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, startelement: u32, modaddr: u64, file: super::super::super::Foundation::PWSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: super::super::super::Foundation::PWSTR, stringbuffersize: u32, stringsize: *mut u32, pinfoex: *mut SYMBOL_INFO_EX) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplication11032(pub ::windows::core::IUnknown);
impl IDebugApplication11032 {
    pub unsafe fn SetDebuggerOptions(&self, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask), ::core::mem::transmute(value)).ok()
    }
    pub unsafe fn GetCurrentDebuggerOptions(&self) -> ::windows::core::Result<SCRIPT_DEBUGGER_OPTIONS> {
        let mut result__: <SCRIPT_DEBUGGER_OPTIONS as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<SCRIPT_DEBUGGER_OPTIONS>(result__)
    }
    pub unsafe fn GetMainThread(&self) -> ::windows::core::Result<IRemoteDebugApplicationThread> {
        let mut result__: <IRemoteDebugApplicationThread as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IRemoteDebugApplicationThread>(result__)
    }
    pub unsafe fn SynchronousCallInMainThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn AsynchronousCallInMainThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CallableWaitForHandles(&self, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(handlecount), ::core::mem::transmute(phandles), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication11032 {
    type Vtable = IDebugApplication11032_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbdb3b5de_89f2_4e11_84a5_97445f941c7d);
}
impl ::core::convert::From<IDebugApplication11032> for ::windows::core::IUnknown {
    fn from(value: IDebugApplication11032) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplication11032> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplication11032) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplication11032 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplication11032 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplication11032> for IRemoteDebugApplication110 {
    fn from(value: IDebugApplication11032) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplication11032> for IRemoteDebugApplication110 {
    fn from(value: &IDebugApplication11032) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication110> for IDebugApplication11032 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication110> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication110> for &IDebugApplication11032 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication110> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication11032_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pcurrentoptions: *mut SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppthread: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE, pindex: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplication11064(pub ::windows::core::IUnknown);
impl IDebugApplication11064 {
    pub unsafe fn SetDebuggerOptions(&self, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask), ::core::mem::transmute(value)).ok()
    }
    pub unsafe fn GetCurrentDebuggerOptions(&self) -> ::windows::core::Result<SCRIPT_DEBUGGER_OPTIONS> {
        let mut result__: <SCRIPT_DEBUGGER_OPTIONS as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<SCRIPT_DEBUGGER_OPTIONS>(result__)
    }
    pub unsafe fn GetMainThread(&self) -> ::windows::core::Result<IRemoteDebugApplicationThread> {
        let mut result__: <IRemoteDebugApplicationThread as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IRemoteDebugApplicationThread>(result__)
    }
    pub unsafe fn SynchronousCallInMainThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall64>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn AsynchronousCallInMainThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall64>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CallableWaitForHandles(&self, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(handlecount), ::core::mem::transmute(phandles), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication11064 {
    type Vtable = IDebugApplication11064_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2039d958_4eeb_496a_87bb_2e5201eadeef);
}
impl ::core::convert::From<IDebugApplication11064> for ::windows::core::IUnknown {
    fn from(value: IDebugApplication11064) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplication11064> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplication11064) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplication11064 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplication11064 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplication11064> for IRemoteDebugApplication110 {
    fn from(value: IDebugApplication11064) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplication11064> for IRemoteDebugApplication110 {
    fn from(value: &IDebugApplication11064) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication110> for IDebugApplication11064 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication110> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication110> for &IDebugApplication11064 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication110> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication11064_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pcurrentoptions: *mut SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppthread: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE, pindex: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplication32(pub ::windows::core::IUnknown);
impl IDebugApplication32 {
    pub unsafe fn ResumeFromBreakPoint<'a, Param0: ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread>>(&self, prptfocus: Param0, bra: BREAKRESUME_ACTION, era: ERRORRESUMEACTION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prptfocus.into_param().abi(), ::core::mem::transmute(bra), ::core::mem::transmute(era)).ok()
    }
    pub unsafe fn CauseBreak(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ConnectDebugger<'a, Param0: ::windows::core::IntoParam<'a, IApplicationDebugger>>(&self, pad: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pad.into_param().abi()).ok()
    }
    pub unsafe fn DisconnectDebugger(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDebugger(&self) -> ::windows::core::Result<IApplicationDebugger> {
        let mut result__: <IApplicationDebugger as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IApplicationDebugger>(result__)
    }
    pub unsafe fn CreateInstanceAtApplication<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, rclsid: *const ::windows::core::GUID, punkouter: Param1, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: <::windows::core::IUnknown as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsid), punkouter.into_param().abi(), ::core::mem::transmute(dwclscontext), ::core::mem::transmute(riid), &mut result__).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EnumThreads(&self) -> ::windows::core::Result<IEnumRemoteDebugApplicationThreads> {
        let mut result__: <IEnumRemoteDebugApplicationThreads as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumRemoteDebugApplicationThreads>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetRootNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    pub unsafe fn EnumGlobalExpressionContexts(&self) -> ::windows::core::Result<IEnumDebugExpressionContexts> {
        let mut result__: <IEnumDebugExpressionContexts as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumDebugExpressionContexts>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), pstrname.into_param().abi()).ok()
    }
    pub unsafe fn StepOutComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DebugOutput<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstr: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn StartDebugSession(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn HandleBreakPoint(&self, br: BREAKREASON) -> ::windows::core::Result<BREAKRESUME_ACTION> {
        let mut result__: <BREAKRESUME_ACTION as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(br), &mut result__).from_abi::<BREAKRESUME_ACTION>(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetBreakFlags(&self, pabf: *mut u32, pprdatsteppingthread: *mut ::core::option::Option<IRemoteDebugApplicationThread>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(pabf), ::core::mem::transmute(pprdatsteppingthread)).ok()
    }
    pub unsafe fn GetCurrentThread(&self) -> ::windows::core::Result<IDebugApplicationThread> {
        let mut result__: <IDebugApplicationThread as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationThread>(result__)
    }
    pub unsafe fn CreateAsyncDebugOperation<'a, Param0: ::windows::core::IntoParam<'a, IDebugSyncOperation>>(&self, psdo: Param0) -> ::windows::core::Result<IDebugAsyncOperation> {
        let mut result__: <IDebugAsyncOperation as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), psdo.into_param().abi(), &mut result__).from_abi::<IDebugAsyncOperation>(result__)
    }
    pub unsafe fn AddStackFrameSniffer<'a, Param0: ::windows::core::IntoParam<'a, IDebugStackFrameSniffer>>(&self, pdsfs: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), pdsfs.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn RemoveStackFrameSniffer(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    pub unsafe fn QueryCurrentThreadIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SynchronousCallInDebuggerThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pptc: Param0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn CreateApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    pub unsafe fn FireDebuggerEvent<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, riid: *const ::windows::core::GUID, punk: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), punk.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleRuntimeError<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>, Param1: ::windows::core::IntoParam<'a, IActiveScriptSite>>(&self, perrordebug: Param0, pscriptsite: Param1, pbra: *mut BREAKRESUME_ACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), perrordebug.into_param().abi(), pscriptsite.into_param().abi(), ::core::mem::transmute(pbra), ::core::mem::transmute(perra), ::core::mem::transmute(pfcallonscripterror)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FCanJitDebug(&self) -> super::super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FIsAutoJitDebugEnabled(&self) -> super::super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn AddGlobalExpressionContextProvider<'a, Param0: ::windows::core::IntoParam<'a, IProvideExpressionContexts>>(&self, pdsfs: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), pdsfs.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn RemoveGlobalExpressionContextProvider(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication32 {
    type Vtable = IDebugApplication32_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c32_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugApplication32> for ::windows::core::IUnknown {
    fn from(value: IDebugApplication32) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplication32> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplication32) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplication32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplication32 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplication32> for IRemoteDebugApplication {
    fn from(value: IDebugApplication32) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplication32> for IRemoteDebugApplication {
    fn from(value: &IDebugApplication32) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication> for IDebugApplication32 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication> for &IDebugApplication32 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication32_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prptfocus: ::windows::core::RawPtr, bra: BREAKRESUME_ACTION, era: ERRORRESUMEACTION) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pad: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pad: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rclsid: *const ::windows::core::GUID, punkouter: ::windows::core::RawPtr, dwclscontext: u32, riid: *const ::windows::core::GUID, ppvobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pperdat: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdanroot: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppedec: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstr: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, br: BREAKREASON, pbra: *mut BREAKRESUME_ACTION) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pabf: *mut u32, pprdatsteppingthread: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pat: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, psdo: ::windows::core::RawPtr, ppado: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdsfs: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcookie: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdannew: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, punk: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, perrordebug: ::windows::core::RawPtr, pscriptsite: ::windows::core::RawPtr, pbra: *mut BREAKRESUME_ACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdsfs: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcookie: u32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplication64(pub ::windows::core::IUnknown);
impl IDebugApplication64 {
    pub unsafe fn ResumeFromBreakPoint<'a, Param0: ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread>>(&self, prptfocus: Param0, bra: BREAKRESUME_ACTION, era: ERRORRESUMEACTION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prptfocus.into_param().abi(), ::core::mem::transmute(bra), ::core::mem::transmute(era)).ok()
    }
    pub unsafe fn CauseBreak(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ConnectDebugger<'a, Param0: ::windows::core::IntoParam<'a, IApplicationDebugger>>(&self, pad: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), pad.into_param().abi()).ok()
    }
    pub unsafe fn DisconnectDebugger(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDebugger(&self) -> ::windows::core::Result<IApplicationDebugger> {
        let mut result__: <IApplicationDebugger as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IApplicationDebugger>(result__)
    }
    pub unsafe fn CreateInstanceAtApplication<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, rclsid: *const ::windows::core::GUID, punkouter: Param1, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: <::windows::core::IUnknown as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsid), punkouter.into_param().abi(), ::core::mem::transmute(dwclscontext), ::core::mem::transmute(riid), &mut result__).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EnumThreads(&self) -> ::windows::core::Result<IEnumRemoteDebugApplicationThreads> {
        let mut result__: <IEnumRemoteDebugApplicationThreads as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumRemoteDebugApplicationThreads>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetRootNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    pub unsafe fn EnumGlobalExpressionContexts(&self) -> ::windows::core::Result<IEnumDebugExpressionContexts> {
        let mut result__: <IEnumDebugExpressionContexts as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumDebugExpressionContexts>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), pstrname.into_param().abi()).ok()
    }
    pub unsafe fn StepOutComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DebugOutput<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstr: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn StartDebugSession(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn HandleBreakPoint(&self, br: BREAKREASON) -> ::windows::core::Result<BREAKRESUME_ACTION> {
        let mut result__: <BREAKRESUME_ACTION as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(br), &mut result__).from_abi::<BREAKRESUME_ACTION>(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetBreakFlags(&self, pabf: *mut u32, pprdatsteppingthread: *mut ::core::option::Option<IRemoteDebugApplicationThread>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), ::core::mem::transmute(pabf), ::core::mem::transmute(pprdatsteppingthread)).ok()
    }
    pub unsafe fn GetCurrentThread(&self) -> ::windows::core::Result<IDebugApplicationThread> {
        let mut result__: <IDebugApplicationThread as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationThread>(result__)
    }
    pub unsafe fn CreateAsyncDebugOperation<'a, Param0: ::windows::core::IntoParam<'a, IDebugSyncOperation>>(&self, psdo: Param0) -> ::windows::core::Result<IDebugAsyncOperation> {
        let mut result__: <IDebugAsyncOperation as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), psdo.into_param().abi(), &mut result__).from_abi::<IDebugAsyncOperation>(result__)
    }
    pub unsafe fn AddStackFrameSniffer<'a, Param0: ::windows::core::IntoParam<'a, IDebugStackFrameSniffer>>(&self, pdsfs: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), pdsfs.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn RemoveStackFrameSniffer(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    pub unsafe fn QueryCurrentThreadIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SynchronousCallInDebuggerThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall64>>(&self, pptc: Param0, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn CreateApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    pub unsafe fn FireDebuggerEvent<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, riid: *const ::windows::core::GUID, punk: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), punk.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleRuntimeError<'a, Param0: ::windows::core::IntoParam<'a, IActiveScriptErrorDebug>, Param1: ::windows::core::IntoParam<'a, IActiveScriptSite>>(&self, perrordebug: Param0, pscriptsite: Param1, pbra: *mut BREAKRESUME_ACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), perrordebug.into_param().abi(), pscriptsite.into_param().abi(), ::core::mem::transmute(pbra), ::core::mem::transmute(perra), ::core::mem::transmute(pfcallonscripterror)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FCanJitDebug(&self) -> super::super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FIsAutoJitDebugEnabled(&self) -> super::super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)))
    }
    pub unsafe fn AddGlobalExpressionContextProvider<'a, Param0: ::windows::core::IntoParam<'a, IProvideExpressionContexts>>(&self, pdsfs: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), pdsfs.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn RemoveGlobalExpressionContextProvider(&self, dwcookie: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication64 {
    type Vtable = IDebugApplication64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4dedc754_04c7_4f10_9e60_16a390fe6e62);
}
impl ::core::convert::From<IDebugApplication64> for ::windows::core::IUnknown {
    fn from(value: IDebugApplication64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplication64> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplication64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplication64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplication64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplication64> for IRemoteDebugApplication {
    fn from(value: IDebugApplication64) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplication64> for IRemoteDebugApplication {
    fn from(value: &IDebugApplication64) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication> for IDebugApplication64 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplication> for &IDebugApplication64 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplication> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prptfocus: ::windows::core::RawPtr, bra: BREAKRESUME_ACTION, era: ERRORRESUMEACTION) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pad: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pad: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, rclsid: *const ::windows::core::GUID, punkouter: ::windows::core::RawPtr, dwclscontext: u32, riid: *const ::windows::core::GUID, ppvobject: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pperdat: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdanroot: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppedec: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrname: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstr: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, br: BREAKREASON, pbra: *mut BREAKRESUME_ACTION) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pabf: *mut u32, pprdatsteppingthread: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pat: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, psdo: ::windows::core::RawPtr, ppado: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdsfs: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcookie: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppdannew: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, punk: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, perrordebug: ::windows::core::RawPtr, pscriptsite: ::windows::core::RawPtr, pbra: *mut BREAKRESUME_ACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdsfs: ::windows::core::RawPtr, pdwcookie: *mut u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcookie: u64) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationNode(pub ::windows::core::IUnknown);
impl IDebugApplicationNode {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self, dnt: DOCUMENTNAMETYPE) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__: <super::super::super::Foundation::BSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dnt), &mut result__).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetDocumentClassId(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: <::windows::core::GUID as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetDocument(&self) -> ::windows::core::Result<IDebugDocument> {
        let mut result__: <IDebugDocument as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugDocument>(result__)
    }
    pub unsafe fn EnumChildren(&self) -> ::windows::core::Result<IEnumDebugApplicationNodes> {
        let mut result__: <IEnumDebugApplicationNodes as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumDebugApplicationNodes>(result__)
    }
    pub unsafe fn GetParent(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__: <IDebugApplicationNode as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugApplicationNode>(result__)
    }
    pub unsafe fn SetDocumentProvider<'a, Param0: ::windows::core::IntoParam<'a, IDebugDocumentProvider>>(&self, pddp: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), pddp.into_param().abi()).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Attach<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, pdanparent: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), pdanparent.into_param().abi()).ok()
    }
    pub unsafe fn Detach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNode {
    type Vtable = IDebugApplicationNode_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c34_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugApplicationNode> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationNode) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationNode> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationNode) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplicationNode> for IDebugDocumentProvider {
    fn from(value: IDebugApplicationNode) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplicationNode> for IDebugDocumentProvider {
    fn from(value: &IDebugApplicationNode) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugDocumentProvider> for IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugDocumentProvider> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugDocumentProvider> for &IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugDocumentProvider> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IDebugApplicationNode> for IDebugDocumentInfo {
    fn from(value: IDebugApplicationNode) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplicationNode> for IDebugDocumentInfo {
    fn from(value: &IDebugApplicationNode) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugDocumentInfo> for IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugDocumentInfo> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugDocumentInfo> for &IDebugApplicationNode {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugDocumentInfo> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNode_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dnt: DOCUMENTNAMETYPE, pbstrname: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pclsiddocument: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppssd: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pperddp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pprddp: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pddp: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdanparent: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationNode100(pub ::windows::core::IUnknown);
impl IDebugApplicationNode100 {
    pub unsafe fn SetFilterForEventSink(&self, dwcookie: u32, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie), ::core::mem::transmute(filter)).ok()
    }
    pub unsafe fn GetExcludedDocuments(&self, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::Result<TEXT_DOCUMENT_ARRAY> {
        let mut result__: <TEXT_DOCUMENT_ARRAY as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(filter), &mut result__).from_abi::<TEXT_DOCUMENT_ARRAY>(result__)
    }
    pub unsafe fn QueryIsChildNode<'a, Param0: ::windows::core::IntoParam<'a, IDebugDocument>>(&self, psearchkey: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), psearchkey.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNode100 {
    type Vtable = IDebugApplicationNode100_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90a7734e_841b_4f77_9384_a2891e76e7e2);
}
impl ::core::convert::From<IDebugApplicationNode100> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationNode100) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationNode100> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationNode100) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationNode100 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationNode100 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNode100_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwcookie: u32, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, filter: APPLICATION_NODE_EVENT_FILTER, pdocuments: *mut TEXT_DOCUMENT_ARRAY) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, psearchkey: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationNodeEvents(pub ::windows::core::IUnknown);
impl IDebugApplicationNodeEvents {
    pub unsafe fn onAddChild<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpchild: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn onRemoveChild<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpchild: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn onAttach<'a, Param0: ::windows::core::IntoParam<'a, IDebugApplicationNode>>(&self, prddpparent: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), prddpparent.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNodeEvents {
    type Vtable = IDebugApplicationNodeEvents_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c35_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugApplicationNodeEvents> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationNodeEvents) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationNodeEvents> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationNodeEvents) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationNodeEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationNodeEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNodeEvents_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpchild: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpchild: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prddpparent: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationThread(pub ::windows::core::IUnknown);
impl IDebugApplicationThread {
    pub unsafe fn GetSystemThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IRemoteDebugApplication> {
        let mut result__: <IRemoteDebugApplication as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IRemoteDebugApplication>(result__)
    }
    pub unsafe fn EnumStackFrames(&self) -> ::windows::core::Result<IEnumDebugStackFrames> {
        let mut result__: <IEnumDebugStackFrames as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumDebugStackFrames>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self, pbstrdescription: *mut super::super::super::Foundation::BSTR, pbstrstate: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrdescription), ::core::mem::transmute(pbstrstate)).ok()
    }
    pub unsafe fn SetNextStatement<'a, Param0: ::windows::core::IntoParam<'a, IDebugStackFrame>, Param1: ::windows::core::IntoParam<'a, IDebugCodeContext>>(&self, pstackframe: Param0, pcodecontext: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pstackframe.into_param().abi(), pcodecontext.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Suspend(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetSuspendCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SynchronousCallIntoThread32<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pstcb: Param0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), pstcb.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn QueryIsCurrentThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn QueryIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDescription<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrdescription: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), pstrdescription.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStateString<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrstate: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pstrstate.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread {
    type Vtable = IDebugApplicationThread_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c38_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugApplicationThread> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationThread) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationThread> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationThread) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationThread {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationThread {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplicationThread> for IRemoteDebugApplicationThread {
    fn from(value: IDebugApplicationThread) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplicationThread> for IRemoteDebugApplicationThread {
    fn from(value: &IDebugApplicationThread) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread> for IDebugApplicationThread {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplicationThread> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread> for &IDebugApplicationThread {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplicationThread> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwthreadid: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pprda: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppedsf: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrdescription: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pbstrstate: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstackframe: ::windows::core::RawPtr, pcodecontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstate: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstcb: ::windows::core::RawPtr, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrdescription: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrstate: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationThread11032(pub ::windows::core::IUnknown);
impl IDebugApplicationThread11032 {
    pub unsafe fn GetActiveThreadRequestCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSuspendedForBreakPoint(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsThreadCallable(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn AsynchronousCallIntoThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread11032 {
    type Vtable = IDebugApplicationThread11032_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2194ac5c_6561_404a_a2e9_f57d72de3702);
}
impl ::core::convert::From<IDebugApplicationThread11032> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationThread11032) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationThread11032> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationThread11032) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationThread11032 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationThread11032 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread11032_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, puithreadrequests: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pfissuspended: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pfiscallable: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationThread11064(pub ::windows::core::IUnknown);
impl IDebugApplicationThread11064 {
    pub unsafe fn GetActiveThreadRequestCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSuspendedForBreakPoint(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsThreadCallable(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn AsynchronousCallIntoThread<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall64>>(&self, pptc: Param0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), pptc.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread11064 {
    type Vtable = IDebugApplicationThread11064_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x420aa4cc_efd8_4dac_983b_47127826917d);
}
impl ::core::convert::From<IDebugApplicationThread11064> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationThread11064) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationThread11064> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationThread11064) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationThread11064 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationThread11064 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread11064_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, puithreadrequests: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pfissuspended: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pfiscallable: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pptc: ::windows::core::RawPtr, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationThread64(pub ::windows::core::IUnknown);
impl IDebugApplicationThread64 {
    pub unsafe fn GetSystemThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IRemoteDebugApplication> {
        let mut result__: <IRemoteDebugApplication as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IRemoteDebugApplication>(result__)
    }
    pub unsafe fn EnumStackFrames(&self) -> ::windows::core::Result<IEnumDebugStackFrames> {
        let mut result__: <IEnumDebugStackFrames as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IEnumDebugStackFrames>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self, pbstrdescription: *mut super::super::super::Foundation::BSTR, pbstrstate: *mut super::super::super::Foundation::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbstrdescription), ::core::mem::transmute(pbstrstate)).ok()
    }
    pub unsafe fn SetNextStatement<'a, Param0: ::windows::core::IntoParam<'a, IDebugStackFrame>, Param1: ::windows::core::IntoParam<'a, IDebugCodeContext>>(&self, pstackframe: Param0, pcodecontext: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), pstackframe.into_param().abi(), pcodecontext.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Suspend(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetSuspendCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SynchronousCallIntoThread32<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall32>>(&self, pstcb: Param0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), pstcb.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
    pub unsafe fn QueryIsCurrentThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn QueryIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDescription<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrdescription: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), pstrdescription.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStateString<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pstrstate: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), pstrstate.into_param().abi()).ok()
    }
    pub unsafe fn SynchronousCallIntoThread64<'a, Param0: ::windows::core::IntoParam<'a, IDebugThreadCall64>>(&self, pstcb: Param0, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), pstcb.into_param().abi(), ::core::mem::transmute(dwparam1), ::core::mem::transmute(dwparam2), ::core::mem::transmute(dwparam3)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread64 {
    type Vtable = IDebugApplicationThread64_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9dac5886_dbad_456d_9dee_5dec39ab3dda);
}
impl ::core::convert::From<IDebugApplicationThread64> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationThread64) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationThread64> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationThread64) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IDebugApplicationThread64> for IDebugApplicationThread {
    fn from(value: IDebugApplicationThread64) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplicationThread64> for IDebugApplicationThread {
    fn from(value: &IDebugApplicationThread64) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugApplicationThread> for IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugApplicationThread> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IDebugApplicationThread> for &IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, IDebugApplicationThread> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IDebugApplicationThread64> for IRemoteDebugApplicationThread {
    fn from(value: IDebugApplicationThread64) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDebugApplicationThread64> for IRemoteDebugApplicationThread {
    fn from(value: &IDebugApplicationThread64) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread> for IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplicationThread> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IRemoteDebugApplicationThread> for &IDebugApplicationThread64 {
    fn into_param(self) -> ::windows::core::Param<'a, IRemoteDebugApplicationThread> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread64_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dwthreadid: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pprda: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppedsf: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pbstrdescription: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pbstrstate: *mut ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstackframe: ::windows::core::RawPtr, pcodecontext: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstate: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstcb: ::windows::core::RawPtr, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrdescription: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstrstate: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, pstcb: ::windows::core::RawPtr, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugApplicationThreadEvents110(pub ::windows::core::IUnknown);
impl IDebugApplicationThreadEvents110 {
    pub unsafe fn OnSuspendForBreakPoint(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn OnResumeFromBreakPoint(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn OnThreadRequestComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn OnBeginThreadRequest(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThreadEvents110 {
    type Vtable = IDebugApplicationThreadEvents110_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x84e5e468_d5da_48a8_83f4_40366429007b);
}
impl ::core::convert::From<IDebugApplicationThreadEvents110> for ::windows::core::IUnknown {
    fn from(value: IDebugApplicationThreadEvents110) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugApplicationThreadEvents110> for ::windows::core::IUnknown {
    fn from(value: &IDebugApplicationThreadEvents110) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugApplicationThreadEvents110 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugApplicationThreadEvents110 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThreadEvents110_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAsyncOperation(pub ::windows::core::IUnknown);
impl IDebugAsyncOperation {
    pub unsafe fn GetSyncDebugOperation(&self) -> ::windows::core::Result<IDebugSyncOperation> {
        let mut result__: <IDebugSyncOperation as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugSyncOperation>(result__)
    }
    pub unsafe fn Start<'a, Param0: ::windows::core::IntoParam<'a, IDebugAsyncOperationCallBack>>(&self, padocb: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), padocb.into_param().abi()).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn QueryIsComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetResult(&self, phrresult: *mut ::windows::core::HRESULT, ppunkresult: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(phrresult), ::core::mem::transmute(ppunkresult)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAsyncOperation {
    type Vtable = IDebugAsyncOperation_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c1b_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugAsyncOperation> for ::windows::core::IUnknown {
    fn from(value: IDebugAsyncOperation) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAsyncOperation> for ::windows::core::IUnknown {
    fn from(value: &IDebugAsyncOperation) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAsyncOperation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAsyncOperation {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAsyncOperation_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, ppsdo: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, padocb: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, phrresult: *mut ::windows::core::HRESULT, ppunkresult: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugAsyncOperationCallBack(pub ::windows::core::IUnknown);
impl IDebugAsyncOperationCallBack {
    pub unsafe fn onComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugAsyncOperationCallBack {
    type Vtable = IDebugAsyncOperationCallBack_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c1c_cb0c_11d0_b5c9_00a0244a0e7a);
}
impl ::core::convert::From<IDebugAsyncOperationCallBack> for ::windows::core::IUnknown {
    fn from(value: IDebugAsyncOperationCallBack) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugAsyncOperationCallBack> for ::windows::core::IUnknown {
    fn from(value: &IDebugAsyncOperationCallBack) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugAsyncOperationCallBack {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugAsyncOperationCallBack {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAsyncOperationCallBack_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugBreakpoint(pub ::windows::core::IUnknown);
impl IDebugBreakpoint {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(breaktype), ::core::mem::transmute(proctype)).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(offset)).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(count)).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(thread)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommand(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(commandsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, command: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), command.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOffsetExpression(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(expressionsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOffsetExpression<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, expression: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self) -> ::windows::core::Result<DEBUG_BREAKPOINT_PARAMETERS> {
        let mut result__: <DEBUG_BREAKPOINT_PARAMETERS as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), &mut result__).from_abi::<DEBUG_BREAKPOINT_PARAMETERS>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint {
    type Vtable = IDebugBreakpoint_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5bd9d474_5975_423a_b88b_65a8e7110e65);
}
impl ::core::convert::From<IDebugBreakpoint> for ::windows::core::IUnknown {
    fn from(value: IDebugBreakpoint) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugBreakpoint> for ::windows::core::IUnknown {
    fn from(value: &IDebugBreakpoint) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugBreakpoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugBreakpoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, adder: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: *mut u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, thread: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, command: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, expression: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugBreakpoint2(pub ::windows::core::IUnknown);
impl IDebugBreakpoint2 {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(breaktype), ::core::mem::transmute(proctype)).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(offset)).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(count)).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(thread)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommand(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(commandsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, command: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), command.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOffsetExpression(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(expressionsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOffsetExpression<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, expression: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self) -> ::windows::core::Result<DEBUG_BREAKPOINT_PARAMETERS> {
        let mut result__: <DEBUG_BREAKPOINT_PARAMETERS as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), &mut result__).from_abi::<DEBUG_BREAKPOINT_PARAMETERS>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommandWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(commandsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommandWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, command: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), command.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(expressionsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOffsetExpressionWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, expression: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), expression.into_param().abi()).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint2 {
    type Vtable = IDebugBreakpoint2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b278d20_79f2_426e_a3f9_c1ddf375d48e);
}
impl ::core::convert::From<IDebugBreakpoint2> for ::windows::core::IUnknown {
    fn from(value: IDebugBreakpoint2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugBreakpoint2> for ::windows::core::IUnknown {
    fn from(value: &IDebugBreakpoint2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugBreakpoint2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugBreakpoint2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, adder: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: *mut u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, thread: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, command: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, expression: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, command: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, expression: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugBreakpoint3(pub ::windows::core::IUnknown);
impl IDebugBreakpoint3 {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(breaktype), ::core::mem::transmute(proctype)).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(::core::mem::transmute_copy(self), ::core::mem::transmute(offset)).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(accesstype)).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), ::core::mem::transmute(count)).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(thread)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommand(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(commandsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, command: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), command.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOffsetExpression(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(expressionsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOffsetExpression<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, expression: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self) -> ::windows::core::Result<DEBUG_BREAKPOINT_PARAMETERS> {
        let mut result__: <DEBUG_BREAKPOINT_PARAMETERS as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), &mut result__).from_abi::<DEBUG_BREAKPOINT_PARAMETERS>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCommandWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(commandsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCommandWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, command: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self), command.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(expressionsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOffsetExpressionWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, expression: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetGuid(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: <::windows::core::GUID as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), &mut result__).from_abi::<::windows::core::GUID>(result__)
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint3 {
    type Vtable = IDebugBreakpoint3_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38f5c249_b448_43bb_9835_579d4ec02249);
}
impl ::core::convert::From<IDebugBreakpoint3> for ::windows::core::IUnknown {
    fn from(value: IDebugBreakpoint3) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugBreakpoint3> for ::windows::core::IUnknown {
    fn from(value: &IDebugBreakpoint3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugBreakpoint3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugBreakpoint3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint3_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, adder: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: *mut u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, offset: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, count: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, id: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, thread: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, command: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, expression: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, command: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, expression: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, guid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugClient(pub ::windows::core::IUnknown);
impl IDebugClient {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernel<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServer<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(ids), ::core::mem::transmute(count), ::core::mem::transmute(actualcount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttach<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), dumpfile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier)).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(historylimit)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServers<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn ExitDispatch<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__: <IDebugInputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugInputCallbacks>(result__)
    }
    pub unsafe fn SetInputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugInputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__: <IDebugOutputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacks>(result__)
    }
    pub unsafe fn SetOutputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), client.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), client.into_param().abi(), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(columns)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefix(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefix<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentity(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentity<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__: <IDebugEventCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).45)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacks>(result__)
    }
    pub unsafe fn SetEventCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient {
    type Vtable = IDebugClient_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x27fe5639_8407_4f47_8364_ee118fb08ac8);
}
impl ::core::convert::From<IDebugClient> for ::windows::core::IUnknown {
    fn from(value: IDebugClient) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugClient> for ::windows::core::IUnknown {
    fn from(value: &IDebugClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugClient {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, connectoptions: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, options: super::super::super::Foundation::PSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, remoteoptions: super::super::super::Foundation::PSTR, server: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, machine: super::super::super::Foundation::PSTR, flags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, code: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prefix: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, flags: u32, format: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugClient2(pub ::windows::core::IUnknown);
impl IDebugClient2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernel<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServer<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(ids), ::core::mem::transmute(count), ::core::mem::transmute(actualcount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttach<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), dumpfile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier)).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(historylimit)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServers<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn ExitDispatch<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__: <IDebugInputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugInputCallbacks>(result__)
    }
    pub unsafe fn SetInputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugInputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__: <IDebugOutputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacks>(result__)
    }
    pub unsafe fn SetOutputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), client.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), client.into_param().abi(), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(columns)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefix(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefix<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentity(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentity<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__: <IDebugEventCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).45)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacks>(result__)
    }
    pub unsafe fn SetEventCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile2<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32, formatflags: u32, comment: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, infofile: Param0, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(::core::mem::transmute_copy(self), infofile.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(::core::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient2 {
    type Vtable = IDebugClient2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedbed635_372e_4dab_bbfe_ed0d2f63be81);
}
impl ::core::convert::From<IDebugClient2> for ::windows::core::IUnknown {
    fn from(value: IDebugClient2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugClient2> for ::windows::core::IUnknown {
    fn from(value: &IDebugClient2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugClient2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugClient2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, connectoptions: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, options: super::super::super::Foundation::PSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, remoteoptions: super::super::super::Foundation::PSTR, server: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, machine: super::super::super::Foundation::PSTR, flags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, code: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prefix: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, flags: u32, format: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32, formatflags: u32, comment: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, infofile: super::super::super::Foundation::PSTR, r#type: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugClient3(pub ::windows::core::IUnknown);
impl IDebugClient3 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernel<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServer<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(ids), ::core::mem::transmute(count), ::core::mem::transmute(actualcount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttach<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), dumpfile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier)).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(historylimit)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServers<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn ExitDispatch<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__: <IDebugInputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugInputCallbacks>(result__)
    }
    pub unsafe fn SetInputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugInputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__: <IDebugOutputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacks>(result__)
    }
    pub unsafe fn SetOutputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), client.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), client.into_param().abi(), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(columns)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefix(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefix<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentity(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentity<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__: <IDebugEventCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).45)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacks>(result__)
    }
    pub unsafe fn SetEventCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile2<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32, formatflags: u32, comment: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, infofile: Param0, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(::core::mem::transmute_copy(self), infofile.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).56)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttachWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient3 {
    type Vtable = IDebugClient3_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdd492d7f_71b8_4ad6_a8dc_1c887479ff91);
}
impl ::core::convert::From<IDebugClient3> for ::windows::core::IUnknown {
    fn from(value: IDebugClient3) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugClient3> for ::windows::core::IUnknown {
    fn from(value: &IDebugClient3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugClient3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugClient3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient3_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, connectoptions: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, options: super::super::super::Foundation::PSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, remoteoptions: super::super::super::Foundation::PSTR, server: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, machine: super::super::super::Foundation::PSTR, flags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, code: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prefix: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, flags: u32, format: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32, formatflags: u32, comment: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, infofile: super::super::super::Foundation::PSTR, r#type: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PWSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugClient4(pub ::windows::core::IUnknown);
impl IDebugClient4 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernel<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServer<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(ids), ::core::mem::transmute(count), ::core::mem::transmute(actualcount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttach<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), dumpfile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier)).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(historylimit)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServers<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn ExitDispatch<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__: <IDebugInputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugInputCallbacks>(result__)
    }
    pub unsafe fn SetInputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugInputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__: <IDebugOutputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacks>(result__)
    }
    pub unsafe fn SetOutputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), client.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), client.into_param().abi(), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(columns)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefix(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefix<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentity(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentity<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__: <IDebugEventCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).45)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacks>(result__)
    }
    pub unsafe fn SetEventCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile2<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32, formatflags: u32, comment: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, infofile: Param0, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(::core::mem::transmute_copy(self), infofile.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).56)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttachWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64, qualifier: u32, formatflags: u32, comment: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).63)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(namesize), ::core::mem::transmute(handle), ::core::mem::transmute(r#type)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(namesize), ::core::mem::transmute(handle), ::core::mem::transmute(r#type)).ok()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient4 {
    type Vtable = IDebugClient4_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xca83c3de_5089_4cf8_93c8_d892387f2a5e);
}
impl ::core::convert::From<IDebugClient4> for ::windows::core::IUnknown {
    fn from(value: IDebugClient4) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IDebugClient4> for ::windows::core::IUnknown {
    fn from(value: &IDebugClient4) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IDebugClient4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IDebugClient4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient4_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, connectoptions: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, options: super::super::super::Foundation::PSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, remoteoptions: super::super::super::Foundation::PSTR, server: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, options: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, machine: super::super::super::Foundation::PSTR, flags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, flags: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, code: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, client: ::windows::core::RawPtr, mask: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, columns: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, prefix: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, outputcontrol: u32, flags: u32, format: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, callbacks: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, dumpfile: super::super::super::Foundation::PSTR, qualifier: u32, formatflags: u32, comment: super::super::super::Foundation::PSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, infofile: super::super::super::Foundation::PSTR, r#type: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, timeout: u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, exename: super::super::super::Foundation::PWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PWSTR, createflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, server: u64, commandline: super::super::super::Foundation::PWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, filename: super::super::super::Foundation::PWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, filename: super::super::super::Foundation::PWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: super::super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, filename: super::super::super::Foundation::PWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, number: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, index: u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, index: u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IDebugClient5(pub ::windows::core::IUnknown);
impl IDebugClient5 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernel<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptions<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServer<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(ids), ::core::mem::transmute(count), ::core::mem::transmute(actualcount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessA<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttach<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).15)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self), ::core::mem::transmute(options)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self), dumpfile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier)).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), ::core::mem::transmute(historylimit)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServers<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).27)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn ExitDispatch<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(::core::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__: <IDebugClient as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).30)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugClient>(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__: <IDebugInputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugInputCallbacks>(result__)
    }
    pub unsafe fn SetInputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugInputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__: <IDebugOutputCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).33)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacks>(result__)
    }
    pub unsafe fn SetOutputCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).35)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(::core::mem::transmute_copy(self), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).37)(::core::mem::transmute_copy(self), client.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOtherOutputMask<'a, Param0: ::windows::core::IntoParam<'a, IDebugClient>>(&self, client: Param0, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(::core::mem::transmute_copy(self), client.into_param().abi(), ::core::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).39)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self), ::core::mem::transmute(columns)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefix(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefix<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentity(&self, buffer: super::super::super::Foundation::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentity<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__: <IDebugEventCallbacks as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).45)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacks>(result__)
    }
    pub unsafe fn SetEventCallbacks<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacks>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFile2<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, dumpfile: Param0, qualifier: u32, formatflags: u32, comment: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(::core::mem::transmute_copy(self), dumpfile.into_param().abi(), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, infofile: Param0, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(::core::mem::transmute_copy(self), infofile.into_param().abi(), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(::core::mem::transmute_copy(self), ::core::mem::transmute(server)).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self), ::core::mem::transmute(timeout)).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(::core::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, exename: Param1, flags: u32) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).56)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), exename.into_param().abi(), ::core::mem::transmute(flags), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: super::super::super::Foundation::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: super::super::super::Foundation::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(server),
            ::core::mem::transmute(systemid),
            ::core::mem::transmute(flags),
            ::core::mem::transmute(exename),
            ::core::mem::transmute(exenamesize),
            ::core::mem::transmute(actualexenamesize),
            ::core::mem::transmute(description),
            ::core::mem::transmute(descriptionsize),
            ::core::mem::transmute(actualdescriptionsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcessAndAttachWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, server: u64, commandline: Param1, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(createflags), ::core::mem::transmute(processid), ::core::mem::transmute(attachflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenDumpFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteDumpFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64, qualifier: u32, formatflags: u32, comment: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle), ::core::mem::transmute(qualifier), ::core::mem::transmute(formatflags), comment.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDumpInformationFileWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, filename: Param0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(filehandle), ::core::mem::transmute(r#type)).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__: <u32 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).63)(::core::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: super::super::super::Foundation::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(namesize), ::core::mem::transmute(handle), ::core::mem::transmute(r#type)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(::core::mem::transmute_copy(self), ::core::mem::transmute(index), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(namesize), ::core::mem::transmute(handle), ::core::mem::transmute(r#type)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AttachKernelWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, flags: u32, connectoptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).66)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), connectoptions.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).67)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(optionssize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKernelConnectionOptionsWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).68)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartProcessServerWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, flags: u32, options: Param1, reserved: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).69)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), options.into_param().abi(), ::core::mem::transmute(reserved)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConnectProcessServerWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, remoteoptions: Param0) -> ::windows::core::Result<u64> {
        let mut result__: <u64 as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).70)(::core::mem::transmute_copy(self), remoteoptions.into_param().abi(), &mut result__).from_abi::<u64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StartServerWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, options: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).71)(::core::mem::transmute_copy(self), options.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputServersWide<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, outputcontrol: u32, machine: Param1, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).72)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), machine.into_param().abi(), ::core::mem::transmute(flags)).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> ::windows::core::Result<IDebugOutputCallbacksWide> {
        let mut result__: <IDebugOutputCallbacksWide as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).73)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugOutputCallbacksWide>(result__)
    }
    pub unsafe fn SetOutputCallbacksWide<'a, Param0: ::windows::core::IntoParam<'a, IDebugOutputCallbacksWide>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).74)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).75)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(prefixsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputLinePrefixWide<'a, Param0: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, prefix: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).76)(::core::mem::transmute_copy(self), prefix.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIdentityWide(&self, buffer: super::super::super::Foundation::PWSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).77)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffersize), ::core::mem::transmute(identitysize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputIdentityWide<'a, Param2: ::windows::core::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, outputcontrol: u32, flags: u32, format: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).78)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputcontrol), ::core::mem::transmute(flags), format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> ::windows::core::Result<IDebugEventCallbacksWide> {
        let mut result__: <IDebugEventCallbacksWide as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).79)(::core::mem::transmute_copy(self), &mut result__).from_abi::<IDebugEventCallbacksWide>(result__)
    }
    pub unsafe fn SetEventCallbacksWide<'a, Param0: ::windows::core::IntoParam<'a, IDebugEventCallbacksWide>>(&self, callbacks: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).80)(::core::mem::transmute_copy(self), callbacks.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateProcess2<'a, Param1: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param4: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>, Param5: ::windows::core::IntoParam<'a, super::super::super::Foundation::PSTR>>(&self, server: u64, commandline: Param1, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: Param4, environment: Param5) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).81)(::core::mem::transmute_copy(self), ::core::mem::transmute(server), commandline.into_param().abi(), ::core::mem::transmute(optio