#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_ATTRIBUTE(pub i32);
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(0i32);
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(1i32);
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(2i32);
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(3i32);
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(4i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(5i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(6i32);
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(7i32);
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(8i32);
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(9i32);
impl ::core::convert::From<i32> for AMSI_ATTRIBUTE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for AMSI_ATTRIBUTE {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_RESULT(pub i32);
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = AMSI_RESULT(0i32);
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = AMSI_RESULT(1i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = AMSI_RESULT(16384i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = AMSI_RESULT(20479i32);
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = AMSI_RESULT(32768i32);
impl ::core::convert::From<i32> for AMSI_RESULT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for AMSI_RESULT {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_MSI_ACTION(pub i32);
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(0i32);
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(1i32);
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(2i32);
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(3i32);
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(4i32);
impl ::core::convert::From<i32> for AMSI_UAC_MSI_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for AMSI_UAC_MSI_ACTION {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: super::super::Foundation::PWSTR,
    pub lpwszSourceURL: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_AX_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_AX_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_AX_INFO").field("ulLength", &self.ulLength).field("lpwszLocalInstallPath", &self.lpwszLocalInstallPath).field("lpwszSourceURL", &self.lpwszSourceURL).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_AX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszLocalInstallPath == other.lpwszLocalInstallPath && self.lpwszSourceURL == other.lpwszSourceURL
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_AX_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: super::super::Foundation::PWSTR,
    pub lpwszRequestor: super::super::Foundation::PWSTR,
    pub Clsid: ::windows::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_COM_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_COM_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_COM_INFO").field("ulLength", &self.ulLength).field("lpwszServerBinary", &self.lpwszServerBinary).field("lpwszRequestor", &self.lpwszRequestor).field("Clsid", &self.Clsid).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_COM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszServerBinary == other.lpwszServerBinary && self.lpwszRequestor == other.lpwszRequestor && self.Clsid == other.Clsid
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_COM_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_CONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpwszDLLParameter: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_EXE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_EXE_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_EXE_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpwszDLLParameter", &self.lpwszDLLParameter).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_EXE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpwszDLLParameter == other.lpwszDLLParameter
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_EXE_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: super::super::Foundation::PWSTR,
    pub lpwszVersion: super::super::Foundation::PWSTR,
    pub lpwszLanguage: super::super::Foundation::PWSTR,
    pub lpwszManufacturer: super::super::Foundation::PWSTR,
    pub lpwszPackagePath: super::super::Foundation::PWSTR,
    pub lpwszPackageSource: super::super::Foundation::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut super::super::Foundation::PWSTR,
    pub ppwszUpdateSources: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_MSI_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_MSI_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_MSI_INFO")
            .field("ulLength", &self.ulLength)
            .field("MsiAction", &self.MsiAction)
            .field("lpwszProductName", &self.lpwszProductName)
            .field("lpwszVersion", &self.lpwszVersion)
            .field("lpwszLanguage", &self.lpwszLanguage)
            .field("lpwszManufacturer", &self.lpwszManufacturer)
            .field("lpwszPackagePath", &self.lpwszPackagePath)
            .field("lpwszPackageSource", &self.lpwszPackageSource)
            .field("ulUpdates", &self.ulUpdates)
            .field("ppwszUpdates", &self.ppwszUpdates)
            .field("ppwszUpdateSources", &self.ppwszUpdateSources)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_MSI_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength
            && self.MsiAction == other.MsiAction
            && self.lpwszProductName == other.lpwszProductName
            && self.lpwszVersion == other.lpwszVersion
            && self.lpwszLanguage == other.lpwszLanguage
            && self.lpwszManufacturer == other.lpwszManufacturer
            && self.lpwszPackagePath == other.lpwszPackagePath
            && self.lpwszPackageSource == other.lpwszPackageSource
            && self.ulUpdates == other.ulUpdates
            && self.ppwszUpdates == other.ppwszUpdates
            && self.ppwszUpdateSources == other.ppwszUpdateSources
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_MSI_INFO {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpPackageFamilyName: super::super::Foundation::PWSTR,
    pub lpApplicationId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_PACKAGED_APP_INFO")
            .field("ulLength", &self.ulLength)
            .field("lpwszApplicationName", &self.lpwszApplicationName)
            .field("lpwszCommandLine", &self.lpwszCommandLine)
            .field("lpPackageFamilyName", &self.lpPackageFamilyName)
            .field("lpApplicationId", &self.lpApplicationId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpPackageFamilyName == other.lpPackageFamilyName && self.lpApplicationId == other.lpApplicationId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_REQUEST_TYPE(pub i32);
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(0i32);
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(1i32);
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(2i32);
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(3i32);
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(4i32);
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(5i32);
impl ::core::convert::From<i32> for AMSI_UAC_REQUEST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for AMSI_UAC_REQUEST_TYPE {
    type Abi = Self;
}
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: marker :: Copy, :: core :: clone :: Clone, :: core :: default :: Default, :: core :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_TRUST_STATE(pub i32);
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(0i32);
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(1i32);
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(2i32);
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(3i32);
impl ::core::convert::From<i32> for AMSI_UAC_TRUST_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::core::Abi for AMSI_UAC_TRUST_STATE {
    type Abi = Self;
}
#[inline]
pub unsafe fn AmsiCloseSession<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, amsisession: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiCloseSession(amsicontext: HAMSICONTEXT, amsisession: HAMSISESSION);
        }
        ::core::mem::transmute(AmsiCloseSession(amsicontext.into_param().abi(), amsisession.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiInitialize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(appname: Param0) -> ::windows::core::Result<HAMSICONTEXT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiInitialize(appname: super::super::Foundation::PWSTR, amsicontext: *mut HAMSICONTEXT) -> ::windows::core::HRESULT;
        }
        let mut result__: <HAMSICONTEXT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        AmsiInitialize(appname.into_param().abi(), &mut result__).from_abi::<HAMSICONTEXT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiNotifyOperation<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(amsicontext: Param0, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiNotifyOperation(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        AmsiNotifyOperation(amsicontext.into_param().abi(), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn AmsiOpenSession<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) -> ::windows::core::Result<HAMSISESSION> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiOpenSession(amsicontext: HAMSICONTEXT, amsisession: *mut HAMSISESSION) -> ::windows::core::HRESULT;
        }
        let mut result__: <HAMSISESSION as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        AmsiOpenSession(amsicontext.into_param().abi(), &mut result__).from_abi::<HAMSISESSION>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanBuffer<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param3, amsisession: Param4) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanBuffer(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        AmsiScanBuffer(amsicontext.into_param().abi(), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanString<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, string: Param1, contentname: Param2, amsisession: Param3) -> ::windows::core::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanString(amsicontext: HAMSICONTEXT, string: super::super::Foundation::PWSTR, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        AmsiScanString(amsicontext.into_param().abi(), string.into_param().abi(), contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn AmsiUninitialize<'a, Param0: ::windows::core::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiUninitialize(amsicontext: HAMSICONTEXT);
        }
        ::core::mem::transmute(AmsiUninitialize(amsicontext.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const CAntimalware: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfdb00e52_a214_4aa1_8fba_4357bb0072ec);
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy, :: core :: fmt :: Debug, :: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
#[repr(transparent)]
pub struct HAMSICONTEXT(pub isize);
impl ::core::default::Default for HAMSICONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
unsafe impl ::windows::core::Handle for HAMSICONTEXT {}
unsafe impl ::windows::core::Abi for HAMSICONTEXT {
    type Abi = Self;
}
#[derive(:: core :: clone :: Clone, :: core :: marker :: Copy, :: core :: fmt :: Debug, :: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
#[repr(transparent)]
pub struct HAMSISESSION(pub isize);
impl ::core::default::Default for HAMSISESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
unsafe impl ::windows::core::Handle for HAMSISESSION {}
unsafe impl ::windows::core::Abi for HAMSISESSION {
    type Abi = Self;
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAmsiStream(pub ::windows::core::IUnknown);
impl IAmsiStream {
    pub unsafe fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(attribute), ::core::mem::transmute(datasize), ::core::mem::transmute(data), ::core::mem::transmute(retdata)).ok()
    }
    pub unsafe fn Read(&self, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(position), ::core::mem::transmute(size), ::core::mem::transmute(buffer), ::core::mem::transmute(readsize)).ok()
    }
}
unsafe impl ::windows::core::Interface for IAmsiStream {
    type Vtable = IAmsiStream_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e47f2e5_81d4_4d3b_897f_545096770373);
}
impl ::core::convert::From<IAmsiStream> for ::windows::core::IUnknown {
    fn from(value: IAmsiStream) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAmsiStream> for ::windows::core::IUnknown {
    fn from(value: &IAmsiStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAmsiStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAmsiStream {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmsiStream_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAntimalware(pub ::windows::core::IUnknown);
impl IAntimalware {
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(result), ::core::mem::transmute(provider)).ok()
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session)))
    }
}
unsafe impl ::windows::core::Interface for IAntimalware {
    type Vtable = IAntimalware_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82d29c2e_f062_44e6_b5c9_3d9a2f24a2df);
}
impl ::core::convert::From<IAntimalware> for ::windows::core::IUnknown {
    fn from(value: IAntimalware) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAntimalware> for ::windows::core::IUnknown {
    fn from(value: &IAntimalware) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalware {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAntimalware {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, session: u64),
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAntimalware2(pub ::windows::core::IUnknown);
impl IAntimalware2 {
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), ::core::mem::transmute(result), ::core::mem::transmute(provider)).ok()
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Notify<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
}
unsafe impl ::windows::core::Interface for IAntimalware2 {
    type Vtable = IAntimalware2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x301035b5_2d42_4f56_8c65_2dcaa7fb3cdc);
}
impl ::core::convert::From<IAntimalware2> for ::windows::core::IUnknown {
    fn from(value: IAntimalware2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAntimalware2> for ::windows::core::IUnknown {
    fn from(value: &IAntimalware2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IAntimalware2> for IAntimalware {
    fn from(value: IAntimalware2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalware2> for IAntimalware {
    fn from(value: &IAntimalware2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalware> for IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalware> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalware> for &IAntimalware2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalware> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAntimalwareProvider(pub ::windows::core::IUnknown);
impl IAntimalwareProvider {
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider {
    type Vtable = IAntimalwareProvider_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe3_fe04_42b1_a5df_08d483d4d125);
}
impl ::core::convert::From<IAntimalwareProvider> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareProvider) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAntimalwareProvider> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAntimalwareProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAntimalwareProvider2(pub ::windows::core::IUnknown);
impl IAntimalwareProvider2 {
    pub unsafe fn Scan<'a, Param0: ::windows::core::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), stream.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), ::core::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Notify<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider2 {
    type Vtable = IAntimalwareProvider2_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c1e6570_3f73_4e0f_8ad4_98b94cd3290f);
}
impl ::core::convert::From<IAntimalwareProvider2> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareProvider2) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAntimalwareProvider2> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareProvider2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
impl ::core::convert::From<IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: IAntimalwareProvider2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: &IAntimalwareProvider2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalwareProvider> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalwareProvider> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAntimalwareProvider> for &IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAntimalwareProvider> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider2_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, stream: ::windows::core::RawPtr, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq, :: core :: clone :: Clone, :: core :: fmt :: Debug)]
pub struct IAntimalwareUacProvider(pub ::windows::core::IUnknown);
impl IAntimalwareUacProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self), ::core::mem::transmute(context), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::core::Abi>::Abi = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(::core::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareUacProvider {
    type Vtable = IAntimalwareUacProvider_abi;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe4_fe04_42b1_a5df_08d483d4d125);
}
impl ::core::convert::From<IAntimalwareUacProvider> for ::windows::core::IUnknown {
    fn from(value: IAntimalwareUacProvider) -> Self {
        value.0
    }
}
impl ::core::convert::From<&IAntimalwareUacProvider> for ::windows::core::IUnknown {
    fn from(value: &IAntimalwareUacProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(self.0)
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareUacProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr, iid: &::windows::core::GUID, interface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::core::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, context: *const AMSI_UAC_REQUEST_CONTEXT, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::core::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn InstallELAMCertificateInfo<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(elamfile: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn InstallELAMCertificateInfo(elamfile: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(InstallELAMCertificateInfo(elamfile.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
