#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_ALLOWED_ACE_TYPE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_ALLOWED_CALLBACK_ACE_TYPE: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_ALLOWED_COMPOUND_ACE_TYPE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_ALLOWED_OBJECT_ACE_TYPE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_DENIED_ACE_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_DENIED_CALLBACK_ACE_TYPE: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_DENIED_OBJECT_ACE_TYPE: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_FILTER_SECURITY_INFORMATION: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_LEVEL: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_ACE_TYPE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_OBJECT_ACE_TYPE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_V2_ACE_TYPE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_V3_ACE_TYPE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_V4_ACE_TYPE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MAX_MS_V5_ACE_TYPE: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MIN_MS_ACE_TYPE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_MIN_MS_OBJECT_ACE_TYPE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_OBJECT_GUID: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_PROPERTY_GUID: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_PROPERTY_SET_GUID: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ACCESS_REASONS {
    pub Data: [u32; 32],
}
impl ACCESS_REASONS {}
impl ::std::default::Default for ACCESS_REASONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ACCESS_REASONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ACCESS_REASONS").field("Data", &self.Data).finish()
    }
}
impl ::std::cmp::PartialEq for ACCESS_REASONS {
    fn eq(&self, other: &Self) -> bool {
        self.Data == other.Data
    }
}
impl ::std::cmp::Eq for ACCESS_REASONS {}
unsafe impl ::windows::runtime::Abi for ACCESS_REASONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_REASON_DATA_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_REASON_EXDATA_MASK: u32 = 2130706432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_REASON_STAGING_MASK: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ACCESS_REASON_TYPE(pub i32);
pub const AccessReasonNone: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(0i32);
pub const AccessReasonAllowedAce: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(65536i32);
pub const AccessReasonDeniedAce: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(131072i32);
pub const AccessReasonAllowedParentAce: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(196608i32);
pub const AccessReasonDeniedParentAce: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(262144i32);
pub const AccessReasonNotGrantedByCape: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(327680i32);
pub const AccessReasonNotGrantedByParentCape: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(393216i32);
pub const AccessReasonNotGrantedToAppContainer: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(458752i32);
pub const AccessReasonMissingPrivilege: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(1048576i32);
pub const AccessReasonFromPrivilege: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(2097152i32);
pub const AccessReasonIntegrityLevel: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(3145728i32);
pub const AccessReasonOwnership: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(4194304i32);
pub const AccessReasonNullDacl: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(5242880i32);
pub const AccessReasonEmptyDacl: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(6291456i32);
pub const AccessReasonNoSD: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(7340032i32);
pub const AccessReasonNoGrant: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(8388608i32);
pub const AccessReasonTrustLabel: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(9437184i32);
pub const AccessReasonFilterAce: ACCESS_REASON_TYPE = ACCESS_REASON_TYPE(10485760i32);
impl ::std::convert::From<i32> for ACCESS_REASON_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ACCESS_REASON_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_REASON_TYPE_MASK: u32 = 16711680u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACCESS_SYSTEM_SECURITY: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACL_REVISION1: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACL_REVISION2: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACL_REVISION3: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACL_REVISION4: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACPI_PPM_HARDWARE_ALL: u32 = 254u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACPI_PPM_SOFTWARE_ALL: u32 = 252u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACPI_PPM_SOFTWARE_ANY: u32 = 253u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ACTIVATION_CONTEXT_INFO_CLASS(pub i32);
pub const ActivationContextBasicInformation: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(1i32);
pub const ActivationContextDetailedInformation: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(2i32);
pub const AssemblyDetailedInformationInActivationContext: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(3i32);
pub const FileInformationInAssemblyOfAssemblyInActivationContext: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(4i32);
pub const RunlevelInformationInActivationContext: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(5i32);
pub const CompatibilityInformationInActivationContext: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(6i32);
pub const ActivationContextManifestResourceName: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(7i32);
pub const MaxActivationContextInfoClass: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(8i32);
pub const AssemblyDetailedInformationInActivationContxt: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(3i32);
pub const FileInformationInAssemblyOfAssemblyInActivationContxt: ACTIVATION_CONTEXT_INFO_CLASS = ACTIVATION_CONTEXT_INFO_CLASS(4i32);
impl ::std::convert::From<i32> for ACTIVATION_CONTEXT_INFO_CLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ACTIVATION_CONTEXT_INFO_CLASS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_PATH_TYPE_ASSEMBLYREF: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_PATH_TYPE_NONE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_PATH_TYPE_URL: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_PATH_TYPE_WIN32_FILE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_APPLICATION_SETTINGS: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_CLR_SURROGATES: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_COMPATIBILITY_INFO: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_COM_INTERFACE_REDIRECTION: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_COM_PROGID_REDIRECTION: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_COM_SERVER_REDIRECTION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_COM_TYPE_LIBRARY_REDIRECTION: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_DLL_REDIRECTION: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_GLOBAL_OBJECT_RENAME_TABLE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_WINDOW_CLASS_REDIRECTION: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ACTIVATION_CONTEXT_SECTION_WINRT_ACTIVATABLE_CLASSES: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ALERT_SYSTEM_SEV(pub u32);
pub const ALERT_SYSTEM_INFORMATIONAL: ALERT_SYSTEM_SEV = ALERT_SYSTEM_SEV(1u32);
pub const ALERT_SYSTEM_WARNING: ALERT_SYSTEM_SEV = ALERT_SYSTEM_SEV(2u32);
pub const ALERT_SYSTEM_ERROR: ALERT_SYSTEM_SEV = ALERT_SYSTEM_SEV(3u32);
pub const ALERT_SYSTEM_QUERY: ALERT_SYSTEM_SEV = ALERT_SYSTEM_SEV(4u32);
pub const ALERT_SYSTEM_CRITICAL: ALERT_SYSTEM_SEV = ALERT_SYSTEM_SEV(5u32);
impl ::std::convert::From<u32> for ALERT_SYSTEM_SEV {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ALERT_SYSTEM_SEV {
    type Abi = Self;
}
impl ::std::ops::BitOr for ALERT_SYSTEM_SEV {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ALERT_SYSTEM_SEV {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ALERT_SYSTEM_SEV {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ALERT_SYSTEM_SEV {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ALERT_SYSTEM_SEV {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ALL_POWERSCHEMES_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1755441502, 5098, 16865, [128, 17, 12, 73, 108, 164, 144, 176]);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ALL_PROCESSOR_GROUPS: u32 = 65535u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ANON_OBJECT_HEADER {
    pub Sig1: u16,
    pub Sig2: u16,
    pub Version: u16,
    pub Machine: u16,
    pub TimeDateStamp: u32,
    pub ClassID: ::windows::runtime::GUID,
    pub SizeOfData: u32,
}
impl ANON_OBJECT_HEADER {}
impl ::std::default::Default for ANON_OBJECT_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ANON_OBJECT_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ANON_OBJECT_HEADER").field("Sig1", &self.Sig1).field("Sig2", &self.Sig2).field("Version", &self.Version).field("Machine", &self.Machine).field("TimeDateStamp", &self.TimeDateStamp).field("ClassID", &self.ClassID).field("SizeOfData", &self.SizeOfData).finish()
    }
}
impl ::std::cmp::PartialEq for ANON_OBJECT_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Sig1 == other.Sig1 && self.Sig2 == other.Sig2 && self.Version == other.Version && self.Machine == other.Machine && self.TimeDateStamp == other.TimeDateStamp && self.ClassID == other.ClassID && self.SizeOfData == other.SizeOfData
    }
}
impl ::std::cmp::Eq for ANON_OBJECT_HEADER {}
unsafe impl ::windows::runtime::Abi for ANON_OBJECT_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ANON_OBJECT_HEADER_BIGOBJ {
    pub Sig1: u16,
    pub Sig2: u16,
    pub Version: u16,
    pub Machine: u16,
    pub TimeDateStamp: u32,
    pub ClassID: ::windows::runtime::GUID,
    pub SizeOfData: u32,
    pub Flags: u32,
    pub MetaDataSize: u32,
    pub MetaDataOffset: u32,
    pub NumberOfSections: u32,
    pub PointerToSymbolTable: u32,
    pub NumberOfSymbols: u32,
}
impl ANON_OBJECT_HEADER_BIGOBJ {}
impl ::std::default::Default for ANON_OBJECT_HEADER_BIGOBJ {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ANON_OBJECT_HEADER_BIGOBJ {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ANON_OBJECT_HEADER_BIGOBJ")
            .field("Sig1", &self.Sig1)
            .field("Sig2", &self.Sig2)
            .field("Version", &self.Version)
            .field("Machine", &self.Machine)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("ClassID", &self.ClassID)
            .field("SizeOfData", &self.SizeOfData)
            .field("Flags", &self.Flags)
            .field("MetaDataSize", &self.MetaDataSize)
            .field("MetaDataOffset", &self.MetaDataOffset)
            .field("NumberOfSections", &self.NumberOfSections)
            .field("PointerToSymbolTable", &self.PointerToSymbolTable)
            .field("NumberOfSymbols", &self.NumberOfSymbols)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ANON_OBJECT_HEADER_BIGOBJ {
    fn eq(&self, other: &Self) -> bool {
        self.Sig1 == other.Sig1
            && self.Sig2 == other.Sig2
            && self.Version == other.Version
            && self.Machine == other.Machine
            && self.TimeDateStamp == other.TimeDateStamp
            && self.ClassID == other.ClassID
            && self.SizeOfData == other.SizeOfData
            && self.Flags == other.Flags
            && self.MetaDataSize == other.MetaDataSize
            && self.MetaDataOffset == other.MetaDataOffset
            && self.NumberOfSections == other.NumberOfSections
            && self.PointerToSymbolTable == other.PointerToSymbolTable
            && self.NumberOfSymbols == other.NumberOfSymbols
    }
}
impl ::std::cmp::Eq for ANON_OBJECT_HEADER_BIGOBJ {}
unsafe impl ::windows::runtime::Abi for ANON_OBJECT_HEADER_BIGOBJ {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ANON_OBJECT_HEADER_V2 {
    pub Sig1: u16,
    pub Sig2: u16,
    pub Version: u16,
    pub Machine: u16,
    pub TimeDateStamp: u32,
    pub ClassID: ::windows::runtime::GUID,
    pub SizeOfData: u32,
    pub Flags: u32,
    pub MetaDataSize: u32,
    pub MetaDataOffset: u32,
}
impl ANON_OBJECT_HEADER_V2 {}
impl ::std::default::Default for ANON_OBJECT_HEADER_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ANON_OBJECT_HEADER_V2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ANON_OBJECT_HEADER_V2")
            .field("Sig1", &self.Sig1)
            .field("Sig2", &self.Sig2)
            .field("Version", &self.Version)
            .field("Machine", &self.Machine)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("ClassID", &self.ClassID)
            .field("SizeOfData", &self.SizeOfData)
            .field("Flags", &self.Flags)
            .field("MetaDataSize", &self.MetaDataSize)
            .field("MetaDataOffset", &self.MetaDataOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ANON_OBJECT_HEADER_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.Sig1 == other.Sig1 && self.Sig2 == other.Sig2 && self.Version == other.Version && self.Machine == other.Machine && self.TimeDateStamp == other.TimeDateStamp && self.ClassID == other.ClassID && self.SizeOfData == other.SizeOfData && self.Flags == other.Flags && self.MetaDataSize == other.MetaDataSize && self.MetaDataOffset == other.MetaDataOffset
    }
}
impl ::std::cmp::Eq for ANON_OBJECT_HEADER_V2 {}
unsafe impl ::windows::runtime::Abi for ANON_OBJECT_HEADER_V2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ANYSIZE_ARRAY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type APC_CALLBACK_FUNCTION = unsafe extern "system" fn(param0: u32, param1: *mut ::std::ffi::c_void, param2: *mut ::std::ffi::c_void);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct APPCOMMAND_ID(pub u32);
pub const APPCOMMAND_BROWSER_BACKWARD: APPCOMMAND_ID = APPCOMMAND_ID(1u32);
pub const APPCOMMAND_BROWSER_FORWARD: APPCOMMAND_ID = APPCOMMAND_ID(2u32);
pub const APPCOMMAND_BROWSER_REFRESH: APPCOMMAND_ID = APPCOMMAND_ID(3u32);
pub const APPCOMMAND_BROWSER_STOP: APPCOMMAND_ID = APPCOMMAND_ID(4u32);
pub const APPCOMMAND_BROWSER_SEARCH: APPCOMMAND_ID = APPCOMMAND_ID(5u32);
pub const APPCOMMAND_BROWSER_FAVORITES: APPCOMMAND_ID = APPCOMMAND_ID(6u32);
pub const APPCOMMAND_BROWSER_HOME: APPCOMMAND_ID = APPCOMMAND_ID(7u32);
pub const APPCOMMAND_VOLUME_MUTE: APPCOMMAND_ID = APPCOMMAND_ID(8u32);
pub const APPCOMMAND_VOLUME_DOWN: APPCOMMAND_ID = APPCOMMAND_ID(9u32);
pub const APPCOMMAND_VOLUME_UP: APPCOMMAND_ID = APPCOMMAND_ID(10u32);
pub const APPCOMMAND_MEDIA_NEXTTRACK: APPCOMMAND_ID = APPCOMMAND_ID(11u32);
pub const APPCOMMAND_MEDIA_PREVIOUSTRACK: APPCOMMAND_ID = APPCOMMAND_ID(12u32);
pub const APPCOMMAND_MEDIA_STOP: APPCOMMAND_ID = APPCOMMAND_ID(13u32);
pub const APPCOMMAND_MEDIA_PLAY_PAUSE: APPCOMMAND_ID = APPCOMMAND_ID(14u32);
pub const APPCOMMAND_LAUNCH_MAIL: APPCOMMAND_ID = APPCOMMAND_ID(15u32);
pub const APPCOMMAND_LAUNCH_MEDIA_SELECT: APPCOMMAND_ID = APPCOMMAND_ID(16u32);
pub const APPCOMMAND_LAUNCH_APP1: APPCOMMAND_ID = APPCOMMAND_ID(17u32);
pub const APPCOMMAND_LAUNCH_APP2: APPCOMMAND_ID = APPCOMMAND_ID(18u32);
pub const APPCOMMAND_BASS_DOWN: APPCOMMAND_ID = APPCOMMAND_ID(19u32);
pub const APPCOMMAND_BASS_BOOST: APPCOMMAND_ID = APPCOMMAND_ID(20u32);
pub const APPCOMMAND_BASS_UP: APPCOMMAND_ID = APPCOMMAND_ID(21u32);
pub const APPCOMMAND_TREBLE_DOWN: APPCOMMAND_ID = APPCOMMAND_ID(22u32);
pub const APPCOMMAND_TREBLE_UP: APPCOMMAND_ID = APPCOMMAND_ID(23u32);
pub const APPCOMMAND_MICROPHONE_VOLUME_MUTE: APPCOMMAND_ID = APPCOMMAND_ID(24u32);
pub const APPCOMMAND_MICROPHONE_VOLUME_DOWN: APPCOMMAND_ID = APPCOMMAND_ID(25u32);
pub const APPCOMMAND_MICROPHONE_VOLUME_UP: APPCOMMAND_ID = APPCOMMAND_ID(26u32);
pub const APPCOMMAND_HELP: APPCOMMAND_ID = APPCOMMAND_ID(27u32);
pub const APPCOMMAND_FIND: APPCOMMAND_ID = APPCOMMAND_ID(28u32);
pub const APPCOMMAND_NEW: APPCOMMAND_ID = APPCOMMAND_ID(29u32);
pub const APPCOMMAND_OPEN: APPCOMMAND_ID = APPCOMMAND_ID(30u32);
pub const APPCOMMAND_CLOSE: APPCOMMAND_ID = APPCOMMAND_ID(31u32);
pub const APPCOMMAND_SAVE: APPCOMMAND_ID = APPCOMMAND_ID(32u32);
pub const APPCOMMAND_PRINT: APPCOMMAND_ID = APPCOMMAND_ID(33u32);
pub const APPCOMMAND_UNDO: APPCOMMAND_ID = APPCOMMAND_ID(34u32);
pub const APPCOMMAND_REDO: APPCOMMAND_ID = APPCOMMAND_ID(35u32);
pub const APPCOMMAND_COPY: APPCOMMAND_ID = APPCOMMAND_ID(36u32);
pub const APPCOMMAND_CUT: APPCOMMAND_ID = APPCOMMAND_ID(37u32);
pub const APPCOMMAND_PASTE: APPCOMMAND_ID = APPCOMMAND_ID(38u32);
pub const APPCOMMAND_REPLY_TO_MAIL: APPCOMMAND_ID = APPCOMMAND_ID(39u32);
pub const APPCOMMAND_FORWARD_MAIL: APPCOMMAND_ID = APPCOMMAND_ID(40u32);
pub const APPCOMMAND_SEND_MAIL: APPCOMMAND_ID = APPCOMMAND_ID(41u32);
pub const APPCOMMAND_SPELL_CHECK: APPCOMMAND_ID = APPCOMMAND_ID(42u32);
pub const APPCOMMAND_DICTATE_OR_COMMAND_CONTROL_TOGGLE: APPCOMMAND_ID = APPCOMMAND_ID(43u32);
pub const APPCOMMAND_MIC_ON_OFF_TOGGLE: APPCOMMAND_ID = APPCOMMAND_ID(44u32);
pub const APPCOMMAND_CORRECTION_LIST: APPCOMMAND_ID = APPCOMMAND_ID(45u32);
pub const APPCOMMAND_MEDIA_PLAY: APPCOMMAND_ID = APPCOMMAND_ID(46u32);
pub const APPCOMMAND_MEDIA_PAUSE: APPCOMMAND_ID = APPCOMMAND_ID(47u32);
pub const APPCOMMAND_MEDIA_RECORD: APPCOMMAND_ID = APPCOMMAND_ID(48u32);
pub const APPCOMMAND_MEDIA_FAST_FORWARD: APPCOMMAND_ID = APPCOMMAND_ID(49u32);
pub const APPCOMMAND_MEDIA_REWIND: APPCOMMAND_ID = APPCOMMAND_ID(50u32);
pub const APPCOMMAND_MEDIA_CHANNEL_UP: APPCOMMAND_ID = APPCOMMAND_ID(51u32);
pub const APPCOMMAND_MEDIA_CHANNEL_DOWN: APPCOMMAND_ID = APPCOMMAND_ID(52u32);
pub const APPCOMMAND_DELETE: APPCOMMAND_ID = APPCOMMAND_ID(53u32);
pub const APPCOMMAND_DWM_FLIP3D: APPCOMMAND_ID = APPCOMMAND_ID(54u32);
impl ::std::convert::From<u32> for APPCOMMAND_ID {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPCOMMAND_ID {
    type Abi = Self;
}
impl ::std::ops::BitOr for APPCOMMAND_ID {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for APPCOMMAND_ID {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for APPCOMMAND_ID {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for APPCOMMAND_ID {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for APPCOMMAND_ID {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct APPLICATIONLAUNCH_SETTING_VALUE {
    pub ActivationTime: i64,
    pub Flags: u32,
    pub ButtonInstanceID: u32,
}
impl APPLICATIONLAUNCH_SETTING_VALUE {}
impl ::std::default::Default for APPLICATIONLAUNCH_SETTING_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for APPLICATIONLAUNCH_SETTING_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPLICATIONLAUNCH_SETTING_VALUE").field("ActivationTime", &self.ActivationTime).field("Flags", &self.Flags).field("ButtonInstanceID", &self.ButtonInstanceID).finish()
    }
}
impl ::std::cmp::PartialEq for APPLICATIONLAUNCH_SETTING_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.ActivationTime == other.ActivationTime && self.Flags == other.Flags && self.ButtonInstanceID == other.ButtonInstanceID
    }
}
impl ::std::cmp::Eq for APPLICATIONLAUNCH_SETTING_VALUE {}
unsafe impl ::windows::runtime::Abi for APPLICATIONLAUNCH_SETTING_VALUE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const APPLICATION_ERROR_MASK: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ARM64_FNPDATA_CR(pub i32);
pub const PdataCrUnchained: ARM64_FNPDATA_CR = ARM64_FNPDATA_CR(0i32);
pub const PdataCrUnchainedSavedLr: ARM64_FNPDATA_CR = ARM64_FNPDATA_CR(1i32);
pub const PdataCrChainedWithPac: ARM64_FNPDATA_CR = ARM64_FNPDATA_CR(2i32);
pub const PdataCrChained: ARM64_FNPDATA_CR = ARM64_FNPDATA_CR(3i32);
impl ::std::convert::From<i32> for ARM64_FNPDATA_CR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ARM64_FNPDATA_CR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ARM64_FNPDATA_FLAGS(pub i32);
pub const PdataRefToFullXdata: ARM64_FNPDATA_FLAGS = ARM64_FNPDATA_FLAGS(0i32);
pub const PdataPackedUnwindFunction: ARM64_FNPDATA_FLAGS = ARM64_FNPDATA_FLAGS(1i32);
pub const PdataPackedUnwindFragment: ARM64_FNPDATA_FLAGS = ARM64_FNPDATA_FLAGS(2i32);
impl ::std::convert::From<i32> for ARM64_FNPDATA_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ARM64_FNPDATA_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_MAX_BREAKPOINTS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_MAX_WATCHPOINTS: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_MULT_INTRINSICS_SUPPORTED: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ARM64_NT_CONTEXT {
    pub ContextFlags: u32,
    pub Cpsr: u32,
    pub Anonymous: ARM64_NT_CONTEXT_0,
    pub Sp: u64,
    pub Pc: u64,
    pub V: [ARM64_NT_NEON128; 32],
    pub Fpcr: u32,
    pub Fpsr: u32,
    pub Bcr: [u32; 8],
    pub Bvr: [u64; 8],
    pub Wcr: [u32; 2],
    pub Wvr: [u64; 2],
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::default::Default for ARM64_NT_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for ARM64_NT_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::Eq for ARM64_NT_CONTEXT {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for ARM64_NT_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
pub union ARM64_NT_CONTEXT_0 {
    pub Anonymous: ARM64_NT_CONTEXT_0_0,
    pub X: [u64; 31],
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::default::Default for ARM64_NT_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for ARM64_NT_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::Eq for ARM64_NT_CONTEXT_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for ARM64_NT_CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
pub struct ARM64_NT_CONTEXT_0_0 {
    pub X0: u64,
    pub X1: u64,
    pub X2: u64,
    pub X3: u64,
    pub X4: u64,
    pub X5: u64,
    pub X6: u64,
    pub X7: u64,
    pub X8: u64,
    pub X9: u64,
    pub X10: u64,
    pub X11: u64,
    pub X12: u64,
    pub X13: u64,
    pub X14: u64,
    pub X15: u64,
    pub X16: u64,
    pub X17: u64,
    pub X18: u64,
    pub X19: u64,
    pub X20: u64,
    pub X21: u64,
    pub X22: u64,
    pub X23: u64,
    pub X24: u64,
    pub X25: u64,
    pub X26: u64,
    pub X27: u64,
    pub X28: u64,
    pub Fp: u64,
    pub Lr: u64,
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ARM64_NT_CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::default::Default for ARM64_NT_CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::fmt::Debug for ARM64_NT_CONTEXT_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("X0", &self.X0)
            .field("X1", &self.X1)
            .field("X2", &self.X2)
            .field("X3", &self.X3)
            .field("X4", &self.X4)
            .field("X5", &self.X5)
            .field("X6", &self.X6)
            .field("X7", &self.X7)
            .field("X8", &self.X8)
            .field("X9", &self.X9)
            .field("X10", &self.X10)
            .field("X11", &self.X11)
            .field("X12", &self.X12)
            .field("X13", &self.X13)
            .field("X14", &self.X14)
            .field("X15", &self.X15)
            .field("X16", &self.X16)
            .field("X17", &self.X17)
            .field("X18", &self.X18)
            .field("X19", &self.X19)
            .field("X20", &self.X20)
            .field("X21", &self.X21)
            .field("X22", &self.X22)
            .field("X23", &self.X23)
            .field("X24", &self.X24)
            .field("X25", &self.X25)
            .field("X26", &self.X26)
            .field("X27", &self.X27)
            .field("X28", &self.X28)
            .field("Fp", &self.Fp)
            .field("Lr", &self.Lr)
            .finish()
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for ARM64_NT_CONTEXT_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.X0 == other.X0
            && self.X1 == other.X1
            && self.X2 == other.X2
            && self.X3 == other.X3
            && self.X4 == other.X4
            && self.X5 == other.X5
            && self.X6 == other.X6
            && self.X7 == other.X7
            && self.X8 == other.X8
            && self.X9 == other.X9
            && self.X10 == other.X10
            && self.X11 == other.X11
            && self.X12 == other.X12
            && self.X13 == other.X13
            && self.X14 == other.X14
            && self.X15 == other.X15
            && self.X16 == other.X16
            && self.X17 == other.X17
            && self.X18 == other.X18
            && self.X19 == other.X19
            && self.X20 == other.X20
            && self.X21 == other.X21
            && self.X22 == other.X22
            && self.X23 == other.X23
            && self.X24 == other.X24
            && self.X25 == other.X25
            && self.X26 == other.X26
            && self.X27 == other.X27
            && self.X28 == other.X28
            && self.Fp == other.Fp
            && self.Lr == other.Lr
    }
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
impl ::std::cmp::Eq for ARM64_NT_CONTEXT_0_0 {}
#[cfg(any(target_arch = "x86", target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for ARM64_NT_CONTEXT_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union ARM64_NT_NEON128 {
    pub Anonymous: ARM64_NT_NEON128_0,
    pub D: [f64; 2],
    pub S: [f32; 4],
    pub H: [u16; 8],
    pub B: [u8; 16],
}
impl ARM64_NT_NEON128 {}
impl ::std::default::Default for ARM64_NT_NEON128 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for ARM64_NT_NEON128 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for ARM64_NT_NEON128 {}
unsafe impl ::windows::runtime::Abi for ARM64_NT_NEON128 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ARM64_NT_NEON128_0 {
    pub Low: u64,
    pub High: i64,
}
impl ARM64_NT_NEON128_0 {}
impl ::std::default::Default for ARM64_NT_NEON128_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ARM64_NT_NEON128_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("Low", &self.Low).field("High", &self.High).finish()
    }
}
impl ::std::cmp::PartialEq for ARM64_NT_NEON128_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Low == other.Low && self.High == other.High
    }
}
impl ::std::cmp::Eq for ARM64_NT_NEON128_0 {}
unsafe impl ::windows::runtime::Abi for ARM64_NT_NEON128_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_KEEP: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_L1: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_L2: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_L3: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_PLD: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_PLI: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_PST: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM64_PREFETCH_STRM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM_CACHE_ALIGNMENT_SIZE: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM_MAX_BREAKPOINTS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ARM_MAX_WATCHPOINTS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ASSERT_BREAKPOINT: u32 = 524291u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ATF_FLAGS(pub u32);
pub const ATF_TIMEOUTON: ATF_FLAGS = ATF_FLAGS(1u32);
pub const ATF_ONOFFFEEDBACK: ATF_FLAGS = ATF_FLAGS(2u32);
impl ::std::convert::From<u32> for ATF_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ATF_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for ATF_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ATF_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ATF_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ATF_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ATF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const AUDIT_ALLOW_NO_PRIVILEGE: u32 = 1u32;
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct AtlThunkData_t(pub u8);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BATTERY_DISCHARGE_FLAGS_ENABLE: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BATTERY_DISCHARGE_FLAGS_EVENTCODE_MASK: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_16BPP: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_1BPP: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_24BPP: i32 = 5i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_32BPP: i32 = 6i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_4BPP: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_4RLE: i32 = 7i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_8BPP: i32 = 3i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_8RLE: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_ACC_NOTIFY: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_DONTCACHE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_JPEG: i32 = 9i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_KMSECTION: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_NOTSYSMEM: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_NOZEROINIT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_PNG: i32 = 10i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_RESERVED: u32 = 15872u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_RMT_ENTER: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_TEMP_ALPHA: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_TOPDOWN: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_UMPDMEM: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_USERMEM: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BMF_WINDOW_BLT: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BREAK_DEBUG_BASE: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BR_CMYKCOLOR: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BR_DEVICE_ICM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BR_HOST_ICM: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BR_ORIGCOLOR: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BSF_MSGSRV32ISOK: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const BSF_MSGSRV32ISOK_BIT: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_IO`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn BindIoCompletionCallback<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(filehandle: Param0, function: ::std::option::Option<super::IO::LPOVERLAPPED_COMPLETION_ROUTINE>, flags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BindIoCompletionCallback(filehandle: super::super::Foundation::HANDLE, function: ::windows::runtime::RawPtr, flags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(BindIoCompletionCallback(filehandle.into_param().abi(), ::std::mem::transmute(function), ::std::mem::transmute(flags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CACHE_FULLY_ASSOCIATIVE: u32 = 255u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CDBEX_CROSSADAPTER: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CDBEX_DXINTEROP: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CDBEX_NTSHAREDSURFACEHANDLE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CDBEX_REDIRECTION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CDBEX_REUSE: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct CDDDXGK_REDIRBITMAPPRESENTINFO {
    pub NumDirtyRects: u32,
    pub DirtyRect: *mut super::super::Foundation::RECT,
    pub NumContexts: u32,
    pub hContext: [super::super::Foundation::HANDLE; 65],
    pub bDoNotSynchronizeWithDxContent: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl CDDDXGK_REDIRBITMAPPRESENTINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CDDDXGK_REDIRBITMAPPRESENTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CDDDXGK_REDIRBITMAPPRESENTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CDDDXGK_REDIRBITMAPPRESENTINFO").field("NumDirtyRects", &self.NumDirtyRects).field("DirtyRect", &self.DirtyRect).field("NumContexts", &self.NumContexts).field("hContext", &self.hContext).field("bDoNotSynchronizeWithDxContent", &self.bDoNotSynchronizeWithDxContent).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CDDDXGK_REDIRBITMAPPRESENTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.NumDirtyRects == other.NumDirtyRects && self.DirtyRect == other.DirtyRect && self.NumContexts == other.NumContexts && self.hContext == other.hContext && self.bDoNotSynchronizeWithDxContent == other.bDoNotSynchronizeWithDxContent
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CDDDXGK_REDIRBITMAPPRESENTINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CDDDXGK_REDIRBITMAPPRESENTINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_ANY: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_LEFTDOWN: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_LEFTUP: i32 = 3i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_LEFTWARDS: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_RIGHTDOWN: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_RIGHTUP: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CD_UPWARDS: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_VIEWPROPERTIES_STRUCT_FLAGS(pub u32);
pub const CM_ENABLEHOOK: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(1u32);
pub const CM_SHOW_HELP: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(2u32);
pub const CM_SHOW_HELPICON: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(4u32);
pub const CM_ENABLETEMPLATE: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(8u32);
pub const CM_HIDE_ADVANCEPAGE: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(16u32);
pub const CM_HIDE_TRUSTPAGE: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(32u32);
pub const CM_NO_NAMECHANGE: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(64u32);
pub const CM_NO_EDITTRUST: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(128u32);
pub const CM_HIDE_DETAILPAGE: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(256u32);
pub const CM_ADD_CERT_STORES: CERT_VIEWPROPERTIES_STRUCT_FLAGS = CERT_VIEWPROPERTIES_STRUCT_FLAGS(512u32);
impl ::std::convert::From<u32> for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_VIEWPROPERTIES_STRUCT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CFE_UNDERLINE(pub u32);
pub const CFU_CF1UNDERLINE: CFE_UNDERLINE = CFE_UNDERLINE(255u32);
pub const CFU_INVERT: CFE_UNDERLINE = CFE_UNDERLINE(254u32);
pub const CFU_UNDERLINETHICKLONGDASH: CFE_UNDERLINE = CFE_UNDERLINE(18u32);
pub const CFU_UNDERLINETHICKDOTTED: CFE_UNDERLINE = CFE_UNDERLINE(17u32);
pub const CFU_UNDERLINETHICKDASHDOTDOT: CFE_UNDERLINE = CFE_UNDERLINE(16u32);
pub const CFU_UNDERLINETHICKDASHDOT: CFE_UNDERLINE = CFE_UNDERLINE(15u32);
pub const CFU_UNDERLINETHICKDASH: CFE_UNDERLINE = CFE_UNDERLINE(14u32);
pub const CFU_UNDERLINELONGDASH: CFE_UNDERLINE = CFE_UNDERLINE(13u32);
pub const CFU_UNDERLINEHEAVYWAVE: CFE_UNDERLINE = CFE_UNDERLINE(12u32);
pub const CFU_UNDERLINEDOUBLEWAVE: CFE_UNDERLINE = CFE_UNDERLINE(11u32);
pub const CFU_UNDERLINEHAIRLINE: CFE_UNDERLINE = CFE_UNDERLINE(10u32);
pub const CFU_UNDERLINETHICK: CFE_UNDERLINE = CFE_UNDERLINE(9u32);
pub const CFU_UNDERLINEWAVE: CFE_UNDERLINE = CFE_UNDERLINE(8u32);
pub const CFU_UNDERLINEDASHDOTDOT: CFE_UNDERLINE = CFE_UNDERLINE(7u32);
pub const CFU_UNDERLINEDASHDOT: CFE_UNDERLINE = CFE_UNDERLINE(6u32);
pub const CFU_UNDERLINEDASH: CFE_UNDERLINE = CFE_UNDERLINE(5u32);
pub const CFU_UNDERLINEDOTTED: CFE_UNDERLINE = CFE_UNDERLINE(4u32);
pub const CFU_UNDERLINEDOUBLE: CFE_UNDERLINE = CFE_UNDERLINE(3u32);
pub const CFU_UNDERLINEWORD: CFE_UNDERLINE = CFE_UNDERLINE(2u32);
pub const CFU_UNDERLINE: CFE_UNDERLINE = CFE_UNDERLINE(1u32);
pub const CFU_UNDERLINENONE: CFE_UNDERLINE = CFE_UNDERLINE(0u32);
impl ::std::convert::From<u32> for CFE_UNDERLINE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CFE_UNDERLINE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CFE_UNDERLINE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CFE_UNDERLINE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CFE_UNDERLINE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CFE_UNDERLINE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CFE_UNDERLINE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CFG_CALL_TARGET_CONVERT_EXPORT_SUPPRESSED_TO_VALID: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CFG_CALL_TARGET_CONVERT_XFG_TO_CFG: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct CFG_CALL_TARGET_INFO {
    pub Offset: usize,
    pub Flags: usize,
}
impl CFG_CALL_TARGET_INFO {}
impl ::std::default::Default for CFG_CALL_TARGET_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CFG_CALL_TARGET_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CFG_CALL_TARGET_INFO").field("Offset", &self.Offset).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for CFG_CALL_TARGET_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for CFG_CALL_TARGET_INFO {}
unsafe impl ::windows::runtime::Abi for CFG_CALL_TARGET_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CFG_CALL_TARGET_PROCESSED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CFG_CALL_TARGET_VALID: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CFG_CALL_TARGET_VALID_XFG: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CHOOSECOLOR_FLAGS(pub u32);
pub const CC_RGBINIT: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(1u32);
pub const CC_FULLOPEN: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(2u32);
pub const CC_PREVENTFULLOPEN: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(4u32);
pub const CC_SHOWHELP: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(8u32);
pub const CC_ENABLEHOOK: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(16u32);
pub const CC_ENABLETEMPLATE: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(32u32);
pub const CC_ENABLETEMPLATEHANDLE: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(64u32);
pub const CC_SOLIDCOLOR: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(128u32);
pub const CC_ANYCOLOR: CHOOSECOLOR_FLAGS = CHOOSECOLOR_FLAGS(256u32);
impl ::std::convert::From<u32> for CHOOSECOLOR_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CHOOSECOLOR_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CHOOSECOLOR_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CHOOSECOLOR_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CHOOSECOLOR_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CHOOSECOLOR_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CHOOSECOLOR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CLAIM_SECURITY_ATTRIBUTES_INFORMATION_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CLAIM_SECURITY_ATTRIBUTES_INFORMATION_VERSION_V1: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CLAIM_SECURITY_ATTRIBUTE_CUSTOM_FLAGS: u32 = 4294901760u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_INVALID: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CLIPBOARD_FORMATS(pub u32);
pub const CF_TEXT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(1u32);
pub const CF_BITMAP: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(2u32);
pub const CF_METAFILEPICT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(3u32);
pub const CF_SYLK: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(4u32);
pub const CF_DIF: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(5u32);
pub const CF_TIFF: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(6u32);
pub const CF_OEMTEXT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(7u32);
pub const CF_DIB: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(8u32);
pub const CF_PALETTE: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(9u32);
pub const CF_PENDATA: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(10u32);
pub const CF_RIFF: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(11u32);
pub const CF_WAVE: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(12u32);
pub const CF_UNICODETEXT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(13u32);
pub const CF_ENHMETAFILE: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(14u32);
pub const CF_HDROP: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(15u32);
pub const CF_LOCALE: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(16u32);
pub const CF_DIBV5: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(17u32);
pub const CF_MAX: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(18u32);
pub const CF_OWNERDISPLAY: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(128u32);
pub const CF_DSPTEXT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(129u32);
pub const CF_DSPBITMAP: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(130u32);
pub const CF_DSPMETAFILEPICT: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(131u32);
pub const CF_DSPENHMETAFILE: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(142u32);
pub const CF_PRIVATEFIRST: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(512u32);
pub const CF_PRIVATELAST: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(767u32);
pub const CF_GDIOBJFIRST: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(768u32);
pub const CF_GDIOBJLAST: CLIPBOARD_FORMATS = CLIPBOARD_FORMATS(1023u32);
impl ::std::convert::From<u32> for CLIPBOARD_FORMATS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CLIPBOARD_FORMATS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CLIPBOARD_FORMATS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CLIPBOARD_FORMATS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CLIPBOARD_FORMATS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CLIPBOARD_FORMATS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CLIPBOARD_FORMATS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CM_ERROR_CONTROL_TYPE(pub i32);
pub const IgnoreError: CM_ERROR_CONTROL_TYPE = CM_ERROR_CONTROL_TYPE(0i32);
pub const NormalError: CM_ERROR_CONTROL_TYPE = CM_ERROR_CONTROL_TYPE(1i32);
pub const SevereError: CM_ERROR_CONTROL_TYPE = CM_ERROR_CONTROL_TYPE(2i32);
pub const CriticalError: CM_ERROR_CONTROL_TYPE = CM_ERROR_CONTROL_TYPE(3i32);
impl ::std::convert::From<i32> for CM_ERROR_CONTROL_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_ERROR_CONTROL_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Power")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Power`*"]
pub struct CM_Power_Data_s {
    pub PD_Size: u32,
    pub PD_MostRecentPowerState: DEVICE_POWER_STATE,
    pub PD_Capabilities: u32,
    pub PD_D1Latency: u32,
    pub PD_D2Latency: u32,
    pub PD_D3Latency: u32,
    pub PD_PowerStateMapping: [DEVICE_POWER_STATE; 7],
    pub PD_DeepestSystemWake: super::Power::SYSTEM_POWER_STATE,
}
#[cfg(feature = "Win32_System_Power")]
impl CM_Power_Data_s {}
#[cfg(feature = "Win32_System_Power")]
impl ::std::default::Default for CM_Power_Data_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Power")]
impl ::std::fmt::Debug for CM_Power_Data_s {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CM_Power_Data_s")
            .field("PD_Size", &self.PD_Size)
            .field("PD_MostRecentPowerState", &self.PD_MostRecentPowerState)
            .field("PD_Capabilities", &self.PD_Capabilities)
            .field("PD_D1Latency", &self.PD_D1Latency)
            .field("PD_D2Latency", &self.PD_D2Latency)
            .field("PD_D3Latency", &self.PD_D3Latency)
            .field("PD_PowerStateMapping", &self.PD_PowerStateMapping)
            .field("PD_DeepestSystemWake", &self.PD_DeepestSystemWake)
            .finish()
    }
}
#[cfg(feature = "Win32_System_Power")]
impl ::std::cmp::PartialEq for CM_Power_Data_s {
    fn eq(&self, other: &Self) -> bool {
        self.PD_Size == other.PD_Size && self.PD_MostRecentPowerState == other.PD_MostRecentPowerState && self.PD_Capabilities == other.PD_Capabilities && self.PD_D1Latency == other.PD_D1Latency && self.PD_D2Latency == other.PD_D2Latency && self.PD_D3Latency == other.PD_D3Latency && self.PD_PowerStateMapping == other.PD_PowerStateMapping && self.PD_DeepestSystemWake == other.PD_DeepestSystemWake
    }
}
#[cfg(feature = "Win32_System_Power")]
impl ::std::cmp::Eq for CM_Power_Data_s {}
#[cfg(feature = "Win32_System_Power")]
unsafe impl ::windows::runtime::Abi for CM_Power_Data_s {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CM_SERVICE_LOAD_TYPE(pub i32);
pub const BootLoad: CM_SERVICE_LOAD_TYPE = CM_SERVICE_LOAD_TYPE(0i32);
pub const SystemLoad: CM_SERVICE_LOAD_TYPE = CM_SERVICE_LOAD_TYPE(1i32);
pub const AutoLoad: CM_SERVICE_LOAD_TYPE = CM_SERVICE_LOAD_TYPE(2i32);
pub const DemandLoad: CM_SERVICE_LOAD_TYPE = CM_SERVICE_LOAD_TYPE(3i32);
pub const DisableLoad: CM_SERVICE_LOAD_TYPE = CM_SERVICE_LOAD_TYPE(4i32);
impl ::std::convert::From<i32> for CM_SERVICE_LOAD_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_SERVICE_LOAD_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_MEASURED_BOOT_LOAD: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_NETWORK_BOOT_LOAD: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CM_SERVICE_NODE_TYPE(pub i32);
pub const DriverType: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(1i32);
pub const FileSystemType: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(2i32);
pub const Win32ServiceOwnProcess: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(16i32);
pub const Win32ServiceShareProcess: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(32i32);
pub const AdapterType: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(4i32);
pub const RecognizerType: CM_SERVICE_NODE_TYPE = CM_SERVICE_NODE_TYPE(8i32);
impl ::std::convert::From<i32> for CM_SERVICE_NODE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_SERVICE_NODE_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_RAM_DISK_BOOT_LOAD: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_SD_DISK_BOOT_LOAD: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_USB3_DISK_BOOT_LOAD: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_USB_DISK_BOOT_LOAD: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_VERIFIER_BOOT_LOAD: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_VIRTUAL_DISK_BOOT_LOAD: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CM_SERVICE_WINPE_BOOT_LOAD: u32 = 128u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct COMPONENT_FILTER {
    pub ComponentFlags: u32,
}
impl COMPONENT_FILTER {}
impl ::std::default::Default for COMPONENT_FILTER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for COMPONENT_FILTER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COMPONENT_FILTER").field("ComponentFlags", &self.ComponentFlags).finish()
    }
}
impl ::std::cmp::PartialEq for COMPONENT_FILTER {
    fn eq(&self, other: &Self) -> bool {
        self.ComponentFlags == other.ComponentFlags
    }
}
impl ::std::cmp::Eq for COMPONENT_FILTER {}
unsafe impl ::windows::runtime::Abi for COMPONENT_FILTER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPONENT_KTM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPONENT_VALID_FLAGS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_ENGINE_HIBER: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_ENGINE_MAXIMUM: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_ENGINE_STANDARD: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_LZNT1: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_XP10: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_XPRESS: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const COMPRESSION_FORMAT_XPRESS_HUFF: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_AMD64: i32 = 1048576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_ARM: i32 = 2097152i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_ARM64: i32 = 4194304i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_ARM64_RET_TO_GUEST: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_ARM64_UNWOUND_TO_CALL: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_EXCEPTION_ACTIVE: i32 = 134217728i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_EXCEPTION_REPORTING: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_EXCEPTION_REQUEST: i32 = 1073741824i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_KERNEL_DEBUGGER: i32 = 67108864i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_RET_TO_GUEST: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_SERVICE_ACTIVE: i32 = 268435456i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_UNWOUND_TO_CALL: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_i386: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CONTEXT_i486: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CORE_PARKING_POLICY_CHANGE_IDEAL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CORE_PARKING_POLICY_CHANGE_MAX: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CORE_PARKING_POLICY_CHANGE_MULTISTEP: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CORE_PARKING_POLICY_CHANGE_ROCKET: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CORE_PARKING_POLICY_CHANGE_SINGLE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct CORRELATION_VECTOR {
    pub Version: super::super::Foundation::CHAR,
    pub Vector: [super::super::Foundation::CHAR; 129],
}
#[cfg(feature = "Win32_Foundation")]
impl CORRELATION_VECTOR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CORRELATION_VECTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CORRELATION_VECTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CORRELATION_VECTOR").field("Version", &self.Version).field("Vector", &self.Vector).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CORRELATION_VECTOR {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Vector == other.Vector
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CORRELATION_VECTOR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CORRELATION_VECTOR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CREATE_BOUNDARY_DESCRIPTOR_ADD_APPCONTAINER_SID: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CRITICAL_ACE_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CTMF_INCLUDE_APPCONTAINER: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CTMF_INCLUDE_LPAC: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const CT_RECTANGLES: i32 = 0i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {
    pub Size: u32,
    pub TriggerId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG").field("Size", &self.Size).field("TriggerId", &self.TriggerId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.TriggerId == other.TriggerId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DANTIALIASMODE(pub i32);
pub const D3DANTIALIAS_NONE: D3DANTIALIASMODE = D3DANTIALIASMODE(0i32);
pub const D3DANTIALIAS_SORTDEPENDENT: D3DANTIALIASMODE = D3DANTIALIASMODE(1i32);
pub const D3DANTIALIAS_SORTINDEPENDENT: D3DANTIALIASMODE = D3DANTIALIASMODE(2i32);
pub const D3DANTIALIAS_FORCE_DWORD: D3DANTIALIASMODE = D3DANTIALIASMODE(2147483647i32);
impl ::std::convert::From<i32> for D3DANTIALIASMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DANTIALIASMODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DBRANCH {
    pub dwMask: u32,
    pub dwValue: u32,
    pub bNegate: super::super::Foundation::BOOL,
    pub dwOffset: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DBRANCH {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DBRANCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DBRANCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DBRANCH").field("dwMask", &self.dwMask).field("dwValue", &self.dwValue).field("bNegate", &self.bNegate).field("dwOffset", &self.dwOffset).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DBRANCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask && self.dwValue == other.dwValue && self.bNegate == other.bNegate && self.dwOffset == other.dwOffset
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DBRANCH {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DBRANCH {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLEAR_STENCIL: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLEAR_TARGET: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLEAR_ZBUFFER: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE0: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE1: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE2: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE3: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE4: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPPLANE5: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DCLIPSTATUS {
    pub dwFlags: u32,
    pub dwStatus: u32,
    pub minx: f32,
    pub maxx: f32,
    pub miny: f32,
    pub maxy: f32,
    pub minz: f32,
    pub maxz: f32,
}
impl D3DCLIPSTATUS {}
impl ::std::default::Default for D3DCLIPSTATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DCLIPSTATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DCLIPSTATUS").field("dwFlags", &self.dwFlags).field("dwStatus", &self.dwStatus).field("minx", &self.minx).field("maxx", &self.maxx).field("miny", &self.miny).field("maxy", &self.maxy).field("minz", &self.minz).field("maxz", &self.maxz).finish()
    }
}
impl ::std::cmp::PartialEq for D3DCLIPSTATUS {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwStatus == other.dwStatus && self.minx == other.minx && self.maxx == other.maxx && self.miny == other.miny && self.maxy == other.maxy && self.minz == other.minz && self.maxz == other.maxz
    }
}
impl ::std::cmp::Eq for D3DCLIPSTATUS {}
unsafe impl ::windows::runtime::Abi for D3DCLIPSTATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPSTATUS_EXTENTS2: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPSTATUS_EXTENTS3: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIPSTATUS_STATUS: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_BACK: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_BOTTOM: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_FRONT: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN0: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN1: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN2: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN3: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN4: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_GEN5: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_LEFT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_RIGHT: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCLIP_TOP: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCOLOR_MONO: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DCOLOR_RGB: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_BCLIPPING: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_COLORMODEL: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_DEVCAPS: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_DEVICERENDERBITDEPTH: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_DEVICEZBUFFERBITDEPTH: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_LIGHTINGCAPS: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_LINECAPS: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_MAXBUFFERSIZE: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_MAXVERTEXCOUNT: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_TRANSFORMCAPS: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDD_TRICAPS: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEBCAPS_SYSTEMMEMORY: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEBCAPS_VIDEOMEMORY: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEB_BUFSIZE: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEB_CAPS: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEB_LPDATA: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_CANBLTSYSTONONLOCAL: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_CANRENDERAFTERFLIP: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_DRAWPRIMITIVES2: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_DRAWPRIMITIVES2EX: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_DRAWPRIMTLVERTEX: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_EXECUTESYSTEMMEMORY: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_EXECUTEVIDEOMEMORY: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_FLOATTLVERTEX: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_HWRASTERIZATION: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_HWTRANSFORMANDLIGHT: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_SEPARATETEXTUREMEMORIES: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_SORTDECREASINGZ: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_SORTEXACT: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_SORTINCREASINGZ: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_TEXTURENONLOCALVIDMEM: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_TEXTURESYSTEMMEMORY: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_TEXTUREVIDEOMEMORY: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_TLVERTEXSYSTEMMEMORY: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVCAPS_TLVERTEXVIDEOMEMORY: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVINFOID_D3DTEXTUREMANAGER: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVINFOID_TEXTUREMANAGER: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDEVINFOID_TEXTURING: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DDEVINFO_TEXTUREMANAGER {
    pub bThrashing: super::super::Foundation::BOOL,
    pub dwApproxBytesDownloaded: u32,
    pub dwNumEvicts: u32,
    pub dwNumVidCreates: u32,
    pub dwNumTexturesUsed: u32,
    pub dwNumUsedTexInVid: u32,
    pub dwWorkingSet: u32,
    pub dwWorkingSetBytes: u32,
    pub dwTotalManaged: u32,
    pub dwTotalBytes: u32,
    pub dwLastPri: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DDEVINFO_TEXTUREMANAGER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DDEVINFO_TEXTUREMANAGER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DDEVINFO_TEXTUREMANAGER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DDEVINFO_TEXTUREMANAGER")
            .field("bThrashing", &self.bThrashing)
            .field("dwApproxBytesDownloaded", &self.dwApproxBytesDownloaded)
            .field("dwNumEvicts", &self.dwNumEvicts)
            .field("dwNumVidCreates", &self.dwNumVidCreates)
            .field("dwNumTexturesUsed", &self.dwNumTexturesUsed)
            .field("dwNumUsedTexInVid", &self.dwNumUsedTexInVid)
            .field("dwWorkingSet", &self.dwWorkingSet)
            .field("dwWorkingSetBytes", &self.dwWorkingSetBytes)
            .field("dwTotalManaged", &self.dwTotalManaged)
            .field("dwTotalBytes", &self.dwTotalBytes)
            .field("dwLastPri", &self.dwLastPri)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DDEVINFO_TEXTUREMANAGER {
    fn eq(&self, other: &Self) -> bool {
        self.bThrashing == other.bThrashing
            && self.dwApproxBytesDownloaded == other.dwApproxBytesDownloaded
            && self.dwNumEvicts == other.dwNumEvicts
            && self.dwNumVidCreates == other.dwNumVidCreates
            && self.dwNumTexturesUsed == other.dwNumTexturesUsed
            && self.dwNumUsedTexInVid == other.dwNumUsedTexInVid
            && self.dwWorkingSet == other.dwWorkingSet
            && self.dwWorkingSetBytes == other.dwWorkingSetBytes
            && self.dwTotalManaged == other.dwTotalManaged
            && self.dwTotalBytes == other.dwTotalBytes
            && self.dwLastPri == other.dwLastPri
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DDEVINFO_TEXTUREMANAGER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DDEVINFO_TEXTUREMANAGER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DDEVINFO_TEXTURING {
    pub dwNumLoads: u32,
    pub dwApproxBytesLoaded: u32,
    pub dwNumPreLoads: u32,
    pub dwNumSet: u32,
    pub dwNumCreates: u32,
    pub dwNumDestroys: u32,
    pub dwNumSetPriorities: u32,
    pub dwNumSetLODs: u32,
    pub dwNumLocks: u32,
    pub dwNumGetDCs: u32,
}
impl D3DDEVINFO_TEXTURING {}
impl ::std::default::Default for D3DDEVINFO_TEXTURING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DDEVINFO_TEXTURING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DDEVINFO_TEXTURING")
            .field("dwNumLoads", &self.dwNumLoads)
            .field("dwApproxBytesLoaded", &self.dwApproxBytesLoaded)
            .field("dwNumPreLoads", &self.dwNumPreLoads)
            .field("dwNumSet", &self.dwNumSet)
            .field("dwNumCreates", &self.dwNumCreates)
            .field("dwNumDestroys", &self.dwNumDestroys)
            .field("dwNumSetPriorities", &self.dwNumSetPriorities)
            .field("dwNumSetLODs", &self.dwNumSetLODs)
            .field("dwNumLocks", &self.dwNumLocks)
            .field("dwNumGetDCs", &self.dwNumGetDCs)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DDEVINFO_TEXTURING {
    fn eq(&self, other: &Self) -> bool {
        self.dwNumLoads == other.dwNumLoads && self.dwApproxBytesLoaded == other.dwApproxBytesLoaded && self.dwNumPreLoads == other.dwNumPreLoads && self.dwNumSet == other.dwNumSet && self.dwNumCreates == other.dwNumCreates && self.dwNumDestroys == other.dwNumDestroys && self.dwNumSetPriorities == other.dwNumSetPriorities && self.dwNumSetLODs == other.dwNumSetLODs && self.dwNumLocks == other.dwNumLocks && self.dwNumGetDCs == other.dwNumGetDCs
    }
}
impl ::std::cmp::Eq for D3DDEVINFO_TEXTURING {}
unsafe impl ::windows::runtime::Abi for D3DDEVINFO_TEXTURING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DDP_MAXTEXCOORD: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DDP_PTRSTRIDE {
    pub lpvData: *mut ::std::ffi::c_void,
    pub dwStride: u32,
}
impl D3DDP_PTRSTRIDE {}
impl ::std::default::Default for D3DDP_PTRSTRIDE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DDP_PTRSTRIDE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DDP_PTRSTRIDE").field("lpvData", &self.lpvData).field("dwStride", &self.dwStride).finish()
    }
}
impl ::std::cmp::PartialEq for D3DDP_PTRSTRIDE {
    fn eq(&self, other: &Self) -> bool {
        self.lpvData == other.lpvData && self.dwStride == other.dwStride
    }
}
impl ::std::cmp::Eq for D3DDP_PTRSTRIDE {}
unsafe impl ::windows::runtime::Abi for D3DDP_PTRSTRIDE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DDRAWPRIMITIVESTRIDEDDATA {
    pub position: D3DDP_PTRSTRIDE,
    pub normal: D3DDP_PTRSTRIDE,
    pub diffuse: D3DDP_PTRSTRIDE,
    pub specular: D3DDP_PTRSTRIDE,
    pub textureCoords: [D3DDP_PTRSTRIDE; 8],
}
impl D3DDRAWPRIMITIVESTRIDEDDATA {}
impl ::std::default::Default for D3DDRAWPRIMITIVESTRIDEDDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DDRAWPRIMITIVESTRIDEDDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DDRAWPRIMITIVESTRIDEDDATA").field("position", &self.position).field("normal", &self.normal).field("diffuse", &self.diffuse).field("specular", &self.specular).field("textureCoords", &self.textureCoords).finish()
    }
}
impl ::std::cmp::PartialEq for D3DDRAWPRIMITIVESTRIDEDDATA {
    fn eq(&self, other: &Self) -> bool {
        self.position == other.position && self.normal == other.normal && self.diffuse == other.diffuse && self.specular == other.specular && self.textureCoords == other.textureCoords
    }
}
impl ::std::cmp::Eq for D3DDRAWPRIMITIVESTRIDEDDATA {}
unsafe impl ::windows::runtime::Abi for D3DDRAWPRIMITIVESTRIDEDDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DEXECUTEDATA {
    pub dwSize: u32,
    pub dwVertexOffset: u32,
    pub dwVertexCount: u32,
    pub dwInstructionOffset: u32,
    pub dwInstructionLength: u32,
    pub dwHVertexOffset: u32,
    pub dsStatus: D3DSTATUS,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DEXECUTEDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DEXECUTEDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DEXECUTEDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DEXECUTEDATA")
            .field("dwSize", &self.dwSize)
            .field("dwVertexOffset", &self.dwVertexOffset)
            .field("dwVertexCount", &self.dwVertexCount)
            .field("dwInstructionOffset", &self.dwInstructionOffset)
            .field("dwInstructionLength", &self.dwInstructionLength)
            .field("dwHVertexOffset", &self.dwHVertexOffset)
            .field("dsStatus", &self.dsStatus)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DEXECUTEDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwVertexOffset == other.dwVertexOffset && self.dwVertexCount == other.dwVertexCount && self.dwInstructionOffset == other.dwInstructionOffset && self.dwInstructionLength == other.dwInstructionLength && self.dwHVertexOffset == other.dwHVertexOffset && self.dsStatus == other.dsStatus
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DEXECUTEDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DEXECUTEDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DEXECUTE_CLIPPED: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DEXECUTE_UNCLIPPED: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_ALPHACMPCAPS: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_COLORMODEL: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_DSTBLENDCAPS: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_GUID: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_HARDWARE: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_LINES: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_MISCCAPS: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_RASTERCAPS: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_SHADECAPS: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_SRCBLENDCAPS: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_TEXTUREADDRESSCAPS: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_TEXTUREBLENDCAPS: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_TEXTURECAPS: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_TEXTUREFILTERCAPS: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_TRIANGLES: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFDS_ZCMPCAPS: i32 = 128i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DFINDDEVICERESULT {
    pub dwSize: u32,
    pub guid: ::windows::runtime::GUID,
    pub ddHwDesc: _D3DDeviceDesc,
    pub ddSwDesc: _D3DDeviceDesc,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DFINDDEVICERESULT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DFINDDEVICERESULT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DFINDDEVICERESULT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DFINDDEVICERESULT").field("dwSize", &self.dwSize).field("guid", &self.guid).field("ddHwDesc", &self.ddHwDesc).field("ddSwDesc", &self.ddSwDesc).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DFINDDEVICERESULT {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.guid == other.guid && self.ddHwDesc == other.ddHwDesc && self.ddSwDesc == other.ddSwDesc
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DFINDDEVICERESULT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DFINDDEVICERESULT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DFINDDEVICESEARCH {
    pub dwSize: u32,
    pub dwFlags: u32,
    pub bHardware: super::super::Foundation::BOOL,
    pub dcmColorModel: u32,
    pub guid: ::windows::runtime::GUID,
    pub dwCaps: u32,
    pub dpcPrimCaps: _D3DPrimCaps,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DFINDDEVICESEARCH {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DFINDDEVICESEARCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DFINDDEVICESEARCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DFINDDEVICESEARCH").field("dwSize", &self.dwSize).field("dwFlags", &self.dwFlags).field("bHardware", &self.bHardware).field("dcmColorModel", &self.dcmColorModel).field("guid", &self.guid).field("dwCaps", &self.dwCaps).field("dpcPrimCaps", &self.dpcPrimCaps).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DFINDDEVICESEARCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwFlags == other.dwFlags && self.bHardware == other.bHardware && self.dcmColorModel == other.dcmColorModel && self.guid == other.guid && self.dwCaps == other.dwCaps && self.dpcPrimCaps == other.dpcPrimCaps
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DFINDDEVICESEARCH {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DFINDDEVICESEARCH {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVFCAPS_DONOTSTRIPELEMENTS: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVFCAPS_TEXCOORDCOUNTMASK: i32 = 65535i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_DIFFUSE: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_NORMAL: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_POSITION_MASK: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_RESERVED0: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_RESERVED1: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_RESERVED2: u32 = 61440u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_SPECULAR: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX0: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX1: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX2: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX3: u32 = 768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX4: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX5: u32 = 1280u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX6: u32 = 1536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX7: u32 = 1792u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEX8: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXCOUNT_MASK: u32 = 3840u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXCOUNT_SHIFT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXTUREFORMAT1: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXTUREFORMAT2: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXTUREFORMAT3: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_TEXTUREFORMAT4: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZ: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZB1: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZB2: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZB3: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZB4: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZB5: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DFVF_XYZRHW: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_SAMPLER_MAXSAMP: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_SAMPLER_MAXVERTEXSAMP: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_STATESETBEGIN: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_STATESETCAPTURE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_STATESETDELETE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_STATESETEND: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DHAL_STATESETEXECUTE: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DHVERTEX {
    pub dwFlags: u32,
    pub Anonymous1: D3DHVERTEX_0,
    pub Anonymous2: D3DHVERTEX_1,
    pub Anonymous3: D3DHVERTEX_2,
}
impl D3DHVERTEX {}
impl ::std::default::Default for D3DHVERTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DHVERTEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DHVERTEX {}
unsafe impl ::windows::runtime::Abi for D3DHVERTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DHVERTEX_0 {
    pub hx: f32,
    pub dvHX: f32,
}
impl D3DHVERTEX_0 {}
impl ::std::default::Default for D3DHVERTEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DHVERTEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DHVERTEX_0 {}
unsafe impl ::windows::runtime::Abi for D3DHVERTEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DHVERTEX_1 {
    pub hy: f32,
    pub dvHY: f32,
}
impl D3DHVERTEX_1 {}
impl ::std::default::Default for D3DHVERTEX_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DHVERTEX_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DHVERTEX_1 {}
unsafe impl ::windows::runtime::Abi for D3DHVERTEX_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DHVERTEX_2 {
    pub hz: f32,
    pub dvHZ: f32,
}
impl D3DHVERTEX_2 {}
impl ::std::default::Default for D3DHVERTEX_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DHVERTEX_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DHVERTEX_2 {}
unsafe impl ::windows::runtime::Abi for D3DHVERTEX_2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DINFINITEINSTRUCTIONS: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DINSTRUCTION {
    pub bOpcode: u8,
    pub bSize: u8,
    pub wCount: u16,
}
impl D3DINSTRUCTION {}
impl ::std::default::Default for D3DINSTRUCTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DINSTRUCTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DINSTRUCTION").field("bOpcode", &self.bOpcode).field("bSize", &self.bSize).field("wCount", &self.wCount).finish()
    }
}
impl ::std::cmp::PartialEq for D3DINSTRUCTION {
    fn eq(&self, other: &Self) -> bool {
        self.bOpcode == other.bOpcode && self.bSize == other.bSize && self.wCount == other.wCount
    }
}
impl ::std::cmp::Eq for D3DINSTRUCTION {}
unsafe impl ::windows::runtime::Abi for D3DINSTRUCTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DLIGHT {
    pub dwSize: u32,
    pub dltType: super::super::Graphics::Direct3D9::D3DLIGHTTYPE,
    pub dcvColor: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dvPosition: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvDirection: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvRange: f32,
    pub dvFalloff: f32,
    pub dvAttenuation0: f32,
    pub dvAttenuation1: f32,
    pub dvAttenuation2: f32,
    pub dvTheta: f32,
    pub dvPhi: f32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DLIGHT {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DLIGHT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DLIGHT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHT")
            .field("dwSize", &self.dwSize)
            .field("dltType", &self.dltType)
            .field("dcvColor", &self.dcvColor)
            .field("dvPosition", &self.dvPosition)
            .field("dvDirection", &self.dvDirection)
            .field("dvRange", &self.dvRange)
            .field("dvFalloff", &self.dvFalloff)
            .field("dvAttenuation0", &self.dvAttenuation0)
            .field("dvAttenuation1", &self.dvAttenuation1)
            .field("dvAttenuation2", &self.dvAttenuation2)
            .field("dvTheta", &self.dvTheta)
            .field("dvPhi", &self.dvPhi)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DLIGHT {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dltType == other.dltType && self.dcvColor == other.dcvColor && self.dvPosition == other.dvPosition && self.dvDirection == other.dvDirection && self.dvRange == other.dvRange && self.dvFalloff == other.dvFalloff && self.dvAttenuation0 == other.dvAttenuation0 && self.dvAttenuation1 == other.dvAttenuation1 && self.dvAttenuation2 == other.dvAttenuation2 && self.dvTheta == other.dvTheta && self.dvPhi == other.dvPhi
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DLIGHT {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DLIGHT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DLIGHT2 {
    pub dwSize: u32,
    pub dltType: super::super::Graphics::Direct3D9::D3DLIGHTTYPE,
    pub dcvColor: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dvPosition: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvDirection: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvRange: f32,
    pub dvFalloff: f32,
    pub dvAttenuation0: f32,
    pub dvAttenuation1: f32,
    pub dvAttenuation2: f32,
    pub dvTheta: f32,
    pub dvPhi: f32,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DLIGHT2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DLIGHT2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DLIGHT2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHT2")
            .field("dwSize", &self.dwSize)
            .field("dltType", &self.dltType)
            .field("dcvColor", &self.dcvColor)
            .field("dvPosition", &self.dvPosition)
            .field("dvDirection", &self.dvDirection)
            .field("dvRange", &self.dvRange)
            .field("dvFalloff", &self.dvFalloff)
            .field("dvAttenuation0", &self.dvAttenuation0)
            .field("dvAttenuation1", &self.dvAttenuation1)
            .field("dvAttenuation2", &self.dvAttenuation2)
            .field("dvTheta", &self.dvTheta)
            .field("dvPhi", &self.dvPhi)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DLIGHT2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dltType == other.dltType && self.dcvColor == other.dcvColor && self.dvPosition == other.dvPosition && self.dvDirection == other.dvDirection && self.dvRange == other.dvRange && self.dvFalloff == other.dvFalloff && self.dvAttenuation0 == other.dvAttenuation0 && self.dvAttenuation1 == other.dvAttenuation1 && self.dvAttenuation2 == other.dvAttenuation2 && self.dvTheta == other.dvTheta && self.dvPhi == other.dvPhi && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DLIGHT2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DLIGHT2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DLIGHT7 {
    pub dltType: super::super::Graphics::Direct3D9::D3DLIGHTTYPE,
    pub dcvDiffuse: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvSpecular: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvAmbient: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dvPosition: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvDirection: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvRange: f32,
    pub dvFalloff: f32,
    pub dvAttenuation0: f32,
    pub dvAttenuation1: f32,
    pub dvAttenuation2: f32,
    pub dvTheta: f32,
    pub dvPhi: f32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DLIGHT7 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DLIGHT7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DLIGHT7 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHT7")
            .field("dltType", &self.dltType)
            .field("dcvDiffuse", &self.dcvDiffuse)
            .field("dcvSpecular", &self.dcvSpecular)
            .field("dcvAmbient", &self.dcvAmbient)
            .field("dvPosition", &self.dvPosition)
            .field("dvDirection", &self.dvDirection)
            .field("dvRange", &self.dvRange)
            .field("dvFalloff", &self.dvFalloff)
            .field("dvAttenuation0", &self.dvAttenuation0)
            .field("dvAttenuation1", &self.dvAttenuation1)
            .field("dvAttenuation2", &self.dvAttenuation2)
            .field("dvTheta", &self.dvTheta)
            .field("dvPhi", &self.dvPhi)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DLIGHT7 {
    fn eq(&self, other: &Self) -> bool {
        self.dltType == other.dltType
            && self.dcvDiffuse == other.dcvDiffuse
            && self.dcvSpecular == other.dcvSpecular
            && self.dcvAmbient == other.dcvAmbient
            && self.dvPosition == other.dvPosition
            && self.dvDirection == other.dvDirection
            && self.dvRange == other.dvRange
            && self.dvFalloff == other.dvFalloff
            && self.dvAttenuation0 == other.dvAttenuation0
            && self.dvAttenuation1 == other.dvAttenuation1
            && self.dvAttenuation2 == other.dvAttenuation2
            && self.dvTheta == other.dvTheta
            && self.dvPhi == other.dvPhi
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DLIGHT7 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DLIGHT7 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTCAPS_DIRECTIONAL: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTCAPS_GLSPOT: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTCAPS_PARALLELPOINT: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTCAPS_POINT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTCAPS_SPOT: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DLIGHTDATA {
    pub dwSize: u32,
    pub lpIn: *mut D3DLIGHTINGELEMENT,
    pub dwInSize: u32,
    pub lpOut: *mut D3DTLVERTEX,
    pub dwOutSize: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DLIGHTDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DLIGHTDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DLIGHTDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHTDATA").field("dwSize", &self.dwSize).field("lpIn", &self.lpIn).field("dwInSize", &self.dwInSize).field("lpOut", &self.lpOut).field("dwOutSize", &self.dwOutSize).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DLIGHTDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.lpIn == other.lpIn && self.dwInSize == other.dwInSize && self.lpOut == other.lpOut && self.dwOutSize == other.dwOutSize
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DLIGHTDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DLIGHTDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DLIGHTINGCAPS {
    pub dwSize: u32,
    pub dwCaps: u32,
    pub dwLightingModel: u32,
    pub dwNumLights: u32,
}
impl D3DLIGHTINGCAPS {}
impl ::std::default::Default for D3DLIGHTINGCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DLIGHTINGCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHTINGCAPS").field("dwSize", &self.dwSize).field("dwCaps", &self.dwCaps).field("dwLightingModel", &self.dwLightingModel).field("dwNumLights", &self.dwNumLights).finish()
    }
}
impl ::std::cmp::PartialEq for D3DLIGHTINGCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwCaps == other.dwCaps && self.dwLightingModel == other.dwLightingModel && self.dwNumLights == other.dwNumLights
    }
}
impl ::std::cmp::Eq for D3DLIGHTINGCAPS {}
unsafe impl ::windows::runtime::Abi for D3DLIGHTINGCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DLIGHTINGELEMENT {
    pub dvPosition: super::super::Graphics::Direct3D9::D3DVECTOR,
    pub dvNormal: super::super::Graphics::Direct3D9::D3DVECTOR,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DLIGHTINGELEMENT {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DLIGHTINGELEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DLIGHTINGELEMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLIGHTINGELEMENT").field("dvPosition", &self.dvPosition).field("dvNormal", &self.dvNormal).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DLIGHTINGELEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.dvPosition == other.dvPosition && self.dvNormal == other.dvNormal
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DLIGHTINGELEMENT {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DLIGHTINGELEMENT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTINGMODEL_MONO: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHTINGMODEL_RGB: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DLIGHTSTATETYPE(pub i32);
pub const D3DLIGHTSTATE_MATERIAL: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(1i32);
pub const D3DLIGHTSTATE_AMBIENT: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(2i32);
pub const D3DLIGHTSTATE_COLORMODEL: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(3i32);
pub const D3DLIGHTSTATE_FOGMODE: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(4i32);
pub const D3DLIGHTSTATE_FOGSTART: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(5i32);
pub const D3DLIGHTSTATE_FOGEND: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(6i32);
pub const D3DLIGHTSTATE_FOGDENSITY: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(7i32);
pub const D3DLIGHTSTATE_COLORVERTEX: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(8i32);
pub const D3DLIGHTSTATE_FORCE_DWORD: D3DLIGHTSTATETYPE = D3DLIGHTSTATETYPE(2147483647i32);
impl ::std::convert::From<i32> for D3DLIGHTSTATETYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DLIGHTSTATETYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHT_ACTIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DLIGHT_NO_SPECULAR: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DLINE {
    pub Anonymous1: D3DLINE_0,
    pub Anonymous2: D3DLINE_1,
}
impl D3DLINE {}
impl ::std::default::Default for D3DLINE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLINE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLINE {}
unsafe impl ::windows::runtime::Abi for D3DLINE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLINE_0 {
    pub v1: u16,
    pub wV1: u16,
}
impl D3DLINE_0 {}
impl ::std::default::Default for D3DLINE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLINE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLINE_0 {}
unsafe impl ::windows::runtime::Abi for D3DLINE_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLINE_1 {
    pub v2: u16,
    pub wV2: u16,
}
impl D3DLINE_1 {}
impl ::std::default::Default for D3DLINE_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLINE_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLINE_1 {}
unsafe impl ::windows::runtime::Abi for D3DLINE_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DLINEPATTERN {
    pub wRepeatFactor: u16,
    pub wLinePattern: u16,
}
impl D3DLINEPATTERN {}
impl ::std::default::Default for D3DLINEPATTERN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DLINEPATTERN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DLINEPATTERN").field("wRepeatFactor", &self.wRepeatFactor).field("wLinePattern", &self.wLinePattern).finish()
    }
}
impl ::std::cmp::PartialEq for D3DLINEPATTERN {
    fn eq(&self, other: &Self) -> bool {
        self.wRepeatFactor == other.wRepeatFactor && self.wLinePattern == other.wLinePattern
    }
}
impl ::std::cmp::Eq for D3DLINEPATTERN {}
unsafe impl ::windows::runtime::Abi for D3DLINEPATTERN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DLVERTEX {
    pub Anonymous1: D3DLVERTEX_0,
    pub Anonymous2: D3DLVERTEX_1,
    pub Anonymous3: D3DLVERTEX_2,
    pub dwReserved: u32,
    pub Anonymous4: D3DLVERTEX_3,
    pub Anonymous5: D3DLVERTEX_4,
    pub Anonymous6: D3DLVERTEX_5,
    pub Anonymous7: D3DLVERTEX_6,
}
impl D3DLVERTEX {}
impl ::std::default::Default for D3DLVERTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_0 {
    pub x: f32,
    pub dvX: f32,
}
impl D3DLVERTEX_0 {}
impl ::std::default::Default for D3DLVERTEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_0 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_1 {
    pub y: f32,
    pub dvY: f32,
}
impl D3DLVERTEX_1 {}
impl ::std::default::Default for D3DLVERTEX_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_1 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_2 {
    pub z: f32,
    pub dvZ: f32,
}
impl D3DLVERTEX_2 {}
impl ::std::default::Default for D3DLVERTEX_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_2 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_3 {
    pub color: u32,
    pub dcColor: u32,
}
impl D3DLVERTEX_3 {}
impl ::std::default::Default for D3DLVERTEX_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_3 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_4 {
    pub specular: u32,
    pub dcSpecular: u32,
}
impl D3DLVERTEX_4 {}
impl ::std::default::Default for D3DLVERTEX_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_4 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_5 {
    pub tu: f32,
    pub dvTU: f32,
}
impl D3DLVERTEX_5 {}
impl ::std::default::Default for D3DLVERTEX_5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_5 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_5 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_5 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DLVERTEX_6 {
    pub tv: f32,
    pub dvTV: f32,
}
impl D3DLVERTEX_6 {}
impl ::std::default::Default for D3DLVERTEX_6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DLVERTEX_6 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DLVERTEX_6 {}
unsafe impl ::windows::runtime::Abi for D3DLVERTEX_6 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DMATERIAL {
    pub dwSize: u32,
    pub Anonymous1: D3DMATERIAL_0,
    pub Anonymous2: D3DMATERIAL_1,
    pub Anonymous3: D3DMATERIAL_2,
    pub Anonymous4: D3DMATERIAL_3,
    pub Anonymous5: D3DMATERIAL_4,
    pub hTexture: u32,
    pub dwRampSize: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL_0 {
    pub diffuse: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvDiffuse: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL_1 {
    pub ambient: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvAmbient: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL_2 {
    pub specular: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvSpecular: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL_2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL_2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL_3 {
    pub emissive: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvEmissive: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL_3 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL_3 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL_4 {
    pub power: f32,
    pub dvPower: f32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL_4 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL_4 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DMATERIAL7 {
    pub Anonymous1: D3DMATERIAL7_0,
    pub Anonymous2: D3DMATERIAL7_1,
    pub Anonymous3: D3DMATERIAL7_2,
    pub Anonymous4: D3DMATERIAL7_3,
    pub Anonymous5: D3DMATERIAL7_4,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL7_0 {
    pub diffuse: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvDiffuse: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL7_1 {
    pub ambient: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvAmbient: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL7_2 {
    pub specular: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvSpecular: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7_2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7_2 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL7_3 {
    pub emissive: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
    pub dcvEmissive: super::super::Graphics::Direct3D9::D3DCOLORVALUE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7_3 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7_3 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DMATERIAL7_4 {
    pub power: f32,
    pub dvPower: f32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DMATERIAL7_4 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DMATERIAL7_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DMATERIAL7_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DMATERIAL7_4 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DMATERIAL7_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DMATRIXLOAD {
    pub hDestMatrix: u32,
    pub hSrcMatrix: u32,
}
impl D3DMATRIXLOAD {}
impl ::std::default::Default for D3DMATRIXLOAD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DMATRIXLOAD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DMATRIXLOAD").field("hDestMatrix", &self.hDestMatrix).field("hSrcMatrix", &self.hSrcMatrix).finish()
    }
}
impl ::std::cmp::PartialEq for D3DMATRIXLOAD {
    fn eq(&self, other: &Self) -> bool {
        self.hDestMatrix == other.hDestMatrix && self.hSrcMatrix == other.hSrcMatrix
    }
}
impl ::std::cmp::Eq for D3DMATRIXLOAD {}
unsafe impl ::windows::runtime::Abi for D3DMATRIXLOAD {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DMATRIXMULTIPLY {
    pub hDestMatrix: u32,
    pub hSrcMatrix1: u32,
    pub hSrcMatrix2: u32,
}
impl D3DMATRIXMULTIPLY {}
impl ::std::default::Default for D3DMATRIXMULTIPLY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DMATRIXMULTIPLY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DMATRIXMULTIPLY").field("hDestMatrix", &self.hDestMatrix).field("hSrcMatrix1", &self.hSrcMatrix1).field("hSrcMatrix2", &self.hSrcMatrix2).finish()
    }
}
impl ::std::cmp::PartialEq for D3DMATRIXMULTIPLY {
    fn eq(&self, other: &Self) -> bool {
        self.hDestMatrix == other.hDestMatrix && self.hSrcMatrix1 == other.hSrcMatrix1 && self.hSrcMatrix2 == other.hSrcMatrix2
    }
}
impl ::std::cmp::Eq for D3DMATRIXMULTIPLY {}
unsafe impl ::windows::runtime::Abi for D3DMATRIXMULTIPLY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DMAXUSERCLIPPLANES: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTCLEAR_COMPUTERECTS: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL2_CB32_SETRENDERTARGET: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL3_CB32_CLEAR2: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL3_CB32_DRAWPRIMITIVES2: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL3_CB32_RESERVED: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL3_CB32_VALIDATETEXTURESTAGESTATE: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_EXECUTEBUFFER: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_REQCOMMANDBUFSIZE: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_REQVERTEXBUFSIZE: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_SWAPCOMMANDBUFFER: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_SWAPVERTEXBUFFER: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_USERMEMVERTICES: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_VIDMEMCOMMANDBUF: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHALDP2_VIDMEMVERTEXBUF: i32 = 64i32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_CALLBACKS {
    pub dwSize: u32,
    pub ContextCreate: ::std::option::Option<LPD3DNTHAL_CONTEXTCREATECB>,
    pub ContextDestroy: ::std::option::Option<LPD3DNTHAL_CONTEXTDESTROYCB>,
    pub ContextDestroyAll: ::std::option::Option<LPD3DNTHAL_CONTEXTDESTROYALLCB>,
    pub SceneCapture: ::std::option::Option<LPD3DNTHAL_SCENECAPTURECB>,
    pub dwReserved10: *mut ::std::ffi::c_void,
    pub dwReserved11: *mut ::std::ffi::c_void,
    pub dwReserved22: *mut ::std::ffi::c_void,
    pub dwReserved23: *mut ::std::ffi::c_void,
    pub dwReserved: usize,
    pub TextureCreate: ::std::option::Option<LPD3DNTHAL_TEXTURECREATECB>,
    pub TextureDestroy: ::std::option::Option<LPD3DNTHAL_TEXTUREDESTROYCB>,
    pub TextureSwap: ::std::option::Option<LPD3DNTHAL_TEXTURESWAPCB>,
    pub TextureGetSurf: ::std::option::Option<LPD3DNTHAL_TEXTUREGETSURFCB>,
    pub dwReserved12: *mut ::std::ffi::c_void,
    pub dwReserved13: *mut ::std::ffi::c_void,
    pub dwReserved14: *mut ::std::ffi::c_void,
    pub dwReserved15: *mut ::std::ffi::c_void,
    pub dwReserved16: *mut ::std::ffi::c_void,
    pub dwReserved17: *mut ::std::ffi::c_void,
    pub dwReserved18: *mut ::std::ffi::c_void,
    pub dwReserved19: *mut ::std::ffi::c_void,
    pub dwReserved20: *mut ::std::ffi::c_void,
    pub dwReserved21: *mut ::std::ffi::c_void,
    pub dwReserved24: *mut ::std::ffi::c_void,
    pub dwReserved0: usize,
    pub dwReserved1: usize,
    pub dwReserved2: usize,
    pub dwReserved3: usize,
    pub dwReserved4: usize,
    pub dwReserved5: usize,
    pub dwReserved6: usize,
    pub dwReserved7: usize,
    pub dwReserved8: usize,
    pub dwReserved9: usize,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CALLBACKS {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CALLBACKS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for D3DNTHAL_CALLBACKS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CALLBACKS")
            .field("dwSize", &self.dwSize)
            .field("dwReserved10", &self.dwReserved10)
            .field("dwReserved11", &self.dwReserved11)
            .field("dwReserved22", &self.dwReserved22)
            .field("dwReserved23", &self.dwReserved23)
            .field("dwReserved", &self.dwReserved)
            .field("dwReserved12", &self.dwReserved12)
            .field("dwReserved13", &self.dwReserved13)
            .field("dwReserved14", &self.dwReserved14)
            .field("dwReserved15", &self.dwReserved15)
            .field("dwReserved16", &self.dwReserved16)
            .field("dwReserved17", &self.dwReserved17)
            .field("dwReserved18", &self.dwReserved18)
            .field("dwReserved19", &self.dwReserved19)
            .field("dwReserved20", &self.dwReserved20)
            .field("dwReserved21", &self.dwReserved21)
            .field("dwReserved24", &self.dwReserved24)
            .field("dwReserved0", &self.dwReserved0)
            .field("dwReserved1", &self.dwReserved1)
            .field("dwReserved2", &self.dwReserved2)
            .field("dwReserved3", &self.dwReserved3)
            .field("dwReserved4", &self.dwReserved4)
            .field("dwReserved5", &self.dwReserved5)
            .field("dwReserved6", &self.dwReserved6)
            .field("dwReserved7", &self.dwReserved7)
            .field("dwReserved8", &self.dwReserved8)
            .field("dwReserved9", &self.dwReserved9)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CALLBACKS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.ContextCreate.map(|f| f as usize) == other.ContextCreate.map(|f| f as usize)
            && self.ContextDestroy.map(|f| f as usize) == other.ContextDestroy.map(|f| f as usize)
            && self.ContextDestroyAll.map(|f| f as usize) == other.ContextDestroyAll.map(|f| f as usize)
            && self.SceneCapture.map(|f| f as usize) == other.SceneCapture.map(|f| f as usize)
            && self.dwReserved10 == other.dwReserved10
            && self.dwReserved11 == other.dwReserved11
            && self.dwReserved22 == other.dwReserved22
            && self.dwReserved23 == other.dwReserved23
            && self.dwReserved == other.dwReserved
            && self.TextureCreate.map(|f| f as usize) == other.TextureCreate.map(|f| f as usize)
            && self.TextureDestroy.map(|f| f as usize) == other.TextureDestroy.map(|f| f as usize)
            && self.TextureSwap.map(|f| f as usize) == other.TextureSwap.map(|f| f as usize)
            && self.TextureGetSurf.map(|f| f as usize) == other.TextureGetSurf.map(|f| f as usize)
            && self.dwReserved12 == other.dwReserved12
            && self.dwReserved13 == other.dwReserved13
            && self.dwReserved14 == other.dwReserved14
            && self.dwReserved15 == other.dwReserved15
            && self.dwReserved16 == other.dwReserved16
            && self.dwReserved17 == other.dwReserved17
            && self.dwReserved18 == other.dwReserved18
            && self.dwReserved19 == other.dwReserved19
            && self.dwReserved20 == other.dwReserved20
            && self.dwReserved21 == other.dwReserved21
            && self.dwReserved24 == other.dwReserved24
            && self.dwReserved0 == other.dwReserved0
            && self.dwReserved1 == other.dwReserved1
            && self.dwReserved2 == other.dwReserved2
            && self.dwReserved3 == other.dwReserved3
            && self.dwReserved4 == other.dwReserved4
            && self.dwReserved5 == other.dwReserved5
            && self.dwReserved6 == other.dwReserved6
            && self.dwReserved7 == other.dwReserved7
            && self.dwReserved8 == other.dwReserved8
            && self.dwReserved9 == other.dwReserved9
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CALLBACKS {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CALLBACKS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_CALLBACKS2 {
    pub dwSize: u32,
    pub dwFlags: u32,
    pub SetRenderTarget: ::std::option::Option<LPD3DNTHAL_SETRENDERTARGETCB>,
    pub dwReserved1: *mut ::std::ffi::c_void,
    pub dwReserved2: *mut ::std::ffi::c_void,
    pub dwReserved3: *mut ::std::ffi::c_void,
    pub dwReserved4: *mut ::std::ffi::c_void,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CALLBACKS2 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CALLBACKS2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for D3DNTHAL_CALLBACKS2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CALLBACKS2").field("dwSize", &self.dwSize).field("dwFlags", &self.dwFlags).field("dwReserved1", &self.dwReserved1).field("dwReserved2", &self.dwReserved2).field("dwReserved3", &self.dwReserved3).field("dwReserved4", &self.dwReserved4).finish()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CALLBACKS2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwFlags == other.dwFlags && self.SetRenderTarget.map(|f| f as usize) == other.SetRenderTarget.map(|f| f as usize) && self.dwReserved1 == other.dwReserved1 && self.dwReserved2 == other.dwReserved2 && self.dwReserved3 == other.dwReserved3 && self.dwReserved4 == other.dwReserved4
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CALLBACKS2 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CALLBACKS2 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_Direct3D9`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_CALLBACKS3 {
    pub dwSize: u32,
    pub dwFlags: u32,
    pub Clear2: ::std::option::Option<LPD3DNTHAL_CLEAR2CB>,
    pub lpvReserved: *mut ::std::ffi::c_void,
    pub ValidateTextureStageState: ::std::option::Option<LPD3DNTHAL_VALIDATETEXTURESTAGESTATECB>,
    pub DrawPrimitives2: ::std::option::Option<LPD3DNTHAL_DRAWPRIMITIVES2CB>,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CALLBACKS3 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CALLBACKS3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for D3DNTHAL_CALLBACKS3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CALLBACKS3").field("dwSize", &self.dwSize).field("dwFlags", &self.dwFlags).field("lpvReserved", &self.lpvReserved).finish()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CALLBACKS3 {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwFlags == other.dwFlags && self.Clear2.map(|f| f as usize) == other.Clear2.map(|f| f as usize) && self.lpvReserved == other.lpvReserved && self.ValidateTextureStageState.map(|f| f as usize) == other.ValidateTextureStageState.map(|f| f as usize) && self.DrawPrimitives2.map(|f| f as usize) == other.DrawPrimitives2.map(|f| f as usize)
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CALLBACKS3 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CALLBACKS3 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DNTHAL_CLEAR2DATA {
    pub dwhContext: usize,
    pub dwFlags: u32,
    pub dwFillColor: u32,
    pub dvFillDepth: f32,
    pub dwFillStencil: u32,
    pub lpRects: *mut super::super::Graphics::Direct3D9::D3DRECT,
    pub dwNumRects: u32,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DNTHAL_CLEAR2DATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DNTHAL_CLEAR2DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DNTHAL_CLEAR2DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CLEAR2DATA")
            .field("dwhContext", &self.dwhContext)
            .field("dwFlags", &self.dwFlags)
            .field("dwFillColor", &self.dwFillColor)
            .field("dvFillDepth", &self.dvFillDepth)
            .field("dwFillStencil", &self.dwFillStencil)
            .field("lpRects", &self.lpRects)
            .field("dwNumRects", &self.dwNumRects)
            .field("ddrval", &self.ddrval)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DNTHAL_CLEAR2DATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.dwFlags == other.dwFlags && self.dwFillColor == other.dwFillColor && self.dvFillDepth == other.dvFillDepth && self.dwFillStencil == other.dwFillStencil && self.lpRects == other.lpRects && self.dwNumRects == other.dwNumRects && self.ddrval == other.ddrval
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DNTHAL_CLEAR2DATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CLEAR2DATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_COL_WEIGHTS: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_CONTEXTCREATEDATA {
    pub Anonymous1: D3DNTHAL_CONTEXTCREATEDATA_0,
    pub Anonymous2: D3DNTHAL_CONTEXTCREATEDATA_1,
    pub Anonymous3: D3DNTHAL_CONTEXTCREATEDATA_2,
    pub dwPID: u32,
    pub dwhContext: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CONTEXTCREATEDATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CONTEXTCREATEDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTCREATEDATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTCREATEDATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTCREATEDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub union D3DNTHAL_CONTEXTCREATEDATA_0 {
    pub lpDDGbl: *mut super::super::UI::DisplayDevices::DD_DIRECTDRAW_GLOBAL,
    pub lpDDLcl: *mut super::super::UI::DisplayDevices::DD_DIRECTDRAW_LOCAL,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CONTEXTCREATEDATA_0 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CONTEXTCREATEDATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTCREATEDATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTCREATEDATA_0 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTCREATEDATA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub union D3DNTHAL_CONTEXTCREATEDATA_1 {
    pub lpDDS: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub lpDDSLcl: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CONTEXTCREATEDATA_1 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CONTEXTCREATEDATA_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTCREATEDATA_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTCREATEDATA_1 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTCREATEDATA_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub union D3DNTHAL_CONTEXTCREATEDATA_2 {
    pub lpDDSZ: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub lpDDSZLcl: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_CONTEXTCREATEDATA_2 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_CONTEXTCREATEDATA_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTCREATEDATA_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTCREATEDATA_2 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTCREATEDATA_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_CONTEXTDESTROYALLDATA {
    pub dwPID: u32,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_CONTEXTDESTROYALLDATA {}
impl ::std::default::Default for D3DNTHAL_CONTEXTDESTROYALLDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_CONTEXTDESTROYALLDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CONTEXTDESTROYALLDATA").field("dwPID", &self.dwPID).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTDESTROYALLDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwPID == other.dwPID && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTDESTROYALLDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTDESTROYALLDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_CONTEXTDESTROYDATA {
    pub dwhContext: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_CONTEXTDESTROYDATA {}
impl ::std::default::Default for D3DNTHAL_CONTEXTDESTROYDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_CONTEXTDESTROYDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_CONTEXTDESTROYDATA").field("dwhContext", &self.dwhContext).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_CONTEXTDESTROYDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_CONTEXTDESTROYDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_CONTEXTDESTROYDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_CONTEXT_BAD: i64 = 512i64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_D3DDX6EXTENDEDCAPS {
    pub dwSize: u32,
    pub dwMinTextureWidth: u32,
    pub dwMaxTextureWidth: u32,
    pub dwMinTextureHeight: u32,
    pub dwMaxTextureHeight: u32,
    pub dwMinStippleWidth: u32,
    pub dwMaxStippleWidth: u32,
    pub dwMinStippleHeight: u32,
    pub dwMaxStippleHeight: u32,
    pub dwMaxTextureRepeat: u32,
    pub dwMaxTextureAspectRatio: u32,
    pub dwMaxAnisotropy: u32,
    pub dvGuardBandLeft: f32,
    pub dvGuardBandTop: f32,
    pub dvGuardBandRight: f32,
    pub dvGuardBandBottom: f32,
    pub dvExtentsAdjust: f32,
    pub dwStencilCaps: u32,
    pub dwFVFCaps: u32,
    pub dwTextureOpCaps: u32,
    pub wMaxTextureBlendStages: u16,
    pub wMaxSimultaneousTextures: u16,
}
impl D3DNTHAL_D3DDX6EXTENDEDCAPS {}
impl ::std::default::Default for D3DNTHAL_D3DDX6EXTENDEDCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_D3DDX6EXTENDEDCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_D3DDX6EXTENDEDCAPS")
            .field("dwSize", &self.dwSize)
            .field("dwMinTextureWidth", &self.dwMinTextureWidth)
            .field("dwMaxTextureWidth", &self.dwMaxTextureWidth)
            .field("dwMinTextureHeight", &self.dwMinTextureHeight)
            .field("dwMaxTextureHeight", &self.dwMaxTextureHeight)
            .field("dwMinStippleWidth", &self.dwMinStippleWidth)
            .field("dwMaxStippleWidth", &self.dwMaxStippleWidth)
            .field("dwMinStippleHeight", &self.dwMinStippleHeight)
            .field("dwMaxStippleHeight", &self.dwMaxStippleHeight)
            .field("dwMaxTextureRepeat", &self.dwMaxTextureRepeat)
            .field("dwMaxTextureAspectRatio", &self.dwMaxTextureAspectRatio)
            .field("dwMaxAnisotropy", &self.dwMaxAnisotropy)
            .field("dvGuardBandLeft", &self.dvGuardBandLeft)
            .field("dvGuardBandTop", &self.dvGuardBandTop)
            .field("dvGuardBandRight", &self.dvGuardBandRight)
            .field("dvGuardBandBottom", &self.dvGuardBandBottom)
            .field("dvExtentsAdjust", &self.dvExtentsAdjust)
            .field("dwStencilCaps", &self.dwStencilCaps)
            .field("dwFVFCaps", &self.dwFVFCaps)
            .field("dwTextureOpCaps", &self.dwTextureOpCaps)
            .field("wMaxTextureBlendStages", &self.wMaxTextureBlendStages)
            .field("wMaxSimultaneousTextures", &self.wMaxSimultaneousTextures)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_D3DDX6EXTENDEDCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwMinTextureWidth == other.dwMinTextureWidth
            && self.dwMaxTextureWidth == other.dwMaxTextureWidth
            && self.dwMinTextureHeight == other.dwMinTextureHeight
            && self.dwMaxTextureHeight == other.dwMaxTextureHeight
            && self.dwMinStippleWidth == other.dwMinStippleWidth
            && self.dwMaxStippleWidth == other.dwMaxStippleWidth
            && self.dwMinStippleHeight == other.dwMinStippleHeight
            && self.dwMaxStippleHeight == other.dwMaxStippleHeight
            && self.dwMaxTextureRepeat == other.dwMaxTextureRepeat
            && self.dwMaxTextureAspectRatio == other.dwMaxTextureAspectRatio
            && self.dwMaxAnisotropy == other.dwMaxAnisotropy
            && self.dvGuardBandLeft == other.dvGuardBandLeft
            && self.dvGuardBandTop == other.dvGuardBandTop
            && self.dvGuardBandRight == other.dvGuardBandRight
            && self.dvGuardBandBottom == other.dvGuardBandBottom
            && self.dvExtentsAdjust == other.dvExtentsAdjust
            && self.dwStencilCaps == other.dwStencilCaps
            && self.dwFVFCaps == other.dwFVFCaps
            && self.dwTextureOpCaps == other.dwTextureOpCaps
            && self.wMaxTextureBlendStages == other.wMaxTextureBlendStages
            && self.wMaxSimultaneousTextures == other.wMaxSimultaneousTextures
    }
}
impl ::std::cmp::Eq for D3DNTHAL_D3DDX6EXTENDEDCAPS {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_D3DDX6EXTENDEDCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_D3DEXTENDEDCAPS {
    pub dwSize: u32,
    pub dwMinTextureWidth: u32,
    pub dwMaxTextureWidth: u32,
    pub dwMinTextureHeight: u32,
    pub dwMaxTextureHeight: u32,
    pub dwMinStippleWidth: u32,
    pub dwMaxStippleWidth: u32,
    pub dwMinStippleHeight: u32,
    pub dwMaxStippleHeight: u32,
    pub dwMaxTextureRepeat: u32,
    pub dwMaxTextureAspectRatio: u32,
    pub dwMaxAnisotropy: u32,
    pub dvGuardBandLeft: f32,
    pub dvGuardBandTop: f32,
    pub dvGuardBandRight: f32,
    pub dvGuardBandBottom: f32,
    pub dvExtentsAdjust: f32,
    pub dwStencilCaps: u32,
    pub dwFVFCaps: u32,
    pub dwTextureOpCaps: u32,
    pub wMaxTextureBlendStages: u16,
    pub wMaxSimultaneousTextures: u16,
    pub dwMaxActiveLights: u32,
    pub dvMaxVertexW: f32,
    pub wMaxUserClipPlanes: u16,
    pub wMaxVertexBlendMatrices: u16,
    pub dwVertexProcessingCaps: u32,
    pub dwReserved1: u32,
    pub dwReserved2: u32,
    pub dwReserved3: u32,
    pub dwReserved4: u32,
}
impl D3DNTHAL_D3DEXTENDEDCAPS {}
impl ::std::default::Default for D3DNTHAL_D3DEXTENDEDCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_D3DEXTENDEDCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_D3DEXTENDEDCAPS")
            .field("dwSize", &self.dwSize)
            .field("dwMinTextureWidth", &self.dwMinTextureWidth)
            .field("dwMaxTextureWidth", &self.dwMaxTextureWidth)
            .field("dwMinTextureHeight", &self.dwMinTextureHeight)
            .field("dwMaxTextureHeight", &self.dwMaxTextureHeight)
            .field("dwMinStippleWidth", &self.dwMinStippleWidth)
            .field("dwMaxStippleWidth", &self.dwMaxStippleWidth)
            .field("dwMinStippleHeight", &self.dwMinStippleHeight)
            .field("dwMaxStippleHeight", &self.dwMaxStippleHeight)
            .field("dwMaxTextureRepeat", &self.dwMaxTextureRepeat)
            .field("dwMaxTextureAspectRatio", &self.dwMaxTextureAspectRatio)
            .field("dwMaxAnisotropy", &self.dwMaxAnisotropy)
            .field("dvGuardBandLeft", &self.dvGuardBandLeft)
            .field("dvGuardBandTop", &self.dvGuardBandTop)
            .field("dvGuardBandRight", &self.dvGuardBandRight)
            .field("dvGuardBandBottom", &self.dvGuardBandBottom)
            .field("dvExtentsAdjust", &self.dvExtentsAdjust)
            .field("dwStencilCaps", &self.dwStencilCaps)
            .field("dwFVFCaps", &self.dwFVFCaps)
            .field("dwTextureOpCaps", &self.dwTextureOpCaps)
            .field("wMaxTextureBlendStages", &self.wMaxTextureBlendStages)
            .field("wMaxSimultaneousTextures", &self.wMaxSimultaneousTextures)
            .field("dwMaxActiveLights", &self.dwMaxActiveLights)
            .field("dvMaxVertexW", &self.dvMaxVertexW)
            .field("wMaxUserClipPlanes", &self.wMaxUserClipPlanes)
            .field("wMaxVertexBlendMatrices", &self.wMaxVertexBlendMatrices)
            .field("dwVertexProcessingCaps", &self.dwVertexProcessingCaps)
            .field("dwReserved1", &self.dwReserved1)
            .field("dwReserved2", &self.dwReserved2)
            .field("dwReserved3", &self.dwReserved3)
            .field("dwReserved4", &self.dwReserved4)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_D3DEXTENDEDCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwMinTextureWidth == other.dwMinTextureWidth
            && self.dwMaxTextureWidth == other.dwMaxTextureWidth
            && self.dwMinTextureHeight == other.dwMinTextureHeight
            && self.dwMaxTextureHeight == other.dwMaxTextureHeight
            && self.dwMinStippleWidth == other.dwMinStippleWidth
            && self.dwMaxStippleWidth == other.dwMaxStippleWidth
            && self.dwMinStippleHeight == other.dwMinStippleHeight
            && self.dwMaxStippleHeight == other.dwMaxStippleHeight
            && self.dwMaxTextureRepeat == other.dwMaxTextureRepeat
            && self.dwMaxTextureAspectRatio == other.dwMaxTextureAspectRatio
            && self.dwMaxAnisotropy == other.dwMaxAnisotropy
            && self.dvGuardBandLeft == other.dvGuardBandLeft
            && self.dvGuardBandTop == other.dvGuardBandTop
            && self.dvGuardBandRight == other.dvGuardBandRight
            && self.dvGuardBandBottom == other.dvGuardBandBottom
            && self.dvExtentsAdjust == other.dvExtentsAdjust
            && self.dwStencilCaps == other.dwStencilCaps
            && self.dwFVFCaps == other.dwFVFCaps
            && self.dwTextureOpCaps == other.dwTextureOpCaps
            && self.wMaxTextureBlendStages == other.wMaxTextureBlendStages
            && self.wMaxSimultaneousTextures == other.wMaxSimultaneousTextures
            && self.dwMaxActiveLights == other.dwMaxActiveLights
            && self.dvMaxVertexW == other.dvMaxVertexW
            && self.wMaxUserClipPlanes == other.wMaxUserClipPlanes
            && self.wMaxVertexBlendMatrices == other.wMaxVertexBlendMatrices
            && self.dwVertexProcessingCaps == other.dwVertexProcessingCaps
            && self.dwReserved1 == other.dwReserved1
            && self.dwReserved2 == other.dwReserved2
            && self.dwReserved3 == other.dwReserved3
            && self.dwReserved4 == other.dwReserved4
    }
}
impl ::std::cmp::Eq for D3DNTHAL_D3DEXTENDEDCAPS {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_D3DEXTENDEDCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DNTHAL_DP2CLEAR {
    pub dwFlags: u32,
    pub dwFillColor: u32,
    pub dvFillDepth: f32,
    pub dwFillStencil: u32,
    pub Rects: [super::super::Foundation::RECT; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl D3DNTHAL_DP2CLEAR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DNTHAL_DP2CLEAR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DNTHAL_DP2CLEAR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2CLEAR").field("dwFlags", &self.dwFlags).field("dwFillColor", &self.dwFillColor).field("dvFillDepth", &self.dvFillDepth).field("dwFillStencil", &self.dwFillStencil).field("Rects", &self.Rects).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2CLEAR {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwFillColor == other.dwFillColor && self.dvFillDepth == other.dvFillDepth && self.dwFillStencil == other.dwFillStencil && self.Rects == other.Rects
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DNTHAL_DP2CLEAR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2CLEAR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2COMMAND {
    pub bCommand: u8,
    pub bReserved: u8,
    pub Anonymous: D3DNTHAL_DP2COMMAND_0,
}
impl D3DNTHAL_DP2COMMAND {}
impl ::std::default::Default for D3DNTHAL_DP2COMMAND {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2COMMAND {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2COMMAND {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2COMMAND {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DNTHAL_DP2COMMAND_0 {
    pub wPrimitiveCount: u16,
    pub wStateCount: u16,
}
impl D3DNTHAL_DP2COMMAND_0 {}
impl ::std::default::Default for D3DNTHAL_DP2COMMAND_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2COMMAND_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2COMMAND_0 {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2COMMAND_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2CREATELIGHT {
    pub dwIndex: u32,
}
impl D3DNTHAL_DP2CREATELIGHT {}
impl ::std::default::Default for D3DNTHAL_DP2CREATELIGHT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2CREATELIGHT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2CREATELIGHT").field("dwIndex", &self.dwIndex).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2CREATELIGHT {
    fn eq(&self, other: &Self) -> bool {
        self.dwIndex == other.dwIndex
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2CREATELIGHT {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2CREATELIGHT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2EXT {
    pub dwExtToken: u32,
    pub dwSize: u32,
}
impl D3DNTHAL_DP2EXT {}
impl ::std::default::Default for D3DNTHAL_DP2EXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2EXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2EXT").field("dwExtToken", &self.dwExtToken).field("dwSize", &self.dwSize).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2EXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwExtToken == other.dwExtToken && self.dwSize == other.dwSize
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2EXT {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2EXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDLINELIST {
    pub wV1: u16,
    pub wV2: u16,
}
impl D3DNTHAL_DP2INDEXEDLINELIST {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDLINELIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDLINELIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDLINELIST").field("wV1", &self.wV1).field("wV2", &self.wV2).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDLINELIST {
    fn eq(&self, other: &Self) -> bool {
        self.wV1 == other.wV1 && self.wV2 == other.wV2
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDLINELIST {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDLINELIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDLINESTRIP {
    pub wV: [u16; 2],
}
impl D3DNTHAL_DP2INDEXEDLINESTRIP {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDLINESTRIP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDLINESTRIP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDLINESTRIP").field("wV", &self.wV).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDLINESTRIP {
    fn eq(&self, other: &Self) -> bool {
        self.wV == other.wV
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDLINESTRIP {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDLINESTRIP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDTRIANGLEFAN {
    pub wV: [u16; 3],
}
impl D3DNTHAL_DP2INDEXEDTRIANGLEFAN {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDTRIANGLEFAN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDTRIANGLEFAN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDTRIANGLEFAN").field("wV", &self.wV).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDTRIANGLEFAN {
    fn eq(&self, other: &Self) -> bool {
        self.wV == other.wV
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDTRIANGLEFAN {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDTRIANGLEFAN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDTRIANGLELIST {
    pub wV1: u16,
    pub wV2: u16,
    pub wV3: u16,
    pub wFlags: u16,
}
impl D3DNTHAL_DP2INDEXEDTRIANGLELIST {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDTRIANGLELIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDTRIANGLELIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDTRIANGLELIST").field("wV1", &self.wV1).field("wV2", &self.wV2).field("wV3", &self.wV3).field("wFlags", &self.wFlags).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDTRIANGLELIST {
    fn eq(&self, other: &Self) -> bool {
        self.wV1 == other.wV1 && self.wV2 == other.wV2 && self.wV3 == other.wV3 && self.wFlags == other.wFlags
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDTRIANGLELIST {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDTRIANGLELIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {
    pub wV1: u16,
    pub wV2: u16,
    pub wV3: u16,
}
impl D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDTRIANGLELIST2").field("wV1", &self.wV1).field("wV2", &self.wV2).field("wV3", &self.wV3).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {
    fn eq(&self, other: &Self) -> bool {
        self.wV1 == other.wV1 && self.wV2 == other.wV2 && self.wV3 == other.wV3
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDTRIANGLELIST2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {
    pub wV: [u16; 3],
}
impl D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {}
impl ::std::default::Default for D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2INDEXEDTRIANGLESTRIP").field("wV", &self.wV).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {
    fn eq(&self, other: &Self) -> bool {
        self.wV == other.wV
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2INDEXEDTRIANGLESTRIP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2LINELIST {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2LINELIST {}
impl ::std::default::Default for D3DNTHAL_DP2LINELIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2LINELIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2LINELIST").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2LINELIST {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2LINELIST {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2LINELIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2LINESTRIP {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2LINESTRIP {}
impl ::std::default::Default for D3DNTHAL_DP2LINESTRIP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2LINESTRIP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2LINESTRIP").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2LINESTRIP {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2LINESTRIP {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2LINESTRIP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DNTHAL_DP2OPERATION(pub i32);
pub const D3DNTDP2OP_POINTS: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(1i32);
pub const D3DNTDP2OP_INDEXEDLINELIST: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(2i32);
pub const D3DNTDP2OP_INDEXEDTRIANGLELIST: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(3i32);
pub const D3DNTDP2OP_RENDERSTATE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(8i32);
pub const D3DNTDP2OP_LINELIST: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(15i32);
pub const D3DNTDP2OP_LINESTRIP: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(16i32);
pub const D3DNTDP2OP_INDEXEDLINESTRIP: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(17i32);
pub const D3DNTDP2OP_TRIANGLELIST: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(18i32);
pub const D3DNTDP2OP_TRIANGLESTRIP: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(19i32);
pub const D3DNTDP2OP_INDEXEDTRIANGLESTRIP: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(20i32);
pub const D3DNTDP2OP_TRIANGLEFAN: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(21i32);
pub const D3DNTDP2OP_INDEXEDTRIANGLEFAN: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(22i32);
pub const D3DNTDP2OP_TRIANGLEFAN_IMM: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(23i32);
pub const D3DNTDP2OP_LINELIST_IMM: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(24i32);
pub const D3DNTDP2OP_TEXTURESTAGESTATE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(25i32);
pub const D3DNTDP2OP_INDEXEDTRIANGLELIST2: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(26i32);
pub const D3DNTDP2OP_INDEXEDLINELIST2: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(27i32);
pub const D3DNTDP2OP_VIEWPORTINFO: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(28i32);
pub const D3DNTDP2OP_WINFO: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(29i32);
pub const D3DNTDP2OP_SETPALETTE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(30i32);
pub const D3DNTDP2OP_UPDATEPALETTE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(31i32);
pub const D3DNTDP2OP_ZRANGE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(32i32);
pub const D3DNTDP2OP_SETMATERIAL: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(33i32);
pub const D3DNTDP2OP_SETLIGHT: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(34i32);
pub const D3DNTDP2OP_CREATELIGHT: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(35i32);
pub const D3DNTDP2OP_SETTRANSFORM: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(36i32);
pub const D3DNTDP2OP_TEXBLT: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(38i32);
pub const D3DNTDP2OP_STATESET: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(39i32);
pub const D3DNTDP2OP_SETPRIORITY: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(40i32);
pub const D3DNTDP2OP_SETRENDERTARGET: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(41i32);
pub const D3DNTDP2OP_CLEAR: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(42i32);
pub const D3DNTDP2OP_SETTEXLOD: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(43i32);
pub const D3DNTDP2OP_SETCLIPPLANE: D3DNTHAL_DP2OPERATION = D3DNTHAL_DP2OPERATION(44i32);
impl ::std::convert::From<i32> for D3DNTHAL_DP2OPERATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2OPERATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2POINTS {
    pub wCount: u16,
    pub wVStart: u16,
}
impl D3DNTHAL_DP2POINTS {}
impl ::std::default::Default for D3DNTHAL_DP2POINTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2POINTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2POINTS").field("wCount", &self.wCount).field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2POINTS {
    fn eq(&self, other: &Self) -> bool {
        self.wCount == other.wCount && self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2POINTS {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2POINTS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DNTHAL_DP2RENDERSTATE {
    pub RenderState: super::super::Graphics::Direct3D9::D3DRENDERSTATETYPE,
    pub Anonymous: D3DNTHAL_DP2RENDERSTATE_0,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DNTHAL_DP2RENDERSTATE {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DNTHAL_DP2RENDERSTATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2RENDERSTATE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DNTHAL_DP2RENDERSTATE {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2RENDERSTATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DNTHAL_DP2RENDERSTATE_0 {
    pub fState: f32,
    pub dwState: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DNTHAL_DP2RENDERSTATE_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DNTHAL_DP2RENDERSTATE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2RENDERSTATE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DNTHAL_DP2RENDERSTATE_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2RENDERSTATE_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETCLIPPLANE {
    pub dwIndex: u32,
    pub plane: [f32; 4],
}
impl D3DNTHAL_DP2SETCLIPPLANE {}
impl ::std::default::Default for D3DNTHAL_DP2SETCLIPPLANE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2SETCLIPPLANE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2SETCLIPPLANE").field("dwIndex", &self.dwIndex).field("plane", &self.plane).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETCLIPPLANE {
    fn eq(&self, other: &Self) -> bool {
        self.dwIndex == other.dwIndex && self.plane == other.plane
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETCLIPPLANE {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETCLIPPLANE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETLIGHT {
    pub dwIndex: u32,
    pub Anonymous: D3DNTHAL_DP2SETLIGHT_0,
}
impl D3DNTHAL_DP2SETLIGHT {}
impl ::std::default::Default for D3DNTHAL_DP2SETLIGHT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETLIGHT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETLIGHT {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETLIGHT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DNTHAL_DP2SETLIGHT_0 {
    pub lightData: u32,
    pub dwDataType: u32,
}
impl D3DNTHAL_DP2SETLIGHT_0 {}
impl ::std::default::Default for D3DNTHAL_DP2SETLIGHT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETLIGHT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETLIGHT_0 {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETLIGHT_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETPALETTE {
    pub dwPaletteHandle: u32,
    pub dwPaletteFlags: u32,
    pub dwSurfaceHandle: u32,
}
impl D3DNTHAL_DP2SETPALETTE {}
impl ::std::default::Default for D3DNTHAL_DP2SETPALETTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2SETPALETTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2SETPALETTE").field("dwPaletteHandle", &self.dwPaletteHandle).field("dwPaletteFlags", &self.dwPaletteFlags).field("dwSurfaceHandle", &self.dwSurfaceHandle).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETPALETTE {
    fn eq(&self, other: &Self) -> bool {
        self.dwPaletteHandle == other.dwPaletteHandle && self.dwPaletteFlags == other.dwPaletteFlags && self.dwSurfaceHandle == other.dwSurfaceHandle
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETPALETTE {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETPALETTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETPRIORITY {
    pub dwDDDestSurface: u32,
    pub dwPriority: u32,
}
impl D3DNTHAL_DP2SETPRIORITY {}
impl ::std::default::Default for D3DNTHAL_DP2SETPRIORITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2SETPRIORITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2SETPRIORITY").field("dwDDDestSurface", &self.dwDDDestSurface).field("dwPriority", &self.dwPriority).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETPRIORITY {
    fn eq(&self, other: &Self) -> bool {
        self.dwDDDestSurface == other.dwDDDestSurface && self.dwPriority == other.dwPriority
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETPRIORITY {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETPRIORITY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETRENDERTARGET {
    pub hRenderTarget: u32,
    pub hZBuffer: u32,
}
impl D3DNTHAL_DP2SETRENDERTARGET {}
impl ::std::default::Default for D3DNTHAL_DP2SETRENDERTARGET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2SETRENDERTARGET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2SETRENDERTARGET").field("hRenderTarget", &self.hRenderTarget).field("hZBuffer", &self.hZBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETRENDERTARGET {
    fn eq(&self, other: &Self) -> bool {
        self.hRenderTarget == other.hRenderTarget && self.hZBuffer == other.hZBuffer
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETRENDERTARGET {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETRENDERTARGET {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2SETTEXLOD {
    pub dwDDSurface: u32,
    pub dwLOD: u32,
}
impl D3DNTHAL_DP2SETTEXLOD {}
impl ::std::default::Default for D3DNTHAL_DP2SETTEXLOD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2SETTEXLOD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2SETTEXLOD").field("dwDDSurface", &self.dwDDSurface).field("dwLOD", &self.dwLOD).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETTEXLOD {
    fn eq(&self, other: &Self) -> bool {
        self.dwDDSurface == other.dwDDSurface && self.dwLOD == other.dwLOD
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2SETTEXLOD {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETTEXLOD {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DNTHAL_DP2SETTRANSFORM {
    pub xfrmType: super::super::Graphics::Direct3D9::D3DTRANSFORMSTATETYPE,
    pub matrix: super::super::Graphics::Direct3D9::D3DMATRIX,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DNTHAL_DP2SETTRANSFORM {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DNTHAL_DP2SETTRANSFORM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2SETTRANSFORM {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DNTHAL_DP2SETTRANSFORM {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2SETTRANSFORM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2STARTVERTEX {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2STARTVERTEX {}
impl ::std::default::Default for D3DNTHAL_DP2STARTVERTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2STARTVERTEX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2STARTVERTEX").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2STARTVERTEX {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2STARTVERTEX {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2STARTVERTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DNTHAL_DP2STATESET {
    pub dwOperation: u32,
    pub dwParam: u32,
    pub sbType: super::super::Graphics::Direct3D9::D3DSTATEBLOCKTYPE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DNTHAL_DP2STATESET {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DNTHAL_DP2STATESET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DNTHAL_DP2STATESET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2STATESET").field("dwOperation", &self.dwOperation).field("dwParam", &self.dwParam).field("sbType", &self.sbType).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2STATESET {
    fn eq(&self, other: &Self) -> bool {
        self.dwOperation == other.dwOperation && self.dwParam == other.dwParam && self.sbType == other.sbType
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DNTHAL_DP2STATESET {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2STATESET {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DNTHAL_DP2TEXBLT {
    pub dwDDDestSurface: u32,
    pub dwDDSrcSurface: u32,
    pub pDest: super::super::Foundation::POINT,
    pub rSrc: super::super::Foundation::RECTL,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DNTHAL_DP2TEXBLT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DNTHAL_DP2TEXBLT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DNTHAL_DP2TEXBLT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TEXBLT").field("dwDDDestSurface", &self.dwDDDestSurface).field("dwDDSrcSurface", &self.dwDDSrcSurface).field("pDest", &self.pDest).field("rSrc", &self.rSrc).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TEXBLT {
    fn eq(&self, other: &Self) -> bool {
        self.dwDDDestSurface == other.dwDDDestSurface && self.dwDDSrcSurface == other.dwDDSrcSurface && self.pDest == other.pDest && self.rSrc == other.rSrc && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DNTHAL_DP2TEXBLT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TEXBLT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2TEXTURESTAGESTATE {
    pub wStage: u16,
    pub TSState: u16,
    pub dwValue: u32,
}
impl D3DNTHAL_DP2TEXTURESTAGESTATE {}
impl ::std::default::Default for D3DNTHAL_DP2TEXTURESTAGESTATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2TEXTURESTAGESTATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TEXTURESTAGESTATE").field("wStage", &self.wStage).field("TSState", &self.TSState).field("dwValue", &self.dwValue).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TEXTURESTAGESTATE {
    fn eq(&self, other: &Self) -> bool {
        self.wStage == other.wStage && self.TSState == other.TSState && self.dwValue == other.dwValue
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2TEXTURESTAGESTATE {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TEXTURESTAGESTATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2TRIANGLEFAN {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2TRIANGLEFAN {}
impl ::std::default::Default for D3DNTHAL_DP2TRIANGLEFAN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2TRIANGLEFAN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TRIANGLEFAN").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TRIANGLEFAN {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2TRIANGLEFAN {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TRIANGLEFAN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2TRIANGLEFAN_IMM {
    pub dwEdgeFlags: u32,
}
impl D3DNTHAL_DP2TRIANGLEFAN_IMM {}
impl ::std::default::Default for D3DNTHAL_DP2TRIANGLEFAN_IMM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2TRIANGLEFAN_IMM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TRIANGLEFAN_IMM").field("dwEdgeFlags", &self.dwEdgeFlags).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TRIANGLEFAN_IMM {
    fn eq(&self, other: &Self) -> bool {
        self.dwEdgeFlags == other.dwEdgeFlags
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2TRIANGLEFAN_IMM {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TRIANGLEFAN_IMM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2TRIANGLELIST {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2TRIANGLELIST {}
impl ::std::default::Default for D3DNTHAL_DP2TRIANGLELIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2TRIANGLELIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TRIANGLELIST").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TRIANGLELIST {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2TRIANGLELIST {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TRIANGLELIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2TRIANGLESTRIP {
    pub wVStart: u16,
}
impl D3DNTHAL_DP2TRIANGLESTRIP {}
impl ::std::default::Default for D3DNTHAL_DP2TRIANGLESTRIP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2TRIANGLESTRIP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2TRIANGLESTRIP").field("wVStart", &self.wVStart).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2TRIANGLESTRIP {
    fn eq(&self, other: &Self) -> bool {
        self.wVStart == other.wVStart
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2TRIANGLESTRIP {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2TRIANGLESTRIP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2UPDATEPALETTE {
    pub dwPaletteHandle: u32,
    pub wStartIndex: u16,
    pub wNumEntries: u16,
}
impl D3DNTHAL_DP2UPDATEPALETTE {}
impl ::std::default::Default for D3DNTHAL_DP2UPDATEPALETTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2UPDATEPALETTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2UPDATEPALETTE").field("dwPaletteHandle", &self.dwPaletteHandle).field("wStartIndex", &self.wStartIndex).field("wNumEntries", &self.wNumEntries).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2UPDATEPALETTE {
    fn eq(&self, other: &Self) -> bool {
        self.dwPaletteHandle == other.dwPaletteHandle && self.wStartIndex == other.wStartIndex && self.wNumEntries == other.wNumEntries
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2UPDATEPALETTE {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2UPDATEPALETTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2VIEWPORTINFO {
    pub dwX: u32,
    pub dwY: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
}
impl D3DNTHAL_DP2VIEWPORTINFO {}
impl ::std::default::Default for D3DNTHAL_DP2VIEWPORTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2VIEWPORTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2VIEWPORTINFO").field("dwX", &self.dwX).field("dwY", &self.dwY).field("dwWidth", &self.dwWidth).field("dwHeight", &self.dwHeight).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2VIEWPORTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwX == other.dwX && self.dwY == other.dwY && self.dwWidth == other.dwWidth && self.dwHeight == other.dwHeight
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2VIEWPORTINFO {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2VIEWPORTINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2WINFO {
    pub dvWNear: f32,
    pub dvWFar: f32,
}
impl D3DNTHAL_DP2WINFO {}
impl ::std::default::Default for D3DNTHAL_DP2WINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2WINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2WINFO").field("dvWNear", &self.dvWNear).field("dvWFar", &self.dvWFar).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2WINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dvWNear == other.dvWNear && self.dvWFar == other.dvWFar
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2WINFO {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2WINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_DP2ZRANGE {
    pub dvMinZ: f32,
    pub dvMaxZ: f32,
}
impl D3DNTHAL_DP2ZRANGE {}
impl ::std::default::Default for D3DNTHAL_DP2ZRANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_DP2ZRANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_DP2ZRANGE").field("dvMinZ", &self.dvMinZ).field("dvMaxZ", &self.dvMaxZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_DP2ZRANGE {
    fn eq(&self, other: &Self) -> bool {
        self.dvMinZ == other.dvMinZ && self.dvMaxZ == other.dvMaxZ
    }
}
impl ::std::cmp::Eq for D3DNTHAL_DP2ZRANGE {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DP2ZRANGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_DRAWPRIMITIVES2DATA {
    pub dwhContext: usize,
    pub dwFlags: u32,
    pub dwVertexType: u32,
    pub lpDDCommands: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub dwCommandOffset: u32,
    pub dwCommandLength: u32,
    pub Anonymous1: D3DNTHAL_DRAWPRIMITIVES2DATA_0,
    pub dwVertexOffset: u32,
    pub dwVertexLength: u32,
    pub dwReqVertexBufSize: u32,
    pub dwReqCommandBufSize: u32,
    pub lpdwRStates: *mut u32,
    pub Anonymous2: D3DNTHAL_DRAWPRIMITIVES2DATA_1,
    pub dwErrorOffset: u32,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_DRAWPRIMITIVES2DATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_DRAWPRIMITIVES2DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_DRAWPRIMITIVES2DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_DRAWPRIMITIVES2DATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DRAWPRIMITIVES2DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub union D3DNTHAL_DRAWPRIMITIVES2DATA_0 {
    pub lpDDVertex: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub lpVertices: *mut ::std::ffi::c_void,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_DRAWPRIMITIVES2DATA_0 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_DRAWPRIMITIVES2DATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_DRAWPRIMITIVES2DATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_DRAWPRIMITIVES2DATA_0 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DRAWPRIMITIVES2DATA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub union D3DNTHAL_DRAWPRIMITIVES2DATA_1 {
    pub dwVertexSize: u32,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_DRAWPRIMITIVES2DATA_1 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_DRAWPRIMITIVES2DATA_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_DRAWPRIMITIVES2DATA_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_DRAWPRIMITIVES2DATA_1 {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_DRAWPRIMITIVES2DATA_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`*"]
pub struct D3DNTHAL_GLOBALDRIVERDATA {
    pub dwSize: u32,
    pub hwCaps: _D3DNTHALDeviceDesc_V1,
    pub dwNumVertices: u32,
    pub dwNumClipVertices: u32,
    pub dwNumTextureFormats: u32,
    pub lpTextureFormats: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
impl D3DNTHAL_GLOBALDRIVERDATA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
impl ::std::default::Default for D3DNTHAL_GLOBALDRIVERDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
impl ::std::fmt::Debug for D3DNTHAL_GLOBALDRIVERDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_GLOBALDRIVERDATA")
            .field("dwSize", &self.dwSize)
            .field("hwCaps", &self.hwCaps)
            .field("dwNumVertices", &self.dwNumVertices)
            .field("dwNumClipVertices", &self.dwNumClipVertices)
            .field("dwNumTextureFormats", &self.dwNumTextureFormats)
            .field("lpTextureFormats", &self.lpTextureFormats)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
impl ::std::cmp::PartialEq for D3DNTHAL_GLOBALDRIVERDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.hwCaps == other.hwCaps && self.dwNumVertices == other.dwNumVertices && self.dwNumClipVertices == other.dwNumClipVertices && self.dwNumTextureFormats == other.dwNumTextureFormats && self.lpTextureFormats == other.lpTextureFormats
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
impl ::std::cmp::Eq for D3DNTHAL_GLOBALDRIVERDATA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_GLOBALDRIVERDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_NUMCLIPVERTICES: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_OUTOFCONTEXTS: i64 = 513i64;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_ROW_WEIGHTS: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_SCENECAPTUREDATA {
    pub dwhContext: usize,
    pub dwFlag: u32,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_SCENECAPTUREDATA {}
impl ::std::default::Default for D3DNTHAL_SCENECAPTUREDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_SCENECAPTUREDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_SCENECAPTUREDATA").field("dwhContext", &self.dwhContext).field("dwFlag", &self.dwFlag).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_SCENECAPTUREDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.dwFlag == other.dwFlag && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_SCENECAPTUREDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_SCENECAPTUREDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_SCENE_CAPTURE_END: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_SCENE_CAPTURE_START: i32 = 0i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
pub struct D3DNTHAL_SETRENDERTARGETDATA {
    pub dwhContext: usize,
    pub lpDDS: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub lpDDSZ: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl D3DNTHAL_SETRENDERTARGETDATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for D3DNTHAL_SETRENDERTARGETDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for D3DNTHAL_SETRENDERTARGETDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_SETRENDERTARGETDATA").field("dwhContext", &self.dwhContext).field("lpDDS", &self.lpDDS).field("lpDDSZ", &self.lpDDSZ).field("ddrval", &self.ddrval).finish()
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for D3DNTHAL_SETRENDERTARGETDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.lpDDS == other.lpDDS && self.lpDDSZ == other.lpDDSZ && self.ddrval == other.ddrval
    }
}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for D3DNTHAL_SETRENDERTARGETDATA {}
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_SETRENDERTARGETDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_STATESETCREATE: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DNTHAL_TEXTURECREATEDATA {
    pub dwhContext: usize,
    pub hDDS: super::super::Foundation::HANDLE,
    pub dwHandle: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DNTHAL_TEXTURECREATEDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DNTHAL_TEXTURECREATEDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DNTHAL_TEXTURECREATEDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_TEXTURECREATEDATA").field("dwhContext", &self.dwhContext).field("hDDS", &self.hDDS).field("dwHandle", &self.dwHandle).field("ddrval", &self.ddrval).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DNTHAL_TEXTURECREATEDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.hDDS == other.hDDS && self.dwHandle == other.dwHandle && self.ddrval == other.ddrval
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DNTHAL_TEXTURECREATEDATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_TEXTURECREATEDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_TEXTUREDESTROYDATA {
    pub dwhContext: usize,
    pub dwHandle: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_TEXTUREDESTROYDATA {}
impl ::std::default::Default for D3DNTHAL_TEXTUREDESTROYDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_TEXTUREDESTROYDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_TEXTUREDESTROYDATA").field("dwhContext", &self.dwhContext).field("dwHandle", &self.dwHandle).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_TEXTUREDESTROYDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.dwHandle == other.dwHandle && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_TEXTUREDESTROYDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_TEXTUREDESTROYDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct D3DNTHAL_TEXTUREGETSURFDATA {
    pub dwhContext: usize,
    pub hDDS: super::super::Foundation::HANDLE,
    pub dwHandle: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3DNTHAL_TEXTUREGETSURFDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3DNTHAL_TEXTUREGETSURFDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3DNTHAL_TEXTUREGETSURFDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_TEXTUREGETSURFDATA").field("dwhContext", &self.dwhContext).field("hDDS", &self.hDDS).field("dwHandle", &self.dwHandle).field("ddrval", &self.ddrval).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3DNTHAL_TEXTUREGETSURFDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.hDDS == other.hDDS && self.dwHandle == other.dwHandle && self.ddrval == other.ddrval
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3DNTHAL_TEXTUREGETSURFDATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3DNTHAL_TEXTUREGETSURFDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_TEXTURESWAPDATA {
    pub dwhContext: usize,
    pub dwHandle1: usize,
    pub dwHandle2: usize,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_TEXTURESWAPDATA {}
impl ::std::default::Default for D3DNTHAL_TEXTURESWAPDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_TEXTURESWAPDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_TEXTURESWAPDATA").field("dwhContext", &self.dwhContext).field("dwHandle1", &self.dwHandle1).field("dwHandle2", &self.dwHandle2).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_TEXTURESWAPDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.dwHandle1 == other.dwHandle1 && self.dwHandle2 == other.dwHandle2 && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_TEXTURESWAPDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_TEXTURESWAPDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_TSS_MAXSTAGES: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_TSS_RENDERSTATEBASE: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DNTHAL_TSS_STATESPERSTAGE: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {
    pub dwhContext: usize,
    pub dwFlags: u32,
    pub dwReserved: usize,
    pub dwNumPasses: u32,
    pub ddrval: ::windows::runtime::HRESULT,
}
impl D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {}
impl ::std::default::Default for D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA").field("dwhContext", &self.dwhContext).field("dwFlags", &self.dwFlags).field("dwReserved", &self.dwReserved).field("dwNumPasses", &self.dwNumPasses).field("ddrval", &self.ddrval).finish()
    }
}
impl ::std::cmp::PartialEq for D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwhContext == other.dwhContext && self.dwFlags == other.dwFlags && self.dwReserved == other.dwReserved && self.dwNumPasses == other.dwNumPasses && self.ddrval == other.ddrval
    }
}
impl ::std::cmp::Eq for D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {}
unsafe impl ::windows::runtime::Abi for D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DOPCODE(pub i32);
pub const D3DOP_POINT: D3DOPCODE = D3DOPCODE(1i32);
pub const D3DOP_LINE: D3DOPCODE = D3DOPCODE(2i32);
pub const D3DOP_TRIANGLE: D3DOPCODE = D3DOPCODE(3i32);
pub const D3DOP_MATRIXLOAD: D3DOPCODE = D3DOPCODE(4i32);
pub const D3DOP_MATRIXMULTIPLY: D3DOPCODE = D3DOPCODE(5i32);
pub const D3DOP_STATETRANSFORM: D3DOPCODE = D3DOPCODE(6i32);
pub const D3DOP_STATELIGHT: D3DOPCODE = D3DOPCODE(7i32);
pub const D3DOP_STATERENDER: D3DOPCODE = D3DOPCODE(8i32);
pub const D3DOP_PROCESSVERTICES: D3DOPCODE = D3DOPCODE(9i32);
pub const D3DOP_TEXTURELOAD: D3DOPCODE = D3DOPCODE(10i32);
pub const D3DOP_EXIT: D3DOPCODE = D3DOPCODE(11i32);
pub const D3DOP_BRANCHFORWARD: D3DOPCODE = D3DOPCODE(12i32);
pub const D3DOP_SPAN: D3DOPCODE = D3DOPCODE(13i32);
pub const D3DOP_SETSTATUS: D3DOPCODE = D3DOPCODE(14i32);
pub const D3DOP_FORCE_DWORD: D3DOPCODE = D3DOPCODE(2147483647i32);
impl ::std::convert::From<i32> for D3DOPCODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DOPCODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPAL_FREE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPAL_READONLY: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPAL_RESERVED: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_BOTHINVSRCALPHA: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_BOTHSRCALPHA: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_DESTALPHA: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_DESTCOLOR: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_INVDESTALPHA: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_INVDESTCOLOR: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_INVSRCALPHA: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_INVSRCCOLOR: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_ONE: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_SRCALPHA: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_SRCALPHASAT: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_SRCCOLOR: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPBLENDCAPS_ZERO: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_ALWAYS: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_EQUAL: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_GREATER: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_GREATEREQUAL: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_LESS: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_LESSEQUAL: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_NEVER: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPCMPCAPS_NOTEQUAL: i32 = 32i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DPICKRECORD {
    pub bOpcode: u8,
    pub bPad: u8,
    pub dwOffset: u32,
    pub dvZ: f32,
}
impl D3DPICKRECORD {}
impl ::std::default::Default for D3DPICKRECORD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DPICKRECORD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DPICKRECORD").field("bOpcode", &self.bOpcode).field("bPad", &self.bPad).field("dwOffset", &self.dwOffset).field("dvZ", &self.dvZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3DPICKRECORD {
    fn eq(&self, other: &Self) -> bool {
        self.bOpcode == other.bOpcode && self.bPad == other.bPad && self.dwOffset == other.dwOffset && self.dvZ == other.dvZ
    }
}
impl ::std::cmp::Eq for D3DPICKRECORD {}
unsafe impl ::windows::runtime::Abi for D3DPICKRECORD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_CONFORMANT: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_CULLCCW: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_CULLCW: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_CULLNONE: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_LINEPATTERNREP: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_MASKPLANES: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPMISCCAPS_MASKZ: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DPOINT {
    pub wCount: u16,
    pub wFirst: u16,
}
impl D3DPOINT {}
impl ::std::default::Default for D3DPOINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DPOINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DPOINT").field("wCount", &self.wCount).field("wFirst", &self.wFirst).finish()
    }
}
impl ::std::cmp::PartialEq for D3DPOINT {
    fn eq(&self, other: &Self) -> bool {
        self.wCount == other.wCount && self.wFirst == other.wFirst
    }
}
impl ::std::cmp::Eq for D3DPOINT {}
unsafe impl ::windows::runtime::Abi for D3DPOINT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ANISOTROPY: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ANTIALIASEDGES: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ANTIALIASSORTDEPENDENT: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ANTIALIASSORTINDEPENDENT: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_DITHER: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_FOGRANGE: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_FOGTABLE: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_FOGVERTEX: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_MIPMAPLODBIAS: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_PAT: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ROP2: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_STIPPLE: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_STRETCHBLTMULTISAMPLE: i32 = 8388608i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_SUBPIXEL: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_SUBPIXELX: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_TRANSLUCENTSORTINDEPENDENT: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_WBUFFER: i32 = 262144i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_WFOG: i32 = 1048576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_XOR: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ZBIAS: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ZBUFFERLESSHSR: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ZFOG: i32 = 2097152i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPRASTERCAPS_ZTEST: i32 = 16i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DPROCESSVERTICES {
    pub dwFlags: u32,
    pub wStart: u16,
    pub wDest: u16,
    pub dwCount: u32,
    pub dwReserved: u32,
}
impl D3DPROCESSVERTICES {}
impl ::std::default::Default for D3DPROCESSVERTICES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DPROCESSVERTICES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DPROCESSVERTICES").field("dwFlags", &self.dwFlags).field("wStart", &self.wStart).field("wDest", &self.wDest).field("dwCount", &self.dwCount).field("dwReserved", &self.dwReserved).finish()
    }
}
impl ::std::cmp::PartialEq for D3DPROCESSVERTICES {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.wStart == other.wStart && self.wDest == other.wDest && self.dwCount == other.dwCount && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for D3DPROCESSVERTICES {}
unsafe impl ::windows::runtime::Abi for D3DPROCESSVERTICES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_COPY: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_NOCOLOR: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_OPMASK: i32 = 7i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_TRANSFORM: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_TRANSFORMLIGHT: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPROCESSVERTICES_UPDATEEXTENTS: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAFLATBLEND: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAFLATSTIPPLED: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAGOURAUDBLEND: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAGOURAUDSTIPPLED: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAPHONGBLEND: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_ALPHAPHONGSTIPPLED: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORFLATMONO: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORFLATRGB: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORGOURAUDMONO: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORGOURAUDRGB: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORPHONGMONO: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_COLORPHONGRGB: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_FOGFLAT: i32 = 262144i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_FOGGOURAUD: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_FOGPHONG: i32 = 1048576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARFLATMONO: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARFLATRGB: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARGOURAUDMONO: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARGOURAUDRGB: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARPHONGMONO: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPSHADECAPS_SPECULARPHONGRGB: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTADDRESSCAPS_BORDER: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTADDRESSCAPS_CLAMP: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTADDRESSCAPS_INDEPENDENTUV: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTADDRESSCAPS_MIRROR: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTADDRESSCAPS_WRAP: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_ADD: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_COPY: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_DECAL: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_DECALALPHA: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_DECALMASK: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_MODULATE: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_MODULATEALPHA: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTBLENDCAPS_MODULATEMASK: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_ALPHA: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_ALPHAPALETTE: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_BORDER: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_COLORKEYBLEND: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_CUBEMAP: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_NONPOW2CONDITIONAL: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_PERSPECTIVE: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_POW2: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_PROJECTED: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_SQUAREONLY: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTEXTURECAPS_TRANSPARENCY: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_LINEAR: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_LINEARMIPLINEAR: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_LINEARMIPNEAREST: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MAGFAFLATCUBIC: i32 = 134217728i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MAGFANISOTROPIC: i32 = 67108864i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC: i32 = 268435456i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MAGFLINEAR: i32 = 33554432i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MAGFPOINT: i32 = 16777216i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MINFANISOTROPIC: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MINFLINEAR: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MINFPOINT: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MIPFLINEAR: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MIPFPOINT: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MIPLINEAR: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_MIPNEAREST: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPTFILTERCAPS_NEAREST: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DPV_DONOTCOPYDATA: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DRENDERSTATE_EVICTMANAGEDTEXTURES: u32 = 61u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DRENDERSTATE_SCENECAPTURE: u32 = 62u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DRENDERSTATE_WRAPBIAS: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DRS_MAXPIXELSHADERINST: u32 = 197u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DRS_MAXVERTEXSHADERINST: u32 = 196u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSETSTATUS_EXTENTS: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSETSTATUS_STATUS: i32 = 1i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DSPAN {
    pub wCount: u16,
    pub wFirst: u16,
}
impl D3DSPAN {}
impl ::std::default::Default for D3DSPAN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DSPAN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DSPAN").field("wCount", &self.wCount).field("wFirst", &self.wFirst).finish()
    }
}
impl ::std::cmp::PartialEq for D3DSPAN {
    fn eq(&self, other: &Self) -> bool {
        self.wCount == other.wCount && self.wFirst == other.wFirst
    }
}
impl ::std::cmp::Eq for D3DSPAN {}
unsafe impl ::windows::runtime::Abi for D3DSPAN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DSTATE {
    pub Anonymous1: D3DSTATE_0,
    pub Anonymous2: D3DSTATE_1,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DSTATE {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DSTATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DSTATE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DSTATE {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DSTATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DSTATE_0 {
    pub dtstTransformStateType: super::super::Graphics::Direct3D9::D3DTRANSFORMSTATETYPE,
    pub dlstLightStateType: D3DLIGHTSTATETYPE,
    pub drstRenderStateType: super::super::Graphics::Direct3D9::D3DRENDERSTATETYPE,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DSTATE_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DSTATE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DSTATE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DSTATE_0 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DSTATE_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub union D3DSTATE_1 {
    pub dwArg: [u32; 1],
    pub dvArg: [f32; 1],
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DSTATE_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DSTATE_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DSTATE_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DSTATE_1 {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DSTATE_1 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATE_OVERRIDE_BIAS: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DSTATS {
    pub dwSize: u32,
    pub dwTrianglesDrawn: u32,
    pub dwLinesDrawn: u32,
    pub dwPointsDrawn: u32,
    pub dwSpansDrawn: u32,
    pub dwVerticesProcessed: u32,
}
impl D3DSTATS {}
impl ::std::default::Default for D3DSTATS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DSTATS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DSTATS")
            .field("dwSize", &self.dwSize)
            .field("dwTrianglesDrawn", &self.dwTrianglesDrawn)
            .field("dwLinesDrawn", &self.dwLinesDrawn)
            .field("dwPointsDrawn", &self.dwPointsDrawn)
            .field("dwSpansDrawn", &self.dwSpansDrawn)
            .field("dwVerticesProcessed", &self.dwVerticesProcessed)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DSTATS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwTrianglesDrawn == other.dwTrianglesDrawn && self.dwLinesDrawn == other.dwLinesDrawn && self.dwPointsDrawn == other.dwPointsDrawn && self.dwSpansDrawn == other.dwSpansDrawn && self.dwVerticesProcessed == other.dwVerticesProcessed
    }
}
impl ::std::cmp::Eq for D3DSTATS {}
unsafe impl ::windows::runtime::Abi for D3DSTATS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DSTATUS {
    pub dwFlags: u32,
    pub dwStatus: u32,
    pub drExtent: super::super::Graphics::Direct3D9::D3DRECT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DSTATUS {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DSTATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DSTATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DSTATUS").field("dwFlags", &self.dwFlags).field("dwStatus", &self.dwStatus).field("drExtent", &self.drExtent).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DSTATUS {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwStatus == other.dwStatus && self.drExtent == other.drExtent
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DSTATUS {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DSTATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONBACK: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONBOTTOM: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONFRONT: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN0: i32 = 262144i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN1: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN2: i32 = 1048576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN3: i32 = 2097152i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN4: i32 = 4194304i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONGEN5: i32 = 8388608i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONLEFT: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONRIGHT: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPINTERSECTIONTOP: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONBACK: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONBOTTOM: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONFRONT: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN0: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN1: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN2: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN3: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN4: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONGEN5: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONLEFT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONRIGHT: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_CLIPUNIONTOP: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTATUS_ZNOTVISIBLE: i32 = 16777216i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_DECR: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_DECRSAT: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_INCR: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_INCRSAT: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_INVERT: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_KEEP: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_REPLACE: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DSTENCILCAPS_ZERO: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_ALPHAREPLICATE: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_COMPLEMENT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_CURRENT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_DIFFUSE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_SELECTMASK: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_SPECULAR: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_TEXTURE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTA_TFACTOR: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_ADD: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_ADDSIGNED: i32 = 128i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_ADDSIGNED2X: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_ADDSMOOTH: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BLENDCURRENTALPHA: i32 = 32768i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BLENDDIFFUSEALPHA: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BLENDFACTORALPHA: i32 = 8192i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BLENDTEXTUREALPHA: i32 = 4096i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BLENDTEXTUREALPHAPM: i32 = 16384i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BUMPENVMAP: i32 = 2097152i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_BUMPENVMAPLUMINANCE: i32 = 4194304i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_DISABLE: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_DOTPRODUCT3: i32 = 8388608i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATE: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATE2X: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATE4X: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR: i32 = 131072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA: i32 = 262144i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR: i32 = 524288i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA: i32 = 1048576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_PREMODULATE: i32 = 65536i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_SELECTARG1: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_SELECTARG2: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTEXOPCAPS_SUBTRACT: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DTEXTUREBLEND(pub i32);
pub const D3DTBLEND_DECAL: D3DTEXTUREBLEND = D3DTEXTUREBLEND(1i32);
pub const D3DTBLEND_MODULATE: D3DTEXTUREBLEND = D3DTEXTUREBLEND(2i32);
pub const D3DTBLEND_DECALALPHA: D3DTEXTUREBLEND = D3DTEXTUREBLEND(3i32);
pub const D3DTBLEND_MODULATEALPHA: D3DTEXTUREBLEND = D3DTEXTUREBLEND(4i32);
pub const D3DTBLEND_DECALMASK: D3DTEXTUREBLEND = D3DTEXTUREBLEND(5i32);
pub const D3DTBLEND_MODULATEMASK: D3DTEXTUREBLEND = D3DTEXTUREBLEND(6i32);
pub const D3DTBLEND_COPY: D3DTEXTUREBLEND = D3DTEXTUREBLEND(7i32);
pub const D3DTBLEND_ADD: D3DTEXTUREBLEND = D3DTEXTUREBLEND(8i32);
pub const D3DTBLEND_FORCE_DWORD: D3DTEXTUREBLEND = D3DTEXTUREBLEND(2147483647i32);
impl ::std::convert::From<i32> for D3DTEXTUREBLEND {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DTEXTUREBLEND {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DTEXTUREFILTER(pub i32);
pub const D3DFILTER_NEAREST: D3DTEXTUREFILTER = D3DTEXTUREFILTER(1i32);
pub const D3DFILTER_LINEAR: D3DTEXTUREFILTER = D3DTEXTUREFILTER(2i32);
pub const D3DFILTER_MIPNEAREST: D3DTEXTUREFILTER = D3DTEXTUREFILTER(3i32);
pub const D3DFILTER_MIPLINEAR: D3DTEXTUREFILTER = D3DTEXTUREFILTER(4i32);
pub const D3DFILTER_LINEARMIPNEAREST: D3DTEXTUREFILTER = D3DTEXTUREFILTER(5i32);
pub const D3DFILTER_LINEARMIPLINEAR: D3DTEXTUREFILTER = D3DTEXTUREFILTER(6i32);
pub const D3DFILTER_FORCE_DWORD: D3DTEXTUREFILTER = D3DTEXTUREFILTER(2147483647i32);
impl ::std::convert::From<i32> for D3DTEXTUREFILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DTEXTUREFILTER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DTEXTURELOAD {
    pub hDestTexture: u32,
    pub hSrcTexture: u32,
}
impl D3DTEXTURELOAD {}
impl ::std::default::Default for D3DTEXTURELOAD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DTEXTURELOAD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DTEXTURELOAD").field("hDestTexture", &self.hDestTexture).field("hSrcTexture", &self.hSrcTexture).finish()
    }
}
impl ::std::cmp::PartialEq for D3DTEXTURELOAD {
    fn eq(&self, other: &Self) -> bool {
        self.hDestTexture == other.hDestTexture && self.hSrcTexture == other.hSrcTexture
    }
}
impl ::std::cmp::Eq for D3DTEXTURELOAD {}
unsafe impl ::windows::runtime::Abi for D3DTEXTURELOAD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DTEXTUREMAGFILTER(pub i32);
pub const D3DTFG_POINT: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(1i32);
pub const D3DTFG_LINEAR: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(2i32);
pub const D3DTFG_FLATCUBIC: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(3i32);
pub const D3DTFG_GAUSSIANCUBIC: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(4i32);
pub const D3DTFG_ANISOTROPIC: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(5i32);
pub const D3DTFG_FORCE_DWORD: D3DTEXTUREMAGFILTER = D3DTEXTUREMAGFILTER(2147483647i32);
impl ::std::convert::From<i32> for D3DTEXTUREMAGFILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DTEXTUREMAGFILTER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DTEXTUREMINFILTER(pub i32);
pub const D3DTFN_POINT: D3DTEXTUREMINFILTER = D3DTEXTUREMINFILTER(1i32);
pub const D3DTFN_LINEAR: D3DTEXTUREMINFILTER = D3DTEXTUREMINFILTER(2i32);
pub const D3DTFN_ANISOTROPIC: D3DTEXTUREMINFILTER = D3DTEXTUREMINFILTER(3i32);
pub const D3DTFN_FORCE_DWORD: D3DTEXTUREMINFILTER = D3DTEXTUREMINFILTER(2147483647i32);
impl ::std::convert::From<i32> for D3DTEXTUREMINFILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DTEXTUREMINFILTER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DTEXTUREMIPFILTER(pub i32);
pub const D3DTFP_NONE: D3DTEXTUREMIPFILTER = D3DTEXTUREMIPFILTER(1i32);
pub const D3DTFP_POINT: D3DTEXTUREMIPFILTER = D3DTEXTUREMIPFILTER(2i32);
pub const D3DTFP_LINEAR: D3DTEXTUREMIPFILTER = D3DTEXTUREMIPFILTER(3i32);
pub const D3DTFP_FORCE_DWORD: D3DTEXTUREMIPFILTER = D3DTEXTUREMIPFILTER(2147483647i32);
impl ::std::convert::From<i32> for D3DTEXTUREMIPFILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DTEXTUREMIPFILTER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DTLVERTEX {
    pub Anonymous1: D3DTLVERTEX_0,
    pub Anonymous2: D3DTLVERTEX_1,
    pub Anonymous3: D3DTLVERTEX_2,
    pub Anonymous4: D3DTLVERTEX_3,
    pub Anonymous5: D3DTLVERTEX_4,
    pub Anonymous6: D3DTLVERTEX_5,
    pub Anonymous7: D3DTLVERTEX_6,
    pub Anonymous8: D3DTLVERTEX_7,
}
impl D3DTLVERTEX {}
impl ::std::default::Default for D3DTLVERTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_0 {
    pub sx: f32,
    pub dvSX: f32,
}
impl D3DTLVERTEX_0 {}
impl ::std::default::Default for D3DTLVERTEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_0 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_1 {
    pub sy: f32,
    pub dvSY: f32,
}
impl D3DTLVERTEX_1 {}
impl ::std::default::Default for D3DTLVERTEX_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_1 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_2 {
    pub sz: f32,
    pub dvSZ: f32,
}
impl D3DTLVERTEX_2 {}
impl ::std::default::Default for D3DTLVERTEX_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_2 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_3 {
    pub rhw: f32,
    pub dvRHW: f32,
}
impl D3DTLVERTEX_3 {}
impl ::std::default::Default for D3DTLVERTEX_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_3 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_4 {
    pub color: u32,
    pub dcColor: u32,
}
impl D3DTLVERTEX_4 {}
impl ::std::default::Default for D3DTLVERTEX_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_4 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_5 {
    pub specular: u32,
    pub dcSpecular: u32,
}
impl D3DTLVERTEX_5 {}
impl ::std::default::Default for D3DTLVERTEX_5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_5 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_5 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_5 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_6 {
    pub tu: f32,
    pub dvTU: f32,
}
impl D3DTLVERTEX_6 {}
impl ::std::default::Default for D3DTLVERTEX_6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_6 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_6 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_6 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTLVERTEX_7 {
    pub tv: f32,
    pub dvTV: f32,
}
impl D3DTLVERTEX_7 {}
impl ::std::default::Default for D3DTLVERTEX_7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTLVERTEX_7 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTLVERTEX_7 {}
unsafe impl ::windows::runtime::Abi for D3DTLVERTEX_7 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DTRANSFORMCAPS {
    pub dwSize: u32,
    pub dwCaps: u32,
}
impl D3DTRANSFORMCAPS {}
impl ::std::default::Default for D3DTRANSFORMCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DTRANSFORMCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DTRANSFORMCAPS").field("dwSize", &self.dwSize).field("dwCaps", &self.dwCaps).finish()
    }
}
impl ::std::cmp::PartialEq for D3DTRANSFORMCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwCaps == other.dwCaps
    }
}
impl ::std::cmp::Eq for D3DTRANSFORMCAPS {}
unsafe impl ::windows::runtime::Abi for D3DTRANSFORMCAPS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRANSFORMCAPS_CLIP: i32 = 1i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
pub struct D3DTRANSFORMDATA {
    pub dwSize: u32,
    pub lpIn: *mut ::std::ffi::c_void,
    pub dwInSize: u32,
    pub lpOut: *mut ::std::ffi::c_void,
    pub dwOutSize: u32,
    pub lpHOut: *mut D3DHVERTEX,
    pub dwClip: u32,
    pub dwClipIntersection: u32,
    pub dwClipUnion: u32,
    pub drExtent: super::super::Graphics::Direct3D9::D3DRECT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl D3DTRANSFORMDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::default::Default for D3DTRANSFORMDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::fmt::Debug for D3DTRANSFORMDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DTRANSFORMDATA")
            .field("dwSize", &self.dwSize)
            .field("lpIn", &self.lpIn)
            .field("dwInSize", &self.dwInSize)
            .field("lpOut", &self.lpOut)
            .field("dwOutSize", &self.dwOutSize)
            .field("lpHOut", &self.lpHOut)
            .field("dwClip", &self.dwClip)
            .field("dwClipIntersection", &self.dwClipIntersection)
            .field("dwClipUnion", &self.dwClipUnion)
            .field("drExtent", &self.drExtent)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::PartialEq for D3DTRANSFORMDATA {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.lpIn == other.lpIn && self.dwInSize == other.dwInSize && self.lpOut == other.lpOut && self.dwOutSize == other.dwOutSize && self.lpHOut == other.lpHOut && self.dwClip == other.dwClip && self.dwClipIntersection == other.dwClipIntersection && self.dwClipUnion == other.dwClipUnion && self.drExtent == other.drExtent
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl ::std::cmp::Eq for D3DTRANSFORMDATA {}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
unsafe impl ::windows::runtime::Abi for D3DTRANSFORMDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRANSFORM_CLIPPED: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRANSFORM_UNCLIPPED: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DTRIANGLE {
    pub Anonymous1: D3DTRIANGLE_0,
    pub Anonymous2: D3DTRIANGLE_1,
    pub Anonymous3: D3DTRIANGLE_2,
    pub wFlags: u16,
}
impl D3DTRIANGLE {}
impl ::std::default::Default for D3DTRIANGLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTRIANGLE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTRIANGLE {}
unsafe impl ::windows::runtime::Abi for D3DTRIANGLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTRIANGLE_0 {
    pub v1: u16,
    pub wV1: u16,
}
impl D3DTRIANGLE_0 {}
impl ::std::default::Default for D3DTRIANGLE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTRIANGLE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTRIANGLE_0 {}
unsafe impl ::windows::runtime::Abi for D3DTRIANGLE_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTRIANGLE_1 {
    pub v2: u16,
    pub wV2: u16,
}
impl D3DTRIANGLE_1 {}
impl ::std::default::Default for D3DTRIANGLE_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTRIANGLE_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTRIANGLE_1 {}
unsafe impl ::windows::runtime::Abi for D3DTRIANGLE_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DTRIANGLE_2 {
    pub v3: u16,
    pub wV3: u16,
}
impl D3DTRIANGLE_2 {}
impl ::std::default::Default for D3DTRIANGLE_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DTRIANGLE_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DTRIANGLE_2 {}
unsafe impl ::windows::runtime::Abi for D3DTRIANGLE_2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_EDGEENABLE1: i32 = 256i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_EDGEENABLE2: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_EDGEENABLE3: i32 = 1024i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_EVEN: i32 = 31i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_ODD: i32 = 30i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTRIFLAG_START: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTSS_TCI_CAMERASPACENORMAL: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTSS_TCI_CAMERASPACEPOSITION: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR: u32 = 196608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTSS_TCI_PASSTHRU: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DTSS_TEXTUREMAP: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVBCAPS_DONOTCLIP: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVBCAPS_OPTIMIZED: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVBCAPS_SYSTEMMEMORY: i32 = 2048i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVBCAPS_WRITEONLY: i32 = 65536i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DVERTEX {
    pub Anonymous1: D3DVERTEX_0,
    pub Anonymous2: D3DVERTEX_1,
    pub Anonymous3: D3DVERTEX_2,
    pub Anonymous4: D3DVERTEX_3,
    pub Anonymous5: D3DVERTEX_4,
    pub Anonymous6: D3DVERTEX_5,
    pub Anonymous7: D3DVERTEX_6,
    pub Anonymous8: D3DVERTEX_7,
}
impl D3DVERTEX {}
impl ::std::default::Default for D3DVERTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_0 {
    pub x: f32,
    pub dvX: f32,
}
impl D3DVERTEX_0 {}
impl ::std::default::Default for D3DVERTEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_0 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_1 {
    pub y: f32,
    pub dvY: f32,
}
impl D3DVERTEX_1 {}
impl ::std::default::Default for D3DVERTEX_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_1 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_2 {
    pub z: f32,
    pub dvZ: f32,
}
impl D3DVERTEX_2 {}
impl ::std::default::Default for D3DVERTEX_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_2 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_3 {
    pub nx: f32,
    pub dvNX: f32,
}
impl D3DVERTEX_3 {}
impl ::std::default::Default for D3DVERTEX_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_3 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_4 {
    pub ny: f32,
    pub dvNY: f32,
}
impl D3DVERTEX_4 {}
impl ::std::default::Default for D3DVERTEX_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_4 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_5 {
    pub nz: f32,
    pub dvNZ: f32,
}
impl D3DVERTEX_5 {}
impl ::std::default::Default for D3DVERTEX_5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_5 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_5 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_5 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_6 {
    pub tu: f32,
    pub dvTU: f32,
}
impl D3DVERTEX_6 {}
impl ::std::default::Default for D3DVERTEX_6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_6 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_6 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_6 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union D3DVERTEX_7 {
    pub tv: f32,
    pub dvTV: f32,
}
impl D3DVERTEX_7 {}
impl ::std::default::Default for D3DVERTEX_7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3DVERTEX_7 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3DVERTEX_7 {}
unsafe impl ::windows::runtime::Abi for D3DVERTEX_7 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DVERTEXBUFFERDESC {
    pub dwSize: u32,
    pub dwCaps: u32,
    pub dwFVF: u32,
    pub dwNumVertices: u32,
}
impl D3DVERTEXBUFFERDESC {}
impl ::std::default::Default for D3DVERTEXBUFFERDESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DVERTEXBUFFERDESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DVERTEXBUFFERDESC").field("dwSize", &self.dwSize).field("dwCaps", &self.dwCaps).field("dwFVF", &self.dwFVF).field("dwNumVertices", &self.dwNumVertices).finish()
    }
}
impl ::std::cmp::PartialEq for D3DVERTEXBUFFERDESC {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwCaps == other.dwCaps && self.dwFVF == other.dwFVF && self.dwNumVertices == other.dwNumVertices
    }
}
impl ::std::cmp::Eq for D3DVERTEXBUFFERDESC {}
unsafe impl ::windows::runtime::Abi for D3DVERTEXBUFFERDESC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3DVERTEXTYPE(pub i32);
pub const D3DVT_VERTEX: D3DVERTEXTYPE = D3DVERTEXTYPE(1i32);
pub const D3DVT_LVERTEX: D3DVERTEXTYPE = D3DVERTEXTYPE(2i32);
pub const D3DVT_TLVERTEX: D3DVERTEXTYPE = D3DVERTEXTYPE(3i32);
pub const D3DVT_FORCE_DWORD: D3DVERTEXTYPE = D3DVERTEXTYPE(2147483647i32);
impl ::std::convert::From<i32> for D3DVERTEXTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DVERTEXTYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DVIEWPORT {
    pub dwSize: u32,
    pub dwX: u32,
    pub dwY: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dvScaleX: f32,
    pub dvScaleY: f32,
    pub dvMaxX: f32,
    pub dvMaxY: f32,
    pub dvMinZ: f32,
    pub dvMaxZ: f32,
}
impl D3DVIEWPORT {}
impl ::std::default::Default for D3DVIEWPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DVIEWPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DVIEWPORT")
            .field("dwSize", &self.dwSize)
            .field("dwX", &self.dwX)
            .field("dwY", &self.dwY)
            .field("dwWidth", &self.dwWidth)
            .field("dwHeight", &self.dwHeight)
            .field("dvScaleX", &self.dvScaleX)
            .field("dvScaleY", &self.dvScaleY)
            .field("dvMaxX", &self.dvMaxX)
            .field("dvMaxY", &self.dvMaxY)
            .field("dvMinZ", &self.dvMinZ)
            .field("dvMaxZ", &self.dvMaxZ)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DVIEWPORT {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwX == other.dwX && self.dwY == other.dwY && self.dwWidth == other.dwWidth && self.dwHeight == other.dwHeight && self.dvScaleX == other.dvScaleX && self.dvScaleY == other.dvScaleY && self.dvMaxX == other.dvMaxX && self.dvMaxY == other.dvMaxY && self.dvMinZ == other.dvMinZ && self.dvMaxZ == other.dvMaxZ
    }
}
impl ::std::cmp::Eq for D3DVIEWPORT {}
unsafe impl ::windows::runtime::Abi for D3DVIEWPORT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DVIEWPORT2 {
    pub dwSize: u32,
    pub dwX: u32,
    pub dwY: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dvClipX: f32,
    pub dvClipY: f32,
    pub dvClipWidth: f32,
    pub dvClipHeight: f32,
    pub dvMinZ: f32,
    pub dvMaxZ: f32,
}
impl D3DVIEWPORT2 {}
impl ::std::default::Default for D3DVIEWPORT2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DVIEWPORT2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DVIEWPORT2")
            .field("dwSize", &self.dwSize)
            .field("dwX", &self.dwX)
            .field("dwY", &self.dwY)
            .field("dwWidth", &self.dwWidth)
            .field("dwHeight", &self.dwHeight)
            .field("dvClipX", &self.dvClipX)
            .field("dvClipY", &self.dvClipY)
            .field("dvClipWidth", &self.dvClipWidth)
            .field("dvClipHeight", &self.dvClipHeight)
            .field("dvMinZ", &self.dvMinZ)
            .field("dvMaxZ", &self.dvMaxZ)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DVIEWPORT2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwX == other.dwX && self.dwY == other.dwY && self.dwWidth == other.dwWidth && self.dwHeight == other.dwHeight && self.dvClipX == other.dvClipX && self.dvClipY == other.dvClipY && self.dvClipWidth == other.dvClipWidth && self.dvClipHeight == other.dvClipHeight && self.dvMinZ == other.dvMinZ && self.dvMaxZ == other.dvMaxZ
    }
}
impl ::std::cmp::Eq for D3DVIEWPORT2 {}
unsafe impl ::windows::runtime::Abi for D3DVIEWPORT2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct D3DVIEWPORT7 {
    pub dwX: u32,
    pub dwY: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dvMinZ: f32,
    pub dvMaxZ: f32,
}
impl D3DVIEWPORT7 {}
impl ::std::default::Default for D3DVIEWPORT7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DVIEWPORT7 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DVIEWPORT7").field("dwX", &self.dwX).field("dwY", &self.dwY).field("dwWidth", &self.dwWidth).field("dwHeight", &self.dwHeight).field("dvMinZ", &self.dvMinZ).field("dvMaxZ", &self.dvMaxZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3DVIEWPORT7 {
    fn eq(&self, other: &Self) -> bool {
        self.dwX == other.dwX && self.dwY == other.dwY && self.dwWidth == other.dwWidth && self.dwHeight == other.dwHeight && self.dvMinZ == other.dvMinZ && self.dvMaxZ == other.dvMaxZ
    }
}
impl ::std::cmp::Eq for D3DVIEWPORT7 {}
unsafe impl ::windows::runtime::Abi for D3DVIEWPORT7 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_BOTTOM: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_FAR: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_FRUSTUM: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_LEFT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_NEAR: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_RIGHT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INSIDE_TOP: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_BOTTOM: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_FAR: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_FRUSTUM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_LEFT: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_NEAR: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_RIGHT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_INTERSECT_TOP: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_BOTTOM: u32 = 768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_FAR: u32 = 12288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_FRUSTUM: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_LEFT: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_NEAR: u32 = 3072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_RIGHT: u32 = 48u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_MASK_TOP: u32 = 192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_BOTTOM: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_FAR: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_FRUSTUM: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_LEFT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_NEAR: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_RIGHT: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVIS_OUTSIDE_TOP: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVOP_CLIP: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVOP_EXTENTS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVOP_LIGHT: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVOP_TRANSFORM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_BLENDINDICES: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_BLENDWEIGHT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_DIFFUSE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_NORMAL: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_NORMAL2: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_POSITION: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_POSITION2: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_PSIZE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_SPECULAR: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD0: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD1: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD2: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD3: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD4: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD5: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD6: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDE_TEXCOORD7: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_D3DCOLOR: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_FLOAT1: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_FLOAT2: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_FLOAT3: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_FLOAT4: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_SHORT2: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_SHORT4: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSDT_UBYTE4: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_CONSTADDRESSSHIFT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_CONSTCOUNTSHIFT: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_CONSTRSSHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_DATALOADTYPESHIFT: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_DATATYPESHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_EXTCOUNTSHIFT: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_EXTINFOSHIFT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_SKIPCOUNTSHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_STREAMNUMBERSHIFT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_STREAMTESSSHIFT: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_TOKENTYPESHIFT: u32 = 29u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_VERTEXREGINSHIFT: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVSD_VERTEXREGSHIFT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_DIRECTIONALLIGHTS: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_LOCALVIEWER: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_MATERIALSOURCE7: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_POSITIONALLIGHTS: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_TEXGEN: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DVTXPCAPS_VERTEXFOG: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAPCOORD_0: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAPCOORD_1: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAPCOORD_2: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAPCOORD_3: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAP_U: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const D3DWRAP_V: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBTF_RESOURCE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBTF_SLOWNET: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBTF_XPORT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_APPYBEGIN: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_APPYEND: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_CONFIGCHANGECANCELED: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_CONFIGCHANGED: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_CONFIGMGAPI32: u32 = 34u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_CONFIGMGPRIVATE: u32 = 32767u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_CUSTOMEVENT: u32 = 32774u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICEARRIVAL: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICEQUERYREMOVE: u32 = 32769u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICEQUERYREMOVEFAILED: u32 = 32770u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICEREMOVECOMPLETE: u32 = 32772u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICEREMOVEPENDING: u32 = 32771u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVICETYPESPECIFIC: u32 = 32773u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVNODES_CHANGED: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVTYP_DEVNODE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_DEVTYP_NET: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_LOW_DISK_SPACE: u32 = 72u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_MONITORCHANGE: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_NO_DISK_SPACE: u32 = 71u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_QUERYCHANGECONFIG: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_SHELLLOGGEDON: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_USERDEFINED: u32 = 65535u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKLOCKFAILED: u32 = 32835u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKLOCKRELEASED: u32 = 32837u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKLOCKTAKEN: u32 = 32834u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKQUERYLOCK: u32 = 32833u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKQUERYUNLOCK: u32 = 32836u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VOLLOCKUNLOCKFAILED: u32 = 32838u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VPOWERDAPI: u32 = 33024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DBT_VXDINITCOMPLETE: u32 = 35u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DCR_DRIVER: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DCR_HALFTONE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DCR_SOLID: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DC_COMPLEX: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DC_RECT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DC_TRIVIAL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDBLT_EXTENDED_PRESENTATION_STRETCHFACTOR: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_DRIVER_VERSION_NT4: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_DRIVER_VERSION_NT5: u32 = 196608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_DRIVER_VERSION_NT5_01: u32 = 196864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_DRIVER_VERSION_NT5_01_SP1: u32 = 196865u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_DRIVER_VERSION_SP3: u32 = 131075u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DDI_ERROR: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEDICATED_MEMORY_CACHE_ELIGIBLE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DELETE: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVHTADJF_ADDITIVE_DEVICE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVHTADJF_COLOR_DEVICE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_ALLINONE: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_BANKING: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_BUILDING_AUTOMATION: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_CONVERTIBLE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_DESKTOP: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_DETACHABLE: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_DIGITAL_SIGNAGE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_GAMING: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_HMD: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_HOME_AUTOMATION: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_INDUSTRIAL_AUTOMATION: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_INDUSTRY_HANDHELD: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_INDUSTRY_OTHER: u32 = 29u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_INDUSTRY_TABLET: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_KIOSK: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_LARGESCREEN: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_MAKER_BOARD: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_MAX: u32 = 45u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_MEDICAL: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_NETWORKING: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_NOTEBOOK: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_PHONE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_POINT_OF_SERVICE: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_PRINTING: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_PUCK: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_STICKPC: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_TABLET: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_THIN_CLIENT: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_TOY: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_VENDING: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_ONE: u32 = 30u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_ONE_S: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_ONE_X: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_ONE_X_DEVKIT: u32 = 33u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_00: u32 = 36u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_01: u32 = 37u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_02: u32 = 38u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_03: u32 = 39u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_04: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_05: u32 = 41u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_06: u32 = 42u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_07: u32 = 43u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_08: u32 = 44u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_RESERVED_09: u32 = 45u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_SERIES_X: u32 = 34u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYDEVICEFORM_XBOX_SERIES_X_DEVKIT: u32 = 35u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_7067329: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_8828080: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_DESKTOP: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_HOLOGRAPHIC: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_IOT: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_IOT_HEADLESS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_MAX: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_MOBILE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_SERVER: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_SERVER_NANO: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_TEAM: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_UAP: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_WINDOWS_8X: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_WINDOWS_CORE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_WINDOWS_CORE_HEADLESS: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_WINDOWS_PHONE_8X: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_XBOX: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_XBOXERA: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVICEFAMILYINFOENUM_XBOXSRA: u32 = 11u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVICE_EVENT_BECOMING_READY {
    pub Version: u32,
    pub Reason: u32,
    pub Estimated100msToReady: u32,
}
impl DEVICE_EVENT_BECOMING_READY {}
impl ::std::default::Default for DEVICE_EVENT_BECOMING_READY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVICE_EVENT_BECOMING_READY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICE_EVENT_BECOMING_READY").field("Version", &self.Version).field("Reason", &self.Reason).field("Estimated100msToReady", &self.Estimated100msToReady).finish()
    }
}
impl ::std::cmp::PartialEq for DEVICE_EVENT_BECOMING_READY {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Reason == other.Reason && self.Estimated100msToReady == other.Estimated100msToReady
    }
}
impl ::std::cmp::Eq for DEVICE_EVENT_BECOMING_READY {}
unsafe impl ::windows::runtime::Abi for DEVICE_EVENT_BECOMING_READY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVICE_EVENT_EXTERNAL_REQUEST {
    pub Version: u32,
    pub DeviceClass: u32,
    pub ButtonStatus: u16,
    pub Request: u16,
    pub SystemTime: i64,
}
impl DEVICE_EVENT_EXTERNAL_REQUEST {}
impl ::std::default::Default for DEVICE_EVENT_EXTERNAL_REQUEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVICE_EVENT_EXTERNAL_REQUEST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICE_EVENT_EXTERNAL_REQUEST").field("Version", &self.Version).field("DeviceClass", &self.DeviceClass).field("ButtonStatus", &self.ButtonStatus).field("Request", &self.Request).field("SystemTime", &self.SystemTime).finish()
    }
}
impl ::std::cmp::PartialEq for DEVICE_EVENT_EXTERNAL_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.DeviceClass == other.DeviceClass && self.ButtonStatus == other.ButtonStatus && self.Request == other.Request && self.SystemTime == other.SystemTime
    }
}
impl ::std::cmp::Eq for DEVICE_EVENT_EXTERNAL_REQUEST {}
unsafe impl ::windows::runtime::Abi for DEVICE_EVENT_EXTERNAL_REQUEST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVICE_EVENT_GENERIC_DATA {
    pub EventNumber: u32,
}
impl DEVICE_EVENT_GENERIC_DATA {}
impl ::std::default::Default for DEVICE_EVENT_GENERIC_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVICE_EVENT_GENERIC_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICE_EVENT_GENERIC_DATA").field("EventNumber", &self.EventNumber).finish()
    }
}
impl ::std::cmp::PartialEq for DEVICE_EVENT_GENERIC_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.EventNumber == other.EventNumber
    }
}
impl ::std::cmp::Eq for DEVICE_EVENT_GENERIC_DATA {}
unsafe impl ::windows::runtime::Abi for DEVICE_EVENT_GENERIC_DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVICE_EVENT_MOUNT {
    pub Version: u32,
    pub Flags: u32,
    pub FileSystemNameLength: u32,
    pub FileSystemNameOffset: u32,
}
impl DEVICE_EVENT_MOUNT {}
impl ::std::default::Default for DEVICE_EVENT_MOUNT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVICE_EVENT_MOUNT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICE_EVENT_MOUNT").field("Version", &self.Version).field("Flags", &self.Flags).field("FileSystemNameLength", &self.FileSystemNameLength).field("FileSystemNameOffset", &self.FileSystemNameOffset).finish()
    }
}
impl ::std::cmp::PartialEq for DEVICE_EVENT_MOUNT {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Flags == other.Flags && self.FileSystemNameLength == other.FileSystemNameLength && self.FileSystemNameOffset == other.FileSystemNameOffset
    }
}
impl ::std::cmp::Eq for DEVICE_EVENT_MOUNT {}
unsafe impl ::windows::runtime::Abi for DEVICE_EVENT_MOUNT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVICE_EVENT_RBC_DATA {
    pub EventNumber: u32,
    pub SenseQualifier: u8,
    pub SenseCode: u8,
    pub SenseKey: u8,
    pub Reserved: u8,
    pub Information: u32,
}
impl DEVICE_EVENT_RBC_DATA {}
impl ::std::default::Default for DEVICE_EVENT_RBC_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVICE_EVENT_RBC_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICE_EVENT_RBC_DATA").field("EventNumber", &self.EventNumber).field("SenseQualifier", &self.SenseQualifier).field("SenseCode", &self.SenseCode).field("SenseKey", &self.SenseKey).field("Reserved", &self.Reserved).field("Information", &self.Information).finish()
    }
}
impl ::std::cmp::PartialEq for DEVICE_EVENT_RBC_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.EventNumber == other.EventNumber && self.SenseQualifier == other.SenseQualifier && self.SenseCode == other.SenseCode && self.SenseKey == other.SenseKey && self.Reserved == other.Reserved && self.Information == other.Information
    }
}
impl ::std::cmp::Eq for DEVICE_EVENT_RBC_DATA {}
unsafe impl ::windows::runtime::Abi for DEVICE_EVENT_RBC_DATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEVICE_POWER_STATE(pub i32);
pub const PowerDeviceUnspecified: DEVICE_POWER_STATE = DEVICE_POWER_STATE(0i32);
pub const PowerDeviceD0: DEVICE_POWER_STATE = DEVICE_POWER_STATE(1i32);
pub const PowerDeviceD1: DEVICE_POWER_STATE = DEVICE_POWER_STATE(2i32);
pub const PowerDeviceD2: DEVICE_POWER_STATE = DEVICE_POWER_STATE(3i32);
pub const PowerDeviceD3: DEVICE_POWER_STATE = DEVICE_POWER_STATE(4i32);
pub const PowerDeviceMaximum: DEVICE_POWER_STATE = DEVICE_POWER_STATE(5i32);
impl ::std::convert::From<i32> for DEVICE_POWER_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEVICE_POWER_STATE {
    type Abi = Self;
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DevQuery_ObjectType: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(325533506, 41942, 18934, [180, 218, 174, 70, 224, 197, 35, 124]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_Characteristics: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 29u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_ClassCoInstallers: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1899828995, 41698, 18933, [146, 20, 86, 71, 46, 243, 218, 92]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_ClassInstaller: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_ClassName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_DHPRebalanceOptOut: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3511500531, 26319, 19362, [157, 56, 13, 219, 55, 171, 71, 1]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_DefaultService: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 11u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_DevType: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 27u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_Exclusive: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 28u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_Icon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_IconPath: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 12u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_LowerFilters: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 20u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_Name: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_NoDisplayClass: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_NoInstallClass: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_NoUseClass: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 10u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_PropPageProvider: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_Security: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 25u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_SecuritySDS: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 26u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_SilentInstall: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(630898684, 20647, 18382, [175, 8, 104, 201, 167, 215, 51, 102]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceClass_UpperFilters: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1126273419, 63134, 18189, [165, 222, 77, 136, 199, 90, 210, 75]),
    pid: 19u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Address: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 51u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_AlwaysShowDeviceAsConnected: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 101u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_AssociationArray: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 80u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_BaselineExperienceId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 78u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Category: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 90u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_CategoryGroup_Desc: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 94u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_CategoryGroup_Icon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 95u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Category_Desc_Plural: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 92u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Category_Desc_Singular: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 91u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Category_Icon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 93u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_ConfigFlags: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 105u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_CustomPrivilegedPackageFamilyNames: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 107u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_DeviceDescription1: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 81u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_DeviceDescription2: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 82u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_DeviceFunctionSubRank: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 100u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_DiscoveryMethod: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 52u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_ExperienceId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 89u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_FriendlyName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1701460915, 60608, 17405, [132, 119, 74, 224, 64, 74, 150, 205]),
    pid: 12288u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_HasProblem: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 83u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Icon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 57u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_InstallInProgress: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsAuthenticated: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 54u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsConnected: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 55u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsDefaultDevice: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 86u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsDeviceUniquelyIdentifiable: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 79u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsEncrypted: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 53u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsLocalMachine: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 70u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsMetadataSearchInProgress: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 72u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsNetworkDevice: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 85u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsNotInterestingForDisplay: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 74u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsPaired: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 56u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsRebootRequired: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 108u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsSharedDevice: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 84u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_IsShowInDisconnectedState: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 68u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Last_Connected: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 67u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Last_Seen: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 66u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_LaunchDeviceStageFromExplorer: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 77u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_LaunchDeviceStageOnDeviceConnect: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 76u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Manufacturer: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1701460915, 60608, 17405, [132, 119, 74, 224, 64, 74, 150, 205]),
    pid: 8192u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_MetadataCabinet: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 87u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_MetadataChecksum: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 73u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_MetadataPath: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 71u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_ModelName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1701460915, 60608, 17405, [132, 119, 74, 224, 64, 74, 150, 205]),
    pid: 8194u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_ModelNumber: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1701460915, 60608, 17405, [132, 119, 74, 224, 64, 74, 150, 205]),
    pid: 8195u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_PrimaryCategory: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 97u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_PrivilegedPackageFamilyNames: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 106u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_RequiresPairingElevation: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 88u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_RequiresUninstallElevation: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 99u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_UnpairUninstall: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 98u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceContainer_Version: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 65u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterfaceClass_DefaultInterface: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(348666521, 2879, 17591, [190, 76, 161, 120, 211, 153, 5, 100]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterfaceClass_Name: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(348666521, 2879, 17591, [190, 76, 161, 120, 211, 153, 5, 100]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_Autoplay_Silent: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1129173647, 40565, 17674, [154, 185, 255, 97, 230, 24, 186, 208]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_ClassGuid: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_Enabled: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_FriendlyName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_ReferenceString: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_Restricted: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_SchematicName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DeviceInterface_UnrestrictedAppCapabilities: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(40784238, 47124, 16715, [131, 205, 133, 109, 111, 239, 72, 34]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_AdditionalSoftwareRequested: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 19u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Address: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 30u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_AssignedToGuest: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 24u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BaseContainerId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 38u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BiosDeviceName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 10u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BusNumber: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 23u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BusRelations: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BusReportedDeviceDesc: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_BusTypeGuid: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 21u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Capabilities: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 17u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Characteristics: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 29u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Children: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Class: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ClassGuid: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 10u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_CompatibleIds: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ConfigFlags: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 12u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ConfigurationId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ContainerId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2357121542, 16266, 18471, [179, 171, 174, 158, 31, 174, 252, 108]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_CreatorProcessId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 25u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DHP_Rebalance_Policy: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DebuggerSafe: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 12u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DependencyDependents: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 21u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DependencyProviders: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 20u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DevNodeStatus: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DevType: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 27u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DeviceDesc: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Driver: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 11u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverCoInstallers: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 11u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverDesc: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverInfPath: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverInfSection: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverInfSectionExt: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverLogoLevel: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 15u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverProblemDesc: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 11u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverPropPageProvider: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 10u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverProvider: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverRank: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 14u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_DriverVersion: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_EjectionRelations: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_EnumeratorName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 24u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Exclusive: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 28u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ExtendedAddress: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 23u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ExtendedConfigurationIds: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 15u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FirmwareDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 17u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FirmwareRevision: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 19u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FirmwareVersion: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 18u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FirstInstallDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 101u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FriendlyName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 14u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_FriendlyNameAttributes: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_GenericDriverInstalled: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 18u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_HardwareIds: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_HasProblem: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_InLocalMachineContainer: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2357121542, 16266, 18471, [179, 171, 174, 158, 31, 174, 252, 108]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_InstallDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 100u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_InstallState: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 36u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_InstanceId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 256u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_IsAssociateableByUserAction: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_IsPresent: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_IsRebootRequired: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 16u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LastArrivalDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 102u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LastRemovalDate: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 103u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Legacy: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2152296704, 35955, 18617, [170, 217, 206, 56, 126, 25, 197, 110]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LegacyBusType: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 22u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LocationInfo: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 15u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LocationPaths: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 37u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_LowerFilters: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 20u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Manufacturer: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 13u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ManufacturerAttributes: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_MatchingDeviceId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Model: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2026065864, 4170, 19146, [158, 164, 82, 77, 82, 153, 110, 87]),
    pid: 39u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ModelId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_NoConnectSound: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 17u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Numa_Node: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Numa_Proximity_Domain: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 1u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PDOName: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 16u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Parent: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PhysicalDeviceLocation: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 9u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PostInstallInProgress: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 13u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PowerData: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 32u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PowerRelations: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_PresenceNotForDevice: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ProblemCode: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ProblemStatus: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 12u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_RemovalPolicy: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 33u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_RemovalPolicyDefault: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 34u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_RemovalPolicyOverride: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 35u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_RemovalRelations: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Reported: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2152296704, 35955, 18617, [170, 217, 206, 56, 126, 25, 197, 110]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ReportedDeviceIdsHash: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ResourcePickerExceptions: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 13u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ResourcePickerTags: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2830656989, 11837, 16532, [173, 151, 229, 147, 167, 12, 117, 214]),
    pid: 12u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SafeRemovalRequired: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2950264384, 34467, 16912, [182, 124, 40, 156, 65, 170, 190, 85]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SafeRemovalRequiredOverride: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2950264384, 34467, 16912, [182, 124, 40, 156, 65, 170, 190, 85]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Security: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 25u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SecuritySDS: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 26u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Service: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SessionId: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2212127526, 38822, 16520, [148, 83, 161, 146, 63, 87, 59, 41]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_ShowInUninstallUI: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 8u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Siblings: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 10u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SignalStrength: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2161647270, 29811, 19212, [130, 22, 239, 193, 26, 44, 76, 139]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_SoftRestartSupported: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 22u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_Stack: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1410045054, 35648, 17852, [168, 162, 106, 11, 137, 76, 189, 162]),
    pid: 14u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_TransportRelations: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(1128310469, 37882, 18182, [151, 44, 123, 100, 128, 8, 165, 167]),
    pid: 11u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_UINumber: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 18u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_UINumberDescFormat: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 31u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_Device_UpperFilters: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2757502286, 57116, 20221, [128, 32, 103, 209, 70, 168, 80, 224]),
    pid: 19u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_BrandingIcon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 7u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_DetailedDescription: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 4u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_DocumentationLink: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 5u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_Icon: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 6u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_Model: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_DrvPkg_VendorWebSite: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3480468305, 15039, 17570, [133, 224, 154, 61, 199, 161, 33, 50]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_NAME: super::PropertiesSystem::PROPERTYKEY = super::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(3072717104, 18415, 4122, [165, 241, 2, 96, 140, 158, 235, 172]),
    pid: 10u32,
};
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct DEVPROPCOMPKEY {
    pub Key: DEVPROPKEY,
    pub Store: DEVPROPSTORE,
    pub LocaleName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DEVPROPCOMPKEY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEVPROPCOMPKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEVPROPCOMPKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVPROPCOMPKEY").field("Key", &self.Key).field("Store", &self.Store).field("LocaleName", &self.LocaleName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEVPROPCOMPKEY {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.Store == other.Store && self.LocaleName == other.LocaleName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEVPROPCOMPKEY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEVPROPCOMPKEY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct DEVPROPERTY {
    pub CompKey: DEVPROPCOMPKEY,
    pub Type: u32,
    pub BufferSize: u32,
    pub Buffer: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl DEVPROPERTY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEVPROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEVPROPERTY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVPROPERTY").field("CompKey", &self.CompKey).field("Type", &self.Type).field("BufferSize", &self.BufferSize).field("Buffer", &self.Buffer).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEVPROPERTY {
    fn eq(&self, other: &Self) -> bool {
        self.CompKey == other.CompKey && self.Type == other.Type && self.BufferSize == other.BufferSize && self.Buffer == other.Buffer
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEVPROPERTY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEVPROPERTY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROPID_FIRST_USABLE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEVPROPKEY {
    pub fmtid: ::windows::runtime::GUID,
    pub pid: u32,
}
impl DEVPROPKEY {}
impl ::std::default::Default for DEVPROPKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVPROPKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVPROPKEY").field("fmtid", &self.fmtid).field("pid", &self.pid).finish()
    }
}
impl ::std::cmp::PartialEq for DEVPROPKEY {
    fn eq(&self, other: &Self) -> bool {
        self.fmtid == other.fmtid && self.pid == other.pid
    }
}
impl ::std::cmp::Eq for DEVPROPKEY {}
unsafe impl ::windows::runtime::Abi for DEVPROPKEY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEVPROPSTORE(pub i32);
pub const DEVPROP_STORE_SYSTEM: DEVPROPSTORE = DEVPROPSTORE(0i32);
pub const DEVPROP_STORE_USER: DEVPROPSTORE = DEVPROPSTORE(1i32);
impl ::std::convert::From<i32> for DEVPROPSTORE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEVPROPSTORE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_MASK_TYPE: u32 = 4095u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_MASK_TYPEMOD: u32 = 61440u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPEMOD_ARRAY: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPEMOD_LIST: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_BOOLEAN: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_BYTE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_CURRENCY: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_DATE: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_DECIMAL: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_DEVPROPKEY: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_DEVPROPTYPE: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_DOUBLE: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_EMPTY: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_ERROR: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_FILETIME: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_FLOAT: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_GUID: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_INT16: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_INT32: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_INT64: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_NTSTATUS: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_NULL: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_SBYTE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_SECURITY_DESCRIPTOR: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_SECURITY_DESCRIPTOR_STRING: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_STRING: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_STRING_INDIRECT: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_UINT16: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_UINT32: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DEVPROP_TYPE_UINT64: u32 = 9u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct DEV_BROADCAST_DEVICEINTERFACE_A {
    pub dbcc_size: u32,
    pub dbcc_devicetype: u32,
    pub dbcc_reserved: u32,
    pub dbcc_classguid: ::windows::runtime::GUID,
    pub dbcc_name: [super::super::Foundation::CHAR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl DEV_BROADCAST_DEVICEINTERFACE_A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEV_BROADCAST_DEVICEINTERFACE_A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEV_BROADCAST_DEVICEINTERFACE_A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_DEVICEINTERFACE_A").field("dbcc_size", &self.dbcc_size).field("dbcc_devicetype", &self.dbcc_devicetype).field("dbcc_reserved", &self.dbcc_reserved).field("dbcc_classguid", &self.dbcc_classguid).field("dbcc_name", &self.dbcc_name).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEV_BROADCAST_DEVICEINTERFACE_A {
    fn eq(&self, other: &Self) -> bool {
        self.dbcc_size == other.dbcc_size && self.dbcc_devicetype == other.dbcc_devicetype && self.dbcc_reserved == other.dbcc_reserved && self.dbcc_classguid == other.dbcc_classguid && self.dbcc_name == other.dbcc_name
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEV_BROADCAST_DEVICEINTERFACE_A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_DEVICEINTERFACE_A {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_DEVICEINTERFACE_W {
    pub dbcc_size: u32,
    pub dbcc_devicetype: u32,
    pub dbcc_reserved: u32,
    pub dbcc_classguid: ::windows::runtime::GUID,
    pub dbcc_name: [u16; 1],
}
impl DEV_BROADCAST_DEVICEINTERFACE_W {}
impl ::std::default::Default for DEV_BROADCAST_DEVICEINTERFACE_W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_DEVICEINTERFACE_W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_DEVICEINTERFACE_W").field("dbcc_size", &self.dbcc_size).field("dbcc_devicetype", &self.dbcc_devicetype).field("dbcc_reserved", &self.dbcc_reserved).field("dbcc_classguid", &self.dbcc_classguid).field("dbcc_name", &self.dbcc_name).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_DEVICEINTERFACE_W {
    fn eq(&self, other: &Self) -> bool {
        self.dbcc_size == other.dbcc_size && self.dbcc_devicetype == other.dbcc_devicetype && self.dbcc_reserved == other.dbcc_reserved && self.dbcc_classguid == other.dbcc_classguid && self.dbcc_name == other.dbcc_name
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_DEVICEINTERFACE_W {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_DEVICEINTERFACE_W {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_DEVNODE {
    pub dbcd_size: u32,
    pub dbcd_devicetype: u32,
    pub dbcd_reserved: u32,
    pub dbcd_devnode: u32,
}
impl DEV_BROADCAST_DEVNODE {}
impl ::std::default::Default for DEV_BROADCAST_DEVNODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_DEVNODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_DEVNODE").field("dbcd_size", &self.dbcd_size).field("dbcd_devicetype", &self.dbcd_devicetype).field("dbcd_reserved", &self.dbcd_reserved).field("dbcd_devnode", &self.dbcd_devnode).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_DEVNODE {
    fn eq(&self, other: &Self) -> bool {
        self.dbcd_size == other.dbcd_size && self.dbcd_devicetype == other.dbcd_devicetype && self.dbcd_reserved == other.dbcd_reserved && self.dbcd_devnode == other.dbcd_devnode
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_DEVNODE {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_DEVNODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct DEV_BROADCAST_HANDLE {
    pub dbch_size: u32,
    pub dbch_devicetype: u32,
    pub dbch_reserved: u32,
    pub dbch_handle: super::super::Foundation::HANDLE,
    pub dbch_hdevnotify: *mut ::std::ffi::c_void,
    pub dbch_eventguid: ::windows::runtime::GUID,
    pub dbch_nameoffset: i32,
    pub dbch_data: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl DEV_BROADCAST_HANDLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEV_BROADCAST_HANDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEV_BROADCAST_HANDLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_HANDLE")
            .field("dbch_size", &self.dbch_size)
            .field("dbch_devicetype", &self.dbch_devicetype)
            .field("dbch_reserved", &self.dbch_reserved)
            .field("dbch_handle", &self.dbch_handle)
            .field("dbch_hdevnotify", &self.dbch_hdevnotify)
            .field("dbch_eventguid", &self.dbch_eventguid)
            .field("dbch_nameoffset", &self.dbch_nameoffset)
            .field("dbch_data", &self.dbch_data)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEV_BROADCAST_HANDLE {
    fn eq(&self, other: &Self) -> bool {
        self.dbch_size == other.dbch_size && self.dbch_devicetype == other.dbch_devicetype && self.dbch_reserved == other.dbch_reserved && self.dbch_handle == other.dbch_handle && self.dbch_hdevnotify == other.dbch_hdevnotify && self.dbch_eventguid == other.dbch_eventguid && self.dbch_nameoffset == other.dbch_nameoffset && self.dbch_data == other.dbch_data
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEV_BROADCAST_HANDLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_HANDLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_HANDLE32 {
    pub dbch_size: u32,
    pub dbch_devicetype: u32,
    pub dbch_reserved: u32,
    pub dbch_handle: u32,
    pub dbch_hdevnotify: u32,
    pub dbch_eventguid: ::windows::runtime::GUID,
    pub dbch_nameoffset: i32,
    pub dbch_data: [u8; 1],
}
impl DEV_BROADCAST_HANDLE32 {}
impl ::std::default::Default for DEV_BROADCAST_HANDLE32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_HANDLE32 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_HANDLE32")
            .field("dbch_size", &self.dbch_size)
            .field("dbch_devicetype", &self.dbch_devicetype)
            .field("dbch_reserved", &self.dbch_reserved)
            .field("dbch_handle", &self.dbch_handle)
            .field("dbch_hdevnotify", &self.dbch_hdevnotify)
            .field("dbch_eventguid", &self.dbch_eventguid)
            .field("dbch_nameoffset", &self.dbch_nameoffset)
            .field("dbch_data", &self.dbch_data)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_HANDLE32 {
    fn eq(&self, other: &Self) -> bool {
        self.dbch_size == other.dbch_size && self.dbch_devicetype == other.dbch_devicetype && self.dbch_reserved == other.dbch_reserved && self.dbch_handle == other.dbch_handle && self.dbch_hdevnotify == other.dbch_hdevnotify && self.dbch_eventguid == other.dbch_eventguid && self.dbch_nameoffset == other.dbch_nameoffset && self.dbch_data == other.dbch_data
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_HANDLE32 {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_HANDLE32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_HANDLE64 {
    pub dbch_size: u32,
    pub dbch_devicetype: u32,
    pub dbch_reserved: u32,
    pub dbch_handle: u64,
    pub dbch_hdevnotify: u64,
    pub dbch_eventguid: ::windows::runtime::GUID,
    pub dbch_nameoffset: i32,
    pub dbch_data: [u8; 1],
}
impl DEV_BROADCAST_HANDLE64 {}
impl ::std::default::Default for DEV_BROADCAST_HANDLE64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_HANDLE64 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_HANDLE64")
            .field("dbch_size", &self.dbch_size)
            .field("dbch_devicetype", &self.dbch_devicetype)
            .field("dbch_reserved", &self.dbch_reserved)
            .field("dbch_handle", &self.dbch_handle)
            .field("dbch_hdevnotify", &self.dbch_hdevnotify)
            .field("dbch_eventguid", &self.dbch_eventguid)
            .field("dbch_nameoffset", &self.dbch_nameoffset)
            .field("dbch_data", &self.dbch_data)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_HANDLE64 {
    fn eq(&self, other: &Self) -> bool {
        self.dbch_size == other.dbch_size && self.dbch_devicetype == other.dbch_devicetype && self.dbch_reserved == other.dbch_reserved && self.dbch_handle == other.dbch_handle && self.dbch_hdevnotify == other.dbch_hdevnotify && self.dbch_eventguid == other.dbch_eventguid && self.dbch_nameoffset == other.dbch_nameoffset && self.dbch_data == other.dbch_data
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_HANDLE64 {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_HANDLE64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_HDR {
    pub dbch_size: u32,
    pub dbch_devicetype: DEV_BROADCAST_HDR_DEVICE_TYPE,
    pub dbch_reserved: u32,
}
impl DEV_BROADCAST_HDR {}
impl ::std::default::Default for DEV_BROADCAST_HDR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_HDR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_HDR").field("dbch_size", &self.dbch_size).field("dbch_devicetype", &self.dbch_devicetype).field("dbch_reserved", &self.dbch_reserved).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_HDR {
    fn eq(&self, other: &Self) -> bool {
        self.dbch_size == other.dbch_size && self.dbch_devicetype == other.dbch_devicetype && self.dbch_reserved == other.dbch_reserved
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_HDR {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_HDR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEV_BROADCAST_HDR_DEVICE_TYPE(pub u32);
pub const DBT_DEVTYP_DEVICEINTERFACE: DEV_BROADCAST_HDR_DEVICE_TYPE = DEV_BROADCAST_HDR_DEVICE_TYPE(5u32);
pub const DBT_DEVTYP_HANDLE: DEV_BROADCAST_HDR_DEVICE_TYPE = DEV_BROADCAST_HDR_DEVICE_TYPE(6u32);
pub const DBT_DEVTYP_OEM: DEV_BROADCAST_HDR_DEVICE_TYPE = DEV_BROADCAST_HDR_DEVICE_TYPE(0u32);
pub const DBT_DEVTYP_PORT: DEV_BROADCAST_HDR_DEVICE_TYPE = DEV_BROADCAST_HDR_DEVICE_TYPE(3u32);
pub const DBT_DEVTYP_VOLUME: DEV_BROADCAST_HDR_DEVICE_TYPE = DEV_BROADCAST_HDR_DEVICE_TYPE(2u32);
impl ::std::convert::From<u32> for DEV_BROADCAST_HDR_DEVICE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_HDR_DEVICE_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for DEV_BROADCAST_HDR_DEVICE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for DEV_BROADCAST_HDR_DEVICE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for DEV_BROADCAST_HDR_DEVICE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for DEV_BROADCAST_HDR_DEVICE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for DEV_BROADCAST_HDR_DEVICE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_NET {
    pub dbcn_size: u32,
    pub dbcn_devicetype: u32,
    pub dbcn_reserved: u32,
    pub dbcn_resource: u32,
    pub dbcn_flags: u32,
}
impl DEV_BROADCAST_NET {}
impl ::std::default::Default for DEV_BROADCAST_NET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_NET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_NET").field("dbcn_size", &self.dbcn_size).field("dbcn_devicetype", &self.dbcn_devicetype).field("dbcn_reserved", &self.dbcn_reserved).field("dbcn_resource", &self.dbcn_resource).field("dbcn_flags", &self.dbcn_flags).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_NET {
    fn eq(&self, other: &Self) -> bool {
        self.dbcn_size == other.dbcn_size && self.dbcn_devicetype == other.dbcn_devicetype && self.dbcn_reserved == other.dbcn_reserved && self.dbcn_resource == other.dbcn_resource && self.dbcn_flags == other.dbcn_flags
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_NET {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_NET {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_OEM {
    pub dbco_size: u32,
    pub dbco_devicetype: u32,
    pub dbco_reserved: u32,
    pub dbco_identifier: u32,
    pub dbco_suppfunc: u32,
}
impl DEV_BROADCAST_OEM {}
impl ::std::default::Default for DEV_BROADCAST_OEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_OEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_OEM").field("dbco_size", &self.dbco_size).field("dbco_devicetype", &self.dbco_devicetype).field("dbco_reserved", &self.dbco_reserved).field("dbco_identifier", &self.dbco_identifier).field("dbco_suppfunc", &self.dbco_suppfunc).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_OEM {
    fn eq(&self, other: &Self) -> bool {
        self.dbco_size == other.dbco_size && self.dbco_devicetype == other.dbco_devicetype && self.dbco_reserved == other.dbco_reserved && self.dbco_identifier == other.dbco_identifier && self.dbco_suppfunc == other.dbco_suppfunc
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_OEM {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_OEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct DEV_BROADCAST_PORT_A {
    pub dbcp_size: u32,
    pub dbcp_devicetype: u32,
    pub dbcp_reserved: u32,
    pub dbcp_name: [super::super::Foundation::CHAR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl DEV_BROADCAST_PORT_A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEV_BROADCAST_PORT_A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEV_BROADCAST_PORT_A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_PORT_A").field("dbcp_size", &self.dbcp_size).field("dbcp_devicetype", &self.dbcp_devicetype).field("dbcp_reserved", &self.dbcp_reserved).field("dbcp_name", &self.dbcp_name).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEV_BROADCAST_PORT_A {
    fn eq(&self, other: &Self) -> bool {
        self.dbcp_size == other.dbcp_size && self.dbcp_devicetype == other.dbcp_devicetype && self.dbcp_reserved == other.dbcp_reserved && self.dbcp_name == other.dbcp_name
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEV_BROADCAST_PORT_A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_PORT_A {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_PORT_W {
    pub dbcp_size: u32,
    pub dbcp_devicetype: u32,
    pub dbcp_reserved: u32,
    pub dbcp_name: [u16; 1],
}
impl DEV_BROADCAST_PORT_W {}
impl ::std::default::Default for DEV_BROADCAST_PORT_W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_PORT_W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_PORT_W").field("dbcp_size", &self.dbcp_size).field("dbcp_devicetype", &self.dbcp_devicetype).field("dbcp_reserved", &self.dbcp_reserved).field("dbcp_name", &self.dbcp_name).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_PORT_W {
    fn eq(&self, other: &Self) -> bool {
        self.dbcp_size == other.dbcp_size && self.dbcp_devicetype == other.dbcp_devicetype && self.dbcp_reserved == other.dbcp_reserved && self.dbcp_name == other.dbcp_name
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_PORT_W {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_PORT_W {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DEV_BROADCAST_VOLUME {
    pub dbcv_size: u32,
    pub dbcv_devicetype: u32,
    pub dbcv_reserved: u32,
    pub dbcv_unitmask: u32,
    pub dbcv_flags: DEV_BROADCAST_VOLUME_FLAGS,
}
impl DEV_BROADCAST_VOLUME {}
impl ::std::default::Default for DEV_BROADCAST_VOLUME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEV_BROADCAST_VOLUME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEV_BROADCAST_VOLUME").field("dbcv_size", &self.dbcv_size).field("dbcv_devicetype", &self.dbcv_devicetype).field("dbcv_reserved", &self.dbcv_reserved).field("dbcv_unitmask", &self.dbcv_unitmask).field("dbcv_flags", &self.dbcv_flags).finish()
    }
}
impl ::std::cmp::PartialEq for DEV_BROADCAST_VOLUME {
    fn eq(&self, other: &Self) -> bool {
        self.dbcv_size == other.dbcv_size && self.dbcv_devicetype == other.dbcv_devicetype && self.dbcv_reserved == other.dbcv_reserved && self.dbcv_unitmask == other.dbcv_unitmask && self.dbcv_flags == other.dbcv_flags
    }
}
impl ::std::cmp::Eq for DEV_BROADCAST_VOLUME {}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_VOLUME {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DEV_BROADCAST_VOLUME_FLAGS(pub u16);
pub const DBTF_MEDIA: DEV_BROADCAST_VOLUME_FLAGS = DEV_BROADCAST_VOLUME_FLAGS(1u16);
pub const DBTF_NET: DEV_BROADCAST_VOLUME_FLAGS = DEV_BROADCAST_VOLUME_FLAGS(2u16);
impl ::std::convert::From<u16> for DEV_BROADCAST_VOLUME_FLAGS {
    fn from(value: u16) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEV_BROADCAST_VOLUME_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct DHPDEV(pub isize);
impl ::std::default::Default for DHPDEV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for DHPDEV {}
unsafe impl ::windows::runtime::Abi for DHPDEV {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct DHSURF(pub isize);
impl ::std::default::Default for DHSURF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for DHSURF {}
unsafe impl ::windows::runtime::Abi for DHSURF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DIAGNOSTIC_REASON_DETAILED_STRING: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DIAGNOSTIC_REASON_NOT_SPECIFIED: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DIAGNOSTIC_REASON_SIMPLE_STRING: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DIAGNOSTIC_REASON_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DIRECT3D_VERSION: u32 = 1792u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DISCHARGE_POLICY_CRITICAL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DISCHARGE_POLICY_LOW: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DISK_HEALTH_NOTIFICATION_DATA {
    pub DeviceGuid: ::windows::runtime::GUID,
}
impl DISK_HEALTH_NOTIFICATION_DATA {}
impl ::std::default::Default for DISK_HEALTH_NOTIFICATION_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DISK_HEALTH_NOTIFICATION_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DISK_HEALTH_NOTIFICATION_DATA").field("DeviceGuid", &self.DeviceGuid).finish()
    }
}
impl ::std::cmp::PartialEq for DISK_HEALTH_NOTIFICATION_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceGuid == other.DeviceGuid
    }
}
impl ::std::cmp::Eq for DISK_HEALTH_NOTIFICATION_DATA {}
unsafe impl ::windows::runtime::Abi for DISK_HEALTH_NOTIFICATION_DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_Diagnostics_Debug`, `Win32_System_Kernel`*"]
pub struct DISPATCHER_CONTEXT {
    pub ControlPc: usize,
    pub ImageBase: usize,
    pub FunctionEntry: *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY,
    pub EstablisherFrame: usize,
    pub TargetPc: usize,
    pub ContextRecord: *mut super::Diagnostics::Debug::CONTEXT,
    pub LanguageHandler: ::std::option::Option<super::Kernel::EXCEPTION_ROUTINE>,
    pub HandlerData: *mut ::std::ffi::c_void,
    pub HistoryTable: *mut UNWIND_HISTORY_TABLE,
    pub ScopeIndex: u32,
    pub ControlPcIsUnwound: super::super::Foundation::BOOLEAN,
    pub NonVolatileRegisters: *mut u8,
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::default::Default for DISPATCHER_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::fmt::Debug for DISPATCHER_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DISPATCHER_CONTEXT")
            .field("ControlPc", &self.ControlPc)
            .field("ImageBase", &self.ImageBase)
            .field("FunctionEntry", &self.FunctionEntry)
            .field("EstablisherFrame", &self.EstablisherFrame)
            .field("TargetPc", &self.TargetPc)
            .field("ContextRecord", &self.ContextRecord)
            .field("HandlerData", &self.HandlerData)
            .field("HistoryTable", &self.HistoryTable)
            .field("ScopeIndex", &self.ScopeIndex)
            .field("ControlPcIsUnwound", &self.ControlPcIsUnwound)
            .field("NonVolatileRegisters", &self.NonVolatileRegisters)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::PartialEq for DISPATCHER_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.ControlPc == other.ControlPc
            && self.ImageBase == other.ImageBase
            && self.FunctionEntry == other.FunctionEntry
            && self.EstablisherFrame == other.EstablisherFrame
            && self.TargetPc == other.TargetPc
            && self.ContextRecord == other.ContextRecord
            && self.LanguageHandler.map(|f| f as usize) == other.LanguageHandler.map(|f| f as usize)
            && self.HandlerData == other.HandlerData
            && self.HistoryTable == other.HistoryTable
            && self.ScopeIndex == other.ScopeIndex
            && self.ControlPcIsUnwound == other.ControlPcIsUnwound
            && self.NonVolatileRegisters == other.NonVolatileRegisters
    }
}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::Eq for DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::runtime::Abi for DISPATCHER_CONTEXT {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_Diagnostics_Debug`, `Win32_System_Kernel`*"]
pub struct DISPATCHER_CONTEXT {
    pub ControlPc: u64,
    pub ImageBase: u64,
    pub FunctionEntry: *mut IMAGE_RUNTIME_FUNCTION_ENTRY,
    pub EstablisherFrame: u64,
    pub TargetIp: u64,
    pub ContextRecord: *mut super::Diagnostics::Debug::CONTEXT,
    pub LanguageHandler: ::std::option::Option<super::Kernel::EXCEPTION_ROUTINE>,
    pub HandlerData: *mut ::std::ffi::c_void,
    pub HistoryTable: *mut UNWIND_HISTORY_TABLE,
    pub ScopeIndex: u32,
    pub Fill0: u32,
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::default::Default for DISPATCHER_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::fmt::Debug for DISPATCHER_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DISPATCHER_CONTEXT")
            .field("ControlPc", &self.ControlPc)
            .field("ImageBase", &self.ImageBase)
            .field("FunctionEntry", &self.FunctionEntry)
            .field("EstablisherFrame", &self.EstablisherFrame)
            .field("TargetIp", &self.TargetIp)
            .field("ContextRecord", &self.ContextRecord)
            .field("HandlerData", &self.HandlerData)
            .field("HistoryTable", &self.HistoryTable)
            .field("ScopeIndex", &self.ScopeIndex)
            .field("Fill0", &self.Fill0)
            .finish()
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::PartialEq for DISPATCHER_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.ControlPc == other.ControlPc && self.ImageBase == other.ImageBase && self.FunctionEntry == other.FunctionEntry && self.EstablisherFrame == other.EstablisherFrame && self.TargetIp == other.TargetIp && self.ContextRecord == other.ContextRecord && self.LanguageHandler.map(|f| f as usize) == other.LanguageHandler.map(|f| f as usize) && self.HandlerData == other.HandlerData && self.HistoryTable == other.HistoryTable && self.ScopeIndex == other.ScopeIndex && self.Fill0 == other.Fill0
    }
}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::Eq for DISPATCHER_CONTEXT {}
#[cfg(any(target_arch = "x86_64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::runtime::Abi for DISPATCHER_CONTEXT {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union DISPATCHER_CONTEXT_NONVOLREG_ARM64 {
    pub Buffer: [u8; 152],
    pub Anonymous: DISPATCHER_CONTEXT_NONVOLREG_ARM64_0,
}
impl DISPATCHER_CONTEXT_NONVOLREG_ARM64 {}
impl ::std::default::Default for DISPATCHER_CONTEXT_NONVOLREG_ARM64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DISPATCHER_CONTEXT_NONVOLREG_ARM64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DISPATCHER_CONTEXT_NONVOLREG_ARM64 {}
unsafe impl ::windows::runtime::Abi for DISPATCHER_CONTEXT_NONVOLREG_ARM64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {
    pub GpNvRegs: [u64; 11],
    pub FpNvRegs: [f64; 8],
}
impl DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {}
impl ::std::default::Default for DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("GpNvRegs", &self.GpNvRegs).field("FpNvRegs", &self.FpNvRegs).finish()
    }
}
impl ::std::cmp::PartialEq for DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {
    fn eq(&self, other: &Self) -> bool {
        self.GpNvRegs == other.GpNvRegs && self.FpNvRegs == other.FpNvRegs
    }
}
impl ::std::cmp::Eq for DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {}
unsafe impl ::windows::runtime::Abi for DISPATCHER_CONTEXT_NONVOLREG_ARM64_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DLL_PROCESS_ATTACH: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DLL_PROCESS_DETACH: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DLL_THREAD_ATTACH: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DLL_THREAD_DETACH: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DM_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DM_MONOCHROME: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_ACCELERATION_LEVEL: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_ASSOCIATE_WINDOW: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_COMPOSITION_CHANGED: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_DEVICE_ORIGIN: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_DRAWING_BEGIN: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_DRAWING_BEGIN_APIBITMAP: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_SLEEP_MODE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DN_SURFOBJ_DESTRUCTION: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_ACCESS_CONTROL_ASSISTANCE_OPS: i32 = 579i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_ACCOUNT_OPS: i32 = 548i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_ADMINS: i32 = 544i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS: i32 = 560i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_BACKUP_OPS: i32 = 551i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_CACHEABLE_PRINCIPALS_GROUP: i32 = 571i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_CERTSVC_DCOM_ACCESS_GROUP: i32 = 574i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_CRYPTO_OPERATORS: i32 = 569i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_DCOM_USERS: i32 = 562i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_DEFAULT_ACCOUNT: i32 = 581i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_DEVICE_OWNERS: i32 = 583i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_EVENT_LOG_READERS_GROUP: i32 = 573i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_GUESTS: i32 = 546i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_HYPER_V_ADMINS: i32 = 578i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS: i32 = 557i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_IUSERS: i32 = 568i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_LOGGING_USERS: i32 = 559i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_MONITORING_USERS: i32 = 558i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS: i32 = 556i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP: i32 = 572i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_POWER_USERS: i32 = 547i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_PREW2KCOMPACCESS: i32 = 554i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_PRINT_OPS: i32 = 550i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_RAS_SERVERS: i32 = 553i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_RDS_ENDPOINT_SERVERS: i32 = 576i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_RDS_MANAGEMENT_SERVERS: i32 = 577i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_RDS_REMOTE_ACCESS_SERVERS: i32 = 575i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS: i32 = 555i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_REMOTE_MANAGEMENT_USERS: i32 = 580i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_REPLICATOR: i32 = 552i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_STORAGE_REPLICA_ADMINS: i32 = 582i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_SYSTEM_OPS: i32 = 549i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_TS_LICENSE_SERVERS: i32 = 561i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_ALIAS_RID_USERS: i32 = 545i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_ADMINS: i32 = 512i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_AUTHORIZATION_DATA_CONTAINS_CLAIMS: i32 = 497i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_AUTHORIZATION_DATA_IS_COMPOUNDED: i32 = 496i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_CDC_RESERVED: i32 = 524i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_CERT_ADMINS: i32 = 517i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_CLONEABLE_CONTROLLERS: i32 = 522i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_COMPUTERS: i32 = 515i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_CONTROLLERS: i32 = 516i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_ENTERPRISE_ADMINS: i32 = 519i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_ENTERPRISE_KEY_ADMINS: i32 = 527i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_ENTERPRISE_READONLY_DOMAIN_CONTROLLERS: i32 = 498i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_GUESTS: i32 = 514i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_KEY_ADMINS: i32 = 526i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_POLICY_ADMINS: i32 = 520i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_PROTECTED_USERS: i32 = 525i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_READONLY_CONTROLLERS: i32 = 521i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_SCHEMA_ADMINS: i32 = 518i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_GROUP_RID_USERS: i32 = 513i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_ADMIN: i32 = 500i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_DEFAULT_ACCOUNT: i32 = 503i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_GUEST: i32 = 501i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_KRBTGT: i32 = 502i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_MAX: i32 = 999i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DOMAIN_USER_RID_WDAG_ACCOUNT: i32 = 504i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DP2BLT_LINEAR: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DP2BLT_POINT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DRD_ERROR: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DRD_SUCCESS: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DRH_APIBITMAP: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
pub struct DRH_APIBITMAPDATA {
    pub pso: *mut super::super::UI::DisplayDevices::SURFOBJ,
    pub b: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl DRH_APIBITMAPDATA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for DRH_APIBITMAPDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for DRH_APIBITMAPDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRH_APIBITMAPDATA").field("pso", &self.pso).field("b", &self.b).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for DRH_APIBITMAPDATA {
    fn eq(&self, other: &Self) -> bool {
        self.pso == other.pso && self.b == other.b
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for DRH_APIBITMAPDATA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for DRH_APIBITMAPDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DRVQUERY_USERMODE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DSS_FLUSH_EVENT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DSS_RESERVED: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DSS_RESERVED1: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DSS_RESERVED2: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DSS_TIMER_EVENT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DX9_DDI_VERSION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DYNAMIC_EH_CONTINUATION_TARGET_ADD: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DYNAMIC_EH_CONTINUATION_TARGET_PROCESSED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DYNAMIC_ENFORCED_ADDRESS_RANGE_ADD: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const DYNAMIC_ENFORCED_ADDRESS_RANGE_PROCESSED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ECS_REDRAW: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ECS_TEARDOWN: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ED_ABORTDOC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EHN_ERROR: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EHN_RESTORED: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IC_INST_WORD_POS_X: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IC_INST_WORD_X: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IC_SIZE_X: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IC_VAL_POS_X: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41a_INST_WORD_POS_X: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41a_INST_WORD_X: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41a_SIZE_X: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41a_VAL_POS_X: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41b_INST_WORD_POS_X: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41b_INST_WORD_X: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41b_SIZE_X: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41b_VAL_POS_X: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41c_INST_WORD_POS_X: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41c_INST_WORD_X: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41c_SIZE_X: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM41c_VAL_POS_X: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM5C_INST_WORD_POS_X: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM5C_INST_WORD_X: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM5C_SIZE_X: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM5C_VAL_POS_X: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM7B_INST_WORD_POS_X: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM7B_INST_WORD_X: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM7B_SIZE_X: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM7B_VAL_POS_X: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM9D_INST_WORD_POS_X: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM9D_INST_WORD_X: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM9D_SIZE_X: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_IMM9D_VAL_POS_X: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_SIGN_INST_WORD_POS_X: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_SIGN_INST_WORD_X: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_SIGN_SIZE_X: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EMARCH_ENC_I17_SIGN_VAL_POS_X: u32 = 63u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Gdi`*"]
pub struct EMFINFO {
    pub nSize: u32,
    pub hdc: super::super::Graphics::Gdi::HDC,
    pub pvEMF: *mut u8,
    pub pvCurrentRecord: *mut u8,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl EMFINFO {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for EMFINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for EMFINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EMFINFO").field("nSize", &self.nSize).field("hdc", &self.hdc).field("pvEMF", &self.pvEMF).field("pvCurrentRecord", &self.pvCurrentRecord).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for EMFINFO {
    fn eq(&self, other: &Self) -> bool {
        self.nSize == other.nSize && self.hdc == other.hdc && self.pvEMF == other.pvEMF && self.pvCurrentRecord == other.pvCurrentRecord
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for EMFINFO {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for EMFINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_LONG_ID_LENGTH: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_SHORT_ID_LENGTH: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_TYPE_SGX: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_TYPE_SGX2: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_TYPE_VBS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_TYPE_VBS_BASIC: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENCLAVE_VBS_FLAG_DEBUG: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENDCAP_BUTT: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENDCAP_ROUND: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENDCAP_SQUARE: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENG_DEVICE_ATTRIBUTE(pub i32);
pub const QDA_RESERVED: ENG_DEVICE_ATTRIBUTE = ENG_DEVICE_ATTRIBUTE(0i32);
pub const QDA_ACCELERATION_LEVEL: ENG_DEVICE_ATTRIBUTE = ENG_DEVICE_ATTRIBUTE(1i32);
impl ::std::convert::From<i32> for ENG_DEVICE_ATTRIBUTE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENG_DEVICE_ATTRIBUTE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENG_FNT_CACHE_READ_FAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENG_FNT_CACHE_WRITE_FAULT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENG_SYSTEM_ATTRIBUTE(pub i32);
pub const EngProcessorFeature: ENG_SYSTEM_ATTRIBUTE = ENG_SYSTEM_ATTRIBUTE(1i32);
pub const EngNumberOfProcessors: ENG_SYSTEM_ATTRIBUTE = ENG_SYSTEM_ATTRIBUTE(2i32);
pub const EngOptimumAvailableUserMemory: ENG_SYSTEM_ATTRIBUTE = ENG_SYSTEM_ATTRIBUTE(3i32);
pub const EngOptimumAvailableSystemMemory: ENG_SYSTEM_ATTRIBUTE = ENG_SYSTEM_ATTRIBUTE(4i32);
impl ::std::convert::From<i32> for ENG_SYSTEM_ATTRIBUTE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENG_SYSTEM_ATTRIBUTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ENLISTMENT_BASIC_INFORMATION {
    pub EnlistmentId: ::windows::runtime::GUID,
    pub TransactionId: ::windows::runtime::GUID,
    pub ResourceManagerId: ::windows::runtime::GUID,
}
impl ENLISTMENT_BASIC_INFORMATION {}
impl ::std::default::Default for ENLISTMENT_BASIC_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ENLISTMENT_BASIC_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ENLISTMENT_BASIC_INFORMATION").field("EnlistmentId", &self.EnlistmentId).field("TransactionId", &self.TransactionId).field("ResourceManagerId", &self.ResourceManagerId).finish()
    }
}
impl ::std::cmp::PartialEq for ENLISTMENT_BASIC_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.EnlistmentId == other.EnlistmentId && self.TransactionId == other.TransactionId && self.ResourceManagerId == other.ResourceManagerId
    }
}
impl ::std::cmp::Eq for ENLISTMENT_BASIC_INFORMATION {}
unsafe impl ::windows::runtime::Abi for ENLISTMENT_BASIC_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct ENLISTMENT_CRM_INFORMATION {
    pub CrmTransactionManagerId: ::windows::runtime::GUID,
    pub CrmResourceManagerId: ::windows::runtime::GUID,
    pub CrmEnlistmentId: ::windows::runtime::GUID,
}
impl ENLISTMENT_CRM_INFORMATION {}
impl ::std::default::Default for ENLISTMENT_CRM_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ENLISTMENT_CRM_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ENLISTMENT_CRM_INFORMATION").field("CrmTransactionManagerId", &self.CrmTransactionManagerId).field("CrmResourceManagerId", &self.CrmResourceManagerId).field("CrmEnlistmentId", &self.CrmEnlistmentId).finish()
    }
}
impl ::std::cmp::PartialEq for ENLISTMENT_CRM_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.CrmTransactionManagerId == other.CrmTransactionManagerId && self.CrmResourceManagerId == other.CrmResourceManagerId && self.CrmEnlistmentId == other.CrmEnlistmentId
    }
}
impl ::std::cmp::Eq for ENLISTMENT_CRM_INFORMATION {}
unsafe impl ::windows::runtime::Abi for ENLISTMENT_CRM_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENLISTMENT_INFORMATION_CLASS(pub i32);
pub const EnlistmentBasicInformation: ENLISTMENT_INFORMATION_CLASS = ENLISTMENT_INFORMATION_CLASS(0i32);
pub const EnlistmentRecoveryInformation: ENLISTMENT_INFORMATION_CLASS = ENLISTMENT_INFORMATION_CLASS(1i32);
pub const EnlistmentCrmInformation: ENLISTMENT_INFORMATION_CLASS = ENLISTMENT_INFORMATION_CLASS(2i32);
impl ::std::convert::From<i32> for ENLISTMENT_INFORMATION_CLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENLISTMENT_INFORMATION_CLASS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENLISTMENT_QUERY_INFORMATION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENLISTMENT_RECOVER: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENLISTMENT_SET_INFORMATION: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENLISTMENT_SUBORDINATE_RIGHTS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ENLISTMENT_SUPERIOR_RIGHTS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ERROR_SEVERITY_ERROR: u32 = 3221225472u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ERROR_SEVERITY_INFORMATIONAL: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ERROR_SEVERITY_SUCCESS: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const ERROR_SEVERITY_WARNING: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_EventLog")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_EventLog`*"]
pub struct EVENTLOGRECORD {
    pub Length: u32,
    pub Reserved: u32,
    pub RecordNumber: u32,
    pub TimeGenerated: u32,
    pub TimeWritten: u32,
    pub EventID: u32,
    pub EventType: super::EventLog::REPORT_EVENT_TYPE,
    pub NumStrings: u16,
    pub EventCategory: u16,
    pub ReservedFlags: u16,
    pub ClosingRecordNumber: u32,
    pub StringOffset: u32,
    pub UserSidLength: u32,
    pub UserSidOffset: u32,
    pub DataLength: u32,
    pub DataOffset: u32,
}
#[cfg(feature = "Win32_System_EventLog")]
impl EVENTLOGRECORD {}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::default::Default for EVENTLOGRECORD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::fmt::Debug for EVENTLOGRECORD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EVENTLOGRECORD")
            .field("Length", &self.Length)
            .field("Reserved", &self.Reserved)
            .field("RecordNumber", &self.RecordNumber)
            .field("TimeGenerated", &self.TimeGenerated)
            .field("TimeWritten", &self.TimeWritten)
            .field("EventID", &self.EventID)
            .field("EventType", &self.EventType)
            .field("NumStrings", &self.NumStrings)
            .field("EventCategory", &self.EventCategory)
            .field("ReservedFlags", &self.ReservedFlags)
            .field("ClosingRecordNumber", &self.ClosingRecordNumber)
            .field("StringOffset", &self.StringOffset)
            .field("UserSidLength", &self.UserSidLength)
            .field("UserSidOffset", &self.UserSidOffset)
            .field("DataLength", &self.DataLength)
            .field("DataOffset", &self.DataOffset)
            .finish()
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::cmp::PartialEq for EVENTLOGRECORD {
    fn eq(&self, other: &Self) -> bool {
        self.Length == other.Length
            && self.Reserved == other.Reserved
            && self.RecordNumber == other.RecordNumber
            && self.TimeGenerated == other.TimeGenerated
            && self.TimeWritten == other.TimeWritten
            && self.EventID == other.EventID
            && self.EventType == other.EventType
            && self.NumStrings == other.NumStrings
            && self.EventCategory == other.EventCategory
            && self.ReservedFlags == other.ReservedFlags
            && self.ClosingRecordNumber == other.ClosingRecordNumber
            && self.StringOffset == other.StringOffset
            && self.UserSidLength == other.UserSidLength
            && self.UserSidOffset == other.UserSidOffset
            && self.DataLength == other.DataLength
            && self.DataOffset == other.DataOffset
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::cmp::Eq for EVENTLOGRECORD {}
#[cfg(feature = "Win32_System_EventLog")]
unsafe impl ::windows::runtime::Abi for EVENTLOGRECORD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_BACKWARDS_READ: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_END_ALL_PAIRED_EVENTS: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_END_PAIRED_EVENT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_FORWARDS_READ: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_PAIRED_EVENT_ACTIVE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_PAIRED_EVENT_INACTIVE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENTLOG_START_PAIRED_EVENT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_EventLog")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_EventLog`*"]
pub struct EVENTSFORLOGFILE {
    pub ulSize: u32,
    pub szLogicalLogFile: [u16; 256],
    pub ulNumRecords: u32,
    pub pEventLogRecords: [EVENTLOGRECORD; 1],
}
#[cfg(feature = "Win32_System_EventLog")]
impl EVENTSFORLOGFILE {}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::default::Default for EVENTSFORLOGFILE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::fmt::Debug for EVENTSFORLOGFILE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EVENTSFORLOGFILE").field("ulSize", &self.ulSize).field("szLogicalLogFile", &self.szLogicalLogFile).field("ulNumRecords", &self.ulNumRecords).field("pEventLogRecords", &self.pEventLogRecords).finish()
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::cmp::PartialEq for EVENTSFORLOGFILE {
    fn eq(&self, other: &Self) -> bool {
        self.ulSize == other.ulSize && self.szLogicalLogFile == other.szLogicalLogFile && self.ulNumRecords == other.ulNumRecords && self.pEventLogRecords == other.pEventLogRecords
    }
}
#[cfg(feature = "Win32_System_EventLog")]
impl ::std::cmp::Eq for EVENTSFORLOGFILE {}
#[cfg(feature = "Win32_System_EventLog")]
unsafe impl ::windows::runtime::Abi for EVENTSFORLOGFILE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EVENT_MODIFY_STATE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_COLLIDED_UNWIND: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_EXECUTE_FAULT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_EXIT_UNWIND: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_MAXIMUM_PARAMETERS: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_NESTED_CALL: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_NONCONTINUABLE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_READ_FAULT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct EXCEPTION_RECORD32 {
    pub ExceptionCode: super::super::Foundation::NTSTATUS,
    pub ExceptionFlags: u32,
    pub ExceptionRecord: u32,
    pub ExceptionAddress: u32,
    pub NumberParameters: u32,
    pub ExceptionInformation: [u32; 15],
}
#[cfg(feature = "Win32_Foundation")]
impl EXCEPTION_RECORD32 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for EXCEPTION_RECORD32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for EXCEPTION_RECORD32 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EXCEPTION_RECORD32")
            .field("ExceptionCode", &self.ExceptionCode)
            .field("ExceptionFlags", &self.ExceptionFlags)
            .field("ExceptionRecord", &self.ExceptionRecord)
            .field("ExceptionAddress", &self.ExceptionAddress)
            .field("NumberParameters", &self.NumberParameters)
            .field("ExceptionInformation", &self.ExceptionInformation)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for EXCEPTION_RECORD32 {
    fn eq(&self, other: &Self) -> bool {
        self.ExceptionCode == other.ExceptionCode && self.ExceptionFlags == other.ExceptionFlags && self.ExceptionRecord == other.ExceptionRecord && self.ExceptionAddress == other.ExceptionAddress && self.NumberParameters == other.NumberParameters && self.ExceptionInformation == other.ExceptionInformation
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for EXCEPTION_RECORD32 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for EXCEPTION_RECORD32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_Diagnostics_Debug`, `Win32_System_Kernel`*"]
pub struct EXCEPTION_REGISTRATION_RECORD {
    pub Next: *mut EXCEPTION_REGISTRATION_RECORD,
    pub Handler: ::std::option::Option<super::Kernel::EXCEPTION_ROUTINE>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl EXCEPTION_REGISTRATION_RECORD {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::default::Default for EXCEPTION_REGISTRATION_RECORD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::fmt::Debug for EXCEPTION_REGISTRATION_RECORD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EXCEPTION_REGISTRATION_RECORD").field("Next", &self.Next).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::PartialEq for EXCEPTION_REGISTRATION_RECORD {
    fn eq(&self, other: &Self) -> bool {
        self.Next == other.Next && self.Handler.map(|f| f as usize) == other.Handler.map(|f| f as usize)
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::Eq for EXCEPTION_REGISTRATION_RECORD {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::runtime::Abi for EXCEPTION_REGISTRATION_RECORD {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_SOFTWARE_ORIGINATE: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_STACK_INVALID: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_TARGET_UNWIND: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_UNWINDING: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const EXCEPTION_WRITE_FAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn EngQueryEMFInfo<'a, Param0: ::windows::runtime::IntoParam<'a, HDEV>>(hdev: Param0, pemfinfo: *mut EMFINFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EngQueryEMFInfo(hdev: HDEV, pemfinfo: *mut EMFINFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EngQueryEMFInfo(hdev.into_param().abi(), ::std::mem::transmute(pemfinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FACILITY_MCA_ERROR_CODE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_ADMINLESS_ACCESS_DENIED: u32 = 55u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_APCS_DISABLED: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_CAST_GUARD: u32 = 65u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_CERTIFICATION_FAILURE: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_CONTROL_INVALID_RETURN_ADDRESS: u32 = 57u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_CORRUPT_LIST_ENTRY: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_CRYPTO_LIBRARY: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_DEPRECATED_SERVICE_INVOKED: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_DLOAD_PROTECTION_FAILURE: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_ENCLAVE_CALL_FAILURE: u32 = 53u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_ETW_CORRUPTION: u32 = 61u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_FATAL_APP_EXIT: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_FLAGS_CORRUPTION: u32 = 59u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GS_COOKIE_INIT: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_EXPORT_SUPPRESSION_FAILURE: u32 = 46u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_ICALL_CHECK_FAILURE: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_ICALL_CHECK_FAILURE_XFG: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_ICALL_CHECK_SUPPRESSED: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_JUMPTABLE: u32 = 37u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_SS_FAILURE: u32 = 44u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_GUARD_WRITE_CHECK_FAILURE: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_HEAP_METADATA_CORRUPTION: u32 = 50u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_HOST_VISIBILITY_CHANGE: u32 = 66u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INCORRECT_STACK: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_ARG: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_BALANCED_TREE: u32 = 29u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_BUFFER_ACCESS: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_CALL_IN_DLL_CALLOUT: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_CONTROL_STACK: u32 = 47u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_DISPATCH_CONTEXT: u32 = 39u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_EXCEPTION_CHAIN: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_FAST_FAIL_CODE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_FIBER_SWITCH: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_FILE_OPERATION: u32 = 42u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_FLS_DATA: u32 = 70u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_IAT: u32 = 49u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_IDLE_STATE: u32 = 33u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_IMAGE_BASE: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_JUMP_BUFFER: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_LOCK_STATE: u32 = 36u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_LONGJUMP_TARGET: u32 = 38u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_NEXT_THREAD: u32 = 30u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_PFN: u32 = 63u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_REFERENCE_COUNT: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_SET_OF_CONTEXT: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_SYSCALL_NUMBER: u32 = 41u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_INVALID_THREAD: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_KERNEL_CET_SHADOW_STACK_ASSIST: u32 = 67u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_LEGACY_GS_VIOLATION: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_LOADER_CONTINUITY_FAILURE: u32 = 45u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_LOW_LABEL_ACCESS_DENIED: u32 = 52u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_LPAC_ACCESS_DENIED: u32 = 43u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_MRDATA_MODIFIED: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_MRDATA_PROTECTION_FAILURE: u32 = 34u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_NTDLL_PATCH_FAILED: u32 = 69u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_PATCH_CALLBACK_FAILED: u32 = 68u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_PAYLOAD_RESTRICTION_VIOLATION: u32 = 51u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_RANGE_CHECK_FAILURE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_RIO_ABORT: u32 = 62u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_SET_CONTEXT_DENIED: u32 = 48u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_STACK_COOKIE_CHECK_FAILURE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNEXPECTED_CALL: u32 = 56u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNEXPECTED_HEAP_EXCEPTION: u32 = 35u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNEXPECTED_HOST_BEHAVIOR: u32 = 58u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNHANDLED_LSS_EXCEPTON: u32 = 54u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNSAFE_EXTENSION_CALL: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_UNSAFE_REGISTRY_ACCESS: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_VEH_CORRUPTION: u32 = 60u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FAST_FAIL_VTGUARD_CHECK_FAILURE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FC_COMPLEX: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FC_RECT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FC_RECT4: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FDM_TYPE_BM_SIDE_CONST: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FDM_TYPE_CHAR_INC_EQUAL_BM_BASE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FDM_TYPE_CONST_BEARINGS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FDM_TYPE_MAXEXT_EQUAL_BM_SIDE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FDM_TYPE_ZERO_BEARINGS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FD_ERROR: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct FD_LIGATURE {
    pub culThis: u32,
    pub ulType: u32,
    pub cLigatures: u32,
    pub alig: [LIGATURE; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl FD_LIGATURE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FD_LIGATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for FD_LIGATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FD_LIGATURE").field("culThis", &self.culThis).field("ulType", &self.ulType).field("cLigatures", &self.cLigatures).field("alig", &self.alig).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FD_LIGATURE {
    fn eq(&self, other: &Self) -> bool {
        self.culThis == other.culThis && self.ulType == other.ulType && self.cLigatures == other.cLigatures && self.alig == other.alig
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FD_LIGATURE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FD_LIGATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FD_NEGATIVE_FONT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FF_IGNORED_SIGNATURE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FF_SIGNATURE_VERIFIED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_ATTRIBUTE_STRICTLY_SEQUENTIAL: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_CASE_PRESERVED_NAMES: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_CASE_SENSITIVE_SEARCH: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_CS_FLAG_CASE_SENSITIVE_DIR: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_DAX_VOLUME: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_FILE_COMPRESSION: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_NAMED_STREAMS: u32 = 262144u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_PERSISTENT_ACLS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_READ_ONLY_VOLUME: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_RETURNS_CLEANUP_RESULT_INFO: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SEQUENTIAL_WRITE_ONCE: u32 = 1048576u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_BLOCK_REFCOUNTING: u32 = 134217728u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_BYPASS_IO: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_ENCRYPTION: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_EXTENDED_ATTRIBUTES: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_GHOSTING: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_HARD_LINKS: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_INTEGRITY_STREAMS: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_OBJECT_IDS: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_OPEN_BY_FILE_ID: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_POSIX_UNLINK_RENAME: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_REMOTE_STORAGE: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_REPARSE_POINTS: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_SPARSE_FILES: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_SPARSE_VDL: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_TRANSACTIONS: u32 = 2097152u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_SUPPORTS_USN_JOURNAL: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_UNICODE_ON_DISK: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_VOLUME_IS_COMPRESSED: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILE_VOLUME_QUOTAS: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILL_NV_MEMORY_FLAG_FLUSH: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILL_NV_MEMORY_FLAG_NON_TEMPORAL: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FILL_NV_MEMORY_FLAG_NO_DRAIN: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union FLOAT_LONG {
    pub e: f32,
    pub l: i32,
}
impl FLOAT_LONG {}
impl ::std::default::Default for FLOAT_LONG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for FLOAT_LONG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for FLOAT_LONG {}
unsafe impl ::windows::runtime::Abi for FLOAT_LONG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FLS_MAXIMUM_AVAILABLE: u32 = 4080u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FLUSH_FLAGS_FILE_DATA_ONLY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FLUSH_FLAGS_FILE_DATA_SYNC_ONLY: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FLUSH_FLAGS_NO_SYNC: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FLUSH_NV_MEMORY_IN_FLAG_NO_DRAIN: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FL_NONPAGED_MEMORY: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FL_NON_SESSION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FL_ZERO_MEMORY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_EDITABLE_EMBED: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_16BPP: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_1BPP: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_24BPP: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_32BPP: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_4BPP: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_8BPP: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_90DEGREE_ROTATIONS: u32 = 2097152u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_ANISOTROPIC_SCALING_ONLY: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_ARB_XFORMS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_CONSTANT_WIDTH: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_DBCS_FIXED_PITCH: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_DO_NOT_ENUMERATE: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_DSIG: u32 = 262144u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_FAMILY_EQUIV: u32 = 134217728u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_IGNORE_TC_RA_ABLE: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_INTEGER_WIDTH: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_INTEGRAL_SCALING: u32 = 1048576u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_ISOTROPIC_SCALING_ONLY: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_NONNEGATIVE_AC: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_NOT_CONTIGUOUS: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_OPTICALLY_FIXED_PITCH: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_RETURNS_BITMAPS: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_RETURNS_OUTLINES: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_RETURNS_STROKES: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_RIGHT_HANDED: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_BITMAP: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_CFF: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_MM: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_OUTLINE_NOT_TRUETYPE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_STROKE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_TRUETYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_INFO_TECH_TYPE1: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_NO_EMBEDDING: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_PANOSE_CULTURE_LATIN: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_READONLY_EMBED: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_BOLD: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_ITALIC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_NEGATIVE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_OUTLINED: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_REGULAR: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_STRIKEOUT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_SEL_UNDERSCORE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_TYPE_LICENSED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FM_VERSION_NUMBER: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FOREST_USER_RID_MAX: i32 = 499i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_ATTR_MODE_ROTATE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_CFF: u32 = 1048576u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_CLEARTYPENATURAL_X: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_CLEARTYPE_X: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_CLEARTYPE_Y: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_DBCS_FONT: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_DEVICE_FONT: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_EM_HEIGHT: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_GLYPHBITS: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_GRAY16: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_HGLYPHS: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_MULTIPLEMASTER: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_NOCLEARTYPE: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_NOGRAY16: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_NOHINTS: u32 = 262144u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_NO_CHOICE: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_OUTLINE_CAPABLE: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_PATHOBJ: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_POSTSCRIPT: u32 = 2097152u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_SIM_BOLD: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_SIM_ITALIC: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FO_VERT_FACE: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FP_ALTERNATEMODE: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FP_WINDINGMODE: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FRAME_FPO: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FRAME_NONFPO: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FRAME_TRAP: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const FRAME_TSS: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type FREEOBJPROC = unsafe extern "system" fn(pdriverobj: *mut ::std::mem::ManuallyDrop<super::super::UI::DisplayDevices::DRIVEROBJ>) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_ACC_DRIVER: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_ALPHACURSOR: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_BITMAPEXREUSE: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_CHANGEGAMMARAMP: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_CLEARTYPE: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_EXCLUDELAYERED: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_ICD_MULTIMON: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_INCLUDEAPIBITMAPS: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_JPEGSRC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_MOUSETRAILS: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_PNGSRC: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_REMOTEDRIVER: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_RESERVED1: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_SHOWHIDDENPOINTER: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_SYNCFLUSH: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_SYNCTIMER: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS2_xxxx: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ALTERNATEFILL: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ARBRUSHOPAQUE: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ARBRUSHTEXT: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ASYNCCHANGE: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ASYNCMOVE: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_BEZIERS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_CMYKCOLOR: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_COLOR_DITHER: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_DIRECTDRAW: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_DITHERONREALIZE: u32 = 2097152u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_DONTJOURNAL: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_FONT_RASTERIZER: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_FORCEDITHER: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_GEOMETRICWIDE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_GRAY16: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_HALFTONE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_HIGHRESTEXT: u32 = 262144u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_HORIZSTRIKE: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_ICM: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_LAYERED: u32 = 134217728u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_MONO_DITHER: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_NO64BITMEMACCESS: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_NUP: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_OPAQUERECT: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_PALMANAGED: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_PANNING: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_SCREENPRECISION: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_VECTORFONT: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_VERTSTRIKE: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GCAPS_WINDINGFILL: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GDI_DRIVER_VERSION: u32 = 16384u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Com")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Com`*"]
pub struct GDI_NONREMOTE {
    pub fContext: i32,
    pub u: GDI_NONREMOTE_0,
}
#[cfg(feature = "Win32_System_Com")]
impl GDI_NONREMOTE {}
#[cfg(feature = "Win32_System_Com")]
impl ::std::default::Default for GDI_NONREMOTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::cmp::PartialEq for GDI_NONREMOTE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::cmp::Eq for GDI_NONREMOTE {}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::runtime::Abi for GDI_NONREMOTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Com")]
pub union GDI_NONREMOTE_0 {
    pub hInproc: i32,
    pub hRemote: *mut super::Com::DWORD_BLOB,
}
#[cfg(feature = "Win32_System_Com")]
impl GDI_NONREMOTE_0 {}
#[cfg(feature = "Win32_System_Com")]
impl ::std::default::Default for GDI_NONREMOTE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::cmp::PartialEq for GDI_NONREMOTE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::cmp::Eq for GDI_NONREMOTE_0 {}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::runtime::Abi for GDI_NONREMOTE_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GENERIC_ALL: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GENERIC_EXECUTE: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GENERIC_READ: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GENERIC_WRITE: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct GESTURECONFIG_FLAGS(pub u32);
pub const GC_ALLGESTURES: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_ZOOM: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_PAN: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_PAN_WITH_SINGLE_FINGER_VERTICALLY: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(2u32);
pub const GC_PAN_WITH_SINGLE_FINGER_HORIZONTALLY: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(4u32);
pub const GC_PAN_WITH_GUTTER: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(8u32);
pub const GC_PAN_WITH_INERTIA: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(16u32);
pub const GC_ROTATE: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_TWOFINGERTAP: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_PRESSANDTAP: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
pub const GC_ROLLOVER: GESTURECONFIG_FLAGS = GESTURECONFIG_FLAGS(1u32);
impl ::std::convert::From<u32> for GESTURECONFIG_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for GESTURECONFIG_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for GESTURECONFIG_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for GESTURECONFIG_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for GESTURECONFIG_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for GESTURECONFIG_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for GESTURECONFIG_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GS_16BIT_HANDLES: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GS_8BIT_HANDLES: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GS_UNICODE_HANDLES: u32 = 1u32;
pub const GUID_ACDC_POWER_SOURCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1564383833, 59861, 19200, [166, 189, 255, 52, 255, 81, 101, 72]);
pub const GUID_ACTIVE_POWERSCHEME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(838464134, 20612, 17150, [183, 32, 43, 2, 100, 153, 55, 99]);
pub const GUID_ADAPTIVE_INPUT_CONTROLLER_STATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(244906729, 62554, 19937, [167, 87, 96, 49, 241, 151, 246, 234]);
pub const GUID_ADAPTIVE_POWER_BEHAVIOR_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2249832726, 57348, 19928, [155, 102, 218, 232, 111, 128, 102, 152]);
pub const GUID_ADVANCED_COLOR_QUALITY_BIAS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1749827177, 42231, 16404, [135, 84, 212, 81, 121, 165, 97, 103]);
pub const GUID_ALLOW_AWAYMODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(635412809, 24017, 18230, [181, 171, 232, 163, 123, 91, 129, 135]);
pub const GUID_ALLOW_DISPLAY_REQUIRED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2848897242, 52550, 17659, [169, 139, 2, 175, 105, 222, 70, 35]);
pub const GUID_ALLOW_RTC_WAKE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3174789514, 1664, 19869, [138, 178, 225, 210, 180, 172, 128, 109]);
pub const GUID_ALLOW_STANDBY_STATES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2885428505, 13832, 19498, [148, 234, 23, 27, 14, 213, 70, 171]);
pub const GUID_ALLOW_SYSTEM_REQUIRED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2763101685, 33317, 18392, [128, 18, 157, 65, 54, 151, 134, 226]);
pub const GUID_APPLAUNCH_BUTTON: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(443060785, 29593, 20122, [143, 153, 183, 31, 153, 157, 179, 250]);
pub const GUID_BACKGROUND_TASK_NOTIFICATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3475239488, 10836, 18648, [177, 20, 222, 21, 24, 255, 5, 46]);
pub const GUID_BATTERY_COUNT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2099658517, 64676, 18917, [133, 75, 169, 242, 191, 189, 92, 36]);
pub const GUID_BATTERY_DISCHARGE_ACTION_0: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1669242927, 48075, 16405, [142, 44, 161, 199, 185, 192, 181, 70]);
pub const GUID_BATTERY_DISCHARGE_ACTION_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3631492555, 15978, 19260, [179, 254, 55, 70, 35, 205, 207, 6]);
pub const GUID_BATTERY_DISCHARGE_ACTION_2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1109178936, 6798, 18561, [172, 137, 227, 58, 139, 4, 236, 228]);
pub const GUID_BATTERY_DISCHARGE_ACTION_3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2152146451, 38784, 17758, [179, 8, 114, 211, 0, 60, 242, 248]);
pub const GUID_BATTERY_DISCHARGE_FLAGS_0: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1572568223, 14569, 16594, [151, 73, 79, 138, 14, 159, 100, 15]);
pub const GUID_BATTERY_DISCHARGE_FLAGS_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3168721233, 6267, 19717, [188, 204, 247, 229, 25, 96, 194, 88]);
pub const GUID_BATTERY_DISCHARGE_FLAGS_2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2144530628, 65207, 19875, [129, 23, 227, 251, 237, 196, 101, 130]);
pub const GUID_BATTERY_DISCHARGE_FLAGS_3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1935752399, 56314, 17017, [131, 86, 73, 53, 246, 191, 98, 243]);
pub const GUID_BATTERY_DISCHARGE_LEVEL_0: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2590431447, 20471, 20217, [181, 162, 90, 50, 108, 162, 164, 105]);
pub const GUID_BATTERY_DISCHARGE_LEVEL_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2172893850, 59664, 18650, [135, 105, 20, 174, 109, 193, 23, 10]);
pub const GUID_BATTERY_DISCHARGE_LEVEL_2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(127958178, 44463, 16599, [176, 119, 83, 58, 173, 237, 27, 250]);
pub const GUID_BATTERY_DISCHARGE_LEVEL_3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1487918502, 49885, 18386, [159, 191, 239, 112, 204, 92, 89, 101]);
pub const GUID_BATTERY_PERCENTAGE_REMAINING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2813165633, 46170, 19630, [135, 163, 238, 203, 180, 104, 169, 225]);
pub const GUID_BATTERY_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3879339149, 48935, 20242, [151, 49, 139, 32, 118, 232, 137, 31]);
pub const GUID_CONNECTIVITY_IN_STANDBY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4048910056, 39095, 16774, [185, 68, 234, 250, 102, 68, 2, 217]);
pub const GUID_CONSOLE_DISPLAY_STATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1877382486, 28746, 18336, [143, 36, 194, 141, 147, 111, 218, 71]);
pub const GUID_CRITICAL_POWER_TRANSITION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3080876069, 58729, 18114, [165, 4, 43, 150, 202, 210, 37, 161]);
pub const GUID_DEEP_SLEEP_ENABLED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3573741550, 7623, 20221, [165, 93, 240, 75, 111, 92, 5, 69]);
pub const GUID_DEEP_SLEEP_PLATFORM_STATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3527356344, 38198, 16440, [156, 148, 28, 224, 46, 92, 33, 82]);
pub const GUID_DEVICE_EVENT_RBC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497281426, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_DEVICE_IDLE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1336588058, 37605, 18214, [181, 49, 34, 69, 89, 103, 45, 25]);
pub const GUID_DEVICE_POWER_POLICY_VIDEO_BRIGHTNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2918014594, 47369, 17945, [153, 73, 245, 215, 29, 172, 11, 203]);
pub const GUID_DEVICE_POWER_POLICY_VIDEO_DIM_BRIGHTNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4059823586, 43360, 16741, [159, 136, 80, 102, 121, 17, 206, 150]);
pub const GUID_DEVINTERFACE_DMP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(632611432, 10757, 18798, [128, 59, 38, 104, 55, 251, 218, 75]);
pub const GUID_DEVINTERFACE_DMR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3498532788, 8598, 19578, [166, 61, 228, 22, 173, 221, 96, 161]);
pub const GUID_DEVINTERFACE_DMS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3378526126, 42328, 17520, [180, 50, 17, 90, 49, 184, 85, 83]);
pub const GUID_DISCONNECTED_STANDBY_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1756345049, 61077, 18344, [143, 80, 65, 21, 8, 128, 115, 177]);
pub const GUID_DISK_ADAPTIVE_POWERDOWN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(963261153, 18842, 16562, [145, 36, 169, 106, 254, 112, 118, 103]);
pub const GUID_DISK_BURST_IGNORE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2162411022, 48020, 19160, [187, 224, 13, 49, 149, 239, 198, 99]);
pub const GUID_DISK_COALESCING_POWERDOWN_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3278835380, 10632, 19056, [142, 238, 8, 132, 252, 44, 36, 51]);
pub const GUID_DISK_IDLE_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1491311528, 47334, 20214, [144, 208, 137, 174, 50, 178, 88, 214]);
pub const GUID_DISK_MAX_POWER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1373545808, 47928, 19396, [153, 27, 234, 207, 55, 190, 94, 200]);
pub const GUID_DISK_NVME_NOPPME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4235424438, 43821, 17390, [135, 151, 21, 233, 132, 31, 44, 202]);
pub const GUID_DISK_POWERDOWN_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1731781316, 59557, 19010, [177, 106, 224, 64, 231, 105, 117, 110]);
pub const GUID_DISK_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1240647, 36929, 19293, [155, 119, 83, 95, 186, 139, 20, 66]);
pub const GUID_ENABLE_SWITCH_FORCED_SHUTDOWN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2201643874, 57252, 18129, [130, 248, 224, 158, 52, 208, 41, 214]);
pub const GUID_ENERGY_SAVER_BATTERY_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3868611530, 53119, 20229, [170, 115, 203, 131, 63, 169, 10, 212]);
pub const GUID_ENERGY_SAVER_BRIGHTNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(332437636, 63310, 18250, [168, 82, 182, 189, 232, 173, 3, 168]);
pub const GUID_ENERGY_SAVER_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1549513545, 44329, 20194, [157, 11, 43, 37, 39, 15, 122, 129]);
pub const GUID_ENERGY_SAVER_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3733129507, 42338, 16815, [160, 134, 227, 162, 198, 186, 210, 218]);
pub const GUID_EXECUTION_REQUIRED_REQUEST_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(828816449, 32408, 19971, [179, 78, 236, 15, 95, 43, 33, 142]);
pub const GUID_GLOBAL_USER_PRESENCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2020510237, 46119, 17220, [146, 7, 9, 231, 11, 220, 190, 169]);
pub const GUID_GPU_PREFERENCE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3716451114, 35421, 17489, [154, 226, 57, 205, 65, 101, 143, 108]);
pub const GUID_GRAPHICS_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1605669773, 7912, 19215, [154, 60, 80, 54, 176, 171, 153, 92]);
pub const GUID_HIBERNATE_FASTS4_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2494328105, 29646, 16806, [128, 159, 99, 99, 186, 33, 180, 126]);
pub const GUID_HIBERNATE_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2641892774, 32484, 18814, [136, 136, 81, 90, 5, 240, 35, 100]);
pub const GUID_HUPR_ADAPTIVE_DISPLAY_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(175991478, 44163, 19153, [130, 130, 236, 165, 181, 131, 8, 243]);
pub const GUID_IDLE_BACKGROUND_TASK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1364996568, 63284, 5693, [160, 253, 17, 160, 140, 145, 232, 241]);
pub const GUID_IDLE_RESILIENCY_PERIOD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3291183530, 43578, 18507, [169, 143, 44, 243, 42, 169, 10, 40]);
pub const GUID_IDLE_RESILIENCY_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(778047792, 21329, 19869, [142, 4, 37, 41, 102, 186, 208, 84]);
pub const GUID_INTSTEER_LOAD_PER_PROC_TRIGGER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1942873677, 55072, 19378, [168, 96, 199, 85, 175, 231, 126, 242]);
pub const GUID_INTSTEER_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(737944825, 24226, 18433, [130, 19, 61, 186, 224, 26, 163, 157]);
pub const GUID_INTSTEER_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1214721848, 31386, 19378, [139, 248, 61, 133, 190, 25, 222, 78]);
pub const GUID_INTSTEER_TIME_UNPARK_TRIGGER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3602532611, 14447, 19500, [138, 219, 92, 33, 179, 50, 141, 37]);
pub const GUID_IO_CDROM_EXCLUSIVE_LOCK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3159802169, 31248, 18414, [162, 148, 76, 106, 56, 240, 20, 154]);
pub const GUID_IO_CDROM_EXCLUSIVE_UNLOCK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2746667645, 24117, 18565, [129, 229, 238, 24, 192, 14, 215, 121]);
pub const GUID_IO_DEVICE_BECOMING_READY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497276400, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_IO_DEVICE_EXTERNAL_REQUEST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497276368, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_IO_DISK_CLONE_ARRIVAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1784776795, 31801, 17373, [155, 86, 184, 172, 34, 165, 73, 170]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {
    pub DiskNumber: u32,
}
impl GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {}
impl ::std::default::Default for GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION").field("DiskNumber", &self.DiskNumber).finish()
    }
}
impl ::std::cmp::PartialEq for GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.DiskNumber == other.DiskNumber
    }
}
impl ::std::cmp::Eq for GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {}
unsafe impl ::windows::runtime::Abi for GUID_IO_DISK_CLONE_ARRIVAL_INFORMATION {
    type Abi = Self;
}
pub const GUID_IO_DISK_HEALTH_NOTIFICATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(253482564, 14614, 18885, [176, 99, 153, 25, 64, 17, 143, 178]);
pub const GUID_IO_DISK_LAYOUT_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(299889996, 33897, 16889, [179, 222, 239, 131, 100, 135, 197, 74]);
pub const GUID_IO_DRIVE_REQUIRES_CLEANING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1913096060, 37101, 17637, [160, 0, 129, 66, 141, 76, 121, 187]);
pub const GUID_IO_MEDIA_ARRIVAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497276352, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_IO_MEDIA_EJECT_REQUEST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497276369, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_IO_MEDIA_REMOVAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3497276353, 43406, 4562, [145, 122, 0, 160, 201, 6, 143, 243]);
pub const GUID_IO_TAPE_ERASE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2234323435, 19384, 17671, [157, 155, 65, 124, 194, 177, 180, 56]);
pub const GUID_IO_VOLUME_BACKGROUND_FORMAT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2732981382, 54733, 16440, [178, 227, 68, 69, 6, 92, 35, 119]);
pub const GUID_IO_VOLUME_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1936942410, 33066, 4560, [190, 199, 8, 0, 43, 226, 9, 47]);
pub const GUID_IO_VOLUME_CHANGE_SIZE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(974529982, 44291, 18929, [142, 248, 107, 186, 193, 130, 209, 253]);
pub const GUID_IO_VOLUME_DEVICE_INTERFACE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1408590605, 46783, 4560, [148, 242, 0, 160, 201, 30, 251, 139]);
pub const GUID_IO_VOLUME_DISMOUNT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3513406952, 4185, 4562, [143, 253, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_DISMOUNT_FAILED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3821384056, 4189, 4562, [143, 253, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_FORCE_CLOSED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1092278351, 17214, 19906, [165, 174, 74, 45, 26, 45, 230, 84]);
pub const GUID_IO_VOLUME_FVE_STATUS_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(103389362, 60959, 19306, [184, 87, 231, 108, 187, 233, 166, 218]);
pub const GUID_IO_VOLUME_INFO_MAKE_COMPAT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(985243858, 61312, 17871, [140, 220, 203, 224, 42, 33, 41, 6]);
pub const GUID_IO_VOLUME_LOCK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1349552244, 51631, 4561, [143, 239, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_LOCK_FAILED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2922310928, 2984, 4562, [143, 251, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_MOUNT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3045083256, 6806, 4562, [143, 253, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_NAME_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(770277251, 19462, 4562, [165, 50, 0, 96, 151, 19, 5, 90]);
pub const GUID_IO_VOLUME_NEED_CHKDSK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2040138080, 2571, 19971, [173, 136, 47, 167, 198, 206, 116, 138]);
pub const GUID_IO_VOLUME_PHYSICAL_CONFIGURATION_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(770277252, 19462, 4562, [165, 50, 0, 96, 151, 19, 5, 90]);
pub const GUID_IO_VOLUME_PREPARING_EJECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3349066094, 3500, 20090, [168, 108, 178, 92, 238, 170, 136, 246]);
pub const GUID_IO_VOLUME_UNIQUE_ID_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2939804226, 26146, 16885, [151, 11, 19, 157, 9, 47, 163, 217]);
pub const GUID_IO_VOLUME_UNLOCK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2592882024, 53451, 4561, [143, 239, 0, 160, 201, 160, 109, 50]);
pub const GUID_IO_VOLUME_WEARING_OUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2268140490, 5254, 17672, [130, 172, 195, 178, 229, 41, 122, 170]);
pub const GUID_IO_VOLUME_WORM_NEAR_FULL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4089446274, 62430, 18642, [175, 149, 69, 127, 128, 183, 99, 242]);
pub const GUID_LEGACY_RTC_MITIGATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(439664067, 32363, 17454, [169, 208, 100, 182, 239, 55, 142, 132]);
pub const GUID_LIDCLOSE_ACTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1554527079, 28229, 17823, [162, 123, 71, 107, 29, 1, 201, 54]);
pub const GUID_LIDOPEN_POWERSTATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2583630055, 9137, 19463, [169, 209, 92, 50, 6, 215, 65, 180]);
pub const GUID_LIDSWITCH_STATE_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3124629325, 47127, 16532, [162, 209, 213, 99, 121, 230, 160, 243]);
pub const GUID_LIDSWITCH_STATE_RELIABILITY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2924236785, 54113, 17396, [128, 170, 187, 182, 235, 3, 222, 148]);
pub const GUID_LOCK_CONSOLE_ON_WAKE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(242838491, 4109, 18390, [162, 213, 247, 210, 218, 165, 31, 81]);
pub const GUID_MAX_POWER_SAVINGS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2709787400, 13633, 20395, [188, 129, 247, 21, 86, 242, 11, 74]);
pub const GUID_MIN_POWER_SAVINGS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2355003354, 59583, 19094, [154, 133, 166, 226, 58, 140, 99, 92]);
pub const GUID_MIXED_REALITY_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(509766478, 52996, 20365, [156, 199, 201, 124, 91, 15, 35, 145]);
pub const GUID_MONITOR_POWER_ON: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(41095189, 17680, 17702, [153, 230, 229, 161, 126, 189, 26, 234]);
pub const GUID_NON_ADAPTIVE_INPUT_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1524350908, 1870, 19873, [186, 56, 219, 139, 54, 178, 200, 243]);
pub const GUID_PCIEXPRESS_ASPM_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3994220806, 53879, 16459, [182, 218, 229, 250, 26, 87, 109, 245]);
pub const GUID_PCIEXPRESS_SETTINGS_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1343900947, 17071, 17449, [159, 209, 168, 33, 140, 38, 142, 32]);
pub const GUID_POWERBUTTON_ACTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1984491427, 56732, 20030, [181, 102, 80, 249, 41, 56, 98, 128]);
pub const GUID_POWERSCHEME_PERSONALITY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(610108737, 14659, 17442, [176, 37, 19, 167, 132, 246, 121, 183]);
pub const GUID_POWER_SAVING_STATUS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3758708928, 49683, 19150, [172, 119, 254, 204, 237, 46, 238, 165]);
pub const GUID_PROCESSOR_ALLOW_THROTTLING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(990172413, 7367, 20259, [171, 28, 209, 51, 120, 25, 196, 187]);
pub const GUID_PROCESSOR_CLASS0_FLOOR_PERF: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4259087403, 33636, 20188, [148, 207, 193, 127, 96, 222, 28, 128]);
pub const GUID_PROCESSOR_CLASS1_INITIAL_PERF: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(531430501, 43312, 19397, [159, 56, 80, 78, 192, 151, 187, 192]);
pub const GUID_PROCESSOR_CORE_PARKING_AFFINITY_HISTORY_DECREASE_FACTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2407220707, 50067, 18442, [135, 140, 246, 122, 195, 208, 112, 130]);
pub const GUID_PROCESSOR_CORE_PARKING_AFFINITY_HISTORY_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1530095995, 59549, 19768, [170, 70, 158, 125, 251, 124, 210, 249]);
pub const GUID_PROCESSOR_CORE_PARKING_AFFINITY_WEIGHTING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3876087793, 64047, 20302, [174, 161, 77, 138, 11, 162, 59, 32]);
pub const GUID_PROCESSOR_CORE_PARKING_DECREASE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1895963457, 51017, 19745, [190, 116, 160, 15, 51, 93, 88, 43]);
pub const GUID_PROCESSOR_CORE_PARKING_DECREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1759325991, 42190, 19985, [132, 135, 55, 148, 228, 19, 93, 250]);
pub const GUID_PROCESSOR_CORE_PARKING_DECREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3755019543, 54763, 17885, [135, 122, 154, 52, 221, 209, 92, 130]);
pub const GUID_PROCESSOR_CORE_PARKING_INCREASE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3351119481, 10263, 19817, [157, 2, 81, 154, 83, 126, 208, 198]);
pub const GUID_PROCESSOR_CORE_PARKING_INCREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3742640449, 8435, 20191, [154, 74, 156, 131, 211, 215, 23, 209]);
pub const GUID_PROCESSOR_CORE_PARKING_INCREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(769481348, 23153, 17278, [145, 42, 219, 11, 140, 120, 135, 50]);
pub const GUID_PROCESSOR_CORE_PARKING_MAX_CORES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3926270001, 3636, 20465, [155, 109, 235, 16, 89, 51, 64, 40]);
pub const GUID_PROCESSOR_CORE_PARKING_MAX_CORES_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3926270001, 3636, 20465, [155, 109, 235, 16, 89, 51, 64, 41]);
pub const GUID_PROCESSOR_CORE_PARKING_MIN_CORES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(214283847, 49631, 17975, [137, 26, 222, 195, 92, 49, 133, 131]);
pub const GUID_PROCESSOR_CORE_PARKING_MIN_CORES_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(214283847, 49631, 17975, [137, 26, 222, 195, 92, 49, 133, 132]);
pub const GUID_PROCESSOR_CORE_PARKING_OVER_UTILIZATION_HISTORY_DECREASE_FACTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(312017468, 48168, 20234, [129, 236, 211, 41, 90, 141, 129, 93]);
pub const GUID_PROCESSOR_CORE_PARKING_OVER_UTILIZATION_HISTORY_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2596376210, 43580, 20007, [179, 7, 1, 174, 55, 48, 113, 41]);
pub const GUID_PROCESSOR_CORE_PARKING_OVER_UTILIZATION_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2486996150, 28563, 16935, [173, 135, 233, 163, 254, 236, 8, 209]);
pub const GUID_PROCESSOR_CORE_PARKING_OVER_UTILIZATION_WEIGHTING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2282341080, 45397, 17108, [188, 218, 13, 52, 86, 81, 177, 219]);
pub const GUID_PROCESSOR_DISTRIBUTE_UTILITY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3758125872, 62857, 17133, [164, 1, 93, 219, 16, 231, 133, 211]);
pub const GUID_PROCESSOR_DUTY_CYCLING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1313099955, 24953, 20113, [184, 241, 91, 185, 147, 143, 129, 161]);
pub const GUID_PROCESSOR_FREQUENCY_LIMIT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1974513215, 48352, 17831, [140, 137, 201, 97, 28, 37, 225, 0]);
pub const GUID_PROCESSOR_FREQUENCY_LIMIT_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1974513215, 48352, 17831, [140, 137, 201, 97, 28, 37, 225, 1]);
pub const GUID_PROCESSOR_HETEROGENEOUS_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2133810426, 61708, 18467, [181, 225, 233, 58, 232, 95, 70, 181]);
pub const GUID_PROCESSOR_HETERO_DECREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4169538599, 38375, 18268, [134, 91, 19, 192, 203, 63, 157, 107]);
pub const GUID_PROCESSOR_HETERO_DECREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2133103286, 24753, 17893, [174, 85, 119, 63, 140, 213, 202, 236]);
pub const GUID_PROCESSOR_HETERO_INCREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2952804733, 39691, 18493, [152, 201, 105, 42, 96, 96, 207, 191]);
pub const GUID_PROCESSOR_HETERO_INCREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1074392999, 59181, 19642, [158, 223, 145, 8, 78, 168, 203, 195]);
pub const GUID_PROCESSOR_IDLESTATE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1760715431, 63009, 16489, [185, 165, 72, 116, 22, 155, 226, 60]);
pub const GUID_PROCESSOR_IDLE_ALLOW_SCALING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1814664112, 36680, 18463, [188, 198, 0, 221, 39, 66, 170, 6]);
pub const GUID_PROCESSOR_IDLE_DEMOTE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1267914584, 23076, 18513, [164, 112, 129, 93, 120, 174, 225, 25]);
pub const GUID_PROCESSOR_IDLE_DISABLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1568056010, 59584, 16431, [161, 51, 33, 88, 73, 45, 88, 173]);
pub const GUID_PROCESSOR_IDLE_PROMOTE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2065844355, 46028, 19833, [129, 159, 131, 116, 21, 44, 190, 124]);
pub const GUID_PROCESSOR_IDLE_STATE_MAXIMUM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2571364613, 39472, 20161, [155, 153, 68, 221, 59, 118, 247, 162]);
pub const GUID_PROCESSOR_IDLE_TIME_CHECK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3294108721, 35243, 17815, [142, 43, 156, 156, 171, 68, 14, 107]);
pub const GUID_PROCESSOR_LATENCY_HINT_MIN_UNPARK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1634523813, 26974, 17733, [151, 173, 151, 220, 45, 27, 221, 136]);
pub const GUID_PROCESSOR_LATENCY_HINT_MIN_UNPARK_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1634523813, 26974, 17733, [151, 173, 151, 220, 45, 27, 221, 137]);
pub const GUID_PROCESSOR_PARKING_CONCURRENCY_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(607169391, 42272, 17570, [150, 1, 247, 242, 59, 81, 52, 177]);
pub const GUID_PROCESSOR_PARKING_CORE_OVERRIDE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2773881514, 63012, 17094, [164, 67, 115, 151, 208, 100, 192, 79]);
pub const GUID_PROCESSOR_PARKING_DISTRIBUTION_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1272640745, 53507, 18135, [165, 240, 98, 128, 18, 22, 22, 239]);
pub const GUID_PROCESSOR_PARKING_HEADROOM_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4147488371, 8294, 20352, [160, 197, 221, 238, 12, 241, 191, 93]);
pub const GUID_PROCESSOR_PARKING_PERF_STATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1148335559, 27277, 19648, [142, 36, 158, 175, 112, 185, 110, 43]);
pub const GUID_PROCESSOR_PARKING_PERF_STATE_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1148335559, 27277, 19648, [142, 36, 158, 175, 112, 185, 110, 44]);
pub const GUID_PROCESSOR_PERFSTATE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3151771668, 6377, 17507, [138, 85, 209, 151, 50, 124, 69, 192]);
pub const GUID_PROCESSOR_PERF_AUTONOMOUS_ACTIVITY_WINDOW: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3488457680, 30359, 17766, [169, 34, 169, 8, 108, 212, 157, 250]);
pub const GUID_PROCESSOR_PERF_AUTONOMOUS_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2343193226, 5318, 17489, [142, 139, 20, 189, 189, 25, 117, 55]);
pub const GUID_PROCESSOR_PERF_BOOST_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3191042616, 3458, 16710, [169, 96, 79, 55, 73, 212, 112, 199]);
pub const GUID_PROCESSOR_PERF_BOOST_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1169997892, 55429, 17378, [134, 5, 238, 14, 198, 233, 107, 89]);
pub const GUID_PROCESSOR_PERF_CORE_PARKING_HISTORY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2010641026, 36634, 17101, [133, 55, 69, 69, 10, 131, 155, 232]);
pub const GUID_PROCESSOR_PERF_DECREASE_HISTORY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(50394872, 43990, 17833, [183, 79, 73, 8, 105, 26, 64, 181]);
pub const GUID_PROCESSOR_PERF_DECREASE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1090252743, 11933, 19749, [161, 133, 12, 253, 133, 116, 186, 198]);
pub const GUID_PROCESSOR_PERF_DECREASE_POLICY_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1090252743, 11933, 19749, [161, 133, 12, 253, 133, 116, 186, 199]);
pub const GUID_PROCESSOR_PERF_DECREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(312519492, 65064, 20393, [179, 189, 75, 100, 244, 73, 96, 166]);
pub const GUID_PROCESSOR_PERF_DECREASE_THRESHOLD_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(312519492, 65064, 20393, [179, 189, 75, 100, 244, 73, 96, 167]);
pub const GUID_PROCESSOR_PERF_DECREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3639471003, 38351, 20373, [167, 60, 176, 97, 151, 54, 147, 200]);
pub const GUID_PROCESSOR_PERF_DECREASE_TIME_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3639471003, 38351, 20373, [167, 60, 176, 97, 151, 54, 147, 201]);
pub const GUID_PROCESSOR_PERF_ENERGY_PERFORMANCE_PREFERENCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(912818078, 58277, 19903, [177, 220, 21, 235, 56, 28, 104, 99]);
pub const GUID_PROCESSOR_PERF_ENERGY_PERFORMANCE_PREFERENCE_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(912818078, 58277, 19903, [177, 220, 21, 235, 56, 28, 104, 100]);
pub const GUID_PROCESSOR_PERF_HISTORY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2099559079, 2948, 18447, [132, 12, 27, 7, 67, 192, 15, 95]);
pub const GUID_PROCESSOR_PERF_HISTORY_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2099559079, 2948, 18447, [132, 12, 27, 7, 67, 192, 15, 96]);
pub const GUID_PROCESSOR_PERF_INCREASE_HISTORY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2578706177, 29999, 18081, [128, 251, 119, 48, 1, 31, 35, 84]);
pub const GUID_PROCESSOR_PERF_INCREASE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1180573520, 46608, 18234, [171, 88, 0, 209, 7, 125, 196, 24]);
pub const GUID_PROCESSOR_PERF_INCREASE_POLICY_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1180573520, 46608, 18234, [171, 88, 0, 209, 7, 125, 196, 25]);
pub const GUID_PROCESSOR_PERF_INCREASE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(113958670, 25837, 17546, [137, 39, 206, 123, 249, 14, 179, 93]);
pub const GUID_PROCESSOR_PERF_INCREASE_THRESHOLD_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(113958670, 25837, 17546, [137, 39, 206, 123, 249, 14, 179, 94]);
pub const GUID_PROCESSOR_PERF_INCREASE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2555180178, 15341, 17544, [168, 249, 66, 134, 201, 123, 245, 170]);
pub const GUID_PROCESSOR_PERF_INCREASE_TIME_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2555180178, 15341, 17544, [168, 249, 66, 134, 201, 123, 245, 171]);
pub const GUID_PROCESSOR_PERF_LATENCY_HINT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(136503089, 40067, 17436, [160, 121, 13, 228, 207, 0, 156, 123]);
pub const GUID_PROCESSOR_PERF_LATENCY_HINT_PERF: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1637577989, 59, 20098, [183, 166, 77, 210, 156, 48, 9, 113]);
pub const GUID_PROCESSOR_PERF_LATENCY_HINT_PERF_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1637577989, 59, 20098, [183, 166, 77, 210, 156, 48, 9, 114]);
pub const GUID_PROCESSOR_PERF_TIME_CHECK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1294664018, 32092, 18827, [136, 226, 52, 52, 83, 146, 162, 197]);
pub const GUID_PROCESSOR_RESPONSIVENESS_DISABLE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(951597117, 52448, 19577, [158, 62, 86, 164, 241, 124, 196, 128]);
pub const GUID_PROCESSOR_RESPONSIVENESS_DISABLE_THRESHOLD_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(951597117, 52448, 19577, [158, 62, 86, 164, 241, 124, 196, 129]);
pub const GUID_PROCESSOR_RESPONSIVENESS_DISABLE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4117076383, 16304, 16666, [162, 38, 63, 1, 152, 222, 193, 48]);
pub const GUID_PROCESSOR_RESPONSIVENESS_DISABLE_TIME_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4117076383, 16304, 16666, [162, 38, 63, 1, 152, 222, 193, 49]);
pub const GUID_PROCESSOR_RESPONSIVENESS_ENABLE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1027924566, 29218, 17429, [169, 237, 156, 69, 250, 61, 216, 48]);
pub const GUID_PROCESSOR_RESPONSIVENESS_ENABLE_THRESHOLD_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1027924566, 29218, 17429, [169, 237, 156, 69, 250, 61, 216, 49]);
pub const GUID_PROCESSOR_RESPONSIVENESS_ENABLE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1032933768, 30768, 18862, [167, 154, 15, 176, 161, 229, 162, 0]);
pub const GUID_PROCESSOR_RESPONSIVENESS_ENABLE_TIME_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1032933768, 30768, 18862, [167, 154, 15, 176, 161, 229, 162, 1]);
pub const GUID_PROCESSOR_RESPONSIVENESS_EPP_CEILING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1143457595, 38742, 19036, [184, 75, 199, 189, 167, 156, 115, 32]);
pub const GUID_PROCESSOR_RESPONSIVENESS_EPP_CEILING_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1143457595, 38742, 19036, [184, 75, 199, 189, 167, 156, 115, 33]);
pub const GUID_PROCESSOR_RESPONSIVENESS_PERF_FLOOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3465450222, 27270, 17778, [191, 224, 32, 194, 29, 3, 205, 64]);
pub const GUID_PROCESSOR_RESPONSIVENESS_PERF_FLOOR_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3465450222, 27270, 17778, [191, 224, 32, 194, 29, 3, 205, 65]);
pub const GUID_PROCESSOR_SETTINGS_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1414738513, 33470, 18468, [150, 193, 71, 182, 11, 116, 13, 0]);
pub const GUID_PROCESSOR_SHORT_THREAD_RUNTIME_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3643381954, 27208, 18890, [133, 212, 140, 206, 236, 41, 69, 112]);
pub const GUID_PROCESSOR_SHORT_THREAD_SCHEDULING_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3135277953, 11614, 18056, [173, 106, 19, 36, 51, 86, 101, 75]);
pub const GUID_PROCESSOR_SOFT_PARKING_LATENCY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2546969665, 8727, 18411, [153, 45, 97, 139, 25, 119, 201, 7]);
pub const GUID_PROCESSOR_THREAD_SCHEDULING_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2478356188, 1688, 19740, [158, 228, 6, 68, 233, 0, 200, 93]);
pub const GUID_PROCESSOR_THROTTLE_MAXIMUM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3159374071, 9184, 18784, [150, 218, 51, 171, 175, 89, 53, 236]);
pub const GUID_PROCESSOR_THROTTLE_MAXIMUM_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3159374071, 9184, 18784, [150, 218, 51, 171, 175, 89, 53, 237]);
pub const GUID_PROCESSOR_THROTTLE_MINIMUM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2302537358, 11247, 16864, [137, 198, 181, 93, 9, 41, 150, 76]);
pub const GUID_PROCESSOR_THROTTLE_MINIMUM_1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2302537358, 11247, 16864, [137, 198, 181, 93, 9, 41, 150, 77]);
pub const GUID_PROCESSOR_THROTTLE_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1459778308, 19190, 16644, [146, 96, 227, 217, 82, 72, 252, 54]);
pub const GUID_SESSION_DISPLAY_STATUS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(730120718, 44323, 19935, [147, 219, 5, 255, 189, 126, 252, 165]);
pub const GUID_SESSION_USER_PRESENCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1007633736, 49215, 19533, [185, 242, 35, 126, 222, 104, 99, 118]);
pub const GUID_SLEEPBUTTON_ACTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2526636992, 44368, 18412, [146, 59, 111, 65, 135, 77, 217, 235]);
pub const GUID_SLEEP_IDLE_THRESHOLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2177708768, 30771, 17651, [135, 55, 112, 129, 243, 141, 31, 112]);
pub const GUID_SLEEP_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(596418472, 2733, 16877, [131, 244, 151, 190, 36, 44, 143, 32]);
pub const GUID_SPR_ACTIVE_SESSION_CHANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(237293112, 50067, 18242, [189, 177, 116, 79, 75, 158, 224, 142]);
pub const GUID_STANDBY_BUDGET_GRACE_PERIOD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1623228385, 1366, 17871, [153, 3, 213, 110, 50, 33, 2, 66]);
pub const GUID_STANDBY_BUDGET_PERCENT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2682595262, 7024, 18650, [147, 13, 123, 207, 23, 180, 73, 144]);
pub const GUID_STANDBY_RESERVE_GRACE_PERIOD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3345215122, 29160, 16679, [132, 235, 246, 237, 4, 58, 62, 61]);
pub const GUID_STANDBY_RESERVE_TIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1183836133, 4440, 18156, [136, 188, 91, 150, 201, 228, 79, 208]);
pub const GUID_STANDBY_RESET_PERCENT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1238045093, 22242, 19195, [157, 56, 61, 244, 120, 114, 226, 27]);
pub const GUID_STANDBY_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(704037339, 34522, 18629, [159, 219, 242, 182, 123, 31, 68, 218]);
pub const GUID_SYSTEM_AWAYMODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2561144192, 503, 18602, [156, 15, 68, 53, 44, 41, 229, 192]);
pub const GUID_SYSTEM_BUTTON_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1335303817, 61117, 17493, [168, 222, 158, 89, 4, 14, 115, 71]);
pub const GUID_SYSTEM_COOLING_POLICY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2496898581, 43161, 19141, [174, 43, 228, 216, 246, 52, 54, 127]);
pub const GUID_TYPICAL_POWER_SAVINGS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(941310498, 63124, 16880, [150, 133, 255, 91, 178, 96, 223, 46]);
pub const GUID_UNATTEND_SLEEP_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2076484345, 55548, 17513, [176, 123, 51, 235, 120, 90, 172, 160]);
pub const GUID_USERINTERFACEBUTTON_ACTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2802214483, 36204, 16552, [145, 14, 161, 245, 75, 132, 199, 229]);
pub const GUID_USER_PRESENCE_PREDICTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2181109509, 64405, 19782, [141, 53, 64, 66, 177, 210, 13, 239]);
pub const GUID_VIDEO_ADAPTIVE_DISPLAY_BRIGHTNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4225346150, 38227, 16535, [186, 68, 237, 110, 157, 101, 234, 184]);
pub const GUID_VIDEO_ADAPTIVE_PERCENT_INCREASE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4007199967, 45378, 16771, [177, 11, 90, 17, 151, 163, 120, 100]);
pub const GUID_VIDEO_ADAPTIVE_POWERDOWN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2425724194, 54945, 18873, [175, 147, 188, 232, 133, 173, 51, 91]);
pub const GUID_VIDEO_ANNOYANCE_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2195443501, 52583, 16581, [191, 220, 159, 26, 92, 205, 70, 99]);
pub const GUID_VIDEO_CONSOLE_LOCK_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2395255717, 26728, 18626, [190, 117, 79, 48, 68, 190, 136, 167]);
pub const GUID_VIDEO_CURRENT_MONITOR_BRIGHTNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2415846086, 11521, 18110, [173, 185, 57, 138, 221, 197, 180, 255]);
pub const GUID_VIDEO_DIM_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(397058715, 35651, 19348, [170, 254, 53, 246, 77, 170, 241, 238]);
pub const GUID_VIDEO_POWERDOWN_TIMEOUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1007403041, 51368, 19975, [169, 115, 107, 20, 203, 203, 43, 126]);
pub const GUID_VIDEO_SUBGROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1964423519, 63350, 17508, [140, 83, 6, 22, 127, 64, 204, 153]);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GX_GENERAL: i32 = 3i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GX_IDENTITY: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GX_OFFSET: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const GX_SCALE: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HBM(pub isize);
impl ::std::default::Default for HBM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HBM {}
unsafe impl ::windows::runtime::Abi for HBM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HDEV(pub isize);
impl ::std::default::Default for HDEV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HDEV {}
unsafe impl ::windows::runtime::Abi for HDEV {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HDRVOBJ(pub isize);
impl ::std::default::Default for HDRVOBJ {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HDRVOBJ {}
unsafe impl ::windows::runtime::Abi for HDRVOBJ {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct HEAP_INFORMATION_CLASS(pub i32);
pub const HeapCompatibilityInformation: HEAP_INFORMATION_CLASS = HEAP_INFORMATION_CLASS(0i32);
pub const HeapEnableTerminationOnCorruption: HEAP_INFORMATION_CLASS = HEAP_INFORMATION_CLASS(1i32);
pub const HeapOptimizeResources: HEAP_INFORMATION_CLASS = HEAP_INFORMATION_CLASS(3i32);
pub const HeapTag: HEAP_INFORMATION_CLASS = HEAP_INFORMATION_CLASS(7i32);
impl ::std::convert::From<i32> for HEAP_INFORMATION_CLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HEAP_INFORMATION_CLASS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HEAP_OPTIMIZE_RESOURCES_CURRENT_VERSION: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct HEAP_OPTIMIZE_RESOURCES_INFORMATION {
    pub Version: u32,
    pub Flags: u32,
}
impl HEAP_OPTIMIZE_RESOURCES_INFORMATION {}
impl ::std::default::Default for HEAP_OPTIMIZE_RESOURCES_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for HEAP_OPTIMIZE_RESOURCES_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HEAP_OPTIMIZE_RESOURCES_INFORMATION").field("Version", &self.Version).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for HEAP_OPTIMIZE_RESOURCES_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for HEAP_OPTIMIZE_RESOURCES_INFORMATION {}
unsafe impl ::windows::runtime::Abi for HEAP_OPTIMIZE_RESOURCES_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HFASTMUTEX(pub isize);
impl ::std::default::Default for HFASTMUTEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HFASTMUTEX {}
unsafe impl ::windows::runtime::Abi for HFASTMUTEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct HIBERFILE_BUCKET {
    pub MaxPhysicalMemory: u64,
    pub PhysicalMemoryPercent: [u32; 3],
}
impl HIBERFILE_BUCKET {}
impl ::std::default::Default for HIBERFILE_BUCKET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for HIBERFILE_BUCKET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HIBERFILE_BUCKET").field("MaxPhysicalMemory", &self.MaxPhysicalMemory).field("PhysicalMemoryPercent", &self.PhysicalMemoryPercent).finish()
    }
}
impl ::std::cmp::PartialEq for HIBERFILE_BUCKET {
    fn eq(&self, other: &Self) -> bool {
        self.MaxPhysicalMemory == other.MaxPhysicalMemory && self.PhysicalMemoryPercent == other.PhysicalMemoryPercent
    }
}
impl ::std::cmp::Eq for HIBERFILE_BUCKET {}
unsafe impl ::windows::runtime::Abi for HIBERFILE_BUCKET {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct HIBERFILE_BUCKET_SIZE(pub i32);
pub const HiberFileBucket1GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(0i32);
pub const HiberFileBucket2GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(1i32);
pub const HiberFileBucket4GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(2i32);
pub const HiberFileBucket8GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(3i32);
pub const HiberFileBucket16GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(4i32);
pub const HiberFileBucket32GB: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(5i32);
pub const HiberFileBucketUnlimited: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(6i32);
pub const HiberFileBucketMax: HIBERFILE_BUCKET_SIZE = HIBERFILE_BUCKET_SIZE(7i32);
impl ::std::convert::From<i32> for HIBERFILE_BUCKET_SIZE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HIBERFILE_BUCKET_SIZE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HIBERFILE_TYPE_FULL: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HIBERFILE_TYPE_MAX: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HIBERFILE_TYPE_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HIBERFILE_TYPE_REDUCED: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HLSURF(pub isize);
impl ::std::default::Default for HLSURF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HLSURF {}
unsafe impl ::windows::runtime::Abi for HLSURF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_ALPHABLEND: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_BITBLT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_COPYBITS: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_FILLPATH: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_FLAGS: u32 = 243199u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_GRADIENTFILL: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_LINETO: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_MOVEPANNING: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_PAINT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_PLGBLT: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_STRETCHBLT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_STRETCHBLTROP: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_STROKEANDFILLPATH: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_STROKEPATH: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_SYNCHRONIZE: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_SYNCHRONIZEACCESS: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_TEXTOUT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HOOK_TRANSPARENTBLT: u32 = 32768u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct HSEMAPHORE__ {
    pub unused: i32,
}
impl HSEMAPHORE__ {}
impl ::std::default::Default for HSEMAPHORE__ {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for HSEMAPHORE__ {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HSEMAPHORE__").field("unused", &self.unused).finish()
    }
}
impl ::std::cmp::PartialEq for HSEMAPHORE__ {
    fn eq(&self, other: &Self) -> bool {
        self.unused == other.unused
    }
}
impl ::std::cmp::Eq for HSEMAPHORE__ {}
unsafe impl ::windows::runtime::Abi for HSEMAPHORE__ {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HSPRITE(pub isize);
impl ::std::default::Default for HSPRITE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HSPRITE {}
unsafe impl ::windows::runtime::Abi for HSPRITE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HSTR(pub isize);
impl ::std::default::Default for HSTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HSTR {}
unsafe impl ::windows::runtime::Abi for HSTR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HS_DDI_MAX: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_8BPP_CMY332_MASK: u32 = 4278190080u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_ADDITIVE_PRIMS: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_DO_DEVCLR_XFORM: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_HAS_BLACK_DYE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_ABSORPTION_IDX0: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_ABSORPTION_IDX1: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_ABSORPTION_IDX2: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_ABSORPTION_IDX3: u32 = 96u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_ABSORPTION_INDICES: u32 = 96u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INK_HIGH_ABSORPTION: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_INVERT_8BPP_BITMASK_IDX: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_LOWER_INK_ABSORPTION: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_LOWEST_INK_ABSORPTION: u32 = 96u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_LOW_INK_ABSORPTION: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_NORMAL_INK_ABSORPTION: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_OUTPUT_CMY: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_PRINT_DRAFT_MODE: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_SQUARE_DEVICE_PEL: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FLAG_USE_8BPP_BITMASK: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_16BPP: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_1BPP: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_24BPP: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_32BPP: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_4BPP: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_4BPP_IRGB: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_FORMAT_8BPP: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_10x10: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_10x10_M: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_12x12: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_12x12_M: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_14x14: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_14x14_M: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_16x16: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_16x16_M: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_2x2: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_2x2_M: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_4x4: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_4x4_M: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_6x6: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_6x6_M: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_8x8: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_8x8_M: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_DEFAULT: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_MAX_INDEX: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_SUPERCELL: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_SUPERCELL_M: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_PATSIZE_USER: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_USERPAT_CX_MAX: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_USERPAT_CX_MIN: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_USERPAT_CY_MAX: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const HT_USERPAT_CY_MIN: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HUMPD(pub isize);
impl ::std::default::Default for HUMPD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HUMPD {}
unsafe impl ::windows::runtime::Abi for HUMPD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IGP_ID(pub u32);
pub const IGP_GETIMEVERSION: IGP_ID = IGP_ID(4294967292u32);
pub const IGP_PROPERTY: IGP_ID = IGP_ID(4u32);
pub const IGP_CONVERSION: IGP_ID = IGP_ID(8u32);
pub const IGP_SENTENCE: IGP_ID = IGP_ID(12u32);
pub const IGP_UI: IGP_ID = IGP_ID(16u32);
pub const IGP_SETCOMPSTR: IGP_ID = IGP_ID(20u32);
pub const IGP_SELECT: IGP_ID = IGP_ID(24u32);
impl ::std::convert::From<u32> for IGP_ID {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IGP_ID {
    type Abi = Self;
}
impl ::std::ops::BitOr for IGP_ID {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IGP_ID {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IGP_ID {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IGP_ID {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IGP_ID {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IGRF_RGB_256BYTES: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IGRF_RGB_256WORDS: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(4))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {
    pub BeginAddress: u64,
    pub EndAddress: u64,
    pub ExceptionHandler: u64,
    pub HandlerData: u64,
    pub PrologEndAddress: u64,
}
impl IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    pub BeginAddress: u32,
    pub EndAddress: u32,
    pub ExceptionHandler: u32,
    pub HandlerData: u32,
    pub PrologEndAddress: u32,
}
impl IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY").field("BeginAddress", &self.BeginAddress).field("EndAddress", &self.EndAddress).field("ExceptionHandler", &self.ExceptionHandler).field("HandlerData", &self.HandlerData).field("PrologEndAddress", &self.PrologEndAddress).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.BeginAddress == other.BeginAddress && self.EndAddress == other.EndAddress && self.ExceptionHandler == other.ExceptionHandler && self.HandlerData == other.HandlerData && self.PrologEndAddress == other.PrologEndAddress
    }
}
impl ::std::cmp::Eq for IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARCHITECTURE_ENTRY {
    pub FixupInstRVA: u32,
    pub NewInst: u32,
}
impl IMAGE_ARCHITECTURE_ENTRY {}
impl ::std::default::Default for IMAGE_ARCHITECTURE_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARCHITECTURE_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ARCHITECTURE_ENTRY").field("FixupInstRVA", &self.FixupInstRVA).field("NewInst", &self.NewInst).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARCHITECTURE_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.FixupInstRVA == other.FixupInstRVA && self.NewInst == other.NewInst
    }
}
impl ::std::cmp::Eq for IMAGE_ARCHITECTURE_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARCHITECTURE_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARCHITECTURE_HEADER {
    pub _bitfield: u32,
    pub FirstEntryRVA: u32,
}
impl IMAGE_ARCHITECTURE_HEADER {}
impl ::std::default::Default for IMAGE_ARCHITECTURE_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARCHITECTURE_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ARCHITECTURE_HEADER").field("_bitfield", &self._bitfield).field("FirstEntryRVA", &self.FirstEntryRVA).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARCHITECTURE_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield && self.FirstEntryRVA == other.FirstEntryRVA
    }
}
impl ::std::cmp::Eq for IMAGE_ARCHITECTURE_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARCHITECTURE_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARCHIVE_MEMBER_HEADER {
    pub Name: [u8; 16],
    pub Date: [u8; 12],
    pub UserID: [u8; 6],
    pub GroupID: [u8; 6],
    pub Mode: [u8; 8],
    pub Size: [u8; 10],
    pub EndHeader: [u8; 2],
}
impl IMAGE_ARCHIVE_MEMBER_HEADER {}
impl ::std::default::Default for IMAGE_ARCHIVE_MEMBER_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARCHIVE_MEMBER_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ARCHIVE_MEMBER_HEADER").field("Name", &self.Name).field("Date", &self.Date).field("UserID", &self.UserID).field("GroupID", &self.GroupID).field("Mode", &self.Mode).field("Size", &self.Size).field("EndHeader", &self.EndHeader).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARCHIVE_MEMBER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.Date == other.Date && self.UserID == other.UserID && self.GroupID == other.GroupID && self.Mode == other.Mode && self.Size == other.Size && self.EndHeader == other.EndHeader
    }
}
impl ::std::cmp::Eq for IMAGE_ARCHIVE_MEMBER_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARCHIVE_MEMBER_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ARCHIVE_START_SIZE: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {
    pub BeginAddress: u32,
    pub Anonymous: IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0,
}
impl IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {
    pub UnwindData: u32,
    pub Anonymous: IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0,
}
impl IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {}
impl ::std::default::Default for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {}
impl ::std::default::Default for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {
    pub HeaderData: u32,
    pub Anonymous: IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0,
}
impl IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {}
impl ::std::default::Default for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {
    pub _bitfield: u32,
}
impl IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {}
impl ::std::default::Default for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY_XDATA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {
    pub BeginAddress: u32,
    pub Anonymous: IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0,
}
impl IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {
    pub UnwindData: u32,
    pub Anonymous: IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0,
}
impl IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {}
impl ::std::default::Default for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {}
impl ::std::default::Default for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_ARM_RUNTIME_FUNCTION_ENTRY_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_AUX_SYMBOL {
    pub Sym: IMAGE_AUX_SYMBOL_3,
    pub File: IMAGE_AUX_SYMBOL_1,
    pub Section: IMAGE_AUX_SYMBOL_2,
    pub TokenDef: IMAGE_AUX_SYMBOL_TOKEN_DEF,
    pub CRC: IMAGE_AUX_SYMBOL_0,
}
impl IMAGE_AUX_SYMBOL {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_0 {
    pub crc: u32,
    pub rgbReserved: [u8; 14],
}
impl IMAGE_AUX_SYMBOL_0 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_1 {
    pub Name: [u8; 18],
}
impl IMAGE_AUX_SYMBOL_1 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_AUX_SYMBOL_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_File_e__Struct").field("Name", &self.Name).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_1 {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_1 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_2 {
    pub Length: u32,
    pub NumberOfRelocations: u16,
    pub NumberOfLinenumbers: u16,
    pub CheckSum: u32,
    pub Number: i16,
    pub Selection: u8,
    pub bReserved: u8,
    pub HighNumber: i16,
}
impl IMAGE_AUX_SYMBOL_2 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_2 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_3 {
    pub TagIndex: u32,
    pub Misc: IMAGE_AUX_SYMBOL_3_1,
    pub FcnAry: IMAGE_AUX_SYMBOL_3_0,
    pub TvIndex: u16,
}
impl IMAGE_AUX_SYMBOL_3 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_AUX_SYMBOL_3_0 {
    pub Function: IMAGE_AUX_SYMBOL_3_0_1,
    pub Array: IMAGE_AUX_SYMBOL_3_0_0,
}
impl IMAGE_AUX_SYMBOL_3_0 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_3_0_0 {
    pub Dimension: [u16; 4],
}
impl IMAGE_AUX_SYMBOL_3_0_0 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_AUX_SYMBOL_3_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Array_e__Struct").field("Dimension", &self.Dimension).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Dimension == other.Dimension
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_3_0_1 {
    pub PointerToLinenumber: u32,
    pub PointerToNextFunction: u32,
}
impl IMAGE_AUX_SYMBOL_3_0_1 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3_0_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3_0_1 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3_0_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_AUX_SYMBOL_3_1 {
    pub LnSz: IMAGE_AUX_SYMBOL_3_1_0,
    pub TotalSize: u32,
}
impl IMAGE_AUX_SYMBOL_3_1 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3_1 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_3_1_0 {
    pub Linenumber: u16,
    pub Size: u16,
}
impl IMAGE_AUX_SYMBOL_3_1_0 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_3_1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_AUX_SYMBOL_3_1_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_LnSz_e__Struct").field("Linenumber", &self.Linenumber).field("Size", &self.Size).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_3_1_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Linenumber == other.Linenumber && self.Size == other.Size
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_3_1_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_3_1_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_AUX_SYMBOL_EX {
    pub Sym: IMAGE_AUX_SYMBOL_EX_4,
    pub File: IMAGE_AUX_SYMBOL_EX_2,
    pub Section: IMAGE_AUX_SYMBOL_EX_3,
    pub Anonymous: IMAGE_AUX_SYMBOL_EX_0,
    pub CRC: IMAGE_AUX_SYMBOL_EX_1,
}
impl IMAGE_AUX_SYMBOL_EX {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_EX_0 {
    pub TokenDef: IMAGE_AUX_SYMBOL_TOKEN_DEF,
    pub rgbReserved: [u8; 2],
}
impl IMAGE_AUX_SYMBOL_EX_0 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_EX_1 {
    pub crc: u32,
    pub rgbReserved: [u8; 16],
}
impl IMAGE_AUX_SYMBOL_EX_1 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX_1 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_EX_2 {
    pub Name: [u8; 20],
}
impl IMAGE_AUX_SYMBOL_EX_2 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_AUX_SYMBOL_EX_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_File_e__Struct").field("Name", &self.Name).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX_2 {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX_2 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_EX_3 {
    pub Length: u32,
    pub NumberOfRelocations: u16,
    pub NumberOfLinenumbers: u16,
    pub CheckSum: u32,
    pub Number: i16,
    pub Selection: u8,
    pub bReserved: u8,
    pub HighNumber: i16,
    pub rgbReserved: [u8; 2],
}
impl IMAGE_AUX_SYMBOL_EX_3 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX_3 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX_3 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX_3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_EX_4 {
    pub WeakDefaultSymIndex: u32,
    pub WeakSearchType: u32,
    pub rgbReserved: [u8; 12],
}
impl IMAGE_AUX_SYMBOL_EX_4 {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_EX_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_EX_4 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_EX_4 {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_EX_4 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_AUX_SYMBOL_TOKEN_DEF {
    pub bAuxType: u8,
    pub bReserved: u8,
    pub SymbolTableIndex: u32,
    pub rgbReserved: [u8; 12],
}
impl IMAGE_AUX_SYMBOL_TOKEN_DEF {}
impl ::std::default::Default for IMAGE_AUX_SYMBOL_TOKEN_DEF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_AUX_SYMBOL_TOKEN_DEF {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_AUX_SYMBOL_TOKEN_DEF {}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_TOKEN_DEF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IMAGE_AUX_SYMBOL_TYPE(pub i32);
pub const IMAGE_AUX_SYMBOL_TYPE_TOKEN_DEF: IMAGE_AUX_SYMBOL_TYPE = IMAGE_AUX_SYMBOL_TYPE(1i32);
impl ::std::convert::From<i32> for IMAGE_AUX_SYMBOL_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMAGE_AUX_SYMBOL_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_BASE_RELOCATION {
    pub VirtualAddress: u32,
    pub SizeOfBlock: u32,
}
impl IMAGE_BASE_RELOCATION {}
impl ::std::default::Default for IMAGE_BASE_RELOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_BASE_RELOCATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_BASE_RELOCATION").field("VirtualAddress", &self.VirtualAddress).field("SizeOfBlock", &self.SizeOfBlock).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_BASE_RELOCATION {
    fn eq(&self, other: &Self) -> bool {
        self.VirtualAddress == other.VirtualAddress && self.SizeOfBlock == other.SizeOfBlock
    }
}
impl ::std::cmp::Eq for IMAGE_BASE_RELOCATION {}
unsafe impl ::windows::runtime::Abi for IMAGE_BASE_RELOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_BOUND_FORWARDER_REF {
    pub TimeDateStamp: u32,
    pub OffsetModuleName: u16,
    pub Reserved: u16,
}
impl IMAGE_BOUND_FORWARDER_REF {}
impl ::std::default::Default for IMAGE_BOUND_FORWARDER_REF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_BOUND_FORWARDER_REF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_BOUND_FORWARDER_REF").field("TimeDateStamp", &self.TimeDateStamp).field("OffsetModuleName", &self.OffsetModuleName).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_BOUND_FORWARDER_REF {
    fn eq(&self, other: &Self) -> bool {
        self.TimeDateStamp == other.TimeDateStamp && self.OffsetModuleName == other.OffsetModuleName && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for IMAGE_BOUND_FORWARDER_REF {}
unsafe impl ::windows::runtime::Abi for IMAGE_BOUND_FORWARDER_REF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_BOUND_IMPORT_DESCRIPTOR {
    pub TimeDateStamp: u32,
    pub OffsetModuleName: u16,
    pub NumberOfModuleForwarderRefs: u16,
}
impl IMAGE_BOUND_IMPORT_DESCRIPTOR {}
impl ::std::default::Default for IMAGE_BOUND_IMPORT_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_BOUND_IMPORT_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_BOUND_IMPORT_DESCRIPTOR").field("TimeDateStamp", &self.TimeDateStamp).field("OffsetModuleName", &self.OffsetModuleName).field("NumberOfModuleForwarderRefs", &self.NumberOfModuleForwarderRefs).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_BOUND_IMPORT_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.TimeDateStamp == other.TimeDateStamp && self.OffsetModuleName == other.OffsetModuleName && self.NumberOfModuleForwarderRefs == other.NumberOfModuleForwarderRefs
    }
}
impl ::std::cmp::Eq for IMAGE_BOUND_IMPORT_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for IMAGE_BOUND_IMPORT_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    pub FuncStart: u32,
    pub _bitfield: u32,
}
impl IMAGE_CE_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_CE_RUNTIME_FUNCTION_ENTRY").field("FuncStart", &self.FuncStart).field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.FuncStart == other.FuncStart && self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_CE_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_ANY: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_ASSOCIATIVE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_EXACT_MATCH: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_LARGEST: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_NEWEST: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_NODUPLICATES: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_COMDAT_SELECT_SAME_SIZE: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Diagnostics_Debug`*"]
pub struct IMAGE_COR20_HEADER {
    pub cb: u32,
    pub MajorRuntimeVersion: u16,
    pub MinorRuntimeVersion: u16,
    pub MetaData: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub Flags: u32,
    pub Anonymous: IMAGE_COR20_HEADER_0,
    pub Resources: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub StrongNameSignature: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub CodeManagerTable: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub VTableFixups: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub ExportAddressTableJumps: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
    pub ManagedNativeHeader: super::Diagnostics::Debug::IMAGE_DATA_DIRECTORY,
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl IMAGE_COR20_HEADER {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::default::Default for IMAGE_COR20_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::PartialEq for IMAGE_COR20_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::Eq for IMAGE_COR20_HEADER {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
unsafe impl ::windows::runtime::Abi for IMAGE_COR20_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
pub union IMAGE_COR20_HEADER_0 {
    pub EntryPointToken: u32,
    pub EntryPointRVA: u32,
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl IMAGE_COR20_HEADER_0 {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::default::Default for IMAGE_COR20_HEADER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::PartialEq for IMAGE_COR20_HEADER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::Eq for IMAGE_COR20_HEADER_0 {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
unsafe impl ::windows::runtime::Abi for IMAGE_COR20_HEADER_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_DEBUG_MISC {
    pub DataType: u32,
    pub Length: u32,
    pub Unicode: super::super::Foundation::BOOLEAN,
    pub Reserved: [u8; 3],
    pub Data: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_DEBUG_MISC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_DEBUG_MISC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMAGE_DEBUG_MISC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_DEBUG_MISC").field("DataType", &self.DataType).field("Length", &self.Length).field("Unicode", &self.Unicode).field("Reserved", &self.Reserved).field("Data", &self.Data).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_DEBUG_MISC {
    fn eq(&self, other: &Self) -> bool {
        self.DataType == other.DataType && self.Length == other.Length && self.Unicode == other.Unicode && self.Reserved == other.Reserved && self.Data == other.Data
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_DEBUG_MISC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_DEBUG_MISC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_MISC_EXENAME: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_CLSID: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_EX_DLLCHARACTERISTICS: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_ILTCG: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_MPX: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_OMAP_FROM_SRC: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_OMAP_TO_SRC: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_POGO: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_REPRO: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_RESERVED10: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DEBUG_TYPE_VC_FEATURE: u32 = 12u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DELAYLOAD_DESCRIPTOR {
    pub Attributes: IMAGE_DELAYLOAD_DESCRIPTOR_0,
    pub DllNameRVA: u32,
    pub ModuleHandleRVA: u32,
    pub ImportAddressTableRVA: u32,
    pub ImportNameTableRVA: u32,
    pub BoundImportAddressTableRVA: u32,
    pub UnloadInformationTableRVA: u32,
    pub TimeDateStamp: u32,
}
impl IMAGE_DELAYLOAD_DESCRIPTOR {}
impl ::std::default::Default for IMAGE_DELAYLOAD_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DELAYLOAD_DESCRIPTOR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DELAYLOAD_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for IMAGE_DELAYLOAD_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_DELAYLOAD_DESCRIPTOR_0 {
    pub AllAttributes: u32,
    pub Anonymous: IMAGE_DELAYLOAD_DESCRIPTOR_0_0,
}
impl IMAGE_DELAYLOAD_DESCRIPTOR_0 {}
impl ::std::default::Default for IMAGE_DELAYLOAD_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DELAYLOAD_DESCRIPTOR_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DELAYLOAD_DESCRIPTOR_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DELAYLOAD_DESCRIPTOR_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {}
impl ::std::default::Default for IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DELAYLOAD_DESCRIPTOR_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DOS_HEADER {
    pub e_magic: u16,
    pub e_cblp: u16,
    pub e_cp: u16,
    pub e_crlc: u16,
    pub e_cparhdr: u16,
    pub e_minalloc: u16,
    pub e_maxalloc: u16,
    pub e_ss: u16,
    pub e_sp: u16,
    pub e_csum: u16,
    pub e_ip: u16,
    pub e_cs: u16,
    pub e_lfarlc: u16,
    pub e_ovno: u16,
    pub e_res: [u16; 4],
    pub e_oemid: u16,
    pub e_oeminfo: u16,
    pub e_res2: [u16; 10],
    pub e_lfanew: i32,
}
impl IMAGE_DOS_HEADER {}
impl ::std::default::Default for IMAGE_DOS_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DOS_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DOS_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_DOS_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DOS_SIGNATURE: u32 = 23117u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DYNAMIC_RELOCATION32 {
    pub Symbol: u32,
    pub BaseRelocSize: u32,
}
impl IMAGE_DYNAMIC_RELOCATION32 {}
impl ::std::default::Default for IMAGE_DYNAMIC_RELOCATION32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DYNAMIC_RELOCATION32 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DYNAMIC_RELOCATION32 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DYNAMIC_RELOCATION32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DYNAMIC_RELOCATION32_V2 {
    pub HeaderSize: u32,
    pub FixupInfoSize: u32,
    pub Symbol: u32,
    pub SymbolGroup: u32,
    pub Flags: u32,
}
impl IMAGE_DYNAMIC_RELOCATION32_V2 {}
impl ::std::default::Default for IMAGE_DYNAMIC_RELOCATION32_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DYNAMIC_RELOCATION32_V2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DYNAMIC_RELOCATION32_V2 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DYNAMIC_RELOCATION32_V2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DYNAMIC_RELOCATION64 {
    pub Symbol: u64,
    pub BaseRelocSize: u32,
}
impl IMAGE_DYNAMIC_RELOCATION64 {}
impl ::std::default::Default for IMAGE_DYNAMIC_RELOCATION64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DYNAMIC_RELOCATION64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DYNAMIC_RELOCATION64 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DYNAMIC_RELOCATION64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DYNAMIC_RELOCATION64_V2 {
    pub HeaderSize: u32,
    pub FixupInfoSize: u32,
    pub Symbol: u64,
    pub SymbolGroup: u32,
    pub Flags: u32,
}
impl IMAGE_DYNAMIC_RELOCATION64_V2 {}
impl ::std::default::Default for IMAGE_DYNAMIC_RELOCATION64_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_DYNAMIC_RELOCATION64_V2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_DYNAMIC_RELOCATION64_V2 {}
unsafe impl ::windows::runtime::Abi for IMAGE_DYNAMIC_RELOCATION64_V2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DYNAMIC_RELOCATION_GUARD_IMPORT_CONTROL_TRANSFER: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DYNAMIC_RELOCATION_GUARD_INDIR_CONTROL_TRANSFER: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DYNAMIC_RELOCATION_GUARD_RF_EPILOGUE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DYNAMIC_RELOCATION_GUARD_RF_PROLOGUE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_DYNAMIC_RELOCATION_GUARD_SWITCHTABLE_BRANCH: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_DYNAMIC_RELOCATION_TABLE {
    pub Version: u32,
    pub Size: u32,
}
impl IMAGE_DYNAMIC_RELOCATION_TABLE {}
impl ::std::default::Default for IMAGE_DYNAMIC_RELOCATION_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_DYNAMIC_RELOCATION_TABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_DYNAMIC_RELOCATION_TABLE").field("Version", &self.Version).field("Size", &self.Size).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_DYNAMIC_RELOCATION_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Size == other.Size
    }
}
impl ::std::cmp::Eq for IMAGE_DYNAMIC_RELOCATION_TABLE {}
unsafe impl ::windows::runtime::Abi for IMAGE_DYNAMIC_RELOCATION_TABLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_FLAG_PRIMARY_IMAGE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_IMPORT_MATCH_AUTHOR_ID: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_IMPORT_MATCH_FAMILY_ID: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_IMPORT_MATCH_IMAGE_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_IMPORT_MATCH_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_IMPORT_MATCH_UNIQUE_ID: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_LONG_ID_LENGTH: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_POLICY_DEBUGGABLE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ENCLAVE_SHORT_ID_LENGTH: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {
    pub EpilogueCount: u32,
    pub EpilogueByteCount: u8,
    pub BranchDescriptorElementSize: u8,
    pub BranchDescriptorCount: u16,
}
impl IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {}
impl ::std::default::Default for IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_EPILOGUE_DYNAMIC_RELOCATION_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_EXPORT_DIRECTORY {
    pub Characteristics: u32,
    pub TimeDateStamp: u32,
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub Name: u32,
    pub Base: u32,
    pub NumberOfFunctions: u32,
    pub NumberOfNames: u32,
    pub AddressOfFunctions: u32,
    pub AddressOfNames: u32,
    pub AddressOfNameOrdinals: u32,
}
impl IMAGE_EXPORT_DIRECTORY {}
impl ::std::default::Default for IMAGE_EXPORT_DIRECTORY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_EXPORT_DIRECTORY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_EXPORT_DIRECTORY")
            .field("Characteristics", &self.Characteristics)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("MajorVersion", &self.MajorVersion)
            .field("MinorVersion", &self.MinorVersion)
            .field("Name", &self.Name)
            .field("Base", &self.Base)
            .field("NumberOfFunctions", &self.NumberOfFunctions)
            .field("NumberOfNames", &self.NumberOfNames)
            .field("AddressOfFunctions", &self.AddressOfFunctions)
            .field("AddressOfNames", &self.AddressOfNames)
            .field("AddressOfNameOrdinals", &self.AddressOfNameOrdinals)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_EXPORT_DIRECTORY {
    fn eq(&self, other: &Self) -> bool {
        self.Characteristics == other.Characteristics && self.TimeDateStamp == other.TimeDateStamp && self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion && self.Name == other.Name && self.Base == other.Base && self.NumberOfFunctions == other.NumberOfFunctions && self.NumberOfNames == other.NumberOfNames && self.AddressOfFunctions == other.AddressOfFunctions && self.AddressOfNames == other.AddressOfNames && self.AddressOfNameOrdinals == other.AddressOfNameOrdinals
    }
}
impl ::std::cmp::Eq for IMAGE_EXPORT_DIRECTORY {}
unsafe impl ::windows::runtime::Abi for IMAGE_EXPORT_DIRECTORY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CFW_INSTRUMENTED: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_ENABLE_EXPORT_SUPPRESSION: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_EXPORT_SUPPRESSION_INFO_PRESENT: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_FUNCTION_TABLE_PRESENT: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK: u32 = 4026531840u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_SHIFT: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_INSTRUMENTED: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_CF_LONGJUMP_TABLE_PRESENT: u32 = 65536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_DELAYLOAD_IAT_IN_ITS_OWN_SECTION: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_EH_CONTINUATION_TABLE_PRESENT: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_FLAG_EXPORT_SUPPRESSED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_FLAG_FID_LANGEXCPTHANDLER: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_FLAG_FID_SUPPRESSED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_FLAG_FID_XFG: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_PROTECT_DELAYLOAD_IAT: u32 = 4096u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_RETPOLINE_PRESENT: u32 = 1048576u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_RF_ENABLE: u32 = 262144u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_RF_INSTRUMENTED: u32 = 131072u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_RF_STRICT: u32 = 524288u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_SECURITY_COOKIE_UNUSED: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_GUARD_XFG_ENABLED: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_ABSOLUTE: u32 = 180224u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_HOT_PATCH_BASE {
    pub SequenceNumber: u32,
    pub Flags: u32,
    pub OriginalTimeDateStamp: u32,
    pub OriginalCheckSum: u32,
    pub CodeIntegrityInfo: u32,
    pub CodeIntegritySize: u32,
    pub PatchTable: u32,
    pub BufferOffset: u32,
}
impl IMAGE_HOT_PATCH_BASE {}
impl ::std::default::Default for IMAGE_HOT_PATCH_BASE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_HOT_PATCH_BASE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_HOT_PATCH_BASE")
            .field("SequenceNumber", &self.SequenceNumber)
            .field("Flags", &self.Flags)
            .field("OriginalTimeDateStamp", &self.OriginalTimeDateStamp)
            .field("OriginalCheckSum", &self.OriginalCheckSum)
            .field("CodeIntegrityInfo", &self.CodeIntegrityInfo)
            .field("CodeIntegritySize", &self.CodeIntegritySize)
            .field("PatchTable", &self.PatchTable)
            .field("BufferOffset", &self.BufferOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_HOT_PATCH_BASE {
    fn eq(&self, other: &Self) -> bool {
        self.SequenceNumber == other.SequenceNumber && self.Flags == other.Flags && self.OriginalTimeDateStamp == other.OriginalTimeDateStamp && self.OriginalCheckSum == other.OriginalCheckSum && self.CodeIntegrityInfo == other.CodeIntegrityInfo && self.CodeIntegritySize == other.CodeIntegritySize && self.PatchTable == other.PatchTable && self.BufferOffset == other.BufferOffset
    }
}
impl ::std::cmp::Eq for IMAGE_HOT_PATCH_BASE {}
unsafe impl ::windows::runtime::Abi for IMAGE_HOT_PATCH_BASE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_BASE_CAN_ROLL_BACK: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_BASE_OBLIGATORY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CALL_TARGET: u32 = 278528u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_INVERSE: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_OBLIGATORY: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_RESERVED: u32 = 1072705536u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_SIZE: u32 = 4095u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_SOURCE_RVA: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_TARGET_RVA: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_CHUNK_TYPE: u32 = 1032192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_DYNAMIC_VALUE: u32 = 491520u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_FUNCTION: u32 = 114688u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_HOT_PATCH_HASHES {
    pub SHA256: [u8; 32],
    pub SHA1: [u8; 20],
}
impl IMAGE_HOT_PATCH_HASHES {}
impl ::std::default::Default for IMAGE_HOT_PATCH_HASHES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_HOT_PATCH_HASHES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_HOT_PATCH_HASHES").field("SHA256", &self.SHA256).field("SHA1", &self.SHA1).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_HOT_PATCH_HASHES {
    fn eq(&self, other: &Self) -> bool {
        self.SHA256 == other.SHA256 && self.SHA1 == other.SHA1
    }
}
impl ::std::cmp::Eq for IMAGE_HOT_PATCH_HASHES {}
unsafe impl ::windows::runtime::Abi for IMAGE_HOT_PATCH_HASHES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_INDIRECT: u32 = 376832u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_HOT_PATCH_INFO {
    pub Version: u32,
    pub Size: u32,
    pub SequenceNumber: u32,
    pub BaseImageList: u32,
    pub BaseImageCount: u32,
    pub BufferOffset: u32,
    pub ExtraPatchSize: u32,
}
impl IMAGE_HOT_PATCH_INFO {}
impl ::std::default::Default for IMAGE_HOT_PATCH_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_HOT_PATCH_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_HOT_PATCH_INFO")
            .field("Version", &self.Version)
            .field("Size", &self.Size)
            .field("SequenceNumber", &self.SequenceNumber)
            .field("BaseImageList", &self.BaseImageList)
            .field("BaseImageCount", &self.BaseImageCount)
            .field("BufferOffset", &self.BufferOffset)
            .field("ExtraPatchSize", &self.ExtraPatchSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_HOT_PATCH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Size == other.Size && self.SequenceNumber == other.SequenceNumber && self.BaseImageList == other.BaseImageList && self.BaseImageCount == other.BaseImageCount && self.BufferOffset == other.BufferOffset && self.ExtraPatchSize == other.ExtraPatchSize
    }
}
impl ::std::cmp::Eq for IMAGE_HOT_PATCH_INFO {}
unsafe impl ::windows::runtime::Abi for IMAGE_HOT_PATCH_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_NO_CALL_TARGET: u32 = 409600u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_HOT_PATCH_REL32: u32 = 245760u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_IMPORT_BY_NAME {
    pub Hint: u16,
    pub Name: [super::super::Foundation::CHAR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_IMPORT_BY_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_IMPORT_BY_NAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMAGE_IMPORT_BY_NAME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_IMPORT_BY_NAME").field("Hint", &self.Hint).field("Name", &self.Name).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_IMPORT_BY_NAME {
    fn eq(&self, other: &Self) -> bool {
        self.Hint == other.Hint && self.Name == other.Name
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_IMPORT_BY_NAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_IMPORT_BY_NAME {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    pub _bitfield: u32,
}
impl IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {}
impl ::std::default::Default for IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {}
unsafe impl ::windows::runtime::Abi for IMAGE_IMPORT_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_IMPORT_DESCRIPTOR {
    pub Anonymous: IMAGE_IMPORT_DESCRIPTOR_0,
    pub TimeDateStamp: u32,
    pub ForwarderChain: u32,
    pub Name: u32,
    pub FirstThunk: u32,
}
impl IMAGE_IMPORT_DESCRIPTOR {}
impl ::std::default::Default for IMAGE_IMPORT_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_IMPORT_DESCRIPTOR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_IMPORT_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for IMAGE_IMPORT_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_IMPORT_DESCRIPTOR_0 {
    pub Characteristics: u32,
    pub OriginalFirstThunk: u32,
}
impl IMAGE_IMPORT_DESCRIPTOR_0 {}
impl ::std::default::Default for IMAGE_IMPORT_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_IMPORT_DESCRIPTOR_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_IMPORT_DESCRIPTOR_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_IMPORT_DESCRIPTOR_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    pub _bitfield: u16,
}
impl IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {}
impl ::std::default::Default for IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {}
unsafe impl ::windows::runtime::Abi for IMAGE_INDIR_CONTROL_TRANSFER_DYNAMIC_RELOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_LINENUMBER {
    pub Type: IMAGE_LINENUMBER_0,
    pub Linenumber: u16,
}
impl IMAGE_LINENUMBER {}
impl ::std::default::Default for IMAGE_LINENUMBER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_LINENUMBER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_LINENUMBER {}
unsafe impl ::windows::runtime::Abi for IMAGE_LINENUMBER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_LINENUMBER_0 {
    pub SymbolTableIndex: u32,
    pub VirtualAddress: u32,
}
impl IMAGE_LINENUMBER_0 {}
impl ::std::default::Default for IMAGE_LINENUMBER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_LINENUMBER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_LINENUMBER_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_LINENUMBER_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_LOAD_CONFIG_CODE_INTEGRITY {
    pub Flags: u16,
    pub Catalog: u16,
    pub CatalogOffset: u32,
    pub Reserved: u32,
}
impl IMAGE_LOAD_CONFIG_CODE_INTEGRITY {}
impl ::std::default::Default for IMAGE_LOAD_CONFIG_CODE_INTEGRITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_LOAD_CONFIG_CODE_INTEGRITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_LOAD_CONFIG_CODE_INTEGRITY").field("Flags", &self.Flags).field("Catalog", &self.Catalog).field("CatalogOffset", &self.CatalogOffset).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_LOAD_CONFIG_CODE_INTEGRITY {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags && self.Catalog == other.Catalog && self.CatalogOffset == other.CatalogOffset && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for IMAGE_LOAD_CONFIG_CODE_INTEGRITY {}
unsafe impl ::windows::runtime::Abi for IMAGE_LOAD_CONFIG_CODE_INTEGRITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_NT_SIGNATURE: u32 = 17744u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_NUMBEROF_DIRECTORY_ENTRIES: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ORDINAL_FLAG: u64 = 9223372036854775808u64;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ORDINAL_FLAG32: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_ORDINAL_FLAG64: u64 = 9223372036854775808u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_OS2_HEADER {
    pub ne_magic: u16,
    pub ne_ver: super::super::Foundation::CHAR,
    pub ne_rev: super::super::Foundation::CHAR,
    pub ne_enttab: u16,
    pub ne_cbenttab: u16,
    pub ne_crc: i32,
    pub ne_flags: u16,
    pub ne_autodata: u16,
    pub ne_heap: u16,
    pub ne_stack: u16,
    pub ne_csip: i32,
    pub ne_sssp: i32,
    pub ne_cseg: u16,
    pub ne_cmod: u16,
    pub ne_cbnrestab: u16,
    pub ne_segtab: u16,
    pub ne_rsrctab: u16,
    pub ne_restab: u16,
    pub ne_modtab: u16,
    pub ne_imptab: u16,
    pub ne_nrestab: i32,
    pub ne_cmovent: u16,
    pub ne_align: u16,
    pub ne_cres: u16,
    pub ne_exetyp: u8,
    pub ne_flagsothers: u8,
    pub ne_pretthunks: u16,
    pub ne_psegrefbytes: u16,
    pub ne_swaparea: u16,
    pub ne_expver: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_OS2_HEADER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_OS2_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_OS2_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_OS2_HEADER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_OS2_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_OS2_SIGNATURE: u32 = 17742u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_OS2_SIGNATURE_LE: u32 = 17740u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_POLICY_ENTRY {
    pub Type: IMAGE_POLICY_ENTRY_TYPE,
    pub PolicyId: IMAGE_POLICY_ID,
    pub u: IMAGE_POLICY_ENTRY_0,
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_POLICY_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_POLICY_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_POLICY_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_POLICY_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_POLICY_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union IMAGE_POLICY_ENTRY_0 {
    pub None: *mut ::std::ffi::c_void,
    pub BoolValue: super::super::Foundation::BOOLEAN,
    pub Int8Value: i8,
    pub UInt8Value: u8,
    pub Int16Value: i16,
    pub UInt16Value: u16,
    pub Int32Value: i32,
    pub UInt32Value: u32,
    pub Int64Value: i64,
    pub UInt64Value: u64,
    pub AnsiStringValue: super::super::Foundation::PSTR,
    pub UnicodeStringValue: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_POLICY_ENTRY_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_POLICY_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_POLICY_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_POLICY_ENTRY_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_POLICY_ENTRY_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IMAGE_POLICY_ENTRY_TYPE(pub i32);
pub const ImagePolicyEntryTypeNone: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(0i32);
pub const ImagePolicyEntryTypeBool: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(1i32);
pub const ImagePolicyEntryTypeInt8: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(2i32);
pub const ImagePolicyEntryTypeUInt8: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(3i32);
pub const ImagePolicyEntryTypeInt16: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(4i32);
pub const ImagePolicyEntryTypeUInt16: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(5i32);
pub const ImagePolicyEntryTypeInt32: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(6i32);
pub const ImagePolicyEntryTypeUInt32: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(7i32);
pub const ImagePolicyEntryTypeInt64: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(8i32);
pub const ImagePolicyEntryTypeUInt64: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(9i32);
pub const ImagePolicyEntryTypeAnsiString: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(10i32);
pub const ImagePolicyEntryTypeUnicodeString: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(11i32);
pub const ImagePolicyEntryTypeOverride: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(12i32);
pub const ImagePolicyEntryTypeMaximum: IMAGE_POLICY_ENTRY_TYPE = IMAGE_POLICY_ENTRY_TYPE(13i32);
impl ::std::convert::From<i32> for IMAGE_POLICY_ENTRY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMAGE_POLICY_ENTRY_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IMAGE_POLICY_ID(pub i32);
pub const ImagePolicyIdNone: IMAGE_POLICY_ID = IMAGE_POLICY_ID(0i32);
pub const ImagePolicyIdEtw: IMAGE_POLICY_ID = IMAGE_POLICY_ID(1i32);
pub const ImagePolicyIdDebug: IMAGE_POLICY_ID = IMAGE_POLICY_ID(2i32);
pub const ImagePolicyIdCrashDump: IMAGE_POLICY_ID = IMAGE_POLICY_ID(3i32);
pub const ImagePolicyIdCrashDumpKey: IMAGE_POLICY_ID = IMAGE_POLICY_ID(4i32);
pub const ImagePolicyIdCrashDumpKeyGuid: IMAGE_POLICY_ID = IMAGE_POLICY_ID(5i32);
pub const ImagePolicyIdParentSd: IMAGE_POLICY_ID = IMAGE_POLICY_ID(6i32);
pub const ImagePolicyIdParentSdRev: IMAGE_POLICY_ID = IMAGE_POLICY_ID(7i32);
pub const ImagePolicyIdSvn: IMAGE_POLICY_ID = IMAGE_POLICY_ID(8i32);
pub const ImagePolicyIdDeviceId: IMAGE_POLICY_ID = IMAGE_POLICY_ID(9i32);
pub const ImagePolicyIdCapability: IMAGE_POLICY_ID = IMAGE_POLICY_ID(10i32);
pub const ImagePolicyIdScenarioId: IMAGE_POLICY_ID = IMAGE_POLICY_ID(11i32);
pub const ImagePolicyIdMaximum: IMAGE_POLICY_ID = IMAGE_POLICY_ID(12i32);
impl ::std::convert::From<i32> for IMAGE_POLICY_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMAGE_POLICY_ID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_POLICY_METADATA {
    pub Version: u8,
    pub Reserved0: [u8; 7],
    pub ApplicationId: u64,
    pub Policies: [IMAGE_POLICY_ENTRY; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_POLICY_METADATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_POLICY_METADATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_POLICY_METADATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_POLICY_METADATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_POLICY_METADATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_POLICY_METADATA_VERSION: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {
    pub PrologueByteCount: u8,
}
impl IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {}
impl ::std::default::Default for IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER").field("PrologueByteCount", &self.PrologueByteCount).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.PrologueByteCount == other.PrologueByteCount
    }
}
impl ::std::cmp::Eq for IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_PROLOGUE_DYNAMIC_RELOCATION_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RELOCATION {
    pub Anonymous: IMAGE_RELOCATION_0,
    pub SymbolTableIndex: u32,
    pub Type: u16,
}
impl IMAGE_RELOCATION {}
impl ::std::default::Default for IMAGE_RELOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RELOCATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RELOCATION {}
unsafe impl ::windows::runtime::Abi for IMAGE_RELOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_RELOCATION_0 {
    pub VirtualAddress: u32,
    pub RelocCount: u32,
}
impl IMAGE_RELOCATION_0 {}
impl ::std::default::Default for IMAGE_RELOCATION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RELOCATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RELOCATION_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RELOCATION_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_BRADDR: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_GPDISP: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_GPREL32: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_GPRELHI: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_GPRELLO: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_HINT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_INLINE_REFLONG: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_LITERAL: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_LITUSE: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_MATCH: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_PAIR: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFHI: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFLO: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFLONG: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFLONGNB: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFQ1: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFQ2: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFQ3: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_REFQUAD: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_SECREL: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_SECRELHI: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_SECRELLO: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ALPHA_SECTION: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_ADDR32: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_ADDR32NB: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_ADDR64: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_CFG_BR: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_CFG_BR_REX: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_CFG_CALL: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_EHANDLER: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_IMPORT_BR: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_IMPORT_CALL: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_INDIR_BR: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_INDIR_BR_REX: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_INDIR_BR_SWITCHTABLE_FIRST: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_INDIR_BR_SWITCHTABLE_LAST: u32 = 47u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_INDIR_CALL: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_PAIR: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32_1: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32_2: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32_3: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32_4: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_REL32_5: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_SECREL: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_SECREL7: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_SECTION: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_SREL32: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_SSPAN32: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AMD64_TOKEN: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_ADDR32NB: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_CALL32: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_FUNCINFO: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_REL32_1: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_REL32_2: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_SECREL: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_SECTION: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_AM_TOKEN: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_ADDR32NB: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_ADDR64: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_BRANCH19: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_BRANCH26: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_PAGEBASE_REL21: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_PAGEOFFSET_12A: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_PAGEOFFSET_12L: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_REL21: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_SECREL: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_SECREL_HIGH12A: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_SECREL_LOW12A: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_SECREL_LOW12L: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_SECTION: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM64_TOKEN: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_ADDR32NB: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BLX11: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BLX23T: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BLX24: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BRANCH11: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BRANCH20T: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BRANCH24: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_BRANCH24T: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_GPREL12: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_GPREL7: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_MOV32: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_MOV32A: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_MOV32T: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_SECREL: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_SECTION: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_ARM_TOKEN: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_ARM_MOV32: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_DIR64: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_HIGH: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_HIGHADJ: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_HIGHLOW: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_IA64_IMM64: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_LOW: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MACHINE_SPECIFIC_5: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MACHINE_SPECIFIC_7: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MACHINE_SPECIFIC_8: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MACHINE_SPECIFIC_9: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MIPS_JMPADDR: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_MIPS_JMPADDR16: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_RESERVED: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_BASED_THUMB_MOV32: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_ADDR32NB: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_ADDR64: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_SECREL: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_SECTION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEE_TOKEN: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_ADDR32NB: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_ADDR64: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_SECREL: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_SECTION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_CEF_TOKEN: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_EBC_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_EBC_ADDR32NB: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_EBC_REL32: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_EBC_SECREL: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_EBC_SECTION: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_DIR16: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_DIR32: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_DIR32NB: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_REL16: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_REL32: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_SECREL: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_SECREL7: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_SECTION: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_SEG12: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_I386_TOKEN: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_ADDEND: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_DIR32: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_DIR32NB: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_DIR64: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_GPREL22: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_GPREL32: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_IMM14: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_IMM22: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_IMM64: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_IMMGPREL64: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_LTOFF22: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL21B: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL21F: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL21M: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL60B: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL60F: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL60I: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL60M: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_PCREL60X: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SECREL22: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SECREL32: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SECREL64I: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SECTION: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SREL14: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SREL22: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_SREL32: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_TOKEN: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_IA64_UREL32: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_ADDR24: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_ADDR32: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_ADDR32NB: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_GPREL16: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_PAIR: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_PCREL16: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_PCREL24: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_PCREL8: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_REFHALF: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_REFHI: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_REFLO: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_SECREL32: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_SECTION: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_M32R_TOKEN: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_GPREL: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_JMPADDR: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_JMPADDR16: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_LITERAL: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_PAIR: u32 = 37u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_REFHALF: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_REFHI: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_REFLO: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_REFWORD: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_REFWORDNB: u32 = 34u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_SECREL: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_SECRELHI: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_SECRELLO: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_SECTION: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_MIPS_TOKEN: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR14: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR16: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR24: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR32: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR32NB: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_ADDR64: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_BRNTAKEN: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_BRTAKEN: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_GPREL: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_IFGLUE: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_IMGLUE: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_NEG: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_PAIR: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_REFHI: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_REFLO: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_REL14: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_REL24: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_SECREL: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_SECREL16: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_SECRELHI: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_SECRELLO: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_SECTION: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_TOCDEFN: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_TOCREL14: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_TOCREL16: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_TOKEN: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_PPC_TYPEMASK: u32 = 255u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_ABSOLUTE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT16: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT32: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT32_NB: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT4: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT4_LONG: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT4_WORD: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT8: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT8_LONG: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_DIRECT8_WORD: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_GPREL4_LONG: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_PCREL12_WORD: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_PCREL8_LONG: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_PCREL8_WORD: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_SECREL: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_SECTION: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_SIZEOF_SECTION: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_STARTOF_SECTION: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH3_TOKEN: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_PAIR: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_PCRELPT: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_REFHALF: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_REFLO: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_RELHALF: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SHM_RELLO: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_SH_NOMODE: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_THUMB_BLX23: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_THUMB_BRANCH20: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_THUMB_BRANCH24: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_REL_THUMB_MOV32: u32 = 17u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DATA_ENTRY {
    pub OffsetToData: u32,
    pub Size: u32,
    pub CodePage: u32,
    pub Reserved: u32,
}
impl IMAGE_RESOURCE_DATA_ENTRY {}
impl ::std::default::Default for IMAGE_RESOURCE_DATA_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_RESOURCE_DATA_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_RESOURCE_DATA_ENTRY").field("OffsetToData", &self.OffsetToData).field("Size", &self.Size).field("CodePage", &self.CodePage).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DATA_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.OffsetToData == other.OffsetToData && self.Size == other.Size && self.CodePage == other.CodePage && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DATA_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DATA_ENTRY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_RESOURCE_DATA_IS_DIRECTORY: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DIRECTORY {
    pub Characteristics: u32,
    pub TimeDateStamp: u32,
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub NumberOfNamedEntries: u16,
    pub NumberOfIdEntries: u16,
}
impl IMAGE_RESOURCE_DIRECTORY {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_RESOURCE_DIRECTORY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_RESOURCE_DIRECTORY")
            .field("Characteristics", &self.Characteristics)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("MajorVersion", &self.MajorVersion)
            .field("MinorVersion", &self.MinorVersion)
            .field("NumberOfNamedEntries", &self.NumberOfNamedEntries)
            .field("NumberOfIdEntries", &self.NumberOfIdEntries)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY {
    fn eq(&self, other: &Self) -> bool {
        self.Characteristics == other.Characteristics && self.TimeDateStamp == other.TimeDateStamp && self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion && self.NumberOfNamedEntries == other.NumberOfNamedEntries && self.NumberOfIdEntries == other.NumberOfIdEntries
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DIRECTORY_ENTRY {
    pub Anonymous1: IMAGE_RESOURCE_DIRECTORY_ENTRY_0,
    pub Anonymous2: IMAGE_RESOURCE_DIRECTORY_ENTRY_1,
}
impl IMAGE_RESOURCE_DIRECTORY_ENTRY {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {
    pub Anonymous: IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0,
    pub Name: u32,
    pub Id: u16,
}
impl IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_ENTRY_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_ENTRY_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {
    pub OffsetToData: u32,
    pub Anonymous: IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0,
}
impl IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_ENTRY_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {
    pub _bitfield: u32,
}
impl IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {}
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_ENTRY_1_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct IMAGE_RESOURCE_DIRECTORY_STRING {
    pub Length: u16,
    pub NameString: [super::super::Foundation::CHAR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMAGE_RESOURCE_DIRECTORY_STRING {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMAGE_RESOURCE_DIRECTORY_STRING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMAGE_RESOURCE_DIRECTORY_STRING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_RESOURCE_DIRECTORY_STRING").field("Length", &self.Length).field("NameString", &self.NameString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIRECTORY_STRING {
    fn eq(&self, other: &Self) -> bool {
        self.Length == other.Length && self.NameString == other.NameString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIRECTORY_STRING {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIRECTORY_STRING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RESOURCE_DIR_STRING_U {
    pub Length: u16,
    pub NameString: [u16; 1],
}
impl IMAGE_RESOURCE_DIR_STRING_U {}
impl ::std::default::Default for IMAGE_RESOURCE_DIR_STRING_U {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_RESOURCE_DIR_STRING_U {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_RESOURCE_DIR_STRING_U").field("Length", &self.Length).field("NameString", &self.NameString).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_RESOURCE_DIR_STRING_U {
    fn eq(&self, other: &Self) -> bool {
        self.Length == other.Length && self.NameString == other.NameString
    }
}
impl ::std::cmp::Eq for IMAGE_RESOURCE_DIR_STRING_U {}
unsafe impl ::windows::runtime::Abi for IMAGE_RESOURCE_DIR_STRING_U {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_RESOURCE_NAME_IS_STRING: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Diagnostics_Debug`*"]
pub struct IMAGE_ROM_HEADERS {
    pub FileHeader: super::Diagnostics::Debug::IMAGE_FILE_HEADER,
    pub OptionalHeader: IMAGE_ROM_OPTIONAL_HEADER,
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl IMAGE_ROM_HEADERS {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::default::Default for IMAGE_ROM_HEADERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::fmt::Debug for IMAGE_ROM_HEADERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ROM_HEADERS").field("FileHeader", &self.FileHeader).field("OptionalHeader", &self.OptionalHeader).finish()
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::PartialEq for IMAGE_ROM_HEADERS {
    fn eq(&self, other: &Self) -> bool {
        self.FileHeader == other.FileHeader && self.OptionalHeader == other.OptionalHeader
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::std::cmp::Eq for IMAGE_ROM_HEADERS {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
unsafe impl ::windows::runtime::Abi for IMAGE_ROM_HEADERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_ROM_OPTIONAL_HEADER {
    pub Magic: u16,
    pub MajorLinkerVersion: u8,
    pub MinorLinkerVersion: u8,
    pub SizeOfCode: u32,
    pub SizeOfInitializedData: u32,
    pub SizeOfUninitializedData: u32,
    pub AddressOfEntryPoint: u32,
    pub BaseOfCode: u32,
    pub BaseOfData: u32,
    pub BaseOfBss: u32,
    pub GprMask: u32,
    pub CprMask: [u32; 4],
    pub GpValue: u32,
}
impl IMAGE_ROM_OPTIONAL_HEADER {}
impl ::std::default::Default for IMAGE_ROM_OPTIONAL_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_ROM_OPTIONAL_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_ROM_OPTIONAL_HEADER")
            .field("Magic", &self.Magic)
            .field("MajorLinkerVersion", &self.MajorLinkerVersion)
            .field("MinorLinkerVersion", &self.MinorLinkerVersion)
            .field("SizeOfCode", &self.SizeOfCode)
            .field("SizeOfInitializedData", &self.SizeOfInitializedData)
            .field("SizeOfUninitializedData", &self.SizeOfUninitializedData)
            .field("AddressOfEntryPoint", &self.AddressOfEntryPoint)
            .field("BaseOfCode", &self.BaseOfCode)
            .field("BaseOfData", &self.BaseOfData)
            .field("BaseOfBss", &self.BaseOfBss)
            .field("GprMask", &self.GprMask)
            .field("CprMask", &self.CprMask)
            .field("GpValue", &self.GpValue)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_ROM_OPTIONAL_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Magic == other.Magic
            && self.MajorLinkerVersion == other.MajorLinkerVersion
            && self.MinorLinkerVersion == other.MinorLinkerVersion
            && self.SizeOfCode == other.SizeOfCode
            && self.SizeOfInitializedData == other.SizeOfInitializedData
            && self.SizeOfUninitializedData == other.SizeOfUninitializedData
            && self.AddressOfEntryPoint == other.AddressOfEntryPoint
            && self.BaseOfCode == other.BaseOfCode
            && self.BaseOfData == other.BaseOfData
            && self.BaseOfBss == other.BaseOfBss
            && self.GprMask == other.GprMask
            && self.CprMask == other.CprMask
            && self.GpValue == other.GpValue
    }
}
impl ::std::cmp::Eq for IMAGE_ROM_OPTIONAL_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_ROM_OPTIONAL_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_RUNTIME_FUNCTION_ENTRY {
    pub BeginAddress: u32,
    pub EndAddress: u32,
    pub Anonymous: IMAGE_RUNTIME_FUNCTION_ENTRY_0,
}
impl IMAGE_RUNTIME_FUNCTION_ENTRY {}
impl ::std::default::Default for IMAGE_RUNTIME_FUNCTION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RUNTIME_FUNCTION_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RUNTIME_FUNCTION_ENTRY {}
unsafe impl ::windows::runtime::Abi for IMAGE_RUNTIME_FUNCTION_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_RUNTIME_FUNCTION_ENTRY_0 {
    pub UnwindInfoAddress: u32,
    pub UnwindData: u32,
}
impl IMAGE_RUNTIME_FUNCTION_ENTRY_0 {}
impl ::std::default::Default for IMAGE_RUNTIME_FUNCTION_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_RUNTIME_FUNCTION_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_RUNTIME_FUNCTION_ENTRY_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_RUNTIME_FUNCTION_ENTRY_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SEPARATE_DEBUG_FLAGS_MASK: u32 = 32768u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SEPARATE_DEBUG_HEADER {
    pub Signature: u16,
    pub Flags: u16,
    pub Machine: u16,
    pub Characteristics: u16,
    pub TimeDateStamp: u32,
    pub CheckSum: u32,
    pub ImageBase: u32,
    pub SizeOfImage: u32,
    pub NumberOfSections: u32,
    pub ExportedNamesSize: u32,
    pub DebugDirectorySize: u32,
    pub SectionAlignment: u32,
    pub Reserved: [u32; 2],
}
impl IMAGE_SEPARATE_DEBUG_HEADER {}
impl ::std::default::Default for IMAGE_SEPARATE_DEBUG_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_SEPARATE_DEBUG_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMAGE_SEPARATE_DEBUG_HEADER")
            .field("Signature", &self.Signature)
            .field("Flags", &self.Flags)
            .field("Machine", &self.Machine)
            .field("Characteristics", &self.Characteristics)
            .field("TimeDateStamp", &self.TimeDateStamp)
            .field("CheckSum", &self.CheckSum)
            .field("ImageBase", &self.ImageBase)
            .field("SizeOfImage", &self.SizeOfImage)
            .field("NumberOfSections", &self.NumberOfSections)
            .field("ExportedNamesSize", &self.ExportedNamesSize)
            .field("DebugDirectorySize", &self.DebugDirectorySize)
            .field("SectionAlignment", &self.SectionAlignment)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_SEPARATE_DEBUG_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Signature == other.Signature
            && self.Flags == other.Flags
            && self.Machine == other.Machine
            && self.Characteristics == other.Characteristics
            && self.TimeDateStamp == other.TimeDateStamp
            && self.CheckSum == other.CheckSum
            && self.ImageBase == other.ImageBase
            && self.SizeOfImage == other.SizeOfImage
            && self.NumberOfSections == other.NumberOfSections
            && self.ExportedNamesSize == other.ExportedNamesSize
            && self.DebugDirectorySize == other.DebugDirectorySize
            && self.SectionAlignment == other.SectionAlignment
            && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for IMAGE_SEPARATE_DEBUG_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_SEPARATE_DEBUG_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SEPARATE_DEBUG_MISMATCH: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SEPARATE_DEBUG_SIGNATURE: u32 = 18756u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR: u32 = 60u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SIZEOF_FILE_HEADER: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SIZEOF_SECTION_HEADER: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SIZEOF_SHORT_NAME: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SIZEOF_SYMBOL: u32 = 18u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {
    pub _bitfield: u16,
}
impl IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {}
impl ::std::default::Default for IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {}
unsafe impl ::windows::runtime::Abi for IMAGE_SWITCHTABLE_BRANCH_DYNAMIC_RELOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SYMBOL {
    pub N: IMAGE_SYMBOL_0,
    pub Value: u32,
    pub SectionNumber: i16,
    pub Type: u16,
    pub StorageClass: u8,
    pub NumberOfAuxSymbols: u8,
}
impl IMAGE_SYMBOL {}
impl ::std::default::Default for IMAGE_SYMBOL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_SYMBOL_0 {
    pub ShortName: [u8; 8],
    pub Name: IMAGE_SYMBOL_0_0,
    pub LongName: [u32; 2],
}
impl IMAGE_SYMBOL_0 {}
impl ::std::default::Default for IMAGE_SYMBOL_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SYMBOL_0_0 {
    pub Short: u32,
    pub Long: u32,
}
impl IMAGE_SYMBOL_0_0 {}
impl ::std::default::Default for IMAGE_SYMBOL_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL_0_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SYMBOL_EX {
    pub N: IMAGE_SYMBOL_EX_0,
    pub Value: u32,
    pub SectionNumber: i32,
    pub Type: u16,
    pub StorageClass: u8,
    pub NumberOfAuxSymbols: u8,
}
impl IMAGE_SYMBOL_EX {}
impl ::std::default::Default for IMAGE_SYMBOL_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL_EX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL_EX {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL_EX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_SYMBOL_EX_0 {
    pub ShortName: [u8; 8],
    pub Name: IMAGE_SYMBOL_EX_0_0,
    pub LongName: [u32; 2],
}
impl IMAGE_SYMBOL_EX_0 {}
impl ::std::default::Default for IMAGE_SYMBOL_EX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL_EX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL_EX_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL_EX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_SYMBOL_EX_0_0 {
    pub Short: u32,
    pub Long: u32,
}
impl IMAGE_SYMBOL_EX_0_0 {}
impl ::std::default::Default for IMAGE_SYMBOL_EX_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_SYMBOL_EX_0_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_SYMBOL_EX_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_SYMBOL_EX_0_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_ARGUMENT: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_AUTOMATIC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_BIT_FIELD: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_BLOCK: u32 = 100u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_CLR_TOKEN: u32 = 107u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_END_OF_STRUCT: u32 = 102u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_ENUM_TAG: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_EXTERNAL: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_EXTERNAL_DEF: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_FAR_EXTERNAL: u32 = 68u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_FILE: u32 = 103u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_FUNCTION: u32 = 101u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_LABEL: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_MEMBER_OF_ENUM: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_MEMBER_OF_STRUCT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_MEMBER_OF_UNION: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_NULL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_REGISTER: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_REGISTER_PARAM: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_SECTION: u32 = 104u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_STATIC: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_STRUCT_TAG: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_TYPE_DEFINITION: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_UNDEFINED_LABEL: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_UNDEFINED_STATIC: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_UNION_TAG: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_CLASS_WEAK_EXTERNAL: u32 = 105u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_DTYPE_ARRAY: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_DTYPE_FUNCTION: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_DTYPE_NULL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_DTYPE_POINTER: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_SECTION_MAX: u32 = 65279u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_SECTION_MAX_EX: u32 = 2147483647u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_BYTE: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_CHAR: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_DOUBLE: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_DWORD: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_ENUM: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_FLOAT: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_INT: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_LONG: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_MOE: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_NULL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_PCODE: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_SHORT: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_STRUCT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_UINT: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_UNION: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_VOID: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_SYM_TYPE_WORD: u32 = 13u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_THUNK_DATA32 {
    pub u1: IMAGE_THUNK_DATA32_0,
}
impl IMAGE_THUNK_DATA32 {}
impl ::std::default::Default for IMAGE_THUNK_DATA32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_THUNK_DATA32 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_THUNK_DATA32 {}
unsafe impl ::windows::runtime::Abi for IMAGE_THUNK_DATA32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_THUNK_DATA32_0 {
    pub ForwarderString: u32,
    pub Function: u32,
    pub Ordinal: u32,
    pub AddressOfData: u32,
}
impl IMAGE_THUNK_DATA32_0 {}
impl ::std::default::Default for IMAGE_THUNK_DATA32_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_THUNK_DATA32_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_THUNK_DATA32_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_THUNK_DATA32_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_THUNK_DATA64 {
    pub u1: IMAGE_THUNK_DATA64_0,
}
impl IMAGE_THUNK_DATA64 {}
impl ::std::default::Default for IMAGE_THUNK_DATA64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_THUNK_DATA64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_THUNK_DATA64 {}
unsafe impl ::windows::runtime::Abi for IMAGE_THUNK_DATA64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_THUNK_DATA64_0 {
    pub ForwarderString: u64,
    pub Function: u64,
    pub Ordinal: u64,
    pub AddressOfData: u64,
}
impl IMAGE_THUNK_DATA64_0 {}
impl ::std::default::Default for IMAGE_THUNK_DATA64_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_THUNK_DATA64_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_THUNK_DATA64_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_THUNK_DATA64_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_TLS_DIRECTORY32 {
    pub StartAddressOfRawData: u32,
    pub EndAddressOfRawData: u32,
    pub AddressOfIndex: u32,
    pub AddressOfCallBacks: u32,
    pub SizeOfZeroFill: u32,
    pub Anonymous: IMAGE_TLS_DIRECTORY32_0,
}
impl IMAGE_TLS_DIRECTORY32 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY32 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY32 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_TLS_DIRECTORY32_0 {
    pub Characteristics: u32,
    pub Anonymous: IMAGE_TLS_DIRECTORY32_0_0,
}
impl IMAGE_TLS_DIRECTORY32_0 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY32_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY32_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY32_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY32_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_TLS_DIRECTORY32_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_TLS_DIRECTORY32_0_0 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY32_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_TLS_DIRECTORY32_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY32_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY32_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY32_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(4))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_TLS_DIRECTORY64 {
    pub StartAddressOfRawData: u64,
    pub EndAddressOfRawData: u64,
    pub AddressOfIndex: u64,
    pub AddressOfCallBacks: u64,
    pub SizeOfZeroFill: u32,
    pub Anonymous: IMAGE_TLS_DIRECTORY64_0,
}
impl IMAGE_TLS_DIRECTORY64 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY64 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMAGE_TLS_DIRECTORY64_0 {
    pub Characteristics: u32,
    pub Anonymous: IMAGE_TLS_DIRECTORY64_0_0,
}
impl IMAGE_TLS_DIRECTORY64_0 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY64_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY64_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY64_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY64_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_TLS_DIRECTORY64_0_0 {
    pub _bitfield: u32,
}
impl IMAGE_TLS_DIRECTORY64_0_0 {}
impl ::std::default::Default for IMAGE_TLS_DIRECTORY64_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMAGE_TLS_DIRECTORY64_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for IMAGE_TLS_DIRECTORY64_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for IMAGE_TLS_DIRECTORY64_0_0 {}
unsafe impl ::windows::runtime::Abi for IMAGE_TLS_DIRECTORY64_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMAGE_VXD_HEADER {
    pub e32_magic: u16,
    pub e32_border: u8,
    pub e32_worder: u8,
    pub e32_level: u32,
    pub e32_cpu: u16,
    pub e32_os: u16,
    pub e32_ver: u32,
    pub e32_mflags: u32,
    pub e32_mpages: u32,
    pub e32_startobj: u32,
    pub e32_eip: u32,
    pub e32_stackobj: u32,
    pub e32_esp: u32,
    pub e32_pagesize: u32,
    pub e32_lastpagesize: u32,
    pub e32_fixupsize: u32,
    pub e32_fixupsum: u32,
    pub e32_ldrsize: u32,
    pub e32_ldrsum: u32,
    pub e32_objtab: u32,
    pub e32_objcnt: u32,
    pub e32_objmap: u32,
    pub e32_itermap: u32,
    pub e32_rsrctab: u32,
    pub e32_rsrccnt: u32,
    pub e32_restab: u32,
    pub e32_enttab: u32,
    pub e32_dirtab: u32,
    pub e32_dircnt: u32,
    pub e32_fpagetab: u32,
    pub e32_frectab: u32,
    pub e32_impmod: u32,
    pub e32_impmodcnt: u32,
    pub e32_impproc: u32,
    pub e32_pagesum: u32,
    pub e32_datapage: u32,
    pub e32_preload: u32,
    pub e32_nrestab: u32,
    pub e32_cbnrestab: u32,
    pub e32_nressum: u32,
    pub e32_autodata: u32,
    pub e32_debuginfo: u32,
    pub e32_debuglen: u32,
    pub e32_instpreload: u32,
    pub e32_instdemand: u32,
    pub e32_heapsize: u32,
    pub e32_res3: [u8; 12],
    pub e32_winresoff: u32,
    pub e32_winreslen: u32,
    pub e32_devid: u16,
    pub e32_ddkver: u16,
}
impl IMAGE_VXD_HEADER {}
impl ::std::default::Default for IMAGE_VXD_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMAGE_VXD_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMAGE_VXD_HEADER {}
unsafe impl ::windows::runtime::Abi for IMAGE_VXD_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_VXD_SIGNATURE: u32 = 17740u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_WEAK_EXTERN_ANTI_DEPENDENCY: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_WEAK_EXTERN_SEARCH_ALIAS: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_WEAK_EXTERN_SEARCH_LIBRARY: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IMPORT_OBJECT_HDR_SIG2: u32 = 65535u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IMPORT_OBJECT_HEADER {
    pub Sig1: u16,
    pub Sig2: u16,
    pub Version: u16,
    pub Machine: u16,
    pub TimeDateStamp: u32,
    pub SizeOfData: u32,
    pub Anonymous: IMPORT_OBJECT_HEADER_0,
    pub _bitfield: u16,
}
impl IMPORT_OBJECT_HEADER {}
impl ::std::default::Default for IMPORT_OBJECT_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMPORT_OBJECT_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMPORT_OBJECT_HEADER {}
unsafe impl ::windows::runtime::Abi for IMPORT_OBJECT_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union IMPORT_OBJECT_HEADER_0 {
    pub Ordinal: u16,
    pub Hint: u16,
}
impl IMPORT_OBJECT_HEADER_0 {}
impl ::std::default::Default for IMPORT_OBJECT_HEADER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMPORT_OBJECT_HEADER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMPORT_OBJECT_HEADER_0 {}
unsafe impl ::windows::runtime::Abi for IMPORT_OBJECT_HEADER_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IMPORT_OBJECT_NAME_TYPE(pub i32);
pub const IMPORT_OBJECT_ORDINAL: IMPORT_OBJECT_NAME_TYPE = IMPORT_OBJECT_NAME_TYPE(0i32);
pub const IMPORT_OBJECT_NAME: IMPORT_OBJECT_NAME_TYPE = IMPORT_OBJECT_NAME_TYPE(1i32);
pub const IMPORT_OBJECT_NAME_NO_PREFIX: IMPORT_OBJECT_NAME_TYPE = IMPORT_OBJECT_NAME_TYPE(2i32);
pub const IMPORT_OBJECT_NAME_UNDECORATE: IMPORT_OBJECT_NAME_TYPE = IMPORT_OBJECT_NAME_TYPE(3i32);
pub const IMPORT_OBJECT_NAME_EXPORTAS: IMPORT_OBJECT_NAME_TYPE = IMPORT_OBJECT_NAME_TYPE(4i32);
impl ::std::convert::From<i32> for IMPORT_OBJECT_NAME_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMPORT_OBJECT_NAME_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IMPORT_OBJECT_TYPE(pub i32);
pub const IMPORT_OBJECT_CODE: IMPORT_OBJECT_TYPE = IMPORT_OBJECT_TYPE(0i32);
pub const IMPORT_OBJECT_DATA: IMPORT_OBJECT_TYPE = IMPORT_OBJECT_TYPE(1i32);
pub const IMPORT_OBJECT_CONST: IMPORT_OBJECT_TYPE = IMPORT_OBJECT_TYPE(2i32);
impl ::std::convert::From<i32> for IMPORT_OBJECT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMPORT_OBJECT_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvAccumulateD3DDirtyRect: i32 = 98i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvAlphaBlend: i32 = 71i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvAssertMode: i32 = 5i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvAssociateSharedSurface: i32 = 96i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvBitBlt: i32 = 18i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvCompletePDEV: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvCopyBits: i32 = 19i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvCreateDeviceBitmap: i32 = 10i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvCreateDeviceBitmapEx: i32 = 94i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDeleteDeviceBitmap: i32 = 11i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDeleteDeviceBitmapEx: i32 = 95i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDeriveSurface: i32 = 85i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDescribePixelFormat: i32 = 55i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDestroyFont: i32 = 43i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDisableDirectDraw: i32 = 61i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDisableDriver: i32 = 8i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDisablePDEV: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDisableSurface: i32 = 4i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDitherColor: i32 = 13i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvDrawEscape: i32 = 25i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEnableDirectDraw: i32 = 60i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEnablePDEV: i32 = 0i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEnableSurface: i32 = 3i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEndDoc: i32 = 34i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEndDxInterop: i32 = 100i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvEscape: i32 = 24i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvFillPath: i32 = 15i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvFontManagement: i32 = 47i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvFree: i32 = 42i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGetDirectDrawInfo: i32 = 59i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGetGlyphMode: i32 = 37i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGetModes: i32 = 41i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGetSynthesizedFontFiles: i32 = 73i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGetTrueTypeFile: i32 = 50i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvGradientFill: i32 = 68i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvIcmCheckBitmapBits: i32 = 66i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvIcmCreateColorTransform: i32 = 64i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvIcmDeleteColorTransform: i32 = 65i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvIcmSetDeviceGammaRamp: i32 = 67i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvLineTo: i32 = 31i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvLoadFontFile: i32 = 45i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvLockDisplayArea: i32 = 101i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvMovePanning: i32 = 52i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvMovePointer: i32 = 30i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvNextBand: i32 = 58i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvNotify: i32 = 87i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvOffset: i32 = 6i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvPaint: i32 = 17i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvPlgBlt: i32 = 70i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryAdvanceWidths: i32 = 53i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryDeviceSupport: i32 = 76i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryFont: i32 = 26i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryFontCaps: i32 = 44i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryFontData: i32 = 28i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryFontFile: i32 = 51i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryFontTree: i32 = 27i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryGlyphAttrs: i32 = 86i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryPerBandInfo: i32 = 75i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQuerySpoolType: i32 = 62i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryTrueTypeOutline: i32 = 49i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvQueryTrueTypeTable: i32 = 48i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvRealizeBrush: i32 = 12i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvRenderHint: i32 = 93i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved1: i32 = 77i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved10: i32 = 91i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved11: i32 = 92i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved2: i32 = 78i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved3: i32 = 79i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved4: i32 = 80i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved5: i32 = 81i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved6: i32 = 82i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved7: i32 = 83i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved8: i32 = 84i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvReserved9: i32 = 90i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvResetDevice: i32 = 89i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvResetPDEV: i32 = 7i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSaveScreenBits: i32 = 40i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSendPage: i32 = 32i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSetPalette: i32 = 22i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSetPixelFormat: i32 = 54i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSetPointerShape: i32 = 29i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStartBanding: i32 = 57i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStartDoc: i32 = 35i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStartDxInterop: i32 = 99i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStartPage: i32 = 33i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStretchBlt: i32 = 20i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStretchBltROP: i32 = 69i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStrokeAndFillPath: i32 = 16i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvStrokePath: i32 = 14i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSurfaceComplete: i32 = 103i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSwapBuffers: i32 = 56i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSynchronize: i32 = 38i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSynchronizeRedirectionBitmaps: i32 = 97i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSynchronizeSurface: i32 = 88i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvSynthesizeFont: i32 = 72i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvTextOut: i32 = 23i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvTransparentBlt: i32 = 74i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvUnloadFontFile: i32 = 46i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_DrvUnlockDisplayArea: i32 = 102i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INDEX_LAST: i32 = 89i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INITIAL_CPSR: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INITIAL_FPCSR: u32 = 639u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INITIAL_FPSCR: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const INITIAL_MXCSR: u32 = 8064u32;
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_BAD_BLOCK_WITH_NAME: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479649i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_CDROM_EXCLUSIVE_LOCK: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004101i32 as _);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_COMPLETION_MODIFY_STATE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct IO_COUNTERS {
    pub ReadOperationCount: u64,
    pub WriteOperationCount: u64,
    pub OtherOperationCount: u64,
    pub ReadTransferCount: u64,
    pub WriteTransferCount: u64,
    pub OtherTransferCount: u64,
}
impl IO_COUNTERS {}
impl ::std::default::Default for IO_COUNTERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IO_COUNTERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IO_COUNTERS")
            .field("ReadOperationCount", &self.ReadOperationCount)
            .field("WriteOperationCount", &self.WriteOperationCount)
            .field("OtherOperationCount", &self.OtherOperationCount)
            .field("ReadTransferCount", &self.ReadTransferCount)
            .field("WriteTransferCount", &self.WriteTransferCount)
            .field("OtherTransferCount", &self.OtherTransferCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IO_COUNTERS {
    fn eq(&self, other: &Self) -> bool {
        self.ReadOperationCount == other.ReadOperationCount && self.WriteOperationCount == other.WriteOperationCount && self.OtherOperationCount == other.OtherOperationCount && self.ReadTransferCount == other.ReadTransferCount && self.WriteTransferCount == other.WriteTransferCount && self.OtherTransferCount == other.OtherTransferCount
    }
}
impl ::std::cmp::Eq for IO_COUNTERS {}
unsafe impl ::windows::runtime::Abi for IO_COUNTERS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DRIVER_CANCEL_TIMEOUT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221450i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_CALLBACK_EXCEPTION: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479517i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_CREATION_SUCCESS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(262306i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_DIRECT_CONFIG_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479632i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_DRIVER_LOAD_FAILURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479635i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_DUMPFILE_CONFLICT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479633i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_INITIALIZATION_FAILURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479634i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_PAGE_CONFIG_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479631i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_DUMP_POINTER_FAILURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479636i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERROR_DISK_RESOURCES_EXHAUSTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479530i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERROR_DUMP_CREATION_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479519i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERROR_IO_HARDWARE_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479526i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_BAD_BLOCK: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479673i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_BAD_FIRMWARE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479655i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_CONFIGURATION_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479677i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_CONTROLLER_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479669i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_DMA_CONFLICT_DETECTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479657i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_DMA_RESOURCE_CONFLICT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479653i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_DRIVER_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479676i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INCORRECT_IRQL: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479667i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INSUFFICIENT_RESOURCES: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479678i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INTERNAL_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479668i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INTERRUPT_RESOURCE_CONFLICT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479652i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INVALID_IOBASE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479666i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_INVALID_REQUEST: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479664i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_IRQ_CONFLICT_DETECTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479656i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_LAYERED_FAILURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479662i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_MEMORY_CONFLICT_DETECTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479659i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_MEMORY_RESOURCE_CONFLICT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479651i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_NOT_READY: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479665i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_OVERRUN_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479672i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_PARITY: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479675i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_PORT_CONFLICT_DETECTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479658i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_PORT_RESOURCE_CONFLICT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479650i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_PORT_TIMEOUT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479563i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_PROTOCOL: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479660i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_RESET: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479661i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_RETRY_SUCCEEDED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(262145i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_SEEK_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479674i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_SEQUENCE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479670i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_THREAD_STUCK_IN_DEVICE_DRIVER: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479572i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_TIMEOUT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479671i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_ERR_VERSION: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479663i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_CORRUPT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479638i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221464i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_LIMIT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004005i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_STARTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004006i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_SUCCEEDED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004007i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_QUOTA_THRESHOLD: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004004i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_SYSTEM_CORRUPT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479639i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_FILE_SYSTEM_CORRUPT_WITH_NAME: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479625i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_INFO_THROTTLE_COMPLETE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004087i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_LOST_DELAYED_WRITE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221454i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_DISCONNECTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221365i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_LOCAL_DISK_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221363i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_SERVER_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221364i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_RECOVERED_VIA_ECC: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221471i32 as _);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_AF_UNIX: i32 = -2147483613i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_APPEXECLINK: i32 = -2147483621i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD: i32 = -1879048166i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_1: i32 = -1879044070i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_2: i32 = -1879039974i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_3: i32 = -1879035878i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_4: i32 = -1879031782i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_5: i32 = -1879027686i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_6: i32 = -1879023590i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_7: i32 = -1879019494i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_8: i32 = -1879015398i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_9: i32 = -1879011302i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_A: i32 = -1879007206i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_B: i32 = -1879003110i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_C: i32 = -1878999014i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_D: i32 = -1878994918i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_E: i32 = -1878990822i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_F: i32 = -1878986726i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CLOUD_MASK: i32 = 61440i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_CSV: i32 = -2147483639i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_DATALESS_CIM: i32 = -1610612696i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_DEDUP: i32 = -2147483629i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_DFS: i32 = -2147483638i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_DFSR: i32 = -2147483630i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_FILE_PLACEHOLDER: i32 = -2147483627i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_GLOBAL_REPARSE: i32 = -1610612711i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_HSM: i32 = -1073741820i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_HSM2: i32 = -2147483642i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_MOUNT_POINT: i32 = -1610612733i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_NFS: i32 = -2147483628i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_ONEDRIVE: i32 = -2147483615i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_PROJFS: i32 = -1879048164i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_PROJFS_TOMBSTONE: i32 = -1610612702i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_RESERVED_ONE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_RESERVED_RANGE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_RESERVED_TWO: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_RESERVED_ZERO: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_SIS: i32 = -2147483641i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_STORAGE_SYNC: i32 = -2147483618i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_SYMLINK: i32 = -1610612724i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_UNHANDLED: i32 = -2147483616i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WCI: i32 = -2147483624i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WCI_1: i32 = -1879044072i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WCI_LINK: i32 = -1610612697i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WCI_LINK_1: i32 = -1610608601i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WCI_TOMBSTONE: i32 = -1610612705i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WIM: i32 = -2147483640i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IO_REPARSE_TAG_WOF: i32 = -2147483625i32;
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_SYSTEM_SLEEP_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073479637i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_ADAPTER_FIRMWARE_UPDATED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004128i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_ALLOCATION_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221448i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_BUS_RESET: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221386i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_COMPLETION_TIME: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221349i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DEVICE_HAS_INTERNAL_DUMP: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221361i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DISK_CAPACITY_CHANGED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221353i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DISK_FIRMWARE_UPDATED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074004127i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DISK_PROVISIONING_TYPE_CHANGED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221352i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DISK_SURPRISE_REMOVED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221347i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DUMP_DISABLED_DEVICE_GONE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221348i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DUPLICATE_PATH: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221445i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_DUPLICATE_SIGNATURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221446i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_INTERRUPT_STILL_PENDING: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221451i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_IO_OPERATION_RETRIED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221351i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_LOG_FLUSH_FAILED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221447i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_PAGING_FAILURE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221453i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_REPEATED_DISK_GUID: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221346i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_RESET: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221375i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221360i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221359i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_LUN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221358i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_POOL: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221357i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_LUN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221356i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_POOL: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221355i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_VOLUME_LOST_DISK_EXTENT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221362i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WARNING_WRITE_FUA_PROBLEM: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221372i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WRITE_CACHE_DISABLED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221470i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WRITE_CACHE_ENABLED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221472i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WRN_BAD_FIRMWARE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221478i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const IO_WRN_FAILURE_PREDICTED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147221452i32 as _);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IS_TEXT_UNICODE_DBCS_LEADBYTE: u32 = 1024u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const IS_TEXT_UNICODE_UTF8: u32 = 2048u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Rpc`*"]
#[cfg(feature = "Win32_System_Rpc")]
#[inline]
pub unsafe fn I_RpcNsGetBuffer(message: *mut super::Rpc::RPC_MESSAGE) -> super::Rpc::RPC_STATUS {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn I_RpcNsGetBuffer(message: *mut super::Rpc::RPC_MESSAGE) -> super::Rpc::RPC_STATUS;
        }
        ::std::mem::transmute(I_RpcNsGetBuffer(::std::mem::transmute(message)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Rpc`*"]
#[cfg(feature = "Win32_System_Rpc")]
#[inline]
pub unsafe fn I_RpcNsRaiseException(message: *mut super::Rpc::RPC_MESSAGE, status: super::Rpc::RPC_STATUS) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn I_RpcNsRaiseException(message: *mut super::Rpc::RPC_MESSAGE, status: super::Rpc::RPC_STATUS);
        }
        ::std::mem::transmute(I_RpcNsRaiseException(::std::mem::transmute(message), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Rpc`*"]
#[cfg(feature = "Win32_System_Rpc")]
#[inline]
pub unsafe fn I_RpcNsSendReceive(message: *mut super::Rpc::RPC_MESSAGE, handle: *mut *mut ::std::ffi::c_void) -> super::Rpc::RPC_STATUS {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn I_RpcNsSendReceive(message: *mut super::Rpc::RPC_MESSAGE, handle: *mut *mut ::std::ffi::c_void) -> super::Rpc::RPC_STATUS;
        }
        ::std::mem::transmute(I_RpcNsSendReceive(::std::mem::transmute(message), ::std::mem::transmute(handle)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_Rpc`*"]
#[cfg(feature = "Win32_System_Rpc")]
#[inline]
pub unsafe fn I_RpcReBindBuffer(message: *mut super::Rpc::RPC_MESSAGE) -> super::Rpc::RPC_STATUS {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn I_RpcReBindBuffer(message: *mut super::Rpc::RPC_MESSAGE) -> super::Rpc::RPC_STATUS;
        }
        ::std::mem::transmute(I_RpcReBindBuffer(::std::mem::transmute(message)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOBOBJECTINFOCLASS(pub i32);
pub const JobObjectBasicAccountingInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(1i32);
pub const JobObjectBasicLimitInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(2i32);
pub const JobObjectBasicProcessIdList: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(3i32);
pub const JobObjectBasicUIRestrictions: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(4i32);
pub const JobObjectSecurityLimitInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(5i32);
pub const JobObjectEndOfJobTimeInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(6i32);
pub const JobObjectAssociateCompletionPortInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(7i32);
pub const JobObjectBasicAndIoAccountingInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(8i32);
pub const JobObjectExtendedLimitInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(9i32);
pub const JobObjectJobSetInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(10i32);
pub const JobObjectGroupInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(11i32);
pub const JobObjectNotificationLimitInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(12i32);
pub const JobObjectLimitViolationInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(13i32);
pub const JobObjectGroupInformationEx: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(14i32);
pub const JobObjectCpuRateControlInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(15i32);
pub const JobObjectCompletionFilter: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(16i32);
pub const JobObjectCompletionCounter: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(17i32);
pub const JobObjectReserved1Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(18i32);
pub const JobObjectReserved2Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(19i32);
pub const JobObjectReserved3Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(20i32);
pub const JobObjectReserved4Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(21i32);
pub const JobObjectReserved5Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(22i32);
pub const JobObjectReserved6Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(23i32);
pub const JobObjectReserved7Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(24i32);
pub const JobObjectReserved8Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(25i32);
pub const JobObjectReserved9Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(26i32);
pub const JobObjectReserved10Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(27i32);
pub const JobObjectReserved11Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(28i32);
pub const JobObjectReserved12Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(29i32);
pub const JobObjectReserved13Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(30i32);
pub const JobObjectReserved14Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(31i32);
pub const JobObjectNetRateControlInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(32i32);
pub const JobObjectNotificationLimitInformation2: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(33i32);
pub const JobObjectLimitViolationInformation2: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(34i32);
pub const JobObjectCreateSilo: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(35i32);
pub const JobObjectSiloBasicInformation: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(36i32);
pub const JobObjectReserved15Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(37i32);
pub const JobObjectReserved16Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(38i32);
pub const JobObjectReserved17Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(39i32);
pub const JobObjectReserved18Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(40i32);
pub const JobObjectReserved19Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(41i32);
pub const JobObjectReserved20Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(42i32);
pub const JobObjectReserved21Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(43i32);
pub const JobObjectReserved22Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(44i32);
pub const JobObjectReserved23Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(45i32);
pub const JobObjectReserved24Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(46i32);
pub const JobObjectReserved25Information: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(47i32);
pub const MaxJobObjectInfoClass: JOBOBJECTINFOCLASS = JOBOBJECTINFOCLASS(48i32);
impl ::std::convert::From<i32> for JOBOBJECTINFOCLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOBOBJECTINFOCLASS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    pub CompletionKey: *mut ::std::ffi::c_void,
    pub CompletionPort: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl JOBOBJECT_ASSOCIATE_COMPLETION_PORT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_ASSOCIATE_COMPLETION_PORT").field("CompletionKey", &self.CompletionKey).field("CompletionPort", &self.CompletionPort).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    fn eq(&self, other: &Self) -> bool {
        self.CompletionKey == other.CompletionKey && self.CompletionPort == other.CompletionPort
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for JOBOBJECT_ASSOCIATE_COMPLETION_PORT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    pub TotalUserTime: i64,
    pub TotalKernelTime: i64,
    pub ThisPeriodTotalUserTime: i64,
    pub ThisPeriodTotalKernelTime: i64,
    pub TotalPageFaultCount: u32,
    pub TotalProcesses: u32,
    pub ActiveProcesses: u32,
    pub TotalTerminatedProcesses: u32,
}
impl JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_BASIC_ACCOUNTING_INFORMATION")
            .field("TotalUserTime", &self.TotalUserTime)
            .field("TotalKernelTime", &self.TotalKernelTime)
            .field("ThisPeriodTotalUserTime", &self.ThisPeriodTotalUserTime)
            .field("ThisPeriodTotalKernelTime", &self.ThisPeriodTotalKernelTime)
            .field("TotalPageFaultCount", &self.TotalPageFaultCount)
            .field("TotalProcesses", &self.TotalProcesses)
            .field("ActiveProcesses", &self.ActiveProcesses)
            .field("TotalTerminatedProcesses", &self.TotalTerminatedProcesses)
            .finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.TotalUserTime == other.TotalUserTime && self.TotalKernelTime == other.TotalKernelTime && self.ThisPeriodTotalUserTime == other.ThisPeriodTotalUserTime && self.ThisPeriodTotalKernelTime == other.ThisPeriodTotalKernelTime && self.TotalPageFaultCount == other.TotalPageFaultCount && self.TotalProcesses == other.TotalProcesses && self.ActiveProcesses == other.ActiveProcesses && self.TotalTerminatedProcesses == other.TotalTerminatedProcesses
    }
}
impl ::std::cmp::Eq for JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    pub BasicInfo: JOBOBJECT_BASIC_ACCOUNTING_INFORMATION,
    pub IoInfo: IO_COUNTERS,
}
impl JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION").field("BasicInfo", &self.BasicInfo).field("IoInfo", &self.IoInfo).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.BasicInfo == other.BasicInfo && self.IoInfo == other.IoInfo
    }
}
impl ::std::cmp::Eq for JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_BASIC_LIMIT_INFORMATION {
    pub PerProcessUserTimeLimit: i64,
    pub PerJobUserTimeLimit: i64,
    pub LimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub MinimumWorkingSetSize: usize,
    pub MaximumWorkingSetSize: usize,
    pub ActiveProcessLimit: u32,
    pub Affinity: usize,
    pub PriorityClass: u32,
    pub SchedulingClass: u32,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_BASIC_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_BASIC_LIMIT_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::fmt::Debug for JOBOBJECT_BASIC_LIMIT_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_BASIC_LIMIT_INFORMATION")
            .field("PerProcessUserTimeLimit", &self.PerProcessUserTimeLimit)
            .field("PerJobUserTimeLimit", &self.PerJobUserTimeLimit)
            .field("LimitFlags", &self.LimitFlags)
            .field("MinimumWorkingSetSize", &self.MinimumWorkingSetSize)
            .field("MaximumWorkingSetSize", &self.MaximumWorkingSetSize)
            .field("ActiveProcessLimit", &self.ActiveProcessLimit)
            .field("Affinity", &self.Affinity)
            .field("PriorityClass", &self.PriorityClass)
            .field("SchedulingClass", &self.SchedulingClass)
            .finish()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_BASIC_LIMIT_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.PerProcessUserTimeLimit == other.PerProcessUserTimeLimit && self.PerJobUserTimeLimit == other.PerJobUserTimeLimit && self.LimitFlags == other.LimitFlags && self.MinimumWorkingSetSize == other.MinimumWorkingSetSize && self.MaximumWorkingSetSize == other.MaximumWorkingSetSize && self.ActiveProcessLimit == other.ActiveProcessLimit && self.Affinity == other.Affinity && self.PriorityClass == other.PriorityClass && self.SchedulingClass == other.SchedulingClass
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_BASIC_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_BASIC_LIMIT_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_BASIC_PROCESS_ID_LIST {
    pub NumberOfAssignedProcesses: u32,
    pub NumberOfProcessIdsInList: u32,
    pub ProcessIdList: [usize; 1],
}
impl JOBOBJECT_BASIC_PROCESS_ID_LIST {}
impl ::std::default::Default for JOBOBJECT_BASIC_PROCESS_ID_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_BASIC_PROCESS_ID_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_BASIC_PROCESS_ID_LIST").field("NumberOfAssignedProcesses", &self.NumberOfAssignedProcesses).field("NumberOfProcessIdsInList", &self.NumberOfProcessIdsInList).field("ProcessIdList", &self.ProcessIdList).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_BASIC_PROCESS_ID_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.NumberOfAssignedProcesses == other.NumberOfAssignedProcesses && self.NumberOfProcessIdsInList == other.NumberOfProcessIdsInList && self.ProcessIdList == other.ProcessIdList
    }
}
impl ::std::cmp::Eq for JOBOBJECT_BASIC_PROCESS_ID_LIST {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_BASIC_PROCESS_ID_LIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_BASIC_UI_RESTRICTIONS {
    pub UIRestrictionsClass: super::JobObjects::JOB_OBJECT_UILIMIT,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_BASIC_UI_RESTRICTIONS {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_BASIC_UI_RESTRICTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::fmt::Debug for JOBOBJECT_BASIC_UI_RESTRICTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_BASIC_UI_RESTRICTIONS").field("UIRestrictionsClass", &self.UIRestrictionsClass).finish()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_BASIC_UI_RESTRICTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.UIRestrictionsClass == other.UIRestrictionsClass
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_BASIC_UI_RESTRICTIONS {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_BASIC_UI_RESTRICTIONS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {
    pub ControlFlags: JOB_OBJECT_CPU_RATE_CONTROL,
    pub Anonymous: JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0,
}
impl JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {
    pub CpuRate: u32,
    pub Weight: u32,
    pub Anonymous: JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0,
}
impl JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {}
impl ::std::default::Default for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {
    pub MinRate: u16,
    pub MaxRate: u16,
}
impl JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {}
impl ::std::default::Default for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("MinRate", &self.MinRate).field("MaxRate", &self.MaxRate).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.MinRate == other.MinRate && self.MaxRate == other.MaxRate
    }
}
impl ::std::cmp::Eq for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_CPU_RATE_CONTROL_INFORMATION_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    pub EndOfJobTimeAction: JOB_OBJECT_TERMINATE_AT_END_ACTION,
}
impl JOBOBJECT_END_OF_JOB_TIME_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_END_OF_JOB_TIME_INFORMATION").field("EndOfJobTimeAction", &self.EndOfJobTimeAction).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.EndOfJobTimeAction == other.EndOfJobTimeAction
    }
}
impl ::std::cmp::Eq for JOBOBJECT_END_OF_JOB_TIME_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    pub BasicLimitInformation: JOBOBJECT_BASIC_LIMIT_INFORMATION,
    pub IoInfo: IO_COUNTERS,
    pub ProcessMemoryLimit: usize,
    pub JobMemoryLimit: usize,
    pub PeakProcessMemoryUsed: usize,
    pub PeakJobMemoryUsed: usize,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_EXTENDED_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::fmt::Debug for JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_EXTENDED_LIMIT_INFORMATION")
            .field("BasicLimitInformation", &self.BasicLimitInformation)
            .field("IoInfo", &self.IoInfo)
            .field("ProcessMemoryLimit", &self.ProcessMemoryLimit)
            .field("JobMemoryLimit", &self.JobMemoryLimit)
            .field("PeakProcessMemoryUsed", &self.PeakProcessMemoryUsed)
            .field("PeakJobMemoryUsed", &self.PeakJobMemoryUsed)
            .finish()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.BasicLimitInformation == other.BasicLimitInformation && self.IoInfo == other.IoInfo && self.ProcessMemoryLimit == other.ProcessMemoryLimit && self.JobMemoryLimit == other.JobMemoryLimit && self.PeakProcessMemoryUsed == other.PeakProcessMemoryUsed && self.PeakJobMemoryUsed == other.PeakJobMemoryUsed
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_EXTENDED_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS(pub i32);
pub const JOBOBJECT_IO_ATTRIBUTION_CONTROL_ENABLE: JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS = JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS(1i32);
pub const JOBOBJECT_IO_ATTRIBUTION_CONTROL_DISABLE: JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS = JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS(2i32);
pub const JOBOBJECT_IO_ATTRIBUTION_CONTROL_VALID_FLAGS: JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS = JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS(3i32);
impl ::std::convert::From<i32> for JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_ATTRIBUTION_CONTROL_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_IO_ATTRIBUTION_INFORMATION {
    pub ControlFlags: u32,
    pub ReadStats: JOBOBJECT_IO_ATTRIBUTION_STATS,
    pub WriteStats: JOBOBJECT_IO_ATTRIBUTION_STATS,
}
impl JOBOBJECT_IO_ATTRIBUTION_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_IO_ATTRIBUTION_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_IO_ATTRIBUTION_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_IO_ATTRIBUTION_INFORMATION").field("ControlFlags", &self.ControlFlags).field("ReadStats", &self.ReadStats).field("WriteStats", &self.WriteStats).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_IO_ATTRIBUTION_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.ControlFlags == other.ControlFlags && self.ReadStats == other.ReadStats && self.WriteStats == other.WriteStats
    }
}
impl ::std::cmp::Eq for JOBOBJECT_IO_ATTRIBUTION_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_ATTRIBUTION_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_IO_ATTRIBUTION_STATS {
    pub IoCount: usize,
    pub TotalNonOverlappedQueueTime: u64,
    pub TotalNonOverlappedServiceTime: u64,
    pub TotalSize: u64,
}
impl JOBOBJECT_IO_ATTRIBUTION_STATS {}
impl ::std::default::Default for JOBOBJECT_IO_ATTRIBUTION_STATS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_IO_ATTRIBUTION_STATS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_IO_ATTRIBUTION_STATS").field("IoCount", &self.IoCount).field("TotalNonOverlappedQueueTime", &self.TotalNonOverlappedQueueTime).field("TotalNonOverlappedServiceTime", &self.TotalNonOverlappedServiceTime).field("TotalSize", &self.TotalSize).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_IO_ATTRIBUTION_STATS {
    fn eq(&self, other: &Self) -> bool {
        self.IoCount == other.IoCount && self.TotalNonOverlappedQueueTime == other.TotalNonOverlappedQueueTime && self.TotalNonOverlappedServiceTime == other.TotalNonOverlappedServiceTime && self.TotalSize == other.TotalSize
    }
}
impl ::std::cmp::Eq for JOBOBJECT_IO_ATTRIBUTION_STATS {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_ATTRIBUTION_STATS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {
    pub MaxIops: i64,
    pub MaxBandwidth: i64,
    pub ReservationIops: i64,
    pub VolumeName: super::super::Foundation::PWSTR,
    pub BaseIoSize: u32,
    pub ControlFlags: JOB_OBJECT_IO_RATE_CONTROL_FLAGS,
    pub VolumeNameLength: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE")
            .field("MaxIops", &self.MaxIops)
            .field("MaxBandwidth", &self.MaxBandwidth)
            .field("ReservationIops", &self.ReservationIops)
            .field("VolumeName", &self.VolumeName)
            .field("BaseIoSize", &self.BaseIoSize)
            .field("ControlFlags", &self.ControlFlags)
            .field("VolumeNameLength", &self.VolumeNameLength)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {
    fn eq(&self, other: &Self) -> bool {
        self.MaxIops == other.MaxIops && self.MaxBandwidth == other.MaxBandwidth && self.ReservationIops == other.ReservationIops && self.VolumeName == other.VolumeName && self.BaseIoSize == other.BaseIoSize && self.ControlFlags == other.ControlFlags && self.VolumeNameLength == other.VolumeNameLength
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {
    pub MaxIops: i64,
    pub MaxBandwidth: i64,
    pub ReservationIops: i64,
    pub VolumeName: super::super::Foundation::PWSTR,
    pub BaseIoSize: u32,
    pub ControlFlags: JOB_OBJECT_IO_RATE_CONTROL_FLAGS,
    pub VolumeNameLength: u16,
    pub CriticalReservationIops: i64,
    pub ReservationBandwidth: i64,
    pub CriticalReservationBandwidth: i64,
    pub MaxTimePercent: i64,
    pub ReservationTimePercent: i64,
    pub CriticalReservationTimePercent: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2")
            .field("MaxIops", &self.MaxIops)
            .field("MaxBandwidth", &self.MaxBandwidth)
            .field("ReservationIops", &self.ReservationIops)
            .field("VolumeName", &self.VolumeName)
            .field("BaseIoSize", &self.BaseIoSize)
            .field("ControlFlags", &self.ControlFlags)
            .field("VolumeNameLength", &self.VolumeNameLength)
            .field("CriticalReservationIops", &self.CriticalReservationIops)
            .field("ReservationBandwidth", &self.ReservationBandwidth)
            .field("CriticalReservationBandwidth", &self.CriticalReservationBandwidth)
            .field("MaxTimePercent", &self.MaxTimePercent)
            .field("ReservationTimePercent", &self.ReservationTimePercent)
            .field("CriticalReservationTimePercent", &self.CriticalReservationTimePercent)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.MaxIops == other.MaxIops
            && self.MaxBandwidth == other.MaxBandwidth
            && self.ReservationIops == other.ReservationIops
            && self.VolumeName == other.VolumeName
            && self.BaseIoSize == other.BaseIoSize
            && self.ControlFlags == other.ControlFlags
            && self.VolumeNameLength == other.VolumeNameLength
            && self.CriticalReservationIops == other.CriticalReservationIops
            && self.ReservationBandwidth == other.ReservationBandwidth
            && self.CriticalReservationBandwidth == other.CriticalReservationBandwidth
            && self.MaxTimePercent == other.MaxTimePercent
            && self.ReservationTimePercent == other.ReservationTimePercent
            && self.CriticalReservationTimePercent == other.CriticalReservationTimePercent
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {
    pub MaxIops: i64,
    pub MaxBandwidth: i64,
    pub ReservationIops: i64,
    pub VolumeName: super::super::Foundation::PWSTR,
    pub BaseIoSize: u32,
    pub ControlFlags: JOB_OBJECT_IO_RATE_CONTROL_FLAGS,
    pub VolumeNameLength: u16,
    pub CriticalReservationIops: i64,
    pub ReservationBandwidth: i64,
    pub CriticalReservationBandwidth: i64,
    pub MaxTimePercent: i64,
    pub ReservationTimePercent: i64,
    pub CriticalReservationTimePercent: i64,
    pub SoftMaxIops: i64,
    pub SoftMaxBandwidth: i64,
    pub SoftMaxTimePercent: i64,
    pub LimitExcessNotifyIops: i64,
    pub LimitExcessNotifyBandwidth: i64,
    pub LimitExcessNotifyTimePercent: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3")
            .field("MaxIops", &self.MaxIops)
            .field("MaxBandwidth", &self.MaxBandwidth)
            .field("ReservationIops", &self.ReservationIops)
            .field("VolumeName", &self.VolumeName)
            .field("BaseIoSize", &self.BaseIoSize)
            .field("ControlFlags", &self.ControlFlags)
            .field("VolumeNameLength", &self.VolumeNameLength)
            .field("CriticalReservationIops", &self.CriticalReservationIops)
            .field("ReservationBandwidth", &self.ReservationBandwidth)
            .field("CriticalReservationBandwidth", &self.CriticalReservationBandwidth)
            .field("MaxTimePercent", &self.MaxTimePercent)
            .field("ReservationTimePercent", &self.ReservationTimePercent)
            .field("CriticalReservationTimePercent", &self.CriticalReservationTimePercent)
            .field("SoftMaxIops", &self.SoftMaxIops)
            .field("SoftMaxBandwidth", &self.SoftMaxBandwidth)
            .field("SoftMaxTimePercent", &self.SoftMaxTimePercent)
            .field("LimitExcessNotifyIops", &self.LimitExcessNotifyIops)
            .field("LimitExcessNotifyBandwidth", &self.LimitExcessNotifyBandwidth)
            .field("LimitExcessNotifyTimePercent", &self.LimitExcessNotifyTimePercent)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {
    fn eq(&self, other: &Self) -> bool {
        self.MaxIops == other.MaxIops
            && self.MaxBandwidth == other.MaxBandwidth
            && self.ReservationIops == other.ReservationIops
            && self.VolumeName == other.VolumeName
            && self.BaseIoSize == other.BaseIoSize
            && self.ControlFlags == other.ControlFlags
            && self.VolumeNameLength == other.VolumeNameLength
            && self.CriticalReservationIops == other.CriticalReservationIops
            && self.ReservationBandwidth == other.ReservationBandwidth
            && self.CriticalReservationBandwidth == other.CriticalReservationBandwidth
            && self.MaxTimePercent == other.MaxTimePercent
            && self.ReservationTimePercent == other.ReservationTimePercent
            && self.CriticalReservationTimePercent == other.CriticalReservationTimePercent
            && self.SoftMaxIops == other.SoftMaxIops
            && self.SoftMaxBandwidth == other.SoftMaxBandwidth
            && self.SoftMaxTimePercent == other.SoftMaxTimePercent
            && self.LimitExcessNotifyIops == other.LimitExcessNotifyIops
            && self.LimitExcessNotifyBandwidth == other.LimitExcessNotifyBandwidth
            && self.LimitExcessNotifyTimePercent == other.LimitExcessNotifyTimePercent
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_IO_RATE_CONTROL_INFORMATION_NATIVE_V3 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_JOBSET_INFORMATION {
    pub MemberLevel: u32,
}
impl JOBOBJECT_JOBSET_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_JOBSET_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_JOBSET_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_JOBSET_INFORMATION").field("MemberLevel", &self.MemberLevel).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_JOBSET_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.MemberLevel == other.MemberLevel
    }
}
impl ::std::cmp::Eq for JOBOBJECT_JOBSET_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_JOBSET_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_LIMIT_VIOLATION_INFORMATION {
    pub LimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub ViolationLimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub IoReadBytes: u64,
    pub IoReadBytesLimit: u64,
    pub IoWriteBytes: u64,
    pub IoWriteBytesLimit: u64,
    pub PerJobUserTime: i64,
    pub PerJobUserTimeLimit: i64,
    pub JobMemory: u64,
    pub JobMemoryLimit: u64,
    pub RateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub RateControlToleranceLimit: JOBOBJECT_RATE_CONTROL_TOLERANCE,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_LIMIT_VIOLATION_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_LIMIT_VIOLATION_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::fmt::Debug for JOBOBJECT_LIMIT_VIOLATION_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_LIMIT_VIOLATION_INFORMATION")
            .field("LimitFlags", &self.LimitFlags)
            .field("ViolationLimitFlags", &self.ViolationLimitFlags)
            .field("IoReadBytes", &self.IoReadBytes)
            .field("IoReadBytesLimit", &self.IoReadBytesLimit)
            .field("IoWriteBytes", &self.IoWriteBytes)
            .field("IoWriteBytesLimit", &self.IoWriteBytesLimit)
            .field("PerJobUserTime", &self.PerJobUserTime)
            .field("PerJobUserTimeLimit", &self.PerJobUserTimeLimit)
            .field("JobMemory", &self.JobMemory)
            .field("JobMemoryLimit", &self.JobMemoryLimit)
            .field("RateControlTolerance", &self.RateControlTolerance)
            .field("RateControlToleranceLimit", &self.RateControlToleranceLimit)
            .finish()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.LimitFlags == other.LimitFlags
            && self.ViolationLimitFlags == other.ViolationLimitFlags
            && self.IoReadBytes == other.IoReadBytes
            && self.IoReadBytesLimit == other.IoReadBytesLimit
            && self.IoWriteBytes == other.IoWriteBytes
            && self.IoWriteBytesLimit == other.IoWriteBytesLimit
            && self.PerJobUserTime == other.PerJobUserTime
            && self.PerJobUserTimeLimit == other.PerJobUserTimeLimit
            && self.JobMemory == other.JobMemory
            && self.JobMemoryLimit == other.JobMemoryLimit
            && self.RateControlTolerance == other.RateControlTolerance
            && self.RateControlToleranceLimit == other.RateControlToleranceLimit
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_LIMIT_VIOLATION_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {
    pub LimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub ViolationLimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub IoReadBytes: u64,
    pub IoReadBytesLimit: u64,
    pub IoWriteBytes: u64,
    pub IoWriteBytesLimit: u64,
    pub PerJobUserTime: i64,
    pub PerJobUserTimeLimit: i64,
    pub JobMemory: u64,
    pub Anonymous1: JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0,
    pub Anonymous2: JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1,
    pub Anonymous3: JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2,
    pub JobLowMemoryLimit: u64,
    pub IoRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub IoRateControlToleranceLimit: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub NetRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub NetRateControlToleranceLimit: JOBOBJECT_RATE_CONTROL_TOLERANCE,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {
    pub JobHighMemoryLimit: u64,
    pub JobMemoryLimit: u64,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {
    pub RateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub CpuRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {
    pub RateControlToleranceLimit: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub CpuRateControlToleranceLimit: JOBOBJECT_RATE_CONTROL_TOLERANCE,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_LIMIT_VIOLATION_INFORMATION_2_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct JOBOBJECT_NET_RATE_CONTROL_INFORMATION {
    pub MaxBandwidth: u64,
    pub ControlFlags: JOB_OBJECT_NET_RATE_CONTROL_FLAGS,
    pub DscpTag: u8,
}
impl JOBOBJECT_NET_RATE_CONTROL_INFORMATION {}
impl ::std::default::Default for JOBOBJECT_NET_RATE_CONTROL_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for JOBOBJECT_NET_RATE_CONTROL_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_NET_RATE_CONTROL_INFORMATION").field("MaxBandwidth", &self.MaxBandwidth).field("ControlFlags", &self.ControlFlags).field("DscpTag", &self.DscpTag).finish()
    }
}
impl ::std::cmp::PartialEq for JOBOBJECT_NET_RATE_CONTROL_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.MaxBandwidth == other.MaxBandwidth && self.ControlFlags == other.ControlFlags && self.DscpTag == other.DscpTag
    }
}
impl ::std::cmp::Eq for JOBOBJECT_NET_RATE_CONTROL_INFORMATION {}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NET_RATE_CONTROL_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {
    pub IoReadBytesLimit: u64,
    pub IoWriteBytesLimit: u64,
    pub PerJobUserTimeLimit: i64,
    pub JobMemoryLimit: u64,
    pub RateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub RateControlToleranceInterval: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL,
    pub LimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::fmt::Debug for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION")
            .field("IoReadBytesLimit", &self.IoReadBytesLimit)
            .field("IoWriteBytesLimit", &self.IoWriteBytesLimit)
            .field("PerJobUserTimeLimit", &self.PerJobUserTimeLimit)
            .field("JobMemoryLimit", &self.JobMemoryLimit)
            .field("RateControlTolerance", &self.RateControlTolerance)
            .field("RateControlToleranceInterval", &self.RateControlToleranceInterval)
            .field("LimitFlags", &self.LimitFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.IoReadBytesLimit == other.IoReadBytesLimit && self.IoWriteBytesLimit == other.IoWriteBytesLimit && self.PerJobUserTimeLimit == other.PerJobUserTimeLimit && self.JobMemoryLimit == other.JobMemoryLimit && self.RateControlTolerance == other.RateControlTolerance && self.RateControlToleranceInterval == other.RateControlToleranceInterval && self.LimitFlags == other.LimitFlags
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {
    pub IoReadBytesLimit: u64,
    pub IoWriteBytesLimit: u64,
    pub PerJobUserTimeLimit: i64,
    pub Anonymous1: JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0,
    pub Anonymous2: JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1,
    pub Anonymous3: JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2,
    pub LimitFlags: super::JobObjects::JOB_OBJECT_LIMIT,
    pub IoRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub JobLowMemoryLimit: u64,
    pub IoRateControlToleranceInterval: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL,
    pub NetRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub NetRateControlToleranceInterval: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {
    pub JobHighMemoryLimit: u64,
    pub JobMemoryLimit: u64,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {
    pub RateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
    pub CpuRateControlTolerance: JOBOBJECT_RATE_CONTROL_TOLERANCE,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_JobObjects")]
pub union JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {
    pub RateControlToleranceInterval: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL,
    pub CpuRateControlToleranceInterval: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL,
}
#[cfg(feature = "Win32_System_JobObjects")]
impl JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::default::Default for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::PartialEq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_JobObjects")]
impl ::std::cmp::Eq for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {}
#[cfg(feature = "Win32_System_JobObjects")]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_NOTIFICATION_LIMIT_INFORMATION_2_2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOBOBJECT_RATE_CONTROL_TOLERANCE(pub i32);
pub const ToleranceLow: JOBOBJECT_RATE_CONTROL_TOLERANCE = JOBOBJECT_RATE_CONTROL_TOLERANCE(1i32);
pub const ToleranceMedium: JOBOBJECT_RATE_CONTROL_TOLERANCE = JOBOBJECT_RATE_CONTROL_TOLERANCE(2i32);
pub const ToleranceHigh: JOBOBJECT_RATE_CONTROL_TOLERANCE = JOBOBJECT_RATE_CONTROL_TOLERANCE(3i32);
impl ::std::convert::From<i32> for JOBOBJECT_RATE_CONTROL_TOLERANCE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_RATE_CONTROL_TOLERANCE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL(pub i32);
pub const ToleranceIntervalShort: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL = JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL(1i32);
pub const ToleranceIntervalMedium: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL = JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL(2i32);
pub const ToleranceIntervalLong: JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL = JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL(3i32);
impl ::std::convert::From<i32> for JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOBOBJECT_RATE_CONTROL_TOLERANCE_INTERVAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Security`, `Win32_System_JobObjects`*"]
pub struct JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    pub SecurityLimitFlags: super::JobObjects::JOB_OBJECT_SECURITY,
    pub JobToken: super::super::Foundation::HANDLE,
    pub SidsToDisable: *mut super::super::Security::TOKEN_GROUPS,
    pub PrivilegesToDelete: *mut super::super::Security::TOKEN_PRIVILEGES,
    pub RestrictedSids: *mut super::super::Security::TOKEN_GROUPS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
impl JOBOBJECT_SECURITY_LIMIT_INFORMATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
impl ::std::default::Default for JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
impl ::std::fmt::Debug for JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOBOBJECT_SECURITY_LIMIT_INFORMATION").field("SecurityLimitFlags", &self.SecurityLimitFlags).field("JobToken", &self.JobToken).field("SidsToDisable", &self.SidsToDisable).field("PrivilegesToDelete", &self.PrivilegesToDelete).field("RestrictedSids", &self.RestrictedSids).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
impl ::std::cmp::PartialEq for JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.SecurityLimitFlags == other.SecurityLimitFlags && self.JobToken == other.JobToken && self.SidsToDisable == other.SidsToDisable && self.PrivilegesToDelete == other.PrivilegesToDelete && self.RestrictedSids == other.RestrictedSids
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
impl ::std::cmp::Eq for JOBOBJECT_SECURITY_LIMIT_INFORMATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_JobObjects"))]
unsafe impl ::windows::runtime::Abi for JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_ASSIGN_PROCESS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOB_OBJECT_CPU_RATE_CONTROL(pub u32);
pub const JOB_OBJECT_CPU_RATE_CONTROL_ENABLE: JOB_OBJECT_CPU_RATE_CONTROL = JOB_OBJECT_CPU_RATE_CONTROL(1u32);
pub const JOB_OBJECT_CPU_RATE_CONTROL_WEIGHT_BASED: JOB_OBJECT_CPU_RATE_CONTROL = JOB_OBJECT_CPU_RATE_CONTROL(2u32);
pub const JOB_OBJECT_CPU_RATE_CONTROL_HARD_CAP: JOB_OBJECT_CPU_RATE_CONTROL = JOB_OBJECT_CPU_RATE_CONTROL(4u32);
pub const JOB_OBJECT_CPU_RATE_CONTROL_NOTIFY: JOB_OBJECT_CPU_RATE_CONTROL = JOB_OBJECT_CPU_RATE_CONTROL(8u32);
pub const JOB_OBJECT__CPU_RATE_CONTROL_MIN_MAX_RATE: JOB_OBJECT_CPU_RATE_CONTROL = JOB_OBJECT_CPU_RATE_CONTROL(16u32);
impl ::std::convert::From<u32> for JOB_OBJECT_CPU_RATE_CONTROL {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOB_OBJECT_CPU_RATE_CONTROL {
    type Abi = Self;
}
impl ::std::ops::BitOr for JOB_OBJECT_CPU_RATE_CONTROL {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for JOB_OBJECT_CPU_RATE_CONTROL {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for JOB_OBJECT_CPU_RATE_CONTROL {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for JOB_OBJECT_CPU_RATE_CONTROL {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for JOB_OBJECT_CPU_RATE_CONTROL {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_CPU_RATE_CONTROL_MIN_MAX_RATE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_CPU_RATE_CONTROL_VALID_FLAGS: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_IMPERSONATE: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOB_OBJECT_IO_RATE_CONTROL_FLAGS(pub i32);
pub const JOB_OBJECT_IO_RATE_CONTROL_ENABLE: JOB_OBJECT_IO_RATE_CONTROL_FLAGS = JOB_OBJECT_IO_RATE_CONTROL_FLAGS(1i32);
pub const JOB_OBJECT_IO_RATE_CONTROL_STANDALONE_VOLUME: JOB_OBJECT_IO_RATE_CONTROL_FLAGS = JOB_OBJECT_IO_RATE_CONTROL_FLAGS(2i32);
pub const JOB_OBJECT_IO_RATE_CONTROL_FORCE_UNIT_ACCESS_ALL: JOB_OBJECT_IO_RATE_CONTROL_FLAGS = JOB_OBJECT_IO_RATE_CONTROL_FLAGS(4i32);
pub const JOB_OBJECT_IO_RATE_CONTROL_FORCE_UNIT_ACCESS_ON_SOFT_CAP: JOB_OBJECT_IO_RATE_CONTROL_FLAGS = JOB_OBJECT_IO_RATE_CONTROL_FLAGS(8i32);
pub const JOB_OBJECT_IO_RATE_CONTROL_VALID_FLAGS: JOB_OBJECT_IO_RATE_CONTROL_FLAGS = JOB_OBJECT_IO_RATE_CONTROL_FLAGS(15i32);
impl ::std::convert::From<i32> for JOB_OBJECT_IO_RATE_CONTROL_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOB_OBJECT_IO_RATE_CONTROL_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_END_OF_JOB_TIME: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_END_OF_PROCESS_TIME: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_EXIT_PROCESS: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_JOB_CYCLE_TIME_LIMIT: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_JOB_MEMORY_LIMIT: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_MAXIMUM: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_MINIMUM: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_NEW_PROCESS: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_NOTIFICATION_LIMIT: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_MSG_SILO_TERMINATED: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOB_OBJECT_NET_RATE_CONTROL_FLAGS(pub i32);
pub const JOB_OBJECT_NET_RATE_CONTROL_ENABLE: JOB_OBJECT_NET_RATE_CONTROL_FLAGS = JOB_OBJECT_NET_RATE_CONTROL_FLAGS(1i32);
pub const JOB_OBJECT_NET_RATE_CONTROL_MAX_BANDWIDTH: JOB_OBJECT_NET_RATE_CONTROL_FLAGS = JOB_OBJECT_NET_RATE_CONTROL_FLAGS(2i32);
pub const JOB_OBJECT_NET_RATE_CONTROL_DSCP_TAG: JOB_OBJECT_NET_RATE_CONTROL_FLAGS = JOB_OBJECT_NET_RATE_CONTROL_FLAGS(4i32);
pub const JOB_OBJECT_NET_RATE_CONTROL_VALID_FLAGS: JOB_OBJECT_NET_RATE_CONTROL_FLAGS = JOB_OBJECT_NET_RATE_CONTROL_FLAGS(7i32);
impl ::std::convert::From<i32> for JOB_OBJECT_NET_RATE_CONTROL_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOB_OBJECT_NET_RATE_CONTROL_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_NET_RATE_CONTROL_MAX_DSCP_TAG: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_QUERY: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_SET_ATTRIBUTES: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_SET_SECURITY_ATTRIBUTES: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_TERMINATE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct JOB_OBJECT_TERMINATE_AT_END_ACTION(pub u32);
pub const JOB_OBJECT_TERMINATE_AT_END_OF_JOB: JOB_OBJECT_TERMINATE_AT_END_ACTION = JOB_OBJECT_TERMINATE_AT_END_ACTION(0u32);
pub const JOB_OBJECT_POST_AT_END_OF_JOB: JOB_OBJECT_TERMINATE_AT_END_ACTION = JOB_OBJECT_TERMINATE_AT_END_ACTION(1u32);
impl ::std::convert::From<u32> for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for JOB_OBJECT_TERMINATE_AT_END_ACTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_UILIMIT_ALL: u32 = 255u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOB_OBJECT_UI_VALID_FLAGS: u32 = 255u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct JOB_SET_ARRAY {
    pub JobHandle: super::super::Foundation::HANDLE,
    pub MemberLevel: u32,
    pub Flags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl JOB_SET_ARRAY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for JOB_SET_ARRAY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for JOB_SET_ARRAY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("JOB_SET_ARRAY").field("JobHandle", &self.JobHandle).field("MemberLevel", &self.MemberLevel).field("Flags", &self.Flags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for JOB_SET_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.JobHandle == other.JobHandle && self.MemberLevel == other.MemberLevel && self.Flags == other.Flags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for JOB_SET_ARRAY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for JOB_SET_ARRAY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOIN_BEVEL: i32 = 1i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOIN_MITER: i32 = 2i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const JOIN_ROUND: i32 = 0i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KERNEL_CET_CONTEXT {
    pub Ssp: u64,
    pub Rip: u64,
    pub SegCs: u16,
    pub Anonymous: KERNEL_CET_CONTEXT_0,
    pub Fill: [u16; 2],
}
impl KERNEL_CET_CONTEXT {}
impl ::std::default::Default for KERNEL_CET_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KERNEL_CET_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KERNEL_CET_CONTEXT {}
unsafe impl ::windows::runtime::Abi for KERNEL_CET_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union KERNEL_CET_CONTEXT_0 {
    pub AllFlags: u16,
    pub Anonymous: KERNEL_CET_CONTEXT_0_0,
}
impl KERNEL_CET_CONTEXT_0 {}
impl ::std::default::Default for KERNEL_CET_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KERNEL_CET_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KERNEL_CET_CONTEXT_0 {}
unsafe impl ::windows::runtime::Abi for KERNEL_CET_CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KERNEL_CET_CONTEXT_0_0 {
    pub _bitfield: u16,
}
impl KERNEL_CET_CONTEXT_0_0 {}
impl ::std::default::Default for KERNEL_CET_CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KERNEL_CET_CONTEXT_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for KERNEL_CET_CONTEXT_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for KERNEL_CET_CONTEXT_0_0 {}
unsafe impl ::windows::runtime::Abi for KERNEL_CET_CONTEXT_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KNONVOLATILE_CONTEXT_POINTERS {
    pub Anonymous1: KNONVOLATILE_CONTEXT_POINTERS_0,
    pub Anonymous2: KNONVOLATILE_CONTEXT_POINTERS_1,
}
#[cfg(any(target_arch = "x86_64",))]
impl KNONVOLATILE_CONTEXT_POINTERS {}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS {}
#[cfg(any(target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
pub union KNONVOLATILE_CONTEXT_POINTERS_0 {
    pub FloatingContext: [*mut M128A; 16],
    pub Anonymous: KNONVOLATILE_CONTEXT_POINTERS_0_0,
}
#[cfg(any(target_arch = "x86_64",))]
impl KNONVOLATILE_CONTEXT_POINTERS_0 {}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS_0 {}
#[cfg(any(target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
pub struct KNONVOLATILE_CONTEXT_POINTERS_0_0 {
    pub Xmm0: *mut M128A,
    pub Xmm1: *mut M128A,
    pub Xmm2: *mut M128A,
    pub Xmm3: *mut M128A,
    pub Xmm4: *mut M128A,
    pub Xmm5: *mut M128A,
    pub Xmm6: *mut M128A,
    pub Xmm7: *mut M128A,
    pub Xmm8: *mut M128A,
    pub Xmm9: *mut M128A,
    pub Xmm10: *mut M128A,
    pub Xmm11: *mut M128A,
    pub Xmm12: *mut M128A,
    pub Xmm13: *mut M128A,
    pub Xmm14: *mut M128A,
    pub Xmm15: *mut M128A,
}
#[cfg(any(target_arch = "x86_64",))]
impl KNONVOLATILE_CONTEXT_POINTERS_0_0 {}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::fmt::Debug for KNONVOLATILE_CONTEXT_POINTERS_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("Xmm0", &self.Xmm0)
            .field("Xmm1", &self.Xmm1)
            .field("Xmm2", &self.Xmm2)
            .field("Xmm3", &self.Xmm3)
            .field("Xmm4", &self.Xmm4)
            .field("Xmm5", &self.Xmm5)
            .field("Xmm6", &self.Xmm6)
            .field("Xmm7", &self.Xmm7)
            .field("Xmm8", &self.Xmm8)
            .field("Xmm9", &self.Xmm9)
            .field("Xmm10", &self.Xmm10)
            .field("Xmm11", &self.Xmm11)
            .field("Xmm12", &self.Xmm12)
            .field("Xmm13", &self.Xmm13)
            .field("Xmm14", &self.Xmm14)
            .field("Xmm15", &self.Xmm15)
            .finish()
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Xmm0 == other.Xmm0 && self.Xmm1 == other.Xmm1 && self.Xmm2 == other.Xmm2 && self.Xmm3 == other.Xmm3 && self.Xmm4 == other.Xmm4 && self.Xmm5 == other.Xmm5 && self.Xmm6 == other.Xmm6 && self.Xmm7 == other.Xmm7 && self.Xmm8 == other.Xmm8 && self.Xmm9 == other.Xmm9 && self.Xmm10 == other.Xmm10 && self.Xmm11 == other.Xmm11 && self.Xmm12 == other.Xmm12 && self.Xmm13 == other.Xmm13 && self.Xmm14 == other.Xmm14 && self.Xmm15 == other.Xmm15
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS_0_0 {}
#[cfg(any(target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
pub union KNONVOLATILE_CONTEXT_POINTERS_1 {
    pub IntegerContext: [*mut u64; 16],
    pub Anonymous: KNONVOLATILE_CONTEXT_POINTERS_1_0,
}
#[cfg(any(target_arch = "x86_64",))]
impl KNONVOLATILE_CONTEXT_POINTERS_1 {}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS_1 {}
#[cfg(any(target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64",))]
pub struct KNONVOLATILE_CONTEXT_POINTERS_1_0 {
    pub Rax: *mut u64,
    pub Rcx: *mut u64,
    pub Rdx: *mut u64,
    pub Rbx: *mut u64,
    pub Rsp: *mut u64,
    pub Rbp: *mut u64,
    pub Rsi: *mut u64,
    pub Rdi: *mut u64,
    pub R8: *mut u64,
    pub R9: *mut u64,
    pub R10: *mut u64,
    pub R11: *mut u64,
    pub R12: *mut u64,
    pub R13: *mut u64,
    pub R14: *mut u64,
    pub R15: *mut u64,
}
#[cfg(any(target_arch = "x86_64",))]
impl KNONVOLATILE_CONTEXT_POINTERS_1_0 {}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS_1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::fmt::Debug for KNONVOLATILE_CONTEXT_POINTERS_1_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("Rax", &self.Rax)
            .field("Rcx", &self.Rcx)
            .field("Rdx", &self.Rdx)
            .field("Rbx", &self.Rbx)
            .field("Rsp", &self.Rsp)
            .field("Rbp", &self.Rbp)
            .field("Rsi", &self.Rsi)
            .field("Rdi", &self.Rdi)
            .field("R8", &self.R8)
            .field("R9", &self.R9)
            .field("R10", &self.R10)
            .field("R11", &self.R11)
            .field("R12", &self.R12)
            .field("R13", &self.R13)
            .field("R14", &self.R14)
            .field("R15", &self.R15)
            .finish()
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS_1_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Rax == other.Rax && self.Rcx == other.Rcx && self.Rdx == other.Rdx && self.Rbx == other.Rbx && self.Rsp == other.Rsp && self.Rbp == other.Rbp && self.Rsi == other.Rsi && self.Rdi == other.Rdi && self.R8 == other.R8 && self.R9 == other.R9 && self.R10 == other.R10 && self.R11 == other.R11 && self.R12 == other.R12 && self.R13 == other.R13 && self.R14 == other.R14 && self.R15 == other.R15
    }
}
#[cfg(any(target_arch = "x86_64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS_1_0 {}
#[cfg(any(target_arch = "x86_64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS_1_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86",))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KNONVOLATILE_CONTEXT_POINTERS {
    pub Dummy: u32,
}
#[cfg(any(target_arch = "x86",))]
impl KNONVOLATILE_CONTEXT_POINTERS {}
#[cfg(any(target_arch = "x86",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::fmt::Debug for KNONVOLATILE_CONTEXT_POINTERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KNONVOLATILE_CONTEXT_POINTERS").field("Dummy", &self.Dummy).finish()
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS {
    fn eq(&self, other: &Self) -> bool {
        self.Dummy == other.Dummy
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS {}
#[cfg(any(target_arch = "x86",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "aarch64",))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KNONVOLATILE_CONTEXT_POINTERS_ARM64 {
    pub X19: *mut u64,
    pub X20: *mut u64,
    pub X21: *mut u64,
    pub X22: *mut u64,
    pub X23: *mut u64,
    pub X24: *mut u64,
    pub X25: *mut u64,
    pub X26: *mut u64,
    pub X27: *mut u64,
    pub X28: *mut u64,
    pub Fp: *mut u64,
    pub Lr: *mut u64,
    pub D8: *mut u64,
    pub D9: *mut u64,
    pub D10: *mut u64,
    pub D11: *mut u64,
    pub D12: *mut u64,
    pub D13: *mut u64,
    pub D14: *mut u64,
    pub D15: *mut u64,
}
#[cfg(any(target_arch = "aarch64",))]
impl KNONVOLATILE_CONTEXT_POINTERS_ARM64 {}
#[cfg(any(target_arch = "aarch64",))]
impl ::std::default::Default for KNONVOLATILE_CONTEXT_POINTERS_ARM64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "aarch64",))]
impl ::std::fmt::Debug for KNONVOLATILE_CONTEXT_POINTERS_ARM64 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KNONVOLATILE_CONTEXT_POINTERS_ARM64")
            .field("X19", &self.X19)
            .field("X20", &self.X20)
            .field("X21", &self.X21)
            .field("X22", &self.X22)
            .field("X23", &self.X23)
            .field("X24", &self.X24)
            .field("X25", &self.X25)
            .field("X26", &self.X26)
            .field("X27", &self.X27)
            .field("X28", &self.X28)
            .field("Fp", &self.Fp)
            .field("Lr", &self.Lr)
            .field("D8", &self.D8)
            .field("D9", &self.D9)
            .field("D10", &self.D10)
            .field("D11", &self.D11)
            .field("D12", &self.D12)
            .field("D13", &self.D13)
            .field("D14", &self.D14)
            .field("D15", &self.D15)
            .finish()
    }
}
#[cfg(any(target_arch = "aarch64",))]
impl ::std::cmp::PartialEq for KNONVOLATILE_CONTEXT_POINTERS_ARM64 {
    fn eq(&self, other: &Self) -> bool {
        self.X19 == other.X19 && self.X20 == other.X20 && self.X21 == other.X21 && self.X22 == other.X22 && self.X23 == other.X23 && self.X24 == other.X24 && self.X25 == other.X25 && self.X26 == other.X26 && self.X27 == other.X27 && self.X28 == other.X28 && self.Fp == other.Fp && self.Lr == other.Lr && self.D8 == other.D8 && self.D9 == other.D9 && self.D10 == other.D10 && self.D11 == other.D11 && self.D12 == other.D12 && self.D13 == other.D13 && self.D14 == other.D14 && self.D15 == other.D15
    }
}
#[cfg(any(target_arch = "aarch64",))]
impl ::std::cmp::Eq for KNONVOLATILE_CONTEXT_POINTERS_ARM64 {}
#[cfg(any(target_arch = "aarch64",))]
unsafe impl ::windows::runtime::Abi for KNONVOLATILE_CONTEXT_POINTERS_ARM64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct KTMOBJECT_CURSOR {
    pub LastQuery: ::windows::runtime::GUID,
    pub ObjectIdCount: u32,
    pub ObjectIds: [::windows::runtime::GUID; 1],
}
impl KTMOBJECT_CURSOR {}
impl ::std::default::Default for KTMOBJECT_CURSOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KTMOBJECT_CURSOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KTMOBJECT_CURSOR").field("LastQuery", &self.LastQuery).field("ObjectIdCount", &self.ObjectIdCount).field("ObjectIds", &self.ObjectIds).finish()
    }
}
impl ::std::cmp::PartialEq for KTMOBJECT_CURSOR {
    fn eq(&self, other: &Self) -> bool {
        self.LastQuery == other.LastQuery && self.ObjectIdCount == other.ObjectIdCount && self.ObjectIds == other.ObjectIds
    }
}
impl ::std::cmp::Eq for KTMOBJECT_CURSOR {}
unsafe impl ::windows::runtime::Abi for KTMOBJECT_CURSOR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KTMOBJECT_TYPE(pub i32);
pub const KTMOBJECT_TRANSACTION: KTMOBJECT_TYPE = KTMOBJECT_TYPE(0i32);
pub const KTMOBJECT_TRANSACTION_MANAGER: KTMOBJECT_TYPE = KTMOBJECT_TYPE(1i32);
pub const KTMOBJECT_RESOURCE_MANAGER: KTMOBJECT_TYPE = KTMOBJECT_TYPE(2i32);
pub const KTMOBJECT_ENLISTMENT: KTMOBJECT_TYPE = KTMOBJECT_TYPE(3i32);
pub const KTMOBJECT_INVALID: KTMOBJECT_TYPE = KTMOBJECT_TYPE(4i32);
impl ::std::convert::From<i32> for KTMOBJECT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KTMOBJECT_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_AFRIKAANS: u32 = 54u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ALBANIAN: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ALSATIAN: u32 = 132u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_AMHARIC: u32 = 94u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ARABIC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ARMENIAN: u32 = 43u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ASSAMESE: u32 = 77u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_AZERBAIJANI: u32 = 44u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_AZERI: u32 = 44u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BANGLA: u32 = 69u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BASHKIR: u32 = 109u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BASQUE: u32 = 45u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BELARUSIAN: u32 = 35u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BENGALI: u32 = 69u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BOSNIAN: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BOSNIAN_NEUTRAL: u32 = 30746u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BRETON: u32 = 126u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_BULGARIAN: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CATALAN: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CENTRAL_KURDISH: u32 = 146u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CHEROKEE: u32 = 92u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CHINESE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CHINESE_SIMPLIFIED: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CHINESE_TRADITIONAL: u32 = 31748u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CORSICAN: u32 = 131u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CROATIAN: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_CZECH: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_DANISH: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_DARI: u32 = 140u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_DIVEHI: u32 = 101u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_DUTCH: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ENGLISH: u32 = 9u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ESTONIAN: u32 = 37u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FAEROESE: u32 = 56u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FARSI: u32 = 41u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FILIPINO: u32 = 100u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FINNISH: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FRENCH: u32 = 12u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FRISIAN: u32 = 98u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_FULAH: u32 = 103u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GALICIAN: u32 = 86u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GEORGIAN: u32 = 55u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GERMAN: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GREEK: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GREENLANDIC: u32 = 111u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_GUJARATI: u32 = 71u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_HAUSA: u32 = 104u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_HAWAIIAN: u32 = 117u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_HEBREW: u32 = 13u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_HINDI: u32 = 57u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_HUNGARIAN: u32 = 14u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ICELANDIC: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_IGBO: u32 = 112u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_INDONESIAN: u32 = 33u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_INUKTITUT: u32 = 93u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_INVARIANT: u32 = 127u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_IRISH: u32 = 60u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ITALIAN: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_JAPANESE: u32 = 17u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KANNADA: u32 = 75u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KASHMIRI: u32 = 96u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KAZAK: u32 = 63u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KHMER: u32 = 83u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KICHE: u32 = 134u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KINYARWANDA: u32 = 135u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KONKANI: u32 = 87u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KOREAN: u32 = 18u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_KYRGYZ: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_LAO: u32 = 84u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_LATVIAN: u32 = 38u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_LITHUANIAN: u32 = 39u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_LOWER_SORBIAN: u32 = 46u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_LUXEMBOURGISH: u32 = 110u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MACEDONIAN: u32 = 47u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MALAY: u32 = 62u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MALAYALAM: u32 = 76u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MALTESE: u32 = 58u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MANIPURI: u32 = 88u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MAORI: u32 = 129u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MAPUDUNGUN: u32 = 122u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MARATHI: u32 = 78u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MOHAWK: u32 = 124u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_MONGOLIAN: u32 = 80u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_NEPALI: u32 = 97u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_NEUTRAL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_NORWEGIAN: u32 = 20u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_OCCITAN: u32 = 130u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ODIA: u32 = 72u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ORIYA: u32 = 72u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_PASHTO: u32 = 99u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_PERSIAN: u32 = 41u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_POLISH: u32 = 21u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_PORTUGUESE: u32 = 22u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_PULAR: u32 = 103u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_PUNJABI: u32 = 70u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_QUECHUA: u32 = 107u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ROMANIAN: u32 = 24u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ROMANSH: u32 = 23u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_RUSSIAN: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SAKHA: u32 = 133u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SAMI: u32 = 59u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SANSKRIT: u32 = 79u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SCOTTISH_GAELIC: u32 = 145u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SERBIAN: u32 = 26u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SERBIAN_NEUTRAL: u32 = 31770u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SINDHI: u32 = 89u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SINHALESE: u32 = 91u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SLOVAK: u32 = 27u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SLOVENIAN: u32 = 36u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SOTHO: u32 = 108u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SPANISH: u32 = 10u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SWAHILI: u32 = 65u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SWEDISH: u32 = 29u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_SYRIAC: u32 = 90u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TAJIK: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TAMAZIGHT: u32 = 95u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TAMIL: u32 = 73u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TATAR: u32 = 68u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TELUGU: u32 = 74u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_THAI: u32 = 30u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TIBETAN: u32 = 81u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TIGRIGNA: u32 = 115u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TIGRINYA: u32 = 115u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TSWANA: u32 = 50u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TURKISH: u32 = 31u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_TURKMEN: u32 = 66u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_UIGHUR: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_UKRAINIAN: u32 = 34u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_UPPER_SORBIAN: u32 = 46u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_URDU: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_UZBEK: u32 = 67u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_VALENCIAN: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_VIETNAMESE: u32 = 42u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_WELSH: u32 = 82u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_WOLOF: u32 = 136u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_XHOSA: u32 = 52u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_YAKUT: u32 = 133u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_YI: u32 = 120u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_YORUBA: u32 = 106u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LANG_ZULU: u32 = 53u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LA_ALTERNATE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LA_GEOMETRIC: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LA_STARTGAP: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LA_STYLED: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct LIGATURE {
    pub culSize: u32,
    pub pwsz: super::super::Foundation::PWSTR,
    pub chglyph: u32,
    pub ahglyph: [u32; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl LIGATURE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for LIGATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for LIGATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("LIGATURE").field("culSize", &self.culSize).field("pwsz", &self.pwsz).field("chglyph", &self.chglyph).field("ahglyph", &self.ahglyph).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for LIGATURE {
    fn eq(&self, other: &Self) -> bool {
        self.culSize == other.culSize && self.pwsz == other.pwsz && self.chglyph == other.chglyph && self.ahglyph == other.ahglyph
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for LIGATURE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for LIGATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_DISCARDABLE: u32 = 3840u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_DISCARDED: u32 = 16384u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_INVALID_HANDLE: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_LOCKCOUNT: u32 = 255u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_MODIFY: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_NOCOMPACT: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_NODISCARD: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LMEM_VALID_FLAGS: u32 = 3954u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCALE_NAME_MAX_LENGTH: u32 = 85u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCALE_TRANSIENT_KEYBOARD1: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCALE_TRANSIENT_KEYBOARD2: u32 = 9216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCALE_TRANSIENT_KEYBOARD3: u32 = 10240u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCALE_TRANSIENT_KEYBOARD4: u32 = 11264u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKF_LOGICAL_LOCK: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKF_PHYSICAL_LOCK: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_ALLOW_MEM_MAPPING: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_ALLOW_WRITES: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_FAIL_MEM_MAPPING: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_FAIL_WRITES: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_LOCK_FOR_FORMAT: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LOCKP_USER_MASK: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LPD3DENUMDEVICESCALLBACK = unsafe extern "system" fn(lpguid: *mut ::windows::runtime::GUID, lpdevicedescription: super::super::Foundation::PSTR, lpdevicename: super::super::Foundation::PSTR, param3: *mut _D3DDeviceDesc, param4: *mut _D3DDeviceDesc, param5: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LPD3DENUMDEVICESCALLBACK7 = unsafe extern "system" fn(lpdevicedescription: super::super::Foundation::PSTR, lpdevicename: super::super::Foundation::PSTR, param2: *mut _D3DDeviceDesc7, param3: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_DirectDraw`*"]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub type LPD3DENUMPIXELFORMATSCALLBACK = unsafe extern "system" fn(lpddpixfmt: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT, lpcontext: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_DirectDraw`*"]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub type LPD3DENUMTEXTUREFORMATSCALLBACK = unsafe extern "system" fn(lpddsd: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, lpcontext: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Direct3D9`*"]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub type LPD3DNTHAL_CLEAR2CB = unsafe extern "system" fn(param0: *mut D3DNTHAL_CLEAR2DATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub type LPD3DNTHAL_CONTEXTCREATECB = unsafe extern "system" fn(param0: *mut D3DNTHAL_CONTEXTCREATEDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_CONTEXTDESTROYALLCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_CONTEXTDESTROYALLDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_CONTEXTDESTROYCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_CONTEXTDESTROYDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub type LPD3DNTHAL_DRAWPRIMITIVES2CB = unsafe extern "system" fn(param0: *mut D3DNTHAL_DRAWPRIMITIVES2DATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_SCENECAPTURECB = unsafe extern "system" fn(param0: *mut D3DNTHAL_SCENECAPTUREDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub type LPD3DNTHAL_SETRENDERTARGETCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_SETRENDERTARGETDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LPD3DNTHAL_TEXTURECREATECB = unsafe extern "system" fn(param0: *mut D3DNTHAL_TEXTURECREATEDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_TEXTUREDESTROYCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_TEXTUREDESTROYDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LPD3DNTHAL_TEXTUREGETSURFCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_TEXTUREGETSURFDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_TEXTURESWAPCB = unsafe extern "system" fn(param0: *mut D3DNTHAL_TEXTURESWAPDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DNTHAL_VALIDATETEXTURESTAGESTATECB = unsafe extern "system" fn(param0: *mut D3DNTHAL_VALIDATETEXTURESTAGESTATEDATA) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPD3DVALIDATECALLBACK = unsafe extern "system" fn(lpuserarg: *mut ::std::ffi::c_void, dwoffset: u32) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPTHREAD_START_ROUTINE = unsafe extern "system" fn(lpthreadparameter: *mut ::std::ffi::c_void) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type LPTIMECALLBACK = unsafe extern "system" fn(utimerid: u32, umsg: u32, dwuser: usize, dw1: usize, dw2: usize);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const LTP_PC_SMT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct M128A {
    pub Low: u64,
    pub High: i64,
}
impl M128A {}
impl ::std::default::Default for M128A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for M128A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("M128A").field("Low", &self.Low).field("High", &self.High).finish()
    }
}
impl ::std::cmp::PartialEq for M128A {
    fn eq(&self, other: &Self) -> bool {
        self.Low == other.Low && self.High == other.High
    }
}
impl ::std::cmp::Eq for M128A {}
unsafe impl ::windows::runtime::Abi for M128A {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAILSLOT_NO_MESSAGE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAILSLOT_WAIT_FOREVER: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXBYTE: u32 = 255u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXCHAR: u32 = 127u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXCHARSETS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXDWORD: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_ALLOWED: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_PROCESSORS: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_PROC_PER_GROUP: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_SUPPORTED_EXTENSION: u32 = 512u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_SUSPEND_COUNT: u32 = 127u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_WAIT_OBJECTS: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXIMUM_XSTATE_FEATURES: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXLOGICALLOGNAMESIZE: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXLONG: u32 = 2147483647u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXLONGLONG: u64 = 9223372036854775807u64;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXSHORT: u32 = 32767u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct MAXVERSIONTESTED_INFO {
    pub MaxVersionTested: u64,
}
impl MAXVERSIONTESTED_INFO {}
impl ::std::default::Default for MAXVERSIONTESTED_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MAXVERSIONTESTED_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAXVERSIONTESTED_INFO").field("MaxVersionTested", &self.MaxVersionTested).finish()
    }
}
impl ::std::cmp::PartialEq for MAXVERSIONTESTED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.MaxVersionTested == other.MaxVersionTested
    }
}
impl ::std::cmp::Eq for MAXVERSIONTESTED_INFO {}
unsafe impl ::windows::runtime::Abi for MAXVERSIONTESTED_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAXWORD: u32 = 65535u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAX_ACL_REVISION: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAX_DEVPROP_TYPE: u32 = 25u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAX_DEVPROP_TYPEMOD: u32 = 8192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAX_HW_COUNTERS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MAX_UCSCHAR: u32 = 1114111u32;
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_BUS_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414022i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_BUS_TIMEOUT_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414021i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_CACHE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414083i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_CPU: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414030i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_CPU_BUS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414079i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_MAS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414075i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_MEM_1_2: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414071i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_MEM_1_2_5: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414069i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_MEM_1_2_5_4: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414067i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_MEM_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414073i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_MASTER_ABORT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414055i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_MASTER_ABORT_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414053i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_PARITY: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414063i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_PARITY_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414061i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_SERR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414059i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_SERR_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414057i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_TIMEOUT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414051i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_TIMEOUT_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414049i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_BUS_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414047i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PCI_DEVICE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414045i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_PLATFORM_SPECIFIC: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414041i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_REGISTER_FILE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414077i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_SMBIOS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414043i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_SYSTEM_EVENT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414065i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_TLB: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414081i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414039i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_ERROR_UNKNOWN_NO_CPU: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414037i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_EXTERNAL_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414017i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_FRC_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414016i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_INFO_CPU_THERMAL_THROTTLING_REMOVED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074069616i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_INFO_MEMORY_PAGE_MARKED_BAD: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074069620i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_INFO_NO_MORE_CORRECTED_ERROR_LOGS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(1074069619i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_INTERNALTIMER_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414020i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_MEMORYHIERARCHY_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414024i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_MICROCODE_ROM_PARITY_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414018i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_TLB_ERROR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-1073414023i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CACHE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155908i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CMC_THRESHOLD_EXCEEDED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155859i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CPE_THRESHOLD_EXCEEDED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155858i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CPU: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155855i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CPU_BUS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155904i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_CPU_THERMAL_THROTTLED: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155857i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_MAS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155900i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_MEM_1_2: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155896i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_MEM_1_2_5: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155894i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_MEM_1_2_5_4: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155892i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_MEM_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155898i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_MASTER_ABORT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155880i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_MASTER_ABORT_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155878i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_PARITY: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155888i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_PARITY_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155886i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_SERR: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155884i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_SERR_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155882i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_TIMEOUT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155876i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_TIMEOUT_NO_INFO: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155874i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_BUS_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155872i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PCI_DEVICE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155870i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_PLATFORM_SPECIFIC: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155866i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_REGISTER_FILE: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155902i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_SMBIOS: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155868i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_SYSTEM_EVENT: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155890i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_TLB: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155906i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_UNKNOWN: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155864i32 as _);
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub const MCA_WARNING_UNKNOWN_NO_CPU: super::super::Foundation::NTSTATUS = super::super::Foundation::NTSTATUS(-2147155862i32 as _);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEMORY_ALLOCATION_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {
    pub Type: MEM_DEDICATED_ATTRIBUTE_TYPE,
    pub Reserved: u32,
    pub Value: u64,
}
impl MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {}
impl ::std::default::Default for MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE").field("Type", &self.Type).field("Reserved", &self.Reserved).field("Value", &self.Value).finish()
    }
}
impl ::std::cmp::PartialEq for MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.Reserved == other.Reserved && self.Value == other.Value
    }
}
impl ::std::cmp::Eq for MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {}
unsafe impl ::windows::runtime::Abi for MEMORY_PARTITION_DEDICATED_MEMORY_ATTRIBUTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {
    pub NextEntryOffset: u32,
    pub SizeOfInformation: u32,
    pub Flags: u32,
    pub AttributesOffset: u32,
    pub AttributeCount: u32,
    pub Reserved: u32,
    pub TypeId: u64,
}
impl MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {}
impl ::std::default::Default for MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION")
            .field("NextEntryOffset", &self.NextEntryOffset)
            .field("SizeOfInformation", &self.SizeOfInformation)
            .field("Flags", &self.Flags)
            .field("AttributesOffset", &self.AttributesOffset)
            .field("AttributeCount", &self.AttributeCount)
            .field("Reserved", &self.Reserved)
            .field("TypeId", &self.TypeId)
            .finish()
    }
}
impl ::std::cmp::PartialEq for MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.NextEntryOffset == other.NextEntryOffset && self.SizeOfInformation == other.SizeOfInformation && self.Flags == other.Flags && self.AttributesOffset == other.AttributesOffset && self.AttributeCount == other.AttributeCount && self.Reserved == other.Reserved && self.TypeId == other.TypeId
    }
}
impl ::std::cmp::Eq for MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {}
unsafe impl ::windows::runtime::Abi for MEMORY_PARTITION_DEDICATED_MEMORY_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEMORY_PARTITION_MODIFY_ACCESS: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEMORY_PARTITION_QUERY_ACCESS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEMORY_PRIORITY_LOWEST: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_4MB_PAGES: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct MEM_ADDRESS_REQUIREMENTS {
    pub LowestStartingAddress: *mut ::std::ffi::c_void,
    pub HighestEndingAddress: *mut ::std::ffi::c_void,
    pub Alignment: usize,
}
impl MEM_ADDRESS_REQUIREMENTS {}
impl ::std::default::Default for MEM_ADDRESS_REQUIREMENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MEM_ADDRESS_REQUIREMENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MEM_ADDRESS_REQUIREMENTS").field("LowestStartingAddress", &self.LowestStartingAddress).field("HighestEndingAddress", &self.HighestEndingAddress).field("Alignment", &self.Alignment).finish()
    }
}
impl ::std::cmp::PartialEq for MEM_ADDRESS_REQUIREMENTS {
    fn eq(&self, other: &Self) -> bool {
        self.LowestStartingAddress == other.LowestStartingAddress && self.HighestEndingAddress == other.HighestEndingAddress && self.Alignment == other.Alignment
    }
}
impl ::std::cmp::Eq for MEM_ADDRESS_REQUIREMENTS {}
unsafe impl ::windows::runtime::Abi for MEM_ADDRESS_REQUIREMENTS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_COALESCE_PLACEHOLDERS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MEM_DEDICATED_ATTRIBUTE_TYPE(pub i32);
pub const MemDedicatedAttributeReadBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(0i32);
pub const MemDedicatedAttributeReadLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(1i32);
pub const MemDedicatedAttributeWriteBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(2i32);
pub const MemDedicatedAttributeWriteLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(3i32);
pub const MemDedicatedAttributeMax: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(4i32);
impl ::std::convert::From<i32> for MEM_DEDICATED_ATTRIBUTE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MEM_DEDICATED_ATTRIBUTE_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_DIFFERENT_IMAGE_BASE_OK: u32 = 8388608u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct MEM_EXTENDED_PARAMETER {
    pub Anonymous1: MEM_EXTENDED_PARAMETER_0,
    pub Anonymous2: MEM_EXTENDED_PARAMETER_1,
}
#[cfg(feature = "Win32_Foundation")]
impl MEM_EXTENDED_PARAMETER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MEM_EXTENDED_PARAMETER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MEM_EXTENDED_PARAMETER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MEM_EXTENDED_PARAMETER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MEM_EXTENDED_PARAMETER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MEM_EXTENDED_PARAMETER_0 {
    pub _bitfield: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl MEM_EXTENDED_PARAMETER_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MEM_EXTENDED_PARAMETER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MEM_EXTENDED_PARAMETER_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous1_e__Struct").field("_bitfield", &self._bitfield).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MEM_EXTENDED_PARAMETER_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MEM_EXTENDED_PARAMETER_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MEM_EXTENDED_PARAMETER_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union MEM_EXTENDED_PARAMETER_1 {
    pub ULong64: u64,
    pub Pointer: *mut ::std::ffi::c_void,
    pub Size: usize,
    pub Handle: super::super::Foundation::HANDLE,
    pub ULong: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MEM_EXTENDED_PARAMETER_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MEM_EXTENDED_PARAMETER_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MEM_EXTENDED_PARAMETER_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MEM_EXTENDED_PARAMETER_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MEM_EXTENDED_PARAMETER_1 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_EC_CODE: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_GRAPHICS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_NONPAGED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_NONPAGED_HUGE: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_NONPAGED_LARGE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_SOFT_FAULT_PAGES: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MEM_EXTENDED_PARAMETER_TYPE(pub i32);
pub const MemExtendedParameterInvalidType: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(0i32);
pub const MemExtendedParameterAddressRequirements: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(1i32);
pub const MemExtendedParameterNumaNode: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(2i32);
pub const MemExtendedParameterPartitionHandle: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(3i32);
pub const MemExtendedParameterUserPhysicalHandle: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(4i32);
pub const MemExtendedParameterAttributeFlags: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(5i32);
pub const MemExtendedParameterImageMachine: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(6i32);
pub const MemExtendedParameterMax: MEM_EXTENDED_PARAMETER_TYPE = MEM_EXTENDED_PARAMETER_TYPE(7i32);
impl ::std::convert::From<i32> for MEM_EXTENDED_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MEM_EXTENDED_PARAMETER_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_TYPE_BITS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_EXTENDED_PARAMETER_ZERO_PAGES_OPTIONAL: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_PHYSICAL: u32 = 4194304u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_ROTATE: u32 = 8388608u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MEM_SECTION_EXTENDED_PARAMETER_TYPE(pub i32);
pub const MemSectionExtendedParameterInvalidType: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(0i32);
pub const MemSectionExtendedParameterUserPhysicalFlags: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(1i32);
pub const MemSectionExtendedParameterNumaNode: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(2i32);
pub const MemSectionExtendedParameterSigningLevel: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(3i32);
pub const MemSectionExtendedParameterMax: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(4i32);
impl ::std::convert::From<i32> for MEM_SECTION_EXTENDED_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MEM_SECTION_EXTENDED_PARAMETER_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_TOP_DOWN: u32 = 1048576u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MEM_WRITE_WATCH: u32 = 2097152u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MESSAGE_RESOURCE_UNICODE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MESSAGE_RESOURCE_UTF8: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MINCHAR: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MINLONG: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MINSHORT: u32 = 32768u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MIN_UCSCHAR: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MONITOR_DISPLAY_STATE(pub i32);
pub const PowerMonitorOff: MONITOR_DISPLAY_STATE = MONITOR_DISPLAY_STATE(0i32);
pub const PowerMonitorOn: MONITOR_DISPLAY_STATE = MONITOR_DISPLAY_STATE(1i32);
pub const PowerMonitorDim: MONITOR_DISPLAY_STATE = MONITOR_DISPLAY_STATE(2i32);
impl ::std::convert::From<i32> for MONITOR_DISPLAY_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MONITOR_DISPLAY_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MS_CDDDEVICEBITMAP: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MS_NOTSYSTEMMEMORY: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MS_PPM_SOFTWARE_ALL: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MS_REUSEDDEVICEBITMAP: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MS_SHAREDACCESS: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const MUTANT_QUERY_STATE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NETWORK_APP_INSTANCE_CSV_FLAGS_VALID_ONLY_IF_CSV_COORDINATOR: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NETWORK_APP_INSTANCE_EA {
    pub AppInstanceID: ::windows::runtime::GUID,
    pub CsvFlags: u32,
}
impl NETWORK_APP_INSTANCE_EA {}
impl ::std::default::Default for NETWORK_APP_INSTANCE_EA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NETWORK_APP_INSTANCE_EA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NETWORK_APP_INSTANCE_EA").field("AppInstanceID", &self.AppInstanceID).field("CsvFlags", &self.CsvFlags).finish()
    }
}
impl ::std::cmp::PartialEq for NETWORK_APP_INSTANCE_EA {
    fn eq(&self, other: &Self) -> bool {
        self.AppInstanceID == other.AppInstanceID && self.CsvFlags == other.CsvFlags
    }
}
impl ::std::cmp::Eq for NETWORK_APP_INSTANCE_EA {}
unsafe impl ::windows::runtime::Abi for NETWORK_APP_INSTANCE_EA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NLS_VALID_LOCALE_MASK: u32 = 1048575u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NONVOL_FP_NUMREG_ARM64: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NONVOL_INT_NUMREG_ARM64: u32 = 11u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(4))]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NON_PAGED_DEBUG_INFO {
    pub Signature: u16,
    pub Flags: u16,
    pub Size: u32,
    pub Machine: u16,
    pub Characteristics: u16,
    pub TimeDateStamp: u32,
    pub CheckSum: u32,
    pub SizeOfImage: u32,
    pub ImageBase: u64,
}
impl NON_PAGED_DEBUG_INFO {}
impl ::std::default::Default for NON_PAGED_DEBUG_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for NON_PAGED_DEBUG_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for NON_PAGED_DEBUG_INFO {}
unsafe impl ::windows::runtime::Abi for NON_PAGED_DEBUG_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NON_PAGED_DEBUG_SIGNATURE: u32 = 18766u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NOTIFY_USER_POWER_SETTING {
    pub Guid: ::windows::runtime::GUID,
}
impl NOTIFY_USER_POWER_SETTING {}
impl ::std::default::Default for NOTIFY_USER_POWER_SETTING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NOTIFY_USER_POWER_SETTING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NOTIFY_USER_POWER_SETTING").field("Guid", &self.Guid).finish()
    }
}
impl ::std::cmp::PartialEq for NOTIFY_USER_POWER_SETTING {
    fn eq(&self, other: &Self) -> bool {
        self.Guid == other.Guid
    }
}
impl ::std::cmp::Eq for NOTIFY_USER_POWER_SETTING {}
unsafe impl ::windows::runtime::Abi for NOTIFY_USER_POWER_SETTING {
    type Abi = Self;
}
pub const NO_SUBGROUP_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4272111934, 32261, 18705, [154, 113, 112, 3, 49, 241, 194, 148]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_Diagnostics_Debug`, `Win32_System_Kernel`*"]
pub struct NT_TIB {
    pub ExceptionList: *mut EXCEPTION_REGISTRATION_RECORD,
    pub StackBase: *mut ::std::ffi::c_void,
    pub StackLimit: *mut ::std::ffi::c_void,
    pub SubSystemTib: *mut ::std::ffi::c_void,
    pub Anonymous: NT_TIB_0,
    pub ArbitraryUserPointer: *mut ::std::ffi::c_void,
    pub Self_: *mut NT_TIB,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl NT_TIB {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::default::Default for NT_TIB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::PartialEq for NT_TIB {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::Eq for NT_TIB {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::runtime::Abi for NT_TIB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
pub union NT_TIB_0 {
    pub FiberData: *mut ::std::ffi::c_void,
    pub Version: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl NT_TIB_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::default::Default for NT_TIB_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::PartialEq for NT_TIB_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl ::std::cmp::Eq for NT_TIB_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
unsafe impl ::windows::runtime::Abi for NT_TIB_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NT_TIB32 {
    pub ExceptionList: u32,
    pub StackBase: u32,
    pub StackLimit: u32,
    pub SubSystemTib: u32,
    pub Anonymous: NT_TIB32_0,
    pub ArbitraryUserPointer: u32,
    pub Self_: u32,
}
impl NT_TIB32 {}
impl ::std::default::Default for NT_TIB32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for NT_TIB32 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for NT_TIB32 {}
unsafe impl ::windows::runtime::Abi for NT_TIB32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union NT_TIB32_0 {
    pub FiberData: u32,
    pub Version: u32,
}
impl NT_TIB32_0 {}
impl ::std::default::Default for NT_TIB32_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for NT_TIB32_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for NT_TIB32_0 {}
unsafe impl ::windows::runtime::Abi for NT_TIB32_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NT_TIB64 {
    pub ExceptionList: u64,
    pub StackBase: u64,
    pub StackLimit: u64,
    pub SubSystemTib: u64,
    pub Anonymous: NT_TIB64_0,
    pub ArbitraryUserPointer: u64,
    pub Self_: u64,
}
impl NT_TIB64 {}
impl ::std::default::Default for NT_TIB64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for NT_TIB64 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for NT_TIB64 {}
unsafe impl ::windows::runtime::Abi for NT_TIB64 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub union NT_TIB64_0 {
    pub FiberData: u64,
    pub Version: u32,
}
impl NT_TIB64_0 {}
impl ::std::default::Default for NT_TIB64_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for NT_TIB64_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for NT_TIB64_0 {}
unsafe impl ::windows::runtime::Abi for NT_TIB64_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NUMA_NO_PREFERRED_NODE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const NUM_DISCHARGE_POLICIES: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct NV_MEMORY_RANGE {
    pub BaseAddress: *mut ::std::ffi::c_void,
    pub Length: usize,
}
impl NV_MEMORY_RANGE {}
impl ::std::default::Default for NV_MEMORY_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NV_MEMORY_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NV_MEMORY_RANGE").field("BaseAddress", &self.BaseAddress).field("Length", &self.Length).finish()
    }
}
impl ::std::cmp::PartialEq for NV_MEMORY_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.BaseAddress == other.BaseAddress && self.Length == other.Length
    }
}
impl ::std::cmp::Eq for NV_MEMORY_RANGE {}
unsafe impl ::windows::runtime::Abi for NV_MEMORY_RANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_BTMASK: u32 = 15u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_BTSHFT: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_TMASK: u32 = 48u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_TMASK1: u32 = 192u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_TMASK2: u32 = 240u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const N_TSHIFT: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const OC_BANK_CLIP: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const OPENGL_CMD: u32 = 4352u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const OPENGL_GETINFO: u32 = 4353u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct OS_DEPLOYEMENT_STATE_VALUES(pub i32);
pub const OS_DEPLOYMENT_STANDARD: OS_DEPLOYEMENT_STATE_VALUES = OS_DEPLOYEMENT_STATE_VALUES(1i32);
pub const OS_DEPLOYMENT_COMPACT: OS_DEPLOYEMENT_STATE_VALUES = OS_DEPLOYEMENT_STATE_VALUES(2i32);
impl ::std::convert::From<i32> for OS_DEPLOYEMENT_STATE_VALUES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for OS_DEPLOYEMENT_STATE_VALUES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct PACKEDEVENTINFO {
    pub ulSize: u32,
    pub ulNumEventsForLogFile: u32,
    pub ulOffsets: [u32; 1],
}
impl PACKEDEVENTINFO {}
impl ::std::default::Default for PACKEDEVENTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for PACKEDEVENTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("PACKEDEVENTINFO").field("ulSize", &self.ulSize).field("ulNumEventsForLogFile", &self.ulNumEventsForLogFile).field("ulOffsets", &self.ulOffsets).finish()
    }
}
impl ::std::cmp::PartialEq for PACKEDEVENTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulSize == other.ulSize && self.ulNumEventsForLogFile == other.ulNumEventsForLogFile && self.ulOffsets == other.ulOffsets
    }
}
impl ::std::cmp::Eq for PACKEDEVENTINFO {}
unsafe impl ::windows::runtime::Abi for PACKEDEVENTINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PAL_BGR: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PAL_BITFIELDS: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PAL_CMYK: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PAL_INDEXED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PAL_RGB: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PAPCFUNC = unsafe extern "system" fn(parameter: usize);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_D0_SUPPORTED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_D1_SUPPORTED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_D2_SUPPORTED: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_D3_SUPPORTED: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_WAKE_FROM_D0_SUPPORTED: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_WAKE_FROM_D1_SUPPORTED: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_WAKE_FROM_D2_SUPPORTED: u32 = 64u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_WAKE_FROM_D3_SUPPORTED: u32 = 128u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PDCAP_WARM_EJECT_SUPPORTED: u32 = 256u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PD_BEGINSUBPATH: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PD_BEZIERS: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PD_CLOSEFIGURE: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PD_ENDSUBPATH: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PD_RESETSTYLE: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFORMANCE_DATA_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_DECREASE_MAX: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_IDEAL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_IDEAL_AGGRESSIVE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_INCREASE_MAX: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_ROCKET: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PERFSTATE_POLICY_CHANGE_SINGLE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_System_Diagnostics_Debug`, `Win32_System_Kernel`*"]
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
pub type PEXCEPTION_FILTER = unsafe extern "system" fn(exceptionpointers: *mut super::Diagnostics::Debug::EXCEPTION_POINTERS, establisherframe: *const ::std::ffi::c_void) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFLS_CALLBACK_FUNCTION = unsafe extern "system" fn(lpflsdata: *const ::std::ffi::c_void);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN = unsafe extern "system" fn() -> isize;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFND3DNTPARSEUNKNOWNCOMMAND = unsafe extern "system" fn(lpvcommands: *mut ::std::ffi::c_void, lplpvreturnedcommand: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvAccumulateD3DDirtyRect = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut CDDDXGK_REDIRBITMAPPRESENTINFO) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvAlphaBlend = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::SURFOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut super::super::UI::DisplayDevices::XLATEOBJ, param4: *mut super::super::Foundation::RECTL, param5: *mut super::super::Foundation::RECTL, param6: *mut super::super::UI::DisplayDevices::BLENDOBJ) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvAssertMode = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvAssociateSharedSurface = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: super::super::Foundation::HANDLE, param2: super::super::Foundation::HANDLE, param3: super::super::Foundation::SIZE) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvBitBlt = unsafe extern "system" fn(
    param0: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param1: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param2: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param3: *mut super::super::UI::DisplayDevices::CLIPOBJ,
    param4: *mut super::super::UI::DisplayDevices::XLATEOBJ,
    param5: *mut super::super::Foundation::RECTL,
    param6: *mut super::super::Foundation::POINTL,
    param7: *mut super::super::Foundation::POINTL,
    param8: *mut super::super::UI::DisplayDevices::BRUSHOBJ,
    param9: *mut super::super::Foundation::POINTL,
    param10: u32,
) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvCompletePDEV = unsafe extern "system" fn(param0: DHPDEV, param1: HDEV);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvCopyBits = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::SURFOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut super::super::UI::DisplayDevices::XLATEOBJ, param4: *mut super::super::Foundation::RECTL, param5: *mut super::super::Foundation::POINTL) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub type PFN_DrvCreateDeviceBitmap = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::SIZE, param2: u32) -> super::super::Graphics::Gdi::HBITMAP;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub type PFN_DrvCreateDeviceBitmapEx = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::SIZE, param2: u32, param3: u32, param4: DHSURF, param5: u32, param6: u32, param7: *mut super::super::Foundation::HANDLE) -> super::super::Graphics::Gdi::HBITMAP;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDeleteDeviceBitmap = unsafe extern "system" fn(param0: DHSURF);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDeleteDeviceBitmapEx = unsafe extern "system" fn(param0: DHSURF);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvDeriveSurface = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::DD_DIRECTDRAW_GLOBAL, param1: *mut super::super::UI::DisplayDevices::DD_SURFACE_LOCAL) -> super::super::Graphics::Gdi::HBITMAP;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_OpenGL`*"]
#[cfg(feature = "Win32_Graphics_OpenGL")]
pub type PFN_DrvDescribePixelFormat = unsafe extern "system" fn(param0: DHPDEV, param1: i32, param2: u32, param3: *mut super::super::Graphics::OpenGL::PIXELFORMATDESCRIPTOR) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvDestroyFont = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::FONTOBJ);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDisableDirectDraw = unsafe extern "system" fn(param0: DHPDEV);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDisableDriver = unsafe extern "system" fn();
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDisablePDEV = unsafe extern "system" fn(param0: DHPDEV);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDisableSurface = unsafe extern "system" fn(param0: DHPDEV);
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvDitherColor = unsafe extern "system" fn(param0: DHPDEV, param1: u32, param2: u32, param3: *mut u32) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvDrawEscape = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: u32, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut super::super::Foundation::RECTL, param4: u32, param5: *mut ::std::ffi::c_void) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEnableDirectDraw = unsafe extern "system" fn(param0: DHPDEV, param1: *mut ::std::mem::ManuallyDrop<super::super::UI::DisplayDevices::DD_CALLBACKS>, param2: *mut ::std::mem::ManuallyDrop<super::super::UI::DisplayDevices::DD_SURFACECALLBACKS>, param3: *mut ::std::mem::ManuallyDrop<super::super::UI::DisplayDevices::DD_PALETTECALLBACKS>) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEnableDriver = unsafe extern "system" fn(param0: u32, param1: u32, param2: *mut super::super::UI::DisplayDevices::DRVENABLEDATA) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEnablePDEV = unsafe extern "system" fn(param0: *mut super::super::Graphics::Gdi::DEVMODEW, param1: super::super::Foundation::PWSTR, param2: u32, param3: *mut super::super::UI::DisplayDevices::HSURF, param4: u32, param5: *mut super::super::UI::DisplayDevices::GDIINFO, param6: u32, param7: *mut super::super::UI::DisplayDevices::DEVINFO, param8: HDEV, param9: super::super::Foundation::PWSTR, param10: super::super::Foundation::HANDLE) -> DHPDEV;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_UI_DisplayDevices`*"]
#[cfg(feature = "Win32_UI_DisplayDevices")]
pub type PFN_DrvEnableSurface = unsafe extern "system" fn(param0: DHPDEV) -> super::super::UI::DisplayDevices::HSURF;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEndDoc = unsafe extern "system" fn(pso: *mut super::super::UI::DisplayDevices::SURFOBJ, fl: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEndDxInterop = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: super::super::Foundation::BOOL, param2: *mut super::super::Foundation::BOOL, kernelmodedevicehandle: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvEscape = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: u32, param2: u32, param3: *mut ::std::ffi::c_void, param4: u32, param5: *mut ::std::ffi::c_void) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvFillPath = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::PATHOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param4: *mut super::super::Foundation::POINTL, param5: u32, param6: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvFontManagement = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::FONTOBJ, param2: u32, param3: u32, param4: *mut ::std::ffi::c_void, param5: u32, param6: *mut ::std::ffi::c_void) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvFree = unsafe extern "system" fn(param0: *mut ::std::ffi::c_void, param1: usize);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Devices_Display`, `Win32_Foundation`, `Win32_Graphics_DirectDraw`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Devices_Display", feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvGetDirectDrawInfo = unsafe extern "system" fn(param0: DHPDEV, param1: *mut ::std::mem::ManuallyDrop<super::super::UI::DisplayDevices::DD_HALINFO>, param2: *mut u32, param3: *mut super::super::UI::DisplayDevices::VIDEOMEMORY, param4: *mut u32, param5: *mut u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvGetGlyphMode = unsafe extern "system" fn(dhpdev: DHPDEV, pfo: *mut super::super::UI::DisplayDevices::FONTOBJ) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub type PFN_DrvGetModes = unsafe extern "system" fn(param0: super::super::Foundation::HANDLE, param1: u32, param2: *mut super::super::Graphics::Gdi::DEVMODEW) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvGetTrueTypeFile = unsafe extern "system" fn(param0: usize, param1: *mut u32) -> *mut ::std::ffi::c_void;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvGradientFill = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::CLIPOBJ, param2: *mut super::super::UI::DisplayDevices::XLATEOBJ, param3: *mut super::super::Graphics::Gdi::TRIVERTEX, param4: u32, param5: *mut ::std::ffi::c_void, param6: u32, param7: *mut super::super::Foundation::RECTL, param8: *mut super::super::Foundation::POINTL, param9: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvIcmCheckBitmapBits = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::HANDLE, param2: *mut super::super::UI::DisplayDevices::SURFOBJ, param3: *mut u8) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_ColorSystem`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_ColorSystem"))]
pub type PFN_DrvIcmCreateColorTransform = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::UI::ColorSystem::LOGCOLORSPACEW, param2: *mut ::std::ffi::c_void, param3: u32, param4: *mut ::std::ffi::c_void, param5: u32, param6: *mut ::std::ffi::c_void, param7: u32, param8: u32) -> super::super::Foundation::HANDLE;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvIcmDeleteColorTransform = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvIcmSetDeviceGammaRamp = unsafe extern "system" fn(param0: DHPDEV, param1: u32, param2: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvLineTo = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::CLIPOBJ, param2: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param3: i32, param4: i32, param5: i32, param6: i32, param7: *mut super::super::Foundation::RECTL, param8: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
pub type PFN_DrvLoadFontFile = unsafe extern "system" fn(param0: u32, param1: *mut usize, param2: *mut *mut ::std::ffi::c_void, param3: *mut u32, param4: *mut super::super::Graphics::Gdi::DESIGNVECTOR, param5: u32, param6: u32) -> usize;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvLockDisplayArea = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::Foundation::RECTL);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvMovePointer = unsafe extern "system" fn(pso: *mut super::super::UI::DisplayDevices::SURFOBJ, x: i32, y: i32, prcl: *mut super::super::Foundation::RECTL);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvNextBand = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, ppointl: *mut super::super::Foundation::POINTL) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvNotify = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: u32, param2: *mut ::std::ffi::c_void);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvPaint = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::CLIPOBJ, param2: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param3: *mut super::super::Foundation::POINTL, param4: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvPlgBlt = unsafe extern "system" fn(
    param0: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param1: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param2: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param3: *mut super::super::UI::DisplayDevices::CLIPOBJ,
    param4: *mut super::super::UI::DisplayDevices::XLATEOBJ,
    param5: *mut super::super::Graphics::Gdi::COLORADJUSTMENT,
    param6: *mut super::super::Foundation::POINTL,
    param7: *mut POINTFIX,
    param8: *mut super::super::Foundation::RECTL,
    param9: *mut super::super::Foundation::POINTL,
    param10: u32,
) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryAdvanceWidths = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::UI::DisplayDevices::FONTOBJ, param2: u32, param3: *mut u32, param4: *mut ::std::ffi::c_void, param5: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryDeviceSupport = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::XLATEOBJ, param2: *mut XFORMOBJ, param3: u32, param4: u32, param5: *mut ::std::ffi::c_void, param6: u32, param7: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryFont = unsafe extern "system" fn(param0: DHPDEV, param1: usize, param2: u32, param3: *mut usize) -> *mut super::super::UI::DisplayDevices::IFIMETRICS;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvQueryFontCaps = unsafe extern "system" fn(param0: u32, param1: *mut u32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryFontData = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::UI::DisplayDevices::FONTOBJ, param2: u32, param3: u32, param4: *mut super::super::UI::DisplayDevices::GLYPHDATA, param5: *mut ::std::ffi::c_void, param6: u32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvQueryFontFile = unsafe extern "system" fn(param0: usize, param1: u32, param2: u32, param3: *mut u32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvQueryFontTree = unsafe extern "system" fn(param0: DHPDEV, param1: usize, param2: u32, param3: u32, param4: *mut usize) -> *mut ::std::ffi::c_void;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryPerBandInfo = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::PERBANDINFO) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvQuerySpoolType = unsafe extern "system" fn(dhpdev: DHPDEV, pwchtype: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvQueryTrueTypeOutline = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::UI::DisplayDevices::FONTOBJ, param2: u32, param3: super::super::Foundation::BOOL, param4: *mut super::super::UI::DisplayDevices::GLYPHDATA, param5: u32, param6: *mut super::super::Graphics::Gdi::TTPOLYGONHEADER) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvQueryTrueTypeSection = unsafe extern "system" fn(param0: u32, param1: u32, param2: u32, param3: *mut super::super::Foundation::HANDLE, param4: *mut i32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvQueryTrueTypeTable = unsafe extern "system" fn(param0: usize, param1: u32, param2: u32, param3: i32, param4: u32, param5: *mut u8, param6: *mut *mut u8, param7: *mut u32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvRealizeBrush = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param1: *mut super::super::UI::DisplayDevices::SURFOBJ, param2: *mut super::super::UI::DisplayDevices::SURFOBJ, param3: *mut super::super::UI::DisplayDevices::SURFOBJ, param4: *mut super::super::UI::DisplayDevices::XLATEOBJ, param5: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvRenderHint = unsafe extern "system" fn(dhpdev: DHPDEV, notifycode: u32, length: usize, data: *const ::std::ffi::c_void) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PFN_DrvResetDevice = unsafe extern "system" fn(param0: DHPDEV, param1: *mut ::std::ffi::c_void) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvResetPDEV = unsafe extern "system" fn(dhpdevold: DHPDEV, dhpdevnew: DHPDEV) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSaveScreenBits = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: u32, param2: usize, param3: *mut super::super::Foundation::RECTL) -> usize;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSendPage = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSetPalette = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::UI::DisplayDevices::PALOBJ, param2: u32, param3: u32, param4: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSetPixelFormat = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: i32, param2: super::super::Foundation::HWND) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSetPointerShape = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::SURFOBJ, param2: *mut super::super::UI::DisplayDevices::SURFOBJ, param3: *mut super::super::UI::DisplayDevices::XLATEOBJ, param4: i32, param5: i32, param6: i32, param7: i32, param8: *mut super::super::Foundation::RECTL, param9: u32) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStartBanding = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, ppointl: *mut super::super::Foundation::POINTL) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStartDoc = unsafe extern "system" fn(pso: *mut super::super::UI::DisplayDevices::SURFOBJ, pwszdocname: super::super::Foundation::PWSTR, dwjobid: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStartDxInterop = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: super::super::Foundation::BOOL, kernelmodedevicehandle: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStartPage = unsafe extern "system" fn(pso: *mut super::super::UI::DisplayDevices::SURFOBJ) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStretchBlt = unsafe extern "system" fn(
    param0: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param1: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param2: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param3: *mut super::super::UI::DisplayDevices::CLIPOBJ,
    param4: *mut super::super::UI::DisplayDevices::XLATEOBJ,
    param5: *mut super::super::Graphics::Gdi::COLORADJUSTMENT,
    param6: *mut super::super::Foundation::POINTL,
    param7: *mut super::super::Foundation::RECTL,
    param8: *mut super::super::Foundation::RECTL,
    param9: *mut super::super::Foundation::POINTL,
    param10: u32,
) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStretchBltROP = unsafe extern "system" fn(
    param0: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param1: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param2: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param3: *mut super::super::UI::DisplayDevices::CLIPOBJ,
    param4: *mut super::super::UI::DisplayDevices::XLATEOBJ,
    param5: *mut super::super::Graphics::Gdi::COLORADJUSTMENT,
    param6: *mut super::super::Foundation::POINTL,
    param7: *mut super::super::Foundation::RECTL,
    param8: *mut super::super::Foundation::RECTL,
    param9: *mut super::super::Foundation::POINTL,
    param10: u32,
    param11: *mut super::super::UI::DisplayDevices::BRUSHOBJ,
    param12: u32,
) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStrokeAndFillPath =
    unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::PATHOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut XFORMOBJ, param4: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param5: *mut super::super::UI::DisplayDevices::LINEATTRS, param6: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param7: *mut super::super::Foundation::POINTL, param8: u32, param9: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvStrokePath = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::PATHOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut XFORMOBJ, param4: *mut super::super::UI::DisplayDevices::BRUSHOBJ, param5: *mut super::super::Foundation::POINTL, param6: *mut super::super::UI::DisplayDevices::LINEATTRS, param7: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvSurfaceComplete = unsafe extern "system" fn(param0: DHPDEV, param1: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSwapBuffers = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::WNDOBJ) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvSynchronize = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::Foundation::RECTL);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvSynchronizeRedirectionBitmaps = unsafe extern "system" fn(param0: DHPDEV, param1: *mut u64) -> super::super::Foundation::NTSTATUS;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvSynchronizeSurface = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::Foundation::RECTL, param2: u32);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvTextOut = unsafe extern "system" fn(
    param0: *mut super::super::UI::DisplayDevices::SURFOBJ,
    param1: *mut super::super::UI::DisplayDevices::STROBJ,
    param2: *mut super::super::UI::DisplayDevices::FONTOBJ,
    param3: *mut super::super::UI::DisplayDevices::CLIPOBJ,
    param4: *mut super::super::Foundation::RECTL,
    param5: *mut super::super::Foundation::RECTL,
    param6: *mut super::super::UI::DisplayDevices::BRUSHOBJ,
    param7: *mut super::super::UI::DisplayDevices::BRUSHOBJ,
    param8: *mut super::super::Foundation::POINTL,
    param9: u32,
) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`, `Win32_UI_DisplayDevices`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub type PFN_DrvTransparentBlt = unsafe extern "system" fn(param0: *mut super::super::UI::DisplayDevices::SURFOBJ, param1: *mut super::super::UI::DisplayDevices::SURFOBJ, param2: *mut super::super::UI::DisplayDevices::CLIPOBJ, param3: *mut super::super::UI::DisplayDevices::XLATEOBJ, param4: *mut super::super::Foundation::RECTL, param5: *mut super::super::Foundation::RECTL, param6: u32, param7: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvUnloadFontFile = unsafe extern "system" fn(param0: usize) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_DrvUnlockDisplayArea = unsafe extern "system" fn(param0: DHPDEV, param1: *mut super::super::Foundation::RECTL);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngCombineRgn = unsafe extern "system" fn(hrgntrg: super::super::Foundation::HANDLE, hrgnsrc1: super::super::Foundation::HANDLE, hrgnsrc2: super::super::Foundation::HANDLE, imode: i32) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngCopyRgn = unsafe extern "system" fn(hrgndst: super::super::Foundation::HANDLE, hrgnsrc: super::super::Foundation::HANDLE) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngCreateRectRgn = unsafe extern "system" fn(left: i32, top: i32, right: i32, bottom: i32) -> super::super::Foundation::HANDLE;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngDeleteRgn = unsafe extern "system" fn(hrgn: super::super::Foundation::HANDLE);
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngIntersectRgn = unsafe extern "system" fn(hrgnresult: super::super::Foundation::HANDLE, hrgna: super::super::Foundation::HANDLE, hrgnb: super::super::Foundation::HANDLE) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngSubtractRgn = unsafe extern "system" fn(hrgnresult: super::super::Foundation::HANDLE, hrgna: super::super::Foundation::HANDLE, hrgnb: super::super::Foundation::HANDLE) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngUnionRgn = unsafe extern "system" fn(hrgnresult: super::super::Foundation::HANDLE, hrgna: super::super::Foundation::HANDLE, hrgnb: super::super::Foundation::HANDLE) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_EngXorRgn = unsafe extern "system" fn(hrgnresult: super::super::Foundation::HANDLE, hrgna: super::super::Foundation::HANDLE, hrgnb: super::super::Foundation::HANDLE) -> i32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_ALPHA_BYTE_INSTRUCTIONS: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_ARM_NEON_INSTRUCTIONS_AVAILABLE: u32 = 19u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_ARM_V82_DP_INSTRUCTIONS_AVAILABLE: u32 = 43u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_ARM_V83_JSCVT_INSTRUCTIONS_AVAILABLE: u32 = 44u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_AVX2_INSTRUCTIONS_AVAILABLE: u32 = 40u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_AVX512F_INSTRUCTIONS_AVAILABLE: u32 = 41u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_AVX_INSTRUCTIONS_AVAILABLE: u32 = 39u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_ERMS_AVAILABLE: u32 = 42u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_MONITORX_INSTRUCTION_AVAILABLE: u32 = 35u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_NON_TEMPORAL_LEVEL_ALL: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_PPC_MOVEMEM_64BIT_OK: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_RDPID_INSTRUCTION_AVAILABLE: u32 = 33u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_RDRAND_INSTRUCTION_AVAILABLE: u32 = 28u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_RDTSCP_INSTRUCTION_AVAILABLE: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_SSE4_1_INSTRUCTIONS_AVAILABLE: u32 = 37u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_SSE4_2_INSTRUCTIONS_AVAILABLE: u32 = 38u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_SSE_DAZ_MODE_AVAILABLE: u32 = 11u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_SSSE3_INSTRUCTIONS_AVAILABLE: u32 = 36u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_TEMPORAL_LEVEL_1: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_TEMPORAL_LEVEL_2: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PF_TEMPORAL_LEVEL_3: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[cfg(any(target_arch = "aarch64",))]
pub type PGET_RUNTIME_FUNCTION_CALLBACK = unsafe extern "system" fn(controlpc: u64, context: *const ::std::ffi::c_void) -> *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[cfg(any(target_arch = "x86_64",))]
pub type PGET_RUNTIME_FUNCTION_CALLBACK = unsafe extern "system" fn(controlpc: u64, context: *const ::std::ffi::c_void) -> *mut IMAGE_RUNTIME_FUNCTION_ENTRY;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub type PIMAGE_TLS_CALLBACK = unsafe extern "system" fn(dllhandle: *mut ::std::ffi::c_void, reason: u32, reserved: *mut ::std::ffi::c_void);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POINTE {
    pub x: f32,
    pub y: f32,
}
impl POINTE {}
impl ::std::default::Default for POINTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POINTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POINTE").field("x", &self.x).field("y", &self.y).finish()
    }
}
impl ::std::cmp::PartialEq for POINTE {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for POINTE {}
unsafe impl ::windows::runtime::Abi for POINTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POINTFIX {
    pub x: i32,
    pub y: i32,
}
impl POINTFIX {}
impl ::std::default::Default for POINTFIX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POINTFIX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POINTFIX").field("x", &self.x).field("y", &self.y).finish()
    }
}
impl ::std::cmp::PartialEq for POINTFIX {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for POINTFIX {}
unsafe impl ::windows::runtime::Abi for POINTFIX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POINTQF {
    pub x: i64,
    pub y: i64,
}
impl POINTQF {}
impl ::std::default::Default for POINTQF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POINTQF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POINTQF").field("x", &self.x).field("y", &self.y).finish()
    }
}
impl ::std::cmp::PartialEq for POINTQF {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for POINTQF {}
unsafe impl ::windows::runtime::Abi for POINTQF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POLICY_AUDIT_SUBCATEGORY_COUNT: u32 = 59u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(any(target_arch = "aarch64",))]
#[cfg(feature = "Win32_Foundation")]
pub type POUT_OF_PROCESS_FUNCTION_TABLE_CALLBACK = unsafe extern "system" fn(process: super::super::Foundation::HANDLE, tableaddress: *const ::std::ffi::c_void, entries: *mut u32, functions: *mut *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
#[cfg(any(target_arch = "x86_64",))]
#[cfg(feature = "Win32_Foundation")]
pub type POUT_OF_PROCESS_FUNCTION_TABLE_CALLBACK = unsafe extern "system" fn(process: super::super::Foundation::HANDLE, tableaddress: *const ::std::ffi::c_void, entries: *mut u32, functions: *mut *mut IMAGE_RUNTIME_FUNCTION_ENTRY) -> u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_INDEX_HIBERNATE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_INDEX_NOTHING: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_INDEX_SHUTDOWN: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_INDEX_SLEEP: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_INDEX_TURN_OFF_THE_DISPLAY: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_VALUE_HIBERNATE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_VALUE_NOTHING: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_VALUE_SHUTDOWN: u32 = 6u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_VALUE_SLEEP: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWERBUTTON_ACTION_VALUE_TURN_OFF_THE_DISPLAY: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_ACPI_CRITICAL: u32 = 16777216u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_ACPI_USER_NOTIFY: u32 = 33554432u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_CRITICAL: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_DIRECTED_DRIPS: u32 = 67108864u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_DISABLE_WAKES: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_DOZE_TO_HIBERNATE: u32 = 32u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_HIBERBOOT: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_LIGHTEST_FIRST: u32 = 268435456u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_LOCK_CONSOLE: u32 = 536870912u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_OVERRIDE_APPS: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_PSEUDO_TRANSITION: u32 = 134217728u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_QUERY_ALLOWED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_UI_ALLOWED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_ACTION_USER_NOTIFY: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_CONNECTIVITY_IN_STANDBY_DISABLED: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_CONNECTIVITY_IN_STANDBY_ENABLED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_CONNECTIVITY_IN_STANDBY_SYSTEM_MANAGED: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_DEVICE_IDLE_POLICY_CONSERVATIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_DEVICE_IDLE_POLICY_PERFORMANCE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_DISCONNECTED_STANDBY_MODE_AGGRESSIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_DISCONNECTED_STANDBY_MODE_NORMAL: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POWER_IDLE_RESILIENCY {
    pub CoalescingTimeout: u32,
    pub IdleResiliencyPeriod: u32,
}
impl POWER_IDLE_RESILIENCY {}
impl ::std::default::Default for POWER_IDLE_RESILIENCY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POWER_IDLE_RESILIENCY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_IDLE_RESILIENCY").field("CoalescingTimeout", &self.CoalescingTimeout).field("IdleResiliencyPeriod", &self.IdleResiliencyPeriod).finish()
    }
}
impl ::std::cmp::PartialEq for POWER_IDLE_RESILIENCY {
    fn eq(&self, other: &Self) -> bool {
        self.CoalescingTimeout == other.CoalescingTimeout && self.IdleResiliencyPeriod == other.IdleResiliencyPeriod
    }
}
impl ::std::cmp::Eq for POWER_IDLE_RESILIENCY {}
unsafe impl ::windows::runtime::Abi for POWER_IDLE_RESILIENCY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_INFORMATION_LEVEL(pub i32);
pub const SystemPowerPolicyAc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(0i32);
pub const SystemPowerPolicyDc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(1i32);
pub const VerifySystemPolicyAc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(2i32);
pub const VerifySystemPolicyDc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(3i32);
pub const SystemPowerCapabilities: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(4i32);
pub const SystemBatteryState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(5i32);
pub const SystemPowerStateHandler: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(6i32);
pub const ProcessorStateHandler: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(7i32);
pub const SystemPowerPolicyCurrent: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(8i32);
pub const AdministratorPowerPolicy: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(9i32);
pub const SystemReserveHiberFile: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(10i32);
pub const ProcessorInformation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(11i32);
pub const SystemPowerInformation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(12i32);
pub const ProcessorStateHandler2: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(13i32);
pub const LastWakeTime: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(14i32);
pub const LastSleepTime: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(15i32);
pub const SystemExecutionState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(16i32);
pub const SystemPowerStateNotifyHandler: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(17i32);
pub const ProcessorPowerPolicyAc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(18i32);
pub const ProcessorPowerPolicyDc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(19i32);
pub const VerifyProcessorPowerPolicyAc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(20i32);
pub const VerifyProcessorPowerPolicyDc: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(21i32);
pub const ProcessorPowerPolicyCurrent: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(22i32);
pub const SystemPowerStateLogging: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(23i32);
pub const SystemPowerLoggingEntry: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(24i32);
pub const SetPowerSettingValue: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(25i32);
pub const NotifyUserPowerSetting: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(26i32);
pub const PowerInformationLevelUnused0: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(27i32);
pub const SystemMonitorHiberBootPowerOff: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(28i32);
pub const SystemVideoState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(29i32);
pub const TraceApplicationPowerMessage: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(30i32);
pub const TraceApplicationPowerMessageEnd: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(31i32);
pub const ProcessorPerfStates: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(32i32);
pub const ProcessorIdleStates: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(33i32);
pub const ProcessorCap: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(34i32);
pub const SystemWakeSource: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(35i32);
pub const SystemHiberFileInformation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(36i32);
pub const TraceServicePowerMessage: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(37i32);
pub const ProcessorLoad: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(38i32);
pub const PowerShutdownNotification: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(39i32);
pub const MonitorCapabilities: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(40i32);
pub const SessionPowerInit: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(41i32);
pub const SessionDisplayState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(42i32);
pub const PowerRequestCreate: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(43i32);
pub const PowerRequestAction: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(44i32);
pub const GetPowerRequestList: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(45i32);
pub const ProcessorInformationEx: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(46i32);
pub const NotifyUserModeLegacyPowerEvent: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(47i32);
pub const GroupPark: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(48i32);
pub const ProcessorIdleDomains: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(49i32);
pub const WakeTimerList: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(50i32);
pub const SystemHiberFileSize: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(51i32);
pub const ProcessorIdleStatesHv: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(52i32);
pub const ProcessorPerfStatesHv: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(53i32);
pub const ProcessorPerfCapHv: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(54i32);
pub const ProcessorSetIdle: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(55i32);
pub const LogicalProcessorIdling: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(56i32);
pub const UserPresence: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(57i32);
pub const PowerSettingNotificationName: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(58i32);
pub const GetPowerSettingValue: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(59i32);
pub const IdleResiliency: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(60i32);
pub const SessionRITState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(61i32);
pub const SessionConnectNotification: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(62i32);
pub const SessionPowerCleanup: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(63i32);
pub const SessionLockState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(64i32);
pub const SystemHiberbootState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(65i32);
pub const PlatformInformation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(66i32);
pub const PdcInvocation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(67i32);
pub const MonitorInvocation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(68i32);
pub const FirmwareTableInformationRegistered: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(69i32);
pub const SetShutdownSelectedTime: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(70i32);
pub const SuspendResumeInvocation: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(71i32);
pub const PlmPowerRequestCreate: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(72i32);
pub const ScreenOff: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(73i32);
pub const CsDeviceNotification: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(74i32);
pub const PlatformRole: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(75i32);
pub const LastResumePerformance: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(76i32);
pub const DisplayBurst: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(77i32);
pub const ExitLatencySamplingPercentage: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(78i32);
pub const RegisterSpmPowerSettings: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(79i32);
pub const PlatformIdleStates: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(80i32);
pub const ProcessorIdleVeto: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(81i32);
pub const PlatformIdleVeto: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(82i32);
pub const SystemBatteryStatePrecise: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(83i32);
pub const ThermalEvent: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(84i32);
pub const PowerRequestActionInternal: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(85i32);
pub const BatteryDeviceState: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(86i32);
pub const PowerInformationInternal: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(87i32);
pub const ThermalStandby: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(88i32);
pub const SystemHiberFileType: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(89i32);
pub const PhysicalPowerButtonPress: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(90i32);
pub const QueryPotentialDripsConstraint: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(91i32);
pub const EnergyTrackerCreate: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(92i32);
pub const EnergyTrackerQuery: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(93i32);
pub const UpdateBlackBoxRecorder: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(94i32);
pub const SessionAllowExternalDmaDevices: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(95i32);
pub const SendSuspendResumeNotification: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(96i32);
pub const PowerInformationLevelMaximum: POWER_INFORMATION_LEVEL = POWER_INFORMATION_LEVEL(97i32);
impl ::std::convert::From<i32> for POWER_INFORMATION_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_INFORMATION_LEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_MONITOR_INVOCATION {
    pub Console: super::super::Foundation::BOOLEAN,
    pub RequestReason: POWER_MONITOR_REQUEST_REASON,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_MONITOR_INVOCATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_MONITOR_INVOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_MONITOR_INVOCATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_MONITOR_INVOCATION").field("Console", &self.Console).field("RequestReason", &self.RequestReason).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_MONITOR_INVOCATION {
    fn eq(&self, other: &Self) -> bool {
        self.Console == other.Console && self.RequestReason == other.RequestReason
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_MONITOR_INVOCATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_MONITOR_INVOCATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_MONITOR_REQUEST_REASON(pub i32);
pub const MonitorRequestReasonUnknown: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(0i32);
pub const MonitorRequestReasonPowerButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(1i32);
pub const MonitorRequestReasonRemoteConnection: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(2i32);
pub const MonitorRequestReasonScMonitorpower: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(3i32);
pub const MonitorRequestReasonUserInput: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(4i32);
pub const MonitorRequestReasonAcDcDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(5i32);
pub const MonitorRequestReasonUserDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(6i32);
pub const MonitorRequestReasonPoSetSystemState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(7i32);
pub const MonitorRequestReasonSetThreadExecutionState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(8i32);
pub const MonitorRequestReasonFullWake: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(9i32);
pub const MonitorRequestReasonSessionUnlock: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(10i32);
pub const MonitorRequestReasonScreenOffRequest: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(11i32);
pub const MonitorRequestReasonIdleTimeout: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(12i32);
pub const MonitorRequestReasonPolicyChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(13i32);
pub const MonitorRequestReasonSleepButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(14i32);
pub const MonitorRequestReasonLid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(15i32);
pub const MonitorRequestReasonBatteryCountChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(16i32);
pub const MonitorRequestReasonGracePeriod: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(17i32);
pub const MonitorRequestReasonPnP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(18i32);
pub const MonitorRequestReasonDP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(19i32);
pub const MonitorRequestReasonSxTransition: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(20i32);
pub const MonitorRequestReasonSystemIdle: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(21i32);
pub const MonitorRequestReasonNearProximity: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(22i32);
pub const MonitorRequestReasonThermalStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(23i32);
pub const MonitorRequestReasonResumePdc: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(24i32);
pub const MonitorRequestReasonResumeS4: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(25i32);
pub const MonitorRequestReasonTerminal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(26i32);
pub const MonitorRequestReasonPdcSignal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(27i32);
pub const MonitorRequestReasonAcDcDisplayBurstSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(28i32);
pub const MonitorRequestReasonSystemStateEntered: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(29i32);
pub const MonitorRequestReasonWinrt: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(30i32);
pub const MonitorRequestReasonUserInputKeyboard: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(31i32);
pub const MonitorRequestReasonUserInputMouse: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(32i32);
pub const MonitorRequestReasonUserInputTouchpad: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(33i32);
pub const MonitorRequestReasonUserInputPen: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(34i32);
pub const MonitorRequestReasonUserInputAccelerometer: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(35i32);
pub const MonitorRequestReasonUserInputHid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(36i32);
pub const MonitorRequestReasonUserInputPoUserPresent: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(37i32);
pub const MonitorRequestReasonUserInputSessionSwitch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(38i32);
pub const MonitorRequestReasonUserInputInitialization: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(39i32);
pub const MonitorRequestReasonPdcSignalWindowsMobilePwrNotif: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(40i32);
pub const MonitorRequestReasonPdcSignalWindowsMobileShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(41i32);
pub const MonitorRequestReasonPdcSignalHeyCortana: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(42i32);
pub const MonitorRequestReasonPdcSignalHolographicShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(43i32);
pub const MonitorRequestReasonPdcSignalFingerprint: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(44i32);
pub const MonitorRequestReasonDirectedDrips: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(45i32);
pub const MonitorRequestReasonDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(46i32);
pub const MonitorRequestReasonBuiltinPanel: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(47i32);
pub const MonitorRequestReasonDisplayRequiredUnDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(48i32);
pub const MonitorRequestReasonBatteryCountChangeSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(49i32);
pub const MonitorRequestReasonResumeModernStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(50i32);
pub const MonitorRequestReasonTerminalInit: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(51i32);
pub const MonitorRequestReasonPdcSignalSensorsHumanPresence: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(52i32);
pub const MonitorRequestReasonBatteryPreCritical: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(53i32);
pub const MonitorRequestReasonUserInputTouch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(54i32);
pub const MonitorRequestReasonMax: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(55i32);
impl ::std::convert::From<i32> for POWER_MONITOR_REQUEST_REASON {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_MONITOR_REQUEST_REASON {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_MONITOR_REQUEST_TYPE(pub i32);
pub const MonitorRequestTypeOff: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(0i32);
pub const MonitorRequestTypeOnAndPresent: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(1i32);
pub const MonitorRequestTypeToggleOn: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(2i32);
impl ::std::convert::From<i32> for POWER_MONITOR_REQUEST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_MONITOR_REQUEST_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_PLATFORM_INFORMATION {
    pub AoAc: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_PLATFORM_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_PLATFORM_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_PLATFORM_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_PLATFORM_INFORMATION").field("AoAc", &self.AoAc).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_PLATFORM_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.AoAc == other.AoAc
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_PLATFORM_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_PLATFORM_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_REQUEST_CONTEXT_FLAGS(pub u32);
pub const POWER_REQUEST_CONTEXT_DETAILED_STRING: POWER_REQUEST_CONTEXT_FLAGS = POWER_REQUEST_CONTEXT_FLAGS(2u32);
pub const POWER_REQUEST_CONTEXT_SIMPLE_STRING: POWER_REQUEST_CONTEXT_FLAGS = POWER_REQUEST_CONTEXT_FLAGS(1u32);
impl ::std::convert::From<u32> for POWER_REQUEST_CONTEXT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_REQUEST_CONTEXT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for POWER_REQUEST_CONTEXT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for POWER_REQUEST_CONTEXT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for POWER_REQUEST_CONTEXT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for POWER_REQUEST_CONTEXT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for POWER_REQUEST_CONTEXT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_REQUEST_CONTEXT_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_REQUEST_TYPE(pub i32);
pub const PowerRequestDisplayRequired: POWER_REQUEST_TYPE = POWER_REQUEST_TYPE(0i32);
pub const PowerRequestSystemRequired: POWER_REQUEST_TYPE = POWER_REQUEST_TYPE(1i32);
pub const PowerRequestAwayModeRequired: POWER_REQUEST_TYPE = POWER_REQUEST_TYPE(2i32);
pub const PowerRequestExecutionRequired: POWER_REQUEST_TYPE = POWER_REQUEST_TYPE(3i32);
impl ::std::convert::From<i32> for POWER_REQUEST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_REQUEST_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {
    pub IsAllowed: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES").field("IsAllowed", &self.IsAllowed).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {
    fn eq(&self, other: &Self) -> bool {
        self.IsAllowed == other.IsAllowed
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_SESSION_ALLOW_EXTERNAL_DMA_DEVICES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_SESSION_CONNECT {
    pub Connected: super::super::Foundation::BOOLEAN,
    pub Console: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_SESSION_CONNECT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_SESSION_CONNECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_SESSION_CONNECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_SESSION_CONNECT").field("Connected", &self.Connected).field("Console", &self.Console).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_SESSION_CONNECT {
    fn eq(&self, other: &Self) -> bool {
        self.Connected == other.Connected && self.Console == other.Console
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_SESSION_CONNECT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_SESSION_CONNECT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_SESSION_RIT_STATE {
    pub Active: super::super::Foundation::BOOLEAN,
    pub LastInputTime: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_SESSION_RIT_STATE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_SESSION_RIT_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_SESSION_RIT_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_SESSION_RIT_STATE").field("Active", &self.Active).field("LastInputTime", &self.LastInputTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_SESSION_RIT_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Active == other.Active && self.LastInputTime == other.LastInputTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_SESSION_RIT_STATE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_SESSION_RIT_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POWER_SESSION_TIMEOUTS {
    pub InputTimeout: u32,
    pub DisplayTimeout: u32,
}
impl POWER_SESSION_TIMEOUTS {}
impl ::std::default::Default for POWER_SESSION_TIMEOUTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POWER_SESSION_TIMEOUTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_SESSION_TIMEOUTS").field("InputTimeout", &self.InputTimeout).field("DisplayTimeout", &self.DisplayTimeout).finish()
    }
}
impl ::std::cmp::PartialEq for POWER_SESSION_TIMEOUTS {
    fn eq(&self, other: &Self) -> bool {
        self.InputTimeout == other.InputTimeout && self.DisplayTimeout == other.DisplayTimeout
    }
}
impl ::std::cmp::Eq for POWER_SESSION_TIMEOUTS {}
unsafe impl ::windows::runtime::Abi for POWER_SESSION_TIMEOUTS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_SystemServices`, `Win32_Foundation`*"]
pub struct POWER_SESSION_WINLOGON {
    pub SessionId: u32,
    pub Console: super::super::Foundation::BOOLEAN,
    pub Locked: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl POWER_SESSION_WINLOGON {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for POWER_SESSION_WINLOGON {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for POWER_SESSION_WINLOGON {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_SESSION_WINLOGON").field("SessionId", &self.SessionId).field("Console", &self.Console).field("Locked", &self.Locked).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for POWER_SESSION_WINLOGON {
    fn eq(&self, other: &Self) -> bool {
        self.SessionId == other.SessionId && self.Console == other.Console && self.Locked == other.Locked
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for POWER_SESSION_WINLOGON {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for POWER_SESSION_WINLOGON {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_SETTING_ALTITUDE(pub i32);
pub const ALTITUDE_GROUP_POLICY: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(0i32);
pub const ALTITUDE_USER: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(1i32);
pub const ALTITUDE_RUNTIME_OVERRIDE: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(2i32);
pub const ALTITUDE_PROVISIONING: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(3i32);
pub const ALTITUDE_OEM_CUSTOMIZATION: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(4i32);
pub const ALTITUDE_INTERNAL_OVERRIDE: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(5i32);
pub const ALTITUDE_OS_DEFAULT: POWER_SETTING_ALTITUDE = POWER_SETTING_ALTITUDE(6i32);
impl ::std::convert::From<i32> for POWER_SETTING_ALTITUDE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_SETTING_ALTITUDE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_SETTING_VALUE_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_SYSTEM_MAXIMUM: u32 = 7u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const POWER_USER_NOTIFY_FORCED_SHUTDOWN: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub struct POWER_USER_PRESENCE {
    pub UserPresence: POWER_USER_PRESENCE_TYPE,
}
impl POWER_USER_PRESENCE {}
impl ::std::default::Default for POWER_USER_PRESENCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for POWER_USER_PRESENCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("POWER_USER_PRESENCE").field("UserPresence", &self.UserPresence).finish()
    }
}
impl ::std::cmp::PartialEq for POWER_USER_PRESENCE {
    fn eq(&self, other: &Self) -> bool {
        self.UserPresence == other.UserPresence
    }
}
impl ::std::cmp::Eq for POWER_USER_PRESENCE {}
unsafe impl ::windows::runtime::Abi for POWER_USER_PRESENCE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct POWER_USER_PRESENCE_TYPE(pub i32);
pub const UserNotPresent: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(0i32);
pub const UserPresent: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(1i32);
pub const UserUnknown: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(255i32);
impl ::std::convert::From<i32> for POWER_USER_PRESENCE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for POWER_USER_PRESENCE_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_ALL_INTEGERS: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_BEZIERS: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_ELLIPSE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_ENUM_AS_INTEGERS: u32 = 8u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_THROTTLE_ADAPTIVE: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_THROTTLE_CONSTANT: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_THROTTLE_DEGRADE: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_THROTTLE_MAXIMUM: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_THROTTLE_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PO_WIDENED: u32 = 16u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_BGR_ORDER_HORIZONTAL_STRIPES: u32 = 5u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_BGR_ORDER_VERTICAL_STRIPES: u32 = 3u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_RGB_ORDER_HORIZONTAL_STRIPES: u32 = 4u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_RGB_ORDER_VERTICAL_STRIPES: u32 = 2u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPC_UNDEFINED: u32 = 1u32;
#[doc = "*Required features: `Win32_System_SystemServices`*"]
pub const PPG_DEFAULT: u32 = 