#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_ATTRIBUTE(pub i32);
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(0i32);
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(1i32);
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(2i32);
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(3i32);
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(4i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(5i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(6i32);
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(7i32);
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(8i32);
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(9i32);
impl ::std::convert::From<i32> for AMSI_ATTRIBUTE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMSI_ATTRIBUTE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_RESULT(pub i32);
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = AMSI_RESULT(0i32);
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = AMSI_RESULT(1i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = AMSI_RESULT(16384i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = AMSI_RESULT(20479i32);
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = AMSI_RESULT(32768i32);
impl ::std::convert::From<i32> for AMSI_RESULT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMSI_RESULT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_MSI_ACTION(pub i32);
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(0i32);
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(1i32);
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(2i32);
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(3i32);
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(4i32);
impl ::std::convert::From<i32> for AMSI_UAC_MSI_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMSI_UAC_MSI_ACTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: super::super::Foundation::PWSTR,
    pub lpwszSourceURL: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_AX_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMSI_UAC_REQUEST_AX_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_AX_INFO").field("ulLength", &self.ulLength).field("lpwszLocalInstallPath", &self.lpwszLocalInstallPath).field("lpwszSourceURL", &self.lpwszSourceURL).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_AX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszLocalInstallPath == other.lpwszLocalInstallPath && self.lpwszSourceURL == other.lpwszSourceURL
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_AX_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: super::super::Foundation::PWSTR,
    pub lpwszRequestor: super::super::Foundation::PWSTR,
    pub Clsid: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_COM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMSI_UAC_REQUEST_COM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_COM_INFO").field("ulLength", &self.ulLength).field("lpwszServerBinary", &self.lpwszServerBinary).field("lpwszRequestor", &self.lpwszRequestor).field("Clsid", &self.Clsid).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_COM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszServerBinary == other.lpwszServerBinary && self.lpwszRequestor == other.lpwszRequestor && self.Clsid == other.Clsid
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_COM_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_CONTEXT_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpwszDLLParameter: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_EXE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMSI_UAC_REQUEST_EXE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_EXE_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpwszDLLParameter", &self.lpwszDLLParameter).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_EXE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpwszDLLParameter == other.lpwszDLLParameter
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_EXE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: super::super::Foundation::PWSTR,
    pub lpwszVersion: super::super::Foundation::PWSTR,
    pub lpwszLanguage: super::super::Foundation::PWSTR,
    pub lpwszManufacturer: super::super::Foundation::PWSTR,
    pub lpwszPackagePath: super::super::Foundation::PWSTR,
    pub lpwszPackageSource: super::super::Foundation::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut super::super::Foundation::PWSTR,
    pub ppwszUpdateSources: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_MSI_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMSI_UAC_REQUEST_MSI_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_MSI_INFO")
            .field("ulLength", &self.ulLength)
            .field("MsiAction", &self.MsiAction)
            .field("lpwszProductName", &self.lpwszProductName)
            .field("lpwszVersion", &self.lpwszVersion)
            .field("lpwszLanguage", &self.lpwszLanguage)
            .field("lpwszManufacturer", &self.lpwszManufacturer)
            .field("lpwszPackagePath", &self.lpwszPackagePath)
            .field("lpwszPackageSource", &self.lpwszPackageSource)
            .field("ulUpdates", &self.ulUpdates)
            .field("ppwszUpdates", &self.ppwszUpdates)
            .field("ppwszUpdateSources", &self.ppwszUpdateSources)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_MSI_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength
            && self.MsiAction == other.MsiAction
            && self.lpwszProductName == other.lpwszProductName
            && self.lpwszVersion == other.lpwszVersion
            && self.lpwszLanguage == other.lpwszLanguage
            && self.lpwszManufacturer == other.lpwszManufacturer
            && self.lpwszPackagePath == other.lpwszPackagePath
            && self.lpwszPackageSource == other.lpwszPackageSource
            && self.ulUpdates == other.ulUpdates
            && self.ppwszUpdates == other.ppwszUpdates
            && self.ppwszUpdateSources == other.ppwszUpdateSources
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_MSI_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpPackageFamilyName: super::super::Foundation::PWSTR,
    pub lpApplicationId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMSI_UAC_REQUEST_PACKAGED_APP_INFO")
            .field("ulLength", &self.ulLength)
            .field("lpwszApplicationName", &self.lpwszApplicationName)
            .field("lpwszCommandLine", &self.lpwszCommandLine)
            .field("lpPackageFamilyName", &self.lpPackageFamilyName)
            .field("lpApplicationId", &self.lpApplicationId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpPackageFamilyName == other.lpPackageFamilyName && self.lpApplicationId == other.lpApplicationId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_REQUEST_TYPE(pub i32);
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(0i32);
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(1i32);
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(2i32);
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(3i32);
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(4i32);
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(5i32);
impl ::std::convert::From<i32> for AMSI_UAC_REQUEST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMSI_UAC_REQUEST_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMSI_UAC_TRUST_STATE(pub i32);
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(0i32);
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(1i32);
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(2i32);
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(3i32);
impl ::std::convert::From<i32> for AMSI_UAC_TRUST_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMSI_UAC_TRUST_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[inline]
pub unsafe fn AmsiCloseSession<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::runtime::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, amsisession: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiCloseSession(amsicontext: HAMSICONTEXT, amsisession: HAMSISESSION);
        }
        ::std::mem::transmute(AmsiCloseSession(amsicontext.into_param().abi(), amsisession.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiInitialize<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(appname: Param0) -> ::windows::runtime::Result<HAMSICONTEXT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiInitialize(appname: super::super::Foundation::PWSTR, amsicontext: *mut HAMSICONTEXT) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <HAMSICONTEXT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        AmsiInitialize(appname.into_param().abi(), &mut result__).from_abi::<HAMSICONTEXT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiNotifyOperation<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(amsicontext: Param0, buffer: *const ::std::ffi::c_void, length: u32, contentname: Param3) -> ::windows::runtime::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiNotifyOperation(amsicontext: HAMSICONTEXT, buffer: *const ::std::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        AmsiNotifyOperation(amsicontext.into_param().abi(), ::std::mem::transmute(buffer), ::std::mem::transmute(length), contentname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[inline]
pub unsafe fn AmsiOpenSession<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) -> ::windows::runtime::Result<HAMSISESSION> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiOpenSession(amsicontext: HAMSICONTEXT, amsisession: *mut HAMSISESSION) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <HAMSISESSION as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        AmsiOpenSession(amsicontext.into_param().abi(), &mut result__).from_abi::<HAMSISESSION>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanBuffer<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, buffer: *const ::std::ffi::c_void, length: u32, contentname: Param3, amsisession: Param4) -> ::windows::runtime::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanBuffer(amsicontext: HAMSICONTEXT, buffer: *const ::std::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        AmsiScanBuffer(amsicontext.into_param().abi(), ::std::mem::transmute(buffer), ::std::mem::transmute(length), contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AmsiScanString<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, HAMSISESSION>>(amsicontext: Param0, string: Param1, contentname: Param2, amsisession: Param3) -> ::windows::runtime::Result<AMSI_RESULT> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiScanString(amsicontext: HAMSICONTEXT, string: super::super::Foundation::PWSTR, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        AmsiScanString(amsicontext.into_param().abi(), string.into_param().abi(), contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[inline]
pub unsafe fn AmsiUninitialize<'a, Param0: ::windows::runtime::IntoParam<'a, HAMSICONTEXT>>(amsicontext: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AmsiUninitialize(amsicontext: HAMSICONTEXT);
        }
        ::std::mem::transmute(AmsiUninitialize(amsicontext.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const CAntimalware: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4256173650, 41492, 19105, [143, 186, 67, 87, 187, 0, 114, 236]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HAMSICONTEXT(pub isize);
impl ::std::default::Default for HAMSICONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HAMSICONTEXT {}
unsafe impl ::windows::runtime::Abi for HAMSICONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HAMSISESSION(pub isize);
impl ::std::default::Default for HAMSISESSION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HAMSISESSION {}
unsafe impl ::windows::runtime::Abi for HAMSISESSION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAmsiStream(pub ::windows::runtime::IUnknown);
impl IAmsiStream {
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(attribute), ::std::mem::transmute(datasize), ::std::mem::transmute(data), ::std::mem::transmute(retdata)).ok()
    }
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn Read(&self, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(position), ::std::mem::transmute(size), ::std::mem::transmute(buffer), ::std::mem::transmute(readsize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAmsiStream {
    type Vtable = IAmsiStream_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1044902629, 33236, 19771, [137, 127, 84, 80, 150, 119, 3, 115]);
}
impl ::std::convert::From<IAmsiStream> for ::windows::runtime::IUnknown {
    fn from(value: IAmsiStream) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAmsiStream> for ::windows::runtime::IUnknown {
    fn from(value: &IAmsiStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAmsiStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAmsiStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmsiStream_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAntimalware(pub ::windows::runtime::IUnknown);
impl IAntimalware {
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn Scan<'a, Param0: ::windows::runtime::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::std::option::Option<IAntimalwareProvider>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), stream.into_param().abi(), ::std::mem::transmute(result), ::std::mem::transmute(provider)).ok()
    }
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(session)))
    }
}
unsafe impl ::windows::runtime::Interface for IAntimalware {
    type Vtable = IAntimalware_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2194840622, 61538, 17638, [181, 201, 61, 154, 47, 36, 162, 223]);
}
impl ::std::convert::From<IAntimalware> for ::windows::runtime::IUnknown {
    fn from(value: IAntimalware) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAntimalware> for ::windows::runtime::IUnknown {
    fn from(value: &IAntimalware) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAntimalware {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAntimalware {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stream: ::windows::runtime::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, session: u64),
);
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAntimalware2(pub ::windows::runtime::IUnknown);
impl IAntimalware2 {
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn Scan<'a, Param0: ::windows::runtime::IntoParam<'a, IAmsiStream>>(&self, stream: Param0, result: *mut AMSI_RESULT, provider: *mut ::std::option::Option<IAntimalwareProvider>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), stream.into_param().abi(), ::std::mem::transmute(result), ::std::mem::transmute(provider)).ok()
    }
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn Notify<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::std::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::runtime::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAntimalware2 {
    type Vtable = IAntimalware2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(806368693, 11586, 20310, [140, 101, 45, 202, 167, 251, 60, 220]);
}
impl ::std::convert::From<IAntimalware2> for ::windows::runtime::IUnknown {
    fn from(value: IAntimalware2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAntimalware2> for ::windows::runtime::IUnknown {
    fn from(value: &IAntimalware2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAntimalware2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAntimalware2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAntimalware2> for IAntimalware {
    fn from(value: IAntimalware2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAntimalware2> for IAntimalware {
    fn from(value: &IAntimalware2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAntimalware> for IAntimalware2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAntimalware> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAntimalware> for &IAntimalware2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAntimalware> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stream: ::windows::runtime::RawPtr, result: *mut AMSI_RESULT, provider: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *const ::std::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAntimalwareProvider(pub ::windows::runtime::IUnknown);
impl IAntimalwareProvider {
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn Scan<'a, Param0: ::windows::runtime::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::runtime::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), stream.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAntimalwareProvider {
    type Vtable = IAntimalwareProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2999631843, 65028, 17073, [165, 223, 8, 212, 131, 212, 209, 37]);
}
impl ::std::convert::From<IAntimalwareProvider> for ::windows::runtime::IUnknown {
    fn from(value: IAntimalwareProvider) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAntimalwareProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IAntimalwareProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAntimalwareProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAntimalwareProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stream: ::windows::runtime::RawPtr, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAntimalwareProvider2(pub ::windows::runtime::IUnknown);
impl IAntimalwareProvider2 {
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn Scan<'a, Param0: ::windows::runtime::IntoParam<'a, IAmsiStream>>(&self, stream: Param0) -> ::windows::runtime::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), stream.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[doc = "*Required features: `Win32_System_Antimalware`*"]
    pub unsafe fn CloseSession(&self, session: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(session)))
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn Notify<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, buffer: *const ::std::ffi::c_void, length: u32, contentname: Param2, appname: Param3) -> ::windows::runtime::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(length), contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAntimalwareProvider2 {
    type Vtable = IAntimalwareProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2082366832, 16243, 19983, [138, 212, 152, 185, 76, 211, 41, 15]);
}
impl ::std::convert::From<IAntimalwareProvider2> for ::windows::runtime::IUnknown {
    fn from(value: IAntimalwareProvider2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAntimalwareProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &IAntimalwareProvider2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: IAntimalwareProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAntimalwareProvider2> for IAntimalwareProvider {
    fn from(value: &IAntimalwareProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAntimalwareProvider> for IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAntimalwareProvider> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAntimalwareProvider> for &IAntimalwareProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAntimalwareProvider> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stream: ::windows::runtime::RawPtr, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, session: u64),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *const ::std::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, appname: super::super::Foundation::PWSTR, presult: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_System_Antimalware`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAntimalwareUacProvider(pub ::windows::runtime::IUnknown);
impl IAntimalwareUacProvider {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> ::windows::runtime::Result<AMSI_RESULT> {
        let mut result__: <AMSI_RESULT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(context), &mut result__).from_abi::<AMSI_RESULT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAntimalwareUacProvider {
    type Vtable = IAntimalwareUacProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2999631844, 65028, 17073, [165, 223, 8, 212, 131, 212, 209, 37]);
}
impl ::std::convert::From<IAntimalwareUacProvider> for ::windows::runtime::IUnknown {
    fn from(value: IAntimalwareUacProvider) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAntimalwareUacProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IAntimalwareUacProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAntimalwareUacProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareUacProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, context: *const AMSI_UAC_REQUEST_CONTEXT, result: *mut AMSI_RESULT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, displayname: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_System_Antimalware`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn InstallELAMCertificateInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(elamfile: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn InstallELAMCertificateInfo(elamfile: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(InstallELAMCertificateInfo(elamfile.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
