#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[cfg(feature = "Win32_Security_Cryptography_Catalog")]
pub mod Catalog;
#[cfg(feature = "Win32_Security_Cryptography_Certificates")]
pub mod Certificates;
#[cfg(feature = "Win32_Security_Cryptography_Sip")]
pub mod Sip;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ACTION_REVOCATION_DEFAULT_CACHE: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ACTION_REVOCATION_DEFAULT_ONLINE: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_ALL: u32 = 57344u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_DATA_ENCRYPT: u32 = 24576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_HASH: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_KEY_EXCHANGE: u32 = 40960u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_MSG_ENCRYPT: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_CLASS_SIGNATURE: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_3DES: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_3DES_112: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_AES: u32 = 17u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_AES_128: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_AES_192: u32 = 15u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_AES_256: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_AGREED_KEY_ANY: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_CAST: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_CYLINK_MEK: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DES: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DESX: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DH_EPHEM: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DH_SANDF: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DSS_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DSS_DMS: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_DSS_PKCS: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_ECDH: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_ECDH_EPHEM: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_ECDSA: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_ECMQV: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_EXAMPLE: u32 = 80u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_HASH_REPLACE_OWF: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_HMAC: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_IDEA: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_KEA: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_MAC: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_MD2: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_MD4: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_MD5: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_PCT1_MASTER: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RC2: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RC4: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RC5: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RIPEMD: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RIPEMD160: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RSA_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RSA_ENTRUST: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RSA_MSATWORK: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RSA_PGP: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_RSA_PKCS: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SAFERSK128: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SAFERSK64: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SCHANNEL_ENC_KEY: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SCHANNEL_MAC_KEY: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SCHANNEL_MASTER_HASH: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SEAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SHA: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SHA1: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SHA_256: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SHA_384: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SHA_512: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SKIPJACK: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SSL2_MASTER: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SSL3SHAMD5: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_SSL3_MASTER: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_TEK: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_THIRDPARTY_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_TLS1PRF: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_SID_TLS1_MASTER: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_BLOCK: u32 = 1536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_DH: u32 = 2560u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_DSS: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_ECDH: u32 = 3584u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_RSA: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_SECURECHANNEL: u32 = 3072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_STREAM: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const ALG_TYPE_THIRDPARTY: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_CARD_DELETE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070017i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_CARD_IMPORT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070018i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_CARD_WRITTEN: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070016i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_SERVICE_IDLE_STOP: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070022i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_STORE_DELETE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070021i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_STORE_EXPORT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070020i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const AUDIT_STORE_IMPORT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(1074070019i32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub pSignerInfo: *mut CMSG_SIGNER_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("pSignerInfo", &self.pSignerInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.pSignerInfo == other.pSignerInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    pub cbSize: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS").field("cbSize", &self.cbSize).field("fCommercial", &self.fCommercial).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.fCommercial == other.fCommercial
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("fCommercial", &self.fCommercial).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.fCommercial == other.fCommercial
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_CA_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_END_ENTITY_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPTBUFFER_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_112_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(369u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_112_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(401u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_112_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(385u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(321u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(353u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_3DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(337u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(417u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_CCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(465u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(449u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_CMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(257u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(433u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_GCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(481u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AES_GMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(273u32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_ALGORITHM_IDENTIFIER {
    pub pszName: super::super::Foundation::PWSTR,
    pub dwClass: u32,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_ALGORITHM_IDENTIFIER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_ALGORITHM_IDENTIFIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_ALGORITHM_IDENTIFIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_ALGORITHM_IDENTIFIER").field("pszName", &self.pszName).field("dwClass", &self.dwClass).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_ALGORITHM_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.pszName == other.pszName && self.dwClass == other.dwClass && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_ALGORITHM_IDENTIFIER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_ALGORITHM_IDENTIFIER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct BCRYPT_ALG_HANDLE(pub isize);
impl ::std::default::Default for BCRYPT_ALG_HANDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for BCRYPT_ALG_HANDLE {}
unsafe impl ::windows::runtime::Abi for BCRYPT_ALG_HANDLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    pub cbSize: u32,
    pub dwInfoVersion: u32,
    pub pbNonce: *mut u8,
    pub cbNonce: u32,
    pub pbAuthData: *mut u8,
    pub cbAuthData: u32,
    pub pbTag: *mut u8,
    pub cbTag: u32,
    pub pbMacContext: *mut u8,
    pub cbMacContext: u32,
    pub cbAAD: u32,
    pub cbData: u64,
    pub dwFlags: u32,
}
impl BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
impl ::std::default::Default for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO")
            .field("cbSize", &self.cbSize)
            .field("dwInfoVersion", &self.dwInfoVersion)
            .field("pbNonce", &self.pbNonce)
            .field("cbNonce", &self.cbNonce)
            .field("pbAuthData", &self.pbAuthData)
            .field("cbAuthData", &self.cbAuthData)
            .field("pbTag", &self.pbTag)
            .field("cbTag", &self.cbTag)
            .field("pbMacContext", &self.pbMacContext)
            .field("cbMacContext", &self.cbMacContext)
            .field("cbAAD", &self.cbAAD)
            .field("cbData", &self.cbData)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwInfoVersion == other.dwInfoVersion && self.pbNonce == other.pbNonce && self.cbNonce == other.cbNonce && self.pbAuthData == other.pbAuthData && self.cbAuthData == other.cbAuthData && self.pbTag == other.pbTag && self.cbTag == other.cbTag && self.pbMacContext == other.pbMacContext && self.cbMacContext == other.cbMacContext && self.cbAAD == other.cbAAD && self.cbData == other.cbData && self.dwFlags == other.dwFlags
    }
}
impl ::std::cmp::Eq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
unsafe impl ::windows::runtime::Abi for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AUTH_MODE_CHAIN_CALLS_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_AUTH_MODE_IN_PROGRESS_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_BLOCK_PADDING: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_BUFFERS_LOCKED_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_CAPI_AES_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_CAPI_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(801u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_CHACHA20_POLY1305_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(929u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DESX_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(545u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DESX_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(577u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DESX_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(561u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(497u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(529u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(513u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(641u32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DH_KEY_BLOB {
    pub dwMagic: BCRYPT_DH_KEY_BLOB_MAGIC,
    pub cbKey: u32,
}
impl BCRYPT_DH_KEY_BLOB {}
impl ::std::default::Default for BCRYPT_DH_KEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DH_KEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DH_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DH_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl ::std::cmp::Eq for BCRYPT_DH_KEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DH_KEY_BLOB {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_DH_KEY_BLOB_MAGIC(pub u32);
pub const BCRYPT_DH_PUBLIC_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1112557636u32);
pub const BCRYPT_DH_PRIVATE_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1448101956u32);
impl ::std::convert::From<u32> for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_DH_KEY_BLOB_MAGIC {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_DH_KEY_BLOB_MAGIC {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_DH_KEY_BLOB_MAGIC {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_DH_KEY_BLOB_MAGIC {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DH_PARAMETERS_MAGIC: u32 = 1297107012u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DH_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
}
impl BCRYPT_DH_PARAMETER_HEADER {}
impl ::std::default::Default for BCRYPT_DH_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DH_PARAMETER_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DH_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DH_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength
    }
}
impl ::std::cmp::Eq for BCRYPT_DH_PARAMETER_HEADER {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DH_PARAMETER_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(721u32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DSA_KEY_BLOB {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl BCRYPT_DSA_KEY_BLOB {}
impl ::std::default::Default for BCRYPT_DSA_KEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DSA_KEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DSA_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DSA_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl ::std::cmp::Eq for BCRYPT_DSA_KEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DSA_KEY_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DSA_KEY_BLOB_V2 {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl BCRYPT_DSA_KEY_BLOB_V2 {}
impl ::std::default::Default for BCRYPT_DSA_KEY_BLOB_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DSA_KEY_BLOB_V2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DSA_KEY_BLOB_V2")
            .field("dwMagic", &self.dwMagic)
            .field("cbKey", &self.cbKey)
            .field("hashAlgorithm", &self.hashAlgorithm)
            .field("standardVersion", &self.standardVersion)
            .field("cbSeedLength", &self.cbSeedLength)
            .field("cbGroupSize", &self.cbGroupSize)
            .field("Count", &self.Count)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DSA_KEY_BLOB_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for BCRYPT_DSA_KEY_BLOB_V2 {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DSA_KEY_BLOB_V2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_DSA_MAGIC(pub u32);
pub const BCRYPT_DSA_PUBLIC_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1112560452u32);
pub const BCRYPT_DSA_PRIVATE_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1448104772u32);
impl ::std::convert::From<u32> for BCRYPT_DSA_MAGIC {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_DSA_MAGIC {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_DSA_MAGIC {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_DSA_MAGIC {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_DSA_MAGIC {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_DSA_MAGIC {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_DSA_MAGIC {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DSA_PARAMETERS_MAGIC: u32 = 1297109828u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DSA_PARAMETERS_MAGIC_V2: u32 = 843927620u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DSA_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl BCRYPT_DSA_PARAMETER_HEADER {}
impl ::std::default::Default for BCRYPT_DSA_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DSA_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DSA_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl ::std::cmp::Eq for BCRYPT_DSA_PARAMETER_HEADER {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DSA_PARAMETER_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_DSA_PARAMETER_HEADER_V2 {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl BCRYPT_DSA_PARAMETER_HEADER_V2 {}
impl ::std::default::Default for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_DSA_PARAMETER_HEADER_V2")
            .field("cbLength", &self.cbLength)
            .field("dwMagic", &self.dwMagic)
            .field("cbKeyLength", &self.cbKeyLength)
            .field("hashAlgorithm", &self.hashAlgorithm)
            .field("standardVersion", &self.standardVersion)
            .field("cbSeedLength", &self.cbSeedLength)
            .field("cbGroupSize", &self.cbGroupSize)
            .field("Count", &self.Count)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for BCRYPT_DSA_PARAMETER_HEADER_V2 {}
unsafe impl ::windows::runtime::Abi for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DSA_PRIVATE_MAGIC_V2: u32 = 844517444u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_DSA_PUBLIC_MAGIC_V2: u32 = 843206724u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_ECCFULLKEY_BLOB {
    pub dwMagic: u32,
    pub dwVersion: u32,
    pub dwCurveType: ECC_CURVE_TYPE_ENUM,
    pub dwCurveGenerationAlgId: ECC_CURVE_ALG_ID_ENUM,
    pub cbFieldLength: u32,
    pub cbSubgroupOrder: u32,
    pub cbCofactor: u32,
    pub cbSeed: u32,
}
impl BCRYPT_ECCFULLKEY_BLOB {}
impl ::std::default::Default for BCRYPT_ECCFULLKEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_ECCFULLKEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_ECCFULLKEY_BLOB")
            .field("dwMagic", &self.dwMagic)
            .field("dwVersion", &self.dwVersion)
            .field("dwCurveType", &self.dwCurveType)
            .field("dwCurveGenerationAlgId", &self.dwCurveGenerationAlgId)
            .field("cbFieldLength", &self.cbFieldLength)
            .field("cbSubgroupOrder", &self.cbSubgroupOrder)
            .field("cbCofactor", &self.cbCofactor)
            .field("cbSeed", &self.cbSeed)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_ECCFULLKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.dwVersion == other.dwVersion && self.dwCurveType == other.dwCurveType && self.dwCurveGenerationAlgId == other.dwCurveGenerationAlgId && self.cbFieldLength == other.cbFieldLength && self.cbSubgroupOrder == other.cbSubgroupOrder && self.cbCofactor == other.cbCofactor && self.cbSeed == other.cbSeed
    }
}
impl ::std::cmp::Eq for BCRYPT_ECCFULLKEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_ECCFULLKEY_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_ECCKEY_BLOB {
    pub dwMagic: u32,
    pub cbKey: u32,
}
impl BCRYPT_ECCKEY_BLOB {}
impl ::std::default::Default for BCRYPT_ECCKEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_ECCKEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_ECCKEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_ECCKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl ::std::cmp::Eq for BCRYPT_ECCKEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_ECCKEY_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_ECC_CURVE_NAMES {
    pub dwEccCurveNames: u32,
    pub pEccCurveNames: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_ECC_CURVE_NAMES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_ECC_CURVE_NAMES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_ECC_CURVE_NAMES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_ECC_CURVE_NAMES").field("dwEccCurveNames", &self.dwEccCurveNames).field("pEccCurveNames", &self.pEccCurveNames).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_ECC_CURVE_NAMES {
    fn eq(&self, other: &Self) -> bool {
        self.dwEccCurveNames == other.dwEccCurveNames && self.pEccCurveNames == other.pEccCurveNames
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_ECC_CURVE_NAMES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_ECC_CURVE_NAMES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECC_FULLKEY_BLOB_V1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECC_PARAMETERS_MAGIC: u32 = 1346585413u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(657u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(673u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(689u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(705u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PRIVATE_GENERIC_MAGIC: u32 = 1447772997u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PRIVATE_P256_MAGIC: u32 = 843793221u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PRIVATE_P384_MAGIC: u32 = 877347653u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PRIVATE_P521_MAGIC: u32 = 910902085u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PUBLIC_GENERIC_MAGIC: u32 = 1347109701u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PUBLIC_P256_MAGIC: u32 = 827016005u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PUBLIC_P384_MAGIC: u32 = 860570437u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDH_PUBLIC_P521_MAGIC: u32 = 894124869u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(241u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(737u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(753u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(769u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PRIVATE_GENERIC_MAGIC: u32 = 1447314245u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PRIVATE_P256_MAGIC: u32 = 844317509u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PRIVATE_P384_MAGIC: u32 = 877871941u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PRIVATE_P521_MAGIC: u32 = 911426373u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PUBLIC_GENERIC_MAGIC: u32 = 1346650949u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PUBLIC_P256_MAGIC: u32 = 827540293u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PUBLIC_P384_MAGIC: u32 = 861094725u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ECDSA_PUBLIC_P521_MAGIC: u32 = 894649157u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_ENABLE_INCOMPATIBLE_FIPS_CHECKS: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_EXTENDED_KEYSIZE: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_GENERATE_IV: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HASH_INTERFACE_MAJORVERSION_2: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_HASH_OPERATION_TYPE(pub i32);
pub const BCRYPT_HASH_OPERATION_HASH_DATA: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(1i32);
pub const BCRYPT_HASH_OPERATION_FINISH_HASH: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(2i32);
impl ::std::convert::From<i32> for BCRYPT_HASH_OPERATION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_HASH_OPERATION_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HKDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(913u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(289u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(305u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(145u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(161u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(177u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(193u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_HMAC_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(209u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_INTERFACE(pub u32);
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(3u32);
pub const BCRYPT_CIPHER_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(1u32);
pub const BCRYPT_HASH_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(2u32);
pub const BCRYPT_RNG_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(6u32);
pub const BCRYPT_SECRET_AGREEMENT_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(4u32);
pub const BCRYPT_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(5u32);
pub const NCRYPT_KEY_STORAGE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65537u32);
pub const NCRYPT_SCHANNEL_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65538u32);
pub const NCRYPT_SCHANNEL_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65539u32);
impl ::std::convert::From<u32> for BCRYPT_INTERFACE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_INTERFACE {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_INTERFACE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_INTERFACE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_INTERFACE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_INTERFACE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_INTERFACE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_INTERFACE_VERSION {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
}
impl BCRYPT_INTERFACE_VERSION {}
impl ::std::default::Default for BCRYPT_INTERFACE_VERSION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_INTERFACE_VERSION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_INTERFACE_VERSION").field("MajorVersion", &self.MajorVersion).field("MinorVersion", &self.MinorVersion).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_INTERFACE_VERSION {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion
    }
}
impl ::std::cmp::Eq for BCRYPT_INTERFACE_VERSION {}
unsafe impl ::windows::runtime::Abi for BCRYPT_INTERFACE_VERSION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_KEY_BLOB {
    pub Magic: u32,
}
impl BCRYPT_KEY_BLOB {}
impl ::std::default::Default for BCRYPT_KEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_KEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_KEY_BLOB").field("Magic", &self.Magic).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.Magic == other.Magic
    }
}
impl ::std::cmp::Eq for BCRYPT_KEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_KEY_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_KEY_DATA_BLOB_HEADER {
    pub dwMagic: u32,
    pub dwVersion: u32,
    pub cbKeyData: u32,
}
impl BCRYPT_KEY_DATA_BLOB_HEADER {}
impl ::std::default::Default for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_KEY_DATA_BLOB_HEADER").field("dwMagic", &self.dwMagic).field("dwVersion", &self.dwVersion).field("cbKeyData", &self.cbKeyData).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.dwVersion == other.dwVersion && self.cbKeyData == other.cbKeyData
    }
}
impl ::std::cmp::Eq for BCRYPT_KEY_DATA_BLOB_HEADER {}
unsafe impl ::windows::runtime::Abi for BCRYPT_KEY_DATA_BLOB_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_DATA_BLOB_MAGIC: u32 = 1296188491u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_DATA_BLOB_VERSION1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_DERIVATION_INTERFACE: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_DERIVATION_OPERATION: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct BCRYPT_KEY_HANDLE(pub isize);
impl ::std::default::Default for BCRYPT_KEY_HANDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for BCRYPT_KEY_HANDLE {}
unsafe impl ::windows::runtime::Abi for BCRYPT_KEY_HANDLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_KEY_LENGTHS_STRUCT {
    pub dwMinLength: u32,
    pub dwMaxLength: u32,
    pub dwIncrement: u32,
}
impl BCRYPT_KEY_LENGTHS_STRUCT {}
impl ::std::default::Default for BCRYPT_KEY_LENGTHS_STRUCT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_KEY_LENGTHS_STRUCT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_KEY_LENGTHS_STRUCT").field("dwMinLength", &self.dwMinLength).field("dwMaxLength", &self.dwMaxLength).field("dwIncrement", &self.dwIncrement).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_KEY_LENGTHS_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.dwMinLength == other.dwMinLength && self.dwMaxLength == other.dwMaxLength && self.dwIncrement == other.dwIncrement
    }
}
impl ::std::cmp::Eq for BCRYPT_KEY_LENGTHS_STRUCT {}
unsafe impl ::windows::runtime::Abi for BCRYPT_KEY_LENGTHS_STRUCT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_VALIDATION_RANGE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_VALIDATION_RANGE_AND_ORDER: u32 = 24u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_KEY_VALIDATION_REGENERATE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(1u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(17u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(33u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_MULTI_FLAG: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_MULTI_HASH_OPERATION {
    pub iHash: u32,
    pub hashOperation: BCRYPT_HASH_OPERATION_TYPE,
    pub pbBuffer: *mut u8,
    pub cbBuffer: u32,
}
impl BCRYPT_MULTI_HASH_OPERATION {}
impl ::std::default::Default for BCRYPT_MULTI_HASH_OPERATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_MULTI_HASH_OPERATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_MULTI_HASH_OPERATION").field("iHash", &self.iHash).field("hashOperation", &self.hashOperation).field("pbBuffer", &self.pbBuffer).field("cbBuffer", &self.cbBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_MULTI_HASH_OPERATION {
    fn eq(&self, other: &Self) -> bool {
        self.iHash == other.iHash && self.hashOperation == other.hashOperation && self.pbBuffer == other.pbBuffer && self.cbBuffer == other.cbBuffer
    }
}
impl ::std::cmp::Eq for BCRYPT_MULTI_HASH_OPERATION {}
unsafe impl ::windows::runtime::Abi for BCRYPT_MULTI_HASH_OPERATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    pub cbPerObject: u32,
    pub cbPerElement: u32,
}
impl BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {}
impl ::std::default::Default for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_MULTI_OBJECT_LENGTH_STRUCT").field("cbPerObject", &self.cbPerObject).field("cbPerElement", &self.cbPerElement).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.cbPerObject == other.cbPerObject && self.cbPerElement == other.cbPerElement
    }
}
impl ::std::cmp::Eq for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {}
unsafe impl ::windows::runtime::Abi for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_MULTI_OPERATION_TYPE(pub i32);
pub const BCRYPT_OPERATION_TYPE_HASH: BCRYPT_MULTI_OPERATION_TYPE = BCRYPT_MULTI_OPERATION_TYPE(1i32);
impl ::std::convert::From<i32> for BCRYPT_MULTI_OPERATION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_MULTI_OPERATION_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_NO_KEY_VALIDATION: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_OAEP_PADDING_INFO {
    pub pszAlgId: super::super::Foundation::PWSTR,
    pub pbLabel: *mut u8,
    pub cbLabel: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_OAEP_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_OAEP_PADDING_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_OAEP_PADDING_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_OAEP_PADDING_INFO").field("pszAlgId", &self.pszAlgId).field("pbLabel", &self.pbLabel).field("cbLabel", &self.cbLabel).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_OAEP_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId && self.pbLabel == other.pbLabel && self.cbLabel == other.cbLabel
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_OAEP_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_OAEP_PADDING_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_OBJECT_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_OID {
    pub cbOID: u32,
    pub pbOID: *mut u8,
}
impl BCRYPT_OID {}
impl ::std::default::Default for BCRYPT_OID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_OID {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_OID").field("cbOID", &self.cbOID).field("pbOID", &self.pbOID).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_OID {
    fn eq(&self, other: &Self) -> bool {
        self.cbOID == other.cbOID && self.pbOID == other.pbOID
    }
}
impl ::std::cmp::Eq for BCRYPT_OID {}
unsafe impl ::windows::runtime::Abi for BCRYPT_OID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_OID_LIST {
    pub dwOIDCount: u32,
    pub pOIDs: *mut BCRYPT_OID,
}
impl BCRYPT_OID_LIST {}
impl ::std::default::Default for BCRYPT_OID_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_OID_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_OID_LIST").field("dwOIDCount", &self.dwOIDCount).field("pOIDs", &self.pOIDs).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_OID_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.dwOIDCount == other.dwOIDCount && self.pOIDs == other.pOIDs
    }
}
impl ::std::cmp::Eq for BCRYPT_OID_LIST {}
unsafe impl ::windows::runtime::Abi for BCRYPT_OID_LIST {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(pub u32);
pub const BCRYPT_ALG_HANDLE_HMAC_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(8u32);
pub const BCRYPT_PROV_DISPATCH: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(1u32);
pub const BCRYPT_HASH_REUSABLE_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(32u32);
impl ::std::convert::From<u32> for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_OPERATION(pub u32);
pub const BCRYPT_CIPHER_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(1u32);
pub const BCRYPT_HASH_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(2u32);
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(4u32);
pub const BCRYPT_SECRET_AGREEMENT_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(8u32);
pub const BCRYPT_SIGNATURE_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(16u32);
pub const BCRYPT_RNG_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(32u32);
impl ::std::convert::From<u32> for BCRYPT_OPERATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_OPERATION {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_OPERATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_OPERATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_OPERATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_OPERATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_PAD_PKCS1_OPTIONAL_HASH_OID: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_PBKDF2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(817u32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_PKCS1_PADDING_INFO {
    pub pszAlgId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_PKCS1_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_PKCS1_PADDING_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_PKCS1_PADDING_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_PKCS1_PADDING_INFO").field("pszAlgId", &self.pszAlgId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_PKCS1_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_PKCS1_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_PKCS1_PADDING_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_PRIVATE_KEY_FLAG: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_PROVIDER_NAME {
    pub pszProviderName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_PROVIDER_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_PROVIDER_NAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_PROVIDER_NAME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_PROVIDER_NAME").field("pszProviderName", &self.pszProviderName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_PROVIDER_NAME {
    fn eq(&self, other: &Self) -> bool {
        self.pszProviderName == other.pszProviderName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_PROVIDER_NAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_PROVIDER_NAME {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct BCRYPT_PSS_PADDING_INFO {
    pub pszAlgId: super::super::Foundation::PWSTR,
    pub cbSalt: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl BCRYPT_PSS_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BCRYPT_PSS_PADDING_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BCRYPT_PSS_PADDING_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_PSS_PADDING_INFO").field("pszAlgId", &self.pszAlgId).field("cbSalt", &self.cbSalt).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BCRYPT_PSS_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId && self.cbSalt == other.cbSalt
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BCRYPT_PSS_PADDING_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BCRYPT_PSS_PADDING_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_PUBLIC_KEY_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_QUERY_PROVIDER_MODE(pub u32);
pub const CRYPT_ANY: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(4u32);
pub const CRYPT_UM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(1u32);
pub const CRYPT_KM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(2u32);
pub const CRYPT_MM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(3u32);
impl ::std::convert::From<u32> for BCRYPT_QUERY_PROVIDER_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_QUERY_PROVIDER_MODE {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_QUERY_PROVIDER_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_QUERY_PROVIDER_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_QUERY_PROVIDER_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_QUERY_PROVIDER_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_QUERY_PROVIDER_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RC2_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(593u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RC2_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(625u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RC2_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(609u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RC4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(113u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_RESOLVE_PROVIDERS_FLAGS(pub u32);
pub const CRYPT_ALL_FUNCTIONS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(1u32);
pub const CRYPT_ALL_PROVIDERS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(2u32);
impl ::std::convert::From<u32> for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RNG_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(129u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RNG_USE_ENTROPY_IN_BUFFER: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCRYPT_RSAKEY_BLOB {
    pub Magic: BCRYPT_RSAKEY_BLOB_MAGIC,
    pub BitLength: u32,
    pub cbPublicExp: u32,
    pub cbModulus: u32,
    pub cbPrime1: u32,
    pub cbPrime2: u32,
}
impl BCRYPT_RSAKEY_BLOB {}
impl ::std::default::Default for BCRYPT_RSAKEY_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCRYPT_RSAKEY_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCRYPT_RSAKEY_BLOB").field("Magic", &self.Magic).field("BitLength", &self.BitLength).field("cbPublicExp", &self.cbPublicExp).field("cbModulus", &self.cbModulus).field("cbPrime1", &self.cbPrime1).field("cbPrime2", &self.cbPrime2).finish()
    }
}
impl ::std::cmp::PartialEq for BCRYPT_RSAKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.Magic == other.Magic && self.BitLength == other.BitLength && self.cbPublicExp == other.cbPublicExp && self.cbModulus == other.cbModulus && self.cbPrime1 == other.cbPrime1 && self.cbPrime2 == other.cbPrime2
    }
}
impl ::std::cmp::Eq for BCRYPT_RSAKEY_BLOB {}
unsafe impl ::windows::runtime::Abi for BCRYPT_RSAKEY_BLOB {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_RSAKEY_BLOB_MAGIC(pub u32);
pub const BCRYPT_RSAPUBLIC_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(826364754u32);
pub const BCRYPT_RSAPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(843141970u32);
pub const BCRYPT_RSAFULLPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(859919186u32);
impl ::std::convert::From<u32> for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_RSAKEY_BLOB_MAGIC {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_RSAKEY_BLOB_MAGIC {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_RSAKEY_BLOB_MAGIC {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_RSAKEY_BLOB_MAGIC {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(225u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_RSA_SIGN_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(785u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(49u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(65u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(81u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(97u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SP800108_CTR_HMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(833u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SP80056A_CONCAT_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(849u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SUPPORTED_PAD_OAEP: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SUPPORTED_PAD_PKCS1_ENC: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SUPPORTED_PAD_PKCS1_SIG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SUPPORTED_PAD_PSS: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_SUPPORTED_PAD_ROUTER: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BCRYPT_TABLE(pub u32);
pub const CRYPT_LOCAL: BCRYPT_TABLE = BCRYPT_TABLE(1u32);
pub const CRYPT_DOMAIN: BCRYPT_TABLE = BCRYPT_TABLE(2u32);
impl ::std::convert::From<u32> for BCRYPT_TABLE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BCRYPT_TABLE {
    type Abi = Self;
}
impl ::std::ops::BitOr for BCRYPT_TABLE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for BCRYPT_TABLE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for BCRYPT_TABLE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for BCRYPT_TABLE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for BCRYPT_TABLE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_TLS1_1_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(865u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_TLS1_2_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(881u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_TLS_CBC_HMAC_VERIFY_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_USE_SYSTEM_PREFERRED_RNG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const BCRYPT_XTS_AES_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(897u32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptAddContextFunction<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, dwposition: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptAddContextFunction(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, dwposition: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptAddContextFunction(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), ::std::mem::transmute(dwposition)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCryptBuffer {
    pub cbBuffer: u32,
    pub BufferType: u32,
    pub pvBuffer: *mut ::std::ffi::c_void,
}
impl BCryptBuffer {}
impl ::std::default::Default for BCryptBuffer {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCryptBuffer {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCryptBuffer").field("cbBuffer", &self.cbBuffer).field("BufferType", &self.BufferType).field("pvBuffer", &self.pvBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BCryptBuffer {
    fn eq(&self, other: &Self) -> bool {
        self.cbBuffer == other.cbBuffer && self.BufferType == other.BufferType && self.pvBuffer == other.pvBuffer
    }
}
impl ::std::cmp::Eq for BCryptBuffer {}
unsafe impl ::windows::runtime::Abi for BCryptBuffer {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct BCryptBufferDesc {
    pub ulVersion: u32,
    pub cBuffers: u32,
    pub pBuffers: *mut BCryptBuffer,
}
impl BCryptBufferDesc {}
impl ::std::default::Default for BCryptBufferDesc {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BCryptBufferDesc {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BCryptBufferDesc").field("ulVersion", &self.ulVersion).field("cBuffers", &self.cBuffers).field("pBuffers", &self.pBuffers).finish()
    }
}
impl ::std::cmp::PartialEq for BCryptBufferDesc {
    fn eq(&self, other: &Self) -> bool {
        self.ulVersion == other.ulVersion && self.cBuffers == other.cBuffers && self.pBuffers == other.pBuffers
    }
}
impl ::std::cmp::Eq for BCryptBufferDesc {}
unsafe impl ::windows::runtime::Abi for BCryptBufferDesc {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCloseAlgorithmProvider<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptCloseAlgorithmProvider(halgorithm: BCRYPT_ALG_HANDLE, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptCloseAlgorithmProvider(halgorithm.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptConfigureContext<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, pconfig: *const CRYPT_CONTEXT_CONFIG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptConfigureContext(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, pconfig: *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptConfigureContext(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(pconfig)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptConfigureContextFunction<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, pconfig: *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptConfigureContextFunction(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, pconfig: *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptConfigureContextFunction(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), ::std::mem::transmute(pconfig)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateContext<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, pconfig: *const CRYPT_CONTEXT_CONFIG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptCreateContext(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, pconfig: *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptCreateContext(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(pconfig)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateHash<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, phhash: *mut *mut ::std::ffi::c_void, pbhashobject: *mut u8, cbhashobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptCreateHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut *mut ::std::ffi::c_void, pbhashobject: *mut u8, cbhashobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptCreateHash(halgorithm.into_param().abi(), ::std::mem::transmute(phhash), ::std::mem::transmute(pbhashobject), ::std::mem::transmute(cbhashobject), ::std::mem::transmute(pbsecret), ::std::mem::transmute(cbsecret), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateMultiHash<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, phhash: *mut *mut ::std::ffi::c_void, nhashes: u32, pbhashobject: *mut u8, cbhashobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptCreateMultiHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut *mut ::std::ffi::c_void, nhashes: u32, pbhashobject: *mut u8, cbhashobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptCreateMultiHash(halgorithm.into_param().abi(), ::std::mem::transmute(phhash), ::std::mem::transmute(nhashes), ::std::mem::transmute(pbhashobject), ::std::mem::transmute(cbhashobject), ::std::mem::transmute(pbsecret), ::std::mem::transmute(cbsecret), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDecrypt<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, pbinput: *const u8, cbinput: u32, ppaddinginfo: *const ::std::ffi::c_void, pbiv: *mut u8, cbiv: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDecrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: *const u8, cbinput: u32, ppaddinginfo: *const ::std::ffi::c_void, pbiv: *mut u8, cbiv: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDecrypt(
            hkey.into_param().abi(),
            ::std::mem::transmute(pbinput),
            ::std::mem::transmute(cbinput),
            ::std::mem::transmute(ppaddinginfo),
            ::std::mem::transmute(pbiv),
            ::std::mem::transmute(cbiv),
            ::std::mem::transmute(pboutput),
            ::std::mem::transmute(cboutput),
            ::std::mem::transmute(pcbresult),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeleteContext<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDeleteContext(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDeleteContext(::std::mem::transmute(dwtable), pszcontext.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKey<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hsharedsecret: *const ::std::ffi::c_void, pwszkdf: Param1, pparameterlist: *const BCryptBufferDesc, pbderivedkey: *mut u8, cbderivedkey: u32, pcbresult: *mut u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDeriveKey(hsharedsecret: *const ::std::ffi::c_void, pwszkdf: super::super::Foundation::PWSTR, pparameterlist: *const BCryptBufferDesc, pbderivedkey: *mut u8, cbderivedkey: u32, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDeriveKey(::std::mem::transmute(hsharedsecret), pwszkdf.into_param().abi(), ::std::mem::transmute(pparameterlist), ::std::mem::transmute(pbderivedkey), ::std::mem::transmute(cbderivedkey), ::std::mem::transmute(pcbresult), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKeyCapi<'a, Param1: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(hhash: *const ::std::ffi::c_void, htargetalg: Param1, pbderivedkey: *mut u8, cbderivedkey: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDeriveKeyCapi(hhash: *const ::std::ffi::c_void, htargetalg: BCRYPT_ALG_HANDLE, pbderivedkey: *mut u8, cbderivedkey: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDeriveKeyCapi(::std::mem::transmute(hhash), htargetalg.into_param().abi(), ::std::mem::transmute(pbderivedkey), ::std::mem::transmute(cbderivedkey), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKeyPBKDF2<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(hprf: Param0, pbpassword: *const u8, cbpassword: u32, pbsalt: *const u8, cbsalt: u32, citerations: u64, pbderivedkey: *mut u8, cbderivedkey: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDeriveKeyPBKDF2(hprf: BCRYPT_ALG_HANDLE, pbpassword: *const u8, cbpassword: u32, pbsalt: *const u8, cbsalt: u32, citerations: u64, pbderivedkey: *mut u8, cbderivedkey: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDeriveKeyPBKDF2(hprf.into_param().abi(), ::std::mem::transmute(pbpassword), ::std::mem::transmute(cbpassword), ::std::mem::transmute(pbsalt), ::std::mem::transmute(cbsalt), ::std::mem::transmute(citerations), ::std::mem::transmute(pbderivedkey), ::std::mem::transmute(cbderivedkey), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroyHash(hhash: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDestroyHash(hhash: *mut ::std::ffi::c_void) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDestroyHash(::std::mem::transmute(hhash)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroyKey<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDestroyKey(hkey: BCRYPT_KEY_HANDLE) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDestroyKey(hkey.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroySecret(hsecret: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDestroySecret(hsecret: *mut ::std::ffi::c_void) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDestroySecret(::std::mem::transmute(hsecret)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDuplicateHash(hhash: *const ::std::ffi::c_void, phnewhash: *mut *mut ::std::ffi::c_void, pbhashobject: *mut u8, cbhashobject: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDuplicateHash(hhash: *const ::std::ffi::c_void, phnewhash: *mut *mut ::std::ffi::c_void, pbhashobject: *mut u8, cbhashobject: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDuplicateHash(::std::mem::transmute(hhash), ::std::mem::transmute(phnewhash), ::std::mem::transmute(pbhashobject), ::std::mem::transmute(cbhashobject), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDuplicateKey<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, phnewkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptDuplicateKey(hkey: BCRYPT_KEY_HANDLE, phnewkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptDuplicateKey(hkey.into_param().abi(), ::std::mem::transmute(phnewkey), ::std::mem::transmute(pbkeyobject), ::std::mem::transmute(cbkeyobject), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEncrypt<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, pbinput: *const u8, cbinput: u32, ppaddinginfo: *const ::std::ffi::c_void, pbiv: *mut u8, cbiv: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEncrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: *const u8, cbinput: u32, ppaddinginfo: *const ::std::ffi::c_void, pbiv: *mut u8, cbiv: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEncrypt(
            hkey.into_param().abi(),
            ::std::mem::transmute(pbinput),
            ::std::mem::transmute(cbinput),
            ::std::mem::transmute(ppaddinginfo),
            ::std::mem::transmute(pbiv),
            ::std::mem::transmute(cbiv),
            ::std::mem::transmute(pboutput),
            ::std::mem::transmute(cboutput),
            ::std::mem::transmute(pcbresult),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumAlgorithms(dwalgoperations: BCRYPT_OPERATION, palgcount: *mut u32, ppalglist: *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumAlgorithms(dwalgoperations: BCRYPT_OPERATION, palgcount: *mut u32, ppalglist: *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumAlgorithms(::std::mem::transmute(dwalgoperations), ::std::mem::transmute(palgcount), ::std::mem::transmute(ppalglist), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContextFunctionProviders<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumContextFunctionProviders(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumContextFunctionProviders(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContextFunctions<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTIONS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumContextFunctions(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTIONS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumContextFunctions(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContexts(dwtable: BCRYPT_TABLE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXTS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumContexts(dwtable: BCRYPT_TABLE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXTS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumContexts(::std::mem::transmute(dwtable), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumProviders<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pszalgid: Param0, pimplcount: *mut u32, ppimpllist: *mut *mut BCRYPT_PROVIDER_NAME, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumProviders(pszalgid: super::super::Foundation::PWSTR, pimplcount: *mut u32, ppimpllist: *mut *mut BCRYPT_PROVIDER_NAME, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumProviders(pszalgid.into_param().abi(), ::std::mem::transmute(pimplcount), ::std::mem::transmute(ppimpllist), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumRegisteredProviders(pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_PROVIDERS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptEnumRegisteredProviders(pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_PROVIDERS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptEnumRegisteredProviders(::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptExportKey<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>, Param1: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hkey: Param0, hexportkey: Param1, pszblobtype: Param2, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptExportKey(hkey: BCRYPT_KEY_HANDLE, hexportkey: BCRYPT_KEY_HANDLE, pszblobtype: super::super::Foundation::PWSTR, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptExportKey(hkey.into_param().abi(), hexportkey.into_param().abi(), pszblobtype.into_param().abi(), ::std::mem::transmute(pboutput), ::std::mem::transmute(cboutput), ::std::mem::transmute(pcbresult), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptFinalizeKeyPair<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptFinalizeKeyPair(hkey: BCRYPT_KEY_HANDLE, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptFinalizeKeyPair(hkey.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptFinishHash(hhash: *mut ::std::ffi::c_void, pboutput: *mut u8, cboutput: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptFinishHash(hhash: *mut ::std::ffi::c_void, pboutput: *mut u8, cboutput: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptFinishHash(::std::mem::transmute(hhash), ::std::mem::transmute(pboutput), ::std::mem::transmute(cboutput), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn BCryptFreeBuffer(pvbuffer: *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptFreeBuffer(pvbuffer: *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(BCryptFreeBuffer(::std::mem::transmute(pvbuffer)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenRandom<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, pbbuffer: *mut u8, cbbuffer: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptGenRandom(halgorithm: BCRYPT_ALG_HANDLE, pbbuffer: *mut u8, cbbuffer: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptGenRandom(halgorithm.into_param().abi(), ::std::mem::transmute(pbbuffer), ::std::mem::transmute(cbbuffer), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenerateKeyPair<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, phkey: *mut BCRYPT_KEY_HANDLE, dwlength: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptGenerateKeyPair(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, dwlength: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptGenerateKeyPair(halgorithm.into_param().abi(), ::std::mem::transmute(phkey), ::std::mem::transmute(dwlength), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenerateSymmetricKey<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptGenerateSymmetricKey(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, pbsecret: *const u8, cbsecret: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptGenerateSymmetricKey(halgorithm.into_param().abi(), ::std::mem::transmute(phkey), ::std::mem::transmute(pbkeyobject), ::std::mem::transmute(cbkeyobject), ::std::mem::transmute(pbsecret), ::std::mem::transmute(cbsecret), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGetFipsAlgorithmMode(pfenabled: *mut u8) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptGetFipsAlgorithmMode(pfenabled: *mut u8) -> super::super::Foundation::NTSTATUS;
        }
        BCryptGetFipsAlgorithmMode(::std::mem::transmute(pfenabled)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGetProperty<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hobject: *const ::std::ffi::c_void, pszproperty: Param1, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptGetProperty(hobject: *const ::std::ffi::c_void, pszproperty: super::super::Foundation::PWSTR, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptGetProperty(::std::mem::transmute(hobject), pszproperty.into_param().abi(), ::std::mem::transmute(pboutput), ::std::mem::transmute(cboutput), ::std::mem::transmute(pcbresult), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptHash<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>>(halgorithm: Param0, pbsecret: *const u8, cbsecret: u32, pbinput: *const u8, cbinput: u32, pboutput: *mut u8, cboutput: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptHash(halgorithm: BCRYPT_ALG_HANDLE, pbsecret: *const u8, cbsecret: u32, pbinput: *const u8, cbinput: u32, pboutput: *mut u8, cboutput: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptHash(halgorithm.into_param().abi(), ::std::mem::transmute(pbsecret), ::std::mem::transmute(cbsecret), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(pboutput), ::std::mem::transmute(cboutput)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptHashData(hhash: *mut ::std::ffi::c_void, pbinput: *const u8, cbinput: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptHashData(hhash: *mut ::std::ffi::c_void, pbinput: *const u8, cbinput: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptHashData(::std::mem::transmute(hhash), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptImportKey<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>, Param1: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(halgorithm: Param0, himportkey: Param1, pszblobtype: Param2, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, pbinput: *const u8, cbinput: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptImportKey(halgorithm: BCRYPT_ALG_HANDLE, himportkey: BCRYPT_KEY_HANDLE, pszblobtype: super::super::Foundation::PWSTR, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: *mut u8, cbkeyobject: u32, pbinput: *const u8, cbinput: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptImportKey(halgorithm.into_param().abi(), himportkey.into_param().abi(), pszblobtype.into_param().abi(), ::std::mem::transmute(phkey), ::std::mem::transmute(pbkeyobject), ::std::mem::transmute(cbkeyobject), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptImportKeyPair<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_ALG_HANDLE>, Param1: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(halgorithm: Param0, himportkey: Param1, pszblobtype: Param2, phkey: *mut BCRYPT_KEY_HANDLE, pbinput: *const u8, cbinput: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptImportKeyPair(halgorithm: BCRYPT_ALG_HANDLE, himportkey: BCRYPT_KEY_HANDLE, pszblobtype: super::super::Foundation::PWSTR, phkey: *mut BCRYPT_KEY_HANDLE, pbinput: *const u8, cbinput: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptImportKeyPair(halgorithm.into_param().abi(), himportkey.into_param().abi(), pszblobtype.into_param().abi(), ::std::mem::transmute(phkey), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptKeyDerivation<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, pparameterlist: *const BCryptBufferDesc, pbderivedkey: *mut u8, cbderivedkey: u32, pcbresult: *mut u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptKeyDerivation(hkey: BCRYPT_KEY_HANDLE, pparameterlist: *const BCryptBufferDesc, pbderivedkey: *mut u8, cbderivedkey: u32, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptKeyDerivation(hkey.into_param().abi(), ::std::mem::transmute(pparameterlist), ::std::mem::transmute(pbderivedkey), ::std::mem::transmute(cbderivedkey), ::std::mem::transmute(pcbresult), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptOpenAlgorithmProvider<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(phalgorithm: *mut BCRYPT_ALG_HANDLE, pszalgid: Param1, pszimplementation: Param2, dwflags: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptOpenAlgorithmProvider(phalgorithm: *mut BCRYPT_ALG_HANDLE, pszalgid: super::super::Foundation::PWSTR, pszimplementation: super::super::Foundation::PWSTR, dwflags: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptOpenAlgorithmProvider(::std::mem::transmute(phalgorithm), pszalgid.into_param().abi(), pszimplementation.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptProcessMultiOperations(hobject: *mut ::std::ffi::c_void, operationtype: BCRYPT_MULTI_OPERATION_TYPE, poperations: *const ::std::ffi::c_void, cboperations: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptProcessMultiOperations(hobject: *mut ::std::ffi::c_void, operationtype: BCRYPT_MULTI_OPERATION_TYPE, poperations: *const ::std::ffi::c_void, cboperations: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptProcessMultiOperations(::std::mem::transmute(hobject), ::std::mem::transmute(operationtype), ::std::mem::transmute(poperations), ::std::mem::transmute(cboperations), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextConfiguration<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_CONFIG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptQueryContextConfiguration(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_CONFIG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptQueryContextConfiguration(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextFunctionConfiguration<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptQueryContextFunctionConfiguration(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptQueryContextFunctionConfiguration(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextFunctionProperty<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, pszproperty: Param4, pcbvalue: *mut u32, ppbvalue: *mut *mut u8) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptQueryContextFunctionProperty(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, pszproperty: super::super::Foundation::PWSTR, pcbvalue: *mut u32, ppbvalue: *mut *mut u8) -> super::super::Foundation::NTSTATUS;
        }
        BCryptQueryContextFunctionProperty(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), pszproperty.into_param().abi(), ::std::mem::transmute(pcbvalue), ::std::mem::transmute(ppbvalue)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryProviderRegistration<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pszprovider: Param0, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_PROVIDER_REG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptQueryProviderRegistration(pszprovider: super::super::Foundation::PWSTR, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_PROVIDER_REG) -> super::super::Foundation::NTSTATUS;
        }
        BCryptQueryProviderRegistration(pszprovider.into_param().abi(), ::std::mem::transmute(dwmode), ::std::mem::transmute(dwinterface), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptRegisterConfigChangeNotify(phevent: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptRegisterConfigChangeNotify(phevent: *mut super::super::Foundation::HANDLE) -> super::super::Foundation::NTSTATUS;
        }
        BCryptRegisterConfigChangeNotify(::std::mem::transmute(phevent)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptRemoveContextFunction<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptRemoveContextFunction(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR) -> super::super::Foundation::NTSTATUS;
        }
        BCryptRemoveContextFunction(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptResolveProviders<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(
    pszcontext: Param0,
    dwinterface: u32,
    pszfunction: Param2,
    pszprovider: Param3,
    dwmode: BCRYPT_QUERY_PROVIDER_MODE,
    dwflags: BCRYPT_RESOLVE_PROVIDERS_FLAGS,
    pcbbuffer: *mut u32,
    ppbuffer: *mut *mut CRYPT_PROVIDER_REFS,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptResolveProviders(pszcontext: super::super::Foundation::PWSTR, dwinterface: u32, pszfunction: super::super::Foundation::PWSTR, pszprovider: super::super::Foundation::PWSTR, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwflags: BCRYPT_RESOLVE_PROVIDERS_FLAGS, pcbbuffer: *mut u32, ppbuffer: *mut *mut CRYPT_PROVIDER_REFS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptResolveProviders(pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), pszprovider.into_param().abi(), ::std::mem::transmute(dwmode), ::std::mem::transmute(dwflags), ::std::mem::transmute(pcbbuffer), ::std::mem::transmute(ppbuffer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSecretAgreement<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>, Param1: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hprivkey: Param0, hpubkey: Param1, phagreedsecret: *mut *mut ::std::ffi::c_void, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptSecretAgreement(hprivkey: BCRYPT_KEY_HANDLE, hpubkey: BCRYPT_KEY_HANDLE, phagreedsecret: *mut *mut ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptSecretAgreement(hprivkey.into_param().abi(), hpubkey.into_param().abi(), ::std::mem::transmute(phagreedsecret), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSetContextFunctionProperty<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwtable: BCRYPT_TABLE, pszcontext: Param1, dwinterface: BCRYPT_INTERFACE, pszfunction: Param3, pszproperty: Param4, cbvalue: u32, pbvalue: *const u8) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptSetContextFunctionProperty(dwtable: BCRYPT_TABLE, pszcontext: super::super::Foundation::PWSTR, dwinterface: BCRYPT_INTERFACE, pszfunction: super::super::Foundation::PWSTR, pszproperty: super::super::Foundation::PWSTR, cbvalue: u32, pbvalue: *const u8) -> super::super::Foundation::NTSTATUS;
        }
        BCryptSetContextFunctionProperty(::std::mem::transmute(dwtable), pszcontext.into_param().abi(), ::std::mem::transmute(dwinterface), pszfunction.into_param().abi(), pszproperty.into_param().abi(), ::std::mem::transmute(cbvalue), ::std::mem::transmute(pbvalue)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSetProperty<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hobject: *mut ::std::ffi::c_void, pszproperty: Param1, pbinput: *const u8, cbinput: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptSetProperty(hobject: *mut ::std::ffi::c_void, pszproperty: super::super::Foundation::PWSTR, pbinput: *const u8, cbinput: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS;
        }
        BCryptSetProperty(::std::mem::transmute(hobject), pszproperty.into_param().abi(), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSignHash<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, ppaddinginfo: *const ::std::ffi::c_void, pbinput: *const u8, cbinput: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptSignHash(hkey: BCRYPT_KEY_HANDLE, ppaddinginfo: *const ::std::ffi::c_void, pbinput: *const u8, cbinput: u32, pboutput: *mut u8, cboutput: u32, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptSignHash(hkey.into_param().abi(), ::std::mem::transmute(ppaddinginfo), ::std::mem::transmute(pbinput), ::std::mem::transmute(cbinput), ::std::mem::transmute(pboutput), ::std::mem::transmute(cboutput), ::std::mem::transmute(pcbresult), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptUnregisterConfigChangeNotify<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(hevent: Param0) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptUnregisterConfigChangeNotify(hevent: super::super::Foundation::HANDLE) -> super::super::Foundation::NTSTATUS;
        }
        BCryptUnregisterConfigChangeNotify(hevent.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptVerifySignature<'a, Param0: ::windows::runtime::IntoParam<'a, BCRYPT_KEY_HANDLE>>(hkey: Param0, ppaddinginfo: *const ::std::ffi::c_void, pbhash: *const u8, cbhash: u32, pbsignature: *const u8, cbsignature: u32, dwflags: NCRYPT_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BCryptVerifySignature(hkey: BCRYPT_KEY_HANDLE, ppaddinginfo: *const ::std::ffi::c_void, pbhash: *const u8, cbhash: u32, pbsignature: *const u8, cbsignature: u32, dwflags: NCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS;
        }
        BCryptVerifySignature(hkey.into_param().abi(), ::std::mem::transmute(ppaddinginfo), ::std::mem::transmute(pbhash), ::std::mem::transmute(cbhash), ::std::mem::transmute(pbsignature), ::std::mem::transmute(cbsignature), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CALG_OID_INFO_CNG_ONLY: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CALG_OID_INFO_PARAMETERS: u32 = 4294967294u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CASetupProperty(pub i32);
pub const ENUM_SETUPPROP_INVALID: CASetupProperty = CASetupProperty(-1i32);
pub const ENUM_SETUPPROP_CATYPE: CASetupProperty = CASetupProperty(0i32);
pub const ENUM_SETUPPROP_CAKEYINFORMATION: CASetupProperty = CASetupProperty(1i32);
pub const ENUM_SETUPPROP_INTERACTIVE: CASetupProperty = CASetupProperty(2i32);
pub const ENUM_SETUPPROP_CANAME: CASetupProperty = CASetupProperty(3i32);
pub const ENUM_SETUPPROP_CADSSUFFIX: CASetupProperty = CASetupProperty(4i32);
pub const ENUM_SETUPPROP_VALIDITYPERIOD: CASetupProperty = CASetupProperty(5i32);
pub const ENUM_SETUPPROP_VALIDITYPERIODUNIT: CASetupProperty = CASetupProperty(6i32);
pub const ENUM_SETUPPROP_EXPIRATIONDATE: CASetupProperty = CASetupProperty(7i32);
pub const ENUM_SETUPPROP_PRESERVEDATABASE: CASetupProperty = CASetupProperty(8i32);
pub const ENUM_SETUPPROP_DATABASEDIRECTORY: CASetupProperty = CASetupProperty(9i32);
pub const ENUM_SETUPPROP_LOGDIRECTORY: CASetupProperty = CASetupProperty(10i32);
pub const ENUM_SETUPPROP_SHAREDFOLDER: CASetupProperty = CASetupProperty(11i32);
pub const ENUM_SETUPPROP_PARENTCAMACHINE: CASetupProperty = CASetupProperty(12i32);
pub const ENUM_SETUPPROP_PARENTCANAME: CASetupProperty = CASetupProperty(13i32);
pub const ENUM_SETUPPROP_REQUESTFILE: CASetupProperty = CASetupProperty(14i32);
pub const ENUM_SETUPPROP_WEBCAMACHINE: CASetupProperty = CASetupProperty(15i32);
pub const ENUM_SETUPPROP_WEBCANAME: CASetupProperty = CASetupProperty(16i32);
impl ::std::convert::From<i32> for CASetupProperty {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CASetupProperty {
    type Abi = Self;
}
pub const CCertSrvSetup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2518620175, 62812, 16701, [169, 179, 125, 42, 244, 216, 228, 47]);
pub const CCertSrvSetupKeyInformation: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(943143174, 21555, 17971, [176, 251, 41, 183, 231, 130, 98, 225]);
pub const CCertificateEnrollmentPolicyServerSetup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2950887986, 16817, 17821, [165, 222, 73, 173, 216, 167, 33, 130]);
pub const CCertificateEnrollmentServerSetup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2567107516, 34991, 19704, [174, 98, 113, 64, 83, 21, 82, 182]);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CEPSetupProperty(pub i32);
pub const ENUM_CEPSETUPPROP_AUTHENTICATION: CEPSetupProperty = CEPSetupProperty(0i32);
pub const ENUM_CEPSETUPPROP_SSLCERTHASH: CEPSetupProperty = CEPSetupProperty(1i32);
pub const ENUM_CEPSETUPPROP_URL: CEPSetupProperty = CEPSetupProperty(2i32);
pub const ENUM_CEPSETUPPROP_KEYBASED_RENEWAL: CEPSetupProperty = CEPSetupProperty(3i32);
impl ::std::convert::From<i32> for CEPSetupProperty {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CEPSetupProperty {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERTIFICATE_CHAIN_BLOB {
    pub certCount: u32,
    pub rawCertificates: *mut CRYPTOAPI_BLOB,
}
impl CERTIFICATE_CHAIN_BLOB {}
impl ::std::default::Default for CERTIFICATE_CHAIN_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERTIFICATE_CHAIN_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERTIFICATE_CHAIN_BLOB").field("certCount", &self.certCount).field("rawCertificates", &self.rawCertificates).finish()
    }
}
impl ::std::cmp::PartialEq for CERTIFICATE_CHAIN_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.certCount == other.certCount && self.rawCertificates == other.rawCertificates
    }
}
impl ::std::cmp::Eq for CERTIFICATE_CHAIN_BLOB {}
unsafe impl ::windows::runtime::Abi for CERTIFICATE_CHAIN_BLOB {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERTVIEW_CRYPTUI_LPARAM: u32 = 8388608u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_ACCESS_DESCRIPTION {
    pub pszAccessMethod: super::super::Foundation::PSTR,
    pub AccessLocation: CERT_ALT_NAME_ENTRY,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_ACCESS_DESCRIPTION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_ACCESS_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_ACCESS_DESCRIPTION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_ACCESS_DESCRIPTION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_ACCESS_DESCRIPTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_GP_SYSTEM_STORE_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_LM_SYSTEM_STORE_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_PROP_ID: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_SHARED_USER_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_SYSTEM_STORE_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ACCESS_STATE_WRITE_PERSIST_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AIA_URL_RETRIEVED_PROP_ID: u32 = 67u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_EDI_PARTY_NAME: u32 = 6u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_ALT_NAME_ENTRY {
    pub dwAltNameChoice: u32,
    pub Anonymous: CERT_ALT_NAME_ENTRY_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_ALT_NAME_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_ALT_NAME_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_ALT_NAME_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_ALT_NAME_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_ALT_NAME_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CERT_ALT_NAME_ENTRY_0 {
    pub pOtherName: *mut CERT_OTHER_NAME,
    pub pwszRfc822Name: super::super::Foundation::PWSTR,
    pub pwszDNSName: super::super::Foundation::PWSTR,
    pub DirectoryName: CRYPTOAPI_BLOB,
    pub pwszURL: super::super::Foundation::PWSTR,
    pub IPAddress: CRYPTOAPI_BLOB,
    pub pszRegisteredID: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_ALT_NAME_ENTRY_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_ALT_NAME_ENTRY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_ALT_NAME_ENTRY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_ALT_NAME_ENTRY_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_ALT_NAME_ENTRY_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK: u32 = 255u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_ALT_NAME_INFO {
    pub cAltEntry: u32,
    pub rgAltEntry: *mut CERT_ALT_NAME_ENTRY,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_ALT_NAME_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_ALT_NAME_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_ALT_NAME_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_ALT_NAME_INFO").field("cAltEntry", &self.cAltEntry).field("rgAltEntry", &self.rgAltEntry).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_ALT_NAME_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cAltEntry == other.cAltEntry && self.rgAltEntry == other.rgAltEntry
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_ALT_NAME_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_ALT_NAME_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ALT_NAME_X400_ADDRESS: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ARCHIVED_KEY_HASH_PROP_ID: u32 = 65u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ARCHIVED_PROP_ID: u32 = 19u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_AUTHORITY_INFO_ACCESS {
    pub cAccDescr: u32,
    pub rgAccDescr: *mut CERT_ACCESS_DESCRIPTION,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_AUTHORITY_INFO_ACCESS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_AUTHORITY_INFO_ACCESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_AUTHORITY_INFO_ACCESS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_AUTHORITY_INFO_ACCESS").field("cAccDescr", &self.cAccDescr).field("rgAccDescr", &self.rgAccDescr).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_AUTHORITY_INFO_ACCESS {
    fn eq(&self, other: &Self) -> bool {
        self.cAccDescr == other.cAccDescr && self.rgAccDescr == other.rgAccDescr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_AUTHORITY_INFO_ACCESS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_AUTHORITY_INFO_ACCESS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 68u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_AUTHORITY_KEY_ID2_INFO {
    pub KeyId: CRYPTOAPI_BLOB,
    pub AuthorityCertIssuer: CERT_ALT_NAME_INFO,
    pub AuthorityCertSerialNumber: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_AUTHORITY_KEY_ID2_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_AUTHORITY_KEY_ID2_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_AUTHORITY_KEY_ID2_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_AUTHORITY_KEY_ID2_INFO").field("KeyId", &self.KeyId).field("AuthorityCertIssuer", &self.AuthorityCertIssuer).field("AuthorityCertSerialNumber", &self.AuthorityCertSerialNumber).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_AUTHORITY_KEY_ID2_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.AuthorityCertIssuer == other.AuthorityCertIssuer && self.AuthorityCertSerialNumber == other.AuthorityCertSerialNumber
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_AUTHORITY_KEY_ID2_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_AUTHORITY_KEY_ID2_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_AUTHORITY_KEY_ID_INFO {
    pub KeyId: CRYPTOAPI_BLOB,
    pub CertIssuer: CRYPTOAPI_BLOB,
    pub CertSerialNumber: CRYPTOAPI_BLOB,
}
impl CERT_AUTHORITY_KEY_ID_INFO {}
impl ::std::default::Default for CERT_AUTHORITY_KEY_ID_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_AUTHORITY_KEY_ID_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_AUTHORITY_KEY_ID_INFO").field("KeyId", &self.KeyId).field("CertIssuer", &self.CertIssuer).field("CertSerialNumber", &self.CertSerialNumber).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_AUTHORITY_KEY_ID_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.CertIssuer == other.CertIssuer && self.CertSerialNumber == other.CertSerialNumber
    }
}
impl ::std::cmp::Eq for CERT_AUTHORITY_KEY_ID_INFO {}
unsafe impl ::windows::runtime::Abi for CERT_AUTHORITY_KEY_ID_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_PARTIAL_CHAIN_LOGGING_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_UNTRUSTED_ROOT_LOGGING_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTH_ROOT_SHA256_HASH_PROP_ID: u32 = 98u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTO_ENROLL_PROP_ID: u32 = 21u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTO_ENROLL_RETRY_PROP_ID: u32 = 66u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_AUTO_UPDATE_DISABLE_RANDOM_QUERY_STRING_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_BACKED_UP_PROP_ID: u32 = 69u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_BASIC_CONSTRAINTS2_INFO {
    pub fCA: super::super::Foundation::BOOL,
    pub fPathLenConstraint: super::super::Foundation::BOOL,
    pub dwPathLenConstraint: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_BASIC_CONSTRAINTS2_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_BASIC_CONSTRAINTS2_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_BASIC_CONSTRAINTS2_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_BASIC_CONSTRAINTS2_INFO").field("fCA", &self.fCA).field("fPathLenConstraint", &self.fPathLenConstraint).field("dwPathLenConstraint", &self.dwPathLenConstraint).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_BASIC_CONSTRAINTS2_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.fCA == other.fCA && self.fPathLenConstraint == other.fPathLenConstraint && self.dwPathLenConstraint == other.dwPathLenConstraint
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_BASIC_CONSTRAINTS2_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_BASIC_CONSTRAINTS2_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_BASIC_CONSTRAINTS_INFO {
    pub SubjectType: CRYPT_BIT_BLOB,
    pub fPathLenConstraint: super::super::Foundation::BOOL,
    pub dwPathLenConstraint: u32,
    pub cSubtreesConstraint: u32,
    pub rgSubtreesConstraint: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_BASIC_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_BASIC_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_BASIC_CONSTRAINTS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_BASIC_CONSTRAINTS_INFO")
            .field("SubjectType", &self.SubjectType)
            .field("fPathLenConstraint", &self.fPathLenConstraint)
            .field("dwPathLenConstraint", &self.dwPathLenConstraint)
            .field("cSubtreesConstraint", &self.cSubtreesConstraint)
            .field("rgSubtreesConstraint", &self.rgSubtreesConstraint)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_BASIC_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectType == other.SubjectType && self.fPathLenConstraint == other.fPathLenConstraint && self.dwPathLenConstraint == other.dwPathLenConstraint && self.cSubtreesConstraint == other.cSubtreesConstraint && self.rgSubtreesConstraint == other.rgSubtreesConstraint
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_BASIC_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_BASIC_CONSTRAINTS_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_BIOMETRIC_DATA {
    pub dwTypeOfBiometricDataChoice: CERT_BIOMETRIC_DATA_TYPE,
    pub Anonymous: CERT_BIOMETRIC_DATA_0,
    pub HashedUrl: CERT_HASHED_URL,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_BIOMETRIC_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_BIOMETRIC_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_BIOMETRIC_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_BIOMETRIC_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_BIOMETRIC_DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CERT_BIOMETRIC_DATA_0 {
    pub dwPredefined: u32,
    pub pszObjId: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_BIOMETRIC_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_BIOMETRIC_DATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_BIOMETRIC_DATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_BIOMETRIC_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_BIOMETRIC_DATA_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_BIOMETRIC_DATA_TYPE(pub u32);
pub const CERT_BIOMETRIC_PREDEFINED_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(1u32);
pub const CERT_BIOMETRIC_OID_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(2u32);
impl ::std::convert::From<u32> for CERT_BIOMETRIC_DATA_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_BIOMETRIC_DATA_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_BIOMETRIC_DATA_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_BIOMETRIC_DATA_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_BIOMETRIC_DATA_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_BIOMETRIC_DATA_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_BIOMETRIC_DATA_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_BIOMETRIC_EXT_INFO {
    pub cBiometricData: u32,
    pub rgBiometricData: *mut CERT_BIOMETRIC_DATA,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_BIOMETRIC_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_BIOMETRIC_EXT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_BIOMETRIC_EXT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_BIOMETRIC_EXT_INFO").field("cBiometricData", &self.cBiometricData).field("rgBiometricData", &self.rgBiometricData).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_BIOMETRIC_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cBiometricData == other.cBiometricData && self.rgBiometricData == other.rgBiometricData
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_BIOMETRIC_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_BIOMETRIC_EXT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_BIOMETRIC_PICTURE_TYPE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_BIOMETRIC_SIGNATURE_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_BUNDLE_CERTIFICATE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_BUNDLE_CRL: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CASE_INSENSITIVE_IS_RDN_ATTRS_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CA_DISABLE_CRL_PROP_ID: u32 = 82u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CA_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 81u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CA_SUBJECT_FLAG: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CEP_PROP_ID: u32 = 87u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CHAIN {
    pub cCerts: u32,
    pub certs: *mut CRYPTOAPI_BLOB,
    pub keyLocatorInfo: CRYPT_KEY_PROV_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CHAIN {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CHAIN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CHAIN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN").field("cCerts", &self.cCerts).field("certs", &self.certs).field("keyLocatorInfo", &self.keyLocatorInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CHAIN {
    fn eq(&self, other: &Self) -> bool {
        self.cCerts == other.cCerts && self.certs == other.certs && self.keyLocatorInfo == other.keyLocatorInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CHAIN {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CHAIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_CURRENT_USER: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_FLUSH_DISABLE_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_HPKP_RULE_INFO: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_IMPERSONATED: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_LOCAL_MACHINE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_LOG_CREATE_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_LOG_FLUSH_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_LOG_FREE_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_NETWORK_INFO: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_PINRULE_INFO: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_PROCESS_INFO: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_AUTO_SERIAL_LOCAL_MACHINE: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_CACHE_END_CERT: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_CACHE_ONLY_URL_RETRIEVAL: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CHAIN_CONTEXT {
    pub cbSize: u32,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub cChain: u32,
    pub rgpChain: *mut *mut CERT_SIMPLE_CHAIN,
    pub cLowerQualityChainContext: u32,
    pub rgpLowerQualityChainContext: *mut *mut CERT_CHAIN_CONTEXT,
    pub fHasRevocationFreshnessTime: super::super::Foundation::BOOL,
    pub dwRevocationFreshnessTime: u32,
    pub dwCreateFlags: u32,
    pub ChainId: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CHAIN_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CHAIN_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CHAIN_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_CONTEXT")
            .field("cbSize", &self.cbSize)
            .field("TrustStatus", &self.TrustStatus)
            .field("cChain", &self.cChain)
            .field("rgpChain", &self.rgpChain)
            .field("cLowerQualityChainContext", &self.cLowerQualityChainContext)
            .field("rgpLowerQualityChainContext", &self.rgpLowerQualityChainContext)
            .field("fHasRevocationFreshnessTime", &self.fHasRevocationFreshnessTime)
            .field("dwRevocationFreshnessTime", &self.dwRevocationFreshnessTime)
            .field("dwCreateFlags", &self.dwCreateFlags)
            .field("ChainId", &self.ChainId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CHAIN_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.TrustStatus == other.TrustStatus
            && self.cChain == other.cChain
            && self.rgpChain == other.rgpChain
            && self.cLowerQualityChainContext == other.cLowerQualityChainContext
            && self.rgpLowerQualityChainContext == other.rgpLowerQualityChainContext
            && self.fHasRevocationFreshnessTime == other.fHasRevocationFreshnessTime
            && self.dwRevocationFreshnessTime == other.dwRevocationFreshnessTime
            && self.dwCreateFlags == other.dwCreateFlags
            && self.ChainId == other.ChainId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CHAIN_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_CONTEXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_DEFAULT: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_AIA: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_ALL_EKU_WEAK_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_CODE_SIGNING_WEAK_FLAG: u32 = 4194304u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_ECC_PARA_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_FILE_HASH_WEAK_FLAG: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MD2_MD4: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MOTW_CODE_SIGNING_WEAK_FLAG: u32 = 8388608u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MOTW_FILE_HASH_WEAK_FLAG: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_HASH_WEAK_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_WEAK_FLAG: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_MY_PEER_TRUST: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_OPT_IN_SERVER_AUTH_WEAK_FLAG: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_PASS1_QUALITY_FILTERING: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_SERVER_AUTH_WEAK_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_TIMESTAMP_HASH_WEAK_FLAG: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_DISABLE_TIMESTAMP_WEAK_FLAG: u32 = 67108864u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CHAIN_ELEMENT {
    pub cbSize: u32,
    pub pCertContext: *mut CERT_CONTEXT,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub pRevocationInfo: *mut CERT_REVOCATION_INFO,
    pub pIssuanceUsage: *mut CTL_USAGE,
    pub pApplicationUsage: *mut CTL_USAGE,
    pub pwszExtendedErrorInfo: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CHAIN_ELEMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CHAIN_ELEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CHAIN_ELEMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_ELEMENT")
            .field("cbSize", &self.cbSize)
            .field("pCertContext", &self.pCertContext)
            .field("TrustStatus", &self.TrustStatus)
            .field("pRevocationInfo", &self.pRevocationInfo)
            .field("pIssuanceUsage", &self.pIssuanceUsage)
            .field("pApplicationUsage", &self.pApplicationUsage)
            .field("pwszExtendedErrorInfo", &self.pwszExtendedErrorInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CHAIN_ELEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pCertContext == other.pCertContext && self.TrustStatus == other.TrustStatus && self.pRevocationInfo == other.pRevocationInfo && self.pIssuanceUsage == other.pIssuanceUsage && self.pApplicationUsage == other.pApplicationUsage && self.pwszExtendedErrorInfo == other.pwszExtendedErrorInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CHAIN_ELEMENT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_ELEMENT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_ALL_EKU_HYGIENE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_CACHE_AUTO_UPDATE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_CODE_SIGNING_HYGIENE_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_MD2_MD4_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_MOTW_CODE_SIGNING_HYGIENE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_MOTW_TIMESTAMP_HYGIENE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_ONLY_WEAK_LOGGING_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_PEER_TRUST: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_SERVER_AUTH_HYGIENE_FLAG: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_SHARE_STORE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_TIMESTAMP_HYGIENE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_WEAK_LOGGING_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_WEAK_RSA_ROOT_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ENABLE_WEAK_SETTINGS_FLAG: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_CHAIN_ENGINE_CONFIG {
    pub cbSize: u32,
    pub hRestrictedRoot: *mut ::std::ffi::c_void,
    pub hRestrictedTrust: *mut ::std::ffi::c_void,
    pub hRestrictedOther: *mut ::std::ffi::c_void,
    pub cAdditionalStore: u32,
    pub rghAdditionalStore: *mut *mut ::std::ffi::c_void,
    pub dwFlags: u32,
    pub dwUrlRetrievalTimeout: u32,
    pub MaximumCachedCertificates: u32,
    pub CycleDetectionModulus: u32,
    pub hExclusiveRoot: *mut ::std::ffi::c_void,
    pub hExclusiveTrustedPeople: *mut ::std::ffi::c_void,
    pub dwExclusiveFlags: u32,
}
impl CERT_CHAIN_ENGINE_CONFIG {}
impl ::std::default::Default for CERT_CHAIN_ENGINE_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_CHAIN_ENGINE_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_ENGINE_CONFIG")
            .field("cbSize", &self.cbSize)
            .field("hRestrictedRoot", &self.hRestrictedRoot)
            .field("hRestrictedTrust", &self.hRestrictedTrust)
            .field("hRestrictedOther", &self.hRestrictedOther)
            .field("cAdditionalStore", &self.cAdditionalStore)
            .field("rghAdditionalStore", &self.rghAdditionalStore)
            .field("dwFlags", &self.dwFlags)
            .field("dwUrlRetrievalTimeout", &self.dwUrlRetrievalTimeout)
            .field("MaximumCachedCertificates", &self.MaximumCachedCertificates)
            .field("CycleDetectionModulus", &self.CycleDetectionModulus)
            .field("hExclusiveRoot", &self.hExclusiveRoot)
            .field("hExclusiveTrustedPeople", &self.hExclusiveTrustedPeople)
            .field("dwExclusiveFlags", &self.dwExclusiveFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CERT_CHAIN_ENGINE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.hRestrictedRoot == other.hRestrictedRoot
            && self.hRestrictedTrust == other.hRestrictedTrust
            && self.hRestrictedOther == other.hRestrictedOther
            && self.cAdditionalStore == other.cAdditionalStore
            && self.rghAdditionalStore == other.rghAdditionalStore
            && self.dwFlags == other.dwFlags
            && self.dwUrlRetrievalTimeout == other.dwUrlRetrievalTimeout
            && self.MaximumCachedCertificates == other.MaximumCachedCertificates
            && self.CycleDetectionModulus == other.CycleDetectionModulus
            && self.hExclusiveRoot == other.hExclusiveRoot
            && self.hExclusiveTrustedPeople == other.hExclusiveTrustedPeople
            && self.dwExclusiveFlags == other.dwExclusiveFlags
    }
}
impl ::std::cmp::Eq for CERT_CHAIN_ENGINE_CONFIG {}
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_ENGINE_CONFIG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_EXCLUSIVE_ENABLE_CA_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER: u32 = 1u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CHAIN_FIND_BY_ISSUER_PARA {
    pub cbSize: u32,
    pub pszUsageIdentifier: super::super::Foundation::PSTR,
    pub dwKeySpec: u32,
    pub dwAcquirePrivateKeyFlags: u32,
    pub cIssuer: u32,
    pub rgIssuer: *mut CRYPTOAPI_BLOB,
    pub pfnFindCallback: ::std::option::Option<PFN_CERT_CHAIN_FIND_BY_ISSUER_CALLBACK>,
    pub pvFindArg: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CHAIN_FIND_BY_ISSUER_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_FIND_BY_ISSUER_PARA")
            .field("cbSize", &self.cbSize)
            .field("pszUsageIdentifier", &self.pszUsageIdentifier)
            .field("dwKeySpec", &self.dwKeySpec)
            .field("dwAcquirePrivateKeyFlags", &self.dwAcquirePrivateKeyFlags)
            .field("cIssuer", &self.cIssuer)
            .field("rgIssuer", &self.rgIssuer)
            .field("pvFindArg", &self.pvFindArg)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszUsageIdentifier == other.pszUsageIdentifier && self.dwKeySpec == other.dwKeySpec && self.dwAcquirePrivateKeyFlags == other.dwAcquirePrivateKeyFlags && self.cIssuer == other.cIssuer && self.rgIssuer == other.rgIssuer && self.pfnFindCallback.map(|f| f as usize) == other.pfnFindCallback.map(|f| f as usize) && self.pvFindArg == other.pvFindArg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CHAIN_FIND_BY_ISSUER_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_HAS_MOTW: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_DEFAULT: u32 = 100000u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_DEFAULT: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MIN_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DEFAULT: u32 = 1023u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_MOTW_IGNORE_AFTER_TIME_WEAK_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_ONLY_ADDITIONAL_AND_AUTH_ROOT: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_OPTION_DISABLE_AIA_URL_RETRIEVAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_OPTION_ENABLE_SIA_URL_RETRIEVAL: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_OPT_IN_WEAK_FLAGS: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_OPT_IN_WEAK_SIGNATURE: u32 = 65536u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CHAIN_PARA {
    pub cbSize: u32,
    pub RequestedUsage: CERT_USAGE_MATCH,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CHAIN_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CHAIN_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_PARA").field("cbSize", &self.cbSize).field("RequestedUsage", &self.RequestedUsage).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.RequestedUsage == other.RequestedUsage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_CHAIN_POLICY_FLAGS(pub u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1u32);
pub const CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_NESTED_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4u32);
pub const CERT_CHAIN_POLICY_IGNORE_ALL_NOT_TIME_VALID_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(7u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_BASIC_CONSTRAINTS_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8u32);
pub const CERT_CHAIN_POLICY_ALLOW_UNKNOWN_CA_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16u32);
pub const CERT_CHAIN_POLICY_IGNORE_WRONG_USAGE_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_NAME_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(64u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_POLICY_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(128u32);
pub const CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(256u32);
pub const CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(512u32);
pub const CERT_CHAIN_POLICY_IGNORE_CA_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1024u32);
pub const CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2048u32);
pub const CERT_CHAIN_POLICY_IGNORE_ALL_REV_UNKNOWN_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(3840u32);
pub const CERT_CHAIN_POLICY_ALLOW_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32768u32);
pub const CERT_CHAIN_POLICY_TRUST_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16384u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_SUPPORTED_CRITICAL_EXT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8192u32);
pub const CERT_CHAIN_POLICY_IGNORE_PEER_TRUST_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4096u32);
impl ::std::convert::From<u32> for CERT_CHAIN_POLICY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_POLICY_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_CHAIN_POLICY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_CHAIN_POLICY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_CHAIN_POLICY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_CHAIN_POLICY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_CHAIN_POLICY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_IGNORE_WEAK_SIGNATURE_FLAG: u32 = 134217728u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwFlags: CERT_CHAIN_POLICY_FLAGS,
    pub pvExtraPolicyPara: *mut ::std::ffi::c_void,
}
impl CERT_CHAIN_POLICY_PARA {}
impl ::std::default::Default for CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).field("pvExtraPolicyPara", &self.pvExtraPolicyPara).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwFlags == other.dwFlags && self.pvExtraPolicyPara == other.pvExtraPolicyPara
    }
}
impl ::std::cmp::Eq for CERT_CHAIN_POLICY_PARA {}
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_POLICY_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_ERROR_LEVEL: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_NONE_CATEGORY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_ROOT_PROGRAM_CATEGORY: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_SUCCESS_LEVEL: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_WARNING_LEVEL: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_WEAK_CRYPTO_CATEGORY: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_ERROR: i32 = -2i32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_WARNING: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_ERROR: i32 = -1i32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_WARNING: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_SUCCESS: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_CHAIN_POLICY_STATUS {
    pub cbSize: u32,
    pub dwError: u32,
    pub lChainIndex: i32,
    pub lElementIndex: i32,
    pub pvExtraPolicyStatus: *mut ::std::ffi::c_void,
}
impl CERT_CHAIN_POLICY_STATUS {}
impl ::std::default::Default for CERT_CHAIN_POLICY_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_CHAIN_POLICY_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CHAIN_POLICY_STATUS").field("cbSize", &self.cbSize).field("dwError", &self.dwError).field("lChainIndex", &self.lChainIndex).field("lElementIndex", &self.lElementIndex).field("pvExtraPolicyStatus", &self.pvExtraPolicyStatus).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_CHAIN_POLICY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwError == other.dwError && self.lChainIndex == other.lChainIndex && self.lElementIndex == other.lElementIndex && self.pvExtraPolicyStatus == other.pvExtraPolicyStatus
    }
}
impl ::std::cmp::Eq for CERT_CHAIN_POLICY_STATUS {}
unsafe impl ::windows::runtime::Abi for CERT_CHAIN_POLICY_STATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_RETURN_LOWER_QUALITY_CONTEXTS: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_ACCUMULATIVE_TIMEOUT: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_END_CERT: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_OCSP_CERT: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_STRONG_SIGN_DISABLE_END_CHECK_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_THREAD_STORE_SYNC: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_TIMESTAMP_TIME: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CHAIN_USE_LOCAL_MACHINE_STORE: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CLOSE_STORE_CHECK_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CLOSE_STORE_FORCE_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CLR_DELETE_KEY_PROP_ID: u32 = 125u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_ATTR: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_CERT_ID: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_CROSS_CERT_DIST_POINTS: u32 = 17u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_CTL_USAGE: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_ENHKEY_USAGE: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_EXISTING: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_HASH: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_HASH_STR: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_HAS_PRIVATE_KEY: u32 = 21u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_ISSUER_OF: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_KEY_IDENTIFIER: u32 = 15u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_KEY_SPEC: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_MD5_HASH: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_NAME: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_NAME_STR_A: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_NAME_STR_W: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_PROPERTY: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_PUBKEY_MD5_HASH: u32 = 18u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_PUBLIC_KEY: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_SHA1_HASH: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_SHIFT: i32 = 16i32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_SIGNATURE_HASH: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_SUBJECT_CERT: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_COMPARE_SUBJECT_INFO_ACCESS: u32 = 19u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CONTEXT {
    pub dwCertEncodingType: u32,
    pub pbCertEncoded: *mut u8,
    pub cbCertEncoded: u32,
    pub pCertInfo: *mut CERT_INFO,
    pub hCertStore: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CONTEXT").field("dwCertEncodingType", &self.dwCertEncodingType).field("pbCertEncoded", &self.pbCertEncoded).field("cbCertEncoded", &self.cbCertEncoded).field("pCertInfo", &self.pCertInfo).field("hCertStore", &self.hCertStore).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwCertEncodingType == other.dwCertEncodingType && self.pbCertEncoded == other.pbCertEncoded && self.cbCertEncoded == other.cbCertEncoded && self.pCertInfo == other.pCertInfo && self.hCertStore == other.hCertStore
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CONTEXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CONTEXT_REVOCATION_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_CONTROL_STORE_FLAGS(pub u32);
pub const CERT_STORE_CTRL_COMMIT_FORCE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
pub const CERT_STORE_CTRL_COMMIT_CLEAR_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(2u32);
pub const CERT_STORE_CTRL_INHIBIT_DUPLICATE_HANDLE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
impl ::std::convert::From<u32> for CERT_CONTROL_STORE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_CONTROL_STORE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_CONTROL_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_CONTROL_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_CONTROL_STORE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_CONTROL_STORE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_CONTROL_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CREATE_CONTEXT_NOCOPY_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CREATE_CONTEXT_NO_ENTRY_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CREATE_CONTEXT_NO_HCRYPTMSG_FLAG: u32 = 4u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CREATE_CONTEXT_PARA {
    pub cbSize: u32,
    pub pfnFree: ::std::option::Option<PFN_CRYPT_FREE>,
    pub pvFree: *mut ::std::ffi::c_void,
    pub pfnSort: ::std::option::Option<PFN_CERT_CREATE_CONTEXT_SORT_FUNC>,
    pub pvSort: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CREATE_CONTEXT_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CREATE_CONTEXT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CREATE_CONTEXT_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CREATE_CONTEXT_PARA").field("cbSize", &self.cbSize).field("pvFree", &self.pvFree).field("pvSort", &self.pvSort).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CREATE_CONTEXT_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pfnFree.map(|f| f as usize) == other.pfnFree.map(|f| f as usize) && self.pvFree == other.pvFree && self.pfnSort.map(|f| f as usize) == other.pfnSort.map(|f| f as usize) && self.pvSort == other.pvSort
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CREATE_CONTEXT_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CREATE_CONTEXT_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CREATE_CONTEXT_SORTED_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_CREATE_SELFSIGN_FLAGS(pub u32);
pub const CERT_CREATE_SELFSIGN_NO_KEY_INFO: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(2u32);
pub const CERT_CREATE_SELFSIGN_NO_SIGN: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(1u32);
impl ::std::convert::From<u32> for CERT_CREATE_SELFSIGN_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_CREATE_SELFSIGN_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CREDENTIAL_PROVIDER_ID: i32 = -509i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_CRL_CONTEXT_PAIR {
    pub pCertContext: *mut CERT_CONTEXT,
    pub pCrlContext: *mut CRL_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_CRL_CONTEXT_PAIR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_CRL_CONTEXT_PAIR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_CRL_CONTEXT_PAIR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_CRL_CONTEXT_PAIR").field("pCertContext", &self.pCertContext).field("pCrlContext", &self.pCrlContext).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_CRL_CONTEXT_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.pCertContext == other.pCertContext && self.pCrlContext == other.pCrlContext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_CRL_CONTEXT_PAIR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_CRL_CONTEXT_PAIR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CRL_SIGN_KEY_USAGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CROSS_CERT_DIST_POINTS_PROP_ID: u32 = 23u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_CTL_USAGE_PROP_ID: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DATA_ENCIPHERMENT_KEY_USAGE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DATE_STAMP_PROP_ID: u32 = 27u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DECIPHER_ONLY_KEY_USAGE: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DESCRIPTION_PROP_ID: u32 = 13u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_DH_PARAMETERS {
    pub p: CRYPTOAPI_BLOB,
    pub g: CRYPTOAPI_BLOB,
}
impl CERT_DH_PARAMETERS {}
impl ::std::default::Default for CERT_DH_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_DH_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_DH_PARAMETERS").field("p", &self.p).field("g", &self.g).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_DH_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.g == other.g
    }
}
impl ::std::cmp::Eq for CERT_DH_PARAMETERS {}
unsafe impl ::windows::runtime::Abi for CERT_DH_PARAMETERS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DIGITAL_SIGNATURE_KEY_USAGE: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISALLOWED_ENHKEY_USAGE_PROP_ID: u32 = 122u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISALLOWED_FILETIME_PROP_ID: u32 = 104u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_DISTRUST_ADD_CA_CERT: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_DISTRUST_ADD_LEAF_CERT: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_DISTRUST_CA_CERT: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_DISTRUST_LEAF_CERT: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_SELECT: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_TRUST_ADD_CA_CERT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_TRUST_ADD_LEAF_CERT: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_TRUST_CA_CERT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DISPWELL_TRUST_LEAF_CERT: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_DSS_PARAMETERS {
    pub p: CRYPTOAPI_BLOB,
    pub q: CRYPTOAPI_BLOB,
    pub g: CRYPTOAPI_BLOB,
}
impl CERT_DSS_PARAMETERS {}
impl ::std::default::Default for CERT_DSS_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_DSS_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_DSS_PARAMETERS").field("p", &self.p).field("q", &self.q).field("g", &self.g).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_DSS_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.q == other.q && self.g == other.g
    }
}
impl ::std::cmp::Eq for CERT_DSS_PARAMETERS {}
unsafe impl ::windows::runtime::Abi for CERT_DSS_PARAMETERS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DSS_R_LEN: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_DSS_S_LEN: u32 = 20u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_ECC_SIGNATURE {
    pub r: CRYPTOAPI_BLOB,
    pub s: CRYPTOAPI_BLOB,
}
impl CERT_ECC_SIGNATURE {}
impl ::std::default::Default for CERT_ECC_SIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_ECC_SIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_ECC_SIGNATURE").field("r", &self.r).field("s", &self.s).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_ECC_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.r == other.r && self.s == other.s
    }
}
impl ::std::cmp::Eq for CERT_ECC_SIGNATURE {}
unsafe impl ::windows::runtime::Abi for CERT_ECC_SIGNATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_EFS_PROP_ID: u32 = 17u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ENCIPHER_ONLY_KEY_USAGE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ENCODING_TYPE_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_END_ENTITY_SUBJECT_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ENHKEY_USAGE_PROP_ID: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ENROLLMENT_PROP_ID: u32 = 26u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_EXCLUDED_SUBTREE_BIT: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_EXTENDED_ERROR_INFO_PROP_ID: u32 = 30u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_EXTENSION {
    pub pszObjId: super::super::Foundation::PSTR,
    pub fCritical: super::super::Foundation::BOOL,
    pub Value: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_EXTENSION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_EXTENSION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_EXTENSION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_EXTENSION").field("pszObjId", &self.pszObjId).field("fCritical", &self.fCritical).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_EXTENSION {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.fCritical == other.fCritical && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_EXTENSION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_EXTENSION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_EXTENSIONS {
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_EXTENSIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_EXTENSIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_EXTENSIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_EXTENSIONS").field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_EXTENSIONS {
    fn eq(&self, other: &Self) -> bool {
        self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_EXTENSIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_EXTENSIONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILE_HASH_USE_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILE_STORE_COMMIT_ENABLE_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_INCLUDE_V1_CERTS: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_ISSUER_CERTS_ONLY: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_KEY_EXISTS: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_LEAF_CERTS_ONLY: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_OP_EQUALITY: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_OP_EXISTS: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_OP_NOT_EXISTS: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_VALID_SIGNATURE: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FILTER_VALID_TIME_RANGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_FIND_CHAIN_IN_STORE_FLAGS(pub u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPARE_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(1u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPLEX_CHAIN_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(2u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(32768u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_URL_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(4u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_LOCAL_MACHINE_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(8u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_NO_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(16384u32);
impl ::std::convert::From<u32> for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_FIND_FLAGS(pub u32);
pub const CERT_FIND_ANY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(0u32);
pub const CERT_FIND_CERT_ID: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1048576u32);
pub const CERT_FIND_CTL_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
pub const CERT_FIND_ENHKEY_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
pub const CERT_FIND_EXISTING: CERT_FIND_FLAGS = CERT_FIND_FLAGS(851968u32);
pub const CERT_FIND_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
pub const CERT_FIND_HAS_PRIVATE_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1376256u32);
pub const CERT_FIND_ISSUER_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196612u32);
pub const CERT_FIND_ISSUER_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131076u32);
pub const CERT_FIND_ISSUER_OF: CERT_FIND_FLAGS = CERT_FIND_FLAGS(786432u32);
pub const CERT_FIND_ISSUER_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
pub const CERT_FIND_KEY_IDENTIFIER: CERT_FIND_FLAGS = CERT_FIND_FLAGS(983040u32);
pub const CERT_FIND_KEY_SPEC: CERT_FIND_FLAGS = CERT_FIND_FLAGS(589824u32);
pub const CERT_FIND_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(262144u32);
pub const CERT_FIND_PROPERTY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(327680u32);
pub const CERT_FIND_PUBLIC_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(393216u32);
pub const CERT_FIND_SHA1_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
pub const CERT_FIND_SIGNATURE_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(917504u32);
pub const CERT_FIND_SUBJECT_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196615u32);
pub const CERT_FIND_SUBJECT_CERT: CERT_FIND_FLAGS = CERT_FIND_FLAGS(720896u32);
pub const CERT_FIND_SUBJECT_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131079u32);
pub const CERT_FIND_SUBJECT_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
pub const CERT_FIND_CROSS_CERT_DIST_POINTS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1114112u32);
pub const CERT_FIND_PUBKEY_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1179648u32);
pub const CERT_FIND_SUBJECT_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458759u32);
pub const CERT_FIND_SUBJECT_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
pub const CERT_FIND_ISSUER_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458756u32);
pub const CERT_FIND_ISSUER_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
pub const CERT_FIND_SUBJECT_INFO_ACCESS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1245184u32);
pub const CERT_FIND_HASH_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1310720u32);
pub const CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
pub const CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
pub const CERT_FIND_PROP_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
pub const CERT_FIND_NO_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
pub const CERT_FIND_OR_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
pub const CERT_FIND_VALID_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
pub const CERT_FIND_OPTIONAL_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
pub const CERT_FIND_EXT_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
pub const CERT_FIND_PROP_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
pub const CERT_FIND_NO_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
pub const CERT_FIND_OR_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
pub const CERT_FIND_VALID_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
impl ::std::convert::From<u32> for CERT_FIND_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_FIND_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_FIND_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_FIND_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_FIND_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_FIND_TYPE(pub u32);
pub const CTL_FIND_ANY: CERT_FIND_TYPE = CERT_FIND_TYPE(0u32);
pub const CTL_FIND_SHA1_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
pub const CTL_FIND_MD5_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(2u32);
pub const CTL_FIND_USAGE: CERT_FIND_TYPE = CERT_FIND_TYPE(3u32);
pub const CTL_FIND_SAME_USAGE_FLAG: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
pub const CTL_FIND_EXISTING: CERT_FIND_TYPE = CERT_FIND_TYPE(5u32);
pub const CTL_FIND_SUBJECT: CERT_FIND_TYPE = CERT_FIND_TYPE(4u32);
impl ::std::convert::From<u32> for CERT_FIND_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_FIND_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_FIND_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_FIND_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_FIND_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_FIND_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_FIND_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FIRST_RESERVED_PROP_ID: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FIRST_USER_PROP_ID: u32 = 32768u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_FORTEZZA_DATA_PROP {
    pub SerialNumber: [u8; 8],
    pub CertIndex: i32,
    pub CertLabel: [u8; 36],
}
impl CERT_FORTEZZA_DATA_PROP {}
impl ::std::default::Default for CERT_FORTEZZA_DATA_PROP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_FORTEZZA_DATA_PROP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_FORTEZZA_DATA_PROP").field("SerialNumber", &self.SerialNumber).field("CertIndex", &self.CertIndex).field("CertLabel", &self.CertLabel).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_FORTEZZA_DATA_PROP {
    fn eq(&self, other: &Self) -> bool {
        self.SerialNumber == other.SerialNumber && self.CertIndex == other.CertIndex && self.CertLabel == other.CertLabel
    }
}
impl ::std::cmp::Eq for CERT_FORTEZZA_DATA_PROP {}
unsafe impl ::windows::runtime::Abi for CERT_FORTEZZA_DATA_PROP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FORTEZZA_DATA_PROP_ID: u32 = 18u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_FRIENDLY_NAME_PROP_ID: u32 = 11u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_GENERAL_SUBTREE {
    pub Base: CERT_ALT_NAME_ENTRY,
    pub dwMinimum: u32,
    pub fMaximum: super::super::Foundation::BOOL,
    pub dwMaximum: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_GENERAL_SUBTREE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_GENERAL_SUBTREE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_GENERAL_SUBTREE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_GENERAL_SUBTREE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_GENERAL_SUBTREE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_HASHED_URL {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Hash: CRYPTOAPI_BLOB,
    pub pwszUrl: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_HASHED_URL {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_HASHED_URL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_HASHED_URL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_HASHED_URL").field("HashAlgorithm", &self.HashAlgorithm).field("Hash", &self.Hash).field("pwszUrl", &self.pwszUrl).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_HASHED_URL {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.Hash == other.Hash && self.pwszUrl == other.pwszUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_HASHED_URL {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_HASHED_URL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_HASH_PROP_ID: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 79u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_HCRYPTPROV_TRANSFER_PROP_ID: u32 = 100u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_ID {
    pub dwIdChoice: CERT_ID_OPTION,
    pub Anonymous: CERT_ID_0,
}
impl CERT_ID {}
impl ::std::default::Default for CERT_ID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CERT_ID {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CERT_ID {}
unsafe impl ::windows::runtime::Abi for CERT_ID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub union CERT_ID_0 {
    pub IssuerSerialNumber: CERT_ISSUER_SERIAL_NUMBER,
    pub KeyId: CRYPTOAPI_BLOB,
    pub HashId: CRYPTOAPI_BLOB,
}
impl CERT_ID_0 {}
impl ::std::default::Default for CERT_ID_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CERT_ID_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CERT_ID_0 {}
unsafe impl ::windows::runtime::Abi for CERT_ID_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_ID_OPTION(pub u32);
pub const CERT_ID_ISSUER_SERIAL_NUMBER: CERT_ID_OPTION = CERT_ID_OPTION(1u32);
pub const CERT_ID_KEY_IDENTIFIER: CERT_ID_OPTION = CERT_ID_OPTION(2u32);
pub const CERT_ID_SHA1_HASH: CERT_ID_OPTION = CERT_ID_OPTION(3u32);
impl ::std::convert::From<u32> for CERT_ID_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_ID_OPTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_ID_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_ID_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_ID_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_ID_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_ID_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_IE30_RESERVED_PROP_ID: u32 = 7u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_INFO {
    pub dwVersion: u32,
    pub SerialNumber: CRYPTOAPI_BLOB,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Issuer: CRYPTOAPI_BLOB,
    pub NotBefore: super::super::Foundation::FILETIME,
    pub NotAfter: super::super::Foundation::FILETIME,
    pub Subject: CRYPTOAPI_BLOB,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub IssuerUniqueId: CRYPT_BIT_BLOB,
    pub SubjectUniqueId: CRYPT_BIT_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("SerialNumber", &self.SerialNumber)
            .field("SignatureAlgorithm", &self.SignatureAlgorithm)
            .field("Issuer", &self.Issuer)
            .field("NotBefore", &self.NotBefore)
            .field("NotAfter", &self.NotAfter)
            .field("Subject", &self.Subject)
            .field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo)
            .field("IssuerUniqueId", &self.IssuerUniqueId)
            .field("SubjectUniqueId", &self.SubjectUniqueId)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion
            && self.SerialNumber == other.SerialNumber
            && self.SignatureAlgorithm == other.SignatureAlgorithm
            && self.Issuer == other.Issuer
            && self.NotBefore == other.NotBefore
            && self.NotAfter == other.NotAfter
            && self.Subject == other.Subject
            && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo
            && self.IssuerUniqueId == other.IssuerUniqueId
            && self.SubjectUniqueId == other.SubjectUniqueId
            && self.cExtension == other.cExtension
            && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_EXTENSION_FLAG: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_ISSUER_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_ISSUER_UNIQUE_ID_FLAG: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_NOT_AFTER_FLAG: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_NOT_BEFORE_FLAG: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_SERIAL_NUMBER_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_SIGNATURE_ALGORITHM_FLAG: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_SUBJECT_FLAG: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_SUBJECT_UNIQUE_ID_FLAG: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_INFO_VERSION_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISOLATED_KEY_PROP_ID: u32 = 118u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISSUER_CHAIN_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 96u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISSUER_CHAIN_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 95u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 24u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISSUER_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 94u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_ISSUER_SERIAL_NUMBER {
    pub Issuer: CRYPTOAPI_BLOB,
    pub SerialNumber: CRYPTOAPI_BLOB,
}
impl CERT_ISSUER_SERIAL_NUMBER {}
impl ::std::default::Default for CERT_ISSUER_SERIAL_NUMBER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_ISSUER_SERIAL_NUMBER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_ISSUER_SERIAL_NUMBER").field("Issuer", &self.Issuer).field("SerialNumber", &self.SerialNumber).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_ISSUER_SERIAL_NUMBER {
    fn eq(&self, other: &Self) -> bool {
        self.Issuer == other.Issuer && self.SerialNumber == other.SerialNumber
    }
}
impl ::std::cmp::Eq for CERT_ISSUER_SERIAL_NUMBER {}
unsafe impl ::windows::runtime::Abi for CERT_ISSUER_SERIAL_NUMBER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: u32 = 28u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_KEYGEN_REQUEST_INFO {
    pub dwVersion: u32,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub pwszChallengeString: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_KEYGEN_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_KEYGEN_REQUEST_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_KEYGEN_REQUEST_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_KEYGEN_REQUEST_INFO").field("dwVersion", &self.dwVersion).field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo).field("pwszChallengeString", &self.pwszChallengeString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_KEYGEN_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo && self.pwszChallengeString == other.pwszChallengeString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_KEYGEN_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_KEYGEN_REQUEST_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEYGEN_REQUEST_V1: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_AGREEMENT_KEY_USAGE: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_KEY_ATTRIBUTES_INFO {
    pub KeyId: CRYPTOAPI_BLOB,
    pub IntendedKeyUsage: CRYPT_BIT_BLOB,
    pub pPrivateKeyUsagePeriod: *mut CERT_PRIVATE_KEY_VALIDITY,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_KEY_ATTRIBUTES_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_KEY_ATTRIBUTES_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_KEY_ATTRIBUTES_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_KEY_ATTRIBUTES_INFO").field("KeyId", &self.KeyId).field("IntendedKeyUsage", &self.IntendedKeyUsage).field("pPrivateKeyUsagePeriod", &self.pPrivateKeyUsagePeriod).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_KEY_ATTRIBUTES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.IntendedKeyUsage == other.IntendedKeyUsage && self.pPrivateKeyUsagePeriod == other.pPrivateKeyUsagePeriod
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_KEY_ATTRIBUTES_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_KEY_ATTRIBUTES_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_CERT_SIGN_KEY_USAGE: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_CLASSIFICATION_PROP_ID: u32 = 120u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_KEY_CONTEXT {
    pub cbSize: u32,
    pub Anonymous: CERT_KEY_CONTEXT_0,
    pub dwKeySpec: u32,
}
impl CERT_KEY_CONTEXT {}
impl ::std::default::Default for CERT_KEY_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CERT_KEY_CONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CERT_KEY_CONTEXT {}
unsafe impl ::windows::runtime::Abi for CERT_KEY_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub union CERT_KEY_CONTEXT_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
impl CERT_KEY_CONTEXT_0 {}
impl ::std::default::Default for CERT_KEY_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CERT_KEY_CONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CERT_KEY_CONTEXT_0 {}
unsafe impl ::windows::runtime::Abi for CERT_KEY_CONTEXT_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_CONTEXT_PROP_ID: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_ENCIPHERMENT_KEY_USAGE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_IDENTIFIER_PROP_ID: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_PROV_HANDLE_PROP_ID: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_PROV_INFO_PROP_ID: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_REPAIR_ATTEMPTED_PROP_ID: u32 = 103u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_KEY_SPEC(pub u32);
pub const AT_KEYEXCHANGE: CERT_KEY_SPEC = CERT_KEY_SPEC(1u32);
pub const AT_SIGNATURE: CERT_KEY_SPEC = CERT_KEY_SPEC(2u32);
pub const CERT_NCRYPT_KEY_SPEC: CERT_KEY_SPEC = CERT_KEY_SPEC(4294967295u32);
impl ::std::convert::From<u32> for CERT_KEY_SPEC {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_KEY_SPEC {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_KEY_SPEC {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_KEY_SPEC {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_KEY_SPEC {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_KEY_SPEC {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_KEY_SPEC {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_KEY_SPEC_PROP_ID: u32 = 6u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_KEY_USAGE_RESTRICTION_INFO {
    pub cCertPolicyId: u32,
    pub rgCertPolicyId: *mut CERT_POLICY_ID,
    pub RestrictedKeyUsage: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_KEY_USAGE_RESTRICTION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_KEY_USAGE_RESTRICTION_INFO").field("cCertPolicyId", &self.cCertPolicyId).field("rgCertPolicyId", &self.rgCertPolicyId).field("RestrictedKeyUsage", &self.RestrictedKeyUsage).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCertPolicyId == other.cCertPolicyId && self.rgCertPolicyId == other.rgCertPolicyId && self.RestrictedKeyUsage == other.RestrictedKeyUsage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_KEY_USAGE_RESTRICTION_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_KEY_USAGE_RESTRICTION_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LAST_RESERVED_PROP_ID: u32 = 32767u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LAST_USER_PROP_ID: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LDAP_STORE_AREC_EXCLUSIVE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LDAP_STORE_OPENED_FLAG: u32 = 262144u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LDAP_STORE_OPENED_PARA {
    pub pvLdapSessionHandle: *mut ::std::ffi::c_void,
    pub pwszLdapUrl: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LDAP_STORE_OPENED_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LDAP_STORE_OPENED_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LDAP_STORE_OPENED_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LDAP_STORE_OPENED_PARA").field("pvLdapSessionHandle", &self.pvLdapSessionHandle).field("pwszLdapUrl", &self.pwszLdapUrl).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LDAP_STORE_OPENED_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pvLdapSessionHandle == other.pvLdapSessionHandle && self.pwszLdapUrl == other.pwszLdapUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LDAP_STORE_OPENED_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LDAP_STORE_OPENED_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LDAP_STORE_SIGN_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_LDAP_STORE_UNBIND_FLAG: u32 = 524288u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_AUDIO {
    pub LogotypeDetails: CERT_LOGOTYPE_DETAILS,
    pub pLogotypeAudioInfo: *mut CERT_LOGOTYPE_AUDIO_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_AUDIO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_AUDIO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_AUDIO").field("LogotypeDetails", &self.LogotypeDetails).field("pLogotypeAudioInfo", &self.pLogotypeAudioInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_AUDIO {
    fn eq(&self, other: &Self) -> bool {
        self.LogotypeDetails == other.LogotypeDetails && self.pLogotypeAudioInfo == other.pLogotypeAudioInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_AUDIO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_AUDIO_INFO {
    pub dwFileSize: u32,
    pub dwPlayTime: u32,
    pub dwChannels: u32,
    pub dwSampleRate: u32,
    pub pwszLanguage: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_AUDIO_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_AUDIO_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_AUDIO_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_AUDIO_INFO").field("dwFileSize", &self.dwFileSize).field("dwPlayTime", &self.dwPlayTime).field("dwChannels", &self.dwChannels).field("dwSampleRate", &self.dwSampleRate).field("pwszLanguage", &self.pwszLanguage).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_AUDIO_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFileSize == other.dwFileSize && self.dwPlayTime == other.dwPlayTime && self.dwChannels == other.dwChannels && self.dwSampleRate == other.dwSampleRate && self.pwszLanguage == other.pwszLanguage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_AUDIO_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_AUDIO_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_LOGOTYPE_CHOICE(pub u32);
pub const CERT_LOGOTYPE_NO_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(0u32);
pub const CERT_LOGOTYPE_BITS_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(1u32);
pub const CERT_LOGOTYPE_TABLE_SIZE_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(2u32);
impl ::std::convert::From<u32> for CERT_LOGOTYPE_CHOICE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_CHOICE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_LOGOTYPE_CHOICE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_LOGOTYPE_CHOICE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_LOGOTYPE_CHOICE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_LOGOTYPE_CHOICE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_LOGOTYPE_CHOICE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_DATA {
    pub cLogotypeImage: u32,
    pub rgLogotypeImage: *mut CERT_LOGOTYPE_IMAGE,
    pub cLogotypeAudio: u32,
    pub rgLogotypeAudio: *mut CERT_LOGOTYPE_AUDIO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_DATA").field("cLogotypeImage", &self.cLogotypeImage).field("rgLogotypeImage", &self.rgLogotypeImage).field("cLogotypeAudio", &self.cLogotypeAudio).field("rgLogotypeAudio", &self.rgLogotypeAudio).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.cLogotypeImage == other.cLogotypeImage && self.rgLogotypeImage == other.rgLogotypeImage && self.cLogotypeAudio == other.cLogotypeAudio && self.rgLogotypeAudio == other.rgLogotypeAudio
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_DETAILS {
    pub pwszMimeType: super::super::Foundation::PWSTR,
    pub cHashedUrl: u32,
    pub rgHashedUrl: *mut CERT_HASHED_URL,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_DETAILS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_DETAILS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_DETAILS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_DETAILS").field("pwszMimeType", &self.pwszMimeType).field("cHashedUrl", &self.cHashedUrl).field("rgHashedUrl", &self.rgHashedUrl).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_DETAILS {
    fn eq(&self, other: &Self) -> bool {
        self.pwszMimeType == other.pwszMimeType && self.cHashedUrl == other.cHashedUrl && self.rgHashedUrl == other.rgHashedUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_DETAILS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_DETAILS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_EXT_INFO {
    pub cCommunityLogo: u32,
    pub rgCommunityLogo: *mut CERT_LOGOTYPE_INFO,
    pub pIssuerLogo: *mut CERT_LOGOTYPE_INFO,
    pub pSubjectLogo: *mut CERT_LOGOTYPE_INFO,
    pub cOtherLogo: u32,
    pub rgOtherLogo: *mut CERT_OTHER_LOGOTYPE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_EXT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_EXT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_EXT_INFO")
            .field("cCommunityLogo", &self.cCommunityLogo)
            .field("rgCommunityLogo", &self.rgCommunityLogo)
            .field("pIssuerLogo", &self.pIssuerLogo)
            .field("pSubjectLogo", &self.pSubjectLogo)
            .field("cOtherLogo", &self.cOtherLogo)
            .field("rgOtherLogo", &self.rgOtherLogo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCommunityLogo == other.cCommunityLogo && self.rgCommunityLogo == other.rgCommunityLogo && self.pIssuerLogo == other.pIssuerLogo && self.pSubjectLogo == other.pSubjectLogo && self.cOtherLogo == other.cOtherLogo && self.rgOtherLogo == other.rgOtherLogo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_EXT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_IMAGE {
    pub LogotypeDetails: CERT_LOGOTYPE_DETAILS,
    pub pLogotypeImageInfo: *mut CERT_LOGOTYPE_IMAGE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_IMAGE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_IMAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_IMAGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_IMAGE").field("LogotypeDetails", &self.LogotypeDetails).field("pLogotypeImageInfo", &self.pLogotypeImageInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_IMAGE {
    fn eq(&self, other: &Self) -> bool {
        self.LogotypeDetails == other.LogotypeDetails && self.pLogotypeImageInfo == other.pLogotypeImageInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_IMAGE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_IMAGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_IMAGE_INFO {
    pub dwLogotypeImageInfoChoice: CERT_LOGOTYPE_IMAGE_INFO_TYPE,
    pub dwFileSize: u32,
    pub dwXSize: u32,
    pub dwYSize: u32,
    pub dwLogotypeImageResolutionChoice: CERT_LOGOTYPE_CHOICE,
    pub Anonymous: CERT_LOGOTYPE_IMAGE_INFO_0,
    pub pwszLanguage: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_IMAGE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_IMAGE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_IMAGE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_IMAGE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_IMAGE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CERT_LOGOTYPE_IMAGE_INFO_0 {
    pub dwNumBits: u32,
    pub dwTableSize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_IMAGE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_IMAGE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_IMAGE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_IMAGE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_IMAGE_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_LOGOTYPE_IMAGE_INFO_TYPE(pub u32);
pub const CERT_LOGOTYPE_GRAY_SCALE_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(1u32);
pub const CERT_LOGOTYPE_COLOR_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(2u32);
impl ::std::convert::From<u32> for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_INFO {
    pub dwLogotypeInfoChoice: CERT_LOGOTYPE_OPTION,
    pub Anonymous: CERT_LOGOTYPE_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CERT_LOGOTYPE_INFO_0 {
    pub pLogotypeDirectInfo: *mut CERT_LOGOTYPE_DATA,
    pub pLogotypeIndirectInfo: *mut CERT_LOGOTYPE_REFERENCE,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_LOGOTYPE_OPTION(pub u32);
pub const CERT_LOGOTYPE_DIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(1u32);
pub const CERT_LOGOTYPE_INDIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(2u32);
impl ::std::convert::From<u32> for CERT_LOGOTYPE_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_OPTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_LOGOTYPE_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_LOGOTYPE_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_LOGOTYPE_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_LOGOTYPE_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_LOGOTYPE_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_LOGOTYPE_REFERENCE {
    pub cHashedUrl: u32,
    pub rgHashedUrl: *mut CERT_HASHED_URL,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_LOGOTYPE_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_LOGOTYPE_REFERENCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_LOGOTYPE_REFERENCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_LOGOTYPE_REFERENCE").field("cHashedUrl", &self.cHashedUrl).field("rgHashedUrl", &self.rgHashedUrl).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_LOGOTYPE_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.cHashedUrl == other.cHashedUrl && self.rgHashedUrl == other.rgHashedUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_LOGOTYPE_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_LOGOTYPE_REFERENCE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_MD5_HASH_PROP_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_ATTR_TYPE: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_NAME_CONSTRAINTS_INFO {
    pub cPermittedSubtree: u32,
    pub rgPermittedSubtree: *mut CERT_GENERAL_SUBTREE,
    pub cExcludedSubtree: u32,
    pub rgExcludedSubtree: *mut CERT_GENERAL_SUBTREE,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_NAME_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_NAME_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_NAME_CONSTRAINTS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_NAME_CONSTRAINTS_INFO").field("cPermittedSubtree", &self.cPermittedSubtree).field("rgPermittedSubtree", &self.rgPermittedSubtree).field("cExcludedSubtree", &self.cExcludedSubtree).field("rgExcludedSubtree", &self.rgExcludedSubtree).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_NAME_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPermittedSubtree == other.cPermittedSubtree && self.rgPermittedSubtree == other.rgPermittedSubtree && self.cExcludedSubtree == other.cExcludedSubtree && self.rgExcludedSubtree == other.rgExcludedSubtree
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_NAME_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_NAME_CONSTRAINTS_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_DNS_TYPE: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_EMAIL_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_FRIENDLY_DISPLAY_TYPE: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_NAME_INFO {
    pub cRDN: u32,
    pub rgRDN: *mut CERT_RDN,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_NAME_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_NAME_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_NAME_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_NAME_INFO").field("cRDN", &self.cRDN).field("rgRDN", &self.rgRDN).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_NAME_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cRDN == other.cRDN && self.rgRDN == other.rgRDN
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_NAME_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_NAME_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_ISSUER_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_RDN_TYPE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_SEARCH_ALL_NAMES_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_SIMPLE_DISPLAY_TYPE: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_COMMA_FLAG: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_CRLF_FLAG: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_DISABLE_UTF8_DIR_STR_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_ENABLE_PUNYCODE_FLAG: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_ENABLE_T61_UNICODE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_ENABLE_UTF8_UNICODE_FLAG: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_FORCE_UTF8_DIR_STR_FLAG: u32 = 524288u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_FORWARD_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_NO_PLUS_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_NO_QUOTING_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_REVERSE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_STR_SEMICOLON_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_UPN_TYPE: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NAME_URL_TYPE: u32 = 7u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_NAME_VALUE {
    pub dwValueType: u32,
    pub Value: CRYPTOAPI_BLOB,
}
impl CERT_NAME_VALUE {}
impl ::std::default::Default for CERT_NAME_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_NAME_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_NAME_VALUE").field("dwValueType", &self.dwValueType).field("Value", &self.Value).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_NAME_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.dwValueType == other.dwValueType && self.Value == other.Value
    }
}
impl ::std::cmp::Eq for CERT_NAME_VALUE {}
unsafe impl ::windows::runtime::Abi for CERT_NAME_VALUE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 78u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NCRYPT_KEY_HANDLE_TRANSFER_PROP_ID: u32 = 99u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NEW_KEY_PROP_ID: u32 = 74u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NEXT_UPDATE_LOCATION_PROP_ID: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NONCOMPLIANT_ROOT_URL_PROP_ID: u32 = 123u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NON_REPUDIATION_KEY_USAGE: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NOT_BEFORE_ENHKEY_USAGE_PROP_ID: u32 = 127u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NOT_BEFORE_FILETIME_PROP_ID: u32 = 126u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID: u32 = 77u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_NO_EXPIRE_NOTIFICATION_PROP_ID: u32 = 97u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_OCSP_CACHE_PREFIX_PROP_ID: u32 = 75u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_OCSP_MUST_STAPLE_PROP_ID: u32 = 121u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_OCSP_RESPONSE_PROP_ID: u32 = 70u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_OFFLINE_CRL_SIGN_KEY_USAGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_OPEN_STORE_FLAGS(pub u32);
pub const CERT_STORE_BACKUP_RESTORE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2048u32);
pub const CERT_STORE_CREATE_NEW_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(8192u32);
pub const CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4u32);
pub const CERT_STORE_DELETE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16u32);
pub const CERT_STORE_ENUM_ARCHIVED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(512u32);
pub const CERT_STORE_MAXIMUM_ALLOWED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4096u32);
pub const CERT_STORE_NO_CRYPT_RELEASE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1u32);
pub const CERT_STORE_OPEN_EXISTING_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16384u32);
pub const CERT_STORE_READONLY_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(32768u32);
pub const CERT_STORE_SET_LOCALIZED_NAME_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2u32);
pub const CERT_STORE_SHARE_CONTEXT_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(128u32);
pub const CERT_STORE_UPDATE_KEYID_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1024u32);
impl ::std::convert::From<u32> for CERT_OPEN_STORE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_OPEN_STORE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_OPEN_STORE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_OPEN_STORE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_OR_CRL_BLOB {
    pub dwChoice: u32,
    pub cbEncoded: u32,
    pub pbEncoded: *mut u8,
}
impl CERT_OR_CRL_BLOB {}
impl ::std::default::Default for CERT_OR_CRL_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_OR_CRL_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_OR_CRL_BLOB").field("dwChoice", &self.dwChoice).field("cbEncoded", &self.cbEncoded).field("pbEncoded", &self.pbEncoded).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_OR_CRL_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwChoice == other.dwChoice && self.cbEncoded == other.cbEncoded && self.pbEncoded == other.pbEncoded
    }
}
impl ::std::cmp::Eq for CERT_OR_CRL_BLOB {}
unsafe impl ::windows::runtime::Abi for CERT_OR_CRL_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_OR_CRL_BUNDLE {
    pub cItem: u32,
    pub rgItem: *mut CERT_OR_CRL_BLOB,
}
impl CERT_OR_CRL_BUNDLE {}
impl ::std::default::Default for CERT_OR_CRL_BUNDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_OR_CRL_BUNDLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_OR_CRL_BUNDLE").field("cItem", &self.cItem).field("rgItem", &self.rgItem).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_OR_CRL_BUNDLE {
    fn eq(&self, other: &Self) -> bool {
        self.cItem == other.cItem && self.rgItem == other.rgItem
    }
}
impl ::std::cmp::Eq for CERT_OR_CRL_BUNDLE {}
unsafe impl ::windows::runtime::Abi for CERT_OR_CRL_BUNDLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_OTHER_LOGOTYPE_INFO {
    pub pszObjId: super::super::Foundation::PSTR,
    pub LogotypeInfo: CERT_LOGOTYPE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_OTHER_LOGOTYPE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_OTHER_LOGOTYPE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_OTHER_LOGOTYPE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_OTHER_LOGOTYPE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_OTHER_LOGOTYPE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_OTHER_NAME {
    pub pszObjId: super::super::Foundation::PSTR,
    pub Value: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_OTHER_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_OTHER_NAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_OTHER_NAME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_OTHER_NAME").field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_OTHER_NAME {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_OTHER_NAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_OTHER_NAME {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_PAIR {
    pub Forward: CRYPTOAPI_BLOB,
    pub Reverse: CRYPTOAPI_BLOB,
}
impl CERT_PAIR {}
impl ::std::default::Default for CERT_PAIR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_PAIR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_PAIR").field("Forward", &self.Forward).field("Reverse", &self.Reverse).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.Forward == other.Forward && self.Reverse == other.Reverse
    }
}
impl ::std::cmp::Eq for CERT_PAIR {}
unsafe impl ::windows::runtime::Abi for CERT_PAIR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PHYSICAL_STORE_ADD_ENABLE_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_PHYSICAL_STORE_INFO {
    pub cbSize: u32,
    pub pszOpenStoreProvider: super::super::Foundation::PSTR,
    pub dwOpenEncodingType: u32,
    pub dwOpenFlags: u32,
    pub OpenParameters: CRYPTOAPI_BLOB,
    pub dwFlags: u32,
    pub dwPriority: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_PHYSICAL_STORE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_PHYSICAL_STORE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_PHYSICAL_STORE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_PHYSICAL_STORE_INFO")
            .field("cbSize", &self.cbSize)
            .field("pszOpenStoreProvider", &self.pszOpenStoreProvider)
            .field("dwOpenEncodingType", &self.dwOpenEncodingType)
            .field("dwOpenFlags", &self.dwOpenFlags)
            .field("OpenParameters", &self.OpenParameters)
            .field("dwFlags", &self.dwFlags)
            .field("dwPriority", &self.dwPriority)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_PHYSICAL_STORE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszOpenStoreProvider == other.pszOpenStoreProvider && self.dwOpenEncodingType == other.dwOpenEncodingType && self.dwOpenFlags == other.dwOpenFlags && self.OpenParameters == other.OpenParameters && self.dwFlags == other.dwFlags && self.dwPriority == other.dwPriority
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_PHYSICAL_STORE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_PHYSICAL_STORE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PHYSICAL_STORE_INSERT_COMPUTER_NAME_ENABLE_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PHYSICAL_STORE_OPEN_DISABLE_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PHYSICAL_STORE_PREDEFINED_ENUM_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PHYSICAL_STORE_REMOTE_OPEN_DISABLE_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PIN_SHA256_HASH_PROP_ID: u32 = 124u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICIES_INFO {
    pub cPolicyInfo: u32,
    pub rgPolicyInfo: *mut CERT_POLICY_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICIES_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICIES_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICIES_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICIES_INFO").field("cPolicyInfo", &self.cPolicyInfo).field("rgPolicyInfo", &self.rgPolicyInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICIES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPolicyInfo == other.cPolicyInfo && self.rgPolicyInfo == other.rgPolicyInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICIES_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICIES_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY95_QUALIFIER1 {
    pub pszPracticesReference: super::super::Foundation::PWSTR,
    pub pszNoticeIdentifier: super::super::Foundation::PSTR,
    pub pszNSINoticeIdentifier: super::super::Foundation::PSTR,
    pub cCPSURLs: u32,
    pub rgCPSURLs: *mut CPS_URLS,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY95_QUALIFIER1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY95_QUALIFIER1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY95_QUALIFIER1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY95_QUALIFIER1")
            .field("pszPracticesReference", &self.pszPracticesReference)
            .field("pszNoticeIdentifier", &self.pszNoticeIdentifier)
            .field("pszNSINoticeIdentifier", &self.pszNSINoticeIdentifier)
            .field("cCPSURLs", &self.cCPSURLs)
            .field("rgCPSURLs", &self.rgCPSURLs)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY95_QUALIFIER1 {
    fn eq(&self, other: &Self) -> bool {
        self.pszPracticesReference == other.pszPracticesReference && self.pszNoticeIdentifier == other.pszNoticeIdentifier && self.pszNSINoticeIdentifier == other.pszNSINoticeIdentifier && self.cCPSURLs == other.cCPSURLs && self.rgCPSURLs == other.rgCPSURLs
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY95_QUALIFIER1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY95_QUALIFIER1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_CONSTRAINTS_INFO {
    pub fRequireExplicitPolicy: super::super::Foundation::BOOL,
    pub dwRequireExplicitPolicySkipCerts: u32,
    pub fInhibitPolicyMapping: super::super::Foundation::BOOL,
    pub dwInhibitPolicyMappingSkipCerts: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_CONSTRAINTS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_CONSTRAINTS_INFO")
            .field("fRequireExplicitPolicy", &self.fRequireExplicitPolicy)
            .field("dwRequireExplicitPolicySkipCerts", &self.dwRequireExplicitPolicySkipCerts)
            .field("fInhibitPolicyMapping", &self.fInhibitPolicyMapping)
            .field("dwInhibitPolicyMappingSkipCerts", &self.dwInhibitPolicyMappingSkipCerts)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.fRequireExplicitPolicy == other.fRequireExplicitPolicy && self.dwRequireExplicitPolicySkipCerts == other.dwRequireExplicitPolicySkipCerts && self.fInhibitPolicyMapping == other.fInhibitPolicyMapping && self.dwInhibitPolicyMappingSkipCerts == other.dwInhibitPolicyMappingSkipCerts
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_CONSTRAINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_CONSTRAINTS_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_ID {
    pub cCertPolicyElementId: u32,
    pub rgpszCertPolicyElementId: *mut super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_ID {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_ID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_ID {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_ID").field("cCertPolicyElementId", &self.cCertPolicyElementId).field("rgpszCertPolicyElementId", &self.rgpszCertPolicyElementId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_ID {
    fn eq(&self, other: &Self) -> bool {
        self.cCertPolicyElementId == other.cCertPolicyElementId && self.rgpszCertPolicyElementId == other.rgpszCertPolicyElementId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_ID {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_ID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_INFO {
    pub pszPolicyIdentifier: super::super::Foundation::PSTR,
    pub cPolicyQualifier: u32,
    pub rgPolicyQualifier: *mut CERT_POLICY_QUALIFIER_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_INFO").field("pszPolicyIdentifier", &self.pszPolicyIdentifier).field("cPolicyQualifier", &self.cPolicyQualifier).field("rgPolicyQualifier", &self.rgPolicyQualifier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszPolicyIdentifier == other.pszPolicyIdentifier && self.cPolicyQualifier == other.cPolicyQualifier && self.rgPolicyQualifier == other.rgPolicyQualifier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_MAPPING {
    pub pszIssuerDomainPolicy: super::super::Foundation::PSTR,
    pub pszSubjectDomainPolicy: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_MAPPING {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_MAPPING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_MAPPING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_MAPPING").field("pszIssuerDomainPolicy", &self.pszIssuerDomainPolicy).field("pszSubjectDomainPolicy", &self.pszSubjectDomainPolicy).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_MAPPING {
    fn eq(&self, other: &Self) -> bool {
        self.pszIssuerDomainPolicy == other.pszIssuerDomainPolicy && self.pszSubjectDomainPolicy == other.pszSubjectDomainPolicy
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_MAPPING {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_MAPPING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_MAPPINGS_INFO {
    pub cPolicyMapping: u32,
    pub rgPolicyMapping: *mut CERT_POLICY_MAPPING,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_MAPPINGS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_MAPPINGS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_MAPPINGS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_MAPPINGS_INFO").field("cPolicyMapping", &self.cPolicyMapping).field("rgPolicyMapping", &self.rgPolicyMapping).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_MAPPINGS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPolicyMapping == other.cPolicyMapping && self.rgPolicyMapping == other.rgPolicyMapping
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_MAPPINGS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_MAPPINGS_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_QUALIFIER_INFO {
    pub pszPolicyQualifierId: super::super::Foundation::PSTR,
    pub Qualifier: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_QUALIFIER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_QUALIFIER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_QUALIFIER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_QUALIFIER_INFO").field("pszPolicyQualifierId", &self.pszPolicyQualifierId).field("Qualifier", &self.Qualifier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_QUALIFIER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszPolicyQualifierId == other.pszPolicyQualifierId && self.Qualifier == other.Qualifier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_QUALIFIER_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_QUALIFIER_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    pub pszOrganization: super::super::Foundation::PSTR,
    pub cNoticeNumbers: u32,
    pub rgNoticeNumbers: *mut i32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_QUALIFIER_NOTICE_REFERENCE").field("pszOrganization", &self.pszOrganization).field("cNoticeNumbers", &self.cNoticeNumbers).field("rgNoticeNumbers", &self.rgNoticeNumbers).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.pszOrganization == other.pszOrganization && self.cNoticeNumbers == other.cNoticeNumbers && self.rgNoticeNumbers == other.rgNoticeNumbers
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_POLICY_QUALIFIER_USER_NOTICE {
    pub pNoticeReference: *mut CERT_POLICY_QUALIFIER_NOTICE_REFERENCE,
    pub pszDisplayText: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_POLICY_QUALIFIER_USER_NOTICE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_POLICY_QUALIFIER_USER_NOTICE").field("pNoticeReference", &self.pNoticeReference).field("pszDisplayText", &self.pszDisplayText).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn eq(&self, other: &Self) -> bool {
        self.pNoticeReference == other.pNoticeReference && self.pszDisplayText == other.pszDisplayText
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_POLICY_QUALIFIER_USER_NOTICE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_POLICY_QUALIFIER_USER_NOTICE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_PRIVATE_KEY_VALIDITY {
    pub NotBefore: super::super::Foundation::FILETIME,
    pub NotAfter: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_PRIVATE_KEY_VALIDITY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_PRIVATE_KEY_VALIDITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_PRIVATE_KEY_VALIDITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_PRIVATE_KEY_VALIDITY").field("NotBefore", &self.NotBefore).field("NotAfter", &self.NotAfter).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_PRIVATE_KEY_VALIDITY {
    fn eq(&self, other: &Self) -> bool {
        self.NotBefore == other.NotBefore && self.NotAfter == other.NotAfter
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_PRIVATE_KEY_VALIDITY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_PRIVATE_KEY_VALIDITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_DISABLE_CURRENT_USER_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_DISABLE_LM_AUTH_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_DISABLE_NOT_DEFINED_NAME_CONSTRAINT_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_DISABLE_NT_AUTH_REQUIRED_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_DISABLE_PEER_TRUST: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_INHIBIT_ADD_AT_INIT_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_INHIBIT_PURGE_LM_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PROT_ROOT_ONLY_LM_GPT_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PUBKEY_ALG_PARA_PROP_ID: u32 = 22u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PUBKEY_HASH_RESERVED_PROP_ID: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_PUBLIC_KEY_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub PublicKey: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_PUBLIC_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_PUBLIC_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_PUBLIC_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_PUBLIC_KEY_INFO").field("Algorithm", &self.Algorithm).field("PublicKey", &self.PublicKey).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_PUBLIC_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.PublicKey == other.PublicKey
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_PUBLIC_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_PUBLIC_KEY_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 93u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_PVK_FILE_PROP_ID: u32 = 12u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_QC_STATEMENT {
    pub pszStatementId: super::super::Foundation::PSTR,
    pub StatementInfo: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_QC_STATEMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_QC_STATEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_QC_STATEMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_QC_STATEMENT").field("pszStatementId", &self.pszStatementId).field("StatementInfo", &self.StatementInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_QC_STATEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.pszStatementId == other.pszStatementId && self.StatementInfo == other.StatementInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_QC_STATEMENT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_QC_STATEMENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_QC_STATEMENTS_EXT_INFO {
    pub cStatement: u32,
    pub rgStatement: *mut CERT_QC_STATEMENT,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_QC_STATEMENTS_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_QC_STATEMENTS_EXT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_QC_STATEMENTS_EXT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_QC_STATEMENTS_EXT_INFO").field("cStatement", &self.cStatement).field("rgStatement", &self.rgStatement).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_QC_STATEMENTS_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cStatement == other.cStatement && self.rgStatement == other.rgStatement
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_QC_STATEMENTS_EXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_QC_STATEMENTS_EXT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_CONTENT_TYPE(pub u32);
pub const CERT_QUERY_CONTENT_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(1u32);
pub const CERT_QUERY_CONTENT_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(2u32);
pub const CERT_QUERY_CONTENT_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(3u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(4u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(5u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(6u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(7u32);
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(8u32);
pub const CERT_QUERY_CONTENT_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(9u32);
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(10u32);
pub const CERT_QUERY_CONTENT_PKCS10: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(11u32);
pub const CERT_QUERY_CONTENT_PFX: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(12u32);
pub const CERT_QUERY_CONTENT_CERT_PAIR: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(13u32);
pub const CERT_QUERY_CONTENT_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(14u32);
impl ::std::convert::From<u32> for CERT_QUERY_CONTENT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_CONTENT_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_CONTENT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_CONTENT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_CONTENT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_CONTENT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_CONTENT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_CONTENT_TYPE_FLAGS(pub u32);
pub const CERT_QUERY_CONTENT_FLAG_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2u32);
pub const CERT_QUERY_CONTENT_FLAG_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4u32);
pub const CERT_QUERY_CONTENT_FLAG_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(32u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(64u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(128u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(256u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(512u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(1024u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS10: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2048u32);
pub const CERT_QUERY_CONTENT_FLAG_PFX: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4096u32);
pub const CERT_QUERY_CONTENT_FLAG_CERT_PAIR: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8192u32);
pub const CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16384u32);
pub const CERT_QUERY_CONTENT_FLAG_ALL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16382u32);
pub const CERT_QUERY_CONTENT_FLAG_ALL_ISSUER_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(818u32);
impl ::std::convert::From<u32> for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_ENCODING_TYPE(pub u32);
pub const X509_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(1u32);
pub const PKCS_7_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(65536u32);
impl ::std::convert::From<u32> for CERT_QUERY_ENCODING_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_ENCODING_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_FORMAT_TYPE(pub u32);
pub const CERT_QUERY_FORMAT_BINARY: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(1u32);
pub const CERT_QUERY_FORMAT_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(2u32);
pub const CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(3u32);
impl ::std::convert::From<u32> for CERT_QUERY_FORMAT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_FORMAT_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_FORMAT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_FORMAT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_FORMAT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_FORMAT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_FORMAT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_FORMAT_TYPE_FLAGS(pub u32);
pub const CERT_QUERY_FORMAT_FLAG_BINARY: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(2u32);
pub const CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(4u32);
pub const CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(8u32);
pub const CERT_QUERY_FORMAT_FLAG_ALL: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(14u32);
impl ::std::convert::From<u32> for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_QUERY_OBJECT_TYPE(pub u32);
pub const CERT_QUERY_OBJECT_FILE: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(1u32);
pub const CERT_QUERY_OBJECT_BLOB: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(2u32);
impl ::std::convert::From<u32> for CERT_QUERY_OBJECT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_QUERY_OBJECT_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_QUERY_OBJECT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_QUERY_OBJECT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_QUERY_OBJECT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_QUERY_OBJECT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_QUERY_OBJECT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_RDN {
    pub cRDNAttr: u32,
    pub rgRDNAttr: *mut CERT_RDN_ATTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_RDN {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_RDN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_RDN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_RDN").field("cRDNAttr", &self.cRDNAttr).field("rgRDNAttr", &self.rgRDNAttr).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_RDN {
    fn eq(&self, other: &Self) -> bool {
        self.cRDNAttr == other.cRDNAttr && self.rgRDNAttr == other.rgRDNAttr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_RDN {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_RDN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_RDN_ATTR {
    pub pszObjId: super::super::Foundation::PSTR,
    pub dwValueType: CERT_RDN_ATTR_VALUE_TYPE,
    pub Value: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_RDN_ATTR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_RDN_ATTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_RDN_ATTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_RDN_ATTR").field("pszObjId", &self.pszObjId).field("dwValueType", &self.dwValueType).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_RDN_ATTR {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.dwValueType == other.dwValueType && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_RDN_ATTR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_RDN_ATTR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_RDN_ATTR_VALUE_TYPE(pub u32);
pub const CERT_RDN_ANY_TYPE: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(0u32);
pub const CERT_RDN_NUMERIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(3u32);
pub const CERT_RDN_PRINTABLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(4u32);
pub const CERT_RDN_T61_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5u32);
pub const CERT_RDN_VIDEOTEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(6u32);
pub const CERT_RDN_IA5_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(7u32);
pub const CERT_RDN_GRAPHIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(8u32);
pub const CERT_RDN_ISO646_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9u32);
pub const CERT_RDN_GENERAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(10u32);
pub const CERT_RDN_INT4_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11u32);
pub const CERT_RDN_UNICODE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12u32);
pub const CERT_RDN_BMP_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12u32);
pub const CERT_RDN_ENCODED_BLOB: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(1u32);
pub const CERT_RDN_OCTET_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(2u32);
pub const CERT_RDN_TELETEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5u32);
pub const CERT_RDN_UNIVERSAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11u32);
pub const CERT_RDN_UTF8_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(13u32);
pub const CERT_RDN_VISIBLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9u32);
impl ::std::convert::From<u32> for CERT_RDN_ATTR_VALUE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_RDN_ATTR_VALUE_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_RDN_ATTR_VALUE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_RDN_ATTR_VALUE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_RDN_ATTR_VALUE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_RDN_ATTR_VALUE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_RDN_ATTR_VALUE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_DISABLE_CHECK_TYPE_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_ENABLE_T61_UNICODE_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_ENABLE_UTF8_UNICODE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_FLAGS_MASK: u32 = 4278190080u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RDN_TYPE_MASK: u32 = 255u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_CLIENT_GPT_FLAG: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_System_Registry`*"]
pub struct CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    pub hKeyBase: super::super::System::Registry::HKEY,
    pub pwszRegPath: super::super::Foundation::PWSTR,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl CERT_REGISTRY_STORE_CLIENT_GPT_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::fmt::Debug for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REGISTRY_STORE_CLIENT_GPT_PARA").field("hKeyBase", &self.hKeyBase).field("pwszRegPath", &self.pwszRegPath).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hKeyBase == other.hKeyBase && self.pwszRegPath == other.pwszRegPath
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_EXTERNAL_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_LM_GPT_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_MY_IE_DIRTY_FLAG: u32 = 524288u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_REMOTE_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_ROAMING_FLAG: u32 = 262144u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_System_Registry`*"]
pub struct CERT_REGISTRY_STORE_ROAMING_PARA {
    pub hKey: super::super::System::Registry::HKEY,
    pub pwszStoreDirectory: super::super::Foundation::PWSTR,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl CERT_REGISTRY_STORE_ROAMING_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::fmt::Debug for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REGISTRY_STORE_ROAMING_PARA").field("hKey", &self.hKey).field("pwszStoreDirectory", &self.pwszStoreDirectory).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hKey == other.hKey && self.pwszStoreDirectory == other.pwszStoreDirectory
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for CERT_REGISTRY_STORE_ROAMING_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for CERT_REGISTRY_STORE_ROAMING_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REGISTRY_STORE_SERIALIZED_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_RENEWAL_PROP_ID: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REQUEST_INFO {
    pub dwVersion: u32,
    pub Subject: CRYPTOAPI_BLOB,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REQUEST_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REQUEST_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REQUEST_INFO").field("dwVersion", &self.dwVersion).field("Subject", &self.Subject).field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Subject == other.Subject && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REQUEST_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REQUEST_ORIGINATOR_PROP_ID: u32 = 71u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_REQUEST_V1: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REVOCATION_CHAIN_PARA {
    pub cbSize: u32,
    pub hChainEngine: HCERTCHAINENGINE,
    pub hAdditionalStore: *mut ::std::ffi::c_void,
    pub dwChainFlags: u32,
    pub dwUrlRetrievalTimeout: u32,
    pub pftCurrentTime: *mut super::super::Foundation::FILETIME,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub cbMaxUrlRetrievalByteCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REVOCATION_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REVOCATION_CHAIN_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REVOCATION_CHAIN_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REVOCATION_CHAIN_PARA")
            .field("cbSize", &self.cbSize)
            .field("hChainEngine", &self.hChainEngine)
            .field("hAdditionalStore", &self.hAdditionalStore)
            .field("dwChainFlags", &self.dwChainFlags)
            .field("dwUrlRetrievalTimeout", &self.dwUrlRetrievalTimeout)
            .field("pftCurrentTime", &self.pftCurrentTime)
            .field("pftCacheResync", &self.pftCacheResync)
            .field("cbMaxUrlRetrievalByteCount", &self.cbMaxUrlRetrievalByteCount)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REVOCATION_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hChainEngine == other.hChainEngine && self.hAdditionalStore == other.hAdditionalStore && self.dwChainFlags == other.dwChainFlags && self.dwUrlRetrievalTimeout == other.dwUrlRetrievalTimeout && self.pftCurrentTime == other.pftCurrentTime && self.pftCacheResync == other.pftCacheResync && self.cbMaxUrlRetrievalByteCount == other.cbMaxUrlRetrievalByteCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REVOCATION_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_CHAIN_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REVOCATION_CRL_INFO {
    pub cbSize: u32,
    pub pBaseCrlContext: *mut CRL_CONTEXT,
    pub pDeltaCrlContext: *mut CRL_CONTEXT,
    pub pCrlEntry: *mut CRL_ENTRY,
    pub fDeltaCrlEntry: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REVOCATION_CRL_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REVOCATION_CRL_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REVOCATION_CRL_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REVOCATION_CRL_INFO").field("cbSize", &self.cbSize).field("pBaseCrlContext", &self.pBaseCrlContext).field("pDeltaCrlContext", &self.pDeltaCrlContext).field("pCrlEntry", &self.pCrlEntry).field("fDeltaCrlEntry", &self.fDeltaCrlEntry).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REVOCATION_CRL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pBaseCrlContext == other.pBaseCrlContext && self.pDeltaCrlContext == other.pDeltaCrlContext && self.pCrlEntry == other.pCrlEntry && self.fDeltaCrlEntry == other.fDeltaCrlEntry
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REVOCATION_CRL_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_CRL_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REVOCATION_INFO {
    pub cbSize: u32,
    pub dwRevocationResult: u32,
    pub pszRevocationOid: super::super::Foundation::PSTR,
    pub pvOidSpecificInfo: *mut ::std::ffi::c_void,
    pub fHasFreshnessTime: super::super::Foundation::BOOL,
    pub dwFreshnessTime: u32,
    pub pCrlInfo: *mut CERT_REVOCATION_CRL_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REVOCATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REVOCATION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REVOCATION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REVOCATION_INFO")
            .field("cbSize", &self.cbSize)
            .field("dwRevocationResult", &self.dwRevocationResult)
            .field("pszRevocationOid", &self.pszRevocationOid)
            .field("pvOidSpecificInfo", &self.pvOidSpecificInfo)
            .field("fHasFreshnessTime", &self.fHasFreshnessTime)
            .field("dwFreshnessTime", &self.dwFreshnessTime)
            .field("pCrlInfo", &self.pCrlInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REVOCATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRevocationResult == other.dwRevocationResult && self.pszRevocationOid == other.pszRevocationOid && self.pvOidSpecificInfo == other.pvOidSpecificInfo && self.fHasFreshnessTime == other.fHasFreshnessTime && self.dwFreshnessTime == other.dwFreshnessTime && self.pCrlInfo == other.pCrlInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REVOCATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REVOCATION_PARA {
    pub cbSize: u32,
    pub pIssuerCert: *mut CERT_CONTEXT,
    pub cCertStore: u32,
    pub rgCertStore: *mut *mut ::std::ffi::c_void,
    pub hCrlStore: *mut ::std::ffi::c_void,
    pub pftTimeToUse: *mut super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REVOCATION_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REVOCATION_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REVOCATION_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REVOCATION_PARA").field("cbSize", &self.cbSize).field("pIssuerCert", &self.pIssuerCert).field("cCertStore", &self.cCertStore).field("rgCertStore", &self.rgCertStore).field("hCrlStore", &self.hCrlStore).field("pftTimeToUse", &self.pftTimeToUse).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REVOCATION_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pIssuerCert == other.pIssuerCert && self.cCertStore == other.cCertStore && self.rgCertStore == other.rgCertStore && self.hCrlStore == other.hCrlStore && self.pftTimeToUse == other.pftTimeToUse
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REVOCATION_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_REVOCATION_STATUS {
    pub cbSize: u32,
    pub dwIndex: u32,
    pub dwError: u32,
    pub dwReason: CERT_REVOCATION_STATUS_REASON,
    pub fHasFreshnessTime: super::super::Foundation::BOOL,
    pub dwFreshnessTime: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_REVOCATION_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_REVOCATION_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_REVOCATION_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_REVOCATION_STATUS").field("cbSize", &self.cbSize).field("dwIndex", &self.dwIndex).field("dwError", &self.dwError).field("dwReason", &self.dwReason).field("fHasFreshnessTime", &self.fHasFreshnessTime).field("dwFreshnessTime", &self.dwFreshnessTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_REVOCATION_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwIndex == other.dwIndex && self.dwError == other.dwError && self.dwReason == other.dwReason && self.fHasFreshnessTime == other.fHasFreshnessTime && self.dwFreshnessTime == other.dwFreshnessTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_REVOCATION_STATUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_STATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_REVOCATION_STATUS_REASON(pub u32);
pub const CRL_REASON_UNSPECIFIED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(0u32);
pub const CRL_REASON_KEY_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(1u32);
pub const CRL_REASON_CA_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(2u32);
pub const CRL_REASON_AFFILIATION_CHANGED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(3u32);
pub const CRL_REASON_SUPERSEDED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(4u32);
pub const CRL_REASON_CESSATION_OF_OPERATION: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(5u32);
pub const CRL_REASON_CERTIFICATE_HOLD: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(6u32);
pub const CRL_REASON_REMOVE_FROM_CRL: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(8u32);
impl ::std::convert::From<u32> for CERT_REVOCATION_STATUS_REASON {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_REVOCATION_STATUS_REASON {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_REVOCATION_STATUS_REASON {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_REVOCATION_STATUS_REASON {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_REVOCATION_STATUS_REASON {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_REVOCATION_STATUS_REASON {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_REVOCATION_STATUS_REASON {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID: u32 = 83u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ROOT_PROGRAM_CHAIN_POLICIES_PROP_ID: u32 = 105u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_ROOT_PROGRAM_FLAGS(pub u32);
pub const CERT_ROOT_PROGRAM_FLAG_LSC: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(64u32);
pub const CERT_ROOT_PROGRAM_FLAG_ORG: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(128u32);
pub const CERT_ROOT_PROGRAM_FLAG_SUBJECT_LOGO: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(32u32);
impl ::std::convert::From<u32> for CERT_ROOT_PROGRAM_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_ROOT_PROGRAM_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ROOT_PROGRAM_FLAG_ADDRESS: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ROOT_PROGRAM_FLAG_OU: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID: u32 = 84u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCARD_PIN_ID_PROP_ID: u32 = 90u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCARD_PIN_INFO_PROP_ID: u32 = 91u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_CA_CERT_PROP_ID: u32 = 111u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_ENCRYPT_HASH_CNG_ALG_PROP_ID: u32 = 114u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_FLAGS_PROP_ID: u32 = 115u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_GUID_PROP_ID: u32 = 116u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_NONCE_PROP_ID: u32 = 113u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_RA_ENCRYPTION_CERT_PROP_ID: u32 = 110u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_RA_SIGNATURE_CERT_PROP_ID: u32 = 109u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_SERVER_CERTS_PROP_ID: u32 = 108u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SCEP_SIGNER_CERT_PROP_ID: u32 = 112u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SELECTUI_INPUT {
    pub hStore: *mut ::std::ffi::c_void,
    pub prgpChain: *mut *mut CERT_CHAIN_CONTEXT,
    pub cChain: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SELECTUI_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SELECTUI_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SELECTUI_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SELECTUI_INPUT").field("hStore", &self.hStore).field("prgpChain", &self.prgpChain).field("cChain", &self.cChain).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SELECTUI_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.hStore == other.hStore && self.prgpChain == other.prgpChain && self.cChain == other.cChain
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SELECTUI_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SELECTUI_INPUT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_ALLOW_DUPLICATES: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_ALLOW_EXPIRED: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_BY_FRIENDLYNAME: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_BY_ISSUER_DISPLAYNAME: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_BY_THUMBPRINT: u32 = 14u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SELECT_CHAIN_PARA {
    pub hChainEngine: HCERTCHAINENGINE,
    pub pTime: *mut super::super::Foundation::FILETIME,
    pub hAdditionalStore: *mut ::std::ffi::c_void,
    pub pChainPara: *mut CERT_CHAIN_PARA,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SELECT_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SELECT_CHAIN_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SELECT_CHAIN_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SELECT_CHAIN_PARA").field("hChainEngine", &self.hChainEngine).field("pTime", &self.pTime).field("hAdditionalStore", &self.hAdditionalStore).field("pChainPara", &self.pChainPara).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SELECT_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hChainEngine == other.hChainEngine && self.pTime == other.pTime && self.hAdditionalStore == other.hAdditionalStore && self.pChainPara == other.pChainPara && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SELECT_CHAIN_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SELECT_CHAIN_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_SELECT_CRITERIA {
    pub dwType: CERT_SELECT_CRITERIA_TYPE,
    pub cPara: u32,
    pub ppPara: *mut *mut ::std::ffi::c_void,
}
impl CERT_SELECT_CRITERIA {}
impl ::std::default::Default for CERT_SELECT_CRITERIA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_SELECT_CRITERIA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SELECT_CRITERIA").field("dwType", &self.dwType).field("cPara", &self.cPara).field("ppPara", &self.ppPara).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_SELECT_CRITERIA {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.cPara == other.cPara && self.ppPara == other.ppPara
    }
}
impl ::std::cmp::Eq for CERT_SELECT_CRITERIA {}
unsafe impl ::windows::runtime::Abi for CERT_SELECT_CRITERIA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_SELECT_CRITERIA_TYPE(pub u32);
pub const CERT_SELECT_BY_ENHKEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(1u32);
pub const CERT_SELECT_BY_KEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(2u32);
pub const CERT_SELECT_BY_POLICY_OID: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(3u32);
pub const CERT_SELECT_BY_PROV_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(4u32);
pub const CERT_SELECT_BY_EXTENSION: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(5u32);
pub const CERT_SELECT_BY_SUBJECT_HOST_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(6u32);
pub const CERT_SELECT_BY_ISSUER_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(7u32);
pub const CERT_SELECT_BY_SUBJECT_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(8u32);
pub const CERT_SELECT_BY_ISSUER_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(9u32);
pub const CERT_SELECT_BY_PUBLIC_KEY: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(10u32);
pub const CERT_SELECT_BY_TLS_SIGNATURES: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(11u32);
impl ::std::convert::From<u32> for CERT_SELECT_CRITERIA_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_SELECT_CRITERIA_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_SELECT_CRITERIA_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_SELECT_CRITERIA_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_SELECT_CRITERIA_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_SELECT_CRITERIA_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_SELECT_CRITERIA_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_DISALLOW_SELFSIGNED: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_HARDWARE_ONLY: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_HAS_KEY_FOR_KEY_EXCHANGE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_HAS_KEY_FOR_SIGNATURE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_HAS_PRIVATE_KEY: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_IGNORE_AUTOSELECT: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_MAX_PARA: u32 = 500u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SELECT_STRUCT_A {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub hInstance: super::super::Foundation::HINSTANCE,
    pub pTemplateName: super::super::Foundation::PSTR,
    pub dwFlags: CERT_SELECT_STRUCT_FLAGS,
    pub szTitle: super::super::Foundation::PSTR,
    pub cCertStore: u32,
    pub arrayCertStore: *mut *mut ::std::ffi::c_void,
    pub szPurposeOid: super::super::Foundation::PSTR,
    pub cCertContext: u32,
    pub arrayCertContext: *mut *mut CERT_CONTEXT,
    pub lCustData: super::super::Foundation::LPARAM,
    pub pfnHook: ::std::option::Option<PFNCMHOOKPROC>,
    pub pfnFilter: ::std::option::Option<PFNCMFILTERPROC>,
    pub szHelpFileName: super::super::Foundation::PSTR,
    pub dwHelpId: u32,
    pub hprov: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SELECT_STRUCT_A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SELECT_STRUCT_A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SELECT_STRUCT_A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SELECT_STRUCT_A")
            .field("dwSize", &self.dwSize)
            .field("hwndParent", &self.hwndParent)
            .field("hInstance", &self.hInstance)
            .field("pTemplateName", &self.pTemplateName)
            .field("dwFlags", &self.dwFlags)
            .field("szTitle", &self.szTitle)
            .field("cCertStore", &self.cCertStore)
            .field("arrayCertStore", &self.arrayCertStore)
            .field("szPurposeOid", &self.szPurposeOid)
            .field("cCertContext", &self.cCertContext)
            .field("arrayCertContext", &self.arrayCertContext)
            .field("lCustData", &self.lCustData)
            .field("szHelpFileName", &self.szHelpFileName)
            .field("dwHelpId", &self.dwHelpId)
            .field("hprov", &self.hprov)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SELECT_STRUCT_A {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.hwndParent == other.hwndParent
            && self.hInstance == other.hInstance
            && self.pTemplateName == other.pTemplateName
            && self.dwFlags == other.dwFlags
            && self.szTitle == other.szTitle
            && self.cCertStore == other.cCertStore
            && self.arrayCertStore == other.arrayCertStore
            && self.szPurposeOid == other.szPurposeOid
            && self.cCertContext == other.cCertContext
            && self.arrayCertContext == other.arrayCertContext
            && self.lCustData == other.lCustData
            && self.pfnHook.map(|f| f as usize) == other.pfnHook.map(|f| f as usize)
            && self.pfnFilter.map(|f| f as usize) == other.pfnFilter.map(|f| f as usize)
            && self.szHelpFileName == other.szHelpFileName
            && self.dwHelpId == other.dwHelpId
            && self.hprov == other.hprov
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SELECT_STRUCT_A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SELECT_STRUCT_A {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_SELECT_STRUCT_FLAGS(pub u32);
pub const CSS_HIDE_PROPERTIES: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(1u32);
pub const CSS_ENABLEHOOK: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(2u32);
pub const CSS_ALLOWMULTISELECT: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(4u32);
pub const CSS_SHOW_HELP: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(16u32);
pub const CSS_ENABLETEMPLATE: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(32u32);
pub const CSS_ENABLETEMPLATEHANDLE: CERT_SELECT_STRUCT_FLAGS = CERT_SELECT_STRUCT_FLAGS(64u32);
impl ::std::convert::From<u32> for CERT_SELECT_STRUCT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_SELECT_STRUCT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_SELECT_STRUCT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_SELECT_STRUCT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_SELECT_STRUCT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_SELECT_STRUCT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_SELECT_STRUCT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SELECT_STRUCT_W {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub hInstance: super::super::Foundation::HINSTANCE,
    pub pTemplateName: super::super::Foundation::PWSTR,
    pub dwFlags: CERT_SELECT_STRUCT_FLAGS,
    pub szTitle: super::super::Foundation::PWSTR,
    pub cCertStore: u32,
    pub arrayCertStore: *mut *mut ::std::ffi::c_void,
    pub szPurposeOid: super::super::Foundation::PSTR,
    pub cCertContext: u32,
    pub arrayCertContext: *mut *mut CERT_CONTEXT,
    pub lCustData: super::super::Foundation::LPARAM,
    pub pfnHook: ::std::option::Option<PFNCMHOOKPROC>,
    pub pfnFilter: ::std::option::Option<PFNCMFILTERPROC>,
    pub szHelpFileName: super::super::Foundation::PWSTR,
    pub dwHelpId: u32,
    pub hprov: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SELECT_STRUCT_W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SELECT_STRUCT_W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SELECT_STRUCT_W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SELECT_STRUCT_W")
            .field("dwSize", &self.dwSize)
            .field("hwndParent", &self.hwndParent)
            .field("hInstance", &self.hInstance)
            .field("pTemplateName", &self.pTemplateName)
            .field("dwFlags", &self.dwFlags)
            .field("szTitle", &self.szTitle)
            .field("cCertStore", &self.cCertStore)
            .field("arrayCertStore", &self.arrayCertStore)
            .field("szPurposeOid", &self.szPurposeOid)
            .field("cCertContext", &self.cCertContext)
            .field("arrayCertContext", &self.arrayCertContext)
            .field("lCustData", &self.lCustData)
            .field("szHelpFileName", &self.szHelpFileName)
            .field("dwHelpId", &self.dwHelpId)
            .field("hprov", &self.hprov)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SELECT_STRUCT_W {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.hwndParent == other.hwndParent
            && self.hInstance == other.hInstance
            && self.pTemplateName == other.pTemplateName
            && self.dwFlags == other.dwFlags
            && self.szTitle == other.szTitle
            && self.cCertStore == other.cCertStore
            && self.arrayCertStore == other.arrayCertStore
            && self.szPurposeOid == other.szPurposeOid
            && self.cCertContext == other.cCertContext
            && self.arrayCertContext == other.arrayCertContext
            && self.lCustData == other.lCustData
            && self.pfnHook.map(|f| f as usize) == other.pfnHook.map(|f| f as usize)
            && self.pfnFilter.map(|f| f as usize) == other.pfnFilter.map(|f| f as usize)
            && self.szHelpFileName == other.szHelpFileName
            && self.dwHelpId == other.dwHelpId
            && self.hprov == other.hprov
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SELECT_STRUCT_W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SELECT_STRUCT_W {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SELECT_TRUSTED_ROOT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SEND_AS_TRUSTED_ISSUER_PROP_ID: u32 = 102u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SERIALIZABLE_KEY_CONTEXT_PROP_ID: u32 = 117u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SERIAL_CHAIN_PROP_ID: u32 = 119u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SERVER_OCSP_RESPONSE_ASYNC_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    pub cbSize: u32,
    pub pbEncodedOcspResponse: *mut u8,
    pub cbEncodedOcspResponse: u32,
}
impl CERT_SERVER_OCSP_RESPONSE_CONTEXT {}
impl ::std::default::Default for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SERVER_OCSP_RESPONSE_CONTEXT").field("cbSize", &self.cbSize).field("pbEncodedOcspResponse", &self.pbEncodedOcspResponse).field("cbEncodedOcspResponse", &self.cbEncodedOcspResponse).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pbEncodedOcspResponse == other.pbEncodedOcspResponse && self.cbEncodedOcspResponse == other.cbEncodedOcspResponse
    }
}
impl ::std::cmp::Eq for CERT_SERVER_OCSP_RESPONSE_CONTEXT {}
unsafe impl ::windows::runtime::Abi for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    pub cbSize: u32,
    pub dwFlags: u32,
    pub pcbUsedSize: *mut u32,
    pub pwszOcspDirectory: super::super::Foundation::PWSTR,
    pub pfnUpdateCallback: ::std::option::Option<PFN_CERT_SERVER_OCSP_RESPONSE_UPDATE_CALLBACK>,
    pub pvUpdateCallbackArg: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SERVER_OCSP_RESPONSE_OPEN_PARA").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).field("pcbUsedSize", &self.pcbUsedSize).field("pwszOcspDirectory", &self.pwszOcspDirectory).field("pvUpdateCallbackArg", &self.pvUpdateCallbackArg).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwFlags == other.dwFlags && self.pcbUsedSize == other.pcbUsedSize && self.pwszOcspDirectory == other.pwszOcspDirectory && self.pfnUpdateCallback.map(|f| f as usize) == other.pfnUpdateCallback.map(|f| f as usize) && self.pvUpdateCallbackArg == other.pvUpdateCallbackArg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_READ_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_WRITE_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SET_PROPERTY_IGNORE_PERSIST_ERROR_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SET_PROPERTY_INHIBIT_PERSIST_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SHA1_HASH_PROP_ID: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SHA256_HASH_PROP_ID: u32 = 107u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SIGNATURE_HASH_PROP_ID: u32 = 15u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SIGNED_CONTENT_INFO {
    pub ToBeSigned: CRYPTOAPI_BLOB,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Signature: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SIGNED_CONTENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SIGNED_CONTENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SIGNED_CONTENT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SIGNED_CONTENT_INFO").field("ToBeSigned", &self.ToBeSigned).field("SignatureAlgorithm", &self.SignatureAlgorithm).field("Signature", &self.Signature).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SIGNED_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ToBeSigned == other.ToBeSigned && self.SignatureAlgorithm == other.SignatureAlgorithm && self.Signature == other.Signature
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SIGNED_CONTENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SIGNED_CONTENT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 89u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SIMPLE_CHAIN {
    pub cbSize: u32,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub cElement: u32,
    pub rgpElement: *mut *mut CERT_CHAIN_ELEMENT,
    pub pTrustListInfo: *mut CERT_TRUST_LIST_INFO,
    pub fHasRevocationFreshnessTime: super::super::Foundation::BOOL,
    pub dwRevocationFreshnessTime: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SIMPLE_CHAIN {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SIMPLE_CHAIN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SIMPLE_CHAIN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SIMPLE_CHAIN")
            .field("cbSize", &self.cbSize)
            .field("TrustStatus", &self.TrustStatus)
            .field("cElement", &self.cElement)
            .field("rgpElement", &self.rgpElement)
            .field("pTrustListInfo", &self.pTrustListInfo)
            .field("fHasRevocationFreshnessTime", &self.fHasRevocationFreshnessTime)
            .field("dwRevocationFreshnessTime", &self.dwRevocationFreshnessTime)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SIMPLE_CHAIN {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.TrustStatus == other.TrustStatus && self.cElement == other.cElement && self.rgpElement == other.rgpElement && self.pTrustListInfo == other.pTrustListInfo && self.fHasRevocationFreshnessTime == other.fHasRevocationFreshnessTime && self.dwRevocationFreshnessTime == other.dwRevocationFreshnessTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SIMPLE_CHAIN {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SIMPLE_CHAIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SMART_CARD_DATA_PROP_ID: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SMART_CARD_READER_NON_REMOVABLE_PROP_ID: u32 = 106u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SMART_CARD_READER_PROP_ID: u32 = 101u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SMART_CARD_ROOT_INFO_PROP_ID: u32 = 76u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SOURCE_LOCATION_PROP_ID: u32 = 72u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SOURCE_URL_PROP_ID: u32 = 73u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SRV_OCSP_RESP_MIN_SYNC_CERT_FILE_SECONDS_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_ALWAYS: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_NEW: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_NEWER: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_REPLACE_EXISTING: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_ADD_USE_EXISTING: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_BASE_CRL_FLAG: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CERTIFICATE_CONTEXT: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CRL_CONTEXT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTL_CONTEXT: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTRL_AUTO_RESYNC: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTRL_CANCEL_NOTIFY: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTRL_COMMIT: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTRL_NOTIFY_CHANGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_CTRL_RESYNC: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_DELTA_CRL_FLAG: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_LOCALIZED_NAME_PROP_ID: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_MANIFOLD_FLAG: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_NO_CRL_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_NO_ISSUER_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_CLOSE_FUNC: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_CONTROL_FUNC: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_DELETE_CERT_FUNC: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_DELETE_CRL_FUNC: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_DELETE_CTL_FUNC: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FIND_CERT_FUNC: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FIND_CRL_FUNC: u32 = 17u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FIND_CTL_FUNC: u32 = 20u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_STORE_PROV_FIND_INFO {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub dwFindFlags: u32,
    pub dwFindType: u32,
    pub pvFindPara: *mut ::std::ffi::c_void,
}
impl CERT_STORE_PROV_FIND_INFO {}
impl ::std::default::Default for CERT_STORE_PROV_FIND_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_STORE_PROV_FIND_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_STORE_PROV_FIND_INFO").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("dwFindFlags", &self.dwFindFlags).field("dwFindType", &self.dwFindType).field("pvFindPara", &self.pvFindPara).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_STORE_PROV_FIND_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.dwFindFlags == other.dwFindFlags && self.dwFindType == other.dwFindType && self.pvFindPara == other.pvFindPara
    }
}
impl ::std::cmp::Eq for CERT_STORE_PROV_FIND_INFO {}
unsafe impl ::windows::runtime::Abi for CERT_STORE_PROV_FIND_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_STORE_PROV_FLAGS(pub u32);
pub const CERT_STORE_PROV_EXTERNAL_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(1u32);
pub const CERT_STORE_PROV_DELETED_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(2u32);
pub const CERT_STORE_PROV_NO_PERSIST_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(4u32);
pub const CERT_STORE_PROV_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(8u32);
pub const CERT_STORE_PROV_LM_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(16u32);
impl ::std::convert::From<u32> for CERT_STORE_PROV_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_STORE_PROV_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_STORE_PROV_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_STORE_PROV_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FREE_FIND_CERT_FUNC: u32 = 15u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FREE_FIND_CRL_FUNC: u32 = 18u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_FREE_FIND_CTL_FUNC: u32 = 21u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_GET_CERT_PROPERTY_FUNC: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_GET_CRL_PROPERTY_FUNC: u32 = 19u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_GET_CTL_PROPERTY_FUNC: u32 = 22u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_GP_SYSTEM_STORE_FLAG: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_STORE_PROV_INFO {
    pub cbSize: u32,
    pub cStoreProvFunc: u32,
    pub rgpvStoreProvFunc: *mut *mut ::std::ffi::c_void,
    pub hStoreProv: *mut ::std::ffi::c_void,
    pub dwStoreProvFlags: CERT_STORE_PROV_FLAGS,
    pub hStoreProvFuncAddr2: *mut ::std::ffi::c_void,
}
impl CERT_STORE_PROV_INFO {}
impl ::std::default::Default for CERT_STORE_PROV_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_STORE_PROV_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_STORE_PROV_INFO")
            .field("cbSize", &self.cbSize)
            .field("cStoreProvFunc", &self.cStoreProvFunc)
            .field("rgpvStoreProvFunc", &self.rgpvStoreProvFunc)
            .field("hStoreProv", &self.hStoreProv)
            .field("dwStoreProvFlags", &self.dwStoreProvFlags)
            .field("hStoreProvFuncAddr2", &self.hStoreProvFuncAddr2)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CERT_STORE_PROV_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cStoreProvFunc == other.cStoreProvFunc && self.rgpvStoreProvFunc == other.rgpvStoreProvFunc && self.hStoreProv == other.hStoreProv && self.dwStoreProvFlags == other.dwStoreProvFlags && self.hStoreProvFuncAddr2 == other.hStoreProvFuncAddr2
    }
}
impl ::std::cmp::Eq for CERT_STORE_PROV_INFO {}
unsafe impl ::windows::runtime::Abi for CERT_STORE_PROV_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_READ_CERT_FUNC: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_READ_CRL_FUNC: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_READ_CTL_FUNC: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_SET_CERT_PROPERTY_FUNC: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_SET_CRL_PROPERTY_FUNC: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_SET_CTL_PROPERTY_FUNC: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_SHARED_USER_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_WRITE_ADD_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_WRITE_CERT_FUNC: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_WRITE_CRL_FUNC: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_PROV_WRITE_CTL_FUNC: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_REVOCATION_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_STORE_SAVE_AS(pub u32);
pub const CERT_STORE_SAVE_AS_PKCS7: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(2u32);
pub const CERT_STORE_SAVE_AS_STORE: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(1u32);
impl ::std::convert::From<u32> for CERT_STORE_SAVE_AS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_STORE_SAVE_AS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_STORE_SAVE_AS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_STORE_SAVE_AS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_STORE_SAVE_AS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_STORE_SAVE_AS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_STORE_SAVE_AS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_SAVE_AS_PKCS12: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_STORE_SAVE_TO(pub u32);
pub const CERT_STORE_SAVE_TO_FILE: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(1u32);
pub const CERT_STORE_SAVE_TO_FILENAME: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
pub const CERT_STORE_SAVE_TO_FILENAME_A: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(3u32);
pub const CERT_STORE_SAVE_TO_FILENAME_W: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
pub const CERT_STORE_SAVE_TO_MEMORY: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(2u32);
impl ::std::convert::From<u32> for CERT_STORE_SAVE_TO {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_STORE_SAVE_TO {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_STORE_SAVE_TO {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_STORE_SAVE_TO {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_STORE_SAVE_TO {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_STORE_SAVE_TO {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_STORE_SAVE_TO {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_SHARE_STORE_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_SIGNATURE_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_TIME_VALIDITY_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STORE_UNSAFE_PHYSICAL_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_STRING_TYPE(pub u32);
pub const CERT_SIMPLE_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(1u32);
pub const CERT_OID_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(2u32);
pub const CERT_X500_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(3u32);
impl ::std::convert::From<u32> for CERT_STRING_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_STRING_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_STRING_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_STRING_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_STRING_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_STRING_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_STRING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_STRONG_SIGN_FLAGS(pub u32);
pub const CERT_STRONG_SIGN_ENABLE_CRL_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(1u32);
pub const CERT_STRONG_SIGN_ENABLE_OCSP_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(2u32);
impl ::std::convert::From<u32> for CERT_STRONG_SIGN_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_STRONG_SIGN_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STRONG_SIGN_OID_INFO_CHOICE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_STRONG_SIGN_PARA {
    pub cbSize: u32,
    pub dwInfoChoice: u32,
    pub Anonymous: CERT_STRONG_SIGN_PARA_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_STRONG_SIGN_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_STRONG_SIGN_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_STRONG_SIGN_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_STRONG_SIGN_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_STRONG_SIGN_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CERT_STRONG_SIGN_PARA_0 {
    pub pvInfo: *mut ::std::ffi::c_void,
    pub pSerializedInfo: *mut CERT_STRONG_SIGN_SERIALIZED_INFO,
    pub pszOID: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_STRONG_SIGN_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_STRONG_SIGN_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_STRONG_SIGN_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_STRONG_SIGN_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_STRONG_SIGN_PARA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_STRONG_SIGN_SERIALIZED_INFO {
    pub dwFlags: CERT_STRONG_SIGN_FLAGS,
    pub pwszCNGSignHashAlgids: super::super::Foundation::PWSTR,
    pub pwszCNGPubKeyMinBitLengths: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_STRONG_SIGN_SERIALIZED_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_STRONG_SIGN_SERIALIZED_INFO").field("dwFlags", &self.dwFlags).field("pwszCNGSignHashAlgids", &self.pwszCNGSignHashAlgids).field("pwszCNGPubKeyMinBitLengths", &self.pwszCNGPubKeyMinBitLengths).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.pwszCNGSignHashAlgids == other.pwszCNGSignHashAlgids && self.pwszCNGPubKeyMinBitLengths == other.pwszCNGPubKeyMinBitLengths
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_STRONG_SIGN_SERIALIZED_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_STRONG_SIGN_SERIALIZED_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_STRONG_SIGN_SERIALIZED_INFO_CHOICE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_DISABLE_CRL_PROP_ID: u32 = 86u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_INFO_ACCESS_PROP_ID: u32 = 80u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: u32 = 29u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 85u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 25u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SUBJECT_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 92u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_SUPPORTED_ALGORITHM_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub IntendedKeyUsage: CRYPT_BIT_BLOB,
    pub IntendedCertPolicies: CERT_POLICIES_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_SUPPORTED_ALGORITHM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_SUPPORTED_ALGORITHM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_SUPPORTED_ALGORITHM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SUPPORTED_ALGORITHM_INFO").field("Algorithm", &self.Algorithm).field("IntendedKeyUsage", &self.IntendedKeyUsage).field("IntendedCertPolicies", &self.IntendedCertPolicies).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_SUPPORTED_ALGORITHM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.IntendedKeyUsage == other.IntendedKeyUsage && self.IntendedCertPolicies == other.IntendedCertPolicies
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_SUPPORTED_ALGORITHM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_SUPPORTED_ALGORITHM_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_CURRENT_SERVICE_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_CURRENT_USER_ID: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_DEFER_READ_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CERT_SYSTEM_STORE_FLAGS(pub u32);
pub const CERT_SYSTEM_STORE_LOCATION_MASK: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(16711680u32);
pub const CERT_SYSTEM_STORE_RELOCATE_FLAG: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(2147483648u32);
impl ::std::convert::From<u32> for CERT_SYSTEM_STORE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CERT_SYSTEM_STORE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CERT_SYSTEM_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CERT_SYSTEM_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CERT_SYSTEM_STORE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CERT_SYSTEM_STORE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CERT_SYSTEM_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_SYSTEM_STORE_INFO {
    pub cbSize: u32,
}
impl CERT_SYSTEM_STORE_INFO {}
impl ::std::default::Default for CERT_SYSTEM_STORE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_SYSTEM_STORE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_SYSTEM_STORE_INFO").field("cbSize", &self.cbSize).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_SYSTEM_STORE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
    }
}
impl ::std::cmp::Eq for CERT_SYSTEM_STORE_INFO {}
unsafe impl ::windows::runtime::Abi for CERT_SYSTEM_STORE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ID: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_WCOS_ID: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_LOCATION_SHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_MASK: u32 = 4294901760u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_System_Registry`*"]
pub struct CERT_SYSTEM_STORE_RELOCATE_PARA {
    pub Anonymous1: CERT_SYSTEM_STORE_RELOCATE_PARA_0,
    pub Anonymous2: CERT_SYSTEM_STORE_RELOCATE_PARA_1,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl CERT_SYSTEM_STORE_RELOCATE_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for CERT_SYSTEM_STORE_RELOCATE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for CERT_SYSTEM_STORE_RELOCATE_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for CERT_SYSTEM_STORE_RELOCATE_PARA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for CERT_SYSTEM_STORE_RELOCATE_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub union CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    pub hKeyBase: super::super::System::Registry::HKEY,
    pub pvBase: *mut ::std::ffi::c_void,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl CERT_SYSTEM_STORE_RELOCATE_PARA_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub union CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    pub pvSystemStore: *mut ::std::ffi::c_void,
    pub pszSystemStore: super::super::Foundation::PSTR,
    pub pwszSystemStore: super::super::Foundation::PWSTR,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl CERT_SYSTEM_STORE_RELOCATE_PARA_1 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_SERVICES_ID: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_UNPROTECTED_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_SYSTEM_STORE_USERS_ID: u32 = 6u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_TEMPLATE_EXT {
    pub pszObjId: super::super::Foundation::PSTR,
    pub dwMajorVersion: u32,
    pub fMinorVersion: super::super::Foundation::BOOL,
    pub dwMinorVersion: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_TEMPLATE_EXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_TEMPLATE_EXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_TEMPLATE_EXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_TEMPLATE_EXT").field("pszObjId", &self.pszObjId).field("dwMajorVersion", &self.dwMajorVersion).field("fMinorVersion", &self.fMinorVersion).field("dwMinorVersion", &self.dwMinorVersion).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_TEMPLATE_EXT {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.dwMajorVersion == other.dwMajorVersion && self.fMinorVersion == other.fMinorVersion && self.dwMinorVersion == other.dwMinorVersion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_TEMPLATE_EXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_TEMPLATE_EXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TIMESTAMP_HASH_USE_TYPE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_TPM_SPECIFICATION_INFO {
    pub pwszFamily: super::super::Foundation::PWSTR,
    pub dwLevel: u32,
    pub dwRevision: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_TPM_SPECIFICATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_TPM_SPECIFICATION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_TPM_SPECIFICATION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_TPM_SPECIFICATION_INFO").field("pwszFamily", &self.pwszFamily).field("dwLevel", &self.dwLevel).field("dwRevision", &self.dwRevision).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_TPM_SPECIFICATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszFamily == other.pwszFamily && self.dwLevel == other.dwLevel && self.dwRevision == other.dwRevision
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_TPM_SPECIFICATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_TPM_SPECIFICATION_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_AUTO_UPDATE_CA_REVOCATION: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_AUTO_UPDATE_END_REVOCATION: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_CTL_IS_NOT_TIME_VALID: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE: u32 = 524288u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_DO_FULL_SEARCH: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_DO_FULL_TRUST: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_ALLOW_WEAK_SIGNATURE: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_AUTO_UPDATE_WEAK_SIGNATURE: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_EXACT_MATCH_ISSUER: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_KEY_MATCH_ISSUER: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_NAME_MATCH_ISSUER: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_PREFERRED_ISSUER: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_WEAK_HYGIENE: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_HAS_WEAK_SIGNATURE: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_INVALID_BASIC_CONSTRAINTS: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_INVALID_EXTENSION: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_INVALID_NAME_CONSTRAINTS: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_INVALID_POLICY_CONSTRAINTS: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_CA_TRUSTED: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_COMPLEX_CHAIN: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_CYCLIC: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_EXPLICIT_DISTRUST: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_KEY_ROLLOVER: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_NOT_SIGNATURE_VALID: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_NOT_TIME_NESTED: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_NOT_TIME_VALID: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_NOT_VALID_FOR_USAGE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_OFFLINE_REVOCATION: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_PARTIAL_CHAIN: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_PEER_TRUSTED: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_REVOKED: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_SELF_SIGNED: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_IS_UNTRUSTED_ROOT: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_TRUST_LIST_INFO {
    pub cbSize: u32,
    pub pCtlEntry: *mut CTL_ENTRY,
    pub pCtlContext: *mut CTL_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_TRUST_LIST_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_TRUST_LIST_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_TRUST_LIST_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_TRUST_LIST_INFO").field("cbSize", &self.cbSize).field("pCtlEntry", &self.pCtlEntry).field("pCtlContext", &self.pCtlContext).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_TRUST_LIST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pCtlEntry == other.pCtlEntry && self.pCtlContext == other.pCtlContext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_TRUST_LIST_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_TRUST_LIST_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_MASK: u32 = 16777215u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_NO_ERROR: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_NO_OCSP_FAILOVER_TO_CRL: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_NO_TIME_CHECK: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PERMIT_MISSING_CRLS: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_ALLOW_END_USER_TRUST: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_ALLOW_ENTERPRISE_ADMIN_TRUST: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_ALLOW_MACHINE_ADMIN_TRUST: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_ALLOW_TRUST_MASK: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_CHECK_PUBLISHER_REV_FLAG: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_PUB_CHECK_TIMESTAMP_REV_FLAG: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_REVOCATION_STATUS_UNKNOWN: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_SSL_HANDSHAKE_OCSP: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_SSL_RECONNECT_OCSP: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_SSL_TIME_VALID: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_TRUST_SSL_TIME_VALID_OCSP: u32 = 524288u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_TRUST_STATUS {
    pub dwErrorStatus: u32,
    pub dwInfoStatus: u32,
}
impl CERT_TRUST_STATUS {}
impl ::std::default::Default for CERT_TRUST_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_TRUST_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_TRUST_STATUS").field("dwErrorStatus", &self.dwErrorStatus).field("dwInfoStatus", &self.dwInfoStatus).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_TRUST_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.dwErrorStatus == other.dwErrorStatus && self.dwInfoStatus == other.dwInfoStatus
    }
}
impl ::std::cmp::Eq for CERT_TRUST_STATUS {}
unsafe impl ::windows::runtime::Abi for CERT_TRUST_STATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_ATTR_ERR_INDEX_MASK: u32 = 63u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_ATTR_ERR_INDEX_SHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_IS_RDN_ATTRS_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_RDN_ERR_INDEX_MASK: u32 = 1023u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_RDN_ERR_INDEX_SHIFT: u32 = 22u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_UNICODE_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_USAGE_MATCH {
    pub dwType: u32,
    pub Usage: CTL_USAGE,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_USAGE_MATCH {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_USAGE_MATCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_USAGE_MATCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_USAGE_MATCH").field("dwType", &self.dwType).field("Usage", &self.Usage).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_USAGE_MATCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.Usage == other.Usage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_USAGE_MATCH {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_USAGE_MATCH {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_V1: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_V2: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_V3: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_AFTER_END: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_BEFORE_START: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_CERTIFICATE_REVOKED: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_CRL_OUT_OF_DATE: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_EXPLICITLY_DISTRUSTED: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_EXTENDED_USAGE_FAILURE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_ISSUER_DISTRUST: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_ISSUER_INVALID: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_KEY_USAGE_EXT_FAILURE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_MASK_TRUST: u32 = 4294901760u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_MASK_VALIDITY: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_NAME_CONSTRAINTS_FAILURE: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_NO_CRL_FOUND: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_NO_ISSUER_CERT_FOUND: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_NO_TRUST_DATA: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_OTHER_ERROR: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_OTHER_EXTENSION_FAILURE: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_PERIOD_NESTING_FAILURE: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_SIGNATURE_FAILS: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VALIDITY_UNKNOWN_CRITICAL_EXTENSION: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_ALLOW_MORE_USAGE_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_CACHE_ONLY_BASED_REVOCATION: u32 = 2u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CERT_VERIFY_CERTIFICATE_TRUST {
    pub cbSize: u32,
    pub pccert: *mut CERT_CONTEXT,
    pub dwFlags: u32,
    pub dwIgnoreErr: u32,
    pub pdwErrors: *mut u32,
    pub pszUsageOid: super::super::Foundation::PSTR,
    pub hprov: usize,
    pub cRootStores: u32,
    pub rghstoreRoots: *mut *mut ::std::ffi::c_void,
    pub cStores: u32,
    pub rghstoreCAs: *mut *mut ::std::ffi::c_void,
    pub cTrustStores: u32,
    pub rghstoreTrust: *mut *mut ::std::ffi::c_void,
    pub lCustData: super::super::Foundation::LPARAM,
    pub pfnTrustHelper: ::std::option::Option<PFNTRUSTHELPER>,
    pub pcChain: *mut u32,
    pub prgChain: *mut *mut *mut CERT_CONTEXT,
    pub prgdwErrors: *mut *mut u32,
    pub prgpbTrustInfo: *mut *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CERT_VERIFY_CERTIFICATE_TRUST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CERT_VERIFY_CERTIFICATE_TRUST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CERT_VERIFY_CERTIFICATE_TRUST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_VERIFY_CERTIFICATE_TRUST")
            .field("cbSize", &self.cbSize)
            .field("pccert", &self.pccert)
            .field("dwFlags", &self.dwFlags)
            .field("dwIgnoreErr", &self.dwIgnoreErr)
            .field("pdwErrors", &self.pdwErrors)
            .field("pszUsageOid", &self.pszUsageOid)
            .field("hprov", &self.hprov)
            .field("cRootStores", &self.cRootStores)
            .field("rghstoreRoots", &self.rghstoreRoots)
            .field("cStores", &self.cStores)
            .field("rghstoreCAs", &self.rghstoreCAs)
            .field("cTrustStores", &self.cTrustStores)
            .field("rghstoreTrust", &self.rghstoreTrust)
            .field("lCustData", &self.lCustData)
            .field("pcChain", &self.pcChain)
            .field("prgChain", &self.prgChain)
            .field("prgdwErrors", &self.prgdwErrors)
            .field("prgpbTrustInfo", &self.prgpbTrustInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CERT_VERIFY_CERTIFICATE_TRUST {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.pccert == other.pccert
            && self.dwFlags == other.dwFlags
            && self.dwIgnoreErr == other.dwIgnoreErr
            && self.pdwErrors == other.pdwErrors
            && self.pszUsageOid == other.pszUsageOid
            && self.hprov == other.hprov
            && self.cRootStores == other.cRootStores
            && self.rghstoreRoots == other.rghstoreRoots
            && self.cStores == other.cStores
            && self.rghstoreCAs == other.rghstoreCAs
            && self.cTrustStores == other.cTrustStores
            && self.rghstoreTrust == other.rghstoreTrust
            && self.lCustData == other.lCustData
            && self.pfnTrustHelper.map(|f| f as usize) == other.pfnTrustHelper.map(|f| f as usize)
            && self.pcChain == other.pcChain
            && self.prgChain == other.prgChain
            && self.prgdwErrors == other.prgdwErrors
            && self.prgpbTrustInfo == other.prgpbTrustInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CERT_VERIFY_CERTIFICATE_TRUST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CERT_VERIFY_CERTIFICATE_TRUST {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_INHIBIT_CTL_UPDATE_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_NO_TIME_CHECK_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_REV_ACCUMULATIVE_TIMEOUT_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_REV_CHAIN_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_REV_NO_OCSP_FAILOVER_TO_CRL_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_REV_SERVER_OCSP_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_REV_SERVER_OCSP_WIRE_ONLY_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_TRUSTED_SIGNERS_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_VERIFY_UPDATED_CTL_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_System_SystemServices`, `Win32_UI_Controls`, `Win32_UI_WindowsAndMessaging`*"]
pub struct CERT_VIEWPROPERTIES_STRUCT_A {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub hInstance: super::super::Foundation::HINSTANCE,
    pub dwFlags: super::super::System::SystemServices::CERT_VIEWPROPERTIES_STRUCT_FLAGS,
    pub szTitle: super::super::Foundation::PSTR,
    pub pCertContext: *mut CERT_CONTEXT,
    pub arrayPurposes: *mut super::super::Foundation::PSTR,
    pub cArrayPurposes: u32,
    pub cRootStores: u32,
    pub rghstoreRoots: *mut *mut ::std::ffi::c_void,
    pub cStores: u32,
    pub rghstoreCAs: *mut *mut ::std::ffi::c_void,
    pub cTrustStores: u32,
    pub rghstoreTrust: *mut *mut ::std::ffi::c_void,
    pub hprov: usize,
    pub lCustData: super::super::Foundation::LPARAM,
    pub dwPad: u32,
    pub szHelpFileName: super::super::Foundation::PSTR,
    pub dwHelpId: u32,
    pub nStartPage: u32,
    pub cArrayPropSheetPages: u32,
    pub arrayPropSheetPages: *mut super::super::UI::Controls::PROPSHEETPAGEA,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CERT_VIEWPROPERTIES_STRUCT_A {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CERT_VIEWPROPERTIES_STRUCT_A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::fmt::Debug for CERT_VIEWPROPERTIES_STRUCT_A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_VIEWPROPERTIES_STRUCT_A")
            .field("dwSize", &self.dwSize)
            .field("hwndParent", &self.hwndParent)
            .field("hInstance", &self.hInstance)
            .field("dwFlags", &self.dwFlags)
            .field("szTitle", &self.szTitle)
            .field("pCertContext", &self.pCertContext)
            .field("arrayPurposes", &self.arrayPurposes)
            .field("cArrayPurposes", &self.cArrayPurposes)
            .field("cRootStores", &self.cRootStores)
            .field("rghstoreRoots", &self.rghstoreRoots)
            .field("cStores", &self.cStores)
            .field("rghstoreCAs", &self.rghstoreCAs)
            .field("cTrustStores", &self.cTrustStores)
            .field("rghstoreTrust", &self.rghstoreTrust)
            .field("hprov", &self.hprov)
            .field("lCustData", &self.lCustData)
            .field("dwPad", &self.dwPad)
            .field("szHelpFileName", &self.szHelpFileName)
            .field("dwHelpId", &self.dwHelpId)
            .field("nStartPage", &self.nStartPage)
            .field("cArrayPropSheetPages", &self.cArrayPropSheetPages)
            .field("arrayPropSheetPages", &self.arrayPropSheetPages)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CERT_VIEWPROPERTIES_STRUCT_A {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.hwndParent == other.hwndParent
            && self.hInstance == other.hInstance
            && self.dwFlags == other.dwFlags
            && self.szTitle == other.szTitle
            && self.pCertContext == other.pCertContext
            && self.arrayPurposes == other.arrayPurposes
            && self.cArrayPurposes == other.cArrayPurposes
            && self.cRootStores == other.cRootStores
            && self.rghstoreRoots == other.rghstoreRoots
            && self.cStores == other.cStores
            && self.rghstoreCAs == other.rghstoreCAs
            && self.cTrustStores == other.cTrustStores
            && self.rghstoreTrust == other.rghstoreTrust
            && self.hprov == other.hprov
            && self.lCustData == other.lCustData
            && self.dwPad == other.dwPad
            && self.szHelpFileName == other.szHelpFileName
            && self.dwHelpId == other.dwHelpId
            && self.nStartPage == other.nStartPage
            && self.cArrayPropSheetPages == other.cArrayPropSheetPages
            && self.arrayPropSheetPages == other.arrayPropSheetPages
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CERT_VIEWPROPERTIES_STRUCT_A {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CERT_VIEWPROPERTIES_STRUCT_A {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_System_SystemServices`, `Win32_UI_Controls`, `Win32_UI_WindowsAndMessaging`*"]
pub struct CERT_VIEWPROPERTIES_STRUCT_W {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub hInstance: super::super::Foundation::HINSTANCE,
    pub dwFlags: super::super::System::SystemServices::CERT_VIEWPROPERTIES_STRUCT_FLAGS,
    pub szTitle: super::super::Foundation::PWSTR,
    pub pCertContext: *mut CERT_CONTEXT,
    pub arrayPurposes: *mut super::super::Foundation::PSTR,
    pub cArrayPurposes: u32,
    pub cRootStores: u32,
    pub rghstoreRoots: *mut *mut ::std::ffi::c_void,
    pub cStores: u32,
    pub rghstoreCAs: *mut *mut ::std::ffi::c_void,
    pub cTrustStores: u32,
    pub rghstoreTrust: *mut *mut ::std::ffi::c_void,
    pub hprov: usize,
    pub lCustData: super::super::Foundation::LPARAM,
    pub dwPad: u32,
    pub szHelpFileName: super::super::Foundation::PWSTR,
    pub dwHelpId: u32,
    pub nStartPage: u32,
    pub cArrayPropSheetPages: u32,
    pub arrayPropSheetPages: *mut super::super::UI::Controls::PROPSHEETPAGEA,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CERT_VIEWPROPERTIES_STRUCT_W {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CERT_VIEWPROPERTIES_STRUCT_W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::fmt::Debug for CERT_VIEWPROPERTIES_STRUCT_W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_VIEWPROPERTIES_STRUCT_W")
            .field("dwSize", &self.dwSize)
            .field("hwndParent", &self.hwndParent)
            .field("hInstance", &self.hInstance)
            .field("dwFlags", &self.dwFlags)
            .field("szTitle", &self.szTitle)
            .field("pCertContext", &self.pCertContext)
            .field("arrayPurposes", &self.arrayPurposes)
            .field("cArrayPurposes", &self.cArrayPurposes)
            .field("cRootStores", &self.cRootStores)
            .field("rghstoreRoots", &self.rghstoreRoots)
            .field("cStores", &self.cStores)
            .field("rghstoreCAs", &self.rghstoreCAs)
            .field("cTrustStores", &self.cTrustStores)
            .field("rghstoreTrust", &self.rghstoreTrust)
            .field("hprov", &self.hprov)
            .field("lCustData", &self.lCustData)
            .field("dwPad", &self.dwPad)
            .field("szHelpFileName", &self.szHelpFileName)
            .field("dwHelpId", &self.dwHelpId)
            .field("nStartPage", &self.nStartPage)
            .field("cArrayPropSheetPages", &self.cArrayPropSheetPages)
            .field("arrayPropSheetPages", &self.arrayPropSheetPages)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CERT_VIEWPROPERTIES_STRUCT_W {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.hwndParent == other.hwndParent
            && self.hInstance == other.hInstance
            && self.dwFlags == other.dwFlags
            && self.szTitle == other.szTitle
            && self.pCertContext == other.pCertContext
            && self.arrayPurposes == other.arrayPurposes
            && self.cArrayPurposes == other.cArrayPurposes
            && self.cRootStores == other.cRootStores
            && self.rghstoreRoots == other.rghstoreRoots
            && self.cStores == other.cStores
            && self.rghstoreCAs == other.rghstoreCAs
            && self.cTrustStores == other.cTrustStores
            && self.rghstoreTrust == other.rghstoreTrust
            && self.hprov == other.hprov
            && self.lCustData == other.lCustData
            && self.dwPad == other.dwPad
            && self.szHelpFileName == other.szHelpFileName
            && self.dwHelpId == other.dwHelpId
            && self.nStartPage == other.nStartPage
            && self.cArrayPropSheetPages == other.cArrayPropSheetPages
            && self.arrayPropSheetPages == other.arrayPropSheetPages
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CERT_VIEWPROPERTIES_STRUCT_W {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_SystemServices", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CERT_VIEWPROPERTIES_STRUCT_W {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_X942_DH_PARAMETERS {
    pub p: CRYPTOAPI_BLOB,
    pub g: CRYPTOAPI_BLOB,
    pub q: CRYPTOAPI_BLOB,
    pub j: CRYPTOAPI_BLOB,
    pub pValidationParams: *mut CERT_X942_DH_VALIDATION_PARAMS,
}
impl CERT_X942_DH_PARAMETERS {}
impl ::std::default::Default for CERT_X942_DH_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_X942_DH_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_X942_DH_PARAMETERS").field("p", &self.p).field("g", &self.g).field("q", &self.q).field("j", &self.j).field("pValidationParams", &self.pValidationParams).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_X942_DH_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.g == other.g && self.q == other.q && self.j == other.j && self.pValidationParams == other.pValidationParams
    }
}
impl ::std::cmp::Eq for CERT_X942_DH_PARAMETERS {}
unsafe impl ::windows::runtime::Abi for CERT_X942_DH_PARAMETERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CERT_X942_DH_VALIDATION_PARAMS {
    pub seed: CRYPT_BIT_BLOB,
    pub pgenCounter: u32,
}
impl CERT_X942_DH_VALIDATION_PARAMS {}
impl ::std::default::Default for CERT_X942_DH_VALIDATION_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CERT_X942_DH_VALIDATION_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CERT_X942_DH_VALIDATION_PARAMS").field("seed", &self.seed).field("pgenCounter", &self.pgenCounter).finish()
    }
}
impl ::std::cmp::PartialEq for CERT_X942_DH_VALIDATION_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.seed == other.seed && self.pgenCounter == other.pgenCounter
    }
}
impl ::std::cmp::Eq for CERT_X942_DH_VALIDATION_PARAMS {}
unsafe impl ::windows::runtime::Abi for CERT_X942_DH_VALIDATION_PARAMS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CERT_XML_NAME_STR: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CESSetupProperty(pub i32);
pub const ENUM_CESSETUPPROP_USE_IISAPPPOOLIDENTITY: CESSetupProperty = CESSetupProperty(0i32);
pub const ENUM_CESSETUPPROP_CACONFIG: CESSetupProperty = CESSetupProperty(1i32);
pub const ENUM_CESSETUPPROP_AUTHENTICATION: CESSetupProperty = CESSetupProperty(2i32);
pub const ENUM_CESSETUPPROP_SSLCERTHASH: CESSetupProperty = CESSetupProperty(3i32);
pub const ENUM_CESSETUPPROP_URL: CESSetupProperty = CESSetupProperty(4i32);
pub const ENUM_CESSETUPPROP_RENEWALONLY: CESSetupProperty = CESSetupProperty(5i32);
pub const ENUM_CESSETUPPROP_ALLOW_KEYBASED_RENEWAL: CESSetupProperty = CESSetupProperty(6i32);
impl ::std::convert::From<i32> for CESSetupProperty {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CESSetupProperty {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CLAIMLIST {
    pub count: u32,
    pub claims: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CLAIMLIST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CLAIMLIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CLAIMLIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CLAIMLIST").field("count", &self.count).field("claims", &self.claims).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CLAIMLIST {
    fn eq(&self, other: &Self) -> bool {
        self.count == other.count && self.claims == other.claims
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CLAIMLIST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CLAIMLIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_ADD_ATTRIBUTES_INFO {
    pub dwCmcDataReference: u32,
    pub cCertReference: u32,
    pub rgdwCertReference: *mut u32,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_ADD_ATTRIBUTES_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_ADD_ATTRIBUTES_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_ADD_ATTRIBUTES_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_ADD_ATTRIBUTES_INFO").field("dwCmcDataReference", &self.dwCmcDataReference).field("cCertReference", &self.cCertReference).field("rgdwCertReference", &self.rgdwCertReference).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_ADD_ATTRIBUTES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwCmcDataReference == other.dwCmcDataReference && self.cCertReference == other.cCertReference && self.rgdwCertReference == other.rgdwCertReference && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_ADD_ATTRIBUTES_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_ADD_ATTRIBUTES_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_ADD_EXTENSIONS_INFO {
    pub dwCmcDataReference: u32,
    pub cCertReference: u32,
    pub rgdwCertReference: *mut u32,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_ADD_EXTENSIONS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_ADD_EXTENSIONS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_ADD_EXTENSIONS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_ADD_EXTENSIONS_INFO").field("dwCmcDataReference", &self.dwCmcDataReference).field("cCertReference", &self.cCertReference).field("rgdwCertReference", &self.rgdwCertReference).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_ADD_EXTENSIONS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwCmcDataReference == other.dwCmcDataReference && self.cCertReference == other.cCertReference && self.rgdwCertReference == other.rgdwCertReference && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_ADD_EXTENSIONS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_ADD_EXTENSIONS_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_DATA_INFO {
    pub cTaggedAttribute: u32,
    pub rgTaggedAttribute: *mut CMC_TAGGED_ATTRIBUTE,
    pub cTaggedRequest: u32,
    pub rgTaggedRequest: *mut CMC_TAGGED_REQUEST,
    pub cTaggedContentInfo: u32,
    pub rgTaggedContentInfo: *mut CMC_TAGGED_CONTENT_INFO,
    pub cTaggedOtherMsg: u32,
    pub rgTaggedOtherMsg: *mut CMC_TAGGED_OTHER_MSG,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_DATA_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_DATA_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_DATA_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_DATA_INFO")
            .field("cTaggedAttribute", &self.cTaggedAttribute)
            .field("rgTaggedAttribute", &self.rgTaggedAttribute)
            .field("cTaggedRequest", &self.cTaggedRequest)
            .field("rgTaggedRequest", &self.rgTaggedRequest)
            .field("cTaggedContentInfo", &self.cTaggedContentInfo)
            .field("rgTaggedContentInfo", &self.rgTaggedContentInfo)
            .field("cTaggedOtherMsg", &self.cTaggedOtherMsg)
            .field("rgTaggedOtherMsg", &self.rgTaggedOtherMsg)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_DATA_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cTaggedAttribute == other.cTaggedAttribute && self.rgTaggedAttribute == other.rgTaggedAttribute && self.cTaggedRequest == other.cTaggedRequest && self.rgTaggedRequest == other.rgTaggedRequest && self.cTaggedContentInfo == other.cTaggedContentInfo && self.rgTaggedContentInfo == other.rgTaggedContentInfo && self.cTaggedOtherMsg == other.cTaggedOtherMsg && self.rgTaggedOtherMsg == other.rgTaggedOtherMsg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_DATA_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_DATA_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_ALG: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_CERT_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_IDENTITY: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_MESSAGE_CHECK: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_REQUEST: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_BAD_TIME: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_INTERNAL_CA_ERROR: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_MUST_ARCHIVE_KEYS: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_NO_KEY_REUSE: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_POP_FAILED: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_POP_REQUIRED: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_TRY_LATER: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_FAIL_UNSUPORTED_EXT: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_OTHER_INFO_FAIL_CHOICE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_OTHER_INFO_NO_CHOICE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_OTHER_INFO_PEND_CHOICE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_PEND_INFO {
    pub PendToken: CRYPTOAPI_BLOB,
    pub PendTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_PEND_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_PEND_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_PEND_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_PEND_INFO").field("PendToken", &self.PendToken).field("PendTime", &self.PendTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_PEND_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.PendToken == other.PendToken && self.PendTime == other.PendTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_PEND_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_PEND_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_RESPONSE_INFO {
    pub cTaggedAttribute: u32,
    pub rgTaggedAttribute: *mut CMC_TAGGED_ATTRIBUTE,
    pub cTaggedContentInfo: u32,
    pub rgTaggedContentInfo: *mut CMC_TAGGED_CONTENT_INFO,
    pub cTaggedOtherMsg: u32,
    pub rgTaggedOtherMsg: *mut CMC_TAGGED_OTHER_MSG,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_RESPONSE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_RESPONSE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_RESPONSE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_RESPONSE_INFO")
            .field("cTaggedAttribute", &self.cTaggedAttribute)
            .field("rgTaggedAttribute", &self.rgTaggedAttribute)
            .field("cTaggedContentInfo", &self.cTaggedContentInfo)
            .field("rgTaggedContentInfo", &self.rgTaggedContentInfo)
            .field("cTaggedOtherMsg", &self.cTaggedOtherMsg)
            .field("rgTaggedOtherMsg", &self.rgTaggedOtherMsg)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_RESPONSE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cTaggedAttribute == other.cTaggedAttribute && self.rgTaggedAttribute == other.rgTaggedAttribute && self.cTaggedContentInfo == other.cTaggedContentInfo && self.rgTaggedContentInfo == other.rgTaggedContentInfo && self.cTaggedOtherMsg == other.cTaggedOtherMsg && self.rgTaggedOtherMsg == other.rgTaggedOtherMsg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_RESPONSE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_RESPONSE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_STATUS_CONFIRM_REQUIRED: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_STATUS_FAILED: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_STATUS_INFO {
    pub dwStatus: u32,
    pub cBodyList: u32,
    pub rgdwBodyList: *mut u32,
    pub pwszStatusString: super::super::Foundation::PWSTR,
    pub dwOtherInfoChoice: u32,
    pub Anonymous: CMC_STATUS_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_STATUS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_STATUS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_STATUS_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_STATUS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_STATUS_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMC_STATUS_INFO_0 {
    pub dwFailInfo: u32,
    pub pPendInfo: *mut CMC_PEND_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_STATUS_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_STATUS_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_STATUS_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_STATUS_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_STATUS_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_STATUS_NO_SUPPORT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_STATUS_PENDING: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_STATUS_SUCCESS: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_TAGGED_ATTRIBUTE {
    pub dwBodyPartID: u32,
    pub Attribute: CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_TAGGED_ATTRIBUTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_TAGGED_ATTRIBUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_TAGGED_ATTRIBUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_TAGGED_ATTRIBUTE").field("dwBodyPartID", &self.dwBodyPartID).field("Attribute", &self.Attribute).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_TAGGED_ATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.Attribute == other.Attribute
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_TAGGED_ATTRIBUTE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_ATTRIBUTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMC_TAGGED_CERT_REQUEST {
    pub dwBodyPartID: u32,
    pub SignedCertRequest: CRYPTOAPI_BLOB,
}
impl CMC_TAGGED_CERT_REQUEST {}
impl ::std::default::Default for CMC_TAGGED_CERT_REQUEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMC_TAGGED_CERT_REQUEST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_TAGGED_CERT_REQUEST").field("dwBodyPartID", &self.dwBodyPartID).field("SignedCertRequest", &self.SignedCertRequest).finish()
    }
}
impl ::std::cmp::PartialEq for CMC_TAGGED_CERT_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.SignedCertRequest == other.SignedCertRequest
    }
}
impl ::std::cmp::Eq for CMC_TAGGED_CERT_REQUEST {}
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_CERT_REQUEST {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMC_TAGGED_CERT_REQUEST_CHOICE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMC_TAGGED_CONTENT_INFO {
    pub dwBodyPartID: u32,
    pub EncodedContentInfo: CRYPTOAPI_BLOB,
}
impl CMC_TAGGED_CONTENT_INFO {}
impl ::std::default::Default for CMC_TAGGED_CONTENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMC_TAGGED_CONTENT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_TAGGED_CONTENT_INFO").field("dwBodyPartID", &self.dwBodyPartID).field("EncodedContentInfo", &self.EncodedContentInfo).finish()
    }
}
impl ::std::cmp::PartialEq for CMC_TAGGED_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.EncodedContentInfo == other.EncodedContentInfo
    }
}
impl ::std::cmp::Eq for CMC_TAGGED_CONTENT_INFO {}
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_CONTENT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMC_TAGGED_OTHER_MSG {
    pub dwBodyPartID: u32,
    pub pszObjId: super::super::Foundation::PSTR,
    pub Value: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CMC_TAGGED_OTHER_MSG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMC_TAGGED_OTHER_MSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMC_TAGGED_OTHER_MSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMC_TAGGED_OTHER_MSG").field("dwBodyPartID", &self.dwBodyPartID).field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMC_TAGGED_OTHER_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMC_TAGGED_OTHER_MSG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_OTHER_MSG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMC_TAGGED_REQUEST {
    pub dwTaggedRequestChoice: u32,
    pub Anonymous: CMC_TAGGED_REQUEST_0,
}
impl CMC_TAGGED_REQUEST {}
impl ::std::default::Default for CMC_TAGGED_REQUEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CMC_TAGGED_REQUEST {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CMC_TAGGED_REQUEST {}
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_REQUEST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub union CMC_TAGGED_REQUEST_0 {
    pub pTaggedCertRequest: *mut CMC_TAGGED_CERT_REQUEST,
}
impl CMC_TAGGED_REQUEST_0 {}
impl ::std::default::Default for CMC_TAGGED_REQUEST_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CMC_TAGGED_REQUEST_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CMC_TAGGED_REQUEST_0 {}
unsafe impl ::windows::runtime::Abi for CMC_TAGGED_REQUEST_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMFLTR {
    pub dwSize: u32,
    pub cExtensionChecks: u32,
    pub arrayExtensionChecks: *mut CMOID,
    pub dwCheckingFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMFLTR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMFLTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMFLTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMFLTR").field("dwSize", &self.dwSize).field("cExtensionChecks", &self.cExtensionChecks).field("arrayExtensionChecks", &self.arrayExtensionChecks).field("dwCheckingFlags", &self.dwCheckingFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMFLTR {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.cExtensionChecks == other.cExtensionChecks && self.arrayExtensionChecks == other.arrayExtensionChecks && self.dwCheckingFlags == other.dwCheckingFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMFLTR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMFLTR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMOID {
    pub szExtensionOID: super::super::Foundation::PSTR,
    pub dwTestOperation: u32,
    pub pbTestData: *mut u8,
    pub cbTestData: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMOID {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMOID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMOID {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMOID").field("szExtensionOID", &self.szExtensionOID).field("dwTestOperation", &self.dwTestOperation).field("pbTestData", &self.pbTestData).field("cbTestData", &self.cbTestData).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMOID {
    fn eq(&self, other: &Self) -> bool {
        self.szExtensionOID == other.szExtensionOID && self.dwTestOperation == other.dwTestOperation && self.pbTestData == other.pbTestData && self.cbTestData == other.cbTestData
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMOID {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMOID {
    type Abi = Self;
}
pub const CMSCEPSetup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2857327618, 36476, 18884, [148, 250, 103, 165, 204, 94, 173, 180]);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ATTR_CERT_COUNT_PARAM: u32 = 31u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ATTR_CERT_PARAM: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_AUTHENTICATED_ATTRIBUTES_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_BARE_CONTENT_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_BARE_CONTENT_PARAM: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CERT_COUNT_PARAM: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CERT_PARAM: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_ENCAPSULATED_CONTENT_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_ENCAPSULATED_CTL_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_RECIPIENT_COUNT_PARAM: u32 = 33u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM: u32 = 35u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_RECIPIENT_INDEX_PARAM: u32 = 34u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CMS_RECIPIENT_INFO {
    pub dwRecipientChoice: u32,
    pub Anonymous: CMSG_CMS_RECIPIENT_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CMS_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CMS_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CMS_RECIPIENT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CMS_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CMS_RECIPIENT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_CMS_RECIPIENT_INFO_0 {
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_INFO,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_INFO,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CMS_RECIPIENT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CMS_RECIPIENT_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CMS_RECIPIENT_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CMS_RECIPIENT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CMS_RECIPIENT_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_RECIPIENT_INFO_PARAM: u32 = 36u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CMS_SIGNER_INFO {
    pub dwVersion: u32,
    pub SignerId: CERT_ID,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedHash: CRYPTOAPI_BLOB,
    pub AuthAttrs: CRYPT_ATTRIBUTES,
    pub UnauthAttrs: CRYPT_ATTRIBUTES,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CMS_SIGNER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CMS_SIGNER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CMS_SIGNER_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CMS_SIGNER_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CMS_SIGNER_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CMS_SIGNER_INFO_PARAM: u32 = 39u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CNG_CONTENT_DECRYPT_INFO {
    pub cbSize: u32,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pfnAlloc: ::std::option::Option<PFN_CMSG_ALLOC>,
    pub pfnFree: ::std::option::Option<PFN_CMSG_FREE>,
    pub hNCryptKey: usize,
    pub pbContentEncryptKey: *mut u8,
    pub cbContentEncryptKey: u32,
    pub hCNGContentEncryptKey: BCRYPT_KEY_HANDLE,
    pub pbCNGContentEncryptKeyObject: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CNG_CONTENT_DECRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_CNG_CONTENT_DECRYPT_INFO")
            .field("cbSize", &self.cbSize)
            .field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm)
            .field("hNCryptKey", &self.hNCryptKey)
            .field("pbContentEncryptKey", &self.pbContentEncryptKey)
            .field("cbContentEncryptKey", &self.cbContentEncryptKey)
            .field("hCNGContentEncryptKey", &self.hCNGContentEncryptKey)
            .field("pbCNGContentEncryptKeyObject", &self.pbCNGContentEncryptKeyObject)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm
            && self.pfnAlloc.map(|f| f as usize) == other.pfnAlloc.map(|f| f as usize)
            && self.pfnFree.map(|f| f as usize) == other.pfnFree.map(|f| f as usize)
            && self.hNCryptKey == other.hNCryptKey
            && self.pbContentEncryptKey == other.pbContentEncryptKey
            && self.cbContentEncryptKey == other.cbContentEncryptKey
            && self.hCNGContentEncryptKey == other.hCNGContentEncryptKey
            && self.pbCNGContentEncryptKeyObject == other.pbCNGContentEncryptKeyObject
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CNG_CONTENT_DECRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CNG_CONTENT_DECRYPT_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_COMPUTED_HASH_PARAM: u32 = 22u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENTS_OCTETS_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENT_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENT_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[cfg(feature = "Win32_Foundation")]
impl ::std::clone::Clone for CMSG_CONTENT_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CONTENT_ENCRYPT_INFO {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub cRecipients: u32,
    pub rgCmsRecipients: *mut CMSG_RECIPIENT_ENCODE_INFO,
    pub pfnAlloc: ::std::option::Option<PFN_CMSG_ALLOC>,
    pub pfnFree: ::std::option::Option<PFN_CMSG_FREE>,
    pub dwEncryptFlags: u32,
    pub Anonymous: CMSG_CONTENT_ENCRYPT_INFO_0,
    pub dwFlags: u32,
    pub fCNG: super::super::Foundation::BOOL,
    pub pbCNGContentEncryptKeyObject: *mut u8,
    pub pbContentEncryptKey: *mut u8,
    pub cbContentEncryptKey: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CONTENT_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CONTENT_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CONTENT_ENCRYPT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CONTENT_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CONTENT_ENCRYPT_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_CONTENT_ENCRYPT_INFO_0 {
    pub hContentEncryptKey: usize,
    pub hCNGContentEncryptKey: BCRYPT_KEY_HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CONTENT_ENCRYPT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CONTENT_ENCRYPT_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CONTENT_ENCRYPT_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CONTENT_ENCRYPT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CONTENT_ENCRYPT_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENT_ENCRYPT_PAD_ENCODED_LEN_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENT_ENCRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CONTENT_PARAM: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CRL_COUNT_PARAM: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CRL_PARAM: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_ATTR_CERT: u32 = 14u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_CERT: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_CMS_SIGNER_INFO: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_CRL: u32 = 12u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_SIGNER: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    pub cbSize: u32,
    pub dwSignerIndex: u32,
    pub blob: CRYPTOAPI_BLOB,
}
impl CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {}
impl ::std::default::Default for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA").field("cbSize", &self.cbSize).field("dwSignerIndex", &self.dwSignerIndex).field("blob", &self.blob).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSignerIndex == other.dwSignerIndex && self.blob == other.blob
    }
}
impl ::std::cmp::Eq for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {}
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DECRYPT: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_CTRL_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub dwRecipientIndex: u32,
}
impl CMSG_CTRL_DECRYPT_PARA {}
impl ::std::default::Default for CMSG_CTRL_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CMSG_CTRL_DECRYPT_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CMSG_CTRL_DECRYPT_PARA {}
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_DECRYPT_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub union CMSG_CTRL_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
impl CMSG_CTRL_DECRYPT_PARA_0 {}
impl ::std::default::Default for CMSG_CTRL_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CMSG_CTRL_DECRYPT_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CMSG_CTRL_DECRYPT_PARA_0 {}
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_DECRYPT_PARA_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DEL_ATTR_CERT: u32 = 15u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DEL_CERT: u32 = 11u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DEL_CRL: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DEL_SIGNER: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR: u32 = 9u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    pub cbSize: u32,
    pub dwSignerIndex: u32,
    pub dwUnauthAttrIndex: u32,
}
impl CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {}
impl ::std::default::Default for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA").field("cbSize", &self.cbSize).field("dwSignerIndex", &self.dwSignerIndex).field("dwUnauthAttrIndex", &self.dwUnauthAttrIndex).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSignerIndex == other.dwSignerIndex && self.dwUnauthAttrIndex == other.dwUnauthAttrIndex
    }
}
impl ::std::cmp::Eq for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {}
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_ENABLE_STRONG_SIGNATURE: u32 = 21u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_KEY_AGREE_DECRYPT: u32 = 17u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
    pub dwRecipientEncryptedKeyIndex: u32,
    pub OriginatorPublicKey: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_KEY_TRANS_DECRYPT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_MAIL_LIST_DECRYPT: u32 = 18u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
    pub dwKeyChoice: u32,
    pub Anonymous: CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    pub hKeyEncryptionKey: usize,
    pub pvKeyEncryptionKey: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_VERIFY_HASH: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_VERIFY_SIGNATURE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_CTRL_VERIFY_SIGNATURE_EX: u32 = 19u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub dwSignerIndex: u32,
    pub dwSignerType: u32,
    pub pvSigner: *mut ::std::ffi::c_void,
}
impl CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {}
impl ::std::default::Default for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA").field("cbSize", &self.cbSize).field("hCryptProv", &self.hCryptProv).field("dwSignerIndex", &self.dwSignerIndex).field("dwSignerType", &self.dwSignerType).field("pvSigner", &self.pvSigner).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.dwSignerIndex == other.dwSignerIndex && self.dwSignerType == other.dwSignerType && self.pvSigner == other.pvSigner
    }
}
impl ::std::cmp::Eq for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {}
unsafe impl ::windows::runtime::Abi for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_DETACHED_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCODED_MESSAGE: u32 = 29u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCODED_SIGNER: u32 = 28u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCODE_SORTED_CTL_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCODING_TYPE_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCRYPTED: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCRYPTED_DIGEST: u32 = 27u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_ENCRYPTED_ENCODE_INFO {
    pub cbSize: u32,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_ENCRYPTED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_ENCRYPTED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_ENCRYPTED_ENCODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_ENCRYPTED_ENCODE_INFO").field("cbSize", &self.cbSize).field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm).field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_ENCRYPTED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_ENCRYPTED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_ENCRYPTED_ENCODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENCRYPT_PARAM: u32 = 26u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_DATA_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_DATA_V0: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_DATA_V2: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_ENVELOPED_ENCODE_INFO {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub cRecipients: u32,
    pub rgpRecipients: *mut *mut CERT_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_ENVELOPED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_ENVELOPED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_ENVELOPED_ENCODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_ENVELOPED_ENCODE_INFO")
            .field("cbSize", &self.cbSize)
            .field("hCryptProv", &self.hCryptProv)
            .field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm)
            .field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo)
            .field("cRecipients", &self.cRecipients)
            .field("rgpRecipients", &self.rgpRecipients)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_ENVELOPED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo && self.cRecipients == other.cRecipients && self.rgpRecipients == other.rgpRecipients
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_ENVELOPED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_ENVELOPED_ENCODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V0: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V2: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V3: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V4: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_ENVELOPE_ALGORITHM_PARAM: u32 = 15u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASHED_DATA_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASHED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASHED_DATA_V0: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASHED_DATA_V2: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_HASHED_ENCODE_INFO {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_HASHED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_HASHED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_HASHED_ENCODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_HASHED_ENCODE_INFO").field("cbSize", &self.cbSize).field("hCryptProv", &self.hCryptProv).field("HashAlgorithm", &self.HashAlgorithm).field("pvHashAuxInfo", &self.pvHashAuxInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_HASHED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.HashAlgorithm == other.HashAlgorithm && self.pvHashAuxInfo == other.pvHashAuxInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_HASHED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_HASHED_ENCODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASH_ALGORITHM_PARAM: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_HASH_DATA_PARAM: u32 = 21u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_INDEFINITE_LENGTH: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_INNER_CONTENT_TYPE_PARAM: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_MATERIAL_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_OBJID_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_ALG_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_BITS_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_PARA_FLAG: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_AGREE_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub UserKeyingMaterial: CRYPTOAPI_BLOB,
    pub dwOriginatorChoice: CMSG_KEY_AGREE_ORIGINATOR,
    pub Anonymous: CMSG_KEY_AGREE_ENCRYPT_INFO_0,
    pub cKeyAgreeKeyEncryptInfo: u32,
    pub rgpKeyAgreeKeyEncryptInfo: *mut *mut CMSG_KEY_AGREE_KEY_ENCRYPT_INFO,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_ENCRYPT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_ENCRYPT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    pub OriginatorCertId: CERT_ID,
    pub OriginatorPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_ENCRYPT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    pub cbSize: u32,
    pub EncryptedKey: CRYPTOAPI_BLOB,
}
impl CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {}
impl ::std::default::Default for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_KEY_AGREE_KEY_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("EncryptedKey", &self.EncryptedKey).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.EncryptedKey == other.EncryptedKey
    }
}
impl ::std::cmp::Eq for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {}
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CMSG_KEY_AGREE_OPTION(pub u32);
pub const CMSG_KEY_AGREE_EPHEMERAL_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(1u32);
pub const CMSG_KEY_AGREE_STATIC_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(2u32);
impl ::std::convert::From<u32> for CMSG_KEY_AGREE_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_OPTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CMSG_KEY_AGREE_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CMSG_KEY_AGREE_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CMSG_KEY_AGREE_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CMSG_KEY_AGREE_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CMSG_KEY_AGREE_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CMSG_KEY_AGREE_ORIGINATOR(pub u32);
pub const CMSG_KEY_AGREE_ORIGINATOR_CERT: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(1u32);
pub const CMSG_KEY_AGREE_ORIGINATOR_PUBLIC_KEY: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(2u32);
impl ::std::convert::From<u32> for CMSG_KEY_AGREE_ORIGINATOR {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_ORIGINATOR {
    type Abi = Self;
}
impl ::std::ops::BitOr for CMSG_KEY_AGREE_ORIGINATOR {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CMSG_KEY_AGREE_ORIGINATOR {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CMSG_KEY_AGREE_ORIGINATOR {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CMSG_KEY_AGREE_ORIGINATOR {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CMSG_KEY_AGREE_ORIGINATOR {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_RECIPIENT: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub KeyWrapAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyWrapAuxInfo: *mut ::std::ffi::c_void,
    pub hCryptProv: usize,
    pub dwKeySpec: u32,
    pub dwKeyChoice: CMSG_KEY_AGREE_OPTION,
    pub Anonymous: CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0,
    pub UserKeyingMaterial: CRYPTOAPI_BLOB,
    pub cRecipientEncryptedKeys: u32,
    pub rgpRecipientEncryptedKeys: *mut *mut CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    pub pEphemeralAlgorithm: *mut CRYPT_ALGORITHM_IDENTIFIER,
    pub pSenderId: *mut CERT_ID,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_AGREE_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub dwOriginatorChoice: CMSG_KEY_AGREE_ORIGINATOR,
    pub Anonymous: CMSG_KEY_AGREE_RECIPIENT_INFO_0,
    pub UserKeyingMaterial: CRYPTOAPI_BLOB,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub cRecipientEncryptedKeys: u32,
    pub rgpRecipientEncryptedKeys: *mut *mut CMSG_RECIPIENT_ENCRYPTED_KEY_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_RECIPIENT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_RECIPIENT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    pub OriginatorCertId: CERT_ID,
    pub OriginatorPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_AGREE_RECIPIENT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_AGREE_VERSION: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_TRANS_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_TRANS_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPTOAPI_BLOB,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_TRANS_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_KEY_TRANS_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("dwRecipientIndex", &self.dwRecipientIndex).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRecipientIndex == other.dwRecipientIndex && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_TRANS_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_TRANS_ENCRYPT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_TRANS_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_KEY_TRANS_RECIPIENT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub hCryptProv: usize,
    pub RecipientPublicKey: CRYPT_BIT_BLOB,
    pub RecipientId: CERT_ID,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_KEY_TRANS_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub RecipientId: CERT_ID,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_KEY_TRANS_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_KEY_TRANS_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_KEY_TRANS_RECIPIENT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_KEY_TRANS_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_KEY_TRANS_RECIPIENT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_LENGTH_ONLY_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_MAIL_LIST_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPTOAPI_BLOB,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_MAIL_LIST_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_MAIL_LIST_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("dwRecipientIndex", &self.dwRecipientIndex).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRecipientIndex == other.dwRecipientIndex && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_MAIL_LIST_ENCRYPT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_MAIL_LIST_ENCRYPT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAIL_LIST_HANDLE_KEY_CHOICE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAIL_LIST_RECIPIENT: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub hCryptProv: usize,
    pub dwKeyChoice: u32,
    pub Anonymous: CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0,
    pub KeyId: CRYPTOAPI_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    pub hKeyEncryptionKey: usize,
    pub pvKeyEncryptionKey: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_MAIL_LIST_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub KeyId: CRYPTOAPI_BLOB,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPTOAPI_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_MAIL_LIST_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_MAIL_LIST_RECIPIENT_INFO").field("dwVersion", &self.dwVersion).field("KeyId", &self.KeyId).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("Date", &self.Date).field("pOtherAttr", &self.pOtherAttr).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.KeyId == other.KeyId && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.Date == other.Date && self.pOtherAttr == other.pOtherAttr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_MAIL_LIST_RECIPIENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_MAIL_LIST_RECIPIENT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAIL_LIST_VERSION: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_MAX_LENGTH_FLAG: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_RC2_AUX_INFO {
    pub cbSize: u32,
    pub dwBitLen: u32,
}
impl CMSG_RC2_AUX_INFO {}
impl ::std::default::Default for CMSG_RC2_AUX_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_RC2_AUX_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_RC2_AUX_INFO").field("cbSize", &self.cbSize).field("dwBitLen", &self.dwBitLen).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_RC2_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwBitLen == other.dwBitLen
    }
}
impl ::std::cmp::Eq for CMSG_RC2_AUX_INFO {}
unsafe impl ::windows::runtime::Abi for CMSG_RC2_AUX_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_RC4_AUX_INFO {
    pub cbSize: u32,
    pub dwBitLen: u32,
}
impl CMSG_RC4_AUX_INFO {}
impl ::std::default::Default for CMSG_RC4_AUX_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_RC4_AUX_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_RC4_AUX_INFO").field("cbSize", &self.cbSize).field("dwBitLen", &self.dwBitLen).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_RC4_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwBitLen == other.dwBitLen
    }
}
impl ::std::cmp::Eq for CMSG_RC4_AUX_INFO {}
unsafe impl ::windows::runtime::Abi for CMSG_RC4_AUX_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_RC4_NO_SALT_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_RECIPIENT_COUNT_PARAM: u32 = 17u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_RECIPIENT_ENCODE_INFO {
    pub dwRecipientChoice: u32,
    pub Anonymous: CMSG_RECIPIENT_ENCODE_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_RECIPIENT_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_RECIPIENT_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_RECIPIENT_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_RECIPIENT_ENCODE_INFO_0 {
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_RECIPIENT_ENCODE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_RECIPIENT_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_RECIPIENT_ENCODE_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    pub cbSize: u32,
    pub RecipientPublicKey: CRYPT_BIT_BLOB,
    pub RecipientId: CERT_ID,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    pub RecipientId: CERT_ID,
    pub EncryptedKey: CRYPTOAPI_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_RECIPIENT_INDEX_PARAM: u32 = 18u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_RECIPIENT_INFO_PARAM: u32 = 19u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    pub cbSize: u32,
    pub SignedInfo: CMSG_SIGNED_ENCODE_INFO,
    pub EnvelopedInfo: CMSG_ENVELOPED_ENCODE_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO").field("cbSize", &self.cbSize).field("SignedInfo", &self.SignedInfo).field("EnvelopedInfo", &self.EnvelopedInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.SignedInfo == other.SignedInfo && self.EnvelopedInfo == other.EnvelopedInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNED_DATA_CMS_VERSION: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNED_DATA_NO_SIGN_FLAG: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNED_DATA_PKCS_1_5_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNED_DATA_V1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNED_DATA_V3: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_SIGNED_ENCODE_INFO {
    pub cbSize: u32,
    pub cSigners: u32,
    pub rgSigners: *mut CMSG_SIGNER_ENCODE_INFO,
    pub cCertEncoded: u32,
    pub rgCertEncoded: *mut CRYPTOAPI_BLOB,
    pub cCrlEncoded: u32,
    pub rgCrlEncoded: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_SIGNED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_SIGNED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_SIGNED_ENCODE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_SIGNED_ENCODE_INFO")
            .field("cbSize", &self.cbSize)
            .field("cSigners", &self.cSigners)
            .field("rgSigners", &self.rgSigners)
            .field("cCertEncoded", &self.cCertEncoded)
            .field("rgCertEncoded", &self.rgCertEncoded)
            .field("cCrlEncoded", &self.cCrlEncoded)
            .field("rgCrlEncoded", &self.rgCrlEncoded)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_SIGNED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cSigners == other.cSigners && self.rgSigners == other.rgSigners && self.cCertEncoded == other.cCertEncoded && self.rgCertEncoded == other.rgCertEncoded && self.cCrlEncoded == other.cCrlEncoded && self.rgCrlEncoded == other.rgCrlEncoded
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_SIGNED_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_SIGNED_ENCODE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_AUTH_ATTR_PARAM: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_CERT_ID_PARAM: u32 = 38u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_CERT_INFO_PARAM: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_COUNT_PARAM: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_SIGNER_ENCODE_INFO {
    pub cbSize: u32,
    pub pCertInfo: *mut CERT_INFO,
    pub Anonymous: CMSG_SIGNER_ENCODE_INFO_0,
    pub dwKeySpec: u32,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut ::std::ffi::c_void,
    pub cAuthAttr: u32,
    pub rgAuthAttr: *mut CRYPT_ATTRIBUTE,
    pub cUnauthAttr: u32,
    pub rgUnauthAttr: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_SIGNER_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_SIGNER_ENCODE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_SIGNER_ENCODE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_SIGNER_ENCODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_SIGNER_ENCODE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CMSG_SIGNER_ENCODE_INFO_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_SIGNER_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_SIGNER_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_SIGNER_ENCODE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_SIGNER_ENCODE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_SIGNER_ENCODE_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_HASH_ALGORITHM_PARAM: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_SIGNER_INFO {
    pub dwVersion: u32,
    pub Issuer: CRYPTOAPI_BLOB,
    pub SerialNumber: CRYPTOAPI_BLOB,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedHash: CRYPTOAPI_BLOB,
    pub AuthAttrs: CRYPT_ATTRIBUTES,
    pub UnauthAttrs: CRYPT_ATTRIBUTES,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_SIGNER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_SIGNER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_SIGNER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_SIGNER_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("Issuer", &self.Issuer)
            .field("SerialNumber", &self.SerialNumber)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("HashEncryptionAlgorithm", &self.HashEncryptionAlgorithm)
            .field("EncryptedHash", &self.EncryptedHash)
            .field("AuthAttrs", &self.AuthAttrs)
            .field("UnauthAttrs", &self.UnauthAttrs)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_SIGNER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Issuer == other.Issuer && self.SerialNumber == other.SerialNumber && self.HashAlgorithm == other.HashAlgorithm && self.HashEncryptionAlgorithm == other.HashEncryptionAlgorithm && self.EncryptedHash == other.EncryptedHash && self.AuthAttrs == other.AuthAttrs && self.UnauthAttrs == other.UnauthAttrs
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_SIGNER_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_SIGNER_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_INFO_CMS_VERSION: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_INFO_PARAM: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_INFO_PKCS_1_5_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_INFO_V1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_INFO_V3: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_ONLY_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SIGNER_UNAUTH_ATTR_PARAM: u32 = 10u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMSG_SP3_COMPATIBLE_AUX_INFO {
    pub cbSize: u32,
    pub dwFlags: u32,
}
impl CMSG_SP3_COMPATIBLE_AUX_INFO {}
impl ::std::default::Default for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_SP3_COMPATIBLE_AUX_INFO").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).finish()
    }
}
impl ::std::cmp::PartialEq for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwFlags == other.dwFlags
    }
}
impl ::std::cmp::Eq for CMSG_SP3_COMPATIBLE_AUX_INFO {}
unsafe impl ::windows::runtime::Abi for CMSG_SP3_COMPATIBLE_AUX_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_SP3_COMPATIBLE_ENCRYPT_FLAG: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMSG_STREAM_INFO {
    pub cbContent: u32,
    pub pfnStreamOutput: ::std::option::Option<PFN_CMSG_STREAM_OUTPUT>,
    pub pvArg: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMSG_STREAM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMSG_STREAM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMSG_STREAM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMSG_STREAM_INFO").field("cbContent", &self.cbContent).field("pvArg", &self.pvArg).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMSG_STREAM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbContent == other.cbContent && self.pfnStreamOutput.map(|f| f as usize) == other.pfnStreamOutput.map(|f| f as usize) && self.pvArg == other.pvArg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMSG_STREAM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMSG_STREAM_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_TRUSTED_SIGNER_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_TYPE_PARAM: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_UNPROTECTED_ATTR_PARAM: u32 = 37u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_USE_SIGNER_INDEX_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERIFY_COUNTER_SIGN_ENABLE_STRONG_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERIFY_SIGNER_CERT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERIFY_SIGNER_CHAIN: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERIFY_SIGNER_NULL: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERIFY_SIGNER_PUBKEY: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CMSG_VERSION_PARAM: u32 = 30u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CMS_DH_KEY_INFO {
    pub dwVersion: u32,
    pub Algid: u32,
    pub pszContentEncObjId: super::super::Foundation::PSTR,
    pub PubInfo: CRYPTOAPI_BLOB,
    pub pReserved: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CMS_DH_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMS_DH_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMS_DH_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMS_DH_KEY_INFO").field("dwVersion", &self.dwVersion).field("Algid", &self.Algid).field("pszContentEncObjId", &self.pszContentEncObjId).field("PubInfo", &self.PubInfo).field("pReserved", &self.pReserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMS_DH_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Algid == other.Algid && self.pszContentEncObjId == other.pszContentEncObjId && self.PubInfo == other.PubInfo && self.pReserved == other.pReserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMS_DH_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMS_DH_KEY_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CMS_KEY_INFO {
    pub dwVersion: u32,
    pub Algid: u32,
    pub pbOID: *mut u8,
    pub cbOID: u32,
}
impl CMS_KEY_INFO {}
impl ::std::default::Default for CMS_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CMS_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMS_KEY_INFO").field("dwVersion", &self.dwVersion).field("Algid", &self.Algid).field("pbOID", &self.pbOID).field("cbOID", &self.cbOID).finish()
    }
}
impl ::std::cmp::PartialEq for CMS_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Algid == other.Algid && self.pbOID == other.pbOID && self.cbOID == other.cbOID
    }
}
impl ::std::cmp::Eq for CMS_KEY_INFO {}
unsafe impl ::windows::runtime::Abi for CMS_KEY_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CM_VIEWFLAGS_MASK: u32 = 16777215u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CPS_URLS {
    pub pszURL: super::super::Foundation::PWSTR,
    pub pAlgorithm: *mut CRYPT_ALGORITHM_IDENTIFIER,
    pub pDigest: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CPS_URLS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CPS_URLS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CPS_URLS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPS_URLS").field("pszURL", &self.pszURL).field("pAlgorithm", &self.pAlgorithm).field("pDigest", &self.pDigest).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CPS_URLS {
    fn eq(&self, other: &Self) -> bool {
        self.pszURL == other.pszURL && self.pAlgorithm == other.pAlgorithm && self.pDigest == other.pDigest
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CPS_URLS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CPS_URLS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_CONTEXT {
    pub dwCertEncodingType: u32,
    pub pbCrlEncoded: *mut u8,
    pub cbCrlEncoded: u32,
    pub pCrlInfo: *mut CRL_INFO,
    pub hCertStore: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_CONTEXT").field("dwCertEncodingType", &self.dwCertEncodingType).field("pbCrlEncoded", &self.pbCrlEncoded).field("cbCrlEncoded", &self.cbCrlEncoded).field("pCrlInfo", &self.pCrlInfo).field("hCertStore", &self.hCertStore).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwCertEncodingType == other.dwCertEncodingType && self.pbCrlEncoded == other.pbCrlEncoded && self.cbCrlEncoded == other.cbCrlEncoded && self.pCrlInfo == other.pCrlInfo && self.hCertStore == other.hCertStore
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_DIST_POINT {
    pub DistPointName: CRL_DIST_POINT_NAME,
    pub ReasonFlags: CRYPT_BIT_BLOB,
    pub CRLIssuer: CERT_ALT_NAME_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_DIST_POINT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_DIST_POINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_DIST_POINT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_DIST_POINT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_DIST_POINT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_DIST_POINTS_INFO {
    pub cDistPoint: u32,
    pub rgDistPoint: *mut CRL_DIST_POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_DIST_POINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_DIST_POINTS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_DIST_POINTS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_DIST_POINTS_INFO").field("cDistPoint", &self.cDistPoint).field("rgDistPoint", &self.rgDistPoint).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_DIST_POINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cDistPoint == other.cDistPoint && self.rgDistPoint == other.rgDistPoint
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_DIST_POINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_DIST_POINTS_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_ERR_CRL_ISSUER_BIT: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_ERR_INDEX_MASK: u32 = 127u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_FULL_NAME: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_ISSUER_RDN_NAME: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_DIST_POINT_NAME {
    pub dwDistPointNameChoice: u32,
    pub Anonymous: CRL_DIST_POINT_NAME_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_DIST_POINT_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_DIST_POINT_NAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_DIST_POINT_NAME {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_DIST_POINT_NAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_DIST_POINT_NAME {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRL_DIST_POINT_NAME_0 {
    pub FullName: CERT_ALT_NAME_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_DIST_POINT_NAME_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_DIST_POINT_NAME_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_DIST_POINT_NAME_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_DIST_POINT_NAME_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_DIST_POINT_NAME_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_DIST_POINT_NO_NAME: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_ENTRY {
    pub SerialNumber: CRYPTOAPI_BLOB,
    pub RevocationDate: super::super::Foundation::FILETIME,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_ENTRY").field("SerialNumber", &self.SerialNumber).field("RevocationDate", &self.RevocationDate).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.SerialNumber == other.SerialNumber && self.RevocationDate == other.RevocationDate && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_ENTRY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ANY: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_EXISTING: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_BY: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_BY_AKI_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_BY_BASE_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_BY_DELTA_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_BY_SIGNATURE_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_FOR: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_FIND_ISSUED_FOR_PARA {
    pub pSubjectCert: *mut CERT_CONTEXT,
    pub pIssuerCert: *mut CERT_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_FIND_ISSUED_FOR_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_FIND_ISSUED_FOR_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_FIND_ISSUED_FOR_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_FIND_ISSUED_FOR_PARA").field("pSubjectCert", &self.pSubjectCert).field("pIssuerCert", &self.pIssuerCert).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_FIND_ISSUED_FOR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pSubjectCert == other.pSubjectCert && self.pIssuerCert == other.pIssuerCert
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_FIND_ISSUED_FOR_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_FIND_ISSUED_FOR_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_FIND_ISSUED_FOR_SET_STRONG_PROPERTIES_FLAG: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_INFO {
    pub dwVersion: u32,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Issuer: CRYPTOAPI_BLOB,
    pub ThisUpdate: super::super::Foundation::FILETIME,
    pub NextUpdate: super::super::Foundation::FILETIME,
    pub cCRLEntry: u32,
    pub rgCRLEntry: *mut CRL_ENTRY,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("SignatureAlgorithm", &self.SignatureAlgorithm)
            .field("Issuer", &self.Issuer)
            .field("ThisUpdate", &self.ThisUpdate)
            .field("NextUpdate", &self.NextUpdate)
            .field("cCRLEntry", &self.cCRLEntry)
            .field("rgCRLEntry", &self.rgCRLEntry)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SignatureAlgorithm == other.SignatureAlgorithm && self.Issuer == other.Issuer && self.ThisUpdate == other.ThisUpdate && self.NextUpdate == other.NextUpdate && self.cCRLEntry == other.cCRLEntry && self.rgCRLEntry == other.rgCRLEntry && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_ISSUING_DIST_POINT {
    pub DistPointName: CRL_DIST_POINT_NAME,
    pub fOnlyContainsUserCerts: super::super::Foundation::BOOL,
    pub fOnlyContainsCACerts: super::super::Foundation::BOOL,
    pub OnlySomeReasonFlags: CRYPT_BIT_BLOB,
    pub fIndirectCRL: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_ISSUING_DIST_POINT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_ISSUING_DIST_POINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_ISSUING_DIST_POINT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_ISSUING_DIST_POINT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_ISSUING_DIST_POINT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_AA_COMPROMISE: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_AA_COMPROMISE_FLAG: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_AFFILIATION_CHANGED_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_CA_COMPROMISE_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_CERTIFICATE_HOLD_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_CESSATION_OF_OPERATION_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_KEY_COMPROMISE_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_PRIVILEGE_WITHDRAWN: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_PRIVILEGE_WITHDRAWN_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_SUPERSEDED_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_REASON_UNUSED_FLAG: u32 = 128u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRL_REVOCATION_INFO {
    pub pCrlEntry: *mut CRL_ENTRY,
    pub pCrlContext: *mut CRL_CONTEXT,
    pub pCrlIssuerChain: *mut CERT_CHAIN_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl CRL_REVOCATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRL_REVOCATION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRL_REVOCATION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRL_REVOCATION_INFO").field("pCrlEntry", &self.pCrlEntry).field("pCrlContext", &self.pCrlContext).field("pCrlIssuerChain", &self.pCrlIssuerChain).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRL_REVOCATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pCrlEntry == other.pCrlEntry && self.pCrlContext == other.pCrlContext && self.pCrlIssuerChain == other.pCrlIssuerChain
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRL_REVOCATION_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRL_REVOCATION_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_V1: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRL_V2: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CROSS_CERT_DIST_POINTS_INFO {
    pub dwSyncDeltaTime: u32,
    pub cDistPoint: u32,
    pub rgDistPoint: *mut CERT_ALT_NAME_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CROSS_CERT_DIST_POINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CROSS_CERT_DIST_POINTS_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CROSS_CERT_DIST_POINTS_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CROSS_CERT_DIST_POINTS_INFO").field("dwSyncDeltaTime", &self.dwSyncDeltaTime).field("cDistPoint", &self.cDistPoint).field("rgDistPoint", &self.rgDistPoint).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CROSS_CERT_DIST_POINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSyncDeltaTime == other.dwSyncDeltaTime && self.cDistPoint == other.cDistPoint && self.rgDistPoint == other.rgDistPoint
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CROSS_CERT_DIST_POINTS_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CROSS_CERT_DIST_POINTS_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_MASK: u32 = 255u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_ACTION_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_CACHE_ONLY_URL_RETRIEVAL: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_DISABLE_AIA: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_POLICY_MASK: u32 = 65535u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_REVOCATION_CACHE: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_REVOCATION_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_REVOCATION_NONE: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTDLG_REVOCATION_ONLINE: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_DEFAULT: u32 = 50u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_CRL_BEFORE_OCSP_ENABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_DEFAULT: u32 = 500u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_OCSP_AFTER_CRL_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 20u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_DEFAULT: u32 = 60u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_PRE_FETCH_TRIGGER_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_DEFAULT_FLUSH: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_DISABLE_FLUSH: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTNET_URL_CACHE_FLUSH_INFO {
    pub cbSize: u32,
    pub dwExemptSeconds: u32,
    pub ExpireTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTNET_URL_CACHE_FLUSH_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTNET_URL_CACHE_FLUSH_INFO").field("cbSize", &self.cbSize).field("dwExemptSeconds", &self.dwExemptSeconds).field("ExpireTime", &self.ExpireTime).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwExemptSeconds == other.dwExemptSeconds && self.ExpireTime == other.ExpireTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTNET_URL_CACHE_FLUSH_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTNET_URL_CACHE_FLUSH_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_AUTOROOT_CAB: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_BLOB: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_CRL: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_DISALLOWED_CERT_CAB: u32 = 6u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    pub cbSize: u32,
    pub dwObjectType: u32,
    pub dwError: u32,
    pub dwReserved: u32,
    pub ThisUpdateTime: super::super::Foundation::FILETIME,
    pub NextUpdateTime: super::super::Foundation::FILETIME,
    pub PublishTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTNET_URL_CACHE_PRE_FETCH_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTNET_URL_CACHE_PRE_FETCH_INFO")
            .field("cbSize", &self.cbSize)
            .field("dwObjectType", &self.dwObjectType)
            .field("dwError", &self.dwError)
            .field("dwReserved", &self.dwReserved)
            .field("ThisUpdateTime", &self.ThisUpdateTime)
            .field("NextUpdateTime", &self.NextUpdateTime)
            .field("PublishTime", &self.PublishTime)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwObjectType == other.dwObjectType && self.dwError == other.dwError && self.dwReserved == other.dwReserved && self.ThisUpdateTime == other.ThisUpdateTime && self.NextUpdateTime == other.NextUpdateTime && self.PublishTime == other.PublishTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_OCSP: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_PIN_RULES_CAB: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_HTTP: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTNET_URL_CACHE_RESPONSE_INFO {
    pub cbSize: u32,
    pub wResponseType: u16,
    pub wResponseFlags: u16,
    pub LastModifiedTime: super::super::Foundation::FILETIME,
    pub dwMaxAge: u32,
    pub pwszETag: super::super::Foundation::PWSTR,
    pub dwProxyId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTNET_URL_CACHE_RESPONSE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTNET_URL_CACHE_RESPONSE_INFO")
            .field("cbSize", &self.cbSize)
            .field("wResponseType", &self.wResponseType)
            .field("wResponseFlags", &self.wResponseFlags)
            .field("LastModifiedTime", &self.LastModifiedTime)
            .field("dwMaxAge", &self.dwMaxAge)
            .field("pwszETag", &self.pwszETag)
            .field("dwProxyId", &self.dwProxyId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wResponseType == other.wResponseType && self.wResponseFlags == other.wResponseFlags && self.LastModifiedTime == other.LastModifiedTime && self.dwMaxAge == other.dwMaxAge && self.pwszETag == other.pwszETag && self.dwProxyId == other.dwProxyId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTNET_URL_CACHE_RESPONSE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_VALIDATED: u32 = 32768u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPTOAPI_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl CRYPTOAPI_BLOB {}
impl ::std::default::Default for CRYPTOAPI_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPTOAPI_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTOAPI_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPTOAPI_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl ::std::cmp::Eq for CRYPTOAPI_BLOB {}
unsafe impl ::windows::runtime::Abi for CRYPTOAPI_BLOB {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECTMEMORY_BLOCK_SIZE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECTMEMORY_CROSS_PROCESS: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECTMEMORY_SAME_LOGON: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECTMEMORY_SAME_PROCESS: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_AUDIT: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_CRED_REGENERATE: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_CRED_SYNC: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_FIRST_RESERVED_FLAGVAL: u32 = 268435455u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_LAST_RESERVED_FLAGVAL: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_LOCAL_MACHINE: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_NO_RECOVERY: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTPROTECT_PROMPTSTRUCT {
    pub cbSize: u32,
    pub dwPromptFlags: u32,
    pub hwndApp: super::super::Foundation::HWND,
    pub szPrompt: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTPROTECT_PROMPTSTRUCT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTPROTECT_PROMPTSTRUCT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTPROTECT_PROMPTSTRUCT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTPROTECT_PROMPTSTRUCT").field("cbSize", &self.cbSize).field("dwPromptFlags", &self.dwPromptFlags).field("hwndApp", &self.hwndApp).field("szPrompt", &self.szPrompt).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTPROTECT_PROMPTSTRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwPromptFlags == other.dwPromptFlags && self.hwndApp == other.hwndApp && self.szPrompt == other.szPrompt
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTPROTECT_PROMPTSTRUCT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTPROTECT_PROMPTSTRUCT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_PROMPT_ON_PROTECT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_PROMPT_ON_UNPROTECT: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_PROMPT_REQUIRE_STRONG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_PROMPT_RESERVED: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_PROMPT_STRONG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_UI_FORBIDDEN: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTPROTECT_VERIFY_PROTECTION: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_CERT_MGR_PUBLISHER_TAB: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_CERT_MGR_SINGLE_TAB_FLAG: u32 = 32768u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_CERT_MGR_STRUCT {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub dwFlags: u32,
    pub pwszTitle: super::super::Foundation::PWSTR,
    pub pszInitUsageOID: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_CERT_MGR_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_CERT_MGR_STRUCT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_CERT_MGR_STRUCT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_CERT_MGR_STRUCT").field("dwSize", &self.dwSize).field("hwndParent", &self.hwndParent).field("dwFlags", &self.dwFlags).field("pwszTitle", &self.pwszTitle).field("pszInitUsageOID", &self.pszInitUsageOID).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_CERT_MGR_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.hwndParent == other.hwndParent && self.dwFlags == other.dwFlags && self.pwszTitle == other.pwszTitle && self.pszInitUsageOID == other.pszInitUsageOID
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_CERT_MGR_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_CERT_MGR_STRUCT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_CERT_MGR_TAB_MASK: u32 = 15u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_INITDIALOG_STRUCT {
    pub lParam: super::super::Foundation::LPARAM,
    pub pCertContext: *mut CERT_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_INITDIALOG_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_INITDIALOG_STRUCT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_INITDIALOG_STRUCT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_INITDIALOG_STRUCT").field("lParam", &self.lParam).field("pCertContext", &self.pCertContext).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_INITDIALOG_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.lParam == other.lParam && self.pCertContext == other.pCertContext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_INITDIALOG_STRUCT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_INITDIALOG_STRUCT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_EXPIRATION_COLUMN: u64 = 32u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_FRIENDLYNAME_COLUMN: u64 = 8u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_INTENDEDUSE_COLUMN: u64 = 4u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_ISSUEDBY_COLUMN: u64 = 2u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_ISSUEDTO_COLUMN: u64 = 1u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_SELECT_LOCATION_COLUMN: u64 = 16u64;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_VIEWCERTIFICATE_FLAGS(pub u32);
pub const CRYPTUI_HIDE_HIERARCHYPAGE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(1u32);
pub const CRYPTUI_HIDE_DETAILPAGE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(2u32);
pub const CRYPTUI_DISABLE_EDITPROPERTIES: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(4u32);
pub const CRYPTUI_ENABLE_EDITPROPERTIES: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(8u32);
pub const CRYPTUI_DISABLE_ADDTOSTORE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(16u32);
pub const CRYPTUI_ENABLE_ADDTOSTORE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(32u32);
pub const CRYPTUI_ACCEPT_DECLINE_STYLE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(64u32);
pub const CRYPTUI_IGNORE_UNTRUSTED_ROOT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(128u32);
pub const CRYPTUI_DONT_OPEN_STORES: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(256u32);
pub const CRYPTUI_ONLY_OPEN_ROOT_STORE: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(512u32);
pub const CRYPTUI_WARN_UNTRUSTED_ROOT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(1024u32);
pub const CRYPTUI_ENABLE_REVOCATION_CHECKING: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(2048u32);
pub const CRYPTUI_WARN_REMOTE_TRUST: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(4096u32);
pub const CRYPTUI_DISABLE_EXPORT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(8192u32);
pub const CRYPTUI_ENABLE_REVOCATION_CHECK_END_CERT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(16384u32);
pub const CRYPTUI_ENABLE_REVOCATION_CHECK_CHAIN: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(32768u32);
pub const CRYPTUI_ENABLE_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(2048u32);
pub const CRYPTUI_DISABLE_HTMLLINK: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(65536u32);
pub const CRYPTUI_DISABLE_ISSUERSTATEMENT: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(131072u32);
pub const CRYPTUI_CACHE_ONLY_URL_RETRIEVAL: CRYPTUI_VIEWCERTIFICATE_FLAGS = CRYPTUI_VIEWCERTIFICATE_FLAGS(262144u32);
impl ::std::convert::From<u32> for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_VIEWCERTIFICATE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_Security_Cryptography_Catalog`, `Win32_Security_Cryptography_Sip`, `Win32_Security_WinTrust`, `Win32_UI_Controls`, `Win32_UI_WindowsAndMessaging`*"]
pub struct CRYPTUI_VIEWCERTIFICATE_STRUCTA {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub dwFlags: CRYPTUI_VIEWCERTIFICATE_FLAGS,
    pub szTitle: super::super::Foundation::PSTR,
    pub pCertContext: *mut CERT_CONTEXT,
    pub rgszPurposes: *mut super::super::Foundation::PSTR,
    pub cPurposes: u32,
    pub Anonymous: CRYPTUI_VIEWCERTIFICATE_STRUCTA_0,
    pub fpCryptProviderDataTrustedUsage: super::super::Foundation::BOOL,
    pub idxSigner: u32,
    pub idxCert: u32,
    pub fCounterSigner: super::super::Foundation::BOOL,
    pub idxCounterSigner: u32,
    pub cStores: u32,
    pub rghStores: *mut *mut ::std::ffi::c_void,
    pub cPropSheetPages: u32,
    pub rgPropSheetPages: *mut super::super::UI::Controls::PROPSHEETPAGEA,
    pub nStartPage: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CRYPTUI_VIEWCERTIFICATE_STRUCTA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CRYPTUI_VIEWCERTIFICATE_STRUCTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CRYPTUI_VIEWCERTIFICATE_STRUCTA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CRYPTUI_VIEWCERTIFICATE_STRUCTA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CRYPTUI_VIEWCERTIFICATE_STRUCTA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
pub union CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {
    pub pCryptProviderData: *mut super::WinTrust::CRYPT_PROVIDER_DATA,
    pub hWVTStateData: super::super::Foundation::HANDLE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CRYPTUI_VIEWCERTIFICATE_STRUCTA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`, `Win32_Graphics_Gdi`, `Win32_Security_Cryptography_Catalog`, `Win32_Security_Cryptography_Sip`, `Win32_Security_WinTrust`, `Win32_UI_Controls`, `Win32_UI_WindowsAndMessaging`*"]
pub struct CRYPTUI_VIEWCERTIFICATE_STRUCTW {
    pub dwSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub dwFlags: CRYPTUI_VIEWCERTIFICATE_FLAGS,
    pub szTitle: super::super::Foundation::PWSTR,
    pub pCertContext: *mut CERT_CONTEXT,
    pub rgszPurposes: *mut super::super::Foundation::PSTR,
    pub cPurposes: u32,
    pub Anonymous: CRYPTUI_VIEWCERTIFICATE_STRUCTW_0,
    pub fpCryptProviderDataTrustedUsage: super::super::Foundation::BOOL,
    pub idxSigner: u32,
    pub idxCert: u32,
    pub fCounterSigner: super::super::Foundation::BOOL,
    pub idxCounterSigner: u32,
    pub cStores: u32,
    pub rghStores: *mut *mut ::std::ffi::c_void,
    pub cPropSheetPages: u32,
    pub rgPropSheetPages: *mut super::super::UI::Controls::PROPSHEETPAGEW,
    pub nStartPage: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CRYPTUI_VIEWCERTIFICATE_STRUCTW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CRYPTUI_VIEWCERTIFICATE_STRUCTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CRYPTUI_VIEWCERTIFICATE_STRUCTW {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CRYPTUI_VIEWCERTIFICATE_STRUCTW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CRYPTUI_VIEWCERTIFICATE_STRUCTW {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
pub union CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {
    pub pCryptProviderData: *mut super::WinTrust::CRYPT_PROVIDER_DATA,
    pub hWVTStateData: super::super::Foundation::HANDLE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_Security_Cryptography_Catalog", feature = "Win32_Security_Cryptography_Sip", feature = "Win32_Security_WinTrust", feature = "Win32_UI_Controls", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CRYPTUI_VIEWCERTIFICATE_STRUCTW_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE(pub u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN: CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE = CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE(1u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN_NO_ROOT: CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE = CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE(2u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_ADD_NONE: CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE = CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE(0u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN(pub u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_CERT: CRYPTUI_WIZ_DIGITAL_SIGN = CRYPTUI_WIZ_DIGITAL_SIGN(1u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_STORE: CRYPTUI_WIZ_DIGITAL_SIGN = CRYPTUI_WIZ_DIGITAL_SIGN(2u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_PVK: CRYPTUI_WIZ_DIGITAL_SIGN = CRYPTUI_WIZ_DIGITAL_SIGN(3u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_NONE: CRYPTUI_WIZ_DIGITAL_SIGN = CRYPTUI_WIZ_DIGITAL_SIGN(0u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_DIGITAL_SIGN {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_DIGITAL_SIGN {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_DIGITAL_SIGN {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_DIGITAL_SIGN {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_DIGITAL_SIGN {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_DIGITAL_SIGN {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {
    pub dwSize: u32,
    pub pGuidSubject: *mut ::windows::runtime::GUID,
    pub cbBlob: u32,
    pub pbBlob: *mut u8,
    pub pwszDisplayName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO").field("dwSize", &self.dwSize).field("pGuidSubject", &self.pGuidSubject).field("cbBlob", &self.cbBlob).field("pbBlob", &self.pbBlob).field("pwszDisplayName", &self.pwszDisplayName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.pGuidSubject == other.pGuidSubject && self.cbBlob == other.cbBlob && self.pbBlob == other.pbBlob && self.pwszDisplayName == other.pwszDisplayName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {
    pub dwSize: u32,
    pub pwszSigningCertFileName: super::super::Foundation::PWSTR,
    pub dwPvkChoice: CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION,
    pub Anonymous: CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {
    pub pPvkFileInfo: *mut CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO,
    pub pPvkProvInfo: *mut CRYPT_KEY_PROV_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {
    pub dwSize: u32,
    pub cbBlob: u32,
    pub pbBlob: *mut u8,
}
impl CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {}
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT").field("dwSize", &self.dwSize).field("cbBlob", &self.cbBlob).field("pbBlob", &self.pbBlob).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.cbBlob == other.cbBlob && self.pbBlob == other.pbBlob
    }
}
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_WIZ_DIGITAL_SIGN_EXCLUDE_PAGE_HASHES: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {
    pub dwSize: u32,
    pub dwAttrFlags: CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE,
    pub pwszDescription: super::super::Foundation::PWSTR,
    pub pwszMoreInfoLocation: super::super::Foundation::PWSTR,
    pub pszHashAlg: super::super::Foundation::PSTR,
    pub pwszSigningCertDisplayString: super::super::Foundation::PWSTR,
    pub hAdditionalCertStore: *mut ::std::ffi::c_void,
    pub psAuthenticated: *mut CRYPT_ATTRIBUTES,
    pub psUnauthenticated: *mut CRYPT_ATTRIBUTES,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO")
            .field("dwSize", &self.dwSize)
            .field("dwAttrFlags", &self.dwAttrFlags)
            .field("pwszDescription", &self.pwszDescription)
            .field("pwszMoreInfoLocation", &self.pwszMoreInfoLocation)
            .field("pszHashAlg", &self.pszHashAlg)
            .field("pwszSigningCertDisplayString", &self.pwszSigningCertDisplayString)
            .field("hAdditionalCertStore", &self.hAdditionalCertStore)
            .field("psAuthenticated", &self.psAuthenticated)
            .field("psUnauthenticated", &self.psUnauthenticated)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwAttrFlags == other.dwAttrFlags && self.pwszDescription == other.pwszDescription && self.pwszMoreInfoLocation == other.pwszMoreInfoLocation && self.pszHashAlg == other.pszHashAlg && self.pwszSigningCertDisplayString == other.pwszSigningCertDisplayString && self.hAdditionalCertStore == other.hAdditionalCertStore && self.psAuthenticated == other.psAuthenticated && self.psUnauthenticated == other.psUnauthenticated
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_WIZ_DIGITAL_SIGN_INCLUDE_PAGE_HASHES: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_INFO {
    pub dwSize: u32,
    pub dwSubjectChoice: CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT,
    pub Anonymous1: CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0,
    pub dwSigningCertChoice: CRYPTUI_WIZ_DIGITAL_SIGN,
    pub Anonymous2: CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1,
    pub pwszTimestampURL: super::super::Foundation::PWSTR,
    pub dwAdditionalCertChoice: CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE,
    pub pSignExtInfo: *mut CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {
    pub pwszFileName: super::super::Foundation::PWSTR,
    pub pSignBlobInfo: *mut CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {
    pub pSigningCertContext: *mut CERT_CONTEXT,
    pub pSigningCertStore: *mut ::std::mem::ManuallyDrop<CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO>,
    pub pSigningCertPvkInfo: *mut CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_INFO_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {
    pub dwSize: u32,
    pub pwszPvkFileName: super::super::Foundation::PWSTR,
    pub pwszProvName: super::super::Foundation::PWSTR,
    pub dwProvType: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO").field("dwSize", &self.dwSize).field("pwszPvkFileName", &self.pwszPvkFileName).field("pwszProvName", &self.pwszProvName).field("dwProvType", &self.dwProvType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.pwszPvkFileName == other.pwszPvkFileName && self.pwszProvName == other.pwszProvName && self.dwProvType == other.dwProvType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION(pub u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE: CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION = CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION(1u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_PVK_PROV: CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION = CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION(2u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE(pub u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_COMMERCIAL: CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE = CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE(1u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_INDIVIDUAL: CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE = CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE(2u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {
    pub dwSize: u32,
    pub cCertStore: u32,
    pub rghCertStore: *mut *mut ::std::ffi::c_void,
    pub pFilterCallback: ::std::option::Option<PFNCFILTERPROC>,
    pub pvCallbackData: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO").field("dwSize", &self.dwSize).field("cCertStore", &self.cCertStore).field("rghCertStore", &self.rghCertStore).field("pvCallbackData", &self.pvCallbackData).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.cCertStore == other.cCertStore && self.rghCertStore == other.rghCertStore && self.pFilterCallback.map(|f| f as usize) == other.pFilterCallback.map(|f| f as usize) && self.pvCallbackData == other.pvCallbackData
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT(pub u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_BLOB: CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT(2u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_FILE: CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT(1u32);
pub const CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_NONE: CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT(0u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {
    pub dwSize: u32,
    pub dwExportFormat: CRYPTUI_WIZ_EXPORT_FORMAT,
    pub fExportChain: super::super::Foundation::BOOL,
    pub fExportPrivateKeys: super::super::Foundation::BOOL,
    pub pwszPassword: super::super::Foundation::PWSTR,
    pub fStrongEncryption: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO")
            .field("dwSize", &self.dwSize)
            .field("dwExportFormat", &self.dwExportFormat)
            .field("fExportChain", &self.fExportChain)
            .field("fExportPrivateKeys", &self.fExportPrivateKeys)
            .field("pwszPassword", &self.pwszPassword)
            .field("fStrongEncryption", &self.fStrongEncryption)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwExportFormat == other.dwExportFormat && self.fExportChain == other.fExportChain && self.fExportPrivateKeys == other.fExportPrivateKeys && self.pwszPassword == other.pwszPassword && self.fStrongEncryption == other.fStrongEncryption
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_EXPORT_FORMAT(pub u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_DER: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(1u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_PFX: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(2u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_PKCS7: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(3u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_BASE64: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(4u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_CRL: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(6u32);
pub const CRYPTUI_WIZ_EXPORT_FORMAT_CTL: CRYPTUI_WIZ_EXPORT_FORMAT = CRYPTUI_WIZ_EXPORT_FORMAT(7u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_EXPORT_FORMAT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_EXPORT_FORMAT {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_EXPORT_FORMAT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_EXPORT_FORMAT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_EXPORT_FORMAT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_EXPORT_FORMAT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_EXPORT_FORMAT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPTUI_WIZ_EXPORT_FORMAT_SERIALIZED_CERT_STORE: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_EXPORT_INFO {
    pub dwSize: u32,
    pub pwszExportFileName: super::super::Foundation::PWSTR,
    pub dwSubjectChoice: CRYPTUI_WIZ_EXPORT_SUBJECT,
    pub Anonymous: CRYPTUI_WIZ_EXPORT_INFO_0,
    pub cStores: u32,
    pub rghStores: *mut *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_EXPORT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_EXPORT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_EXPORT_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_EXPORT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_EXPORT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPTUI_WIZ_EXPORT_INFO_0 {
    pub pCertContext: *mut CERT_CONTEXT,
    pub pCTLContext: *mut CTL_CONTEXT,
    pub pCRLContext: *mut CRL_CONTEXT,
    pub hCertStore: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_EXPORT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_EXPORT_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_EXPORT_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_EXPORT_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_EXPORT_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_EXPORT_SUBJECT(pub u32);
pub const CRYPTUI_WIZ_EXPORT_CERT_CONTEXT: CRYPTUI_WIZ_EXPORT_SUBJECT = CRYPTUI_WIZ_EXPORT_SUBJECT(1u32);
pub const CRYPTUI_WIZ_EXPORT_CTL_CONTEXT: CRYPTUI_WIZ_EXPORT_SUBJECT = CRYPTUI_WIZ_EXPORT_SUBJECT(2u32);
pub const CRYPTUI_WIZ_EXPORT_CRL_CONTEXT: CRYPTUI_WIZ_EXPORT_SUBJECT = CRYPTUI_WIZ_EXPORT_SUBJECT(3u32);
pub const CRYPTUI_WIZ_EXPORT_CERT_STORE: CRYPTUI_WIZ_EXPORT_SUBJECT = CRYPTUI_WIZ_EXPORT_SUBJECT(4u32);
pub const CRYPTUI_WIZ_EXPORT_CERT_STORE_CERTIFICATES_ONLY: CRYPTUI_WIZ_EXPORT_SUBJECT = CRYPTUI_WIZ_EXPORT_SUBJECT(5u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_EXPORT_SUBJECT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_EXPORT_SUBJECT {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_EXPORT_SUBJECT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_EXPORT_SUBJECT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_EXPORT_SUBJECT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_EXPORT_SUBJECT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_EXPORT_SUBJECT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_FLAGS(pub u32);
pub const CRYPTUI_WIZ_NO_UI: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(1u32);
pub const CRYPTUI_WIZ_IGNORE_NO_UI_FLAG_FOR_CSPS: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(2u32);
pub const CRYPTUI_WIZ_NO_UI_EXCEPT_CSP: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(3u32);
pub const CRYPTUI_WIZ_IMPORT_ALLOW_CERT: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(131072u32);
pub const CRYPTUI_WIZ_IMPORT_ALLOW_CRL: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(262144u32);
pub const CRYPTUI_WIZ_IMPORT_ALLOW_CTL: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(524288u32);
pub const CRYPTUI_WIZ_IMPORT_NO_CHANGE_DEST_STORE: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(65536u32);
pub const CRYPTUI_WIZ_IMPORT_TO_LOCALMACHINE: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(1048576u32);
pub const CRYPTUI_WIZ_IMPORT_TO_CURRENTUSER: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(2097152u32);
pub const CRYPTUI_WIZ_IMPORT_REMOTE_DEST_STORE: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(4194304u32);
pub const CRYPTUI_WIZ_EXPORT_PRIVATE_KEY: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(256u32);
pub const CRYPTUI_WIZ_EXPORT_NO_DELETE_PRIVATE_KEY: CRYPTUI_WIZ_FLAGS = CRYPTUI_WIZ_FLAGS(512u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPTUI_WIZ_IMPORT_SRC_INFO {
    pub dwSize: u32,
    pub dwSubjectChoice: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION,
    pub Anonymous: CRYPTUI_WIZ_IMPORT_SRC_INFO_0,
    pub dwFlags: CRYPT_KEY_FLAGS,
    pub pwszPassword: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_IMPORT_SRC_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_IMPORT_SRC_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_IMPORT_SRC_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_IMPORT_SRC_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_IMPORT_SRC_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {
    pub pwszFileName: super::super::Foundation::PWSTR,
    pub pCertContext: *mut CERT_CONTEXT,
    pub pCTLContext: *mut CTL_CONTEXT,
    pub pCRLContext: *mut CRL_CONTEXT,
    pub hCertStore: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_IMPORT_SRC_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(pub u32);
pub const CRYPTUI_WIZ_IMPORT_SUBJECT_FILE: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION = CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(1u32);
pub const CRYPTUI_WIZ_IMPORT_SUBJECT_CERT_CONTEXT: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION = CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(2u32);
pub const CRYPTUI_WIZ_IMPORT_SUBJECT_CTL_CONTEXT: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION = CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(3u32);
pub const CRYPTUI_WIZ_IMPORT_SUBJECT_CRL_CONTEXT: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION = CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(4u32);
pub const CRYPTUI_WIZ_IMPORT_SUBJECT_CERT_STORE: CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION = CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION(5u32);
impl ::std::convert::From<u32> for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_3DES_KEY_STATE {
    pub Key: [u8; 24],
    pub IV: [u8; 8],
    pub Feedback: [u8; 8],
}
impl CRYPT_3DES_KEY_STATE {}
impl ::std::default::Default for CRYPT_3DES_KEY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_3DES_KEY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_3DES_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("Feedback", &self.Feedback).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_3DES_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.Feedback == other.Feedback
    }
}
impl ::std::cmp::Eq for CRYPT_3DES_KEY_STATE {}
unsafe impl ::windows::runtime::Abi for CRYPT_3DES_KEY_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACCUMULATIVE_TIMEOUT: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_ACQUIRE_FLAGS(pub u32);
pub const CRYPT_ACQUIRE_CACHE_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(1u32);
pub const CRYPT_ACQUIRE_COMPARE_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(4u32);
pub const CRYPT_ACQUIRE_NO_HEALING: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(8u32);
pub const CRYPT_ACQUIRE_SILENT_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(64u32);
pub const CRYPT_ACQUIRE_USE_PROV_INFO_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(2u32);
impl ::std::convert::From<u32> for CRYPT_ACQUIRE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_ACQUIRE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK: u32 = 458752u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ACQUIRE_WINDOW_HANDLE_FLAG: u32 = 128u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_AES_128_KEY_STATE {
    pub Key: [u8; 16],
    pub IV: [u8; 16],
    pub EncryptionState: [u8; 176],
    pub DecryptionState: [u8; 176],
    pub Feedback: [u8; 16],
}
impl CRYPT_AES_128_KEY_STATE {}
impl ::std::default::Default for CRYPT_AES_128_KEY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_AES_128_KEY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_AES_128_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("EncryptionState", &self.EncryptionState).field("DecryptionState", &self.DecryptionState).field("Feedback", &self.Feedback).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_AES_128_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.EncryptionState == other.EncryptionState && self.DecryptionState == other.DecryptionState && self.Feedback == other.Feedback
    }
}
impl ::std::cmp::Eq for CRYPT_AES_128_KEY_STATE {}
unsafe impl ::windows::runtime::Abi for CRYPT_AES_128_KEY_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_AES_256_KEY_STATE {
    pub Key: [u8; 32],
    pub IV: [u8; 16],
    pub EncryptionState: [u8; 240],
    pub DecryptionState: [u8; 240],
    pub Feedback: [u8; 16],
}
impl CRYPT_AES_256_KEY_STATE {}
impl ::std::default::Default for CRYPT_AES_256_KEY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_AES_256_KEY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_AES_256_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("EncryptionState", &self.EncryptionState).field("DecryptionState", &self.DecryptionState).field("Feedback", &self.Feedback).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_AES_256_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.EncryptionState == other.EncryptionState && self.DecryptionState == other.DecryptionState && self.Feedback == other.Feedback
    }
}
impl ::std::cmp::Eq for CRYPT_AES_256_KEY_STATE {}
unsafe impl ::windows::runtime::Abi for CRYPT_AES_256_KEY_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_AIA_RETRIEVAL: u32 = 524288u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ALGORITHM_IDENTIFIER {
    pub pszObjId: super::super::Foundation::PSTR,
    pub Parameters: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ALGORITHM_IDENTIFIER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ALGORITHM_IDENTIFIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ALGORITHM_IDENTIFIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ALGORITHM_IDENTIFIER").field("pszObjId", &self.pszObjId).field("Parameters", &self.Parameters).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ALGORITHM_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Parameters == other.Parameters
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ALGORITHM_IDENTIFIER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ALGORITHM_IDENTIFIER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ARCHIVE: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ASN_ENCODING: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ASYNC_RETRIEVAL: u32 = 16u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    pub pfnCompletion: ::std::option::Option<PFN_CRYPT_ASYNC_RETRIEVAL_COMPLETION_FUNC>,
    pub pvCompletion: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ASYNC_RETRIEVAL_COMPLETION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ASYNC_RETRIEVAL_COMPLETION").field("pvCompletion", &self.pvCompletion).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn eq(&self, other: &Self) -> bool {
        self.pfnCompletion.map(|f| f as usize) == other.pfnCompletion.map(|f| f as usize) && self.pvCompletion == other.pvCompletion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ASYNC_RETRIEVAL_COMPLETION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ATTRIBUTE {
    pub pszObjId: super::super::Foundation::PSTR,
    pub cValue: u32,
    pub rgValue: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ATTRIBUTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ATTRIBUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ATTRIBUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ATTRIBUTE").field("pszObjId", &self.pszObjId).field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ATTRIBUTE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ATTRIBUTE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ATTRIBUTES {
    pub cAttr: u32,
    pub rgAttr: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ATTRIBUTES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ATTRIBUTES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ATTRIBUTES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ATTRIBUTES").field("cAttr", &self.cAttr).field("rgAttr", &self.rgAttr).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ATTRIBUTES {
    fn eq(&self, other: &Self) -> bool {
        self.cAttr == other.cAttr && self.rgAttr == other.rgAttr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ATTRIBUTES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ATTRIBUTES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ATTRIBUTE_TYPE_VALUE {
    pub pszObjId: super::super::Foundation::PSTR,
    pub Value: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ATTRIBUTE_TYPE_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ATTRIBUTE_TYPE_VALUE").field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ATTRIBUTE_TYPE_VALUE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ATTRIBUTE_TYPE_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_BIT_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
    pub cUnusedBits: u32,
}
impl CRYPT_BIT_BLOB {}
impl ::std::default::Default for CRYPT_BIT_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_BIT_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_BIT_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).field("cUnusedBits", &self.cUnusedBits).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_BIT_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData && self.cUnusedBits == other.cUnusedBits
    }
}
impl ::std::cmp::Eq for CRYPT_BIT_BLOB {}
unsafe impl ::windows::runtime::Abi for CRYPT_BIT_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_BLOB_ARRAY {
    pub cBlob: u32,
    pub rgBlob: *mut CRYPTOAPI_BLOB,
}
impl CRYPT_BLOB_ARRAY {}
impl ::std::default::Default for CRYPT_BLOB_ARRAY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_BLOB_ARRAY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_BLOB_ARRAY").field("cBlob", &self.cBlob).field("rgBlob", &self.rgBlob).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_BLOB_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.cBlob == other.cBlob && self.rgBlob == other.rgBlob
    }
}
impl ::std::cmp::Eq for CRYPT_BLOB_ARRAY {}
unsafe impl ::windows::runtime::Abi for CRYPT_BLOB_ARRAY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_CACHE_ONLY_RETRIEVAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_CHECK_FRESHNESS_TIME_VALIDITY: u32 = 1024u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CONTENT_INFO {
    pub pszObjId: super::super::Foundation::PSTR,
    pub Content: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CONTENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CONTENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CONTENT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTENT_INFO").field("pszObjId", &self.pszObjId).field("Content", &self.Content).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Content == other.Content
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CONTENT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CONTENT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    pub pszObjId: super::super::Foundation::PSTR,
    pub cValue: u32,
    pub rgValue: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY").field("pszObjId", &self.pszObjId).field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CONTEXTS {
    pub cContexts: u32,
    pub rgpszContexts: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CONTEXTS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CONTEXTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CONTEXTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTEXTS").field("cContexts", &self.cContexts).field("rgpszContexts", &self.rgpszContexts).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CONTEXTS {
    fn eq(&self, other: &Self) -> bool {
        self.cContexts == other.cContexts && self.rgpszContexts == other.rgpszContexts
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CONTEXTS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXTS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_CONTEXT_CONFIG {
    pub dwFlags: CRYPT_CONTEXT_CONFIG_FLAGS,
    pub dwReserved: u32,
}
impl CRYPT_CONTEXT_CONFIG {}
impl ::std::default::Default for CRYPT_CONTEXT_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_CONTEXT_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTEXT_CONFIG").field("dwFlags", &self.dwFlags).field("dwReserved", &self.dwReserved).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_CONTEXT_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for CRYPT_CONTEXT_CONFIG {}
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXT_CONFIG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_CONTEXT_CONFIG_FLAGS(pub u32);
pub const CRYPT_EXCLUSIVE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(1u32);
pub const CRYPT_OVERRIDE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(65536u32);
impl ::std::convert::From<u32> for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CONTEXT_FUNCTIONS {
    pub cFunctions: u32,
    pub rgpszFunctions: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CONTEXT_FUNCTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CONTEXT_FUNCTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CONTEXT_FUNCTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTEXT_FUNCTIONS").field("cFunctions", &self.cFunctions).field("rgpszFunctions", &self.rgpszFunctions).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CONTEXT_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.cFunctions == other.cFunctions && self.rgpszFunctions == other.rgpszFunctions
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CONTEXT_FUNCTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXT_FUNCTIONS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_CONTEXT_FUNCTION_CONFIG {
    pub dwFlags: u32,
    pub dwReserved: u32,
}
impl CRYPT_CONTEXT_FUNCTION_CONFIG {}
impl ::std::default::Default for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTEXT_FUNCTION_CONFIG").field("dwFlags", &self.dwFlags).field("dwReserved", &self.dwReserved).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for CRYPT_CONTEXT_FUNCTION_CONFIG {}
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXT_FUNCTION_CONFIG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    pub cProviders: u32,
    pub rgpszProviders: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CONTEXT_FUNCTION_PROVIDERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CONTEXT_FUNCTION_PROVIDERS").field("cProviders", &self.cProviders).field("rgpszProviders", &self.rgpszProviders).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpszProviders == other.rgpszProviders
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CONTEXT_FUNCTION_PROVIDERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_CREATE_NEW_FLUSH_ENTRY: u32 = 268435456u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CREDENTIALS {
    pub cbSize: u32,
    pub pszCredentialsOid: super::super::Foundation::PSTR,
    pub pvCredentials: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CREDENTIALS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CREDENTIALS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CREDENTIALS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CREDENTIALS").field("cbSize", &self.cbSize).field("pszCredentialsOid", &self.pszCredentialsOid).field("pvCredentials", &self.pvCredentials).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CREDENTIALS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszCredentialsOid == other.pszCredentialsOid && self.pvCredentials == other.pvCredentials
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CREDENTIALS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CREDENTIALS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_CSP_PROVIDER {
    pub dwKeySpec: u32,
    pub pwszProviderName: super::super::Foundation::PWSTR,
    pub Signature: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_CSP_PROVIDER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_CSP_PROVIDER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_CSP_PROVIDER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_CSP_PROVIDER").field("dwKeySpec", &self.dwKeySpec).field("pwszProviderName", &self.pwszProviderName).field("Signature", &self.Signature).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_CSP_PROVIDER {
    fn eq(&self, other: &Self) -> bool {
        self.dwKeySpec == other.dwKeySpec && self.pwszProviderName == other.pwszProviderName && self.Signature == other.Signature
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_CSP_PROVIDER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_CSP_PROVIDER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_ALLOC_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_ENABLE_UTF8PERCENT_FLAG: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_NOCOPY_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_DECODE_PARA {
    pub cbSize: u32,
    pub pfnAlloc: ::std::option::Option<PFN_CRYPT_ALLOC>,
    pub pfnFree: ::std::option::Option<PFN_CRYPT_FREE>,
}
impl CRYPT_DECODE_PARA {}
impl ::std::default::Default for CRYPT_DECODE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_DECODE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_DECODE_PARA").field("cbSize", &self.cbSize).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_DECODE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pfnAlloc.map(|f| f as usize) == other.pfnAlloc.map(|f| f as usize) && self.pfnFree.map(|f| f as usize) == other.pfnFree.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for CRYPT_DECODE_PARA {}
unsafe impl ::windows::runtime::Abi for CRYPT_DECODE_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_SHARE_OID_STRING_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECODE_TO_BE_SIGNED_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECRYPT: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_DECRYPT_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub cCertStore: u32,
    pub rghCertStore: *mut *mut ::std::ffi::c_void,
}
impl CRYPT_DECRYPT_MESSAGE_PARA {}
impl ::std::default::Default for CRYPT_DECRYPT_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_DECRYPT_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_DECRYPT_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("cCertStore", &self.cCertStore).field("rghCertStore", &self.rghCertStore).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_DECRYPT_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.cCertStore == other.cCertStore && self.rghCertStore == other.rghCertStore
    }
}
impl ::std::cmp::Eq for CRYPT_DECRYPT_MESSAGE_PARA {}
unsafe impl ::windows::runtime::Abi for CRYPT_DECRYPT_MESSAGE_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DECRYPT_RSA_NO_PADDING_CHECK: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DEFAULT_CONTAINER_OPTIONAL: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_DEFAULT_CONTEXT_FLAGS(pub u32);
pub const CRYPT_DEFAULT_CONTEXT_AUTO_RELEASE_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(1u32);
pub const CRYPT_DEFAULT_CONTEXT_PROCESS_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(2u32);
impl ::std::convert::From<u32> for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    pub cOID: u32,
    pub rgpszOID: *mut super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA").field("cOID", &self.cOID).field("rgpszOID", &self.rgpszOID).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cOID == other.cOID && self.rgpszOID == other.rgpszOID
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_DEFAULT_CONTEXT_TYPE(pub u32);
pub const CRYPT_DEFAULT_CONTEXT_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(1u32);
pub const CRYPT_DEFAULT_CONTEXT_MULTI_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(2u32);
impl ::std::convert::From<u32> for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_DEFAULT_CONTEXT_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_DEFAULT_CONTEXT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_DEFAULT_CONTEXT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_DEFAULT_CONTEXT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DELETEKEYSET: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DELETE_DEFAULT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DELETE_KEYSET: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_DES_KEY_STATE {
    pub Key: [u8; 8],
    pub IV: [u8; 8],
    pub Feedback: [u8; 8],
}
impl CRYPT_DES_KEY_STATE {}
impl ::std::default::Default for CRYPT_DES_KEY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_DES_KEY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_DES_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("Feedback", &self.Feedback).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_DES_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.Feedback == other.Feedback
    }
}
impl ::std::cmp::Eq for CRYPT_DES_KEY_STATE {}
unsafe impl ::windows::runtime::Abi for CRYPT_DES_KEY_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DONT_CACHE_RESULT: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DONT_CHECK_TIME_VALIDITY: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_DONT_VERIFY_SIGNATURE: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ECC_CMS_SHARED_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EntityUInfo: CRYPTOAPI_BLOB,
    pub rgbSuppPubInfo: [u8; 4],
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ECC_CMS_SHARED_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ECC_CMS_SHARED_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ECC_CMS_SHARED_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ECC_CMS_SHARED_INFO").field("Algorithm", &self.Algorithm).field("EntityUInfo", &self.EntityUInfo).field("rgbSuppPubInfo", &self.rgbSuppPubInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ECC_CMS_SHARED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.EntityUInfo == other.EntityUInfo && self.rgbSuppPubInfo == other.rgbSuppPubInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ECC_CMS_SHARED_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ECC_CMS_SHARED_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ECC_CMS_SHARED_INFO_SUPPPUBINFO_BYTE_LENGTH: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ECC_PRIVATE_KEY_INFO {
    pub dwVersion: u32,
    pub PrivateKey: CRYPTOAPI_BLOB,
    pub szCurveOid: super::super::Foundation::PSTR,
    pub PublicKey: CRYPT_BIT_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ECC_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ECC_PRIVATE_KEY_INFO").field("dwVersion", &self.dwVersion).field("PrivateKey", &self.PrivateKey).field("szCurveOid", &self.szCurveOid).field("PublicKey", &self.PublicKey).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.PrivateKey == other.PrivateKey && self.szCurveOid == other.szCurveOid && self.PublicKey == other.PublicKey
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ECC_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ECC_PRIVATE_KEY_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ECC_PRIVATE_KEY_INFO_v1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENABLE_FILE_RETRIEVAL: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENABLE_SSL_REVOCATION_RETRIEVAL: u32 = 8388608u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENCODE_DECODE_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENCODE_ENABLE_UTF8PERCENT_FLAG: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENCODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_ENCODE_OBJECT_FLAGS(pub u32);
pub const CRYPT_ENCODE_ALLOC_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(32768u32);
pub const CRYPT_ENCODE_ENABLE_PUNYCODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(131072u32);
pub const CRYPT_UNICODE_NAME_ENCODE_DISABLE_CHECK_TYPE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(1073741824u32);
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_T61_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(2147483648u32);
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_UTF8_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(536870912u32);
impl ::std::convert::From<u32> for CRYPT_ENCODE_OBJECT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_ENCODE_OBJECT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_ENCODE_PARA {
    pub cbSize: u32,
    pub pfnAlloc: ::std::option::Option<PFN_CRYPT_ALLOC>,
    pub pfnFree: ::std::option::Option<PFN_CRYPT_FREE>,
}
impl CRYPT_ENCODE_PARA {}
impl ::std::default::Default for CRYPT_ENCODE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_ENCODE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ENCODE_PARA").field("cbSize", &self.cbSize).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_ENCODE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pfnAlloc.map(|f| f as usize) == other.pfnAlloc.map(|f| f as usize) && self.pfnFree.map(|f| f as usize) == other.pfnFree.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for CRYPT_ENCODE_PARA {}
unsafe impl ::windows::runtime::Abi for CRYPT_ENCODE_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENCRYPT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    pub EncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedPrivateKey: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ENCRYPTED_PRIVATE_KEY_INFO").field("EncryptionAlgorithm", &self.EncryptionAlgorithm).field("EncryptedPrivateKey", &self.EncryptedPrivateKey).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.EncryptionAlgorithm == other.EncryptionAlgorithm && self.EncryptedPrivateKey == other.EncryptedPrivateKey
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENCRYPT_ALG_OID_GROUP_ID: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ENCRYPT_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: usize,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut ::std::ffi::c_void,
    pub dwFlags: u32,
    pub dwInnerContentType: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ENCRYPT_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ENCRYPT_MESSAGE_PARA")
            .field("cbSize", &self.cbSize)
            .field("dwMsgEncodingType", &self.dwMsgEncodingType)
            .field("hCryptProv", &self.hCryptProv)
            .field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm)
            .field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo)
            .field("dwFlags", &self.dwFlags)
            .field("dwInnerContentType", &self.dwInnerContentType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo && self.dwFlags == other.dwFlags && self.dwInnerContentType == other.dwInnerContentType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ENCRYPT_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ENCRYPT_MESSAGE_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_ENHKEY_USAGE_OID_GROUP_ID: u32 = 7u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    pub pwszName: super::super::Foundation::PWSTR,
    pub pwszValue: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_ENROLLMENT_NAME_VALUE_PAIR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_ENROLLMENT_NAME_VALUE_PAIR").field("pwszName", &self.pwszName).field("pwszValue", &self.pwszValue).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.pwszName == other.pwszName && self.pwszValue == other.pwszValue
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_EXPORT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_EXPORT_KEY: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_EXT_OR_ATTR_OID_GROUP_ID: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FAILED: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FASTSGC: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_FIND_FLAGS(pub u32);
pub const CRYPT_FIND_USER_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(1u32);
pub const CRYPT_FIND_MACHINE_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(2u32);
pub const CRYPT_FIND_SILENT_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(64u32);
impl ::std::convert::From<u32> for CRYPT_FIND_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_FIND_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_FIND_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_FIND_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_FIND_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_FIND_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_FIND_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FIRST: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FIRST_ALG_OID_GROUP_ID: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_IPSEC: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_PCT1: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_SIGNING: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_SSL2: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_SSL3: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FLAG_TLS1: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_COMMA: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_CRLF: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_OID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_RDN_CRLF: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_RDN_REVERSE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_RDN_SEMICOLON: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_RDN_UNQUOTE: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_SEMICOLON: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_SIMPLE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_STR_MULTI_LINE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_STR_NO_HEX: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_FORMAT_X509: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_GET_INSTALLED_OID_FUNC_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    pub cbSize: u32,
    pub iDeltaCrlIndicator: i32,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub pLastSyncTime: *mut super::super::Foundation::FILETIME,
    pub pMaxAgeTime: *mut super::super::Foundation::FILETIME,
    pub pChainPara: *mut CERT_REVOCATION_CHAIN_PARA,
    pub pDeltaCrlIndicator: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO")
            .field("cbSize", &self.cbSize)
            .field("iDeltaCrlIndicator", &self.iDeltaCrlIndicator)
            .field("pftCacheResync", &self.pftCacheResync)
            .field("pLastSyncTime", &self.pLastSyncTime)
            .field("pMaxAgeTime", &self.pMaxAgeTime)
            .field("pChainPara", &self.pChainPara)
            .field("pDeltaCrlIndicator", &self.pDeltaCrlIndicator)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.iDeltaCrlIndicator == other.iDeltaCrlIndicator && self.pftCacheResync == other.pftCacheResync && self.pLastSyncTime == other.pLastSyncTime && self.pMaxAgeTime == other.pMaxAgeTime && self.pChainPara == other.pChainPara && self.pDeltaCrlIndicator == other.pDeltaCrlIndicator
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_GET_URL_FLAGS(pub u32);
pub const CRYPT_GET_URL_FROM_PROPERTY: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(1u32);
pub const CRYPT_GET_URL_FROM_EXTENSION: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(2u32);
pub const CRYPT_GET_URL_FROM_UNAUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(4u32);
pub const CRYPT_GET_URL_FROM_AUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(8u32);
impl ::std::convert::From<u32> for CRYPT_GET_URL_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_GET_URL_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_GET_URL_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_GET_URL_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_HASH_ALG_OID_GROUP_ID: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_HASH_INFO {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Hash: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_HASH_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_HASH_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_HASH_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_HASH_INFO").field("HashAlgorithm", &self.HashAlgorithm).field("Hash", &self.Hash).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_HASH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.Hash == other.Hash
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_HASH_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_HASH_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_HASH_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: usize,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_HASH_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_HASH_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_HASH_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_HASH_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgEncodingType", &self.dwMsgEncodingType).field("hCryptProv", &self.hCryptProv).field("HashAlgorithm", &self.HashAlgorithm).field("pvHashAuxInfo", &self.pvHashAuxInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_HASH_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv && self.HashAlgorithm == other.HashAlgorithm && self.pvHashAuxInfo == other.pvHashAuxInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_HASH_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_HASH_MESSAGE_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_HTTP_POST_RETRIEVAL: u32 = 1048576u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_IMAGE_REF {
    pub pszImage: super::super::Foundation::PWSTR,
    pub dwFlags: CRYPT_IMAGE_REF_FLAGS,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_IMAGE_REF {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_IMAGE_REF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_IMAGE_REF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_IMAGE_REF").field("pszImage", &self.pszImage).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_IMAGE_REF {
    fn eq(&self, other: &Self) -> bool {
        self.pszImage == other.pszImage && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_IMAGE_REF {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_IMAGE_REF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_IMAGE_REF_FLAGS(pub u32);
pub const CRYPT_MIN_DEPENDENCIES: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(1u32);
pub const CRYPT_PROCESS_ISOLATE: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(65536u32);
impl ::std::convert::From<u32> for CRYPT_IMAGE_REF_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_IMAGE_REF_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_IMAGE_REG {
    pub pszImage: super::super::Foundation::PWSTR,
    pub cInterfaces: u32,
    pub rgpInterfaces: *mut *mut CRYPT_INTERFACE_REG,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_IMAGE_REG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_IMAGE_REG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_IMAGE_REG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_IMAGE_REG").field("pszImage", &self.pszImage).field("cInterfaces", &self.cInterfaces).field("rgpInterfaces", &self.rgpInterfaces).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_IMAGE_REG {
    fn eq(&self, other: &Self) -> bool {
        self.pszImage == other.pszImage && self.cInterfaces == other.cInterfaces && self.rgpInterfaces == other.rgpInterfaces
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_IMAGE_REG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_IMAGE_REG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPL_HARDWARE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPL_MIXED: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPL_REMOVABLE: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPL_SOFTWARE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPL_UNKNOWN: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_IMPORT_KEY: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_IMPORT_PUBLIC_KEY_FLAGS(pub u32);
pub const CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(2147483648u32);
pub const CRYPT_OID_INFO_PUBKEY_ENCRYPT_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(1073741824u32);
impl ::std::convert::From<u32> for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_INSTALL_OID_FUNC_BEFORE_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_INSTALL_OID_INFO_BEFORE_FLAG: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_INTERFACE_REG {
    pub dwInterface: BCRYPT_INTERFACE,
    pub dwFlags: BCRYPT_TABLE,
    pub cFunctions: u32,
    pub rgpszFunctions: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_INTERFACE_REG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_INTERFACE_REG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_INTERFACE_REG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_INTERFACE_REG").field("dwInterface", &self.dwInterface).field("dwFlags", &self.dwFlags).field("cFunctions", &self.cFunctions).field("rgpszFunctions", &self.rgpszFunctions).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_INTERFACE_REG {
    fn eq(&self, other: &Self) -> bool {
        self.dwInterface == other.dwInterface && self.dwFlags == other.dwFlags && self.cFunctions == other.cFunctions && self.rgpszFunctions == other.rgpszFunctions
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_INTERFACE_REG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_INTERFACE_REG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KDF_OID_GROUP_ID: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KEEP_TIME_VALID: u32 = 128u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KEYID_ALLOC_FLAG: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KEYID_DELETE_FLAG: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KEYID_MACHINE_FLAG: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_KEYID_SET_NEW_FLAG: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_KEY_FLAGS(pub u32);
pub const CRYPT_EXPORTABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CRYPT_USER_PROTECTED: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
pub const CRYPT_ARCHIVABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
pub const CRYPT_CREATE_IV: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
pub const CRYPT_CREATE_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
pub const CRYPT_DATA_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2048u32);
pub const CRYPT_FORCE_KEY_PROTECTION_HIGH: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
pub const CRYPT_KEK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1024u32);
pub const CRYPT_INITIATOR: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_NO_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const CRYPT_ONLINE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
pub const CRYPT_PREGEN: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_RECIPIENT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const CRYPT_SF: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const CRYPT_SGCKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(8192u32);
pub const CRYPT_VOLATILE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
pub const CRYPT_MACHINE_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32u32);
pub const CRYPT_USER_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
pub const PKCS12_PREFER_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const PKCS12_ALWAYS_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
pub const PKCS12_ALLOW_OVERWRITE_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
pub const PKCS12_NO_PERSIST_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
pub const PKCS12_INCLUDE_EXTENDED_PROPERTIES: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const CRYPT_OAEP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_BLOB_VER3: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
pub const CRYPT_DESTROYKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
pub const CRYPT_SSL2_FALLBACK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
pub const CRYPT_Y_ONLY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CRYPT_IPSEC_HMAC_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const CERT_SET_KEY_PROV_HANDLE_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CERT_SET_KEY_CONTEXT_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
impl ::std::convert::From<u32> for CRYPT_KEY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_KEY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_KEY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_KEY_PARAM_ID(pub u32);
pub const KP_ALGID: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(7u32);
pub const KP_CERTIFICATE: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(26u32);
pub const KP_PERMISSIONS: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(6u32);
pub const KP_SALT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(2u32);
pub const KP_SALT_EX: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(10u32);
pub const KP_BLOCKLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(8u32);
pub const KP_GET_USE_COUNT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(42u32);
pub const KP_KEYLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(9u32);
impl ::std::convert::From<u32> for CRYPT_KEY_PARAM_ID {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_PARAM_ID {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_KEY_PARAM_ID {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_KEY_PARAM_ID {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_KEY_PARAM_ID {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_KEY_PARAM_ID {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_KEY_PARAM_ID {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_KEY_PROV_INFO {
    pub pwszContainerName: super::super::Foundation::PWSTR,
    pub pwszProvName: super::super::Foundation::PWSTR,
    pub dwProvType: u32,
    pub dwFlags: CRYPT_KEY_FLAGS,
    pub cProvParam: u32,
    pub rgProvParam: *mut CRYPT_KEY_PROV_PARAM,
    pub dwKeySpec: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_KEY_PROV_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_KEY_PROV_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_KEY_PROV_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_KEY_PROV_INFO")
            .field("pwszContainerName", &self.pwszContainerName)
            .field("pwszProvName", &self.pwszProvName)
            .field("dwProvType", &self.dwProvType)
            .field("dwFlags", &self.dwFlags)
            .field("cProvParam", &self.cProvParam)
            .field("rgProvParam", &self.rgProvParam)
            .field("dwKeySpec", &self.dwKeySpec)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_KEY_PROV_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszContainerName == other.pwszContainerName && self.pwszProvName == other.pwszProvName && self.dwProvType == other.dwProvType && self.dwFlags == other.dwFlags && self.cProvParam == other.cProvParam && self.rgProvParam == other.rgProvParam && self.dwKeySpec == other.dwKeySpec
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_KEY_PROV_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_PROV_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_KEY_PROV_PARAM {
    pub dwParam: u32,
    pub pbData: *mut u8,
    pub cbData: u32,
    pub dwFlags: u32,
}
impl CRYPT_KEY_PROV_PARAM {}
impl ::std::default::Default for CRYPT_KEY_PROV_PARAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_KEY_PROV_PARAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_KEY_PROV_PARAM").field("dwParam", &self.dwParam).field("pbData", &self.pbData).field("cbData", &self.cbData).field("dwFlags", &self.dwFlags).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_KEY_PROV_PARAM {
    fn eq(&self, other: &Self) -> bool {
        self.dwParam == other.dwParam && self.pbData == other.pbData && self.cbData == other.cbData && self.dwFlags == other.dwFlags
    }
}
impl ::std::cmp::Eq for CRYPT_KEY_PROV_PARAM {}
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_PROV_PARAM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_KEY_SIGN_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: CERT_QUERY_ENCODING_TYPE,
    pub Anonymous: CRYPT_KEY_SIGN_MESSAGE_PARA_0,
    pub dwKeySpec: CERT_KEY_SPEC,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut ::std::ffi::c_void,
    pub PubKeyAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_KEY_SIGN_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_KEY_SIGN_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_KEY_SIGN_MESSAGE_PARA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_KEY_SIGN_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_SIGN_MESSAGE_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: usize,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_KEY_SIGN_MESSAGE_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_KEY_VERIFY_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: usize,
}
impl CRYPT_KEY_VERIFY_MESSAGE_PARA {}
impl ::std::default::Default for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_KEY_VERIFY_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgEncodingType", &self.dwMsgEncodingType).field("hCryptProv", &self.hCryptProv).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv
    }
}
impl ::std::cmp::Eq for CRYPT_KEY_VERIFY_MESSAGE_PARA {}
unsafe impl ::windows::runtime::Abi for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LAST_ALG_OID_GROUP_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LAST_OID_GROUP_ID: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LDAP_AREC_EXCLUSIVE_RETRIEVAL: u32 = 262144u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LDAP_INSERT_ENTRY_ATTRIBUTE: u32 = 32768u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LDAP_SCOPE_BASE_ONLY_RETRIEVAL: u32 = 8192u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LDAP_SIGN_RETRIEVAL: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LITTLE_ENDIAN: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_LOCALIZED_NAME_ENCODING_TYPE: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MAC: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MACHINE_DEFAULT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_MASK_GEN_ALGORITHM {
    pub pszObjId: super::super::Foundation::PSTR,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_MASK_GEN_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_MASK_GEN_ALGORITHM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_MASK_GEN_ALGORITHM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_MASK_GEN_ALGORITHM").field("pszObjId", &self.pszObjId).field("HashAlgorithm", &self.HashAlgorithm).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_MASK_GEN_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.HashAlgorithm == other.HashAlgorithm
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_MASK_GEN_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_MASK_GEN_ALGORITHM {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MATCH_ANY_ENCODING_TYPE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MESSAGE_BARE_CONTENT_OUT_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MESSAGE_ENCAPSULATED_CONTENT_OUT_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MESSAGE_KEYID_RECIPIENT_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MESSAGE_KEYID_SIGNER_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MESSAGE_SILENT_KEYSET_FLAG: u32 = 64u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CBC: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CBCI: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CBCOFM: u32 = 9u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CBCOFMI: u32 = 10u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CFB: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CFBP: u32 = 7u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_CTS: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_ECB: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_OFB: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_MODE_OFBP: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_MSG_TYPE(pub u32);
pub const CMSG_DATA: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(1u32);
pub const CMSG_SIGNED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(2u32);
pub const CMSG_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(3u32);
pub const CMSG_SIGNED_AND_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(4u32);
pub const CMSG_HASHED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(5u32);
impl ::std::convert::From<u32> for CRYPT_MSG_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_MSG_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_MSG_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_MSG_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_MSG_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_MSG_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_MSG_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NDR_ENCODING: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NEWKEYSET: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NEXT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NOHASHOID: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NOT_MODIFIED_RETRIEVAL: u32 = 4194304u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NO_AUTH_RETRIEVAL: u32 = 131072u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_NO_OCSP_FAILOVER_TO_CRL_RETRIEVAL: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OBJECT_LOCATOR_FIRST_RESERVED_USER_NAME_TYPE: u32 = 33u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_NAME_TYPE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_USER_NAME_TYPE: u32 = 65535u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    pub cbSize: u32,
    pub pfnGet: ::std::option::Option<PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_GET>,
    pub pfnRelease: ::std::option::Option<PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_RELEASE>,
    pub pfnFreePassword: ::std::option::Option<PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE_PASSWORD>,
    pub pfnFree: ::std::option::Option<PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE>,
    pub pfnFreeIdentifier: ::std::option::Option<PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE_IDENTIFIER>,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE").field("cbSize", &self.cbSize).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pfnGet.map(|f| f as usize) == other.pfnGet.map(|f| f as usize) && self.pfnRelease.map(|f| f as usize) == other.pfnRelease.map(|f| f as usize) && self.pfnFreePassword.map(|f| f as usize) == other.pfnFreePassword.map(|f| f as usize) && self.pfnFree.map(|f| f as usize) == other.pfnFree.map(|f| f as usize) && self.pfnFreeIdentifier.map(|f| f as usize) == other.pfnFreeIdentifier.map(|f| f as usize)
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_OBJECT_LOCATOR_RELEASE_REASON(pub u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SYSTEM_SHUTDOWN: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(1u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SERVICE_STOP: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(2u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_PROCESS_EXIT: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(3u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_DLL_UNLOAD: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(4u32);
impl ::std::convert::From<u32> for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OBJECT_LOCATOR_SPN_NAME_TYPE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_OBJID_TABLE {
    pub dwAlgId: u32,
    pub pszObjId: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_OBJID_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_OBJID_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_OBJID_TABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_OBJID_TABLE").field("dwAlgId", &self.dwAlgId).field("pszObjId", &self.pszObjId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_OBJID_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.dwAlgId == other.dwAlgId && self.pszObjId == other.pszObjId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_OBJID_TABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_OBJID_TABLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OCSP_ONLY_RETRIEVAL: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OFFLINE_CHECK_RETRIEVAL: u32 = 16384u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_DISABLE_SEARCH_DS_FLAG: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_OID_FUNC_ENTRY {
    pub pszOID: super::super::Foundation::PSTR,
    pub pvFuncAddr: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_OID_FUNC_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_OID_FUNC_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_OID_FUNC_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_OID_FUNC_ENTRY").field("pszOID", &self.pszOID).field("pvFuncAddr", &self.pvFuncAddr).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_OID_FUNC_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.pszOID == other.pszOID && self.pvFuncAddr == other.pvFuncAddr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_OID_FUNC_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_OID_FUNC_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_OID_INFO {
    pub cbSize: u32,
    pub pszOID: super::super::Foundation::PSTR,
    pub pwszName: super::super::Foundation::PWSTR,
    pub dwGroupId: u32,
    pub Anonymous: CRYPT_OID_INFO_0,
    pub ExtraInfo: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_OID_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_OID_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_OID_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_OID_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_OID_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPT_OID_INFO_0 {
    pub dwValue: u32,
    pub Algid: u32,
    pub dwLength: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_OID_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_OID_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_OID_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_OID_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_OID_INFO_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_ALGID_KEY: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_CNG_ALGID_KEY: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_CNG_SIGN_KEY: u32 = 6u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_NAME_KEY: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_MASK: u32 = 268369920u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_SHIFT: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_OID_KEY: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_OID_KEY_FLAGS_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INFO_SIGN_KEY: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_PREFER_CNG_ALGID_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_PUBKEY_ENCRYPT_ONLY_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_PUBKEY_SIGN_ONLY_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_USE_CURVE_NAME_FOR_ENCODE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_USE_CURVE_PARAMETERS_FOR_ENCODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OVERWRITE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_OWF_REPL_LM_HASH: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PASSWORD_CREDENTIALSA {
    pub cbSize: u32,
    pub pszUsername: super::super::Foundation::PSTR,
    pub pszPassword: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PASSWORD_CREDENTIALSA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PASSWORD_CREDENTIALSA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PASSWORD_CREDENTIALSA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PASSWORD_CREDENTIALSA").field("cbSize", &self.cbSize).field("pszUsername", &self.pszUsername).field("pszPassword", &self.pszPassword).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PASSWORD_CREDENTIALSA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszUsername == other.pszUsername && self.pszPassword == other.pszPassword
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PASSWORD_CREDENTIALSA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PASSWORD_CREDENTIALSA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PASSWORD_CREDENTIALSW {
    pub cbSize: u32,
    pub pszUsername: super::super::Foundation::PWSTR,
    pub pszPassword: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PASSWORD_CREDENTIALSW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PASSWORD_CREDENTIALSW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PASSWORD_CREDENTIALSW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PASSWORD_CREDENTIALSW").field("cbSize", &self.cbSize).field("pszUsername", &self.pszUsername).field("pszPassword", &self.pszPassword).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PASSWORD_CREDENTIALSW {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszUsername == other.pszUsername && self.pszPassword == other.pszPassword
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PASSWORD_CREDENTIALSW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PASSWORD_CREDENTIALSW {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_PKCS12_PBE_PARAMS {
    pub iIterations: i32,
    pub cbSalt: u32,
}
impl CRYPT_PKCS12_PBE_PARAMS {}
impl ::std::default::Default for CRYPT_PKCS12_PBE_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_PKCS12_PBE_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PKCS12_PBE_PARAMS").field("iIterations", &self.iIterations).field("cbSalt", &self.cbSalt).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_PKCS12_PBE_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.iIterations == other.iIterations && self.cbSalt == other.cbSalt
    }
}
impl ::std::cmp::Eq for CRYPT_PKCS12_PBE_PARAMS {}
unsafe impl ::windows::runtime::Abi for CRYPT_PKCS12_PBE_PARAMS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PKCS8_EXPORT_PARAMS {
    pub hCryptProv: usize,
    pub dwKeySpec: u32,
    pub pszPrivateKeyObjId: super::super::Foundation::PSTR,
    pub pEncryptPrivateKeyFunc: ::std::option::Option<PCRYPT_ENCRYPT_PRIVATE_KEY_FUNC>,
    pub pVoidEncryptFunc: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PKCS8_EXPORT_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PKCS8_EXPORT_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PKCS8_EXPORT_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PKCS8_EXPORT_PARAMS").field("hCryptProv", &self.hCryptProv).field("dwKeySpec", &self.dwKeySpec).field("pszPrivateKeyObjId", &self.pszPrivateKeyObjId).field("pVoidEncryptFunc", &self.pVoidEncryptFunc).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PKCS8_EXPORT_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.hCryptProv == other.hCryptProv && self.dwKeySpec == other.dwKeySpec && self.pszPrivateKeyObjId == other.pszPrivateKeyObjId && self.pEncryptPrivateKeyFunc.map(|f| f as usize) == other.pEncryptPrivateKeyFunc.map(|f| f as usize) && self.pVoidEncryptFunc == other.pVoidEncryptFunc
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PKCS8_EXPORT_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PKCS8_EXPORT_PARAMS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PKCS8_IMPORT_PARAMS {
    pub PrivateKey: CRYPTOAPI_BLOB,
    pub pResolvehCryptProvFunc: ::std::option::Option<PCRYPT_RESOLVE_HCRYPTPROV_FUNC>,
    pub pVoidResolveFunc: *mut ::std::ffi::c_void,
    pub pDecryptPrivateKeyFunc: ::std::option::Option<PCRYPT_DECRYPT_PRIVATE_KEY_FUNC>,
    pub pVoidDecryptFunc: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PKCS8_IMPORT_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PKCS8_IMPORT_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PKCS8_IMPORT_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PKCS8_IMPORT_PARAMS").field("PrivateKey", &self.PrivateKey).field("pVoidResolveFunc", &self.pVoidResolveFunc).field("pVoidDecryptFunc", &self.pVoidDecryptFunc).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PKCS8_IMPORT_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.PrivateKey == other.PrivateKey && self.pResolvehCryptProvFunc.map(|f| f as usize) == other.pResolvehCryptProvFunc.map(|f| f as usize) && self.pVoidResolveFunc == other.pVoidResolveFunc && self.pDecryptPrivateKeyFunc.map(|f| f as usize) == other.pDecryptPrivateKeyFunc.map(|f| f as usize) && self.pVoidDecryptFunc == other.pVoidDecryptFunc
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PKCS8_IMPORT_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PKCS8_IMPORT_PARAMS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_POLICY_OID_GROUP_ID: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_PRIORITY_BOTTOM: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_PRIORITY_TOP: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PRIVATE_KEY_INFO {
    pub Version: u32,
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub PrivateKey: CRYPTOAPI_BLOB,
    pub pAttributes: *mut CRYPT_ATTRIBUTES,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PRIVATE_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PRIVATE_KEY_INFO").field("Version", &self.Version).field("Algorithm", &self.Algorithm).field("PrivateKey", &self.PrivateKey).field("pAttributes", &self.pAttributes).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Algorithm == other.Algorithm && self.PrivateKey == other.PrivateKey && self.pAttributes == other.pAttributes
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PRIVATE_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PRIVATE_KEY_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PROPERTY_REF {
    pub pszProperty: super::super::Foundation::PWSTR,
    pub cbValue: u32,
    pub pbValue: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PROPERTY_REF {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PROPERTY_REF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PROPERTY_REF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PROPERTY_REF").field("pszProperty", &self.pszProperty).field("cbValue", &self.cbValue).field("pbValue", &self.pbValue).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PROPERTY_REF {
    fn eq(&self, other: &Self) -> bool {
        self.pszProperty == other.pszProperty && self.cbValue == other.cbValue && self.pbValue == other.pbValue
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PROPERTY_REF {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PROPERTY_REF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PROVIDERS {
    pub cProviders: u32,
    pub rgpszProviders: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PROVIDERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PROVIDERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PROVIDERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PROVIDERS").field("cProviders", &self.cProviders).field("rgpszProviders", &self.rgpszProviders).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PROVIDERS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpszProviders == other.rgpszProviders
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PROVIDERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PROVIDERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PROVIDER_REF {
    pub dwInterface: u32,
    pub pszFunction: super::super::Foundation::PWSTR,
    pub pszProvider: super::super::Foundation::PWSTR,
    pub cProperties: u32,
    pub rgpProperties: *mut *mut CRYPT_PROPERTY_REF,
    pub pUM: *mut CRYPT_IMAGE_REF,
    pub pKM: *mut CRYPT_IMAGE_REF,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PROVIDER_REF {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PROVIDER_REF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PROVIDER_REF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PROVIDER_REF").field("dwInterface", &self.dwInterface).field("pszFunction", &self.pszFunction).field("pszProvider", &self.pszProvider).field("cProperties", &self.cProperties).field("rgpProperties", &self.rgpProperties).field("pUM", &self.pUM).field("pKM", &self.pKM).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PROVIDER_REF {
    fn eq(&self, other: &Self) -> bool {
        self.dwInterface == other.dwInterface && self.pszFunction == other.pszFunction && self.pszProvider == other.pszProvider && self.cProperties == other.cProperties && self.rgpProperties == other.rgpProperties && self.pUM == other.pUM && self.pKM == other.pKM
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PROVIDER_REF {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PROVIDER_REF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PROVIDER_REFS {
    pub cProviders: u32,
    pub rgpProviders: *mut *mut CRYPT_PROVIDER_REF,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PROVIDER_REFS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PROVIDER_REFS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PROVIDER_REFS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PROVIDER_REFS").field("cProviders", &self.cProviders).field("rgpProviders", &self.rgpProviders).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PROVIDER_REFS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpProviders == other.rgpProviders
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PROVIDER_REFS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PROVIDER_REFS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PROVIDER_REG {
    pub cAliases: u32,
    pub rgpszAliases: *mut super::super::Foundation::PWSTR,
    pub pUM: *mut CRYPT_IMAGE_REG,
    pub pKM: *mut CRYPT_IMAGE_REG,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PROVIDER_REG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PROVIDER_REG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PROVIDER_REG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PROVIDER_REG").field("cAliases", &self.cAliases).field("rgpszAliases", &self.rgpszAliases).field("pUM", &self.pUM).field("pKM", &self.pKM).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PROVIDER_REG {
    fn eq(&self, other: &Self) -> bool {
        self.cAliases == other.cAliases && self.rgpszAliases == other.rgpszAliases && self.pUM == other.pUM && self.pKM == other.pKM
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PROVIDER_REG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PROVIDER_REG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_PROXY_CACHE_RETRIEVAL: u32 = 2097152u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_PSOURCE_ALGORITHM {
    pub pszObjId: super::super::Foundation::PSTR,
    pub EncodingParameters: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_PSOURCE_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_PSOURCE_ALGORITHM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_PSOURCE_ALGORITHM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_PSOURCE_ALGORITHM").field("pszObjId", &self.pszObjId).field("EncodingParameters", &self.EncodingParameters).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_PSOURCE_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.EncodingParameters == other.EncodingParameters
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_PSOURCE_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_PSOURCE_ALGORITHM {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_PSTORE: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_PUBKEY_ALG_OID_GROUP_ID: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RANDOM_QUERY_STRING_RETRIEVAL: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RC2_128BIT_VERSION: u32 = 58u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RC2_40BIT_VERSION: u32 = 160u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RC2_56BIT_VERSION: u32 = 52u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RC2_64BIT_VERSION: u32 = 120u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_RC2_CBC_PARAMETERS {
    pub dwVersion: u32,
    pub fIV: super::super::Foundation::BOOL,
    pub rgbIV: [u8; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_RC2_CBC_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_RC2_CBC_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_RC2_CBC_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_RC2_CBC_PARAMETERS").field("dwVersion", &self.dwVersion).field("fIV", &self.fIV).field("rgbIV", &self.rgbIV).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_RC2_CBC_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.fIV == other.fIV && self.rgbIV == other.rgbIV
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_RC2_CBC_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_RC2_CBC_PARAMETERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_RC4_KEY_STATE {
    pub Key: [u8; 16],
    pub SBox: [u8; 256],
    pub i: u8,
    pub j: u8,
}
impl CRYPT_RC4_KEY_STATE {}
impl ::std::default::Default for CRYPT_RC4_KEY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_RC4_KEY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_RC4_KEY_STATE").field("Key", &self.Key).field("SBox", &self.SBox).field("i", &self.i).field("j", &self.j).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_RC4_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.SBox == other.SBox && self.i == other.i && self.j == other.j
    }
}
impl ::std::cmp::Eq for CRYPT_RC4_KEY_STATE {}
unsafe impl ::windows::runtime::Abi for CRYPT_RC4_KEY_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RDN_ATTR_OID_GROUP_ID: u32 = 5u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_READ: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_REGISTER_FIRST_INDEX: u32 = 0u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_REGISTER_LAST_INDEX: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_RETRIEVE_AUX_INFO {
    pub cbSize: u32,
    pub pLastSyncTime: *mut super::super::Foundation::FILETIME,
    pub dwMaxUrlRetrievalByteCount: u32,
    pub pPreFetchInfo: *mut CRYPTNET_URL_CACHE_PRE_FETCH_INFO,
    pub pFlushInfo: *mut CRYPTNET_URL_CACHE_FLUSH_INFO,
    pub ppResponseInfo: *mut *mut CRYPTNET_URL_CACHE_RESPONSE_INFO,
    pub pwszCacheFileNamePrefix: super::super::Foundation::PWSTR,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub fProxyCacheRetrieval: super::super::Foundation::BOOL,
    pub dwHttpStatusCode: u32,
    pub ppwszErrorResponseHeaders: *mut super::super::Foundation::PWSTR,
    pub ppErrorContentBlob: *mut *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_RETRIEVE_AUX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_RETRIEVE_AUX_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_RETRIEVE_AUX_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_RETRIEVE_AUX_INFO")
            .field("cbSize", &self.cbSize)
            .field("pLastSyncTime", &self.pLastSyncTime)
            .field("dwMaxUrlRetrievalByteCount", &self.dwMaxUrlRetrievalByteCount)
            .field("pPreFetchInfo", &self.pPreFetchInfo)
            .field("pFlushInfo", &self.pFlushInfo)
            .field("ppResponseInfo", &self.ppResponseInfo)
            .field("pwszCacheFileNamePrefix", &self.pwszCacheFileNamePrefix)
            .field("pftCacheResync", &self.pftCacheResync)
            .field("fProxyCacheRetrieval", &self.fProxyCacheRetrieval)
            .field("dwHttpStatusCode", &self.dwHttpStatusCode)
            .field("ppwszErrorResponseHeaders", &self.ppwszErrorResponseHeaders)
            .field("ppErrorContentBlob", &self.ppErrorContentBlob)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_RETRIEVE_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.pLastSyncTime == other.pLastSyncTime
            && self.dwMaxUrlRetrievalByteCount == other.dwMaxUrlRetrievalByteCount
            && self.pPreFetchInfo == other.pPreFetchInfo
            && self.pFlushInfo == other.pFlushInfo
            && self.ppResponseInfo == other.ppResponseInfo
            && self.pwszCacheFileNamePrefix == other.pwszCacheFileNamePrefix
            && self.pftCacheResync == other.pftCacheResync
            && self.fProxyCacheRetrieval == other.fProxyCacheRetrieval
            && self.dwHttpStatusCode == other.dwHttpStatusCode
            && self.ppwszErrorResponseHeaders == other.ppwszErrorResponseHeaders
            && self.ppErrorContentBlob == other.ppErrorContentBlob
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_RETRIEVE_AUX_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_RETRIEVE_AUX_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RETRIEVE_MAX_ERROR_CONTENT_LENGTH: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_RETRIEVE_MULTIPLE_OBJECTS: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_RSAES_OAEP_PARAMETERS {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub MaskGenAlgorithm: CRYPT_MASK_GEN_ALGORITHM,
    pub PSourceAlgorithm: CRYPT_PSOURCE_ALGORITHM,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_RSAES_OAEP_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_RSAES_OAEP_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_RSAES_OAEP_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_RSAES_OAEP_PARAMETERS").field("HashAlgorithm", &self.HashAlgorithm).field("MaskGenAlgorithm", &self.MaskGenAlgorithm).field("PSourceAlgorithm", &self.PSourceAlgorithm).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_RSAES_OAEP_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.MaskGenAlgorithm == other.MaskGenAlgorithm && self.PSourceAlgorithm == other.PSourceAlgorithm
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_RSAES_OAEP_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_RSAES_OAEP_PARAMETERS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_RSA_SSA_PSS_PARAMETERS {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub MaskGenAlgorithm: CRYPT_MASK_GEN_ALGORITHM,
    pub dwSaltLength: u32,
    pub dwTrailerField: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_RSA_SSA_PSS_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_RSA_SSA_PSS_PARAMETERS").field("HashAlgorithm", &self.HashAlgorithm).field("MaskGenAlgorithm", &self.MaskGenAlgorithm).field("dwSaltLength", &self.dwSaltLength).field("dwTrailerField", &self.dwTrailerField).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.MaskGenAlgorithm == other.MaskGenAlgorithm && self.dwSaltLength == other.dwSaltLength && self.dwTrailerField == other.dwTrailerField
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_RSA_SSA_PSS_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_RSA_SSA_PSS_PARAMETERS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SECRETDIGEST: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SEC_DESCR: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_SEQUENCE_OF_ANY {
    pub cValue: u32,
    pub rgValue: *mut CRYPTOAPI_BLOB,
}
impl CRYPT_SEQUENCE_OF_ANY {}
impl ::std::default::Default for CRYPT_SEQUENCE_OF_ANY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_SEQUENCE_OF_ANY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_SEQUENCE_OF_ANY").field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_SEQUENCE_OF_ANY {
    fn eq(&self, other: &Self) -> bool {
        self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
impl ::std::cmp::Eq for CRYPT_SEQUENCE_OF_ANY {}
unsafe impl ::windows::runtime::Abi for CRYPT_SEQUENCE_OF_ANY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SERVER: u32 = 1024u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_SET_HASH_PARAM(pub u32);
pub const HP_HMAC_INFO: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(5u32);
pub const HP_HASHVAL: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(2u32);
impl ::std::convert::From<u32> for CRYPT_SET_HASH_PARAM {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_SET_HASH_PARAM {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_SET_HASH_PARAM {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_SET_HASH_PARAM {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_SET_HASH_PARAM {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_SET_HASH_PARAM {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_SET_HASH_PARAM {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_SET_PROV_PARAM_ID(pub u32);
pub const PP_CLIENT_HWND: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(1u32);
pub const PP_DELETEKEY: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(24u32);
pub const PP_KEYEXCHANGE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(14u32);
pub const PP_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(32u32);
pub const PP_KEYEXCHANGE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(12u32);
pub const PP_KEYSET_SEC_DESCR: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(8u32);
pub const PP_PIN_PROMPT_STRING: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(44u32);
pub const PP_ROOT_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(46u32);
pub const PP_SIGNATURE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(15u32);
pub const PP_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(33u32);
pub const PP_SIGNATURE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(13u32);
pub const PP_UI_PROMPT: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(21u32);
pub const PP_USE_HARDWARE_RNG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(38u32);
pub const PP_USER_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(42u32);
pub const PP_SECURE_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(47u32);
pub const PP_SECURE_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(48u32);
pub const PP_SMARTCARD_READER: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(43u32);
impl ::std::convert::From<u32> for CRYPT_SET_PROV_PARAM_ID {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_SET_PROV_PARAM_ID {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_SET_PROV_PARAM_ID {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_SET_PROV_PARAM_ID {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_SET_PROV_PARAM_ID {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_SET_PROV_PARAM_ID {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_SET_PROV_PARAM_ID {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SGC: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SGC_ENUM: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SIGN_ALG_OID_GROUP_ID: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_SIGN_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub pSigningCert: *mut CERT_CONTEXT,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut ::std::ffi::c_void,
    pub cMsgCert: u32,
    pub rgpMsgCert: *mut *mut CERT_CONTEXT,
    pub cMsgCrl: u32,
    pub rgpMsgCrl: *mut *mut CRL_CONTEXT,
    pub cAuthAttr: u32,
    pub rgAuthAttr: *mut CRYPT_ATTRIBUTE,
    pub cUnauthAttr: u32,
    pub rgUnauthAttr: *mut CRYPT_ATTRIBUTE,
    pub dwFlags: u32,
    pub dwInnerContentType: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_SIGN_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_SIGN_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_SIGN_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_SIGN_MESSAGE_PARA")
            .field("cbSize", &self.cbSize)
            .field("dwMsgEncodingType", &self.dwMsgEncodingType)
            .field("pSigningCert", &self.pSigningCert)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("pvHashAuxInfo", &self.pvHashAuxInfo)
            .field("cMsgCert", &self.cMsgCert)
            .field("rgpMsgCert", &self.rgpMsgCert)
            .field("cMsgCrl", &self.cMsgCrl)
            .field("rgpMsgCrl", &self.rgpMsgCrl)
            .field("cAuthAttr", &self.cAuthAttr)
            .field("rgAuthAttr", &self.rgAuthAttr)
            .field("cUnauthAttr", &self.cUnauthAttr)
            .field("rgUnauthAttr", &self.rgUnauthAttr)
            .field("dwFlags", &self.dwFlags)
            .field("dwInnerContentType", &self.dwInnerContentType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_SIGN_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwMsgEncodingType == other.dwMsgEncodingType
            && self.pSigningCert == other.pSigningCert
            && self.HashAlgorithm == other.HashAlgorithm
            && self.pvHashAuxInfo == other.pvHashAuxInfo
            && self.cMsgCert == other.cMsgCert
            && self.rgpMsgCert == other.rgpMsgCert
            && self.cMsgCrl == other.cMsgCrl
            && self.rgpMsgCrl == other.rgpMsgCrl
            && self.cAuthAttr == other.cAuthAttr
            && self.rgAuthAttr == other.rgAuthAttr
            && self.cUnauthAttr == other.cUnauthAttr
            && self.rgUnauthAttr == other.rgUnauthAttr
            && self.dwFlags == other.dwFlags
            && self.dwInnerContentType == other.dwInnerContentType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_SIGN_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_SIGN_MESSAGE_PARA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SILENT: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_SMART_CARD_ROOT_INFO {
    pub rgbCardID: [u8; 16],
    pub luid: ROOT_INFO_LUID,
}
impl CRYPT_SMART_CARD_ROOT_INFO {}
impl ::std::default::Default for CRYPT_SMART_CARD_ROOT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_SMART_CARD_ROOT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_SMART_CARD_ROOT_INFO").field("rgbCardID", &self.rgbCardID).field("luid", &self.luid).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_SMART_CARD_ROOT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.rgbCardID == other.rgbCardID && self.luid == other.luid
    }
}
impl ::std::cmp::Eq for CRYPT_SMART_CARD_ROOT_INFO {}
unsafe impl ::windows::runtime::Abi for CRYPT_SMART_CARD_ROOT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_SMIME_CAPABILITIES {
    pub cCapability: u32,
    pub rgCapability: *mut CRYPT_SMIME_CAPABILITY,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_SMIME_CAPABILITIES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_SMIME_CAPABILITIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_SMIME_CAPABILITIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_SMIME_CAPABILITIES").field("cCapability", &self.cCapability).field("rgCapability", &self.rgCapability).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_SMIME_CAPABILITIES {
    fn eq(&self, other: &Self) -> bool {
        self.cCapability == other.cCapability && self.rgCapability == other.rgCapability
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_SMIME_CAPABILITIES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_SMIME_CAPABILITIES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_SMIME_CAPABILITY {
    pub pszObjId: super::super::Foundation::PSTR,
    pub Parameters: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_SMIME_CAPABILITY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_SMIME_CAPABILITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_SMIME_CAPABILITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_SMIME_CAPABILITY").field("pszObjId", &self.pszObjId).field("Parameters", &self.Parameters).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_SMIME_CAPABILITY {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Parameters == other.Parameters
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_SMIME_CAPABILITY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_SMIME_CAPABILITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SORTED_CTL_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 65536u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STICKY_CACHE_RETRIEVAL: u32 = 4096u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_STRING(pub u32);
pub const CRYPT_STRING_BASE64HEADER: CRYPT_STRING = CRYPT_STRING(0u32);
pub const CRYPT_STRING_BASE64: CRYPT_STRING = CRYPT_STRING(1u32);
pub const CRYPT_STRING_BINARY: CRYPT_STRING = CRYPT_STRING(2u32);
pub const CRYPT_STRING_BASE64REQUESTHEADER: CRYPT_STRING = CRYPT_STRING(3u32);
pub const CRYPT_STRING_HEX: CRYPT_STRING = CRYPT_STRING(4u32);
pub const CRYPT_STRING_HEXASCII: CRYPT_STRING = CRYPT_STRING(5u32);
pub const CRYPT_STRING_BASE64X509CRLHEADER: CRYPT_STRING = CRYPT_STRING(9u32);
pub const CRYPT_STRING_HEXADDR: CRYPT_STRING = CRYPT_STRING(10u32);
pub const CRYPT_STRING_HEXASCIIADDR: CRYPT_STRING = CRYPT_STRING(11u32);
pub const CRYPT_STRING_HEXRAW: CRYPT_STRING = CRYPT_STRING(12u32);
pub const CRYPT_STRING_STRICT: CRYPT_STRING = CRYPT_STRING(536870912u32);
pub const CRYPT_STRING_BASE64_ANY: CRYPT_STRING = CRYPT_STRING(6u32);
pub const CRYPT_STRING_ANY: CRYPT_STRING = CRYPT_STRING(7u32);
pub const CRYPT_STRING_HEX_ANY: CRYPT_STRING = CRYPT_STRING(8u32);
impl ::std::convert::From<u32> for CRYPT_STRING {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_STRING {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_STRING {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_STRING {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_STRING {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_STRING {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_STRING {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_BASE64URI: u32 = 13u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_ENCODEMASK: u32 = 255u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_HASHDATA: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_NOCR: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_NOCRLF: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_PERCENTESCAPE: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_RESERVED100: u32 = 256u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_STRING_RESERVED200: u32 = 512u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_SUCCEED: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_TEMPLATE_OID_GROUP_ID: u32 = 9u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_TIMESTAMP_ACCURACY {
    pub dwSeconds: u32,
    pub dwMillis: u32,
    pub dwMicros: u32,
}
impl CRYPT_TIMESTAMP_ACCURACY {}
impl ::std::default::Default for CRYPT_TIMESTAMP_ACCURACY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_ACCURACY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_ACCURACY").field("dwSeconds", &self.dwSeconds).field("dwMillis", &self.dwMillis).field("dwMicros", &self.dwMicros).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_ACCURACY {
    fn eq(&self, other: &Self) -> bool {
        self.dwSeconds == other.dwSeconds && self.dwMillis == other.dwMillis && self.dwMicros == other.dwMicros
    }
}
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_ACCURACY {}
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_ACCURACY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIMESTAMP_CONTEXT {
    pub cbEncoded: u32,
    pub pbEncoded: *mut u8,
    pub pTimeStamp: *mut CRYPT_TIMESTAMP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIMESTAMP_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIMESTAMP_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_CONTEXT").field("cbEncoded", &self.cbEncoded).field("pbEncoded", &self.pbEncoded).field("pTimeStamp", &self.pTimeStamp).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbEncoded == other.cbEncoded && self.pbEncoded == other.pbEncoded && self.pTimeStamp == other.pTimeStamp
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIMESTAMP_INFO {
    pub dwVersion: u32,
    pub pszTSAPolicyId: super::super::Foundation::PSTR,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashedMessage: CRYPTOAPI_BLOB,
    pub SerialNumber: CRYPTOAPI_BLOB,
    pub ftTime: super::super::Foundation::FILETIME,
    pub pvAccuracy: *mut CRYPT_TIMESTAMP_ACCURACY,
    pub fOrdering: super::super::Foundation::BOOL,
    pub Nonce: CRYPTOAPI_BLOB,
    pub Tsa: CRYPTOAPI_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIMESTAMP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIMESTAMP_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("pszTSAPolicyId", &self.pszTSAPolicyId)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("HashedMessage", &self.HashedMessage)
            .field("SerialNumber", &self.SerialNumber)
            .field("ftTime", &self.ftTime)
            .field("pvAccuracy", &self.pvAccuracy)
            .field("fOrdering", &self.fOrdering)
            .field("Nonce", &self.Nonce)
            .field("Tsa", &self.Tsa)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.pszTSAPolicyId == other.pszTSAPolicyId && self.HashAlgorithm == other.HashAlgorithm && self.HashedMessage == other.HashedMessage && self.SerialNumber == other.SerialNumber && self.ftTime == other.ftTime && self.pvAccuracy == other.pvAccuracy && self.fOrdering == other.fOrdering && self.Nonce == other.Nonce && self.Tsa == other.Tsa && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIMESTAMP_PARA {
    pub pszTSAPolicyId: super::super::Foundation::PSTR,
    pub fRequestCerts: super::super::Foundation::BOOL,
    pub Nonce: CRYPTOAPI_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIMESTAMP_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIMESTAMP_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_PARA").field("pszTSAPolicyId", &self.pszTSAPolicyId).field("fRequestCerts", &self.fRequestCerts).field("Nonce", &self.Nonce).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pszTSAPolicyId == other.pszTSAPolicyId && self.fRequestCerts == other.fRequestCerts && self.Nonce == other.Nonce && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIMESTAMP_REQUEST {
    pub dwVersion: CRYPT_TIMESTAMP_VERSION,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashedMessage: CRYPTOAPI_BLOB,
    pub pszTSAPolicyId: super::super::Foundation::PSTR,
    pub Nonce: CRYPTOAPI_BLOB,
    pub fCertReq: super::super::Foundation::BOOL,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIMESTAMP_REQUEST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIMESTAMP_REQUEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_REQUEST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_REQUEST")
            .field("dwVersion", &self.dwVersion)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("HashedMessage", &self.HashedMessage)
            .field("pszTSAPolicyId", &self.pszTSAPolicyId)
            .field("Nonce", &self.Nonce)
            .field("fCertReq", &self.fCertReq)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.HashAlgorithm == other.HashAlgorithm && self.HashedMessage == other.HashedMessage && self.pszTSAPolicyId == other.pszTSAPolicyId && self.Nonce == other.Nonce && self.fCertReq == other.fCertReq && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_REQUEST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_REQUEST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIMESTAMP_RESPONSE {
    pub dwStatus: CRYPT_TIMESTAMP_RESPONSE_STATUS,
    pub cFreeText: u32,
    pub rgFreeText: *mut super::super::Foundation::PWSTR,
    pub FailureInfo: CRYPT_BIT_BLOB,
    pub ContentInfo: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIMESTAMP_RESPONSE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIMESTAMP_RESPONSE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIMESTAMP_RESPONSE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIMESTAMP_RESPONSE").field("dwStatus", &self.dwStatus).field("cFreeText", &self.cFreeText).field("rgFreeText", &self.rgFreeText).field("FailureInfo", &self.FailureInfo).field("ContentInfo", &self.ContentInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIMESTAMP_RESPONSE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStatus == other.dwStatus && self.cFreeText == other.cFreeText && self.rgFreeText == other.rgFreeText && self.FailureInfo == other.FailureInfo && self.ContentInfo == other.ContentInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIMESTAMP_RESPONSE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_RESPONSE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_TIMESTAMP_RESPONSE_STATUS(pub u32);
pub const TIMESTAMP_STATUS_GRANTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(0u32);
pub const TIMESTAMP_STATUS_GRANTED_WITH_MODS: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(1u32);
pub const TIMESTAMP_STATUS_REJECTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(2u32);
pub const TIMESTAMP_STATUS_WAITING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(3u32);
pub const TIMESTAMP_STATUS_REVOCATION_WARNING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(4u32);
pub const TIMESTAMP_STATUS_REVOKED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(5u32);
impl ::std::convert::From<u32> for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_TIMESTAMP_VERSION(pub u32);
pub const TIMESTAMP_VERSION: CRYPT_TIMESTAMP_VERSION = CRYPT_TIMESTAMP_VERSION(1u32);
impl ::std::convert::From<u32> for CRYPT_TIMESTAMP_VERSION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_TIMESTAMP_VERSION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_TIMESTAMP_VERSION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_TIMESTAMP_VERSION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_TIMESTAMP_VERSION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_TIMESTAMP_VERSION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_TIMESTAMP_VERSION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_TIME_STAMP_REQUEST_INFO {
    pub pszTimeStampAlgorithm: super::super::Foundation::PSTR,
    pub pszContentType: super::super::Foundation::PSTR,
    pub Content: CRYPTOAPI_BLOB,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_TIME_STAMP_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_TIME_STAMP_REQUEST_INFO").field("pszTimeStampAlgorithm", &self.pszTimeStampAlgorithm).field("pszContentType", &self.pszContentType).field("Content", &self.Content).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszTimeStampAlgorithm == other.pszTimeStampAlgorithm && self.pszContentType == other.pszContentType && self.Content == other.Content && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_TIME_STAMP_REQUEST_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_TIME_STAMP_REQUEST_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_TYPE2_FORMAT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_UI_PROMPT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_UNICODE_NAME_DECODE_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_UNICODE_NAME_ENCODE_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_UPDATE_KEY: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_URL_ARRAY {
    pub cUrl: u32,
    pub rgwszUrl: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_URL_ARRAY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_URL_ARRAY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_URL_ARRAY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_URL_ARRAY").field("cUrl", &self.cUrl).field("rgwszUrl", &self.rgwszUrl).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_URL_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.cUrl == other.cUrl && self.rgwszUrl == other.rgwszUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_URL_ARRAY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_URL_ARRAY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_URL_INFO {
    pub cbSize: u32,
    pub dwSyncDeltaTime: u32,
    pub cGroup: u32,
    pub rgcGroupEntry: *mut u32,
}
impl CRYPT_URL_INFO {}
impl ::std::default::Default for CRYPT_URL_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_URL_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_URL_INFO").field("cbSize", &self.cbSize).field("dwSyncDeltaTime", &self.dwSyncDeltaTime).field("cGroup", &self.cGroup).field("rgcGroupEntry", &self.rgcGroupEntry).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_URL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSyncDeltaTime == other.dwSyncDeltaTime && self.cGroup == other.cGroup && self.rgcGroupEntry == other.rgcGroupEntry
    }
}
impl ::std::cmp::Eq for CRYPT_URL_INFO {}
unsafe impl ::windows::runtime::Abi for CRYPT_URL_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_USERDATA: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_USER_DEFAULT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_USER_PROTECTED_STRONG: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFYCONTEXT: u32 = 4026531840u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_VERIFY_CERT_FLAGS(pub u32);
pub const CRYPT_VERIFY_CERT_SIGN_DISABLE_MD2_MD4_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(1u32);
pub const CRYPT_VERIFY_CERT_SIGN_SET_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(2u32);
pub const CRYPT_VERIFY_CERT_SIGN_RETURN_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(4u32);
impl ::std::convert::From<u32> for CRYPT_VERIFY_CERT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_VERIFY_CERT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_VERIFY_CERT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_VERIFY_CERT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_VERIFY_CERT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_VERIFY_CERT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_VERIFY_CERT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_CHECK_WEAK_HASH_FLAG: u32 = 8u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CERT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CHAIN: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_NULL: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_PUBKEY: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    pub CertSignHashCNGAlgPropData: CRYPTOAPI_BLOB,
    pub CertIssuerPubKeyBitLengthPropData: CRYPTOAPI_BLOB,
}
impl CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {}
impl ::std::default::Default for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO").field("CertSignHashCNGAlgPropData", &self.CertSignHashCNGAlgPropData).field("CertIssuerPubKeyBitLengthPropData", &self.CertIssuerPubKeyBitLengthPropData).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.CertSignHashCNGAlgPropData == other.CertSignHashCNGAlgPropData && self.CertIssuerPubKeyBitLengthPropData == other.CertIssuerPubKeyBitLengthPropData
    }
}
impl ::std::cmp::Eq for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {}
unsafe impl ::windows::runtime::Abi for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_BLOB: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CERT: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CRL: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_OCSP_BASIC_SIGNED_RESPONSE: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    pub cCNGHashAlgid: u32,
    pub rgpwszCNGHashAlgid: *mut super::super::Foundation::PWSTR,
    pub dwWeakIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO").field("cCNGHashAlgid", &self.cCNGHashAlgid).field("rgpwszCNGHashAlgid", &self.rgpwszCNGHashAlgid).field("dwWeakIndex", &self.dwWeakIndex).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCNGHashAlgid == other.cCNGHashAlgid && self.rgpwszCNGHashAlgid == other.rgpwszCNGHashAlgid && self.dwWeakIndex == other.dwWeakIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_CONTEXT_SIGNATURE: u32 = 32u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_VERIFY_DATA_HASH: u32 = 64u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_VERIFY_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub hCryptProv: usize,
    pub pfnGetSignerCertificate: ::std::option::Option<PFN_CRYPT_GET_SIGNER_CERTIFICATE>,
    pub pvGetArg: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_VERIFY_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_VERIFY_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_VERIFY_MESSAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_VERIFY_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("hCryptProv", &self.hCryptProv).field("pvGetArg", &self.pvGetArg).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_VERIFY_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.hCryptProv == other.hCryptProv && self.pfnGetSignerCertificate.map(|f| f as usize) == other.pfnGetSignerCertificate.map(|f| f as usize) && self.pvGetArg == other.pvGetArg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_VERIFY_MESSAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_VERIFY_MESSAGE_PARA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_WIRE_ONLY_RETRIEVAL: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_WRITE: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_X931_FORMAT: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_X942_COUNTER_BYTE_LENGTH: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_X942_KEY_LENGTH_BYTE_LENGTH: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_X942_OTHER_INFO {
    pub pszContentEncryptionObjId: super::super::Foundation::PSTR,
    pub rgbCounter: [u8; 4],
    pub rgbKeyLength: [u8; 4],
    pub PubInfo: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_X942_OTHER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_X942_OTHER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_X942_OTHER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_X942_OTHER_INFO").field("pszContentEncryptionObjId", &self.pszContentEncryptionObjId).field("rgbCounter", &self.rgbCounter).field("rgbKeyLength", &self.rgbKeyLength).field("PubInfo", &self.PubInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_X942_OTHER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszContentEncryptionObjId == other.pszContentEncryptionObjId && self.rgbCounter == other.rgbCounter && self.rgbKeyLength == other.rgbKeyLength && self.PubInfo == other.PubInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_X942_OTHER_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_X942_OTHER_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_ALGORITHM {
    pub cbSize: u32,
    pub wszAlgorithm: super::super::Foundation::PWSTR,
    pub Encoded: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_ALGORITHM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_ALGORITHM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_ALGORITHM").field("cbSize", &self.cbSize).field("wszAlgorithm", &self.wszAlgorithm).field("Encoded", &self.Encoded).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszAlgorithm == other.wszAlgorithm && self.Encoded == other.Encoded
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_ALGORITHM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_ALGORITHM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_ALGORITHM_INFO {
    pub cbSize: u32,
    pub wszAlgorithmURI: super::super::Foundation::PWSTR,
    pub wszName: super::super::Foundation::PWSTR,
    pub dwGroupId: CRYPT_XML_GROUP_ID,
    pub wszCNGAlgid: super::super::Foundation::PWSTR,
    pub wszCNGExtraAlgid: super::super::Foundation::PWSTR,
    pub dwSignFlags: u32,
    pub dwVerifyFlags: u32,
    pub pvPaddingInfo: *mut ::std::ffi::c_void,
    pub pvExtraInfo: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_ALGORITHM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_ALGORITHM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_ALGORITHM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_ALGORITHM_INFO")
            .field("cbSize", &self.cbSize)
            .field("wszAlgorithmURI", &self.wszAlgorithmURI)
            .field("wszName", &self.wszName)
            .field("dwGroupId", &self.dwGroupId)
            .field("wszCNGAlgid", &self.wszCNGAlgid)
            .field("wszCNGExtraAlgid", &self.wszCNGExtraAlgid)
            .field("dwSignFlags", &self.dwSignFlags)
            .field("dwVerifyFlags", &self.dwVerifyFlags)
            .field("pvPaddingInfo", &self.pvPaddingInfo)
            .field("pvExtraInfo", &self.pvExtraInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_ALGORITHM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszAlgorithmURI == other.wszAlgorithmURI && self.wszName == other.wszName && self.dwGroupId == other.dwGroupId && self.wszCNGAlgid == other.wszCNGAlgid && self.wszCNGExtraAlgid == other.wszCNGExtraAlgid && self.dwSignFlags == other.dwSignFlags && self.dwVerifyFlags == other.dwVerifyFlags && self.pvPaddingInfo == other.pvPaddingInfo && self.pvExtraInfo == other.pvExtraInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_ALGORITHM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_ALGORITHM_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_ALGID: u32 = 3u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_SIGN_ALGID: u32 = 4u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_NAME: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_URI: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_BLOB {
    pub dwCharset: CRYPT_XML_CHARSET,
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl CRYPT_XML_BLOB {}
impl ::std::default::Default for CRYPT_XML_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_BLOB").field("dwCharset", &self.dwCharset).field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwCharset == other.dwCharset && self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl ::std::cmp::Eq for CRYPT_XML_BLOB {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_BLOB {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_BLOB_MAX: u32 = 2147483640u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_CHARSET(pub i32);
pub const CRYPT_XML_CHARSET_AUTO: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(0i32);
pub const CRYPT_XML_CHARSET_UTF8: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(1i32);
pub const CRYPT_XML_CHARSET_UTF16LE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(2i32);
pub const CRYPT_XML_CHARSET_UTF16BE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(3i32);
impl ::std::convert::From<i32> for CRYPT_XML_CHARSET {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_CHARSET {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    pub cbSize: u32,
    pub fpCryptXmlEncodeAlgorithm: ::std::option::Option<CryptXmlDllEncodeAlgorithm>,
    pub fpCryptXmlCreateDigest: ::std::option::Option<CryptXmlDllCreateDigest>,
    pub fpCryptXmlDigestData: ::std::option::Option<CryptXmlDllDigestData>,
    pub fpCryptXmlFinalizeDigest: ::std::option::Option<CryptXmlDllFinalizeDigest>,
    pub fpCryptXmlCloseDigest: ::std::option::Option<CryptXmlDllCloseDigest>,
    pub fpCryptXmlSignData: ::std::option::Option<CryptXmlDllSignData>,
    pub fpCryptXmlVerifySignature: ::std::option::Option<CryptXmlDllVerifySignature>,
    pub fpCryptXmlGetAlgorithmInfo: ::std::option::Option<CryptXmlDllGetAlgorithmInfo>,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_CRYPTOGRAPHIC_INTERFACE").field("cbSize", &self.cbSize).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fpCryptXmlEncodeAlgorithm.map(|f| f as usize) == other.fpCryptXmlEncodeAlgorithm.map(|f| f as usize)
            && self.fpCryptXmlCreateDigest.map(|f| f as usize) == other.fpCryptXmlCreateDigest.map(|f| f as usize)
            && self.fpCryptXmlDigestData.map(|f| f as usize) == other.fpCryptXmlDigestData.map(|f| f as usize)
            && self.fpCryptXmlFinalizeDigest.map(|f| f as usize) == other.fpCryptXmlFinalizeDigest.map(|f| f as usize)
            && self.fpCryptXmlCloseDigest.map(|f| f as usize) == other.fpCryptXmlCloseDigest.map(|f| f as usize)
            && self.fpCryptXmlSignData.map(|f| f as usize) == other.fpCryptXmlSignData.map(|f| f as usize)
            && self.fpCryptXmlVerifySignature.map(|f| f as usize) == other.fpCryptXmlVerifySignature.map(|f| f as usize)
            && self.fpCryptXmlGetAlgorithmInfo.map(|f| f as usize) == other.fpCryptXmlGetAlgorithmInfo.map(|f| f as usize)
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_DATA_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl CRYPT_XML_DATA_BLOB {}
impl ::std::default::Default for CRYPT_XML_DATA_BLOB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_DATA_BLOB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_DATA_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_DATA_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl ::std::cmp::Eq for CRYPT_XML_DATA_BLOB {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_DATA_BLOB {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_DATA_PROVIDER {
    pub pvCallbackState: *mut ::std::ffi::c_void,
    pub cbBufferSize: u32,
    pub pfnRead: ::std::option::Option<PFN_CRYPT_XML_DATA_PROVIDER_READ>,
    pub pfnClose: ::std::option::Option<PFN_CRYPT_XML_DATA_PROVIDER_CLOSE>,
}
impl CRYPT_XML_DATA_PROVIDER {}
impl ::std::default::Default for CRYPT_XML_DATA_PROVIDER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_DATA_PROVIDER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_DATA_PROVIDER").field("pvCallbackState", &self.pvCallbackState).field("cbBufferSize", &self.cbBufferSize).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_DATA_PROVIDER {
    fn eq(&self, other: &Self) -> bool {
        self.pvCallbackState == other.pvCallbackState && self.cbBufferSize == other.cbBufferSize && self.pfnRead.map(|f| f as usize) == other.pfnRead.map(|f| f as usize) && self.pfnClose.map(|f| f as usize) == other.pfnClose.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for CRYPT_XML_DATA_PROVIDER {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_DATA_PROVIDER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_DIGEST_REFERENCE_DATA_TRANSFORMED: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_DIGEST_VALUE_MAX: u32 = 128u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_DOC_CTXT {
    pub cbSize: u32,
    pub hDocCtxt: *mut ::std::ffi::c_void,
    pub pTransformsConfig: *mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG,
    pub cSignature: u32,
    pub rgpSignature: *mut *mut CRYPT_XML_SIGNATURE,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_DOC_CTXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_DOC_CTXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_DOC_CTXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_DOC_CTXT").field("cbSize", &self.cbSize).field("hDocCtxt", &self.hDocCtxt).field("pTransformsConfig", &self.pTransformsConfig).field("cSignature", &self.cSignature).field("rgpSignature", &self.rgpSignature).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_DOC_CTXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hDocCtxt == other.hDocCtxt && self.pTransformsConfig == other.pTransformsConfig && self.cSignature == other.cSignature && self.rgpSignature == other.rgpSignature
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_DOC_CTXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_DOC_CTXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_ALGORITHM: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885372i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_BASE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885376i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_ENCODING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885373i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_HANDLE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885370i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_HASH_FAILED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885365i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_INVALID_DIGEST: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885367i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_INVALID_KEYVALUE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885361i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_INVALID_SIGNATURE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885366i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_LARGE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885375i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_LAST: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885358i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_NON_UNIQUE_ID: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885358i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_OPERATION: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885369i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_SIGNER: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885359i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_SIGN_FAILED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885364i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_TOO_MANY_SIGNATURES: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885362i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_TOO_MANY_TRANSFORMS: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885374i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_TRANSFORM: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885371i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_UNEXPECTED_XML: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885360i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_UNRESOLVED_REFERENCE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885368i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_E_VERIFY_FAILED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2146885363i32 as _);
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_FLAGS(pub u32);
pub const CRYPT_XML_FLAG_DISABLE_EXTENSIONS: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(268435456u32);
pub const CRYPT_XML_FLAG_NO_SERIALIZE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(2147483648u32);
pub const CRYPT_XML_SIGN_ADD_KEYVALUE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(1u32);
impl ::std::convert::From<u32> for CRYPT_XML_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_ADD_OBJECT_CREATE_COPY: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_ALWAYS_RETURN_ENCODED_OBJECT: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_CREATE_REFERENCE_AS_OBJECT: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_ECDSA_DSIG11: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_ENFORCE_ID_NAME_FORMAT: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_FLAG_ENFORCE_ID_NCNAME_FORMAT: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_GROUP_ID(pub u32);
pub const CRYPT_XML_GROUP_ID_HASH_________: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(1u32);
pub const CRYPT_XML_GROUP_ID_SIGN_________: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(2u32);
impl ::std::convert::From<u32> for CRYPT_XML_GROUP_ID {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_GROUP_ID {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_GROUP_ID {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_GROUP_ID {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_GROUP_ID {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_GROUP_ID {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_GROUP_ID {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_GROUP_ID_HASH: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_GROUP_ID_SIGN: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_ID_MAX: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_ISSUER_SERIAL {
    pub wszIssuer: super::super::Foundation::PWSTR,
    pub wszSerial: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_ISSUER_SERIAL {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_ISSUER_SERIAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_ISSUER_SERIAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_ISSUER_SERIAL").field("wszIssuer", &self.wszIssuer).field("wszSerial", &self.wszSerial).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_ISSUER_SERIAL {
    fn eq(&self, other: &Self) -> bool {
        self.wszIssuer == other.wszIssuer && self.wszSerial == other.wszSerial
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_ISSUER_SERIAL {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_ISSUER_SERIAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_KEYINFO_PARAM {
    pub wszId: super::super::Foundation::PWSTR,
    pub wszKeyName: super::super::Foundation::PWSTR,
    pub SKI: CRYPTOAPI_BLOB,
    pub wszSubjectName: super::super::Foundation::PWSTR,
    pub cCertificate: u32,
    pub rgCertificate: *mut CRYPTOAPI_BLOB,
    pub cCRL: u32,
    pub rgCRL: *mut CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEYINFO_PARAM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEYINFO_PARAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_KEYINFO_PARAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_KEYINFO_PARAM")
            .field("wszId", &self.wszId)
            .field("wszKeyName", &self.wszKeyName)
            .field("SKI", &self.SKI)
            .field("wszSubjectName", &self.wszSubjectName)
            .field("cCertificate", &self.cCertificate)
            .field("rgCertificate", &self.rgCertificate)
            .field("cCRL", &self.cCRL)
            .field("rgCRL", &self.rgCRL)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEYINFO_PARAM {
    fn eq(&self, other: &Self) -> bool {
        self.wszId == other.wszId && self.wszKeyName == other.wszKeyName && self.SKI == other.SKI && self.wszSubjectName == other.wszSubjectName && self.cCertificate == other.cCertificate && self.rgCertificate == other.rgCertificate && self.cCRL == other.cCRL && self.rgCRL == other.rgCRL
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEYINFO_PARAM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEYINFO_PARAM {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_KEYINFO_SPEC(pub i32);
pub const CRYPT_XML_KEYINFO_SPEC_NONE: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(0i32);
pub const CRYPT_XML_KEYINFO_SPEC_ENCODED: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(1i32);
pub const CRYPT_XML_KEYINFO_SPEC_PARAM: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(2i32);
impl ::std::convert::From<i32> for CRYPT_XML_KEYINFO_SPEC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEYINFO_SPEC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_KEYINFO_TYPE(pub u32);
pub const CRYPT_XML_KEYINFO_TYPE_KEYNAME: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(1u32);
pub const CRYPT_XML_KEYINFO_TYPE_KEYVALUE: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(2u32);
pub const CRYPT_XML_KEYINFO_TYPE_RETRIEVAL: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(3u32);
pub const CRYPT_XML_KEYINFO_TYPE_X509DATA: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(4u32);
pub const CRYPT_XML_KEYINFO_TYPE_CUSTOM: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(5u32);
impl ::std::convert::From<u32> for CRYPT_XML_KEYINFO_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEYINFO_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_KEYINFO_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_KEYINFO_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_KEYINFO_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_KEYINFO_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_KEYINFO_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_KEY_DSA_KEY_VALUE {
    pub P: CRYPT_XML_DATA_BLOB,
    pub Q: CRYPT_XML_DATA_BLOB,
    pub G: CRYPT_XML_DATA_BLOB,
    pub Y: CRYPT_XML_DATA_BLOB,
    pub J: CRYPT_XML_DATA_BLOB,
    pub Seed: CRYPT_XML_DATA_BLOB,
    pub Counter: CRYPT_XML_DATA_BLOB,
}
impl CRYPT_XML_KEY_DSA_KEY_VALUE {}
impl ::std::default::Default for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_KEY_DSA_KEY_VALUE").field("P", &self.P).field("Q", &self.Q).field("G", &self.G).field("Y", &self.Y).field("J", &self.J).field("Seed", &self.Seed).field("Counter", &self.Counter).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.P == other.P && self.Q == other.Q && self.G == other.G && self.Y == other.Y && self.J == other.J && self.Seed == other.Seed && self.Counter == other.Counter
    }
}
impl ::std::cmp::Eq for CRYPT_XML_KEY_DSA_KEY_VALUE {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_DSA_KEY_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    pub wszNamedCurve: super::super::Foundation::PWSTR,
    pub X: CRYPT_XML_DATA_BLOB,
    pub Y: CRYPT_XML_DATA_BLOB,
    pub ExplicitPara: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_ECDSA_KEY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_KEY_ECDSA_KEY_VALUE").field("wszNamedCurve", &self.wszNamedCurve).field("X", &self.X).field("Y", &self.Y).field("ExplicitPara", &self.ExplicitPara).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.wszNamedCurve == other.wszNamedCurve && self.X == other.X && self.Y == other.Y && self.ExplicitPara == other.ExplicitPara
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_ECDSA_KEY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_KEY_INFO {
    pub cbSize: u32,
    pub wszId: super::super::Foundation::PWSTR,
    pub cKeyInfo: u32,
    pub rgKeyInfo: *mut CRYPT_XML_KEY_INFO_ITEM,
    pub hVerifyKey: BCRYPT_KEY_HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_KEY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_KEY_INFO").field("cbSize", &self.cbSize).field("wszId", &self.wszId).field("cKeyInfo", &self.cKeyInfo).field("rgKeyInfo", &self.rgKeyInfo).field("hVerifyKey", &self.hVerifyKey).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszId == other.wszId && self.cKeyInfo == other.cKeyInfo && self.rgKeyInfo == other.rgKeyInfo && self.hVerifyKey == other.hVerifyKey
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_KEY_INFO_ITEM {
    pub dwType: CRYPT_XML_KEYINFO_TYPE,
    pub Anonymous: CRYPT_XML_KEY_INFO_ITEM_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_INFO_ITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_INFO_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_INFO_ITEM {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_INFO_ITEM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_INFO_ITEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPT_XML_KEY_INFO_ITEM_0 {
    pub wszKeyName: super::super::Foundation::PWSTR,
    pub KeyValue: CRYPT_XML_KEY_VALUE,
    pub RetrievalMethod: CRYPT_XML_BLOB,
    pub X509Data: CRYPT_XML_X509DATA,
    pub Custom: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_INFO_ITEM_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_INFO_ITEM_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_INFO_ITEM_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_INFO_ITEM_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_INFO_ITEM_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_KEY_RSA_KEY_VALUE {
    pub Modulus: CRYPT_XML_DATA_BLOB,
    pub Exponent: CRYPT_XML_DATA_BLOB,
}
impl CRYPT_XML_KEY_RSA_KEY_VALUE {}
impl ::std::default::Default for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_KEY_RSA_KEY_VALUE").field("Modulus", &self.Modulus).field("Exponent", &self.Exponent).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.Modulus == other.Modulus && self.Exponent == other.Exponent
    }
}
impl ::std::cmp::Eq for CRYPT_XML_KEY_RSA_KEY_VALUE {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_RSA_KEY_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_KEY_VALUE {
    pub dwType: CRYPT_XML_KEY_VALUE_TYPE,
    pub Anonymous: CRYPT_XML_KEY_VALUE_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_VALUE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPT_XML_KEY_VALUE_0 {
    pub DSAKeyValue: CRYPT_XML_KEY_DSA_KEY_VALUE,
    pub RSAKeyValue: CRYPT_XML_KEY_RSA_KEY_VALUE,
    pub ECDSAKeyValue: CRYPT_XML_KEY_ECDSA_KEY_VALUE,
    pub Custom: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_KEY_VALUE_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_KEY_VALUE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_KEY_VALUE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_KEY_VALUE_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_VALUE_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_KEY_VALUE_TYPE(pub u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_DSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(1u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_RSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(2u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_ECDSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(3u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_CUSTOM: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(4u32);
impl ::std::convert::From<u32> for CRYPT_XML_KEY_VALUE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_KEY_VALUE_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_KEY_VALUE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_KEY_VALUE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_KEY_VALUE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_KEY_VALUE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_KEY_VALUE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_OBJECT {
    pub cbSize: u32,
    pub hObject: *mut ::std::ffi::c_void,
    pub wszId: super::super::Foundation::PWSTR,
    pub wszMimeType: super::super::Foundation::PWSTR,
    pub wszEncoding: super::super::Foundation::PWSTR,
    pub Manifest: CRYPT_XML_REFERENCES,
    pub Encoded: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_OBJECT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_OBJECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_OBJECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_OBJECT").field("cbSize", &self.cbSize).field("hObject", &self.hObject).field("wszId", &self.wszId).field("wszMimeType", &self.wszMimeType).field("wszEncoding", &self.wszEncoding).field("Manifest", &self.Manifest).field("Encoded", &self.Encoded).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_OBJECT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hObject == other.hObject && self.wszId == other.wszId && self.wszMimeType == other.wszMimeType && self.wszEncoding == other.wszEncoding && self.Manifest == other.Manifest && self.Encoded == other.Encoded
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_OBJECT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_OBJECT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_OBJECTS_MAX: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_PROPERTY {
    pub dwPropId: CRYPT_XML_PROPERTY_ID,
    pub pvValue: *mut ::std::ffi::c_void,
    pub cbValue: u32,
}
impl CRYPT_XML_PROPERTY {}
impl ::std::default::Default for CRYPT_XML_PROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_PROPERTY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_PROPERTY").field("dwPropId", &self.dwPropId).field("pvValue", &self.pvValue).field("cbValue", &self.cbValue).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_PROPERTY {
    fn eq(&self, other: &Self) -> bool {
        self.dwPropId == other.dwPropId && self.pvValue == other.pvValue && self.cbValue == other.cbValue
    }
}
impl ::std::cmp::Eq for CRYPT_XML_PROPERTY {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_PROPERTY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_PROPERTY_ID(pub i32);
pub const CRYPT_XML_PROPERTY_MAX_HEAP_SIZE: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(1i32);
pub const CRYPT_XML_PROPERTY_SIGNATURE_LOCATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(2i32);
pub const CRYPT_XML_PROPERTY_MAX_SIGNATURES: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(3i32);
pub const CRYPT_XML_PROPERTY_DOC_DECLARATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(4i32);
pub const CRYPT_XML_PROPERTY_XML_OUTPUT_CHARSET: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(5i32);
impl ::std::convert::From<i32> for CRYPT_XML_PROPERTY_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_PROPERTY_ID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_REFERENCE {
    pub cbSize: u32,
    pub hReference: *mut ::std::ffi::c_void,
    pub wszId: super::super::Foundation::PWSTR,
    pub wszUri: super::super::Foundation::PWSTR,
    pub wszType: super::super::Foundation::PWSTR,
    pub DigestMethod: CRYPT_XML_ALGORITHM,
    pub DigestValue: CRYPTOAPI_BLOB,
    pub cTransform: u32,
    pub rgTransform: *mut CRYPT_XML_ALGORITHM,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_REFERENCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_REFERENCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_REFERENCE")
            .field("cbSize", &self.cbSize)
            .field("hReference", &self.hReference)
            .field("wszId", &self.wszId)
            .field("wszUri", &self.wszUri)
            .field("wszType", &self.wszType)
            .field("DigestMethod", &self.DigestMethod)
            .field("DigestValue", &self.DigestValue)
            .field("cTransform", &self.cTransform)
            .field("rgTransform", &self.rgTransform)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hReference == other.hReference && self.wszId == other.wszId && self.wszUri == other.wszUri && self.wszType == other.wszType && self.DigestMethod == other.DigestMethod && self.DigestValue == other.DigestValue && self.cTransform == other.cTransform && self.rgTransform == other.rgTransform
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_REFERENCE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_REFERENCE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_REFERENCES {
    pub cReference: u32,
    pub rgpReference: *mut *mut CRYPT_XML_REFERENCE,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_REFERENCES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_REFERENCES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_REFERENCES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_REFERENCES").field("cReference", &self.cReference).field("rgpReference", &self.rgpReference).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_REFERENCES {
    fn eq(&self, other: &Self) -> bool {
        self.cReference == other.cReference && self.rgpReference == other.rgpReference
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_REFERENCES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_REFERENCES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_REFERENCES_MAX: u32 = 32760u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_SIGNATURE {
    pub cbSize: u32,
    pub hSignature: *mut ::std::ffi::c_void,
    pub wszId: super::super::Foundation::PWSTR,
    pub SignedInfo: CRYPT_XML_SIGNED_INFO,
    pub SignatureValue: CRYPTOAPI_BLOB,
    pub pKeyInfo: *mut CRYPT_XML_KEY_INFO,
    pub cObject: u32,
    pub rgpObject: *mut *mut CRYPT_XML_OBJECT,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_SIGNATURE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_SIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_SIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_SIGNATURE")
            .field("cbSize", &self.cbSize)
            .field("hSignature", &self.hSignature)
            .field("wszId", &self.wszId)
            .field("SignedInfo", &self.SignedInfo)
            .field("SignatureValue", &self.SignatureValue)
            .field("pKeyInfo", &self.pKeyInfo)
            .field("cObject", &self.cObject)
            .field("rgpObject", &self.rgpObject)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hSignature == other.hSignature && self.wszId == other.wszId && self.SignedInfo == other.SignedInfo && self.SignatureValue == other.SignatureValue && self.pKeyInfo == other.pKeyInfo && self.cObject == other.cObject && self.rgpObject == other.rgpObject
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_SIGNATURE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_SIGNATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_SIGNATURES_MAX: u32 = 16u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_SIGNATURE_VALUE_MAX: u32 = 2048u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_SIGNED_INFO {
    pub cbSize: u32,
    pub wszId: super::super::Foundation::PWSTR,
    pub Canonicalization: CRYPT_XML_ALGORITHM,
    pub SignatureMethod: CRYPT_XML_ALGORITHM,
    pub cReference: u32,
    pub rgpReference: *mut *mut CRYPT_XML_REFERENCE,
    pub Encoded: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_SIGNED_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_SIGNED_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_SIGNED_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_SIGNED_INFO")
            .field("cbSize", &self.cbSize)
            .field("wszId", &self.wszId)
            .field("Canonicalization", &self.Canonicalization)
            .field("SignatureMethod", &self.SignatureMethod)
            .field("cReference", &self.cReference)
            .field("rgpReference", &self.rgpReference)
            .field("Encoded", &self.Encoded)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_SIGNED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszId == other.wszId && self.Canonicalization == other.Canonicalization && self.SignatureMethod == other.SignatureMethod && self.cReference == other.cReference && self.rgpReference == other.rgpReference && self.Encoded == other.Encoded
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_SIGNED_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_SIGNED_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CRYPT_XML_STATUS {
    pub cbSize: u32,
    pub dwErrorStatus: CRYPT_XML_STATUS_ERROR_STATUS,
    pub dwInfoStatus: CRYPT_XML_STATUS_INFO_STATUS,
}
impl CRYPT_XML_STATUS {}
impl ::std::default::Default for CRYPT_XML_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CRYPT_XML_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_STATUS").field("cbSize", &self.cbSize).field("dwErrorStatus", &self.dwErrorStatus).field("dwInfoStatus", &self.dwInfoStatus).finish()
    }
}
impl ::std::cmp::PartialEq for CRYPT_XML_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwErrorStatus == other.dwErrorStatus && self.dwInfoStatus == other.dwInfoStatus
    }
}
impl ::std::cmp::Eq for CRYPT_XML_STATUS {}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_STATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_STATUS_ERROR_STATUS(pub u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_RESOLVED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(1u32);
pub const CRYPT_XML_STATUS_ERROR_DIGEST_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(2u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_ALGORITHM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(5u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_TRANSFORM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(8u32);
pub const CRYPT_XML_STATUS_ERROR_SIGNATURE_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(65536u32);
pub const CRYPT_XML_STATUS_ERROR_KEYINFO_NOT_PARSED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(131072u32);
impl ::std::convert::From<u32> for CRYPT_XML_STATUS_ERROR_STATUS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_STATUS_ERROR_STATUS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_STATUS_ERROR_STATUS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_STATUS_ERROR_STATUS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_STATUS_ERROR_STATUS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_STATUS_ERROR_STATUS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_STATUS_ERROR_STATUS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_STATUS_INFO_STATUS(pub u32);
pub const CRYPT_XML_STATUS_INTERNAL_REFERENCE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(1u32);
pub const CRYPT_XML_STATUS_KEY_AVAILABLE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2u32);
pub const CRYPT_XML_STATUS_DIGESTING: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(4u32);
pub const CRYPT_XML_STATUS_DIGEST_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(8u32);
pub const CRYPT_XML_STATUS_SIGNATURE_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(65536u32);
pub const CRYPT_XML_STATUS_OPENED_TO_ENCODE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2147483648u32);
impl ::std::convert::From<u32> for CRYPT_XML_STATUS_INFO_STATUS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_STATUS_INFO_STATUS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_STATUS_INFO_STATUS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_STATUS_INFO_STATUS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_STATUS_INFO_STATUS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_STATUS_INFO_STATUS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_STATUS_INFO_STATUS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_STATUS_NO_ERROR: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    pub cbSize: u32,
    pub cTransformInfo: u32,
    pub rgpTransformInfo: *mut *mut CRYPT_XML_TRANSFORM_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_TRANSFORM_CHAIN_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_TRANSFORM_CHAIN_CONFIG").field("cbSize", &self.cbSize).field("cTransformInfo", &self.cTransformInfo).field("rgpTransformInfo", &self.rgpTransformInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cTransformInfo == other.cTransformInfo && self.rgpTransformInfo == other.rgpTransformInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_TRANSFORM_FLAGS(pub u32);
pub const CRYPT_XML_TRANSFORM_ON_STREAM: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(1u32);
pub const CRYPT_XML_TRANSFORM_ON_NODESET: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(2u32);
pub const CRYPT_XML_TRANSFORM_URI_QUERY_STRING: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(3u32);
impl ::std::convert::From<u32> for CRYPT_XML_TRANSFORM_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_TRANSFORM_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_TRANSFORM_INFO {
    pub cbSize: u32,
    pub wszAlgorithm: super::super::Foundation::PWSTR,
    pub cbBufferSize: u32,
    pub dwFlags: CRYPT_XML_TRANSFORM_FLAGS,
    pub pfnCreateTransform: ::std::option::Option<PFN_CRYPT_XML_CREATE_TRANSFORM>,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_TRANSFORM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_TRANSFORM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_TRANSFORM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_TRANSFORM_INFO").field("cbSize", &self.cbSize).field("wszAlgorithm", &self.wszAlgorithm).field("cbBufferSize", &self.cbBufferSize).field("dwFlags", &self.dwFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_TRANSFORM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszAlgorithm == other.wszAlgorithm && self.cbBufferSize == other.cbBufferSize && self.dwFlags == other.dwFlags && self.pfnCreateTransform.map(|f| f as usize) == other.pfnCreateTransform.map(|f| f as usize)
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_TRANSFORM_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_TRANSFORM_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYPT_XML_TRANSFORM_MAX: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_X509DATA {
    pub cX509Data: u32,
    pub rgX509Data: *mut CRYPT_XML_X509DATA_ITEM,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_X509DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_X509DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CRYPT_XML_X509DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CRYPT_XML_X509DATA").field("cX509Data", &self.cX509Data).field("rgX509Data", &self.rgX509Data).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_X509DATA {
    fn eq(&self, other: &Self) -> bool {
        self.cX509Data == other.cX509Data && self.rgX509Data == other.rgX509Data
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_X509DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_X509DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CRYPT_XML_X509DATA_ITEM {
    pub dwType: CRYPT_XML_X509DATA_TYPE,
    pub Anonymous: CRYPT_XML_X509DATA_ITEM_0,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_X509DATA_ITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_X509DATA_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_X509DATA_ITEM {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_X509DATA_ITEM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_X509DATA_ITEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union CRYPT_XML_X509DATA_ITEM_0 {
    pub IssuerSerial: CRYPT_XML_ISSUER_SERIAL,
    pub SKI: CRYPT_XML_DATA_BLOB,
    pub wszSubjectName: super::super::Foundation::PWSTR,
    pub Certificate: CRYPT_XML_DATA_BLOB,
    pub CRL: CRYPT_XML_DATA_BLOB,
    pub Custom: CRYPT_XML_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CRYPT_XML_X509DATA_ITEM_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CRYPT_XML_X509DATA_ITEM_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CRYPT_XML_X509DATA_ITEM_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CRYPT_XML_X509DATA_ITEM_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CRYPT_XML_X509DATA_ITEM_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRYPT_XML_X509DATA_TYPE(pub u32);
pub const CRYPT_XML_X509DATA_TYPE_ISSUER_SERIAL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(1u32);
pub const CRYPT_XML_X509DATA_TYPE_SKI: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(2u32);
pub const CRYPT_XML_X509DATA_TYPE_SUBJECT_NAME: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(3u32);
pub const CRYPT_XML_X509DATA_TYPE_CERTIFICATE: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(4u32);
pub const CRYPT_XML_X509DATA_TYPE_CRL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(5u32);
pub const CRYPT_XML_X509DATA_TYPE_CUSTOM: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(6u32);
impl ::std::convert::From<u32> for CRYPT_XML_X509DATA_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRYPT_XML_X509DATA_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for CRYPT_XML_X509DATA_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CRYPT_XML_X509DATA_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CRYPT_XML_X509DATA_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CRYPT_XML_X509DATA_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CRYPT_XML_X509DATA_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CRYTPDLG_FLAGS_MASK: u32 = 4278190080u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CSS_SELECTCERT_MASK: u32 = 16777215u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_ANY_SUBJECT_INFO {
    pub SubjectAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub SubjectIdentifier: CRYPTOAPI_BLOB,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_ANY_SUBJECT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_ANY_SUBJECT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_ANY_SUBJECT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_ANY_SUBJECT_INFO").field("SubjectAlgorithm", &self.SubjectAlgorithm).field("SubjectIdentifier", &self.SubjectIdentifier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_ANY_SUBJECT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectAlgorithm == other.SubjectAlgorithm && self.SubjectIdentifier == other.SubjectIdentifier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_ANY_SUBJECT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_ANY_SUBJECT_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CTL_ANY_SUBJECT_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CTL_CERT_SUBJECT_TYPE: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_CONTEXT {
    pub dwMsgAndCertEncodingType: u32,
    pub pbCtlEncoded: *mut u8,
    pub cbCtlEncoded: u32,
    pub pCtlInfo: *mut CTL_INFO,
    pub hCertStore: *mut ::std::ffi::c_void,
    pub hCryptMsg: *mut ::std::ffi::c_void,
    pub pbCtlContent: *mut u8,
    pub cbCtlContent: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_CONTEXT")
            .field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType)
            .field("pbCtlEncoded", &self.pbCtlEncoded)
            .field("cbCtlEncoded", &self.cbCtlEncoded)
            .field("pCtlInfo", &self.pCtlInfo)
            .field("hCertStore", &self.hCertStore)
            .field("hCryptMsg", &self.hCryptMsg)
            .field("pbCtlContent", &self.pbCtlContent)
            .field("cbCtlContent", &self.cbCtlContent)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.pbCtlEncoded == other.pbCtlEncoded && self.cbCtlEncoded == other.cbCtlEncoded && self.pCtlInfo == other.pCtlInfo && self.hCertStore == other.hCertStore && self.hCryptMsg == other.hCryptMsg && self.pbCtlContent == other.pbCtlContent && self.cbCtlContent == other.cbCtlContent
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_CONTEXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_ENTRY {
    pub SubjectIdentifier: CRYPTOAPI_BLOB,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_ENTRY").field("SubjectIdentifier", &self.SubjectIdentifier).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectIdentifier == other.SubjectIdentifier && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_ENTRY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CTL_ENTRY_FROM_PROP_CHAIN_FLAG: u32 = 1u32;
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CTL_FIND_NO_LIST_ID_CBDATA: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_FIND_SUBJECT_PARA {
    pub cbSize: u32,
    pub pUsagePara: *mut CTL_FIND_USAGE_PARA,
    pub dwSubjectType: u32,
    pub pvSubject: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_FIND_SUBJECT_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_FIND_SUBJECT_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_FIND_SUBJECT_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_FIND_SUBJECT_PARA").field("cbSize", &self.cbSize).field("pUsagePara", &self.pUsagePara).field("dwSubjectType", &self.dwSubjectType).field("pvSubject", &self.pvSubject).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_FIND_SUBJECT_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pUsagePara == other.pUsagePara && self.dwSubjectType == other.dwSubjectType && self.pvSubject == other.pvSubject
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_FIND_SUBJECT_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_FIND_SUBJECT_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_FIND_USAGE_PARA {
    pub cbSize: u32,
    pub SubjectUsage: CTL_USAGE,
    pub ListIdentifier: CRYPTOAPI_BLOB,
    pub pSigner: *mut CERT_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_FIND_USAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_FIND_USAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_FIND_USAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_FIND_USAGE_PARA").field("cbSize", &self.cbSize).field("SubjectUsage", &self.SubjectUsage).field("ListIdentifier", &self.ListIdentifier).field("pSigner", &self.pSigner).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_FIND_USAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.SubjectUsage == other.SubjectUsage && self.ListIdentifier == other.ListIdentifier && self.pSigner == other.pSigner
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_FIND_USAGE_PARA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_FIND_USAGE_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_INFO {
    pub dwVersion: u32,
    pub SubjectUsage: CTL_USAGE,
    pub ListIdentifier: CRYPTOAPI_BLOB,
    pub SequenceNumber: CRYPTOAPI_BLOB,
    pub ThisUpdate: super::super::Foundation::FILETIME,
    pub NextUpdate: super::super::Foundation::FILETIME,
    pub SubjectAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub cCTLEntry: u32,
    pub rgCTLEntry: *mut CTL_ENTRY,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("SubjectUsage", &self.SubjectUsage)
            .field("ListIdentifier", &self.ListIdentifier)
            .field("SequenceNumber", &self.SequenceNumber)
            .field("ThisUpdate", &self.ThisUpdate)
            .field("NextUpdate", &self.NextUpdate)
            .field("SubjectAlgorithm", &self.SubjectAlgorithm)
            .field("cCTLEntry", &self.cCTLEntry)
            .field("rgCTLEntry", &self.rgCTLEntry)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SubjectUsage == other.SubjectUsage && self.ListIdentifier == other.ListIdentifier && self.SequenceNumber == other.SequenceNumber && self.ThisUpdate == other.ThisUpdate && self.NextUpdate == other.NextUpdate && self.SubjectAlgorithm == other.SubjectAlgorithm && self.cCTLEntry == other.cCTLEntry && self.rgCTLEntry == other.rgCTLEntry && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_MODIFY_REQUEST {
    pub pccert: *mut CERT_CONTEXT,
    pub dwOperation: CTL_MODIFY_REQUEST_OPERATION,
    pub dwError: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_MODIFY_REQUEST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_MODIFY_REQUEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_MODIFY_REQUEST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_MODIFY_REQUEST").field("pccert", &self.pccert).field("dwOperation", &self.dwOperation).field("dwError", &self.dwError).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_MODIFY_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.pccert == other.pccert && self.dwOperation == other.dwOperation && self.dwError == other.dwError
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_MODIFY_REQUEST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_MODIFY_REQUEST {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CTL_MODIFY_REQUEST_OPERATION(pub u32);
pub const CTL_MODIFY_REQUEST_ADD_TRUSTED: CTL_MODIFY_REQUEST_OPERATION = CTL_MODIFY_REQUEST_OPERATION(3u32);
pub const CTL_MODIFY_REQUEST_ADD_NOT_TRUSTED: CTL_MODIFY_REQUEST_OPERATION = CTL_MODIFY_REQUEST_OPERATION(1u32);
pub const CTL_MODIFY_REQUEST_REMOVE: CTL_MODIFY_REQUEST_OPERATION = CTL_MODIFY_REQUEST_OPERATION(2u32);
impl ::std::convert::From<u32> for CTL_MODIFY_REQUEST_OPERATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CTL_MODIFY_REQUEST_OPERATION {
    type Abi = Self;
}
impl ::std::ops::BitOr for CTL_MODIFY_REQUEST_OPERATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CTL_MODIFY_REQUEST_OPERATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CTL_MODIFY_REQUEST_OPERATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CTL_MODIFY_REQUEST_OPERATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CTL_MODIFY_REQUEST_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_USAGE {
    pub cUsageIdentifier: u32,
    pub rgpszUsageIdentifier: *mut super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_USAGE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_USAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_USAGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_USAGE").field("cUsageIdentifier", &self.cUsageIdentifier).field("rgpszUsageIdentifier", &self.rgpszUsageIdentifier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_USAGE {
    fn eq(&self, other: &Self) -> bool {
        self.cUsageIdentifier == other.cUsageIdentifier && self.rgpszUsageIdentifier == other.rgpszUsageIdentifier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_USAGE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_USAGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_USAGE_MATCH {
    pub dwType: u32,
    pub Usage: CTL_USAGE,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_USAGE_MATCH {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_USAGE_MATCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_USAGE_MATCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_USAGE_MATCH").field("dwType", &self.dwType).field("Usage", &self.Usage).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_USAGE_MATCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.Usage == other.Usage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_USAGE_MATCH {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_USAGE_MATCH {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CTL_V1: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub struct CTL_VERIFY_USAGE_PARA {
    pub cbSize: u32,
    pub ListIdentifier: CRYPTOAPI_BLOB,
    pub cCtlStore: u32,
    pub rghCtlStore: *mut *mut ::std::ffi::c_void,
    pub cSignerStore: u32,
    pub rghSignerStore: *mut *mut ::std::ffi::c_void,
}
impl CTL_VERIFY_USAGE_PARA {}
impl ::std::default::Default for CTL_VERIFY_USAGE_PARA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CTL_VERIFY_USAGE_PARA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_VERIFY_USAGE_PARA").field("cbSize", &self.cbSize).field("ListIdentifier", &self.ListIdentifier).field("cCtlStore", &self.cCtlStore).field("rghCtlStore", &self.rghCtlStore).field("cSignerStore", &self.cSignerStore).field("rghSignerStore", &self.rghSignerStore).finish()
    }
}
impl ::std::cmp::PartialEq for CTL_VERIFY_USAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.ListIdentifier == other.ListIdentifier && self.cCtlStore == other.cCtlStore && self.rghCtlStore == other.rghCtlStore && self.cSignerStore == other.cSignerStore && self.rghSignerStore == other.rghSignerStore
    }
}
impl ::std::cmp::Eq for CTL_VERIFY_USAGE_PARA {}
unsafe impl ::windows::runtime::Abi for CTL_VERIFY_USAGE_PARA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
pub struct CTL_VERIFY_USAGE_STATUS {
    pub cbSize: u32,
    pub dwError: u32,
    pub dwFlags: u32,
    pub ppCtl: *mut *mut CTL_CONTEXT,
    pub dwCtlEntryIndex: u32,
    pub ppSigner: *mut *mut CERT_CONTEXT,
    pub dwSignerIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CTL_VERIFY_USAGE_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CTL_VERIFY_USAGE_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CTL_VERIFY_USAGE_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CTL_VERIFY_USAGE_STATUS").field("cbSize", &self.cbSize).field("dwError", &self.dwError).field("dwFlags", &self.dwFlags).field("ppCtl", &self.ppCtl).field("dwCtlEntryIndex", &self.dwCtlEntryIndex).field("ppSigner", &self.ppSigner).field("dwSignerIndex", &self.dwSignerIndex).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CTL_VERIFY_USAGE_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwError == other.dwError && self.dwFlags == other.dwFlags && self.ppCtl == other.ppCtl && self.dwCtlEntryIndex == other.dwCtlEntryIndex && self.ppSigner == other.ppSigner && self.dwSignerIndex == other.dwSignerIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CTL_VERIFY_USAGE_STATUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CTL_VERIFY_USAGE_STATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
pub const CUR_BLOB_VERSION: u32 = 2u32;
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCRLContextToStore(hcertstore: *const ::std::ffi::c_void, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCRLContextToStore(hcertstore: *const ::std::ffi::c_void, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCRLContextToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCRLLinkToStore(hcertstore: *const ::std::ffi::c_void, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCRLLinkToStore(hcertstore: *const ::std::ffi::c_void, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCRLLinkToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCTLContextToStore(hcertstore: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCTLContextToStore(hcertstore: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCTLContextToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCTLLinkToStore(hcertstore: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCTLLinkToStore(hcertstore: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCTLLinkToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCertificateContextToStore(hcertstore: *const ::std::ffi::c_void, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCertificateContextToStore(hcertstore: *const ::std::ffi::c_void, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCertificateContextToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCertificateLinkToStore(hcertstore: *const ::std::ffi::c_void, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddCertificateLinkToStore(hcertstore: *const ::std::ffi::c_void, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddCertificateLinkToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppstorecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCRLToStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pbcrlencoded: *const u8, cbcrlencoded: u32, dwadddisposition: u32, ppcrlcontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEncodedCRLToStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pbcrlencoded: *const u8, cbcrlencoded: u32, dwadddisposition: u32, ppcrlcontext: *mut *mut CRL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEncodedCRLToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pbcrlencoded), ::std::mem::transmute(cbcrlencoded), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCTLToStore(hcertstore: *const ::std::ffi::c_void, dwmsgandcertencodingtype: u32, pbctlencoded: *const u8, cbctlencoded: u32, dwadddisposition: u32, ppctlcontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEncodedCTLToStore(hcertstore: *const ::std::ffi::c_void, dwmsgandcertencodingtype: u32, pbctlencoded: *const u8, cbctlencoded: u32, dwadddisposition: u32, ppctlcontext: *mut *mut CTL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEncodedCTLToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwmsgandcertencodingtype), ::std::mem::transmute(pbctlencoded), ::std::mem::transmute(cbctlencoded), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pbcertencoded: *const u8, cbcertencoded: u32, dwadddisposition: u32, ppcertcontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEncodedCertificateToStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pbcertencoded: *const u8, cbcertencoded: u32, dwadddisposition: u32, ppcertcontext: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEncodedCertificateToStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pbcertencoded), ::std::mem::transmute(cbcertencoded), ::std::mem::transmute(dwadddisposition), ::std::mem::transmute(ppcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreA<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(szcertstorename: Param0, pbcertencoded: *const u8, cbcertencoded: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEncodedCertificateToSystemStoreA(szcertstorename: super::super::Foundation::PSTR, pbcertencoded: *const u8, cbcertencoded: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEncodedCertificateToSystemStoreA(szcertstorename.into_param().abi(), ::std::mem::transmute(pbcertencoded), ::std::mem::transmute(cbcertencoded)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreW<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(szcertstorename: Param0, pbcertencoded: *const u8, cbcertencoded: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEncodedCertificateToSystemStoreW(szcertstorename: super::super::Foundation::PWSTR, pbcertencoded: *const u8, cbcertencoded: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEncodedCertificateToSystemStoreW(szcertstorename.into_param().abi(), ::std::mem::transmute(pbcertencoded), ::std::mem::transmute(cbcertencoded)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEnhancedKeyUsageIdentifier<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: Param1) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddEnhancedKeyUsageIdentifier(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: super::super::Foundation::PSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddEnhancedKeyUsageIdentifier(::std::mem::transmute(pcertcontext), pszusageidentifier.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertAddRefServerOcspResponse(hserverocspresponse: *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddRefServerOcspResponse(hserverocspresponse: *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(CertAddRefServerOcspResponse(::std::mem::transmute(hserverocspresponse)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext: *const CERT_SERVER_OCSP_RESPONSE_CONTEXT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext: *const CERT_SERVER_OCSP_RESPONSE_CONTEXT);
        }
        ::std::mem::transmute(CertAddRefServerOcspResponseContext(::std::mem::transmute(pserverocspresponsecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddSerializedElementToStore(hcertstore: *const ::std::ffi::c_void, pbelement: *const u8, cbelement: u32, dwadddisposition: u32, dwflags: u32, dwcontexttypeflags: u32, pdwcontexttype: *mut u32, ppvcontext: *mut *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddSerializedElementToStore(hcertstore: *const ::std::ffi::c_void, pbelement: *const u8, cbelement: u32, dwadddisposition: u32, dwflags: u32, dwcontexttypeflags: u32, pdwcontexttype: *mut u32, ppvcontext: *mut *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddSerializedElementToStore(
            ::std::mem::transmute(hcertstore),
            ::std::mem::transmute(pbelement),
            ::std::mem::transmute(cbelement),
            ::std::mem::transmute(dwadddisposition),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwcontexttypeflags),
            ::std::mem::transmute(pdwcontexttype),
            ::std::mem::transmute(ppvcontext),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddStoreToCollection(hcollectionstore: *const ::std::ffi::c_void, hsiblingstore: *const ::std::ffi::c_void, dwupdateflags: u32, dwpriority: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAddStoreToCollection(hcollectionstore: *const ::std::ffi::c_void, hsiblingstore: *const ::std::ffi::c_void, dwupdateflags: u32, dwpriority: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertAddStoreToCollection(::std::mem::transmute(hcollectionstore), ::std::mem::transmute(hsiblingstore), ::std::mem::transmute(dwupdateflags), ::std::mem::transmute(dwpriority)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAlgIdToOID(dwalgid: u32) -> super::super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertAlgIdToOID(dwalgid: u32) -> super::super::Foundation::PSTR;
        }
        ::std::mem::transmute(CertAlgIdToOID(::std::mem::transmute(dwalgid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertCloseServerOcspResponse(hserverocspresponse: *const ::std::ffi::c_void, dwflags: u32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCloseServerOcspResponse(hserverocspresponse: *const ::std::ffi::c_void, dwflags: u32);
        }
        ::std::mem::transmute(CertCloseServerOcspResponse(::std::mem::transmute(hserverocspresponse), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCloseStore(hcertstore: *const ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCloseStore(hcertstore: *const ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCloseStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareCertificate(dwcertencodingtype: u32, pcertid1: *const CERT_INFO, pcertid2: *const CERT_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCompareCertificate(dwcertencodingtype: u32, pcertid1: *const CERT_INFO, pcertid2: *const CERT_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCompareCertificate(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pcertid1), ::std::mem::transmute(pcertid2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareCertificateName(dwcertencodingtype: u32, pcertname1: *const CRYPTOAPI_BLOB, pcertname2: *const CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCompareCertificateName(dwcertencodingtype: u32, pcertname1: *const CRYPTOAPI_BLOB, pcertname2: *const CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCompareCertificateName(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pcertname1), ::std::mem::transmute(pcertname2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareIntegerBlob(pint1: *const CRYPTOAPI_BLOB, pint2: *const CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCompareIntegerBlob(pint1: *const CRYPTOAPI_BLOB, pint2: *const CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCompareIntegerBlob(::std::mem::transmute(pint1), ::std::mem::transmute(pint2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertComparePublicKeyInfo(dwcertencodingtype: u32, ppublickey1: *const CERT_PUBLIC_KEY_INFO, ppublickey2: *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertComparePublicKeyInfo(dwcertencodingtype: u32, ppublickey1: *const CERT_PUBLIC_KEY_INFO, ppublickey2: *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertComparePublicKeyInfo(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(ppublickey1), ::std::mem::transmute(ppublickey2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertControlStore(hcertstore: *const ::std::ffi::c_void, dwflags: CERT_CONTROL_STORE_FLAGS, dwctrltype: u32, pvctrlpara: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertControlStore(hcertstore: *const ::std::ffi::c_void, dwflags: CERT_CONTROL_STORE_FLAGS, dwctrltype: u32, pvctrlpara: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertControlStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwflags), ::std::mem::transmute(dwctrltype), ::std::mem::transmute(pvctrlpara)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCRLContext(dwcertencodingtype: u32, pbcrlencoded: *const u8, cbcrlencoded: u32) -> *mut CRL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateCRLContext(dwcertencodingtype: u32, pbcrlencoded: *const u8, cbcrlencoded: u32) -> *mut CRL_CONTEXT;
        }
        ::std::mem::transmute(CertCreateCRLContext(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pbcrlencoded), ::std::mem::transmute(cbcrlencoded)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCTLContext(dwmsgandcertencodingtype: u32, pbctlencoded: *const u8, cbctlencoded: u32) -> *mut CTL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateCTLContext(dwmsgandcertencodingtype: u32, pbctlencoded: *const u8, cbctlencoded: u32) -> *mut CTL_CONTEXT;
        }
        ::std::mem::transmute(CertCreateCTLContext(::std::mem::transmute(dwmsgandcertencodingtype), ::std::mem::transmute(pbctlencoded), ::std::mem::transmute(cbctlencoded)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, coptattr: u32, rgoptattr: *const CRYPT_ATTRIBUTE, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pctlentry: *mut CTL_ENTRY, pcbctlentry: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, coptattr: u32, rgoptattr: *const CRYPT_ATTRIBUTE, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pctlentry: *mut CTL_ENTRY, pcbctlentry: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCreateCTLEntryFromCertificateContextProperties(::std::mem::transmute(pcertcontext), ::std::mem::transmute(coptattr), ::std::mem::transmute(rgoptattr), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved), ::std::mem::transmute(pctlentry), ::std::mem::transmute(pcbctlentry)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCertificateChainEngine(pconfig: *const CERT_CHAIN_ENGINE_CONFIG, phchainengine: *mut HCERTCHAINENGINE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateCertificateChainEngine(pconfig: *const CERT_CHAIN_ENGINE_CONFIG, phchainengine: *mut HCERTCHAINENGINE) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertCreateCertificateChainEngine(::std::mem::transmute(pconfig), ::std::mem::transmute(phchainengine)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCertificateContext(dwcertencodingtype: u32, pbcertencoded: *const u8, cbcertencoded: u32) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateCertificateContext(dwcertencodingtype: u32, pbcertencoded: *const u8, cbcertencoded: u32) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertCreateCertificateContext(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pbcertencoded), ::std::mem::transmute(cbcertencoded)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateContext(dwcontexttype: u32, dwencodingtype: u32, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pcreatepara: *const CERT_CREATE_CONTEXT_PARA) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateContext(dwcontexttype: u32, dwencodingtype: u32, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pcreatepara: *const ::std::mem::ManuallyDrop<CERT_CREATE_CONTEXT_PARA>) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertCreateContext(::std::mem::transmute(dwcontexttype), ::std::mem::transmute(dwencodingtype), ::std::mem::transmute(pbencoded), ::std::mem::transmute(cbencoded), ::std::mem::transmute(dwflags), ::std::mem::transmute(pcreatepara)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateSelfSignCertificate(hcryptprovorncryptkey: usize, psubjectissuerblob: *const CRYPTOAPI_BLOB, dwflags: CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo: *const CRYPT_KEY_PROV_INFO, psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pstarttime: *const super::super::Foundation::SYSTEMTIME, pendtime: *const super::super::Foundation::SYSTEMTIME, pextensions: *const CERT_EXTENSIONS) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertCreateSelfSignCertificate(hcryptprovorncryptkey: usize, psubjectissuerblob: *const CRYPTOAPI_BLOB, dwflags: CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo: *const CRYPT_KEY_PROV_INFO, psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pstarttime: *const super::super::Foundation::SYSTEMTIME, pendtime: *const super::super::Foundation::SYSTEMTIME, pextensions: *const CERT_EXTENSIONS) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertCreateSelfSignCertificate(
            ::std::mem::transmute(hcryptprovorncryptkey),
            ::std::mem::transmute(psubjectissuerblob),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pkeyprovinfo),
            ::std::mem::transmute(psignaturealgorithm),
            ::std::mem::transmute(pstarttime),
            ::std::mem::transmute(pendtime),
            ::std::mem::transmute(pextensions),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCRLFromStore(pcrlcontext: *const CRL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDeleteCRLFromStore(pcrlcontext: *const CRL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertDeleteCRLFromStore(::std::mem::transmute(pcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCTLFromStore(pctlcontext: *const CTL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDeleteCTLFromStore(pctlcontext: *const CTL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertDeleteCTLFromStore(::std::mem::transmute(pctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCertificateFromStore(pcertcontext: *const CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDeleteCertificateFromStore(pcertcontext: *const CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertDeleteCertificateFromStore(::std::mem::transmute(pcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCRLContext(pcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDuplicateCRLContext(pcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT;
        }
        ::std::mem::transmute(CertDuplicateCRLContext(::std::mem::transmute(pcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCTLContext(pctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDuplicateCTLContext(pctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT;
        }
        ::std::mem::transmute(CertDuplicateCTLContext(::std::mem::transmute(pctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDuplicateCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT;
        }
        ::std::mem::transmute(CertDuplicateCertificateChain(::std::mem::transmute(pchaincontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCertificateContext(pcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDuplicateCertificateContext(pcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertDuplicateCertificateContext(::std::mem::transmute(pcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertDuplicateStore(hcertstore: *const ::std::ffi::c_void) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertDuplicateStore(hcertstore: *const ::std::ffi::c_void) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertDuplicateStore(::std::mem::transmute(hcertstore)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCRLContextProperties(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCRLContextProperties(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32) -> u32;
        }
        ::std::mem::transmute(CertEnumCRLContextProperties(::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwpropid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCRLsInStore(hcertstore: *const ::std::ffi::c_void, pprevcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCRLsInStore(hcertstore: *const ::std::ffi::c_void, pprevcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT;
        }
        ::std::mem::transmute(CertEnumCRLsInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pprevcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCTLContextProperties(pctlcontext: *const CTL_CONTEXT, dwpropid: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCTLContextProperties(pctlcontext: *const CTL_CONTEXT, dwpropid: u32) -> u32;
        }
        ::std::mem::transmute(CertEnumCTLContextProperties(::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwpropid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCTLsInStore(hcertstore: *const ::std::ffi::c_void, pprevctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCTLsInStore(hcertstore: *const ::std::ffi::c_void, pprevctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT;
        }
        ::std::mem::transmute(CertEnumCTLsInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pprevctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, dwpropid: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, dwpropid: u32) -> u32;
        }
        ::std::mem::transmute(CertEnumCertificateContextProperties(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwpropid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCertificatesInStore(hcertstore: *const ::std::ffi::c_void, pprevcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumCertificatesInStore(hcertstore: *const ::std::ffi::c_void, pprevcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertEnumCertificatesInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pprevcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumPhysicalStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pvarg: *mut ::std::ffi::c_void, pfnenum: ::std::option::Option<PFN_CERT_ENUM_PHYSICAL_STORE>) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumPhysicalStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pvarg: *mut ::std::ffi::c_void, pfnenum: ::windows::runtime::RawPtr) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertEnumPhysicalStore(::std::mem::transmute(pvsystemstore), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvarg), ::std::mem::transmute(pfnenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSubjectInSortedCTL(pctlcontext: *const CTL_CONTEXT, ppvnextsubject: *mut *mut ::std::ffi::c_void, psubjectidentifier: *mut CRYPTOAPI_BLOB, pencodedattributes: *mut CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumSubjectInSortedCTL(pctlcontext: *const CTL_CONTEXT, ppvnextsubject: *mut *mut ::std::ffi::c_void, psubjectidentifier: *mut CRYPTOAPI_BLOB, pencodedattributes: *mut CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertEnumSubjectInSortedCTL(::std::mem::transmute(pctlcontext), ::std::mem::transmute(ppvnextsubject), ::std::mem::transmute(psubjectidentifier), ::std::mem::transmute(pencodedattributes)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSystemStore(dwflags: u32, pvsystemstorelocationpara: *const ::std::ffi::c_void, pvarg: *mut ::std::ffi::c_void, pfnenum: ::std::option::Option<PFN_CERT_ENUM_SYSTEM_STORE>) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumSystemStore(dwflags: u32, pvsystemstorelocationpara: *const ::std::ffi::c_void, pvarg: *mut ::std::ffi::c_void, pfnenum: ::windows::runtime::RawPtr) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertEnumSystemStore(::std::mem::transmute(dwflags), ::std::mem::transmute(pvsystemstorelocationpara), ::std::mem::transmute(pvarg), ::std::mem::transmute(pfnenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSystemStoreLocation(dwflags: u32, pvarg: *mut ::std::ffi::c_void, pfnenum: ::std::option::Option<PFN_CERT_ENUM_SYSTEM_STORE_LOCATION>) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertEnumSystemStoreLocation(dwflags: u32, pvarg: *mut ::std::ffi::c_void, pfnenum: ::windows::runtime::RawPtr) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertEnumSystemStoreLocation(::std::mem::transmute(dwflags), ::std::mem::transmute(pvarg), ::std::mem::transmute(pfnenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindAttribute<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pszobjid: Param0, cattr: u32, rgattr: *const CRYPT_ATTRIBUTE) -> *mut CRYPT_ATTRIBUTE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindAttribute(pszobjid: super::super::Foundation::PSTR, cattr: u32, rgattr: *const CRYPT_ATTRIBUTE) -> *mut CRYPT_ATTRIBUTE;
        }
        ::std::mem::transmute(CertFindAttribute(pszobjid.into_param().abi(), ::std::mem::transmute(cattr), ::std::mem::transmute(rgattr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCRLInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: u32, dwfindtype: u32, pvfindpara: *const ::std::ffi::c_void, pprevcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindCRLInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: u32, dwfindtype: u32, pvfindpara: *const ::std::ffi::c_void, pprevcrlcontext: *const CRL_CONTEXT) -> *mut CRL_CONTEXT;
        }
        ::std::mem::transmute(CertFindCRLInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(dwfindflags), ::std::mem::transmute(dwfindtype), ::std::mem::transmute(pvfindpara), ::std::mem::transmute(pprevcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCTLInStore(hcertstore: *const ::std::ffi::c_void, dwmsgandcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_TYPE, pvfindpara: *const ::std::ffi::c_void, pprevctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindCTLInStore(hcertstore: *const ::std::ffi::c_void, dwmsgandcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_TYPE, pvfindpara: *const ::std::ffi::c_void, pprevctlcontext: *const CTL_CONTEXT) -> *mut CTL_CONTEXT;
        }
        ::std::mem::transmute(CertFindCTLInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwmsgandcertencodingtype), ::std::mem::transmute(dwfindflags), ::std::mem::transmute(dwfindtype), ::std::mem::transmute(pvfindpara), ::std::mem::transmute(pprevctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCertificateInCRL(pcert: *const CERT_CONTEXT, pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppcrlentry: *mut *mut CRL_ENTRY) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindCertificateInCRL(pcert: *const CERT_CONTEXT, pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppcrlentry: *mut *mut CRL_ENTRY) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertFindCertificateInCRL(::std::mem::transmute(pcert), ::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved), ::std::mem::transmute(ppcrlentry)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCertificateInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_FLAGS, pvfindpara: *const ::std::ffi::c_void, pprevcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindCertificateInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_FLAGS, pvfindpara: *const ::std::ffi::c_void, pprevcertcontext: *const CERT_CONTEXT) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertFindCertificateInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(dwfindflags), ::std::mem::transmute(dwfindtype), ::std::mem::transmute(pvfindpara), ::std::mem::transmute(pprevcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindChainInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype: u32, pvfindpara: *const ::std::ffi::c_void, pprevchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindChainInStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, dwfindflags: CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype: u32, pvfindpara: *const ::std::ffi::c_void, pprevchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT;
        }
        ::std::mem::transmute(CertFindChainInStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(dwfindflags), ::std::mem::transmute(dwfindtype), ::std::mem::transmute(pvfindpara), ::std::mem::transmute(pprevchaincontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindExtension<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pszobjid: Param0, cextensions: u32, rgextensions: *const CERT_EXTENSION) -> *mut CERT_EXTENSION {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindExtension(pszobjid: super::super::Foundation::PSTR, cextensions: u32, rgextensions: *const CERT_EXTENSION) -> *mut CERT_EXTENSION;
        }
        ::std::mem::transmute(CertFindExtension(pszobjid.into_param().abi(), ::std::mem::transmute(cextensions), ::std::mem::transmute(rgextensions)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindRDNAttr<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pszobjid: Param0, pname: *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindRDNAttr(pszobjid: super::super::Foundation::PSTR, pname: *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR;
        }
        ::std::mem::transmute(CertFindRDNAttr(pszobjid.into_param().abi(), ::std::mem::transmute(pname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindSubjectInCTL(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwflags: u32) -> *mut CTL_ENTRY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindSubjectInCTL(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::std::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwflags: u32) -> *mut CTL_ENTRY;
        }
        ::std::mem::transmute(CertFindSubjectInCTL(::std::mem::transmute(dwencodingtype), ::std::mem::transmute(dwsubjecttype), ::std::mem::transmute(pvsubject), ::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindSubjectInSortedCTL(psubjectidentifier: *const CRYPTOAPI_BLOB, pctlcontext: *const CTL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pencodedattributes: *mut CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFindSubjectInSortedCTL(psubjectidentifier: *const CRYPTOAPI_BLOB, pctlcontext: *const CTL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pencodedattributes: *mut CRYPTOAPI_BLOB) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertFindSubjectInSortedCTL(::std::mem::transmute(psubjectidentifier), ::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved), ::std::mem::transmute(pencodedattributes)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCRLContext(pcrlcontext: *const CRL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCRLContext(pcrlcontext: *const CRL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertFreeCRLContext(::std::mem::transmute(pcrlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCTLContext(pctlcontext: *const CTL_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCTLContext(pctlcontext: *const CTL_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertFreeCTLContext(::std::mem::transmute(pctlcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT);
        }
        ::std::mem::transmute(CertFreeCertificateChain(::std::mem::transmute(pchaincontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertFreeCertificateChainEngine<'a, Param0: ::windows::runtime::IntoParam<'a, HCERTCHAINENGINE>>(hchainengine: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCertificateChainEngine(hchainengine: HCERTCHAINENGINE);
        }
        ::std::mem::transmute(CertFreeCertificateChainEngine(hchainengine.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateChainList(prgpselection: *const *const CERT_CHAIN_CONTEXT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCertificateChainList(prgpselection: *const *const CERT_CHAIN_CONTEXT);
        }
        ::std::mem::transmute(CertFreeCertificateChainList(::std::mem::transmute(prgpselection)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateContext(pcertcontext: *const CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeCertificateContext(pcertcontext: *const CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertFreeCertificateContext(::std::mem::transmute(pcertcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertFreeServerOcspResponseContext(pserverocspresponsecontext: *const CERT_SERVER_OCSP_RESPONSE_CONTEXT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertFreeServerOcspResponseContext(pserverocspresponsecontext: *const CERT_SERVER_OCSP_RESPONSE_CONTEXT);
        }
        ::std::mem::transmute(CertFreeServerOcspResponseContext(::std::mem::transmute(pserverocspresponsecontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetCRLContextProperty(::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(pvdata), ::std::mem::transmute(pcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCRLFromStore(hcertstore: *const ::std::ffi::c_void, pissuercontext: *const CERT_CONTEXT, pprevcrlcontext: *const CRL_CONTEXT, pdwflags: *mut u32) -> *mut CRL_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetCRLFromStore(hcertstore: *const ::std::ffi::c_void, pissuercontext: *const CERT_CONTEXT, pprevcrlcontext: *const CRL_CONTEXT, pdwflags: *mut u32) -> *mut CRL_CONTEXT;
        }
        ::std::mem::transmute(CertGetCRLFromStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(pissuercontext), ::std::mem::transmute(pprevcrlcontext), ::std::mem::transmute(pdwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetCTLContextProperty(::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(pvdata), ::std::mem::transmute(pcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCertificateChain<'a, Param0: ::windows::runtime::IntoParam<'a, HCERTCHAINENGINE>>(hchainengine: Param0, pcertcontext: *const CERT_CONTEXT, ptime: *const super::super::Foundation::FILETIME, hadditionalstore: *const ::std::ffi::c_void, pchainpara: *const CERT_CHAIN_PARA, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppchaincontext: *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetCertificateChain(hchainengine: HCERTCHAINENGINE, pcertcontext: *const CERT_CONTEXT, ptime: *const super::super::Foundation::FILETIME, hadditionalstore: *const ::std::ffi::c_void, pchainpara: *const CERT_CHAIN_PARA, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppchaincontext: *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetCertificateChain(
            hchainengine.into_param().abi(),
            ::std::mem::transmute(pcertcontext),
            ::std::mem::transmute(ptime),
            ::std::mem::transmute(hadditionalstore),
            ::std::mem::transmute(pchainpara),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pvreserved),
            ::std::mem::transmute(ppchaincontext),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetCertificateContextProperty(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(pvdata), ::std::mem::transmute(pcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pusage: *mut CTL_USAGE, pcbusage: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pusage: *mut CTL_USAGE, pcbusage: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetEnhancedKeyUsage(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pusage), ::std::mem::transmute(pcbusage)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetIntendedKeyUsage(dwcertencodingtype: u32, pcertinfo: *const CERT_INFO, pbkeyusage: *mut u8, cbkeyusage: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetIntendedKeyUsage(dwcertencodingtype: u32, pcertinfo: *const CERT_INFO, pbkeyusage: *mut u8, cbkeyusage: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetIntendedKeyUsage(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pcertinfo), ::std::mem::transmute(pbkeyusage), ::std::mem::transmute(cbkeyusage)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetIssuerCertificateFromStore(hcertstore: *const ::std::ffi::c_void, psubjectcontext: *const CERT_CONTEXT, pprevissuercontext: *const CERT_CONTEXT, pdwflags: *mut u32) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetIssuerCertificateFromStore(hcertstore: *const ::std::ffi::c_void, psubjectcontext: *const CERT_CONTEXT, pprevissuercontext: *const CERT_CONTEXT, pdwflags: *mut u32) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertGetIssuerCertificateFromStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(psubjectcontext), ::std::mem::transmute(pprevissuercontext), ::std::mem::transmute(pdwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetNameStringA(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: *const ::std::ffi::c_void, psznamestring: super::super::Foundation::PSTR, cchnamestring: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetNameStringA(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: *const ::std::ffi::c_void, psznamestring: super::super::Foundation::PSTR, cchnamestring: u32) -> u32;
        }
        ::std::mem::transmute(CertGetNameStringA(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwtype), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvtypepara), ::std::mem::transmute(psznamestring), ::std::mem::transmute(cchnamestring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetNameStringW(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: *const ::std::ffi::c_void, psznamestring: super::super::Foundation::PWSTR, cchnamestring: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetNameStringW(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: *const ::std::ffi::c_void, psznamestring: super::super::Foundation::PWSTR, cchnamestring: u32) -> u32;
        }
        ::std::mem::transmute(CertGetNameStringW(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwtype), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvtypepara), ::std::mem::transmute(psznamestring), ::std::mem::transmute(cchnamestring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetPublicKeyLength(dwcertencodingtype: u32, ppublickey: *const CERT_PUBLIC_KEY_INFO) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetPublicKeyLength(dwcertencodingtype: u32, ppublickey: *const CERT_PUBLIC_KEY_INFO) -> u32;
        }
        ::std::mem::transmute(CertGetPublicKeyLength(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(ppublickey)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertGetServerOcspResponseContext(hserverocspresponse: *const ::std::ffi::c_void, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetServerOcspResponseContext(hserverocspresponse: *const ::std::ffi::c_void, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT;
        }
        ::std::mem::transmute(CertGetServerOcspResponseContext(::std::mem::transmute(hserverocspresponse), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetStoreProperty(hcertstore: *const ::std::ffi::c_void, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetStoreProperty(hcertstore: *const ::std::ffi::c_void, dwpropid: u32, pvdata: *mut ::std::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetStoreProperty(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwpropid), ::std::mem::transmute(pvdata), ::std::mem::transmute(pcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetSubjectCertificateFromStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pcertid: *const CERT_INFO) -> *mut CERT_CONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetSubjectCertificateFromStore(hcertstore: *const ::std::ffi::c_void, dwcertencodingtype: u32, pcertid: *const CERT_INFO) -> *mut CERT_CONTEXT;
        }
        ::std::mem::transmute(CertGetSubjectCertificateFromStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pcertid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetValidUsages(ccerts: u32, rghcerts: *const *const CERT_CONTEXT, cnumoids: *mut i32, rghoids: *mut super::super::Foundation::PSTR, pcboids: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertGetValidUsages(ccerts: u32, rghcerts: *const *const CERT_CONTEXT, cnumoids: *mut i32, rghoids: *mut super::super::Foundation::PSTR, pcboids: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertGetValidUsages(::std::mem::transmute(ccerts), ::std::mem::transmute(rghcerts), ::std::mem::transmute(cnumoids), ::std::mem::transmute(rghoids), ::std::mem::transmute(pcboids)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsRDNAttrsInCertificateName(dwcertencodingtype: u32, dwflags: u32, pcertname: *const CRYPTOAPI_BLOB, prdn: *const CERT_RDN) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertIsRDNAttrsInCertificateName(dwcertencodingtype: u32, dwflags: u32, pcertname: *const CRYPTOAPI_BLOB, prdn: *const CERT_RDN) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertIsRDNAttrsInCertificateName(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(dwflags), ::std::mem::transmute(pcertname), ::std::mem::transmute(prdn)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsStrongHashToSign<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pstrongsignpara: *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid: Param1, psigningcert: *const CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertIsStrongHashToSign(pstrongsignpara: *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid: super::super::Foundation::PWSTR, psigningcert: *const CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertIsStrongHashToSign(::std::mem::transmute(pstrongsignpara), pwszcnghashalgid.into_param().abi(), ::std::mem::transmute(psigningcert)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsValidCRLForCertificate(pcert: *const CERT_CONTEXT, pcrl: *const CRL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertIsValidCRLForCertificate(pcert: *const CERT_CONTEXT, pcrl: *const CRL_CONTEXT, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertIsValidCRLForCertificate(::std::mem::transmute(pcert), ::std::mem::transmute(pcrl), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsWeakHash<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwhashusetype: u32, pwszcnghashalgid: Param1, dwchainflags: u32, psignerchaincontext: *const CERT_CHAIN_CONTEXT, ptimestamp: *const super::super::Foundation::FILETIME, pwszfilename: Param5) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertIsWeakHash(dwhashusetype: u32, pwszcnghashalgid: super::super::Foundation::PWSTR, dwchainflags: u32, psignerchaincontext: *const CERT_CHAIN_CONTEXT, ptimestamp: *const super::super::Foundation::FILETIME, pwszfilename: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertIsWeakHash(::std::mem::transmute(dwhashusetype), pwszcnghashalgid.into_param().abi(), ::std::mem::transmute(dwchainflags), ::std::mem::transmute(psignerchaincontext), ::std::mem::transmute(ptimestamp), pwszfilename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CertKeyType(pub u32);
pub const KeyTypeOther: CertKeyType = CertKeyType(0u32);
pub const KeyTypeVirtualSmartCard: CertKeyType = CertKeyType(1u32);
pub const KeyTypePhysicalSmartCard: CertKeyType = CertKeyType(2u32);
pub const KeyTypePassport: CertKeyType = CertKeyType(3u32);
pub const KeyTypePassportRemote: CertKeyType = CertKeyType(4u32);
pub const KeyTypePassportSmartCard: CertKeyType = CertKeyType(5u32);
pub const KeyTypeHardware: CertKeyType = CertKeyType(6u32);
pub const KeyTypeSoftware: CertKeyType = CertKeyType(7u32);
pub const KeyTypeSelfSigned: CertKeyType = CertKeyType(8u32);
impl ::std::convert::From<u32> for CertKeyType {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CertKeyType {
    type Abi = Self;
}
impl ::std::ops::BitOr for CertKeyType {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for CertKeyType {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for CertKeyType {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for CertKeyType {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for CertKeyType {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertNameToStrA(dwcertencodingtype: u32, pname: *const CRYPTOAPI_BLOB, dwstrtype: CERT_STRING_TYPE, psz: super::super::Foundation::PSTR, csz: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertNameToStrA(dwcertencodingtype: u32, pname: *const CRYPTOAPI_BLOB, dwstrtype: CERT_STRING_TYPE, psz: super::super::Foundation::PSTR, csz: u32) -> u32;
        }
        ::std::mem::transmute(CertNameToStrA(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pname), ::std::mem::transmute(dwstrtype), ::std::mem::transmute(psz), ::std::mem::transmute(csz)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertNameToStrW(dwcertencodingtype: u32, pname: *const CRYPTOAPI_BLOB, dwstrtype: CERT_STRING_TYPE, psz: super::super::Foundation::PWSTR, csz: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertNameToStrW(dwcertencodingtype: u32, pname: *const CRYPTOAPI_BLOB, dwstrtype: CERT_STRING_TYPE, psz: super::super::Foundation::PWSTR, csz: u32) -> u32;
        }
        ::std::mem::transmute(CertNameToStrW(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pname), ::std::mem::transmute(dwstrtype), ::std::mem::transmute(psz), ::std::mem::transmute(csz)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOIDToAlgId<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pszobjid: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertOIDToAlgId(pszobjid: super::super::Foundation::PSTR) -> u32;
        }
        ::std::mem::transmute(CertOIDToAlgId(pszobjid.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOpenServerOcspResponse(pchaincontext: *const CERT_CHAIN_CONTEXT, dwflags: u32, popenpara: *const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertOpenServerOcspResponse(pchaincontext: *const CERT_CHAIN_CONTEXT, dwflags: u32, popenpara: *const ::std::mem::ManuallyDrop<CERT_SERVER_OCSP_RESPONSE_OPEN_PARA>) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertOpenServerOcspResponse(::std::mem::transmute(pchaincontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(popenpara)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOpenStore<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(lpszstoreprovider: Param0, dwencodingtype: CERT_QUERY_ENCODING_TYPE, hcryptprov: usize, dwflags: CERT_OPEN_STORE_FLAGS, pvpara: *const ::std::ffi::c_void) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertOpenStore(lpszstoreprovider: super::super::Foundation::PSTR, dwencodingtype: CERT_QUERY_ENCODING_TYPE, hcryptprov: usize, dwflags: CERT_OPEN_STORE_FLAGS, pvpara: *const ::std::ffi::c_void) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertOpenStore(lpszstoreprovider.into_param().abi(), ::std::mem::transmute(dwencodingtype), ::std::mem::transmute(hcryptprov), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvpara)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOpenSystemStoreA<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(hprov: usize, szsubsystemprotocol: Param1) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertOpenSystemStoreA(hprov: usize, szsubsystemprotocol: super::super::Foundation::PSTR) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertOpenSystemStoreA(::std::mem::transmute(hprov), szsubsystemprotocol.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOpenSystemStoreW<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hprov: usize, szsubsystemprotocol: Param1) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertOpenSystemStoreW(hprov: usize, szsubsystemprotocol: super::super::Foundation::PWSTR) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(CertOpenSystemStoreW(::std::mem::transmute(hprov), szsubsystemprotocol.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRDNValueToStrA(dwvaluetype: u32, pvalue: *const CRYPTOAPI_BLOB, psz: super::super::Foundation::PSTR, csz: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRDNValueToStrA(dwvaluetype: u32, pvalue: *const CRYPTOAPI_BLOB, psz: super::super::Foundation::PSTR, csz: u32) -> u32;
        }
        ::std::mem::transmute(CertRDNValueToStrA(::std::mem::transmute(dwvaluetype), ::std::mem::transmute(pvalue), ::std::mem::transmute(psz), ::std::mem::transmute(csz)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRDNValueToStrW(dwvaluetype: u32, pvalue: *const CRYPTOAPI_BLOB, psz: super::super::Foundation::PWSTR, csz: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRDNValueToStrW(dwvaluetype: u32, pvalue: *const CRYPTOAPI_BLOB, psz: super::super::Foundation::PWSTR, csz: u32) -> u32;
        }
        ::std::mem::transmute(CertRDNValueToStrW(::std::mem::transmute(dwvaluetype), ::std::mem::transmute(pvalue), ::std::mem::transmute(psz), ::std::mem::transmute(csz)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRegisterPhysicalStore<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pwszstorename: Param2, pstoreinfo: *const CERT_PHYSICAL_STORE_INFO, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRegisterPhysicalStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pwszstorename: super::super::Foundation::PWSTR, pstoreinfo: *const CERT_PHYSICAL_STORE_INFO, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertRegisterPhysicalStore(::std::mem::transmute(pvsystemstore), ::std::mem::transmute(dwflags), pwszstorename.into_param().abi(), ::std::mem::transmute(pstoreinfo), ::std::mem::transmute(pvreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRegisterSystemStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pstoreinfo: *const CERT_SYSTEM_STORE_INFO, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRegisterSystemStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pstoreinfo: *const CERT_SYSTEM_STORE_INFO, pvreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertRegisterSystemStore(::std::mem::transmute(pvsystemstore), ::std::mem::transmute(dwflags), ::std::mem::transmute(pstoreinfo), ::std::mem::transmute(pvreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRemoveEnhancedKeyUsageIdentifier<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: Param1) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRemoveEnhancedKeyUsageIdentifier(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: super::super::Foundation::PSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertRemoveEnhancedKeyUsageIdentifier(::std::mem::transmute(pcertcontext), pszusageidentifier.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CertRemoveStoreFromCollection(hcollectionstore: *const ::std::ffi::c_void, hsiblingstore: *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRemoveStoreFromCollection(hcollectionstore: *const ::std::ffi::c_void, hsiblingstore: *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(CertRemoveStoreFromCollection(::std::mem::transmute(hcollectionstore), ::std::mem::transmute(hsiblingstore)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertResyncCertificateChainEngine<'a, Param0: ::windows::runtime::IntoParam<'a, HCERTCHAINENGINE>>(hchainengine: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertResyncCertificateChainEngine(hchainengine: HCERTCHAINENGINE) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertResyncCertificateChainEngine(hchainengine.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRetrieveLogoOrBiometricInfo<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pcertcontext: *const CERT_CONTEXT, lpszlogoorbiometrictype: Param1, dwretrievalflags: u32, dwtimeout: u32, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppbdata: *mut *mut u8, pcbdata: *mut u32, ppwszmimetype: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertRetrieveLogoOrBiometricInfo(pcertcontext: *const CERT_CONTEXT, lpszlogoorbiometrictype: super::super::Foundation::PSTR, dwretrievalflags: u32, dwtimeout: u32, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, ppbdata: *mut *mut u8, pcbdata: *mut u32, ppwszmimetype: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertRetrieveLogoOrBiometricInfo(
            ::std::mem::transmute(pcertcontext),
            lpszlogoorbiometrictype.into_param().abi(),
            ::std::mem::transmute(dwretrievalflags),
            ::std::mem::transmute(dwtimeout),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pvreserved),
            ::std::mem::transmute(ppbdata),
            ::std::mem::transmute(pcbdata),
            ::std::mem::transmute(ppwszmimetype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSaveStore(hcertstore: *const ::std::ffi::c_void, dwencodingtype: CERT_QUERY_ENCODING_TYPE, dwsaveas: CERT_STORE_SAVE_AS, dwsaveto: CERT_STORE_SAVE_TO, pvsavetopara: *mut ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSaveStore(hcertstore: *const ::std::ffi::c_void, dwencodingtype: CERT_QUERY_ENCODING_TYPE, dwsaveas: CERT_STORE_SAVE_AS, dwsaveto: CERT_STORE_SAVE_TO, pvsavetopara: *mut ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSaveStore(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwencodingtype), ::std::mem::transmute(dwsaveas), ::std::mem::transmute(dwsaveto), ::std::mem::transmute(pvsavetopara), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSelectCertificateChains(pselectioncontext: *const ::windows::runtime::GUID, dwflags: u32, pchainparameters: *const CERT_SELECT_CHAIN_PARA, ccriteria: u32, rgpcriteria: *const CERT_SELECT_CRITERIA, hstore: *const ::std::ffi::c_void, pcselection: *mut u32, pprgpselection: *mut *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSelectCertificateChains(pselectioncontext: *const ::windows::runtime::GUID, dwflags: u32, pchainparameters: *const CERT_SELECT_CHAIN_PARA, ccriteria: u32, rgpcriteria: *const CERT_SELECT_CRITERIA, hstore: *const ::std::ffi::c_void, pcselection: *mut u32, pprgpselection: *mut *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSelectCertificateChains(
            ::std::mem::transmute(pselectioncontext),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pchainparameters),
            ::std::mem::transmute(ccriteria),
            ::std::mem::transmute(rgpcriteria),
            ::std::mem::transmute(hstore),
            ::std::mem::transmute(pcselection),
            ::std::mem::transmute(pprgpselection),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSelectionGetSerializedBlob(pcsi: *const CERT_SELECTUI_INPUT, ppoutbuffer: *mut *mut ::std::ffi::c_void, puloutbuffersize: *mut u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSelectionGetSerializedBlob(pcsi: *const CERT_SELECTUI_INPUT, ppoutbuffer: *mut *mut ::std::ffi::c_void, puloutbuffersize: *mut u32) -> ::windows::runtime::HRESULT;
        }
        CertSelectionGetSerializedBlob(::std::mem::transmute(pcsi), ::std::mem::transmute(ppoutbuffer), ::std::mem::transmute(puloutbuffersize)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCRLStoreElement(pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSerializeCRLStoreElement(pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSerializeCRLStoreElement(::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pbelement), ::std::mem::transmute(pcbelement)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCTLStoreElement(pctlcontext: *const CTL_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSerializeCTLStoreElement(pctlcontext: *const CTL_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSerializeCTLStoreElement(::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pbelement), ::std::mem::transmute(pcbelement)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCertificateStoreElement(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSerializeCertificateStoreElement(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pbelement: *mut u8, pcbelement: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSerializeCertificateStoreElement(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(pbelement), ::std::mem::transmute(pcbelement)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetCRLContextProperty(::std::mem::transmute(pcrlcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetCTLContextProperty(::std::mem::transmute(pctlcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext: *const CERT_CONTEXT, pctlentry: *const CTL_ENTRY, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext: *const CERT_CONTEXT, pctlentry: *const CTL_ENTRY, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetCertificateContextPropertiesFromCTLEntry(::std::mem::transmute(pcertcontext), ::std::mem::transmute(pctlentry), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetCertificateContextProperty(::std::mem::transmute(pcertcontext), ::std::mem::transmute(dwpropid), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, pusage: *const CTL_USAGE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, pusage: *const CTL_USAGE) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetEnhancedKeyUsage(::std::mem::transmute(pcertcontext), ::std::mem::transmute(pusage)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetStoreProperty(hcertstore: *const ::std::ffi::c_void, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertSetStoreProperty(hcertstore: *const ::std::ffi::c_void, dwpropid: u32, dwflags: u32, pvdata: *const ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertSetStoreProperty(::std::mem::transmute(hcertstore), ::std::mem::transmute(dwpropid), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertStrToNameA<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(dwcertencodingtype: u32, pszx500: Param1, dwstrtype: CERT_STRING_TYPE, pvreserved: *mut ::std::ffi::c_void, pbencoded: *mut u8, pcbencoded: *mut u32, ppszerror: *mut super::super::Foundation::PSTR) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertStrToNameA(dwcertencodingtype: u32, pszx500: super::super::Foundation::PSTR, dwstrtype: CERT_STRING_TYPE, pvreserved: *mut ::std::ffi::c_void, pbencoded: *mut u8, pcbencoded: *mut u32, ppszerror: *mut super::super::Foundation::PSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertStrToNameA(::std::mem::transmute(dwcertencodingtype), pszx500.into_param().abi(), ::std::mem::transmute(dwstrtype), ::std::mem::transmute(pvreserved), ::std::mem::transmute(pbencoded), ::std::mem::transmute(pcbencoded), ::std::mem::transmute(ppszerror)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertStrToNameW<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(dwcertencodingtype: u32, pszx500: Param1, dwstrtype: CERT_STRING_TYPE, pvreserved: *mut ::std::ffi::c_void, pbencoded: *mut u8, pcbencoded: *mut u32, ppszerror: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertStrToNameW(dwcertencodingtype: u32, pszx500: super::super::Foundation::PWSTR, dwstrtype: CERT_STRING_TYPE, pvreserved: *mut ::std::ffi::c_void, pbencoded: *mut u8, pcbencoded: *mut u32, ppszerror: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertStrToNameW(::std::mem::transmute(dwcertencodingtype), pszx500.into_param().abi(), ::std::mem::transmute(dwstrtype), ::std::mem::transmute(pvreserved), ::std::mem::transmute(pbencoded), ::std::mem::transmute(pcbencoded), ::std::mem::transmute(ppszerror)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertUnregisterPhysicalStore<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pwszstorename: Param2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertUnregisterPhysicalStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32, pwszstorename: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertUnregisterPhysicalStore(::std::mem::transmute(pvsystemstore), ::std::mem::transmute(dwflags), pwszstorename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertUnregisterSystemStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertUnregisterSystemStore(pvsystemstore: *const ::std::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertUnregisterSystemStore(::std::mem::transmute(pvsystemstore), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCRLRevocation(dwcertencodingtype: u32, pcertid: *const CERT_INFO, ccrlinfo: u32, rgpcrlinfo: *const *const CRL_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyCRLRevocation(dwcertencodingtype: u32, pcertid: *const CERT_INFO, ccrlinfo: u32, rgpcrlinfo: *const *const CRL_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifyCRLRevocation(::std::mem::transmute(dwcertencodingtype), ::std::mem::transmute(pcertid), ::std::mem::transmute(ccrlinfo), ::std::mem::transmute(rgpcrlinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCRLTimeValidity(ptimetoverify: *const super::super::Foundation::FILETIME, pcrlinfo: *const CRL_INFO) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyCRLTimeValidity(ptimetoverify: *const super::super::Foundation::FILETIME, pcrlinfo: *const CRL_INFO) -> i32;
        }
        ::std::mem::transmute(CertVerifyCRLTimeValidity(::std::mem::transmute(ptimetoverify), ::std::mem::transmute(pcrlinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCTLUsage(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::std::ffi::c_void, psubjectusage: *const CTL_USAGE, dwflags: u32, pverifyusagepara: *const CTL_VERIFY_USAGE_PARA, pverifyusagestatus: *mut CTL_VERIFY_USAGE_STATUS) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyCTLUsage(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::std::ffi::c_void, psubjectusage: *const CTL_USAGE, dwflags: u32, pverifyusagepara: *const CTL_VERIFY_USAGE_PARA, pverifyusagestatus: *mut CTL_VERIFY_USAGE_STATUS) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifyCTLUsage(::std::mem::transmute(dwencodingtype), ::std::mem::transmute(dwsubjecttype), ::std::mem::transmute(pvsubject), ::std::mem::transmute(psubjectusage), ::std::mem::transmute(dwflags), ::std::mem::transmute(pverifyusagepara), ::std::mem::transmute(pverifyusagestatus)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCertificateChainPolicy<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(pszpolicyoid: Param0, pchaincontext: *const CERT_CHAIN_CONTEXT, ppolicypara: *const CERT_CHAIN_POLICY_PARA, ppolicystatus: *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyCertificateChainPolicy(pszpolicyoid: super::super::Foundation::PSTR, pchaincontext: *const CERT_CHAIN_CONTEXT, ppolicypara: *const CERT_CHAIN_POLICY_PARA, ppolicystatus: *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifyCertificateChainPolicy(pszpolicyoid.into_param().abi(), ::std::mem::transmute(pchaincontext), ::std::mem::transmute(ppolicypara), ::std::mem::transmute(ppolicystatus)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyRevocation(dwencodingtype: u32, dwrevtype: u32, ccontext: u32, rgpvcontext: *const *const ::std::ffi::c_void, dwflags: u32, prevpara: *const CERT_REVOCATION_PARA, prevstatus: *mut CERT_REVOCATION_STATUS) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyRevocation(dwencodingtype: u32, dwrevtype: u32, ccontext: u32, rgpvcontext: *const *const ::std::ffi::c_void, dwflags: u32, prevpara: *const CERT_REVOCATION_PARA, prevstatus: *mut CERT_REVOCATION_STATUS) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifyRevocation(::std::mem::transmute(dwencodingtype), ::std::mem::transmute(dwrevtype), ::std::mem::transmute(ccontext), ::std::mem::transmute(rgpvcontext), ::std::mem::transmute(dwflags), ::std::mem::transmute(prevpara), ::std::mem::transmute(prevstatus)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifySubjectCertificateContext(psubject: *const CERT_CONTEXT, pissuer: *const CERT_CONTEXT, pdwflags: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifySubjectCertificateContext(psubject: *const CERT_CONTEXT, pissuer: *const CERT_CONTEXT, pdwflags: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifySubjectCertificateContext(::std::mem::transmute(psubject), ::std::mem::transmute(pissuer), ::std::mem::transmute(pdwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyTimeValidity(ptimetoverify: *const super::super::Foundation::FILETIME, pcertinfo: *const CERT_INFO) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyTimeValidity(ptimetoverify: *const super::super::Foundation::FILETIME, pcertinfo: *const CERT_INFO) -> i32;
        }
        ::std::mem::transmute(CertVerifyTimeValidity(::std::mem::transmute(ptimetoverify), ::std::mem::transmute(pcertinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyValidityNesting(psubjectinfo: *const CERT_INFO, pissuerinfo: *const CERT_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CertVerifyValidityNesting(psubjectinfo: *const CERT_INFO, pissuerinfo: *const CERT_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CertVerifyValidityNesting(::std::mem::transmute(psubjectinfo), ::std::mem::transmute(pissuerinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`*"]
#[inline]
pub unsafe fn CloseCryptoHandle(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseCryptoHandle(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows::runtime::HRESULT;
        }
        CloseCryptoHandle(::std::mem::transmute(hcrypto)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireCertificatePrivateKey(pcert: *const CERT_CONTEXT, dwflags: CRYPT_ACQUIRE_FLAGS, pvparameters: *const ::std::ffi::c_void, phcryptprovorncryptkey: *mut usize, pdwkeyspec: *mut CERT_KEY_SPEC, pfcallerfreeprovorncryptkey: *mut super::super::Foundation::BOOL) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptAcquireCertificatePrivateKey(pcert: *const CERT_CONTEXT, dwflags: CRYPT_ACQUIRE_FLAGS, pvparameters: *const ::std::ffi::c_void, phcryptprovorncryptkey: *mut usize, pdwkeyspec: *mut CERT_KEY_SPEC, pfcallerfreeprovorncryptkey: *mut super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptAcquireCertificatePrivateKey(::std::mem::transmute(pcert), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvparameters), ::std::mem::transmute(phcryptprovorncryptkey), ::std::mem::transmute(pdwkeyspec), ::std::mem::transmute(pfcallerfreeprovorncryptkey)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireContextA<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(phprov: *mut usize, szcontainer: Param1, szprovider: Param2, dwprovtype: u32, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptAcquireContextA(phprov: *mut usize, szcontainer: super::super::Foundation::PSTR, szprovider: super::super::Foundation::PSTR, dwprovtype: u32, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptAcquireContextA(::std::mem::transmute(phprov), szcontainer.into_param().abi(), szprovider.into_param().abi(), ::std::mem::transmute(dwprovtype), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireContextW<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(phprov: *mut usize, szcontainer: Param1, szprovider: Param2, dwprovtype: u32, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptAcquireContextW(phprov: *mut usize, szcontainer: super::super::Foundation::PWSTR, szprovider: super::super::Foundation::PWSTR, dwprovtype: u32, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptAcquireContextW(::std::mem::transmute(phprov), szcontainer.into_param().abi(), szprovider.into_param().abi(), ::std::mem::transmute(dwprovtype), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptBinaryToStringA(pbbinary: *const u8, cbbinary: u32, dwflags: CRYPT_STRING, pszstring: super::super::Foundation::PSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptBinaryToStringA(pbbinary: *const u8, cbbinary: u32, dwflags: CRYPT_STRING, pszstring: super::super::Foundation::PSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptBinaryToStringA(::std::mem::transmute(pbbinary), ::std::mem::transmute(cbbinary), ::std::mem::transmute(dwflags), ::std::mem::transmute(pszstring), ::std::mem::transmute(pcchstring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptBinaryToStringW(pbbinary: *const u8, cbbinary: u32, dwflags: CRYPT_STRING, pszstring: super::super::Foundation::PWSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptBinaryToStringW(pbbinary: *const u8, cbbinary: u32, dwflags: CRYPT_STRING, pszstring: super::super::Foundation::PWSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptBinaryToStringW(::std::mem::transmute(pbbinary), ::std::mem::transmute(cbbinary), ::std::mem::transmute(dwflags), ::std::mem::transmute(pszstring), ::std::mem::transmute(pcchstring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCloseAsyncHandle<'a, Param0: ::windows::runtime::IntoParam<'a, HCRYPTASYNC>>(hasync: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptCloseAsyncHandle(hasync: HCRYPTASYNC) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptCloseAsyncHandle(hasync.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptContextAddRef(hprov: usize, pdwreserved: *mut u32, dwflags: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptContextAddRef(hprov: usize, pdwreserved: *mut u32, dwflags: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptContextAddRef(::std::mem::transmute(hprov), ::std::mem::transmute(pdwreserved), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateAsyncHandle(dwflags: u32, phasync: *mut HCRYPTASYNC) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptCreateAsyncHandle(dwflags: u32, phasync: *mut HCRYPTASYNC) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptCreateAsyncHandle(::std::mem::transmute(dwflags), ::std::mem::transmute(phasync)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateHash(hprov: usize, algid: u32, hkey: usize, dwflags: u32, phhash: *mut usize) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptCreateHash(hprov: usize, algid: u32, hkey: usize, dwflags: u32, phhash: *mut usize) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptCreateHash(::std::mem::transmute(hprov), ::std::mem::transmute(algid), ::std::mem::transmute(hkey), ::std::mem::transmute(dwflags), ::std::mem::transmute(phhash)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateKeyIdentifierFromCSP<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(dwcertencodingtype: u32, pszpubkeyoid: Param1, ppubkeystruc: *const PUBLICKEYSTRUC, cbpubkeystruc: u32, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pbhash: *mut u8, pcbhash: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptCreateKeyIdentifierFromCSP(dwcertencodingtype: u32, pszpubkeyoid: super::super::Foundation::PSTR, ppubkeystruc: *const PUBLICKEYSTRUC, cbpubkeystruc: u32, dwflags: u32, pvreserved: *mut ::std::ffi::c_void, pbhash: *mut u8, pcbhash: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptCreateKeyIdentifierFromCSP(
            ::std::mem::transmute(dwcertencodingtype),
            pszpubkeyoid.into_param().abi(),
            ::std::mem::transmute(ppubkeystruc),
            ::std::mem::transmute(cbpubkeystruc),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pvreserved),
            ::std::mem::transmute(pbhash),
            ::std::mem::transmute(pcbhash),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeMessage(dwmsgtypeflags: u32, pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbencodedblob: *const u8, cbencodedblob: u32, dwprevinnercontenttype: u32, pdwmsgtype: *mut u32, pdwinnercontenttype: *mut u32, pbdecoded: *mut u8, pcbdecoded: *mut u32, ppxchgcert: *mut *mut CERT_CONTEXT, ppsignercert: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptDecodeMessage(dwmsgtypeflags: u32, pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara: *const ::std::mem::ManuallyDrop<CRYPT_VERIFY_MESSAGE_PARA>, dwsignerindex: u32, pbencodedblob: *const u8, cbencodedblob: u32, dwprevinnercontenttype: u32, pdwmsgtype: *mut u32, pdwinnercontenttype: *mut u32, pbdecoded: *mut u8, pcbdecoded: *mut u32, ppxchgcert: *mut *mut CERT_CONTEXT, ppsignercert: *mut *mut CERT_CONTEXT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptDecodeMessage(
            ::std::mem::transmute(dwmsgtypeflags),
            ::std::mem::transmute(pdecryptpara),
            ::std::mem::transmute(pverifypara),
            ::std::mem::transmute(dwsignerindex),
            ::std::mem::transmute(pbencodedblob),
            ::std::mem::transmute(cbencodedblob),
            ::std::mem::transmute(dwprevinnercontenttype),
            ::std::mem::transmute(pdwmsgtype),
            ::std::mem::transmute(pdwinnercontenttype),
            ::std::mem::transmute(pbdecoded),
            ::std::mem::transmute(pcbdecoded),
            ::std::mem::transmute(ppxchgcert),
            ::std::mem::transmute(ppsignercert),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeObject<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(dwcertencodingtype: u32, lpszstructtype: Param1, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pvstructinfo: *mut ::std::ffi::c_void, pcbstructinfo: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptDecodeObject(dwcertencodingtype: u32, lpszstructtype: super::super::Foundation::PSTR, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pvstructinfo: *mut ::std::ffi::c_void, pcbstructinfo: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptDecodeObject(::std::mem::transmute(dwcertencodingtype), lpszstructtype.into_param().abi(), ::std::mem::transmute(pbencoded), ::std::mem::transmute(cbencoded), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvstructinfo), ::std::mem::transmute(pcbstructinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeObjectEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>>(dwcertencodingtype: u32, lpszstructtype: Param1, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pdecodepara: *const CRYPT_DECODE_PARA, pvstructinfo: *mut ::std::ffi::c_void, pcbstructinfo: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptDecodeObjectEx(dwcertencodingtype: u32, lpszstructtype: super::super::Foundation::PSTR, pbencoded: *const u8, cbencoded: u32, dwflags: u32, pdecodepara: *const ::std::mem::ManuallyDrop<CRYPT_DECODE_PARA>, pvstructinfo: *mut ::std::ffi::c_void, pcbstructinfo: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptDecodeObjectEx(
            ::std::mem::transmute(dwcertencodingtype),
            lpszstructtype.into_param().abi(),
            ::std::mem::transmute(pbencoded),
            ::std::mem::transmute(cbencoded),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pdecodepara),
            ::std::mem::transmute(pvstructinfo),
            ::std::mem::transmute(pcbstructinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecrypt<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(hkey: usize, hhash: usize, r#final: Param2, dwflags: u32, pbdata: *mut u8, pdwdatalen: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CryptDecrypt(hkey: usize, hhash: usize, r#final: super::super::Foundation::BOOL, dwflags: u32, pbdata: *mut u8, pdwdatalen: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CryptDecrypt(::std::mem::transmute(hkey), ::std::mem::transmute(hhash), r#final.into_param().abi(), ::std::mem::transmute(dwflags), ::std::mem::transmute(pbdata), ::std::mem::transmute(pdwdatalen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Security_Cryptography`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecryptAndVerifyMessageSignature(pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbencryptedb