#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_MODE_FULL_DUPLEX: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_MODE_HALF_DUPLEX: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_MODE_PASS_THROUGH: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_STATUS_FD_CURRENTLY_CONVERGED: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_STATUS_FD_HISTORY_CONTINUOUSLY_CONVERGED: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_STATUS_FD_HISTORY_PREVIOUSLY_DIVERGED: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AEC_STATUS_FD_HISTORY_UNINITIALIZED: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMBISONICS_CHANNEL_ORDERING(pub i32);
pub const AMBISONICS_CHANNEL_ORDERING_ACN: AMBISONICS_CHANNEL_ORDERING = AMBISONICS_CHANNEL_ORDERING(0i32);
impl ::std::convert::From<i32> for AMBISONICS_CHANNEL_ORDERING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMBISONICS_CHANNEL_ORDERING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMBISONICS_NORMALIZATION(pub i32);
pub const AMBISONICS_NORMALIZATION_SN3D: AMBISONICS_NORMALIZATION = AMBISONICS_NORMALIZATION(0i32);
pub const AMBISONICS_NORMALIZATION_N3D: AMBISONICS_NORMALIZATION = AMBISONICS_NORMALIZATION(1i32);
impl ::std::convert::From<i32> for AMBISONICS_NORMALIZATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMBISONICS_NORMALIZATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AMBISONICS_PARAMS {
    pub u32Size: u32,
    pub u32Version: u32,
    pub u32Type: AMBISONICS_TYPE,
    pub u32ChannelOrdering: AMBISONICS_CHANNEL_ORDERING,
    pub u32Normalization: AMBISONICS_NORMALIZATION,
    pub u32Order: u32,
    pub u32NumChannels: u32,
    pub pu32ChannelMap: *mut u32,
}
impl AMBISONICS_PARAMS {}
impl ::std::default::Default for AMBISONICS_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMBISONICS_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMBISONICS_PARAMS")
            .field("u32Size", &self.u32Size)
            .field("u32Version", &self.u32Version)
            .field("u32Type", &self.u32Type)
            .field("u32ChannelOrdering", &self.u32ChannelOrdering)
            .field("u32Normalization", &self.u32Normalization)
            .field("u32Order", &self.u32Order)
            .field("u32NumChannels", &self.u32NumChannels)
            .field("pu32ChannelMap", &self.pu32ChannelMap)
            .finish()
    }
}
impl ::std::cmp::PartialEq for AMBISONICS_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.u32Size == other.u32Size && self.u32Version == other.u32Version && self.u32Type == other.u32Type && self.u32ChannelOrdering == other.u32ChannelOrdering && self.u32Normalization == other.u32Normalization && self.u32Order == other.u32Order && self.u32NumChannels == other.u32NumChannels && self.pu32ChannelMap == other.pu32ChannelMap
    }
}
impl ::std::cmp::Eq for AMBISONICS_PARAMS {}
unsafe impl ::windows::runtime::Abi for AMBISONICS_PARAMS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AMBISONICS_PARAM_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMBISONICS_TYPE(pub i32);
pub const AMBISONICS_TYPE_FULL3D: AMBISONICS_TYPE = AMBISONICS_TYPE(0i32);
impl ::std::convert::From<i32> for AMBISONICS_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMBISONICS_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_Media_Audio_DirectMusic`, `Win32_System_Com`, `Win32_System_PropertiesSystem`*"]
pub struct APOInitSystemEffects3 {
    pub APOInit: super::DirectMusic::APOInitBaseStruct,
    pub pAPOEndpointProperties: ::std::option::Option<super::super::super::System::PropertiesSystem::IPropertyStore>,
    pub pServiceProvider: ::std::option::Option<super::super::super::System::Com::IServiceProvider>,
    pub pDeviceCollection: ::std::option::Option<IMMDeviceCollection>,
    pub nSoftwareIoDeviceInCollection: u32,
    pub nSoftwareIoConnectorIndex: u32,
    pub AudioProcessingMode: ::windows::runtime::GUID,
    pub InitializeForDiscoveryOnly: super::super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
impl APOInitSystemEffects3 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
impl ::std::default::Default for APOInitSystemEffects3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
impl ::std::fmt::Debug for APOInitSystemEffects3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APOInitSystemEffects3")
            .field("APOInit", &self.APOInit)
            .field("pAPOEndpointProperties", &self.pAPOEndpointProperties)
            .field("pServiceProvider", &self.pServiceProvider)
            .field("pDeviceCollection", &self.pDeviceCollection)
            .field("nSoftwareIoDeviceInCollection", &self.nSoftwareIoDeviceInCollection)
            .field("nSoftwareIoConnectorIndex", &self.nSoftwareIoConnectorIndex)
            .field("AudioProcessingMode", &self.AudioProcessingMode)
            .field("InitializeForDiscoveryOnly", &self.InitializeForDiscoveryOnly)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::PartialEq for APOInitSystemEffects3 {
    fn eq(&self, other: &Self) -> bool {
        self.APOInit == other.APOInit && self.pAPOEndpointProperties == other.pAPOEndpointProperties && self.pServiceProvider == other.pServiceProvider && self.pDeviceCollection == other.pDeviceCollection && self.nSoftwareIoDeviceInCollection == other.nSoftwareIoDeviceInCollection && self.nSoftwareIoConnectorIndex == other.nSoftwareIoConnectorIndex && self.AudioProcessingMode == other.AudioProcessingMode && self.InitializeForDiscoveryOnly == other.InitializeForDiscoveryOnly
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::Eq for APOInitSystemEffects3 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Audio_DirectMusic", feature = "Win32_System_Com", feature = "Win32_System_PropertiesSystem"))]
unsafe impl ::windows::runtime::Abi for APOInitSystemEffects3 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
pub const APO_CLASS_UUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1502215400, 40144, 18045, [138, 106, 84, 25, 227, 21, 41, 212]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_RemoteDesktop")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_RemoteDesktop`*"]
pub struct APO_CONNECTION_PROPERTY_V2 {
    pub property: super::super::super::System::RemoteDesktop::APO_CONNECTION_PROPERTY,
    pub u64QPCTime: u64,
}
#[cfg(feature = "Win32_System_RemoteDesktop")]
impl APO_CONNECTION_PROPERTY_V2 {}
#[cfg(feature = "Win32_System_RemoteDesktop")]
impl ::std::default::Default for APO_CONNECTION_PROPERTY_V2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_RemoteDesktop")]
impl ::std::fmt::Debug for APO_CONNECTION_PROPERTY_V2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APO_CONNECTION_PROPERTY_V2").field("property", &self.property).field("u64QPCTime", &self.u64QPCTime).finish()
    }
}
#[cfg(feature = "Win32_System_RemoteDesktop")]
impl ::std::cmp::PartialEq for APO_CONNECTION_PROPERTY_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.property == other.property && self.u64QPCTime == other.u64QPCTime
    }
}
#[cfg(feature = "Win32_System_RemoteDesktop")]
impl ::std::cmp::Eq for APO_CONNECTION_PROPERTY_V2 {}
#[cfg(feature = "Win32_System_RemoteDesktop")]
unsafe impl ::windows::runtime::Abi for APO_CONNECTION_PROPERTY_V2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct APO_LOG_LEVEL(pub i32);
pub const APO_LOG_LEVEL_ALWAYS: APO_LOG_LEVEL = APO_LOG_LEVEL(0i32);
pub const APO_LOG_LEVEL_CRITICAL: APO_LOG_LEVEL = APO_LOG_LEVEL(1i32);
pub const APO_LOG_LEVEL_ERROR: APO_LOG_LEVEL = APO_LOG_LEVEL(2i32);
pub const APO_LOG_LEVEL_WARNING: APO_LOG_LEVEL = APO_LOG_LEVEL(3i32);
pub const APO_LOG_LEVEL_INFO: APO_LOG_LEVEL = APO_LOG_LEVEL(4i32);
pub const APO_LOG_LEVEL_VERBOSE: APO_LOG_LEVEL = APO_LOG_LEVEL(5i32);
impl ::std::convert::From<i32> for APO_LOG_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APO_LOG_LEVEL {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::clone::Clone for APO_NOTIFICATION {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_PropertiesSystem`*"]
pub struct APO_NOTIFICATION {
    pub r#type: APO_NOTIFICATION_TYPE,
    pub Anonymous: APO_NOTIFICATION_0,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl APO_NOTIFICATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::default::Default for APO_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::PartialEq for APO_NOTIFICATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::Eq for APO_NOTIFICATION {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
unsafe impl ::windows::runtime::Abi for APO_NOTIFICATION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::clone::Clone for APO_NOTIFICATION_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
pub union APO_NOTIFICATION_0 {
    pub audioEndpointVolumeChange: ::std::mem::ManuallyDrop<AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION>,
    pub audioEndpointPropertyChange: ::std::mem::ManuallyDrop<AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION>,
    pub audioSystemEffectsPropertyChange: ::std::mem::ManuallyDrop<AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl APO_NOTIFICATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::default::Default for APO_NOTIFICATION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::PartialEq for APO_NOTIFICATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
impl ::std::cmp::Eq for APO_NOTIFICATION_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
unsafe impl ::windows::runtime::Abi for APO_NOTIFICATION_0 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
impl ::std::clone::Clone for APO_NOTIFICATION_DESCRIPTOR {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct APO_NOTIFICATION_DESCRIPTOR {
    pub r#type: APO_NOTIFICATION_TYPE,
    pub Anonymous: APO_NOTIFICATION_DESCRIPTOR_0,
}
impl APO_NOTIFICATION_DESCRIPTOR {}
impl ::std::default::Default for APO_NOTIFICATION_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for APO_NOTIFICATION_DESCRIPTOR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for APO_NOTIFICATION_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for APO_NOTIFICATION_DESCRIPTOR {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
impl ::std::clone::Clone for APO_NOTIFICATION_DESCRIPTOR_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union APO_NOTIFICATION_DESCRIPTOR_0 {
    pub audioEndpointVolume: ::std::mem::ManuallyDrop<AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR>,
    pub audioEndpointPropertyChange: ::std::mem::ManuallyDrop<AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR>,
    pub audioSystemEffectsPropertyChange: ::std::mem::ManuallyDrop<AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR>,
}
impl APO_NOTIFICATION_DESCRIPTOR_0 {}
impl ::std::default::Default for APO_NOTIFICATION_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for APO_NOTIFICATION_DESCRIPTOR_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for APO_NOTIFICATION_DESCRIPTOR_0 {}
unsafe impl ::windows::runtime::Abi for APO_NOTIFICATION_DESCRIPTOR_0 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct APO_NOTIFICATION_TYPE(pub i32);
pub const APO_NOTIFICATION_TYPE_NONE: APO_NOTIFICATION_TYPE = APO_NOTIFICATION_TYPE(0i32);
pub const APO_NOTIFICATION_TYPE_ENDPOINT_VOLUME: APO_NOTIFICATION_TYPE = APO_NOTIFICATION_TYPE(1i32);
pub const APO_NOTIFICATION_TYPE_ENDPOINT_PROPERTY_CHANGE: APO_NOTIFICATION_TYPE = APO_NOTIFICATION_TYPE(2i32);
pub const APO_NOTIFICATION_TYPE_SYSTEM_EFFECTS_PROPERTY_CHANGE: APO_NOTIFICATION_TYPE = APO_NOTIFICATION_TYPE(3i32);
impl ::std::convert::From<i32> for APO_NOTIFICATION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APO_NOTIFICATION_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_ALREADY_INITIALIZED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287486i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFDURATION_PERIOD_NOT_EQUAL: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287469i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFFER_ERROR: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287464i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFFER_OPERATION_PENDING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287477i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFFER_SIZE_ERROR: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287466i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFFER_SIZE_NOT_ALIGNED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287463i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_BUFFER_TOO_LARGE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287482i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_CPUUSAGE_EXCEEDED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287465i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_DEVICE_INVALIDATED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287484i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_DEVICE_IN_USE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287478i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EFFECT_NOT_AVAILABLE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287423i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EFFECT_STATE_READ_ONLY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287422i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_ENDPOINT_CREATE_FAILED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287473i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_ENDPOINT_OFFLOAD_NOT_CAPABLE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287454i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_ENGINE_FORMAT_LOCKED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287447i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_ENGINE_PERIODICITY_LOCKED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287448i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EVENTHANDLE_NOT_EXPECTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287471i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EVENTHANDLE_NOT_SET: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287468i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EXCLUSIVE_MODE_NOT_ALLOWED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287474i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_EXCLUSIVE_MODE_ONLY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287470i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_HEADTRACKING_ENABLED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287440i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_HEADTRACKING_UNSUPPORTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287424i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_INCORRECT_BUFFER_SIZE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287467i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_INVALID_DEVICE_PERIOD: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287456i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_INVALID_SIZE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287479i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_INVALID_STREAM_FLAG: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287455i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_NONOFFLOAD_MODE_ONLY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287451i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_NOT_INITIALIZED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287487i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_NOT_STOPPED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287483i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_OFFLOAD_MODE_ONLY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287452i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_OUT_OF_OFFLOAD_RESOURCES: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287453i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_OUT_OF_ORDER: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287481i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_RAW_MODE_UNSUPPORTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287449i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_RESOURCES_INVALIDATED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287450i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_SERVICE_NOT_RUNNING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287472i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_THREAD_NOT_REGISTERED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287476i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_UNSUPPORTED_FORMAT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287480i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_E_WRONG_ENDPOINT_TYPE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2004287485i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_SESSIONFLAGS_DISPLAY_HIDE: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_SESSIONFLAGS_DISPLAY_HIDEWHENEXPIRED: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_SESSIONFLAGS_EXPIREWHENUNOWNED: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDCLNT_SHAREMODE(pub i32);
pub const AUDCLNT_SHAREMODE_SHARED: AUDCLNT_SHAREMODE = AUDCLNT_SHAREMODE(0i32);
pub const AUDCLNT_SHAREMODE_EXCLUSIVE: AUDCLNT_SHAREMODE = AUDCLNT_SHAREMODE(1i32);
impl ::std::convert::From<i32> for AUDCLNT_SHAREMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDCLNT_SHAREMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_AUTOCONVERTPCM: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_CROSSPROCESS: u32 = 65536u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_EVENTCALLBACK: u32 = 262144u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_LOOPBACK: u32 = 131072u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_NOPERSIST: u32 = 524288u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_RATEADJUST: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_STREAMFLAGS_SRC_DEFAULT_QUALITY: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDCLNT_STREAMOPTIONS(pub u32);
pub const AUDCLNT_STREAMOPTIONS_NONE: AUDCLNT_STREAMOPTIONS = AUDCLNT_STREAMOPTIONS(0u32);
pub const AUDCLNT_STREAMOPTIONS_RAW: AUDCLNT_STREAMOPTIONS = AUDCLNT_STREAMOPTIONS(1u32);
pub const AUDCLNT_STREAMOPTIONS_MATCH_FORMAT: AUDCLNT_STREAMOPTIONS = AUDCLNT_STREAMOPTIONS(2u32);
pub const AUDCLNT_STREAMOPTIONS_AMBISONICS: AUDCLNT_STREAMOPTIONS = AUDCLNT_STREAMOPTIONS(4u32);
impl ::std::convert::From<u32> for AUDCLNT_STREAMOPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDCLNT_STREAMOPTIONS {
    type Abi = Self;
}
impl ::std::ops::BitOr for AUDCLNT_STREAMOPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AUDCLNT_STREAMOPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AUDCLNT_STREAMOPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AUDCLNT_STREAMOPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AUDCLNT_STREAMOPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_S_BUFFER_EMPTY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(143196161i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_S_POSITION_STALLED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(143196163i32 as _);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDCLNT_S_THREAD_ALREADY_REGISTERED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(143196162i32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AUDIOCLIENT_ACTIVATION_PARAMS {
    pub ActivationType: AUDIOCLIENT_ACTIVATION_TYPE,
    pub Anonymous: AUDIOCLIENT_ACTIVATION_PARAMS_0,
}
impl AUDIOCLIENT_ACTIVATION_PARAMS {}
impl ::std::default::Default for AUDIOCLIENT_ACTIVATION_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AUDIOCLIENT_ACTIVATION_PARAMS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AUDIOCLIENT_ACTIVATION_PARAMS {}
unsafe impl ::windows::runtime::Abi for AUDIOCLIENT_ACTIVATION_PARAMS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union AUDIOCLIENT_ACTIVATION_PARAMS_0 {
    pub ProcessLoopbackParams: AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS,
}
impl AUDIOCLIENT_ACTIVATION_PARAMS_0 {}
impl ::std::default::Default for AUDIOCLIENT_ACTIVATION_PARAMS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AUDIOCLIENT_ACTIVATION_PARAMS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AUDIOCLIENT_ACTIVATION_PARAMS_0 {}
unsafe impl ::windows::runtime::Abi for AUDIOCLIENT_ACTIVATION_PARAMS_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIOCLIENT_ACTIVATION_TYPE(pub i32);
pub const AUDIOCLIENT_ACTIVATION_TYPE_DEFAULT: AUDIOCLIENT_ACTIVATION_TYPE = AUDIOCLIENT_ACTIVATION_TYPE(0i32);
pub const AUDIOCLIENT_ACTIVATION_TYPE_PROCESS_LOOPBACK: AUDIOCLIENT_ACTIVATION_TYPE = AUDIOCLIENT_ACTIVATION_TYPE(1i32);
impl ::std::convert::From<i32> for AUDIOCLIENT_ACTIVATION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIOCLIENT_ACTIVATION_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {
    pub TargetProcessId: u32,
    pub ProcessLoopbackMode: PROCESS_LOOPBACK_MODE,
}
impl AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {}
impl ::std::default::Default for AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS").field("TargetProcessId", &self.TargetProcessId).field("ProcessLoopbackMode", &self.ProcessLoopbackMode).finish()
    }
}
impl ::std::cmp::PartialEq for AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.TargetProcessId == other.TargetProcessId && self.ProcessLoopbackMode == other.ProcessLoopbackMode
    }
}
impl ::std::cmp::Eq for AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {}
unsafe impl ::windows::runtime::Abi for AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDIOCLOCK_CHARACTERISTIC_FIXED_FREQ: u32 = 1u32;
pub const AUDIOENDPOINT_CLASS_UUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3244708412, 65036, 19092, [165, 134, 241, 168, 12, 251, 191, 62]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDIOMODULE_MAX_DATA_SIZE: u32 = 64000u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const AUDIOMODULE_MAX_NAME_CCH_SIZE: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIOPOSTURE_ORIENTATION(pub i32);
pub const AUDIOPOSTURE_ORIENTATION_NOTROTATED: AUDIOPOSTURE_ORIENTATION = AUDIOPOSTURE_ORIENTATION(0i32);
pub const AUDIOPOSTURE_ORIENTATION_ROTATED90DEGREESCOUNTERCLOCKWISE: AUDIOPOSTURE_ORIENTATION = AUDIOPOSTURE_ORIENTATION(1i32);
pub const AUDIOPOSTURE_ORIENTATION_ROTATED180DEGREESCOUNTERCLOCKWISE: AUDIOPOSTURE_ORIENTATION = AUDIOPOSTURE_ORIENTATION(2i32);
pub const AUDIOPOSTURE_ORIENTATION_ROTATED270DEGREESCOUNTERCLOCKWISE: AUDIOPOSTURE_ORIENTATION = AUDIOPOSTURE_ORIENTATION(3i32);
impl ::std::convert::From<i32> for AUDIOPOSTURE_ORIENTATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIOPOSTURE_ORIENTATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {
    pub ResourceGroupAcquired: super::super::super::Foundation::BOOL,
    pub ResourceGroupName: [u16; 256],
}
#[cfg(feature = "Win32_Foundation")]
impl AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIORESOURCEMANAGEMENT_RESOURCEGROUP").field("ResourceGroupAcquired", &self.ResourceGroupAcquired).field("ResourceGroupName", &self.ResourceGroupName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {
    fn eq(&self, other: &Self) -> bool {
        self.ResourceGroupAcquired == other.ResourceGroupAcquired && self.ResourceGroupName == other.ResourceGroupName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUDIORESOURCEMANAGEMENT_RESOURCEGROUP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIO_CURVE_TYPE(pub i32);
pub const AUDIO_CURVE_TYPE_NONE: AUDIO_CURVE_TYPE = AUDIO_CURVE_TYPE(0i32);
pub const AUDIO_CURVE_TYPE_WINDOWS_FADE: AUDIO_CURVE_TYPE = AUDIO_CURVE_TYPE(1i32);
impl ::std::convert::From<i32> for AUDIO_CURVE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIO_CURVE_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIO_DUCKING_OPTIONS(pub u32);
pub const AUDIO_DUCKING_OPTIONS_DEFAULT: AUDIO_DUCKING_OPTIONS = AUDIO_DUCKING_OPTIONS(0u32);
pub const AUDIO_DUCKING_OPTIONS_DO_NOT_DUCK_OTHER_STREAMS: AUDIO_DUCKING_OPTIONS = AUDIO_DUCKING_OPTIONS(1u32);
impl ::std::convert::From<u32> for AUDIO_DUCKING_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIO_DUCKING_OPTIONS {
    type Abi = Self;
}
impl ::std::ops::BitOr for AUDIO_DUCKING_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AUDIO_DUCKING_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AUDIO_DUCKING_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AUDIO_DUCKING_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AUDIO_DUCKING_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AUDIO_EFFECT {
    pub id: ::windows::runtime::GUID,
    pub canSetState: super::super::super::Foundation::BOOL,
    pub state: AUDIO_EFFECT_STATE,
}
#[cfg(feature = "Win32_Foundation")]
impl AUDIO_EFFECT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUDIO_EFFECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUDIO_EFFECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_EFFECT").field("id", &self.id).field("canSetState", &self.canSetState).field("state", &self.state).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUDIO_EFFECT {
    fn eq(&self, other: &Self) -> bool {
        self.id == other.id && self.canSetState == other.canSetState && self.state == other.state
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUDIO_EFFECT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUDIO_EFFECT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIO_EFFECT_STATE(pub i32);
pub const AUDIO_EFFECT_STATE_OFF: AUDIO_EFFECT_STATE = AUDIO_EFFECT_STATE(0i32);
pub const AUDIO_EFFECT_STATE_ON: AUDIO_EFFECT_STATE = AUDIO_EFFECT_STATE(1i32);
impl ::std::convert::From<i32> for AUDIO_EFFECT_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIO_EFFECT_STATE {
    type Abi = Self;
}
pub const AUDIO_EFFECT_TYPE_ACOUSTIC_ECHO_CANCELLATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869054, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_AUTOMATIC_GAIN_CONTROL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869056, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_BASS_BOOST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869061, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_BASS_MANAGEMENT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869066, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_BEAMFORMING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869057, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_CONSTANT_TONE_REMOVAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869058, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_DEEP_NOISE_SUPPRESSION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869072, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_DYNAMIC_RANGE_COMPRESSION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869070, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_ENVIRONMENTAL_EFFECTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869067, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_EQUALIZER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869059, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_FAR_FIELD_BEAMFORMING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869071, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_LOUDNESS_EQUALIZER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869060, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_NOISE_SUPPRESSION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869055, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_ROOM_CORRECTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869065, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_SPEAKER_COMPENSATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869069, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_SPEAKER_FILL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869064, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_SPEAKER_PROTECTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869068, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_VIRTUAL_HEADPHONES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869063, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
pub const AUDIO_EFFECT_TYPE_VIRTUAL_SURROUND: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1868869062, 33297, 4578, [140, 112, 44, 39, 215, 240, 1, 250]);
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    pub device: ::std::option::Option<IMMDevice>,
}
impl AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {}
impl ::std::default::Default for AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR").field("device", &self.device).finish()
    }
}
impl ::std::cmp::PartialEq for AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.device == other.device
    }
}
impl ::std::cmp::Eq for AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
pub struct AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {
    pub endpoint: ::std::option::Option<IMMDevice>,
    pub propertyStore: ::std::option::Option<super::super::super::System::PropertiesSystem::IPropertyStore>,
    pub propertyKey: super::super::super::System::PropertiesSystem::PROPERTYKEY,
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::default::Default for AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::fmt::Debug for AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION").field("endpoint", &self.endpoint).field("propertyStore", &self.propertyStore).field("propertyKey", &self.propertyKey).finish()
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::cmp::PartialEq for AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        self.endpoint == other.endpoint && self.propertyStore == other.propertyStore && self.propertyKey == other.propertyKey
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::cmp::Eq for AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_System_PropertiesSystem")]
unsafe impl ::windows::runtime::Abi for AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
pub struct AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {
    pub u32Size: u32,
    pub u32TSSessionId: u32,
    pub targetEndpointConnectorType: EndpointConnectorType,
    pub wfxDeviceFormat: super::super::Multimedia::WAVEFORMATEX,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for AUDIO_ENDPOINT_SHARED_CREATE_PARAMS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {
    pub device: ::std::option::Option<IMMDevice>,
}
impl AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {}
impl ::std::default::Default for AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR").field("device", &self.device).finish()
    }
}
impl ::std::cmp::PartialEq for AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.device == other.device
    }
}
impl ::std::cmp::Eq for AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {
    pub endpoint: ::std::option::Option<IMMDevice>,
    pub volume: *mut AUDIO_VOLUME_NOTIFICATION_DATA,
}
#[cfg(feature = "Win32_Foundation")]
impl AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION").field("endpoint", &self.endpoint).field("volume", &self.volume).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        self.endpoint == other.endpoint && self.volume == other.volume
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
pub const AUDIO_SIGNALPROCESSINGMODE_COMMUNICATIONS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2559906611, 47565, 18609, [160, 163, 255, 64, 104, 45, 115, 247]);
pub const AUDIO_SIGNALPROCESSINGMODE_DEFAULT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3247320958, 37693, 18789, [183, 209, 30, 239, 34, 141, 42, 243]);
pub const AUDIO_SIGNALPROCESSINGMODE_FAR_FIELD_SPEECH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(680795322, 15334, 19064, [154, 118, 48, 253, 145, 85, 155, 100]);
pub const AUDIO_SIGNALPROCESSINGMODE_MEDIA: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1199571022, 28979, 16856, [140, 116, 102, 13, 173, 210, 192, 238]);
pub const AUDIO_SIGNALPROCESSINGMODE_MOVIE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2993679117, 60564, 18300, [148, 148, 209, 171, 142, 117, 63, 110]);
pub const AUDIO_SIGNALPROCESSINGMODE_NOTIFICATION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2633148171, 62327, 16443, [189, 107, 54, 8, 99, 224, 53, 92]);
pub const AUDIO_SIGNALPROCESSINGMODE_RAW: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2660297248, 46227, 20433, [161, 168, 126, 19, 97, 169, 86, 207]);
pub const AUDIO_SIGNALPROCESSINGMODE_SPEECH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4229758107, 47574, 19706, [181, 224, 75, 178, 22, 104, 120, 178]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIO_STREAM_CATEGORY(pub i32);
pub const AudioCategory_Other: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(0i32);
pub const AudioCategory_ForegroundOnlyMedia: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(1i32);
pub const AudioCategory_Communications: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(3i32);
pub const AudioCategory_Alerts: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(4i32);
pub const AudioCategory_SoundEffects: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(5i32);
pub const AudioCategory_GameEffects: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(6i32);
pub const AudioCategory_GameMedia: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(7i32);
pub const AudioCategory_GameChat: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(8i32);
pub const AudioCategory_Speech: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(9i32);
pub const AudioCategory_Movie: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(10i32);
pub const AudioCategory_Media: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(11i32);
pub const AudioCategory_FarFieldSpeech: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(12i32);
pub const AudioCategory_UniformSpeech: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(13i32);
pub const AudioCategory_VoiceTyping: AUDIO_STREAM_CATEGORY = AUDIO_STREAM_CATEGORY(14i32);
impl ::std::convert::From<i32> for AUDIO_STREAM_CATEGORY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIO_STREAM_CATEGORY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AUDIO_SYSTEMEFFECT {
    pub id: ::windows::runtime::GUID,
    pub canSetState: super::super::super::Foundation::BOOL,
    pub state: AUDIO_SYSTEMEFFECT_STATE,
}
#[cfg(feature = "Win32_Foundation")]
impl AUDIO_SYSTEMEFFECT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUDIO_SYSTEMEFFECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUDIO_SYSTEMEFFECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_SYSTEMEFFECT").field("id", &self.id).field("canSetState", &self.canSetState).field("state", &self.state).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUDIO_SYSTEMEFFECT {
    fn eq(&self, other: &Self) -> bool {
        self.id == other.id && self.canSetState == other.canSetState && self.state == other.state
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUDIO_SYSTEMEFFECT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUDIO_SYSTEMEFFECT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    pub device: ::std::option::Option<IMMDevice>,
    pub propertyStoreContext: ::windows::runtime::GUID,
}
impl AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {}
impl ::std::default::Default for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR").field("device", &self.device).field("propertyStoreContext", &self.propertyStoreContext).finish()
    }
}
impl ::std::cmp::PartialEq for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.device == other.device && self.propertyStoreContext == other.propertyStoreContext
    }
}
impl ::std::cmp::Eq for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
pub struct AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {
    pub endpoint: ::std::option::Option<IMMDevice>,
    pub propertyStoreContext: ::windows::runtime::GUID,
    pub propertyStoreType: __MIDL___MIDL_itf_mmdeviceapi_0000_0008_0002,
    pub propertyStore: ::std::option::Option<super::super::super::System::PropertiesSystem::IPropertyStore>,
    pub propertyKey: super::super::super::System::PropertiesSystem::PROPERTYKEY,
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::default::Default for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::fmt::Debug for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION")
            .field("endpoint", &self.endpoint)
            .field("propertyStoreContext", &self.propertyStoreContext)
            .field("propertyStoreType", &self.propertyStoreType)
            .field("propertyStore", &self.propertyStore)
            .field("propertyKey", &self.propertyKey)
            .finish()
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::cmp::PartialEq for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        self.endpoint == other.endpoint && self.propertyStoreContext == other.propertyStoreContext && self.propertyStoreType == other.propertyStoreType && self.propertyStore == other.propertyStore && self.propertyKey == other.propertyKey
    }
}
#[cfg(feature = "Win32_System_PropertiesSystem")]
impl ::std::cmp::Eq for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {}
#[cfg(feature = "Win32_System_PropertiesSystem")]
unsafe impl ::windows::runtime::Abi for AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AUDIO_SYSTEMEFFECT_STATE(pub i32);
pub const AUDIO_SYSTEMEFFECT_STATE_OFF: AUDIO_SYSTEMEFFECT_STATE = AUDIO_SYSTEMEFFECT_STATE(0i32);
pub const AUDIO_SYSTEMEFFECT_STATE_ON: AUDIO_SYSTEMEFFECT_STATE = AUDIO_SYSTEMEFFECT_STATE(1i32);
impl ::std::convert::From<i32> for AUDIO_SYSTEMEFFECT_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUDIO_SYSTEMEFFECT_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AUDIO_VOLUME_NOTIFICATION_DATA {
    pub guidEventContext: ::windows::runtime::GUID,
    pub bMuted: super::super::super::Foundation::BOOL,
    pub fMasterVolume: f32,
    pub nChannels: u32,
    pub afChannelVolumes: [f32; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl AUDIO_VOLUME_NOTIFICATION_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUDIO_VOLUME_NOTIFICATION_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AUDIO_VOLUME_NOTIFICATION_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_VOLUME_NOTIFICATION_DATA").field("guidEventContext", &self.guidEventContext).field("bMuted", &self.bMuted).field("fMasterVolume", &self.fMasterVolume).field("nChannels", &self.nChannels).field("afChannelVolumes", &self.afChannelVolumes).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUDIO_VOLUME_NOTIFICATION_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.guidEventContext == other.guidEventContext && self.bMuted == other.bMuted && self.fMasterVolume == other.fMasterVolume && self.nChannels == other.nChannels && self.afChannelVolumes == other.afChannelVolumes
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUDIO_VOLUME_NOTIFICATION_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUDIO_VOLUME_NOTIFICATION_DATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
#[inline]
pub unsafe fn ActivateAudioInterfaceAsync<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, IActivateAudioInterfaceCompletionHandler>>(deviceinterfacepath: Param0, riid: *const ::windows::runtime::GUID, activationparams: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT, completionhandler: Param3) -> ::windows::runtime::Result<IActivateAudioInterfaceAsyncOperation> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ActivateAudioInterfaceAsync(deviceinterfacepath: super::super::super::Foundation::PWSTR, riid: *const ::windows::runtime::GUID, activationparams: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>, completionhandler: ::windows::runtime::RawPtr, activationoperation: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IActivateAudioInterfaceAsyncOperation as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ActivateAudioInterfaceAsync(deviceinterfacepath.into_param().abi(), ::std::mem::transmute(riid), ::std::mem::transmute(activationparams), completionhandler.into_param().abi(), &mut result__).from_abi::<IActivateAudioInterfaceAsyncOperation>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct AudioClient3ActivationParams {
    pub tracingContextId: ::windows::runtime::GUID,
}
impl AudioClient3ActivationParams {}
impl ::std::default::Default for AudioClient3ActivationParams {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AudioClient3ActivationParams {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AudioClient3ActivationParams").field("tracingContextId", &self.tracingContextId).finish()
    }
}
impl ::std::cmp::PartialEq for AudioClient3ActivationParams {
    fn eq(&self, other: &Self) -> bool {
        self.tracingContextId == other.tracingContextId
    }
}
impl ::std::cmp::Eq for AudioClient3ActivationParams {}
unsafe impl ::windows::runtime::Abi for AudioClient3ActivationParams {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AudioClientProperties {
    pub cbSize: u32,
    pub bIsOffload: super::super::super::Foundation::BOOL,
    pub eCategory: AUDIO_STREAM_CATEGORY,
    pub Options: AUDCLNT_STREAMOPTIONS,
}
#[cfg(feature = "Win32_Foundation")]
impl AudioClientProperties {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AudioClientProperties {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AudioClientProperties {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AudioClientProperties").field("cbSize", &self.cbSize).field("bIsOffload", &self.bIsOffload).field("eCategory", &self.eCategory).field("Options", &self.Options).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AudioClientProperties {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.bIsOffload == other.bIsOffload && self.eCategory == other.eCategory && self.Options == other.Options
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AudioClientProperties {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AudioClientProperties {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct AudioExtensionParams {
    pub AddPageParam: super::super::super::Foundation::LPARAM,
    pub pEndpoint: ::std::option::Option<IMMDevice>,
    pub pPnpInterface: ::std::option::Option<IMMDevice>,
    pub pPnpDevnode: ::std::option::Option<IMMDevice>,
}
#[cfg(feature = "Win32_Foundation")]
impl AudioExtensionParams {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AudioExtensionParams {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AudioExtensionParams {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AudioExtensionParams").field("AddPageParam", &self.AddPageParam).field("pEndpoint", &self.pEndpoint).field("pPnpInterface", &self.pPnpInterface).field("pPnpDevnode", &self.pPnpDevnode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AudioExtensionParams {
    fn eq(&self, other: &Self) -> bool {
        self.AddPageParam == other.AddPageParam && self.pEndpoint == other.pEndpoint && self.pPnpInterface == other.pPnpInterface && self.pPnpDevnode == other.pPnpDevnode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AudioExtensionParams {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AudioExtensionParams {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AudioObjectType(pub u32);
pub const AudioObjectType_None: AudioObjectType = AudioObjectType(0u32);
pub const AudioObjectType_Dynamic: AudioObjectType = AudioObjectType(1u32);
pub const AudioObjectType_FrontLeft: AudioObjectType = AudioObjectType(2u32);
pub const AudioObjectType_FrontRight: AudioObjectType = AudioObjectType(4u32);
pub const AudioObjectType_FrontCenter: AudioObjectType = AudioObjectType(8u32);
pub const AudioObjectType_LowFrequency: AudioObjectType = AudioObjectType(16u32);
pub const AudioObjectType_SideLeft: AudioObjectType = AudioObjectType(32u32);
pub const AudioObjectType_SideRight: AudioObjectType = AudioObjectType(64u32);
pub const AudioObjectType_BackLeft: AudioObjectType = AudioObjectType(128u32);
pub const AudioObjectType_BackRight: AudioObjectType = AudioObjectType(256u32);
pub const AudioObjectType_TopFrontLeft: AudioObjectType = AudioObjectType(512u32);
pub const AudioObjectType_TopFrontRight: AudioObjectType = AudioObjectType(1024u32);
pub const AudioObjectType_TopBackLeft: AudioObjectType = AudioObjectType(2048u32);
pub const AudioObjectType_TopBackRight: AudioObjectType = AudioObjectType(4096u32);
pub const AudioObjectType_BottomFrontLeft: AudioObjectType = AudioObjectType(8192u32);
pub const AudioObjectType_BottomFrontRight: AudioObjectType = AudioObjectType(16384u32);
pub const AudioObjectType_BottomBackLeft: AudioObjectType = AudioObjectType(32768u32);
pub const AudioObjectType_BottomBackRight: AudioObjectType = AudioObjectType(65536u32);
pub const AudioObjectType_BackCenter: AudioObjectType = AudioObjectType(131072u32);
impl ::std::convert::From<u32> for AudioObjectType {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AudioObjectType {
    type Abi = Self;
}
impl ::std::ops::BitOr for AudioObjectType {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AudioObjectType {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AudioObjectType {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AudioObjectType {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AudioObjectType {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AudioSessionDisconnectReason(pub i32);
pub const DisconnectReasonDeviceRemoval: AudioSessionDisconnectReason = AudioSessionDisconnectReason(0i32);
pub const DisconnectReasonServerShutdown: AudioSessionDisconnectReason = AudioSessionDisconnectReason(1i32);
pub const DisconnectReasonFormatChanged: AudioSessionDisconnectReason = AudioSessionDisconnectReason(2i32);
pub const DisconnectReasonSessionLogoff: AudioSessionDisconnectReason = AudioSessionDisconnectReason(3i32);
pub const DisconnectReasonSessionDisconnected: AudioSessionDisconnectReason = AudioSessionDisconnectReason(4i32);
pub const DisconnectReasonExclusiveModeOverride: AudioSessionDisconnectReason = AudioSessionDisconnectReason(5i32);
impl ::std::convert::From<i32> for AudioSessionDisconnectReason {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AudioSessionDisconnectReason {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AudioSessionState(pub i32);
pub const AudioSessionStateInactive: AudioSessionState = AudioSessionState(0i32);
pub const AudioSessionStateActive: AudioSessionState = AudioSessionState(1i32);
pub const AudioSessionStateExpired: AudioSessionState = AudioSessionState(2i32);
impl ::std::convert::From<i32> for AudioSessionState {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AudioSessionState {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AudioStateMonitorSoundLevel(pub i32);
pub const Muted: AudioStateMonitorSoundLevel = AudioStateMonitorSoundLevel(0i32);
pub const Low: AudioStateMonitorSoundLevel = AudioStateMonitorSoundLevel(1i32);
pub const Full: AudioStateMonitorSoundLevel = AudioStateMonitorSoundLevel(2i32);
impl ::std::convert::From<i32> for AudioStateMonitorSoundLevel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AudioStateMonitorSoundLevel {
    type Abi = Self;
}
pub const BLUETOOTHLE_MIDI_SERVICE_UUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(62393946, 60904, 19251, [167, 81, 108, 227, 78, 196, 199, 0]);
pub const BLUETOOTH_MIDI_DATAIO_CHARACTERISTIC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2004018651, 14440, 16658, [161, 169, 242, 102, 157, 16, 107, 243]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const BUS_INTERFACE_REFERENCE_VERSION: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CAPTURE_MEMORY_ALLOCATION_FLAGS(pub i32);
pub const KS_CAPTURE_ALLOC_INVALID: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(0i32);
pub const KS_CAPTURE_ALLOC_SYSTEM: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(1i32);
pub const KS_CAPTURE_ALLOC_VRAM: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(2i32);
pub const KS_CAPTURE_ALLOC_SYSTEM_AGP: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(4i32);
pub const KS_CAPTURE_ALLOC_VRAM_MAPPED: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(8i32);
pub const KS_CAPTURE_ALLOC_SECURE_BUFFER: CAPTURE_MEMORY_ALLOCATION_FLAGS = CAPTURE_MEMORY_ALLOCATION_FLAGS(16i32);
impl ::std::convert::From<i32> for CAPTURE_MEMORY_ALLOCATION_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CAPTURE_MEMORY_ALLOCATION_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct CC_BYTE_PAIR {
    pub Decoded: [u8; 2],
    pub Reserved: u16,
}
impl CC_BYTE_PAIR {}
impl ::std::default::Default for CC_BYTE_PAIR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CC_BYTE_PAIR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CC_BYTE_PAIR").field("Decoded", &self.Decoded).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for CC_BYTE_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.Decoded == other.Decoded && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for CC_BYTE_PAIR {}
unsafe impl ::windows::runtime::Abi for CC_BYTE_PAIR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct CC_HW_FIELD {
    pub ScanlinesRequested: VBICODECFILTERING_SCANLINES,
    pub fieldFlags: u32,
    pub PictureNumber: i64,
    pub Lines: [CC_BYTE_PAIR; 12],
}
impl CC_HW_FIELD {}
impl ::std::default::Default for CC_HW_FIELD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CC_HW_FIELD {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CC_HW_FIELD").field("ScanlinesRequested", &self.ScanlinesRequested).field("fieldFlags", &self.fieldFlags).field("PictureNumber", &self.PictureNumber).field("Lines", &self.Lines).finish()
    }
}
impl ::std::cmp::PartialEq for CC_HW_FIELD {
    fn eq(&self, other: &Self) -> bool {
        self.ScanlinesRequested == other.ScanlinesRequested && self.fieldFlags == other.fieldFlags && self.PictureNumber == other.PictureNumber && self.Lines == other.Lines
    }
}
impl ::std::cmp::Eq for CC_HW_FIELD {}
unsafe impl ::windows::runtime::Abi for CC_HW_FIELD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const CC_MAX_HW_DECODE_LINES: u32 = 12u32;
pub const CLSID_KsIBasicAudioInterfaceHandler: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3120081982, 3953, 4562, [183, 44, 0, 192, 79, 182, 189, 61]);
pub const CODECAPI_ALLSETTINGS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1784118930, 33761, 16659, [173, 194, 79, 206, 195, 47, 131, 161]);
pub const CODECAPI_AUDIO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3117521470, 63639, 17052, [188, 70, 129, 56, 183, 39, 43, 45]);
pub const CODECAPI_CHANGELISTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1655777999, 63152, 18393, [148, 86, 150, 242, 44, 78, 11, 157]);
pub const CODECAPI_CURRENTCHANGELIST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(481382019, 32114, 18007, [131, 253, 71, 162, 197, 185, 209, 61]);
pub const CODECAPI_SETALLDEFAULTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1818126972, 44280, 20309, [169, 153, 26, 98, 129, 9, 5, 27]);
pub const CODECAPI_SUPPORTSEVENTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(92385175, 30355, 19901, [157, 202, 63, 158, 189, 101, 133, 161]);
pub const CODECAPI_VIDEO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1897064673, 15619, 18415, [142, 96, 3, 241, 207, 83, 115, 1]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CONSTRICTOR_OPTION(pub i32);
pub const CONSTRICTOR_OPTION_DISABLE: CONSTRICTOR_OPTION = CONSTRICTOR_OPTION(0i32);
pub const CONSTRICTOR_OPTION_MUTE: CONSTRICTOR_OPTION = CONSTRICTOR_OPTION(1i32);
impl ::std::convert::From<i32> for CONSTRICTOR_OPTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CONSTRICTOR_OPTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CoRegisterMessageFilter<'a, Param0: ::windows::runtime::IntoParam<'a, IMessageFilter>>(lpmessagefilter: Param0) -> ::windows::runtime::Result<IMessageFilter> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CoRegisterMessageFilter(lpmessagefilter: ::windows::runtime::RawPtr, lplpmessagefilter: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IMessageFilter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CoRegisterMessageFilter(lpmessagefilter.into_param().abi(), &mut result__).from_abi::<IMessageFilter>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ConnectorType(pub i32);
impl ConnectorType {
    pub const Unknown_Connector: ConnectorType = ConnectorType(0i32);
    pub const Physical_Internal: ConnectorType = ConnectorType(1i32);
    pub const Physical_External: ConnectorType = ConnectorType(2i32);
    pub const Software_IO: ConnectorType = ConnectorType(3i32);
    pub const Software_Fixed: ConnectorType = ConnectorType(4i32);
    pub const Network: ConnectorType = ConnectorType(5i32);
}
impl ::std::convert::From<i32> for ConnectorType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ConnectorType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateCaptureAudioStateMonitor() -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateCaptureAudioStateMonitor(audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateCaptureAudioStateMonitor(&mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateCaptureAudioStateMonitorForCategory(category: AUDIO_STREAM_CATEGORY) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateCaptureAudioStateMonitorForCategory(category: AUDIO_STREAM_CATEGORY, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateCaptureAudioStateMonitorForCategory(::std::mem::transmute(category), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateCaptureAudioStateMonitorForCategoryAndDeviceId<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(category: AUDIO_STREAM_CATEGORY, deviceid: Param1) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateCaptureAudioStateMonitorForCategoryAndDeviceId(category: AUDIO_STREAM_CATEGORY, deviceid: super::super::super::Foundation::PWSTR, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateCaptureAudioStateMonitorForCategoryAndDeviceId(::std::mem::transmute(category), deviceid.into_param().abi(), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateCaptureAudioStateMonitorForCategoryAndDeviceRole(category: AUDIO_STREAM_CATEGORY, role: ERole) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateCaptureAudioStateMonitorForCategoryAndDeviceRole(category: AUDIO_STREAM_CATEGORY, role: ERole, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateCaptureAudioStateMonitorForCategoryAndDeviceRole(::std::mem::transmute(category), ::std::mem::transmute(role), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateRenderAudioStateMonitor() -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateRenderAudioStateMonitor(audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateRenderAudioStateMonitor(&mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateRenderAudioStateMonitorForCategory(category: AUDIO_STREAM_CATEGORY) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateRenderAudioStateMonitorForCategory(category: AUDIO_STREAM_CATEGORY, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateRenderAudioStateMonitorForCategory(::std::mem::transmute(category), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateRenderAudioStateMonitorForCategoryAndDeviceId<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(category: AUDIO_STREAM_CATEGORY, deviceid: Param1) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateRenderAudioStateMonitorForCategoryAndDeviceId(category: AUDIO_STREAM_CATEGORY, deviceid: super::super::super::Foundation::PWSTR, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateRenderAudioStateMonitorForCategoryAndDeviceId(::std::mem::transmute(category), deviceid.into_param().abi(), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[inline]
pub unsafe fn CreateRenderAudioStateMonitorForCategoryAndDeviceRole(category: AUDIO_STREAM_CATEGORY, role: ERole) -> ::windows::runtime::Result<IAudioStateMonitor> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateRenderAudioStateMonitorForCategoryAndDeviceRole(category: AUDIO_STREAM_CATEGORY, role: ERole, audiostatemonitor: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IAudioStateMonitor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CreateRenderAudioStateMonitorForCategoryAndDeviceRole(::std::mem::transmute(category), ::std::mem::transmute(role), &mut result__).from_abi::<IAudioStateMonitor>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DDPF_FOURCC: i32 = 4i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct DEVCAPS {
    pub CanRecord: i32,
    pub CanRecordStrobe: i32,
    pub HasAudio: i32,
    pub HasVideo: i32,
    pub UsesFiles: i32,
    pub CanSave: i32,
    pub DeviceType: i32,
    pub TCRead: i32,
    pub TCWrite: i32,
    pub CTLRead: i32,
    pub IndexRead: i32,
    pub Preroll: i32,
    pub Postroll: i32,
    pub SyncAcc: i32,
    pub NormRate: i32,
    pub CanPreview: i32,
    pub CanMonitorSrc: i32,
    pub CanTest: i32,
    pub VideoIn: i32,
    pub AudioIn: i32,
    pub Calibrate: i32,
    pub SeekType: i32,
    pub SimulatedHardware: i32,
}
impl DEVCAPS {}
impl ::std::default::Default for DEVCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DEVCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVCAPS")
            .field("CanRecord", &self.CanRecord)
            .field("CanRecordStrobe", &self.CanRecordStrobe)
            .field("HasAudio", &self.HasAudio)
            .field("HasVideo", &self.HasVideo)
            .field("UsesFiles", &self.UsesFiles)
            .field("CanSave", &self.CanSave)
            .field("DeviceType", &self.DeviceType)
            .field("TCRead", &self.TCRead)
            .field("TCWrite", &self.TCWrite)
            .field("CTLRead", &self.CTLRead)
            .field("IndexRead", &self.IndexRead)
            .field("Preroll", &self.Preroll)
            .field("Postroll", &self.Postroll)
            .field("SyncAcc", &self.SyncAcc)
            .field("NormRate", &self.NormRate)
            .field("CanPreview", &self.CanPreview)
            .field("CanMonitorSrc", &self.CanMonitorSrc)
            .field("CanTest", &self.CanTest)
            .field("VideoIn", &self.VideoIn)
            .field("AudioIn", &self.AudioIn)
            .field("Calibrate", &self.Calibrate)
            .field("SeekType", &self.SeekType)
            .field("SimulatedHardware", &self.SimulatedHardware)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DEVCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.CanRecord == other.CanRecord
            && self.CanRecordStrobe == other.CanRecordStrobe
            && self.HasAudio == other.HasAudio
            && self.HasVideo == other.HasVideo
            && self.UsesFiles == other.UsesFiles
            && self.CanSave == other.CanSave
            && self.DeviceType == other.DeviceType
            && self.TCRead == other.TCRead
            && self.TCWrite == other.TCWrite
            && self.CTLRead == other.CTLRead
            && self.IndexRead == other.IndexRead
            && self.Preroll == other.Preroll
            && self.Postroll == other.Postroll
            && self.SyncAcc == other.SyncAcc
            && self.NormRate == other.NormRate
            && self.CanPreview == other.CanPreview
            && self.CanMonitorSrc == other.CanMonitorSrc
            && self.CanTest == other.CanTest
            && self.VideoIn == other.VideoIn
            && self.AudioIn == other.AudioIn
            && self.Calibrate == other.Calibrate
            && self.SeekType == other.SeekType
            && self.SimulatedHardware == other.SimulatedHardware
    }
}
impl ::std::cmp::Eq for DEVCAPS {}
unsafe impl ::windows::runtime::Abi for DEVCAPS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DEVICE_STATEMASK_ALL: u32 = 15u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DEVICE_STATE_ACTIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DEVICE_STATE_DISABLED: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DEVICE_STATE_NOTPRESENT: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const DEVICE_STATE_UNPLUGGED: u32 = 8u32;
pub const DEVINTERFACE_AUDIOENDPOINTPLUGIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2670689126, 26028, 20390, [138, 228, 18, 60, 120, 184, 147, 19]);
pub const DEVINTERFACE_AUDIO_CAPTURE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(787448254, 13306, 18432, [150, 112, 28, 212, 116, 151, 44, 63]);
pub const DEVINTERFACE_AUDIO_RENDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3862068397, 56556, 18761, [174, 138, 153, 30, 151, 106, 121, 210]);
pub const DEVINTERFACE_MIDI_INPUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1347150636, 52470, 19756, [183, 63, 111, 139, 55, 71, 226, 43]);
pub const DEVINTERFACE_MIDI_OUTPUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1841443616, 43827, 19684, [128, 212, 187, 179, 235, 191, 40, 20]);
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_KsAudio_Controller_DeviceInterface_Path: super::super::super::System::PropertiesSystem::PROPERTYKEY = super::super::super::System::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(333448406, 45158, 17341, [145, 59, 164, 21, 205, 19, 218, 135]),
    pid: 3u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_KsAudio_PacketSize_Constraints: super::super::super::System::PropertiesSystem::PROPERTYKEY = super::super::super::System::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(333448406, 45158, 17341, [145, 59, 164, 21, 205, 19, 218, 135]),
    pid: 2u32,
};
#[cfg(feature = "Win32_System_PropertiesSystem")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
pub const DEVPKEY_KsAudio_PacketSize_Constraints2: super::super::super::System::PropertiesSystem::PROPERTYKEY = super::super::super::System::PropertiesSystem::PROPERTYKEY {
    fmtid: ::windows::runtime::GUID::from_values(2483353473, 29073, 16539, [139, 11, 128, 191, 110, 194, 41, 174]),
    pid: 2u32,
};
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct DIRECTX_AUDIO_ACTIVATION_PARAMS {
    pub cbDirectXAudioActivationParams: u32,
    pub guidAudioSession: ::windows::runtime::GUID,
    pub dwAudioStreamFlags: u32,
}
impl DIRECTX_AUDIO_ACTIVATION_PARAMS {}
impl ::std::default::Default for DIRECTX_AUDIO_ACTIVATION_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DIRECTX_AUDIO_ACTIVATION_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DIRECTX_AUDIO_ACTIVATION_PARAMS").field("cbDirectXAudioActivationParams", &self.cbDirectXAudioActivationParams).field("guidAudioSession", &self.guidAudioSession).field("dwAudioStreamFlags", &self.dwAudioStreamFlags).finish()
    }
}
impl ::std::cmp::PartialEq for DIRECTX_AUDIO_ACTIVATION_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.cbDirectXAudioActivationParams == other.cbDirectXAudioActivationParams && self.guidAudioSession == other.guidAudioSession && self.dwAudioStreamFlags == other.dwAudioStreamFlags
    }
}
impl ::std::cmp::Eq for DIRECTX_AUDIO_ACTIVATION_PARAMS {}
unsafe impl ::windows::runtime::Abi for DIRECTX_AUDIO_ACTIVATION_PARAMS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct DS3DVECTOR {
    pub Anonymous1: DS3DVECTOR_0,
    pub Anonymous2: DS3DVECTOR_1,
    pub Anonymous3: DS3DVECTOR_2,
}
impl DS3DVECTOR {}
impl ::std::default::Default for DS3DVECTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DS3DVECTOR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DS3DVECTOR {}
unsafe impl ::windows::runtime::Abi for DS3DVECTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union DS3DVECTOR_0 {
    pub x: f32,
    pub dvX: f32,
}
impl DS3DVECTOR_0 {}
impl ::std::default::Default for DS3DVECTOR_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DS3DVECTOR_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DS3DVECTOR_0 {}
unsafe impl ::windows::runtime::Abi for DS3DVECTOR_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union DS3DVECTOR_1 {
    pub y: f32,
    pub dvY: f32,
}
impl DS3DVECTOR_1 {}
impl ::std::default::Default for DS3DVECTOR_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DS3DVECTOR_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DS3DVECTOR_1 {}
unsafe impl ::windows::runtime::Abi for DS3DVECTOR_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union DS3DVECTOR_2 {
    pub z: f32,
    pub dvZ: f32,
}
impl DS3DVECTOR_2 {}
impl ::std::default::Default for DS3DVECTOR_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DS3DVECTOR_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DS3DVECTOR_2 {}
unsafe impl ::windows::runtime::Abi for DS3DVECTOR_2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DataFlow(pub i32);
pub const In: DataFlow = DataFlow(0i32);
pub const Out: DataFlow = DataFlow(1i32);
impl ::std::convert::From<i32> for DataFlow {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DataFlow {
    type Abi = Self;
}
pub const DeviceTopology: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(502675920, 24257, 18346, [147, 121, 130, 141, 193, 170, 140, 89]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EDataFlow(pub i32);
pub const eRender: EDataFlow = EDataFlow(0i32);
pub const eCapture: EDataFlow = EDataFlow(1i32);
pub const eAll: EDataFlow = EDataFlow(2i32);
pub const EDataFlow_enum_count: EDataFlow = EDataFlow(3i32);
impl ::std::convert::From<i32> for EDataFlow {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EDataFlow {
    type Abi = Self;
}
pub const ENCAPIPARAM_BITRATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1238125635, 51843, 19156, [169, 175, 243, 105, 106, 246, 102, 223]);
pub const ENCAPIPARAM_BITRATE_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3999248988, 50963, 16593, [157, 88, 192, 215, 36, 30, 37, 15]);
pub const ENCAPIPARAM_PEAK_BITRATE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1883182761, 15688, 17569, [176, 119, 1, 141, 255, 145, 93, 25]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_FORMAT_RESET_MIX_ONLY: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_HARDWARE_SUPPORT_METER: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_HARDWARE_SUPPORT_MUTE: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_HARDWARE_SUPPORT_VOLUME: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_SYSFX_DISABLED: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const ENDPOINT_SYSFX_ENABLED: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EPcxConnectionType(pub i32);
pub const eConnTypeUnknown: EPcxConnectionType = EPcxConnectionType(0i32);
pub const eConnType3Point5mm: EPcxConnectionType = EPcxConnectionType(1i32);
pub const eConnTypeQuarter: EPcxConnectionType = EPcxConnectionType(2i32);
pub const eConnTypeAtapiInternal: EPcxConnectionType = EPcxConnectionType(3i32);
pub const eConnTypeRCA: EPcxConnectionType = EPcxConnectionType(4i32);
pub const eConnTypeOptical: EPcxConnectionType = EPcxConnectionType(5i32);
pub const eConnTypeOtherDigital: EPcxConnectionType = EPcxConnectionType(6i32);
pub const eConnTypeOtherAnalog: EPcxConnectionType = EPcxConnectionType(7i32);
pub const eConnTypeMultichannelAnalogDIN: EPcxConnectionType = EPcxConnectionType(8i32);
pub const eConnTypeXlrProfessional: EPcxConnectionType = EPcxConnectionType(9i32);
pub const eConnTypeRJ11Modem: EPcxConnectionType = EPcxConnectionType(10i32);
pub const eConnTypeCombination: EPcxConnectionType = EPcxConnectionType(11i32);
impl ::std::convert::From<i32> for EPcxConnectionType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPcxConnectionType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EPcxGenLocation(pub i32);
pub const eGenLocPrimaryBox: EPcxGenLocation = EPcxGenLocation(0i32);
pub const eGenLocInternal: EPcxGenLocation = EPcxGenLocation(1i32);
pub const eGenLocSeparate: EPcxGenLocation = EPcxGenLocation(2i32);
pub const eGenLocOther: EPcxGenLocation = EPcxGenLocation(3i32);
pub const EPcxGenLocation_enum_count: EPcxGenLocation = EPcxGenLocation(4i32);
impl ::std::convert::From<i32> for EPcxGenLocation {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPcxGenLocation {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EPcxGeoLocation(pub i32);
pub const eGeoLocRear: EPcxGeoLocation = EPcxGeoLocation(1i32);
pub const eGeoLocFront: EPcxGeoLocation = EPcxGeoLocation(2i32);
pub const eGeoLocLeft: EPcxGeoLocation = EPcxGeoLocation(3i32);
pub const eGeoLocRight: EPcxGeoLocation = EPcxGeoLocation(4i32);
pub const eGeoLocTop: EPcxGeoLocation = EPcxGeoLocation(5i32);
pub const eGeoLocBottom: EPcxGeoLocation = EPcxGeoLocation(6i32);
pub const eGeoLocRearPanel: EPcxGeoLocation = EPcxGeoLocation(7i32);
pub const eGeoLocRiser: EPcxGeoLocation = EPcxGeoLocation(8i32);
pub const eGeoLocInsideMobileLid: EPcxGeoLocation = EPcxGeoLocation(9i32);
pub const eGeoLocDrivebay: EPcxGeoLocation = EPcxGeoLocation(10i32);
pub const eGeoLocHDMI: EPcxGeoLocation = EPcxGeoLocation(11i32);
pub const eGeoLocOutsideMobileLid: EPcxGeoLocation = EPcxGeoLocation(12i32);
pub const eGeoLocATAPI: EPcxGeoLocation = EPcxGeoLocation(13i32);
pub const eGeoLocNotApplicable: EPcxGeoLocation = EPcxGeoLocation(14i32);
pub const eGeoLocReserved6: EPcxGeoLocation = EPcxGeoLocation(15i32);
pub const EPcxGeoLocation_enum_count: EPcxGeoLocation = EPcxGeoLocation(16i32);
impl ::std::convert::From<i32> for EPcxGeoLocation {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPcxGeoLocation {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EPxcPortConnection(pub i32);
pub const ePortConnJack: EPxcPortConnection = EPxcPortConnection(0i32);
pub const ePortConnIntegratedDevice: EPxcPortConnection = EPxcPortConnection(1i32);
pub const ePortConnBothIntegratedAndJack: EPxcPortConnection = EPxcPortConnection(2i32);
pub const ePortConnUnknown: EPxcPortConnection = EPxcPortConnection(3i32);
impl ::std::convert::From<i32> for EPxcPortConnection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPxcPortConnection {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ERole(pub i32);
pub const eConsole: ERole = ERole(0i32);
pub const eMultimedia: ERole = ERole(1i32);
pub const eCommunications: ERole = ERole(2i32);
pub const ERole_enum_count: ERole = ERole(3i32);
impl ::std::convert::From<i32> for ERole {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ERole {
    type Abi = Self;
}
pub const EVENTCONTEXT_VOLUMESLIDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3804424670, 2481, 19204, [132, 229, 7, 147, 18, 37, 238, 4]);
pub const EVENTSETID_CROSSBAR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1781401153, 10468, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
pub const EVENTSETID_TUNER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1781401094, 10468, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
pub const EVENTSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(803208285, 50994, 19366, [181, 223, 107, 77, 127, 200, 139, 139]);
pub const EVENTSETID_VIDEODECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1781401121, 10468, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EndpointConnectorType(pub i32);
pub const eHostProcessConnector: EndpointConnectorType = EndpointConnectorType(0i32);
pub const eOffloadConnector: EndpointConnectorType = EndpointConnectorType(1i32);
pub const eLoopbackConnector: EndpointConnectorType = EndpointConnectorType(2i32);
pub const eKeywordDetectorConnector: EndpointConnectorType = EndpointConnectorType(3i32);
pub const eConnectorCount: EndpointConnectorType = EndpointConnectorType(4i32);
impl ::std::convert::From<i32> for EndpointConnectorType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EndpointConnectorType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EndpointFormFactor(pub i32);
pub const RemoteNetworkDevice: EndpointFormFactor = EndpointFormFactor(0i32);
pub const Speakers: EndpointFormFactor = EndpointFormFactor(1i32);
pub const LineLevel: EndpointFormFactor = EndpointFormFactor(2i32);
pub const Headphones: EndpointFormFactor = EndpointFormFactor(3i32);
pub const Microphone: EndpointFormFactor = EndpointFormFactor(4i32);
pub const Headset: EndpointFormFactor = EndpointFormFactor(5i32);
pub const Handset: EndpointFormFactor = EndpointFormFactor(6i32);
pub const UnknownDigitalPassthrough: EndpointFormFactor = EndpointFormFactor(7i32);
pub const SPDIF: EndpointFormFactor = EndpointFormFactor(8i32);
pub const DigitalAudioDisplayDevice: EndpointFormFactor = EndpointFormFactor(9i32);
pub const UnknownFormFactor: EndpointFormFactor = EndpointFormFactor(10i32);
pub const EndpointFormFactor_enum_count: EndpointFormFactor = EndpointFormFactor(11i32);
impl ::std::convert::From<i32> for EndpointFormFactor {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EndpointFormFactor {
    type Abi = Self;
}
pub const GUID_NULL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(0, 0, 0, [0, 0, 0, 0, 0, 0, 0, 0]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HTASK(pub isize);
impl ::std::default::Default for HTASK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HTASK {}
unsafe impl ::windows::runtime::Abi for HTASK {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IActivateAudioInterfaceAsyncOperation(pub ::windows::runtime::IUnknown);
impl IActivateAudioInterfaceAsyncOperation {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetActivateResult(&self, activateresult: *mut ::windows::runtime::HRESULT, activatedinterface: *mut ::std::option::Option<::windows::runtime::IUnknown>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(activateresult), ::std::mem::transmute(activatedinterface)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActivateAudioInterfaceAsyncOperation {
    type Vtable = IActivateAudioInterfaceAsyncOperation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1923231096, 52708, 17181, [184, 204, 132, 58, 113, 25, 155, 109]);
}
impl ::std::convert::From<IActivateAudioInterfaceAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: IActivateAudioInterfaceAsyncOperation) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IActivateAudioInterfaceAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: &IActivateAudioInterfaceAsyncOperation) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActivateAudioInterfaceAsyncOperation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IActivateAudioInterfaceAsyncOperation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActivateAudioInterfaceAsyncOperation_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, activateresult: *mut ::windows::runtime::HRESULT, activatedinterface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IActivateAudioInterfaceCompletionHandler(pub ::windows::runtime::IUnknown);
impl IActivateAudioInterfaceCompletionHandler {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateCompleted<'a, Param0: ::windows::runtime::IntoParam<'a, IActivateAudioInterfaceAsyncOperation>>(&self, activateoperation: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), activateoperation.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActivateAudioInterfaceCompletionHandler {
    type Vtable = IActivateAudioInterfaceCompletionHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1104759211, 39010, 17482, [128, 246, 194, 97, 51, 77, 165, 235]);
}
impl ::std::convert::From<IActivateAudioInterfaceCompletionHandler> for ::windows::runtime::IUnknown {
    fn from(value: IActivateAudioInterfaceCompletionHandler) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IActivateAudioInterfaceCompletionHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IActivateAudioInterfaceCompletionHandler) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActivateAudioInterfaceCompletionHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IActivateAudioInterfaceCompletionHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActivateAudioInterfaceCompletionHandler_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, activateoperation: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioAmbisonicsControl(pub ::windows::runtime::IUnknown);
impl IAudioAmbisonicsControl {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetData(&self, pambisonicsparams: *const AMBISONICS_PARAMS, cbambisonicsparams: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pambisonicsparams), ::std::mem::transmute(cbambisonicsparams)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetHeadTracking<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, benableheadtracking: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), benableheadtracking.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetHeadTracking(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetRotation(&self, x: f32, y: f32, z: f32, w: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(x), ::std::mem::transmute(y), ::std::mem::transmute(z), ::std::mem::transmute(w)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioAmbisonicsControl {
    type Vtable = IAudioAmbisonicsControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(678579345, 57141, 18518, [159, 118, 214, 162, 100, 19, 243, 223]);
}
impl ::std::convert::From<IAudioAmbisonicsControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioAmbisonicsControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioAmbisonicsControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioAmbisonicsControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioAmbisonicsControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioAmbisonicsControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioAmbisonicsControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pambisonicsparams: *const AMBISONICS_PARAMS, cbambisonicsparams: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, benableheadtracking: super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbenableheadtracking: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, x: f32, y: f32, z: f32, w: f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioAutoGainControl(pub ::windows::runtime::IUnknown);
impl IAudioAutoGainControl {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetEnabled(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetEnabled<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, benable: Param0, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), benable.into_param().abi(), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioAutoGainControl {
    type Vtable = IAudioAutoGainControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2235572180, 28132, 19357, [152, 105, 45, 103, 83, 168, 47, 60]);
}
impl ::std::convert::From<IAudioAutoGainControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioAutoGainControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioAutoGainControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioAutoGainControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioAutoGainControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioAutoGainControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioAutoGainControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbenabled: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, benable: super::super::super::Foundation::BOOL, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioBass(pub ::windows::runtime::IUnknown);
impl IAudioBass {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevelRange(&self, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(pfminleveldb), ::std::mem::transmute(pfmaxleveldb), ::std::mem::transmute(pfstepping)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelUniform(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelAllChannels(&self, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(alevelsdb), ::std::mem::transmute(cchannels), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioBass {
    type Vtable = IAudioBass_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2729550297, 19891, 16989, [162, 178, 189, 51, 92, 179, 226, 229]);
}
impl ::std::convert::From<IAudioBass> for ::windows::runtime::IUnknown {
    fn from(value: IAudioBass) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioBass> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioBass) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioBass {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioBass {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioBass> for IPerChannelDbLevel {
    fn from(value: IAudioBass) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioBass> for IPerChannelDbLevel {
    fn from(value: &IAudioBass) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for IAudioBass {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for &IAudioBass {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioBass_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioCaptureClient(pub ::windows::runtime::IUnknown);
impl IAudioCaptureClient {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, ppdata: *mut *mut u8, pnumframestoread: *mut u32, pdwflags: *mut u32, pu64deviceposition: *mut u64, pu64qpcposition: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppdata), ::std::mem::transmute(pnumframestoread), ::std::mem::transmute(pdwflags), ::std::mem::transmute(pu64deviceposition), ::std::mem::transmute(pu64qpcposition)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ReleaseBuffer(&self, numframesread: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(numframesread)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetNextPacketSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioCaptureClient {
    type Vtable = IAudioCaptureClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3366829412, 59166, 18592, [164, 222, 24, 92, 57, 92, 211, 23]);
}
impl ::std::convert::From<IAudioCaptureClient> for ::windows::runtime::IUnknown {
    fn from(value: IAudioCaptureClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioCaptureClient> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioCaptureClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioCaptureClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioCaptureClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioCaptureClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppdata: *mut *mut u8, pnumframestoread: *mut u32, pdwflags: *mut u32, pu64deviceposition: *mut u64, pu64qpcposition: *mut u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numframesread: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumframesinnextpacket: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioChannelConfig(pub ::windows::runtime::IUnknown);
impl IAudioChannelConfig {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelConfig(&self, dwconfig: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwconfig), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelConfig(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioChannelConfig {
    type Vtable = IAudioChannelConfig_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3138503791, 60456, 18748, [184, 138, 93, 184, 128, 98, 206, 152]);
}
impl ::std::convert::From<IAudioChannelConfig> for ::windows::runtime::IUnknown {
    fn from(value: IAudioChannelConfig) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioChannelConfig> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioChannelConfig) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioChannelConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioChannelConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioChannelConfig_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwconfig: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwconfig: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClient(pub ::windows::runtime::IUnknown);
impl IAudioClient {
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn Initialize(&self, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(streamflags), ::std::mem::transmute(hnsbufferduration), ::std::mem::transmute(hnsperiodicity), ::std::mem::transmute(pformat), ::std::mem::transmute(audiosessionguid)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBufferSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetStreamLatency(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCurrentPadding(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn IsFormatSupported(&self, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(pformat), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMixFormat(&self) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDevicePeriod(&self, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(phnsdefaultdeviceperiod), ::std::mem::transmute(phnsminimumdeviceperiod)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetEventHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::HANDLE>>(&self, eventhandle: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), eventhandle.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService(&self, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(ppv)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClient {
    type Vtable = IAudioClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(481930572, 56314, 19506, [177, 120, 194, 245, 104, 167, 3, 178]);
}
impl ::std::convert::From<IAudioClient> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClient> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumbufferframes: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnslatency: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumpaddingframes: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX, ppclosestmatch: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppdeviceformat: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, eventhandle: super::super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClient2(pub ::windows::runtime::IUnknown);
impl IAudioClient2 {
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn Initialize(&self, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(streamflags), ::std::mem::transmute(hnsbufferduration), ::std::mem::transmute(hnsperiodicity), ::std::mem::transmute(pformat), ::std::mem::transmute(audiosessionguid)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBufferSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetStreamLatency(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCurrentPadding(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn IsFormatSupported(&self, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(pformat), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMixFormat(&self) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDevicePeriod(&self, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(phnsdefaultdeviceperiod), ::std::mem::transmute(phnsminimumdeviceperiod)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetEventHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::HANDLE>>(&self, eventhandle: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), eventhandle.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService(&self, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(ppv)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsOffloadCapable(&self, category: AUDIO_STREAM_CATEGORY) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(category), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetClientProperties(&self, pproperties: *const AudioClientProperties) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pproperties)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetBufferSizeLimits<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, pformat: *const super::super::Multimedia::WAVEFORMATEX, beventdriven: Param1, phnsminbufferduration: *mut i64, phnsmaxbufferduration: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pformat), beventdriven.into_param().abi(), ::std::mem::transmute(phnsminbufferduration), ::std::mem::transmute(phnsmaxbufferduration)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClient2 {
    type Vtable = IAudioClient2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1919383757, 62986, 20186, [130, 222, 228, 118, 16, 205, 120, 170]);
}
impl ::std::convert::From<IAudioClient2> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClient2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClient2> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClient2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioClient2> for IAudioClient {
    fn from(value: IAudioClient2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioClient2> for IAudioClient {
    fn from(value: &IAudioClient2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient> for IAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient> for &IAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClient2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumbufferframes: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnslatency: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumpaddingframes: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX, ppclosestmatch: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppdeviceformat: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, eventhandle: super::super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: AUDIO_STREAM_CATEGORY, pboffloadcapable: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pproperties: *const AudioClientProperties) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pformat: *const super::super::Multimedia::WAVEFORMATEX, beventdriven: super::super::super::Foundation::BOOL, phnsminbufferduration: *mut i64, phnsmaxbufferduration: *mut i64) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClient3(pub ::windows::runtime::IUnknown);
impl IAudioClient3 {
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn Initialize(&self, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(streamflags), ::std::mem::transmute(hnsbufferduration), ::std::mem::transmute(hnsperiodicity), ::std::mem::transmute(pformat), ::std::mem::transmute(audiosessionguid)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBufferSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetStreamLatency(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCurrentPadding(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn IsFormatSupported(&self, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(sharemode), ::std::mem::transmute(pformat), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMixFormat(&self) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDevicePeriod(&self, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(phnsdefaultdeviceperiod), ::std::mem::transmute(phnsminimumdeviceperiod)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetEventHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::HANDLE>>(&self, eventhandle: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), eventhandle.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService(&self, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(ppv)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsOffloadCapable(&self, category: AUDIO_STREAM_CATEGORY) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(category), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetClientProperties(&self, pproperties: *const AudioClientProperties) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pproperties)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetBufferSizeLimits<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, pformat: *const super::super::Multimedia::WAVEFORMATEX, beventdriven: Param1, phnsminbufferduration: *mut i64, phnsmaxbufferduration: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pformat), beventdriven.into_param().abi(), ::std::mem::transmute(phnsminbufferduration), ::std::mem::transmute(phnsmaxbufferduration)).ok()
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetSharedModeEnginePeriod(&self, pformat: *const super::super::Multimedia::WAVEFORMATEX, pdefaultperiodinframes: *mut u32, pfundamentalperiodinframes: *mut u32, pminperiodinframes: *mut u32, pmaxperiodinframes: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pformat), ::std::mem::transmute(pdefaultperiodinframes), ::std::mem::transmute(pfundamentalperiodinframes), ::std::mem::transmute(pminperiodinframes), ::std::mem::transmute(pmaxperiodinframes)).ok()
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetCurrentSharedModeEnginePeriod(&self, ppformat: *mut *mut super::super::Multimedia::WAVEFORMATEX, pcurrentperiodinframes: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppformat), ::std::mem::transmute(pcurrentperiodinframes)).ok()
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn InitializeSharedAudioStream(&self, streamflags: u32, periodinframes: u32, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(streamflags), ::std::mem::transmute(periodinframes), ::std::mem::transmute(pformat), ::std::mem::transmute(audiosessionguid)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClient3 {
    type Vtable = IAudioClient3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2127883783, 36455, 19668, [140, 26, 43, 122, 89, 135, 173, 66]);
}
impl ::std::convert::From<IAudioClient3> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClient3) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClient3> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClient3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioClient3> for IAudioClient2 {
    fn from(value: IAudioClient3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioClient3> for IAudioClient2 {
    fn from(value: &IAudioClient3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient2> for IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient2> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient2> for &IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient2> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IAudioClient3> for IAudioClient {
    fn from(value: IAudioClient3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioClient3> for IAudioClient {
    fn from(value: &IAudioClient3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient> for IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioClient> for &IAudioClient3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioClient> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClient3_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, streamflags: u32, hnsbufferduration: i64, hnsperiodicity: i64, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumbufferframes: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnslatency: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumpaddingframes: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sharemode: AUDCLNT_SHAREMODE, pformat: *const super::super::Multimedia::WAVEFORMATEX, ppclosestmatch: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppdeviceformat: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phnsdefaultdeviceperiod: *mut i64, phnsminimumdeviceperiod: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, eventhandle: super::super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppv: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: AUDIO_STREAM_CATEGORY, pboffloadcapable: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pproperties: *const AudioClientProperties) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pformat: *const super::super::Multimedia::WAVEFORMATEX, beventdriven: super::super::super::Foundation::BOOL, phnsminbufferduration: *mut i64, phnsmaxbufferduration: *mut i64) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia")))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pformat: *const super::super::Multimedia::WAVEFORMATEX, pdefaultperiodinframes: *mut u32, pfundamentalperiodinframes: *mut u32, pminperiodinframes: *mut u32, pmaxperiodinframes: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppformat: *mut *mut super::super::Multimedia::WAVEFORMATEX, pcurrentperiodinframes: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, streamflags: u32, periodinframes: u32, pformat: *const super::super::Multimedia::WAVEFORMATEX, audiosessionguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClientDuckingControl(pub ::windows::runtime::IUnknown);
impl IAudioClientDuckingControl {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetDuckingOptionsForCurrentStream(&self, options: AUDIO_DUCKING_OPTIONS) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(options)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClientDuckingControl {
    type Vtable = IAudioClientDuckingControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3347698561, 41612, 16744, [178, 143, 211, 168, 55, 146, 77, 195]);
}
impl ::std::convert::From<IAudioClientDuckingControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClientDuckingControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClientDuckingControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClientDuckingControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClientDuckingControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClientDuckingControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClientDuckingControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, options: AUDIO_DUCKING_OPTIONS) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClock(pub ::windows::runtime::IUnknown);
impl IAudioClock {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetFrequency(&self) -> ::windows::runtime::Result<u64> {
        let mut result__: <u64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetPosition(&self, pu64position: *mut u64, pu64qpcposition: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pu64position), ::std::mem::transmute(pu64qpcposition)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCharacteristics(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClock {
    type Vtable = IAudioClock_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3445829967, 16314, 18971, [129, 44, 239, 150, 53, 135, 40, 231]);
}
impl ::std::convert::From<IAudioClock> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClock) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClock> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClock) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClock {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClock {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClock_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pu64frequency: *mut u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pu64position: *mut u64, pu64qpcposition: *mut u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwcharacteristics: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClock2(pub ::windows::runtime::IUnknown);
impl IAudioClock2 {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDevicePosition(&self, deviceposition: *mut u64, qpcposition: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(deviceposition), ::std::mem::transmute(qpcposition)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClock2 {
    type Vtable = IAudioClock2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1867120499, 26407, 18860, [160, 8, 217, 140, 245, 231, 0, 72]);
}
impl ::std::convert::From<IAudioClock2> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClock2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClock2> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClock2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClock2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClock2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClock2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, deviceposition: *mut u64, qpcposition: *mut u64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioClockAdjustment(pub ::windows::runtime::IUnknown);
impl IAudioClockAdjustment {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetSampleRate(&self, flsamplerate: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(flsamplerate)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioClockAdjustment {
    type Vtable = IAudioClockAdjustment_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4142186656, 18137, 20408, [190, 33, 87, 163, 239, 43, 98, 108]);
}
impl ::std::convert::From<IAudioClockAdjustment> for ::windows::runtime::IUnknown {
    fn from(value: IAudioClockAdjustment) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioClockAdjustment> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioClockAdjustment) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioClockAdjustment {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioClockAdjustment {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioClockAdjustment_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flsamplerate: f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEffectsChangedNotificationClient(pub ::windows::runtime::IUnknown);
impl IAudioEffectsChangedNotificationClient {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnAudioEffectsChanged(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEffectsChangedNotificationClient {
    type Vtable = IAudioEffectsChangedNotificationClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2782843983, 15453, 19243, [189, 30, 93, 193, 238, 32, 187, 246]);
}
impl ::std::convert::From<IAudioEffectsChangedNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEffectsChangedNotificationClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEffectsChangedNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEffectsChangedNotificationClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEffectsChangedNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEffectsChangedNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEffectsChangedNotificationClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEffectsManager(pub ::windows::runtime::IUnknown);
impl IAudioEffectsManager {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterAudioEffectsChangedNotificationCallback<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEffectsChangedNotificationClient>>(&self, client: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterAudioEffectsChangedNotificationCallback<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEffectsChangedNotificationClient>>(&self, client: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), client.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetAudioEffects(&self, effects: *mut *mut AUDIO_EFFECT, numeffects: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(effects), ::std::mem::transmute(numeffects)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetAudioEffectState<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>>(&self, effectid: Param0, state: AUDIO_EFFECT_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), effectid.into_param().abi(), ::std::mem::transmute(state)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEffectsManager {
    type Vtable = IAudioEffectsManager_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1147188142, 19268, 17703, [134, 118, 117, 72, 168, 172, 210, 96]);
}
impl ::std::convert::From<IAudioEffectsManager> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEffectsManager) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEffectsManager> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEffectsManager) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEffectsManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEffectsManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEffectsManager_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, client: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, client: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, effects: *mut *mut AUDIO_EFFECT, numeffects: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, effectid: ::windows::runtime::GUID, state: AUDIO_EFFECT_STATE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointFormatControl(pub ::windows::runtime::IUnknown);
impl IAudioEndpointFormatControl {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ResetToDefault(&self, resetflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(resetflags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointFormatControl {
    type Vtable = IAudioEndpointFormatControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2018311488, 40841, 17774, [161, 166, 135, 59, 0, 106, 102, 78]);
}
impl ::std::convert::From<IAudioEndpointFormatControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointFormatControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointFormatControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointFormatControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointFormatControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointFormatControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointFormatControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, resetflags: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointLastBufferControl(pub ::windows::runtime::IUnknown);
impl IAudioEndpointLastBufferControl {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsLastBufferControlSupported(&self) -> super::super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_System_RemoteDesktop")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_RemoteDesktop`*"]
    pub unsafe fn ReleaseOutputDataPointerForLastBuffer(&self, pconnectionproperty: *const super::super::super::System::RemoteDesktop::APO_CONNECTION_PROPERTY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pconnectionproperty)))
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointLastBufferControl {
    type Vtable = IAudioEndpointLastBufferControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4166127059, 36765, 17463, [152, 97, 98, 245, 132, 195, 61, 214]);
}
impl ::std::convert::From<IAudioEndpointLastBufferControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointLastBufferControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointLastBufferControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointLastBufferControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointLastBufferControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointLastBufferControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointLastBufferControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_RemoteDesktop")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pconnectionproperty: *const super::super::super::System::RemoteDesktop::APO_CONNECTION_PROPERTY),
    #[cfg(not(feature = "Win32_System_RemoteDesktop"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointOffloadStreamMeter(pub ::windows::runtime::IUnknown);
impl IAudioEndpointOffloadStreamMeter {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMeterChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMeteringData(&self, u32channelcount: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(u32channelcount), &mut result__).from_abi::<f32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointOffloadStreamMeter {
    type Vtable = IAudioEndpointOffloadStreamMeter_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3780406734, 40401, 16779, [154, 178, 52, 140, 237, 22, 28, 134]);
}
impl ::std::convert::From<IAudioEndpointOffloadStreamMeter> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointOffloadStreamMeter) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointOffloadStreamMeter> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointOffloadStreamMeter) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointOffloadStreamMeter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointOffloadStreamMeter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointOffloadStreamMeter_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pu32channelcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, u32channelcount: u32, pf32peakvalues: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointOffloadStreamMute(pub ::windows::runtime::IUnknown);
impl IAudioEndpointOffloadStreamMute {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMute(&self, bmuted: u8) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(bmuted)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMute(&self) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u8>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointOffloadStreamMute {
    type Vtable = IAudioEndpointOffloadStreamMute_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3756135253, 24258, 16608, [141, 107, 113, 10, 195, 192, 2, 73]);
}
impl ::std::convert::From<IAudioEndpointOffloadStreamMute> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointOffloadStreamMute) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointOffloadStreamMute> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointOffloadStreamMute) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointOffloadStreamMute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointOffloadStreamMute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointOffloadStreamMute_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bmuted: u8) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbmuted: *mut u8) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointOffloadStreamVolume(pub ::windows::runtime::IUnknown);
impl IAudioEndpointOffloadStreamVolume {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolumes(&self, u32channelcount: u32, pf32volumes: *const f32, u32curvetype: AUDIO_CURVE_TYPE, pcurveduration: *const i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(u32channelcount), ::std::mem::transmute(pf32volumes), ::std::mem::transmute(u32curvetype), ::std::mem::transmute(pcurveduration)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolumes(&self, u32channelcount: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(u32channelcount), &mut result__).from_abi::<f32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointOffloadStreamVolume {
    type Vtable = IAudioEndpointOffloadStreamVolume_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1693572425, 29130, 17025, [134, 114, 58, 158, 221, 209, 208, 182]);
}
impl ::std::convert::From<IAudioEndpointOffloadStreamVolume> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointOffloadStreamVolume) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointOffloadStreamVolume> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointOffloadStreamVolume) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointOffloadStreamVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointOffloadStreamVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointOffloadStreamVolume_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pu32channelcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, u32channelcount: u32, pf32volumes: *const f32, u32curvetype: AUDIO_CURVE_TYPE, pcurveduration: *const i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, u32channelcount: u32, pf32volumes: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointVolume(pub ::windows::runtime::IUnknown);
impl IAudioEndpointVolume {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterControlChangeNotify<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEndpointVolumeCallback>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterControlChangeNotify<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEndpointVolumeCallback>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMasterVolumeLevel(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMasterVolumeLevelScalar(&self, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(flevel), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMasterVolumeLevel(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMasterVolumeLevelScalar(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolumeLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolumeLevelScalar(&self, nchannel: u32, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(flevel), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolumeLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolumeLevelScalar(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetMute<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, bmute: Param0, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), bmute.into_param().abi(), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetMute(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeStepInfo(&self, pnstep: *mut u32, pnstepcount: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pnstep), ::std::mem::transmute(pnstepcount)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn VolumeStepUp(&self, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn VolumeStepDown(&self, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn QueryHardwareSupport(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeRange(&self, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(pflvolumemindb), ::std::mem::transmute(pflvolumemaxdb), ::std::mem::transmute(pflvolumeincrementdb)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointVolume {
    type Vtable = IAudioEndpointVolume_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1558129794, 33822, 17734, [151, 34, 12, 247, 64, 120, 34, 154]);
}
impl ::std::convert::From<IAudioEndpointVolume> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointVolume) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointVolume> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointVolume) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointVolume_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnchannelcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bmute: super::super::super::Foundation::BOOL, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbmute: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnstep: *mut u32, pnstepcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwhardwaresupportmask: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointVolumeCallback(pub ::windows::runtime::IUnknown);
impl IAudioEndpointVolumeCallback {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnNotify(&self, pnotify: *mut AUDIO_VOLUME_NOTIFICATION_DATA) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pnotify)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointVolumeCallback {
    type Vtable = IAudioEndpointVolumeCallback_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1702364410, 54957, 17558, [138, 96, 53, 39, 82, 175, 79, 137]);
}
impl ::std::convert::From<IAudioEndpointVolumeCallback> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointVolumeCallback) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointVolumeCallback> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointVolumeCallback) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointVolumeCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointVolumeCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointVolumeCallback_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: *mut AUDIO_VOLUME_NOTIFICATION_DATA) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioEndpointVolumeEx(pub ::windows::runtime::IUnknown);
impl IAudioEndpointVolumeEx {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterControlChangeNotify<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEndpointVolumeCallback>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterControlChangeNotify<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioEndpointVolumeCallback>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMasterVolumeLevel(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMasterVolumeLevelScalar(&self, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(flevel), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMasterVolumeLevel(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMasterVolumeLevelScalar(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolumeLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolumeLevelScalar(&self, nchannel: u32, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(flevel), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolumeLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolumeLevelScalar(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetMute<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, bmute: Param0, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), bmute.into_param().abi(), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetMute(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeStepInfo(&self, pnstep: *mut u32, pnstepcount: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pnstep), ::std::mem::transmute(pnstepcount)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn VolumeStepUp(&self, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn VolumeStepDown(&self, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn QueryHardwareSupport(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeRange(&self, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(pflvolumemindb), ::std::mem::transmute(pflvolumemaxdb), ::std::mem::transmute(pflvolumeincrementdb)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetVolumeRangeChannel(&self, ichannel: u32, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), ::std::mem::transmute(ichannel), ::std::mem::transmute(pflvolumemindb), ::std::mem::transmute(pflvolumemaxdb), ::std::mem::transmute(pflvolumeincrementdb)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioEndpointVolumeEx {
    type Vtable = IAudioEndpointVolumeEx_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1726027652, 63125, 20264, [165, 5, 167, 8, 0, 129, 167, 143]);
}
impl ::std::convert::From<IAudioEndpointVolumeEx> for ::windows::runtime::IUnknown {
    fn from(value: IAudioEndpointVolumeEx) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioEndpointVolumeEx> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioEndpointVolumeEx) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioEndpointVolumeEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioEndpointVolumeEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioEndpointVolumeEx> for IAudioEndpointVolume {
    fn from(value: IAudioEndpointVolumeEx) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioEndpointVolumeEx> for IAudioEndpointVolume {
    fn from(value: &IAudioEndpointVolumeEx) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioEndpointVolume> for IAudioEndpointVolumeEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioEndpointVolume> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioEndpointVolume> for &IAudioEndpointVolumeEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioEndpointVolume> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioEndpointVolumeEx_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnchannelcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, flevel: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bmute: super::super::super::Foundation::BOOL, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbmute: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnstep: *mut u32, pnstepcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwhardwaresupportmask: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ichannel: u32, pflvolumemindb: *mut f32, pflvolumemaxdb: *mut f32, pflvolumeincrementdb: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioFormatEnumerator(pub ::windows::runtime::IUnknown);
impl IAudioFormatEnumerator {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetFormat(&self, index: u32) -> ::windows::runtime::Result<*mut super::super::Multimedia::WAVEFORMATEX> {
        let mut result__: <*mut super::super::Multimedia::WAVEFORMATEX as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(index), &mut result__).from_abi::<*mut super::super::Multimedia::WAVEFORMATEX>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioFormatEnumerator {
    type Vtable = IAudioFormatEnumerator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3705317464, 35162, 18978, [165, 235, 103, 189, 165, 6, 9, 109]);
}
impl ::std::convert::From<IAudioFormatEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: IAudioFormatEnumerator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioFormatEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioFormatEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioFormatEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioFormatEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioFormatEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, count: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, index: u32, format: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioInputSelector(pub ::windows::runtime::IUnknown);
impl IAudioInputSelector {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSelection(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetSelection(&self, nidselect: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nidselect), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioInputSelector {
    type Vtable = IAudioInputSelector_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1325652994, 24174, 18003, [143, 114, 160, 48, 193, 35, 213, 152]);
}
impl ::std::convert::From<IAudioInputSelector> for ::windows::runtime::IUnknown {
    fn from(value: IAudioInputSelector) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioInputSelector> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioInputSelector) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioInputSelector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioInputSelector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioInputSelector_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnidselected: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nidselect: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioLfxControl(pub ::windows::runtime::IUnknown);
impl IAudioLfxControl {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetLocalEffectsState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, benabled: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), benabled.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetLocalEffectsState(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioLfxControl {
    type Vtable = IAudioLfxControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(124414242, 55298, 20355, [186, 246, 64, 157, 156, 161, 27, 254]);
}
impl ::std::convert::From<IAudioLfxControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioLfxControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioLfxControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioLfxControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioLfxControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioLfxControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioLfxControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, benabled: super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbenabled: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioLoudness(pub ::windows::runtime::IUnknown);
impl IAudioLoudness {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetEnabled(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetEnabled<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, benable: Param0, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), benable.into_param().abi(), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioLoudness {
    type Vtable = IAudioLoudness_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2106266679, 56659, 17232, [156, 27, 30, 226, 137, 11, 217, 56]);
}
impl ::std::convert::From<IAudioLoudness> for ::windows::runtime::IUnknown {
    fn from(value: IAudioLoudness) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioLoudness> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioLoudness) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioLoudness {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioLoudness {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioLoudness_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbenabled: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, benable: super::super::super::Foundation::BOOL, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioMeterInformation(pub ::windows::runtime::IUnknown);
impl IAudioMeterInformation {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetPeakValue(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMeteringChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelsPeakValues(&self, u32channelcount: u32, afpeakvalues: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(u32channelcount), ::std::mem::transmute(afpeakvalues)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn QueryHardwareSupport(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioMeterInformation {
    type Vtable = IAudioMeterInformation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3223459574, 35943, 19291, [157, 0, 208, 8, 231, 62, 0, 100]);
}
impl ::std::convert::From<IAudioMeterInformation> for ::windows::runtime::IUnknown {
    fn from(value: IAudioMeterInformation) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioMeterInformation> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioMeterInformation) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioMeterInformation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioMeterInformation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioMeterInformation_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfpeak: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnchannelcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, u32channelcount: u32, afpeakvalues: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwhardwaresupportmask: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioMidrange(pub ::windows::runtime::IUnknown);
impl IAudioMidrange {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevelRange(&self, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(pfminleveldb), ::std::mem::transmute(pfmaxleveldb), ::std::mem::transmute(pfstepping)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelUniform(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelAllChannels(&self, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(alevelsdb), ::std::mem::transmute(cchannels), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioMidrange {
    type Vtable = IAudioMidrange_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1582610135, 46155, 16601, [154, 158, 230, 145, 217, 206, 110, 223]);
}
impl ::std::convert::From<IAudioMidrange> for ::windows::runtime::IUnknown {
    fn from(value: IAudioMidrange) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioMidrange> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioMidrange) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioMidrange {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioMidrange {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioMidrange> for IPerChannelDbLevel {
    fn from(value: IAudioMidrange) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioMidrange> for IPerChannelDbLevel {
    fn from(value: &IAudioMidrange) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for IAudioMidrange {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for &IAudioMidrange {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioMidrange_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioMute(pub ::windows::runtime::IUnknown);
impl IAudioMute {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetMute<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, bmuted: Param0, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), bmuted.into_param().abi(), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetMute(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioMute {
    type Vtable = IAudioMute_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3745885930, 46922, 19307, [175, 173, 35, 102, 182, 170, 1, 46]);
}
impl ::std::convert::From<IAudioMute> for ::windows::runtime::IUnknown {
    fn from(value: IAudioMute) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioMute> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioMute) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioMute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioMute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioMute_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bmuted: super::super::super::Foundation::BOOL, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbmuted: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioOutputSelector(pub ::windows::runtime::IUnknown);
impl IAudioOutputSelector {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSelection(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetSelection(&self, nidselect: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nidselect), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioOutputSelector {
    type Vtable = IAudioOutputSelector_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3142672233, 38055, 17054, [139, 156, 39, 27, 63, 17, 163, 171]);
}
impl ::std::convert::From<IAudioOutputSelector> for ::windows::runtime::IUnknown {
    fn from(value: IAudioOutputSelector) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioOutputSelector> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioOutputSelector) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioOutputSelector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioOutputSelector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioOutputSelector_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnidselected: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nidselect: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioPeakMeter(pub ::windows::runtime::IUnknown);
impl IAudioPeakMeter {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioPeakMeter {
    type Vtable = IAudioPeakMeter_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3715732028, 1433, 17888, [184, 182, 200, 223, 125, 182, 231, 150]);
}
impl ::std::convert::From<IAudioPeakMeter> for ::windows::runtime::IUnknown {
    fn from(value: IAudioPeakMeter) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioPeakMeter> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioPeakMeter) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioPeakMeter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioPeakMeter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioPeakMeter_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioProcessingObjectLoggingService(pub ::windows::runtime::IUnknown);
impl IAudioProcessingObjectLoggingService {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn ApoLog<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, level: APO_LOG_LEVEL, format: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(level), format.into_param().abi()))
    }
}
unsafe impl ::windows::runtime::Interface for IAudioProcessingObjectLoggingService {
    type Vtable = IAudioProcessingObjectLoggingService_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1770979591, 5957, 18184, [149, 165, 216, 68, 120, 166, 42, 101]);
}
impl ::std::convert::From<IAudioProcessingObjectLoggingService> for ::windows::runtime::IUnknown {
    fn from(value: IAudioProcessingObjectLoggingService) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioProcessingObjectLoggingService> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioProcessingObjectLoggingService) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioProcessingObjectLoggingService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioProcessingObjectLoggingService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioProcessingObjectLoggingService_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, level: APO_LOG_LEVEL, format: super::super::super::Foundation::PWSTR),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioProcessingObjectNotifications(pub ::windows::runtime::IUnknown);
impl IAudioProcessingObjectNotifications {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetApoNotificationRegistrationInfo(&self, aponotifications: *mut *mut APO_NOTIFICATION_DESCRIPTOR, count: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(aponotifications), ::std::mem::transmute(count)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn HandleNotification(&self, aponotification: *const APO_NOTIFICATION) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(aponotification)))
    }
}
unsafe impl ::windows::runtime::Interface for IAudioProcessingObjectNotifications {
    type Vtable = IAudioProcessingObjectNotifications_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1454425967, 765, 19233, [165, 46, 159, 130, 25, 252, 134, 228]);
}
impl ::std::convert::From<IAudioProcessingObjectNotifications> for ::windows::runtime::IUnknown {
    fn from(value: IAudioProcessingObjectNotifications) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioProcessingObjectNotifications> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioProcessingObjectNotifications) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioProcessingObjectNotifications {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioProcessingObjectNotifications {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioProcessingObjectNotifications_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, aponotifications: *mut *mut APO_NOTIFICATION_DESCRIPTOR, count: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, aponotification: *const ::std::mem::ManuallyDrop<APO_NOTIFICATION>),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioProcessingObjectRTQueueService(pub ::windows::runtime::IUnknown);
impl IAudioProcessingObjectRTQueueService {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetRealTimeWorkQueue(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioProcessingObjectRTQueueService {
    type Vtable = IAudioProcessingObjectRTQueueService_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2899729967, 38235, 19287, [185, 191, 172, 41, 123, 183, 82, 201]);
}
impl ::std::convert::From<IAudioProcessingObjectRTQueueService> for ::windows::runtime::IUnknown {
    fn from(value: IAudioProcessingObjectRTQueueService) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioProcessingObjectRTQueueService> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioProcessingObjectRTQueueService) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioProcessingObjectRTQueueService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioProcessingObjectRTQueueService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioProcessingObjectRTQueueService_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, workqueueid: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioRenderClient(pub ::windows::runtime::IUnknown);
impl IAudioRenderClient {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, numframesrequested: u32) -> ::windows::runtime::Result<*mut u8> {
        let mut result__: <*mut u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(numframesrequested), &mut result__).from_abi::<*mut u8>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ReleaseBuffer(&self, numframeswritten: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(numframeswritten), ::std::mem::transmute(dwflags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioRenderClient {
    type Vtable = IAudioRenderClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4069829884, 12614, 17539, [167, 191, 173, 220, 167, 194, 96, 226]);
}
impl ::std::convert::From<IAudioRenderClient> for ::windows::runtime::IUnknown {
    fn from(value: IAudioRenderClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioRenderClient> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioRenderClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioRenderClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioRenderClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioRenderClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numframesrequested: u32, ppdata: *mut *mut u8) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numframeswritten: u32, dwflags: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionControl(pub ::windows::runtime::IUnknown);
impl IAudioSessionControl {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetState(&self) -> ::windows::runtime::Result<AudioSessionState> {
        let mut result__: <AudioSessionState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioSessionState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetDisplayName(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetDisplayName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, value: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), value.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetIconPath(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetIconPath<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, value: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), value.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetGroupingParam(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetGroupingParam(&self, r#override: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#override), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterAudioSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionEvents>>(&self, newnotifications: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), newnotifications.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterAudioSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionEvents>>(&self, newnotifications: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), newnotifications.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionControl {
    type Vtable = IAudioSessionControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4105282969, 29286, 17177, [168, 202, 231, 10, 203, 17, 232, 205]);
}
impl ::std::convert::From<IAudioSessionControl> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut AudioSessionState) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#override: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newnotifications: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newnotifications: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionControl2(pub ::windows::runtime::IUnknown);
impl IAudioSessionControl2 {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetState(&self) -> ::windows::runtime::Result<AudioSessionState> {
        let mut result__: <AudioSessionState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioSessionState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetDisplayName(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetDisplayName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, value: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), value.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetIconPath(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetIconPath<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, value: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), value.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetGroupingParam(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetGroupingParam(&self, r#override: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#override), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterAudioSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionEvents>>(&self, newnotifications: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), newnotifications.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterAudioSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionEvents>>(&self, newnotifications: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), newnotifications.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetSessionIdentifier(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetSessionInstanceIdentifier(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetProcessId(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn IsSystemSoundsSession(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetDuckingPreference<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, optout: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), optout.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionControl2 {
    type Vtable = IAudioSessionControl2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3216506760, 29241, 20425, [143, 162, 7, 201, 80, 190, 156, 109]);
}
impl ::std::convert::From<IAudioSessionControl2> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionControl2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionControl2> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionControl2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionControl2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionControl2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioSessionControl2> for IAudioSessionControl {
    fn from(value: IAudioSessionControl2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioSessionControl2> for IAudioSessionControl {
    fn from(value: &IAudioSessionControl2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioSessionControl> for IAudioSessionControl2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioSessionControl> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioSessionControl> for &IAudioSessionControl2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioSessionControl> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionControl2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut AudioSessionState) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#override: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newnotifications: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newnotifications: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pretval: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optout: super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionEnumerator(pub ::windows::runtime::IUnknown);
impl IAudioSessionEnumerator {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSession(&self, sessioncount: i32) -> ::windows::runtime::Result<IAudioSessionControl> {
        let mut result__: <IAudioSessionControl as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(sessioncount), &mut result__).from_abi::<IAudioSessionControl>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionEnumerator {
    type Vtable = IAudioSessionEnumerator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3807755025, 1392, 16586, [172, 221, 58, 160, 18, 119, 222, 232]);
}
impl ::std::convert::From<IAudioSessionEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionEnumerator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessioncount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessioncount: i32, session: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionEvents(pub ::windows::runtime::IUnknown);
impl IAudioSessionEvents {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnDisplayNameChanged<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, newdisplayname: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), newdisplayname.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnIconPathChanged<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, newiconpath: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), newiconpath.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnSimpleVolumeChanged<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, newvolume: f32, newmute: Param1, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(newvolume), newmute.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnChannelVolumeChanged(&self, channelcount: u32, newchannelvolumearray: *const f32, changedchannel: u32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(channelcount), ::std::mem::transmute(newchannelvolumearray), ::std::mem::transmute(changedchannel), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnGroupingParamChanged(&self, newgroupingparam: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(newgroupingparam), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnStateChanged(&self, newstate: AudioSessionState) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(newstate)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnSessionDisconnected(&self, disconnectreason: AudioSessionDisconnectReason) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(disconnectreason)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionEvents {
    type Vtable = IAudioSessionEvents_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(613518028, 25779, 14273, [140, 169, 116, 166, 110, 153, 87, 168]);
}
impl ::std::convert::From<IAudioSessionEvents> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionEvents) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionEvents> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionEvents) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionEvents {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionEvents {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionEvents_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newdisplayname: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newiconpath: super::super::super::Foundation::PWSTR, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newvolume: f32, newmute: super::super::super::Foundation::BOOL, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, channelcount: u32, newchannelvolumearray: *const f32, changedchannel: u32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newgroupingparam: *const ::windows::runtime::GUID, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newstate: AudioSessionState) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, disconnectreason: AudioSessionDisconnectReason) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionManager(pub ::windows::runtime::IUnknown);
impl IAudioSessionManager {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioSessionControl(&self, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32) -> ::windows::runtime::Result<IAudioSessionControl> {
        let mut result__: <IAudioSessionControl as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(audiosessionguid), ::std::mem::transmute(streamflags), &mut result__).from_abi::<IAudioSessionControl>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSimpleAudioVolume(&self, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32) -> ::windows::runtime::Result<ISimpleAudioVolume> {
        let mut result__: <ISimpleAudioVolume as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(audiosessionguid), ::std::mem::transmute(streamflags), &mut result__).from_abi::<ISimpleAudioVolume>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionManager {
    type Vtable = IAudioSessionManager_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3215553009, 19806, 16571, [147, 94, 150, 112, 57, 191, 190, 228]);
}
impl ::std::convert::From<IAudioSessionManager> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionManager) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionManager> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionManager) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionManager_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32, sessioncontrol: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32, audiovolume: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionManager2(pub ::windows::runtime::IUnknown);
impl IAudioSessionManager2 {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioSessionControl(&self, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32) -> ::windows::runtime::Result<IAudioSessionControl> {
        let mut result__: <IAudioSessionControl as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(audiosessionguid), ::std::mem::transmute(streamflags), &mut result__).from_abi::<IAudioSessionControl>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSimpleAudioVolume(&self, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32) -> ::windows::runtime::Result<ISimpleAudioVolume> {
        let mut result__: <ISimpleAudioVolume as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(audiosessionguid), ::std::mem::transmute(streamflags), &mut result__).from_abi::<ISimpleAudioVolume>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSessionEnumerator(&self) -> ::windows::runtime::Result<IAudioSessionEnumerator> {
        let mut result__: <IAudioSessionEnumerator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IAudioSessionEnumerator>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionNotification>>(&self, sessionnotification: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), sessionnotification.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterSessionNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionNotification>>(&self, sessionnotification: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), sessionnotification.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn RegisterDuckNotification<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, IAudioVolumeDuckNotification>>(&self, sessionid: Param0, ducknotification: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), sessionid.into_param().abi(), ducknotification.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterDuckNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioVolumeDuckNotification>>(&self, ducknotification: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ducknotification.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionManager2 {
    type Vtable = IAudioSessionManager2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2007669152, 7126, 18511, [139, 199, 44, 101, 76, 154, 155, 111]);
}
impl ::std::convert::From<IAudioSessionManager2> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionManager2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionManager2> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionManager2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionManager2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionManager2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioSessionManager2> for IAudioSessionManager {
    fn from(value: IAudioSessionManager2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioSessionManager2> for IAudioSessionManager {
    fn from(value: &IAudioSessionManager2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioSessionManager> for IAudioSessionManager2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioSessionManager> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAudioSessionManager> for &IAudioSessionManager2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAudioSessionManager> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionManager2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32, sessioncontrol: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audiosessionguid: *const ::windows::runtime::GUID, streamflags: u32, audiovolume: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionenum: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionnotification: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionnotification: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionid: super::super::super::Foundation::PWSTR, ducknotification: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ducknotification: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSessionNotification(pub ::windows::runtime::IUnknown);
impl IAudioSessionNotification {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnSessionCreated<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSessionControl>>(&self, newsession: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), newsession.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSessionNotification {
    type Vtable = IAudioSessionNotification_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1679675915, 19777, 18892, [171, 163, 23, 75, 148, 119, 187, 8]);
}
impl ::std::convert::From<IAudioSessionNotification> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSessionNotification) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSessionNotification> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSessionNotification) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSessionNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSessionNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSessionNotification_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newsession: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioStateMonitor(pub ::windows::runtime::IUnknown);
impl IAudioStateMonitor {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterCallback(&self, callback: ::std::option::Option<PAudioStateMonitorCallback>, context: *const ::std::ffi::c_void) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(callback), ::std::mem::transmute(context), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterCallback(&self, registration: i64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(registration)))
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSoundLevel(&self) -> AudioStateMonitorSoundLevel {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for IAudioStateMonitor {
    type Vtable = IAudioStateMonitor_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1673365304, 58125, 19575, [191, 92, 131, 78, 135, 198, 87, 226]);
}
impl ::std::convert::From<IAudioStateMonitor> for ::windows::runtime::IUnknown {
    fn from(value: IAudioStateMonitor) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioStateMonitor> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioStateMonitor) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioStateMonitor {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioStateMonitor {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioStateMonitor_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, callback: ::windows::runtime::RawPtr, context: *const ::std::ffi::c_void, registration: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, registration: i64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> AudioStateMonitorSoundLevel,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioStreamVolume(pub ::windows::runtime::IUnknown);
impl IAudioStreamVolume {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolume(&self, dwindex: u32, flevel: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwindex), ::std::mem::transmute(flevel)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolume(&self, dwindex: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwindex), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetAllVolumes(&self, dwcount: u32, pfvolumes: *const f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcount), ::std::mem::transmute(pfvolumes)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAllVolumes(&self, dwcount: u32, pfvolumes: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcount), ::std::mem::transmute(pfvolumes)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioStreamVolume {
    type Vtable = IAudioStreamVolume_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2466334855, 9261, 16488, [138, 21, 207, 94, 147, 185, 15, 227]);
}
impl ::std::convert::From<IAudioStreamVolume> for ::windows::runtime::IUnknown {
    fn from(value: IAudioStreamVolume) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioStreamVolume> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioStreamVolume) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioStreamVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioStreamVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioStreamVolume_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwindex: u32, flevel: f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwindex: u32, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcount: u32, pfvolumes: *const f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcount: u32, pfvolumes: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSystemEffects3(pub ::windows::runtime::IUnknown);
impl IAudioSystemEffects3 {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetEffectsList<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::HANDLE>>(&self, ppeffectsids: *mut *mut ::windows::runtime::GUID, pceffects: *mut u32, event: Param2) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppeffectsids), ::std::mem::transmute(pceffects), event.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetControllableSystemEffectsList<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::HANDLE>>(&self, effects: *mut *mut AUDIO_SYSTEMEFFECT, numeffects: *mut u32, event: Param2) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(effects), ::std::mem::transmute(numeffects), event.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetAudioSystemEffectState<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>>(&self, effectid: Param0, state: AUDIO_SYSTEMEFFECT_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), effectid.into_param().abi(), ::std::mem::transmute(state)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSystemEffects3 {
    type Vtable = IAudioSystemEffects3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3314233805, 64618, 16981, [188, 31, 173, 41, 187, 10, 74, 23]);
}
impl ::std::convert::From<IAudioSystemEffects3> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSystemEffects3) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSystemEffects3> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSystemEffects3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl ::std::convert::From<IAudioSystemEffects3> for super::DirectMusic::IAudioSystemEffects2 {
    fn from(value: IAudioSystemEffects3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl ::std::convert::From<&IAudioSystemEffects3> for super::DirectMusic::IAudioSystemEffects2 {
    fn from(value: &IAudioSystemEffects3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl<'a> ::windows::runtime::IntoParam<'a, super::DirectMusic::IAudioSystemEffects2> for IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::DirectMusic::IAudioSystemEffects2> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl<'a> ::windows::runtime::IntoParam<'a, super::DirectMusic::IAudioSystemEffects2> for &IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::DirectMusic::IAudioSystemEffects2> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl ::std::convert::From<IAudioSystemEffects3> for super::DirectMusic::IAudioSystemEffects {
    fn from(value: IAudioSystemEffects3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl ::std::convert::From<&IAudioSystemEffects3> for super::DirectMusic::IAudioSystemEffects {
    fn from(value: &IAudioSystemEffects3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl<'a> ::windows::runtime::IntoParam<'a, super::DirectMusic::IAudioSystemEffects> for IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::DirectMusic::IAudioSystemEffects> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectMusic")]
impl<'a> ::windows::runtime::IntoParam<'a, super::DirectMusic::IAudioSystemEffects> for &IAudioSystemEffects3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::DirectMusic::IAudioSystemEffects> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSystemEffects3_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppeffectsids: *mut *mut ::windows::runtime::GUID, pceffects: *mut u32, event: super::super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, effects: *mut *mut AUDIO_SYSTEMEFFECT, numeffects: *mut u32, event: super::super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, effectid: ::windows::runtime::GUID, state: AUDIO_SYSTEMEFFECT_STATE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSystemEffectsPropertyChangeNotificationClient(pub ::windows::runtime::IUnknown);
impl IAudioSystemEffectsPropertyChangeNotificationClient {
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OnPropertyChanged<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::System::PropertiesSystem::PROPERTYKEY>>(&self, r#type: __MIDL___MIDL_itf_mmdeviceapi_0000_0008_0002, key: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), key.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSystemEffectsPropertyChangeNotificationClient {
    type Vtable = IAudioSystemEffectsPropertyChangeNotificationClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(537173312, 22229, 16398, [162, 239, 56, 85, 153, 254, 237, 73]);
}
impl ::std::convert::From<IAudioSystemEffectsPropertyChangeNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSystemEffectsPropertyChangeNotificationClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSystemEffectsPropertyChangeNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSystemEffectsPropertyChangeNotificationClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSystemEffectsPropertyChangeNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSystemEffectsPropertyChangeNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSystemEffectsPropertyChangeNotificationClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_PropertiesSystem")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: __MIDL___MIDL_itf_mmdeviceapi_0000_0008_0002, key: super::super::super::System::PropertiesSystem::PROPERTYKEY) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioSystemEffectsPropertyStore(pub ::windows::runtime::IUnknown);
impl IAudioSystemEffectsPropertyStore {
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OpenDefaultPropertyStore(&self, stgmaccess: u32) -> ::windows::runtime::Result<super::super::super::System::PropertiesSystem::IPropertyStore> {
        let mut result__: <super::super::super::System::PropertiesSystem::IPropertyStore as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(stgmaccess), &mut result__).from_abi::<super::super::super::System::PropertiesSystem::IPropertyStore>(result__)
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OpenUserPropertyStore(&self, stgmaccess: u32) -> ::windows::runtime::Result<super::super::super::System::PropertiesSystem::IPropertyStore> {
        let mut result__: <super::super::super::System::PropertiesSystem::IPropertyStore as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(stgmaccess), &mut result__).from_abi::<super::super::super::System::PropertiesSystem::IPropertyStore>(result__)
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OpenVolatilePropertyStore(&self, stgmaccess: u32) -> ::windows::runtime::Result<super::super::super::System::PropertiesSystem::IPropertyStore> {
        let mut result__: <super::super::super::System::PropertiesSystem::IPropertyStore as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(stgmaccess), &mut result__).from_abi::<super::super::super::System::PropertiesSystem::IPropertyStore>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ResetUserPropertyStore(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ResetVolatilePropertyStore(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterPropertyChangeNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSystemEffectsPropertyChangeNotificationClient>>(&self, callback: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), callback.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterPropertyChangeNotification<'a, Param0: ::windows::runtime::IntoParam<'a, IAudioSystemEffectsPropertyChangeNotificationClient>>(&self, callback: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), callback.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioSystemEffectsPropertyStore {
    type Vtable = IAudioSystemEffectsPropertyStore_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(808118265, 55264, 17380, [151, 27, 31, 130, 147, 97, 61, 42]);
}
impl ::std::convert::From<IAudioSystemEffectsPropertyStore> for ::windows::runtime::IUnknown {
    fn from(value: IAudioSystemEffectsPropertyStore) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioSystemEffectsPropertyStore> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioSystemEffectsPropertyStore) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioSystemEffectsPropertyStore {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioSystemEffectsPropertyStore {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioSystemEffectsPropertyStore_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_PropertiesSystem")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stgmaccess: u32, propstore: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stgmaccess: u32, propstore: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stgmaccess: u32, propstore: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, callback: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, callback: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioTreble(pub ::windows::runtime::IUnknown);
impl IAudioTreble {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevelRange(&self, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(pfminleveldb), ::std::mem::transmute(pfmaxleveldb), ::std::mem::transmute(pfstepping)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelUniform(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelAllChannels(&self, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(alevelsdb), ::std::mem::transmute(cchannels), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioTreble {
    type Vtable = IAudioTreble_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(175208466, 26958, 18695, [183, 75, 186, 250, 92, 253, 202, 123]);
}
impl ::std::convert::From<IAudioTreble> for ::windows::runtime::IUnknown {
    fn from(value: IAudioTreble) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioTreble> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioTreble) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioTreble {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioTreble {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioTreble> for IPerChannelDbLevel {
    fn from(value: IAudioTreble) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioTreble> for IPerChannelDbLevel {
    fn from(value: &IAudioTreble) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for IAudioTreble {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for &IAudioTreble {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioTreble_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioVolumeDuckNotification(pub ::windows::runtime::IUnknown);
impl IAudioVolumeDuckNotification {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnVolumeDuckNotification<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, sessionid: Param0, countcommunicationsessions: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), sessionid.into_param().abi(), ::std::mem::transmute(countcommunicationsessions)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnVolumeUnduckNotification<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, sessionid: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), sessionid.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioVolumeDuckNotification {
    type Vtable = IAudioVolumeDuckNotification_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3283256532, 27961, 17241, [179, 207, 181, 109, 219, 59, 179, 156]);
}
impl ::std::convert::From<IAudioVolumeDuckNotification> for ::windows::runtime::IUnknown {
    fn from(value: IAudioVolumeDuckNotification) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioVolumeDuckNotification> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioVolumeDuckNotification) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioVolumeDuckNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioVolumeDuckNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioVolumeDuckNotification_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionid: super::super::super::Foundation::PWSTR, countcommunicationsessions: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sessionid: super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAudioVolumeLevel(pub ::windows::runtime::IUnknown);
impl IAudioVolumeLevel {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevelRange(&self, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(pfminleveldb), ::std::mem::transmute(pfmaxleveldb), ::std::mem::transmute(pfstepping)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelUniform(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelAllChannels(&self, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(alevelsdb), ::std::mem::transmute(cchannels), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAudioVolumeLevel {
    type Vtable = IAudioVolumeLevel_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2142745743, 21277, 17570, [188, 179, 90, 213, 161, 52, 179, 220]);
}
impl ::std::convert::From<IAudioVolumeLevel> for ::windows::runtime::IUnknown {
    fn from(value: IAudioVolumeLevel) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAudioVolumeLevel> for ::windows::runtime::IUnknown {
    fn from(value: &IAudioVolumeLevel) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAudioVolumeLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAudioVolumeLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAudioVolumeLevel> for IPerChannelDbLevel {
    fn from(value: IAudioVolumeLevel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAudioVolumeLevel> for IPerChannelDbLevel {
    fn from(value: &IAudioVolumeLevel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for IAudioVolumeLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPerChannelDbLevel> for &IAudioVolumeLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPerChannelDbLevel> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioVolumeLevel_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IChannelAudioVolume(pub ::windows::runtime::IUnknown);
impl IChannelAudioVolume {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetChannelVolume(&self, dwindex: u32, flevel: f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwindex), ::std::mem::transmute(flevel), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelVolume(&self, dwindex: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwindex), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetAllVolumes(&self, dwcount: u32, pfvolumes: *const f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcount), ::std::mem::transmute(pfvolumes), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAllVolumes(&self, dwcount: u32, pfvolumes: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcount), ::std::mem::transmute(pfvolumes)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IChannelAudioVolume {
    type Vtable = IChannelAudioVolume_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(471173217, 46387, 19248, [177, 207, 232, 83, 229, 28, 89, 184]);
}
impl ::std::convert::From<IChannelAudioVolume> for ::windows::runtime::IUnknown {
    fn from(value: IChannelAudioVolume) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IChannelAudioVolume> for ::windows::runtime::IUnknown {
    fn from(value: &IChannelAudioVolume) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IChannelAudioVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IChannelAudioVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IChannelAudioVolume_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwindex: u32, flevel: f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwindex: u32, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcount: u32, pfvolumes: *const f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcount: u32, pfvolumes: *mut f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IConnector(pub ::windows::runtime::IUnknown);
impl IConnector {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetType(&self) -> ::windows::runtime::Result<ConnectorType> {
        let mut result__: <ConnectorType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ConnectorType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDataFlow(&self) -> ::windows::runtime::Result<DataFlow> {
        let mut result__: <DataFlow as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<DataFlow>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ConnectTo<'a, Param0: ::windows::runtime::IntoParam<'a, IConnector>>(&self, pconnectto: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pconnectto.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Disconnect(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsConnected(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetConnectedTo(&self) -> ::windows::runtime::Result<IConnector> {
        let mut result__: <IConnector as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IConnector>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetConnectorIdConnectedTo(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetDeviceIdConnectedTo(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IConnector {
    type Vtable = IConnector_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2620145752, 9205, 16862, [135, 122, 223, 58, 242, 54, 160, 158]);
}
impl ::std::convert::From<IConnector> for ::windows::runtime::IUnknown {
    fn from(value: IConnector) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IConnector> for ::windows::runtime::IUnknown {
    fn from(value: &IConnector) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IConnector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IConnector {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IConnector_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptype: *mut ConnectorType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflow: *mut DataFlow) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pconnectto: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbconnected: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppconto: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrconnectorid: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrdeviceid: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IControlChangeNotify(pub ::windows::runtime::IUnknown);
impl IControlChangeNotify {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnNotify(&self, dwsenderprocessid: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsenderprocessid), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IControlChangeNotify {
    type Vtable = IControlChangeNotify_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2694124525, 50953, 19745, [189, 123, 95, 52, 196, 127, 57, 71]);
}
impl ::std::convert::From<IControlChangeNotify> for ::windows::runtime::IUnknown {
    fn from(value: IControlChangeNotify) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IControlChangeNotify> for ::windows::runtime::IUnknown {
    fn from(value: &IControlChangeNotify) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IControlChangeNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IControlChangeNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IControlChangeNotify_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsenderprocessid: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IControlInterface(pub ::windows::runtime::IUnknown);
impl IControlInterface {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetName(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetIID(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IControlInterface {
    type Vtable = IControlInterface_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1171487807, 20800, 17482, [174, 36, 64, 7, 137, 243, 203, 243]);
}
impl ::std::convert::From<IControlInterface> for ::windows::runtime::IUnknown {
    fn from(value: IControlInterface) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IControlInterface> for ::windows::runtime::IUnknown {
    fn from(value: &IControlInterface) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IControlInterface {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IControlInterface {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IControlInterface_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrname: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, piid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IDeviceSpecificProperty(pub ::windows::runtime::IUnknown);
impl IDeviceSpecificProperty {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetType(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u16>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetValue(&self, pvvalue: *mut ::std::ffi::c_void, pcbvalue: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pvvalue), ::std::mem::transmute(pcbvalue)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetValue(&self, pvvalue: *const ::std::ffi::c_void, cbvalue: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pvvalue), ::std::mem::transmute(cbvalue), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Get4BRange(&self, plmin: *mut i32, plmax: *mut i32, plstepping: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(plmin), ::std::mem::transmute(plmax), ::std::mem::transmute(plstepping)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IDeviceSpecificProperty {
    type Vtable = IDeviceSpecificProperty_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(992132287, 9606, 19184, [133, 131, 32, 93, 57, 27, 128, 124]);
}
impl ::std::convert::From<IDeviceSpecificProperty> for ::windows::runtime::IUnknown {
    fn from(value: IDeviceSpecificProperty) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IDeviceSpecificProperty> for ::windows::runtime::IUnknown {
    fn from(value: &IDeviceSpecificProperty) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IDeviceSpecificProperty {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IDeviceSpecificProperty {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDeviceSpecificProperty_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pvtype: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pvvalue: *mut ::std::ffi::c_void, pcbvalue: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pvvalue: *const ::std::ffi::c_void, cbvalue: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmin: *mut i32, plmax: *mut i32, plstepping: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IDeviceTopology(pub ::windows::runtime::IUnknown);
impl IDeviceTopology {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetConnectorCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetConnector(&self, nindex: u32) -> ::windows::runtime::Result<IConnector> {
        let mut result__: <IConnector as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nindex), &mut result__).from_abi::<IConnector>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSubunitCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSubunit(&self, nindex: u32) -> ::windows::runtime::Result<ISubunit> {
        let mut result__: <ISubunit as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nindex), &mut result__).from_abi::<ISubunit>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetPartById(&self, nid: u32) -> ::windows::runtime::Result<IPart> {
        let mut result__: <IPart as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(nid), &mut result__).from_abi::<IPart>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetDeviceId(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetSignalPath<'a, Param0: ::windows::runtime::IntoParam<'a, IPart>, Param1: ::windows::runtime::IntoParam<'a, IPart>, Param2: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, pipartfrom: Param0, pipartto: Param1, brejectmixedpaths: Param2) -> ::windows::runtime::Result<IPartsList> {
        let mut result__: <IPartsList as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), pipartfrom.into_param().abi(), pipartto.into_param().abi(), brejectmixedpaths.into_param().abi(), &mut result__).from_abi::<IPartsList>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IDeviceTopology {
    type Vtable = IDeviceTopology_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(705118334, 25751, 18968, [151, 135, 50, 247, 155, 208, 217, 143]);
}
impl ::std::convert::From<IDeviceTopology> for ::windows::runtime::IUnknown {
    fn from(value: IDeviceTopology) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IDeviceTopology> for ::windows::runtime::IUnknown {
    fn from(value: &IDeviceTopology) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IDeviceTopology {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IDeviceTopology {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDeviceTopology_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nindex: u32, ppconnector: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nindex: u32, ppsubunit: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nid: u32, pppart: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrdeviceid: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pipartfrom: ::windows::runtime::RawPtr, pipartto: ::windows::runtime::RawPtr, brejectmixedpaths: super::super::super::Foundation::BOOL, ppparts: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IHardwareAudioEngineBase(pub ::windows::runtime::IUnknown);
impl IHardwareAudioEngineBase {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetAvailableOffloadConnectorCount<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, _pwstrdeviceid: Param0, _uconnectorid: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), _pwstrdeviceid.into_param().abi(), ::std::mem::transmute(_uconnectorid), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetEngineFormat<'a, Param0: ::windows::runtime::IntoParam<'a, IMMDevice>, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, pdevice: Param0, _brequestdeviceformat: Param1, _ppwfxformat: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pdevice.into_param().abi(), _brequestdeviceformat.into_param().abi(), ::std::mem::transmute(_ppwfxformat)).ok()
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn SetEngineDeviceFormat<'a, Param0: ::windows::runtime::IntoParam<'a, IMMDevice>>(&self, pdevice: Param0, _pwfxformat: *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pdevice.into_param().abi(), ::std::mem::transmute(_pwfxformat)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetGfxState<'a, Param0: ::windows::runtime::IntoParam<'a, IMMDevice>, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, pdevice: Param0, _benable: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), pdevice.into_param().abi(), _benable.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetGfxState<'a, Param0: ::windows::runtime::IntoParam<'a, IMMDevice>>(&self, pdevice: Param0) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pdevice.into_param().abi(), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IHardwareAudioEngineBase {
    type Vtable = IHardwareAudioEngineBase_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3990676452, 62401, 17722, [180, 97, 34, 53, 99, 203, 216, 134]);
}
impl ::std::convert::From<IHardwareAudioEngineBase> for ::windows::runtime::IUnknown {
    fn from(value: IHardwareAudioEngineBase) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IHardwareAudioEngineBase> for ::windows::runtime::IUnknown {
    fn from(value: &IHardwareAudioEngineBase) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IHardwareAudioEngineBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IHardwareAudioEngineBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IHardwareAudioEngineBase_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, _pwstrdeviceid: super::super::super::Foundation::PWSTR, _uconnectorid: u32, _pavailableconnectorinstancecount: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdevice: ::windows::runtime::RawPtr, _brequestdeviceformat: super::super::super::Foundation::BOOL, _ppwfxformat: *mut *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia")))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdevice: ::windows::runtime::RawPtr, _pwfxformat: *mut super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdevice: ::windows::runtime::RawPtr, _benable: super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdevice: ::windows::runtime::RawPtr, _pbenable: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IKsFormatSupport(pub ::windows::runtime::IUnknown);
impl IKsFormatSupport {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsFormatSupported(&self, pksformat: *mut KSDATAFORMAT, cbformat: u32, pbsupported: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pksformat), ::std::mem::transmute(cbformat), ::std::mem::transmute(pbsupported)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDevicePreferredFormat(&self) -> ::windows::runtime::Result<*mut KSDATAFORMAT> {
        let mut result__: <*mut KSDATAFORMAT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut KSDATAFORMAT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IKsFormatSupport {
    type Vtable = IKsFormatSupport_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1018472093, 47983, 19755, [149, 183, 69, 45, 44, 21, 93, 181]);
}
impl ::std::convert::From<IKsFormatSupport> for ::windows::runtime::IUnknown {
    fn from(value: IKsFormatSupport) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IKsFormatSupport> for ::windows::runtime::IUnknown {
    fn from(value: &IKsFormatSupport) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IKsFormatSupport {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IKsFormatSupport {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IKsFormatSupport_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pksformat: *mut KSDATAFORMAT, cbformat: u32, pbsupported: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppksformat: *mut *mut KSDATAFORMAT) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IKsJackContainerId(pub ::windows::runtime::IUnknown);
impl IKsJackContainerId {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetJackContainerId(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IKsJackContainerId {
    type Vtable = IKsJackContainerId_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3382375523, 54825, 20164, [140, 0, 229, 77, 104, 21, 66, 72]);
}
impl ::std::convert::From<IKsJackContainerId> for ::windows::runtime::IUnknown {
    fn from(value: IKsJackContainerId) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IKsJackContainerId> for ::windows::runtime::IUnknown {
    fn from(value: &IKsJackContainerId) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IKsJackContainerId {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IKsJackContainerId {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IKsJackContainerId_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pjackcontainerid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IKsJackDescription(pub ::windows::runtime::IUnknown);
impl IKsJackDescription {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetJackCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetJackDescription(&self, njack: u32) -> ::windows::runtime::Result<KSJACK_DESCRIPTION> {
        let mut result__: <KSJACK_DESCRIPTION as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(njack), &mut result__).from_abi::<KSJACK_DESCRIPTION>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IKsJackDescription {
    type Vtable = IKsJackDescription_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1158281047, 11590, 17975, [142, 98, 206, 125, 185, 68, 245, 123]);
}
impl ::std::convert::From<IKsJackDescription> for ::windows::runtime::IUnknown {
    fn from(value: IKsJackDescription) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IKsJackDescription> for ::windows::runtime::IUnknown {
    fn from(value: &IKsJackDescription) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IKsJackDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IKsJackDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IKsJackDescription_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcjacks: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, njack: u32, pdescription: *mut KSJACK_DESCRIPTION) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IKsJackDescription2(pub ::windows::runtime::IUnknown);
impl IKsJackDescription2 {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetJackCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetJackDescription2(&self, njack: u32) -> ::windows::runtime::Result<KSJACK_DESCRIPTION2> {
        let mut result__: <KSJACK_DESCRIPTION2 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(njack), &mut result__).from_abi::<KSJACK_DESCRIPTION2>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IKsJackDescription2 {
    type Vtable = IKsJackDescription2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1200568987, 57545, 18471, [146, 40, 111, 85, 5, 255, 231, 106]);
}
impl ::std::convert::From<IKsJackDescription2> for ::windows::runtime::IUnknown {
    fn from(value: IKsJackDescription2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IKsJackDescription2> for ::windows::runtime::IUnknown {
    fn from(value: &IKsJackDescription2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IKsJackDescription2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IKsJackDescription2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IKsJackDescription2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcjacks: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, njack: u32, pdescription2: *mut KSJACK_DESCRIPTION2) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IKsJackSinkInformation(pub ::windows::runtime::IUnknown);
impl IKsJackSinkInformation {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetJackSinkInformation(&self) -> ::windows::runtime::Result<KSJACK_SINK_INFORMATION> {
        let mut result__: <KSJACK_SINK_INFORMATION as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<KSJACK_SINK_INFORMATION>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IKsJackSinkInformation {
    type Vtable = IKsJackSinkInformation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3653071597, 10511, 17793, [159, 243, 97, 2, 122, 143, 229, 50]);
}
impl ::std::convert::From<IKsJackSinkInformation> for ::windows::runtime::IUnknown {
    fn from(value: IKsJackSinkInformation) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IKsJackSinkInformation> for ::windows::runtime::IUnknown {
    fn from(value: &IKsJackSinkInformation) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IKsJackSinkInformation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IKsJackSinkInformation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IKsJackSinkInformation_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pjacksinkinformation: *mut KSJACK_SINK_INFORMATION) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMDevice(pub ::windows::runtime::IUnknown);
impl IMMDevice {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Activate(&self, iid: *const ::windows::runtime::GUID, dwclsctx: u32, pactivationparams: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT, ppinterface: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(iid), ::std::mem::transmute(dwclsctx), ::std::mem::transmute(pactivationparams), ::std::mem::transmute(ppinterface)).ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OpenPropertyStore(&self, stgmaccess: u32) -> ::windows::runtime::Result<super::super::super::System::PropertiesSystem::IPropertyStore> {
        let mut result__: <super::super::super::System::PropertiesSystem::IPropertyStore as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(stgmaccess), &mut result__).from_abi::<super::super::super::System::PropertiesSystem::IPropertyStore>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetId(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetState(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMMDevice {
    type Vtable = IMMDevice_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3597010495, 5511, 20035, [129, 241, 185, 72, 232, 7, 54, 63]);
}
impl ::std::convert::From<IMMDevice> for ::windows::runtime::IUnknown {
    fn from(value: IMMDevice) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMDevice> for ::windows::runtime::IUnknown {
    fn from(value: &IMMDevice) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMDevice_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: *const ::windows::runtime::GUID, dwclsctx: u32, pactivationparams: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>, ppinterface: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, stgmaccess: u32, ppproperties: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppstrid: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwstate: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMDeviceActivator(pub ::windows::runtime::IUnknown);
impl IMMDeviceActivator {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Activate<'a, Param1: ::windows::runtime::IntoParam<'a, IMMDevice>>(&self, iid: *const ::windows::runtime::GUID, pdevice: Param1, pactivationparams: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT, ppinterface: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(iid), pdevice.into_param().abi(), ::std::mem::transmute(pactivationparams), ::std::mem::transmute(ppinterface)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMMDeviceActivator {
    type Vtable = IMMDeviceActivator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(990711460, 53417, 19214, [147, 91, 9, 81, 103, 70, 250, 192]);
}
impl ::std::convert::From<IMMDeviceActivator> for ::windows::runtime::IUnknown {
    fn from(value: IMMDeviceActivator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMDeviceActivator> for ::windows::runtime::IUnknown {
    fn from(value: &IMMDeviceActivator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMDeviceActivator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMDeviceActivator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMDeviceActivator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: *const ::windows::runtime::GUID, pdevice: ::windows::runtime::RawPtr, pactivationparams: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>, ppinterface: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMDeviceCollection(pub ::windows::runtime::IUnknown);
impl IMMDeviceCollection {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Item(&self, ndevice: u32) -> ::windows::runtime::Result<IMMDevice> {
        let mut result__: <IMMDevice as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ndevice), &mut result__).from_abi::<IMMDevice>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMMDeviceCollection {
    type Vtable = IMMDeviceCollection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(198681022, 31258, 17627, [131, 151, 204, 83, 146, 56, 123, 94]);
}
impl ::std::convert::From<IMMDeviceCollection> for ::windows::runtime::IUnknown {
    fn from(value: IMMDeviceCollection) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMDeviceCollection> for ::windows::runtime::IUnknown {
    fn from(value: &IMMDeviceCollection) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMDeviceCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMDeviceCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMDeviceCollection_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcdevices: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ndevice: u32, ppdevice: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMDeviceEnumerator(pub ::windows::runtime::IUnknown);
impl IMMDeviceEnumerator {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EnumAudioEndpoints(&self, dataflow: EDataFlow, dwstatemask: u32) -> ::windows::runtime::Result<IMMDeviceCollection> {
        let mut result__: <IMMDeviceCollection as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dataflow), ::std::mem::transmute(dwstatemask), &mut result__).from_abi::<IMMDeviceCollection>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDefaultAudioEndpoint(&self, dataflow: EDataFlow, role: ERole) -> ::windows::runtime::Result<IMMDevice> {
        let mut result__: <IMMDevice as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(dataflow), ::std::mem::transmute(role), &mut result__).from_abi::<IMMDevice>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetDevice<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwstrid: Param0) -> ::windows::runtime::Result<IMMDevice> {
        let mut result__: <IMMDevice as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pwstrid.into_param().abi(), &mut result__).from_abi::<IMMDevice>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterEndpointNotificationCallback<'a, Param0: ::windows::runtime::IntoParam<'a, IMMNotificationClient>>(&self, pclient: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), pclient.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterEndpointNotificationCallback<'a, Param0: ::windows::runtime::IntoParam<'a, IMMNotificationClient>>(&self, pclient: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pclient.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMMDeviceEnumerator {
    type Vtable = IMMDeviceEnumerator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2841011410, 38420, 20277, [167, 70, 222, 141, 182, 54, 23, 230]);
}
impl ::std::convert::From<IMMDeviceEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: IMMDeviceEnumerator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMDeviceEnumerator> for ::windows::runtime::IUnknown {
    fn from(value: &IMMDeviceEnumerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMDeviceEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMDeviceEnumerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMDeviceEnumerator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dataflow: EDataFlow, dwstatemask: u32, ppdevices: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dataflow: EDataFlow, role: ERole, ppendpoint: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstrid: super::super::super::Foundation::PWSTR, ppdevice: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pclient: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pclient: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMEndpoint(pub ::windows::runtime::IUnknown);
impl IMMEndpoint {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetDataFlow(&self) -> ::windows::runtime::Result<EDataFlow> {
        let mut result__: <EDataFlow as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<EDataFlow>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMMEndpoint {
    type Vtable = IMMEndpoint_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(467703688, 26772, 16521, [133, 134, 154, 42, 108, 38, 90, 197]);
}
impl ::std::convert::From<IMMEndpoint> for ::windows::runtime::IUnknown {
    fn from(value: IMMEndpoint) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMEndpoint> for ::windows::runtime::IUnknown {
    fn from(value: &IMMEndpoint) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMEndpoint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMEndpoint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMEndpoint_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdataflow: *mut EDataFlow) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMMNotificationClient(pub ::windows::runtime::IUnknown);
impl IMMNotificationClient {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnDeviceStateChanged<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwstrdeviceid: Param0, dwnewstate: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), pwstrdeviceid.into_param().abi(), ::std::mem::transmute(dwnewstate)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnDeviceAdded<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwstrdeviceid: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pwstrdeviceid.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnDeviceRemoved<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, pwstrdeviceid: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pwstrdeviceid.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn OnDefaultDeviceChanged<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>>(&self, flow: EDataFlow, role: ERole, pwstrdefaultdeviceid: Param2) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(flow), ::std::mem::transmute(role), pwstrdefaultdeviceid.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_PropertiesSystem`*"]
    pub unsafe fn OnPropertyValueChanged<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::super::super::System::PropertiesSystem::PROPERTYKEY>>(&self, pwstrdeviceid: Param0, key: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pwstrdeviceid.into_param().abi(), key.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMMNotificationClient {
    type Vtable = IMMNotificationClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2039606985, 32393, 19845, [131, 144, 108, 112, 60, 236, 96, 192]);
}
impl ::std::convert::From<IMMNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: IMMNotificationClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMMNotificationClient> for ::windows::runtime::IUnknown {
    fn from(value: &IMMNotificationClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMMNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMMNotificationClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMMNotificationClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstrdeviceid: super::super::super::Foundation::PWSTR, dwnewstate: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstrdeviceid: super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstrdeviceid: super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flow: EDataFlow, role: ERole, pwstrdefaultdeviceid: super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstrdeviceid: super::super::super::Foundation::PWSTR, key: super::super::super::System::PropertiesSystem::PROPERTYKEY) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_PropertiesSystem")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMessageFilter(pub ::windows::runtime::IUnknown);
impl IMessageFilter {
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_System_Com`*"]
    pub unsafe fn HandleInComingCall<'a, Param1: ::windows::runtime::IntoParam<'a, HTASK>>(&self, dwcalltype: u32, htaskcaller: Param1, dwtickcount: u32, lpinterfaceinfo: *const super::super::super::System::Com::INTERFACEINFO) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcalltype), htaskcaller.into_param().abi(), ::std::mem::transmute(dwtickcount), ::std::mem::transmute(lpinterfaceinfo)))
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RetryRejectedCall<'a, Param0: ::windows::runtime::IntoParam<'a, HTASK>>(&self, htaskcallee: Param0, dwtickcount: u32, dwrejecttype: u32) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), htaskcallee.into_param().abi(), ::std::mem::transmute(dwtickcount), ::std::mem::transmute(dwrejecttype)))
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn MessagePending<'a, Param0: ::windows::runtime::IntoParam<'a, HTASK>>(&self, htaskcallee: Param0, dwtickcount: u32, dwpendingtype: u32) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), htaskcallee.into_param().abi(), ::std::mem::transmute(dwtickcount), ::std::mem::transmute(dwpendingtype)))
    }
}
unsafe impl ::windows::runtime::Interface for IMessageFilter {
    type Vtable = IMessageFilter_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(22, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
}
impl ::std::convert::From<IMessageFilter> for ::windows::runtime::IUnknown {
    fn from(value: IMessageFilter) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMessageFilter> for ::windows::runtime::IUnknown {
    fn from(value: &IMessageFilter) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMessageFilter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMessageFilter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMessageFilter_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcalltype: u32, htaskcaller: HTASK, dwtickcount: u32, lpinterfaceinfo: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::INTERFACEINFO>) -> u32,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, htaskcallee: HTASK, dwtickcount: u32, dwrejecttype: u32) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, htaskcallee: HTASK, dwtickcount: u32, dwpendingtype: u32) -> u32,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct INTERLEAVED_AUDIO_FORMAT_INFORMATION {
    pub Size: u32,
    pub PrimaryChannelCount: u32,
    pub PrimaryChannelStartPosition: u32,
    pub PrimaryChannelMask: u32,
    pub InterleavedChannelCount: u32,
    pub InterleavedChannelStartPosition: u32,
    pub InterleavedChannelMask: u32,
}
impl INTERLEAVED_AUDIO_FORMAT_INFORMATION {}
impl ::std::default::Default for INTERLEAVED_AUDIO_FORMAT_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for INTERLEAVED_AUDIO_FORMAT_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("INTERLEAVED_AUDIO_FORMAT_INFORMATION")
            .field("Size", &self.Size)
            .field("PrimaryChannelCount", &self.PrimaryChannelCount)
            .field("PrimaryChannelStartPosition", &self.PrimaryChannelStartPosition)
            .field("PrimaryChannelMask", &self.PrimaryChannelMask)
            .field("InterleavedChannelCount", &self.InterleavedChannelCount)
            .field("InterleavedChannelStartPosition", &self.InterleavedChannelStartPosition)
            .field("InterleavedChannelMask", &self.InterleavedChannelMask)
            .finish()
    }
}
impl ::std::cmp::PartialEq for INTERLEAVED_AUDIO_FORMAT_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.PrimaryChannelCount == other.PrimaryChannelCount && self.PrimaryChannelStartPosition == other.PrimaryChannelStartPosition && self.PrimaryChannelMask == other.PrimaryChannelMask && self.InterleavedChannelCount == other.InterleavedChannelCount && self.InterleavedChannelStartPosition == other.InterleavedChannelStartPosition && self.InterleavedChannelMask == other.InterleavedChannelMask
    }
}
impl ::std::cmp::Eq for INTERLEAVED_AUDIO_FORMAT_INFORMATION {}
unsafe impl ::windows::runtime::Abi for INTERLEAVED_AUDIO_FORMAT_INFORMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_DISABLE_EVENT: u32 = 3080203u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_ENABLE_EVENT: u32 = 3080199u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_HANDSHAKE: u32 = 3080223u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_METHOD: u32 = 3080207u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_PROPERTY: u32 = 3080195u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_READ_STREAM: u32 = 3096599u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_RESET_STATE: u32 = 3080219u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const IOCTL_KS_WRITE_STREAM: u32 = 3112979u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IPart(pub ::windows::runtime::IUnknown);
impl IPart {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetName(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLocalId(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetGlobalId(&self) -> ::windows::runtime::Result<super::super::super::Foundation::PWSTR> {
        let mut result__: <super::super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetPartType(&self) -> ::windows::runtime::Result<PartType> {
        let mut result__: <PartType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<PartType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSubType(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetControlInterfaceCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetControlInterface(&self, nindex: u32) -> ::windows::runtime::Result<IControlInterface> {
        let mut result__: <IControlInterface as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(nindex), &mut result__).from_abi::<IControlInterface>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EnumPartsIncoming(&self) -> ::windows::runtime::Result<IPartsList> {
        let mut result__: <IPartsList as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IPartsList>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EnumPartsOutgoing(&self) -> ::windows::runtime::Result<IPartsList> {
        let mut result__: <IPartsList as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IPartsList>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetTopologyObject(&self) -> ::windows::runtime::Result<IDeviceTopology> {
        let mut result__: <IDeviceTopology as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IDeviceTopology>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Activate(&self, dwclscontext: u32, refiid: *const ::windows::runtime::GUID, ppvobject: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwclscontext), ::std::mem::transmute(refiid), ::std::mem::transmute(ppvobject)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn RegisterControlChangeCallback<'a, Param1: ::windows::runtime::IntoParam<'a, IControlChangeNotify>>(&self, riid: *const ::windows::runtime::GUID, pnotify: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn UnregisterControlChangeCallback<'a, Param0: ::windows::runtime::IntoParam<'a, IControlChangeNotify>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPart {
    type Vtable = IPart_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2922242276, 23498, 20269, [170, 70, 93, 19, 248, 253, 179, 169]);
}
impl ::std::convert::From<IPart> for ::windows::runtime::IUnknown {
    fn from(value: IPart) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IPart> for ::windows::runtime::IUnknown {
    fn from(value: &IPart) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPart {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IPart {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPart_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrname: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnid: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppwstrglobalid: *mut super::super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pparttype: *mut PartType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psubtype: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nindex: u32, ppinterfacedesc: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppparts: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppparts: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pptopology: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwclscontext: u32, refiid: *const ::windows::runtime::GUID, ppvobject: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IPartsList(pub ::windows::runtime::IUnknown);
impl IPartsList {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetPart(&self, nindex: u32) -> ::windows::runtime::Result<IPart> {
        let mut result__: <IPart as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nindex), &mut result__).from_abi::<IPart>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPartsList {
    type Vtable = IPartsList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1839891596, 24240, 17868, [174, 165, 153, 138, 44, 218, 31, 251]);
}
impl ::std::convert::From<IPartsList> for ::windows::runtime::IUnknown {
    fn from(value: IPartsList) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IPartsList> for ::windows::runtime::IUnknown {
    fn from(value: &IPartsList) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPartsList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IPartsList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPartsList_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcount: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nindex: u32, pppart: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IPerChannelDbLevel(pub ::windows::runtime::IUnknown);
impl IPerChannelDbLevel {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetChannelCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevelRange(&self, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(pfminleveldb), ::std::mem::transmute(pfmaxleveldb), ::std::mem::transmute(pfstepping)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetLevel(&self, nchannel: u32) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), &mut result__).from_abi::<f32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevel(&self, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(nchannel), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelUniform(&self, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fleveldb), ::std::mem::transmute(pguideventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetLevelAllChannels(&self, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(alevelsdb), ::std::mem::transmute(cchannels), ::std::mem::transmute(pguideventcontext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPerChannelDbLevel {
    type Vtable = IPerChannelDbLevel_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3271090177, 61957, 19401, [153, 188, 193, 59, 30, 4, 140, 203]);
}
impl ::std::convert::From<IPerChannelDbLevel> for ::windows::runtime::IUnknown {
    fn from(value: IPerChannelDbLevel) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IPerChannelDbLevel> for ::windows::runtime::IUnknown {
    fn from(value: &IPerChannelDbLevel) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPerChannelDbLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IPerChannelDbLevel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPerChannelDbLevel_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcchannels: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfminleveldb: *mut f32, pfmaxleveldb: *mut f32, pfstepping: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, pfleveldb: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nchannel: u32, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fleveldb: f32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, alevelsdb: *const f32, cchannels: u32, pguideventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISimpleAudioVolume(pub ::windows::runtime::IUnknown);
impl ISimpleAudioVolume {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetMasterVolume(&self, flevel: f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(flevel), ::std::mem::transmute(eventcontext)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMasterVolume(&self) -> ::windows::runtime::Result<f32> {
        let mut result__: <f32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn SetMute<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, bmute: Param0, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), bmute.into_param().abi(), ::std::mem::transmute(eventcontext)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn GetMute(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISimpleAudioVolume {
    type Vtable = ISimpleAudioVolume_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2278446232, 26838, 17637, [146, 21, 109, 164, 126, 248, 131, 216]);
}
impl ::std::convert::From<ISimpleAudioVolume> for ::windows::runtime::IUnknown {
    fn from(value: ISimpleAudioVolume) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISimpleAudioVolume> for ::windows::runtime::IUnknown {
    fn from(value: &ISimpleAudioVolume) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISimpleAudioVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISimpleAudioVolume {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISimpleAudioVolume_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flevel: f32, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflevel: *mut f32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bmute: super::super::super::Foundation::BOOL, eventcontext: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbmute: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioClient(pub ::windows::runtime::IUnknown);
impl ISpatialAudioClient {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetStaticObjectPosition(&self, r#type: AudioObjectType, x: *mut f32, y: *mut f32, z: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(x), ::std::mem::transmute(y), ::std::mem::transmute(z)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetNativeStaticObjectTypeMask(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMaxDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSupportedAudioObjectFormatEnumerator(&self) -> ::windows::runtime::Result<IAudioFormatEnumerator> {
        let mut result__: <IAudioFormatEnumerator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IAudioFormatEnumerator>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMaxFrameCount(&self, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(objectformat), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn IsAudioObjectFormatSupported(&self, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(objectformat)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn IsSpatialAudioStreamAvailable(&self, streamuuid: *const ::windows::runtime::GUID, auxiliaryinfo: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(streamuuid), ::std::mem::transmute(auxiliaryinfo)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn ActivateSpatialAudioStream<T: ::windows::runtime::Interface>(&self, activationparams: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(activationparams), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioClient {
    type Vtable = ISpatialAudioClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3153649766, 43690, 18878, [154, 77, 253, 42, 133, 142, 162, 127]);
}
impl ::std::convert::From<ISpatialAudioClient> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioClient> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, x: *mut f32, y: *mut f32, z: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enumerator: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, objectformat: *const super::super::Multimedia::WAVEFORMATEX, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, streamuuid: *const ::windows::runtime::GUID, auxiliaryinfo: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, activationparams: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>, riid: *const ::windows::runtime::GUID, stream: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioClient2(pub ::windows::runtime::IUnknown);
impl ISpatialAudioClient2 {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetStaticObjectPosition(&self, r#type: AudioObjectType, x: *mut f32, y: *mut f32, z: *mut f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(x), ::std::mem::transmute(y), ::std::mem::transmute(z)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetNativeStaticObjectTypeMask(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMaxDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSupportedAudioObjectFormatEnumerator(&self) -> ::windows::runtime::Result<IAudioFormatEnumerator> {
        let mut result__: <IAudioFormatEnumerator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IAudioFormatEnumerator>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMaxFrameCount(&self, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(objectformat), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Media_Multimedia")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
    pub unsafe fn IsAudioObjectFormatSupported(&self, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(objectformat)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn IsSpatialAudioStreamAvailable(&self, streamuuid: *const ::windows::runtime::GUID, auxiliaryinfo: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(streamuuid), ::std::mem::transmute(auxiliaryinfo)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Com_StructuredStorage`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn ActivateSpatialAudioStream<T: ::windows::runtime::Interface>(&self, activationparams: *const super::super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(activationparams), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsOffloadCapable(&self, category: AUDIO_STREAM_CATEGORY) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(category), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`, `Win32_Media_Multimedia`*"]
    pub unsafe fn GetMaxFrameCountForCategory<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::super::Foundation::BOOL>>(&self, category: AUDIO_STREAM_CATEGORY, offloadenabled: Param1, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(category), offloadenabled.into_param().abi(), ::std::mem::transmute(objectformat), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioClient2 {
    type Vtable = ISpatialAudioClient2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3400262738, 42602, 19438, [169, 62, 227, 32, 70, 63, 106, 83]);
}
impl ::std::convert::From<ISpatialAudioClient2> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioClient2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioClient2> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioClient2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioClient2> for ISpatialAudioClient {
    fn from(value: ISpatialAudioClient2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioClient2> for ISpatialAudioClient {
    fn from(value: &ISpatialAudioClient2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioClient> for ISpatialAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioClient> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioClient> for &ISpatialAudioClient2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioClient> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioClient2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, x: *mut f32, y: *mut f32, z: *mut f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enumerator: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, objectformat: *const super::super::Multimedia::WAVEFORMATEX, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(feature = "Win32_Media_Multimedia")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, objectformat: *const super::super::Multimedia::WAVEFORMATEX) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Multimedia"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, streamuuid: *const ::windows::runtime::GUID, auxiliaryinfo: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, activationparams: *const ::std::mem::ManuallyDrop<super::super::super::System::Com::StructuredStorage::PROPVARIANT>, riid: *const ::windows::runtime::GUID, stream: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: AUDIO_STREAM_CATEGORY, isoffloadcapable: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: AUDIO_STREAM_CATEGORY, offloadenabled: super::super::super::Foundation::BOOL, objectformat: *const super::super::Multimedia::WAVEFORMATEX, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_Multimedia")))] usize,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataClient(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataClient {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioMetadataItems(&self, maxitemcount: u16, framecount: u16, metadataitemsbuffer: *mut ::std::option::Option<ISpatialAudioMetadataItemsBuffer>, metadataitems: *mut ::std::option::Option<ISpatialAudioMetadataItems>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(maxitemcount), ::std::mem::transmute(framecount), ::std::mem::transmute(metadataitemsbuffer), ::std::mem::transmute(metadataitems)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSpatialAudioMetadataItemsBufferLength(&self, maxitemcount: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(maxitemcount), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioMetadataWriter(&self, overflowmode: SpatialAudioMetadataWriterOverflowMode) -> ::windows::runtime::Result<ISpatialAudioMetadataWriter> {
        let mut result__: <ISpatialAudioMetadataWriter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(overflowmode), &mut result__).from_abi::<ISpatialAudioMetadataWriter>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioMetadataCopier(&self) -> ::windows::runtime::Result<ISpatialAudioMetadataCopier> {
        let mut result__: <ISpatialAudioMetadataCopier as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ISpatialAudioMetadataCopier>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioMetadataReader(&self) -> ::windows::runtime::Result<ISpatialAudioMetadataReader> {
        let mut result__: <ISpatialAudioMetadataReader as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ISpatialAudioMetadataReader>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataClient {
    type Vtable = ISpatialAudioMetadataClient_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2004699707, 63231, 18982, [133, 220, 104, 215, 205, 237, 161, 212]);
}
impl ::std::convert::From<ISpatialAudioMetadataClient> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataClient) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataClient> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataClient) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataClient {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataClient_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maxitemcount: u16, framecount: u16, metadataitemsbuffer: *mut ::windows::runtime::RawPtr, metadataitems: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maxitemcount: u16, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, overflowmode: SpatialAudioMetadataWriterOverflowMode, metadatawriter: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadatacopier: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadatareader: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataCopier(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataCopier {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Open<'a, Param0: ::windows::runtime::IntoParam<'a, ISpatialAudioMetadataItems>>(&self, metadataitems: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), metadataitems.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn CopyMetadataForFrames<'a, Param2: ::windows::runtime::IntoParam<'a, ISpatialAudioMetadataItems>>(&self, copyframecount: u16, copymode: SpatialAudioMetadataCopyMode, dstmetadataitems: Param2) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(copyframecount), ::std::mem::transmute(copymode), dstmetadataitems.into_param().abi(), &mut result__).from_abi::<u16>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataCopier {
    type Vtable = ISpatialAudioMetadataCopier_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3525620275, 57937, 20432, [156, 162, 213, 236, 249, 166, 132, 4]);
}
impl ::std::convert::From<ISpatialAudioMetadataCopier> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataCopier) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataCopier> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataCopier) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataCopier {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataCopier {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataCopier_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadataitems: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, copyframecount: u16, copymode: SpatialAudioMetadataCopyMode, dstmetadataitems: ::windows::runtime::RawPtr, itemscopied: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataItems(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataItems {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetFrameCount(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u16>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetItemCount(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u16>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMaxItemCount(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u16>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetMaxValueBufferLength(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetInfo(&self) -> ::windows::runtime::Result<SpatialAudioMetadataItemsInfo> {
        let mut result__: <SpatialAudioMetadataItemsInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<SpatialAudioMetadataItemsInfo>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataItems {
    type Vtable = ISpatialAudioMetadataItems_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3168257935, 12440, 20258, [181, 71, 162, 242, 90, 56, 18, 105]);
}
impl ::std::convert::From<ISpatialAudioMetadataItems> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataItems) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataItems> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataItems) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataItems_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itemcount: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maxitemcount: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maxvaluebufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, info: *mut SpatialAudioMetadataItemsInfo) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataItemsBuffer(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataItemsBuffer {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn AttachToBuffer(&self, buffer: *mut u8, bufferlength: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn AttachToPopulatedBuffer(&self, buffer: *mut u8, bufferlength: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn DetachBuffer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataItemsBuffer {
    type Vtable = ISpatialAudioMetadataItemsBuffer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1113852438, 57789, 17113, [159, 246, 3, 26, 183, 26, 45, 186]);
}
impl ::std::convert::From<ISpatialAudioMetadataItemsBuffer> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataItemsBuffer) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataItemsBuffer> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataItemsBuffer) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataItemsBuffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataItemsBuffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataItemsBuffer_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut u8, bufferlength: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut u8, bufferlength: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataReader(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataReader {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Open<'a, Param0: ::windows::runtime::IntoParam<'a, ISpatialAudioMetadataItems>>(&self, metadataitems: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), metadataitems.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ReadNextItem(&self, commandcount: *mut u8, frameoffset: *mut u16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(commandcount), ::std::mem::transmute(frameoffset)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ReadNextItemCommand(&self, commandid: *mut u8, valuebuffer: *mut ::std::ffi::c_void, maxvaluebufferlength: u32, valuebufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(commandid), ::std::mem::transmute(valuebuffer), ::std::mem::transmute(maxvaluebufferlength), ::std::mem::transmute(valuebufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataReader {
    type Vtable = ISpatialAudioMetadataReader_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3079571106, 12761, 19506, [148, 210, 125, 244, 15, 199, 235, 236]);
}
impl ::std::convert::From<ISpatialAudioMetadataReader> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataReader) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataReader> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataReader) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataReader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataReader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataReader_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadataitems: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, commandcount: *mut u8, frameoffset: *mut u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, commandid: *mut u8, valuebuffer: *mut ::std::ffi::c_void, maxvaluebufferlength: u32, valuebufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioMetadataWriter(pub ::windows::runtime::IUnknown);
impl ISpatialAudioMetadataWriter {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Open<'a, Param0: ::windows::runtime::IntoParam<'a, ISpatialAudioMetadataItems>>(&self, metadataitems: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), metadataitems.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn WriteNextItem(&self, frameoffset: u16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(frameoffset)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn WriteNextItemCommand(&self, commandid: u8, valuebuffer: *const ::std::ffi::c_void, valuebufferlength: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(commandid), ::std::mem::transmute(valuebuffer), ::std::mem::transmute(valuebufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioMetadataWriter {
    type Vtable = ISpatialAudioMetadataWriter_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(454543873, 10581, 17485, [164, 48, 83, 125, 197, 137, 168, 68]);
}
impl ::std::convert::From<ISpatialAudioMetadataWriter> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioMetadataWriter) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioMetadataWriter> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioMetadataWriter) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioMetadataWriter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioMetadataWriter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioMetadataWriter_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadataitems: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, frameoffset: u16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, commandid: u8, valuebuffer: *const ::std::ffi::c_void, valuebufferlength: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObject(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObject {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEndOfStream(&self, framecount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(framecount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsActive(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioObjectType(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetPosition(&self, x: f32, y: f32, z: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(x), ::std::mem::transmute(y), ::std::mem::transmute(z)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetVolume(&self, volume: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(volume)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObject {
    type Vtable = ISpatialAudioObject_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3722611047, 21019, 18149, [143, 0, 189, 111, 43, 200, 171, 29]);
}
impl ::std::convert::From<ISpatialAudioObject> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObject) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObject> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObject) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObject> for ISpatialAudioObjectBase {
    fn from(value: ISpatialAudioObject) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObject> for ISpatialAudioObjectBase {
    fn from(value: &ISpatialAudioObject) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for ISpatialAudioObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for &ISpatialAudioObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObject_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isactive: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audioobjecttype: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, x: f32, y: f32, z: f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, volume: f32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectBase(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectBase {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEndOfStream(&self, framecount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(framecount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsActive(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioObjectType(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectBase {
    type Vtable = ISpatialAudioObjectBase_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3437279474, 36173, 20219, [168, 207, 61, 110, 207, 28, 48, 224]);
}
impl ::std::convert::From<ISpatialAudioObjectBase> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectBase) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectBase> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectBase) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectBase_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isactive: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audioobjecttype: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectForHrtf(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectForHrtf {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEndOfStream(&self, framecount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(framecount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsActive(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioObjectType(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetPosition(&self, x: f32, y: f32, z: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(x), ::std::mem::transmute(y), ::std::mem::transmute(z)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetGain(&self, gain: f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(gain)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetOrientation(&self, orientation: *const *const f32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(orientation)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEnvironment(&self, environment: SpatialAudioHrtfEnvironmentType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(environment)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetDistanceDecay(&self, distancedecay: *const SpatialAudioHrtfDistanceDecay) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(distancedecay)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetDirectivity(&self, directivity: *const SpatialAudioHrtfDirectivityUnion) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(directivity)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectForHrtf {
    type Vtable = ISpatialAudioObjectForHrtf_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3611519710, 6520, 19988, [171, 160, 85, 91, 216, 235, 131, 180]);
}
impl ::std::convert::From<ISpatialAudioObjectForHrtf> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectForHrtf) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForHrtf> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectForHrtf) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectForHrtf> for ISpatialAudioObjectBase {
    fn from(value: ISpatialAudioObjectForHrtf) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForHrtf> for ISpatialAudioObjectBase {
    fn from(value: &ISpatialAudioObjectForHrtf) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for ISpatialAudioObjectForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for &ISpatialAudioObjectForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectForHrtf_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isactive: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audioobjecttype: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, x: f32, y: f32, z: f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, gain: f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, orientation: *const *const f32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, environment: SpatialAudioHrtfEnvironmentType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, distancedecay: *const SpatialAudioHrtfDistanceDecay) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, directivity: *const SpatialAudioHrtfDirectivityUnion) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectForMetadataCommands(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectForMetadataCommands {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEndOfStream(&self, framecount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(framecount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsActive(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioObjectType(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn WriteNextMetadataCommand(&self, commandid: u8, valuebuffer: *const ::std::ffi::c_void, valuebufferlength: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(commandid), ::std::mem::transmute(valuebuffer), ::std::mem::transmute(valuebufferlength)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectForMetadataCommands {
    type Vtable = ISpatialAudioObjectForMetadataCommands_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(234015051, 62969, 18221, [175, 107, 196, 110, 10, 201, 205, 5]);
}
impl ::std::convert::From<ISpatialAudioObjectForMetadataCommands> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectForMetadataCommands) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForMetadataCommands> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectForMetadataCommands) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectForMetadataCommands {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectForMetadataCommands {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectForMetadataCommands> for ISpatialAudioObjectBase {
    fn from(value: ISpatialAudioObjectForMetadataCommands) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForMetadataCommands> for ISpatialAudioObjectBase {
    fn from(value: &ISpatialAudioObjectForMetadataCommands) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for ISpatialAudioObjectForMetadataCommands {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for &ISpatialAudioObjectForMetadataCommands {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectForMetadataCommands_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isactive: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audioobjecttype: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, commandid: u8, valuebuffer: *const ::std::ffi::c_void, valuebufferlength: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectForMetadataItems(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectForMetadataItems {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetBuffer(&self, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(buffer), ::std::mem::transmute(bufferlength)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn SetEndOfStream(&self, framecount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(framecount)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
    pub unsafe fn IsActive(&self) -> ::windows::runtime::Result<super::super::super::Foundation::BOOL> {
        let mut result__: <super::super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAudioObjectType(&self) -> ::windows::runtime::Result<AudioObjectType> {
        let mut result__: <AudioObjectType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AudioObjectType>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetSpatialAudioMetadataItems(&self) -> ::windows::runtime::Result<ISpatialAudioMetadataItems> {
        let mut result__: <ISpatialAudioMetadataItems as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ISpatialAudioMetadataItems>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectForMetadataItems {
    type Vtable = ISpatialAudioObjectForMetadataItems_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3723119103, 15296, 17271, [138, 173, 159, 188, 253, 128, 133, 102]);
}
impl ::std::convert::From<ISpatialAudioObjectForMetadataItems> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectForMetadataItems) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForMetadataItems> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectForMetadataItems) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectForMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectForMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectForMetadataItems> for ISpatialAudioObjectBase {
    fn from(value: ISpatialAudioObjectForMetadataItems) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectForMetadataItems> for ISpatialAudioObjectBase {
    fn from(value: &ISpatialAudioObjectForMetadataItems) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for ISpatialAudioObjectForMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectBase> for &ISpatialAudioObjectForMetadataItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectForMetadataItems_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, buffer: *mut *mut u8, bufferlength: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framecount: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isactive: *mut super::super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, audioobjecttype: *mut AudioObjectType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadataitems: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectRenderStream(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectRenderStream {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAvailableDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn BeginUpdatingAudioObjects(&self, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(availabledynamicobjectcount), ::std::mem::transmute(framecountperbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EndUpdatingAudioObjects(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioObject(&self, r#type: AudioObjectType) -> ::windows::runtime::Result<ISpatialAudioObject> {
        let mut result__: <ISpatialAudioObject as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &mut result__).from_abi::<ISpatialAudioObject>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectRenderStream {
    type Vtable = ISpatialAudioObjectRenderStream_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3132486771, 46115, 18299, [133, 245, 181, 163, 50, 160, 65, 83]);
}
impl ::std::convert::From<ISpatialAudioObjectRenderStream> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectRenderStream) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStream> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectRenderStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectRenderStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectRenderStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectRenderStream> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: ISpatialAudioObjectRenderStream) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStream> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: &ISpatialAudioObjectRenderStream) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for ISpatialAudioObjectRenderStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for &ISpatialAudioObjectRenderStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectRenderStream_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, service: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, audioobject: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectRenderStreamBase(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectRenderStreamBase {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAvailableDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn BeginUpdatingAudioObjects(&self, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(availabledynamicobjectcount), ::std::mem::transmute(framecountperbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EndUpdatingAudioObjects(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectRenderStreamBase {
    type Vtable = ISpatialAudioObjectRenderStreamBase_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4272616451, 49624, 17677, [170, 5, 224, 204, 238, 117, 2, 168]);
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamBase> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectRenderStreamBase) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamBase> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectRenderStreamBase) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectRenderStreamBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectRenderStreamBase {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectRenderStreamBase_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, service: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectRenderStreamForHrtf(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectRenderStreamForHrtf {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAvailableDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn BeginUpdatingAudioObjects(&self, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(availabledynamicobjectcount), ::std::mem::transmute(framecountperbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EndUpdatingAudioObjects(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioObjectForHrtf(&self, r#type: AudioObjectType) -> ::windows::runtime::Result<ISpatialAudioObjectForHrtf> {
        let mut result__: <ISpatialAudioObjectForHrtf as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &mut result__).from_abi::<ISpatialAudioObjectForHrtf>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectRenderStreamForHrtf {
    type Vtable = ISpatialAudioObjectRenderStreamForHrtf_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3767398137, 21347, 16494, [159, 220, 8, 14, 226, 71, 187, 224]);
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamForHrtf> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectRenderStreamForHrtf) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamForHrtf> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectRenderStreamForHrtf) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectRenderStreamForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectRenderStreamForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamForHrtf> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: ISpatialAudioObjectRenderStreamForHrtf) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamForHrtf> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: &ISpatialAudioObjectRenderStreamForHrtf) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for ISpatialAudioObjectRenderStreamForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for &ISpatialAudioObjectRenderStreamForHrtf {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectRenderStreamForHrtf_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, service: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, audioobject: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectRenderStreamForMetadata(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectRenderStreamForMetadata {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetAvailableDynamicObjectCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn GetService<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn BeginUpdatingAudioObjects(&self, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(availabledynamicobjectcount), ::std::mem::transmute(framecountperbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn EndUpdatingAudioObjects(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioObjectForMetadataCommands(&self, r#type: AudioObjectType) -> ::windows::runtime::Result<ISpatialAudioObjectForMetadataCommands> {
        let mut result__: <ISpatialAudioObjectForMetadataCommands as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &mut result__).from_abi::<ISpatialAudioObjectForMetadataCommands>(result__)
    }
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn ActivateSpatialAudioObjectForMetadataItems(&self, r#type: AudioObjectType) -> ::windows::runtime::Result<ISpatialAudioObjectForMetadataItems> {
        let mut result__: <ISpatialAudioObjectForMetadataItems as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &mut result__).from_abi::<ISpatialAudioObjectForMetadataItems>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectRenderStreamForMetadata {
    type Vtable = ISpatialAudioObjectRenderStreamForMetadata_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3150563591, 18645, 18990, [160, 199, 247, 240, 214, 124, 31, 177]);
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamForMetadata> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectRenderStreamForMetadata) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamForMetadata> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectRenderStreamForMetadata) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectRenderStreamForMetadata {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectRenderStreamForMetadata {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamForMetadata> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: ISpatialAudioObjectRenderStreamForMetadata) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamForMetadata> for ISpatialAudioObjectRenderStreamBase {
    fn from(value: &ISpatialAudioObjectRenderStreamForMetadata) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for ISpatialAudioObjectRenderStreamForMetadata {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase> for &ISpatialAudioObjectRenderStreamForMetadata {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpatialAudioObjectRenderStreamBase> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectRenderStreamForMetadata_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, service: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, availabledynamicobjectcount: *mut u32, framecountperbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, audioobject: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: AudioObjectType, audioobject: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpatialAudioObjectRenderStreamNotify(pub ::windows::runtime::IUnknown);
impl ISpatialAudioObjectRenderStreamNotify {
    #[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
    pub unsafe fn OnAvailableDynamicObjectCountChange<'a, Param0: ::windows::runtime::IntoParam<'a, ISpatialAudioObjectRenderStreamBase>>(&self, sender: Param0, hnscompliancedeadlinetime: i64, availabledynamicobjectcountchange: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), sender.into_param().abi(), ::std::mem::transmute(hnscompliancedeadlinetime), ::std::mem::transmute(availabledynamicobjectcountchange)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpatialAudioObjectRenderStreamNotify {
    type Vtable = ISpatialAudioObjectRenderStreamNotify_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3722413030, 26839, 19568, [136, 63, 161, 131, 106, 251, 74, 80]);
}
impl ::std::convert::From<ISpatialAudioObjectRenderStreamNotify> for ::windows::runtime::IUnknown {
    fn from(value: ISpatialAudioObjectRenderStreamNotify) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpatialAudioObjectRenderStreamNotify> for ::windows::runtime::IUnknown {
    fn from(value: &ISpatialAudioObjectRenderStreamNotify) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpatialAudioObjectRenderStreamNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpatialAudioObjectRenderStreamNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpatialAudioObjectRenderStreamNotify_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sender: ::windows::runtime::RawPtr, hnscompliancedeadlinetime: i64, availabledynamicobjectcountchange: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISubunit(pub ::windows::runtime::IUnknown);
impl ISubunit {}
unsafe impl ::windows::runtime::Interface for ISubunit {
    type Vtable = ISubunit_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2182388357, 56230, 17543, [134, 187, 234, 143, 127, 239, 204, 113]);
}
impl ::std::convert::From<ISubunit> for ::windows::runtime::IUnknown {
    fn from(value: ISubunit) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISubunit> for ::windows::runtime::IUnknown {
    fn from(value: &ISubunit) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISubunit {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISubunit {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISubunit_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const JACKDESC2_DYNAMIC_FORMAT_CHANGE_CAPABILITY: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const JACKDESC2_PRESENCE_DETECT_CAPABILITY: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAC3_ALTERNATE_AUDIO {
    pub fStereo: super::super::super::Foundation::BOOL,
    pub DualMode: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAC3_ALTERNATE_AUDIO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAC3_ALTERNATE_AUDIO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_ALTERNATE_AUDIO").field("fStereo", &self.fStereo).field("DualMode", &self.DualMode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAC3_ALTERNATE_AUDIO {
    fn eq(&self, other: &Self) -> bool {
        self.fStereo == other.fStereo && self.DualMode == other.DualMode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAC3_ALTERNATE_AUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_ALTERNATE_AUDIO_1: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_ALTERNATE_AUDIO_2: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_ALTERNATE_AUDIO_BOTH: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAC3_BIT_STREAM_MODE {
    pub BitStreamMode: i32,
}
impl KSAC3_BIT_STREAM_MODE {}
impl ::std::default::Default for KSAC3_BIT_STREAM_MODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAC3_BIT_STREAM_MODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_BIT_STREAM_MODE").field("BitStreamMode", &self.BitStreamMode).finish()
    }
}
impl ::std::cmp::PartialEq for KSAC3_BIT_STREAM_MODE {
    fn eq(&self, other: &Self) -> bool {
        self.BitStreamMode == other.BitStreamMode
    }
}
impl ::std::cmp::Eq for KSAC3_BIT_STREAM_MODE {}
unsafe impl ::windows::runtime::Abi for KSAC3_BIT_STREAM_MODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAC3_DIALOGUE_LEVEL {
    pub DialogueLevel: u32,
}
impl KSAC3_DIALOGUE_LEVEL {}
impl ::std::default::Default for KSAC3_DIALOGUE_LEVEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAC3_DIALOGUE_LEVEL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_DIALOGUE_LEVEL").field("DialogueLevel", &self.DialogueLevel).finish()
    }
}
impl ::std::cmp::PartialEq for KSAC3_DIALOGUE_LEVEL {
    fn eq(&self, other: &Self) -> bool {
        self.DialogueLevel == other.DialogueLevel
    }
}
impl ::std::cmp::Eq for KSAC3_DIALOGUE_LEVEL {}
unsafe impl ::windows::runtime::Abi for KSAC3_DIALOGUE_LEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAC3_DOWNMIX {
    pub fDownMix: super::super::super::Foundation::BOOL,
    pub fDolbySurround: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAC3_DOWNMIX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAC3_DOWNMIX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_DOWNMIX").field("fDownMix", &self.fDownMix).field("fDolbySurround", &self.fDolbySurround).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAC3_DOWNMIX {
    fn eq(&self, other: &Self) -> bool {
        self.fDownMix == other.fDownMix && self.fDolbySurround == other.fDolbySurround
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAC3_DOWNMIX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAC3_ERROR_CONCEALMENT {
    pub fRepeatPreviousBlock: super::super::super::Foundation::BOOL,
    pub fErrorInCurrentBlock: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAC3_ERROR_CONCEALMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAC3_ERROR_CONCEALMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_ERROR_CONCEALMENT").field("fRepeatPreviousBlock", &self.fRepeatPreviousBlock).field("fErrorInCurrentBlock", &self.fErrorInCurrentBlock).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAC3_ERROR_CONCEALMENT {
    fn eq(&self, other: &Self) -> bool {
        self.fRepeatPreviousBlock == other.fRepeatPreviousBlock && self.fErrorInCurrentBlock == other.fErrorInCurrentBlock
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAC3_ERROR_CONCEALMENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAC3_ROOM_TYPE {
    pub fLargeRoom: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAC3_ROOM_TYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAC3_ROOM_TYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAC3_ROOM_TYPE").field("fLargeRoom", &self.fLargeRoom).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAC3_ROOM_TYPE {
    fn eq(&self, other: &Self) -> bool {
        self.fLargeRoom == other.fLargeRoom
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAC3_ROOM_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_COMMENTARY: u32 = 5u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_DIALOG_ONLY: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_EMERGENCY_FLASH: u32 = 6u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_HEARING_IMPAIRED: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_MAIN_AUDIO: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_NO_DIALOG: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_VISUALLY_IMPAIRED: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAC3_SERVICE_VOICE_OVER: u32 = 7u32;
pub const KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(472040813, 39033, 20315, [163, 137, 39, 153, 109, 220, 40, 16]);
pub const KSALGORITHMINSTANCE_SYSTEM_AGC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2500744633, 34684, 19559, [190, 8, 228, 123, 86, 17, 19, 10]);
pub const KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3069550752, 40545, 20364, [145, 227, 118, 207, 15, 60, 71, 31]);
pub const KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1521518638, 29300, 17686, [135, 125, 78, 238, 153, 186, 79, 208]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_2D_BUFFER_REQUIRED: u32 = 32768u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_ALLOCATOR_EXISTS: u32 = 2048u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_ATTENTION_STEPPING: u32 = 8192u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_CAN_ALLOCATE: u32 = 64u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_CYCLE: u32 = 1024u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_DEVICE_SPECIFIC: u32 = 32u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_ENABLE_CACHED_MDL: u32 = 16384u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_INDEPENDENT_RANGES: u32 = 4096u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_INSIST_ON_FRAMESIZE_RATIO: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_MULTIPLE_OUTPUT: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_NO_FRAME_INTEGRITY: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_FLAG_PARTIAL_READ_SUPPORT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSALLOCATOR_FRAMING {
    pub Anonymous1: KSALLOCATOR_FRAMING_0,
    pub PoolType: u32,
    pub Frames: u32,
    pub FrameSize: u32,
    pub Anonymous2: KSALLOCATOR_FRAMING_1,
    pub Reserved: u32,
}
impl KSALLOCATOR_FRAMING {}
impl ::std::default::Default for KSALLOCATOR_FRAMING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSALLOCATOR_FRAMING {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSALLOCATOR_FRAMING {}
unsafe impl ::windows::runtime::Abi for KSALLOCATOR_FRAMING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSALLOCATOR_FRAMING_0 {
    pub OptionsFlags: u32,
    pub RequirementsFlags: u32,
}
impl KSALLOCATOR_FRAMING_0 {}
impl ::std::default::Default for KSALLOCATOR_FRAMING_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSALLOCATOR_FRAMING_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSALLOCATOR_FRAMING_0 {}
unsafe impl ::windows::runtime::Abi for KSALLOCATOR_FRAMING_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSALLOCATOR_FRAMING_1 {
    pub FileAlignment: u32,
    pub FramePitch: i32,
}
impl KSALLOCATOR_FRAMING_1 {}
impl ::std::default::Default for KSALLOCATOR_FRAMING_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSALLOCATOR_FRAMING_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSALLOCATOR_FRAMING_1 {}
unsafe impl ::windows::runtime::Abi for KSALLOCATOR_FRAMING_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSALLOCATOR_FRAMING_EX {
    pub CountItems: u32,
    pub PinFlags: u32,
    pub OutputCompression: KS_COMPRESSION,
    pub PinWeight: u32,
    pub FramingItem: [KS_FRAMING_ITEM; 1],
}
impl KSALLOCATOR_FRAMING_EX {}
impl ::std::default::Default for KSALLOCATOR_FRAMING_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSALLOCATOR_FRAMING_EX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSALLOCATOR_FRAMING_EX {}
unsafe impl ::windows::runtime::Abi for KSALLOCATOR_FRAMING_EX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_OPTIONF_COMPATIBLE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_OPTIONF_SYSTEM_MEMORY: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_OPTIONF_VALID: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_FRAME_INTEGRITY: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_INPLACE_MODIFIER: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_MUST_ALLOCATE: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_PREFERENCES_ONLY: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_SYSTEM_MEMORY: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSALLOCATOR_REQUIREMENTF_SYSTEM_MEMORY_CUSTOM_ALLOCATION: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSATTRIBUTE {
    pub Size: u32,
    pub Flags: u32,
    pub Attribute: ::windows::runtime::GUID,
}
impl KSATTRIBUTE {}
impl ::std::default::Default for KSATTRIBUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSATTRIBUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSATTRIBUTE").field("Size", &self.Size).field("Flags", &self.Flags).field("Attribute", &self.Attribute).finish()
    }
}
impl ::std::cmp::PartialEq for KSATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Flags == other.Flags && self.Attribute == other.Attribute
    }
}
impl ::std::cmp::Eq for KSATTRIBUTE {}
unsafe impl ::windows::runtime::Abi for KSATTRIBUTE {
    type Abi = Self;
}
pub const KSATTRIBUTEID_AUDIOSIGNALPROCESSING_MODE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3791167157, 24390, 16795, [150, 123, 255, 103, 112, 185, 132, 1]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {
    pub AttributeHeader: KSATTRIBUTE,
    pub SignalProcessingMode: ::windows::runtime::GUID,
}
impl KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {}
impl ::std::default::Default for KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE").field("AttributeHeader", &self.AttributeHeader).field("SignalProcessingMode", &self.SignalProcessingMode).finish()
    }
}
impl ::std::cmp::PartialEq for KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {
    fn eq(&self, other: &Self) -> bool {
        self.AttributeHeader == other.AttributeHeader && self.SignalProcessingMode == other.SignalProcessingMode
    }
}
impl ::std::cmp::Eq for KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {}
unsafe impl ::windows::runtime::Abi for KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSATTRIBUTE_REQUIRED: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDDECOUTMODE_PCM_51: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDDECOUTMODE_SPDIFF: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDDECOUTMODE_STEREO_ANALOG: u32 = 1u32;
pub const KSAUDFNAME_3D_CENTER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2667999412, 39199, 4562, [172, 77, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_3D_DEPTH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1677678407, 39199, 4562, [172, 77, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_3D_STEREO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940002, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_ALTERNATE_MICROPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(734207339, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_AUX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940030, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_AUX_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940029, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_AUX_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940028, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_BASS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940000, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_CD_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940027, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_CD_IN_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940019, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_CD_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940010, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_CD_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940009, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_LINE_IN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940025, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_LINE_IN_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940020, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_LINE_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940012, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_LINE_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940011, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MASTER_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940004, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MASTER_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940003, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MICROPHONE_BOOST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(734207338, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MIC_IN_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940021, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIC_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940014, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIC_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940013, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIDI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940024, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIDI_IN_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940018, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIDI_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940008, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIDI_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940007, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_MIDRANGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2731271288, 44676, 18849, [139, 114, 74, 208, 155, 120, 237, 52]);
pub const KSAUDFNAME_MONO_MIX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(14676088, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MONO_MIX_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(734207337, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MONO_MIX_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(582019838, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MONO_OUT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4189330883, 38626, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MONO_OUT_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(449988588, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_MONO_OUT_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(449988587, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_PC_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940031, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_PC_SPEAKER_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940017, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_PC_SPEAKER_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940016, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_PEAKMETER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1474446144, 64603, 17938, [165, 98, 114, 177, 26, 41, 223, 174]);
pub const KSAUDFNAME_RECORDING_CONTROL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940026, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_RECORDING_SOURCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940015, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_STEREO_MIX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(14676087, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_STEREO_MIX_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(582019837, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_STEREO_MIX_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(449988589, 38627, 4562, [172, 76, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_TREBLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940001, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2438835908, 42036, 4562, [172, 82, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_VIDEO_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2605115145, 39210, 4562, [172, 77, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_VIDEO_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2605115144, 39210, 4562, [172, 77, 0, 192, 79, 142, 251, 104]);
pub const KSAUDFNAME_VOLUME_CONTROL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940023, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_WAVE_IN_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940022, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_WAVE_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940006, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_WAVE_OUT_MIX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940032, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
pub const KSAUDFNAME_WAVE_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(408940005, 39173, 4561, [149, 169, 0, 192, 79, 185, 37, 211]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOENGINE_BUFFER_SIZE_RANGE {
    pub MinBufferBytes: u32,
    pub MaxBufferBytes: u32,
}
impl KSAUDIOENGINE_BUFFER_SIZE_RANGE {}
impl ::std::default::Default for KSAUDIOENGINE_BUFFER_SIZE_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIOENGINE_BUFFER_SIZE_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIOENGINE_BUFFER_SIZE_RANGE").field("MinBufferBytes", &self.MinBufferBytes).field("MaxBufferBytes", &self.MaxBufferBytes).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIOENGINE_BUFFER_SIZE_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.MinBufferBytes == other.MinBufferBytes && self.MaxBufferBytes == other.MaxBufferBytes
    }
}
impl ::std::cmp::Eq for KSAUDIOENGINE_BUFFER_SIZE_RANGE {}
unsafe impl ::windows::runtime::Abi for KSAUDIOENGINE_BUFFER_SIZE_RANGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOENGINE_DESCRIPTOR {
    pub nHostPinId: u32,
    pub nOffloadPinId: u32,
    pub nLoopbackPinId: u32,
}
impl KSAUDIOENGINE_DESCRIPTOR {}
impl ::std::default::Default for KSAUDIOENGINE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIOENGINE_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIOENGINE_DESCRIPTOR").field("nHostPinId", &self.nHostPinId).field("nOffloadPinId", &self.nOffloadPinId).field("nLoopbackPinId", &self.nLoopbackPinId).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIOENGINE_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.nHostPinId == other.nHostPinId && self.nOffloadPinId == other.nOffloadPinId && self.nLoopbackPinId == other.nLoopbackPinId
    }
}
impl ::std::cmp::Eq for KSAUDIOENGINE_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for KSAUDIOENGINE_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOENGINE_VOLUMELEVEL {
    pub TargetVolume: i32,
    pub CurveType: AUDIO_CURVE_TYPE,
    pub CurveDuration: u64,
}
impl KSAUDIOENGINE_VOLUMELEVEL {}
impl ::std::default::Default for KSAUDIOENGINE_VOLUMELEVEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIOENGINE_VOLUMELEVEL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIOENGINE_VOLUMELEVEL").field("TargetVolume", &self.TargetVolume).field("CurveType", &self.CurveType).field("CurveDuration", &self.CurveDuration).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIOENGINE_VOLUMELEVEL {
    fn eq(&self, other: &Self) -> bool {
        self.TargetVolume == other.TargetVolume && self.CurveType == other.CurveType && self.CurveDuration == other.CurveDuration
    }
}
impl ::std::cmp::Eq for KSAUDIOENGINE_VOLUMELEVEL {}
unsafe impl ::windows::runtime::Abi for KSAUDIOENGINE_VOLUMELEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOMODULE_DESCRIPTOR {
    pub ClassId: ::windows::runtime::GUID,
    pub InstanceId: u32,
    pub VersionMajor: u32,
    pub VersionMinor: u32,
    pub Name: [u16; 128],
}
impl KSAUDIOMODULE_DESCRIPTOR {}
impl ::std::default::Default for KSAUDIOMODULE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIOMODULE_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIOMODULE_DESCRIPTOR").field("ClassId", &self.ClassId).field("InstanceId", &self.InstanceId).field("VersionMajor", &self.VersionMajor).field("VersionMinor", &self.VersionMinor).field("Name", &self.Name).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIOMODULE_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.ClassId == other.ClassId && self.InstanceId == other.InstanceId && self.VersionMajor == other.VersionMajor && self.VersionMinor == other.VersionMinor && self.Name == other.Name
    }
}
impl ::std::cmp::Eq for KSAUDIOMODULE_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for KSAUDIOMODULE_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOMODULE_NOTIFICATION {
    pub Anonymous: KSAUDIOMODULE_NOTIFICATION_0,
}
impl KSAUDIOMODULE_NOTIFICATION {}
impl ::std::default::Default for KSAUDIOMODULE_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSAUDIOMODULE_NOTIFICATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSAUDIOMODULE_NOTIFICATION {}
unsafe impl ::windows::runtime::Abi for KSAUDIOMODULE_NOTIFICATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSAUDIOMODULE_NOTIFICATION_0 {
    pub ProviderId: KSAUDIOMODULE_NOTIFICATION_0_0,
    pub Alignment: i64,
}
impl KSAUDIOMODULE_NOTIFICATION_0 {}
impl ::std::default::Default for KSAUDIOMODULE_NOTIFICATION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSAUDIOMODULE_NOTIFICATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSAUDIOMODULE_NOTIFICATION_0 {}
unsafe impl ::windows::runtime::Abi for KSAUDIOMODULE_NOTIFICATION_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOMODULE_NOTIFICATION_0_0 {
    pub DeviceId: ::windows::runtime::GUID,
    pub ClassId: ::windows::runtime::GUID,
    pub InstanceId: u32,
    pub Reserved: u32,
}
impl KSAUDIOMODULE_NOTIFICATION_0_0 {}
impl ::std::default::Default for KSAUDIOMODULE_NOTIFICATION_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIOMODULE_NOTIFICATION_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_ProviderId_e__Struct").field("DeviceId", &self.DeviceId).field("ClassId", &self.ClassId).field("InstanceId", &self.InstanceId).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIOMODULE_NOTIFICATION_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceId == other.DeviceId && self.ClassId == other.ClassId && self.InstanceId == other.InstanceId && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSAUDIOMODULE_NOTIFICATION_0_0 {}
unsafe impl ::windows::runtime::Abi for KSAUDIOMODULE_NOTIFICATION_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIOMODULE_PROPERTY {
    pub Property: KSIDENTIFIER,
    pub ClassId: ::windows::runtime::GUID,
    pub InstanceId: u32,
}
impl KSAUDIOMODULE_PROPERTY {}
impl ::std::default::Default for KSAUDIOMODULE_PROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSAUDIOMODULE_PROPERTY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSAUDIOMODULE_PROPERTY {}
unsafe impl ::windows::runtime::Abi for KSAUDIOMODULE_PROPERTY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_CHANNEL_CONFIG {
    pub ActiveSpeakerPositions: i32,
}
impl KSAUDIO_CHANNEL_CONFIG {}
impl ::std::default::Default for KSAUDIO_CHANNEL_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_CHANNEL_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_CHANNEL_CONFIG").field("ActiveSpeakerPositions", &self.ActiveSpeakerPositions).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_CHANNEL_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.ActiveSpeakerPositions == other.ActiveSpeakerPositions
    }
}
impl ::std::cmp::Eq for KSAUDIO_CHANNEL_CONFIG {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_CHANNEL_CONFIG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAUDIO_COPY_PROTECTION {
    pub fCopyrighted: super::super::super::Foundation::BOOL,
    pub fOriginal: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAUDIO_COPY_PROTECTION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAUDIO_COPY_PROTECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAUDIO_COPY_PROTECTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_COPY_PROTECTION").field("fCopyrighted", &self.fCopyrighted).field("fOriginal", &self.fOriginal).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAUDIO_COPY_PROTECTION {
    fn eq(&self, other: &Self) -> bool {
        self.fCopyrighted == other.fCopyrighted && self.fOriginal == other.fOriginal
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAUDIO_COPY_PROTECTION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAUDIO_COPY_PROTECTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_CPU_RESOURCES_HOST_CPU: u32 = 2147483647u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_CPU_RESOURCES_NOT_HOST_CPU: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_DYNAMIC_RANGE {
    pub QuietCompression: u32,
    pub LoudCompression: u32,
}
impl KSAUDIO_DYNAMIC_RANGE {}
impl ::std::default::Default for KSAUDIO_DYNAMIC_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_DYNAMIC_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_DYNAMIC_RANGE").field("QuietCompression", &self.QuietCompression).field("LoudCompression", &self.LoudCompression).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_DYNAMIC_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.QuietCompression == other.QuietCompression && self.LoudCompression == other.LoudCompression
    }
}
impl ::std::cmp::Eq for KSAUDIO_DYNAMIC_RANGE {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_DYNAMIC_RANGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_MICROPHONE_COORDINATES {
    pub usType: u16,
    pub wXCoord: i16,
    pub wYCoord: i16,
    pub wZCoord: i16,
    pub wVerticalAngle: i16,
    pub wHorizontalAngle: i16,
}
impl KSAUDIO_MICROPHONE_COORDINATES {}
impl ::std::default::Default for KSAUDIO_MICROPHONE_COORDINATES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_MICROPHONE_COORDINATES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_MICROPHONE_COORDINATES").field("usType", &self.usType).field("wXCoord", &self.wXCoord).field("wYCoord", &self.wYCoord).field("wZCoord", &self.wZCoord).field("wVerticalAngle", &self.wVerticalAngle).field("wHorizontalAngle", &self.wHorizontalAngle).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_MICROPHONE_COORDINATES {
    fn eq(&self, other: &Self) -> bool {
        self.usType == other.usType && self.wXCoord == other.wXCoord && self.wYCoord == other.wYCoord && self.wZCoord == other.wZCoord && self.wVerticalAngle == other.wVerticalAngle && self.wHorizontalAngle == other.wHorizontalAngle
    }
}
impl ::std::cmp::Eq for KSAUDIO_MICROPHONE_COORDINATES {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_MICROPHONE_COORDINATES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_MIC_ARRAY_GEOMETRY {
    pub usVersion: u16,
    pub usMicArrayType: u16,
    pub wVerticalAngleBegin: i16,
    pub wVerticalAngleEnd: i16,
    pub wHorizontalAngleBegin: i16,
    pub wHorizontalAngleEnd: i16,
    pub usFrequencyBandLo: u16,
    pub usFrequencyBandHi: u16,
    pub usNumberOfMicrophones: u16,
    pub KsMicCoord: [KSAUDIO_MICROPHONE_COORDINATES; 1],
}
impl KSAUDIO_MIC_ARRAY_GEOMETRY {}
impl ::std::default::Default for KSAUDIO_MIC_ARRAY_GEOMETRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_MIC_ARRAY_GEOMETRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_MIC_ARRAY_GEOMETRY")
            .field("usVersion", &self.usVersion)
            .field("usMicArrayType", &self.usMicArrayType)
            .field("wVerticalAngleBegin", &self.wVerticalAngleBegin)
            .field("wVerticalAngleEnd", &self.wVerticalAngleEnd)
            .field("wHorizontalAngleBegin", &self.wHorizontalAngleBegin)
            .field("wHorizontalAngleEnd", &self.wHorizontalAngleEnd)
            .field("usFrequencyBandLo", &self.usFrequencyBandLo)
            .field("usFrequencyBandHi", &self.usFrequencyBandHi)
            .field("usNumberOfMicrophones", &self.usNumberOfMicrophones)
            .field("KsMicCoord", &self.KsMicCoord)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_MIC_ARRAY_GEOMETRY {
    fn eq(&self, other: &Self) -> bool {
        self.usVersion == other.usVersion
            && self.usMicArrayType == other.usMicArrayType
            && self.wVerticalAngleBegin == other.wVerticalAngleBegin
            && self.wVerticalAngleEnd == other.wVerticalAngleEnd
            && self.wHorizontalAngleBegin == other.wHorizontalAngleBegin
            && self.wHorizontalAngleEnd == other.wHorizontalAngleEnd
            && self.usFrequencyBandLo == other.usFrequencyBandLo
            && self.usFrequencyBandHi == other.usFrequencyBandHi
            && self.usNumberOfMicrophones == other.usNumberOfMicrophones
            && self.KsMicCoord == other.KsMicCoord
    }
}
impl ::std::cmp::Eq for KSAUDIO_MIC_ARRAY_GEOMETRY {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_MIC_ARRAY_GEOMETRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAUDIO_MIXCAP_TABLE {
    pub InputChannels: u32,
    pub OutputChannels: u32,
    pub Capabilities: [KSAUDIO_MIX_CAPS; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl KSAUDIO_MIXCAP_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAUDIO_MIXCAP_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAUDIO_MIXCAP_TABLE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAUDIO_MIXCAP_TABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAUDIO_MIXCAP_TABLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAUDIO_MIXLEVEL {
    pub Mute: super::super::super::Foundation::BOOL,
    pub Level: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAUDIO_MIXLEVEL {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAUDIO_MIXLEVEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSAUDIO_MIXLEVEL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_MIXLEVEL").field("Mute", &self.Mute).field("Level", &self.Level).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAUDIO_MIXLEVEL {
    fn eq(&self, other: &Self) -> bool {
        self.Mute == other.Mute && self.Level == other.Level
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAUDIO_MIXLEVEL {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAUDIO_MIXLEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSAUDIO_MIX_CAPS {
    pub Mute: super::super::super::Foundation::BOOL,
    pub Minimum: i32,
    pub Maximum: i32,
    pub Anonymous: KSAUDIO_MIX_CAPS_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAUDIO_MIX_CAPS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAUDIO_MIX_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAUDIO_MIX_CAPS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAUDIO_MIX_CAPS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAUDIO_MIX_CAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union KSAUDIO_MIX_CAPS_0 {
    pub Reset: i32,
    pub Resolution: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSAUDIO_MIX_CAPS_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSAUDIO_MIX_CAPS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSAUDIO_MIX_CAPS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSAUDIO_MIX_CAPS_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSAUDIO_MIX_CAPS_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_PACKETSIZE_CONSTRAINTS {
    pub MinPacketPeriodInHns: u32,
    pub PacketSizeFileAlignment: u32,
    pub Reserved: u32,
    pub NumProcessingModeConstraints: u32,
    pub ProcessingModeConstraints: [_KSAUDIO_PACKETSIZE_SIGNALPROCESSINGMODE_CONSTRAINT; 1],
}
impl KSAUDIO_PACKETSIZE_CONSTRAINTS {}
impl ::std::default::Default for KSAUDIO_PACKETSIZE_CONSTRAINTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_PACKETSIZE_CONSTRAINTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_PACKETSIZE_CONSTRAINTS")
            .field("MinPacketPeriodInHns", &self.MinPacketPeriodInHns)
            .field("PacketSizeFileAlignment", &self.PacketSizeFileAlignment)
            .field("Reserved", &self.Reserved)
            .field("NumProcessingModeConstraints", &self.NumProcessingModeConstraints)
            .field("ProcessingModeConstraints", &self.ProcessingModeConstraints)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_PACKETSIZE_CONSTRAINTS {
    fn eq(&self, other: &Self) -> bool {
        self.MinPacketPeriodInHns == other.MinPacketPeriodInHns && self.PacketSizeFileAlignment == other.PacketSizeFileAlignment && self.Reserved == other.Reserved && self.NumProcessingModeConstraints == other.NumProcessingModeConstraints && self.ProcessingModeConstraints == other.ProcessingModeConstraints
    }
}
impl ::std::cmp::Eq for KSAUDIO_PACKETSIZE_CONSTRAINTS {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_PACKETSIZE_CONSTRAINTS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_PACKETSIZE_CONSTRAINTS2 {
    pub MinPacketPeriodInHns: u32,
    pub PacketSizeFileAlignment: u32,
    pub MaxPacketSizeInBytes: u32,
    pub NumProcessingModeConstraints: u32,
    pub ProcessingModeConstraints: [_KSAUDIO_PACKETSIZE_SIGNALPROCESSINGMODE_CONSTRAINT; 1],
}
impl KSAUDIO_PACKETSIZE_CONSTRAINTS2 {}
impl ::std::default::Default for KSAUDIO_PACKETSIZE_CONSTRAINTS2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_PACKETSIZE_CONSTRAINTS2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_PACKETSIZE_CONSTRAINTS2")
            .field("MinPacketPeriodInHns", &self.MinPacketPeriodInHns)
            .field("PacketSizeFileAlignment", &self.PacketSizeFileAlignment)
            .field("MaxPacketSizeInBytes", &self.MaxPacketSizeInBytes)
            .field("NumProcessingModeConstraints", &self.NumProcessingModeConstraints)
            .field("ProcessingModeConstraints", &self.ProcessingModeConstraints)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_PACKETSIZE_CONSTRAINTS2 {
    fn eq(&self, other: &Self) -> bool {
        self.MinPacketPeriodInHns == other.MinPacketPeriodInHns && self.PacketSizeFileAlignment == other.PacketSizeFileAlignment && self.MaxPacketSizeInBytes == other.MaxPacketSizeInBytes && self.NumProcessingModeConstraints == other.NumProcessingModeConstraints && self.ProcessingModeConstraints == other.ProcessingModeConstraints
    }
}
impl ::std::cmp::Eq for KSAUDIO_PACKETSIZE_CONSTRAINTS2 {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_PACKETSIZE_CONSTRAINTS2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_POSITION {
    pub PlayOffset: u64,
    pub WriteOffset: u64,
}
impl KSAUDIO_POSITION {}
impl ::std::default::Default for KSAUDIO_POSITION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_POSITION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_POSITION").field("PlayOffset", &self.PlayOffset).field("WriteOffset", &self.WriteOffset).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_POSITION {
    fn eq(&self, other: &Self) -> bool {
        self.PlayOffset == other.PlayOffset && self.WriteOffset == other.WriteOffset
    }
}
impl ::std::cmp::Eq for KSAUDIO_POSITION {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_POSITION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_POSITIONEX {
    pub TimerFrequency: i64,
    pub TimeStamp1: i64,
    pub Position: KSAUDIO_POSITION,
    pub TimeStamp2: i64,
}
impl KSAUDIO_POSITIONEX {}
impl ::std::default::Default for KSAUDIO_POSITIONEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_POSITIONEX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_POSITIONEX").field("TimerFrequency", &self.TimerFrequency).field("TimeStamp1", &self.TimeStamp1).field("Position", &self.Position).field("TimeStamp2", &self.TimeStamp2).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_POSITIONEX {
    fn eq(&self, other: &Self) -> bool {
        self.TimerFrequency == other.TimerFrequency && self.TimeStamp1 == other.TimeStamp1 && self.Position == other.Position && self.TimeStamp2 == other.TimeStamp2
    }
}
impl ::std::cmp::Eq for KSAUDIO_POSITIONEX {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_POSITIONEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSAUDIO_PRESENTATION_POSITION {
    pub u64PositionInBlocks: u64,
    pub u64QPCPosition: u64,
}
impl KSAUDIO_PRESENTATION_POSITION {}
impl ::std::default::Default for KSAUDIO_PRESENTATION_POSITION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSAUDIO_PRESENTATION_POSITION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSAUDIO_PRESENTATION_POSITION").field("u64PositionInBlocks", &self.u64PositionInBlocks).field("u64QPCPosition", &self.u64QPCPosition).finish()
    }
}
impl ::std::cmp::PartialEq for KSAUDIO_PRESENTATION_POSITION {
    fn eq(&self, other: &Self) -> bool {
        self.u64PositionInBlocks == other.u64PositionInBlocks && self.u64QPCPosition == other.u64QPCPosition
    }
}
impl ::std::cmp::Eq for KSAUDIO_PRESENTATION_POSITION {}
unsafe impl ::windows::runtime::Abi for KSAUDIO_PRESENTATION_POSITION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_QUALITY_ADVANCED: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_QUALITY_BASIC: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_QUALITY_PC: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_QUALITY_WORST: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_DIRECTOUT: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_GROUND_FRONT_CENTER: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_GROUND_FRONT_LEFT: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_GROUND_FRONT_RIGHT: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_GROUND_REAR_LEFT: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_GROUND_REAR_RIGHT: u32 = 32u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_MONO: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_SUPER_WOOFER: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_SPEAKER_TOP_MIDDLE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_STEREO_SPEAKER_GEOMETRY_HEADPHONE: i32 = -1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_STEREO_SPEAKER_GEOMETRY_MAX: u32 = 180u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_STEREO_SPEAKER_GEOMETRY_MIN: u32 = 5u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW: u32 = 10u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSAUDIO_STEREO_SPEAKER_GEOMETRY_WIDE: u32 = 20u32;
pub const KSCAMERAPROFILE_BalancedVideoAndPhoto: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1800581143, 17095, 18977, [191, 227, 35, 240, 9, 20, 152, 135]);
pub const KSCAMERAPROFILE_CompressedCamera: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(238341569, 10157, 17279, [171, 222, 2, 182, 41, 243, 123, 68]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_FACEDETECTION: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_PHOTOHDR: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_PREVIEW_RES_MUSTMATCH: u64 = 32u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_VARIABLEPHOTOSEQUENCE: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_VIDEOHDR: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERAPROFILE_FLAGS_VIDEOSTABLIZATION: u64 = 1u64;
pub const KSCAMERAPROFILE_FaceAuth_Mode: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2167806754, 28683, 17734, [162, 212, 197, 46, 144, 123, 252, 39]);
pub const KSCAMERAPROFILE_HDRWithWCGPhoto: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2616652287, 46421, 17957, [179, 38, 164, 109, 239, 49, 143, 183]);
pub const KSCAMERAPROFILE_HDRWithWCGVideo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1260897078, 18724, 18825, [185, 148, 253, 175, 29, 199, 205, 133]);
pub const KSCAMERAPROFILE_HighFrameRate: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1450074387, 35893, 18663, [184, 159, 210, 63, 220, 18, 25, 220]);
pub const KSCAMERAPROFILE_HighQualityPhoto: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(843319077, 38427, 19619, [181, 178, 133, 78, 113, 157, 158, 27]);
pub const KSCAMERAPROFILE_Legacy: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3028897153, 25271, 20204, [135, 64, 128, 101, 140, 74, 157, 62]);
pub const KSCAMERAPROFILE_PhotoSequence: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(37330333, 20200, 18874, [188, 7, 95, 241, 86, 83, 20, 19]);
pub const KSCAMERAPROFILE_VariablePhotoSequence: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2683489110, 59226, 18865, [169, 40, 153, 133, 213, 148, 111, 135]);
pub const KSCAMERAPROFILE_VideoConferencing: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3309587080, 57791, 17815, [178, 221, 158, 30, 173, 134, 75, 184]);
pub const KSCAMERAPROFILE_VideoHDR8: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3572757740, 48639, 17172, [177, 212, 0, 142, 40, 31, 116, 231]);
pub const KSCAMERAPROFILE_VideoRecording: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2699368424, 36748, 20335, [154, 87, 70, 252, 47, 100, 126, 192]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_AUTO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_FNF: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_HDR: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_ULTRALOWLIGHT: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_BLUR: u64 = 1u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    pub Resolution: super::super::super::Foundation::SIZE,
    pub MaxFrameRate: KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0,
    pub MaskResolution: super::super::super::Foundation::SIZE,
    pub SubType: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS").field("Resolution", &self.Resolution).field("MaxFrameRate", &self.MaxFrameRate).field("MaskResolution", &self.MaskResolution).field("SubType", &self.SubType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.Resolution == other.Resolution && self.MaxFrameRate == other.MaxFrameRate && self.MaskResolution == other.MaskResolution && self.SubType == other.SubType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {
    pub Numerator: i32,
    pub Denominator: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_MaxFrameRate_e__Struct").field("Numerator", &self.Numerator).field("Denominator", &self.Denominator).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Numerator == other.Numerator && self.Denominator == other.Denominator
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_MASK: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_OFF: u64 = 0u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    pub PitchAngle: i32,
    pub YawAngle: i32,
    pub Flag: u32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_CAMERAOFFSET").field("PitchAngle", &self.PitchAngle).field("YawAngle", &self.YawAngle).field("Flag", &self.Flag).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    fn eq(&self, other: &Self) -> bool {
        self.PitchAngle == other.PitchAngle && self.YawAngle == other.YawAngle && self.Flag == other.Flag && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_CAPS_ASYNCCONTROL: u64 = 9223372036854775808u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_CAPS_CANCELLABLE: u64 = 4611686018427387904u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_CAPS_MASK: u64 = 18374686479671623680u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_CAPS_RESERVED: u64 = 18374686479671623680u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_AUTOFACEFRAMING: u64 = 1u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    pub ResolutionX: i32,
    pub ResolutionY: i32,
    pub PorchTop: i32,
    pub PorchLeft: i32,
    pub PorchBottom: i32,
    pub PorchRight: i32,
    pub NonUpscalingWindowSize: i32,
    pub MinWindowSize: i32,
    pub MaxWindowSize: i32,
    pub Reserved: i32,
}
impl KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS")
            .field("ResolutionX", &self.ResolutionX)
            .field("ResolutionY", &self.ResolutionY)
            .field("PorchTop", &self.PorchTop)
            .field("PorchLeft", &self.PorchLeft)
            .field("PorchBottom", &self.PorchBottom)
            .field("PorchRight", &self.PorchRight)
            .field("NonUpscalingWindowSize", &self.NonUpscalingWindowSize)
            .field("MinWindowSize", &self.MinWindowSize)
            .field("MaxWindowSize", &self.MaxWindowSize)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.ResolutionX == other.ResolutionX && self.ResolutionY == other.ResolutionY && self.PorchTop == other.PorchTop && self.PorchLeft == other.PorchLeft && self.PorchBottom == other.PorchBottom && self.PorchRight == other.PorchRight && self.NonUpscalingWindowSize == other.NonUpscalingWindowSize && self.MinWindowSize == other.MinWindowSize && self.MaxWindowSize == other.MaxWindowSize && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    pub Size: u32,
    pub Count: u32,
}
impl KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER").field("Size", &self.Size).field("Count", &self.Count).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_MANUAL: u64 = 0u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    pub OriginX: i32,
    pub OriginY: i32,
    pub WindowSize: i32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING").field("OriginX", &self.OriginX).field("OriginY", &self.OriginY).field("WindowSize", &self.WindowSize).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    fn eq(&self, other: &Self) -> bool {
        self.OriginX == other.OriginX && self.OriginY == other.OriginY && self.WindowSize == other.WindowSize && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    pub Mode: u32,
    pub Min: i32,
    pub Max: i32,
    pub Value: i32,
    pub Reserved: u64,
}
impl KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_EVCOMPENSATION").field("Mode", &self.Mode).field("Min", &self.Min).field("Max", &self.Max).field("Value", &self.Value).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    fn eq(&self, other: &Self) -> bool {
        self.Mode == other.Mode && self.Min == other.Min && self.Max == other.Max && self.Value == other.Value && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EVCOMP_FULLSTEP: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EVCOMP_HALFSTEP: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EVCOMP_QUARTERSTEP: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EVCOMP_SIXTHSTEP: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EVCOMP_THIRDSTEP: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EYEGAZECORRECTION_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_EYEGAZECORRECTION_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_ALTERNATIVE_FRAME_ILLUMINATION: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_BACKGROUND_SUBTRACTION: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_DISABLED: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_BLINK: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_PHOTO: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_PREVIEW: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_SMILE: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FACEDETECTION_VIDEO: u64 = 2u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    pub NormalizedFocalLengthX: u32,
    pub NormalizedFocalLengthY: u32,
    pub Flag: u32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_FIELDOFVIEW").field("NormalizedFocalLengthX", &self.NormalizedFocalLengthX).field("NormalizedFocalLengthY", &self.NormalizedFocalLengthY).field("Flag", &self.Flag).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    fn eq(&self, other: &Self) -> bool {
        self.NormalizedFocalLengthX == other.NormalizedFocalLengthX && self.NormalizedFocalLengthY == other.NormalizedFocalLengthY && self.Flag == other.Flag && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FILTERSCOPE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLAG_CANCELOPERATION: u64 = 9223372036854775808u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLAG_MASK: u64 = 18374686479671623680u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_AUTO: u64 = 256u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_ON: u64 = 128u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_AUTO: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_AUTO_ADJUSTABLEPOWER: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_MULTIFLASHSUPPORTED: u64 = 64u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_ON_ADJUSTABLEPOWER: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_REDEYEREDUCTION: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FLASH_SINGLEFLASH: u64 = 32u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUSPRIORITY_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUSPRIORITY_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_EXTENDEDPROP_FOCUSSTATE(pub i32);
pub const KSCAMERA_EXTENDEDPROP_FOCUSSTATE_UNINITIALIZED: KSCAMERA_EXTENDEDPROP_FOCUSSTATE = KSCAMERA_EXTENDEDPROP_FOCUSSTATE(0i32);
pub const KSCAMERA_EXTENDEDPROP_FOCUSSTATE_LOST: KSCAMERA_EXTENDEDPROP_FOCUSSTATE = KSCAMERA_EXTENDEDPROP_FOCUSSTATE(1i32);
pub const KSCAMERA_EXTENDEDPROP_FOCUSSTATE_SEARCHING: KSCAMERA_EXTENDEDPROP_FOCUSSTATE = KSCAMERA_EXTENDEDPROP_FOCUSSTATE(2i32);
pub const KSCAMERA_EXTENDEDPROP_FOCUSSTATE_FOCUSED: KSCAMERA_EXTENDEDPROP_FOCUSSTATE = KSCAMERA_EXTENDEDPROP_FOCUSSTATE(3i32);
pub const KSCAMERA_EXTENDEDPROP_FOCUSSTATE_FAILED: KSCAMERA_EXTENDEDPROP_FOCUSSTATE = KSCAMERA_EXTENDEDPROP_FOCUSSTATE(4i32);
impl ::std::convert::From<i32> for KSCAMERA_EXTENDEDPROP_FOCUSSTATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_FOCUSSTATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUS: u64 = 256u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUSLOCK: u64 = 512u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_HYPERFOCAL: u64 = 33554432u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_INFINITY: u64 = 16777216u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_NEAREST: u64 = 67108864u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_DRIVERFALLBACK_OFF: u64 = 2048u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_FULLRANGE: u64 = 262144u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_HYPERFOCAL: u64 = 1048576u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_INFINITY: u64 = 524288u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_MACRO: u64 = 65536u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_NORMAL: u64 = 131072u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_REGIONBASED: u64 = 4096u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_FOCUS_UNLOCK: u64 = 1024u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_HEADER {
    pub Version: u32,
    pub PinId: u32,
    pub Size: u32,
    pub Result: u32,
    pub Flags: u64,
    pub Capability: u64,
}
impl KSCAMERA_EXTENDEDPROP_HEADER {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_HEADER").field("Version", &self.Version).field("PinId", &self.PinId).field("Size", &self.Size).field("Result", &self.Result).field("Flags", &self.Flags).field("Capability", &self.Capability).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.PinId == other.PinId && self.Size == other.Size && self.Result == other.Result && self.Flags == other.Flags && self.Capability == other.Capability
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_HISTOGRAM_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_HISTOGRAM_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_IRTORCHMODE_ALTERNATING_FRAME_ILLUMINATION: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_IRTORCHMODE_ALWAYS_ON: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_IRTORCHMODE_OFF: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_100: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_12800: u64 = 1024u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_1600: u64 = 128u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_200: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_25600: u64 = 2048u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_3200: u64 = 256u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_400: u64 = 32u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_50: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_6400: u64 = 512u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_80: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_800: u64 = 64u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_AUTO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ISO_MANUAL: u64 = 36028797018963968u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_METADATAINFO {
    pub BufferAlignment: i32,
    pub MaxMetadataBufferSize: u32,
}
impl KSCAMERA_EXTENDEDPROP_METADATAINFO {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_METADATAINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_METADATAINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_METADATAINFO").field("BufferAlignment", &self.BufferAlignment).field("MaxMetadataBufferSize", &self.MaxMetadataBufferSize).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_METADATAINFO {
    fn eq(&self, other: &Self) -> bool {
        self.BufferAlignment == other.BufferAlignment && self.MaxMetadataBufferSize == other.MaxMetadataBufferSize
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_METADATAINFO {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_METADATAINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_METADATA_ALIGNMENTREQUIRED: u64 = 256u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_METADATA_MEMORYTYPE_MASK: u64 = 255u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_METADATA_SYSTEMMEMORY: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_EXTENDEDPROP_MetadataAlignment(pub i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_16: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(4i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_32: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(5i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_64: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(6i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_128: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(7i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_256: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(8i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_512: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(9i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_1024: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(10i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_2048: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(11i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_4096: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(12i32);
pub const KSCAMERA_EXTENDEDPROP_MetadataAlignment_8192: KSCAMERA_EXTENDEDPROP_MetadataAlignment = KSCAMERA_EXTENDEDPROP_MetadataAlignment(13i32);
impl ::std::convert::From<i32> for KSCAMERA_EXTENDEDPROP_MetadataAlignment {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_MetadataAlignment {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OIS_AUTO: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OIS_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OIS_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_DEFAULT: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_LATENCY: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_PHOTO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_POWER: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_QUALITY: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_OPTIMIZATION_VIDEO: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOCONFIRMATION_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOCONFIRMATION_ON: u64 = 1u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_PHOTOMODE {
    pub RequestedHistoryFrames: u32,
    pub MaxHistoryFrames: u32,
    pub SubMode: u32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_PHOTOMODE {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_PHOTOMODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_PHOTOMODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_PHOTOMODE").field("RequestedHistoryFrames", &self.RequestedHistoryFrames).field("MaxHistoryFrames", &self.MaxHistoryFrames).field("SubMode", &self.SubMode).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_PHOTOMODE {
    fn eq(&self, other: &Self) -> bool {
        self.RequestedHistoryFrames == other.RequestedHistoryFrames && self.MaxHistoryFrames == other.MaxHistoryFrames && self.SubMode == other.SubMode && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_PHOTOMODE {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_PHOTOMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOMODE_NORMAL: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE_SUB_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE_SUB_VARIABLE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_16X: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_2X: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_4X: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_8X: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_DISABLE: u64 = 0u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_PROFILE {
    pub ProfileId: ::windows::runtime::GUID,
    pub Index: u32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_PROFILE {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_PROFILE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_PROFILE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_PROFILE").field("ProfileId", &self.ProfileId).field("Index", &self.Index).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_PROFILE {
    fn eq(&self, other: &Self) -> bool {
        self.ProfileId == other.ProfileId && self.Index == other.Index && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_PROFILE {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_PROFILE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_DYNAMIC: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_EXTENDEDPROP_ROITYPE(pub i32);
pub const KSCAMERA_EXTENDEDPROP_ROITYPE_UNKNOWN: KSCAMERA_EXTENDEDPROP_ROITYPE = KSCAMERA_EXTENDEDPROP_ROITYPE(0i32);
pub const KSCAMERA_EXTENDEDPROP_ROITYPE_FACE: KSCAMERA_EXTENDEDPROP_ROITYPE = KSCAMERA_EXTENDEDPROP_ROITYPE(1i32);
impl ::std::convert::From<i32> for KSCAMERA_EXTENDEDPROP_ROITYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROITYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    pub ControlId: u32,
    pub MaxNumberOfROIs: u32,
    pub Capability: u64,
}
impl KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS").field("ControlId", &self.ControlId).field("MaxNumberOfROIs", &self.MaxNumberOfROIs).field("Capability", &self.Capability).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    fn eq(&self, other: &Self) -> bool {
        self.ControlId == other.ControlId && self.MaxNumberOfROIs == other.MaxNumberOfROIs && self.Capability == other.Capability
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    pub Size: u32,
    pub ConfigCapCount: u32,
    pub Reserved: u64,
}
impl KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER").field("Size", &self.Size).field("ConfigCapCount", &self.ConfigCapCount).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.ConfigCapCount == other.ConfigCapCount && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    pub ROIInfo: KSCAMERA_EXTENDEDPROP_ROI_INFO,
    pub Reserved: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE").field("ROIInfo", &self.ROIInfo).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    fn eq(&self, other: &Self) -> bool {
        self.ROIInfo == other.ROIInfo && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    pub ROIInfo: KSCAMERA_EXTENDEDPROP_ROI_INFO,
    pub Reserved: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_ROI_FOCUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_FOCUS").field("ROIInfo", &self.ROIInfo).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    fn eq(&self, other: &Self) -> bool {
        self.ROIInfo == other.ROIInfo && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_FOCUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_INFO {
    pub Region: super::super::super::Foundation::RECT,
    pub Flags: u64,
    pub Weight: i32,
    pub RegionOfInterestType: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_ROI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_INFO").field("Region", &self.Region).field("Flags", &self.Flags).field("Weight", &self.Weight).field("RegionOfInterestType", &self.RegionOfInterestType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Region == other.Region && self.Flags == other.Flags && self.Weight == other.Weight && self.RegionOfInterestType == other.RegionOfInterestType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    pub ControlId: u32,
    pub ROICount: u32,
    pub Result: u32,
    pub Reserved: u32,
}
impl KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL").field("ControlId", &self.ControlId).field("ROICount", &self.ROICount).field("Result", &self.Result).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    fn eq(&self, other: &Self) -> bool {
        self.ControlId == other.ControlId && self.ROICount == other.ROICount && self.Result == other.Result && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    pub Size: u32,
    pub ControlCount: u32,
    pub Reserved: u64,
}
impl KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER").field("Size", &self.Size).field("ControlCount", &self.ControlCount).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.ControlCount == other.ControlCount && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    pub ROIInfo: KSCAMERA_EXTENDEDPROP_ROI_INFO,
    pub Reserved: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE").field("ROIInfo", &self.ROIInfo).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    fn eq(&self, other: &Self) -> bool {
        self.ROIInfo == other.ROIInfo && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_AUTO: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_BACKLIT: u64 = 1024u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_BEACH: u64 = 32u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_CANDLELIGHT: u64 = 128u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_LANDSCAPE: u64 = 256u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_MACRO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_MANUAL: u64 = 36028797018963968u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_NIGHT: u64 = 16u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_NIGHTPORTRAIT: u64 = 512u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_PORTRAIT: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_SNOW: u64 = 8u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_SPORT: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SCENEMODE_SUNSET: u64 = 64u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SECUREMODE_DISABLED: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_SECUREMODE_ENABLED: u64 = 2u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_VALUE {
    pub Value: KSCAMERA_EXTENDEDPROP_VALUE_0,
}
impl KSCAMERA_EXTENDEDPROP_VALUE {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_VALUE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_VALUE {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_VALUE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSCAMERA_EXTENDEDPROP_VALUE_0 {
    pub dbl: f64,
    pub ull: u64,
    pub ul: u32,
    pub ratio: u64,
    pub l: i32,
    pub ll: i64,
}
impl KSCAMERA_EXTENDEDPROP_VALUE_0 {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_VALUE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_VALUE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_VALUE_0 {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_VALUE_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VFR_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VFR_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOHDR_AUTO: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOHDR_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOHDR_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_AUTO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_LOCK: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_MANUAL: u64 = 2u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {
    pub Mode: u32,
    pub Min: i32,
    pub Max: i32,
    pub Step: i32,
    pub VideoProc: KSCAMERA_EXTENDEDPROP_VALUE,
    pub Reserved: u64,
}
impl KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {}
impl ::std::default::Default for KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_AUTO: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_AUTO: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_OFF: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_ON: u64 = 4u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTORCH_OFF: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTORCH_ON: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_VIDEOTORCH_ON_ADJUSTABLEPOWER: u64 = 2u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_WARMSTART_MODE_DISABLED: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_WARMSTART_MODE_ENABLED: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_EXTENDEDPROP_WBPRESET(pub i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_CLOUDY: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(1i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_DAYLIGHT: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(2i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_FLASH: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(3i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_FLUORESCENT: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(4i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_TUNGSTEN: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(5i32);
pub const KSCAMERA_EXTENDEDPROP_WBPRESET_CANDLELIGHT: KSCAMERA_EXTENDEDPROP_WBPRESET = KSCAMERA_EXTENDEDPROP_WBPRESET(6i32);
impl ::std::convert::From<i32> for KSCAMERA_EXTENDEDPROP_WBPRESET {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_WBPRESET {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE(pub i32);
pub const KSCAMERA_EXTENDEDPROP_WHITEBALANCE_TEMPERATURE: KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE = KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE(1i32);
pub const KSCAMERA_EXTENDEDPROP_WHITEBALANCE_PRESET: KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE = KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE(2i32);
impl ::std::convert::From<i32> for KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ZOOM_DEFAULT: u64 = 0u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ZOOM_DIRECT: u64 = 1u64;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_EXTENDEDPROP_ZOOM_SMOOTH: u64 = 2u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_MAXVIDEOFPS_FORPHOTORES {
    pub PhotoResWidth: u32,
    pub PhotoResHeight: u32,
    pub PreviewFPSNum: u32,
    pub PreviewFPSDenom: u32,
    pub CaptureFPSNum: u32,
    pub CaptureFPSDenom: u32,
}
impl KSCAMERA_MAXVIDEOFPS_FORPHOTORES {}
impl ::std::default::Default for KSCAMERA_MAXVIDEOFPS_FORPHOTORES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_MAXVIDEOFPS_FORPHOTORES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_MAXVIDEOFPS_FORPHOTORES")
            .field("PhotoResWidth", &self.PhotoResWidth)
            .field("PhotoResHeight", &self.PhotoResHeight)
            .field("PreviewFPSNum", &self.PreviewFPSNum)
            .field("PreviewFPSDenom", &self.PreviewFPSDenom)
            .field("CaptureFPSNum", &self.CaptureFPSNum)
            .field("CaptureFPSDenom", &self.CaptureFPSDenom)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_MAXVIDEOFPS_FORPHOTORES {
    fn eq(&self, other: &Self) -> bool {
        self.PhotoResWidth == other.PhotoResWidth && self.PhotoResHeight == other.PhotoResHeight && self.PreviewFPSNum == other.PreviewFPSNum && self.PreviewFPSDenom == other.PreviewFPSDenom && self.CaptureFPSNum == other.CaptureFPSNum && self.CaptureFPSDenom == other.CaptureFPSDenom
    }
}
impl ::std::cmp::Eq for KSCAMERA_MAXVIDEOFPS_FORPHOTORES {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_MAXVIDEOFPS_FORPHOTORES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub MaskCoverageBoundingBox: super::super::super::Foundation::RECT,
    pub MaskResolution: super::super::super::Foundation::SIZE,
    pub ForegroundBoundingBox: super::super::super::Foundation::RECT,
    pub MaskData: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK")
            .field("Header", &self.Header)
            .field("MaskCoverageBoundingBox", &self.MaskCoverageBoundingBox)
            .field("MaskResolution", &self.MaskResolution)
            .field("ForegroundBoundingBox", &self.ForegroundBoundingBox)
            .field("MaskData", &self.MaskData)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header && self.MaskCoverageBoundingBox == other.MaskCoverageBoundingBox && self.MaskResolution == other.MaskResolution && self.ForegroundBoundingBox == other.ForegroundBoundingBox && self.MaskData == other.MaskData
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_METADATA_CAPTURESTATS {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub Flags: u32,
    pub Reserved: u32,
    pub ExposureTime: u64,
    pub ExposureCompensationFlags: u64,
    pub ExposureCompensationValue: i32,
    pub IsoSpeed: u32,
    pub FocusState: u32,
    pub LensPosition: u32,
    pub WhiteBalance: u32,
    pub Flash: u32,
    pub FlashPower: u32,
    pub ZoomFactor: u32,
    pub SceneMode: u64,
    pub SensorFramerate: u64,
}
impl KSCAMERA_METADATA_CAPTURESTATS {}
impl ::std::default::Default for KSCAMERA_METADATA_CAPTURESTATS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_METADATA_CAPTURESTATS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_CAPTURESTATS")
            .field("Header", &self.Header)
            .field("Flags", &self.Flags)
            .field("Reserved", &self.Reserved)
            .field("ExposureTime", &self.ExposureTime)
            .field("ExposureCompensationFlags", &self.ExposureCompensationFlags)
            .field("ExposureCompensationValue", &self.ExposureCompensationValue)
            .field("IsoSpeed", &self.IsoSpeed)
            .field("FocusState", &self.FocusState)
            .field("LensPosition", &self.LensPosition)
            .field("WhiteBalance", &self.WhiteBalance)
            .field("Flash", &self.Flash)
            .field("FlashPower", &self.FlashPower)
            .field("ZoomFactor", &self.ZoomFactor)
            .field("SceneMode", &self.SceneMode)
            .field("SensorFramerate", &self.SensorFramerate)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_CAPTURESTATS {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header
            && self.Flags == other.Flags
            && self.Reserved == other.Reserved
            && self.ExposureTime == other.ExposureTime
            && self.ExposureCompensationFlags == other.ExposureCompensationFlags
            && self.ExposureCompensationValue == other.ExposureCompensationValue
            && self.IsoSpeed == other.IsoSpeed
            && self.FocusState == other.FocusState
            && self.LensPosition == other.LensPosition
            && self.WhiteBalance == other.WhiteBalance
            && self.Flash == other.Flash
            && self.FlashPower == other.FlashPower
            && self.ZoomFactor == other.ZoomFactor
            && self.SceneMode == other.SceneMode
            && self.SensorFramerate == other.SensorFramerate
    }
}
impl ::std::cmp::Eq for KSCAMERA_METADATA_CAPTURESTATS {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_CAPTURESTATS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_EXPOSURECOMPENSATION: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_EXPOSURETIME: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_FLASH: u32 = 64u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_FLASHPOWER: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_FOCUSSTATE: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_ISOSPEED: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_LENSPOSITION: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_SCENEMODE: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_SENSORFRAMERATE: u32 = 1024u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_WHITEBALANCE: u32 = 32u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_CAPTURESTATS_FLAG_ZOOMFACTOR: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_METADATA_DIGITALWINDOW {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub Window: KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING,
}
impl KSCAMERA_METADATA_DIGITALWINDOW {}
impl ::std::default::Default for KSCAMERA_METADATA_DIGITALWINDOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_METADATA_DIGITALWINDOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_DIGITALWINDOW").field("Header", &self.Header).field("Window", &self.Window).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_DIGITALWINDOW {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header && self.Window == other.Window
    }
}
impl ::std::cmp::Eq for KSCAMERA_METADATA_DIGITALWINDOW {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_DIGITALWINDOW {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_METADATA_FRAMEILLUMINATION {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub Flags: u32,
    pub Reserved: u32,
}
impl KSCAMERA_METADATA_FRAMEILLUMINATION {}
impl ::std::default::Default for KSCAMERA_METADATA_FRAMEILLUMINATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_METADATA_FRAMEILLUMINATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_FRAMEILLUMINATION").field("Header", &self.Header).field("Flags", &self.Flags).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_FRAMEILLUMINATION {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header && self.Flags == other.Flags && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_METADATA_FRAMEILLUMINATION {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_FRAMEILLUMINATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_METADATA_FRAMEILLUMINATION_FLAG_ON: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_METADATA_ITEMHEADER {
    pub MetadataId: u32,
    pub Size: u32,
}
impl KSCAMERA_METADATA_ITEMHEADER {}
impl ::std::default::Default for KSCAMERA_METADATA_ITEMHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_METADATA_ITEMHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_ITEMHEADER").field("MetadataId", &self.MetadataId).field("Size", &self.Size).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_ITEMHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.MetadataId == other.MetadataId && self.Size == other.Size
    }
}
impl ::std::cmp::Eq for KSCAMERA_METADATA_ITEMHEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_ITEMHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_METADATA_PHOTOCONFIRMATION {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub PhotoConfirmationIndex: u32,
    pub Reserved: u32,
}
impl KSCAMERA_METADATA_PHOTOCONFIRMATION {}
impl ::std::default::Default for KSCAMERA_METADATA_PHOTOCONFIRMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_METADATA_PHOTOCONFIRMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_METADATA_PHOTOCONFIRMATION").field("Header", &self.Header).field("PhotoConfirmationIndex", &self.PhotoConfirmationIndex).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_METADATA_PHOTOCONFIRMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header && self.PhotoConfirmationIndex == other.PhotoConfirmationIndex && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_METADATA_PHOTOCONFIRMATION {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_METADATA_PHOTOCONFIRMATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_MetadataId(pub i32);
pub const MetadataId_Standard_Start: KSCAMERA_MetadataId = KSCAMERA_MetadataId(1i32);
pub const MetadataId_PhotoConfirmation: KSCAMERA_MetadataId = KSCAMERA_MetadataId(1i32);
pub const MetadataId_UsbVideoHeader: KSCAMERA_MetadataId = KSCAMERA_MetadataId(2i32);
pub const MetadataId_CaptureStats: KSCAMERA_MetadataId = KSCAMERA_MetadataId(3i32);
pub const MetadataId_CameraExtrinsics: KSCAMERA_MetadataId = KSCAMERA_MetadataId(4i32);
pub const MetadataId_CameraIntrinsics: KSCAMERA_MetadataId = KSCAMERA_MetadataId(5i32);
pub const MetadataId_FrameIllumination: KSCAMERA_MetadataId = KSCAMERA_MetadataId(6i32);
pub const MetadataId_DigitalWindow: KSCAMERA_MetadataId = KSCAMERA_MetadataId(7i32);
pub const MetadataId_BackgroundSegmentationMask: KSCAMERA_MetadataId = KSCAMERA_MetadataId(8i32);
pub const MetadataId_Standard_End: KSCAMERA_MetadataId = KSCAMERA_MetadataId(8i32);
pub const MetadataId_Custom_Start: KSCAMERA_MetadataId = KSCAMERA_MetadataId(-2147483648i32);
impl ::std::convert::From<i32> for KSCAMERA_MetadataId {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_MetadataId {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_PERFRAMESETTING_AUTO: u64 = 4294967296u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_CAP_HEADER {
    pub Size: u32,
    pub ItemCount: u32,
    pub Flags: u64,
}
impl KSCAMERA_PERFRAMESETTING_CAP_HEADER {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_CAP_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_CAP_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_CAP_HEADER").field("Size", &self.Size).field("ItemCount", &self.ItemCount).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_CAP_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.ItemCount == other.ItemCount && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_CAP_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_CAP_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {
    pub Size: u32,
    pub Type: u32,
    pub Flags: u64,
}
impl KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER").field("Size", &self.Size).field("Type", &self.Type).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Type == other.Type && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {
    pub Size: u32,
    pub Reserved: u32,
    pub Id: ::windows::runtime::GUID,
}
impl KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM").field("Size", &self.Size).field("Reserved", &self.Reserved).field("Id", &self.Id).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Reserved == other.Reserved && self.Id == other.Id
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_FRAME_HEADER {
    pub Size: u32,
    pub Id: u32,
    pub ItemCount: u32,
    pub Reserved: u32,
}
impl KSCAMERA_PERFRAMESETTING_FRAME_HEADER {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_FRAME_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_FRAME_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_FRAME_HEADER").field("Size", &self.Size).field("Id", &self.Id).field("ItemCount", &self.ItemCount).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_FRAME_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Id == other.Id && self.ItemCount == other.ItemCount && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_FRAME_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_FRAME_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_HEADER {
    pub Size: u32,
    pub FrameCount: u32,
    pub Id: ::windows::runtime::GUID,
    pub Flags: u64,
    pub LoopCount: u32,
    pub Reserved: u32,
}
impl KSCAMERA_PERFRAMESETTING_HEADER {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_HEADER").field("Size", &self.Size).field("FrameCount", &self.FrameCount).field("Id", &self.Id).field("Flags", &self.Flags).field("LoopCount", &self.LoopCount).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.FrameCount == other.FrameCount && self.Id == other.Id && self.Flags == other.Flags && self.LoopCount == other.LoopCount && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_HEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PERFRAMESETTING_ITEM_HEADER {
    pub Size: u32,
    pub Type: u32,
    pub Flags: u64,
}
impl KSCAMERA_PERFRAMESETTING_ITEM_HEADER {}
impl ::std::default::Default for KSCAMERA_PERFRAMESETTING_ITEM_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PERFRAMESETTING_ITEM_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PERFRAMESETTING_ITEM_HEADER").field("Size", &self.Size).field("Type", &self.Type).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PERFRAMESETTING_ITEM_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Type == other.Type && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for KSCAMERA_PERFRAMESETTING_ITEM_HEADER {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_ITEM_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSCAMERA_PERFRAMESETTING_ITEM_TYPE(pub i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_EXPOSURE_TIME: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(1i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_FLASH: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(2i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_EXPOSURE_COMPENSATION: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(3i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_ISO: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(4i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_FOCUS: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(5i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_PHOTOCONFIRMATION: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(6i32);
pub const KSCAMERA_PERFRAMESETTING_ITEM_CUSTOM: KSCAMERA_PERFRAMESETTING_ITEM_TYPE = KSCAMERA_PERFRAMESETTING_ITEM_TYPE(7i32);
impl ::std::convert::From<i32> for KSCAMERA_PERFRAMESETTING_ITEM_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PERFRAMESETTING_ITEM_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCAMERA_PERFRAMESETTING_MANUAL: u64 = 8589934592u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_CONCURRENCYINFO {
    pub ReferenceGuid: ::windows::runtime::GUID,
    pub Reserved: u32,
    pub ProfileCount: u32,
    pub Profiles: *mut KSCAMERA_PROFILE_INFO,
}
impl KSCAMERA_PROFILE_CONCURRENCYINFO {}
impl ::std::default::Default for KSCAMERA_PROFILE_CONCURRENCYINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_CONCURRENCYINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PROFILE_CONCURRENCYINFO").field("ReferenceGuid", &self.ReferenceGuid).field("Reserved", &self.Reserved).field("ProfileCount", &self.ProfileCount).field("Profiles", &self.Profiles).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_CONCURRENCYINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ReferenceGuid == other.ReferenceGuid && self.Reserved == other.Reserved && self.ProfileCount == other.ProfileCount && self.Profiles == other.Profiles
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_CONCURRENCYINFO {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_CONCURRENCYINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_INFO {
    pub ProfileId: ::windows::runtime::GUID,
    pub Index: u32,
    pub PinCount: u32,
    pub Pins: *mut KSCAMERA_PROFILE_PININFO,
}
impl KSCAMERA_PROFILE_INFO {}
impl ::std::default::Default for KSCAMERA_PROFILE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PROFILE_INFO").field("ProfileId", &self.ProfileId).field("Index", &self.Index).field("PinCount", &self.PinCount).field("Pins", &self.Pins).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ProfileId == other.ProfileId && self.Index == other.Index && self.PinCount == other.PinCount && self.Pins == other.Pins
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_INFO {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_MEDIAINFO {
    pub Resolution: KSCAMERA_PROFILE_MEDIAINFO_1,
    pub MaxFrameRate: KSCAMERA_PROFILE_MEDIAINFO_0,
    pub Flags: u64,
    pub Data0: u32,
    pub Data1: u32,
    pub Data2: u32,
    pub Data3: u32,
}
impl KSCAMERA_PROFILE_MEDIAINFO {}
impl ::std::default::Default for KSCAMERA_PROFILE_MEDIAINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_MEDIAINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCAMERA_PROFILE_MEDIAINFO").field("Resolution", &self.Resolution).field("MaxFrameRate", &self.MaxFrameRate).field("Flags", &self.Flags).field("Data0", &self.Data0).field("Data1", &self.Data1).field("Data2", &self.Data2).field("Data3", &self.Data3).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_MEDIAINFO {
    fn eq(&self, other: &Self) -> bool {
        self.Resolution == other.Resolution && self.MaxFrameRate == other.MaxFrameRate && self.Flags == other.Flags && self.Data0 == other.Data0 && self.Data1 == other.Data1 && self.Data2 == other.Data2 && self.Data3 == other.Data3
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_MEDIAINFO {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_MEDIAINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_MEDIAINFO_0 {
    pub Numerator: u32,
    pub Denominator: u32,
}
impl KSCAMERA_PROFILE_MEDIAINFO_0 {}
impl ::std::default::Default for KSCAMERA_PROFILE_MEDIAINFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_MEDIAINFO_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_MaxFrameRate_e__Struct").field("Numerator", &self.Numerator).field("Denominator", &self.Denominator).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_MEDIAINFO_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Numerator == other.Numerator && self.Denominator == other.Denominator
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_MEDIAINFO_0 {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_MEDIAINFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_MEDIAINFO_1 {
    pub X: u32,
    pub Y: u32,
}
impl KSCAMERA_PROFILE_MEDIAINFO_1 {}
impl ::std::default::Default for KSCAMERA_PROFILE_MEDIAINFO_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_MEDIAINFO_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Resolution_e__Struct").field("X", &self.X).field("Y", &self.Y).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_MEDIAINFO_1 {
    fn eq(&self, other: &Self) -> bool {
        self.X == other.X && self.Y == other.Y
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_MEDIAINFO_1 {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_MEDIAINFO_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_PININFO {
    pub PinCategory: ::windows::runtime::GUID,
    pub Anonymous: KSCAMERA_PROFILE_PININFO_0,
    pub MediaInfoCount: u32,
    pub MediaInfos: *mut KSCAMERA_PROFILE_MEDIAINFO,
}
impl KSCAMERA_PROFILE_PININFO {}
impl ::std::default::Default for KSCAMERA_PROFILE_PININFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_PININFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_PININFO {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_PININFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSCAMERA_PROFILE_PININFO_0 {
    pub Anonymous: KSCAMERA_PROFILE_PININFO_0_0,
    pub Reserved: u32,
}
impl KSCAMERA_PROFILE_PININFO_0 {}
impl ::std::default::Default for KSCAMERA_PROFILE_PININFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_PININFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_PININFO_0 {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_PININFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCAMERA_PROFILE_PININFO_0_0 {
    pub PinIndex: u16,
    pub ProfileSensorType: u16,
}
impl KSCAMERA_PROFILE_PININFO_0_0 {}
impl ::std::default::Default for KSCAMERA_PROFILE_PININFO_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCAMERA_PROFILE_PININFO_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("PinIndex", &self.PinIndex).field("ProfileSensorType", &self.ProfileSensorType).finish()
    }
}
impl ::std::cmp::PartialEq for KSCAMERA_PROFILE_PININFO_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.PinIndex == other.PinIndex && self.ProfileSensorType == other.ProfileSensorType
    }
}
impl ::std::cmp::Eq for KSCAMERA_PROFILE_PININFO_0_0 {}
unsafe impl ::windows::runtime::Abi for KSCAMERA_PROFILE_PININFO_0_0 {
    type Abi = Self;
}
pub const KSCATEGORY_ACOUSTIC_ECHO_CANCEL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3214294400, 50521, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSCATEGORY_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1771351300, 37871, 4560, [163, 204, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_BRIDGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(140181248, 25294, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_CAPTURE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1709733693, 36694, 4560, [163, 185, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_CLOCK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1394025600, 18321, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_COMMUNICATIONSTRANSFORM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3474840108, 38723, 4560, [163, 238, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_CROSSBAR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2811865089, 42093, 4560, [161, 140, 0, 160, 36, 1, 220, 212]);
pub const KSCATEGORY_DATACOMPRESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(512018688, 32368, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_DATADECOMPRESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(656518688, 32368, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_DATATRANSFORM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(783318688, 32368, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(426286070, 50052, 18685, [173, 81, 144, 229, 140, 121, 247, 11]);
pub const KSCATEGORY_ESCALANTE_PLATFORM_DRIVER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1962127016, 38760, 4561, [142, 7, 0, 160, 201, 94, 194, 46]);
pub const KSCATEGORY_FILESYSTEM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1980755294, 37719, 4560, [163, 204, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_INTERFACETRANSFORM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3474840109, 38723, 4560, [163, 238, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_MEDIUMTRANSFORM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3474840110, 38723, 4560, [163, 238, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2198488306, 41773, 18283, [190, 151, 66, 132, 86, 115, 179, 90]);
pub const KSCATEGORY_MIXER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2910886912, 31624, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_MULTIPLEXER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2052973011, 417, 17708, [180, 129, 79, 162, 185, 98, 113, 232]);
pub const KSCATEGORY_NETWORK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1741278268, 27076, 4562, [135, 89, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_NETWORK_CAMERA: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3089335890, 46336, 16875, [180, 243, 66, 52, 247, 245, 174, 153]);
pub const KSCATEGORY_PROXY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2548804298, 38333, 4560, [163, 234, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_QUALITY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2548804299, 38333, 4560, [163, 234, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_REALTIME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3943784444, 4296, 18788, [131, 29, 109, 203, 2, 230, 242, 63]);
pub const KSCATEGORY_RENDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1709733694, 36694, 4560, [163, 185, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_SENSOR_CAMERA: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(619008727, 25891, 18423, [166, 71, 211, 70, 91, 241, 245, 202]);
pub const KSCATEGORY_SENSOR_GROUP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1721528852, 2696, 17169, [167, 243, 78, 121, 130, 14, 51, 189]);
pub const KSCATEGORY_SPLITTER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(172118688, 32368, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSCATEGORY_TEXT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1771351302, 37871, 4560, [163, 204, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_TOPOLOGY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3718597184, 7756, 4561, [160, 80, 64, 87, 5, 193, 0, 0]);
pub const KSCATEGORY_TVAUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2811865090, 42093, 4560, [161, 140, 0, 160, 36, 1, 220, 212]);
pub const KSCATEGORY_TVTUNER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2811865088, 42093, 4560, [161, 140, 0, 160, 36, 1, 220, 212]);
pub const KSCATEGORY_VBICODEC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(131782240, 8945, 4561, [169, 244, 0, 192, 79, 187, 222, 143]);
pub const KSCATEGORY_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1771351301, 37871, 4560, [163, 204, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_VIDEO_CAMERA: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3845273463, 63862, 20315, [155, 85, 185, 70, 153, 196, 110, 68]);
pub const KSCATEGORY_VIRTUAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(889449156, 7974, 4561, [138, 176, 0, 160, 201, 34, 49, 150]);
pub const KSCATEGORY_VPMUX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2811865091, 42093, 4560, [161, 140, 0, 160, 36, 1, 220, 212]);
pub const KSCATEGORY_WDMAUD_USE_PIN_NAME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1201994272, 41553, 4561, [160, 80, 0, 0, 248, 0, 71, 136]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCLOCK_CREATE {
    pub CreateFlags: u32,
}
impl KSCLOCK_CREATE {}
impl ::std::default::Default for KSCLOCK_CREATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCLOCK_CREATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCLOCK_CREATE").field("CreateFlags", &self.CreateFlags).finish()
    }
}
impl ::std::cmp::PartialEq for KSCLOCK_CREATE {
    fn eq(&self, other: &Self) -> bool {
        self.CreateFlags == other.CreateFlags
    }
}
impl ::std::cmp::Eq for KSCLOCK_CREATE {}
unsafe impl ::windows::runtime::Abi for KSCLOCK_CREATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCOMPONENTID {
    pub Manufacturer: ::windows::runtime::GUID,
    pub Product: ::windows::runtime::GUID,
    pub Component: ::windows::runtime::GUID,
    pub Name: ::windows::runtime::GUID,
    pub Version: u32,
    pub Revision: u32,
}
impl KSCOMPONENTID {}
impl ::std::default::Default for KSCOMPONENTID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCOMPONENTID {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCOMPONENTID").field("Manufacturer", &self.Manufacturer).field("Product", &self.Product).field("Component", &self.Component).field("Name", &self.Name).field("Version", &self.Version).field("Revision", &self.Revision).finish()
    }
}
impl ::std::cmp::PartialEq for KSCOMPONENTID {
    fn eq(&self, other: &Self) -> bool {
        self.Manufacturer == other.Manufacturer && self.Product == other.Product && self.Component == other.Component && self.Name == other.Name && self.Version == other.Version && self.Revision == other.Revision
    }
}
impl ::std::cmp::Eq for KSCOMPONENTID {}
unsafe impl ::windows::runtime::Abi for KSCOMPONENTID {
    type Abi = Self;
}
pub const KSCOMPONENTID_USBAUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2400351728, 9961, 16996, [186, 77, 57, 255, 240, 29, 148, 170]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSCORRELATED_TIME {
    pub Time: i64,
    pub SystemTime: i64,
}
impl KSCORRELATED_TIME {}
impl ::std::default::Default for KSCORRELATED_TIME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSCORRELATED_TIME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSCORRELATED_TIME").field("Time", &self.Time).field("SystemTime", &self.SystemTime).finish()
    }
}
impl ::std::cmp::PartialEq for KSCORRELATED_TIME {
    fn eq(&self, other: &Self) -> bool {
        self.Time == other.Time && self.SystemTime == other.SystemTime
    }
}
impl ::std::cmp::Eq for KSCORRELATED_TIME {}
unsafe impl ::windows::runtime::Abi for KSCORRELATED_TIME {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCREATE_ITEM_FREEONSTOP: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCREATE_ITEM_NOPARAMETERS: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCREATE_ITEM_SECURITYCHANGED: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCREATE_ITEM_WILDCARD: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_Custom: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_Depth: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_ImageSegmentation: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_Infrared: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_PoseTracking: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSCameraProfileSensorType_RGB: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSDATAFORMAT {
    pub Anonymous: KSDATAFORMAT_0,
    pub Alignment: i64,
}
impl KSDATAFORMAT {}
impl ::std::default::Default for KSDATAFORMAT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDATAFORMAT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDATAFORMAT {}
unsafe impl ::windows::runtime::Abi for KSDATAFORMAT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDATAFORMAT_0 {
    pub FormatSize: u32,
    pub Flags: u32,
    pub SampleSize: u32,
    pub Reserved: u32,
    pub MajorFormat: ::windows::runtime::GUID,
    pub SubFormat: ::windows::runtime::GUID,
    pub Specifier: ::windows::runtime::GUID,
}
impl KSDATAFORMAT_0 {}
impl ::std::default::Default for KSDATAFORMAT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDATAFORMAT_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("FormatSize", &self.FormatSize).field("Flags", &self.Flags).field("SampleSize", &self.SampleSize).field("Reserved", &self.Reserved).field("MajorFormat", &self.MajorFormat).field("SubFormat", &self.SubFormat).field("Specifier", &self.Specifier).finish()
    }
}
impl ::std::cmp::PartialEq for KSDATAFORMAT_0 {
    fn eq(&self, other: &Self) -> bool {
        self.FormatSize == other.FormatSize && self.Flags == other.Flags && self.SampleSize == other.SampleSize && self.Reserved == other.Reserved && self.MajorFormat == other.MajorFormat && self.SubFormat == other.SubFormat && self.Specifier == other.Specifier
    }
}
impl ::std::cmp::Eq for KSDATAFORMAT_0 {}
unsafe impl ::windows::runtime::Abi for KSDATAFORMAT_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDATAFORMAT_BIT_ATTRIBUTES: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDATAFORMAT_BIT_TEMPORAL_COMPRESSION: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
pub struct KSDATAFORMAT_DSOUND {
    pub DataFormat: KSDATAFORMAT,
    pub BufferDesc: KSDSOUND_BUFFERDESC,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl KSDATAFORMAT_DSOUND {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for KSDATAFORMAT_DSOUND {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for KSDATAFORMAT_DSOUND {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for KSDATAFORMAT_DSOUND {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for KSDATAFORMAT_DSOUND {
    type Abi = Self;
}
pub const KSDATAFORMAT_SPECIFIER_AC3_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272804, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SPECIFIER_ANALOGVIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(75685344, 30743, 4559, [138, 3, 0, 170, 0, 110, 203, 101]);
pub const KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358773, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358770, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358769, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358772, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358771, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SPECIFIER_DSOUND: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1367707810, 41348, 4560, [133, 34, 0, 192, 79, 217, 186, 243]);
pub const KSDATAFORMAT_SPECIFIER_FILEHANDLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1709733692, 36694, 4560, [163, 185, 0, 160, 201, 34, 49, 150]);
pub const KSDATAFORMAT_SPECIFIER_FILENAME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2860088128, 59764, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSDATAFORMAT_SPECIFIER_H264_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(538426885, 26153, 16968, [170, 237, 126, 26, 71, 188, 155, 156]);
pub const KSDATAFORMAT_SPECIFIER_IMAGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1764729721, 54248, 18001, [181, 180, 11, 148, 176, 19, 238, 175]);
pub const KSDATAFORMAT_SPECIFIER_JPEG_IMAGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1764729721, 54248, 18001, [181, 180, 11, 148, 176, 19, 238, 175]);
pub const KSDATAFORMAT_SPECIFIER_LPCM_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272806, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(89694082, 50006, 4558, [191, 1, 0, 170, 0, 85, 89, 90]);
pub const KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272805, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272803, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SPECIFIER_NONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(258217942, 49944, 4560, [164, 63, 0, 160, 201, 34, 49, 150]);
pub const KSDATAFORMAT_SPECIFIER_VBI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4146755296, 60170, 4560, [172, 228, 0, 0, 192, 204, 22, 186]);
pub const KSDATAFORMAT_SPECIFIER_VC_ID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2912473476, 43715, 4560, [164, 28, 0, 160, 201, 34, 49, 150]);
pub const KSDATAFORMAT_SPECIFIER_VIDEOINFO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(89694080, 50006, 4558, [191, 1, 0, 170, 0, 85, 89, 90]);
pub const KSDATAFORMAT_SPECIFIER_VIDEOINFO2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4146755232, 60170, 4560, [172, 228, 0, 0, 192, 204, 22, 186]);
pub const KSDATAFORMAT_SPECIFIER_WAVEFORMATEX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(89694081, 50006, 4558, [191, 1, 0, 170, 0, 85, 89, 90]);
pub const KSDATAFORMAT_SUBTYPE_AC3_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272620, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_ADPCM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_ALAW: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(6, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_ANALOG: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1840918928, 26557, 4559, [160, 247, 0, 32, 175, 209, 86, 228]);
pub const KSDATAFORMAT_SUBTYPE_CC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(857820353, 287, 4562, [180, 177, 0, 160, 209, 2, 207, 190]);
pub const KSDATAFORMAT_SUBTYPE_D16: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(80, 4, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_DRM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(9, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_DSS_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2695843714, 57699, 4560, [186, 217, 0, 96, 151, 68, 17, 26]);
pub const KSDATAFORMAT_SUBTYPE_DSS_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2695843713, 57699, 4560, [186, 217, 0, 96, 151, 68, 17, 26]);
pub const KSDATAFORMAT_SUBTYPE_DTS_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272627, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_AAC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(6, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_ATRAC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(8, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(146, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(10, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS_ATMOS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(266, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT20: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(268, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT21: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(780, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MLP: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(12, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DST: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(13, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(8, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(267, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(779, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_DTS_HD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(11, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_MPEG1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_MPEG2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_MPEG3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(5, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_ONE_BIT_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(9, 3306, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IEC61937_WMA_PRO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(356, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_IMAGE_RGB32: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(22, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_JPEG: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(434415018, 22114, 20421, [160, 192, 23, 88, 2, 142, 16, 87]);
pub const KSDATAFORMAT_SUBTYPE_L16: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(81, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_L16_CUSTOM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(81, 32768, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_L16_IR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(81, 2, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_L8: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(50, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_L8_CUSTOM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(50, 32768, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_L8_IR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(50, 2, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_LPCM_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272626, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_Line21_BytePair: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1854753314, 12556, 4560, [183, 154, 0, 170, 0, 55, 103, 167]);
pub const KSDATAFORMAT_SUBTYPE_Line21_GOPPacket: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1854753315, 12556, 4560, [183, 154, 0, 170, 0, 55, 103, 167]);
pub const KSDATAFORMAT_SUBTYPE_MIDI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(489039712, 59735, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSDATAFORMAT_SUBTYPE_MIDI_BUS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(748773280, 27902, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1196444237, 32768, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MJPG_DEPTH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1196444237, 4, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MJPG_IR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1196444237, 2, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MPEG: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(80, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MPEG1Packet: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804480, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_MPEG1Payload: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804481, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_MPEG1Video: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804486, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272619, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272614, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_MPEGLAYER3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(85, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MPEG_HEAAC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(5648, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_MULAW: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(7, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_NABTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4146755298, 60170, 4560, [172, 228, 0, 0, 192, 204, 22, 186]);
pub const KSDATAFORMAT_SUBTYPE_NABTS_FEC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3881286817, 14764, 4561, [169, 245, 0, 192, 79, 187, 222, 143]);
pub const KSDATAFORMAT_SUBTYPE_NONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804494, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_OVERLAY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804479, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_RAW8: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3391150496, 15934, 4561, [155, 249, 0, 192, 79, 187, 222, 191]);
pub const KSDATAFORMAT_SUBTYPE_RIFF: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1234557678, 40678, 4560, [164, 14, 0, 160, 201, 34, 49, 150]);
pub const KSDATAFORMAT_SUBTYPE_RIFFMIDI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1234557680, 40678, 4560, [164, 14, 0, 160, 201, 34, 49, 150]);
pub const KSDATAFORMAT_SUBTYPE_RIFFWAVE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804491, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_SUBTYPE_SDDS_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272628, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358757, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358754, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358753, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358756, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358755, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_SUBTYPE_SUBPICTURE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272621, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_SUBTYPE_TELETEXT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4146755299, 60170, 4560, [172, 228, 0, 0, 192, 204, 22, 186]);
pub const KSDATAFORMAT_SUBTYPE_VPVBI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1520134721, 6690, 4561, [186, 217, 0, 96, 151, 68, 17, 26]);
pub const KSDATAFORMAT_SUBTYPE_VPVideo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1520134720, 6690, 4561, [186, 217, 0, 96, 151, 68, 17, 26]);
pub const KSDATAFORMAT_SUBTYPE_WMAUDIO2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(353, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_WMAUDIO3: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(354, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_SUBTYPE_WMAUDIO_LOSSLESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(355, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_TYPE_ANALOGAUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(75685601, 30743, 4559, [138, 3, 0, 170, 0, 110, 203, 101]);
pub const KSDATAFORMAT_TYPE_ANALOGVIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(75685345, 30743, 4559, [138, 3, 0, 170, 0, 110, 203, 101]);
pub const KSDATAFORMAT_TYPE_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1935963489, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_TYPE_AUXLine21Data: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1728768640, 14978, 4560, [183, 155, 0, 170, 0, 55, 103, 167]);
pub const KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3976958314, 1101, 4561, [170, 120, 0, 192, 79, 195, 29, 96]);
pub const KSDATAFORMAT_TYPE_IMAGE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1914145827, 58459, 4565, [188, 42, 0, 176, 208, 243, 244, 171]);
pub const KSDATAFORMAT_TYPE_MIDI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1935960429, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_TYPE_MPEG2_PES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272608, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_TYPE_MPEG2_PROGRAM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272610, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_TYPE_MPEG2_TRANSPORT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3765272611, 56134, 4559, [180, 209, 0, 128, 95, 108, 187, 234]);
pub const KSDATAFORMAT_TYPE_MUSIC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3878015840, 25292, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSDATAFORMAT_TYPE_NABTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3881286816, 14764, 4561, [169, 245, 0, 192, 79, 187, 222, 143]);
pub const KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358737, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358739, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_TYPE_STANDARD_PES_PACKET: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911358738, 36581, 4561, [140, 163, 0, 96, 176, 87, 102, 74]);
pub const KSDATAFORMAT_TYPE_STREAM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804483, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
pub const KSDATAFORMAT_TYPE_TEXT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1937012852, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
pub const KSDATAFORMAT_TYPE_VBI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4146755297, 60170, 4560, [172, 228, 0, 0, 192, 204, 22, 186]);
pub const KSDATAFORMAT_TYPE_VIDEO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1935960438, 0, 16, [128, 0, 0, 170, 0, 56, 155, 113]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
pub struct KSDATAFORMAT_WAVEFORMATEX {
    pub DataFormat: KSDATAFORMAT,
    pub WaveFormatEx: super::super::Multimedia::WAVEFORMATEX,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl KSDATAFORMAT_WAVEFORMATEX {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for KSDATAFORMAT_WAVEFORMATEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for KSDATAFORMAT_WAVEFORMATEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for KSDATAFORMAT_WAVEFORMATEX {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for KSDATAFORMAT_WAVEFORMATEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
pub struct KSDATAFORMAT_WAVEFORMATEXTENSIBLE {
    pub DataFormat: KSDATAFORMAT,
    pub WaveFormatExt: super::super::Multimedia::WAVEFORMATEXTENSIBLE,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl KSDATAFORMAT_WAVEFORMATEXTENSIBLE {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for KSDATAFORMAT_WAVEFORMATEXTENSIBLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for KSDATAFORMAT_WAVEFORMATEXTENSIBLE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for KSDATAFORMAT_WAVEFORMATEXTENSIBLE {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for KSDATAFORMAT_WAVEFORMATEXTENSIBLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDATARANGE_AUDIO {
    pub DataRange: KSDATAFORMAT,
    pub MaximumChannels: u32,
    pub MinimumBitsPerSample: u32,
    pub MaximumBitsPerSample: u32,
    pub MinimumSampleFrequency: u32,
    pub MaximumSampleFrequency: u32,
}
impl KSDATARANGE_AUDIO {}
impl ::std::default::Default for KSDATARANGE_AUDIO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDATARANGE_AUDIO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDATARANGE_AUDIO {}
unsafe impl ::windows::runtime::Abi for KSDATARANGE_AUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDATARANGE_BIT_ATTRIBUTES: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDATARANGE_BIT_REQUIRED_ATTRIBUTES: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDATARANGE_MUSIC {
    pub DataRange: KSDATAFORMAT,
    pub Technology: ::windows::runtime::GUID,
    pub Channels: u32,
    pub Notes: u32,
    pub ChannelMask: u32,
}
impl KSDATARANGE_MUSIC {}
impl ::std::default::Default for KSDATARANGE_MUSIC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDATARANGE_MUSIC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDATARANGE_MUSIC {}
unsafe impl ::windows::runtime::Abi for KSDATARANGE_MUSIC {
    type Abi = Self;
}
pub const KSDEGRADESETID_Standard: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2673230208, 28748, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDEGRADE_STANDARD(pub i32);
pub const KSDEGRADE_STANDARD_SAMPLE: KSDEGRADE_STANDARD = KSDEGRADE_STANDARD(0i32);
pub const KSDEGRADE_STANDARD_QUALITY: KSDEGRADE_STANDARD = KSDEGRADE_STANDARD(1i32);
pub const KSDEGRADE_STANDARD_COMPUTATION: KSDEGRADE_STANDARD = KSDEGRADE_STANDARD(2i32);
pub const KSDEGRADE_STANDARD_SKIP: KSDEGRADE_STANDARD = KSDEGRADE_STANDARD(3i32);
impl ::std::convert::From<i32> for KSDEGRADE_STANDARD {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDEGRADE_STANDARD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_DESCRIPTOR_VERSION: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_DESCRIPTOR_VERSION_2: u32 = 272u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_FLAG_ENABLE_QUERYINTERFACE: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_FLAG_ENABLE_REMOTE_WAKEUP: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_FLAG_LOWPOWER_PASSTHROUGH: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDEVICE_PROFILE_INFO {
    pub Type: u32,
    pub Size: u32,
    pub Anonymous: KSDEVICE_PROFILE_INFO_0,
}
impl KSDEVICE_PROFILE_INFO {}
impl ::std::default::Default for KSDEVICE_PROFILE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDEVICE_PROFILE_INFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDEVICE_PROFILE_INFO {}
unsafe impl ::windows::runtime::Abi for KSDEVICE_PROFILE_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSDEVICE_PROFILE_INFO_0 {
    pub Camera: KSDEVICE_PROFILE_INFO_0_0,
}
impl KSDEVICE_PROFILE_INFO_0 {}
impl ::std::default::Default for KSDEVICE_PROFILE_INFO_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDEVICE_PROFILE_INFO_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDEVICE_PROFILE_INFO_0 {}
unsafe impl ::windows::runtime::Abi for KSDEVICE_PROFILE_INFO_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDEVICE_PROFILE_INFO_0_0 {
    pub Info: KSCAMERA_PROFILE_INFO,
    pub Reserved: u32,
    pub ConcurrencyCount: u32,
    pub Concurrency: *mut KSCAMERA_PROFILE_CONCURRENCYINFO,
}
impl KSDEVICE_PROFILE_INFO_0_0 {}
impl ::std::default::Default for KSDEVICE_PROFILE_INFO_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDEVICE_PROFILE_INFO_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Camera_e__Struct").field("Info", &self.Info).field("Reserved", &self.Reserved).field("ConcurrencyCount", &self.ConcurrencyCount).field("Concurrency", &self.Concurrency).finish()
    }
}
impl ::std::cmp::PartialEq for KSDEVICE_PROFILE_INFO_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Info == other.Info && self.Reserved == other.Reserved && self.ConcurrencyCount == other.ConcurrencyCount && self.Concurrency == other.Concurrency
    }
}
impl ::std::cmp::Eq for KSDEVICE_PROFILE_INFO_0_0 {}
unsafe impl ::windows::runtime::Abi for KSDEVICE_PROFILE_INFO_0_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_PROFILE_TYPE_CAMERA: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDEVICE_PROFILE_TYPE_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDEVICE_THERMAL_STATE(pub i32);
pub const KSDEVICE_THERMAL_STATE_LOW: KSDEVICE_THERMAL_STATE = KSDEVICE_THERMAL_STATE(0i32);
pub const KSDEVICE_THERMAL_STATE_HIGH: KSDEVICE_THERMAL_STATE = KSDEVICE_THERMAL_STATE(1i32);
impl ::std::convert::From<i32> for KSDEVICE_THERMAL_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDEVICE_THERMAL_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDISPATCH_FASTIO: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDISPLAYCHANGE {
    pub PelsWidth: u32,
    pub PelsHeight: u32,
    pub BitsPerPel: u32,
    pub DeviceID: [u16; 1],
}
impl KSDISPLAYCHANGE {}
impl ::std::default::Default for KSDISPLAYCHANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDISPLAYCHANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDISPLAYCHANGE").field("PelsWidth", &self.PelsWidth).field("PelsHeight", &self.PelsHeight).field("BitsPerPel", &self.BitsPerPel).field("DeviceID", &self.DeviceID).finish()
    }
}
impl ::std::cmp::PartialEq for KSDISPLAYCHANGE {
    fn eq(&self, other: &Self) -> bool {
        self.PelsWidth == other.PelsWidth && self.PelsHeight == other.PelsHeight && self.BitsPerPel == other.BitsPerPel && self.DeviceID == other.DeviceID
    }
}
impl ::std::cmp::Eq for KSDISPLAYCHANGE {}
unsafe impl ::windows::runtime::Abi for KSDISPLAYCHANGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_BUFFER_ALL {
    pub Position: DS3DVECTOR,
    pub Velocity: DS3DVECTOR,
    pub InsideConeAngle: u32,
    pub OutsideConeAngle: u32,
    pub ConeOrientation: DS3DVECTOR,
    pub ConeOutsideVolume: i32,
    pub MinDistance: f32,
    pub MaxDistance: f32,
    pub Mode: u32,
}
impl KSDS3D_BUFFER_ALL {}
impl ::std::default::Default for KSDS3D_BUFFER_ALL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDS3D_BUFFER_ALL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDS3D_BUFFER_ALL {}
unsafe impl ::windows::runtime::Abi for KSDS3D_BUFFER_ALL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_BUFFER_CONE_ANGLES {
    pub InsideConeAngle: u32,
    pub OutsideConeAngle: u32,
}
impl KSDS3D_BUFFER_CONE_ANGLES {}
impl ::std::default::Default for KSDS3D_BUFFER_CONE_ANGLES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDS3D_BUFFER_CONE_ANGLES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_BUFFER_CONE_ANGLES").field("InsideConeAngle", &self.InsideConeAngle).field("OutsideConeAngle", &self.OutsideConeAngle).finish()
    }
}
impl ::std::cmp::PartialEq for KSDS3D_BUFFER_CONE_ANGLES {
    fn eq(&self, other: &Self) -> bool {
        self.InsideConeAngle == other.InsideConeAngle && self.OutsideConeAngle == other.OutsideConeAngle
    }
}
impl ::std::cmp::Eq for KSDS3D_BUFFER_CONE_ANGLES {}
unsafe impl ::windows::runtime::Abi for KSDS3D_BUFFER_CONE_ANGLES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDS3D_HRTF_COEFF_FORMAT(pub i32);
pub const FLOAT_COEFF: KSDS3D_HRTF_COEFF_FORMAT = KSDS3D_HRTF_COEFF_FORMAT(0i32);
pub const SHORT_COEFF: KSDS3D_HRTF_COEFF_FORMAT = KSDS3D_HRTF_COEFF_FORMAT(1i32);
pub const KSDS3D_COEFF_COUNT: KSDS3D_HRTF_COEFF_FORMAT = KSDS3D_HRTF_COEFF_FORMAT(2i32);
impl ::std::convert::From<i32> for KSDS3D_HRTF_COEFF_FORMAT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_COEFF_FORMAT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_HRTF_FILTER_FORMAT_MSG {
    pub FilterMethod: KSDS3D_HRTF_FILTER_METHOD,
    pub CoeffFormat: KSDS3D_HRTF_COEFF_FORMAT,
    pub Version: KSDS3D_HRTF_FILTER_VERSION,
    pub Reserved: u32,
}
impl KSDS3D_HRTF_FILTER_FORMAT_MSG {}
impl ::std::default::Default for KSDS3D_HRTF_FILTER_FORMAT_MSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDS3D_HRTF_FILTER_FORMAT_MSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_HRTF_FILTER_FORMAT_MSG").field("FilterMethod", &self.FilterMethod).field("CoeffFormat", &self.CoeffFormat).field("Version", &self.Version).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSDS3D_HRTF_FILTER_FORMAT_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.FilterMethod == other.FilterMethod && self.CoeffFormat == other.CoeffFormat && self.Version == other.Version && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSDS3D_HRTF_FILTER_FORMAT_MSG {}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_FILTER_FORMAT_MSG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDS3D_HRTF_FILTER_METHOD(pub i32);
pub const DIRECT_FORM: KSDS3D_HRTF_FILTER_METHOD = KSDS3D_HRTF_FILTER_METHOD(0i32);
pub const CASCADE_FORM: KSDS3D_HRTF_FILTER_METHOD = KSDS3D_HRTF_FILTER_METHOD(1i32);
pub const KSDS3D_FILTER_METHOD_COUNT: KSDS3D_HRTF_FILTER_METHOD = KSDS3D_HRTF_FILTER_METHOD(2i32);
impl ::std::convert::From<i32> for KSDS3D_HRTF_FILTER_METHOD {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_FILTER_METHOD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDS3D_HRTF_FILTER_QUALITY(pub i32);
pub const FULL_FILTER: KSDS3D_HRTF_FILTER_QUALITY = KSDS3D_HRTF_FILTER_QUALITY(0i32);
pub const LIGHT_FILTER: KSDS3D_HRTF_FILTER_QUALITY = KSDS3D_HRTF_FILTER_QUALITY(1i32);
pub const KSDS3D_FILTER_QUALITY_COUNT: KSDS3D_HRTF_FILTER_QUALITY = KSDS3D_HRTF_FILTER_QUALITY(2i32);
impl ::std::convert::From<i32> for KSDS3D_HRTF_FILTER_QUALITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_FILTER_QUALITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSDS3D_HRTF_FILTER_VERSION(pub i32);
pub const DS3D_HRTF_VERSION_1: KSDS3D_HRTF_FILTER_VERSION = KSDS3D_HRTF_FILTER_VERSION(0i32);
impl ::std::convert::From<i32> for KSDS3D_HRTF_FILTER_VERSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_FILTER_VERSION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_HRTF_INIT_MSG {
    pub Size: u32,
    pub Quality: KSDS3D_HRTF_FILTER_QUALITY,
    pub SampleRate: f32,
    pub MaxFilterSize: u32,
    pub FilterTransientMuteLength: u32,
    pub FilterOverlapBufferLength: u32,
    pub OutputOverlapBufferLength: u32,
    pub Reserved: u32,
}
impl KSDS3D_HRTF_INIT_MSG {}
impl ::std::default::Default for KSDS3D_HRTF_INIT_MSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDS3D_HRTF_INIT_MSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_HRTF_INIT_MSG")
            .field("Size", &self.Size)
            .field("Quality", &self.Quality)
            .field("SampleRate", &self.SampleRate)
            .field("MaxFilterSize", &self.MaxFilterSize)
            .field("FilterTransientMuteLength", &self.FilterTransientMuteLength)
            .field("FilterOverlapBufferLength", &self.FilterOverlapBufferLength)
            .field("OutputOverlapBufferLength", &self.OutputOverlapBufferLength)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSDS3D_HRTF_INIT_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Quality == other.Quality && self.SampleRate == other.SampleRate && self.MaxFilterSize == other.MaxFilterSize && self.FilterTransientMuteLength == other.FilterTransientMuteLength && self.FilterOverlapBufferLength == other.FilterOverlapBufferLength && self.OutputOverlapBufferLength == other.OutputOverlapBufferLength && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSDS3D_HRTF_INIT_MSG {}
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_INIT_MSG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSDS3D_HRTF_PARAMS_MSG {
    pub Size: u32,
    pub Enabled: u32,
    pub SwapChannels: super::super::super::Foundation::BOOL,
    pub ZeroAzimuth: super::super::super::Foundation::BOOL,
    pub CrossFadeOutput: super::super::super::Foundation::BOOL,
    pub FilterSize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSDS3D_HRTF_PARAMS_MSG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSDS3D_HRTF_PARAMS_MSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSDS3D_HRTF_PARAMS_MSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_HRTF_PARAMS_MSG").field("Size", &self.Size).field("Enabled", &self.Enabled).field("SwapChannels", &self.SwapChannels).field("ZeroAzimuth", &self.ZeroAzimuth).field("CrossFadeOutput", &self.CrossFadeOutput).field("FilterSize", &self.FilterSize).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSDS3D_HRTF_PARAMS_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Enabled == other.Enabled && self.SwapChannels == other.SwapChannels && self.ZeroAzimuth == other.ZeroAzimuth && self.CrossFadeOutput == other.CrossFadeOutput && self.FilterSize == other.FilterSize
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSDS3D_HRTF_PARAMS_MSG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSDS3D_HRTF_PARAMS_MSG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_ITD_PARAMS {
    pub Channel: i32,
    pub VolSmoothScale: f32,
    pub TotalDryAttenuation: f32,
    pub TotalWetAttenuation: f32,
    pub SmoothFrequency: i32,
    pub Delay: i32,
}
impl KSDS3D_ITD_PARAMS {}
impl ::std::default::Default for KSDS3D_ITD_PARAMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDS3D_ITD_PARAMS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_ITD_PARAMS")
            .field("Channel", &self.Channel)
            .field("VolSmoothScale", &self.VolSmoothScale)
            .field("TotalDryAttenuation", &self.TotalDryAttenuation)
            .field("TotalWetAttenuation", &self.TotalWetAttenuation)
            .field("SmoothFrequency", &self.SmoothFrequency)
            .field("Delay", &self.Delay)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSDS3D_ITD_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.Channel == other.Channel && self.VolSmoothScale == other.VolSmoothScale && self.TotalDryAttenuation == other.TotalDryAttenuation && self.TotalWetAttenuation == other.TotalWetAttenuation && self.SmoothFrequency == other.SmoothFrequency && self.Delay == other.Delay
    }
}
impl ::std::cmp::Eq for KSDS3D_ITD_PARAMS {}
unsafe impl ::windows::runtime::Abi for KSDS3D_ITD_PARAMS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_ITD_PARAMS_MSG {
    pub Enabled: u32,
    pub LeftParams: KSDS3D_ITD_PARAMS,
    pub RightParams: KSDS3D_ITD_PARAMS,
    pub Reserved: u32,
}
impl KSDS3D_ITD_PARAMS_MSG {}
impl ::std::default::Default for KSDS3D_ITD_PARAMS_MSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSDS3D_ITD_PARAMS_MSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSDS3D_ITD_PARAMS_MSG").field("Enabled", &self.Enabled).field("LeftParams", &self.LeftParams).field("RightParams", &self.RightParams).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSDS3D_ITD_PARAMS_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.Enabled == other.Enabled && self.LeftParams == other.LeftParams && self.RightParams == other.RightParams && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSDS3D_ITD_PARAMS_MSG {}
unsafe impl ::windows::runtime::Abi for KSDS3D_ITD_PARAMS_MSG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_LISTENER_ALL {
    pub Position: DS3DVECTOR,
    pub Velocity: DS3DVECTOR,
    pub OrientFront: DS3DVECTOR,
    pub OrientTop: DS3DVECTOR,
    pub DistanceFactor: f32,
    pub RolloffFactor: f32,
    pub DopplerFactor: f32,
}
impl KSDS3D_LISTENER_ALL {}
impl ::std::default::Default for KSDS3D_LISTENER_ALL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDS3D_LISTENER_ALL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDS3D_LISTENER_ALL {}
unsafe impl ::windows::runtime::Abi for KSDS3D_LISTENER_ALL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSDS3D_LISTENER_ORIENTATION {
    pub Front: DS3DVECTOR,
    pub Top: DS3DVECTOR,
}
impl KSDS3D_LISTENER_ORIENTATION {}
impl ::std::default::Default for KSDS3D_LISTENER_ORIENTATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSDS3D_LISTENER_ORIENTATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSDS3D_LISTENER_ORIENTATION {}
unsafe impl ::windows::runtime::Abi for KSDS3D_LISTENER_ORIENTATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_3D_MODE_DISABLE: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_3D_MODE_HEADRELATIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_3D_MODE_NORMAL: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Media_Multimedia`*"]
pub struct KSDSOUND_BUFFERDESC {
    pub Flags: u32,
    pub Control: u32,
    pub WaveFormatEx: super::super::Multimedia::WAVEFORMATEX,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl KSDSOUND_BUFFERDESC {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for KSDSOUND_BUFFERDESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for KSDSOUND_BUFFERDESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for KSDSOUND_BUFFERDESC {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for KSDSOUND_BUFFERDESC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_3D: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_FREQUENCY: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_HRTF_3D: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_PAN: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_CTRL_VOLUME: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_LOCHARDWARE: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_LOCSOFTWARE: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_PRIMARY: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSDSOUND_BUFFER_STATIC: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSERROR {
    pub Context: *mut ::std::ffi::c_void,
    pub Status: u32,
}
impl KSERROR {}
impl ::std::default::Default for KSERROR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSERROR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSERROR").field("Context", &self.Context).field("Status", &self.Status).finish()
    }
}
impl ::std::cmp::PartialEq for KSERROR {
    fn eq(&self, other: &Self) -> bool {
        self.Context == other.Context && self.Status == other.Status
    }
}
impl ::std::cmp::Eq for KSERROR {}
unsafe impl ::windows::runtime::Abi for KSERROR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSEVENTDATA {
    pub NotificationType: u32,
    pub Anonymous: KSEVENTDATA_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENTDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENTDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENTDATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENTDATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENTDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union KSEVENTDATA_0 {
    pub EventHandle: KSEVENTDATA_0_1,
    pub SemaphoreHandle: KSEVENTDATA_0_2,
    pub Alignment: KSEVENTDATA_0_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENTDATA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENTDATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENTDATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENTDATA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENTDATA_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSEVENTDATA_0_0 {
    pub Unused: *mut ::std::ffi::c_void,
    pub Alignment: [isize; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENTDATA_0_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENTDATA_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSEVENTDATA_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Alignment_e__Struct").field("Unused", &self.Unused).field("Alignment", &self.Alignment).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENTDATA_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Unused == other.Unused && self.Alignment == other.Alignment
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENTDATA_0_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENTDATA_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSEVENTDATA_0_1 {
    pub Event: super::super::super::Foundation::HANDLE,
    pub Reserved: [usize; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENTDATA_0_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENTDATA_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSEVENTDATA_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_EventHandle_e__Struct").field("Event", &self.Event).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENTDATA_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.Event == other.Event && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENTDATA_0_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENTDATA_0_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSEVENTDATA_0_2 {
    pub Semaphore: super::super::super::Foundation::HANDLE,
    pub Reserved: u32,
    pub Adjustment: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENTDATA_0_2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENTDATA_0_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSEVENTDATA_0_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_SemaphoreHandle_e__Struct").field("Semaphore", &self.Semaphore).field("Reserved", &self.Reserved).field("Adjustment", &self.Adjustment).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENTDATA_0_2 {
    fn eq(&self, other: &Self) -> bool {
        self.Semaphore == other.Semaphore && self.Reserved == other.Reserved && self.Adjustment == other.Adjustment
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENTDATA_0_2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENTDATA_0_2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_DPC: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_EVENT_HANDLE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_EVENT_OBJECT: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_KSWORKITEM: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_SEMAPHORE_HANDLE: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_SEMAPHORE_OBJECT: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENTF_WORKITEM: u32 = 32u32;
pub const KSEVENTSETID_AudioControlChange: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3898513048, 64047, 4561, [149, 189, 0, 192, 79, 185, 37, 211]);
pub const KSEVENTSETID_CameraAsyncControl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(580982612, 38657, 16520, [179, 63, 107, 156, 188, 82, 223, 94]);
pub const KSEVENTSETID_CameraEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2023338720, 27459, 18788, [157, 42, 162, 31, 64, 97, 245, 118]);
pub const KSEVENTSETID_Clock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(911052320, 25287, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSEVENTSETID_Connection: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2135673824, 40613, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSEVENTSETID_Device: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(679646956, 40852, 16820, [161, 83, 170, 49, 174, 236, 179, 63]);
pub const KSEVENTSETID_DynamicFormatChange: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(371901526, 33751, 16953, [150, 223, 199, 95, 250, 19, 139, 198]);
pub const KSEVENTSETID_EXTDEV_Command: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(278690184, 46027, 4562, [180, 142, 0, 96, 151, 179, 57, 27]);
pub const KSEVENTSETID_ExtendedCameraControl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1461490377, 5026, 18403, [166, 73, 210, 167, 120, 22, 99, 132]);
pub const KSEVENTSETID_LoopedStreaming: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1182972224, 50927, 4560, [150, 216, 0, 170, 0, 81, 229, 29]);
pub const KSEVENTSETID_PinCapsChange: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3712948526, 15224, 18861, [165, 52, 44, 49, 91, 130, 32, 0]);
pub const KSEVENTSETID_SoundDetector: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1769495707, 64557, 18902, [172, 50, 71, 153, 248, 125, 233, 246]);
pub const KSEVENTSETID_StreamAllocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1977177457, 1852, 4560, [161, 97, 0, 32, 175, 209, 86, 228]);
pub const KSEVENTSETID_Telephony: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3078558388, 52916, 17540, [141, 94, 82, 193, 231, 216, 118, 45]);
pub const KSEVENTSETID_VIDCAPTOSTI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3678920224, 63016, 4561, [186, 65, 0, 160, 201, 13, 43, 5]);
pub const KSEVENTSETID_VIDCAP_TVAUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1781401169, 10468, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
pub const KSEVENTSETID_VPNotify: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(549804430, 54216, 4560, [141, 252, 0, 192, 79, 215, 192, 139]);
pub const KSEVENTSETID_VPVBINotify: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3964836609, 6687, 4561, [186, 217, 0, 96, 151, 68, 17, 26]);
pub const KSEVENTSETID_VolumeLimit: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3658908773, 14972, 18520, [157, 74, 62, 142, 36, 112, 26, 239]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_AUDIO_CONTROL_CHANGE(pub i32);
pub const KSEVENT_CONTROL_CHANGE: KSEVENT_AUDIO_CONTROL_CHANGE = KSEVENT_AUDIO_CONTROL_CHANGE(0i32);
impl ::std::convert::From<i32> for KSEVENT_AUDIO_CONTROL_CHANGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_AUDIO_CONTROL_CHANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_CAMERACONTROL(pub i32);
pub const KSEVENT_CAMERACONTROL_FOCUS: KSEVENT_CAMERACONTROL = KSEVENT_CAMERACONTROL(0i32);
pub const KSEVENT_CAMERACONTROL_ZOOM: KSEVENT_CAMERACONTROL = KSEVENT_CAMERACONTROL(1i32);
impl ::std::convert::From<i32> for KSEVENT_CAMERACONTROL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_CAMERACONTROL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_CAMERAEVENT(pub i32);
pub const KSEVENT_PHOTO_SAMPLE_SCANNED: KSEVENT_CAMERAEVENT = KSEVENT_CAMERAEVENT(0i32);
impl ::std::convert::From<i32> for KSEVENT_CAMERAEVENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_CAMERAEVENT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_CLOCK_POSITION(pub i32);
pub const KSEVENT_CLOCK_INTERVAL_MARK: KSEVENT_CLOCK_POSITION = KSEVENT_CLOCK_POSITION(0i32);
pub const KSEVENT_CLOCK_POSITION_MARK: KSEVENT_CLOCK_POSITION = KSEVENT_CLOCK_POSITION(1i32);
impl ::std::convert::From<i32> for KSEVENT_CLOCK_POSITION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_CLOCK_POSITION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_CONNECTION(pub i32);
pub const KSEVENT_CONNECTION_POSITIONUPDATE: KSEVENT_CONNECTION = KSEVENT_CONNECTION(0i32);
pub const KSEVENT_CONNECTION_DATADISCONTINUITY: KSEVENT_CONNECTION = KSEVENT_CONNECTION(1i32);
pub const KSEVENT_CONNECTION_TIMEDISCONTINUITY: KSEVENT_CONNECTION = KSEVENT_CONNECTION(2i32);
pub const KSEVENT_CONNECTION_PRIORITY: KSEVENT_CONNECTION = KSEVENT_CONNECTION(3i32);
pub const KSEVENT_CONNECTION_ENDOFSTREAM: KSEVENT_CONNECTION = KSEVENT_CONNECTION(4i32);
impl ::std::convert::From<i32> for KSEVENT_CONNECTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_CONNECTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_CROSSBAR(pub i32);
pub const KSEVENT_CROSSBAR_CHANGED: KSEVENT_CROSSBAR = KSEVENT_CROSSBAR(0i32);
impl ::std::convert::From<i32> for KSEVENT_CROSSBAR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_CROSSBAR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_DEVCMD(pub i32);
pub const KSEVENT_EXTDEV_COMMAND_NOTIFY_INTERIM_READY: KSEVENT_DEVCMD = KSEVENT_DEVCMD(0i32);
pub const KSEVENT_EXTDEV_COMMAND_CONTROL_INTERIM_READY: KSEVENT_DEVCMD = KSEVENT_DEVCMD(1i32);
pub const KSEVENT_EXTDEV_COMMAND_BUSRESET: KSEVENT_DEVCMD = KSEVENT_DEVCMD(2i32);
pub const KSEVENT_EXTDEV_TIMECODE_UPDATE: KSEVENT_DEVCMD = KSEVENT_DEVCMD(3i32);
pub const KSEVENT_EXTDEV_OPERATION_MODE_UPDATE: KSEVENT_DEVCMD = KSEVENT_DEVCMD(4i32);
pub const KSEVENT_EXTDEV_TRANSPORT_STATE_UPDATE: KSEVENT_DEVCMD = KSEVENT_DEVCMD(5i32);
pub const KSEVENT_EXTDEV_NOTIFY_REMOVAL: KSEVENT_DEVCMD = KSEVENT_DEVCMD(6i32);
pub const KSEVENT_EXTDEV_NOTIFY_MEDIUM_CHANGE: KSEVENT_DEVCMD = KSEVENT_DEVCMD(7i32);
impl ::std::convert::From<i32> for KSEVENT_DEVCMD {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_DEVCMD {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_DEVICE(pub i32);
pub const KSEVENT_DEVICE_LOST: KSEVENT_DEVICE = KSEVENT_DEVICE(0i32);
pub const KSEVENT_DEVICE_PREEMPTED: KSEVENT_DEVICE = KSEVENT_DEVICE(1i32);
pub const KSEVENT_DEVICE_THERMAL_HIGH: KSEVENT_DEVICE = KSEVENT_DEVICE(2i32);
pub const KSEVENT_DEVICE_THERMAL_LOW: KSEVENT_DEVICE = KSEVENT_DEVICE(3i32);
impl ::std::convert::From<i32> for KSEVENT_DEVICE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_DEVICE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_DYNAMICFORMATCHANGE(pub i32);
pub const KSEVENT_DYNAMIC_FORMAT_CHANGE: KSEVENT_DYNAMICFORMATCHANGE = KSEVENT_DYNAMICFORMATCHANGE(0i32);
impl ::std::convert::From<i32> for KSEVENT_DYNAMICFORMATCHANGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_DYNAMICFORMATCHANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_ENTRY_BUFFERED: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_ENTRY_DELETED: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_ENTRY_ONESHOT: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_LOOPEDSTREAMING(pub i32);
pub const KSEVENT_LOOPEDSTREAMING_POSITION: KSEVENT_LOOPEDSTREAMING = KSEVENT_LOOPEDSTREAMING(0i32);
impl ::std::convert::From<i32> for KSEVENT_LOOPEDSTREAMING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_LOOPEDSTREAMING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_PINCAPS_CHANGENOTIFICATIONS(pub i32);
pub const KSEVENT_PINCAPS_FORMATCHANGE: KSEVENT_PINCAPS_CHANGENOTIFICATIONS = KSEVENT_PINCAPS_CHANGENOTIFICATIONS(0i32);
pub const KSEVENT_PINCAPS_JACKINFOCHANGE: KSEVENT_PINCAPS_CHANGENOTIFICATIONS = KSEVENT_PINCAPS_CHANGENOTIFICATIONS(1i32);
impl ::std::convert::From<i32> for KSEVENT_PINCAPS_CHANGENOTIFICATIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_PINCAPS_CHANGENOTIFICATIONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_SOUNDDETECTOR(pub i32);
pub const KSEVENT_SOUNDDETECTOR_MATCHDETECTED: KSEVENT_SOUNDDETECTOR = KSEVENT_SOUNDDETECTOR(1i32);
impl ::std::convert::From<i32> for KSEVENT_SOUNDDETECTOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_SOUNDDETECTOR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_STREAMALLOCATOR(pub i32);
pub const KSEVENT_STREAMALLOCATOR_INTERNAL_FREEFRAME: KSEVENT_STREAMALLOCATOR = KSEVENT_STREAMALLOCATOR(0i32);
pub const KSEVENT_STREAMALLOCATOR_FREEFRAME: KSEVENT_STREAMALLOCATOR = KSEVENT_STREAMALLOCATOR(1i32);
impl ::std::convert::From<i32> for KSEVENT_STREAMALLOCATOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_STREAMALLOCATOR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_TELEPHONY(pub i32);
pub const KSEVENT_TELEPHONY_ENDPOINTPAIRS_CHANGED: KSEVENT_TELEPHONY = KSEVENT_TELEPHONY(0i32);
impl ::std::convert::From<i32> for KSEVENT_TELEPHONY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_TELEPHONY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSEVENT_TIME_INTERVAL {
    pub EventData: KSEVENTDATA,
    pub TimeBase: i64,
    pub Interval: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENT_TIME_INTERVAL {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENT_TIME_INTERVAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENT_TIME_INTERVAL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENT_TIME_INTERVAL {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENT_TIME_INTERVAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSEVENT_TIME_MARK {
    pub EventData: KSEVENTDATA,
    pub MarkTime: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENT_TIME_MARK {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENT_TIME_MARK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENT_TIME_MARK {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENT_TIME_MARK {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENT_TIME_MARK {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_TUNER(pub i32);
pub const KSEVENT_TUNER_CHANGED: KSEVENT_TUNER = KSEVENT_TUNER(0i32);
pub const KSEVENT_TUNER_INITIATE_SCAN: KSEVENT_TUNER = KSEVENT_TUNER(1i32);
impl ::std::convert::From<i32> for KSEVENT_TUNER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_TUNER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSEVENT_TUNER_INITIATE_SCAN_S {
    pub EventData: KSEVENTDATA,
    pub StartFrequency: u32,
    pub EndFrequency: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSEVENT_TUNER_INITIATE_SCAN_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSEVENT_TUNER_INITIATE_SCAN_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSEVENT_TUNER_INITIATE_SCAN_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSEVENT_TUNER_INITIATE_SCAN_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSEVENT_TUNER_INITIATE_SCAN_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_TVAUDIO(pub i32);
pub const KSEVENT_TVAUDIO_CHANGED: KSEVENT_TVAUDIO = KSEVENT_TVAUDIO(0i32);
impl ::std::convert::From<i32> for KSEVENT_TVAUDIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_TVAUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_BASICSUPPORT: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_ENABLE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_ENABLEBUFFERED: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_ONESHOT: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_QUERYBUFFER: u32 = 1024u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_SETSUPPORT: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSEVENT_TYPE_TOPOLOGY: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_VIDCAPTOSTI(pub i32);
pub const KSEVENT_VIDCAPTOSTI_EXT_TRIGGER: KSEVENT_VIDCAPTOSTI = KSEVENT_VIDCAPTOSTI(0i32);
pub const KSEVENT_VIDCAP_AUTO_UPDATE: KSEVENT_VIDCAPTOSTI = KSEVENT_VIDCAPTOSTI(1i32);
pub const KSEVENT_VIDCAP_SEARCH: KSEVENT_VIDCAPTOSTI = KSEVENT_VIDCAPTOSTI(2i32);
impl ::std::convert::From<i32> for KSEVENT_VIDCAPTOSTI {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_VIDCAPTOSTI {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_VIDEODECODER(pub i32);
pub const KSEVENT_VIDEODECODER_CHANGED: KSEVENT_VIDEODECODER = KSEVENT_VIDEODECODER(0i32);
impl ::std::convert::From<i32> for KSEVENT_VIDEODECODER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_VIDEODECODER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_VOLUMELIMIT(pub i32);
pub const KSEVENT_VOLUMELIMIT_CHANGED: KSEVENT_VOLUMELIMIT = KSEVENT_VOLUMELIMIT(0i32);
impl ::std::convert::From<i32> for KSEVENT_VOLUMELIMIT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_VOLUMELIMIT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_VPNOTIFY(pub i32);
pub const KSEVENT_VPNOTIFY_FORMATCHANGE: KSEVENT_VPNOTIFY = KSEVENT_VPNOTIFY(0i32);
impl ::std::convert::From<i32> for KSEVENT_VPNOTIFY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_VPNOTIFY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSEVENT_VPVBINOTIFY(pub i32);
pub const KSEVENT_VPVBINOTIFY_FORMATCHANGE: KSEVENT_VPVBINOTIFY = KSEVENT_VPVBINOTIFY(0i32);
impl ::std::convert::From<i32> for KSEVENT_VPVBINOTIFY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSEVENT_VPVBINOTIFY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSE_NODE {
    pub Event: KSIDENTIFIER,
    pub NodeId: u32,
    pub Reserved: u32,
}
impl KSE_NODE {}
impl ::std::default::Default for KSE_NODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSE_NODE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSE_NODE {}
unsafe impl ::windows::runtime::Abi for KSE_NODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSE_PIN {
    pub Event: KSIDENTIFIER,
    pub PinId: u32,
    pub Reserved: u32,
}
impl KSE_PIN {}
impl ::std::default::Default for KSE_PIN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSE_PIN {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSE_PIN {}
unsafe impl ::windows::runtime::Abi for KSE_PIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_CRITICAL_PROCESSING: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_DENY_USERMODE_ACCESS: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_DISPATCH_LEVEL_PROCESSING: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_HYPERCRITICAL_PROCESSING: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_PRIORITIZE_REFERENCEGUID: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFILTER_FLAG_RECEIVE_ZERO_LENGTH_SAMPLES: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSFRAMETIME {
    pub Duration: i64,
    pub FrameFlags: u32,
    pub Reserved: u32,
}
impl KSFRAMETIME {}
impl ::std::default::Default for KSFRAMETIME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSFRAMETIME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSFRAMETIME").field("Duration", &self.Duration).field("FrameFlags", &self.FrameFlags).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for KSFRAMETIME {
    fn eq(&self, other: &Self) -> bool {
        self.Duration == other.Duration && self.FrameFlags == other.FrameFlags && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for KSFRAMETIME {}
unsafe impl ::windows::runtime::Abi for KSFRAMETIME {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSFRAMETIME_VARIABLESIZE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSGOP_USERDATA {
    pub sc: u32,
    pub reserved1: u32,
    pub cFields: u8,
    pub l21Data: [super::super::super::Foundation::CHAR; 3],
}
#[cfg(feature = "Win32_Foundation")]
impl KSGOP_USERDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSGOP_USERDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSGOP_USERDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSGOP_USERDATA").field("sc", &self.sc).field("reserved1", &self.reserved1).field("cFields", &self.cFields).field("l21Data", &self.l21Data).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSGOP_USERDATA {
    fn eq(&self, other: &Self) -> bool {
        self.sc == other.sc && self.reserved1 == other.reserved1 && self.cFields == other.cFields && self.l21Data == other.l21Data
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSGOP_USERDATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSGOP_USERDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSIDENTIFIER {
    pub Anonymous: KSIDENTIFIER_0,
}
impl KSIDENTIFIER {}
impl ::std::default::Default for KSIDENTIFIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSIDENTIFIER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSIDENTIFIER {}
unsafe impl ::windows::runtime::Abi for KSIDENTIFIER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSIDENTIFIER_0 {
    pub Anonymous: KSIDENTIFIER_0_0,
    pub Alignment: i64,
}
impl KSIDENTIFIER_0 {}
impl ::std::default::Default for KSIDENTIFIER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSIDENTIFIER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSIDENTIFIER_0 {}
unsafe impl ::windows::runtime::Abi for KSIDENTIFIER_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSIDENTIFIER_0_0 {
    pub Set: ::windows::runtime::GUID,
    pub Id: u32,
    pub Flags: u32,
}
impl KSIDENTIFIER_0_0 {}
impl ::std::default::Default for KSIDENTIFIER_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSIDENTIFIER_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct").field("Set", &self.Set).field("Id", &self.Id).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for KSIDENTIFIER_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.Set == other.Set && self.Id == other.Id && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for KSIDENTIFIER_0_0 {}
unsafe impl ::windows::runtime::Abi for KSIDENTIFIER_0_0 {
    type Abi = Self;
}
pub const KSINTERFACESETID_FileIo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2356122412, 59249, 4560, [184, 255, 0, 160, 201, 34, 49, 150]);
pub const KSINTERFACESETID_Media: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(974383936, 12455, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSINTERFACESETID_Standard: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(445081248, 25294, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSINTERFACE_FILEIO(pub i32);
pub const KSINTERFACE_FILEIO_STREAMING: KSINTERFACE_FILEIO = KSINTERFACE_FILEIO(0i32);
impl ::std::convert::From<i32> for KSINTERFACE_FILEIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSINTERFACE_FILEIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSINTERFACE_MEDIA(pub i32);
pub const KSINTERFACE_MEDIA_MUSIC: KSINTERFACE_MEDIA = KSINTERFACE_MEDIA(0i32);
pub const KSINTERFACE_MEDIA_WAVE_BUFFERED: KSINTERFACE_MEDIA = KSINTERFACE_MEDIA(1i32);
pub const KSINTERFACE_MEDIA_WAVE_QUEUED: KSINTERFACE_MEDIA = KSINTERFACE_MEDIA(2i32);
impl ::std::convert::From<i32> for KSINTERFACE_MEDIA {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSINTERFACE_MEDIA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSINTERFACE_STANDARD(pub i32);
pub const KSINTERFACE_STANDARD_STREAMING: KSINTERFACE_STANDARD = KSINTERFACE_STANDARD(0i32);
pub const KSINTERFACE_STANDARD_LOOPED_STREAMING: KSINTERFACE_STANDARD = KSINTERFACE_STANDARD(1i32);
pub const KSINTERFACE_STANDARD_CONTROL: KSINTERFACE_STANDARD = KSINTERFACE_STANDARD(2i32);
impl ::std::convert::From<i32> for KSINTERFACE_STANDARD {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSINTERFACE_STANDARD {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSINTERVAL {
    pub TimeBase: i64,
    pub Interval: i64,
}
impl KSINTERVAL {}
impl ::std::default::Default for KSINTERVAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSINTERVAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSINTERVAL").field("TimeBase", &self.TimeBase).field("Interval", &self.Interval).finish()
    }
}
impl ::std::cmp::PartialEq for KSINTERVAL {
    fn eq(&self, other: &Self) -> bool {
        self.TimeBase == other.TimeBase && self.Interval == other.Interval
    }
}
impl ::std::cmp::Eq for KSINTERVAL {}
unsafe impl ::windows::runtime::Abi for KSINTERVAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSJACK_DESCRIPTION {
    pub ChannelMapping: u32,
    pub Color: u32,
    pub ConnectionType: EPcxConnectionType,
    pub GeoLocation: EPcxGeoLocation,
    pub GenLocation: EPcxGenLocation,
    pub PortConnection: EPxcPortConnection,
    pub IsConnected: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSJACK_DESCRIPTION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSJACK_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSJACK_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSJACK_DESCRIPTION")
            .field("ChannelMapping", &self.ChannelMapping)
            .field("Color", &self.Color)
            .field("ConnectionType", &self.ConnectionType)
            .field("GeoLocation", &self.GeoLocation)
            .field("GenLocation", &self.GenLocation)
            .field("PortConnection", &self.PortConnection)
            .field("IsConnected", &self.IsConnected)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSJACK_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.ChannelMapping == other.ChannelMapping && self.Color == other.Color && self.ConnectionType == other.ConnectionType && self.GeoLocation == other.GeoLocation && self.GenLocation == other.GenLocation && self.PortConnection == other.PortConnection && self.IsConnected == other.IsConnected
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSJACK_DESCRIPTION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSJACK_DESCRIPTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSJACK_DESCRIPTION2 {
    pub DeviceStateInfo: u32,
    pub JackCapabilities: u32,
}
impl KSJACK_DESCRIPTION2 {}
impl ::std::default::Default for KSJACK_DESCRIPTION2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSJACK_DESCRIPTION2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSJACK_DESCRIPTION2").field("DeviceStateInfo", &self.DeviceStateInfo).field("JackCapabilities", &self.JackCapabilities).finish()
    }
}
impl ::std::cmp::PartialEq for KSJACK_DESCRIPTION2 {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceStateInfo == other.DeviceStateInfo && self.JackCapabilities == other.JackCapabilities
    }
}
impl ::std::cmp::Eq for KSJACK_DESCRIPTION2 {}
unsafe impl ::windows::runtime::Abi for KSJACK_DESCRIPTION2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSJACK_SINK_CONNECTIONTYPE(pub i32);
pub const KSJACK_SINK_CONNECTIONTYPE_HDMI: KSJACK_SINK_CONNECTIONTYPE = KSJACK_SINK_CONNECTIONTYPE(0i32);
pub const KSJACK_SINK_CONNECTIONTYPE_DISPLAYPORT: KSJACK_SINK_CONNECTIONTYPE = KSJACK_SINK_CONNECTIONTYPE(1i32);
impl ::std::convert::From<i32> for KSJACK_SINK_CONNECTIONTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSJACK_SINK_CONNECTIONTYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSJACK_SINK_INFORMATION {
    pub ConnType: KSJACK_SINK_CONNECTIONTYPE,
    pub ManufacturerId: u16,
    pub ProductId: u16,
    pub AudioLatency: u16,
    pub HDCPCapable: super::super::super::Foundation::BOOL,
    pub AICapable: super::super::super::Foundation::BOOL,
    pub SinkDescriptionLength: u8,
    pub SinkDescription: [u16; 32],
    pub PortId: super::super::super::Foundation::LUID,
}
#[cfg(feature = "Win32_Foundation")]
impl KSJACK_SINK_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSJACK_SINK_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSJACK_SINK_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSJACK_SINK_INFORMATION")
            .field("ConnType", &self.ConnType)
            .field("ManufacturerId", &self.ManufacturerId)
            .field("ProductId", &self.ProductId)
            .field("AudioLatency", &self.AudioLatency)
            .field("HDCPCapable", &self.HDCPCapable)
            .field("AICapable", &self.AICapable)
            .field("SinkDescriptionLength", &self.SinkDescriptionLength)
            .field("SinkDescription", &self.SinkDescription)
            .field("PortId", &self.PortId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSJACK_SINK_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.ConnType == other.ConnType && self.ManufacturerId == other.ManufacturerId && self.ProductId == other.ProductId && self.AudioLatency == other.AudioLatency && self.HDCPCapable == other.HDCPCapable && self.AICapable == other.AICapable && self.SinkDescriptionLength == other.SinkDescriptionLength && self.SinkDescription == other.SinkDescription && self.PortId == other.PortId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSJACK_SINK_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSJACK_SINK_INFORMATION {
    type Abi = Self;
}
pub const KSMEDIUMSETID_MidiBus: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(93356096, 12870, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSMEDIUMSETID_Standard: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1195881248, 25294, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSMEDIUMSETID_VPBus: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2710312428, 52803, 4560, [171, 231, 0, 160, 201, 34, 49, 150]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMEDIUM_STANDARD_DEVIO: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMEDIUM_TYPE_ANYINSTANCE: u32 = 0u32;
pub const KSMEMORY_TYPE_DEVICE_UNKNOWN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(152811065, 24639, 4561, [176, 103, 0, 160, 201, 6, 40, 2]);
pub const KSMEMORY_TYPE_KERNEL_NONPAGED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1248681924, 30869, 4561, [176, 105, 0, 160, 201, 6, 40, 2]);
pub const KSMEMORY_TYPE_KERNEL_PAGED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3627284728, 30868, 4561, [176, 105, 0, 160, 201, 6, 40, 2]);
pub const KSMEMORY_TYPE_SYSTEM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(152811064, 24639, 4561, [176, 103, 0, 160, 201, 6, 40, 2]);
pub const KSMEMORY_TYPE_USER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2360409128, 30867, 4561, [176, 105, 0, 160, 201, 6, 40, 2]);
pub const KSMETHODSETID_StreamAllocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3480109889, 60551, 4559, [161, 48, 0, 32, 175, 209, 86, 228]);
pub const KSMETHODSETID_StreamIo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1708131274, 5411, 4562, [178, 122, 0, 160, 201, 34, 49, 150]);
pub const KSMETHODSETID_Wavetable: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3706663403, 55559, 4560, [149, 131, 0, 192, 79, 185, 37, 211]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSMETHOD_STREAMALLOCATOR(pub i32);
pub const KSMETHOD_STREAMALLOCATOR_ALLOC: KSMETHOD_STREAMALLOCATOR = KSMETHOD_STREAMALLOCATOR(0i32);
pub const KSMETHOD_STREAMALLOCATOR_FREE: KSMETHOD_STREAMALLOCATOR = KSMETHOD_STREAMALLOCATOR(1i32);
impl ::std::convert::From<i32> for KSMETHOD_STREAMALLOCATOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSMETHOD_STREAMALLOCATOR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSMETHOD_STREAMIO(pub i32);
pub const KSMETHOD_STREAMIO_READ: KSMETHOD_STREAMIO = KSMETHOD_STREAMIO(0i32);
pub const KSMETHOD_STREAMIO_WRITE: KSMETHOD_STREAMIO = KSMETHOD_STREAMIO(1i32);
impl ::std::convert::From<i32> for KSMETHOD_STREAMIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSMETHOD_STREAMIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_BASICSUPPORT: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_MODIFY: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_READ: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_SEND: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_SETSUPPORT: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_SOURCE: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_TOPOLOGY: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_TYPE_WRITE: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSMETHOD_WAVETABLE(pub i32);
pub const KSMETHOD_WAVETABLE_WAVE_ALLOC: KSMETHOD_WAVETABLE = KSMETHOD_WAVETABLE(0i32);
pub const KSMETHOD_WAVETABLE_WAVE_FREE: KSMETHOD_WAVETABLE = KSMETHOD_WAVETABLE(1i32);
pub const KSMETHOD_WAVETABLE_WAVE_FIND: KSMETHOD_WAVETABLE = KSMETHOD_WAVETABLE(2i32);
pub const KSMETHOD_WAVETABLE_WAVE_WRITE: KSMETHOD_WAVETABLE = KSMETHOD_WAVETABLE(3i32);
impl ::std::convert::From<i32> for KSMETHOD_WAVETABLE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSMETHOD_WAVETABLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMETHOD_WAVE_QUEUED_BREAKLOOP: u32 = 1u32;
pub const KSMFT_CATEGORY_AUDIO_DECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2661760948, 61306, 17753, [141, 93, 113, 157, 143, 4, 38, 199]);
pub const KSMFT_CATEGORY_AUDIO_EFFECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(285625416, 13896, 20176, [147, 46, 5, 206, 138, 200, 17, 183]);
pub const KSMFT_CATEGORY_AUDIO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2445691856, 63774, 19852, [146, 118, 219, 36, 130, 121, 217, 117]);
pub const KSMFT_CATEGORY_DEMULTIPLEXER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2825915002, 37787, 17605, [153, 215, 118, 34, 107, 35, 179, 241]);
pub const KSMFT_CATEGORY_MULTIPLEXER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(94131742, 1454, 19297, [182, 157, 85, 182, 30, 229, 74, 123]);
pub const KSMFT_CATEGORY_OTHER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2417450327, 47082, 18689, [174, 179, 147, 58, 135, 71, 117, 111]);
pub const KSMFT_CATEGORY_VIDEO_DECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3602918731, 26675, 17844, [151, 26, 5, 164, 176, 75, 171, 145]);
pub const KSMFT_CATEGORY_VIDEO_EFFECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(316767265, 21292, 19054, [138, 28, 64, 130, 90, 115, 99, 151]);
pub const KSMFT_CATEGORY_VIDEO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4154371197, 58693, 17287, [189, 238, 214, 71, 215, 189, 228, 42]);
pub const KSMFT_CATEGORY_VIDEO_PROCESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(808363004, 43615, 18425, [159, 122, 194, 24, 139, 177, 99, 2]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSMICARRAY_MICARRAYTYPE(pub i32);
pub const KSMICARRAY_MICARRAYTYPE_LINEAR: KSMICARRAY_MICARRAYTYPE = KSMICARRAY_MICARRAYTYPE(0i32);
pub const KSMICARRAY_MICARRAYTYPE_PLANAR: KSMICARRAY_MICARRAYTYPE = KSMICARRAY_MICARRAYTYPE(1i32);
pub const KSMICARRAY_MICARRAYTYPE_3D: KSMICARRAY_MICARRAYTYPE = KSMICARRAY_MICARRAYTYPE(2i32);
impl ::std::convert::From<i32> for KSMICARRAY_MICARRAYTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSMICARRAY_MICARRAYTYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSMICARRAY_MICTYPE(pub i32);
pub const KSMICARRAY_MICTYPE_OMNIDIRECTIONAL: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(0i32);
pub const KSMICARRAY_MICTYPE_SUBCARDIOID: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(1i32);
pub const KSMICARRAY_MICTYPE_CARDIOID: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(2i32);
pub const KSMICARRAY_MICTYPE_SUPERCARDIOID: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(3i32);
pub const KSMICARRAY_MICTYPE_HYPERCARDIOID: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(4i32);
pub const KSMICARRAY_MICTYPE_8SHAPED: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(5i32);
pub const KSMICARRAY_MICTYPE_VENDORDEFINED: KSMICARRAY_MICTYPE = KSMICARRAY_MICTYPE(15i32);
impl ::std::convert::From<i32> for KSMICARRAY_MICTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSMICARRAY_MICTYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMPEGVIDMODE_LTRBOX: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMPEGVIDMODE_PANSCAN: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSMPEGVIDMODE_SCALE: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSMPEGVID_RECT {
    pub StartX: u32,
    pub StartY: u32,
    pub EndX: u32,
    pub EndY: u32,
}
impl KSMPEGVID_RECT {}
impl ::std::default::Default for KSMPEGVID_RECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSMPEGVID_RECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSMPEGVID_RECT").field("StartX", &self.StartX).field("StartY", &self.StartY).field("EndX", &self.EndX).field("EndY", &self.EndY).finish()
    }
}
impl ::std::cmp::PartialEq for KSMPEGVID_RECT {
    fn eq(&self, other: &Self) -> bool {
        self.StartX == other.StartX && self.StartY == other.StartY && self.EndX == other.EndX && self.EndY == other.EndY
    }
}
impl ::std::cmp::Eq for KSMPEGVID_RECT {}
unsafe impl ::windows::runtime::Abi for KSMPEGVID_RECT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSMULTIPLE_DATA_PROP {
    pub Property: KSIDENTIFIER,
    pub MultipleItem: KSMULTIPLE_ITEM,
}
impl KSMULTIPLE_DATA_PROP {}
impl ::std::default::Default for KSMULTIPLE_DATA_PROP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSMULTIPLE_DATA_PROP {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSMULTIPLE_DATA_PROP {}
unsafe impl ::windows::runtime::Abi for KSMULTIPLE_DATA_PROP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSMULTIPLE_ITEM {
    pub Size: u32,
    pub Count: u32,
}
impl KSMULTIPLE_ITEM {}
impl ::std::default::Default for KSMULTIPLE_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSMULTIPLE_ITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSMULTIPLE_ITEM").field("Size", &self.Size).field("Count", &self.Count).finish()
    }
}
impl ::std::cmp::PartialEq for KSMULTIPLE_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for KSMULTIPLE_ITEM {}
unsafe impl ::windows::runtime::Abi for KSMULTIPLE_ITEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSMUSICFORMAT {
    pub TimeDeltaMs: u32,
    pub ByteCount: u32,
}
impl KSMUSICFORMAT {}
impl ::std::default::Default for KSMUSICFORMAT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSMUSICFORMAT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSMUSICFORMAT").field("TimeDeltaMs", &self.TimeDeltaMs).field("ByteCount", &self.ByteCount).finish()
    }
}
impl ::std::cmp::PartialEq for KSMUSICFORMAT {
    fn eq(&self, other: &Self) -> bool {
        self.TimeDeltaMs == other.TimeDeltaMs && self.ByteCount == other.ByteCount
    }
}
impl ::std::cmp::Eq for KSMUSICFORMAT {}
unsafe impl ::windows::runtime::Abi for KSMUSICFORMAT {
    type Abi = Self;
}
pub const KSMUSIC_TECHNOLOGY_FMSYNTH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(623664256, 25321, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSMUSIC_TECHNOLOGY_PORT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2261331552, 25320, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSMUSIC_TECHNOLOGY_SQSYNTH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(248464256, 25321, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSMUSIC_TECHNOLOGY_SWSYNTH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(926971702, 13856, 4561, [133, 211, 0, 0, 248, 117, 67, 128]);
pub const KSMUSIC_TECHNOLOGY_WAVETABLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(961464256, 25321, 4559, [165, 214, 40, 219, 4, 193, 0, 0]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSM_NODE {
    pub Method: KSIDENTIFIER,
    pub NodeId: u32,
    pub Reserved: u32,
}
impl KSM_NODE {}
impl ::std::default::Default for KSM_NODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSM_NODE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSM_NODE {}
unsafe impl ::windows::runtime::Abi for KSM_NODE {
    type Abi = Self;
}
pub const KSNAME_Allocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1680825600, 18321, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSNAME_Clock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1394025600, 18321, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSNAME_Filter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2604030096, 5727, 4560, [161, 149, 0, 32, 175, 209, 86, 228]);
pub const KSNAME_Pin: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(342825600, 18321, 4560, [165, 214, 40, 219, 4, 193, 0, 0]);
pub const KSNAME_TopologyNode: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(102827546, 61045, 4560, [185, 21, 0, 160, 201, 34, 49, 150]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_AEC_CAPTURE_IN: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_AEC_CAPTURE_OUT: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_AEC_RENDER_IN: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_AEC_RENDER_OUT: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_DEMUX_IN: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_DEMUX_OUT: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_STANDARD_IN: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_STANDARD_OUT: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_SUM_MUX_IN: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSNODEPIN_SUM_MUX_OUT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY {
    pub Property: KSIDENTIFIER,
    pub NodeId: u32,
    pub Reserved: u32,
}
impl KSNODEPROPERTY {}
impl ::std::default::Default for KSNODEPROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSNODEPROPERTY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSNODEPROPERTY {}
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_3D_LISTENER {
    pub NodeProperty: KSNODEPROPERTY,
    pub ListenerId: *mut ::std::ffi::c_void,
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl KSNODEPROPERTY_AUDIO_3D_LISTENER {}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_3D_LISTENER {}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86",))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_3D_LISTENER {
    pub NodeProperty: KSNODEPROPERTY,
    pub ListenerId: *mut ::std::ffi::c_void,
    pub Reserved: u32,
}
#[cfg(any(target_arch = "x86",))]
impl KSNODEPROPERTY_AUDIO_3D_LISTENER {}
#[cfg(any(target_arch = "x86",))]
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_3D_LISTENER {}
#[cfg(any(target_arch = "x86",))]
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_3D_LISTENER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_CHANNEL {
    pub NodeProperty: KSNODEPROPERTY,
    pub Channel: i32,
    pub Reserved: u32,
}
impl KSNODEPROPERTY_AUDIO_CHANNEL {}
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_CHANNEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_CHANNEL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_CHANNEL {}
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_CHANNEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {
    pub NodeProperty: KSNODEPROPERTY,
    pub DevSpecificId: u32,
    pub DeviceInfo: u32,
    pub Length: u32,
}
impl KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {}
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {}
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_DEV_SPECIFIC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_PROPERTY {
    pub NodeProperty: KSNODEPROPERTY,
    pub AppContext: *mut ::std::ffi::c_void,
    pub Length: u32,
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl KSNODEPROPERTY_AUDIO_PROPERTY {}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_PROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_PROPERTY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_PROPERTY {}
#[cfg(any(target_arch = "x86_64", target_arch = "aarch64",))]
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_PROPERTY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(any(target_arch = "x86",))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODEPROPERTY_AUDIO_PROPERTY {
    pub NodeProperty: KSNODEPROPERTY,
    pub AppContext: *mut ::std::ffi::c_void,
    pub Length: u32,
    pub Reserved: u32,
}
#[cfg(any(target_arch = "x86",))]
impl KSNODEPROPERTY_AUDIO_PROPERTY {}
#[cfg(any(target_arch = "x86",))]
impl ::std::default::Default for KSNODEPROPERTY_AUDIO_PROPERTY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::PartialEq for KSNODEPROPERTY_AUDIO_PROPERTY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(any(target_arch = "x86",))]
impl ::std::cmp::Eq for KSNODEPROPERTY_AUDIO_PROPERTY {}
#[cfg(any(target_arch = "x86",))]
unsafe impl ::windows::runtime::Abi for KSNODEPROPERTY_AUDIO_PROPERTY {
    type Abi = Self;
}
pub const KSNODETYPE_1394_DA_STREAM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187046, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_1394_DV_STREAM_SOUNDTRACK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187047, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_3D_EFFECTS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1431394400, 50521, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_ADC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1300463584, 50517, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_AGC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3901528992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_ANALOG_CONNECTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187041, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_ANALOG_TAPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187303, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_AUDIO_ENGINE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(902493924, 62387, 16744, [187, 75, 85, 231, 122, 70, 28, 126]);
pub const KSNODETYPE_AUDIO_KEYWORDDETECTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(941088952, 57176, 17269, [182, 105, 196, 150, 52, 51, 31, 157]);
pub const KSNODETYPE_AUDIO_LOOPBACK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2403516594, 37326, 19407, [156, 205, 14, 89, 144, 55, 171, 53]);
pub const KSNODETYPE_AUDIO_MODULE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1168815150, 51947, 16466, [138, 169, 179, 140, 181, 16, 150, 25]);
pub const KSNODETYPE_BIDIRECTIONAL_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186528, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_CABLE_TUNER_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187310, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_CD_PLAYER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187299, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_CHORUS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(538394400, 50521, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_COMMUNICATION_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186278, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DAC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1350230880, 50516, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187300, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187301, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DELAY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(340361696, 50520, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_DEMUX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3236653012, 59399, 4560, [149, 138, 0, 192, 79, 185, 37, 211]);
pub const KSNODETYPE_DESKTOP_MICROPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186018, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DESKTOP_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186276, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DEV_SPECIFIC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2484894400, 50521, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_DIGITAL_AUDIO_INTERFACE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187042, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DISPLAYPORT_INTERFACE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3833479217, 16038, 16781, [143, 155, 183, 56, 67, 204, 186, 151]);
pub const KSNODETYPE_DOWN_LINE_PHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186787, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DRM_DESCRAMBLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4290473535, 52478, 19844, [144, 217, 66, 20, 24, 176, 58, 142]);
pub const KSNODETYPE_DSS_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187311, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DVD_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187307, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_DYN_RANGE_COMPRESSOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(147367592, 24607, 19192, [135, 147, 217, 5, 255, 76, 169, 125]);
pub const KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186533, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186532, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_EMBEDDED_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187296, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_EQUALIZATION_NOISE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187298, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_EQUALIZER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2638328992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_EXTERNAL_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187040, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_FM_RX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2202694460, 62597, 16832, [166, 43, 81, 48, 37, 1, 78, 64]);
pub const KSNODETYPE_HANDSET: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186529, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_HDMI_INTERFACE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3518614570, 62745, 16767, [145, 201, 85, 250, 101, 72, 16, 1]);
pub const KSNODETYPE_HEADPHONES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186274, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_HEADSET: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186530, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186275, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_INPUT_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186016, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_LEGACY_AUDIO_CONNECTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187044, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187297, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_LINE_CONNECTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187043, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_LOUDNESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1099461696, 50520, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186279, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_MICROPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186017, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_MICROPHONE_ARRAY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186021, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_MIDI_ELEMENT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(29818470, 28232, 19557, [172, 155, 82, 219, 93, 101, 108, 126]);
pub const KSNODETYPE_MIDI_JACK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(643697727, 64057, 19955, [171, 4, 190, 1, 185, 30, 41, 154]);
pub const KSNODETYPE_MINIDISK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187302, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_MULTITRACK_RECORDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187314, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_MUTE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(45228992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_MUX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(753596288, 50518, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_NOISE_SUPPRESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3766456383, 25341, 20064, [140, 221, 222, 167, 35, 102, 101, 181]);
pub const KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186020, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_OUTPUT_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186272, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_PARAMETRIC_EQUALIZER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(431700586, 52779, 17474, [135, 236, 103, 39, 195, 202, 180, 119]);
pub const KSNODETYPE_PEAKMETER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2693096734, 24333, 19254, [168, 105, 209, 149, 214, 171, 75, 158]);
pub const KSNODETYPE_PERSONAL_MICROPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186019, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_PHONE_LINE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186785, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_PHONOGRAPH: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187304, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_PROCESSING_MICROPHONE_ARRAY: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186022, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_PROLOGIC_DECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2199661696, 50520, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_PROLOGIC_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2155136434, 15462, 4562, [180, 90, 48, 120, 48, 44, 32, 48]);
pub const KSNODETYPE_RADIO_RECEIVER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187312, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_RADIO_TRANSMITTER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187313, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_REVERB: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4009961696, 50520, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_ROOM_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186277, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_SATELLITE_RECEIVER_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187309, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_SPDIF_INTERFACE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187045, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_SPEAKER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186273, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186531, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_SPEAKERS_STATIC_JACK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(685789063, 19902, 20365, [133, 137, 2, 93, 32, 157, 251, 74]);
pub const KSNODETYPE_SRC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2646063584, 50517, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_STEREO_WIDE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2850461696, 50520, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_SUM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3661896288, 50518, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_SUPERMIX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3849563584, 50517, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_SYNTHESIZER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187315, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_TELEPHONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186786, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_TELEPHONY_BIDI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1752005824, 55555, 16984, [180, 67, 58, 61, 53, 128, 116, 28]);
pub const KSNODETYPE_TELEPHONY_UNDEFINED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757186784, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_TONE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1980228992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const KSNODETYPE_TV_TUNER_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187308, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_UPDOWN_MIX: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3085813199, 31587, 20194, [161, 0, 41, 238, 44, 182, 178, 222]);
pub const KSNODETYPE_VCR_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187305, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_CAMERA_TERMINAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189606, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_DISC_AUDIO: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757187306, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_INPUT_MTT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189607, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_INPUT_TERMINAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189602, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_OUTPUT_MTT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189608, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_OUTPUT_TERMINAL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189603, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_PROCESSING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189605, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_SELECTOR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189604, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VIDEO_STREAMING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3757189601, 63247, 4560, [185, 23, 0, 160, 201, 34, 49, 150]);
pub const KSNODETYPE_VOLUME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(979028992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSNODE_CREATE {
    pub CreateFlags: u32,
    pub Node: u32,
}
impl KSNODE_CREATE {}
impl ::std::default::Default for KSNODE_CREATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSNODE_CREATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSNODE_CREATE").field("CreateFlags", &self.CreateFlags).field("Node", &self.Node).finish()
    }
}
impl ::std::cmp::PartialEq for KSNODE_CREATE {
    fn eq(&self, other: &Self) -> bool {
        self.CreateFlags == other.CreateFlags && self.Node == other.Node
    }
}
impl ::std::cmp::Eq for KSNODE_CREATE {}
unsafe impl ::windows::runtime::Abi for KSNODE_CREATE {
    type Abi = Self;
}
pub const KSNOTIFICATIONID_AudioModule: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2619482352, 55718, 19804, [160, 54, 87, 56, 87, 253, 80, 210]);
pub const KSNOTIFICATIONID_SoundDetector: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1669978180, 47922, 19532, [168, 2, 244, 180, 183, 122, 254, 173]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPIN_CINSTANCES {
    pub PossibleCount: u32,
    pub CurrentCount: u32,
}
impl KSPIN_CINSTANCES {}
impl ::std::default::Default for KSPIN_CINSTANCES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPIN_CINSTANCES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPIN_CINSTANCES").field("PossibleCount", &self.PossibleCount).field("CurrentCount", &self.CurrentCount).finish()
    }
}
impl ::std::cmp::PartialEq for KSPIN_CINSTANCES {
    fn eq(&self, other: &Self) -> bool {
        self.PossibleCount == other.PossibleCount && self.CurrentCount == other.CurrentCount
    }
}
impl ::std::cmp::Eq for KSPIN_CINSTANCES {}
unsafe impl ::windows::runtime::Abi for KSPIN_CINSTANCES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPIN_COMMUNICATION(pub i32);
pub const KSPIN_COMMUNICATION_NONE: KSPIN_COMMUNICATION = KSPIN_COMMUNICATION(0i32);
pub const KSPIN_COMMUNICATION_SINK: KSPIN_COMMUNICATION = KSPIN_COMMUNICATION(1i32);
pub const KSPIN_COMMUNICATION_SOURCE: KSPIN_COMMUNICATION = KSPIN_COMMUNICATION(2i32);
pub const KSPIN_COMMUNICATION_BOTH: KSPIN_COMMUNICATION = KSPIN_COMMUNICATION(3i32);
pub const KSPIN_COMMUNICATION_BRIDGE: KSPIN_COMMUNICATION = KSPIN_COMMUNICATION(4i32);
impl ::std::convert::From<i32> for KSPIN_COMMUNICATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPIN_COMMUNICATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPIN_CONNECT {
    pub Interface: KSIDENTIFIER,
    pub Medium: KSIDENTIFIER,
    pub PinId: u32,
    pub PinToHandle: super::super::super::Foundation::HANDLE,
    pub Priority: KSPRIORITY,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPIN_CONNECT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPIN_CONNECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPIN_CONNECT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPIN_CONNECT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPIN_CONNECT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPIN_DATAFLOW(pub i32);
pub const KSPIN_DATAFLOW_IN: KSPIN_DATAFLOW = KSPIN_DATAFLOW(1i32);
pub const KSPIN_DATAFLOW_OUT: KSPIN_DATAFLOW = KSPIN_DATAFLOW(2i32);
impl ::std::convert::From<i32> for KSPIN_DATAFLOW {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPIN_DATAFLOW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_ASYNCHRONOUS_PROCESSING: u32 = 8u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_CRITICAL_PROCESSING: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_DENY_USERMODE_ACCESS: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_DISPATCH_LEVEL_PROCESSING: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_DISTINCT_TRAILING_EDGE: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_DO_NOT_INITIATE_PROCESSING: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_DO_NOT_USE_STANDARD_TRANSPORT: u32 = 524288u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_ENFORCE_FIFO: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_FIXED_FORMAT: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_FRAMES_NOT_REQUIRED_FOR_PROCESSING: u32 = 64u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_GENERATE_EOS_EVENTS: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_GENERATE_MAPPINGS: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_HYPERCRITICAL_PROCESSING: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_IMPLEMENT_CLOCK: u32 = 4194304u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_INITIATE_PROCESSING_ON_EVERY_ARRIVAL: u32 = 32u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_PROCESS_IF_ANY_IN_RUN_STATE: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_PROCESS_IN_RUN_STATE_ONLY: u32 = 65536u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_SOME_FRAMES_REQUIRED_FOR_PROCESSING: u32 = 8388608u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_SPLITTER: u32 = 131072u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPIN_FLAG_USE_STANDARD_TRANSPORT: u32 = 262144u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPIN_MDL_CACHING_EVENT(pub i32);
pub const KSPIN_MDL_CACHING_NOTIFY_CLEANUP: KSPIN_MDL_CACHING_EVENT = KSPIN_MDL_CACHING_EVENT(0i32);
pub const KSPIN_MDL_CACHING_NOTIFY_CLEANALL_WAIT: KSPIN_MDL_CACHING_EVENT = KSPIN_MDL_CACHING_EVENT(1i32);
pub const KSPIN_MDL_CACHING_NOTIFY_CLEANALL_NOWAIT: KSPIN_MDL_CACHING_EVENT = KSPIN_MDL_CACHING_EVENT(2i32);
pub const KSPIN_MDL_CACHING_NOTIFY_ADDSAMPLE: KSPIN_MDL_CACHING_EVENT = KSPIN_MDL_CACHING_EVENT(3i32);
impl ::std::convert::From<i32> for KSPIN_MDL_CACHING_EVENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPIN_MDL_CACHING_EVENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPIN_MDL_CACHING_NOTIFICATION {
    pub Event: KSPIN_MDL_CACHING_EVENT,
    pub Buffer: *mut ::std::ffi::c_void,
}
impl KSPIN_MDL_CACHING_NOTIFICATION {}
impl ::std::default::Default for KSPIN_MDL_CACHING_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPIN_MDL_CACHING_NOTIFICATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPIN_MDL_CACHING_NOTIFICATION").field("Event", &self.Event).field("Buffer", &self.Buffer).finish()
    }
}
impl ::std::cmp::PartialEq for KSPIN_MDL_CACHING_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        self.Event == other.Event && self.Buffer == other.Buffer
    }
}
impl ::std::cmp::Eq for KSPIN_MDL_CACHING_NOTIFICATION {}
unsafe impl ::windows::runtime::Abi for KSPIN_MDL_CACHING_NOTIFICATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPIN_MDL_CACHING_NOTIFICATION32 {
    pub Event: KSPIN_MDL_CACHING_EVENT,
    pub Buffer: u32,
}
impl KSPIN_MDL_CACHING_NOTIFICATION32 {}
impl ::std::default::Default for KSPIN_MDL_CACHING_NOTIFICATION32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPIN_MDL_CACHING_NOTIFICATION32 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPIN_MDL_CACHING_NOTIFICATION32").field("Event", &self.Event).field("Buffer", &self.Buffer).finish()
    }
}
impl ::std::cmp::PartialEq for KSPIN_MDL_CACHING_NOTIFICATION32 {
    fn eq(&self, other: &Self) -> bool {
        self.Event == other.Event && self.Buffer == other.Buffer
    }
}
impl ::std::cmp::Eq for KSPIN_MDL_CACHING_NOTIFICATION32 {}
unsafe impl ::windows::runtime::Abi for KSPIN_MDL_CACHING_NOTIFICATION32 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPIN_PHYSICALCONNECTION {
    pub Size: u32,
    pub Pin: u32,
    pub SymbolicLinkName: [u16; 1],
}
impl KSPIN_PHYSICALCONNECTION {}
impl ::std::default::Default for KSPIN_PHYSICALCONNECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPIN_PHYSICALCONNECTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPIN_PHYSICALCONNECTION").field("Size", &self.Size).field("Pin", &self.Pin).field("SymbolicLinkName", &self.SymbolicLinkName).finish()
    }
}
impl ::std::cmp::PartialEq for KSPIN_PHYSICALCONNECTION {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Pin == other.Pin && self.SymbolicLinkName == other.SymbolicLinkName
    }
}
impl ::std::cmp::Eq for KSPIN_PHYSICALCONNECTION {}
unsafe impl ::windows::runtime::Abi for KSPIN_PHYSICALCONNECTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPPROPERTY_ALLOCATOR_MDLCACHING(pub i32);
pub const KSPROPERTY_ALLOCATOR_CLEANUP_CACHEDMDLPAGES: KSPPROPERTY_ALLOCATOR_MDLCACHING = KSPPROPERTY_ALLOCATOR_MDLCACHING(1i32);
impl ::std::convert::From<i32> for KSPPROPERTY_ALLOCATOR_MDLCACHING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPPROPERTY_ALLOCATOR_MDLCACHING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPRIORITY {
    pub PriorityClass: u32,
    pub PrioritySubClass: u32,
}
impl KSPRIORITY {}
impl ::std::default::Default for KSPRIORITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPRIORITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPRIORITY").field("PriorityClass", &self.PriorityClass).field("PrioritySubClass", &self.PrioritySubClass).finish()
    }
}
impl ::std::cmp::PartialEq for KSPRIORITY {
    fn eq(&self, other: &Self) -> bool {
        self.PriorityClass == other.PriorityClass && self.PrioritySubClass == other.PrioritySubClass
    }
}
impl ::std::cmp::Eq for KSPRIORITY {}
unsafe impl ::windows::runtime::Abi for KSPRIORITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPRIORITY_EXCLUSIVE: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPRIORITY_HIGH: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPRIORITY_LOW: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPRIORITY_NORMAL: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_ALLOCATEMDL: u32 = 16u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_ALLOWFORMATCHANGE: u32 = 128u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_MODIFY: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_PROBEANDLOCK: u32 = 32u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_STREAMREAD: u32 = 0u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_STREAMWRITE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROBE_SYSTEMADDRESS: u32 = 64u32;
pub const KSPROPERTYSETID_ExtendedCameraControl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(481792274, 49362, 16915, [156, 166, 205, 79, 219, 146, 121, 114]);
pub const KSPROPERTYSETID_NetworkCameraControl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(242749193, 22341, 20026, [188, 159, 242, 38, 234, 67, 166, 236]);
pub const KSPROPERTYSETID_PerFrameSettingControl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4059292257, 57062, 17719, [191, 245, 238, 32, 109, 181, 74, 172]);
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AC3(pub i32);
pub const KSPROPERTY_AC3_ERROR_CONCEALMENT: KSPROPERTY_AC3 = KSPROPERTY_AC3(1i32);
pub const KSPROPERTY_AC3_ALTERNATE_AUDIO: KSPROPERTY_AC3 = KSPROPERTY_AC3(2i32);
pub const KSPROPERTY_AC3_DOWNMIX: KSPROPERTY_AC3 = KSPROPERTY_AC3(3i32);
pub const KSPROPERTY_AC3_BIT_STREAM_MODE: KSPROPERTY_AC3 = KSPROPERTY_AC3(4i32);
pub const KSPROPERTY_AC3_DIALOGUE_LEVEL: KSPROPERTY_AC3 = KSPROPERTY_AC3(5i32);
pub const KSPROPERTY_AC3_LANGUAGE_CODE: KSPROPERTY_AC3 = KSPROPERTY_AC3(6i32);
pub const KSPROPERTY_AC3_ROOM_TYPE: KSPROPERTY_AC3 = KSPROPERTY_AC3(7i32);
impl ::std::convert::From<i32> for KSPROPERTY_AC3 {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AC3 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_ALLOCATOR_CONTROL(pub i32);
pub const KSPROPERTY_ALLOCATOR_CONTROL_HONOR_COUNT: KSPROPERTY_ALLOCATOR_CONTROL = KSPROPERTY_ALLOCATOR_CONTROL(0i32);
pub const KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE: KSPROPERTY_ALLOCATOR_CONTROL = KSPROPERTY_ALLOCATOR_CONTROL(1i32);
pub const KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS: KSPROPERTY_ALLOCATOR_CONTROL = KSPROPERTY_ALLOCATOR_CONTROL(2i32);
pub const KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE: KSPROPERTY_ALLOCATOR_CONTROL = KSPROPERTY_ALLOCATOR_CONTROL(3i32);
impl ::std::convert::From<i32> for KSPROPERTY_ALLOCATOR_CONTROL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_ALLOCATOR_CONTROL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {
    pub InterleavedCapSupported: u32,
}
impl KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S").field("InterleavedCapSupported", &self.InterleavedCapSupported).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {
    fn eq(&self, other: &Self) -> bool {
        self.InterleavedCapSupported == other.InterleavedCapSupported
    }
}
impl ::std::cmp::Eq for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {
    pub InterleavedCapPossible: u32,
}
impl KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {}
impl ::std::default::Default for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S").field("InterleavedCapPossible", &self.InterleavedCapPossible).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {
    fn eq(&self, other: &Self) -> bool {
        self.InterleavedCapPossible == other.InterleavedCapPossible
    }
}
impl ::std::cmp::Eq for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {
    pub CX: u32,
    pub CY: u32,
}
impl KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {}
impl ::std::default::Default for KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S").field("CX", &self.CX).field("CY", &self.CY).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {
    fn eq(&self, other: &Self) -> bool {
        self.CX == other.CX && self.CY == other.CY
    }
}
impl ::std::cmp::Eq for KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDDECOUT(pub i32);
pub const KSPROPERTY_AUDDECOUT_MODES: KSPROPERTY_AUDDECOUT = KSPROPERTY_AUDDECOUT(0i32);
pub const KSPROPERTY_AUDDECOUT_CUR_MODE: KSPROPERTY_AUDDECOUT = KSPROPERTY_AUDDECOUT(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDDECOUT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDDECOUT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIO(pub i32);
pub const KSPROPERTY_AUDIO_LATENCY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(1i32);
pub const KSPROPERTY_AUDIO_COPY_PROTECTION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(2i32);
pub const KSPROPERTY_AUDIO_CHANNEL_CONFIG: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(3i32);
pub const KSPROPERTY_AUDIO_VOLUMELEVEL: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(4i32);
pub const KSPROPERTY_AUDIO_POSITION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(5i32);
pub const KSPROPERTY_AUDIO_DYNAMIC_RANGE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(6i32);
pub const KSPROPERTY_AUDIO_QUALITY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(7i32);
pub const KSPROPERTY_AUDIO_SAMPLING_RATE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(8i32);
pub const KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(9i32);
pub const KSPROPERTY_AUDIO_MIX_LEVEL_TABLE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(10i32);
pub const KSPROPERTY_AUDIO_MIX_LEVEL_CAPS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(11i32);
pub const KSPROPERTY_AUDIO_MUX_SOURCE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(12i32);
pub const KSPROPERTY_AUDIO_MUTE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(13i32);
pub const KSPROPERTY_AUDIO_BASS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(14i32);
pub const KSPROPERTY_AUDIO_MID: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(15i32);
pub const KSPROPERTY_AUDIO_TREBLE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(16i32);
pub const KSPROPERTY_AUDIO_BASS_BOOST: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(17i32);
pub const KSPROPERTY_AUDIO_EQ_LEVEL: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(18i32);
pub const KSPROPERTY_AUDIO_NUM_EQ_BANDS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(19i32);
pub const KSPROPERTY_AUDIO_EQ_BANDS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(20i32);
pub const KSPROPERTY_AUDIO_AGC: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(21i32);
pub const KSPROPERTY_AUDIO_DELAY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(22i32);
pub const KSPROPERTY_AUDIO_LOUDNESS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(23i32);
pub const KSPROPERTY_AUDIO_WIDE_MODE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(24i32);
pub const KSPROPERTY_AUDIO_WIDENESS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(25i32);
pub const KSPROPERTY_AUDIO_REVERB_LEVEL: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(26i32);
pub const KSPROPERTY_AUDIO_CHORUS_LEVEL: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(27i32);
pub const KSPROPERTY_AUDIO_DEV_SPECIFIC: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(28i32);
pub const KSPROPERTY_AUDIO_DEMUX_DEST: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(29i32);
pub const KSPROPERTY_AUDIO_STEREO_ENHANCE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(30i32);
pub const KSPROPERTY_AUDIO_MANUFACTURE_GUID: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(31i32);
pub const KSPROPERTY_AUDIO_PRODUCT_GUID: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(32i32);
pub const KSPROPERTY_AUDIO_CPU_RESOURCES: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(33i32);
pub const KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(34i32);
pub const KSPROPERTY_AUDIO_SURROUND_ENCODE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(35i32);
pub const KSPROPERTY_AUDIO_3D_INTERFACE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(36i32);
pub const KSPROPERTY_AUDIO_PEAKMETER: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(37i32);
pub const KSPROPERTY_AUDIO_ALGORITHM_INSTANCE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(38i32);
pub const KSPROPERTY_AUDIO_FILTER_STATE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(39i32);
pub const KSPROPERTY_AUDIO_PREFERRED_STATUS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(40i32);
pub const KSPROPERTY_AUDIO_PEQ_MAX_BANDS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(41i32);
pub const KSPROPERTY_AUDIO_PEQ_NUM_BANDS: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(42i32);
pub const KSPROPERTY_AUDIO_PEQ_BAND_CENTER_FREQ: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(43i32);
pub const KSPROPERTY_AUDIO_PEQ_BAND_Q_FACTOR: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(44i32);
pub const KSPROPERTY_AUDIO_PEQ_BAND_LEVEL: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(45i32);
pub const KSPROPERTY_AUDIO_CHORUS_MODULATION_RATE: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(46i32);
pub const KSPROPERTY_AUDIO_CHORUS_MODULATION_DEPTH: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(47i32);
pub const KSPROPERTY_AUDIO_REVERB_TIME: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(48i32);
pub const KSPROPERTY_AUDIO_REVERB_DELAY_FEEDBACK: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(49i32);
pub const KSPROPERTY_AUDIO_POSITIONEX: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(50i32);
pub const KSPROPERTY_AUDIO_MIC_ARRAY_GEOMETRY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(51i32);
pub const KSPROPERTY_AUDIO_PRESENTATION_POSITION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(52i32);
pub const KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_POSITION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(53i32);
pub const KSPROPERTY_AUDIO_LINEAR_BUFFER_POSITION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(54i32);
pub const KSPROPERTY_AUDIO_PEAKMETER2: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(55i32);
pub const KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(56i32);
pub const KSPROPERTY_AUDIO_VOLUMELIMIT_ENGAGED: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(57i32);
pub const KSPROPERTY_AUDIO_MIC_SENSITIVITY: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(58i32);
pub const KSPROPERTY_AUDIO_MIC_SNR: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(59i32);
pub const KSPROPERTY_AUDIO_MIC_SENSITIVITY2: KSPROPERTY_AUDIO = KSPROPERTY_AUDIO(60i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIOENGINE(pub i32);
pub const KSPROPERTY_AUDIOENGINE_LFXENABLE: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(0i32);
pub const KSPROPERTY_AUDIOENGINE_GFXENABLE: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(1i32);
pub const KSPROPERTY_AUDIOENGINE_MIXFORMAT: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(2i32);
pub const KSPROPERTY_AUDIOENGINE_DEVICEFORMAT: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(4i32);
pub const KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(5i32);
pub const KSPROPERTY_AUDIOENGINE_DESCRIPTOR: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(6i32);
pub const KSPROPERTY_AUDIOENGINE_BUFFER_SIZE_RANGE: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(7i32);
pub const KSPROPERTY_AUDIOENGINE_LOOPBACK_PROTECTION: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(8i32);
pub const KSPROPERTY_AUDIOENGINE_VOLUMELEVEL: KSPROPERTY_AUDIOENGINE = KSPROPERTY_AUDIOENGINE(9i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIOENGINE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIOENGINE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIOMODULE(pub i32);
pub const KSPROPERTY_AUDIOMODULE_DESCRIPTORS: KSPROPERTY_AUDIOMODULE = KSPROPERTY_AUDIOMODULE(1i32);
pub const KSPROPERTY_AUDIOMODULE_COMMAND: KSPROPERTY_AUDIOMODULE = KSPROPERTY_AUDIOMODULE(2i32);
pub const KSPROPERTY_AUDIOMODULE_NOTIFICATION_DEVICE_ID: KSPROPERTY_AUDIOMODULE = KSPROPERTY_AUDIOMODULE(3i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIOMODULE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIOMODULE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIOPOSTURE(pub i32);
pub const KSPROPERTY_AUDIOPOSTURE_ORIENTATION: KSPROPERTY_AUDIOPOSTURE = KSPROPERTY_AUDIOPOSTURE(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIOPOSTURE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIOPOSTURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIORESOURCEMANAGEMENT(pub i32);
pub const KSPROPERTY_AUDIORESOURCEMANAGEMENT_RESOURCEGROUP: KSPROPERTY_AUDIORESOURCEMANAGEMENT = KSPROPERTY_AUDIORESOURCEMANAGEMENT(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIORESOURCEMANAGEMENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIORESOURCEMANAGEMENT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_AUDIOSIGNALPROCESSING(pub i32);
pub const KSPROPERTY_AUDIOSIGNALPROCESSING_MODES: KSPROPERTY_AUDIOSIGNALPROCESSING = KSPROPERTY_AUDIOSIGNALPROCESSING(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_AUDIOSIGNALPROCESSING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_AUDIOSIGNALPROCESSING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_AUDIO_BUFFER_DURATION: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_BIBLIOGRAPHIC(pub i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_LEADER: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(1380207648i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_LCCN: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808529952i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ISBN: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808595488i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ISSN: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(842149920i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_CATALOGINGSOURCE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808726560i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_MAINPERSONALNAME: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808464672i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_MAINCORPORATEBODY: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808530208i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_MAINMEETINGNAME: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(825307424i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_MAINUNIFORMTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808661280i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_UNIFORMTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808727072i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_TITLESTATEMENT: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(892613152i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_VARYINGFORMTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(909390368i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_PUBLICATION: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808858144i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_PHYSICALDESCRIPTION: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808465184i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808727584i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENT: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(809055264i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_GENERALNOTE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808465696i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_BIBLIOGRAPHYNOTE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(875574560i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_CONTENTSNOTE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(892351776i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_CREATIONCREDIT: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(942683424i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_CITATION: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808531232i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_PARTICIPANT: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(825308448i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_SUMMARY: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808596768i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_TARGETAUDIENCE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(825373984i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDFORMAVAILABLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808662304i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_SYSTEMDETAILS: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(942880032i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_AWARDS: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(909653280i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYPERSONALNAME: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808465952i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTOPICALTERM: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808793632i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYGEOGRAPHIC: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(825570848i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMGENRE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(892679712i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMCURRICULUM: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(943011360i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYUNIFORMTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808662816i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYRELATED: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808728352i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTPERSONALNAME: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808466464i32);
pub const KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTUNIFORMTITLE: KSPROPERTY_BIBLIOGRAPHIC = KSPROPERTY_BIBLIOGRAPHIC(808663072i32);
impl ::std::convert::From<i32> for KSPROPERTY_BIBLIOGRAPHIC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BIBLIOGRAPHIC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSPROPERTY_BOUNDS_LONG {
    pub Anonymous1: KSPROPERTY_BOUNDS_LONG_0,
    pub Anonymous2: KSPROPERTY_BOUNDS_LONG_1,
}
impl KSPROPERTY_BOUNDS_LONG {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONG {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_BOUNDS_LONG_0 {
    pub SignedMinimum: i32,
    pub SignedMaximum: i32,
}
impl KSPROPERTY_BOUNDS_LONG_0 {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONG_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_BOUNDS_LONG_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous1_e__Struct").field("SignedMinimum", &self.SignedMinimum).field("SignedMaximum", &self.SignedMaximum).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONG_0 {
    fn eq(&self, other: &Self) -> bool {
        self.SignedMinimum == other.SignedMinimum && self.SignedMaximum == other.SignedMaximum
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONG_0 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONG_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_BOUNDS_LONG_1 {
    pub UnsignedMinimum: u32,
    pub UnsignedMaximum: u32,
}
impl KSPROPERTY_BOUNDS_LONG_1 {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONG_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_BOUNDS_LONG_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous2_e__Struct").field("UnsignedMinimum", &self.UnsignedMinimum).field("UnsignedMaximum", &self.UnsignedMaximum).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONG_1 {
    fn eq(&self, other: &Self) -> bool {
        self.UnsignedMinimum == other.UnsignedMinimum && self.UnsignedMaximum == other.UnsignedMaximum
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONG_1 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONG_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSPROPERTY_BOUNDS_LONGLONG {
    pub Anonymous1: KSPROPERTY_BOUNDS_LONGLONG_0,
    pub Anonymous2: KSPROPERTY_BOUNDS_LONGLONG_1,
}
impl KSPROPERTY_BOUNDS_LONGLONG {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONGLONG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONGLONG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONGLONG {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONGLONG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_BOUNDS_LONGLONG_0 {
    pub SignedMinimum: i64,
    pub SignedMaximum: i64,
}
impl KSPROPERTY_BOUNDS_LONGLONG_0 {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONGLONG_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_BOUNDS_LONGLONG_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous1_e__Struct").field("SignedMinimum", &self.SignedMinimum).field("SignedMaximum", &self.SignedMaximum).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONGLONG_0 {
    fn eq(&self, other: &Self) -> bool {
        self.SignedMinimum == other.SignedMinimum && self.SignedMaximum == other.SignedMaximum
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONGLONG_0 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONGLONG_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_BOUNDS_LONGLONG_1 {
    pub UnsignedMinimum: u64,
    pub UnsignedMaximum: u64,
}
impl KSPROPERTY_BOUNDS_LONGLONG_1 {}
impl ::std::default::Default for KSPROPERTY_BOUNDS_LONGLONG_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_BOUNDS_LONGLONG_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous2_e__Struct").field("UnsignedMinimum", &self.UnsignedMinimum).field("UnsignedMaximum", &self.UnsignedMaximum).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_BOUNDS_LONGLONG_1 {
    fn eq(&self, other: &Self) -> bool {
        self.UnsignedMinimum == other.UnsignedMinimum && self.UnsignedMaximum == other.UnsignedMaximum
    }
}
impl ::std::cmp::Eq for KSPROPERTY_BOUNDS_LONGLONG_1 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BOUNDS_LONGLONG_1 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_BTAUDIO(pub i32);
pub const KSPROPERTY_ONESHOT_RECONNECT: KSPROPERTY_BTAUDIO = KSPROPERTY_BTAUDIO(0i32);
pub const KSPROPERTY_ONESHOT_DISCONNECT: KSPROPERTY_BTAUDIO = KSPROPERTY_BTAUDIO(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_BTAUDIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_BTAUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(pub i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(0i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOFRAMERATE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(1i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOMAXFRAMERATE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(2i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOTRIGGERTIME: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(3i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_WARMSTART: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(4i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_MAXVIDFPS_PHOTORES: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(5i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOTHUMBNAIL: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(6i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_SCENEMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(7i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_TORCHMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(8i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FLASHMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(9i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_OPTIMIZATIONHINT: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(10i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_WHITEBALANCEMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(11i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_EXPOSUREMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(12i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(13i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ISO: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(14i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FIELDOFVIEW: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(15i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_EVCOMPENSATION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(16i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_CAMERAANGLEOFFSET: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(17i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_METADATA: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(18i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSPRIORITY: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(19i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSSTATE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(20i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ROI_CONFIGCAPS: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(21i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ROI_ISPCONTROL: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(22i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOCONFIRMATION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(23i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ZOOM: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(24i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_MCC: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(25i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ISO_ADVANCED: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(26i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOSTABILIZATION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(27i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_VFR: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(28i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FACEDETECTION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(29i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOHDR: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(30i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_HISTOGRAM: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(31i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_OIS: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(32i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_ADVANCEDPHOTO: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(33i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_PROFILE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(34i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_FACEAUTH_MODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(35i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_SECURE_MODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(36i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOTEMPORALDENOISING: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(37i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_IRTORCHMODE: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(38i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_RELATIVEPANELOPTIMIZATION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(39i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_EYEGAZECORRECTION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(40i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_BACKGROUNDSEGMENTATION: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(41i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_DIGITALWINDOW_CONFIGCAPS: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(42i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_DIGITALWINDOW: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(43i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_END: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(44i32);
pub const KSPROPERTY_CAMERACONTROL_EXTENDED_END2: KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY = KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY(44i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLAGS_ABSOLUTE: i32 = 0i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLAGS_ASYNCHRONOUS: i32 = 4i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLAGS_AUTO: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLAGS_MANUAL: i32 = 2i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLAGS_RELATIVE: i32 = 16i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_FLASH(pub i32);
pub const KSPROPERTY_CAMERACONTROL_FLASH_PROPERTY_ID: KSPROPERTY_CAMERACONTROL_FLASH = KSPROPERTY_CAMERACONTROL_FLASH(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_FLASH {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_FLASH {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLASH_AUTO: i32 = 2i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLASH_FLAGS_AUTO: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLASH_FLAGS_MANUAL: i32 = 2i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLASH_OFF: i32 = 0i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_FLASH_ON: i32 = 1i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_FLASH_S {
    pub Flash: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_CAMERACONTROL_FLASH_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_FLASH_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_CAMERACONTROL_FLASH_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_CAMERACONTROL_FLASH_S").field("Flash", &self.Flash).field("Capabilities", &self.Capabilities).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_FLASH_S {
    fn eq(&self, other: &Self) -> bool {
        self.Flash == other.Flash && self.Capabilities == other.Capabilities
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_FLASH_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_FLASH_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {
    pub Property: KSIDENTIFIER,
    pub lOcularFocalLength: i32,
    pub lObjectiveFocalLengthMin: i32,
    pub lObjectiveFocalLengthMax: i32,
}
impl KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY(pub i32);
pub const KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_PROPERTY_ID: KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY = KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_EXCLUSIVE_WITH_RECORD: i32 = 1i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {
    pub Capabilities: u32,
    pub Reserved0: u32,
}
impl KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S").field("Capabilities", &self.Capabilities).field("Reserved0", &self.Reserved0).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {
    fn eq(&self, other: &Self) -> bool {
        self.Capabilities == other.Capabilities && self.Reserved0 == other.Reserved0
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_SEQUENCE_EXCLUSIVE_WITH_RECORD: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {
    pub NodeProperty: KSNODEPROPERTY,
    pub lOcularFocalLength: i32,
    pub lObjectiveFocalLengthMin: i32,
    pub lObjectiveFocalLengthMax: i32,
}
impl KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_NODE_S {
    pub NodeProperty: KSP_NODE,
    pub Value: i32,
    pub Flags: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_CAMERACONTROL_NODE_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_NODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_NODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_NODE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_NODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_NODE_S2 {
    pub NodeProperty: KSP_NODE,
    pub Value1: i32,
    pub Flags: u32,
    pub Capabilities: u32,
    pub Value2: i32,
}
impl KSPROPERTY_CAMERACONTROL_NODE_S2 {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_NODE_S2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_NODE_S2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_NODE_S2 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_NODE_S2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY(pub i32);
pub const KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_CAPABILITY: KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY = KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY(0i32);
pub const KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_SET: KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY = KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY(1i32);
pub const KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_CLEAR: KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY = KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST(pub i32);
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_PROPERTY_ID: KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST = KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_EXPOSURE: i32 = 512i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_FOCUS: i32 = 256i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_WB: i32 = 1024i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONVERGEMODE: i32 = 1073741824i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_ASYNC: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_AUTO: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_MANUAL: i32 = 2i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {
    pub FocusRect: super::super::super::Foundation::RECT,
    pub AutoFocusLock: super::super::super::Foundation::BOOL,
    pub AutoExposureLock: super::super::super::Foundation::BOOL,
    pub AutoWhitebalanceLock: super::super::super::Foundation::BOOL,
    pub Anonymous: KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {
    pub Capabilities: u32,
    pub Configuration: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_S {
    pub Property: KSIDENTIFIER,
    pub Value: i32,
    pub Flags: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_CAMERACONTROL_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_S2 {
    pub Property: KSIDENTIFIER,
    pub Value1: i32,
    pub Flags: u32,
    pub Capabilities: u32,
    pub Value2: i32,
}
impl KSPROPERTY_CAMERACONTROL_S2 {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_S2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_S2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_S2 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_S2 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_CAMERACONTROL_S_EX {
    pub Property: KSIDENTIFIER,
    pub Value: i32,
    pub Flags: u32,
    pub Capabilities: u32,
    pub FocusRect: super::super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_CAMERACONTROL_S_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_S_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_S_EX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_S_EX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_S_EX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_AUTO: i32 = 4i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_FLAGS_AUTO: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_FLAGS_MANUAL: i32 = 2i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_HIGH: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_LOW: i32 = 3i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_MEDIUM: i32 = 2i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_OFF: i32 = 0i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {
    pub VideoStabilizationMode: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {}
impl ::std::default::Default for KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S").field("VideoStabilizationMode", &self.VideoStabilizationMode).field("Capabilities", &self.Capabilities).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {
    fn eq(&self, other: &Self) -> bool {
        self.VideoStabilizationMode == other.VideoStabilizationMode && self.Capabilities == other.Capabilities
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE(pub i32);
pub const KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE_PROPERTY_ID: KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE = KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS(pub i32);
pub const KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_CLEAR: KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS = KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS(0i32);
pub const KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_SET: KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS = KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CLOCK(pub i32);
pub const KSPROPERTY_CLOCK_TIME: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(0i32);
pub const KSPROPERTY_CLOCK_PHYSICALTIME: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(1i32);
pub const KSPROPERTY_CLOCK_CORRELATEDTIME: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(2i32);
pub const KSPROPERTY_CLOCK_CORRELATEDPHYSICALTIME: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(3i32);
pub const KSPROPERTY_CLOCK_RESOLUTION: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(4i32);
pub const KSPROPERTY_CLOCK_STATE: KSPROPERTY_CLOCK = KSPROPERTY_CLOCK(5i32);
impl ::std::convert::From<i32> for KSPROPERTY_CLOCK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CLOCK {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CONNECTION(pub i32);
pub const KSPROPERTY_CONNECTION_STATE: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(0i32);
pub const KSPROPERTY_CONNECTION_PRIORITY: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(1i32);
pub const KSPROPERTY_CONNECTION_DATAFORMAT: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(2i32);
pub const KSPROPERTY_CONNECTION_ALLOCATORFRAMING: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(3i32);
pub const KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(4i32);
pub const KSPROPERTY_CONNECTION_ACQUIREORDERING: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(5i32);
pub const KSPROPERTY_CONNECTION_ALLOCATORFRAMING_EX: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(6i32);
pub const KSPROPERTY_CONNECTION_STARTAT: KSPROPERTY_CONNECTION = KSPROPERTY_CONNECTION(7i32);
impl ::std::convert::From<i32> for KSPROPERTY_CONNECTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CONNECTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_COPYPROT(pub i32);
pub const KSPROPERTY_DVDCOPY_CHLG_KEY: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(1i32);
pub const KSPROPERTY_DVDCOPY_DVD_KEY1: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(2i32);
pub const KSPROPERTY_DVDCOPY_DEC_KEY2: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(3i32);
pub const KSPROPERTY_DVDCOPY_TITLE_KEY: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(4i32);
pub const KSPROPERTY_COPY_MACROVISION: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(5i32);
pub const KSPROPERTY_DVDCOPY_REGION: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(6i32);
pub const KSPROPERTY_DVDCOPY_SET_COPY_STATE: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(7i32);
pub const KSPROPERTY_DVDCOPY_DISC_KEY: KSPROPERTY_COPYPROT = KSPROPERTY_COPYPROT(128i32);
impl ::std::convert::From<i32> for KSPROPERTY_COPYPROT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_COPYPROT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CROSSBAR_ACTIVE_S {
    pub Property: KSIDENTIFIER,
    pub IndexInputPin: u32,
    pub Active: u32,
}
impl KSPROPERTY_CROSSBAR_ACTIVE_S {}
impl ::std::default::Default for KSPROPERTY_CROSSBAR_ACTIVE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CROSSBAR_ACTIVE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CROSSBAR_ACTIVE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CROSSBAR_ACTIVE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CROSSBAR_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub NumberOfInputs: u32,
    pub NumberOfOutputs: u32,
}
impl KSPROPERTY_CROSSBAR_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_CROSSBAR_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CROSSBAR_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CROSSBAR_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CROSSBAR_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CROSSBAR_PININFO_S {
    pub Property: KSIDENTIFIER,
    pub Direction: KSPIN_DATAFLOW,
    pub Index: u32,
    pub PinType: u32,
    pub RelatedPinIndex: u32,
    pub Medium: KSIDENTIFIER,
}
impl KSPROPERTY_CROSSBAR_PININFO_S {}
impl ::std::default::Default for KSPROPERTY_CROSSBAR_PININFO_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CROSSBAR_PININFO_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CROSSBAR_PININFO_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CROSSBAR_PININFO_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_CROSSBAR_ROUTE_S {
    pub Property: KSIDENTIFIER,
    pub IndexInputPin: u32,
    pub IndexOutputPin: u32,
    pub CanRoute: u32,
}
impl KSPROPERTY_CROSSBAR_ROUTE_S {}
impl ::std::default::Default for KSPROPERTY_CROSSBAR_ROUTE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_CROSSBAR_ROUTE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_CROSSBAR_ROUTE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CROSSBAR_ROUTE_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_CYCLIC(pub i32);
pub const KSPROPERTY_CYCLIC_POSITION: KSPROPERTY_CYCLIC = KSPROPERTY_CYCLIC(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_CYCLIC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_CYCLIC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_DESCRIPTION {
    pub AccessFlags: u32,
    pub DescriptionSize: u32,
    pub PropTypeSet: KSIDENTIFIER,
    pub MembersListCount: u32,
    pub Reserved: u32,
}
impl KSPROPERTY_DESCRIPTION {}
impl ::std::default::Default for KSPROPERTY_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_DESCRIPTION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_DESCRIPTION {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DESCRIPTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_DIRECTSOUND3DBUFFER(pub i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_ALL: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(0i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(1i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(2i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(3i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(4i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(5i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(6i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(7i32);
pub const KSPROPERTY_DIRECTSOUND3DBUFFER_MODE: KSPROPERTY_DIRECTSOUND3DBUFFER = KSPROPERTY_DIRECTSOUND3DBUFFER(8i32);
impl ::std::convert::From<i32> for KSPROPERTY_DIRECTSOUND3DBUFFER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DIRECTSOUND3DBUFFER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_DIRECTSOUND3DLISTENER(pub i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_ALL: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(0i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(1i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(2i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(3i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(4i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(5i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(6i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(7i32);
pub const KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION: KSPROPERTY_DIRECTSOUND3DLISTENER = KSPROPERTY_DIRECTSOUND3DLISTENER(8i32);
impl ::std::convert::From<i32> for KSPROPERTY_DIRECTSOUND3DLISTENER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DIRECTSOUND3DLISTENER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_DRMAUDIOSTREAM(pub i32);
pub const KSPROPERTY_DRMAUDIOSTREAM_CONTENTID: KSPROPERTY_DRMAUDIOSTREAM = KSPROPERTY_DRMAUDIOSTREAM(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_DRMAUDIOSTREAM {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DRMAUDIOSTREAM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_DROPPEDFRAMES_CURRENT_S {
    pub Property: KSIDENTIFIER,
    pub PictureNumber: i64,
    pub DropCount: i64,
    pub AverageFrameSize: u32,
}
impl KSPROPERTY_DROPPEDFRAMES_CURRENT_S {}
impl ::std::default::Default for KSPROPERTY_DROPPEDFRAMES_CURRENT_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_DROPPEDFRAMES_CURRENT_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_DROPPEDFRAMES_CURRENT_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DROPPEDFRAMES_CURRENT_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_DVDSUBPIC(pub i32);
pub const KSPROPERTY_DVDSUBPIC_PALETTE: KSPROPERTY_DVDSUBPIC = KSPROPERTY_DVDSUBPIC(0i32);
pub const KSPROPERTY_DVDSUBPIC_HLI: KSPROPERTY_DVDSUBPIC = KSPROPERTY_DVDSUBPIC(1i32);
pub const KSPROPERTY_DVDSUBPIC_COMPOSIT_ON: KSPROPERTY_DVDSUBPIC = KSPROPERTY_DVDSUBPIC(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_DVDSUBPIC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_DVDSUBPIC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_EXTDEVICE(pub i32);
pub const KSPROPERTY_EXTDEVICE_ID: KSPROPERTY_EXTDEVICE = KSPROPERTY_EXTDEVICE(0i32);
pub const KSPROPERTY_EXTDEVICE_VERSION: KSPROPERTY_EXTDEVICE = KSPROPERTY_EXTDEVICE(1i32);
pub const KSPROPERTY_EXTDEVICE_POWER_STATE: KSPROPERTY_EXTDEVICE = KSPROPERTY_EXTDEVICE(2i32);
pub const KSPROPERTY_EXTDEVICE_PORT: KSPROPERTY_EXTDEVICE = KSPROPERTY_EXTDEVICE(3i32);
pub const KSPROPERTY_EXTDEVICE_CAPABILITIES: KSPROPERTY_EXTDEVICE = KSPROPERTY_EXTDEVICE(4i32);
impl ::std::convert::From<i32> for KSPROPERTY_EXTDEVICE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTDEVICE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_EXTDEVICE_S {
    pub Property: KSIDENTIFIER,
    pub u: KSPROPERTY_EXTDEVICE_S_0,
}
impl KSPROPERTY_EXTDEVICE_S {}
impl ::std::default::Default for KSPROPERTY_EXTDEVICE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_EXTDEVICE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_EXTDEVICE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTDEVICE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub union KSPROPERTY_EXTDEVICE_S_0 {
    pub Capabilities: DEVCAPS,
    pub DevPort: u32,
    pub PowerState: u32,
    pub pawchString: [u16; 260],
    pub NodeUniqueID: [u32; 2],
}
impl KSPROPERTY_EXTDEVICE_S_0 {}
impl ::std::default::Default for KSPROPERTY_EXTDEVICE_S_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_EXTDEVICE_S_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_EXTDEVICE_S_0 {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTDEVICE_S_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_EXTENSION_UNIT(pub i32);
pub const KSPROPERTY_EXTENSION_UNIT_INFO: KSPROPERTY_EXTENSION_UNIT = KSPROPERTY_EXTENSION_UNIT(0i32);
pub const KSPROPERTY_EXTENSION_UNIT_CONTROL: KSPROPERTY_EXTENSION_UNIT = KSPROPERTY_EXTENSION_UNIT(1i32);
pub const KSPROPERTY_EXTENSION_UNIT_PASS_THROUGH: KSPROPERTY_EXTENSION_UNIT = KSPROPERTY_EXTENSION_UNIT(65535i32);
impl ::std::convert::From<i32> for KSPROPERTY_EXTENSION_UNIT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTENSION_UNIT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_EXTXPORT(pub i32);
pub const KSPROPERTY_EXTXPORT_CAPABILITIES: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(0i32);
pub const KSPROPERTY_EXTXPORT_INPUT_SIGNAL_MODE: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(1i32);
pub const KSPROPERTY_EXTXPORT_OUTPUT_SIGNAL_MODE: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(2i32);
pub const KSPROPERTY_EXTXPORT_LOAD_MEDIUM: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(3i32);
pub const KSPROPERTY_EXTXPORT_MEDIUM_INFO: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(4i32);
pub const KSPROPERTY_EXTXPORT_STATE: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(5i32);
pub const KSPROPERTY_EXTXPORT_STATE_NOTIFY: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(6i32);
pub const KSPROPERTY_EXTXPORT_TIMECODE_SEARCH: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(7i32);
pub const KSPROPERTY_EXTXPORT_ATN_SEARCH: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(8i32);
pub const KSPROPERTY_EXTXPORT_RTC_SEARCH: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(9i32);
pub const KSPROPERTY_RAW_AVC_CMD: KSPROPERTY_EXTXPORT = KSPROPERTY_EXTXPORT(10i32);
impl ::std::convert::From<i32> for KSPROPERTY_EXTXPORT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_EXTXPORT_NODE_S {
    pub NodeProperty: KSP_NODE,
    pub u: KSPROPERTY_EXTXPORT_NODE_S_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_NODE_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_NODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_NODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_NODE_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_NODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union KSPROPERTY_EXTXPORT_NODE_S_0 {
    pub Capabilities: u32,
    pub SignalMode: u32,
    pub LoadMedium: u32,
    pub MediumInfo: MEDIUM_INFO,
    pub XPrtState: TRANSPORT_STATE,
    pub Timecode: KSPROPERTY_EXTXPORT_NODE_S_0_1,
    pub dwTimecode: u32,
    pub dwAbsTrackNumber: u32,
    pub RawAVC: KSPROPERTY_EXTXPORT_NODE_S_0_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_NODE_S_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_NODE_S_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_NODE_S_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_NODE_S_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_NODE_S_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSPROPERTY_EXTXPORT_NODE_S_0_0 {
    pub PayloadSize: u32,
    pub Payload: [u8; 512],
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_NODE_S_0_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_NODE_S_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSPROPERTY_EXTXPORT_NODE_S_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_RawAVC_e__Struct").field("PayloadSize", &self.PayloadSize).field("Payload", &self.Payload).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_NODE_S_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.PayloadSize == other.PayloadSize && self.Payload == other.Payload
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_NODE_S_0_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_NODE_S_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSPROPERTY_EXTXPORT_NODE_S_0_1 {
    pub frame: u8,
    pub second: u8,
    pub minute: u8,
    pub hour: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_NODE_S_0_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_NODE_S_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSPROPERTY_EXTXPORT_NODE_S_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Timecode_e__Struct").field("frame", &self.frame).field("second", &self.second).field("minute", &self.minute).field("hour", &self.hour).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_NODE_S_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.frame == other.frame && self.second == other.second && self.minute == other.minute && self.hour == other.hour
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_NODE_S_0_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_NODE_S_0_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_EXTXPORT_S {
    pub Property: KSIDENTIFIER,
    pub u: KSPROPERTY_EXTXPORT_S_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union KSPROPERTY_EXTXPORT_S_0 {
    pub Capabilities: u32,
    pub SignalMode: u32,
    pub LoadMedium: u32,
    pub MediumInfo: MEDIUM_INFO,
    pub XPrtState: TRANSPORT_STATE,
    pub Timecode: KSPROPERTY_EXTXPORT_S_0_1,
    pub dwTimecode: u32,
    pub dwAbsTrackNumber: u32,
    pub RawAVC: KSPROPERTY_EXTXPORT_S_0_0,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_S_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_S_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_S_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_S_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_S_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSPROPERTY_EXTXPORT_S_0_0 {
    pub PayloadSize: u32,
    pub Payload: [u8; 512],
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_S_0_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_S_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSPROPERTY_EXTXPORT_S_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_RawAVC_e__Struct").field("PayloadSize", &self.PayloadSize).field("Payload", &self.Payload).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_S_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.PayloadSize == other.PayloadSize && self.Payload == other.Payload
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_S_0_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_S_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct KSPROPERTY_EXTXPORT_S_0_1 {
    pub frame: u8,
    pub second: u8,
    pub minute: u8,
    pub hour: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_EXTXPORT_S_0_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_EXTXPORT_S_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSPROPERTY_EXTXPORT_S_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Timecode_e__Struct").field("frame", &self.frame).field("second", &self.second).field("minute", &self.minute).field("hour", &self.hour).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_EXTXPORT_S_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.frame == other.frame && self.second == other.second && self.minute == other.minute && self.hour == other.hour
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_EXTXPORT_S_0_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_EXTXPORT_S_0_1 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_FMRX_CONTROL(pub i32);
pub const KSPROPERTY_FMRX_STATE: KSPROPERTY_FMRX_CONTROL = KSPROPERTY_FMRX_CONTROL(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_FMRX_CONTROL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_FMRX_CONTROL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_FMRX_TOPOLOGY(pub i32);
pub const KSPROPERTY_FMRX_ENDPOINTID: KSPROPERTY_FMRX_TOPOLOGY = KSPROPERTY_FMRX_TOPOLOGY(0i32);
pub const KSPROPERTY_FMRX_VOLUME: KSPROPERTY_FMRX_TOPOLOGY = KSPROPERTY_FMRX_TOPOLOGY(1i32);
pub const KSPROPERTY_FMRX_ANTENNAENDPOINTID: KSPROPERTY_FMRX_TOPOLOGY = KSPROPERTY_FMRX_TOPOLOGY(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_FMRX_TOPOLOGY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_FMRX_TOPOLOGY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_GENERAL(pub i32);
pub const KSPROPERTY_GENERAL_COMPONENTID: KSPROPERTY_GENERAL = KSPROPERTY_GENERAL(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_GENERAL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_GENERAL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_HRTF3D(pub i32);
pub const KSPROPERTY_HRTF3D_PARAMS: KSPROPERTY_HRTF3D = KSPROPERTY_HRTF3D(0i32);
pub const KSPROPERTY_HRTF3D_INITIALIZE: KSPROPERTY_HRTF3D = KSPROPERTY_HRTF3D(1i32);
pub const KSPROPERTY_HRTF3D_FILTER_FORMAT: KSPROPERTY_HRTF3D = KSPROPERTY_HRTF3D(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_HRTF3D {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_HRTF3D {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_INTERLEAVEDAUDIO(pub i32);
pub const KSPROPERTY_INTERLEAVEDAUDIO_FORMATINFORMATION: KSPROPERTY_INTERLEAVEDAUDIO = KSPROPERTY_INTERLEAVEDAUDIO(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_INTERLEAVEDAUDIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_INTERLEAVEDAUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_ITD3D(pub i32);
pub const KSPROPERTY_ITD3D_PARAMS: KSPROPERTY_ITD3D = KSPROPERTY_ITD3D(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_ITD3D {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_ITD3D {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_JACK(pub i32);
pub const KSPROPERTY_JACK_DESCRIPTION: KSPROPERTY_JACK = KSPROPERTY_JACK(1i32);
pub const KSPROPERTY_JACK_DESCRIPTION2: KSPROPERTY_JACK = KSPROPERTY_JACK(2i32);
pub const KSPROPERTY_JACK_SINK_INFO: KSPROPERTY_JACK = KSPROPERTY_JACK(3i32);
pub const KSPROPERTY_JACK_CONTAINERID: KSPROPERTY_JACK = KSPROPERTY_JACK(4i32);
impl ::std::convert::From<i32> for KSPROPERTY_JACK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_JACK {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_MEDIAAVAILABLE {
    pub Earliest: i64,
    pub Latest: i64,
}
impl KSPROPERTY_MEDIAAVAILABLE {}
impl ::std::default::Default for KSPROPERTY_MEDIAAVAILABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_MEDIAAVAILABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_MEDIAAVAILABLE").field("Earliest", &self.Earliest).field("Latest", &self.Latest).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_MEDIAAVAILABLE {
    fn eq(&self, other: &Self) -> bool {
        self.Earliest == other.Earliest && self.Latest == other.Latest
    }
}
impl ::std::cmp::Eq for KSPROPERTY_MEDIAAVAILABLE {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_MEDIAAVAILABLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_MEDIASEEKING(pub i32);
pub const KSPROPERTY_MEDIASEEKING_CAPABILITIES: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(0i32);
pub const KSPROPERTY_MEDIASEEKING_FORMATS: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(1i32);
pub const KSPROPERTY_MEDIASEEKING_TIMEFORMAT: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(2i32);
pub const KSPROPERTY_MEDIASEEKING_POSITION: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(3i32);
pub const KSPROPERTY_MEDIASEEKING_STOPPOSITION: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(4i32);
pub const KSPROPERTY_MEDIASEEKING_POSITIONS: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(5i32);
pub const KSPROPERTY_MEDIASEEKING_DURATION: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(6i32);
pub const KSPROPERTY_MEDIASEEKING_AVAILABLE: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(7i32);
pub const KSPROPERTY_MEDIASEEKING_PREROLL: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(8i32);
pub const KSPROPERTY_MEDIASEEKING_CONVERTTIMEFORMAT: KSPROPERTY_MEDIASEEKING = KSPROPERTY_MEDIASEEKING(9i32);
impl ::std::convert::From<i32> for KSPROPERTY_MEDIASEEKING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_MEDIASEEKING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_MEMBERSHEADER {
    pub MembersFlags: u32,
    pub MembersSize: u32,
    pub MembersCount: u32,
    pub Flags: u32,
}
impl KSPROPERTY_MEMBERSHEADER {}
impl ::std::default::Default for KSPROPERTY_MEMBERSHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_MEMBERSHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_MEMBERSHEADER").field("MembersFlags", &self.MembersFlags).field("MembersSize", &self.MembersSize).field("MembersCount", &self.MembersCount).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_MEMBERSHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.MembersFlags == other.MembersFlags && self.MembersSize == other.MembersSize && self.MembersCount == other.MembersCount && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for KSPROPERTY_MEMBERSHEADER {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_MEMBERSHEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_FLAG_BASICSUPPORT_MULTICHANNEL: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_FLAG_BASICSUPPORT_UNIFORM: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_FLAG_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_RANGES: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_STEPPEDRANGES: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMBER_VALUES: u32 = 3u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_MEMORY_TRANSPORT: i32 = 1i32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_MPEG2VID(pub i32);
pub const KSPROPERTY_MPEG2VID_MODES: KSPROPERTY_MPEG2VID = KSPROPERTY_MPEG2VID(0i32);
pub const KSPROPERTY_MPEG2VID_CUR_MODE: KSPROPERTY_MPEG2VID = KSPROPERTY_MPEG2VID(1i32);
pub const KSPROPERTY_MPEG2VID_4_3_RECT: KSPROPERTY_MPEG2VID = KSPROPERTY_MPEG2VID(2i32);
pub const KSPROPERTY_MPEG2VID_16_9_RECT: KSPROPERTY_MPEG2VID = KSPROPERTY_MPEG2VID(3i32);
pub const KSPROPERTY_MPEG2VID_16_9_PANSCAN: KSPROPERTY_MPEG2VID = KSPROPERTY_MPEG2VID(4i32);
impl ::std::convert::From<i32> for KSPROPERTY_MPEG2VID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_MPEG2VID {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES(pub i32);
pub const KSPROPERTY_MPEG4_MEDIATYPE_SD_BOX: KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES = KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {
    pub Header: KSCAMERA_METADATA_ITEMHEADER,
    pub EventFilter: [u16; 1],
}
impl KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {}
impl ::std::default::Default for KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO").field("Header", &self.Header).field("EventFilter", &self.EventFilter).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Header == other.Header && self.EventFilter == other.EventFilter
    }
}
impl ::std::cmp::Eq for KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {
    pub MetadataItems: u32,
    pub Size: u32,
    pub PTZStatus: super::super::super::Foundation::BOOL,
    pub Events: super::super::super::Foundation::BOOL,
    pub Analytics: super::super::super::Foundation::BOOL,
    pub Reserved: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO").field("MetadataItems", &self.MetadataItems).field("Size", &self.Size).field("PTZStatus", &self.PTZStatus).field("Events", &self.Events).field("Analytics", &self.Analytics).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.MetadataItems == other.MetadataItems && self.Size == other.Size && self.PTZStatus == other.PTZStatus && self.Events == other.Events && self.Analytics == other.Analytics && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE(pub i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE_EVENTSINFO: KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE = KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {
    pub Size: u32,
    pub Type: KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE,
}
impl KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {}
impl ::std::default::Default for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER").field("Size", &self.Size).field("Type", &self.Type).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.Type == other.Type
    }
}
impl ::std::cmp::Eq for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE(pub i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE_DISABLE: KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE = KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE(0i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE_HOSTNTP: KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE = KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE(1i32);
pub const KSPROPERYT_NETWORKCAMERACONTROL_NTPINFO_TYPE_CUSTOM: KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE = KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY(pub i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_NTP: KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY = KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY(0i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_URI: KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY = KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY(1i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_METADATA: KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY = KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY(2i32);
pub const KSPROPERTY_NETWORKCAMERACONTROL_EVENTTOPICS_XML: KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY = KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY(3i32);
impl ::std::convert::From<i32> for KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_OVERLAYUPDATE(pub i32);
pub const KSPROPERTY_OVERLAYUPDATE_INTERESTS: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(0i32);
pub const KSPROPERTY_OVERLAYUPDATE_CLIPLIST: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(1i32);
pub const KSPROPERTY_OVERLAYUPDATE_PALETTE: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(2i32);
pub const KSPROPERTY_OVERLAYUPDATE_COLORKEY: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(4i32);
pub const KSPROPERTY_OVERLAYUPDATE_VIDEOPOSITION: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(8i32);
pub const KSPROPERTY_OVERLAYUPDATE_DISPLAYCHANGE: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(16i32);
pub const KSPROPERTY_OVERLAYUPDATE_COLORREF: KSPROPERTY_OVERLAYUPDATE = KSPROPERTY_OVERLAYUPDATE(268435456i32);
impl ::std::convert::From<i32> for KSPROPERTY_OVERLAYUPDATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_OVERLAYUPDATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_PIN(pub i32);
pub const KSPROPERTY_PIN_CINSTANCES: KSPROPERTY_PIN = KSPROPERTY_PIN(0i32);
pub const KSPROPERTY_PIN_CTYPES: KSPROPERTY_PIN = KSPROPERTY_PIN(1i32);
pub const KSPROPERTY_PIN_DATAFLOW: KSPROPERTY_PIN = KSPROPERTY_PIN(2i32);
pub const KSPROPERTY_PIN_DATARANGES: KSPROPERTY_PIN = KSPROPERTY_PIN(3i32);
pub const KSPROPERTY_PIN_DATAINTERSECTION: KSPROPERTY_PIN = KSPROPERTY_PIN(4i32);
pub const KSPROPERTY_PIN_INTERFACES: KSPROPERTY_PIN = KSPROPERTY_PIN(5i32);
pub const KSPROPERTY_PIN_MEDIUMS: KSPROPERTY_PIN = KSPROPERTY_PIN(6i32);
pub const KSPROPERTY_PIN_COMMUNICATION: KSPROPERTY_PIN = KSPROPERTY_PIN(7i32);
pub const KSPROPERTY_PIN_GLOBALCINSTANCES: KSPROPERTY_PIN = KSPROPERTY_PIN(8i32);
pub const KSPROPERTY_PIN_NECESSARYINSTANCES: KSPROPERTY_PIN = KSPROPERTY_PIN(9i32);
pub const KSPROPERTY_PIN_PHYSICALCONNECTION: KSPROPERTY_PIN = KSPROPERTY_PIN(10i32);
pub const KSPROPERTY_PIN_CATEGORY: KSPROPERTY_PIN = KSPROPERTY_PIN(11i32);
pub const KSPROPERTY_PIN_NAME: KSPROPERTY_PIN = KSPROPERTY_PIN(12i32);
pub const KSPROPERTY_PIN_CONSTRAINEDDATARANGES: KSPROPERTY_PIN = KSPROPERTY_PIN(13i32);
pub const KSPROPERTY_PIN_PROPOSEDATAFORMAT: KSPROPERTY_PIN = KSPROPERTY_PIN(14i32);
pub const KSPROPERTY_PIN_PROPOSEDATAFORMAT2: KSPROPERTY_PIN = KSPROPERTY_PIN(15i32);
pub const KSPROPERTY_PIN_MODEDATAFORMATS: KSPROPERTY_PIN = KSPROPERTY_PIN(16i32);
impl ::std::convert::From<i32> for KSPROPERTY_PIN {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_PIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_PIN_FLAGS_ATTRIBUTE_RANGE_AWARE: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_PIN_FLAGS_MASK: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_POSITIONS {
    pub Current: i64,
    pub Stop: i64,
    pub CurrentFlags: KS_SEEKING_FLAGS,
    pub StopFlags: KS_SEEKING_FLAGS,
}
impl KSPROPERTY_POSITIONS {}
impl ::std::default::Default for KSPROPERTY_POSITIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_POSITIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_POSITIONS").field("Current", &self.Current).field("Stop", &self.Stop).field("CurrentFlags", &self.CurrentFlags).field("StopFlags", &self.StopFlags).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_POSITIONS {
    fn eq(&self, other: &Self) -> bool {
        self.Current == other.Current && self.Stop == other.Stop && self.CurrentFlags == other.CurrentFlags && self.StopFlags == other.StopFlags
    }
}
impl ::std::cmp::Eq for KSPROPERTY_POSITIONS {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_POSITIONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_QUALITY(pub i32);
pub const KSPROPERTY_QUALITY_REPORT: KSPROPERTY_QUALITY = KSPROPERTY_QUALITY(0i32);
pub const KSPROPERTY_QUALITY_ERROR: KSPROPERTY_QUALITY = KSPROPERTY_QUALITY(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_QUALITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_QUALITY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_RTAUDIO(pub i32);
pub const KSPROPERTY_RTAUDIO_GETPOSITIONFUNCTION: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(0i32);
pub const KSPROPERTY_RTAUDIO_BUFFER: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(1i32);
pub const KSPROPERTY_RTAUDIO_HWLATENCY: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(2i32);
pub const KSPROPERTY_RTAUDIO_POSITIONREGISTER: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(3i32);
pub const KSPROPERTY_RTAUDIO_CLOCKREGISTER: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(4i32);
pub const KSPROPERTY_RTAUDIO_BUFFER_WITH_NOTIFICATION: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(5i32);
pub const KSPROPERTY_RTAUDIO_REGISTER_NOTIFICATION_EVENT: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(6i32);
pub const KSPROPERTY_RTAUDIO_UNREGISTER_NOTIFICATION_EVENT: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(7i32);
pub const KSPROPERTY_RTAUDIO_QUERY_NOTIFICATION_SUPPORT: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(8i32);
pub const KSPROPERTY_RTAUDIO_PACKETCOUNT: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(9i32);
pub const KSPROPERTY_RTAUDIO_PRESENTATION_POSITION: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(10i32);
pub const KSPROPERTY_RTAUDIO_GETREADPACKET: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(11i32);
pub const KSPROPERTY_RTAUDIO_SETWRITEPACKET: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(12i32);
pub const KSPROPERTY_RTAUDIO_PACKETVREGISTER: KSPROPERTY_RTAUDIO = KSPROPERTY_RTAUDIO(13i32);
impl ::std::convert::From<i32> for KSPROPERTY_RTAUDIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_RTAUDIO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SELECTOR_NODE_S {
    pub NodeProperty: KSP_NODE,
    pub Value: i32,
    pub Flags: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_SELECTOR_NODE_S {}
impl ::std::default::Default for KSPROPERTY_SELECTOR_NODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SELECTOR_NODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SELECTOR_NODE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SELECTOR_NODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SELECTOR_S {
    pub Property: KSIDENTIFIER,
    pub Value: i32,
    pub Flags: u32,
    pub Capabilities: u32,
}
impl KSPROPERTY_SELECTOR_S {}
impl ::std::default::Default for KSPROPERTY_SELECTOR_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SELECTOR_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SELECTOR_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SELECTOR_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SERIAL {
    pub PropTypeSet: KSIDENTIFIER,
    pub Id: u32,
    pub PropertyLength: u32,
}
impl KSPROPERTY_SERIAL {}
impl ::std::default::Default for KSPROPERTY_SERIAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SERIAL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SERIAL {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SERIAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SERIALHDR {
    pub PropertySet: ::windows::runtime::GUID,
    pub Count: u32,
}
impl KSPROPERTY_SERIALHDR {}
impl ::std::default::Default for KSPROPERTY_SERIALHDR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SERIALHDR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SERIALHDR {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SERIALHDR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_SOUNDDETECTOR(pub i32);
pub const KSPROPERTY_SOUNDDETECTOR_SUPPORTEDPATTERNS: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(1i32);
pub const KSPROPERTY_SOUNDDETECTOR_PATTERNS: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(2i32);
pub const KSPROPERTY_SOUNDDETECTOR_ARMED: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(3i32);
pub const KSPROPERTY_SOUNDDETECTOR_MATCHRESULT: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(4i32);
pub const KSPROPERTY_SOUNDDETECTOR_RESET: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(5i32);
pub const KSPROPERTY_SOUNDDETECTOR_STREAMINGSUPPORT: KSPROPERTY_SOUNDDETECTOR = KSPROPERTY_SOUNDDETECTOR(6i32);
impl ::std::convert::From<i32> for KSPROPERTY_SOUNDDETECTOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SOUNDDETECTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SPHLI {
    pub HLISS: u16,
    pub Reserved: u16,
    pub StartPTM: u32,
    pub EndPTM: u32,
    pub StartX: u16,
    pub StartY: u16,
    pub StopX: u16,
    pub StopY: u16,
    pub ColCon: KS_COLCON,
}
impl KSPROPERTY_SPHLI {}
impl ::std::default::Default for KSPROPERTY_SPHLI {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_SPHLI {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_SPHLI")
            .field("HLISS", &self.HLISS)
            .field("Reserved", &self.Reserved)
            .field("StartPTM", &self.StartPTM)
            .field("EndPTM", &self.EndPTM)
            .field("StartX", &self.StartX)
            .field("StartY", &self.StartY)
            .field("StopX", &self.StopX)
            .field("StopY", &self.StopY)
            .field("ColCon", &self.ColCon)
            .finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SPHLI {
    fn eq(&self, other: &Self) -> bool {
        self.HLISS == other.HLISS && self.Reserved == other.Reserved && self.StartPTM == other.StartPTM && self.EndPTM == other.EndPTM && self.StartX == other.StartX && self.StartY == other.StartY && self.StopX == other.StopX && self.StopY == other.StopY && self.ColCon == other.ColCon
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SPHLI {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SPHLI {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_SPPAL {
    pub sppal: [KS_DVD_YUV; 16],
}
impl KSPROPERTY_SPPAL {}
impl ::std::default::Default for KSPROPERTY_SPPAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for KSPROPERTY_SPPAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("KSPROPERTY_SPPAL").field("sppal", &self.sppal).finish()
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_SPPAL {
    fn eq(&self, other: &Self) -> bool {
        self.sppal == other.sppal
    }
}
impl ::std::cmp::Eq for KSPROPERTY_SPPAL {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_SPPAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_STEPPING_LONG {
    pub SteppingDelta: u32,
    pub Reserved: u32,
    pub Bounds: KSPROPERTY_BOUNDS_LONG,
}
impl KSPROPERTY_STEPPING_LONG {}
impl ::std::default::Default for KSPROPERTY_STEPPING_LONG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_STEPPING_LONG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_STEPPING_LONG {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_STEPPING_LONG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_STEPPING_LONGLONG {
    pub SteppingDelta: u64,
    pub Bounds: KSPROPERTY_BOUNDS_LONGLONG,
}
impl KSPROPERTY_STEPPING_LONGLONG {}
impl ::std::default::Default for KSPROPERTY_STEPPING_LONGLONG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_STEPPING_LONGLONG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_STEPPING_LONGLONG {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_STEPPING_LONGLONG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_STREAM(pub i32);
pub const KSPROPERTY_STREAM_ALLOCATOR: KSPROPERTY_STREAM = KSPROPERTY_STREAM(0i32);
pub const KSPROPERTY_STREAM_QUALITY: KSPROPERTY_STREAM = KSPROPERTY_STREAM(1i32);
pub const KSPROPERTY_STREAM_DEGRADATION: KSPROPERTY_STREAM = KSPROPERTY_STREAM(2i32);
pub const KSPROPERTY_STREAM_MASTERCLOCK: KSPROPERTY_STREAM = KSPROPERTY_STREAM(3i32);
pub const KSPROPERTY_STREAM_TIMEFORMAT: KSPROPERTY_STREAM = KSPROPERTY_STREAM(4i32);
pub const KSPROPERTY_STREAM_PRESENTATIONTIME: KSPROPERTY_STREAM = KSPROPERTY_STREAM(5i32);
pub const KSPROPERTY_STREAM_PRESENTATIONEXTENT: KSPROPERTY_STREAM = KSPROPERTY_STREAM(6i32);
pub const KSPROPERTY_STREAM_FRAMETIME: KSPROPERTY_STREAM = KSPROPERTY_STREAM(7i32);
pub const KSPROPERTY_STREAM_RATECAPABILITY: KSPROPERTY_STREAM = KSPROPERTY_STREAM(8i32);
pub const KSPROPERTY_STREAM_RATE: KSPROPERTY_STREAM = KSPROPERTY_STREAM(9i32);
pub const KSPROPERTY_STREAM_PIPE_ID: KSPROPERTY_STREAM = KSPROPERTY_STREAM(10i32);
impl ::std::convert::From<i32> for KSPROPERTY_STREAM {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_STREAM {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_STREAMINTERFACE(pub i32);
pub const KSPROPERTY_STREAMINTERFACE_HEADERSIZE: KSPROPERTY_STREAMINTERFACE = KSPROPERTY_STREAMINTERFACE(0i32);
impl ::std::convert::From<i32> for KSPROPERTY_STREAMINTERFACE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_STREAMINTERFACE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TELEPHONY_CONTROL(pub i32);
pub const KSPROPERTY_TELEPHONY_PROVIDERID: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(0i32);
pub const KSPROPERTY_TELEPHONY_CALLINFO: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(1i32);
pub const KSPROPERTY_TELEPHONY_CALLCONTROL: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(2i32);
pub const KSPROPERTY_TELEPHONY_PROVIDERCHANGE: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(3i32);
pub const KSPROPERTY_TELEPHONY_CALLHOLD: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(4i32);
pub const KSPROPERTY_TELEPHONY_MUTE_TX: KSPROPERTY_TELEPHONY_CONTROL = KSPROPERTY_TELEPHONY_CONTROL(5i32);
impl ::std::convert::From<i32> for KSPROPERTY_TELEPHONY_CONTROL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TELEPHONY_CONTROL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TELEPHONY_TOPOLOGY(pub i32);
pub const KSPROPERTY_TELEPHONY_ENDPOINTIDPAIR: KSPROPERTY_TELEPHONY_TOPOLOGY = KSPROPERTY_TELEPHONY_TOPOLOGY(0i32);
pub const KSPROPERTY_TELEPHONY_VOLUME: KSPROPERTY_TELEPHONY_TOPOLOGY = KSPROPERTY_TELEPHONY_TOPOLOGY(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_TELEPHONY_TOPOLOGY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TELEPHONY_TOPOLOGY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TIMECODE(pub i32);
pub const KSPROPERTY_TIMECODE_READER: KSPROPERTY_TIMECODE = KSPROPERTY_TIMECODE(0i32);
pub const KSPROPERTY_ATN_READER: KSPROPERTY_TIMECODE = KSPROPERTY_TIMECODE(1i32);
pub const KSPROPERTY_RTC_READER: KSPROPERTY_TIMECODE = KSPROPERTY_TIMECODE(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_TIMECODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TIMECODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectShow")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Graphics_DirectShow`*"]
pub struct KSPROPERTY_TIMECODE_NODE_S {
    pub NodeProperty: KSP_NODE,
    pub TimecodeSamp: super::super::super::Graphics::DirectShow::TIMECODE_SAMPLE,
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl KSPROPERTY_TIMECODE_NODE_S {}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::default::Default for KSPROPERTY_TIMECODE_NODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::cmp::PartialEq for KSPROPERTY_TIMECODE_NODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::cmp::Eq for KSPROPERTY_TIMECODE_NODE_S {}
#[cfg(feature = "Win32_Graphics_DirectShow")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TIMECODE_NODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectShow")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Graphics_DirectShow`*"]
pub struct KSPROPERTY_TIMECODE_S {
    pub Property: KSIDENTIFIER,
    pub TimecodeSamp: super::super::super::Graphics::DirectShow::TIMECODE_SAMPLE,
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl KSPROPERTY_TIMECODE_S {}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::default::Default for KSPROPERTY_TIMECODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::cmp::PartialEq for KSPROPERTY_TIMECODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_DirectShow")]
impl ::std::cmp::Eq for KSPROPERTY_TIMECODE_S {}
#[cfg(feature = "Win32_Graphics_DirectShow")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TIMECODE_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TOPOLOGY(pub i32);
pub const KSPROPERTY_TOPOLOGY_CATEGORIES: KSPROPERTY_TOPOLOGY = KSPROPERTY_TOPOLOGY(0i32);
pub const KSPROPERTY_TOPOLOGY_NODES: KSPROPERTY_TOPOLOGY = KSPROPERTY_TOPOLOGY(1i32);
pub const KSPROPERTY_TOPOLOGY_CONNECTIONS: KSPROPERTY_TOPOLOGY = KSPROPERTY_TOPOLOGY(2i32);
pub const KSPROPERTY_TOPOLOGY_NAME: KSPROPERTY_TOPOLOGY = KSPROPERTY_TOPOLOGY(3i32);
impl ::std::convert::From<i32> for KSPROPERTY_TOPOLOGY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TOPOLOGY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TOPOLOGYNODE(pub i32);
pub const KSPROPERTY_TOPOLOGYNODE_ENABLE: KSPROPERTY_TOPOLOGYNODE = KSPROPERTY_TOPOLOGYNODE(1i32);
pub const KSPROPERTY_TOPOLOGYNODE_RESET: KSPROPERTY_TOPOLOGYNODE = KSPROPERTY_TOPOLOGYNODE(2i32);
impl ::std::convert::From<i32> for KSPROPERTY_TOPOLOGYNODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TOPOLOGYNODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TUNER(pub i32);
pub const KSPROPERTY_TUNER_CAPS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(0i32);
pub const KSPROPERTY_TUNER_MODE_CAPS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(1i32);
pub const KSPROPERTY_TUNER_MODE: KSPROPERTY_TUNER = KSPROPERTY_TUNER(2i32);
pub const KSPROPERTY_TUNER_STANDARD: KSPROPERTY_TUNER = KSPROPERTY_TUNER(3i32);
pub const KSPROPERTY_TUNER_FREQUENCY: KSPROPERTY_TUNER = KSPROPERTY_TUNER(4i32);
pub const KSPROPERTY_TUNER_INPUT: KSPROPERTY_TUNER = KSPROPERTY_TUNER(5i32);
pub const KSPROPERTY_TUNER_STATUS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(6i32);
pub const KSPROPERTY_TUNER_IF_MEDIUM: KSPROPERTY_TUNER = KSPROPERTY_TUNER(7i32);
pub const KSPROPERTY_TUNER_SCAN_CAPS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(8i32);
pub const KSPROPERTY_TUNER_SCAN_STATUS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(9i32);
pub const KSPROPERTY_TUNER_STANDARD_MODE: KSPROPERTY_TUNER = KSPROPERTY_TUNER(10i32);
pub const KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS: KSPROPERTY_TUNER = KSPROPERTY_TUNER(11i32);
impl ::std::convert::From<i32> for KSPROPERTY_TUNER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub ModesSupported: u32,
    pub VideoMedium: KSIDENTIFIER,
    pub TVAudioMedium: KSIDENTIFIER,
    pub RadioAudioMedium: KSIDENTIFIER,
}
impl KSPROPERTY_TUNER_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_FREQUENCY_S {
    pub Property: KSIDENTIFIER,
    pub Frequency: u32,
    pub LastFrequency: u32,
    pub TuningFlags: u32,
    pub VideoSubChannel: u32,
    pub AudioSubChannel: u32,
    pub Channel: u32,
    pub Country: u32,
}
impl KSPROPERTY_TUNER_FREQUENCY_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_FREQUENCY_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_FREQUENCY_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_FREQUENCY_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_FREQUENCY_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_IF_MEDIUM_S {
    pub Property: KSIDENTIFIER,
    pub IFMedium: KSIDENTIFIER,
}
impl KSPROPERTY_TUNER_IF_MEDIUM_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_IF_MEDIUM_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_IF_MEDIUM_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_IF_MEDIUM_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_IF_MEDIUM_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_INPUT_S {
    pub Property: KSIDENTIFIER,
    pub InputIndex: u32,
}
impl KSPROPERTY_TUNER_INPUT_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_INPUT_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_INPUT_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_INPUT_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_INPUT_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_TUNER_MODES(pub i32);
pub const KSPROPERTY_TUNER_MODE_TV: KSPROPERTY_TUNER_MODES = KSPROPERTY_TUNER_MODES(1i32);
pub const KSPROPERTY_TUNER_MODE_FM_RADIO: KSPROPERTY_TUNER_MODES = KSPROPERTY_TUNER_MODES(2i32);
pub const KSPROPERTY_TUNER_MODE_AM_RADIO: KSPROPERTY_TUNER_MODES = KSPROPERTY_TUNER_MODES(4i32);
pub const KSPROPERTY_TUNER_MODE_DSS: KSPROPERTY_TUNER_MODES = KSPROPERTY_TUNER_MODES(8i32);
pub const KSPROPERTY_TUNER_MODE_ATSC: KSPROPERTY_TUNER_MODES = KSPROPERTY_TUNER_MODES(16i32);
impl ::std::convert::From<i32> for KSPROPERTY_TUNER_MODES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_MODES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_MODE_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub Mode: u32,
    pub StandardsSupported: u32,
    pub MinFrequency: u32,
    pub MaxFrequency: u32,
    pub TuningGranularity: u32,
    pub NumberOfInputs: u32,
    pub SettlingTime: u32,
    pub Strategy: u32,
}
impl KSPROPERTY_TUNER_MODE_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_MODE_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_MODE_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_MODE_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_MODE_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_MODE_S {
    pub Property: KSIDENTIFIER,
    pub Mode: u32,
}
impl KSPROPERTY_TUNER_MODE_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_MODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_MODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_MODE_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_MODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub NetworkType: ::windows::runtime::GUID,
    pub BufferSize: u32,
    pub NetworkTunerCapabilities: *mut ::std::ffi::c_void,
}
impl KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_TUNER_SCAN_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub fSupportsHardwareAssistedScanning: super::super::super::Foundation::BOOL,
    pub SupportedBroadcastStandards: u32,
    pub GUIDBucket: *mut ::std::ffi::c_void,
    pub lengthofBucket: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_TUNER_SCAN_CAPS_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_TUNER_SCAN_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_SCAN_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_TUNER_SCAN_CAPS_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_SCAN_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_SCAN_STATUS_S {
    pub Property: KSIDENTIFIER,
    pub LockStatus: _TunerDecoderLockType,
    pub CurrentFrequency: u32,
}
impl KSPROPERTY_TUNER_SCAN_STATUS_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_SCAN_STATUS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_SCAN_STATUS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_SCAN_STATUS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_SCAN_STATUS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`, `Win32_Foundation`*"]
pub struct KSPROPERTY_TUNER_STANDARD_MODE_S {
    pub Property: KSIDENTIFIER,
    pub AutoDetect: super::super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl KSPROPERTY_TUNER_STANDARD_MODE_S {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for KSPROPERTY_TUNER_STANDARD_MODE_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_STANDARD_MODE_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for KSPROPERTY_TUNER_STANDARD_MODE_S {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_STANDARD_MODE_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_STANDARD_S {
    pub Property: KSIDENTIFIER,
    pub Standard: u32,
}
impl KSPROPERTY_TUNER_STANDARD_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_STANDARD_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_STANDARD_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_STANDARD_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_STANDARD_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TUNER_STATUS_S {
    pub Property: KSIDENTIFIER,
    pub CurrentFrequency: u32,
    pub PLLOffset: u32,
    pub SignalStrength: u32,
    pub Busy: u32,
}
impl KSPROPERTY_TUNER_STATUS_S {}
impl ::std::default::Default for KSPROPERTY_TUNER_STATUS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TUNER_STATUS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TUNER_STATUS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TUNER_STATUS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TVAUDIO_CAPS_S {
    pub Property: KSIDENTIFIER,
    pub Capabilities: u32,
    pub InputMedium: KSIDENTIFIER,
    pub OutputMedium: KSIDENTIFIER,
}
impl KSPROPERTY_TVAUDIO_CAPS_S {}
impl ::std::default::Default for KSPROPERTY_TVAUDIO_CAPS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TVAUDIO_CAPS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TVAUDIO_CAPS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TVAUDIO_CAPS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_TVAUDIO_S {
    pub Property: KSIDENTIFIER,
    pub Mode: u32,
}
impl KSPROPERTY_TVAUDIO_S {}
impl ::std::default::Default for KSPROPERTY_TVAUDIO_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_TVAUDIO_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_TVAUDIO_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_TVAUDIO_S {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_BASICSUPPORT: u32 = 512u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_COPYPAYLOAD: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_DEFAULTVALUES: u32 = 65536u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_FSFILTERSCOPE: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_GET: u32 = 1u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_GETPAYLOADSIZE: u32 = 4u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_HIGHPRIORITY: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_RELATIONS: u32 = 1024u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_SERIALIZERAW: u32 = 8192u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_SERIALIZESET: u32 = 2048u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_SERIALIZESIZE: u32 = 32768u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_SET: u32 = 2u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_SETSUPPORT: u32 = 256u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_TOPOLOGY: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_UNSERIALIZERAW: u32 = 16384u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub const KSPROPERTY_TYPE_UNSERIALIZESET: u32 = 4096u32;
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_VBICAP(pub i32);
pub const KSPROPERTY_VBICAP_PROPERTIES_PROTECTION: KSPROPERTY_VBICAP = KSPROPERTY_VBICAP(1i32);
impl ::std::convert::From<i32> for KSPROPERTY_VBICAP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICAP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct KSPROPERTY_VBICODECFILTERING(pub i32);
pub const KSPROPERTY_VBICODECFILTERING_SCANLINES_REQUESTED_BIT_ARRAY: KSPROPERTY_VBICODECFILTERING = KSPROPERTY_VBICODECFILTERING(1i32);
pub const KSPROPERTY_VBICODECFILTERING_SCANLINES_DISCOVERED_BIT_ARRAY: KSPROPERTY_VBICODECFILTERING = KSPROPERTY_VBICODECFILTERING(2i32);
pub const KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_REQUESTED_BIT_ARRAY: KSPROPERTY_VBICODECFILTERING = KSPROPERTY_VBICODECFILTERING(3i32);
pub const KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_DISCOVERED_BIT_ARRAY: KSPROPERTY_VBICODECFILTERING = KSPROPERTY_VBICODECFILTERING(4i32);
pub const KSPROPERTY_VBICODECFILTERING_STATISTICS: KSPROPERTY_VBICODECFILTERING = KSPROPERTY_VBICODECFILTERING(5i32);
impl ::std::convert::From<i32> for KSPROPERTY_VBICODECFILTERING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {
    pub Property: KSIDENTIFIER,
    pub Substreams: VBICODECFILTERING_CC_SUBSTREAMS,
}
impl KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {
    pub Property: KSIDENTIFIER,
    pub Substreams: VBICODECFILTERING_NABTS_SUBSTREAMS,
}
impl KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_SCANLINES_S {
    pub Property: KSIDENTIFIER,
    pub Scanlines: VBICODECFILTERING_SCANLINES,
}
impl KSPROPERTY_VBICODECFILTERING_SCANLINES_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_SCANLINES_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_SCANLINES_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_SCANLINES_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_SCANLINES_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {
    pub Property: KSIDENTIFIER,
    pub Statistics: VBICODECFILTERING_STATISTICS_CC_PIN,
}
impl KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {
    pub Property: KSIDENTIFIER,
    pub Statistics: VBICODECFILTERING_STATISTICS_CC,
}
impl KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {
    pub Property: KSIDENTIFIER,
    pub Statistics: VBICODECFILTERING_STATISTICS_COMMON_PIN,
}
impl KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {}
unsafe impl ::windows::runtime::Abi for KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Media_Audio_CoreAudio`*"]
pub struct KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S {
    pub Property: KSIDENTIFIER,
    pub Statistics: VBICODECFILTERING_STATISTICS_COMMON,
}
impl KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S {}
impl ::std::default::Default for KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S {
    