#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ADVISE_TYPE(pub u32);
pub const ADVISE_NONE: ADVISE_TYPE = ADVISE_TYPE(0u32);
pub const ADVISE_CLIPPING: ADVISE_TYPE = ADVISE_TYPE(1u32);
pub const ADVISE_PALETTE: ADVISE_TYPE = ADVISE_TYPE(2u32);
pub const ADVISE_COLORKEY: ADVISE_TYPE = ADVISE_TYPE(4u32);
pub const ADVISE_POSITION: ADVISE_TYPE = ADVISE_TYPE(8u32);
pub const ADVISE_DISPLAY_CHANGE: ADVISE_TYPE = ADVISE_TYPE(16u32);
impl ::std::convert::From<u32> for ADVISE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ADVISE_TYPE {
    type Abi = Self;
}
impl ::std::ops::BitOr for ADVISE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ADVISE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ADVISE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ADVISE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ADVISE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ALLOCATOR_PROPERTIES {
    pub cBuffers: i32,
    pub cbBuffer: i32,
    pub cbAlign: i32,
    pub cbPrefix: i32,
}
impl ALLOCATOR_PROPERTIES {}
impl ::std::default::Default for ALLOCATOR_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ALLOCATOR_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ALLOCATOR_PROPERTIES").field("cBuffers", &self.cBuffers).field("cbBuffer", &self.cbBuffer).field("cbAlign", &self.cbAlign).field("cbPrefix", &self.cbPrefix).finish()
    }
}
impl ::std::cmp::PartialEq for ALLOCATOR_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.cBuffers == other.cBuffers && self.cbBuffer == other.cbBuffer && self.cbAlign == other.cbAlign && self.cbPrefix == other.cbPrefix
    }
}
impl ::std::cmp::Eq for ALLOCATOR_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for ALLOCATOR_PROPERTIES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_CoreAudio`*"]
pub struct ALLOCATOR_PROPERTIES_EX {
    pub cBuffers: i32,
    pub cbBuffer: i32,
    pub cbAlign: i32,
    pub cbPrefix: i32,
    pub MemoryType: ::windows::runtime::GUID,
    pub BusType: ::windows::runtime::GUID,
    pub State: PIPE_STATE,
    pub Input: PIPE_TERMINATION,
    pub Output: PIPE_TERMINATION,
    pub Strategy: u32,
    pub Flags: u32,
    pub Weight: u32,
    pub LogicalMemoryType: KS_LogicalMemoryType,
    pub AllocatorPlace: PIPE_ALLOCATOR_PLACE,
    pub Dimensions: PIPE_DIMENSIONS,
    pub PhysicalRange: super::super::Media::Audio::CoreAudio::KS_FRAMING_RANGE,
    pub PrevSegment: *mut IKsAllocatorEx,
    pub CountNextSegments: u32,
    pub NextSegments: *mut *mut IKsAllocatorEx,
    pub InsideFactors: u32,
    pub NumberPins: u32,
}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
impl ALLOCATOR_PROPERTIES_EX {}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
impl ::std::default::Default for ALLOCATOR_PROPERTIES_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
impl ::std::fmt::Debug for ALLOCATOR_PROPERTIES_EX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ALLOCATOR_PROPERTIES_EX")
            .field("cBuffers", &self.cBuffers)
            .field("cbBuffer", &self.cbBuffer)
            .field("cbAlign", &self.cbAlign)
            .field("cbPrefix", &self.cbPrefix)
            .field("MemoryType", &self.MemoryType)
            .field("BusType", &self.BusType)
            .field("State", &self.State)
            .field("Input", &self.Input)
            .field("Output", &self.Output)
            .field("Strategy", &self.Strategy)
            .field("Flags", &self.Flags)
            .field("Weight", &self.Weight)
            .field("LogicalMemoryType", &self.LogicalMemoryType)
            .field("AllocatorPlace", &self.AllocatorPlace)
            .field("Dimensions", &self.Dimensions)
            .field("PhysicalRange", &self.PhysicalRange)
            .field("PrevSegment", &self.PrevSegment)
            .field("CountNextSegments", &self.CountNextSegments)
            .field("NextSegments", &self.NextSegments)
            .field("InsideFactors", &self.InsideFactors)
            .field("NumberPins", &self.NumberPins)
            .finish()
    }
}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
impl ::std::cmp::PartialEq for ALLOCATOR_PROPERTIES_EX {
    fn eq(&self, other: &Self) -> bool {
        self.cBuffers == other.cBuffers
            && self.cbBuffer == other.cbBuffer
            && self.cbAlign == other.cbAlign
            && self.cbPrefix == other.cbPrefix
            && self.MemoryType == other.MemoryType
            && self.BusType == other.BusType
            && self.State == other.State
            && self.Input == other.Input
            && self.Output == other.Output
            && self.Strategy == other.Strategy
            && self.Flags == other.Flags
            && self.Weight == other.Weight
            && self.LogicalMemoryType == other.LogicalMemoryType
            && self.AllocatorPlace == other.AllocatorPlace
            && self.Dimensions == other.Dimensions
            && self.PhysicalRange == other.PhysicalRange
            && self.PrevSegment == other.PrevSegment
            && self.CountNextSegments == other.CountNextSegments
            && self.NextSegments == other.NextSegments
            && self.InsideFactors == other.InsideFactors
            && self.NumberPins == other.NumberPins
    }
}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
impl ::std::cmp::Eq for ALLOCATOR_PROPERTIES_EX {}
#[cfg(feature = "Win32_Media_Audio_CoreAudio")]
unsafe impl ::windows::runtime::Abi for ALLOCATOR_PROPERTIES_EX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMCONTROL_COLORINFO_PRESENT: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMCONTROL_PAD_TO_16x9: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMCONTROL_PAD_TO_4x3: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMCONTROL_USED: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMCOPPCommand {
    pub macKDI: ::windows::runtime::GUID,
    pub guidCommandID: ::windows::runtime::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub CommandData: [u8; 4056],
}
impl AMCOPPCommand {}
impl ::std::default::Default for AMCOPPCommand {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMCOPPCommand {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMCOPPCommand").field("macKDI", &self.macKDI).field("guidCommandID", &self.guidCommandID).field("dwSequence", &self.dwSequence).field("cbSizeData", &self.cbSizeData).field("CommandData", &self.CommandData).finish()
    }
}
impl ::std::cmp::PartialEq for AMCOPPCommand {
    fn eq(&self, other: &Self) -> bool {
        self.macKDI == other.macKDI && self.guidCommandID == other.guidCommandID && self.dwSequence == other.dwSequence && self.cbSizeData == other.cbSizeData && self.CommandData == other.CommandData
    }
}
impl ::std::cmp::Eq for AMCOPPCommand {}
unsafe impl ::windows::runtime::Abi for AMCOPPCommand {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMCOPPSignature {
    pub Signature: [u8; 256],
}
impl AMCOPPSignature {}
impl ::std::default::Default for AMCOPPSignature {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMCOPPSignature {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMCOPPSignature").field("Signature", &self.Signature).finish()
    }
}
impl ::std::cmp::PartialEq for AMCOPPSignature {
    fn eq(&self, other: &Self) -> bool {
        self.Signature == other.Signature
    }
}
impl ::std::cmp::Eq for AMCOPPSignature {}
unsafe impl ::windows::runtime::Abi for AMCOPPSignature {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMCOPPStatusInput {
    pub rApp: ::windows::runtime::GUID,
    pub guidStatusRequestID: ::windows::runtime::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub StatusData: [u8; 4056],
}
impl AMCOPPStatusInput {}
impl ::std::default::Default for AMCOPPStatusInput {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMCOPPStatusInput {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMCOPPStatusInput").field("rApp", &self.rApp).field("guidStatusRequestID", &self.guidStatusRequestID).field("dwSequence", &self.dwSequence).field("cbSizeData", &self.cbSizeData).field("StatusData", &self.StatusData).finish()
    }
}
impl ::std::cmp::PartialEq for AMCOPPStatusInput {
    fn eq(&self, other: &Self) -> bool {
        self.rApp == other.rApp && self.guidStatusRequestID == other.guidStatusRequestID && self.dwSequence == other.dwSequence && self.cbSizeData == other.cbSizeData && self.StatusData == other.StatusData
    }
}
impl ::std::cmp::Eq for AMCOPPStatusInput {}
unsafe impl ::windows::runtime::Abi for AMCOPPStatusInput {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMCOPPStatusOutput {
    pub macKDI: ::windows::runtime::GUID,
    pub cbSizeData: u32,
    pub COPPStatus: [u8; 4076],
}
impl AMCOPPStatusOutput {}
impl ::std::default::Default for AMCOPPStatusOutput {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMCOPPStatusOutput {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMCOPPStatusOutput").field("macKDI", &self.macKDI).field("cbSizeData", &self.cbSizeData).field("COPPStatus", &self.COPPStatus).finish()
    }
}
impl ::std::cmp::PartialEq for AMCOPPStatusOutput {
    fn eq(&self, other: &Self) -> bool {
        self.macKDI == other.macKDI && self.cbSizeData == other.cbSizeData && self.COPPStatus == other.COPPStatus
    }
}
impl ::std::cmp::Eq for AMCOPPStatusOutput {}
unsafe impl ::windows::runtime::Abi for AMCOPPStatusOutput {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMCOPYPROTECT_RestrictDuplication: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_ALL: u32 = 255u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_DCIPS: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_DEFAULT: u32 = 255u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_NONE: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_PS: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_RGBFLP: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_RGBOFF: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_RGBOVR: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_YUVFLP: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_YUVOFF: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMDDS_YUVOVR: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMExtendedSeekingCapabilities(pub i32);
pub const AM_EXSEEK_CANSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(1i32);
pub const AM_EXSEEK_CANSCAN: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(2i32);
pub const AM_EXSEEK_MARKERSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(4i32);
pub const AM_EXSEEK_SCANWITHOUTCLOCK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(8i32);
pub const AM_EXSEEK_NOSTANDARDREPAINT: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(16i32);
pub const AM_EXSEEK_BUFFERING: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(32i32);
pub const AM_EXSEEK_SENDS_VIDEOFRAMEREADY: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(64i32);
impl ::std::convert::From<i32> for AMExtendedSeekingCapabilities {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMExtendedSeekingCapabilities {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMF_AUTOMATICGAIN: f64 = -1f64;
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type AMGETERRORTEXTPROCA = unsafe extern "system" fn(param0: ::windows::runtime::HRESULT, param1: super::super::Foundation::PSTR, param2: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type AMGETERRORTEXTPROCW = unsafe extern "system" fn(param0: ::windows::runtime::HRESULT, param1: super::super::Foundation::PWSTR, param2: u32) -> super::super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AMGetErrorTextA(hr: ::windows::runtime::HRESULT, pbuffer: super::super::Foundation::PSTR, maxlen: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AMGetErrorTextA(hr: ::windows::runtime::HRESULT, pbuffer: super::super::Foundation::PSTR, maxlen: u32) -> u32;
        }
        ::std::mem::transmute(AMGetErrorTextA(::std::mem::transmute(hr), ::std::mem::transmute(pbuffer), ::std::mem::transmute(maxlen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AMGetErrorTextW(hr: ::windows::runtime::HRESULT, pbuffer: super::super::Foundation::PWSTR, maxlen: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AMGetErrorTextW(hr: ::windows::runtime::HRESULT, pbuffer: super::super::Foundation::PWSTR, maxlen: u32) -> u32;
        }
        ::std::mem::transmute(AMGetErrorTextW(::std::mem::transmute(hr), ::std::mem::transmute(pbuffer), ::std::mem::transmute(maxlen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_1FieldPerSample: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_DisplayModeBobOnly: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_DisplayModeBobOrWeave: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_DisplayModeMask: u32 = 192u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_DisplayModeWeaveOnly: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_Field1First: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_FieldPatBothIrregular: u32 = 48u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_FieldPatBothRegular: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_FieldPatField1Only: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_FieldPatField2Only: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_FieldPatternMask: u32 = 48u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_IsInterlaced: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMINTERLACE_UNUSED: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMMSF_MMS_INIT_FLAGS(pub u32);
pub const AMMSF_NOGRAPHTHREAD: AMMSF_MMS_INIT_FLAGS = AMMSF_MMS_INIT_FLAGS(1u32);
impl ::std::convert::From<u32> for AMMSF_MMS_INIT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMMSF_MMS_INIT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AMMSF_MMS_INIT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AMMSF_MMS_INIT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMMSF_MS_FLAGS(pub u32);
pub const AMMSF_ADDDEFAULTRENDERER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(1u32);
pub const AMMSF_CREATEPEER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(2u32);
pub const AMMSF_STOPIFNOSAMPLES: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(4u32);
pub const AMMSF_NOSTALL: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(8u32);
impl ::std::convert::From<u32> for AMMSF_MS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMMSF_MS_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for AMMSF_MS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AMMSF_MS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AMMSF_MS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AMMSF_MS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AMMSF_MS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMMSF_RENDER_FLAGS(pub u32);
pub const AMMSF_RENDERTYPEMASK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(3u32);
pub const AMMSF_RENDERTOEXISTING: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(0u32);
pub const AMMSF_RENDERALLSTREAMS: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(1u32);
pub const AMMSF_NORENDER: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(2u32);
pub const AMMSF_NOCLOCK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(4u32);
pub const AMMSF_RUN: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(8u32);
impl ::std::convert::From<u32> for AMMSF_RENDER_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMMSF_RENDER_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for AMMSF_RENDER_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for AMMSF_RENDER_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMOVERLAYFX(pub i32);
pub const AMOVERFX_NOFX: AMOVERLAYFX = AMOVERLAYFX(0i32);
pub const AMOVERFX_MIRRORLEFTRIGHT: AMOVERLAYFX = AMOVERLAYFX(2i32);
pub const AMOVERFX_MIRRORUPDOWN: AMOVERLAYFX = AMOVERLAYFX(4i32);
pub const AMOVERFX_DEINTERLACE: AMOVERLAYFX = AMOVERLAYFX(8i32);
impl ::std::convert::From<i32> for AMOVERLAYFX {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMOVERLAYFX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMPROPERTY_PIN(pub i32);
pub const AMPROPERTY_PIN_CATEGORY: AMPROPERTY_PIN = AMPROPERTY_PIN(0i32);
pub const AMPROPERTY_PIN_MEDIUM: AMPROPERTY_PIN = AMPROPERTY_PIN(1i32);
impl ::std::convert::From<i32> for AMPROPERTY_PIN {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMPROPERTY_PIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMPlayListEventFlags(pub i32);
pub const AMPLAYLISTEVENT_RESUME: AMPlayListEventFlags = AMPlayListEventFlags(0i32);
pub const AMPLAYLISTEVENT_BREAK: AMPlayListEventFlags = AMPlayListEventFlags(1i32);
pub const AMPLAYLISTEVENT_NEXT: AMPlayListEventFlags = AMPlayListEventFlags(2i32);
pub const AMPLAYLISTEVENT_MASK: AMPlayListEventFlags = AMPlayListEventFlags(15i32);
pub const AMPLAYLISTEVENT_REFRESH: AMPlayListEventFlags = AMPlayListEventFlags(16i32);
impl ::std::convert::From<i32> for AMPlayListEventFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMPlayListEventFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMPlayListFlags(pub i32);
pub const AMPLAYLIST_STARTINSCANMODE: AMPlayListFlags = AMPlayListFlags(1i32);
pub const AMPLAYLIST_FORCEBANNER: AMPlayListFlags = AMPlayListFlags(2i32);
impl ::std::convert::From<i32> for AMPlayListFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMPlayListFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMPlayListItemFlags(pub i32);
pub const AMPLAYLISTITEM_CANSKIP: AMPlayListItemFlags = AMPlayListItemFlags(1i32);
pub const AMPLAYLISTITEM_CANBIND: AMPlayListItemFlags = AMPlayListItemFlags(2i32);
impl ::std::convert::From<i32> for AMPlayListItemFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMPlayListItemFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMTVAudioEventType(pub i32);
pub const AMTVAUDIO_EVENT_CHANGED: AMTVAudioEventType = AMTVAudioEventType(1i32);
impl ::std::convert::From<i32> for AMTVAudioEventType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMTVAudioEventType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMTunerEventType(pub i32);
pub const AMTUNER_EVENT_CHANGED: AMTunerEventType = AMTunerEventType(1i32);
impl ::std::convert::From<i32> for AMTunerEventType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMTunerEventType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMTunerModeType(pub i32);
pub const AMTUNER_MODE_DEFAULT: AMTunerModeType = AMTunerModeType(0i32);
pub const AMTUNER_MODE_TV: AMTunerModeType = AMTunerModeType(1i32);
pub const AMTUNER_MODE_FM_RADIO: AMTunerModeType = AMTunerModeType(2i32);
pub const AMTUNER_MODE_AM_RADIO: AMTunerModeType = AMTunerModeType(4i32);
pub const AMTUNER_MODE_DSS: AMTunerModeType = AMTunerModeType(8i32);
impl ::std::convert::From<i32> for AMTunerModeType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMTunerModeType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMTunerSignalStrength(pub i32);
pub const AMTUNER_HASNOSIGNALSTRENGTH: AMTunerSignalStrength = AMTunerSignalStrength(-1i32);
pub const AMTUNER_NOSIGNAL: AMTunerSignalStrength = AMTunerSignalStrength(0i32);
pub const AMTUNER_SIGNALPRESENT: AMTunerSignalStrength = AMTunerSignalStrength(1i32);
impl ::std::convert::From<i32> for AMTunerSignalStrength {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMTunerSignalStrength {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMTunerSubChannel(pub i32);
pub const AMTUNER_SUBCHAN_NO_TUNE: AMTunerSubChannel = AMTunerSubChannel(-2i32);
pub const AMTUNER_SUBCHAN_DEFAULT: AMTunerSubChannel = AMTunerSubChannel(-1i32);
impl ::std::convert::From<i32> for AMTunerSubChannel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMTunerSubChannel {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMVABUFFERINFO {
    pub dwTypeIndex: u32,
    pub dwBufferIndex: u32,
    pub dwDataOffset: u32,
    pub dwDataSize: u32,
}
impl AMVABUFFERINFO {}
impl ::std::default::Default for AMVABUFFERINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMVABUFFERINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVABUFFERINFO").field("dwTypeIndex", &self.dwTypeIndex).field("dwBufferIndex", &self.dwBufferIndex).field("dwDataOffset", &self.dwDataOffset).field("dwDataSize", &self.dwDataSize).finish()
    }
}
impl ::std::cmp::PartialEq for AMVABUFFERINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwTypeIndex == other.dwTypeIndex && self.dwBufferIndex == other.dwBufferIndex && self.dwDataOffset == other.dwDataOffset && self.dwDataSize == other.dwDataSize
    }
}
impl ::std::cmp::Eq for AMVABUFFERINFO {}
unsafe impl ::windows::runtime::Abi for AMVABUFFERINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMVABeginFrameInfo {
    pub dwDestSurfaceIndex: u32,
    pub pInputData: *mut ::std::ffi::c_void,
    pub dwSizeInputData: u32,
    pub pOutputData: *mut ::std::ffi::c_void,
    pub dwSizeOutputData: u32,
}
impl AMVABeginFrameInfo {}
impl ::std::default::Default for AMVABeginFrameInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMVABeginFrameInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVABeginFrameInfo").field("dwDestSurfaceIndex", &self.dwDestSurfaceIndex).field("pInputData", &self.pInputData).field("dwSizeInputData", &self.dwSizeInputData).field("pOutputData", &self.pOutputData).field("dwSizeOutputData", &self.dwSizeOutputData).finish()
    }
}
impl ::std::cmp::PartialEq for AMVABeginFrameInfo {
    fn eq(&self, other: &Self) -> bool {
        self.dwDestSurfaceIndex == other.dwDestSurfaceIndex && self.pInputData == other.pInputData && self.dwSizeInputData == other.dwSizeInputData && self.pOutputData == other.pOutputData && self.dwSizeOutputData == other.dwSizeOutputData
    }
}
impl ::std::cmp::Eq for AMVABeginFrameInfo {}
unsafe impl ::windows::runtime::Abi for AMVABeginFrameInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
pub struct AMVACompBufferInfo {
    pub dwNumCompBuffers: u32,
    pub dwWidthToCreate: u32,
    pub dwHeightToCreate: u32,
    pub dwBytesToAllocate: u32,
    pub ddCompCaps: super::DirectDraw::DDSCAPS2,
    pub ddPixelFormat: super::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl AMVACompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::default::Default for AMVACompBufferInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::PartialEq for AMVACompBufferInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::Eq for AMVACompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::runtime::Abi for AMVACompBufferInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMVAEndFrameInfo {
    pub dwSizeMiscData: u32,
    pub pMiscData: *mut ::std::ffi::c_void,
}
impl AMVAEndFrameInfo {}
impl ::std::default::Default for AMVAEndFrameInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMVAEndFrameInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVAEndFrameInfo").field("dwSizeMiscData", &self.dwSizeMiscData).field("pMiscData", &self.pMiscData).finish()
    }
}
impl ::std::cmp::PartialEq for AMVAEndFrameInfo {
    fn eq(&self, other: &Self) -> bool {
        self.dwSizeMiscData == other.dwSizeMiscData && self.pMiscData == other.pMiscData
    }
}
impl ::std::cmp::Eq for AMVAEndFrameInfo {}
unsafe impl ::windows::runtime::Abi for AMVAEndFrameInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMVAInternalMemInfo {
    pub dwScratchMemAlloc: u32,
}
impl AMVAInternalMemInfo {}
impl ::std::default::Default for AMVAInternalMemInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMVAInternalMemInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVAInternalMemInfo").field("dwScratchMemAlloc", &self.dwScratchMemAlloc).finish()
    }
}
impl ::std::cmp::PartialEq for AMVAInternalMemInfo {
    fn eq(&self, other: &Self) -> bool {
        self.dwScratchMemAlloc == other.dwScratchMemAlloc
    }
}
impl ::std::cmp::Eq for AMVAInternalMemInfo {}
unsafe impl ::windows::runtime::Abi for AMVAInternalMemInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
pub struct AMVAUncompBufferInfo {
    pub dwMinNumSurfaces: u32,
    pub dwMaxNumSurfaces: u32,
    pub ddUncompPixelFormat: super::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl AMVAUncompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::default::Default for AMVAUncompBufferInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::PartialEq for AMVAUncompBufferInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::Eq for AMVAUncompBufferInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::runtime::Abi for AMVAUncompBufferInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
pub struct AMVAUncompDataInfo {
    pub dwUncompWidth: u32,
    pub dwUncompHeight: u32,
    pub ddUncompPixelFormat: super::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl AMVAUncompDataInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::default::Default for AMVAUncompDataInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::PartialEq for AMVAUncompDataInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl ::std::cmp::Eq for AMVAUncompDataInfo {}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
unsafe impl ::windows::runtime::Abi for AMVAUncompDataInfo {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMVA_QUERYRENDERSTATUSF_READ: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AMVA_TYPEINDEX_OUTPUTFRAME: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AMVPDATAINFO {
    pub dwSize: u32,
    pub dwMicrosecondsPerField: u32,
    pub amvpDimInfo: AMVPDIMINFO,
    pub dwPictAspectRatioX: u32,
    pub dwPictAspectRatioY: u32,
    pub bEnableDoubleClock: super::super::Foundation::BOOL,
    pub bEnableVACT: super::super::Foundation::BOOL,
    pub bDataIsInterlaced: super::super::Foundation::BOOL,
    pub lHalfLinesOdd: i32,
    pub bFieldPolarityInverted: super::super::Foundation::BOOL,
    pub dwNumLinesInVREF: u32,
    pub lHalfLinesEven: i32,
    pub dwReserved1: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl AMVPDATAINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMVPDATAINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMVPDATAINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVPDATAINFO")
            .field("dwSize", &self.dwSize)
            .field("dwMicrosecondsPerField", &self.dwMicrosecondsPerField)
            .field("amvpDimInfo", &self.amvpDimInfo)
            .field("dwPictAspectRatioX", &self.dwPictAspectRatioX)
            .field("dwPictAspectRatioY", &self.dwPictAspectRatioY)
            .field("bEnableDoubleClock", &self.bEnableDoubleClock)
            .field("bEnableVACT", &self.bEnableVACT)
            .field("bDataIsInterlaced", &self.bDataIsInterlaced)
            .field("lHalfLinesOdd", &self.lHalfLinesOdd)
            .field("bFieldPolarityInverted", &self.bFieldPolarityInverted)
            .field("dwNumLinesInVREF", &self.dwNumLinesInVREF)
            .field("lHalfLinesEven", &self.lHalfLinesEven)
            .field("dwReserved1", &self.dwReserved1)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMVPDATAINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwMicrosecondsPerField == other.dwMicrosecondsPerField
            && self.amvpDimInfo == other.amvpDimInfo
            && self.dwPictAspectRatioX == other.dwPictAspectRatioX
            && self.dwPictAspectRatioY == other.dwPictAspectRatioY
            && self.bEnableDoubleClock == other.bEnableDoubleClock
            && self.bEnableVACT == other.bEnableVACT
            && self.bDataIsInterlaced == other.bDataIsInterlaced
            && self.lHalfLinesOdd == other.lHalfLinesOdd
            && self.bFieldPolarityInverted == other.bFieldPolarityInverted
            && self.dwNumLinesInVREF == other.dwNumLinesInVREF
            && self.lHalfLinesEven == other.lHalfLinesEven
            && self.dwReserved1 == other.dwReserved1
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMVPDATAINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMVPDATAINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AMVPDIMINFO {
    pub dwFieldWidth: u32,
    pub dwFieldHeight: u32,
    pub dwVBIWidth: u32,
    pub dwVBIHeight: u32,
    pub rcValidRegion: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl AMVPDIMINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AMVPDIMINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AMVPDIMINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVPDIMINFO").field("dwFieldWidth", &self.dwFieldWidth).field("dwFieldHeight", &self.dwFieldHeight).field("dwVBIWidth", &self.dwVBIWidth).field("dwVBIHeight", &self.dwVBIHeight).field("rcValidRegion", &self.rcValidRegion).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AMVPDIMINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFieldWidth == other.dwFieldWidth && self.dwFieldHeight == other.dwFieldHeight && self.dwVBIWidth == other.dwVBIWidth && self.dwVBIHeight == other.dwVBIHeight && self.rcValidRegion == other.rcValidRegion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AMVPDIMINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AMVPDIMINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AMVPSIZE {
    pub dwWidth: u32,
    pub dwHeight: u32,
}
impl AMVPSIZE {}
impl ::std::default::Default for AMVPSIZE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AMVPSIZE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AMVPSIZE").field("dwWidth", &self.dwWidth).field("dwHeight", &self.dwHeight).finish()
    }
}
impl ::std::cmp::PartialEq for AMVPSIZE {
    fn eq(&self, other: &Self) -> bool {
        self.dwWidth == other.dwWidth && self.dwHeight == other.dwHeight
    }
}
impl ::std::cmp::Eq for AMVPSIZE {}
unsafe impl ::windows::runtime::Abi for AMVPSIZE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMVP_MODE(pub i32);
pub const AMVP_MODE_WEAVE: AMVP_MODE = AMVP_MODE(0i32);
pub const AMVP_MODE_BOBINTERLEAVED: AMVP_MODE = AMVP_MODE(1i32);
pub const AMVP_MODE_BOBNONINTERLEAVED: AMVP_MODE = AMVP_MODE(2i32);
pub const AMVP_MODE_SKIPEVEN: AMVP_MODE = AMVP_MODE(3i32);
pub const AMVP_MODE_SKIPODD: AMVP_MODE = AMVP_MODE(4i32);
impl ::std::convert::From<i32> for AMVP_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMVP_MODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AMVP_SELECT_FORMAT_BY(pub i32);
pub const AMVP_DO_NOT_CARE: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(0i32);
pub const AMVP_BEST_BANDWIDTH: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(1i32);
pub const AMVP_INPUT_SAME_AS_OUTPUT: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(2i32);
impl ::std::convert::From<i32> for AMVP_SELECT_FORMAT_BY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AMVP_SELECT_FORMAT_BY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_AC3_ALTERNATE_AUDIO {
    pub fStereo: super::super::Foundation::BOOL,
    pub DualMode: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_AC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_AC3_ALTERNATE_AUDIO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_AC3_ALTERNATE_AUDIO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_ALTERNATE_AUDIO").field("fStereo", &self.fStereo).field("DualMode", &self.DualMode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_AC3_ALTERNATE_AUDIO {
    fn eq(&self, other: &Self) -> bool {
        self.fStereo == other.fStereo && self.DualMode == other.DualMode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_AC3_ALTERNATE_AUDIO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_AC3_ALTERNATE_AUDIO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_ALTERNATE_AUDIO_1: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_ALTERNATE_AUDIO_2: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_ALTERNATE_AUDIO_BOTH: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_AC3_BIT_STREAM_MODE {
    pub BitStreamMode: i32,
}
impl AM_AC3_BIT_STREAM_MODE {}
impl ::std::default::Default for AM_AC3_BIT_STREAM_MODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_AC3_BIT_STREAM_MODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_BIT_STREAM_MODE").field("BitStreamMode", &self.BitStreamMode).finish()
    }
}
impl ::std::cmp::PartialEq for AM_AC3_BIT_STREAM_MODE {
    fn eq(&self, other: &Self) -> bool {
        self.BitStreamMode == other.BitStreamMode
    }
}
impl ::std::cmp::Eq for AM_AC3_BIT_STREAM_MODE {}
unsafe impl ::windows::runtime::Abi for AM_AC3_BIT_STREAM_MODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_AC3_DIALOGUE_LEVEL {
    pub DialogueLevel: u32,
}
impl AM_AC3_DIALOGUE_LEVEL {}
impl ::std::default::Default for AM_AC3_DIALOGUE_LEVEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_AC3_DIALOGUE_LEVEL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_DIALOGUE_LEVEL").field("DialogueLevel", &self.DialogueLevel).finish()
    }
}
impl ::std::cmp::PartialEq for AM_AC3_DIALOGUE_LEVEL {
    fn eq(&self, other: &Self) -> bool {
        self.DialogueLevel == other.DialogueLevel
    }
}
impl ::std::cmp::Eq for AM_AC3_DIALOGUE_LEVEL {}
unsafe impl ::windows::runtime::Abi for AM_AC3_DIALOGUE_LEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_AC3_DOWNMIX {
    pub fDownMix: super::super::Foundation::BOOL,
    pub fDolbySurround: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_AC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_AC3_DOWNMIX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_AC3_DOWNMIX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_DOWNMIX").field("fDownMix", &self.fDownMix).field("fDolbySurround", &self.fDolbySurround).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_AC3_DOWNMIX {
    fn eq(&self, other: &Self) -> bool {
        self.fDownMix == other.fDownMix && self.fDolbySurround == other.fDolbySurround
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_AC3_DOWNMIX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_AC3_DOWNMIX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_AC3_ERROR_CONCEALMENT {
    pub fRepeatPreviousBlock: super::super::Foundation::BOOL,
    pub fErrorInCurrentBlock: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_AC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_AC3_ERROR_CONCEALMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_AC3_ERROR_CONCEALMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_ERROR_CONCEALMENT").field("fRepeatPreviousBlock", &self.fRepeatPreviousBlock).field("fErrorInCurrentBlock", &self.fErrorInCurrentBlock).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_AC3_ERROR_CONCEALMENT {
    fn eq(&self, other: &Self) -> bool {
        self.fRepeatPreviousBlock == other.fRepeatPreviousBlock && self.fErrorInCurrentBlock == other.fErrorInCurrentBlock
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_AC3_ERROR_CONCEALMENT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_AC3_ERROR_CONCEALMENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_AC3_ROOM_TYPE {
    pub fLargeRoom: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_AC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_AC3_ROOM_TYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_AC3_ROOM_TYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_AC3_ROOM_TYPE").field("fLargeRoom", &self.fLargeRoom).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_AC3_ROOM_TYPE {
    fn eq(&self, other: &Self) -> bool {
        self.fLargeRoom == other.fLargeRoom
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_AC3_ROOM_TYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_AC3_ROOM_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_COMMENTARY: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_DIALOG_ONLY: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_EMERGENCY_FLASH: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_HEARING_IMPAIRED: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_MAIN_AUDIO: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_NO_DIALOG: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_VISUALLY_IMPAIRED: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_AC3_SERVICE_VOICE_OVER: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_ASPECT_RATIO_MODE(pub i32);
pub const AM_ARMODE_STRETCHED: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(0i32);
pub const AM_ARMODE_LETTER_BOX: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(1i32);
pub const AM_ARMODE_CROP: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(2i32);
pub const AM_ARMODE_STRETCHED_AS_PRIMARY: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(3i32);
impl ::std::convert::From<i32> for AM_ASPECT_RATIO_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_ASPECT_RATIO_MODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_COLCON {
    pub _bitfield1: u8,
    pub _bitfield2: u8,
    pub _bitfield3: u8,
    pub _bitfield4: u8,
}
impl AM_COLCON {}
impl ::std::default::Default for AM_COLCON {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_COLCON {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_COLCON").field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).field("_bitfield3", &self._bitfield3).field("_bitfield4", &self._bitfield4).finish()
    }
}
impl ::std::cmp::PartialEq for AM_COLCON {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2 && self._bitfield3 == other._bitfield3 && self._bitfield4 == other._bitfield4
    }
}
impl ::std::cmp::Eq for AM_COLCON {}
unsafe impl ::windows::runtime::Abi for AM_COLCON {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_CONTENTPROPERTY_AUTHOR: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_CONTENTPROPERTY_COPYRIGHT: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_CONTENTPROPERTY_DESCRIPTION: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_CONTENTPROPERTY_TITLE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_COPY_MACROVISION {
    pub MACROVISIONLevel: u32,
}
impl AM_COPY_MACROVISION {}
impl ::std::default::Default for AM_COPY_MACROVISION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_COPY_MACROVISION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_COPY_MACROVISION").field("MACROVISIONLevel", &self.MACROVISIONLevel).finish()
    }
}
impl ::std::cmp::PartialEq for AM_COPY_MACROVISION {
    fn eq(&self, other: &Self) -> bool {
        self.MACROVISIONLevel == other.MACROVISIONLevel
    }
}
impl ::std::cmp::Eq for AM_COPY_MACROVISION {}
unsafe impl ::windows::runtime::Abi for AM_COPY_MACROVISION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_COPY_MACROVISION_LEVEL(pub i32);
pub const AM_MACROVISION_DISABLED: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(0i32);
pub const AM_MACROVISION_LEVEL1: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(1i32);
pub const AM_MACROVISION_LEVEL2: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(2i32);
pub const AM_MACROVISION_LEVEL3: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(3i32);
impl ::std::convert::From<i32> for AM_COPY_MACROVISION_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_COPY_MACROVISION_LEVEL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_DIGITAL_CP(pub i32);
pub const AM_DIGITAL_CP_OFF: AM_DIGITAL_CP = AM_DIGITAL_CP(0i32);
pub const AM_DIGITAL_CP_ON: AM_DIGITAL_CP = AM_DIGITAL_CP(1i32);
pub const AM_DIGITAL_CP_DVD_COMPLIANT: AM_DIGITAL_CP = AM_DIGITAL_CP(2i32);
impl ::std::convert::From<i32> for AM_DIGITAL_CP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_DIGITAL_CP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_DVDCOPYSTATE(pub i32);
pub const AM_DVDCOPYSTATE_INITIALIZE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(0i32);
pub const AM_DVDCOPYSTATE_INITIALIZE_TITLE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(1i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(2i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(3i32);
pub const AM_DVDCOPYSTATE_DONE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(4i32);
impl ::std::convert::From<i32> for AM_DVDCOPYSTATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPYSTATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVDCOPY_BUSKEY {
    pub BusKey: [u8; 5],
    pub Reserved: [u8; 1],
}
impl AM_DVDCOPY_BUSKEY {}
impl ::std::default::Default for AM_DVDCOPY_BUSKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVDCOPY_BUSKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVDCOPY_BUSKEY").field("BusKey", &self.BusKey).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVDCOPY_BUSKEY {
    fn eq(&self, other: &Self) -> bool {
        self.BusKey == other.BusKey && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for AM_DVDCOPY_BUSKEY {}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPY_BUSKEY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVDCOPY_CHLGKEY {
    pub ChlgKey: [u8; 10],
    pub Reserved: [u8; 2],
}
impl AM_DVDCOPY_CHLGKEY {}
impl ::std::default::Default for AM_DVDCOPY_CHLGKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVDCOPY_CHLGKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVDCOPY_CHLGKEY").field("ChlgKey", &self.ChlgKey).field("Reserved", &self.Reserved).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVDCOPY_CHLGKEY {
    fn eq(&self, other: &Self) -> bool {
        self.ChlgKey == other.ChlgKey && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for AM_DVDCOPY_CHLGKEY {}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPY_CHLGKEY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVDCOPY_DISCKEY {
    pub DiscKey: [u8; 2048],
}
impl AM_DVDCOPY_DISCKEY {}
impl ::std::default::Default for AM_DVDCOPY_DISCKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVDCOPY_DISCKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVDCOPY_DISCKEY").field("DiscKey", &self.DiscKey).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVDCOPY_DISCKEY {
    fn eq(&self, other: &Self) -> bool {
        self.DiscKey == other.DiscKey
    }
}
impl ::std::cmp::Eq for AM_DVDCOPY_DISCKEY {}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPY_DISCKEY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVDCOPY_SET_COPY_STATE {
    pub DVDCopyState: u32,
}
impl AM_DVDCOPY_SET_COPY_STATE {}
impl ::std::default::Default for AM_DVDCOPY_SET_COPY_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVDCOPY_SET_COPY_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVDCOPY_SET_COPY_STATE").field("DVDCopyState", &self.DVDCopyState).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVDCOPY_SET_COPY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.DVDCopyState == other.DVDCopyState
    }
}
impl ::std::cmp::Eq for AM_DVDCOPY_SET_COPY_STATE {}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPY_SET_COPY_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVDCOPY_TITLEKEY {
    pub KeyFlags: u32,
    pub Reserved1: [u32; 2],
    pub TitleKey: [u8; 6],
    pub Reserved2: [u8; 2],
}
impl AM_DVDCOPY_TITLEKEY {}
impl ::std::default::Default for AM_DVDCOPY_TITLEKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVDCOPY_TITLEKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVDCOPY_TITLEKEY").field("KeyFlags", &self.KeyFlags).field("Reserved1", &self.Reserved1).field("TitleKey", &self.TitleKey).field("Reserved2", &self.Reserved2).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVDCOPY_TITLEKEY {
    fn eq(&self, other: &Self) -> bool {
        self.KeyFlags == other.KeyFlags && self.Reserved1 == other.Reserved1 && self.TitleKey == other.TitleKey && self.Reserved2 == other.Reserved2
    }
}
impl ::std::cmp::Eq for AM_DVDCOPY_TITLEKEY {}
unsafe impl ::windows::runtime::Abi for AM_DVDCOPY_TITLEKEY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_CGMS_COPY_ONCE: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_CGMS_COPY_PERMITTED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_CGMS_COPY_PROTECT_MASK: u32 = 24u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_CGMS_NO_COPY: u32 = 24u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_CGMS_RESERVED_MASK: u32 = 120u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_COPYRIGHTED: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_COPYRIGHT_MASK: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVD_ChangeRate {
    pub StartInTime: i64,
    pub StartOutTime: i64,
    pub Rate: i32,
}
impl AM_DVD_ChangeRate {}
impl ::std::default::Default for AM_DVD_ChangeRate {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVD_ChangeRate {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVD_ChangeRate").field("StartInTime", &self.StartInTime).field("StartOutTime", &self.StartOutTime).field("Rate", &self.Rate).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVD_ChangeRate {
    fn eq(&self, other: &Self) -> bool {
        self.StartInTime == other.StartInTime && self.StartOutTime == other.StartOutTime && self.Rate == other.Rate
    }
}
impl ::std::cmp::Eq for AM_DVD_ChangeRate {}
unsafe impl ::windows::runtime::Abi for AM_DVD_ChangeRate {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_DVD_GRAPH_FLAGS(pub i32);
pub const AM_DVD_HWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(1i32);
pub const AM_DVD_HWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2i32);
pub const AM_DVD_SWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4i32);
pub const AM_DVD_SWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8i32);
pub const AM_DVD_NOVPE: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(256i32);
pub const AM_DVD_DO_NOT_CLEAR: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(512i32);
pub const AM_DVD_VMR9_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2048i32);
pub const AM_DVD_EVR_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4096i32);
pub const AM_DVD_EVR_QOS: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8192i32);
pub const AM_DVD_ADAPT_GRAPH: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(16384i32);
pub const AM_DVD_MASK: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(65535i32);
impl ::std::convert::From<i32> for AM_DVD_GRAPH_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_DVD_GRAPH_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_NOT_COPYRIGHTED: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_DVD_RENDERSTATUS {
    pub hrVPEStatus: ::windows::runtime::HRESULT,
    pub bDvdVolInvalid: super::super::Foundation::BOOL,
    pub bDvdVolUnknown: super::super::Foundation::BOOL,
    pub bNoLine21In: super::super::Foundation::BOOL,
    pub bNoLine21Out: super::super::Foundation::BOOL,
    pub iNumStreams: i32,
    pub iNumStreamsFailed: i32,
    pub dwFailedStreamsFlag: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_DVD_RENDERSTATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_DVD_RENDERSTATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_DVD_RENDERSTATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVD_RENDERSTATUS")
            .field("hrVPEStatus", &self.hrVPEStatus)
            .field("bDvdVolInvalid", &self.bDvdVolInvalid)
            .field("bDvdVolUnknown", &self.bDvdVolUnknown)
            .field("bNoLine21In", &self.bNoLine21In)
            .field("bNoLine21Out", &self.bNoLine21Out)
            .field("iNumStreams", &self.iNumStreams)
            .field("iNumStreamsFailed", &self.iNumStreamsFailed)
            .field("dwFailedStreamsFlag", &self.dwFailedStreamsFlag)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_DVD_RENDERSTATUS {
    fn eq(&self, other: &Self) -> bool {
        self.hrVPEStatus == other.hrVPEStatus && self.bDvdVolInvalid == other.bDvdVolInvalid && self.bDvdVolUnknown == other.bDvdVolUnknown && self.bNoLine21In == other.bNoLine21In && self.bNoLine21Out == other.bNoLine21Out && self.iNumStreams == other.iNumStreams && self.iNumStreamsFailed == other.iNumStreamsFailed && self.dwFailedStreamsFlag == other.dwFailedStreamsFlag
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_DVD_RENDERSTATUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_DVD_RENDERSTATUS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_SECTOR_NOT_PROTECTED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_SECTOR_PROTECTED: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_DVD_SECTOR_PROTECT_MASK: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_DVD_STREAM_FLAGS(pub i32);
pub const AM_DVD_STREAM_VIDEO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(1i32);
pub const AM_DVD_STREAM_AUDIO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(2i32);
pub const AM_DVD_STREAM_SUBPIC: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(4i32);
impl ::std::convert::From<i32> for AM_DVD_STREAM_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_DVD_STREAM_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DVD_YUV {
    pub Reserved: u8,
    pub Y: u8,
    pub U: u8,
    pub V: u8,
}
impl AM_DVD_YUV {}
impl ::std::default::Default for AM_DVD_YUV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DVD_YUV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DVD_YUV").field("Reserved", &self.Reserved).field("Y", &self.Y).field("U", &self.U).field("V", &self.V).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DVD_YUV {
    fn eq(&self, other: &Self) -> bool {
        self.Reserved == other.Reserved && self.Y == other.Y && self.U == other.U && self.V == other.V
    }
}
impl ::std::cmp::Eq for AM_DVD_YUV {}
unsafe impl ::windows::runtime::Abi for AM_DVD_YUV {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_DvdKaraokeData {
    pub dwDownmix: u32,
    pub dwSpeakerAssignment: u32,
}
impl AM_DvdKaraokeData {}
impl ::std::default::Default for AM_DvdKaraokeData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_DvdKaraokeData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_DvdKaraokeData").field("dwDownmix", &self.dwDownmix).field("dwSpeakerAssignment", &self.dwSpeakerAssignment).finish()
    }
}
impl ::std::cmp::PartialEq for AM_DvdKaraokeData {
    fn eq(&self, other: &Self) -> bool {
        self.dwDownmix == other.dwDownmix && self.dwSpeakerAssignment == other.dwSpeakerAssignment
    }
}
impl ::std::cmp::Eq for AM_DvdKaraokeData {}
unsafe impl ::windows::runtime::Abi for AM_DvdKaraokeData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_ExactRateChange {
    pub OutputZeroTime: i64,
    pub Rate: i32,
}
impl AM_ExactRateChange {}
impl ::std::default::Default for AM_ExactRateChange {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_ExactRateChange {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_ExactRateChange").field("OutputZeroTime", &self.OutputZeroTime).field("Rate", &self.Rate).finish()
    }
}
impl ::std::cmp::PartialEq for AM_ExactRateChange {
    fn eq(&self, other: &Self) -> bool {
        self.OutputZeroTime == other.OutputZeroTime && self.Rate == other.Rate
    }
}
impl ::std::cmp::Eq for AM_ExactRateChange {}
unsafe impl ::windows::runtime::Abi for AM_ExactRateChange {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_FILESINK_FLAGS(pub i32);
pub const AM_FILE_OVERWRITE: AM_FILESINK_FLAGS = AM_FILESINK_FLAGS(1i32);
impl ::std::convert::From<i32> for AM_FILESINK_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_FILESINK_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_FILTER_FLAGS(pub i32);
pub const AM_FILTER_FLAGS_REMOVABLE: AM_FILTER_FLAGS = AM_FILTER_FLAGS(1i32);
impl ::std::convert::From<i32> for AM_FILTER_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_FILTER_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_FRAMESTEP_STEP {
    pub dwFramesToStep: u32,
}
impl AM_FRAMESTEP_STEP {}
impl ::std::default::Default for AM_FRAMESTEP_STEP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_FRAMESTEP_STEP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_FRAMESTEP_STEP").field("dwFramesToStep", &self.dwFramesToStep).finish()
    }
}
impl ::std::cmp::PartialEq for AM_FRAMESTEP_STEP {
    fn eq(&self, other: &Self) -> bool {
        self.dwFramesToStep == other.dwFramesToStep
    }
}
impl ::std::cmp::Eq for AM_FRAMESTEP_STEP {}
unsafe impl ::windows::runtime::Abi for AM_FRAMESTEP_STEP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GBF_NODDSURFACELOCK: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GBF_NOTASYNCPOINT: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GBF_NOWAIT: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GBF_PREVFRAMESKIPPED: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GETDECODERCAP_QUERY_EVR_SUPPORT: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GETDECODERCAP_QUERY_VMR9_SUPPORT: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_GETDECODERCAP_QUERY_VMR_SUPPORT: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_GRAPH_CONFIG_RECONNECT_FLAGS(pub i32);
pub const AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(1i32);
pub const AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(2i32);
pub const AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(4i32);
impl ::std::convert::From<i32> for AM_GRAPH_CONFIG_RECONNECT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_GRAPH_CONFIG_RECONNECT_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_LINE21_CCLEVEL(pub i32);
pub const AM_L21_CCLEVEL_TC2: AM_LINE21_CCLEVEL = AM_LINE21_CCLEVEL(0i32);
impl ::std::convert::From<i32> for AM_LINE21_CCLEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_LINE21_CCLEVEL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_LINE21_CCSERVICE(pub i32);
pub const AM_L21_CCSERVICE_None: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(0i32);
pub const AM_L21_CCSERVICE_Caption1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(1i32);
pub const AM_L21_CCSERVICE_Caption2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(2i32);
pub const AM_L21_CCSERVICE_Text1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(3i32);
pub const AM_L21_CCSERVICE_Text2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(4i32);
pub const AM_L21_CCSERVICE_XDS: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(5i32);
pub const AM_L21_CCSERVICE_DefChannel: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(10i32);
pub const AM_L21_CCSERVICE_Invalid: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(11i32);
impl ::std::convert::From<i32> for AM_LINE21_CCSERVICE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_LINE21_CCSERVICE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_LINE21_CCSTATE(pub i32);
pub const AM_L21_CCSTATE_Off: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(0i32);
pub const AM_L21_CCSTATE_On: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(1i32);
impl ::std::convert::From<i32> for AM_LINE21_CCSTATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_LINE21_CCSTATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_LINE21_CCSTYLE(pub i32);
pub const AM_L21_CCSTYLE_None: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(0i32);
pub const AM_L21_CCSTYLE_PopOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(1i32);
pub const AM_L21_CCSTYLE_PaintOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(2i32);
pub const AM_L21_CCSTYLE_RollUp: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(3i32);
impl ::std::convert::From<i32> for AM_LINE21_CCSTYLE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_LINE21_CCSTYLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_LINE21_DRAWBGMODE(pub i32);
pub const AM_L21_DRAWBGMODE_Opaque: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(0i32);
pub const AM_L21_DRAWBGMODE_Transparent: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(1i32);
impl ::std::convert::From<i32> for AM_LINE21_DRAWBGMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_LINE21_DRAWBGMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_CLOSED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_CONNECTING: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_LOADINGDESCR: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_LOADINGMCAST: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_LOCATING: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_OPEN: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_LOADSTATUS_OPENING: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_MEDIAEVENT_FLAGS(pub i32);
pub const AM_MEDIAEVENT_NONOTIFY: AM_MEDIAEVENT_FLAGS = AM_MEDIAEVENT_FLAGS(1i32);
impl ::std::convert::From<i32> for AM_MEDIAEVENT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_MEDIAEVENT_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_MEDIA_TYPE {
    pub majortype: ::windows::runtime::GUID,
    pub subtype: ::windows::runtime::GUID,
    pub bFixedSizeSamples: super::super::Foundation::BOOL,
    pub bTemporalCompression: super::super::Foundation::BOOL,
    pub lSampleSize: u32,
    pub formattype: ::windows::runtime::GUID,
    pub pUnk: ::std::option::Option<::windows::runtime::IUnknown>,
    pub cbFormat: u32,
    pub pbFormat: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_MEDIA_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_MEDIA_TYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_MEDIA_TYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_MEDIA_TYPE")
            .field("majortype", &self.majortype)
            .field("subtype", &self.subtype)
            .field("bFixedSizeSamples", &self.bFixedSizeSamples)
            .field("bTemporalCompression", &self.bTemporalCompression)
            .field("lSampleSize", &self.lSampleSize)
            .field("formattype", &self.formattype)
            .field("pUnk", &self.pUnk)
            .field("cbFormat", &self.cbFormat)
            .field("pbFormat", &self.pbFormat)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_MEDIA_TYPE {
    fn eq(&self, other: &Self) -> bool {
        self.majortype == other.majortype && self.subtype == other.subtype && self.bFixedSizeSamples == other.bFixedSizeSamples && self.bTemporalCompression == other.bTemporalCompression && self.lSampleSize == other.lSampleSize && self.formattype == other.formattype && self.pUnk == other.pUnk && self.cbFormat == other.cbFormat && self.pbFormat == other.pbFormat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_MEDIA_TYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_MEDIA_TYPE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_MPEG2Level(pub i32);
pub const AM_MPEG2Level_Low: AM_MPEG2Level = AM_MPEG2Level(1i32);
pub const AM_MPEG2Level_Main: AM_MPEG2Level = AM_MPEG2Level(2i32);
pub const AM_MPEG2Level_High1440: AM_MPEG2Level = AM_MPEG2Level(3i32);
pub const AM_MPEG2Level_High: AM_MPEG2Level = AM_MPEG2Level(4i32);
impl ::std::convert::From<i32> for AM_MPEG2Level {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_MPEG2Level {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_MPEG2Profile(pub i32);
pub const AM_MPEG2Profile_Simple: AM_MPEG2Profile = AM_MPEG2Profile(1i32);
pub const AM_MPEG2Profile_Main: AM_MPEG2Profile = AM_MPEG2Profile(2i32);
pub const AM_MPEG2Profile_SNRScalable: AM_MPEG2Profile = AM_MPEG2Profile(3i32);
pub const AM_MPEG2Profile_SpatiallyScalable: AM_MPEG2Profile = AM_MPEG2Profile(4i32);
pub const AM_MPEG2Profile_High: AM_MPEG2Profile = AM_MPEG2Profile(5i32);
impl ::std::convert::From<i32> for AM_MPEG2Profile {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_MPEG2Profile {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_MPEGSTREAMTYPE {
    pub dwStreamId: u32,
    pub dwReserved: u32,
    pub mt: AM_MEDIA_TYPE,
    pub bFormat: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl AM_MPEGSTREAMTYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_MPEGSTREAMTYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_MPEGSTREAMTYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_MPEGSTREAMTYPE").field("dwStreamId", &self.dwStreamId).field("dwReserved", &self.dwReserved).field("mt", &self.mt).field("bFormat", &self.bFormat).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_MPEGSTREAMTYPE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStreamId == other.dwStreamId && self.dwReserved == other.dwReserved && self.mt == other.mt && self.bFormat == other.bFormat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_MPEGSTREAMTYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_MPEGSTREAMTYPE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_MPEGSYSTEMTYPE {
    pub dwBitRate: u32,
    pub cStreams: u32,
    pub Streams: [AM_MPEGSTREAMTYPE; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl AM_MPEGSYSTEMTYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_MPEGSYSTEMTYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_MPEGSYSTEMTYPE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_MPEGSYSTEMTYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_MPEGSYSTEMTYPE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_MPEG_AUDIO_DUAL_LEFT: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_MPEG_AUDIO_DUAL_MERGE: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_MPEG_AUDIO_DUAL_RIGHT: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_AC3(pub i32);
pub const AM_PROPERTY_AC3_ERROR_CONCEALMENT: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(1i32);
pub const AM_PROPERTY_AC3_ALTERNATE_AUDIO: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(2i32);
pub const AM_PROPERTY_AC3_DOWNMIX: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(3i32);
pub const AM_PROPERTY_AC3_BIT_STREAM_MODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(4i32);
pub const AM_PROPERTY_AC3_DIALOGUE_LEVEL: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(5i32);
pub const AM_PROPERTY_AC3_LANGUAGE_CODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(6i32);
pub const AM_PROPERTY_AC3_ROOM_TYPE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(7i32);
impl ::std::convert::From<i32> for AM_PROPERTY_AC3 {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_AC3 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_DVDCOPYPROT(pub i32);
pub const AM_PROPERTY_DVDCOPY_CHLG_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(1i32);
pub const AM_PROPERTY_DVDCOPY_DVD_KEY1: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(2i32);
pub const AM_PROPERTY_DVDCOPY_DEC_KEY2: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(3i32);
pub const AM_PROPERTY_DVDCOPY_TITLE_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(4i32);
pub const AM_PROPERTY_COPY_MACROVISION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(5i32);
pub const AM_PROPERTY_DVDCOPY_REGION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(6i32);
pub const AM_PROPERTY_DVDCOPY_SET_COPY_STATE: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(7i32);
pub const AM_PROPERTY_COPY_ANALOG_COMPONENT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(8i32);
pub const AM_PROPERTY_COPY_DIGITAL_CP: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(9i32);
pub const AM_PROPERTY_COPY_DVD_SRM: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(10i32);
pub const AM_PROPERTY_DVDCOPY_SUPPORTS_NEW_KEYCOUNT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(11i32);
pub const AM_PROPERTY_DVDCOPY_DISC_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(128i32);
impl ::std::convert::From<i32> for AM_PROPERTY_DVDCOPYPROT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_DVDCOPYPROT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_DVDKARAOKE(pub i32);
pub const AM_PROPERTY_DVDKARAOKE_ENABLE: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(0i32);
pub const AM_PROPERTY_DVDKARAOKE_DATA: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(1i32);
impl ::std::convert::From<i32> for AM_PROPERTY_DVDKARAOKE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_DVDKARAOKE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_DVDSUBPIC(pub i32);
pub const AM_PROPERTY_DVDSUBPIC_PALETTE: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(0i32);
pub const AM_PROPERTY_DVDSUBPIC_HLI: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(1i32);
pub const AM_PROPERTY_DVDSUBPIC_COMPOSIT_ON: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(2i32);
impl ::std::convert::From<i32> for AM_PROPERTY_DVDSUBPIC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_DVDSUBPIC {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_DVD_RATE_CHANGE(pub i32);
pub const AM_RATE_ChangeRate: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(1i32);
pub const AM_RATE_FullDataRateMax: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(2i32);
pub const AM_RATE_ReverseDecode: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(3i32);
pub const AM_RATE_DecoderPosition: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(4i32);
pub const AM_RATE_DecoderVersion: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(5i32);
impl ::std::convert::From<i32> for AM_PROPERTY_DVD_RATE_CHANGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_DVD_RATE_CHANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_FRAMESTEP(pub i32);
pub const AM_PROPERTY_FRAMESTEP_STEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(1i32);
pub const AM_PROPERTY_FRAMESTEP_CANCEL: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(2i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(3i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(4i32);
impl ::std::convert::From<i32> for AM_PROPERTY_FRAMESTEP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_FRAMESTEP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_PROPERTY_SPHLI {
    pub HLISS: u16,
    pub Reserved: u16,
    pub StartPTM: u32,
    pub EndPTM: u32,
    pub StartX: u16,
    pub StartY: u16,
    pub StopX: u16,
    pub StopY: u16,
    pub ColCon: AM_COLCON,
}
impl AM_PROPERTY_SPHLI {}
impl ::std::default::Default for AM_PROPERTY_SPHLI {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_PROPERTY_SPHLI {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_PROPERTY_SPHLI")
            .field("HLISS", &self.HLISS)
            .field("Reserved", &self.Reserved)
            .field("StartPTM", &self.StartPTM)
            .field("EndPTM", &self.EndPTM)
            .field("StartX", &self.StartX)
            .field("StartY", &self.StartY)
            .field("StopX", &self.StopX)
            .field("StopY", &self.StopY)
            .field("ColCon", &self.ColCon)
            .finish()
    }
}
impl ::std::cmp::PartialEq for AM_PROPERTY_SPHLI {
    fn eq(&self, other: &Self) -> bool {
        self.HLISS == other.HLISS && self.Reserved == other.Reserved && self.StartPTM == other.StartPTM && self.EndPTM == other.EndPTM && self.StartX == other.StartX && self.StartY == other.StartY && self.StopX == other.StopX && self.StopY == other.StopY && self.ColCon == other.ColCon
    }
}
impl ::std::cmp::Eq for AM_PROPERTY_SPHLI {}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_SPHLI {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_PROPERTY_SPPAL {
    pub sppal: [AM_DVD_YUV; 16],
}
impl AM_PROPERTY_SPPAL {}
impl ::std::default::Default for AM_PROPERTY_SPPAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_PROPERTY_SPPAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_PROPERTY_SPPAL").field("sppal", &self.sppal).finish()
    }
}
impl ::std::cmp::PartialEq for AM_PROPERTY_SPPAL {
    fn eq(&self, other: &Self) -> bool {
        self.sppal == other.sppal
    }
}
impl ::std::cmp::Eq for AM_PROPERTY_SPPAL {}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_SPPAL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_PROPERTY_TS_RATE_CHANGE(pub i32);
pub const AM_RATE_SimpleRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(1i32);
pub const AM_RATE_ExactRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(2i32);
pub const AM_RATE_MaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(3i32);
pub const AM_RATE_Step: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(4i32);
pub const AM_RATE_UseRateVersion: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(5i32);
pub const AM_RATE_QueryFullFrameRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(6i32);
pub const AM_RATE_QueryLastRateSegPTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(7i32);
pub const AM_RATE_CorrectTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(8i32);
pub const AM_RATE_ReverseMaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(9i32);
pub const AM_RATE_ResetOnTimeDisc: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(10i32);
pub const AM_RATE_QueryMapping: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(11i32);
impl ::std::convert::From<i32> for AM_PROPERTY_TS_RATE_CHANGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_PROPERTY_TS_RATE_CHANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_QUERY_DECODER_ATSC_HD_SUPPORT: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_QUERY_DECODER_ATSC_SD_SUPPORT: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_QUERY_DECODER_DVD_SUPPORT: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_QUERY_DECODER_DXVA_1_SUPPORT: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_QUERY_DECODER_VMR_SUPPORT: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_QueryRate {
    pub lMaxForwardFullFrame: i32,
    pub lMaxReverseFullFrame: i32,
}
impl AM_QueryRate {}
impl ::std::default::Default for AM_QueryRate {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_QueryRate {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_QueryRate").field("lMaxForwardFullFrame", &self.lMaxForwardFullFrame).field("lMaxReverseFullFrame", &self.lMaxReverseFullFrame).finish()
    }
}
impl ::std::cmp::PartialEq for AM_QueryRate {
    fn eq(&self, other: &Self) -> bool {
        self.lMaxForwardFullFrame == other.lMaxForwardFullFrame && self.lMaxReverseFullFrame == other.lMaxReverseFullFrame
    }
}
impl ::std::cmp::Eq for AM_QueryRate {}
unsafe impl ::windows::runtime::Abi for AM_QueryRate {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_ReverseBlockEnd: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_ReverseBlockStart: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AM_SAMPLE2_PROPERTIES {
    pub cbData: u32,
    pub dwTypeSpecificFlags: u32,
    pub dwSampleFlags: u32,
    pub lActual: i32,
    pub tStart: i64,
    pub tStop: i64,
    pub dwStreamId: u32,
    pub pMediaType: *mut AM_MEDIA_TYPE,
    pub pbBuffer: *mut u8,
    pub cbBuffer: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl AM_SAMPLE2_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AM_SAMPLE2_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AM_SAMPLE2_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_SAMPLE2_PROPERTIES")
            .field("cbData", &self.cbData)
            .field("dwTypeSpecificFlags", &self.dwTypeSpecificFlags)
            .field("dwSampleFlags", &self.dwSampleFlags)
            .field("lActual", &self.lActual)
            .field("tStart", &self.tStart)
            .field("tStop", &self.tStop)
            .field("dwStreamId", &self.dwStreamId)
            .field("pMediaType", &self.pMediaType)
            .field("pbBuffer", &self.pbBuffer)
            .field("cbBuffer", &self.cbBuffer)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AM_SAMPLE2_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.dwTypeSpecificFlags == other.dwTypeSpecificFlags && self.dwSampleFlags == other.dwSampleFlags && self.lActual == other.lActual && self.tStart == other.tStart && self.tStop == other.tStop && self.dwStreamId == other.dwStreamId && self.pMediaType == other.pMediaType && self.pbBuffer == other.pbBuffer && self.cbBuffer == other.cbBuffer
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AM_SAMPLE2_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AM_SAMPLE2_PROPERTIES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_SAMPLE_PROPERTY_FLAGS(pub i32);
pub const AM_SAMPLE_SPLICEPOINT: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
pub const AM_SAMPLE_PREROLL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(2i32);
pub const AM_SAMPLE_DATADISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(4i32);
pub const AM_SAMPLE_TYPECHANGED: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(8i32);
pub const AM_SAMPLE_TIMEVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(16i32);
pub const AM_SAMPLE_TIMEDISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(64i32);
pub const AM_SAMPLE_FLUSH_ON_PAUSE: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(128i32);
pub const AM_SAMPLE_STOPVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(256i32);
pub const AM_SAMPLE_ENDOFSTREAM: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(512i32);
pub const AM_STREAM_MEDIA: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(0i32);
pub const AM_STREAM_CONTROL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
impl ::std::convert::From<i32> for AM_SAMPLE_PROPERTY_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_SAMPLE_PROPERTY_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_SEEKING_SEEKING_CAPABILITIES(pub i32);
pub const AM_SEEKING_CanSeekAbsolute: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(1i32);
pub const AM_SEEKING_CanSeekForwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(2i32);
pub const AM_SEEKING_CanSeekBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(4i32);
pub const AM_SEEKING_CanGetCurrentPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(8i32);
pub const AM_SEEKING_CanGetStopPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(16i32);
pub const AM_SEEKING_CanGetDuration: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(32i32);
pub const AM_SEEKING_CanPlayBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(64i32);
pub const AM_SEEKING_CanDoSegments: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(128i32);
pub const AM_SEEKING_Source: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(256i32);
impl ::std::convert::From<i32> for AM_SEEKING_SEEKING_CAPABILITIES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_SEEKING_SEEKING_CAPABILITIES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_SEEKING_SeekingFlags(pub i32);
pub const AM_SEEKING_NoPositioning: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(0i32);
pub const AM_SEEKING_AbsolutePositioning: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(1i32);
pub const AM_SEEKING_RelativePositioning: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(2i32);
pub const AM_SEEKING_IncrementalPositioning: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(3i32);
pub const AM_SEEKING_PositioningBitsMask: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(3i32);
pub const AM_SEEKING_SeekToKeyFrame: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(4i32);
pub const AM_SEEKING_ReturnTime: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(8i32);
pub const AM_SEEKING_Segment: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(16i32);
pub const AM_SEEKING_NoFlush: AM_SEEKING_SeekingFlags = AM_SEEKING_SeekingFlags(32i32);
impl ::std::convert::From<i32> for AM_SEEKING_SeekingFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_SEEKING_SeekingFlags {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_STREAM_INFO {
    pub tStart: i64,
    pub tStop: i64,
    pub dwStartCookie: u32,
    pub dwStopCookie: u32,
    pub dwFlags: u32,
}
impl AM_STREAM_INFO {}
impl ::std::default::Default for AM_STREAM_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_STREAM_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_STREAM_INFO").field("tStart", &self.tStart).field("tStop", &self.tStop).field("dwStartCookie", &self.dwStartCookie).field("dwStopCookie", &self.dwStopCookie).field("dwFlags", &self.dwFlags).finish()
    }
}
impl ::std::cmp::PartialEq for AM_STREAM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.tStart == other.tStart && self.tStop == other.tStop && self.dwStartCookie == other.dwStartCookie && self.dwStopCookie == other.dwStopCookie && self.dwFlags == other.dwFlags
    }
}
impl ::std::cmp::Eq for AM_STREAM_INFO {}
unsafe impl ::windows::runtime::Abi for AM_STREAM_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_STREAM_INFO_FLAGS(pub i32);
pub const AM_STREAM_INFO_START_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(1i32);
pub const AM_STREAM_INFO_STOP_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(2i32);
pub const AM_STREAM_INFO_DISCARDING: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(4i32);
pub const AM_STREAM_INFO_STOP_SEND_EXTRA: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(16i32);
impl ::std::convert::From<i32> for AM_STREAM_INFO_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_STREAM_INFO_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_SimpleRateChange {
    pub StartTime: i64,
    pub Rate: i32,
}
impl AM_SimpleRateChange {}
impl ::std::default::Default for AM_SimpleRateChange {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_SimpleRateChange {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_SimpleRateChange").field("StartTime", &self.StartTime).field("Rate", &self.Rate).finish()
    }
}
impl ::std::cmp::PartialEq for AM_SimpleRateChange {
    fn eq(&self, other: &Self) -> bool {
        self.StartTime == other.StartTime && self.Rate == other.Rate
    }
}
impl ::std::cmp::Eq for AM_SimpleRateChange {}
unsafe impl ::windows::runtime::Abi for AM_SimpleRateChange {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_UseNewCSSKey: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_B_SAMPLE: i32 = 32i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_FIELD1: i32 = 1i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_FIELD1FIRST: i32 = 4i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_FIELD2: i32 = 2i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_FIELD_MASK: i32 = 3i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_INTERLEAVED_FRAME: i32 = 0i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_IPB_MASK: i32 = 48i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_I_SAMPLE: i32 = 0i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_P_SAMPLE: i32 = 16i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_REPEAT_FIELD: i32 = 64i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AM_VIDEO_FLAG_WEAVE: i32 = 8i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_WST_DRAWBGMODE(pub i32);
pub const AM_WST_DRAWBGMODE_Opaque: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(0i32);
pub const AM_WST_DRAWBGMODE_Transparent: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(1i32);
impl ::std::convert::From<i32> for AM_WST_DRAWBGMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_WST_DRAWBGMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_WST_LEVEL(pub i32);
pub const AM_WST_LEVEL_1_5: AM_WST_LEVEL = AM_WST_LEVEL(0i32);
impl ::std::convert::From<i32> for AM_WST_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_WST_LEVEL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AM_WST_PAGE {
    pub dwPageNr: u32,
    pub dwSubPageNr: u32,
    pub pucPageData: *mut u8,
}
impl AM_WST_PAGE {}
impl ::std::default::Default for AM_WST_PAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AM_WST_PAGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AM_WST_PAGE").field("dwPageNr", &self.dwPageNr).field("dwSubPageNr", &self.dwSubPageNr).field("pucPageData", &self.pucPageData).finish()
    }
}
impl ::std::cmp::PartialEq for AM_WST_PAGE {
    fn eq(&self, other: &Self) -> bool {
        self.dwPageNr == other.dwPageNr && self.dwSubPageNr == other.dwSubPageNr && self.pucPageData == other.pucPageData
    }
}
impl ::std::cmp::Eq for AM_WST_PAGE {}
unsafe impl ::windows::runtime::Abi for AM_WST_PAGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_WST_SERVICE(pub i32);
pub const AM_WST_SERVICE_None: AM_WST_SERVICE = AM_WST_SERVICE(0i32);
pub const AM_WST_SERVICE_Text: AM_WST_SERVICE = AM_WST_SERVICE(1i32);
pub const AM_WST_SERVICE_IDS: AM_WST_SERVICE = AM_WST_SERVICE(2i32);
pub const AM_WST_SERVICE_Invalid: AM_WST_SERVICE = AM_WST_SERVICE(3i32);
impl ::std::convert::From<i32> for AM_WST_SERVICE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_WST_SERVICE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_WST_STATE(pub i32);
pub const AM_WST_STATE_Off: AM_WST_STATE = AM_WST_STATE(0i32);
pub const AM_WST_STATE_On: AM_WST_STATE = AM_WST_STATE(1i32);
impl ::std::convert::From<i32> for AM_WST_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_WST_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AM_WST_STYLE(pub i32);
pub const AM_WST_STYLE_None: AM_WST_STYLE = AM_WST_STYLE(0i32);
pub const AM_WST_STYLE_Invers: AM_WST_STYLE = AM_WST_STYLE(1i32);
impl ::std::convert::From<i32> for AM_WST_STYLE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AM_WST_STYLE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct ANALOGVIDEOINFO {
    pub rcSource: super::super::Foundation::RECT,
    pub rcTarget: super::super::Foundation::RECT,
    pub dwActiveWidth: u32,
    pub dwActiveHeight: u32,
    pub AvgTimePerFrame: i64,
}
#[cfg(feature = "Win32_Foundation")]
impl ANALOGVIDEOINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for ANALOGVIDEOINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for ANALOGVIDEOINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ANALOGVIDEOINFO").field("rcSource", &self.rcSource).field("rcTarget", &self.rcTarget).field("dwActiveWidth", &self.dwActiveWidth).field("dwActiveHeight", &self.dwActiveHeight).field("AvgTimePerFrame", &self.AvgTimePerFrame).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for ANALOGVIDEOINFO {
    fn eq(&self, other: &Self) -> bool {
        self.rcSource == other.rcSource && self.rcTarget == other.rcTarget && self.dwActiveWidth == other.dwActiveWidth && self.dwActiveHeight == other.dwActiveHeight && self.AvgTimePerFrame == other.AvgTimePerFrame
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for ANALOGVIDEOINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for ANALOGVIDEOINFO {
    type Abi = Self;
}
pub const ANALOG_AUXIN_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1949235303, 2529, 16547, [130, 211, 150, 105, 186, 53, 50, 95]);
pub const ANALOG_FM_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1999112315, 11193, 20016, [128, 120, 68, 148, 118, 229, 157, 187]);
pub const ANALOG_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3089160318, 57571, 18319, [138, 56, 78, 19, 247, 179, 223, 66]);
pub const ATSCChannelTuneRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(57259238, 17846, 4563, [182, 80, 0, 192, 79, 121, 73, 142]);
pub const ATSCComponentType: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2833052629, 1920, 20212, [138, 131, 44, 255, 170, 203, 138, 206]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ATSCComponentTypeFlags(pub i32);
pub const ATSCCT_AC3: ATSCComponentTypeFlags = ATSCComponentTypeFlags(1i32);
impl ::std::convert::From<i32> for ATSCComponentTypeFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ATSCComponentTypeFlags {
    type Abi = Self;
}
pub const ATSCLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2289237787, 39162, 19834, [141, 147, 201, 241, 5, 95, 133, 187]);
pub const ATSCTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2732787536, 27709, 4563, [182, 83, 0, 192, 79, 121, 73, 142]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_EIT_TID: u32 = 203u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_EVENT: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_PSIP: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_ETM_LOCATION_NOT_PRESENT: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_ETM_LOCATION_RESERVED: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_ETT_TID: u32 = 204u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct ATSC_FILTER_OPTIONS {
    pub fSpecifyEtmId: super::super::Foundation::BOOL,
    pub EtmId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ATSC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for ATSC_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for ATSC_FILTER_OPTIONS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for ATSC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for ATSC_FILTER_OPTIONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_MGT_PID: u32 = 8187u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_MGT_TID: u32 = 199u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_PIT_TID: u32 = 208u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_RRT_PID: u32 = 8187u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_RRT_TID: u32 = 202u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_STT_PID: u32 = 8187u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_STT_TID: u32 = 205u32;
pub const ATSC_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(229453789, 24535, 4563, [143, 80, 0, 192, 79, 121, 113, 226]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_VCT_CABL_TID: u32 = 201u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_VCT_PID: u32 = 8187u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const ATSC_VCT_TERR_TID: u32 = 200u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AUDIO_STREAM_CONFIG_CAPS {
    pub guid: ::windows::runtime::GUID,
    pub MinimumChannels: u32,
    pub MaximumChannels: u32,
    pub ChannelsGranularity: u32,
    pub MinimumBitsPerSample: u32,
    pub MaximumBitsPerSample: u32,
    pub BitsPerSampleGranularity: u32,
    pub MinimumSampleFrequency: u32,
    pub MaximumSampleFrequency: u32,
    pub SampleFrequencyGranularity: u32,
}
impl AUDIO_STREAM_CONFIG_CAPS {}
impl ::std::default::Default for AUDIO_STREAM_CONFIG_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AUDIO_STREAM_CONFIG_CAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AUDIO_STREAM_CONFIG_CAPS")
            .field("guid", &self.guid)
            .field("MinimumChannels", &self.MinimumChannels)
            .field("MaximumChannels", &self.MaximumChannels)
            .field("ChannelsGranularity", &self.ChannelsGranularity)
            .field("MinimumBitsPerSample", &self.MinimumBitsPerSample)
            .field("MaximumBitsPerSample", &self.MaximumBitsPerSample)
            .field("BitsPerSampleGranularity", &self.BitsPerSampleGranularity)
            .field("MinimumSampleFrequency", &self.MinimumSampleFrequency)
            .field("MaximumSampleFrequency", &self.MaximumSampleFrequency)
            .field("SampleFrequencyGranularity", &self.SampleFrequencyGranularity)
            .finish()
    }
}
impl ::std::cmp::PartialEq for AUDIO_STREAM_CONFIG_CAPS {
    fn eq(&self, other: &Self) -> bool {
        self.guid == other.guid
            && self.MinimumChannels == other.MinimumChannels
            && self.MaximumChannels == other.MaximumChannels
            && self.ChannelsGranularity == other.ChannelsGranularity
            && self.MinimumBitsPerSample == other.MinimumBitsPerSample
            && self.MaximumBitsPerSample == other.MaximumBitsPerSample
            && self.BitsPerSampleGranularity == other.BitsPerSampleGranularity
            && self.MinimumSampleFrequency == other.MinimumSampleFrequency
            && self.MaximumSampleFrequency == other.MaximumSampleFrequency
            && self.SampleFrequencyGranularity == other.SampleFrequencyGranularity
    }
}
impl ::std::cmp::Eq for AUDIO_STREAM_CONFIG_CAPS {}
unsafe impl ::windows::runtime::Abi for AUDIO_STREAM_CONFIG_CAPS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIEXTHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwGrandFrames: u32,
    pub dwFuture: [u32; 61],
}
impl AVIEXTHEADER {}
impl ::std::default::Default for AVIEXTHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIEXTHEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIEXTHEADER {}
unsafe impl ::windows::runtime::Abi for AVIEXTHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIFIELDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved3: u32,
    pub aIndex: [AVIFIELDINDEX_0; 1],
}
impl AVIFIELDINDEX {}
impl ::std::default::Default for AVIFIELDINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIFIELDINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIFIELDINDEX {}
unsafe impl ::windows::runtime::Abi for AVIFIELDINDEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIFIELDINDEX_0 {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwOffsetField2: u32,
}
impl AVIFIELDINDEX_0 {}
impl ::std::default::Default for AVIFIELDINDEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIFIELDINDEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIFIELDINDEX_0 {}
unsafe impl ::windows::runtime::Abi for AVIFIELDINDEX_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_COPYRIGHTED: u32 = 131072u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_HASINDEX: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_ISINTERLEAVED: u32 = 256u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_MUSTUSEINDEX: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_TRUSTCKTYPE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIF_WASCAPTUREFILE: u32 = 65536u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_COMPRESSOR: u32 = 268369920u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_COMPUSE: i32 = 268369920i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_FIRSTPART: i32 = 32i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_KEYFRAME: i32 = 16i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_LASTPART: i32 = 64i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_LIST: i32 = 1i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_NOTIME: i32 = 256i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVIIF_NO_TIME: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIINDEXENTRY {
    pub ckid: u32,
    pub dwFlags: u32,
    pub dwChunkOffset: u32,
    pub dwChunkLength: u32,
}
impl AVIINDEXENTRY {}
impl ::std::default::Default for AVIINDEXENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AVIINDEXENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AVIINDEXENTRY").field("ckid", &self.ckid).field("dwFlags", &self.dwFlags).field("dwChunkOffset", &self.dwChunkOffset).field("dwChunkLength", &self.dwChunkLength).finish()
    }
}
impl ::std::cmp::PartialEq for AVIINDEXENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.ckid == other.ckid && self.dwFlags == other.dwFlags && self.dwChunkOffset == other.dwChunkOffset && self.dwChunkLength == other.dwChunkLength
    }
}
impl ::std::cmp::Eq for AVIINDEXENTRY {}
unsafe impl ::windows::runtime::Abi for AVIINDEXENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIMAINHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwMicroSecPerFrame: u32,
    pub dwMaxBytesPerSec: u32,
    pub dwPaddingGranularity: u32,
    pub dwFlags: u32,
    pub dwTotalFrames: u32,
    pub dwInitialFrames: u32,
    pub dwStreams: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dwReserved: [u32; 4],
}
impl AVIMAINHEADER {}
impl ::std::default::Default for AVIMAINHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIMAINHEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIMAINHEADER {}
unsafe impl ::windows::runtime::Abi for AVIMAINHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIMETAINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub adwIndex: [u32; 1],
}
impl AVIMETAINDEX {}
impl ::std::default::Default for AVIMETAINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIMETAINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIMETAINDEX {}
unsafe impl ::windows::runtime::Abi for AVIMETAINDEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIOLDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub aIndex: [AVIOLDINDEX_0; 1],
}
impl AVIOLDINDEX {}
impl ::std::default::Default for AVIOLDINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIOLDINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIOLDINDEX {}
unsafe impl ::windows::runtime::Abi for AVIOLDINDEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVIOLDINDEX_0 {
    pub dwChunkId: u32,
    pub dwFlags: u32,
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl AVIOLDINDEX_0 {}
impl ::std::default::Default for AVIOLDINDEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVIOLDINDEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVIOLDINDEX_0 {}
unsafe impl ::windows::runtime::Abi for AVIOLDINDEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_Gdi`*"]
pub struct AVIPALCHANGE {
    pub bFirstEntry: u8,
    pub bNumEntries: u8,
    pub wFlags: u16,
    pub peNew: [super::Gdi::PALETTEENTRY; 1],
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl AVIPALCHANGE {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for AVIPALCHANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for AVIPALCHANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AVIPALCHANGE").field("bFirstEntry", &self.bFirstEntry).field("bNumEntries", &self.bNumEntries).field("wFlags", &self.wFlags).field("peNew", &self.peNew).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for AVIPALCHANGE {
    fn eq(&self, other: &Self) -> bool {
        self.bFirstEntry == other.bFirstEntry && self.bNumEntries == other.bNumEntries && self.wFlags == other.wFlags && self.peNew == other.peNew
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for AVIPALCHANGE {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for AVIPALCHANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVISF_DISABLED: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVISF_VIDEO_PALCHANGES: u32 = 65536u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISTDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved_3: u32,
    pub aIndex: [AVISTDINDEX_ENTRY; 2044],
}
impl AVISTDINDEX {}
impl ::std::default::Default for AVISTDINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVISTDINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVISTDINDEX {}
unsafe impl ::windows::runtime::Abi for AVISTDINDEX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVISTDINDEX_DELTAFRAME: u32 = 2147483648u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISTDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl AVISTDINDEX_ENTRY {}
impl ::std::default::Default for AVISTDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVISTDINDEX_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVISTDINDEX_ENTRY {}
unsafe impl ::windows::runtime::Abi for AVISTDINDEX_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISTREAMHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: AVISTREAMHEADER_0,
}
impl AVISTREAMHEADER {}
impl ::std::default::Default for AVISTREAMHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVISTREAMHEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVISTREAMHEADER {}
unsafe impl ::windows::runtime::Abi for AVISTREAMHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISTREAMHEADER_0 {
    pub left: i16,
    pub top: i16,
    pub right: i16,
    pub bottom: i16,
}
impl AVISTREAMHEADER_0 {}
impl ::std::default::Default for AVISTREAMHEADER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AVISTREAMHEADER_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_rcFrame_e__Struct").field("left", &self.left).field("top", &self.top).field("right", &self.right).field("bottom", &self.bottom).finish()
    }
}
impl ::std::cmp::PartialEq for AVISTREAMHEADER_0 {
    fn eq(&self, other: &Self) -> bool {
        self.left == other.left && self.top == other.top && self.right == other.right && self.bottom == other.bottom
    }
}
impl ::std::cmp::Eq for AVISTREAMHEADER_0 {}
unsafe impl ::windows::runtime::Abi for AVISTREAMHEADER_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISUPERINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [AVISUPERINDEX_0; 1022],
}
impl AVISUPERINDEX {}
impl ::std::default::Default for AVISUPERINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVISUPERINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVISUPERINDEX {}
unsafe impl ::windows::runtime::Abi for AVISUPERINDEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVISUPERINDEX_0 {
    pub qwOffset: u64,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl AVISUPERINDEX_0 {}
impl ::std::default::Default for AVISUPERINDEX_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVISUPERINDEX_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVISUPERINDEX_0 {}
unsafe impl ::windows::runtime::Abi for AVISUPERINDEX_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct AVIStreamHeader {
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl AVIStreamHeader {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AVIStreamHeader {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AVIStreamHeader {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AVIStreamHeader")
            .field("fccType", &self.fccType)
            .field("fccHandler", &self.fccHandler)
            .field("dwFlags", &self.dwFlags)
            .field("wPriority", &self.wPriority)
            .field("wLanguage", &self.wLanguage)
            .field("dwInitialFrames", &self.dwInitialFrames)
            .field("dwScale", &self.dwScale)
            .field("dwRate", &self.dwRate)
            .field("dwStart", &self.dwStart)
            .field("dwLength", &self.dwLength)
            .field("dwSuggestedBufferSize", &self.dwSuggestedBufferSize)
            .field("dwQuality", &self.dwQuality)
            .field("dwSampleSize", &self.dwSampleSize)
            .field("rcFrame", &self.rcFrame)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AVIStreamHeader {
    fn eq(&self, other: &Self) -> bool {
        self.fccType == other.fccType
            && self.fccHandler == other.fccHandler
            && self.dwFlags == other.dwFlags
            && self.wPriority == other.wPriority
            && self.wLanguage == other.wLanguage
            && self.dwInitialFrames == other.dwInitialFrames
            && self.dwScale == other.dwScale
            && self.dwRate == other.dwRate
            && self.dwStart == other.dwStart
            && self.dwLength == other.dwLength
            && self.dwSuggestedBufferSize == other.dwSuggestedBufferSize
            && self.dwQuality == other.dwQuality
            && self.dwSampleSize == other.dwSampleSize
            && self.rcFrame == other.rcFrame
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AVIStreamHeader {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AVIStreamHeader {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVITCDLINDEX_ENTRY {
    pub dwTick: u32,
    pub time: TIMECODE,
    pub dwSMPTEflags: u32,
    pub dwUser: u32,
    pub szReelId: [i8; 12],
}
impl AVITCDLINDEX_ENTRY {}
impl ::std::default::Default for AVITCDLINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVITCDLINDEX_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVITCDLINDEX_ENTRY {}
unsafe impl ::windows::runtime::Abi for AVITCDLINDEX_ENTRY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVITIMECODEINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [TIMECODEDATA; 1022],
}
impl AVITIMECODEINDEX {}
impl ::std::default::Default for AVITIMECODEINDEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVITIMECODEINDEX {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVITIMECODEINDEX {}
unsafe impl ::windows::runtime::Abi for AVITIMECODEINDEX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct AVITIMEDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl AVITIMEDINDEX_ENTRY {}
impl ::std::default::Default for AVITIMEDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for AVITIMEDINDEX_ENTRY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for AVITIMEDINDEX_ENTRY {}
unsafe impl ::windows::runtime::Abi for AVITIMEDINDEX_ENTRY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_HEADERSIZE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_IS_DATA: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_OF_CHUNKS: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_OF_INDEXES: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_OF_SUB_2FIELD: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_OF_TIMED_CHUNKS: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_SUB_2FIELD: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AVI_INDEX_SUB_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AllocatorStrategy_DontCare: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AllocatorStrategy_MaximizeSpeed: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AllocatorStrategy_MinimizeFrameSize: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AllocatorStrategy_MinimizeNumberOfAllocators: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AllocatorStrategy_MinimizeNumberOfFrames: u32 = 1u32;
pub const AnalogAudioComponentType: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(682295301, 59461, 20474, [170, 155, 244, 102, 82, 54, 20, 28]);
pub const AnalogLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1231260561, 18603, 18615, [164, 122, 125, 14, 117, 160, 142, 222]);
pub const AnalogRadioTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2322025292, 8035, 4563, [182, 76, 0, 192, 79, 121, 73, 142]);
pub const AnalogTVTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2322025293, 8035, 4563, [182, 76, 0, 192, 79, 121, 73, 142]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct AnalogVideoStandard(pub i32);
pub const AnalogVideo_None: AnalogVideoStandard = AnalogVideoStandard(0i32);
pub const AnalogVideo_NTSC_M: AnalogVideoStandard = AnalogVideoStandard(1i32);
pub const AnalogVideo_NTSC_M_J: AnalogVideoStandard = AnalogVideoStandard(2i32);
pub const AnalogVideo_NTSC_433: AnalogVideoStandard = AnalogVideoStandard(4i32);
pub const AnalogVideo_PAL_B: AnalogVideoStandard = AnalogVideoStandard(16i32);
pub const AnalogVideo_PAL_D: AnalogVideoStandard = AnalogVideoStandard(32i32);
pub const AnalogVideo_PAL_G: AnalogVideoStandard = AnalogVideoStandard(64i32);
pub const AnalogVideo_PAL_H: AnalogVideoStandard = AnalogVideoStandard(128i32);
pub const AnalogVideo_PAL_I: AnalogVideoStandard = AnalogVideoStandard(256i32);
pub const AnalogVideo_PAL_M: AnalogVideoStandard = AnalogVideoStandard(512i32);
pub const AnalogVideo_PAL_N: AnalogVideoStandard = AnalogVideoStandard(1024i32);
pub const AnalogVideo_PAL_60: AnalogVideoStandard = AnalogVideoStandard(2048i32);
pub const AnalogVideo_SECAM_B: AnalogVideoStandard = AnalogVideoStandard(4096i32);
pub const AnalogVideo_SECAM_D: AnalogVideoStandard = AnalogVideoStandard(8192i32);
pub const AnalogVideo_SECAM_G: AnalogVideoStandard = AnalogVideoStandard(16384i32);
pub const AnalogVideo_SECAM_H: AnalogVideoStandard = AnalogVideoStandard(32768i32);
pub const AnalogVideo_SECAM_K: AnalogVideoStandard = AnalogVideoStandard(65536i32);
pub const AnalogVideo_SECAM_K1: AnalogVideoStandard = AnalogVideoStandard(131072i32);
pub const AnalogVideo_SECAM_L: AnalogVideoStandard = AnalogVideoStandard(262144i32);
pub const AnalogVideo_SECAM_L1: AnalogVideoStandard = AnalogVideoStandard(524288i32);
pub const AnalogVideo_PAL_N_COMBO: AnalogVideoStandard = AnalogVideoStandard(1048576i32);
pub const AnalogVideoMask_MCE_NTSC: AnalogVideoStandard = AnalogVideoStandard(1052167i32);
pub const AnalogVideoMask_MCE_PAL: AnalogVideoStandard = AnalogVideoStandard(496i32);
pub const AnalogVideoMask_MCE_SECAM: AnalogVideoStandard = AnalogVideoStandard(1044480i32);
impl ::std::convert::From<i32> for AnalogVideoStandard {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AnalogVideoStandard {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AnalogVideo_NTSC_Mask: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AnalogVideo_PAL_Mask: u32 = 1052656u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AnalogVideo_SECAM_Mask: u32 = 1044480u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ApplicationTypeType(pub i32);
pub const SCTE28_ConditionalAccess: ApplicationTypeType = ApplicationTypeType(0i32);
pub const SCTE28_POD_Host_Binding_Information: ApplicationTypeType = ApplicationTypeType(1i32);
pub const SCTE28_IPService: ApplicationTypeType = ApplicationTypeType(2i32);
pub const SCTE28_NetworkInterface_SCTE55_2: ApplicationTypeType = ApplicationTypeType(3i32);
pub const SCTE28_NetworkInterface_SCTE55_1: ApplicationTypeType = ApplicationTypeType(4i32);
pub const SCTE28_CopyProtection: ApplicationTypeType = ApplicationTypeType(5i32);
pub const SCTE28_Diagnostic: ApplicationTypeType = ApplicationTypeType(6i32);
pub const SCTE28_Undesignated: ApplicationTypeType = ApplicationTypeType(7i32);
pub const SCTE28_Reserved: ApplicationTypeType = ApplicationTypeType(8i32);
impl ::std::convert::From<i32> for ApplicationTypeType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ApplicationTypeType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Commentary: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Dialogue: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Emergency: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Hearing_Impaired: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Music_And_Effects: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Reserved: i32 = -1i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Standard: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Visually_Impaired: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const AudioType_Voiceover: u32 = 7u32;
pub const AuxInTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4185299462, 31434, 20025, [156, 251, 151, 187, 53, 240, 231, 126]);
pub const BDANETWORKTYPE_ATSC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1905811281, 7329, 4563, [156, 200, 0, 192, 79, 121, 113, 224]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDANODE_DESCRIPTOR {
    pub ulBdaNodeType: u32,
    pub guidFunction: ::windows::runtime::GUID,
    pub guidName: ::windows::runtime::GUID,
}
impl BDANODE_DESCRIPTOR {}
impl ::std::default::Default for BDANODE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDANODE_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDANODE_DESCRIPTOR").field("ulBdaNodeType", &self.ulBdaNodeType).field("guidFunction", &self.guidFunction).field("guidName", &self.guidName).finish()
    }
}
impl ::std::cmp::PartialEq for BDANODE_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.ulBdaNodeType == other.ulBdaNodeType && self.guidFunction == other.guidFunction && self.guidName == other.guidName
    }
}
impl ::std::cmp::Eq for BDANODE_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for BDANODE_DESCRIPTOR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_BUFFER {
    pub lResult: i32,
    pub ulBufferSize: u32,
    pub argbBuffer: [u8; 1],
}
impl BDA_BUFFER {}
impl ::std::default::Default for BDA_BUFFER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_BUFFER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_BUFFER").field("lResult", &self.lResult).field("ulBufferSize", &self.ulBufferSize).field("argbBuffer", &self.argbBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_BUFFER {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulBufferSize == other.ulBufferSize && self.argbBuffer == other.argbBuffer
    }
}
impl ::std::cmp::Eq for BDA_BUFFER {}
unsafe impl ::windows::runtime::Abi for BDA_BUFFER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
}
impl BDA_CAS_CHECK_ENTITLEMENTTOKEN {}
impl ::std::default::Default for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CAS_CHECK_ENTITLEMENTTOKEN").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulDescrambleStatus == other.ulDescrambleStatus
    }
}
impl ::std::cmp::Eq for BDA_CAS_CHECK_ENTITLEMENTTOKEN {}
unsafe impl ::windows::runtime::Abi for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CAS_CLOSEMMIDATA {
    pub ulDialogNumber: u32,
}
impl BDA_CAS_CLOSEMMIDATA {}
impl ::std::default::Default for BDA_CAS_CLOSEMMIDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CAS_CLOSEMMIDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CAS_CLOSEMMIDATA").field("ulDialogNumber", &self.ulDialogNumber).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CAS_CLOSEMMIDATA {
    fn eq(&self, other: &Self) -> bool {
        self.ulDialogNumber == other.ulDialogNumber
    }
}
impl ::std::cmp::Eq for BDA_CAS_CLOSEMMIDATA {}
unsafe impl ::windows::runtime::Abi for BDA_CAS_CLOSEMMIDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CAS_CLOSE_MMIDIALOG {
    pub lResult: i32,
    pub SessionResult: u32,
}
impl BDA_CAS_CLOSE_MMIDIALOG {}
impl ::std::default::Default for BDA_CAS_CLOSE_MMIDIALOG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CAS_CLOSE_MMIDIALOG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CAS_CLOSE_MMIDIALOG").field("lResult", &self.lResult).field("SessionResult", &self.SessionResult).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CAS_CLOSE_MMIDIALOG {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.SessionResult == other.SessionResult
    }
}
impl ::std::cmp::Eq for BDA_CAS_CLOSE_MMIDIALOG {}
unsafe impl ::windows::runtime::Abi for BDA_CAS_CLOSE_MMIDIALOG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CAS_OPENMMIDATA {
    pub ulDialogNumber: u32,
    pub ulDialogRequest: u32,
    pub uuidDialogType: ::windows::runtime::GUID,
    pub usDialogDataLength: u16,
    pub argbDialogData: [u8; 1],
}
impl BDA_CAS_OPENMMIDATA {}
impl ::std::default::Default for BDA_CAS_OPENMMIDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CAS_OPENMMIDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CAS_OPENMMIDATA").field("ulDialogNumber", &self.ulDialogNumber).field("ulDialogRequest", &self.ulDialogRequest).field("uuidDialogType", &self.uuidDialogType).field("usDialogDataLength", &self.usDialogDataLength).field("argbDialogData", &self.argbDialogData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CAS_OPENMMIDATA {
    fn eq(&self, other: &Self) -> bool {
        self.ulDialogNumber == other.ulDialogNumber && self.ulDialogRequest == other.ulDialogRequest && self.uuidDialogType == other.uuidDialogType && self.usDialogDataLength == other.usDialogDataLength && self.argbDialogData == other.argbDialogData
    }
}
impl ::std::cmp::Eq for BDA_CAS_OPENMMIDATA {}
unsafe impl ::windows::runtime::Abi for BDA_CAS_OPENMMIDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CAS_REQUESTTUNERDATA {
    pub ucRequestPriority: u8,
    pub ucRequestReason: u8,
    pub ucRequestConsequences: u8,
    pub ulEstimatedTime: u32,
}
impl BDA_CAS_REQUESTTUNERDATA {}
impl ::std::default::Default for BDA_CAS_REQUESTTUNERDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CAS_REQUESTTUNERDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CAS_REQUESTTUNERDATA").field("ucRequestPriority", &self.ucRequestPriority).field("ucRequestReason", &self.ucRequestReason).field("ucRequestConsequences", &self.ucRequestConsequences).field("ulEstimatedTime", &self.ulEstimatedTime).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CAS_REQUESTTUNERDATA {
    fn eq(&self, other: &Self) -> bool {
        self.ucRequestPriority == other.ucRequestPriority && self.ucRequestReason == other.ucRequestReason && self.ucRequestConsequences == other.ucRequestConsequences && self.ulEstimatedTime == other.ulEstimatedTime
    }
}
impl ::std::cmp::Eq for BDA_CAS_REQUESTTUNERDATA {}
unsafe impl ::windows::runtime::Abi for BDA_CAS_REQUESTTUNERDATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_CA_MODULE_UI {
    pub ulFormat: u32,
    pub ulbcDesc: u32,
    pub ulDesc: [u32; 1],
}
impl BDA_CA_MODULE_UI {}
impl ::std::default::Default for BDA_CA_MODULE_UI {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_CA_MODULE_UI {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_CA_MODULE_UI").field("ulFormat", &self.ulFormat).field("ulbcDesc", &self.ulbcDesc).field("ulDesc", &self.ulDesc).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_CA_MODULE_UI {
    fn eq(&self, other: &Self) -> bool {
        self.ulFormat == other.ulFormat && self.ulbcDesc == other.ulbcDesc && self.ulDesc == other.ulDesc
    }
}
impl ::std::cmp::Eq for BDA_CA_MODULE_UI {}
unsafe impl ::windows::runtime::Abi for BDA_CA_MODULE_UI {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_CHANGE_STATE(pub i32);
pub const BDA_CHANGES_COMPLETE: BDA_CHANGE_STATE = BDA_CHANGE_STATE(0i32);
pub const BDA_CHANGES_PENDING: BDA_CHANGE_STATE = BDA_CHANGE_STATE(1i32);
impl ::std::convert::From<i32> for BDA_CHANGE_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_CHANGE_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_CONDITIONALACCESS_MMICLOSEREASON(pub i32);
pub const CONDITIONALACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(0i32);
pub const CONDITIONALACCESS_CLOSED_ITSELF: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(1i32);
pub const CONDITIONALACCESS_TUNER_REQUESTED_CLOSE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(2i32);
pub const CONDITIONALACCESS_DIALOG_TIMEOUT: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(3i32);
pub const CONDITIONALACCESS_DIALOG_FOCUS_CHANGE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(4i32);
pub const CONDITIONALACCESS_DIALOG_USER_DISMISSED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(5i32);
pub const CONDITIONALACCESS_DIALOG_USER_NOT_AVAILABLE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(6i32);
impl ::std::convert::From<i32> for BDA_CONDITIONALACCESS_MMICLOSEREASON {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_CONDITIONALACCESS_MMICLOSEREASON {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_CONDITIONALACCESS_REQUESTTYPE(pub i32);
pub const CONDITIONALACCESS_ACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(0i32);
pub const CONDITIONALACCESS_ACCESS_NOT_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(1i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(2i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE_NO_STREAMING_DISRUPTION: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(3i32);
impl ::std::convert::From<i32> for BDA_CONDITIONALACCESS_REQUESTTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_CONDITIONALACCESS_REQUESTTYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_CONDITIONALACCESS_SESSION_RESULT(pub i32);
pub const CONDITIONALACCESS_SUCCESSFULL: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(0i32);
pub const CONDITIONALACCESS_ENDED_NOCHANGE: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(1i32);
pub const CONDITIONALACCESS_ABORTED: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(2i32);
impl ::std::convert::From<i32> for BDA_CONDITIONALACCESS_SESSION_RESULT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_CONDITIONALACCESS_SESSION_RESULT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Channel(pub i32);
pub const BDA_UNDEFINED_CHANNEL: BDA_Channel = BDA_Channel(-1i32);
impl ::std::convert::From<i32> for BDA_Channel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Channel {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Channel_Bandwidth(pub i32);
pub const BDA_CHAN_BANDWITH_NOT_SET: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(-1i32);
pub const BDA_CHAN_BANDWITH_NOT_DEFINED: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(0i32);
impl ::std::convert::From<i32> for BDA_Channel_Bandwidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Channel_Bandwidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Comp_Flags(pub i32);
pub const BDACOMP_NOT_DEFINED: BDA_Comp_Flags = BDA_Comp_Flags(0i32);
pub const BDACOMP_EXCLUDE_TS_FROM_TR: BDA_Comp_Flags = BDA_Comp_Flags(1i32);
pub const BDACOMP_INCLUDE_LOCATOR_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(2i32);
pub const BDACOMP_INCLUDE_COMPONENTS_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(4i32);
impl ::std::convert::From<i32> for BDA_Comp_Flags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Comp_Flags {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_DEBUG_DATA {
    pub lResult: i32,
    pub uuidDebugDataType: ::windows::runtime::GUID,
    pub ulDataSize: u32,
    pub argbDebugData: [u8; 1],
}
impl BDA_DEBUG_DATA {}
impl ::std::default::Default for BDA_DEBUG_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_DEBUG_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_DEBUG_DATA").field("lResult", &self.lResult).field("uuidDebugDataType", &self.uuidDebugDataType).field("ulDataSize", &self.ulDataSize).field("argbDebugData", &self.argbDebugData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_DEBUG_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.uuidDebugDataType == other.uuidDebugDataType && self.ulDataSize == other.ulDataSize && self.argbDebugData == other.argbDebugData
    }
}
impl ::std::cmp::Eq for BDA_DEBUG_DATA {}
unsafe impl ::windows::runtime::Abi for BDA_DEBUG_DATA {
    type Abi = Self;
}
pub const BDA_DEBUG_DATA_AVAILABLE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1774341972, 39299, 18814, [180, 21, 40, 43, 228, 197, 85, 251]);
pub const BDA_DEBUG_DATA_TYPE_STRING: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2819024743, 56924, 17164, [128, 191, 162, 30, 190, 6, 199, 72]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_DISCOVERY_STATE(pub i32);
pub const BDA_DISCOVERY_UNSPECIFIED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(0i32);
pub const BDA_DISCOVERY_REQUIRED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(1i32);
pub const BDA_DISCOVERY_COMPLETE: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(2i32);
impl ::std::convert::From<i32> for BDA_DISCOVERY_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_DISCOVERY_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_DISEQC_RESPONSE {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl BDA_DISEQC_RESPONSE {}
impl ::std::default::Default for BDA_DISEQC_RESPONSE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_DISEQC_RESPONSE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_DISEQC_RESPONSE").field("ulRequestId", &self.ulRequestId).field("ulPacketLength", &self.ulPacketLength).field("argbPacketData", &self.argbPacketData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_DISEQC_RESPONSE {
    fn eq(&self, other: &Self) -> bool {
        self.ulRequestId == other.ulRequestId && self.ulPacketLength == other.ulPacketLength && self.argbPacketData == other.argbPacketData
    }
}
impl ::std::cmp::Eq for BDA_DISEQC_RESPONSE {}
unsafe impl ::windows::runtime::Abi for BDA_DISEQC_RESPONSE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_DISEQC_SEND {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl BDA_DISEQC_SEND {}
impl ::std::default::Default for BDA_DISEQC_SEND {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_DISEQC_SEND {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_DISEQC_SEND").field("ulRequestId", &self.ulRequestId).field("ulPacketLength", &self.ulPacketLength).field("argbPacketData", &self.argbPacketData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_DISEQC_SEND {
    fn eq(&self, other: &Self) -> bool {
        self.ulRequestId == other.ulRequestId && self.ulPacketLength == other.ulPacketLength && self.argbPacketData == other.argbPacketData
    }
}
impl ::std::cmp::Eq for BDA_DISEQC_SEND {}
unsafe impl ::windows::runtime::Abi for BDA_DISEQC_SEND {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_DRM_DRMSTATUS {
    pub lResult: i32,
    pub DRMuuid: ::windows::runtime::GUID,
    pub ulDrmUuidListStringSize: u32,
    pub argbDrmUuidListString: [::windows::runtime::GUID; 1],
}
impl BDA_DRM_DRMSTATUS {}
impl ::std::default::Default for BDA_DRM_DRMSTATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_DRM_DRMSTATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_DRM_DRMSTATUS").field("lResult", &self.lResult).field("DRMuuid", &self.DRMuuid).field("ulDrmUuidListStringSize", &self.ulDrmUuidListStringSize).field("argbDrmUuidListString", &self.argbDrmUuidListString).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_DRM_DRMSTATUS {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.DRMuuid == other.DRMuuid && self.ulDrmUuidListStringSize == other.ulDrmUuidListStringSize && self.argbDrmUuidListString == other.argbDrmUuidListString
    }
}
impl ::std::cmp::Eq for BDA_DRM_DRMSTATUS {}
unsafe impl ::windows::runtime::Abi for BDA_DRM_DRMSTATUS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_DVBT2_L1_SIGNALLING_DATA {
    pub L1Pre_TYPE: u8,
    pub L1Pre_BWT_S1_S2: u8,
    pub L1Pre_REPETITION_GUARD_PAPR: u8,
    pub L1Pre_MOD_COD_FEC: u8,
    pub L1Pre_POSTSIZE_INFO_PILOT: [u8; 5],
    pub L1Pre_TX_ID_AVAIL: u8,
    pub L1Pre_CELL_ID: [u8; 2],
    pub L1Pre_NETWORK_ID: [u8; 2],
    pub L1Pre_T2SYSTEM_ID: [u8; 2],
    pub L1Pre_NUM_T2_FRAMES: u8,
    pub L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT: [u8; 2],
    pub L1Pre_NUMRF_CURRENTRF_RESERVED: [u8; 2],
    pub L1Pre_CRC32: [u8; 4],
    pub L1PostData: [u8; 1],
}
impl BDA_DVBT2_L1_SIGNALLING_DATA {}
impl ::std::default::Default for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_DVBT2_L1_SIGNALLING_DATA")
            .field("L1Pre_TYPE", &self.L1Pre_TYPE)
            .field("L1Pre_BWT_S1_S2", &self.L1Pre_BWT_S1_S2)
            .field("L1Pre_REPETITION_GUARD_PAPR", &self.L1Pre_REPETITION_GUARD_PAPR)
            .field("L1Pre_MOD_COD_FEC", &self.L1Pre_MOD_COD_FEC)
            .field("L1Pre_POSTSIZE_INFO_PILOT", &self.L1Pre_POSTSIZE_INFO_PILOT)
            .field("L1Pre_TX_ID_AVAIL", &self.L1Pre_TX_ID_AVAIL)
            .field("L1Pre_CELL_ID", &self.L1Pre_CELL_ID)
            .field("L1Pre_NETWORK_ID", &self.L1Pre_NETWORK_ID)
            .field("L1Pre_T2SYSTEM_ID", &self.L1Pre_T2SYSTEM_ID)
            .field("L1Pre_NUM_T2_FRAMES", &self.L1Pre_NUM_T2_FRAMES)
            .field("L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT", &self.L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT)
            .field("L1Pre_NUMRF_CURRENTRF_RESERVED", &self.L1Pre_NUMRF_CURRENTRF_RESERVED)
            .field("L1Pre_CRC32", &self.L1Pre_CRC32)
            .field("L1PostData", &self.L1PostData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.L1Pre_TYPE == other.L1Pre_TYPE
            && self.L1Pre_BWT_S1_S2 == other.L1Pre_BWT_S1_S2
            && self.L1Pre_REPETITION_GUARD_PAPR == other.L1Pre_REPETITION_GUARD_PAPR
            && self.L1Pre_MOD_COD_FEC == other.L1Pre_MOD_COD_FEC
            && self.L1Pre_POSTSIZE_INFO_PILOT == other.L1Pre_POSTSIZE_INFO_PILOT
            && self.L1Pre_TX_ID_AVAIL == other.L1Pre_TX_ID_AVAIL
            && self.L1Pre_CELL_ID == other.L1Pre_CELL_ID
            && self.L1Pre_NETWORK_ID == other.L1Pre_NETWORK_ID
            && self.L1Pre_T2SYSTEM_ID == other.L1Pre_T2SYSTEM_ID
            && self.L1Pre_NUM_T2_FRAMES == other.L1Pre_NUM_T2_FRAMES
            && self.L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT == other.L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT
            && self.L1Pre_NUMRF_CURRENTRF_RESERVED == other.L1Pre_NUMRF_CURRENTRF_RESERVED
            && self.L1Pre_CRC32 == other.L1Pre_CRC32
            && self.L1PostData == other.L1PostData
    }
}
impl ::std::cmp::Eq for BDA_DVBT2_L1_SIGNALLING_DATA {}
unsafe impl ::windows::runtime::Abi for BDA_DVBT2_L1_SIGNALLING_DATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_DigitalSignalStandard(pub i32);
pub const Bda_DigitalStandard_None: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(0i32);
pub const Bda_DigitalStandard_DVB_T: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(1i32);
pub const Bda_DigitalStandard_DVB_S: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(2i32);
pub const Bda_DigitalStandard_DVB_C: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(4i32);
pub const Bda_DigitalStandard_ATSC: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(8i32);
pub const Bda_DigitalStandard_ISDB_T: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(16i32);
pub const Bda_DigitalStandard_ISDB_S: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(32i32);
pub const Bda_DigitalStandard_ISDB_C: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(64i32);
impl ::std::convert::From<i32> for BDA_DigitalSignalStandard {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_DigitalSignalStandard {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_DrmPairingError(pub i32);
pub const BDA_DrmPairing_Succeeded: BDA_DrmPairingError = BDA_DrmPairingError(0i32);
pub const BDA_DrmPairing_HardwareFailure: BDA_DrmPairingError = BDA_DrmPairingError(1i32);
pub const BDA_DrmPairing_NeedRevocationData: BDA_DrmPairingError = BDA_DrmPairingError(2i32);
pub const BDA_DrmPairing_NeedIndiv: BDA_DrmPairingError = BDA_DrmPairingError(3i32);
pub const BDA_DrmPairing_Other: BDA_DrmPairingError = BDA_DrmPairingError(4i32);
pub const BDA_DrmPairing_DrmInitFailed: BDA_DrmPairingError = BDA_DrmPairingError(5i32);
pub const BDA_DrmPairing_DrmNotPaired: BDA_DrmPairingError = BDA_DrmPairingError(6i32);
pub const BDA_DrmPairing_DrmRePairSoon: BDA_DrmPairingError = BDA_DrmPairingError(7i32);
pub const BDA_DrmPairing_Aborted: BDA_DrmPairingError = BDA_DrmPairingError(8i32);
pub const BDA_DrmPairing_NeedSDKUpdate: BDA_DrmPairingError = BDA_DrmPairingError(9i32);
impl ::std::convert::From<i32> for BDA_DrmPairingError {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_DrmPairingError {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_ETHERNET_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl BDA_ETHERNET_ADDRESS {}
impl ::std::default::Default for BDA_ETHERNET_ADDRESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_ETHERNET_ADDRESS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_ETHERNET_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_ETHERNET_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.rgbAddress == other.rgbAddress
    }
}
impl ::std::cmp::Eq for BDA_ETHERNET_ADDRESS {}
unsafe impl ::windows::runtime::Abi for BDA_ETHERNET_ADDRESS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_ETHERNET_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_ETHERNET_ADDRESS; 1],
}
impl BDA_ETHERNET_ADDRESS_LIST {}
impl ::std::default::Default for BDA_ETHERNET_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_ETHERNET_ADDRESS_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_ETHERNET_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_ETHERNET_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.ulcAddresses == other.ulcAddresses && self.rgAddressl == other.rgAddressl
    }
}
impl ::std::cmp::Eq for BDA_ETHERNET_ADDRESS_LIST {}
unsafe impl ::windows::runtime::Abi for BDA_ETHERNET_ADDRESS_LIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_EVENT_DATA {
    pub lResult: i32,
    pub ulEventID: u32,
    pub uuidEventType: ::windows::runtime::GUID,
    pub ulEventDataLength: u32,
    pub argbEventData: [u8; 1],
}
impl BDA_EVENT_DATA {}
impl ::std::default::Default for BDA_EVENT_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_EVENT_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_EVENT_DATA").field("lResult", &self.lResult).field("ulEventID", &self.ulEventID).field("uuidEventType", &self.uuidEventType).field("ulEventDataLength", &self.ulEventDataLength).field("argbEventData", &self.argbEventData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_EVENT_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulEventID == other.ulEventID && self.uuidEventType == other.uuidEventType && self.ulEventDataLength == other.ulEventDataLength && self.argbEventData == other.argbEventData
    }
}
impl ::std::cmp::Eq for BDA_EVENT_DATA {}
unsafe impl ::windows::runtime::Abi for BDA_EVENT_DATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_EVENT_ID(pub i32);
pub const BDA_EVENT_SIGNAL_LOSS: BDA_EVENT_ID = BDA_EVENT_ID(0i32);
pub const BDA_EVENT_SIGNAL_LOCK: BDA_EVENT_ID = BDA_EVENT_ID(1i32);
pub const BDA_EVENT_DATA_START: BDA_EVENT_ID = BDA_EVENT_ID(2i32);
pub const BDA_EVENT_DATA_STOP: BDA_EVENT_ID = BDA_EVENT_ID(3i32);
pub const BDA_EVENT_CHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(4i32);
pub const BDA_EVENT_CHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(5i32);
pub const BDA_EVENT_CHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(6i32);
pub const BDA_EVENT_CHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(7i32);
pub const BDA_EVENT_CHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(8i32);
pub const BDA_EVENT_SUBCHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(9i32);
pub const BDA_EVENT_SUBCHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(10i32);
pub const BDA_EVENT_SUBCHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(11i32);
pub const BDA_EVENT_SUBCHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(12i32);
pub const BDA_EVENT_SUBCHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(13i32);
pub const BDA_EVENT_ACCESS_GRANTED: BDA_EVENT_ID = BDA_EVENT_ID(14i32);
pub const BDA_EVENT_ACCESS_DENIED: BDA_EVENT_ID = BDA_EVENT_ID(15i32);
pub const BDA_EVENT_OFFER_EXTENDED: BDA_EVENT_ID = BDA_EVENT_ID(16i32);
pub const BDA_EVENT_PURCHASE_COMPLETED: BDA_EVENT_ID = BDA_EVENT_ID(17i32);
pub const BDA_EVENT_SMART_CARD_INSERTED: BDA_EVENT_ID = BDA_EVENT_ID(18i32);
pub const BDA_EVENT_SMART_CARD_REMOVED: BDA_EVENT_ID = BDA_EVENT_ID(19i32);
impl ::std::convert::From<i32> for BDA_EVENT_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_EVENT_ID {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_ACCESS_DENIED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479671i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_BUFFER_TOO_SMALL: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479669i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_DISABLED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479666i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_FAILURE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479679i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_CAPTURE_TOKEN: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073463294i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_ENTITLEMENT_TOKEN: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073463295i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_HANDLE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479674i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_LANGUAGE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479664i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_PURCHASE_TOKEN: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073463292i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_SCHEMA: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479675i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_TUNE_REQUEST: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073467388i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_INVALID_TYPE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479673i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_IPNETWORK_ADDRESS_NOT_FOUND: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073459198i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_IPNETWORK_ERROR: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073459199i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_IPNETWORK_TIMEOUT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073459197i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_IPNETWORK_UNAVAILABLE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073459196i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NOT_FOUND: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479670i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NOT_IMPLEMENTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479678i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NO_HANDLER: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479665i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NO_MORE_DATA: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073475582i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NO_MORE_EVENTS: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073475583i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_NO_SUCH_COMMAND: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479677i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_OUT_OF_BOUNDS: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479676i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_OUT_OF_MEMORY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479667i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_OUT_OF_RESOURCES: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479668i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_READ_ONLY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479672i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TIMEOUT_ELAPSED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073479663i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNER_CONFLICT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073467389i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNER_INITIALIZING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073467391i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNER_REQUIRED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073467390i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV01: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455103i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV02: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455102i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV03: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455101i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV04: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455100i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV05: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455099i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV06: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455098i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV07: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455097i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDV08: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073455096i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_TUNE_FAILED_SDVFF: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073454849i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_INVALID_CERTIFICATE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418238i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_INVALID_DATE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418235i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_INVALID_PROXIMITY: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418234i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_INVALID_SIGNATURE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418239i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_INVALID_VERSION: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418236i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WMDRM_KEY_ID_NOT_FOUND: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073418232i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_E_WOULD_DISRUPT_STREAMING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-1073463293i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Frequency(pub i32);
pub const BDA_FREQUENCY_NOT_SET: BDA_Frequency = BDA_Frequency(-1i32);
pub const BDA_FREQUENCY_NOT_DEFINED: BDA_Frequency = BDA_Frequency(0i32);
impl ::std::convert::From<i32> for BDA_Frequency {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Frequency {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Frequency_Multiplier(pub i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_SET: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(-1i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(0i32);
impl ::std::convert::From<i32> for BDA_Frequency_Multiplier {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Frequency_Multiplier {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_GDDS_DATA {
    pub lResult: i32,
    pub ulDataLength: u32,
    pub ulPercentageProgress: u32,
    pub argbData: [u8; 1],
}
impl BDA_GDDS_DATA {}
impl ::std::default::Default for BDA_GDDS_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_GDDS_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_GDDS_DATA").field("lResult", &self.lResult).field("ulDataLength", &self.ulDataLength).field("ulPercentageProgress", &self.ulPercentageProgress).field("argbData", &self.argbData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_GDDS_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulDataLength == other.ulDataLength && self.ulPercentageProgress == other.ulPercentageProgress && self.argbData == other.argbData
    }
}
impl ::std::cmp::Eq for BDA_GDDS_DATA {}
unsafe impl ::windows::runtime::Abi for BDA_GDDS_DATA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_GDDS_DATATYPE {
    pub lResult: i32,
    pub uuidDataType: ::windows::runtime::GUID,
}
impl BDA_GDDS_DATATYPE {}
impl ::std::default::Default for BDA_GDDS_DATATYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_GDDS_DATATYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_GDDS_DATATYPE").field("lResult", &self.lResult).field("uuidDataType", &self.uuidDataType).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_GDDS_DATATYPE {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.uuidDataType == other.uuidDataType
    }
}
impl ::std::cmp::Eq for BDA_GDDS_DATATYPE {}
unsafe impl ::windows::runtime::Abi for BDA_GDDS_DATATYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_IPv4_ADDRESS {
    pub rgbAddress: [u8; 4],
}
impl BDA_IPv4_ADDRESS {}
impl ::std::default::Default for BDA_IPv4_ADDRESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_IPv4_ADDRESS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_IPv4_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_IPv4_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.rgbAddress == other.rgbAddress
    }
}
impl ::std::cmp::Eq for BDA_IPv4_ADDRESS {}
unsafe impl ::windows::runtime::Abi for BDA_IPv4_ADDRESS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_IPv4_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv4_ADDRESS; 1],
}
impl BDA_IPv4_ADDRESS_LIST {}
impl ::std::default::Default for BDA_IPv4_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_IPv4_ADDRESS_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_IPv4_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_IPv4_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.ulcAddresses == other.ulcAddresses && self.rgAddressl == other.rgAddressl
    }
}
impl ::std::cmp::Eq for BDA_IPv4_ADDRESS_LIST {}
unsafe impl ::windows::runtime::Abi for BDA_IPv4_ADDRESS_LIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_IPv6_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl BDA_IPv6_ADDRESS {}
impl ::std::default::Default for BDA_IPv6_ADDRESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_IPv6_ADDRESS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_IPv6_ADDRESS").field("rgbAddress", &self.rgbAddress).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_IPv6_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        self.rgbAddress == other.rgbAddress
    }
}
impl ::std::cmp::Eq for BDA_IPv6_ADDRESS {}
unsafe impl ::windows::runtime::Abi for BDA_IPv6_ADDRESS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_IPv6_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv6_ADDRESS; 1],
}
impl BDA_IPv6_ADDRESS_LIST {}
impl ::std::default::Default for BDA_IPv6_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_IPv6_ADDRESS_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_IPv6_ADDRESS_LIST").field("ulcAddresses", &self.ulcAddresses).field("rgAddressl", &self.rgAddressl).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_IPv6_ADDRESS_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.ulcAddresses == other.ulcAddresses && self.rgAddressl == other.rgAddressl
    }
}
impl ::std::cmp::Eq for BDA_IPv6_ADDRESS_LIST {}
unsafe impl ::windows::runtime::Abi for BDA_IPv6_ADDRESS_LIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_ISDBCAS_EMG_REQ {
    pub bCLA: u8,
    pub bINS: u8,
    pub bP1: u8,
    pub bP2: u8,
    pub bLC: u8,
    pub bCardId: [u8; 6],
    pub bProtocol: u8,
    pub bCABroadcasterGroupId: u8,
    pub bMessageControl: u8,
    pub bMessageCode: [u8; 1],
}
impl BDA_ISDBCAS_EMG_REQ {}
impl ::std::default::Default for BDA_ISDBCAS_EMG_REQ {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_ISDBCAS_EMG_REQ {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_ISDBCAS_EMG_REQ")
            .field("bCLA", &self.bCLA)
            .field("bINS", &self.bINS)
            .field("bP1", &self.bP1)
            .field("bP2", &self.bP2)
            .field("bLC", &self.bLC)
            .field("bCardId", &self.bCardId)
            .field("bProtocol", &self.bProtocol)
            .field("bCABroadcasterGroupId", &self.bCABroadcasterGroupId)
            .field("bMessageControl", &self.bMessageControl)
            .field("bMessageCode", &self.bMessageCode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BDA_ISDBCAS_EMG_REQ {
    fn eq(&self, other: &Self) -> bool {
        self.bCLA == other.bCLA && self.bINS == other.bINS && self.bP1 == other.bP1 && self.bP2 == other.bP2 && self.bLC == other.bLC && self.bCardId == other.bCardId && self.bProtocol == other.bProtocol && self.bCABroadcasterGroupId == other.bCABroadcasterGroupId && self.bMessageControl == other.bMessageControl && self.bMessageCode == other.bMessageCode
    }
}
impl ::std::cmp::Eq for BDA_ISDBCAS_EMG_REQ {}
unsafe impl ::windows::runtime::Abi for BDA_ISDBCAS_EMG_REQ {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_ISDBCAS_REQUESTHEADER {
    pub bInstruction: u8,
    pub bReserved: [u8; 3],
    pub ulDataLength: u32,
    pub argbIsdbCommand: [u8; 1],
}
impl BDA_ISDBCAS_REQUESTHEADER {}
impl ::std::default::Default for BDA_ISDBCAS_REQUESTHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for BDA_ISDBCAS_REQUESTHEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for BDA_ISDBCAS_REQUESTHEADER {}
unsafe impl ::windows::runtime::Abi for BDA_ISDBCAS_REQUESTHEADER {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_ISDBCAS_RESPONSEDATA {
    pub lResult: i32,
    pub ulRequestID: u32,
    pub ulIsdbStatus: u32,
    pub ulIsdbDataSize: u32,
    pub argbIsdbCommandData: [u8; 1],
}
impl BDA_ISDBCAS_RESPONSEDATA {}
impl ::std::default::Default for BDA_ISDBCAS_RESPONSEDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for BDA_ISDBCAS_RESPONSEDATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for BDA_ISDBCAS_RESPONSEDATA {}
unsafe impl ::windows::runtime::Abi for BDA_ISDBCAS_RESPONSEDATA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_LockType(pub i32);
pub const Bda_LockType_None: BDA_LockType = BDA_LockType(0i32);
pub const Bda_LockType_PLL: BDA_LockType = BDA_LockType(1i32);
pub const Bda_LockType_DecoderDemod: BDA_LockType = BDA_LockType(2i32);
pub const Bda_LockType_Complete: BDA_LockType = BDA_LockType(128i32);
impl ::std::convert::From<i32> for BDA_LockType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_LockType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_MULTICAST_MODE(pub i32);
pub const BDA_PROMISCUOUS_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(0i32);
pub const BDA_FILTERED_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(1i32);
pub const BDA_NO_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(2i32);
impl ::std::convert::From<i32> for BDA_MULTICAST_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_MULTICAST_MODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(2))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_MUX_PIDLISTITEM {
    pub usPIDNumber: u16,
    pub usProgramNumber: u16,
    pub ePIDType: MUX_PID_TYPE,
}
impl BDA_MUX_PIDLISTITEM {}
impl ::std::default::Default for BDA_MUX_PIDLISTITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for BDA_MUX_PIDLISTITEM {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for BDA_MUX_PIDLISTITEM {}
unsafe impl ::windows::runtime::Abi for BDA_MUX_PIDLISTITEM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_PID_MAP {
    pub MediaSampleContent: MEDIA_SAMPLE_CONTENT,
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl BDA_PID_MAP {}
impl ::std::default::Default for BDA_PID_MAP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_PID_MAP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_PID_MAP").field("MediaSampleContent", &self.MediaSampleContent).field("ulcPIDs", &self.ulcPIDs).field("aulPIDs", &self.aulPIDs).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_PID_MAP {
    fn eq(&self, other: &Self) -> bool {
        self.MediaSampleContent == other.MediaSampleContent && self.ulcPIDs == other.ulcPIDs && self.aulPIDs == other.aulPIDs
    }
}
impl ::std::cmp::Eq for BDA_PID_MAP {}
unsafe impl ::windows::runtime::Abi for BDA_PID_MAP {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_PID_UNMAP {
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl BDA_PID_UNMAP {}
impl ::std::default::Default for BDA_PID_UNMAP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_PID_UNMAP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_PID_UNMAP").field("ulcPIDs", &self.ulcPIDs).field("aulPIDs", &self.aulPIDs).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_PID_UNMAP {
    fn eq(&self, other: &Self) -> bool {
        self.ulcPIDs == other.ulcPIDs && self.aulPIDs == other.aulPIDs
    }
}
impl ::std::cmp::Eq for BDA_PID_UNMAP {}
unsafe impl ::windows::runtime::Abi for BDA_PID_UNMAP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const BDA_PLP_ID_NOT_SET: i32 = -1i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_PROGRAM_PID_LIST {
    pub ulProgramNumber: u32,
    pub ulcPIDs: u32,
    pub ulPID: [u32; 1],
}
impl BDA_PROGRAM_PID_LIST {}
impl ::std::default::Default for BDA_PROGRAM_PID_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_PROGRAM_PID_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_PROGRAM_PID_LIST").field("ulProgramNumber", &self.ulProgramNumber).field("ulcPIDs", &self.ulcPIDs).field("ulPID", &self.ulPID).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_PROGRAM_PID_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.ulProgramNumber == other.ulProgramNumber && self.ulcPIDs == other.ulcPIDs && self.ulPID == other.ulPID
    }
}
impl ::std::cmp::Eq for BDA_PROGRAM_PID_LIST {}
unsafe impl ::windows::runtime::Abi for BDA_PROGRAM_PID_LIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_RATING_PINRESET {
    pub bPinLength: u8,
    pub argbNewPin: [u8; 1],
}
impl BDA_RATING_PINRESET {}
impl ::std::default::Default for BDA_RATING_PINRESET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_RATING_PINRESET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_RATING_PINRESET").field("bPinLength", &self.bPinLength).field("argbNewPin", &self.argbNewPin).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_RATING_PINRESET {
    fn eq(&self, other: &Self) -> bool {
        self.bPinLength == other.bPinLength && self.argbNewPin == other.argbNewPin
    }
}
impl ::std::cmp::Eq for BDA_RATING_PINRESET {}
unsafe impl ::windows::runtime::Abi for BDA_RATING_PINRESET {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_Range(pub i32);
pub const BDA_RANGE_NOT_SET: BDA_Range = BDA_Range(-1i32);
pub const BDA_RANGE_NOT_DEFINED: BDA_Range = BDA_Range(0i32);
impl ::std::convert::From<i32> for BDA_Range {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_Range {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_SCAN_CAPABILTIES {
    pub lResult: i32,
    pub ul64AnalogStandardsSupported: u64,
}
impl BDA_SCAN_CAPABILTIES {}
impl ::std::default::Default for BDA_SCAN_CAPABILTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_SCAN_CAPABILTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_SCAN_CAPABILTIES").field("lResult", &self.lResult).field("ul64AnalogStandardsSupported", &self.ul64AnalogStandardsSupported).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_SCAN_CAPABILTIES {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ul64AnalogStandardsSupported == other.ul64AnalogStandardsSupported
    }
}
impl ::std::cmp::Eq for BDA_SCAN_CAPABILTIES {}
unsafe impl ::windows::runtime::Abi for BDA_SCAN_CAPABILTIES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_SCAN_START {
    pub lResult: i32,
    pub LowerFrequency: u32,
    pub HigerFrequency: u32,
}
impl BDA_SCAN_START {}
impl ::std::default::Default for BDA_SCAN_START {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_SCAN_START {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_SCAN_START").field("lResult", &self.lResult).field("LowerFrequency", &self.LowerFrequency).field("HigerFrequency", &self.HigerFrequency).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_SCAN_START {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.LowerFrequency == other.LowerFrequency && self.HigerFrequency == other.HigerFrequency
    }
}
impl ::std::cmp::Eq for BDA_SCAN_START {}
unsafe impl ::windows::runtime::Abi for BDA_SCAN_START {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_SCAN_STATE {
    pub lResult: i32,
    pub ulSignalLock: u32,
    pub ulSecondsLeft: u32,
    pub ulCurrentFrequency: u32,
}
impl BDA_SCAN_STATE {}
impl ::std::default::Default for BDA_SCAN_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_SCAN_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_SCAN_STATE").field("lResult", &self.lResult).field("ulSignalLock", &self.ulSignalLock).field("ulSecondsLeft", &self.ulSecondsLeft).field("ulCurrentFrequency", &self.ulCurrentFrequency).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_SCAN_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulSignalLock == other.ulSignalLock && self.ulSecondsLeft == other.ulSecondsLeft && self.ulCurrentFrequency == other.ulCurrentFrequency
    }
}
impl ::std::cmp::Eq for BDA_SCAN_STATE {}
unsafe impl ::windows::runtime::Abi for BDA_SCAN_STATE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_SIGNAL_STATE(pub i32);
pub const BDA_SIGNAL_UNAVAILABLE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(0i32);
pub const BDA_SIGNAL_INACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(1i32);
pub const BDA_SIGNAL_ACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(2i32);
impl ::std::convert::From<i32> for BDA_SIGNAL_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_SIGNAL_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_SIGNAL_TIMEOUTS {
    pub ulCarrierTimeoutMs: u32,
    pub ulScanningTimeoutMs: u32,
    pub ulTuningTimeoutMs: u32,
}
impl BDA_SIGNAL_TIMEOUTS {}
impl ::std::default::Default for BDA_SIGNAL_TIMEOUTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_SIGNAL_TIMEOUTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_SIGNAL_TIMEOUTS").field("ulCarrierTimeoutMs", &self.ulCarrierTimeoutMs).field("ulScanningTimeoutMs", &self.ulScanningTimeoutMs).field("ulTuningTimeoutMs", &self.ulTuningTimeoutMs).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_SIGNAL_TIMEOUTS {
    fn eq(&self, other: &Self) -> bool {
        self.ulCarrierTimeoutMs == other.ulCarrierTimeoutMs && self.ulScanningTimeoutMs == other.ulScanningTimeoutMs && self.ulTuningTimeoutMs == other.ulTuningTimeoutMs
    }
}
impl ::std::cmp::Eq for BDA_SIGNAL_TIMEOUTS {}
unsafe impl ::windows::runtime::Abi for BDA_SIGNAL_TIMEOUTS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_STRING {
    pub lResult: i32,
    pub ulStringSize: u32,
    pub argbString: [u8; 1],
}
impl BDA_STRING {}
impl ::std::default::Default for BDA_STRING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_STRING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_STRING").field("lResult", &self.lResult).field("ulStringSize", &self.ulStringSize).field("argbString", &self.argbString).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_STRING {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulStringSize == other.ulStringSize && self.argbString == other.argbString
    }
}
impl ::std::cmp::Eq for BDA_STRING {}
unsafe impl ::windows::runtime::Abi for BDA_STRING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BDA_SignalType(pub i32);
pub const Bda_SignalType_Unknown: BDA_SignalType = BDA_SignalType(0i32);
pub const Bda_SignalType_Analog: BDA_SignalType = BDA_SignalType(1i32);
pub const Bda_SignalType_Digital: BDA_SignalType = BDA_SignalType(2i32);
impl ::std::convert::From<i32> for BDA_SignalType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BDA_SignalType {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TABLE_SECTION {
    pub ulPrimarySectionId: u32,
    pub ulSecondarySectionId: u32,
    pub ulcbSectionLength: u32,
    pub argbSectionData: [u32; 1],
}
impl BDA_TABLE_SECTION {}
impl ::std::default::Default for BDA_TABLE_SECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TABLE_SECTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TABLE_SECTION").field("ulPrimarySectionId", &self.ulPrimarySectionId).field("ulSecondarySectionId", &self.ulSecondarySectionId).field("ulcbSectionLength", &self.ulcbSectionLength).field("argbSectionData", &self.argbSectionData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TABLE_SECTION {
    fn eq(&self, other: &Self) -> bool {
        self.ulPrimarySectionId == other.ulPrimarySectionId && self.ulSecondarySectionId == other.ulSecondarySectionId && self.ulcbSectionLength == other.ulcbSectionLength && self.argbSectionData == other.argbSectionData
    }
}
impl ::std::cmp::Eq for BDA_TABLE_SECTION {}
unsafe impl ::windows::runtime::Abi for BDA_TABLE_SECTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TEMPLATE_CONNECTION {
    pub FromNodeType: u32,
    pub FromNodePinType: u32,
    pub ToNodeType: u32,
    pub ToNodePinType: u32,
}
impl BDA_TEMPLATE_CONNECTION {}
impl ::std::default::Default for BDA_TEMPLATE_CONNECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TEMPLATE_CONNECTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TEMPLATE_CONNECTION").field("FromNodeType", &self.FromNodeType).field("FromNodePinType", &self.FromNodePinType).field("ToNodeType", &self.ToNodeType).field("ToNodePinType", &self.ToNodePinType).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TEMPLATE_CONNECTION {
    fn eq(&self, other: &Self) -> bool {
        self.FromNodeType == other.FromNodeType && self.FromNodePinType == other.FromNodePinType && self.ToNodeType == other.ToNodeType && self.ToNodePinType == other.ToNodePinType
    }
}
impl ::std::cmp::Eq for BDA_TEMPLATE_CONNECTION {}
unsafe impl ::windows::runtime::Abi for BDA_TEMPLATE_CONNECTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TEMPLATE_PIN_JOINT {
    pub uliTemplateConnection: u32,
    pub ulcInstancesMax: u32,
}
impl BDA_TEMPLATE_PIN_JOINT {}
impl ::std::default::Default for BDA_TEMPLATE_PIN_JOINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TEMPLATE_PIN_JOINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TEMPLATE_PIN_JOINT").field("uliTemplateConnection", &self.uliTemplateConnection).field("ulcInstancesMax", &self.ulcInstancesMax).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TEMPLATE_PIN_JOINT {
    fn eq(&self, other: &Self) -> bool {
        self.uliTemplateConnection == other.uliTemplateConnection && self.ulcInstancesMax == other.ulcInstancesMax
    }
}
impl ::std::cmp::Eq for BDA_TEMPLATE_PIN_JOINT {}
unsafe impl ::windows::runtime::Abi for BDA_TEMPLATE_PIN_JOINT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TRANSPORT_INFO {
    pub ulcbPhyiscalPacket: u32,
    pub ulcbPhyiscalFrame: u32,
    pub ulcbPhyiscalFrameAlignment: u32,
    pub AvgTimePerFrame: i64,
}
impl BDA_TRANSPORT_INFO {}
impl ::std::default::Default for BDA_TRANSPORT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TRANSPORT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TRANSPORT_INFO").field("ulcbPhyiscalPacket", &self.ulcbPhyiscalPacket).field("ulcbPhyiscalFrame", &self.ulcbPhyiscalFrame).field("ulcbPhyiscalFrameAlignment", &self.ulcbPhyiscalFrameAlignment).field("AvgTimePerFrame", &self.AvgTimePerFrame).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TRANSPORT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulcbPhyiscalPacket == other.ulcbPhyiscalPacket && self.ulcbPhyiscalFrame == other.ulcbPhyiscalFrame && self.ulcbPhyiscalFrameAlignment == other.ulcbPhyiscalFrameAlignment && self.AvgTimePerFrame == other.AvgTimePerFrame
    }
}
impl ::std::cmp::Eq for BDA_TRANSPORT_INFO {}
unsafe impl ::windows::runtime::Abi for BDA_TRANSPORT_INFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TS_SELECTORINFO {
    pub bTSInfolength: u8,
    pub bReserved: [u8; 2],
    pub guidNetworkType: ::windows::runtime::GUID,
    pub bTSIDCount: u8,
    pub usTSID: [u16; 1],
}
impl BDA_TS_SELECTORINFO {}
impl ::std::default::Default for BDA_TS_SELECTORINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for BDA_TS_SELECTORINFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for BDA_TS_SELECTORINFO {}
unsafe impl ::windows::runtime::Abi for BDA_TS_SELECTORINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TS_SELECTORINFO_ISDBS_EXT {
    pub bTMCC: [u8; 48],
}
impl BDA_TS_SELECTORINFO_ISDBS_EXT {}
impl ::std::default::Default for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TS_SELECTORINFO_ISDBS_EXT").field("bTMCC", &self.bTMCC).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn eq(&self, other: &Self) -> bool {
        self.bTMCC == other.bTMCC
    }
}
impl ::std::cmp::Eq for BDA_TS_SELECTORINFO_ISDBS_EXT {}
unsafe impl ::windows::runtime::Abi for BDA_TS_SELECTORINFO_ISDBS_EXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TUNER_DIAGNOSTICS {
    pub lResult: i32,
    pub ulSignalLevel: u32,
    pub ulSignalLevelQuality: u32,
    pub ulSignalNoiseRatio: u32,
}
impl BDA_TUNER_DIAGNOSTICS {}
impl ::std::default::Default for BDA_TUNER_DIAGNOSTICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TUNER_DIAGNOSTICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TUNER_DIAGNOSTICS").field("lResult", &self.lResult).field("ulSignalLevel", &self.ulSignalLevel).field("ulSignalLevelQuality", &self.ulSignalLevelQuality).field("ulSignalNoiseRatio", &self.ulSignalNoiseRatio).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TUNER_DIAGNOSTICS {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulSignalLevel == other.ulSignalLevel && self.ulSignalLevelQuality == other.ulSignalLevelQuality && self.ulSignalNoiseRatio == other.ulSignalNoiseRatio
    }
}
impl ::std::cmp::Eq for BDA_TUNER_DIAGNOSTICS {}
unsafe impl ::windows::runtime::Abi for BDA_TUNER_DIAGNOSTICS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_TUNER_TUNERSTATE {
    pub lResult: i32,
    pub ulTuneLength: u32,
    pub argbTuneData: [u8; 1],
}
impl BDA_TUNER_TUNERSTATE {}
impl ::std::default::Default for BDA_TUNER_TUNERSTATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_TUNER_TUNERSTATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_TUNER_TUNERSTATE").field("lResult", &self.lResult).field("ulTuneLength", &self.ulTuneLength).field("argbTuneData", &self.argbTuneData).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_TUNER_TUNERSTATE {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulTuneLength == other.ulTuneLength && self.argbTuneData == other.argbTuneData
    }
}
impl ::std::cmp::Eq for BDA_TUNER_TUNERSTATE {}
unsafe impl ::windows::runtime::Abi for BDA_TUNER_TUNERSTATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_USERACTIVITY_INTERVAL {
    pub lResult: i32,
    pub ulActivityInterval: u32,
}
impl BDA_USERACTIVITY_INTERVAL {}
impl ::std::default::Default for BDA_USERACTIVITY_INTERVAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_USERACTIVITY_INTERVAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_USERACTIVITY_INTERVAL").field("lResult", &self.lResult).field("ulActivityInterval", &self.ulActivityInterval).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_USERACTIVITY_INTERVAL {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulActivityInterval == other.ulActivityInterval
    }
}
impl ::std::cmp::Eq for BDA_USERACTIVITY_INTERVAL {}
unsafe impl ::windows::runtime::Abi for BDA_USERACTIVITY_INTERVAL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_WMDRMTUNER_PIDPROTECTION {
    pub lResult: i32,
    pub uuidKeyID: ::windows::runtime::GUID,
}
impl BDA_WMDRMTUNER_PIDPROTECTION {}
impl ::std::default::Default for BDA_WMDRMTUNER_PIDPROTECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_WMDRMTUNER_PIDPROTECTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_WMDRMTUNER_PIDPROTECTION").field("lResult", &self.lResult).field("uuidKeyID", &self.uuidKeyID).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_WMDRMTUNER_PIDPROTECTION {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.uuidKeyID == other.uuidKeyID
    }
}
impl ::std::cmp::Eq for BDA_WMDRMTUNER_PIDPROTECTION {}
unsafe impl ::windows::runtime::Abi for BDA_WMDRMTUNER_PIDPROTECTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulCaptureTokenLength: u32,
    pub argbCaptureTokenBuffer: [u8; 1],
}
impl BDA_WMDRMTUNER_PURCHASEENTITLEMENT {}
impl ::std::default::Default for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_WMDRMTUNER_PURCHASEENTITLEMENT").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).field("ulCaptureTokenLength", &self.ulCaptureTokenLength).field("argbCaptureTokenBuffer", &self.argbCaptureTokenBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulDescrambleStatus == other.ulDescrambleStatus && self.ulCaptureTokenLength == other.ulCaptureTokenLength && self.argbCaptureTokenBuffer == other.argbCaptureTokenBuffer
    }
}
impl ::std::cmp::Eq for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {}
unsafe impl ::windows::runtime::Abi for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_WMDRM_KEYINFOLIST {
    pub lResult: i32,
    pub ulKeyuuidBufferLen: u32,
    pub argKeyuuidBuffer: [::windows::runtime::GUID; 1],
}
impl BDA_WMDRM_KEYINFOLIST {}
impl ::std::default::Default for BDA_WMDRM_KEYINFOLIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_WMDRM_KEYINFOLIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_WMDRM_KEYINFOLIST").field("lResult", &self.lResult).field("ulKeyuuidBufferLen", &self.ulKeyuuidBufferLen).field("argKeyuuidBuffer", &self.argKeyuuidBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_WMDRM_KEYINFOLIST {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulKeyuuidBufferLen == other.ulKeyuuidBufferLen && self.argKeyuuidBuffer == other.argKeyuuidBuffer
    }
}
impl ::std::cmp::Eq for BDA_WMDRM_KEYINFOLIST {}
unsafe impl ::windows::runtime::Abi for BDA_WMDRM_KEYINFOLIST {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_WMDRM_RENEWLICENSE {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulXmrLicenseOutputLength: u32,
    pub argbXmrLicenceOutputBuffer: [u8; 1],
}
impl BDA_WMDRM_RENEWLICENSE {}
impl ::std::default::Default for BDA_WMDRM_RENEWLICENSE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_WMDRM_RENEWLICENSE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_WMDRM_RENEWLICENSE").field("lResult", &self.lResult).field("ulDescrambleStatus", &self.ulDescrambleStatus).field("ulXmrLicenseOutputLength", &self.ulXmrLicenseOutputLength).field("argbXmrLicenceOutputBuffer", &self.argbXmrLicenceOutputBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for BDA_WMDRM_RENEWLICENSE {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulDescrambleStatus == other.ulDescrambleStatus && self.ulXmrLicenseOutputLength == other.ulXmrLicenseOutputLength && self.argbXmrLicenceOutputBuffer == other.argbXmrLicenceOutputBuffer
    }
}
impl ::std::cmp::Eq for BDA_WMDRM_RENEWLICENSE {}
unsafe impl ::windows::runtime::Abi for BDA_WMDRM_RENEWLICENSE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BDA_WMDRM_STATUS {
    pub lResult: i32,
    pub ulMaxCaptureTokenSize: u32,
    pub uMaxStreamingPid: u32,
    pub ulMaxLicense: u32,
    pub ulMinSecurityLevel: u32,
    pub ulRevInfoSequenceNumber: u32,
    pub ulRevInfoIssuedTime: u64,
    pub ulRevListVersion: u32,
    pub ulRevInfoTTL: u32,
    pub ulState: u32,
}
impl BDA_WMDRM_STATUS {}
impl ::std::default::Default for BDA_WMDRM_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BDA_WMDRM_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BDA_WMDRM_STATUS")
            .field("lResult", &self.lResult)
            .field("ulMaxCaptureTokenSize", &self.ulMaxCaptureTokenSize)
            .field("uMaxStreamingPid", &self.uMaxStreamingPid)
            .field("ulMaxLicense", &self.ulMaxLicense)
            .field("ulMinSecurityLevel", &self.ulMinSecurityLevel)
            .field("ulRevInfoSequenceNumber", &self.ulRevInfoSequenceNumber)
            .field("ulRevInfoIssuedTime", &self.ulRevInfoIssuedTime)
            .field("ulRevListVersion", &self.ulRevListVersion)
            .field("ulRevInfoTTL", &self.ulRevInfoTTL)
            .field("ulState", &self.ulState)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BDA_WMDRM_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.lResult == other.lResult && self.ulMaxCaptureTokenSize == other.ulMaxCaptureTokenSize && self.uMaxStreamingPid == other.uMaxStreamingPid && self.ulMaxLicense == other.ulMaxLicense && self.ulMinSecurityLevel == other.ulMinSecurityLevel && self.ulRevInfoSequenceNumber == other.ulRevInfoSequenceNumber && self.ulRevInfoIssuedTime == other.ulRevInfoIssuedTime && self.ulRevListVersion == other.ulRevListVersion && self.ulRevInfoTTL == other.ulRevInfoTTL && self.ulState == other.ulState
    }
}
impl ::std::cmp::Eq for BDA_WMDRM_STATUS {}
unsafe impl ::windows::runtime::Abi for BDA_WMDRM_STATUS {
    type Abi = Self;
}
pub const BSKYB_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2661172934, 15034, 20232, [173, 14, 204, 90, 200, 20, 140, 43]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct BadSampleInfo {
    pub hrReason: ::windows::runtime::HRESULT,
}
impl BadSampleInfo {}
impl ::std::default::Default for BadSampleInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for BadSampleInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for BadSampleInfo {}
unsafe impl ::windows::runtime::Abi for BadSampleInfo {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BfEnTvRat_Attributes_CAE_TV(pub i32);
pub const CAE_IsBlocked: BfEnTvRat_Attributes_CAE_TV = BfEnTvRat_Attributes_CAE_TV(1i32);
pub const CAE_ValidAttrSubmask: BfEnTvRat_Attributes_CAE_TV = BfEnTvRat_Attributes_CAE_TV(1i32);
impl ::std::convert::From<i32> for BfEnTvRat_Attributes_CAE_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BfEnTvRat_Attributes_CAE_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BfEnTvRat_Attributes_CAF_TV(pub i32);
pub const CAF_IsBlocked: BfEnTvRat_Attributes_CAF_TV = BfEnTvRat_Attributes_CAF_TV(1i32);
pub const CAF_ValidAttrSubmask: BfEnTvRat_Attributes_CAF_TV = BfEnTvRat_Attributes_CAF_TV(1i32);
impl ::std::convert::From<i32> for BfEnTvRat_Attributes_CAF_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BfEnTvRat_Attributes_CAF_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BfEnTvRat_Attributes_MPAA(pub i32);
pub const MPAA_IsBlocked: BfEnTvRat_Attributes_MPAA = BfEnTvRat_Attributes_MPAA(1i32);
pub const MPAA_ValidAttrSubmask: BfEnTvRat_Attributes_MPAA = BfEnTvRat_Attributes_MPAA(1i32);
impl ::std::convert::From<i32> for BfEnTvRat_Attributes_MPAA {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BfEnTvRat_Attributes_MPAA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BfEnTvRat_Attributes_US_TV(pub i32);
pub const US_TV_IsBlocked: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(1i32);
pub const US_TV_IsViolent: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(2i32);
pub const US_TV_IsSexualSituation: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(4i32);
pub const US_TV_IsAdultLanguage: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(8i32);
pub const US_TV_IsSexuallySuggestiveDialog: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(16i32);
pub const US_TV_ValidAttrSubmask: BfEnTvRat_Attributes_US_TV = BfEnTvRat_Attributes_US_TV(31i32);
impl ::std::convert::From<i32> for BfEnTvRat_Attributes_US_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BfEnTvRat_Attributes_US_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BfEnTvRat_GenericAttributes(pub i32);
pub const BfAttrNone: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(0i32);
pub const BfIsBlocked: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(1i32);
pub const BfIsAttr_1: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(2i32);
pub const BfIsAttr_2: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(4i32);
pub const BfIsAttr_3: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(8i32);
pub const BfIsAttr_4: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(16i32);
pub const BfIsAttr_5: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(32i32);
pub const BfIsAttr_6: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(64i32);
pub const BfIsAttr_7: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(128i32);
pub const BfValidAttrSubmask: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(255i32);
impl ::std::convert::From<i32> for BfEnTvRat_GenericAttributes {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BfEnTvRat_GenericAttributes {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct BinaryConvolutionCodeRate(pub i32);
pub const BDA_BCC_RATE_NOT_SET: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(-1i32);
pub const BDA_BCC_RATE_NOT_DEFINED: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(0i32);
pub const BDA_BCC_RATE_1_2: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(1i32);
pub const BDA_BCC_RATE_2_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(2i32);
pub const BDA_BCC_RATE_3_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(3i32);
pub const BDA_BCC_RATE_3_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(4i32);
pub const BDA_BCC_RATE_4_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(5i32);
pub const BDA_BCC_RATE_5_6: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(6i32);
pub const BDA_BCC_RATE_5_11: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(7i32);
pub const BDA_BCC_RATE_7_8: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(8i32);
pub const BDA_BCC_RATE_1_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(9i32);
pub const BDA_BCC_RATE_1_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(10i32);
pub const BDA_BCC_RATE_2_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(11i32);
pub const BDA_BCC_RATE_6_7: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(12i32);
pub const BDA_BCC_RATE_8_9: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(13i32);
pub const BDA_BCC_RATE_9_10: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(14i32);
pub const BDA_BCC_RATE_MAX: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(15i32);
impl ::std::convert::From<i32> for BinaryConvolutionCodeRate {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BinaryConvolutionCodeRate {
    type Abi = Self;
}
pub const BroadcastEventService: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(188742546, 2329, 18740, [157, 91, 97, 156, 113, 157, 2, 2]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct CAPTURE_STREAMTIME {
    pub StreamTime: i64,
}
impl CAPTURE_STREAMTIME {}
impl ::std::default::Default for CAPTURE_STREAMTIME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CAPTURE_STREAMTIME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CAPTURE_STREAMTIME").field("StreamTime", &self.StreamTime).finish()
    }
}
impl ::std::cmp::PartialEq for CAPTURE_STREAMTIME {
    fn eq(&self, other: &Self) -> bool {
        self.StreamTime == other.StreamTime
    }
}
impl ::std::cmp::Eq for CAPTURE_STREAMTIME {}
unsafe impl ::windows::runtime::Abi for CAPTURE_STREAMTIME {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_BYPASS_CLASS_MANAGER: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_CLASS_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_DEVMON_CMGR_DEVICE: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_DEVMON_DMO: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_DEVMON_FILTER: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_DEVMON_PNP_DEVICE: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_DEVMON_SELECTIVE_MASK: u32 = 240u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CDEF_MERIT_ABOVE_DO_NOT_USE: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const CHARS_IN_GUID: u32 = 39u32;
pub const CLSID_AMAudioData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4064707968, 44938, 4560, [130, 18, 0, 192, 79, 195, 44, 69]);
pub const CLSID_AMAudioStream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2224480320, 44876, 4560, [130, 18, 0, 192, 79, 195, 44, 69]);
pub const CLSID_AMDirectDrawStream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1237613796, 39844, 4560, [130, 18, 0, 192, 79, 195, 44, 69]);
pub const CLSID_AMMediaTypeStream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3473878908, 63423, 4560, [144, 13, 0, 192, 79, 217, 24, 157]);
pub const CLSID_AMMultiMediaStream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1237613797, 39844, 4560, [130, 18, 0, 192, 79, 195, 44, 69]);
pub const CLSID_CPCAFiltersCategory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229820, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_DMOFilterCategory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3168106860, 48466, 19760, [171, 118, 112, 249, 117, 184, 145, 153]);
pub const CLSID_DMOWrapperFilter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2485743683, 48514, 19965, [176, 222, 129, 119, 115, 156, 109, 32]);
pub const CLSID_DTFilterEncProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229698, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_DTFilterTagProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229714, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_ETFilterEncProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229697, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_ETFilterTagProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229713, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_Mpeg2TableFilter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1965573617, 30095, 19587, [160, 67, 66, 112, 197, 147, 48, 142]);
pub const CLSID_PBDA_AUX_DATA_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4249183091, 13091, 16528, [173, 202, 142, 212, 95, 85, 207, 16]);
pub const CLSID_PBDA_Encoder_DATA_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1922029244, 21830, 18198, [177, 3, 248, 153, 245, 161, 250, 104]);
pub const CLSID_PBDA_FDC_DATA_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3889953184, 8875, 16455, [142, 103, 239, 154, 213, 4, 231, 41]);
pub const CLSID_PBDA_GDDS_DATA_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3356233203, 24658, 19478, [159, 86, 196, 76, 33, 247, 60, 69]);
pub const CLSID_PTFilter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2631079447, 45827, 20374, [131, 48, 46, 177, 115, 234, 77, 198]);
pub const CLSID_Proxy: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(399288091, 60631, 4560, [185, 8, 0, 160, 201, 34, 49, 150]);
pub const CLSID_XDSCodecProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229699, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_XDSCodecTagProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229715, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const CLSID_XMLGraphBuilder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(464542049, 24511, 4562, [165, 33, 68, 223, 7, 193, 0, 0]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct COLORKEY {
    pub KeyType: u32,
    pub PaletteIndex: u32,
    pub LowColorValue: u32,
    pub HighColorValue: u32,
}
impl COLORKEY {}
impl ::std::default::Default for COLORKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for COLORKEY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COLORKEY").field("KeyType", &self.KeyType).field("PaletteIndex", &self.PaletteIndex).field("LowColorValue", &self.LowColorValue).field("HighColorValue", &self.HighColorValue).finish()
    }
}
impl ::std::cmp::PartialEq for COLORKEY {
    fn eq(&self, other: &Self) -> bool {
        self.KeyType == other.KeyType && self.PaletteIndex == other.PaletteIndex && self.LowColorValue == other.LowColorValue && self.HighColorValue == other.HighColorValue
    }
}
impl ::std::cmp::Eq for COLORKEY {}
unsafe impl ::windows::runtime::Abi for COLORKEY {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COLORKEY_TYPE(pub i32);
pub const CK_NOCOLORKEY: COLORKEY_TYPE = COLORKEY_TYPE(0i32);
pub const CK_INDEX: COLORKEY_TYPE = COLORKEY_TYPE(1i32);
pub const CK_RGB: COLORKEY_TYPE = COLORKEY_TYPE(2i32);
impl ::std::convert::From<i32> for COLORKEY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COLORKEY_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COMPLETION_STATUS_FLAGS(pub i32);
pub const COMPSTAT_NOUPDATEOK: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(1i32);
pub const COMPSTAT_WAIT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(2i32);
pub const COMPSTAT_ABORT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(4i32);
impl ::std::convert::From<i32> for COMPLETION_STATUS_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COMPLETION_STATUS_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COMPONENT_TAG_CAPTION_MAX: u32 = 55u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COMPONENT_TAG_CAPTION_MIN: u32 = 48u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COMPONENT_TAG_SUPERIMPOSE_MAX: u32 = 63u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COMPONENT_TAG_SUPERIMPOSE_MIN: u32 = 56u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPPEventBlockReason(pub i32);
pub const COPP_Unknown: COPPEventBlockReason = COPPEventBlockReason(-1i32);
pub const COPP_BadDriver: COPPEventBlockReason = COPPEventBlockReason(0i32);
pub const COPP_NoCardHDCPSupport: COPPEventBlockReason = COPPEventBlockReason(1i32);
pub const COPP_NoMonitorHDCPSupport: COPPEventBlockReason = COPPEventBlockReason(2i32);
pub const COPP_BadCertificate: COPPEventBlockReason = COPPEventBlockReason(3i32);
pub const COPP_InvalidBusProtection: COPPEventBlockReason = COPPEventBlockReason(4i32);
pub const COPP_AeroGlassOff: COPPEventBlockReason = COPPEventBlockReason(5i32);
pub const COPP_RogueApp: COPPEventBlockReason = COPPEventBlockReason(6i32);
pub const COPP_ForbiddenVideo: COPPEventBlockReason = COPPEventBlockReason(7i32);
pub const COPP_Activate: COPPEventBlockReason = COPPEventBlockReason(8i32);
pub const COPP_DigitalAudioUnprotected: COPPEventBlockReason = COPPEventBlockReason(9i32);
impl ::std::convert::From<i32> for COPPEventBlockReason {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPPEventBlockReason {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_ACP_Protection_Level(pub i32);
pub const COPP_ACP_Level0: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
pub const COPP_ACP_LevelMin: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
pub const COPP_ACP_Level1: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(1i32);
pub const COPP_ACP_Level2: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2i32);
pub const COPP_ACP_Level3: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_LevelMax: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_ForceDWORD: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2147483647i32);
impl ::std::convert::From<i32> for COPP_ACP_Protection_Level {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_ACP_Protection_Level {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_BusType(pub i32);
pub const COPP_BusType_Unknown: COPP_BusType = COPP_BusType(0i32);
pub const COPP_BusType_PCI: COPP_BusType = COPP_BusType(1i32);
pub const COPP_BusType_PCIX: COPP_BusType = COPP_BusType(2i32);
pub const COPP_BusType_PCIExpress: COPP_BusType = COPP_BusType(3i32);
pub const COPP_BusType_AGP: COPP_BusType = COPP_BusType(4i32);
pub const COPP_BusType_Integrated: COPP_BusType = COPP_BusType(-2147483648i32);
pub const COPP_BusType_ForceDWORD: COPP_BusType = COPP_BusType(2147483647i32);
impl ::std::convert::From<i32> for COPP_BusType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_BusType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_CGMSA_Protection_Level(pub i32);
pub const COPP_CGMSA_Disabled: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
pub const COPP_CGMSA_LevelMin: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
pub const COPP_CGMSA_CopyFreely: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(1i32);
pub const COPP_CGMSA_CopyNoMore: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2i32);
pub const COPP_CGMSA_CopyOneGeneration: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(3i32);
pub const COPP_CGMSA_CopyNever: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(4i32);
pub const COPP_CGMSA_RedistributionControlRequired: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(8i32);
pub const COPP_CGMSA_LevelMax: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(12i32);
pub const COPP_CGMSA_ForceDWORD: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2147483647i32);
impl ::std::convert::From<i32> for COPP_CGMSA_Protection_Level {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_CGMSA_Protection_Level {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_ConnectorType(pub i32);
pub const COPP_ConnectorType_Unknown: COPP_ConnectorType = COPP_ConnectorType(-1i32);
pub const COPP_ConnectorType_VGA: COPP_ConnectorType = COPP_ConnectorType(0i32);
pub const COPP_ConnectorType_SVideo: COPP_ConnectorType = COPP_ConnectorType(1i32);
pub const COPP_ConnectorType_CompositeVideo: COPP_ConnectorType = COPP_ConnectorType(2i32);
pub const COPP_ConnectorType_ComponentVideo: COPP_ConnectorType = COPP_ConnectorType(3i32);
pub const COPP_ConnectorType_DVI: COPP_ConnectorType = COPP_ConnectorType(4i32);
pub const COPP_ConnectorType_HDMI: COPP_ConnectorType = COPP_ConnectorType(5i32);
pub const COPP_ConnectorType_LVDS: COPP_ConnectorType = COPP_ConnectorType(6i32);
pub const COPP_ConnectorType_TMDS: COPP_ConnectorType = COPP_ConnectorType(7i32);
pub const COPP_ConnectorType_D_JPN: COPP_ConnectorType = COPP_ConnectorType(8i32);
pub const COPP_ConnectorType_Internal: COPP_ConnectorType = COPP_ConnectorType(-2147483648i32);
pub const COPP_ConnectorType_ForceDWORD: COPP_ConnectorType = COPP_ConnectorType(2147483647i32);
impl ::std::convert::From<i32> for COPP_ConnectorType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_ConnectorType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COPP_DefaultProtectionLevel: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_HDCP_Protection_Level(pub i32);
pub const COPP_HDCP_Level0: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
pub const COPP_HDCP_LevelMin: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
pub const COPP_HDCP_Level1: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_LevelMax: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_ForceDWORD: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(2147483647i32);
impl ::std::convert::From<i32> for COPP_HDCP_Protection_Level {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_HDCP_Protection_Level {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_ImageAspectRatio_EN300294(pub i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(0i32);
pub const COPP_AspectRatio_EN300294_Box14by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(1i32);
pub const COPP_AspectRatio_EN300294_Box14by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2i32);
pub const COPP_AspectRatio_EN300294_Box16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(3i32);
pub const COPP_AspectRatio_EN300294_Box16by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(4i32);
pub const COPP_AspectRatio_EN300294_BoxGT16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(5i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(6i32);
pub const COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(7i32);
pub const COPP_AspectRatio_ForceDWORD: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2147483647i32);
impl ::std::convert::From<i32> for COPP_ImageAspectRatio_EN300294 {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_ImageAspectRatio_EN300294 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COPP_ImageAspectRatio_EN300294_Mask: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const COPP_NoProtectionLevelAvailable: i32 = -1i32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_StatusFlags(pub i32);
pub const COPP_StatusNormal: COPP_StatusFlags = COPP_StatusFlags(0i32);
pub const COPP_LinkLost: COPP_StatusFlags = COPP_StatusFlags(1i32);
pub const COPP_RenegotiationRequired: COPP_StatusFlags = COPP_StatusFlags(2i32);
pub const COPP_StatusFlagsReserved: COPP_StatusFlags = COPP_StatusFlags(-4i32);
impl ::std::convert::From<i32> for COPP_StatusFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_StatusFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_StatusHDCPFlags(pub i32);
pub const COPP_HDCPRepeater: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(1i32);
pub const COPP_HDCPFlagsReserved: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(-2i32);
impl ::std::convert::From<i32> for COPP_StatusHDCPFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_StatusHDCPFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COPP_TVProtectionStandard(pub i32);
pub const COPP_ProtectionStandard_Unknown: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147483648i32);
pub const COPP_ProtectionStandard_None: COPP_TVProtectionStandard = COPP_TVProtectionStandard(0i32);
pub const COPP_ProtectionStandard_IEC61880_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1i32);
pub const COPP_ProtectionStandard_IEC61880_2_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2i32);
pub const COPP_ProtectionStandard_IEC62375_625p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4i32);
pub const COPP_ProtectionStandard_EIA608B_525: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8i32);
pub const COPP_ProtectionStandard_EN300294_625i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(32i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(64i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(128i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(256i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(512i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1024i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2048i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4096i32);
pub const COPP_ProtectionStandard_ARIBTRB15_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8192i32);
pub const COPP_ProtectionStandard_ARIBTRB15_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16384i32);
pub const COPP_ProtectionStandard_Mask: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147450881i32);
pub const COPP_ProtectionStandard_Reserved: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2147450880i32);
impl ::std::convert::From<i32> for COPP_TVProtectionStandard {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COPP_TVProtectionStandard {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CPEventBitShift(pub i32);
pub const CPEVENT_BITSHIFT_RATINGS: CPEventBitShift = CPEventBitShift(0i32);
pub const CPEVENT_BITSHIFT_COPP: CPEventBitShift = CPEventBitShift(1i32);
pub const CPEVENT_BITSHIFT_LICENSE: CPEventBitShift = CPEventBitShift(2i32);
pub const CPEVENT_BITSHIFT_ROLLBACK: CPEventBitShift = CPEventBitShift(3i32);
pub const CPEVENT_BITSHIFT_SAC: CPEventBitShift = CPEventBitShift(4i32);
pub const CPEVENT_BITSHIFT_DOWNRES: CPEventBitShift = CPEventBitShift(5i32);
pub const CPEVENT_BITSHIFT_STUBLIB: CPEventBitShift = CPEventBitShift(6i32);
pub const CPEVENT_BITSHIFT_UNTRUSTEDGRAPH: CPEventBitShift = CPEventBitShift(7i32);
pub const CPEVENT_BITSHIFT_PENDING_CERTIFICATE: CPEventBitShift = CPEventBitShift(8i32);
pub const CPEVENT_BITSHIFT_NO_PLAYREADY: CPEventBitShift = CPEventBitShift(9i32);
impl ::std::convert::From<i32> for CPEventBitShift {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CPEventBitShift {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CPEvents(pub i32);
pub const CPEVENT_NONE: CPEvents = CPEvents(0i32);
pub const CPEVENT_RATINGS: CPEvents = CPEvents(1i32);
pub const CPEVENT_COPP: CPEvents = CPEvents(2i32);
pub const CPEVENT_LICENSE: CPEvents = CPEvents(3i32);
pub const CPEVENT_ROLLBACK: CPEvents = CPEvents(4i32);
pub const CPEVENT_SAC: CPEvents = CPEvents(5i32);
pub const CPEVENT_DOWNRES: CPEvents = CPEvents(6i32);
pub const CPEVENT_STUBLIB: CPEvents = CPEvents(7i32);
pub const CPEVENT_UNTRUSTEDGRAPH: CPEvents = CPEvents(8i32);
pub const CPEVENT_PROTECTWINDOWED: CPEvents = CPEvents(9i32);
impl ::std::convert::From<i32> for CPEvents {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CPEvents {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CPRecordingStatus(pub i32);
pub const RECORDING_STOPPED: CPRecordingStatus = CPRecordingStatus(0i32);
pub const RECORDING_STARTED: CPRecordingStatus = CPRecordingStatus(1i32);
impl ::std::convert::From<i32> for CPRecordingStatus {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CPRecordingStatus {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CRID_LOCATION(pub i32);
pub const CRID_LOCATION_IN_DESCRIPTOR: CRID_LOCATION = CRID_LOCATION(0i32);
pub const CRID_LOCATION_IN_CIT: CRID_LOCATION = CRID_LOCATION(1i32);
pub const CRID_LOCATION_DVB_RESERVED1: CRID_LOCATION = CRID_LOCATION(2i32);
pub const CRID_LOCATION_DVB_RESERVED2: CRID_LOCATION = CRID_LOCATION(3i32);
impl ::std::convert::From<i32> for CRID_LOCATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CRID_LOCATION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CROSSBAR_DEFAULT_FLAGS(pub i32);
pub const DEF_MODE_PROFILE: CROSSBAR_DEFAULT_FLAGS = CROSSBAR_DEFAULT_FLAGS(1i32);
pub const DEF_MODE_STREAMS: CROSSBAR_DEFAULT_FLAGS = CROSSBAR_DEFAULT_FLAGS(2i32);
impl ::std::convert::From<i32> for CROSSBAR_DEFAULT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CROSSBAR_DEFAULT_FLAGS {
    type Abi = Self;
}
pub const CXDSData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229812, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CameraControlFlags(pub i32);
pub const CameraControl_Flags_Auto: CameraControlFlags = CameraControlFlags(1i32);
pub const CameraControl_Flags_Manual: CameraControlFlags = CameraControlFlags(2i32);
impl ::std::convert::From<i32> for CameraControlFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CameraControlFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CameraControlProperty(pub i32);
pub const CameraControl_Pan: CameraControlProperty = CameraControlProperty(0i32);
pub const CameraControl_Tilt: CameraControlProperty = CameraControlProperty(1i32);
pub const CameraControl_Roll: CameraControlProperty = CameraControlProperty(2i32);
pub const CameraControl_Zoom: CameraControlProperty = CameraControlProperty(3i32);
pub const CameraControl_Exposure: CameraControlProperty = CameraControlProperty(4i32);
pub const CameraControl_Iris: CameraControlProperty = CameraControlProperty(5i32);
pub const CameraControl_Focus: CameraControlProperty = CameraControlProperty(6i32);
impl ::std::convert::From<i32> for CameraControlProperty {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CameraControlProperty {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelChangeInfo {
    pub state: ChannelChangeSpanningEvent_State,
    pub TimeStamp: u64,
}
impl ChannelChangeInfo {}
impl ::std::default::Default for ChannelChangeInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ChannelChangeInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ChannelChangeInfo").field("state", &self.state).field("TimeStamp", &self.TimeStamp).finish()
    }
}
impl ::std::cmp::PartialEq for ChannelChangeInfo {
    fn eq(&self, other: &Self) -> bool {
        self.state == other.state && self.TimeStamp == other.TimeStamp
    }
}
impl ::std::cmp::Eq for ChannelChangeInfo {}
unsafe impl ::windows::runtime::Abi for ChannelChangeInfo {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ChannelChangeSpanningEvent_State(pub i32);
pub const ChannelChangeSpanningEvent_Start: ChannelChangeSpanningEvent_State = ChannelChangeSpanningEvent_State(0i32);
pub const ChannelChangeSpanningEvent_End: ChannelChangeSpanningEvent_State = ChannelChangeSpanningEvent_State(2i32);
impl ::std::convert::From<i32> for ChannelChangeSpanningEvent_State {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ChannelChangeSpanningEvent_State {
    type Abi = Self;
}
pub const ChannelIDTuneRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(982788263, 12708, 17897, [158, 251, 224, 85, 191, 123, 179, 219]);
pub const ChannelIDTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3431111215, 13157, 17983, [175, 19, 129, 219, 182, 243, 165, 85]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelInfo {
    pub lFrequency: i32,
    pub Anonymous: ChannelInfo_0,
}
impl ChannelInfo {}
impl ::std::default::Default for ChannelInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for ChannelInfo {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for ChannelInfo {}
unsafe impl ::windows::runtime::Abi for ChannelInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub union ChannelInfo_0 {
    pub DVB: ChannelInfo_0_2,
    pub DC: ChannelInfo_0_1,
    pub ATSC: ChannelInfo_0_0,
}
impl ChannelInfo_0 {}
impl ::std::default::Default for ChannelInfo_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for ChannelInfo_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for ChannelInfo_0 {}
unsafe impl ::windows::runtime::Abi for ChannelInfo_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelInfo_0_0 {
    pub lProgNumber: i32,
}
impl ChannelInfo_0_0 {}
impl ::std::default::Default for ChannelInfo_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ChannelInfo_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_ATSC_e__Struct").field("lProgNumber", &self.lProgNumber).finish()
    }
}
impl ::std::cmp::PartialEq for ChannelInfo_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.lProgNumber == other.lProgNumber
    }
}
impl ::std::cmp::Eq for ChannelInfo_0_0 {}
unsafe impl ::windows::runtime::Abi for ChannelInfo_0_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelInfo_0_1 {
    pub lProgNumber: i32,
}
impl ChannelInfo_0_1 {}
impl ::std::default::Default for ChannelInfo_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ChannelInfo_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_DC_e__Struct").field("lProgNumber", &self.lProgNumber).finish()
    }
}
impl ::std::cmp::PartialEq for ChannelInfo_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.lProgNumber == other.lProgNumber
    }
}
impl ::std::cmp::Eq for ChannelInfo_0_1 {}
unsafe impl ::windows::runtime::Abi for ChannelInfo_0_1 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelInfo_0_2 {
    pub lONID: i32,
    pub lTSID: i32,
    pub lSID: i32,
}
impl ChannelInfo_0_2 {}
impl ::std::default::Default for ChannelInfo_0_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ChannelInfo_0_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_DVB_e__Struct").field("lONID", &self.lONID).field("lTSID", &self.lTSID).field("lSID", &self.lSID).finish()
    }
}
impl ::std::cmp::PartialEq for ChannelInfo_0_2 {
    fn eq(&self, other: &Self) -> bool {
        self.lONID == other.lONID && self.lTSID == other.lTSID && self.lSID == other.lSID
    }
}
impl ::std::cmp::Eq for ChannelInfo_0_2 {}
unsafe impl ::windows::runtime::Abi for ChannelInfo_0_2 {
    type Abi = Self;
}
pub const ChannelTuneRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(57259237, 17846, 4563, [182, 80, 0, 192, 79, 121, 73, 142]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ChannelType(pub i32);
pub const ChannelTypeNone: ChannelType = ChannelType(0i32);
pub const ChannelTypeOther: ChannelType = ChannelType(1i32);
pub const ChannelTypeVideo: ChannelType = ChannelType(2i32);
pub const ChannelTypeAudio: ChannelType = ChannelType(4i32);
pub const ChannelTypeText: ChannelType = ChannelType(8i32);
pub const ChannelTypeSubtitles: ChannelType = ChannelType(16i32);
pub const ChannelTypeCaptions: ChannelType = ChannelType(32i32);
pub const ChannelTypeSuperimpose: ChannelType = ChannelType(64i32);
pub const ChannelTypeData: ChannelType = ChannelType(128i32);
impl ::std::convert::From<i32> for ChannelType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ChannelType {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct ChannelTypeInfo {
    pub channelType: ChannelType,
    pub timeStamp: u64,
}
impl ChannelTypeInfo {}
impl ::std::default::Default for ChannelTypeInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ChannelTypeInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ChannelTypeInfo").field("channelType", &self.channelType).field("timeStamp", &self.timeStamp).finish()
    }
}
impl ::std::cmp::PartialEq for ChannelTypeInfo {
    fn eq(&self, other: &Self) -> bool {
        self.channelType == other.channelType && self.timeStamp == other.timeStamp
    }
}
impl ::std::cmp::Eq for ChannelTypeInfo {}
unsafe impl ::windows::runtime::Abi for ChannelTypeInfo {
    type Abi = Self;
}
pub const Component: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1507608488, 4460, 4563, [157, 142, 0, 192, 79, 114, 217, 128]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ComponentCategory(pub i32);
pub const CategoryNotSet: ComponentCategory = ComponentCategory(-1i32);
pub const CategoryOther: ComponentCategory = ComponentCategory(0i32);
pub const CategoryVideo: ComponentCategory = ComponentCategory(1i32);
pub const CategoryAudio: ComponentCategory = ComponentCategory(2i32);
pub const CategoryText: ComponentCategory = ComponentCategory(3i32);
pub const CategorySubtitles: ComponentCategory = ComponentCategory(4i32);
pub const CategoryCaptions: ComponentCategory = ComponentCategory(5i32);
pub const CategorySuperimpose: ComponentCategory = ComponentCategory(6i32);
pub const CategoryData: ComponentCategory = ComponentCategory(7i32);
pub const CATEGORY_COUNT: ComponentCategory = ComponentCategory(8i32);
impl ::std::convert::From<i32> for ComponentCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ComponentCategory {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ComponentStatus(pub i32);
pub const StatusActive: ComponentStatus = ComponentStatus(0i32);
pub const StatusInactive: ComponentStatus = ComponentStatus(1i32);
pub const StatusUnavailable: ComponentStatus = ComponentStatus(2i32);
impl ::std::convert::From<i32> for ComponentStatus {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ComponentStatus {
    type Abi = Self;
}
pub const ComponentType: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2184525216, 792, 4563, [157, 142, 0, 192, 79, 114, 217, 128]);
pub const ComponentTypes: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2711794116, 3642, 4563, [157, 142, 0, 192, 79, 114, 217, 128]);
pub const Components: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2157667937, 38084, 18918, [182, 236, 63, 15, 134, 34, 21, 170]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CompressionCaps(pub i32);
pub const CompressionCaps_CanQuality: CompressionCaps = CompressionCaps(1i32);
pub const CompressionCaps_CanCrunch: CompressionCaps = CompressionCaps(2i32);
pub const CompressionCaps_CanKeyFrame: CompressionCaps = CompressionCaps(4i32);
pub const CompressionCaps_CanBFrame: CompressionCaps = CompressionCaps(8i32);
pub const CompressionCaps_CanWindow: CompressionCaps = CompressionCaps(16i32);
impl ::std::convert::From<i32> for CompressionCaps {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CompressionCaps {
    type Abi = Self;
}
pub const CreatePropBagOnRegKey: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2322025289, 8035, 4563, [182, 76, 0, 192, 79, 121, 73, 142]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DDSFF_FLAGS(pub u32);
pub const DDSFF_PROGRESSIVERENDER: DDSFF_FLAGS = DDSFF_FLAGS(1u32);
impl ::std::convert::From<u32> for DDSFF_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DDSFF_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for DDSFF_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for DDSFF_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for DDSFF_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for DDSFF_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for DDSFF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DECIMATION_USAGE(pub i32);
pub const DECIMATION_LEGACY: DECIMATION_USAGE = DECIMATION_USAGE(0i32);
pub const DECIMATION_USE_DECODER_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(1i32);
pub const DECIMATION_USE_VIDEOPORT_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(2i32);
pub const DECIMATION_USE_OVERLAY_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(3i32);
pub const DECIMATION_DEFAULT: DECIMATION_USAGE = DECIMATION_USAGE(4i32);
impl ::std::convert::From<i32> for DECIMATION_USAGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DECIMATION_USAGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DECODER_CAP_NOTSUPPORTED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DECODER_CAP_SUPPORTED: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DESC_LINKAGE_TYPE(pub i32);
pub const DESC_LINKAGE_RESERVED0: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(0i32);
pub const DESC_LINKAGE_INFORMATION: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(1i32);
pub const DESC_LINKAGE_EPG: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(2i32);
pub const DESC_LINKAGE_CA_REPLACEMENT: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(3i32);
pub const DESC_LINKAGE_COMPLETE_NET_BOUQUET_SI: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(4i32);
pub const DESC_LINKAGE_REPLACEMENT: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(5i32);
pub const DESC_LINKAGE_DATA: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(6i32);
pub const DESC_LINKAGE_RESERVED1: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(7i32);
pub const DESC_LINKAGE_USER: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(8i32);
pub const DESC_LINKAGE_RESERVED2: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(255i32);
impl ::std::convert::From<i32> for DESC_LINKAGE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESC_LINKAGE_TYPE {
    type Abi = Self;
}
pub const DIGITAL_CABLE_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(339224491, 63355, 18829, [129, 202, 90, 0, 122, 236, 40, 191]);
pub const DIRECT_TV_SATELLITE_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2478206901, 37844, 17187, [146, 28, 193, 245, 45, 246, 29, 63]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DISPID_TUNER(pub i32);
pub const DISPID_TUNER_TS_UNIQUENAME: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_TS_FRIENDLYNAME: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_TS_CLSID: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_TS_NETWORKTYPE: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_TS__NETWORKTYPE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_TS_CREATETUNEREQUEST: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_TS_ENUMCATEGORYGUIDS: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_TS_ENUMDEVICEMONIKERS: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_TS_DEFAULTPREFERREDCOMPONENTTYPES: DISPID_TUNER = DISPID_TUNER(9i32);
pub const DISPID_TUNER_TS_FREQMAP: DISPID_TUNER = DISPID_TUNER(10i32);
pub const DISPID_TUNER_TS_DEFLOCATOR: DISPID_TUNER = DISPID_TUNER(11i32);
pub const DISPID_TUNER_TS_CLONE: DISPID_TUNER = DISPID_TUNER(12i32);
pub const DISPID_TUNER_TR_TUNINGSPACE: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_TR_COMPONENTS: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_TR_CLONE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_TR_LOCATOR: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_CT_CATEGORY: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_CT_MEDIAMAJORTYPE: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_CT__MEDIAMAJORTYPE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_CT_MEDIASUBTYPE: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_CT__MEDIASUBTYPE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_CT_MEDIAFORMATTYPE: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_CT__MEDIAFORMATTYPE: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_CT_MEDIATYPE: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_CT_CLONE: DISPID_TUNER = DISPID_TUNER(9i32);
pub const DISPID_TUNER_LCT_LANGID: DISPID_TUNER = DISPID_TUNER(100i32);
pub const DISPID_TUNER_MP2CT_TYPE: DISPID_TUNER = DISPID_TUNER(200i32);
pub const DISPID_TUNER_ATSCCT_FLAGS: DISPID_TUNER = DISPID_TUNER(300i32);
pub const DISPID_TUNER_L_CARRFREQ: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_L_INNERFECMETHOD: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_L_INNERFECRATE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_L_OUTERFECMETHOD: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_L_OUTERFECRATE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_L_MOD: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_L_SYMRATE: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_L_CLONE: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_L_ATSC_PHYS_CHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_L_ATSC_TSID: DISPID_TUNER = DISPID_TUNER(202i32);
pub const DISPID_TUNER_L_ATSC_MP2_PROGNO: DISPID_TUNER = DISPID_TUNER(203i32);
pub const DISPID_TUNER_L_DVBT_BANDWIDTH: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_TUNER_L_DVBT_LPINNERFECMETHOD: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_TUNER_L_DVBT_LPINNERFECRATE: DISPID_TUNER = DISPID_TUNER(303i32);
pub const DISPID_TUNER_L_DVBT_GUARDINTERVAL: DISPID_TUNER = DISPID_TUNER(304i32);
pub const DISPID_TUNER_L_DVBT_HALPHA: DISPID_TUNER = DISPID_TUNER(305i32);
pub const DISPID_TUNER_L_DVBT_TRANSMISSIONMODE: DISPID_TUNER = DISPID_TUNER(306i32);
pub const DISPID_TUNER_L_DVBT_INUSE: DISPID_TUNER = DISPID_TUNER(307i32);
pub const DISPID_TUNER_L_DVBT2_PHYSICALLAYERPIPEID: DISPID_TUNER = DISPID_TUNER(351i32);
pub const DISPID_TUNER_L_DVBS_POLARISATION: DISPID_TUNER = DISPID_TUNER(401i32);
pub const DISPID_TUNER_L_DVBS_WEST: DISPID_TUNER = DISPID_TUNER(402i32);
pub const DISPID_TUNER_L_DVBS_ORBITAL: DISPID_TUNER = DISPID_TUNER(403i32);
pub const DISPID_TUNER_L_DVBS_AZIMUTH: DISPID_TUNER = DISPID_TUNER(404i32);
pub const DISPID_TUNER_L_DVBS_ELEVATION: DISPID_TUNER = DISPID_TUNER(405i32);
pub const DISPID_TUNER_L_DVBS2_DISEQ_LNB_SOURCE: DISPID_TUNER = DISPID_TUNER(406i32);
pub const DISPID_TUNER_TS_DVBS2_LOW_OSC_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(407i32);
pub const DISPID_TUNER_TS_DVBS2_HI_OSC_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(408i32);
pub const DISPID_TUNER_TS_DVBS2_LNB_SWITCH_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(409i32);
pub const DISPID_TUNER_TS_DVBS2_SPECTRAL_INVERSION_OVERRIDE: DISPID_TUNER = DISPID_TUNER(410i32);
pub const DISPID_TUNER_L_DVBS2_ROLLOFF: DISPID_TUNER = DISPID_TUNER(411i32);
pub const DISPID_TUNER_L_DVBS2_PILOT: DISPID_TUNER = DISPID_TUNER(412i32);
pub const DISPID_TUNER_L_ANALOG_STANDARD: DISPID_TUNER = DISPID_TUNER(601i32);
pub const DISPID_TUNER_L_DTV_O_MAJOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(701i32);
pub const DISPID_TUNER_C_TYPE: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_C_STATUS: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_C_LANGID: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_C_DESCRIPTION: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_C_CLONE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_C_MP2_PID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_C_MP2_PCRPID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_C_MP2_PROGNO: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_C_ANALOG_AUDIO: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_TS_DVB_SYSTEMTYPE: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_DVB2_NETWORK_ID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_DVBS_LOW_OSC_FREQ: DISPID_TUNER = DISPID_TUNER(1001i32);
pub const DISPID_TUNER_TS_DVBS_HI_OSC_FREQ: DISPID_TUNER = DISPID_TUNER(1002i32);
pub const DISPID_TUNER_TS_DVBS_LNB_SWITCH_FREQ: DISPID_TUNER = DISPID_TUNER(1003i32);
pub const DISPID_TUNER_TS_DVBS_INPUT_RANGE: DISPID_TUNER = DISPID_TUNER(1004i32);
pub const DISPID_TUNER_TS_DVBS_SPECTRAL_INVERSION: DISPID_TUNER = DISPID_TUNER(1005i32);
pub const DISPID_TUNER_TS_AR_MINFREQUENCY: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_AR_MAXFREQUENCY: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_AR_STEP: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_TS_AR_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_TUNER_TS_AUX_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_ATV_MINCHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_ATV_MAXCHANNEL: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_ATV_INPUTTYPE: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_TS_ATV_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_TUNER_TS_ATSC_MINMINORCHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_TS_ATSC_MAXMINORCHANNEL: DISPID_TUNER = DISPID_TUNER(202i32);
pub const DISPID_TUNER_TS_ATSC_MINPHYSCHANNEL: DISPID_TUNER = DISPID_TUNER(203i32);
pub const DISPID_TUNER_TS_ATSC_MAXPHYSCHANNEL: DISPID_TUNER = DISPID_TUNER(204i32);
pub const DISPID_TUNER_TS_DC_MINMAJORCHANNEL: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_TUNER_TS_DC_MAXMAJORCHANNEL: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_TUNER_TS_DC_MINSOURCEID: DISPID_TUNER = DISPID_TUNER(303i32);
pub const DISPID_TUNER_TS_DC_MAXSOURCEID: DISPID_TUNER = DISPID_TUNER(304i32);
pub const DISPID_CHTUNER_ATVAC_CHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_ATVDC_SYSTEM: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_ATVDC_CONTENT: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_CHTUNER_CIDTR_CHANNELID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_CTR_CHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_ACTR_MINOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_CHTUNER_DCTR_MAJOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_CHTUNER_DCTR_SRCID: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_DVBTUNER_DVBC_ATTRIBUTESVALID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_DVBTUNER_DVBC_PID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_DVBTUNER_DVBC_TAG: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_DVBTUNER_DVBC_COMPONENTTYPE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_DVBTUNER_ONID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_DVBTUNER_TSID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_DVBTUNER_SID: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_MP2TUNER_TSID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_MP2TUNER_PROGNO: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_MP2TUNERFACTORY_CREATETUNEREQUEST: DISPID_TUNER = DISPID_TUNER(1i32);
impl ::std::convert::From<i32> for DISPID_TUNER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DISPID_TUNER {
    type Abi = Self;
}
pub const DMOCATEGORY_ACOUSTIC_ECHO_CANCEL: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3214294400, 50521, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const DMOCATEGORY_AGC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3901528992, 50519, 4560, [138, 43, 0, 160, 201, 37, 90, 193]);
pub const DMOCATEGORY_AUDIO_CAPTURE_EFFECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4133857978, 15881, 18720, [170, 95, 33, 152, 17, 20, 143, 9]);
pub const DMOCATEGORY_AUDIO_DECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1475533707, 59067, 17683, [157, 67, 220, 210, 166, 89, 49, 37]);
pub const DMOCATEGORY_AUDIO_EFFECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4083166015, 1426, 18655, [164, 205, 103, 71, 33, 231, 235, 235]);
pub const DMOCATEGORY_AUDIO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(869902177, 37064, 4560, [189, 67, 0, 160, 201, 17, 206, 134]);
pub const DMOCATEGORY_AUDIO_NOISE_SUPPRESS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3766456383, 25341, 20064, [140, 221, 222, 167, 35, 102, 101, 181]);
pub const DMOCATEGORY_VIDEO_DECODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1248441410, 10430, 18833, [150, 156, 181, 0, 173, 245, 216, 168]);
pub const DMOCATEGORY_VIDEO_EFFECT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3650154004, 30572, 18211, [190, 70, 61, 162, 245, 111, 16, 185]);
pub const DMOCATEGORY_VIDEO_ENCODER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(869902176, 37064, 4560, [189, 67, 0, 160, 201, 17, 206, 134]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[inline]
pub unsafe fn DMOEnum(guidcategory: *const ::windows::runtime::GUID, dwflags: u32, cintypes: u32, pintypes: *const DMO_PARTIAL_MEDIATYPE, couttypes: u32, pouttypes: *const DMO_PARTIAL_MEDIATYPE) -> ::windows::runtime::Result<IEnumDMO> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DMOEnum(guidcategory: *const ::windows::runtime::GUID, dwflags: u32, cintypes: u32, pintypes: *const DMO_PARTIAL_MEDIATYPE, couttypes: u32, pouttypes: *const DMO_PARTIAL_MEDIATYPE, ppenum: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IEnumDMO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        DMOEnum(::std::mem::transmute(guidcategory), ::std::mem::transmute(dwflags), ::std::mem::transmute(cintypes), ::std::mem::transmute(pintypes), ::std::mem::transmute(couttypes), ::std::mem::transmute(pouttypes), &mut result__).from_abi::<IEnumDMO>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DMOGetName(clsiddmo: *const ::windows::runtime::GUID, szname: super::super::Foundation::PWSTR) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DMOGetName(clsiddmo: *const ::windows::runtime::GUID, szname: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT;
        }
        DMOGetName(::std::mem::transmute(clsiddmo), ::std::mem::transmute(szname)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[inline]
pub unsafe fn DMOGetTypes(clsiddmo: *const ::windows::runtime::GUID, ulinputtypesrequested: u32, pulinputtypessupplied: *mut u32, pinputtypes: *mut DMO_PARTIAL_MEDIATYPE, uloutputtypesrequested: u32, puloutputtypessupplied: *mut u32, poutputtypes: *mut DMO_PARTIAL_MEDIATYPE) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DMOGetTypes(clsiddmo: *const ::windows::runtime::GUID, ulinputtypesrequested: u32, pulinputtypessupplied: *mut u32, pinputtypes: *mut DMO_PARTIAL_MEDIATYPE, uloutputtypesrequested: u32, puloutputtypessupplied: *mut u32, poutputtypes: *mut DMO_PARTIAL_MEDIATYPE) -> ::windows::runtime::HRESULT;
        }
        DMOGetTypes(::std::mem::transmute(clsiddmo), ::std::mem::transmute(ulinputtypesrequested), ::std::mem::transmute(pulinputtypessupplied), ::std::mem::transmute(pinputtypes), ::std::mem::transmute(uloutputtypesrequested), ::std::mem::transmute(puloutputtypessupplied), ::std::mem::transmute(poutputtypes)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DMORegister<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(szname: Param0, clsiddmo: *const ::windows::runtime::GUID, guidcategory: *const ::windows::runtime::GUID, dwflags: u32, cintypes: u32, pintypes: *const DMO_PARTIAL_MEDIATYPE, couttypes: u32, pouttypes: *const DMO_PARTIAL_MEDIATYPE) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DMORegister(szname: super::super::Foundation::PWSTR, clsiddmo: *const ::windows::runtime::GUID, guidcategory: *const ::windows::runtime::GUID, dwflags: u32, cintypes: u32, pintypes: *const DMO_PARTIAL_MEDIATYPE, couttypes: u32, pouttypes: *const DMO_PARTIAL_MEDIATYPE) -> ::windows::runtime::HRESULT;
        }
        DMORegister(szname.into_param().abi(), ::std::mem::transmute(clsiddmo), ::std::mem::transmute(guidcategory), ::std::mem::transmute(dwflags), ::std::mem::transmute(cintypes), ::std::mem::transmute(pintypes), ::std::mem::transmute(couttypes), ::std::mem::transmute(pouttypes)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[inline]
pub unsafe fn DMOUnregister(clsiddmo: *const ::windows::runtime::GUID, guidcategory: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DMOUnregister(clsiddmo: *const ::windows::runtime::GUID, guidcategory: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT;
        }
        DMOUnregister(::std::mem::transmute(clsiddmo), ::std::mem::transmute(guidcategory)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DMO_ENUM_FLAGS(pub i32);
pub const DMO_ENUMF_INCLUDE_KEYED: DMO_ENUM_FLAGS = DMO_ENUM_FLAGS(1i32);
impl ::std::convert::From<i32> for DMO_ENUM_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DMO_ENUM_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_INVALIDSTREAMINDEX: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220991i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_INVALIDTYPE: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220990i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_NOTACCEPTING: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220988i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_NO_MORE_ITEMS: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220986i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_TYPE_NOT_ACCEPTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220987i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DMO_E_TYPE_NOT_SET: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220989i32 as _);
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DMO_MEDIA_TYPE {
    pub majortype: ::windows::runtime::GUID,
    pub subtype: ::windows::runtime::GUID,
    pub bFixedSizeSamples: super::super::Foundation::BOOL,
    pub bTemporalCompression: super::super::Foundation::BOOL,
    pub lSampleSize: u32,
    pub formattype: ::windows::runtime::GUID,
    pub pUnk: ::std::option::Option<::windows::runtime::IUnknown>,
    pub cbFormat: u32,
    pub pbFormat: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl DMO_MEDIA_TYPE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DMO_MEDIA_TYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DMO_MEDIA_TYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DMO_MEDIA_TYPE")
            .field("majortype", &self.majortype)
            .field("subtype", &self.subtype)
            .field("bFixedSizeSamples", &self.bFixedSizeSamples)
            .field("bTemporalCompression", &self.bTemporalCompression)
            .field("lSampleSize", &self.lSampleSize)
            .field("formattype", &self.formattype)
            .field("pUnk", &self.pUnk)
            .field("cbFormat", &self.cbFormat)
            .field("pbFormat", &self.pbFormat)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DMO_MEDIA_TYPE {
    fn eq(&self, other: &Self) -> bool {
        self.majortype == other.majortype && self.subtype == other.subtype && self.bFixedSizeSamples == other.bFixedSizeSamples && self.bTemporalCompression == other.bTemporalCompression && self.lSampleSize == other.lSampleSize && self.formattype == other.formattype && self.pUnk == other.pUnk && self.cbFormat == other.cbFormat && self.pbFormat == other.pbFormat
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DMO_MEDIA_TYPE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DMO_MEDIA_TYPE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DMO_OUTPUT_DATA_BUFFER {
    pub pBuffer: ::std::option::Option<IMediaBuffer>,
    pub dwStatus: u32,
    pub rtTimestamp: i64,
    pub rtTimelength: i64,
}
impl DMO_OUTPUT_DATA_BUFFER {}
impl ::std::default::Default for DMO_OUTPUT_DATA_BUFFER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DMO_OUTPUT_DATA_BUFFER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DMO_OUTPUT_DATA_BUFFER").field("pBuffer", &self.pBuffer).field("dwStatus", &self.dwStatus).field("rtTimestamp", &self.rtTimestamp).field("rtTimelength", &self.rtTimelength).finish()
    }
}
impl ::std::cmp::PartialEq for DMO_OUTPUT_DATA_BUFFER {
    fn eq(&self, other: &Self) -> bool {
        self.pBuffer == other.pBuffer && self.dwStatus == other.dwStatus && self.rtTimestamp == other.rtTimestamp && self.rtTimelength == other.rtTimelength
    }
}
impl ::std::cmp::Eq for DMO_OUTPUT_DATA_BUFFER {}
unsafe impl ::windows::runtime::Abi for DMO_OUTPUT_DATA_BUFFER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DMO_PARTIAL_MEDIATYPE {
    pub r#type: ::windows::runtime::GUID,
    pub subtype: ::windows::runtime::GUID,
}
impl DMO_PARTIAL_MEDIATYPE {}
impl ::std::default::Default for DMO_PARTIAL_MEDIATYPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DMO_PARTIAL_MEDIATYPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DMO_PARTIAL_MEDIATYPE").field("r#type", &self.r#type).field("subtype", &self.subtype).finish()
    }
}
impl ::std::cmp::PartialEq for DMO_PARTIAL_MEDIATYPE {
    fn eq(&self, other: &Self) -> bool {
        self.r#type == other.r#type && self.subtype == other.subtype
    }
}
impl ::std::cmp::Eq for DMO_PARTIAL_MEDIATYPE {}
unsafe impl ::windows::runtime::Abi for DMO_PARTIAL_MEDIATYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DMO_REGISTER_FLAGS(pub i32);
pub const DMO_REGISTERF_IS_KEYED: DMO_REGISTER_FLAGS = DMO_REGISTER_FLAGS(1i32);
impl ::std::convert::From<i32> for DMO_REGISTER_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DMO_REGISTER_FLAGS {
    type Abi = Self;
}
pub const DSATTRIB_BadSampleInfo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3833884122, 22584, 17076, [184, 151, 111, 126, 95, 170, 47, 47]);
pub const DSATTRIB_WMDRMProtectionInfo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1081382275, 27549, 20204, [180, 60, 103, 161, 128, 30, 26, 155]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DSHOW_STREAM_DESC {
    pub VersionNo: u32,
    pub StreamId: u32,
    pub Default: super::super::Foundation::BOOL,
    pub Creation: super::super::Foundation::BOOL,
    pub Reserved: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DSHOW_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DSHOW_STREAM_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DSHOW_STREAM_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DSHOW_STREAM_DESC").field("VersionNo", &self.VersionNo).field("StreamId", &self.StreamId).field("Default", &self.Default).field("Creation", &self.Creation).field("Reserved", &self.Reserved).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DSHOW_STREAM_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.VersionNo == other.VersionNo && self.StreamId == other.StreamId && self.Default == other.Default && self.Creation == other.Creation && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DSHOW_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DSHOW_STREAM_DESC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DSMCC_ELEMENT {
    pub pid: u16,
    pub bComponentTag: u8,
    pub dwCarouselId: u32,
    pub dwTransactionId: u32,
    pub pNext: *mut DSMCC_ELEMENT,
}
impl DSMCC_ELEMENT {}
impl ::std::default::Default for DSMCC_ELEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DSMCC_ELEMENT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DSMCC_ELEMENT {}
unsafe impl ::windows::runtime::Abi for DSMCC_ELEMENT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DSMCC_FILTER_OPTIONS {
    pub fSpecifyProtocol: super::super::Foundation::BOOL,
    pub Protocol: u8,
    pub fSpecifyType: super::super::Foundation::BOOL,
    pub Type: u8,
    pub fSpecifyMessageId: super::super::Foundation::BOOL,
    pub MessageId: u16,
    pub fSpecifyTransactionId: super::super::Foundation::BOOL,
    pub fUseTrxIdMessageIdMask: super::super::Foundation::BOOL,
    pub TransactionId: u32,
    pub fSpecifyModuleVersion: super::super::Foundation::BOOL,
    pub ModuleVersion: u8,
    pub fSpecifyBlockNumber: super::super::Foundation::BOOL,
    pub BlockNumber: u16,
    pub fGetModuleCall: super::super::Foundation::BOOL,
    pub NumberOfBlocksInModule: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl DSMCC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DSMCC_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DSMCC_FILTER_OPTIONS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DSMCC_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DSMCC_FILTER_OPTIONS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DSMCC_SECTION {
    pub TableId: u8,
    pub Header: DSMCC_SECTION_0,
    pub TableIdExtension: u16,
    pub Version: DSMCC_SECTION_1,
    pub SectionNumber: u8,
    pub LastSectionNumber: u8,
    pub ProtocolDiscriminator: u8,
    pub DsmccType: u8,
    pub MessageId: u16,
    pub TransactionId: u32,
    pub Reserved: u8,
    pub AdaptationLength: u8,
    pub MessageLength: u16,
    pub RemainingData: [u8; 1],
}
impl DSMCC_SECTION {}
impl ::std::default::Default for DSMCC_SECTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DSMCC_SECTION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DSMCC_SECTION {}
unsafe impl ::windows::runtime::Abi for DSMCC_SECTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub union DSMCC_SECTION_0 {
    pub S: MPEG_HEADER_BITS_MIDL,
    pub W: u16,
}
impl DSMCC_SECTION_0 {}
impl ::std::default::Default for DSMCC_SECTION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DSMCC_SECTION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DSMCC_SECTION_0 {}
unsafe impl ::windows::runtime::Abi for DSMCC_SECTION_0 {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub union DSMCC_SECTION_1 {
    pub S: MPEG_HEADER_VERSION_BITS_MIDL,
    pub B: u8,
}
impl DSMCC_SECTION_1 {}
impl ::std::default::Default for DSMCC_SECTION_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DSMCC_SECTION_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DSMCC_SECTION_1 {}
unsafe impl ::windows::runtime::Abi for DSMCC_SECTION_1 {
    type Abi = Self;
}
pub const DTFilter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229810, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_CardStatus_Error: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_CardStatus_FirmwareDownload: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_CardStatus_Inserted: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_CardStatus_Removed: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_Entitlement_CanDecrypt: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_Entitlement_NotEntitled: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_Entitlement_TechnicalFailure: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_MMIMessage_Close: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DTV_MMIMessage_Open: u32 = 0u32;
pub const DVBCLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3308378621, 38533, 16424, [139, 104, 110, 18, 50, 7, 159, 30]);
pub const DVBSLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(502780198, 16464, 18416, [167, 207, 76, 76, 169, 36, 19, 51]);
pub const DVBSTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3057653491, 51618, 16486, [150, 240, 189, 149, 99, 49, 71, 38]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVBS_SCAN_TABLE_MAX_SIZE: u32 = 400u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVBScramblingControlSpanningEvent {
    pub ulPID: u32,
    pub fScrambled: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl DVBScramblingControlSpanningEvent {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVBScramblingControlSpanningEvent {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVBScramblingControlSpanningEvent {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVBScramblingControlSpanningEvent").field("ulPID", &self.ulPID).field("fScrambled", &self.fScrambled).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVBScramblingControlSpanningEvent {
    fn eq(&self, other: &Self) -> bool {
        self.ulPID == other.ulPID && self.fScrambled == other.fScrambled
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVBScramblingControlSpanningEvent {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVBScramblingControlSpanningEvent {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVBSystemType(pub i32);
pub const DVB_Cable: DVBSystemType = DVBSystemType(0i32);
pub const DVB_Terrestrial: DVBSystemType = DVBSystemType(1i32);
pub const DVB_Satellite: DVBSystemType = DVBSystemType(2i32);
pub const ISDB_Terrestrial: DVBSystemType = DVBSystemType(3i32);
pub const ISDB_Satellite: DVBSystemType = DVBSystemType(4i32);
impl ::std::convert::From<i32> for DVBSystemType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVBSystemType {
    type Abi = Self;
}
pub const DVBTLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2631288577, 48627, 19732, [142, 3, 241, 41, 131, 216, 102, 100]);
pub const DVBTLocator2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4024695298, 17879, 18720, [190, 150, 83, 250, 127, 53, 176, 230]);
pub const DVBTuneRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(366366794, 21652, 18844, [136, 108, 151, 60, 158, 83, 185, 241]);
pub const DVBTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3333507890, 30378, 19078, [167, 172, 92, 121, 170, 245, 141, 167]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_BAT_PID: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_BAT_TID: u32 = 74u32;
pub const DVB_CABLE_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3691778023, 1157, 16998, [185, 63, 104, 251, 248, 14, 216, 52]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_DIT_PID: u32 = 30u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_DIT_TID: u32 = 126u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_EIT_ACTUAL_TID: u32 = 78u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVB_EIT_FILTER_OPTIONS {
    pub fSpecifySegment: super::super::Foundation::BOOL,
    pub bSegment: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl DVB_EIT_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVB_EIT_FILTER_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVB_EIT_FILTER_OPTIONS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVB_EIT_FILTER_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVB_EIT_FILTER_OPTIONS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_EIT_OTHER_TID: u32 = 79u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_EIT_PID: u32 = 18u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_NIT_ACTUAL_TID: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_NIT_OTHER_TID: u32 = 65u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_NIT_PID: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_RST_PID: u32 = 19u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_RST_TID: u32 = 113u32;
pub const DVB_SATELLITE_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4199233370, 17844, 19781, [132, 64, 38, 57, 87, 177, 22, 35]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_SDT_ACTUAL_TID: u32 = 66u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_SDT_OTHER_TID: u32 = 70u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_SDT_PID: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_SIT_PID: u32 = 31u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_SIT_TID: u32 = 127u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVB_STRCONV_MODE(pub i32);
pub const STRCONV_MODE_DVB: DVB_STRCONV_MODE = DVB_STRCONV_MODE(0i32);
pub const STRCONV_MODE_DVB_EMPHASIS: DVB_STRCONV_MODE = DVB_STRCONV_MODE(1i32);
pub const STRCONV_MODE_DVB_WITHOUT_EMPHASIS: DVB_STRCONV_MODE = DVB_STRCONV_MODE(2i32);
pub const STRCONV_MODE_ISDB: DVB_STRCONV_MODE = DVB_STRCONV_MODE(3i32);
impl ::std::convert::From<i32> for DVB_STRCONV_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVB_STRCONV_MODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_PID_16: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_PID_17: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_PID_18: u32 = 18u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_PID_19: u32 = 19u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_PID_20: u32 = 20u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_ST_TID: u32 = 114u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_TDT_PID: u32 = 20u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_TDT_TID: u32 = 112u32;
pub const DVB_TERRESTRIAL_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(560751327, 28031, 20122, [133, 113, 5, 241, 78, 219, 118, 106]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_TOT_PID: u32 = 20u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVB_TOT_TID: u32 = 115u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVDFilterState(pub i32);
pub const dvdState_Undefined: DVDFilterState = DVDFilterState(-2i32);
pub const dvdState_Unitialized: DVDFilterState = DVDFilterState(-1i32);
pub const dvdState_Stopped: DVDFilterState = DVDFilterState(0i32);
pub const dvdState_Paused: DVDFilterState = DVDFilterState(1i32);
pub const dvdState_Running: DVDFilterState = DVDFilterState(2i32);
impl ::std::convert::From<i32> for DVDFilterState {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVDFilterState {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVDMenuIDConstants(pub i32);
pub const dvdMenu_Title: DVDMenuIDConstants = DVDMenuIDConstants(2i32);
pub const dvdMenu_Root: DVDMenuIDConstants = DVDMenuIDConstants(3i32);
pub const dvdMenu_Subpicture: DVDMenuIDConstants = DVDMenuIDConstants(4i32);
pub const dvdMenu_Audio: DVDMenuIDConstants = DVDMenuIDConstants(5i32);
pub const dvdMenu_Angle: DVDMenuIDConstants = DVDMenuIDConstants(6i32);
pub const dvdMenu_Chapter: DVDMenuIDConstants = DVDMenuIDConstants(7i32);
impl ::std::convert::From<i32> for DVDMenuIDConstants {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVDMenuIDConstants {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVDSPExt(pub i32);
pub const dvdSPExt_NotSpecified: DVDSPExt = DVDSPExt(0i32);
pub const dvdSPExt_Caption_Normal: DVDSPExt = DVDSPExt(1i32);
pub const dvdSPExt_Caption_Big: DVDSPExt = DVDSPExt(2i32);
pub const dvdSPExt_Caption_Children: DVDSPExt = DVDSPExt(3i32);
pub const dvdSPExt_CC_Normal: DVDSPExt = DVDSPExt(5i32);
pub const dvdSPExt_CC_Big: DVDSPExt = DVDSPExt(6i32);
pub const dvdSPExt_CC_Children: DVDSPExt = DVDSPExt(7i32);
pub const dvdSPExt_Forced: DVDSPExt = DVDSPExt(9i32);
pub const dvdSPExt_DirectorComments_Normal: DVDSPExt = DVDSPExt(13i32);
pub const dvdSPExt_DirectorComments_Big: DVDSPExt = DVDSPExt(14i32);
pub const dvdSPExt_DirectorComments_Children: DVDSPExt = DVDSPExt(15i32);
impl ::std::convert::From<i32> for DVDSPExt {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVDSPExt {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVDTextStringType(pub i32);
pub const dvdStruct_Volume: DVDTextStringType = DVDTextStringType(1i32);
pub const dvdStruct_Title: DVDTextStringType = DVDTextStringType(2i32);
pub const dvdStruct_ParentalID: DVDTextStringType = DVDTextStringType(3i32);
pub const dvdStruct_PartOfTitle: DVDTextStringType = DVDTextStringType(4i32);
pub const dvdStruct_Cell: DVDTextStringType = DVDTextStringType(5i32);
pub const dvdStream_Audio: DVDTextStringType = DVDTextStringType(16i32);
pub const dvdStream_Subpicture: DVDTextStringType = DVDTextStringType(17i32);
pub const dvdStream_Angle: DVDTextStringType = DVDTextStringType(18i32);
pub const dvdChannel_Audio: DVDTextStringType = DVDTextStringType(32i32);
pub const dvdGeneral_Name: DVDTextStringType = DVDTextStringType(48i32);
pub const dvdGeneral_Comments: DVDTextStringType = DVDTextStringType(49i32);
pub const dvdTitle_Series: DVDTextStringType = DVDTextStringType(56i32);
pub const dvdTitle_Movie: DVDTextStringType = DVDTextStringType(57i32);
pub const dvdTitle_Video: DVDTextStringType = DVDTextStringType(58i32);
pub const dvdTitle_Album: DVDTextStringType = DVDTextStringType(59i32);
pub const dvdTitle_Song: DVDTextStringType = DVDTextStringType(60i32);
pub const dvdTitle_Other: DVDTextStringType = DVDTextStringType(63i32);
pub const dvdTitle_Sub_Series: DVDTextStringType = DVDTextStringType(64i32);
pub const dvdTitle_Sub_Movie: DVDTextStringType = DVDTextStringType(65i32);
pub const dvdTitle_Sub_Video: DVDTextStringType = DVDTextStringType(66i32);
pub const dvdTitle_Sub_Album: DVDTextStringType = DVDTextStringType(67i32);
pub const dvdTitle_Sub_Song: DVDTextStringType = DVDTextStringType(68i32);
pub const dvdTitle_Sub_Other: DVDTextStringType = DVDTextStringType(71i32);
pub const dvdTitle_Orig_Series: DVDTextStringType = DVDTextStringType(72i32);
pub const dvdTitle_Orig_Movie: DVDTextStringType = DVDTextStringType(73i32);
pub const dvdTitle_Orig_Video: DVDTextStringType = DVDTextStringType(74i32);
pub const dvdTitle_Orig_Album: DVDTextStringType = DVDTextStringType(75i32);
pub const dvdTitle_Orig_Song: DVDTextStringType = DVDTextStringType(76i32);
pub const dvdTitle_Orig_Other: DVDTextStringType = DVDTextStringType(79i32);
pub const dvdOther_Scene: DVDTextStringType = DVDTextStringType(80i32);
pub const dvdOther_Cut: DVDTextStringType = DVDTextStringType(81i32);
pub const dvdOther_Take: DVDTextStringType = DVDTextStringType(82i32);
impl ::std::convert::From<i32> for DVDTextStringType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVDTextStringType {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_ATR {
    pub ulCAT: u32,
    pub pbATRI: [u8; 768],
}
impl DVD_ATR {}
impl ::std::default::Default for DVD_ATR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_ATR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_ATR").field("ulCAT", &self.ulCAT).field("pbATRI", &self.pbATRI).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_ATR {
    fn eq(&self, other: &Self) -> bool {
        self.ulCAT == other.ulCAT && self.pbATRI == other.pbATRI
    }
}
impl ::std::cmp::Eq for DVD_ATR {}
unsafe impl ::windows::runtime::Abi for DVD_ATR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_AUDIO_APPMODE(pub i32);
pub const DVD_AudioMode_None: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(0i32);
pub const DVD_AudioMode_Karaoke: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(1i32);
pub const DVD_AudioMode_Surround: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(2i32);
pub const DVD_AudioMode_Other: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(3i32);
impl ::std::convert::From<i32> for DVD_AUDIO_APPMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_AUDIO_APPMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_AUDIO_CAPS_AC3: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_AUDIO_CAPS_DTS: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_AUDIO_CAPS_LPCM: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_AUDIO_CAPS_MPEG2: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_AUDIO_CAPS_SDDS: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_AUDIO_FORMAT(pub i32);
pub const DVD_AudioFormat_AC3: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(0i32);
pub const DVD_AudioFormat_MPEG1: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(1i32);
pub const DVD_AudioFormat_MPEG1_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(2i32);
pub const DVD_AudioFormat_MPEG2: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(3i32);
pub const DVD_AudioFormat_MPEG2_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(4i32);
pub const DVD_AudioFormat_LPCM: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(5i32);
pub const DVD_AudioFormat_DTS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(6i32);
pub const DVD_AudioFormat_SDDS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(7i32);
pub const DVD_AudioFormat_Other: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(8i32);
impl ::std::convert::From<i32> for DVD_AUDIO_FORMAT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_AUDIO_FORMAT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_AUDIO_LANG_EXT(pub i32);
pub const DVD_AUD_EXT_NotSpecified: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(0i32);
pub const DVD_AUD_EXT_Captions: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(1i32);
pub const DVD_AUD_EXT_VisuallyImpaired: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(2i32);
pub const DVD_AUD_EXT_DirectorComments1: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(3i32);
pub const DVD_AUD_EXT_DirectorComments2: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(4i32);
impl ::std::convert::From<i32> for DVD_AUDIO_LANG_EXT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_AUDIO_LANG_EXT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_AudioAttributes {
    pub AppMode: DVD_AUDIO_APPMODE,
    pub AppModeData: u8,
    pub AudioFormat: DVD_AUDIO_FORMAT,
    pub Language: u32,
    pub LanguageExtension: DVD_AUDIO_LANG_EXT,
    pub fHasMultichannelInfo: super::super::Foundation::BOOL,
    pub dwFrequency: u32,
    pub bQuantization: u8,
    pub bNumberOfChannels: u8,
    pub dwReserved: [u32; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_AudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_AudioAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_AudioAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_AudioAttributes")
            .field("AppMode", &self.AppMode)
            .field("AppModeData", &self.AppModeData)
            .field("AudioFormat", &self.AudioFormat)
            .field("Language", &self.Language)
            .field("LanguageExtension", &self.LanguageExtension)
            .field("fHasMultichannelInfo", &self.fHasMultichannelInfo)
            .field("dwFrequency", &self.dwFrequency)
            .field("bQuantization", &self.bQuantization)
            .field("bNumberOfChannels", &self.bNumberOfChannels)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_AudioAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.AppMode == other.AppMode && self.AppModeData == other.AppModeData && self.AudioFormat == other.AudioFormat && self.Language == other.Language && self.LanguageExtension == other.LanguageExtension && self.fHasMultichannelInfo == other.fHasMultichannelInfo && self.dwFrequency == other.dwFrequency && self.bQuantization == other.bQuantization && self.bNumberOfChannels == other.bNumberOfChannels && self.dwReserved == other.dwReserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_AudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_AudioAttributes {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_CMD_FLAGS(pub i32);
pub const DVD_CMD_FLAG_None: DVD_CMD_FLAGS = DVD_CMD_FLAGS(0i32);
pub const DVD_CMD_FLAG_Flush: DVD_CMD_FLAGS = DVD_CMD_FLAGS(1i32);
pub const DVD_CMD_FLAG_SendEvents: DVD_CMD_FLAGS = DVD_CMD_FLAGS(2i32);
pub const DVD_CMD_FLAG_Block: DVD_CMD_FLAGS = DVD_CMD_FLAGS(4i32);
pub const DVD_CMD_FLAG_StartWhenRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(8i32);
pub const DVD_CMD_FLAG_EndAfterRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(16i32);
impl ::std::convert::From<i32> for DVD_CMD_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_CMD_FLAGS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_DECODER_CAPS {
    pub dwSize: u32,
    pub dwAudioCaps: u32,
    pub dFwdMaxRateVideo: f64,
    pub dFwdMaxRateAudio: f64,
    pub dFwdMaxRateSP: f64,
    pub dBwdMaxRateVideo: f64,
    pub dBwdMaxRateAudio: f64,
    pub dBwdMaxRateSP: f64,
    pub dwRes1: u32,
    pub dwRes2: u32,
    pub dwRes3: u32,
    pub dwRes4: u32,
}
impl DVD_DECODER_CAPS {}
impl ::std::default::Default for DVD_DECODER_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_DECODER_CAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_DECODER_CAPS")
            .field("dwSize", &self.dwSize)
            .field("dwAudioCaps", &self.dwAudioCaps)
            .field("dFwdMaxRateVideo", &self.dFwdMaxRateVideo)
            .field("dFwdMaxRateAudio", &self.dFwdMaxRateAudio)
            .field("dFwdMaxRateSP", &self.dFwdMaxRateSP)
            .field("dBwdMaxRateVideo", &self.dBwdMaxRateVideo)
            .field("dBwdMaxRateAudio", &self.dBwdMaxRateAudio)
            .field("dBwdMaxRateSP", &self.dBwdMaxRateSP)
            .field("dwRes1", &self.dwRes1)
            .field("dwRes2", &self.dwRes2)
            .field("dwRes3", &self.dwRes3)
            .field("dwRes4", &self.dwRes4)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DVD_DECODER_CAPS {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize && self.dwAudioCaps == other.dwAudioCaps && self.dFwdMaxRateVideo == other.dFwdMaxRateVideo && self.dFwdMaxRateAudio == other.dFwdMaxRateAudio && self.dFwdMaxRateSP == other.dFwdMaxRateSP && self.dBwdMaxRateVideo == other.dBwdMaxRateVideo && self.dBwdMaxRateAudio == other.dBwdMaxRateAudio && self.dBwdMaxRateSP == other.dBwdMaxRateSP && self.dwRes1 == other.dwRes1 && self.dwRes2 == other.dwRes2 && self.dwRes3 == other.dwRes3 && self.dwRes4 == other.dwRes4
    }
}
impl ::std::cmp::Eq for DVD_DECODER_CAPS {}
unsafe impl ::windows::runtime::Abi for DVD_DECODER_CAPS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_DEFAULT_AUDIO_STREAM: u32 = 15u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_DISC_SIDE(pub i32);
pub const DVD_SIDE_A: DVD_DISC_SIDE = DVD_DISC_SIDE(1i32);
pub const DVD_SIDE_B: DVD_DISC_SIDE = DVD_DISC_SIDE(2i32);
impl ::std::convert::From<i32> for DVD_DISC_SIDE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_DISC_SIDE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_DOMAIN(pub i32);
pub const DVD_DOMAIN_FirstPlay: DVD_DOMAIN = DVD_DOMAIN(1i32);
pub const DVD_DOMAIN_VideoManagerMenu: DVD_DOMAIN = DVD_DOMAIN(2i32);
pub const DVD_DOMAIN_VideoTitleSetMenu: DVD_DOMAIN = DVD_DOMAIN(3i32);
pub const DVD_DOMAIN_Title: DVD_DOMAIN = DVD_DOMAIN(4i32);
pub const DVD_DOMAIN_Stop: DVD_DOMAIN = DVD_DOMAIN(5i32);
impl ::std::convert::From<i32> for DVD_DOMAIN {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_DOMAIN {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_ERROR(pub i32);
pub const DVD_ERROR_Unexpected: DVD_ERROR = DVD_ERROR(1i32);
pub const DVD_ERROR_CopyProtectFail: DVD_ERROR = DVD_ERROR(2i32);
pub const DVD_ERROR_InvalidDVD1_0Disc: DVD_ERROR = DVD_ERROR(3i32);
pub const DVD_ERROR_InvalidDiscRegion: DVD_ERROR = DVD_ERROR(4i32);
pub const DVD_ERROR_LowParentalLevel: DVD_ERROR = DVD_ERROR(5i32);
pub const DVD_ERROR_MacrovisionFail: DVD_ERROR = DVD_ERROR(6i32);
pub const DVD_ERROR_IncompatibleSystemAndDecoderRegions: DVD_ERROR = DVD_ERROR(7i32);
pub const DVD_ERROR_IncompatibleDiscAndDecoderRegions: DVD_ERROR = DVD_ERROR(8i32);
pub const DVD_ERROR_CopyProtectOutputFail: DVD_ERROR = DVD_ERROR(9i32);
pub const DVD_ERROR_CopyProtectOutputNotSupported: DVD_ERROR = DVD_ERROR(10i32);
impl ::std::convert::From<i32> for DVD_ERROR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_ERROR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_FRAMERATE(pub i32);
pub const DVD_FPS_25: DVD_FRAMERATE = DVD_FRAMERATE(1i32);
pub const DVD_FPS_30NonDrop: DVD_FRAMERATE = DVD_FRAMERATE(3i32);
impl ::std::convert::From<i32> for DVD_FRAMERATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_FRAMERATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_HMSF_TIMECODE {
    pub bHours: u8,
    pub bMinutes: u8,
    pub bSeconds: u8,
    pub bFrames: u8,
}
impl DVD_HMSF_TIMECODE {}
impl ::std::default::Default for DVD_HMSF_TIMECODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_HMSF_TIMECODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_HMSF_TIMECODE").field("bHours", &self.bHours).field("bMinutes", &self.bMinutes).field("bSeconds", &self.bSeconds).field("bFrames", &self.bFrames).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_HMSF_TIMECODE {
    fn eq(&self, other: &Self) -> bool {
        self.bHours == other.bHours && self.bMinutes == other.bMinutes && self.bSeconds == other.bSeconds && self.bFrames == other.bFrames
    }
}
impl ::std::cmp::Eq for DVD_HMSF_TIMECODE {}
unsafe impl ::windows::runtime::Abi for DVD_HMSF_TIMECODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_KARAOKE_ASSIGNMENT(pub i32);
pub const DVD_Assignment_reserved0: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(0i32);
pub const DVD_Assignment_reserved1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(1i32);
pub const DVD_Assignment_LR: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(2i32);
pub const DVD_Assignment_LRM: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(3i32);
pub const DVD_Assignment_LR1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(4i32);
pub const DVD_Assignment_LRM1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(5i32);
pub const DVD_Assignment_LR12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(6i32);
pub const DVD_Assignment_LRM12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(7i32);
impl ::std::convert::From<i32> for DVD_KARAOKE_ASSIGNMENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_KARAOKE_ASSIGNMENT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_KARAOKE_CONTENTS(pub i32);
pub const DVD_Karaoke_GuideVocal1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(1i32);
pub const DVD_Karaoke_GuideVocal2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(2i32);
pub const DVD_Karaoke_GuideMelody1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(4i32);
pub const DVD_Karaoke_GuideMelody2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(8i32);
pub const DVD_Karaoke_GuideMelodyA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(16i32);
pub const DVD_Karaoke_GuideMelodyB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(32i32);
pub const DVD_Karaoke_SoundEffectA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(64i32);
pub const DVD_Karaoke_SoundEffectB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(128i32);
impl ::std::convert::From<i32> for DVD_KARAOKE_CONTENTS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_KARAOKE_CONTENTS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_KARAOKE_DOWNMIX(pub i32);
pub const DVD_Mix_0to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1i32);
pub const DVD_Mix_1to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2i32);
pub const DVD_Mix_2to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4i32);
pub const DVD_Mix_3to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8i32);
pub const DVD_Mix_4to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16i32);
pub const DVD_Mix_Lto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(32i32);
pub const DVD_Mix_Rto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(64i32);
pub const DVD_Mix_0to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(256i32);
pub const DVD_Mix_1to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(512i32);
pub const DVD_Mix_2to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1024i32);
pub const DVD_Mix_3to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2048i32);
pub const DVD_Mix_4to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4096i32);
pub const DVD_Mix_Lto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8192i32);
pub const DVD_Mix_Rto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16384i32);
impl ::std::convert::From<i32> for DVD_KARAOKE_DOWNMIX {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_KARAOKE_DOWNMIX {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_KaraokeAttributes {
    pub bVersion: u8,
    pub fMasterOfCeremoniesInGuideVocal1: super::super::Foundation::BOOL,
    pub fDuet: super::super::Foundation::BOOL,
    pub ChannelAssignment: DVD_KARAOKE_ASSIGNMENT,
    pub wChannelContents: [u16; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_KaraokeAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_KaraokeAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_KaraokeAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_KaraokeAttributes").field("bVersion", &self.bVersion).field("fMasterOfCeremoniesInGuideVocal1", &self.fMasterOfCeremoniesInGuideVocal1).field("fDuet", &self.fDuet).field("ChannelAssignment", &self.ChannelAssignment).field("wChannelContents", &self.wChannelContents).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_KaraokeAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.bVersion == other.bVersion && self.fMasterOfCeremoniesInGuideVocal1 == other.fMasterOfCeremoniesInGuideVocal1 && self.fDuet == other.fDuet && self.ChannelAssignment == other.ChannelAssignment && self.wChannelContents == other.wChannelContents
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_KaraokeAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_KaraokeAttributes {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_MENU_ID(pub i32);
pub const DVD_MENU_Title: DVD_MENU_ID = DVD_MENU_ID(2i32);
pub const DVD_MENU_Root: DVD_MENU_ID = DVD_MENU_ID(3i32);
pub const DVD_MENU_Subpicture: DVD_MENU_ID = DVD_MENU_ID(4i32);
pub const DVD_MENU_Audio: DVD_MENU_ID = DVD_MENU_ID(5i32);
pub const DVD_MENU_Angle: DVD_MENU_ID = DVD_MENU_ID(6i32);
pub const DVD_MENU_Chapter: DVD_MENU_ID = DVD_MENU_ID(7i32);
impl ::std::convert::From<i32> for DVD_MENU_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_MENU_ID {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_MUA_Coeff {
    pub log2_alpha: f64,
    pub log2_beta: f64,
}
impl DVD_MUA_Coeff {}
impl ::std::default::Default for DVD_MUA_Coeff {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_MUA_Coeff {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_MUA_Coeff").field("log2_alpha", &self.log2_alpha).field("log2_beta", &self.log2_beta).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_MUA_Coeff {
    fn eq(&self, other: &Self) -> bool {
        self.log2_alpha == other.log2_alpha && self.log2_beta == other.log2_beta
    }
}
impl ::std::cmp::Eq for DVD_MUA_Coeff {}
unsafe impl ::windows::runtime::Abi for DVD_MUA_Coeff {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_MUA_MixingInfo {
    pub fMixTo0: super::super::Foundation::BOOL,
    pub fMixTo1: super::super::Foundation::BOOL,
    pub fMix0InPhase: super::super::Foundation::BOOL,
    pub fMix1InPhase: super::super::Foundation::BOOL,
    pub dwSpeakerPosition: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_MUA_MixingInfo {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_MUA_MixingInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_MUA_MixingInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_MUA_MixingInfo").field("fMixTo0", &self.fMixTo0).field("fMixTo1", &self.fMixTo1).field("fMix0InPhase", &self.fMix0InPhase).field("fMix1InPhase", &self.fMix1InPhase).field("dwSpeakerPosition", &self.dwSpeakerPosition).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_MUA_MixingInfo {
    fn eq(&self, other: &Self) -> bool {
        self.fMixTo0 == other.fMixTo0 && self.fMixTo1 == other.fMixTo1 && self.fMix0InPhase == other.fMix0InPhase && self.fMix1InPhase == other.fMix1InPhase && self.dwSpeakerPosition == other.dwSpeakerPosition
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_MUA_MixingInfo {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_MUA_MixingInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_MenuAttributes {
    pub fCompatibleRegion: [super::super::Foundation::BOOL; 8],
    pub VideoAttributes: DVD_VideoAttributes,
    pub fAudioPresent: super::super::Foundation::BOOL,
    pub AudioAttributes: DVD_AudioAttributes,
    pub fSubpicturePresent: super::super::Foundation::BOOL,
    pub SubpictureAttributes: DVD_SubpictureAttributes,
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_MenuAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_MenuAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_MenuAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_MenuAttributes")
            .field("fCompatibleRegion", &self.fCompatibleRegion)
            .field("VideoAttributes", &self.VideoAttributes)
            .field("fAudioPresent", &self.fAudioPresent)
            .field("AudioAttributes", &self.AudioAttributes)
            .field("fSubpicturePresent", &self.fSubpicturePresent)
            .field("SubpictureAttributes", &self.SubpictureAttributes)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_MenuAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.fCompatibleRegion == other.fCompatibleRegion && self.VideoAttributes == other.VideoAttributes && self.fAudioPresent == other.fAudioPresent && self.AudioAttributes == other.AudioAttributes && self.fSubpicturePresent == other.fSubpicturePresent && self.SubpictureAttributes == other.SubpictureAttributes
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_MenuAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_MenuAttributes {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_MultichannelAudioAttributes {
    pub Info: [DVD_MUA_MixingInfo; 8],
    pub Coeff: [DVD_MUA_Coeff; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_MultichannelAudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_MultichannelAudioAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_MultichannelAudioAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_MultichannelAudioAttributes").field("Info", &self.Info).field("Coeff", &self.Coeff).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_MultichannelAudioAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.Info == other.Info && self.Coeff == other.Coeff
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_MultichannelAudioAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_MultichannelAudioAttributes {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_NavCmdType(pub i32);
pub const DVD_NavCmdType_Pre: DVD_NavCmdType = DVD_NavCmdType(1i32);
pub const DVD_NavCmdType_Post: DVD_NavCmdType = DVD_NavCmdType(2i32);
pub const DVD_NavCmdType_Cell: DVD_NavCmdType = DVD_NavCmdType(3i32);
pub const DVD_NavCmdType_Button: DVD_NavCmdType = DVD_NavCmdType(4i32);
impl ::std::convert::From<i32> for DVD_NavCmdType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_NavCmdType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_OPTION_FLAG(pub i32);
pub const DVD_ResetOnStop: DVD_OPTION_FLAG = DVD_OPTION_FLAG(1i32);
pub const DVD_NotifyParentalLevelChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(2i32);
pub const DVD_HMSF_TimeCodeEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(3i32);
pub const DVD_AudioDuringFFwdRew: DVD_OPTION_FLAG = DVD_OPTION_FLAG(4i32);
pub const DVD_EnableNonblockingAPIs: DVD_OPTION_FLAG = DVD_OPTION_FLAG(5i32);
pub const DVD_CacheSizeInMB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(6i32);
pub const DVD_EnablePortableBookmarks: DVD_OPTION_FLAG = DVD_OPTION_FLAG(7i32);
pub const DVD_EnableExtendedCopyProtectErrors: DVD_OPTION_FLAG = DVD_OPTION_FLAG(8i32);
pub const DVD_NotifyPositionChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(9i32);
pub const DVD_IncreaseOutputControl: DVD_OPTION_FLAG = DVD_OPTION_FLAG(10i32);
pub const DVD_EnableStreaming: DVD_OPTION_FLAG = DVD_OPTION_FLAG(11i32);
pub const DVD_EnableESOutput: DVD_OPTION_FLAG = DVD_OPTION_FLAG(12i32);
pub const DVD_EnableTitleLength: DVD_OPTION_FLAG = DVD_OPTION_FLAG(13i32);
pub const DVD_DisableStillThrottle: DVD_OPTION_FLAG = DVD_OPTION_FLAG(14i32);
pub const DVD_EnableLoggingEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(15i32);
pub const DVD_MaxReadBurstInKB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(16i32);
pub const DVD_ReadBurstPeriodInMS: DVD_OPTION_FLAG = DVD_OPTION_FLAG(17i32);
pub const DVD_RestartDisc: DVD_OPTION_FLAG = DVD_OPTION_FLAG(18i32);
pub const DVD_EnableCC: DVD_OPTION_FLAG = DVD_OPTION_FLAG(19i32);
impl ::std::convert::From<i32> for DVD_OPTION_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_OPTION_FLAG {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_PARENTAL_LEVEL(pub i32);
pub const DVD_PARENTAL_LEVEL_8: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(32768i32);
pub const DVD_PARENTAL_LEVEL_7: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(16384i32);
pub const DVD_PARENTAL_LEVEL_6: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(8192i32);
pub const DVD_PARENTAL_LEVEL_5: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(4096i32);
pub const DVD_PARENTAL_LEVEL_4: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(2048i32);
pub const DVD_PARENTAL_LEVEL_3: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(1024i32);
pub const DVD_PARENTAL_LEVEL_2: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(512i32);
pub const DVD_PARENTAL_LEVEL_1: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(256i32);
impl ::std::convert::From<i32> for DVD_PARENTAL_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_PARENTAL_LEVEL {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_PB_STOPPED(pub i32);
pub const DVD_PB_STOPPED_Other: DVD_PB_STOPPED = DVD_PB_STOPPED(0i32);
pub const DVD_PB_STOPPED_NoBranch: DVD_PB_STOPPED = DVD_PB_STOPPED(1i32);
pub const DVD_PB_STOPPED_NoFirstPlayDomain: DVD_PB_STOPPED = DVD_PB_STOPPED(2i32);
pub const DVD_PB_STOPPED_StopCommand: DVD_PB_STOPPED = DVD_PB_STOPPED(3i32);
pub const DVD_PB_STOPPED_Reset: DVD_PB_STOPPED = DVD_PB_STOPPED(4i32);
pub const DVD_PB_STOPPED_DiscEjected: DVD_PB_STOPPED = DVD_PB_STOPPED(5i32);
pub const DVD_PB_STOPPED_IllegalNavCommand: DVD_PB_STOPPED = DVD_PB_STOPPED(6i32);
pub const DVD_PB_STOPPED_PlayPeriodAutoStop: DVD_PB_STOPPED = DVD_PB_STOPPED(7i32);
pub const DVD_PB_STOPPED_PlayChapterAutoStop: DVD_PB_STOPPED = DVD_PB_STOPPED(8i32);
pub const DVD_PB_STOPPED_ParentalFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(9i32);
pub const DVD_PB_STOPPED_RegionFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(10i32);
pub const DVD_PB_STOPPED_MacrovisionFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(11i32);
pub const DVD_PB_STOPPED_DiscReadError: DVD_PB_STOPPED = DVD_PB_STOPPED(12i32);
pub const DVD_PB_STOPPED_CopyProtectFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(13i32);
pub const DVD_PB_STOPPED_CopyProtectOutputFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(14i32);
pub const DVD_PB_STOPPED_CopyProtectOutputNotSupported: DVD_PB_STOPPED = DVD_PB_STOPPED(15i32);
impl ::std::convert::From<i32> for DVD_PB_STOPPED {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_PB_STOPPED {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_PLAYBACK_LOCATION {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: u32,
}
impl DVD_PLAYBACK_LOCATION {}
impl ::std::default::Default for DVD_PLAYBACK_LOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_PLAYBACK_LOCATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_PLAYBACK_LOCATION").field("TitleNum", &self.TitleNum).field("ChapterNum", &self.ChapterNum).field("TimeCode", &self.TimeCode).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_PLAYBACK_LOCATION {
    fn eq(&self, other: &Self) -> bool {
        self.TitleNum == other.TitleNum && self.ChapterNum == other.ChapterNum && self.TimeCode == other.TimeCode
    }
}
impl ::std::cmp::Eq for DVD_PLAYBACK_LOCATION {}
unsafe impl ::windows::runtime::Abi for DVD_PLAYBACK_LOCATION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_PLAYBACK_LOCATION2 {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: DVD_HMSF_TIMECODE,
    pub TimeCodeFlags: u32,
}
impl DVD_PLAYBACK_LOCATION2 {}
impl ::std::default::Default for DVD_PLAYBACK_LOCATION2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_PLAYBACK_LOCATION2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_PLAYBACK_LOCATION2").field("TitleNum", &self.TitleNum).field("ChapterNum", &self.ChapterNum).field("TimeCode", &self.TimeCode).field("TimeCodeFlags", &self.TimeCodeFlags).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_PLAYBACK_LOCATION2 {
    fn eq(&self, other: &Self) -> bool {
        self.TitleNum == other.TitleNum && self.ChapterNum == other.ChapterNum && self.TimeCode == other.TimeCode && self.TimeCodeFlags == other.TimeCodeFlags
    }
}
impl ::std::cmp::Eq for DVD_PLAYBACK_LOCATION2 {}
unsafe impl ::windows::runtime::Abi for DVD_PLAYBACK_LOCATION2 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_PLAY_DIRECTION(pub i32);
pub const DVD_DIR_FORWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(0i32);
pub const DVD_DIR_BACKWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(1i32);
impl ::std::convert::From<i32> for DVD_PLAY_DIRECTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_PLAY_DIRECTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_PREFERRED_DISPLAY_MODE(pub i32);
pub const DISPLAY_CONTENT_DEFAULT: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(0i32);
pub const DISPLAY_16x9: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(1i32);
pub const DISPLAY_4x3_PANSCAN_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(2i32);
pub const DISPLAY_4x3_LETTERBOX_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(3i32);
impl ::std::convert::From<i32> for DVD_PREFERRED_DISPLAY_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_PREFERRED_DISPLAY_MODE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_REGION {
    pub CopySystem: u8,
    pub RegionData: u8,
    pub SystemRegion: u8,
    pub ResetCount: u8,
}
impl DVD_REGION {}
impl ::std::default::Default for DVD_REGION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_REGION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_REGION").field("CopySystem", &self.CopySystem).field("RegionData", &self.RegionData).field("SystemRegion", &self.SystemRegion).field("ResetCount", &self.ResetCount).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_REGION {
    fn eq(&self, other: &Self) -> bool {
        self.CopySystem == other.CopySystem && self.RegionData == other.RegionData && self.SystemRegion == other.SystemRegion && self.ResetCount == other.ResetCount
    }
}
impl ::std::cmp::Eq for DVD_REGION {}
unsafe impl ::windows::runtime::Abi for DVD_REGION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_RELATIVE_BUTTON(pub i32);
pub const DVD_Relative_Upper: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(1i32);
pub const DVD_Relative_Lower: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(2i32);
pub const DVD_Relative_Left: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(3i32);
pub const DVD_Relative_Right: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(4i32);
impl ::std::convert::From<i32> for DVD_RELATIVE_BUTTON {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_RELATIVE_BUTTON {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_STREAM_DATA_CURRENT: u32 = 2048u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_STREAM_DATA_VMGM: u32 = 1024u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_STREAM_DATA_VTSM: u32 = 1025u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_SUBPICTURE_CODING(pub i32);
pub const DVD_SPCoding_RunLength: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(0i32);
pub const DVD_SPCoding_Extended: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(1i32);
pub const DVD_SPCoding_Other: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(2i32);
impl ::std::convert::From<i32> for DVD_SUBPICTURE_CODING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_SUBPICTURE_CODING {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_SUBPICTURE_LANG_EXT(pub i32);
pub const DVD_SP_EXT_NotSpecified: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(0i32);
pub const DVD_SP_EXT_Caption_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(1i32);
pub const DVD_SP_EXT_Caption_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(2i32);
pub const DVD_SP_EXT_Caption_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(3i32);
pub const DVD_SP_EXT_CC_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(5i32);
pub const DVD_SP_EXT_CC_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(6i32);
pub const DVD_SP_EXT_CC_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(7i32);
pub const DVD_SP_EXT_Forced: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(9i32);
pub const DVD_SP_EXT_DirectorComments_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(13i32);
pub const DVD_SP_EXT_DirectorComments_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(14i32);
pub const DVD_SP_EXT_DirectorComments_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(15i32);
impl ::std::convert::From<i32> for DVD_SUBPICTURE_LANG_EXT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_SUBPICTURE_LANG_EXT {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_SUBPICTURE_TYPE(pub i32);
pub const DVD_SPType_NotSpecified: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(0i32);
pub const DVD_SPType_Language: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(1i32);
pub const DVD_SPType_Other: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(2i32);
impl ::std::convert::From<i32> for DVD_SUBPICTURE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_SUBPICTURE_TYPE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_SubpictureAttributes {
    pub Type: DVD_SUBPICTURE_TYPE,
    pub CodingMode: DVD_SUBPICTURE_CODING,
    pub Language: u32,
    pub LanguageExtension: DVD_SUBPICTURE_LANG_EXT,
}
impl DVD_SubpictureAttributes {}
impl ::std::default::Default for DVD_SubpictureAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_SubpictureAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_SubpictureAttributes").field("Type", &self.Type).field("CodingMode", &self.CodingMode).field("Language", &self.Language).field("LanguageExtension", &self.LanguageExtension).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_SubpictureAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.CodingMode == other.CodingMode && self.Language == other.Language && self.LanguageExtension == other.LanguageExtension
    }
}
impl ::std::cmp::Eq for DVD_SubpictureAttributes {}
unsafe impl ::windows::runtime::Abi for DVD_SubpictureAttributes {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVD_TIMECODE {
    pub _bitfield: u32,
}
impl DVD_TIMECODE {}
impl ::std::default::Default for DVD_TIMECODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVD_TIMECODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_TIMECODE").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for DVD_TIMECODE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for DVD_TIMECODE {}
unsafe impl ::windows::runtime::Abi for DVD_TIMECODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_TIMECODE_FLAGS(pub i32);
pub const DVD_TC_FLAG_25fps: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(1i32);
pub const DVD_TC_FLAG_30fps: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(2i32);
pub const DVD_TC_FLAG_DropFrame: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(4i32);
pub const DVD_TC_FLAG_Interpolated: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(8i32);
impl ::std::convert::From<i32> for DVD_TIMECODE_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_TIMECODE_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_TITLE_APPMODE(pub i32);
pub const DVD_AppMode_Not_Specified: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(0i32);
pub const DVD_AppMode_Karaoke: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(1i32);
pub const DVD_AppMode_Other: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(3i32);
impl ::std::convert::From<i32> for DVD_TITLE_APPMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_TITLE_APPMODE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DVD_TITLE_MENU: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_TextCharSet(pub i32);
pub const DVD_CharSet_Unicode: DVD_TextCharSet = DVD_TextCharSet(0i32);
pub const DVD_CharSet_ISO646: DVD_TextCharSet = DVD_TextCharSet(1i32);
pub const DVD_CharSet_JIS_Roman_Kanji: DVD_TextCharSet = DVD_TextCharSet(2i32);
pub const DVD_CharSet_ISO8859_1: DVD_TextCharSet = DVD_TextCharSet(3i32);
pub const DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana: DVD_TextCharSet = DVD_TextCharSet(4i32);
impl ::std::convert::From<i32> for DVD_TextCharSet {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_TextCharSet {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_TextStringType(pub i32);
pub const DVD_Struct_Volume: DVD_TextStringType = DVD_TextStringType(1i32);
pub const DVD_Struct_Title: DVD_TextStringType = DVD_TextStringType(2i32);
pub const DVD_Struct_ParentalID: DVD_TextStringType = DVD_TextStringType(3i32);
pub const DVD_Struct_PartOfTitle: DVD_TextStringType = DVD_TextStringType(4i32);
pub const DVD_Struct_Cell: DVD_TextStringType = DVD_TextStringType(5i32);
pub const DVD_Stream_Audio: DVD_TextStringType = DVD_TextStringType(16i32);
pub const DVD_Stream_Subpicture: DVD_TextStringType = DVD_TextStringType(17i32);
pub const DVD_Stream_Angle: DVD_TextStringType = DVD_TextStringType(18i32);
pub const DVD_Channel_Audio: DVD_TextStringType = DVD_TextStringType(32i32);
pub const DVD_General_Name: DVD_TextStringType = DVD_TextStringType(48i32);
pub const DVD_General_Comments: DVD_TextStringType = DVD_TextStringType(49i32);
pub const DVD_Title_Series: DVD_TextStringType = DVD_TextStringType(56i32);
pub const DVD_Title_Movie: DVD_TextStringType = DVD_TextStringType(57i32);
pub const DVD_Title_Video: DVD_TextStringType = DVD_TextStringType(58i32);
pub const DVD_Title_Album: DVD_TextStringType = DVD_TextStringType(59i32);
pub const DVD_Title_Song: DVD_TextStringType = DVD_TextStringType(60i32);
pub const DVD_Title_Other: DVD_TextStringType = DVD_TextStringType(63i32);
pub const DVD_Title_Sub_Series: DVD_TextStringType = DVD_TextStringType(64i32);
pub const DVD_Title_Sub_Movie: DVD_TextStringType = DVD_TextStringType(65i32);
pub const DVD_Title_Sub_Video: DVD_TextStringType = DVD_TextStringType(66i32);
pub const DVD_Title_Sub_Album: DVD_TextStringType = DVD_TextStringType(67i32);
pub const DVD_Title_Sub_Song: DVD_TextStringType = DVD_TextStringType(68i32);
pub const DVD_Title_Sub_Other: DVD_TextStringType = DVD_TextStringType(71i32);
pub const DVD_Title_Orig_Series: DVD_TextStringType = DVD_TextStringType(72i32);
pub const DVD_Title_Orig_Movie: DVD_TextStringType = DVD_TextStringType(73i32);
pub const DVD_Title_Orig_Video: DVD_TextStringType = DVD_TextStringType(74i32);
pub const DVD_Title_Orig_Album: DVD_TextStringType = DVD_TextStringType(75i32);
pub const DVD_Title_Orig_Song: DVD_TextStringType = DVD_TextStringType(76i32);
pub const DVD_Title_Orig_Other: DVD_TextStringType = DVD_TextStringType(79i32);
pub const DVD_Other_Scene: DVD_TextStringType = DVD_TextStringType(80i32);
pub const DVD_Other_Cut: DVD_TextStringType = DVD_TextStringType(81i32);
pub const DVD_Other_Take: DVD_TextStringType = DVD_TextStringType(82i32);
impl ::std::convert::From<i32> for DVD_TextStringType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_TextStringType {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_TitleAttributes {
    pub Anonymous: DVD_TitleAttributes_0,
    pub VideoAttributes: DVD_VideoAttributes,
    pub ulNumberOfAudioStreams: u32,
    pub AudioAttributes: [DVD_AudioAttributes; 8],
    pub MultichannelAudioAttributes: [DVD_MultichannelAudioAttributes; 8],
    pub ulNumberOfSubpictureStreams: u32,
    pub SubpictureAttributes: [DVD_SubpictureAttributes; 32],
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_TitleAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_TitleAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_TitleAttributes {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_TitleAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_TitleAttributes {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DVD_TitleAttributes_0 {
    pub AppMode: DVD_TITLE_APPMODE,
    pub TitleLength: DVD_HMSF_TIMECODE,
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_TitleAttributes_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_TitleAttributes_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_TitleAttributes_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_TitleAttributes_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_TitleAttributes_0 {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_VIDEO_COMPRESSION(pub i32);
pub const DVD_VideoCompression_Other: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(0i32);
pub const DVD_VideoCompression_MPEG1: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(1i32);
pub const DVD_VideoCompression_MPEG2: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(2i32);
impl ::std::convert::From<i32> for DVD_VIDEO_COMPRESSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_VIDEO_COMPRESSION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVD_VideoAttributes {
    pub fPanscanPermitted: super::super::Foundation::BOOL,
    pub fLetterboxPermitted: super::super::Foundation::BOOL,
    pub ulAspectX: u32,
    pub ulAspectY: u32,
    pub ulFrameRate: u32,
    pub ulFrameHeight: u32,
    pub Compression: DVD_VIDEO_COMPRESSION,
    pub fLine21Field1InGOP: super::super::Foundation::BOOL,
    pub fLine21Field2InGOP: super::super::Foundation::BOOL,
    pub ulSourceResolutionX: u32,
    pub ulSourceResolutionY: u32,
    pub fIsSourceLetterboxed: super::super::Foundation::BOOL,
    pub fIsFilmMode: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl DVD_VideoAttributes {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVD_VideoAttributes {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVD_VideoAttributes {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVD_VideoAttributes")
            .field("fPanscanPermitted", &self.fPanscanPermitted)
            .field("fLetterboxPermitted", &self.fLetterboxPermitted)
            .field("ulAspectX", &self.ulAspectX)
            .field("ulAspectY", &self.ulAspectY)
            .field("ulFrameRate", &self.ulFrameRate)
            .field("ulFrameHeight", &self.ulFrameHeight)
            .field("Compression", &self.Compression)
            .field("fLine21Field1InGOP", &self.fLine21Field1InGOP)
            .field("fLine21Field2InGOP", &self.fLine21Field2InGOP)
            .field("ulSourceResolutionX", &self.ulSourceResolutionX)
            .field("ulSourceResolutionY", &self.ulSourceResolutionY)
            .field("fIsSourceLetterboxed", &self.fIsSourceLetterboxed)
            .field("fIsFilmMode", &self.fIsFilmMode)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVD_VideoAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.fPanscanPermitted == other.fPanscanPermitted
            && self.fLetterboxPermitted == other.fLetterboxPermitted
            && self.ulAspectX == other.ulAspectX
            && self.ulAspectY == other.ulAspectY
            && self.ulFrameRate == other.ulFrameRate
            && self.ulFrameHeight == other.ulFrameHeight
            && self.Compression == other.Compression
            && self.fLine21Field1InGOP == other.fLine21Field1InGOP
            && self.fLine21Field2InGOP == other.fLine21Field2InGOP
            && self.ulSourceResolutionX == other.ulSourceResolutionX
            && self.ulSourceResolutionY == other.ulSourceResolutionY
            && self.fIsSourceLetterboxed == other.fIsSourceLetterboxed
            && self.fIsFilmMode == other.fIsFilmMode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVD_VideoAttributes {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVD_VideoAttributes {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DVD_WARNING(pub i32);
pub const DVD_WARNING_InvalidDVD1_0Disc: DVD_WARNING = DVD_WARNING(1i32);
pub const DVD_WARNING_FormatNotSupported: DVD_WARNING = DVD_WARNING(2i32);
pub const DVD_WARNING_IllegalNavCommand: DVD_WARNING = DVD_WARNING(3i32);
pub const DVD_WARNING_Open: DVD_WARNING = DVD_WARNING(4i32);
pub const DVD_WARNING_Seek: DVD_WARNING = DVD_WARNING(5i32);
pub const DVD_WARNING_Read: DVD_WARNING = DVD_WARNING(6i32);
impl ::std::convert::From<i32> for DVD_WARNING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DVD_WARNING {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DVINFO {
    pub dwDVAAuxSrc: u32,
    pub dwDVAAuxCtl: u32,
    pub dwDVAAuxSrc1: u32,
    pub dwDVAAuxCtl1: u32,
    pub dwDVVAuxSrc: u32,
    pub dwDVVAuxCtl: u32,
    pub dwDVReserved: [u32; 2],
}
impl DVINFO {}
impl ::std::default::Default for DVINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DVINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVINFO")
            .field("dwDVAAuxSrc", &self.dwDVAAuxSrc)
            .field("dwDVAAuxCtl", &self.dwDVAAuxCtl)
            .field("dwDVAAuxSrc1", &self.dwDVAAuxSrc1)
            .field("dwDVAAuxCtl1", &self.dwDVAAuxCtl1)
            .field("dwDVVAuxSrc", &self.dwDVVAuxSrc)
            .field("dwDVVAuxCtl", &self.dwDVVAuxCtl)
            .field("dwDVReserved", &self.dwDVReserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DVINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwDVAAuxSrc == other.dwDVAAuxSrc && self.dwDVAAuxCtl == other.dwDVAAuxCtl && self.dwDVAAuxSrc1 == other.dwDVAAuxSrc1 && self.dwDVAAuxCtl1 == other.dwDVAAuxCtl1 && self.dwDVVAuxSrc == other.dwDVVAuxSrc && self.dwDVVAuxCtl == other.dwDVVAuxCtl && self.dwDVReserved == other.dwDVReserved
    }
}
impl ::std::cmp::Eq for DVINFO {}
unsafe impl ::windows::runtime::Abi for DVINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DVR_STREAM_DESC {
    pub Version: u32,
    pub StreamId: u32,
    pub Default: super::super::Foundation::BOOL,
    pub Creation: super::super::Foundation::BOOL,
    pub Reserved: u32,
    pub guidSubMediaType: ::windows::runtime::GUID,
    pub guidFormatType: ::windows::runtime::GUID,
    pub MediaType: AM_MEDIA_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl DVR_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DVR_STREAM_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DVR_STREAM_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DVR_STREAM_DESC")
            .field("Version", &self.Version)
            .field("StreamId", &self.StreamId)
            .field("Default", &self.Default)
            .field("Creation", &self.Creation)
            .field("Reserved", &self.Reserved)
            .field("guidSubMediaType", &self.guidSubMediaType)
            .field("guidFormatType", &self.guidFormatType)
            .field("MediaType", &self.MediaType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DVR_STREAM_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.StreamId == other.StreamId && self.Default == other.Default && self.Creation == other.Creation && self.Reserved == other.Reserved && self.guidSubMediaType == other.guidSubMediaType && self.guidFormatType == other.guidFormatType && self.MediaType == other.MediaType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DVR_STREAM_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DVR_STREAM_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DWORD_ALLPARAMS: i32 = -1i32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_Graphics_Direct3D9`, `Win32_Media_MediaFoundation`*"]
pub struct DXVA2SW_CALLBACKS {
    pub Size: u32,
    pub GetVideoProcessorRenderTargetCount: ::std::option::Option<PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETCOUNT>,
    pub GetVideoProcessorRenderTargets: ::std::option::Option<PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETS>,
    pub GetVideoProcessorCaps: ::std::option::Option<PDXVA2SW_GETVIDEOPROCESSORCAPS>,
    pub GetVideoProcessorSubStreamFormatCount: ::std::option::Option<PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATCOUNT>,
    pub GetVideoProcessorSubStreamFormats: ::std::option::Option<PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATS>,
    pub GetProcAmpRange: ::std::option::Option<PDXVA2SW_GETPROCAMPRANGE>,
    pub GetFilterPropertyRange: ::std::option::Option<PDXVA2SW_GETFILTERPROPERTYRANGE>,
    pub CreateVideoProcessDevice: ::std::option::Option<PDXVA2SW_CREATEVIDEOPROCESSDEVICE>,
    pub DestroyVideoProcessDevice: ::std::option::Option<PDXVA2SW_DESTROYVIDEOPROCESSDEVICE>,
    pub VideoProcessBeginFrame: ::std::option::Option<PDXVA2SW_VIDEOPROCESSBEGINFRAME>,
    pub VideoProcessEndFrame: ::std::option::Option<PDXVA2SW_VIDEOPROCESSENDFRAME>,
    pub VideoProcessSetRenderTarget: ::std::option::Option<PDXVA2SW_VIDEOPROCESSSETRENDERTARGET>,
    pub VideoProcessBlt: ::std::option::Option<PDXVA2SW_VIDEOPROCESSBLT>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl DXVA2SW_CALLBACKS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::std::default::Default for DXVA2SW_CALLBACKS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::std::fmt::Debug for DXVA2SW_CALLBACKS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA2SW_CALLBACKS").field("Size", &self.Size).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::PartialEq for DXVA2SW_CALLBACKS {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.GetVideoProcessorRenderTargetCount.map(|f| f as usize) == other.GetVideoProcessorRenderTargetCount.map(|f| f as usize)
            && self.GetVideoProcessorRenderTargets.map(|f| f as usize) == other.GetVideoProcessorRenderTargets.map(|f| f as usize)
            && self.GetVideoProcessorCaps.map(|f| f as usize) == other.GetVideoProcessorCaps.map(|f| f as usize)
            && self.GetVideoProcessorSubStreamFormatCount.map(|f| f as usize) == other.GetVideoProcessorSubStreamFormatCount.map(|f| f as usize)
            && self.GetVideoProcessorSubStreamFormats.map(|f| f as usize) == other.GetVideoProcessorSubStreamFormats.map(|f| f as usize)
            && self.GetProcAmpRange.map(|f| f as usize) == other.GetProcAmpRange.map(|f| f as usize)
            && self.GetFilterPropertyRange.map(|f| f as usize) == other.GetFilterPropertyRange.map(|f| f as usize)
            && self.CreateVideoProcessDevice.map(|f| f as usize) == other.CreateVideoProcessDevice.map(|f| f as usize)
            && self.DestroyVideoProcessDevice.map(|f| f as usize) == other.DestroyVideoProcessDevice.map(|f| f as usize)
            && self.VideoProcessBeginFrame.map(|f| f as usize) == other.VideoProcessBeginFrame.map(|f| f as usize)
            && self.VideoProcessEndFrame.map(|f| f as usize) == other.VideoProcessEndFrame.map(|f| f as usize)
            && self.VideoProcessSetRenderTarget.map(|f| f as usize) == other.VideoProcessSetRenderTarget.map(|f| f as usize)
            && self.VideoProcessBlt.map(|f| f as usize) == other.VideoProcessBlt.map(|f| f as usize)
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::Eq for DXVA2SW_CALLBACKS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::runtime::Abi for DXVA2SW_CALLBACKS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2TraceVideoProcessBltData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub TargetFrameTime: u64,
    pub TargetRect: super::super::Foundation::RECT,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2TraceVideoProcessBltData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2TraceVideoProcessBltData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2TraceVideoProcessBltData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2TraceVideoProcessBltData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2TraceVideoProcessBltData {
    type Abi = Self;
}
pub const DXVA2Trace_Control: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2688052853, 63244, 17996, [169, 206, 51, 196, 78, 9, 22, 35]);
pub const DXVA2Trace_DecodeDevBeginFrame: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2681318646, 17611, 17975, [188, 98, 44, 17, 169, 96, 143, 144]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_DecodeDevBeginFrameData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_DecodeDevBeginFrameData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_DecodeDevBeginFrameData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_DecodeDevBeginFrameData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_DecodeDevBeginFrameData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_DecodeDevBeginFrameData {
    type Abi = Self;
}
pub const DXVA2Trace_DecodeDevCreated: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3034453921, 50610, 17662, [134, 213, 217, 122, 100, 129, 20, 255]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_DecodeDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: ::windows::runtime::GUID,
    pub Width: u32,
    pub Height: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_DecodeDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_DecodeDevCreatedData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_DecodeDevCreatedData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_DecodeDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_DecodeDevCreatedData {
    type Abi = Self;
}
pub const DXVA2Trace_DecodeDevDestroyed: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2235481586, 16736, 16925, [136, 147, 99, 220, 234, 79, 24, 187]);
pub const DXVA2Trace_DecodeDevEndFrame: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2679360307, 18396, 18585, [152, 200, 192, 198, 205, 124, 211, 203]);
pub const DXVA2Trace_DecodeDevExecute: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2232085324, 53658, 17929, [179, 180, 188, 191, 14, 34, 18, 30]);
pub const DXVA2Trace_DecodeDevGetBuffer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1471228155, 29387, 16695, [165, 117, 217, 31, 163, 22, 8, 151]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_DecodeDevGetBufferData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub BufferType: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_DecodeDevGetBufferData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_DecodeDevGetBufferData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_DecodeDevGetBufferData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_DecodeDevGetBufferData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_DecodeDevGetBufferData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_DecodeDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_DecodeDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_DecodeDeviceData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_DecodeDeviceData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_DecodeDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_DecodeDeviceData {
    type Abi = Self;
}
pub const DXVA2Trace_VideoProcessBlt: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1762172096, 29099, 17104, [149, 58, 40, 135, 191, 5, 168, 175]);
pub const DXVA2Trace_VideoProcessDevCreated: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2304051398, 21517, 19591, [152, 248, 141, 203, 242, 218, 187, 42]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_VideoProcessDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: ::windows::runtime::GUID,
    pub RTFourCC: u32,
    pub Width: u32,
    pub Height: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_VideoProcessDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_VideoProcessDevCreatedData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_VideoProcessDevCreatedData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_VideoProcessDevCreatedData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_VideoProcessDevCreatedData {
    type Abi = Self;
}
pub const DXVA2Trace_VideoProcessDevDestroyed: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4185862321, 64329, 17095, [142, 232, 136, 189, 250, 146, 212, 226]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Diagnostics_Etw`*"]
pub struct DXVA2Trace_VideoProcessDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl DXVA2Trace_VideoProcessDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::default::Default for DXVA2Trace_VideoProcessDeviceData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::PartialEq for DXVA2Trace_VideoProcessDeviceData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
impl ::std::cmp::Eq for DXVA2Trace_VideoProcessDeviceData {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Diagnostics_Etw"))]
unsafe impl ::windows::runtime::Abi for DXVA2Trace_VideoProcessDeviceData {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DXVA2_DestinationFlags(pub i32);
pub const DXVA2_DestinationFlag_Background_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(1i32);
pub const DXVA2_DestinationFlag_TargetRect_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(2i32);
pub const DXVA2_DestinationFlag_ColorData_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(4i32);
pub const DXVA2_DestinationFlag_Alpha_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(8i32);
pub const DXVA2_DestinationFlag_RFF: DXVA2_DestinationFlags = DXVA2_DestinationFlags(65536i32);
pub const DXVA2_DestinationFlag_TFF: DXVA2_DestinationFlags = DXVA2_DestinationFlags(131072i32);
pub const DXVA2_DestinationFlag_RFF_TFF_Present: DXVA2_DestinationFlags = DXVA2_DestinationFlags(262144i32);
pub const DXVA2_DestinationFlagMask: DXVA2_DestinationFlags = DXVA2_DestinationFlags(-65521i32);
impl ::std::convert::From<i32> for DXVA2_DestinationFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DXVA2_DestinationFlags {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DXVA2_SampleFlags(pub i32);
pub const DXVA2_SampleFlag_Palette_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(1i32);
pub const DXVA2_SampleFlag_SrcRect_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(2i32);
pub const DXVA2_SampleFlag_DstRect_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(4i32);
pub const DXVA2_SampleFlag_ColorData_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(8i32);
pub const DXVA2_SampleFlag_PlanarAlpha_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(16i32);
pub const DXVA2_SampleFlag_RFF: DXVA2_SampleFlags = DXVA2_SampleFlags(65536i32);
pub const DXVA2_SampleFlag_TFF: DXVA2_SampleFlags = DXVA2_SampleFlags(131072i32);
pub const DXVA2_SampleFlag_RFF_TFF_Present: DXVA2_SampleFlags = DXVA2_SampleFlags(262144i32);
pub const DXVA2_SampleFlagsMask: DXVA2_SampleFlags = DXVA2_SampleFlags(-65505i32);
impl ::std::convert::From<i32> for DXVA2_SampleFlags {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DXVA2_SampleFlags {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_Media_MediaFoundation`*"]
pub struct DXVA2_VIDEOPROCESSBLT {
    pub TargetFrame: i64,
    pub TargetRect: super::super::Foundation::RECT,
    pub ConstrictionSize: super::super::Foundation::SIZE,
    pub StreamingFlags: u32,
    pub BackgroundColor: super::super::Media::MediaFoundation::DXVA2_AYUVSample16,
    pub DestFormat: super::super::Media::MediaFoundation::DXVA2_ExtendedFormat,
    pub DestFlags: u32,
    pub ProcAmpValues: super::super::Media::MediaFoundation::DXVA2_ProcAmpValues,
    pub Alpha: super::super::Media::MediaFoundation::DXVA2_Fixed32,
    pub NoiseFilterLuma: super::super::Media::MediaFoundation::DXVA2_FilterValues,
    pub NoiseFilterChroma: super::super::Media::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterLuma: super::super::Media::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterChroma: super::super::Media::MediaFoundation::DXVA2_FilterValues,
    pub pSrcSurfaces: *mut DXVA2_VIDEOSAMPLE,
    pub NumSrcSurfaces: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl DXVA2_VIDEOPROCESSBLT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::default::Default for DXVA2_VIDEOPROCESSBLT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::PartialEq for DXVA2_VIDEOPROCESSBLT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::Eq for DXVA2_VIDEOPROCESSBLT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::runtime::Abi for DXVA2_VIDEOPROCESSBLT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_Media_MediaFoundation`*"]
pub struct DXVA2_VIDEOSAMPLE {
    pub Start: i64,
    pub End: i64,
    pub SampleFormat: super::super::Media::MediaFoundation::DXVA2_ExtendedFormat,
    pub SampleFlags: u32,
    pub SrcResource: *mut ::std::ffi::c_void,
    pub SrcRect: super::super::Foundation::RECT,
    pub DstRect: super::super::Foundation::RECT,
    pub Pal: [super::super::Media::MediaFoundation::DXVA2_AYUVSample8; 16],
    pub PlanarAlpha: super::super::Media::MediaFoundation::DXVA2_Fixed32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl DXVA2_VIDEOSAMPLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::default::Default for DXVA2_VIDEOSAMPLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::PartialEq for DXVA2_VIDEOSAMPLE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
impl ::std::cmp::Eq for DXVA2_VIDEOSAMPLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
unsafe impl ::windows::runtime::Abi for DXVA2_VIDEOSAMPLE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ALPHA_BLEND_COMBINATION_BUFFER: u32 = 13u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ALPHA_BLEND_COMBINATION_FUNCTION: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ALPHA_BLEND_DATA_LOAD_FUNCTION: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_AYUV_BUFFER: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BIDIRECTIONAL_AVERAGING_H263_TRUNC: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_FORWARD: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_UNSPECIFIED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_MILD: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_SEVERE: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_UNLIKELY: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_BITSTREAM_DATA_BUFFER: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CHROMA_FORMAT_420: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CHROMA_FORMAT_422: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CHROMA_FORMAT_444: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COMPBUFFER_TYPE_THAT_IS_NOT_USED: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_BLEND_TYPE_BACK_HARDWARE: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_DATA_TYPE_AI44: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_DATA_TYPE_AYUV: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_DATA_TYPE_DPXD: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_CONFIG_DATA_TYPE_IA44: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COPPCommandFnCode: u32 = 4u32;
pub const DXVA_COPPDevice: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3527768797, 35225, 17901, [138, 138, 209, 170, 4, 123, 164, 213]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COPPGetCertificateLengthFnCode: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COPPKeyExchangeFnCode: u32 = 2u32;
pub const DXVA_COPPQueryBusData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3337934451, 24948, 16772, [142, 53, 246, 219, 82, 0, 188, 186]);
pub const DXVA_COPPQueryConnectorType: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2177941461, 27390, 18626, [153, 192, 149, 160, 143, 151, 197, 218]);
pub const DXVA_COPPQueryDisplayData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3619625891, 44307, 20366, [175, 152, 13, 203, 60, 162, 4, 204]);
pub const DXVA_COPPQueryGlobalProtectionLevel: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(425140490, 30566, 17706, [185, 154, 210, 122, 237, 84, 240, 58]);
pub const DXVA_COPPQueryHDCPKeyData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(230006132, 43410, 18734, [160, 189, 194, 63, 218, 86, 78, 0]);
pub const DXVA_COPPQueryLocalProtectionLevel: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2986825815, 16090, 19805, [136, 219, 116, 143, 140, 26, 5, 73]);
pub const DXVA_COPPQueryProtectionType: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(955426817, 39532, 18619, [145, 7, 182, 105, 110, 111, 23, 151]);
pub const DXVA_COPPQuerySignaling: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1714005393, 15225, 19699, [146, 74, 17, 232, 231, 129, 22, 113]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COPPQueryStatusFnCode: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_COPPSequenceStartFnCode: u32 = 3u32;
pub const DXVA_COPPSetProtectionLevel: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2612605564, 20149, 18215, [159, 0, 180, 43, 9, 25, 192, 218]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPSetProtectionLevelCmdData {
    pub ProtType: u32,
    pub ProtLevel: u32,
    pub ExtendedInfoChangeMask: u32,
    pub ExtendedInfoData: u32,
}
impl DXVA_COPPSetProtectionLevelCmdData {}
impl ::std::default::Default for DXVA_COPPSetProtectionLevelCmdData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPSetProtectionLevelCmdData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPSetProtectionLevelCmdData").field("ProtType", &self.ProtType).field("ProtLevel", &self.ProtLevel).field("ExtendedInfoChangeMask", &self.ExtendedInfoChangeMask).field("ExtendedInfoData", &self.ExtendedInfoData).finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPSetProtectionLevelCmdData {
    fn eq(&self, other: &Self) -> bool {
        self.ProtType == other.ProtType && self.ProtLevel == other.ProtLevel && self.ExtendedInfoChangeMask == other.ExtendedInfoChangeMask && self.ExtendedInfoData == other.ExtendedInfoData
    }
}
impl ::std::cmp::Eq for DXVA_COPPSetProtectionLevelCmdData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPSetProtectionLevelCmdData {
    type Abi = Self;
}
pub const DXVA_COPPSetSignaling: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(161886629, 54916, 19552, [142, 77, 211, 187, 15, 11, 227, 238]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPSetSignalingCmdData {
    pub ActiveTVProtectionStandard: u32,
    pub AspectRatioChangeMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioChangeMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioChangeMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoChangeMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
    pub Reserved: u32,
}
impl DXVA_COPPSetSignalingCmdData {}
impl ::std::default::Default for DXVA_COPPSetSignalingCmdData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPSetSignalingCmdData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPSetSignalingCmdData")
            .field("ActiveTVProtectionStandard", &self.ActiveTVProtectionStandard)
            .field("AspectRatioChangeMask1", &self.AspectRatioChangeMask1)
            .field("AspectRatioData1", &self.AspectRatioData1)
            .field("AspectRatioChangeMask2", &self.AspectRatioChangeMask2)
            .field("AspectRatioData2", &self.AspectRatioData2)
            .field("AspectRatioChangeMask3", &self.AspectRatioChangeMask3)
            .field("AspectRatioData3", &self.AspectRatioData3)
            .field("ExtendedInfoChangeMask", &self.ExtendedInfoChangeMask)
            .field("ExtendedInfoData", &self.ExtendedInfoData)
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPSetSignalingCmdData {
    fn eq(&self, other: &Self) -> bool {
        self.ActiveTVProtectionStandard == other.ActiveTVProtectionStandard
            && self.AspectRatioChangeMask1 == other.AspectRatioChangeMask1
            && self.AspectRatioData1 == other.AspectRatioData1
            && self.AspectRatioChangeMask2 == other.AspectRatioChangeMask2
            && self.AspectRatioData2 == other.AspectRatioData2
            && self.AspectRatioChangeMask3 == other.AspectRatioChangeMask3
            && self.AspectRatioData3 == other.AspectRatioData3
            && self.ExtendedInfoChangeMask == other.ExtendedInfoChangeMask
            && self.ExtendedInfoData == other.ExtendedInfoData
            && self.Reserved == other.Reserved
    }
}
impl ::std::cmp::Eq for DXVA_COPPSetSignalingCmdData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPSetSignalingCmdData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPStatusData {
    pub rApp: ::windows::runtime::GUID,
    pub dwFlags: u32,
    pub dwData: u32,
    pub ExtendedInfoValidMask: u32,
    pub ExtendedInfoData: u32,
}
impl DXVA_COPPStatusData {}
impl ::std::default::Default for DXVA_COPPStatusData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPStatusData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPStatusData").field("rApp", &self.rApp).field("dwFlags", &self.dwFlags).field("dwData", &self.dwData).field("ExtendedInfoValidMask", &self.ExtendedInfoValidMask).field("ExtendedInfoData", &self.ExtendedInfoData).finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPStatusData {
    fn eq(&self, other: &Self) -> bool {
        self.rApp == other.rApp && self.dwFlags == other.dwFlags && self.dwData == other.dwData && self.ExtendedInfoValidMask == other.ExtendedInfoValidMask && self.ExtendedInfoData == other.ExtendedInfoData
    }
}
impl ::std::cmp::Eq for DXVA_COPPStatusData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPStatusData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPStatusDisplayData {
    pub rApp: ::windows::runtime::GUID,
    pub dwFlags: u32,
    pub DisplayWidth: u32,
    pub DisplayHeight: u32,
    pub Format: u32,
    pub d3dFormat: u32,
    pub FreqNumerator: u32,
    pub FreqDenominator: u32,
}
impl DXVA_COPPStatusDisplayData {}
impl ::std::default::Default for DXVA_COPPStatusDisplayData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPStatusDisplayData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPStatusDisplayData")
            .field("rApp", &self.rApp)
            .field("dwFlags", &self.dwFlags)
            .field("DisplayWidth", &self.DisplayWidth)
            .field("DisplayHeight", &self.DisplayHeight)
            .field("Format", &self.Format)
            .field("d3dFormat", &self.d3dFormat)
            .field("FreqNumerator", &self.FreqNumerator)
            .field("FreqDenominator", &self.FreqDenominator)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPStatusDisplayData {
    fn eq(&self, other: &Self) -> bool {
        self.rApp == other.rApp && self.dwFlags == other.dwFlags && self.DisplayWidth == other.DisplayWidth && self.DisplayHeight == other.DisplayHeight && self.Format == other.Format && self.d3dFormat == other.d3dFormat && self.FreqNumerator == other.FreqNumerator && self.FreqDenominator == other.FreqDenominator
    }
}
impl ::std::cmp::Eq for DXVA_COPPStatusDisplayData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPStatusDisplayData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPStatusHDCPKeyData {
    pub rApp: ::windows::runtime::GUID,
    pub dwFlags: u32,
    pub dwHDCPFlags: u32,
    pub BKey: ::windows::runtime::GUID,
    pub Reserved1: ::windows::runtime::GUID,
    pub Reserved2: ::windows::runtime::GUID,
}
impl DXVA_COPPStatusHDCPKeyData {}
impl ::std::default::Default for DXVA_COPPStatusHDCPKeyData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPStatusHDCPKeyData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPStatusHDCPKeyData").field("rApp", &self.rApp).field("dwFlags", &self.dwFlags).field("dwHDCPFlags", &self.dwHDCPFlags).field("BKey", &self.BKey).field("Reserved1", &self.Reserved1).field("Reserved2", &self.Reserved2).finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPStatusHDCPKeyData {
    fn eq(&self, other: &Self) -> bool {
        self.rApp == other.rApp && self.dwFlags == other.dwFlags && self.dwHDCPFlags == other.dwHDCPFlags && self.BKey == other.BKey && self.Reserved1 == other.Reserved1 && self.Reserved2 == other.Reserved2
    }
}
impl ::std::cmp::Eq for DXVA_COPPStatusHDCPKeyData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPStatusHDCPKeyData {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DXVA_COPPStatusSignalingCmdData {
    pub rApp: ::windows::runtime::GUID,
    pub dwFlags: u32,
    pub AvailableTVProtectionStandards: u32,
    pub ActiveTVProtectionStandard: u32,
    pub TVType: u32,
    pub AspectRatioValidMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioValidMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioValidMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoValidMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
}
impl DXVA_COPPStatusSignalingCmdData {}
impl ::std::default::Default for DXVA_COPPStatusSignalingCmdData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DXVA_COPPStatusSignalingCmdData {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DXVA_COPPStatusSignalingCmdData")
            .field("rApp", &self.rApp)
            .field("dwFlags", &self.dwFlags)
            .field("AvailableTVProtectionStandards", &self.AvailableTVProtectionStandards)
            .field("ActiveTVProtectionStandard", &self.ActiveTVProtectionStandard)
            .field("TVType", &self.TVType)
            .field("AspectRatioValidMask1", &self.AspectRatioValidMask1)
            .field("AspectRatioData1", &self.AspectRatioData1)
            .field("AspectRatioValidMask2", &self.AspectRatioValidMask2)
            .field("AspectRatioData2", &self.AspectRatioData2)
            .field("AspectRatioValidMask3", &self.AspectRatioValidMask3)
            .field("AspectRatioData3", &self.AspectRatioData3)
            .field("ExtendedInfoValidMask", &self.ExtendedInfoValidMask)
            .field("ExtendedInfoData", &self.ExtendedInfoData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DXVA_COPPStatusSignalingCmdData {
    fn eq(&self, other: &Self) -> bool {
        self.rApp == other.rApp
            && self.dwFlags == other.dwFlags
            && self.AvailableTVProtectionStandards == other.AvailableTVProtectionStandards
            && self.ActiveTVProtectionStandard == other.ActiveTVProtectionStandard
            && self.TVType == other.TVType
            && self.AspectRatioValidMask1 == other.AspectRatioValidMask1
            && self.AspectRatioData1 == other.AspectRatioData1
            && self.AspectRatioValidMask2 == other.AspectRatioValidMask2
            && self.AspectRatioData2 == other.AspectRatioData2
            && self.AspectRatioValidMask3 == other.AspectRatioValidMask3
            && self.AspectRatioData3 == other.AspectRatioData3
            && self.ExtendedInfoValidMask == other.ExtendedInfoValidMask
            && self.ExtendedInfoData == other.ExtendedInfoData
    }
}
impl ::std::cmp::Eq for DXVA_COPPStatusSignalingCmdData {}
unsafe impl ::windows::runtime::Abi for DXVA_COPPStatusSignalingCmdData {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DCCMD_SURFACE_BUFFER: u32 = 12u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DEBLOCKING_CONTROL_BUFFER: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DEBLOCKING_FILTER_FUNCTION: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DPXD_SURFACE_BUFFER: u32 = 10u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DeinterlaceBltExFnCode: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DeinterlaceBltFnCode: u32 = 1u32;
pub const DXVA_DeinterlaceBobDevice: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(861578094, 30852, 17316, [156, 145, 127, 135, 250, 243, 227, 126]);
pub const DXVA_DeinterlaceContainerDevice: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(243649427, 12358, 20464, [174, 204, 213, 140, 181, 240, 53, 253]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DeinterlaceQueryAvailableModesFnCode: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_DeinterlaceQueryModeCapsFnCode: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL: u32 = 16776968u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_HOST: u32 = 16776960u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SIGNIF: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_EXECUTE_RETURN_OK: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ExtColorData_ShiftBase: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_FILM_GRAIN_BUFFER: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_FILM_GRAIN_SYNTHESIS_FUNCTION: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_HIGHLIGHT_BUFFER: u32 = 11u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_IA44_SURFACE_BUFFER: u32 = 9u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_MACROBLOCK_CONTROL_BUFFER: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_MOTION_VECTOR_BUFFER: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H261: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2: u32 = 0u32;
pub const DXVA_ModeAV1_VLD_12bit_Profile2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(387084297, 40975, 19681, [153, 78, 191, 64, 129, 246, 243, 240]);
pub const DXVA_ModeAV1_VLD_12bit_Profile2_420: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(763412182, 40108, 18485, [158, 145, 50, 123, 188, 79, 158, 232]);
pub const DXVA_ModeAV1_VLD_Profile0: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3099479243, 53075, 18106, [141, 89, 214, 184, 166, 218, 93, 42]);
pub const DXVA_ModeAV1_VLD_Profile1: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1765211919, 17841, 16739, [156, 193, 100, 110, 246, 148, 97, 8]);
pub const DXVA_ModeAV1_VLD_Profile2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(207563425, 58689, 16521, [187, 123, 152, 17, 10, 25, 215, 200]);
pub const DXVA_ModeH261_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487617, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH261_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487618, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487619, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487620, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_C: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487621, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487622, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_E: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487623, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH263_F: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487624, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487716, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487717, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_C: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487718, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487719, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_E: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487720, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_F: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487721, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeH264_VLD_Multiview_NoFGT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1885052290, 30415, 18902, [183, 230, 172, 136, 114, 219, 1, 60]);
pub const DXVA_ModeH264_VLD_Stereo_NoFGT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4188720315, 49846, 19708, [135, 121, 87, 7, 177, 118, 5, 82]);
pub const DXVA_ModeH264_VLD_Stereo_Progressive_NoFGT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3617319130, 3313, 19585, [184, 42, 105, 164, 226, 54, 244, 61]);
pub const DXVA_ModeH264_VLD_WithFMOASO_NoFGT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3589296121, 13336, 17880, [149, 97, 50, 167, 106, 174, 45, 221]);
pub const DXVA_ModeHEVC_VLD_Main: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1527895323, 12108, 17490, [188, 195, 9, 242, 161, 22, 12, 192]);
pub const DXVA_ModeHEVC_VLD_Main10: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(276492512, 61210, 19737, [171, 168, 103, 161, 99, 7, 61, 19]);
pub const DXVA_ModeMPEG1_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487625, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeMPEG1_VLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1866385177, 14133, 17100, [128, 99, 101, 204, 60, 179, 102, 22]);
pub const DXVA_ModeMPEG2_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487626, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeMPEG2_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487627, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeMPEG2_C: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487628, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeMPEG2_D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487629, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeMPEG2and1_VLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2255052562, 13326, 20228, [159, 211, 146, 83, 221, 50, 116, 96]);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_GMC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2878966619, 16984, 17577, [159, 235, 148, 229, 151, 166, 186, 174]);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_NoGMC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3980495519, 269, 20186, [154, 227, 154, 101, 53, 141, 141, 46]);
pub const DXVA_ModeMPEG4pt2_VLD_Simple: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4023799156, 51688, 16855, [165, 233, 233, 176, 227, 159, 163, 25]);
pub const DXVA_ModeNone: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487616, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVC1_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487776, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVC1_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487777, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVC1_C: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487778, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVC1_D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487779, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVC1_D2010: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487780, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeVP8_VLD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2428017130, 14946, 18181, [136, 179, 141, 240, 75, 39, 68, 231]);
pub const DXVA_ModeVP9_VLD_10bit_Profile2: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2764524015, 28367, 18602, [132, 72, 80, 167, 161, 22, 95, 247]);
pub const DXVA_ModeVP9_VLD_Profile0: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1178011640, 41424, 17797, [135, 109, 131, 170, 109, 96, 184, 158]);
pub const DXVA_ModeWMV8_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487744, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeWMV8_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487745, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeWMV9_A: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487760, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeWMV9_B: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487761, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
pub const DXVA_ModeWMV9_C: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487764, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_NUM_TYPES_COMP_BUFFERS: u32 = 18u32;
pub const DXVA_NoEncrypt: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(461487824, 41159, 4563, [185, 132, 0, 192, 79, 46, 115, 197]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_off: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_on: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_NumMV_OBMC_on__BinPB_off: u32 = 10u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_NumMV_OBMC_on__BinPB_on: u32 = 11u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_DECODE_BUFFER: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_DECODING_FUNCTION: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_RESAMPLE_BUFFER: u32 = 14u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_RESAMPLE_FUNCTION: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_STRUCTURE_BOTTOM_FIELD: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_STRUCTURE_FRAME: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_PICTURE_STRUCTURE_TOP_FIELD: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ProcAmpControlBltFnCode: u32 = 1u32;
pub const DXVA_ProcAmpControlDevice: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2669676819, 12285, 16470, [159, 30, 225, 181, 8, 242, 45, 207]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ProcAmpControlQueryCapsFnCode: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_ProcAmpControlQueryRangeFnCode: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_FALSE_PLUS: u32 = 16777215u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_OK_COPY: u32 = 16777212u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS: u32 = 16777211u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_COPY: u32 = 16777208u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_PLUS: u32 = 16777209u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY: u32 = 16777205u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_PROBE_QUERY: u32 = 16777201u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_READ_BACK_BUFFER: u32 = 15u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESIDUAL_DIFFERENCE_BUFFER: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H261_A: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H261_B: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_A: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_B: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_C: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_D: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_E: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H263_F: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_A: u32 = 100u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_B: u32 = 101u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_C: u32 = 102u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_D: u32 = 103u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_E: u32 = 104u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_F: u32 = 105u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_IDCT_FGT: u32 = 103u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_IDCT_NOFGT: u32 = 102u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_FGT: u32 = 101u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_NOFGT: u32 = 100u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_FGT: u32 = 105u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_MULTIVIEW_NOFGT: u32 = 115u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_NOFGT: u32 = 104u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_NOFGT: u32 = 114u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: u32 = 113u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_H264_VLD_WITHFMOASO_NOFGT: u32 = 112u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG1_A: u32 = 9u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG1_VLD: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_A: u32 = 10u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_B: u32 = 11u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_C: u32 = 12u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG2_D: u32 = 13u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG2and1_VLD: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_GMC: u32 = 178u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_NOGMC: u32 = 177u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_SIMPLE: u32 = 176u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_UNRESTRICTED: u32 = 65535u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_A: u32 = 160u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_B: u32 = 161u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_C: u32 = 162u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_D: u32 = 163u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_D2010: u32 = 164u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_IDCT: u32 = 162u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_MOCOMP: u32 = 161u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_POSTPROC: u32 = 160u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_VC1_VLD: u32 = 163u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV8_A: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV8_B: u32 = 129u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV8_MOCOMP: u32 = 129u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV8_POSTPROC: u32 = 128u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_A: u32 = 144u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_B: u32 = 145u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_C: u32 = 148u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_IDCT: u32 = 148u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_MOCOMP: u32 = 145u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_RESTRICTED_MODE_WMV9_POSTPROC: u32 = 144u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_SCAN_METHOD_ALTERNATE_HORIZONTAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_SCAN_METHOD_ALTERNATE_VERTICAL: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_SCAN_METHOD_ARBITRARY: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_SCAN_METHOD_ZIG_ZAG: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_SLICE_CONTROL_BUFFER: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_STATUS_REPORTING_FUNCTION: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_USUAL_BLOCK_HEIGHT: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const DXVA_USUAL_BLOCK_WIDTH: u32 = 8u32;
pub const DigitalCableLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(62940182, 53543, 16506, [171, 76, 253, 210, 121, 171, 190, 93]);
pub const DigitalCableTuneRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(653003619, 43664, 17802, [141, 244, 86, 89, 242, 200, 161, 138]);
pub const DigitalCableTuningSpace: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3652930798, 47226, 18417, [172, 146, 176, 141, 156, 120, 19, 252]);
pub const DigitalLocator: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1850788877, 49563, 19446, [129, 11, 91, 214, 7, 97, 245, 204]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DisplaySizeList(pub i32);
pub const dslDefaultSize: DisplaySizeList = DisplaySizeList(0i32);
pub const dslSourceSize: DisplaySizeList = DisplaySizeList(0i32);
pub const dslHalfSourceSize: DisplaySizeList = DisplaySizeList(1i32);
pub const dslDoubleSourceSize: DisplaySizeList = DisplaySizeList(2i32);
pub const dslFullScreen: DisplaySizeList = DisplaySizeList(3i32);
pub const dslHalfScreen: DisplaySizeList = DisplaySizeList(4i32);
pub const dslQuarterScreen: DisplaySizeList = DisplaySizeList(5i32);
pub const dslSixteenthScreen: DisplaySizeList = DisplaySizeList(6i32);
impl ::std::convert::From<i32> for DisplaySizeList {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DisplaySizeList {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct DownResEventParam(pub i32);
pub const DOWNRES_Always: DownResEventParam = DownResEventParam(0i32);
pub const DOWNRES_InWindowOnly: DownResEventParam = DownResEventParam(1i32);
pub const DOWNRES_Undefined: DownResEventParam = DownResEventParam(2i32);
impl ::std::convert::From<i32> for DownResEventParam {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DownResEventParam {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct DualMonoInfo {
    pub LangID1: u16,
    pub LangID2: u16,
    pub lISOLangCode1: i32,
    pub lISOLangCode2: i32,
}
impl DualMonoInfo {}
impl ::std::default::Default for DualMonoInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DualMonoInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DualMonoInfo").field("LangID1", &self.LangID1).field("LangID2", &self.LangID2).field("lISOLangCode1", &self.lISOLangCode1).field("lISOLangCode2", &self.lISOLangCode2).finish()
    }
}
impl ::std::cmp::PartialEq for DualMonoInfo {
    fn eq(&self, other: &Self) -> bool {
        self.LangID1 == other.LangID1 && self.LangID2 == other.LangID2 && self.lISOLangCode1 == other.lISOLangCode1 && self.lISOLangCode2 == other.lISOLangCode2
    }
}
impl ::std::cmp::Eq for DualMonoInfo {}
unsafe impl ::windows::runtime::Abi for DualMonoInfo {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DvbParentalRatingDescriptor {
    pub ulNumParams: u32,
    pub pParams: [DvbParentalRatingParam; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl DvbParentalRatingDescriptor {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DvbParentalRatingDescriptor {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DvbParentalRatingDescriptor {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DvbParentalRatingDescriptor").field("ulNumParams", &self.ulNumParams).field("pParams", &self.pParams).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DvbParentalRatingDescriptor {
    fn eq(&self, other: &Self) -> bool {
        self.ulNumParams == other.ulNumParams && self.pParams == other.pParams
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DvbParentalRatingDescriptor {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DvbParentalRatingDescriptor {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
pub struct DvbParentalRatingParam {
    pub szCountryCode: [super::super::Foundation::CHAR; 4],
    pub bRating: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl DvbParentalRatingParam {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DvbParentalRatingParam {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DvbParentalRatingParam {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DvbParentalRatingParam").field("szCountryCode", &self.szCountryCode).field("bRating", &self.bRating).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DvbParentalRatingParam {
    fn eq(&self, other: &Self) -> bool {
        self.szCountryCode == other.szCountryCode && self.bRating == other.bRating
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DvbParentalRatingParam {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DvbParentalRatingParam {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct EALocationCodeType {
    pub LocationCodeScheme: LocationCodeSchemeType,
    pub state_code: u8,
    pub county_subdivision: u8,
    pub county_code: u16,
}
impl EALocationCodeType {}
impl ::std::default::Default for EALocationCodeType {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for EALocationCodeType {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EALocationCodeType").field("LocationCodeScheme", &self.LocationCodeScheme).field("state_code", &self.state_code).field("county_subdivision", &self.county_subdivision).field("county_code", &self.county_code).finish()
    }
}
impl ::std::cmp::PartialEq for EALocationCodeType {
    fn eq(&self, other: &Self) -> bool {
        self.LocationCodeScheme == other.LocationCodeScheme && self.state_code == other.state_code && self.county_subdivision == other.county_subdivision && self.county_code == other.county_code
    }
}
impl ::std::cmp::Eq for EALocationCodeType {}
unsafe impl ::windows::runtime::Abi for EALocationCodeType {
    type Abi = Self;
}
pub const ECHOSTAR_SATELLITE_TV_NETWORK_TYPE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3304502043, 50879, 18265, [136, 111, 167, 56, 109, 202, 39, 160]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_ACTIVATE: u32 = 19u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_BANDWIDTHCHANGE: u32 = 72u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_BUFFERING_DATA: u32 = 17u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_BUILT: u32 = 768u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_CLOCK_CHANGED: u32 = 13u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_CLOCK_UNSET: u32 = 81u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_CODECAPI_EVENT: u32 = 87u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_COMPLETE: u32 = 1u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_CONTENTPROPERTY_CHANGED: u32 = 71u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DEVICE_LOST: u32 = 31u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DISPLAY_CHANGED: u32 = 22u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVDBASE: u32 = 256u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_ANGLES_AVAILABLE: u32 = 275u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_ANGLE_CHANGE: u32 = 262u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_AUDIO_STREAM_CHANGE: u32 = 260u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_BUTTON_AUTO_ACTIVATED: u32 = 277u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_BUTTON_CHANGE: u32 = 263u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_BeginNavigationCommands: u32 = 291u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CHAPTER_AUTOSTOP: u32 = 270u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CHAPTER_START: u32 = 259u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CMD_END: u32 = 279u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CMD_START: u32 = 278u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CURRENT_HMSF_TIME: u32 = 282u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_CURRENT_TIME: u32 = 267u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_DISC_EJECTED: u32 = 280u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_DISC_INSERTED: u32 = 281u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_DOMAIN_CHANGE: u32 = 257u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_ERROR: u32 = 268u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_GPRM_Change: u32 = 289u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_KARAOKE_MODE: u32 = 283u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_NO_FP_PGC: u32 = 271u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_NavigationCommand: u32 = 292u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PARENTAL_LEVEL_CHANGE: u32 = 273u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PLAYBACK_RATE_CHANGE: u32 = 272u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PLAYBACK_STOPPED: u32 = 274u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PLAYPERIOD_AUTOSTOP: u32 = 276u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PROGRAM_CELL_CHANGE: u32 = 284u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_PROGRAM_CHAIN_CHANGE: u32 = 286u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_SPRM_Change: u32 = 290u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_STILL_OFF: u32 = 266u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_STILL_ON: u32 = 265u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_SUBPICTURE_STREAM_CHANGE: u32 = 261u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_TITLE_CHANGE: u32 = 258u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_TITLE_SET_CHANGE: u32 = 285u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_VALID_UOPS_CHANGE: u32 = 264u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_VOBU_Offset: u32 = 287u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_VOBU_Timestamp: u32 = 288u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_DVD_WARNING: u32 = 269u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_END_OF_SEGMENT: u32 = 28u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_EOS_SOON: u32 = 70u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_ERRORABORT: u32 = 3u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_ERRORABORTEX: u32 = 69u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_ERROR_STILLPLAYING: u32 = 8u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_EXTDEVICE_MODE_CHANGE: u32 = 49u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_FILE_CLOSED: u32 = 68u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_FULLSCREEN_LOST: u32 = 18u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_GRAPH_CHANGED: u32 = 80u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_LENGTH_CHANGED: u32 = 30u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_LOADSTATUS: u32 = 67u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_MARKER_HIT: u32 = 66u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_NEED_RESTART: u32 = 20u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_NEW_PIN: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_NOTIFY_WINDOW: u32 = 25u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_OLE_EVENT: u32 = 24u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_OPENING_FILE: u32 = 16u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_PALETTE_CHANGED: u32 = 9u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_PAUSED: u32 = 14u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_PLEASE_REOPEN: u32 = 64u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_PREPROCESS_COMPLETE: u32 = 86u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_PROCESSING_LATENCY: u32 = 33u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_QUALITY_CHANGE: u32 = 11u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_RENDER_FINISHED: u32 = 33u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_REPAINT: u32 = 5u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SAMPLE_LATENCY: u32 = 34u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SAMPLE_NEEDED: u32 = 32u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SCRUB_TIME: u32 = 35u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SEGMENT_STARTED: u32 = 29u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SHUTTING_DOWN: u32 = 12u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SKIP_FRAMES: u32 = 37u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SNDDEV_IN_ERROR: u32 = 512u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SNDDEV_OUT_ERROR: u32 = 513u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SND_DEVICE_ERROR_BASE: u32 = 512u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STARVATION: u32 = 23u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STATE_CHANGE: u32 = 50u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STATUS: u32 = 65u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STEP_COMPLETE: u32 = 36u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STREAM_CONTROL_STARTED: u32 = 27u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STREAM_CONTROL_STOPPED: u32 = 26u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STREAM_ERROR_STILLPLAYING: u32 = 7u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_STREAM_ERROR_STOPPED: u32 = 6u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_SYSTEMBASE: u32 = 0u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_TIME: u32 = 4u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_TIMECODE_AVAILABLE: u32 = 48u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_UNBUILT: u32 = 769u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_USER: u32 = 32768u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_USERABORT: u32 = 2u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_VIDEOFRAMEREADY: u32 = 73u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_VIDEO_SIZE_CHANGED: u32 = 10u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_VMR_RECONNECTION_FAILED: u32 = 85u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_VMR_RENDERDEVICE_SET: u32 = 83u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_VMR_SURFACE_FLIPPED: u32 = 84u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_WINDOW_DESTROYED: u32 = 21u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_WMT_EVENT: u32 = 594u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_WMT_EVENT_BASE: u32 = 593u32;
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const EC_WMT_INDEX_EVENT: u32 = 593u32;
pub const ESEventFactory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2391410650, 29176, 16577, [169, 41, 94, 58, 134, 138, 194, 198]);
pub const ESEventService: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3255060476, 60512, 18270, [129, 63, 210, 176, 166, 222, 206, 254]);
pub const ETFilter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229809, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ARIBcontentSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(982859907, 37840, 17982, [144, 178, 7, 66, 196, 150, 237, 240]);
pub const EVENTID_AudioDescriptorSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(276550684, 42714, 18065, [131, 105, 17, 178, 205, 170, 40, 142]);
pub const EVENTID_AudioTypeSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1344061374, 47177, 17102, [155, 233, 61, 184, 105, 251, 130, 179]);
pub const EVENTID_BDAConditionalAccessTAG: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4022576217, 44683, 19274, [143, 233, 121, 160, 208, 151, 243, 234]);
pub const EVENTID_BDAEventingServicePendingEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1554323217, 24028, 16806, [148, 48, 228, 27, 139, 59, 188, 91]);
pub const EVENTID_BDA_CASBroadcastMMI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1734899440, 4402, 16460, [167, 202, 231, 32, 105, 169, 213, 79]);
pub const EVENTID_BDA_CASCloseMMI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1561285903, 56878, 18333, [131, 69, 236, 14, 149, 87, 232, 162]);
pub const EVENTID_BDA_CASOpenMMI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2245708053, 58771, 16653, [132, 113, 214, 129, 33, 5, 242, 142]);
pub const EVENTID_BDA_CASReleaseTuner: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(549560683, 17439, 18853, [187, 92, 233, 160, 68, 149, 198, 193]);
pub const EVENTID_BDA_CASRequestTuner: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3476662744, 62931, 18053, [190, 87, 237, 129, 219, 164, 107, 39]);
pub const EVENTID_BDA_DiseqCResponseAvailable: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4020644088, 7980, 19303, [158, 165, 172, 246, 250, 154, 31, 54]);
pub const EVENTID_BDA_EncoderSignalLock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1590234809, 14842, 19708, [185, 63, 0, 187, 17, 7, 127, 94]);
pub const EVENTID_BDA_FdcStatus: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(99767142, 53483, 17362, [188, 60, 104, 43, 134, 61, 241, 66]);
pub const EVENTID_BDA_FdcTableSection: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1779226455, 19683, 20059, [148, 68, 113, 135, 184, 113, 82, 197]);
pub const EVENTID_BDA_GPNVValueUpdate: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4285908620, 62486, 20094, [191, 23, 109, 85, 197, 223, 21, 117]);
pub const EVENTID_BDA_GuideDataAvailable: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2564518266, 18314, 19668, [146, 208, 149, 246, 107, 137, 229, 177]);
pub const EVENTID_BDA_GuideDataError: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2889073736, 28531, 20439, [179, 65, 89, 76, 54, 13, 141, 116]);
pub const EVENTID_BDA_GuideServiceInformationUpdated: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2713971243, 5983, 17496, [183, 53, 80, 125, 34, 219, 35, 166]);
pub const EVENTID_BDA_IsdbCASResponse: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3570080102, 16828, 19693, [154, 32, 253, 206, 172, 120, 247, 13]);
pub const EVENTID_BDA_LbigsCloseConnectionHandle: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3270544281, 26095, 17172, [150, 113, 233, 157, 76, 206, 11, 174]);
pub const EVENTID_BDA_LbigsOpenConnection: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(895616946, 28465, 20144, [162, 113, 179, 250, 107, 183, 104, 15]);
pub const EVENTID_BDA_LbigsSendData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(287516539, 61894, 16724, [139, 13, 72, 230, 21, 112, 89, 170]);
pub const EVENTID_BDA_RatingPinReset: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336587456, 50548, 19494, [188, 218, 47, 77, 53, 235, 94, 133]);
pub const EVENTID_BDA_TransprtStreamSelectorInfo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3289358213, 2512, 18588, [158, 156, 10, 187, 181, 105, 81, 176]);
pub const EVENTID_BDA_TunerNoSignal: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3801823275, 7901, 18736, [188, 70, 104, 47, 215, 45, 45, 251]);
pub const EVENTID_BDA_TunerSignalLock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(410183488, 62835, 17051, [160, 14, 217, 193, 228, 8, 175, 9]);
pub const EVENTID_BDA_UpdateDrmStatus: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1705440897, 5218, 18235, [136, 206, 203, 115, 20, 39, 189, 181]);
pub const EVENTID_BDA_UpdateScanState: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1433414480, 31561, 17080, [168, 47, 74, 251, 105, 27, 6, 40]);
pub const EVENTID_CADenialCountChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(711312680, 8777, 16496, [172, 22, 0, 57, 12, 223, 178, 221]);
pub const EVENTID_CASFailureSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3940037038, 21801, 19743, [175, 206, 13, 140, 209, 37, 125, 48]);
pub const EVENTID_CSDescriptorSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4024924633, 38896, 18310, [128, 13, 149, 207, 80, 93, 220, 102]);
pub const EVENTID_CandidatePostTuneData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2667762640, 40710, 17257, [159, 30, 58, 214, 202, 25, 128, 126]);
pub const EVENTID_CardStatusChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2724592362, 63604, 19256, [159, 247, 197, 61, 2, 150, 153, 150]);
pub const EVENTID_ChannelChangeSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2422719973, 19548, 16901, [134, 200, 122, 254, 32, 254, 30, 250]);
pub const EVENTID_ChannelInfoSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1106472320, 16690, 19650, [177, 33, 1, 164, 50, 25, 216, 27]);
pub const EVENTID_ChannelTypeSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1923816785, 34770, 18587, [186, 17, 14, 8, 220, 33, 2, 67]);
pub const EVENTID_CtxADescriptorSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(984916710, 16967, 19252, [137, 108, 48, 175, 165, 210, 28, 36]);
pub const EVENTID_DFNWithNoActualAVData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4117274622, 22009, 19379, [150, 190, 174, 151, 28, 99, 186, 224]);
pub const EVENTID_DRMParingStatusChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(591605, 61649, 16854, [167, 223, 64, 40, 105, 118, 105, 246]);
pub const EVENTID_DRMParingStepComplete: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1529790328, 46930, 17440, [180, 30, 164, 114, 220, 149, 130, 142]);
pub const EVENTID_DTFilterCOPPBlock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229802, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterCOPPUnblock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229800, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterDataFormatFailure: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229805, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterDataFormatOK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229804, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterRatingChange: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229794, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterRatingsBlock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229795, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterRatingsUnblock: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229796, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DTFilterXDSPacket: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229797, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_DVBScramblingControlSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1272242628, 37025, 16649, [130, 54, 39, 240, 14, 125, 204, 91]);
pub const EVENTID_DemultiplexerFilterDiscontinuity: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(370497392, 44757, 18268, [187, 152, 149, 163, 48, 112, 223, 12]);
pub const EVENTID_DualMonoSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2846006102, 43083, 18572, [137, 213, 13, 78, 118, 87, 200, 206]);
pub const EVENTID_DvbParentalRatingDescriptor: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(711435661, 60581, 20140, [171, 203, 231, 52, 211, 119, 109, 10]);
pub const EVENTID_EASMessageReceived: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3507354069, 49761, 19333, [158, 138, 81, 123, 50, 153, 202, 178]);
pub const EVENTID_ETDTFilterLicenseFailure: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229807, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ETDTFilterLicenseOK: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229806, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ETFilterCopyNever: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229808, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ETFilterCopyOnce: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229803, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ETFilterEncryptionOff: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229799, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_ETFilterEncryptionOn: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229798, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_EmmMessageSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1810891368, 20350, 17044, [170, 135, 233, 233, 83, 228, 63, 20]);
pub const EVENTID_EncDecFilterError: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229801, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_EncDecFilterEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1243301467, 4025, 16729, [175, 189, 227, 48, 6, 160, 249, 244]);
pub const EVENTID_EntitlementChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2423369053, 9049, 19605, [134, 148, 175, 168, 29, 112, 191, 213]);
pub const EVENTID_FormatNotSupportedEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(615655434, 45738, 18295, [191, 101, 99, 243, 94, 123, 2, 74]);
pub const EVENTID_LanguageSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3801245293, 39938, 17549, [170, 141, 120, 26, 147, 253, 195, 149]);
pub const EVENTID_MMIMessage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(86780335, 2468, 19347, [137, 15, 189, 106, 52, 137, 104, 164]);
pub const EVENTID_NewSignalAcquired: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3363751213, 52504, 16458, [160, 118, 192, 42, 39, 61, 61, 231]);
pub const EVENTID_PBDAParentalControlEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4182223493, 64338, 18664, [185, 197, 225, 225, 244, 17, 165, 26]);
pub const EVENTID_PIDListSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1207734117, 58043, 17972, [156, 239, 253, 191, 230, 38, 29, 92]);
pub const EVENTID_PSITable: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(463222531, 54343, 19990, [151, 187, 1, 121, 159, 192, 49, 237]);
pub const EVENTID_RRTSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4140812532, 55955, 20271, [191, 248, 186, 30, 230, 252, 163, 162]);
pub const EVENTID_SBE2RecControlStarted: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2305206430, 63550, 19470, [188, 59, 191, 167, 100, 158, 4, 203]);
pub const EVENTID_SBE2RecControlStopped: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1162550984, 3227, 19626, [177, 161, 30, 122, 38, 102, 246, 195]);
pub const EVENTID_STBChannelNumber: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(398776112, 53488, 16698, [140, 153, 80, 4, 105, 222, 53, 173]);
pub const EVENTID_ServiceTerminated: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(169695516, 57554, 20366, [137, 96, 35, 53, 190, 244, 92, 203]);
pub const EVENTID_SignalAndServiceStatusSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2154350027, 15364, 18731, [180, 125, 3, 8, 130, 13, 206, 81]);
pub const EVENTID_SignalStatusChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1839004402, 28717, 19201, [141, 255, 104, 146, 173, 32, 209, 145]);
pub const EVENTID_StreamIDSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3404835688, 57683, 19777, [166, 179, 167, 201, 152, 219, 117, 238]);
pub const EVENTID_StreamTypeSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2192518844, 12454, 16996, [168, 11, 173, 46, 19, 114, 172, 96]);
pub const EVENTID_SubtitleSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1573830728, 53433, 16739, [135, 44, 79, 50, 34, 59, 232, 138]);
pub const EVENTID_TeletextSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2509887824, 24371, 17943, [175, 124, 30, 84, 181, 16, 218, 163]);
pub const EVENTID_TuneFailureEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3648161714, 11773, 17258, [148, 133, 153, 215, 212, 171, 90, 105]);
pub const EVENTID_TuneFailureSpanningEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1871357013, 24289, 18603, [162, 124, 76, 141, 112, 185, 174, 186]);
pub const EVENTID_TuningChanged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2642305589, 19325, 16989, [166, 209, 215, 23, 195, 59, 156, 76]);
pub const EVENTID_TuningChanging: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2199403523, 49310, 17860, [167, 25, 128, 122, 148, 149, 43, 249]);
pub const EVENTID_XDSCodecDuplicateXDSRating: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229791, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_XDSCodecNewXDSPacket: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229793, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTID_XDSCodecNewXDSRating: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229792, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
pub const EVENTTYPE_CASDescrambleFailureEvent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2987556162, 31717, 20299, [145, 48, 102, 121, 137, 159, 79, 75]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const E_PROP_ID_UNSUPPORTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147023728i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub const E_PROP_SET_UNSUPPORTED: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147023726i32 as _);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTag_Mode(pub i32);
pub const EnTag_Remove: EnTag_Mode = EnTag_Mode(0i32);
pub const EnTag_Once: EnTag_Mode = EnTag_Mode(1i32);
pub const EnTag_Repeat: EnTag_Mode = EnTag_Mode(2i32);
impl ::std::convert::From<i32> for EnTag_Mode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTag_Mode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_CAE_TV(pub i32);
pub const CAE_TV_Exempt: EnTvRat_CAE_TV = EnTvRat_CAE_TV(0i32);
pub const CAE_TV_C: EnTvRat_CAE_TV = EnTvRat_CAE_TV(1i32);
pub const CAE_TV_C8: EnTvRat_CAE_TV = EnTvRat_CAE_TV(2i32);
pub const CAE_TV_G: EnTvRat_CAE_TV = EnTvRat_CAE_TV(3i32);
pub const CAE_TV_PG: EnTvRat_CAE_TV = EnTvRat_CAE_TV(4i32);
pub const CAE_TV_14: EnTvRat_CAE_TV = EnTvRat_CAE_TV(5i32);
pub const CAE_TV_18: EnTvRat_CAE_TV = EnTvRat_CAE_TV(6i32);
pub const CAE_TV_Reserved: EnTvRat_CAE_TV = EnTvRat_CAE_TV(7i32);
impl ::std::convert::From<i32> for EnTvRat_CAE_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_CAE_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_CAF_TV(pub i32);
pub const CAF_TV_Exempt: EnTvRat_CAF_TV = EnTvRat_CAF_TV(0i32);
pub const CAF_TV_G: EnTvRat_CAF_TV = EnTvRat_CAF_TV(1i32);
pub const CAF_TV_8: EnTvRat_CAF_TV = EnTvRat_CAF_TV(2i32);
pub const CAF_TV_13: EnTvRat_CAF_TV = EnTvRat_CAF_TV(3i32);
pub const CAF_TV_16: EnTvRat_CAF_TV = EnTvRat_CAF_TV(4i32);
pub const CAF_TV_18: EnTvRat_CAF_TV = EnTvRat_CAF_TV(5i32);
pub const CAF_TV_Reserved6: EnTvRat_CAF_TV = EnTvRat_CAF_TV(6i32);
pub const CAF_TV_Reserved: EnTvRat_CAF_TV = EnTvRat_CAF_TV(7i32);
impl ::std::convert::From<i32> for EnTvRat_CAF_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_CAF_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_GenericLevel(pub i32);
pub const TvRat_0: EnTvRat_GenericLevel = EnTvRat_GenericLevel(0i32);
pub const TvRat_1: EnTvRat_GenericLevel = EnTvRat_GenericLevel(1i32);
pub const TvRat_2: EnTvRat_GenericLevel = EnTvRat_GenericLevel(2i32);
pub const TvRat_3: EnTvRat_GenericLevel = EnTvRat_GenericLevel(3i32);
pub const TvRat_4: EnTvRat_GenericLevel = EnTvRat_GenericLevel(4i32);
pub const TvRat_5: EnTvRat_GenericLevel = EnTvRat_GenericLevel(5i32);
pub const TvRat_6: EnTvRat_GenericLevel = EnTvRat_GenericLevel(6i32);
pub const TvRat_7: EnTvRat_GenericLevel = EnTvRat_GenericLevel(7i32);
pub const TvRat_8: EnTvRat_GenericLevel = EnTvRat_GenericLevel(8i32);
pub const TvRat_9: EnTvRat_GenericLevel = EnTvRat_GenericLevel(9i32);
pub const TvRat_10: EnTvRat_GenericLevel = EnTvRat_GenericLevel(10i32);
pub const TvRat_11: EnTvRat_GenericLevel = EnTvRat_GenericLevel(11i32);
pub const TvRat_12: EnTvRat_GenericLevel = EnTvRat_GenericLevel(12i32);
pub const TvRat_13: EnTvRat_GenericLevel = EnTvRat_GenericLevel(13i32);
pub const TvRat_14: EnTvRat_GenericLevel = EnTvRat_GenericLevel(14i32);
pub const TvRat_15: EnTvRat_GenericLevel = EnTvRat_GenericLevel(15i32);
pub const TvRat_16: EnTvRat_GenericLevel = EnTvRat_GenericLevel(16i32);
pub const TvRat_17: EnTvRat_GenericLevel = EnTvRat_GenericLevel(17i32);
pub const TvRat_18: EnTvRat_GenericLevel = EnTvRat_GenericLevel(18i32);
pub const TvRat_19: EnTvRat_GenericLevel = EnTvRat_GenericLevel(19i32);
pub const TvRat_20: EnTvRat_GenericLevel = EnTvRat_GenericLevel(20i32);
pub const TvRat_21: EnTvRat_GenericLevel = EnTvRat_GenericLevel(21i32);
pub const TvRat_kLevels: EnTvRat_GenericLevel = EnTvRat_GenericLevel(22i32);
pub const TvRat_Unblock: EnTvRat_GenericLevel = EnTvRat_GenericLevel(-1i32);
pub const TvRat_LevelDontKnow: EnTvRat_GenericLevel = EnTvRat_GenericLevel(255i32);
impl ::std::convert::From<i32> for EnTvRat_GenericLevel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_GenericLevel {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_MPAA(pub i32);
pub const MPAA_NotApplicable: EnTvRat_MPAA = EnTvRat_MPAA(0i32);
pub const MPAA_G: EnTvRat_MPAA = EnTvRat_MPAA(1i32);
pub const MPAA_PG: EnTvRat_MPAA = EnTvRat_MPAA(2i32);
pub const MPAA_PG13: EnTvRat_MPAA = EnTvRat_MPAA(3i32);
pub const MPAA_R: EnTvRat_MPAA = EnTvRat_MPAA(4i32);
pub const MPAA_NC17: EnTvRat_MPAA = EnTvRat_MPAA(5i32);
pub const MPAA_X: EnTvRat_MPAA = EnTvRat_MPAA(6i32);
pub const MPAA_NotRated: EnTvRat_MPAA = EnTvRat_MPAA(7i32);
impl ::std::convert::From<i32> for EnTvRat_MPAA {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_MPAA {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_System(pub i32);
pub const MPAA: EnTvRat_System = EnTvRat_System(0i32);
pub const US_TV: EnTvRat_System = EnTvRat_System(1i32);
pub const Canadian_English: EnTvRat_System = EnTvRat_System(2i32);
pub const Canadian_French: EnTvRat_System = EnTvRat_System(3i32);
pub const Reserved4: EnTvRat_System = EnTvRat_System(4i32);
pub const System5: EnTvRat_System = EnTvRat_System(5i32);
pub const System6: EnTvRat_System = EnTvRat_System(6i32);
pub const Reserved7: EnTvRat_System = EnTvRat_System(7i32);
pub const PBDA: EnTvRat_System = EnTvRat_System(8i32);
pub const AgeBased: EnTvRat_System = EnTvRat_System(9i32);
pub const TvRat_kSystems: EnTvRat_System = EnTvRat_System(10i32);
pub const TvRat_SystemDontKnow: EnTvRat_System = EnTvRat_System(255i32);
impl ::std::convert::From<i32> for EnTvRat_System {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_System {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EnTvRat_US_TV(pub i32);
pub const US_TV_None: EnTvRat_US_TV = EnTvRat_US_TV(0i32);
pub const US_TV_Y: EnTvRat_US_TV = EnTvRat_US_TV(1i32);
pub const US_TV_Y7: EnTvRat_US_TV = EnTvRat_US_TV(2i32);
pub const US_TV_G: EnTvRat_US_TV = EnTvRat_US_TV(3i32);
pub const US_TV_PG: EnTvRat_US_TV = EnTvRat_US_TV(4i32);
pub const US_TV_14: EnTvRat_US_TV = EnTvRat_US_TV(5i32);
pub const US_TV_MA: EnTvRat_US_TV = EnTvRat_US_TV(6i32);
pub const US_TV_None7: EnTvRat_US_TV = EnTvRat_US_TV(7i32);
impl ::std::convert::From<i32> for EnTvRat_US_TV {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EnTvRat_US_TV {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EncDecEvents(pub i32);
pub const ENCDEC_CPEVENT: EncDecEvents = EncDecEvents(0i32);
pub const ENCDEC_RECORDING_STATUS: EncDecEvents = EncDecEvents(1i32);
impl ::std::convert::From<i32> for EncDecEvents {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EncDecEvents {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct EntitlementType(pub i32);
pub const Entitled: EntitlementType = EntitlementType(0i32);
pub const NotEntitled: EntitlementType = EntitlementType(1i32);
pub const TechnicalFailure: EntitlementType = EntitlementType(2i32);
impl ::std::convert::From<i32> for EntitlementType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EntitlementType {
    type Abi = Self;
}
pub const EvalRat: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3318072817, 15036, 4566, [178, 91, 0, 192, 79, 160, 192, 38]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FECMethod(pub i32);
pub const BDA_FEC_METHOD_NOT_SET: FECMethod = FECMethod(-1i32);
pub const BDA_FEC_METHOD_NOT_DEFINED: FECMethod = FECMethod(0i32);
pub const BDA_FEC_VITERBI: FECMethod = FECMethod(1i32);
pub const BDA_FEC_RS_204_188: FECMethod = FECMethod(2i32);
pub const BDA_FEC_LDPC: FECMethod = FECMethod(3i32);
pub const BDA_FEC_BCH: FECMethod = FECMethod(4i32);
pub const BDA_FEC_RS_147_130: FECMethod = FECMethod(5i32);
pub const BDA_FEC_MAX: FECMethod = FECMethod(6i32);
impl ::std::convert::From<i32> for FECMethod {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FECMethod {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
pub struct FILTER_INFO {
    pub achName: [u16; 128],
    pub pGraph: ::std::option::Option<IFilterGraph>,
}
impl FILTER_INFO {}
impl ::std::default::Default for FILTER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FILTER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FILTER_INFO").field("achName", &self.achName).field("pGraph", &self.pGraph).finish()
    }
}
impl ::std::cmp::PartialEq for FILTER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.achName == other.achName && self.pGraph == other.pGraph
    }
}
impl ::std::cmp::Eq for FILTER_INFO {}
unsafe impl ::windows::runtime::Abi for FILTER_INFO {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FILTER_STATE(pub i32);
pub const State_Stopped: FILTER_STATE = FILTER_STATE(0i32);
pub const State_Paused: FILTER_STATE = FILTER_STATE(1i32);
pub const State_Running: FILTER_STATE = FILTER_STATE(2i32);
impl ::std::convert::From<i32> for FILTER_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FILTER_STATE {
    type Abi = Self;
}
pub const FORMATTYPE_CPFilters_Processed: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1731834735, 7519, 19138, [129, 146, 40, 187, 14, 115, 209, 106]);
pub const FORMATTYPE_ETDTFilter_Tagged: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3301229777, 73, 20011, [152, 251, 149, 55, 246, 206, 81, 109]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FRAMING_CACHE_OPS(pub i32);
pub const Framing_Cache_Update: FRAMING_CACHE_OPS = FRAMING_CACHE_OPS(0i32);
pub const Framing_Cache_ReadLast: FRAMING_CACHE_OPS = FRAMING_CACHE_OPS(1i32);
pub const Framing_Cache_ReadOrig: FRAMING_CACHE_OPS = FRAMING_CACHE_OPS(2i32);
pub const Framing_Cache_Write: FRAMING_CACHE_OPS = FRAMING_CACHE_OPS(3i32);
impl ::std::convert::From<i32> for FRAMING_CACHE_OPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FRAMING_CACHE_OPS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FRAMING_PROP(pub i32);
pub const FramingProp_Uninitialized: FRAMING_PROP = FRAMING_PROP(0i32);
pub const FramingProp_None: FRAMING_PROP = FRAMING_PROP(1i32);
pub const FramingProp_Old: FRAMING_PROP = FRAMING_PROP(2i32);
pub const FramingProp_Ex: FRAMING_PROP = FRAMING_PROP(3i32);
impl ::std::convert::From<i32> for FRAMING_PROP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FRAMING_PROP {
    type Abi = Self;
}
pub const FilgraphManager: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3828804531, 21071, 4558, [159, 83, 0, 32, 175, 11, 167, 112]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FormatNotSupportedEvents(pub i32);
pub const FORMATNOTSUPPORTED_CLEAR: FormatNotSupportedEvents = FormatNotSupportedEvents(0i32);
pub const FORMATNOTSUPPORTED_NOTSUPPORTED: FormatNotSupportedEvents = FormatNotSupportedEvents(1i32);
impl ::std::convert::From<i32> for FormatNotSupportedEvents {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FormatNotSupportedEvents {
    type Abi = Self;
}
pub const GUID_TIME_MUSIC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(91538589, 23300, 19221, [165, 66, 174, 40, 32, 48, 17, 123]);
pub const GUID_TIME_REFERENCE: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2477617451, 55968, 20478, [188, 129, 176, 206, 80, 15, 205, 217]);
pub const GUID_TIME_SAMPLES: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2824420613, 3139, 18820, [154, 99, 151, 175, 158, 2, 196, 192]);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct GuardInterval(pub i32);
pub const BDA_GUARD_NOT_SET: GuardInterval = GuardInterval(-1i32);
pub const BDA_GUARD_NOT_DEFINED: GuardInterval = GuardInterval(0i32);
pub const BDA_GUARD_1_32: GuardInterval = GuardInterval(1i32);
pub const BDA_GUARD_1_16: GuardInterval = GuardInterval(2i32);
pub const BDA_GUARD_1_8: GuardInterval = GuardInterval(3i32);
pub const BDA_GUARD_1_4: GuardInterval = GuardInterval(4i32);
pub const BDA_GUARD_1_128: GuardInterval = GuardInterval(5i32);
pub const BDA_GUARD_19_128: GuardInterval = GuardInterval(6i32);
pub const BDA_GUARD_19_256: GuardInterval = GuardInterval(7i32);
pub const BDA_GUARD_MAX: GuardInterval = GuardInterval(8i32);
impl ::std::convert::From<i32> for GuardInterval {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for GuardInterval {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Multimedia`*"]
pub struct HEAACWAVEFORMAT {
    pub wfInfo: HEAACWAVEINFO,
    pub pbAudioSpecificConfig: [u8; 1],
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl HEAACWAVEFORMAT {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for HEAACWAVEFORMAT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for HEAACWAVEFORMAT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for HEAACWAVEFORMAT {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for HEAACWAVEFORMAT {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Multimedia")]
#[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Multimedia`*"]
pub struct HEAACWAVEINFO {
    pub wfx: super::super::Media::Multimedia::WAVEFORMATEX,
    pub wPayloadType: u16,
    pub wAudioProfileLevelIndication: u16,
    pub wStructType: u16,
    pub wReserved1: u16,
    pub dwReserved2: u32,
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl HEAACWAVEINFO {}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::default::Default for HEAACWAVEINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::PartialEq for HEAACWAVEINFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Media_Multimedia")]
impl ::std::cmp::Eq for HEAACWAVEINFO {}
#[cfg(feature = "Win32_Media_Multimedia")]
unsafe impl ::windows::runtime::Abi for HEAACWAVEINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct HierarchyAlpha(pub i32);
pub const BDA_HALPHA_NOT_SET: HierarchyAlpha = HierarchyAlpha(-1i32);
pub const BDA_HALPHA_NOT_DEFINED: HierarchyAlpha = HierarchyAlpha(0i32);
pub const BDA_HALPHA_1: HierarchyAlpha = HierarchyAlpha(1i32);
pub const BDA_HALPHA_2: HierarchyAlpha = HierarchyAlpha(2i32);
pub const BDA_HALPHA_4: HierarchyAlpha = HierarchyAlpha(3i32);
pub const BDA_HALPHA_MAX: HierarchyAlpha = HierarchyAlpha(4i32);
impl ::std::convert::From<i32> for HierarchyAlpha {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HierarchyAlpha {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMAnalogVideoDecoder(pub ::windows::runtime::IUnknown);
impl IAMAnalogVideoDecoder {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(lanalogvideostandard)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TVFormat(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn HorizontalLocked(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(lvcrhorizontallocking)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn VCRHorizontalLocking(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn NumberOfLines(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOutputEnable(&self, loutputenable: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(loutputenable)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OutputEnable(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMAnalogVideoDecoder {
    type Vtable = IAMAnalogVideoDecoder_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647504, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMAnalogVideoDecoder> for ::windows::runtime::IUnknown {
    fn from(value: IAMAnalogVideoDecoder) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMAnalogVideoDecoder> for ::windows::runtime::IUnknown {
    fn from(value: &IAMAnalogVideoDecoder) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMAnalogVideoDecoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMAnalogVideoDecoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoDecoder_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lanalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lanalogvideostandard: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, planalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pllocked: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lvcrhorizontallocking: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plvcrhorizontallocking: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plnumberoflines: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, loutputenable: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ploutputenable: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMAnalogVideoEncoder(pub ::windows::runtime::IUnknown);
impl IAMAnalogVideoEncoder {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(lanalogvideostandard)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TVFormat(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCopyProtection(&self, lvideocopyprotection: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lvideocopyprotection)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CopyProtection(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCCEnable(&self, lccenable: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(lccenable)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CCEnable(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMAnalogVideoEncoder {
    type Vtable = IAMAnalogVideoEncoder_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647600, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMAnalogVideoEncoder> for ::windows::runtime::IUnknown {
    fn from(value: IAMAnalogVideoEncoder) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMAnalogVideoEncoder> for ::windows::runtime::IUnknown {
    fn from(value: &IAMAnalogVideoEncoder) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMAnalogVideoEncoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMAnalogVideoEncoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoEncoder_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lanalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lanalogvideostandard: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, planalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lvideocopyprotection: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lvideocopyprotection: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lccenable: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lccenable: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMAsyncReaderTimestampScaling(pub ::windows::runtime::IUnknown);
impl IAMAsyncReaderTimestampScaling {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetTimestampMode(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetTimestampMode<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fraw: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), fraw.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMAsyncReaderTimestampScaling {
    type Vtable = IAMAsyncReaderTimestampScaling_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3480954620, 39424, 18523, [129, 71, 62, 120, 157, 94, 143, 103]);
}
impl ::std::convert::From<IAMAsyncReaderTimestampScaling> for ::windows::runtime::IUnknown {
    fn from(value: IAMAsyncReaderTimestampScaling) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMAsyncReaderTimestampScaling> for ::windows::runtime::IUnknown {
    fn from(value: &IAMAsyncReaderTimestampScaling) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMAsyncReaderTimestampScaling {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMAsyncReaderTimestampScaling {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAsyncReaderTimestampScaling_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfraw: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fraw: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMAudioInputMixer(pub ::windows::runtime::IUnknown);
impl IAMAudioInputMixer {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetEnable<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fenable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), fenable.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Enable(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMono<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fmono: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), fmono.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Mono(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMixLevel(&self, level: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(level)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MixLevel(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPan(&self, pan: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pan)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Pan(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetLoudness<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, floudness: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), floudness.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Loudness(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTreble(&self, treble: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(treble)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Treble(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TrebleRange(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetBass(&self, bass: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(bass)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Bass(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn BassRange(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMAudioInputMixer {
    type Vtable = IAMAudioInputMixer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1422103073, 33664, 4560, [179, 240, 0, 170, 0, 55, 97, 197]);
}
impl ::std::convert::From<IAMAudioInputMixer> for ::windows::runtime::IUnknown {
    fn from(value: IAMAudioInputMixer) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMAudioInputMixer> for ::windows::runtime::IUnknown {
    fn from(value: &IAMAudioInputMixer) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMAudioInputMixer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMAudioInputMixer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioInputMixer_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fenable: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfenable: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fmono: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfmono: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, level: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plevel: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pan: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppan: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, floudness: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfloudness: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, treble: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptreble: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prange: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bass: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbass: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prange: *mut f64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMAudioRendererStats(pub ::windows::runtime::IUnknown);
impl IAMAudioRendererStats {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwparam), ::std::mem::transmute(pdwparam1), ::std::mem::transmute(pdwparam2)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMAudioRendererStats {
    type Vtable = IAMAudioRendererStats_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(573705394, 54298, 4562, [191, 124, 215, 203, 157, 240, 191, 147]);
}
impl ::std::convert::From<IAMAudioRendererStats> for ::windows::runtime::IUnknown {
    fn from(value: IAMAudioRendererStats) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMAudioRendererStats> for ::windows::runtime::IUnknown {
    fn from(value: &IAMAudioRendererStats) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMAudioRendererStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMAudioRendererStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioRendererStats_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMBufferNegotiation(pub ::windows::runtime::IUnknown);
impl IAMBufferNegotiation {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pprop)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetAllocatorProperties(&self) -> ::windows::runtime::Result<ALLOCATOR_PROPERTIES> {
        let mut result__: <ALLOCATOR_PROPERTIES as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ALLOCATOR_PROPERTIES>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMBufferNegotiation {
    type Vtable = IAMBufferNegotiation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1458401696, 44895, 4560, [179, 240, 0, 170, 0, 55, 97, 197]);
}
impl ::std::convert::From<IAMBufferNegotiation> for ::windows::runtime::IUnknown {
    fn from(value: IAMBufferNegotiation) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMBufferNegotiation> for ::windows::runtime::IUnknown {
    fn from(value: &IAMBufferNegotiation) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMBufferNegotiation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMBufferNegotiation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMBufferNegotiation_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pprop: *mut ALLOCATOR_PROPERTIES) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMCameraControl(pub ::windows::runtime::IUnknown);
impl IAMCameraControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(pmin), ::std::mem::transmute(pmax), ::std::mem::transmute(psteppingdelta), ::std::mem::transmute(pdefault), ::std::mem::transmute(pcapsflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(lvalue), ::std::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(lvalue), ::std::mem::transmute(flags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMCameraControl {
    type Vtable = IAMCameraControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647536, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMCameraControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMCameraControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMCameraControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMCameraControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMCameraControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMCameraControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCameraControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, lvalue: i32, flags: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMCertifiedOutputProtection(pub ::windows::runtime::IUnknown);
impl IAMCertifiedOutputProtection {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn KeyExchange(&self, prandom: *mut ::windows::runtime::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(prandom), ::std::mem::transmute(varlencertgh), ::std::mem::transmute(pdwlengthcertgh)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SessionSequenceStart(&self, psig: *mut AMCOPPSignature) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(psig)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(cmd)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput) -> ::windows::runtime::Result<AMCOPPStatusOutput> {
        let mut result__: <AMCOPPStatusOutput as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(pstatusinput), &mut result__).from_abi::<AMCOPPStatusOutput>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMCertifiedOutputProtection {
    type Vtable = IAMCertifiedOutputProtection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1877863742, 4081, 18689, [162, 241, 67, 247, 1, 44, 133, 21]);
}
impl ::std::convert::From<IAMCertifiedOutputProtection> for ::windows::runtime::IUnknown {
    fn from(value: IAMCertifiedOutputProtection) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMCertifiedOutputProtection> for ::windows::runtime::IUnknown {
    fn from(value: &IAMCertifiedOutputProtection) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMCertifiedOutputProtection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMCertifiedOutputProtection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCertifiedOutputProtection_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prandom: *mut ::windows::runtime::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psig: *mut AMCOPPSignature) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cmd: *const AMCOPPCommand) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMChannelInfo(pub ::windows::runtime::IUnknown);
impl IAMChannelInfo {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ChannelName(&self, pbstrchannelname: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrchannelname)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ChannelDescription(&self, pbstrchanneldescription: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrchanneldescription)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ChannelURL(&self, pbstrchannelurl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrchannelurl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ContactAddress(&self, pbstrcontactaddress: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrcontactaddress)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ContactPhone(&self, pbstrcontactphone: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrcontactphone)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ContactEmail(&self, pbstrcontactemail: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrcontactemail)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMChannelInfo {
    type Vtable = IAMChannelInfo_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099762, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMChannelInfo> for ::windows::runtime::IUnknown {
    fn from(value: IAMChannelInfo) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMChannelInfo> for ::windows::runtime::IUnknown {
    fn from(value: &IAMChannelInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMChannelInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMChannelInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMChannelInfo> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMChannelInfo) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMChannelInfo> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMChannelInfo) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMChannelInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMChannelInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMChannelInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrchannelname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrchanneldescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrchannelurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrcontactaddress: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrcontactphone: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrcontactemail: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMClockAdjust(pub ::windows::runtime::IUnknown);
impl IAMClockAdjust {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetClockDelta(&self, rtdelta: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(rtdelta)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMClockAdjust {
    type Vtable = IAMClockAdjust_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1297376944, 42140, 4561, [171, 232, 0, 160, 201, 5, 243, 117]);
}
impl ::std::convert::From<IAMClockAdjust> for ::windows::runtime::IUnknown {
    fn from(value: IAMClockAdjust) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMClockAdjust> for ::windows::runtime::IUnknown {
    fn from(value: &IAMClockAdjust) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMClockAdjust {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMClockAdjust {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockAdjust_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rtdelta: i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMClockSlave(pub ::windows::runtime::IUnknown);
impl IAMClockSlave {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetErrorTolerance(&self, dwtolerance: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwtolerance)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetErrorTolerance(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMClockSlave {
    type Vtable = IAMClockSlave_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2681546561, 5997, 19254, [143, 81, 202, 143, 147, 50, 35, 190]);
}
impl ::std::convert::From<IAMClockSlave> for ::windows::runtime::IUnknown {
    fn from(value: IAMClockSlave) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMClockSlave> for ::windows::runtime::IUnknown {
    fn from(value: &IAMClockSlave) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMClockSlave {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMClockSlave {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockSlave_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwtolerance: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwtolerance: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMCollection(pub ::windows::runtime::IUnknown);
impl IAMCollection {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Item(&self, litem: i32) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(litem), &mut result__).from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMCollection {
    type Vtable = IAMCollection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1453877433, 2772, 4558, [176, 58, 0, 32, 175, 11, 167, 112]);
}
impl ::std::convert::From<IAMCollection> for ::windows::runtime::IUnknown {
    fn from(value: IAMCollection) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMCollection> for ::windows::runtime::IUnknown {
    fn from(value: &IAMCollection) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMCollection> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMCollection> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCollection_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plcount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, litem: i32, ppunk: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppunk: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMCopyCaptureFileProgress(pub ::windows::runtime::IUnknown);
impl IAMCopyCaptureFileProgress {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Progress(&self, iprogress: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(iprogress)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMCopyCaptureFileProgress {
    type Vtable = IAMCopyCaptureFileProgress_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1728912672, 41064, 4560, [179, 240, 0, 170, 0, 55, 97, 197]);
}
impl ::std::convert::From<IAMCopyCaptureFileProgress> for ::windows::runtime::IUnknown {
    fn from(value: IAMCopyCaptureFileProgress) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMCopyCaptureFileProgress> for ::windows::runtime::IUnknown {
    fn from(value: &IAMCopyCaptureFileProgress) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMCopyCaptureFileProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMCopyCaptureFileProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCopyCaptureFileProgress_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iprogress: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMCrossbar(pub ::windows::runtime::IUnknown);
impl IAMCrossbar {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(outputpincount), ::std::mem::transmute(inputpincount)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(outputpinindex), ::std::mem::transmute(inputpinindex)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(outputpinindex), ::std::mem::transmute(inputpinindex)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsRoutedTo(&self, outputpinindex: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(outputpinindex), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn CrossbarPinInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, isinputpin: Param0, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), isinputpin.into_param().abi(), ::std::mem::transmute(pinindex), ::std::mem::transmute(pinindexrelated), ::std::mem::transmute(physicaltype)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMCrossbar {
    type Vtable = IAMCrossbar_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647552, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMCrossbar> for ::windows::runtime::IUnknown {
    fn from(value: IAMCrossbar) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMCrossbar> for ::windows::runtime::IUnknown {
    fn from(value: &IAMCrossbar) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMCrossbar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMCrossbar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCrossbar_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, outputpinindex: i32, inputpinindex: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, outputpinindex: i32, inputpinindex: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, outputpinindex: i32, inputpinindex: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, isinputpin: super::super::Foundation::BOOL, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDecoderCaps(pub ::windows::runtime::IUnknown);
impl IAMDecoderCaps {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDecoderCaps(&self, dwcapindex: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcapindex), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMDecoderCaps {
    type Vtable = IAMDecoderCaps_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3235902567, 54425, 18822, [151, 43, 225, 217, 9, 15, 169, 65]);
}
impl ::std::convert::From<IAMDecoderCaps> for ::windows::runtime::IUnknown {
    fn from(value: IAMDecoderCaps) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDecoderCaps> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDecoderCaps) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDecoderCaps {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDecoderCaps {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDecoderCaps_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcapindex: u32, lpdwcap: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDevMemoryAllocator(pub ::windows::runtime::IUnknown);
impl IAMDevMemoryAllocator {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwcbtotalfree), ::std::mem::transmute(pdwcblargestfree), ::std::mem::transmute(pdwcbtotalmemory), ::std::mem::transmute(pdwcbminimumchunk)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CheckMemory(&self, pbuffer: *const u8) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppbuffer), ::std::mem::transmute(pdwcbbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Free(&self, pbuffer: *mut u8) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbuffer)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDevMemoryObject<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, ppunkinnner: *mut ::std::option::Option<::windows::runtime::IUnknown>, punkouter: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppunkinnner), punkouter.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMDevMemoryAllocator {
    type Vtable = IAMDevMemoryAllocator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3327417328, 59243, 4560, [189, 82, 0, 160, 201, 17, 206, 134]);
}
impl ::std::convert::From<IAMDevMemoryAllocator> for ::windows::runtime::IUnknown {
    fn from(value: IAMDevMemoryAllocator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDevMemoryAllocator> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDevMemoryAllocator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDevMemoryAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDevMemoryAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryAllocator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbuffer: *const u8) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbuffer: *mut u8) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppunkinnner: *mut ::windows::runtime::RawPtr, punkouter: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDevMemoryControl(pub ::windows::runtime::IUnknown);
impl IAMDevMemoryControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn QueryWriteSync(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn WriteSync(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDevId(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMDevMemoryControl {
    type Vtable = IAMDevMemoryControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3327417329, 59243, 4560, [189, 82, 0, 160, 201, 17, 206, 134]);
}
impl ::std::convert::From<IAMDevMemoryControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMDevMemoryControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDevMemoryControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDevMemoryControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDevMemoryControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDevMemoryControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwdevid: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDeviceRemoval(pub ::windows::runtime::IUnknown);
impl IAMDeviceRemoval {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn DeviceInfo(&self, pclsidinterfaceclass: *mut ::windows::runtime::GUID, pwszsymboliclink: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pclsidinterfaceclass), ::std::mem::transmute(pwszsymboliclink)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Reassociate(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Disassociate(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMDeviceRemoval {
    type Vtable = IAMDeviceRemoval_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4178207024, 46680, 4562, [174, 73, 0, 0, 248, 117, 75, 153]);
}
impl ::std::convert::From<IAMDeviceRemoval> for ::windows::runtime::IUnknown {
    fn from(value: IAMDeviceRemoval) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDeviceRemoval> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDeviceRemoval) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDeviceRemoval {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDeviceRemoval {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDeviceRemoval_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pclsidinterfaceclass: *mut ::windows::runtime::GUID, pwszsymboliclink: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDirectSound(pub ::windows::runtime::IUnknown);
impl IAMDirectSound {
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn GetDirectSoundInterface(&self) -> ::windows::runtime::Result<super::super::Media::Audio::DirectMusic::IDirectSound> {
        let mut result__: <super::super::Media::Audio::DirectMusic::IDirectSound as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Media::Audio::DirectMusic::IDirectSound>(result__)
    }
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn GetPrimaryBufferInterface(&self) -> ::windows::runtime::Result<super::super::Media::Audio::DirectMusic::IDirectSoundBuffer> {
        let mut result__: <super::super::Media::Audio::DirectMusic::IDirectSoundBuffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Media::Audio::DirectMusic::IDirectSoundBuffer>(result__)
    }
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn GetSecondaryBufferInterface(&self) -> ::windows::runtime::Result<super::super::Media::Audio::DirectMusic::IDirectSoundBuffer> {
        let mut result__: <super::super::Media::Audio::DirectMusic::IDirectSoundBuffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Media::Audio::DirectMusic::IDirectSoundBuffer>(result__)
    }
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn ReleaseDirectSoundInterface<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Media::Audio::DirectMusic::IDirectSound>>(&self, lpds: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), lpds.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn ReleasePrimaryBufferInterface<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Media::Audio::DirectMusic::IDirectSoundBuffer>>(&self, lpdsb: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), lpdsb.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Media_Audio_DirectMusic`*"]
    pub unsafe fn ReleaseSecondaryBufferInterface<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Media::Audio::DirectMusic::IDirectSoundBuffer>>(&self, lpdsb: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), lpdsb.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetFocusWindow<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, param0: Param0, param1: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), param0.into_param().abi(), param1.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(param0), ::std::mem::transmute(param1)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMDirectSound {
    type Vtable = IAMDirectSound_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IAMDirectSound> for ::windows::runtime::IUnknown {
    fn from(value: IAMDirectSound) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDirectSound> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDirectSound) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDirectSound {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDirectSound {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDirectSound_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lplpds: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lplpdsb: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lplpdsb: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpds: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpdsb: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Media_Audio_DirectMusic")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpdsb: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectMusic"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param0: super::super::Foundation::HWND, param1: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMDroppedFrames(pub ::windows::runtime::IUnknown);
impl IAMDroppedFrames {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetNumDropped(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetNumNotDropped(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsize), ::std::mem::transmute(plarray), ::std::mem::transmute(plnumcopied)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetAverageFrameSize(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMDroppedFrames {
    type Vtable = IAMDroppedFrames_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647492, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMDroppedFrames> for ::windows::runtime::IUnknown {
    fn from(value: IAMDroppedFrames) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMDroppedFrames> for ::windows::runtime::IUnknown {
    fn from(value: &IAMDroppedFrames) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMDroppedFrames {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMDroppedFrames {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDroppedFrames_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pldropped: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plnotdropped: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plaveragesize: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMExtDevice(pub ::windows::runtime::IUnknown);
impl IAMExtDevice {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(capability), ::std::mem::transmute(pvalue), ::std::mem::transmute(pdblvalue)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ExternalDeviceID(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ExternalDeviceVersion(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDevicePower(&self, powermode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(powermode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn DevicePower(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Calibrate(&self, hevent: usize, mode: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(hevent), ::std::mem::transmute(mode), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDevicePort(&self, deviceport: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(deviceport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn DevicePort(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMExtDevice {
    type Vtable = IAMExtDevice_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3044215440, 6700, 4559, [140, 35, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMExtDevice> for ::windows::runtime::IUnknown {
    fn from(value: IAMExtDevice) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMExtDevice> for ::windows::runtime::IUnknown {
    fn from(value: &IAMExtDevice) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMExtDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMExtDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtDevice_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, powermode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppowermode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hevent: usize, mode: i32, pstatus: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, deviceport: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdeviceport: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMExtTransport(pub ::windows::runtime::IUnknown);
impl IAMExtTransport {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(capability), ::std::mem::transmute(pvalue), ::std::mem::transmute(pdblvalue)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMediaState(&self, state: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MediaState(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetLocalControl(&self, state: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn LocalControl(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetStatus(&self, statusitem: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(statusitem), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(pvalue), ::std::mem::transmute(ppszdata)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetTransportBasicParameters<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, param: i32, value: i32, pszdata: Param2) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value), pszdata.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTransportVideoParameters(&self, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTransportVideoParameters(&self, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTransportAudioParameters(&self, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTransportAudioParameters(&self, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMode(&self, mode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(mode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Mode(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetRate(&self, dblrate: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(dblrate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Rate(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(penabled), ::std::mem::transmute(poffset), ::std::mem::transmute(phevent)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(enable), ::std::mem::transmute(offset), ::std::mem::transmute(hevent)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), ::std::mem::transmute(pspeed), ::std::mem::transmute(pduration)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetBump(&self, speed: i32, duration: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(speed), ::std::mem::transmute(duration)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AntiClogControl(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetAntiClogControl(&self, enable: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(enable)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetEditPropertySet(&self, editid: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(editid), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), ::std::mem::transmute(peditid), ::std::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetEditProperty(&self, editid: i32, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(editid), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(editid), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EditStart(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEditStart(&self, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(value)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMExtTransport {
    type Vtable = IAMExtTransport_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2688341488, 12357, 4559, [140, 68, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMExtTransport> for ::windows::runtime::IUnknown {
    fn from(value: IAMExtTransport) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMExtTransport> for ::windows::runtime::IUnknown {
    fn from(value: &IAMExtTransport) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMExtTransport {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMExtTransport {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtTransport_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, statusitem: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32, ppszdata: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32, pszdata: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dblrate: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdblrate: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: i32, offset: i32, hevent: usize) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pspeed: *mut i32, pduration: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, speed: i32, duration: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penabled: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, editid: i32, pstate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, peditid: *mut i32, state: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, editid: i32, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, editid: i32, param: i32, value: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMExtendedErrorInfo(pub ::windows::runtime::IUnknown);
impl IAMExtendedErrorInfo {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn HasError(&self, phaserror: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(phaserror)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ErrorDescription(&self, pbstrerrordescription: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrerrordescription)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ErrorCode(&self, perrorcode: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(perrorcode)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMExtendedErrorInfo {
    type Vtable = IAMExtendedErrorInfo_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099766, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMExtendedErrorInfo> for ::windows::runtime::IUnknown {
    fn from(value: IAMExtendedErrorInfo) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMExtendedErrorInfo> for ::windows::runtime::IUnknown {
    fn from(value: &IAMExtendedErrorInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMExtendedErrorInfo> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMExtendedErrorInfo) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMExtendedErrorInfo> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMExtendedErrorInfo) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMExtendedErrorInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedErrorInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phaserror: *mut i16) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrerrordescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, perrorcode: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMExtendedSeeking(pub ::windows::runtime::IUnknown);
impl IAMExtendedSeeking {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pexcapabilities)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MarkerCount(&self, pmarkercount: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pmarkercount)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pcurrentmarker)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(markernum), ::std::mem::transmute(pmarkertime)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(markernum), ::std::mem::transmute(pbstrmarkername)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPlaybackSpeed(&self, speed: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(speed)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PlaybackSpeed(&self, pspeed: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(pspeed)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMExtendedSeeking {
    type Vtable = IAMExtendedSeeking_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099769, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMExtendedSeeking> for ::windows::runtime::IUnknown {
    fn from(value: IAMExtendedSeeking) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMExtendedSeeking> for ::windows::runtime::IUnknown {
    fn from(value: &IAMExtendedSeeking) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMExtendedSeeking {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMExtendedSeeking {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMExtendedSeeking> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMExtendedSeeking) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMExtendedSeeking> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMExtendedSeeking) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMExtendedSeeking {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMExtendedSeeking {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedSeeking_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pexcapabilities: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmarkercount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcurrentmarker: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, markernum: i32, pmarkertime: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, markernum: i32, pbstrmarkername: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, speed: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pspeed: *mut f64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMFilterGraphCallback(pub ::windows::runtime::IUnknown);
impl IAMFilterGraphCallback {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UnableToRender<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ppin.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMFilterGraphCallback {
    type Vtable = IAMFilterGraphCallback_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1453877501, 2772, 4558, [176, 163, 0, 32, 175, 11, 167, 112]);
}
impl ::std::convert::From<IAMFilterGraphCallback> for ::windows::runtime::IUnknown {
    fn from(value: IAMFilterGraphCallback) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMFilterGraphCallback> for ::windows::runtime::IUnknown {
    fn from(value: &IAMFilterGraphCallback) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMFilterGraphCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMFilterGraphCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterGraphCallback_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMFilterMiscFlags(pub ::windows::runtime::IUnknown);
impl IAMFilterMiscFlags {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMiscFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for IAMFilterMiscFlags {
    type Vtable = IAMFilterMiscFlags_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(769083728, 43152, 4561, [171, 232, 0, 160, 201, 5, 243, 117]);
}
impl ::std::convert::From<IAMFilterMiscFlags> for ::windows::runtime::IUnknown {
    fn from(value: IAMFilterMiscFlags) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMFilterMiscFlags> for ::windows::runtime::IUnknown {
    fn from(value: &IAMFilterMiscFlags) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMFilterMiscFlags {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMFilterMiscFlags {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterMiscFlags_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMGraphBuilderCallback(pub ::windows::runtime::IUnknown);
impl IAMGraphBuilderCallback {
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Com`*"]
    pub unsafe fn SelectedFilter<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>>(&self, pmon: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), pmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreatedFilter<'a, Param0: ::windows::runtime::IntoParam<'a, IBaseFilter>>(&self, pfil: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pfil.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMGraphBuilderCallback {
    type Vtable = IAMGraphBuilderCallback_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1234564369, 40411, 20242, [189, 59, 240, 70, 17, 128, 123, 121]);
}
impl ::std::convert::From<IAMGraphBuilderCallback> for ::windows::runtime::IUnknown {
    fn from(value: IAMGraphBuilderCallback) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMGraphBuilderCallback> for ::windows::runtime::IUnknown {
    fn from(value: &IAMGraphBuilderCallback) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMGraphBuilderCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMGraphBuilderCallback {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphBuilderCallback_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmon: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfil: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMGraphStreams(pub ::windows::runtime::IUnknown);
impl IAMGraphStreams {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn FindUpstreamInterface<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0, riid: *const ::windows::runtime::GUID, ppvinterface: *mut *mut ::std::ffi::c_void, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ppin.into_param().abi(), ::std::mem::transmute(riid), ::std::mem::transmute(ppvinterface), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SyncUsingStreamOffset<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, busestreamoffset: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), busestreamoffset.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(rtmaxgraphlatency)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMGraphStreams {
    type Vtable = IAMGraphStreams_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1663108602, 1838, 4563, [138, 249, 0, 192, 79, 182, 189, 61]);
}
impl ::std::convert::From<IAMGraphStreams> for ::windows::runtime::IUnknown {
    fn from(value: IAMGraphStreams) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMGraphStreams> for ::windows::runtime::IUnknown {
    fn from(value: &IAMGraphStreams) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMGraphStreams {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMGraphStreams {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphStreams_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvinterface: *mut *mut ::std::ffi::c_void, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, busestreamoffset: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rtmaxgraphlatency: i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMLatency(pub ::windows::runtime::IUnknown);
impl IAMLatency {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetLatency(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMLatency {
    type Vtable = IAMLatency_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1659540410, 60514, 4562, [183, 112, 0, 192, 79, 182, 189, 61]);
}
impl ::std::convert::From<IAMLatency> for ::windows::runtime::IUnknown {
    fn from(value: IAMLatency) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMLatency> for ::windows::runtime::IUnknown {
    fn from(value: &IAMLatency) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMLatency {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMLatency {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLatency_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prtlatency: *mut i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMLine21Decoder(pub ::windows::runtime::IUnknown);
impl IAMLine21Decoder {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(lplevel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpservice)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(service)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpstate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::Gdi::BITMAPINFOHEADER) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpbmih)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::Gdi::BITMAPINFO) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpbmi)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwphyscolor)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwphyscolor)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpboption)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetRedrawAlways<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, boption: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), boption.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpmode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(mode)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMLine21Decoder {
    type Vtable = IAMLine21Decoder_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IAMLine21Decoder> for ::windows::runtime::IUnknown {
    fn from(value: IAMLine21Decoder) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMLine21Decoder> for ::windows::runtime::IUnknown {
    fn from(value: &IAMLine21Decoder) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMLine21Decoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMLine21Decoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLine21Decoder_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, service: AM_LINE21_CCSERVICE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: AM_LINE21_CCSTATE) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpbmih: *mut super::Gdi::BITMAPINFOHEADER) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpbmi: *mut super::Gdi::BITMAPINFO) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwphyscolor: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwphyscolor: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpboption: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, boption: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mode: AM_LINE21_DRAWBGMODE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMediaContent(pub ::windows::runtime::IUnknown);
impl IAMMediaContent {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn AuthorName(&self, pbstrauthorname: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrauthorname)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Title(&self, pbstrtitle: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrtitle)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Rating(&self, pbstrrating: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrrating)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Description(&self, pbstrdescription: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrdescription)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Copyright(&self, pbstrcopyright: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrcopyright)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn BaseURL(&self, pbstrbaseurl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrbaseurl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn LogoURL(&self, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrlogourl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn LogoIconURL(&self, pbstrlogourl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrlogourl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn WatermarkURL(&self, pbstrwatermarkurl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrwatermarkurl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MoreInfoURL(&self, pbstrmoreinfourl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrmoreinfourl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrmoreinfobannerimage)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrmoreinfobannerurl)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MoreInfoText(&self, pbstrmoreinfotext: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrmoreinfotext)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMediaContent {
    type Vtable = IAMMediaContent_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099764, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMMediaContent> for ::windows::runtime::IUnknown {
    fn from(value: IAMMediaContent) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMediaContent> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMediaContent) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMediaContent {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMediaContent {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMMediaContent> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMMediaContent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMMediaContent> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMMediaContent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMMediaContent {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMMediaContent {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContent_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrauthorname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrtitle: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrrating: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrdescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrcopyright: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrbaseurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrlogourl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrlogourl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrwatermarkurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrmoreinfourl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrmoreinfobannerimage: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrmoreinfobannerurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrmoreinfotext: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMediaContent2(pub ::windows::runtime::IUnknown);
impl IAMMediaContent2 {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaParameter<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, entrynum: i32, bstrname: Param1, pbstrvalue: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(entrynum), bstrname.into_param().abi(), ::std::mem::transmute(pbstrvalue)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(entrynum), ::std::mem::transmute(index), ::std::mem::transmute(pbstrname)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PlaylistCount(&self, pnumberentries: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pnumberentries)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMediaContent2 {
    type Vtable = IAMMediaContent2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3465509057, 29913, 4562, [176, 157, 0, 160, 201, 168, 17, 23]);
}
impl ::std::convert::From<IAMMediaContent2> for ::windows::runtime::IUnknown {
    fn from(value: IAMMediaContent2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMediaContent2> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMediaContent2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMediaContent2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMediaContent2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMMediaContent2> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMMediaContent2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMMediaContent2> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMMediaContent2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMMediaContent2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMMediaContent2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContent2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, entrynum: i32, bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>, pbstrvalue: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, entrynum: i32, index: i32, pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnumberentries: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMediaStream(pub ::windows::runtime::IUnknown);
impl IAMMediaStream {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows::runtime::Result<IMultiMediaStream> {
        let mut result__: <IMultiMediaStream as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IMultiMediaStream>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows::runtime::GUID, ptype: *mut STREAM_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppurposeid), ::std::mem::transmute(ptype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetSameFormat<'a, Param0: ::windows::runtime::IntoParam<'a, IMediaStream>>(&self, pstreamthathasdesiredformat: Param0, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pstreamthathasdesiredformat.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows::runtime::Result<IStreamSample> {
        let mut result__: <IStreamSample as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), &mut result__).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreateSharedSample<'a, Param0: ::windows::runtime::IntoParam<'a, IStreamSample>>(&self, pexistingsample: Param0, dwflags: u32) -> ::windows::runtime::Result<IStreamSample> {
        let mut result__: <IStreamSample as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pexistingsample.into_param().abi(), ::std::mem::transmute(dwflags), &mut result__).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Initialize<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, psourceobject: Param0, dwflags: u32, purposeid: *const ::windows::runtime::GUID, streamtype: STREAM_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), psourceobject.into_param().abi(), ::std::mem::transmute(dwflags), ::std::mem::transmute(purposeid), ::std::mem::transmute(streamtype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetState(&self, state: FILTER_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn JoinAMMultiMediaStream<'a, Param0: ::windows::runtime::IntoParam<'a, IAMMultiMediaStream>>(&self, pammultimediastream: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), pammultimediastream.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn JoinFilter<'a, Param0: ::windows::runtime::IntoParam<'a, IMediaStreamFilter>>(&self, pmediastreamfilter: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), pmediastreamfilter.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn JoinFilterGraph<'a, Param0: ::windows::runtime::IntoParam<'a, IFilterGraph>>(&self, pfiltergraph: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), pfiltergraph.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMediaStream {
    type Vtable = IAMMediaStream_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3200145757, 39535, 4560, [143, 222, 0, 192, 79, 217, 24, 157]);
}
impl ::std::convert::From<IAMMediaStream> for ::windows::runtime::IUnknown {
    fn from(value: IAMMediaStream) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMediaStream> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMediaStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMMediaStream> for IMediaStream {
    fn from(value: IAMMediaStream) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMMediaStream> for IMediaStream {
    fn from(value: &IAMMediaStream) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMediaStream> for IAMMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMediaStream> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMediaStream> for &IAMMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMediaStream> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaStream_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppmultimediastream: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppurposeid: *mut ::windows::runtime::GUID, ptype: *mut STREAM_TYPE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstreamthathasdesiredformat: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, ppsample: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pexistingsample: ::windows::runtime::RawPtr, dwflags: u32, ppnewsample: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psourceobject: ::windows::runtime::RawPtr, dwflags: u32, purposeid: *const ::windows::runtime::GUID, streamtype: STREAM_TYPE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: FILTER_STATE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pammultimediastream: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmediastreamfilter: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfiltergraph: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMediaTypeSample(pub ::windows::runtime::IUnknown);
impl IAMMediaTypeSample {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::std::option::Option<IMediaStream>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppmediastream)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pstarttime), ::std::mem::transmute(pendtime), ::std::mem::transmute(pcurrenttime)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pstarttime), ::std::mem::transmute(pendtime)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_SystemServices`*"]
    pub unsafe fn Update<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, dwflags: u32, hevent: Param1, pfnapc: ::std::option::Option<super::super::System::SystemServices::PAPCFUNC>, dwapcdata: usize) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), hevent.into_param().abi(), ::std::mem::transmute(pfnapc), ::std::mem::transmute(dwapcdata)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), ::std::mem::transmute(dwmilliseconds)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPointer(&self, pbuffer: *const u8, lsize: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbuffer), ::std::mem::transmute(lsize)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetPointer(&self) -> ::windows::runtime::Result<*mut u8> {
        let mut result__: <*mut u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut u8>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSize(&self) -> i32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptimestart), ::std::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptimestart), ::std::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsSyncPoint(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetSyncPoint<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bissyncpoint: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), bissyncpoint.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsPreroll(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetPreroll<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bispreroll: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), bispreroll.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(__midl__iammediatypesample0000)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetMediaType(&self) -> ::windows::runtime::Result<*mut AM_MEDIA_TYPE> {
        let mut result__: <*mut AM_MEDIA_TYPE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut AM_MEDIA_TYPE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMediaType(&self, pmediatype: *const AM_MEDIA_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(pmediatype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsDiscontinuity(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetDiscontinuity<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bdiscontinuity: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), bdiscontinuity.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptimestart), ::std::mem::transmute(ptimeend)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptimestart), ::std::mem::transmute(ptimeend)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMediaTypeSample {
    type Vtable = IAMMediaTypeSample_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2875935483, 63204, 4560, [144, 13, 0, 192, 79, 217, 24, 157]);
}
impl ::std::convert::From<IAMMediaTypeSample> for ::windows::runtime::IUnknown {
    fn from(value: IAMMediaTypeSample) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMediaTypeSample> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMediaTypeSample) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMediaTypeSample {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMediaTypeSample {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMMediaTypeSample> for IStreamSample {
    fn from(value: IAMMediaTypeSample) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMMediaTypeSample> for IStreamSample {
    fn from(value: &IAMMediaTypeSample) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IStreamSample> for IAMMediaTypeSample {
    fn into_param(self) -> ::windows::runtime::Param<'a, IStreamSample> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IStreamSample> for &IAMMediaTypeSample {
    fn into_param(self) -> ::windows::runtime::Param<'a, IStreamSample> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeSample_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppmediastream: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstarttime: *const i64, pendtime: *const i64) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, hevent: super::super::Foundation::HANDLE, pfnapc: ::windows::runtime::RawPtr, dwapcdata: usize) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, dwmilliseconds: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbuffer: *const u8, lsize: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppbuffer: *mut *mut u8) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> i32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bissyncpoint: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bispreroll: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> i32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, __midl__iammediatypesample0000: i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppmediatype: *mut *mut AM_MEDIA_TYPE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmediatype: *const ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bdiscontinuity: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimestart: *const i64, ptimeend: *const i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMediaTypeStream(pub ::windows::runtime::IUnknown);
impl IAMMediaTypeStream {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows::runtime::Result<IMultiMediaStream> {
        let mut result__: <IMultiMediaStream as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IMultiMediaStream>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows::runtime::GUID, ptype: *mut STREAM_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppurposeid), ::std::mem::transmute(ptype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetSameFormat<'a, Param0: ::windows::runtime::IntoParam<'a, IMediaStream>>(&self, pstreamthathasdesiredformat: Param0, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pstreamthathasdesiredformat.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows::runtime::Result<IStreamSample> {
        let mut result__: <IStreamSample as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), &mut result__).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreateSharedSample<'a, Param0: ::windows::runtime::IntoParam<'a, IStreamSample>>(&self, pexistingsample: Param0, dwflags: u32) -> ::windows::runtime::Result<IStreamSample> {
        let mut result__: <IStreamSample as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pexistingsample.into_param().abi(), ::std::mem::transmute(dwflags), &mut result__).from_abi::<IStreamSample>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetFormat(&self, pmediatype: *mut AM_MEDIA_TYPE, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pmediatype), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetFormat(&self, pmediatype: *const AM_MEDIA_TYPE, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pmediatype), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreateSample<'a, Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: Param3) -> ::windows::runtime::Result<IAMMediaTypeSample> {
        let mut result__: <IAMMediaTypeSample as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsamplesize), ::std::mem::transmute(pbbuffer), ::std::mem::transmute(dwflags), punkouter.into_param().abi(), &mut result__).from_abi::<IAMMediaTypeSample>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetStreamAllocatorRequirements(&self) -> ::windows::runtime::Result<ALLOCATOR_PROPERTIES> {
        let mut result__: <ALLOCATOR_PROPERTIES as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ALLOCATOR_PROPERTIES>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(pprops)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMediaTypeStream {
    type Vtable = IAMMediaTypeStream_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2875935482, 63204, 4560, [144, 13, 0, 192, 79, 217, 24, 157]);
}
impl ::std::convert::From<IAMMediaTypeStream> for ::windows::runtime::IUnknown {
    fn from(value: IAMMediaTypeStream) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMediaTypeStream> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMediaTypeStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMediaTypeStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMediaTypeStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMMediaTypeStream> for IMediaStream {
    fn from(value: IAMMediaTypeStream) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMMediaTypeStream> for IMediaStream {
    fn from(value: &IAMMediaTypeStream) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMediaStream> for IAMMediaTypeStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMediaStream> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMediaStream> for &IAMMediaTypeStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMediaStream> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeStream_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppmultimediastream: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppurposeid: *mut ::windows::runtime::GUID, ptype: *mut STREAM_TYPE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstreamthathasdesiredformat: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, ppsample: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pexistingsample: ::windows::runtime::RawPtr, dwflags: u32, ppnewsample: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmediatype: *mut ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmediatype: *const ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: ::windows::runtime::RawPtr, ppammediatypesample: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pprops: *mut ALLOCATOR_PROPERTIES) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMMultiMediaStream(pub ::windows::runtime::IUnknown);
impl IAMMultiMediaStream {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwflags), ::std::mem::transmute(pstreamtype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<IMediaStream> {
        let mut result__: <IMediaStream as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(idpurpose), &mut result__).from_abi::<IMediaStream>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows::runtime::Result<IMediaStream> {
        let mut result__: <IMediaStream as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(index), &mut result__).from_abi::<IMediaStream>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetState(&self) -> ::windows::runtime::Result<STREAM_STATE> {
        let mut result__: <STREAM_STATE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<STREAM_STATE>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(newstate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTime(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDuration(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(seektime)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Initialize<'a, Param2: ::windows::runtime::IntoParam<'a, IGraphBuilder>>(&self, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: Param2) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(streamtype), ::std::mem::transmute(dwflags), pfiltergraph.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetFilterGraph(&self) -> ::windows::runtime::Result<IGraphBuilder> {
        let mut result__: <IGraphBuilder as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IGraphBuilder>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetFilter(&self) -> ::windows::runtime::Result<IMediaStreamFilter> {
        let mut result__: <IMediaStreamFilter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IMediaStreamFilter>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AddMediaStream<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, pstreamobject: Param0, purposeid: *const ::windows::runtime::GUID, dwflags: AMMSF_MS_FLAGS) -> ::windows::runtime::Result<IMediaStream> {
        let mut result__: <IMediaStream as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), pstreamobject.into_param().abi(), ::std::mem::transmute(purposeid), ::std::mem::transmute(dwflags), &mut result__).from_abi::<IMediaStream>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn OpenFile<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszfilename: Param0, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), pszfilename.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Com`*"]
    pub unsafe fn OpenMoniker<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>, Param1: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>>(&self, pctx: Param0, pmoniker: Param1, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), pctx.into_param().abi(), pmoniker.into_param().abi(), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Render(&self, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMMultiMediaStream {
    type Vtable = IAMMultiMediaStream_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3200145756, 39535, 4560, [143, 222, 0, 192, 79, 217, 24, 157]);
}
impl ::std::convert::From<IAMMultiMediaStream> for ::windows::runtime::IUnknown {
    fn from(value: IAMMultiMediaStream) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMMultiMediaStream> for ::windows::runtime::IUnknown {
    fn from(value: &IAMMultiMediaStream) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMMultiMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMMultiMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMMultiMediaStream> for IMultiMediaStream {
    fn from(value: IAMMultiMediaStream) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMMultiMediaStream> for IMultiMediaStream {
    fn from(value: &IAMMultiMediaStream) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiMediaStream> for IAMMultiMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiMediaStream> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiMediaStream> for &IAMMultiMediaStream {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiMediaStream> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMultiMediaStream_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, idpurpose: *const ::windows::runtime::GUID, ppmediastream: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, index: i32, ppmediastream: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcurrentstate: *mut STREAM_STATE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newstate: STREAM_STATE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcurrenttime: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pduration: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, seektime: i64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheos: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppgraphbuilder: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppfilter: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstreamobject: ::windows::runtime::RawPtr, purposeid: *const ::windows::runtime::GUID, dwflags: AMMSF_MS_FLAGS, ppnewstream: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszfilename: super::super::Foundation::PWSTR, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctx: ::windows::runtime::RawPtr, pmoniker: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMNetShowConfig(pub ::windows::runtime::IUnknown);
impl IAMNetShowConfig {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn BufferingTime(&self, pbufferingtime: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbufferingtime)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetBufferingTime(&self, bufferingtime: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(bufferingtime)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UseFixedUDPPort(&self, pusefixedudpport: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pusefixedudpport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetUseFixedUDPPort(&self, usefixedudpport: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(usefixedudpport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pfixedudpport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetFixedUDPPort(&self, fixedudpport: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(fixedudpport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UseHTTPProxy(&self, pusehttpproxy: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(pusehttpproxy)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetUseHTTPProxy(&self, usehttpproxy: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(usehttpproxy)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnableAutoProxy(&self, penableautoproxy: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(penableautoproxy)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEnableAutoProxy(&self, enableautoproxy: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(enableautoproxy)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrhttpproxyhost)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetHTTPProxyHost<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrhttpproxyhost: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), bstrhttpproxyhost.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(phttpproxyport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetHTTPProxyPort(&self, httpproxyport: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(httpproxyport)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnableMulticast(&self, penablemulticast: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), ::std::mem::transmute(penablemulticast)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEnableMulticast(&self, enablemulticast: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(enablemulticast)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnableUDP(&self, penableudp: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(penableudp)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEnableUDP(&self, enableudp: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(enableudp)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnableTCP(&self, penabletcp: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(penabletcp)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEnableTCP(&self, enabletcp: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), ::std::mem::transmute(enabletcp)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EnableHTTP(&self, penablehttp: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(penablehttp)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetEnableHTTP(&self, enablehttp: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(enablehttp)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMNetShowConfig {
    type Vtable = IAMNetShowConfig_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099761, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMNetShowConfig> for ::windows::runtime::IUnknown {
    fn from(value: IAMNetShowConfig) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMNetShowConfig> for ::windows::runtime::IUnknown {
    fn from(value: &IAMNetShowConfig) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMNetShowConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMNetShowConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMNetShowConfig> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMNetShowConfig) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMNetShowConfig> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMNetShowConfig) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMNetShowConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMNetShowConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowConfig_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbufferingtime: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bufferingtime: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pusefixedudpport: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, usefixedudpport: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfixedudpport: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fixedudpport: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pusehttpproxy: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, usehttpproxy: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penableautoproxy: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enableautoproxy: i16) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrhttpproxyhost: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bstrhttpproxyhost: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, phttpproxyport: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, httpproxyport: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penablemulticast: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enablemulticast: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penableudp: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enableudp: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penabletcp: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enabletcp: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, penablehttp: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enablehttp: i16) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMNetShowExProps(pub ::windows::runtime::IUnknown);
impl IAMNetShowExProps {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SourceProtocol(&self, psourceprotocol: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(psourceprotocol)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Bandwidth(&self, pbandwidth: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbandwidth)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ErrorCorrection(&self, pbstrerrorcorrection: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrerrorcorrection)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CodecCount(&self, pcodeccount: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pcodeccount)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(codecnum), ::std::mem::transmute(pcodecinstalled)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(codecnum), ::std::mem::transmute(pbstrcodecdescription)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(codecnum), ::std::mem::transmute(pbstrcodecurl)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreationDate(&self, pcreationdate: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pcreationdate)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SourceLink(&self, pbstrsourcelink: *mut super::super::Foundation::BSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbstrsourcelink)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMNetShowExProps {
    type Vtable = IAMNetShowExProps_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099765, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMNetShowExProps> for ::windows::runtime::IUnknown {
    fn from(value: IAMNetShowExProps) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMNetShowExProps> for ::windows::runtime::IUnknown {
    fn from(value: &IAMNetShowExProps) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMNetShowExProps {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMNetShowExProps {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMNetShowExProps> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMNetShowExProps) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMNetShowExProps> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMNetShowExProps) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMNetShowExProps {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMNetShowExProps {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowExProps_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psourceprotocol: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbandwidth: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrerrorcorrection: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcodeccount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, codecnum: i32, pcodecinstalled: *mut i16) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, codecnum: i32, pbstrcodecdescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, codecnum: i32, pbstrcodecurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcreationdate: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrsourcelink: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMNetShowPreroll(pub ::windows::runtime::IUnknown);
impl IAMNetShowPreroll {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPreroll(&self, fpreroll: i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(fpreroll)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Preroll(&self, pfpreroll: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pfpreroll)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMNetShowPreroll {
    type Vtable = IAMNetShowPreroll_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2867324130, 25480, 4561, [141, 147, 0, 96, 151, 201, 162, 178]);
}
impl ::std::convert::From<IAMNetShowPreroll> for ::windows::runtime::IUnknown {
    fn from(value: IAMNetShowPreroll) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMNetShowPreroll> for ::windows::runtime::IUnknown {
    fn from(value: &IAMNetShowPreroll) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMNetShowPreroll {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMNetShowPreroll {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMNetShowPreroll> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMNetShowPreroll) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMNetShowPreroll> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMNetShowPreroll) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMNetShowPreroll {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMNetShowPreroll {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowPreroll_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fpreroll: i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfpreroll: *mut i16) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMNetworkStatus(pub ::windows::runtime::IUnknown);
impl IAMNetworkStatus {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(preceivedpackets)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(precoveredpackets)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn LostPackets(&self, plostpackets: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(plostpackets)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ReceptionQuality(&self, preceptionquality: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(preceptionquality)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn BufferingCount(&self, pbufferingcount: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbufferingcount)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsBroadcast(&self, pisbroadcast: *mut i16) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(pisbroadcast)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbufferingprogress)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMNetworkStatus {
    type Vtable = IAMNetworkStatus_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4197099763, 35682, 4560, [165, 32, 0, 0, 0, 0, 0, 0]);
}
impl ::std::convert::From<IAMNetworkStatus> for ::windows::runtime::IUnknown {
    fn from(value: IAMNetworkStatus) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMNetworkStatus> for ::windows::runtime::IUnknown {
    fn from(value: &IAMNetworkStatus) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMNetworkStatus {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMNetworkStatus {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMNetworkStatus> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMNetworkStatus) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMNetworkStatus> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMNetworkStatus) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMNetworkStatus {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMNetworkStatus {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetworkStatus_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, preceivedpackets: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, precoveredpackets: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plostpackets: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, preceptionquality: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbufferingcount: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pisbroadcast: *mut i16) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbufferingprogress: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMOpenProgress(pub ::windows::runtime::IUnknown);
impl IAMOpenProgress {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(plltotal), ::std::mem::transmute(pllcurrent)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AbortOperation(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMOpenProgress {
    type Vtable = IAMOpenProgress_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2384214433, 56915, 4559, [170, 99, 0, 128, 199, 68, 82, 141]);
}
impl ::std::convert::From<IAMOpenProgress> for ::windows::runtime::IUnknown {
    fn from(value: IAMOpenProgress) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMOpenProgress> for ::windows::runtime::IUnknown {
    fn from(value: &IAMOpenProgress) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMOpenProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMOpenProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOpenProgress_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMOverlayFX(pub ::windows::runtime::IUnknown);
impl IAMOverlayFX {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn QueryOverlayFXCaps(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOverlayFX(&self, dwoverlayfx: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwoverlayfx)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetOverlayFX(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMOverlayFX {
    type Vtable = IAMOverlayFX_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1660609104, 32357, 17504, [191, 201, 99, 152, 179, 34, 7, 60]);
}
impl ::std::convert::From<IAMOverlayFX> for ::windows::runtime::IUnknown {
    fn from(value: IAMOverlayFX) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMOverlayFX> for ::windows::runtime::IUnknown {
    fn from(value: &IAMOverlayFX) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMOverlayFX {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMOverlayFX {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOverlayFX_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpdwoverlayfxcaps: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwoverlayfx: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpdwoverlayfx: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMParse(pub ::windows::runtime::IUnknown);
impl IAMParse {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetParseTime(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetParseTime(&self, rtcurrent: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(rtcurrent)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Flush(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMParse {
    type Vtable = IAMParse_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3296343072, 92, 4562, [144, 56, 0, 160, 201, 105, 114, 152]);
}
impl ::std::convert::From<IAMParse> for ::windows::runtime::IUnknown {
    fn from(value: IAMParse) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMParse> for ::windows::runtime::IUnknown {
    fn from(value: &IAMParse) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMParse {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMParse {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMParse_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prtcurrent: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rtcurrent: i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMPhysicalPinInfo(pub ::windows::runtime::IUnknown);
impl IAMPhysicalPinInfo {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptype), ::std::mem::transmute(ppsztype)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMPhysicalPinInfo {
    type Vtable = IAMPhysicalPinInfo_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4181248401, 12329, 4559, [140, 68, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMPhysicalPinInfo> for ::windows::runtime::IUnknown {
    fn from(value: IAMPhysicalPinInfo) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMPhysicalPinInfo> for ::windows::runtime::IUnknown {
    fn from(value: &IAMPhysicalPinInfo) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMPhysicalPinInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMPhysicalPinInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPhysicalPinInfo_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptype: *mut i32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMPlayList(pub ::windows::runtime::IUnknown);
impl IAMPlayList {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetItemCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetItem(&self, dwitemindex: u32) -> ::windows::runtime::Result<IAMPlayListItem> {
        let mut result__: <IAMPlayListItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwitemindex), &mut result__).from_abi::<IAMPlayListItem>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetNamedEvent<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pwszeventname: Param0, dwitemindex: u32, ppitem: *mut ::std::option::Option<IAMPlayListItem>, pdwflags: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), pwszeventname.into_param().abi(), ::std::mem::transmute(dwitemindex), ::std::mem::transmute(ppitem), ::std::mem::transmute(pdwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwrepeatcount), ::std::mem::transmute(pdwrepeatstart), ::std::mem::transmute(pdwrepeatend)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMPlayList {
    type Vtable = IAMPlayList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1453877502, 2772, 4558, [176, 58, 0, 32, 175, 11, 167, 112]);
}
impl ::std::convert::From<IAMPlayList> for ::windows::runtime::IUnknown {
    fn from(value: IAMPlayList) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMPlayList> for ::windows::runtime::IUnknown {
    fn from(value: &IAMPlayList) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMPlayList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMPlayList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayList_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwflags: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwitems: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwitemindex: u32, ppitem: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwszeventname: super::super::Foundation::PWSTR, dwitemindex: u32, ppitem: *mut ::windows::runtime::RawPtr, pdwflags: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMPlayListItem(pub ::windows::runtime::IUnknown);
impl IAMPlayListItem {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSourceCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetSourceURL(&self, dwsourceindex: u32) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSourceStart(&self, dwsourceindex: u32) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSourceDuration(&self, dwsourceindex: u32) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSourceStartMarker(&self, dwsourceindex: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetSourceEndMarker(&self, dwsourceindex: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetLinkURL(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetScanDuration(&self, dwsourceindex: u32) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsourceindex), &mut result__).from_abi::<i64>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMPlayListItem {
    type Vtable = IAMPlayListItem_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1453877503, 2772, 4558, [176, 58, 0, 32, 175, 11, 167, 112]);
}
impl ::std::convert::From<IAMPlayListItem> for ::windows::runtime::IUnknown {
    fn from(value: IAMPlayListItem) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMPlayListItem> for ::windows::runtime::IUnknown {
    fn from(value: &IAMPlayListItem) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMPlayListItem {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMPlayListItem {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayListItem_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwflags: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwsources: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, pbstrurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, prtstart: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, prtduration: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, pbstrstartmarker: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, pbstrendmarker: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbstrurl: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsourceindex: u32, prtscanduration: *mut i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMPluginControl(pub ::windows::runtime::IUnknown);
impl IAMPluginControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetPreferredClsid(&self, subtype: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(subtype), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut ::windows::runtime::GUID, clsid: *mut ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(index), ::std::mem::transmute(subtype), ::std::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPreferredClsid(&self, subtype: *const ::windows::runtime::GUID, clsid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(subtype), ::std::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn IsDisabled(&self, clsid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(clsid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDisabledByIndex(&self, index: u32) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(index), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetDisabled<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, clsid: *const ::windows::runtime::GUID, disabled: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(clsid), disabled.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn IsLegacyDisabled<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, dllname: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), dllname.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMPluginControl {
    type Vtable = IAMPluginControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(237412737, 62476, 17973, [135, 134, 151, 98, 132, 181, 41, 129]);
}
impl ::std::convert::From<IAMPluginControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMPluginControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMPluginControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMPluginControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMPluginControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMPluginControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPluginControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, subtype: *const ::windows::runtime::GUID, clsid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, index: u32, subtype: *mut ::windows::runtime::GUID, clsid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, subtype: *const ::windows::runtime::GUID, clsid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, clsid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, index: u32, clsid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, clsid: *const ::windows::runtime::GUID, disabled: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dllname: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMPushSource(pub ::windows::runtime::IUnknown);
impl IAMPushSource {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetLatency(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetPushSourceFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPushSourceFlags(&self, flags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetStreamOffset(&self, rtoffset: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(rtoffset)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetStreamOffset(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMaxStreamOffset(&self) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(rtmaxoffset)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMPushSource {
    type Vtable = IAMPushSource_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4052090486, 58958, 4562, [183, 110, 0, 192, 79, 182, 189, 61]);
}
impl ::std::convert::From<IAMPushSource> for ::windows::runtime::IUnknown {
    fn from(value: IAMPushSource) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMPushSource> for ::windows::runtime::IUnknown {
    fn from(value: &IAMPushSource) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMPushSource {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMPushSource {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMPushSource> for IAMLatency {
    fn from(value: IAMPushSource) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMPushSource> for IAMLatency {
    fn from(value: &IAMPushSource) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAMLatency> for IAMPushSource {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAMLatency> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAMLatency> for &IAMPushSource {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAMLatency> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPushSource_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prtlatency: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pflags: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rtoffset: i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prtoffset: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, prtmaxoffset: *mut i64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rtmaxoffset: i64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMRebuild(pub ::windows::runtime::IUnknown);
impl IAMRebuild {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn RebuildNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMRebuild {
    type Vtable = IAMRebuild_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(49218781, 30080, 4561, [190, 206, 0, 192, 79, 182, 233, 55]);
}
impl ::std::convert::From<IAMRebuild> for ::windows::runtime::IUnknown {
    fn from(value: IAMRebuild) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMRebuild> for ::windows::runtime::IUnknown {
    fn from(value: &IAMRebuild) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMRebuild {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMRebuild {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMRebuild_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMResourceControl(pub ::windows::runtime::IUnknown);
impl IAMResourceControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Reserve(&self, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), ::std::mem::transmute(pvreserved)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMResourceControl {
    type Vtable = IAMResourceControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2206847696, 30679, 4561, [171, 230, 0, 160, 201, 5, 243, 117]);
}
impl ::std::convert::From<IAMResourceControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMResourceControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMResourceControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMResourceControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMResourceControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMResourceControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMResourceControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, pvreserved: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMStats(pub ::windows::runtime::IUnknown);
impl IAMStats {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetValueByIndex(&self, lindex: i32, szname: *mut super::super::Foundation::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), ::std::mem::transmute(szname), ::std::mem::transmute(lcount), ::std::mem::transmute(dlast), ::std::mem::transmute(daverage), ::std::mem::transmute(dstddev), ::std::mem::transmute(dmin), ::std::mem::transmute(dmax)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetValueByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, szname: Param0, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), szname.into_param().abi(), ::std::mem::transmute(lindex), ::std::mem::transmute(lcount), ::std::mem::transmute(dlast), ::std::mem::transmute(daverage), ::std::mem::transmute(dstddev), ::std::mem::transmute(dmin), ::std::mem::transmute(dmax)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIndex<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, szname: Param0, lcreate: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), szname.into_param().abi(), ::std::mem::transmute(lcreate), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AddValue(&self, lindex: i32, dvalue: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), ::std::mem::transmute(dvalue)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMStats {
    type Vtable = IAMStats_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3164327808, 56530, 4562, [171, 246, 0, 160, 201, 5, 243, 117]);
}
impl ::std::convert::From<IAMStats> for ::windows::runtime::IUnknown {
    fn from(value: IAMStats) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMStats> for ::windows::runtime::IUnknown {
    fn from(value: &IAMStats) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IAMStats> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IAMStats) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IAMStats> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IAMStats) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IAMStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IAMStats {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStats_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plcount: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, szname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, szname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, szname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>, lcreate: i32, plindex: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, dvalue: f64) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMStreamConfig(pub ::windows::runtime::IUnknown);
impl IAMStreamConfig {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetFormat(&self, pmt: *mut AM_MEDIA_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pmt)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetFormat(&self) -> ::windows::runtime::Result<*mut AM_MEDIA_TYPE> {
        let mut result__: <*mut AM_MEDIA_TYPE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<*mut AM_MEDIA_TYPE>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(picount), ::std::mem::transmute(pisize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(iindex), ::std::mem::transmute(ppmt), ::std::mem::transmute(pscc)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMStreamConfig {
    type Vtable = IAMStreamConfig_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647488, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMStreamConfig> for ::windows::runtime::IUnknown {
    fn from(value: IAMStreamConfig) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMStreamConfig> for ::windows::runtime::IUnknown {
    fn from(value: &IAMStreamConfig) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMStreamConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMStreamConfig {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamConfig_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pmt: *mut ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppmt: *mut *mut AM_MEDIA_TYPE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, picount: *mut i32, pisize: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMStreamControl(pub ::windows::runtime::IUnknown);
impl IAMStreamControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn StartAt(&self, ptstart: *const i64, dwcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptstart), ::std::mem::transmute(dwcookie)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn StopAt<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, ptstop: *const i64, bsendextra: Param1, dwcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptstop), bsendextra.into_param().abi(), ::std::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetInfo(&self) -> ::windows::runtime::Result<AM_STREAM_INFO> {
        let mut result__: <AM_STREAM_INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AM_STREAM_INFO>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMStreamControl {
    type Vtable = IAMStreamControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(917977217, 49864, 4559, [139, 70, 0, 128, 95, 108, 239, 96]);
}
impl ::std::convert::From<IAMStreamControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMStreamControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMStreamControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMStreamControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMStreamControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMStreamControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptstart: *const i64, dwcookie: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptstop: *const i64, bsendextra: super::super::Foundation::BOOL, dwcookie: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pinfo: *mut AM_STREAM_INFO) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMStreamSelect(pub ::windows::runtime::IUnknown);
impl IAMStreamSelect {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Info(&self, lindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut super::super::Foundation::PWSTR, ppobject: *mut ::std::option::Option<::windows::runtime::IUnknown>, ppunk: *mut ::std::option::Option<::windows::runtime::IUnknown>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), ::std::mem::transmute(ppmt), ::std::mem::transmute(pdwflags), ::std::mem::transmute(plcid), ::std::mem::transmute(pdwgroup), ::std::mem::transmute(ppszname), ::std::mem::transmute(ppobject), ::std::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Enable(&self, lindex: i32, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), ::std::mem::transmute(dwflags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMStreamSelect {
    type Vtable = IAMStreamSelect_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3247835488, 6133, 4561, [171, 225, 0, 160, 201, 5, 243, 117]);
}
impl ::std::convert::From<IAMStreamSelect> for ::windows::runtime::IUnknown {
    fn from(value: IAMStreamSelect) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMStreamSelect> for ::windows::runtime::IUnknown {
    fn from(value: &IAMStreamSelect) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMStreamSelect {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMStreamSelect {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamSelect_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pcstreams: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, ppmt: *mut *mut AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut super::super::Foundation::PWSTR, ppobject: *mut ::windows::runtime::RawPtr, ppunk: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, dwflags: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTVAudio(pub ::windows::runtime::IUnknown);
impl IAMTVAudio {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetHardwareSupportedTVAudioModes(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetAvailableTVAudioModes(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TVAudioMode(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTVAudioMode(&self, lmode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), pnotify.into_param().abi(), ::std::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMTVAudio {
    type Vtable = IAMTVAudio_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2213289008, 9169, 4561, [153, 230, 0, 160, 201, 86, 2, 102]);
}
impl ::std::convert::From<IAMTVAudio> for ::windows::runtime::IUnknown {
    fn from(value: IAMTVAudio) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTVAudio> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTVAudio) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTVAudio {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTVAudio {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudio_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmodes: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmodes: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lmode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr, levents: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTVAudioNotification(pub ::windows::runtime::IUnknown);
impl IAMTVAudioNotification {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OnEvent(&self, event: AMTVAudioEventType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(event)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMTVAudioNotification {
    type Vtable = IAMTVAudioNotification_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2213289011, 9169, 4561, [153, 230, 0, 160, 201, 86, 2, 102]);
}
impl ::std::convert::From<IAMTVAudioNotification> for ::windows::runtime::IUnknown {
    fn from(value: IAMTVAudioNotification) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTVAudioNotification> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTVAudioNotification) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTVAudioNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTVAudioNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudioNotification_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, event: AMTVAudioEventType) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTVTuner(pub ::windows::runtime::IUnknown);
impl IAMTVTuner {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetChannel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(lchannel), ::std::mem::transmute(lvideosubchannel), ::std::mem::transmute(laudiosubchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(plchannel), ::std::mem::transmute(plvideosubchannel), ::std::mem::transmute(plaudiosubchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(lchannelmin), ::std::mem::transmute(lchannelmax)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lcountrycode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CountryCode(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(ltuningspace)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Logon<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hcurrentuser: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), hcurrentuser.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Logout(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SignalPresent(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Mode(&self) -> ::windows::runtime::Result<AMTunerModeType> {
        let mut result__: <AMTunerModeType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AMTunerModeType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetAvailableModes(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), pnotify.into_param().abi(), ::std::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AvailableTVFormats(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TVFormat(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AutoTune(&self, lchannel: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(lchannel), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn StoreAutoTune(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn NumInputConnections(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInputType(&self, lindex: i32, inputtype: TunerInputType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), ::std::mem::transmute(inputtype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InputType(&self, lindex: i32) -> ::windows::runtime::Result<TunerInputType> {
        let mut result__: <TunerInputType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex), &mut result__).from_abi::<TunerInputType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetConnectInput(&self, lindex: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(lindex)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ConnectInput(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn VideoFrequency(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn AudioFrequency(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMTVTuner {
    type Vtable = IAMTVTuner_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(555386726, 940, 4561, [141, 19, 0, 170, 0, 189, 131, 57]);
}
impl ::std::convert::From<IAMTVTuner> for ::windows::runtime::IUnknown {
    fn from(value: IAMTVTuner) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTVTuner> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTVTuner) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTVTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTVTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IAMTVTuner> for IAMTuner {
    fn from(value: IAMTVTuner) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAMTVTuner> for IAMTuner {
    fn from(value: &IAMTVTuner) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAMTuner> for IAMTVTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAMTuner> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAMTuner> for &IAMTVTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAMTuner> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVTuner_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lcountrycode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plcountrycode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ltuningspace: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pltuningspace: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hcurrentuser: super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plsignalstrength: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lmode: AMTunerModeType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmode: *mut AMTunerModeType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmodes: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr, levents: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lanalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, planalogvideostandard: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lchannel: i32, plfoundsignal: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plnuminputconnections: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, inputtype: TunerInputType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32, pinputtype: *mut TunerInputType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lindex: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plindex: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lfreq: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lfreq: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTimecodeDisplay(pub ::windows::runtime::IUnknown);
impl IAMTimecodeDisplay {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTCDisplayEnable(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTCDisplayEnable(&self, state: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTCDisplay(&self, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTCDisplay(&self, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMTimecodeDisplay {
    type Vtable = IAMTimecodeDisplay_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2605280482, 33051, 4559, [140, 119, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMTimecodeDisplay> for ::windows::runtime::IUnknown {
    fn from(value: IAMTimecodeDisplay) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTimecodeDisplay> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTimecodeDisplay) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTimecodeDisplay {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTimecodeDisplay {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeDisplay_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTimecodeGenerator(pub ::windows::runtime::IUnknown);
impl IAMTimecodeGenerator {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTCGMode(&self, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTCGMode(&self, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(line)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn VITCLine(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTimecode(&self, ptimecodesample: *mut TIMECODE_SAMPLE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(ptimecodesample)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTimecode(&self) -> ::windows::runtime::Result<TIMECODE_SAMPLE> {
        let mut result__: <TIMECODE_SAMPLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<TIMECODE_SAMPLE>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMTimecodeGenerator {
    type Vtable = IAMTimecodeGenerator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2605280480, 33051, 4559, [140, 119, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMTimecodeGenerator> for ::windows::runtime::IUnknown {
    fn from(value: IAMTimecodeGenerator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTimecodeGenerator> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTimecodeGenerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTimecodeGenerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTimecodeGenerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeGenerator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, line: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pline: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimecodesample: *mut TIMECODE_SAMPLE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimecodesample: *mut TIMECODE_SAMPLE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTimecodeReader(pub ::windows::runtime::IUnknown);
impl IAMTimecodeReader {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTCRMode(&self, param: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTCRMode(&self, param: i32, value: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(param), ::std::mem::transmute(value)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(line)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn VITCLine(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTimecode(&self) -> ::windows::runtime::Result<TIMECODE_SAMPLE> {
        let mut result__: <TIMECODE_SAMPLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<TIMECODE_SAMPLE>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAMTimecodeReader {
    type Vtable = IAMTimecodeReader_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2605280481, 33051, 4559, [140, 119, 0, 170, 0, 107, 104, 20]);
}
impl ::std::convert::From<IAMTimecodeReader> for ::windows::runtime::IUnknown {
    fn from(value: IAMTimecodeReader) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTimecodeReader> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTimecodeReader) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTimecodeReader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTimecodeReader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeReader_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, pvalue: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, param: i32, value: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, line: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pline: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptimecodesample: *mut TIMECODE_SAMPLE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTuner(pub ::windows::runtime::IUnknown);
impl IAMTuner {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetChannel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(lchannel), ::std::mem::transmute(lvideosubchannel), ::std::mem::transmute(laudiosubchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(plchannel), ::std::mem::transmute(plvideosubchannel), ::std::mem::transmute(plaudiosubchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(lchannelmin), ::std::mem::transmute(lchannelmax)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lcountrycode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CountryCode(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(ltuningspace)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn Logon<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, hcurrentuser: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), hcurrentuser.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Logout(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SignalPresent(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(lmode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Mode(&self) -> ::windows::runtime::Result<AMTunerModeType> {
        let mut result__: <AMTunerModeType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AMTunerModeType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetAvailableModes(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn RegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0, levents: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), pnotify.into_param().abi(), ::std::mem::transmute(levents)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn UnRegisterNotificationCallBack<'a, Param0: ::windows::runtime::IntoParam<'a, IAMTunerNotification>>(&self, pnotify: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), pnotify.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMTuner {
    type Vtable = IAMTuner_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(555386721, 940, 4561, [141, 19, 0, 170, 0, 189, 131, 57]);
}
impl ::std::convert::From<IAMTuner> for ::windows::runtime::IUnknown {
    fn from(value: IAMTuner) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTuner> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTuner) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTuner {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTuner_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lcountrycode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plcountrycode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ltuningspace: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pltuningspace: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hcurrentuser: super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plsignalstrength: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lmode: AMTunerModeType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmode: *mut AMTunerModeType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plmodes: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr, levents: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnotify: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMTunerNotification(pub ::windows::runtime::IUnknown);
impl IAMTunerNotification {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OnEvent(&self, event: AMTunerEventType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(event)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMTunerNotification {
    type Vtable = IAMTunerNotification_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(555386720, 940, 4561, [141, 19, 0, 170, 0, 189, 131, 57]);
}
impl ::std::convert::From<IAMTunerNotification> for ::windows::runtime::IUnknown {
    fn from(value: IAMTunerNotification) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMTunerNotification> for ::windows::runtime::IUnknown {
    fn from(value: &IAMTunerNotification) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMTunerNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMTunerNotification {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTunerNotification_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, event: AMTunerEventType) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVfwCaptureDialogs(pub ::windows::runtime::IUnknown);
impl IAMVfwCaptureDialogs {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn HasDialog(&self, idialog: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(idialog)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ShowDialog<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>>(&self, idialog: i32, hwnd: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(idialog), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(idialog), ::std::mem::transmute(umsg), ::std::mem::transmute(dw1), ::std::mem::transmute(dw2)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVfwCaptureDialogs {
    type Vtable = IAMVfwCaptureDialogs_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3637974432, 28254, 4560, [179, 240, 0, 170, 0, 55, 97, 197]);
}
impl ::std::convert::From<IAMVfwCaptureDialogs> for ::windows::runtime::IUnknown {
    fn from(value: IAMVfwCaptureDialogs) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVfwCaptureDialogs> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVfwCaptureDialogs) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVfwCaptureDialogs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVfwCaptureDialogs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCaptureDialogs_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, idialog: i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVfwCompressDialogs(pub ::windows::runtime::IUnknown);
impl IAMVfwCompressDialogs {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn ShowDialog<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>>(&self, idialog: i32, hwnd: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(idialog), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetState(&self, pstate: *mut ::std::ffi::c_void, pcbstate: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pstate), ::std::mem::transmute(pcbstate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetState(&self, pstate: *const ::std::ffi::c_void, cbstate: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pstate), ::std::mem::transmute(cbstate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(umsg), ::std::mem::transmute(dw1), ::std::mem::transmute(dw2)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVfwCompressDialogs {
    type Vtable = IAMVfwCompressDialogs_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3637974435, 28254, 4560, [179, 240, 0, 170, 0, 55, 97, 197]);
}
impl ::std::convert::From<IAMVfwCompressDialogs> for ::windows::runtime::IUnknown {
    fn from(value: IAMVfwCompressDialogs) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVfwCompressDialogs> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVfwCompressDialogs) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVfwCompressDialogs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVfwCompressDialogs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCompressDialogs_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstate: *mut ::std::ffi::c_void, pcbstate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pstate: *const ::std::ffi::c_void, cbstate: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, umsg: i32, dw1: i32, dw2: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoAccelerator(pub ::windows::runtime::IUnknown);
impl IAMVideoAccelerator {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: *mut ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwnumguidssupported), ::std::mem::transmute(pguidssupported)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
    pub unsafe fn GetUncompFormatsSupported(&self, pguid: *const ::windows::runtime::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::DirectDraw::DDPIXELFORMAT) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguid), ::std::mem::transmute(pdwnumformatssupported), ::std::mem::transmute(pformatssupported)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
    pub unsafe fn GetInternalMemInfo(&self, pguid: *const ::windows::runtime::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguid), ::std::mem::transmute(pamvauncompdatainfo), ::std::mem::transmute(pamvainternalmeminfo)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
    pub unsafe fn GetCompBufferInfo(&self, pguid: *const ::windows::runtime::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguid), ::std::mem::transmute(pamvauncompdatainfo), ::std::mem::transmute(pdwnumtypescompbuffers), ::std::mem::transmute(pamvacompbufferinfo)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
    pub unsafe fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwnumtypescompbuffers), ::std::mem::transmute(pamvacompbufferinfo)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(amvabeginframeinfo)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pendframeinfo)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetBuffer<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: Param2, ppbuffer: *mut *mut ::std::ffi::c_void, lpstride: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwtypeindex), ::std::mem::transmute(dwbufferindex), breadonly.into_param().abi(), ::std::mem::transmute(ppbuffer), ::std::mem::transmute(lpstride)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwtypeindex), ::std::mem::transmute(dwbufferindex)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const ::std::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::std::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfunction),
            ::std::mem::transmute(lpprivateinputdata),
            ::std::mem::transmute(cbprivateinputdata),
            ::std::mem::transmute(lpprivateoutputdat),
            ::std::mem::transmute(cbprivateoutputdata),
            ::std::mem::transmute(dwnumbuffers),
            ::std::mem::transmute(pamvabufferinfo),
        )
        .ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwtypeindex), ::std::mem::transmute(dwbufferindex), ::std::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn DisplayFrame<'a, Param1: ::windows::runtime::IntoParam<'a, IMediaSample>>(&self, dwfliptoindex: u32, pmediasample: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwfliptoindex), pmediasample.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoAccelerator {
    type Vtable = IAMVideoAccelerator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(627730978, 64429, 4561, [130, 191, 0, 160, 201, 105, 108, 143]);
}
impl ::std::convert::From<IAMVideoAccelerator> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoAccelerator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoAccelerator> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoAccelerator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoAccelerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoAccelerator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAccelerator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwnumguidssupported: *mut u32, pguidssupported: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguid: *const ::windows::runtime::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::DirectDraw::DDPIXELFORMAT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguid: *const ::windows::runtime::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguid: *const ::windows::runtime::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwtypeindex: u32, dwbufferindex: u32, breadonly: super::super::Foundation::BOOL, ppbuffer: *mut *mut ::std::ffi::c_void, lpstride: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwtypeindex: u32, dwbufferindex: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwfunction: u32, lpprivateinputdata: *const ::std::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::std::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwfliptoindex: u32, pmediasample: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoAcceleratorNotify(pub ::windows::runtime::IUnknown);
impl IAMVideoAcceleratorNotify {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_DirectDraw`*"]
    pub unsafe fn GetUncompSurfacesInfo(&self, pguid: *const ::windows::runtime::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguid), ::std::mem::transmute(puncompbufferinfo)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwactualuncompsurfacesallocated)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCreateVideoAcceleratorData(&self, pguid: *const ::windows::runtime::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pguid), ::std::mem::transmute(pdwsizemiscdata), ::std::mem::transmute(ppmiscdata)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoAcceleratorNotify {
    type Vtable = IAMVideoAcceleratorNotify_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(627730977, 64429, 4561, [130, 191, 0, 160, 201, 105, 108, 143]);
}
impl ::std::convert::From<IAMVideoAcceleratorNotify> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoAcceleratorNotify) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoAcceleratorNotify> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoAcceleratorNotify) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoAcceleratorNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoAcceleratorNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAcceleratorNotify_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_DirectDraw")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguid: *const ::windows::runtime::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwactualuncompsurfacesallocated: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pguid: *const ::windows::runtime::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoCompression(pub ::windows::runtime::IUnknown);
impl IAMVideoCompression {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetKeyFrameRate(&self, keyframerate: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(keyframerate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn KeyFrameRate(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(pframesperkeyframe)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PFramesPerKeyFrame(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetQuality(&self, quality: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(quality)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Quality(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetWindowSize(&self, windowsize: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(windowsize)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn WindowSize(&self) -> ::windows::runtime::Result<u64> {
        let mut result__: <u64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetInfo(&self, pszversion: super::super::Foundation::PWSTR, pcbversion: *mut i32, pszdescription: super::super::Foundation::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pszversion),
            ::std::mem::transmute(pcbversion),
            ::std::mem::transmute(pszdescription),
            ::std::mem::transmute(pcbdescription),
            ::std::mem::transmute(pdefaultkeyframerate),
            ::std::mem::transmute(pdefaultpframesperkey),
            ::std::mem::transmute(pdefaultquality),
            ::std::mem::transmute(pcapabilities),
        )
        .ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OverrideKeyFrame(&self, framenumber: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(framenumber)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(framenumber), ::std::mem::transmute(size)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoCompression {
    type Vtable = IAMVideoCompression_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647491, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMVideoCompression> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoCompression) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoCompression> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoCompression) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoCompression {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoCompression {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoCompression_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, keyframerate: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pkeyframerate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pframesperkeyframe: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppframesperkeyframe: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, quality: f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pquality: *mut f64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, windowsize: u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwindowsize: *mut u64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszversion: super::super::Foundation::PWSTR, pcbversion: *mut i32, pszdescription: super::super::Foundation::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framenumber: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, framenumber: i32, size: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoControl(pub ::windows::runtime::IUnknown);
impl IAMVideoControl {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCaps<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ppin.into_param().abi(), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMode<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0, mode: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ppin.into_param().abi(), ::std::mem::transmute(mode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetMode<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ppin.into_param().abi(), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCurrentActualFrameRate<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>>(&self, ppin: Param0) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ppin.into_param().abi(), &mut result__).from_abi::<i64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetMaxAvailableFrameRate<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>>(&self, ppin: Param0, iindex: i32, dimensions: Param2) -> ::windows::runtime::Result<i64> {
        let mut result__: <i64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ppin.into_param().abi(), ::std::mem::transmute(iindex), dimensions.into_param().abi(), &mut result__).from_abi::<i64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetFrameRateList<'a, Param0: ::windows::runtime::IntoParam<'a, IPin>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>>(&self, ppin: Param0, iindex: i32, dimensions: Param2, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ppin.into_param().abi(), ::std::mem::transmute(iindex), dimensions.into_param().abi(), ::std::mem::transmute(listsize), ::std::mem::transmute(framerates)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoControl {
    type Vtable = IAMVideoControl_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1781401200, 10468, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMVideoControl> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoControl) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoControl> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoControl) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoControl {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoControl_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, pcapsflags: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, mode: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, mode: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, actualframerate: *mut i64) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, iindex: i32, dimensions: super::super::Foundation::SIZE, maxavailableframerate: *mut i64) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppin: ::windows::runtime::RawPtr, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoDecimationProperties(pub ::windows::runtime::IUnknown);
impl IAMVideoDecimationProperties {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn QueryDecimationUsage(&self) -> ::windows::runtime::Result<DECIMATION_USAGE> {
        let mut result__: <DECIMATION_USAGE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<DECIMATION_USAGE>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(usage)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoDecimationProperties {
    type Vtable = IAMVideoDecimationProperties_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1624451376, 5082, 4563, [158, 198, 196, 252, 174, 245, 199, 190]);
}
impl ::std::convert::From<IAMVideoDecimationProperties> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoDecimationProperties) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoDecimationProperties> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoDecimationProperties) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoDecimationProperties {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoDecimationProperties {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoDecimationProperties_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpusage: *mut DECIMATION_USAGE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, usage: DECIMATION_USAGE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMVideoProcAmp(pub ::windows::runtime::IUnknown);
impl IAMVideoProcAmp {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(pmin), ::std::mem::transmute(pmax), ::std::mem::transmute(psteppingdelta), ::std::mem::transmute(pdefault), ::std::mem::transmute(pcapsflags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(lvalue), ::std::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(property), ::std::mem::transmute(lvalue), ::std::mem::transmute(flags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMVideoProcAmp {
    type Vtable = IAMVideoProcAmp_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3336647520, 12460, 4560, [161, 140, 0, 160, 201, 17, 137, 86]);
}
impl ::std::convert::From<IAMVideoProcAmp> for ::windows::runtime::IUnknown {
    fn from(value: IAMVideoProcAmp) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMVideoProcAmp> for ::windows::runtime::IUnknown {
    fn from(value: &IAMVideoProcAmp) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMVideoProcAmp {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMVideoProcAmp {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoProcAmp_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, lvalue: i32, flags: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMWstDecoder(pub ::windows::runtime::IUnknown);
impl IAMWstDecoder {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(lplevel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpservice)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpstate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetServiceState(&self, state: AM_WST_STATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(state)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::Gdi::BITMAPINFOHEADER) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpbmih)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::Gdi::BITMAPINFO) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpbmi)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwphyscolor)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwphyscolor)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpboption)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetRedrawAlways<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, boption: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), boption.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(lpmode)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(mode)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetAnswerMode<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, banswer: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), banswer.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetAnswerMode(&self, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbanswer)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetHoldPage<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bholdpage: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), bholdpage.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetHoldPage(&self, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pbholdpage)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(pwstpage)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCurrentPage<'a, Param0: ::windows::runtime::IntoParam<'a, AM_WST_PAGE>>(&self, wstpage: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), wstpage.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMWstDecoder {
    type Vtable = IAMWstDecoder_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IAMWstDecoder> for ::windows::runtime::IUnknown {
    fn from(value: IAMWstDecoder) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMWstDecoder> for ::windows::runtime::IUnknown {
    fn from(value: &IAMWstDecoder) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMWstDecoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMWstDecoder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMWstDecoder_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lplevel: *mut AM_WST_LEVEL) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpservice: *mut AM_WST_SERVICE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpstate: *mut AM_WST_STATE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, state: AM_WST_STATE) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpbmih: *mut super::Gdi::BITMAPINFOHEADER) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpbmi: *mut super::Gdi::BITMAPINFO) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwphyscolor: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwphyscolor: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpboption: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, boption: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mode: AM_WST_DRAWBGMODE) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, banswer: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, bholdpage: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pwstpage: *mut AM_WST_PAGE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, wstpage: AM_WST_PAGE) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IAMovieSetup(pub ::windows::runtime::IUnknown);
impl IAMovieSetup {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Register(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Unregister(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAMovieSetup {
    type Vtable = IAMovieSetup_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2748894912, 32346, 4559, [187, 197, 0, 128, 95, 108, 239, 32]);
}
impl ::std::convert::From<IAMovieSetup> for ::windows::runtime::IUnknown {
    fn from(value: IAMovieSetup) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IAMovieSetup> for ::windows::runtime::IUnknown {
    fn from(value: &IAMovieSetup) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAMovieSetup {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IAMovieSetup {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMovieSetup_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IATSCChannelTuneRequest(pub ::windows::runtime::IUnknown);
impl IATSCChannelTuneRequest {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_Ole_Automation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::runtime::Result<super::super::System::Ole::Automation::ITypeInfo> {
        let mut result__: <super::super::System::Ole::Automation::ITypeInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(itinfo), ::std::mem::transmute(lcid), &mut result__).from_abi::<super::super::System::Ole::Automation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(rgsznames), ::std::mem::transmute(cnames), ::std::mem::transmute(lcid), ::std::mem::transmute(rgdispid)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Ole::Automation::EXCEPINFO, puargerr: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dispidmember), ::std::mem::transmute(riid), ::std::mem::transmute(lcid), ::std::mem::transmute(wflags), ::std::mem::transmute(pdispparams), ::std::mem::transmute(pvarresult), ::std::mem::transmute(pexcepinfo), ::std::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TuningSpace(&self) -> ::windows::runtime::Result<ITuningSpace> {
        let mut result__: <ITuningSpace as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ITuningSpace>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Components(&self) -> ::windows::runtime::Result<IComponents> {
        let mut result__: <IComponents as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IComponents>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ITuneRequest> {
        let mut result__: <ITuneRequest as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ITuneRequest>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Locator(&self) -> ::windows::runtime::Result<ILocator> {
        let mut result__: <ILocator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetLocator<'a, Param0: ::windows::runtime::IntoParam<'a, ILocator>>(&self, locator: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), locator.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Channel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetChannel(&self, channel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(channel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MinorChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMinorChannel(&self, minorchannel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(minorchannel)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IATSCChannelTuneRequest {
    type Vtable = IATSCChannelTuneRequest_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(57259233, 17846, 4563, [182, 80, 0, 192, 79, 121, 73, 142]);
}
impl ::std::convert::From<IATSCChannelTuneRequest> for ::windows::runtime::IUnknown {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IATSCChannelTuneRequest> for ::windows::runtime::IUnknown {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IATSCChannelTuneRequest> for IChannelTuneRequest {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCChannelTuneRequest> for IChannelTuneRequest {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IChannelTuneRequest> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, IChannelTuneRequest> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IChannelTuneRequest> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, IChannelTuneRequest> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCChannelTuneRequest> for ITuneRequest {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCChannelTuneRequest> for ITuneRequest {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITuneRequest> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITuneRequest> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITuneRequest> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITuneRequest> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IATSCChannelTuneRequest> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IATSCChannelTuneRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IATSCChannelTuneRequest> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IATSCChannelTuneRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IATSCChannelTuneRequest {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCChannelTuneRequest_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tuningspace: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, components: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newtunerequest: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locator: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locator: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, channel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, channel: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, minorchannel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, minorchannel: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IATSCComponentType(pub ::windows::runtime::IUnknown);
impl IATSCComponentType {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_Ole_Automation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::runtime::Result<super::super::System::Ole::Automation::ITypeInfo> {
        let mut result__: <super::super::System::Ole::Automation::ITypeInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(itinfo), ::std::mem::transmute(lcid), &mut result__).from_abi::<super::super::System::Ole::Automation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(rgsznames), ::std::mem::transmute(cnames), ::std::mem::transmute(lcid), ::std::mem::transmute(rgdispid)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Ole::Automation::EXCEPINFO, puargerr: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dispidmember), ::std::mem::transmute(riid), ::std::mem::transmute(lcid), ::std::mem::transmute(wflags), ::std::mem::transmute(pdispparams), ::std::mem::transmute(pvarresult), ::std::mem::transmute(pexcepinfo), ::std::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Category(&self) -> ::windows::runtime::Result<ComponentCategory> {
        let mut result__: <ComponentCategory as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ComponentCategory>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCategory(&self, category: ComponentCategory) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(category)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaMajorType(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMediaMajorType<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediamajortype: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), mediamajortype.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn _MediaMajorType(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set_MediaMajorType(&self, mediamajortypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(mediamajortypeguid)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaSubType(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMediaSubType<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediasubtype: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), mediasubtype.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn _MediaSubType(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set_MediaSubType(&self, mediasubtypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(mediasubtypeguid)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaFormatType(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMediaFormatType<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mediaformattype: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), mediaformattype.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn _MediaFormatType(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set_MediaFormatType(&self, mediaformattypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(mediaformattypeguid)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn MediaType(&self) -> ::windows::runtime::Result<AM_MEDIA_TYPE> {
        let mut result__: <AM_MEDIA_TYPE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), &mut result__).from_abi::<AM_MEDIA_TYPE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetMediaType(&self, mediatype: *const AM_MEDIA_TYPE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(mediatype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IComponentType> {
        let mut result__: <IComponentType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IComponentType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn LangID(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetLangID(&self, langid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(langid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn StreamType(&self) -> ::windows::runtime::Result<MPEG2StreamType> {
        let mut result__: <MPEG2StreamType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__).from_abi::<MPEG2StreamType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetStreamType(&self, mp2streamtype: MPEG2StreamType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(mp2streamtype)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Flags(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetFlags(&self, flags: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IATSCComponentType {
    type Vtable = IATSCComponentType_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4229471821, 31700, 16677, [179, 179, 58, 118, 163, 50, 204, 150]);
}
impl ::std::convert::From<IATSCComponentType> for ::windows::runtime::IUnknown {
    fn from(value: IATSCComponentType) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IATSCComponentType> for ::windows::runtime::IUnknown {
    fn from(value: &IATSCComponentType) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IATSCComponentType> for IMPEG2ComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCComponentType> for IMPEG2ComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMPEG2ComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMPEG2ComponentType> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMPEG2ComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMPEG2ComponentType> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCComponentType> for ILanguageComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCComponentType> for ILanguageComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILanguageComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILanguageComponentType> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILanguageComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILanguageComponentType> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCComponentType> for IComponentType {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCComponentType> for IComponentType {
    fn from(value: &IATSCComponentType) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IComponentType> for IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, IComponentType> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IComponentType> for &IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, IComponentType> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IATSCComponentType> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IATSCComponentType) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IATSCComponentType> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IATSCComponentType) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IATSCComponentType {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCComponentType_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: *mut ComponentCategory) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, category: ComponentCategory) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediamajortype: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediamajortype: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediamajortypeguid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediamajortypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediasubtype: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediasubtype: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediasubtypeguid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediasubtypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediaformattype: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediaformattype: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediaformattypeguid: *mut ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediaformattypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediatype: *mut ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mediatype: *const ::std::mem::ManuallyDrop<AM_MEDIA_TYPE>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newct: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, langid: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, langid: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mp2streamtype: *mut MPEG2StreamType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mp2streamtype: MPEG2StreamType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IATSCLocator(pub ::windows::runtime::IUnknown);
impl IATSCLocator {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_Ole_Automation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::runtime::Result<super::super::System::Ole::Automation::ITypeInfo> {
        let mut result__: <super::super::System::Ole::Automation::ITypeInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(itinfo), ::std::mem::transmute(lcid), &mut result__).from_abi::<super::super::System::Ole::Automation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(rgsznames), ::std::mem::transmute(cnames), ::std::mem::transmute(lcid), ::std::mem::transmute(rgdispid)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Ole::Automation::EXCEPINFO, puargerr: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dispidmember), ::std::mem::transmute(riid), ::std::mem::transmute(lcid), ::std::mem::transmute(wflags), ::std::mem::transmute(pdispparams), ::std::mem::transmute(pvarresult), ::std::mem::transmute(pexcepinfo), ::std::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CarrierFrequency(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCarrierFrequency(&self, frequency: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(frequency)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InnerFEC(&self) -> ::windows::runtime::Result<FECMethod> {
        let mut result__: <FECMethod as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInnerFEC(&self, fec: FECMethod) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InnerFECRate(&self) -> ::windows::runtime::Result<BinaryConvolutionCodeRate> {
        let mut result__: <BinaryConvolutionCodeRate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInnerFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OuterFEC(&self) -> ::windows::runtime::Result<FECMethod> {
        let mut result__: <FECMethod as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), &mut result__).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOuterFEC(&self, fec: FECMethod) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OuterFECRate(&self) -> ::windows::runtime::Result<BinaryConvolutionCodeRate> {
        let mut result__: <BinaryConvolutionCodeRate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOuterFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Modulation(&self) -> ::windows::runtime::Result<ModulationType> {
        let mut result__: <ModulationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ModulationType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetModulation(&self, modulation: ModulationType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(modulation)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SymbolRate(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetSymbolRate(&self, rate: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(rate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ILocator> {
        let mut result__: <ILocator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PhysicalChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPhysicalChannel(&self, physicalchannel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(physicalchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TSID(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTSID(&self, tsid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(tsid)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IATSCLocator {
    type Vtable = IATSCLocator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3213727855, 35883, 16689, [148, 215, 77, 61, 159, 204, 33, 239]);
}
impl ::std::convert::From<IATSCLocator> for ::windows::runtime::IUnknown {
    fn from(value: IATSCLocator) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IATSCLocator> for ::windows::runtime::IUnknown {
    fn from(value: &IATSCLocator) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IATSCLocator> for IDigitalLocator {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCLocator> for IDigitalLocator {
    fn from(value: &IATSCLocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IDigitalLocator> for IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, IDigitalLocator> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IDigitalLocator> for &IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, IDigitalLocator> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCLocator> for ILocator {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCLocator> for ILocator {
    fn from(value: &IATSCLocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILocator> for IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILocator> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILocator> for &IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILocator> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IATSCLocator> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IATSCLocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IATSCLocator> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IATSCLocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IATSCLocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, frequency: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, frequency: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, modulation: *mut ModulationType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, modulation: ModulationType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rate: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newlocator: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, physicalchannel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, physicalchannel: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tsid: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tsid: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IATSCLocator2(pub ::windows::runtime::IUnknown);
impl IATSCLocator2 {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_Ole_Automation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::runtime::Result<super::super::System::Ole::Automation::ITypeInfo> {
        let mut result__: <super::super::System::Ole::Automation::ITypeInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(itinfo), ::std::mem::transmute(lcid), &mut result__).from_abi::<super::super::System::Ole::Automation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(rgsznames), ::std::mem::transmute(cnames), ::std::mem::transmute(lcid), ::std::mem::transmute(rgdispid)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Ole::Automation::EXCEPINFO, puargerr: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dispidmember), ::std::mem::transmute(riid), ::std::mem::transmute(lcid), ::std::mem::transmute(wflags), ::std::mem::transmute(pdispparams), ::std::mem::transmute(pvarresult), ::std::mem::transmute(pexcepinfo), ::std::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CarrierFrequency(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCarrierFrequency(&self, frequency: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(frequency)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InnerFEC(&self) -> ::windows::runtime::Result<FECMethod> {
        let mut result__: <FECMethod as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInnerFEC(&self, fec: FECMethod) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InnerFECRate(&self) -> ::windows::runtime::Result<BinaryConvolutionCodeRate> {
        let mut result__: <BinaryConvolutionCodeRate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInnerFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OuterFEC(&self) -> ::windows::runtime::Result<FECMethod> {
        let mut result__: <FECMethod as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), &mut result__).from_abi::<FECMethod>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOuterFEC(&self, fec: FECMethod) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn OuterFECRate(&self) -> ::windows::runtime::Result<BinaryConvolutionCodeRate> {
        let mut result__: <BinaryConvolutionCodeRate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<BinaryConvolutionCodeRate>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetOuterFECRate(&self, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(fec)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Modulation(&self) -> ::windows::runtime::Result<ModulationType> {
        let mut result__: <ModulationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ModulationType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetModulation(&self, modulation: ModulationType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(modulation)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SymbolRate(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetSymbolRate(&self, rate: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(rate)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ILocator> {
        let mut result__: <ILocator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn PhysicalChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetPhysicalChannel(&self, physicalchannel: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(physicalchannel)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn TSID(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetTSID(&self, tsid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(tsid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn ProgramNumber(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetProgramNumber(&self, programnumber: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(programnumber)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IATSCLocator2 {
    type Vtable = IATSCLocator2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1630185605, 26319, 16528, [186, 10, 86, 111, 83, 18, 228, 202]);
}
impl ::std::convert::From<IATSCLocator2> for ::windows::runtime::IUnknown {
    fn from(value: IATSCLocator2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IATSCLocator2> for ::windows::runtime::IUnknown {
    fn from(value: &IATSCLocator2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IATSCLocator2> for IATSCLocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCLocator2> for IATSCLocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IATSCLocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IATSCLocator> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IATSCLocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IATSCLocator> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCLocator2> for IDigitalLocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCLocator2> for IDigitalLocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IDigitalLocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IDigitalLocator> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IDigitalLocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IDigitalLocator> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCLocator2> for ILocator {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCLocator2> for ILocator {
    fn from(value: &IATSCLocator2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILocator> for IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILocator> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ILocator> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ILocator> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IATSCLocator2> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IATSCLocator2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IATSCLocator2> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IATSCLocator2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IATSCLocator2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocator2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, frequency: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, frequency: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: FECMethod) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: *mut BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fec: BinaryConvolutionCodeRate) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, modulation: *mut ModulationType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, modulation: ModulationType) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rate: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, rate: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, newlocator: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, physicalchannel: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, physicalchannel: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tsid: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tsid: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, programnumber: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, programnumber: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IATSCTuningSpace(pub ::windows::runtime::IUnknown);
impl IATSCTuningSpace {
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_Ole_Automation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::runtime::Result<super::super::System::Ole::Automation::ITypeInfo> {
        let mut result__: <super::super::System::Ole::Automation::ITypeInfo as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(itinfo), ::std::mem::transmute(lcid), &mut result__).from_abi::<super::super::System::Ole::Automation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(riid), ::std::mem::transmute(rgsznames), ::std::mem::transmute(cnames), ::std::mem::transmute(lcid), ::std::mem::transmute(rgdispid)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`, `Win32_System_Com`, `Win32_System_Ole_Automation`*"]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Ole::Automation::EXCEPINFO, puargerr: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dispidmember), ::std::mem::transmute(riid), ::std::mem::transmute(lcid), ::std::mem::transmute(wflags), ::std::mem::transmute(pdispparams), ::std::mem::transmute(pvarresult), ::std::mem::transmute(pexcepinfo), ::std::mem::transmute(puargerr)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn UniqueName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetUniqueName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn FriendlyName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetFriendlyName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn CLSID(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn NetworkType(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetNetworkType<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, networktypeguid: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), networktypeguid.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn _NetworkType(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), &mut result__).from_abi::<::windows::runtime::GUID>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Set_NetworkType(&self, networktypeguid: *const ::windows::runtime::GUID) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(networktypeguid)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CreateTuneRequest(&self) -> ::windows::runtime::Result<ITuneRequest> {
        let mut result__: <ITuneRequest as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ITuneRequest>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Com`*"]
    pub unsafe fn EnumCategoryGUIDs(&self) -> ::windows::runtime::Result<super::super::System::Com::IEnumGUID> {
        let mut result__: <super::super::System::Com::IEnumGUID as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_System_Com`*"]
    pub unsafe fn EnumDeviceMonikers(&self) -> ::windows::runtime::Result<super::super::System::Com::IEnumMoniker> {
        let mut result__: <super::super::System::Com::IEnumMoniker as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::System::Com::IEnumMoniker>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn DefaultPreferredComponentTypes(&self) -> ::windows::runtime::Result<IComponentTypes> {
        let mut result__: <IComponentTypes as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IComponentTypes>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDefaultPreferredComponentTypes<'a, Param0: ::windows::runtime::IntoParam<'a, IComponentTypes>>(&self, newcomponenttypes: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), newcomponenttypes.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn FrequencyMapping(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Graphics_DirectShow`, `Win32_Foundation`*"]
    pub unsafe fn SetFrequencyMapping<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>>(&self, mapping: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), mapping.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn DefaultLocator(&self) -> ::windows::runtime::Result<ILocator> {
        let mut result__: <ILocator as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ILocator>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetDefaultLocator<'a, Param0: ::windows::runtime::IntoParam<'a, ILocator>>(&self, locatorval: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), locatorval.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ITuningSpace> {
        let mut result__: <ITuningSpace as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ITuningSpace>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MinChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMinChannel(&self, newminchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(newminchannelval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MaxChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMaxChannel(&self, newmaxchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), ::std::mem::transmute(newmaxchannelval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn InputType(&self) -> ::windows::runtime::Result<TunerInputType> {
        let mut result__: <TunerInputType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), &mut result__).from_abi::<TunerInputType>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetInputType(&self, newinputtypeval: TunerInputType) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), ::std::mem::transmute(newinputtypeval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn CountryCode(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetCountryCode(&self, newcountrycodeval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), ::std::mem::transmute(newcountrycodeval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MinMinorChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMinMinorChannel(&self, newminminorchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(newminminorchannelval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MaxMinorChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMaxMinorChannel(&self, newmaxminorchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self), ::std::mem::transmute(newmaxminorchannelval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MinPhysicalChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMinPhysicalChannel(&self, newminphysicalchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(newminphysicalchannelval)).ok()
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn MaxPhysicalChannel(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Graphics_DirectShow`*"]
    pub unsafe fn SetMaxPhysicalChannel(&self, newmaxphysicalchannelval: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(newmaxphysicalchannelval)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IATSCTuningSpace {
    type Vtable = IATSCTuningSpace_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(57259234, 17846, 4563, [182, 80, 0, 192, 79, 121, 73, 142]);
}
impl ::std::convert::From<IATSCTuningSpace> for ::windows::runtime::IUnknown {
    fn from(value: IATSCTuningSpace) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IATSCTuningSpace> for ::windows::runtime::IUnknown {
    fn from(value: &IATSCTuningSpace) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IATSCTuningSpace> for IAnalogTVTuningSpace {
    fn from(value: IATSCTuningSpace) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCTuningSpace> for IAnalogTVTuningSpace {
    fn from(value: &IATSCTuningSpace) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAnalogTVTuningSpace> for IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAnalogTVTuningSpace> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAnalogTVTuningSpace> for &IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAnalogTVTuningSpace> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
impl ::std::convert::From<IATSCTuningSpace> for ITuningSpace {
    fn from(value: IATSCTuningSpace) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IATSCTuningSpace> for ITuningSpace {
    fn from(value: &IATSCTuningSpace) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITuningSpace> for IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITuningSpace> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITuningSpace> for &IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITuningSpace> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<IATSCTuningSpace> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: IATSCTuningSpace) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl ::std::convert::From<&IATSCTuningSpace> for super::super::System::Ole::Automation::IDispatch {
    fn from(value: &IATSCTuningSpace) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Ole_Automation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Ole::Automation::IDispatch> for &IATSCTuningSpace {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::super::System::Ole::Automation::IDispatch> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSCTuningSpace_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pctinfo: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Ole_Automation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, itinfo: u32, lcid: u32, pptinfo: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole_Automation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole_Automation"))]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dispidmember: i32, riid: *const ::windows::runtime::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Ole::Automation::DISPPARAMS, pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::Ole::Automation::EXCEPINFO>, puargerr: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", fe