#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ALL_SERVICES: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ALL_SERVICE_TYPES: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_ALPHA: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_BLANK: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_CNTRL: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_DEFINED: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_DIGIT: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_LOWER: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_PUNCT: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_SPACE: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_UPPER: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C1_XDIGIT: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_ARABICNUMBER: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_BLOCKSEPARATOR: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_COMMONSEPARATOR: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_EUROPENUMBER: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_EUROPESEPARATOR: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_EUROPETERMINATOR: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_LEFTTORIGHT: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_NOTAPPLICABLE: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_OTHERNEUTRAL: u32 = 11u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_RIGHTTOLEFT: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_SEGMENTSEPARATOR: u32 = 9u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C2_WHITESPACE: u32 = 10u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_ALPHA: u32 = 32768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_DIACRITIC: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_FULLWIDTH: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_HALFWIDTH: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_HIGHSURROGATE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_HIRAGANA: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_IDEOGRAPH: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_KASHIDA: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_KATAKANA: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_LEXICAL: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_LOWSURROGATE: u32 = 4096u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_NONSPACING: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_NOTAPPLICABLE: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_SYMBOL: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const C3_VOWELMARK: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXA = unsafe extern "system" fn(param0: super::Foundation::PSTR, param1: u32) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXEX = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: u32, param2: super::Foundation::PWSTR, param3: super::Foundation::LPARAM) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXW = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: u32) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN_ARABIC: u32 = 10u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN_ME_FRENCH: u32 = 9u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN_US: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN_XLIT_ENGLISH: u32 = 11u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_GREGORIAN_XLIT_FRENCH: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_HEBREW: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_HIJRI: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_ICALINTVALUE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_ITWODIGITYEARMAX: u32 = 48u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_IYEAROFFSETRANGE: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_JAPAN: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_KOREA: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_NOUSEROVERRIDE: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_PERSIAN: u32 = 22u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_RETURN_NUMBER: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME1: u32 = 14u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME2: u32 = 15u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME3: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME4: u32 = 17u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME5: u32 = 18u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME6: u32 = 19u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVDAYNAME7: u32 = 20u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVERASTRING: u32 = 57u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME1: u32 = 34u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME10: u32 = 43u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME11: u32 = 44u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME12: u32 = 45u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME13: u32 = 46u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME2: u32 = 35u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME3: u32 = 36u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME4: u32 = 37u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME5: u32 = 38u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME6: u32 = 39u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME7: u32 = 40u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME8: u32 = 41u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SABBREVMONTHNAME9: u32 = 42u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SCALNAME: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME1: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME2: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME3: u32 = 9u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME4: u32 = 10u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME5: u32 = 11u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME6: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SDAYNAME7: u32 = 13u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SENGLISHABBREVERANAME: u32 = 60u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SENGLISHERANAME: u32 = 59u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SERASTRING: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SJAPANESEERAFIRSTYEAR: u32 = 61u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SLONGDATE: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHDAY: u32 = 56u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME1: u32 = 21u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME10: u32 = 30u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME11: u32 = 31u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME12: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME13: u32 = 33u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME2: u32 = 22u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME3: u32 = 23u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME4: u32 = 24u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME5: u32 = 25u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME6: u32 = 26u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME7: u32 = 27u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME8: u32 = 28u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SMONTHNAME9: u32 = 29u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SRELATIVELONGDATE: u32 = 58u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTDATE: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME1: u32 = 49u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME2: u32 = 50u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME3: u32 = 51u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME4: u32 = 52u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME5: u32 = 53u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME6: u32 = 54u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SSHORTESTDAYNAME7: u32 = 55u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_SYEARMONTH: u32 = 47u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_TAIWAN: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_THAI: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_UMALQURA: u32 = 23u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CAL_USE_CP_ACP: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CANITER_SKIP_ZEROES: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct CHARSETINFO {
    pub ciCharset: u32,
    pub ciACP: u32,
    pub fs: FONTSIGNATURE,
}
impl CHARSETINFO {}
impl ::std::default::Default for CHARSETINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CHARSETINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CHARSETINFO").field("ciCharset", &self.ciCharset).field("ciACP", &self.ciACP).field("fs", &self.fs).finish()
    }
}
impl ::std::cmp::PartialEq for CHARSETINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ciCharset == other.ciCharset && self.ciACP == other.ciACP && self.fs == other.fs
    }
}
impl ::std::cmp::Eq for CHARSETINFO {}
unsafe impl ::windows::runtime::Abi for CHARSETINFO {
    type Abi = Self;
}
pub const CMLangConvertCharset: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3597496217, 52650, 4560, [184, 34, 0, 192, 79, 201, 179, 31]);
pub const CMLangString: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3226297807, 46861, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
pub const CMultiLanguage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(660349922, 14151, 4560, [159, 234, 0, 170, 0, 63, 134, 70]);
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CODEPAGE_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type CODEPAGE_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct COMPARE_STRING_FLAGS(pub u32);
pub const LINGUISTIC_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(16u32);
pub const LINGUISTIC_IGNOREDIACRITIC: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(32u32);
pub const NORM_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(1u32);
pub const NORM_IGNOREKANATYPE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(65536u32);
pub const NORM_IGNORENONSPACE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(2u32);
pub const NORM_IGNORESYMBOLS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4u32);
pub const NORM_IGNOREWIDTH: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(131072u32);
pub const NORM_LINGUISTIC_CASING: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(134217728u32);
pub const SORT_DIGITSASNUMBERS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(8u32);
pub const SORT_STRINGSORT: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4096u32);
impl ::std::convert::From<u32> for COMPARE_STRING_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COMPARE_STRING_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for COMPARE_STRING_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for COMPARE_STRING_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct CORRECTIVE_ACTION(pub i32);
pub const CORRECTIVE_ACTION_NONE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(0i32);
pub const CORRECTIVE_ACTION_GET_SUGGESTIONS: CORRECTIVE_ACTION = CORRECTIVE_ACTION(1i32);
pub const CORRECTIVE_ACTION_REPLACE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(2i32);
pub const CORRECTIVE_ACTION_DELETE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(3i32);
impl ::std::convert::From<i32> for CORRECTIVE_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CORRECTIVE_ACTION {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct CPINFO {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
}
impl CPINFO {}
impl ::std::default::Default for CPINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CPINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFO").field("MaxCharSize", &self.MaxCharSize).field("DefaultChar", &self.DefaultChar).field("LeadByte", &self.LeadByte).finish()
    }
}
impl ::std::cmp::PartialEq for CPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize && self.DefaultChar == other.DefaultChar && self.LeadByte == other.LeadByte
    }
}
impl ::std::cmp::Eq for CPINFO {}
unsafe impl ::windows::runtime::Abi for CPINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct CPINFOEXA {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
    pub UnicodeDefaultChar: u16,
    pub CodePage: u32,
    pub CodePageName: [super::Foundation::CHAR; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl CPINFOEXA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CPINFOEXA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CPINFOEXA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFOEXA").field("MaxCharSize", &self.MaxCharSize).field("DefaultChar", &self.DefaultChar).field("LeadByte", &self.LeadByte).field("UnicodeDefaultChar", &self.UnicodeDefaultChar).field("CodePage", &self.CodePage).field("CodePageName", &self.CodePageName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CPINFOEXA {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize && self.DefaultChar == other.DefaultChar && self.LeadByte == other.LeadByte && self.UnicodeDefaultChar == other.UnicodeDefaultChar && self.CodePage == other.CodePage && self.CodePageName == other.CodePageName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CPINFOEXA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CPINFOEXA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct CPINFOEXW {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
    pub UnicodeDefaultChar: u16,
    pub CodePage: u32,
    pub CodePageName: [u16; 260],
}
impl CPINFOEXW {}
impl ::std::default::Default for CPINFOEXW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CPINFOEXW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFOEXW").field("MaxCharSize", &self.MaxCharSize).field("DefaultChar", &self.DefaultChar).field("LeadByte", &self.LeadByte).field("UnicodeDefaultChar", &self.UnicodeDefaultChar).field("CodePage", &self.CodePage).field("CodePageName", &self.CodePageName).finish()
    }
}
impl ::std::cmp::PartialEq for CPINFOEXW {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize && self.DefaultChar == other.DefaultChar && self.LeadByte == other.LeadByte && self.UnicodeDefaultChar == other.UnicodeDefaultChar && self.CodePage == other.CodePage && self.CodePageName == other.CodePageName
    }
}
impl ::std::cmp::Eq for CPINFOEXW {}
unsafe impl ::windows::runtime::Abi for CPINFOEXW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CPIOD_FORCE_PROMPT: i32 = -2147483648i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CPIOD_PEEK: i32 = 1073741824i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_ACP: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_MACCP: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_OEMCP: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_SYMBOL: u32 = 42u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_THREAD_ACP: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_UTF7: u32 = 65000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CP_UTF8: u32 = 65001u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CSTR_EQUAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CSTR_GREATER_THAN: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CSTR_LESS_THAN: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ALBANIA: u32 = 355u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ALGERIA: u32 = 213u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ARGENTINA: u32 = 54u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ARMENIA: u32 = 374u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_AUSTRALIA: u32 = 61u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_AUSTRIA: u32 = 43u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_AZERBAIJAN: u32 = 994u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BAHRAIN: u32 = 973u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BELARUS: u32 = 375u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BELGIUM: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BELIZE: u32 = 501u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BOLIVIA: u32 = 591u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BRAZIL: u32 = 55u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BRUNEI_DARUSSALAM: u32 = 673u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_BULGARIA: u32 = 359u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_CANADA: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_CARIBBEAN: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_CHILE: u32 = 56u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_COLOMBIA: u32 = 57u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_COSTA_RICA: u32 = 506u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_CROATIA: u32 = 385u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_CZECH: u32 = 420u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_DENMARK: u32 = 45u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_DOMINICAN_REPUBLIC: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ECUADOR: u32 = 593u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_EGYPT: u32 = 20u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_EL_SALVADOR: u32 = 503u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ESTONIA: u32 = 372u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_FAEROE_ISLANDS: u32 = 298u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_FINLAND: u32 = 358u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_FRANCE: u32 = 33u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_GEORGIA: u32 = 995u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_GERMANY: u32 = 49u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_GREECE: u32 = 30u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_GUATEMALA: u32 = 502u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_HONDURAS: u32 = 504u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_HONG_KONG: u32 = 852u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_HUNGARY: u32 = 36u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ICELAND: u32 = 354u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_INDIA: u32 = 91u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_INDONESIA: u32 = 62u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_IRAN: u32 = 981u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_IRAQ: u32 = 964u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_IRELAND: u32 = 353u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ISRAEL: u32 = 972u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ITALY: u32 = 39u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_JAMAICA: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_JAPAN: u32 = 81u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_JORDAN: u32 = 962u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_KAZAKSTAN: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_KENYA: u32 = 254u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_KUWAIT: u32 = 965u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_KYRGYZSTAN: u32 = 996u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LATVIA: u32 = 371u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LEBANON: u32 = 961u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LIBYA: u32 = 218u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LIECHTENSTEIN: u32 = 41u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LITHUANIA: u32 = 370u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_LUXEMBOURG: u32 = 352u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MACAU: u32 = 853u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MACEDONIA: u32 = 389u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MALAYSIA: u32 = 60u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MALDIVES: u32 = 960u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MEXICO: u32 = 52u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MONACO: u32 = 33u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MONGOLIA: u32 = 976u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_MOROCCO: u32 = 212u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_NETHERLANDS: u32 = 31u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_NEW_ZEALAND: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_NICARAGUA: u32 = 505u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_NORWAY: u32 = 47u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_OMAN: u32 = 968u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PAKISTAN: u32 = 92u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PANAMA: u32 = 507u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PARAGUAY: u32 = 595u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PERU: u32 = 51u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PHILIPPINES: u32 = 63u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_POLAND: u32 = 48u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PORTUGAL: u32 = 351u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PRCHINA: u32 = 86u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_PUERTO_RICO: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_QATAR: u32 = 974u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ROMANIA: u32 = 40u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_RUSSIA: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SAUDI_ARABIA: u32 = 966u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SERBIA: u32 = 381u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SINGAPORE: u32 = 65u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SLOVAK: u32 = 421u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SLOVENIA: u32 = 386u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SOUTH_AFRICA: u32 = 27u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SOUTH_KOREA: u32 = 82u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SPAIN: u32 = 34u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SWEDEN: u32 = 46u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SWITZERLAND: u32 = 41u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_SYRIA: u32 = 963u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_TAIWAN: u32 = 886u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_TATARSTAN: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_THAILAND: u32 = 66u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_TRINIDAD_Y_TOBAGO: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_TUNISIA: u32 = 216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_TURKEY: u32 = 90u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_UAE: u32 = 971u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_UKRAINE: u32 = 380u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_UNITED_KINGDOM: u32 = 44u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_UNITED_STATES: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_URUGUAY: u32 = 598u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_UZBEKISTAN: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_VENEZUELA: u32 = 58u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_VIET_NAM: u32 = 84u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_YEMEN: u32 = 967u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CTRY_ZIMBABWE: u32 = 263u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CT_CTYPE1: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CT_CTYPE2: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const CT_CTYPE3: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct CURRENCYFMTA {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PSTR,
    pub lpThousandSep: super::Foundation::PSTR,
    pub NegativeOrder: u32,
    pub PositiveOrder: u32,
    pub lpCurrencySymbol: super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CURRENCYFMTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CURRENCYFMTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CURRENCYFMTA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CURRENCYFMTA")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .field("PositiveOrder", &self.PositiveOrder)
            .field("lpCurrencySymbol", &self.lpCurrencySymbol)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CURRENCYFMTA {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits && self.LeadingZero == other.LeadingZero && self.Grouping == other.Grouping && self.lpDecimalSep == other.lpDecimalSep && self.lpThousandSep == other.lpThousandSep && self.NegativeOrder == other.NegativeOrder && self.PositiveOrder == other.PositiveOrder && self.lpCurrencySymbol == other.lpCurrencySymbol
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CURRENCYFMTA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CURRENCYFMTA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct CURRENCYFMTW {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PWSTR,
    pub lpThousandSep: super::Foundation::PWSTR,
    pub NegativeOrder: u32,
    pub PositiveOrder: u32,
    pub lpCurrencySymbol: super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CURRENCYFMTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CURRENCYFMTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CURRENCYFMTW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CURRENCYFMTW")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .field("PositiveOrder", &self.PositiveOrder)
            .field("lpCurrencySymbol", &self.lpCurrencySymbol)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CURRENCYFMTW {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits && self.LeadingZero == other.LeadingZero && self.Grouping == other.Grouping && self.lpDecimalSep == other.lpDecimalSep && self.lpThousandSep == other.lpThousandSep && self.NegativeOrder == other.NegativeOrder && self.PositiveOrder == other.PositiveOrder && self.lpCurrencySymbol == other.lpCurrencySymbol
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CURRENCYFMTW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CURRENCYFMTW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn CompareStringA(locale: u32, dwcmpflags: u32, lpstring1: *const i8, cchcount1: i32, lpstring2: *const i8, cchcount2: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringA(locale: u32, dwcmpflags: u32, lpstring1: *const i8, cchcount1: i32, lpstring2: *const i8, cchcount2: i32) -> i32;
        }
        ::std::mem::transmute(CompareStringA(::std::mem::transmute(locale), ::std::mem::transmute(dwcmpflags), ::std::mem::transmute(lpstring1), ::std::mem::transmute(cchcount1), ::std::mem::transmute(lpstring2), ::std::mem::transmute(cchcount2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CompareStringEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param8: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(
    lplocalename: Param0,
    dwcmpflags: COMPARE_STRING_FLAGS,
    lpstring1: Param2,
    cchcount1: i32,
    lpstring2: Param4,
    cchcount2: i32,
    lpversioninformation: *mut NLSVERSIONINFO,
    lpreserved: *mut ::std::ffi::c_void,
    lparam: Param8,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringEx(lplocalename: super::Foundation::PWSTR, dwcmpflags: COMPARE_STRING_FLAGS, lpstring1: super::Foundation::PWSTR, cchcount1: i32, lpstring2: super::Foundation::PWSTR, cchcount2: i32, lpversioninformation: *mut NLSVERSIONINFO, lpreserved: *mut ::std::ffi::c_void, lparam: super::Foundation::LPARAM) -> i32;
        }
        ::std::mem::transmute(CompareStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwcmpflags),
            lpstring1.into_param().abi(),
            ::std::mem::transmute(cchcount1),
            lpstring2.into_param().abi(),
            ::std::mem::transmute(cchcount2),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CompareStringOrdinal<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(lpstring1: Param0, cchcount1: i32, lpstring2: Param2, cchcount2: i32, bignorecase: Param4) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringOrdinal(lpstring1: super::Foundation::PWSTR, cchcount1: i32, lpstring2: super::Foundation::PWSTR, cchcount2: i32, bignorecase: super::Foundation::BOOL) -> i32;
        }
        ::std::mem::transmute(CompareStringOrdinal(lpstring1.into_param().abi(), ::std::mem::transmute(cchcount1), lpstring2.into_param().abi(), ::std::mem::transmute(cchcount2), bignorecase.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CompareStringW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwcmpflags: u32, lpstring1: Param2, cchcount1: i32, lpstring2: Param4, cchcount2: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringW(locale: u32, dwcmpflags: u32, lpstring1: super::Foundation::PWSTR, cchcount1: i32, lpstring2: super::Foundation::PWSTR, cchcount2: i32) -> i32;
        }
        ::std::mem::transmute(CompareStringW(::std::mem::transmute(locale), ::std::mem::transmute(dwcmpflags), lpstring1.into_param().abi(), ::std::mem::transmute(cchcount1), lpstring2.into_param().abi(), ::std::mem::transmute(cchcount2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ConvertDefaultLocale(locale: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ConvertDefaultLocale(locale: u32) -> u32;
        }
        ::std::mem::transmute(ConvertDefaultLocale(::std::mem::transmute(locale)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXA = unsafe extern "system" fn(param0: super::Foundation::PSTR, param1: u32) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXEX = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: u32, param2: super::Foundation::LPARAM) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXW = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: u32) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct DetectEncodingInfo {
    pub nLangID: u32,
    pub nCodePage: u32,
    pub nDocPercent: i32,
    pub nConfidence: i32,
}
impl DetectEncodingInfo {}
impl ::std::default::Default for DetectEncodingInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DetectEncodingInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DetectEncodingInfo").field("nLangID", &self.nLangID).field("nCodePage", &self.nCodePage).field("nDocPercent", &self.nDocPercent).field("nConfidence", &self.nConfidence).finish()
    }
}
impl ::std::cmp::PartialEq for DetectEncodingInfo {
    fn eq(&self, other: &Self) -> bool {
        self.nLangID == other.nLangID && self.nCodePage == other.nCodePage && self.nDocPercent == other.nDocPercent && self.nConfidence == other.nConfidence
    }
}
impl ::std::cmp::Eq for DetectEncodingInfo {}
unsafe impl ::windows::runtime::Abi for DetectEncodingInfo {
    type Abi = Self;
}
pub const ELS_GUID_LANGUAGE_DETECTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3481141425, 37019, 19861, [168, 244, 97, 31, 124, 55, 119, 2]);
pub const ELS_GUID_SCRIPT_DETECTION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(761574457, 27823, 20331, [182, 136, 229, 208, 244, 250, 167, 215]);
pub const ELS_GUID_TRANSLITERATION_BENGALI_TO_LATIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4108310565, 37284, 18591, [133, 94, 154, 217, 190, 229, 87, 39]);
pub const ELS_GUID_TRANSLITERATION_CYRILLIC_TO_LATIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1037118104, 23293, 18691, [161, 63, 225, 126, 108, 11, 254, 1]);
pub const ELS_GUID_TRANSLITERATION_DEVANAGARI_TO_LATIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3299138814, 9825, 19714, [152, 53, 244, 129, 135, 16, 152, 3]);
pub const ELS_GUID_TRANSLITERATION_HANGUL_DECOMPOSITION: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1268950817, 58429, 16823, [179, 48, 83, 106, 225, 228, 136, 99]);
pub const ELS_GUID_TRANSLITERATION_HANS_TO_HANT: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1017957832, 21904, 17116, [154, 123, 181, 166, 181, 179, 182, 59]);
pub const ELS_GUID_TRANSLITERATION_HANT_TO_HANS: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2745709371, 62716, 17142, [160, 196, 4, 98, 254, 115, 23, 203]);
pub const ELS_GUID_TRANSLITERATION_MALAYALAM_TO_LATIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3636036529, 63679, 18987, [188, 213, 91, 94, 162, 6, 19, 225]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
pub struct ENUMTEXTMETRICA {
    pub etmNewTextMetricEx: NEWTEXTMETRICEXA,
    pub etmAxesList: super::Graphics::Gdi::AXESLISTA,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ENUMTEXTMETRICA {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for ENUMTEXTMETRICA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for ENUMTEXTMETRICA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ENUMTEXTMETRICA").field("etmNewTextMetricEx", &self.etmNewTextMetricEx).field("etmAxesList", &self.etmAxesList).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for ENUMTEXTMETRICA {
    fn eq(&self, other: &Self) -> bool {
        self.etmNewTextMetricEx == other.etmNewTextMetricEx && self.etmAxesList == other.etmAxesList
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for ENUMTEXTMETRICA {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for ENUMTEXTMETRICA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
pub struct ENUMTEXTMETRICW {
    pub etmNewTextMetricEx: NEWTEXTMETRICEXW,
    pub etmAxesList: super::Graphics::Gdi::AXESLISTW,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ENUMTEXTMETRICW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for ENUMTEXTMETRICW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for ENUMTEXTMETRICW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ENUMTEXTMETRICW").field("etmNewTextMetricEx", &self.etmNewTextMetricEx).field("etmAxesList", &self.etmAxesList).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for ENUMTEXTMETRICW {
    fn eq(&self, other: &Self) -> bool {
        self.etmNewTextMetricEx == other.etmNewTextMetricEx && self.etmAxesList == other.etmAxesList
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for ENUMTEXTMETRICW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for ENUMTEXTMETRICW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ENUM_ALL_CALENDARS: u32 = 4294967295u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENUM_DATE_FORMATS_FLAGS(pub u32);
pub const DATE_SHORTDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(1u32);
pub const DATE_LONGDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(2u32);
pub const DATE_YEARMONTH: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(8u32);
pub const DATE_MONTHDAY: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(128u32);
pub const DATE_AUTOLAYOUT: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(64u32);
pub const DATE_LTRREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(16u32);
pub const DATE_RTLREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(32u32);
pub const DATE_USE_ALT_CALENDAR: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(4u32);
impl ::std::convert::From<u32> for ENUM_DATE_FORMATS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_DATE_FORMATS_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_DATE_FORMATS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_DATE_FORMATS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENUM_SYSTEM_CODE_PAGES_FLAGS(pub u32);
pub const CP_INSTALLED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(1u32);
pub const CP_SUPPORTED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(2u32);
impl ::std::convert::From<u32> for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(pub u32);
pub const LGRPID_INSTALLED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS = ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(1u32);
pub const LGRPID_SUPPORTED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS = ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(2u32);
impl ::std::convert::From<u32> for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoA(lpcalinfoenumproc: ::std::option::Option<CALINFO_ENUMPROCA>, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoA(lpcalinfoenumproc: ::windows::runtime::RawPtr, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoA(::std::mem::transmute(lpcalinfoenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExA(lpcalinfoenumprocex: ::std::option::Option<CALINFO_ENUMPROCEXA>, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExA(lpcalinfoenumprocex: ::windows::runtime::RawPtr, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExA(::std::mem::transmute(lpcalinfoenumprocex), ::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param5: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(pcalinfoenumprocexex: ::std::option::Option<CALINFO_ENUMPROCEXEX>, lplocalename: Param1, calendar: u32, lpreserved: Param3, caltype: u32, lparam: Param5) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExEx(pcalinfoenumprocexex: ::windows::runtime::RawPtr, lplocalename: super::Foundation::PWSTR, calendar: u32, lpreserved: super::Foundation::PWSTR, caltype: u32, lparam: super::Foundation::LPARAM) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExEx(::std::mem::transmute(pcalinfoenumprocexex), lplocalename.into_param().abi(), ::std::mem::transmute(calendar), lpreserved.into_param().abi(), ::std::mem::transmute(caltype), lparam.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExW(lpcalinfoenumprocex: ::std::option::Option<CALINFO_ENUMPROCEXW>, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExW(lpcalinfoenumprocex: ::windows::runtime::RawPtr, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExW(::std::mem::transmute(lpcalinfoenumprocex), ::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoW(lpcalinfoenumproc: ::std::option::Option<CALINFO_ENUMPROCW>, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoW(lpcalinfoenumproc: ::windows::runtime::RawPtr, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoW(::std::mem::transmute(lpcalinfoenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsA(lpdatefmtenumproc: ::std::option::Option<DATEFMT_ENUMPROCA>, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsA(lpdatefmtenumproc: ::windows::runtime::RawPtr, locale: u32, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsA(::std::mem::transmute(lpdatefmtenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExA(lpdatefmtenumprocex: ::std::option::Option<DATEFMT_ENUMPROCEXA>, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExA(lpdatefmtenumprocex: ::windows::runtime::RawPtr, locale: u32, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExA(::std::mem::transmute(lpdatefmtenumprocex), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(lpdatefmtenumprocexex: ::std::option::Option<DATEFMT_ENUMPROCEXEX>, lplocalename: Param1, dwflags: ENUM_DATE_FORMATS_FLAGS, lparam: Param3) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExEx(lpdatefmtenumprocexex: ::windows::runtime::RawPtr, lplocalename: super::Foundation::PWSTR, dwflags: ENUM_DATE_FORMATS_FLAGS, lparam: super::Foundation::LPARAM) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExEx(::std::mem::transmute(lpdatefmtenumprocexex), lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), lparam.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExW(lpdatefmtenumprocex: ::std::option::Option<DATEFMT_ENUMPROCEXW>, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExW(lpdatefmtenumprocex: ::windows::runtime::RawPtr, locale: u32, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExW(::std::mem::transmute(lpdatefmtenumprocex), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsW(lpdatefmtenumproc: ::std::option::Option<DATEFMT_ENUMPROCW>, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsW(lpdatefmtenumproc: ::windows::runtime::RawPtr, locale: u32, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsW(::std::mem::transmute(lpdatefmtenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumLanguageGroupLocalesA(lplanggrouplocaleenumproc: ::std::option::Option<LANGGROUPLOCALE_ENUMPROCA>, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumLanguageGroupLocalesA(lplanggrouplocaleenumproc: ::windows::runtime::RawPtr, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumLanguageGroupLocalesA(::std::mem::transmute(lplanggrouplocaleenumproc), ::std::mem::transmute(languagegroup), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumLanguageGroupLocalesW(lplanggrouplocaleenumproc: ::std::option::Option<LANGGROUPLOCALE_ENUMPROCW>, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumLanguageGroupLocalesW(lplanggrouplocaleenumproc: ::windows::runtime::RawPtr, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumLanguageGroupLocalesW(::std::mem::transmute(lplanggrouplocaleenumproc), ::std::mem::transmute(languagegroup), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemCodePagesA(lpcodepageenumproc: ::std::option::Option<CODEPAGE_ENUMPROCA>, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemCodePagesA(lpcodepageenumproc: ::windows::runtime::RawPtr, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemCodePagesA(::std::mem::transmute(lpcodepageenumproc), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemCodePagesW(lpcodepageenumproc: ::std::option::Option<CODEPAGE_ENUMPROCW>, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemCodePagesW(lpcodepageenumproc: ::windows::runtime::RawPtr, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemCodePagesW(::std::mem::transmute(lpcodepageenumproc), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemGeoID(geoclass: u32, parentgeoid: i32, lpgeoenumproc: ::std::option::Option<GEO_ENUMPROC>) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemGeoID(geoclass: u32, parentgeoid: i32, lpgeoenumproc: ::windows::runtime::RawPtr) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemGeoID(::std::mem::transmute(geoclass), ::std::mem::transmute(parentgeoid), ::std::mem::transmute(lpgeoenumproc)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemGeoNames<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(geoclass: u32, geoenumproc: ::std::option::Option<GEO_ENUMNAMEPROC>, data: Param2) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemGeoNames(geoclass: u32, geoenumproc: ::windows::runtime::RawPtr, data: super::Foundation::LPARAM) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemGeoNames(::std::mem::transmute(geoclass), ::std::mem::transmute(geoenumproc), data.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLanguageGroupsA(lplanguagegroupenumproc: ::std::option::Option<LANGUAGEGROUP_ENUMPROCA>, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLanguageGroupsA(lplanguagegroupenumproc: ::windows::runtime::RawPtr, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLanguageGroupsA(::std::mem::transmute(lplanguagegroupenumproc), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLanguageGroupsW(lplanguagegroupenumproc: ::std::option::Option<LANGUAGEGROUP_ENUMPROCW>, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLanguageGroupsW(lplanguagegroupenumproc: ::windows::runtime::RawPtr, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLanguageGroupsW(::std::mem::transmute(lplanguagegroupenumproc), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesA(lplocaleenumproc: ::std::option::Option<LOCALE_ENUMPROCA>, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesA(lplocaleenumproc: ::windows::runtime::RawPtr, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesA(::std::mem::transmute(lplocaleenumproc), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesEx<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(lplocaleenumprocex: ::std::option::Option<LOCALE_ENUMPROCEX>, dwflags: u32, lparam: Param2, lpreserved: *const ::std::ffi::c_void) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesEx(lplocaleenumprocex: ::windows::runtime::RawPtr, dwflags: u32, lparam: super::Foundation::LPARAM, lpreserved: *const ::std::ffi::c_void) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesEx(::std::mem::transmute(lplocaleenumprocex), ::std::mem::transmute(dwflags), lparam.into_param().abi(), ::std::mem::transmute(lpreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesW(lplocaleenumproc: ::std::option::Option<LOCALE_ENUMPROCW>, dwflags: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesW(lplocaleenumproc: ::windows::runtime::RawPtr, dwflags: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesW(::std::mem::transmute(lplocaleenumproc), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsA(lptimefmtenumproc: ::std::option::Option<TIMEFMT_ENUMPROCA>, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsA(lptimefmtenumproc: ::windows::runtime::RawPtr, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsA(::std::mem::transmute(lptimefmtenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(lptimefmtenumprocex: ::std::option::Option<TIMEFMT_ENUMPROCEX>, lplocalename: Param1, dwflags: u32, lparam: Param3) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsEx(lptimefmtenumprocex: ::windows::runtime::RawPtr, lplocalename: super::Foundation::PWSTR, dwflags: u32, lparam: super::Foundation::LPARAM) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsEx(::std::mem::transmute(lptimefmtenumprocex), lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), lparam.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsW(lptimefmtenumproc: ::std::option::Option<TIMEFMT_ENUMPROCW>, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsW(lptimefmtenumproc: ::windows::runtime::RawPtr, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsW(::std::mem::transmute(lptimefmtenumproc), ::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumUILanguagesA(lpuilanguageenumproc: ::std::option::Option<UILANGUAGE_ENUMPROCA>, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumUILanguagesA(lpuilanguageenumproc: ::windows::runtime::RawPtr, dwflags: u32, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumUILanguagesA(::std::mem::transmute(lpuilanguageenumproc), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumUILanguagesW(lpuilanguageenumproc: ::std::option::Option<UILANGUAGE_ENUMPROCW>, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumUILanguagesW(lpuilanguageenumproc: ::windows::runtime::RawPtr, dwflags: u32, lparam: isize) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumUILanguagesW(::std::mem::transmute(lpuilanguageenumproc), ::std::mem::transmute(dwflags), ::std::mem::transmute(lparam)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct FILEMUIINFO {
    pub dwSize: u32,
    pub dwVersion: u32,
    pub dwFileType: u32,
    pub pChecksum: [u8; 16],
    pub pServiceChecksum: [u8; 16],
    pub dwLanguageNameOffset: u32,
    pub dwTypeIDMainSize: u32,
    pub dwTypeIDMainOffset: u32,
    pub dwTypeNameMainOffset: u32,
    pub dwTypeIDMUISize: u32,
    pub dwTypeIDMUIOffset: u32,
    pub dwTypeNameMUIOffset: u32,
    pub abBuffer: [u8; 8],
}
impl FILEMUIINFO {}
impl ::std::default::Default for FILEMUIINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FILEMUIINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FILEMUIINFO")
            .field("dwSize", &self.dwSize)
            .field("dwVersion", &self.dwVersion)
            .field("dwFileType", &self.dwFileType)
            .field("pChecksum", &self.pChecksum)
            .field("pServiceChecksum", &self.pServiceChecksum)
            .field("dwLanguageNameOffset", &self.dwLanguageNameOffset)
            .field("dwTypeIDMainSize", &self.dwTypeIDMainSize)
            .field("dwTypeIDMainOffset", &self.dwTypeIDMainOffset)
            .field("dwTypeNameMainOffset", &self.dwTypeNameMainOffset)
            .field("dwTypeIDMUISize", &self.dwTypeIDMUISize)
            .field("dwTypeIDMUIOffset", &self.dwTypeIDMUIOffset)
            .field("dwTypeNameMUIOffset", &self.dwTypeNameMUIOffset)
            .field("abBuffer", &self.abBuffer)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FILEMUIINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwVersion == other.dwVersion
            && self.dwFileType == other.dwFileType
            && self.pChecksum == other.pChecksum
            && self.pServiceChecksum == other.pServiceChecksum
            && self.dwLanguageNameOffset == other.dwLanguageNameOffset
            && self.dwTypeIDMainSize == other.dwTypeIDMainSize
            && self.dwTypeIDMainOffset == other.dwTypeIDMainOffset
            && self.dwTypeNameMainOffset == other.dwTypeNameMainOffset
            && self.dwTypeIDMUISize == other.dwTypeIDMUISize
            && self.dwTypeIDMUIOffset == other.dwTypeIDMUIOffset
            && self.dwTypeNameMUIOffset == other.dwTypeNameMUIOffset
            && self.abBuffer == other.abBuffer
    }
}
impl ::std::cmp::Eq for FILEMUIINFO {}
unsafe impl ::windows::runtime::Abi for FILEMUIINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const FIND_ENDSWITH: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const FIND_FROMEND: u32 = 8388608u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const FIND_FROMSTART: u32 = 4194304u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const FIND_STARTSWITH: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct FOLD_STRING_MAP_FLAGS(pub u32);
pub const MAP_COMPOSITE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(64u32);
pub const MAP_EXPAND_LIGATURES: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(8192u32);
pub const MAP_FOLDCZONE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(16u32);
pub const MAP_FOLDDIGITS: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(128u32);
pub const MAP_PRECOMPOSED: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(32u32);
impl ::std::convert::From<u32> for FOLD_STRING_MAP_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLD_STRING_MAP_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for FOLD_STRING_MAP_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for FOLD_STRING_MAP_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct FONTSIGNATURE {
    pub fsUsb: [u32; 4],
    pub fsCsb: [u32; 2],
}
impl FONTSIGNATURE {}
impl ::std::default::Default for FONTSIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FONTSIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FONTSIGNATURE").field("fsUsb", &self.fsUsb).field("fsCsb", &self.fsCsb).finish()
    }
}
impl ::std::cmp::PartialEq for FONTSIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.fsUsb == other.fsUsb && self.fsCsb == other.fsCsb
    }
}
impl ::std::cmp::Eq for FONTSIGNATURE {}
unsafe impl ::windows::runtime::Abi for FONTSIGNATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindNLSString<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwfindnlsstringflags: u32, lpstringsource: Param2, cchsource: i32, lpstringvalue: Param4, cchvalue: i32, pcchfound: *mut i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindNLSString(locale: u32, dwfindnlsstringflags: u32, lpstringsource: super::Foundation::PWSTR, cchsource: i32, lpstringvalue: super::Foundation::PWSTR, cchvalue: i32, pcchfound: *mut i32) -> i32;
        }
        ::std::mem::transmute(FindNLSString(::std::mem::transmute(locale), ::std::mem::transmute(dwfindnlsstringflags), lpstringsource.into_param().abi(), ::std::mem::transmute(cchsource), lpstringvalue.into_param().abi(), ::std::mem::transmute(cchvalue), ::std::mem::transmute(pcchfound)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindNLSStringEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param9: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(
    lplocalename: Param0,
    dwfindnlsstringflags: u32,
    lpstringsource: Param2,
    cchsource: i32,
    lpstringvalue: Param4,
    cchvalue: i32,
    pcchfound: *mut i32,
    lpversioninformation: *const NLSVERSIONINFO,
    lpreserved: *const ::std::ffi::c_void,
    sorthandle: Param9,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindNLSStringEx(lplocalename: super::Foundation::PWSTR, dwfindnlsstringflags: u32, lpstringsource: super::Foundation::PWSTR, cchsource: i32, lpstringvalue: super::Foundation::PWSTR, cchvalue: i32, pcchfound: *mut i32, lpversioninformation: *const NLSVERSIONINFO, lpreserved: *const ::std::ffi::c_void, sorthandle: super::Foundation::LPARAM) -> i32;
        }
        ::std::mem::transmute(FindNLSStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwfindnlsstringflags),
            lpstringsource.into_param().abi(),
            ::std::mem::transmute(cchsource),
            lpstringvalue.into_param().abi(),
            ::std::mem::transmute(cchvalue),
            ::std::mem::transmute(pcchfound),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            sorthandle.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindStringOrdinal<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param5: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(dwfindstringordinalflags: u32, lpstringsource: Param1, cchsource: i32, lpstringvalue: Param3, cchvalue: i32, bignorecase: Param5) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindStringOrdinal(dwfindstringordinalflags: u32, lpstringsource: super::Foundation::PWSTR, cchsource: i32, lpstringvalue: super::Foundation::PWSTR, cchvalue: i32, bignorecase: super::Foundation::BOOL) -> i32;
        }
        ::std::mem::transmute(FindStringOrdinal(::std::mem::transmute(dwfindstringordinalflags), lpstringsource.into_param().abi(), ::std::mem::transmute(cchsource), lpstringvalue.into_param().abi(), ::std::mem::transmute(cchvalue), bignorecase.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FoldStringA<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: Param1, cchsrc: i32, lpdeststr: super::Foundation::PSTR, cchdest: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FoldStringA(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: super::Foundation::PSTR, cchsrc: i32, lpdeststr: super::Foundation::PSTR, cchdest: i32) -> i32;
        }
        ::std::mem::transmute(FoldStringA(::std::mem::transmute(dwmapflags), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpdeststr), ::std::mem::transmute(cchdest)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FoldStringW<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: Param1, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FoldStringW(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: super::Foundation::PWSTR, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32) -> i32;
        }
        ::std::mem::transmute(FoldStringW(::std::mem::transmute(dwmapflags), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpdeststr), ::std::mem::transmute(cchdest)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const GEOID_NOT_AVAILABLE: i32 = -1i32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type GEO_ENUMNAMEPROC = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: super::Foundation::LPARAM) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type GEO_ENUMPROC = unsafe extern "system" fn(param0: i32) -> super::Foundation::BOOL;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct GOFFSET {
    pub du: i32,
    pub dv: i32,
}
impl GOFFSET {}
impl ::std::default::Default for GOFFSET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for GOFFSET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("GOFFSET").field("du", &self.du).field("dv", &self.dv).finish()
    }
}
impl ::std::cmp::PartialEq for GOFFSET {
    fn eq(&self, other: &Self) -> bool {
        self.du == other.du && self.dv == other.dv
    }
}
impl ::std::cmp::Eq for GOFFSET {}
unsafe impl ::windows::runtime::Abi for GOFFSET {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const GSS_ALLOW_INHERITED_COMMON: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetACP() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetACP() -> u32;
        }
        ::std::mem::transmute(GetACP())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfo(codepage: u32, lpcpinfo: *mut CPINFO) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfo(codepage: u32, lpcpinfo: *mut CPINFO) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfo(::std::mem::transmute(codepage), ::std::mem::transmute(lpcpinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfoExA(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXA) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfoExA(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXA) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfoExA(::std::mem::transmute(codepage), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpcpinfoex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfoExW(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXW) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfoExW(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXW) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfoExW(::std::mem::transmute(codepage), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpcpinfoex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCalendarInfoA(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PSTR, cchdata: i32, lpvalue: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoA(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PSTR, cchdata: i32, lpvalue: *mut u32) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoA(::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype), ::std::mem::transmute(lpcaldata), ::std::mem::transmute(cchdata), ::std::mem::transmute(lpvalue)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCalendarInfoEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, calendar: u32, lpreserved: Param2, caltype: u32, lpcaldata: super::Foundation::PWSTR, cchdata: i32, lpvalue: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoEx(lplocalename: super::Foundation::PWSTR, calendar: u32, lpreserved: super::Foundation::PWSTR, caltype: u32, lpcaldata: super::Foundation::PWSTR, cchdata: i32, lpvalue: *mut u32) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoEx(lplocalename.into_param().abi(), ::std::mem::transmute(calendar), lpreserved.into_param().abi(), ::std::mem::transmute(caltype), ::std::mem::transmute(lpcaldata), ::std::mem::transmute(cchdata), ::std::mem::transmute(lpvalue)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCalendarInfoW(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PWSTR, cchdata: i32, lpvalue: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoW(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PWSTR, cchdata: i32, lpvalue: *mut u32) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoW(::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype), ::std::mem::transmute(lpcaldata), ::std::mem::transmute(cchdata), ::std::mem::transmute(lpvalue)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCurrencyFormatA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwflags: u32, lpvalue: Param2, lpformat: *const CURRENCYFMTA, lpcurrencystr: super::Foundation::PSTR, cchcurrency: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatA(locale: u32, dwflags: u32, lpvalue: super::Foundation::PSTR, lpformat: *const CURRENCYFMTA, lpcurrencystr: super::Foundation::PSTR, cchcurrency: i32) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatA(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpcurrencystr), ::std::mem::transmute(cchcurrency)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCurrencyFormatEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, dwflags: u32, lpvalue: Param2, lpformat: *const CURRENCYFMTW, lpcurrencystr: super::Foundation::PWSTR, cchcurrency: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatEx(lplocalename: super::Foundation::PWSTR, dwflags: u32, lpvalue: super::Foundation::PWSTR, lpformat: *const CURRENCYFMTW, lpcurrencystr: super::Foundation::PWSTR, cchcurrency: i32) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatEx(lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpcurrencystr), ::std::mem::transmute(cchcurrency)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCurrencyFormatW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwflags: u32, lpvalue: Param2, lpformat: *const CURRENCYFMTW, lpcurrencystr: super::Foundation::PWSTR, cchcurrency: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatW(locale: u32, dwflags: u32, lpvalue: super::Foundation::PWSTR, lpformat: *const CURRENCYFMTW, lpcurrencystr: super::Foundation::PWSTR, cchcurrency: i32) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatW(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpcurrencystr), ::std::mem::transmute(cchcurrency)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatA<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwflags: u32, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lpdatestr: super::Foundation::PSTR, cchdate: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatA(locale: u32, dwflags: u32, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PSTR, lpdatestr: super::Foundation::PSTR, cchdate: i32) -> i32;
        }
        ::std::mem::transmute(GetDateFormatA(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpdate), lpformat.into_param().abi(), ::std::mem::transmute(lpdatestr), ::std::mem::transmute(cchdate)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param6: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, dwflags: ENUM_DATE_FORMATS_FLAGS, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lpdatestr: super::Foundation::PWSTR, cchdate: i32, lpcalendar: Param6) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatEx(lplocalename: super::Foundation::PWSTR, dwflags: ENUM_DATE_FORMATS_FLAGS, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PWSTR, lpdatestr: super::Foundation::PWSTR, cchdate: i32, lpcalendar: super::Foundation::PWSTR) -> i32;
        }
        ::std::mem::transmute(GetDateFormatEx(lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpdate), lpformat.into_param().abi(), ::std::mem::transmute(lpdatestr), ::std::mem::transmute(cchdate), lpcalendar.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatW<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwflags: u32, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lpdatestr: super::Foundation::PWSTR, cchdate: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatW(locale: u32, dwflags: u32, lpdate: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PWSTR, lpdatestr: super::Foundation::PWSTR, cchdate: i32) -> i32;
        }
        ::std::mem::transmute(GetDateFormatW(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpdate), lpformat.into_param().abi(), ::std::mem::transmute(lpdatestr), ::std::mem::transmute(cchdate)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDistanceOfClosestLanguageInList<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pszlanguage: Param0, pszlanguageslist: Param1, wchlistdelimiter: u16) -> ::windows::runtime::Result<f64> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDistanceOfClosestLanguageInList(pszlanguage: super::Foundation::PWSTR, pszlanguageslist: super::Foundation::PWSTR, wchlistdelimiter: u16, pclosestdistance: *mut f64) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        GetDistanceOfClosestLanguageInList(pszlanguage.into_param().abi(), pszlanguageslist.into_param().abi(), ::std::mem::transmute(wchlistdelimiter), &mut result__).from_abi::<f64>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDurationFormat<'a, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwflags: u32, lpduration: *const super::Foundation::SYSTEMTIME, ullduration: u64, lpformat: Param4, lpdurationstr: super::Foundation::PWSTR, cchduration: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDurationFormat(locale: u32, dwflags: u32, lpduration: *const super::Foundation::SYSTEMTIME, ullduration: u64, lpformat: super::Foundation::PWSTR, lpdurationstr: super::Foundation::PWSTR, cchduration: i32) -> i32;
        }
        ::std::mem::transmute(GetDurationFormat(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpduration), ::std::mem::transmute(ullduration), lpformat.into_param().abi(), ::std::mem::transmute(lpdurationstr), ::std::mem::transmute(cchduration)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDurationFormatEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, dwflags: u32, lpduration: *const super::Foundation::SYSTEMTIME, ullduration: u64, lpformat: Param4, lpdurationstr: super::Foundation::PWSTR, cchduration: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDurationFormatEx(lplocalename: super::Foundation::PWSTR, dwflags: u32, lpduration: *const super::Foundation::SYSTEMTIME, ullduration: u64, lpformat: super::Foundation::PWSTR, lpdurationstr: super::Foundation::PWSTR, cchduration: i32) -> i32;
        }
        ::std::mem::transmute(GetDurationFormatEx(lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpduration), ::std::mem::transmute(ullduration), lpformat.into_param().abi(), ::std::mem::transmute(lpdurationstr), ::std::mem::transmute(cchduration)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileMUIInfo<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pcwszfilepath: Param1, pfilemuiinfo: *mut FILEMUIINFO, pcbfilemuiinfo: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetFileMUIInfo(dwflags: u32, pcwszfilepath: super::Foundation::PWSTR, pfilemuiinfo: *mut FILEMUIINFO, pcbfilemuiinfo: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFileMUIInfo(::std::mem::transmute(dwflags), pcwszfilepath.into_param().abi(), ::std::mem::transmute(pfilemuiinfo), ::std::mem::transmute(pcbfilemuiinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileMUIPath<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pcwszfilepath: Param1, pwszlanguage: Param2, pcchlanguage: *mut u32, pwszfilemuipath: super::Foundation::PWSTR, pcchfilemuipath: *mut u32, pululenumerator: *mut u64) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetFileMUIPath(dwflags: u32, pcwszfilepath: super::Foundation::PWSTR, pwszlanguage: super::Foundation::PWSTR, pcchlanguage: *mut u32, pwszfilemuipath: super::Foundation::PWSTR, pcchfilemuipath: *mut u32, pululenumerator: *mut u64) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFileMUIPath(::std::mem::transmute(dwflags), pcwszfilepath.into_param().abi(), pwszlanguage.into_param().abi(), ::std::mem::transmute(pcchlanguage), ::std::mem::transmute(pwszfilemuipath), ::std::mem::transmute(pcchfilemuipath), ::std::mem::transmute(pululenumerator)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetGeoInfoA(location: i32, geotype: u32, lpgeodata: super::Foundation::PSTR, cchdata: i32, langid: u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoA(location: i32, geotype: u32, lpgeodata: super::Foundation::PSTR, cchdata: i32, langid: u16) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoA(::std::mem::transmute(location), ::std::mem::transmute(geotype), ::std::mem::transmute(lpgeodata), ::std::mem::transmute(cchdata), ::std::mem::transmute(langid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetGeoInfoEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(location: Param0, geotype: u32, geodata: super::Foundation::PWSTR, geodatacount: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoEx(location: super::Foundation::PWSTR, geotype: u32, geodata: super::Foundation::PWSTR, geodatacount: i32) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoEx(location.into_param().abi(), ::std::mem::transmute(geotype), ::std::mem::transmute(geodata), ::std::mem::transmute(geodatacount)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetGeoInfoW(location: i32, geotype: u32, lpgeodata: super::Foundation::PWSTR, cchdata: i32, langid: u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoW(location: i32, geotype: u32, lpgeodata: super::Foundation::PWSTR, cchdata: i32, langid: u16) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoW(::std::mem::transmute(location), ::std::mem::transmute(geotype), ::std::mem::transmute(lpgeodata), ::std::mem::transmute(cchdata), ::std::mem::transmute(langid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetLocaleInfoA(locale: u32, lctype: u32, lplcdata: super::Foundation::PSTR, cchdata: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoA(locale: u32, lctype: u32, lplcdata: super::Foundation::PSTR, cchdata: i32) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoA(::std::mem::transmute(locale), ::std::mem::transmute(lctype), ::std::mem::transmute(lplcdata), ::std::mem::transmute(cchdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetLocaleInfoEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, lctype: u32, lplcdata: super::Foundation::PWSTR, cchdata: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoEx(lplocalename: super::Foundation::PWSTR, lctype: u32, lplcdata: super::Foundation::PWSTR, cchdata: i32) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoEx(lplocalename.into_param().abi(), ::std::mem::transmute(lctype), ::std::mem::transmute(lplcdata), ::std::mem::transmute(cchdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetLocaleInfoW(locale: u32, lctype: u32, lplcdata: super::Foundation::PWSTR, cchdata: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoW(locale: u32, lctype: u32, lplcdata: super::Foundation::PWSTR, cchdata: i32) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoW(::std::mem::transmute(locale), ::std::mem::transmute(lctype), ::std::mem::transmute(lplcdata), ::std::mem::transmute(cchdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNLSVersion(function: u32, locale: u32, lpversioninformation: *mut NLSVERSIONINFO) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNLSVersion(function: u32, locale: u32, lpversioninformation: *mut NLSVERSIONINFO) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetNLSVersion(::std::mem::transmute(function), ::std::mem::transmute(locale), ::std::mem::transmute(lpversioninformation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNLSVersionEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(function: u32, lplocalename: Param1, lpversioninformation: *mut NLSVERSIONINFOEX) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNLSVersionEx(function: u32, lplocalename: super::Foundation::PWSTR, lpversioninformation: *mut NLSVERSIONINFOEX) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetNLSVersionEx(::std::mem::transmute(function), lplocalename.into_param().abi(), ::std::mem::transmute(lpversioninformation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNumberFormatA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwflags: u32, lpvalue: Param2, lpformat: *const NUMBERFMTA, lpnumberstr: super::Foundation::PSTR, cchnumber: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatA(locale: u32, dwflags: u32, lpvalue: super::Foundation::PSTR, lpformat: *const NUMBERFMTA, lpnumberstr: super::Foundation::PSTR, cchnumber: i32) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatA(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpnumberstr), ::std::mem::transmute(cchnumber)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNumberFormatEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, dwflags: u32, lpvalue: Param2, lpformat: *const NUMBERFMTW, lpnumberstr: super::Foundation::PWSTR, cchnumber: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatEx(lplocalename: super::Foundation::PWSTR, dwflags: u32, lpvalue: super::Foundation::PWSTR, lpformat: *const NUMBERFMTW, lpnumberstr: super::Foundation::PWSTR, cchnumber: i32) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatEx(lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpnumberstr), ::std::mem::transmute(cchnumber)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNumberFormatW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwflags: u32, lpvalue: Param2, lpformat: *const NUMBERFMTW, lpnumberstr: super::Foundation::PWSTR, cchnumber: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatW(locale: u32, dwflags: u32, lpvalue: super::Foundation::PWSTR, lpformat: *const NUMBERFMTW, lpnumberstr: super::Foundation::PWSTR, cchnumber: i32) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatW(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), lpvalue.into_param().abi(), ::std::mem::transmute(lpformat), ::std::mem::transmute(lpnumberstr), ::std::mem::transmute(cchnumber)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetOEMCP() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetOEMCP() -> u32;
        }
        ::std::mem::transmute(GetOEMCP())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProcessPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetProcessPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetProcessPreferredUILanguages(::std::mem::transmute(dwflags), ::std::mem::transmute(pulnumlanguages), ::std::mem::transmute(pwszlanguagesbuffer), ::std::mem::transmute(pcchlanguagesbuffer)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringScripts<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, lpstring: Param1, cchstring: i32, lpscripts: super::Foundation::PWSTR, cchscripts: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringScripts(dwflags: u32, lpstring: super::Foundation::PWSTR, cchstring: i32, lpscripts: super::Foundation::PWSTR, cchscripts: i32) -> i32;
        }
        ::std::mem::transmute(GetStringScripts(::std::mem::transmute(dwflags), lpstring.into_param().abi(), ::std::mem::transmute(cchstring), ::std::mem::transmute(lpscripts), ::std::mem::transmute(cchscripts)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwinfotype: u32, lpsrcstr: Param2, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeA(locale: u32, dwinfotype: u32, lpsrcstr: super::Foundation::PSTR, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeA(::std::mem::transmute(locale), ::std::mem::transmute(dwinfotype), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpchartype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeExA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwinfotype: u32, lpsrcstr: Param2, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeExA(locale: u32, dwinfotype: u32, lpsrcstr: super::Foundation::PSTR, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeExA(::std::mem::transmute(locale), ::std::mem::transmute(dwinfotype), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpchartype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeExW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwinfotype: u32, lpsrcstr: Param2, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeExW(locale: u32, dwinfotype: u32, lpsrcstr: super::Foundation::PWSTR, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeExW(::std::mem::transmute(locale), ::std::mem::transmute(dwinfotype), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpchartype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeW<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwinfotype: u32, lpsrcstr: Param1, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeW(dwinfotype: u32, lpsrcstr: super::Foundation::PWSTR, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeW(::std::mem::transmute(dwinfotype), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpchartype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetSystemDefaultLCID() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLCID() -> u32;
        }
        ::std::mem::transmute(GetSystemDefaultLCID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetSystemDefaultLangID() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLangID() -> u16;
        }
        ::std::mem::transmute(GetSystemDefaultLangID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetSystemDefaultLocaleName(lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLocaleName(lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32;
        }
        ::std::mem::transmute(GetSystemDefaultLocaleName(::std::mem::transmute(lplocalename), ::std::mem::transmute(cchlocalename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetSystemDefaultUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultUILanguage() -> u16;
        }
        ::std::mem::transmute(GetSystemDefaultUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetSystemPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetSystemPreferredUILanguages(::std::mem::transmute(dwflags), ::std::mem::transmute(pulnumlanguages), ::std::mem::transmute(pwszlanguagesbuffer), ::std::mem::transmute(pcchlanguagesbuffer)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn GetTextCharset<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTextCharset(hdc: super::Graphics::Gdi::HDC) -> i32;
        }
        ::std::mem::transmute(GetTextCharset(hdc.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn GetTextCharsetInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, lpsig: *mut FONTSIGNATURE, dwflags: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTextCharsetInfo(hdc: super::Graphics::Gdi::HDC, lpsig: *mut FONTSIGNATURE, dwflags: u32) -> i32;
        }
        ::std::mem::transmute(GetTextCharsetInfo(hdc.into_param().abi(), ::std::mem::transmute(lpsig), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetThreadLocale() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadLocale() -> u32;
        }
        ::std::mem::transmute(GetThreadLocale())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetThreadPreferredUILanguages(::std::mem::transmute(dwflags), ::std::mem::transmute(pulnumlanguages), ::std::mem::transmute(pwszlanguagesbuffer), ::std::mem::transmute(pcchlanguagesbuffer)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetThreadUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadUILanguage() -> u16;
        }
        ::std::mem::transmute(GetThreadUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatA<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwflags: u32, lptime: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lptimestr: super::Foundation::PSTR, cchtime: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatA(locale: u32, dwflags: u32, lptime: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PSTR, lptimestr: super::Foundation::PSTR, cchtime: i32) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatA(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), ::std::mem::transmute(lptime), lpformat.into_param().abi(), ::std::mem::transmute(lptimestr), ::std::mem::transmute(cchtime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0, dwflags: TIME_FORMAT_FLAGS, lptime: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lptimestr: super::Foundation::PWSTR, cchtime: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatEx(lplocalename: super::Foundation::PWSTR, dwflags: TIME_FORMAT_FLAGS, lptime: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PWSTR, lptimestr: super::Foundation::PWSTR, cchtime: i32) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatEx(lplocalename.into_param().abi(), ::std::mem::transmute(dwflags), ::std::mem::transmute(lptime), lpformat.into_param().abi(), ::std::mem::transmute(lptimestr), ::std::mem::transmute(cchtime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatW<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwflags: u32, lptime: *const super::Foundation::SYSTEMTIME, lpformat: Param3, lptimestr: super::Foundation::PWSTR, cchtime: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatW(locale: u32, dwflags: u32, lptime: *const super::Foundation::SYSTEMTIME, lpformat: super::Foundation::PWSTR, lptimestr: super::Foundation::PWSTR, cchtime: i32) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatW(::std::mem::transmute(locale), ::std::mem::transmute(dwflags), ::std::mem::transmute(lptime), lpformat.into_param().abi(), ::std::mem::transmute(lptimestr), ::std::mem::transmute(cchtime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUILanguageInfo<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pwmszlanguage: Param1, pwszfallbacklanguages: super::Foundation::PWSTR, pcchfallbacklanguages: *mut u32, pattributes: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUILanguageInfo(dwflags: u32, pwmszlanguage: super::Foundation::PWSTR, pwszfallbacklanguages: super::Foundation::PWSTR, pcchfallbacklanguages: *mut u32, pattributes: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUILanguageInfo(::std::mem::transmute(dwflags), pwmszlanguage.into_param().abi(), ::std::mem::transmute(pwszfallbacklanguages), ::std::mem::transmute(pcchfallbacklanguages), ::std::mem::transmute(pattributes)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserDefaultGeoName(geoname: super::Foundation::PWSTR, geonamecount: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultGeoName(geoname: super::Foundation::PWSTR, geonamecount: i32) -> i32;
        }
        ::std::mem::transmute(GetUserDefaultGeoName(::std::mem::transmute(geoname), ::std::mem::transmute(geonamecount)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetUserDefaultLCID() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLCID() -> u32;
        }
        ::std::mem::transmute(GetUserDefaultLCID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetUserDefaultLangID() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLangID() -> u16;
        }
        ::std::mem::transmute(GetUserDefaultLangID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserDefaultLocaleName(lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLocaleName(lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32;
        }
        ::std::mem::transmute(GetUserDefaultLocaleName(::std::mem::transmute(lplocalename), ::std::mem::transmute(cchlocalename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetUserDefaultUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultUILanguage() -> u16;
        }
        ::std::mem::transmute(GetUserDefaultUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn GetUserGeoID(geoclass: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserGeoID(geoclass: u32) -> i32;
        }
        ::std::mem::transmute(GetUserGeoID(::std::mem::transmute(geoclass)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUserPreferredUILanguages(::std::mem::transmute(dwflags), ::std::mem::transmute(pulnumlanguages), ::std::mem::transmute(pwszlanguagesbuffer), ::std::mem::transmute(pcchlanguagesbuffer)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const HIGHLEVEL_SERVICE_TYPES: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const HIGH_SURROGATE_END: u32 = 56319u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const HIGH_SURROGATE_START: u32 = 55296u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HIMC(pub isize);
impl ::std::default::Default for HIMC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HIMC {}
unsafe impl ::windows::runtime::Abi for HIMC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HIMCC(pub isize);
impl ::std::default::Default for HIMCC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HIMCC {}
unsafe impl ::windows::runtime::Abi for HIMCC {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq)]
#[repr(transparent)]
pub struct HSAVEDUILANGUAGES(pub isize);
impl ::std::default::Default for HSAVEDUILANGUAGES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HSAVEDUILANGUAGES {}
unsafe impl ::windows::runtime::Abi for HSAVEDUILANGUAGES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IComprehensiveSpellCheckProvider(pub ::windows::runtime::IUnknown);
impl IComprehensiveSpellCheckProvider {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ComprehensiveCheck<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IComprehensiveSpellCheckProvider {
    type Vtable = IComprehensiveSpellCheckProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(207157470, 36500, 18334, [151, 23, 112, 196, 44, 74, 210, 195]);
}
impl ::std::convert::From<IComprehensiveSpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: IComprehensiveSpellCheckProvider) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IComprehensiveSpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IComprehensiveSpellCheckProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IComprehensiveSpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IComprehensiveSpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComprehensiveSpellCheckProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IDN_ALLOW_UNASSIGNED: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IDN_EMAIL_ADDRESS: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IDN_RAW_PUNYCODE: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IDN_USE_STD3_ASCII_RULES: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IEnumCodePage(pub ::windows::runtime::IUnknown);
impl IEnumCodePage {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IEnumCodePage>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut MIMECPINFO, pceltfetched: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt), ::std::mem::transmute(rgelt), ::std::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumCodePage {
    type Vtable = IEnumCodePage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(660349923, 14151, 4560, [159, 234, 0, 170, 0, 63, 134, 70]);
}
impl ::std::convert::From<IEnumCodePage> for ::windows::runtime::IUnknown {
    fn from(value: IEnumCodePage) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IEnumCodePage> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumCodePage) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumCodePage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IEnumCodePage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumCodePage_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppenum: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32, rgelt: *mut MIMECPINFO, pceltfetched: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IEnumRfc1766(pub ::windows::runtime::IUnknown);
impl IEnumRfc1766 {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IEnumRfc1766>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut RFC1766INFO, pceltfetched: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt), ::std::mem::transmute(rgelt), ::std::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumRfc1766 {
    type Vtable = IEnumRfc1766_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1036229917, 49200, 4560, [184, 27, 0, 192, 79, 201, 179, 31]);
}
impl ::std::convert::From<IEnumRfc1766> for ::windows::runtime::IUnknown {
    fn from(value: IEnumRfc1766) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IEnumRfc1766> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumRfc1766) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumRfc1766 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IEnumRfc1766 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRfc1766_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppenum: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32, rgelt: *mut RFC1766INFO, pceltfetched: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IEnumScript(pub ::windows::runtime::IUnknown);
impl IEnumScript {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IEnumScript>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut SCRIPTINFO, pceltfetched: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt), ::std::mem::transmute(rgelt), ::std::mem::transmute(pceltfetched)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(celt)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumScript {
    type Vtable = IEnumScript_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2925466672, 14475, 4562, [131, 128, 0, 192, 79, 143, 93, 161]);
}
impl ::std::convert::From<IEnumScript> for ::windows::runtime::IUnknown {
    fn from(value: IEnumScript) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IEnumScript> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumScript) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumScript {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IEnumScript {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumScript_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppenum: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32, rgelt: *mut SCRIPTINFO, pceltfetched: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, celt: u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IEnumSpellingError(pub ::windows::runtime::IUnknown);
impl IEnumSpellingError {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Next(&self) -> ::windows::runtime::Result<ISpellingError> {
        let mut result__: <ISpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<ISpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IEnumSpellingError {
    type Vtable = IEnumSpellingError_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2151562196, 10280, 17424, [130, 144, 65, 141, 29, 115, 199, 98]);
}
impl ::std::convert::From<IEnumSpellingError> for ::windows::runtime::IUnknown {
    fn from(value: IEnumSpellingError) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IEnumSpellingError> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumSpellingError) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumSpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IEnumSpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSpellingError_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_ALPHANUMERIC: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_CHARCODE: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_CHINESE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_FULLSHAPE: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_HANGUL: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_HANJACONVERT: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_JAPANESE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_KATAKANA: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_LANGUAGE: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_NATIVE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_NATIVESYMBOL: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const IME_CMODE_ROMAN: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangCodePages(pub ::windows::runtime::IUnknown);
impl IMLangCodePages {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(chsrc), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetStrCodePages<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pszsrc: Param0, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(dwprioritycodepages), ::std::mem::transmute(pdwcodepages), ::std::mem::transmute(pcchcodepages)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ucodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcodepages), ::std::mem::transmute(udefaultcodepage), &mut result__).from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMLangCodePages {
    type Vtable = IMLangCodePages_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(899626051, 48458, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangCodePages> for ::windows::runtime::IUnknown {
    fn from(value: IMLangCodePages) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangCodePages> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangCodePages) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangCodePages {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangCodePages {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangCodePages_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, chsrc: u16, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszsrc: super::Foundation::PWSTR, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ucodepage: u32, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcodepages: u32, udefaultcodepage: u32, pucodepage: *mut u32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangConvertCharset(pub ::windows::runtime::IUnknown);
impl IMLangConvertCharset {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Initialize(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(uisrccodepage), ::std::mem::transmute(uidstcodepage), ::std::mem::transmute(dwproperty)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetSourceCodePage(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetDestinationCodePage(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetProperty(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn DoConversion(&self, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(psrcstr), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn DoConversionToUnicode<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, psrcstr: Param0, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn DoConversionFromUnicode<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, psrcstr: Param0, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangConvertCharset {
    type Vtable = IMLangConvertCharset_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3597496216, 52650, 4560, [184, 34, 0, 192, 79, 201, 179, 31]);
}
impl ::std::convert::From<IMLangConvertCharset> for ::windows::runtime::IUnknown {
    fn from(value: IMLangConvertCharset) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangConvertCharset> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangConvertCharset) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangConvertCharset {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangConvertCharset {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangConvertCharset_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, puisrccodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, puidstcodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwproperty: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangFontLink(pub ::windows::runtime::IUnknown);
impl IMLangFontLink {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(chsrc), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetStrCodePages<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pszsrc: Param0, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(dwprioritycodepages), ::std::mem::transmute(pdwcodepages), ::std::mem::transmute(pcchcodepages)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ucodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcodepages), ::std::mem::transmute(udefaultcodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn GetFontCodePages<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param1: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>>(&self, hdc: Param0, hfont: Param1) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), hdc.into_param().abi(), hfont.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn MapFont<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param2: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>>(&self, hdc: Param0, dwcodepages: u32, hsrcfont: Param2) -> ::windows::runtime::Result<super::Graphics::Gdi::HFONT> {
        let mut result__: <super::Graphics::Gdi::HFONT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), hdc.into_param().abi(), ::std::mem::transmute(dwcodepages), hsrcfont.into_param().abi(), &mut result__).from_abi::<super::Graphics::Gdi::HFONT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn ReleaseFont<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>>(&self, hfont: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), hfont.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ResetFontMapping(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangFontLink {
    type Vtable = IMLangFontLink_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(899626049, 48458, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangFontLink> for ::windows::runtime::IUnknown {
    fn from(value: IMLangFontLink) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangFontLink> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangFontLink) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IMLangFontLink> for IMLangCodePages {
    fn from(value: IMLangFontLink) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink> for IMLangCodePages {
    fn from(value: &IMLangFontLink) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for &IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, chsrc: u16, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszsrc: super::Foundation::PWSTR, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ucodepage: u32, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcodepages: u32, udefaultcodepage: u32, pucodepage: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hdc: super::Graphics::Gdi::HDC, hfont: super::Graphics::Gdi::HFONT, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hdc: super::Graphics::Gdi::HDC, dwcodepages: u32, hsrcfont: super::Graphics::Gdi::HFONT, phdestfont: *mut super::Graphics::Gdi::HFONT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hfont: super::Graphics::Gdi::HFONT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangFontLink2(pub ::windows::runtime::IUnknown);
impl IMLangFontLink2 {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(chsrc), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetStrCodePages<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pszsrc: Param0, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(dwprioritycodepages), ::std::mem::transmute(pdwcodepages), ::std::mem::transmute(pcchcodepages)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ucodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwcodepages), ::std::mem::transmute(udefaultcodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn GetFontCodePages<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param1: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>>(&self, hdc: Param0, hfont: Param1) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), hdc.into_param().abi(), hfont.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn ReleaseFont<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>>(&self, hfont: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), hfont.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ResetFontMapping(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn MapFont<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(&self, hdc: Param0, dwcodepages: u32, chsrc: u16) -> ::windows::runtime::Result<super::Graphics::Gdi::HFONT> {
        let mut result__: <super::Graphics::Gdi::HFONT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), hdc.into_param().abi(), ::std::mem::transmute(dwcodepages), ::std::mem::transmute(chsrc), &mut result__).from_abi::<super::Graphics::Gdi::HFONT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
    pub unsafe fn GetFontUnicodeRanges<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(&self, hdc: Param0, puiranges: *const u32) -> ::windows::runtime::Result<UNICODERANGE> {
        let mut result__: <UNICODERANGE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), hdc.into_param().abi(), ::std::mem::transmute(puiranges), &mut result__).from_abi::<UNICODERANGE>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetScriptFontInfo(&self, sid: u8, dwflags: u32, puifonts: *mut u32, pscriptfont: *mut tagSCRIPFONTINFO) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(sid), ::std::mem::transmute(dwflags), ::std::mem::transmute(puifonts), ::std::mem::transmute(pscriptfont)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CodePageToScriptID(&self, uicodepage: u32) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), &mut result__).from_abi::<u8>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMLangFontLink2 {
    type Vtable = IMLangFontLink2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3704602978, 11064, 4562, [183, 236, 0, 192, 79, 143, 93, 154]);
}
impl ::std::convert::From<IMLangFontLink2> for ::windows::runtime::IUnknown {
    fn from(value: IMLangFontLink2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangFontLink2> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangFontLink2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IMLangFontLink2> for IMLangCodePages {
    fn from(value: IMLangFontLink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink2> for IMLangCodePages {
    fn from(value: &IMLangFontLink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for &IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, chsrc: u16, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszsrc: super::Foundation::PWSTR, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ucodepage: u32, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwcodepages: u32, udefaultcodepage: u32, pucodepage: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hdc: super::Graphics::Gdi::HDC, hfont: super::Graphics::Gdi::HFONT, pdwcodepages: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hfont: super::Graphics::Gdi::HFONT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hdc: super::Graphics::Gdi::HDC, dwcodepages: u32, chsrc: u16, pfont: *mut super::Graphics::Gdi::HFONT) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hdc: super::Graphics::Gdi::HDC, puiranges: *const u32, puranges: *mut UNICODERANGE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sid: u8, dwflags: u32, puifonts: *mut u32, pscriptfont: *mut tagSCRIPFONTINFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, psid: *mut u8) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangLineBreakConsole(pub ::windows::runtime::IUnknown);
impl IMLangLineBreakConsole {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn BreakLineML<'a, Param0: ::windows::runtime::IntoParam<'a, IMLangString>>(&self, psrcmlstr: Param0, lsrcpos: i32, lsrclen: i32, cmincolumns: i32, cmaxcolumns: i32, pllinelen: *mut i32, plskiplen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), psrcmlstr.into_param().abi(), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), ::std::mem::transmute(cmincolumns), ::std::mem::transmute(cmaxcolumns), ::std::mem::transmute(pllinelen), ::std::mem::transmute(plskiplen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn BreakLineW<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, locale: u32, pszsrc: Param1, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(cmaxcolumns), ::std::mem::transmute(pcchline), ::std::mem::transmute(pcchskip)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn BreakLineA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, locale: u32, ucodepage: u32, pszsrc: Param2, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), ::std::mem::transmute(ucodepage), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(cmaxcolumns), ::std::mem::transmute(pcchline), ::std::mem::transmute(pcchskip)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangLineBreakConsole {
    type Vtable = IMLangLineBreakConsole_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4122881761, 49111, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangLineBreakConsole> for ::windows::runtime::IUnknown {
    fn from(value: IMLangLineBreakConsole) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangLineBreakConsole> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangLineBreakConsole) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangLineBreakConsole {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangLineBreakConsole {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangLineBreakConsole_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, psrcmlstr: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, cmincolumns: i32, cmaxcolumns: i32, pllinelen: *mut i32, plskiplen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, pszsrc: super::Foundation::PWSTR, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, ucodepage: u32, pszsrc: super::Foundation::PSTR, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangString(pub ::windows::runtime::IUnknown);
impl IMLangString {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(&self, fnoaccess: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), fnoaccess.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: Param2, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), psrcmlstr.into_param().abi(), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, lsrcpos: i32, lsrclen: i32, punkouter: Param2, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), punkouter.into_param().abi(), ::std::mem::transmute(dwclscontext), ::std::mem::transmute(piid), ::std::mem::transmute(ppdestmlstr), ::std::mem::transmute(pldestpos), ::std::mem::transmute(pldestlen)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangString {
    type Vtable = IMLangString_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3226297806, 46861, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangString> for ::windows::runtime::IUnknown {
    fn from(value: IMLangString) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangString> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangString) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangString {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangString {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangString_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fnoaccess: super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pllen: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, psrcmlstr: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, punkouter: ::windows::runtime::RawPtr, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::windows::runtime::RawPtr, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangStringAStr(pub ::windows::runtime::IUnknown);
impl IMLangStringAStr {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(&self, fnoaccess: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), fnoaccess.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: Param2, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), psrcmlstr.into_param().abi(), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, lsrcpos: i32, lsrclen: i32, punkouter: Param2, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), punkouter.into_param().abi(), ::std::mem::transmute(dwclscontext), ::std::mem::transmute(piid), ::std::mem::transmute(ppdestmlstr), ::std::mem::transmute(pldestpos), ::std::mem::transmute(pldestlen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn SetAStr<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, ldestpos: i32, ldestlen: i32, ucodepage: u32, pszsrc: Param3, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), ::std::mem::transmute(ucodepage), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetStrBufA<'a, Param3: ::windows::runtime::IntoParam<'a, IMLangStringBufA>>(&self, ldestpos: i32, ldestlen: i32, ucodepage: u32, psrcbuf: Param3, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), ::std::mem::transmute(ucodepage), psrcbuf.into_param().abi(), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetAStr(&self, lsrcpos: i32, lsrclen: i32, ucodepagein: u32, pucodepageout: *mut u32, pszdest: super::Foundation::PSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(ucodepagein),
            ::std::mem::transmute(pucodepageout),
            ::std::mem::transmute(pszdest),
            ::std::mem::transmute(cchdest),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetStrBufA(&self, lsrcpos: i32, lsrcmaxlen: i32, pudestcodepage: *mut u32, ppdestbuf: *mut ::std::option::Option<IMLangStringBufA>, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrcmaxlen), ::std::mem::transmute(pudestcodepage), ::std::mem::transmute(ppdestbuf), ::std::mem::transmute(pldestlen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LockAStr(&self, lsrcpos: i32, lsrclen: i32, lflags: i32, ucodepagein: u32, cchrequest: i32, pucodepageout: *mut u32, ppszdest: *mut super::Foundation::PSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(lflags),
            ::std::mem::transmute(ucodepagein),
            ::std::mem::transmute(cchrequest),
            ::std::mem::transmute(pucodepageout),
            ::std::mem::transmute(ppszdest),
            ::std::mem::transmute(pcchdest),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn UnlockAStr<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, pszsrc: Param0, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetLocale(&self, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), ::std::mem::transmute(locale)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetLocale(&self, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrcmaxlen), ::std::mem::transmute(plocale), ::std::mem::transmute(pllocalepos), ::std::mem::transmute(pllocalelen)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringAStr {
    type Vtable = IMLangStringAStr_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3226297810, 46861, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangStringAStr> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringAStr) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangStringAStr> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringAStr) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IMLangStringAStr> for IMLangString {
    fn from(value: IMLangStringAStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringAStr> for IMLangString {
    fn from(value: &IMLangStringAStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for &IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringAStr_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fnoaccess: super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pllen: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, psrcmlstr: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, punkouter: ::windows::runtime::RawPtr, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::windows::runtime::RawPtr, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, ucodepage: u32, pszsrc: super::Foundation::PSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, ucodepage: u32, psrcbuf: ::windows::runtime::RawPtr, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, ucodepagein: u32, pucodepageout: *mut u32, pszdest: super::Foundation::PSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrcmaxlen: i32, pudestcodepage: *mut u32, ppdestbuf: *mut ::windows::runtime::RawPtr, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, lflags: i32, ucodepagein: u32, cchrequest: i32, pucodepageout: *mut u32, ppszdest: *mut super::Foundation::PSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszsrc: super::Foundation::PSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangStringBufA(pub ::windows::runtime::IUnknown);
impl IMLangStringBufA {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetStatus(&self, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(plflags), ::std::mem::transmute(pcchbuf)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LockBuf(&self, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut super::Foundation::CHAR, pcchbuf: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchmaxlock), ::std::mem::transmute(ppszbuf), ::std::mem::transmute(pcchbuf)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn UnlockBuf<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, pszbuf: Param0, cchoffset: i32, cchwrite: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pszbuf.into_param().abi(), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchwrite)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Insert(&self, cchoffset: i32, cchmaxinsert: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchmaxinsert), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchdelete)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringBufA {
    type Vtable = IMLangStringBufA_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3528117539, 47730, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangStringBufA> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringBufA) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangStringBufA> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringBufA) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringBufA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangStringBufA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufA_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut super::Foundation::CHAR, pcchbuf: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszbuf: super::Foundation::PSTR, cchoffset: i32, cchwrite: i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchmaxinsert: i32, pcchactual: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangStringBufW(pub ::windows::runtime::IUnknown);
impl IMLangStringBufW {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetStatus(&self, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(plflags), ::std::mem::transmute(pcchbuf)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn LockBuf(&self, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u16, pcchbuf: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchmaxlock), ::std::mem::transmute(ppszbuf), ::std::mem::transmute(pcchbuf)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn UnlockBuf<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pszbuf: Param0, cchoffset: i32, cchwrite: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pszbuf.into_param().abi(), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchwrite)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Insert(&self, cchoffset: i32, cchmaxinsert: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchmaxinsert), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(cchoffset), ::std::mem::transmute(cchdelete)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringBufW {
    type Vtable = IMLangStringBufW_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3528117537, 47730, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangStringBufW> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringBufW) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangStringBufW> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringBufW) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringBufW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangStringBufW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufW_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u16, pcchbuf: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszbuf: super::Foundation::PWSTR, cchoffset: i32, cchwrite: i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchmaxinsert: i32, pcchactual: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMLangStringWStr(pub ::windows::runtime::IUnknown);
impl IMLangStringWStr {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(&self, fnoaccess: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), fnoaccess.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: Param2, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), psrcmlstr.into_param().abi(), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetMLStr<'a, Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, lsrcpos: i32, lsrclen: i32, punkouter: Param2, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), punkouter.into_param().abi(), ::std::mem::transmute(dwclscontext), ::std::mem::transmute(piid), ::std::mem::transmute(ppdestmlstr), ::std::mem::transmute(pldestpos), ::std::mem::transmute(pldestlen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn SetWStr<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, ldestpos: i32, ldestlen: i32, pszsrc: Param2, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetStrBufW<'a, Param2: ::windows::runtime::IntoParam<'a, IMLangStringBufW>>(&self, ldestpos: i32, ldestlen: i32, psrcbuf: Param2, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), psrcbuf.into_param().abi(), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetWStr(&self, lsrcpos: i32, lsrclen: i32, pszdest: super::Foundation::PWSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), ::std::mem::transmute(pszdest), ::std::mem::transmute(cchdest), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetStrBufW(&self, lsrcpos: i32, lsrcmaxlen: i32, ppdestbuf: *mut ::std::option::Option<IMLangStringBufW>, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrcmaxlen), ::std::mem::transmute(ppdestbuf), ::std::mem::transmute(pldestlen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LockWStr(&self, lsrcpos: i32, lsrclen: i32, lflags: i32, cchrequest: i32, ppszdest: *mut super::Foundation::PWSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrclen), ::std::mem::transmute(lflags), ::std::mem::transmute(cchrequest), ::std::mem::transmute(ppszdest), ::std::mem::transmute(pcchdest), ::std::mem::transmute(pldestlen)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn UnlockWStr<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pszsrc: Param0, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), pszsrc.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(pcchactual), ::std::mem::transmute(plactuallen)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetLocale(&self, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(ldestpos), ::std::mem::transmute(ldestlen), ::std::mem::transmute(locale)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetLocale(&self, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(lsrcpos), ::std::mem::transmute(lsrcmaxlen), ::std::mem::transmute(plocale), ::std::mem::transmute(pllocalepos), ::std::mem::transmute(pllocalelen)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringWStr {
    type Vtable = IMLangStringWStr_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3226297808, 46861, 4560, [177, 136, 0, 170, 0, 56, 201, 105]);
}
impl ::std::convert::From<IMLangStringWStr> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringWStr) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMLangStringWStr> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringWStr) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IMLangStringWStr> for IMLangString {
    fn from(value: IMLangStringWStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringWStr> for IMLangString {
    fn from(value: &IMLangStringWStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for &IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringWStr_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, fnoaccess: super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pllen: *mut i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, psrcmlstr: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, punkouter: ::windows::runtime::RawPtr, dwclscontext: u32, piid: *const ::windows::runtime::GUID, ppdestmlstr: *mut ::windows::runtime::RawPtr, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, pszsrc: super::Foundation::PWSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, psrcbuf: ::windows::runtime::RawPtr, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, pszdest: super::Foundation::PWSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrcmaxlen: i32, ppdestbuf: *mut ::windows::runtime::RawPtr, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrclen: i32, lflags: i32, cchrequest: i32, ppszdest: *mut super::Foundation::PWSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pszsrc: super::Foundation::PWSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMultiLanguage(pub ::windows::runtime::IUnknown);
impl IMultiLanguage {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), &mut result__).from_abi::<MIMECPINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumCodePages(&self, grfflags: u32) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(grfflags), &mut result__).from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetCharsetInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, charset: Param0) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), charset.into_param().abi(), &mut result__).from_abi::<MIMECSETINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertString(&self, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding), ::std::mem::transmute(psrcstr), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringToUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringFromUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), &mut result__).from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetLcidFromRfc1766<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, plocale: *mut u32, bstrrfc1766: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(plocale), bstrrfc1766.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumRfc1766(&self) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), &mut result__).from_abi::<IEnumRfc1766>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetRfc1766Info(&self, locale: u32) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), &mut result__).from_abi::<RFC1766INFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(uisrccodepage), ::std::mem::transmute(uidstcodepage), ::std::mem::transmute(dwproperty), &mut result__).from_abi::<IMLangConvertCharset>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage {
    type Vtable = IMultiLanguage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(660349921, 14151, 4560, [159, 234, 0, 170, 0, 63, 134, 70]);
}
impl ::std::convert::From<IMultiLanguage> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMultiLanguage> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMultiLanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pccodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, pcodepageinfo: *mut MIMECPINFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, puifamilycodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, grfflags: u32, ppenumcodepage: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plocale: *mut u32, bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppenumrfc1766: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, prfc1766info: *mut RFC1766INFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32, ppmlangconvertcharset: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMultiLanguage2(pub ::windows::runtime::IUnknown);
impl IMultiLanguage2 {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32, langid: u16) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), ::std::mem::transmute(langid), &mut result__).from_abi::<MIMECPINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumCodePages(&self, grfflags: u32, langid: u16) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(grfflags), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetCharsetInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, charset: Param0) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), charset.into_param().abi(), &mut result__).from_abi::<MIMECSETINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertString(&self, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding), ::std::mem::transmute(psrcstr), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringToUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringFromUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), &mut result__).from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetLcidFromRfc1766<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, plocale: *mut u32, bstrrfc1766: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(plocale), bstrrfc1766.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumRfc1766>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetRfc1766Info(&self, locale: u32, langid: u16) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), ::std::mem::transmute(langid), &mut result__).from_abi::<RFC1766INFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(uisrccodepage), ::std::mem::transmute(uidstcodepage), ::std::mem::transmute(dwproperty), &mut result__).from_abi::<IMLangConvertCharset>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn ConvertStringInIStream<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param5: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>, Param6: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>>(&self, pdwmode: *mut u32, dwflag: u32, lpfallback: Param2, dwsrcencoding: u32, dwdstencoding: u32, pstmin: Param5, pstmout: Param6) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwflag), lpfallback.into_param().abi(), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding), pstmin.into_param().abi(), pstmout.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringToUnicodeEx<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: Param7) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize), ::std::mem::transmute(dwflag), lpfallback.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringFromUnicodeEx<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: Param7) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize), ::std::mem::transmute(dwflag), lpfallback.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn DetectCodepageInIStream<'a, Param2: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>>(&self, dwflag: u32, dwprefwincodepage: u32, pstmin: Param2, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflag), ::std::mem::transmute(dwprefwincodepage), pstmin.into_param().abi(), ::std::mem::transmute(lpencoding), ::std::mem::transmute(pnscores)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn DetectInputCodepage<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, dwflag: u32, dwprefwincodepage: u32, psrcstr: Param2, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflag), ::std::mem::transmute(dwprefwincodepage), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(lpencoding), ::std::mem::transmute(pnscores)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ValidateCodePage<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>>(&self, uicodepage: u32, hwnd: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), hwnd.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetCodePageDescription(&self, uicodepage: u32, lcid: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), ::std::mem::transmute(lcid), ::std::mem::transmute(lpwidecharstr), ::std::mem::transmute(cchwidechar)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsource)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumScripts(&self, dwflags: u32, langid: u16) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumScript>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ValidateCodePageEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>>(&self, uicodepage: u32, hwnd: Param1, dwfiodcontrol: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), hwnd.into_param().abi(), ::std::mem::transmute(dwfiodcontrol)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage2 {
    type Vtable = IMultiLanguage2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3704602980, 11064, 4562, [183, 236, 0, 192, 79, 143, 93, 154]);
}
impl ::std::convert::From<IMultiLanguage2> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMultiLanguage2> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMultiLanguage2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pccodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, langid: u16, pcodepageinfo: *mut MIMECPINFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, puifamilycodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, grfflags: u32, langid: u16, ppenumcodepage: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plocale: *mut u32, bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, langid: u16, ppenumrfc1766: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, langid: u16, prfc1766info: *mut RFC1766INFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32, ppmlangconvertcharset: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR, dwsrcencoding: u32, dwdstencoding: u32, pstmin: ::windows::runtime::RawPtr, pstmout: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflag: u32, dwprefwincodepage: u32, pstmin: ::windows::runtime::RawPtr, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflag: u32, dwprefwincodepage: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, hwnd: super::Foundation::HWND) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, lcid: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsource: MIMECONTF) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnscripts: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, langid: u16, ppenumscript: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, hwnd: super::Foundation::HWND, dwfiodcontrol: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IMultiLanguage3(pub ::windows::runtime::IUnknown);
impl IMultiLanguage3 {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32, langid: u16) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), ::std::mem::transmute(langid), &mut result__).from_abi::<MIMECPINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumCodePages(&self, grfflags: u32, langid: u16) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(grfflags), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetCharsetInfo<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, charset: Param0) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), charset.into_param().abi(), &mut result__).from_abi::<MIMECSETINFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertString(&self, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding), ::std::mem::transmute(psrcstr), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringToUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringFromUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), &mut result__).from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetLcidFromRfc1766<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>>(&self, plocale: *mut u32, bstrrfc1766: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(plocale), bstrrfc1766.into_param().abi()).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumRfc1766>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetRfc1766Info(&self, locale: u32, langid: u16) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(locale), ::std::mem::transmute(langid), &mut result__).from_abi::<RFC1766INFO>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(uisrccodepage), ::std::mem::transmute(uidstcodepage), ::std::mem::transmute(dwproperty), &mut result__).from_abi::<IMLangConvertCharset>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn ConvertStringInIStream<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param5: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>, Param6: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>>(&self, pdwmode: *mut u32, dwflag: u32, lpfallback: Param2, dwsrcencoding: u32, dwdstencoding: u32, pstmin: Param5, pstmout: Param6) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwflag), lpfallback.into_param().abi(), ::std::mem::transmute(dwsrcencoding), ::std::mem::transmute(dwdstencoding), pstmin.into_param().abi(), pstmout.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringToUnicodeEx<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: Param7) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize), ::std::mem::transmute(dwflag), lpfallback.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ConvertStringFromUnicodeEx<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, pdwmode: *mut u32, dwencoding: u32, psrcstr: Param2, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: Param7) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdwmode), ::std::mem::transmute(dwencoding), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(pdststr), ::std::mem::transmute(pcdstsize), ::std::mem::transmute(dwflag), lpfallback.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn DetectCodepageInIStream<'a, Param2: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>>(&self, dwflag: u32, dwprefwincodepage: u32, pstmin: Param2, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflag), ::std::mem::transmute(dwprefwincodepage), pstmin.into_param().abi(), ::std::mem::transmute(lpencoding), ::std::mem::transmute(pnscores)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn DetectInputCodepage<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(&self, dwflag: u32, dwprefwincodepage: u32, psrcstr: Param2, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflag), ::std::mem::transmute(dwprefwincodepage), psrcstr.into_param().abi(), ::std::mem::transmute(pcsrcsize), ::std::mem::transmute(lpencoding), ::std::mem::transmute(pnscores)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ValidateCodePage<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>>(&self, uicodepage: u32, hwnd: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), hwnd.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetCodePageDescription(&self, uicodepage: u32, lcid: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), ::std::mem::transmute(lcid), ::std::mem::transmute(lpwidecharstr), ::std::mem::transmute(cchwidechar)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwsource)).ok()
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn EnumScripts(&self, dwflags: u32, langid: u16) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(dwflags), ::std::mem::transmute(langid), &mut result__).from_abi::<IEnumScript>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ValidateCodePageEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>>(&self, uicodepage: u32, hwnd: Param1, dwfiodcontrol: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), ::std::mem::transmute(uicodepage), hwnd.into_param().abi(), ::std::mem::transmute(dwfiodcontrol)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn DetectOutboundCodePage<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, dwflags: u32, lpwidecharstr: Param1, cchwidechar: u32, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: Param7) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            lpwidecharstr.into_param().abi(),
            ::std::mem::transmute(cchwidechar),
            ::std::mem::transmute(puipreferredcodepages),
            ::std::mem::transmute(npreferredcodepages),
            ::std::mem::transmute(puidetectedcodepages),
            ::std::mem::transmute(pndetectedcodepages),
            lpspecialchar.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn DetectOutboundCodePageInIStream<'a, Param1: ::windows::runtime::IntoParam<'a, super::System::Com::IStream>, Param6: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, dwflags: u32, pstrin: Param1, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: Param6) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            pstrin.into_param().abi(),
            ::std::mem::transmute(puipreferredcodepages),
            ::std::mem::transmute(npreferredcodepages),
            ::std::mem::transmute(puidetectedcodepages),
            ::std::mem::transmute(pndetectedcodepages),
            lpspecialchar.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage3 {
    type Vtable = IMultiLanguage3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1314416811, 45399, 17955, [154, 204, 106, 29, 156, 174, 190, 4]);
}
impl ::std::convert::From<IMultiLanguage3> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage3) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IMultiLanguage3> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage3) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<IMultiLanguage3> for IMultiLanguage2 {
    fn from(value: IMultiLanguage3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultiLanguage3> for IMultiLanguage2 {
    fn from(value: &IMultiLanguage3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiLanguage2> for IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiLanguage2> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiLanguage2> for &IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiLanguage2> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage3_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pccodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, langid: u16, pcodepageinfo: *mut MIMECPINFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, puifamilycodepage: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, grfflags: u32, langid: u16, ppenumcodepage: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plocale: *mut u32, bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, langid: u16, ppenumrfc1766: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, locale: u32, langid: u16, prfc1766info: *mut RFC1766INFO) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32, ppmlangconvertcharset: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR, dwsrcencoding: u32, dwdstencoding: u32, pstmin: ::windows::runtime::RawPtr, pstmout: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PWSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdwmode: *mut u32, dwencoding: u32, psrcstr: super::Foundation::PWSTR, pcsrcsize: *mut u32, pdststr: super::Foundation::PSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflag: u32, dwprefwincodepage: u32, pstmin: ::windows::runtime::RawPtr, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflag: u32, dwprefwincodepage: u32, psrcstr: super::Foundation::PSTR, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, hwnd: super::Foundation::HWND) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, lcid: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwsource: MIMECONTF) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pnscripts: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, langid: u16, ppenumscript: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, uicodepage: u32, hwnd: super::Foundation::HWND, dwfiodcontrol: u32) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: u32, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dwflags: u32, pstrin: ::windows::runtime::RawPtr, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IOptionDescription(pub ::windows::runtime::IUnknown);
impl IOptionDescription {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Heading(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Description(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn Labels(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IOptionDescription {
    type Vtable = IOptionDescription_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1127112581, 13775, 17926, [168, 1, 111, 112, 39, 126, 29, 122]);
}
impl ::std::convert::From<IOptionDescription> for ::windows::runtime::IUnknown {
    fn from(value: IOptionDescription) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IOptionDescription> for ::windows::runtime::IUnknown {
    fn from(value: &IOptionDescription) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IOptionDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IOptionDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IOptionDescription_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IS_TEXT_UNICODE_RESULT(pub u32);
pub const IS_TEXT_UNICODE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(1u32);
pub const IS_TEXT_UNICODE_REVERSE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(16u32);
pub const IS_TEXT_UNICODE_STATISTICS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(2u32);
pub const IS_TEXT_UNICODE_REVERSE_STATISTICS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(32u32);
pub const IS_TEXT_UNICODE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4u32);
pub const IS_TEXT_UNICODE_REVERSE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(64u32);
pub const IS_TEXT_UNICODE_SIGNATURE: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(8u32);
pub const IS_TEXT_UNICODE_REVERSE_SIGNATURE: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(128u32);
pub const IS_TEXT_UNICODE_ILLEGAL_CHARS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(256u32);
pub const IS_TEXT_UNICODE_ODD_LENGTH: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(512u32);
pub const IS_TEXT_UNICODE_NULL_BYTES: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4096u32);
pub const IS_TEXT_UNICODE_UNICODE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(15u32);
pub const IS_TEXT_UNICODE_REVERSE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(240u32);
pub const IS_TEXT_UNICODE_NOT_UNICODE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(3840u32);
pub const IS_TEXT_UNICODE_NOT_ASCII_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(61440u32);
impl ::std::convert::From<u32> for IS_TEXT_UNICODE_RESULT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IS_TEXT_UNICODE_RESULT {
    type Abi = Self;
}
impl ::std::ops::BitOr for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IS_TEXT_UNICODE_RESULT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IS_TEXT_UNICODE_RESULT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct IS_VALID_LOCALE_FLAGS(pub u32);
pub const LCID_INSTALLED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(1u32);
pub const LCID_SUPPORTED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(2u32);
impl ::std::convert::From<u32> for IS_VALID_LOCALE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IS_VALID_LOCALE_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IS_VALID_LOCALE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IS_VALID_LOCALE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellCheckProvider(pub ::windows::runtime::IUnknown);
impl ISpellCheckProvider {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn Suggest<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), word.into_param().abi(), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionValue<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn SetOptionValue<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0, value: u8) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), optionid.into_param().abi(), ::std::mem::transmute(value)).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionDescription<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn InitializeWordlist<'a, Param1: ::windows::runtime::IntoParam<'a, super::System::Com::IEnumString>>(&self, wordlisttype: WORDLIST_TYPE, words: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(wordlisttype), words.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckProvider {
    type Vtable = ISpellCheckProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1944680160, 36564, 20145, [128, 215, 27, 224, 161, 107, 12, 56]);
}
impl ::std::convert::From<ISpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckProvider) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckProvider) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProvider_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut u8) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: u8) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, wordlisttype: WORDLIST_TYPE, words: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellCheckProviderFactory(pub ::windows::runtime::IUnknown);
impl ISpellCheckProviderFactory {
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn SupportedLanguages(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn IsSupported<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, languagetag: Param0) -> ::windows::runtime::Result<super::Foundation::BOOL> {
        let mut result__: <super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), languagetag.into_param().abi(), &mut result__).from_abi::<super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn CreateSpellCheckProvider<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, languagetag: Param0) -> ::windows::runtime::Result<ISpellCheckProvider> {
        let mut result__: <ISpellCheckProvider as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), languagetag.into_param().abi(), &mut result__).from_abi::<ISpellCheckProvider>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckProviderFactory {
    type Vtable = ISpellCheckProviderFactory_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2674335249, 30678, 19602, [174, 251, 97, 82, 21, 227, 164, 190]);
}
impl ::std::convert::From<ISpellCheckProviderFactory> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckProviderFactory) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellCheckProviderFactory> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckProviderFactory) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckProviderFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellCheckProviderFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProviderFactory_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, languagetag: super::Foundation::PWSTR, value: *mut super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, languagetag: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellChecker(pub ::windows::runtime::IUnknown);
impl ISpellChecker {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn Suggest<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), word.into_param().abi(), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Add<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), word.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Ignore<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), word.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn AutoCorrect<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, from: Param0, to: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), from.into_param().abi(), to.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionValue<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SpellCheckerChanged<'a, Param0: ::windows::runtime::IntoParam<'a, ISpellCheckerChangedEventHandler>>(&self, handler: Param0) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), handler.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn RemoveSpellCheckerChanged(&self, eventcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(eventcookie)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionDescription<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ComprehensiveCheck<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellChecker {
    type Vtable = ISpellChecker_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3070036849, 58044, 18003, [141, 5, 241, 151, 228, 18, 119, 11]);
}
impl ::std::convert::From<ISpellChecker> for ::windows::runtime::IUnknown {
    fn from(value: ISpellChecker) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellChecker> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellChecker) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellChecker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellChecker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, from: super::Foundation::PWSTR, to: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut u8) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, handler: ::windows::runtime::RawPtr, eventcookie: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, eventcookie: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellChecker2(pub ::windows::runtime::IUnknown);
impl ISpellChecker2 {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_System_Com`*"]
    pub unsafe fn Suggest<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), word.into_param().abi(), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Add<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), word.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Ignore<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), word.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn AutoCorrect<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, from: Param0, to: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), from.into_param().abi(), to.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionValue<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn SpellCheckerChanged<'a, Param0: ::windows::runtime::IntoParam<'a, ISpellCheckerChangedEventHandler>>(&self, handler: Param0) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), handler.into_param().abi(), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn RemoveSpellCheckerChanged(&self, eventcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(eventcookie)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn GetOptionDescription<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, optionid: Param0) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), optionid.into_param().abi(), &mut result__).from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn ComprehensiveCheck<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, text: Param0) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), text.into_param().abi(), &mut result__).from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Remove<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, word: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), word.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellChecker2 {
    type Vtable = ISpellChecker2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3891076209, 34807, 17272, [168, 64, 201, 32, 13, 172, 238, 71]);
}
impl ::std::convert::From<ISpellChecker2> for ::windows::runtime::IUnknown {
    fn from(value: ISpellChecker2) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellChecker2> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellChecker2) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
impl ::std::convert::From<ISpellChecker2> for ISpellChecker {
    fn from(value: ISpellChecker2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellChecker2> for ISpellChecker {
    fn from(value: &ISpellChecker2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpellChecker> for ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpellChecker> {
        ::windows::runtime::Param::Owned(unsafe { ::std::mem::transmute(self) })
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpellChecker> for &ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpellChecker> {
        ::windows::runtime::Param::Borrowed(unsafe { ::std::mem::transmute(self) })
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, from: super::Foundation::PWSTR, to: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut u8) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, handler: ::windows::runtime::RawPtr, eventcookie: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, eventcookie: u32) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, optionid: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, text: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, word: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellCheckerChangedEventHandler(pub ::windows::runtime::IUnknown);
impl ISpellCheckerChangedEventHandler {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Invoke<'a, Param0: ::windows::runtime::IntoParam<'a, ISpellChecker>>(&self, sender: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), sender.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckerChangedEventHandler {
    type Vtable = ISpellCheckerChangedEventHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(193177008, 31023, 20139, [151, 153, 172, 245, 44, 94, 208, 138]);
}
impl ::std::convert::From<ISpellCheckerChangedEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckerChangedEventHandler) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellCheckerChangedEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckerChangedEventHandler) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckerChangedEventHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellCheckerChangedEventHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerChangedEventHandler_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, sender: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellCheckerFactory(pub ::windows::runtime::IUnknown);
impl ISpellCheckerFactory {
    #[cfg(feature = "Win32_System_Com")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_System_Com`*"]
    pub unsafe fn SupportedLanguages(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn IsSupported<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, languagetag: Param0) -> ::windows::runtime::Result<super::Foundation::BOOL> {
        let mut result__: <super::Foundation::BOOL as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), languagetag.into_param().abi(), &mut result__).from_abi::<super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn CreateSpellChecker<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, languagetag: Param0) -> ::windows::runtime::Result<ISpellChecker> {
        let mut result__: <ISpellChecker as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), languagetag.into_param().abi(), &mut result__).from_abi::<ISpellChecker>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckerFactory {
    type Vtable = ISpellCheckerFactory_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2382465693, 9237, 18039, [191, 8, 121, 78, 166, 31, 148, 187]);
}
impl ::std::convert::From<ISpellCheckerFactory> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckerFactory) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellCheckerFactory> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckerFactory) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckerFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellCheckerFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerFactory_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, languagetag: super::Foundation::PWSTR, value: *mut super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, languagetag: super::Foundation::PWSTR, value: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ISpellingError(pub ::windows::runtime::IUnknown);
impl ISpellingError {
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn StartIndex(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn Length(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `Win32_Globalization`*"]
    pub unsafe fn CorrectiveAction(&self) -> ::windows::runtime::Result<CORRECTIVE_ACTION> {
        let mut result__: <CORRECTIVE_ACTION as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), &mut result__).from_abi::<CORRECTIVE_ACTION>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn Replacement(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &mut result__).from_abi::<super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellingError {
    type Vtable = ISpellingError_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3083349345, 64488, 19271, [155, 39, 108, 13, 46, 13, 224, 163]);
}
impl ::std::convert::From<ISpellingError> for ::windows::runtime::IUnknown {
    fn from(value: ISpellingError) -> Self {
        value.0
    }
}
impl ::std::convert::From<&ISpellingError> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellingError) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a ISpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellingError_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut CORRECTIVE_ACTION) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, value: *mut super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`*"]
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct IUserDictionariesRegistrar(pub ::windows::runtime::IUnknown);
impl IUserDictionariesRegistrar {
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn RegisterUserDictionary<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, dictionarypath: Param0, languagetag: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), dictionarypath.into_param().abi(), languagetag.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    #[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
    pub unsafe fn UnregisterUserDictionary<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(&self, dictionarypath: Param0, languagetag: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), dictionarypath.into_param().abi(), languagetag.into_param().abi()).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUserDictionariesRegistrar {
    type Vtable = IUserDictionariesRegistrar_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2853661573, 3602, 18500, [142, 26, 238, 241, 218, 119, 245, 134]);
}
impl ::std::convert::From<IUserDictionariesRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: IUserDictionariesRegistrar) -> Self {
        value.0
    }
}
impl ::std::convert::From<&IUserDictionariesRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: &IUserDictionariesRegistrar) -> Self {
        value.0.clone()
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUserDictionariesRegistrar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(self.0)
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &'a IUserDictionariesRegistrar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Borrowed(&self.0)
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUserDictionariesRegistrar_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dictionarypath: super::Foundation::PWSTR, languagetag: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dictionarypath: super::Foundation::PWSTR, languagetag: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IdnToAscii<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, lpunicodecharstr: Param1, cchunicodechar: i32, lpasciicharstr: super::Foundation::PWSTR, cchasciichar: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToAscii(dwflags: u32, lpunicodecharstr: super::Foundation::PWSTR, cchunicodechar: i32, lpasciicharstr: super::Foundation::PWSTR, cchasciichar: i32) -> i32;
        }
        ::std::mem::transmute(IdnToAscii(::std::mem::transmute(dwflags), lpunicodecharstr.into_param().abi(), ::std::mem::transmute(cchunicodechar), ::std::mem::transmute(lpasciicharstr), ::std::mem::transmute(cchasciichar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IdnToNameprepUnicode<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, lpunicodecharstr: Param1, cchunicodechar: i32, lpnameprepcharstr: super::Foundation::PWSTR, cchnameprepchar: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToNameprepUnicode(dwflags: u32, lpunicodecharstr: super::Foundation::PWSTR, cchunicodechar: i32, lpnameprepcharstr: super::Foundation::PWSTR, cchnameprepchar: i32) -> i32;
        }
        ::std::mem::transmute(IdnToNameprepUnicode(::std::mem::transmute(dwflags), lpunicodecharstr.into_param().abi(), ::std::mem::transmute(cchunicodechar), ::std::mem::transmute(lpnameprepcharstr), ::std::mem::transmute(cchnameprepchar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IdnToUnicode<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, lpasciicharstr: Param1, cchasciichar: i32, lpunicodecharstr: super::Foundation::PWSTR, cchunicodechar: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToUnicode(dwflags: u32, lpasciicharstr: super::Foundation::PWSTR, cchasciichar: i32, lpunicodecharstr: super::Foundation::PWSTR, cchunicodechar: i32) -> i32;
        }
        ::std::mem::transmute(IdnToUnicode(::std::mem::transmute(dwflags), lpasciicharstr.into_param().abi(), ::std::mem::transmute(cchasciichar), ::std::mem::transmute(lpunicodecharstr), ::std::mem::transmute(cchunicodechar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsDBCSLeadByte(testchar: u8) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsDBCSLeadByte(testchar: u8) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsDBCSLeadByte(::std::mem::transmute(testchar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsDBCSLeadByteEx(codepage: u32, testchar: u8) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsDBCSLeadByteEx(codepage: u32, testchar: u8) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsDBCSLeadByteEx(::std::mem::transmute(codepage), ::std::mem::transmute(testchar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsNLSDefinedString<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(function: u32, dwflags: u32, lpversioninformation: *const NLSVERSIONINFO, lpstring: Param3, cchstr: i32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsNLSDefinedString(function: u32, dwflags: u32, lpversioninformation: *const NLSVERSIONINFO, lpstring: super::Foundation::PWSTR, cchstr: i32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsNLSDefinedString(::std::mem::transmute(function), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpversioninformation), lpstring.into_param().abi(), ::std::mem::transmute(cchstr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsNormalizedString<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(normform: NORM_FORM, lpstring: Param1, cwlength: i32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsNormalizedString(normform: NORM_FORM, lpstring: super::Foundation::PWSTR, cwlength: i32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsNormalizedString(::std::mem::transmute(normform), lpstring.into_param().abi(), ::std::mem::transmute(cwlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsTextUnicode(lpv: *const ::std::ffi::c_void, isize: i32, lpiresult: *mut IS_TEXT_UNICODE_RESULT) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsTextUnicode(lpv: *const ::std::ffi::c_void, isize: i32, lpiresult: *mut IS_TEXT_UNICODE_RESULT) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsTextUnicode(::std::mem::transmute(lpv), ::std::mem::transmute(isize), ::std::mem::transmute(lpiresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidCodePage(codepage: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidCodePage(codepage: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidCodePage(::std::mem::transmute(codepage)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLanguageGroup(languagegroup: u32, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLanguageGroup(languagegroup: u32, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLanguageGroup(::std::mem::transmute(languagegroup), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLocale(locale: u32, dwflags: IS_VALID_LOCALE_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLocale(locale: u32, dwflags: IS_VALID_LOCALE_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLocale(::std::mem::transmute(locale), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLocaleName<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lplocalename: Param0) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLocaleName(lplocalename: super::Foundation::PWSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLocaleName(lplocalename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidNLSVersion<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(function: u32, lplocalename: Param1, lpversioninformation: *const NLSVERSIONINFOEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidNLSVersion(function: u32, lplocalename: super::Foundation::PWSTR, lpversioninformation: *const NLSVERSIONINFOEX) -> u32;
        }
        ::std::mem::transmute(IsValidNLSVersion(::std::mem::transmute(function), lplocalename.into_param().abi(), ::std::mem::transmute(lpversioninformation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsWellFormedTag<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(psztag: Param0) -> u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsWellFormedTag(psztag: super::Foundation::PWSTR) -> u8;
        }
        ::std::mem::transmute(IsWellFormedTag(psztag.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LANGGROUPLOCALE_ENUMPROCA = unsafe extern "system" fn(param0: u32, param1: u32, param2: super::Foundation::PSTR, param3: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LANGGROUPLOCALE_ENUMPROCW = unsafe extern "system" fn(param0: u32, param1: u32, param2: super::Foundation::PWSTR, param3: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LANGUAGEGROUP_ENUMPROCA = unsafe extern "system" fn(param0: u32, param1: super::Foundation::PSTR, param2: super::Foundation::PSTR, param3: u32, param4: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LANGUAGEGROUP_ENUMPROCW = unsafe extern "system" fn(param0: u32, param1: super::Foundation::PWSTR, param2: super::Foundation::PWSTR, param3: u32, param4: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LCIDToLocaleName(locale: u32, lpname: super::Foundation::PWSTR, cchname: i32, dwflags: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCIDToLocaleName(locale: u32, lpname: super::Foundation::PWSTR, cchname: i32, dwflags: u32) -> i32;
        }
        ::std::mem::transmute(LCIDToLocaleName(::std::mem::transmute(locale), ::std::mem::transmute(lpname), ::std::mem::transmute(cchname), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCID_ALTERNATE_SORTS: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_BYTEREV: u32 = 2048u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_FULLWIDTH: u32 = 8388608u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_HALFWIDTH: u32 = 4194304u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_HASH: u32 = 262144u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_HIRAGANA: u32 = 1048576u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_KATAKANA: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_LINGUISTIC_CASING: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_LOWERCASE: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_SIMPLIFIED_CHINESE: u32 = 33554432u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_SORTHANDLE: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_SORTKEY: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_TITLECASE: u32 = 768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_TRADITIONAL_CHINESE: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LCMAP_UPPERCASE: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LCMapStringA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, dwmapflags: u32, lpsrcstr: Param2, cchsrc: i32, lpdeststr: super::Foundation::PSTR, cchdest: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringA(locale: u32, dwmapflags: u32, lpsrcstr: super::Foundation::PSTR, cchsrc: i32, lpdeststr: super::Foundation::PSTR, cchdest: i32) -> i32;
        }
        ::std::mem::transmute(LCMapStringA(::std::mem::transmute(locale), ::std::mem::transmute(dwmapflags), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpdeststr), ::std::mem::transmute(cchdest)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LCMapStringEx<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param8: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>>(lplocalename: Param0, dwmapflags: u32, lpsrcstr: Param2, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32, lpversioninformation: *const NLSVERSIONINFO, lpreserved: *const ::std::ffi::c_void, sorthandle: Param8) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringEx(lplocalename: super::Foundation::PWSTR, dwmapflags: u32, lpsrcstr: super::Foundation::PWSTR, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32, lpversioninformation: *const NLSVERSIONINFO, lpreserved: *const ::std::ffi::c_void, sorthandle: super::Foundation::LPARAM) -> i32;
        }
        ::std::mem::transmute(LCMapStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            sorthandle.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LCMapStringW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, dwmapflags: u32, lpsrcstr: Param2, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringW(locale: u32, dwmapflags: u32, lpsrcstr: super::Foundation::PWSTR, cchsrc: i32, lpdeststr: super::Foundation::PWSTR, cchdest: i32) -> i32;
        }
        ::std::mem::transmute(LCMapStringW(::std::mem::transmute(locale), ::std::mem::transmute(dwmapflags), lpsrcstr.into_param().abi(), ::std::mem::transmute(cchsrc), ::std::mem::transmute(lpdeststr), ::std::mem::transmute(cchdest)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_ARABIC: u32 = 13u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_ARMENIAN: u32 = 17u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_BALTIC: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_CENTRAL_EUROPE: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_CYRILLIC: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_GEORGIAN: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_GREEK: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_HEBREW: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_INDIC: u32 = 15u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_JAPANESE: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_KOREAN: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_SIMPLIFIED_CHINESE: u32 = 10u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_THAI: u32 = 11u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_TRADITIONAL_CHINESE: u32 = 9u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_TURKIC: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_TURKISH: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_VIETNAMESE: u32 = 14u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LGRPID_WESTERN_EUROPE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct LOCALESIGNATURE {
    pub lsUsb: [u32; 4],
    pub lsCsbDefault: [u32; 2],
    pub lsCsbSupported: [u32; 2],
}
impl LOCALESIGNATURE {}
impl ::std::default::Default for LOCALESIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for LOCALESIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("LOCALESIGNATURE").field("lsUsb", &self.lsUsb).field("lsCsbDefault", &self.lsCsbDefault).field("lsCsbSupported", &self.lsCsbSupported).finish()
    }
}
impl ::std::cmp::PartialEq for LOCALESIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.lsUsb == other.lsUsb && self.lsCsbDefault == other.lsCsbDefault && self.lsCsbSupported == other.lsCsbSupported
    }
}
impl ::std::cmp::Eq for LOCALESIGNATURE {}
unsafe impl ::windows::runtime::Abi for LOCALESIGNATURE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ALL: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ALLOW_NEUTRAL_NAMES: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ALTERNATE_SORTS: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCEX = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: u32, param2: super::Foundation::LPARAM) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_FONTSIGNATURE: u32 = 88u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICALENDARTYPE: u32 = 4105u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICENTURY: u32 = 36u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICONSTRUCTEDLOCALE: u32 = 125u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICOUNTRY: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICURRDIGITS: u32 = 25u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ICURRENCY: u32 = 27u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDATE: u32 = 33u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDAYLZERO: u32 = 38u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTANSICODEPAGE: u32 = 4100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTCODEPAGE: u32 = 11u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTCOUNTRY: u32 = 10u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTEBCDICCODEPAGE: u32 = 4114u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTLANGUAGE: u32 = 9u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDEFAULTMACCODEPAGE: u32 = 4113u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDIALINGCODE: u32 = 5u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDIGITS: u32 = 17u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IDIGITSUBSTITUTION: u32 = 4116u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IFIRSTDAYOFWEEK: u32 = 4108u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IFIRSTWEEKOFYEAR: u32 = 4109u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IGEOID: u32 = 91u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IINTLCURRDIGITS: u32 = 26u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ILANGUAGE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ILDATE: u32 = 34u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ILZERO: u32 = 18u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IMEASURE: u32 = 13u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IMONLZERO: u32 = 39u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGATIVEPERCENT: u32 = 116u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGCURR: u32 = 28u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGNUMBER: u32 = 4112u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGSEPBYSPACE: u32 = 87u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGSIGNPOSN: u32 = 83u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEGSYMPRECEDES: u32 = 86u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_INEUTRAL: u32 = 113u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IOPTIONALCALENDAR: u32 = 4107u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IPAPERSIZE: u32 = 4106u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IPOSITIVEPERCENT: u32 = 117u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IPOSSEPBYSPACE: u32 = 85u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IPOSSIGNPOSN: u32 = 82u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IPOSSYMPRECEDES: u32 = 84u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IREADINGLAYOUT: u32 = 112u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ITIME: u32 = 35u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ITIMEMARKPOSN: u32 = 4101u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_ITLZERO: u32 = 37u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IUSEUTF8LEGACYACP: u32 = 1638u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_IUSEUTF8LEGACYOEMCP: u32 = 2457u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_NEUTRALDATA: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_NOUSEROVERRIDE: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_REPLACEMENT: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_RETURN_NUMBER: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_S1159: u32 = 40u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_S2359: u32 = 41u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVCTRYNAME: u32 = 7u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME1: u32 = 49u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME2: u32 = 50u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME3: u32 = 51u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME4: u32 = 52u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME5: u32 = 53u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME6: u32 = 54u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVDAYNAME7: u32 = 55u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVLANGNAME: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME1: u32 = 68u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME10: u32 = 77u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME11: u32 = 78u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME12: u32 = 79u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME13: u32 = 4111u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME2: u32 = 69u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME3: u32 = 70u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME4: u32 = 71u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME5: u32 = 72u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME6: u32 = 73u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME7: u32 = 74u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME8: u32 = 75u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SABBREVMONTHNAME9: u32 = 76u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SAM: u32 = 40u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SCONSOLEFALLBACKNAME: u32 = 110u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SCOUNTRY: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SCURRENCY: u32 = 20u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDATE: u32 = 29u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME1: u32 = 42u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME2: u32 = 43u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME3: u32 = 44u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME4: u32 = 45u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME5: u32 = 46u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME6: u32 = 47u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDAYNAME7: u32 = 48u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDECIMAL: u32 = 14u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SDURATION: u32 = 93u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGCOUNTRY: u32 = 4098u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGCURRNAME: u32 = 4103u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGLANGUAGE: u32 = 4097u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGLISHCOUNTRYNAME: u32 = 4098u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGLISHDISPLAYNAME: u32 = 114u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SENGLISHLANGUAGENAME: u32 = 4097u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SGROUPING: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SINTLSYMBOL: u32 = 21u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SISO3166CTRYNAME: u32 = 90u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SISO3166CTRYNAME2: u32 = 104u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SISO639LANGNAME: u32 = 89u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SISO639LANGNAME2: u32 = 103u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SKEYBOARDSTOINSTALL: u32 = 94u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLANGDISPLAYNAME: u32 = 111u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLANGUAGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLIST: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLOCALIZEDCOUNTRYNAME: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLOCALIZEDDISPLAYNAME: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLOCALIZEDLANGUAGENAME: u32 = 111u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SLONGDATE: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONDECIMALSEP: u32 = 22u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONGROUPING: u32 = 24u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHDAY: u32 = 120u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME1: u32 = 56u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME10: u32 = 65u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME11: u32 = 66u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME12: u32 = 67u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME13: u32 = 4110u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME2: u32 = 57u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME3: u32 = 58u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME4: u32 = 59u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME5: u32 = 60u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME6: u32 = 61u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME7: u32 = 62u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME8: u32 = 63u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHNAME9: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SMONTHOUSANDSEP: u32 = 23u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNAME: u32 = 92u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNAN: u32 = 105u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVECOUNTRYNAME: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVECTRYNAME: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVECURRNAME: u32 = 4104u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVEDIGITS: u32 = 19u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVEDISPLAYNAME: u32 = 115u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVELANGNAME: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNATIVELANGUAGENAME: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNEGATIVESIGN: u32 = 81u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SNEGINFINITY: u32 = 107u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SOPENTYPELANGUAGETAG: u32 = 122u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPARENT: u32 = 109u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPECIFICDATA: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPERCENT: u32 = 118u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPERMILLE: u32 = 119u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPM: u32 = 41u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPOSINFINITY: u32 = 106u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SPOSITIVESIGN: u32 = 80u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SRELATIVELONGDATE: u32 = 124u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSCRIPTS: u32 = 108u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTDATE: u32 = 31u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTAM: u32 = 126u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME1: u32 = 96u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME2: u32 = 97u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME3: u32 = 98u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME4: u32 = 99u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME5: u32 = 100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME6: u32 = 101u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTDAYNAME7: u32 = 102u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTESTPM: u32 = 127u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSHORTTIME: u32 = 121u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSORTLOCALE: u32 = 123u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SSORTNAME: u32 = 4115u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_STHOUSAND: u32 = 15u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_STIME: u32 = 30u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_STIMEFORMAT: u32 = 4099u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SUPPLEMENTAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_SYEARMONTH: u32 = 4102u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_USE_CP_ACP: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOCALE_WINDOWS: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOWLEVEL_SERVICE_TYPES: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOW_SURROGATE_END: u32 = 57343u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const LOW_SURROGATE_START: u32 = 56320u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LocaleNameToLCID<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpname: Param0, dwflags: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LocaleNameToLCID(lpname: super::Foundation::PWSTR, dwflags: u32) -> u32;
        }
        ::std::mem::transmute(LocaleNameToLCID(lpname.into_param().abi(), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct MAPPING_DATA_RANGE {
    pub dwStartIndex: u32,
    pub dwEndIndex: u32,
    pub pszDescription: super::Foundation::PWSTR,
    pub dwDescriptionLength: u32,
    pub pData: *mut ::std::ffi::c_void,
    pub dwDataSize: u32,
    pub pszContentType: super::Foundation::PWSTR,
    pub prgActionIds: *mut super::Foundation::PWSTR,
    pub dwActionsCount: u32,
    pub prgActionDisplayNames: *mut super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_DATA_RANGE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_DATA_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_DATA_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_DATA_RANGE")
            .field("dwStartIndex", &self.dwStartIndex)
            .field("dwEndIndex", &self.dwEndIndex)
            .field("pszDescription", &self.pszDescription)
            .field("dwDescriptionLength", &self.dwDescriptionLength)
            .field("pData", &self.pData)
            .field("dwDataSize", &self.dwDataSize)
            .field("pszContentType", &self.pszContentType)
            .field("prgActionIds", &self.prgActionIds)
            .field("dwActionsCount", &self.dwActionsCount)
            .field("prgActionDisplayNames", &self.prgActionDisplayNames)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_DATA_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStartIndex == other.dwStartIndex && self.dwEndIndex == other.dwEndIndex && self.pszDescription == other.pszDescription && self.dwDescriptionLength == other.dwDescriptionLength && self.pData == other.pData && self.dwDataSize == other.dwDataSize && self.pszContentType == other.pszContentType && self.prgActionIds == other.prgActionIds && self.dwActionsCount == other.dwActionsCount && self.prgActionDisplayNames == other.prgActionDisplayNames
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_DATA_RANGE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_DATA_RANGE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct MAPPING_ENUM_OPTIONS {
    pub Size: usize,
    pub pszCategory: super::Foundation::PWSTR,
    pub pszInputLanguage: super::Foundation::PWSTR,
    pub pszOutputLanguage: super::Foundation::PWSTR,
    pub pszInputScript: super::Foundation::PWSTR,
    pub pszOutputScript: super::Foundation::PWSTR,
    pub pszInputContentType: super::Foundation::PWSTR,
    pub pszOutputContentType: super::Foundation::PWSTR,
    pub pGuid: *mut ::windows::runtime::GUID,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_ENUM_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_ENUM_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_ENUM_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_ENUM_OPTIONS")
            .field("Size", &self.Size)
            .field("pszCategory", &self.pszCategory)
            .field("pszInputLanguage", &self.pszInputLanguage)
            .field("pszOutputLanguage", &self.pszOutputLanguage)
            .field("pszInputScript", &self.pszInputScript)
            .field("pszOutputScript", &self.pszOutputScript)
            .field("pszInputContentType", &self.pszInputContentType)
            .field("pszOutputContentType", &self.pszOutputContentType)
            .field("pGuid", &self.pGuid)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_ENUM_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.pszCategory == other.pszCategory && self.pszInputLanguage == other.pszInputLanguage && self.pszOutputLanguage == other.pszOutputLanguage && self.pszInputScript == other.pszInputScript && self.pszOutputScript == other.pszOutputScript && self.pszInputContentType == other.pszInputContentType && self.pszOutputContentType == other.pszOutputContentType && self.pGuid == other.pGuid && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_ENUM_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_ENUM_OPTIONS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct MAPPING_OPTIONS {
    pub Size: usize,
    pub pszInputLanguage: super::Foundation::PWSTR,
    pub pszOutputLanguage: super::Foundation::PWSTR,
    pub pszInputScript: super::Foundation::PWSTR,
    pub pszOutputScript: super::Foundation::PWSTR,
    pub pszInputContentType: super::Foundation::PWSTR,
    pub pszOutputContentType: super::Foundation::PWSTR,
    pub pszUILanguage: super::Foundation::PWSTR,
    pub pfnRecognizeCallback: ::std::option::Option<PFN_MAPPINGCALLBACKPROC>,
    pub pRecognizeCallerData: *mut ::std::ffi::c_void,
    pub dwRecognizeCallerDataSize: u32,
    pub pfnActionCallback: ::std::option::Option<PFN_MAPPINGCALLBACKPROC>,
    pub pActionCallerData: *mut ::std::ffi::c_void,
    pub dwActionCallerDataSize: u32,
    pub dwServiceFlag: u32,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_OPTIONS")
            .field("Size", &self.Size)
            .field("pszInputLanguage", &self.pszInputLanguage)
            .field("pszOutputLanguage", &self.pszOutputLanguage)
            .field("pszInputScript", &self.pszInputScript)
            .field("pszOutputScript", &self.pszOutputScript)
            .field("pszInputContentType", &self.pszInputContentType)
            .field("pszOutputContentType", &self.pszOutputContentType)
            .field("pszUILanguage", &self.pszUILanguage)
            .field("pRecognizeCallerData", &self.pRecognizeCallerData)
            .field("dwRecognizeCallerDataSize", &self.dwRecognizeCallerDataSize)
            .field("pActionCallerData", &self.pActionCallerData)
            .field("dwActionCallerDataSize", &self.dwActionCallerDataSize)
            .field("dwServiceFlag", &self.dwServiceFlag)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.pszInputLanguage == other.pszInputLanguage
            && self.pszOutputLanguage == other.pszOutputLanguage
            && self.pszInputScript == other.pszInputScript
            && self.pszOutputScript == other.pszOutputScript
            && self.pszInputContentType == other.pszInputContentType
            && self.pszOutputContentType == other.pszOutputContentType
            && self.pszUILanguage == other.pszUILanguage
            && self.pfnRecognizeCallback.map(|f| f as usize) == other.pfnRecognizeCallback.map(|f| f as usize)
            && self.pRecognizeCallerData == other.pRecognizeCallerData
            && self.dwRecognizeCallerDataSize == other.dwRecognizeCallerDataSize
            && self.pfnActionCallback.map(|f| f as usize) == other.pfnActionCallback.map(|f| f as usize)
            && self.pActionCallerData == other.pActionCallerData
            && self.dwActionCallerDataSize == other.dwActionCallerDataSize
            && self.dwServiceFlag == other.dwServiceFlag
            && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_OPTIONS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct MAPPING_PROPERTY_BAG {
    pub Size: usize,
    pub prgResultRanges: *mut MAPPING_DATA_RANGE,
    pub dwRangesCount: u32,
    pub pServiceData: *mut ::std::ffi::c_void,
    pub dwServiceDataSize: u32,
    pub pCallerData: *mut ::std::ffi::c_void,
    pub dwCallerDataSize: u32,
    pub pContext: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_PROPERTY_BAG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_PROPERTY_BAG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_PROPERTY_BAG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_PROPERTY_BAG")
            .field("Size", &self.Size)
            .field("prgResultRanges", &self.prgResultRanges)
            .field("dwRangesCount", &self.dwRangesCount)
            .field("pServiceData", &self.pServiceData)
            .field("dwServiceDataSize", &self.dwServiceDataSize)
            .field("pCallerData", &self.pCallerData)
            .field("dwCallerDataSize", &self.dwCallerDataSize)
            .field("pContext", &self.pContext)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_PROPERTY_BAG {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size && self.prgResultRanges == other.prgResultRanges && self.dwRangesCount == other.dwRangesCount && self.pServiceData == other.pServiceData && self.dwServiceDataSize == other.dwServiceDataSize && self.pCallerData == other.pCallerData && self.dwCallerDataSize == other.dwCallerDataSize && self.pContext == other.pContext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_PROPERTY_BAG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_PROPERTY_BAG {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct MAPPING_SERVICE_INFO {
    pub Size: usize,
    pub pszCopyright: super::Foundation::PWSTR,
    pub wMajorVersion: u16,
    pub wMinorVersion: u16,
    pub wBuildVersion: u16,
    pub wStepVersion: u16,
    pub dwInputContentTypesCount: u32,
    pub prgInputContentTypes: *mut super::Foundation::PWSTR,
    pub dwOutputContentTypesCount: u32,
    pub prgOutputContentTypes: *mut super::Foundation::PWSTR,
    pub dwInputLanguagesCount: u32,
    pub prgInputLanguages: *mut super::Foundation::PWSTR,
    pub dwOutputLanguagesCount: u32,
    pub prgOutputLanguages: *mut super::Foundation::PWSTR,
    pub dwInputScriptsCount: u32,
    pub prgInputScripts: *mut super::Foundation::PWSTR,
    pub dwOutputScriptsCount: u32,
    pub prgOutputScripts: *mut super::Foundation::PWSTR,
    pub guid: ::windows::runtime::GUID,
    pub pszCategory: super::Foundation::PWSTR,
    pub pszDescription: super::Foundation::PWSTR,
    pub dwPrivateDataSize: u32,
    pub pPrivateData: *mut ::std::ffi::c_void,
    pub pContext: *mut ::std::ffi::c_void,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_SERVICE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_SERVICE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_SERVICE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_SERVICE_INFO")
            .field("Size", &self.Size)
            .field("pszCopyright", &self.pszCopyright)
            .field("wMajorVersion", &self.wMajorVersion)
            .field("wMinorVersion", &self.wMinorVersion)
            .field("wBuildVersion", &self.wBuildVersion)
            .field("wStepVersion", &self.wStepVersion)
            .field("dwInputContentTypesCount", &self.dwInputContentTypesCount)
            .field("prgInputContentTypes", &self.prgInputContentTypes)
            .field("dwOutputContentTypesCount", &self.dwOutputContentTypesCount)
            .field("prgOutputContentTypes", &self.prgOutputContentTypes)
            .field("dwInputLanguagesCount", &self.dwInputLanguagesCount)
            .field("prgInputLanguages", &self.prgInputLanguages)
            .field("dwOutputLanguagesCount", &self.dwOutputLanguagesCount)
            .field("prgOutputLanguages", &self.prgOutputLanguages)
            .field("dwInputScriptsCount", &self.dwInputScriptsCount)
            .field("prgInputScripts", &self.prgInputScripts)
            .field("dwOutputScriptsCount", &self.dwOutputScriptsCount)
            .field("prgOutputScripts", &self.prgOutputScripts)
            .field("guid", &self.guid)
            .field("pszCategory", &self.pszCategory)
            .field("pszDescription", &self.pszDescription)
            .field("dwPrivateDataSize", &self.dwPrivateDataSize)
            .field("pPrivateData", &self.pPrivateData)
            .field("pContext", &self.pContext)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_SERVICE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.pszCopyright == other.pszCopyright
            && self.wMajorVersion == other.wMajorVersion
            && self.wMinorVersion == other.wMinorVersion
            && self.wBuildVersion == other.wBuildVersion
            && self.wStepVersion == other.wStepVersion
            && self.dwInputContentTypesCount == other.dwInputContentTypesCount
            && self.prgInputContentTypes == other.prgInputContentTypes
            && self.dwOutputContentTypesCount == other.dwOutputContentTypesCount
            && self.prgOutputContentTypes == other.prgOutputContentTypes
            && self.dwInputLanguagesCount == other.dwInputLanguagesCount
            && self.prgInputLanguages == other.prgInputLanguages
            && self.dwOutputLanguagesCount == other.dwOutputLanguagesCount
            && self.prgOutputLanguages == other.prgOutputLanguages
            && self.dwInputScriptsCount == other.dwInputScriptsCount
            && self.prgInputScripts == other.prgInputScripts
            && self.dwOutputScriptsCount == other.dwOutputScriptsCount
            && self.prgOutputScripts == other.prgOutputScripts
            && self.guid == other.guid
            && self.pszCategory == other.pszCategory
            && self.pszDescription == other.pszDescription
            && self.dwPrivateDataSize == other.dwPrivateDataSize
            && self.pPrivateData == other.pPrivateData
            && self.pContext == other.pContext
            && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_SERVICE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_SERVICE_INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_DEFAULTCHAR: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_LEADBYTES: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_LOCALE_NAME: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_MIMECP_NAME: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_MIMECSET_NAME: u32 = 50u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_MIMEFACE_NAME: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_RFC1766_NAME: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MAX_SCRIPT_NAME: u32 = 48u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MIMECONTF(pub i32);
pub const MIMECONTF_MAILNEWS: MIMECONTF = MIMECONTF(1i32);
pub const MIMECONTF_BROWSER: MIMECONTF = MIMECONTF(2i32);
pub const MIMECONTF_MINIMAL: MIMECONTF = MIMECONTF(4i32);
pub const MIMECONTF_IMPORT: MIMECONTF = MIMECONTF(8i32);
pub const MIMECONTF_SAVABLE_MAILNEWS: MIMECONTF = MIMECONTF(256i32);
pub const MIMECONTF_SAVABLE_BROWSER: MIMECONTF = MIMECONTF(512i32);
pub const MIMECONTF_EXPORT: MIMECONTF = MIMECONTF(1024i32);
pub const MIMECONTF_PRIVCONVERTER: MIMECONTF = MIMECONTF(65536i32);
pub const MIMECONTF_VALID: MIMECONTF = MIMECONTF(131072i32);
pub const MIMECONTF_VALID_NLS: MIMECONTF = MIMECONTF(262144i32);
pub const MIMECONTF_MIME_IE4: MIMECONTF = MIMECONTF(268435456i32);
pub const MIMECONTF_MIME_LATEST: MIMECONTF = MIMECONTF(536870912i32);
pub const MIMECONTF_MIME_REGISTRY: MIMECONTF = MIMECONTF(1073741824i32);
impl ::std::convert::From<i32> for MIMECONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MIMECONTF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct MIMECPINFO {
    pub dwFlags: u32,
    pub uiCodePage: u32,
    pub uiFamilyCodePage: u32,
    pub wszDescription: [u16; 64],
    pub wszWebCharset: [u16; 50],
    pub wszHeaderCharset: [u16; 50],
    pub wszBodyCharset: [u16; 50],
    pub wszFixedWidthFont: [u16; 32],
    pub wszProportionalFont: [u16; 32],
    pub bGDICharset: u8,
}
impl MIMECPINFO {}
impl ::std::default::Default for MIMECPINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MIMECPINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MIMECPINFO")
            .field("dwFlags", &self.dwFlags)
            .field("uiCodePage", &self.uiCodePage)
            .field("uiFamilyCodePage", &self.uiFamilyCodePage)
            .field("wszDescription", &self.wszDescription)
            .field("wszWebCharset", &self.wszWebCharset)
            .field("wszHeaderCharset", &self.wszHeaderCharset)
            .field("wszBodyCharset", &self.wszBodyCharset)
            .field("wszFixedWidthFont", &self.wszFixedWidthFont)
            .field("wszProportionalFont", &self.wszProportionalFont)
            .field("bGDICharset", &self.bGDICharset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for MIMECPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.uiCodePage == other.uiCodePage && self.uiFamilyCodePage == other.uiFamilyCodePage && self.wszDescription == other.wszDescription && self.wszWebCharset == other.wszWebCharset && self.wszHeaderCharset == other.wszHeaderCharset && self.wszBodyCharset == other.wszBodyCharset && self.wszFixedWidthFont == other.wszFixedWidthFont && self.wszProportionalFont == other.wszProportionalFont && self.bGDICharset == other.bGDICharset
    }
}
impl ::std::cmp::Eq for MIMECPINFO {}
unsafe impl ::windows::runtime::Abi for MIMECPINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct MIMECSETINFO {
    pub uiCodePage: u32,
    pub uiInternetEncoding: u32,
    pub wszCharset: [u16; 50],
}
impl MIMECSETINFO {}
impl ::std::default::Default for MIMECSETINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MIMECSETINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MIMECSETINFO").field("uiCodePage", &self.uiCodePage).field("uiInternetEncoding", &self.uiInternetEncoding).field("wszCharset", &self.wszCharset).finish()
    }
}
impl ::std::cmp::PartialEq for MIMECSETINFO {
    fn eq(&self, other: &Self) -> bool {
        self.uiCodePage == other.uiCodePage && self.uiInternetEncoding == other.uiInternetEncoding && self.wszCharset == other.wszCharset
    }
}
impl ::std::cmp::Eq for MIMECSETINFO {}
unsafe impl ::windows::runtime::Abi for MIMECSETINFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MIN_SPELLING_NTDDI: u32 = 100794368u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MLDETECTCP(pub i32);
pub const MLDETECTCP_NONE: MLDETECTCP = MLDETECTCP(0i32);
pub const MLDETECTCP_7BIT: MLDETECTCP = MLDETECTCP(1i32);
pub const MLDETECTCP_8BIT: MLDETECTCP = MLDETECTCP(2i32);
pub const MLDETECTCP_DBCS: MLDETECTCP = MLDETECTCP(4i32);
pub const MLDETECTCP_HTML: MLDETECTCP = MLDETECTCP(8i32);
pub const MLDETECTCP_NUMBER: MLDETECTCP = MLDETECTCP(16i32);
impl ::std::convert::From<i32> for MLDETECTCP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MLDETECTCP {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MLSTR_FLAGS(pub i32);
pub const MLSTR_READ: MLSTR_FLAGS = MLSTR_FLAGS(1i32);
pub const MLSTR_WRITE: MLSTR_FLAGS = MLSTR_FLAGS(2i32);
impl ::std::convert::From<i32> for MLSTR_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MLSTR_FLAGS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_COMPLEX_SCRIPT_FILTER: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_CONSOLE_FILTER: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FILEINFO_VERSION: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MAIN: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MUI: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FILETYPE_NOT_LANGUAGE_NEUTRAL: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FORMAT_INF_COMPAT: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FORMAT_REG_COMPAT: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_FULL_LANGUAGE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_IMMUTABLE_LOOKUP: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANGUAGE_EXACT: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANGUAGE_ID: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANGUAGE_INSTALLED: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANGUAGE_LICENSED: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANGUAGE_NAME: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LANG_NEUTRAL_PE_FILE: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_LIP_LANGUAGE: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_MACHINE_LANGUAGE_SETTINGS: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_MERGE_SYSTEM_FALLBACK: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_MERGE_USER_FALLBACK: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_NON_LANG_NEUTRAL_FILE: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_PARTIAL_LANGUAGE: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_QUERY_CHECKSUM: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_QUERY_LANGUAGE_NAME: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_QUERY_RESOURCE_TYPES: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_QUERY_TYPE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_RESET_FILTERS: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_SKIP_STRING_CACHE: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_THREAD_LANGUAGES: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_USER_PREFERRED_UI_LANGUAGES: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_USE_INSTALLED_LANGUAGES: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_USE_SEARCH_ALL_LANGUAGES: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const MUI_VERIFY_FILE_EXISTS: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct MULTI_BYTE_TO_WIDE_CHAR_FLAGS(pub u32);
pub const MB_COMPOSITE: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(2u32);
pub const MB_ERR_INVALID_CHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(8u32);
pub const MB_PRECOMPOSED: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(1u32);
pub const MB_USEGLYPHCHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(4u32);
impl ::std::convert::From<u32> for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MappingDoAction<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pbag: *mut MAPPING_PROPERTY_BAG, dwrangeindex: u32, pszactionid: Param2) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingDoAction(pbag: *mut MAPPING_PROPERTY_BAG, dwrangeindex: u32, pszactionid: super::Foundation::PWSTR) -> ::windows::runtime::HRESULT;
        }
        MappingDoAction(::std::mem::transmute(pbag), ::std::mem::transmute(dwrangeindex), pszactionid.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MappingFreePropertyBag(pbag: *const MAPPING_PROPERTY_BAG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingFreePropertyBag(pbag: *const MAPPING_PROPERTY_BAG) -> ::windows::runtime::HRESULT;
        }
        MappingFreePropertyBag(::std::mem::transmute(pbag)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MappingFreeServices(pserviceinfo: *const MAPPING_SERVICE_INFO) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingFreeServices(pserviceinfo: *const MAPPING_SERVICE_INFO) -> ::windows::runtime::HRESULT;
        }
        MappingFreeServices(::std::mem::transmute(pserviceinfo)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MappingGetServices(poptions: *const MAPPING_ENUM_OPTIONS, prgservices: *mut *mut MAPPING_SERVICE_INFO, pdwservicescount: *mut u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingGetServices(poptions: *const MAPPING_ENUM_OPTIONS, prgservices: *mut *mut MAPPING_SERVICE_INFO, pdwservicescount: *mut u32) -> ::windows::runtime::HRESULT;
        }
        MappingGetServices(::std::mem::transmute(poptions), ::std::mem::transmute(prgservices), ::std::mem::transmute(pdwservicescount)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MappingRecognizeText<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pserviceinfo: *const MAPPING_SERVICE_INFO, psztext: Param1, dwlength: u32, dwindex: u32, poptions: *const MAPPING_OPTIONS, pbag: *mut MAPPING_PROPERTY_BAG) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingRecognizeText(pserviceinfo: *const MAPPING_SERVICE_INFO, psztext: super::Foundation::PWSTR, dwlength: u32, dwindex: u32, poptions: *const ::std::mem::ManuallyDrop<MAPPING_OPTIONS>, pbag: *mut MAPPING_PROPERTY_BAG) -> ::windows::runtime::HRESULT;
        }
        MappingRecognizeText(::std::mem::transmute(pserviceinfo), psztext.into_param().abi(), ::std::mem::transmute(dwlength), ::std::mem::transmute(dwindex), ::std::mem::transmute(poptions), ::std::mem::transmute(pbag)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MultiByteToWideChar<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(codepage: u32, dwflags: MULTI_BYTE_TO_WIDE_CHAR_FLAGS, lpmultibytestr: Param2, cbmultibyte: i32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MultiByteToWideChar(codepage: u32, dwflags: MULTI_BYTE_TO_WIDE_CHAR_FLAGS, lpmultibytestr: super::Foundation::PSTR, cbmultibyte: i32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32) -> i32;
        }
        ::std::mem::transmute(MultiByteToWideChar(::std::mem::transmute(codepage), ::std::mem::transmute(dwflags), lpmultibytestr.into_param().abi(), ::std::mem::transmute(cbmultibyte), ::std::mem::transmute(lpwidecharstr), ::std::mem::transmute(cchwidechar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
pub struct NEWTEXTMETRICEXA {
    pub ntmTm: super::Graphics::Gdi::NEWTEXTMETRICA,
    pub ntmFontSig: FONTSIGNATURE,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl NEWTEXTMETRICEXA {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for NEWTEXTMETRICEXA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for NEWTEXTMETRICEXA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NEWTEXTMETRICEXA").field("ntmTm", &self.ntmTm).field("ntmFontSig", &self.ntmFontSig).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for NEWTEXTMETRICEXA {
    fn eq(&self, other: &Self) -> bool {
        self.ntmTm == other.ntmTm && self.ntmFontSig == other.ntmFontSig
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for NEWTEXTMETRICEXA {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for NEWTEXTMETRICEXA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
pub struct NEWTEXTMETRICEXW {
    pub ntmTm: super::Graphics::Gdi::NEWTEXTMETRICW,
    pub ntmFontSig: FONTSIGNATURE,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl NEWTEXTMETRICEXW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for NEWTEXTMETRICEXW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for NEWTEXTMETRICEXW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NEWTEXTMETRICEXW").field("ntmTm", &self.ntmTm).field("ntmFontSig", &self.ntmFontSig).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for NEWTEXTMETRICEXW {
    fn eq(&self, other: &Self) -> bool {
        self.ntmTm == other.ntmTm && self.ntmFontSig == other.ntmFontSig
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for NEWTEXTMETRICEXW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for NEWTEXTMETRICEXW {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct NLSVERSIONINFO {
    pub dwNLSVersionInfoSize: u32,
    pub dwNLSVersion: u32,
    pub dwDefinedVersion: u32,
    pub dwEffectiveId: u32,
    pub guidCustomVersion: ::windows::runtime::GUID,
}
impl NLSVERSIONINFO {}
impl ::std::default::Default for NLSVERSIONINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NLSVERSIONINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NLSVERSIONINFO").field("dwNLSVersionInfoSize", &self.dwNLSVersionInfoSize).field("dwNLSVersion", &self.dwNLSVersion).field("dwDefinedVersion", &self.dwDefinedVersion).field("dwEffectiveId", &self.dwEffectiveId).field("guidCustomVersion", &self.guidCustomVersion).finish()
    }
}
impl ::std::cmp::PartialEq for NLSVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwNLSVersionInfoSize == other.dwNLSVersionInfoSize && self.dwNLSVersion == other.dwNLSVersion && self.dwDefinedVersion == other.dwDefinedVersion && self.dwEffectiveId == other.dwEffectiveId && self.guidCustomVersion == other.guidCustomVersion
    }
}
impl ::std::cmp::Eq for NLSVERSIONINFO {}
unsafe impl ::windows::runtime::Abi for NLSVERSIONINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct NLSVERSIONINFOEX {
    pub dwNLSVersionInfoSize: u32,
    pub dwNLSVersion: u32,
    pub dwDefinedVersion: u32,
    pub dwEffectiveId: u32,
    pub guidCustomVersion: ::windows::runtime::GUID,
}
impl NLSVERSIONINFOEX {}
impl ::std::default::Default for NLSVERSIONINFOEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NLSVERSIONINFOEX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NLSVERSIONINFOEX").field("dwNLSVersionInfoSize", &self.dwNLSVersionInfoSize).field("dwNLSVersion", &self.dwNLSVersion).field("dwDefinedVersion", &self.dwDefinedVersion).field("dwEffectiveId", &self.dwEffectiveId).field("guidCustomVersion", &self.guidCustomVersion).finish()
    }
}
impl ::std::cmp::PartialEq for NLSVERSIONINFOEX {
    fn eq(&self, other: &Self) -> bool {
        self.dwNLSVersionInfoSize == other.dwNLSVersionInfoSize && self.dwNLSVersion == other.dwNLSVersion && self.dwDefinedVersion == other.dwDefinedVersion && self.dwEffectiveId == other.dwEffectiveId && self.guidCustomVersion == other.guidCustomVersion
    }
}
impl ::std::cmp::Eq for NLSVERSIONINFOEX {}
unsafe impl ::windows::runtime::Abi for NLSVERSIONINFOEX {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const NLS_CP_CPINFO: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const NLS_CP_MBTOWC: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const NLS_CP_WCTOMB: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct NORM_FORM(pub i32);
pub const NormalizationOther: NORM_FORM = NORM_FORM(0i32);
pub const NormalizationC: NORM_FORM = NORM_FORM(1i32);
pub const NormalizationD: NORM_FORM = NORM_FORM(2i32);
pub const NormalizationKC: NORM_FORM = NORM_FORM(5i32);
pub const NormalizationKD: NORM_FORM = NORM_FORM(6i32);
impl ::std::convert::From<i32> for NORM_FORM {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for NORM_FORM {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct NUMBERFMTA {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PSTR,
    pub lpThousandSep: super::Foundation::PSTR,
    pub NegativeOrder: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl NUMBERFMTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NUMBERFMTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NUMBERFMTA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NUMBERFMTA").field("NumDigits", &self.NumDigits).field("LeadingZero", &self.LeadingZero).field("Grouping", &self.Grouping).field("lpDecimalSep", &self.lpDecimalSep).field("lpThousandSep", &self.lpThousandSep).field("NegativeOrder", &self.NegativeOrder).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NUMBERFMTA {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits && self.LeadingZero == other.LeadingZero && self.Grouping == other.Grouping && self.lpDecimalSep == other.lpDecimalSep && self.lpThousandSep == other.lpThousandSep && self.NegativeOrder == other.NegativeOrder
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NUMBERFMTA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NUMBERFMTA {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct NUMBERFMTW {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PWSTR,
    pub lpThousandSep: super::Foundation::PWSTR,
    pub NegativeOrder: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl NUMBERFMTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NUMBERFMTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NUMBERFMTW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NUMBERFMTW").field("NumDigits", &self.NumDigits).field("LeadingZero", &self.LeadingZero).field("Grouping", &self.Grouping).field("lpDecimalSep", &self.lpDecimalSep).field("lpThousandSep", &self.lpThousandSep).field("NegativeOrder", &self.NegativeOrder).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NUMBERFMTW {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits && self.LeadingZero == other.LeadingZero && self.Grouping == other.Grouping && self.lpDecimalSep == other.lpDecimalSep && self.lpThousandSep == other.lpThousandSep && self.NegativeOrder == other.NegativeOrder
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NUMBERFMTW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NUMBERFMTW {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const NUMSYS_NAME_CAPACITY: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NormalizeString<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(normform: NORM_FORM, lpsrcstring: Param1, cwsrclength: i32, lpdststring: super::Foundation::PWSTR, cwdstlength: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn NormalizeString(normform: NORM_FORM, lpsrcstring: super::Foundation::PWSTR, cwsrclength: i32, lpdststring: super::Foundation::PWSTR, cwdstlength: i32) -> i32;
        }
        ::std::mem::transmute(NormalizeString(::std::mem::transmute(normform), lpsrcstring.into_param().abi(), ::std::mem::transmute(cwsrclength), ::std::mem::transmute(lpdststring), ::std::mem::transmute(cwdstlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NotifyUILanguageChange<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pcwstrnewlanguage: Param1, pcwstrpreviouslanguage: Param2, dwreserved: u32, pdwstatusrtrn: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn NotifyUILanguageChange(dwflags: u32, pcwstrnewlanguage: super::Foundation::PWSTR, pcwstrpreviouslanguage: super::Foundation::PWSTR, dwreserved: u32, pdwstatusrtrn: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(NotifyUILanguageChange(::std::mem::transmute(dwflags), pcwstrnewlanguage.into_param().abi(), pcwstrpreviouslanguage.into_param().abi(), ::std::mem::transmute(dwreserved), ::std::mem::transmute(pdwstatusrtrn)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const OFFLINE_SERVICES: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ONLINE_SERVICES: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type PFN_MAPPINGCALLBACKPROC = unsafe extern "system" fn(pbag: *mut MAPPING_PROPERTY_BAG, data: *mut ::std::ffi::c_void, dwdatasize: u32, result: ::windows::runtime::HRESULT);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct RFC1766INFO {
    pub lcid: u32,
    pub wszRfc1766: [u16; 6],
    pub wszLocaleName: [u16; 32],
}
impl RFC1766INFO {}
impl ::std::default::Default for RFC1766INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for RFC1766INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("RFC1766INFO").field("lcid", &self.lcid).field("wszRfc1766", &self.wszRfc1766).field("wszLocaleName", &self.wszLocaleName).finish()
    }
}
impl ::std::cmp::PartialEq for RFC1766INFO {
    fn eq(&self, other: &Self) -> bool {
        self.lcid == other.lcid && self.wszRfc1766 == other.wszRfc1766 && self.wszLocaleName == other.wszLocaleName
    }
}
impl ::std::cmp::Eq for RFC1766INFO {}
unsafe impl ::windows::runtime::Abi for RFC1766INFO {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ResolveLocaleName<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpnametoresolve: Param0, lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ResolveLocaleName(lpnametoresolve: super::Foundation::PWSTR, lplocalename: super::Foundation::PWSTR, cchlocalename: i32) -> i32;
        }
        ::std::mem::transmute(ResolveLocaleName(lpnametoresolve.into_param().abi(), ::std::mem::transmute(lplocalename), ::std::mem::transmute(cchlocalename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn RestoreThreadPreferredUILanguages<'a, Param0: ::windows::runtime::IntoParam<'a, HSAVEDUILANGUAGES>>(snapshot: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn RestoreThreadPreferredUILanguages(snapshot: HSAVEDUILANGUAGES);
        }
        ::std::mem::transmute(RestoreThreadPreferredUILanguages(snapshot.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SCRIPTCONTF(pub i32);
pub const sidDefault: SCRIPTCONTF = SCRIPTCONTF(0i32);
pub const sidMerge: SCRIPTCONTF = SCRIPTCONTF(1i32);
pub const sidAsciiSym: SCRIPTCONTF = SCRIPTCONTF(2i32);
pub const sidAsciiLatin: SCRIPTCONTF = SCRIPTCONTF(3i32);
pub const sidLatin: SCRIPTCONTF = SCRIPTCONTF(4i32);
pub const sidGreek: SCRIPTCONTF = SCRIPTCONTF(5i32);
pub const sidCyrillic: SCRIPTCONTF = SCRIPTCONTF(6i32);
pub const sidArmenian: SCRIPTCONTF = SCRIPTCONTF(7i32);
pub const sidHebrew: SCRIPTCONTF = SCRIPTCONTF(8i32);
pub const sidArabic: SCRIPTCONTF = SCRIPTCONTF(9i32);
pub const sidDevanagari: SCRIPTCONTF = SCRIPTCONTF(10i32);
pub const sidBengali: SCRIPTCONTF = SCRIPTCONTF(11i32);
pub const sidGurmukhi: SCRIPTCONTF = SCRIPTCONTF(12i32);
pub const sidGujarati: SCRIPTCONTF = SCRIPTCONTF(13i32);
pub const sidOriya: SCRIPTCONTF = SCRIPTCONTF(14i32);
pub const sidTamil: SCRIPTCONTF = SCRIPTCONTF(15i32);
pub const sidTelugu: SCRIPTCONTF = SCRIPTCONTF(16i32);
pub const sidKannada: SCRIPTCONTF = SCRIPTCONTF(17i32);
pub const sidMalayalam: SCRIPTCONTF = SCRIPTCONTF(18i32);
pub const sidThai: SCRIPTCONTF = SCRIPTCONTF(19i32);
pub const sidLao: SCRIPTCONTF = SCRIPTCONTF(20i32);
pub const sidTibetan: SCRIPTCONTF = SCRIPTCONTF(21i32);
pub const sidGeorgian: SCRIPTCONTF = SCRIPTCONTF(22i32);
pub const sidHangul: SCRIPTCONTF = SCRIPTCONTF(23i32);
pub const sidKana: SCRIPTCONTF = SCRIPTCONTF(24i32);
pub const sidBopomofo: SCRIPTCONTF = SCRIPTCONTF(25i32);
pub const sidHan: SCRIPTCONTF = SCRIPTCONTF(26i32);
pub const sidEthiopic: SCRIPTCONTF = SCRIPTCONTF(27i32);
pub const sidCanSyllabic: SCRIPTCONTF = SCRIPTCONTF(28i32);
pub const sidCherokee: SCRIPTCONTF = SCRIPTCONTF(29i32);
pub const sidYi: SCRIPTCONTF = SCRIPTCONTF(30i32);
pub const sidBraille: SCRIPTCONTF = SCRIPTCONTF(31i32);
pub const sidRunic: SCRIPTCONTF = SCRIPTCONTF(32i32);
pub const sidOgham: SCRIPTCONTF = SCRIPTCONTF(33i32);
pub const sidSinhala: SCRIPTCONTF = SCRIPTCONTF(34i32);
pub const sidSyriac: SCRIPTCONTF = SCRIPTCONTF(35i32);
pub const sidBurmese: SCRIPTCONTF = SCRIPTCONTF(36i32);
pub const sidKhmer: SCRIPTCONTF = SCRIPTCONTF(37i32);
pub const sidThaana: SCRIPTCONTF = SCRIPTCONTF(38i32);
pub const sidMongolian: SCRIPTCONTF = SCRIPTCONTF(39i32);
pub const sidUserDefined: SCRIPTCONTF = SCRIPTCONTF(40i32);
pub const sidLim: SCRIPTCONTF = SCRIPTCONTF(41i32);
pub const sidFEFirst: SCRIPTCONTF = SCRIPTCONTF(23i32);
pub const sidFELast: SCRIPTCONTF = SCRIPTCONTF(26i32);
impl ::std::convert::From<i32> for SCRIPTCONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPTCONTF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SCRIPTFONTCONTF(pub i32);
pub const SCRIPTCONTF_FIXED_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(1i32);
pub const SCRIPTCONTF_PROPORTIONAL_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(2i32);
pub const SCRIPTCONTF_SCRIPT_USER: SCRIPTFONTCONTF = SCRIPTFONTCONTF(65536i32);
pub const SCRIPTCONTF_SCRIPT_HIDE: SCRIPTFONTCONTF = SCRIPTFONTCONTF(131072i32);
pub const SCRIPTCONTF_SCRIPT_SYSTEM: SCRIPTFONTCONTF = SCRIPTFONTCONTF(262144i32);
impl ::std::convert::From<i32> for SCRIPTFONTCONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPTFONTCONTF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPTINFO {
    pub ScriptId: u8,
    pub uiCodePage: u32,
    pub wszDescription: [u16; 48],
    pub wszFixedWidthFont: [u16; 32],
    pub wszProportionalFont: [u16; 32],
}
impl SCRIPTINFO {}
impl ::std::default::Default for SCRIPTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPTINFO").field("ScriptId", &self.ScriptId).field("uiCodePage", &self.uiCodePage).field("wszDescription", &self.wszDescription).field("wszFixedWidthFont", &self.wszFixedWidthFont).field("wszProportionalFont", &self.wszProportionalFont).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ScriptId == other.ScriptId && self.uiCodePage == other.uiCodePage && self.wszDescription == other.wszDescription && self.wszFixedWidthFont == other.wszFixedWidthFont && self.wszProportionalFont == other.wszProportionalFont
    }
}
impl ::std::cmp::Eq for SCRIPTINFO {}
unsafe impl ::windows::runtime::Abi for SCRIPTINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_ANALYSIS {
    pub _bitfield: u16,
    pub s: SCRIPT_STATE,
}
impl SCRIPT_ANALYSIS {}
impl ::std::default::Default for SCRIPT_ANALYSIS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_ANALYSIS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_ANALYSIS").field("_bitfield", &self._bitfield).field("s", &self.s).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_ANALYSIS {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield && self.s == other.s
    }
}
impl ::std::cmp::Eq for SCRIPT_ANALYSIS {}
unsafe impl ::windows::runtime::Abi for SCRIPT_ANALYSIS {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_CONTROL {
    pub _bitfield: u32,
}
impl SCRIPT_CONTROL {}
impl ::std::default::Default for SCRIPT_CONTROL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_CONTROL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_CONTROL").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_CONTROL {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_CONTROL {}
unsafe impl ::windows::runtime::Abi for SCRIPT_CONTROL {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_DIGITSUBSTITUTE {
    pub _bitfield1: u32,
    pub _bitfield2: u32,
    pub dwReserved: u32,
}
impl SCRIPT_DIGITSUBSTITUTE {}
impl ::std::default::Default for SCRIPT_DIGITSUBSTITUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_DIGITSUBSTITUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_DIGITSUBSTITUTE").field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).field("dwReserved", &self.dwReserved).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_DIGITSUBSTITUTE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2 && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for SCRIPT_DIGITSUBSTITUTE {}
unsafe impl ::windows::runtime::Abi for SCRIPT_DIGITSUBSTITUTE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_DIGITSUBSTITUTE_CONTEXT: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_DIGITSUBSTITUTE_NATIONAL: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_DIGITSUBSTITUTE_NONE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_DIGITSUBSTITUTE_TRADITIONAL: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_FONTPROPERTIES {
    pub cBytes: i32,
    pub wgBlank: u16,
    pub wgDefault: u16,
    pub wgInvalid: u16,
    pub wgKashida: u16,
    pub iKashidaWidth: i32,
}
impl SCRIPT_FONTPROPERTIES {}
impl ::std::default::Default for SCRIPT_FONTPROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_FONTPROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_FONTPROPERTIES").field("cBytes", &self.cBytes).field("wgBlank", &self.wgBlank).field("wgDefault", &self.wgDefault).field("wgInvalid", &self.wgInvalid).field("wgKashida", &self.wgKashida).field("iKashidaWidth", &self.iKashidaWidth).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_FONTPROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.cBytes == other.cBytes && self.wgBlank == other.wgBlank && self.wgDefault == other.wgDefault && self.wgInvalid == other.wgInvalid && self.wgKashida == other.wgKashida && self.iKashidaWidth == other.iKashidaWidth
    }
}
impl ::std::cmp::Eq for SCRIPT_FONTPROPERTIES {}
unsafe impl ::windows::runtime::Abi for SCRIPT_FONTPROPERTIES {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SCRIPT_IS_COMPLEX_FLAGS(pub u32);
pub const SIC_ASCIIDIGIT: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(2u32);
pub const SIC_COMPLEX: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(1u32);
pub const SIC_NEUTRAL: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(4u32);
impl ::std::convert::From<u32> for SCRIPT_IS_COMPLEX_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPT_IS_COMPLEX_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for SCRIPT_IS_COMPLEX_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for SCRIPT_IS_COMPLEX_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_ITEM {
    pub iCharPos: i32,
    pub a: SCRIPT_ANALYSIS,
}
impl SCRIPT_ITEM {}
impl ::std::default::Default for SCRIPT_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_ITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_ITEM").field("iCharPos", &self.iCharPos).field("a", &self.a).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.iCharPos == other.iCharPos && self.a == other.a
    }
}
impl ::std::cmp::Eq for SCRIPT_ITEM {}
unsafe impl ::windows::runtime::Abi for SCRIPT_ITEM {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SCRIPT_JUSTIFY(pub i32);
pub const SCRIPT_JUSTIFY_NONE: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(0i32);
pub const SCRIPT_JUSTIFY_ARABIC_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(1i32);
pub const SCRIPT_JUSTIFY_CHARACTER: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(2i32);
pub const SCRIPT_JUSTIFY_RESERVED1: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(3i32);
pub const SCRIPT_JUSTIFY_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(4i32);
pub const SCRIPT_JUSTIFY_RESERVED2: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(5i32);
pub const SCRIPT_JUSTIFY_RESERVED3: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(6i32);
pub const SCRIPT_JUSTIFY_ARABIC_NORMAL: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(7i32);
pub const SCRIPT_JUSTIFY_ARABIC_KASHIDA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(8i32);
pub const SCRIPT_JUSTIFY_ARABIC_ALEF: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(9i32);
pub const SCRIPT_JUSTIFY_ARABIC_HA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(10i32);
pub const SCRIPT_JUSTIFY_ARABIC_RA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(11i32);
pub const SCRIPT_JUSTIFY_ARABIC_BA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(12i32);
pub const SCRIPT_JUSTIFY_ARABIC_BARA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(13i32);
pub const SCRIPT_JUSTIFY_ARABIC_SEEN: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(14i32);
pub const SCRIPT_JUSTIFY_ARABIC_SEEN_M: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(15i32);
impl ::std::convert::From<i32> for SCRIPT_JUSTIFY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPT_JUSTIFY {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_LOGATTR {
    pub _bitfield: u8,
}
impl SCRIPT_LOGATTR {}
impl ::std::default::Default for SCRIPT_LOGATTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_LOGATTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_LOGATTR").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_LOGATTR {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_LOGATTR {}
unsafe impl ::windows::runtime::Abi for SCRIPT_LOGATTR {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_PROPERTIES {
    pub _bitfield1: u32,
    pub _bitfield2: u32,
}
impl SCRIPT_PROPERTIES {}
impl ::std::default::Default for SCRIPT_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_PROPERTIES").field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2
    }
}
impl ::std::cmp::Eq for SCRIPT_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for SCRIPT_PROPERTIES {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_STATE {
    pub _bitfield: u16,
}
impl SCRIPT_STATE {}
impl ::std::default::Default for SCRIPT_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_STATE").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_STATE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_STATE {}
unsafe impl ::windows::runtime::Abi for SCRIPT_STATE {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_TABDEF {
    pub cTabStops: i32,
    pub iScale: i32,
    pub pTabStops: *mut i32,
    pub iTabOrigin: i32,
}
impl SCRIPT_TABDEF {}
impl ::std::default::Default for SCRIPT_TABDEF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_TABDEF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_TABDEF").field("cTabStops", &self.cTabStops).field("iScale", &self.iScale).field("pTabStops", &self.pTabStops).field("iTabOrigin", &self.iTabOrigin).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_TABDEF {
    fn eq(&self, other: &Self) -> bool {
        self.cTabStops == other.cTabStops && self.iScale == other.iScale && self.pTabStops == other.pTabStops && self.iTabOrigin == other.iTabOrigin
    }
}
impl ::std::cmp::Eq for SCRIPT_TABDEF {}
unsafe impl ::windows::runtime::Abi for SCRIPT_TABDEF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_TAG_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SCRIPT_UNDEFINED: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct SCRIPT_VISATTR {
    pub _bitfield: u16,
}
impl SCRIPT_VISATTR {}
impl ::std::default::Default for SCRIPT_VISATTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_VISATTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_VISATTR").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_VISATTR {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_VISATTR {}
unsafe impl ::windows::runtime::Abi for SCRIPT_VISATTR {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SGCM_RTL: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SORTING_PARADIGM_ICU: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SORTING_PARADIGM_NLS: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_BREAK: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_CLIP: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_DONTGLYPH: u32 = 1073741824u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_DZWG: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_FALLBACK: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_FIT: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_FULLMEASURE: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_GCP: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_GLYPHS: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_HIDEHOTKEY: u32 = 8192u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_HOTKEY: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_HOTKEYONLY: u32 = 9216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_LAYOUTRTL: u32 = 536870912u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_LINK: u32 = 4096u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_LPKANSIFALLBACK: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_METAFILE: u32 = 2048u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_NOKASHIDA: u32 = 2147483648u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_PASSWORD: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_PIDX: u32 = 268435456u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_RTL: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const SSA_TAB: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SYSGEOCLASS(pub i32);
pub const GEOCLASS_NATION: SYSGEOCLASS = SYSGEOCLASS(16i32);
pub const GEOCLASS_REGION: SYSGEOCLASS = SYSGEOCLASS(14i32);
pub const GEOCLASS_ALL: SYSGEOCLASS = SYSGEOCLASS(0i32);
impl ::std::convert::From<i32> for SYSGEOCLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSGEOCLASS {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SYSGEOTYPE(pub i32);
pub const GEO_NATION: SYSGEOTYPE = SYSGEOTYPE(1i32);
pub const GEO_LATITUDE: SYSGEOTYPE = SYSGEOTYPE(2i32);
pub const GEO_LONGITUDE: SYSGEOTYPE = SYSGEOTYPE(3i32);
pub const GEO_ISO2: SYSGEOTYPE = SYSGEOTYPE(4i32);
pub const GEO_ISO3: SYSGEOTYPE = SYSGEOTYPE(5i32);
pub const GEO_RFC1766: SYSGEOTYPE = SYSGEOTYPE(6i32);
pub const GEO_LCID: SYSGEOTYPE = SYSGEOTYPE(7i32);
pub const GEO_FRIENDLYNAME: SYSGEOTYPE = SYSGEOTYPE(8i32);
pub const GEO_OFFICIALNAME: SYSGEOTYPE = SYSGEOTYPE(9i32);
pub const GEO_TIMEZONES: SYSGEOTYPE = SYSGEOTYPE(10i32);
pub const GEO_OFFICIALLANGUAGES: SYSGEOTYPE = SYSGEOTYPE(11i32);
pub const GEO_ISO_UN_NUMBER: SYSGEOTYPE = SYSGEOTYPE(12i32);
pub const GEO_PARENT: SYSGEOTYPE = SYSGEOTYPE(13i32);
pub const GEO_DIALINGCODE: SYSGEOTYPE = SYSGEOTYPE(14i32);
pub const GEO_CURRENCYCODE: SYSGEOTYPE = SYSGEOTYPE(15i32);
pub const GEO_CURRENCYSYMBOL: SYSGEOTYPE = SYSGEOTYPE(16i32);
pub const GEO_NAME: SYSGEOTYPE = SYSGEOTYPE(17i32);
pub const GEO_ID: SYSGEOTYPE = SYSGEOTYPE(18i32);
impl ::std::convert::From<i32> for SYSGEOTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSGEOTYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct SYSNLS_FUNCTION(pub i32);
pub const COMPARE_STRING: SYSNLS_FUNCTION = SYSNLS_FUNCTION(1i32);
impl ::std::convert::From<i32> for SYSNLS_FUNCTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSNLS_FUNCTION {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptApplyDigitSubstitution(psds: *const SCRIPT_DIGITSUBSTITUTE, psc: *mut SCRIPT_CONTROL, pss: *mut SCRIPT_STATE) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptApplyDigitSubstitution(psds: *const SCRIPT_DIGITSUBSTITUTE, psc: *mut SCRIPT_CONTROL, pss: *mut SCRIPT_STATE) -> ::windows::runtime::HRESULT;
        }
        ScriptApplyDigitSubstitution(::std::mem::transmute(psds), ::std::mem::transmute(psc), ::std::mem::transmute(pss)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptApplyLogicalWidth(pidx: *const i32, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pabc: *mut super::Graphics::Gdi::ABC, pijustify: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptApplyLogicalWidth(pidx: *const i32, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pabc: *mut super::Graphics::Gdi::ABC, pijustify: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptApplyLogicalWidth(::std::mem::transmute(pidx), ::std::mem::transmute(cchars), ::std::mem::transmute(cglyphs), ::std::mem::transmute(pwlogclust), ::std::mem::transmute(psva), ::std::mem::transmute(piadvance), ::std::mem::transmute(psa), ::std::mem::transmute(pabc), ::std::mem::transmute(pijustify)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptBreak<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pwcchars: Param0, cchars: i32, psa: *const SCRIPT_ANALYSIS) -> ::windows::runtime::Result<SCRIPT_LOGATTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptBreak(pwcchars: super::Foundation::PWSTR, cchars: i32, psa: *const SCRIPT_ANALYSIS, psla: *mut SCRIPT_LOGATTR) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <SCRIPT_LOGATTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptBreak(pwcchars.into_param().abi(), ::std::mem::transmute(cchars), ::std::mem::transmute(psa), &mut result__).from_abi::<SCRIPT_LOGATTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptCPtoX<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(icp: i32, ftrailing: Param1, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pix: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptCPtoX(icp: i32, ftrailing: super::Foundation::BOOL, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pix: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptCPtoX(::std::mem::transmute(icp), ftrailing.into_param().abi(), ::std::mem::transmute(cchars), ::std::mem::transmute(cglyphs), ::std::mem::transmute(pwlogclust), ::std::mem::transmute(psva), ::std::mem::transmute(piadvance), ::std::mem::transmute(psa), ::std::mem::transmute(pix)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptCacheGetHeight<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, tmheight: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptCacheGetHeight(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, tmheight: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptCacheGetHeight(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(tmheight)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptFreeCache(psc: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptFreeCache(psc: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptFreeCache(::std::mem::transmute(psc)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptGetCMap<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, pwcinchars: Param2, cchars: i32, dwflags: u32, pwoutglyphs: *mut u16) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetCMap(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, pwcinchars: super::Foundation::PWSTR, cchars: i32, dwflags: u32, pwoutglyphs: *mut u16) -> ::windows::runtime::HRESULT;
        }
        ScriptGetCMap(hdc.into_param().abi(), ::std::mem::transmute(psc), pwcinchars.into_param().abi(), ::std::mem::transmute(cchars), ::std::mem::transmute(dwflags), ::std::mem::transmute(pwoutglyphs)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontAlternateGlyphs<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, wglyphid: u16, cmaxalternates: i32, palternateglyphs: *mut u16, pcalternates: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontAlternateGlyphs(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, wglyphid: u16, cmaxalternates: i32, palternateglyphs: *mut u16, pcalternates: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontAlternateGlyphs(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(tagfeature),
            ::std::mem::transmute(wglyphid),
            ::std::mem::transmute(cmaxalternates),
            ::std::mem::transmute(palternateglyphs),
            ::std::mem::transmute(pcalternates),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontFeatureTags<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, cmaxtags: i32, pfeaturetags: *mut u32, pctags: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontFeatureTags(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, cmaxtags: i32, pfeaturetags: *mut u32, pctags: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontFeatureTags(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(psa), ::std::mem::transmute(tagscript), ::std::mem::transmute(taglangsys), ::std::mem::transmute(cmaxtags), ::std::mem::transmute(pfeaturetags), ::std::mem::transmute(pctags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontLanguageTags<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, cmaxtags: i32, plangsystags: *mut u32, pctags: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontLanguageTags(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, cmaxtags: i32, plangsystags: *mut u32, pctags: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontLanguageTags(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(psa), ::std::mem::transmute(tagscript), ::std::mem::transmute(cmaxtags), ::std::mem::transmute(plangsystags), ::std::mem::transmute(pctags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontProperties<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, sfp: *mut SCRIPT_FONTPROPERTIES) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontProperties(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, sfp: *mut SCRIPT_FONTPROPERTIES) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontProperties(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(sfp)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontScriptTags<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, cmaxtags: i32, pscripttags: *mut u32, pctags: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontScriptTags(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, cmaxtags: i32, pscripttags: *mut u32, pctags: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontScriptTags(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(psa), ::std::mem::transmute(cmaxtags), ::std::mem::transmute(pscripttags), ::std::mem::transmute(pctags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetGlyphABCWidth<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, wglyph: u16, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetGlyphABCWidth(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, wglyph: u16, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::runtime::HRESULT;
        }
        ScriptGetGlyphABCWidth(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(wglyph), ::std::mem::transmute(pabc)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptGetLogicalWidths(psa: *const SCRIPT_ANALYSIS, cchars: i32, cglyphs: i32, piglyphwidth: *const i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, pidx: *const i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetLogicalWidths(psa: *const SCRIPT_ANALYSIS, cchars: i32, cglyphs: i32, piglyphwidth: *const i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, pidx: *const i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetLogicalWidths(::std::mem::transmute(psa), ::std::mem::transmute(cchars), ::std::mem::transmute(cglyphs), ::std::mem::transmute(piglyphwidth), ::std::mem::transmute(pwlogclust), ::std::mem::transmute(psva), ::std::mem::transmute(pidx)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptGetProperties(ppsp: *mut *mut *mut SCRIPT_PROPERTIES, pinumscripts: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetProperties(ppsp: *mut *mut *mut SCRIPT_PROPERTIES, pinumscripts: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptGetProperties(::std::mem::transmute(ppsp), ::std::mem::transmute(pinumscripts)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptIsComplex<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pwcinchars: Param0, cinchars: i32, dwflags: SCRIPT_IS_COMPLEX_FLAGS) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptIsComplex(pwcinchars: super::Foundation::PWSTR, cinchars: i32, dwflags: SCRIPT_IS_COMPLEX_FLAGS) -> ::windows::runtime::HRESULT;
        }
        ScriptIsComplex(pwcinchars.into_param().abi(), ::std::mem::transmute(cinchars), ::std::mem::transmute(dwflags)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptItemize<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pwcinchars: Param0, cinchars: i32, cmaxitems: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pitems: *mut SCRIPT_ITEM, pcitems: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptItemize(pwcinchars: super::Foundation::PWSTR, cinchars: i32, cmaxitems: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pitems: *mut SCRIPT_ITEM, pcitems: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptItemize(pwcinchars.into_param().abi(), ::std::mem::transmute(cinchars), ::std::mem::transmute(cmaxitems), ::std::mem::transmute(pscontrol), ::std::mem::transmute(psstate), ::std::mem::transmute(pitems), ::std::mem::transmute(pcitems)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptItemizeOpenType<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(pwcinchars: Param0, cinchars: i32, cmaxitems: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pitems: *mut SCRIPT_ITEM, pscripttags: *mut u32, pcitems: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptItemizeOpenType(pwcinchars: super::Foundation::PWSTR, cinchars: i32, cmaxitems: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pitems: *mut SCRIPT_ITEM, pscripttags: *mut u32, pcitems: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptItemizeOpenType(pwcinchars.into_param().abi(), ::std::mem::transmute(cinchars), ::std::mem::transmute(cmaxitems), ::std::mem::transmute(pscontrol), ::std::mem::transmute(psstate), ::std::mem::transmute(pitems), ::std::mem::transmute(pscripttags), ::std::mem::transmute(pcitems)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptJustify(psva: *const SCRIPT_VISATTR, piadvance: *const i32, cglyphs: i32, idx: i32, iminkashida: i32) -> ::windows::runtime::Result<i32> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptJustify(psva: *const SCRIPT_VISATTR, piadvance: *const i32, cglyphs: i32, idx: i32, iminkashida: i32, pijustify: *mut i32) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptJustify(::std::mem::transmute(psva), ::std::mem::transmute(piadvance), ::std::mem::transmute(cglyphs), ::std::mem::transmute(idx), ::std::mem::transmute(iminkashida), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptLayout(cruns: i32, pblevel: *const u8, pivisualtological: *mut i32, pilogicaltovisual: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptLayout(cruns: i32, pblevel: *const u8, pivisualtological: *mut i32, pilogicaltovisual: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptLayout(::std::mem::transmute(cruns), ::std::mem::transmute(pblevel), ::std::mem::transmute(pivisualtological), ::std::mem::transmute(pilogicaltovisual)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptPlace<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, pwglyphs: *const u16, cglyphs: i32, psva: *const SCRIPT_VISATTR, psa: *mut SCRIPT_ANALYSIS, piadvance: *mut i32, pgoffset: *mut GOFFSET, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPlace(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, pwglyphs: *const u16, cglyphs: i32, psva: *const SCRIPT_VISATTR, psa: *mut SCRIPT_ANALYSIS, piadvance: *mut i32, pgoffset: *mut GOFFSET, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::runtime::HRESULT;
        }
        ScriptPlace(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(pwglyphs), ::std::mem::transmute(cglyphs), ::std::mem::transmute(psva), ::std::mem::transmute(psa), ::std::mem::transmute(piadvance), ::std::mem::transmute(pgoffset), ::std::mem::transmute(pabc)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptPlaceOpenType<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param8: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *mut SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    rcrangechars: *const i32,
    rprangeproperties: *const *const textrange_properties,
    cranges: i32,
    pwcchars: Param8,
    pwlogclust: *const u16,
    pcharprops: *const script_charprop,
    cchars: i32,
    pwglyphs: *const u16,
    pglyphprops: *const script_glyphprop,
    cglyphs: i32,
    piadvance: *mut i32,
    pgoffset: *mut GOFFSET,
    pabc: *mut super::Graphics::Gdi::ABC,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPlaceOpenType(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *mut SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                rcrangechars: *const i32,
                rprangeproperties: *const *const textrange_properties,
                cranges: i32,
                pwcchars: super::Foundation::PWSTR,
                pwlogclust: *const u16,
                pcharprops: *const script_charprop,
                cchars: i32,
                pwglyphs: *const u16,
                pglyphprops: *const script_glyphprop,
                cglyphs: i32,
                piadvance: *mut i32,
                pgoffset: *mut GOFFSET,
                pabc: *mut super::Graphics::Gdi::ABC,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptPlaceOpenType(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(rcrangechars),
            ::std::mem::transmute(rprangeproperties),
            ::std::mem::transmute(cranges),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(pcharprops),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(pwglyphs),
            ::std::mem::transmute(pglyphprops),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(pgoffset),
            ::std::mem::transmute(pabc),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptPositionSingleGlyph<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param9: ::windows::runtime::IntoParam<'a, GOFFSET>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, iadvance: i32, goffset: Param9, pioutadvance: *mut i32, poutgoffset: *mut GOFFSET) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPositionSingleGlyph(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, iadvance: i32, goffset: GOFFSET, pioutadvance: *mut i32, poutgoffset: *mut GOFFSET) -> ::windows::runtime::HRESULT;
        }
        ScriptPositionSingleGlyph(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(tagfeature),
            ::std::mem::transmute(lparameter),
            ::std::mem::transmute(wglyphid),
            ::std::mem::transmute(iadvance),
            goffset.into_param().abi(),
            ::std::mem::transmute(pioutadvance),
            ::std::mem::transmute(poutgoffset),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptRecordDigitSubstitution(locale: u32) -> ::windows::runtime::Result<SCRIPT_DIGITSUBSTITUTE> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptRecordDigitSubstitution(locale: u32, psds: *mut SCRIPT_DIGITSUBSTITUTE) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <SCRIPT_DIGITSUBSTITUTE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptRecordDigitSubstitution(::std::mem::transmute(locale), &mut result__).from_abi::<SCRIPT_DIGITSUBSTITUTE>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptShape<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, pwcchars: Param2, cchars: i32, cmaxglyphs: i32, psa: *mut SCRIPT_ANALYSIS, pwoutglyphs: *mut u16, pwlogclust: *mut u16, psva: *mut SCRIPT_VISATTR, pcglyphs: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptShape(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, pwcchars: super::Foundation::PWSTR, cchars: i32, cmaxglyphs: i32, psa: *mut SCRIPT_ANALYSIS, pwoutglyphs: *mut u16, pwlogclust: *mut u16, psva: *mut SCRIPT_VISATTR, pcglyphs: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptShape(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cmaxglyphs),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(pwoutglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(pcglyphs),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptShapeOpenType<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param8: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *mut SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    rcrangechars: *const i32,
    rprangeproperties: *const *const textrange_properties,
    cranges: i32,
    pwcchars: Param8,
    cchars: i32,
    cmaxglyphs: i32,
    pwlogclust: *mut u16,
    pcharprops: *mut script_charprop,
    pwoutglyphs: *mut u16,
    poutglyphprops: *mut script_glyphprop,
    pcglyphs: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptShapeOpenType(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *mut SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, rcrangechars: *const i32, rprangeproperties: *const *const textrange_properties, cranges: i32, pwcchars: super::Foundation::PWSTR, cchars: i32, cmaxglyphs: i32, pwlogclust: *mut u16, pcharprops: *mut script_charprop, pwoutglyphs: *mut u16, poutglyphprops: *mut script_glyphprop, pcglyphs: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptShapeOpenType(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(rcrangechars),
            ::std::mem::transmute(rprangeproperties),
            ::std::mem::transmute(cranges),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cmaxglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(pcharprops),
            ::std::mem::transmute(pwoutglyphs),
            ::std::mem::transmute(poutglyphprops),
            ::std::mem::transmute(pcglyphs),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptStringAnalyse<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, pstring: *const ::std::ffi::c_void, cstring: i32, cglyphs: i32, icharset: i32, dwflags: u32, ireqwidth: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pidx: *const i32, ptabdef: *const SCRIPT_TABDEF, pbinclass: *const u8, pssa: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringAnalyse(hdc: super::Graphics::Gdi::HDC, pstring: *const ::std::ffi::c_void, cstring: i32, cglyphs: i32, icharset: i32, dwflags: u32, ireqwidth: i32, pscontrol: *const SCRIPT_CONTROL, psstate: *const SCRIPT_STATE, pidx: *const i32, ptabdef: *const SCRIPT_TABDEF, pbinclass: *const u8, pssa: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptStringAnalyse(
            hdc.into_param().abi(),
            ::std::mem::transmute(pstring),
            ::std::mem::transmute(cstring),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(icharset),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(ireqwidth),
            ::std::mem::transmute(pscontrol),
            ::std::mem::transmute(psstate),
            ::std::mem::transmute(pidx),
            ::std::mem::transmute(ptabdef),
            ::std::mem::transmute(pbinclass),
            ::std::mem::transmute(pssa),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptStringCPtoX<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(ssa: *const ::std::ffi::c_void, icp: i32, ftrailing: Param2) -> ::windows::runtime::Result<i32> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringCPtoX(ssa: *const ::std::ffi::c_void, icp: i32, ftrailing: super::Foundation::BOOL, px: *mut i32) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptStringCPtoX(::std::mem::transmute(ssa), ::std::mem::transmute(icp), ftrailing.into_param().abi(), &mut result__).from_abi::<i32>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptStringFree(pssa: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringFree(pssa: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptStringFree(::std::mem::transmute(pssa)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptStringGetLogicalWidths(ssa: *const ::std::ffi::c_void, pidx: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringGetLogicalWidths(ssa: *const ::std::ffi::c_void, pidx: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptStringGetLogicalWidths(::std::mem::transmute(ssa), ::std::mem::transmute(pidx)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptStringGetOrder(ssa: *const ::std::ffi::c_void, puorder: *mut u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringGetOrder(ssa: *const ::std::ffi::c_void, puorder: *mut u32) -> ::windows::runtime::HRESULT;
        }
        ScriptStringGetOrder(::std::mem::transmute(ssa), ::std::mem::transmute(puorder)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptStringOut<'a, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(ssa: *const ::std::ffi::c_void, ix: i32, iy: i32, uoptions: super::Graphics::Gdi::ETO_OPTIONS, prc: *const super::Foundation::RECT, iminsel: i32, imaxsel: i32, fdisabled: Param7) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringOut(ssa: *const ::std::ffi::c_void, ix: i32, iy: i32, uoptions: super::Graphics::Gdi::ETO_OPTIONS, prc: *const super::Foundation::RECT, iminsel: i32, imaxsel: i32, fdisabled: super::Foundation::BOOL) -> ::windows::runtime::HRESULT;
        }
        ScriptStringOut(::std::mem::transmute(ssa), ::std::mem::transmute(ix), ::std::mem::transmute(iy), ::std::mem::transmute(uoptions), ::std::mem::transmute(prc), ::std::mem::transmute(iminsel), ::std::mem::transmute(imaxsel), fdisabled.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptStringValidate(ssa: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringValidate(ssa: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptStringValidate(::std::mem::transmute(ssa)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptStringXtoCP(ssa: *const ::std::ffi::c_void, ix: i32, pich: *mut i32, pitrailing: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringXtoCP(ssa: *const ::std::ffi::c_void, ix: i32, pich: *mut i32, pitrailing: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptStringXtoCP(::std::mem::transmute(ssa), ::std::mem::transmute(ix), ::std::mem::transmute(pich), ::std::mem::transmute(pitrailing)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptString_pLogAttr(ssa: *const ::std::ffi::c_void) -> *mut SCRIPT_LOGATTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pLogAttr(ssa: *const ::std::ffi::c_void) -> *mut SCRIPT_LOGATTR;
        }
        ::std::mem::transmute(ScriptString_pLogAttr(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptString_pSize(ssa: *const ::std::ffi::c_void) -> *mut super::Foundation::SIZE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pSize(ssa: *const ::std::ffi::c_void) -> *mut super::Foundation::SIZE;
        }
        ::std::mem::transmute(ScriptString_pSize(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptString_pcOutChars(ssa: *const ::std::ffi::c_void) -> *mut i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pcOutChars(ssa: *const ::std::ffi::c_void) -> *mut i32;
        }
        ::std::mem::transmute(ScriptString_pcOutChars(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Graphics_Gdi`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptSubstituteSingleGlyph<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, pwoutglyphid: *mut u16) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptSubstituteSingleGlyph(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, psa: *const SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, pwoutglyphid: *mut u16) -> ::windows::runtime::HRESULT;
        }
        ScriptSubstituteSingleGlyph(hdc.into_param().abi(), ::std::mem::transmute(psc), ::std::mem::transmute(psa), ::std::mem::transmute(tagscript), ::std::mem::transmute(taglangsys), ::std::mem::transmute(tagfeature), ::std::mem::transmute(lparameter), ::std::mem::transmute(wglyphid), ::std::mem::transmute(pwoutglyphid)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`, `Win32_Graphics_Gdi`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptTextOut<'a, Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>, Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(hdc: Param0, psc: *mut *mut ::std::ffi::c_void, x: i32, y: i32, fuoptions: u32, lprc: *const super::Foundation::RECT, psa: *const SCRIPT_ANALYSIS, pwcreserved: Param7, ireserved: i32, pwglyphs: *const u16, cglyphs: i32, piadvance: *const i32, pijustify: *const i32, pgoffset: *const GOFFSET) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptTextOut(hdc: super::Graphics::Gdi::HDC, psc: *mut *mut ::std::ffi::c_void, x: i32, y: i32, fuoptions: u32, lprc: *const super::Foundation::RECT, psa: *const SCRIPT_ANALYSIS, pwcreserved: super::Foundation::PWSTR, ireserved: i32, pwglyphs: *const u16, cglyphs: i32, piadvance: *const i32, pijustify: *const i32, pgoffset: *const GOFFSET) -> ::windows::runtime::HRESULT;
        }
        ScriptTextOut(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(fuoptions),
            ::std::mem::transmute(lprc),
            ::std::mem::transmute(psa),
            pwcreserved.into_param().abi(),
            ::std::mem::transmute(ireserved),
            ::std::mem::transmute(pwglyphs),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(pijustify),
            ::std::mem::transmute(pgoffset),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ScriptXtoCP(ix: i32, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, picp: *mut i32, pitrailing: *mut i32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptXtoCP(ix: i32, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, picp: *mut i32, pitrailing: *mut i32) -> ::windows::runtime::HRESULT;
        }
        ScriptXtoCP(::std::mem::transmute(ix), ::std::mem::transmute(cchars), ::std::mem::transmute(cglyphs), ::std::mem::transmute(pwlogclust), ::std::mem::transmute(psva), ::std::mem::transmute(piadvance), ::std::mem::transmute(psa), ::std::mem::transmute(picp), ::std::mem::transmute(pitrailing)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetCalendarInfoA<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, calendar: u32, caltype: u32, lpcaldata: Param3) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetCalendarInfoA(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetCalendarInfoA(::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype), lpcaldata.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetCalendarInfoW<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, calendar: u32, caltype: u32, lpcaldata: Param3) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetCalendarInfoW(locale: u32, calendar: u32, caltype: u32, lpcaldata: super::Foundation::PWSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetCalendarInfoW(::std::mem::transmute(locale), ::std::mem::transmute(calendar), ::std::mem::transmute(caltype), lpcaldata.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetLocaleInfoA<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: u32, lctype: u32, lplcdata: Param2) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetLocaleInfoA(locale: u32, lctype: u32, lplcdata: super::Foundation::PSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetLocaleInfoA(::std::mem::transmute(locale), ::std::mem::transmute(lctype), lplcdata.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetLocaleInfoW<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(locale: u32, lctype: u32, lplcdata: Param2) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetLocaleInfoW(locale: u32, lctype: u32, lplcdata: super::Foundation::PWSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetLocaleInfoW(::std::mem::transmute(locale), ::std::mem::transmute(lctype), lplcdata.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetProcessPreferredUILanguages<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pwszlanguagesbuffer: Param1, pulnumlanguages: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetProcessPreferredUILanguages(dwflags: u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pulnumlanguages: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetProcessPreferredUILanguages(::std::mem::transmute(dwflags), pwszlanguagesbuffer.into_param().abi(), ::std::mem::transmute(pulnumlanguages)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadLocale(locale: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadLocale(locale: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadLocale(::std::mem::transmute(locale)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadPreferredUILanguages<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, pwszlanguagesbuffer: Param1, pulnumlanguages: *mut u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadPreferredUILanguages(dwflags: u32, pwszlanguagesbuffer: super::Foundation::PWSTR, pulnumlanguages: *mut u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadPreferredUILanguages(::std::mem::transmute(dwflags), pwszlanguagesbuffer.into_param().abi(), ::std::mem::transmute(pulnumlanguages)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadPreferredUILanguages2<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(flags: u32, languages: Param1, numlanguagesset: *mut u32, snapshot: *mut HSAVEDUILANGUAGES) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadPreferredUILanguages2(flags: u32, languages: super::Foundation::PWSTR, numlanguagesset: *mut u32, snapshot: *mut HSAVEDUILANGUAGES) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadPreferredUILanguages2(::std::mem::transmute(flags), languages.into_param().abi(), ::std::mem::transmute(numlanguagesset), ::std::mem::transmute(snapshot)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn SetThreadUILanguage(langid: u16) -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadUILanguage(langid: u16) -> u16;
        }
        ::std::mem::transmute(SetThreadUILanguage(::std::mem::transmute(langid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetUserGeoID(geoid: i32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetUserGeoID(geoid: i32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetUserGeoID(::std::mem::transmute(geoid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetUserGeoName<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(geoname: Param0) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetUserGeoName(geoname: super::Foundation::PWSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetUserGeoName(geoname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const SpellCheckerFactory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2058577491, 6038, 18507, [189, 250, 231, 79, 29, 183, 193, 220]);
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCEX = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: super::Foundation::LPARAM) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct TIME_FORMAT_FLAGS(pub u32);
pub const TIME_NOMINUTESORSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(1u32);
pub const TIME_NOSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(2u32);
pub const TIME_NOTIMEMARKER: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(4u32);
pub const TIME_FORCE24HOURFORMAT: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(8u32);
impl ::std::convert::From<u32> for TIME_FORMAT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for TIME_FORMAT_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for TIME_FORMAT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for TIME_FORMAT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct TRANSLATE_CHARSET_INFO_FLAGS(pub u32);
pub const TCI_SRCCHARSET: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(1u32);
pub const TCI_SRCCODEPAGE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(2u32);
pub const TCI_SRCFONTSIG: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(3u32);
pub const TCI_SRCLOCALE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(4096u32);
impl ::std::convert::From<u32> for TRANSLATE_CHARSET_INFO_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for TRANSLATE_CHARSET_INFO_FLAGS {
    type Abi = Self;
}
impl ::std::ops::BitOr for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for TRANSLATE_CHARSET_INFO_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for TRANSLATE_CHARSET_INFO_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn TranslateCharsetInfo(lpsrc: *mut u32, lpcs: *mut CHARSETINFO, dwflags: TRANSLATE_CHARSET_INFO_FLAGS) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn TranslateCharsetInfo(lpsrc: *mut u32, lpcs: *mut CHARSETINFO, dwflags: TRANSLATE_CHARSET_INFO_FLAGS) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(TranslateCharsetInfo(::std::mem::transmute(lpsrc), ::std::mem::transmute(lpcs), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U16_MAX_LENGTH: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U8_MAX_LENGTH: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UAcceptResult(pub i32);
pub const ULOC_ACCEPT_FAILED: UAcceptResult = UAcceptResult(0i32);
pub const ULOC_ACCEPT_VALID: UAcceptResult = UAcceptResult(1i32);
pub const ULOC_ACCEPT_FALLBACK: UAcceptResult = UAcceptResult(2i32);
impl ::std::convert::From<i32> for UAcceptResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UAcceptResult {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UAlphabeticIndexLabelType(pub i32);
pub const U_ALPHAINDEX_NORMAL: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(0i32);
pub const U_ALPHAINDEX_UNDERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(1i32);
pub const U_ALPHAINDEX_INFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(2i32);
pub const U_ALPHAINDEX_OVERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(3i32);
impl ::std::convert::From<i32> for UAlphabeticIndexLabelType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UAlphabeticIndexLabelType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_DEFAULT_LTR: u32 = 254u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_DEFAULT_RTL: u32 = 255u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_DO_MIRRORING: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_INSERT_LRM_FOR_NUMERIC: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_KEEP_BASE_COMBINING: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_LEVEL_OVERRIDE: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_MAP_NOWHERE: i32 = -1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_MAX_EXPLICIT_LEVEL: u32 = 125u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_OUTPUT_REVERSE: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UBIDI_REMOVE_BIDI_CONTROLS: u32 = 8u32;
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UBiDi(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UBiDiClassCallback = unsafe extern "system" fn(context: *const ::std::ffi::c_void, c: i32) -> UCharDirection;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBiDiDirection(pub i32);
pub const UBIDI_LTR: UBiDiDirection = UBiDiDirection(0i32);
pub const UBIDI_RTL: UBiDiDirection = UBiDiDirection(1i32);
pub const UBIDI_MIXED: UBiDiDirection = UBiDiDirection(2i32);
pub const UBIDI_NEUTRAL: UBiDiDirection = UBiDiDirection(3i32);
impl ::std::convert::From<i32> for UBiDiDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiDirection {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBiDiMirroring(pub i32);
pub const UBIDI_MIRRORING_OFF: UBiDiMirroring = UBiDiMirroring(0i32);
pub const UBIDI_MIRRORING_ON: UBiDiMirroring = UBiDiMirroring(1i32);
impl ::std::convert::From<i32> for UBiDiMirroring {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiMirroring {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBiDiOrder(pub i32);
pub const UBIDI_LOGICAL: UBiDiOrder = UBiDiOrder(0i32);
pub const UBIDI_VISUAL: UBiDiOrder = UBiDiOrder(1i32);
impl ::std::convert::From<i32> for UBiDiOrder {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiOrder {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBiDiReorderingMode(pub i32);
pub const UBIDI_REORDER_DEFAULT: UBiDiReorderingMode = UBiDiReorderingMode(0i32);
pub const UBIDI_REORDER_NUMBERS_SPECIAL: UBiDiReorderingMode = UBiDiReorderingMode(1i32);
pub const UBIDI_REORDER_GROUP_NUMBERS_WITH_R: UBiDiReorderingMode = UBiDiReorderingMode(2i32);
pub const UBIDI_REORDER_RUNS_ONLY: UBiDiReorderingMode = UBiDiReorderingMode(3i32);
pub const UBIDI_REORDER_INVERSE_NUMBERS_AS_L: UBiDiReorderingMode = UBiDiReorderingMode(4i32);
pub const UBIDI_REORDER_INVERSE_LIKE_DIRECT: UBiDiReorderingMode = UBiDiReorderingMode(5i32);
pub const UBIDI_REORDER_INVERSE_FOR_NUMBERS_SPECIAL: UBiDiReorderingMode = UBiDiReorderingMode(6i32);
impl ::std::convert::From<i32> for UBiDiReorderingMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiReorderingMode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBiDiReorderingOption(pub i32);
pub const UBIDI_OPTION_DEFAULT: UBiDiReorderingOption = UBiDiReorderingOption(0i32);
pub const UBIDI_OPTION_INSERT_MARKS: UBiDiReorderingOption = UBiDiReorderingOption(1i32);
pub const UBIDI_OPTION_REMOVE_CONTROLS: UBiDiReorderingOption = UBiDiReorderingOption(2i32);
pub const UBIDI_OPTION_STREAMING: UBiDiReorderingOption = UBiDiReorderingOption(4i32);
impl ::std::convert::From<i32> for UBiDiReorderingOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiReorderingOption {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UBiDiTransform(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBidiPairedBracketType(pub i32);
pub const U_BPT_NONE: UBidiPairedBracketType = UBidiPairedBracketType(0i32);
pub const U_BPT_OPEN: UBidiPairedBracketType = UBidiPairedBracketType(1i32);
pub const U_BPT_CLOSE: UBidiPairedBracketType = UBidiPairedBracketType(2i32);
impl ::std::convert::From<i32> for UBidiPairedBracketType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBidiPairedBracketType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBlockCode(pub i32);
pub const UBLOCK_NO_BLOCK: UBlockCode = UBlockCode(0i32);
pub const UBLOCK_BASIC_LATIN: UBlockCode = UBlockCode(1i32);
pub const UBLOCK_LATIN_1_SUPPLEMENT: UBlockCode = UBlockCode(2i32);
pub const UBLOCK_LATIN_EXTENDED_A: UBlockCode = UBlockCode(3i32);
pub const UBLOCK_LATIN_EXTENDED_B: UBlockCode = UBlockCode(4i32);
pub const UBLOCK_IPA_EXTENSIONS: UBlockCode = UBlockCode(5i32);
pub const UBLOCK_SPACING_MODIFIER_LETTERS: UBlockCode = UBlockCode(6i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS: UBlockCode = UBlockCode(7i32);
pub const UBLOCK_GREEK: UBlockCode = UBlockCode(8i32);
pub const UBLOCK_CYRILLIC: UBlockCode = UBlockCode(9i32);
pub const UBLOCK_ARMENIAN: UBlockCode = UBlockCode(10i32);
pub const UBLOCK_HEBREW: UBlockCode = UBlockCode(11i32);
pub const UBLOCK_ARABIC: UBlockCode = UBlockCode(12i32);
pub const UBLOCK_SYRIAC: UBlockCode = UBlockCode(13i32);
pub const UBLOCK_THAANA: UBlockCode = UBlockCode(14i32);
pub const UBLOCK_DEVANAGARI: UBlockCode = UBlockCode(15i32);
pub const UBLOCK_BENGALI: UBlockCode = UBlockCode(16i32);
pub const UBLOCK_GURMUKHI: UBlockCode = UBlockCode(17i32);
pub const UBLOCK_GUJARATI: UBlockCode = UBlockCode(18i32);
pub const UBLOCK_ORIYA: UBlockCode = UBlockCode(19i32);
pub const UBLOCK_TAMIL: UBlockCode = UBlockCode(20i32);
pub const UBLOCK_TELUGU: UBlockCode = UBlockCode(21i32);
pub const UBLOCK_KANNADA: UBlockCode = UBlockCode(22i32);
pub const UBLOCK_MALAYALAM: UBlockCode = UBlockCode(23i32);
pub const UBLOCK_SINHALA: UBlockCode = UBlockCode(24i32);
pub const UBLOCK_THAI: UBlockCode = UBlockCode(25i32);
pub const UBLOCK_LAO: UBlockCode = UBlockCode(26i32);
pub const UBLOCK_TIBETAN: UBlockCode = UBlockCode(27i32);
pub const UBLOCK_MYANMAR: UBlockCode = UBlockCode(28i32);
pub const UBLOCK_GEORGIAN: UBlockCode = UBlockCode(29i32);
pub const UBLOCK_HANGUL_JAMO: UBlockCode = UBlockCode(30i32);
pub const UBLOCK_ETHIOPIC: UBlockCode = UBlockCode(31i32);
pub const UBLOCK_CHEROKEE: UBlockCode = UBlockCode(32i32);
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS: UBlockCode = UBlockCode(33i32);
pub const UBLOCK_OGHAM: UBlockCode = UBlockCode(34i32);
pub const UBLOCK_RUNIC: UBlockCode = UBlockCode(35i32);
pub const UBLOCK_KHMER: UBlockCode = UBlockCode(36i32);
pub const UBLOCK_MONGOLIAN: UBlockCode = UBlockCode(37i32);
pub const UBLOCK_LATIN_EXTENDED_ADDITIONAL: UBlockCode = UBlockCode(38i32);
pub const UBLOCK_GREEK_EXTENDED: UBlockCode = UBlockCode(39i32);
pub const UBLOCK_GENERAL_PUNCTUATION: UBlockCode = UBlockCode(40i32);
pub const UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS: UBlockCode = UBlockCode(41i32);
pub const UBLOCK_CURRENCY_SYMBOLS: UBlockCode = UBlockCode(42i32);
pub const UBLOCK_COMBINING_MARKS_FOR_SYMBOLS: UBlockCode = UBlockCode(43i32);
pub const UBLOCK_LETTERLIKE_SYMBOLS: UBlockCode = UBlockCode(44i32);
pub const UBLOCK_NUMBER_FORMS: UBlockCode = UBlockCode(45i32);
pub const UBLOCK_ARROWS: UBlockCode = UBlockCode(46i32);
pub const UBLOCK_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(47i32);
pub const UBLOCK_MISCELLANEOUS_TECHNICAL: UBlockCode = UBlockCode(48i32);
pub const UBLOCK_CONTROL_PICTURES: UBlockCode = UBlockCode(49i32);
pub const UBLOCK_OPTICAL_CHARACTER_RECOGNITION: UBlockCode = UBlockCode(50i32);
pub const UBLOCK_ENCLOSED_ALPHANUMERICS: UBlockCode = UBlockCode(51i32);
pub const UBLOCK_BOX_DRAWING: UBlockCode = UBlockCode(52i32);
pub const UBLOCK_BLOCK_ELEMENTS: UBlockCode = UBlockCode(53i32);
pub const UBLOCK_GEOMETRIC_SHAPES: UBlockCode = UBlockCode(54i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS: UBlockCode = UBlockCode(55i32);
pub const UBLOCK_DINGBATS: UBlockCode = UBlockCode(56i32);
pub const UBLOCK_BRAILLE_PATTERNS: UBlockCode = UBlockCode(57i32);
pub const UBLOCK_CJK_RADICALS_SUPPLEMENT: UBlockCode = UBlockCode(58i32);
pub const UBLOCK_KANGXI_RADICALS: UBlockCode = UBlockCode(59i32);
pub const UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS: UBlockCode = UBlockCode(60i32);
pub const UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(61i32);
pub const UBLOCK_HIRAGANA: UBlockCode = UBlockCode(62i32);
pub const UBLOCK_KATAKANA: UBlockCode = UBlockCode(63i32);
pub const UBLOCK_BOPOMOFO: UBlockCode = UBlockCode(64i32);
pub const UBLOCK_HANGUL_COMPATIBILITY_JAMO: UBlockCode = UBlockCode(65i32);
pub const UBLOCK_KANBUN: UBlockCode = UBlockCode(66i32);
pub const UBLOCK_BOPOMOFO_EXTENDED: UBlockCode = UBlockCode(67i32);
pub const UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS: UBlockCode = UBlockCode(68i32);
pub const UBLOCK_CJK_COMPATIBILITY: UBlockCode = UBlockCode(69i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A: UBlockCode = UBlockCode(70i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS: UBlockCode = UBlockCode(71i32);
pub const UBLOCK_YI_SYLLABLES: UBlockCode = UBlockCode(72i32);
pub const UBLOCK_YI_RADICALS: UBlockCode = UBlockCode(73i32);
pub const UBLOCK_HANGUL_SYLLABLES: UBlockCode = UBlockCode(74i32);
pub const UBLOCK_HIGH_SURROGATES: UBlockCode = UBlockCode(75i32);
pub const UBLOCK_HIGH_PRIVATE_USE_SURROGATES: UBlockCode = UBlockCode(76i32);
pub const UBLOCK_LOW_SURROGATES: UBlockCode = UBlockCode(77i32);
pub const UBLOCK_PRIVATE_USE_AREA: UBlockCode = UBlockCode(78i32);
pub const UBLOCK_PRIVATE_USE: UBlockCode = UBlockCode(78i32);
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS: UBlockCode = UBlockCode(79i32);
pub const UBLOCK_ALPHABETIC_PRESENTATION_FORMS: UBlockCode = UBlockCode(80i32);
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_A: UBlockCode = UBlockCode(81i32);
pub const UBLOCK_COMBINING_HALF_MARKS: UBlockCode = UBlockCode(82i32);
pub const UBLOCK_CJK_COMPATIBILITY_FORMS: UBlockCode = UBlockCode(83i32);
pub const UBLOCK_SMALL_FORM_VARIANTS: UBlockCode = UBlockCode(84i32);
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_B: UBlockCode = UBlockCode(85i32);
pub const UBLOCK_SPECIALS: UBlockCode = UBlockCode(86i32);
pub const UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS: UBlockCode = UBlockCode(87i32);
pub const UBLOCK_OLD_ITALIC: UBlockCode = UBlockCode(88i32);
pub const UBLOCK_GOTHIC: UBlockCode = UBlockCode(89i32);
pub const UBLOCK_DESERET: UBlockCode = UBlockCode(90i32);
pub const UBLOCK_BYZANTINE_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(91i32);
pub const UBLOCK_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(92i32);
pub const UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS: UBlockCode = UBlockCode(93i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B: UBlockCode = UBlockCode(94i32);
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT: UBlockCode = UBlockCode(95i32);
pub const UBLOCK_TAGS: UBlockCode = UBlockCode(96i32);
pub const UBLOCK_CYRILLIC_SUPPLEMENT: UBlockCode = UBlockCode(97i32);
pub const UBLOCK_CYRILLIC_SUPPLEMENTARY: UBlockCode = UBlockCode(97i32);
pub const UBLOCK_TAGALOG: UBlockCode = UBlockCode(98i32);
pub const UBLOCK_HANUNOO: UBlockCode = UBlockCode(99i32);
pub const UBLOCK_BUHID: UBlockCode = UBlockCode(100i32);
pub const UBLOCK_TAGBANWA: UBlockCode = UBlockCode(101i32);
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A: UBlockCode = UBlockCode(102i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_A: UBlockCode = UBlockCode(103i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_B: UBlockCode = UBlockCode(104i32);
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B: UBlockCode = UBlockCode(105i32);
pub const UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(106i32);
pub const UBLOCK_KATAKANA_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(107i32);
pub const UBLOCK_VARIATION_SELECTORS: UBlockCode = UBlockCode(108i32);
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A: UBlockCode = UBlockCode(109i32);
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B: UBlockCode = UBlockCode(110i32);
pub const UBLOCK_LIMBU: UBlockCode = UBlockCode(111i32);
pub const UBLOCK_TAI_LE: UBlockCode = UBlockCode(112i32);
pub const UBLOCK_KHMER_SYMBOLS: UBlockCode = UBlockCode(113i32);
pub const UBLOCK_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(114i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS: UBlockCode = UBlockCode(115i32);
pub const UBLOCK_YIJING_HEXAGRAM_SYMBOLS: UBlockCode = UBlockCode(116i32);
pub const UBLOCK_LINEAR_B_SYLLABARY: UBlockCode = UBlockCode(117i32);
pub const UBLOCK_LINEAR_B_IDEOGRAMS: UBlockCode = UBlockCode(118i32);
pub const UBLOCK_AEGEAN_NUMBERS: UBlockCode = UBlockCode(119i32);
pub const UBLOCK_UGARITIC: UBlockCode = UBlockCode(120i32);
pub const UBLOCK_SHAVIAN: UBlockCode = UBlockCode(121i32);
pub const UBLOCK_OSMANYA: UBlockCode = UBlockCode(122i32);
pub const UBLOCK_CYPRIOT_SYLLABARY: UBlockCode = UBlockCode(123i32);
pub const UBLOCK_TAI_XUAN_JING_SYMBOLS: UBlockCode = UBlockCode(124i32);
pub const UBLOCK_VARIATION_SELECTORS_SUPPLEMENT: UBlockCode = UBlockCode(125i32);
pub const UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION: UBlockCode = UBlockCode(126i32);
pub const UBLOCK_ANCIENT_GREEK_NUMBERS: UBlockCode = UBlockCode(127i32);
pub const UBLOCK_ARABIC_SUPPLEMENT: UBlockCode = UBlockCode(128i32);
pub const UBLOCK_BUGINESE: UBlockCode = UBlockCode(129i32);
pub const UBLOCK_CJK_STROKES: UBlockCode = UBlockCode(130i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT: UBlockCode = UBlockCode(131i32);
pub const UBLOCK_COPTIC: UBlockCode = UBlockCode(132i32);
pub const UBLOCK_ETHIOPIC_EXTENDED: UBlockCode = UBlockCode(133i32);
pub const UBLOCK_ETHIOPIC_SUPPLEMENT: UBlockCode = UBlockCode(134i32);
pub const UBLOCK_GEORGIAN_SUPPLEMENT: UBlockCode = UBlockCode(135i32);
pub const UBLOCK_GLAGOLITIC: UBlockCode = UBlockCode(136i32);
pub const UBLOCK_KHAROSHTHI: UBlockCode = UBlockCode(137i32);
pub const UBLOCK_MODIFIER_TONE_LETTERS: UBlockCode = UBlockCode(138i32);
pub const UBLOCK_NEW_TAI_LUE: UBlockCode = UBlockCode(139i32);
pub const UBLOCK_OLD_PERSIAN: UBlockCode = UBlockCode(140i32);
pub const UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT: UBlockCode = UBlockCode(141i32);
pub const UBLOCK_SUPPLEMENTAL_PUNCTUATION: UBlockCode = UBlockCode(142i32);
pub const UBLOCK_SYLOTI_NAGRI: UBlockCode = UBlockCode(143i32);
pub const UBLOCK_TIFINAGH: UBlockCode = UBlockCode(144i32);
pub const UBLOCK_VERTICAL_FORMS: UBlockCode = UBlockCode(145i32);
pub const UBLOCK_NKO: UBlockCode = UBlockCode(146i32);
pub const UBLOCK_BALINESE: UBlockCode = UBlockCode(147i32);
pub const UBLOCK_LATIN_EXTENDED_C: UBlockCode = UBlockCode(148i32);
pub const UBLOCK_LATIN_EXTENDED_D: UBlockCode = UBlockCode(149i32);
pub const UBLOCK_PHAGS_PA: UBlockCode = UBlockCode(150i32);
pub const UBLOCK_PHOENICIAN: UBlockCode = UBlockCode(151i32);
pub const UBLOCK_CUNEIFORM: UBlockCode = UBlockCode(152i32);
pub const UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION: UBlockCode = UBlockCode(153i32);
pub const UBLOCK_COUNTING_ROD_NUMERALS: UBlockCode = UBlockCode(154i32);
pub const UBLOCK_SUNDANESE: UBlockCode = UBlockCode(155i32);
pub const UBLOCK_LEPCHA: UBlockCode = UBlockCode(156i32);
pub const UBLOCK_OL_CHIKI: UBlockCode = UBlockCode(157i32);
pub const UBLOCK_CYRILLIC_EXTENDED_A: UBlockCode = UBlockCode(158i32);
pub const UBLOCK_VAI: UBlockCode = UBlockCode(159i32);
pub const UBLOCK_CYRILLIC_EXTENDED_B: UBlockCode = UBlockCode(160i32);
pub const UBLOCK_SAURASHTRA: UBlockCode = UBlockCode(161i32);
pub const UBLOCK_KAYAH_LI: UBlockCode = UBlockCode(162i32);
pub const UBLOCK_REJANG: UBlockCode = UBlockCode(163i32);
pub const UBLOCK_CHAM: UBlockCode = UBlockCode(164i32);
pub const UBLOCK_ANCIENT_SYMBOLS: UBlockCode = UBlockCode(165i32);
pub const UBLOCK_PHAISTOS_DISC: UBlockCode = UBlockCode(166i32);
pub const UBLOCK_LYCIAN: UBlockCode = UBlockCode(167i32);
pub const UBLOCK_CARIAN: UBlockCode = UBlockCode(168i32);
pub const UBLOCK_LYDIAN: UBlockCode = UBlockCode(169i32);
pub const UBLOCK_MAHJONG_TILES: UBlockCode = UBlockCode(170i32);
pub const UBLOCK_DOMINO_TILES: UBlockCode = UBlockCode(171i32);
pub const UBLOCK_SAMARITAN: UBlockCode = UBlockCode(172i32);
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED: UBlockCode = UBlockCode(173i32);
pub const UBLOCK_TAI_THAM: UBlockCode = UBlockCode(174i32);
pub const UBLOCK_VEDIC_EXTENSIONS: UBlockCode = UBlockCode(175i32);
pub const UBLOCK_LISU: UBlockCode = UBlockCode(176i32);
pub const UBLOCK_BAMUM: UBlockCode = UBlockCode(177i32);
pub const UBLOCK_COMMON_INDIC_NUMBER_FORMS: UBlockCode = UBlockCode(178i32);
pub const UBLOCK_DEVANAGARI_EXTENDED: UBlockCode = UBlockCode(179i32);
pub const UBLOCK_HANGUL_JAMO_EXTENDED_A: UBlockCode = UBlockCode(180i32);
pub const UBLOCK_JAVANESE: UBlockCode = UBlockCode(181i32);
pub const UBLOCK_MYANMAR_EXTENDED_A: UBlockCode = UBlockCode(182i32);
pub const UBLOCK_TAI_VIET: UBlockCode = UBlockCode(183i32);
pub const UBLOCK_MEETEI_MAYEK: UBlockCode = UBlockCode(184i32);
pub const UBLOCK_HANGUL_JAMO_EXTENDED_B: UBlockCode = UBlockCode(185i32);
pub const UBLOCK_IMPERIAL_ARAMAIC: UBlockCode = UBlockCode(186i32);
pub const UBLOCK_OLD_SOUTH_ARABIAN: UBlockCode = UBlockCode(187i32);
pub const UBLOCK_AVESTAN: UBlockCode = UBlockCode(188i32);
pub const UBLOCK_INSCRIPTIONAL_PARTHIAN: UBlockCode = UBlockCode(189i32);
pub const UBLOCK_INSCRIPTIONAL_PAHLAVI: UBlockCode = UBlockCode(190i32);
pub const UBLOCK_OLD_TURKIC: UBlockCode = UBlockCode(191i32);
pub const UBLOCK_RUMI_NUMERAL_SYMBOLS: UBlockCode = UBlockCode(192i32);
pub const UBLOCK_KAITHI: UBlockCode = UBlockCode(193i32);
pub const UBLOCK_EGYPTIAN_HIEROGLYPHS: UBlockCode = UBlockCode(194i32);
pub const UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT: UBlockCode = UBlockCode(195i32);
pub const UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT: UBlockCode = UBlockCode(196i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C: UBlockCode = UBlockCode(197i32);
pub const UBLOCK_MANDAIC: UBlockCode = UBlockCode(198i32);
pub const UBLOCK_BATAK: UBlockCode = UBlockCode(199i32);
pub const UBLOCK_ETHIOPIC_EXTENDED_A: UBlockCode = UBlockCode(200i32);
pub const UBLOCK_BRAHMI: UBlockCode = UBlockCode(201i32);
pub const UBLOCK_BAMUM_SUPPLEMENT: UBlockCode = UBlockCode(202i32);
pub const UBLOCK_KANA_SUPPLEMENT: UBlockCode = UBlockCode(203i32);
pub const UBLOCK_PLAYING_CARDS: UBlockCode = UBlockCode(204i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(205i32);
pub const UBLOCK_EMOTICONS: UBlockCode = UBlockCode(206i32);
pub const UBLOCK_TRANSPORT_AND_MAP_SYMBOLS: UBlockCode = UBlockCode(207i32);
pub const UBLOCK_ALCHEMICAL_SYMBOLS: UBlockCode = UBlockCode(208i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D: UBlockCode = UBlockCode(209i32);
pub const UBLOCK_ARABIC_EXTENDED_A: UBlockCode = UBlockCode(210i32);
pub const UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS: UBlockCode = UBlockCode(211i32);
pub const UBLOCK_CHAKMA: UBlockCode = UBlockCode(212i32);
pub const UBLOCK_MEETEI_MAYEK_EXTENSIONS: UBlockCode = UBlockCode(213i32);
pub const UBLOCK_MEROITIC_CURSIVE: UBlockCode = UBlockCode(214i32);
pub const UBLOCK_MEROITIC_HIEROGLYPHS: UBlockCode = UBlockCode(215i32);
pub const UBLOCK_MIAO: UBlockCode = UBlockCode(216i32);
pub const UBLOCK_SHARADA: UBlockCode = UBlockCode(217i32);
pub const UBLOCK_SORA_SOMPENG: UBlockCode = UBlockCode(218i32);
pub const UBLOCK_SUNDANESE_SUPPLEMENT: UBlockCode = UBlockCode(219i32);
pub const UBLOCK_TAKRI: UBlockCode = UBlockCode(220i32);
pub const UBLOCK_BASSA_VAH: UBlockCode = UBlockCode(221i32);
pub const UBLOCK_CAUCASIAN_ALBANIAN: UBlockCode = UBlockCode(222i32);
pub const UBLOCK_COPTIC_EPACT_NUMBERS: UBlockCode = UBlockCode(223i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED: UBlockCode = UBlockCode(224i32);
pub const UBLOCK_DUPLOYAN: UBlockCode = UBlockCode(225i32);
pub const UBLOCK_ELBASAN: UBlockCode = UBlockCode(226i32);
pub const UBLOCK_GEOMETRIC_SHAPES_EXTENDED: UBlockCode = UBlockCode(227i32);
pub const UBLOCK_GRANTHA: UBlockCode = UBlockCode(228i32);
pub const UBLOCK_KHOJKI: UBlockCode = UBlockCode(229i32);
pub const UBLOCK_KHUDAWADI: UBlockCode = UBlockCode(230i32);
pub const UBLOCK_LATIN_EXTENDED_E: UBlockCode = UBlockCode(231i32);
pub const UBLOCK_LINEAR_A: UBlockCode = UBlockCode(232i32);
pub const UBLOCK_MAHAJANI: UBlockCode = UBlockCode(233i32);
pub const UBLOCK_MANICHAEAN: UBlockCode = UBlockCode(234i32);
pub const UBLOCK_MENDE_KIKAKUI: UBlockCode = UBlockCode(235i32);
pub const UBLOCK_MODI: UBlockCode = UBlockCode(236i32);
pub const UBLOCK_MRO: UBlockCode = UBlockCode(237i32);
pub const UBLOCK_MYANMAR_EXTENDED_B: UBlockCode = UBlockCode(238i32);
pub const UBLOCK_NABATAEAN: UBlockCode = UBlockCode(239i32);
pub const UBLOCK_OLD_NORTH_ARABIAN: UBlockCode = UBlockCode(240i32);
pub const UBLOCK_OLD_PERMIC: UBlockCode = UBlockCode(241i32);
pub const UBLOCK_ORNAMENTAL_DINGBATS: UBlockCode = UBlockCode(242i32);
pub const UBLOCK_PAHAWH_HMONG: UBlockCode = UBlockCode(243i32);
pub const UBLOCK_PALMYRENE: UBlockCode = UBlockCode(244i32);
pub const UBLOCK_PAU_CIN_HAU: UBlockCode = UBlockCode(245i32);
pub const UBLOCK_PSALTER_PAHLAVI: UBlockCode = UBlockCode(246i32);
pub const UBLOCK_SHORTHAND_FORMAT_CONTROLS: UBlockCode = UBlockCode(247i32);
pub const UBLOCK_SIDDHAM: UBlockCode = UBlockCode(248i32);
pub const UBLOCK_SINHALA_ARCHAIC_NUMBERS: UBlockCode = UBlockCode(249i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_C: UBlockCode = UBlockCode(250i32);
pub const UBLOCK_TIRHUTA: UBlockCode = UBlockCode(251i32);
pub const UBLOCK_WARANG_CITI: UBlockCode = UBlockCode(252i32);
pub const UBLOCK_AHOM: UBlockCode = UBlockCode(253i32);
pub const UBLOCK_ANATOLIAN_HIEROGLYPHS: UBlockCode = UBlockCode(254i32);
pub const UBLOCK_CHEROKEE_SUPPLEMENT: UBlockCode = UBlockCode(255i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E: UBlockCode = UBlockCode(256i32);
pub const UBLOCK_EARLY_DYNASTIC_CUNEIFORM: UBlockCode = UBlockCode(257i32);
pub const UBLOCK_HATRAN: UBlockCode = UBlockCode(258i32);
pub const UBLOCK_MULTANI: UBlockCode = UBlockCode(259i32);
pub const UBLOCK_OLD_HUNGARIAN: UBlockCode = UBlockCode(260i32);
pub const UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(261i32);
pub const UBLOCK_SUTTON_SIGNWRITING: UBlockCode = UBlockCode(262i32);
pub const UBLOCK_ADLAM: UBlockCode = UBlockCode(263i32);
pub const UBLOCK_BHAIKSUKI: UBlockCode = UBlockCode(264i32);
pub const UBLOCK_CYRILLIC_EXTENDED_C: UBlockCode = UBlockCode(265i32);
pub const UBLOCK_GLAGOLITIC_SUPPLEMENT: UBlockCode = UBlockCode(266i32);
pub const UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(267i32);
pub const UBLOCK_MARCHEN: UBlockCode = UBlockCode(268i32);
pub const UBLOCK_MONGOLIAN_SUPPLEMENT: UBlockCode = UBlockCode(269i32);
pub const UBLOCK_NEWA: UBlockCode = UBlockCode(270i32);
pub const UBLOCK_OSAGE: UBlockCode = UBlockCode(271i32);
pub const UBLOCK_TANGUT: UBlockCode = UBlockCode(272i32);
pub const UBLOCK_TANGUT_COMPONENTS: UBlockCode = UBlockCode(273i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F: UBlockCode = UBlockCode(274i32);
pub const UBLOCK_KANA_EXTENDED_A: UBlockCode = UBlockCode(275i32);
pub const UBLOCK_MASARAM_GONDI: UBlockCode = UBlockCode(276i32);
pub const UBLOCK_NUSHU: UBlockCode = UBlockCode(277i32);
pub const UBLOCK_SOYOMBO: UBlockCode = UBlockCode(278i32);
pub const UBLOCK_SYRIAC_SUPPLEMENT: UBlockCode = UBlockCode(279i32);
pub const UBLOCK_ZANABAZAR_SQUARE: UBlockCode = UBlockCode(280i32);
pub const UBLOCK_CHESS_SYMBOLS: UBlockCode = UBlockCode(281i32);
pub const UBLOCK_DOGRA: UBlockCode = UBlockCode(282i32);
pub const UBLOCK_GEORGIAN_EXTENDED: UBlockCode = UBlockCode(283i32);
pub const UBLOCK_GUNJALA_GONDI: UBlockCode = UBlockCode(284i32);
pub const UBLOCK_HANIFI_ROHINGYA: UBlockCode = UBlockCode(285i32);
pub const UBLOCK_INDIC_SIYAQ_NUMBERS: UBlockCode = UBlockCode(286i32);
pub const UBLOCK_MAKASAR: UBlockCode = UBlockCode(287i32);
pub const UBLOCK_MAYAN_NUMERALS: UBlockCode = UBlockCode(288i32);
pub const UBLOCK_MEDEFAIDRIN: UBlockCode = UBlockCode(289i32);
pub const UBLOCK_OLD_SOGDIAN: UBlockCode = UBlockCode(290i32);
pub const UBLOCK_SOGDIAN: UBlockCode = UBlockCode(291i32);
pub const UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS: UBlockCode = UBlockCode(292i32);
pub const UBLOCK_ELYMAIC: UBlockCode = UBlockCode(293i32);
pub const UBLOCK_NANDINAGARI: UBlockCode = UBlockCode(294i32);
pub const UBLOCK_NYIAKENG_PUACHUE_HMONG: UBlockCode = UBlockCode(295i32);
pub const UBLOCK_OTTOMAN_SIYAQ_NUMBERS: UBlockCode = UBlockCode(296i32);
pub const UBLOCK_SMALL_KANA_EXTENSION: UBlockCode = UBlockCode(297i32);
pub const UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A: UBlockCode = UBlockCode(298i32);
pub const UBLOCK_TAMIL_SUPPLEMENT: UBlockCode = UBlockCode(299i32);
pub const UBLOCK_WANCHO: UBlockCode = UBlockCode(300i32);
pub const UBLOCK_CHORASMIAN: UBlockCode = UBlockCode(301i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G: UBlockCode = UBlockCode(302i32);
pub const UBLOCK_DIVES_AKURU: UBlockCode = UBlockCode(303i32);
pub const UBLOCK_KHITAN_SMALL_SCRIPT: UBlockCode = UBlockCode(304i32);
pub const UBLOCK_LISU_SUPPLEMENT: UBlockCode = UBlockCode(305i32);
pub const UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING: UBlockCode = UBlockCode(306i32);
pub const UBLOCK_TANGUT_SUPPLEMENT: UBlockCode = UBlockCode(307i32);
pub const UBLOCK_YEZIDI: UBlockCode = UBlockCode(308i32);
pub const UBLOCK_INVALID_CODE: UBlockCode = UBlockCode(-1i32);
impl ::std::convert::From<i32> for UBlockCode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBlockCode {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UBreakIterator(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UBreakIteratorType(pub i32);
pub const UBRK_CHARACTER: UBreakIteratorType = UBreakIteratorType(0i32);
pub const UBRK_WORD: UBreakIteratorType = UBreakIteratorType(1i32);
pub const UBRK_LINE: UBreakIteratorType = UBreakIteratorType(2i32);
pub const UBRK_SENTENCE: UBreakIteratorType = UBreakIteratorType(3i32);
impl ::std::convert::From<i32> for UBreakIteratorType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBreakIteratorType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCHAR_MAX_VALUE: u32 = 1114111u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCHAR_MIN_VALUE: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCLN_NO_AUTO_CLEANUP: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_ESCAPE(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_ESCAPE(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_ESCAPE(::std::mem::transmute(context), ::std::mem::transmute(fromuargs), ::std::mem::transmute(codeunits), ::std::mem::transmute(length), ::std::mem::transmute(codepoint), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_SKIP(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_SKIP(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_SKIP(::std::mem::transmute(context), ::std::mem::transmute(fromuargs), ::std::mem::transmute(codeunits), ::std::mem::transmute(length), ::std::mem::transmute(codepoint), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_STOP(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_STOP(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_STOP(::std::mem::transmute(context), ::std::mem::transmute(fromuargs), ::std::mem::transmute(codeunits), ::std::mem::transmute(length), ::std::mem::transmute(codepoint), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_SUBSTITUTE(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_SUBSTITUTE(context: *const ::std::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_SUBSTITUTE(::std::mem::transmute(context), ::std::mem::transmute(fromuargs), ::std::mem::transmute(codeunits), ::std::mem::transmute(length), ::std::mem::transmute(codepoint), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCNV_MAX_CONVERTER_NAME_LENGTH: u32 = 60u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCNV_SI: u32 = 15u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCNV_SO: u32 = 14u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_ESCAPE<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: Param2, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_ESCAPE(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: super::Foundation::PSTR, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_ESCAPE(::std::mem::transmute(context), ::std::mem::transmute(touargs), codeunits.into_param().abi(), ::std::mem::transmute(length), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_SKIP<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: Param2, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_SKIP(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: super::Foundation::PSTR, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_SKIP(::std::mem::transmute(context), ::std::mem::transmute(touargs), codeunits.into_param().abi(), ::std::mem::transmute(length), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_STOP<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: Param2, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_STOP(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: super::Foundation::PSTR, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_STOP(::std::mem::transmute(context), ::std::mem::transmute(touargs), codeunits.into_param().abi(), ::std::mem::transmute(length), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_SUBSTITUTE<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: Param2, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_SUBSTITUTE(context: *const ::std::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: super::Foundation::PSTR, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode);
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_SUBSTITUTE(::std::mem::transmute(context), ::std::mem::transmute(touargs), codeunits.into_param().abi(), ::std::mem::transmute(length), ::std::mem::transmute(reason), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCONFIG_ENABLE_PLUGINS: u32 = 0u32;
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCPMap(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCPMapRangeOption(pub i32);
pub const UCPMAP_RANGE_NORMAL: UCPMapRangeOption = UCPMapRangeOption(0i32);
pub const UCPMAP_RANGE_FIXED_LEAD_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(1i32);
pub const UCPMAP_RANGE_FIXED_ALL_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(2i32);
impl ::std::convert::From<i32> for UCPMapRangeOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPMapRangeOption {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCPMapValueFilter = unsafe extern "system" fn(context: *const ::std::ffi::c_void, value: u32) -> u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_ERROR_VALUE_NEG_DATA_OFFSET: i32 = 1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_FAST_DATA_BLOCK_LENGTH: i32 = 64i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_FAST_DATA_MASK: i32 = 63i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_FAST_SHIFT: i32 = 6i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_HIGH_VALUE_NEG_DATA_OFFSET: i32 = 2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UCPTRIE_SMALL_MAX: i32 = 4095i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UCPTrie {
    pub index: *mut u16,
    pub data: UCPTrieData,
    pub indexLength: i32,
    pub dataLength: i32,
    pub highStart: i32,
    pub shifted12HighStart: u16,
    pub r#type: i8,
    pub valueWidth: i8,
    pub reserved32: u32,
    pub reserved16: u16,
    pub index3NullOffset: u16,
    pub dataNullOffset: i32,
    pub nullValue: u32,
}
impl UCPTrie {}
impl ::std::default::Default for UCPTrie {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for UCPTrie {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for UCPTrie {}
unsafe impl ::windows::runtime::Abi for UCPTrie {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub union UCPTrieData {
    pub ptr0: *mut ::std::ffi::c_void,
    pub ptr16: *mut u16,
    pub ptr32: *mut u32,
    pub ptr8: *mut u8,
}
impl UCPTrieData {}
impl ::std::default::Default for UCPTrieData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for UCPTrieData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for UCPTrieData {}
unsafe impl ::windows::runtime::Abi for UCPTrieData {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCPTrieType(pub i32);
pub const UCPTRIE_TYPE_ANY: UCPTrieType = UCPTrieType(-1i32);
pub const UCPTRIE_TYPE_FAST: UCPTrieType = UCPTrieType(0i32);
pub const UCPTRIE_TYPE_SMALL: UCPTrieType = UCPTrieType(1i32);
impl ::std::convert::From<i32> for UCPTrieType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPTrieType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCPTrieValueWidth(pub i32);
pub const UCPTRIE_VALUE_BITS_ANY: UCPTrieValueWidth = UCPTrieValueWidth(-1i32);
pub const UCPTRIE_VALUE_BITS_16: UCPTrieValueWidth = UCPTrieValueWidth(0i32);
pub const UCPTRIE_VALUE_BITS_32: UCPTrieValueWidth = UCPTrieValueWidth(1i32);
pub const UCPTRIE_VALUE_BITS_8: UCPTrieValueWidth = UCPTrieValueWidth(2i32);
impl ::std::convert::From<i32> for UCPTrieValueWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPTrieValueWidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarAMPMs(pub i32);
pub const UCAL_AM: UCalendarAMPMs = UCalendarAMPMs(0i32);
pub const UCAL_PM: UCalendarAMPMs = UCalendarAMPMs(1i32);
impl ::std::convert::From<i32> for UCalendarAMPMs {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarAMPMs {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarAttribute(pub i32);
pub const UCAL_LENIENT: UCalendarAttribute = UCalendarAttribute(0i32);
pub const UCAL_FIRST_DAY_OF_WEEK: UCalendarAttribute = UCalendarAttribute(1i32);
pub const UCAL_MINIMAL_DAYS_IN_FIRST_WEEK: UCalendarAttribute = UCalendarAttribute(2i32);
pub const UCAL_REPEATED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(3i32);
pub const UCAL_SKIPPED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(4i32);
impl ::std::convert::From<i32> for UCalendarAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarAttribute {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarDateFields(pub i32);
pub const UCAL_ERA: UCalendarDateFields = UCalendarDateFields(0i32);
pub const UCAL_YEAR: UCalendarDateFields = UCalendarDateFields(1i32);
pub const UCAL_MONTH: UCalendarDateFields = UCalendarDateFields(2i32);
pub const UCAL_WEEK_OF_YEAR: UCalendarDateFields = UCalendarDateFields(3i32);
pub const UCAL_WEEK_OF_MONTH: UCalendarDateFields = UCalendarDateFields(4i32);
pub const UCAL_DATE: UCalendarDateFields = UCalendarDateFields(5i32);
pub const UCAL_DAY_OF_YEAR: UCalendarDateFields = UCalendarDateFields(6i32);
pub const UCAL_DAY_OF_WEEK: UCalendarDateFields = UCalendarDateFields(7i32);
pub const UCAL_DAY_OF_WEEK_IN_MONTH: UCalendarDateFields = UCalendarDateFields(8i32);
pub const UCAL_AM_PM: UCalendarDateFields = UCalendarDateFields(9i32);
pub const UCAL_HOUR: UCalendarDateFields = UCalendarDateFields(10i32);
pub const UCAL_HOUR_OF_DAY: UCalendarDateFields = UCalendarDateFields(11i32);
pub const UCAL_MINUTE: UCalendarDateFields = UCalendarDateFields(12i32);
pub const UCAL_SECOND: UCalendarDateFields = UCalendarDateFields(13i32);
pub const UCAL_MILLISECOND: UCalendarDateFields = UCalendarDateFields(14i32);
pub const UCAL_ZONE_OFFSET: UCalendarDateFields = UCalendarDateFields(15i32);
pub const UCAL_DST_OFFSET: UCalendarDateFields = UCalendarDateFields(16i32);
pub const UCAL_YEAR_WOY: UCalendarDateFields = UCalendarDateFields(17i32);
pub const UCAL_DOW_LOCAL: UCalendarDateFields = UCalendarDateFields(18i32);
pub const UCAL_EXTENDED_YEAR: UCalendarDateFields = UCalendarDateFields(19i32);
pub const UCAL_JULIAN_DAY: UCalendarDateFields = UCalendarDateFields(20i32);
pub const UCAL_MILLISECONDS_IN_DAY: UCalendarDateFields = UCalendarDateFields(21i32);
pub const UCAL_IS_LEAP_MONTH: UCalendarDateFields = UCalendarDateFields(22i32);
pub const UCAL_FIELD_COUNT: UCalendarDateFields = UCalendarDateFields(23i32);
pub const UCAL_DAY_OF_MONTH: UCalendarDateFields = UCalendarDateFields(5i32);
impl ::std::convert::From<i32> for UCalendarDateFields {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDateFields {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarDaysOfWeek(pub i32);
pub const UCAL_SUNDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(1i32);
pub const UCAL_MONDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(2i32);
pub const UCAL_TUESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(3i32);
pub const UCAL_WEDNESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(4i32);
pub const UCAL_THURSDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(5i32);
pub const UCAL_FRIDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(6i32);
pub const UCAL_SATURDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(7i32);
impl ::std::convert::From<i32> for UCalendarDaysOfWeek {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDaysOfWeek {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarDisplayNameType(pub i32);
pub const UCAL_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(0i32);
pub const UCAL_SHORT_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(1i32);
pub const UCAL_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(2i32);
pub const UCAL_SHORT_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(3i32);
impl ::std::convert::From<i32> for UCalendarDisplayNameType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDisplayNameType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarLimitType(pub i32);
pub const UCAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(0i32);
pub const UCAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(1i32);
pub const UCAL_GREATEST_MINIMUM: UCalendarLimitType = UCalendarLimitType(2i32);
pub const UCAL_LEAST_MAXIMUM: UCalendarLimitType = UCalendarLimitType(3i32);
pub const UCAL_ACTUAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(4i32);
pub const UCAL_ACTUAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(5i32);
impl ::std::convert::From<i32> for UCalendarLimitType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarLimitType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarMonths(pub i32);
pub const UCAL_JANUARY: UCalendarMonths = UCalendarMonths(0i32);
pub const UCAL_FEBRUARY: UCalendarMonths = UCalendarMonths(1i32);
pub const UCAL_MARCH: UCalendarMonths = UCalendarMonths(2i32);
pub const UCAL_APRIL: UCalendarMonths = UCalendarMonths(3i32);
pub const UCAL_MAY: UCalendarMonths = UCalendarMonths(4i32);
pub const UCAL_JUNE: UCalendarMonths = UCalendarMonths(5i32);
pub const UCAL_JULY: UCalendarMonths = UCalendarMonths(6i32);
pub const UCAL_AUGUST: UCalendarMonths = UCalendarMonths(7i32);
pub const UCAL_SEPTEMBER: UCalendarMonths = UCalendarMonths(8i32);
pub const UCAL_OCTOBER: UCalendarMonths = UCalendarMonths(9i32);
pub const UCAL_NOVEMBER: UCalendarMonths = UCalendarMonths(10i32);
pub const UCAL_DECEMBER: UCalendarMonths = UCalendarMonths(11i32);
pub const UCAL_UNDECIMBER: UCalendarMonths = UCalendarMonths(12i32);
impl ::std::convert::From<i32> for UCalendarMonths {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarMonths {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarType(pub i32);
pub const UCAL_TRADITIONAL: UCalendarType = UCalendarType(0i32);
pub const UCAL_DEFAULT: UCalendarType = UCalendarType(0i32);
pub const UCAL_GREGORIAN: UCalendarType = UCalendarType(1i32);
impl ::std::convert::From<i32> for UCalendarType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarWallTimeOption(pub i32);
pub const UCAL_WALLTIME_LAST: UCalendarWallTimeOption = UCalendarWallTimeOption(0i32);
pub const UCAL_WALLTIME_FIRST: UCalendarWallTimeOption = UCalendarWallTimeOption(1i32);
pub const UCAL_WALLTIME_NEXT_VALID: UCalendarWallTimeOption = UCalendarWallTimeOption(2i32);
impl ::std::convert::From<i32> for UCalendarWallTimeOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarWallTimeOption {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCalendarWeekdayType(pub i32);
pub const UCAL_WEEKDAY: UCalendarWeekdayType = UCalendarWeekdayType(0i32);
pub const UCAL_WEEKEND: UCalendarWeekdayType = UCalendarWeekdayType(1i32);
pub const UCAL_WEEKEND_ONSET: UCalendarWeekdayType = UCalendarWeekdayType(2i32);
pub const UCAL_WEEKEND_CEASE: UCalendarWeekdayType = UCalendarWeekdayType(3i32);
impl ::std::convert::From<i32> for UCalendarWeekdayType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarWeekdayType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCaseMap(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCharCategory(pub i32);
pub const U_UNASSIGNED: UCharCategory = UCharCategory(0i32);
pub const U_GENERAL_OTHER_TYPES: UCharCategory = UCharCategory(0i32);
pub const U_UPPERCASE_LETTER: UCharCategory = UCharCategory(1i32);
pub const U_LOWERCASE_LETTER: UCharCategory = UCharCategory(2i32);
pub const U_TITLECASE_LETTER: UCharCategory = UCharCategory(3i32);
pub const U_MODIFIER_LETTER: UCharCategory = UCharCategory(4i32);
pub const U_OTHER_LETTER: UCharCategory = UCharCategory(5i32);
pub const U_NON_SPACING_MARK: UCharCategory = UCharCategory(6i32);
pub const U_ENCLOSING_MARK: UCharCategory = UCharCategory(7i32);
pub const U_COMBINING_SPACING_MARK: UCharCategory = UCharCategory(8i32);
pub const U_DECIMAL_DIGIT_NUMBER: UCharCategory = UCharCategory(9i32);
pub const U_LETTER_NUMBER: UCharCategory = UCharCategory(10i32);
pub const U_OTHER_NUMBER: UCharCategory = UCharCategory(11i32);
pub const U_SPACE_SEPARATOR: UCharCategory = UCharCategory(12i32);
pub const U_LINE_SEPARATOR: UCharCategory = UCharCategory(13i32);
pub const U_PARAGRAPH_SEPARATOR: UCharCategory = UCharCategory(14i32);
pub const U_CONTROL_CHAR: UCharCategory = UCharCategory(15i32);
pub const U_FORMAT_CHAR: UCharCategory = UCharCategory(16i32);
pub const U_PRIVATE_USE_CHAR: UCharCategory = UCharCategory(17i32);
pub const U_SURROGATE: UCharCategory = UCharCategory(18i32);
pub const U_DASH_PUNCTUATION: UCharCategory = UCharCategory(19i32);
pub const U_START_PUNCTUATION: UCharCategory = UCharCategory(20i32);
pub const U_END_PUNCTUATION: UCharCategory = UCharCategory(21i32);
pub const U_CONNECTOR_PUNCTUATION: UCharCategory = UCharCategory(22i32);
pub const U_OTHER_PUNCTUATION: UCharCategory = UCharCategory(23i32);
pub const U_MATH_SYMBOL: UCharCategory = UCharCategory(24i32);
pub const U_CURRENCY_SYMBOL: UCharCategory = UCharCategory(25i32);
pub const U_MODIFIER_SYMBOL: UCharCategory = UCharCategory(26i32);
pub const U_OTHER_SYMBOL: UCharCategory = UCharCategory(27i32);
pub const U_INITIAL_PUNCTUATION: UCharCategory = UCharCategory(28i32);
pub const U_FINAL_PUNCTUATION: UCharCategory = UCharCategory(29i32);
pub const U_CHAR_CATEGORY_COUNT: UCharCategory = UCharCategory(30i32);
impl ::std::convert::From<i32> for UCharCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharCategory {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCharDirection(pub i32);
pub const U_LEFT_TO_RIGHT: UCharDirection = UCharDirection(0i32);
pub const U_RIGHT_TO_LEFT: UCharDirection = UCharDirection(1i32);
pub const U_EUROPEAN_NUMBER: UCharDirection = UCharDirection(2i32);
pub const U_EUROPEAN_NUMBER_SEPARATOR: UCharDirection = UCharDirection(3i32);
pub const U_EUROPEAN_NUMBER_TERMINATOR: UCharDirection = UCharDirection(4i32);
pub const U_ARABIC_NUMBER: UCharDirection = UCharDirection(5i32);
pub const U_COMMON_NUMBER_SEPARATOR: UCharDirection = UCharDirection(6i32);
pub const U_BLOCK_SEPARATOR: UCharDirection = UCharDirection(7i32);
pub const U_SEGMENT_SEPARATOR: UCharDirection = UCharDirection(8i32);
pub const U_WHITE_SPACE_NEUTRAL: UCharDirection = UCharDirection(9i32);
pub const U_OTHER_NEUTRAL: UCharDirection = UCharDirection(10i32);
pub const U_LEFT_TO_RIGHT_EMBEDDING: UCharDirection = UCharDirection(11i32);
pub const U_LEFT_TO_RIGHT_OVERRIDE: UCharDirection = UCharDirection(12i32);
pub const U_RIGHT_TO_LEFT_ARABIC: UCharDirection = UCharDirection(13i32);
pub const U_RIGHT_TO_LEFT_EMBEDDING: UCharDirection = UCharDirection(14i32);
pub const U_RIGHT_TO_LEFT_OVERRIDE: UCharDirection = UCharDirection(15i32);
pub const U_POP_DIRECTIONAL_FORMAT: UCharDirection = UCharDirection(16i32);
pub const U_DIR_NON_SPACING_MARK: UCharDirection = UCharDirection(17i32);
pub const U_BOUNDARY_NEUTRAL: UCharDirection = UCharDirection(18i32);
pub const U_FIRST_STRONG_ISOLATE: UCharDirection = UCharDirection(19i32);
pub const U_LEFT_TO_RIGHT_ISOLATE: UCharDirection = UCharDirection(20i32);
pub const U_RIGHT_TO_LEFT_ISOLATE: UCharDirection = UCharDirection(21i32);
pub const U_POP_DIRECTIONAL_ISOLATE: UCharDirection = UCharDirection(22i32);
impl ::std::convert::From<i32> for UCharDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharDirection {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharEnumTypeRange = unsafe extern "system" fn(context: *const ::std::ffi::c_void, start: i32, limit: i32, r#type: UCharCategory) -> i8;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UCharIterator {
    pub context: *mut ::std::ffi::c_void,
    pub length: i32,
    pub start: i32,
    pub index: i32,
    pub limit: i32,
    pub reservedField: i32,
    pub getIndex: ::std::option::Option<UCharIteratorGetIndex>,
    pub r#move: ::std::option::Option<UCharIteratorMove>,
    pub hasNext: ::std::option::Option<UCharIteratorHasNext>,
    pub hasPrevious: ::std::option::Option<UCharIteratorHasPrevious>,
    pub current: ::std::option::Option<UCharIteratorCurrent>,
    pub next: ::std::option::Option<UCharIteratorNext>,
    pub previous: ::std::option::Option<UCharIteratorPrevious>,
    pub reservedFn: ::std::option::Option<UCharIteratorReserved>,
    pub getState: ::std::option::Option<UCharIteratorGetState>,
    pub setState: ::std::option::Option<UCharIteratorSetState>,
}
impl UCharIterator {}
impl ::std::default::Default for UCharIterator {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UCharIterator {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UCharIterator").field("context", &self.context).field("length", &self.length).field("start", &self.start).field("index", &self.index).field("limit", &self.limit).field("reservedField", &self.reservedField).finish()
    }
}
impl ::std::cmp::PartialEq for UCharIterator {
    fn eq(&self, other: &Self) -> bool {
        self.context == other.context
            && self.length == other.length
            && self.start == other.start
            && self.index == other.index
            && self.limit == other.limit
            && self.reservedField == other.reservedField
            && self.getIndex.map(|f| f as usize) == other.getIndex.map(|f| f as usize)
            && self.r#move.map(|f| f as usize) == other.r#move.map(|f| f as usize)
            && self.hasNext.map(|f| f as usize) == other.hasNext.map(|f| f as usize)
            && self.hasPrevious.map(|f| f as usize) == other.hasPrevious.map(|f| f as usize)
            && self.current.map(|f| f as usize) == other.current.map(|f| f as usize)
            && self.next.map(|f| f as usize) == other.next.map(|f| f as usize)
            && self.previous.map(|f| f as usize) == other.previous.map(|f| f as usize)
            && self.reservedFn.map(|f| f as usize) == other.reservedFn.map(|f| f as usize)
            && self.getState.map(|f| f as usize) == other.getState.map(|f| f as usize)
            && self.setState.map(|f| f as usize) == other.setState.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for UCharIterator {}
unsafe impl ::windows::runtime::Abi for UCharIterator {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorCurrent = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorGetIndex = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>, origin: UCharIteratorOrigin) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorGetState = unsafe extern "system" fn(iter: *const ::std::mem::ManuallyDrop<UCharIterator>) -> u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorHasNext = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i8;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorHasPrevious = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i8;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorMove = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>, delta: i32, origin: UCharIteratorOrigin) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorNext = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCharIteratorOrigin(pub i32);
pub const UITER_START: UCharIteratorOrigin = UCharIteratorOrigin(0i32);
pub const UITER_CURRENT: UCharIteratorOrigin = UCharIteratorOrigin(1i32);
pub const UITER_LIMIT: UCharIteratorOrigin = UCharIteratorOrigin(2i32);
pub const UITER_ZERO: UCharIteratorOrigin = UCharIteratorOrigin(3i32);
pub const UITER_LENGTH: UCharIteratorOrigin = UCharIteratorOrigin(4i32);
impl ::std::convert::From<i32> for UCharIteratorOrigin {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharIteratorOrigin {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorPrevious = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorReserved = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>, something: i32) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UCharIteratorSetState = unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>, state: u32, perrorcode: *mut UErrorCode);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCharNameChoice(pub i32);
pub const U_UNICODE_CHAR_NAME: UCharNameChoice = UCharNameChoice(0i32);
pub const U_EXTENDED_CHAR_NAME: UCharNameChoice = UCharNameChoice(2i32);
pub const U_CHAR_NAME_ALIAS: UCharNameChoice = UCharNameChoice(3i32);
impl ::std::convert::From<i32> for UCharNameChoice {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharNameChoice {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCharsetDetector(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCharsetMatch(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UColAttribute(pub i32);
pub const UCOL_FRENCH_COLLATION: UColAttribute = UColAttribute(0i32);
pub const UCOL_ALTERNATE_HANDLING: UColAttribute = UColAttribute(1i32);
pub const UCOL_CASE_FIRST: UColAttribute = UColAttribute(2i32);
pub const UCOL_CASE_LEVEL: UColAttribute = UColAttribute(3i32);
pub const UCOL_NORMALIZATION_MODE: UColAttribute = UColAttribute(4i32);
pub const UCOL_DECOMPOSITION_MODE: UColAttribute = UColAttribute(4i32);
pub const UCOL_STRENGTH: UColAttribute = UColAttribute(5i32);
pub const UCOL_NUMERIC_COLLATION: UColAttribute = UColAttribute(7i32);
pub const UCOL_ATTRIBUTE_COUNT: UColAttribute = UColAttribute(8i32);
impl ::std::convert::From<i32> for UColAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UColAttribute {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UColAttributeValue(pub i32);
pub const UCOL_DEFAULT: UColAttributeValue = UColAttributeValue(-1i32);
pub const UCOL_PRIMARY: UColAttributeValue = UColAttributeValue(0i32);
pub const UCOL_SECONDARY: UColAttributeValue = UColAttributeValue(1i32);
pub const UCOL_TERTIARY: UColAttributeValue = UColAttributeValue(2i32);
pub const UCOL_DEFAULT_STRENGTH: UColAttributeValue = UColAttributeValue(2i32);
pub const UCOL_CE_STRENGTH_LIMIT: UColAttributeValue = UColAttributeValue(3i32);
pub const UCOL_QUATERNARY: UColAttributeValue = UColAttributeValue(3i32);
pub const UCOL_IDENTICAL: UColAttributeValue = UColAttributeValue(15i32);
pub const UCOL_STRENGTH_LIMIT: UColAttributeValue = UColAttributeValue(16i32);
pub const UCOL_OFF: UColAttributeValue = UColAttributeValue(16i32);
pub const UCOL_ON: UColAttributeValue = UColAttributeValue(17i32);
pub const UCOL_SHIFTED: UColAttributeValue = UColAttributeValue(20i32);
pub const UCOL_NON_IGNORABLE: UColAttributeValue = UColAttributeValue(21i32);
pub const UCOL_LOWER_FIRST: UColAttributeValue = UColAttributeValue(24i32);
pub const UCOL_UPPER_FIRST: UColAttributeValue = UColAttributeValue(25i32);
impl ::std::convert::From<i32> for UColAttributeValue {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UColAttributeValue {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UColBoundMode(pub i32);
pub const UCOL_BOUND_LOWER: UColBoundMode = UColBoundMode(0i32);
pub const UCOL_BOUND_UPPER: UColBoundMode = UColBoundMode(1i32);
pub const UCOL_BOUND_UPPER_LONG: UColBoundMode = UColBoundMode(2i32);
impl ::std::convert::From<i32> for UColBoundMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UColBoundMode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UColReorderCode(pub i32);
pub const UCOL_REORDER_CODE_DEFAULT: UColReorderCode = UColReorderCode(-1i32);
pub const UCOL_REORDER_CODE_NONE: UColReorderCode = UColReorderCode(103i32);
pub const UCOL_REORDER_CODE_OTHERS: UColReorderCode = UColReorderCode(103i32);
pub const UCOL_REORDER_CODE_SPACE: UColReorderCode = UColReorderCode(4096i32);
pub const UCOL_REORDER_CODE_FIRST: UColReorderCode = UColReorderCode(4096i32);
pub const UCOL_REORDER_CODE_PUNCTUATION: UColReorderCode = UColReorderCode(4097i32);
pub const UCOL_REORDER_CODE_SYMBOL: UColReorderCode = UColReorderCode(4098i32);
pub const UCOL_REORDER_CODE_CURRENCY: UColReorderCode = UColReorderCode(4099i32);
pub const UCOL_REORDER_CODE_DIGIT: UColReorderCode = UColReorderCode(4100i32);
impl ::std::convert::From<i32> for UColReorderCode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UColReorderCode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UColRuleOption(pub i32);
pub const UCOL_TAILORING_ONLY: UColRuleOption = UColRuleOption(0i32);
pub const UCOL_FULL_RULES: UColRuleOption = UColRuleOption(1i32);
impl ::std::convert::From<i32> for UColRuleOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UColRuleOption {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCollationElements(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCollationResult(pub i32);
pub const UCOL_EQUAL: UCollationResult = UCollationResult(0i32);
pub const UCOL_GREATER: UCollationResult = UCollationResult(1i32);
pub const UCOL_LESS: UCollationResult = UCollationResult(-1i32);
impl ::std::convert::From<i32> for UCollationResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCollationResult {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UCollator(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UConstrainedFieldPosition(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UConverter(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UConverterCallbackReason(pub i32);
pub const UCNV_UNASSIGNED: UConverterCallbackReason = UConverterCallbackReason(0i32);
pub const UCNV_ILLEGAL: UConverterCallbackReason = UConverterCallbackReason(1i32);
pub const UCNV_IRREGULAR: UConverterCallbackReason = UConverterCallbackReason(2i32);
pub const UCNV_RESET: UConverterCallbackReason = UConverterCallbackReason(3i32);
pub const UCNV_CLOSE: UConverterCallbackReason = UConverterCallbackReason(4i32);
pub const UCNV_CLONE: UConverterCallbackReason = UConverterCallbackReason(5i32);
impl ::std::convert::From<i32> for UConverterCallbackReason {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UConverterCallbackReason {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UConverterFromUCallback = unsafe extern "system" fn(context: *const ::std::ffi::c_void, args: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, perrorcode: *mut UErrorCode);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct UConverterFromUnicodeArgs {
    pub size: u16,
    pub flush: i8,
    pub converter: *mut UConverter,
    pub source: *mut u16,
    pub sourceLimit: *mut u16,
    pub target: super::Foundation::PSTR,
    pub targetLimit: super::Foundation::PSTR,
    pub offsets: *mut i32,
}
#[cfg(feature = "Win32_Foundation")]
impl UConverterFromUnicodeArgs {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for UConverterFromUnicodeArgs {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for UConverterFromUnicodeArgs {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UConverterFromUnicodeArgs")
            .field("size", &self.size)
            .field("flush", &self.flush)
            .field("converter", &self.converter)
            .field("source", &self.source)
            .field("sourceLimit", &self.sourceLimit)
            .field("target", &self.target)
            .field("targetLimit", &self.targetLimit)
            .field("offsets", &self.offsets)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for UConverterFromUnicodeArgs {
    fn eq(&self, other: &Self) -> bool {
        self.size == other.size && self.flush == other.flush && self.converter == other.converter && self.source == other.source && self.sourceLimit == other.sourceLimit && self.target == other.target && self.targetLimit == other.targetLimit && self.offsets == other.offsets
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for UConverterFromUnicodeArgs {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for UConverterFromUnicodeArgs {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UConverterPlatform(pub i32);
pub const UCNV_UNKNOWN: UConverterPlatform = UConverterPlatform(-1i32);
pub const UCNV_IBM: UConverterPlatform = UConverterPlatform(0i32);
impl ::std::convert::From<i32> for UConverterPlatform {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UConverterPlatform {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UConverterSelector(pub u8);
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UConverterToUCallback = unsafe extern "system" fn(context: *const ::std::ffi::c_void, args: *mut UConverterToUnicodeArgs, codeunits: super::Foundation::PSTR, length: i32, reason: UConverterCallbackReason, perrorcode: *mut UErrorCode);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
pub struct UConverterToUnicodeArgs {
    pub size: u16,
    pub flush: i8,
    pub converter: *mut UConverter,
    pub source: super::Foundation::PSTR,
    pub sourceLimit: super::Foundation::PSTR,
    pub target: *mut u16,
    pub targetLimit: *mut u16,
    pub offsets: *mut i32,
}
#[cfg(feature = "Win32_Foundation")]
impl UConverterToUnicodeArgs {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for UConverterToUnicodeArgs {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for UConverterToUnicodeArgs {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UConverterToUnicodeArgs")
            .field("size", &self.size)
            .field("flush", &self.flush)
            .field("converter", &self.converter)
            .field("source", &self.source)
            .field("sourceLimit", &self.sourceLimit)
            .field("target", &self.target)
            .field("targetLimit", &self.targetLimit)
            .field("offsets", &self.offsets)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for UConverterToUnicodeArgs {
    fn eq(&self, other: &Self) -> bool {
        self.size == other.size && self.flush == other.flush && self.converter == other.converter && self.source == other.source && self.sourceLimit == other.sourceLimit && self.target == other.target && self.targetLimit == other.targetLimit && self.offsets == other.offsets
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for UConverterToUnicodeArgs {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for UConverterToUnicodeArgs {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UConverterType(pub i32);
pub const UCNV_UNSUPPORTED_CONVERTER: UConverterType = UConverterType(-1i32);
pub const UCNV_SBCS: UConverterType = UConverterType(0i32);
pub const UCNV_DBCS: UConverterType = UConverterType(1i32);
pub const UCNV_MBCS: UConverterType = UConverterType(2i32);
pub const UCNV_LATIN_1: UConverterType = UConverterType(3i32);
pub const UCNV_UTF8: UConverterType = UConverterType(4i32);
pub const UCNV_UTF16_BigEndian: UConverterType = UConverterType(5i32);
pub const UCNV_UTF16_LittleEndian: UConverterType = UConverterType(6i32);
pub const UCNV_UTF32_BigEndian: UConverterType = UConverterType(7i32);
pub const UCNV_UTF32_LittleEndian: UConverterType = UConverterType(8i32);
pub const UCNV_EBCDIC_STATEFUL: UConverterType = UConverterType(9i32);
pub const UCNV_ISO_2022: UConverterType = UConverterType(10i32);
pub const UCNV_LMBCS_1: UConverterType = UConverterType(11i32);
pub const UCNV_LMBCS_2: UConverterType = UConverterType(12i32);
pub const UCNV_LMBCS_3: UConverterType = UConverterType(13i32);
pub const UCNV_LMBCS_4: UConverterType = UConverterType(14i32);
pub const UCNV_LMBCS_5: UConverterType = UConverterType(15i32);
pub const UCNV_LMBCS_6: UConverterType = UConverterType(16i32);
pub const UCNV_LMBCS_8: UConverterType = UConverterType(17i32);
pub const UCNV_LMBCS_11: UConverterType = UConverterType(18i32);
pub const UCNV_LMBCS_16: UConverterType = UConverterType(19i32);
pub const UCNV_LMBCS_17: UConverterType = UConverterType(20i32);
pub const UCNV_LMBCS_18: UConverterType = UConverterType(21i32);
pub const UCNV_LMBCS_19: UConverterType = UConverterType(22i32);
pub const UCNV_LMBCS_LAST: UConverterType = UConverterType(22i32);
pub const UCNV_HZ: UConverterType = UConverterType(23i32);
pub const UCNV_SCSU: UConverterType = UConverterType(24i32);
pub const UCNV_ISCII: UConverterType = UConverterType(25i32);
pub const UCNV_US_ASCII: UConverterType = UConverterType(26i32);
pub const UCNV_UTF7: UConverterType = UConverterType(27i32);
pub const UCNV_BOCU1: UConverterType = UConverterType(28i32);
pub const UCNV_UTF16: UConverterType = UConverterType(29i32);
pub const UCNV_UTF32: UConverterType = UConverterType(30i32);
pub const UCNV_CESU8: UConverterType = UConverterType(31i32);
pub const UCNV_IMAP_MAILBOX: UConverterType = UConverterType(32i32);
pub const UCNV_COMPOUND_TEXT: UConverterType = UConverterType(33i32);
pub const UCNV_NUMBER_OF_SUPPORTED_CONVERTER_TYPES: UConverterType = UConverterType(34i32);
impl ::std::convert::From<i32> for UConverterType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UConverterType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UConverterUnicodeSet(pub i32);
pub const UCNV_ROUNDTRIP_SET: UConverterUnicodeSet = UConverterUnicodeSet(0i32);
pub const UCNV_ROUNDTRIP_AND_FALLBACK_SET: UConverterUnicodeSet = UConverterUnicodeSet(1i32);
impl ::std::convert::From<i32> for UConverterUnicodeSet {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UConverterUnicodeSet {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCurrCurrencyType(pub i32);
pub const UCURR_ALL: UCurrCurrencyType = UCurrCurrencyType(2147483647i32);
pub const UCURR_COMMON: UCurrCurrencyType = UCurrCurrencyType(1i32);
pub const UCURR_UNCOMMON: UCurrCurrencyType = UCurrCurrencyType(2i32);
pub const UCURR_DEPRECATED: UCurrCurrencyType = UCurrCurrencyType(4i32);
pub const UCURR_NON_DEPRECATED: UCurrCurrencyType = UCurrCurrencyType(8i32);
impl ::std::convert::From<i32> for UCurrCurrencyType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCurrCurrencyType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCurrNameStyle(pub i32);
pub const UCURR_SYMBOL_NAME: UCurrNameStyle = UCurrNameStyle(0i32);
pub const UCURR_LONG_NAME: UCurrNameStyle = UCurrNameStyle(1i32);
pub const UCURR_NARROW_SYMBOL_NAME: UCurrNameStyle = UCurrNameStyle(2i32);
impl ::std::convert::From<i32> for UCurrNameStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCurrNameStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCurrencySpacing(pub i32);
pub const UNUM_CURRENCY_MATCH: UCurrencySpacing = UCurrencySpacing(0i32);
pub const UNUM_CURRENCY_SURROUNDING_MATCH: UCurrencySpacing = UCurrencySpacing(1i32);
pub const UNUM_CURRENCY_INSERT: UCurrencySpacing = UCurrencySpacing(2i32);
pub const UNUM_CURRENCY_SPACING_COUNT: UCurrencySpacing = UCurrencySpacing(3i32);
impl ::std::convert::From<i32> for UCurrencySpacing {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCurrencySpacing {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UCurrencyUsage(pub i32);
pub const UCURR_USAGE_STANDARD: UCurrencyUsage = UCurrencyUsage(0i32);
pub const UCURR_USAGE_CASH: UCurrencyUsage = UCurrencyUsage(1i32);
impl ::std::convert::From<i32> for UCurrencyUsage {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCurrencyUsage {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateAbsoluteUnit(pub i32);
pub const UDAT_ABSOLUTE_SUNDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(0i32);
pub const UDAT_ABSOLUTE_MONDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(1i32);
pub const UDAT_ABSOLUTE_TUESDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(2i32);
pub const UDAT_ABSOLUTE_WEDNESDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(3i32);
pub const UDAT_ABSOLUTE_THURSDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(4i32);
pub const UDAT_ABSOLUTE_FRIDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(5i32);
pub const UDAT_ABSOLUTE_SATURDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(6i32);
pub const UDAT_ABSOLUTE_DAY: UDateAbsoluteUnit = UDateAbsoluteUnit(7i32);
pub const UDAT_ABSOLUTE_WEEK: UDateAbsoluteUnit = UDateAbsoluteUnit(8i32);
pub const UDAT_ABSOLUTE_MONTH: UDateAbsoluteUnit = UDateAbsoluteUnit(9i32);
pub const UDAT_ABSOLUTE_YEAR: UDateAbsoluteUnit = UDateAbsoluteUnit(10i32);
pub const UDAT_ABSOLUTE_NOW: UDateAbsoluteUnit = UDateAbsoluteUnit(11i32);
pub const UDAT_ABSOLUTE_UNIT_COUNT: UDateAbsoluteUnit = UDateAbsoluteUnit(12i32);
impl ::std::convert::From<i32> for UDateAbsoluteUnit {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateAbsoluteUnit {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateDirection(pub i32);
pub const UDAT_DIRECTION_LAST_2: UDateDirection = UDateDirection(0i32);
pub const UDAT_DIRECTION_LAST: UDateDirection = UDateDirection(1i32);
pub const UDAT_DIRECTION_THIS: UDateDirection = UDateDirection(2i32);
pub const UDAT_DIRECTION_NEXT: UDateDirection = UDateDirection(3i32);
pub const UDAT_DIRECTION_NEXT_2: UDateDirection = UDateDirection(4i32);
pub const UDAT_DIRECTION_PLAIN: UDateDirection = UDateDirection(5i32);
pub const UDAT_DIRECTION_COUNT: UDateDirection = UDateDirection(6i32);
impl ::std::convert::From<i32> for UDateDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateDirection {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateFormatBooleanAttribute(pub i32);
pub const UDAT_PARSE_ALLOW_WHITESPACE: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(0i32);
pub const UDAT_PARSE_ALLOW_NUMERIC: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(1i32);
pub const UDAT_PARSE_PARTIAL_LITERAL_MATCH: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(2i32);
pub const UDAT_PARSE_MULTIPLE_PATTERNS_FOR_MATCH: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(3i32);
pub const UDAT_BOOLEAN_ATTRIBUTE_COUNT: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(4i32);
impl ::std::convert::From<i32> for UDateFormatBooleanAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateFormatBooleanAttribute {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateFormatField(pub i32);
pub const UDAT_ERA_FIELD: UDateFormatField = UDateFormatField(0i32);
pub const UDAT_YEAR_FIELD: UDateFormatField = UDateFormatField(1i32);
pub const UDAT_MONTH_FIELD: UDateFormatField = UDateFormatField(2i32);
pub const UDAT_DATE_FIELD: UDateFormatField = UDateFormatField(3i32);
pub const UDAT_HOUR_OF_DAY1_FIELD: UDateFormatField = UDateFormatField(4i32);
pub const UDAT_HOUR_OF_DAY0_FIELD: UDateFormatField = UDateFormatField(5i32);
pub const UDAT_MINUTE_FIELD: UDateFormatField = UDateFormatField(6i32);
pub const UDAT_SECOND_FIELD: UDateFormatField = UDateFormatField(7i32);
pub const UDAT_FRACTIONAL_SECOND_FIELD: UDateFormatField = UDateFormatField(8i32);
pub const UDAT_DAY_OF_WEEK_FIELD: UDateFormatField = UDateFormatField(9i32);
pub const UDAT_DAY_OF_YEAR_FIELD: UDateFormatField = UDateFormatField(10i32);
pub const UDAT_DAY_OF_WEEK_IN_MONTH_FIELD: UDateFormatField = UDateFormatField(11i32);
pub const UDAT_WEEK_OF_YEAR_FIELD: UDateFormatField = UDateFormatField(12i32);
pub const UDAT_WEEK_OF_MONTH_FIELD: UDateFormatField = UDateFormatField(13i32);
pub const UDAT_AM_PM_FIELD: UDateFormatField = UDateFormatField(14i32);
pub const UDAT_HOUR1_FIELD: UDateFormatField = UDateFormatField(15i32);
pub const UDAT_HOUR0_FIELD: UDateFormatField = UDateFormatField(16i32);
pub const UDAT_TIMEZONE_FIELD: UDateFormatField = UDateFormatField(17i32);
pub const UDAT_YEAR_WOY_FIELD: UDateFormatField = UDateFormatField(18i32);
pub const UDAT_DOW_LOCAL_FIELD: UDateFormatField = UDateFormatField(19i32);
pub const UDAT_EXTENDED_YEAR_FIELD: UDateFormatField = UDateFormatField(20i32);
pub const UDAT_JULIAN_DAY_FIELD: UDateFormatField = UDateFormatField(21i32);
pub const UDAT_MILLISECONDS_IN_DAY_FIELD: UDateFormatField = UDateFormatField(22i32);
pub const UDAT_TIMEZONE_RFC_FIELD: UDateFormatField = UDateFormatField(23i32);
pub const UDAT_TIMEZONE_GENERIC_FIELD: UDateFormatField = UDateFormatField(24i32);
pub const UDAT_STANDALONE_DAY_FIELD: UDateFormatField = UDateFormatField(25i32);
pub const UDAT_STANDALONE_MONTH_FIELD: UDateFormatField = UDateFormatField(26i32);
pub const UDAT_QUARTER_FIELD: UDateFormatField = UDateFormatField(27i32);
pub const UDAT_STANDALONE_QUARTER_FIELD: UDateFormatField = UDateFormatField(28i32);
pub const UDAT_TIMEZONE_SPECIAL_FIELD: UDateFormatField = UDateFormatField(29i32);
pub const UDAT_YEAR_NAME_FIELD: UDateFormatField = UDateFormatField(30i32);
pub const UDAT_TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD: UDateFormatField = UDateFormatField(31i32);
pub const UDAT_TIMEZONE_ISO_FIELD: UDateFormatField = UDateFormatField(32i32);
pub const UDAT_TIMEZONE_ISO_LOCAL_FIELD: UDateFormatField = UDateFormatField(33i32);
pub const UDAT_AM_PM_MIDNIGHT_NOON_FIELD: UDateFormatField = UDateFormatField(35i32);
pub const UDAT_FLEXIBLE_DAY_PERIOD_FIELD: UDateFormatField = UDateFormatField(36i32);
impl ::std::convert::From<i32> for UDateFormatField {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateFormatField {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateFormatStyle(pub i32);
pub const UDAT_FULL: UDateFormatStyle = UDateFormatStyle(0i32);
pub const UDAT_LONG: UDateFormatStyle = UDateFormatStyle(1i32);
pub const UDAT_MEDIUM: UDateFormatStyle = UDateFormatStyle(2i32);
pub const UDAT_SHORT: UDateFormatStyle = UDateFormatStyle(3i32);
pub const UDAT_DEFAULT: UDateFormatStyle = UDateFormatStyle(2i32);
pub const UDAT_RELATIVE: UDateFormatStyle = UDateFormatStyle(128i32);
pub const UDAT_FULL_RELATIVE: UDateFormatStyle = UDateFormatStyle(128i32);
pub const UDAT_LONG_RELATIVE: UDateFormatStyle = UDateFormatStyle(129i32);
pub const UDAT_MEDIUM_RELATIVE: UDateFormatStyle = UDateFormatStyle(130i32);
pub const UDAT_SHORT_RELATIVE: UDateFormatStyle = UDateFormatStyle(131i32);
pub const UDAT_NONE: UDateFormatStyle = UDateFormatStyle(-1i32);
pub const UDAT_PATTERN: UDateFormatStyle = UDateFormatStyle(-2i32);
impl ::std::convert::From<i32> for UDateFormatStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateFormatStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateFormatSymbolType(pub i32);
pub const UDAT_ERAS: UDateFormatSymbolType = UDateFormatSymbolType(0i32);
pub const UDAT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(1i32);
pub const UDAT_SHORT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(2i32);
pub const UDAT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(3i32);
pub const UDAT_SHORT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(4i32);
pub const UDAT_AM_PMS: UDateFormatSymbolType = UDateFormatSymbolType(5i32);
pub const UDAT_LOCALIZED_CHARS: UDateFormatSymbolType = UDateFormatSymbolType(6i32);
pub const UDAT_ERA_NAMES: UDateFormatSymbolType = UDateFormatSymbolType(7i32);
pub const UDAT_NARROW_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(8i32);
pub const UDAT_NARROW_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(9i32);
pub const UDAT_STANDALONE_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(10i32);
pub const UDAT_STANDALONE_SHORT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(11i32);
pub const UDAT_STANDALONE_NARROW_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(12i32);
pub const UDAT_STANDALONE_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(13i32);
pub const UDAT_STANDALONE_SHORT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(14i32);
pub const UDAT_STANDALONE_NARROW_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(15i32);
pub const UDAT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(16i32);
pub const UDAT_SHORT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(17i32);
pub const UDAT_STANDALONE_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(18i32);
pub const UDAT_STANDALONE_SHORT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(19i32);
pub const UDAT_SHORTER_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(20i32);
pub const UDAT_STANDALONE_SHORTER_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(21i32);
pub const UDAT_CYCLIC_YEARS_WIDE: UDateFormatSymbolType = UDateFormatSymbolType(22i32);
pub const UDAT_CYCLIC_YEARS_ABBREVIATED: UDateFormatSymbolType = UDateFormatSymbolType(23i32);
pub const UDAT_CYCLIC_YEARS_NARROW: UDateFormatSymbolType = UDateFormatSymbolType(24i32);
pub const UDAT_ZODIAC_NAMES_WIDE: UDateFormatSymbolType = UDateFormatSymbolType(25i32);
pub const UDAT_ZODIAC_NAMES_ABBREVIATED: UDateFormatSymbolType = UDateFormatSymbolType(26i32);
pub const UDAT_ZODIAC_NAMES_NARROW: UDateFormatSymbolType = UDateFormatSymbolType(27i32);
impl ::std::convert::From<i32> for UDateFormatSymbolType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateFormatSymbolType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UDateFormatSymbols(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UDateIntervalFormat(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateRelativeDateTimeFormatterStyle(pub i32);
pub const UDAT_STYLE_LONG: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(0i32);
pub const UDAT_STYLE_SHORT: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(1i32);
pub const UDAT_STYLE_NARROW: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(2i32);
impl ::std::convert::From<i32> for UDateRelativeDateTimeFormatterStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateRelativeDateTimeFormatterStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateRelativeUnit(pub i32);
pub const UDAT_RELATIVE_SECONDS: UDateRelativeUnit = UDateRelativeUnit(0i32);
pub const UDAT_RELATIVE_MINUTES: UDateRelativeUnit = UDateRelativeUnit(1i32);
pub const UDAT_RELATIVE_HOURS: UDateRelativeUnit = UDateRelativeUnit(2i32);
pub const UDAT_RELATIVE_DAYS: UDateRelativeUnit = UDateRelativeUnit(3i32);
pub const UDAT_RELATIVE_WEEKS: UDateRelativeUnit = UDateRelativeUnit(4i32);
pub const UDAT_RELATIVE_MONTHS: UDateRelativeUnit = UDateRelativeUnit(5i32);
pub const UDAT_RELATIVE_YEARS: UDateRelativeUnit = UDateRelativeUnit(6i32);
pub const UDAT_RELATIVE_UNIT_COUNT: UDateRelativeUnit = UDateRelativeUnit(7i32);
impl ::std::convert::From<i32> for UDateRelativeUnit {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateRelativeUnit {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateTimePGDisplayWidth(pub i32);
pub const UDATPG_WIDE: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(0i32);
pub const UDATPG_ABBREVIATED: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(1i32);
pub const UDATPG_NARROW: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(2i32);
impl ::std::convert::From<i32> for UDateTimePGDisplayWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateTimePGDisplayWidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateTimePatternConflict(pub i32);
pub const UDATPG_NO_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(0i32);
pub const UDATPG_BASE_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(1i32);
pub const UDATPG_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(2i32);
impl ::std::convert::From<i32> for UDateTimePatternConflict {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateTimePatternConflict {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateTimePatternField(pub i32);
pub const UDATPG_ERA_FIELD: UDateTimePatternField = UDateTimePatternField(0i32);
pub const UDATPG_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(1i32);
pub const UDATPG_QUARTER_FIELD: UDateTimePatternField = UDateTimePatternField(2i32);
pub const UDATPG_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(3i32);
pub const UDATPG_WEEK_OF_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(4i32);
pub const UDATPG_WEEK_OF_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(5i32);
pub const UDATPG_WEEKDAY_FIELD: UDateTimePatternField = UDateTimePatternField(6i32);
pub const UDATPG_DAY_OF_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(7i32);
pub const UDATPG_DAY_OF_WEEK_IN_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(8i32);
pub const UDATPG_DAY_FIELD: UDateTimePatternField = UDateTimePatternField(9i32);
pub const UDATPG_DAYPERIOD_FIELD: UDateTimePatternField = UDateTimePatternField(10i32);
pub const UDATPG_HOUR_FIELD: UDateTimePatternField = UDateTimePatternField(11i32);
pub const UDATPG_MINUTE_FIELD: UDateTimePatternField = UDateTimePatternField(12i32);
pub const UDATPG_SECOND_FIELD: UDateTimePatternField = UDateTimePatternField(13i32);
pub const UDATPG_FRACTIONAL_SECOND_FIELD: UDateTimePatternField = UDateTimePatternField(14i32);
pub const UDATPG_ZONE_FIELD: UDateTimePatternField = UDateTimePatternField(15i32);
pub const UDATPG_FIELD_COUNT: UDateTimePatternField = UDateTimePatternField(16i32);
impl ::std::convert::From<i32> for UDateTimePatternField {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateTimePatternField {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateTimePatternMatchOptions(pub i32);
pub const UDATPG_MATCH_NO_OPTIONS: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(0i32);
pub const UDATPG_MATCH_HOUR_FIELD_LENGTH: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(2048i32);
pub const UDATPG_MATCH_ALL_FIELDS_LENGTH: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(65535i32);
impl ::std::convert::From<i32> for UDateTimePatternMatchOptions {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateTimePatternMatchOptions {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDateTimeScale(pub i32);
pub const UDTS_JAVA_TIME: UDateTimeScale = UDateTimeScale(0i32);
pub const UDTS_UNIX_TIME: UDateTimeScale = UDateTimeScale(1i32);
pub const UDTS_ICU4C_TIME: UDateTimeScale = UDateTimeScale(2i32);
pub const UDTS_WINDOWS_FILE_TIME: UDateTimeScale = UDateTimeScale(3i32);
pub const UDTS_DOTNET_DATE_TIME: UDateTimeScale = UDateTimeScale(4i32);
pub const UDTS_MAC_OLD_TIME: UDateTimeScale = UDateTimeScale(5i32);
pub const UDTS_MAC_TIME: UDateTimeScale = UDateTimeScale(6i32);
pub const UDTS_EXCEL_TIME: UDateTimeScale = UDateTimeScale(7i32);
pub const UDTS_DB2_TIME: UDateTimeScale = UDateTimeScale(8i32);
pub const UDTS_UNIX_MICROSECONDS_TIME: UDateTimeScale = UDateTimeScale(9i32);
impl ::std::convert::From<i32> for UDateTimeScale {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDateTimeScale {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDecompositionType(pub i32);
pub const U_DT_NONE: UDecompositionType = UDecompositionType(0i32);
pub const U_DT_CANONICAL: UDecompositionType = UDecompositionType(1i32);
pub const U_DT_COMPAT: UDecompositionType = UDecompositionType(2i32);
pub const U_DT_CIRCLE: UDecompositionType = UDecompositionType(3i32);
pub const U_DT_FINAL: UDecompositionType = UDecompositionType(4i32);
pub const U_DT_FONT: UDecompositionType = UDecompositionType(5i32);
pub const U_DT_FRACTION: UDecompositionType = UDecompositionType(6i32);
pub const U_DT_INITIAL: UDecompositionType = UDecompositionType(7i32);
pub const U_DT_ISOLATED: UDecompositionType = UDecompositionType(8i32);
pub const U_DT_MEDIAL: UDecompositionType = UDecompositionType(9i32);
pub const U_DT_NARROW: UDecompositionType = UDecompositionType(10i32);
pub const U_DT_NOBREAK: UDecompositionType = UDecompositionType(11i32);
pub const U_DT_SMALL: UDecompositionType = UDecompositionType(12i32);
pub const U_DT_SQUARE: UDecompositionType = UDecompositionType(13i32);
pub const U_DT_SUB: UDecompositionType = UDecompositionType(14i32);
pub const U_DT_SUPER: UDecompositionType = UDecompositionType(15i32);
pub const U_DT_VERTICAL: UDecompositionType = UDecompositionType(16i32);
pub const U_DT_WIDE: UDecompositionType = UDecompositionType(17i32);
impl ::std::convert::From<i32> for UDecompositionType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDecompositionType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDialectHandling(pub i32);
pub const ULDN_STANDARD_NAMES: UDialectHandling = UDialectHandling(0i32);
pub const ULDN_DIALECT_NAMES: UDialectHandling = UDialectHandling(1i32);
impl ::std::convert::From<i32> for UDialectHandling {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDialectHandling {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDisplayContext(pub i32);
pub const UDISPCTX_STANDARD_NAMES: UDisplayContext = UDisplayContext(0i32);
pub const UDISPCTX_DIALECT_NAMES: UDisplayContext = UDisplayContext(1i32);
pub const UDISPCTX_CAPITALIZATION_NONE: UDisplayContext = UDisplayContext(256i32);
pub const UDISPCTX_CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE: UDisplayContext = UDisplayContext(257i32);
pub const UDISPCTX_CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE: UDisplayContext = UDisplayContext(258i32);
pub const UDISPCTX_CAPITALIZATION_FOR_UI_LIST_OR_MENU: UDisplayContext = UDisplayContext(259i32);
pub const UDISPCTX_CAPITALIZATION_FOR_STANDALONE: UDisplayContext = UDisplayContext(260i32);
pub const UDISPCTX_LENGTH_FULL: UDisplayContext = UDisplayContext(512i32);
pub const UDISPCTX_LENGTH_SHORT: UDisplayContext = UDisplayContext(513i32);
pub const UDISPCTX_SUBSTITUTE: UDisplayContext = UDisplayContext(768i32);
pub const UDISPCTX_NO_SUBSTITUTE: UDisplayContext = UDisplayContext(769i32);
impl ::std::convert::From<i32> for UDisplayContext {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDisplayContext {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UDisplayContextType(pub i32);
pub const UDISPCTX_TYPE_DIALECT_HANDLING: UDisplayContextType = UDisplayContextType(0i32);
pub const UDISPCTX_TYPE_CAPITALIZATION: UDisplayContextType = UDisplayContextType(1i32);
pub const UDISPCTX_TYPE_DISPLAY_LENGTH: UDisplayContextType = UDisplayContextType(2i32);
pub const UDISPCTX_TYPE_SUBSTITUTE_HANDLING: UDisplayContextType = UDisplayContextType(3i32);
impl ::std::convert::From<i32> for UDisplayContextType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UDisplayContextType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UEastAsianWidth(pub i32);
pub const U_EA_NEUTRAL: UEastAsianWidth = UEastAsianWidth(0i32);
pub const U_EA_AMBIGUOUS: UEastAsianWidth = UEastAsianWidth(1i32);
pub const U_EA_HALFWIDTH: UEastAsianWidth = UEastAsianWidth(2i32);
pub const U_EA_FULLWIDTH: UEastAsianWidth = UEastAsianWidth(3i32);
pub const U_EA_NARROW: UEastAsianWidth = UEastAsianWidth(4i32);
pub const U_EA_WIDE: UEastAsianWidth = UEastAsianWidth(5i32);
impl ::std::convert::From<i32> for UEastAsianWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UEastAsianWidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UEnumCharNamesFn = unsafe extern "system" fn(context: *mut ::std::ffi::c_void, code: i32, namechoice: UCharNameChoice, name: super::Foundation::PSTR, length: i32) -> i8;
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UEnumeration(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UErrorCode(pub i32);
pub const U_USING_FALLBACK_WARNING: UErrorCode = UErrorCode(-128i32);
pub const U_ERROR_WARNING_START: UErrorCode = UErrorCode(-128i32);
pub const U_USING_DEFAULT_WARNING: UErrorCode = UErrorCode(-127i32);
pub const U_SAFECLONE_ALLOCATED_WARNING: UErrorCode = UErrorCode(-126i32);
pub const U_STATE_OLD_WARNING: UErrorCode = UErrorCode(-125i32);
pub const U_STRING_NOT_TERMINATED_WARNING: UErrorCode = UErrorCode(-124i32);
pub const U_SORT_KEY_TOO_SHORT_WARNING: UErrorCode = UErrorCode(-123i32);
pub const U_AMBIGUOUS_ALIAS_WARNING: UErrorCode = UErrorCode(-122i32);
pub const U_DIFFERENT_UCA_VERSION: UErrorCode = UErrorCode(-121i32);
pub const U_PLUGIN_CHANGED_LEVEL_WARNING: UErrorCode = UErrorCode(-120i32);
pub const U_ZERO_ERROR: UErrorCode = UErrorCode(0i32);
pub const U_ILLEGAL_ARGUMENT_ERROR: UErrorCode = UErrorCode(1i32);
pub const U_MISSING_RESOURCE_ERROR: UErrorCode = UErrorCode(2i32);
pub const U_INVALID_FORMAT_ERROR: UErrorCode = UErrorCode(3i32);
pub const U_FILE_ACCESS_ERROR: UErrorCode = UErrorCode(4i32);
pub const U_INTERNAL_PROGRAM_ERROR: UErrorCode = UErrorCode(5i32);
pub const U_MESSAGE_PARSE_ERROR: UErrorCode = UErrorCode(6i32);
pub const U_MEMORY_ALLOCATION_ERROR: UErrorCode = UErrorCode(7i32);
pub const U_INDEX_OUTOFBOUNDS_ERROR: UErrorCode = UErrorCode(8i32);
pub const U_PARSE_ERROR: UErrorCode = UErrorCode(9i32);
pub const U_INVALID_CHAR_FOUND: UErrorCode = UErrorCode(10i32);
pub const U_TRUNCATED_CHAR_FOUND: UErrorCode = UErrorCode(11i32);
pub const U_ILLEGAL_CHAR_FOUND: UErrorCode = UErrorCode(12i32);
pub const U_INVALID_TABLE_FORMAT: UErrorCode = UErrorCode(13i32);
pub const U_INVALID_TABLE_FILE: UErrorCode = UErrorCode(14i32);
pub const U_BUFFER_OVERFLOW_ERROR: UErrorCode = UErrorCode(15i32);
pub const U_UNSUPPORTED_ERROR: UErrorCode = UErrorCode(16i32);
pub const U_RESOURCE_TYPE_MISMATCH: UErrorCode = UErrorCode(17i32);
pub const U_ILLEGAL_ESCAPE_SEQUENCE: UErrorCode = UErrorCode(18i32);
pub const U_UNSUPPORTED_ESCAPE_SEQUENCE: UErrorCode = UErrorCode(19i32);
pub const U_NO_SPACE_AVAILABLE: UErrorCode = UErrorCode(20i32);
pub const U_CE_NOT_FOUND_ERROR: UErrorCode = UErrorCode(21i32);
pub const U_PRIMARY_TOO_LONG_ERROR: UErrorCode = UErrorCode(22i32);
pub const U_STATE_TOO_OLD_ERROR: UErrorCode = UErrorCode(23i32);
pub const U_TOO_MANY_ALIASES_ERROR: UErrorCode = UErrorCode(24i32);
pub const U_ENUM_OUT_OF_SYNC_ERROR: UErrorCode = UErrorCode(25i32);
pub const U_INVARIANT_CONVERSION_ERROR: UErrorCode = UErrorCode(26i32);
pub const U_INVALID_STATE_ERROR: UErrorCode = UErrorCode(27i32);
pub const U_COLLATOR_VERSION_MISMATCH: UErrorCode = UErrorCode(28i32);
pub const U_USELESS_COLLATOR_ERROR: UErrorCode = UErrorCode(29i32);
pub const U_NO_WRITE_PERMISSION: UErrorCode = UErrorCode(30i32);
pub const U_BAD_VARIABLE_DEFINITION: UErrorCode = UErrorCode(65536i32);
pub const U_PARSE_ERROR_START: UErrorCode = UErrorCode(65536i32);
pub const U_MALFORMED_RULE: UErrorCode = UErrorCode(65537i32);
pub const U_MALFORMED_SET: UErrorCode = UErrorCode(65538i32);
pub const U_MALFORMED_SYMBOL_REFERENCE: UErrorCode = UErrorCode(65539i32);
pub const U_MALFORMED_UNICODE_ESCAPE: UErrorCode = UErrorCode(65540i32);
pub const U_MALFORMED_VARIABLE_DEFINITION: UErrorCode = UErrorCode(65541i32);
pub const U_MALFORMED_VARIABLE_REFERENCE: UErrorCode = UErrorCode(65542i32);
pub const U_MISMATCHED_SEGMENT_DELIMITERS: UErrorCode = UErrorCode(65543i32);
pub const U_MISPLACED_ANCHOR_START: UErrorCode = UErrorCode(65544i32);
pub const U_MISPLACED_CURSOR_OFFSET: UErrorCode = UErrorCode(65545i32);
pub const U_MISPLACED_QUANTIFIER: UErrorCode = UErrorCode(65546i32);
pub const U_MISSING_OPERATOR: UErrorCode = UErrorCode(65547i32);
pub const U_MISSING_SEGMENT_CLOSE: UErrorCode = UErrorCode(65548i32);
pub const U_MULTIPLE_ANTE_CONTEXTS: UErrorCode = UErrorCode(65549i32);
pub const U_MULTIPLE_CURSORS: UErrorCode = UErrorCode(65550i32);
pub const U_MULTIPLE_POST_CONTEXTS: UErrorCode = UErrorCode(65551i32);
pub const U_TRAILING_BACKSLASH: UErrorCode = UErrorCode(65552i32);
pub const U_UNDEFINED_SEGMENT_REFERENCE: UErrorCode = UErrorCode(65553i32);
pub const U_UNDEFINED_VARIABLE: UErrorCode = UErrorCode(65554i32);
pub const U_UNQUOTED_SPECIAL: UErrorCode = UErrorCode(65555i32);
pub const U_UNTERMINATED_QUOTE: UErrorCode = UErrorCode(65556i32);
pub const U_RULE_MASK_ERROR: UErrorCode = UErrorCode(65557i32);
pub const U_MISPLACED_COMPOUND_FILTER: UErrorCode = UErrorCode(65558i32);
pub const U_MULTIPLE_COMPOUND_FILTERS: UErrorCode = UErrorCode(65559i32);
pub const U_INVALID_RBT_SYNTAX: UErrorCode = UErrorCode(65560i32);
pub const U_INVALID_PROPERTY_PATTERN: UErrorCode = UErrorCode(65561i32);
pub const U_MALFORMED_PRAGMA: UErrorCode = UErrorCode(65562i32);
pub const U_UNCLOSED_SEGMENT: UErrorCode = UErrorCode(65563i32);
pub const U_ILLEGAL_CHAR_IN_SEGMENT: UErrorCode = UErrorCode(65564i32);
pub const U_VARIABLE_RANGE_EXHAUSTED: UErrorCode = UErrorCode(65565i32);
pub const U_VARIABLE_RANGE_OVERLAP: UErrorCode = UErrorCode(65566i32);
pub const U_ILLEGAL_CHARACTER: UErrorCode = UErrorCode(65567i32);
pub const U_INTERNAL_TRANSLITERATOR_ERROR: UErrorCode = UErrorCode(65568i32);
pub const U_INVALID_ID: UErrorCode = UErrorCode(65569i32);
pub const U_INVALID_FUNCTION: UErrorCode = UErrorCode(65570i32);
pub const U_UNEXPECTED_TOKEN: UErrorCode = UErrorCode(65792i32);
pub const U_FMT_PARSE_ERROR_START: UErrorCode = UErrorCode(65792i32);
pub const U_MULTIPLE_DECIMAL_SEPARATORS: UErrorCode = UErrorCode(65793i32);
pub const U_MULTIPLE_DECIMAL_SEPERATORS: UErrorCode = UErrorCode(65793i32);
pub const U_MULTIPLE_EXPONENTIAL_SYMBOLS: UErrorCode = UErrorCode(65794i32);
pub const U_MALFORMED_EXPONENTIAL_PATTERN: UErrorCode = UErrorCode(65795i32);
pub const U_MULTIPLE_PERCENT_SYMBOLS: UErrorCode = UErrorCode(65796i32);
pub const U_MULTIPLE_PERMILL_SYMBOLS: UErrorCode = UErrorCode(65797i32);
pub const U_MULTIPLE_PAD_SPECIFIERS: UErrorCode = UErrorCode(65798i32);
pub const U_PATTERN_SYNTAX_ERROR: UErrorCode = UErrorCode(65799i32);
pub const U_ILLEGAL_PAD_POSITION: UErrorCode = UErrorCode(65800i32);
pub const U_UNMATCHED_BRACES: UErrorCode = UErrorCode(65801i32);
pub const U_UNSUPPORTED_PROPERTY: UErrorCode = UErrorCode(65802i32);
pub const U_UNSUPPORTED_ATTRIBUTE: UErrorCode = UErrorCode(65803i32);
pub const U_ARGUMENT_TYPE_MISMATCH: UErrorCode = UErrorCode(65804i32);
pub const U_DUPLICATE_KEYWORD: UErrorCode = UErrorCode(65805i32);
pub const U_UNDEFINED_KEYWORD: UErrorCode = UErrorCode(65806i32);
pub const U_DEFAULT_KEYWORD_MISSING: UErrorCode = UErrorCode(65807i32);
pub const U_DECIMAL_NUMBER_SYNTAX_ERROR: UErrorCode = UErrorCode(65808i32);
pub const U_FORMAT_INEXACT_ERROR: UErrorCode = UErrorCode(65809i32);
pub const U_NUMBER_ARG_OUTOFBOUNDS_ERROR: UErrorCode = UErrorCode(65810i32);
pub const U_NUMBER_SKELETON_SYNTAX_ERROR: UErrorCode = UErrorCode(65811i32);
pub const U_BRK_INTERNAL_ERROR: UErrorCode = UErrorCode(66048i32);
pub const U_BRK_ERROR_START: UErrorCode = UErrorCode(66048i32);
pub const U_BRK_HEX_DIGITS_EXPECTED: UErrorCode = UErrorCode(66049i32);
pub const U_BRK_SEMICOLON_EXPECTED: UErrorCode = UErrorCode(66050i32);
pub const U_BRK_RULE_SYNTAX: UErrorCode = UErrorCode(66051i32);
pub const U_BRK_UNCLOSED_SET: UErrorCode = UErrorCode(66052i32);
pub const U_BRK_ASSIGN_ERROR: UErrorCode = UErrorCode(66053i32);
pub const U_BRK_VARIABLE_REDFINITION: UErrorCode = UErrorCode(66054i32);
pub const U_BRK_MISMATCHED_PAREN: UErrorCode = UErrorCode(66055i32);
pub const U_BRK_NEW_LINE_IN_QUOTED_STRING: UErrorCode = UErrorCode(66056i32);
pub const U_BRK_UNDEFINED_VARIABLE: UErrorCode = UErrorCode(66057i32);
pub const U_BRK_INIT_ERROR: UErrorCode = UErrorCode(66058i32);
pub const U_BRK_RULE_EMPTY_SET: UErrorCode = UErrorCode(66059i32);
pub const U_BRK_UNRECOGNIZED_OPTION: UErrorCode = UErrorCode(66060i32);
pub const U_BRK_MALFORMED_RULE_TAG: UErrorCode = UErrorCode(66061i32);
pub const U_REGEX_INTERNAL_ERROR: UErrorCode = UErrorCode(66304i32);
pub const U_REGEX_ERROR_START: UErrorCode = UErrorCode(66304i32);
pub const U_REGEX_RULE_SYNTAX: UErrorCode = UErrorCode(66305i32);
pub const U_REGEX_INVALID_STATE: UErrorCode = UErrorCode(66306i32);
pub const U_REGEX_BAD_ESCAPE_SEQUENCE: UErrorCode = UErrorCode(66307i32);
pub const U_REGEX_PROPERTY_SYNTAX: UErrorCode = UErrorCode(66308i32);
pub const U_REGEX_UNIMPLEMENTED: UErrorCode = UErrorCode(66309i32);
pub const U_REGEX_MISMATCHED_PAREN: UErrorCode = UErrorCode(66310i32);
pub const U_REGEX_NUMBER_TOO_BIG: UErrorCode = UErrorCode(66311i32);
pub const U_REGEX_BAD_INTERVAL: UErrorCode = UErrorCode(66312i32);
pub const U_REGEX_MAX_LT_MIN: UErrorCode = UErrorCode(66313i32);
pub const U_REGEX_INVALID_BACK_REF: UErrorCode = UErrorCode(66314i32);
pub const U_REGEX_INVALID_FLAG: UErrorCode = UErrorCode(66315i32);
pub const U_REGEX_LOOK_BEHIND_LIMIT: UErrorCode = UErrorCode(66316i32);
pub const U_REGEX_SET_CONTAINS_STRING: UErrorCode = UErrorCode(66317i32);
pub const U_REGEX_MISSING_CLOSE_BRACKET: UErrorCode = UErrorCode(66319i32);
pub const U_REGEX_INVALID_RANGE: UErrorCode = UErrorCode(66320i32);
pub const U_REGEX_STACK_OVERFLOW: UErrorCode = UErrorCode(66321i32);
pub const U_REGEX_TIME_OUT: UErrorCode = UErrorCode(66322i32);
pub const U_REGEX_STOPPED_BY_CALLER: UErrorCode = UErrorCode(66323i32);
pub const U_REGEX_PATTERN_TOO_BIG: UErrorCode = UErrorCode(66324i32);
pub const U_REGEX_INVALID_CAPTURE_GROUP_NAME: UErrorCode = UErrorCode(66325i32);
pub const U_IDNA_PROHIBITED_ERROR: UErrorCode = UErrorCode(66560i32);
pub const U_IDNA_ERROR_START: UErrorCode = UErrorCode(66560i32);
pub const U_IDNA_UNASSIGNED_ERROR: UErrorCode = UErrorCode(66561i32);
pub const U_IDNA_CHECK_BIDI_ERROR: UErrorCode = UErrorCode(66562i32);
pub const U_IDNA_STD3_ASCII_RULES_ERROR: UErrorCode = UErrorCode(66563i32);
pub const U_IDNA_ACE_PREFIX_ERROR: UErrorCode = UErrorCode(66564i32);
pub const U_IDNA_VERIFICATION_ERROR: UErrorCode = UErrorCode(66565i32);
pub const U_IDNA_LABEL_TOO_LONG_ERROR: UErrorCode = UErrorCode(66566i32);
pub const U_IDNA_ZERO_LENGTH_LABEL_ERROR: UErrorCode = UErrorCode(66567i32);
pub const U_IDNA_DOMAIN_NAME_TOO_LONG_ERROR: UErrorCode = UErrorCode(66568i32);
pub const U_STRINGPREP_PROHIBITED_ERROR: UErrorCode = UErrorCode(66560i32);
pub const U_STRINGPREP_UNASSIGNED_ERROR: UErrorCode = UErrorCode(66561i32);
pub const U_STRINGPREP_CHECK_BIDI_ERROR: UErrorCode = UErrorCode(66562i32);
pub const U_PLUGIN_ERROR_START: UErrorCode = UErrorCode(66816i32);
pub const U_PLUGIN_TOO_HIGH: UErrorCode = UErrorCode(66816i32);
pub const U_PLUGIN_DIDNT_SET_LEVEL: UErrorCode = UErrorCode(66817i32);
impl ::std::convert::From<i32> for UErrorCode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UErrorCode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UFieldCategory(pub i32);
pub const UFIELD_CATEGORY_UNDEFINED: UFieldCategory = UFieldCategory(0i32);
pub const UFIELD_CATEGORY_DATE: UFieldCategory = UFieldCategory(1i32);
pub const UFIELD_CATEGORY_NUMBER: UFieldCategory = UFieldCategory(2i32);
pub const UFIELD_CATEGORY_LIST: UFieldCategory = UFieldCategory(3i32);
pub const UFIELD_CATEGORY_RELATIVE_DATETIME: UFieldCategory = UFieldCategory(4i32);
pub const UFIELD_CATEGORY_DATE_INTERVAL: UFieldCategory = UFieldCategory(5i32);
pub const UFIELD_CATEGORY_LIST_SPAN: UFieldCategory = UFieldCategory(4099i32);
pub const UFIELD_CATEGORY_DATE_INTERVAL_SPAN: UFieldCategory = UFieldCategory(4101i32);
impl ::std::convert::From<i32> for UFieldCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UFieldCategory {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UFieldPosition {
    pub field: i32,
    pub beginIndex: i32,
    pub endIndex: i32,
}
impl UFieldPosition {}
impl ::std::default::Default for UFieldPosition {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UFieldPosition {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UFieldPosition").field("field", &self.field).field("beginIndex", &self.beginIndex).field("endIndex", &self.endIndex).finish()
    }
}
impl ::std::cmp::PartialEq for UFieldPosition {
    fn eq(&self, other: &Self) -> bool {
        self.field == other.field && self.beginIndex == other.beginIndex && self.endIndex == other.endIndex
    }
}
impl ::std::cmp::Eq for UFieldPosition {}
unsafe impl ::windows::runtime::Abi for UFieldPosition {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFieldPositionIterator(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UFormattableType(pub i32);
pub const UFMT_DATE: UFormattableType = UFormattableType(0i32);
pub const UFMT_DOUBLE: UFormattableType = UFormattableType(1i32);
pub const UFMT_LONG: UFormattableType = UFormattableType(2i32);
pub const UFMT_STRING: UFormattableType = UFormattableType(3i32);
pub const UFMT_ARRAY: UFormattableType = UFormattableType(4i32);
pub const UFMT_INT64: UFormattableType = UFormattableType(5i32);
pub const UFMT_OBJECT: UFormattableType = UFormattableType(6i32);
impl ::std::convert::From<i32> for UFormattableType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UFormattableType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedDateInterval(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedList(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedNumber(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedNumberRange(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedRelativeDateTime(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UFormattedValue(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UGender(pub i32);
pub const UGENDER_MALE: UGender = UGender(0i32);
pub const UGENDER_FEMALE: UGender = UGender(1i32);
pub const UGENDER_OTHER: UGender = UGender(2i32);
impl ::std::convert::From<i32> for UGender {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UGender {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UGenderInfo(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UGraphemeClusterBreak(pub i32);
pub const U_GCB_OTHER: UGraphemeClusterBreak = UGraphemeClusterBreak(0i32);
pub const U_GCB_CONTROL: UGraphemeClusterBreak = UGraphemeClusterBreak(1i32);
pub const U_GCB_CR: UGraphemeClusterBreak = UGraphemeClusterBreak(2i32);
pub const U_GCB_EXTEND: UGraphemeClusterBreak = UGraphemeClusterBreak(3i32);
pub const U_GCB_L: UGraphemeClusterBreak = UGraphemeClusterBreak(4i32);
pub const U_GCB_LF: UGraphemeClusterBreak = UGraphemeClusterBreak(5i32);
pub const U_GCB_LV: UGraphemeClusterBreak = UGraphemeClusterBreak(6i32);
pub const U_GCB_LVT: UGraphemeClusterBreak = UGraphemeClusterBreak(7i32);
pub const U_GCB_T: UGraphemeClusterBreak = UGraphemeClusterBreak(8i32);
pub const U_GCB_V: UGraphemeClusterBreak = UGraphemeClusterBreak(9i32);
pub const U_GCB_SPACING_MARK: UGraphemeClusterBreak = UGraphemeClusterBreak(10i32);
pub const U_GCB_PREPEND: UGraphemeClusterBreak = UGraphemeClusterBreak(11i32);
pub const U_GCB_REGIONAL_INDICATOR: UGraphemeClusterBreak = UGraphemeClusterBreak(12i32);
pub const U_GCB_E_BASE: UGraphemeClusterBreak = UGraphemeClusterBreak(13i32);
pub const U_GCB_E_BASE_GAZ: UGraphemeClusterBreak = UGraphemeClusterBreak(14i32);
pub const U_GCB_E_MODIFIER: UGraphemeClusterBreak = UGraphemeClusterBreak(15i32);
pub const U_GCB_GLUE_AFTER_ZWJ: UGraphemeClusterBreak = UGraphemeClusterBreak(16i32);
pub const U_GCB_ZWJ: UGraphemeClusterBreak = UGraphemeClusterBreak(17i32);
impl ::std::convert::From<i32> for UGraphemeClusterBreak {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UGraphemeClusterBreak {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UHangulSyllableType(pub i32);
pub const U_HST_NOT_APPLICABLE: UHangulSyllableType = UHangulSyllableType(0i32);
pub const U_HST_LEADING_JAMO: UHangulSyllableType = UHangulSyllableType(1i32);
pub const U_HST_VOWEL_JAMO: UHangulSyllableType = UHangulSyllableType(2i32);
pub const U_HST_TRAILING_JAMO: UHangulSyllableType = UHangulSyllableType(3i32);
pub const U_HST_LV_SYLLABLE: UHangulSyllableType = UHangulSyllableType(4i32);
pub const U_HST_LVT_SYLLABLE: UHangulSyllableType = UHangulSyllableType(5i32);
impl ::std::convert::From<i32> for UHangulSyllableType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UHangulSyllableType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UHashtable(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UIDNA(pub u8);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UIDNAInfo {
    pub size: i16,
    pub isTransitionalDifferent: i8,
    pub reservedB3: i8,
    pub errors: u32,
    pub reservedI2: i32,
    pub reservedI3: i32,
}
impl UIDNAInfo {}
impl ::std::default::Default for UIDNAInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UIDNAInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UIDNAInfo").field("size", &self.size).field("isTransitionalDifferent", &self.isTransitionalDifferent).field("reservedB3", &self.reservedB3).field("errors", &self.errors).field("reservedI2", &self.reservedI2).field("reservedI3", &self.reservedI3).finish()
    }
}
impl ::std::cmp::PartialEq for UIDNAInfo {
    fn eq(&self, other: &Self) -> bool {
        self.size == other.size && self.isTransitionalDifferent == other.isTransitionalDifferent && self.reservedB3 == other.reservedB3 && self.errors == other.errors && self.reservedI2 == other.reservedI2 && self.reservedI3 == other.reservedI3
    }
}
impl ::std::cmp::Eq for UIDNAInfo {}
unsafe impl ::windows::runtime::Abi for UIDNAInfo {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_CHECK_BIDI: i32 = 4i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_CHECK_CONTEXTJ: i32 = 8i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_CHECK_CONTEXTO: i32 = 64i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_DEFAULT: i32 = 0i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_BIDI: i32 = 2048i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_CONTEXTJ: i32 = 4096i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_CONTEXTO_DIGITS: i32 = 16384i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_CONTEXTO_PUNCTUATION: i32 = 8192i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_DISALLOWED: i32 = 128i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_DOMAIN_NAME_TOO_LONG: i32 = 4i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_EMPTY_LABEL: i32 = 1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_HYPHEN_3_4: i32 = 32i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_INVALID_ACE_LABEL: i32 = 1024i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_LABEL_HAS_DOT: i32 = 512i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_LABEL_TOO_LONG: i32 = 2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_LEADING_COMBINING_MARK: i32 = 64i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_LEADING_HYPHEN: i32 = 8i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_PUNYCODE: i32 = 256i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_ERROR_TRAILING_HYPHEN: i32 = 16i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_NONTRANSITIONAL_TO_ASCII: i32 = 16i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_NONTRANSITIONAL_TO_UNICODE: i32 = 32i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UIDNA_USE_STD3_RULES: i32 = 2i32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UILANGUAGE_ENUMPROCA = unsafe extern "system" fn(param0: super::Foundation::PSTR, param1: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UILANGUAGE_ENUMPROCW = unsafe extern "system" fn(param0: super::Foundation::PWSTR, param1: isize) -> super::Foundation::BOOL;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UITER_UNKNOWN_INDEX: i32 = -2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UIndicPositionalCategory(pub i32);
pub const U_INPC_NA: UIndicPositionalCategory = UIndicPositionalCategory(0i32);
pub const U_INPC_BOTTOM: UIndicPositionalCategory = UIndicPositionalCategory(1i32);
pub const U_INPC_BOTTOM_AND_LEFT: UIndicPositionalCategory = UIndicPositionalCategory(2i32);
pub const U_INPC_BOTTOM_AND_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(3i32);
pub const U_INPC_LEFT: UIndicPositionalCategory = UIndicPositionalCategory(4i32);
pub const U_INPC_LEFT_AND_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(5i32);
pub const U_INPC_OVERSTRUCK: UIndicPositionalCategory = UIndicPositionalCategory(6i32);
pub const U_INPC_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(7i32);
pub const U_INPC_TOP: UIndicPositionalCategory = UIndicPositionalCategory(8i32);
pub const U_INPC_TOP_AND_BOTTOM: UIndicPositionalCategory = UIndicPositionalCategory(9i32);
pub const U_INPC_TOP_AND_BOTTOM_AND_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(10i32);
pub const U_INPC_TOP_AND_LEFT: UIndicPositionalCategory = UIndicPositionalCategory(11i32);
pub const U_INPC_TOP_AND_LEFT_AND_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(12i32);
pub const U_INPC_TOP_AND_RIGHT: UIndicPositionalCategory = UIndicPositionalCategory(13i32);
pub const U_INPC_VISUAL_ORDER_LEFT: UIndicPositionalCategory = UIndicPositionalCategory(14i32);
pub const U_INPC_TOP_AND_BOTTOM_AND_LEFT: UIndicPositionalCategory = UIndicPositionalCategory(15i32);
impl ::std::convert::From<i32> for UIndicPositionalCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UIndicPositionalCategory {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UIndicSyllabicCategory(pub i32);
pub const U_INSC_OTHER: UIndicSyllabicCategory = UIndicSyllabicCategory(0i32);
pub const U_INSC_AVAGRAHA: UIndicSyllabicCategory = UIndicSyllabicCategory(1i32);
pub const U_INSC_BINDU: UIndicSyllabicCategory = UIndicSyllabicCategory(2i32);
pub const U_INSC_BRAHMI_JOINING_NUMBER: UIndicSyllabicCategory = UIndicSyllabicCategory(3i32);
pub const U_INSC_CANTILLATION_MARK: UIndicSyllabicCategory = UIndicSyllabicCategory(4i32);
pub const U_INSC_CONSONANT: UIndicSyllabicCategory = UIndicSyllabicCategory(5i32);
pub const U_INSC_CONSONANT_DEAD: UIndicSyllabicCategory = UIndicSyllabicCategory(6i32);
pub const U_INSC_CONSONANT_FINAL: UIndicSyllabicCategory = UIndicSyllabicCategory(7i32);
pub const U_INSC_CONSONANT_HEAD_LETTER: UIndicSyllabicCategory = UIndicSyllabicCategory(8i32);
pub const U_INSC_CONSONANT_INITIAL_POSTFIXED: UIndicSyllabicCategory = UIndicSyllabicCategory(9i32);
pub const U_INSC_CONSONANT_KILLER: UIndicSyllabicCategory = UIndicSyllabicCategory(10i32);
pub const U_INSC_CONSONANT_MEDIAL: UIndicSyllabicCategory = UIndicSyllabicCategory(11i32);
pub const U_INSC_CONSONANT_PLACEHOLDER: UIndicSyllabicCategory = UIndicSyllabicCategory(12i32);
pub const U_INSC_CONSONANT_PRECEDING_REPHA: UIndicSyllabicCategory = UIndicSyllabicCategory(13i32);
pub const U_INSC_CONSONANT_PREFIXED: UIndicSyllabicCategory = UIndicSyllabicCategory(14i32);
pub const U_INSC_CONSONANT_SUBJOINED: UIndicSyllabicCategory = UIndicSyllabicCategory(15i32);
pub const U_INSC_CONSONANT_SUCCEEDING_REPHA: UIndicSyllabicCategory = UIndicSyllabicCategory(16i32);
pub const U_INSC_CONSONANT_WITH_STACKER: UIndicSyllabicCategory = UIndicSyllabicCategory(17i32);
pub const U_INSC_GEMINATION_MARK: UIndicSyllabicCategory = UIndicSyllabicCategory(18i32);
pub const U_INSC_INVISIBLE_STACKER: UIndicSyllabicCategory = UIndicSyllabicCategory(19i32);
pub const U_INSC_JOINER: UIndicSyllabicCategory = UIndicSyllabicCategory(20i32);
pub const U_INSC_MODIFYING_LETTER: UIndicSyllabicCategory = UIndicSyllabicCategory(21i32);
pub const U_INSC_NON_JOINER: UIndicSyllabicCategory = UIndicSyllabicCategory(22i32);
pub const U_INSC_NUKTA: UIndicSyllabicCategory = UIndicSyllabicCategory(23i32);
pub const U_INSC_NUMBER: UIndicSyllabicCategory = UIndicSyllabicCategory(24i32);
pub const U_INSC_NUMBER_JOINER: UIndicSyllabicCategory = UIndicSyllabicCategory(25i32);
pub const U_INSC_PURE_KILLER: UIndicSyllabicCategory = UIndicSyllabicCategory(26i32);
pub const U_INSC_REGISTER_SHIFTER: UIndicSyllabicCategory = UIndicSyllabicCategory(27i32);
pub const U_INSC_SYLLABLE_MODIFIER: UIndicSyllabicCategory = UIndicSyllabicCategory(28i32);
pub const U_INSC_TONE_LETTER: UIndicSyllabicCategory = UIndicSyllabicCategory(29i32);
pub const U_INSC_TONE_MARK: UIndicSyllabicCategory = UIndicSyllabicCategory(30i32);
pub const U_INSC_VIRAMA: UIndicSyllabicCategory = UIndicSyllabicCategory(31i32);
pub const U_INSC_VISARGA: UIndicSyllabicCategory = UIndicSyllabicCategory(32i32);
pub const U_INSC_VOWEL: UIndicSyllabicCategory = UIndicSyllabicCategory(33i32);
pub const U_INSC_VOWEL_DEPENDENT: UIndicSyllabicCategory = UIndicSyllabicCategory(34i32);
pub const U_INSC_VOWEL_INDEPENDENT: UIndicSyllabicCategory = UIndicSyllabicCategory(35i32);
impl ::std::convert::From<i32> for UIndicSyllabicCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UIndicSyllabicCategory {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UJoiningGroup(pub i32);
pub const U_JG_NO_JOINING_GROUP: UJoiningGroup = UJoiningGroup(0i32);
pub const U_JG_AIN: UJoiningGroup = UJoiningGroup(1i32);
pub const U_JG_ALAPH: UJoiningGroup = UJoiningGroup(2i32);
pub const U_JG_ALEF: UJoiningGroup = UJoiningGroup(3i32);
pub const U_JG_BEH: UJoiningGroup = UJoiningGroup(4i32);
pub const U_JG_BETH: UJoiningGroup = UJoiningGroup(5i32);
pub const U_JG_DAL: UJoiningGroup = UJoiningGroup(6i32);
pub const U_JG_DALATH_RISH: UJoiningGroup = UJoiningGroup(7i32);
pub const U_JG_E: UJoiningGroup = UJoiningGroup(8i32);
pub const U_JG_FEH: UJoiningGroup = UJoiningGroup(9i32);
pub const U_JG_FINAL_SEMKATH: UJoiningGroup = UJoiningGroup(10i32);
pub const U_JG_GAF: UJoiningGroup = UJoiningGroup(11i32);
pub const U_JG_GAMAL: UJoiningGroup = UJoiningGroup(12i32);
pub const U_JG_HAH: UJoiningGroup = UJoiningGroup(13i32);
pub const U_JG_TEH_MARBUTA_GOAL: UJoiningGroup = UJoiningGroup(14i32);
pub const U_JG_HAMZA_ON_HEH_GOAL: UJoiningGroup = UJoiningGroup(14i32);
pub const U_JG_HE: UJoiningGroup = UJoiningGroup(15i32);
pub const U_JG_HEH: UJoiningGroup = UJoiningGroup(16i32);
pub const U_JG_HEH_GOAL: UJoiningGroup = UJoiningGroup(17i32);
pub const U_JG_HETH: UJoiningGroup = UJoiningGroup(18i32);
pub const U_JG_KAF: UJoiningGroup = UJoiningGroup(19i32);
pub const U_JG_KAPH: UJoiningGroup = UJoiningGroup(20i32);
pub const U_JG_KNOTTED_HEH: UJoiningGroup = UJoiningGroup(21i32);
pub const U_JG_LAM: UJoiningGroup = UJoiningGroup(22i32);
pub const U_JG_LAMADH: UJoiningGroup = UJoiningGroup(23i32);
pub const U_JG_MEEM: UJoiningGroup = UJoiningGroup(24i32);
pub const U_JG_MIM: UJoiningGroup = UJoiningGroup(25i32);
pub const U_JG_NOON: UJoiningGroup = UJoiningGroup(26i32);
pub const U_JG_NUN: UJoiningGroup = UJoiningGroup(27i32);
pub const U_JG_PE: UJoiningGroup = UJoiningGroup(28i32);
pub const U_JG_QAF: UJoiningGroup = UJoiningGroup(29i32);
pub const U_JG_QAPH: UJoiningGroup = UJoiningGroup(30i32);
pub const U_JG_REH: UJoiningGroup = UJoiningGroup(31i32);
pub const U_JG_REVERSED_PE: UJoiningGroup = UJoiningGroup(32i32);
pub const U_JG_SAD: UJoiningGroup = UJoiningGroup(33i32);
pub const U_JG_SADHE: UJoiningGroup = UJoiningGroup(34i32);
pub const U_JG_SEEN: UJoiningGroup = UJoiningGroup(35i32);
pub const U_JG_SEMKATH: UJoiningGroup = UJoiningGroup(36i32);
pub const U_JG_SHIN: UJoiningGroup = UJoiningGroup(37i32);
pub const U_JG_SWASH_KAF: UJoiningGroup = UJoiningGroup(38i32);
pub const U_JG_SYRIAC_WAW: UJoiningGroup = UJoiningGroup(39i32);
pub const U_JG_TAH: UJoiningGroup = UJoiningGroup(40i32);
pub const U_JG_TAW: UJoiningGroup = UJoiningGroup(41i32);
pub const U_JG_TEH_MARBUTA: UJoiningGroup = UJoiningGroup(42i32);
pub const U_JG_TETH: UJoiningGroup = UJoiningGroup(43i32);
pub const U_JG_WAW: UJoiningGroup = UJoiningGroup(44i32);
pub const U_JG_YEH: UJoiningGroup = UJoiningGroup(45i32);
pub const U_JG_YEH_BARREE: UJoiningGroup = UJoiningGroup(46i32);
pub const U_JG_YEH_WITH_TAIL: UJoiningGroup = UJoiningGroup(47i32);
pub const U_JG_YUDH: UJoiningGroup = UJoiningGroup(48i32);
pub const U_JG_YUDH_HE: UJoiningGroup = UJoiningGroup(49i32);
pub const U_JG_ZAIN: UJoiningGroup = UJoiningGroup(50i32);
pub const U_JG_FE: UJoiningGroup = UJoiningGroup(51i32);
pub const U_JG_KHAPH: UJoiningGroup = UJoiningGroup(52i32);
pub const U_JG_ZHAIN: UJoiningGroup = UJoiningGroup(53i32);
pub const U_JG_BURUSHASKI_YEH_BARREE: UJoiningGroup = UJoiningGroup(54i32);
pub const U_JG_FARSI_YEH: UJoiningGroup = UJoiningGroup(55i32);
pub const U_JG_NYA: UJoiningGroup = UJoiningGroup(56i32);
pub const U_JG_ROHINGYA_YEH: UJoiningGroup = UJoiningGroup(57i32);
pub const U_JG_MANICHAEAN_ALEPH: UJoiningGroup = UJoiningGroup(58i32);
pub const U_JG_MANICHAEAN_AYIN: UJoiningGroup = UJoiningGroup(59i32);
pub const U_JG_MANICHAEAN_BETH: UJoiningGroup = UJoiningGroup(60i32);
pub const U_JG_MANICHAEAN_DALETH: UJoiningGroup = UJoiningGroup(61i32);
pub const U_JG_MANICHAEAN_DHAMEDH: UJoiningGroup = UJoiningGroup(62i32);
pub const U_JG_MANICHAEAN_FIVE: UJoiningGroup = UJoiningGroup(63i32);
pub const U_JG_MANICHAEAN_GIMEL: UJoiningGroup = UJoiningGroup(64i32);
pub const U_JG_MANICHAEAN_HETH: UJoiningGroup = UJoiningGroup(65i32);
pub const U_JG_MANICHAEAN_HUNDRED: UJoiningGroup = UJoiningGroup(66i32);
pub const U_JG_MANICHAEAN_KAPH: UJoiningGroup = UJoiningGroup(67i32);
pub const U_JG_MANICHAEAN_LAMEDH: UJoiningGroup = UJoiningGroup(68i32);
pub const U_JG_MANICHAEAN_MEM: UJoiningGroup = UJoiningGroup(69i32);
pub const U_JG_MANICHAEAN_NUN: UJoiningGroup = UJoiningGroup(70i32);
pub const U_JG_MANICHAEAN_ONE: UJoiningGroup = UJoiningGroup(71i32);
pub const U_JG_MANICHAEAN_PE: UJoiningGroup = UJoiningGroup(72i32);
pub const U_JG_MANICHAEAN_QOPH: UJoiningGroup = UJoiningGroup(73i32);
pub const U_JG_MANICHAEAN_RESH: UJoiningGroup = UJoiningGroup(74i32);
pub const U_JG_MANICHAEAN_SADHE: UJoiningGroup = UJoiningGroup(75i32);
pub const U_JG_MANICHAEAN_SAMEKH: UJoiningGroup = UJoiningGroup(76i32);
pub const U_JG_MANICHAEAN_TAW: UJoiningGroup = UJoiningGroup(77i32);
pub const U_JG_MANICHAEAN_TEN: UJoiningGroup = UJoiningGroup(78i32);
pub const U_JG_MANICHAEAN_TETH: UJoiningGroup = UJoiningGroup(79i32);
pub const U_JG_MANICHAEAN_THAMEDH: UJoiningGroup = UJoiningGroup(80i32);
pub const U_JG_MANICHAEAN_TWENTY: UJoiningGroup = UJoiningGroup(81i32);
pub const U_JG_MANICHAEAN_WAW: UJoiningGroup = UJoiningGroup(82i32);
pub const U_JG_MANICHAEAN_YODH: UJoiningGroup = UJoiningGroup(83i32);
pub const U_JG_MANICHAEAN_ZAYIN: UJoiningGroup = UJoiningGroup(84i32);
pub const U_JG_STRAIGHT_WAW: UJoiningGroup = UJoiningGroup(85i32);
pub const U_JG_AFRICAN_FEH: UJoiningGroup = UJoiningGroup(86i32);
pub const U_JG_AFRICAN_NOON: UJoiningGroup = UJoiningGroup(87i32);
pub const U_JG_AFRICAN_QAF: UJoiningGroup = UJoiningGroup(88i32);
pub const U_JG_MALAYALAM_BHA: UJoiningGroup = UJoiningGroup(89i32);
pub const U_JG_MALAYALAM_JA: UJoiningGroup = UJoiningGroup(90i32);
pub const U_JG_MALAYALAM_LLA: UJoiningGroup = UJoiningGroup(91i32);
pub const U_JG_MALAYALAM_LLLA: UJoiningGroup = UJoiningGroup(92i32);
pub const U_JG_MALAYALAM_NGA: UJoiningGroup = UJoiningGroup(93i32);
pub const U_JG_MALAYALAM_NNA: UJoiningGroup = UJoiningGroup(94i32);
pub const U_JG_MALAYALAM_NNNA: UJoiningGroup = UJoiningGroup(95i32);
pub const U_JG_MALAYALAM_NYA: UJoiningGroup = UJoiningGroup(96i32);
pub const U_JG_MALAYALAM_RA: UJoiningGroup = UJoiningGroup(97i32);
pub const U_JG_MALAYALAM_SSA: UJoiningGroup = UJoiningGroup(98i32);
pub const U_JG_MALAYALAM_TTA: UJoiningGroup = UJoiningGroup(99i32);
pub const U_JG_HANIFI_ROHINGYA_KINNA_YA: UJoiningGroup = UJoiningGroup(100i32);
pub const U_JG_HANIFI_ROHINGYA_PA: UJoiningGroup = UJoiningGroup(101i32);
impl ::std::convert::From<i32> for UJoiningGroup {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UJoiningGroup {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UJoiningType(pub i32);
pub const U_JT_NON_JOINING: UJoiningType = UJoiningType(0i32);
pub const U_JT_JOIN_CAUSING: UJoiningType = UJoiningType(1i32);
pub const U_JT_DUAL_JOINING: UJoiningType = UJoiningType(2i32);
pub const U_JT_LEFT_JOINING: UJoiningType = UJoiningType(3i32);
pub const U_JT_RIGHT_JOINING: UJoiningType = UJoiningType(4i32);
pub const U_JT_TRANSPARENT: UJoiningType = UJoiningType(5i32);
impl ::std::convert::From<i32> for UJoiningType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UJoiningType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_COUNTRY_CAPACITY: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_FULLNAME_CAPACITY: u32 = 157u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_KEYWORDS_CAPACITY: u32 = 96u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_KEYWORD_AND_VALUES_CAPACITY: u32 = 100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_KEYWORD_ASSIGN_UNICODE: u32 = 61u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_KEYWORD_ITEM_SEPARATOR_UNICODE: u32 = 59u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_KEYWORD_SEPARATOR_UNICODE: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_LANG_CAPACITY: u32 = 12u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const ULOC_SCRIPT_CAPACITY: u32 = 6u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULayoutType(pub i32);
pub const ULOC_LAYOUT_LTR: ULayoutType = ULayoutType(0i32);
pub const ULOC_LAYOUT_RTL: ULayoutType = ULayoutType(1i32);
pub const ULOC_LAYOUT_TTB: ULayoutType = ULayoutType(2i32);
pub const ULOC_LAYOUT_BTT: ULayoutType = ULayoutType(3i32);
pub const ULOC_LAYOUT_UNKNOWN: ULayoutType = ULayoutType(4i32);
impl ::std::convert::From<i32> for ULayoutType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULayoutType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULineBreak(pub i32);
pub const U_LB_UNKNOWN: ULineBreak = ULineBreak(0i32);
pub const U_LB_AMBIGUOUS: ULineBreak = ULineBreak(1i32);
pub const U_LB_ALPHABETIC: ULineBreak = ULineBreak(2i32);
pub const U_LB_BREAK_BOTH: ULineBreak = ULineBreak(3i32);
pub const U_LB_BREAK_AFTER: ULineBreak = ULineBreak(4i32);
pub const U_LB_BREAK_BEFORE: ULineBreak = ULineBreak(5i32);
pub const U_LB_MANDATORY_BREAK: ULineBreak = ULineBreak(6i32);
pub const U_LB_CONTINGENT_BREAK: ULineBreak = ULineBreak(7i32);
pub const U_LB_CLOSE_PUNCTUATION: ULineBreak = ULineBreak(8i32);
pub const U_LB_COMBINING_MARK: ULineBreak = ULineBreak(9i32);
pub const U_LB_CARRIAGE_RETURN: ULineBreak = ULineBreak(10i32);
pub const U_LB_EXCLAMATION: ULineBreak = ULineBreak(11i32);
pub const U_LB_GLUE: ULineBreak = ULineBreak(12i32);
pub const U_LB_HYPHEN: ULineBreak = ULineBreak(13i32);
pub const U_LB_IDEOGRAPHIC: ULineBreak = ULineBreak(14i32);
pub const U_LB_INSEPARABLE: ULineBreak = ULineBreak(15i32);
pub const U_LB_INSEPERABLE: ULineBreak = ULineBreak(15i32);
pub const U_LB_INFIX_NUMERIC: ULineBreak = ULineBreak(16i32);
pub const U_LB_LINE_FEED: ULineBreak = ULineBreak(17i32);
pub const U_LB_NONSTARTER: ULineBreak = ULineBreak(18i32);
pub const U_LB_NUMERIC: ULineBreak = ULineBreak(19i32);
pub const U_LB_OPEN_PUNCTUATION: ULineBreak = ULineBreak(20i32);
pub const U_LB_POSTFIX_NUMERIC: ULineBreak = ULineBreak(21i32);
pub const U_LB_PREFIX_NUMERIC: ULineBreak = ULineBreak(22i32);
pub const U_LB_QUOTATION: ULineBreak = ULineBreak(23i32);
pub const U_LB_COMPLEX_CONTEXT: ULineBreak = ULineBreak(24i32);
pub const U_LB_SURROGATE: ULineBreak = ULineBreak(25i32);
pub const U_LB_SPACE: ULineBreak = ULineBreak(26i32);
pub const U_LB_BREAK_SYMBOLS: ULineBreak = ULineBreak(27i32);
pub const U_LB_ZWSPACE: ULineBreak = ULineBreak(28i32);
pub const U_LB_NEXT_LINE: ULineBreak = ULineBreak(29i32);
pub const U_LB_WORD_JOINER: ULineBreak = ULineBreak(30i32);
pub const U_LB_H2: ULineBreak = ULineBreak(31i32);
pub const U_LB_H3: ULineBreak = ULineBreak(32i32);
pub const U_LB_JL: ULineBreak = ULineBreak(33i32);
pub const U_LB_JT: ULineBreak = ULineBreak(34i32);
pub const U_LB_JV: ULineBreak = ULineBreak(35i32);
pub const U_LB_CLOSE_PARENTHESIS: ULineBreak = ULineBreak(36i32);
pub const U_LB_CONDITIONAL_JAPANESE_STARTER: ULineBreak = ULineBreak(37i32);
pub const U_LB_HEBREW_LETTER: ULineBreak = ULineBreak(38i32);
pub const U_LB_REGIONAL_INDICATOR: ULineBreak = ULineBreak(39i32);
pub const U_LB_E_BASE: ULineBreak = ULineBreak(40i32);
pub const U_LB_E_MODIFIER: ULineBreak = ULineBreak(41i32);
pub const U_LB_ZWJ: ULineBreak = ULineBreak(42i32);
impl ::std::convert::From<i32> for ULineBreak {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULineBreak {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULineBreakTag(pub i32);
pub const UBRK_LINE_SOFT: ULineBreakTag = ULineBreakTag(0i32);
pub const UBRK_LINE_SOFT_LIMIT: ULineBreakTag = ULineBreakTag(100i32);
pub const UBRK_LINE_HARD: ULineBreakTag = ULineBreakTag(100i32);
pub const UBRK_LINE_HARD_LIMIT: ULineBreakTag = ULineBreakTag(200i32);
impl ::std::convert::From<i32> for ULineBreakTag {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULineBreakTag {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UListFormatter(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UListFormatterField(pub i32);
pub const ULISTFMT_LITERAL_FIELD: UListFormatterField = UListFormatterField(0i32);
pub const ULISTFMT_ELEMENT_FIELD: UListFormatterField = UListFormatterField(1i32);
impl ::std::convert::From<i32> for UListFormatterField {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UListFormatterField {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UListFormatterType(pub i32);
pub const ULISTFMT_TYPE_AND: UListFormatterType = UListFormatterType(0i32);
pub const ULISTFMT_TYPE_OR: UListFormatterType = UListFormatterType(1i32);
pub const ULISTFMT_TYPE_UNITS: UListFormatterType = UListFormatterType(2i32);
impl ::std::convert::From<i32> for UListFormatterType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UListFormatterType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UListFormatterWidth(pub i32);
pub const ULISTFMT_WIDTH_WIDE: UListFormatterWidth = UListFormatterWidth(0i32);
pub const ULISTFMT_WIDTH_SHORT: UListFormatterWidth = UListFormatterWidth(1i32);
pub const ULISTFMT_WIDTH_NARROW: UListFormatterWidth = UListFormatterWidth(2i32);
impl ::std::convert::From<i32> for UListFormatterWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UListFormatterWidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULocAvailableType(pub i32);
pub const ULOC_AVAILABLE_DEFAULT: ULocAvailableType = ULocAvailableType(0i32);
pub const ULOC_AVAILABLE_ONLY_LEGACY_ALIASES: ULocAvailableType = ULocAvailableType(1i32);
pub const ULOC_AVAILABLE_WITH_LEGACY_ALIASES: ULocAvailableType = ULocAvailableType(2i32);
impl ::std::convert::From<i32> for ULocAvailableType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULocAvailableType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULocDataLocaleType(pub i32);
pub const ULOC_ACTUAL_LOCALE: ULocDataLocaleType = ULocDataLocaleType(0i32);
pub const ULOC_VALID_LOCALE: ULocDataLocaleType = ULocDataLocaleType(1i32);
impl ::std::convert::From<i32> for ULocDataLocaleType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULocDataLocaleType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct ULocaleData(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULocaleDataDelimiterType(pub i32);
pub const ULOCDATA_QUOTATION_START: ULocaleDataDelimiterType = ULocaleDataDelimiterType(0i32);
pub const ULOCDATA_QUOTATION_END: ULocaleDataDelimiterType = ULocaleDataDelimiterType(1i32);
pub const ULOCDATA_ALT_QUOTATION_START: ULocaleDataDelimiterType = ULocaleDataDelimiterType(2i32);
pub const ULOCDATA_ALT_QUOTATION_END: ULocaleDataDelimiterType = ULocaleDataDelimiterType(3i32);
impl ::std::convert::From<i32> for ULocaleDataDelimiterType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULocaleDataDelimiterType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct ULocaleDataExemplarSetType(pub i32);
pub const ULOCDATA_ES_STANDARD: ULocaleDataExemplarSetType = ULocaleDataExemplarSetType(0i32);
pub const ULOCDATA_ES_AUXILIARY: ULocaleDataExemplarSetType = ULocaleDataExemplarSetType(1i32);
pub const ULOCDATA_ES_INDEX: ULocaleDataExemplarSetType = ULocaleDataExemplarSetType(2i32);
pub const ULOCDATA_ES_PUNCTUATION: ULocaleDataExemplarSetType = ULocaleDataExemplarSetType(3i32);
impl ::std::convert::From<i32> for ULocaleDataExemplarSetType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ULocaleDataExemplarSetType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct ULocaleDisplayNames(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UMSGPAT_ARG_NAME_NOT_NUMBER: i32 = -1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UMSGPAT_ARG_NAME_NOT_VALID: i32 = -2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UMeasureFormatWidth(pub i32);
pub const UMEASFMT_WIDTH_WIDE: UMeasureFormatWidth = UMeasureFormatWidth(0i32);
pub const UMEASFMT_WIDTH_SHORT: UMeasureFormatWidth = UMeasureFormatWidth(1i32);
pub const UMEASFMT_WIDTH_NARROW: UMeasureFormatWidth = UMeasureFormatWidth(2i32);
pub const UMEASFMT_WIDTH_NUMERIC: UMeasureFormatWidth = UMeasureFormatWidth(3i32);
pub const UMEASFMT_WIDTH_COUNT: UMeasureFormatWidth = UMeasureFormatWidth(4i32);
impl ::std::convert::From<i32> for UMeasureFormatWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UMeasureFormatWidth {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UMeasurementSystem(pub i32);
pub const UMS_SI: UMeasurementSystem = UMeasurementSystem(0i32);
pub const UMS_US: UMeasurementSystem = UMeasurementSystem(1i32);
pub const UMS_UK: UMeasurementSystem = UMeasurementSystem(2i32);
impl ::std::convert::From<i32> for UMeasurementSystem {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UMeasurementSystem {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UMemAllocFn = unsafe extern "system" fn(context: *const ::std::ffi::c_void, size: usize) -> *mut ::std::ffi::c_void;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UMemFreeFn = unsafe extern "system" fn(context: *const ::std::ffi::c_void, mem: *mut ::std::ffi::c_void);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UMemReallocFn = unsafe extern "system" fn(context: *const ::std::ffi::c_void, mem: *mut ::std::ffi::c_void, size: usize) -> *mut ::std::ffi::c_void;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UMessagePatternApostropheMode(pub i32);
pub const UMSGPAT_APOS_DOUBLE_OPTIONAL: UMessagePatternApostropheMode = UMessagePatternApostropheMode(0i32);
pub const UMSGPAT_APOS_DOUBLE_REQUIRED: UMessagePatternApostropheMode = UMessagePatternApostropheMode(1i32);
impl ::std::convert::From<i32> for UMessagePatternApostropheMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UMessagePatternApostropheMode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UMessagePatternArgType(pub i32);
pub const UMSGPAT_ARG_TYPE_NONE: UMessagePatternArgType = UMessagePatternArgType(0i32);
pub const UMSGPAT_ARG_TYPE_SIMPLE: UMessagePatternArgType = UMessagePatternArgType(1i32);
pub const UMSGPAT_ARG_TYPE_CHOICE: UMessagePatternArgType = UMessagePatternArgType(2i32);
pub const UMSGPAT_ARG_TYPE_PLURAL: UMessagePatternArgType = UMessagePatternArgType(3i32);
pub const UMSGPAT_ARG_TYPE_SELECT: UMessagePatternArgType = UMessagePatternArgType(4i32);
pub const UMSGPAT_ARG_TYPE_SELECTORDINAL: UMessagePatternArgType = UMessagePatternArgType(5i32);
impl ::std::convert::From<i32> for UMessagePatternArgType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UMessagePatternArgType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UMessagePatternPartType(pub i32);
pub const UMSGPAT_PART_TYPE_MSG_START: UMessagePatternPartType = UMessagePatternPartType(0i32);
pub const UMSGPAT_PART_TYPE_MSG_LIMIT: UMessagePatternPartType = UMessagePatternPartType(1i32);
pub const UMSGPAT_PART_TYPE_SKIP_SYNTAX: UMessagePatternPartType = UMessagePatternPartType(2i32);
pub const UMSGPAT_PART_TYPE_INSERT_CHAR: UMessagePatternPartType = UMessagePatternPartType(3i32);
pub const UMSGPAT_PART_TYPE_REPLACE_NUMBER: UMessagePatternPartType = UMessagePatternPartType(4i32);
pub const UMSGPAT_PART_TYPE_ARG_START: UMessagePatternPartType = UMessagePatternPartType(5i32);
pub const UMSGPAT_PART_TYPE_ARG_LIMIT: UMessagePatternPartType = UMessagePatternPartType(6i32);
pub const UMSGPAT_PART_TYPE_ARG_NUMBER: UMessagePatternPartType = UMessagePatternPartType(7i32);
pub const UMSGPAT_PART_TYPE_ARG_NAME: UMessagePatternPartType = UMessagePatternPartType(8i32);
pub const UMSGPAT_PART_TYPE_ARG_TYPE: UMessagePatternPartType = UMessagePatternPartType(9i32);
pub const UMSGPAT_PART_TYPE_ARG_STYLE: UMessagePatternPartType = UMessagePatternPartType(10i32);
pub const UMSGPAT_PART_TYPE_ARG_SELECTOR: UMessagePatternPartType = UMessagePatternPartType(11i32);
pub const UMSGPAT_PART_TYPE_ARG_INT: UMessagePatternPartType = UMessagePatternPartType(12i32);
pub const UMSGPAT_PART_TYPE_ARG_DOUBLE: UMessagePatternPartType = UMessagePatternPartType(13i32);
impl ::std::convert::From<i32> for UMessagePatternPartType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UMessagePatternPartType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UMutableCPTrie(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UNESCAPE_CHAR_AT = unsafe extern "system" fn(offset: i32, context: *mut ::std::ffi::c_void) -> u16;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UNICODERANGE {
    pub wcFrom: u16,
    pub wcTo: u16,
}
impl UNICODERANGE {}
impl ::std::default::Default for UNICODERANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UNICODERANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UNICODERANGE").field("wcFrom", &self.wcFrom).field("wcTo", &self.wcTo).finish()
    }
}
impl ::std::cmp::PartialEq for UNICODERANGE {
    fn eq(&self, other: &Self) -> bool {
        self.wcFrom == other.wcFrom && self.wcTo == other.wcTo
    }
}
impl ::std::cmp::Eq for UNICODERANGE {}
unsafe impl ::windows::runtime::Abi for UNICODERANGE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UNISCRIBE_OPENTYPE: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UNORM_INPUT_IS_FCD: u32 = 131072u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNormalization2Mode(pub i32);
pub const UNORM2_COMPOSE: UNormalization2Mode = UNormalization2Mode(0i32);
pub const UNORM2_DECOMPOSE: UNormalization2Mode = UNormalization2Mode(1i32);
pub const UNORM2_FCD: UNormalization2Mode = UNormalization2Mode(2i32);
pub const UNORM2_COMPOSE_CONTIGUOUS: UNormalization2Mode = UNormalization2Mode(3i32);
impl ::std::convert::From<i32> for UNormalization2Mode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNormalization2Mode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNormalizationCheckResult(pub i32);
pub const UNORM_NO: UNormalizationCheckResult = UNormalizationCheckResult(0i32);
pub const UNORM_YES: UNormalizationCheckResult = UNormalizationCheckResult(1i32);
pub const UNORM_MAYBE: UNormalizationCheckResult = UNormalizationCheckResult(2i32);
impl ::std::convert::From<i32> for UNormalizationCheckResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNormalizationCheckResult {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNormalizationMode(pub i32);
pub const UNORM_NONE: UNormalizationMode = UNormalizationMode(1i32);
pub const UNORM_NFD: UNormalizationMode = UNormalizationMode(2i32);
pub const UNORM_NFKD: UNormalizationMode = UNormalizationMode(3i32);
pub const UNORM_NFC: UNormalizationMode = UNormalizationMode(4i32);
pub const UNORM_DEFAULT: UNormalizationMode = UNormalizationMode(4i32);
pub const UNORM_NFKC: UNormalizationMode = UNormalizationMode(5i32);
pub const UNORM_FCD: UNormalizationMode = UNormalizationMode(6i32);
pub const UNORM_MODE_COUNT: UNormalizationMode = UNormalizationMode(7i32);
impl ::std::convert::From<i32> for UNormalizationMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNormalizationMode {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UNormalizer2(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberCompactStyle(pub i32);
pub const UNUM_SHORT: UNumberCompactStyle = UNumberCompactStyle(0i32);
pub const UNUM_LONG: UNumberCompactStyle = UNumberCompactStyle(1i32);
impl ::std::convert::From<i32> for UNumberCompactStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberCompactStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberDecimalSeparatorDisplay(pub i32);
pub const UNUM_DECIMAL_SEPARATOR_AUTO: UNumberDecimalSeparatorDisplay = UNumberDecimalSeparatorDisplay(0i32);
pub const UNUM_DECIMAL_SEPARATOR_ALWAYS: UNumberDecimalSeparatorDisplay = UNumberDecimalSeparatorDisplay(1i32);
pub const UNUM_DECIMAL_SEPARATOR_COUNT: UNumberDecimalSeparatorDisplay = UNumberDecimalSeparatorDisplay(2i32);
impl ::std::convert::From<i32> for UNumberDecimalSeparatorDisplay {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberDecimalSeparatorDisplay {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatAttribute(pub i32);
pub const UNUM_PARSE_INT_ONLY: UNumberFormatAttribute = UNumberFormatAttribute(0i32);
pub const UNUM_GROUPING_USED: UNumberFormatAttribute = UNumberFormatAttribute(1i32);
pub const UNUM_DECIMAL_ALWAYS_SHOWN: UNumberFormatAttribute = UNumberFormatAttribute(2i32);
pub const UNUM_MAX_INTEGER_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(3i32);
pub const UNUM_MIN_INTEGER_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(4i32);
pub const UNUM_INTEGER_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(5i32);
pub const UNUM_MAX_FRACTION_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(6i32);
pub const UNUM_MIN_FRACTION_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(7i32);
pub const UNUM_FRACTION_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(8i32);
pub const UNUM_MULTIPLIER: UNumberFormatAttribute = UNumberFormatAttribute(9i32);
pub const UNUM_GROUPING_SIZE: UNumberFormatAttribute = UNumberFormatAttribute(10i32);
pub const UNUM_ROUNDING_MODE: UNumberFormatAttribute = UNumberFormatAttribute(11i32);
pub const UNUM_ROUNDING_INCREMENT: UNumberFormatAttribute = UNumberFormatAttribute(12i32);
pub const UNUM_FORMAT_WIDTH: UNumberFormatAttribute = UNumberFormatAttribute(13i32);
pub const UNUM_PADDING_POSITION: UNumberFormatAttribute = UNumberFormatAttribute(14i32);
pub const UNUM_SECONDARY_GROUPING_SIZE: UNumberFormatAttribute = UNumberFormatAttribute(15i32);
pub const UNUM_SIGNIFICANT_DIGITS_USED: UNumberFormatAttribute = UNumberFormatAttribute(16i32);
pub const UNUM_MIN_SIGNIFICANT_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(17i32);
pub const UNUM_MAX_SIGNIFICANT_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(18i32);
pub const UNUM_LENIENT_PARSE: UNumberFormatAttribute = UNumberFormatAttribute(19i32);
pub const UNUM_PARSE_ALL_INPUT: UNumberFormatAttribute = UNumberFormatAttribute(20i32);
pub const UNUM_SCALE: UNumberFormatAttribute = UNumberFormatAttribute(21i32);
pub const UNUM_MINIMUM_GROUPING_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(22i32);
pub const UNUM_CURRENCY_USAGE: UNumberFormatAttribute = UNumberFormatAttribute(23i32);
pub const UNUM_FORMAT_FAIL_IF_MORE_THAN_MAX_DIGITS: UNumberFormatAttribute = UNumberFormatAttribute(4096i32);
pub const UNUM_PARSE_NO_EXPONENT: UNumberFormatAttribute = UNumberFormatAttribute(4097i32);
pub const UNUM_PARSE_DECIMAL_MARK_REQUIRED: UNumberFormatAttribute = UNumberFormatAttribute(4098i32);
pub const UNUM_PARSE_CASE_SENSITIVE: UNumberFormatAttribute = UNumberFormatAttribute(4099i32);
pub const UNUM_SIGN_ALWAYS_SHOWN: UNumberFormatAttribute = UNumberFormatAttribute(4100i32);
impl ::std::convert::From<i32> for UNumberFormatAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatAttribute {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatAttributeValue(pub i32);
pub const UNUM_FORMAT_ATTRIBUTE_VALUE_HIDDEN: UNumberFormatAttributeValue = UNumberFormatAttributeValue(0i32);
impl ::std::convert::From<i32> for UNumberFormatAttributeValue {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatAttributeValue {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatFields(pub i32);
pub const UNUM_INTEGER_FIELD: UNumberFormatFields = UNumberFormatFields(0i32);
pub const UNUM_FRACTION_FIELD: UNumberFormatFields = UNumberFormatFields(1i32);
pub const UNUM_DECIMAL_SEPARATOR_FIELD: UNumberFormatFields = UNumberFormatFields(2i32);
pub const UNUM_EXPONENT_SYMBOL_FIELD: UNumberFormatFields = UNumberFormatFields(3i32);
pub const UNUM_EXPONENT_SIGN_FIELD: UNumberFormatFields = UNumberFormatFields(4i32);
pub const UNUM_EXPONENT_FIELD: UNumberFormatFields = UNumberFormatFields(5i32);
pub const UNUM_GROUPING_SEPARATOR_FIELD: UNumberFormatFields = UNumberFormatFields(6i32);
pub const UNUM_CURRENCY_FIELD: UNumberFormatFields = UNumberFormatFields(7i32);
pub const UNUM_PERCENT_FIELD: UNumberFormatFields = UNumberFormatFields(8i32);
pub const UNUM_PERMILL_FIELD: UNumberFormatFields = UNumberFormatFields(9i32);
pub const UNUM_SIGN_FIELD: UNumberFormatFields = UNumberFormatFields(10i32);
pub const UNUM_MEASURE_UNIT_FIELD: UNumberFormatFields = UNumberFormatFields(11i32);
pub const UNUM_COMPACT_FIELD: UNumberFormatFields = UNumberFormatFields(12i32);
impl ::std::convert::From<i32> for UNumberFormatFields {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatFields {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatPadPosition(pub i32);
pub const UNUM_PAD_BEFORE_PREFIX: UNumberFormatPadPosition = UNumberFormatPadPosition(0i32);
pub const UNUM_PAD_AFTER_PREFIX: UNumberFormatPadPosition = UNumberFormatPadPosition(1i32);
pub const UNUM_PAD_BEFORE_SUFFIX: UNumberFormatPadPosition = UNumberFormatPadPosition(2i32);
pub const UNUM_PAD_AFTER_SUFFIX: UNumberFormatPadPosition = UNumberFormatPadPosition(3i32);
impl ::std::convert::From<i32> for UNumberFormatPadPosition {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatPadPosition {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatRoundingMode(pub i32);
pub const UNUM_ROUND_CEILING: UNumberFormatRoundingMode = UNumberFormatRoundingMode(0i32);
pub const UNUM_ROUND_FLOOR: UNumberFormatRoundingMode = UNumberFormatRoundingMode(1i32);
pub const UNUM_ROUND_DOWN: UNumberFormatRoundingMode = UNumberFormatRoundingMode(2i32);
pub const UNUM_ROUND_UP: UNumberFormatRoundingMode = UNumberFormatRoundingMode(3i32);
pub const UNUM_ROUND_HALFEVEN: UNumberFormatRoundingMode = UNumberFormatRoundingMode(4i32);
pub const UNUM_ROUND_HALFDOWN: UNumberFormatRoundingMode = UNumberFormatRoundingMode(5i32);
pub const UNUM_ROUND_HALFUP: UNumberFormatRoundingMode = UNumberFormatRoundingMode(6i32);
pub const UNUM_ROUND_UNNECESSARY: UNumberFormatRoundingMode = UNumberFormatRoundingMode(7i32);
impl ::std::convert::From<i32> for UNumberFormatRoundingMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatRoundingMode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatStyle(pub i32);
pub const UNUM_PATTERN_DECIMAL: UNumberFormatStyle = UNumberFormatStyle(0i32);
pub const UNUM_DECIMAL: UNumberFormatStyle = UNumberFormatStyle(1i32);
pub const UNUM_CURRENCY: UNumberFormatStyle = UNumberFormatStyle(2i32);
pub const UNUM_PERCENT: UNumberFormatStyle = UNumberFormatStyle(3i32);
pub const UNUM_SCIENTIFIC: UNumberFormatStyle = UNumberFormatStyle(4i32);
pub const UNUM_SPELLOUT: UNumberFormatStyle = UNumberFormatStyle(5i32);
pub const UNUM_ORDINAL: UNumberFormatStyle = UNumberFormatStyle(6i32);
pub const UNUM_DURATION: UNumberFormatStyle = UNumberFormatStyle(7i32);
pub const UNUM_NUMBERING_SYSTEM: UNumberFormatStyle = UNumberFormatStyle(8i32);
pub const UNUM_PATTERN_RULEBASED: UNumberFormatStyle = UNumberFormatStyle(9i32);
pub const UNUM_CURRENCY_ISO: UNumberFormatStyle = UNumberFormatStyle(10i32);
pub const UNUM_CURRENCY_PLURAL: UNumberFormatStyle = UNumberFormatStyle(11i32);
pub const UNUM_CURRENCY_ACCOUNTING: UNumberFormatStyle = UNumberFormatStyle(12i32);
pub const UNUM_CASH_CURRENCY: UNumberFormatStyle = UNumberFormatStyle(13i32);
pub const UNUM_DECIMAL_COMPACT_SHORT: UNumberFormatStyle = UNumberFormatStyle(14i32);
pub const UNUM_DECIMAL_COMPACT_LONG: UNumberFormatStyle = UNumberFormatStyle(15i32);
pub const UNUM_CURRENCY_STANDARD: UNumberFormatStyle = UNumberFormatStyle(16i32);
pub const UNUM_DEFAULT: UNumberFormatStyle = UNumberFormatStyle(1i32);
pub const UNUM_IGNORE: UNumberFormatStyle = UNumberFormatStyle(0i32);
impl ::std::convert::From<i32> for UNumberFormatStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatSymbol(pub i32);
pub const UNUM_DECIMAL_SEPARATOR_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(0i32);
pub const UNUM_GROUPING_SEPARATOR_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(1i32);
pub const UNUM_PATTERN_SEPARATOR_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(2i32);
pub const UNUM_PERCENT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(3i32);
pub const UNUM_ZERO_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(4i32);
pub const UNUM_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(5i32);
pub const UNUM_MINUS_SIGN_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(6i32);
pub const UNUM_PLUS_SIGN_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(7i32);
pub const UNUM_CURRENCY_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(8i32);
pub const UNUM_INTL_CURRENCY_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(9i32);
pub const UNUM_MONETARY_SEPARATOR_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(10i32);
pub const UNUM_EXPONENTIAL_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(11i32);
pub const UNUM_PERMILL_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(12i32);
pub const UNUM_PAD_ESCAPE_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(13i32);
pub const UNUM_INFINITY_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(14i32);
pub const UNUM_NAN_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(15i32);
pub const UNUM_SIGNIFICANT_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(16i32);
pub const UNUM_MONETARY_GROUPING_SEPARATOR_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(17i32);
pub const UNUM_ONE_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(18i32);
pub const UNUM_TWO_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(19i32);
pub const UNUM_THREE_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(20i32);
pub const UNUM_FOUR_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(21i32);
pub const UNUM_FIVE_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(22i32);
pub const UNUM_SIX_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(23i32);
pub const UNUM_SEVEN_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(24i32);
pub const UNUM_EIGHT_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(25i32);
pub const UNUM_NINE_DIGIT_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(26i32);
pub const UNUM_EXPONENT_MULTIPLICATION_SYMBOL: UNumberFormatSymbol = UNumberFormatSymbol(27i32);
impl ::std::convert::From<i32> for UNumberFormatSymbol {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatSymbol {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberFormatTextAttribute(pub i32);
pub const UNUM_POSITIVE_PREFIX: UNumberFormatTextAttribute = UNumberFormatTextAttribute(0i32);
pub const UNUM_POSITIVE_SUFFIX: UNumberFormatTextAttribute = UNumberFormatTextAttribute(1i32);
pub const UNUM_NEGATIVE_PREFIX: UNumberFormatTextAttribute = UNumberFormatTextAttribute(2i32);
pub const UNUM_NEGATIVE_SUFFIX: UNumberFormatTextAttribute = UNumberFormatTextAttribute(3i32);
pub const UNUM_PADDING_CHARACTER: UNumberFormatTextAttribute = UNumberFormatTextAttribute(4i32);
pub const UNUM_CURRENCY_CODE: UNumberFormatTextAttribute = UNumberFormatTextAttribute(5i32);
pub const UNUM_DEFAULT_RULESET: UNumberFormatTextAttribute = UNumberFormatTextAttribute(6i32);
pub const UNUM_PUBLIC_RULESETS: UNumberFormatTextAttribute = UNumberFormatTextAttribute(7i32);
impl ::std::convert::From<i32> for UNumberFormatTextAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberFormatTextAttribute {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UNumberFormatter(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberGroupingStrategy(pub i32);
pub const UNUM_GROUPING_OFF: UNumberGroupingStrategy = UNumberGroupingStrategy(0i32);
pub const UNUM_GROUPING_MIN2: UNumberGroupingStrategy = UNumberGroupingStrategy(1i32);
pub const UNUM_GROUPING_AUTO: UNumberGroupingStrategy = UNumberGroupingStrategy(2i32);
pub const UNUM_GROUPING_ON_ALIGNED: UNumberGroupingStrategy = UNumberGroupingStrategy(3i32);
pub const UNUM_GROUPING_THOUSANDS: UNumberGroupingStrategy = UNumberGroupingStrategy(4i32);
impl ::std::convert::From<i32> for UNumberGroupingStrategy {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberGroupingStrategy {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberRangeCollapse(pub i32);
pub const UNUM_RANGE_COLLAPSE_AUTO: UNumberRangeCollapse = UNumberRangeCollapse(0i32);
pub const UNUM_RANGE_COLLAPSE_NONE: UNumberRangeCollapse = UNumberRangeCollapse(1i32);
pub const UNUM_RANGE_COLLAPSE_UNIT: UNumberRangeCollapse = UNumberRangeCollapse(2i32);
pub const UNUM_RANGE_COLLAPSE_ALL: UNumberRangeCollapse = UNumberRangeCollapse(3i32);
impl ::std::convert::From<i32> for UNumberRangeCollapse {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberRangeCollapse {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberRangeIdentityFallback(pub i32);
pub const UNUM_IDENTITY_FALLBACK_SINGLE_VALUE: UNumberRangeIdentityFallback = UNumberRangeIdentityFallback(0i32);
pub const UNUM_IDENTITY_FALLBACK_APPROXIMATELY_OR_SINGLE_VALUE: UNumberRangeIdentityFallback = UNumberRangeIdentityFallback(1i32);
pub const UNUM_IDENTITY_FALLBACK_APPROXIMATELY: UNumberRangeIdentityFallback = UNumberRangeIdentityFallback(2i32);
pub const UNUM_IDENTITY_FALLBACK_RANGE: UNumberRangeIdentityFallback = UNumberRangeIdentityFallback(3i32);
impl ::std::convert::From<i32> for UNumberRangeIdentityFallback {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberRangeIdentityFallback {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberRangeIdentityResult(pub i32);
pub const UNUM_IDENTITY_RESULT_EQUAL_BEFORE_ROUNDING: UNumberRangeIdentityResult = UNumberRangeIdentityResult(0i32);
pub const UNUM_IDENTITY_RESULT_EQUAL_AFTER_ROUNDING: UNumberRangeIdentityResult = UNumberRangeIdentityResult(1i32);
pub const UNUM_IDENTITY_RESULT_NOT_EQUAL: UNumberRangeIdentityResult = UNumberRangeIdentityResult(2i32);
impl ::std::convert::From<i32> for UNumberRangeIdentityResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberRangeIdentityResult {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberSignDisplay(pub i32);
pub const UNUM_SIGN_AUTO: UNumberSignDisplay = UNumberSignDisplay(0i32);
pub const UNUM_SIGN_ALWAYS: UNumberSignDisplay = UNumberSignDisplay(1i32);
pub const UNUM_SIGN_NEVER: UNumberSignDisplay = UNumberSignDisplay(2i32);
pub const UNUM_SIGN_ACCOUNTING: UNumberSignDisplay = UNumberSignDisplay(3i32);
pub const UNUM_SIGN_ACCOUNTING_ALWAYS: UNumberSignDisplay = UNumberSignDisplay(4i32);
pub const UNUM_SIGN_EXCEPT_ZERO: UNumberSignDisplay = UNumberSignDisplay(5i32);
pub const UNUM_SIGN_ACCOUNTING_EXCEPT_ZERO: UNumberSignDisplay = UNumberSignDisplay(6i32);
pub const UNUM_SIGN_COUNT: UNumberSignDisplay = UNumberSignDisplay(7i32);
impl ::std::convert::From<i32> for UNumberSignDisplay {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberSignDisplay {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumberUnitWidth(pub i32);
pub const UNUM_UNIT_WIDTH_NARROW: UNumberUnitWidth = UNumberUnitWidth(0i32);
pub const UNUM_UNIT_WIDTH_SHORT: UNumberUnitWidth = UNumberUnitWidth(1i32);
pub const UNUM_UNIT_WIDTH_FULL_NAME: UNumberUnitWidth = UNumberUnitWidth(2i32);
pub const UNUM_UNIT_WIDTH_ISO_CODE: UNumberUnitWidth = UNumberUnitWidth(3i32);
pub const UNUM_UNIT_WIDTH_HIDDEN: UNumberUnitWidth = UNumberUnitWidth(4i32);
pub const UNUM_UNIT_WIDTH_COUNT: UNumberUnitWidth = UNumberUnitWidth(5i32);
impl ::std::convert::From<i32> for UNumberUnitWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumberUnitWidth {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UNumberingSystem(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UNumericType(pub i32);
pub const U_NT_NONE: UNumericType = UNumericType(0i32);
pub const U_NT_DECIMAL: UNumericType = UNumericType(1i32);
pub const U_NT_DIGIT: UNumericType = UNumericType(2i32);
pub const U_NT_NUMERIC: UNumericType = UNumericType(3i32);
impl ::std::convert::From<i32> for UNumericType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UNumericType {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UParseError {
    pub line: i32,
    pub offset: i32,
    pub preContext: [u16; 16],
    pub postContext: [u16; 16],
}
impl UParseError {}
impl ::std::default::Default for UParseError {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UParseError {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UParseError").field("line", &self.line).field("offset", &self.offset).field("preContext", &self.preContext).field("postContext", &self.postContext).finish()
    }
}
impl ::std::cmp::PartialEq for UParseError {
    fn eq(&self, other: &Self) -> bool {
        self.line == other.line && self.offset == other.offset && self.preContext == other.preContext && self.postContext == other.postContext
    }
}
impl ::std::cmp::Eq for UParseError {}
unsafe impl ::windows::runtime::Abi for UParseError {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UPluralRules(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UPluralType(pub i32);
pub const UPLURAL_TYPE_CARDINAL: UPluralType = UPluralType(0i32);
pub const UPLURAL_TYPE_ORDINAL: UPluralType = UPluralType(1i32);
impl ::std::convert::From<i32> for UPluralType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UPluralType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UProperty(pub i32);
pub const UCHAR_ALPHABETIC: UProperty = UProperty(0i32);
pub const UCHAR_BINARY_START: UProperty = UProperty(0i32);
pub const UCHAR_ASCII_HEX_DIGIT: UProperty = UProperty(1i32);
pub const UCHAR_BIDI_CONTROL: UProperty = UProperty(2i32);
pub const UCHAR_BIDI_MIRRORED: UProperty = UProperty(3i32);
pub const UCHAR_DASH: UProperty = UProperty(4i32);
pub const UCHAR_DEFAULT_IGNORABLE_CODE_POINT: UProperty = UProperty(5i32);
pub const UCHAR_DEPRECATED: UProperty = UProperty(6i32);
pub const UCHAR_DIACRITIC: UProperty = UProperty(7i32);
pub const UCHAR_EXTENDER: UProperty = UProperty(8i32);
pub const UCHAR_FULL_COMPOSITION_EXCLUSION: UProperty = UProperty(9i32);
pub const UCHAR_GRAPHEME_BASE: UProperty = UProperty(10i32);
pub const UCHAR_GRAPHEME_EXTEND: UProperty = UProperty(11i32);
pub const UCHAR_GRAPHEME_LINK: UProperty = UProperty(12i32);
pub const UCHAR_HEX_DIGIT: UProperty = UProperty(13i32);
pub const UCHAR_HYPHEN: UProperty = UProperty(14i32);
pub const UCHAR_ID_CONTINUE: UProperty = UProperty(15i32);
pub const UCHAR_ID_START: UProperty = UProperty(16i32);
pub const UCHAR_IDEOGRAPHIC: UProperty = UProperty(17i32);
pub const UCHAR_IDS_BINARY_OPERATOR: UProperty = UProperty(18i32);
pub const UCHAR_IDS_TRINARY_OPERATOR: UProperty = UProperty(19i32);
pub const UCHAR_JOIN_CONTROL: UProperty = UProperty(20i32);
pub const UCHAR_LOGICAL_ORDER_EXCEPTION: UProperty = UProperty(21i32);
pub const UCHAR_LOWERCASE: UProperty = UProperty(22i32);
pub const UCHAR_MATH: UProperty = UProperty(23i32);
pub const UCHAR_NONCHARACTER_CODE_POINT: UProperty = UProperty(24i32);
pub const UCHAR_QUOTATION_MARK: UProperty = UProperty(25i32);
pub const UCHAR_RADICAL: UProperty = UProperty(26i32);
pub const UCHAR_SOFT_DOTTED: UProperty = UProperty(27i32);
pub const UCHAR_TERMINAL_PUNCTUATION: UProperty = UProperty(28i32);
pub const UCHAR_UNIFIED_IDEOGRAPH: UProperty = UProperty(29i32);
pub const UCHAR_UPPERCASE: UProperty = UProperty(30i32);
pub const UCHAR_WHITE_SPACE: UProperty = UProperty(31i32);
pub const UCHAR_XID_CONTINUE: UProperty = UProperty(32i32);
pub const UCHAR_XID_START: UProperty = UProperty(33i32);
pub const UCHAR_CASE_SENSITIVE: UProperty = UProperty(34i32);
pub const UCHAR_S_TERM: UProperty = UProperty(35i32);
pub const UCHAR_VARIATION_SELECTOR: UProperty = UProperty(36i32);
pub const UCHAR_NFD_INERT: UProperty = UProperty(37i32);
pub const UCHAR_NFKD_INERT: UProperty = UProperty(38i32);
pub const UCHAR_NFC_INERT: UProperty = UProperty(39i32);
pub const UCHAR_NFKC_INERT: UProperty = UProperty(40i32);
pub const UCHAR_SEGMENT_STARTER: UProperty = UProperty(41i32);
pub const UCHAR_PATTERN_SYNTAX: UProperty = UProperty(42i32);
pub const UCHAR_PATTERN_WHITE_SPACE: UProperty = UProperty(43i32);
pub const UCHAR_POSIX_ALNUM: UProperty = UProperty(44i32);
pub const UCHAR_POSIX_BLANK: UProperty = UProperty(45i32);
pub const UCHAR_POSIX_GRAPH: UProperty = UProperty(46i32);
pub const UCHAR_POSIX_PRINT: UProperty = UProperty(47i32);
pub const UCHAR_POSIX_XDIGIT: UProperty = UProperty(48i32);
pub const UCHAR_CASED: UProperty = UProperty(49i32);
pub const UCHAR_CASE_IGNORABLE: UProperty = UProperty(50i32);
pub const UCHAR_CHANGES_WHEN_LOWERCASED: UProperty = UProperty(51i32);
pub const UCHAR_CHANGES_WHEN_UPPERCASED: UProperty = UProperty(52i32);
pub const UCHAR_CHANGES_WHEN_TITLECASED: UProperty = UProperty(53i32);
pub const UCHAR_CHANGES_WHEN_CASEFOLDED: UProperty = UProperty(54i32);
pub const UCHAR_CHANGES_WHEN_CASEMAPPED: UProperty = UProperty(55i32);
pub const UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED: UProperty = UProperty(56i32);
pub const UCHAR_EMOJI: UProperty = UProperty(57i32);
pub const UCHAR_EMOJI_PRESENTATION: UProperty = UProperty(58i32);
pub const UCHAR_EMOJI_MODIFIER: UProperty = UProperty(59i32);
pub const UCHAR_EMOJI_MODIFIER_BASE: UProperty = UProperty(60i32);
pub const UCHAR_EMOJI_COMPONENT: UProperty = UProperty(61i32);
pub const UCHAR_REGIONAL_INDICATOR: UProperty = UProperty(62i32);
pub const UCHAR_PREPENDED_CONCATENATION_MARK: UProperty = UProperty(63i32);
pub const UCHAR_EXTENDED_PICTOGRAPHIC: UProperty = UProperty(64i32);
pub const UCHAR_BIDI_CLASS: UProperty = UProperty(4096i32);
pub const UCHAR_INT_START: UProperty = UProperty(4096i32);
pub const UCHAR_BLOCK: UProperty = UProperty(4097i32);
pub const UCHAR_CANONICAL_COMBINING_CLASS: UProperty = UProperty(4098i32);
pub const UCHAR_DECOMPOSITION_TYPE: UProperty = UProperty(4099i32);
pub const UCHAR_EAST_ASIAN_WIDTH: UProperty = UProperty(4100i32);
pub const UCHAR_GENERAL_CATEGORY: UProperty = UProperty(4101i32);
pub const UCHAR_JOINING_GROUP: UProperty = UProperty(4102i32);
pub const UCHAR_JOINING_TYPE: UProperty = UProperty(4103i32);
pub const UCHAR_LINE_BREAK: UProperty = UProperty(4104i32);
pub const UCHAR_NUMERIC_TYPE: UProperty = UProperty(4105i32);
pub const UCHAR_SCRIPT: UProperty = UProperty(4106i32);
pub const UCHAR_HANGUL_SYLLABLE_TYPE: UProperty = UProperty(4107i32);
pub const UCHAR_NFD_QUICK_CHECK: UProperty = UProperty(4108i32);
pub const UCHAR_NFKD_QUICK_CHECK: UProperty = UProperty(4109i32);
pub const UCHAR_NFC_QUICK_CHECK: UProperty = UProperty(4110i32);
pub const UCHAR_NFKC_QUICK_CHECK: UProperty = UProperty(4111i32);
pub const UCHAR_LEAD_CANONICAL_COMBINING_CLASS: UProperty = UProperty(4112i32);
pub const UCHAR_TRAIL_CANONICAL_COMBINING_CLASS: UProperty = UProperty(4113i32);
pub const UCHAR_GRAPHEME_CLUSTER_BREAK: UProperty = UProperty(4114i32);
pub const UCHAR_SENTENCE_BREAK: UProperty = UProperty(4115i32);
pub const UCHAR_WORD_BREAK: UProperty = UProperty(4116i32);
pub const UCHAR_BIDI_PAIRED_BRACKET_TYPE: UProperty = UProperty(4117i32);
pub const UCHAR_INDIC_POSITIONAL_CATEGORY: UProperty = UProperty(4118i32);
pub const UCHAR_INDIC_SYLLABIC_CATEGORY: UProperty = UProperty(4119i32);
pub const UCHAR_VERTICAL_ORIENTATION: UProperty = UProperty(4120i32);
pub const UCHAR_GENERAL_CATEGORY_MASK: UProperty = UProperty(8192i32);
pub const UCHAR_MASK_START: UProperty = UProperty(8192i32);
pub const UCHAR_NUMERIC_VALUE: UProperty = UProperty(12288i32);
pub const UCHAR_DOUBLE_START: UProperty = UProperty(12288i32);
pub const UCHAR_AGE: UProperty = UProperty(16384i32);
pub const UCHAR_STRING_START: UProperty = UProperty(16384i32);
pub const UCHAR_BIDI_MIRRORING_GLYPH: UProperty = UProperty(16385i32);
pub const UCHAR_CASE_FOLDING: UProperty = UProperty(16386i32);
pub const UCHAR_LOWERCASE_MAPPING: UProperty = UProperty(16388i32);
pub const UCHAR_NAME: UProperty = UProperty(16389i32);
pub const UCHAR_SIMPLE_CASE_FOLDING: UProperty = UProperty(16390i32);
pub const UCHAR_SIMPLE_LOWERCASE_MAPPING: UProperty = UProperty(16391i32);
pub const UCHAR_SIMPLE_TITLECASE_MAPPING: UProperty = UProperty(16392i32);
pub const UCHAR_SIMPLE_UPPERCASE_MAPPING: UProperty = UProperty(16393i32);
pub const UCHAR_TITLECASE_MAPPING: UProperty = UProperty(16394i32);
pub const UCHAR_UPPERCASE_MAPPING: UProperty = UProperty(16396i32);
pub const UCHAR_BIDI_PAIRED_BRACKET: UProperty = UProperty(16397i32);
pub const UCHAR_SCRIPT_EXTENSIONS: UProperty = UProperty(28672i32);
pub const UCHAR_OTHER_PROPERTY_START: UProperty = UProperty(28672i32);
pub const UCHAR_INVALID_CODE: UProperty = UProperty(-1i32);
impl ::std::convert::From<i32> for UProperty {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UProperty {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UPropertyNameChoice(pub i32);
pub const U_SHORT_PROPERTY_NAME: UPropertyNameChoice = UPropertyNameChoice(0i32);
pub const U_LONG_PROPERTY_NAME: UPropertyNameChoice = UPropertyNameChoice(1i32);
impl ::std::convert::From<i32> for UPropertyNameChoice {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UPropertyNameChoice {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type URegexFindProgressCallback = unsafe extern "system" fn(context: *const ::std::ffi::c_void, matchindex: i64) -> i8;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type URegexMatchCallback = unsafe extern "system" fn(context: *const ::std::ffi::c_void, steps: i32) -> i8;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct URegexpFlag(pub i32);
pub const UREGEX_CASE_INSENSITIVE: URegexpFlag = URegexpFlag(2i32);
pub const UREGEX_COMMENTS: URegexpFlag = URegexpFlag(4i32);
pub const UREGEX_DOTALL: URegexpFlag = URegexpFlag(32i32);
pub const UREGEX_LITERAL: URegexpFlag = URegexpFlag(16i32);
pub const UREGEX_MULTILINE: URegexpFlag = URegexpFlag(8i32);
pub const UREGEX_UNIX_LINES: URegexpFlag = URegexpFlag(1i32);
pub const UREGEX_UWORD: URegexpFlag = URegexpFlag(256i32);
pub const UREGEX_ERROR_ON_UNKNOWN_ESCAPES: URegexpFlag = URegexpFlag(512i32);
impl ::std::convert::From<i32> for URegexpFlag {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for URegexpFlag {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct URegion(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct URegionType(pub i32);
pub const URGN_UNKNOWN: URegionType = URegionType(0i32);
pub const URGN_TERRITORY: URegionType = URegionType(1i32);
pub const URGN_WORLD: URegionType = URegionType(2i32);
pub const URGN_CONTINENT: URegionType = URegionType(3i32);
pub const URGN_SUBCONTINENT: URegionType = URegionType(4i32);
pub const URGN_GROUPING: URegionType = URegionType(5i32);
pub const URGN_DEPRECATED: URegionType = URegionType(6i32);
impl ::std::convert::From<i32> for URegionType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for URegionType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct URegularExpression(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct URelativeDateTimeFormatter(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct URelativeDateTimeFormatterField(pub i32);
pub const UDAT_REL_LITERAL_FIELD: URelativeDateTimeFormatterField = URelativeDateTimeFormatterField(0i32);
pub const UDAT_REL_NUMERIC_FIELD: URelativeDateTimeFormatterField = URelativeDateTimeFormatterField(1i32);
impl ::std::convert::From<i32> for URelativeDateTimeFormatterField {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for URelativeDateTimeFormatterField {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct URelativeDateTimeUnit(pub i32);
pub const UDAT_REL_UNIT_YEAR: URelativeDateTimeUnit = URelativeDateTimeUnit(0i32);
pub const UDAT_REL_UNIT_QUARTER: URelativeDateTimeUnit = URelativeDateTimeUnit(1i32);
pub const UDAT_REL_UNIT_MONTH: URelativeDateTimeUnit = URelativeDateTimeUnit(2i32);
pub const UDAT_REL_UNIT_WEEK: URelativeDateTimeUnit = URelativeDateTimeUnit(3i32);
pub const UDAT_REL_UNIT_DAY: URelativeDateTimeUnit = URelativeDateTimeUnit(4i32);
pub const UDAT_REL_UNIT_HOUR: URelativeDateTimeUnit = URelativeDateTimeUnit(5i32);
pub const UDAT_REL_UNIT_MINUTE: URelativeDateTimeUnit = URelativeDateTimeUnit(6i32);
pub const UDAT_REL_UNIT_SECOND: URelativeDateTimeUnit = URelativeDateTimeUnit(7i32);
pub const UDAT_REL_UNIT_SUNDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(8i32);
pub const UDAT_REL_UNIT_MONDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(9i32);
pub const UDAT_REL_UNIT_TUESDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(10i32);
pub const UDAT_REL_UNIT_WEDNESDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(11i32);
pub const UDAT_REL_UNIT_THURSDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(12i32);
pub const UDAT_REL_UNIT_FRIDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(13i32);
pub const UDAT_REL_UNIT_SATURDAY: URelativeDateTimeUnit = URelativeDateTimeUnit(14i32);
impl ::std::convert::From<i32> for URelativeDateTimeUnit {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for URelativeDateTimeUnit {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UReplaceableCallbacks {
    pub length: isize,
    pub charAt: isize,
    pub char32At: isize,
    pub replace: isize,
    pub extract: isize,
    pub copy: isize,
}
impl UReplaceableCallbacks {}
impl ::std::default::Default for UReplaceableCallbacks {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UReplaceableCallbacks {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UReplaceableCallbacks").field("length", &self.length).field("charAt", &self.charAt).field("char32At", &self.char32At).field("replace", &self.replace).field("extract", &self.extract).field("copy", &self.copy).finish()
    }
}
impl ::std::cmp::PartialEq for UReplaceableCallbacks {
    fn eq(&self, other: &Self) -> bool {
        self.length == other.length && self.charAt == other.charAt && self.char32At == other.char32At && self.replace == other.replace && self.extract == other.extract && self.copy == other.copy
    }
}
impl ::std::cmp::Eq for UReplaceableCallbacks {}
unsafe impl ::windows::runtime::Abi for UReplaceableCallbacks {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UResType(pub i32);
pub const URES_NONE: UResType = UResType(-1i32);
pub const URES_STRING: UResType = UResType(0i32);
pub const URES_BINARY: UResType = UResType(1i32);
pub const URES_TABLE: UResType = UResType(2i32);
pub const URES_ALIAS: UResType = UResType(3i32);
pub const URES_INT: UResType = UResType(7i32);
pub const URES_ARRAY: UResType = UResType(8i32);
pub const URES_INT_VECTOR: UResType = UResType(14i32);
impl ::std::convert::From<i32> for UResType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UResType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UResourceBundle(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct URestrictionLevel(pub i32);
pub const USPOOF_ASCII: URestrictionLevel = URestrictionLevel(268435456i32);
pub const USPOOF_SINGLE_SCRIPT_RESTRICTIVE: URestrictionLevel = URestrictionLevel(536870912i32);
pub const USPOOF_HIGHLY_RESTRICTIVE: URestrictionLevel = URestrictionLevel(805306368i32);
pub const USPOOF_MODERATELY_RESTRICTIVE: URestrictionLevel = URestrictionLevel(1073741824i32);
pub const USPOOF_MINIMALLY_RESTRICTIVE: URestrictionLevel = URestrictionLevel(1342177280i32);
pub const USPOOF_UNRESTRICTIVE: URestrictionLevel = URestrictionLevel(1610612736i32);
pub const USPOOF_RESTRICTION_LEVEL_MASK: URestrictionLevel = URestrictionLevel(2130706432i32);
impl ::std::convert::From<i32> for URestrictionLevel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for URestrictionLevel {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USEARCH_DONE: i32 = -1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USET_ADD_CASE_MAPPINGS: i32 = 4i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USET_CASE_INSENSITIVE: i32 = 2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USET_IGNORE_SPACE: i32 = 1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USET_SERIALIZED_STATIC_ARRAY_CAPACITY: i32 = 8i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USPREP_ALLOW_UNASSIGNED: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USPREP_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const USP_E_SCRIPT_NOT_IN_FONT: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147220992i32 as _);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UScriptCode(pub i32);
pub const USCRIPT_INVALID_CODE: UScriptCode = UScriptCode(-1i32);
pub const USCRIPT_COMMON: UScriptCode = UScriptCode(0i32);
pub const USCRIPT_INHERITED: UScriptCode = UScriptCode(1i32);
pub const USCRIPT_ARABIC: UScriptCode = UScriptCode(2i32);
pub const USCRIPT_ARMENIAN: UScriptCode = UScriptCode(3i32);
pub const USCRIPT_BENGALI: UScriptCode = UScriptCode(4i32);
pub const USCRIPT_BOPOMOFO: UScriptCode = UScriptCode(5i32);
pub const USCRIPT_CHEROKEE: UScriptCode = UScriptCode(6i32);
pub const USCRIPT_COPTIC: UScriptCode = UScriptCode(7i32);
pub const USCRIPT_CYRILLIC: UScriptCode = UScriptCode(8i32);
pub const USCRIPT_DESERET: UScriptCode = UScriptCode(9i32);
pub const USCRIPT_DEVANAGARI: UScriptCode = UScriptCode(10i32);
pub const USCRIPT_ETHIOPIC: UScriptCode = UScriptCode(11i32);
pub const USCRIPT_GEORGIAN: UScriptCode = UScriptCode(12i32);
pub const USCRIPT_GOTHIC: UScriptCode = UScriptCode(13i32);
pub const USCRIPT_GREEK: UScriptCode = UScriptCode(14i32);
pub const USCRIPT_GUJARATI: UScriptCode = UScriptCode(15i32);
pub const USCRIPT_GURMUKHI: UScriptCode = UScriptCode(16i32);
pub const USCRIPT_HAN: UScriptCode = UScriptCode(17i32);
pub const USCRIPT_HANGUL: UScriptCode = UScriptCode(18i32);
pub const USCRIPT_HEBREW: UScriptCode = UScriptCode(19i32);
pub const USCRIPT_HIRAGANA: UScriptCode = UScriptCode(20i32);
pub const USCRIPT_KANNADA: UScriptCode = UScriptCode(21i32);
pub const USCRIPT_KATAKANA: UScriptCode = UScriptCode(22i32);
pub const USCRIPT_KHMER: UScriptCode = UScriptCode(23i32);
pub const USCRIPT_LAO: UScriptCode = UScriptCode(24i32);
pub const USCRIPT_LATIN: UScriptCode = UScriptCode(25i32);
pub const USCRIPT_MALAYALAM: UScriptCode = UScriptCode(26i32);
pub const USCRIPT_MONGOLIAN: UScriptCode = UScriptCode(27i32);
pub const USCRIPT_MYANMAR: UScriptCode = UScriptCode(28i32);
pub const USCRIPT_OGHAM: UScriptCode = UScriptCode(29i32);
pub const USCRIPT_OLD_ITALIC: UScriptCode = UScriptCode(30i32);
pub const USCRIPT_ORIYA: UScriptCode = UScriptCode(31i32);
pub const USCRIPT_RUNIC: UScriptCode = UScriptCode(32i32);
pub const USCRIPT_SINHALA: UScriptCode = UScriptCode(33i32);
pub const USCRIPT_SYRIAC: UScriptCode = UScriptCode(34i32);
pub const USCRIPT_TAMIL: UScriptCode = UScriptCode(35i32);
pub const USCRIPT_TELUGU: UScriptCode = UScriptCode(36i32);
pub const USCRIPT_THAANA: UScriptCode = UScriptCode(37i32);
pub const USCRIPT_THAI: UScriptCode = UScriptCode(38i32);
pub const USCRIPT_TIBETAN: UScriptCode = UScriptCode(39i32);
pub const USCRIPT_CANADIAN_ABORIGINAL: UScriptCode = UScriptCode(40i32);
pub const USCRIPT_UCAS: UScriptCode = UScriptCode(40i32);
pub const USCRIPT_YI: UScriptCode = UScriptCode(41i32);
pub const USCRIPT_TAGALOG: UScriptCode = UScriptCode(42i32);
pub const USCRIPT_HANUNOO: UScriptCode = UScriptCode(43i32);
pub const USCRIPT_BUHID: UScriptCode = UScriptCode(44i32);
pub const USCRIPT_TAGBANWA: UScriptCode = UScriptCode(45i32);
pub const USCRIPT_BRAILLE: UScriptCode = UScriptCode(46i32);
pub const USCRIPT_CYPRIOT: UScriptCode = UScriptCode(47i32);
pub const USCRIPT_LIMBU: UScriptCode = UScriptCode(48i32);
pub const USCRIPT_LINEAR_B: UScriptCode = UScriptCode(49i32);
pub const USCRIPT_OSMANYA: UScriptCode = UScriptCode(50i32);
pub const USCRIPT_SHAVIAN: UScriptCode = UScriptCode(51i32);
pub const USCRIPT_TAI_LE: UScriptCode = UScriptCode(52i32);
pub const USCRIPT_UGARITIC: UScriptCode = UScriptCode(53i32);
pub const USCRIPT_KATAKANA_OR_HIRAGANA: UScriptCode = UScriptCode(54i32);
pub const USCRIPT_BUGINESE: UScriptCode = UScriptCode(55i32);
pub const USCRIPT_GLAGOLITIC: UScriptCode = UScriptCode(56i32);
pub const USCRIPT_KHAROSHTHI: UScriptCode = UScriptCode(57i32);
pub const USCRIPT_SYLOTI_NAGRI: UScriptCode = UScriptCode(58i32);
pub const USCRIPT_NEW_TAI_LUE: UScriptCode = UScriptCode(59i32);
pub const USCRIPT_TIFINAGH: UScriptCode = UScriptCode(60i32);
pub const USCRIPT_OLD_PERSIAN: UScriptCode = UScriptCode(61i32);
pub const USCRIPT_BALINESE: UScriptCode = UScriptCode(62i32);
pub const USCRIPT_BATAK: UScriptCode = UScriptCode(63i32);
pub const USCRIPT_BLISSYMBOLS: UScriptCode = UScriptCode(64i32);
pub const USCRIPT_BRAHMI: UScriptCode = UScriptCode(65i32);
pub const USCRIPT_CHAM: UScriptCode = UScriptCode(66i32);
pub const USCRIPT_CIRTH: UScriptCode = UScriptCode(67i32);
pub const USCRIPT_OLD_CHURCH_SLAVONIC_CYRILLIC: UScriptCode = UScriptCode(68i32);
pub const USCRIPT_DEMOTIC_EGYPTIAN: UScriptCode = UScriptCode(69i32);
pub const USCRIPT_HIERATIC_EGYPTIAN: UScriptCode = UScriptCode(70i32);
pub const USCRIPT_EGYPTIAN_HIEROGLYPHS: UScriptCode = UScriptCode(71i32);
pub const USCRIPT_KHUTSURI: UScriptCode = UScriptCode(72i32);
pub const USCRIPT_SIMPLIFIED_HAN: UScriptCode = UScriptCode(73i32);
pub const USCRIPT_TRADITIONAL_HAN: UScriptCode = UScriptCode(74i32);
pub const USCRIPT_PAHAWH_HMONG: UScriptCode = UScriptCode(75i32);
pub const USCRIPT_OLD_HUNGARIAN: UScriptCode = UScriptCode(76i32);
pub const USCRIPT_HARAPPAN_INDUS: UScriptCode = UScriptCode(77i32);
pub const USCRIPT_JAVANESE: UScriptCode = UScriptCode(78i32);
pub const USCRIPT_KAYAH_LI: UScriptCode = UScriptCode(79i32);
pub const USCRIPT_LATIN_FRAKTUR: UScriptCode = UScriptCode(80i32);
pub const USCRIPT_LATIN_GAELIC: UScriptCode = UScriptCode(81i32);
pub const USCRIPT_LEPCHA: UScriptCode = UScriptCode(82i32);
pub const USCRIPT_LINEAR_A: UScriptCode = UScriptCode(83i32);
pub const USCRIPT_MANDAIC: UScriptCode = UScriptCode(84i32);
pub const USCRIPT_MANDAEAN: UScriptCode = UScriptCode(84i32);
pub const USCRIPT_MAYAN_HIEROGLYPHS: UScriptCode = UScriptCode(85i32);
pub const USCRIPT_MEROITIC_HIEROGLYPHS: UScriptCode = UScriptCode(86i32);
pub const USCRIPT_MEROITIC: UScriptCode = UScriptCode(86i32);
pub const USCRIPT_NKO: UScriptCode = UScriptCode(87i32);
pub const USCRIPT_ORKHON: UScriptCode = UScriptCode(88i32);
pub const USCRIPT_OLD_PERMIC: UScriptCode = UScriptCode(89i32);
pub const USCRIPT_PHAGS_PA: UScriptCode = UScriptCode(90i32);
pub const USCRIPT_PHOENICIAN: UScriptCode = UScriptCode(91i32);
pub const USCRIPT_MIAO: UScriptCode = UScriptCode(92i32);
pub const USCRIPT_PHONETIC_POLLARD: UScriptCode = UScriptCode(92i32);
pub const USCRIPT_RONGORONGO: UScriptCode = UScriptCode(93i32);
pub const USCRIPT_SARATI: UScriptCode = UScriptCode(94i32);
pub const USCRIPT_ESTRANGELO_SYRIAC: UScriptCode = UScriptCode(95i32);
pub const USCRIPT_WESTERN_SYRIAC: UScriptCode = UScriptCode(96i32);
pub const USCRIPT_EASTERN_SYRIAC: UScriptCode = UScriptCode(97i32);
pub const USCRIPT_TENGWAR: UScriptCode = UScriptCode(98i32);
pub const USCRIPT_VAI: UScriptCode = UScriptCode(99i32);
pub const USCRIPT_VISIBLE_SPEECH: UScriptCode = UScriptCode(100i32);
pub const USCRIPT_CUNEIFORM: UScriptCode = UScriptCode(101i32);
pub const USCRIPT_UNWRITTEN_LANGUAGES: UScriptCode = UScriptCode(102i32);
pub const USCRIPT_UNKNOWN: UScriptCode = UScriptCode(103i32);
pub const USCRIPT_CARIAN: UScriptCode = UScriptCode(104i32);
pub const USCRIPT_JAPANESE: UScriptCode = UScriptCode(105i32);
pub const USCRIPT_LANNA: UScriptCode = UScriptCode(106i32);
pub const USCRIPT_LYCIAN: UScriptCode = UScriptCode(107i32);
pub const USCRIPT_LYDIAN: UScriptCode = UScriptCode(108i32);
pub const USCRIPT_OL_CHIKI: UScriptCode = UScriptCode(109i32);
pub const USCRIPT_REJANG: UScriptCode = UScriptCode(110i32);
pub const USCRIPT_SAURASHTRA: UScriptCode = UScriptCode(111i32);
pub const USCRIPT_SIGN_WRITING: UScriptCode = UScriptCode(112i32);
pub const USCRIPT_SUNDANESE: UScriptCode = UScriptCode(113i32);
pub const USCRIPT_MOON: UScriptCode = UScriptCode(114i32);
pub const USCRIPT_MEITEI_MAYEK: UScriptCode = UScriptCode(115i32);
pub const USCRIPT_IMPERIAL_ARAMAIC: UScriptCode = UScriptCode(116i32);
pub const USCRIPT_AVESTAN: UScriptCode = UScriptCode(117i32);
pub const USCRIPT_CHAKMA: UScriptCode = UScriptCode(118i32);
pub const USCRIPT_KOREAN: UScriptCode = UScriptCode(119i32);
pub const USCRIPT_KAITHI: UScriptCode = UScriptCode(120i32);
pub const USCRIPT_MANICHAEAN: UScriptCode = UScriptCode(121i32);
pub const USCRIPT_INSCRIPTIONAL_PAHLAVI: UScriptCode = UScriptCode(122i32);
pub const USCRIPT_PSALTER_PAHLAVI: UScriptCode = UScriptCode(123i32);
pub const USCRIPT_BOOK_PAHLAVI: UScriptCode = UScriptCode(124i32);
pub const USCRIPT_INSCRIPTIONAL_PARTHIAN: UScriptCode = UScriptCode(125i32);
pub const USCRIPT_SAMARITAN: UScriptCode = UScriptCode(126i32);
pub const USCRIPT_TAI_VIET: UScriptCode = UScriptCode(127i32);
pub const USCRIPT_MATHEMATICAL_NOTATION: UScriptCode = UScriptCode(128i32);
pub const USCRIPT_SYMBOLS: UScriptCode = UScriptCode(129i32);
pub const USCRIPT_BAMUM: UScriptCode = UScriptCode(130i32);
pub const USCRIPT_LISU: UScriptCode = UScriptCode(131i32);
pub const USCRIPT_NAKHI_GEBA: UScriptCode = UScriptCode(132i32);
pub const USCRIPT_OLD_SOUTH_ARABIAN: UScriptCode = UScriptCode(133i32);
pub const USCRIPT_BASSA_VAH: UScriptCode = UScriptCode(134i32);
pub const USCRIPT_DUPLOYAN: UScriptCode = UScriptCode(135i32);
pub const USCRIPT_ELBASAN: UScriptCode = UScriptCode(136i32);
pub const USCRIPT_GRANTHA: UScriptCode = UScriptCode(137i32);
pub const USCRIPT_KPELLE: UScriptCode = UScriptCode(138i32);
pub const USCRIPT_LOMA: UScriptCode = UScriptCode(139i32);
pub const USCRIPT_MENDE: UScriptCode = UScriptCode(140i32);
pub const USCRIPT_MEROITIC_CURSIVE: UScriptCode = UScriptCode(141i32);
pub const USCRIPT_OLD_NORTH_ARABIAN: UScriptCode = UScriptCode(142i32);
pub const USCRIPT_NABATAEAN: UScriptCode = UScriptCode(143i32);
pub const USCRIPT_PALMYRENE: UScriptCode = UScriptCode(144i32);
pub const USCRIPT_KHUDAWADI: UScriptCode = UScriptCode(145i32);
pub const USCRIPT_SINDHI: UScriptCode = UScriptCode(145i32);
pub const USCRIPT_WARANG_CITI: UScriptCode = UScriptCode(146i32);
pub const USCRIPT_AFAKA: UScriptCode = UScriptCode(147i32);
pub const USCRIPT_JURCHEN: UScriptCode = UScriptCode(148i32);
pub const USCRIPT_MRO: UScriptCode = UScriptCode(149i32);
pub const USCRIPT_NUSHU: UScriptCode = UScriptCode(150i32);
pub const USCRIPT_SHARADA: UScriptCode = UScriptCode(151i32);
pub const USCRIPT_SORA_SOMPENG: UScriptCode = UScriptCode(152i32);
pub const USCRIPT_TAKRI: UScriptCode = UScriptCode(153i32);
pub const USCRIPT_TANGUT: UScriptCode = UScriptCode(154i32);
pub const USCRIPT_WOLEAI: UScriptCode = UScriptCode(155i32);
pub const USCRIPT_ANATOLIAN_HIEROGLYPHS: UScriptCode = UScriptCode(156i32);
pub const USCRIPT_KHOJKI: UScriptCode = UScriptCode(157i32);
pub const USCRIPT_TIRHUTA: UScriptCode = UScriptCode(158i32);
pub const USCRIPT_CAUCASIAN_ALBANIAN: UScriptCode = UScriptCode(159i32);
pub const USCRIPT_MAHAJANI: UScriptCode = UScriptCode(160i32);
pub const USCRIPT_AHOM: UScriptCode = UScriptCode(161i32);
pub const USCRIPT_HATRAN: UScriptCode = UScriptCode(162i32);
pub const USCRIPT_MODI: UScriptCode = UScriptCode(163i32);
pub const USCRIPT_MULTANI: UScriptCode = UScriptCode(164i32);
pub const USCRIPT_PAU_CIN_HAU: UScriptCode = UScriptCode(165i32);
pub const USCRIPT_SIDDHAM: UScriptCode = UScriptCode(166i32);
pub const USCRIPT_ADLAM: UScriptCode = UScriptCode(167i32);
pub const USCRIPT_BHAIKSUKI: UScriptCode = UScriptCode(168i32);
pub const USCRIPT_MARCHEN: UScriptCode = UScriptCode(169i32);
pub const USCRIPT_NEWA: UScriptCode = UScriptCode(170i32);
pub const USCRIPT_OSAGE: UScriptCode = UScriptCode(171i32);
pub const USCRIPT_HAN_WITH_BOPOMOFO: UScriptCode = UScriptCode(172i32);
pub const USCRIPT_JAMO: UScriptCode = UScriptCode(173i32);
pub const USCRIPT_SYMBOLS_EMOJI: UScriptCode = UScriptCode(174i32);
pub const USCRIPT_MASARAM_GONDI: UScriptCode = UScriptCode(175i32);
pub const USCRIPT_SOYOMBO: UScriptCode = UScriptCode(176i32);
pub const USCRIPT_ZANABAZAR_SQUARE: UScriptCode = UScriptCode(177i32);
pub const USCRIPT_DOGRA: UScriptCode = UScriptCode(178i32);
pub const USCRIPT_GUNJALA_GONDI: UScriptCode = UScriptCode(179i32);
pub const USCRIPT_MAKASAR: UScriptCode = UScriptCode(180i32);
pub const USCRIPT_MEDEFAIDRIN: UScriptCode = UScriptCode(181i32);
pub const USCRIPT_HANIFI_ROHINGYA: UScriptCode = UScriptCode(182i32);
pub const USCRIPT_SOGDIAN: UScriptCode = UScriptCode(183i32);
pub const USCRIPT_OLD_SOGDIAN: UScriptCode = UScriptCode(184i32);
pub const USCRIPT_ELYMAIC: UScriptCode = UScriptCode(185i32);
pub const USCRIPT_NYIAKENG_PUACHUE_HMONG: UScriptCode = UScriptCode(186i32);
pub const USCRIPT_NANDINAGARI: UScriptCode = UScriptCode(187i32);
pub const USCRIPT_WANCHO: UScriptCode = UScriptCode(188i32);
pub const USCRIPT_CHORASMIAN: UScriptCode = UScriptCode(189i32);
pub const USCRIPT_DIVES_AKURU: UScriptCode = UScriptCode(190i32);
pub const USCRIPT_KHITAN_SMALL_SCRIPT: UScriptCode = UScriptCode(191i32);
pub const USCRIPT_YEZIDI: UScriptCode = UScriptCode(192i32);
impl ::std::convert::From<i32> for UScriptCode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UScriptCode {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UScriptUsage(pub i32);
pub const USCRIPT_USAGE_NOT_ENCODED: UScriptUsage = UScriptUsage(0i32);
pub const USCRIPT_USAGE_UNKNOWN: UScriptUsage = UScriptUsage(1i32);
pub const USCRIPT_USAGE_EXCLUDED: UScriptUsage = UScriptUsage(2i32);
pub const USCRIPT_USAGE_LIMITED_USE: UScriptUsage = UScriptUsage(3i32);
pub const USCRIPT_USAGE_ASPIRATIONAL: UScriptUsage = UScriptUsage(4i32);
pub const USCRIPT_USAGE_RECOMMENDED: UScriptUsage = UScriptUsage(5i32);
impl ::std::convert::From<i32> for UScriptUsage {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UScriptUsage {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct USearch(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USearchAttribute(pub i32);
pub const USEARCH_OVERLAP: USearchAttribute = USearchAttribute(0i32);
pub const USEARCH_ELEMENT_COMPARISON: USearchAttribute = USearchAttribute(2i32);
impl ::std::convert::From<i32> for USearchAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USearchAttribute {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USearchAttributeValue(pub i32);
pub const USEARCH_DEFAULT: USearchAttributeValue = USearchAttributeValue(-1i32);
pub const USEARCH_OFF: USearchAttributeValue = USearchAttributeValue(0i32);
pub const USEARCH_ON: USearchAttributeValue = USearchAttributeValue(1i32);
pub const USEARCH_STANDARD_ELEMENT_COMPARISON: USearchAttributeValue = USearchAttributeValue(2i32);
pub const USEARCH_PATTERN_BASE_WEIGHT_IS_WILDCARD: USearchAttributeValue = USearchAttributeValue(3i32);
pub const USEARCH_ANY_BASE_WEIGHT_IS_WILDCARD: USearchAttributeValue = USearchAttributeValue(4i32);
impl ::std::convert::From<i32> for USearchAttributeValue {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USearchAttributeValue {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USentenceBreak(pub i32);
pub const U_SB_OTHER: USentenceBreak = USentenceBreak(0i32);
pub const U_SB_ATERM: USentenceBreak = USentenceBreak(1i32);
pub const U_SB_CLOSE: USentenceBreak = USentenceBreak(2i32);
pub const U_SB_FORMAT: USentenceBreak = USentenceBreak(3i32);
pub const U_SB_LOWER: USentenceBreak = USentenceBreak(4i32);
pub const U_SB_NUMERIC: USentenceBreak = USentenceBreak(5i32);
pub const U_SB_OLETTER: USentenceBreak = USentenceBreak(6i32);
pub const U_SB_SEP: USentenceBreak = USentenceBreak(7i32);
pub const U_SB_SP: USentenceBreak = USentenceBreak(8i32);
pub const U_SB_STERM: USentenceBreak = USentenceBreak(9i32);
pub const U_SB_UPPER: USentenceBreak = USentenceBreak(10i32);
pub const U_SB_CR: USentenceBreak = USentenceBreak(11i32);
pub const U_SB_EXTEND: USentenceBreak = USentenceBreak(12i32);
pub const U_SB_LF: USentenceBreak = USentenceBreak(13i32);
pub const U_SB_SCONTINUE: USentenceBreak = USentenceBreak(14i32);
impl ::std::convert::From<i32> for USentenceBreak {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USentenceBreak {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USentenceBreakTag(pub i32);
pub const UBRK_SENTENCE_TERM: USentenceBreakTag = USentenceBreakTag(0i32);
pub const UBRK_SENTENCE_TERM_LIMIT: USentenceBreakTag = USentenceBreakTag(100i32);
pub const UBRK_SENTENCE_SEP: USentenceBreakTag = USentenceBreakTag(100i32);
pub const UBRK_SENTENCE_SEP_LIMIT: USentenceBreakTag = USentenceBreakTag(200i32);
impl ::std::convert::From<i32> for USentenceBreakTag {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USentenceBreakTag {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct USerializedSet {
    pub array: *mut u16,
    pub bmpLength: i32,
    pub length: i32,
    pub staticArray: [u16; 8],
}
impl USerializedSet {}
impl ::std::default::Default for USerializedSet {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for USerializedSet {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("USerializedSet").field("array", &self.array).field("bmpLength", &self.bmpLength).field("length", &self.length).field("staticArray", &self.staticArray).finish()
    }
}
impl ::std::cmp::PartialEq for USerializedSet {
    fn eq(&self, other: &Self) -> bool {
        self.array == other.array && self.bmpLength == other.bmpLength && self.length == other.length && self.staticArray == other.staticArray
    }
}
impl ::std::cmp::Eq for USerializedSet {}
unsafe impl ::windows::runtime::Abi for USerializedSet {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct USet(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USetSpanCondition(pub i32);
pub const USET_SPAN_NOT_CONTAINED: USetSpanCondition = USetSpanCondition(0i32);
pub const USET_SPAN_CONTAINED: USetSpanCondition = USetSpanCondition(1i32);
pub const USET_SPAN_SIMPLE: USetSpanCondition = USetSpanCondition(2i32);
impl ::std::convert::From<i32> for USetSpanCondition {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USetSpanCondition {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct USpoofCheckResult(pub u8);
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct USpoofChecker(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USpoofChecks(pub i32);
pub const USPOOF_SINGLE_SCRIPT_CONFUSABLE: USpoofChecks = USpoofChecks(1i32);
pub const USPOOF_MIXED_SCRIPT_CONFUSABLE: USpoofChecks = USpoofChecks(2i32);
pub const USPOOF_WHOLE_SCRIPT_CONFUSABLE: USpoofChecks = USpoofChecks(4i32);
pub const USPOOF_CONFUSABLE: USpoofChecks = USpoofChecks(7i32);
pub const USPOOF_RESTRICTION_LEVEL: USpoofChecks = USpoofChecks(16i32);
pub const USPOOF_INVISIBLE: USpoofChecks = USpoofChecks(32i32);
pub const USPOOF_CHAR_LIMIT: USpoofChecks = USpoofChecks(64i32);
pub const USPOOF_MIXED_NUMBERS: USpoofChecks = USpoofChecks(128i32);
pub const USPOOF_HIDDEN_OVERLAY: USpoofChecks = USpoofChecks(256i32);
pub const USPOOF_ALL_CHECKS: USpoofChecks = USpoofChecks(65535i32);
pub const USPOOF_AUX_INFO: USpoofChecks = USpoofChecks(1073741824i32);
impl ::std::convert::From<i32> for USpoofChecks {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USpoofChecks {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UStringCaseMapper = unsafe extern "system" fn(csm: *const UCaseMap, dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UStringPrepProfile(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UStringPrepProfileType(pub i32);
pub const USPREP_RFC3491_NAMEPREP: UStringPrepProfileType = UStringPrepProfileType(0i32);
pub const USPREP_RFC3530_NFS4_CS_PREP: UStringPrepProfileType = UStringPrepProfileType(1i32);
pub const USPREP_RFC3530_NFS4_CS_PREP_CI: UStringPrepProfileType = UStringPrepProfileType(2i32);
pub const USPREP_RFC3530_NFS4_CIS_PREP: UStringPrepProfileType = UStringPrepProfileType(3i32);
pub const USPREP_RFC3530_NFS4_MIXED_PREP_PREFIX: UStringPrepProfileType = UStringPrepProfileType(4i32);
pub const USPREP_RFC3530_NFS4_MIXED_PREP_SUFFIX: UStringPrepProfileType = UStringPrepProfileType(5i32);
pub const USPREP_RFC3722_ISCSI: UStringPrepProfileType = UStringPrepProfileType(6i32);
pub const USPREP_RFC3920_NODEPREP: UStringPrepProfileType = UStringPrepProfileType(7i32);
pub const USPREP_RFC3920_RESOURCEPREP: UStringPrepProfileType = UStringPrepProfileType(8i32);
pub const USPREP_RFC4011_MIB: UStringPrepProfileType = UStringPrepProfileType(9i32);
pub const USPREP_RFC4013_SASLPREP: UStringPrepProfileType = UStringPrepProfileType(10i32);
pub const USPREP_RFC4505_TRACE: UStringPrepProfileType = UStringPrepProfileType(11i32);
pub const USPREP_RFC4518_LDAP: UStringPrepProfileType = UStringPrepProfileType(12i32);
pub const USPREP_RFC4518_LDAP_CI: UStringPrepProfileType = UStringPrepProfileType(13i32);
impl ::std::convert::From<i32> for UStringPrepProfileType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UStringPrepProfileType {
    type Abi = Self;
}
#[repr(C)]
#[derive(:: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug, :: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy)]
pub struct UStringSearch(pub u8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UStringTrieBuildOption(pub i32);
pub const USTRINGTRIE_BUILD_FAST: UStringTrieBuildOption = UStringTrieBuildOption(0i32);
pub const USTRINGTRIE_BUILD_SMALL: UStringTrieBuildOption = UStringTrieBuildOption(1i32);
impl ::std::convert::From<i32> for UStringTrieBuildOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UStringTrieBuildOption {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UStringTrieResult(pub i32);
pub const USTRINGTRIE_NO_MATCH: UStringTrieResult = UStringTrieResult(0i32);
pub const USTRINGTRIE_NO_VALUE: UStringTrieResult = UStringTrieResult(1i32);
pub const USTRINGTRIE_FINAL_VALUE: UStringTrieResult = UStringTrieResult(2i32);
pub const USTRINGTRIE_INTERMEDIATE_VALUE: UStringTrieResult = UStringTrieResult(3i32);
impl ::std::convert::From<i32> for UStringTrieResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UStringTrieResult {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct USystemTimeZoneType(pub i32);
pub const UCAL_ZONE_TYPE_ANY: USystemTimeZoneType = USystemTimeZoneType(0i32);
pub const UCAL_ZONE_TYPE_CANONICAL: USystemTimeZoneType = USystemTimeZoneType(1i32);
pub const UCAL_ZONE_TYPE_CANONICAL_LOCATION: USystemTimeZoneType = USystemTimeZoneType(2i32);
impl ::std::convert::From<i32> for USystemTimeZoneType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for USystemTimeZoneType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_MAGIC: i32 = 878368812i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_PROVIDER_HAS_META_DATA: i32 = 4i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_PROVIDER_LENGTH_IS_EXPENSIVE: i32 = 1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_PROVIDER_OWNS_TEXT: i32 = 5i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_PROVIDER_STABLE_CHUNKS: i32 = 2i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTEXT_PROVIDER_WRITABLE: i32 = 3i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF16_MAX_CHAR_LENGTH: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF32_MAX_CHAR_LENGTH: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF8_ERROR_VALUE_1: u32 = 21u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF8_ERROR_VALUE_2: u32 = 159u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF8_MAX_CHAR_LENGTH: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF_ERROR_VALUE: u32 = 65535u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF_MAX_CHAR_LENGTH: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const UTF_SIZE: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UText {
    pub magic: u32,
    pub flags: i32,
    pub providerProperties: i32,
    pub sizeOfStruct: i32,
    pub chunkNativeLimit: i64,
    pub extraSize: i32,
    pub nativeIndexingLimit: i32,
    pub chunkNativeStart: i64,
    pub chunkOffset: i32,
    pub chunkLength: i32,
    pub chunkContents: *mut u16,
    pub pFuncs: *mut UTextFuncs,
    pub pExtra: *mut ::std::ffi::c_void,
    pub context: *mut ::std::ffi::c_void,
    pub p: *mut ::std::ffi::c_void,
    pub q: *mut ::std::ffi::c_void,
    pub r: *mut ::std::ffi::c_void,
    pub privP: *mut ::std::ffi::c_void,
    pub a: i64,
    pub b: i32,
    pub c: i32,
    pub privA: i64,
    pub privB: i32,
    pub privC: i32,
}
impl UText {}
impl ::std::default::Default for UText {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UText {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UText")
            .field("magic", &self.magic)
            .field("flags", &self.flags)
            .field("providerProperties", &self.providerProperties)
            .field("sizeOfStruct", &self.sizeOfStruct)
            .field("chunkNativeLimit", &self.chunkNativeLimit)
            .field("extraSize", &self.extraSize)
            .field("nativeIndexingLimit", &self.nativeIndexingLimit)
            .field("chunkNativeStart", &self.chunkNativeStart)
            .field("chunkOffset", &self.chunkOffset)
            .field("chunkLength", &self.chunkLength)
            .field("chunkContents", &self.chunkContents)
            .field("pFuncs", &self.pFuncs)
            .field("pExtra", &self.pExtra)
            .field("context", &self.context)
            .field("p", &self.p)
            .field("q", &self.q)
            .field("r", &self.r)
            .field("privP", &self.privP)
            .field("a", &self.a)
            .field("b", &self.b)
            .field("c", &self.c)
            .field("privA", &self.privA)
            .field("privB", &self.privB)
            .field("privC", &self.privC)
            .finish()
    }
}
impl ::std::cmp::PartialEq for UText {
    fn eq(&self, other: &Self) -> bool {
        self.magic == other.magic
            && self.flags == other.flags
            && self.providerProperties == other.providerProperties
            && self.sizeOfStruct == other.sizeOfStruct
            && self.chunkNativeLimit == other.chunkNativeLimit
            && self.extraSize == other.extraSize
            && self.nativeIndexingLimit == other.nativeIndexingLimit
            && self.chunkNativeStart == other.chunkNativeStart
            && self.chunkOffset == other.chunkOffset
            && self.chunkLength == other.chunkLength
            && self.chunkContents == other.chunkContents
            && self.pFuncs == other.pFuncs
            && self.pExtra == other.pExtra
            && self.context == other.context
            && self.p == other.p
            && self.q == other.q
            && self.r == other.r
            && self.privP == other.privP
            && self.a == other.a
            && self.b == other.b
            && self.c == other.c
            && self.privA == other.privA
            && self.privB == other.privB
            && self.privC == other.privC
    }
}
impl ::std::cmp::Eq for UText {}
unsafe impl ::windows::runtime::Abi for UText {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextAccess = unsafe extern "system" fn(ut: *mut UText, nativeindex: i64, forward: i8) -> i8;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextClone = unsafe extern "system" fn(dest: *mut UText, src: *const UText, deep: i8, status: *mut UErrorCode) -> *mut UText;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextClose = unsafe extern "system" fn(ut: *mut UText);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextCopy = unsafe extern "system" fn(ut: *mut UText, nativestart: i64, nativelimit: i64, nativedest: i64, r#move: i8, status: *mut UErrorCode);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextExtract = unsafe extern "system" fn(ut: *mut UText, nativestart: i64, nativelimit: i64, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UTextFuncs {
    pub tableSize: i32,
    pub reserved1: i32,
    pub reserved2: i32,
    pub reserved3: i32,
    pub clone: ::std::option::Option<UTextClone>,
    pub nativeLength: ::std::option::Option<UTextNativeLength>,
    pub access: ::std::option::Option<UTextAccess>,
    pub extract: ::std::option::Option<UTextExtract>,
    pub replace: ::std::option::Option<UTextReplace>,
    pub copy: ::std::option::Option<UTextCopy>,
    pub mapOffsetToNative: ::std::option::Option<UTextMapOffsetToNative>,
    pub mapNativeIndexToUTF16: ::std::option::Option<UTextMapNativeIndexToUTF16>,
    pub close: ::std::option::Option<UTextClose>,
    pub spare1: ::std::option::Option<UTextClose>,
    pub spare2: ::std::option::Option<UTextClose>,
    pub spare3: ::std::option::Option<UTextClose>,
}
impl UTextFuncs {}
impl ::std::default::Default for UTextFuncs {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UTextFuncs {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UTextFuncs").field("tableSize", &self.tableSize).field("reserved1", &self.reserved1).field("reserved2", &self.reserved2).field("reserved3", &self.reserved3).finish()
    }
}
impl ::std::cmp::PartialEq for UTextFuncs {
    fn eq(&self, other: &Self) -> bool {
        self.tableSize == other.tableSize
            && self.reserved1 == other.reserved1
            && self.reserved2 == other.reserved2
            && self.reserved3 == other.reserved3
            && self.clone.map(|f| f as usize) == other.clone.map(|f| f as usize)
            && self.nativeLength.map(|f| f as usize) == other.nativeLength.map(|f| f as usize)
            && self.access.map(|f| f as usize) == other.access.map(|f| f as usize)
            && self.extract.map(|f| f as usize) == other.extract.map(|f| f as usize)
            && self.replace.map(|f| f as usize) == other.replace.map(|f| f as usize)
            && self.copy.map(|f| f as usize) == other.copy.map(|f| f as usize)
            && self.mapOffsetToNative.map(|f| f as usize) == other.mapOffsetToNative.map(|f| f as usize)
            && self.mapNativeIndexToUTF16.map(|f| f as usize) == other.mapNativeIndexToUTF16.map(|f| f as usize)
            && self.close.map(|f| f as usize) == other.close.map(|f| f as usize)
            && self.spare1.map(|f| f as usize) == other.spare1.map(|f| f as usize)
            && self.spare2.map(|f| f as usize) == other.spare2.map(|f| f as usize)
            && self.spare3.map(|f| f as usize) == other.spare3.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for UTextFuncs {}
unsafe impl ::windows::runtime::Abi for UTextFuncs {
    type Abi = ::std::mem::ManuallyDrop<Self>;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextMapNativeIndexToUTF16 = unsafe extern "system" fn(ut: *const UText, nativeindex: i64) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextMapOffsetToNative = unsafe extern "system" fn(ut: *const UText) -> i64;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextNativeLength = unsafe extern "system" fn(ut: *mut UText) -> i64;
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTextReplace = unsafe extern "system" fn(ut: *mut UText, nativestart: i64, nativelimit: i64, replacementtext: *const u16, replacmentlength: i32, status: *mut UErrorCode) -> i32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeScaleValue(pub i32);
pub const UTSV_UNITS_VALUE: UTimeScaleValue = UTimeScaleValue(0i32);
pub const UTSV_EPOCH_OFFSET_VALUE: UTimeScaleValue = UTimeScaleValue(1i32);
pub const UTSV_FROM_MIN_VALUE: UTimeScaleValue = UTimeScaleValue(2i32);
pub const UTSV_FROM_MAX_VALUE: UTimeScaleValue = UTimeScaleValue(3i32);
pub const UTSV_TO_MIN_VALUE: UTimeScaleValue = UTimeScaleValue(4i32);
pub const UTSV_TO_MAX_VALUE: UTimeScaleValue = UTimeScaleValue(5i32);
impl ::std::convert::From<i32> for UTimeScaleValue {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeScaleValue {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneFormatGMTOffsetPatternType(pub i32);
pub const UTZFMT_PAT_POSITIVE_HM: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(0i32);
pub const UTZFMT_PAT_POSITIVE_HMS: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(1i32);
pub const UTZFMT_PAT_NEGATIVE_HM: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(2i32);
pub const UTZFMT_PAT_NEGATIVE_HMS: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(3i32);
pub const UTZFMT_PAT_POSITIVE_H: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(4i32);
pub const UTZFMT_PAT_NEGATIVE_H: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(5i32);
pub const UTZFMT_PAT_COUNT: UTimeZoneFormatGMTOffsetPatternType = UTimeZoneFormatGMTOffsetPatternType(6i32);
impl ::std::convert::From<i32> for UTimeZoneFormatGMTOffsetPatternType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneFormatGMTOffsetPatternType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneFormatParseOption(pub i32);
pub const UTZFMT_PARSE_OPTION_NONE: UTimeZoneFormatParseOption = UTimeZoneFormatParseOption(0i32);
pub const UTZFMT_PARSE_OPTION_ALL_STYLES: UTimeZoneFormatParseOption = UTimeZoneFormatParseOption(1i32);
pub const UTZFMT_PARSE_OPTION_TZ_DATABASE_ABBREVIATIONS: UTimeZoneFormatParseOption = UTimeZoneFormatParseOption(2i32);
impl ::std::convert::From<i32> for UTimeZoneFormatParseOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneFormatParseOption {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneFormatStyle(pub i32);
pub const UTZFMT_STYLE_GENERIC_LOCATION: UTimeZoneFormatStyle = UTimeZoneFormatStyle(0i32);
pub const UTZFMT_STYLE_GENERIC_LONG: UTimeZoneFormatStyle = UTimeZoneFormatStyle(1i32);
pub const UTZFMT_STYLE_GENERIC_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(2i32);
pub const UTZFMT_STYLE_SPECIFIC_LONG: UTimeZoneFormatStyle = UTimeZoneFormatStyle(3i32);
pub const UTZFMT_STYLE_SPECIFIC_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(4i32);
pub const UTZFMT_STYLE_LOCALIZED_GMT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(5i32);
pub const UTZFMT_STYLE_LOCALIZED_GMT_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(6i32);
pub const UTZFMT_STYLE_ISO_BASIC_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(7i32);
pub const UTZFMT_STYLE_ISO_BASIC_LOCAL_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(8i32);
pub const UTZFMT_STYLE_ISO_BASIC_FIXED: UTimeZoneFormatStyle = UTimeZoneFormatStyle(9i32);
pub const UTZFMT_STYLE_ISO_BASIC_LOCAL_FIXED: UTimeZoneFormatStyle = UTimeZoneFormatStyle(10i32);
pub const UTZFMT_STYLE_ISO_BASIC_FULL: UTimeZoneFormatStyle = UTimeZoneFormatStyle(11i32);
pub const UTZFMT_STYLE_ISO_BASIC_LOCAL_FULL: UTimeZoneFormatStyle = UTimeZoneFormatStyle(12i32);
pub const UTZFMT_STYLE_ISO_EXTENDED_FIXED: UTimeZoneFormatStyle = UTimeZoneFormatStyle(13i32);
pub const UTZFMT_STYLE_ISO_EXTENDED_LOCAL_FIXED: UTimeZoneFormatStyle = UTimeZoneFormatStyle(14i32);
pub const UTZFMT_STYLE_ISO_EXTENDED_FULL: UTimeZoneFormatStyle = UTimeZoneFormatStyle(15i32);
pub const UTZFMT_STYLE_ISO_EXTENDED_LOCAL_FULL: UTimeZoneFormatStyle = UTimeZoneFormatStyle(16i32);
pub const UTZFMT_STYLE_ZONE_ID: UTimeZoneFormatStyle = UTimeZoneFormatStyle(17i32);
pub const UTZFMT_STYLE_ZONE_ID_SHORT: UTimeZoneFormatStyle = UTimeZoneFormatStyle(18i32);
pub const UTZFMT_STYLE_EXEMPLAR_LOCATION: UTimeZoneFormatStyle = UTimeZoneFormatStyle(19i32);
impl ::std::convert::From<i32> for UTimeZoneFormatStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneFormatStyle {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneFormatTimeType(pub i32);
pub const UTZFMT_TIME_TYPE_UNKNOWN: UTimeZoneFormatTimeType = UTimeZoneFormatTimeType(0i32);
pub const UTZFMT_TIME_TYPE_STANDARD: UTimeZoneFormatTimeType = UTimeZoneFormatTimeType(1i32);
pub const UTZFMT_TIME_TYPE_DAYLIGHT: UTimeZoneFormatTimeType = UTimeZoneFormatTimeType(2i32);
impl ::std::convert::From<i32> for UTimeZoneFormatTimeType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneFormatTimeType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneNameType(pub i32);
pub const UTZNM_UNKNOWN: UTimeZoneNameType = UTimeZoneNameType(0i32);
pub const UTZNM_LONG_GENERIC: UTimeZoneNameType = UTimeZoneNameType(1i32);
pub const UTZNM_LONG_STANDARD: UTimeZoneNameType = UTimeZoneNameType(2i32);
pub const UTZNM_LONG_DAYLIGHT: UTimeZoneNameType = UTimeZoneNameType(4i32);
pub const UTZNM_SHORT_GENERIC: UTimeZoneNameType = UTimeZoneNameType(8i32);
pub const UTZNM_SHORT_STANDARD: UTimeZoneNameType = UTimeZoneNameType(16i32);
pub const UTZNM_SHORT_DAYLIGHT: UTimeZoneNameType = UTimeZoneNameType(32i32);
pub const UTZNM_EXEMPLAR_LOCATION: UTimeZoneNameType = UTimeZoneNameType(64i32);
impl ::std::convert::From<i32> for UTimeZoneNameType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneNameType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTimeZoneTransitionType(pub i32);
pub const UCAL_TZ_TRANSITION_NEXT: UTimeZoneTransitionType = UTimeZoneTransitionType(0i32);
pub const UCAL_TZ_TRANSITION_NEXT_INCLUSIVE: UTimeZoneTransitionType = UTimeZoneTransitionType(1i32);
pub const UCAL_TZ_TRANSITION_PREVIOUS: UTimeZoneTransitionType = UTimeZoneTransitionType(2i32);
pub const UCAL_TZ_TRANSITION_PREVIOUS_INCLUSIVE: UTimeZoneTransitionType = UTimeZoneTransitionType(3i32);
impl ::std::convert::From<i32> for UTimeZoneTransitionType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTimeZoneTransitionType {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UTraceData = unsafe extern "system" fn(context: *const ::std::ffi::c_void, fnnumber: i32, level: i32, fmt: super::Foundation::PSTR, args: *mut i8);
#[doc = "*Required features: `Win32_Globalization`*"]
pub type UTraceEntry = unsafe extern "system" fn(context: *const ::std::ffi::c_void, fnnumber: i32);
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
pub type UTraceExit = unsafe extern "system" fn(context: *const ::std::ffi::c_void, fnnumber: i32, fmt: super::Foundation::PSTR, args: *mut i8);
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTraceFunctionNumber(pub i32);
pub const UTRACE_FUNCTION_START: UTraceFunctionNumber = UTraceFunctionNumber(0i32);
pub const UTRACE_U_INIT: UTraceFunctionNumber = UTraceFunctionNumber(0i32);
pub const UTRACE_U_CLEANUP: UTraceFunctionNumber = UTraceFunctionNumber(1i32);
pub const UTRACE_CONVERSION_START: UTraceFunctionNumber = UTraceFunctionNumber(4096i32);
pub const UTRACE_UCNV_OPEN: UTraceFunctionNumber = UTraceFunctionNumber(4096i32);
pub const UTRACE_UCNV_OPEN_PACKAGE: UTraceFunctionNumber = UTraceFunctionNumber(4097i32);
pub const UTRACE_UCNV_OPEN_ALGORITHMIC: UTraceFunctionNumber = UTraceFunctionNumber(4098i32);
pub const UTRACE_UCNV_CLONE: UTraceFunctionNumber = UTraceFunctionNumber(4099i32);
pub const UTRACE_UCNV_CLOSE: UTraceFunctionNumber = UTraceFunctionNumber(4100i32);
pub const UTRACE_UCNV_FLUSH_CACHE: UTraceFunctionNumber = UTraceFunctionNumber(4101i32);
pub const UTRACE_UCNV_LOAD: UTraceFunctionNumber = UTraceFunctionNumber(4102i32);
pub const UTRACE_UCNV_UNLOAD: UTraceFunctionNumber = UTraceFunctionNumber(4103i32);
pub const UTRACE_COLLATION_START: UTraceFunctionNumber = UTraceFunctionNumber(8192i32);
pub const UTRACE_UCOL_OPEN: UTraceFunctionNumber = UTraceFunctionNumber(8192i32);
pub const UTRACE_UCOL_CLOSE: UTraceFunctionNumber = UTraceFunctionNumber(8193i32);
pub const UTRACE_UCOL_STRCOLL: UTraceFunctionNumber = UTraceFunctionNumber(8194i32);
pub const UTRACE_UCOL_GET_SORTKEY: UTraceFunctionNumber = UTraceFunctionNumber(8195i32);
pub const UTRACE_UCOL_GETLOCALE: UTraceFunctionNumber = UTraceFunctionNumber(8196i32);
pub const UTRACE_UCOL_NEXTSORTKEYPART: UTraceFunctionNumber = UTraceFunctionNumber(8197i32);
pub const UTRACE_UCOL_STRCOLLITER: UTraceFunctionNumber = UTraceFunctionNumber(8198i32);
pub const UTRACE_UCOL_OPEN_FROM_SHORT_STRING: UTraceFunctionNumber = UTraceFunctionNumber(8199i32);
pub const UTRACE_UCOL_STRCOLLUTF8: UTraceFunctionNumber = UTraceFunctionNumber(8200i32);
pub const UTRACE_UDATA_START: UTraceFunctionNumber = UTraceFunctionNumber(12288i32);
pub const UTRACE_UDATA_RESOURCE: UTraceFunctionNumber = UTraceFunctionNumber(12288i32);
pub const UTRACE_UDATA_BUNDLE: UTraceFunctionNumber = UTraceFunctionNumber(12289i32);
pub const UTRACE_UDATA_DATA_FILE: UTraceFunctionNumber = UTraceFunctionNumber(12290i32);
pub const UTRACE_UDATA_RES_FILE: UTraceFunctionNumber = UTraceFunctionNumber(12291i32);
impl ::std::convert::From<i32> for UTraceFunctionNumber {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTraceFunctionNumber {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTraceLevel(pub i32);
pub const UTRACE_OFF: UTraceLevel = UTraceLevel(-1i32);
pub const UTRACE_ERROR: UTraceLevel = UTraceLevel(0i32);
pub const UTRACE_WARNING: UTraceLevel = UTraceLevel(3i32);
pub const UTRACE_OPEN_CLOSE: UTraceLevel = UTraceLevel(5i32);
pub const UTRACE_INFO: UTraceLevel = UTraceLevel(7i32);
pub const UTRACE_VERBOSE: UTraceLevel = UTraceLevel(9i32);
impl ::std::convert::From<i32> for UTraceLevel {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTraceLevel {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UTransDirection(pub i32);
pub const UTRANS_FORWARD: UTransDirection = UTransDirection(0i32);
pub const UTRANS_REVERSE: UTransDirection = UTransDirection(1i32);
impl ::std::convert::From<i32> for UTransDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UTransDirection {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct UTransPosition {
    pub contextStart: i32,
    pub contextLimit: i32,
    pub start: i32,
    pub limit: i32,
}
impl UTransPosition {}
impl ::std::default::Default for UTransPosition {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UTransPosition {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UTransPosition").field("contextStart", &self.contextStart).field("contextLimit", &self.contextLimit).field("start", &self.start).field("limit", &self.limit).finish()
    }
}
impl ::std::cmp::PartialEq for UTransPosition {
    fn eq(&self, other: &Self) -> bool {
        self.contextStart == other.contextStart && self.contextLimit == other.contextLimit && self.start == other.start && self.limit == other.limit
    }
}
impl ::std::cmp::Eq for UTransPosition {}
unsafe impl ::windows::runtime::Abi for UTransPosition {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UVerticalOrientation(pub i32);
pub const U_VO_ROTATED: UVerticalOrientation = UVerticalOrientation(0i32);
pub const U_VO_TRANSFORMED_ROTATED: UVerticalOrientation = UVerticalOrientation(1i32);
pub const U_VO_TRANSFORMED_UPRIGHT: UVerticalOrientation = UVerticalOrientation(2i32);
pub const U_VO_UPRIGHT: UVerticalOrientation = UVerticalOrientation(3i32);
impl ::std::convert::From<i32> for UVerticalOrientation {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UVerticalOrientation {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UWordBreak(pub i32);
pub const UBRK_WORD_NONE: UWordBreak = UWordBreak(0i32);
pub const UBRK_WORD_NONE_LIMIT: UWordBreak = UWordBreak(100i32);
pub const UBRK_WORD_NUMBER: UWordBreak = UWordBreak(100i32);
pub const UBRK_WORD_NUMBER_LIMIT: UWordBreak = UWordBreak(200i32);
pub const UBRK_WORD_LETTER: UWordBreak = UWordBreak(200i32);
pub const UBRK_WORD_LETTER_LIMIT: UWordBreak = UWordBreak(300i32);
pub const UBRK_WORD_KANA: UWordBreak = UWordBreak(300i32);
pub const UBRK_WORD_KANA_LIMIT: UWordBreak = UWordBreak(400i32);
pub const UBRK_WORD_IDEO: UWordBreak = UWordBreak(400i32);
pub const UBRK_WORD_IDEO_LIMIT: UWordBreak = UWordBreak(500i32);
impl ::std::convert::From<i32> for UWordBreak {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UWordBreak {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct UWordBreakValues(pub i32);
pub const U_WB_OTHER: UWordBreakValues = UWordBreakValues(0i32);
pub const U_WB_ALETTER: UWordBreakValues = UWordBreakValues(1i32);
pub const U_WB_FORMAT: UWordBreakValues = UWordBreakValues(2i32);
pub const U_WB_KATAKANA: UWordBreakValues = UWordBreakValues(3i32);
pub const U_WB_MIDLETTER: UWordBreakValues = UWordBreakValues(4i32);
pub const U_WB_MIDNUM: UWordBreakValues = UWordBreakValues(5i32);
pub const U_WB_NUMERIC: UWordBreakValues = UWordBreakValues(6i32);
pub const U_WB_EXTENDNUMLET: UWordBreakValues = UWordBreakValues(7i32);
pub const U_WB_CR: UWordBreakValues = UWordBreakValues(8i32);
pub const U_WB_EXTEND: UWordBreakValues = UWordBreakValues(9i32);
pub const U_WB_LF: UWordBreakValues = UWordBreakValues(10i32);
pub const U_WB_MIDNUMLET: UWordBreakValues = UWordBreakValues(11i32);
pub const U_WB_NEWLINE: UWordBreakValues = UWordBreakValues(12i32);
pub const U_WB_REGIONAL_INDICATOR: UWordBreakValues = UWordBreakValues(13i32);
pub const U_WB_HEBREW_LETTER: UWordBreakValues = UWordBreakValues(14i32);
pub const U_WB_SINGLE_QUOTE: UWordBreakValues = UWordBreakValues(15i32);
pub const U_WB_DOUBLE_QUOTE: UWordBreakValues = UWordBreakValues(16i32);
pub const U_WB_E_BASE: UWordBreakValues = UWordBreakValues(17i32);
pub const U_WB_E_BASE_GAZ: UWordBreakValues = UWordBreakValues(18i32);
pub const U_WB_E_MODIFIER: UWordBreakValues = UWordBreakValues(19i32);
pub const U_WB_GLUE_AFTER_ZWJ: UWordBreakValues = UWordBreakValues(20i32);
pub const U_WB_ZWJ: UWordBreakValues = UWordBreakValues(21i32);
pub const U_WB_WSEGSPACE: UWordBreakValues = UWordBreakValues(22i32);
impl ::std::convert::From<i32> for UWordBreakValues {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UWordBreakValues {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_ASCII_FAMILY: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_CHECK_DYLOAD: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_COMBINED_IMPLEMENTATION: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_COMPARE_CODE_POINT_ORDER: u32 = 32768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_COMPARE_IGNORE_CASE: u32 = 65536u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_COPYRIGHT_STRING_LENGTH: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_DEFAULT_SHOW_DRAFT: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_DEFINE_FALSE_AND_TRUE: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_DISABLE_RENAMING: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_EBCDIC_FAMILY: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_EDITS_NO_RESET: u32 = 8192u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_ENABLE_DYLOAD: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_ENABLE_TRACING: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_FOLD_CASE_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_FOLD_CASE_EXCLUDE_SPECIAL_I: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HAVE_RBNF: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HAVE_STD_STRING: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HIDE_DEPRECATED_API: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HIDE_DRAFT_API: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HIDE_INTERNAL_API: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_HIDE_OBSOLETE_API: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_IOSTREAM_SOURCE: u32 = 199711u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MAX_VERSION_LENGTH: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MAX_VERSION_STRING_LENGTH: u32 = 20u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MILLIS_PER_DAY: u32 = 86400000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MILLIS_PER_HOUR: u32 = 3600000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MILLIS_PER_MINUTE: u32 = 60000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_MILLIS_PER_SECOND: u32 = 1000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_NO_DEFAULT_INCLUDE_UTF_HEADERS: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_OMIT_UNCHANGED_TEXT: u32 = 16384u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_OVERRIDE_CXX_ALLOCATION: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PARSE_CONTEXT_LEN: i32 = 16i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_AIX: u32 = 3100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_ANDROID: u32 = 4050u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_BROWSER_NATIVE_CLIENT: u32 = 4020u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_BSD: u32 = 3000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_CYGWIN: u32 = 1900u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_DARWIN: u32 = 3500u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_EMSCRIPTEN: u32 = 5010u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_FUCHSIA: u32 = 4100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_HPUX: u32 = 2100u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_IPHONE: u32 = 3550u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_IRIX: u32 = 3200u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_LINUX: u32 = 4000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_MINGW: u32 = 1800u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_OS390: u32 = 9000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_OS400: u32 = 9400u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_QNX: u32 = 3700u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_SOLARIS: u32 = 2600u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_PF_WINDOWS: u32 = 1000u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SENTINEL: i32 = -1i32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL: u32 = 16384u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL_MASK: u32 = 16384u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL_NOOP: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_ALEN2AN_INIT_AL: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_ALEN2AN_INIT_LR: u32 = 96u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_AN2EN: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_EN2AN: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_MASK: u32 = 224u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_NOOP: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGITS_RESERVED: u32 = 160u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGIT_TYPE_AN: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGIT_TYPE_AN_EXTENDED: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGIT_TYPE_MASK: u32 = 768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_DIGIT_TYPE_RESERVED: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_AUTO: u32 = 65536u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_BEGIN: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_END: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_MASK: u32 = 65539u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_NEAR: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LAMALEF_RESIZE: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_AT_BEGINNING: u32 = 3u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_AT_END: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_NEAR: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LENGTH_GROW_SHRINK: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LENGTH_MASK: u32 = 65539u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LETTERS_MASK: u32 = 24u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LETTERS_NOOP: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LETTERS_SHAPE: u32 = 8u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LETTERS_SHAPE_TASHKEEL_ISOLATED: u32 = 24u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_LETTERS_UNSHAPE: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION: u32 = 32768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION_MASK: u32 = 32768u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION_NOOP: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_SEEN_MASK: u32 = 7340032u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_SEEN_TWOCELL_NEAR: u32 = 2097152u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_SPACES_RELATIVE_TO_TEXT_BEGIN_END: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_SPACES_RELATIVE_TO_TEXT_MASK: u32 = 67108864u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TAIL_NEW_UNICODE: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TAIL_TYPE_MASK: u32 = 134217728u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TASHKEEL_BEGIN: u32 = 262144u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TASHKEEL_END: u32 = 393216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TASHKEEL_MASK: u32 = 917504u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TASHKEEL_REPLACE_BY_TATWEEL: u32 = 786432u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TASHKEEL_RESIZE: u32 = 524288u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TEXT_DIRECTION_LOGICAL: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TEXT_DIRECTION_MASK: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TEXT_DIRECTION_VISUAL_LTR: u32 = 4u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_TEXT_DIRECTION_VISUAL_RTL: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_YEHHAMZA_MASK: u32 = 58720256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHAPE_YEHHAMZA_TWOCELL_NEAR: u32 = 16777216u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SHOW_CPLUSPLUS_API: u32 = 0u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_SIZEOF_UCHAR: u32 = 2u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_TITLECASE_ADJUST_TO_CASED: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_TITLECASE_NO_BREAK_ADJUSTMENT: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_TITLECASE_NO_LOWERCASE: u32 = 256u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_TITLECASE_SENTENCES: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const U_TITLECASE_WHOLE_STRING: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const VS_ALLOW_LATIN: u32 = 1u32;
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn VerifyScripts<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dwflags: u32, lplocalescripts: Param1, cchlocalescripts: i32, lptestscripts: Param3, cchtestscripts: i32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn VerifyScripts(dwflags: u32, lplocalescripts: super::Foundation::PWSTR, cchlocalescripts: i32, lptestscripts: super::Foundation::PWSTR, cchtestscripts: i32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(VerifyScripts(::std::mem::transmute(dwflags), lplocalescripts.into_param().abi(), ::std::mem::transmute(cchlocalescripts), lptestscripts.into_param().abi(), ::std::mem::transmute(cchtestscripts)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_COMPOSITECHECK: u32 = 512u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_DEFAULTCHAR: u32 = 64u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_DISCARDNS: u32 = 16u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_ERR_INVALID_CHARS: u32 = 128u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_NO_BEST_FIT_CHARS: u32 = 1024u32;
#[doc = "*Required features: `Win32_Globalization`*"]
pub const WC_SEPCHARS: u32 = 32u32;
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WORDLIST_TYPE(pub i32);
pub const WORDLIST_TYPE_IGNORE: WORDLIST_TYPE = WORDLIST_TYPE(0i32);
pub const WORDLIST_TYPE_ADD: WORDLIST_TYPE = WORDLIST_TYPE(1i32);
pub const WORDLIST_TYPE_EXCLUDE: WORDLIST_TYPE = WORDLIST_TYPE(2i32);
pub const WORDLIST_TYPE_AUTOCORRECT: WORDLIST_TYPE = WORDLIST_TYPE(3i32);
impl ::std::convert::From<i32> for WORDLIST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WORDLIST_TYPE {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WideCharToMultiByte<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param6: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(codepage: u32, dwflags: u32, lpwidecharstr: Param2, cchwidechar: i32, lpmultibytestr: super::Foundation::PSTR, cbmultibyte: i32, lpdefaultchar: Param6, lpuseddefaultchar: *mut i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WideCharToMultiByte(codepage: u32, dwflags: u32, lpwidecharstr: super::Foundation::PWSTR, cchwidechar: i32, lpmultibytestr: super::Foundation::PSTR, cbmultibyte: i32, lpdefaultchar: super::Foundation::PSTR, lpuseddefaultchar: *mut i32) -> i32;
        }
        ::std::mem::transmute(WideCharToMultiByte(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(dwflags),
            lpwidecharstr.into_param().abi(),
            ::std::mem::transmute(cchwidechar),
            ::std::mem::transmute(lpmultibytestr),
            ::std::mem::transmute(cbmultibyte),
            lpdefaultchar.into_param().abi(),
            ::std::mem::transmute(lpuseddefaultchar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcatA<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring1: Param0, lpstring2: Param1) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcatA(lpstring1: super::Foundation::PSTR, lpstring2: super::Foundation::PSTR) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(lstrcatA(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcatW<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring1: Param0, lpstring2: Param1) -> super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcatW(lpstring1: super::Foundation::PWSTR, lpstring2: super::Foundation::PWSTR) -> super::Foundation::PWSTR;
        }
        ::std::mem::transmute(lstrcatW(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcmpA<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring1: Param0, lpstring2: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcmpA(lpstring1: super::Foundation::PSTR, lpstring2: super::Foundation::PSTR) -> i32;
        }
        ::std::mem::transmute(lstrcmpA(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcmpW<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring1: Param0, lpstring2: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcmpW(lpstring1: super::Foundation::PWSTR, lpstring2: super::Foundation::PWSTR) -> i32;
        }
        ::std::mem::transmute(lstrcmpW(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcmpiA<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring1: Param0, lpstring2: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcmpiA(lpstring1: super::Foundation::PSTR, lpstring2: super::Foundation::PSTR) -> i32;
        }
        ::std::mem::transmute(lstrcmpiA(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcmpiW<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring1: Param0, lpstring2: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcmpiW(lpstring1: super::Foundation::PWSTR, lpstring2: super::Foundation::PWSTR) -> i32;
        }
        ::std::mem::transmute(lstrcmpiW(lpstring1.into_param().abi(), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcpyA<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring1: super::Foundation::PSTR, lpstring2: Param1) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcpyA(lpstring1: super::Foundation::PSTR, lpstring2: super::Foundation::PSTR) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(lstrcpyA(::std::mem::transmute(lpstring1), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcpyW<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring1: super::Foundation::PWSTR, lpstring2: Param1) -> super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcpyW(lpstring1: super::Foundation::PWSTR, lpstring2: super::Foundation::PWSTR) -> super::Foundation::PWSTR;
        }
        ::std::mem::transmute(lstrcpyW(::std::mem::transmute(lpstring1), lpstring2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcpynA<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring1: super::Foundation::PSTR, lpstring2: Param1, imaxlength: i32) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcpynA(lpstring1: super::Foundation::PSTR, lpstring2: super::Foundation::PSTR, imaxlength: i32) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(lstrcpynA(::std::mem::transmute(lpstring1), lpstring2.into_param().abi(), ::std::mem::transmute(imaxlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrcpynW<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring1: super::Foundation::PWSTR, lpstring2: Param1, imaxlength: i32) -> super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrcpynW(lpstring1: super::Foundation::PWSTR, lpstring2: super::Foundation::PWSTR, imaxlength: i32) -> super::Foundation::PWSTR;
        }
        ::std::mem::transmute(lstrcpynW(::std::mem::transmute(lpstring1), lpstring2.into_param().abi(), ::std::mem::transmute(imaxlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrlenA<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(lpstring: Param0) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrlenA(lpstring: super::Foundation::PSTR) -> i32;
        }
        ::std::mem::transmute(lstrlenA(lpstring.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn lstrlenW<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(lpstring: Param0) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn lstrlenW(lpstring: super::Foundation::PWSTR) -> i32;
        }
        ::std::mem::transmute(lstrlenW(lpstring.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct opentype_feature_record {
    pub tagFeature: u32,
    pub lParameter: i32,
}
impl opentype_feature_record {}
impl ::std::default::Default for opentype_feature_record {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for opentype_feature_record {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("opentype_feature_record").field("tagFeature", &self.tagFeature).field("lParameter", &self.lParameter).finish()
    }
}
impl ::std::cmp::PartialEq for opentype_feature_record {
    fn eq(&self, other: &Self) -> bool {
        self.tagFeature == other.tagFeature && self.lParameter == other.lParameter
    }
}
impl ::std::cmp::Eq for opentype_feature_record {}
unsafe impl ::windows::runtime::Abi for opentype_feature_record {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct script_charprop {
    pub _bitfield: u16,
}
impl script_charprop {}
impl ::std::default::Default for script_charprop {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for script_charprop {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("script_charprop").field("_bitfield", &self._bitfield).finish()
    }
}
impl ::std::cmp::PartialEq for script_charprop {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for script_charprop {}
unsafe impl ::windows::runtime::Abi for script_charprop {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct script_glyphprop {
    pub sva: SCRIPT_VISATTR,
    pub reserved: u16,
}
impl script_glyphprop {}
impl ::std::default::Default for script_glyphprop {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for script_glyphprop {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("script_glyphprop").field("sva", &self.sva).field("reserved", &self.reserved).finish()
    }
}
impl ::std::cmp::PartialEq for script_glyphprop {
    fn eq(&self, other: &Self) -> bool {
        self.sva == other.sva && self.reserved == other.reserved
    }
}
impl ::std::cmp::Eq for script_glyphprop {}
unsafe impl ::windows::runtime::Abi for script_glyphprop {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct tagMLCONVCHARF(pub i32);
pub const MLCONVCHARF_AUTODETECT: tagMLCONVCHARF = tagMLCONVCHARF(1i32);
pub const MLCONVCHARF_ENTITIZE: tagMLCONVCHARF = tagMLCONVCHARF(2i32);
pub const MLCONVCHARF_NCR_ENTITIZE: tagMLCONVCHARF = tagMLCONVCHARF(2i32);
pub const MLCONVCHARF_NAME_ENTITIZE: tagMLCONVCHARF = tagMLCONVCHARF(4i32);
pub const MLCONVCHARF_USEDEFCHAR: tagMLCONVCHARF = tagMLCONVCHARF(8i32);
pub const MLCONVCHARF_NOBESTFITCHARS: tagMLCONVCHARF = tagMLCONVCHARF(16i32);
pub const MLCONVCHARF_DETECTJPN: tagMLCONVCHARF = tagMLCONVCHARF(32i32);
impl ::std::convert::From<i32> for tagMLCONVCHARF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for tagMLCONVCHARF {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct tagMLCPF(pub i32);
pub const MLDETECTF_MAILNEWS: tagMLCPF = tagMLCPF(1i32);
pub const MLDETECTF_BROWSER: tagMLCPF = tagMLCPF(2i32);
pub const MLDETECTF_VALID: tagMLCPF = tagMLCPF(4i32);
pub const MLDETECTF_VALID_NLS: tagMLCPF = tagMLCPF(8i32);
pub const MLDETECTF_PRESERVE_ORDER: tagMLCPF = tagMLCPF(16i32);
pub const MLDETECTF_PREFERRED_ONLY: tagMLCPF = tagMLCPF(32i32);
pub const MLDETECTF_FILTER_SPECIALCHAR: tagMLCPF = tagMLCPF(64i32);
pub const MLDETECTF_EURO_UTF8: tagMLCPF = tagMLCPF(128i32);
impl ::std::convert::From<i32> for tagMLCPF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for tagMLCPF {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct tagSCRIPFONTINFO {
    pub scripts: i64,
    pub wszFont: [u16; 32],
}
impl tagSCRIPFONTINFO {}
impl ::std::default::Default for tagSCRIPFONTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for tagSCRIPFONTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("tagSCRIPFONTINFO").field("scripts", &self.scripts).field("wszFont", &self.wszFont).finish()
    }
}
impl ::std::cmp::PartialEq for tagSCRIPFONTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.scripts == other.scripts && self.wszFont == other.wszFont
    }
}
impl ::std::cmp::Eq for tagSCRIPFONTINFO {}
unsafe impl ::windows::runtime::Abi for tagSCRIPFONTINFO {
    type Abi = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[doc = "*Required features: `Win32_Globalization`*"]
pub struct textrange_properties {
    pub potfRecords: *mut opentype_feature_record,
    pub cotfRecords: i32,
}
impl textrange_properties {}
impl ::std::default::Default for textrange_properties {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for textrange_properties {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("textrange_properties").field("potfRecords", &self.potfRecords).field("cotfRecords", &self.cotfRecords).finish()
    }
}
impl ::std::cmp::PartialEq for textrange_properties {
    fn eq(&self, other: &Self) -> bool {
        self.potfRecords == other.potfRecords && self.cotfRecords == other.cotfRecords
    }
}
impl ::std::cmp::Eq for textrange_properties {}
unsafe impl ::windows::runtime::Abi for textrange_properties {
    type Abi = Self;
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_UCharsToChars<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(us: *const u16, cs: Param1, length: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_UCharsToChars(us: *const u16, cs: super::Foundation::PSTR, length: i32);
        }
        ::std::mem::transmute(u_UCharsToChars(::std::mem::transmute(us), cs.into_param().abi(), ::std::mem::transmute(length)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_austrcpy<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dst: Param0, src: *const u16) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_austrcpy(dst: super::Foundation::PSTR, src: *const u16) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_austrcpy(dst.into_param().abi(), ::std::mem::transmute(src)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_austrncpy<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dst: Param0, src: *const u16, n: i32) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_austrncpy(dst: super::Foundation::PSTR, src: *const u16, n: i32) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_austrncpy(dst.into_param().abi(), ::std::mem::transmute(src), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_catclose(catd: *mut UResourceBundle) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_catclose(catd: *mut UResourceBundle);
        }
        ::std::mem::transmute(u_catclose(::std::mem::transmute(catd)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_catgets(catd: *mut UResourceBundle, set_num: i32, msg_num: i32, s: *const u16, len: *mut i32, ec: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_catgets(catd: *mut UResourceBundle, set_num: i32, msg_num: i32, s: *const u16, len: *mut i32, ec: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_catgets(::std::mem::transmute(catd), ::std::mem::transmute(set_num), ::std::mem::transmute(msg_num), ::std::mem::transmute(s), ::std::mem::transmute(len), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_catopen<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(name: Param0, locale: Param1, ec: *mut UErrorCode) -> *mut UResourceBundle {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_catopen(name: super::Foundation::PSTR, locale: super::Foundation::PSTR, ec: *mut UErrorCode) -> *mut UResourceBundle;
        }
        ::std::mem::transmute(u_catopen(name.into_param().abi(), locale.into_param().abi(), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_charAge(c: i32, versionarray: *mut u8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charAge(c: i32, versionarray: *mut u8);
        }
        ::std::mem::transmute(u_charAge(::std::mem::transmute(c), ::std::mem::transmute(versionarray)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_charDigitValue(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charDigitValue(c: i32) -> i32;
        }
        ::std::mem::transmute(u_charDigitValue(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_charDirection(c: i32) -> UCharDirection {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charDirection(c: i32) -> UCharDirection;
        }
        ::std::mem::transmute(u_charDirection(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_charFromName<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(namechoice: UCharNameChoice, name: Param1, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charFromName(namechoice: UCharNameChoice, name: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_charFromName(::std::mem::transmute(namechoice), name.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_charMirror(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charMirror(c: i32) -> i32;
        }
        ::std::mem::transmute(u_charMirror(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_charName<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(code: i32, namechoice: UCharNameChoice, buffer: Param2, bufferlength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charName(code: i32, namechoice: UCharNameChoice, buffer: super::Foundation::PSTR, bufferlength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_charName(::std::mem::transmute(code), ::std::mem::transmute(namechoice), buffer.into_param().abi(), ::std::mem::transmute(bufferlength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_charType(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charType(c: i32) -> i8;
        }
        ::std::mem::transmute(u_charType(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_charsToUChars<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(cs: Param0, us: *mut u16, length: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_charsToUChars(cs: super::Foundation::PSTR, us: *mut u16, length: i32);
        }
        ::std::mem::transmute(u_charsToUChars(cs.into_param().abi(), ::std::mem::transmute(us), ::std::mem::transmute(length)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_cleanup() {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_cleanup();
        }
        ::std::mem::transmute(u_cleanup())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_countChar32(s: *const u16, length: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_countChar32(s: *const u16, length: i32) -> i32;
        }
        ::std::mem::transmute(u_countChar32(::std::mem::transmute(s), ::std::mem::transmute(length)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_digit(ch: i32, radix: i8) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_digit(ch: i32, radix: i8) -> i32;
        }
        ::std::mem::transmute(u_digit(::std::mem::transmute(ch), ::std::mem::transmute(radix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_enumCharNames(start: i32, limit: i32, r#fn: *mut ::std::option::Option<UEnumCharNamesFn>, context: *mut ::std::ffi::c_void, namechoice: UCharNameChoice, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_enumCharNames(start: i32, limit: i32, r#fn: *mut ::windows::runtime::RawPtr, context: *mut ::std::ffi::c_void, namechoice: UCharNameChoice, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(u_enumCharNames(::std::mem::transmute(start), ::std::mem::transmute(limit), ::std::mem::transmute(r#fn), ::std::mem::transmute(context), ::std::mem::transmute(namechoice), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_enumCharTypes(enumrange: *mut ::std::option::Option<UCharEnumTypeRange>, context: *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_enumCharTypes(enumrange: *mut ::windows::runtime::RawPtr, context: *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(u_enumCharTypes(::std::mem::transmute(enumrange), ::std::mem::transmute(context)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_errorName(code: UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_errorName(code: UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_errorName(::std::mem::transmute(code)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_foldCase(c: i32, options: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_foldCase(c: i32, options: u32) -> i32;
        }
        ::std::mem::transmute(u_foldCase(::std::mem::transmute(c), ::std::mem::transmute(options)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_forDigit(digit: i32, radix: i8) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_forDigit(digit: i32, radix: i8) -> i32;
        }
        ::std::mem::transmute(u_forDigit(::std::mem::transmute(digit), ::std::mem::transmute(radix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_formatMessage<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_formatMessage(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_formatMessage(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_formatMessageWithError<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_formatMessageWithError(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_formatMessageWithError(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(parseerror), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getBidiPairedBracket(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getBidiPairedBracket(c: i32) -> i32;
        }
        ::std::mem::transmute(u_getBidiPairedBracket(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getBinaryPropertySet(property: UProperty, perrorcode: *mut UErrorCode) -> *mut USet {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getBinaryPropertySet(property: UProperty, perrorcode: *mut UErrorCode) -> *mut USet;
        }
        ::std::mem::transmute(u_getBinaryPropertySet(::std::mem::transmute(property), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getCombiningClass(c: i32) -> u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getCombiningClass(c: i32) -> u8;
        }
        ::std::mem::transmute(u_getCombiningClass(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getDataVersion(dataversionfillin: *mut u8, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getDataVersion(dataversionfillin: *mut u8, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_getDataVersion(::std::mem::transmute(dataversionfillin), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getFC_NFKC_Closure(c: i32, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getFC_NFKC_Closure(c: i32, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_getFC_NFKC_Closure(::std::mem::transmute(c), ::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getIntPropertyMap(property: UProperty, perrorcode: *mut UErrorCode) -> *mut UCPMap {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getIntPropertyMap(property: UProperty, perrorcode: *mut UErrorCode) -> *mut UCPMap;
        }
        ::std::mem::transmute(u_getIntPropertyMap(::std::mem::transmute(property), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getIntPropertyMaxValue(which: UProperty) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getIntPropertyMaxValue(which: UProperty) -> i32;
        }
        ::std::mem::transmute(u_getIntPropertyMaxValue(::std::mem::transmute(which)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getIntPropertyMinValue(which: UProperty) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getIntPropertyMinValue(which: UProperty) -> i32;
        }
        ::std::mem::transmute(u_getIntPropertyMinValue(::std::mem::transmute(which)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getIntPropertyValue(c: i32, which: UProperty) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getIntPropertyValue(c: i32, which: UProperty) -> i32;
        }
        ::std::mem::transmute(u_getIntPropertyValue(::std::mem::transmute(c), ::std::mem::transmute(which)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getNumericValue(c: i32) -> f64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getNumericValue(c: i32) -> f64;
        }
        ::std::mem::transmute(u_getNumericValue(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_getPropertyEnum<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(alias: Param0) -> UProperty {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getPropertyEnum(alias: super::Foundation::PSTR) -> UProperty;
        }
        ::std::mem::transmute(u_getPropertyEnum(alias.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_getPropertyName(property: UProperty, namechoice: UPropertyNameChoice) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getPropertyName(property: UProperty, namechoice: UPropertyNameChoice) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_getPropertyName(::std::mem::transmute(property), ::std::mem::transmute(namechoice)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_getPropertyValueEnum<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(property: UProperty, alias: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getPropertyValueEnum(property: UProperty, alias: super::Foundation::PSTR) -> i32;
        }
        ::std::mem::transmute(u_getPropertyValueEnum(::std::mem::transmute(property), alias.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_getPropertyValueName(property: UProperty, value: i32, namechoice: UPropertyNameChoice) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getPropertyValueName(property: UProperty, value: i32, namechoice: UPropertyNameChoice) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_getPropertyValueName(::std::mem::transmute(property), ::std::mem::transmute(value), ::std::mem::transmute(namechoice)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getUnicodeVersion(versionarray: *mut u8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getUnicodeVersion(versionarray: *mut u8);
        }
        ::std::mem::transmute(u_getUnicodeVersion(::std::mem::transmute(versionarray)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_getVersion(versionarray: *mut u8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_getVersion(versionarray: *mut u8);
        }
        ::std::mem::transmute(u_getVersion(::std::mem::transmute(versionarray)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_hasBinaryProperty(c: i32, which: UProperty) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_hasBinaryProperty(c: i32, which: UProperty) -> i8;
        }
        ::std::mem::transmute(u_hasBinaryProperty(::std::mem::transmute(c), ::std::mem::transmute(which)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_init(status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_init(status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_init(::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isIDIgnorable(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isIDIgnorable(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isIDIgnorable(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isIDPart(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isIDPart(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isIDPart(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isIDStart(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isIDStart(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isIDStart(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isISOControl(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isISOControl(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isISOControl(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isJavaIDPart(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isJavaIDPart(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isJavaIDPart(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isJavaIDStart(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isJavaIDStart(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isJavaIDStart(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isJavaSpaceChar(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isJavaSpaceChar(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isJavaSpaceChar(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isMirrored(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isMirrored(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isMirrored(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isUAlphabetic(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isUAlphabetic(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isUAlphabetic(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isULowercase(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isULowercase(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isULowercase(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isUUppercase(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isUUppercase(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isUUppercase(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isUWhiteSpace(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isUWhiteSpace(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isUWhiteSpace(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isWhitespace(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isWhitespace(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isWhitespace(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isalnum(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isalnum(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isalnum(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isalpha(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isalpha(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isalpha(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isbase(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isbase(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isbase(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isblank(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isblank(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isblank(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_iscntrl(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_iscntrl(c: i32) -> i8;
        }
        ::std::mem::transmute(u_iscntrl(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isdefined(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isdefined(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isdefined(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isdigit(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isdigit(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isdigit(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isgraph(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isgraph(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isgraph(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_islower(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_islower(c: i32) -> i8;
        }
        ::std::mem::transmute(u_islower(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isprint(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isprint(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isprint(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_ispunct(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_ispunct(c: i32) -> i8;
        }
        ::std::mem::transmute(u_ispunct(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isspace(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isspace(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isspace(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_istitle(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_istitle(c: i32) -> i8;
        }
        ::std::mem::transmute(u_istitle(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isupper(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isupper(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isupper(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_isxdigit(c: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_isxdigit(c: i32) -> i8;
        }
        ::std::mem::transmute(u_isxdigit(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memcasecmp(s1: *const u16, s2: *const u16, length: i32, options: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memcasecmp(s1: *const u16, s2: *const u16, length: i32, options: u32) -> i32;
        }
        ::std::mem::transmute(u_memcasecmp(::std::mem::transmute(s1), ::std::mem::transmute(s2), ::std::mem::transmute(length), ::std::mem::transmute(options)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memchr(s: *const u16, c: u16, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memchr(s: *const u16, c: u16, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memchr(::std::mem::transmute(s), ::std::mem::transmute(c), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memchr32(s: *const u16, c: i32, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memchr32(s: *const u16, c: i32, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memchr32(::std::mem::transmute(s), ::std::mem::transmute(c), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memcmp(buf1: *const u16, buf2: *const u16, count: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memcmp(buf1: *const u16, buf2: *const u16, count: i32) -> i32;
        }
        ::std::mem::transmute(u_memcmp(::std::mem::transmute(buf1), ::std::mem::transmute(buf2), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memcmpCodePointOrder(s1: *const u16, s2: *const u16, count: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memcmpCodePointOrder(s1: *const u16, s2: *const u16, count: i32) -> i32;
        }
        ::std::mem::transmute(u_memcmpCodePointOrder(::std::mem::transmute(s1), ::std::mem::transmute(s2), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memcpy(dest: *mut u16, src: *const u16, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memcpy(dest: *mut u16, src: *const u16, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memcpy(::std::mem::transmute(dest), ::std::mem::transmute(src), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memmove(dest: *mut u16, src: *const u16, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memmove(dest: *mut u16, src: *const u16, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memmove(::std::mem::transmute(dest), ::std::mem::transmute(src), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memrchr(s: *const u16, c: u16, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memrchr(s: *const u16, c: u16, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memrchr(::std::mem::transmute(s), ::std::mem::transmute(c), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memrchr32(s: *const u16, c: i32, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memrchr32(s: *const u16, c: i32, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memrchr32(::std::mem::transmute(s), ::std::mem::transmute(c), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_memset(dest: *mut u16, c: u16, count: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_memset(dest: *mut u16, c: u16, count: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_memset(::std::mem::transmute(dest), ::std::mem::transmute(c), ::std::mem::transmute(count)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_parseMessage<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_parseMessage(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_parseMessage(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(source), ::std::mem::transmute(sourcelength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_parseMessageWithError<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_parseMessageWithError(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, parseerror: *mut UParseError, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_parseMessageWithError(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(source), ::std::mem::transmute(sourcelength), ::std::mem::transmute(parseerror), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_setMemoryFunctions(context: *const ::std::ffi::c_void, a: *mut ::std::option::Option<UMemAllocFn>, r: *mut ::std::option::Option<UMemReallocFn>, f: *mut ::std::option::Option<UMemFreeFn>, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_setMemoryFunctions(context: *const ::std::ffi::c_void, a: *mut ::windows::runtime::RawPtr, r: *mut ::windows::runtime::RawPtr, f: *mut ::windows::runtime::RawPtr, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_setMemoryFunctions(::std::mem::transmute(context), ::std::mem::transmute(a), ::std::mem::transmute(r), ::std::mem::transmute(f), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_shapeArabic(source: *const u16, sourcelength: i32, dest: *mut u16, destsize: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_shapeArabic(source: *const u16, sourcelength: i32, dest: *mut u16, destsize: i32, options: u32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_shapeArabic(::std::mem::transmute(source), ::std::mem::transmute(sourcelength), ::std::mem::transmute(dest), ::std::mem::transmute(destsize), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strCaseCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strCaseCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, options: u32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_strCaseCompare(::std::mem::transmute(s1), ::std::mem::transmute(length1), ::std::mem::transmute(s2), ::std::mem::transmute(length2), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, codepointorder: i8) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, codepointorder: i8) -> i32;
        }
        ::std::mem::transmute(u_strCompare(::std::mem::transmute(s1), ::std::mem::transmute(length1), ::std::mem::transmute(s2), ::std::mem::transmute(length2), ::std::mem::transmute(codepointorder)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strCompareIter(iter1: *mut UCharIterator, iter2: *mut UCharIterator, codepointorder: i8) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strCompareIter(iter1: *mut ::std::mem::ManuallyDrop<UCharIterator>, iter2: *mut ::std::mem::ManuallyDrop<UCharIterator>, codepointorder: i8) -> i32;
        }
        ::std::mem::transmute(u_strCompareIter(::std::mem::transmute(iter1), ::std::mem::transmute(iter2), ::std::mem::transmute(codepointorder)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strFindFirst(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFindFirst(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strFindFirst(::std::mem::transmute(s), ::std::mem::transmute(length), ::std::mem::transmute(substring), ::std::mem::transmute(sublength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strFindLast(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFindLast(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strFindLast(::std::mem::transmute(s), ::std::mem::transmute(length), ::std::mem::transmute(substring), ::std::mem::transmute(sublength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strFoldCase(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFoldCase(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, options: u32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_strFoldCase(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strFromJavaModifiedUTF8WithSub<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: Param3, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromJavaModifiedUTF8WithSub(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: super::Foundation::PSTR, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromJavaModifiedUTF8WithSub(
            ::std::mem::transmute(dest),
            ::std::mem::transmute(destcapacity),
            ::std::mem::transmute(pdestlength),
            src.into_param().abi(),
            ::std::mem::transmute(srclength),
            ::std::mem::transmute(subchar),
            ::std::mem::transmute(pnumsubstitutions),
            ::std::mem::transmute(perrorcode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strFromUTF32(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromUTF32(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromUTF32(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strFromUTF32WithSub(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromUTF32WithSub(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromUTF32WithSub(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(subchar), ::std::mem::transmute(pnumsubstitutions), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strFromUTF8<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromUTF8(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromUTF8(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strFromUTF8Lenient<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromUTF8Lenient(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromUTF8Lenient(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strFromUTF8WithSub<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: Param3, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromUTF8WithSub(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: super::Foundation::PSTR, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromUTF8WithSub(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(subchar), ::std::mem::transmute(pnumsubstitutions), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strFromWCS<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strFromWCS(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: super::Foundation::PWSTR, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16;
        }
        ::std::mem::transmute(u_strFromWCS(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strHasMoreChar32Than(s: *const u16, length: i32, number: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strHasMoreChar32Than(s: *const u16, length: i32, number: i32) -> i8;
        }
        ::std::mem::transmute(u_strHasMoreChar32Than(::std::mem::transmute(s), ::std::mem::transmute(length), ::std::mem::transmute(number)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToJavaModifiedUTF8<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: Param0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToJavaModifiedUTF8(dest: super::Foundation::PSTR, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_strToJavaModifiedUTF8(dest.into_param().abi(), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToLower<'a, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: Param4, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToLower(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_strToLower(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), locale.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToTitle<'a, Param5: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, titleiter: *mut UBreakIterator, locale: Param5, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToTitle(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, titleiter: *mut UBreakIterator, locale: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_strToTitle(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(titleiter), locale.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strToUTF32(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> *mut i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToUTF32(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> *mut i32;
        }
        ::std::mem::transmute(u_strToUTF32(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strToUTF32WithSub(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToUTF32WithSub(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut i32;
        }
        ::std::mem::transmute(u_strToUTF32WithSub(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(subchar), ::std::mem::transmute(pnumsubstitutions), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToUTF8<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: Param0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToUTF8(dest: super::Foundation::PSTR, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_strToUTF8(dest.into_param().abi(), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToUTF8WithSub<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: Param0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToUTF8WithSub(dest: super::Foundation::PSTR, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(u_strToUTF8WithSub(dest.into_param().abi(), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(subchar), ::std::mem::transmute(pnumsubstitutions), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToUpper<'a, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: Param4, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToUpper(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_strToUpper(::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), locale.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_strToWCS<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(dest: Param0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strToWCS(dest: super::Foundation::PWSTR, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> super::Foundation::PWSTR;
        }
        ::std::mem::transmute(u_strToWCS(dest.into_param().abi(), ::std::mem::transmute(destcapacity), ::std::mem::transmute(pdestlength), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcasecmp(s1: *const u16, s2: *const u16, options: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcasecmp(s1: *const u16, s2: *const u16, options: u32) -> i32;
        }
        ::std::mem::transmute(u_strcasecmp(::std::mem::transmute(s1), ::std::mem::transmute(s2), ::std::mem::transmute(options)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcat(dst: *mut u16, src: *const u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcat(dst: *mut u16, src: *const u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strcat(::std::mem::transmute(dst), ::std::mem::transmute(src)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strchr(s: *const u16, c: u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strchr(s: *const u16, c: u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strchr(::std::mem::transmute(s), ::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strchr32(s: *const u16, c: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strchr32(s: *const u16, c: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strchr32(::std::mem::transmute(s), ::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcmp(s1: *const u16, s2: *const u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcmp(s1: *const u16, s2: *const u16) -> i32;
        }
        ::std::mem::transmute(u_strcmp(::std::mem::transmute(s1), ::std::mem::transmute(s2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcmpCodePointOrder(s1: *const u16, s2: *const u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcmpCodePointOrder(s1: *const u16, s2: *const u16) -> i32;
        }
        ::std::mem::transmute(u_strcmpCodePointOrder(::std::mem::transmute(s1), ::std::mem::transmute(s2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcpy(dst: *mut u16, src: *const u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcpy(dst: *mut u16, src: *const u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strcpy(::std::mem::transmute(dst), ::std::mem::transmute(src)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strcspn(string: *const u16, matchset: *const u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strcspn(string: *const u16, matchset: *const u16) -> i32;
        }
        ::std::mem::transmute(u_strcspn(::std::mem::transmute(string), ::std::mem::transmute(matchset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strlen(s: *const u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strlen(s: *const u16) -> i32;
        }
        ::std::mem::transmute(u_strlen(::std::mem::transmute(s)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strncasecmp(s1: *const u16, s2: *const u16, n: i32, options: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strncasecmp(s1: *const u16, s2: *const u16, n: i32, options: u32) -> i32;
        }
        ::std::mem::transmute(u_strncasecmp(::std::mem::transmute(s1), ::std::mem::transmute(s2), ::std::mem::transmute(n), ::std::mem::transmute(options)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strncat(dst: *mut u16, src: *const u16, n: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strncat(dst: *mut u16, src: *const u16, n: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strncat(::std::mem::transmute(dst), ::std::mem::transmute(src), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strncmp(ucs1: *const u16, ucs2: *const u16, n: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strncmp(ucs1: *const u16, ucs2: *const u16, n: i32) -> i32;
        }
        ::std::mem::transmute(u_strncmp(::std::mem::transmute(ucs1), ::std::mem::transmute(ucs2), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strncmpCodePointOrder(s1: *const u16, s2: *const u16, n: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strncmpCodePointOrder(s1: *const u16, s2: *const u16, n: i32) -> i32;
        }
        ::std::mem::transmute(u_strncmpCodePointOrder(::std::mem::transmute(s1), ::std::mem::transmute(s2), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strncpy(dst: *mut u16, src: *const u16, n: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strncpy(dst: *mut u16, src: *const u16, n: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strncpy(::std::mem::transmute(dst), ::std::mem::transmute(src), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strpbrk(string: *const u16, matchset: *const u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strpbrk(string: *const u16, matchset: *const u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strpbrk(::std::mem::transmute(string), ::std::mem::transmute(matchset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strrchr(s: *const u16, c: u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strrchr(s: *const u16, c: u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strrchr(::std::mem::transmute(s), ::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strrchr32(s: *const u16, c: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strrchr32(s: *const u16, c: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_strrchr32(::std::mem::transmute(s), ::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strrstr(s: *const u16, substring: *const u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strrstr(s: *const u16, substring: *const u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strrstr(::std::mem::transmute(s), ::std::mem::transmute(substring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strspn(string: *const u16, matchset: *const u16) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strspn(string: *const u16, matchset: *const u16) -> i32;
        }
        ::std::mem::transmute(u_strspn(::std::mem::transmute(string), ::std::mem::transmute(matchset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strstr(s: *const u16, substring: *const u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strstr(s: *const u16, substring: *const u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strstr(::std::mem::transmute(s), ::std::mem::transmute(substring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_strtok_r(src: *mut u16, delim: *const u16, savestate: *mut *mut u16) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_strtok_r(src: *mut u16, delim: *const u16, savestate: *mut *mut u16) -> *mut u16;
        }
        ::std::mem::transmute(u_strtok_r(::std::mem::transmute(src), ::std::mem::transmute(delim), ::std::mem::transmute(savestate)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_tolower(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_tolower(c: i32) -> i32;
        }
        ::std::mem::transmute(u_tolower(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_totitle(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_totitle(c: i32) -> i32;
        }
        ::std::mem::transmute(u_totitle(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_toupper(c: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_toupper(c: i32) -> i32;
        }
        ::std::mem::transmute(u_toupper(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_uastrcpy<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dst: *mut u16, src: Param1) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_uastrcpy(dst: *mut u16, src: super::Foundation::PSTR) -> *mut u16;
        }
        ::std::mem::transmute(u_uastrcpy(::std::mem::transmute(dst), src.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_uastrncpy<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(dst: *mut u16, src: Param1, n: i32) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_uastrncpy(dst: *mut u16, src: super::Foundation::PSTR, n: i32) -> *mut u16;
        }
        ::std::mem::transmute(u_uastrncpy(::std::mem::transmute(dst), src.into_param().abi(), ::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_unescape<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(src: Param0, dest: *mut u16, destcapacity: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_unescape(src: super::Foundation::PSTR, dest: *mut u16, destcapacity: i32) -> i32;
        }
        ::std::mem::transmute(u_unescape(src.into_param().abi(), ::std::mem::transmute(dest), ::std::mem::transmute(destcapacity)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_unescapeAt(charat: ::std::option::Option<UNESCAPE_CHAR_AT>, offset: *mut i32, length: i32, context: *mut ::std::ffi::c_void) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_unescapeAt(charat: ::windows::runtime::RawPtr, offset: *mut i32, length: i32, context: *mut ::std::ffi::c_void) -> i32;
        }
        ::std::mem::transmute(u_unescapeAt(::std::mem::transmute(charat), ::std::mem::transmute(offset), ::std::mem::transmute(length), ::std::mem::transmute(context)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_versionFromString<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(versionarray: *mut u8, versionstring: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_versionFromString(versionarray: *mut u8, versionstring: super::Foundation::PSTR);
        }
        ::std::mem::transmute(u_versionFromString(::std::mem::transmute(versionarray), versionstring.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn u_versionFromUString(versionarray: *mut u8, versionstring: *const u16) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_versionFromUString(versionarray: *mut u8, versionstring: *const u16);
        }
        ::std::mem::transmute(u_versionFromUString(::std::mem::transmute(versionarray), ::std::mem::transmute(versionstring)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_versionToString<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(versionarray: *const u8, versionstring: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_versionToString(versionarray: *const u8, versionstring: super::Foundation::PSTR);
        }
        ::std::mem::transmute(u_versionToString(::std::mem::transmute(versionarray), versionstring.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_vformatMessage<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, ap: *mut i8, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_vformatMessage(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, ap: *mut i8, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_vformatMessage(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(ap), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_vformatMessageWithError<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, ap: *mut i8, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_vformatMessageWithError(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, ap: *mut i8, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(u_vformatMessageWithError(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(parseerror), ::std::mem::transmute(ap), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_vparseMessage<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_vparseMessage(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_vparseMessage(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(source), ::std::mem::transmute(sourcelength), ::std::mem::transmute(ap), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn u_vparseMessageWithError<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, parseerror: *mut UParseError, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn u_vparseMessageWithError(locale: super::Foundation::PSTR, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, parseerror: *mut UParseError, status: *mut UErrorCode);
        }
        ::std::mem::transmute(u_vparseMessageWithError(locale.into_param().abi(), ::std::mem::transmute(pattern), ::std::mem::transmute(patternlength), ::std::mem::transmute(source), ::std::mem::transmute(sourcelength), ::std::mem::transmute(ap), ::std::mem::transmute(parseerror), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_close(pbidi: *mut UBiDi) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_close(pbidi: *mut UBiDi);
        }
        ::std::mem::transmute(ubidi_close(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_countParagraphs(pbidi: *mut UBiDi) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_countParagraphs(pbidi: *mut UBiDi) -> i32;
        }
        ::std::mem::transmute(ubidi_countParagraphs(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_countRuns(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_countRuns(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_countRuns(::std::mem::transmute(pbidi), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getBaseDirection(text: *const u16, length: i32) -> UBiDiDirection {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getBaseDirection(text: *const u16, length: i32) -> UBiDiDirection;
        }
        ::std::mem::transmute(ubidi_getBaseDirection(::std::mem::transmute(text), ::std::mem::transmute(length)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getClassCallback(pbidi: *mut UBiDi, r#fn: *mut ::std::option::Option<UBiDiClassCallback>, context: *const *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getClassCallback(pbidi: *mut UBiDi, r#fn: *mut ::windows::runtime::RawPtr, context: *const *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(ubidi_getClassCallback(::std::mem::transmute(pbidi), ::std::mem::transmute(r#fn), ::std::mem::transmute(context)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getCustomizedClass(pbidi: *mut UBiDi, c: i32) -> UCharDirection {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getCustomizedClass(pbidi: *mut UBiDi, c: i32) -> UCharDirection;
        }
        ::std::mem::transmute(ubidi_getCustomizedClass(::std::mem::transmute(pbidi), ::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getDirection(pbidi: *const UBiDi) -> UBiDiDirection {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getDirection(pbidi: *const UBiDi) -> UBiDiDirection;
        }
        ::std::mem::transmute(ubidi_getDirection(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLength(pbidi: *const UBiDi) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLength(pbidi: *const UBiDi) -> i32;
        }
        ::std::mem::transmute(ubidi_getLength(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLevelAt(pbidi: *const UBiDi, charindex: i32) -> u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLevelAt(pbidi: *const UBiDi, charindex: i32) -> u8;
        }
        ::std::mem::transmute(ubidi_getLevelAt(::std::mem::transmute(pbidi), ::std::mem::transmute(charindex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLevels(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLevels(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> *mut u8;
        }
        ::std::mem::transmute(ubidi_getLevels(::std::mem::transmute(pbidi), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLogicalIndex(pbidi: *mut UBiDi, visualindex: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLogicalIndex(pbidi: *mut UBiDi, visualindex: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_getLogicalIndex(::std::mem::transmute(pbidi), ::std::mem::transmute(visualindex), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLogicalMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLogicalMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_getLogicalMap(::std::mem::transmute(pbidi), ::std::mem::transmute(indexmap), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getLogicalRun(pbidi: *const UBiDi, logicalposition: i32, plogicallimit: *mut i32, plevel: *mut u8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getLogicalRun(pbidi: *const UBiDi, logicalposition: i32, plogicallimit: *mut i32, plevel: *mut u8);
        }
        ::std::mem::transmute(ubidi_getLogicalRun(::std::mem::transmute(pbidi), ::std::mem::transmute(logicalposition), ::std::mem::transmute(plogicallimit), ::std::mem::transmute(plevel)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getParaLevel(pbidi: *const UBiDi) -> u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getParaLevel(pbidi: *const UBiDi) -> u8;
        }
        ::std::mem::transmute(ubidi_getParaLevel(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getParagraph(pbidi: *const UBiDi, charindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getParagraph(pbidi: *const UBiDi, charindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_getParagraph(::std::mem::transmute(pbidi), ::std::mem::transmute(charindex), ::std::mem::transmute(pparastart), ::std::mem::transmute(pparalimit), ::std::mem::transmute(pparalevel), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getParagraphByIndex(pbidi: *const UBiDi, paraindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getParagraphByIndex(pbidi: *const UBiDi, paraindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_getParagraphByIndex(::std::mem::transmute(pbidi), ::std::mem::transmute(paraindex), ::std::mem::transmute(pparastart), ::std::mem::transmute(pparalimit), ::std::mem::transmute(pparalevel), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getProcessedLength(pbidi: *const UBiDi) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getProcessedLength(pbidi: *const UBiDi) -> i32;
        }
        ::std::mem::transmute(ubidi_getProcessedLength(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getReorderingMode(pbidi: *mut UBiDi) -> UBiDiReorderingMode {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getReorderingMode(pbidi: *mut UBiDi) -> UBiDiReorderingMode;
        }
        ::std::mem::transmute(ubidi_getReorderingMode(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getReorderingOptions(pbidi: *mut UBiDi) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getReorderingOptions(pbidi: *mut UBiDi) -> u32;
        }
        ::std::mem::transmute(ubidi_getReorderingOptions(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getResultLength(pbidi: *const UBiDi) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getResultLength(pbidi: *const UBiDi) -> i32;
        }
        ::std::mem::transmute(ubidi_getResultLength(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getText(pbidi: *const UBiDi) -> *mut u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getText(pbidi: *const UBiDi) -> *mut u16;
        }
        ::std::mem::transmute(ubidi_getText(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getVisualIndex(pbidi: *mut UBiDi, logicalindex: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getVisualIndex(pbidi: *mut UBiDi, logicalindex: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_getVisualIndex(::std::mem::transmute(pbidi), ::std::mem::transmute(logicalindex), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getVisualMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getVisualMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_getVisualMap(::std::mem::transmute(pbidi), ::std::mem::transmute(indexmap), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_getVisualRun(pbidi: *mut UBiDi, runindex: i32, plogicalstart: *mut i32, plength: *mut i32) -> UBiDiDirection {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_getVisualRun(pbidi: *mut UBiDi, runindex: i32, plogicalstart: *mut i32, plength: *mut i32) -> UBiDiDirection;
        }
        ::std::mem::transmute(ubidi_getVisualRun(::std::mem::transmute(pbidi), ::std::mem::transmute(runindex), ::std::mem::transmute(plogicalstart), ::std::mem::transmute(plength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_invertMap(srcmap: *const i32, destmap: *mut i32, length: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_invertMap(srcmap: *const i32, destmap: *mut i32, length: i32);
        }
        ::std::mem::transmute(ubidi_invertMap(::std::mem::transmute(srcmap), ::std::mem::transmute(destmap), ::std::mem::transmute(length)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_isInverse(pbidi: *mut UBiDi) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_isInverse(pbidi: *mut UBiDi) -> i8;
        }
        ::std::mem::transmute(ubidi_isInverse(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_isOrderParagraphsLTR(pbidi: *mut UBiDi) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_isOrderParagraphsLTR(pbidi: *mut UBiDi) -> i8;
        }
        ::std::mem::transmute(ubidi_isOrderParagraphsLTR(::std::mem::transmute(pbidi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_open() -> *mut UBiDi {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_open() -> *mut UBiDi;
        }
        ::std::mem::transmute(ubidi_open())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_openSized(maxlength: i32, maxruncount: i32, perrorcode: *mut UErrorCode) -> *mut UBiDi {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_openSized(maxlength: i32, maxruncount: i32, perrorcode: *mut UErrorCode) -> *mut UBiDi;
        }
        ::std::mem::transmute(ubidi_openSized(::std::mem::transmute(maxlength), ::std::mem::transmute(maxruncount), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_orderParagraphsLTR(pbidi: *mut UBiDi, orderparagraphsltr: i8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_orderParagraphsLTR(pbidi: *mut UBiDi, orderparagraphsltr: i8);
        }
        ::std::mem::transmute(ubidi_orderParagraphsLTR(::std::mem::transmute(pbidi), ::std::mem::transmute(orderparagraphsltr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_reorderLogical(levels: *const u8, length: i32, indexmap: *mut i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_reorderLogical(levels: *const u8, length: i32, indexmap: *mut i32);
        }
        ::std::mem::transmute(ubidi_reorderLogical(::std::mem::transmute(levels), ::std::mem::transmute(length), ::std::mem::transmute(indexmap)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_reorderVisual(levels: *const u8, length: i32, indexmap: *mut i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_reorderVisual(levels: *const u8, length: i32, indexmap: *mut i32);
        }
        ::std::mem::transmute(ubidi_reorderVisual(::std::mem::transmute(levels), ::std::mem::transmute(length), ::std::mem::transmute(indexmap)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setClassCallback(pbidi: *mut UBiDi, newfn: ::std::option::Option<UBiDiClassCallback>, newcontext: *const ::std::ffi::c_void, oldfn: *mut ::std::option::Option<UBiDiClassCallback>, oldcontext: *const *const ::std::ffi::c_void, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setClassCallback(pbidi: *mut UBiDi, newfn: ::windows::runtime::RawPtr, newcontext: *const ::std::ffi::c_void, oldfn: *mut ::windows::runtime::RawPtr, oldcontext: *const *const ::std::ffi::c_void, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_setClassCallback(::std::mem::transmute(pbidi), ::std::mem::transmute(newfn), ::std::mem::transmute(newcontext), ::std::mem::transmute(oldfn), ::std::mem::transmute(oldcontext), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setContext(pbidi: *mut UBiDi, prologue: *const u16, prolength: i32, epilogue: *const u16, epilength: i32, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setContext(pbidi: *mut UBiDi, prologue: *const u16, prolength: i32, epilogue: *const u16, epilength: i32, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_setContext(::std::mem::transmute(pbidi), ::std::mem::transmute(prologue), ::std::mem::transmute(prolength), ::std::mem::transmute(epilogue), ::std::mem::transmute(epilength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setInverse(pbidi: *mut UBiDi, isinverse: i8) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setInverse(pbidi: *mut UBiDi, isinverse: i8);
        }
        ::std::mem::transmute(ubidi_setInverse(::std::mem::transmute(pbidi), ::std::mem::transmute(isinverse)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setLine(pparabidi: *const UBiDi, start: i32, limit: i32, plinebidi: *mut UBiDi, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setLine(pparabidi: *const UBiDi, start: i32, limit: i32, plinebidi: *mut UBiDi, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_setLine(::std::mem::transmute(pparabidi), ::std::mem::transmute(start), ::std::mem::transmute(limit), ::std::mem::transmute(plinebidi), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setPara(pbidi: *mut UBiDi, text: *const u16, length: i32, paralevel: u8, embeddinglevels: *mut u8, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setPara(pbidi: *mut UBiDi, text: *const u16, length: i32, paralevel: u8, embeddinglevels: *mut u8, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ubidi_setPara(::std::mem::transmute(pbidi), ::std::mem::transmute(text), ::std::mem::transmute(length), ::std::mem::transmute(paralevel), ::std::mem::transmute(embeddinglevels), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setReorderingMode(pbidi: *mut UBiDi, reorderingmode: UBiDiReorderingMode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setReorderingMode(pbidi: *mut UBiDi, reorderingmode: UBiDiReorderingMode);
        }
        ::std::mem::transmute(ubidi_setReorderingMode(::std::mem::transmute(pbidi), ::std::mem::transmute(reorderingmode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_setReorderingOptions(pbidi: *mut UBiDi, reorderingoptions: u32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_setReorderingOptions(pbidi: *mut UBiDi, reorderingoptions: u32);
        }
        ::std::mem::transmute(ubidi_setReorderingOptions(::std::mem::transmute(pbidi), ::std::mem::transmute(reorderingoptions)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_writeReordered(pbidi: *mut UBiDi, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_writeReordered(pbidi: *mut UBiDi, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_writeReordered(::std::mem::transmute(pbidi), ::std::mem::transmute(dest), ::std::mem::transmute(destsize), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubidi_writeReverse(src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubidi_writeReverse(src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubidi_writeReverse(::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(dest), ::std::mem::transmute(destsize), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubiditransform_close(pbiditransform: *mut UBiDiTransform) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubiditransform_close(pbiditransform: *mut UBiDiTransform);
        }
        ::std::mem::transmute(ubiditransform_close(::std::mem::transmute(pbiditransform)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubiditransform_open(perrorcode: *mut UErrorCode) -> *mut UBiDiTransform {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubiditransform_open(perrorcode: *mut UErrorCode) -> *mut UBiDiTransform;
        }
        ::std::mem::transmute(ubiditransform_open(::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubiditransform_transform(pbiditransform: *mut UBiDiTransform, src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, inparalevel: u8, inorder: UBiDiOrder, outparalevel: u8, outorder: UBiDiOrder, domirroring: UBiDiMirroring, shapingoptions: u32, perrorcode: *mut UErrorCode) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubiditransform_transform(pbiditransform: *mut UBiDiTransform, src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, inparalevel: u8, inorder: UBiDiOrder, outparalevel: u8, outorder: UBiDiOrder, domirroring: UBiDiMirroring, shapingoptions: u32, perrorcode: *mut UErrorCode) -> u32;
        }
        ::std::mem::transmute(ubiditransform_transform(
            ::std::mem::transmute(pbiditransform),
            ::std::mem::transmute(src),
            ::std::mem::transmute(srclength),
            ::std::mem::transmute(dest),
            ::std::mem::transmute(destsize),
            ::std::mem::transmute(inparalevel),
            ::std::mem::transmute(inorder),
            ::std::mem::transmute(outparalevel),
            ::std::mem::transmute(outorder),
            ::std::mem::transmute(domirroring),
            ::std::mem::transmute(shapingoptions),
            ::std::mem::transmute(perrorcode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ublock_getCode(c: i32) -> UBlockCode {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ublock_getCode(c: i32) -> UBlockCode;
        }
        ::std::mem::transmute(ublock_getCode(::std::mem::transmute(c)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_close(bi: *mut UBreakIterator) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_close(bi: *mut UBreakIterator);
        }
        ::std::mem::transmute(ubrk_close(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_countAvailable() -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_countAvailable() -> i32;
        }
        ::std::mem::transmute(ubrk_countAvailable())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_current(bi: *const UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_current(bi: *const UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_current(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_first(bi: *mut UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_first(bi: *mut UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_first(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_following(bi: *mut UBreakIterator, offset: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_following(bi: *mut UBreakIterator, offset: i32) -> i32;
        }
        ::std::mem::transmute(ubrk_following(::std::mem::transmute(bi), ::std::mem::transmute(offset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ubrk_getAvailable(index: i32) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_getAvailable(index: i32) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ubrk_getAvailable(::std::mem::transmute(index)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_getBinaryRules(bi: *mut UBreakIterator, binaryrules: *mut u8, rulescapacity: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_getBinaryRules(bi: *mut UBreakIterator, binaryrules: *mut u8, rulescapacity: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubrk_getBinaryRules(::std::mem::transmute(bi), ::std::mem::transmute(binaryrules), ::std::mem::transmute(rulescapacity), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ubrk_getLocaleByType(bi: *const UBreakIterator, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_getLocaleByType(bi: *const UBreakIterator, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ubrk_getLocaleByType(::std::mem::transmute(bi), ::std::mem::transmute(r#type), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_getRuleStatus(bi: *mut UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_getRuleStatus(bi: *mut UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_getRuleStatus(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_getRuleStatusVec(bi: *mut UBreakIterator, fillinvec: *mut i32, capacity: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_getRuleStatusVec(bi: *mut UBreakIterator, fillinvec: *mut i32, capacity: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ubrk_getRuleStatusVec(::std::mem::transmute(bi), ::std::mem::transmute(fillinvec), ::std::mem::transmute(capacity), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_isBoundary(bi: *mut UBreakIterator, offset: i32) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_isBoundary(bi: *mut UBreakIterator, offset: i32) -> i8;
        }
        ::std::mem::transmute(ubrk_isBoundary(::std::mem::transmute(bi), ::std::mem::transmute(offset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_last(bi: *mut UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_last(bi: *mut UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_last(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_next(bi: *mut UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_next(bi: *mut UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_next(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ubrk_open<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(r#type: UBreakIteratorType, locale: Param1, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_open(r#type: UBreakIteratorType, locale: super::Foundation::PSTR, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator;
        }
        ::std::mem::transmute(ubrk_open(::std::mem::transmute(r#type), locale.into_param().abi(), ::std::mem::transmute(text), ::std::mem::transmute(textlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_openBinaryRules(binaryrules: *const u8, ruleslength: i32, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_openBinaryRules(binaryrules: *const u8, ruleslength: i32, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator;
        }
        ::std::mem::transmute(ubrk_openBinaryRules(::std::mem::transmute(binaryrules), ::std::mem::transmute(ruleslength), ::std::mem::transmute(text), ::std::mem::transmute(textlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_openRules(rules: *const u16, ruleslength: i32, text: *const u16, textlength: i32, parseerr: *mut UParseError, status: *mut UErrorCode) -> *mut UBreakIterator {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_openRules(rules: *const u16, ruleslength: i32, text: *const u16, textlength: i32, parseerr: *mut UParseError, status: *mut UErrorCode) -> *mut UBreakIterator;
        }
        ::std::mem::transmute(ubrk_openRules(::std::mem::transmute(rules), ::std::mem::transmute(ruleslength), ::std::mem::transmute(text), ::std::mem::transmute(textlength), ::std::mem::transmute(parseerr), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_preceding(bi: *mut UBreakIterator, offset: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_preceding(bi: *mut UBreakIterator, offset: i32) -> i32;
        }
        ::std::mem::transmute(ubrk_preceding(::std::mem::transmute(bi), ::std::mem::transmute(offset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_previous(bi: *mut UBreakIterator) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_previous(bi: *mut UBreakIterator) -> i32;
        }
        ::std::mem::transmute(ubrk_previous(::std::mem::transmute(bi)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_refreshUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_refreshUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ubrk_refreshUText(::std::mem::transmute(bi), ::std::mem::transmute(text), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_safeClone(bi: *const UBreakIterator, stackbuffer: *mut ::std::ffi::c_void, pbuffersize: *mut i32, status: *mut UErrorCode) -> *mut UBreakIterator {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_safeClone(bi: *const UBreakIterator, stackbuffer: *mut ::std::ffi::c_void, pbuffersize: *mut i32, status: *mut UErrorCode) -> *mut UBreakIterator;
        }
        ::std::mem::transmute(ubrk_safeClone(::std::mem::transmute(bi), ::std::mem::transmute(stackbuffer), ::std::mem::transmute(pbuffersize), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_setText(bi: *mut UBreakIterator, text: *const u16, textlength: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_setText(bi: *mut UBreakIterator, text: *const u16, textlength: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ubrk_setText(::std::mem::transmute(bi), ::std::mem::transmute(text), ::std::mem::transmute(textlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ubrk_setUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ubrk_setUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ubrk_setUText(::std::mem::transmute(bi), ::std::mem::transmute(text), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_add(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_add(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_add(::std::mem::transmute(cal), ::std::mem::transmute(field), ::std::mem::transmute(amount), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_clear(calendar: *mut *mut ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_clear(calendar: *mut *mut ::std::ffi::c_void);
        }
        ::std::mem::transmute(ucal_clear(::std::mem::transmute(calendar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_clearField(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_clearField(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields);
        }
        ::std::mem::transmute(ucal_clearField(::std::mem::transmute(cal), ::std::mem::transmute(field)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_clone(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_clone(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(ucal_clone(::std::mem::transmute(cal), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_close(cal: *mut *mut ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_close(cal: *mut *mut ::std::ffi::c_void);
        }
        ::std::mem::transmute(ucal_close(::std::mem::transmute(cal)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_countAvailable() -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_countAvailable() -> i32;
        }
        ::std::mem::transmute(ucal_countAvailable())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_equivalentTo(cal1: *const *const ::std::ffi::c_void, cal2: *const *const ::std::ffi::c_void) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_equivalentTo(cal1: *const *const ::std::ffi::c_void, cal2: *const *const ::std::ffi::c_void) -> i8;
        }
        ::std::mem::transmute(ucal_equivalentTo(::std::mem::transmute(cal1), ::std::mem::transmute(cal2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_get(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_get(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_get(::std::mem::transmute(cal), ::std::mem::transmute(field), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getAttribute(cal: *const *const ::std::ffi::c_void, attr: UCalendarAttribute) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getAttribute(cal: *const *const ::std::ffi::c_void, attr: UCalendarAttribute) -> i32;
        }
        ::std::mem::transmute(ucal_getAttribute(::std::mem::transmute(cal), ::std::mem::transmute(attr)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getAvailable(localeindex: i32) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getAvailable(localeindex: i32) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucal_getAvailable(::std::mem::transmute(localeindex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getCanonicalTimeZoneID(id: *const u16, len: i32, result: *mut u16, resultcapacity: i32, issystemid: *mut i8, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getCanonicalTimeZoneID(id: *const u16, len: i32, result: *mut u16, resultcapacity: i32, issystemid: *mut i8, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getCanonicalTimeZoneID(::std::mem::transmute(id), ::std::mem::transmute(len), ::std::mem::transmute(result), ::std::mem::transmute(resultcapacity), ::std::mem::transmute(issystemid), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getDSTSavings(zoneid: *const u16, ec: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getDSTSavings(zoneid: *const u16, ec: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getDSTSavings(::std::mem::transmute(zoneid), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getDayOfWeekType(cal: *const *const ::std::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> UCalendarWeekdayType {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getDayOfWeekType(cal: *const *const ::std::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> UCalendarWeekdayType;
        }
        ::std::mem::transmute(ucal_getDayOfWeekType(::std::mem::transmute(cal), ::std::mem::transmute(dayofweek), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getDefaultTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getDefaultTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getDefaultTimeZone(::std::mem::transmute(result), ::std::mem::transmute(resultcapacity), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getFieldDifference(cal: *mut *mut ::std::ffi::c_void, target: f64, field: UCalendarDateFields, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getFieldDifference(cal: *mut *mut ::std::ffi::c_void, target: f64, field: UCalendarDateFields, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getFieldDifference(::std::mem::transmute(cal), ::std::mem::transmute(target), ::std::mem::transmute(field), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getGregorianChange(cal: *const *const ::std::ffi::c_void, perrorcode: *mut UErrorCode) -> f64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getGregorianChange(cal: *const *const ::std::ffi::c_void, perrorcode: *mut UErrorCode) -> f64;
        }
        ::std::mem::transmute(ucal_getGregorianChange(::std::mem::transmute(cal), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getHostTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getHostTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getHostTimeZone(::std::mem::transmute(result), ::std::mem::transmute(resultcapacity), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getKeywordValuesForLocale<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(key: Param0, locale: Param1, commonlyused: i8, status: *mut UErrorCode) -> *mut UEnumeration {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getKeywordValuesForLocale(key: super::Foundation::PSTR, locale: super::Foundation::PSTR, commonlyused: i8, status: *mut UErrorCode) -> *mut UEnumeration;
        }
        ::std::mem::transmute(ucal_getKeywordValuesForLocale(key.into_param().abi(), locale.into_param().abi(), ::std::mem::transmute(commonlyused), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getLimit(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields, r#type: UCalendarLimitType, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getLimit(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields, r#type: UCalendarLimitType, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getLimit(::std::mem::transmute(cal), ::std::mem::transmute(field), ::std::mem::transmute(r#type), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getLocaleByType(cal: *const *const ::std::ffi::c_void, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getLocaleByType(cal: *const *const ::std::ffi::c_void, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucal_getLocaleByType(::std::mem::transmute(cal), ::std::mem::transmute(r#type), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getMillis(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> f64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getMillis(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> f64;
        }
        ::std::mem::transmute(ucal_getMillis(::std::mem::transmute(cal), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getNow() -> f64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getNow() -> f64;
        }
        ::std::mem::transmute(ucal_getNow())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getTZDataVersion(status: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getTZDataVersion(status: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucal_getTZDataVersion(::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getTimeZoneDisplayName<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(cal: *const *const ::std::ffi::c_void, r#type: UCalendarDisplayNameType, locale: Param2, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getTimeZoneDisplayName(cal: *const *const ::std::ffi::c_void, r#type: UCalendarDisplayNameType, locale: super::Foundation::PSTR, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getTimeZoneDisplayName(::std::mem::transmute(cal), ::std::mem::transmute(r#type), locale.into_param().abi(), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneID(cal: *const *const ::std::ffi::c_void, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getTimeZoneID(cal: *const *const ::std::ffi::c_void, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getTimeZoneID(::std::mem::transmute(cal), ::std::mem::transmute(result), ::std::mem::transmute(resultlength), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getTimeZoneIDForWindowsID<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(winid: *const u16, len: i32, region: Param2, id: *mut u16, idcapacity: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getTimeZoneIDForWindowsID(winid: *const u16, len: i32, region: super::Foundation::PSTR, id: *mut u16, idcapacity: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getTimeZoneIDForWindowsID(::std::mem::transmute(winid), ::std::mem::transmute(len), region.into_param().abi(), ::std::mem::transmute(id), ::std::mem::transmute(idcapacity), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneTransitionDate(cal: *const *const ::std::ffi::c_void, r#type: UTimeZoneTransitionType, transition: *mut f64, status: *mut UErrorCode) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getTimeZoneTransitionDate(cal: *const *const ::std::ffi::c_void, r#type: UTimeZoneTransitionType, transition: *mut f64, status: *mut UErrorCode) -> i8;
        }
        ::std::mem::transmute(ucal_getTimeZoneTransitionDate(::std::mem::transmute(cal), ::std::mem::transmute(r#type), ::std::mem::transmute(transition), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_getType(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getType(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucal_getType(::std::mem::transmute(cal), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getWeekendTransition(cal: *const *const ::std::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getWeekendTransition(cal: *const *const ::std::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getWeekendTransition(::std::mem::transmute(cal), ::std::mem::transmute(dayofweek), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_getWindowsTimeZoneID(id: *const u16, len: i32, winid: *mut u16, winidcapacity: i32, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_getWindowsTimeZoneID(id: *const u16, len: i32, winid: *mut u16, winidcapacity: i32, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucal_getWindowsTimeZoneID(::std::mem::transmute(id), ::std::mem::transmute(len), ::std::mem::transmute(winid), ::std::mem::transmute(winidcapacity), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_inDaylightTime(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_inDaylightTime(cal: *const *const ::std::ffi::c_void, status: *mut UErrorCode) -> i8;
        }
        ::std::mem::transmute(ucal_inDaylightTime(::std::mem::transmute(cal), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_isSet(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_isSet(cal: *const *const ::std::ffi::c_void, field: UCalendarDateFields) -> i8;
        }
        ::std::mem::transmute(ucal_isSet(::std::mem::transmute(cal), ::std::mem::transmute(field)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_isWeekend(cal: *const *const ::std::ffi::c_void, date: f64, status: *mut UErrorCode) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_isWeekend(cal: *const *const ::std::ffi::c_void, date: f64, status: *mut UErrorCode) -> i8;
        }
        ::std::mem::transmute(ucal_isWeekend(::std::mem::transmute(cal), ::std::mem::transmute(date), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_open<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(zoneid: *const u16, len: i32, locale: Param2, r#type: UCalendarType, status: *mut UErrorCode) -> *mut *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_open(zoneid: *const u16, len: i32, locale: super::Foundation::PSTR, r#type: UCalendarType, status: *mut UErrorCode) -> *mut *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(ucal_open(::std::mem::transmute(zoneid), ::std::mem::transmute(len), locale.into_param().abi(), ::std::mem::transmute(r#type), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_openCountryTimeZones<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(country: Param0, ec: *mut UErrorCode) -> *mut UEnumeration {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_openCountryTimeZones(country: super::Foundation::PSTR, ec: *mut UErrorCode) -> *mut UEnumeration;
        }
        ::std::mem::transmute(ucal_openCountryTimeZones(country.into_param().abi(), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucal_openTimeZoneIDEnumeration<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(zonetype: USystemTimeZoneType, region: Param1, rawoffset: *const i32, ec: *mut UErrorCode) -> *mut UEnumeration {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_openTimeZoneIDEnumeration(zonetype: USystemTimeZoneType, region: super::Foundation::PSTR, rawoffset: *const i32, ec: *mut UErrorCode) -> *mut UEnumeration;
        }
        ::std::mem::transmute(ucal_openTimeZoneIDEnumeration(::std::mem::transmute(zonetype), region.into_param().abi(), ::std::mem::transmute(rawoffset), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_openTimeZones(ec: *mut UErrorCode) -> *mut UEnumeration {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_openTimeZones(ec: *mut UErrorCode) -> *mut UEnumeration;
        }
        ::std::mem::transmute(ucal_openTimeZones(::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_roll(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_roll(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_roll(::std::mem::transmute(cal), ::std::mem::transmute(field), ::std::mem::transmute(amount), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_set(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, value: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_set(cal: *mut *mut ::std::ffi::c_void, field: UCalendarDateFields, value: i32);
        }
        ::std::mem::transmute(ucal_set(::std::mem::transmute(cal), ::std::mem::transmute(field), ::std::mem::transmute(value)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setAttribute(cal: *mut *mut ::std::ffi::c_void, attr: UCalendarAttribute, newvalue: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setAttribute(cal: *mut *mut ::std::ffi::c_void, attr: UCalendarAttribute, newvalue: i32);
        }
        ::std::mem::transmute(ucal_setAttribute(::std::mem::transmute(cal), ::std::mem::transmute(attr), ::std::mem::transmute(newvalue)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setDate(cal: *mut *mut ::std::ffi::c_void, year: i32, month: i32, date: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setDate(cal: *mut *mut ::std::ffi::c_void, year: i32, month: i32, date: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setDate(::std::mem::transmute(cal), ::std::mem::transmute(year), ::std::mem::transmute(month), ::std::mem::transmute(date), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setDateTime(cal: *mut *mut ::std::ffi::c_void, year: i32, month: i32, date: i32, hour: i32, minute: i32, second: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setDateTime(cal: *mut *mut ::std::ffi::c_void, year: i32, month: i32, date: i32, hour: i32, minute: i32, second: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setDateTime(::std::mem::transmute(cal), ::std::mem::transmute(year), ::std::mem::transmute(month), ::std::mem::transmute(date), ::std::mem::transmute(hour), ::std::mem::transmute(minute), ::std::mem::transmute(second), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setDefaultTimeZone(zoneid: *const u16, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setDefaultTimeZone(zoneid: *const u16, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setDefaultTimeZone(::std::mem::transmute(zoneid), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setGregorianChange(cal: *mut *mut ::std::ffi::c_void, date: f64, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setGregorianChange(cal: *mut *mut ::std::ffi::c_void, date: f64, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setGregorianChange(::std::mem::transmute(cal), ::std::mem::transmute(date), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setMillis(cal: *mut *mut ::std::ffi::c_void, datetime: f64, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setMillis(cal: *mut *mut ::std::ffi::c_void, datetime: f64, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setMillis(::std::mem::transmute(cal), ::std::mem::transmute(datetime), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucal_setTimeZone(cal: *mut *mut ::std::ffi::c_void, zoneid: *const u16, len: i32, status: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucal_setTimeZone(cal: *mut *mut ::std::ffi::c_void, zoneid: *const u16, len: i32, status: *mut UErrorCode);
        }
        ::std::mem::transmute(ucal_setTimeZone(::std::mem::transmute(cal), ::std::mem::transmute(zoneid), ::std::mem::transmute(len), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_close(csm: *mut UCaseMap) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_close(csm: *mut UCaseMap);
        }
        ::std::mem::transmute(ucasemap_close(::std::mem::transmute(csm)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_getBreakIterator(csm: *const UCaseMap) -> *mut UBreakIterator {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_getBreakIterator(csm: *const UCaseMap) -> *mut UBreakIterator;
        }
        ::std::mem::transmute(ucasemap_getBreakIterator(::std::mem::transmute(csm)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_getLocale(csm: *const UCaseMap) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_getLocale(csm: *const UCaseMap) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucasemap_getLocale(::std::mem::transmute(csm)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_getOptions(csm: *const UCaseMap) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_getOptions(csm: *const UCaseMap) -> u32;
        }
        ::std::mem::transmute(ucasemap_getOptions(::std::mem::transmute(csm)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_open<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(locale: Param0, options: u32, perrorcode: *mut UErrorCode) -> *mut UCaseMap {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_open(locale: super::Foundation::PSTR, options: u32, perrorcode: *mut UErrorCode) -> *mut UCaseMap;
        }
        ::std::mem::transmute(ucasemap_open(locale.into_param().abi(), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_setBreakIterator(csm: *mut UCaseMap, itertoadopt: *mut UBreakIterator, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_setBreakIterator(csm: *mut UCaseMap, itertoadopt: *mut UBreakIterator, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucasemap_setBreakIterator(::std::mem::transmute(csm), ::std::mem::transmute(itertoadopt), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_setLocale<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(csm: *mut UCaseMap, locale: Param1, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_setLocale(csm: *mut UCaseMap, locale: super::Foundation::PSTR, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucasemap_setLocale(::std::mem::transmute(csm), locale.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_setOptions(csm: *mut UCaseMap, options: u32, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_setOptions(csm: *mut UCaseMap, options: u32, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucasemap_setOptions(::std::mem::transmute(csm), ::std::mem::transmute(options), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucasemap_toTitle(csm: *mut UCaseMap, dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_toTitle(csm: *mut UCaseMap, dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucasemap_toTitle(::std::mem::transmute(csm), ::std::mem::transmute(dest), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_utf8FoldCase<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(csm: *const UCaseMap, dest: Param1, destcapacity: i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_utf8FoldCase(csm: *const UCaseMap, dest: super::Foundation::PSTR, destcapacity: i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucasemap_utf8FoldCase(::std::mem::transmute(csm), dest.into_param().abi(), ::std::mem::transmute(destcapacity), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_utf8ToLower<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(csm: *const UCaseMap, dest: Param1, destcapacity: i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_utf8ToLower(csm: *const UCaseMap, dest: super::Foundation::PSTR, destcapacity: i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucasemap_utf8ToLower(::std::mem::transmute(csm), dest.into_param().abi(), ::std::mem::transmute(destcapacity), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_utf8ToTitle<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(csm: *mut UCaseMap, dest: Param1, destcapacity: i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_utf8ToTitle(csm: *mut UCaseMap, dest: super::Foundation::PSTR, destcapacity: i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucasemap_utf8ToTitle(::std::mem::transmute(csm), dest.into_param().abi(), ::std::mem::transmute(destcapacity), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucasemap_utf8ToUpper<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(csm: *const UCaseMap, dest: Param1, destcapacity: i32, src: Param3, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucasemap_utf8ToUpper(csm: *const UCaseMap, dest: super::Foundation::PSTR, destcapacity: i32, src: super::Foundation::PSTR, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucasemap_utf8ToUpper(::std::mem::transmute(csm), dest.into_param().abi(), ::std::mem::transmute(destcapacity), src.into_param().abi(), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_close(ucfpos: *mut UConstrainedFieldPosition) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_close(ucfpos: *mut UConstrainedFieldPosition);
        }
        ::std::mem::transmute(ucfpos_close(::std::mem::transmute(ucfpos)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_constrainCategory(ucfpos: *mut UConstrainedFieldPosition, category: i32, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_constrainCategory(ucfpos: *mut UConstrainedFieldPosition, category: i32, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_constrainCategory(::std::mem::transmute(ucfpos), ::std::mem::transmute(category), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_constrainField(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_constrainField(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_constrainField(::std::mem::transmute(ucfpos), ::std::mem::transmute(category), ::std::mem::transmute(field), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_getCategory(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_getCategory(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucfpos_getCategory(::std::mem::transmute(ucfpos), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_getField(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_getField(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucfpos_getField(::std::mem::transmute(ucfpos), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_getIndexes(ucfpos: *const UConstrainedFieldPosition, pstart: *mut i32, plimit: *mut i32, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_getIndexes(ucfpos: *const UConstrainedFieldPosition, pstart: *mut i32, plimit: *mut i32, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_getIndexes(::std::mem::transmute(ucfpos), ::std::mem::transmute(pstart), ::std::mem::transmute(plimit), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_getInt64IterationContext(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i64 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_getInt64IterationContext(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i64;
        }
        ::std::mem::transmute(ucfpos_getInt64IterationContext(::std::mem::transmute(ucfpos), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_matchesField(ucfpos: *const UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_matchesField(ucfpos: *const UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode) -> i8;
        }
        ::std::mem::transmute(ucfpos_matchesField(::std::mem::transmute(ucfpos), ::std::mem::transmute(category), ::std::mem::transmute(field), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_open(ec: *mut UErrorCode) -> *mut UConstrainedFieldPosition {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_open(ec: *mut UErrorCode) -> *mut UConstrainedFieldPosition;
        }
        ::std::mem::transmute(ucfpos_open(::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_reset(ucfpos: *mut UConstrainedFieldPosition, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_reset(ucfpos: *mut UConstrainedFieldPosition, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_reset(::std::mem::transmute(ucfpos), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_setInt64IterationContext(ucfpos: *mut UConstrainedFieldPosition, context: i64, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_setInt64IterationContext(ucfpos: *mut UConstrainedFieldPosition, context: i64, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_setInt64IterationContext(::std::mem::transmute(ucfpos), ::std::mem::transmute(context), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucfpos_setState(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, start: i32, limit: i32, ec: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucfpos_setState(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, start: i32, limit: i32, ec: *mut UErrorCode);
        }
        ::std::mem::transmute(ucfpos_setState(::std::mem::transmute(ucfpos), ::std::mem::transmute(category), ::std::mem::transmute(field), ::std::mem::transmute(start), ::std::mem::transmute(limit), ::std::mem::transmute(ec)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_cbFromUWriteBytes<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(args: *mut UConverterFromUnicodeArgs, source: Param1, length: i32, offsetindex: i32, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_cbFromUWriteBytes(args: *mut UConverterFromUnicodeArgs, source: super::Foundation::PSTR, length: i32, offsetindex: i32, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_cbFromUWriteBytes(::std::mem::transmute(args), source.into_param().abi(), ::std::mem::transmute(length), ::std::mem::transmute(offsetindex), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_cbFromUWriteSub(args: *mut UConverterFromUnicodeArgs, offsetindex: i32, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_cbFromUWriteSub(args: *mut UConverterFromUnicodeArgs, offsetindex: i32, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_cbFromUWriteSub(::std::mem::transmute(args), ::std::mem::transmute(offsetindex), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_cbFromUWriteUChars(args: *mut UConverterFromUnicodeArgs, source: *const *const u16, sourcelimit: *const u16, offsetindex: i32, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_cbFromUWriteUChars(args: *mut UConverterFromUnicodeArgs, source: *const *const u16, sourcelimit: *const u16, offsetindex: i32, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_cbFromUWriteUChars(::std::mem::transmute(args), ::std::mem::transmute(source), ::std::mem::transmute(sourcelimit), ::std::mem::transmute(offsetindex), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_cbToUWriteSub(args: *mut UConverterToUnicodeArgs, offsetindex: i32, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_cbToUWriteSub(args: *mut UConverterToUnicodeArgs, offsetindex: i32, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_cbToUWriteSub(::std::mem::transmute(args), ::std::mem::transmute(offsetindex), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_cbToUWriteUChars(args: *mut UConverterToUnicodeArgs, source: *const u16, length: i32, offsetindex: i32, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_cbToUWriteUChars(args: *mut UConverterToUnicodeArgs, source: *const u16, length: i32, offsetindex: i32, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_cbToUWriteUChars(::std::mem::transmute(args), ::std::mem::transmute(source), ::std::mem::transmute(length), ::std::mem::transmute(offsetindex), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_close(converter: *mut UConverter) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_close(converter: *mut UConverter);
        }
        ::std::mem::transmute(ucnv_close(::std::mem::transmute(converter)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_compareNames<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(name1: Param0, name2: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_compareNames(name1: super::Foundation::PSTR, name2: super::Foundation::PSTR) -> i32;
        }
        ::std::mem::transmute(ucnv_compareNames(name1.into_param().abi(), name2.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_convert<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(toconvertername: Param0, fromconvertername: Param1, target: Param2, targetcapacity: i32, source: Param4, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_convert(toconvertername: super::Foundation::PSTR, fromconvertername: super::Foundation::PSTR, target: super::Foundation::PSTR, targetcapacity: i32, source: super::Foundation::PSTR, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_convert(toconvertername.into_param().abi(), fromconvertername.into_param().abi(), target.into_param().abi(), ::std::mem::transmute(targetcapacity), source.into_param().abi(), ::std::mem::transmute(sourcelength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_convertEx<'a, Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param5: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(targetcnv: *mut UConverter, sourcecnv: *mut UConverter, target: *mut *mut i8, targetlimit: Param3, source: *const *const i8, sourcelimit: Param5, pivotstart: *mut u16, pivotsource: *mut *mut u16, pivottarget: *mut *mut u16, pivotlimit: *const u16, reset: i8, flush: i8, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_convertEx(targetcnv: *mut UConverter, sourcecnv: *mut UConverter, target: *mut *mut i8, targetlimit: super::Foundation::PSTR, source: *const *const i8, sourcelimit: super::Foundation::PSTR, pivotstart: *mut u16, pivotsource: *mut *mut u16, pivottarget: *mut *mut u16, pivotlimit: *const u16, reset: i8, flush: i8, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_convertEx(
            ::std::mem::transmute(targetcnv),
            ::std::mem::transmute(sourcecnv),
            ::std::mem::transmute(target),
            targetlimit.into_param().abi(),
            ::std::mem::transmute(source),
            sourcelimit.into_param().abi(),
            ::std::mem::transmute(pivotstart),
            ::std::mem::transmute(pivotsource),
            ::std::mem::transmute(pivottarget),
            ::std::mem::transmute(pivotlimit),
            ::std::mem::transmute(reset),
            ::std::mem::transmute(flush),
            ::std::mem::transmute(perrorcode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_countAliases<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(alias: Param0, perrorcode: *mut UErrorCode) -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_countAliases(alias: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> u16;
        }
        ::std::mem::transmute(ucnv_countAliases(alias.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_countAvailable() -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_countAvailable() -> i32;
        }
        ::std::mem::transmute(ucnv_countAvailable())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_countStandards() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_countStandards() -> u16;
        }
        ::std::mem::transmute(ucnv_countStandards())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_detectUnicodeSignature<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(source: Param0, sourcelength: i32, signaturelength: *mut i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_detectUnicodeSignature(source: super::Foundation::PSTR, sourcelength: i32, signaturelength: *mut i32, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_detectUnicodeSignature(source.into_param().abi(), ::std::mem::transmute(sourcelength), ::std::mem::transmute(signaturelength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_fixFileSeparator(cnv: *const UConverter, source: *mut u16, sourcelen: i32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_fixFileSeparator(cnv: *const UConverter, source: *mut u16, sourcelen: i32);
        }
        ::std::mem::transmute(ucnv_fixFileSeparator(::std::mem::transmute(cnv), ::std::mem::transmute(source), ::std::mem::transmute(sourcelen)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_flushCache() -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_flushCache() -> i32;
        }
        ::std::mem::transmute(ucnv_flushCache())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_fromAlgorithmic<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(cnv: *mut UConverter, algorithmictype: UConverterType, target: Param2, targetcapacity: i32, source: Param4, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_fromAlgorithmic(cnv: *mut UConverter, algorithmictype: UConverterType, target: super::Foundation::PSTR, targetcapacity: i32, source: super::Foundation::PSTR, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_fromAlgorithmic(::std::mem::transmute(cnv), ::std::mem::transmute(algorithmictype), target.into_param().abi(), ::std::mem::transmute(targetcapacity), source.into_param().abi(), ::std::mem::transmute(sourcelength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_fromUChars<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(cnv: *mut UConverter, dest: Param1, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_fromUChars(cnv: *mut UConverter, dest: super::Foundation::PSTR, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_fromUChars(::std::mem::transmute(cnv), dest.into_param().abi(), ::std::mem::transmute(destcapacity), ::std::mem::transmute(src), ::std::mem::transmute(srclength), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_fromUCountPending(cnv: *const UConverter, status: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_fromUCountPending(cnv: *const UConverter, status: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_fromUCountPending(::std::mem::transmute(cnv), ::std::mem::transmute(status)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_fromUnicode<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(converter: *mut UConverter, target: *mut *mut i8, targetlimit: Param2, source: *const *const u16, sourcelimit: *const u16, offsets: *mut i32, flush: i8, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_fromUnicode(converter: *mut UConverter, target: *mut *mut i8, targetlimit: super::Foundation::PSTR, source: *const *const u16, sourcelimit: *const u16, offsets: *mut i32, flush: i8, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_fromUnicode(::std::mem::transmute(converter), ::std::mem::transmute(target), targetlimit.into_param().abi(), ::std::mem::transmute(source), ::std::mem::transmute(sourcelimit), ::std::mem::transmute(offsets), ::std::mem::transmute(flush), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getAlias<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(alias: Param0, n: u16, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getAlias(alias: super::Foundation::PSTR, n: u16, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getAlias(alias.into_param().abi(), ::std::mem::transmute(n), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getAliases<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(alias: Param0, aliases: *const *const i8, perrorcode: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getAliases(alias: super::Foundation::PSTR, aliases: *const *const i8, perrorcode: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_getAliases(alias.into_param().abi(), ::std::mem::transmute(aliases), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getAvailableName(n: i32) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getAvailableName(n: i32) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getAvailableName(::std::mem::transmute(n)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getCCSID(converter: *const UConverter, err: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getCCSID(converter: *const UConverter, err: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_getCCSID(::std::mem::transmute(converter), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getCanonicalName<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(alias: Param0, standard: Param1, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getCanonicalName(alias: super::Foundation::PSTR, standard: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getCanonicalName(alias.into_param().abi(), standard.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getDefaultName() -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getDefaultName() -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getDefaultName())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getDisplayName<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(converter: *const UConverter, displaylocale: Param1, displayname: *mut u16, displaynamecapacity: i32, err: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getDisplayName(converter: *const UConverter, displaylocale: super::Foundation::PSTR, displayname: *mut u16, displaynamecapacity: i32, err: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_getDisplayName(::std::mem::transmute(converter), displaylocale.into_param().abi(), ::std::mem::transmute(displayname), ::std::mem::transmute(displaynamecapacity), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getFromUCallBack(converter: *const UConverter, action: *mut ::std::option::Option<UConverterFromUCallback>, context: *const *const ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getFromUCallBack(converter: *const UConverter, action: *mut ::windows::runtime::RawPtr, context: *const *const ::std::ffi::c_void);
        }
        ::std::mem::transmute(ucnv_getFromUCallBack(::std::mem::transmute(converter), ::std::mem::transmute(action), ::std::mem::transmute(context)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getInvalidChars<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(converter: *const UConverter, errbytes: Param1, len: *mut i8, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getInvalidChars(converter: *const UConverter, errbytes: super::Foundation::PSTR, len: *mut i8, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_getInvalidChars(::std::mem::transmute(converter), errbytes.into_param().abi(), ::std::mem::transmute(len), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getInvalidUChars(converter: *const UConverter, erruchars: *mut u16, len: *mut i8, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getInvalidUChars(converter: *const UConverter, erruchars: *mut u16, len: *mut i8, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_getInvalidUChars(::std::mem::transmute(converter), ::std::mem::transmute(erruchars), ::std::mem::transmute(len), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getMaxCharSize(converter: *const UConverter) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getMaxCharSize(converter: *const UConverter) -> i8;
        }
        ::std::mem::transmute(ucnv_getMaxCharSize(::std::mem::transmute(converter)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getMinCharSize(converter: *const UConverter) -> i8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getMinCharSize(converter: *const UConverter) -> i8;
        }
        ::std::mem::transmute(ucnv_getMinCharSize(::std::mem::transmute(converter)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getName(converter: *const UConverter, err: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getName(converter: *const UConverter, err: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getName(::std::mem::transmute(converter), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getNextUChar<'a, Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(converter: *mut UConverter, source: *const *const i8, sourcelimit: Param2, err: *mut UErrorCode) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getNextUChar(converter: *mut UConverter, source: *const *const i8, sourcelimit: super::Foundation::PSTR, err: *mut UErrorCode) -> i32;
        }
        ::std::mem::transmute(ucnv_getNextUChar(::std::mem::transmute(converter), ::std::mem::transmute(source), sourcelimit.into_param().abi(), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getPlatform(converter: *const UConverter, err: *mut UErrorCode) -> UConverterPlatform {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getPlatform(converter: *const UConverter, err: *mut UErrorCode) -> UConverterPlatform;
        }
        ::std::mem::transmute(ucnv_getPlatform(::std::mem::transmute(converter), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getStandard(n: u16, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getStandard(n: u16, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getStandard(::std::mem::transmute(n), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getStandardName<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(name: Param0, standard: Param1, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getStandardName(name: super::Foundation::PSTR, standard: super::Foundation::PSTR, perrorcode: *mut UErrorCode) -> super::Foundation::PSTR;
        }
        ::std::mem::transmute(ucnv_getStandardName(name.into_param().abi(), standard.into_param().abi(), ::std::mem::transmute(perrorcode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`*"]
#[inline]
pub unsafe fn ucnv_getStarters(converter: *const UConverter, starters: *mut i8, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getStarters(converter: *const UConverter, starters: *mut i8, err: *mut UErrorCode);
        }
        ::std::mem::transmute(ucnv_getStarters(::std::mem::transmute(converter), ::std::mem::transmute(starters), ::std::mem::transmute(err)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `Win32_Globalization`, `Win32_Foundation`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ucnv_getSubstChars<'a, Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(converter: *const UConverter, subchars: Param1, len: *mut i8, err: *mut UErrorCode) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ucnv_getSubstChars(converter: *const U