#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
pub const API_GET_PROXY_FOR_URL: u32 = 6u32;
pub const API_QUERY_DATA_AVAILABLE: u32 = 2u32;
pub const API_READ_DATA: u32 = 3u32;
pub const API_RECEIVE_RESPONSE: u32 = 1u32;
pub const API_SEND_REQUEST: u32 = 5u32;
pub const API_WRITE_DATA: u32 = 4u32;
pub const ERROR_WINHTTP_AUTODETECTION_FAILED: u32 = 12180u32;
pub const ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR: u32 = 12178u32;
pub const ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT: u32 = 12166u32;
pub const ERROR_WINHTTP_CANNOT_CALL_AFTER_OPEN: u32 = 12103u32;
pub const ERROR_WINHTTP_CANNOT_CALL_AFTER_SEND: u32 = 12102u32;
pub const ERROR_WINHTTP_CANNOT_CALL_BEFORE_OPEN: u32 = 12100u32;
pub const ERROR_WINHTTP_CANNOT_CALL_BEFORE_SEND: u32 = 12101u32;
pub const ERROR_WINHTTP_CANNOT_CONNECT: u32 = 12029u32;
pub const ERROR_WINHTTP_CHUNKED_ENCODING_HEADER_SIZE_OVERFLOW: u32 = 12183u32;
pub const ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED: u32 = 12044u32;
pub const ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED_PROXY: u32 = 12187u32;
pub const ERROR_WINHTTP_CLIENT_CERT_NO_ACCESS_PRIVATE_KEY: u32 = 12186u32;
pub const ERROR_WINHTTP_CLIENT_CERT_NO_PRIVATE_KEY: u32 = 12185u32;
pub const ERROR_WINHTTP_CONNECTION_ERROR: u32 = 12030u32;
pub const ERROR_WINHTTP_FEATURE_DISABLED: u32 = 12192u32;
pub const ERROR_WINHTTP_GLOBAL_CALLBACK_FAILED: u32 = 12191u32;
pub const ERROR_WINHTTP_HEADER_ALREADY_EXISTS: u32 = 12155u32;
pub const ERROR_WINHTTP_HEADER_COUNT_EXCEEDED: u32 = 12181u32;
pub const ERROR_WINHTTP_HEADER_NOT_FOUND: u32 = 12150u32;
pub const ERROR_WINHTTP_HEADER_SIZE_OVERFLOW: u32 = 12182u32;
pub const ERROR_WINHTTP_HTTP_PROTOCOL_MISMATCH: u32 = 12190u32;
pub const ERROR_WINHTTP_INCORRECT_HANDLE_STATE: u32 = 12019u32;
pub const ERROR_WINHTTP_INCORRECT_HANDLE_TYPE: u32 = 12018u32;
pub const ERROR_WINHTTP_INTERNAL_ERROR: u32 = 12004u32;
pub const ERROR_WINHTTP_INVALID_HEADER: u32 = 12153u32;
pub const ERROR_WINHTTP_INVALID_OPTION: u32 = 12009u32;
pub const ERROR_WINHTTP_INVALID_QUERY_REQUEST: u32 = 12154u32;
pub const ERROR_WINHTTP_INVALID_SERVER_RESPONSE: u32 = 12152u32;
pub const ERROR_WINHTTP_INVALID_URL: u32 = 12005u32;
pub const ERROR_WINHTTP_LOGIN_FAILURE: u32 = 12015u32;
pub const ERROR_WINHTTP_NAME_NOT_RESOLVED: u32 = 12007u32;
pub const ERROR_WINHTTP_NOT_INITIALIZED: u32 = 12172u32;
pub const ERROR_WINHTTP_OPERATION_CANCELLED: u32 = 12017u32;
pub const ERROR_WINHTTP_OPTION_NOT_SETTABLE: u32 = 12011u32;
pub const ERROR_WINHTTP_OUT_OF_HANDLES: u32 = 12001u32;
pub const ERROR_WINHTTP_REDIRECT_FAILED: u32 = 12156u32;
pub const ERROR_WINHTTP_RESEND_REQUEST: u32 = 12032u32;
pub const ERROR_WINHTTP_RESERVED_189: u32 = 12189u32;
pub const ERROR_WINHTTP_RESPONSE_DRAIN_OVERFLOW: u32 = 12184u32;
pub const ERROR_WINHTTP_SCRIPT_EXECUTION_ERROR: u32 = 12177u32;
pub const ERROR_WINHTTP_SECURE_CERT_CN_INVALID: u32 = 12038u32;
pub const ERROR_WINHTTP_SECURE_CERT_DATE_INVALID: u32 = 12037u32;
pub const ERROR_WINHTTP_SECURE_CERT_REVOKED: u32 = 12170u32;
pub const ERROR_WINHTTP_SECURE_CERT_REV_FAILED: u32 = 12057u32;
pub const ERROR_WINHTTP_SECURE_CERT_WRONG_USAGE: u32 = 12179u32;
pub const ERROR_WINHTTP_SECURE_CHANNEL_ERROR: u32 = 12157u32;
pub const ERROR_WINHTTP_SECURE_FAILURE: u32 = 12175u32;
pub const ERROR_WINHTTP_SECURE_FAILURE_PROXY: u32 = 12188u32;
pub const ERROR_WINHTTP_SECURE_INVALID_CA: u32 = 12045u32;
pub const ERROR_WINHTTP_SECURE_INVALID_CERT: u32 = 12169u32;
pub const ERROR_WINHTTP_SHUTDOWN: u32 = 12012u32;
pub const ERROR_WINHTTP_TIMEOUT: u32 = 12002u32;
pub const ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT: u32 = 12167u32;
pub const ERROR_WINHTTP_UNHANDLED_SCRIPT_TYPE: u32 = 12176u32;
pub const ERROR_WINHTTP_UNRECOGNIZED_SCHEME: u32 = 12006u32;
pub const HTTP_STATUS_ACCEPTED: u32 = 202u32;
pub const HTTP_STATUS_AMBIGUOUS: u32 = 300u32;
pub const HTTP_STATUS_BAD_GATEWAY: u32 = 502u32;
pub const HTTP_STATUS_BAD_METHOD: u32 = 405u32;
pub const HTTP_STATUS_BAD_REQUEST: u32 = 400u32;
pub const HTTP_STATUS_CONFLICT: u32 = 409u32;
pub const HTTP_STATUS_CONTINUE: u32 = 100u32;
pub const HTTP_STATUS_CREATED: u32 = 201u32;
pub const HTTP_STATUS_DENIED: u32 = 401u32;
pub const HTTP_STATUS_FIRST: u32 = 100u32;
pub const HTTP_STATUS_FORBIDDEN: u32 = 403u32;
pub const HTTP_STATUS_GATEWAY_TIMEOUT: u32 = 504u32;
pub const HTTP_STATUS_GONE: u32 = 410u32;
pub const HTTP_STATUS_LAST: u32 = 505u32;
pub const HTTP_STATUS_LENGTH_REQUIRED: u32 = 411u32;
pub const HTTP_STATUS_MOVED: u32 = 301u32;
pub const HTTP_STATUS_NONE_ACCEPTABLE: u32 = 406u32;
pub const HTTP_STATUS_NOT_FOUND: u32 = 404u32;
pub const HTTP_STATUS_NOT_MODIFIED: u32 = 304u32;
pub const HTTP_STATUS_NOT_SUPPORTED: u32 = 501u32;
pub const HTTP_STATUS_NO_CONTENT: u32 = 204u32;
pub const HTTP_STATUS_OK: u32 = 200u32;
pub const HTTP_STATUS_PARTIAL: u32 = 203u32;
pub const HTTP_STATUS_PARTIAL_CONTENT: u32 = 206u32;
pub const HTTP_STATUS_PAYMENT_REQ: u32 = 402u32;
pub const HTTP_STATUS_PERMANENT_REDIRECT: u32 = 308u32;
pub const HTTP_STATUS_PRECOND_FAILED: u32 = 412u32;
pub const HTTP_STATUS_PROXY_AUTH_REQ: u32 = 407u32;
pub const HTTP_STATUS_REDIRECT: u32 = 302u32;
pub const HTTP_STATUS_REDIRECT_KEEP_VERB: u32 = 307u32;
pub const HTTP_STATUS_REDIRECT_METHOD: u32 = 303u32;
pub const HTTP_STATUS_REQUEST_TIMEOUT: u32 = 408u32;
pub const HTTP_STATUS_REQUEST_TOO_LARGE: u32 = 413u32;
pub const HTTP_STATUS_RESET_CONTENT: u32 = 205u32;
pub const HTTP_STATUS_RETRY_WITH: u32 = 449u32;
pub const HTTP_STATUS_SERVER_ERROR: u32 = 500u32;
pub const HTTP_STATUS_SERVICE_UNAVAIL: u32 = 503u32;
pub const HTTP_STATUS_SWITCH_PROTOCOLS: u32 = 101u32;
pub const HTTP_STATUS_UNSUPPORTED_MEDIA: u32 = 415u32;
pub const HTTP_STATUS_URI_TOO_LONG: u32 = 414u32;
pub const HTTP_STATUS_USE_PROXY: u32 = 305u32;
pub const HTTP_STATUS_VERSION_NOT_SUP: u32 = 505u32;
pub const HTTP_STATUS_WEBDAV_MULTI_STATUS: u32 = 207u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct HTTP_VERSION_INFO {
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
}
impl HTTP_VERSION_INFO {}
impl ::std::default::Default for HTTP_VERSION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for HTTP_VERSION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HTTP_VERSION_INFO").field("dwMajorVersion", &self.dwMajorVersion).field("dwMinorVersion", &self.dwMinorVersion).finish()
    }
}
impl ::std::cmp::PartialEq for HTTP_VERSION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwMajorVersion == other.dwMajorVersion && self.dwMinorVersion == other.dwMinorVersion
    }
}
impl ::std::cmp::Eq for HTTP_VERSION_INFO {}
unsafe impl ::windows::runtime::Abi for HTTP_VERSION_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ICU_BROWSER_MODE: u32 = 33554432u32;
pub const ICU_ENCODE_PERCENT: u32 = 4096u32;
pub const ICU_ENCODE_SPACES_ONLY: u32 = 67108864u32;
pub const ICU_ESCAPE_AUTHORITY: u32 = 8192u32;
pub const ICU_NO_ENCODE: u32 = 536870912u32;
pub const ICU_NO_META: u32 = 134217728u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct INTERNET_PORT(pub u32);
pub const INTERNET_DEFAULT_HTTP_PORT: INTERNET_PORT = INTERNET_PORT(80u32);
pub const INTERNET_DEFAULT_HTTPS_PORT: INTERNET_PORT = INTERNET_PORT(443u32);
pub const INTERNET_DEFAULT_PORT: INTERNET_PORT = INTERNET_PORT(0u32);
impl ::std::convert::From<u32> for INTERNET_PORT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for INTERNET_PORT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for INTERNET_PORT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for INTERNET_PORT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for INTERNET_PORT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for INTERNET_PORT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for INTERNET_PORT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub type LPWINHTTP_STATUS_CALLBACK = unsafe extern "system" fn();
pub const NETWORKING_KEY_BUFSIZE: u32 = 128u32;
pub const SECURITY_FLAG_IGNORE_CERT_CN_INVALID: u32 = 4096u32;
pub const SECURITY_FLAG_IGNORE_CERT_DATE_INVALID: u32 = 8192u32;
pub const SECURITY_FLAG_IGNORE_CERT_WRONG_USAGE: u32 = 512u32;
pub const SECURITY_FLAG_IGNORE_UNKNOWN_CA: u32 = 256u32;
pub const SECURITY_FLAG_SECURE: u32 = 1u32;
pub const SECURITY_FLAG_STRENGTH_MEDIUM: u32 = 1073741824u32;
pub const SECURITY_FLAG_STRENGTH_STRONG: u32 = 536870912u32;
pub const SECURITY_FLAG_STRENGTH_WEAK: u32 = 268435456u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct URL_COMPONENTS {
    pub dwStructSize: u32,
    pub lpszScheme: super::super::Foundation::PWSTR,
    pub dwSchemeLength: u32,
    pub nScheme: WINHTTP_INTERNET_SCHEME,
    pub lpszHostName: super::super::Foundation::PWSTR,
    pub dwHostNameLength: u32,
    pub nPort: u16,
    pub lpszUserName: super::super::Foundation::PWSTR,
    pub dwUserNameLength: u32,
    pub lpszPassword: super::super::Foundation::PWSTR,
    pub dwPasswordLength: u32,
    pub lpszUrlPath: super::super::Foundation::PWSTR,
    pub dwUrlPathLength: u32,
    pub lpszExtraInfo: super::super::Foundation::PWSTR,
    pub dwExtraInfoLength: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl URL_COMPONENTS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for URL_COMPONENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for URL_COMPONENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("URL_COMPONENTS")
            .field("dwStructSize", &self.dwStructSize)
            .field("lpszScheme", &self.lpszScheme)
            .field("dwSchemeLength", &self.dwSchemeLength)
            .field("nScheme", &self.nScheme)
            .field("lpszHostName", &self.lpszHostName)
            .field("dwHostNameLength", &self.dwHostNameLength)
            .field("nPort", &self.nPort)
            .field("lpszUserName", &self.lpszUserName)
            .field("dwUserNameLength", &self.dwUserNameLength)
            .field("lpszPassword", &self.lpszPassword)
            .field("dwPasswordLength", &self.dwPasswordLength)
            .field("lpszUrlPath", &self.lpszUrlPath)
            .field("dwUrlPathLength", &self.dwUrlPathLength)
            .field("lpszExtraInfo", &self.lpszExtraInfo)
            .field("dwExtraInfoLength", &self.dwExtraInfoLength)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for URL_COMPONENTS {
    fn eq(&self, other: &Self) -> bool {
        self.dwStructSize == other.dwStructSize
            && self.lpszScheme == other.lpszScheme
            && self.dwSchemeLength == other.dwSchemeLength
            && self.nScheme == other.nScheme
            && self.lpszHostName == other.lpszHostName
            && self.dwHostNameLength == other.dwHostNameLength
            && self.nPort == other.nPort
            && self.lpszUserName == other.lpszUserName
            && self.dwUserNameLength == other.dwUserNameLength
            && self.lpszPassword == other.lpszPassword
            && self.dwPasswordLength == other.dwPasswordLength
            && self.lpszUrlPath == other.lpszUrlPath
            && self.dwUrlPathLength == other.dwUrlPathLength
            && self.lpszExtraInfo == other.lpszExtraInfo
            && self.dwExtraInfoLength == other.dwExtraInfoLength
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for URL_COMPONENTS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for URL_COMPONENTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_ACCESS_TYPE(pub u32);
pub const WINHTTP_ACCESS_TYPE_NO_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(1u32);
pub const WINHTTP_ACCESS_TYPE_DEFAULT_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(0u32);
pub const WINHTTP_ACCESS_TYPE_NAMED_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(3u32);
pub const WINHTTP_ACCESS_TYPE_AUTOMATIC_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(4u32);
impl ::std::convert::From<u32> for WINHTTP_ACCESS_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_ACCESS_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for WINHTTP_ACCESS_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for WINHTTP_ACCESS_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for WINHTTP_ACCESS_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for WINHTTP_ACCESS_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for WINHTTP_ACCESS_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const WINHTTP_ADDREQ_FLAGS_MASK: u32 = 4294901760u32;
pub const WINHTTP_ADDREQ_FLAG_ADD: u32 = 536870912u32;
pub const WINHTTP_ADDREQ_FLAG_ADD_IF_NEW: u32 = 268435456u32;
pub const WINHTTP_ADDREQ_FLAG_COALESCE: u32 = 1073741824u32;
pub const WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA: u32 = 1073741824u32;
pub const WINHTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON: u32 = 16777216u32;
pub const WINHTTP_ADDREQ_FLAG_REPLACE: u32 = 2147483648u32;
pub const WINHTTP_ADDREQ_INDEX_MASK: u32 = 65535u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_ASYNC_RESULT {
    pub dwResult: usize,
    pub dwError: u32,
}
impl WINHTTP_ASYNC_RESULT {}
impl ::std::default::Default for WINHTTP_ASYNC_RESULT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_ASYNC_RESULT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_ASYNC_RESULT").field("dwResult", &self.dwResult).field("dwError", &self.dwError).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_ASYNC_RESULT {
    fn eq(&self, other: &Self) -> bool {
        self.dwResult == other.dwResult && self.dwError == other.dwError
    }
}
impl ::std::cmp::Eq for WINHTTP_ASYNC_RESULT {}
unsafe impl ::windows::runtime::Abi for WINHTTP_ASYNC_RESULT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_AUTH_SCHEME_DIGEST: u32 = 8u32;
pub const WINHTTP_AUTH_SCHEME_PASSPORT: u32 = 4u32;
pub const WINHTTP_AUTH_TARGET_PROXY: u32 = 1u32;
pub const WINHTTP_AUTH_TARGET_SERVER: u32 = 0u32;
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_DEFAULT: u32 = 0u32;
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_HIGH: u32 = 2u32;
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_LOW: u32 = 1u32;
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_MEDIUM: u32 = 0u32;
pub const WINHTTP_AUTOPROXY_ALLOW_AUTOCONFIG: u32 = 256u32;
pub const WINHTTP_AUTOPROXY_ALLOW_CM: u32 = 1024u32;
pub const WINHTTP_AUTOPROXY_ALLOW_STATIC: u32 = 512u32;
pub const WINHTTP_AUTOPROXY_AUTO_DETECT: u32 = 1u32;
pub const WINHTTP_AUTOPROXY_CONFIG_URL: u32 = 2u32;
pub const WINHTTP_AUTOPROXY_HOST_KEEPCASE: u32 = 4u32;
pub const WINHTTP_AUTOPROXY_HOST_LOWERCASE: u32 = 8u32;
pub const WINHTTP_AUTOPROXY_NO_CACHE_CLIENT: u32 = 524288u32;
pub const WINHTTP_AUTOPROXY_NO_CACHE_SVC: u32 = 1048576u32;
pub const WINHTTP_AUTOPROXY_NO_DIRECTACCESS: u32 = 262144u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_AUTOPROXY_OPTIONS {
    pub dwFlags: u32,
    pub dwAutoDetectFlags: u32,
    pub lpszAutoConfigUrl: super::super::Foundation::PWSTR,
    pub lpvReserved: *mut ::std::ffi::c_void,
    pub dwReserved: u32,
    pub fAutoLogonIfChallenged: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_AUTOPROXY_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_AUTOPROXY_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_AUTOPROXY_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_AUTOPROXY_OPTIONS")
            .field("dwFlags", &self.dwFlags)
            .field("dwAutoDetectFlags", &self.dwAutoDetectFlags)
            .field("lpszAutoConfigUrl", &self.lpszAutoConfigUrl)
            .field("lpvReserved", &self.lpvReserved)
            .field("dwReserved", &self.dwReserved)
            .field("fAutoLogonIfChallenged", &self.fAutoLogonIfChallenged)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_AUTOPROXY_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwAutoDetectFlags == other.dwAutoDetectFlags && self.lpszAutoConfigUrl == other.lpszAutoConfigUrl && self.lpvReserved == other.lpvReserved && self.dwReserved == other.dwReserved && self.fAutoLogonIfChallenged == other.fAutoLogonIfChallenged
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_AUTOPROXY_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_AUTOPROXY_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_AUTOPROXY_RUN_INPROCESS: u32 = 65536u32;
pub const WINHTTP_AUTOPROXY_RUN_OUTPROCESS_ONLY: u32 = 131072u32;
pub const WINHTTP_AUTOPROXY_SORT_RESULTS: u32 = 4194304u32;
pub const WINHTTP_AUTO_DETECT_TYPE_DHCP: u32 = 1u32;
pub const WINHTTP_AUTO_DETECT_TYPE_DNS_A: u32 = 2u32;
pub const WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS: u32 = 4294967295u32;
pub const WINHTTP_CALLBACK_FLAG_DATA_AVAILABLE: u32 = 262144u32;
pub const WINHTTP_CALLBACK_FLAG_DETECTING_PROXY: u32 = 4096u32;
pub const WINHTTP_CALLBACK_FLAG_GETPROXYFORURL_COMPLETE: u32 = 16777216u32;
pub const WINHTTP_CALLBACK_FLAG_HEADERS_AVAILABLE: u32 = 131072u32;
pub const WINHTTP_CALLBACK_FLAG_INTERMEDIATE_RESPONSE: u32 = 32768u32;
pub const WINHTTP_CALLBACK_FLAG_READ_COMPLETE: u32 = 524288u32;
pub const WINHTTP_CALLBACK_FLAG_REDIRECT: u32 = 16384u32;
pub const WINHTTP_CALLBACK_FLAG_REQUEST_ERROR: u32 = 2097152u32;
pub const WINHTTP_CALLBACK_FLAG_SECURE_FAILURE: u32 = 65536u32;
pub const WINHTTP_CALLBACK_FLAG_SENDREQUEST_COMPLETE: u32 = 4194304u32;
pub const WINHTTP_CALLBACK_FLAG_WRITE_COMPLETE: u32 = 1048576u32;
pub const WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE: u32 = 33554432u32;
pub const WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION: u32 = 256u32;
pub const WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER: u32 = 8u32;
pub const WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER: u32 = 4u32;
pub const WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED: u32 = 512u32;
pub const WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE: u32 = 262144u32;
pub const WINHTTP_CALLBACK_STATUS_DETECTING_PROXY: u32 = 4096u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_CN_INVALID: u32 = 16u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_DATE_INVALID: u32 = 32u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_REVOKED: u32 = 4u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_REV_FAILED: u32 = 1u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_WRONG_USAGE: u32 = 64u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CA: u32 = 8u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CERT: u32 = 2u32;
pub const WINHTTP_CALLBACK_STATUS_FLAG_SECURITY_CHANNEL_ERROR: u32 = 2147483648u32;
pub const WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE: u32 = 16777216u32;
pub const WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING: u32 = 2048u32;
pub const WINHTTP_CALLBACK_STATUS_HANDLE_CREATED: u32 = 1024u32;
pub const WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE: u32 = 131072u32;
pub const WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE: u32 = 32768u32;
pub const WINHTTP_CALLBACK_STATUS_NAME_RESOLVED: u32 = 2u32;
pub const WINHTTP_CALLBACK_STATUS_READ_COMPLETE: u32 = 524288u32;
pub const WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE: u32 = 64u32;
pub const WINHTTP_CALLBACK_STATUS_REDIRECT: u32 = 16384u32;
pub const WINHTTP_CALLBACK_STATUS_REQUEST_ERROR: u32 = 2097152u32;
pub const WINHTTP_CALLBACK_STATUS_REQUEST_SENT: u32 = 32u32;
pub const WINHTTP_CALLBACK_STATUS_RESOLVING_NAME: u32 = 1u32;
pub const WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED: u32 = 128u32;
pub const WINHTTP_CALLBACK_STATUS_SECURE_FAILURE: u32 = 65536u32;
pub const WINHTTP_CALLBACK_STATUS_SENDING_REQUEST: u32 = 16u32;
pub const WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE: u32 = 4194304u32;
pub const WINHTTP_CALLBACK_STATUS_SETTINGS_READ_COMPLETE: u32 = 536870912u32;
pub const WINHTTP_CALLBACK_STATUS_SETTINGS_WRITE_COMPLETE: u32 = 268435456u32;
pub const WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE: u32 = 67108864u32;
pub const WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE: u32 = 1048576u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CERTIFICATE_INFO {
    pub ftExpiry: super::super::Foundation::FILETIME,
    pub ftStart: super::super::Foundation::FILETIME,
    pub lpszSubjectInfo: super::super::Foundation::PWSTR,
    pub lpszIssuerInfo: super::super::Foundation::PWSTR,
    pub lpszProtocolName: super::super::Foundation::PWSTR,
    pub lpszSignatureAlgName: super::super::Foundation::PWSTR,
    pub lpszEncryptionAlgName: super::super::Foundation::PWSTR,
    pub dwKeySize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_CERTIFICATE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_CERTIFICATE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_CERTIFICATE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CERTIFICATE_INFO")
            .field("ftExpiry", &self.ftExpiry)
            .field("ftStart", &self.ftStart)
            .field("lpszSubjectInfo", &self.lpszSubjectInfo)
            .field("lpszIssuerInfo", &self.lpszIssuerInfo)
            .field("lpszProtocolName", &self.lpszProtocolName)
            .field("lpszSignatureAlgName", &self.lpszSignatureAlgName)
            .field("lpszEncryptionAlgName", &self.lpszEncryptionAlgName)
            .field("dwKeySize", &self.dwKeySize)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_CERTIFICATE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ftExpiry == other.ftExpiry && self.ftStart == other.ftStart && self.lpszSubjectInfo == other.lpszSubjectInfo && self.lpszIssuerInfo == other.lpszIssuerInfo && self.lpszProtocolName == other.lpszProtocolName && self.lpszSignatureAlgName == other.lpszSignatureAlgName && self.lpszEncryptionAlgName == other.lpszEncryptionAlgName && self.dwKeySize == other.dwKeySize
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_CERTIFICATE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_CERTIFICATE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_CONNECTION_GROUP {
    pub cConnections: u32,
    pub guidGroup: ::windows::runtime::GUID,
}
impl WINHTTP_CONNECTION_GROUP {}
impl ::std::default::Default for WINHTTP_CONNECTION_GROUP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_CONNECTION_GROUP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CONNECTION_GROUP").field("cConnections", &self.cConnections).field("guidGroup", &self.guidGroup).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_CONNECTION_GROUP {
    fn eq(&self, other: &Self) -> bool {
        self.cConnections == other.cConnections && self.guidGroup == other.guidGroup
    }
}
impl ::std::cmp::Eq for WINHTTP_CONNECTION_GROUP {}
unsafe impl ::windows::runtime::Abi for WINHTTP_CONNECTION_GROUP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
pub struct WINHTTP_CONNECTION_INFO {
    pub cbSize: u32,
    pub LocalAddress: super::WinSock::SOCKADDR_STORAGE,
    pub RemoteAddress: super::WinSock::SOCKADDR_STORAGE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl WINHTTP_CONNECTION_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::std::default::Default for WINHTTP_CONNECTION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::std::fmt::Debug for WINHTTP_CONNECTION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CONNECTION_INFO").field("cbSize", &self.cbSize).field("LocalAddress", &self.LocalAddress).field("RemoteAddress", &self.RemoteAddress).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::std::cmp::PartialEq for WINHTTP_CONNECTION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.LocalAddress == other.LocalAddress && self.RemoteAddress == other.RemoteAddress
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::std::cmp::Eq for WINHTTP_CONNECTION_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
unsafe impl ::windows::runtime::Abi for WINHTTP_CONNECTION_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_CONNECTION_RETRY_CONDITION_408: u32 = 1u32;
pub const WINHTTP_CONNECTION_RETRY_CONDITION_SSL_HANDSHAKE: u32 = 2u32;
pub const WINHTTP_CONNECTION_RETRY_CONDITION_STALE_CONNECTION: u32 = 4u32;
pub const WINHTTP_CONNS_PER_SERVER_UNLIMITED: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CREDS {
    pub lpszUserName: super::super::Foundation::PSTR,
    pub lpszPassword: super::super::Foundation::PSTR,
    pub lpszRealm: super::super::Foundation::PSTR,
    pub dwAuthScheme: WINHTTP_CREDS_AUTHSCHEME,
    pub lpszHostName: super::super::Foundation::PSTR,
    pub dwPort: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_CREDS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_CREDS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_CREDS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CREDS").field("lpszUserName", &self.lpszUserName).field("lpszPassword", &self.lpszPassword).field("lpszRealm", &self.lpszRealm).field("dwAuthScheme", &self.dwAuthScheme).field("lpszHostName", &self.lpszHostName).field("dwPort", &self.dwPort).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_CREDS {
    fn eq(&self, other: &Self) -> bool {
        self.lpszUserName == other.lpszUserName && self.lpszPassword == other.lpszPassword && self.lpszRealm == other.lpszRealm && self.dwAuthScheme == other.dwAuthScheme && self.lpszHostName == other.lpszHostName && self.dwPort == other.dwPort
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_CREDS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_CREDS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_CREDS_AUTHSCHEME(pub u32);
pub const WINHTTP_AUTH_SCHEME_BASIC: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(1u32);
pub const WINHTTP_AUTH_SCHEME_NTLM: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(2u32);
pub const WINHTTP_AUTH_SCHEME_NEGOTIATE: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(16u32);
impl ::std::convert::From<u32> for WINHTTP_CREDS_AUTHSCHEME {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_CREDS_AUTHSCHEME {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for WINHTTP_CREDS_AUTHSCHEME {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for WINHTTP_CREDS_AUTHSCHEME {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for WINHTTP_CREDS_AUTHSCHEME {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for WINHTTP_CREDS_AUTHSCHEME {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for WINHTTP_CREDS_AUTHSCHEME {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CREDS_EX {
    pub lpszUserName: super::super::Foundation::PSTR,
    pub lpszPassword: super::super::Foundation::PSTR,
    pub lpszRealm: super::super::Foundation::PSTR,
    pub dwAuthScheme: WINHTTP_CREDS_AUTHSCHEME,
    pub lpszHostName: super::super::Foundation::PSTR,
    pub dwPort: u32,
    pub lpszUrl: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_CREDS_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_CREDS_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_CREDS_EX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CREDS_EX")
            .field("lpszUserName", &self.lpszUserName)
            .field("lpszPassword", &self.lpszPassword)
            .field("lpszRealm", &self.lpszRealm)
            .field("dwAuthScheme", &self.dwAuthScheme)
            .field("lpszHostName", &self.lpszHostName)
            .field("dwPort", &self.dwPort)
            .field("lpszUrl", &self.lpszUrl)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_CREDS_EX {
    fn eq(&self, other: &Self) -> bool {
        self.lpszUserName == other.lpszUserName && self.lpszPassword == other.lpszPassword && self.lpszRealm == other.lpszRealm && self.dwAuthScheme == other.dwAuthScheme && self.lpszHostName == other.lpszHostName && self.dwPort == other.dwPort && self.lpszUrl == other.lpszUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_CREDS_EX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_CREDS_EX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    pub fAutoDetect: super::super::Foundation::BOOL,
    pub lpszAutoConfigUrl: super::super::Foundation::PWSTR,
    pub lpszProxy: super::super::Foundation::PWSTR,
    pub lpszProxyBypass: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_CURRENT_USER_IE_PROXY_CONFIG").field("fAutoDetect", &self.fAutoDetect).field("lpszAutoConfigUrl", &self.lpszAutoConfigUrl).field("lpszProxy", &self.lpszProxy).field("lpszProxyBypass", &self.lpszProxyBypass).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.fAutoDetect == other.fAutoDetect && self.lpszAutoConfigUrl == other.lpszAutoConfigUrl && self.lpszProxy == other.lpszProxy && self.lpszProxyBypass == other.lpszProxyBypass
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_DECOMPRESSION_FLAG_DEFLATE: u32 = 2u32;
pub const WINHTTP_DECOMPRESSION_FLAG_GZIP: u32 = 1u32;
pub const WINHTTP_DISABLE_AUTHENTICATION: u32 = 4u32;
pub const WINHTTP_DISABLE_COOKIES: u32 = 1u32;
pub const WINHTTP_DISABLE_KEEP_ALIVE: u32 = 8u32;
pub const WINHTTP_DISABLE_PASSPORT_AUTH: u32 = 0u32;
pub const WINHTTP_DISABLE_PASSPORT_KEYRING: u32 = 536870912u32;
pub const WINHTTP_DISABLE_REDIRECTS: u32 = 2u32;
pub const WINHTTP_DISABLE_SPN_SERVER_PORT: u32 = 0u32;
pub const WINHTTP_ENABLE_PASSPORT_AUTH: u32 = 268435456u32;
pub const WINHTTP_ENABLE_PASSPORT_KEYRING: u32 = 1073741824u32;
pub const WINHTTP_ENABLE_SPN_SERVER_PORT: u32 = 1u32;
pub const WINHTTP_ENABLE_SSL_REVERT_IMPERSONATION: u32 = 2u32;
pub const WINHTTP_ENABLE_SSL_REVOCATION: u32 = 1u32;
pub const WINHTTP_ERROR_BASE: u32 = 12000u32;
pub const WINHTTP_ERROR_LAST: u32 = 12192u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_EXTENDED_HEADER {
    pub Anonymous1: WINHTTP_EXTENDED_HEADER_0,
    pub Anonymous2: WINHTTP_EXTENDED_HEADER_1,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_EXTENDED_HEADER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_EXTENDED_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_EXTENDED_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_EXTENDED_HEADER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_EXTENDED_HEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WINHTTP_EXTENDED_HEADER_0 {
    pub pwszName: super::super::Foundation::PWSTR,
    pub pszName: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_EXTENDED_HEADER_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_EXTENDED_HEADER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_EXTENDED_HEADER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_EXTENDED_HEADER_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_EXTENDED_HEADER_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WINHTTP_EXTENDED_HEADER_1 {
    pub pwszValue: super::super::Foundation::PWSTR,
    pub pszValue: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_EXTENDED_HEADER_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_EXTENDED_HEADER_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_EXTENDED_HEADER_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_EXTENDED_HEADER_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_EXTENDED_HEADER_1 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_EXTENDED_HEADER_FLAG_UNICODE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_FAILED_CONNECTION_RETRIES {
    pub dwMaxRetries: u32,
    pub dwAllowedRetryConditions: u32,
}
impl WINHTTP_FAILED_CONNECTION_RETRIES {}
impl ::std::default::Default for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_FAILED_CONNECTION_RETRIES").field("dwMaxRetries", &self.dwMaxRetries).field("dwAllowedRetryConditions", &self.dwAllowedRetryConditions).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn eq(&self, other: &Self) -> bool {
        self.dwMaxRetries == other.dwMaxRetries && self.dwAllowedRetryConditions == other.dwAllowedRetryConditions
    }
}
impl ::std::cmp::Eq for WINHTTP_FAILED_CONNECTION_RETRIES {}
unsafe impl ::windows::runtime::Abi for WINHTTP_FAILED_CONNECTION_RETRIES {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_FLAG_ASYNC: u32 = 268435456u32;
pub const WINHTTP_FLAG_SECURE_DEFAULTS: u32 = 805306368u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_SSL2: u32 = 8u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_SSL3: u32 = 32u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1: u32 = 128u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_1: u32 = 512u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_2: u32 = 2048u32;
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_3: u32 = 8192u32;
pub const WINHTTP_HANDLE_TYPE_CONNECT: u32 = 2u32;
pub const WINHTTP_HANDLE_TYPE_REQUEST: u32 = 3u32;
pub const WINHTTP_HANDLE_TYPE_SESSION: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WINHTTP_HEADER_NAME {
    pub pwszName: super::super::Foundation::PWSTR,
    pub pszName: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_HEADER_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_HEADER_NAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_HEADER_NAME {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_HEADER_NAME {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_HEADER_NAME {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_HOST_CONNECTION_GROUP {
    pub pwszHost: super::super::Foundation::PWSTR,
    pub cConnectionGroups: u32,
    pub pConnectionGroups: *mut WINHTTP_CONNECTION_GROUP,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_HOST_CONNECTION_GROUP {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_HOST_CONNECTION_GROUP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_HOST_CONNECTION_GROUP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_HOST_CONNECTION_GROUP").field("pwszHost", &self.pwszHost).field("cConnectionGroups", &self.cConnectionGroups).field("pConnectionGroups", &self.pConnectionGroups).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_HOST_CONNECTION_GROUP {
    fn eq(&self, other: &Self) -> bool {
        self.pwszHost == other.pwszHost && self.cConnectionGroups == other.cConnectionGroups && self.pConnectionGroups == other.pConnectionGroups
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_HOST_CONNECTION_GROUP {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_HOST_CONNECTION_GROUP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_HTTP2_RECEIVE_WINDOW {
    pub ulStreamWindow: u32,
    pub ulStreamWindowUpdateDelta: u32,
}
impl WINHTTP_HTTP2_RECEIVE_WINDOW {}
impl ::std::default::Default for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_HTTP2_RECEIVE_WINDOW").field("ulStreamWindow", &self.ulStreamWindow).field("ulStreamWindowUpdateDelta", &self.ulStreamWindowUpdateDelta).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn eq(&self, other: &Self) -> bool {
        self.ulStreamWindow == other.ulStreamWindow && self.ulStreamWindowUpdateDelta == other.ulStreamWindowUpdateDelta
    }
}
impl ::std::cmp::Eq for WINHTTP_HTTP2_RECEIVE_WINDOW {}
unsafe impl ::windows::runtime::Abi for WINHTTP_HTTP2_RECEIVE_WINDOW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_IGNORE_REQUEST_TOTAL_LENGTH: u32 = 0u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_INTERNET_SCHEME(pub u32);
pub const WINHTTP_INTERNET_SCHEME_HTTP: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(1u32);
pub const WINHTTP_INTERNET_SCHEME_HTTPS: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(2u32);
pub const WINHTTP_INTERNET_SCHEME_FTP: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(3u32);
pub const WINHTTP_INTERNET_SCHEME_SOCKS: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(4u32);
impl ::std::convert::From<u32> for WINHTTP_INTERNET_SCHEME {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_INTERNET_SCHEME {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for WINHTTP_INTERNET_SCHEME {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for WINHTTP_INTERNET_SCHEME {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for WINHTTP_INTERNET_SCHEME {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for WINHTTP_INTERNET_SCHEME {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for WINHTTP_INTERNET_SCHEME {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const WINHTTP_LAST_OPTION: u32 = 183u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_MATCH_CONNECTION_GUID {
    pub ConnectionGuid: ::windows::runtime::GUID,
    pub ullFlags: u64,
}
impl WINHTTP_MATCH_CONNECTION_GUID {}
impl ::std::default::Default for WINHTTP_MATCH_CONNECTION_GUID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_MATCH_CONNECTION_GUID {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_MATCH_CONNECTION_GUID").field("ConnectionGuid", &self.ConnectionGuid).field("ullFlags", &self.ullFlags).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_MATCH_CONNECTION_GUID {
    fn eq(&self, other: &Self) -> bool {
        self.ConnectionGuid == other.ConnectionGuid && self.ullFlags == other.ullFlags
    }
}
impl ::std::cmp::Eq for WINHTTP_MATCH_CONNECTION_GUID {}
unsafe impl ::windows::runtime::Abi for WINHTTP_MATCH_CONNECTION_GUID {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_MATCH_CONNECTION_GUID_FLAGS_MASK: u32 = 1u32;
pub const WINHTTP_MATCH_CONNECTION_GUID_FLAG_REQUIRE_MARKED_CONNECTION: u32 = 1u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_OPEN_REQUEST_FLAGS(pub u32);
pub const WINHTTP_FLAG_BYPASS_PROXY_CACHE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(256u32);
pub const WINHTTP_FLAG_ESCAPE_DISABLE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(64u32);
pub const WINHTTP_FLAG_ESCAPE_DISABLE_QUERY: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(128u32);
pub const WINHTTP_FLAG_ESCAPE_PERCENT: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(4u32);
pub const WINHTTP_FLAG_NULL_CODEPAGE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(8u32);
pub const WINHTTP_FLAG_REFRESH: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(256u32);
pub const WINHTTP_FLAG_SECURE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(8388608u32);
impl ::std::convert::From<u32> for WINHTTP_OPEN_REQUEST_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_OPEN_REQUEST_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for WINHTTP_OPEN_REQUEST_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for WINHTTP_OPEN_REQUEST_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const WINHTTP_OPTION_AGGREGATE_PROXY_CONFIG: u32 = 181u32;
pub const WINHTTP_OPTION_ASSURED_NON_BLOCKING_CALLBACKS: u32 = 111u32;
pub const WINHTTP_OPTION_AUTOLOGON_POLICY: u32 = 77u32;
pub const WINHTTP_OPTION_BACKGROUND_CONNECTIONS: u32 = 172u32;
pub const WINHTTP_OPTION_CALLBACK: u32 = 1u32;
pub const WINHTTP_OPTION_CLIENT_CERT_CONTEXT: u32 = 47u32;
pub const WINHTTP_OPTION_CLIENT_CERT_ISSUER_LIST: u32 = 94u32;
pub const WINHTTP_OPTION_CODEPAGE: u32 = 68u32;
pub const WINHTTP_OPTION_CONFIGURE_PASSPORT_AUTH: u32 = 83u32;
pub const WINHTTP_OPTION_CONNECTION_FILTER: u32 = 131u32;
pub const WINHTTP_OPTION_CONNECTION_GUID: u32 = 178u32;
pub const WINHTTP_OPTION_CONNECTION_INFO: u32 = 93u32;
pub const WINHTTP_OPTION_CONNECTION_STATS_V0: u32 = 141u32;
pub const WINHTTP_OPTION_CONNECTION_STATS_V1: u32 = 150u32;
pub const WINHTTP_OPTION_CONNECT_RETRIES: u32 = 4u32;
pub const WINHTTP_OPTION_CONNECT_TIMEOUT: u32 = 3u32;
pub const WINHTTP_OPTION_CONTEXT_VALUE: u32 = 45u32;
pub const WINHTTP_OPTION_DECOMPRESSION: u32 = 118u32;
pub const WINHTTP_OPTION_DISABLE_CERT_CHAIN_BUILDING: u32 = 171u32;
pub const WINHTTP_OPTION_DISABLE_FEATURE: u32 = 63u32;
pub const WINHTTP_OPTION_DISABLE_PROXY_LINK_LOCAL_NAME_RESOLUTION: u32 = 176u32;
pub const WINHTTP_OPTION_DISABLE_SECURE_PROTOCOL_FALLBACK: u32 = 144u32;
pub const WINHTTP_OPTION_DISABLE_STREAM_QUEUE: u32 = 139u32;
pub const WINHTTP_OPTION_ENABLETRACING: u32 = 85u32;
pub const WINHTTP_OPTION_ENABLE_FEATURE: u32 = 79u32;
pub const WINHTTP_OPTION_ENABLE_HTTP2_PLUS_CLIENT_CERT: u32 = 161u32;
pub const WINHTTP_OPTION_ENABLE_HTTP_PROTOCOL: u32 = 133u32;
pub const WINHTTP_OPTION_ENABLE_TEST_SIGNING: u32 = 174u32;
pub const WINHTTP_OPTION_ENCODE_EXTRA: u32 = 138u32;
pub const WINHTTP_OPTION_EXPIRE_CONNECTION: u32 = 143u32;
pub const WINHTTP_OPTION_EXTENDED_ERROR: u32 = 24u32;
pub const WINHTTP_OPTION_FAILED_CONNECTION_RETRIES: u32 = 162u32;
pub const WINHTTP_OPTION_FIRST_AVAILABLE_CONNECTION: u32 = 173u32;
pub const WINHTTP_OPTION_GLOBAL_PROXY_CREDS: u32 = 97u32;
pub const WINHTTP_OPTION_GLOBAL_SERVER_CREDS: u32 = 98u32;
pub const WINHTTP_OPTION_HANDLE_TYPE: u32 = 9u32;
pub const WINHTTP_OPTION_HEAP_EXTENSION: u32 = 157u32;
pub const WINHTTP_OPTION_HTTP2_KEEPALIVE: u32 = 164u32;
pub const WINHTTP_OPTION_HTTP2_PLUS_TRANSFER_ENCODING: u32 = 169u32;
pub const WINHTTP_OPTION_HTTP2_RECEIVE_WINDOW: u32 = 183u32;
pub const WINHTTP_OPTION_HTTP_PROTOCOL_REQUIRED: u32 = 145u32;
pub const WINHTTP_OPTION_HTTP_PROTOCOL_USED: u32 = 134u32;
pub const WINHTTP_OPTION_HTTP_VERSION: u32 = 59u32;
pub const WINHTTP_OPTION_IGNORE_CERT_REVOCATION_OFFLINE: u32 = 155u32;
pub const WINHTTP_OPTION_IPV6_FAST_FALLBACK: u32 = 140u32;
pub const WINHTTP_OPTION_IS_PROXY_CONNECT_RESPONSE: u32 = 104u32;
pub const WINHTTP_OPTION_KDC_PROXY_SETTINGS: u32 = 136u32;
pub const WINHTTP_OPTION_MATCH_CONNECTION_GUID: u32 = 179u32;
pub const WINHTTP_OPTION_MAX_CONNS_PER_1_0_SERVER: u32 = 74u32;
pub const WINHTTP_OPTION_MAX_CONNS_PER_SERVER: u32 = 73u32;
pub const WINHTTP_OPTION_MAX_HTTP_AUTOMATIC_REDIRECTS: u32 = 89u32;
pub const WINHTTP_OPTION_MAX_HTTP_STATUS_CONTINUE: u32 = 90u32;
pub const WINHTTP_OPTION_MAX_RESPONSE_DRAIN_SIZE: u32 = 92u32;
pub const WINHTTP_OPTION_MAX_RESPONSE_HEADER_SIZE: u32 = 91u32;
pub const WINHTTP_OPTION_NTSERVICE_FLAG_TEST: u32 = 175u32;
pub const WINHTTP_OPTION_PARENT_HANDLE: u32 = 21u32;
pub const WINHTTP_OPTION_PASSPORT_COBRANDING_TEXT: u32 = 81u32;
pub const WINHTTP_OPTION_PASSPORT_COBRANDING_URL: u32 = 82u32;
pub const WINHTTP_OPTION_PASSPORT_RETURN_URL: u32 = 87u32;
pub const WINHTTP_OPTION_PASSPORT_SIGN_OUT: u32 = 86u32;
pub const WINHTTP_OPTION_PASSWORD: u32 = 4097u32;
pub const WINHTTP_OPTION_PROXY: u32 = 38u32;
pub const WINHTTP_OPTION_PROXY_CONFIG_INFO: u32 = 180u32;
pub const WINHTTP_OPTION_PROXY_DISABLE_SERVICE_CALLS: u32 = 137u32;
pub const WINHTTP_OPTION_PROXY_PASSWORD: u32 = 4099u32;
pub const WINHTTP_OPTION_PROXY_RESULT_ENTRY: u32 = 39u32;
pub const WINHTTP_OPTION_PROXY_SPN_USED: u32 = 107u32;
pub const WINHTTP_OPTION_PROXY_USERNAME: u32 = 4098u32;
pub const WINHTTP_OPTION_READ_BUFFER_SIZE: u32 = 12u32;
pub const WINHTTP_OPTION_RECEIVE_PROXY_CONNECT_RESPONSE: u32 = 103u32;
pub const WINHTTP_OPTION_RECEIVE_RESPONSE_TIMEOUT: u32 = 7u32;
pub const WINHTTP_OPTION_RECEIVE_TIMEOUT: u32 = 6u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY: u32 = 88u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY_ALWAYS: u32 = 2u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY_DEFAULT: u32 = 1u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY_DISALLOW_HTTPS_TO_HTTP: u32 = 1u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY_LAST: u32 = 2u32;
pub const WINHTTP_OPTION_REDIRECT_POLICY_NEVER: u32 = 0u32;
pub const WINHTTP_OPTION_REFERER_TOKEN_BINDING_HOSTNAME: u32 = 168u32;
pub const WINHTTP_OPTION_REJECT_USERPWD_IN_URL: u32 = 100u32;
pub const WINHTTP_OPTION_REQUEST_PRIORITY: u32 = 58u32;
pub const WINHTTP_OPTION_REQUEST_STATS: u32 = 146u32;
pub const WINHTTP_OPTION_REQUEST_TIMES: u32 = 142u32;
pub const WINHTTP_OPTION_REQUIRE_STREAM_END: u32 = 160u32;
pub const WINHTTP_OPTION_RESOLUTION_HOSTNAME: u32 = 165u32;
pub const WINHTTP_OPTION_RESOLVER_CACHE_CONFIG: u32 = 170u32;
pub const WINHTTP_OPTION_RESOLVE_TIMEOUT: u32 = 2u32;
pub const WINHTTP_OPTION_SECURE_PROTOCOLS: u32 = 84u32;
pub const WINHTTP_OPTION_SECURITY_CERTIFICATE_STRUCT: u32 = 32u32;
pub const WINHTTP_OPTION_SECURITY_FLAGS: u32 = 31u32;
pub const WINHTTP_OPTION_SECURITY_INFO: u32 = 151u32;
pub const WINHTTP_OPTION_SECURITY_KEY_BITNESS: u32 = 36u32;
pub const WINHTTP_OPTION_SELECTED_PROXY_CONFIG_INFO: u32 = 182u32;
pub const WINHTTP_OPTION_SEND_TIMEOUT: u32 = 5u32;
pub const WINHTTP_OPTION_SERVER_CBT: u32 = 108u32;
pub const WINHTTP_OPTION_SERVER_CERT_CHAIN_CONTEXT: u32 = 147u32;
pub const WINHTTP_OPTION_SERVER_CERT_CONTEXT: u32 = 78u32;
pub const WINHTTP_OPTION_SERVER_SPN_USED: u32 = 106u32;
pub const WINHTTP_OPTION_SET_GLOBAL_CALLBACK: u32 = 163u32;
pub const WINHTTP_OPTION_SET_TOKEN_BINDING: u32 = 166u32;
pub const WINHTTP_OPTION_SOURCE_ADDRESS: u32 = 156u32;
pub const WINHTTP_OPTION_SPN: u32 = 96u32;
pub const WINHTTP_OPTION_SPN_MASK: u32 = 1u32;
pub const WINHTTP_OPTION_STREAM_ERROR_CODE: u32 = 159u32;
pub const WINHTTP_OPTION_TCP_FAST_OPEN: u32 = 153u32;
pub const WINHTTP_OPTION_TCP_KEEPALIVE: u32 = 152u32;
pub const WINHTTP_OPTION_TCP_PRIORITY_HINT: u32 = 128u32;
pub const WINHTTP_OPTION_TCP_PRIORITY_STATUS: u32 = 177u32;
pub const WINHTTP_OPTION_TLS_FALSE_START: u32 = 154u32;
pub const WINHTTP_OPTION_TLS_PROTOCOL_INSECURE_FALLBACK: u32 = 158u32;
pub const WINHTTP_OPTION_TOKEN_BINDING_PUBLIC_KEY: u32 = 167u32;
pub const WINHTTP_OPTION_UNLOAD_NOTIFY_EVENT: u32 = 99u32;
pub const WINHTTP_OPTION_UNSAFE_HEADER_PARSING: u32 = 110u32;
pub const WINHTTP_OPTION_UPGRADE_TO_WEB_SOCKET: u32 = 114u32;
pub const WINHTTP_OPTION_URL: u32 = 34u32;
pub const WINHTTP_OPTION_USERNAME: u32 = 4096u32;
pub const WINHTTP_OPTION_USER_AGENT: u32 = 41u32;
pub const WINHTTP_OPTION_USE_GLOBAL_SERVER_CREDENTIALS: u32 = 101u32;
pub const WINHTTP_OPTION_WEB_SOCKET_CLOSE_TIMEOUT: u32 = 115u32;
pub const WINHTTP_OPTION_WEB_SOCKET_KEEPALIVE_INTERVAL: u32 = 116u32;
pub const WINHTTP_OPTION_WEB_SOCKET_RECEIVE_BUFFER_SIZE: u32 = 122u32;
pub const WINHTTP_OPTION_WEB_SOCKET_SEND_BUFFER_SIZE: u32 = 123u32;
pub const WINHTTP_OPTION_WORKER_THREAD_COUNT: u32 = 80u32;
pub const WINHTTP_OPTION_WRITE_BUFFER_SIZE: u32 = 13u32;
pub const WINHTTP_PROTOCOL_FLAG_HTTP2: u32 = 1u32;
pub const WINHTTP_PROTOCOL_FLAG_HTTP3: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_INFO {
    pub dwAccessType: WINHTTP_ACCESS_TYPE,
    pub lpszProxy: super::super::Foundation::PWSTR,
    pub lpszProxyBypass: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_PROXY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_PROXY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_PROXY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_PROXY_INFO").field("dwAccessType", &self.dwAccessType).field("lpszProxy", &self.lpszProxy).field("lpszProxyBypass", &self.lpszProxyBypass).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_PROXY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwAccessType == other.dwAccessType && self.lpszProxy == other.lpszProxy && self.lpszProxyBypass == other.lpszProxyBypass
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_PROXY_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_PROXY_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT {
    pub cEntries: u32,
    pub pEntries: *mut WINHTTP_PROXY_RESULT_ENTRY,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_PROXY_RESULT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_PROXY_RESULT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_PROXY_RESULT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_PROXY_RESULT").field("cEntries", &self.cEntries).field("pEntries", &self.pEntries).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_PROXY_RESULT {
    fn eq(&self, other: &Self) -> bool {
        self.cEntries == other.cEntries && self.pEntries == other.pEntries
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_PROXY_RESULT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_PROXY_RESULT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT_ENTRY {
    pub fProxy: super::super::Foundation::BOOL,
    pub fBypass: super::super::Foundation::BOOL,
    pub ProxyScheme: WINHTTP_INTERNET_SCHEME,
    pub pwszProxy: super::super::Foundation::PWSTR,
    pub ProxyPort: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_PROXY_RESULT_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_PROXY_RESULT_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_PROXY_RESULT_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_PROXY_RESULT_ENTRY").field("fProxy", &self.fProxy).field("fBypass", &self.fBypass).field("ProxyScheme", &self.ProxyScheme).field("pwszProxy", &self.pwszProxy).field("ProxyPort", &self.ProxyPort).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_PROXY_RESULT_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.fProxy == other.fProxy && self.fBypass == other.fBypass && self.ProxyScheme == other.ProxyScheme && self.pwszProxy == other.pwszProxy && self.ProxyPort == other.ProxyPort
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_PROXY_RESULT_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_PROXY_RESULT_ENTRY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT_EX {
    pub cEntries: u32,
    pub pEntries: *mut WINHTTP_PROXY_RESULT_ENTRY,
    pub hProxyDetectionHandle: super::super::Foundation::HANDLE,
    pub dwProxyInterfaceAffinity: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_PROXY_RESULT_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_PROXY_RESULT_EX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_PROXY_RESULT_EX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_PROXY_RESULT_EX").field("cEntries", &self.cEntries).field("pEntries", &self.pEntries).field("hProxyDetectionHandle", &self.hProxyDetectionHandle).field("dwProxyInterfaceAffinity", &self.dwProxyInterfaceAffinity).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_PROXY_RESULT_EX {
    fn eq(&self, other: &Self) -> bool {
        self.cEntries == other.cEntries && self.pEntries == other.pEntries && self.hProxyDetectionHandle == other.hProxyDetectionHandle && self.dwProxyInterfaceAffinity == other.dwProxyInterfaceAffinity
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_PROXY_RESULT_EX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_PROXY_RESULT_EX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_SETTINGS {
    pub dwStructSize: u32,
    pub dwFlags: u32,
    pub dwCurrentSettingsVersion: u32,
    pub pwszConnectionName: super::super::Foundation::PWSTR,
    pub pwszProxy: super::super::Foundation::PWSTR,
    pub pwszProxyBypass: super::super::Foundation::PWSTR,
    pub pwszAutoconfigUrl: super::super::Foundation::PWSTR,
    pub pwszAutoconfigSecondaryUrl: super::super::Foundation::PWSTR,
    pub dwAutoDiscoveryFlags: u32,
    pub pwszLastKnownGoodAutoConfigUrl: super::super::Foundation::PWSTR,
    pub dwAutoconfigReloadDelayMins: u32,
    pub ftLastKnownDetectTime: super::super::Foundation::FILETIME,
    pub dwDetectedInterfaceIpCount: u32,
    pub pdwDetectedInterfaceIp: *mut u32,
    pub cNetworkKeys: u32,
    pub pNetworkKeys: *mut _WinHttpProxyNetworkKey,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_PROXY_SETTINGS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_PROXY_SETTINGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_PROXY_SETTINGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_PROXY_SETTINGS")
            .field("dwStructSize", &self.dwStructSize)
            .field("dwFlags", &self.dwFlags)
            .field("dwCurrentSettingsVersion", &self.dwCurrentSettingsVersion)
            .field("pwszConnectionName", &self.pwszConnectionName)
            .field("pwszProxy", &self.pwszProxy)
            .field("pwszProxyBypass", &self.pwszProxyBypass)
            .field("pwszAutoconfigUrl", &self.pwszAutoconfigUrl)
            .field("pwszAutoconfigSecondaryUrl", &self.pwszAutoconfigSecondaryUrl)
            .field("dwAutoDiscoveryFlags", &self.dwAutoDiscoveryFlags)
            .field("pwszLastKnownGoodAutoConfigUrl", &self.pwszLastKnownGoodAutoConfigUrl)
            .field("dwAutoconfigReloadDelayMins", &self.dwAutoconfigReloadDelayMins)
            .field("ftLastKnownDetectTime", &self.ftLastKnownDetectTime)
            .field("dwDetectedInterfaceIpCount", &self.dwDetectedInterfaceIpCount)
            .field("pdwDetectedInterfaceIp", &self.pdwDetectedInterfaceIp)
            .field("cNetworkKeys", &self.cNetworkKeys)
            .field("pNetworkKeys", &self.pNetworkKeys)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_PROXY_SETTINGS {
    fn eq(&self, other: &Self) -> bool {
        self.dwStructSize == other.dwStructSize
            && self.dwFlags == other.dwFlags
            && self.dwCurrentSettingsVersion == other.dwCurrentSettingsVersion
            && self.pwszConnectionName == other.pwszConnectionName
            && self.pwszProxy == other.pwszProxy
            && self.pwszProxyBypass == other.pwszProxyBypass
            && self.pwszAutoconfigUrl == other.pwszAutoconfigUrl
            && self.pwszAutoconfigSecondaryUrl == other.pwszAutoconfigSecondaryUrl
            && self.dwAutoDiscoveryFlags == other.dwAutoDiscoveryFlags
            && self.pwszLastKnownGoodAutoConfigUrl == other.pwszLastKnownGoodAutoConfigUrl
            && self.dwAutoconfigReloadDelayMins == other.dwAutoconfigReloadDelayMins
            && self.ftLastKnownDetectTime == other.ftLastKnownDetectTime
            && self.dwDetectedInterfaceIpCount == other.dwDetectedInterfaceIpCount
            && self.pdwDetectedInterfaceIp == other.pdwDetectedInterfaceIp
            && self.cNetworkKeys == other.cNetworkKeys
            && self.pNetworkKeys == other.pNetworkKeys
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_PROXY_SETTINGS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_PROXY_SETTINGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_PROXY_TYPE_AUTO_DETECT: u32 = 8u32;
pub const WINHTTP_PROXY_TYPE_AUTO_PROXY_URL: u32 = 4u32;
pub const WINHTTP_PROXY_TYPE_DIRECT: u32 = 1u32;
pub const WINHTTP_PROXY_TYPE_PROXY: u32 = 2u32;
pub const WINHTTP_QUERY_ACCEPT: u32 = 24u32;
pub const WINHTTP_QUERY_ACCEPT_CHARSET: u32 = 25u32;
pub const WINHTTP_QUERY_ACCEPT_ENCODING: u32 = 26u32;
pub const WINHTTP_QUERY_ACCEPT_LANGUAGE: u32 = 27u32;
pub const WINHTTP_QUERY_ACCEPT_RANGES: u32 = 42u32;
pub const WINHTTP_QUERY_AGE: u32 = 48u32;
pub const WINHTTP_QUERY_ALLOW: u32 = 7u32;
pub const WINHTTP_QUERY_AUTHENTICATION_INFO: u32 = 76u32;
pub const WINHTTP_QUERY_AUTHORIZATION: u32 = 28u32;
pub const WINHTTP_QUERY_CACHE_CONTROL: u32 = 49u32;
pub const WINHTTP_QUERY_CONNECTION: u32 = 23u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    pub cHosts: u32,
    pub pHostConnectionGroups: *mut WINHTTP_HOST_CONNECTION_GROUP,
}
#[cfg(feature = "Win32_Foundation")]
impl WINHTTP_QUERY_CONNECTION_GROUP_RESULT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_QUERY_CONNECTION_GROUP_RESULT").field("cHosts", &self.cHosts).field("pHostConnectionGroups", &self.pHostConnectionGroups).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn eq(&self, other: &Self) -> bool {
        self.cHosts == other.cHosts && self.pHostConnectionGroups == other.pHostConnectionGroups
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_QUERY_CONTENT_BASE: u32 = 50u32;
pub const WINHTTP_QUERY_CONTENT_DESCRIPTION: u32 = 4u32;
pub const WINHTTP_QUERY_CONTENT_DISPOSITION: u32 = 47u32;
pub const WINHTTP_QUERY_CONTENT_ENCODING: u32 = 29u32;
pub const WINHTTP_QUERY_CONTENT_ID: u32 = 3u32;
pub const WINHTTP_QUERY_CONTENT_LANGUAGE: u32 = 6u32;
pub const WINHTTP_QUERY_CONTENT_LENGTH: u32 = 5u32;
pub const WINHTTP_QUERY_CONTENT_LOCATION: u32 = 51u32;
pub const WINHTTP_QUERY_CONTENT_MD5: u32 = 52u32;
pub const WINHTTP_QUERY_CONTENT_RANGE: u32 = 53u32;
pub const WINHTTP_QUERY_CONTENT_TRANSFER_ENCODING: u32 = 2u32;
pub const WINHTTP_QUERY_CONTENT_TYPE: u32 = 1u32;
pub const WINHTTP_QUERY_COOKIE: u32 = 44u32;
pub const WINHTTP_QUERY_COST: u32 = 15u32;
pub const WINHTTP_QUERY_CUSTOM: u32 = 65535u32;
pub const WINHTTP_QUERY_DATE: u32 = 9u32;
pub const WINHTTP_QUERY_DERIVED_FROM: u32 = 14u32;
pub const WINHTTP_QUERY_ETAG: u32 = 54u32;
pub const WINHTTP_QUERY_EXPECT: u32 = 68u32;
pub const WINHTTP_QUERY_EXPIRES: u32 = 10u32;
pub const WINHTTP_QUERY_EX_ALL_HEADERS: u32 = 21u32;
pub const WINHTTP_QUERY_FLAG_NUMBER: u32 = 536870912u32;
pub const WINHTTP_QUERY_FLAG_NUMBER64: u32 = 134217728u32;
pub const WINHTTP_QUERY_FLAG_REQUEST_HEADERS: u32 = 2147483648u32;
pub const WINHTTP_QUERY_FLAG_SYSTEMTIME: u32 = 1073741824u32;
pub const WINHTTP_QUERY_FLAG_TRAILERS: u32 = 33554432u32;
pub const WINHTTP_QUERY_FLAG_WIRE_ENCODING: u32 = 16777216u32;
pub const WINHTTP_QUERY_FORWARDED: u32 = 30u32;
pub const WINHTTP_QUERY_FROM: u32 = 31u32;
pub const WINHTTP_QUERY_HOST: u32 = 55u32;
pub const WINHTTP_QUERY_IF_MATCH: u32 = 56u32;
pub const WINHTTP_QUERY_IF_MODIFIED_SINCE: u32 = 32u32;
pub const WINHTTP_QUERY_IF_NONE_MATCH: u32 = 57u32;
pub const WINHTTP_QUERY_IF_RANGE: u32 = 58u32;
pub const WINHTTP_QUERY_IF_UNMODIFIED_SINCE: u32 = 59u32;
pub const WINHTTP_QUERY_LAST_MODIFIED: u32 = 11u32;
pub const WINHTTP_QUERY_LINK: u32 = 16u32;
pub const WINHTTP_QUERY_LOCATION: u32 = 33u32;
pub const WINHTTP_QUERY_MAX: u32 = 78u32;
pub const WINHTTP_QUERY_MAX_FORWARDS: u32 = 60u32;
pub const WINHTTP_QUERY_MESSAGE_ID: u32 = 12u32;
pub const WINHTTP_QUERY_MIME_VERSION: u32 = 0u32;
pub const WINHTTP_QUERY_ORIG_URI: u32 = 34u32;
pub const WINHTTP_QUERY_PASSPORT_CONFIG: u32 = 78u32;
pub const WINHTTP_QUERY_PASSPORT_URLS: u32 = 77u32;
pub const WINHTTP_QUERY_PRAGMA: u32 = 17u32;
pub const WINHTTP_QUERY_PROXY_AUTHENTICATE: u32 = 41u32;
pub const WINHTTP_QUERY_PROXY_AUTHORIZATION: u32 = 61u32;
pub const WINHTTP_QUERY_PROXY_CONNECTION: u32 = 69u32;
pub const WINHTTP_QUERY_PROXY_SUPPORT: u32 = 75u32;
pub const WINHTTP_QUERY_PUBLIC: u32 = 8u32;
pub const WINHTTP_QUERY_RANGE: u32 = 62u32;
pub const WINHTTP_QUERY_RAW_HEADERS: u32 = 21u32;
pub const WINHTTP_QUERY_RAW_HEADERS_CRLF: u32 = 22u32;
pub const WINHTTP_QUERY_REFERER: u32 = 35u32;
pub const WINHTTP_QUERY_REFRESH: u32 = 46u32;
pub const WINHTTP_QUERY_REQUEST_METHOD: u32 = 45u32;
pub const WINHTTP_QUERY_RETRY_AFTER: u32 = 36u32;
pub const WINHTTP_QUERY_SERVER: u32 = 37u32;
pub const WINHTTP_QUERY_SET_COOKIE: u32 = 43u32;
pub const WINHTTP_QUERY_STATUS_CODE: u32 = 19u32;
pub const WINHTTP_QUERY_STATUS_TEXT: u32 = 20u32;
pub const WINHTTP_QUERY_TITLE: u32 = 38u32;
pub const WINHTTP_QUERY_TRANSFER_ENCODING: u32 = 63u32;
pub const WINHTTP_QUERY_UNLESS_MODIFIED_SINCE: u32 = 70u32;
pub const WINHTTP_QUERY_UPGRADE: u32 = 64u32;
pub const WINHTTP_QUERY_URI: u32 = 13u32;
pub const WINHTTP_QUERY_USER_AGENT: u32 = 39u32;
pub const WINHTTP_QUERY_VARY: u32 = 65u32;
pub const WINHTTP_QUERY_VERSION: u32 = 18u32;
pub const WINHTTP_QUERY_VIA: u32 = 66u32;
pub const WINHTTP_QUERY_WARNING: u32 = 67u32;
pub const WINHTTP_QUERY_WWW_AUTHENTICATE: u32 = 40u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_REQUEST_STATS {
    pub ullFlags: u64,
    pub ulIndex: u32,
    pub cStats: u32,
    pub rgullStats: [u64; 32],
}
impl WINHTTP_REQUEST_STATS {}
impl ::std::default::Default for WINHTTP_REQUEST_STATS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_REQUEST_STATS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_REQUEST_STATS").field("ullFlags", &self.ullFlags).field("ulIndex", &self.ulIndex).field("cStats", &self.cStats).field("rgullStats", &self.rgullStats).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_REQUEST_STATS {
    fn eq(&self, other: &Self) -> bool {
        self.ullFlags == other.ullFlags && self.ulIndex == other.ulIndex && self.cStats == other.cStats && self.rgullStats == other.rgullStats
    }
}
impl ::std::cmp::Eq for WINHTTP_REQUEST_STATS {}
unsafe impl ::windows::runtime::Abi for WINHTTP_REQUEST_STATS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_REQUEST_STAT_ENTRY(pub i32);
pub const WinHttpConnectFailureCount: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(0i32);
pub const WinHttpProxyFailureCount: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(1i32);
pub const WinHttpTlsHandshakeClientLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(2i32);
pub const WinHttpTlsHandshakeServerLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(3i32);
pub const WinHttpTlsHandshakeClientLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(4i32);
pub const WinHttpTlsHandshakeServerLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(5i32);
pub const WinHttpRequestHeadersSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(6i32);
pub const WinHttpRequestHeadersCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(7i32);
pub const WinHttpResponseHeadersSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(8i32);
pub const WinHttpResponseHeadersCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(9i32);
pub const WinHttpResponseBodySize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(10i32);
pub const WinHttpResponseBodyCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(11i32);
pub const WinHttpProxyTlsHandshakeClientLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(12i32);
pub const WinHttpProxyTlsHandshakeServerLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(13i32);
pub const WinHttpProxyTlsHandshakeClientLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(14i32);
pub const WinHttpProxyTlsHandshakeServerLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(15i32);
pub const WinHttpRequestStatLast: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(16i32);
pub const WinHttpRequestStatMax: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(32i32);
impl ::std::convert::From<i32> for WINHTTP_REQUEST_STAT_ENTRY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_REQUEST_STAT_ENTRY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_REQUEST_STAT_FLAG_FIRST_REQUEST: u32 = 32u32;
pub const WINHTTP_REQUEST_STAT_FLAG_PROXY_TLS_FALSE_START: u32 = 16u32;
pub const WINHTTP_REQUEST_STAT_FLAG_PROXY_TLS_SESSION_RESUMPTION: u32 = 8u32;
pub const WINHTTP_REQUEST_STAT_FLAG_TCP_FAST_OPEN: u32 = 1u32;
pub const WINHTTP_REQUEST_STAT_FLAG_TLS_FALSE_START: u32 = 4u32;
pub const WINHTTP_REQUEST_STAT_FLAG_TLS_SESSION_RESUMPTION: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_REQUEST_TIMES {
    pub cTimes: u32,
    pub rgullTimes: [u64; 64],
}
impl WINHTTP_REQUEST_TIMES {}
impl ::std::default::Default for WINHTTP_REQUEST_TIMES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_REQUEST_TIMES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_REQUEST_TIMES").field("cTimes", &self.cTimes).field("rgullTimes", &self.rgullTimes).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_REQUEST_TIMES {
    fn eq(&self, other: &Self) -> bool {
        self.cTimes == other.cTimes && self.rgullTimes == other.rgullTimes
    }
}
impl ::std::cmp::Eq for WINHTTP_REQUEST_TIMES {}
unsafe impl ::windows::runtime::Abi for WINHTTP_REQUEST_TIMES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_REQUEST_TIME_ENTRY(pub i32);
pub const WinHttpProxyDetectionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(0i32);
pub const WinHttpProxyDetectionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(1i32);
pub const WinHttpConnectionAcquireStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(2i32);
pub const WinHttpConnectionAcquireWaitEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(3i32);
pub const WinHttpConnectionAcquireEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(4i32);
pub const WinHttpNameResolutionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(5i32);
pub const WinHttpNameResolutionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(6i32);
pub const WinHttpConnectionEstablishmentStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(7i32);
pub const WinHttpConnectionEstablishmentEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(8i32);
pub const WinHttpTlsHandshakeClientLeg1Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(9i32);
pub const WinHttpTlsHandshakeClientLeg1End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(10i32);
pub const WinHttpTlsHandshakeClientLeg2Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(11i32);
pub const WinHttpTlsHandshakeClientLeg2End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(12i32);
pub const WinHttpTlsHandshakeClientLeg3Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(13i32);
pub const WinHttpTlsHandshakeClientLeg3End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(14i32);
pub const WinHttpStreamWaitStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(15i32);
pub const WinHttpStreamWaitEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(16i32);
pub const WinHttpSendRequestStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(17i32);
pub const WinHttpSendRequestHeadersCompressionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(18i32);
pub const WinHttpSendRequestHeadersCompressionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(19i32);
pub const WinHttpSendRequestHeadersEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(20i32);
pub const WinHttpSendRequestEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(21i32);
pub const WinHttpReceiveResponseStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(22i32);
pub const WinHttpReceiveResponseHeadersDecompressionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(23i32);
pub const WinHttpReceiveResponseHeadersDecompressionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(24i32);
pub const WinHttpReceiveResponseHeadersEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(25i32);
pub const WinHttpReceiveResponseBodyDecompressionDelta: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(26i32);
pub const WinHttpReceiveResponseEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(27i32);
pub const WinHttpProxyTunnelStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(28i32);
pub const WinHttpProxyTunnelEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(29i32);
pub const WinHttpProxyTlsHandshakeClientLeg1Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(30i32);
pub const WinHttpProxyTlsHandshakeClientLeg1End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(31i32);
pub const WinHttpProxyTlsHandshakeClientLeg2Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(32i32);
pub const WinHttpProxyTlsHandshakeClientLeg2End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(33i32);
pub const WinHttpProxyTlsHandshakeClientLeg3Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(34i32);
pub const WinHttpProxyTlsHandshakeClientLeg3End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(35i32);
pub const WinHttpRequestTimeLast: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(36i32);
pub const WinHttpRequestTimeMax: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(64i32);
impl ::std::convert::From<i32> for WINHTTP_REQUEST_TIME_ENTRY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_REQUEST_TIME_ENTRY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_RESET_ALL: u32 = 65535u32;
pub const WINHTTP_RESET_DISCARD_RESOLVERS: u32 = 262144u32;
pub const WINHTTP_RESET_NOTIFY_NETWORK_CHANGED: u32 = 65536u32;
pub const WINHTTP_RESET_OUT_OF_PROC: u32 = 131072u32;
pub const WINHTTP_RESET_SCRIPT_CACHE: u32 = 8u32;
pub const WINHTTP_RESET_STATE: u32 = 1u32;
pub const WINHTTP_RESET_SWPAD_ALL: u32 = 4u32;
pub const WINHTTP_RESET_SWPAD_CURRENT_NETWORK: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_RESOLVER_CACHE_CONFIG {
    pub ulMaxResolverCacheEntries: u32,
    pub ulMaxCacheEntryAge: u32,
    pub ulMinCacheEntryTtl: u32,
    pub SecureDnsSetting: WINHTTP_SECURE_DNS_SETTING,
    pub ullConnResolutionWaitTime: u64,
    pub ullFlags: u64,
}
impl WINHTTP_RESOLVER_CACHE_CONFIG {}
impl ::std::default::Default for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_RESOLVER_CACHE_CONFIG")
            .field("ulMaxResolverCacheEntries", &self.ulMaxResolverCacheEntries)
            .field("ulMaxCacheEntryAge", &self.ulMaxCacheEntryAge)
            .field("ulMinCacheEntryTtl", &self.ulMinCacheEntryTtl)
            .field("SecureDnsSetting", &self.SecureDnsSetting)
            .field("ullConnResolutionWaitTime", &self.ullConnResolutionWaitTime)
            .field("ullFlags", &self.ullFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.ulMaxResolverCacheEntries == other.ulMaxResolverCacheEntries && self.ulMaxCacheEntryAge == other.ulMaxCacheEntryAge && self.ulMinCacheEntryTtl == other.ulMinCacheEntryTtl && self.SecureDnsSetting == other.SecureDnsSetting && self.ullConnResolutionWaitTime == other.ullConnResolutionWaitTime && self.ullFlags == other.ullFlags
    }
}
impl ::std::cmp::Eq for WINHTTP_RESOLVER_CACHE_CONFIG {}
unsafe impl ::windows::runtime::Abi for WINHTTP_RESOLVER_CACHE_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_BYPASS_CACHE: u32 = 2u32;
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_CONN_USE_TTL: u32 = 8u32;
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_SOFT_LIMIT: u32 = 1u32;
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_USE_DNS_TTL: u32 = 4u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_SECURE_DNS_SETTING(pub i32);
pub const WinHttpSecureDnsSettingDefault: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(0i32);
pub const WinHttpSecureDnsSettingForcePlaintext: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(1i32);
pub const WinHttpSecureDnsSettingRequireEncryption: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(2i32);
pub const WinHttpSecureDnsSettingTryEncryptionWithFallback: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(3i32);
pub const WinHttpSecureDnsSettingMax: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(4i32);
impl ::std::convert::From<i32> for WINHTTP_SECURE_DNS_SETTING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_SECURE_DNS_SETTING {
    type Abi = Self;
    type DefaultType = Self;
}
pub type WINHTTP_STATUS_CALLBACK = unsafe extern "system" fn(hinternet: *mut ::std::ffi::c_void, dwcontext: usize, dwinternetstatus: u32, lpvstatusinformation: *mut ::std::ffi::c_void, dwstatusinformationlength: u32);
pub const WINHTTP_TIME_FORMAT_BUFSIZE: u32 = 62u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    pub AsyncResult: WINHTTP_ASYNC_RESULT,
    pub Operation: WINHTTP_WEB_SOCKET_OPERATION,
}
impl WINHTTP_WEB_SOCKET_ASYNC_RESULT {}
impl ::std::default::Default for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_WEB_SOCKET_ASYNC_RESULT").field("AsyncResult", &self.AsyncResult).field("Operation", &self.Operation).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn eq(&self, other: &Self) -> bool {
        self.AsyncResult == other.AsyncResult && self.Operation == other.Operation
    }
}
impl ::std::cmp::Eq for WINHTTP_WEB_SOCKET_ASYNC_RESULT {}
unsafe impl ::windows::runtime::Abi for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_WEB_SOCKET_BUFFER_TYPE(pub i32);
pub const WINHTTP_WEB_SOCKET_BINARY_MESSAGE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(0i32);
pub const WINHTTP_WEB_SOCKET_BINARY_FRAGMENT_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(1i32);
pub const WINHTTP_WEB_SOCKET_UTF8_MESSAGE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(2i32);
pub const WINHTTP_WEB_SOCKET_UTF8_FRAGMENT_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(3i32);
pub const WINHTTP_WEB_SOCKET_CLOSE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(4i32);
impl ::std::convert::From<i32> for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_WEB_SOCKET_CLOSE_STATUS(pub i32);
pub const WINHTTP_WEB_SOCKET_SUCCESS_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1000i32);
pub const WINHTTP_WEB_SOCKET_ENDPOINT_TERMINATED_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1001i32);
pub const WINHTTP_WEB_SOCKET_PROTOCOL_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1002i32);
pub const WINHTTP_WEB_SOCKET_INVALID_DATA_TYPE_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1003i32);
pub const WINHTTP_WEB_SOCKET_EMPTY_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1005i32);
pub const WINHTTP_WEB_SOCKET_ABORTED_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1006i32);
pub const WINHTTP_WEB_SOCKET_INVALID_PAYLOAD_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1007i32);
pub const WINHTTP_WEB_SOCKET_POLICY_VIOLATION_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1008i32);
pub const WINHTTP_WEB_SOCKET_MESSAGE_TOO_BIG_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1009i32);
pub const WINHTTP_WEB_SOCKET_UNSUPPORTED_EXTENSIONS_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1010i32);
pub const WINHTTP_WEB_SOCKET_SERVER_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1011i32);
pub const WINHTTP_WEB_SOCKET_SECURE_HANDSHAKE_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1015i32);
impl ::std::convert::From<i32> for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WINHTTP_WEB_SOCKET_MAX_CLOSE_REASON_LENGTH: u32 = 123u32;
pub const WINHTTP_WEB_SOCKET_MIN_KEEPALIVE_VALUE: u32 = 15000u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WINHTTP_WEB_SOCKET_OPERATION(pub i32);
pub const WINHTTP_WEB_SOCKET_SEND_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(0i32);
pub const WINHTTP_WEB_SOCKET_RECEIVE_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(1i32);
pub const WINHTTP_WEB_SOCKET_CLOSE_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(2i32);
pub const WINHTTP_WEB_SOCKET_SHUTDOWN_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(3i32);
impl ::std::convert::From<i32> for WINHTTP_WEB_SOCKET_OPERATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WINHTTP_WEB_SOCKET_OPERATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WINHTTP_WEB_SOCKET_STATUS {
    pub dwBytesTransferred: u32,
    pub eBufferType: WINHTTP_WEB_SOCKET_BUFFER_TYPE,
}
impl WINHTTP_WEB_SOCKET_STATUS {}
impl ::std::default::Default for WINHTTP_WEB_SOCKET_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WINHTTP_WEB_SOCKET_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WINHTTP_WEB_SOCKET_STATUS").field("dwBytesTransferred", &self.dwBytesTransferred).field("eBufferType", &self.eBufferType).finish()
    }
}
impl ::std::cmp::PartialEq for WINHTTP_WEB_SOCKET_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.dwBytesTransferred == other.dwBytesTransferred && self.eBufferType == other.eBufferType
    }
}
impl ::std::cmp::Eq for WINHTTP_WEB_SOCKET_STATUS {}
unsafe impl ::windows::runtime::Abi for WINHTTP_WEB_SOCKET_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct WIN_HTTP_CREATE_URL_FLAGS(pub u32);
pub const ICU_ESCAPE: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(2147483648u32);
pub const ICU_REJECT_USERPWD: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(16384u32);
pub const ICU_DECODE: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(268435456u32);
impl ::std::convert::From<u32> for WIN_HTTP_CREATE_URL_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WIN_HTTP_CREATE_URL_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for WIN_HTTP_CREATE_URL_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for WIN_HTTP_CREATE_URL_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for WIN_HTTP_CREATE_URL_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for WIN_HTTP_CREATE_URL_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for WIN_HTTP_CREATE_URL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpAddRequestHeaders<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hrequest: *mut ::std::ffi::c_void, lpszheaders: Param1, dwheaderslength: u32, dwmodifiers: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpAddRequestHeaders(hrequest: *mut ::std::ffi::c_void, lpszheaders: super::super::Foundation::PWSTR, dwheaderslength: u32, dwmodifiers: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpAddRequestHeaders(::std::mem::transmute(hrequest), lpszheaders.into_param().abi(), ::std::mem::transmute(dwheaderslength), ::std::mem::transmute(dwmodifiers)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpAddRequestHeadersEx(hrequest: *mut ::std::ffi::c_void, dwmodifiers: u32, ullflags: u64, ullextra: u64, cheaders: u32, pheaders: *const WINHTTP_EXTENDED_HEADER) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpAddRequestHeadersEx(hrequest: *mut ::std::ffi::c_void, dwmodifiers: u32, ullflags: u64, ullextra: u64, cheaders: u32, pheaders: *const WINHTTP_EXTENDED_HEADER) -> u32;
        }
        ::std::mem::transmute(WinHttpAddRequestHeadersEx(::std::mem::transmute(hrequest), ::std::mem::transmute(dwmodifiers), ::std::mem::transmute(ullflags), ::std::mem::transmute(ullextra), ::std::mem::transmute(cheaders), ::std::mem::transmute(pheaders)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCheckPlatform() -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpCheckPlatform() -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpCheckPlatform())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCloseHandle(hinternet: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpCloseHandle(hinternet: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpCloseHandle(::std::mem::transmute(hinternet)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpConnect<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hsession: *mut ::std::ffi::c_void, pswzservername: Param1, nserverport: INTERNET_PORT, dwreserved: u32) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpConnect(hsession: *mut ::std::ffi::c_void, pswzservername: super::super::Foundation::PWSTR, nserverport: INTERNET_PORT, dwreserved: u32) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(WinHttpConnect(::std::mem::transmute(hsession), pswzservername.into_param().abi(), ::std::mem::transmute(nserverport), ::std::mem::transmute(dwreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCrackUrl<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pwszurl: Param0, dwurllength: u32, dwflags: u32, lpurlcomponents: *mut URL_COMPONENTS) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpCrackUrl(pwszurl: super::super::Foundation::PWSTR, dwurllength: u32, dwflags: u32, lpurlcomponents: *mut URL_COMPONENTS) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpCrackUrl(pwszurl.into_param().abi(), ::std::mem::transmute(dwurllength), ::std::mem::transmute(dwflags), ::std::mem::transmute(lpurlcomponents)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpCreateProxyResolver(hsession: *const ::std::ffi::c_void, phresolver: *mut *mut ::std::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpCreateProxyResolver(hsession: *const ::std::ffi::c_void, phresolver: *mut *mut ::std::ffi::c_void) -> u32;
        }
        ::std::mem::transmute(WinHttpCreateProxyResolver(::std::mem::transmute(hsession), ::std::mem::transmute(phresolver)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCreateUrl(lpurlcomponents: *const URL_COMPONENTS, dwflags: WIN_HTTP_CREATE_URL_FLAGS, pwszurl: super::super::Foundation::PWSTR, pdwurllength: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpCreateUrl(lpurlcomponents: *const URL_COMPONENTS, dwflags: WIN_HTTP_CREATE_URL_FLAGS, pwszurl: super::super::Foundation::PWSTR, pdwurllength: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpCreateUrl(::std::mem::transmute(lpurlcomponents), ::std::mem::transmute(dwflags), ::std::mem::transmute(pwszurl), ::std::mem::transmute(pdwurllength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpDetectAutoProxyConfigUrl(dwautodetectflags: u32, ppwstrautoconfigurl: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpDetectAutoProxyConfigUrl(dwautodetectflags: u32, ppwstrautoconfigurl: *mut super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpDetectAutoProxyConfigUrl(::std::mem::transmute(dwautodetectflags), ::std::mem::transmute(ppwstrautoconfigurl)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxyResult(pproxyresult: *mut WINHTTP_PROXY_RESULT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpFreeProxyResult(pproxyresult: *mut WINHTTP_PROXY_RESULT);
        }
        ::std::mem::transmute(WinHttpFreeProxyResult(::std::mem::transmute(pproxyresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxyResultEx(pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpFreeProxyResultEx(pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX);
        }
        ::std::mem::transmute(WinHttpFreeProxyResultEx(::std::mem::transmute(pproxyresultex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxySettings(pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpFreeProxySettings(pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS);
        }
        ::std::mem::transmute(WinHttpFreeProxySettings(::std::mem::transmute(pwinhttpproxysettings)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeQueryConnectionGroupResult(presult: *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpFreeQueryConnectionGroupResult(presult: *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT);
        }
        ::std::mem::transmute(WinHttpFreeQueryConnectionGroupResult(::std::mem::transmute(presult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpGetDefaultProxyConfiguration(::std::mem::transmute(pproxyinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetIEProxyConfigForCurrentUser(pproxyconfig: *mut WINHTTP_CURRENT_USER_IE_PROXY_CONFIG) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetIEProxyConfigForCurrentUser(pproxyconfig: *mut WINHTTP_CURRENT_USER_IE_PROXY_CONFIG) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpGetIEProxyConfigForCurrentUser(::std::mem::transmute(pproxyconfig)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrl<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hsession: *mut ::std::ffi::c_void, lpcwszurl: Param1, pautoproxyoptions: *mut WINHTTP_AUTOPROXY_OPTIONS, pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxyForUrl(hsession: *mut ::std::ffi::c_void, lpcwszurl: super::super::Foundation::PWSTR, pautoproxyoptions: *mut WINHTTP_AUTOPROXY_OPTIONS, pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpGetProxyForUrl(::std::mem::transmute(hsession), lpcwszurl.into_param().abi(), ::std::mem::transmute(pautoproxyoptions), ::std::mem::transmute(pproxyinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrlEx<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hresolver: *const ::std::ffi::c_void, pcwszurl: Param1, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, pcontext: usize) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxyForUrlEx(hresolver: *const ::std::ffi::c_void, pcwszurl: super::super::Foundation::PWSTR, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, pcontext: usize) -> u32;
        }
        ::std::mem::transmute(WinHttpGetProxyForUrlEx(::std::mem::transmute(hresolver), pcwszurl.into_param().abi(), ::std::mem::transmute(pautoproxyoptions), ::std::mem::transmute(pcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrlEx2<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hresolver: *const ::std::ffi::c_void, pcwszurl: Param1, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, cbinterfaceselectioncontext: u32, pinterfaceselectioncontext: *const u8, pcontext: usize) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxyForUrlEx2(hresolver: *const ::std::ffi::c_void, pcwszurl: super::super::Foundation::PWSTR, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, cbinterfaceselectioncontext: u32, pinterfaceselectioncontext: *const u8, pcontext: usize) -> u32;
        }
        ::std::mem::transmute(WinHttpGetProxyForUrlEx2(::std::mem::transmute(hresolver), pcwszurl.into_param().abi(), ::std::mem::transmute(pautoproxyoptions), ::std::mem::transmute(cbinterfaceselectioncontext), ::std::mem::transmute(pinterfaceselectioncontext), ::std::mem::transmute(pcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyResult(hresolver: *const ::std::ffi::c_void, pproxyresult: *mut WINHTTP_PROXY_RESULT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxyResult(hresolver: *const ::std::ffi::c_void, pproxyresult: *mut WINHTTP_PROXY_RESULT) -> u32;
        }
        ::std::mem::transmute(WinHttpGetProxyResult(::std::mem::transmute(hresolver), ::std::mem::transmute(pproxyresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyResultEx(hresolver: *const ::std::ffi::c_void, pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxyResultEx(hresolver: *const ::std::ffi::c_void, pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) -> u32;
        }
        ::std::mem::transmute(WinHttpGetProxyResultEx(::std::mem::transmute(hresolver), ::std::mem::transmute(pproxyresultex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpGetProxySettingsVersion(hsession: *const ::std::ffi::c_void, pdwproxysettingsversion: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpGetProxySettingsVersion(hsession: *const ::std::ffi::c_void, pdwproxysettingsversion: *mut u32) -> u32;
        }
        ::std::mem::transmute(WinHttpGetProxySettingsVersion(::std::mem::transmute(hsession), ::std::mem::transmute(pdwproxysettingsversion)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpOpen<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pszagentw: Param0, dwaccesstype: WINHTTP_ACCESS_TYPE, pszproxyw: Param2, pszproxybypassw: Param3, dwflags: u32) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpOpen(pszagentw: super::super::Foundation::PWSTR, dwaccesstype: WINHTTP_ACCESS_TYPE, pszproxyw: super::super::Foundation::PWSTR, pszproxybypassw: super::super::Foundation::PWSTR, dwflags: u32) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(WinHttpOpen(pszagentw.into_param().abi(), ::std::mem::transmute(dwaccesstype), pszproxyw.into_param().abi(), pszproxybypassw.into_param().abi(), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpOpenRequest<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(
    hconnect: *mut ::std::ffi::c_void,
    pwszverb: Param1,
    pwszobjectname: Param2,
    pwszversion: Param3,
    pwszreferrer: Param4,
    ppwszaccepttypes: *mut super::super::Foundation::PWSTR,
    dwflags: WINHTTP_OPEN_REQUEST_FLAGS,
) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpOpenRequest(hconnect: *mut ::std::ffi::c_void, pwszverb: super::super::Foundation::PWSTR, pwszobjectname: super::super::Foundation::PWSTR, pwszversion: super::super::Foundation::PWSTR, pwszreferrer: super::super::Foundation::PWSTR, ppwszaccepttypes: *mut super::super::Foundation::PWSTR, dwflags: WINHTTP_OPEN_REQUEST_FLAGS) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(WinHttpOpenRequest(::std::mem::transmute(hconnect), pwszverb.into_param().abi(), pwszobjectname.into_param().abi(), pwszversion.into_param().abi(), pwszreferrer.into_param().abi(), ::std::mem::transmute(ppwszaccepttypes), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryAuthSchemes(hrequest: *mut ::std::ffi::c_void, lpdwsupportedschemes: *mut u32, lpdwfirstscheme: *mut u32, pdwauthtarget: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryAuthSchemes(hrequest: *mut ::std::ffi::c_void, lpdwsupportedschemes: *mut u32, lpdwfirstscheme: *mut u32, pdwauthtarget: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpQueryAuthSchemes(::std::mem::transmute(hrequest), ::std::mem::transmute(lpdwsupportedschemes), ::std::mem::transmute(lpdwfirstscheme), ::std::mem::transmute(pdwauthtarget)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryConnectionGroup(hinternet: *const ::std::ffi::c_void, pguidconnection: *const ::windows::runtime::GUID, ullflags: u64, ppresult: *mut *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryConnectionGroup(hinternet: *const ::std::ffi::c_void, pguidconnection: *const ::windows::runtime::GUID, ullflags: u64, ppresult: *mut *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) -> u32;
        }
        ::std::mem::transmute(WinHttpQueryConnectionGroup(::std::mem::transmute(hinternet), ::std::mem::transmute(pguidconnection), ::std::mem::transmute(ullflags), ::std::mem::transmute(ppresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryDataAvailable(hrequest: *mut ::std::ffi::c_void, lpdwnumberofbytesavailable: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryDataAvailable(hrequest: *mut ::std::ffi::c_void, lpdwnumberofbytesavailable: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpQueryDataAvailable(::std::mem::transmute(hrequest), ::std::mem::transmute(lpdwnumberofbytesavailable)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryHeaders<'a, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hrequest: *mut ::std::ffi::c_void, dwinfolevel: u32, pwszname: Param2, lpbuffer: *mut ::std::ffi::c_void, lpdwbufferlength: *mut u32, lpdwindex: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryHeaders(hrequest: *mut ::std::ffi::c_void, dwinfolevel: u32, pwszname: super::super::Foundation::PWSTR, lpbuffer: *mut ::std::ffi::c_void, lpdwbufferlength: *mut u32, lpdwindex: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpQueryHeaders(::std::mem::transmute(hrequest), ::std::mem::transmute(dwinfolevel), pwszname.into_param().abi(), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(lpdwbufferlength), ::std::mem::transmute(lpdwindex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryHeadersEx(hrequest: *const ::std::ffi::c_void, dwinfolevel: u32, ullflags: u64, uicodepage: u32, pdwindex: *mut u32, pheadername: *const WINHTTP_HEADER_NAME, pbuffer: *mut ::std::ffi::c_void, pdwbufferlength: *mut u32, ppheaders: *mut *mut WINHTTP_EXTENDED_HEADER, pdwheaderscount: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryHeadersEx(hrequest: *const ::std::ffi::c_void, dwinfolevel: u32, ullflags: u64, uicodepage: u32, pdwindex: *mut u32, pheadername: *const WINHTTP_HEADER_NAME, pbuffer: *mut ::std::ffi::c_void, pdwbufferlength: *mut u32, ppheaders: *mut *mut WINHTTP_EXTENDED_HEADER, pdwheaderscount: *mut u32) -> u32;
        }
        ::std::mem::transmute(WinHttpQueryHeadersEx(
            ::std::mem::transmute(hrequest),
            ::std::mem::transmute(dwinfolevel),
            ::std::mem::transmute(ullflags),
            ::std::mem::transmute(uicodepage),
            ::std::mem::transmute(pdwindex),
            ::std::mem::transmute(pheadername),
            ::std::mem::transmute(pbuffer),
            ::std::mem::transmute(pdwbufferlength),
            ::std::mem::transmute(ppheaders),
            ::std::mem::transmute(pdwheaderscount),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryOption(hinternet: *mut ::std::ffi::c_void, dwoption: u32, lpbuffer: *mut ::std::ffi::c_void, lpdwbufferlength: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpQueryOption(hinternet: *mut ::std::ffi::c_void, dwoption: u32, lpbuffer: *mut ::std::ffi::c_void, lpdwbufferlength: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpQueryOption(::std::mem::transmute(hinternet), ::std::mem::transmute(dwoption), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(lpdwbufferlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReadData(hrequest: *mut ::std::ffi::c_void, lpbuffer: *mut ::std::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpReadData(hrequest: *mut ::std::ffi::c_void, lpbuffer: *mut ::std::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpReadData(::std::mem::transmute(hrequest), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(dwnumberofbytestoread), ::std::mem::transmute(lpdwnumberofbytesread)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpReadDataEx(hrequest: *mut ::std::ffi::c_void, lpbuffer: *mut ::std::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32, ullflags: u64, cbproperty: u32, pvproperty: *const ::std::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpReadDataEx(hrequest: *mut ::std::ffi::c_void, lpbuffer: *mut ::std::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32, ullflags: u64, cbproperty: u32, pvproperty: *const ::std::ffi::c_void) -> u32;
        }
        ::std::mem::transmute(WinHttpReadDataEx(::std::mem::transmute(hrequest), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(dwnumberofbytestoread), ::std::mem::transmute(lpdwnumberofbytesread), ::std::mem::transmute(ullflags), ::std::mem::transmute(cbproperty), ::std::mem::transmute(pvproperty)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReadProxySettings<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(
    hsession: *const ::std::ffi::c_void,
    pcwszconnectionname: Param1,
    ffallbacktodefaultsettings: Param2,
    fsetautodiscoverfordefaultsettings: Param3,
    pdwsettingsversion: *mut u32,
    pfdefaultsettingsarereturned: *mut super::super::Foundation::BOOL,
    pwinhttpproxysettings: *mut WINHTTP_PROXY_SETTINGS,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpReadProxySettings(hsession: *const ::std::ffi::c_void, pcwszconnectionname: super::super::Foundation::PWSTR, ffallbacktodefaultsettings: super::super::Foundation::BOOL, fsetautodiscoverfordefaultsettings: super::super::Foundation::BOOL, pdwsettingsversion: *mut u32, pfdefaultsettingsarereturned: *mut super::super::Foundation::BOOL, pwinhttpproxysettings: *mut WINHTTP_PROXY_SETTINGS) -> u32;
        }
        ::std::mem::transmute(WinHttpReadProxySettings(
            ::std::mem::transmute(hsession),
            pcwszconnectionname.into_param().abi(),
            ffallbacktodefaultsettings.into_param().abi(),
            fsetautodiscoverfordefaultsettings.into_param().abi(),
            ::std::mem::transmute(pdwsettingsversion),
            ::std::mem::transmute(pfdefaultsettingsarereturned),
            ::std::mem::transmute(pwinhttpproxysettings),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReceiveResponse(hrequest: *mut ::std::ffi::c_void, lpreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpReceiveResponse(hrequest: *mut ::std::ffi::c_void, lpreserved: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpReceiveResponse(::std::mem::transmute(hrequest), ::std::mem::transmute(lpreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpResetAutoProxy(hsession: *const ::std::ffi::c_void, dwflags: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpResetAutoProxy(hsession: *const ::std::ffi::c_void, dwflags: u32) -> u32;
        }
        ::std::mem::transmute(WinHttpResetAutoProxy(::std::mem::transmute(hsession), ::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSendRequest<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hrequest: *mut ::std::ffi::c_void, lpszheaders: Param1, dwheaderslength: u32, lpoptional: *const ::std::ffi::c_void, dwoptionallength: u32, dwtotallength: u32, dwcontext: usize) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSendRequest(hrequest: *mut ::std::ffi::c_void, lpszheaders: super::super::Foundation::PWSTR, dwheaderslength: u32, lpoptional: *const ::std::ffi::c_void, dwoptionallength: u32, dwtotallength: u32, dwcontext: usize) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpSendRequest(::std::mem::transmute(hrequest), lpszheaders.into_param().abi(), ::std::mem::transmute(dwheaderslength), ::std::mem::transmute(lpoptional), ::std::mem::transmute(dwoptionallength), ::std::mem::transmute(dwtotallength), ::std::mem::transmute(dwcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetCredentials<'a, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(hrequest: *mut ::std::ffi::c_void, authtargets: u32, authscheme: u32, pwszusername: Param3, pwszpassword: Param4, pauthparams: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetCredentials(hrequest: *mut ::std::ffi::c_void, authtargets: u32, authscheme: u32, pwszusername: super::super::Foundation::PWSTR, pwszpassword: super::super::Foundation::PWSTR, pauthparams: *mut ::std::ffi::c_void) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpSetCredentials(::std::mem::transmute(hrequest), ::std::mem::transmute(authtargets), ::std::mem::transmute(authscheme), pwszusername.into_param().abi(), pwszpassword.into_param().abi(), ::std::mem::transmute(pauthparams)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpSetDefaultProxyConfiguration(::std::mem::transmute(pproxyinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetOption(hinternet: *const ::std::ffi::c_void, dwoption: u32, lpbuffer: *const ::std::ffi::c_void, dwbufferlength: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetOption(hinternet: *const ::std::ffi::c_void, dwoption: u32, lpbuffer: *const ::std::ffi::c_void, dwbufferlength: u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpSetOption(::std::mem::transmute(hinternet), ::std::mem::transmute(dwoption), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(dwbufferlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetProxySettingsPerUser<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(fproxysettingsperuser: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetProxySettingsPerUser(fproxysettingsperuser: super::super::Foundation::BOOL) -> u32;
        }
        ::std::mem::transmute(WinHttpSetProxySettingsPerUser(fproxysettingsperuser.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpSetStatusCallback(hinternet: *mut ::std::ffi::c_void, lpfninternetcallback: ::std::option::Option<WINHTTP_STATUS_CALLBACK>, dwnotificationflags: u32, dwreserved: usize) -> ::std::option::Option<WINHTTP_STATUS_CALLBACK> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetStatusCallback(hinternet: *mut ::std::ffi::c_void, lpfninternetcallback: ::windows::runtime::RawPtr, dwnotificationflags: u32, dwreserved: usize) -> ::std::option::Option<WINHTTP_STATUS_CALLBACK>;
        }
        ::std::mem::transmute(WinHttpSetStatusCallback(::std::mem::transmute(hinternet), ::std::mem::transmute(lpfninternetcallback), ::std::mem::transmute(dwnotificationflags), ::std::mem::transmute(dwreserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetTimeouts(hinternet: *mut ::std::ffi::c_void, nresolvetimeout: i32, nconnecttimeout: i32, nsendtimeout: i32, nreceivetimeout: i32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpSetTimeouts(hinternet: *mut ::std::ffi::c_void, nresolvetimeout: i32, nconnecttimeout: i32, nsendtimeout: i32, nreceivetimeout: i32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpSetTimeouts(::std::mem::transmute(hinternet), ::std::mem::transmute(nresolvetimeout), ::std::mem::transmute(nconnecttimeout), ::std::mem::transmute(nsendtimeout), ::std::mem::transmute(nreceivetimeout)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpTimeFromSystemTime(pst: *const super::super::Foundation::SYSTEMTIME, pwsztime: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpTimeFromSystemTime(pst: *const super::super::Foundation::SYSTEMTIME, pwsztime: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpTimeFromSystemTime(::std::mem::transmute(pst), ::std::mem::transmute(pwsztime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpTimeToSystemTime<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(pwsztime: Param0, pst: *mut super::super::Foundation::SYSTEMTIME) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpTimeToSystemTime(pwsztime: super::super::Foundation::PWSTR, pst: *mut super::super::Foundation::SYSTEMTIME) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpTimeToSystemTime(pwsztime.into_param().abi(), ::std::mem::transmute(pst)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketClose(hwebsocket: *const ::std::ffi::c_void, usstatus: u16, pvreason: *const ::std::ffi::c_void, dwreasonlength: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketClose(hwebsocket: *const ::std::ffi::c_void, usstatus: u16, pvreason: *const ::std::ffi::c_void, dwreasonlength: u32) -> u32;
        }
        ::std::mem::transmute(WinHttpWebSocketClose(::std::mem::transmute(hwebsocket), ::std::mem::transmute(usstatus), ::std::mem::transmute(pvreason), ::std::mem::transmute(dwreasonlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketCompleteUpgrade(hrequest: *const ::std::ffi::c_void, pcontext: usize) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketCompleteUpgrade(hrequest: *const ::std::ffi::c_void, pcontext: usize) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(WinHttpWebSocketCompleteUpgrade(::std::mem::transmute(hrequest), ::std::mem::transmute(pcontext)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketQueryCloseStatus(hwebsocket: *const ::std::ffi::c_void, pusstatus: *mut u16, pvreason: *mut ::std::ffi::c_void, dwreasonlength: u32, pdwreasonlengthconsumed: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketQueryCloseStatus(hwebsocket: *const ::std::ffi::c_void, pusstatus: *mut u16, pvreason: *mut ::std::ffi::c_void, dwreasonlength: u32, pdwreasonlengthconsumed: *mut u32) -> u32;
        }
        ::std::mem::transmute(WinHttpWebSocketQueryCloseStatus(::std::mem::transmute(hwebsocket), ::std::mem::transmute(pusstatus), ::std::mem::transmute(pvreason), ::std::mem::transmute(dwreasonlength), ::std::mem::transmute(pdwreasonlengthconsumed)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketReceive(hwebsocket: *const ::std::ffi::c_void, pvbuffer: *mut ::std::ffi::c_void, dwbufferlength: u32, pdwbytesread: *mut u32, pebuffertype: *mut WINHTTP_WEB_SOCKET_BUFFER_TYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketReceive(hwebsocket: *const ::std::ffi::c_void, pvbuffer: *mut ::std::ffi::c_void, dwbufferlength: u32, pdwbytesread: *mut u32, pebuffertype: *mut WINHTTP_WEB_SOCKET_BUFFER_TYPE) -> u32;
        }
        ::std::mem::transmute(WinHttpWebSocketReceive(::std::mem::transmute(hwebsocket), ::std::mem::transmute(pvbuffer), ::std::mem::transmute(dwbufferlength), ::std::mem::transmute(pdwbytesread), ::std::mem::transmute(pebuffertype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketSend(hwebsocket: *const ::std::ffi::c_void, ebuffertype: WINHTTP_WEB_SOCKET_BUFFER_TYPE, pvbuffer: *const ::std::ffi::c_void, dwbufferlength: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketSend(hwebsocket: *const ::std::ffi::c_void, ebuffertype: WINHTTP_WEB_SOCKET_BUFFER_TYPE, pvbuffer: *const ::std::ffi::c_void, dwbufferlength: u32) -> u32;
        }
        ::std::mem::transmute(WinHttpWebSocketSend(::std::mem::transmute(hwebsocket), ::std::mem::transmute(ebuffertype), ::std::mem::transmute(pvbuffer), ::std::mem::transmute(dwbufferlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn WinHttpWebSocketShutdown(hwebsocket: *const ::std::ffi::c_void, usstatus: u16, pvreason: *const ::std::ffi::c_void, dwreasonlength: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWebSocketShutdown(hwebsocket: *const ::std::ffi::c_void, usstatus: u16, pvreason: *const ::std::ffi::c_void, dwreasonlength: u32) -> u32;
        }
        ::std::mem::transmute(WinHttpWebSocketShutdown(::std::mem::transmute(hwebsocket), ::std::mem::transmute(usstatus), ::std::mem::transmute(pvreason), ::std::mem::transmute(dwreasonlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpWriteData(hrequest: *mut ::std::ffi::c_void, lpbuffer: *const ::std::ffi::c_void, dwnumberofbytestowrite: u32, lpdwnumberofbyteswritten: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWriteData(hrequest: *mut ::std::ffi::c_void, lpbuffer: *const ::std::ffi::c_void, dwnumberofbytestowrite: u32, lpdwnumberofbyteswritten: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(WinHttpWriteData(::std::mem::transmute(hrequest), ::std::mem::transmute(lpbuffer), ::std::mem::transmute(dwnumberofbytestowrite), ::std::mem::transmute(lpdwnumberofbyteswritten)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpWriteProxySettings<'a, Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(hsession: *const ::std::ffi::c_void, fforceupdate: Param1, pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WinHttpWriteProxySettings(hsession: *const ::std::ffi::c_void, fforceupdate: super::super::Foundation::BOOL, pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) -> u32;
        }
        ::std::mem::transmute(WinHttpWriteProxySettings(::std::mem::transmute(hsession), fforceupdate.into_param().abi(), ::std::mem::transmute(pwinhttpproxysettings)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct _WinHttpProxyNetworkKey {
    pub pbBuffer: [u8; 128],
}
impl _WinHttpProxyNetworkKey {}
impl ::std::default::Default for _WinHttpProxyNetworkKey {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for _WinHttpProxyNetworkKey {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_WinHttpProxyNetworkKey").field("pbBuffer", &self.pbBuffer).finish()
    }
}
impl ::std::cmp::PartialEq for _WinHttpProxyNetworkKey {
    fn eq(&self, other: &Self) -> bool {
        self.pbBuffer == other.pbBuffer
    }
}
impl ::std::cmp::Eq for _WinHttpProxyNetworkKey {}
unsafe impl ::windows::runtime::Abi for _WinHttpProxyNetworkKey {
    type Abi = Self;
    type DefaultType = Self;
}
